
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  446),  selected   56 , name 2onq_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 2onq_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      T       1          1.241
LGA    Q     2_A      T       2          1.082
LGA    F     3_A      Y       3          0.518
LGA    K     4_A      K       4          0.253
LGA    L     5_A      L       5          0.354
LGA    I     6_A      I       6          0.829
LGA    I     7_A      L       7          0.978
LGA    N     8_A      N       8          1.351
LGA    G     9_A      L       9          1.342
LGA    K    10_A      K      10          1.316
LGA    T    11_A      Q      11          3.064
LGA    L    12_A      A      12          2.389
LGA    K    13_A      K      13          0.405
LGA    G    14_A      E      14          2.658
LGA    E    15_A      E      15          1.695
LGA    I    16_A      A      16          2.102
LGA    T    17_A      I      17          1.716
LGA    I    18_A      K      18          1.064
LGA    E    19_A      E      19          0.772
LGA    A    20_A      A      20          1.600
LGA    V    21_A      V      21          1.632
LGA    D    22_A      D      22          1.219
LGA    A    23_A      A      23          1.743
LGA    A    24_A      G      24          2.109
LGA    E    25_A      T      25          1.577
LGA    A    26_A      A      26          0.562
LGA    E    27_A      E      27          0.781
LGA    K    28_A      K      28          0.682
LGA    F    29_A      Y      29          0.809
LGA    F    30_A      F      30          0.990
LGA    K    31_A      K      31          0.995
LGA    Q    32_A      L      32          1.042
LGA    Y    33_A      I      33          0.842
LGA    A    34_A      A      34          1.401
LGA    N    35_A      N      35          1.514
LGA    D    36_A      A      36          0.953
LGA    N    37_A      K      37          1.168
LGA    G    38_A      T      38          2.405
LGA    I    39_A      V      39          3.227
LGA    D    40_A      E      40          1.551
LGA    G    41_A      G      41          1.177
LGA    E    42_A      V      42          0.844
LGA    W    43_A      W      43          0.630
LGA    T    44_A      T      44          0.723
LGA    Y    45_A      Y      45          1.186
LGA    D    46_A      K      46          1.816
LGA    D    47_A      D      47          2.793
LGA    A    48_A      E      48          0.744
LGA    T    49_A      I      49          2.101
LGA    K    50_A      K      50          0.920
LGA    T    51_A      T      51          0.686
LGA    F    52_A      F      52          0.387
LGA    T    53_A      T      53          0.626
LGA    V    54_A      V      54          0.659
LGA    T    55_A      T      55          0.505
LGA    E    56_A      E      56          0.752

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   56    5.0     56    1.44    55.36     93.084     3.643

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.140190 * X  +  -0.384162 * Y  +  -0.912560 * Z  +  36.062946
  Y_new =   0.617215 * X  +   0.686765 * Y  +  -0.383927 * Z  + -15.986411
  Z_new =   0.774204 * X  +  -0.617069 * Y  +   0.140833 * Z  +   1.881673 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.346411    1.795182  [ DEG:   -77.1436    102.8564 ]
  Theta =  -0.885457   -2.256136  [ DEG:   -50.7329   -129.2671 ]
  Phi   =   1.794140   -1.347453  [ DEG:   102.7967    -77.2033 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2onq_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2onq_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   56   5.0   56   1.44   55.36  93.084
REMARK  ---------------------------------------------------------- 
MOLECULE 2onq_A
HEADER    PROTEIN BINDING                         24-JAN-07   2ONQ              
TITLE     GBETA1 STABILIZATION BY IN VITRO EVOLUTION AND                        
TITLE    2 COMPUTATIONAL DESIGN                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G-BINDING PROTEIN G;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 373-427;                                          
COMPND   5 SYNONYM: IGG-BINDING PROTEIN G;                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP.;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: G148;                                                        
SOURCE   5 GENE: SPG;                                                           
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    BETA SHEET, ALPHA HELIX, IMPROVED HYDROPHOBIC PACKING OF              
KEYWDS   2 CORE RESIDUES, PROTEIN BINDING                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.E.A.MAX,U.HEINEMANN                                                 
REVDAT   1   08-JAN-08 2ONQ    0                                                
JRNL        AUTH   M.WUNDERLICH,K.E.MAX,Y.ROSKE,U.MUELLER,U.HEINEMANN,          
JRNL        AUTH 2 F.X.SCHMID                                                   
JRNL        TITL   OPTIMIZATION OF THE GBETA1 DOMAIN BY COMPUTATIONAL           
JRNL        TITL 2 DESIGN AND BY IN VITRO EVOLUTION: STRUCTURAL AND             
JRNL        TITL 3 ENERGETIC BASIS OF STABILIZATION.                            
JRNL        REF    J.MOL.BIOL.                   V. 373   775 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2ONQ A    2    56  UNP    P19909   SPG2_STRSG     373    427             
SEQRES   1 A   56  MET GLN PHE LYS LEU ILE ILE ASN GLY LYS THR LEU LYS          
SEQRES   2 A   56  GLY GLU ILE THR ILE GLU ALA VAL ASP ALA ALA GLU ALA          
SEQRES   3 A   56  GLU LYS PHE PHE LYS GLN TYR ALA ASN ASP ASN GLY ILE          
SEQRES   4 A   56  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 A   56  THR VAL THR GLU                                              
FORMUL   2  HOH   *34(H2 O)                                                     
CRYST1   48.412   48.412  107.332  90.00  90.00 120.00 H 3 2        18          
ATOM      1  N   MET A   1       5.762 -12.544   5.026  1.00 57.78           N  
ATOM      2  CA  MET A   1       6.157 -12.591   3.596  1.00 59.74           C  
ATOM      3  C   MET A   1       6.197 -11.151   3.073  1.00 51.14           C  
ATOM      4  O   MET A   1       5.910 -10.233   3.826  1.00 48.91           O  
ATOM      5  CB  MET A   1       5.111 -13.420   2.833  1.00 61.25           C  
ATOM      6  CG  MET A   1       3.757 -12.856   2.987  1.00 54.04           C  
ATOM      7  SD  MET A   1       2.490 -14.127   3.054  1.00 71.11           S  
ATOM      8  CE  MET A   1       2.627 -14.686   4.750  0.01 69.51           C  
ATOM      9  N   GLN A   2       6.518 -10.961   1.794  1.00 47.22           N  
ATOM     10  CA  GLN A   2       6.600  -9.630   1.207  1.00 42.40           C  
ATOM     11  C   GLN A   2       5.214  -9.142   0.749  1.00 33.69           C  
ATOM     12  O   GLN A   2       4.523  -9.845  -0.000  1.00 34.12           O  
ATOM     13  CB  GLN A   2       7.578  -9.631   0.013  1.00 46.61           C  
ATOM     14  CG  GLN A   2       7.947  -8.252  -0.566  1.00 50.20           C  
ATOM     15  CD  GLN A   2       8.764  -8.324  -1.883  1.00 49.49           C  
ATOM     16  OE1 GLN A   2       8.150  -8.514  -2.977  1.00 51.25           O  
ATOM     17  NE2 GLN A   2      10.015  -8.154  -1.815  1.00 59.93           N  
ATOM     18  N   PHE A   3       4.833  -7.932   1.178  1.00 27.55           N  
ATOM     19  CA  PHE A   3       3.560  -7.303   0.765  1.00 25.38           C  
ATOM     20  C   PHE A   3       3.885  -6.091  -0.058  1.00 21.55           C  
ATOM     21  O   PHE A   3       4.920  -5.473   0.192  1.00 22.56           O  
ATOM     22  CB  PHE A   3       2.701  -6.888   1.967  1.00 25.48           C  
ATOM     23  CG  PHE A   3       2.034  -8.038   2.645  1.00 30.43           C  
ATOM     24  CD1 PHE A   3       2.675  -8.711   3.710  1.00 36.86           C  
ATOM     25  CD2 PHE A   3       0.793  -8.487   2.208  1.00 32.50           C  
ATOM     26  CE1 PHE A   3       2.056  -9.818   4.327  1.00 41.55           C  
ATOM     27  CE2 PHE A   3       0.171  -9.591   2.788  1.00 34.72           C  
ATOM     28  CZ  PHE A   3       0.778 -10.251   3.860  1.00 38.78           C  
ATOM     29  N   LYS A   4       3.039  -5.730  -1.021  1.00 19.86           N  
ATOM     30  CA  LYS A   4       3.324  -4.681  -1.952  1.00 19.59           C  
ATOM     31  C   LYS A   4       2.183  -3.667  -1.872  1.00 15.09           C  
ATOM     32  O   LYS A   4       1.001  -4.039  -1.632  1.00 17.22           O  
ATOM     33  CB  LYS A   4       3.404  -5.232  -3.373  1.00 23.53           C  
ATOM     34  CG  LYS A   4       4.056  -4.363  -4.402  1.00 28.80           C  
ATOM     35  CD  LYS A   4       3.788  -4.939  -5.830  1.00 31.25           C  
ATOM     36  CE  LYS A   4       4.770  -4.409  -6.862  0.01 32.73           C  
ATOM     37  NZ  LYS A   4       4.203  -3.282  -7.644  0.01 31.36           N  
ATOM     38  N   LEU A   5       2.550  -2.406  -2.014  1.00 14.46           N  
ATOM     39  CA  LEU A   5       1.540  -1.352  -2.206  1.00 12.81           C  
ATOM     40  C   LEU A   5       1.815  -0.684  -3.539  1.00 13.71           C  
ATOM     41  O   LEU A   5       2.873  -0.058  -3.714  1.00 18.89           O  
ATOM     42  CB  LEU A   5       1.560  -0.295  -1.058  1.00 13.84           C  
ATOM     43  CG  LEU A   5       0.548   0.897  -1.137  1.00 12.86           C  
ATOM     44  CD1 LEU A   5      -0.956   0.453  -1.009  1.00 10.28           C  
ATOM     45  CD2 LEU A   5       0.966   1.996  -0.109  1.00 12.21           C  
ATOM     46  N   ILE A   6       0.791  -0.728  -4.414  1.00 13.07           N  
ATOM     47  CA  ILE A   6       0.815  -0.061  -5.679  1.00 15.83           C  
ATOM     48  C   ILE A   6       0.110   1.276  -5.442  1.00 14.99           C  
ATOM     49  O   ILE A   6      -1.032   1.319  -5.019  1.00 16.74           O  
ATOM     50  CB  ILE A   6       0.151  -0.939  -6.736  1.00 18.97           C  
ATOM     51  CG1 ILE A   6       1.042  -2.166  -6.932  1.00 24.52           C  
ATOM     52  CG2 ILE A   6      -0.016  -0.138  -7.987  1.00 21.36           C  
ATOM     53  CD1 ILE A   6       0.390  -3.334  -7.635  1.00 36.55           C  
ATOM     54  N   ILE A   7       0.836   2.363  -5.640  1.00 16.26           N  
ATOM     55  CA  ILE A   7       0.331   3.729  -5.405  1.00 16.54           C  
ATOM     56  C   ILE A   7       0.027   4.359  -6.771  1.00 16.12           C  
ATOM     57  O   ILE A   7       0.948   4.571  -7.603  1.00 20.27           O  
ATOM     58  CB  ILE A   7       1.389   4.605  -4.664  1.00 16.04           C  
ATOM     59  CG1 ILE A   7       1.842   3.955  -3.310  1.00 21.36           C  
ATOM     60  CG2 ILE A   7       0.875   5.978  -4.421  1.00 17.83           C  
ATOM     61  CD1 ILE A   7       3.330   4.105  -3.048  1.00 21.66           C  
ATOM     62  N   ASN A   8      -1.238   4.732  -6.975  1.00 13.42           N  
ATOM     63  CA  ASN A   8      -1.625   5.422  -8.188  1.00 16.41           C  
ATOM     64  C   ASN A   8      -2.187   6.750  -7.729  1.00 17.51           C  
ATOM     65  O   ASN A   8      -3.413   6.960  -7.674  1.00 19.86           O  
ATOM     66  CB  ASN A   8      -2.663   4.563  -8.929  1.00 20.87           C  
ATOM     67  CG  ASN A   8      -2.908   4.987 -10.379  1.00 27.92           C  
ATOM     68  OD1 ASN A   8      -2.580   6.118 -10.787  1.00 29.73           O  
ATOM     69  ND2 ASN A   8      -3.512   4.081 -11.173  1.00 25.82           N  
ATOM     70  N   GLY A   9      -1.275   7.650  -7.354  1.00 19.62           N  
ATOM     71  CA  GLY A   9      -1.715   8.885  -6.692  1.00 23.16           C  
ATOM     72  C   GLY A   9      -1.725  10.099  -7.608  1.00 25.74           C  
ATOM     73  O   GLY A   9      -1.324  10.059  -8.774  1.00 27.33           O  
ATOM     74  N   LYS A  10      -2.216  11.210  -7.082  1.00 24.26           N  
ATOM     75  CA  LYS A  10      -2.252  12.397  -7.902  1.00 32.58           C  
ATOM     76  C   LYS A  10      -0.831  12.909  -8.082  1.00 36.78           C  
ATOM     77  O   LYS A  10      -0.510  13.390  -9.132  1.00 39.89           O  
ATOM     78  CB  LYS A  10      -3.242  13.438  -7.365  1.00 36.64           C  
ATOM     79  CG  LYS A  10      -4.719  12.978  -7.407  1.00 35.38           C  
ATOM     80  CD  LYS A  10      -5.672  14.036  -6.851  0.01 36.75           C  
ATOM     81  CE  LYS A  10      -5.859  13.917  -5.341  0.01 35.47           C  
ATOM     82  NZ  LYS A  10      -4.713  14.463  -4.560  0.01 35.67           N  
ATOM     83  N   THR A  11       0.034  12.721  -7.085  1.00 35.50           N  
ATOM     84  CA  THR A  11       1.428  13.225  -7.171  1.00 42.69           C  
ATOM     85  C   THR A  11       2.458  12.094  -7.361  1.00 40.10           C  
ATOM     86  O   THR A  11       3.359  12.187  -8.181  1.00 46.18           O  
ATOM     87  CB  THR A  11       1.759  14.055  -5.916  1.00 42.51           C  
ATOM     88  OG1 THR A  11       0.918  15.204  -5.919  1.00 44.03           O  
ATOM     89  CG2 THR A  11       3.265  14.512  -5.880  1.00 48.46           C  
ATOM     90  N   LEU A  12       2.315  11.059  -6.544  1.00 38.13           N  
ATOM     91  CA  LEU A  12       3.207   9.902  -6.493  1.00 35.16           C  
ATOM     92  C   LEU A  12       2.564   8.737  -7.224  1.00 32.86           C  
ATOM     93  O   LEU A  12       1.434   8.346  -6.883  1.00 29.77           O  
ATOM     94  CB  LEU A  12       3.397   9.426  -5.033  1.00 32.09           C  
ATOM     95  CG  LEU A  12       3.997  10.327  -3.960  1.00 32.89           C  
ATOM     96  CD1 LEU A  12       3.639   9.848  -2.526  1.00 35.31           C  
ATOM     97  CD2 LEU A  12       5.514  10.388  -4.180  1.00 34.21           C  
ATOM     98  N   LYS A  13       3.280   8.163  -8.205  1.00 31.65           N  
ATOM     99  CA  LYS A  13       3.051   6.777  -8.615  1.00 25.67           C  
ATOM    100  C   LYS A  13       4.189   5.921  -8.076  1.00 27.61           C  
ATOM    101  O   LYS A  13       5.299   6.395  -7.901  1.00 28.61           O  
ATOM    102  CB  LYS A  13       3.075   6.572 -10.133  1.00 27.02           C  
ATOM    103  CG  LYS A  13       2.470   7.624 -10.995  1.00 42.82           C  
ATOM    104  CD  LYS A  13       1.000   7.771 -10.877  1.00 44.14           C  
ATOM    105  CE  LYS A  13       0.605   9.043 -11.601  1.00 41.24           C  
ATOM    106  NZ  LYS A  13      -0.766   9.365 -11.202  1.00 55.37           N  
ATOM    107  N   GLY A  14       3.914   4.648  -7.878  1.00 26.42           N  
ATOM    108  CA  GLY A  14       5.000   3.702  -7.675  1.00 30.40           C  
ATOM    109  C   GLY A  14       4.556   2.485  -6.899  1.00 27.68           C  
ATOM    110  O   GLY A  14       3.397   2.086  -6.898  1.00 25.51           O  
ATOM    111  N   GLU A  15       5.502   1.854  -6.245  1.00 20.60           N  
ATOM    112  CA  GLU A  15       5.231   0.564  -5.679  1.00 21.44           C  
ATOM    113  C   GLU A  15       6.165   0.564  -4.466  1.00 20.65           C  
ATOM    114  O   GLU A  15       7.354   0.866  -4.605  1.00 26.26           O  
ATOM    115  CB  GLU A  15       5.592  -0.578  -6.682  1.00 26.11           C  
ATOM    116  CG  GLU A  15       6.911  -0.418  -7.440  0.01 26.29           C  
ATOM    117  CD  GLU A  15       7.188  -1.566  -8.399  0.01 29.00           C  
ATOM    118  OE1 GLU A  15       6.759  -2.707  -8.118  0.01 28.55           O  
ATOM    119  OE2 GLU A  15       7.843  -1.328  -9.434  0.01 31.46           O  
ATOM    120  N   ILE A  16       5.635   0.289  -3.297  1.00 21.02           N  
ATOM    121  CA  ILE A  16       6.520  -0.028  -2.166  1.00 21.98           C  
ATOM    122  C   ILE A  16       6.335  -1.489  -1.716  1.00 22.07           C  
ATOM    123  O   ILE A  16       5.222  -2.048  -1.837  1.00 22.39           O  
ATOM    124  CB  ILE A  16       6.394   0.984  -1.006  1.00 21.34           C  
ATOM    125  CG1 ILE A  16       5.004   1.060  -0.425  1.00 23.91           C  
ATOM    126  CG2 ILE A  16       6.849   2.354  -1.479  1.00 26.65           C  
ATOM    127  CD1 ILE A  16       5.017   1.607   1.009  1.00 31.72           C  
ATOM    128  N   THR A  17       7.405  -2.121  -1.210  1.00 21.47           N  
ATOM    129  CA  THR A  17       7.296  -3.456  -0.625  1.00 22.37           C  
ATOM    130  C   THR A  17       7.878  -3.442   0.800  1.00 22.85           C  
ATOM    131  O   THR A  17       8.882  -2.737   1.102  1.00 24.54           O  
ATOM    132  CB  THR A  17       8.012  -4.572  -1.443  1.00 24.94           C  
ATOM    133  OG1 THR A  17       9.412  -4.266  -1.511  1.00 31.52           O  
ATOM    134  CG2 THR A  17       7.459  -4.663  -2.829  1.00 23.45           C  
ATOM    135  N   ILE A  18       7.202  -4.204   1.658  1.00 24.85           N  
ATOM    136  CA  ILE A  18       7.636  -4.418   3.024  1.00 29.04           C  
ATOM    137  C   ILE A  18       7.589  -5.903   3.316  1.00 34.61           C  
ATOM    138  O   ILE A  18       6.995  -6.686   2.538  1.00 34.52           O  
ATOM    139  CB  ILE A  18       6.760  -3.681   4.074  1.00 24.53           C  
ATOM    140  CG1 ILE A  18       5.320  -4.190   4.031  1.00 28.56           C  
ATOM    141  CG2 ILE A  18       6.862  -2.205   3.859  1.00 27.32           C  
ATOM    142  CD1 ILE A  18       4.423  -3.696   5.066  1.00 27.36           C  
ATOM    143  N   GLU A  19       8.214  -6.283   4.433  1.00 36.19           N  
ATOM    144  CA  GLU A  19       8.051  -7.605   4.994  1.00 43.34           C  
ATOM    145  C   GLU A  19       7.087  -7.484   6.165  1.00 39.29           C  
ATOM    146  O   GLU A  19       7.231  -6.631   7.043  1.00 40.29           O  
ATOM    147  CB  GLU A  19       9.409  -8.200   5.441  1.00 46.44           C  
ATOM    148  CG  GLU A  19      10.021  -9.290   4.525  1.00 58.65           C  
ATOM    149  CD  GLU A  19      11.522  -9.472   4.820  1.00 64.02           C  
ATOM    150  OE1 GLU A  19      11.910 -10.326   5.686  1.00 85.49           O  
ATOM    151  OE2 GLU A  19      12.325  -8.714   4.208  1.00 82.95           O  
ATOM    152  N   ALA A  20       6.078  -8.344   6.172  1.00 40.85           N  
ATOM    153  CA  ALA A  20       5.126  -8.354   7.272  1.00 41.50           C  
ATOM    154  C   ALA A  20       4.707  -9.811   7.450  1.00 45.24           C  
ATOM    155  O   ALA A  20       4.943 -10.644   6.540  1.00 45.18           O  
ATOM    156  CB  ALA A  20       3.923  -7.417   6.981  1.00 37.34           C  
ATOM    157  N   VAL A  21       4.140 -10.127   8.611  1.00 47.45           N  
ATOM    158  CA  VAL A  21       3.699 -11.520   8.879  1.00 56.59           C  
ATOM    159  C   VAL A  21       2.385 -11.873   8.190  1.00 54.74           C  
ATOM    160  O   VAL A  21       2.214 -13.007   7.696  1.00 56.10           O  
ATOM    161  CB  VAL A  21       3.543 -11.877  10.399  1.00 61.12           C  
ATOM    162  CG1 VAL A  21       4.882 -11.968  11.063  1.00 64.38           C  
ATOM    163  CG2 VAL A  21       2.610 -10.907  11.125  1.00 58.92           C  
ATOM    164  N   ASP A  22       1.489 -10.872   8.161  1.00 51.30           N  
ATOM    165  CA  ASP A  22       0.084 -10.985   7.804  1.00 49.60           C  
ATOM    166  C   ASP A  22      -0.286  -9.811   6.854  1.00 43.62           C  
ATOM    167  O   ASP A  22       0.365  -8.744   6.856  1.00 39.44           O  
ATOM    168  CB  ASP A  22      -0.812 -10.971   9.088  1.00 50.22           C  
ATOM    169  CG  ASP A  22      -0.604 -12.193   9.967  0.01 56.26           C  
ATOM    170  OD1 ASP A  22      -0.403 -13.304   9.429  0.01 58.15           O  
ATOM    171  OD2 ASP A  22      -0.654 -12.043  11.206  0.01 58.42           O  
ATOM    172  N   ALA A  23      -1.325 -10.019   6.042  1.00 42.90           N  
ATOM    173  CA  ALA A  23      -1.930  -8.920   5.250  1.00 36.94           C  
ATOM    174  C   ALA A  23      -2.506  -7.810   6.134  1.00 36.13           C  
ATOM    175  O   ALA A  23      -2.461  -6.645   5.758  1.00 31.44           O  
ATOM    176  CB  ALA A  23      -2.947  -9.440   4.253  1.00 35.49           C  
ATOM    177  N   ALA A  24      -3.010  -8.186   7.309  1.00 39.79           N  
ATOM    178  CA  ALA A  24      -3.509  -7.260   8.341  1.00 39.16           C  
ATOM    179  C   ALA A  24      -2.412  -6.317   8.916  1.00 38.05           C  
ATOM    180  O   ALA A  24      -2.618  -5.107   9.074  1.00 35.09           O  
ATOM    181  CB  ALA A  24      -4.149  -8.066   9.474  1.00 44.55           C  
ATOM    182  N   GLU A  25      -1.267  -6.870   9.270  1.00 38.22           N  
ATOM    183  CA  GLU A  25      -0.162  -6.006   9.696  1.00 39.43           C  
ATOM    184  C   GLU A  25       0.350  -5.136   8.524  1.00 33.61           C  
ATOM    185  O   GLU A  25       0.645  -3.964   8.758  1.00 34.46           O  
ATOM    186  CB  GLU A  25       0.982  -6.768  10.420  1.00 42.34           C  
ATOM    187  CG  GLU A  25       0.605  -7.267  11.832  1.00 51.84           C  
ATOM    188  CD  GLU A  25       0.143  -6.151  12.840  1.00 57.13           C  
ATOM    189  OE1 GLU A  25      -1.044  -6.207  13.247  1.00 65.24           O  
ATOM    190  OE2 GLU A  25       0.958  -5.260  13.257  1.00 60.89           O  
ATOM    191  N   ALA A  26       0.457  -5.707   7.313  1.00 31.22           N  
ATOM    192  CA  ALA A  26       0.819  -4.951   6.110  1.00 25.22           C  
ATOM    193  C   ALA A  26      -0.170  -3.765   5.877  1.00 27.04           C  
ATOM    194  O   ALA A  26       0.249  -2.640   5.613  1.00 22.74           O  
ATOM    195  CB  ALA A  26       0.886  -5.874   4.859  1.00 26.47           C  
ATOM    196  N   GLU A  27      -1.472  -4.015   6.015  1.00 26.58           N  
ATOM    197  CA  GLU A  27      -2.447  -2.938   5.910  1.00 25.57           C  
ATOM    198  C   GLU A  27      -2.212  -1.794   6.886  1.00 25.94           C  
ATOM    199  O   GLU A  27      -2.293  -0.623   6.505  1.00 21.50           O  
ATOM    200  CB  GLU A  27      -3.882  -3.430   6.075  1.00 27.92           C  
ATOM    201  CG  GLU A  27      -4.861  -2.251   5.819  1.00 29.29           C  
ATOM    202  CD  GLU A  27      -6.299  -2.594   6.098  1.00 29.38           C  
ATOM    203  OE1 GLU A  27      -6.708  -3.719   5.813  1.00 41.10           O  
ATOM    204  OE2 GLU A  27      -7.042  -1.741   6.600  1.00 30.00           O  
ATOM    205  N   LYS A  28      -1.913  -2.124   8.147  1.00 28.37           N  
ATOM    206  CA  LYS A  28      -1.692  -1.054   9.152  1.00 28.52           C  
ATOM    207  C   LYS A  28      -0.482  -0.197   8.716  1.00 26.40           C  
ATOM    208  O   LYS A  28      -0.557   1.017   8.713  1.00 23.86           O  
ATOM    209  CB  LYS A  28      -1.495  -1.626  10.576  1.00 35.00           C  
ATOM    210  CG  LYS A  28      -1.891  -0.694  11.705  0.01 35.35           C  
ATOM    211  CD  LYS A  28      -1.962  -1.447  13.029  0.01 39.25           C  
ATOM    212  CE  LYS A  28      -3.260  -2.235  13.171  0.01 39.91           C  
ATOM    213  NZ  LYS A  28      -3.311  -2.997  14.449  0.01 44.38           N  
ATOM    214  N   PHE A  29       0.610  -0.853   8.315  1.00 26.04           N  
ATOM    215  CA  PHE A  29       1.795  -0.138   7.799  1.00 26.44           C  
ATOM    216  C   PHE A  29       1.405   0.786   6.608  1.00 21.55           C  
ATOM    217  O   PHE A  29       1.774   1.988   6.556  1.00 20.91           O  
ATOM    218  CB  PHE A  29       2.931  -1.110   7.368  1.00 24.60           C  
ATOM    219  CG  PHE A  29       4.205  -0.384   6.962  1.00 27.11           C  
ATOM    220  CD1 PHE A  29       5.227  -0.143   7.898  1.00 33.94           C  
ATOM    221  CD2 PHE A  29       4.367   0.107   5.665  1.00 24.63           C  
ATOM    222  CE1 PHE A  29       6.361   0.553   7.523  1.00 36.75           C  
ATOM    223  CE2 PHE A  29       5.497   0.809   5.293  1.00 22.87           C  
ATOM    224  CZ  PHE A  29       6.478   1.037   6.198  1.00 31.15           C  
ATOM    225  N   PHE A  30       0.689   0.195   5.648  1.00 19.35           N  
ATOM    226  CA  PHE A  30       0.372   0.899   4.448  1.00 16.67           C  
ATOM    227  C   PHE A  30      -0.575   2.064   4.710  1.00 17.29           C  
ATOM    228  O   PHE A  30      -0.451   3.090   4.063  1.00 16.30           O  
ATOM    229  CB  PHE A  30      -0.174  -0.057   3.382  1.00 16.26           C  
ATOM    230  CG  PHE A  30       0.873  -0.939   2.771  1.00 15.90           C  
ATOM    231  CD1 PHE A  30       2.180  -0.465   2.544  1.00 20.54           C  
ATOM    232  CD2 PHE A  30       0.554  -2.236   2.364  1.00 19.77           C  
ATOM    233  CE1 PHE A  30       3.174  -1.290   1.920  1.00 20.60           C  
ATOM    234  CE2 PHE A  30       1.503  -3.074   1.761  1.00 18.38           C  
ATOM    235  CZ  PHE A  30       2.836  -2.613   1.557  1.00 20.16           C  
ATOM    236  N   LYS A  31      -1.539   1.910   5.605  1.00 17.86           N  
ATOM    237  CA  LYS A  31      -2.383   3.068   5.979  1.00 21.43           C  
ATOM    238  C   LYS A  31      -1.603   4.181   6.656  1.00 23.00           C  
ATOM    239  O   LYS A  31      -1.816   5.363   6.339  1.00 22.81           O  
ATOM    240  CB  LYS A  31      -3.550   2.661   6.855  1.00 22.99           C  
ATOM    241  CG  LYS A  31      -4.515   1.739   6.091  1.00 26.21           C  
ATOM    242  CD  LYS A  31      -5.892   1.636   6.704  1.00 35.91           C  
ATOM    243  CE  LYS A  31      -6.900   1.289   5.601  1.00 34.60           C  
ATOM    244  NZ  LYS A  31      -8.301   1.325   6.103  0.01 36.27           N  
ATOM    245  N   GLN A  32      -0.668   3.793   7.533  1.00 24.77           N  
ATOM    246  CA  GLN A  32       0.275   4.752   8.125  1.00 27.67           C  
ATOM    247  C   GLN A  32       1.110   5.457   7.013  1.00 24.81           C  
ATOM    248  O   GLN A  32       1.253   6.677   7.019  1.00 24.59           O  
ATOM    249  CB  GLN A  32       1.158   4.087   9.234  1.00 26.81           C  
ATOM    250  CG  GLN A  32       2.029   5.092  10.059  1.00 38.74           C  
ATOM    251  CD  GLN A  32       1.250   5.942  11.090  1.00 47.57           C  
ATOM    252  OE1 GLN A  32       1.560   5.915  12.281  0.01 48.79           O  
ATOM    253  NE2 GLN A  32       0.266   6.703  10.625  0.01 44.69           N  
ATOM    254  N   TYR A  33       1.653   4.675   6.070  1.00 23.01           N  
ATOM    255  CA  TYR A  33       2.438   5.233   4.978  1.00 20.77           C  
ATOM    256  C   TYR A  33       1.576   6.195   4.129  1.00 18.57           C  
ATOM    257  O   TYR A  33       2.036   7.291   3.783  1.00 19.93           O  
ATOM    258  CB  TYR A  33       3.036   4.063   4.124  1.00 19.74           C  
ATOM    259  CG  TYR A  33       3.656   4.542   2.813  1.00 17.24           C  
ATOM    260  CD1 TYR A  33       5.014   4.833   2.741  1.00 23.53           C  
ATOM    261  CD2 TYR A  33       2.864   4.818   1.717  1.00 21.40           C  
ATOM    262  CE1 TYR A  33       5.590   5.298   1.573  1.00 19.20           C  
ATOM    263  CE2 TYR A  33       3.419   5.335   0.520  1.00 20.51           C  
ATOM    264  CZ  TYR A  33       4.796   5.534   0.461  1.00 20.76           C  
ATOM    265  OH  TYR A  33       5.373   6.025  -0.718  1.00 25.58           O  
ATOM    266  N   ALA A  34       0.328   5.797   3.791  1.00 16.10           N  
ATOM    267  CA  ALA A  34      -0.549   6.660   2.961  1.00 16.08           C  
ATOM    268  C   ALA A  34      -0.819   7.994   3.699  1.00 24.02           C  
ATOM    269  O   ALA A  34      -0.643   9.063   3.128  1.00 24.41           O  
ATOM    270  CB  ALA A  34      -1.849   5.910   2.581  1.00 15.62           C  
ATOM    271  N   ASN A  35      -1.190   7.907   4.978  1.00 25.42           N  
ATOM    272  CA  ASN A  35      -1.295   9.042   5.922  1.00 30.98           C  
ATOM    273  C   ASN A  35      -0.073  10.010   5.852  1.00 31.80           C  
ATOM    274  O   ASN A  35      -0.196  11.236   5.658  1.00 34.97           O  
ATOM    275  CB  ASN A  35      -1.406   8.426   7.361  1.00 34.63           C  
ATOM    276  CG  ASN A  35      -1.853   9.422   8.446  1.00 49.08           C  
ATOM    277  OD1 ASN A  35      -2.960   9.964   8.362  1.00 56.97           O  
ATOM    278  ND2 ASN A  35      -1.014   9.611   9.508  1.00 48.91           N  
ATOM    279  N   ASP A  36       1.109   9.436   6.006  1.00 30.93           N  
ATOM    280  CA  ASP A  36       2.371  10.133   6.056  1.00 34.33           C  
ATOM    281  C   ASP A  36       2.687  10.869   4.745  1.00 33.79           C  
ATOM    282  O   ASP A  36       3.396  11.902   4.708  1.00 36.38           O  
ATOM    283  CB  ASP A  36       3.407   9.070   6.244  1.00 35.52           C  
ATOM    284  CG  ASP A  36       4.219   9.304   7.402  1.00 46.03           C  
ATOM    285  OD1 ASP A  36       4.013   8.523   8.353  1.00 60.39           O  
ATOM    286  OD2 ASP A  36       5.010  10.277   7.376  1.00 49.67           O  
ATOM    287  N   ASN A  37       2.139  10.339   3.662  1.00 25.77           N  
ATOM    288  CA  ASN A  37       2.462  10.831   2.362  1.00 26.14           C  
ATOM    289  C   ASN A  37       1.320  11.558   1.709  1.00 26.19           C  
ATOM    290  O   ASN A  37       1.366  11.837   0.532  1.00 25.98           O  
ATOM    291  CB  ASN A  37       2.985   9.671   1.498  1.00 21.09           C  
ATOM    292  CG  ASN A  37       4.389   9.266   1.913  1.00 23.71           C  
ATOM    293  OD1 ASN A  37       5.368   9.921   1.554  1.00 25.43           O  
ATOM    294  ND2 ASN A  37       4.477   8.290   2.759  1.00 25.57           N  
ATOM    295  N   GLY A  38       0.297  11.844   2.503  1.00 25.23           N  
ATOM    296  CA  GLY A  38      -0.873  12.548   2.050  1.00 28.52           C  
ATOM    297  C   GLY A  38      -1.692  11.909   0.975  1.00 26.99           C  
ATOM    298  O   GLY A  38      -2.324  12.645   0.192  1.00 32.60           O  
ATOM    299  N   ILE A  39      -1.677  10.568   0.928  1.00 25.12           N  
ATOM    300  CA  ILE A  39      -2.427   9.792  -0.073  1.00 26.31           C  
ATOM    301  C   ILE A  39      -3.791   9.381   0.510  1.00 28.56           C  
ATOM    302  O   ILE A  39      -3.829   8.730   1.541  1.00 31.34           O  
ATOM    303  CB  ILE A  39      -1.631   8.513  -0.513  1.00 25.24           C  
ATOM    304  CG1 ILE A  39      -0.296   8.878  -1.143  1.00 25.25           C  
ATOM    305  CG2 ILE A  39      -2.501   7.601  -1.431  1.00 27.20           C  
ATOM    306  CD1 ILE A  39       0.577   7.712  -1.164  1.00 25.07           C  
ATOM    307  N   ASP A  40      -4.887   9.775  -0.146  1.00 27.49           N  
ATOM    308  CA  ASP A  40      -6.266   9.447   0.275  1.00 30.87           C  
ATOM    309  C   ASP A  40      -7.030   8.947  -0.976  1.00 29.73           C  
ATOM    310  O   ASP A  40      -7.290   9.760  -1.921  1.00 31.35           O  
ATOM    311  CB  ASP A  40      -6.986  10.680   0.944  1.00 38.48           C  
ATOM    312  CG  ASP A  40      -8.405  10.321   1.579  1.00 39.30           C  
ATOM    313  OD1 ASP A  40      -8.655   9.150   1.985  1.00 46.85           O  
ATOM    314  OD2 ASP A  40      -9.263  11.233   1.684  1.00 61.60           O  
ATOM    315  N   GLY A  41      -7.354   7.640  -1.017  1.00 22.07           N  
ATOM    316  CA  GLY A  41      -8.056   7.098  -2.177  1.00 21.67           C  
ATOM    317  C   GLY A  41      -8.837   5.809  -1.957  1.00 19.00           C  
ATOM    318  O   GLY A  41      -9.223   5.498  -0.808  1.00 19.77           O  
ATOM    319  N   GLU A  42      -9.033   5.074  -3.052  1.00 17.35           N  
ATOM    320  CA  GLU A  42      -9.782   3.822  -3.122  1.00 15.41           C  
ATOM    321  C   GLU A  42      -8.765   2.729  -2.965  1.00 12.75           C  
ATOM    322  O   GLU A  42      -7.683   2.802  -3.591  1.00 13.52           O  
ATOM    323  CB  GLU A  42     -10.451   3.595  -4.508  1.00 18.39           C  
ATOM    324  CG  GLU A  42     -11.592   4.515  -4.815  1.00 31.14           C  
ATOM    325  CD  GLU A  42     -12.742   3.805  -5.453  0.50 36.22           C  
ATOM    326  OE1 GLU A  42     -12.455   3.005  -6.368  0.50 34.46           O  
ATOM    327  OE2 GLU A  42     -13.918   4.039  -5.047  0.50 29.35           O  
ATOM    328  N   TRP A  43      -9.085   1.718  -2.153  1.00 12.39           N  
ATOM    329  CA  TRP A  43      -8.148   0.615  -1.875  1.00 13.74           C  
ATOM    330  C   TRP A  43      -8.629  -0.755  -2.307  1.00 14.10           C  
ATOM    331  O   TRP A  43      -9.816  -1.125  -2.137  1.00 16.98           O  
ATOM    332  CB  TRP A  43      -7.937   0.550  -0.346  1.00 14.79           C  
ATOM    333  CG  TRP A  43      -7.233   1.709   0.244  1.00 10.86           C  
ATOM    334  CD1 TRP A  43      -7.702   2.930   0.464  1.00 12.04           C  
ATOM    335  CD2 TRP A  43      -5.910   1.683   0.765  1.00 12.29           C  
ATOM    336  NE1 TRP A  43      -6.771   3.713   1.073  1.00 12.83           N  
ATOM    337  CE2 TRP A  43      -5.653   2.958   1.281  1.00 12.63           C  
ATOM    338  CE3 TRP A  43      -4.930   0.691   0.866  1.00 12.05           C  
ATOM    339  CZ2 TRP A  43      -4.417   3.311   1.893  1.00 14.73           C  
ATOM    340  CZ3 TRP A  43      -3.693   1.021   1.451  1.00 15.27           C  
ATOM    341  CH2 TRP A  43      -3.447   2.339   1.961  1.00 17.18           C  
ATOM    342  N   THR A  44      -7.704  -1.566  -2.807  1.00 15.86           N  
ATOM    343  CA  THR A  44      -8.056  -2.992  -2.999  1.00 17.55           C  
ATOM    344  C   THR A  44      -6.979  -3.844  -2.326  1.00 18.85           C  
ATOM    345  O   THR A  44      -5.960  -3.351  -1.881  1.00 20.54           O  
ATOM    346  CB  THR A  44      -8.146  -3.442  -4.472  1.00 22.31           C  
ATOM    347  OG1 THR A  44      -6.810  -3.453  -5.009  1.00 27.94           O  
ATOM    348  CG2 THR A  44      -9.062  -2.548  -5.259  1.00 23.11           C  
ATOM    349  N   TYR A  45      -7.228  -5.131  -2.240  1.00 22.22           N  
ATOM    350  CA  TYR A  45      -6.176  -6.084  -1.832  1.00 23.76           C  
ATOM    351  C   TYR A  45      -6.331  -7.348  -2.689  1.00 27.42           C  
ATOM    352  O   TYR A  45      -7.446  -7.839  -2.824  1.00 29.46           O  
ATOM    353  CB  TYR A  45      -6.276  -6.453  -0.385  1.00 23.86           C  
ATOM    354  CG  TYR A  45      -5.284  -7.500  -0.040  1.00 25.32           C  
ATOM    355  CD1 TYR A  45      -3.923  -7.212   0.029  1.00 25.07           C  
ATOM    356  CD2 TYR A  45      -5.687  -8.787   0.202  1.00 37.63           C  
ATOM    357  CE1 TYR A  45      -2.972  -8.210   0.374  1.00 30.19           C  
ATOM    358  CE2 TYR A  45      -4.763  -9.767   0.541  1.00 32.85           C  
ATOM    359  CZ  TYR A  45      -3.414  -9.463   0.614  1.00 31.41           C  
ATOM    360  OH  TYR A  45      -2.508 -10.443   0.947  1.00 36.41           O  
ATOM    361  N   ASP A  46      -5.247  -7.832  -3.306  1.00 28.24           N  
ATOM    362  CA  ASP A  46      -5.272  -9.085  -4.085  1.00 31.46           C  
ATOM    363  C   ASP A  46      -4.417 -10.120  -3.357  1.00 34.26           C  
ATOM    364  O   ASP A  46      -3.200  -9.989  -3.278  1.00 32.96           O  
ATOM    365  CB  ASP A  46      -4.628  -8.882  -5.449  1.00 32.15           C  
ATOM    366  CG  ASP A  46      -4.533 -10.202  -6.244  1.00 39.54           C  
ATOM    367  OD1 ASP A  46      -5.517 -10.952  -6.182  1.00 49.19           O  
ATOM    368  OD2 ASP A  46      -3.496 -10.474  -6.879  1.00 43.62           O  
ATOM    369  N   ASP A  47      -5.031 -11.152  -2.816  1.00 42.41           N  
ATOM    370  CA  ASP A  47      -4.205 -12.159  -2.127  1.00 45.62           C  
ATOM    371  C   ASP A  47      -3.153 -12.928  -3.031  1.00 48.87           C  
ATOM    372  O   ASP A  47      -2.074 -13.224  -2.575  1.00 47.64           O  
ATOM    373  CB  ASP A  47      -5.080 -13.080  -1.264  1.00 50.23           C  
ATOM    374  CG  ASP A  47      -4.292 -13.765  -0.146  1.00 62.78           C  
ATOM    375  OD1 ASP A  47      -3.856 -13.073   0.832  1.00 59.47           O  
ATOM    376  OD2 ASP A  47      -4.129 -15.008  -0.235  1.00 72.20           O  
ATOM    377  N   ALA A  48      -3.427 -13.180  -4.313  1.00 50.08           N  
ATOM    378  CA  ALA A  48      -2.450 -13.950  -5.135  1.00 49.66           C  
ATOM    379  C   ALA A  48      -1.102 -13.252  -5.243  1.00 43.88           C  
ATOM    380  O   ALA A  48      -0.059 -13.856  -5.045  1.00 45.08           O  
ATOM    381  CB  ALA A  48      -3.037 -14.265  -6.527  1.00 54.78           C  
ATOM    382  N   THR A  49      -1.139 -11.938  -5.446  1.00 38.69           N  
ATOM    383  CA  THR A  49       0.026 -11.154  -5.608  1.00 37.18           C  
ATOM    384  C   THR A  49       0.445 -10.434  -4.311  1.00 34.25           C  
ATOM    385  O   THR A  49       1.418  -9.690  -4.329  1.00 33.28           O  
ATOM    386  CB  THR A  49      -0.153 -10.160  -6.820  1.00 41.18           C  
ATOM    387  OG1 THR A  49      -1.271  -9.242  -6.602  1.00 38.79           O  
ATOM    388  CG2 THR A  49      -0.331 -10.985  -8.187  1.00 49.67           C  
ATOM    389  N   LYS A  50      -0.254 -10.696  -3.203  1.00 30.26           N  
ATOM    390  CA  LYS A  50      -0.006 -10.074  -1.880  1.00 31.38           C  
ATOM    391  C   LYS A  50       0.110  -8.565  -1.958  1.00 27.36           C  
ATOM    392  O   LYS A  50       1.037  -7.955  -1.390  1.00 28.03           O  
ATOM    393  CB  LYS A  50       1.234 -10.699  -1.198  1.00 34.36           C  
ATOM    394  CG  LYS A  50       1.065 -12.210  -0.918  1.00 41.12           C  
ATOM    395  CD  LYS A  50       0.192 -12.476   0.312  1.00 43.56           C  
ATOM    396  CE  LYS A  50       0.014 -13.980   0.508  1.00 51.01           C  
ATOM    397  NZ  LYS A  50      -0.650 -14.608  -0.686  1.00 59.95           N  
ATOM    398  N   THR A  51      -0.838  -7.949  -2.670  1.00 26.61           N  
ATOM    399  CA  THR A  51      -0.676  -6.599  -3.161  1.00 22.23           C  
ATOM    400  C   THR A  51      -1.928  -5.802  -2.796  1.00 21.53           C  
ATOM    401  O   THR A  51      -3.062  -6.229  -3.056  1.00 24.42           O  
ATOM    402  CB  THR A  51      -0.417  -6.536  -4.730  1.00 24.00           C  
ATOM    403  OG1 THR A  51       0.832  -7.158  -5.056  1.00 30.66           O  
ATOM    404  CG2 THR A  51      -0.267  -5.149  -5.187  1.00 21.91           C  
ATOM    405  N   PHE A  52      -1.694  -4.664  -2.126  1.00 17.86           N  
ATOM    406  CA  PHE A  52      -2.685  -3.605  -1.974  1.00 16.00           C  
ATOM    407  C   PHE A  52      -2.508  -2.581  -3.089  1.00 14.75           C  
ATOM    408  O   PHE A  52      -1.393  -2.325  -3.571  1.00 17.17           O  
ATOM    409  CB  PHE A  52      -2.482  -2.871  -0.652  1.00 14.48           C  
ATOM    410  CG  PHE A  52      -2.703  -3.717   0.565  1.00 17.67           C  
ATOM    411  CD1 PHE A  52      -1.678  -4.529   1.073  1.00 19.39           C  
ATOM    412  CD2 PHE A  52      -3.918  -3.692   1.215  1.00 22.14           C  
ATOM    413  CE1 PHE A  52      -1.878  -5.312   2.188  1.00 20.39           C  
ATOM    414  CE2 PHE A  52      -4.132  -4.501   2.355  1.00 23.80           C  
ATOM    415  CZ  PHE A  52      -3.084  -5.303   2.830  1.00 22.90           C  
ATOM    416  N   THR A  53      -3.599  -1.948  -3.454  1.00 15.35           N  
ATOM    417  CA  THR A  53      -3.513  -0.801  -4.333  1.00 16.41           C  
ATOM    418  C   THR A  53      -4.238   0.353  -3.614  1.00 16.53           C  
ATOM    419  O   THR A  53      -5.244   0.139  -2.920  1.00 16.39           O  
ATOM    420  CB  THR A  53      -4.170  -1.060  -5.663  1.00 16.84           C  
ATOM    421  OG1 THR A  53      -5.571  -1.378  -5.406  1.00 22.97           O  
ATOM    422  CG2 THR A  53      -3.448  -2.201  -6.372  1.00 14.12           C  
ATOM    423  N   VAL A  54      -3.687   1.548  -3.730  1.00 12.29           N  
ATOM    424  CA  VAL A  54      -4.400   2.792  -3.398  1.00 12.14           C  
ATOM    425  C   VAL A  54      -4.362   3.761  -4.606  1.00 14.79           C  
ATOM    426  O   VAL A  54      -3.309   3.979  -5.209  1.00 14.75           O  
ATOM    427  CB  VAL A  54      -3.850   3.452  -2.090  1.00 11.94           C  
ATOM    428  CG1 VAL A  54      -2.343   3.887  -2.257  1.00 11.61           C  
ATOM    429  CG2 VAL A  54      -4.748   4.642  -1.644  1.00 11.25           C  
ATOM    430  N   THR A  55      -5.522   4.295  -4.974  1.00 14.16           N  
ATOM    431  CA  THR A  55      -5.692   5.086  -6.204  1.00 15.68           C  
ATOM    432  C   THR A  55      -6.453   6.346  -5.844  1.00 18.29           C  
ATOM    433  O   THR A  55      -7.526   6.261  -5.233  1.00 19.82           O  
ATOM    434  CB  THR A  55      -6.473   4.276  -7.248  1.00 16.63           C  
ATOM    435  OG1 THR A  55      -5.735   3.081  -7.539  1.00 20.55           O  
ATOM    436  CG2 THR A  55      -6.679   5.084  -8.529  1.00 19.68           C  
ATOM    437  N   GLU A  56      -5.864   7.508  -6.165  1.00 16.86           N  
ATOM    438  CA  GLU A  56      -6.441   8.811  -5.829  1.00 23.26           C  
ATOM    439  C   GLU A  56      -7.252   9.340  -6.953  1.00 30.77           C  
ATOM    440  O   GLU A  56      -6.923   9.148  -8.140  1.00 35.33           O  
ATOM    441  CB  GLU A  56      -5.381   9.828  -5.527  1.00 22.53           C  
ATOM    442  CG  GLU A  56      -4.584   9.489  -4.324  1.00 31.53           C  
ATOM    443  CD  GLU A  56      -3.853  10.702  -3.811  1.00 36.05           C  
ATOM    444  OE1 GLU A  56      -2.997  11.228  -4.555  1.00 31.30           O  
ATOM    445  OE2 GLU A  56      -4.155  11.154  -2.666  1.00 34.96           O  
ATOM    446  OXT GLU A  56      -8.221  10.039  -6.631  1.00 33.77           O  
TER     447      GLU A  56                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
