
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   71 (  547),  selected   71 , name 1xf5_L
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1xf5_L.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    12_L      -       -           -
LGA    T    13_L      -       -           -
LGA    P    14_L      -       -           -
LGA    E    15_L      -       -           -
LGA    E    16_L      -       -           -
LGA    P    17_L      -       -           -
LGA    K    18_L      -       -           -
LGA    E    19_L      -       -           -
LGA    E    20_L      -       -           -
LGA    V    21_L      T       1          1.141
LGA    T    22_L      T       2          0.534
LGA    I    23_L      Y       3          0.448
LGA    K    24_L      K       4          1.301
LGA    V    25_L      L       5          1.485
LGA    N    26_L      I       6          1.344
LGA    L    27_L      L       7          1.192
LGA    I    28_L      N       8          0.826
LGA    F    29_L      L       9          1.020
LGA    A    30_L      K      10          1.297
LGA    D    31_L      Q      11          1.947
LGA    G    32_L      -       -           -
LGA    K    33_L      A      12          2.030
LGA    I    34_L      K      13          1.246
LGA    Q    35_L      E      14          1.473
LGA    T    36_L      E      15          1.753
LGA    A    37_L      A      16          2.184
LGA    E    38_L      I      17          1.177
LGA    F    39_L      K      18          1.134
LGA    K    40_L      E      19          1.123
LGA    G    41_L      A      20          0.827
LGA    T    42_L      V      21          2.086
LGA    F    43_L      D      22          1.872
LGA    E    44_L      A      23          2.813
LGA    -       -      G      24           -
LGA    E    45_L      T      25          0.649
LGA    A    46_L      A      26          1.299
LGA    T    47_L      E      27          1.885
LGA    A    48_L      K      28          1.506
LGA    E    49_L      Y      29          0.837
LGA    A    50_L      F      30          0.830
LGA    Y    51_L      K      31          1.581
LGA    R    52_L      L      32          1.992
LGA    Y    53_L      I      33          1.470
LGA    A    54_L      A      34          1.306
LGA    D    55_L      N      35          1.653
LGA    L    56_L      A      36          1.484
LGA    L    57_L      K      37          1.681
LGA    A    58_L      T      38          2.419
LGA    K    59_L      -       -           -
LGA    V    60_L      -       -           -
LGA    N    61_L      -       -           -
LGA    G    62_L      V      39          3.140
LGA    E    63_L      E      40          2.009
LGA    W    64_L      G      41          2.854
LGA    T    65_L      V      42          2.242
LGA    A    66_L      W      43          1.536
LGA    D    67_L      T      44          1.568
LGA    L    68_L      Y      45          0.673
LGA    E    69_L      K      46          1.326
LGA    D    70_L      D      47          1.488
LGA    G    71_L      E      48          5.702
LGA    G    72_L      I      49           -
LGA    N    73_L      K      50          0.748
LGA    C    74_L      T      51          1.303
LGA    M    75_L      F      52          1.594
LGA    N    76_L      T      53          1.831
LGA    I    77_L      V      54          1.587
LGA    K    78_L      T      55          1.962
LGA    F    79_L      E      56          3.706
LGA    A    80_L      -       -           -
LGA    G    81_L      -       -           -
LGA    K    82_L      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   71   56    5.0     54    1.84    14.81     87.641     2.786

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.452096 * X  +  -0.891483 * Y  +  -0.029444 * Z  +  39.786026
  Y_new =   0.169949 * X  +   0.118498 * Y  +  -0.978302 * Z  + -36.670624
  Z_new =   0.875629 * X  +   0.437283 * Y  +   0.205079 * Z  + -110.370743 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.132267   -2.009326  [ DEG:    64.8741   -115.1259 ]
  Theta =  -1.066736   -2.074856  [ DEG:   -61.1195   -118.8805 ]
  Phi   =   0.359572   -2.782021  [ DEG:    20.6019   -159.3981 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xf5_L                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xf5_L.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   71   56   5.0   54   1.84   14.81  87.641
REMARK  ---------------------------------------------------------- 
MOLECULE 1xf5_L
HEADER    IMMUNE SYSTEM                           14-SEP-04   1XF5              
TITLE     COMPLEX HCV CORE-FAB 19D9D6-PROTEIN L MUTANT (H74C, Y64W)IN           
TITLE    2 SPACE GROUP P21212                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CAPSID PROTEIN C;                                          
COMPND   3 CHAIN: P, Q;                                                         
COMPND   4 FRAGMENT: RESIDUES 2-45;                                             
COMPND   5 SYNONYM: CORE PROTEIN;                                               
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: MONOCLONAL ANTIBODY 19D9D6 LIGHT CHAIN;                    
COMPND   9 CHAIN: A, C;                                                         
COMPND  10 MOL_ID: 3;                                                           
COMPND  11 MOLECULE: MONOCLONAL ANTIBODY 19D9D6 HEAVY CHAIN;                    
COMPND  12 CHAIN: B, D;                                                         
COMPND  13 MOL_ID: 4;                                                           
COMPND  14 MOLECULE: PROTEIN L;                                                 
COMPND  15 CHAIN: L, M;                                                         
COMPND  16 ENGINEERED: YES;                                                     
COMPND  17 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 SYNTHETIC: YES;                                                      
SOURCE   3 OTHER_DETAILS: THIS SEQUENCE OCCURS NATURALLY IN HCV;                
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   6 ORGANISM_COMMON: MOUSE;                                              
SOURCE   7 MOL_ID: 3;                                                           
SOURCE   8 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   9 ORGANISM_COMMON: MOUSE;                                              
SOURCE  10 MOL_ID: 4;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PEPTOSTREPTOCOCCUS MAGNUS;                      
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  14 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PKK223-3                                  
KEYWDS    CRYSTAL PACKING, FAB, PROTEIN L, PEPTIDE COMPLEX                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.MENEZ,N.G.HOUSDEN,S.HARRISON,C.JOLIVET-REYNAUD,M.G.GORE,            
AUTHOR   2 E.A.STURA                                                            
REVDAT   1   31-MAY-05 1XF5    0                                                
JRNL        AUTH   R.MENEZ,N.G.HOUSDEN,S.HARRISON,C.JOLIVET-REYNAUD,            
JRNL        AUTH 2 M.G.GORE,E.A.STURA                                           
JRNL        TITL   DIFFERENT CRYSTAL PACKING IN FAB-PROTEIN L                   
JRNL        TITL 2 SEMI-DISORDERED PEPTIDE COMPLEX.                             
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  61   744 2005              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1XF5 P    2    45  UNP    P26661   POLG_HCVJ8       1     44             
DBREF  1XF5 Q    2    45  UNP    P26661   POLG_HCVJ8       1     44             
SEQRES   1 P   44  SER THR ASN PRO LYS PRO GLN ARG LYS THR LYS ARG ASN          
SEQRES   2 P   44  THR ASN ARG ARG PRO GLN ASP VAL LYS PHE PRO GLY GLY          
SEQRES   3 P   44  GLY GLN ILE VAL GLY GLY VAL TYR LEU LEU PRO ARG ARG          
SEQRES   4 P   44  GLY PRO ARG LEU GLY                                          
SEQRES   1 Q   44  SER THR ASN PRO LYS PRO GLN ARG LYS THR LYS ARG ASN          
SEQRES   2 Q   44  THR ASN ARG ARG PRO GLN ASP VAL LYS PHE PRO GLY GLY          
SEQRES   3 Q   44  GLY GLN ILE VAL GLY GLY VAL TYR LEU LEU PRO ARG ARG          
SEQRES   4 Q   44  GLY PRO ARG LEU GLY                                          
SEQRES   1 A  220  ASP ILE VAL MET SER GLN SER PRO SER SER LEU ALA VAL          
SEQRES   2 A  220  SER ALA GLY GLU LYS VAL THR MET SER CYS LYS SER SER          
SEQRES   3 A  220  GLN SER LEU LEU ASN SER ARG THR ARG LYS ASN TYR LEU          
SEQRES   4 A  220  ALA TRP TYR GLN GLN LYS PRO GLY GLN SER PRO LYS VAL          
SEQRES   5 A  220  LEU ILE TYR TRP ALA SER THR ARG GLU SER GLY VAL PRO          
SEQRES   6 A  220  ASP ARG PHE THR GLY ARG GLY SER GLY THR ASP PHE THR          
SEQRES   7 A  220  LEU THR ILE SER SER VAL GLN ALA GLU ASP GLN ALA VAL          
SEQRES   8 A  220  TYR TYR CYS LYS GLN ALA TYR ILE PRO PRO LEU THR PHE          
SEQRES   9 A  220  GLY ALA GLY THR LYS LEU GLU LEU LYS ARG ALA ASP ALA          
SEQRES  10 A  220  ALA PRO THR VAL SER ILE PHE PRO PRO SER SER GLU GLN          
SEQRES  11 A  220  LEU THR SER GLY GLY ALA SER VAL VAL CYS PHE LEU ASN          
SEQRES  12 A  220  ASN PHE TYR PRO LYS ASP ILE ASN VAL LYS TRP LYS ILE          
SEQRES  13 A  220  ASP GLY SER GLU ARG GLN ASN GLY VAL LEU ASN SER TRP          
SEQRES  14 A  220  THR ASP GLN ASP SER LYS ASP SER THR TYR SER MET SER          
SEQRES  15 A  220  SER THR LEU THR LEU THR LYS ASP GLU TYR GLU ARG HIS          
SEQRES  16 A  220  ASN SER TYR THR CYS GLU ALA THR HIS LYS THR SER THR          
SEQRES  17 A  220  SER PRO ILE VAL LYS SER PHE ASN ARG ASN GLU CYS              
SEQRES   1 B  218  GLN ILE GLN LEU VAL GLN SER GLY PRO GLU LEU LYS LYS          
SEQRES   2 B  218  PRO GLY GLU THR VAL LYS ILE SER CYS LYS ALA SER GLY          
SEQRES   3 B  218  TYR THR PHE THR ASP PHE SER MET HIS TRP VAL ASN GLN          
SEQRES   4 B  218  ALA PRO GLY LYS GLY LEU ASN TRP MET GLY TRP VAL ASN          
SEQRES   5 B  218  THR GLU THR GLY GLU PRO THR TYR ALA ASP ASP PHE LYS          
SEQRES   6 B  218  GLY ARG PHE ALA PHE SER LEU GLU THR SER ALA SER THR          
SEQRES   7 B  218  ALA TYR LEU GLN ILE ASN SER LEU LYS ASN GLU ASP THR          
SEQRES   8 B  218  ALA THR TYR PHE CYS ALA ARG PHE LEU LEU ARG GLN TYR          
SEQRES   9 B  218  PHE ASP VAL TRP GLY ALA GLY THR THR VAL THR VAL SER          
SEQRES  10 B  218  SER ALA LYS THR THR PRO PRO SER VAL TYR PRO LEU ALA          
SEQRES  11 B  218  PRO GLY SER ALA ALA GLN THR ASN SER MET VAL THR LEU          
SEQRES  12 B  218  GLY CYS LEU VAL LYS GLY TYR PHE PRO GLU PRO VAL THR          
SEQRES  13 B  218  VAL THR TRP ASN SER GLY SER LEU SER SER GLY VAL HIS          
SEQRES  14 B  218  THR PHE PRO ALA VAL LEU GLN SER ASP LEU TYR THR LEU          
SEQRES  15 B  218  SER SER SER VAL THR VAL PRO SER SER THR TRP PRO SER          
SEQRES  16 B  218  GLU THR VAL THR CYS ASN VAL ALA HIS PRO ALA SER SER          
SEQRES  17 B  218  THR LYS VAL ASP LYS LYS ILE VAL PRO ARG                      
SEQRES   1 L   80  MET ASN ILE LYS PHE ALA GLY LYS GLU LYS THR PRO GLU          
SEQRES   2 L   80  GLU PRO LYS GLU GLU VAL THR ILE LYS VAL ASN LEU ILE          
SEQRES   3 L   80  PHE ALA ASP GLY LYS ILE GLN THR ALA GLU PHE LYS GLY          
SEQRES   4 L   80  THR PHE GLU GLU ALA THR ALA GLU ALA TYR ARG TYR ALA          
SEQRES   5 L   80  ASP LEU LEU ALA LYS VAL ASN GLY GLU TRP THR ALA ASP          
SEQRES   6 L   80  LEU GLU ASP GLY GLY ASN CYS MET ASN ILE LYS PHE ALA          
SEQRES   7 L   80  GLY LYS                                                      
SEQRES   1 C  220  ASP ILE VAL MET SER GLN SER PRO SER SER LEU ALA VAL          
SEQRES   2 C  220  SER ALA GLY GLU LYS VAL THR MET SER CYS LYS SER SER          
SEQRES   3 C  220  GLN SER LEU LEU ASN SER ARG THR ARG LYS ASN TYR LEU          
SEQRES   4 C  220  ALA TRP TYR GLN GLN LYS PRO GLY GLN SER PRO LYS VAL          
SEQRES   5 C  220  LEU ILE TYR TRP ALA SER THR ARG GLU SER GLY VAL PRO          
SEQRES   6 C  220  ASP ARG PHE THR GLY ARG GLY SER GLY THR ASP PHE THR          
SEQRES   7 C  220  LEU THR ILE SER SER VAL GLN ALA GLU ASP GLN ALA VAL          
SEQRES   8 C  220  TYR TYR CYS LYS GLN ALA TYR ILE PRO PRO LEU THR PHE          
SEQRES   9 C  220  GLY ALA GLY THR LYS LEU GLU LEU LYS ARG ALA ASP ALA          
SEQRES  10 C  220  ALA PRO THR VAL SER ILE PHE PRO PRO SER SER GLU GLN          
SEQRES  11 C  220  LEU THR SER GLY GLY ALA SER VAL VAL CYS PHE LEU ASN          
SEQRES  12 C  220  ASN PHE TYR PRO LYS ASP ILE ASN VAL LYS TRP LYS ILE          
SEQRES  13 C  220  ASP GLY SER GLU ARG GLN ASN GLY VAL LEU ASN SER TRP          
SEQRES  14 C  220  THR ASP GLN ASP SER LYS ASP SER THR TYR SER MET SER          
SEQRES  15 C  220  SER THR LEU THR LEU THR LYS ASP GLU TYR GLU ARG HIS          
SEQRES  16 C  220  ASN SER TYR THR CYS GLU ALA THR HIS LYS THR SER THR          
SEQRES  17 C  220  SER PRO ILE VAL LYS SER PHE ASN ARG ASN GLU CYS              
SEQRES   1 D  218  GLN ILE GLN LEU VAL GLN SER GLY PRO GLU LEU LYS LYS          
SEQRES   2 D  218  PRO GLY GLU THR VAL LYS ILE SER CYS LYS ALA SER GLY          
SEQRES   3 D  218  TYR THR PHE THR ASP PHE SER MET HIS TRP VAL ASN GLN          
SEQRES   4 D  218  ALA PRO GLY LYS GLY LEU ASN TRP MET GLY TRP VAL ASN          
SEQRES   5 D  218  THR GLU THR GLY GLU PRO THR TYR ALA ASP ASP PHE LYS          
SEQRES   6 D  218  GLY ARG PHE ALA PHE SER LEU GLU THR SER ALA SER THR          
SEQRES   7 D  218  ALA TYR LEU GLN ILE ASN SER LEU LYS ASN GLU ASP THR          
SEQRES   8 D  218  ALA THR TYR PHE CYS ALA ARG PHE LEU LEU ARG GLN TYR          
SEQRES   9 D  218  PHE ASP VAL TRP GLY ALA GLY THR THR VAL THR VAL SER          
SEQRES  10 D  218  SER ALA LYS THR THR PRO PRO SER VAL TYR PRO LEU ALA          
SEQRES  11 D  218  PRO GLY SER ALA ALA GLN THR ASN SER MET VAL THR LEU          
SEQRES  12 D  218  GLY CYS LEU VAL LYS GLY TYR PHE PRO GLU PRO VAL THR          
SEQRES  13 D  218  VAL THR TRP ASN SER GLY SER LEU SER SER GLY VAL HIS          
SEQRES  14 D  218  THR PHE PRO ALA VAL LEU GLN SER ASP LEU TYR THR LEU          
SEQRES  15 D  218  SER SER SER VAL THR VAL PRO SER SER THR TRP PRO SER          
SEQRES  16 D  218  GLU THR VAL THR CYS ASN VAL ALA HIS PRO ALA SER SER          
SEQRES  17 D  218  THR LYS VAL ASP LYS LYS ILE VAL PRO ARG                      
SEQRES   1 M   80  MET ASN ILE LYS PHE ALA GLY LYS GLU LYS THR PRO GLU          
SEQRES   2 M   80  GLU PRO LYS GLU GLU VAL THR ILE LYS VAL ASN LEU ILE          
SEQRES   3 M   80  PHE ALA ASP GLY LYS ILE GLN THR ALA GLU PHE LYS GLY          
SEQRES   4 M   80  THR PHE GLU GLU ALA THR ALA GLU ALA TYR ARG TYR ALA          
SEQRES   5 M   80  ASP LEU LEU ALA LYS VAL ASN GLY GLU TRP THR ALA ASP          
SEQRES   6 M   80  LEU GLU ASP GLY GLY ASN CYS MET ASN ILE LYS PHE ALA          
SEQRES   7 M   80  GLY LYS                                                      
FORMUL   9  HOH   *446(H2 O)                                                    
CRYST1  129.337  222.928   43.624  90.00  90.00  90.00 P 21 21 2     8          
ATOM   3547  N   LYS L  12       5.471 -10.077  21.232  1.00136.22           N  
ATOM   3548  CA  LYS L  12       5.430 -11.426  21.847  1.00136.42           C  
ATOM   3549  C   LYS L  12       5.949 -12.554  20.937  1.00136.54           C  
ATOM   3550  O   LYS L  12       6.389 -13.594  21.426  1.00136.53           O  
ATOM   3551  CB  LYS L  12       4.015 -11.725  22.339  1.00136.15           C  
ATOM   3552  N   THR L  13       5.921 -12.266  19.630  1.00136.73           N  
ATOM   3553  CA  THR L  13       6.324 -13.041  18.430  1.00136.74           C  
ATOM   3554  C   THR L  13       6.394 -14.565  18.231  1.00136.40           C  
ATOM   3555  O   THR L  13       7.429 -15.191  18.457  1.00136.85           O  
ATOM   3556  CB  THR L  13       7.611 -12.434  17.877  1.00136.81           C  
ATOM   3557  N   PRO L  14       5.305 -15.165  17.713  1.00135.70           N  
ATOM   3558  CA  PRO L  14       5.204 -16.591  17.447  1.00134.95           C  
ATOM   3559  C   PRO L  14       6.382 -17.540  17.397  1.00134.02           C  
ATOM   3560  O   PRO L  14       7.341 -17.335  16.642  1.00134.27           O  
ATOM   3561  CB  PRO L  14       4.483 -16.630  16.100  1.00135.12           C  
ATOM   3562  CG  PRO L  14       3.516 -15.482  16.190  1.00135.07           C  
ATOM   3563  CD  PRO L  14       4.020 -14.544  17.319  1.00135.44           C  
ATOM   3564  N   GLU L  15       6.362 -18.554  18.246  1.00132.18           N  
ATOM   3565  CA  GLU L  15       7.342 -19.549  17.943  1.00130.15           C  
ATOM   3566  C   GLU L  15       6.617 -20.848  17.616  1.00128.75           C  
ATOM   3567  O   GLU L  15       7.085 -21.931  17.929  1.00128.54           O  
ATOM   3568  CB  GLU L  15       8.571 -19.741  18.883  1.00130.25           C  
ATOM   3569  CG  GLU L  15       8.662 -19.099  20.250  1.00130.13           C  
ATOM   3570  CD  GLU L  15       9.468 -17.796  20.308  1.00129.96           C  
ATOM   3571  OE1 GLU L  15      10.503 -17.643  19.615  1.00129.63           O  
ATOM   3572  OE2 GLU L  15       9.057 -16.923  21.097  1.00130.01           O  
ATOM   3573  N   GLU L  16       5.420 -20.714  17.035  1.00127.00           N  
ATOM   3574  CA  GLU L  16       4.715 -21.860  16.459  1.00124.80           C  
ATOM   3575  C   GLU L  16       4.273 -21.343  15.104  1.00123.32           C  
ATOM   3576  O   GLU L  16       4.993 -21.567  14.125  1.00123.52           O  
ATOM   3577  CB  GLU L  16       3.512 -22.407  17.241  1.00124.40           C  
ATOM   3578  CG  GLU L  16       3.921 -23.586  18.071  1.00123.77           C  
ATOM   3579  CD  GLU L  16       4.611 -23.094  19.296  1.00123.92           C  
ATOM   3580  OE1 GLU L  16       5.312 -23.867  19.980  1.00124.03           O  
ATOM   3581  OE2 GLU L  16       4.422 -21.894  19.574  1.00123.89           O  
ATOM   3582  N   PRO L  17       3.131 -20.611  15.009  1.00121.57           N  
ATOM   3583  CA  PRO L  17       3.101 -20.331  13.590  1.00119.55           C  
ATOM   3584  C   PRO L  17       2.917 -18.963  12.919  1.00117.30           C  
ATOM   3585  O   PRO L  17       2.224 -18.016  13.331  1.00117.06           O  
ATOM   3586  CB  PRO L  17       2.111 -21.379  13.082  1.00119.87           C  
ATOM   3587  CG  PRO L  17       1.148 -21.547  14.244  1.00120.48           C  
ATOM   3588  CD  PRO L  17       1.747 -20.808  15.451  1.00121.14           C  
ATOM   3589  N   LYS L  18       3.707 -19.047  11.873  1.00114.44           N  
ATOM   3590  CA  LYS L  18       4.159 -18.344  10.712  1.00110.71           C  
ATOM   3591  C   LYS L  18       4.186 -17.049   9.978  1.00107.62           C  
ATOM   3592  O   LYS L  18       4.165 -15.960  10.525  1.00107.55           O  
ATOM   3593  CB  LYS L  18       3.992 -19.430   9.668  1.00110.88           C  
ATOM   3594  CG  LYS L  18       5.113 -20.454   9.843  1.00110.33           C  
ATOM   3595  CD  LYS L  18       5.589 -20.628  11.340  1.00109.34           C  
ATOM   3596  CE  LYS L  18       6.325 -19.397  11.989  1.00108.90           C  
ATOM   3597  NZ  LYS L  18       5.852 -19.039  13.389  1.00108.56           N  
ATOM   3598  N   GLU L  19       4.581 -17.337   8.740  1.00103.46           N  
ATOM   3599  CA  GLU L  19       4.751 -16.527   7.564  1.00 98.92           C  
ATOM   3600  C   GLU L  19       5.272 -15.128   7.523  1.00 94.57           C  
ATOM   3601  O   GLU L  19       4.650 -14.159   8.036  1.00 93.92           O  
ATOM   3602  CB  GLU L  19       3.464 -16.620   6.747  1.00100.45           C  
ATOM   3603  CG  GLU L  19       3.451 -15.862   5.428  1.00102.39           C  
ATOM   3604  CD  GLU L  19       3.033 -16.735   4.262  1.00103.39           C  
ATOM   3605  OE1 GLU L  19       3.864 -17.565   3.834  1.00103.47           O  
ATOM   3606  OE2 GLU L  19       1.884 -16.590   3.781  1.00103.82           O  
ATOM   3607  N   GLU L  20       6.448 -14.992   6.893  1.00 89.08           N  
ATOM   3608  CA  GLU L  20       6.983 -13.581   6.722  1.00 83.71           C  
ATOM   3609  C   GLU L  20       6.533 -13.168   5.361  1.00 80.16           C  
ATOM   3610  O   GLU L  20       7.098 -13.688   4.409  1.00 79.76           O  
ATOM   3611  CB  GLU L  20       8.514 -13.538   6.745  1.00 82.97           C  
ATOM   3612  CG  GLU L  20       9.028 -13.471   8.197  1.00 81.95           C  
ATOM   3613  CD  GLU L  20       8.328 -12.415   9.071  1.00 81.09           C  
ATOM   3614  OE1 GLU L  20       8.808 -11.261   9.134  1.00 80.68           O  
ATOM   3615  OE2 GLU L  20       7.294 -12.748   9.694  1.00 80.74           O  
ATOM   3616  N   VAL L  21       5.362 -12.463   5.246  1.00 75.36           N  
ATOM   3617  CA  VAL L  21       4.905 -12.191   3.937  1.00 71.11           C  
ATOM   3618  C   VAL L  21       5.473 -10.906   3.429  1.00 67.73           C  
ATOM   3619  O   VAL L  21       6.197 -10.183   4.133  1.00 67.12           O  
ATOM   3620  CB  VAL L  21       3.417 -12.272   3.927  1.00 70.89           C  
ATOM   3621  CG1 VAL L  21       2.801 -11.159   4.781  1.00 69.29           C  
ATOM   3622  CG2 VAL L  21       2.993 -12.311   2.562  1.00 70.24           C  
ATOM   3623  N   THR L  22       5.222 -10.693   2.152  1.00 63.24           N  
ATOM   3624  CA  THR L  22       5.653  -9.482   1.495  1.00 58.56           C  
ATOM   3625  C   THR L  22       4.475  -8.886   0.721  1.00 55.89           C  
ATOM   3626  O   THR L  22       3.987  -9.484  -0.238  1.00 56.09           O  
ATOM   3627  CB  THR L  22       6.806  -9.716   0.502  1.00 57.32           C  
ATOM   3628  OG1 THR L  22       7.919 -10.308   1.177  1.00 57.80           O  
ATOM   3629  CG2 THR L  22       7.248  -8.382  -0.087  1.00 55.97           C  
ATOM   3630  N   ILE L  23       4.020  -7.708   1.137  1.00 52.36           N  
ATOM   3631  CA  ILE L  23       2.915  -7.035   0.460  1.00 49.10           C  
ATOM   3632  C   ILE L  23       3.455  -6.013  -0.544  1.00 46.12           C  
ATOM   3633  O   ILE L  23       4.055  -5.019  -0.154  1.00 44.81           O  
ATOM   3634  CB  ILE L  23       2.011  -6.274   1.453  1.00 50.74           C  
ATOM   3635  CG1 ILE L  23       1.437  -7.224   2.509  1.00 53.20           C  
ATOM   3636  CG2 ILE L  23       0.908  -5.565   0.686  1.00 50.90           C  
ATOM   3637  CD1 ILE L  23       0.554  -8.329   1.958  1.00 58.14           C  
ATOM   3638  N   LYS L  24       3.235  -6.250  -1.833  1.00 43.89           N  
ATOM   3639  CA  LYS L  24       3.708  -5.325  -2.863  1.00 42.15           C  
ATOM   3640  C   LYS L  24       2.645  -4.265  -3.160  1.00 39.83           C  
ATOM   3641  O   LYS L  24       1.492  -4.587  -3.442  1.00 38.61           O  
ATOM   3642  CB  LYS L  24       4.087  -6.095  -4.132  1.00 41.87           C  
ATOM   3643  CG  LYS L  24       5.203  -7.099  -3.900  1.00 43.53           C  
ATOM   3644  CD  LYS L  24       5.693  -7.735  -5.188  1.00 46.86           C  
ATOM   3645  CE  LYS L  24       6.825  -8.719  -4.910  1.00 49.50           C  
ATOM   3646  NZ  LYS L  24       7.349  -9.393  -6.142  1.00 51.15           N  
ATOM   3647  N   VAL L  25       3.050  -2.999  -3.109  1.00 37.06           N  
ATOM   3648  CA  VAL L  25       2.125  -1.894  -3.307  1.00 34.76           C  
ATOM   3649  C   VAL L  25       2.491  -0.897  -4.389  1.00 33.66           C  
ATOM   3650  O   VAL L  25       3.652  -0.553  -4.561  1.00 35.58           O  
ATOM   3651  CB  VAL L  25       1.964  -1.097  -1.997  1.00 34.11           C  
ATOM   3652  CG1 VAL L  25       1.004   0.054  -2.192  1.00 35.03           C  
ATOM   3653  CG2 VAL L  25       1.481  -2.009  -0.899  1.00 35.40           C  
ATOM   3654  N   ASN L  26       1.477  -0.434  -5.114  1.00 33.15           N  
ATOM   3655  CA  ASN L  26       1.649   0.585  -6.144  1.00 32.73           C  
ATOM   3656  C   ASN L  26       1.045   1.853  -5.553  1.00 31.35           C  
ATOM   3657  O   ASN L  26      -0.095   1.841  -5.097  1.00 31.82           O  
ATOM   3658  CB  ASN L  26       0.890   0.230  -7.423  1.00 32.26           C  
ATOM   3659  CG  ASN L  26       1.718  -0.582  -8.383  1.00 33.25           C  
ATOM   3660  OD1 ASN L  26       2.903  -0.315  -8.568  1.00 33.54           O  
ATOM   3661  ND2 ASN L  26       1.093  -1.568  -9.023  1.00 35.15           N  
ATOM   3662  N   LEU L  27       1.804   2.939  -5.546  1.00 29.52           N  
ATOM   3663  CA  LEU L  27       1.311   4.192  -4.997  1.00 29.92           C  
ATOM   3664  C   LEU L  27       1.040   5.130  -6.157  1.00 31.26           C  
ATOM   3665  O   LEU L  27       1.966   5.675  -6.775  1.00 32.42           O  
ATOM   3666  CB  LEU L  27       2.348   4.782  -4.040  1.00 28.86           C  
ATOM   3667  CG  LEU L  27       2.698   3.842  -2.877  1.00 29.21           C  
ATOM   3668  CD1 LEU L  27       4.079   4.158  -2.344  1.00 27.18           C  
ATOM   3669  CD2 LEU L  27       1.638   3.956  -1.783  1.00 25.73           C  
ATOM   3670  N   ILE L  28      -0.242   5.299  -6.459  1.00 30.91           N  
ATOM   3671  CA  ILE L  28      -0.673   6.146  -7.567  1.00 30.38           C  
ATOM   3672  C   ILE L  28      -1.154   7.496  -7.059  1.00 31.11           C  
ATOM   3673  O   ILE L  28      -2.091   7.571  -6.264  1.00 32.12           O  
ATOM   3674  CB  ILE L  28      -1.808   5.454  -8.347  1.00 29.54           C  
ATOM   3675  CG1 ILE L  28      -1.370   4.037  -8.734  1.00 28.60           C  
ATOM   3676  CG2 ILE L  28      -2.183   6.281  -9.562  1.00 29.19           C  
ATOM   3677  CD1 ILE L  28      -2.485   3.159  -9.216  1.00 29.57           C  
ATOM   3678  N   PHE L  29      -0.515   8.564  -7.520  1.00 32.83           N  
ATOM   3679  CA  PHE L  29      -0.881   9.911  -7.092  1.00 36.25           C  
ATOM   3680  C   PHE L  29      -1.731  10.649  -8.126  1.00 38.28           C  
ATOM   3681  O   PHE L  29      -1.671  10.356  -9.322  1.00 39.59           O  
ATOM   3682  CB  PHE L  29       0.381  10.722  -6.776  1.00 36.23           C  
ATOM   3683  CG  PHE L  29       1.220  10.131  -5.675  1.00 37.15           C  
ATOM   3684  CD1 PHE L  29       2.104   9.091  -5.932  1.00 37.19           C  
ATOM   3685  CD2 PHE L  29       1.128  10.618  -4.375  1.00 38.21           C  
ATOM   3686  CE1 PHE L  29       2.883   8.545  -4.910  1.00 37.38           C  
ATOM   3687  CE2 PHE L  29       1.908  10.072  -3.344  1.00 37.76           C  
ATOM   3688  CZ  PHE L  29       2.784   9.040  -3.616  1.00 36.73           C  
ATOM   3689  N   ALA L  30      -2.519  11.611  -7.662  1.00 38.95           N  
ATOM   3690  CA  ALA L  30      -3.385  12.370  -8.556  1.00 39.98           C  
ATOM   3691  C   ALA L  30      -2.639  12.971  -9.748  1.00 41.12           C  
ATOM   3692  O   ALA L  30      -3.120  12.907 -10.876  1.00 41.33           O  
ATOM   3693  CB  ALA L  30      -4.093  13.467  -7.781  1.00 39.26           C  
ATOM   3694  N   ASP L  31      -1.465  13.547  -9.503  1.00 42.30           N  
ATOM   3695  CA  ASP L  31      -0.698  14.165 -10.578  1.00 43.45           C  
ATOM   3696  C   ASP L  31      -0.176  13.170 -11.615  1.00 43.61           C  
ATOM   3697  O   ASP L  31       0.443  13.570 -12.598  1.00 44.30           O  
ATOM   3698  CB  ASP L  31       0.470  14.977 -10.011  1.00 45.83           C  
ATOM   3699  CG  ASP L  31       1.581  14.104  -9.463  1.00 51.09           C  
ATOM   3700  OD1 ASP L  31       2.112  13.271 -10.231  1.00 53.44           O  
ATOM   3701  OD2 ASP L  31       1.931  14.252  -8.270  1.00 54.75           O  
ATOM   3702  N   GLY L  32      -0.409  11.880 -11.392  1.00 43.29           N  
ATOM   3703  CA  GLY L  32       0.034  10.879 -12.345  1.00 41.31           C  
ATOM   3704  C   GLY L  32       1.294  10.092 -12.014  1.00 41.72           C  
ATOM   3705  O   GLY L  32       1.571   9.074 -12.657  1.00 41.95           O  
ATOM   3706  N   LYS L  33       2.069  10.540 -11.031  1.00 39.34           N  
ATOM   3707  CA  LYS L  33       3.288   9.817 -10.676  1.00 37.99           C  
ATOM   3708  C   LYS L  33       2.992   8.519  -9.930  1.00 36.75           C  
ATOM   3709  O   LYS L  33       2.042   8.437  -9.152  1.00 35.85           O  
ATOM   3710  CB  LYS L  33       4.204  10.707  -9.836  1.00 37.68           C  
ATOM   3711  CG  LYS L  33       4.674  11.923 -10.586  1.00 38.79           C  
ATOM   3712  CD  LYS L  33       5.486  12.864  -9.721  1.00 41.99           C  
ATOM   3713  CE  LYS L  33       5.504  14.268 -10.335  1.00 45.10           C  
ATOM   3714  NZ  LYS L  33       5.851  14.263 -11.795  1.00 45.66           N  
ATOM   3715  N   ILE L  34       3.814   7.504 -10.182  1.00 35.79           N  
ATOM   3716  CA  ILE L  34       3.648   6.209  -9.535  1.00 34.48           C  
ATOM   3717  C   ILE L  34       4.907   5.779  -8.777  1.00 34.18           C  
ATOM   3718  O   ILE L  34       6.005   5.789  -9.328  1.00 34.09           O  
ATOM   3719  CB  ILE L  34       3.338   5.096 -10.570  1.00 35.73           C  
ATOM   3720  CG1 ILE L  34       2.106   5.466 -11.405  1.00 38.89           C  
ATOM   3721  CG2 ILE L  34       3.148   3.764  -9.846  1.00 31.50           C  
ATOM   3722  CD1 ILE L  34       0.850   5.710 -10.558  1.00 46.62           C  
ATOM   3723  N   GLN L  35       4.747   5.404  -7.515  1.00 32.09           N  
ATOM   3724  CA  GLN L  35       5.879   4.919  -6.742  1.00 30.63           C  
ATOM   3725  C   GLN L  35       5.569   3.491  -6.339  1.00 29.14           C  
ATOM   3726  O   GLN L  35       4.416   3.092  -6.314  1.00 29.60           O  
ATOM   3727  CB  GLN L  35       6.110   5.779  -5.500  1.00 29.89           C  
ATOM   3728  CG  GLN L  35       6.757   7.117  -5.792  1.00 29.04           C  
ATOM   3729  CD  GLN L  35       6.957   7.942  -4.545  1.00 27.91           C  
ATOM   3730  OE1 GLN L  35       7.322   9.111  -4.610  1.00 29.51           O  
ATOM   3731  NE2 GLN L  35       6.720   7.336  -3.400  1.00 27.35           N  
ATOM   3732  N   THR L  36       6.598   2.714  -6.043  1.00 30.09           N  
ATOM   3733  CA  THR L  36       6.407   1.330  -5.635  1.00 30.73           C  
ATOM   3734  C   THR L  36       6.959   1.136  -4.239  1.00 30.56           C  
ATOM   3735  O   THR L  36       7.977   1.720  -3.877  1.00 31.16           O  
ATOM   3736  CB  THR L  36       7.123   0.362  -6.602  1.00 32.24           C  
ATOM   3737  OG1 THR L  36       6.220  -0.014  -7.645  1.00 33.63           O  
ATOM   3738  CG2 THR L  36       7.609  -0.880  -5.874  1.00 34.65           C  
ATOM   3739  N   ALA L  37       6.287   0.309  -3.454  1.00 30.73           N  
ATOM   3740  CA  ALA L  37       6.733   0.049  -2.101  1.00 31.12           C  
ATOM   3741  C   ALA L  37       6.489  -1.398  -1.699  1.00 32.63           C  
ATOM   3742  O   ALA L  37       5.682  -2.103  -2.305  1.00 32.84           O  
ATOM   3743  CB  ALA L  37       6.031   0.979  -1.141  1.00 27.78           C  
ATOM   3744  N   GLU L  38       7.215  -1.833  -0.679  1.00 33.28           N  
ATOM   3745  CA  GLU L  38       7.080  -3.177  -0.167  1.00 34.28           C  
ATOM   3746  C   GLU L  38       7.008  -3.131   1.344  1.00 35.08           C  
ATOM   3747  O   GLU L  38       7.591  -2.254   1.972  1.00 35.78           O  
ATOM   3748  CB  GLU L  38       8.270  -4.031  -0.593  1.00 36.33           C  
ATOM   3749  CG  GLU L  38       8.266  -4.416  -2.058  1.00 39.41           C  
ATOM   3750  CD  GLU L  38       9.242  -5.540  -2.367  1.00 42.38           C  
ATOM   3751  OE1 GLU L  38       9.200  -6.071  -3.497  1.00 43.64           O  
ATOM   3752  OE2 GLU L  38      10.051  -5.897  -1.481  1.00 43.72           O  
ATOM   3753  N   PHE L  39       6.270  -4.068   1.925  1.00 36.81           N  
ATOM   3754  CA  PHE L  39       6.151  -4.165   3.372  1.00 38.96           C  
ATOM   3755  C   PHE L  39       6.335  -5.625   3.731  1.00 40.92           C  
ATOM   3756  O   PHE L  39       5.648  -6.489   3.198  1.00 41.70           O  
ATOM   3757  CB  PHE L  39       4.785  -3.680   3.840  1.00 37.55           C  
ATOM   3758  CG  PHE L  39       4.439  -2.306   3.366  1.00 36.48           C  
ATOM   3759  CD1 PHE L  39       3.936  -2.107   2.084  1.00 35.55           C  
ATOM   3760  CD2 PHE L  39       4.633  -1.203   4.193  1.00 35.42           C  
ATOM   3761  CE1 PHE L  39       3.623  -0.829   1.633  1.00 36.66           C  
ATOM   3762  CE2 PHE L  39       4.324   0.082   3.751  1.00 36.51           C  
ATOM   3763  CZ  PHE L  39       3.821   0.271   2.468  1.00 35.27           C  
ATOM   3764  N   LYS L  40       7.280  -5.905   4.619  1.00 44.61           N  
ATOM   3765  CA  LYS L  40       7.549  -7.279   5.027  1.00 47.26           C  
ATOM   3766  C   LYS L  40       7.031  -7.539   6.437  1.00 49.05           C  
ATOM   3767  O   LYS L  40       6.871  -6.610   7.232  1.00 49.77           O  
ATOM   3768  CB  LYS L  40       9.054  -7.551   4.978  1.00 47.59           C  
ATOM   3769  CG  LYS L  40       9.699  -7.375   3.613  1.00 48.50           C  
ATOM   3770  CD  LYS L  40       9.677  -8.666   2.815  1.00 51.94           C  
ATOM   3771  CE  LYS L  40      10.506  -8.552   1.534  1.00 53.33           C  
ATOM   3772  NZ  LYS L  40      11.953  -8.270   1.809  1.00 54.06           N  
ATOM   3773  N   GLY L  41       6.771  -8.805   6.745  1.00 51.83           N  
ATOM   3774  CA  GLY L  41       6.286  -9.162   8.068  1.00 54.78           C  
ATOM   3775  C   GLY L  41       5.154 -10.160   8.013  1.00 56.67           C  
ATOM   3776  O   GLY L  41       4.945 -10.813   6.995  1.00 55.62           O  
ATOM   3777  N   THR L  42       4.425 -10.294   9.114  1.00 60.41           N  
ATOM   3778  CA  THR L  42       3.297 -11.214   9.134  1.00 63.90           C  
ATOM   3779  C   THR L  42       2.229 -10.528   8.302  1.00 65.28           C  
ATOM   3780  O   THR L  42       2.253  -9.307   8.156  1.00 66.18           O  
ATOM   3781  CB  THR L  42       2.760 -11.438  10.557  1.00 64.36           C  
ATOM   3782  OG1 THR L  42       1.846 -12.543  10.548  1.00 65.85           O  
ATOM   3783  CG2 THR L  42       2.031 -10.206  11.051  1.00 64.26           C  
ATOM   3784  N   PHE L  43       1.293 -11.296   7.761  1.00 66.98           N  
ATOM   3785  CA  PHE L  43       0.253 -10.706   6.934  1.00 67.74           C  
ATOM   3786  C   PHE L  43      -0.508  -9.599   7.652  1.00 68.00           C  
ATOM   3787  O   PHE L  43      -0.859  -8.592   7.045  1.00 68.52           O  
ATOM   3788  CB  PHE L  43      -0.719 -11.777   6.440  1.00 68.89           C  
ATOM   3789  CG  PHE L  43      -1.561 -11.326   5.284  1.00 69.38           C  
ATOM   3790  CD1 PHE L  43      -2.658 -10.493   5.488  1.00 69.34           C  
ATOM   3791  CD2 PHE L  43      -1.209 -11.666   3.982  1.00 68.43           C  
ATOM   3792  CE1 PHE L  43      -3.381 -10.001   4.417  1.00 68.74           C  
ATOM   3793  CE2 PHE L  43      -1.931 -11.177   2.900  1.00 67.99           C  
ATOM   3794  CZ  PHE L  43      -3.019 -10.342   3.117  1.00 68.43           C  
ATOM   3795  N   GLU L  44      -0.758  -9.771   8.941  1.00 68.51           N  
ATOM   3796  CA  GLU L  44      -1.477  -8.751   9.691  1.00 70.17           C  
ATOM   3797  C   GLU L  44      -0.645  -7.474   9.808  1.00 69.01           C  
ATOM   3798  O   GLU L  44      -1.155  -6.374   9.602  1.00 69.48           O  
ATOM   3799  CB  GLU L  44      -1.813  -9.261  11.090  1.00 73.91           C  
ATOM   3800  CG  GLU L  44      -2.456 -10.638  11.117  1.00 78.95           C  
ATOM   3801  CD  GLU L  44      -2.681 -11.140  12.534  1.00 82.05           C  
ATOM   3802  OE1 GLU L  44      -3.487 -10.517  13.263  1.00 83.38           O  
ATOM   3803  OE2 GLU L  44      -2.046 -12.150  12.919  1.00 82.83           O  
ATOM   3804  N   GLU L  45       0.635  -7.633  10.145  1.00 67.66           N  
ATOM   3805  CA  GLU L  45       1.569  -6.514  10.306  1.00 65.13           C  
ATOM   3806  C   GLU L  45       1.735  -5.682   9.043  1.00 62.02           C  
ATOM   3807  O   GLU L  45       1.477  -4.478   9.034  1.00 61.28           O  
ATOM   3808  CB  GLU L  45       2.948  -7.036  10.707  1.00 67.01           C  
ATOM   3809  CG  GLU L  45       3.090  -7.484  12.143  1.00 69.30           C  
ATOM   3810  CD  GLU L  45       4.265  -8.427  12.319  1.00 70.51           C  
ATOM   3811  OE1 GLU L  45       4.762  -8.558  13.457  1.00 71.05           O  
ATOM   3812  OE2 GLU L  45       4.682  -9.045  11.315  1.00 70.24           O  
ATOM   3813  N   ALA L  46       2.195  -6.340   7.987  1.00 58.91           N  
ATOM   3814  CA  ALA L  46       2.417  -5.696   6.701  1.00 57.03           C  
ATOM   3815  C   ALA L  46       1.201  -4.922   6.186  1.00 55.65           C  
ATOM   3816  O   ALA L  46       1.341  -3.807   5.691  1.00 56.20           O  
ATOM   3817  CB  ALA L  46       2.842  -6.734   5.681  1.00 57.01           C  
ATOM   3818  N   THR L  47       0.013  -5.508   6.291  1.00 52.88           N  
ATOM   3819  CA  THR L  47      -1.190  -4.832   5.832  1.00 50.73           C  
ATOM   3820  C   THR L  47      -1.403  -3.557   6.644  1.00 49.02           C  
ATOM   3821  O   THR L  47      -1.743  -2.511   6.097  1.00 49.50           O  
ATOM   3822  CB  THR L  47      -2.438  -5.743   5.956  1.00 51.91           C  
ATOM   3823  OG1 THR L  47      -2.296  -6.874   5.085  1.00 50.56           O  
ATOM   3824  CG2 THR L  47      -3.709  -4.976   5.582  1.00 50.92           C  
ATOM   3825  N   ALA L  48      -1.192  -3.647   7.952  1.00 46.80           N  
ATOM   3826  CA  ALA L  48      -1.353  -2.495   8.831  1.00 45.26           C  
ATOM   3827  C   ALA L  48      -0.323  -1.419   8.494  1.00 45.04           C  
ATOM   3828  O   ALA L  48      -0.554  -0.229   8.715  1.00 44.28           O  
ATOM   3829  CB  ALA L  48      -1.202  -2.923  10.276  1.00 44.75           C  
ATOM   3830  N   GLU L  49       0.817  -1.852   7.962  1.00 44.63           N  
ATOM   3831  CA  GLU L  49       1.891  -0.944   7.569  1.00 43.94           C  
ATOM   3832  C   GLU L  49       1.451  -0.106   6.380  1.00 41.52           C  
ATOM   3833  O   GLU L  49       1.434   1.121   6.431  1.00 39.73           O  
ATOM   3834  CB  GLU L  49       3.127  -1.742   7.165  1.00 47.35           C  
ATOM   3835  CG  GLU L  49       3.693  -2.600   8.265  1.00 51.00           C  
ATOM   3836  CD  GLU L  49       4.366  -1.772   9.325  1.00 53.63           C  
ATOM   3837  OE1 GLU L  49       3.711  -0.853   9.862  1.00 54.74           O  
ATOM   3838  OE2 GLU L  49       5.551  -2.041   9.617  1.00 56.70           O  
ATOM   3839  N   ALA L  50       1.105  -0.800   5.302  1.00 39.75           N  
ATOM   3840  CA  ALA L  50       0.669  -0.160   4.076  1.00 38.34           C  
ATOM   3841  C   ALA L  50      -0.393   0.862   4.396  1.00 36.58           C  
ATOM   3842  O   ALA L  50      -0.331   1.988   3.930  1.00 34.80           O  
ATOM   3843  CB  ALA L  50       0.123  -1.199   3.117  1.00 39.64           C  
ATOM   3844  N   TYR L  51      -1.362   0.469   5.209  1.00 36.81           N  
ATOM   3845  CA  TYR L  51      -2.437   1.374   5.577  1.00 38.72           C  
ATOM   3846  C   TYR L  51      -1.928   2.634   6.273  1.00 39.24           C  
ATOM   3847  O   TYR L  51      -2.284   3.746   5.884  1.00 39.58           O  
ATOM   3848  CB  TYR L  51      -3.455   0.672   6.474  1.00 39.88           C  
ATOM   3849  CG  TYR L  51      -4.440  -0.233   5.762  1.00 42.48           C  
ATOM   3850  CD1 TYR L  51      -5.771  -0.289   6.175  1.00 45.76           C  
ATOM   3851  CD2 TYR L  51      -4.044  -1.060   4.713  1.00 43.41           C  
ATOM   3852  CE1 TYR L  51      -6.689  -1.144   5.565  1.00 47.88           C  
ATOM   3853  CE2 TYR L  51      -4.951  -1.926   4.092  1.00 45.74           C  
ATOM   3854  CZ  TYR L  51      -6.274  -1.963   4.525  1.00 48.44           C  
ATOM   3855  OH  TYR L  51      -7.194  -2.815   3.939  1.00 49.43           O  
ATOM   3856  N   ARG L  52      -1.105   2.473   7.305  1.00 40.68           N  
ATOM   3857  CA  ARG L  52      -0.581   3.640   8.017  1.00 40.90           C  
ATOM   3858  C   ARG L  52       0.204   4.506   7.044  1.00 38.40           C  
ATOM   3859  O   ARG L  52       0.027   5.719   7.006  1.00 37.16           O  
ATOM   3860  CB  ARG L  52       0.337   3.218   9.166  1.00 44.37           C  
ATOM   3861  CG  ARG L  52      -0.307   2.277  10.156  1.00 49.83           C  
ATOM   3862  CD  ARG L  52       0.630   1.960  11.313  1.00 53.94           C  
ATOM   3863  NE  ARG L  52       0.123   0.852  12.121  1.00 58.59           N  
ATOM   3864  CZ  ARG L  52       0.551  -0.407  12.030  1.00 59.56           C  
ATOM   3865  NH1 ARG L  52       1.508  -0.726  11.167  1.00 60.22           N  
ATOM   3866  NH2 ARG L  52       0.011  -1.353  12.792  1.00 59.89           N  
ATOM   3867  N   TYR L  53       1.071   3.873   6.258  1.00 36.43           N  
ATOM   3868  CA  TYR L  53       1.876   4.596   5.283  1.00 35.10           C  
ATOM   3869  C   TYR L  53       0.941   5.378   4.375  1.00 35.02           C  
ATOM   3870  O   TYR L  53       1.191   6.545   4.081  1.00 35.13           O  
ATOM   3871  CB  TYR L  53       2.727   3.631   4.451  1.00 33.38           C  
ATOM   3872  CG  TYR L  53       3.755   4.328   3.592  1.00 32.39           C  
ATOM   3873  CD1 TYR L  53       4.769   5.094   4.168  1.00 32.77           C  
ATOM   3874  CD2 TYR L  53       3.695   4.262   2.204  1.00 30.46           C  
ATOM   3875  CE1 TYR L  53       5.689   5.782   3.379  1.00 31.80           C  
ATOM   3876  CE2 TYR L  53       4.606   4.944   1.408  1.00 29.04           C  
ATOM   3877  CZ  TYR L  53       5.599   5.704   1.997  1.00 29.95           C  
ATOM   3878  OH  TYR L  53       6.490   6.399   1.208  1.00 29.24           O  
ATOM   3879  N   ALA L  54      -0.143   4.738   3.940  1.00 34.22           N  
ATOM   3880  CA  ALA L  54      -1.114   5.405   3.080  1.00 33.83           C  
ATOM   3881  C   ALA L  54      -1.651   6.623   3.827  1.00 33.35           C  
ATOM   3882  O   ALA L  54      -1.671   7.728   3.286  1.00 33.14           O  
ATOM   3883  CB  ALA L  54      -2.248   4.457   2.714  1.00 33.85           C  
ATOM   3884  N   ASP L  55      -2.081   6.426   5.068  1.00 33.24           N  
ATOM   3885  CA  ASP L  55      -2.574   7.547   5.861  1.00 36.18           C  
ATOM   3886  C   ASP L  55      -1.484   8.621   5.919  1.00 37.21           C  
ATOM   3887  O   ASP L  55      -1.745   9.804   5.715  1.00 37.00           O  
ATOM   3888  CB  ASP L  55      -2.900   7.116   7.296  1.00 37.08           C  
ATOM   3889  CG  ASP L  55      -4.032   6.114   7.371  1.00 38.58           C  
ATOM   3890  OD1 ASP L  55      -4.766   5.956   6.371  1.00 39.69           O  
ATOM   3891  OD2 ASP L  55      -4.193   5.494   8.443  1.00 38.47           O  
ATOM   3892  N   LEU L  56      -0.257   8.194   6.196  1.00 37.92           N  
ATOM   3893  CA  LEU L  56       0.865   9.111   6.298  1.00 37.42           C  
ATOM   3894  C   LEU L  56       1.035   9.910   5.008  1.00 36.99           C  
ATOM   3895  O   LEU L  56       1.256  11.115   5.034  1.00 36.84           O  
ATOM   3896  CB  LEU L  56       2.147   8.332   6.594  1.00 37.66           C  
ATOM   3897  CG  LEU L  56       3.219   9.010   7.453  1.00 39.04           C  
ATOM   3898  CD1 LEU L  56       4.555   8.366   7.140  1.00 38.55           C  
ATOM   3899  CD2 LEU L  56       3.291  10.510   7.182  1.00 37.79           C  
ATOM   3900  N   LEU L  57       0.930   9.232   3.874  1.00 37.66           N  
ATOM   3901  CA  LEU L  57       1.085   9.897   2.584  1.00 37.90           C  
ATOM   3902  C   LEU L  57      -0.142  10.717   2.212  1.00 37.63           C  
ATOM   3903  O   LEU L  57      -0.050  11.672   1.446  1.00 38.16           O  
ATOM   3904  CB  LEU L  57       1.365   8.867   1.486  1.00 36.97           C  
ATOM   3905  CG  LEU L  57       2.712   8.967   0.769  1.00 35.74           C  
ATOM   3906  CD1 LEU L  57       3.837   9.044   1.782  1.00 34.75           C  
ATOM   3907  CD2 LEU L  57       2.887   7.762  -0.145  1.00 36.82           C  
ATOM   3908  N   ALA L  58      -1.291  10.338   2.758  1.00 37.07           N  
ATOM   3909  CA  ALA L  58      -2.529  11.039   2.463  1.00 37.35           C  
ATOM   3910  C   ALA L  58      -2.537  12.430   3.084  1.00 37.73           C  
ATOM   3911  O   ALA L  58      -3.287  13.304   2.651  1.00 36.87           O  
ATOM   3912  CB  ALA L  58      -3.724  10.220   2.956  1.00 36.18           C  
ATOM   3913  N   LYS L  59      -1.696  12.631   4.096  1.00 40.05           N  
ATOM   3914  CA  LYS L  59      -1.596  13.922   4.774  1.00 41.94           C  
ATOM   3915  C   LYS L  59      -1.235  15.023   3.791  1.00 42.85           C  
ATOM   3916  O   LYS L  59      -1.542  16.182   4.025  1.00 45.06           O  
ATOM   3917  CB  LYS L  59      -0.538  13.877   5.886  1.00 43.94           C  
ATOM   3918  CG  LYS L  59      -0.953  13.087   7.134  1.00 45.81           C  
ATOM   3919  CD  LYS L  59       0.250  12.673   7.998  1.00 48.43           C  
ATOM   3920  CE  LYS L  59       1.014  13.857   8.596  1.00 49.77           C  
ATOM   3921  NZ  LYS L  59       0.267  14.536   9.699  1.00 51.27           N  
ATOM   3922  N   VAL L  60      -0.589  14.664   2.685  1.00 43.19           N  
ATOM   3923  CA  VAL L  60      -0.209  15.661   1.688  1.00 42.42           C  
ATOM   3924  C   VAL L  60      -0.761  15.380   0.292  1.00 41.38           C  
ATOM   3925  O   VAL L  60      -1.024  16.305  -0.475  1.00 42.45           O  
ATOM   3926  CB  VAL L  60       1.326  15.786   1.583  1.00 43.90           C  
ATOM   3927  CG1 VAL L  60       1.926  16.049   2.959  1.00 44.44           C  
ATOM   3928  CG2 VAL L  60       1.909  14.523   0.984  1.00 44.80           C  
ATOM   3929  N   ASN L  61      -0.953  14.113  -0.044  1.00 39.80           N  
ATOM   3930  CA  ASN L  61      -1.443  13.780  -1.369  1.00 38.06           C  
ATOM   3931  C   ASN L  61      -2.937  13.487  -1.442  1.00 38.44           C  
ATOM   3932  O   ASN L  61      -3.444  13.109  -2.493  1.00 37.54           O  
ATOM   3933  CB  ASN L  61      -0.647  12.603  -1.925  1.00 37.70           C  
ATOM   3934  CG  ASN L  61       0.852  12.838  -1.869  1.00 35.90           C  
ATOM   3935  OD1 ASN L  61       1.521  12.434  -0.920  1.00 35.54           O  
ATOM   3936  ND2 ASN L  61       1.384  13.505  -2.887  1.00 35.06           N  
ATOM   3937  N   GLY L  62      -3.639  13.648  -0.326  1.00 39.02           N  
ATOM   3938  CA  GLY L  62      -5.071  13.412  -0.325  1.00 39.41           C  
ATOM   3939  C   GLY L  62      -5.556  12.082   0.220  1.00 40.46           C  
ATOM   3940  O   GLY L  62      -4.769  11.200   0.548  1.00 40.60           O  
ATOM   3941  N   GLU L  63      -6.876  11.952   0.317  1.00 41.89           N  
ATOM   3942  CA  GLU L  63      -7.525  10.740   0.810  1.00 41.93           C  
ATOM   3943  C   GLU L  63      -7.219   9.594  -0.139  1.00 40.47           C  
ATOM   3944  O   GLU L  63      -7.156   9.788  -1.355  1.00 42.14           O  
ATOM   3945  CB  GLU L  63      -9.033  10.963   0.876  1.00 44.88           C  
ATOM   3946  CG  GLU L  63      -9.439  12.085   1.818  1.00 51.21           C  
ATOM   3947  CD  GLU L  63     -10.797  12.681   1.475  1.00 54.60           C  
ATOM   3948  OE1 GLU L  63     -11.782  11.916   1.348  1.00 56.65           O  
ATOM   3949  OE2 GLU L  63     -10.877  13.922   1.334  1.00 55.80           O  
ATOM   3950  N   TRP L  64      -7.036   8.398   0.406  1.00 37.70           N  
ATOM   3951  CA  TRP L  64      -6.724   7.251  -0.432  1.00 34.90           C  
ATOM   3952  C   TRP L  64      -7.800   6.177  -0.457  1.00 34.69           C  
ATOM   3953  O   TRP L  64      -8.596   6.046   0.471  1.00 34.75           O  
ATOM   3954  CB  TRP L  64      -5.401   6.611   0.005  1.00 31.55           C  
ATOM   3955  CG  TRP L  64      -5.449   5.947   1.362  1.00 28.79           C  
ATOM   3956  CD1 TRP L  64      -5.135   6.511   2.571  1.00 26.67           C  
ATOM   3957  CD2 TRP L  64      -5.843   4.596   1.643  1.00 26.64           C  
ATOM   3958  NE1 TRP L  64      -5.309   5.595   3.579  1.00 22.67           N  
ATOM   3959  CE2 TRP L  64      -5.744   4.414   3.040  1.00 24.09           C  
ATOM   3960  CE3 TRP L  64      -6.274   3.522   0.847  1.00 26.23           C  
ATOM   3961  CZ2 TRP L  64      -6.057   3.200   3.662  1.00 25.02           C  
ATOM   3962  CZ3 TRP L  64      -6.584   2.316   1.465  1.00 26.30           C  
ATOM   3963  CH2 TRP L  64      -6.475   2.166   2.863  1.00 25.31           C  
ATOM   3964  N   THR L  65      -7.805   5.420  -1.548  1.00 34.84           N  
ATOM   3965  CA  THR L  65      -8.718   4.306  -1.760  1.00 35.69           C  
ATOM   3966  C   THR L  65      -7.814   3.195  -2.287  1.00 37.65           C  
ATOM   3967  O   THR L  65      -6.708   3.472  -2.741  1.00 37.65           O  
ATOM   3968  CB  THR L  65      -9.798   4.656  -2.786  1.00 35.05           C  
ATOM   3969  OG1 THR L  65      -9.183   5.069  -4.016  1.00 36.10           O  
ATOM   3970  CG2 THR L  65     -10.678   5.774  -2.251  1.00 31.57           C  
ATOM   3971  N   ALA L  66      -8.261   1.945  -2.240  1.00 39.41           N  
ATOM   3972  CA  ALA L  66      -7.393   0.862  -2.681  1.00 41.47           C  
ATOM   3973  C   ALA L  66      -8.073  -0.316  -3.363  1.00 43.84           C  
ATOM   3974  O   ALA L  66      -9.283  -0.506  -3.254  1.00 43.96           O  
ATOM   3975  CB  ALA L  66      -6.591   0.355  -1.494  1.00 38.64           C  
ATOM   3976  N   ASP L  67      -7.262  -1.111  -4.053  1.00 46.19           N  
ATOM   3977  CA  ASP L  67      -7.730  -2.292  -4.757  1.00 49.41           C  
ATOM   3978  C   ASP L  67      -6.871  -3.469  -4.327  1.00 50.25           C  
ATOM   3979  O   ASP L  67      -5.679  -3.501  -4.614  1.00 51.78           O  
ATOM   3980  CB  ASP L  67      -7.599  -2.096  -6.271  1.00 52.08           C  
ATOM   3981  CG  ASP L  67      -8.498  -0.986  -6.802  1.00 55.49           C  
ATOM   3982  OD1 ASP L  67      -8.248  -0.502  -7.931  1.00 55.50           O  
ATOM   3983  OD2 ASP L  67      -9.460  -0.603  -6.095  1.00 56.93           O  
ATOM   3984  N   LEU L  68      -7.471  -4.432  -3.636  1.00 51.04           N  
ATOM   3985  CA  LEU L  68      -6.736  -5.608  -3.189  1.00 52.68           C  
ATOM   3986  C   LEU L  68      -6.792  -6.733  -4.209  1.00 53.96           C  
ATOM   3987  O   LEU L  68      -7.660  -6.755  -5.081  1.00 54.26           O  
ATOM   3988  CB  LEU L  68      -7.298  -6.132  -1.864  1.00 52.85           C  
ATOM   3989  CG  LEU L  68      -7.021  -5.350  -0.582  1.00 53.52           C  
ATOM   3990  CD1 LEU L  68      -5.530  -5.108  -0.464  1.00 53.24           C  
ATOM   3991  CD2 LEU L  68      -7.772  -4.039  -0.589  1.00 54.98           C  
ATOM   3992  N   GLU L  69      -5.852  -7.662  -4.096  1.00 55.40           N  
ATOM   3993  CA  GLU L  69      -5.795  -8.823  -4.968  1.00 57.66           C  
ATOM   3994  C   GLU L  69      -4.695  -9.749  -4.500  1.00 57.94           C  
ATOM   3995  O   GLU L  69      -3.862  -9.357  -3.693  1.00 57.40           O  
ATOM   3996  CB  GLU L  69      -5.583  -8.424  -6.429  1.00 58.62           C  
ATOM   3997  CG  GLU L  69      -4.601  -7.309  -6.667  1.00 62.12           C  
ATOM   3998  CD  GLU L  69      -4.519  -6.940  -8.138  1.00 64.17           C  
ATOM   3999  OE1 GLU L  69      -3.988  -7.753  -8.930  1.00 64.90           O  
ATOM   4000  OE2 GLU L  69      -5.001  -5.844  -8.503  1.00 64.77           O  
ATOM   4001  N   ASP L  70      -4.698 -10.977  -5.009  1.00 59.59           N  
ATOM   4002  CA  ASP L  70      -3.721 -11.977  -4.601  1.00 60.78           C  
ATOM   4003  C   ASP L  70      -3.882 -12.194  -3.101  1.00 60.30           C  
ATOM   4004  O   ASP L  70      -2.905 -12.297  -2.360  1.00 59.14           O  
ATOM   4005  CB  ASP L  70      -2.293 -11.521  -4.927  1.00 64.21           C  
ATOM   4006  CG  ASP L  70      -1.807 -12.036  -6.277  1.00 67.96           C  
ATOM   4007  OD1 ASP L  70      -1.772 -13.276  -6.453  1.00 70.14           O  
ATOM   4008  OD2 ASP L  70      -1.459 -11.212  -7.158  1.00 68.51           O  
ATOM   4009  N   GLY L  71      -5.137 -12.251  -2.666  1.00 59.68           N  
ATOM   4010  CA  GLY L  71      -5.432 -12.460  -1.261  1.00 60.11           C  
ATOM   4011  C   GLY L  71      -5.099 -11.260  -0.397  1.00 59.88           C  
ATOM   4012  O   GLY L  71      -5.195 -11.322   0.831  1.00 60.07           O  
ATOM   4013  N   GLY L  72      -4.717 -10.162  -1.043  1.00 58.95           N  
ATOM   4014  CA  GLY L  72      -4.356  -8.960  -0.313  1.00 57.37           C  
ATOM   4015  C   GLY L  72      -2.850  -8.767  -0.310  1.00 56.53           C  
ATOM   4016  O   GLY L  72      -2.323  -7.937   0.433  1.00 54.91           O  
ATOM   4017  N   ASN L  73      -2.166  -9.546  -1.146  1.00 55.91           N  
ATOM   4018  CA  ASN L  73      -0.713  -9.490  -1.277  1.00 56.19           C  
ATOM   4019  C   ASN L  73      -0.271  -8.499  -2.351  1.00 55.33           C  
ATOM   4020  O   ASN L  73       0.891  -8.487  -2.763  1.00 54.66           O  
ATOM   4021  CB  ASN L  73      -0.161 -10.875  -1.618  1.00 58.78           C  
ATOM   4022  CG  ASN L  73      -0.400 -11.880  -0.512  1.00 61.29           C  
ATOM   4023  OD1 ASN L  73      -0.047 -11.639   0.643  1.00 61.26           O  
ATOM   4024  ND2 ASN L  73      -0.998 -13.015  -0.860  1.00 63.06           N  
ATOM   4025  N   CYS L  74      -1.208  -7.674  -2.802  1.00 53.65           N  
ATOM   4026  CA  CYS L  74      -0.933  -6.681  -3.827  1.00 51.96           C  
ATOM   4027  C   CYS L  74      -1.946  -5.562  -3.640  1.00 49.00           C  
ATOM   4028  O   CYS L  74      -3.144  -5.814  -3.594  1.00 49.97           O  
ATOM   4029  CB  CYS L  74      -1.083  -7.313  -5.214  1.00 53.33           C  
ATOM   4030  SG  CYS L  74      -0.602  -6.245  -6.590  1.00 63.80           S  
ATOM   4031  N   MET L  75      -1.466  -4.330  -3.510  1.00 46.48           N  
ATOM   4032  CA  MET L  75      -2.348  -3.183  -3.321  1.00 43.36           C  
ATOM   4033  C   MET L  75      -2.153  -2.079  -4.350  1.00 42.84           C  
ATOM   4034  O   MET L  75      -1.029  -1.758  -4.731  1.00 42.79           O  
ATOM   4035  CB  MET L  75      -2.145  -2.573  -1.936  1.00 42.03           C  
ATOM   4036  CG  MET L  75      -2.739  -3.358  -0.805  1.00 43.05           C  
ATOM   4037  SD  MET L  75      -2.577  -2.468   0.733  1.00 45.02           S  
ATOM   4038  CE  MET L  75      -1.648  -3.643   1.680  1.00 46.73           C  
ATOM   4039  N   ASN L  76      -3.259  -1.502  -4.802  1.00 41.18           N  
ATOM   4040  CA  ASN L  76      -3.215  -0.390  -5.741  1.00 39.91           C  
ATOM   4041  C   ASN L  76      -3.810   0.771  -4.966  1.00 40.08           C  
ATOM   4042  O   ASN L  76      -5.031   0.930  -4.913  1.00 42.00           O  
ATOM   4043  CB  ASN L  76      -4.060  -0.672  -6.985  1.00 39.37           C  
ATOM   4044  CG  ASN L  76      -3.318  -1.489  -8.030  1.00 38.83           C  
ATOM   4045  OD1 ASN L  76      -3.932  -2.081  -8.918  1.00 39.45           O  
ATOM   4046  ND2 ASN L  76      -1.997  -1.516  -7.939  1.00 37.30           N  
ATOM   4047  N   ILE L  77      -2.946   1.568  -4.346  1.00 38.42           N  
ATOM   4048  CA  ILE L  77      -3.390   2.703  -3.559  1.00 37.54           C  
ATOM   4049  C   ILE L  77      -3.372   3.982  -4.400  1.00 38.05           C  
ATOM   4050  O   ILE L  77      -2.325   4.389  -4.906  1.00 37.30           O  
ATOM   4051  CB  ILE L  77      -2.490   2.900  -2.314  1.00 38.59           C  
ATOM   4052  CG1 ILE L  77      -2.332   1.575  -1.545  1.00 39.58           C  
ATOM   4053  CG2 ILE L  77      -3.083   3.987  -1.429  1.00 34.98           C  
ATOM   4054  CD1 ILE L  77      -3.585   1.132  -0.803  1.00 46.09           C  
ATOM   4055  N   LYS L  78      -4.541   4.602  -4.542  1.00 38.81           N  
ATOM   4056  CA  LYS L  78      -4.690   5.831  -5.308  1.00 40.53           C  
ATOM   4057  C   LYS L  78      -4.958   6.969  -4.342  1.00 40.93           C  
ATOM   4058  O   LYS L  78      -5.777   6.829  -3.437  1.00 40.82           O  
ATOM   4059  CB  LYS L  78      -5.868   5.715  -6.281  1.00 43.08           C  
ATOM   4060  CG  LYS L  78      -5.833   4.471  -7.161  1.00 47.56           C  
ATOM   4061  CD  LYS L  78      -6.949   4.476  -8.197  1.00 50.65           C  
ATOM   4062  CE  LYS L  78      -6.920   3.202  -9.047  1.00 53.80           C  
ATOM   4063  NZ  LYS L  78      -7.977   3.186 -10.107  1.00 54.04           N  
ATOM   4064  N   PHE L  79      -4.270   8.090  -4.529  1.00 40.73           N  
ATOM   4065  CA  PHE L  79      -4.475   9.243  -3.665  1.00 43.02           C  
ATOM   4066  C   PHE L  79      -5.249  10.316  -4.414  1.00 45.02           C  
ATOM   4067  O   PHE L  79      -4.811  10.795  -5.455  1.00 46.08           O  
ATOM   4068  CB  PHE L  79      -3.136   9.797  -3.175  1.00 41.57           C  
ATOM   4069  CG  PHE L  79      -2.398   8.860  -2.268  1.00 40.84           C  
ATOM   4070  CD1 PHE L  79      -1.615   7.837  -2.789  1.00 40.16           C  
ATOM   4071  CD2 PHE L  79      -2.513   8.978  -0.887  1.00 39.88           C  
ATOM   4072  CE1 PHE L  79      -0.964   6.943  -1.949  1.00 39.66           C  
ATOM   4073  CE2 PHE L  79      -1.865   8.087  -0.037  1.00 39.06           C  
ATOM   4074  CZ  PHE L  79      -1.089   7.071  -0.567  1.00 40.10           C  
ATOM   4075  N   ALA L  80      -6.404  10.688  -3.874  1.00 47.67           N  
ATOM   4076  CA  ALA L  80      -7.267  11.691  -4.492  1.00 50.22           C  
ATOM   4077  C   ALA L  80      -6.561  12.999  -4.845  1.00 51.66           C  
ATOM   4078  O   ALA L  80      -7.009  13.730  -5.720  1.00 49.98           O  
ATOM   4079  CB  ALA L  80      -8.453  11.972  -3.582  1.00 51.47           C  
ATOM   4080  N   GLY L  81      -5.467  13.295  -4.158  1.00 55.17           N  
ATOM   4081  CA  GLY L  81      -4.740  14.518  -4.442  1.00 59.42           C  
ATOM   4082  C   GLY L  81      -5.313  15.739  -3.751  1.00 61.67           C  
ATOM   4083  O   GLY L  81      -6.242  15.631  -2.945  1.00 61.91           O  
ATOM   4084  N   LYS L  82      -4.750  16.903  -4.077  1.00 64.16           N  
ATOM   4085  CA  LYS L  82      -5.182  18.178  -3.503  1.00 67.65           C  
ATOM   4086  C   LYS L  82      -4.786  18.306  -2.026  1.00 69.59           C  
ATOM   4087  O   LYS L  82      -4.441  17.274  -1.404  1.00 69.72           O  
ATOM   4088  CB  LYS L  82      -6.703  18.334  -3.663  1.00 69.29           C  
ATOM   4089  CG  LYS L  82      -7.307  19.564  -2.987  1.00 72.01           C  
ATOM   4090  CD  LYS L  82      -7.660  19.297  -1.525  1.00 71.95           C  
ATOM   4091  CE  LYS L  82      -8.238  20.538  -0.847  1.00 72.03           C  
ATOM   4092  NZ  LYS L  82      -8.702  20.269   0.549  1.00 72.13           N  
ATOM   4093  OXT LYS L  82      -4.830  19.443  -1.507  1.00 70.66           O  
TER    4094      LYS L  82                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
