
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  231 ( 1789),  selected  231 , name 1k23_D
# Molecule2: number of CA atoms  213 ( 1712),  selected  213 , name T0501_2_214.pdb
# PARAMETERS: 1k23_D.T0501_2_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       2           -
LGA    -       -      T       3           -
LGA    -       -      K       4           -
LGA    -       -      V       5           -
LGA    -       -      I       6           -
LGA    -       -      A       7           -
LGA    -       -      Q       8           -
LGA    -       -      A       9           -
LGA    -       -      X      10           -
LGA    -       -      I      11           -
LGA    -       -      D      12           -
LGA    -       -      X      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      K      16           -
LGA    -       -      W      17           -
LGA    -       -      F      18           -
LGA    -       -      E      19           -
LGA    -       -      R      20           -
LGA    X     1_D      A      21          4.255
LGA    E     2_D      D      22          4.709
LGA    K     3_D      K      23          2.366
LGA    I     4_D      I      24          2.470
LGA    L     5_D      V      25          1.470
LGA    I     6_D      I      26          0.370
LGA    F     7_D      V      27          1.823
LGA    G     8_D      S      28          1.042
LGA    H     9_D      X      29          0.397
LGA    Q    10_D      V      30          0.499
LGA    N    11_D      S      31          0.552
LGA    P    12_D      P      32          0.595
LGA    D    13_D      D      33          0.528
LGA    T    14_D      G      34          1.180
LGA    D    15_D      D      35          1.278
LGA    T    16_D      A      36          0.994
LGA    I    17_D      I      37          1.088
LGA    C    18_D      G      38          1.845
LGA    S    19_D      S      39          1.233
LGA    A    20_D      S      40          1.118
LGA    I    21_D      L      41          1.625
LGA    A    22_D      G      42          1.490
LGA    Y    23_D      L      43          1.034
LGA    A    24_D      Y      44          2.268
LGA    D    25_D      X      45          2.755
LGA    L    26_D      F      46          2.486
LGA    K    27_D      L      47          2.857
LGA    N    28_D      D      48          3.732
LGA    K    29_D      S      49          3.831
LGA    L    30_D      Q      50          4.399
LGA    G    31_D      D      51          5.154
LGA    F    32_D      K      52          3.944
LGA    N    33_D      I      53          2.910
LGA    A    34_D      V      54          2.133
LGA    E    35_D      N      55          1.469
LGA    P    36_D      V      56          1.766
LGA    V    37_D      I      57          2.177
LGA    R    38_D      V      58          2.530
LGA    L    39_D      P      59          1.980
LGA    G    40_D      N      60          1.113
LGA    Q    41_D      A      61          1.171
LGA    V    42_D      F      62          1.831
LGA    N    43_D      P      63          0.516
LGA    G    44_D      D      64          3.064
LGA    E    45_D      F      65          3.134
LGA    T    46_D      L      66          1.704
LGA    Q    47_D      K      67          2.505
LGA    Y    48_D      W      68          4.252
LGA    A    49_D      -       -           -
LGA    L    50_D      M      69          1.276
LGA    D    51_D      -       -           -
LGA    Y    52_D      -       -           -
LGA    F    53_D      -       -           -
LGA    K    54_D      P      70          4.345
LGA    Q    55_D      G      71          3.635
LGA    E    56_D      S      72          3.831
LGA    S    57_D      K      73          2.169
LGA    P    58_D      D      74          3.400
LGA    R    59_D      I      75          2.741
LGA    -       -      L      76           -
LGA    L    60_D      L      77          1.549
LGA    V    61_D      Y      78          2.041
LGA    E    62_D      D      79          3.771
LGA    T    63_D      R      80           -
LGA    -       -      Y      81           -
LGA    -       -      Q      82           -
LGA    -       -      E      83           -
LGA    A    64_D      F      84           #
LGA    A    65_D      A      85           #
LGA    N    66_D      D      86          2.777
LGA    E    67_D      K      87          1.236
LGA    V    68_D      L      88          3.661
LGA    -       -      I      89           -
LGA    -       -      M      90           -
LGA    N    69_D      E      91          4.194
LGA    -       -      A      92           -
LGA    -       -      D      93           -
LGA    G    70_D      V      94          4.936
LGA    V    71_D      I      95          2.175
LGA    I    72_D      C      96          1.351
LGA    L    73_D      C      97          0.545
LGA    V    74_D      L      98          0.426
LGA    D    75_D      D      99          0.748
LGA    H    76_D      F     100          0.784
LGA    N    77_D      N     101          1.409
LGA    E    78_D      A     102          1.303
LGA    R    79_D      L     103          1.568
LGA    Q    80_D      K     104          1.348
LGA    Q    81_D      R     105          0.777
LGA    S    82_D      I     106          1.610
LGA    I    83_D      D     107          4.790
LGA    K    84_D      E     108          1.635
LGA    D    85_D      M     109          3.651
LGA    I    86_D      S     110          2.240
LGA    -       -      D     111           -
LGA    -       -      I     112           -
LGA    -       -      V     113           -
LGA    E    87_D      A     114          2.727
LGA    E    88_D      A     115          2.206
LGA    V    89_D      S     116          2.323
LGA    Q    90_D      P     117          4.625
LGA    -       -      G     118           -
LGA    V    91_D      R     119           #
LGA    L    92_D      K     120          1.183
LGA    E    93_D      I     121          0.557
LGA    V    94_D      M     122          0.940
LGA    I    95_D      I     123          0.819
LGA    D    96_D      D     124          0.718
LGA    H    97_D      X     125          0.713
LGA    H    98_D      X     126          0.722
LGA    R    99_D      L     127          0.999
LGA    I   100_D      Y     128          2.541
LGA    A   101_D      P     129          3.676
LGA    N   102_D      -       -           -
LGA    F   103_D      E     130          2.208
LGA    E   104_D      D     131          2.461
LGA    T   105_D      F     132          2.667
LGA    A   106_D      -       -           -
LGA    E   107_D      C     133           #
LGA    P   108_D      R     134          2.986
LGA    L   109_D      -       -           -
LGA    Y   110_D      I     135          2.251
LGA    Y   111_D      T     136          1.589
LGA    R   112_D      I     137          1.309
LGA    A   113_D      S     138          2.245
LGA    E   114_D      X     139          2.189
LGA    P   115_D      P     140          3.336
LGA    -       -      E     141           -
LGA    V   116_D      I     142          1.064
LGA    G   117_D      S     143          1.043
LGA    C   118_D      S     144          1.080
LGA    T   119_D      T     145          0.995
LGA    A   120_D      S     146          1.297
LGA    T   121_D      E     147          0.935
LGA    I   122_D      L     148          1.310
LGA    L   123_D      V     149          1.538
LGA    N   124_D      F     150          1.443
LGA    K   125_D      R     151          1.501
LGA    X   126_D      L     152          1.988
LGA    Y   127_D      I     153          2.251
LGA    K   128_D      C     154          1.905
LGA    E   129_D      R     155          1.740
LGA    N   130_D      M     156          2.109
LGA    N   131_D      G     157          2.334
LGA    V   132_D      Y     158          2.138
LGA    -       -      F     159           -
LGA    K   133_D      S     160          1.918
LGA    -       -      D     161           -
LGA    I   134_D      I     162          1.104
LGA    E   135_D      S     163          0.750
LGA    K   136_D      K     164          0.904
LGA    E   137_D      E     165          1.511
LGA    I   138_D      G     166          1.536
LGA    A   139_D      A     167          0.672
LGA    G   140_D      E     168          0.812
LGA    L   141_D      C     169          1.182
LGA    X   142_D      I     170          1.019
LGA    L   143_D      Y     171          0.992
LGA    S   144_D      T     172          1.195
LGA    A   145_D      G     173          1.232
LGA    I   146_D      M     174          0.992
LGA    I   147_D      M     175          0.914
LGA    S   148_D      T     176          0.925
LGA    D   149_D      D     177          0.948
LGA    S   150_D      T     178          1.140
LGA    L   151_D      G     179          1.143
LGA    L   152_D      G     180          1.285
LGA    F   153_D      F     181          0.772
LGA    K   154_D      T     182          0.357
LGA    S   155_D      Y     183          1.316
LGA    P   156_D      N     184          2.810
LGA    T   157_D      S     185           #
LGA    C   158_D      N     186           #
LGA    T   159_D      N     187          3.366
LGA    D   160_D      R     188          2.852
LGA    Q   161_D      E     189          2.837
LGA    D   162_D      I     190          2.810
LGA    V   163_D      Y     191          3.040
LGA    A   164_D      F     192          2.548
LGA    A   165_D      I     193          1.655
LGA    A   166_D      I     194          2.226
LGA    K   167_D      S     195          2.669
LGA    E   168_D      E     196          1.787
LGA    L   169_D      L     197          0.959
LGA    A   170_D      L     198          2.680
LGA    E   171_D      S     199          3.055
LGA    I   172_D      K     200          1.138
LGA    A   173_D      G     201          3.037
LGA    G   174_D      I     202          3.082
LGA    V   175_D      D     203          1.473
LGA    D   176_D      K     204          3.783
LGA    A   177_D      -       -           -
LGA    E   178_D      -       -           -
LGA    E   179_D      D     205          2.313
LGA    Y   180_D      D     206          2.761
LGA    G   181_D      I     207          4.665
LGA    L   182_D      Y     208          3.553
LGA    N   183_D      R     209          1.074
LGA    X   184_D      K     210          3.263
LGA    -       -      V     211           -
LGA    L   185_D      Y     212          2.394
LGA    K   186_D      N     213          2.784
LGA    A   187_D      T     214          2.745
LGA    G   188_D      -       -           -
LGA    A   189_D      -       -           -
LGA    D   190_D      -       -           -
LGA    L   191_D      -       -           -
LGA    S   192_D      -       -           -
LGA    K   193_D      -       -           -
LGA    I   216_D      -       -           -
LGA    A   217_D      -       -           -
LGA    Q   218_D      -       -           -
LGA    V   219_D      -       -           -
LGA    N   220_D      -       -           -
LGA    T   221_D      -       -           -
LGA    V   222_D      -       -           -
LGA    D   223_D      -       -           -
LGA    I   224_D      -       -           -
LGA    E   225_D      -       -           -
LGA    D   226_D      -       -           -
LGA    V   227_D      -       -           -
LGA    L   252_D      -       -           -
LGA    V   253_D      -       -           -
LGA    I   254_D      -       -           -
LGA    T   255_D      -       -           -
LGA    D   256_D      -       -           -
LGA    I   257_D      -       -           -
LGA    L   258_D      -       -           -
LGA    E   259_D      -       -           -
LGA    N   260_D      -       -           -
LGA    D   261_D      -       -           -
LGA    S   262_D      -       -           -
LGA    V   293_D      -       -           -
LGA    S   294_D      -       -           -
LGA    R   295_D      -       -           -
LGA    K   296_D      -       -           -
LGA    K   297_D      -       -           -
LGA    Q   298_D      -       -           -
LGA    V   299_D      -       -           -
LGA    V   300_D      -       -           -
LGA    P   301_D      -       -           -
LGA    V   302_D      -       -           -
LGA    L   303_D      -       -           -
LGA    T   304_D      -       -           -
LGA    D   305_D      -       -           -
LGA    A   306_D      -       -           -
LGA    X   307_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  231  213    5.0    171    2.31    13.45     56.310     7.109

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.138703 * X  +   0.990328 * Y  +   0.003489 * Z  + -75.275810
  Y_new =  -0.306163 * X  +   0.039529 * Y  +   0.951158 * Z  +  -4.820666
  Z_new =   0.941820 * X  +  -0.132997 * Y  +   0.308684 * Z  +  26.932896 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.406816    2.734777  [ DEG:   -23.3088    156.6912 ]
  Theta =  -1.228006   -1.913587  [ DEG:   -70.3596   -109.6404 ]
  Phi   =  -1.145420    1.996173  [ DEG:   -65.6277    114.3723 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k23_D                                        
REMARK     2: T0501_2_214.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k23_D.T0501_2_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  231  213   5.0  171   2.31   13.45  56.310
REMARK  ---------------------------------------------------------- 
MOLECULE 1k23_D
HEADER    HYDROLASE                               26-SEP-01   1K23              
TITLE     INORGANIC PYROPHOSPHATASE (FAMILY II) FROM BACILLUS SUBTILIS          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MANGANESE-DEPENDENT INORGANIC PYROPHOSPHATASE;             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PYROPHOSPHATE PHOSPHO-HYDROLASE, PPASE;                     
COMPND   5 EC: 3.6.1.1;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    INORGANIC PYROPHOSPHATASE, MANGANESE, BINUCLEAR METAL CENTRE          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.AHN,A.J.MILNER,K.FUTTERER,M.KONOPKA,M.ILIAS,T.W.YOUNG,              
AUTHOR   2 S.A.WHITE                                                            
REVDAT   2   01-APR-03 1K23    1       JRNL                                     
REVDAT   1   31-OCT-01 1K23    0                                                
JRNL        AUTH   S.AHN,A.J.MILNER,K.FUTTERER,M.KONOPKA,M.ILIAS,               
JRNL        AUTH 2 T.W.YOUNG,S.A.WHITE                                          
JRNL        TITL   THE "OPEN" AND "CLOSED" STRUCTURES OF THE TYPE-C             
JRNL        TITL 2 INORGANIC PYROPHOSPHATASES FROM BACILLUS SUBTILIS            
JRNL        TITL 3 AND STREPTOCOCCUS GORDONII.                                  
JRNL        REF    J.MOL.BIOL.                   V. 313   797 2001              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  1K23 A    1   309  UNP    P37487   PPAC_BACSU       1    309             
DBREF  1K23 B    1   309  UNP    P37487   PPAC_BACSU       1    309             
DBREF  1K23 C    1   309  UNP    P37487   PPAC_BACSU       1    309             
DBREF  1K23 D    1   309  UNP    P37487   PPAC_BACSU       1    309             
SEQRES   1 A  309  MSE GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 A  309  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 A  309  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 A  309  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 A  309  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 A  309  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 A  309  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 A  309  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 A  309  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 A  309  CYS THR ALA THR ILE LEU ASN LYS MSE TYR LYS GLU ASN          
SEQRES  11 A  309  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MSE LEU          
SEQRES  12 A  309  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 A  309  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 A  309  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 A  309  ASN MSE LEU LYS ALA GLY ALA ASP LEU SER LYS LYS THR          
SEQRES  16 A  309  VAL GLU GLU LEU ILE SER LEU ASP ALA LYS GLU PHE THR          
SEQRES  17 A  309  LEU GLY SER LYS LYS VAL GLU ILE ALA GLN VAL ASN THR          
SEQRES  18 A  309  VAL ASP ILE GLU ASP VAL LYS LYS ARG GLN ALA GLU LEU          
SEQRES  19 A  309  GLU ALA VAL ILE SER LYS VAL VAL ALA GLU LYS ASN LEU          
SEQRES  20 A  309  ASP LEU PHE LEU LEU VAL ILE THR ASP ILE LEU GLU ASN          
SEQRES  21 A  309  ASP SER LEU ALA LEU ALA ILE GLY ASN GLU ALA ALA LYS          
SEQRES  22 A  309  VAL GLU LYS ALA PHE ASN VAL THR LEU GLU ASN ASN THR          
SEQRES  23 A  309  ALA LEU LEU LYS GLY VAL VAL SER ARG LYS LYS GLN VAL          
SEQRES  24 A  309  VAL PRO VAL LEU THR ASP ALA MSE ALA GLU                      
SEQRES   1 B  309  MSE GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 B  309  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 B  309  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 B  309  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 B  309  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 B  309  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 B  309  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 B  309  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 B  309  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 B  309  CYS THR ALA THR ILE LEU ASN LYS MSE TYR LYS GLU ASN          
SEQRES  11 B  309  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MSE LEU          
SEQRES  12 B  309  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 B  309  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 B  309  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 B  309  ASN MSE LEU LYS ALA GLY ALA ASP LEU SER LYS LYS THR          
SEQRES  16 B  309  VAL GLU GLU LEU ILE SER LEU ASP ALA LYS GLU PHE THR          
SEQRES  17 B  309  LEU GLY SER LYS LYS VAL GLU ILE ALA GLN VAL ASN THR          
SEQRES  18 B  309  VAL ASP ILE GLU ASP VAL LYS LYS ARG GLN ALA GLU LEU          
SEQRES  19 B  309  GLU ALA VAL ILE SER LYS VAL VAL ALA GLU LYS ASN LEU          
SEQRES  20 B  309  ASP LEU PHE LEU LEU VAL ILE THR ASP ILE LEU GLU ASN          
SEQRES  21 B  309  ASP SER LEU ALA LEU ALA ILE GLY ASN GLU ALA ALA LYS          
SEQRES  22 B  309  VAL GLU LYS ALA PHE ASN VAL THR LEU GLU ASN ASN THR          
SEQRES  23 B  309  ALA LEU LEU LYS GLY VAL VAL SER ARG LYS LYS GLN VAL          
SEQRES  24 B  309  VAL PRO VAL LEU THR ASP ALA MSE ALA GLU                      
SEQRES   1 C  309  MSE GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 C  309  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 C  309  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 C  309  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 C  309  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 C  309  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 C  309  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 C  309  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 C  309  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 C  309  CYS THR ALA THR ILE LEU ASN LYS MSE TYR LYS GLU ASN          
SEQRES  11 C  309  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MSE LEU          
SEQRES  12 C  309  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 C  309  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 C  309  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 C  309  ASN MSE LEU LYS ALA GLY ALA ASP LEU SER LYS LYS THR          
SEQRES  16 C  309  VAL GLU GLU LEU ILE SER LEU ASP ALA LYS GLU PHE THR          
SEQRES  17 C  309  LEU GLY SER LYS LYS VAL GLU ILE ALA GLN VAL ASN THR          
SEQRES  18 C  309  VAL ASP ILE GLU ASP VAL LYS LYS ARG GLN ALA GLU LEU          
SEQRES  19 C  309  GLU ALA VAL ILE SER LYS VAL VAL ALA GLU LYS ASN LEU          
SEQRES  20 C  309  ASP LEU PHE LEU LEU VAL ILE THR ASP ILE LEU GLU ASN          
SEQRES  21 C  309  ASP SER LEU ALA LEU ALA ILE GLY ASN GLU ALA ALA LYS          
SEQRES  22 C  309  VAL GLU LYS ALA PHE ASN VAL THR LEU GLU ASN ASN THR          
SEQRES  23 C  309  ALA LEU LEU LYS GLY VAL VAL SER ARG LYS LYS GLN VAL          
SEQRES  24 C  309  VAL PRO VAL LEU THR ASP ALA MSE ALA GLU                      
SEQRES   1 D  309  MSE GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 D  309  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 D  309  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 D  309  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 D  309  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 D  309  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 D  309  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 D  309  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 D  309  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 D  309  CYS THR ALA THR ILE LEU ASN LYS MSE TYR LYS GLU ASN          
SEQRES  11 D  309  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MSE LEU          
SEQRES  12 D  309  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 D  309  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 D  309  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 D  309  ASN MSE LEU LYS ALA GLY ALA ASP LEU SER LYS LYS THR          
SEQRES  16 D  309  VAL GLU GLU LEU ILE SER LEU ASP ALA LYS GLU PHE THR          
SEQRES  17 D  309  LEU GLY SER LYS LYS VAL GLU ILE ALA GLN VAL ASN THR          
SEQRES  18 D  309  VAL ASP ILE GLU ASP VAL LYS LYS ARG GLN ALA GLU LEU          
SEQRES  19 D  309  GLU ALA VAL ILE SER LYS VAL VAL ALA GLU LYS ASN LEU          
SEQRES  20 D  309  ASP LEU PHE LEU LEU VAL ILE THR ASP ILE LEU GLU ASN          
SEQRES  21 D  309  ASP SER LEU ALA LEU ALA ILE GLY ASN GLU ALA ALA LYS          
SEQRES  22 D  309  VAL GLU LYS ALA PHE ASN VAL THR LEU GLU ASN ASN THR          
SEQRES  23 D  309  ALA LEU LEU LYS GLY VAL VAL SER ARG LYS LYS GLN VAL          
SEQRES  24 D  309  VAL PRO VAL LEU THR ASP ALA MSE ALA GLU                      
HET    MSE  A   1       8                                                       
HET    MSE  A 126       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 184       8                                                       
HET    MSE  A 307       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 126       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 184       8                                                       
HET    MSE  B 307       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C 126       8                                                       
HET    MSE  C 142       8                                                       
HET    MSE  C 184       8                                                       
HET    MSE  C 307       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D 126       8                                                       
HET    MSE  D 142       8                                                       
HET    MSE  D 184       8                                                       
HET    MSE  D 307       8                                                       
HET     MN  A 401       1                                                       
HET     MN  A 402       1                                                       
HET     MN  B 403       1                                                       
HET     MN  B 404       1                                                       
HET     MN  C 405       1                                                       
HET     MN  C 406       1                                                       
HET     MN  D 407       1                                                       
HET     MN  D 408       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MN MANGANESE (II) ION                                               
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   5   MN    8(MN 2+)                                                     
FORMUL  13  HOH   *58(H2 O)                                                     
CRYST1   80.290  130.560  150.470  90.00  90.00  90.00 P 21 21 21   16          
HETATM 7122  N   MSE D   1       8.899  44.919  59.863  1.00 79.95           N  
HETATM 7123  CA  MSE D   1       8.540  45.411  58.504  1.00 80.80           C  
HETATM 7124  C   MSE D   1       8.370  46.925  58.453  1.00 78.73           C  
HETATM 7125  O   MSE D   1       7.570  47.485  59.202  1.00 78.70           O  
HETATM 7126  CB  MSE D   1       7.238  44.760  58.046  1.00 85.18           C  
HETATM 7127  CG  MSE D   1       7.331  43.252  57.826  1.00 90.72           C  
HETATM 7128 SE   MSE D   1       8.545  42.673  56.243  1.00103.97          SE  
HETATM 7129  CE  MSE D   1       8.732  44.398  55.277  1.00 97.87           C  
ATOM   7130  N   GLU D   2       9.118  47.587  57.571  1.00 75.62           N  
ATOM   7131  CA  GLU D   2       9.017  49.041  57.409  1.00 72.53           C  
ATOM   7132  C   GLU D   2       7.534  49.282  57.109  1.00 69.17           C  
ATOM   7133  O   GLU D   2       6.893  48.428  56.493  1.00 69.45           O  
ATOM   7134  CB  GLU D   2       9.876  49.492  56.216  1.00 75.15           C  
ATOM   7135  CG  GLU D   2      10.195  50.991  56.152  1.00 79.86           C  
ATOM   7136  CD  GLU D   2       9.956  51.604  54.763  1.00 83.80           C  
ATOM   7137  OE1 GLU D   2      10.494  51.076  53.754  1.00 85.26           O  
ATOM   7138  OE2 GLU D   2       9.226  52.626  54.687  1.00 86.12           O  
ATOM   7139  N   LYS D   3       6.965  50.410  57.535  1.00 65.21           N  
ATOM   7140  CA  LYS D   3       5.545  50.640  57.246  1.00 60.45           C  
ATOM   7141  C   LYS D   3       5.287  51.221  55.856  1.00 57.91           C  
ATOM   7142  O   LYS D   3       6.006  52.116  55.383  1.00 57.08           O  
ATOM   7143  CB  LYS D   3       4.891  51.544  58.284  1.00 59.26           C  
ATOM   7144  CG  LYS D   3       3.364  51.492  58.211  1.00 58.21           C  
ATOM   7145  CD  LYS D   3       2.705  52.613  59.013  1.00 57.89           C  
ATOM   7146  CE  LYS D   3       1.195  52.644  58.812  1.00 57.01           C  
ATOM   7147  NZ  LYS D   3       0.525  51.390  59.269  1.00 57.47           N  
ATOM   7148  N   ILE D   4       4.237  50.697  55.226  1.00 54.41           N  
ATOM   7149  CA  ILE D   4       3.829  51.081  53.887  1.00 50.60           C  
ATOM   7150  C   ILE D   4       2.420  51.651  53.880  1.00 47.84           C  
ATOM   7151  O   ILE D   4       1.570  51.255  54.670  1.00 47.65           O  
ATOM   7152  CB  ILE D   4       3.851  49.864  52.953  1.00 50.83           C  
ATOM   7153  CG1 ILE D   4       5.251  49.279  52.891  1.00 51.70           C  
ATOM   7154  CG2 ILE D   4       3.471  50.269  51.562  1.00 51.29           C  
ATOM   7155  CD1 ILE D   4       5.318  47.980  52.117  1.00 54.03           C  
ATOM   7156  N   LEU D   5       2.181  52.577  52.964  1.00 44.76           N  
ATOM   7157  CA  LEU D   5       0.878  53.201  52.811  1.00 42.37           C  
ATOM   7158  C   LEU D   5       0.305  52.807  51.446  1.00 41.89           C  
ATOM   7159  O   LEU D   5       0.946  53.036  50.412  1.00 43.98           O  
ATOM   7160  CB  LEU D   5       1.039  54.717  52.881  1.00 40.63           C  
ATOM   7161  CG  LEU D   5       0.333  55.467  54.003  1.00 39.24           C  
ATOM   7162  CD1 LEU D   5       0.441  54.702  55.300  1.00 38.18           C  
ATOM   7163  CD2 LEU D   5       0.953  56.845  54.127  1.00 38.16           C  
ATOM   7164  N   ILE D   6      -0.886  52.213  51.437  1.00 38.88           N  
ATOM   7165  CA  ILE D   6      -1.541  51.800  50.192  1.00 35.63           C  
ATOM   7166  C   ILE D   6      -2.766  52.685  49.941  1.00 35.31           C  
ATOM   7167  O   ILE D   6      -3.621  52.842  50.814  1.00 35.27           O  
ATOM   7168  CB  ILE D   6      -1.989  50.330  50.276  1.00 33.92           C  
ATOM   7169  CG1 ILE D   6      -0.771  49.433  50.449  1.00 32.58           C  
ATOM   7170  CG2 ILE D   6      -2.763  49.940  49.046  1.00 32.41           C  
ATOM   7171  CD1 ILE D   6      -1.116  47.975  50.659  1.00 33.12           C  
ATOM   7172  N   PHE D   7      -2.861  53.261  48.749  1.00 35.80           N  
ATOM   7173  CA  PHE D   7      -3.992  54.130  48.443  1.00 36.83           C  
ATOM   7174  C   PHE D   7      -4.249  54.310  46.938  1.00 38.65           C  
ATOM   7175  O   PHE D   7      -3.356  54.105  46.111  1.00 38.90           O  
ATOM   7176  CB  PHE D   7      -3.766  55.485  49.109  1.00 33.72           C  
ATOM   7177  CG  PHE D   7      -2.484  56.145  48.705  1.00 33.04           C  
ATOM   7178  CD1 PHE D   7      -2.364  56.778  47.470  1.00 32.64           C  
ATOM   7179  CD2 PHE D   7      -1.390  56.130  49.550  1.00 32.53           C  
ATOM   7180  CE1 PHE D   7      -1.172  57.390  47.083  1.00 31.87           C  
ATOM   7181  CE2 PHE D   7      -0.193  56.739  49.174  1.00 32.78           C  
ATOM   7182  CZ  PHE D   7      -0.084  57.372  47.936  1.00 32.34           C  
ATOM   7183  N   GLY D   8      -5.478  54.694  46.596  1.00 40.11           N  
ATOM   7184  CA  GLY D   8      -5.842  54.910  45.203  1.00 40.22           C  
ATOM   7185  C   GLY D   8      -5.744  56.380  44.842  1.00 40.49           C  
ATOM   7186  O   GLY D   8      -5.072  57.135  45.539  1.00 40.49           O  
ATOM   7187  N   HIS D   9      -6.422  56.792  43.776  1.00 40.62           N  
ATOM   7188  CA  HIS D   9      -6.377  58.183  43.325  1.00 41.89           C  
ATOM   7189  C   HIS D   9      -7.243  59.155  44.118  1.00 43.24           C  
ATOM   7190  O   HIS D   9      -7.952  58.762  45.043  1.00 43.18           O  
ATOM   7191  CB  HIS D   9      -6.785  58.248  41.853  1.00 41.46           C  
ATOM   7192  CG  HIS D   9      -8.140  57.667  41.572  1.00 41.79           C  
ATOM   7193  ND1 HIS D   9      -9.312  58.368  41.764  1.00 41.31           N  
ATOM   7194  CD2 HIS D   9      -8.507  56.439  41.133  1.00 41.35           C  
ATOM   7195  CE1 HIS D   9     -10.340  57.596  41.457  1.00 40.79           C  
ATOM   7196  NE2 HIS D   9      -9.881  56.420  41.072  1.00 39.71           N  
ATOM   7197  N   GLN D  10      -7.172  60.431  43.742  1.00 45.49           N  
ATOM   7198  CA  GLN D  10      -7.965  61.486  44.377  1.00 46.98           C  
ATOM   7199  C   GLN D  10      -9.386  61.380  43.859  1.00 47.36           C  
ATOM   7200  O   GLN D  10      -9.626  60.703  42.860  1.00 47.78           O  
ATOM   7201  CB  GLN D  10      -7.402  62.850  44.034  1.00 47.72           C  
ATOM   7202  CG  GLN D  10      -5.962  62.975  44.402  1.00 52.40           C  
ATOM   7203  CD  GLN D  10      -5.527  64.414  44.499  1.00 56.05           C  
ATOM   7204  OE1 GLN D  10      -5.564  65.167  43.505  1.00 57.64           O  
ATOM   7205  NE2 GLN D  10      -5.114  64.822  45.706  1.00 57.75           N  
ATOM   7206  N   ASN D  11     -10.328  62.058  44.513  1.00 47.45           N  
ATOM   7207  CA  ASN D  11     -11.729  61.959  44.097  1.00 47.35           C  
ATOM   7208  C   ASN D  11     -11.993  60.457  44.016  1.00 45.63           C  
ATOM   7209  O   ASN D  11     -12.394  59.935  42.978  1.00 45.63           O  
ATOM   7210  CB  ASN D  11     -11.935  62.601  42.724  1.00 49.34           C  
ATOM   7211  CG  ASN D  11     -11.412  64.023  42.663  1.00 52.51           C  
ATOM   7212  OD1 ASN D  11     -11.637  64.819  43.580  1.00 54.98           O  
ATOM   7213  ND2 ASN D  11     -10.717  64.354  41.577  1.00 53.82           N  
ATOM   7214  N   PRO D  12     -11.768  59.750  45.131  1.00 44.15           N  
ATOM   7215  CA  PRO D  12     -11.931  58.304  45.290  1.00 43.25           C  
ATOM   7216  C   PRO D  12     -13.196  57.618  44.837  1.00 41.99           C  
ATOM   7217  O   PRO D  12     -14.288  57.959  45.267  1.00 41.58           O  
ATOM   7218  CB  PRO D  12     -11.689  58.090  46.783  1.00 43.40           C  
ATOM   7219  CG  PRO D  12     -12.123  59.388  47.379  1.00 43.81           C  
ATOM   7220  CD  PRO D  12     -11.522  60.384  46.441  1.00 43.25           C  
ATOM   7221  N   ASP D  13     -13.023  56.628  43.969  1.00 41.53           N  
ATOM   7222  CA  ASP D  13     -14.128  55.822  43.488  1.00 40.45           C  
ATOM   7223  C   ASP D  13     -14.143  54.561  44.377  1.00 39.24           C  
ATOM   7224  O   ASP D  13     -13.241  54.370  45.209  1.00 37.80           O  
ATOM   7225  CB  ASP D  13     -13.966  55.497  41.979  1.00 41.59           C  
ATOM   7226  CG  ASP D  13     -12.575  54.955  41.607  1.00 43.44           C  
ATOM   7227  OD1 ASP D  13     -12.222  54.981  40.402  1.00 43.48           O  
ATOM   7228  OD2 ASP D  13     -11.837  54.492  42.501  1.00 45.18           O  
ATOM   7229  N   THR D  14     -15.167  53.724  44.238  1.00 38.16           N  
ATOM   7230  CA  THR D  14     -15.260  52.527  45.060  1.00 37.67           C  
ATOM   7231  C   THR D  14     -14.073  51.587  44.858  1.00 37.72           C  
ATOM   7232  O   THR D  14     -13.705  50.817  45.753  1.00 37.83           O  
ATOM   7233  CB  THR D  14     -16.566  51.774  44.783  1.00 37.95           C  
ATOM   7234  OG1 THR D  14     -17.678  52.630  45.077  1.00 37.89           O  
ATOM   7235  CG2 THR D  14     -16.654  50.526  45.657  1.00 38.30           C  
ATOM   7236  N   ASP D  15     -13.467  51.652  43.679  1.00 37.61           N  
ATOM   7237  CA  ASP D  15     -12.313  50.814  43.384  1.00 36.74           C  
ATOM   7238  C   ASP D  15     -11.143  51.307  44.220  1.00 35.78           C  
ATOM   7239  O   ASP D  15     -10.519  50.535  44.948  1.00 35.45           O  
ATOM   7240  CB  ASP D  15     -11.952  50.890  41.894  1.00 36.60           C  
ATOM   7241  CG  ASP D  15     -11.124  49.701  41.433  1.00 36.05           C  
ATOM   7242  OD1 ASP D  15     -10.684  49.704  40.265  1.00 36.73           O  
ATOM   7243  OD2 ASP D  15     -10.921  48.763  42.235  1.00 34.27           O  
ATOM   7244  N   THR D  16     -10.862  52.602  44.114  1.00 35.78           N  
ATOM   7245  CA  THR D  16      -9.763  53.225  44.848  1.00 36.41           C  
ATOM   7246  C   THR D  16      -9.849  52.964  46.342  1.00 36.52           C  
ATOM   7247  O   THR D  16      -8.818  52.794  46.999  1.00 36.82           O  
ATOM   7248  CB  THR D  16      -9.693  54.772  44.601  1.00 36.79           C  
ATOM   7249  OG1 THR D  16      -8.900  55.044  43.437  1.00 36.27           O  
ATOM   7250  CG2 THR D  16      -9.069  55.491  45.800  1.00 38.12           C  
ATOM   7251  N   ILE D  17     -11.064  52.928  46.886  1.00 36.45           N  
ATOM   7252  CA  ILE D  17     -11.196  52.678  48.315  1.00 35.75           C  
ATOM   7253  C   ILE D  17     -11.114  51.205  48.640  1.00 36.61           C  
ATOM   7254  O   ILE D  17     -10.275  50.801  49.443  1.00 36.84           O  
ATOM   7255  CB  ILE D  17     -12.501  53.221  48.885  1.00 34.54           C  
ATOM   7256  CG1 ILE D  17     -12.556  54.738  48.703  1.00 33.42           C  
ATOM   7257  CG2 ILE D  17     -12.582  52.880  50.371  1.00 33.68           C  
ATOM   7258  CD1 ILE D  17     -11.546  55.485  49.545  1.00 32.49           C  
ATOM   7259  N   CYS D  18     -11.966  50.395  48.013  1.00 36.96           N  
ATOM   7260  CA  CYS D  18     -11.953  48.960  48.290  1.00 38.45           C  
ATOM   7261  C   CYS D  18     -10.646  48.240  47.957  1.00 37.71           C  
ATOM   7262  O   CYS D  18     -10.125  47.475  48.778  1.00 36.21           O  
ATOM   7263  CB  CYS D  18     -13.120  48.286  47.585  1.00 38.93           C  
ATOM   7264  SG  CYS D  18     -14.663  48.959  48.170  1.00 44.73           S  
ATOM   7265  N   SER D  19     -10.105  48.485  46.769  1.00 37.54           N  
ATOM   7266  CA  SER D  19      -8.873  47.823  46.381  1.00 37.73           C  
ATOM   7267  C   SER D  19      -7.738  48.125  47.344  1.00 37.81           C  
ATOM   7268  O   SER D  19      -6.925  47.248  47.643  1.00 37.83           O  
ATOM   7269  CB  SER D  19      -8.490  48.221  44.962  1.00 38.77           C  
ATOM   7270  OG  SER D  19      -9.365  47.606  44.033  1.00 40.77           O  
ATOM   7271  N   ALA D  20      -7.683  49.361  47.837  1.00 36.62           N  
ATOM   7272  CA  ALA D  20      -6.641  49.744  48.778  1.00 35.28           C  
ATOM   7273  C   ALA D  20      -6.784  48.889  50.043  1.00 35.28           C  
ATOM   7274  O   ALA D  20      -5.816  48.313  50.546  1.00 34.91           O  
ATOM   7275  CB  ALA D  20      -6.760  51.215  49.106  1.00 35.15           C  
ATOM   7276  N   ILE D  21      -8.001  48.794  50.553  1.00 35.90           N  
ATOM   7277  CA  ILE D  21      -8.251  47.996  51.742  1.00 36.95           C  
ATOM   7278  C   ILE D  21      -7.941  46.533  51.451  1.00 38.33           C  
ATOM   7279  O   ILE D  21      -7.292  45.858  52.262  1.00 39.74           O  
ATOM   7280  CB  ILE D  21      -9.729  48.105  52.192  1.00 36.70           C  
ATOM   7281  CG1 ILE D  21     -10.039  49.553  52.570  1.00 35.64           C  
ATOM   7282  CG2 ILE D  21     -10.012  47.142  53.358  1.00 34.76           C  
ATOM   7283  CD1 ILE D  21     -11.484  49.804  52.792  1.00 36.06           C  
ATOM   7284  N   ALA D  22      -8.402  46.057  50.291  1.00 37.93           N  
ATOM   7285  CA  ALA D  22      -8.207  44.662  49.876  1.00 37.36           C  
ATOM   7286  C   ALA D  22      -6.750  44.261  49.780  1.00 36.71           C  
ATOM   7287  O   ALA D  22      -6.330  43.273  50.376  1.00 37.30           O  
ATOM   7288  CB  ALA D  22      -8.900  44.406  48.544  1.00 36.81           C  
ATOM   7289  N   TYR D  23      -5.975  45.036  49.037  1.00 36.41           N  
ATOM   7290  CA  TYR D  23      -4.568  44.716  48.869  1.00 37.78           C  
ATOM   7291  C   TYR D  23      -3.778  44.847  50.176  1.00 38.64           C  
ATOM   7292  O   TYR D  23      -2.842  44.078  50.427  1.00 39.03           O  
ATOM   7293  CB  TYR D  23      -3.942  45.593  47.770  1.00 36.55           C  
ATOM   7294  CG  TYR D  23      -2.625  45.037  47.267  1.00 35.26           C  
ATOM   7295  CD1 TYR D  23      -2.431  43.657  47.158  1.00 33.72           C  
ATOM   7296  CD2 TYR D  23      -1.575  45.882  46.908  1.00 34.54           C  
ATOM   7297  CE1 TYR D  23      -1.236  43.136  46.716  1.00 33.35           C  
ATOM   7298  CE2 TYR D  23      -0.365  45.363  46.459  1.00 33.64           C  
ATOM   7299  CZ  TYR D  23      -0.209  43.984  46.373  1.00 33.94           C  
ATOM   7300  OH  TYR D  23       0.990  43.438  45.985  1.00 34.30           O  
ATOM   7301  N   ALA D  24      -4.154  45.821  51.003  1.00 38.61           N  
ATOM   7302  CA  ALA D  24      -3.487  46.014  52.280  1.00 39.00           C  
ATOM   7303  C   ALA D  24      -3.627  44.723  53.064  1.00 39.64           C  
ATOM   7304  O   ALA D  24      -2.690  44.275  53.709  1.00 39.55           O  
ATOM   7305  CB  ALA D  24      -4.126  47.153  53.039  1.00 38.69           C  
ATOM   7306  N   ASP D  25      -4.810  44.124  53.001  1.00 40.06           N  
ATOM   7307  CA  ASP D  25      -5.044  42.877  53.698  1.00 40.73           C  
ATOM   7308  C   ASP D  25      -4.102  41.807  53.155  1.00 40.65           C  
ATOM   7309  O   ASP D  25      -3.328  41.201  53.909  1.00 40.99           O  
ATOM   7310  CB  ASP D  25      -6.483  42.414  53.514  1.00 42.59           C  
ATOM   7311  CG  ASP D  25      -6.737  41.066  54.168  1.00 46.08           C  
ATOM   7312  OD1 ASP D  25      -7.200  40.139  53.467  1.00 46.78           O  
ATOM   7313  OD2 ASP D  25      -6.461  40.929  55.388  1.00 47.82           O  
ATOM   7314  N   LEU D  26      -4.162  41.584  51.844  1.00 39.63           N  
ATOM   7315  CA  LEU D  26      -3.318  40.584  51.198  1.00 38.98           C  
ATOM   7316  C   LEU D  26      -1.867  40.775  51.623  1.00 38.66           C  
ATOM   7317  O   LEU D  26      -1.188  39.825  52.006  1.00 38.73           O  
ATOM   7318  CB  LEU D  26      -3.406  40.716  49.681  1.00 38.18           C  
ATOM   7319  CG  LEU D  26      -3.153  39.446  48.864  1.00 38.24           C  
ATOM   7320  CD1 LEU D  26      -2.562  39.875  47.534  1.00 37.22           C  
ATOM   7321  CD2 LEU D  26      -2.217  38.472  49.581  1.00 36.24           C  
ATOM   7322  N   LYS D  27      -1.403  42.016  51.541  1.00 37.86           N  
ATOM   7323  CA  LYS D  27      -0.043  42.353  51.909  1.00 38.02           C  
ATOM   7324  C   LYS D  27       0.244  41.947  53.341  1.00 39.59           C  
ATOM   7325  O   LYS D  27       1.233  41.260  53.614  1.00 40.40           O  
ATOM   7326  CB  LYS D  27       0.198  43.857  51.733  1.00 36.68           C  
ATOM   7327  CG  LYS D  27       0.839  44.241  50.414  1.00 35.00           C  
ATOM   7328  CD  LYS D  27       2.244  43.671  50.330  1.00 36.93           C  
ATOM   7329  CE  LYS D  27       2.929  44.004  49.011  1.00 39.10           C  
ATOM   7330  NZ  LYS D  27       4.411  43.783  49.069  1.00 39.89           N  
ATOM   7331  N   ASN D  28      -0.616  42.361  54.264  1.00 40.21           N  
ATOM   7332  CA  ASN D  28      -0.393  42.025  55.653  1.00 41.11           C  
ATOM   7333  C   ASN D  28      -0.388  40.512  55.856  1.00 42.52           C  
ATOM   7334  O   ASN D  28       0.467  39.992  56.569  1.00 44.09           O  
ATOM   7335  CB  ASN D  28      -1.441  42.692  56.541  1.00 40.91           C  
ATOM   7336  CG  ASN D  28      -1.310  44.225  56.569  1.00 41.71           C  
ATOM   7337  OD1 ASN D  28      -0.204  44.769  56.699  1.00 40.53           O  
ATOM   7338  ND2 ASN D  28      -2.448  44.921  56.463  1.00 40.77           N  
ATOM   7339  N   LYS D  29      -1.314  39.798  55.222  1.00 42.46           N  
ATOM   7340  CA  LYS D  29      -1.359  38.347  55.370  1.00 43.44           C  
ATOM   7341  C   LYS D  29      -0.062  37.697  54.856  1.00 44.56           C  
ATOM   7342  O   LYS D  29       0.251  36.543  55.158  1.00 45.58           O  
ATOM   7343  CB  LYS D  29      -2.552  37.783  54.609  1.00 43.02           C  
ATOM   7344  CG  LYS D  29      -3.896  38.312  55.053  1.00 42.34           C  
ATOM   7345  CD  LYS D  29      -4.406  37.607  56.279  1.00 41.68           C  
ATOM   7346  CE  LYS D  29      -5.863  37.955  56.527  1.00 42.19           C  
ATOM   7347  NZ  LYS D  29      -6.753  37.465  55.435  1.00 39.87           N  
ATOM   7348  N   LEU D  30       0.693  38.436  54.062  1.00 45.48           N  
ATOM   7349  CA  LEU D  30       1.943  37.901  53.545  1.00 47.29           C  
ATOM   7350  C   LEU D  30       3.141  38.383  54.375  1.00 49.09           C  
ATOM   7351  O   LEU D  30       4.292  38.275  53.931  1.00 50.40           O  
ATOM   7352  CB  LEU D  30       2.131  38.296  52.081  1.00 46.63           C  
ATOM   7353  CG  LEU D  30       1.148  37.663  51.103  1.00 46.92           C  
ATOM   7354  CD1 LEU D  30       1.391  38.236  49.721  1.00 47.40           C  
ATOM   7355  CD2 LEU D  30       1.308  36.147  51.096  1.00 47.47           C  
ATOM   7356  N   GLY D  31       2.864  38.937  55.561  1.00 49.59           N  
ATOM   7357  CA  GLY D  31       3.922  39.386  56.460  1.00 49.24           C  
ATOM   7358  C   GLY D  31       4.441  40.810  56.359  1.00 49.94           C  
ATOM   7359  O   GLY D  31       5.565  41.112  56.797  1.00 50.28           O  
ATOM   7360  N   PHE D  32       3.655  41.705  55.782  1.00 49.97           N  
ATOM   7361  CA  PHE D  32       4.130  43.074  55.697  1.00 50.38           C  
ATOM   7362  C   PHE D  32       3.352  43.967  56.645  1.00 50.37           C  
ATOM   7363  O   PHE D  32       2.433  43.515  57.340  1.00 50.49           O  
ATOM   7364  CB  PHE D  32       4.020  43.605  54.274  1.00 50.26           C  
ATOM   7365  CG  PHE D  32       4.862  42.861  53.303  1.00 51.38           C  
ATOM   7366  CD1 PHE D  32       4.427  41.641  52.775  1.00 51.37           C  
ATOM   7367  CD2 PHE D  32       6.113  43.343  52.945  1.00 52.03           C  
ATOM   7368  CE1 PHE D  32       5.231  40.914  51.907  1.00 50.94           C  
ATOM   7369  CE2 PHE D  32       6.924  42.627  52.084  1.00 52.28           C  
ATOM   7370  CZ  PHE D  32       6.481  41.406  51.561  1.00 52.24           C  
ATOM   7371  N   ASN D  33       3.730  45.239  56.659  1.00 49.23           N  
ATOM   7372  CA  ASN D  33       3.101  46.221  57.516  1.00 48.32           C  
ATOM   7373  C   ASN D  33       2.449  47.297  56.635  1.00 47.94           C  
ATOM   7374  O   ASN D  33       3.024  48.365  56.386  1.00 48.14           O  
ATOM   7375  CB  ASN D  33       4.174  46.814  58.445  1.00 49.82           C  
ATOM   7376  CG  ASN D  33       3.605  47.788  59.469  1.00 51.50           C  
ATOM   7377  OD1 ASN D  33       2.569  47.529  60.101  1.00 52.61           O  
ATOM   7378  ND2 ASN D  33       4.292  48.912  59.647  1.00 51.32           N  
ATOM   7379  N   ALA D  34       1.239  47.015  56.163  1.00 46.11           N  
ATOM   7380  CA  ALA D  34       0.556  47.957  55.289  1.00 44.47           C  
ATOM   7381  C   ALA D  34      -0.759  48.477  55.851  1.00 43.19           C  
ATOM   7382  O   ALA D  34      -1.470  47.767  56.563  1.00 42.24           O  
ATOM   7383  CB  ALA D  34       0.321  47.312  53.920  1.00 44.42           C  
ATOM   7384  N   GLU D  35      -1.078  49.719  55.504  1.00 42.64           N  
ATOM   7385  CA  GLU D  35      -2.301  50.359  55.961  1.00 42.86           C  
ATOM   7386  C   GLU D  35      -3.048  51.039  54.803  1.00 42.10           C  
ATOM   7387  O   GLU D  35      -2.468  51.838  54.060  1.00 42.75           O  
ATOM   7388  CB  GLU D  35      -1.971  51.415  57.023  1.00 43.83           C  
ATOM   7389  CG  GLU D  35      -3.192  51.938  57.800  1.00 46.22           C  
ATOM   7390  CD  GLU D  35      -2.987  53.339  58.390  1.00 47.68           C  
ATOM   7391  OE1 GLU D  35      -1.867  53.636  58.864  1.00 48.57           O  
ATOM   7392  OE2 GLU D  35      -3.954  54.139  58.390  1.00 48.41           O  
ATOM   7393  N   PRO D  36      -4.346  50.735  54.644  1.00 40.90           N  
ATOM   7394  CA  PRO D  36      -5.169  51.322  53.585  1.00 40.02           C  
ATOM   7395  C   PRO D  36      -5.392  52.792  53.892  1.00 40.65           C  
ATOM   7396  O   PRO D  36      -5.683  53.154  55.033  1.00 41.28           O  
ATOM   7397  CB  PRO D  36      -6.475  50.546  53.687  1.00 39.27           C  
ATOM   7398  CG  PRO D  36      -6.084  49.278  54.353  1.00 40.40           C  
ATOM   7399  CD  PRO D  36      -5.102  49.717  55.382  1.00 40.17           C  
ATOM   7400  N   VAL D  37      -5.277  53.639  52.881  1.00 41.05           N  
ATOM   7401  CA  VAL D  37      -5.481  55.064  53.073  1.00 41.47           C  
ATOM   7402  C   VAL D  37      -6.213  55.702  51.889  1.00 42.35           C  
ATOM   7403  O   VAL D  37      -6.075  55.252  50.753  1.00 43.75           O  
ATOM   7404  CB  VAL D  37      -4.129  55.743  53.298  1.00 40.72           C  
ATOM   7405  CG1 VAL D  37      -4.244  57.237  53.140  1.00 41.94           C  
ATOM   7406  CG2 VAL D  37      -3.639  55.418  54.683  1.00 40.50           C  
ATOM   7407  N   ARG D  38      -7.008  56.735  52.157  1.00 43.29           N  
ATOM   7408  CA  ARG D  38      -7.736  57.441  51.099  1.00 44.27           C  
ATOM   7409  C   ARG D  38      -7.210  58.857  50.998  1.00 44.60           C  
ATOM   7410  O   ARG D  38      -6.633  59.369  51.945  1.00 43.89           O  
ATOM   7411  CB  ARG D  38      -9.230  57.477  51.394  1.00 45.22           C  
ATOM   7412  CG  ARG D  38      -9.604  58.127  52.700  1.00 47.11           C  
ATOM   7413  CD  ARG D  38     -11.072  57.898  52.978  1.00 49.24           C  
ATOM   7414  NE  ARG D  38     -11.786  59.143  53.232  1.00 51.61           N  
ATOM   7415  CZ  ARG D  38     -12.010  59.661  54.437  1.00 52.03           C  
ATOM   7416  NH1 ARG D  38     -11.577  59.046  55.537  1.00 51.85           N  
ATOM   7417  NH2 ARG D  38     -12.684  60.795  54.533  1.00 52.62           N  
ATOM   7418  N   LEU D  39      -7.406  59.489  49.847  1.00 46.06           N  
ATOM   7419  CA  LEU D  39      -6.915  60.853  49.642  1.00 47.50           C  
ATOM   7420  C   LEU D  39      -8.051  61.874  49.516  1.00 49.34           C  
ATOM   7421  O   LEU D  39      -7.814  63.044  49.194  1.00 49.56           O  
ATOM   7422  CB  LEU D  39      -6.045  60.908  48.381  1.00 46.45           C  
ATOM   7423  CG  LEU D  39      -4.913  59.884  48.210  1.00 45.21           C  
ATOM   7424  CD1 LEU D  39      -4.205  60.118  46.877  1.00 43.86           C  
ATOM   7425  CD2 LEU D  39      -3.920  60.004  49.354  1.00 45.12           C  
ATOM   7426  N   GLY D  40      -9.282  61.425  49.764  1.00 50.99           N  
ATOM   7427  CA  GLY D  40     -10.431  62.308  49.656  1.00 52.88           C  
ATOM   7428  C   GLY D  40     -11.669  61.761  50.340  1.00 54.48           C  
ATOM   7429  O   GLY D  40     -11.594  60.789  51.090  1.00 54.74           O  
ATOM   7430  N   GLN D  41     -12.814  62.380  50.068  1.00 56.51           N  
ATOM   7431  CA  GLN D  41     -14.084  61.983  50.674  1.00 58.99           C  
ATOM   7432  C   GLN D  41     -14.668  60.715  50.065  1.00 58.61           C  
ATOM   7433  O   GLN D  41     -14.608  60.502  48.852  1.00 58.35           O  
ATOM   7434  CB  GLN D  41     -15.110  63.116  50.538  1.00 61.89           C  
ATOM   7435  CG  GLN D  41     -14.725  64.422  51.246  1.00 67.27           C  
ATOM   7436  CD  GLN D  41     -13.386  64.983  50.778  1.00 70.18           C  
ATOM   7437  OE1 GLN D  41     -13.211  65.291  49.588  1.00 71.69           O  
ATOM   7438  NE2 GLN D  41     -12.430  65.111  51.711  1.00 70.18           N  
ATOM   7439  N   VAL D  42     -15.242  59.876  50.916  1.00 58.42           N  
ATOM   7440  CA  VAL D  42     -15.857  58.644  50.457  1.00 57.83           C  
ATOM   7441  C   VAL D  42     -17.277  58.967  49.971  1.00 58.16           C  
ATOM   7442  O   VAL D  42     -18.087  59.462  50.748  1.00 59.42           O  
ATOM   7443  CB  VAL D  42     -15.939  57.637  51.600  1.00 56.93           C  
ATOM   7444  CG1 VAL D  42     -16.489  56.328  51.095  1.00 57.77           C  
ATOM   7445  CG2 VAL D  42     -14.579  57.449  52.207  1.00 56.23           C  
ATOM   7446  N   ASN D  43     -17.583  58.702  48.699  1.00 57.80           N  
ATOM   7447  CA  ASN D  43     -18.923  58.984  48.180  1.00 56.66           C  
ATOM   7448  C   ASN D  43     -19.960  57.935  48.609  1.00 56.54           C  
ATOM   7449  O   ASN D  43     -19.621  56.852  49.103  1.00 55.32           O  
ATOM   7450  CB  ASN D  43     -18.917  59.117  46.647  1.00 56.76           C  
ATOM   7451  CG  ASN D  43     -18.633  57.801  45.932  1.00 57.38           C  
ATOM   7452  OD1 ASN D  43     -19.219  56.759  46.241  1.00 57.31           O  
ATOM   7453  ND2 ASN D  43     -17.739  57.850  44.954  1.00 57.34           N  
ATOM   7454  N   GLY D  44     -21.230  58.278  48.412  1.00 56.74           N  
ATOM   7455  CA  GLY D  44     -22.324  57.400  48.788  1.00 57.33           C  
ATOM   7456  C   GLY D  44     -22.229  55.969  48.306  1.00 57.74           C  
ATOM   7457  O   GLY D  44     -22.538  55.036  49.051  1.00 57.88           O  
ATOM   7458  N   GLU D  45     -21.812  55.789  47.058  1.00 58.11           N  
ATOM   7459  CA  GLU D  45     -21.684  54.456  46.485  1.00 58.06           C  
ATOM   7460  C   GLU D  45     -20.712  53.640  47.339  1.00 56.75           C  
ATOM   7461  O   GLU D  45     -21.029  52.553  47.817  1.00 55.61           O  
ATOM   7462  CB  GLU D  45     -21.165  54.565  45.055  1.00 59.35           C  
ATOM   7463  CG  GLU D  45     -21.442  53.337  44.219  1.00 60.99           C  
ATOM   7464  CD  GLU D  45     -20.633  53.310  42.946  1.00 61.97           C  
ATOM   7465  OE1 GLU D  45     -19.386  53.284  43.040  1.00 61.99           O  
ATOM   7466  OE2 GLU D  45     -21.247  53.313  41.858  1.00 62.46           O  
ATOM   7467  N   THR D  46     -19.526  54.195  47.533  1.00 55.81           N  
ATOM   7468  CA  THR D  46     -18.501  53.551  48.327  1.00 55.62           C  
ATOM   7469  C   THR D  46     -19.064  53.240  49.703  1.00 55.54           C  
ATOM   7470  O   THR D  46     -18.971  52.110  50.184  1.00 54.76           O  
ATOM   7471  CB  THR D  46     -17.302  54.469  48.491  1.00 55.49           C  
ATOM   7472  OG1 THR D  46     -16.897  54.950  47.207  1.00 55.17           O  
ATOM   7473  CG2 THR D  46     -16.160  53.726  49.136  1.00 55.75           C  
ATOM   7474  N   GLN D  47     -19.647  54.260  50.327  1.00 56.03           N  
ATOM   7475  CA  GLN D  47     -20.246  54.125  51.659  1.00 56.57           C  
ATOM   7476  C   GLN D  47     -21.110  52.871  51.787  1.00 56.42           C  
ATOM   7477  O   GLN D  47     -20.821  51.989  52.601  1.00 55.81           O  
ATOM   7478  CB  GLN D  47     -21.114  55.350  52.001  1.00 56.25           C  
ATOM   7479  CG  GLN D  47     -20.375  56.548  52.559  1.00 56.04           C  
ATOM   7480  CD  GLN D  47     -19.772  56.285  53.925  1.00 56.47           C  
ATOM   7481  OE1 GLN D  47     -19.101  57.152  54.489  1.00 57.50           O  
ATOM   7482  NE2 GLN D  47     -20.003  55.090  54.465  1.00 54.59           N  
ATOM   7483  N   TYR D  48     -22.167  52.803  50.983  1.00 56.41           N  
ATOM   7484  CA  TYR D  48     -23.079  51.674  51.034  1.00 56.87           C  
ATOM   7485  C   TYR D  48     -22.339  50.359  51.156  1.00 57.03           C  
ATOM   7486  O   TYR D  48     -22.742  49.498  51.943  1.00 57.70           O  
ATOM   7487  CB  TYR D  48     -23.972  51.642  49.800  1.00 58.04           C  
ATOM   7488  CG  TYR D  48     -24.933  50.471  49.792  1.00 60.49           C  
ATOM   7489  CD1 TYR D  48     -26.222  50.585  50.324  1.00 61.20           C  
ATOM   7490  CD2 TYR D  48     -24.549  49.233  49.267  1.00 61.35           C  
ATOM   7491  CE1 TYR D  48     -27.106  49.488  50.329  1.00 61.38           C  
ATOM   7492  CE2 TYR D  48     -25.423  48.135  49.271  1.00 61.33           C  
ATOM   7493  CZ  TYR D  48     -26.696  48.271  49.801  1.00 61.24           C  
ATOM   7494  OH  TYR D  48     -27.551  47.194  49.791  1.00 61.26           O  
ATOM   7495  N   ALA D  49     -21.258  50.209  50.386  1.00 56.70           N  
ATOM   7496  CA  ALA D  49     -20.458  48.983  50.398  1.00 56.22           C  
ATOM   7497  C   ALA D  49     -19.657  48.802  51.698  1.00 56.34           C  
ATOM   7498  O   ALA D  49     -19.553  47.690  52.246  1.00 55.71           O  
ATOM   7499  CB  ALA D  49     -19.524  48.965  49.192  1.00 55.50           C  
ATOM   7500  N   LEU D  50     -19.087  49.900  52.183  1.00 56.82           N  
ATOM   7501  CA  LEU D  50     -18.313  49.878  53.416  1.00 57.55           C  
ATOM   7502  C   LEU D  50     -19.220  49.491  54.580  1.00 59.07           C  
ATOM   7503  O   LEU D  50     -18.866  48.657  55.416  1.00 59.49           O  
ATOM   7504  CB  LEU D  50     -17.711  51.255  53.673  1.00 56.16           C  
ATOM   7505  CG  LEU D  50     -16.629  51.667  52.685  1.00 55.30           C  
ATOM   7506  CD1 LEU D  50     -16.200  53.109  52.937  1.00 54.94           C  
ATOM   7507  CD2 LEU D  50     -15.464  50.718  52.837  1.00 53.44           C  
ATOM   7508  N   ASP D  51     -20.395  50.108  54.622  1.00 60.07           N  
ATOM   7509  CA  ASP D  51     -21.361  49.834  55.670  1.00 61.19           C  
ATOM   7510  C   ASP D  51     -21.906  48.423  55.551  1.00 62.07           C  
ATOM   7511  O   ASP D  51     -21.905  47.668  56.532  1.00 61.90           O  
ATOM   7512  CB  ASP D  51     -22.513  50.829  55.588  1.00 62.25           C  
ATOM   7513  CG  ASP D  51     -22.065  52.248  55.832  1.00 63.72           C  
ATOM   7514  OD1 ASP D  51     -21.527  52.523  56.925  1.00 64.50           O  
ATOM   7515  OD2 ASP D  51     -22.244  53.089  54.930  1.00 64.75           O  
ATOM   7516  N   TYR D  52     -22.368  48.066  54.352  1.00 62.36           N  
ATOM   7517  CA  TYR D  52     -22.935  46.741  54.129  1.00 62.70           C  
ATOM   7518  C   TYR D  52     -22.002  45.632  54.612  1.00 63.32           C  
ATOM   7519  O   TYR D  52     -22.450  44.632  55.180  1.00 63.55           O  
ATOM   7520  CB  TYR D  52     -23.267  46.523  52.649  1.00 61.96           C  
ATOM   7521  CG  TYR D  52     -24.039  45.245  52.413  1.00 62.29           C  
ATOM   7522  CD1 TYR D  52     -25.416  45.262  52.201  1.00 62.37           C  
ATOM   7523  CD2 TYR D  52     -23.399  44.005  52.469  1.00 62.90           C  
ATOM   7524  CE1 TYR D  52     -26.140  44.069  52.051  1.00 63.04           C  
ATOM   7525  CE2 TYR D  52     -24.107  42.813  52.327  1.00 64.08           C  
ATOM   7526  CZ  TYR D  52     -25.477  42.847  52.119  1.00 64.26           C  
ATOM   7527  OH  TYR D  52     -26.170  41.657  52.007  1.00 63.76           O  
ATOM   7528  N   PHE D  53     -20.705  45.794  54.394  1.00 63.53           N  
ATOM   7529  CA  PHE D  53     -19.788  44.757  54.825  1.00 64.27           C  
ATOM   7530  C   PHE D  53     -19.029  45.092  56.092  1.00 65.76           C  
ATOM   7531  O   PHE D  53     -17.934  44.577  56.318  1.00 66.16           O  
ATOM   7532  CB  PHE D  53     -18.817  44.403  53.702  1.00 63.28           C  
ATOM   7533  CG  PHE D  53     -19.470  43.708  52.539  1.00 62.17           C  
ATOM   7534  CD1 PHE D  53     -19.967  44.440  51.459  1.00 62.16           C  
ATOM   7535  CD2 PHE D  53     -19.612  42.321  52.533  1.00 61.04           C  
ATOM   7536  CE1 PHE D  53     -20.595  43.802  50.385  1.00 61.54           C  
ATOM   7537  CE2 PHE D  53     -20.236  41.672  51.472  1.00 60.72           C  
ATOM   7538  CZ  PHE D  53     -20.731  42.417  50.393  1.00 61.12           C  
ATOM   7539  N   LYS D  54     -19.620  45.949  56.920  1.00 67.39           N  
ATOM   7540  CA  LYS D  54     -19.025  46.348  58.198  1.00 67.94           C  
ATOM   7541  C   LYS D  54     -17.521  46.593  58.099  1.00 66.86           C  
ATOM   7542  O   LYS D  54     -16.723  45.889  58.725  1.00 66.92           O  
ATOM   7543  CB  LYS D  54     -19.305  45.268  59.249  1.00 69.76           C  
ATOM   7544  CG  LYS D  54     -20.790  44.949  59.433  1.00 72.49           C  
ATOM   7545  CD  LYS D  54     -20.987  43.666  60.230  1.00 75.03           C  
ATOM   7546  CE  LYS D  54     -22.462  43.300  60.334  1.00 76.17           C  
ATOM   7547  NZ  LYS D  54     -22.663  41.957  60.977  1.00 76.96           N  
ATOM   7548  N   GLN D  55     -17.141  47.588  57.305  1.00 65.48           N  
ATOM   7549  CA  GLN D  55     -15.735  47.927  57.129  1.00 64.88           C  
ATOM   7550  C   GLN D  55     -15.468  49.388  57.402  1.00 64.44           C  
ATOM   7551  O   GLN D  55     -16.177  50.274  56.917  1.00 63.63           O  
ATOM   7552  CB  GLN D  55     -15.267  47.581  55.722  1.00 64.93           C  
ATOM   7553  CG  GLN D  55     -15.053  46.099  55.507  1.00 65.01           C  
ATOM   7554  CD  GLN D  55     -13.969  45.529  56.403  1.00 65.05           C  
ATOM   7555  OE1 GLN D  55     -12.798  45.917  56.314  1.00 63.70           O  
ATOM   7556  NE2 GLN D  55     -14.354  44.596  57.275  1.00 65.79           N  
ATOM   7557  N   GLU D  56     -14.416  49.625  58.173  1.00 64.48           N  
ATOM   7558  CA  GLU D  56     -14.031  50.972  58.556  1.00 64.73           C  
ATOM   7559  C   GLU D  56     -13.529  51.778  57.366  1.00 63.04           C  
ATOM   7560  O   GLU D  56     -12.784  51.267  56.531  1.00 62.91           O  
ATOM   7561  CB  GLU D  56     -12.943  50.908  59.633  1.00 67.31           C  
ATOM   7562  CG  GLU D  56     -12.774  52.199  60.435  1.00 71.21           C  
ATOM   7563  CD  GLU D  56     -14.021  52.563  61.234  1.00 74.07           C  
ATOM   7564  OE1 GLU D  56     -14.485  51.712  62.035  1.00 74.36           O  
ATOM   7565  OE2 GLU D  56     -14.526  53.701  61.057  1.00 75.10           O  
ATOM   7566  N   SER D  57     -13.946  53.038  57.286  1.00 60.94           N  
ATOM   7567  CA  SER D  57     -13.507  53.913  56.204  1.00 59.21           C  
ATOM   7568  C   SER D  57     -12.006  54.194  56.337  1.00 58.20           C  
ATOM   7569  O   SER D  57     -11.557  54.765  57.330  1.00 57.57           O  
ATOM   7570  CB  SER D  57     -14.270  55.239  56.242  1.00 58.93           C  
ATOM   7571  OG  SER D  57     -13.722  56.159  55.315  1.00 57.91           O  
ATOM   7572  N   PRO D  58     -11.212  53.804  55.325  1.00 57.49           N  
ATOM   7573  CA  PRO D  58      -9.767  54.039  55.385  1.00 56.06           C  
ATOM   7574  C   PRO D  58      -9.431  55.465  55.788  1.00 54.69           C  
ATOM   7575  O   PRO D  58     -10.085  56.424  55.376  1.00 54.37           O  
ATOM   7576  CB  PRO D  58      -9.301  53.698  53.967  1.00 56.43           C  
ATOM   7577  CG  PRO D  58     -10.518  54.003  53.116  1.00 57.01           C  
ATOM   7578  CD  PRO D  58     -11.613  53.394  53.963  1.00 58.27           C  
ATOM   7579  N   ARG D  59      -8.393  55.581  56.600  1.00 53.06           N  
ATOM   7580  CA  ARG D  59      -7.928  56.859  57.122  1.00 51.67           C  
ATOM   7581  C   ARG D  59      -7.627  57.915  56.055  1.00 51.42           C  
ATOM   7582  O   ARG D  59      -6.968  57.623  55.061  1.00 51.64           O  
ATOM   7583  CB  ARG D  59      -6.667  56.610  57.960  1.00 50.13           C  
ATOM   7584  CG  ARG D  59      -6.373  57.689  58.969  1.00 48.42           C  
ATOM   7585  CD  ARG D  59      -5.119  57.364  59.714  1.00 46.53           C  
ATOM   7586  NE  ARG D  59      -3.962  57.943  59.051  1.00 45.31           N  
ATOM   7587  CZ  ARG D  59      -2.806  57.319  58.912  1.00 44.09           C  
ATOM   7588  NH1 ARG D  59      -2.655  56.090  59.389  1.00 44.38           N  
ATOM   7589  NH2 ARG D  59      -1.809  57.923  58.302  1.00 42.36           N  
ATOM   7590  N   LEU D  60      -8.097  59.143  56.257  1.00 51.11           N  
ATOM   7591  CA  LEU D  60      -7.809  60.206  55.293  1.00 50.85           C  
ATOM   7592  C   LEU D  60      -6.362  60.685  55.473  1.00 50.81           C  
ATOM   7593  O   LEU D  60      -5.851  60.754  56.593  1.00 51.22           O  
ATOM   7594  CB  LEU D  60      -8.755  61.394  55.463  1.00 50.53           C  
ATOM   7595  CG  LEU D  60      -8.486  62.501  54.439  1.00 50.92           C  
ATOM   7596  CD1 LEU D  60      -8.996  62.055  53.098  1.00 51.19           C  
ATOM   7597  CD2 LEU D  60      -9.159  63.800  54.842  1.00 51.87           C  
ATOM   7598  N   VAL D  61      -5.714  61.031  54.367  1.00 49.94           N  
ATOM   7599  CA  VAL D  61      -4.334  61.476  54.394  1.00 49.15           C  
ATOM   7600  C   VAL D  61      -4.092  62.580  53.379  1.00 49.59           C  
ATOM   7601  O   VAL D  61      -4.701  62.597  52.314  1.00 49.31           O  
ATOM   7602  CB  VAL D  61      -3.402  60.294  54.107  1.00 48.91           C  
ATOM   7603  CG1 VAL D  61      -2.171  60.752  53.375  1.00 49.07           C  
ATOM   7604  CG2 VAL D  61      -3.023  59.624  55.409  1.00 49.00           C  
ATOM   7605  N   GLU D  62      -3.191  63.498  53.717  1.00 50.69           N  
ATOM   7606  CA  GLU D  62      -2.863  64.628  52.854  1.00 51.78           C  
ATOM   7607  C   GLU D  62      -1.481  64.516  52.240  1.00 51.05           C  
ATOM   7608  O   GLU D  62      -1.220  65.064  51.164  1.00 50.90           O  
ATOM   7609  CB  GLU D  62      -2.920  65.917  53.654  1.00 54.22           C  
ATOM   7610  CG  GLU D  62      -4.309  66.350  54.040  1.00 57.09           C  
ATOM   7611  CD  GLU D  62      -4.297  67.563  54.953  1.00 59.02           C  
ATOM   7612  OE1 GLU D  62      -3.711  68.601  54.589  1.00 60.63           O  
ATOM   7613  OE2 GLU D  62      -4.877  67.480  56.049  1.00 60.23           O  
ATOM   7614  N   THR D  63      -0.601  63.824  52.956  1.00 50.16           N  
ATOM   7615  CA  THR D  63       0.778  63.604  52.537  1.00 49.79           C  
ATOM   7616  C   THR D  63       1.287  62.256  53.083  1.00 49.19           C  
ATOM   7617  O   THR D  63       0.765  61.729  54.077  1.00 48.83           O  
ATOM   7618  CB  THR D  63       1.710  64.767  53.028  1.00 50.26           C  
ATOM   7619  OG1 THR D  63       1.404  65.101  54.388  1.00 50.65           O  
ATOM   7620  CG2 THR D  63       1.526  66.010  52.162  1.00 49.53           C  
ATOM   7621  N   ALA D  64       2.306  61.696  52.441  1.00 48.38           N  
ATOM   7622  CA  ALA D  64       2.834  60.411  52.887  1.00 48.23           C  
ATOM   7623  C   ALA D  64       4.291  60.480  53.339  1.00 47.78           C  
ATOM   7624  O   ALA D  64       4.717  59.724  54.217  1.00 46.29           O  
ATOM   7625  CB  ALA D  64       2.683  59.376  51.771  1.00 48.33           C  
ATOM   7626  N   ALA D  65       5.047  61.390  52.734  1.00 47.84           N  
ATOM   7627  CA  ALA D  65       6.458  61.547  53.054  1.00 48.12           C  
ATOM   7628  C   ALA D  65       6.731  61.561  54.557  1.00 48.55           C  
ATOM   7629  O   ALA D  65       7.695  60.951  55.041  1.00 49.60           O  
ATOM   7630  CB  ALA D  65       6.981  62.817  52.422  1.00 47.76           C  
ATOM   7631  N   ASN D  66       5.869  62.255  55.289  1.00 47.71           N  
ATOM   7632  CA  ASN D  66       5.990  62.380  56.735  1.00 46.68           C  
ATOM   7633  C   ASN D  66       5.722  61.090  57.514  1.00 46.56           C  
ATOM   7634  O   ASN D  66       6.098  60.970  58.685  1.00 47.34           O  
ATOM   7635  CB  ASN D  66       5.033  63.461  57.216  1.00 47.06           C  
ATOM   7636  CG  ASN D  66       3.592  63.164  56.836  1.00 48.68           C  
ATOM   7637  OD1 ASN D  66       2.936  62.306  57.436  1.00 49.26           O  
ATOM   7638  ND2 ASN D  66       3.094  63.863  55.819  1.00 49.02           N  
ATOM   7639  N   GLU D  67       5.076  60.120  56.885  1.00 45.58           N  
ATOM   7640  CA  GLU D  67       4.780  58.876  57.592  1.00 45.63           C  
ATOM   7641  C   GLU D  67       5.591  57.669  57.168  1.00 45.41           C  
ATOM   7642  O   GLU D  67       5.935  56.829  58.001  1.00 44.81           O  
ATOM   7643  CB  GLU D  67       3.317  58.510  57.434  1.00 45.41           C  
ATOM   7644  CG  GLU D  67       2.377  59.432  58.121  1.00 45.38           C  
ATOM   7645  CD  GLU D  67       0.963  58.970  57.976  1.00 45.55           C  
ATOM   7646  OE1 GLU D  67       0.728  57.743  58.198  1.00 44.33           O  
ATOM   7647  OE2 GLU D  67       0.114  59.838  57.644  1.00 44.77           O  
ATOM   7648  N   VAL D  68       5.869  57.575  55.871  1.00 44.89           N  
ATOM   7649  CA  VAL D  68       6.604  56.443  55.338  1.00 44.71           C  
ATOM   7650  C   VAL D  68       7.623  56.848  54.287  1.00 45.64           C  
ATOM   7651  O   VAL D  68       7.752  58.033  53.936  1.00 45.68           O  
ATOM   7652  CB  VAL D  68       5.636  55.419  54.721  1.00 43.84           C  
ATOM   7653  CG1 VAL D  68       4.906  54.659  55.827  1.00 43.20           C  
ATOM   7654  CG2 VAL D  68       4.626  56.145  53.834  1.00 42.09           C  
ATOM   7655  N   ASN D  69       8.351  55.851  53.791  1.00 45.48           N  
ATOM   7656  CA  ASN D  69       9.366  56.081  52.773  1.00 45.48           C  
ATOM   7657  C   ASN D  69       8.909  55.444  51.480  1.00 44.49           C  
ATOM   7658  O   ASN D  69       9.333  55.843  50.397  1.00 44.08           O  
ATOM   7659  CB  ASN D  69      10.684  55.463  53.219  1.00 48.38           C  
ATOM   7660  CG  ASN D  69      11.250  56.130  54.471  1.00 51.37           C  
ATOM   7661  OD1 ASN D  69      12.042  55.523  55.196  1.00 51.63           O  
ATOM   7662  ND2 ASN D  69      10.857  57.389  54.721  1.00 52.12           N  
ATOM   7663  N   GLY D  70       8.030  54.450  51.619  1.00 43.93           N  
ATOM   7664  CA  GLY D  70       7.488  53.741  50.470  1.00 41.39           C  
ATOM   7665  C   GLY D  70       5.971  53.587  50.492  1.00 39.63           C  
ATOM   7666  O   GLY D  70       5.364  53.361  51.549  1.00 39.26           O  
ATOM   7667  N   VAL D  71       5.360  53.706  49.312  1.00 37.37           N  
ATOM   7668  CA  VAL D  71       3.913  53.587  49.167  1.00 35.88           C  
ATOM   7669  C   VAL D  71       3.579  52.626  48.036  1.00 34.91           C  
ATOM   7670  O   VAL D  71       4.434  52.310  47.209  1.00 34.91           O  
ATOM   7671  CB  VAL D  71       3.267  54.948  48.820  1.00 36.00           C  
ATOM   7672  CG1 VAL D  71       3.576  55.978  49.894  1.00 36.22           C  
ATOM   7673  CG2 VAL D  71       3.797  55.436  47.486  1.00 36.57           C  
ATOM   7674  N   ILE D  72       2.330  52.165  48.013  1.00 32.69           N  
ATOM   7675  CA  ILE D  72       1.833  51.269  46.968  1.00 30.65           C  
ATOM   7676  C   ILE D  72       0.591  51.917  46.362  1.00 31.31           C  
ATOM   7677  O   ILE D  72      -0.348  52.232  47.086  1.00 33.98           O  
ATOM   7678  CB  ILE D  72       1.453  49.902  47.535  1.00 29.51           C  
ATOM   7679  CG1 ILE D  72       2.711  49.091  47.812  1.00 28.67           C  
ATOM   7680  CG2 ILE D  72       0.589  49.151  46.562  1.00 27.65           C  
ATOM   7681  CD1 ILE D  72       2.416  47.760  48.451  1.00 27.91           C  
ATOM   7682  N   LEU D  73       0.597  52.133  45.046  1.00 30.22           N  
ATOM   7683  CA  LEU D  73      -0.528  52.748  44.340  1.00 29.31           C  
ATOM   7684  C   LEU D  73      -1.480  51.717  43.750  1.00 29.82           C  
ATOM   7685  O   LEU D  73      -1.046  50.732  43.159  1.00 31.16           O  
ATOM   7686  CB  LEU D  73      -0.027  53.615  43.197  1.00 28.18           C  
ATOM   7687  CG  LEU D  73       0.946  54.732  43.543  1.00 29.58           C  
ATOM   7688  CD1 LEU D  73       1.181  55.605  42.323  1.00 29.71           C  
ATOM   7689  CD2 LEU D  73       0.377  55.558  44.671  1.00 29.81           C  
ATOM   7690  N   VAL D  74      -2.782  51.934  43.920  1.00 29.10           N  
ATOM   7691  CA  VAL D  74      -3.781  51.041  43.340  1.00 27.67           C  
ATOM   7692  C   VAL D  74      -4.763  51.901  42.549  1.00 28.11           C  
ATOM   7693  O   VAL D  74      -5.023  53.050  42.908  1.00 28.18           O  
ATOM   7694  CB  VAL D  74      -4.548  50.213  44.399  1.00 26.08           C  
ATOM   7695  CG1 VAL D  74      -3.585  49.349  45.165  1.00 25.37           C  
ATOM   7696  CG2 VAL D  74      -5.317  51.124  45.322  1.00 25.01           C  
ATOM   7697  N   ASP D  75      -5.262  51.340  41.453  1.00 28.04           N  
ATOM   7698  CA  ASP D  75      -6.213  51.995  40.574  1.00 27.63           C  
ATOM   7699  C   ASP D  75      -5.699  53.246  39.878  1.00 27.49           C  
ATOM   7700  O   ASP D  75      -6.496  54.004  39.354  1.00 28.35           O  
ATOM   7701  CB  ASP D  75      -7.501  52.324  41.341  1.00 28.89           C  
ATOM   7702  CG  ASP D  75      -8.677  52.661  40.419  1.00 31.30           C  
ATOM   7703  OD1 ASP D  75      -8.939  51.887  39.467  1.00 32.48           O  
ATOM   7704  OD2 ASP D  75      -9.358  53.688  40.649  1.00 31.32           O  
ATOM   7705  N   HIS D  76      -4.392  53.477  39.852  1.00 26.99           N  
ATOM   7706  CA  HIS D  76      -3.897  54.662  39.159  1.00 28.80           C  
ATOM   7707  C   HIS D  76      -2.395  54.751  39.072  1.00 30.52           C  
ATOM   7708  O   HIS D  76      -1.691  53.974  39.690  1.00 32.29           O  
ATOM   7709  CB  HIS D  76      -4.393  55.934  39.836  1.00 29.44           C  
ATOM   7710  CG  HIS D  76      -3.677  56.259  41.108  1.00 30.39           C  
ATOM   7711  ND1 HIS D  76      -3.765  55.473  42.236  1.00 30.76           N  
ATOM   7712  CD2 HIS D  76      -2.829  57.270  41.418  1.00 30.52           C  
ATOM   7713  CE1 HIS D  76      -3.000  55.983  43.185  1.00 31.37           C  
ATOM   7714  NE2 HIS D  76      -2.421  57.073  42.713  1.00 30.32           N  
ATOM   7715  N   ASN D  77      -1.896  55.703  38.296  1.00 32.40           N  
ATOM   7716  CA  ASN D  77      -0.461  55.868  38.220  1.00 34.18           C  
ATOM   7717  C   ASN D  77      -0.038  57.259  37.817  1.00 35.54           C  
ATOM   7718  O   ASN D  77       1.070  57.672  38.127  1.00 37.47           O  
ATOM   7719  CB  ASN D  77       0.179  54.825  37.295  1.00 35.13           C  
ATOM   7720  CG  ASN D  77      -0.266  54.948  35.844  1.00 35.24           C  
ATOM   7721  OD1 ASN D  77       0.268  55.731  35.060  1.00 34.71           O  
ATOM   7722  ND2 ASN D  77      -1.246  54.154  35.483  1.00 36.70           N  
ATOM   7723  N   GLU D  78      -0.906  58.002  37.150  1.00 35.95           N  
ATOM   7724  CA  GLU D  78      -0.531  59.352  36.750  1.00 37.42           C  
ATOM   7725  C   GLU D  78      -0.374  60.265  37.980  1.00 37.75           C  
ATOM   7726  O   GLU D  78      -1.203  60.235  38.879  1.00 37.49           O  
ATOM   7727  CB  GLU D  78      -1.577  59.878  35.772  1.00 37.57           C  
ATOM   7728  CG  GLU D  78      -1.691  58.991  34.554  1.00 39.82           C  
ATOM   7729  CD  GLU D  78      -2.662  59.496  33.512  1.00 41.81           C  
ATOM   7730  OE1 GLU D  78      -2.527  60.672  33.092  1.00 41.39           O  
ATOM   7731  OE2 GLU D  78      -3.548  58.703  33.100  1.00 42.97           O  
ATOM   7732  N   ARG D  79       0.702  61.053  38.020  1.00 38.49           N  
ATOM   7733  CA  ARG D  79       0.992  61.954  39.148  1.00 39.58           C  
ATOM   7734  C   ARG D  79      -0.175  62.794  39.641  1.00 39.53           C  
ATOM   7735  O   ARG D  79      -0.516  62.779  40.826  1.00 38.38           O  
ATOM   7736  CB  ARG D  79       2.132  62.921  38.804  1.00 41.11           C  
ATOM   7737  CG  ARG D  79       3.464  62.259  38.597  1.00 43.76           C  
ATOM   7738  CD  ARG D  79       4.526  63.255  38.221  1.00 45.13           C  
ATOM   7739  NE  ARG D  79       5.538  62.598  37.406  1.00 48.49           N  
ATOM   7740  CZ  ARG D  79       5.480  62.526  36.079  1.00 51.29           C  
ATOM   7741  NH1 ARG D  79       4.459  63.088  35.444  1.00 53.23           N  
ATOM   7742  NH2 ARG D  79       6.423  61.887  35.384  1.00 51.08           N  
ATOM   7743  N   GLN D  80      -0.770  63.550  38.727  1.00 39.31           N  
ATOM   7744  CA  GLN D  80      -1.877  64.412  39.089  1.00 40.05           C  
ATOM   7745  C   GLN D  80      -2.961  63.698  39.880  1.00 39.96           C  
ATOM   7746  O   GLN D  80      -3.575  64.286  40.768  1.00 40.49           O  
ATOM   7747  CB  GLN D  80      -2.482  65.048  37.840  1.00 40.43           C  
ATOM   7748  CG  GLN D  80      -1.725  64.742  36.577  1.00 41.95           C  
ATOM   7749  CD  GLN D  80      -2.158  63.435  35.949  1.00 43.46           C  
ATOM   7750  OE1 GLN D  80      -1.320  62.629  35.555  1.00 45.26           O  
ATOM   7751  NE2 GLN D  80      -3.473  63.224  35.837  1.00 42.03           N  
ATOM   7752  N   GLN D  81      -3.191  62.431  39.563  1.00 40.07           N  
ATOM   7753  CA  GLN D  81      -4.219  61.653  40.239  1.00 39.01           C  
ATOM   7754  C   GLN D  81      -3.759  61.106  41.570  1.00 38.40           C  
ATOM   7755  O   GLN D  81      -4.571  60.661  42.376  1.00 37.71           O  
ATOM   7756  CB  GLN D  81      -4.634  60.486  39.362  1.00 39.99           C  
ATOM   7757  CG  GLN D  81      -5.289  60.874  38.072  1.00 41.49           C  
ATOM   7758  CD  GLN D  81      -5.387  59.705  37.130  1.00 42.58           C  
ATOM   7759  OE1 GLN D  81      -5.776  58.607  37.520  1.00 43.45           O  
ATOM   7760  NE2 GLN D  81      -5.032  59.934  35.878  1.00 44.84           N  
ATOM   7761  N   SER D  82      -2.454  61.134  41.795  1.00 38.52           N  
ATOM   7762  CA  SER D  82      -1.894  60.600  43.020  1.00 39.71           C  
ATOM   7763  C   SER D  82      -1.788  61.638  44.141  1.00 41.23           C  
ATOM   7764  O   SER D  82      -2.165  62.803  43.976  1.00 41.38           O  
ATOM   7765  CB  SER D  82      -0.522  59.994  42.724  1.00 39.71           C  
ATOM   7766  OG  SER D  82      -0.212  58.957  43.640  1.00 41.54           O  
ATOM   7767  N   ILE D  83      -1.280  61.194  45.290  1.00 41.91           N  
ATOM   7768  CA  ILE D  83      -1.105  62.046  46.460  1.00 42.09           C  
ATOM   7769  C   ILE D  83      -0.349  63.327  46.119  1.00 43.71           C  
ATOM   7770  O   ILE D  83       0.274  63.448  45.057  1.00 42.80           O  
ATOM   7771  CB  ILE D  83      -0.363  61.305  47.575  1.00 40.68           C  
ATOM   7772  CG1 ILE D  83      -0.631  61.987  48.910  1.00 39.56           C  
ATOM   7773  CG2 ILE D  83       1.124  61.282  47.291  1.00 39.15           C  
ATOM   7774  CD1 ILE D  83      -0.152  61.174  50.092  1.00 40.26           C  
ATOM   7775  N   LYS D  84      -0.408  64.293  47.024  1.00 46.18           N  
ATOM   7776  CA  LYS D  84       0.234  65.579  46.781  1.00 48.06           C  
ATOM   7777  C   LYS D  84       1.757  65.482  46.746  1.00 47.64           C  
ATOM   7778  O   LYS D  84       2.388  65.907  45.784  1.00 46.95           O  
ATOM   7779  CB  LYS D  84      -0.229  66.588  47.845  1.00 50.17           C  
ATOM   7780  CG  LYS D  84       0.340  68.008  47.713  1.00 52.49           C  
ATOM   7781  CD  LYS D  84      -0.267  68.973  48.765  1.00 55.10           C  
ATOM   7782  CE  LYS D  84      -0.089  68.474  50.221  1.00 56.57           C  
ATOM   7783  NZ  LYS D  84      -0.723  69.367  51.258  1.00 55.99           N  
ATOM   7784  N   ASP D  85       2.342  64.905  47.789  1.00 47.67           N  
ATOM   7785  CA  ASP D  85       3.791  64.781  47.872  1.00 48.47           C  
ATOM   7786  C   ASP D  85       4.314  63.451  47.317  1.00 48.98           C  
ATOM   7787  O   ASP D  85       5.281  62.887  47.838  1.00 49.54           O  
ATOM   7788  CB  ASP D  85       4.243  64.968  49.332  1.00 48.79           C  
ATOM   7789  CG  ASP D  85       3.803  63.823  50.249  1.00 49.00           C  
ATOM   7790  OD1 ASP D  85       2.712  63.255  50.022  1.00 48.98           O  
ATOM   7791  OD2 ASP D  85       4.541  63.503  51.214  1.00 48.43           O  
ATOM   7792  N   ILE D  86       3.686  62.959  46.251  1.00 48.59           N  
ATOM   7793  CA  ILE D  86       4.093  61.700  45.637  1.00 48.30           C  
ATOM   7794  C   ILE D  86       5.543  61.722  45.146  1.00 50.10           C  
ATOM   7795  O   ILE D  86       6.227  60.700  45.134  1.00 50.21           O  
ATOM   7796  CB  ILE D  86       3.182  61.350  44.455  1.00 46.38           C  
ATOM   7797  CG1 ILE D  86       3.518  59.946  43.932  1.00 44.79           C  
ATOM   7798  CG2 ILE D  86       3.315  62.406  43.376  1.00 46.16           C  
ATOM   7799  CD1 ILE D  86       3.195  58.820  44.912  1.00 42.89           C  
ATOM   7800  N   GLU D  87       6.010  62.892  44.740  1.00 51.52           N  
ATOM   7801  CA  GLU D  87       7.367  63.029  44.253  1.00 53.41           C  
ATOM   7802  C   GLU D  87       8.356  62.705  45.360  1.00 53.50           C  
ATOM   7803  O   GLU D  87       9.490  62.327  45.088  1.00 54.01           O  
ATOM   7804  CB  GLU D  87       7.608  64.463  43.798  1.00 56.37           C  
ATOM   7805  CG  GLU D  87       8.571  64.600  42.646  1.00 61.40           C  
ATOM   7806  CD  GLU D  87       7.942  64.146  41.343  1.00 65.83           C  
ATOM   7807  OE1 GLU D  87       7.587  62.944  41.257  1.00 68.27           O  
ATOM   7808  OE2 GLU D  87       7.796  64.990  40.417  1.00 66.89           O  
ATOM   7809  N   GLU D  88       7.913  62.850  46.607  1.00 53.06           N  
ATOM   7810  CA  GLU D  88       8.778  62.631  47.757  1.00 52.79           C  
ATOM   7811  C   GLU D  88       8.800  61.267  48.420  1.00 50.21           C  
ATOM   7812  O   GLU D  88       9.368  61.115  49.496  1.00 50.35           O  
ATOM   7813  CB  GLU D  88       8.487  63.696  48.810  1.00 56.24           C  
ATOM   7814  CG  GLU D  88       8.891  65.096  48.371  1.00 61.84           C  
ATOM   7815  CD  GLU D  88       8.474  66.150  49.375  1.00 65.50           C  
ATOM   7816  OE1 GLU D  88       8.879  66.038  50.563  1.00 67.19           O  
ATOM   7817  OE2 GLU D  88       7.740  67.084  48.969  1.00 66.95           O  
ATOM   7818  N   VAL D  89       8.183  60.277  47.799  1.00 47.66           N  
ATOM   7819  CA  VAL D  89       8.210  58.935  48.358  1.00 45.41           C  
ATOM   7820  C   VAL D  89       8.517  57.942  47.251  1.00 44.50           C  
ATOM   7821  O   VAL D  89       8.517  58.303  46.068  1.00 44.34           O  
ATOM   7822  CB  VAL D  89       6.886  58.582  49.009  1.00 45.05           C  
ATOM   7823  CG1 VAL D  89       6.768  59.302  50.322  1.00 45.11           C  
ATOM   7824  CG2 VAL D  89       5.744  58.981  48.099  1.00 44.90           C  
ATOM   7825  N   GLN D  90       8.795  56.700  47.626  1.00 43.07           N  
ATOM   7826  CA  GLN D  90       9.100  55.680  46.632  1.00 42.11           C  
ATOM   7827  C   GLN D  90       7.907  54.799  46.313  1.00 40.66           C  
ATOM   7828  O   GLN D  90       7.338  54.183  47.201  1.00 41.88           O  
ATOM   7829  CB  GLN D  90      10.235  54.786  47.109  1.00 42.71           C  
ATOM   7830  CG  GLN D  90      10.625  53.732  46.095  1.00 45.78           C  
ATOM   7831  CD  GLN D  90      11.781  52.880  46.560  1.00 47.06           C  
ATOM   7832  OE1 GLN D  90      11.629  52.016  47.423  1.00 48.07           O  
ATOM   7833  NE2 GLN D  90      12.952  53.130  45.998  1.00 49.01           N  
ATOM   7834  N   VAL D  91       7.525  54.736  45.048  1.00 38.12           N  
ATOM   7835  CA  VAL D  91       6.415  53.884  44.663  1.00 36.68           C  
ATOM   7836  C   VAL D  91       6.930  52.431  44.634  1.00 35.56           C  
ATOM   7837  O   VAL D  91       7.616  52.030  43.710  1.00 35.41           O  
ATOM   7838  CB  VAL D  91       5.875  54.294  43.272  1.00 36.61           C  
ATOM   7839  CG1 VAL D  91       4.712  53.410  42.883  1.00 37.02           C  
ATOM   7840  CG2 VAL D  91       5.451  55.752  43.286  1.00 34.57           C  
ATOM   7841  N   LEU D  92       6.617  51.657  45.663  1.00 34.25           N  
ATOM   7842  CA  LEU D  92       7.061  50.269  45.763  1.00 33.28           C  
ATOM   7843  C   LEU D  92       6.427  49.361  44.736  1.00 33.63           C  
ATOM   7844  O   LEU D  92       7.063  48.456  44.223  1.00 33.49           O  
ATOM   7845  CB  LEU D  92       6.759  49.729  47.154  1.00 32.73           C  
ATOM   7846  CG  LEU D  92       7.889  49.744  48.182  1.00 31.77           C  
ATOM   7847  CD1 LEU D  92       8.880  50.834  47.813  1.00 31.65           C  
ATOM   7848  CD2 LEU D  92       7.317  49.942  49.586  1.00 29.26           C  
ATOM   7849  N   GLU D  93       5.152  49.586  44.471  1.00 34.41           N  
ATOM   7850  CA  GLU D  93       4.426  48.812  43.481  1.00 34.67           C  
ATOM   7851  C   GLU D  93       3.134  49.501  43.080  1.00 34.19           C  
ATOM   7852  O   GLU D  93       2.652  50.388  43.779  1.00 35.35           O  
ATOM   7853  CB  GLU D  93       4.138  47.400  43.978  1.00 33.84           C  
ATOM   7854  CG  GLU D  93       3.973  47.253  45.440  1.00 35.44           C  
ATOM   7855  CD  GLU D  93       3.651  45.806  45.819  1.00 37.34           C  
ATOM   7856  OE1 GLU D  93       2.492  45.377  45.660  1.00 38.03           O  
ATOM   7857  OE2 GLU D  93       4.558  45.080  46.267  1.00 37.35           O  
ATOM   7858  N   VAL D  94       2.596  49.098  41.935  1.00 32.78           N  
ATOM   7859  CA  VAL D  94       1.377  49.678  41.409  1.00 31.16           C  
ATOM   7860  C   VAL D  94       0.513  48.562  40.869  1.00 30.56           C  
ATOM   7861  O   VAL D  94       0.976  47.728  40.107  1.00 30.56           O  
ATOM   7862  CB  VAL D  94       1.698  50.668  40.263  1.00 31.45           C  
ATOM   7863  CG1 VAL D  94       0.433  51.229  39.670  1.00 30.17           C  
ATOM   7864  CG2 VAL D  94       2.545  51.787  40.782  1.00 31.25           C  
ATOM   7865  N   ILE D  95      -0.742  48.530  41.292  1.00 30.46           N  
ATOM   7866  CA  ILE D  95      -1.689  47.528  40.805  1.00 30.61           C  
ATOM   7867  C   ILE D  95      -2.747  48.390  40.133  1.00 31.44           C  
ATOM   7868  O   ILE D  95      -3.495  49.095  40.808  1.00 32.43           O  
ATOM   7869  CB  ILE D  95      -2.316  46.730  41.955  1.00 30.10           C  
ATOM   7870  CG1 ILE D  95      -1.233  46.075  42.812  1.00 29.45           C  
ATOM   7871  CG2 ILE D  95      -3.183  45.645  41.389  1.00 30.71           C  
ATOM   7872  CD1 ILE D  95      -0.286  45.218  42.010  1.00 28.36           C  
ATOM   7873  N   ASP D  96      -2.820  48.337  38.809  1.00 31.00           N  
ATOM   7874  CA  ASP D  96      -3.734  49.218  38.106  1.00 30.83           C  
ATOM   7875  C   ASP D  96      -4.343  48.628  36.847  1.00 31.48           C  
ATOM   7876  O   ASP D  96      -4.047  47.497  36.479  1.00 32.09           O  
ATOM   7877  CB  ASP D  96      -2.967  50.491  37.784  1.00 31.95           C  
ATOM   7878  CG  ASP D  96      -3.794  51.517  37.074  1.00 34.44           C  
ATOM   7879  OD1 ASP D  96      -4.892  51.829  37.568  1.00 35.31           O  
ATOM   7880  OD2 ASP D  96      -3.340  52.029  36.026  1.00 35.20           O  
ATOM   7881  N   HIS D  97      -5.214  49.394  36.194  1.00 31.53           N  
ATOM   7882  CA  HIS D  97      -5.856  48.938  34.978  1.00 31.01           C  
ATOM   7883  C   HIS D  97      -6.116  50.036  33.962  1.00 31.44           C  
ATOM   7884  O   HIS D  97      -7.027  49.926  33.166  1.00 32.03           O  
ATOM   7885  CB  HIS D  97      -7.156  48.184  35.309  1.00 31.49           C  
ATOM   7886  CG  HIS D  97      -8.269  49.035  35.858  1.00 33.48           C  
ATOM   7887  ND1 HIS D  97      -9.416  49.312  35.142  1.00 34.94           N  
ATOM   7888  CD2 HIS D  97      -8.456  49.582  37.082  1.00 35.13           C  
ATOM   7889  CE1 HIS D  97     -10.263  49.984  35.901  1.00 34.66           C  
ATOM   7890  NE2 HIS D  97      -9.705  50.162  37.085  1.00 35.32           N  
ATOM   7891  N   HIS D  98      -5.302  51.084  33.975  1.00 32.29           N  
ATOM   7892  CA  HIS D  98      -5.457  52.192  33.037  1.00 34.29           C  
ATOM   7893  C   HIS D  98      -4.199  52.390  32.215  1.00 35.39           C  
ATOM   7894  O   HIS D  98      -3.219  51.674  32.397  1.00 36.81           O  
ATOM   7895  CB  HIS D  98      -5.751  53.486  33.780  1.00 35.46           C  
ATOM   7896  CG  HIS D  98      -6.912  53.391  34.715  1.00 37.53           C  
ATOM   7897  ND1 HIS D  98      -6.865  52.664  35.885  1.00 38.53           N  
ATOM   7898  CD2 HIS D  98      -8.150  53.932  34.655  1.00 37.73           C  
ATOM   7899  CE1 HIS D  98      -8.027  52.762  36.508  1.00 39.31           C  
ATOM   7900  NE2 HIS D  98      -8.824  53.526  35.783  1.00 39.12           N  
ATOM   7901  N   ARG D  99      -4.220  53.367  31.315  1.00 35.58           N  
ATOM   7902  CA  ARG D  99      -3.053  53.641  30.476  1.00 35.64           C  
ATOM   7903  C   ARG D  99      -1.946  54.045  31.414  1.00 35.62           C  
ATOM   7904  O   ARG D  99      -2.202  54.345  32.572  1.00 37.22           O  
ATOM   7905  CB  ARG D  99      -3.323  54.810  29.534  1.00 36.54           C  
ATOM   7906  CG  ARG D  99      -3.338  56.146  30.262  1.00 39.28           C  
ATOM   7907  CD  ARG D  99      -4.079  57.195  29.495  1.00 41.31           C  
ATOM   7908  NE  ARG D  99      -3.218  57.936  28.600  1.00 43.71           N  
ATOM   7909  CZ  ARG D  99      -2.837  59.180  28.836  1.00 45.87           C  
ATOM   7910  NH1 ARG D  99      -3.252  59.793  29.935  1.00 45.44           N  
ATOM   7911  NH2 ARG D  99      -2.054  59.811  27.970  1.00 47.94           N  
ATOM   7912  N   ILE D 100      -0.718  54.075  30.916  1.00 35.38           N  
ATOM   7913  CA  ILE D 100       0.404  54.488  31.737  1.00 34.92           C  
ATOM   7914  C   ILE D 100       0.891  55.828  31.234  1.00 36.42           C  
ATOM   7915  O   ILE D 100       1.237  55.968  30.061  1.00 37.50           O  
ATOM   7916  CB  ILE D 100       1.539  53.491  31.655  1.00 33.31           C  
ATOM   7917  CG1 ILE D 100       1.070  52.149  32.208  1.00 33.35           C  
ATOM   7918  CG2 ILE D 100       2.727  54.013  32.417  1.00 32.49           C  
ATOM   7919  CD1 ILE D 100       2.141  51.100  32.261  1.00 33.78           C  
ATOM   7920  N   ALA D 101       0.908  56.827  32.105  1.00 37.89           N  
ATOM   7921  CA  ALA D 101       1.364  58.143  31.686  1.00 39.15           C  
ATOM   7922  C   ALA D 101       1.676  59.003  32.888  1.00 39.89           C  
ATOM   7923  O   ALA D 101       1.183  58.738  33.989  1.00 38.47           O  
ATOM   7924  CB  ALA D 101       0.304  58.815  30.827  1.00 38.25           C  
ATOM   7925  N   ASN D 102       2.495  60.032  32.675  1.00 41.16           N  
ATOM   7926  CA  ASN D 102       2.859  60.932  33.761  1.00 41.51           C  
ATOM   7927  C   ASN D 102       3.246  60.087  34.968  1.00 41.28           C  
ATOM   7928  O   ASN D 102       2.818  60.343  36.092  1.00 40.76           O  
ATOM   7929  CB  ASN D 102       1.676  61.839  34.117  1.00 43.00           C  
ATOM   7930  CG  ASN D 102       1.161  62.631  32.923  1.00 44.88           C  
ATOM   7931  OD1 ASN D 102       1.877  63.456  32.350  1.00 47.25           O  
ATOM   7932  ND2 ASN D 102      -0.088  62.380  32.541  1.00 44.89           N  
ATOM   7933  N   PHE D 103       4.035  59.054  34.706  1.00 40.49           N  
ATOM   7934  CA  PHE D 103       4.506  58.160  35.745  1.00 39.50           C  
ATOM   7935  C   PHE D 103       5.902  57.751  35.356  1.00 39.92           C  
ATOM   7936  O   PHE D 103       6.204  57.548  34.175  1.00 40.25           O  
ATOM   7937  CB  PHE D 103       3.633  56.923  35.856  1.00 39.17           C  
ATOM   7938  CG  PHE D 103       4.087  55.978  36.919  1.00 39.30           C  
ATOM   7939  CD1 PHE D 103       3.897  56.280  38.255  1.00 38.90           C  
ATOM   7940  CD2 PHE D 103       4.743  54.808  36.587  1.00 39.81           C  
ATOM   7941  CE1 PHE D 103       4.349  55.441  39.239  1.00 38.74           C  
ATOM   7942  CE2 PHE D 103       5.204  53.954  37.571  1.00 39.58           C  
ATOM   7943  CZ  PHE D 103       5.004  54.276  38.903  1.00 39.64           C  
ATOM   7944  N   GLU D 104       6.750  57.584  36.354  1.00 40.55           N  
ATOM   7945  CA  GLU D 104       8.132  57.279  36.086  1.00 40.98           C  
ATOM   7946  C   GLU D 104       8.750  56.879  37.404  1.00 40.26           C  
ATOM   7947  O   GLU D 104       8.355  57.390  38.443  1.00 41.43           O  
ATOM   7948  CB  GLU D 104       8.748  58.560  35.560  1.00 44.21           C  
ATOM   7949  CG  GLU D 104      10.160  58.533  35.091  1.00 48.61           C  
ATOM   7950  CD  GLU D 104      10.537  59.888  34.518  1.00 51.37           C  
ATOM   7951  OE1 GLU D 104      10.506  60.899  35.274  1.00 50.45           O  
ATOM   7952  OE2 GLU D 104      10.837  59.929  33.303  1.00 53.60           O  
ATOM   7953  N   THR D 105       9.700  55.954  37.371  1.00 39.42           N  
ATOM   7954  CA  THR D 105      10.357  55.512  38.593  1.00 39.79           C  
ATOM   7955  C   THR D 105      11.862  55.520  38.400  1.00 39.59           C  
ATOM   7956  O   THR D 105      12.356  55.283  37.307  1.00 38.95           O  
ATOM   7957  CB  THR D 105       9.927  54.099  38.998  1.00 39.66           C  
ATOM   7958  OG1 THR D 105      10.216  53.202  37.933  1.00 41.85           O  
ATOM   7959  CG2 THR D 105       8.450  54.045  39.292  1.00 39.77           C  
ATOM   7960  N   ALA D 106      12.589  55.801  39.471  1.00 40.70           N  
ATOM   7961  CA  ALA D 106      14.045  55.863  39.423  1.00 40.37           C  
ATOM   7962  C   ALA D 106      14.644  54.484  39.642  1.00 40.89           C  
ATOM   7963  O   ALA D 106      15.751  54.179  39.186  1.00 40.59           O  
ATOM   7964  CB  ALA D 106      14.544  56.810  40.485  1.00 39.43           C  
ATOM   7965  N   GLU D 107      13.878  53.652  40.335  1.00 40.96           N  
ATOM   7966  CA  GLU D 107      14.273  52.297  40.672  1.00 40.40           C  
ATOM   7967  C   GLU D 107      13.259  51.292  40.118  1.00 38.00           C  
ATOM   7968  O   GLU D 107      12.180  51.661  39.669  1.00 37.47           O  
ATOM   7969  CB  GLU D 107      14.318  52.174  42.199  1.00 43.37           C  
ATOM   7970  CG  GLU D 107      15.610  51.658  42.772  1.00 49.83           C  
ATOM   7971  CD  GLU D 107      16.776  52.567  42.470  1.00 54.75           C  
ATOM   7972  OE1 GLU D 107      16.713  53.752  42.876  1.00 57.18           O  
ATOM   7973  OE2 GLU D 107      17.754  52.097  41.831  1.00 57.23           O  
ATOM   7974  N   PRO D 108      13.612  50.004  40.115  1.00 36.09           N  
ATOM   7975  CA  PRO D 108      12.670  49.005  39.616  1.00 34.96           C  
ATOM   7976  C   PRO D 108      11.523  48.926  40.620  1.00 33.76           C  
ATOM   7977  O   PRO D 108      11.606  49.501  41.705  1.00 33.92           O  
ATOM   7978  CB  PRO D 108      13.505  47.732  39.612  1.00 34.87           C  
ATOM   7979  CG  PRO D 108      14.853  48.235  39.311  1.00 35.05           C  
ATOM   7980  CD  PRO D 108      14.966  49.434  40.201  1.00 35.33           C  
ATOM   7981  N   LEU D 109      10.459  48.218  40.267  1.00 31.99           N  
ATOM   7982  CA  LEU D 109       9.323  48.068  41.171  1.00 30.02           C  
ATOM   7983  C   LEU D 109       8.384  47.016  40.643  1.00 29.53           C  
ATOM   7984  O   LEU D 109       8.563  46.523  39.538  1.00 28.78           O  
ATOM   7985  CB  LEU D 109       8.584  49.394  41.349  1.00 28.30           C  
ATOM   7986  CG  LEU D 109       7.822  50.115  40.231  1.00 27.88           C  
ATOM   7987  CD1 LEU D 109       8.210  49.609  38.873  1.00 27.63           C  
ATOM   7988  CD2 LEU D 109       6.348  49.922  40.459  1.00 27.51           C  
ATOM   7989  N   TYR D 110       7.395  46.664  41.450  1.00 29.89           N  
ATOM   7990  CA  TYR D 110       6.419  45.667  41.067  1.00 31.10           C  
ATOM   7991  C   TYR D 110       5.240  46.361  40.414  1.00 31.58           C  
ATOM   7992  O   TYR D 110       4.306  46.764  41.090  1.00 32.13           O  
ATOM   7993  CB  TYR D 110       5.924  44.910  42.290  1.00 31.80           C  
ATOM   7994  CG  TYR D 110       4.983  43.769  41.962  1.00 34.21           C  
ATOM   7995  CD1 TYR D 110       5.477  42.514  41.610  1.00 34.82           C  
ATOM   7996  CD2 TYR D 110       3.602  43.941  41.996  1.00 34.92           C  
ATOM   7997  CE1 TYR D 110       4.616  41.453  41.302  1.00 35.31           C  
ATOM   7998  CE2 TYR D 110       2.736  42.884  41.685  1.00 35.70           C  
ATOM   7999  CZ  TYR D 110       3.254  41.639  41.341  1.00 35.06           C  
ATOM   8000  OH  TYR D 110       2.430  40.576  41.051  1.00 32.39           O  
ATOM   8001  N   TYR D 111       5.284  46.515  39.099  1.00 32.22           N  
ATOM   8002  CA  TYR D 111       4.183  47.153  38.390  1.00 32.94           C  
ATOM   8003  C   TYR D 111       3.358  46.056  37.734  1.00 34.25           C  
ATOM   8004  O   TYR D 111       3.888  45.239  36.976  1.00 35.09           O  
ATOM   8005  CB  TYR D 111       4.707  48.095  37.312  1.00 31.04           C  
ATOM   8006  CG  TYR D 111       3.688  49.088  36.853  1.00 30.76           C  
ATOM   8007  CD1 TYR D 111       3.810  50.437  37.186  1.00 31.61           C  
ATOM   8008  CD2 TYR D 111       2.597  48.687  36.089  1.00 30.27           C  
ATOM   8009  CE1 TYR D 111       2.869  51.374  36.762  1.00 32.16           C  
ATOM   8010  CE2 TYR D 111       1.646  49.605  35.660  1.00 30.98           C  
ATOM   8011  CZ  TYR D 111       1.789  50.956  35.997  1.00 31.96           C  
ATOM   8012  OH  TYR D 111       0.878  51.891  35.554  1.00 32.01           O  
ATOM   8013  N   ARG D 112       2.064  46.032  38.030  1.00 34.37           N  
ATOM   8014  CA  ARG D 112       1.192  45.028  37.458  1.00 34.13           C  
ATOM   8015  C   ARG D 112      -0.135  45.596  37.006  1.00 33.86           C  
ATOM   8016  O   ARG D 112      -1.041  45.788  37.805  1.00 35.04           O  
ATOM   8017  CB  ARG D 112       0.946  43.922  38.458  1.00 35.65           C  
ATOM   8018  CG  ARG D 112      -0.014  42.902  37.937  1.00 39.54           C  
ATOM   8019  CD  ARG D 112       0.174  41.575  38.625  1.00 43.78           C  
ATOM   8020  NE  ARG D 112      -0.725  40.557  38.084  1.00 47.22           N  
ATOM   8021  CZ  ARG D 112      -0.790  39.300  38.518  1.00 48.01           C  
ATOM   8022  NH1 ARG D 112      -0.007  38.887  39.508  1.00 47.61           N  
ATOM   8023  NH2 ARG D 112      -1.639  38.453  37.954  1.00 48.88           N  
ATOM   8024  N   ALA D 113      -0.243  45.862  35.713  1.00 32.89           N  
ATOM   8025  CA  ALA D 113      -1.456  46.408  35.142  1.00 32.53           C  
ATOM   8026  C   ALA D 113      -2.029  45.401  34.167  1.00 33.02           C  
ATOM   8027  O   ALA D 113      -1.291  44.720  33.468  1.00 33.59           O  
ATOM   8028  CB  ALA D 113      -1.150  47.719  34.430  1.00 31.67           C  
ATOM   8029  N   GLU D 114      -3.348  45.290  34.132  1.00 33.82           N  
ATOM   8030  CA  GLU D 114      -3.997  44.371  33.222  1.00 34.38           C  
ATOM   8031  C   GLU D 114      -5.136  45.092  32.529  1.00 35.89           C  
ATOM   8032  O   GLU D 114      -5.730  46.014  33.094  1.00 35.85           O  
ATOM   8033  CB  GLU D 114      -4.506  43.150  33.978  1.00 34.74           C  
ATOM   8034  CG  GLU D 114      -3.387  42.278  34.510  1.00 36.61           C  
ATOM   8035  CD  GLU D 114      -3.834  40.863  34.870  1.00 38.36           C  
ATOM   8036  OE1 GLU D 114      -4.793  40.361  34.238  1.00 39.58           O  
ATOM   8037  OE2 GLU D 114      -3.207  40.247  35.761  1.00 36.07           O  
ATOM   8038  N   PRO D 115      -5.446  44.693  31.281  1.00 37.35           N  
ATOM   8039  CA  PRO D 115      -6.513  45.275  30.460  1.00 37.84           C  
ATOM   8040  C   PRO D 115      -7.904  44.863  30.893  1.00 38.23           C  
ATOM   8041  O   PRO D 115      -8.723  44.494  30.064  1.00 39.68           O  
ATOM   8042  CB  PRO D 115      -6.199  44.757  29.061  1.00 37.70           C  
ATOM   8043  CG  PRO D 115      -4.754  44.409  29.115  1.00 38.27           C  
ATOM   8044  CD  PRO D 115      -4.624  43.790  30.465  1.00 38.22           C  
ATOM   8045  N   VAL D 116      -8.175  44.918  32.188  1.00 37.56           N  
ATOM   8046  CA  VAL D 116      -9.480  44.545  32.686  1.00 35.97           C  
ATOM   8047  C   VAL D 116     -10.215  45.798  33.147  1.00 36.63           C  
ATOM   8048  O   VAL D 116      -9.650  46.885  33.131  1.00 36.54           O  
ATOM   8049  CB  VAL D 116      -9.347  43.531  33.815  1.00 34.57           C  
ATOM   8050  CG1 VAL D 116      -8.723  42.264  33.273  1.00 33.68           C  
ATOM   8051  CG2 VAL D 116      -8.496  44.105  34.929  1.00 33.51           C  
ATOM   8052  N   GLY D 117     -11.474  45.644  33.550  1.00 37.31           N  
ATOM   8053  CA  GLY D 117     -12.273  46.784  33.955  1.00 37.60           C  
ATOM   8054  C   GLY D 117     -12.218  47.235  35.400  1.00 38.13           C  
ATOM   8055  O   GLY D 117     -12.860  48.212  35.775  1.00 38.44           O  
ATOM   8056  N   CYS D 118     -11.443  46.551  36.222  1.00 38.00           N  
ATOM   8057  CA  CYS D 118     -11.376  46.936  37.617  1.00 36.85           C  
ATOM   8058  C   CYS D 118     -10.135  46.389  38.309  1.00 35.31           C  
ATOM   8059  O   CYS D 118      -9.735  45.248  38.070  1.00 36.05           O  
ATOM   8060  CB  CYS D 118     -12.633  46.435  38.318  1.00 37.81           C  
ATOM   8061  SG  CYS D 118     -12.651  46.713  40.081  1.00 43.04           S  
ATOM   8062  N   THR D 119      -9.543  47.205  39.173  1.00 32.93           N  
ATOM   8063  CA  THR D 119      -8.350  46.827  39.917  1.00 31.84           C  
ATOM   8064  C   THR D 119      -8.560  45.561  40.753  1.00 32.66           C  
ATOM   8065  O   THR D 119      -7.651  44.738  40.894  1.00 32.78           O  
ATOM   8066  CB  THR D 119      -7.925  47.954  40.863  1.00 30.04           C  
ATOM   8067  OG1 THR D 119      -8.148  49.211  40.231  1.00 28.37           O  
ATOM   8068  CG2 THR D 119      -6.457  47.852  41.182  1.00 28.52           C  
ATOM   8069  N   ALA D 120      -9.760  45.403  41.305  1.00 32.63           N  
ATOM   8070  CA  ALA D 120     -10.069  44.241  42.128  1.00 33.04           C  
ATOM   8071  C   ALA D 120      -9.927  42.921  41.389  1.00 33.55           C  
ATOM   8072  O   ALA D 120      -9.520  41.926  41.969  1.00 33.95           O  
ATOM   8073  CB  ALA D 120     -11.459  44.361  42.682  1.00 33.72           C  
ATOM   8074  N   THR D 121     -10.279  42.914  40.112  1.00 33.83           N  
ATOM   8075  CA  THR D 121     -10.184  41.710  39.299  1.00 34.35           C  
ATOM   8076  C   THR D 121      -8.768  41.169  39.336  1.00 34.81           C  
ATOM   8077  O   THR D 121      -8.550  39.956  39.352  1.00 35.58           O  
ATOM   8078  CB  THR D 121     -10.517  41.988  37.820  1.00 34.49           C  
ATOM   8079  OG1 THR D 121     -11.809  42.605  37.718  1.00 35.74           O  
ATOM   8080  CG2 THR D 121     -10.498  40.687  37.029  1.00 32.72           C  
ATOM   8081  N   ILE D 122      -7.810  42.085  39.329  1.00 34.31           N  
ATOM   8082  CA  ILE D 122      -6.409  41.721  39.353  1.00 34.81           C  
ATOM   8083  C   ILE D 122      -6.055  41.179  40.723  1.00 35.99           C  
ATOM   8084  O   ILE D 122      -5.470  40.101  40.819  1.00 36.79           O  
ATOM   8085  CB  ILE D 122      -5.508  42.934  39.033  1.00 33.92           C  
ATOM   8086  CG1 ILE D 122      -5.887  43.513  37.664  1.00 34.37           C  
ATOM   8087  CG2 ILE D 122      -4.052  42.517  39.012  1.00 32.14           C  
ATOM   8088  CD1 ILE D 122      -5.163  44.800  37.299  1.00 34.88           C  
ATOM   8089  N   LEU D 123      -6.411  41.912  41.781  1.00 35.97           N  
ATOM   8090  CA  LEU D 123      -6.116  41.472  43.146  1.00 35.80           C  
ATOM   8091  C   LEU D 123      -6.607  40.041  43.334  1.00 37.14           C  
ATOM   8092  O   LEU D 123      -5.866  39.184  43.823  1.00 37.10           O  
ATOM   8093  CB  LEU D 123      -6.785  42.395  44.171  1.00 34.73           C  
ATOM   8094  CG  LEU D 123      -6.333  43.863  44.212  1.00 34.16           C  
ATOM   8095  CD1 LEU D 123      -7.253  44.659  45.133  1.00 33.00           C  
ATOM   8096  CD2 LEU D 123      -4.887  43.948  44.670  1.00 31.93           C  
ATOM   8097  N   ASN D 124      -7.848  39.783  42.927  1.00 37.80           N  
ATOM   8098  CA  ASN D 124      -8.430  38.456  43.039  1.00 37.87           C  
ATOM   8099  C   ASN D 124      -7.499  37.403  42.449  1.00 37.79           C  
ATOM   8100  O   ASN D 124      -7.408  36.297  42.974  1.00 38.01           O  
ATOM   8101  CB  ASN D 124      -9.788  38.410  42.339  1.00 40.10           C  
ATOM   8102  CG  ASN D 124     -10.399  37.015  42.334  1.00 42.55           C  
ATOM   8103  OD1 ASN D 124     -10.786  36.479  43.377  1.00 43.98           O  
ATOM   8104  ND2 ASN D 124     -10.482  36.419  41.151  1.00 44.26           N  
ATOM   8105  N   LYS D 125      -6.811  37.724  41.354  1.00 38.09           N  
ATOM   8106  CA  LYS D 125      -5.876  36.760  40.770  1.00 38.77           C  
ATOM   8107  C   LYS D 125      -4.722  36.585  41.754  1.00 39.30           C  
ATOM   8108  O   LYS D 125      -4.276  35.474  42.038  1.00 39.42           O  
ATOM   8109  CB  LYS D 125      -5.271  37.267  39.464  1.00 38.59           C  
ATOM   8110  CG  LYS D 125      -6.162  37.328  38.252  1.00 39.84           C  
ATOM   8111  CD  LYS D 125      -5.296  37.520  36.986  1.00 40.98           C  
ATOM   8112  CE  LYS D 125      -6.130  37.750  35.721  1.00 41.23           C  
ATOM   8113  NZ  LYS D 125      -5.353  37.763  34.439  1.00 41.08           N  
HETATM 8114  N   MSE D 126      -4.244  37.715  42.265  1.00 39.09           N  
HETATM 8115  CA  MSE D 126      -3.135  37.748  43.196  1.00 40.13           C  
HETATM 8116  C   MSE D 126      -3.375  36.991  44.499  1.00 41.93           C  
HETATM 8117  O   MSE D 126      -2.437  36.430  45.078  1.00 40.77           O  
HETATM 8118  CB  MSE D 126      -2.757  39.201  43.463  1.00 39.67           C  
HETATM 8119  CG  MSE D 126      -2.244  39.867  42.213  1.00 39.99           C  
HETATM 8120 SE   MSE D 126      -1.700  41.662  42.427  1.00 42.96          SE  
HETATM 8121  CE  MSE D 126      -0.060  41.402  43.322  1.00 42.12           C  
ATOM   8122  N   TYR D 127      -4.617  36.975  44.976  1.00 43.12           N  
ATOM   8123  CA  TYR D 127      -4.912  36.243  46.200  1.00 44.14           C  
ATOM   8124  C   TYR D 127      -4.671  34.765  45.915  1.00 45.20           C  
ATOM   8125  O   TYR D 127      -3.984  34.079  46.665  1.00 46.36           O  
ATOM   8126  CB  TYR D 127      -6.367  36.429  46.631  1.00 44.60           C  
ATOM   8127  CG  TYR D 127      -6.589  37.517  47.654  1.00 44.09           C  
ATOM   8128  CD1 TYR D 127      -7.020  38.780  47.274  1.00 42.83           C  
ATOM   8129  CD2 TYR D 127      -6.352  37.282  49.005  1.00 43.90           C  
ATOM   8130  CE1 TYR D 127      -7.206  39.780  48.210  1.00 43.53           C  
ATOM   8131  CE2 TYR D 127      -6.534  38.276  49.951  1.00 43.68           C  
ATOM   8132  CZ  TYR D 127      -6.960  39.525  49.548  1.00 43.11           C  
ATOM   8133  OH  TYR D 127      -7.130  40.528  50.474  1.00 42.01           O  
ATOM   8134  N   LYS D 128      -5.229  34.276  44.817  1.00 45.70           N  
ATOM   8135  CA  LYS D 128      -5.068  32.873  44.462  1.00 46.83           C  
ATOM   8136  C   LYS D 128      -3.629  32.556  44.129  1.00 46.80           C  
ATOM   8137  O   LYS D 128      -3.137  31.476  44.437  1.00 46.57           O  
ATOM   8138  CB  LYS D 128      -5.929  32.507  43.252  1.00 47.55           C  
ATOM   8139  CG  LYS D 128      -7.392  32.907  43.343  1.00 48.57           C  
ATOM   8140  CD  LYS D 128      -8.147  32.402  42.131  1.00 48.84           C  
ATOM   8141  CE  LYS D 128      -9.313  33.296  41.796  1.00 49.73           C  
ATOM   8142  NZ  LYS D 128      -9.871  32.877  40.491  1.00 51.58           N  
ATOM   8143  N   GLU D 129      -2.953  33.493  43.481  1.00 47.71           N  
ATOM   8144  CA  GLU D 129      -1.576  33.260  43.105  1.00 49.02           C  
ATOM   8145  C   GLU D 129      -0.711  33.044  44.328  1.00 51.21           C  
ATOM   8146  O   GLU D 129       0.201  32.225  44.302  1.00 51.80           O  
ATOM   8147  CB  GLU D 129      -1.064  34.421  42.259  1.00 48.06           C  
ATOM   8148  CG  GLU D 129      -1.749  34.492  40.901  1.00 48.82           C  
ATOM   8149  CD  GLU D 129      -1.213  35.592  40.009  1.00 49.83           C  
ATOM   8150  OE1 GLU D 129      -1.611  35.637  38.820  1.00 50.00           O  
ATOM   8151  OE2 GLU D 129      -0.402  36.415  40.492  1.00 50.28           O  
ATOM   8152  N   ASN D 130      -1.013  33.764  45.404  1.00 53.76           N  
ATOM   8153  CA  ASN D 130      -0.273  33.654  46.657  1.00 55.81           C  
ATOM   8154  C   ASN D 130      -0.951  32.701  47.621  1.00 58.45           C  
ATOM   8155  O   ASN D 130      -0.524  32.558  48.768  1.00 59.72           O  
ATOM   8156  CB  ASN D 130      -0.168  35.016  47.311  1.00 55.12           C  
ATOM   8157  CG  ASN D 130       0.931  35.835  46.735  1.00 55.18           C  
ATOM   8158  OD1 ASN D 130       2.104  35.566  46.989  1.00 55.89           O  
ATOM   8159  ND2 ASN D 130       0.574  36.836  45.937  1.00 54.82           N  
ATOM   8160  N   ASN D 131      -2.006  32.051  47.151  1.00 61.28           N  
ATOM   8161  CA  ASN D 131      -2.756  31.128  47.983  1.00 64.86           C  
ATOM   8162  C   ASN D 131      -3.017  31.744  49.362  1.00 66.16           C  
ATOM   8163  O   ASN D 131      -2.359  31.417  50.361  1.00 67.33           O  
ATOM   8164  CB  ASN D 131      -2.000  29.818  48.136  1.00 67.36           C  
ATOM   8165  CG  ASN D 131      -2.707  28.840  49.076  1.00 70.75           C  
ATOM   8166  OD1 ASN D 131      -3.943  28.750  49.083  1.00 71.83           O  
ATOM   8167  ND2 ASN D 131      -1.921  28.092  49.865  1.00 71.79           N  
ATOM   8168  N   VAL D 132      -3.974  32.657  49.398  1.00 66.18           N  
ATOM   8169  CA  VAL D 132      -4.360  33.318  50.628  1.00 66.27           C  
ATOM   8170  C   VAL D 132      -5.873  33.336  50.575  1.00 66.93           C  
ATOM   8171  O   VAL D 132      -6.458  33.832  49.613  1.00 67.00           O  
ATOM   8172  CB  VAL D 132      -3.829  34.765  50.683  1.00 65.95           C  
ATOM   8173  CG1 VAL D 132      -4.447  35.503  51.864  1.00 65.55           C  
ATOM   8174  CG2 VAL D 132      -2.307  34.758  50.780  1.00 64.88           C  
ATOM   8175  N   LYS D 133      -6.512  32.774  51.592  1.00 67.68           N  
ATOM   8176  CA  LYS D 133      -7.964  32.743  51.622  1.00 68.57           C  
ATOM   8177  C   LYS D 133      -8.502  34.166  51.741  1.00 68.07           C  
ATOM   8178  O   LYS D 133      -7.942  34.994  52.461  1.00 68.13           O  
ATOM   8179  CB  LYS D 133      -8.432  31.868  52.791  1.00 70.47           C  
ATOM   8180  CG  LYS D 133      -9.946  31.740  52.955  1.00 72.18           C  
ATOM   8181  CD  LYS D 133     -10.305  30.624  53.947  1.00 73.36           C  
ATOM   8182  CE  LYS D 133     -11.616  30.909  54.670  1.00 74.28           C  
ATOM   8183  NZ  LYS D 133     -11.529  32.126  55.549  1.00 75.46           N  
ATOM   8184  N   ILE D 134      -9.574  34.449  51.009  1.00 67.84           N  
ATOM   8185  CA  ILE D 134     -10.196  35.769  51.028  1.00 68.65           C  
ATOM   8186  C   ILE D 134     -11.319  35.855  52.068  1.00 70.26           C  
ATOM   8187  O   ILE D 134     -12.320  35.140  51.979  1.00 70.52           O  
ATOM   8188  CB  ILE D 134     -10.785  36.115  49.653  1.00 67.59           C  
ATOM   8189  CG1 ILE D 134      -9.655  36.272  48.634  1.00 66.98           C  
ATOM   8190  CG2 ILE D 134     -11.624  37.378  49.749  1.00 66.98           C  
ATOM   8191  CD1 ILE D 134     -10.139  36.439  47.205  1.00 66.28           C  
ATOM   8192  N   GLU D 135     -11.152  36.733  53.050  1.00 71.40           N  
ATOM   8193  CA  GLU D 135     -12.155  36.900  54.091  1.00 72.75           C  
ATOM   8194  C   GLU D 135     -13.470  37.383  53.490  1.00 72.71           C  
ATOM   8195  O   GLU D 135     -13.484  38.298  52.667  1.00 72.34           O  
ATOM   8196  CB  GLU D 135     -11.662  37.899  55.146  1.00 74.95           C  
ATOM   8197  CG  GLU D 135     -10.690  37.314  56.187  1.00 78.44           C  
ATOM   8198  CD  GLU D 135     -10.063  38.381  57.099  1.00 80.61           C  
ATOM   8199  OE1 GLU D 135     -10.784  39.301  57.556  1.00 80.98           O  
ATOM   8200  OE2 GLU D 135      -8.843  38.290  57.371  1.00 81.94           O  
ATOM   8201  N   LYS D 136     -14.567  36.747  53.899  1.00 73.18           N  
ATOM   8202  CA  LYS D 136     -15.904  37.099  53.425  1.00 72.87           C  
ATOM   8203  C   LYS D 136     -16.043  38.615  53.395  1.00 71.73           C  
ATOM   8204  O   LYS D 136     -16.464  39.194  52.399  1.00 71.32           O  
ATOM   8205  CB  LYS D 136     -16.965  36.511  54.364  1.00 74.63           C  
ATOM   8206  CG  LYS D 136     -18.405  36.891  54.019  1.00 77.05           C  
ATOM   8207  CD  LYS D 136     -19.380  36.587  55.171  1.00 79.45           C  
ATOM   8208  CE  LYS D 136     -19.485  35.087  55.496  1.00 81.28           C  
ATOM   8209  NZ  LYS D 136     -20.107  34.260  54.403  1.00 82.19           N  
ATOM   8210  N   GLU D 137     -15.672  39.246  54.501  1.00 70.81           N  
ATOM   8211  CA  GLU D 137     -15.741  40.699  54.646  1.00 69.62           C  
ATOM   8212  C   GLU D 137     -15.181  41.488  53.447  1.00 66.82           C  
ATOM   8213  O   GLU D 137     -15.895  42.282  52.829  1.00 66.31           O  
ATOM   8214  CB  GLU D 137     -15.007  41.126  55.936  1.00 72.14           C  
ATOM   8215  CG  GLU D 137     -15.692  40.728  57.250  1.00 74.20           C  
ATOM   8216  CD  GLU D 137     -16.939  41.556  57.522  1.00 76.30           C  
ATOM   8217  OE1 GLU D 137     -17.607  41.337  58.561  1.00 76.96           O  
ATOM   8218  OE2 GLU D 137     -17.248  42.432  56.684  1.00 76.62           O  
ATOM   8219  N   ILE D 138     -13.905  41.269  53.124  1.00 63.67           N  
ATOM   8220  CA  ILE D 138     -13.262  41.987  52.023  1.00 59.91           C  
ATOM   8221  C   ILE D 138     -13.719  41.547  50.636  1.00 57.29           C  
ATOM   8222  O   ILE D 138     -13.835  42.378  49.738  1.00 56.86           O  
ATOM   8223  CB  ILE D 138     -11.720  41.896  52.099  1.00 59.08           C  
ATOM   8224  CG1 ILE D 138     -11.275  40.449  52.004  1.00 59.63           C  
ATOM   8225  CG2 ILE D 138     -11.219  42.483  53.408  1.00 58.53           C  
ATOM   8226  CD1 ILE D 138      -9.774  40.295  52.094  1.00 60.74           C  
ATOM   8227  N   ALA D 139     -13.979  40.254  50.452  1.00 54.25           N  
ATOM   8228  CA  ALA D 139     -14.450  39.772  49.158  1.00 51.79           C  
ATOM   8229  C   ALA D 139     -15.594  40.677  48.695  1.00 50.34           C  
ATOM   8230  O   ALA D 139     -15.711  41.003  47.510  1.00 50.01           O  
ATOM   8231  CB  ALA D 139     -14.931  38.332  49.267  1.00 50.58           C  
ATOM   8232  N   GLY D 140     -16.423  41.095  49.650  1.00 48.68           N  
ATOM   8233  CA  GLY D 140     -17.544  41.965  49.340  1.00 45.64           C  
ATOM   8234  C   GLY D 140     -17.086  43.307  48.809  1.00 43.84           C  
ATOM   8235  O   GLY D 140     -17.661  43.828  47.857  1.00 42.74           O  
ATOM   8236  N   LEU D 141     -16.054  43.872  49.427  1.00 42.13           N  
ATOM   8237  CA  LEU D 141     -15.513  45.156  48.983  1.00 41.13           C  
ATOM   8238  C   LEU D 141     -14.990  45.034  47.555  1.00 40.92           C  
ATOM   8239  O   LEU D 141     -15.136  45.957  46.746  1.00 40.54           O  
ATOM   8240  CB  LEU D 141     -14.362  45.606  49.885  1.00 39.03           C  
ATOM   8241  CG  LEU D 141     -14.742  46.049  51.283  1.00 37.74           C  
ATOM   8242  CD1 LEU D 141     -13.490  46.294  52.073  1.00 35.07           C  
ATOM   8243  CD2 LEU D 141     -15.589  47.301  51.188  1.00 37.14           C  
HETATM 8244  N   MSE D 142     -14.366  43.895  47.259  1.00 40.44           N  
HETATM 8245  CA  MSE D 142     -13.816  43.644  45.936  1.00 38.37           C  
HETATM 8246  C   MSE D 142     -14.962  43.545  44.952  1.00 36.39           C  
HETATM 8247  O   MSE D 142     -14.961  44.203  43.907  1.00 34.22           O  
HETATM 8248  CB  MSE D 142     -12.985  42.357  45.953  1.00 38.67           C  
HETATM 8249  CG  MSE D 142     -11.731  42.473  46.819  1.00 39.36           C  
HETATM 8250 SE   MSE D 142     -10.522  40.965  46.715  1.00 42.42          SE  
HETATM 8251  CE  MSE D 142     -10.787  40.264  48.480  1.00 41.72           C  
ATOM   8252  N   LEU D 143     -15.948  42.733  45.309  1.00 35.62           N  
ATOM   8253  CA  LEU D 143     -17.125  42.550  44.474  1.00 35.88           C  
ATOM   8254  C   LEU D 143     -17.760  43.920  44.250  1.00 36.57           C  
ATOM   8255  O   LEU D 143     -18.195  44.235  43.149  1.00 35.79           O  
ATOM   8256  CB  LEU D 143     -18.104  41.596  45.163  1.00 35.39           C  
ATOM   8257  CG  LEU D 143     -19.405  41.155  44.479  1.00 34.59           C  
ATOM   8258  CD1 LEU D 143     -20.507  42.143  44.755  1.00 34.51           C  
ATOM   8259  CD2 LEU D 143     -19.181  41.000  42.997  1.00 34.23           C  
ATOM   8260  N   SER D 144     -17.800  44.736  45.301  1.00 37.02           N  
ATOM   8261  CA  SER D 144     -18.355  46.087  45.195  1.00 37.37           C  
ATOM   8262  C   SER D 144     -17.582  46.858  44.122  1.00 37.23           C  
ATOM   8263  O   SER D 144     -18.169  47.384  43.182  1.00 36.15           O  
ATOM   8264  CB  SER D 144     -18.226  46.847  46.526  1.00 38.46           C  
ATOM   8265  OG  SER D 144     -18.894  46.194  47.591  1.00 40.33           O  
ATOM   8266  N   ALA D 145     -16.259  46.924  44.274  1.00 37.52           N  
ATOM   8267  CA  ALA D 145     -15.406  47.625  43.316  1.00 36.91           C  
ATOM   8268  C   ALA D 145     -15.668  47.167  41.870  1.00 36.04           C  
ATOM   8269  O   ALA D 145     -15.816  48.004  40.970  1.00 35.38           O  
ATOM   8270  CB  ALA D 145     -13.925  47.433  43.680  1.00 38.04           C  
ATOM   8271  N   ILE D 146     -15.733  45.855  41.632  1.00 34.44           N  
ATOM   8272  CA  ILE D 146     -16.000  45.394  40.272  1.00 33.29           C  
ATOM   8273  C   ILE D 146     -17.338  45.932  39.787  1.00 34.47           C  
ATOM   8274  O   ILE D 146     -17.416  46.541  38.721  1.00 34.54           O  
ATOM   8275  CB  ILE D 146     -16.016  43.870  40.171  1.00 30.56           C  
ATOM   8276  CG1 ILE D 146     -14.640  43.333  40.548  1.00 28.75           C  
ATOM   8277  CG2 ILE D 146     -16.380  43.459  38.760  1.00 27.25           C  
ATOM   8278  CD1 ILE D 146     -14.562  41.864  40.671  1.00 26.82           C  
ATOM   8279  N   ILE D 147     -18.391  45.713  40.572  1.00 35.50           N  
ATOM   8280  CA  ILE D 147     -19.720  46.204  40.207  1.00 37.10           C  
ATOM   8281  C   ILE D 147     -19.603  47.699  39.867  1.00 38.82           C  
ATOM   8282  O   ILE D 147     -20.013  48.140  38.789  1.00 39.32           O  
ATOM   8283  CB  ILE D 147     -20.764  46.043  41.378  1.00 36.56           C  
ATOM   8284  CG1 ILE D 147     -20.887  44.584  41.821  1.00 34.47           C  
ATOM   8285  CG2 ILE D 147     -22.128  46.532  40.922  1.00 36.15           C  
ATOM   8286  CD1 ILE D 147     -21.424  43.672  40.765  1.00 34.36           C  
ATOM   8287  N   SER D 148     -19.028  48.464  40.790  1.00 39.98           N  
ATOM   8288  CA  SER D 148     -18.858  49.903  40.618  1.00 41.60           C  
ATOM   8289  C   SER D 148     -18.174  50.308  39.301  1.00 43.50           C  
ATOM   8290  O   SER D 148     -18.702  51.134  38.539  1.00 43.41           O  
ATOM   8291  CB  SER D 148     -18.078  50.464  41.811  1.00 41.60           C  
ATOM   8292  OG  SER D 148     -17.619  51.779  41.562  1.00 42.98           O  
ATOM   8293  N   ASP D 149     -17.005  49.730  39.028  1.00 44.82           N  
ATOM   8294  CA  ASP D 149     -16.271  50.061  37.808  1.00 45.98           C  
ATOM   8295  C   ASP D 149     -16.935  49.541  36.530  1.00 46.92           C  
ATOM   8296  O   ASP D 149     -16.836  50.183  35.484  1.00 47.53           O  
ATOM   8297  CB  ASP D 149     -14.829  49.530  37.878  1.00 46.52           C  
ATOM   8298  CG  ASP D 149     -13.829  50.572  38.377  1.00 47.34           C  
ATOM   8299  OD1 ASP D 149     -14.191  51.765  38.475  1.00 47.36           O  
ATOM   8300  OD2 ASP D 149     -12.666  50.190  38.655  1.00 47.74           O  
ATOM   8301  N   SER D 150     -17.614  48.396  36.601  1.00 46.94           N  
ATOM   8302  CA  SER D 150     -18.243  47.840  35.409  1.00 48.20           C  
ATOM   8303  C   SER D 150     -19.708  48.216  35.233  1.00 49.80           C  
ATOM   8304  O   SER D 150     -20.368  47.715  34.313  1.00 50.82           O  
ATOM   8305  CB  SER D 150     -18.114  46.316  35.400  1.00 47.32           C  
ATOM   8306  OG  SER D 150     -18.791  45.738  36.497  1.00 45.72           O  
ATOM   8307  N   LEU D 151     -20.217  49.099  36.094  1.00 49.91           N  
ATOM   8308  CA  LEU D 151     -21.622  49.512  36.014  1.00 48.99           C  
ATOM   8309  C   LEU D 151     -22.475  48.271  35.869  1.00 49.12           C  
ATOM   8310  O   LEU D 151     -23.298  48.157  34.969  1.00 48.20           O  
ATOM   8311  CB  LEU D 151     -21.839  50.434  34.823  1.00 48.52           C  
ATOM   8312  CG  LEU D 151     -21.285  51.848  35.026  1.00 48.71           C  
ATOM   8313  CD1 LEU D 151     -21.320  52.639  33.720  1.00 47.70           C  
ATOM   8314  CD2 LEU D 151     -22.106  52.536  36.107  1.00 49.08           C  
ATOM   8315  N   LEU D 152     -22.236  47.330  36.772  1.00 50.15           N  
ATOM   8316  CA  LEU D 152     -22.937  46.068  36.799  1.00 51.12           C  
ATOM   8317  C   LEU D 152     -22.734  45.274  35.504  1.00 51.96           C  
ATOM   8318  O   LEU D 152     -23.690  44.781  34.905  1.00 52.36           O  
ATOM   8319  CB  LEU D 152     -24.421  46.306  37.059  1.00 50.83           C  
ATOM   8320  CG  LEU D 152     -25.110  45.138  37.762  1.00 51.15           C  
ATOM   8321  CD1 LEU D 152     -24.406  44.879  39.088  1.00 50.79           C  
ATOM   8322  CD2 LEU D 152     -26.573  45.450  37.990  1.00 51.41           C  
ATOM   8323  N   PHE D 153     -21.476  45.156  35.085  1.00 52.14           N  
ATOM   8324  CA  PHE D 153     -21.097  44.401  33.887  1.00 52.71           C  
ATOM   8325  C   PHE D 153     -21.593  44.985  32.579  1.00 52.75           C  
ATOM   8326  O   PHE D 153     -21.447  44.364  31.527  1.00 51.93           O  
ATOM   8327  CB  PHE D 153     -21.580  42.954  34.001  1.00 52.82           C  
ATOM   8328  CG  PHE D 153     -21.372  42.362  35.359  1.00 54.02           C  
ATOM   8329  CD1 PHE D 153     -22.456  42.005  36.149  1.00 54.85           C  
ATOM   8330  CD2 PHE D 153     -20.093  42.202  35.869  1.00 54.91           C  
ATOM   8331  CE1 PHE D 153     -22.269  41.498  37.434  1.00 55.77           C  
ATOM   8332  CE2 PHE D 153     -19.897  41.695  37.153  1.00 56.20           C  
ATOM   8333  CZ  PHE D 153     -20.986  41.343  37.936  1.00 55.96           C  
ATOM   8334  N   LYS D 154     -22.171  46.179  32.641  1.00 53.40           N  
ATOM   8335  CA  LYS D 154     -22.685  46.825  31.446  1.00 53.94           C  
ATOM   8336  C   LYS D 154     -21.679  47.757  30.789  1.00 53.39           C  
ATOM   8337  O   LYS D 154     -21.858  48.156  29.642  1.00 53.46           O  
ATOM   8338  CB  LYS D 154     -23.970  47.597  31.776  1.00 55.80           C  
ATOM   8339  CG  LYS D 154     -25.192  46.719  32.046  1.00 58.17           C  
ATOM   8340  CD  LYS D 154     -25.556  45.886  30.805  1.00 61.63           C  
ATOM   8341  CE  LYS D 154     -26.739  44.941  31.051  1.00 62.63           C  
ATOM   8342  NZ  LYS D 154     -27.036  44.085  29.861  1.00 62.26           N  
ATOM   8343  N   SER D 155     -20.621  48.095  31.517  1.00 53.42           N  
ATOM   8344  CA  SER D 155     -19.586  48.989  31.001  1.00 54.08           C  
ATOM   8345  C   SER D 155     -18.858  48.445  29.773  1.00 54.65           C  
ATOM   8346  O   SER D 155     -18.626  47.242  29.643  1.00 55.74           O  
ATOM   8347  CB  SER D 155     -18.554  49.287  32.089  1.00 54.61           C  
ATOM   8348  OG  SER D 155     -17.434  49.964  31.540  1.00 54.42           O  
ATOM   8349  N   PRO D 156     -18.468  49.335  28.857  1.00 54.34           N  
ATOM   8350  CA  PRO D 156     -17.758  48.945  27.633  1.00 53.73           C  
ATOM   8351  C   PRO D 156     -16.376  48.358  27.918  1.00 52.91           C  
ATOM   8352  O   PRO D 156     -15.798  47.664  27.084  1.00 51.94           O  
ATOM   8353  CB  PRO D 156     -17.668  50.255  26.866  1.00 54.12           C  
ATOM   8354  CG  PRO D 156     -17.533  51.270  27.975  1.00 55.47           C  
ATOM   8355  CD  PRO D 156     -18.586  50.800  28.960  1.00 55.02           C  
ATOM   8356  N   THR D 157     -15.867  48.651  29.113  1.00 52.61           N  
ATOM   8357  CA  THR D 157     -14.553  48.198  29.554  1.00 52.25           C  
ATOM   8358  C   THR D 157     -14.612  46.881  30.320  1.00 50.92           C  
ATOM   8359  O   THR D 157     -13.583  46.244  30.535  1.00 51.09           O  
ATOM   8360  CB  THR D 157     -13.899  49.228  30.491  1.00 53.43           C  
ATOM   8361  OG1 THR D 157     -14.598  49.224  31.749  1.00 52.94           O  
ATOM   8362  CG2 THR D 157     -13.960  50.638  29.884  1.00 53.66           C  
ATOM   8363  N   CYS D 158     -15.805  46.490  30.751  1.00 48.99           N  
ATOM   8364  CA  CYS D 158     -15.967  45.254  31.493  1.00 47.79           C  
ATOM   8365  C   CYS D 158     -15.413  44.080  30.696  1.00 47.17           C  
ATOM   8366  O   CYS D 158     -15.444  44.079  29.474  1.00 46.90           O  
ATOM   8367  CB  CYS D 158     -17.436  45.030  31.817  1.00 47.34           C  
ATOM   8368  SG  CYS D 158     -17.766  43.581  32.808  1.00 47.32           S  
ATOM   8369  N   THR D 159     -14.911  43.076  31.398  1.00 47.15           N  
ATOM   8370  CA  THR D 159     -14.315  41.926  30.748  1.00 47.89           C  
ATOM   8371  C   THR D 159     -14.799  40.627  31.314  1.00 48.34           C  
ATOM   8372  O   THR D 159     -15.280  40.575  32.439  1.00 48.64           O  
ATOM   8373  CB  THR D 159     -12.817  41.941  30.932  1.00 48.37           C  
ATOM   8374  OG1 THR D 159     -12.274  43.025  30.184  1.00 48.57           O  
ATOM   8375  CG2 THR D 159     -12.194  40.619  30.494  1.00 48.97           C  
ATOM   8376  N   ASP D 160     -14.629  39.569  30.532  1.00 48.92           N  
ATOM   8377  CA  ASP D 160     -15.031  38.233  30.939  1.00 50.21           C  
ATOM   8378  C   ASP D 160     -14.349  37.867  32.249  1.00 48.86           C  
ATOM   8379  O   ASP D 160     -14.883  37.098  33.045  1.00 48.01           O  
ATOM   8380  CB  ASP D 160     -14.664  37.235  29.844  1.00 53.79           C  
ATOM   8381  CG  ASP D 160     -15.214  37.645  28.491  1.00 58.03           C  
ATOM   8382  OD1 ASP D 160     -16.441  37.485  28.283  1.00 59.84           O  
ATOM   8383  OD2 ASP D 160     -14.428  38.147  27.649  1.00 59.79           O  
ATOM   8384  N   GLN D 161     -13.173  38.441  32.475  1.00 48.50           N  
ATOM   8385  CA  GLN D 161     -12.411  38.178  33.692  1.00 48.05           C  
ATOM   8386  C   GLN D 161     -13.033  38.886  34.864  1.00 46.98           C  
ATOM   8387  O   GLN D 161     -13.058  38.365  35.976  1.00 47.75           O  
ATOM   8388  CB  GLN D 161     -10.979  38.674  33.571  1.00 48.39           C  
ATOM   8389  CG  GLN D 161     -10.135  38.022  32.511  1.00 48.63           C  
ATOM   8390  CD  GLN D 161      -8.664  38.267  32.770  1.00 48.57           C  
ATOM   8391  OE1 GLN D 161      -8.084  37.677  33.680  1.00 48.00           O  
ATOM   8392  NE2 GLN D 161      -8.060  39.157  31.989  1.00 49.35           N  
ATOM   8393  N   ASP D 162     -13.491  40.100  34.615  1.00 45.99           N  
ATOM   8394  CA  ASP D 162     -14.126  40.898  35.642  1.00 45.48           C  
ATOM   8395  C   ASP D 162     -15.390  40.177  36.098  1.00 45.74           C  
ATOM   8396  O   ASP D 162     -15.650  40.044  37.298  1.00 46.16           O  
ATOM   8397  CB  ASP D 162     -14.485  42.266  35.073  1.00 45.22           C  
ATOM   8398  CG  ASP D 162     -13.265  43.084  34.708  1.00 45.04           C  
ATOM   8399  OD1 ASP D 162     -12.682  43.728  35.609  1.00 44.87           O  
ATOM   8400  OD2 ASP D 162     -12.889  43.076  33.520  1.00 42.77           O  
ATOM   8401  N   VAL D 163     -16.165  39.697  35.128  1.00 45.27           N  
ATOM   8402  CA  VAL D 163     -17.411  38.988  35.401  1.00 44.71           C  
ATOM   8403  C   VAL D 163     -17.206  37.678  36.132  1.00 44.34           C  
ATOM   8404  O   VAL D 163     -17.938  37.374  37.071  1.00 45.04           O  
ATOM   8405  CB  VAL D 163     -18.167  38.705  34.108  1.00 44.05           C  
ATOM   8406  CG1 VAL D 163     -19.399  37.879  34.404  1.00 44.75           C  
ATOM   8407  CG2 VAL D 163     -18.544  40.021  33.445  1.00 43.48           C  
ATOM   8408  N   ALA D 164     -16.219  36.902  35.707  1.00 43.61           N  
ATOM   8409  CA  ALA D 164     -15.957  35.637  36.367  1.00 45.11           C  
ATOM   8410  C   ALA D 164     -15.444  35.877  37.780  1.00 45.78           C  
ATOM   8411  O   ALA D 164     -15.722  35.097  38.693  1.00 46.39           O  
ATOM   8412  CB  ALA D 164     -14.960  34.837  35.578  1.00 44.39           C  
ATOM   8413  N   ALA D 165     -14.700  36.966  37.951  1.00 46.69           N  
ATOM   8414  CA  ALA D 165     -14.147  37.344  39.247  1.00 47.31           C  
ATOM   8415  C   ALA D 165     -15.248  37.802  40.180  1.00 48.48           C  
ATOM   8416  O   ALA D 165     -15.254  37.465  41.360  1.00 48.27           O  
ATOM   8417  CB  ALA D 165     -13.157  38.443  39.074  1.00 46.93           C  
ATOM   8418  N   ALA D 166     -16.176  38.588  39.648  1.00 50.10           N  
ATOM   8419  CA  ALA D 166     -17.280  39.083  40.450  1.00 52.22           C  
ATOM   8420  C   ALA D 166     -18.096  37.899  40.935  1.00 53.40           C  
ATOM   8421  O   ALA D 166     -18.434  37.831  42.109  1.00 53.92           O  
ATOM   8422  CB  ALA D 166     -18.154  40.053  39.642  1.00 51.69           C  
ATOM   8423  N   LYS D 167     -18.392  36.961  40.041  1.00 55.25           N  
ATOM   8424  CA  LYS D 167     -19.177  35.777  40.394  1.00 58.39           C  
ATOM   8425  C   LYS D 167     -18.554  35.026  41.556  1.00 58.30           C  
ATOM   8426  O   LYS D 167     -19.212  34.659  42.521  1.00 57.32           O  
ATOM   8427  CB  LYS D 167     -19.280  34.824  39.198  1.00 60.43           C  
ATOM   8428  CG  LYS D 167     -20.696  34.643  38.649  1.00 65.29           C  
ATOM   8429  CD  LYS D 167     -21.334  35.991  38.202  1.00 69.41           C  
ATOM   8430  CE  LYS D 167     -22.805  35.843  37.727  1.00 71.65           C  
ATOM   8431  NZ  LYS D 167     -23.418  37.155  37.271  1.00 72.50           N  
ATOM   8432  N   GLU D 168     -17.261  34.800  41.427  1.00 59.76           N  
ATOM   8433  CA  GLU D 168     -16.482  34.087  42.410  1.00 61.23           C  
ATOM   8434  C   GLU D 168     -16.469  34.801  43.766  1.00 61.52           C  
ATOM   8435  O   GLU D 168     -16.650  34.166  44.816  1.00 61.56           O  
ATOM   8436  CB  GLU D 168     -15.077  33.945  41.847  1.00 62.78           C  
ATOM   8437  CG  GLU D 168     -14.167  33.047  42.616  1.00 66.01           C  
ATOM   8438  CD  GLU D 168     -12.853  32.827  41.894  1.00 67.27           C  
ATOM   8439  OE1 GLU D 168     -11.930  32.276  42.523  1.00 68.63           O  
ATOM   8440  OE2 GLU D 168     -12.748  33.196  40.701  1.00 67.52           O  
ATOM   8441  N   LEU D 169     -16.254  36.116  43.742  1.00 61.70           N  
ATOM   8442  CA  LEU D 169     -16.226  36.931  44.962  1.00 61.83           C  
ATOM   8443  C   LEU D 169     -17.607  37.021  45.631  1.00 62.48           C  
ATOM   8444  O   LEU D 169     -17.733  36.873  46.845  1.00 62.47           O  
ATOM   8445  CB  LEU D 169     -15.709  38.342  44.644  1.00 60.01           C  
ATOM   8446  CG  LEU D 169     -14.252  38.496  44.201  1.00 58.70           C  
ATOM   8447  CD1 LEU D 169     -14.025  39.907  43.726  1.00 57.65           C  
ATOM   8448  CD2 LEU D 169     -13.315  38.166  45.349  1.00 57.78           C  
ATOM   8449  N   ALA D 170     -18.639  37.264  44.828  1.00 63.50           N  
ATOM   8450  CA  ALA D 170     -20.006  37.366  45.331  1.00 64.29           C  
ATOM   8451  C   ALA D 170     -20.410  36.121  46.120  1.00 64.89           C  
ATOM   8452  O   ALA D 170     -21.167  36.216  47.082  1.00 65.39           O  
ATOM   8453  CB  ALA D 170     -20.983  37.596  44.173  1.00 63.12           C  
ATOM   8454  N   GLU D 171     -19.917  34.953  45.721  1.00 65.63           N  
ATOM   8455  CA  GLU D 171     -20.255  33.739  46.450  1.00 67.09           C  
ATOM   8456  C   GLU D 171     -19.595  33.755  47.817  1.00 66.90           C  
ATOM   8457  O   GLU D 171     -20.238  33.531  48.847  1.00 66.91           O  
ATOM   8458  CB  GLU D 171     -19.800  32.487  45.705  1.00 68.73           C  
ATOM   8459  CG  GLU D 171     -19.754  31.266  46.615  1.00 72.32           C  
ATOM   8460  CD  GLU D 171     -20.091  29.981  45.897  1.00 74.88           C  
ATOM   8461  OE1 GLU D 171     -20.145  28.928  46.575  1.00 75.41           O  
ATOM   8462  OE2 GLU D 171     -20.303  30.026  44.659  1.00 76.56           O  
ATOM   8463  N   ILE D 172     -18.298  34.012  47.816  1.00 66.49           N  
ATOM   8464  CA  ILE D 172     -17.548  34.062  49.051  1.00 66.43           C  
ATOM   8465  C   ILE D 172     -18.151  35.071  50.030  1.00 66.67           C  
ATOM   8466  O   ILE D 172     -18.308  34.781  51.215  1.00 66.27           O  
ATOM   8467  CB  ILE D 172     -16.089  34.419  48.759  1.00 65.73           C  
ATOM   8468  CG1 ILE D 172     -15.467  33.320  47.893  1.00 64.87           C  
ATOM   8469  CG2 ILE D 172     -15.322  34.605  50.058  1.00 66.20           C  
ATOM   8470  CD1 ILE D 172     -14.010  33.518  47.625  1.00 64.61           C  
ATOM   8471  N   ALA D 173     -18.501  36.250  49.522  1.00 67.46           N  
ATOM   8472  CA  ALA D 173     -19.085  37.312  50.343  1.00 67.61           C  
ATOM   8473  C   ALA D 173     -20.524  36.991  50.700  1.00 67.88           C  
ATOM   8474  O   ALA D 173     -21.163  37.740  51.438  1.00 67.80           O  
ATOM   8475  CB  ALA D 173     -19.028  38.647  49.605  1.00 66.97           C  
ATOM   8476  N   GLY D 174     -21.025  35.880  50.166  1.00 68.17           N  
ATOM   8477  CA  GLY D 174     -22.389  35.464  50.432  1.00 69.05           C  
ATOM   8478  C   GLY D 174     -23.434  36.489  50.029  1.00 69.68           C  
ATOM   8479  O   GLY D 174     -24.233  36.930  50.858  1.00 69.84           O  
ATOM   8480  N   VAL D 175     -23.436  36.870  48.756  1.00 70.24           N  
ATOM   8481  CA  VAL D 175     -24.391  37.854  48.255  1.00 70.27           C  
ATOM   8482  C   VAL D 175     -24.760  37.529  46.810  1.00 71.03           C  
ATOM   8483  O   VAL D 175     -24.217  36.592  46.218  1.00 70.92           O  
ATOM   8484  CB  VAL D 175     -23.798  39.290  48.322  1.00 69.14           C  
ATOM   8485  CG1 VAL D 175     -24.830  40.299  47.893  1.00 69.46           C  
ATOM   8486  CG2 VAL D 175     -23.343  39.605  49.732  1.00 68.73           C  
ATOM   8487  N   ASP D 176     -25.705  38.280  46.257  1.00 72.49           N  
ATOM   8488  CA  ASP D 176     -26.120  38.087  44.875  1.00 74.23           C  
ATOM   8489  C   ASP D 176     -25.560  39.255  44.080  1.00 74.44           C  
ATOM   8490  O   ASP D 176     -26.002  40.394  44.236  1.00 73.78           O  
ATOM   8491  CB  ASP D 176     -27.642  38.072  44.736  1.00 75.36           C  
ATOM   8492  CG  ASP D 176     -28.089  37.719  43.322  1.00 76.94           C  
ATOM   8493  OD1 ASP D 176     -29.277  37.926  43.002  1.00 77.86           O  
ATOM   8494  OD2 ASP D 176     -27.254  37.228  42.528  1.00 78.18           O  
ATOM   8495  N   ALA D 177     -24.580  38.951  43.234  1.00 75.35           N  
ATOM   8496  CA  ALA D 177     -23.913  39.939  42.408  1.00 75.89           C  
ATOM   8497  C   ALA D 177     -24.842  41.066  41.976  1.00 76.55           C  
ATOM   8498  O   ALA D 177     -24.762  42.175  42.502  1.00 76.28           O  
ATOM   8499  CB  ALA D 177     -23.299  39.254  41.184  1.00 76.14           C  
ATOM   8500  N   GLU D 178     -25.733  40.777  41.031  1.00 77.38           N  
ATOM   8501  CA  GLU D 178     -26.653  41.783  40.507  1.00 78.44           C  
ATOM   8502  C   GLU D 178     -27.602  42.394  41.521  1.00 77.84           C  
ATOM   8503  O   GLU D 178     -27.915  43.577  41.438  1.00 77.20           O  
ATOM   8504  CB  GLU D 178     -27.462  41.218  39.331  1.00 80.45           C  
ATOM   8505  CG  GLU D 178     -27.639  39.701  39.339  1.00 84.42           C  
ATOM   8506  CD  GLU D 178     -26.410  38.948  38.804  1.00 87.01           C  
ATOM   8507  OE1 GLU D 178     -25.979  39.248  37.664  1.00 88.72           O  
ATOM   8508  OE2 GLU D 178     -25.883  38.057  39.517  1.00 87.37           O  
ATOM   8509  N   GLU D 179     -28.058  41.601  42.481  1.00 78.15           N  
ATOM   8510  CA  GLU D 179     -28.979  42.121  43.482  1.00 78.34           C  
ATOM   8511  C   GLU D 179     -28.300  43.203  44.323  1.00 77.52           C  
ATOM   8512  O   GLU D 179     -28.749  44.352  44.345  1.00 77.90           O  
ATOM   8513  CB  GLU D 179     -29.482  40.991  44.377  1.00 80.61           C  
ATOM   8514  CG  GLU D 179     -30.796  41.312  45.072  1.00 83.35           C  
ATOM   8515  CD  GLU D 179     -31.315  40.160  45.916  1.00 85.27           C  
ATOM   8516  OE1 GLU D 179     -31.564  39.066  45.360  1.00 86.63           O  
ATOM   8517  OE2 GLU D 179     -31.477  40.351  47.141  1.00 86.17           O  
ATOM   8518  N   TYR D 180     -27.220  42.831  45.010  1.00 75.80           N  
ATOM   8519  CA  TYR D 180     -26.450  43.758  45.846  1.00 73.47           C  
ATOM   8520  C   TYR D 180     -25.944  44.931  45.012  1.00 72.10           C  
ATOM   8521  O   TYR D 180     -25.995  46.087  45.430  1.00 70.50           O  
ATOM   8522  CB  TYR D 180     -25.250  43.028  46.452  1.00 73.06           C  
ATOM   8523  CG  TYR D 180     -24.208  43.949  47.032  1.00 72.52           C  
ATOM   8524  CD1 TYR D 180     -24.368  44.509  48.291  1.00 72.84           C  
ATOM   8525  CD2 TYR D 180     -23.086  44.303  46.296  1.00 72.26           C  
ATOM   8526  CE1 TYR D 180     -23.429  45.409  48.808  1.00 72.89           C  
ATOM   8527  CE2 TYR D 180     -22.144  45.202  46.798  1.00 72.53           C  
ATOM   8528  CZ  TYR D 180     -22.321  45.752  48.055  1.00 72.34           C  
ATOM   8529  OH  TYR D 180     -21.399  46.646  48.554  1.00 71.05           O  
ATOM   8530  N   GLY D 181     -25.440  44.600  43.828  1.00 71.69           N  
ATOM   8531  CA  GLY D 181     -24.910  45.595  42.916  1.00 71.51           C  
ATOM   8532  C   GLY D 181     -25.863  46.739  42.656  1.00 70.96           C  
ATOM   8533  O   GLY D 181     -25.492  47.906  42.814  1.00 70.91           O  
ATOM   8534  N   LEU D 182     -27.089  46.411  42.256  1.00 70.67           N  
ATOM   8535  CA  LEU D 182     -28.089  47.435  41.985  1.00 70.12           C  
ATOM   8536  C   LEU D 182     -28.276  48.360  43.174  1.00 69.88           C  
ATOM   8537  O   LEU D 182     -28.264  49.579  43.025  1.00 68.85           O  
ATOM   8538  CB  LEU D 182     -29.420  46.793  41.614  1.00 70.12           C  
ATOM   8539  CG  LEU D 182     -29.632  46.753  40.101  1.00 71.60           C  
ATOM   8540  CD1 LEU D 182     -30.824  45.876  39.754  1.00 72.06           C  
ATOM   8541  CD2 LEU D 182     -29.820  48.177  39.583  1.00 71.14           C  
ATOM   8542  N   ASN D 183     -28.439  47.781  44.359  1.00 69.93           N  
ATOM   8543  CA  ASN D 183     -28.617  48.588  45.564  1.00 69.60           C  
ATOM   8544  C   ASN D 183     -27.460  49.566  45.728  1.00 68.69           C  
ATOM   8545  O   ASN D 183     -27.666  50.774  45.882  1.00 68.37           O  
ATOM   8546  CB  ASN D 183     -28.711  47.691  46.804  1.00 71.58           C  
ATOM   8547  CG  ASN D 183     -29.930  46.790  46.776  1.00 73.15           C  
ATOM   8548  OD1 ASN D 183     -31.038  47.234  46.445  1.00 73.29           O  
ATOM   8549  ND2 ASN D 183     -29.738  45.515  47.131  1.00 73.86           N  
HETATM 8550  N   MSE D 184     -26.244  49.030  45.697  1.00 67.20           N  
HETATM 8551  CA  MSE D 184     -25.056  49.845  45.837  1.00 65.73           C  
HETATM 8552  C   MSE D 184     -25.057  50.952  44.791  1.00 66.36           C  
HETATM 8553  O   MSE D 184     -24.961  52.134  45.128  1.00 65.28           O  
HETATM 8554  CB  MSE D 184     -23.810  48.983  45.666  1.00 64.45           C  
HETATM 8555  CG  MSE D 184     -22.521  49.769  45.836  1.00 62.50           C  
HETATM 8556 SE   MSE D 184     -20.950  48.821  45.340  1.00 59.62          SE  
HETATM 8557  CE  MSE D 184     -21.050  49.131  43.434  1.00 58.83           C  
ATOM   8558  N   LEU D 185     -25.158  50.557  43.522  1.00 67.24           N  
ATOM   8559  CA  LEU D 185     -25.171  51.512  42.425  1.00 68.56           C  
ATOM   8560  C   LEU D 185     -26.183  52.613  42.697  1.00 70.38           C  
ATOM   8561  O   LEU D 185     -25.889  53.795  42.503  1.00 70.49           O  
ATOM   8562  CB  LEU D 185     -25.509  50.805  41.112  1.00 67.75           C  
ATOM   8563  CG  LEU D 185     -24.406  49.939  40.504  1.00 67.96           C  
ATOM   8564  CD1 LEU D 185     -24.942  49.140  39.327  1.00 68.05           C  
ATOM   8565  CD2 LEU D 185     -23.271  50.839  40.061  1.00 68.26           C  
ATOM   8566  N   LYS D 186     -27.368  52.216  43.162  1.00 72.93           N  
ATOM   8567  CA  LYS D 186     -28.460  53.153  43.460  1.00 74.80           C  
ATOM   8568  C   LYS D 186     -28.058  54.178  44.518  1.00 75.72           C  
ATOM   8569  O   LYS D 186     -28.278  55.388  44.347  1.00 75.18           O  
ATOM   8570  CB  LYS D 186     -29.711  52.384  43.924  1.00 75.21           C  
ATOM   8571  CG  LYS D 186     -30.336  51.506  42.838  1.00 76.49           C  
ATOM   8572  CD  LYS D 186     -31.617  50.806  43.292  1.00 77.43           C  
ATOM   8573  CE  LYS D 186     -32.238  50.017  42.136  1.00 77.79           C  
ATOM   8574  NZ  LYS D 186     -33.509  49.341  42.514  1.00 77.57           N  
ATOM   8575  N   ALA D 187     -27.457  53.689  45.601  1.00 77.05           N  
ATOM   8576  CA  ALA D 187     -27.012  54.550  46.690  1.00 78.98           C  
ATOM   8577  C   ALA D 187     -26.076  55.627  46.151  1.00 80.58           C  
ATOM   8578  O   ALA D 187     -25.672  56.535  46.879  1.00 80.07           O  
ATOM   8579  CB  ALA D 187     -26.303  53.721  47.758  1.00 78.52           C  
ATOM   8580  N   GLY D 188     -25.738  55.509  44.869  1.00 82.99           N  
ATOM   8581  CA  GLY D 188     -24.863  56.470  44.230  1.00 86.34           C  
ATOM   8582  C   GLY D 188     -25.380  57.879  44.420  1.00 89.07           C  
ATOM   8583  O   GLY D 188     -24.821  58.645  45.206  1.00 89.17           O  
ATOM   8584  N   ALA D 189     -26.478  58.212  43.745  1.00 92.54           N  
ATOM   8585  CA  ALA D 189     -27.051  59.559  43.857  1.00 95.86           C  
ATOM   8586  C   ALA D 189     -28.236  59.686  44.837  1.00 97.71           C  
ATOM   8587  O   ALA D 189     -28.755  60.792  45.051  1.00 98.02           O  
ATOM   8588  CB  ALA D 189     -27.464  60.068  42.467  1.00 96.07           C  
ATOM   8589  N   ASP D 190     -28.651  58.560  45.420  1.00 99.46           N  
ATOM   8590  CA  ASP D 190     -29.763  58.517  46.380  1.00100.70           C  
ATOM   8591  C   ASP D 190     -30.954  59.357  45.914  1.00100.67           C  
ATOM   8592  O   ASP D 190     -31.652  59.964  46.731  1.00100.55           O  
ATOM   8593  CB  ASP D 190     -29.291  59.002  47.767  1.00101.81           C  
ATOM   8594  CG  ASP D 190     -29.622  58.008  48.905  1.00102.38           C  
ATOM   8595  OD1 ASP D 190     -30.083  56.854  48.625  1.00100.71           O  
ATOM   8596  OD2 ASP D 190     -29.404  58.392  50.086  1.00101.31           O  
ATOM   8597  N   LEU D 191     -31.177  59.386  44.602  1.00100.71           N  
ATOM   8598  CA  LEU D 191     -32.282  60.146  44.024  1.00100.73           C  
ATOM   8599  C   LEU D 191     -33.593  59.854  44.738  1.00101.59           C  
ATOM   8600  O   LEU D 191     -34.484  60.710  44.776  1.00102.35           O  
ATOM   8601  CB  LEU D 191     -32.438  59.823  42.535  1.00 99.15           C  
ATOM   8602  CG  LEU D 191     -31.464  60.525  41.596  1.00 98.11           C  
ATOM   8603  CD1 LEU D 191     -31.641  60.012  40.176  1.00 97.66           C  
ATOM   8604  CD2 LEU D 191     -31.705  62.017  41.676  1.00 97.20           C  
ATOM   8605  N   SER D 192     -33.707  58.649  45.304  1.00101.88           N  
ATOM   8606  CA  SER D 192     -34.921  58.252  46.022  1.00101.79           C  
ATOM   8607  C   SER D 192     -35.214  59.132  47.247  1.00101.39           C  
ATOM   8608  O   SER D 192     -35.811  58.668  48.224  1.00101.28           O  
ATOM   8609  CB  SER D 192     -34.854  56.758  46.421  1.00101.65           C  
ATOM   8610  OG  SER D 192     -33.547  56.355  46.801  1.00101.28           O  
ATOM   8611  N   LYS D 193     -34.795  60.401  47.171  1.00100.81           N  
ATOM   8612  CA  LYS D 193     -35.003  61.395  48.227  1.00 99.88           C  
ATOM   8613  C   LYS D 193     -34.920  62.835  47.702  1.00 99.21           C  
ATOM   8614  O   LYS D 193     -33.849  63.339  47.364  1.00 98.61           O  
ATOM   8615  CB  LYS D 193     -34.000  61.185  49.371  1.00 99.64           C  
ATOM   8616  CG  LYS D 193     -34.173  59.834  50.051  1.00 99.85           C  
ATOM   8617  CD  LYS D 193     -33.837  59.843  51.526  1.00100.19           C  
ATOM   8618  CE  LYS D 193     -34.355  58.568  52.186  1.00 99.76           C  
ATOM   8619  NZ  LYS D 193     -34.065  58.527  53.642  1.00100.05           N  
ATOM   8620  N   ILE D 216     -32.378  73.385  29.198  1.00 86.15           N  
ATOM   8621  CA  ILE D 216     -32.182  71.934  28.960  1.00 86.72           C  
ATOM   8622  C   ILE D 216     -31.575  71.202  30.191  1.00 87.68           C  
ATOM   8623  O   ILE D 216     -30.340  71.261  30.427  1.00 87.47           O  
ATOM   8624  CB  ILE D 216     -31.227  71.648  27.706  1.00 85.95           C  
ATOM   8625  CG1 ILE D 216     -31.887  72.127  26.391  1.00 85.64           C  
ATOM   8626  CG2 ILE D 216     -30.892  70.123  27.607  1.00 84.48           C  
ATOM   8627  CD1 ILE D 216     -30.967  71.991  25.143  1.00 85.86           C  
ATOM   8628  N   ALA D 217     -32.423  70.493  30.944  1.00 89.17           N  
ATOM   8629  CA  ALA D 217     -31.986  69.771  32.142  1.00 89.42           C  
ATOM   8630  C   ALA D 217     -31.469  68.364  31.852  1.00 89.80           C  
ATOM   8631  O   ALA D 217     -31.509  67.884  30.718  1.00 89.65           O  
ATOM   8632  CB  ALA D 217     -33.131  69.688  33.145  1.00 89.24           C  
ATOM   8633  N   GLN D 218     -30.969  67.720  32.902  1.00 90.63           N  
ATOM   8634  CA  GLN D 218     -30.455  66.358  32.817  1.00 91.17           C  
ATOM   8635  C   GLN D 218     -30.212  65.765  34.202  1.00 91.65           C  
ATOM   8636  O   GLN D 218     -29.475  66.325  35.012  1.00 91.95           O  
ATOM   8637  CB  GLN D 218     -29.143  66.292  32.008  1.00 91.28           C  
ATOM   8638  CG  GLN D 218     -28.763  64.853  31.565  1.00 90.66           C  
ATOM   8639  CD  GLN D 218     -27.348  64.715  30.970  1.00 90.40           C  
ATOM   8640  OE1 GLN D 218     -26.887  65.575  30.207  1.00 89.38           O  
ATOM   8641  NE2 GLN D 218     -26.667  63.611  31.307  1.00 89.43           N  
ATOM   8642  N   VAL D 219     -30.857  64.634  34.461  1.00 91.75           N  
ATOM   8643  CA  VAL D 219     -30.703  63.906  35.713  1.00 91.82           C  
ATOM   8644  C   VAL D 219     -29.877  62.692  35.320  1.00 92.61           C  
ATOM   8645  O   VAL D 219     -29.556  62.520  34.144  1.00 92.70           O  
ATOM   8646  CB  VAL D 219     -32.063  63.441  36.264  1.00 90.84           C  
ATOM   8647  CG1 VAL D 219     -31.870  62.532  37.467  1.00 89.85           C  
ATOM   8648  CG2 VAL D 219     -32.889  64.648  36.652  1.00 90.60           C  
ATOM   8649  N   ASN D 220     -29.532  61.848  36.282  1.00 93.37           N  
ATOM   8650  CA  ASN D 220     -28.745  60.665  35.982  1.00 94.37           C  
ATOM   8651  C   ASN D 220     -29.108  59.526  36.924  1.00 94.45           C  
ATOM   8652  O   ASN D 220     -28.918  59.636  38.135  1.00 94.58           O  
ATOM   8653  CB  ASN D 220     -27.256  61.011  36.097  1.00 95.65           C  
ATOM   8654  CG  ASN D 220     -26.556  61.082  34.737  1.00 97.27           C  
ATOM   8655  OD1 ASN D 220     -26.267  60.056  34.122  1.00 98.49           O  
ATOM   8656  ND2 ASN D 220     -26.290  62.297  34.262  1.00 97.80           N  
ATOM   8657  N   THR D 221     -29.641  58.436  36.382  1.00 94.42           N  
ATOM   8658  CA  THR D 221     -30.006  57.313  37.234  1.00 94.90           C  
ATOM   8659  C   THR D 221     -29.659  55.932  36.728  1.00 94.42           C  
ATOM   8660  O   THR D 221     -29.458  55.706  35.539  1.00 93.61           O  
ATOM   8661  CB  THR D 221     -31.505  57.263  37.534  1.00 96.12           C  
ATOM   8662  OG1 THR D 221     -31.749  56.322  38.600  1.00 96.86           O  
ATOM   8663  CG2 THR D 221     -32.266  56.809  36.284  1.00 96.20           C  
ATOM   8664  N   VAL D 222     -29.634  55.011  37.683  1.00 94.34           N  
ATOM   8665  CA  VAL D 222     -29.350  53.614  37.447  1.00 94.75           C  
ATOM   8666  C   VAL D 222     -30.637  52.958  36.952  1.00 94.94           C  
ATOM   8667  O   VAL D 222     -30.610  52.121  36.049  1.00 95.18           O  
ATOM   8668  CB  VAL D 222     -28.898  52.939  38.749  1.00 95.03           C  
ATOM   8669  CG1 VAL D 222     -29.887  53.267  39.865  1.00 95.40           C  
ATOM   8670  CG2 VAL D 222     -28.786  51.437  38.549  1.00 95.31           C  
ATOM   8671  N   ASP D 223     -31.760  53.335  37.554  1.00 94.77           N  
ATOM   8672  CA  ASP D 223     -33.054  52.793  37.146  1.00 94.34           C  
ATOM   8673  C   ASP D 223     -34.047  53.917  36.862  1.00 93.27           C  
ATOM   8674  O   ASP D 223     -34.380  54.715  37.751  1.00 93.33           O  
ATOM   8675  CB  ASP D 223     -33.615  51.835  38.211  1.00 95.07           C  
ATOM   8676  CG  ASP D 223     -34.992  51.278  37.839  1.00 95.49           C  
ATOM   8677  OD1 ASP D 223     -35.185  50.864  36.674  1.00 95.26           O  
ATOM   8678  OD2 ASP D 223     -35.880  51.244  38.720  1.00 95.81           O  
ATOM   8679  N   ILE D 224     -34.503  53.983  35.613  1.00 91.83           N  
ATOM   8680  CA  ILE D 224     -35.451  55.005  35.215  1.00 89.96           C  
ATOM   8681  C   ILE D 224     -36.773  54.706  35.915  1.00 90.53           C  
ATOM   8682  O   ILE D 224     -37.572  55.610  36.156  1.00 90.95           O  
ATOM   8683  CB  ILE D 224     -35.639  55.038  33.675  1.00 87.71           C  
ATOM   8684  CG1 ILE D 224     -34.287  54.875  32.964  1.00 85.73           C  
ATOM   8685  CG2 ILE D 224     -36.212  56.388  33.258  1.00 87.80           C  
ATOM   8686  CD1 ILE D 224     -34.353  54.998  31.448  1.00 81.86           C  
ATOM   8687  N   GLU D 225     -36.997  53.437  36.255  1.00 90.48           N  
ATOM   8688  CA  GLU D 225     -38.219  53.064  36.967  1.00 90.46           C  
ATOM   8689  C   GLU D 225     -38.283  53.934  38.219  1.00 90.05           C  
ATOM   8690  O   GLU D 225     -39.242  54.700  38.384  1.00 90.18           O  
ATOM   8691  CB  GLU D 225     -38.206  51.584  37.380  1.00 91.09           C  
ATOM   8692  CG  GLU D 225     -39.358  51.187  38.339  1.00 90.58           C  
ATOM   8693  CD  GLU D 225     -40.713  50.891  37.631  1.00 90.76           C  
ATOM   8694  OE1 GLU D 225     -41.028  51.539  36.554  1.00 89.26           O  
ATOM   8695  OE2 GLU D 225     -41.476  50.023  38.146  1.00 91.24           O  
ATOM   8696  N   ASP D 226     -37.257  53.810  39.083  1.00 88.29           N  
ATOM   8697  CA  ASP D 226     -37.142  54.601  40.344  1.00 87.13           C  
ATOM   8698  C   ASP D 226     -37.675  56.048  40.123  1.00 85.71           C  
ATOM   8699  O   ASP D 226     -38.159  56.707  41.084  1.00 85.79           O  
ATOM   8700  CB  ASP D 226     -35.660  54.673  40.848  1.00 87.91           C  
ATOM   8701  CG  ASP D 226     -35.060  53.259  41.270  1.00 87.50           C  
ATOM   8702  OD1 ASP D 226     -35.740  52.528  42.076  1.00 87.71           O  
ATOM   8703  OD2 ASP D 226     -33.906  52.893  40.804  1.00 87.38           O  
ATOM   8704  N   VAL D 227     -37.550  56.526  38.870  1.00 83.35           N  
ATOM   8705  CA  VAL D 227     -38.051  57.846  38.471  1.00 81.45           C  
ATOM   8706  C   VAL D 227     -38.976  57.761  37.246  1.00 81.04           C  
ATOM   8707  O   VAL D 227     -40.086  58.332  37.230  1.00 79.52           O  
ATOM   8708  CB  VAL D 227     -36.887  58.859  38.163  1.00 80.74           C  
ATOM   8709  CG1 VAL D 227     -37.352  59.924  37.103  1.00 79.47           C  
ATOM   8710  CG2 VAL D 227     -36.461  59.566  39.486  1.00 79.77           C  
ATOM   8711  N   LEU D 252     -34.916  68.562  30.470  1.00100.52           N  
ATOM   8712  CA  LEU D 252     -34.783  67.350  31.287  1.00101.01           C  
ATOM   8713  C   LEU D 252     -34.796  66.090  30.424  1.00101.50           C  
ATOM   8714  O   LEU D 252     -35.685  65.919  29.584  1.00102.35           O  
ATOM   8715  CB  LEU D 252     -35.920  67.255  32.313  1.00 99.70           C  
ATOM   8716  CG  LEU D 252     -36.048  65.879  32.978  1.00 98.11           C  
ATOM   8717  CD1 LEU D 252     -34.799  65.611  33.794  1.00 97.02           C  
ATOM   8718  CD2 LEU D 252     -37.300  65.818  33.839  1.00 97.01           C  
ATOM   8719  N   VAL D 253     -33.831  65.200  30.654  1.00101.35           N  
ATOM   8720  CA  VAL D 253     -33.729  63.965  29.876  1.00100.87           C  
ATOM   8721  C   VAL D 253     -33.229  62.785  30.703  1.00100.10           C  
ATOM   8722  O   VAL D 253     -32.098  62.344  30.524  1.00100.52           O  
ATOM   8723  CB  VAL D 253     -32.767  64.152  28.664  1.00101.26           C  
ATOM   8724  CG1 VAL D 253     -33.349  65.162  27.683  1.00101.37           C  
ATOM   8725  CG2 VAL D 253     -31.396  64.634  29.144  1.00100.98           C  
ATOM   8726  N   ILE D 254     -34.064  62.269  31.598  1.00 99.09           N  
ATOM   8727  CA  ILE D 254     -33.668  61.138  32.445  1.00 98.48           C  
ATOM   8728  C   ILE D 254     -32.756  60.134  31.712  1.00 97.98           C  
ATOM   8729  O   ILE D 254     -33.214  59.322  30.891  1.00 98.39           O  
ATOM   8730  CB  ILE D 254     -34.911  60.382  33.015  1.00 98.46           C  
ATOM   8731  CG1 ILE D 254     -35.726  61.301  33.933  1.00 98.49           C  
ATOM   8732  CG2 ILE D 254     -34.465  59.172  33.828  1.00 97.97           C  
ATOM   8733  CD1 ILE D 254     -36.377  62.479  33.234  1.00 98.22           C  
ATOM   8734  N   THR D 255     -31.459  60.212  32.020  1.00 96.58           N  
ATOM   8735  CA  THR D 255     -30.445  59.345  31.422  1.00 94.92           C  
ATOM   8736  C   THR D 255     -30.187  58.109  32.283  1.00 94.12           C  
ATOM   8737  O   THR D 255     -30.015  58.206  33.502  1.00 94.20           O  
ATOM   8738  CB  THR D 255     -29.100  60.100  31.233  1.00 94.71           C  
ATOM   8739  OG1 THR D 255     -29.257  61.137  30.258  1.00 94.33           O  
ATOM   8740  CG2 THR D 255     -28.011  59.150  30.767  1.00 94.68           C  
ATOM   8741  N   ASP D 256     -30.173  56.948  31.639  1.00 92.87           N  
ATOM   8742  CA  ASP D 256     -29.918  55.693  32.326  1.00 91.79           C  
ATOM   8743  C   ASP D 256     -28.449  55.335  32.139  1.00 91.32           C  
ATOM   8744  O   ASP D 256     -28.020  55.021  31.030  1.00 91.69           O  
ATOM   8745  CB  ASP D 256     -30.802  54.587  31.752  1.00 91.35           C  
ATOM   8746  CG  ASP D 256     -30.347  53.205  32.170  1.00 91.40           C  
ATOM   8747  OD1 ASP D 256     -30.153  52.980  33.383  1.00 91.13           O  
ATOM   8748  OD2 ASP D 256     -30.188  52.340  31.283  1.00 91.83           O  
ATOM   8749  N   ILE D 257     -27.684  55.388  33.225  1.00 90.10           N  
ATOM   8750  CA  ILE D 257     -26.257  55.085  33.187  1.00 88.64           C  
ATOM   8751  C   ILE D 257     -25.902  53.665  32.743  1.00 87.69           C  
ATOM   8752  O   ILE D 257     -24.781  53.425  32.297  1.00 87.59           O  
ATOM   8753  CB  ILE D 257     -25.600  55.335  34.568  1.00 88.74           C  
ATOM   8754  CG1 ILE D 257     -26.416  54.660  35.675  1.00 88.81           C  
ATOM   8755  CG2 ILE D 257     -25.482  56.819  34.824  1.00 88.13           C  
ATOM   8756  CD1 ILE D 257     -25.861  54.876  37.071  1.00 87.86           C  
ATOM   8757  N   LEU D 258     -26.847  52.734  32.852  1.00 86.73           N  
ATOM   8758  CA  LEU D 258     -26.599  51.341  32.476  1.00 86.25           C  
ATOM   8759  C   LEU D 258     -26.836  50.997  31.001  1.00 86.87           C  
ATOM   8760  O   LEU D 258     -25.936  50.500  30.311  1.00 86.51           O  
ATOM   8761  CB  LEU D 258     -27.458  50.416  33.329  1.00 84.63           C  
ATOM   8762  CG  LEU D 258     -27.435  50.646  34.832  1.00 83.08           C  
ATOM   8763  CD1 LEU D 258     -28.341  49.620  35.472  1.00 82.52           C  
ATOM   8764  CD2 LEU D 258     -26.022  50.547  35.371  1.00 82.36           C  
ATOM   8765  N   GLU D 259     -28.052  51.251  30.524  1.00 87.65           N  
ATOM   8766  CA  GLU D 259     -28.410  50.941  29.144  1.00 88.45           C  
ATOM   8767  C   GLU D 259     -28.096  52.059  28.152  1.00 88.18           C  
ATOM   8768  O   GLU D 259     -28.403  51.944  26.970  1.00 88.24           O  
ATOM   8769  CB  GLU D 259     -29.897  50.576  29.062  1.00 89.29           C  
ATOM   8770  CG  GLU D 259     -30.343  49.479  30.049  1.00 91.82           C  
ATOM   8771  CD  GLU D 259     -29.505  48.190  29.973  1.00 93.46           C  
ATOM   8772  OE1 GLU D 259     -29.334  47.642  28.860  1.00 93.97           O  
ATOM   8773  OE2 GLU D 259     -29.025  47.721  31.035  1.00 93.80           O  
ATOM   8774  N   ASN D 260     -27.478  53.131  28.641  1.00 88.31           N  
ATOM   8775  CA  ASN D 260     -27.106  54.286  27.818  1.00 88.25           C  
ATOM   8776  C   ASN D 260     -28.216  54.859  26.945  1.00 87.95           C  
ATOM   8777  O   ASN D 260     -28.016  55.129  25.758  1.00 87.83           O  
ATOM   8778  CB  ASN D 260     -25.894  53.940  26.952  1.00 88.51           C  
ATOM   8779  CG  ASN D 260     -24.591  54.065  27.712  1.00 89.33           C  
ATOM   8780  OD1 ASN D 260     -24.115  55.175  27.974  1.00 89.37           O  
ATOM   8781  ND2 ASN D 260     -24.014  52.926  28.091  1.00 89.88           N  
ATOM   8782  N   ASP D 261     -29.384  55.057  27.552  1.00 87.57           N  
ATOM   8783  CA  ASP D 261     -30.544  55.607  26.861  1.00 86.74           C  
ATOM   8784  C   ASP D 261     -31.192  56.646  27.762  1.00 86.23           C  
ATOM   8785  O   ASP D 261     -31.647  56.336  28.863  1.00 86.23           O  
ATOM   8786  CB  ASP D 261     -31.558  54.499  26.540  1.00 86.76           C  
ATOM   8787  CG  ASP D 261     -30.960  53.378  25.706  1.00 86.55           C  
ATOM   8788  OD1 ASP D 261     -30.377  53.668  24.630  1.00 86.07           O  
ATOM   8789  OD2 ASP D 261     -31.080  52.206  26.130  1.00 85.82           O  
ATOM   8790  N   SER D 262     -31.235  57.882  27.289  1.00 85.84           N  
ATOM   8791  CA  SER D 262     -31.816  58.964  28.064  1.00 85.37           C  
ATOM   8792  C   SER D 262     -33.337  58.980  27.972  1.00 85.32           C  
ATOM   8793  O   SER D 262     -33.915  58.440  27.030  1.00 85.26           O  
ATOM   8794  CB  SER D 262     -31.241  60.289  27.578  1.00 84.99           C  
ATOM   8795  OG  SER D 262     -29.824  60.235  27.566  1.00 84.47           O  
ATOM   8796  N   VAL D 293     -26.925  60.154  25.462  1.00 94.43           N  
ATOM   8797  CA  VAL D 293     -26.376  60.070  26.818  1.00 95.37           C  
ATOM   8798  C   VAL D 293     -25.641  61.338  27.277  1.00 95.49           C  
ATOM   8799  O   VAL D 293     -25.453  61.556  28.479  1.00 95.76           O  
ATOM   8800  CB  VAL D 293     -25.419  58.846  26.954  1.00 95.62           C  
ATOM   8801  CG1 VAL D 293     -24.659  58.895  28.284  1.00 95.42           C  
ATOM   8802  CG2 VAL D 293     -26.226  57.557  26.876  1.00 95.82           C  
ATOM   8803  N   SER D 294     -25.237  62.178  26.329  1.00 95.68           N  
ATOM   8804  CA  SER D 294     -24.531  63.415  26.657  1.00 95.81           C  
ATOM   8805  C   SER D 294     -24.979  64.580  25.781  1.00 96.16           C  
ATOM   8806  O   SER D 294     -24.493  64.734  24.661  1.00 96.00           O  
ATOM   8807  CB  SER D 294     -23.018  63.224  26.496  1.00 95.39           C  
ATOM   8808  OG  SER D 294     -22.326  64.452  26.658  1.00 94.35           O  
ATOM   8809  N   ARG D 295     -25.893  65.404  26.284  1.00 96.68           N  
ATOM   8810  CA  ARG D 295     -26.366  66.549  25.516  1.00 97.66           C  
ATOM   8811  C   ARG D 295     -25.209  67.397  25.007  1.00 98.51           C  
ATOM   8812  O   ARG D 295     -25.345  68.119  24.022  1.00 98.48           O  
ATOM   8813  CB  ARG D 295     -27.329  67.406  26.357  1.00 97.64           C  
ATOM   8814  CG  ARG D 295     -26.839  67.770  27.755  1.00 97.75           C  
ATOM   8815  CD  ARG D 295     -26.175  69.146  27.825  1.00 97.57           C  
ATOM   8816  NE  ARG D 295     -25.702  69.431  29.182  1.00 97.85           N  
ATOM   8817  CZ  ARG D 295     -26.493  69.541  30.251  1.00 98.17           C  
ATOM   8818  NH1 ARG D 295     -27.808  69.399  30.132  1.00 98.47           N  
ATOM   8819  NH2 ARG D 295     -25.972  69.771  31.451  1.00 97.73           N  
ATOM   8820  N   LYS D 296     -24.064  67.286  25.675  1.00 99.68           N  
ATOM   8821  CA  LYS D 296     -22.861  68.038  25.315  1.00100.23           C  
ATOM   8822  C   LYS D 296     -22.440  67.781  23.861  1.00100.92           C  
ATOM   8823  O   LYS D 296     -22.534  68.671  23.006  1.00101.09           O  
ATOM   8824  CB  LYS D 296     -21.701  67.655  26.252  1.00 99.55           C  
ATOM   8825  CG  LYS D 296     -22.099  67.390  27.706  1.00 98.24           C  
ATOM   8826  CD  LYS D 296     -22.683  68.619  28.393  1.00 96.70           C  
ATOM   8827  CE  LYS D 296     -23.108  68.291  29.818  1.00 95.55           C  
ATOM   8828  NZ  LYS D 296     -21.979  67.786  30.649  1.00 94.75           N  
ATOM   8829  N   LYS D 297     -21.985  66.556  23.595  1.00101.45           N  
ATOM   8830  CA  LYS D 297     -21.522  66.144  22.270  1.00101.69           C  
ATOM   8831  C   LYS D 297     -22.640  65.633  21.366  1.00101.80           C  
ATOM   8832  O   LYS D 297     -22.513  65.676  20.141  1.00102.11           O  
ATOM   8833  CB  LYS D 297     -20.466  65.037  22.403  1.00101.76           C  
ATOM   8834  CG  LYS D 297     -19.327  65.367  23.352  1.00101.92           C  
ATOM   8835  CD  LYS D 297     -18.602  64.111  23.821  1.00101.25           C  
ATOM   8836  CE  LYS D 297     -17.656  64.429  24.981  1.00100.89           C  
ATOM   8837  NZ  LYS D 297     -18.357  65.066  26.144  1.00100.06           N  
ATOM   8838  N   GLN D 298     -23.729  65.152  21.962  1.00101.63           N  
ATOM   8839  CA  GLN D 298     -24.831  64.597  21.182  1.00101.64           C  
ATOM   8840  C   GLN D 298     -26.112  65.420  21.135  1.00101.64           C  
ATOM   8841  O   GLN D 298     -26.428  66.028  20.115  1.00101.61           O  
ATOM   8842  CB  GLN D 298     -25.177  63.186  21.689  1.00101.58           C  
ATOM   8843  CG  GLN D 298     -23.970  62.278  21.929  1.00101.72           C  
ATOM   8844  CD  GLN D 298     -24.354  60.859  22.338  1.00101.64           C  
ATOM   8845  OE1 GLN D 298     -25.233  60.657  23.183  1.00101.62           O  
ATOM   8846  NE2 GLN D 298     -23.682  59.869  21.750  1.00101.24           N  
ATOM   8847  N   VAL D 299     -26.846  65.427  22.244  1.00101.87           N  
ATOM   8848  CA  VAL D 299     -28.129  66.119  22.345  1.00102.02           C  
ATOM   8849  C   VAL D 299     -28.191  67.605  21.978  1.00102.58           C  
ATOM   8850  O   VAL D 299     -29.157  68.037  21.348  1.00102.72           O  
ATOM   8851  CB  VAL D 299     -28.729  65.954  23.757  1.00101.48           C  
ATOM   8852  CG1 VAL D 299     -30.205  66.301  23.738  1.00100.97           C  
ATOM   8853  CG2 VAL D 299     -28.501  64.535  24.255  1.00101.31           C  
ATOM   8854  N   VAL D 300     -27.188  68.392  22.362  1.00103.01           N  
ATOM   8855  CA  VAL D 300     -27.212  69.825  22.052  1.00103.54           C  
ATOM   8856  C   VAL D 300     -26.824  70.204  20.616  1.00103.66           C  
ATOM   8857  O   VAL D 300     -27.553  70.946  19.952  1.00103.01           O  
ATOM   8858  CB  VAL D 300     -26.333  70.640  23.041  1.00103.73           C  
ATOM   8859  CG1 VAL D 300     -26.310  72.112  22.632  1.00103.25           C  
ATOM   8860  CG2 VAL D 300     -26.884  70.501  24.461  1.00103.78           C  
ATOM   8861  N   PRO D 301     -25.672  69.713  20.116  1.00104.23           N  
ATOM   8862  CA  PRO D 301     -25.275  70.057  18.742  1.00104.45           C  
ATOM   8863  C   PRO D 301     -26.244  69.546  17.663  1.00104.28           C  
ATOM   8864  O   PRO D 301     -26.475  70.214  16.652  1.00104.15           O  
ATOM   8865  CB  PRO D 301     -23.874  69.439  18.617  1.00104.52           C  
ATOM   8866  CG  PRO D 301     -23.928  68.272  19.559  1.00104.58           C  
ATOM   8867  CD  PRO D 301     -24.652  68.859  20.757  1.00104.53           C  
ATOM   8868  N   VAL D 302     -26.811  68.364  17.886  1.00103.96           N  
ATOM   8869  CA  VAL D 302     -27.748  67.774  16.936  1.00103.34           C  
ATOM   8870  C   VAL D 302     -29.088  68.528  16.990  1.00102.34           C  
ATOM   8871  O   VAL D 302     -29.791  68.633  15.980  1.00102.01           O  
ATOM   8872  CB  VAL D 302     -27.948  66.250  17.241  1.00103.86           C  
ATOM   8873  CG1 VAL D 302     -29.016  66.054  18.308  1.00103.92           C  
ATOM   8874  CG2 VAL D 302     -28.286  65.492  15.964  1.00103.91           C  
ATOM   8875  N   LEU D 303     -29.414  69.064  18.170  1.00101.17           N  
ATOM   8876  CA  LEU D 303     -30.653  69.817  18.390  1.00 99.70           C  
ATOM   8877  C   LEU D 303     -30.488  71.249  17.889  1.00 99.26           C  
ATOM   8878  O   LEU D 303     -31.476  71.974  17.757  1.00 99.18           O  
ATOM   8879  CB  LEU D 303     -31.013  69.853  19.889  1.00 98.76           C  
ATOM   8880  CG  LEU D 303     -32.484  69.726  20.329  1.00 98.31           C  
ATOM   8881  CD1 LEU D 303     -32.654  70.260  21.747  1.00 97.50           C  
ATOM   8882  CD2 LEU D 303     -33.385  70.480  19.377  1.00 98.02           C  
ATOM   8883  N   THR D 304     -29.240  71.647  17.626  1.00 98.79           N  
ATOM   8884  CA  THR D 304     -28.916  73.001  17.142  1.00 98.59           C  
ATOM   8885  C   THR D 304     -29.278  73.192  15.661  1.00 99.24           C  
ATOM   8886  O   THR D 304     -30.146  74.002  15.325  1.00 99.36           O  
ATOM   8887  CB  THR D 304     -27.399  73.343  17.349  1.00 97.81           C  
ATOM   8888  OG1 THR D 304     -27.093  73.370  18.752  1.00 97.09           O  
ATOM   8889  CG2 THR D 304     -27.058  74.710  16.741  1.00 96.31           C  
ATOM   8890  N   ASP D 305     -28.607  72.477  14.766  1.00100.22           N  
ATOM   8891  CA  ASP D 305     -28.959  72.610  13.361  1.00101.34           C  
ATOM   8892  C   ASP D 305     -30.078  71.611  13.032  1.00103.07           C  
ATOM   8893  O   ASP D 305     -30.088  70.961  11.982  1.00103.88           O  
ATOM   8894  CB  ASP D 305     -27.719  72.457  12.441  1.00 99.74           C  
ATOM   8895  CG  ASP D 305     -26.725  71.393  12.918  1.00 99.00           C  
ATOM   8896  OD1 ASP D 305     -27.094  70.195  12.940  1.00 98.28           O  
ATOM   8897  OD2 ASP D 305     -25.567  71.761  13.255  1.00 96.92           O  
ATOM   8898  N   ALA D 306     -31.009  71.501  13.979  1.00103.87           N  
ATOM   8899  CA  ALA D 306     -32.202  70.652  13.888  1.00104.22           C  
ATOM   8900  C   ALA D 306     -33.296  71.707  14.054  1.00104.32           C  
ATOM   8901  O   ALA D 306     -33.912  72.142  13.068  1.00104.49           O  
ATOM   8902  CB  ALA D 306     -32.238  69.658  15.045  1.00103.93           C  
HETATM 8903  N   MSE D 307     -33.535  72.096  15.314  1.00103.04           N  
HETATM 8904  CA  MSE D 307     -34.472  73.209  15.649  1.00103.07           C  
HETATM 8905  C   MSE D 307     -33.557  74.489  15.409  1.00100.74           C  
HETATM 8906  O   MSE D 307     -33.950  75.433  14.632  1.00 99.39           O  
HETATM 8907  CB  MSE D 307     -35.008  73.140  17.142  1.00105.58           C  
HETATM 8908  CG  MSE D 307     -33.976  73.185  18.280  1.00108.85           C  
HETATM 8909 SE   MSE D 307     -34.721  73.693  20.339  1.00115.71          SE  
HETATM 8910  CE  MSE D 307     -32.976  75.022  20.718  1.00112.45           C  
TER    8911      MSE D 307                                                      
END
MOLECULE T0501_2_214.pdb
ATOM      1  CB  LEU     2      -9.118  30.738  34.125  1.00 51.67          
ATOM      2  CG  LEU     2     -10.314  30.118  34.866  1.00 53.86          
ATOM      3  CD1 LEU     2     -11.388  29.708  33.864  1.00 54.66          
ATOM      4  CD2 LEU     2      -9.859  28.897  35.667  1.00 54.00          
ATOM      5  C   LEU     2      -6.735  31.546  34.073  1.00 48.54          
ATOM      6  O   LEU     2      -5.767  30.796  34.138  1.00 49.26          
ATOM      7  N   LEU     2      -8.396  32.565  35.655  1.00 50.89          
ATOM      8  CA  LEU     2      -7.962  31.312  34.963  1.00 49.96          
ATOM      9  N   THR     3      -6.780  32.590  33.254  1.00 46.10          
ATOM     10  CA  THR     3      -5.683  32.929  32.353  1.00 45.01          
ATOM     11  CB  THR     3      -6.219  33.711  31.127  1.00 45.64          
ATOM     12  OG1 THR     3      -7.112  32.873  30.384  1.00 47.96          
ATOM     13  CG2 THR     3      -5.093  34.165  30.226  1.00 42.04          
ATOM     14  C   THR     3      -4.635  33.777  33.073  1.00 45.61          
ATOM     15  O   THR     3      -4.978  34.589  33.928  1.00 45.72          
ATOM     16  N   LYS     4      -3.361  33.589  32.727  1.00 45.17          
ATOM     17  CA  LYS     4      -2.269  34.343  33.350  1.00 44.57          
ATOM     18  CB  LYS     4      -0.961  33.536  33.320  1.00 45.36          
ATOM     19  CG  LYS     4      -0.965  32.307  34.221  1.00 48.99          
ATOM     20  CD  LYS     4       0.398  31.634  34.276  1.00 49.41          
ATOM     21  CE  LYS     4       0.359  30.402  35.179  1.00 52.94          
ATOM     22  NZ  LYS     4       1.684  29.705  35.252  1.00 53.72          
ATOM     23  C   LYS     4      -2.044  35.683  32.660  1.00 41.65          
ATOM     24  O   LYS     4      -1.392  35.751  31.622  1.00 43.14          
ATOM     25  N   VAL     5      -2.581  36.746  33.247  1.00 38.71          
ATOM     26  CA  VAL     5      -2.449  38.087  32.694  1.00 35.10          
ATOM     27  CB  VAL     5      -3.719  38.935  32.989  1.00 35.84          
ATOM     28  CG1 VAL     5      -3.490  40.413  32.581  1.00 35.47          
ATOM     29  CG2 VAL     5      -4.909  38.356  32.228  1.00 33.49          
ATOM     30  C   VAL     5      -1.230  38.803  33.256  1.00 34.67          
ATOM     31  O   VAL     5      -0.446  39.389  32.512  1.00 34.53          
ATOM     32  N   ILE     6      -1.081  38.777  34.575  1.00 35.13          
ATOM     33  CA  ILE     6       0.052  39.425  35.220  1.00 34.65          
ATOM     34  CB  ILE     6      -0.186  39.580  36.737  1.00 34.25          
ATOM     35  CG2 ILE     6       1.015  40.268  37.390  1.00 31.59          
ATOM     36  CG1 ILE     6      -1.479  40.370  36.987  1.00 33.48          
ATOM     37  CD  ILE     6      -1.867  40.457  38.449  1.00 28.08          
ATOM     38  C   ILE     6       1.316  38.592  35.005  1.00 36.03          
ATOM     39  O   ILE     6       1.293  37.358  35.133  1.00 34.96          
ATOM     40  N   ALA     7       2.410  39.270  34.677  1.00 35.53          
ATOM     41  CA  ALA     7       3.688  38.599  34.454  1.00 40.36          
ATOM     42  CB  ALA     7       4.716  39.599  33.927  1.00 38.81          
ATOM     43  C   ALA     7       4.207  37.938  35.732  1.00 40.87          
ATOM     44  O   ALA     7       4.298  38.573  36.779  1.00 45.09          
ATOM     45  N   GLN     8       4.545  36.657  35.636  1.00 42.36          
ATOM     46  CA  GLN     8       5.055  35.903  36.773  1.00 42.67          
ATOM     47  CB  GLN     8       5.416  34.485  36.337  1.00 42.33          
ATOM     48  CG  GLN     8       5.795  33.566  37.488  1.00 43.24          
ATOM     49  CD  GLN     8       4.603  33.197  38.345  1.00 42.83          
ATOM     50  OE1 GLN     8       3.578  32.755  37.829  1.00 43.63          
ATOM     51  NE2 GLN     8       4.730  33.369  39.659  1.00 42.46          
ATOM     52  C   GLN     8       6.285  36.560  37.406  1.00 43.98          
ATOM     53  O   GLN     8       6.493  36.463  38.617  1.00 45.06          
ATOM     54  N   ALA     9       7.111  37.210  36.593  1.00 42.49          
ATOM     55  CA  ALA     9       8.298  37.862  37.124  1.00 43.37          
ATOM     56  CB  ALA     9       9.098  38.497  36.005  1.00 42.79          
ATOM     57  C   ALA     9       7.874  38.922  38.133  1.00 43.16          
ATOM     58  O   ALA     9       8.433  39.003  39.224  1.00 43.57          
ATOM     59  N   HSD    10       6.879  39.728  37.767  1.00 43.39          
ATOM     60  CA  HSD    10       6.378  40.775  38.656  1.00 42.97          
ATOM     61  CB  HSD    10       5.314  41.637  37.953  1.00 43.19          
ATOM     62  CG  HSD    10       5.860  42.491  36.848  1.00 43.10          
ATOM     63  CD2 HSD    10       5.242  43.290  35.945  1.00 42.11          
ATOM     64  ND1 HSD    10       7.209  42.592  36.585  1.00 42.30          
ATOM     65  CE1 HSD    10       7.400  43.415  35.569  1.00 42.04          
ATOM     66  NE2 HSD    10       6.223  43.853  35.162  1.00 43.04          
ATOM     67  C   HSD    10       5.797  40.156  39.921  1.00 42.31          
ATOM     68  O   HSD    10       6.043  40.647  41.023  1.00 43.53          
ATOM     69  N   ILE    11       5.041  39.073  39.771  1.00 40.92          
ATOM     70  CA  ILE    11       4.459  38.406  40.933  1.00 39.12          
ATOM     71  CB  ILE    11       3.550  37.251  40.516  1.00 38.41          
ATOM     72  CG2 ILE    11       3.084  36.472  41.746  1.00 36.95          
ATOM     73  CG1 ILE    11       2.343  37.798  39.762  1.00 38.19          
ATOM     74  CD  ILE    11       1.493  36.728  39.145  1.00 36.04          
ATOM     75  C   ILE    11       5.555  37.859  41.845  1.00 40.95          
ATOM     76  O   ILE    11       5.434  37.897  43.070  1.00 41.13          
ATOM     77  N   ASP    12       6.625  37.345  41.250  1.00 41.17          
ATOM     78  CA  ASP    12       7.722  36.813  42.041  1.00 39.63          
ATOM     79  CB  ASP    12       8.733  36.075  41.145  1.00 41.10          
ATOM     80  CG  ASP    12       8.187  34.764  40.592  1.00 45.36          
ATOM     81  OD1 ASP    12       7.295  34.167  41.236  1.00 46.36          
ATOM     82  OD2 ASP    12       8.665  34.318  39.525  1.00 45.15          
ATOM     83  C   ASP    12       8.427  37.947  42.792  1.00 38.33          
ATOM     84  O   ASP    12       8.723  37.822  43.973  1.00 37.84          
ATOM     85  N   HSD    13       8.685  39.050  42.099  1.00 37.35          
ATOM     86  CA  HSD    13       9.360  40.196  42.690  1.00 39.45          
ATOM     87  CB  HSD    13       9.590  41.260  41.610  1.00 40.12          
ATOM     88  CG  HSD    13      10.658  42.253  41.949  1.00 41.22          
ATOM     89  CD2 HSD    13      11.393  42.426  43.072  1.00 42.23          
ATOM     90  ND1 HSD    13      11.090  43.212  41.058  1.00 42.76          
ATOM     91  CE1 HSD    13      12.046  43.933  41.617  1.00 41.42          
ATOM     92  NE2 HSD    13      12.250  43.476  42.839  1.00 40.50          
ATOM     93  C   HSD    13       8.562  40.786  43.860  1.00 40.08          
ATOM     94  O   HSD    13       9.110  41.060  44.929  1.00 41.01          
ATOM     95  N   PHE    14       7.261  40.970  43.661  1.00 39.38          
ATOM     96  CA  PHE    14       6.418  41.523  44.709  1.00 37.21          
ATOM     97  CB  PHE    14       5.003  41.780  44.192  1.00 36.26          
ATOM     98  CG  PHE    14       4.072  42.304  45.245  1.00 36.60          
ATOM     99  CD1 PHE    14       4.258  43.577  45.781  1.00 36.10          
ATOM    100  CD2 PHE    14       3.048  41.514  45.742  1.00 35.62          
ATOM    101  CE1 PHE    14       3.443  44.049  46.794  1.00 34.53          
ATOM    102  CE2 PHE    14       2.223  41.981  46.763  1.00 37.98          
ATOM    103  CZ  PHE    14       2.424  43.250  47.288  1.00 36.03          
ATOM    104  C   PHE    14       6.348  40.594  45.909  1.00 38.11          
ATOM    105  O   PHE    14       6.388  41.048  47.054  1.00 38.55          
ATOM    106  N   THR    15       6.222  39.296  45.653  1.00 37.59          
ATOM    107  CA  THR    15       6.157  38.325  46.735  1.00 39.05          
ATOM    108  CB  THR    15       6.103  36.890  46.205  1.00 36.44          
ATOM    109  OG1 THR    15       4.966  36.742  45.345  1.00 38.35          
ATOM    110  CG2 THR    15       5.963  35.912  47.352  1.00 34.02          
ATOM    111  C   THR    15       7.400  38.484  47.606  1.00 42.40          
ATOM    112  O   THR    15       7.339  38.328  48.828  1.00 42.29          
ATOM    113  N   LYS    16       8.527  38.797  46.969  1.00 44.18          
ATOM    114  CA  LYS    16       9.778  39.007  47.694  1.00 44.92          
ATOM    115  CB  LYS    16      10.915  39.323  46.713  1.00 48.14          
ATOM    116  CG  LYS    16      12.274  39.551  47.371  1.00 52.51          
ATOM    117  CD  LYS    16      13.345  39.979  46.361  1.00 55.04          
ATOM    118  CE  LYS    16      13.644  38.873  45.356  1.00 56.85          
ATOM    119  NZ  LYS    16      14.735  39.260  44.414  1.00 58.69          
ATOM    120  C   LYS    16       9.572  40.183  48.652  1.00 43.53          
ATOM    121  O   LYS    16       9.674  40.026  49.868  1.00 42.77          
ATOM    122  N   TRP    17       9.289  41.359  48.097  1.00 41.76          
ATOM    123  CA  TRP    17       9.045  42.553  48.901  1.00 41.20          
ATOM    124  CB  TRP    17       8.451  43.664  48.036  1.00 39.38          
ATOM    125  CG  TRP    17       9.375  44.302  47.035  1.00 37.40          
ATOM    126  CD2 TRP    17       9.049  45.382  46.143  1.00 34.69          
ATOM    127  CE2 TRP    17      10.204  45.659  45.381  1.00 32.93          
ATOM    128  CE3 TRP    17       7.890  46.136  45.915  1.00 31.13          
ATOM    129  CD1 TRP    17      10.678  43.983  46.787  1.00 36.45          
ATOM    130  NE1 TRP    17      11.184  44.796  45.792  1.00 34.75          
ATOM    131  CZ2 TRP    17      10.235  46.660  44.406  1.00 33.80          
ATOM    132  CZ3 TRP    17       7.919  47.130  44.949  1.00 32.34          
ATOM    133  CH2 TRP    17       9.084  47.383  44.203  1.00 33.90          
ATOM    134  C   TRP    17       8.044  42.244  50.022  1.00 43.35          
ATOM    135  O   TRP    17       8.238  42.608  51.179  1.00 43.42          
ATOM    136  N   PHE    18       6.968  41.564  49.645  1.00 44.83          
ATOM    137  CA  PHE    18       5.879  41.199  50.543  1.00 45.58          
ATOM    138  CB  PHE    18       4.843  40.373  49.771  1.00 44.15          
ATOM    139  CG  PHE    18       3.866  39.646  50.647  1.00 40.28          
ATOM    140  CD1 PHE    18       2.867  40.333  51.318  1.00 39.22          
ATOM    141  CD2 PHE    18       3.951  38.268  50.799  1.00 38.13          
ATOM    142  CE1 PHE    18       1.958  39.654  52.130  1.00 40.88          
ATOM    143  CE2 PHE    18       3.058  37.580  51.602  1.00 37.25          
ATOM    144  CZ  PHE    18       2.054  38.273  52.273  1.00 38.48          
ATOM    145  C   PHE    18       6.257  40.451  51.813  1.00 48.27          
ATOM    146  O   PHE    18       5.813  40.806  52.905  1.00 48.40          
ATOM    147  N   GLU    19       7.061  39.406  51.677  1.00 50.96          
ATOM    148  CA  GLU    19       7.450  38.619  52.834  1.00 52.43          
ATOM    149  CB  GLU    19       7.977  37.267  52.359  1.00 55.35          
ATOM    150  CG  GLU    19       6.900  36.491  51.606  1.00 59.69          
ATOM    151  CD  GLU    19       7.355  35.133  51.120  1.00 63.06          
ATOM    152  OE1 GLU    19       8.409  35.061  50.443  1.00 64.77          
ATOM    153  OE2 GLU    19       6.646  34.140  51.407  1.00 64.02          
ATOM    154  C   GLU    19       8.451  39.331  53.736  1.00 51.66          
ATOM    155  O   GLU    19       8.501  39.087  54.941  1.00 50.92          
ATOM    156  N   ARG    20       9.217  40.240  53.150  1.00 51.24          
ATOM    157  CA  ARG    20      10.220  40.998  53.883  1.00 52.55          
ATOM    158  CB  ARG    20      11.332  41.426  52.919  1.00 55.09          
ATOM    159  CG  ARG    20      12.409  42.314  53.530  1.00 60.07          
ATOM    160  CD  ARG    20      13.466  42.689  52.488  1.00 64.44          
ATOM    161  NE  ARG    20      14.431  43.670  52.986  1.00 67.58          
ATOM    162  CZ  ARG    20      15.436  44.161  52.263  1.00 68.91          
ATOM    163  NH1 ARG    20      15.609  43.759  51.008  1.00 68.88          
ATOM    164  NH2 ARG    20      16.263  45.059  52.789  1.00 69.46          
ATOM    165  C   ARG    20       9.642  42.238  54.580  1.00 51.72          
ATOM    166  O   ARG    20      10.138  42.663  55.627  1.00 51.01          
ATOM    167  N   ALA    21       8.588  42.803  53.999  1.00 49.64          
ATOM    168  CA  ALA    21       7.963  44.009  54.528  1.00 47.85          
ATOM    169  CB  ALA    21       6.974  44.561  53.498  1.00 49.46          
ATOM    170  C   ALA    21       7.262  43.872  55.875  1.00 47.01          
ATOM    171  O   ALA    21       6.695  42.825  56.189  1.00 47.44          
ATOM    172  N   ASP    22       7.317  44.945  56.665  1.00 45.09          
ATOM    173  CA  ASP    22       6.652  45.007  57.967  1.00 45.38          
ATOM    174  CB  ASP    22       7.620  45.424  59.083  1.00 47.61          
ATOM    175  CG  ASP    22       8.679  44.373  59.379  1.00 52.55          
ATOM    176  OD1 ASP    22       8.313  43.191  59.585  1.00 54.15          
ATOM    177  OD2 ASP    22       9.879  44.740  59.418  1.00 53.54          
ATOM    178  C   ASP    22       5.559  46.073  57.878  1.00 42.79          
ATOM    179  O   ASP    22       4.439  45.876  58.331  1.00 41.20          
ATOM    180  N   LYS    23       5.917  47.211  57.296  1.00 41.31          
ATOM    181  CA  LYS    23       5.007  48.338  57.156  1.00 40.07          
ATOM    182  CB  LYS    23       5.647  49.611  57.723  1.00 40.15          
ATOM    183  CG  LYS    23       5.723  49.667  59.242  1.00 42.44          
ATOM    184  CD  LYS    23       7.143  49.463  59.732  1.00 45.87          
ATOM    185  CE  LYS    23       7.257  49.684  61.238  1.00 47.87          
ATOM    186  NZ  LYS    23       8.680  49.605  61.691  1.00 47.06          
ATOM    187  C   LYS    23       4.652  48.567  55.700  1.00 38.87          
ATOM    188  O   LYS    23       5.535  48.732  54.851  1.00 39.02          
ATOM    189  N   ILE    24       3.358  48.584  55.408  1.00 37.82          
ATOM    190  CA  ILE    24       2.925  48.788  54.037  1.00 35.88          
ATOM    191  CB  ILE    24       2.339  47.494  53.427  1.00 35.91          
ATOM    192  CG2 ILE    24       2.009  47.724  51.954  1.00 35.08          
ATOM    193  CG1 ILE    24       3.343  46.346  53.559  1.00 35.23          
ATOM    194  CD  ILE    24       2.796  44.996  53.099  1.00 34.91          
ATOM    195  C   ILE    24       1.885  49.881  53.924  1.00 35.76          
ATOM    196  O   ILE    24       1.001  50.003  54.765  1.00 37.25          
ATOM    197  N   VAL    25       2.009  50.689  52.878  1.00 34.59          
ATOM    198  CA  VAL    25       1.058  51.753  52.632  1.00 31.66          
ATOM    199  CB  VAL    25       1.732  53.134  52.735  1.00 33.26          
ATOM    200  CG1 VAL    25       0.844  54.202  52.114  1.00 28.81          
ATOM    201  CG2 VAL    25       2.003  53.455  54.208  1.00 29.92          
ATOM    202  C   VAL    25       0.456  51.571  51.243  1.00 31.50          
ATOM    203  O   VAL    25       1.177  51.307  50.288  1.00 30.16          
ATOM    204  N   ILE    26      -0.870  51.690  51.160  1.00 30.40          
ATOM    205  CA  ILE    26      -1.617  51.567  49.915  1.00 29.14          
ATOM    206  CB  ILE    26      -2.797  50.582  50.066  1.00 28.76          
ATOM    207  CG2 ILE    26      -3.640  50.592  48.809  1.00 27.27          
ATOM    208  CG1 ILE    26      -2.281  49.164  50.345  1.00 28.35          
ATOM    209  CD  ILE    26      -3.368  48.215  50.877  1.00 27.30          
ATOM    210  C   ILE    26      -2.188  52.947  49.589  1.00 29.36          
ATOM    211  O   ILE    26      -2.909  53.531  50.405  1.00 28.32          
ATOM    212  N   VAL    27      -1.874  53.460  48.401  1.00 29.54          
ATOM    213  CA  VAL    27      -2.351  54.773  47.978  1.00 31.52          
ATOM    214  CB  VAL    27      -1.174  55.694  47.634  1.00 32.36          
ATOM    215  CG1 VAL    27      -1.690  57.060  47.194  1.00 35.16          
ATOM    216  CG2 VAL    27      -0.272  55.828  48.828  1.00 34.15          
ATOM    217  C   VAL    27      -3.255  54.704  46.756  1.00 30.07          
ATOM    218  O   VAL    27      -3.071  53.866  45.892  1.00 33.33          
ATOM    219  N   SER    28      -4.237  55.590  46.677  1.00 31.28          
ATOM    220  CA  SER    28      -5.129  55.597  45.525  1.00 32.25          
ATOM    221  CB  SER    28      -6.419  54.843  45.840  1.00 35.92          
ATOM    222  OG  SER    28      -7.076  54.470  44.640  1.00 36.38          
ATOM    223  C   SER    28      -5.406  57.039  45.124  1.00 32.58          
ATOM    224  O   SER    28      -5.047  57.964  45.855  1.00 33.65          
ATOM    225  N   HSD    29      -6.061  57.228  43.978  1.00 33.91          
ATOM    226  CA  HSD    29      -6.293  58.562  43.408  1.00 33.32          
ATOM    227  CB  HSD    29      -6.619  58.408  41.907  1.00 33.19          
ATOM    228  CG  HSD    29      -7.991  57.872  41.623  1.00 34.83          
ATOM    229  CD2 HSD    29      -8.396  56.703  41.068  1.00 32.63          
ATOM    230  ND1 HSD    29      -9.142  58.593  41.871  1.00 36.71          
ATOM    231  CE1 HSD    29     -10.193  57.894  41.477  1.00 34.83          
ATOM    232  NE2 HSD    29      -9.768  56.746  40.985  1.00 34.02          
ATOM    233  C   HSD    29      -7.270  59.560  44.040  1.00 33.50          
ATOM    234  O   HSD    29      -8.182  59.190  44.777  1.00 34.48          
ATOM    235  N   VAL    30      -7.045  60.839  43.734  1.00 33.88          
ATOM    236  CA  VAL    30      -7.872  61.949  44.214  1.00 32.40          
ATOM    237  CB  VAL    30      -7.470  63.287  43.519  1.00 34.85          
ATOM    238  CG1 VAL    30      -7.882  63.268  42.035  1.00 34.37          
ATOM    239  CG2 VAL    30      -8.101  64.471  44.238  1.00 34.77          
ATOM    240  C   VAL    30      -9.339  61.634  43.919  1.00 33.17          
ATOM    241  O   VAL    30      -9.652  60.980  42.919  1.00 34.06          
ATOM    242  N   SER    31     -10.234  62.096  44.785  1.00 32.93          
ATOM    243  CA  SER    31     -11.661  61.827  44.628  1.00 33.69          
ATOM    244  CB  SER    31     -12.251  62.660  43.491  1.00 34.58          
ATOM    245  OG  SER    31     -12.244  64.030  43.841  1.00 39.90          
ATOM    246  C   SER    31     -11.854  60.351  44.329  1.00 31.45          
ATOM    247  O   SER    31     -12.452  59.986  43.314  1.00 32.18          
ATOM    248  N   PRO    32     -11.347  59.480  45.219  1.00 30.81          
ATOM    249  CD  PRO    32     -10.776  59.775  46.546  1.00 28.03          
ATOM    250  CA  PRO    32     -11.476  58.035  45.016  1.00 28.92          
ATOM    251  CB  PRO    32     -10.767  57.446  46.244  1.00 28.88          
ATOM    252  CG  PRO    32     -11.023  58.483  47.300  1.00 27.92          
ATOM    253  C   PRO    32     -12.925  57.591  44.904  1.00 28.55          
ATOM    254  O   PRO    32     -13.799  58.114  45.603  1.00 30.11          
ATOM    255  N   ASP    33     -13.164  56.627  44.015  1.00 29.12          
ATOM    256  CA  ASP    33     -14.493  56.060  43.786  1.00 29.45          
ATOM    257  CB  ASP    33     -14.912  56.230  42.323  1.00 29.48          
ATOM    258  CG  ASP    33     -13.934  55.576  41.348  1.00 30.94          
ATOM    259  OD1 ASP    33     -13.019  54.848  41.778  1.00 32.90          
ATOM    260  OD2 ASP    33     -14.082  55.793  40.134  1.00 33.35          
ATOM    261  C   ASP    33     -14.534  54.570  44.149  1.00 28.90          
ATOM    262  O   ASP    33     -13.629  54.047  44.802  1.00 29.73          
ATOM    263  N   GLY    34     -15.590  53.896  43.703  1.00 26.63          
ATOM    264  CA  GLY    34     -15.758  52.486  43.991  1.00 26.40          
ATOM    265  C   GLY    34     -14.551  51.611  43.723  1.00 28.12          
ATOM    266  O   GLY    34     -14.171  50.807  44.580  1.00 28.23          
ATOM    267  N   ASP    35     -13.933  51.768  42.555  1.00 27.14          
ATOM    268  CA  ASP    35     -12.775  50.947  42.200  1.00 28.32          
ATOM    269  CB  ASP    35     -12.572  50.944  40.673  1.00 29.30          
ATOM    270  CG  ASP    35     -11.587  49.880  40.207  1.00 31.44          
ATOM    271  OD1 ASP    35     -11.466  48.836  40.882  1.00 31.59          
ATOM    272  OD2 ASP    35     -10.947  50.069  39.151  1.00 33.89          
ATOM    273  C   ASP    35     -11.498  51.382  42.914  1.00 26.35          
ATOM    274  O   ASP    35     -10.604  50.575  43.159  1.00 26.54          
ATOM    275  N   ALA    36     -11.398  52.652  43.261  1.00 25.47          
ATOM    276  CA  ALA    36     -10.202  53.096  43.965  1.00 26.79          
ATOM    277  CB  ALA    36     -10.138  54.639  43.984  1.00 24.48          
ATOM    278  C   ALA    36     -10.260  52.535  45.398  1.00 26.45          
ATOM    279  O   ALA    36      -9.297  51.958  45.898  1.00 23.78          
ATOM    280  N   ILE    37     -11.407  52.694  46.048  1.00 25.86          
ATOM    281  CA  ILE    37     -11.579  52.208  47.411  1.00 26.11          
ATOM    282  CB  ILE    37     -12.843  52.813  48.057  1.00 26.33          
ATOM    283  CG2 ILE    37     -12.962  52.332  49.500  1.00 29.36          
ATOM    284  CG1 ILE    37     -12.766  54.344  48.031  1.00 24.81          
ATOM    285  CD  ILE    37     -11.526  54.890  48.684  1.00 22.13          
ATOM    286  C   ILE    37     -11.669  50.676  47.503  1.00 27.36          
ATOM    287  O   ILE    37     -11.055  50.059  48.377  1.00 27.50          
ATOM    288  N   GLY    38     -12.442  50.074  46.604  1.00 27.18          
ATOM    289  CA  GLY    38     -12.605  48.630  46.596  1.00 25.23          
ATOM    290  C   GLY    38     -11.319  47.841  46.393  1.00 26.33          
ATOM    291  O   GLY    38     -11.101  46.850  47.073  1.00 26.12          
ATOM    292  N   SER    39     -10.468  48.271  45.467  1.00 25.60          
ATOM    293  CA  SER    39      -9.220  47.575  45.224  1.00 26.69          
ATOM    294  CB  SER    39      -8.580  48.037  43.909  1.00 27.38          
ATOM    295  OG  SER    39      -8.325  49.430  43.912  1.00 27.36          
ATOM    296  C   SER    39      -8.259  47.815  46.376  1.00 28.36          
ATOM    297  O   SER    39      -7.527  46.903  46.775  1.00 27.38          
ATOM    298  N   SER    40      -8.249  49.039  46.905  1.00 27.65          
ATOM    299  CA  SER    40      -7.375  49.357  48.029  1.00 28.89          
ATOM    300  CB  SER    40      -7.411  50.856  48.336  1.00 28.62          
ATOM    301  OG  SER    40      -6.895  51.600  47.251  1.00 31.32          
ATOM    302  C   SER    40      -7.766  48.568  49.277  1.00 28.20          
ATOM    303  O   SER    40      -6.905  48.034  49.966  1.00 29.02          
ATOM    304  N   LEU    41      -9.060  48.495  49.574  1.00 27.56          
ATOM    305  CA  LEU    41      -9.515  47.754  50.751  1.00 26.91          
ATOM    306  CB  LEU    41     -10.951  48.154  51.108  1.00 23.66          
ATOM    307  CG  LEU    41     -11.219  49.575  51.632  1.00 21.34          
ATOM    308  CD1 LEU    41     -12.706  49.721  51.960  1.00 18.05          
ATOM    309  CD2 LEU    41     -10.388  49.835  52.873  1.00 23.41          
ATOM    310  C   LEU    41      -9.431  46.234  50.518  1.00 27.04          
ATOM    311  O   LEU    41      -9.359  45.453  51.464  1.00 26.84          
ATOM    312  N   GLY    42      -9.457  45.818  49.254  1.00 28.17          
ATOM    313  CA  GLY    42      -9.344  44.404  48.949  1.00 26.80          
ATOM    314  C   GLY    42      -7.924  43.970  49.263  1.00 27.96          
ATOM    315  O   GLY    42      -7.702  42.948  49.910  1.00 30.68          
ATOM    316  N   LEU    43      -6.953  44.750  48.803  1.00 29.79          
ATOM    317  CA  LEU    43      -5.546  44.448  49.071  1.00 30.77          
ATOM    318  CB  LEU    43      -4.637  45.396  48.270  1.00 26.21          
ATOM    319  CG  LEU    43      -3.128  45.160  48.423  1.00 29.21          
ATOM    320  CD1 LEU    43      -2.794  43.731  48.047  1.00 28.13          
ATOM    321  CD2 LEU    43      -2.345  46.134  47.550  1.00 27.64          
ATOM    322  C   LEU    43      -5.303  44.616  50.582  1.00 31.49          
ATOM    323  O   LEU    43      -4.638  43.789  51.222  1.00 32.74          
ATOM    324  N   TYR    44      -5.862  45.684  51.148  1.00 30.11          
ATOM    325  CA  TYR    44      -5.735  45.953  52.575  1.00 30.63          
ATOM    326  CB  TYR    44      -6.651  47.109  52.979  1.00 32.54          
ATOM    327  CG  TYR    44      -6.771  47.318  54.470  1.00 34.40          
ATOM    328  CD1 TYR    44      -5.716  47.844  55.207  1.00 36.25          
ATOM    329  CE1 TYR    44      -5.833  48.048  56.580  1.00 37.78          
ATOM    330  CD2 TYR    44      -7.944  46.992  55.145  1.00 34.48          
ATOM    331  CE2 TYR    44      -8.068  47.187  56.515  1.00 34.71          
ATOM    332  CZ  TYR    44      -7.015  47.718  57.228  1.00 38.46          
ATOM    333  OH  TYR    44      -7.148  47.941  58.587  1.00 39.21          
ATOM    334  C   TYR    44      -6.109  44.726  53.398  1.00 30.77          
ATOM    335  O   TYR    44      -5.304  44.217  54.180  1.00 29.05          
ATOM    336  N   HSD    45      -7.338  44.251  53.235  1.00 31.49          
ATOM    337  CA  HSD    45      -7.774  43.094  54.005  1.00 32.78          
ATOM    338  CB  HSD    45      -9.193  42.698  53.631  1.00 33.36          
ATOM    339  CG  HSD    45     -10.234  43.601  54.208  1.00 35.68          
ATOM    340  CD2 HSD    45     -10.592  43.841  55.491  1.00 35.97          
ATOM    341  ND1 HSD    45     -11.059  44.380  53.428  1.00 36.28          
ATOM    342  CE1 HSD    45     -11.884  45.058  54.204  1.00 36.54          
ATOM    343  NE2 HSD    45     -11.621  44.750  55.460  1.00 37.43          
ATOM    344  C   HSD    45      -6.846  41.904  53.856  1.00 32.83          
ATOM    345  O   HSD    45      -6.539  41.227  54.845  1.00 31.46          
ATOM    346  N   PHE    46      -6.401  41.635  52.630  1.00 31.89          
ATOM    347  CA  PHE    46      -5.482  40.525  52.421  1.00 31.57          
ATOM    348  CB  PHE    46      -5.115  40.376  50.947  1.00 31.48          
ATOM    349  CG  PHE    46      -3.942  39.471  50.732  1.00 29.99          
ATOM    350  CD1 PHE    46      -4.001  38.139  51.143  1.00 29.60          
ATOM    351  CD2 PHE    46      -2.748  39.968  50.221  1.00 29.98          
ATOM    352  CE1 PHE    46      -2.889  37.316  51.060  1.00 29.82          
ATOM    353  CE2 PHE    46      -1.614  39.154  50.127  1.00 30.29          
ATOM    354  CZ  PHE    46      -1.685  37.825  50.551  1.00 32.13          
ATOM    355  C   PHE    46      -4.184  40.728  53.206  1.00 32.52          
ATOM    356  O   PHE    46      -3.769  39.874  53.983  1.00 33.32          
ATOM    357  N   LEU    47      -3.542  41.869  52.989  1.00 32.38          
ATOM    358  CA  LEU    47      -2.290  42.157  53.662  1.00 32.89          
ATOM    359  CB  LEU    47      -1.758  43.515  53.207  1.00 31.48          
ATOM    360  CG  LEU    47      -1.371  43.580  51.725  1.00 30.76          
ATOM    361  CD1 LEU    47      -0.965  44.991  51.368  1.00 28.94          
ATOM    362  CD2 LEU    47      -0.230  42.597  51.442  1.00 30.28          
ATOM    363  C   LEU    47      -2.422  42.126  55.185  1.00 34.82          
ATOM    364  O   LEU    47      -1.545  41.606  55.893  1.00 34.46          
ATOM    365  N   ASP    48      -3.525  42.672  55.688  1.00 36.77          
ATOM    366  CA  ASP    48      -3.756  42.704  57.120  1.00 36.93          
ATOM    367  CB  ASP    48      -4.973  43.577  57.434  1.00 38.42          
ATOM    368  CG  ASP    48      -5.044  43.974  58.897  1.00 41.42          
ATOM    369  OD1 ASP    48      -4.087  44.607  59.387  1.00 43.40          
ATOM    370  OD2 ASP    48      -6.052  43.653  59.558  1.00 43.69          
ATOM    371  C   ASP    48      -3.937  41.294  57.708  1.00 36.86          
ATOM    372  O   ASP    48      -3.667  41.079  58.888  1.00 38.68          
ATOM    373  N   SER    49      -4.382  40.336  56.897  1.00 35.52          
ATOM    374  CA  SER    49      -4.557  38.966  57.387  1.00 36.25          
ATOM    375  CB  SER    49      -5.418  38.134  56.433  1.00 36.08          
ATOM    376  OG  SER    49      -4.663  37.709  55.300  1.00 33.69          
ATOM    377  C   SER    49      -3.193  38.297  57.477  1.00 37.50          
ATOM    378  O   SER    49      -3.053  37.220  58.048  1.00 38.97          
ATOM    379  N   GLN    50      -2.187  38.931  56.898  1.00 37.44          
ATOM    380  CA  GLN    50      -0.855  38.364  56.908  1.00 39.18          
ATOM    381  CB  GLN    50      -0.257  38.461  55.504  1.00 38.23          
ATOM    382  CG  GLN    50      -1.070  37.728  54.463  1.00 35.52          
ATOM    383  CD  GLN    50      -1.122  36.244  54.740  1.00 34.46          
ATOM    384  OE1 GLN    50      -2.188  35.675  55.000  1.00 36.03          
ATOM    385  NE2 GLN    50       0.037  35.607  54.702  1.00 38.23          
ATOM    386  C   GLN    50       0.091  38.990  57.925  1.00 40.98          
ATOM    387  O   GLN    50       1.275  39.144  57.651  1.00 42.44          
ATOM    388  N   ASP    51      -0.433  39.350  59.095  1.00 43.39          
ATOM    389  CA  ASP    51       0.384  39.927  60.169  1.00 45.28          
ATOM    390  CB  ASP    51       1.256  38.826  60.809  1.00 47.56          
ATOM    391  CG  ASP    51       2.005  39.300  62.073  1.00 52.02          
ATOM    392  OD1 ASP    51       1.345  39.766  63.033  1.00 52.05          
ATOM    393  OD2 ASP    51       3.257  39.188  62.110  1.00 51.44          
ATOM    394  C   ASP    51       1.274  41.077  59.690  1.00 44.85          
ATOM    395  O   ASP    51       2.489  41.060  59.890  1.00 43.78          
ATOM    396  N   LYS    52       0.673  42.068  59.039  1.00 43.04          
ATOM    397  CA  LYS    52       1.441  43.216  58.579  1.00 41.75          
ATOM    398  CB  LYS    52       1.688  43.126  57.069  1.00 42.51          
ATOM    399  CG  LYS    52       2.677  42.019  56.751  1.00 46.54          
ATOM    400  CD  LYS    52       3.056  41.939  55.298  1.00 47.80          
ATOM    401  CE  LYS    52       3.862  40.665  55.035  1.00 48.07          
ATOM    402  NZ  LYS    52       5.131  40.604  55.822  1.00 45.53          
ATOM    403  C   LYS    52       0.756  44.521  58.942  1.00 38.98          
ATOM    404  O   LYS    52      -0.454  44.561  59.117  1.00 37.30          
ATOM    405  N   ILE    53       1.549  45.575  59.105  1.00 36.70          
ATOM    406  CA  ILE    53       1.009  46.886  59.427  1.00 35.00          
ATOM    407  CB  ILE    53       2.034  47.737  60.192  1.00 35.59          
ATOM    408  CG2 ILE    53       1.449  49.120  60.477  1.00 34.46          
ATOM    409  CG1 ILE    53       2.395  47.031  61.513  1.00 34.83          
ATOM    410  CD  ILE    53       3.561  47.667  62.272  1.00 33.44          
ATOM    411  C   ILE    53       0.679  47.497  58.078  1.00 33.10          
ATOM    412  O   ILE    53       1.555  47.648  57.224  1.00 32.73          
ATOM    413  N   VAL    54      -0.598  47.805  57.878  1.00 31.77          
ATOM    414  CA  VAL    54      -1.072  48.345  56.612  1.00 29.40          
ATOM    415  CB  VAL    54      -1.850  47.269  55.833  1.00 29.09          
ATOM    416  CG1 VAL    54      -1.776  47.546  54.354  1.00 30.04          
ATOM    417  CG2 VAL    54      -1.320  45.889  56.182  1.00 28.84          
ATOM    418  C   VAL    54      -2.015  49.526  56.808  1.00 29.37          
ATOM    419  O   VAL    54      -2.941  49.464  57.615  1.00 28.18          
ATOM    420  N   ASN    55      -1.783  50.591  56.050  1.00 29.03          
ATOM    421  CA  ASN    55      -2.612  51.787  56.112  1.00 26.75          
ATOM    422  CB  ASN    55      -1.874  52.922  56.818  1.00 26.03          
ATOM    423  CG  ASN    55      -1.659  52.651  58.286  1.00 26.40          
ATOM    424  OD1 ASN    55      -2.612  52.609  59.065  1.00 25.84          
ATOM    425  ND2 ASN    55      -0.407  52.456  58.677  1.00 26.86          
ATOM    426  C   ASN    55      -2.944  52.228  54.697  1.00 27.96          
ATOM    427  O   ASN    55      -2.060  52.287  53.838  1.00 29.55          
ATOM    428  N   VAL    56      -4.222  52.517  54.468  1.00 27.62          
ATOM    429  CA  VAL    56      -4.725  52.982  53.180  1.00 27.84          
ATOM    430  CB  VAL    56      -6.141  52.394  52.893  1.00 27.96          
ATOM    431  CG1 VAL    56      -6.672  52.909  51.566  1.00 27.29          
ATOM    432  CG2 VAL    56      -6.081  50.872  52.911  1.00 26.32          
ATOM    433  C   VAL    56      -4.819  54.504  53.295  1.00 29.56          
ATOM    434  O   VAL    56      -5.399  55.032  54.254  1.00 31.54          
ATOM    435  N   ILE    57      -4.242  55.203  52.323  1.00 29.78          
ATOM    436  CA  ILE    57      -4.219  56.665  52.312  1.00 29.55          
ATOM    437  CB  ILE    57      -2.795  57.210  52.593  1.00 30.14          
ATOM    438  CG2 ILE    57      -2.838  58.722  52.702  1.00 28.42          
ATOM    439  CG1 ILE    57      -2.229  56.601  53.881  1.00 32.53          
ATOM    440  CD  ILE    57      -0.798  57.048  54.208  1.00 30.80          
ATOM    441  C   ILE    57      -4.631  57.206  50.949  1.00 31.03          
ATOM    442  O   ILE    57      -4.083  56.803  49.926  1.00 30.07          
ATOM    443  N   VAL    58      -5.589  58.125  50.946  1.00 31.81          
ATOM    444  CA  VAL    58      -6.059  58.744  49.724  1.00 31.32          
ATOM    445  CB  VAL    58      -7.481  58.260  49.356  1.00 29.85          
ATOM    446  CG1 VAL    58      -7.470  56.732  49.131  1.00 26.17          
ATOM    447  CG2 VAL    58      -8.456  58.622  50.466  1.00 27.71          
ATOM    448  C   VAL    58      -6.051  60.249  49.990  1.00 34.66          
ATOM    449  O   VAL    58      -6.151  60.692  51.133  1.00 35.74          
ATOM    450  N   PRO    59      -5.935  61.064  48.938  1.00 36.20          
ATOM    451  CD  PRO    59      -5.712  60.777  47.507  1.00 35.64          
ATOM    452  CA  PRO    59      -5.913  62.502  49.199  1.00 37.92          
ATOM    453  CB  PRO    59      -5.257  63.056  47.934  1.00 37.96          
ATOM    454  CG  PRO    59      -5.768  62.150  46.882  1.00 37.41          
ATOM    455  C   PRO    59      -7.262  63.145  49.469  1.00 37.79          
ATOM    456  O   PRO    59      -7.333  64.254  49.991  1.00 37.77          
ATOM    457  N   ASN    60      -8.328  62.421  49.163  1.00 37.74          
ATOM    458  CA  ASN    60      -9.649  62.999  49.269  1.00 37.58          
ATOM    459  CB  ASN    60     -10.102  63.407  47.860  1.00 41.54          
ATOM    460  CG  ASN    60     -10.430  64.856  47.766  1.00 43.71          
ATOM    461  OD1 ASN    60     -10.838  65.356  46.710  1.00 42.06          
ATOM    462  ND2 ASN    60     -10.244  65.563  48.880  1.00 46.57          
ATOM    463  C   ASN    60     -10.711  62.100  49.843  1.00 36.65          
ATOM    464  O   ASN    60     -10.576  60.886  49.842  1.00 38.33          
ATOM    465  N   ALA    61     -11.796  62.716  50.291  1.00 32.40          
ATOM    466  CA  ALA    61     -12.922  61.965  50.818  1.00 31.75          
ATOM    467  CB  ALA    61     -13.935  62.923  51.455  1.00 27.37          
ATOM    468  C   ALA    61     -13.588  61.174  49.676  1.00 29.99          
ATOM    469  O   ALA    61     -13.589  61.613  48.528  1.00 29.09          
ATOM    470  N   PHE    62     -14.132  60.002  49.999  1.00 30.76          
ATOM    471  CA  PHE    62     -14.838  59.179  49.032  1.00 30.64          
ATOM    472  CB  PHE    62     -14.399  57.710  49.149  1.00 31.09          
ATOM    473  CG  PHE    62     -14.203  57.239  50.558  1.00 28.04          
ATOM    474  CD1 PHE    62     -15.243  56.676  51.267  1.00 28.08          
ATOM    475  CD2 PHE    62     -12.969  57.376  51.178  1.00 31.11          
ATOM    476  CE1 PHE    62     -15.065  56.259  52.578  1.00 29.65          
ATOM    477  CE2 PHE    62     -12.779  56.963  52.488  1.00 31.33          
ATOM    478  CZ  PHE    62     -13.829  56.402  53.190  1.00 30.85          
ATOM    479  C   PHE    62     -16.332  59.346  49.311  1.00 31.27          
ATOM    480  O   PHE    62     -16.712  59.788  50.376  1.00 31.45          
ATOM    481  N   PRO    63     -17.199  59.019  48.346  1.00 33.05          
ATOM    482  CD  PRO    63     -16.914  58.661  46.948  1.00 32.96          
ATOM    483  CA  PRO    63     -18.644  59.173  48.571  1.00 33.62          
ATOM    484  CB  PRO    63     -19.251  58.731  47.241  1.00 32.78          
ATOM    485  CG  PRO    63     -18.183  59.097  46.241  1.00 32.91          
ATOM    486  C   PRO    63     -19.222  58.386  49.752  1.00 34.25          
ATOM    487  O   PRO    63     -18.687  57.346  50.150  1.00 34.94          
ATOM    488  N   ASP    64     -20.327  58.891  50.292  1.00 33.47          
ATOM    489  CA  ASP    64     -21.005  58.266  51.414  1.00 33.89          
ATOM    490  CB  ASP    64     -22.157  59.150  51.919  1.00 36.56          
ATOM    491  CG  ASP    64     -21.674  60.400  52.659  1.00 40.84          
ATOM    492  OD1 ASP    64     -20.450  60.583  52.842  1.00 42.78          
ATOM    493  OD2 ASP    64     -22.538  61.207  53.065  1.00 44.20          
ATOM    494  C   ASP    64     -21.561  56.905  51.052  1.00 33.28          
ATOM    495  O   ASP    64     -21.734  56.056  51.923  1.00 34.03          
ATOM    496  N   PHE    65     -21.857  56.687  49.778  1.00 32.12          
ATOM    497  CA  PHE    65     -22.385  55.393  49.393  1.00 31.83          
ATOM    498  CB  PHE    65     -23.076  55.462  48.026  1.00 29.14          
ATOM    499  CG  PHE    65     -22.233  56.041  46.924  1.00 28.68          
ATOM    500  CD1 PHE    65     -21.184  55.314  46.376  1.00 29.64          
ATOM    501  CD2 PHE    65     -22.538  57.293  46.383  1.00 30.47          
ATOM    502  CE1 PHE    65     -20.448  55.809  45.304  1.00 28.66          
ATOM    503  CE2 PHE    65     -21.806  57.806  45.303  1.00 27.64          
ATOM    504  CZ  PHE    65     -20.763  57.062  44.762  1.00 32.72          
ATOM    505  C   PHE    65     -21.289  54.326  49.418  1.00 32.66          
ATOM    506  O   PHE    65     -21.525  53.169  49.088  1.00 34.42          
ATOM    507  N   LEU    66     -20.095  54.724  49.833  1.00 31.79          
ATOM    508  CA  LEU    66     -18.982  53.795  49.943  1.00 32.29          
ATOM    509  CB  LEU    66     -17.772  54.337  49.174  1.00 29.27          
ATOM    510  CG  LEU    66     -17.458  53.742  47.792  1.00 29.38          
ATOM    511  CD1 LEU    66     -18.720  53.490  47.016  1.00 27.89          
ATOM    512  CD2 LEU    66     -16.520  54.686  47.022  1.00 26.27          
ATOM    513  C   LEU    66     -18.608  53.542  51.422  1.00 34.02          
ATOM    514  O   LEU    66     -17.796  52.657  51.715  1.00 34.35          
ATOM    515  N   LYS    67     -19.214  54.300  52.343  1.00 34.06          
ATOM    516  CA  LYS    67     -18.922  54.172  53.784  1.00 35.32          
ATOM    517  CB  LYS    67     -19.717  55.202  54.608  1.00 35.07          
ATOM    518  CG  LYS    67     -19.405  56.658  54.305  1.00 40.09          
ATOM    519  CD  LYS    67     -17.937  56.978  54.510  1.00 40.44          
ATOM    520  CE  LYS    67     -17.627  58.424  54.103  1.00 43.21          
ATOM    521  NZ  LYS    67     -18.403  59.446  54.876  1.00 42.94          
ATOM    522  C   LYS    67     -19.204  52.789  54.375  1.00 33.77          
ATOM    523  O   LYS    67     -18.551  52.365  55.334  1.00 34.03          
ATOM    524  N   TRP    68     -20.189  52.099  53.822  1.00 31.42          
ATOM    525  CA  TRP    68     -20.540  50.784  54.326  1.00 30.37          
ATOM    526  CB  TRP    68     -21.740  50.255  53.557  1.00 29.25          
ATOM    527  CG  TRP    68     -21.440  50.113  52.090  1.00 27.99          
ATOM    528  CD2 TRP    68     -20.930  48.948  51.427  1.00 26.98          
ATOM    529  CE2 TRP    68     -20.816  49.264  50.055  1.00 27.98          
ATOM    530  CE3 TRP    68     -20.563  47.667  51.859  1.00 28.36          
ATOM    531  CD1 TRP    68     -21.595  51.066  51.122  1.00 27.96          
ATOM    532  NE1 TRP    68     -21.225  50.564  49.900  1.00 28.85          
ATOM    533  CZ2 TRP    68     -20.342  48.342  49.105  1.00 26.01          
ATOM    534  CZ3 TRP    68     -20.089  46.751  50.914  1.00 27.81          
ATOM    535  CH2 TRP    68     -19.989  47.097  49.553  1.00 28.09          
ATOM    536  C   TRP    68     -19.390  49.778  54.191  1.00 30.93          
ATOM    537  O   TRP    68     -19.351  48.774  54.891  1.00 31.65          
ATOM    538  N   MET    69     -18.456  50.041  53.287  1.00 31.64          
ATOM    539  CA  MET    69     -17.363  49.104  53.060  1.00 31.14          
ATOM    540  CB  MET    69     -16.485  49.621  51.923  1.00 31.66          
ATOM    541  CG  MET    69     -17.297  49.856  50.661  1.00 35.57          
ATOM    542  SD  MET    69     -16.258  50.298  49.110  0.82 40.99          
ATOM    543  CE  MET    69     -15.599  48.525  48.755  1.00 32.37          
ATOM    544  C   MET    69     -16.537  48.796  54.304  1.00 30.75          
ATOM    545  O   MET    69     -16.101  49.703  55.022  1.00 30.72          
ATOM    546  N   PRO    70     -16.302  47.501  54.577  1.00 28.17          
ATOM    547  CD  PRO    70     -16.736  46.286  53.859  1.00 28.83          
ATOM    548  CA  PRO    70     -15.514  47.169  55.774  1.00 27.85          
ATOM    549  CB  PRO    70     -15.621  45.641  55.859  1.00 25.83          
ATOM    550  CG  PRO    70     -15.823  45.229  54.423  1.00 28.24          
ATOM    551  C   PRO    70     -14.090  47.668  55.644  1.00 27.04          
ATOM    552  O   PRO    70     -13.412  47.368  54.672  1.00 27.87          
ATOM    553  N   GLY    71     -13.649  48.448  56.624  1.00 26.27          
ATOM    554  CA  GLY    71     -12.306  49.000  56.580  1.00 25.37          
ATOM    555  C   GLY    71     -12.282  50.438  56.088  1.00 26.27          
ATOM    556  O   GLY    71     -11.265  51.129  56.223  1.00 25.98          
ATOM    557  N   SER    72     -13.393  50.908  55.523  1.00 27.02          
ATOM    558  CA  SER    72     -13.426  52.282  55.007  1.00 29.27          
ATOM    559  CB  SER    72     -14.736  52.560  54.252  1.00 28.76          
ATOM    560  OG  SER    72     -15.845  52.561  55.125  1.00 30.29          
ATOM    561  C   SER    72     -13.205  53.355  56.070  1.00 29.72          
ATOM    562  O   SER    72     -12.609  54.395  55.783  1.00 32.66          
ATOM    563  N   LYS    73     -13.670  53.113  57.292  1.00 30.61          
ATOM    564  CA  LYS    73     -13.486  54.089  58.366  1.00 33.82          
ATOM    565  CB  LYS    73     -14.232  53.661  59.636  1.00 38.19          
ATOM    566  CG  LYS    73     -15.748  53.712  59.545  1.00 42.50          
ATOM    567  CD  LYS    73     -16.388  53.404  60.907  1.00 45.65          
ATOM    568  CE  LYS    73     -17.914  53.334  60.825  1.00 49.02          
ATOM    569  NZ  LYS    73     -18.518  53.057  62.163  1.00 49.92          
ATOM    570  C   LYS    73     -12.015  54.305  58.725  1.00 34.09          
ATOM    571  O   LYS    73     -11.656  55.332  59.294  1.00 32.84          
ATOM    572  N   ASP    74     -11.165  53.335  58.414  1.00 34.27          
ATOM    573  CA  ASP    74      -9.749  53.463  58.735  1.00 33.14          
ATOM    574  CB  ASP    74      -9.185  52.104  59.130  1.00 36.60          
ATOM    575  CG  ASP    74      -9.836  51.563  60.380  1.00 42.86          
ATOM    576  OD1 ASP    74      -9.601  52.144  61.465  1.00 42.82          
ATOM    577  OD2 ASP    74     -10.598  50.573  60.275  1.00 45.88          
ATOM    578  C   ASP    74      -8.933  54.063  57.609  1.00 31.29          
ATOM    579  O   ASP    74      -7.731  54.244  57.733  1.00 30.75          
ATOM    580  N   ILE    75      -9.587  54.364  56.501  1.00 31.72          
ATOM    581  CA  ILE    75      -8.891  54.972  55.383  1.00 29.07          
ATOM    582  CB  ILE    75      -9.791  54.988  54.146  1.00 28.66          
ATOM    583  CG2 ILE    75      -9.243  55.985  53.115  1.00 26.91          
ATOM    584  CG1 ILE    75      -9.906  53.552  53.603  1.00 25.62          
ATOM    585  CD  ILE    75     -10.723  53.401  52.336  1.00 23.30          
ATOM    586  C   ILE    75      -8.492  56.388  55.807  1.00 30.43          
ATOM    587  O   ILE    75      -9.304  57.135  56.358  1.00 28.26          
ATOM    588  N   LEU    76      -7.232  56.740  55.573  1.00 31.55          
ATOM    589  CA  LEU    76      -6.714  58.044  55.970  1.00 31.89          
ATOM    590  CB  LEU    76      -5.269  57.892  56.434  1.00 33.71          
ATOM    591  CG  LEU    76      -4.570  59.113  57.030  1.00 40.05          
ATOM    592  CD1 LEU    76      -5.274  59.539  58.319  1.00 41.69          
ATOM    593  CD2 LEU    76      -3.113  58.767  57.326  1.00 41.40          
ATOM    594  C   LEU    76      -6.797  59.083  54.862  1.00 33.23          
ATOM    595  O   LEU    76      -6.278  58.876  53.766  1.00 33.29          
ATOM    596  N   LEU    77      -7.460  60.200  55.158  1.00 32.61          
ATOM    597  CA  LEU    77      -7.616  61.290  54.203  1.00 32.41          
ATOM    598  CB  LEU    77      -8.928  62.031  54.472  1.00 29.66          
ATOM    599  CG  LEU    77     -10.166  61.551  53.700  1.00 33.37          
ATOM    600  CD1 LEU    77     -10.200  60.033  53.609  1.00 34.92          
ATOM    601  CD2 LEU    77     -11.421  62.076  54.380  1.00 33.03          
ATOM    602  C   LEU    77      -6.430  62.234  54.331  1.00 32.68          
ATOM    603  O   LEU    77      -6.239  62.862  55.370  1.00 34.95          
ATOM    604  N   TYR    78      -5.637  62.327  53.267  1.00 34.06          
ATOM    605  CA  TYR    78      -4.442  63.166  53.256  1.00 34.06          
ATOM    606  CB  TYR    78      -3.680  62.958  51.949  1.00 32.66          
ATOM    607  CG  TYR    78      -2.285  63.531  51.955  1.00 32.30          
ATOM    608  CD1 TYR    78      -2.024  64.788  51.414  1.00 30.89          
ATOM    609  CE1 TYR    78      -0.734  65.306  51.397  1.00 33.96          
ATOM    610  CD2 TYR    78      -1.221  62.805  52.487  1.00 33.50          
ATOM    611  CE2 TYR    78       0.077  63.309  52.476  1.00 33.03          
ATOM    612  CZ  TYR    78       0.313  64.557  51.924  1.00 35.44          
ATOM    613  OH  TYR    78       1.601  65.042  51.861  1.00 36.90          
ATOM    614  C   TYR    78      -4.655  64.662  53.490  1.00 33.92          
ATOM    615  O   TYR    78      -3.805  65.316  54.102  1.00 34.27          
ATOM    616  N   ASP    79      -5.766  65.206  53.007  1.00 35.91          
ATOM    617  CA  ASP    79      -6.046  66.622  53.195  1.00 38.79          
ATOM    618  CB  ASP    79      -7.097  67.113  52.185  1.00 38.82          
ATOM    619  CG  ASP    79      -8.456  66.429  52.347  1.00 41.50          
ATOM    620  OD1 ASP    79      -8.611  65.613  53.272  1.00 43.85          
ATOM    621  OD2 ASP    79      -9.379  66.712  51.544  1.00 40.81          
ATOM    622  C   ASP    79      -6.523  66.934  54.616  1.00 40.94          
ATOM    623  O   ASP    79      -7.037  68.024  54.871  1.00 40.44          
ATOM    624  N   ARG    80      -6.350  65.985  55.538  1.00 41.60          
ATOM    625  CA  ARG    80      -6.784  66.187  56.917  1.00 43.07          
ATOM    626  CB  ARG    80      -8.137  65.514  57.141  1.00 46.63          
ATOM    627  CG  ARG    80      -9.183  65.989  56.157  1.00 54.16          
ATOM    628  CD  ARG    80     -10.510  65.268  56.304  1.00 59.08          
ATOM    629  NE  ARG    80     -11.373  65.547  55.157  1.00 63.08          
ATOM    630  CZ  ARG    80     -12.647  65.179  55.067  1.00 65.70          
ATOM    631  NH1 ARG    80     -13.220  64.511  56.065  1.00 65.94          
ATOM    632  NH2 ARG    80     -13.349  65.482  53.980  1.00 64.66          
ATOM    633  C   ARG    80      -5.796  65.669  57.944  1.00 42.03          
ATOM    634  O   ARG    80      -5.856  66.049  59.108  1.00 41.92          
ATOM    635  N   TYR    81      -4.888  64.801  57.510  1.00 41.24          
ATOM    636  CA  TYR    81      -3.889  64.217  58.402  1.00 39.85          
ATOM    637  CB  TYR    81      -4.335  62.823  58.846  1.00 38.67          
ATOM    638  CG  TYR    81      -5.616  62.833  59.643  1.00 40.17          
ATOM    639  CD1 TYR    81      -5.663  63.403  60.912  1.00 39.13          
ATOM    640  CE1 TYR    81      -6.850  63.471  61.626  1.00 38.11          
ATOM    641  CD2 TYR    81      -6.799  62.322  59.108  1.00 41.32          
ATOM    642  CE2 TYR    81      -7.996  62.385  59.818  1.00 39.97          
ATOM    643  CZ  TYR    81      -8.009  62.964  61.074  1.00 40.07          
ATOM    644  OH  TYR    81      -9.189  63.046  61.771  1.00 39.26          
ATOM    645  C   TYR    81      -2.569  64.118  57.668  1.00 38.91          
ATOM    646  O   TYR    81      -1.912  63.072  57.688  1.00 37.78          
ATOM    647  N   GLN    82      -2.174  65.216  57.037  1.00 37.90          
ATOM    648  CA  GLN    82      -0.941  65.242  56.262  1.00 40.84          
ATOM    649  CB  GLN    82      -0.728  66.623  55.640  1.00 40.56          
ATOM    650  CG  GLN    82       0.516  66.689  54.789  1.00 44.88          
ATOM    651  CD  GLN    82       0.669  68.008  54.070  1.00 47.57          
ATOM    652  OE1 GLN    82       1.668  68.239  53.384  1.00 50.54          
ATOM    653  NE2 GLN    82      -0.321  68.879  54.209  1.00 46.33          
ATOM    654  C   GLN    82       0.302  64.830  57.023  1.00 42.03          
ATOM    655  O   GLN    82       1.054  63.971  56.560  1.00 43.23          
ATOM    656  N   GLU    83       0.526  65.441  58.182  1.00 43.36          
ATOM    657  CA  GLU    83       1.692  65.125  59.004  1.00 43.35          
ATOM    658  CB  GLU    83       1.588  65.843  60.357  1.00 46.89          
ATOM    659  CG  GLU    83       2.867  66.543  60.828  1.00 52.94          
ATOM    660  CD  GLU    83       3.923  65.591  61.386  1.00 57.16          
ATOM    661  OE1 GLU    83       3.705  65.003  62.479  1.00 57.43          
ATOM    662  OE2 GLU    83       4.980  65.434  60.729  1.00 58.63          
ATOM    663  C   GLU    83       1.733  63.615  59.220  1.00 41.35          
ATOM    664  O   GLU    83       2.724  62.963  58.927  1.00 42.06          
ATOM    665  N   PHE    84       0.635  63.074  59.735  1.00 40.42          
ATOM    666  CA  PHE    84       0.508  61.643  60.002  1.00 39.17          
ATOM    667  CB  PHE    84      -0.892  61.376  60.578  1.00 38.13          
ATOM    668  CG  PHE    84      -1.137  59.951  60.999  1.00 35.76          
ATOM    669  CD1 PHE    84      -0.082  59.086  61.279  1.00 34.07          
ATOM    670  CD2 PHE    84      -2.441  59.485  61.147  1.00 35.03          
ATOM    671  CE1 PHE    84      -0.333  57.776  61.701  1.00 34.76          
ATOM    672  CE2 PHE    84      -2.701  58.184  61.568  1.00 32.86          
ATOM    673  CZ  PHE    84      -1.647  57.327  61.844  1.00 33.63          
ATOM    674  C   PHE    84       0.742  60.839  58.713  1.00 38.18          
ATOM    675  O   PHE    84       1.596  59.949  58.673  1.00 37.58          
ATOM    676  N   ALA    85      -0.004  61.168  57.660  1.00 37.01          
ATOM    677  CA  ALA    85       0.140  60.476  56.381  1.00 37.48          
ATOM    678  CB  ALA    85      -0.719  61.140  55.324  1.00 36.13          
ATOM    679  C   ALA    85       1.597  60.476  55.934  1.00 38.07          
ATOM    680  O   ALA    85       2.167  59.418  55.646  1.00 38.53          
ATOM    681  N   ASP    86       2.200  61.662  55.887  1.00 38.63          
ATOM    682  CA  ASP    86       3.592  61.782  55.470  1.00 38.89          
ATOM    683  CB  ASP    86       4.093  63.211  55.664  1.00 38.29          
ATOM    684  CG  ASP    86       3.481  64.184  54.675  1.00 40.83          
ATOM    685  OD1 ASP    86       2.960  63.735  53.626  1.00 40.42          
ATOM    686  OD2 ASP    86       3.536  65.405  54.942  1.00 42.57          
ATOM    687  C   ASP    86       4.517  60.824  56.207  1.00 38.30          
ATOM    688  O   ASP    86       5.380  60.205  55.598  1.00 39.58          
ATOM    689  N   LYS    87       4.338  60.698  57.517  1.00 38.01          
ATOM    690  CA  LYS    87       5.174  59.804  58.308  1.00 35.88          
ATOM    691  CB  LYS    87       4.828  59.910  59.796  1.00 37.18          
ATOM    692  CG  LYS    87       5.474  61.057  60.546  1.00 38.89          
ATOM    693  CD  LYS    87       5.259  60.851  62.047  1.00 41.78          
ATOM    694  CE  LYS    87       6.029  61.848  62.891  1.00 43.14          
ATOM    695  NZ  LYS    87       5.903  61.486  64.333  1.00 46.08          
ATOM    696  C   LYS    87       5.013  58.360  57.865  1.00 34.44          
ATOM    697  O   LYS    87       5.997  57.651  57.687  1.00 35.58          
ATOM    698  N   LEU    88       3.767  57.915  57.712  1.00 34.03          
ATOM    699  CA  LEU    88       3.497  56.548  57.271  1.00 33.27          
ATOM    700  CB  LEU    88       1.987  56.301  57.194  1.00 32.14          
ATOM    701  CG  LEU    88       1.214  56.320  58.519  1.00 31.68          
ATOM    702  CD1 LEU    88      -0.287  56.264  58.268  1.00 30.17          
ATOM    703  CD2 LEU    88       1.654  55.144  59.361  1.00 30.35          
ATOM    704  C   LEU    88       4.121  56.301  55.894  1.00 32.41          
ATOM    705  O   LEU    88       4.744  55.268  55.668  1.00 32.09          
ATOM    706  N   ILE    89       3.948  57.254  54.979  1.00 33.64          
ATOM    707  CA  ILE    89       4.486  57.130  53.628  1.00 34.27          
ATOM    708  CB  ILE    89       3.984  58.290  52.734  1.00 33.66          
ATOM    709  CG2 ILE    89       4.684  58.281  51.386  1.00 33.00          
ATOM    710  CG1 ILE    89       2.472  58.152  52.528  1.00 32.47          
ATOM    711  CD  ILE    89       1.829  59.343  51.863  1.00 33.70          
ATOM    712  C   ILE    89       6.013  57.080  53.636  1.00 35.89          
ATOM    713  O   ILE    89       6.603  56.205  53.017  1.00 37.25          
ATOM    714  N   MET    90       6.653  57.995  54.359  1.00 37.05          
ATOM    715  CA  MET    90       8.110  58.018  54.414  1.00 38.99          
ATOM    716  CB  MET    90       8.599  59.264  55.150  1.00 41.56          
ATOM    717  CG  MET    90       8.408  60.580  54.395  1.00 41.92          
ATOM    718  SD  MET    90       9.402  60.619  52.728  0.74 46.55          
ATOM    719  CE  MET    90      11.162  60.273  53.427  1.00 38.88          
ATOM    720  C   MET    90       8.688  56.795  55.103  1.00 40.77          
ATOM    721  O   MET    90       9.826  56.414  54.843  1.00 41.78          
ATOM    722  N   GLU    91       7.901  56.166  55.969  1.00 40.75          
ATOM    723  CA  GLU    91       8.384  55.011  56.708  1.00 39.81          
ATOM    724  CB  GLU    91       7.946  55.131  58.172  1.00 39.54          
ATOM    725  CG  GLU    91       8.353  56.452  58.821  1.00 42.24          
ATOM    726  CD  GLU    91       8.164  56.456  60.334  1.00 42.27          
ATOM    727  OE1 GLU    91       7.069  56.099  60.814  1.00 39.94          
ATOM    728  OE2 GLU    91       9.116  56.826  61.049  1.00 44.46          
ATOM    729  C   GLU    91       7.981  53.642  56.160  1.00 39.90          
ATOM    730  O   GLU    91       8.396  52.615  56.698  1.00 38.09          
ATOM    731  N   ALA    92       7.188  53.619  55.091  1.00 38.87          
ATOM    732  CA  ALA    92       6.741  52.350  54.519  1.00 37.94          
ATOM    733  CB  ALA    92       5.589  52.601  53.556  1.00 38.28          
ATOM    734  C   ALA    92       7.830  51.523  53.819  1.00 38.26          
ATOM    735  O   ALA    92       8.633  52.049  53.038  1.00 35.92          
ATOM    736  N   ASP    93       7.853  50.221  54.099  1.00 36.50          
ATOM    737  CA  ASP    93       8.818  49.339  53.453  1.00 36.59          
ATOM    738  CB  ASP    93       8.840  47.966  54.134  1.00 37.39          
ATOM    739  CG  ASP    93       9.257  48.035  55.590  1.00 38.73          
ATOM    740  OD1 ASP    93      10.324  48.622  55.871  1.00 39.27          
ATOM    741  OD2 ASP    93       8.526  47.492  56.449  1.00 37.39          
ATOM    742  C   ASP    93       8.368  49.173  51.994  1.00 37.69          
ATOM    743  O   ASP    93       9.188  49.131  51.066  1.00 37.42          
ATOM    744  N   VAL    94       7.050  49.086  51.810  1.00 36.05          
ATOM    745  CA  VAL    94       6.445  48.917  50.493  1.00 35.77          
ATOM    746  CB  VAL    94       5.894  47.489  50.309  1.00 34.02          
ATOM    747  CG1 VAL    94       5.126  47.396  49.003  1.00 34.22          
ATOM    748  CG2 VAL    94       7.018  46.481  50.350  1.00 34.98          
ATOM    749  C   VAL    94       5.280  49.874  50.303  1.00 36.07          
ATOM    750  O   VAL    94       4.435  50.012  51.188  1.00 36.28          
ATOM    751  N   ILE    95       5.235  50.522  49.142  1.00 33.64          
ATOM    752  CA  ILE    95       4.159  51.454  48.825  1.00 32.60          
ATOM    753  CB  ILE    95       4.688  52.858  48.470  1.00 30.93          
ATOM    754  CG2 ILE    95       3.518  53.756  48.059  1.00 29.57          
ATOM    755  CG1 ILE    95       5.448  53.450  49.660  1.00 29.98          
ATOM    756  CD  ILE    95       5.824  54.901  49.491  1.00 28.21          
ATOM    757  C   ILE    95       3.402  50.946  47.608  1.00 34.39          
ATOM    758  O   ILE    95       3.940  50.939  46.500  1.00 33.57          
ATOM    759  N   CYS    96       2.157  50.522  47.806  1.00 33.80          
ATOM    760  CA  CYS    96       1.362  50.034  46.692  1.00 33.46          
ATOM    761  CB  CYS    96       0.449  48.904  47.152  1.00 32.49          
ATOM    762  SG  CYS    96       1.331  47.592  48.009  1.00 36.58          
ATOM    763  C   CYS    96       0.526  51.168  46.130  1.00 33.15          
ATOM    764  O   CYS    96      -0.277  51.752  46.841  1.00 32.93          
ATOM    765  N   CYS    97       0.717  51.478  44.853  1.00 32.89          
ATOM    766  CA  CYS    97      -0.045  52.538  44.202  1.00 33.12          
ATOM    767  CB  CYS    97       0.865  53.356  43.296  1.00 32.47          
ATOM    768  SG  CYS    97       2.281  53.974  44.196  1.00 39.10          
ATOM    769  C   CYS    97      -1.151  51.893  43.382  1.00 33.17          
ATOM    770  O   CYS    97      -0.903  51.348  42.298  1.00 31.81          
ATOM    771  N   LEU    98      -2.372  51.980  43.903  1.00 31.03          
ATOM    772  CA  LEU    98      -3.526  51.374  43.266  1.00 30.79          
ATOM    773  CB  LEU    98      -4.327  50.575  44.298  1.00 30.46          
ATOM    774  CG  LEU    98      -3.900  49.127  44.523  1.00 31.69          
ATOM    775  CD1 LEU    98      -2.470  49.060  45.042  1.00 33.03          
ATOM    776  CD2 LEU    98      -4.859  48.491  45.498  1.00 32.91          
ATOM    777  C   LEU    98      -4.482  52.282  42.521  1.00 32.04          
ATOM    778  O   LEU    98      -4.940  53.317  43.037  1.00 31.66          
ATOM    779  N   ASP    99      -4.773  51.860  41.293  1.00 29.79          
ATOM    780  CA  ASP    99      -5.712  52.531  40.427  1.00 29.72          
ATOM    781  CB  ASP    99      -7.072  52.604  41.128  1.00 29.36          
ATOM    782  CG  ASP    99      -8.213  52.739  40.159  1.00 29.17          
ATOM    783  OD1 ASP    99      -8.123  52.167  39.057  1.00 29.47          
ATOM    784  OD2 ASP    99      -9.206  53.408  40.497  1.00 32.53          
ATOM    785  C   ASP    99      -5.317  53.894  39.868  1.00 31.43          
ATOM    786  O   ASP    99      -6.175  54.721  39.545  1.00 30.39          
ATOM    787  N   PHE   100      -4.018  54.145  39.781  1.00 32.00          
ATOM    788  CA  PHE   100      -3.545  55.363  39.141  1.00 32.27          
ATOM    789  CB  PHE   100      -3.510  56.578  40.100  1.00 31.73          
ATOM    790  CG  PHE   100      -2.419  56.528  41.139  1.00 31.75          
ATOM    791  CD1 PHE   100      -2.607  55.846  42.334  1.00 30.17          
ATOM    792  CD2 PHE   100      -1.220  57.195  40.933  1.00 31.12          
ATOM    793  CE1 PHE   100      -1.615  55.831  43.315  1.00 30.63          
ATOM    794  CE2 PHE   100      -0.220  57.187  41.909  1.00 34.02          
ATOM    795  CZ  PHE   100      -0.420  56.501  43.106  1.00 30.26          
ATOM    796  C   PHE   100      -2.167  55.048  38.559  1.00 33.76          
ATOM    797  O   PHE   100      -1.455  54.163  39.052  1.00 32.82          
ATOM    798  N   ASN   101      -1.802  55.740  37.488  1.00 35.47          
ATOM    799  CA  ASN   101      -0.513  55.483  36.866  1.00 37.46          
ATOM    800  CB  ASN   101      -0.714  54.762  35.529  1.00 37.50          
ATOM    801  CG  ASN   101      -1.535  55.572  34.540  1.00 36.93          
ATOM    802  OD1 ASN   101      -1.809  56.748  34.755  1.00 39.46          
ATOM    803  ND2 ASN   101      -1.923  54.938  33.437  1.00 39.29          
ATOM    804  C   ASN   101       0.326  56.739  36.656  1.00 38.16          
ATOM    805  O   ASN   101       1.314  56.709  35.927  1.00 40.94          
ATOM    806  N   ALA   102      -0.060  57.834  37.302  1.00 37.53          
ATOM    807  CA  ALA   102       0.674  59.089  37.171  1.00 37.06          
ATOM    808  CB  ALA   102       0.153  59.877  35.980  1.00 38.93          
ATOM    809  C   ALA   102       0.524  59.898  38.452  1.00 37.20          
ATOM    810  O   ALA   102      -0.594  60.138  38.917  1.00 37.06          
ATOM    811  N   LEU   103       1.655  60.327  39.006  1.00 36.86          
ATOM    812  CA  LEU   103       1.671  61.075  40.255  1.00 36.56          
ATOM    813  CB  LEU   103       3.078  61.579  40.533  1.00 37.09          
ATOM    814  CG  LEU   103       4.120  60.496  40.805  1.00 39.01          
ATOM    815  CD1 LEU   103       5.517  61.083  40.651  1.00 39.86          
ATOM    816  CD2 LEU   103       3.909  59.927  42.191  1.00 37.66          
ATOM    817  C   LEU   103       0.692  62.235  40.350  1.00 37.82          
ATOM    818  O   LEU   103       0.283  62.602  41.447  1.00 38.03          
ATOM    819  N   LYS   104       0.309  62.814  39.217  1.00 37.38          
ATOM    820  CA  LYS   104      -0.629  63.927  39.242  1.00 39.02          
ATOM    821  CB  LYS   104      -0.715  64.609  37.876  1.00 39.65          
ATOM    822  CG  LYS   104      -1.176  63.721  36.744  1.00 41.55          
ATOM    823  CD  LYS   104      -1.295  64.535  35.463  1.00 45.19          
ATOM    824  CE  LYS   104      -1.074  63.682  34.227  1.00 45.32          
ATOM    825  NZ  LYS   104      -1.036  64.532  33.001  1.00 46.79          
ATOM    826  C   LYS   104      -2.007  63.448  39.654  1.00 38.14          
ATOM    827  O   LYS   104      -2.862  64.248  40.037  1.00 38.57          
ATOM    828  N   ARG   105      -2.221  62.138  39.573  1.00 36.45          
ATOM    829  CA  ARG   105      -3.498  61.561  39.963  1.00 34.98          
ATOM    830  CB  ARG   105      -3.636  60.128  39.418  1.00 35.72          
ATOM    831  CG  ARG   105      -3.792  60.040  37.891  1.00 35.17          
ATOM    832  CD  ARG   105      -5.049  60.774  37.432  1.00 33.44          
ATOM    833  NE  ARG   105      -6.260  60.214  38.036  1.00 33.96          
ATOM    834  CZ  ARG   105      -7.296  60.942  38.458  1.00 34.97          
ATOM    835  NH1 ARG   105      -7.270  62.268  38.351  1.00 33.45          
ATOM    836  NH2 ARG   105      -8.362  60.347  38.978  1.00 35.05          
ATOM    837  C   ARG   105      -3.685  61.562  41.478  1.00 34.78          
ATOM    838  O   ARG   105      -4.797  61.380  41.965  1.00 34.27          
ATOM    839  N   ILE   106      -2.606  61.772  42.226  1.00 33.67          
ATOM    840  CA  ILE   106      -2.735  61.806  43.675  1.00 36.15          
ATOM    841  CB  ILE   106      -1.778  60.823  44.379  1.00 34.05          
ATOM    842  CG2 ILE   106      -2.231  59.393  44.144  1.00 33.84          
ATOM    843  CG1 ILE   106      -0.358  60.983  43.853  1.00 33.37          
ATOM    844  CD  ILE   106       0.610  60.143  44.624  1.00 30.88          
ATOM    845  C   ILE   106      -2.641  63.198  44.311  1.00 38.43          
ATOM    846  O   ILE   106      -2.238  63.351  45.458  1.00 39.34          
ATOM    847  N   ASP   107      -3.000  64.207  43.524  1.00 40.16          
ATOM    848  CA  ASP   107      -3.129  65.602  43.971  1.00 41.70          
ATOM    849  CB  ASP   107      -4.611  65.901  44.055  1.00 42.91          
ATOM    850  CG  ASP   107      -5.046  67.003  43.158  1.00 45.25          
ATOM    851  OD1 ASP   107      -4.943  66.854  41.913  1.00 45.93          
ATOM    852  OD2 ASP   107      -5.532  68.019  43.717  1.00 41.75          
ATOM    853  C   ASP   107      -2.551  66.005  45.336  1.00 43.26          
ATOM    854  O   ASP   107      -3.274  65.930  46.336  1.00 42.06          
ATOM    855  N   GLU   108      -1.300  66.461  45.400  1.00 44.95          
ATOM    856  CA  GLU   108      -0.710  66.910  46.686  1.00 45.34          
ATOM    857  CB  GLU   108      -1.776  67.495  47.631  1.00 49.50          
ATOM    858  CG  GLU   108      -2.369  68.832  47.184  1.00 55.94          
ATOM    859  CD  GLU   108      -1.430  70.018  47.404  1.00 60.46          
ATOM    860  OE1 GLU   108      -0.344  70.060  46.781  1.00 60.93          
ATOM    861  OE2 GLU   108      -1.783  70.912  48.209  1.00 63.03          
ATOM    862  C   GLU   108       0.032  65.837  47.415  1.00 42.94          
ATOM    863  O   GLU   108       0.890  66.138  48.217  1.00 42.57          
ATOM    864  N   MET   109      -0.312  64.585  47.145  1.00 43.52          
ATOM    865  CA  MET   109       0.381  63.481  47.776  1.00 42.26          
ATOM    866  CB  MET   109      -0.523  62.253  47.862  1.00 42.58          
ATOM    867  CG  MET   109      -1.719  62.329  48.818  1.00 44.39          
ATOM    868  SD  MET   109      -2.490  60.556  49.010  0.84 47.67          
ATOM    869  CE  MET   109      -1.034  59.625  49.874  1.00 45.45          
ATOM    870  C   MET   109       1.613  63.142  46.942  1.00 41.67          
ATOM    871  O   MET   109       2.562  62.537  47.441  1.00 42.28          
ATOM    872  N   SER   110       1.606  63.547  45.673  1.00 40.59          
ATOM    873  CA  SER   110       2.712  63.234  44.768  1.00 41.10          
ATOM    874  CB  SER   110       2.546  64.005  43.448  1.00 41.33          
ATOM    875  OG  SER   110       2.156  65.336  43.681  1.00 47.73          
ATOM    876  C   SER   110       4.117  63.445  45.325  1.00 40.98          
ATOM    877  O   SER   110       4.978  62.580  45.172  1.00 40.69          
ATOM    878  N   ASP   111       4.352  64.583  45.965  1.00 41.29          
ATOM    879  CA  ASP   111       5.669  64.880  46.526  1.00 42.46          
ATOM    880  CB  ASP   111       5.650  66.244  47.199  1.00 45.19          
ATOM    881  CG  ASP   111       5.185  67.338  46.268  1.00 48.99          
ATOM    882  OD1 ASP   111       6.007  67.779  45.429  1.00 45.25          
ATOM    883  OD2 ASP   111       3.994  67.735  46.378  1.00 50.34          
ATOM    884  C   ASP   111       6.160  63.850  47.534  1.00 41.38          
ATOM    885  O   ASP   111       7.240  63.281  47.376  1.00 41.62          
ATOM    886  N   ILE   112       5.384  63.624  48.587  1.00 41.87          
ATOM    887  CA  ILE   112       5.781  62.655  49.611  1.00 41.89          
ATOM    888  CB  ILE   112       4.754  62.637  50.788  1.00 41.73          
ATOM    889  CG2 ILE   112       3.462  61.954  50.367  1.00 40.84          
ATOM    890  CG1 ILE   112       5.356  61.934  51.996  1.00 41.46          
ATOM    891  CD  ILE   112       6.499  62.697  52.605  1.00 44.60          
ATOM    892  C   ILE   112       5.944  61.235  49.021  1.00 40.88          
ATOM    893  O   ILE   112       6.907  60.530  49.345  1.00 41.92          
ATOM    894  N   VAL   113       5.017  60.822  48.153  1.00 39.40          
ATOM    895  CA  VAL   113       5.084  59.494  47.533  1.00 40.12          
ATOM    896  CB  VAL   113       3.843  59.192  46.653  1.00 39.76          
ATOM    897  CG1 VAL   113       4.052  57.879  45.906  1.00 38.38          
ATOM    898  CG2 VAL   113       2.590  59.113  47.508  1.00 37.65          
ATOM    899  C   VAL   113       6.313  59.372  46.647  1.00 40.75          
ATOM    900  O   VAL   113       6.992  58.343  46.644  1.00 41.48          
ATOM    901  N   ALA   114       6.596  60.424  45.890  1.00 40.29          
ATOM    902  CA  ALA   114       7.754  60.436  45.002  1.00 41.36          
ATOM    903  CB  ALA   114       7.740  61.694  44.152  1.00 38.78          
ATOM    904  C   ALA   114       9.073  60.352  45.767  1.00 41.98          
ATOM    905  O   ALA   114      10.003  59.671  45.335  1.00 43.70          
ATOM    906  N   ALA   115       9.142  61.041  46.903  1.00 43.36          
ATOM    907  CA  ALA   115      10.356  61.089  47.730  1.00 42.76          
ATOM    908  CB  ALA   115      10.329  62.332  48.600  1.00 43.26          
ATOM    909  C   ALA   115      10.606  59.875  48.612  1.00 42.28          
ATOM    910  O   ALA   115      11.755  59.539  48.893  1.00 43.94          
ATOM    911  N   SER   116       9.540  59.224  49.060  1.00 40.85          
ATOM    912  CA  SER   116       9.685  58.056  49.923  1.00 39.40          
ATOM    913  CB  SER   116       8.319  57.404  50.148  1.00 37.40          
ATOM    914  OG  SER   116       8.424  56.304  51.033  1.00 34.59          
ATOM    915  C   SER   116      10.666  57.021  49.356  1.00 39.21          
ATOM    916  O   SER   116      10.650  56.731  48.163  1.00 39.48          
ATOM    917  N   PRO   117      11.544  56.465  50.207  1.00 40.00          
ATOM    918  CD  PRO   117      11.852  56.888  51.587  1.00 39.39          
ATOM    919  CA  PRO   117      12.512  55.464  49.747  1.00 40.25          
ATOM    920  CB  PRO   117      13.641  55.594  50.756  1.00 41.57          
ATOM    921  CG  PRO   117      12.893  55.853  52.026  1.00 39.13          
ATOM    922  C   PRO   117      11.918  54.055  49.737  1.00 41.84          
ATOM    923  O   PRO   117      12.590  53.089  49.357  1.00 42.99          
ATOM    924  N   GLY   118      10.667  53.939  50.174  1.00 41.53          
ATOM    925  CA  GLY   118      10.006  52.646  50.191  1.00 40.70          
ATOM    926  C   GLY   118       9.884  52.077  48.789  1.00 40.90          
ATOM    927  O   GLY   118       9.941  52.813  47.807  1.00 40.91          
ATOM    928  N   ARG   119       9.724  50.759  48.698  1.00 42.48          
ATOM    929  CA  ARG   119       9.603  50.070  47.412  1.00 41.59          
ATOM    930  CB  ARG   119       9.887  48.580  47.598  1.00 44.27          
ATOM    931  CG  ARG   119      11.267  48.273  48.167  1.00 47.89          
ATOM    932  CD  ARG   119      11.352  46.824  48.645  1.00 53.75          
ATOM    933  NE  ARG   119      12.674  46.475  49.166  1.00 59.27          
ATOM    934  CZ  ARG   119      13.784  46.429  48.431  1.00 62.74          
ATOM    935  NH1 ARG   119      13.741  46.708  47.132  1.00 65.21          
ATOM    936  NH2 ARG   119      14.944  46.106  48.992  1.00 64.67          
ATOM    937  C   ARG   119       8.203  50.271  46.837  1.00 39.36          
ATOM    938  O   ARG   119       7.214  49.853  47.431  1.00 39.59          
ATOM    939  N   LYS   120       8.126  50.905  45.674  1.00 38.87          
ATOM    940  CA  LYS   120       6.840  51.183  45.044  1.00 37.65          
ATOM    941  CB  LYS   120       6.851  52.586  44.436  1.00 38.03          
ATOM    942  CG  LYS   120       7.350  53.686  45.353  1.00 37.98          
ATOM    943  CD  LYS   120       7.439  55.003  44.594  1.00 38.64          
ATOM    944  CE  LYS   120       8.096  56.100  45.419  1.00 39.68          
ATOM    945  NZ  LYS   120       9.497  55.767  45.766  1.00 39.24          
ATOM    946  C   LYS   120       6.421  50.191  43.956  1.00 37.15          
ATOM    947  O   LYS   120       7.229  49.759  43.129  1.00 36.54          
ATOM    948  N   ILE   121       5.143  49.843  43.964  1.00 34.69          
ATOM    949  CA  ILE   121       4.593  48.948  42.967  1.00 34.40          
ATOM    950  CB  ILE   121       4.360  47.517  43.511  1.00 34.24          
ATOM    951  CG2 ILE   121       3.529  47.559  44.780  1.00 32.10          
ATOM    952  CG1 ILE   121       3.668  46.666  42.436  1.00 34.61          
ATOM    953  CD  ILE   121       3.506  45.188  42.813  1.00 37.44          
ATOM    954  C   ILE   121       3.267  49.524  42.519  1.00 34.74          
ATOM    955  O   ILE   121       2.475  49.984  43.332  1.00 34.93          
ATOM    956  N   MET   122       3.038  49.504  41.215  1.00 35.73          
ATOM    957  CA  MET   122       1.809  50.020  40.647  1.00 34.81          
ATOM    958  CB  MET   122       2.145  50.871  39.429  1.00 35.89          
ATOM    959  CG  MET   122       0.944  51.487  38.740  1.00 40.74          
ATOM    960  SD  MET   122       1.355  52.204  36.975  0.76 44.96          
ATOM    961  CE  MET   122       0.561  50.811  35.944  1.00 46.12          
ATOM    962  C   MET   122       0.906  48.850  40.241  1.00 35.35          
ATOM    963  O   MET   122       1.385  47.855  39.715  1.00 35.95          
ATOM    964  N   ILE   123      -0.393  48.966  40.528  1.00 33.83          
ATOM    965  CA  ILE   123      -1.399  47.958  40.170  1.00 31.28          
ATOM    966  CB  ILE   123      -1.914  47.186  41.388  1.00 31.28          
ATOM    967  CG2 ILE   123      -2.907  46.112  40.926  1.00 33.86          
ATOM    968  CG1 ILE   123      -0.751  46.501  42.095  1.00 30.43          
ATOM    969  CD  ILE   123      -1.159  45.642  43.263  1.00 31.93          
ATOM    970  C   ILE   123      -2.514  48.816  39.599  1.00 30.35          
ATOM    971  O   ILE   123      -3.287  49.444  40.335  1.00 27.53          
ATOM    972  N   ASP   124      -2.606  48.829  38.278  1.00 30.16          
ATOM    973  CA  ASP   124      -3.539  49.713  37.623  1.00 29.64          
ATOM    974  CB  ASP   124      -2.828  51.055  37.490  1.00 30.77          
ATOM    975  CG  ASP   124      -3.674  52.096  36.854  1.00 33.01          
ATOM    976  OD1 ASP   124      -4.808  52.288  37.337  1.00 36.00          
ATOM    977  OD2 ASP   124      -3.196  52.721  35.884  1.00 33.84          
ATOM    978  C   ASP   124      -3.990  49.225  36.253  1.00 28.95          
ATOM    979  O   ASP   124      -3.320  48.405  35.626  1.00 30.32          
ATOM    980  N   HSD   125      -5.112  49.750  35.777  1.00 28.69          
ATOM    981  CA  HSD   125      -5.613  49.364  34.460  1.00 31.58          
ATOM    982  CB  HSD   125      -6.906  48.538  34.586  1.00 31.91          
ATOM    983  CG  HSD   125      -8.144  49.366  34.696  1.00 35.24          
ATOM    984  CD2 HSD   125      -9.170  49.544  33.833  1.00 36.10          
ATOM    985  ND1 HSD   125      -8.406  50.180  35.778  1.00 36.82          
ATOM    986  CE1 HSD   125      -9.538  50.825  35.574  1.00 38.66          
ATOM    987  NE2 HSD   125     -10.022  50.457  34.400  1.00 37.88          
ATOM    988  C   HSD   125      -5.855  50.565  33.528  1.00 30.90          
ATOM    989  O   HSD   125      -6.551  50.435  32.526  1.00 30.56          
ATOM    990  N   HSD   126      -5.281  51.725  33.853  1.00 29.49          
ATOM    991  CA  HSD   126      -5.435  52.913  33.007  1.00 31.03          
ATOM    992  CB  HSD   126      -5.311  54.188  33.851  1.00 31.51          
ATOM    993  CG  HSD   126      -6.409  54.348  34.858  1.00 34.84          
ATOM    994  CD2 HSD   126      -6.517  53.910  36.137  1.00 31.69          
ATOM    995  ND1 HSD   126      -7.620  54.930  34.551  1.00 34.35          
ATOM    996  CE1 HSD   126      -8.431  54.836  35.593  1.00 33.45          
ATOM    997  NE2 HSD   126      -7.786  54.219  36.568  1.00 33.01          
ATOM    998  C   HSD   126      -4.374  52.922  31.890  1.00 30.40          
ATOM    999  O   HSD   126      -3.332  52.275  32.014  1.00 29.46          
ATOM   1000  N   LEU   127      -4.637  53.652  30.807  1.00 29.08          
ATOM   1001  CA  LEU   127      -3.685  53.715  29.706  1.00 31.21          
ATOM   1002  CB  LEU   127      -4.393  54.030  28.373  1.00 30.35          
ATOM   1003  CG  LEU   127      -5.225  52.907  27.732  1.00 31.41          
ATOM   1004  CD1 LEU   127      -6.582  52.774  28.439  1.00 32.99          
ATOM   1005  CD2 LEU   127      -5.445  53.207  26.260  1.00 32.55          
ATOM   1006  C   LEU   127      -2.588  54.747  29.947  1.00 32.73          
ATOM   1007  O   LEU   127      -2.792  55.736  30.656  1.00 34.88          
ATOM   1008  N   TYR   128      -1.416  54.483  29.372  1.00 32.88          
ATOM   1009  CA  TYR   128      -0.261  55.383  29.453  1.00 31.90          
ATOM   1010  CB  TYR   128      -0.656  56.743  28.855  1.00 28.60          
ATOM   1011  CG  TYR   128      -1.486  56.627  27.592  1.00 29.14          
ATOM   1012  CD1 TYR   128      -1.077  55.813  26.532  1.00 29.87          
ATOM   1013  CE1 TYR   128      -1.858  55.692  25.366  1.00 27.90          
ATOM   1014  CD2 TYR   128      -2.686  57.319  27.456  1.00 27.85          
ATOM   1015  CE2 TYR   128      -3.464  57.211  26.302  1.00 23.10          
ATOM   1016  CZ  TYR   128      -3.051  56.400  25.270  1.00 26.65          
ATOM   1017  OH  TYR   128      -3.845  56.272  24.144  1.00 27.76          
ATOM   1018  C   TYR   128       0.328  55.587  30.854  1.00 32.36          
ATOM   1019  O   TYR   128       0.273  56.684  31.398  1.00 34.11          
ATOM   1020  N   PRO   129       0.937  54.546  31.439  1.00 32.76          
ATOM   1021  CD  PRO   129       1.108  53.189  30.886  1.00 31.40          
ATOM   1022  CA  PRO   129       1.527  54.637  32.781  1.00 34.04          
ATOM   1023  CB  PRO   129       1.650  53.179  33.178  1.00 34.12          
ATOM   1024  CG  PRO   129       2.075  52.554  31.863  1.00 30.03          
ATOM   1025  C   PRO   129       2.891  55.340  32.833  1.00 36.66          
ATOM   1026  O   PRO   129       3.653  55.264  31.879  1.00 36.19          
ATOM   1027  N   GLU   130       3.197  56.006  33.948  1.00 39.16          
ATOM   1028  CA  GLU   130       4.490  56.680  34.106  1.00 42.62          
ATOM   1029  CB  GLU   130       4.390  57.898  35.033  1.00 42.55          
ATOM   1030  CG  GLU   130       3.254  58.866  34.735  1.00 45.87          
ATOM   1031  CD  GLU   130       3.425  60.225  35.429  1.00 48.32          
ATOM   1032  OE1 GLU   130       3.887  60.263  36.597  1.00 47.97          
ATOM   1033  OE2 GLU   130       3.082  61.259  34.804  1.00 48.19          
ATOM   1034  C   GLU   130       5.427  55.648  34.732  1.00 43.40          
ATOM   1035  O   GLU   130       4.978  54.593  35.165  1.00 43.98          
ATOM   1036  N   ASP   131       6.718  55.939  34.800  1.00 46.61          
ATOM   1037  CA  ASP   131       7.646  54.971  35.382  1.00 49.52          
ATOM   1038  CB  ASP   131       8.840  54.754  34.440  1.00 53.09          
ATOM   1039  CG  ASP   131       9.697  56.006  34.281  1.00 59.72          
ATOM   1040  OD1 ASP   131      10.129  56.564  35.313  1.00 62.44          
ATOM   1041  OD2 ASP   131       9.947  56.431  33.129  1.00 62.89          
ATOM   1042  C   ASP   131       8.167  55.313  36.780  1.00 48.22          
ATOM   1043  O   ASP   131       9.329  55.046  37.079  1.00 49.85          
ATOM   1044  N   PHE   132       7.335  55.883  37.646  1.00 46.63          
ATOM   1045  CA  PHE   132       7.814  56.209  38.991  1.00 45.41          
ATOM   1046  CB  PHE   132       6.996  57.354  39.620  1.00 42.93          
ATOM   1047  CG  PHE   132       5.541  57.033  39.830  1.00 43.16          
ATOM   1048  CD1 PHE   132       4.606  57.282  38.828  1.00 41.40          
ATOM   1049  CD2 PHE   132       5.109  56.456  41.026  1.00 41.30          
ATOM   1050  CE1 PHE   132       3.261  56.959  39.013  1.00 42.87          
ATOM   1051  CE2 PHE   132       3.768  56.128  41.219  1.00 41.84          
ATOM   1052  CZ  PHE   132       2.840  56.379  40.211  1.00 42.28          
ATOM   1053  C   PHE   132       7.847  55.002  39.941  1.00 45.62          
ATOM   1054  O   PHE   132       8.362  55.102  41.053  1.00 46.69          
ATOM   1055  N   CYS   133       7.310  53.863  39.510  1.00 45.46          
ATOM   1056  CA  CYS   133       7.320  52.663  40.345  1.00 45.11          
ATOM   1057  CB  CYS   133       5.949  51.987  40.344  1.00 44.69          
ATOM   1058  SG  CYS   133       4.654  52.944  41.162  1.00 45.03          
ATOM   1059  C   CYS   133       8.374  51.680  39.851  1.00 46.08          
ATOM   1060  O   CYS   133       8.686  51.643  38.663  1.00 46.16          
ATOM   1061  N   ARG   134       8.915  50.887  40.771  1.00 48.10          
ATOM   1062  CA  ARG   134       9.945  49.901  40.446  1.00 50.01          
ATOM   1063  CB  ARG   134      10.746  49.547  41.705  1.00 52.85          
ATOM   1064  CG  ARG   134      11.745  48.412  41.533  1.00 59.74          
ATOM   1065  CD  ARG   134      12.873  48.755  40.562  1.00 65.44          
ATOM   1066  NE  ARG   134      13.905  47.713  40.521  1.00 69.14          
ATOM   1067  CZ  ARG   134      13.760  46.518  39.947  1.00 71.05          
ATOM   1068  NH1 ARG   134      12.620  46.189  39.348  1.00 71.80          
ATOM   1069  NH2 ARG   134      14.758  45.642  39.979  1.00 70.72          
ATOM   1070  C   ARG   134       9.330  48.642  39.837  1.00 49.12          
ATOM   1071  O   ARG   134       9.962  47.959  39.031  1.00 50.77          
ATOM   1072  N   ILE   135       8.106  48.327  40.245  1.00 46.06          
ATOM   1073  CA  ILE   135       7.385  47.179  39.707  1.00 43.55          
ATOM   1074  CB  ILE   135       7.039  46.141  40.776  1.00 41.87          
ATOM   1075  CG2 ILE   135       6.199  45.018  40.149  1.00 39.89          
ATOM   1076  CG1 ILE   135       8.322  45.578  41.385  1.00 40.13          
ATOM   1077  CD  ILE   135       8.085  44.541  42.459  1.00 39.37          
ATOM   1078  C   ILE   135       6.090  47.720  39.133  1.00 43.45          
ATOM   1079  O   ILE   135       5.272  48.305  39.855  1.00 43.77          
ATOM   1080  N   THR   136       5.904  47.528  37.834  1.00 42.66          
ATOM   1081  CA  THR   136       4.715  48.033  37.178  1.00 42.58          
ATOM   1082  CB  THR   136       5.086  48.970  36.039  1.00 41.52          
ATOM   1083  OG1 THR   136       5.927  50.013  36.545  1.00 41.82          
ATOM   1084  CG2 THR   136       3.834  49.568  35.419  1.00 39.61          
ATOM   1085  C   THR   136       3.797  46.958  36.626  1.00 42.96          
ATOM   1086  O   THR   136       4.196  46.156  35.784  1.00 42.81          
ATOM   1087  N   ILE   137       2.566  46.949  37.124  1.00 40.95          
ATOM   1088  CA  ILE   137       1.561  46.011  36.675  1.00 40.86          
ATOM   1089  CB  ILE   137       0.998  45.198  37.862  1.00 40.06          
ATOM   1090  CG2 ILE   137      -0.183  44.329  37.414  1.00 38.42          
ATOM   1091  CG1 ILE   137       2.121  44.331  38.445  1.00 39.32          
ATOM   1092  CD  ILE   137       1.709  43.459  39.623  1.00 38.28          
ATOM   1093  C   ILE   137       0.491  46.888  36.038  1.00 42.00          
ATOM   1094  O   ILE   137      -0.404  47.388  36.718  1.00 41.71          
ATOM   1095  N   SER   138       0.617  47.092  34.727  1.00 41.73          
ATOM   1096  CA  SER   138      -0.301  47.928  33.960  1.00 40.12          
ATOM   1097  CB  SER   138       0.473  49.058  33.289  1.00 39.40          
ATOM   1098  OG  SER   138      -0.377  49.875  32.507  1.00 40.81          
ATOM   1099  C   SER   138      -1.017  47.115  32.892  1.00 39.45          
ATOM   1100  O   SER   138      -0.428  46.762  31.868  1.00 40.12          
ATOM   1101  N   HSD   139      -2.292  46.827  33.120  1.00 38.65          
ATOM   1102  CA  HSD   139      -3.065  46.046  32.165  1.00 35.52          
ATOM   1103  CB  HSD   139      -3.338  44.665  32.764  1.00 37.65          
ATOM   1104  CG  HSD   139      -2.094  43.855  32.959  1.00 41.43          
ATOM   1105  CD2 HSD   139      -1.222  43.797  33.993  1.00 40.77          
ATOM   1106  ND1 HSD   139      -1.568  43.052  31.968  1.00 42.62          
ATOM   1107  CE1 HSD   139      -0.424  42.536  32.384  1.00 42.79          
ATOM   1108  NE2 HSD   139      -0.191  42.974  33.609  1.00 43.31          
ATOM   1109  C   HSD   139      -4.353  46.745  31.769  1.00 33.08          
ATOM   1110  O   HSD   139      -5.414  46.463  32.303  1.00 33.78          
ATOM   1111  N   PRO   140      -4.266  47.682  30.813  1.00 33.88          
ATOM   1112  CD  PRO   140      -3.041  48.126  30.117  1.00 30.46          
ATOM   1113  CA  PRO   140      -5.436  48.431  30.343  1.00 31.77          
ATOM   1114  CB  PRO   140      -4.843  49.407  29.328  1.00 33.32          
ATOM   1115  CG  PRO   140      -3.375  49.537  29.777  1.00 32.83          
ATOM   1116  C   PRO   140      -6.502  47.526  29.720  1.00 32.09          
ATOM   1117  O   PRO   140      -7.644  47.937  29.548  1.00 32.78          
ATOM   1118  N   GLU   141      -6.140  46.291  29.394  1.00 31.69          
ATOM   1119  CA  GLU   141      -7.117  45.387  28.805  1.00 32.14          
ATOM   1120  CB  GLU   141      -6.431  44.261  28.002  1.00 31.60          
ATOM   1121  CG  GLU   141      -5.774  43.165  28.832  1.00 31.70          
ATOM   1122  CD  GLU   141      -4.429  43.558  29.395  1.00 35.06          
ATOM   1123  OE1 GLU   141      -4.058  44.749  29.310  1.00 32.08          
ATOM   1124  OE2 GLU   141      -3.742  42.663  29.933  1.00 35.70          
ATOM   1125  C   GLU   141      -8.005  44.798  29.895  1.00 32.30          
ATOM   1126  O   GLU   141      -8.976  44.106  29.607  1.00 34.39          
ATOM   1127  N   ILE   142      -7.677  45.057  31.155  1.00 30.77          
ATOM   1128  CA  ILE   142      -8.514  44.545  32.239  1.00 29.25          
ATOM   1129  CB  ILE   142      -7.650  44.083  33.428  1.00 30.81          
ATOM   1130  CG2 ILE   142      -8.536  43.641  34.600  1.00 33.11          
ATOM   1131  CG1 ILE   142      -6.788  42.901  32.986  1.00 30.46          
ATOM   1132  CD  ILE   142      -7.606  41.660  32.561  1.00 27.12          
ATOM   1133  C   ILE   142      -9.462  45.686  32.623  1.00 28.20          
ATOM   1134  O   ILE   142      -9.048  46.840  32.680  1.00 27.30          
ATOM   1135  N   SER   143     -10.729  45.366  32.863  1.00 27.62          
ATOM   1136  CA  SER   143     -11.717  46.391  33.165  1.00 26.90          
ATOM   1137  CB  SER   143     -13.140  45.849  32.917  1.00 26.26          
ATOM   1138  OG  SER   143     -13.434  44.731  33.724  1.00 30.18          
ATOM   1139  C   SER   143     -11.637  47.092  34.527  1.00 26.94          
ATOM   1140  O   SER   143     -12.240  48.141  34.702  1.00 27.12          
ATOM   1141  N   SER   144     -10.904  46.548  35.489  1.00 26.93          
ATOM   1142  CA  SER   144     -10.782  47.247  36.771  1.00 25.34          
ATOM   1143  CB  SER   144     -12.004  46.978  37.668  1.00 23.94          
ATOM   1144  OG  SER   144     -12.124  45.606  38.003  1.00 24.96          
ATOM   1145  C   SER   144      -9.501  46.904  37.527  1.00 26.87          
ATOM   1146  O   SER   144      -8.832  45.918  37.219  1.00 28.73          
ATOM   1147  N   THR   145      -9.155  47.741  38.505  1.00 27.42          
ATOM   1148  CA  THR   145      -7.973  47.528  39.320  1.00 25.33          
ATOM   1149  CB  THR   145      -7.547  48.838  40.050  1.00 25.77          
ATOM   1150  OG1 THR   145      -7.239  49.837  39.072  1.00 25.47          
ATOM   1151  CG2 THR   145      -6.303  48.615  40.903  1.00 22.85          
ATOM   1152  C   THR   145      -8.323  46.454  40.329  1.00 26.01          
ATOM   1153  O   THR   145      -7.481  45.631  40.678  1.00 26.72          
ATOM   1154  N   SER   146      -9.572  46.464  40.792  1.00 27.09          
ATOM   1155  CA  SER   146     -10.048  45.481  41.751  1.00 27.15          
ATOM   1156  CB  SER   146     -11.557  45.636  41.991  1.00 28.82          
ATOM   1157  OG  SER   146     -11.867  46.839  42.664  1.00 29.92          
ATOM   1158  C   SER   146      -9.768  44.075  41.233  1.00 28.82          
ATOM   1159  O   SER   146      -9.333  43.197  41.985  1.00 30.47          
ATOM   1160  N   GLU   147     -10.018  43.860  39.946  1.00 30.06          
ATOM   1161  CA  GLU   147      -9.782  42.553  39.343  1.00 30.37          
ATOM   1162  CB  GLU   147     -10.334  42.509  37.912  1.00 30.53          
ATOM   1163  CG  GLU   147     -10.335  41.113  37.306  1.00 33.77          
ATOM   1164  CD  GLU   147     -10.665  41.085  35.809  1.00 33.91          
ATOM   1165  OE1 GLU   147     -11.543  41.845  35.351  1.00 35.36          
ATOM   1166  OE2 GLU   147     -10.050  40.279  35.089  1.00 33.44          
ATOM   1167  C   GLU   147      -8.284  42.204  39.326  1.00 30.28          
ATOM   1168  O   GLU   147      -7.912  41.041  39.500  1.00 27.29          
ATOM   1169  N   LEU   148      -7.426  43.199  39.103  1.00 28.62          
ATOM   1170  CA  LEU   148      -5.989  42.932  39.080  1.00 28.85          
ATOM   1171  CB  LEU   148      -5.209  44.137  38.556  1.00 28.47          
ATOM   1172  CG  LEU   148      -5.443  44.507  37.096  1.00 28.28          
ATOM   1173  CD1 LEU   148      -4.612  45.725  36.763  1.00 25.29          
ATOM   1174  CD2 LEU   148      -5.064  43.336  36.182  1.00 28.72          
ATOM   1175  C   LEU   148      -5.497  42.587  40.473  1.00 30.09          
ATOM   1176  O   LEU   148      -4.572  41.790  40.629  1.00 32.18          
ATOM   1177  N   VAL   149      -6.099  43.206  41.485  1.00 30.23          
ATOM   1178  CA  VAL   149      -5.718  42.932  42.866  1.00 27.30          
ATOM   1179  CB  VAL   149      -6.412  43.912  43.838  1.00 26.59          
ATOM   1180  CG1 VAL   149      -6.318  43.412  45.273  1.00 21.56          
ATOM   1181  CG2 VAL   149      -5.757  45.275  43.725  1.00 24.42          
ATOM   1182  C   VAL   149      -6.120  41.498  43.176  1.00 28.80          
ATOM   1183  O   VAL   149      -5.363  40.756  43.814  1.00 29.24          
ATOM   1184  N   PHE   150      -7.311  41.107  42.718  1.00 27.36          
ATOM   1185  CA  PHE   150      -7.796  39.747  42.925  1.00 26.97          
ATOM   1186  CB  PHE   150      -9.215  39.577  42.369  1.00 25.53          
ATOM   1187  CG  PHE   150      -9.750  38.169  42.489  1.00 27.27          
ATOM   1188  CD1 PHE   150      -9.523  37.233  41.487  1.00 28.90          
ATOM   1189  CD2 PHE   150     -10.449  37.772  43.629  1.00 28.85          
ATOM   1190  CE1 PHE   150      -9.983  35.912  41.617  1.00 31.04          
ATOM   1191  CE2 PHE   150     -10.911  36.462  43.777  1.00 29.05          
ATOM   1192  CZ  PHE   150     -10.676  35.526  42.765  1.00 31.17          
ATOM   1193  C   PHE   150      -6.858  38.753  42.236  1.00 28.65          
ATOM   1194  O   PHE   150      -6.441  37.762  42.832  1.00 28.46          
ATOM   1195  N   ARG   151      -6.539  39.014  40.976  1.00 27.60          
ATOM   1196  CA  ARG   151      -5.643  38.140  40.230  1.00 31.06          
ATOM   1197  CB  ARG   151      -5.444  38.675  38.803  1.00 28.29          
ATOM   1198  CG  ARG   151      -6.618  38.410  37.866  1.00 28.51          
ATOM   1199  CD  ARG   151      -6.486  39.198  36.554  1.00 31.13          
ATOM   1200  NE  ARG   151      -6.677  38.341  35.395  1.00 38.81          
ATOM   1201  CZ  ARG   151      -7.835  37.785  35.069  1.00 40.64          
ATOM   1202  NH1 ARG   151      -8.903  38.009  35.812  1.00 46.24          
ATOM   1203  NH2 ARG   151      -7.923  36.991  34.021  1.00 41.74          
ATOM   1204  C   ARG   151      -4.284  37.995  40.932  1.00 32.68          
ATOM   1205  O   ARG   151      -3.804  36.871  41.155  1.00 32.34          
ATOM   1206  N   LEU   152      -3.671  39.124  41.290  1.00 32.29          
ATOM   1207  CA  LEU   152      -2.367  39.097  41.954  1.00 33.82          
ATOM   1208  CB  LEU   152      -1.908  40.521  42.288  1.00 32.12          
ATOM   1209  CG  LEU   152      -0.630  40.682  43.125  1.00 32.33          
ATOM   1210  CD1 LEU   152       0.568  40.028  42.440  1.00 32.89          
ATOM   1211  CD2 LEU   152      -0.375  42.163  43.340  1.00 31.94          
ATOM   1212  C   LEU   152      -2.360  38.246  43.224  1.00 35.91          
ATOM   1213  O   LEU   152      -1.471  37.414  43.419  1.00 36.37          
ATOM   1214  N   ILE   153      -3.353  38.450  44.084  1.00 35.44          
ATOM   1215  CA  ILE   153      -3.432  37.695  45.323  1.00 33.78          
ATOM   1216  CB  ILE   153      -4.588  38.201  46.214  1.00 31.87          
ATOM   1217  CG2 ILE   153      -4.717  37.329  47.429  1.00 28.22          
ATOM   1218  CG1 ILE   153      -4.347  39.660  46.619  1.00 31.24          
ATOM   1219  CD  ILE   153      -5.524  40.288  47.356  1.00 31.56          
ATOM   1220  C   ILE   153      -3.632  36.209  45.033  1.00 34.72          
ATOM   1221  O   ILE   153      -3.121  35.356  45.750  1.00 33.97          
ATOM   1222  N   CYS   154      -4.377  35.903  43.977  1.00 36.23          
ATOM   1223  CA  CYS   154      -4.611  34.517  43.615  1.00 38.23          
ATOM   1224  CB  CYS   154      -5.744  34.429  42.596  1.00 41.01          
ATOM   1225  SG  CYS   154      -6.173  32.739  42.146  1.00 54.00          
ATOM   1226  C   CYS   154      -3.324  33.879  43.060  1.00 37.49          
ATOM   1227  O   CYS   154      -2.929  32.788  43.483  1.00 36.13          
ATOM   1228  N   ARG   155      -2.659  34.565  42.132  1.00 36.33          
ATOM   1229  CA  ARG   155      -1.417  34.048  41.562  1.00 35.61          
ATOM   1230  CB  ARG   155      -0.844  35.021  40.519  1.00 33.86          
ATOM   1231  CG  ARG   155      -1.609  35.078  39.193  1.00 34.43          
ATOM   1232  CD  ARG   155      -1.363  33.851  38.310  1.00 31.75          
ATOM   1233  NE  ARG   155       0.003  33.828  37.796  1.00 33.62          
ATOM   1234  CZ  ARG   155       0.454  34.622  36.831  1.00 35.35          
ATOM   1235  NH1 ARG   155      -0.362  35.499  36.260  1.00 33.15          
ATOM   1236  NH2 ARG   155       1.732  34.567  36.464  1.00 33.38          
ATOM   1237  C   ARG   155      -0.369  33.788  42.648  1.00 36.02          
ATOM   1238  O   ARG   155       0.470  32.903  42.494  1.00 39.16          
ATOM   1239  N   MET   156      -0.423  34.553  43.738  1.00 34.62          
ATOM   1240  CA  MET   156       0.521  34.409  44.855  1.00 34.40          
ATOM   1241  CB  MET   156       0.517  35.669  45.737  1.00 36.57          
ATOM   1242  CG  MET   156       1.217  36.881  45.136  1.00 37.44          
ATOM   1243  SD  MET   156       0.901  38.494  46.176  0.76 46.32          
ATOM   1244  CE  MET   156       2.223  38.222  47.573  1.00 46.33          
ATOM   1245  C   MET   156       0.182  33.197  45.717  1.00 34.41          
ATOM   1246  O   MET   156       0.914  32.872  46.655  1.00 33.86          
ATOM   1247  N   GLY   157      -0.935  32.547  45.393  1.00 33.63          
ATOM   1248  CA  GLY   157      -1.372  31.365  46.118  1.00 33.45          
ATOM   1249  C   GLY   157      -2.242  31.628  47.334  1.00 35.54          
ATOM   1250  O   GLY   157      -2.565  30.703  48.085  1.00 34.63          
ATOM   1251  N   TYR   158      -2.657  32.878  47.521  1.00 35.38          
ATOM   1252  CA  TYR   158      -3.453  33.225  48.694  1.00 34.82          
ATOM   1253  CB  TYR   158      -2.889  34.498  49.318  1.00 35.06          
ATOM   1254  CG  TYR   158      -1.497  34.327  49.865  1.00 36.35          
ATOM   1255  CD1 TYR   158      -1.284  33.710  51.096  1.00 38.52          
ATOM   1256  CE1 TYR   158       0.007  33.550  51.612  1.00 38.11          
ATOM   1257  CD2 TYR   158      -0.387  34.777  49.151  1.00 39.02          
ATOM   1258  CE2 TYR   158       0.906  34.619  49.654  1.00 39.49          
ATOM   1259  CZ  TYR   158       1.088  34.008  50.888  1.00 38.91          
ATOM   1260  OH  TYR   158       2.344  33.889  51.417  1.00 39.72          
ATOM   1261  C   TYR   158      -4.954  33.378  48.516  1.00 33.74          
ATOM   1262  O   TYR   158      -5.587  34.119  49.259  1.00 33.16          
ATOM   1263  N   PHE   159      -5.529  32.681  47.546  1.00 34.83          
ATOM   1264  CA  PHE   159      -6.963  32.773  47.330  1.00 35.85          
ATOM   1265  CB  PHE   159      -7.412  31.763  46.283  1.00 35.40          
ATOM   1266  CG  PHE   159      -8.901  31.723  46.083  1.00 34.82          
ATOM   1267  CD1 PHE   159      -9.571  32.815  45.543  1.00 34.98          
ATOM   1268  CD2 PHE   159      -9.633  30.589  46.425  1.00 34.12          
ATOM   1269  CE1 PHE   159     -10.952  32.784  45.341  1.00 36.22          
ATOM   1270  CE2 PHE   159     -11.010  30.543  46.229  1.00 34.96          
ATOM   1271  CZ  PHE   159     -11.676  31.648  45.682  1.00 37.47          
ATOM   1272  C   PHE   159      -7.728  32.502  48.615  1.00 38.04          
ATOM   1273  O   PHE   159      -8.736  33.160  48.892  1.00 38.13          
ATOM   1274  N   SER   160      -7.247  31.520  49.381  1.00 38.62          
ATOM   1275  CA  SER   160      -7.875  31.103  50.632  1.00 39.13          
ATOM   1276  CB  SER   160      -7.184  29.845  51.180  1.00 39.98          
ATOM   1277  OG  SER   160      -5.814  30.098  51.474  1.00 43.49          
ATOM   1278  C   SER   160      -7.877  32.178  51.706  1.00 37.85          
ATOM   1279  O   SER   160      -8.691  32.144  52.623  1.00 38.58          
ATOM   1280  N   ASP   161      -6.967  33.130  51.592  1.00 36.87          
ATOM   1281  CA  ASP   161      -6.880  34.197  52.568  1.00 36.59          
ATOM   1282  CB  ASP   161      -5.418  34.565  52.800  1.00 38.61          
ATOM   1283  CG  ASP   161      -4.653  33.452  53.485  1.00 39.71          
ATOM   1284  OD1 ASP   161      -5.237  32.818  54.382  1.00 42.10          
ATOM   1285  OD2 ASP   161      -3.478  33.217  53.140  1.00 42.01          
ATOM   1286  C   ASP   161      -7.683  35.437  52.197  1.00 36.21          
ATOM   1287  O   ASP   161      -7.527  36.493  52.811  1.00 35.70          
ATOM   1288  N   ILE   162      -8.526  35.323  51.177  1.00 34.45          
ATOM   1289  CA  ILE   162      -9.357  36.449  50.801  1.00 34.28          
ATOM   1290  CB  ILE   162      -9.661  36.480  49.290  1.00 35.57          
ATOM   1291  CG2 ILE   162     -10.737  37.549  48.993  1.00 33.75          
ATOM   1292  CG1 ILE   162      -8.382  36.779  48.507  1.00 32.37          
ATOM   1293  CD  ILE   162      -8.606  36.843  47.010  1.00 34.07          
ATOM   1294  C   ILE   162     -10.643  36.231  51.575  1.00 34.63          
ATOM   1295  O   ILE   162     -11.358  35.252  51.336  1.00 36.27          
ATOM   1296  N   SER   163     -10.919  37.131  52.517  1.00 32.02          
ATOM   1297  CA  SER   163     -12.109  37.033  53.354  1.00 32.47          
ATOM   1298  CB  SER   163     -11.888  37.791  54.661  1.00 33.83          
ATOM   1299  OG  SER   163     -11.709  39.181  54.405  1.00 36.56          
ATOM   1300  C   SER   163     -13.365  37.571  52.691  1.00 33.22          
ATOM   1301  O   SER   163     -13.316  38.208  51.639  1.00 35.63          
ATOM   1302  N   LYS   164     -14.500  37.314  53.330  1.00 33.29          
ATOM   1303  CA  LYS   164     -15.790  37.775  52.836  1.00 31.81          
ATOM   1304  CB  LYS   164     -16.868  37.373  53.848  1.00 32.57          
ATOM   1305  CG  LYS   164     -18.249  37.972  53.654  1.00 35.91          
ATOM   1306  CD  LYS   164     -19.034  37.792  54.944  1.00 40.37          
ATOM   1307  CE  LYS   164     -20.389  38.464  54.912  1.00 43.39          
ATOM   1308  NZ  LYS   164     -21.300  37.812  53.938  1.00 47.82          
ATOM   1309  C   LYS   164     -15.744  39.297  52.647  1.00 31.13          
ATOM   1310  O   LYS   164     -16.244  39.837  51.648  1.00 30.93          
ATOM   1311  N   GLU   165     -15.121  39.982  53.598  1.00 28.88          
ATOM   1312  CA  GLU   165     -15.008  41.437  53.549  1.00 28.11          
ATOM   1313  CB  GLU   165     -14.474  41.969  54.876  1.00 27.66          
ATOM   1314  CG  GLU   165     -15.364  41.596  56.045  1.00 31.07          
ATOM   1315  CD  GLU   165     -15.002  42.330  57.318  1.00 35.55          
ATOM   1316  OE1 GLU   165     -13.816  42.703  57.474  1.00 38.37          
ATOM   1317  OE2 GLU   165     -15.900  42.525  58.170  1.00 38.76          
ATOM   1318  C   GLU   165     -14.124  41.893  52.407  1.00 27.22          
ATOM   1319  O   GLU   165     -14.461  42.850  51.700  1.00 27.47          
ATOM   1320  N   GLY   166     -13.000  41.204  52.224  1.00 28.61          
ATOM   1321  CA  GLY   166     -12.087  41.536  51.144  1.00 26.26          
ATOM   1322  C   GLY   166     -12.767  41.300  49.807  1.00 25.80          
ATOM   1323  O   GLY   166     -12.592  42.077  48.865  1.00 25.53          
ATOM   1324  N   ALA   167     -13.560  40.230  49.729  1.00 24.96          
ATOM   1325  CA  ALA   167     -14.288  39.876  48.514  1.00 24.41          
ATOM   1326  CB  ALA   167     -14.900  38.477  48.656  1.00 23.92          
ATOM   1327  C   ALA   167     -15.387  40.897  48.207  1.00 25.29          
ATOM   1328  O   ALA   167     -15.723  41.118  47.056  1.00 26.94          
ATOM   1329  N   GLU   168     -15.961  41.492  49.246  1.00 25.80          
ATOM   1330  CA  GLU   168     -16.995  42.501  49.072  1.00 26.84          
ATOM   1331  CB  GLU   168     -17.607  42.891  50.424  1.00 27.74          
ATOM   1332  CG  GLU   168     -18.508  41.826  51.025  1.00 30.09          
ATOM   1333  CD  GLU   168     -18.925  42.164  52.440  1.00 32.85          
ATOM   1334  OE1 GLU   168     -18.454  43.187  52.982  1.00 32.58          
ATOM   1335  OE2 GLU   168     -19.723  41.400  53.016  1.00 34.25          
ATOM   1336  C   GLU   168     -16.377  43.739  48.447  1.00 26.11          
ATOM   1337  O   GLU   168     -16.970  44.370  47.581  1.00 27.62          
ATOM   1338  N   CYS   169     -15.176  44.076  48.895  1.00 25.36          
ATOM   1339  CA  CYS   169     -14.492  45.257  48.395  1.00 25.51          
ATOM   1340  CB  CYS   169     -13.317  45.580  49.314  1.00 26.47          
ATOM   1341  SG  CYS   169     -13.873  45.951  50.998  1.00 29.13          
ATOM   1342  C   CYS   169     -14.036  45.084  46.945  1.00 27.43          
ATOM   1343  O   CYS   169     -14.202  45.979  46.115  1.00 26.93          
ATOM   1344  N   ILE   170     -13.472  43.922  46.641  1.00 28.32          
ATOM   1345  CA  ILE   170     -13.031  43.637  45.286  1.00 28.24          
ATOM   1346  CB  ILE   170     -12.321  42.273  45.218  1.00 27.26          
ATOM   1347  CG2 ILE   170     -12.205  41.807  43.770  1.00 22.52          
ATOM   1348  CG1 ILE   170     -10.954  42.400  45.889  1.00 27.47          
ATOM   1349  CD  ILE   170     -10.271  41.078  46.166  1.00 31.01          
ATOM   1350  C   ILE   170     -14.223  43.643  44.335  1.00 28.14          
ATOM   1351  O   ILE   170     -14.156  44.220  43.254  1.00 28.90          
ATOM   1352  N   TYR   171     -15.322  43.009  44.729  1.00 26.16          
ATOM   1353  CA  TYR   171     -16.484  42.986  43.855  1.00 27.19          
ATOM   1354  CB  TYR   171     -17.606  42.145  44.464  1.00 27.05          
ATOM   1355  CG  TYR   171     -18.846  42.131  43.607  1.00 28.28          
ATOM   1356  CD1 TYR   171     -18.890  41.394  42.423  1.00 28.11          
ATOM   1357  CE1 TYR   171     -20.004  41.442  41.582  1.00 30.14          
ATOM   1358  CD2 TYR   171     -19.950  42.915  43.935  1.00 29.55          
ATOM   1359  CE2 TYR   171     -21.075  42.976  43.098  1.00 29.92          
ATOM   1360  CZ  TYR   171     -21.093  42.238  41.926  1.00 31.21          
ATOM   1361  OH  TYR   171     -22.187  42.307  41.093  1.00 31.95          
ATOM   1362  C   TYR   171     -16.993  44.418  43.585  1.00 28.05          
ATOM   1363  O   TYR   171     -17.315  44.776  42.452  1.00 28.96          
ATOM   1364  N   THR   172     -17.049  45.235  44.634  1.00 28.13          
ATOM   1365  CA  THR   172     -17.529  46.603  44.502  1.00 27.14          
ATOM   1366  CB  THR   172     -17.411  47.356  45.842  1.00 28.33          
ATOM   1367  OG1 THR   172     -18.253  46.721  46.807  1.00 30.25          
ATOM   1368  CG2 THR   172     -17.837  48.821  45.695  1.00 26.97          
ATOM   1369  C   THR   172     -16.772  47.361  43.417  1.00 26.85          
ATOM   1370  O   THR   172     -17.376  48.080  42.635  1.00 27.08          
ATOM   1371  N   GLY   173     -15.455  47.192  43.364  1.00 25.96          
ATOM   1372  CA  GLY   173     -14.666  47.889  42.367  1.00 24.87          
ATOM   1373  C   GLY   173     -14.959  47.406  40.959  1.00 26.12          
ATOM   1374  O   GLY   173     -15.051  48.202  40.022  1.00 27.09          
ATOM   1375  N   MET   174     -15.098  46.094  40.806  1.00 27.58          
ATOM   1376  CA  MET   174     -15.383  45.504  39.503  1.00 27.65          
ATOM   1377  CB  MET   174     -15.342  43.969  39.594  1.00 27.61          
ATOM   1378  CG  MET   174     -13.952  43.399  39.876  1.00 28.52          
ATOM   1379  SD  MET   174     -13.891  41.464  40.113  0.87 36.46          
ATOM   1380  CE  MET   174     -14.392  40.953  38.311  1.00 28.76          
ATOM   1381  C   MET   174     -16.757  45.968  39.022  1.00 27.10          
ATOM   1382  O   MET   174     -16.931  46.299  37.855  1.00 27.31          
ATOM   1383  N   MET   175     -17.726  45.994  39.929  1.00 27.16          
ATOM   1384  CA  MET   175     -19.086  46.420  39.585  1.00 30.18          
ATOM   1385  CB  MET   175     -20.014  46.220  40.782  1.00 28.11          
ATOM   1386  CG  MET   175     -21.393  46.839  40.626  1.00 31.10          
ATOM   1387  SD  MET   175     -22.425  46.704  42.265  0.83 38.55          
ATOM   1388  CE  MET   175     -23.410  45.066  41.844  1.00 40.78          
ATOM   1389  C   MET   175     -19.109  47.895  39.177  1.00 30.51          
ATOM   1390  O   MET   175     -19.649  48.281  38.150  1.00 33.21          
ATOM   1391  N   THR   176     -18.510  48.704  40.019  1.00 32.00          
ATOM   1392  CA  THR   176     -18.430  50.129  39.830  1.00 33.48          
ATOM   1393  CB  THR   176     -17.776  50.728  41.090  1.00 32.77          
ATOM   1394  OG1 THR   176     -18.811  51.272  41.921  1.00 36.49          
ATOM   1395  CG2 THR   176     -16.748  51.748  40.757  1.00 37.91          
ATOM   1396  C   THR   176     -17.718  50.574  38.543  1.00 33.25          
ATOM   1397  O   THR   176     -18.233  51.412  37.806  1.00 33.46          
ATOM   1398  N   ASP   177     -16.557  50.004  38.247  1.00 31.93          
ATOM   1399  CA  ASP   177     -15.846  50.430  37.046  1.00 31.98          
ATOM   1400  CB  ASP   177     -14.377  50.031  37.110  1.00 31.15          
ATOM   1401  CG  ASP   177     -13.464  51.177  36.738  1.00 33.75          
ATOM   1402  OD1 ASP   177     -13.397  52.134  37.529  1.00 33.92          
ATOM   1403  OD2 ASP   177     -12.833  51.144  35.651  1.00 34.05          
ATOM   1404  C   ASP   177     -16.448  49.968  35.721  1.00 29.47          
ATOM   1405  O   ASP   177     -16.066  50.476  34.679  1.00 30.03          
ATOM   1406  N   THR   178     -17.372  49.010  35.756  1.00 26.64          
ATOM   1407  CA  THR   178     -18.030  48.541  34.536  1.00 24.46          
ATOM   1408  CB  THR   178     -18.048  47.008  34.432  1.00 23.17          
ATOM   1409  OG1 THR   178     -18.662  46.475  35.612  1.00 21.83          
ATOM   1410  CG2 THR   178     -16.635  46.446  34.254  1.00 18.25          
ATOM   1411  C   THR   178     -19.501  48.977  34.502  1.00 24.93          
ATOM   1412  O   THR   178     -20.288  48.424  33.734  1.00 25.61          
ATOM   1413  N   GLY   179     -19.875  49.934  35.349  1.00 24.84          
ATOM   1414  CA  GLY   179     -21.257  50.396  35.389  1.00 26.11          
ATOM   1415  C   GLY   179     -22.224  49.264  35.699  1.00 27.41          
ATOM   1416  O   GLY   179     -23.289  49.140  35.078  1.00 26.05          
ATOM   1417  N   GLY   180     -21.856  48.429  36.662  1.00 26.42          
ATOM   1418  CA  GLY   180     -22.707  47.314  37.010  1.00 26.63          
ATOM   1419  C   GLY   180     -22.670  46.251  35.925  1.00 28.01          
ATOM   1420  O   GLY   180     -23.692  45.625  35.644  1.00 30.69          
ATOM   1421  N   PHE   181     -21.495  46.047  35.319  1.00 28.77          
ATOM   1422  CA  PHE   181     -21.293  45.052  34.252  1.00 29.65          
ATOM   1423  CB  PHE   181     -21.443  43.642  34.827  1.00 27.89          
ATOM   1424  CG  PHE   181     -20.507  43.372  35.967  1.00 29.12          
ATOM   1425  CD1 PHE   181     -19.146  43.153  35.731  1.00 25.36          
ATOM   1426  CD2 PHE   181     -20.962  43.430  37.282  1.00 26.39          
ATOM   1427  CE1 PHE   181     -18.253  43.005  36.787  1.00 23.94          
ATOM   1428  CE2 PHE   181     -20.080  43.288  38.345  1.00 28.32          
ATOM   1429  CZ  PHE   181     -18.714  43.074  38.098  1.00 25.88          
ATOM   1430  C   PHE   181     -22.206  45.247  33.036  1.00 30.64          
ATOM   1431  O   PHE   181     -22.848  44.304  32.527  1.00 29.85          
ATOM   1432  N   THR   182     -22.248  46.489  32.570  1.00 31.07          
ATOM   1433  CA  THR   182     -23.039  46.853  31.406  1.00 33.07          
ATOM   1434  CB  THR   182     -24.131  47.888  31.769  1.00 34.08          
ATOM   1435  OG1 THR   182     -23.523  49.080  32.291  1.00 30.35          
ATOM   1436  CG2 THR   182     -25.080  47.303  32.802  1.00 31.13          
ATOM   1437  C   THR   182     -22.115  47.461  30.361  1.00 35.11          
ATOM   1438  O   THR   182     -22.507  47.655  29.216  1.00 37.32          
ATOM   1439  N   TYR   183     -20.879  47.741  30.765  1.00 35.90          
ATOM   1440  CA  TYR   183     -19.895  48.352  29.892  1.00 37.98          
ATOM   1441  CB  TYR   183     -19.914  49.875  30.154  1.00 42.87          
ATOM   1442  CG  TYR   183     -18.571  50.572  30.134  1.00 47.63          
ATOM   1443  CD1 TYR   183     -17.841  50.775  31.311  1.00 49.33          
ATOM   1444  CE1 TYR   183     -16.578  51.395  31.283  1.00 52.30          
ATOM   1445  CD2 TYR   183     -18.014  51.007  28.928  1.00 52.35          
ATOM   1446  CE2 TYR   183     -16.757  51.628  28.882  1.00 55.10          
ATOM   1447  CZ  TYR   183     -16.043  51.818  30.058  1.00 54.65          
ATOM   1448  OH  TYR   183     -14.802  52.423  29.982  1.00 54.09          
ATOM   1449  C   TYR   183     -18.481  47.748  30.070  1.00 37.87          
ATOM   1450  O   TYR   183     -17.998  47.598  31.190  1.00 38.40          
ATOM   1451  N   ASN   184     -17.842  47.382  28.955  1.00 37.08          
ATOM   1452  CA  ASN   184     -16.487  46.817  28.957  1.00 36.25          
ATOM   1453  CB  ASN   184     -15.495  47.883  29.460  1.00 38.50          
ATOM   1454  CG  ASN   184     -14.037  47.491  29.250  1.00 41.70          
ATOM   1455  OD1 ASN   184     -13.691  46.814  28.275  1.00 43.17          
ATOM   1456  ND2 ASN   184     -13.166  47.939  30.158  1.00 43.13          
ATOM   1457  C   ASN   184     -16.401  45.554  29.818  1.00 35.55          
ATOM   1458  O   ASN   184     -15.401  45.307  30.484  1.00 33.07          
ATOM   1459  N   SER   185     -17.458  44.749  29.788  1.00 34.76          
ATOM   1460  CA  SER   185     -17.501  43.536  30.595  1.00 35.27          
ATOM   1461  CB  SER   185     -18.621  43.645  31.644  1.00 33.75          
ATOM   1462  OG  SER   185     -19.916  43.519  31.052  1.00 33.36          
ATOM   1463  C   SER   185     -17.702  42.257  29.792  1.00 34.83          
ATOM   1464  O   SER   185     -18.153  41.259  30.336  1.00 35.65          
ATOM   1465  N   ASN   186     -17.374  42.272  28.506  1.00 36.30          
ATOM   1466  CA  ASN   186     -17.548  41.069  27.683  1.00 37.20          
ATOM   1467  CB  ASN   186     -17.388  41.392  26.202  1.00 38.02          
ATOM   1468  CG  ASN   186     -18.690  41.774  25.562  1.00 41.93          
ATOM   1469  OD1 ASN   186     -19.718  41.129  25.799  1.00 44.55          
ATOM   1470  ND2 ASN   186     -18.666  42.824  24.742  1.00 42.63          
ATOM   1471  C   ASN   186     -16.648  39.885  27.991  1.00 35.72          
ATOM   1472  O   ASN   186     -16.934  38.777  27.567  1.00 37.06          
ATOM   1473  N   ASN   187     -15.564  40.113  28.719  1.00 35.37          
ATOM   1474  CA  ASN   187     -14.627  39.044  29.038  1.00 34.61          
ATOM   1475  CB  ASN   187     -13.366  39.654  29.644  1.00 34.20          
ATOM   1476  CG  ASN   187     -12.228  38.658  29.740  1.00 36.08          
ATOM   1477  OD1 ASN   187     -12.274  37.731  30.533  1.00 38.86          
ATOM   1478  ND2 ASN   187     -11.206  38.844  28.921  1.00 37.91          
ATOM   1479  C   ASN   187     -15.197  37.946  29.957  1.00 35.01          
ATOM   1480  O   ASN   187     -15.663  38.208  31.066  1.00 33.39          
ATOM   1481  N   ARG   188     -15.149  36.712  29.472  1.00 34.87          
ATOM   1482  CA  ARG   188     -15.638  35.546  30.203  1.00 36.55          
ATOM   1483  CB  ARG   188     -15.330  34.269  29.414  1.00 38.74          
ATOM   1484  CG  ARG   188     -15.954  34.198  28.038  1.00 45.42          
ATOM   1485  CD  ARG   188     -15.510  32.933  27.320  1.00 49.93          
ATOM   1486  NE  ARG   188     -15.802  31.738  28.105  1.00 54.73          
ATOM   1487  CZ  ARG   188     -15.416  30.509  27.772  1.00 57.44          
ATOM   1488  NH1 ARG   188     -14.716  30.308  26.659  1.00 58.34          
ATOM   1489  NH2 ARG   188     -15.723  29.481  28.556  1.00 57.11          
ATOM   1490  C   ARG   188     -15.054  35.364  31.605  1.00 35.34          
ATOM   1491  O   ARG   188     -15.734  34.903  32.512  1.00 33.02          
ATOM   1492  N   GLU   189     -13.784  35.703  31.772  1.00 35.80          
ATOM   1493  CA  GLU   189     -13.125  35.508  33.051  1.00 35.79          
ATOM   1494  CB  GLU   189     -11.612  35.645  32.878  1.00 39.48          
ATOM   1495  CG  GLU   189     -10.986  34.462  32.118  1.00 44.18          
ATOM   1496  CD  GLU   189      -9.510  34.662  31.809  1.00 47.71          
ATOM   1497  OE1 GLU   189      -8.712  34.797  32.753  1.00 46.93          
ATOM   1498  OE2 GLU   189      -9.143  34.690  30.615  1.00 52.27          
ATOM   1499  C   GLU   189     -13.630  36.399  34.175  1.00 36.30          
ATOM   1500  O   GLU   189     -13.349  36.140  35.343  1.00 35.97          
ATOM   1501  N   ILE   190     -14.375  37.445  33.824  1.00 34.55          
ATOM   1502  CA  ILE   190     -14.937  38.334  34.827  1.00 32.00          
ATOM   1503  CB  ILE   190     -15.669  39.531  34.177  1.00 32.80          
ATOM   1504  CG2 ILE   190     -16.560  40.208  35.197  1.00 31.52          
ATOM   1505  CG1 ILE   190     -14.664  40.529  33.596  1.00 32.56          
ATOM   1506  CD  ILE   190     -15.342  41.696  32.831  1.00 25.42          
ATOM   1507  C   ILE   190     -15.967  37.564  35.666  1.00 32.30          
ATOM   1508  O   ILE   190     -16.000  37.687  36.890  1.00 32.46          
ATOM   1509  N   TYR   191     -16.795  36.768  34.985  1.00 30.94          
ATOM   1510  CA  TYR   191     -17.864  35.990  35.613  1.00 29.63          
ATOM   1511  CB  TYR   191     -18.895  35.620  34.533  1.00 26.56          
ATOM   1512  CG  TYR   191     -19.298  36.888  33.823  1.00 27.05          
ATOM   1513  CD1 TYR   191     -20.177  37.793  34.433  1.00 27.31          
ATOM   1514  CE1 TYR   191     -20.371  39.079  33.918  1.00 27.13          
ATOM   1515  CD2 TYR   191     -18.638  37.298  32.660  1.00 26.65          
ATOM   1516  CE2 TYR   191     -18.820  38.585  32.134  1.00 28.47          
ATOM   1517  CZ  TYR   191     -19.682  39.471  32.776  1.00 29.42          
ATOM   1518  OH  TYR   191     -19.800  40.766  32.332  1.00 29.95          
ATOM   1519  C   TYR   191     -17.381  34.787  36.408  1.00 29.74          
ATOM   1520  O   TYR   191     -18.028  34.360  37.363  1.00 30.86          
ATOM   1521  N   PHE   192     -16.241  34.237  36.039  1.00 30.44          
ATOM   1522  CA  PHE   192     -15.713  33.143  36.826  1.00 29.53          
ATOM   1523  CB  PHE   192     -14.515  32.504  36.128  1.00 32.28          
ATOM   1524  CG  PHE   192     -13.824  31.453  36.960  1.00 35.87          
ATOM   1525  CD1 PHE   192     -14.430  30.219  37.193  1.00 34.97          
ATOM   1526  CD2 PHE   192     -12.575  31.710  37.532  1.00 35.73          
ATOM   1527  CE1 PHE   192     -13.802  29.250  37.987  1.00 37.32          
ATOM   1528  CE2 PHE   192     -11.939  30.750  38.326  1.00 37.87          
ATOM   1529  CZ  PHE   192     -12.554  29.518  38.553  1.00 38.02          
ATOM   1530  C   PHE   192     -15.256  33.796  38.140  1.00 29.35          
ATOM   1531  O   PHE   192     -15.447  33.250  39.219  1.00 30.15          
ATOM   1532  N   ILE   193     -14.664  34.985  38.043  1.00 29.06          
ATOM   1533  CA  ILE   193     -14.186  35.690  39.233  1.00 27.57          
ATOM   1534  CB  ILE   193     -13.341  36.930  38.824  1.00 28.35          
ATOM   1535  CG2 ILE   193     -13.057  37.831  40.042  1.00 25.51          
ATOM   1536  CG1 ILE   193     -12.017  36.454  38.190  1.00 24.46          
ATOM   1537  CD  ILE   193     -11.033  37.591  37.864  1.00 24.39          
ATOM   1538  C   ILE   193     -15.370  36.073  40.134  1.00 29.26          
ATOM   1539  O   ILE   193     -15.314  35.917  41.359  1.00 28.70          
ATOM   1540  N   ILE   194     -16.462  36.533  39.528  1.00 28.48          
ATOM   1541  CA  ILE   194     -17.628  36.889  40.314  1.00 27.23          
ATOM   1542  CB  ILE   194     -18.772  37.398  39.425  1.00 26.40          
ATOM   1543  CG2 ILE   194     -20.101  37.392  40.220  1.00 21.87          
ATOM   1544  CG1 ILE   194     -18.430  38.805  38.916  1.00 23.24          
ATOM   1545  CD  ILE   194     -19.428  39.353  37.895  1.00 25.70          
ATOM   1546  C   ILE   194     -18.087  35.643  41.062  1.00 28.71          
ATOM   1547  O   ILE   194     -18.419  35.695  42.244  1.00 28.58          
ATOM   1548  N   SER   195     -18.090  34.514  40.367  1.00 30.04          
ATOM   1549  CA  SER   195     -18.498  33.265  40.986  1.00 31.00          
ATOM   1550  CB  SER   195     -18.465  32.133  39.957  1.00 31.22          
ATOM   1551  OG  SER   195     -18.849  30.911  40.554  1.00 36.50          
ATOM   1552  C   SER   195     -17.588  32.934  42.169  1.00 31.24          
ATOM   1553  O   SER   195     -18.059  32.481  43.202  1.00 33.18          
ATOM   1554  N   GLU   196     -16.290  33.176  42.024  1.00 32.73          
ATOM   1555  CA  GLU   196     -15.332  32.901  43.092  1.00 33.94          
ATOM   1556  CB  GLU   196     -13.899  33.138  42.598  1.00 37.81          
ATOM   1557  CG  GLU   196     -13.478  32.233  41.461  1.00 41.38          
ATOM   1558  CD  GLU   196     -13.333  30.800  41.908  1.00 46.25          
ATOM   1559  OE1 GLU   196     -12.191  30.374  42.206  1.00 47.63          
ATOM   1560  OE2 GLU   196     -14.370  30.102  41.974  1.00 48.65          
ATOM   1561  C   GLU   196     -15.575  33.776  44.315  1.00 34.01          
ATOM   1562  O   GLU   196     -15.429  33.329  45.457  1.00 35.27          
ATOM   1563  N   LEU   197     -15.923  35.037  44.067  1.00 33.36          
ATOM   1564  CA  LEU   197     -16.183  35.990  45.140  1.00 29.03          
ATOM   1565  CB  LEU   197     -16.305  37.409  44.569  1.00 26.66          
ATOM   1566  CG  LEU   197     -15.010  37.970  43.958  1.00 25.48          
ATOM   1567  CD1 LEU   197     -15.297  39.260  43.196  1.00 24.52          
ATOM   1568  CD2 LEU   197     -13.989  38.207  45.062  1.00 24.18          
ATOM   1569  C   LEU   197     -17.455  35.606  45.885  1.00 29.57          
ATOM   1570  O   LEU   197     -17.521  35.727  47.109  1.00 29.13          
ATOM   1571  N   LEU   198     -18.458  35.136  45.145  1.00 30.03          
ATOM   1572  CA  LEU   198     -19.731  34.732  45.742  1.00 30.25          
ATOM   1573  CB  LEU   198     -20.751  34.383  44.657  1.00 28.58          
ATOM   1574  CG  LEU   198     -21.483  35.533  43.969  1.00 26.47          
ATOM   1575  CD1 LEU   198     -22.244  35.020  42.771  1.00 24.74          
ATOM   1576  CD2 LEU   198     -22.454  36.163  44.962  1.00 27.49          
ATOM   1577  C   LEU   198     -19.519  33.523  46.640  1.00 32.45          
ATOM   1578  O   LEU   198     -20.229  33.340  47.626  1.00 33.99          
ATOM   1579  N   SER   199     -18.534  32.701  46.304  1.00 33.73          
ATOM   1580  CA  SER   199     -18.258  31.522  47.107  1.00 35.25          
ATOM   1581  CB  SER   199     -17.304  30.562  46.371  1.00 35.31          
ATOM   1582  OG  SER   199     -15.969  31.059  46.332  1.00 38.05          
ATOM   1583  C   SER   199     -17.644  31.967  48.433  1.00 35.09          
ATOM   1584  O   SER   199     -17.490  31.162  49.342  1.00 36.33          
ATOM   1585  N   LYS   200     -17.299  33.250  48.540  1.00 34.71          
ATOM   1586  CA  LYS   200     -16.721  33.773  49.777  1.00 33.11          
ATOM   1587  CB  LYS   200     -15.753  34.915  49.497  1.00 35.23          
ATOM   1588  CG  LYS   200     -14.544  34.547  48.648  1.00 38.23          
ATOM   1589  CD  LYS   200     -13.511  33.766  49.427  1.00 41.15          
ATOM   1590  CE  LYS   200     -12.282  33.501  48.555  1.00 44.94          
ATOM   1591  NZ  LYS   200     -11.180  32.833  49.304  1.00 44.66          
ATOM   1592  C   LYS   200     -17.829  34.280  50.682  1.00 32.44          
ATOM   1593  O   LYS   200     -17.567  34.797  51.759  1.00 31.53          
ATOM   1594  N   GLY   201     -19.074  34.144  50.235  1.00 32.78          
ATOM   1595  CA  GLY   201     -20.194  34.576  51.054  1.00 30.44          
ATOM   1596  C   GLY   201     -20.776  35.958  50.817  1.00 30.41          
ATOM   1597  O   GLY   201     -21.658  36.380  51.563  1.00 28.74          
ATOM   1598  N   ILE   202     -20.328  36.670  49.787  1.00 30.88          
ATOM   1599  CA  ILE   202     -20.868  38.005  49.580  1.00 33.35          
ATOM   1600  CB  ILE   202     -19.982  38.881  48.655  1.00 33.04          
ATOM   1601  CG2 ILE   202     -18.533  38.814  49.094  1.00 32.09          
ATOM   1602  CG1 ILE   202     -20.149  38.447  47.202  1.00 34.24          
ATOM   1603  CD  ILE   202     -19.512  39.400  46.218  1.00 33.20          
ATOM   1604  C   ILE   202     -22.268  37.994  48.996  1.00 33.81          
ATOM   1605  O   ILE   202     -22.719  37.005  48.419  1.00 35.35          
ATOM   1606  N   ASP   203     -22.958  39.112  49.171  1.00 34.27          
ATOM   1607  CA  ASP   203     -24.295  39.273  48.639  1.00 31.99          
ATOM   1608  CB  ASP   203     -25.275  39.696  49.741  1.00 34.30          
ATOM   1609  CG  ASP   203     -26.706  39.772  49.240  1.00 35.91          
ATOM   1610  OD1 ASP   203     -26.896  39.860  48.006  1.00 36.40          
ATOM   1611  OD2 ASP   203     -27.642  39.749  50.068  1.00 36.83          
ATOM   1612  C   ASP   203     -24.143  40.389  47.623  1.00 30.24          
ATOM   1613  O   ASP   203     -24.156  41.560  47.985  1.00 30.86          
ATOM   1614  N   LYS   204     -24.003  40.034  46.351  1.00 28.91          
ATOM   1615  CA  LYS   204     -23.811  41.050  45.320  1.00 27.49          
ATOM   1616  CB  LYS   204     -23.404  40.402  43.984  1.00 25.75          
ATOM   1617  CG  LYS   204     -24.430  39.462  43.377  1.00 22.65          
ATOM   1618  CD  LYS   204     -23.849  38.694  42.178  1.00 26.13          
ATOM   1619  CE  LYS   204     -23.612  39.601  40.962  1.00 22.67          
ATOM   1620  NZ  LYS   204     -24.878  40.119  40.351  1.00 26.05          
ATOM   1621  C   LYS   204     -25.006  41.957  45.105  1.00 27.76          
ATOM   1622  O   LYS   204     -24.846  43.101  44.703  1.00 28.21          
ATOM   1623  N   ASP   205     -26.205  41.444  45.346  1.00 28.58          
ATOM   1624  CA  ASP   205     -27.393  42.256  45.160  1.00 29.45          
ATOM   1625  CB  ASP   205     -28.650  41.371  45.206  1.00 29.61          
ATOM   1626  CG  ASP   205     -28.794  40.500  43.945  1.00 32.48          
ATOM   1627  OD1 ASP   205     -28.212  40.883  42.897  1.00 31.51          
ATOM   1628  OD2 ASP   205     -29.494  39.448  43.988  1.00 26.53          
ATOM   1629  C   ASP   205     -27.426  43.349  46.228  1.00 31.45          
ATOM   1630  O   ASP   205     -27.769  44.497  45.942  1.00 32.07          
ATOM   1631  N   ASP   206     -27.036  43.001  47.451  1.00 32.36          
ATOM   1632  CA  ASP   206     -27.014  43.977  48.540  1.00 33.45          
ATOM   1633  CB  ASP   206     -26.750  43.286  49.882  1.00 34.82          
ATOM   1634  CG  ASP   206     -26.917  44.229  51.061  1.00 36.95          
ATOM   1635  OD1 ASP   206     -28.046  44.723  51.272  1.00 38.08          
ATOM   1636  OD2 ASP   206     -25.919  44.489  51.773  1.00 41.70          
ATOM   1637  C   ASP   206     -25.953  45.051  48.303  1.00 32.60          
ATOM   1638  O   ASP   206     -26.156  46.217  48.659  1.00 33.43          
ATOM   1639  N   ILE   207     -24.819  44.652  47.720  1.00 30.96          
ATOM   1640  CA  ILE   207     -23.720  45.579  47.427  1.00 28.75          
ATOM   1641  CB  ILE   207     -22.479  44.835  46.878  1.00 27.95          
ATOM   1642  CG2 ILE   207     -21.490  45.828  46.254  1.00 22.28          
ATOM   1643  CG1 ILE   207     -21.812  44.050  48.007  1.00 28.52          
ATOM   1644  CD  ILE   207     -20.519  43.372  47.593  1.00 31.28          
ATOM   1645  C   ILE   207     -24.195  46.584  46.391  1.00 29.34          
ATOM   1646  O   ILE   207     -23.880  47.773  46.464  1.00 27.18          
ATOM   1647  N   TYR   208     -24.954  46.089  45.420  1.00 30.26          
ATOM   1648  CA  TYR   208     -25.519  46.936  44.387  1.00 30.72          
ATOM   1649  CB  TYR   208     -26.386  46.118  43.435  1.00 31.93          
ATOM   1650  CG  TYR   208     -27.042  46.988  42.399  1.00 34.80          
ATOM   1651  CD1 TYR   208     -26.315  47.451  41.314  1.00 37.17          
ATOM   1652  CE1 TYR   208     -26.872  48.319  40.394  1.00 40.08          
ATOM   1653  CD2 TYR   208     -28.367  47.417  42.541  1.00 37.07          
ATOM   1654  CE2 TYR   208     -28.936  48.296  41.619  1.00 38.96          
ATOM   1655  CZ  TYR   208     -28.171  48.740  40.549  1.00 40.83          
ATOM   1656  OH  TYR   208     -28.668  49.624  39.616  1.00 47.44          
ATOM   1657  C   TYR   208     -26.406  48.014  45.017  1.00 30.74          
ATOM   1658  O   TYR   208     -26.286  49.203  44.693  1.00 32.39          
ATOM   1659  N   ARG   209     -27.309  47.587  45.896  1.00 29.59          
ATOM   1660  CA  ARG   209     -28.236  48.504  46.564  1.00 31.14          
ATOM   1661  CB  ARG   209     -29.246  47.731  47.429  1.00 28.96          
ATOM   1662  CG  ARG   209     -30.367  47.085  46.621  1.00 33.30          
ATOM   1663  CD  ARG   209     -31.462  46.536  47.516  1.00 36.06          
ATOM   1664  NE  ARG   209     -31.061  45.298  48.175  1.00 39.96          
ATOM   1665  CZ  ARG   209     -31.199  44.088  47.637  1.00 43.93          
ATOM   1666  NH1 ARG   209     -31.735  43.945  46.428  1.00 45.67          
ATOM   1667  NH2 ARG   209     -30.797  43.021  48.305  1.00 44.04          
ATOM   1668  C   ARG   209     -27.539  49.547  47.422  1.00 30.77          
ATOM   1669  O   ARG   209     -27.923  50.716  47.423  1.00 29.95          
ATOM   1670  N   LYS   210     -26.515  49.118  48.147  1.00 30.75          
ATOM   1671  CA  LYS   210     -25.763  50.005  49.018  1.00 30.54          
ATOM   1672  CB  LYS   210     -24.758  49.188  49.828  1.00 29.89          
ATOM   1673  CG  LYS   210     -25.389  48.417  50.984  1.00 31.07          
ATOM   1674  CD  LYS   210     -24.370  47.517  51.675  1.00 32.60          
ATOM   1675  CE  LYS   210     -24.546  47.541  53.172  1.00 33.06          
ATOM   1676  NZ  LYS   210     -25.961  47.315  53.527  1.00 36.41          
ATOM   1677  C   LYS   210     -25.044  51.128  48.272  1.00 31.25          
ATOM   1678  O   LYS   210     -24.890  52.227  48.793  1.00 34.02          
ATOM   1679  N   VAL   211     -24.620  50.851  47.046  1.00 30.57          
ATOM   1680  CA  VAL   211     -23.904  51.831  46.237  1.00 28.27          
ATOM   1681  CB  VAL   211     -22.827  51.126  45.350  1.00 25.73          
ATOM   1682  CG1 VAL   211     -22.190  52.110  44.376  1.00 19.95          
ATOM   1683  CG2 VAL   211     -21.768  50.494  46.225  1.00 20.49          
ATOM   1684  C   VAL   211     -24.812  52.672  45.331  1.00 32.06          
ATOM   1685  O   VAL   211     -24.604  53.885  45.189  1.00 32.03          
ATOM   1686  N   TYR   212     -25.823  52.041  44.736  1.00 31.92          
ATOM   1687  CA  TYR   212     -26.695  52.741  43.803  1.00 35.21          
ATOM   1688  CB  TYR   212     -26.794  51.937  42.511  1.00 33.86          
ATOM   1689  CG  TYR   212     -25.463  51.714  41.830  1.00 34.74          
ATOM   1690  CD1 TYR   212     -24.796  52.768  41.195  1.00 32.46          
ATOM   1691  CE1 TYR   212     -23.588  52.558  40.540  1.00 31.55          
ATOM   1692  CD2 TYR   212     -24.879  50.441  41.799  1.00 31.42          
ATOM   1693  CE2 TYR   212     -23.675  50.216  41.147  1.00 31.04          
ATOM   1694  CZ  TYR   212     -23.041  51.275  40.516  1.00 34.10          
ATOM   1695  OH  TYR   212     -21.899  51.045  39.806  1.00 36.56          
ATOM   1696  C   TYR   212     -28.105  53.114  44.249  1.00 38.85          
ATOM   1697  O   TYR   212     -28.734  53.988  43.636  1.00 38.01          
ATOM   1698  N   ASN   213     -28.610  52.464  45.292  1.00 41.30          
ATOM   1699  CA  ASN   213     -29.955  52.753  45.774  1.00 43.85          
ATOM   1700  CB  ASN   213     -30.769  51.470  45.817  1.00 44.64          
ATOM   1701  CG  ASN   213     -30.914  50.837  44.451  1.00 48.21          
ATOM   1702  OD1 ASN   213     -31.324  49.688  44.336  1.00 52.04          
ATOM   1703  ND2 ASN   213     -30.588  51.592  43.403  1.00 48.25          
ATOM   1704  C   ASN   213     -29.924  53.384  47.148  1.00 46.10          
ATOM   1705  O   ASN   213     -30.675  53.000  48.044  1.00 46.55          
ATOM   1706  N   THR   214     -29.049  54.363  47.314  1.00 49.38          
ATOM   1707  CA  THR   214     -28.932  55.026  48.593  1.00 54.47          
ATOM   1708  CB  THR   214     -27.792  54.426  49.444  1.00 56.19          
ATOM   1709  OG1 THR   214     -26.595  54.361  48.659  1.00 56.02          
ATOM   1710  CG2 THR   214     -28.177  53.026  49.962  1.00 56.49          
ATOM   1711  C   THR   214     -28.688  56.507  48.463  1.00 57.84          
ATOM   1712  O   THR   214     -27.545  56.967  48.483  1.00 59.27          
END
