
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  187 ( 1455),  selected  187 , name 1wpn_A
# Molecule2: number of CA atoms  213 ( 1712),  selected  213 , name T0501_2_214.pdb
# PARAMETERS: 1wpn_A.T0501_2_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       2           -
LGA    -       -      T       3           -
LGA    -       -      K       4           -
LGA    -       -      V       5           -
LGA    -       -      I       6           -
LGA    -       -      A       7           -
LGA    -       -      Q       8           -
LGA    -       -      A       9           -
LGA    -       -      X      10           -
LGA    -       -      I      11           -
LGA    -       -      D      12           -
LGA    -       -      X      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      K      16           -
LGA    -       -      W      17           -
LGA    -       -      F      18           -
LGA    -       -      E      19           -
LGA    -       -      R      20           -
LGA    -       -      A      21           -
LGA    E     2_A      D      22          4.413
LGA    K     3_A      K      23          2.505
LGA    I     4_A      I      24          2.796
LGA    L     5_A      V      25          1.659
LGA    I     6_A      I      26          0.543
LGA    F     7_A      V      27          1.828
LGA    G     8_A      S      28          1.022
LGA    H     9_A      X      29          0.552
LGA    Q    10_A      V      30          0.583
LGA    N    11_A      S      31          0.294
LGA    P    12_A      P      32          0.766
LGA    D    13_A      D      33          0.337
LGA    T    14_A      G      34          1.274
LGA    D    15_A      D      35          1.359
LGA    T    16_A      A      36          1.005
LGA    I    17_A      I      37          1.161
LGA    C    18_A      G      38          1.863
LGA    S    19_A      S      39          1.394
LGA    A    20_A      S      40          1.364
LGA    I    21_A      L      41          1.630
LGA    A    22_A      G      42          1.721
LGA    Y    23_A      L      43          1.221
LGA    A    24_A      Y      44          2.270
LGA    D    25_A      X      45          2.587
LGA    L    26_A      F      46          2.490
LGA    K    27_A      L      47          2.694
LGA    N    28_A      D      48          3.364
LGA    K    29_A      S      49          3.502
LGA    L    30_A      Q      50          4.044
LGA    G    31_A      D      51          4.634
LGA    F    32_A      K      52          3.741
LGA    N    33_A      I      53          2.637
LGA    A    34_A      V      54          1.864
LGA    E    35_A      N      55          1.240
LGA    P    36_A      V      56          1.631
LGA    V    37_A      I      57          2.349
LGA    R    38_A      V      58          2.596
LGA    L    39_A      P      59          2.060
LGA    G    40_A      N      60          1.297
LGA    Q    41_A      A      61          1.341
LGA    V    42_A      F      62          1.990
LGA    N    43_A      P      63          0.788
LGA    G    44_A      D      64          3.171
LGA    E    45_A      F      65          3.036
LGA    T    46_A      L      66          1.642
LGA    Q    47_A      K      67          2.425
LGA    Y    48_A      W      68          4.122
LGA    A    49_A      -       -           -
LGA    L    50_A      M      69          1.222
LGA    D    51_A      -       -           -
LGA    Y    52_A      -       -           -
LGA    F    53_A      -       -           -
LGA    K    54_A      P      70          4.212
LGA    Q    55_A      G      71          3.558
LGA    E    56_A      S      72          3.581
LGA    S    57_A      K      73          2.534
LGA    P    58_A      D      74          3.357
LGA    R    59_A      I      75          2.945
LGA    -       -      L      76           -
LGA    L    60_A      L      77          1.554
LGA    V    61_A      Y      78          2.040
LGA    E    62_A      D      79          3.530
LGA    -       -      R      80           -
LGA    -       -      Y      81           -
LGA    T    63_A      Q      82          4.167
LGA    -       -      E      83           -
LGA    -       -      F      84           -
LGA    A    64_A      A      85          4.084
LGA    A    65_A      D      86          3.229
LGA    N    66_A      K      87          3.087
LGA    E    67_A      L      88          2.859
LGA    V    68_A      I      89          2.913
LGA    -       -      M      90           -
LGA    N    69_A      E      91          3.697
LGA    G    70_A      A      92          4.114
LGA    -       -      D      93           -
LGA    V    71_A      V      94          5.588
LGA    I    72_A      I      95          2.886
LGA    -       -      C      96           -
LGA    L    73_A      C      97          0.765
LGA    V    74_A      L      98          0.553
LGA    D    75_A      D      99          0.792
LGA    H    76_A      F     100          0.764
LGA    N    77_A      N     101          1.730
LGA    E    78_A      A     102          1.437
LGA    R    79_A      L     103          1.428
LGA    Q    80_A      K     104          1.495
LGA    Q    81_A      R     105          1.070
LGA    S    82_A      I     106          1.264
LGA    I    83_A      D     107           #
LGA    K    84_A      E     108          1.607
LGA    D    85_A      M     109          3.560
LGA    I    86_A      S     110          2.437
LGA    E    87_A      D     111          3.381
LGA    E    88_A      I     112          3.304
LGA    V    89_A      V     113          3.414
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    Q    90_A      S     116          3.578
LGA    -       -      P     117           -
LGA    -       -      G     118           -
LGA    V    91_A      R     119          5.584
LGA    L    92_A      K     120          1.194
LGA    E    93_A      I     121          0.957
LGA    V    94_A      M     122          1.010
LGA    I    95_A      I     123          0.829
LGA    D    96_A      D     124          0.756
LGA    H    97_A      X     125          0.848
LGA    H    98_A      X     126          0.789
LGA    R    99_A      L     127          1.281
LGA    I   100_A      Y     128          2.811
LGA    A   101_A      P     129          3.987
LGA    N   102_A      -       -           -
LGA    F   103_A      E     130          2.888
LGA    E   104_A      D     131          3.305
LGA    T   105_A      F     132          2.517
LGA    A   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    P   108_A      C     133           #
LGA    L   109_A      R     134          1.745
LGA    Y   110_A      I     135          2.138
LGA    Y   111_A      T     136          1.577
LGA    R   112_A      I     137          1.292
LGA    A   113_A      S     138          1.937
LGA    E   114_A      X     139          2.073
LGA    P   115_A      P     140          2.952
LGA    -       -      E     141           -
LGA    V   116_A      I     142          0.798
LGA    G   117_A      S     143          0.950
LGA    C   118_A      S     144          1.100
LGA    T   119_A      T     145          1.112
LGA    A   120_A      S     146          1.367
LGA    T   121_A      E     147          0.929
LGA    I   122_A      L     148          1.210
LGA    L   123_A      V     149          1.494
LGA    N   124_A      F     150          1.402
LGA    K   125_A      R     151          1.580
LGA    M   126_A      L     152          2.079
LGA    Y   127_A      I     153          2.262
LGA    K   128_A      C     154          1.787
LGA    E   129_A      R     155          2.051
LGA    N   130_A      M     156          2.504
LGA    N   131_A      G     157          2.651
LGA    V   132_A      Y     158          2.304
LGA    -       -      F     159           -
LGA    -       -      S     160           -
LGA    K   133_A      D     161          1.864
LGA    I   134_A      I     162          0.915
LGA    E   135_A      S     163          0.696
LGA    K   136_A      K     164          0.847
LGA    E   137_A      E     165          1.235
LGA    I   138_A      G     166          1.091
LGA    A   139_A      A     167          0.619
LGA    G   140_A      E     168          0.996
LGA    L   141_A      C     169          1.212
LGA    M   142_A      I     170          0.993
LGA    L   143_A      Y     171          0.897
LGA    S   144_A      T     172          1.104
LGA    A   145_A      G     173          1.134
LGA    I   146_A      M     174          0.882
LGA    I   147_A      M     175          0.803
LGA    S   148_A      T     176          0.770
LGA    D   149_A      D     177          0.846
LGA    S   150_A      T     178          1.073
LGA    L   151_A      G     179          0.995
LGA    L   152_A      G     180          1.171
LGA    F   153_A      F     181          0.656
LGA    K   154_A      T     182          0.793
LGA    S   155_A      Y     183          1.514
LGA    P   156_A      N     184          2.661
LGA    T   157_A      S     185           #
LGA    C   158_A      N     186           #
LGA    T   159_A      N     187          3.364
LGA    D   160_A      R     188          3.037
LGA    Q   161_A      E     189          3.083
LGA    D   162_A      I     190          2.850
LGA    V   163_A      Y     191          3.182
LGA    A   164_A      F     192          2.730
LGA    A   165_A      I     193          1.719
LGA    A   166_A      I     194          2.170
LGA    K   167_A      S     195          2.638
LGA    E   168_A      E     196          1.789
LGA    L   169_A      L     197          1.034
LGA    A   170_A      L     198          2.489
LGA    E   171_A      S     199          2.827
LGA    I   172_A      K     200          1.128
LGA    A   173_A      G     201          2.953
LGA    G   174_A      I     202          3.199
LGA    V   175_A      D     203          1.650
LGA    D   176_A      K     204          4.099
LGA    A   177_A      -       -           -
LGA    E   178_A      -       -           -
LGA    E   179_A      D     205          2.361
LGA    Y   180_A      D     206          2.812
LGA    G   181_A      I     207          4.580
LGA    L   182_A      Y     208          3.497
LGA    N   183_A      R     209          0.951
LGA    M   184_A      K     210          3.204
LGA    L   185_A      V     211          3.829
LGA    K   186_A      Y     212          1.936
LGA    -       -      N     213           -
LGA    A   187_A      T     214          2.705
LGA    G   188_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  187  213    5.0    173    2.37    15.61     56.486     7.004

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.978908 * X  +   0.051749 * Y  +   0.197638 * Z  +  13.859181
  Y_new =  -0.146542 * X  +   0.496202 * Y  +  -0.855750 * Z  +  62.717308
  Z_new =  -0.142353 * X  +  -0.866663 * Y  +  -0.478153 * Z  +  47.800415 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.074957    1.066635  [ DEG:  -118.8863     61.1137 ]
  Theta =   0.142838    2.998755  [ DEG:     8.1840    171.8160 ]
  Phi   =  -2.992997    0.148596  [ DEG:  -171.4861      8.5139 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wpn_A                                        
REMARK     2: T0501_2_214.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wpn_A.T0501_2_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  187  213   5.0  173   2.37   15.61  56.486
REMARK  ---------------------------------------------------------- 
MOLECULE 1wpn_A
HEADER    HYDROLASE                               09-SEP-04   1WPN              
TITLE     CRYSTAL STRUCTURE OF THE N-TERMINAL CORE OF BACILLUS                  
TITLE    2 SUBTILIS INORGANIC PYROPHOSPHATASE                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MANGANESE-DEPENDENT INORGANIC PYROPHOSPHATASE;             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN;                                         
COMPND   5 SYNONYM: PYROPHOSPHATE PHOSPHO-HYDROLASE, PPASE;                     
COMPND   6 EC: 3.6.1.1;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-3A                                    
KEYWDS    INORGANIC PYROPHOSPHATASE, METAL BINDING                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    I.P.FABRICHNIY,L.LEHTIO,A.SALMINEN,A.A.BAYKOV,R.LAHTI,                
AUTHOR   2 A.GOLDMAN                                                            
REVDAT   1   23-NOV-04 1WPN    0                                                
JRNL        AUTH   I.P.FABRICHNIY,L.LEHTIO,A.SALMINEN,A.B.ZYRYANOV,             
JRNL        AUTH 2 A.A.BAYKOV,R.LAHTI,A.GOLDMAN                                 
JRNL        TITL   STRUCTURAL STUDIES OF METAL IONS IN FAMILY II                
JRNL        TITL 2 PYROPHOSPHATASES: THE REQUIREMENT FOR A JANUS ION            
JRNL        REF    BIOCHEMISTRY                  V.  43 14403 2004              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 1.30 ANGSTROMS.                                          
DBREF  1WPN A    1   188  UNP    P37487   PPAC_BACSU       1    188             
DBREF  1WPN B    1   188  UNP    P37487   PPAC_BACSU       1    188             
SEQRES   1 A  188  MET GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 A  188  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 A  188  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 A  188  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 A  188  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 A  188  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 A  188  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 A  188  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 A  188  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 A  188  CYS THR ALA THR ILE LEU ASN LYS MET TYR LYS GLU ASN          
SEQRES  11 A  188  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MET LEU          
SEQRES  12 A  188  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 A  188  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 A  188  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 A  188  ASN MET LEU LYS ALA GLY                                      
SEQRES   1 B  188  MET GLU LYS ILE LEU ILE PHE GLY HIS GLN ASN PRO ASP          
SEQRES   2 B  188  THR ASP THR ILE CYS SER ALA ILE ALA TYR ALA ASP LEU          
SEQRES   3 B  188  LYS ASN LYS LEU GLY PHE ASN ALA GLU PRO VAL ARG LEU          
SEQRES   4 B  188  GLY GLN VAL ASN GLY GLU THR GLN TYR ALA LEU ASP TYR          
SEQRES   5 B  188  PHE LYS GLN GLU SER PRO ARG LEU VAL GLU THR ALA ALA          
SEQRES   6 B  188  ASN GLU VAL ASN GLY VAL ILE LEU VAL ASP HIS ASN GLU          
SEQRES   7 B  188  ARG GLN GLN SER ILE LYS ASP ILE GLU GLU VAL GLN VAL          
SEQRES   8 B  188  LEU GLU VAL ILE ASP HIS HIS ARG ILE ALA ASN PHE GLU          
SEQRES   9 B  188  THR ALA GLU PRO LEU TYR TYR ARG ALA GLU PRO VAL GLY          
SEQRES  10 B  188  CYS THR ALA THR ILE LEU ASN LYS MET TYR LYS GLU ASN          
SEQRES  11 B  188  ASN VAL LYS ILE GLU LYS GLU ILE ALA GLY LEU MET LEU          
SEQRES  12 B  188  SER ALA ILE ILE SER ASP SER LEU LEU PHE LYS SER PRO          
SEQRES  13 B  188  THR CYS THR ASP GLN ASP VAL ALA ALA ALA LYS GLU LEU          
SEQRES  14 B  188  ALA GLU ILE ALA GLY VAL ASP ALA GLU GLU TYR GLY LEU          
SEQRES  15 B  188  ASN MET LEU LYS ALA GLY                                      
HET     MN  A 601       1                                                       
HET     MN  A 602       1                                                       
HET     MN  B 603       1                                                       
HET     MN  B 604       1                                                       
HET    SO4    701       5                                                       
HET    SO4    702       5                                                       
HET    SO4    703       5                                                       
HETNAM      MN MANGANESE (II) ION                                               
HETNAM     SO4 SULFATE ION                                                      
FORMUL   3   MN    4(MN 2+)                                                     
FORMUL   7  SO4    3(O4 S 2-)                                                   
FORMUL  10  HOH   *512(H2 O)                                                    
CRYST1   48.140   60.970   74.060  90.00  99.99  90.00 P 1 21 1      4          
ATOM      1  N   GLU A   2       8.730  47.526  58.440  1.00 28.69           N  
ATOM      2  CA  GLU A   2       8.557  48.981  58.201  1.00 27.52           C  
ATOM      3  C   GLU A   2       7.169  49.317  57.604  1.00 24.75           C  
ATOM      4  O   GLU A   2       6.669  48.630  56.696  1.00 24.31           O  
ATOM      5  CB  GLU A   2       9.665  49.493  57.284  1.00 29.86           C  
ATOM      6  CG  GLU A   2       9.310  50.765  56.550  1.00 33.61           C  
ATOM      7  CD  GLU A   2      10.478  51.646  56.183  1.00 39.06           C  
ATOM      8  OE1 GLU A   2      10.525  52.806  56.677  1.00 40.17           O  
ATOM      9  OE2 GLU A   2      11.323  51.200  55.373  1.00 42.39           O  
ATOM     10  N   LYS A   3       6.580  50.395  58.110  1.00 20.73           N  
ATOM     11  CA  LYS A   3       5.204  50.764  57.750  1.00 19.07           C  
ATOM     12  C   LYS A   3       5.100  51.307  56.338  1.00 17.83           C  
ATOM     13  O   LYS A   3       5.897  52.141  55.923  1.00 19.27           O  
ATOM     14  CB  LYS A   3       4.736  51.850  58.741  1.00 19.04           C  
ATOM     15  CG  LYS A   3       3.354  52.357  58.561  1.00 21.95           C  
ATOM     16  CD  LYS A   3       2.370  51.285  58.873  1.00 23.53           C  
ATOM     17  CE  LYS A   3       0.916  51.768  58.600  1.00 23.33           C  
ATOM     18  NZ  LYS A   3       0.469  52.958  59.405  1.00 22.88           N  
ATOM     19  N   ILE A   4       4.080  50.859  55.612  1.00 15.63           N  
ATOM     20  CA  ILE A   4       3.751  51.445  54.308  1.00 15.27           C  
ATOM     21  C   ILE A   4       2.276  51.863  54.273  1.00 13.22           C  
ATOM     22  O   ILE A   4       1.450  51.310  54.991  1.00 13.76           O  
ATOM     23  CB  ILE A   4       4.084  50.473  53.203  1.00 14.35           C  
ATOM     24  CG1 ILE A   4       3.220  49.254  53.268  1.00 16.47           C  
ATOM     25  CG2 ILE A   4       5.558  50.038  53.214  1.00 17.64           C  
ATOM     26  CD1 ILE A   4       3.522  48.319  52.081  1.00 21.04           C  
ATOM     27  N   LEU A   5       1.982  52.872  53.457  1.00 11.19           N  
ATOM     28  CA  LEU A   5       0.617  53.263  53.158  1.00  9.44           C  
ATOM     29  C   LEU A   5       0.200  52.805  51.781  1.00  9.19           C  
ATOM     30  O   LEU A   5       1.011  52.843  50.852  1.00  9.95           O  
ATOM     31  CB  LEU A   5       0.440  54.766  53.250  1.00  9.83           C  
ATOM     32  CG  LEU A   5       0.835  55.458  54.576  1.00 11.38           C  
ATOM     33  CD1 LEU A   5       0.628  56.971  54.537  1.00 12.81           C  
ATOM     34  CD2 LEU A   5       0.075  54.803  55.730  1.00 13.21           C  
ATOM     35  N   ILE A   6      -1.036  52.355  51.652  1.00  9.10           N  
ATOM     36  CA  ILE A   6      -1.615  51.889  50.353  1.00  8.44           C  
ATOM     37  C   ILE A   6      -2.803  52.784  50.061  1.00  8.47           C  
ATOM     38  O   ILE A   6      -3.692  52.884  50.896  1.00  9.27           O  
ATOM     39  CB  ILE A   6      -2.078  50.421  50.399  1.00  8.16           C  
ATOM     40  CG1 ILE A   6      -0.916  49.567  50.893  1.00  9.61           C  
ATOM     41  CG2 ILE A   6      -2.601  50.012  49.030  1.00  9.76           C  
ATOM     42  CD1 ILE A   6      -1.091  48.073  50.662  1.00 11.85           C  
ATOM     43  N   PHE A   7      -2.877  53.386  48.878  1.00  8.10           N  
ATOM     44  CA  PHE A   7      -4.004  54.285  48.587  1.00  8.36           C  
ATOM     45  C   PHE A   7      -4.273  54.302  47.087  1.00  7.64           C  
ATOM     46  O   PHE A   7      -3.360  54.063  46.250  1.00  8.00           O  
ATOM     47  CB  PHE A   7      -3.826  55.730  49.120  1.00  9.17           C  
ATOM     48  CG  PHE A   7      -2.478  56.326  48.812  1.00  8.75           C  
ATOM     49  CD1 PHE A   7      -2.261  57.067  47.653  1.00  9.18           C  
ATOM     50  CD2 PHE A   7      -1.430  56.147  49.703  1.00  9.53           C  
ATOM     51  CE1 PHE A   7      -1.015  57.600  47.387  1.00 10.34           C  
ATOM     52  CE2 PHE A   7      -0.197  56.715  49.440  1.00 10.65           C  
ATOM     53  CZ  PHE A   7       0.005  57.449  48.290  1.00 10.31           C  
ATOM     54  N   GLY A   8      -5.524  54.614  46.767  1.00  7.73           N  
ATOM     55  CA  GLY A   8      -5.925  54.964  45.424  1.00  7.47           C  
ATOM     56  C   GLY A   8      -5.954  56.472  45.211  1.00  8.29           C  
ATOM     57  O   GLY A   8      -5.238  57.238  45.900  1.00  9.20           O  
ATOM     58  N   HIS A   9      -6.713  56.867  44.186  1.00  7.61           N  
ATOM     59  CA  HIS A   9      -6.617  58.246  43.723  1.00  8.94           C  
ATOM     60  C   HIS A   9      -7.423  59.275  44.533  1.00  9.08           C  
ATOM     61  O   HIS A   9      -8.315  58.937  45.327  1.00  9.67           O  
ATOM     62  CB  HIS A   9      -7.024  58.367  42.233  1.00  9.56           C  
ATOM     63  CG  HIS A   9      -8.322  57.686  41.866  1.00  7.69           C  
ATOM     64  ND1 HIS A   9      -9.561  58.186  42.243  1.00  8.47           N  
ATOM     65  CD2 HIS A   9      -8.576  56.544  41.174  1.00  8.95           C  
ATOM     66  CE1 HIS A   9     -10.521  57.378  41.782  1.00  8.07           C  
ATOM     67  NE2 HIS A   9      -9.949  56.372  41.126  1.00  8.01           N  
ATOM     68  N   GLN A  10      -7.118  60.549  44.285  0.50 10.45           N  
ATOM     70  CA  GLN A  10      -7.966  61.688  44.726  0.50 11.73           C  
ATOM     72  C   GLN A  10      -9.345  61.514  44.128  0.50 12.00           C  
ATOM     74  O   GLN A  10      -9.488  60.886  43.085  0.50 12.28           O  
ATOM     76  CB  GLN A  10      -7.399  63.012  44.200  0.50 12.37           C  
ATOM     78  CG  GLN A  10      -6.053  63.387  44.747  0.50 11.50           C  
ATOM     80  CD  GLN A  10      -5.592  64.771  44.289  0.50 11.02           C  
ATOM     82  OE1 GLN A  10      -6.367  65.763  44.361  0.50 14.46           O  
ATOM     84  NE2 GLN A  10      -4.341  64.867  43.870  0.50 12.95           N  
ATOM     86  N   ASN A  11     -10.354  62.123  44.760  1.00 12.67           N  
ATOM     87  CA  ASN A  11     -11.757  61.915  44.364  1.00 13.21           C  
ATOM     88  C   ASN A  11     -12.091  60.408  44.344  1.00 12.27           C  
ATOM     89  O   ASN A  11     -12.349  59.805  43.286  1.00 12.58           O  
ATOM     90  CB  ASN A  11     -12.094  62.595  43.034  1.00 15.58           C  
ATOM     91  CG  ASN A  11     -11.802  64.072  43.071  1.00 22.09           C  
ATOM     92  OD1 ASN A  11     -12.165  64.775  44.043  1.00 26.63           O  
ATOM     93  ND2 ASN A  11     -11.172  64.570  42.009  1.00 26.97           N  
ATOM     94  N   PRO A  12     -11.961  59.773  45.496  1.00 11.45           N  
ATOM     95  CA  PRO A  12     -12.007  58.300  45.500  1.00 12.14           C  
ATOM     96  C   PRO A  12     -13.296  57.701  44.965  1.00 10.47           C  
ATOM     97  O   PRO A  12     -14.400  58.269  45.257  1.00 12.12           O  
ATOM     98  CB  PRO A  12     -11.880  57.931  46.987  1.00 12.07           C  
ATOM     99  CG  PRO A  12     -11.840  59.202  47.736  1.00 14.14           C  
ATOM    100  CD  PRO A  12     -11.706  60.332  46.827  1.00 12.84           C  
ATOM    101  N   ASP A  13     -13.156  56.587  44.238  1.00  9.74           N  
ATOM    102  CA  ASP A  13     -14.306  55.794  43.875  1.00  9.71           C  
ATOM    103  C   ASP A  13     -14.213  54.474  44.658  1.00  8.40           C  
ATOM    104  O   ASP A  13     -13.255  54.223  45.410  1.00  8.89           O  
ATOM    105  CB  ASP A  13     -14.388  55.585  42.326  1.00  9.22           C  
ATOM    106  CG  ASP A  13     -13.092  55.110  41.728  1.00  8.68           C  
ATOM    107  OD1 ASP A  13     -12.828  55.363  40.485  1.00 11.02           O  
ATOM    108  OD2 ASP A  13     -12.286  54.402  42.373  1.00  9.96           O  
ATOM    109  N   THR A  14     -15.199  53.619  44.435  1.00  8.63           N  
ATOM    110  CA  THR A  14     -15.309  52.396  45.180  1.00  8.85           C  
ATOM    111  C   THR A  14     -14.096  51.488  44.936  1.00  8.93           C  
ATOM    112  O   THR A  14     -13.586  50.881  45.876  1.00  9.25           O  
ATOM    113  CB  THR A  14     -16.619  51.707  44.827  1.00  9.96           C  
ATOM    114  OG1 THR A  14     -17.692  52.527  45.239  1.00 11.00           O  
ATOM    115  CG2 THR A  14     -16.797  50.341  45.536  1.00 11.65           C  
ATOM    116  N   ASP A  15     -13.591  51.400  43.700  1.00  8.33           N  
ATOM    117  CA  ASP A  15     -12.418  50.567  43.455  1.00  7.88           C  
ATOM    118  C   ASP A  15     -11.226  51.122  44.254  1.00  8.60           C  
ATOM    119  O   ASP A  15     -10.449  50.359  44.819  1.00  8.77           O  
ATOM    120  CB  ASP A  15     -12.113  50.543  41.964  1.00  9.25           C  
ATOM    121  CG  ASP A  15     -11.058  49.528  41.587  1.00  8.85           C  
ATOM    122  OD1 ASP A  15     -10.900  48.502  42.298  1.00  9.51           O  
ATOM    123  OD2 ASP A  15     -10.403  49.699  40.533  1.00  8.49           O  
ATOM    124  N   THR A  16     -11.030  52.442  44.241  1.00  7.56           N  
ATOM    125  CA  THR A  16      -9.887  53.009  44.916  1.00  8.59           C  
ATOM    126  C   THR A  16      -9.937  52.802  46.421  1.00  8.45           C  
ATOM    127  O   THR A  16      -8.866  52.650  47.044  1.00  9.46           O  
ATOM    128  CB  THR A  16      -9.794  54.514  44.532  1.00  8.37           C  
ATOM    129  OG1 THR A  16      -8.724  54.708  43.605  1.00  8.91           O  
ATOM    130  CG2 THR A  16      -9.521  55.462  45.712  1.00 10.00           C  
ATOM    131  N   ILE A  17     -11.135  52.789  47.022  1.00  8.92           N  
ATOM    132  CA  ILE A  17     -11.197  52.537  48.457  1.00  8.53           C  
ATOM    133  C   ILE A  17     -11.064  51.033  48.745  1.00  8.57           C  
ATOM    134  O   ILE A  17     -10.269  50.613  49.600  1.00  9.32           O  
ATOM    135  CB  ILE A  17     -12.556  53.098  48.984  1.00  9.43           C  
ATOM    136  CG1 ILE A  17     -12.613  54.638  48.845  1.00 10.29           C  
ATOM    137  CG2 ILE A  17     -12.811  52.618  50.395  1.00 10.43           C  
ATOM    138  CD1 ILE A  17     -11.579  55.408  49.675  1.00 12.10           C  
ATOM    139  N   CYS A  18     -11.850  50.233  48.042  1.00  8.70           N  
ATOM    140  CA  CYS A  18     -11.932  48.814  48.324  1.00  9.72           C  
ATOM    141  C   CYS A  18     -10.631  48.088  47.973  1.00  8.83           C  
ATOM    142  O   CYS A  18     -10.215  47.185  48.713  1.00  9.75           O  
ATOM    143  CB  CYS A  18     -13.133  48.230  47.570  1.00 10.32           C  
ATOM    144  SG  CYS A  18     -14.712  48.795  48.315  1.00 13.27           S  
ATOM    145  N   SER A  19      -9.979  48.487  46.871  1.00  8.96           N  
ATOM    146  CA  SER A  19      -8.719  47.837  46.499  1.00  8.89           C  
ATOM    147  C   SER A  19      -7.601  48.226  47.465  1.00  8.12           C  
ATOM    148  O   SER A  19      -6.716  47.424  47.696  1.00  9.28           O  
ATOM    149  CB  SER A  19      -8.334  48.189  45.074  1.00  9.81           C  
ATOM    150  OG  SER A  19      -9.153  47.455  44.188  1.00 11.49           O  
ATOM    151  N   ALA A  20      -7.624  49.426  48.044  1.00  8.67           N  
ATOM    152  CA  ALA A  20      -6.629  49.796  49.083  1.00  8.73           C  
ATOM    153  C   ALA A  20      -6.836  48.899  50.297  1.00  8.79           C  
ATOM    154  O   ALA A  20      -5.886  48.353  50.823  1.00  8.46           O  
ATOM    155  CB  ALA A  20      -6.770  51.293  49.453  1.00  9.04           C  
ATOM    156  N   ILE A  21      -8.085  48.719  50.743  1.00  9.14           N  
ATOM    157  CA  ILE A  21      -8.363  47.860  51.900  1.00  9.59           C  
ATOM    158  C   ILE A  21      -7.968  46.424  51.601  1.00  9.71           C  
ATOM    159  O   ILE A  21      -7.308  45.779  52.424  1.00 10.57           O  
ATOM    160  CB  ILE A  21      -9.843  47.918  52.269  1.00  9.85           C  
ATOM    161  CG1 ILE A  21     -10.163  49.327  52.786  1.00  9.83           C  
ATOM    162  CG2 ILE A  21     -10.196  46.893  53.332  1.00 10.76           C  
ATOM    163  CD1 ILE A  21     -11.672  49.582  52.922  1.00  9.88           C  
ATOM    164  N   ALA A  22      -8.320  45.907  50.409  1.00  9.26           N  
ATOM    165  CA  ALA A  22      -8.051  44.523  50.078  1.00 10.25           C  
ATOM    166  C   ALA A  22      -6.561  44.269  49.930  1.00 10.56           C  
ATOM    167  O   ALA A  22      -6.044  43.268  50.463  1.00 12.05           O  
ATOM    168  CB  ALA A  22      -8.826  44.124  48.797  1.00 10.94           C  
ATOM    169  N   TYR A  23      -5.826  45.158  49.252  1.00 10.18           N  
ATOM    170  CA  TYR A  23      -4.403  44.876  49.079  1.00 10.18           C  
ATOM    171  C   TYR A  23      -3.673  45.035  50.420  1.00 10.41           C  
ATOM    172  O   TYR A  23      -2.749  44.287  50.697  1.00 12.04           O  
ATOM    173  CB  TYR A  23      -3.751  45.730  47.994  1.00 10.09           C  
ATOM    174  CG  TYR A  23      -2.425  45.170  47.525  1.00  8.54           C  
ATOM    175  CD1 TYR A  23      -2.180  43.779  47.455  1.00 12.93           C  
ATOM    176  CD2 TYR A  23      -1.442  46.026  47.093  1.00 10.35           C  
ATOM    177  CE1 TYR A  23      -0.930  43.255  47.005  1.00 14.09           C  
ATOM    178  CE2 TYR A  23      -0.189  45.525  46.624  1.00  9.79           C  
ATOM    179  CZ  TYR A  23       0.059  44.133  46.587  1.00 10.22           C  
ATOM    180  OH  TYR A  23       1.252  43.632  46.144  1.00 12.57           O  
ATOM    181  N   ALA A  24      -4.103  45.940  51.300  1.00  9.94           N  
ATOM    182  CA  ALA A  24      -3.467  46.013  52.631  1.00  9.88           C  
ATOM    183  C   ALA A  24      -3.720  44.698  53.388  1.00 11.75           C  
ATOM    184  O   ALA A  24      -2.824  44.189  54.078  1.00 12.67           O  
ATOM    185  CB  ALA A  24      -3.969  47.223  53.393  1.00 10.87           C  
ATOM    186  N   ASP A  25      -4.911  44.115  53.247  1.00 12.85           N  
ATOM    187  CA  ASP A  25      -5.204  42.824  53.878  1.00 14.04           C  
ATOM    188  C   ASP A  25      -4.266  41.743  53.362  1.00 13.88           C  
ATOM    189  O   ASP A  25      -3.678  40.984  54.161  1.00 16.36           O  
ATOM    190  CB  ASP A  25      -6.647  42.428  53.617  1.00 14.77           C  
ATOM    191  CG  ASP A  25      -6.965  41.025  54.098  1.00 19.44           C  
ATOM    192  OD1 ASP A  25      -7.179  40.109  53.265  1.00 19.42           O  
ATOM    193  OD2 ASP A  25      -7.013  40.765  55.297  1.00 22.27           O  
ATOM    194  N   LEU A  26      -4.094  41.645  52.050  1.00 13.32           N  
ATOM    195  CA  LEU A  26      -3.179  40.675  51.487  1.00 13.70           C  
ATOM    196  C   LEU A  26      -1.770  40.885  51.965  1.00 15.01           C  
ATOM    197  O   LEU A  26      -1.137  39.915  52.416  1.00 16.30           O  
ATOM    198  CB  LEU A  26      -3.244  40.705  49.953  1.00 12.87           C  
ATOM    199  CG  LEU A  26      -2.330  39.743  49.196  1.00 12.87           C  
ATOM    200  CD1 LEU A  26      -2.487  38.266  49.679  1.00 15.29           C  
ATOM    201  CD2 LEU A  26      -2.577  39.853  47.667  1.00 14.74           C  
ATOM    202  N   LYS A  27      -1.280  42.117  51.915  0.50 14.75           N  
ATOM    204  CA  LYS A  27       0.068  42.429  52.386  0.50 15.64           C  
ATOM    206  C   LYS A  27       0.243  41.990  53.822  0.50 17.02           C  
ATOM    208  O   LYS A  27       1.210  41.303  54.184  0.50 17.37           O  
ATOM    210  CB  LYS A  27       0.253  43.942  52.340  0.50 14.80           C  
ATOM    212  CG  LYS A  27       0.793  44.456  51.066  0.50 15.22           C  
ATOM    214  CD  LYS A  27       1.939  43.613  50.597  0.50 17.30           C  
ATOM    216  CE  LYS A  27       2.387  44.145  49.252  0.50 15.51           C  
ATOM    218  NZ  LYS A  27       3.559  43.378  48.710  0.50 14.98           N  
ATOM    220  N   ASN A  28      -0.701  42.380  54.653  1.00 16.53           N  
ATOM    221  CA  ASN A  28      -0.615  42.071  56.095  1.00 18.71           C  
ATOM    222  C   ASN A  28      -0.651  40.565  56.354  1.00 19.62           C  
ATOM    223  O   ASN A  28       0.121  40.063  57.200  1.00 21.35           O  
ATOM    224  CB  ASN A  28      -1.664  42.833  56.891  1.00 17.18           C  
ATOM    225  CG  ASN A  28      -1.342  44.331  56.933  1.00 17.19           C  
ATOM    226  OD1 ASN A  28      -0.179  44.704  56.871  1.00 18.52           O  
ATOM    227  ND2 ASN A  28      -2.370  45.188  56.972  1.00 15.62           N  
ATOM    228  N   LYS A  29      -1.512  39.834  55.637  0.50 20.15           N  
ATOM    230  CA  LYS A  29      -1.528  38.373  55.732  0.50 21.30           C  
ATOM    232  C   LYS A  29      -0.147  37.797  55.369  0.50 22.05           C  
ATOM    234  O   LYS A  29       0.261  36.785  55.966  0.50 23.49           O  
ATOM    236  CB  LYS A  29      -2.650  37.745  54.874  0.50 20.56           C  
ATOM    238  CG  LYS A  29      -4.106  38.078  55.293  0.50 20.98           C  
ATOM    240  CD  LYS A  29      -4.632  37.297  56.506  0.50 20.82           C  
ATOM    242  CE  LYS A  29      -5.893  37.877  57.100  0.50 19.72           C  
ATOM    244  NZ  LYS A  29      -7.056  38.072  56.167  0.50 16.05           N  
ATOM    246  N   LEU A  30       0.595  38.445  54.465  1.00 23.24           N  
ATOM    247  CA  LEU A  30       1.906  37.958  53.980  1.00 24.45           C  
ATOM    248  C   LEU A  30       3.069  38.451  54.861  1.00 25.41           C  
ATOM    249  O   LEU A  30       4.240  38.303  54.479  1.00 27.73           O  
ATOM    250  CB  LEU A  30       2.164  38.357  52.507  1.00 24.36           C  
ATOM    251  CG  LEU A  30       1.248  37.735  51.441  1.00 25.15           C  
ATOM    252  CD1 LEU A  30       1.476  38.398  50.073  1.00 26.10           C  
ATOM    253  CD2 LEU A  30       1.470  36.193  51.388  1.00 26.75           C  
ATOM    254  N   GLY A  31       2.736  39.093  55.980  1.00 25.58           N  
ATOM    255  CA  GLY A  31       3.718  39.528  56.975  1.00 25.47           C  
ATOM    256  C   GLY A  31       4.268  40.949  56.874  1.00 25.80           C  
ATOM    257  O   GLY A  31       5.234  41.316  57.553  1.00 27.17           O  
ATOM    258  N   PHE A  32       3.627  41.799  56.072  1.00 23.41           N  
ATOM    259  CA  PHE A  32       4.092  43.171  55.939  1.00 22.49           C  
ATOM    260  C   PHE A  32       3.328  44.057  56.927  1.00 19.50           C  
ATOM    261  O   PHE A  32       2.579  43.585  57.780  1.00 18.80           O  
ATOM    262  CB  PHE A  32       3.949  43.666  54.480  1.00 23.54           C  
ATOM    263  CG  PHE A  32       4.840  42.921  53.498  1.00 26.85           C  
ATOM    264  CD1 PHE A  32       4.361  41.806  52.797  1.00 27.67           C  
ATOM    265  CD2 PHE A  32       6.155  43.324  53.291  1.00 29.88           C  
ATOM    266  CE1 PHE A  32       5.177  41.116  51.888  1.00 30.25           C  
ATOM    267  CE2 PHE A  32       6.999  42.623  52.378  1.00 31.65           C  
ATOM    268  CZ  PHE A  32       6.499  41.517  51.686  1.00 31.33           C  
ATOM    269  N   ASN A  33       3.552  45.346  56.817  1.00 17.44           N  
ATOM    270  CA  ASN A  33       2.960  46.288  57.756  1.00 16.51           C  
ATOM    271  C   ASN A  33       2.349  47.449  56.962  1.00 15.64           C  
ATOM    272  O   ASN A  33       2.997  48.475  56.720  1.00 16.43           O  
ATOM    273  CB  ASN A  33       4.020  46.788  58.771  1.00 17.25           C  
ATOM    274  CG  ASN A  33       3.475  47.779  59.773  1.00 19.08           C  
ATOM    275  OD1 ASN A  33       2.262  47.912  59.975  1.00 19.01           O  
ATOM    276  ND2 ASN A  33       4.414  48.487  60.459  1.00 21.28           N  
ATOM    277  N   ALA A  34       1.093  47.257  56.567  1.00 14.14           N  
ATOM    278  CA  ALA A  34       0.469  48.119  55.589  1.00 13.08           C  
ATOM    279  C   ALA A  34      -0.805  48.681  56.177  1.00 12.50           C  
ATOM    280  O   ALA A  34      -1.547  47.953  56.872  1.00 15.08           O  
ATOM    281  CB  ALA A  34       0.118  47.361  54.301  1.00 13.00           C  
ATOM    282  N   GLU A  35      -1.101  49.948  55.880  1.00 11.35           N  
ATOM    283  CA  GLU A  35      -2.392  50.576  56.258  1.00 11.25           C  
ATOM    284  C   GLU A  35      -3.032  51.122  54.989  1.00 10.23           C  
ATOM    285  O   GLU A  35      -2.365  51.871  54.269  1.00 10.80           O  
ATOM    286  CB  GLU A  35      -2.251  51.739  57.282  1.00 11.95           C  
ATOM    287  CG  GLU A  35      -3.570  52.355  57.672  1.00 14.18           C  
ATOM    288  CD  GLU A  35      -3.407  53.532  58.578  1.00 15.46           C  
ATOM    289  OE1 GLU A  35      -2.272  53.867  58.986  1.00 18.01           O  
ATOM    290  OE2 GLU A  35      -4.440  54.151  58.895  1.00 15.37           O  
ATOM    291  N   PRO A  36      -4.306  50.807  54.720  1.00 10.31           N  
ATOM    292  CA  PRO A  36      -5.002  51.431  53.599  1.00  9.63           C  
ATOM    293  C   PRO A  36      -5.428  52.831  54.017  1.00  9.48           C  
ATOM    294  O   PRO A  36      -5.928  53.035  55.158  1.00 11.45           O  
ATOM    295  CB  PRO A  36      -6.248  50.561  53.412  1.00  9.84           C  
ATOM    296  CG  PRO A  36      -6.546  50.005  54.812  1.00 10.18           C  
ATOM    297  CD  PRO A  36      -5.198  49.939  55.517  1.00  9.75           C  
ATOM    298  N   VAL A  37      -5.231  53.828  53.156  1.00  8.99           N  
ATOM    299  CA  VAL A  37      -5.652  55.188  53.444  1.00  8.79           C  
ATOM    300  C   VAL A  37      -6.408  55.740  52.241  1.00  8.63           C  
ATOM    301  O   VAL A  37      -6.490  55.040  51.201  1.00  9.74           O  
ATOM    302  CB  VAL A  37      -4.484  56.136  53.898  1.00  9.45           C  
ATOM    303  CG1 VAL A  37      -3.830  55.606  55.194  1.00 10.95           C  
ATOM    304  CG2 VAL A  37      -3.410  56.232  52.788  1.00 11.02           C  
ATOM    305  N   ARG A  38      -7.009  56.923  52.411  1.00  9.34           N  
ATOM    306  CA  ARG A  38      -7.739  57.589  51.331  1.00  9.68           C  
ATOM    307  C   ARG A  38      -7.326  59.024  51.198  1.00  9.57           C  
ATOM    308  O   ARG A  38      -6.796  59.605  52.166  1.00 10.57           O  
ATOM    309  CB  ARG A  38      -9.238  57.470  51.515  1.00 10.49           C  
ATOM    310  CG  ARG A  38      -9.797  58.145  52.727  1.00 11.43           C  
ATOM    311  CD  ARG A  38     -11.290  57.850  52.872  1.00 12.46           C  
ATOM    312  NE  ARG A  38     -11.718  58.219  54.215  1.00 14.52           N  
ATOM    313  CZ  ARG A  38     -12.192  59.395  54.553  1.00 13.75           C  
ATOM    314  NH1 ARG A  38     -12.367  60.352  53.653  1.00 16.98           N  
ATOM    315  NH2 ARG A  38     -12.497  59.624  55.827  1.00 17.82           N  
ATOM    316  N   LEU A  39      -7.588  59.576  50.015  1.00  9.64           N  
ATOM    317  CA  LEU A  39      -7.158  60.936  49.686  1.00 10.85           C  
ATOM    318  C   LEU A  39      -8.302  61.917  49.583  1.00 12.39           C  
ATOM    319  O   LEU A  39      -8.061  63.086  49.292  1.00 13.81           O  
ATOM    320  CB  LEU A  39      -6.379  60.951  48.356  1.00 11.08           C  
ATOM    321  CG  LEU A  39      -5.155  60.026  48.281  1.00 10.68           C  
ATOM    322  CD1 LEU A  39      -4.371  60.226  46.957  1.00 11.39           C  
ATOM    323  CD2 LEU A  39      -4.209  60.160  49.471  1.00 12.64           C  
ATOM    324  N   GLY A  40      -9.550  61.485  49.785  1.00 11.06           N  
ATOM    325  CA  GLY A  40     -10.685  62.413  49.786  1.00 12.16           C  
ATOM    326  C   GLY A  40     -11.886  61.706  50.382  1.00 13.10           C  
ATOM    327  O   GLY A  40     -11.803  60.596  50.918  1.00 13.12           O  
ATOM    328  N   GLN A  41     -13.029  62.351  50.263  1.00 14.47           N  
ATOM    329  CA  GLN A  41     -14.258  61.852  50.861  1.00 15.47           C  
ATOM    330  C   GLN A  41     -14.833  60.629  50.150  1.00 15.16           C  
ATOM    331  O   GLN A  41     -14.738  60.501  48.927  1.00 18.40           O  
ATOM    332  CB  GLN A  41     -15.307  62.995  50.983  1.00 18.57           C  
ATOM    333  CG  GLN A  41     -15.840  63.510  49.745  1.00 26.31           C  
ATOM    334  CD  GLN A  41     -16.854  64.616  50.015  1.00 33.06           C  
ATOM    335  OE1 GLN A  41     -18.032  64.339  50.302  1.00 35.96           O  
ATOM    336  NE2 GLN A  41     -16.397  65.868  49.949  1.00 36.00           N  
ATOM    337  N   VAL A  42     -15.448  59.751  50.934  1.00 13.77           N  
ATOM    338  CA  VAL A  42     -16.080  58.522  50.440  1.00 14.88           C  
ATOM    339  C   VAL A  42     -17.464  58.868  49.913  1.00 15.02           C  
ATOM    340  O   VAL A  42     -18.259  59.527  50.632  1.00 16.47           O  
ATOM    341  CB  VAL A  42     -16.168  57.503  51.625  1.00 16.07           C  
ATOM    342  CG1 VAL A  42     -16.958  56.268  51.307  1.00 17.78           C  
ATOM    343  CG2 VAL A  42     -14.764  57.063  52.065  1.00 15.93           C  
ATOM    344  N   ASN A  43     -17.786  58.458  48.705  1.00 13.50           N  
ATOM    345  CA  ASN A  43     -19.121  58.696  48.164  1.00 13.67           C  
ATOM    346  C   ASN A  43     -20.178  57.683  48.671  1.00 13.59           C  
ATOM    347  O   ASN A  43     -19.849  56.706  49.363  1.00 13.04           O  
ATOM    348  CB  ASN A  43     -19.066  58.788  46.603  1.00 14.08           C  
ATOM    349  CG  ASN A  43     -18.809  57.416  45.908  1.00 13.96           C  
ATOM    350  OD1 ASN A  43     -19.371  56.416  46.304  1.00 15.25           O  
ATOM    351  ND2 ASN A  43     -17.994  57.394  44.819  1.00 13.20           N  
ATOM    352  N   GLY A  44     -21.457  57.942  48.353  1.00 14.22           N  
ATOM    353  CA  GLY A  44     -22.500  57.078  48.883  1.00 13.66           C  
ATOM    354  C   GLY A  44     -22.523  55.655  48.404  1.00 13.37           C  
ATOM    355  O   GLY A  44     -22.952  54.758  49.103  1.00 14.38           O  
ATOM    356  N   GLU A  45     -22.071  55.451  47.166  1.00 12.64           N  
ATOM    357  CA  GLU A  45     -21.935  54.115  46.676  1.00 12.66           C  
ATOM    358  C   GLU A  45     -20.893  53.317  47.478  1.00 12.54           C  
ATOM    359  O   GLU A  45     -21.167  52.219  47.932  1.00 12.35           O  
ATOM    360  CB  GLU A  45     -21.468  54.152  45.223  1.00 14.32           C  
ATOM    361  CG  GLU A  45     -21.339  52.800  44.538  1.00 13.72           C  
ATOM    362  CD  GLU A  45     -20.618  52.932  43.224  1.00 13.59           C  
ATOM    363  OE1 GLU A  45     -19.384  52.966  43.246  1.00 13.60           O  
ATOM    364  OE2 GLU A  45     -21.261  53.099  42.199  1.00 16.94           O  
ATOM    365  N   THR A  46     -19.703  53.884  47.630  1.00 10.89           N  
ATOM    366  CA  THR A  46     -18.674  53.248  48.425  1.00 10.90           C  
ATOM    367  C   THR A  46     -19.132  53.063  49.885  1.00 10.32           C  
ATOM    368  O   THR A  46     -18.884  52.004  50.474  1.00 10.88           O  
ATOM    369  CB  THR A  46     -17.446  54.102  48.426  1.00 10.25           C  
ATOM    370  OG1 THR A  46     -17.031  54.391  47.084  1.00 11.97           O  
ATOM    371  CG2 THR A  46     -16.287  53.357  49.113  1.00 11.33           C  
ATOM    372  N   GLN A  47     -19.848  54.074  50.420  1.00 10.61           N  
ATOM    373  CA  GLN A  47     -20.307  53.979  51.802  1.00 12.32           C  
ATOM    374  C   GLN A  47     -21.270  52.795  51.987  1.00 12.87           C  
ATOM    375  O   GLN A  47     -21.225  52.121  53.022  1.00 12.49           O  
ATOM    376  CB  GLN A  47     -20.959  55.262  52.271  1.00 13.27           C  
ATOM    377  CG  GLN A  47     -21.183  55.331  53.811  1.00 11.74           C  
ATOM    378  CD  GLN A  47     -19.873  55.382  54.532  1.00 12.71           C  
ATOM    379  OE1 GLN A  47     -19.061  56.267  54.237  1.00 14.94           O  
ATOM    380  NE2 GLN A  47     -19.607  54.421  55.405  1.00 11.86           N  
ATOM    381  N   TYR A  48     -22.146  52.545  51.006  1.00 12.58           N  
ATOM    382  CA  TYR A  48     -22.996  51.363  51.066  1.00 12.56           C  
ATOM    383  C   TYR A  48     -22.213  50.064  51.195  1.00 12.14           C  
ATOM    384  O   TYR A  48     -22.530  49.182  51.994  1.00 12.37           O  
ATOM    385  CB  TYR A  48     -23.906  51.295  49.827  1.00 13.97           C  
ATOM    386  CG  TYR A  48     -24.945  50.177  49.887  1.00 14.70           C  
ATOM    387  CD1 TYR A  48     -26.220  50.425  50.417  1.00 15.59           C  
ATOM    388  CD2 TYR A  48     -24.650  48.886  49.460  1.00 14.51           C  
ATOM    389  CE1 TYR A  48     -27.159  49.368  50.474  1.00 16.78           C  
ATOM    390  CE2 TYR A  48     -25.578  47.842  49.516  1.00 15.12           C  
ATOM    391  CZ  TYR A  48     -26.811  48.107  50.030  1.00 16.74           C  
ATOM    392  OH  TYR A  48     -27.702  47.037  50.091  1.00 20.32           O  
ATOM    393  N   ALA A  49     -21.138  49.954  50.396  1.00 11.83           N  
ATOM    394  CA  ALA A  49     -20.343  48.754  50.401  1.00 10.63           C  
ATOM    395  C   ALA A  49     -19.637  48.604  51.754  1.00 10.91           C  
ATOM    396  O   ALA A  49     -19.604  47.532  52.317  1.00 12.02           O  
ATOM    397  CB  ALA A  49     -19.271  48.777  49.285  1.00 11.81           C  
ATOM    398  N   LEU A  50     -19.058  49.698  52.251  1.00 10.37           N  
ATOM    399  CA  LEU A  50     -18.360  49.619  53.543  1.00 11.56           C  
ATOM    400  C   LEU A  50     -19.346  49.230  54.651  1.00 10.86           C  
ATOM    401  O   LEU A  50     -19.049  48.494  55.554  1.00 12.38           O  
ATOM    402  CB  LEU A  50     -17.763  50.981  53.858  1.00 10.46           C  
ATOM    403  CG  LEU A  50     -16.574  51.431  53.004  1.00 10.14           C  
ATOM    404  CD1 LEU A  50     -16.222  52.887  53.332  1.00 12.69           C  
ATOM    405  CD2 LEU A  50     -15.360  50.434  53.123  1.00 10.87           C  
ATOM    406  N   ASP A  51     -20.543  49.806  54.606  1.00 11.56           N  
ATOM    407  CA  ASP A  51     -21.508  49.524  55.666  1.00 12.45           C  
ATOM    408  C   ASP A  51     -22.040  48.102  55.547  1.00 12.84           C  
ATOM    409  O   ASP A  51     -22.205  47.405  56.550  1.00 15.22           O  
ATOM    410  CB  ASP A  51     -22.674  50.471  55.571  1.00 12.96           C  
ATOM    411  CG  ASP A  51     -22.311  51.880  55.887  1.00 13.21           C  
ATOM    412  OD1 ASP A  51     -23.172  52.770  55.659  1.00 16.59           O  
ATOM    413  OD2 ASP A  51     -21.195  52.184  56.385  1.00 12.65           O  
ATOM    414  N   TYR A  52     -22.286  47.633  54.319  1.00 12.55           N  
ATOM    415  CA  TYR A  52     -22.839  46.308  54.121  1.00 13.82           C  
ATOM    416  C   TYR A  52     -21.868  45.233  54.603  1.00 14.37           C  
ATOM    417  O   TYR A  52     -22.278  44.246  55.227  1.00 15.61           O  
ATOM    418  CB  TYR A  52     -23.156  46.101  52.618  1.00 14.72           C  
ATOM    419  CG  TYR A  52     -24.020  44.885  52.362  1.00 13.97           C  
ATOM    420  CD1 TYR A  52     -23.490  43.582  52.377  1.00 14.96           C  
ATOM    421  CD2 TYR A  52     -25.394  45.058  52.179  1.00 16.54           C  
ATOM    422  CE1 TYR A  52     -24.325  42.433  52.175  1.00 13.90           C  
ATOM    423  CE2 TYR A  52     -26.227  43.931  51.969  1.00 16.35           C  
ATOM    424  CZ  TYR A  52     -25.676  42.652  51.965  1.00 16.15           C  
ATOM    425  OH  TYR A  52     -26.511  41.570  51.784  1.00 19.19           O  
ATOM    426  N   PHE A  53     -20.585  45.420  54.293  1.00 13.52           N  
ATOM    427  CA  PHE A  53     -19.551  44.438  54.637  1.00 13.07           C  
ATOM    428  C   PHE A  53     -18.786  44.799  55.923  1.00 13.85           C  
ATOM    429  O   PHE A  53     -17.763  44.209  56.210  1.00 14.44           O  
ATOM    430  CB  PHE A  53     -18.626  44.203  53.424  1.00 13.48           C  
ATOM    431  CG  PHE A  53     -19.363  43.525  52.317  1.00 13.79           C  
ATOM    432  CD1 PHE A  53     -19.774  44.227  51.186  1.00 13.38           C  
ATOM    433  CD2 PHE A  53     -19.774  42.205  52.477  1.00 13.91           C  
ATOM    434  CE1 PHE A  53     -20.491  43.585  50.183  1.00 15.00           C  
ATOM    435  CE2 PHE A  53     -20.530  41.564  51.502  1.00 15.70           C  
ATOM    436  CZ  PHE A  53     -20.872  42.235  50.349  1.00 15.16           C  
ATOM    437  N   LYS A  54     -19.332  45.724  56.713  1.00 13.62           N  
ATOM    438  CA  LYS A  54     -18.847  46.023  58.081  1.00 14.11           C  
ATOM    439  C   LYS A  54     -17.350  46.339  58.078  1.00 12.83           C  
ATOM    440  O   LYS A  54     -16.548  45.807  58.869  1.00 12.67           O  
ATOM    441  CB  LYS A  54     -19.194  44.868  59.016  1.00 15.82           C  
ATOM    442  CG  LYS A  54     -20.686  44.684  59.176  1.00 20.13           C  
ATOM    443  CD  LYS A  54     -20.938  43.441  60.070  1.00 26.57           C  
ATOM    444  CE  LYS A  54     -22.217  42.748  59.703  1.00 32.32           C  
ATOM    445  NZ  LYS A  54     -23.389  43.628  60.011  1.00 35.84           N  
ATOM    446  N   GLN A  55     -16.975  47.256  57.192  1.00 12.91           N  
ATOM    447  CA  GLN A  55     -15.592  47.721  57.060  1.00 11.89           C  
ATOM    448  C   GLN A  55     -15.579  49.231  57.332  1.00 11.35           C  
ATOM    449  O   GLN A  55     -16.471  49.983  56.923  1.00 12.88           O  
ATOM    450  CB  GLN A  55     -15.052  47.361  55.640  1.00 12.63           C  
ATOM    451  CG  GLN A  55     -15.013  45.867  55.412  1.00 15.80           C  
ATOM    452  CD  GLN A  55     -13.928  45.223  56.161  1.00 17.94           C  
ATOM    453  OE1 GLN A  55     -12.749  45.641  56.079  1.00 21.68           O  
ATOM    454  NE2 GLN A  55     -14.300  44.208  56.936  1.00 22.00           N  
ATOM    455  N   GLU A  56     -14.533  49.686  57.986  0.50 13.20           N  
ATOM    457  CA  GLU A  56     -14.386  51.100  58.248  0.50 13.19           C  
ATOM    459  C   GLU A  56     -13.762  51.821  57.052  0.50 12.93           C  
ATOM    461  O   GLU A  56     -12.908  51.281  56.345  0.50 13.80           O  
ATOM    463  CB  GLU A  56     -13.482  51.269  59.466  0.50 13.95           C  
ATOM    465  CG  GLU A  56     -14.014  50.462  60.634  0.50 12.69           C  
ATOM    467  CD  GLU A  56     -13.269  50.707  61.928  0.50 11.78           C  
ATOM    469  OE1 GLU A  56     -12.384  51.616  61.907  0.50 17.60           O  
ATOM    471  OE2 GLU A  56     -13.626  50.033  62.941  0.50  9.06           O  
ATOM    473  N   SER A  57     -14.161  53.066  56.853  0.50 12.88           N  
ATOM    475  CA  SER A  57     -13.534  53.884  55.841  0.50 12.44           C  
ATOM    477  C   SER A  57     -12.054  54.113  56.182  0.50 11.14           C  
ATOM    479  O   SER A  57     -11.730  54.530  57.312  0.50 12.06           O  
ATOM    481  CB  SER A  57     -14.267  55.217  55.780  0.50 12.66           C  
ATOM    483  OG  SER A  57     -13.626  56.127  54.921  0.50 15.22           O  
ATOM    485  N   PRO A  58     -11.152  53.895  55.213  1.00 10.97           N  
ATOM    486  CA  PRO A  58      -9.712  54.143  55.448  1.00 11.17           C  
ATOM    487  C   PRO A  58      -9.446  55.556  56.006  1.00 11.19           C  
ATOM    488  O   PRO A  58     -10.173  56.512  55.703  1.00 12.29           O  
ATOM    489  CB  PRO A  58      -9.086  53.990  54.027  1.00 11.33           C  
ATOM    490  CG  PRO A  58     -10.034  53.076  53.314  1.00 11.82           C  
ATOM    491  CD  PRO A  58     -11.423  53.467  53.826  1.00 11.46           C  
ATOM    492  N   ARG A  59      -8.411  55.692  56.814  1.00 10.44           N  
ATOM    493  CA  ARG A  59      -8.040  57.001  57.340  1.00 11.42           C  
ATOM    494  C   ARG A  59      -7.719  57.991  56.187  1.00 11.16           C  
ATOM    495  O   ARG A  59      -7.048  57.607  55.187  1.00 11.04           O  
ATOM    496  CB  ARG A  59      -6.816  56.799  58.221  1.00 12.30           C  
ATOM    497  CG  ARG A  59      -6.269  58.055  58.876  1.00 12.33           C  
ATOM    498  CD  ARG A  59      -5.257  57.690  59.950  1.00 13.57           C  
ATOM    499  NE  ARG A  59      -4.097  56.980  59.423  1.00 14.03           N  
ATOM    500  CZ  ARG A  59      -2.981  57.557  59.032  1.00 14.36           C  
ATOM    501  NH1 ARG A  59      -2.843  58.868  59.071  1.00 15.08           N  
ATOM    502  NH2 ARG A  59      -2.001  56.779  58.580  1.00 15.38           N  
ATOM    503  N   LEU A  60      -8.201  59.232  56.303  1.00 11.70           N  
ATOM    504  CA  LEU A  60      -7.928  60.284  55.345  1.00 11.53           C  
ATOM    505  C   LEU A  60      -6.556  60.874  55.597  1.00 13.16           C  
ATOM    506  O   LEU A  60      -6.235  61.230  56.740  1.00 13.65           O  
ATOM    507  CB  LEU A  60      -8.988  61.384  55.507  1.00 13.56           C  
ATOM    508  CG  LEU A  60      -8.822  62.605  54.617  1.00 13.69           C  
ATOM    509  CD1 LEU A  60      -8.999  62.289  53.148  1.00 13.37           C  
ATOM    510  CD2 LEU A  60      -9.934  63.592  55.019  1.00 16.32           C  
ATOM    511  N   VAL A  61      -5.750  60.982  54.540  1.00 12.14           N  
ATOM    512  CA  VAL A  61      -4.448  61.647  54.618  1.00 13.23           C  
ATOM    513  C   VAL A  61      -4.310  62.672  53.531  1.00 12.80           C  
ATOM    514  O   VAL A  61      -4.987  62.579  52.499  1.00 13.98           O  
ATOM    515  CB  VAL A  61      -3.218  60.663  54.543  1.00 12.42           C  
ATOM    516  CG1 VAL A  61      -3.252  59.665  55.718  1.00 12.76           C  
ATOM    517  CG2 VAL A  61      -3.189  59.930  53.201  1.00 13.84           C  
ATOM    518  N   GLU A  62      -3.470  63.692  53.794  1.00 13.27           N  
ATOM    519  CA  GLU A  62      -3.114  64.697  52.798  1.00 15.34           C  
ATOM    520  C   GLU A  62      -1.709  64.466  52.253  1.00 15.03           C  
ATOM    521  O   GLU A  62      -1.419  64.871  51.121  1.00 15.18           O  
ATOM    522  CB  GLU A  62      -3.208  66.117  53.401  1.00 16.95           C  
ATOM    523  CG  GLU A  62      -4.623  66.457  53.853  1.00 21.16           C  
ATOM    524  CD  GLU A  62      -4.770  67.841  54.488  1.00 28.58           C  
ATOM    525  OE1 GLU A  62      -3.743  68.515  54.723  1.00 33.10           O  
ATOM    526  OE2 GLU A  62      -5.924  68.263  54.757  1.00 33.06           O  
ATOM    527  N   THR A  63      -0.851  63.880  53.077  1.00 14.59           N  
ATOM    528  CA  THR A  63       0.556  63.649  52.714  1.00 15.17           C  
ATOM    529  C   THR A  63       0.999  62.307  53.231  1.00 14.08           C  
ATOM    530  O   THR A  63       0.405  61.781  54.170  1.00 15.93           O  
ATOM    531  CB  THR A  63       1.510  64.710  53.352  1.00 16.38           C  
ATOM    532  OG1 THR A  63       1.245  64.817  54.772  1.00 18.71           O  
ATOM    533  CG2 THR A  63       1.228  66.100  52.782  1.00 18.06           C  
ATOM    534  N   ALA A  64       2.066  61.753  52.648  1.00 14.10           N  
ATOM    535  CA  ALA A  64       2.577  60.486  53.104  1.00 14.32           C  
ATOM    536  C   ALA A  64       3.980  60.612  53.696  1.00 15.35           C  
ATOM    537  O   ALA A  64       4.324  59.805  54.527  1.00 16.74           O  
ATOM    538  CB  ALA A  64       2.609  59.441  51.894  1.00 13.81           C  
ATOM    539  N   ALA A  65       4.792  61.570  53.238  1.00 16.66           N  
ATOM    540  CA  ALA A  65       6.223  61.590  53.607  1.00 17.44           C  
ATOM    541  C   ALA A  65       6.490  61.844  55.091  1.00 18.44           C  
ATOM    542  O   ALA A  65       7.512  61.459  55.626  1.00 19.43           O  
ATOM    543  CB  ALA A  65       6.981  62.609  52.749  1.00 18.20           C  
ATOM    544  N   ASN A  66       5.543  62.472  55.750  1.00 18.37           N  
ATOM    545  CA  ASN A  66       5.628  62.652  57.207  1.00 18.77           C  
ATOM    546  C   ASN A  66       5.407  61.385  57.991  1.00 18.72           C  
ATOM    547  O   ASN A  66       5.706  61.311  59.189  1.00 21.67           O  
ATOM    548  CB  ASN A  66       4.623  63.721  57.669  1.00 19.40           C  
ATOM    549  CG  ASN A  66       3.189  63.374  57.312  1.00 20.46           C  
ATOM    550  OD1 ASN A  66       2.303  63.348  58.175  1.00 22.69           O  
ATOM    551  ND2 ASN A  66       2.932  63.182  56.031  1.00 17.47           N  
ATOM    552  N   GLU A  67       4.859  60.349  57.335  1.00 18.25           N  
ATOM    553  CA  GLU A  67       4.544  59.099  58.025  1.00 17.26           C  
ATOM    554  C   GLU A  67       5.433  57.922  57.611  1.00 16.61           C  
ATOM    555  O   GLU A  67       5.735  57.023  58.421  1.00 17.73           O  
ATOM    556  CB  GLU A  67       3.086  58.669  57.759  1.00 17.63           C  
ATOM    557  CG  GLU A  67       2.069  59.652  58.309  1.00 17.23           C  
ATOM    558  CD  GLU A  67       0.650  59.108  58.273  1.00 17.57           C  
ATOM    559  OE1 GLU A  67      -0.274  59.939  58.293  1.00 19.31           O  
ATOM    560  OE2 GLU A  67       0.469  57.880  58.211  1.00 19.93           O  
ATOM    561  N   VAL A  68       5.726  57.828  56.303  1.00 15.70           N  
ATOM    562  CA  VAL A  68       6.388  56.635  55.777  1.00 15.48           C  
ATOM    563  C   VAL A  68       7.428  56.999  54.729  1.00 14.78           C  
ATOM    564  O   VAL A  68       7.442  58.108  54.199  1.00 17.22           O  
ATOM    565  CB  VAL A  68       5.329  55.656  55.116  1.00 14.40           C  
ATOM    566  CG1 VAL A  68       4.374  55.071  56.158  1.00 15.65           C  
ATOM    567  CG2 VAL A  68       4.575  56.329  53.945  1.00 15.68           C  
ATOM    568  N   ASN A  69       8.254  56.011  54.380  1.00 15.54           N  
ATOM    569  CA  ASN A  69       9.200  56.231  53.315  1.00 16.90           C  
ATOM    570  C   ASN A  69       8.713  55.659  51.979  1.00 15.74           C  
ATOM    571  O   ASN A  69       9.192  56.079  50.907  1.00 17.42           O  
ATOM    572  CB  ASN A  69      10.524  55.565  53.691  1.00 18.26           C  
ATOM    573  CG  ASN A  69      11.221  56.293  54.832  1.00 22.82           C  
ATOM    574  OD1 ASN A  69      11.213  57.523  54.893  1.00 25.72           O  
ATOM    575  ND2 ASN A  69      11.790  55.538  55.735  1.00 29.20           N  
ATOM    576  N   GLY A  70       7.775  54.721  52.047  1.00 13.75           N  
ATOM    577  CA  GLY A  70       7.354  54.035  50.817  1.00 12.91           C  
ATOM    578  C   GLY A  70       5.844  53.856  50.832  1.00 12.52           C  
ATOM    579  O   GLY A  70       5.215  53.681  51.883  1.00 13.06           O  
ATOM    580  N   VAL A  71       5.264  53.858  49.629  1.00 11.13           N  
ATOM    581  CA  VAL A  71       3.815  53.736  49.451  1.00  9.92           C  
ATOM    582  C   VAL A  71       3.538  52.718  48.323  1.00  9.12           C  
ATOM    583  O   VAL A  71       4.400  52.412  47.481  1.00 10.26           O  
ATOM    584  CB  VAL A  71       3.119  55.085  49.088  1.00 10.37           C  
ATOM    585  CG1 VAL A  71       3.369  56.101  50.200  1.00 12.13           C  
ATOM    586  CG2 VAL A  71       3.637  55.638  47.731  1.00 11.07           C  
ATOM    587  N   ILE A  72       2.308  52.231  48.299  1.00  8.57           N  
ATOM    588  CA  ILE A  72       1.783  51.421  47.186  1.00  8.07           C  
ATOM    589  C   ILE A  72       0.563  52.138  46.623  1.00  7.08           C  
ATOM    590  O   ILE A  72      -0.334  52.550  47.377  1.00  7.90           O  
ATOM    591  CB  ILE A  72       1.426  50.017  47.673  1.00  8.39           C  
ATOM    592  CG1 ILE A  72       2.704  49.256  48.082  1.00 10.68           C  
ATOM    593  CG2 ILE A  72       0.600  49.305  46.578  1.00  9.36           C  
ATOM    594  CD1 ILE A  72       2.478  47.836  48.617  1.00 11.62           C  
ATOM    595  N   LEU A  73       0.558  52.292  45.307  1.00  7.60           N  
ATOM    596  CA  LEU A  73      -0.586  52.877  44.623  1.00  7.90           C  
ATOM    597  C   LEU A  73      -1.501  51.813  44.094  1.00  7.11           C  
ATOM    598  O   LEU A  73      -0.999  50.856  43.473  1.00  7.75           O  
ATOM    599  CB  LEU A  73      -0.111  53.760  43.460  1.00  7.40           C  
ATOM    600  CG  LEU A  73       0.974  54.810  43.803  1.00  8.52           C  
ATOM    601  CD1 LEU A  73       1.214  55.694  42.587  1.00 10.79           C  
ATOM    602  CD2 LEU A  73       0.590  55.569  45.047  1.00 10.74           C  
ATOM    603  N   VAL A  74      -2.804  51.950  44.334  1.00  7.30           N  
ATOM    604  CA  VAL A  74      -3.783  51.085  43.662  1.00  7.34           C  
ATOM    605  C   VAL A  74      -4.663  51.938  42.788  1.00  6.58           C  
ATOM    606  O   VAL A  74      -4.972  53.104  43.150  1.00  7.16           O  
ATOM    607  CB  VAL A  74      -4.627  50.266  44.667  1.00  8.05           C  
ATOM    608  CG1 VAL A  74      -3.710  49.263  45.383  1.00  9.64           C  
ATOM    609  CG2 VAL A  74      -5.367  51.134  45.673  1.00  8.79           C  
ATOM    610  N   ASP A  75      -5.099  51.373  41.656  1.00  6.27           N  
ATOM    611  CA  ASP A  75      -6.133  51.984  40.815  1.00  7.22           C  
ATOM    612  C   ASP A  75      -5.722  53.307  40.187  1.00  6.83           C  
ATOM    613  O   ASP A  75      -6.589  54.024  39.644  1.00  8.30           O  
ATOM    614  CB  ASP A  75      -7.446  52.181  41.649  1.00  7.81           C  
ATOM    615  CG  ASP A  75      -8.613  52.532  40.798  1.00  7.38           C  
ATOM    616  OD1 ASP A  75      -9.407  53.433  41.199  1.00  7.41           O  
ATOM    617  OD2 ASP A  75      -8.810  51.902  39.719  1.00  7.84           O  
ATOM    618  N   HIS A  76      -4.435  53.645  40.212  1.00  6.90           N  
ATOM    619  CA  HIS A  76      -3.976  54.865  39.527  1.00  6.83           C  
ATOM    620  C   HIS A  76      -2.455  54.786  39.457  1.00  6.85           C  
ATOM    621  O   HIS A  76      -1.814  54.077  40.224  1.00  8.14           O  
ATOM    622  CB  HIS A  76      -4.394  56.161  40.235  1.00  7.34           C  
ATOM    623  CG  HIS A  76      -3.635  56.460  41.483  1.00  7.58           C  
ATOM    624  ND1 HIS A  76      -3.711  55.693  42.635  1.00  7.86           N  
ATOM    625  CD2 HIS A  76      -2.782  57.470  41.783  1.00  8.18           C  
ATOM    626  CE1 HIS A  76      -2.918  56.195  43.577  1.00  7.82           C  
ATOM    627  NE2 HIS A  76      -2.362  57.293  43.099  1.00  9.14           N  
ATOM    628  N   ASN A  77      -1.899  55.599  38.553  1.00  7.67           N  
ATOM    629  CA  ASN A  77      -0.491  55.890  38.547  1.00  7.77           C  
ATOM    630  C   ASN A  77      -0.183  57.361  38.279  1.00  7.95           C  
ATOM    631  O   ASN A  77       0.857  57.860  38.716  1.00  9.61           O  
ATOM    632  CB  ASN A  77       0.233  55.024  37.503  1.00  8.24           C  
ATOM    633  CG  ASN A  77      -0.215  55.318  36.061  1.00  8.19           C  
ATOM    634  OD1 ASN A  77       0.440  56.067  35.327  1.00  8.95           O  
ATOM    635  ND2 ASN A  77      -1.318  54.703  35.640  1.00  8.64           N  
ATOM    636  N   GLU A  78      -1.057  58.068  37.563  1.00  8.15           N  
ATOM    637  CA  GLU A  78      -0.719  59.437  37.135  1.00  8.22           C  
ATOM    638  C   GLU A  78      -0.525  60.366  38.328  1.00  9.16           C  
ATOM    639  O   GLU A  78      -1.346  60.362  39.230  1.00  9.60           O  
ATOM    640  CB  GLU A  78      -1.808  59.967  36.190  1.00  9.08           C  
ATOM    641  CG  GLU A  78      -2.021  59.039  34.982  1.00  9.24           C  
ATOM    642  CD  GLU A  78      -2.844  59.661  33.885  1.00 10.39           C  
ATOM    643  OE1 GLU A  78      -2.705  60.889  33.648  1.00 12.22           O  
ATOM    644  OE2 GLU A  78      -3.642  58.942  33.251  1.00 12.09           O  
ATOM    645  N   ARG A  79       0.530  61.180  38.297  1.00  8.97           N  
ATOM    646  CA  ARG A  79       0.869  61.960  39.473  1.00 10.92           C  
ATOM    647  C   ARG A  79      -0.239  62.918  39.903  1.00 10.46           C  
ATOM    648  O   ARG A  79      -0.454  63.064  41.115  1.00 10.96           O  
ATOM    649  CB  ARG A  79       2.203  62.649  39.330  1.00 11.98           C  
ATOM    650  CG  ARG A  79       2.265  63.770  38.372  1.00 14.65           C  
ATOM    651  CD  ARG A  79       3.597  64.535  38.454  1.00 14.40           C  
ATOM    652  NE  ARG A  79       4.684  63.605  38.179  1.00 16.62           N  
ATOM    653  CZ  ARG A  79       5.096  63.247  36.967  1.00 18.09           C  
ATOM    654  NH1 ARG A  79       4.592  63.837  35.886  1.00 19.67           N  
ATOM    655  NH2 ARG A  79       6.038  62.330  36.825  1.00 20.74           N  
ATOM    656  N   GLN A  80      -0.998  63.466  38.958  1.00  9.78           N  
ATOM    657  CA  GLN A  80      -2.032  64.439  39.311  1.00 11.07           C  
ATOM    658  C   GLN A  80      -3.229  63.775  39.941  1.00 11.21           C  
ATOM    659  O   GLN A  80      -4.061  64.459  40.535  1.00 12.78           O  
ATOM    660  CB  GLN A  80      -2.419  65.298  38.105  1.00 11.44           C  
ATOM    661  CG  GLN A  80      -3.348  64.663  37.125  1.00 10.82           C  
ATOM    662  CD  GLN A  80      -2.705  63.613  36.235  1.00 11.43           C  
ATOM    663  OE1 GLN A  80      -1.473  63.480  36.172  1.00 11.13           O  
ATOM    664  NE2 GLN A  80      -3.545  62.878  35.505  1.00 13.23           N  
ATOM    665  N   GLN A  81      -3.324  62.440  39.856  1.00 10.08           N  
ATOM    666  CA  GLN A  81      -4.393  61.686  40.537  1.00  9.60           C  
ATOM    667  C   GLN A  81      -3.941  61.210  41.912  1.00  9.19           C  
ATOM    668  O   GLN A  81      -4.739  60.673  42.672  1.00 10.66           O  
ATOM    669  CB  GLN A  81      -4.808  60.470  39.707  1.00  9.10           C  
ATOM    670  CG  GLN A  81      -5.401  60.860  38.357  1.00 11.75           C  
ATOM    671  CD  GLN A  81      -5.736  59.638  37.514  1.00 11.34           C  
ATOM    672  OE1 GLN A  81      -5.643  58.486  37.997  1.00 12.31           O  
ATOM    673  NE2 GLN A  81      -6.115  59.863  36.234  1.00 13.58           N  
ATOM    674  N   SER A  82      -2.652  61.385  42.223  1.00  9.69           N  
ATOM    675  CA  SER A  82      -2.088  60.754  43.406  1.00 10.15           C  
ATOM    676  C   SER A  82      -1.945  61.729  44.589  1.00 10.64           C  
ATOM    677  O   SER A  82      -2.514  62.842  44.604  1.00 11.58           O  
ATOM    678  CB  SER A  82      -0.731  60.130  43.084  1.00 10.34           C  
ATOM    679  OG  SER A  82      -0.378  59.125  44.044  1.00  9.77           O  
ATOM    680  N   ILE A  83      -1.242  61.292  45.629  1.00 10.76           N  
ATOM    681  CA  ILE A  83      -1.103  62.168  46.821  1.00 12.29           C  
ATOM    682  C   ILE A  83      -0.185  63.340  46.456  1.00 13.37           C  
ATOM    683  O   ILE A  83       0.696  63.211  45.602  1.00 12.76           O  
ATOM    684  CB  ILE A  83      -0.570  61.319  47.995  1.00 12.24           C  
ATOM    685  CG1 ILE A  83      -0.851  61.992  49.349  1.00 12.64           C  
ATOM    686  CG2 ILE A  83       0.897  60.947  47.865  1.00 11.99           C  
ATOM    687  CD1 ILE A  83      -0.674  61.026  50.511  1.00 13.43           C  
ATOM    688  N   LYS A  84      -0.392  64.476  47.119  1.00 14.42           N  
ATOM    689  CA  LYS A  84       0.308  65.666  46.687  1.00 16.94           C  
ATOM    690  C   LYS A  84       1.810  65.608  46.809  1.00 16.42           C  
ATOM    691  O   LYS A  84       2.502  66.242  46.007  1.00 17.63           O  
ATOM    692  CB  LYS A  84      -0.255  66.889  47.401  1.00 17.92           C  
ATOM    693  CG  LYS A  84       0.077  66.888  48.883  1.00 20.85           C  
ATOM    694  CD  LYS A  84      -0.099  68.242  49.571  1.00 27.54           C  
ATOM    695  CE  LYS A  84      -1.527  68.626  49.616  1.00 30.83           C  
ATOM    696  NZ  LYS A  84      -1.777  69.590  50.762  1.00 31.98           N  
ATOM    697  N   ASP A  85       2.310  64.849  47.769  1.00 15.64           N  
ATOM    698  CA  ASP A  85       3.729  64.678  47.951  1.00 16.53           C  
ATOM    699  C   ASP A  85       4.281  63.362  47.466  1.00 16.56           C  
ATOM    700  O   ASP A  85       5.271  62.859  48.000  1.00 16.54           O  
ATOM    701  CB  ASP A  85       4.153  64.951  49.411  1.00 17.07           C  
ATOM    702  CG  ASP A  85       3.678  63.888  50.412  1.00 15.87           C  
ATOM    703  OD1 ASP A  85       2.697  63.167  50.127  1.00 16.11           O  
ATOM    704  OD2 ASP A  85       4.231  63.698  51.540  1.00 16.87           O  
ATOM    705  N   ILE A  86       3.657  62.842  46.408  1.00 15.95           N  
ATOM    706  CA  ILE A  86       4.094  61.545  45.852  1.00 16.76           C  
ATOM    707  C   ILE A  86       5.580  61.569  45.434  1.00 17.78           C  
ATOM    708  O   ILE A  86       6.277  60.564  45.516  1.00 17.12           O  
ATOM    709  CB  ILE A  86       3.152  61.096  44.679  1.00 15.27           C  
ATOM    710  CG1 ILE A  86       3.441  59.639  44.263  1.00 14.99           C  
ATOM    711  CG2 ILE A  86       3.272  62.055  43.470  1.00 17.75           C  
ATOM    712  CD1 ILE A  86       3.087  58.604  45.325  1.00 15.39           C  
ATOM    713  N   GLU A  87       6.089  62.741  45.047  1.00 19.50           N  
ATOM    714  CA  GLU A  87       7.478  62.787  44.582  1.00 21.00           C  
ATOM    715  C   GLU A  87       8.457  62.730  45.767  1.00 21.02           C  
ATOM    716  O   GLU A  87       9.651  62.517  45.562  1.00 22.73           O  
ATOM    717  CB  GLU A  87       7.720  63.985  43.597  1.00 21.18           C  
ATOM    718  CG  GLU A  87       6.666  64.107  42.478  1.00 26.03           C  
ATOM    719  CD  GLU A  87       6.787  63.040  41.387  1.00 29.49           C  
ATOM    720  OE1 GLU A  87       7.950  62.569  41.214  1.00 31.19           O  
ATOM    721  OE2 GLU A  87       5.729  62.679  40.709  1.00 26.71           O  
ATOM    722  N   GLU A  88       7.960  62.839  47.007  1.00 20.63           N  
ATOM    723  CA  GLU A  88       8.777  62.756  48.222  1.00 21.35           C  
ATOM    724  C   GLU A  88       8.846  61.396  48.923  1.00 20.57           C  
ATOM    725  O   GLU A  88       9.445  61.255  49.993  1.00 20.38           O  
ATOM    726  CB  GLU A  88       8.357  63.840  49.241  1.00 23.29           C  
ATOM    727  CG  GLU A  88       8.238  65.236  48.670  1.00 27.33           C  
ATOM    728  CD  GLU A  88       7.992  66.274  49.763  1.00 34.23           C  
ATOM    729  OE1 GLU A  88       7.361  67.312  49.464  1.00 38.78           O  
ATOM    730  OE2 GLU A  88       8.402  66.045  50.937  1.00 37.06           O  
ATOM    731  N   VAL A  89       8.174  60.393  48.337  1.00 17.59           N  
ATOM    732  CA  VAL A  89       8.196  59.031  48.857  1.00 16.32           C  
ATOM    733  C   VAL A  89       8.589  58.054  47.755  1.00 15.38           C  
ATOM    734  O   VAL A  89       8.458  58.363  46.585  1.00 17.54           O  
ATOM    735  CB  VAL A  89       6.838  58.576  49.459  1.00 16.50           C  
ATOM    736  CG1 VAL A  89       6.578  59.279  50.805  1.00 18.60           C  
ATOM    737  CG2 VAL A  89       5.685  58.860  48.481  1.00 16.93           C  
ATOM    738  N   GLN A  90       9.046  56.892  48.136  1.00 13.91           N  
ATOM    739  CA  GLN A  90       9.323  55.856  47.125  1.00 13.82           C  
ATOM    740  C   GLN A  90       8.034  55.132  46.798  1.00 12.68           C  
ATOM    741  O   GLN A  90       7.291  54.745  47.703  1.00 12.78           O  
ATOM    742  CB  GLN A  90      10.286  54.823  47.664  1.00 15.17           C  
ATOM    743  CG  GLN A  90      10.542  53.764  46.603  1.00 18.37           C  
ATOM    744  CD  GLN A  90      11.742  52.868  46.842  1.00 18.58           C  
ATOM    745  OE1 GLN A  90      12.192  52.139  45.881  1.00 19.93           O  
ATOM    746  NE2 GLN A  90      12.306  52.924  48.075  1.00 17.90           N  
ATOM    747  N   VAL A  91       7.754  54.993  45.506  1.00 12.14           N  
ATOM    748  CA  VAL A  91       6.623  54.159  45.050  1.00 10.61           C  
ATOM    749  C   VAL A  91       7.116  52.726  44.963  1.00  9.49           C  
ATOM    750  O   VAL A  91       7.924  52.385  44.082  1.00 11.21           O  
ATOM    751  CB  VAL A  91       6.037  54.637  43.712  1.00 10.47           C  
ATOM    752  CG1 VAL A  91       4.923  53.653  43.253  1.00 11.16           C  
ATOM    753  CG2 VAL A  91       5.475  56.089  43.844  1.00 12.27           C  
ATOM    754  N   LEU A  92       6.700  51.896  45.906  1.00  9.39           N  
ATOM    755  CA  LEU A  92       7.184  50.533  45.985  1.00 10.22           C  
ATOM    756  C   LEU A  92       6.495  49.632  44.974  1.00  9.44           C  
ATOM    757  O   LEU A  92       7.097  48.702  44.430  1.00 10.12           O  
ATOM    758  CB  LEU A  92       6.924  49.974  47.389  1.00 11.42           C  
ATOM    759  CG  LEU A  92       7.670  50.734  48.499  1.00 13.45           C  
ATOM    760  CD1 LEU A  92       7.222  50.257  49.871  1.00 15.17           C  
ATOM    761  CD2 LEU A  92       9.191  50.581  48.326  1.00 16.26           C  
ATOM    762  N   GLU A  93       5.193  49.854  44.782  1.00  8.17           N  
ATOM    763  CA  GLU A  93       4.374  49.004  43.897  1.00  8.57           C  
ATOM    764  C   GLU A  93       3.233  49.851  43.373  1.00  8.87           C  
ATOM    765  O   GLU A  93       2.800  50.812  44.044  1.00  9.36           O  
ATOM    766  CB  GLU A  93       3.753  47.832  44.627  1.00  8.53           C  
ATOM    767  CG  GLU A  93       4.682  47.052  45.552  1.00 11.27           C  
ATOM    768  CD  GLU A  93       4.030  45.801  46.078  1.00 13.07           C  
ATOM    769  OE1 GLU A  93       2.920  45.451  45.648  1.00 13.91           O  
ATOM    770  OE2 GLU A  93       4.655  45.122  46.922  1.00 17.36           O  
ATOM    771  N   VAL A  94       2.735  49.443  42.199  1.00  7.59           N  
ATOM    772  CA  VAL A  94       1.498  49.995  41.607  1.00  7.30           C  
ATOM    773  C   VAL A  94       0.680  48.815  41.144  1.00  7.61           C  
ATOM    774  O   VAL A  94       1.227  47.946  40.432  1.00  7.88           O  
ATOM    775  CB  VAL A  94       1.791  50.930  40.414  1.00  7.00           C  
ATOM    776  CG1 VAL A  94       0.493  51.379  39.730  1.00  8.57           C  
ATOM    777  CG2 VAL A  94       2.632  52.109  40.832  1.00  8.31           C  
ATOM    778  N   ILE A  95      -0.599  48.757  41.533  1.00  7.25           N  
ATOM    779  CA  ILE A  95      -1.505  47.739  40.962  1.00  7.47           C  
ATOM    780  C   ILE A  95      -2.611  48.513  40.259  1.00  7.28           C  
ATOM    781  O   ILE A  95      -3.290  49.271  40.935  1.00  7.92           O  
ATOM    782  CB  ILE A  95      -2.138  46.812  42.048  1.00  7.81           C  
ATOM    783  CG1 ILE A  95      -1.106  46.362  43.109  1.00  9.42           C  
ATOM    784  CG2 ILE A  95      -2.816  45.622  41.370  1.00  9.04           C  
ATOM    785  CD1 ILE A  95       0.028  45.488  42.591  1.00  9.01           C  
ATOM    786  N   ASP A  96      -2.801  48.348  38.956  1.00  6.41           N  
ATOM    787  CA  ASP A  96      -3.696  49.289  38.228  1.00  6.82           C  
ATOM    788  C   ASP A  96      -4.217  48.660  36.948  1.00  6.80           C  
ATOM    789  O   ASP A  96      -3.766  47.607  36.507  1.00  8.13           O  
ATOM    790  CB  ASP A  96      -2.891  50.572  37.908  1.00  7.50           C  
ATOM    791  CG  ASP A  96      -3.748  51.675  37.363  1.00  7.32           C  
ATOM    792  OD1 ASP A  96      -3.223  52.463  36.538  1.00 10.19           O  
ATOM    793  OD2 ASP A  96      -4.933  51.800  37.763  1.00  8.38           O  
ATOM    794  N   HIS A  97      -5.193  49.339  36.338  1.00  7.34           N  
ATOM    795  CA  HIS A  97      -5.821  48.868  35.116  1.00  7.12           C  
ATOM    796  C   HIS A  97      -6.001  49.990  34.097  1.00  6.96           C  
ATOM    797  O   HIS A  97      -6.845  49.903  33.239  1.00  9.30           O  
ATOM    798  CB  HIS A  97      -7.164  48.144  35.433  1.00  7.04           C  
ATOM    799  CG  HIS A  97      -8.234  49.041  36.009  1.00  7.29           C  
ATOM    800  ND1 HIS A  97      -9.339  49.438  35.273  1.00 10.98           N  
ATOM    801  CD2 HIS A  97      -8.410  49.571  37.251  1.00  8.02           C  
ATOM    802  CE1 HIS A  97     -10.160  50.146  36.047  1.00 10.18           C  
ATOM    803  NE2 HIS A  97      -9.621  50.247  37.256  1.00  8.73           N  
ATOM    804  N   HIS A  98      -5.172  51.041  34.185  1.00  8.04           N  
ATOM    805  CA  HIS A  98      -5.284  52.197  33.301  1.00  8.35           C  
ATOM    806  C   HIS A  98      -4.064  52.371  32.435  1.00  7.84           C  
ATOM    807  O   HIS A  98      -3.026  51.703  32.627  1.00  9.22           O  
ATOM    808  CB  HIS A  98      -5.494  53.478  34.154  1.00  9.01           C  
ATOM    809  CG  HIS A  98      -6.735  53.448  34.986  1.00  9.26           C  
ATOM    810  ND1 HIS A  98      -6.735  53.058  36.300  1.00  9.28           N  
ATOM    811  CD2 HIS A  98      -8.029  53.698  34.654  1.00 11.52           C  
ATOM    812  CE1 HIS A  98      -7.984  53.104  36.778  1.00  9.26           C  
ATOM    813  NE2 HIS A  98      -8.790  53.484  35.790  1.00 11.08           N  
ATOM    814  N   ARG A  99      -4.143  53.287  31.484  1.00  8.23           N  
ATOM    815  CA  ARG A  99      -2.926  53.691  30.738  1.00  8.28           C  
ATOM    816  C   ARG A  99      -1.894  54.244  31.724  1.00  8.71           C  
ATOM    817  O   ARG A  99      -2.242  54.633  32.861  1.00  8.35           O  
ATOM    818  CB  ARG A  99      -3.293  54.771  29.710  1.00  9.89           C  
ATOM    819  CG  ARG A  99      -3.534  56.154  30.295  1.00 11.47           C  
ATOM    820  CD  ARG A  99      -3.997  57.074  29.291  1.00 16.88           C  
ATOM    821  NE  ARG A  99      -3.865  58.441  29.742  1.00 19.00           N  
ATOM    822  CZ  ARG A  99      -3.026  59.279  29.226  1.00 18.99           C  
ATOM    823  NH1 ARG A  99      -3.039  60.519  29.665  1.00 19.40           N  
ATOM    824  NH2 ARG A  99      -2.126  58.848  28.322  1.00 17.71           N  
ATOM    825  N   ILE A 100      -0.629  54.255  31.300  1.00  8.09           N  
ATOM    826  CA  ILE A 100       0.449  54.832  32.116  1.00  7.44           C  
ATOM    827  C   ILE A 100       0.799  56.196  31.576  1.00  8.07           C  
ATOM    828  O   ILE A 100       1.021  56.340  30.369  1.00  9.61           O  
ATOM    829  CB  ILE A 100       1.664  53.911  32.068  1.00  9.74           C  
ATOM    830  CG1 ILE A 100       1.280  52.618  32.714  1.00 10.25           C  
ATOM    831  CG2 ILE A 100       2.838  54.542  32.848  1.00 11.41           C  
ATOM    832  CD1 ILE A 100       2.384  51.561  32.616  1.00 12.75           C  
ATOM    833  N   ALA A 101       0.793  57.192  32.466  1.00  8.59           N  
ATOM    834  CA  ALA A 101       1.163  58.536  32.033  1.00  8.55           C  
ATOM    835  C   ALA A 101       1.527  59.356  33.236  1.00  8.60           C  
ATOM    836  O   ALA A 101       1.103  59.048  34.336  1.00  9.74           O  
ATOM    837  CB  ALA A 101      -0.002  59.232  31.252  1.00 10.72           C  
ATOM    838  N   ASN A 102       2.284  60.449  33.022  1.00  8.02           N  
ATOM    839  CA  ASN A 102       2.578  61.337  34.156  1.00  8.52           C  
ATOM    840  C   ASN A 102       3.119  60.592  35.366  1.00  8.73           C  
ATOM    841  O   ASN A 102       2.795  60.905  36.510  1.00  9.15           O  
ATOM    842  CB  ASN A 102       1.359  62.171  34.513  1.00  8.60           C  
ATOM    843  CG  ASN A 102       0.774  62.883  33.279  1.00  9.66           C  
ATOM    844  OD1 ASN A 102       1.465  63.669  32.643  1.00 12.50           O  
ATOM    845  ND2 ASN A 102      -0.458  62.568  32.911  1.00  9.93           N  
ATOM    846  N   PHE A 103       4.025  59.664  35.096  1.00  9.36           N  
ATOM    847  CA  PHE A 103       4.491  58.745  36.125  1.00  9.21           C  
ATOM    848  C   PHE A 103       5.894  58.330  35.797  1.00  8.84           C  
ATOM    849  O   PHE A 103       6.163  57.759  34.733  1.00 11.29           O  
ATOM    850  CB  PHE A 103       3.586  57.503  36.212  1.00  9.30           C  
ATOM    851  CG  PHE A 103       4.093  56.471  37.239  1.00 10.31           C  
ATOM    852  CD1 PHE A 103       4.888  55.367  36.897  1.00 14.25           C  
ATOM    853  CD2 PHE A 103       3.812  56.705  38.572  1.00 13.60           C  
ATOM    854  CE1 PHE A 103       5.335  54.498  37.901  1.00 13.32           C  
ATOM    855  CE2 PHE A 103       4.255  55.837  39.558  1.00 15.01           C  
ATOM    856  CZ  PHE A 103       5.004  54.729  39.202  1.00 12.18           C  
ATOM    857  N   GLU A 104       6.826  58.533  36.721  1.00  9.03           N  
ATOM    858  CA  GLU A 104       8.179  58.008  36.570  1.00 10.19           C  
ATOM    859  C   GLU A 104       8.697  57.637  37.946  1.00 10.06           C  
ATOM    860  O   GLU A 104       8.266  58.203  38.975  1.00 11.88           O  
ATOM    861  CB  GLU A 104       9.111  59.089  35.955  1.00 12.83           C  
ATOM    862  CG  GLU A 104       8.709  59.602  34.586  1.00 16.16           C  
ATOM    863  CD  GLU A 104       9.772  60.426  33.899  1.00 19.62           C  
ATOM    864  OE1 GLU A 104      10.561  61.127  34.620  1.00 23.78           O  
ATOM    865  OE2 GLU A 104       9.763  60.399  32.639  1.00 19.75           O  
ATOM    866  N   THR A 105       9.670  56.738  37.981  1.00  9.93           N  
ATOM    867  CA  THR A 105      10.310  56.403  39.247  1.00 10.23           C  
ATOM    868  C   THR A 105      11.827  56.528  39.052  1.00 10.18           C  
ATOM    869  O   THR A 105      12.356  56.315  37.926  1.00 10.19           O  
ATOM    870  CB  THR A 105      10.015  54.958  39.712  1.00 10.31           C  
ATOM    871  OG1 THR A 105      10.483  53.972  38.736  1.00 10.08           O  
ATOM    872  CG2 THR A 105       8.508  54.752  39.852  1.00 10.59           C  
ATOM    873  N   ALA A 106      12.536  56.757  40.167  1.00 10.10           N  
ATOM    874  CA  ALA A 106      13.989  56.715  40.130  1.00 10.56           C  
ATOM    875  C   ALA A 106      14.517  55.282  40.197  1.00  9.87           C  
ATOM    876  O   ALA A 106      15.614  54.991  39.664  1.00 11.58           O  
ATOM    877  CB  ALA A 106      14.580  57.527  41.244  1.00 12.74           C  
ATOM    878  N   GLU A 107      13.788  54.386  40.879  1.00 10.37           N  
ATOM    879  CA  GLU A 107      14.234  53.012  41.136  1.00  9.80           C  
ATOM    880  C   GLU A 107      13.238  52.006  40.574  1.00  9.38           C  
ATOM    881  O   GLU A 107      12.070  52.328  40.327  1.00 10.24           O  
ATOM    882  CB  GLU A 107      14.341  52.779  42.649  1.00 12.83           C  
ATOM    883  CG  GLU A 107      15.329  53.774  43.305  1.00 16.68           C  
ATOM    884  CD  GLU A 107      16.723  53.661  42.712  1.00 20.85           C  
ATOM    885  OE1 GLU A 107      17.130  52.536  42.428  1.00 25.67           O  
ATOM    886  OE2 GLU A 107      17.433  54.644  42.490  1.00 24.58           O  
ATOM    887  N   PRO A 108      13.676  50.771  40.401  1.00  8.92           N  
ATOM    888  CA  PRO A 108      12.751  49.679  40.073  1.00  8.72           C  
ATOM    889  C   PRO A 108      11.629  49.519  41.090  1.00  8.53           C  
ATOM    890  O   PRO A 108      11.728  50.007  42.240  1.00  9.58           O  
ATOM    891  CB  PRO A 108      13.649  48.463  40.072  1.00  9.96           C  
ATOM    892  CG  PRO A 108      15.022  49.006  39.744  1.00 11.36           C  
ATOM    893  CD  PRO A 108      15.057  50.291  40.540  1.00  9.69           C  
ATOM    894  N   LEU A 109      10.570  48.815  40.660  1.00  9.06           N  
ATOM    895  CA  LEU A 109       9.404  48.640  41.524  1.00  8.75           C  
ATOM    896  C   LEU A 109       8.610  47.427  41.022  1.00  8.47           C  
ATOM    897  O   LEU A 109       8.918  46.867  39.943  1.00  9.59           O  
ATOM    898  CB  LEU A 109       8.495  49.901  41.550  1.00 10.11           C  
ATOM    899  CG  LEU A 109       7.609  50.162  40.316  1.00  9.34           C  
ATOM    900  CD1 LEU A 109       6.532  51.187  40.696  1.00 12.09           C  
ATOM    901  CD2 LEU A 109       8.403  50.612  39.089  1.00 11.21           C  
ATOM    902  N   TYR A 110       7.616  47.007  41.797  1.00  8.53           N  
ATOM    903  CA  TYR A 110       6.619  46.039  41.345  1.00  7.92           C  
ATOM    904  C   TYR A 110       5.467  46.798  40.685  1.00  8.03           C  
ATOM    905  O   TYR A 110       4.696  47.464  41.397  1.00  9.58           O  
ATOM    906  CB  TYR A 110       6.078  45.221  42.531  1.00  9.15           C  
ATOM    907  CG  TYR A 110       5.211  44.054  42.146  1.00  8.27           C  
ATOM    908  CD1 TYR A 110       5.776  42.850  41.664  1.00 11.34           C  
ATOM    909  CD2 TYR A 110       3.837  44.123  42.202  1.00 10.95           C  
ATOM    910  CE1 TYR A 110       4.952  41.758  41.291  1.00 12.41           C  
ATOM    911  CE2 TYR A 110       3.013  43.046  41.846  1.00 12.31           C  
ATOM    912  CZ  TYR A 110       3.566  41.889  41.390  1.00 12.19           C  
ATOM    913  OH  TYR A 110       2.723  40.853  41.065  1.00 15.07           O  
ATOM    914  N   TYR A 111       5.414  46.842  39.371  1.00  7.63           N  
ATOM    915  CA  TYR A 111       4.350  47.525  38.625  1.00  7.73           C  
ATOM    916  C   TYR A 111       3.526  46.441  37.949  1.00  7.75           C  
ATOM    917  O   TYR A 111       4.048  45.656  37.176  1.00  9.64           O  
ATOM    918  CB  TYR A 111       4.942  48.501  37.590  1.00  8.49           C  
ATOM    919  CG  TYR A 111       3.899  49.507  37.115  1.00  7.21           C  
ATOM    920  CD1 TYR A 111       2.835  49.097  36.324  1.00  9.17           C  
ATOM    921  CD2 TYR A 111       3.970  50.848  37.496  1.00  9.37           C  
ATOM    922  CE1 TYR A 111       1.848  50.015  35.940  1.00  8.33           C  
ATOM    923  CE2 TYR A 111       3.045  51.764  37.109  1.00  9.16           C  
ATOM    924  CZ  TYR A 111       1.966  51.333  36.320  1.00  7.19           C  
ATOM    925  OH  TYR A 111       1.020  52.312  36.030  1.00  9.63           O  
ATOM    926  N   ARG A 112       2.245  46.355  38.333  1.00  8.34           N  
ATOM    927  CA  ARG A 112       1.358  45.345  37.763  1.00  8.86           C  
ATOM    928  C   ARG A 112       0.134  46.057  37.227  1.00  8.22           C  
ATOM    929  O   ARG A 112      -0.781  46.483  37.977  1.00  8.77           O  
ATOM    930  CB  ARG A 112       0.932  44.371  38.858  1.00  9.15           C  
ATOM    931  CG  ARG A 112       0.021  43.308  38.374  1.00 12.35           C  
ATOM    932  CD  ARG A 112       0.049  42.132  39.262  1.00 14.70           C  
ATOM    933  NE  ARG A 112      -0.834  41.099  38.766  1.00 16.63           N  
ATOM    934  CZ  ARG A 112      -0.812  39.857  39.245  1.00 17.05           C  
ATOM    935  NH1 ARG A 112       0.058  39.511  40.210  1.00 16.40           N  
ATOM    936  NH2 ARG A 112      -1.689  38.995  38.792  1.00 15.19           N  
ATOM    937  N   ALA A 113       0.080  46.270  35.919  1.00  8.46           N  
ATOM    938  CA  ALA A 113      -1.149  46.754  35.245  1.00  7.87           C  
ATOM    939  C   ALA A 113      -1.644  45.638  34.348  1.00  7.37           C  
ATOM    940  O   ALA A 113      -0.862  44.944  33.691  1.00  7.85           O  
ATOM    941  CB  ALA A 113      -0.893  48.012  34.423  1.00 10.11           C  
ATOM    942  N   GLU A 114      -2.954  45.439  34.342  1.00  7.79           N  
ATOM    943  CA  GLU A 114      -3.556  44.477  33.428  1.00  8.59           C  
ATOM    944  C   GLU A 114      -4.727  45.206  32.759  1.00  9.37           C  
ATOM    945  O   GLU A 114      -5.409  46.065  33.368  1.00  9.76           O  
ATOM    946  CB  GLU A 114      -4.050  43.213  34.162  1.00 10.09           C  
ATOM    947  CG  GLU A 114      -2.921  42.535  34.960  1.00 11.03           C  
ATOM    948  CD  GLU A 114      -3.248  41.132  35.398  1.00 14.45           C  
ATOM    949  OE1 GLU A 114      -2.538  40.612  36.312  1.00 16.13           O  
ATOM    950  OE2 GLU A 114      -4.154  40.518  34.811  1.00 15.56           O  
ATOM    951  N   PRO A 115      -5.005  44.890  31.482  1.00 10.18           N  
ATOM    952  CA  PRO A 115      -6.064  45.573  30.735  1.00 10.96           C  
ATOM    953  C   PRO A 115      -7.437  44.974  31.005  1.00 11.76           C  
ATOM    954  O   PRO A 115      -8.107  44.403  30.133  1.00 14.05           O  
ATOM    955  CB  PRO A 115      -5.616  45.369  29.275  1.00 12.30           C  
ATOM    956  CG  PRO A 115      -4.970  44.014  29.312  1.00 13.68           C  
ATOM    957  CD  PRO A 115      -4.194  43.992  30.625  1.00 11.16           C  
ATOM    958  N   VAL A 116      -7.822  45.068  32.266  1.00  9.88           N  
ATOM    959  CA  VAL A 116      -9.120  44.631  32.751  1.00 10.15           C  
ATOM    960  C   VAL A 116      -9.913  45.832  33.263  1.00  9.07           C  
ATOM    961  O   VAL A 116      -9.404  46.985  33.291  1.00 10.30           O  
ATOM    962  CB  VAL A 116      -8.991  43.570  33.852  1.00 10.93           C  
ATOM    963  CG1 VAL A 116      -8.335  42.312  33.289  1.00 12.29           C  
ATOM    964  CG2 VAL A 116      -8.186  44.086  35.063  1.00 11.00           C  
ATOM    965  N   GLY A 117     -11.160  45.574  33.672  1.00  9.54           N  
ATOM    966  CA  GLY A 117     -12.021  46.695  34.012  1.00 10.31           C  
ATOM    967  C   GLY A 117     -11.971  47.165  35.452  1.00 10.43           C  
ATOM    968  O   GLY A 117     -12.622  48.158  35.749  1.00 13.01           O  
ATOM    969  N   CYS A 118     -11.172  46.523  36.311  1.00  9.71           N  
ATOM    970  CA  CYS A 118     -11.190  46.908  37.735  1.00  8.98           C  
ATOM    971  C   CYS A 118      -9.942  46.416  38.421  1.00  9.19           C  
ATOM    972  O   CYS A 118      -9.474  45.322  38.108  1.00 10.17           O  
ATOM    973  CB  CYS A 118     -12.426  46.229  38.402  1.00 10.79           C  
ATOM    974  SG  CYS A 118     -12.632  46.665  40.136  1.00 11.00           S  
ATOM    975  N   THR A 119      -9.397  47.198  39.360  1.00  7.44           N  
ATOM    976  CA  THR A 119      -8.185  46.750  40.086  1.00  8.49           C  
ATOM    977  C   THR A 119      -8.453  45.487  40.886  1.00  8.92           C  
ATOM    978  O   THR A 119      -7.576  44.605  41.009  1.00  8.64           O  
ATOM    979  CB  THR A 119      -7.719  47.836  41.051  1.00  7.80           C  
ATOM    980  OG1 THR A 119      -7.529  49.045  40.288  1.00  8.70           O  
ATOM    981  CG2 THR A 119      -6.343  47.452  41.670  1.00  8.81           C  
ATOM    982  N   ALA A 120      -9.683  45.356  41.397  1.00  8.86           N  
ATOM    983  CA  ALA A 120      -9.982  44.223  42.282  1.00  9.51           C  
ATOM    984  C   ALA A 120      -9.901  42.862  41.537  1.00  8.95           C  
ATOM    985  O   ALA A 120      -9.618  41.850  42.173  1.00 10.86           O  
ATOM    986  CB  ALA A 120     -11.338  44.416  42.912  1.00 10.86           C  
ATOM    987  N   THR A 121     -10.091  42.855  40.215  1.00  9.21           N  
ATOM    988  CA  THR A 121      -9.944  41.641  39.418  1.00  9.61           C  
ATOM    989  C   THR A 121      -8.499  41.175  39.460  1.00  9.63           C  
ATOM    990  O   THR A 121      -8.222  39.971  39.453  1.00 11.06           O  
ATOM    991  CB  THR A 121     -10.413  41.992  37.983  1.00 10.09           C  
ATOM    992  OG1 THR A 121     -11.805  42.368  38.059  1.00 11.93           O  
ATOM    993  CG2 THR A 121     -10.278  40.813  36.991  1.00 11.87           C  
ATOM    994  N   ILE A 122      -7.565  42.116  39.407  1.00  9.24           N  
ATOM    995  CA  ILE A 122      -6.146  41.822  39.536  1.00  9.72           C  
ATOM    996  C   ILE A 122      -5.821  41.309  40.938  1.00 10.02           C  
ATOM    997  O   ILE A 122      -5.130  40.315  41.116  1.00 11.55           O  
ATOM    998  CB  ILE A 122      -5.282  43.059  39.180  1.00  9.10           C  
ATOM    999  CG1 ILE A 122      -5.624  43.564  37.804  1.00 10.35           C  
ATOM   1000  CG2 ILE A 122      -3.798  42.669  39.273  1.00 11.20           C  
ATOM   1001  CD1 ILE A 122      -4.995  44.904  37.483  1.00 10.70           C  
ATOM   1002  N   LEU A 123      -6.360  41.987  41.955  1.00  9.26           N  
ATOM   1003  CA  LEU A 123      -6.076  41.560  43.336  1.00 10.86           C  
ATOM   1004  C   LEU A 123      -6.608  40.150  43.609  1.00 11.99           C  
ATOM   1005  O   LEU A 123      -5.974  39.365  44.346  1.00 12.25           O  
ATOM   1006  CB  LEU A 123      -6.714  42.513  44.349  1.00 11.07           C  
ATOM   1007  CG  LEU A 123      -6.090  43.923  44.345  1.00 10.01           C  
ATOM   1008  CD1 LEU A 123      -6.840  44.843  45.309  1.00 11.09           C  
ATOM   1009  CD2 LEU A 123      -4.601  43.892  44.670  1.00 12.00           C  
ATOM   1010  N   ASN A 124      -7.736  39.793  42.982  1.00 11.97           N  
ATOM   1011  CA  ASN A 124      -8.304  38.454  43.114  1.00 12.59           C  
ATOM   1012  C   ASN A 124      -7.255  37.424  42.653  1.00 12.52           C  
ATOM   1013  O   ASN A 124      -7.032  36.405  43.354  1.00 14.92           O  
ATOM   1014  CB  ASN A 124      -9.590  38.370  42.282  1.00 12.66           C  
ATOM   1015  CG  ASN A 124     -10.344  37.060  42.488  1.00 13.63           C  
ATOM   1016  OD1 ASN A 124     -10.567  36.644  43.618  1.00 15.73           O  
ATOM   1017  ND2 ASN A 124     -10.818  36.460  41.376  1.00 15.63           N  
ATOM   1018  N   LYS A 125      -6.613  37.671  41.498  0.50 11.00           N  
ATOM   1020  CA  LYS A 125      -5.516  36.798  41.053  0.50 12.52           C  
ATOM   1022  C   LYS A 125      -4.383  36.765  42.050  0.50 12.91           C  
ATOM   1024  O   LYS A 125      -3.771  35.709  42.245  0.50 14.87           O  
ATOM   1026  CB  LYS A 125      -4.920  37.227  39.728  0.50 13.25           C  
ATOM   1028  CG  LYS A 125      -5.869  37.611  38.648  0.50 13.25           C  
ATOM   1030  CD  LYS A 125      -5.055  37.793  37.379  0.50 11.55           C  
ATOM   1032  CE  LYS A 125      -5.946  37.816  36.210  0.50 11.68           C  
ATOM   1034  NZ  LYS A 125      -5.165  37.927  34.958  0.50 16.32           N  
ATOM   1036  N   MET A 126      -4.060  37.912  42.651  1.00 14.42           N  
ATOM   1037  CA  MET A 126      -2.939  37.981  43.612  1.00 14.06           C  
ATOM   1038  C   MET A 126      -3.193  37.187  44.891  1.00 13.67           C  
ATOM   1039  O   MET A 126      -2.253  36.527  45.401  1.00 15.20           O  
ATOM   1040  CB  MET A 126      -2.612  39.452  43.901  1.00 14.64           C  
ATOM   1041  CG  MET A 126      -2.094  40.097  42.665  1.00 13.58           C  
ATOM   1042  SD  MET A 126      -1.734  41.876  42.796  1.00 15.19           S  
ATOM   1043  CE  MET A 126      -0.226  41.773  43.729  1.00 18.38           C  
ATOM   1044  N   TYR A 127      -4.421  37.197  45.405  1.00 14.27           N  
ATOM   1045  CA  TYR A 127      -4.756  36.304  46.517  1.00 14.91           C  
ATOM   1046  C   TYR A 127      -4.466  34.845  46.165  1.00 15.73           C  
ATOM   1047  O   TYR A 127      -3.840  34.119  46.954  1.00 17.05           O  
ATOM   1048  CB  TYR A 127      -6.186  36.477  46.962  1.00 14.55           C  
ATOM   1049  CG  TYR A 127      -6.419  37.600  47.942  1.00 14.97           C  
ATOM   1050  CD1 TYR A 127      -6.808  38.882  47.505  1.00 15.30           C  
ATOM   1051  CD2 TYR A 127      -6.293  37.378  49.322  1.00 14.12           C  
ATOM   1052  CE1 TYR A 127      -7.064  39.869  48.401  1.00 15.77           C  
ATOM   1053  CE2 TYR A 127      -6.561  38.383  50.232  1.00 13.95           C  
ATOM   1054  CZ  TYR A 127      -6.930  39.631  49.752  1.00 13.65           C  
ATOM   1055  OH  TYR A 127      -7.215  40.615  50.642  1.00 14.48           O  
ATOM   1056  N   LYS A 128      -4.913  34.425  44.993  1.00 15.23           N  
ATOM   1057  CA  LYS A 128      -4.793  33.029  44.587  1.00 17.01           C  
ATOM   1058  C   LYS A 128      -3.336  32.670  44.333  1.00 17.06           C  
ATOM   1059  O   LYS A 128      -2.892  31.604  44.742  1.00 17.65           O  
ATOM   1060  CB  LYS A 128      -5.630  32.810  43.330  1.00 16.24           C  
ATOM   1061  CG  LYS A 128      -7.108  32.929  43.502  1.00 20.75           C  
ATOM   1062  CD  LYS A 128      -7.724  32.646  42.117  1.00 23.07           C  
ATOM   1063  CE  LYS A 128      -9.116  33.236  42.026  1.00 24.67           C  
ATOM   1064  NZ  LYS A 128      -9.672  32.972  40.682  1.00 24.69           N  
ATOM   1065  N   GLU A 129      -2.549  33.574  43.727  1.00 17.79           N  
ATOM   1066  CA  GLU A 129      -1.106  33.383  43.476  1.00 18.12           C  
ATOM   1067  C   GLU A 129      -0.346  33.185  44.815  1.00 19.22           C  
ATOM   1068  O   GLU A 129       0.645  32.439  44.907  1.00 20.94           O  
ATOM   1069  CB  GLU A 129      -0.487  34.581  42.713  1.00 18.10           C  
ATOM   1070  CG  GLU A 129      -0.880  34.650  41.242  1.00 18.09           C  
ATOM   1071  CD  GLU A 129      -0.656  36.030  40.655  1.00 17.74           C  
ATOM   1072  OE1 GLU A 129      -0.124  36.934  41.356  1.00 22.02           O  
ATOM   1073  OE2 GLU A 129      -1.079  36.233  39.501  1.00 18.24           O  
ATOM   1074  N   ASN A 130      -0.844  33.820  45.860  1.00 19.31           N  
ATOM   1075  CA  ASN A 130      -0.188  33.740  47.162  1.00 19.68           C  
ATOM   1076  C   ASN A 130      -0.810  32.715  48.101  1.00 20.97           C  
ATOM   1077  O   ASN A 130      -0.382  32.629  49.260  1.00 21.98           O  
ATOM   1078  CB  ASN A 130      -0.155  35.146  47.787  1.00 18.55           C  
ATOM   1079  CG  ASN A 130       0.869  36.006  47.134  1.00 19.41           C  
ATOM   1080  OD1 ASN A 130       2.075  35.868  47.389  1.00 21.72           O  
ATOM   1081  ND2 ASN A 130       0.419  36.911  46.233  1.00 20.47           N  
ATOM   1082  N   ASN A 131      -1.798  31.956  47.624  1.00 21.80           N  
ATOM   1083  CA  ASN A 131      -2.552  31.003  48.464  1.00 22.35           C  
ATOM   1084  C   ASN A 131      -3.131  31.580  49.766  1.00 21.77           C  
ATOM   1085  O   ASN A 131      -3.106  30.957  50.840  1.00 22.64           O  
ATOM   1086  CB  ASN A 131      -1.680  29.753  48.763  1.00 22.71           C  
ATOM   1087  CG  ASN A 131      -2.508  28.530  49.097  1.00 28.15           C  
ATOM   1088  OD1 ASN A 131      -3.592  28.309  48.524  1.00 33.82           O  
ATOM   1089  ND2 ASN A 131      -2.011  27.724  50.041  1.00 31.01           N  
ATOM   1090  N   VAL A 132      -3.662  32.804  49.688  1.00 19.84           N  
ATOM   1091  CA  VAL A 132      -4.230  33.469  50.849  1.00 19.41           C  
ATOM   1092  C   VAL A 132      -5.730  33.498  50.670  1.00 19.04           C  
ATOM   1093  O   VAL A 132      -6.204  33.935  49.626  1.00 17.24           O  
ATOM   1094  CB  VAL A 132      -3.666  34.913  50.971  1.00 20.03           C  
ATOM   1095  CG1 VAL A 132      -4.429  35.696  52.015  1.00 19.58           C  
ATOM   1096  CG2 VAL A 132      -2.167  34.869  51.288  1.00 19.79           C  
ATOM   1097  N   LYS A 133      -6.476  33.020  51.658  1.00 19.64           N  
ATOM   1098  CA  LYS A 133      -7.925  32.984  51.613  1.00 19.99           C  
ATOM   1099  C   LYS A 133      -8.461  34.429  51.642  1.00 19.12           C  
ATOM   1100  O   LYS A 133      -8.002  35.261  52.447  1.00 19.33           O  
ATOM   1101  CB  LYS A 133      -8.411  32.210  52.863  1.00 21.44           C  
ATOM   1102  CG  LYS A 133      -9.924  32.188  53.112  1.00 26.33           C  
ATOM   1103  CD  LYS A 133     -10.216  31.686  54.553  1.00 32.30           C  
ATOM   1104  CE  LYS A 133     -11.695  31.555  54.862  1.00 35.35           C  
ATOM   1105  NZ  LYS A 133     -12.170  32.647  55.788  1.00 38.32           N  
ATOM   1106  N   ILE A 134      -9.442  34.704  50.797  1.00 18.11           N  
ATOM   1107  CA  ILE A 134     -10.139  35.978  50.849  1.00 18.33           C  
ATOM   1108  C   ILE A 134     -11.271  35.866  51.850  1.00 18.86           C  
ATOM   1109  O   ILE A 134     -12.202  35.080  51.667  1.00 18.68           O  
ATOM   1110  CB  ILE A 134     -10.693  36.353  49.457  1.00 17.76           C  
ATOM   1111  CG1 ILE A 134      -9.594  36.246  48.423  1.00 17.61           C  
ATOM   1112  CG2 ILE A 134     -11.305  37.751  49.480  1.00 17.42           C  
ATOM   1113  CD1 ILE A 134     -10.042  36.558  46.945  1.00 18.33           C  
ATOM   1114  N   GLU A 135     -11.227  36.672  52.905  1.00 18.03           N  
ATOM   1115  CA  GLU A 135     -12.295  36.643  53.900  1.00 18.70           C  
ATOM   1116  C   GLU A 135     -13.576  37.175  53.284  1.00 16.50           C  
ATOM   1117  O   GLU A 135     -13.529  38.022  52.360  1.00 16.46           O  
ATOM   1118  CB  GLU A 135     -11.901  37.497  55.095  1.00 20.37           C  
ATOM   1119  CG  GLU A 135     -10.675  36.978  55.836  1.00 24.90           C  
ATOM   1120  CD  GLU A 135     -10.463  37.664  57.183  1.00 32.88           C  
ATOM   1121  OE1 GLU A 135      -9.307  37.745  57.644  1.00 35.60           O  
ATOM   1122  OE2 GLU A 135     -11.456  38.109  57.805  1.00 39.43           O  
ATOM   1123  N   LYS A 136     -14.723  36.718  53.767  1.00 17.42           N  
ATOM   1124  CA  LYS A 136     -16.053  37.108  53.287  1.00 16.82           C  
ATOM   1125  C   LYS A 136     -16.229  38.611  53.047  1.00 16.04           C  
ATOM   1126  O   LYS A 136     -16.682  39.032  51.992  1.00 16.14           O  
ATOM   1127  CB  LYS A 136     -17.100  36.650  54.301  1.00 19.05           C  
ATOM   1128  CG  LYS A 136     -18.513  36.924  53.919  1.00 22.67           C  
ATOM   1129  CD  LYS A 136     -19.382  36.551  55.123  1.00 27.99           C  
ATOM   1130  CE  LYS A 136     -20.861  36.744  54.886  1.00 33.18           C  
ATOM   1131  NZ  LYS A 136     -21.619  36.103  56.042  1.00 35.68           N  
ATOM   1132  N   GLU A 137     -15.801  39.404  54.024  0.50 14.56           N  
ATOM   1134  CA  GLU A 137     -15.986  40.841  54.011  0.50 14.78           C  
ATOM   1136  C   GLU A 137     -15.116  41.500  52.940  0.50 13.93           C  
ATOM   1138  O   GLU A 137     -15.566  42.415  52.244  0.50 14.12           O  
ATOM   1140  CB  GLU A 137     -15.602  41.388  55.382  0.50 14.93           C  
ATOM   1142  CG  GLU A 137     -16.558  40.955  56.483  0.50 16.58           C  
ATOM   1144  CD  GLU A 137     -16.241  39.596  57.133  0.50 18.77           C  
ATOM   1146  OE1 GLU A 137     -15.220  38.903  56.796  0.50 16.60           O  
ATOM   1148  OE2 GLU A 137     -17.067  39.220  58.011  0.50 22.57           O  
ATOM   1150  N   ILE A 138     -13.895  40.997  52.806  1.00 12.81           N  
ATOM   1151  CA  ILE A 138     -12.955  41.501  51.803  1.00 13.02           C  
ATOM   1152  C   ILE A 138     -13.466  41.129  50.399  1.00 12.30           C  
ATOM   1153  O   ILE A 138     -13.395  41.939  49.480  1.00 12.54           O  
ATOM   1154  CB  ILE A 138     -11.549  40.983  52.057  1.00 13.02           C  
ATOM   1155  CG1 ILE A 138     -11.020  41.431  53.436  1.00 15.97           C  
ATOM   1156  CG2 ILE A 138     -10.554  41.411  50.923  1.00 15.19           C  
ATOM   1157  CD1 ILE A 138     -10.849  42.955  53.511  1.00 17.91           C  
ATOM   1158  N   ALA A 139     -14.006  39.919  50.246  1.00 13.21           N  
ATOM   1159  CA  ALA A 139     -14.572  39.542  48.951  1.00 12.05           C  
ATOM   1160  C   ALA A 139     -15.721  40.448  48.612  1.00 12.30           C  
ATOM   1161  O   ALA A 139     -15.875  40.820  47.449  1.00 12.63           O  
ATOM   1162  CB  ALA A 139     -15.065  38.108  48.981  1.00 13.76           C  
ATOM   1163  N   GLY A 140     -16.525  40.832  49.606  1.00 12.32           N  
ATOM   1164  CA  GLY A 140     -17.585  41.763  49.386  1.00 11.87           C  
ATOM   1165  C   GLY A 140     -17.122  43.116  48.887  1.00 11.14           C  
ATOM   1166  O   GLY A 140     -17.713  43.674  47.957  1.00 12.11           O  
ATOM   1167  N   LEU A 141     -16.051  43.638  49.480  1.00 11.64           N  
ATOM   1168  CA  LEU A 141     -15.487  44.890  48.982  1.00 10.47           C  
ATOM   1169  C   LEU A 141     -14.905  44.739  47.561  1.00  9.62           C  
ATOM   1170  O   LEU A 141     -15.075  45.638  46.739  1.00 10.67           O  
ATOM   1171  CB  LEU A 141     -14.390  45.410  49.913  1.00 10.98           C  
ATOM   1172  CG  LEU A 141     -14.793  45.739  51.375  1.00 11.93           C  
ATOM   1173  CD1 LEU A 141     -13.613  46.409  52.032  1.00 14.96           C  
ATOM   1174  CD2 LEU A 141     -15.964  46.623  51.386  1.00 13.35           C  
ATOM   1175  N   MET A 142     -14.253  43.616  47.290  1.00 10.55           N  
ATOM   1176  CA  MET A 142     -13.723  43.407  45.960  1.00 10.12           C  
ATOM   1177  C   MET A 142     -14.831  43.330  44.905  1.00 10.14           C  
ATOM   1178  O   MET A 142     -14.726  43.925  43.792  1.00  9.90           O  
ATOM   1179  CB  MET A 142     -12.786  42.203  45.917  1.00 11.46           C  
ATOM   1180  CG  MET A 142     -11.535  42.429  46.735  1.00 10.90           C  
ATOM   1181  SD  MET A 142     -10.619  40.944  47.113  1.00 13.80           S  
ATOM   1182  CE  MET A 142     -10.059  40.590  45.522  1.00 14.53           C  
ATOM   1183  N   LEU A 143     -15.896  42.611  45.251  1.00 10.30           N  
ATOM   1184  CA  LEU A 143     -17.070  42.539  44.368  1.00 10.90           C  
ATOM   1185  C   LEU A 143     -17.644  43.926  44.142  1.00 11.00           C  
ATOM   1186  O   LEU A 143     -17.974  44.292  43.009  1.00 10.66           O  
ATOM   1187  CB  LEU A 143     -18.111  41.629  45.048  1.00 11.92           C  
ATOM   1188  CG  LEU A 143     -19.492  41.695  44.382  1.00 13.11           C  
ATOM   1189  CD1 LEU A 143     -19.473  41.061  42.964  1.00 15.53           C  
ATOM   1190  CD2 LEU A 143     -20.531  41.001  45.259  1.00 14.44           C  
ATOM   1191  N   SER A 144     -17.724  44.723  45.210  1.00 10.40           N  
ATOM   1192  CA  SER A 144     -18.277  46.074  45.118  1.00 10.40           C  
ATOM   1193  C   SER A 144     -17.467  46.915  44.121  1.00 10.34           C  
ATOM   1194  O   SER A 144     -18.043  47.659  43.299  1.00  9.97           O  
ATOM   1195  CB  SER A 144     -18.243  46.752  46.482  1.00 11.36           C  
ATOM   1196  OG  SER A 144     -19.060  46.004  47.391  1.00 12.07           O  
ATOM   1197  N   ALA A 145     -16.145  46.790  44.192  1.00  9.07           N  
ATOM   1198  CA  ALA A 145     -15.261  47.479  43.241  1.00  9.57           C  
ATOM   1199  C   ALA A 145     -15.546  47.091  41.787  1.00  8.96           C  
ATOM   1200  O   ALA A 145     -15.669  47.989  40.942  1.00  9.78           O  
ATOM   1201  CB  ALA A 145     -13.823  47.145  43.576  1.00 10.48           C  
ATOM   1202  N   ILE A 146     -15.707  45.804  41.510  1.00  8.74           N  
ATOM   1203  CA  ILE A 146     -15.972  45.366  40.145  1.00 10.29           C  
ATOM   1204  C   ILE A 146     -17.321  45.846  39.666  1.00 10.26           C  
ATOM   1205  O   ILE A 146     -17.433  46.306  38.548  1.00 11.56           O  
ATOM   1206  CB  ILE A 146     -15.893  43.845  40.073  1.00 10.83           C  
ATOM   1207  CG1 ILE A 146     -14.462  43.361  40.379  1.00 11.32           C  
ATOM   1208  CG2 ILE A 146     -16.310  43.324  38.653  1.00 11.96           C  
ATOM   1209  CD1 ILE A 146     -14.314  41.881  40.664  1.00 14.34           C  
ATOM   1210  N   ILE A 147     -18.357  45.771  40.520  0.50 10.80           N  
ATOM   1212  CA  ILE A 147     -19.672  46.270  40.114  0.50 11.47           C  
ATOM   1214  C   ILE A 147     -19.612  47.759  39.814  0.50 11.16           C  
ATOM   1216  O   ILE A 147     -20.189  48.226  38.827  0.50 11.84           O  
ATOM   1218  CB  ILE A 147     -20.713  45.949  41.191  0.50 11.14           C  
ATOM   1220  CG1 ILE A 147     -20.916  44.426  41.298  0.50 12.15           C  
ATOM   1222  CG2 ILE A 147     -22.018  46.758  40.955  0.50 12.17           C  
ATOM   1224  CD1 ILE A 147     -21.747  44.008  42.481  0.50 12.65           C  
ATOM   1226  N   SER A 148     -18.914  48.509  40.668  1.00 10.78           N  
ATOM   1227  CA  SER A 148     -18.781  49.932  40.487  1.00 11.45           C  
ATOM   1228  C   SER A 148     -18.069  50.317  39.189  1.00 11.18           C  
ATOM   1229  O   SER A 148     -18.611  51.079  38.384  1.00 11.97           O  
ATOM   1230  CB  SER A 148     -18.008  50.510  41.669  1.00 10.56           C  
ATOM   1231  OG  SER A 148     -17.799  51.890  41.451  1.00 11.05           O  
ATOM   1232  N   ASP A 149     -16.889  49.733  38.963  1.00 10.75           N  
ATOM   1233  CA  ASP A 149     -16.142  50.088  37.760  1.00 10.74           C  
ATOM   1234  C   ASP A 149     -16.796  49.592  36.488  1.00 12.78           C  
ATOM   1235  O   ASP A 149     -16.706  50.257  35.450  1.00 14.16           O  
ATOM   1236  CB  ASP A 149     -14.727  49.563  37.833  1.00 10.06           C  
ATOM   1237  CG  ASP A 149     -13.767  50.493  38.491  1.00 10.56           C  
ATOM   1238  OD1 ASP A 149     -14.089  51.629  38.889  1.00 11.47           O  
ATOM   1239  OD2 ASP A 149     -12.581  50.115  38.638  1.00 10.13           O  
ATOM   1240  N   SER A 150     -17.453  48.450  36.577  1.00 11.84           N  
ATOM   1241  CA  SER A 150     -18.095  47.872  35.372  1.00 13.17           C  
ATOM   1242  C   SER A 150     -19.509  48.393  35.163  1.00 14.12           C  
ATOM   1243  O   SER A 150     -20.122  48.006  34.150  1.00 14.51           O  
ATOM   1244  CB  SER A 150     -18.103  46.363  35.453  1.00 13.69           C  
ATOM   1245  OG  SER A 150     -19.094  45.954  36.397  1.00 13.39           O  
ATOM   1246  N   LEU A 151     -20.057  49.185  36.097  1.00 14.64           N  
ATOM   1247  CA  LEU A 151     -21.469  49.636  35.995  1.00 15.74           C  
ATOM   1248  C   LEU A 151     -22.363  48.404  35.867  1.00 15.74           C  
ATOM   1249  O   LEU A 151     -23.197  48.308  34.930  1.00 17.87           O  
ATOM   1250  CB  LEU A 151     -21.698  50.632  34.828  1.00 17.62           C  
ATOM   1251  CG  LEU A 151     -20.804  51.858  34.900  1.00 21.52           C  
ATOM   1252  CD1 LEU A 151     -20.982  52.692  33.630  1.00 24.15           C  
ATOM   1253  CD2 LEU A 151     -21.184  52.666  36.126  1.00 23.39           C  
ATOM   1254  N   LEU A 152     -22.227  47.449  36.781  1.00 15.16           N  
ATOM   1255  CA  LEU A 152     -23.001  46.216  36.729  1.00 15.31           C  
ATOM   1256  C   LEU A 152     -22.816  45.503  35.375  1.00 16.48           C  
ATOM   1257  O   LEU A 152     -23.789  45.070  34.709  1.00 18.13           O  
ATOM   1258  CB  LEU A 152     -24.487  46.438  37.088  1.00 16.90           C  
ATOM   1259  CG  LEU A 152     -25.229  45.184  37.535  1.00 18.63           C  
ATOM   1260  CD1 LEU A 152     -24.651  44.577  38.828  1.00 19.66           C  
ATOM   1261  CD2 LEU A 152     -26.721  45.496  37.645  1.00 22.52           C  
ATOM   1262  N   PHE A 153     -21.555  45.400  34.948  1.00 15.53           N  
ATOM   1263  CA  PHE A 153     -21.128  44.658  33.754  1.00 18.64           C  
ATOM   1264  C   PHE A 153     -21.596  45.298  32.455  1.00 18.35           C  
ATOM   1265  O   PHE A 153     -21.593  44.625  31.394  1.00 21.58           O  
ATOM   1266  CB  PHE A 153     -21.562  43.179  33.864  1.00 19.29           C  
ATOM   1267  CG  PHE A 153     -21.398  42.626  35.246  1.00 20.01           C  
ATOM   1268  CD1 PHE A 153     -22.488  42.233  36.009  1.00 22.16           C  
ATOM   1269  CD2 PHE A 153     -20.121  42.576  35.816  1.00 20.83           C  
ATOM   1270  CE1 PHE A 153     -22.330  41.796  37.273  1.00 21.42           C  
ATOM   1271  CE2 PHE A 153     -19.949  42.132  37.099  1.00 21.00           C  
ATOM   1272  CZ  PHE A 153     -21.054  41.740  37.827  1.00 22.28           C  
ATOM   1273  N   LYS A 154     -21.912  46.588  32.494  1.00 18.15           N  
ATOM   1274  CA  LYS A 154     -22.398  47.306  31.293  1.00 19.39           C  
ATOM   1275  C   LYS A 154     -21.318  48.142  30.608  1.00 20.51           C  
ATOM   1276  O   LYS A 154     -21.465  48.506  29.441  1.00 21.79           O  
ATOM   1277  CB  LYS A 154     -23.568  48.242  31.624  1.00 20.31           C  
ATOM   1278  CG  LYS A 154     -24.871  47.549  32.120  1.00 23.29           C  
ATOM   1279  CD  LYS A 154     -25.981  48.559  32.452  1.00 27.59           C  
ATOM   1280  CE  LYS A 154     -27.097  47.925  33.296  1.00 30.89           C  
ATOM   1281  NZ  LYS A 154     -27.873  48.996  33.996  1.00 33.77           N  
ATOM   1282  N   SER A 155     -20.244  48.460  31.326  0.50 19.97           N  
ATOM   1284  CA  SER A 155     -19.219  49.353  30.804  0.50 20.44           C  
ATOM   1286  C   SER A 155     -18.421  48.729  29.669  0.50 21.45           C  
ATOM   1288  O   SER A 155     -18.138  47.548  29.698  0.50 20.96           O  
ATOM   1290  CB  SER A 155     -18.260  49.750  31.917  0.50 20.07           C  
ATOM   1292  OG  SER A 155     -17.223  50.545  31.380  0.50 18.25           O  
ATOM   1294  N   PRO A 156     -18.075  49.511  28.647  1.00 23.34           N  
ATOM   1295  CA  PRO A 156     -17.176  48.996  27.594  1.00 23.57           C  
ATOM   1296  C   PRO A 156     -15.809  48.487  28.074  1.00 23.04           C  
ATOM   1297  O   PRO A 156     -15.209  47.677  27.380  1.00 23.11           O  
ATOM   1298  CB  PRO A 156     -16.987  50.195  26.649  1.00 25.05           C  
ATOM   1299  CG  PRO A 156     -17.457  51.397  27.401  1.00 26.03           C  
ATOM   1300  CD  PRO A 156     -18.535  50.890  28.366  1.00 24.27           C  
ATOM   1301  N   THR A 157     -15.364  48.906  29.264  1.00 22.36           N  
ATOM   1302  CA  THR A 157     -14.117  48.431  29.832  1.00 22.45           C  
ATOM   1303  C   THR A 157     -14.225  47.038  30.511  1.00 20.65           C  
ATOM   1304  O   THR A 157     -13.211  46.411  30.848  1.00 19.49           O  
ATOM   1305  CB  THR A 157     -13.590  49.486  30.876  1.00 23.69           C  
ATOM   1306  OG1 THR A 157     -14.547  49.669  31.920  1.00 26.17           O  
ATOM   1307  CG2 THR A 157     -13.551  50.862  30.251  1.00 27.19           C  
ATOM   1308  N   CYS A 158     -15.440  46.578  30.765  1.00 19.16           N  
ATOM   1309  CA  CYS A 158     -15.629  45.324  31.467  1.00 18.15           C  
ATOM   1310  C   CYS A 158     -15.155  44.182  30.569  1.00 17.99           C  
ATOM   1311  O   CYS A 158     -15.466  44.179  29.350  1.00 20.01           O  
ATOM   1312  CB  CYS A 158     -17.119  45.169  31.852  1.00 18.25           C  
ATOM   1313  SG  CYS A 158     -17.429  43.759  32.933  1.00 20.98           S  
ATOM   1314  N   THR A 159     -14.391  43.239  31.126  1.00 16.72           N  
ATOM   1315  CA  THR A 159     -13.946  42.016  30.459  1.00 16.72           C  
ATOM   1316  C   THR A 159     -14.534  40.764  31.052  1.00 16.37           C  
ATOM   1317  O   THR A 159     -15.058  40.774  32.178  1.00 15.59           O  
ATOM   1318  CB  THR A 159     -12.400  41.875  30.449  1.00 16.08           C  
ATOM   1319  OG1 THR A 159     -11.953  41.526  31.782  1.00 16.11           O  
ATOM   1320  CG2 THR A 159     -11.685  43.179  30.051  1.00 17.28           C  
ATOM   1321  N   ASP A 160     -14.367  39.645  30.354  1.00 16.83           N  
ATOM   1322  CA  ASP A 160     -14.750  38.365  30.901  1.00 16.94           C  
ATOM   1323  C   ASP A 160     -14.005  38.060  32.212  1.00 15.39           C  
ATOM   1324  O   ASP A 160     -14.566  37.409  33.070  1.00 15.71           O  
ATOM   1325  CB  ASP A 160     -14.478  37.236  29.918  1.00 19.40           C  
ATOM   1326  CG  ASP A 160     -15.411  37.228  28.726  1.00 23.17           C  
ATOM   1327  OD1 ASP A 160     -16.437  37.938  28.679  1.00 25.44           O  
ATOM   1328  OD2 ASP A 160     -15.136  36.491  27.747  1.00 28.09           O  
ATOM   1329  N   GLN A 161     -12.768  38.557  32.366  1.00 14.62           N  
ATOM   1330  CA  GLN A 161     -12.048  38.341  33.619  1.00 13.68           C  
ATOM   1331  C   GLN A 161     -12.751  39.015  34.784  1.00 13.12           C  
ATOM   1332  O   GLN A 161     -12.835  38.436  35.867  1.00 13.73           O  
ATOM   1333  CB  GLN A 161     -10.648  38.895  33.525  1.00 13.21           C  
ATOM   1334  CG  GLN A 161      -9.807  38.196  32.462  1.00 14.81           C  
ATOM   1335  CD  GLN A 161      -8.356  38.540  32.658  1.00 17.91           C  
ATOM   1336  OE1 GLN A 161      -7.789  38.166  33.666  1.00 19.49           O  
ATOM   1337  NE2 GLN A 161      -7.766  39.259  31.718  1.00 18.23           N  
ATOM   1338  N   ASP A 162     -13.305  40.181  34.545  1.00 12.50           N  
ATOM   1339  CA  ASP A 162     -14.044  40.932  35.586  1.00 12.06           C  
ATOM   1340  C   ASP A 162     -15.339  40.218  35.961  1.00 13.32           C  
ATOM   1341  O   ASP A 162     -15.684  40.106  37.129  1.00 13.00           O  
ATOM   1342  CB  ASP A 162     -14.346  42.373  35.156  1.00 12.72           C  
ATOM   1343  CG  ASP A 162     -13.096  43.151  34.787  1.00 13.18           C  
ATOM   1344  OD1 ASP A 162     -12.297  43.514  35.707  1.00 13.34           O  
ATOM   1345  OD2 ASP A 162     -12.868  43.442  33.599  1.00 13.81           O  
ATOM   1346  N   VAL A 163     -16.089  39.787  34.942  1.00 14.28           N  
ATOM   1347  CA  VAL A 163     -17.378  39.102  35.162  1.00 14.62           C  
ATOM   1348  C   VAL A 163     -17.166  37.828  35.964  1.00 15.17           C  
ATOM   1349  O   VAL A 163     -17.890  37.568  36.937  1.00 15.37           O  
ATOM   1350  CB  VAL A 163     -17.958  38.771  33.710  1.00 17.67           C  
ATOM   1351  CG1 VAL A 163     -18.943  37.655  33.714  1.00 21.34           C  
ATOM   1352  CG2 VAL A 163     -18.428  40.074  33.088  1.00 19.24           C  
ATOM   1353  N   ALA A 164     -16.150  37.064  35.612  1.00 14.23           N  
ATOM   1354  CA  ALA A 164     -15.862  35.819  36.308  1.00 15.33           C  
ATOM   1355  C   ALA A 164     -15.440  36.063  37.735  1.00 15.47           C  
ATOM   1356  O   ALA A 164     -15.858  35.330  38.638  1.00 16.57           O  
ATOM   1357  CB  ALA A 164     -14.802  35.009  35.587  1.00 17.18           C  
ATOM   1358  N   ALA A 165     -14.577  37.056  37.924  1.00 14.25           N  
ATOM   1359  CA  ALA A 165     -14.142  37.407  39.300  1.00 13.57           C  
ATOM   1360  C   ALA A 165     -15.337  37.834  40.132  1.00 12.70           C  
ATOM   1361  O   ALA A 165     -15.445  37.456  41.313  1.00 14.61           O  
ATOM   1362  CB  ALA A 165     -13.049  38.529  39.277  1.00 11.64           C  
ATOM   1363  N   ALA A 166     -16.245  38.619  39.563  1.00 13.60           N  
ATOM   1364  CA  ALA A 166     -17.417  39.049  40.315  1.00 14.04           C  
ATOM   1365  C   ALA A 166     -18.245  37.846  40.785  1.00 14.41           C  
ATOM   1366  O   ALA A 166     -18.712  37.791  41.932  1.00 14.49           O  
ATOM   1367  CB  ALA A 166     -18.265  39.993  39.512  1.00 13.29           C  
ATOM   1368  N   LYS A 167     -18.482  36.873  39.907  1.00 14.71           N  
ATOM   1369  CA  LYS A 167     -19.254  35.715  40.364  1.00 16.04           C  
ATOM   1370  C   LYS A 167     -18.556  34.984  41.533  1.00 15.65           C  
ATOM   1371  O   LYS A 167     -19.205  34.584  42.498  1.00 16.53           O  
ATOM   1372  CB  LYS A 167     -19.535  34.777  39.167  1.00 17.44           C  
ATOM   1373  CG  LYS A 167     -20.375  33.508  39.579  1.00 19.84           C  
ATOM   1374  CD  LYS A 167     -21.031  32.785  38.424  1.00 24.08           C  
ATOM   1375  CE  LYS A 167     -22.306  32.068  38.813  1.00 26.89           C  
ATOM   1376  NZ  LYS A 167     -23.586  32.871  38.524  1.00 26.49           N  
ATOM   1377  N   GLU A 168     -17.260  34.761  41.405  1.00 16.00           N  
ATOM   1378  CA  GLU A 168     -16.477  34.131  42.478  1.00 17.08           C  
ATOM   1379  C   GLU A 168     -16.552  34.892  43.781  1.00 16.41           C  
ATOM   1380  O   GLU A 168     -16.764  34.310  44.845  1.00 17.63           O  
ATOM   1381  CB  GLU A 168     -14.991  34.027  42.118  1.00 19.69           C  
ATOM   1382  CG  GLU A 168     -14.677  33.178  40.921  1.00 22.79           C  
ATOM   1383  CD  GLU A 168     -13.202  33.217  40.511  1.00 27.42           C  
ATOM   1384  OE1 GLU A 168     -12.907  32.651  39.435  1.00 30.82           O  
ATOM   1385  OE2 GLU A 168     -12.329  33.793  41.215  1.00 24.19           O  
ATOM   1386  N   LEU A 169     -16.353  36.197  43.692  1.00 15.08           N  
ATOM   1387  CA  LEU A 169     -16.303  36.991  44.912  1.00 14.00           C  
ATOM   1388  C   LEU A 169     -17.669  37.084  45.547  1.00 14.72           C  
ATOM   1389  O   LEU A 169     -17.755  37.105  46.784  1.00 14.42           O  
ATOM   1390  CB  LEU A 169     -15.714  38.386  44.589  1.00 12.97           C  
ATOM   1391  CG  LEU A 169     -14.237  38.225  44.208  1.00 12.86           C  
ATOM   1392  CD1 LEU A 169     -13.777  39.497  43.455  1.00 13.29           C  
ATOM   1393  CD2 LEU A 169     -13.329  38.060  45.423  1.00 14.15           C  
ATOM   1394  N   ALA A 170     -18.738  37.096  44.740  1.00 14.69           N  
ATOM   1395  CA  ALA A 170     -20.087  37.159  45.322  1.00 15.76           C  
ATOM   1396  C   ALA A 170     -20.393  35.876  46.100  1.00 16.64           C  
ATOM   1397  O   ALA A 170     -21.066  35.916  47.160  1.00 17.28           O  
ATOM   1398  CB  ALA A 170     -21.166  37.433  44.247  1.00 15.17           C  
ATOM   1399  N   GLU A 171     -19.879  34.744  45.602  1.00 17.79           N  
ATOM   1400  CA  GLU A 171     -20.124  33.483  46.294  1.00 19.81           C  
ATOM   1401  C   GLU A 171     -19.401  33.512  47.646  1.00 19.15           C  
ATOM   1402  O   GLU A 171     -19.967  33.083  48.670  1.00 20.07           O  
ATOM   1403  CB  GLU A 171     -19.593  32.329  45.432  1.00 21.14           C  
ATOM   1404  CG  GLU A 171     -19.617  30.968  46.090  1.00 27.76           C  
ATOM   1405  CD  GLU A 171     -20.392  29.999  45.245  1.00 36.62           C  
ATOM   1406  OE1 GLU A 171     -21.643  29.953  45.391  1.00 41.81           O  
ATOM   1407  OE2 GLU A 171     -19.756  29.338  44.399  1.00 41.08           O  
ATOM   1408  N   ILE A 172     -18.178  34.027  47.669  1.00 17.70           N  
ATOM   1409  CA  ILE A 172     -17.374  34.049  48.899  1.00 17.06           C  
ATOM   1410  C   ILE A 172     -18.030  35.044  49.867  1.00 17.93           C  
ATOM   1411  O   ILE A 172     -18.133  34.812  51.094  1.00 19.66           O  
ATOM   1412  CB  ILE A 172     -15.879  34.454  48.616  1.00 16.78           C  
ATOM   1413  CG1 ILE A 172     -15.112  33.388  47.839  1.00 17.54           C  
ATOM   1414  CG2 ILE A 172     -15.103  34.684  49.964  1.00 17.08           C  
ATOM   1415  CD1 ILE A 172     -13.814  33.919  47.212  1.00 19.28           C  
ATOM   1416  N   ALA A 173     -18.540  36.145  49.343  1.00 17.42           N  
ATOM   1417  CA  ALA A 173     -19.162  37.192  50.155  1.00 17.90           C  
ATOM   1418  C   ALA A 173     -20.548  36.814  50.669  1.00 18.71           C  
ATOM   1419  O   ALA A 173     -21.084  37.465  51.566  1.00 20.02           O  
ATOM   1420  CB  ALA A 173     -19.243  38.500  49.356  1.00 17.62           C  
ATOM   1421  N   GLY A 174     -21.162  35.805  50.060  1.00 19.21           N  
ATOM   1422  CA  GLY A 174     -22.495  35.378  50.407  1.00 20.17           C  
ATOM   1423  C   GLY A 174     -23.606  36.267  49.882  1.00 19.97           C  
ATOM   1424  O   GLY A 174     -24.678  36.368  50.511  1.00 21.82           O  
ATOM   1425  N   VAL A 175     -23.413  36.892  48.709  1.00 17.82           N  
ATOM   1426  CA  VAL A 175     -24.467  37.712  48.134  1.00 18.30           C  
ATOM   1427  C   VAL A 175     -24.709  37.300  46.702  1.00 18.71           C  
ATOM   1428  O   VAL A 175     -23.884  36.575  46.121  1.00 18.59           O  
ATOM   1429  CB  VAL A 175     -24.177  39.234  48.182  1.00 17.58           C  
ATOM   1430  CG1 VAL A 175     -23.982  39.745  49.628  1.00 19.04           C  
ATOM   1431  CG2 VAL A 175     -22.978  39.636  47.342  1.00 17.81           C  
ATOM   1432  N   ASP A 176     -25.813  37.790  46.175  1.00 18.56           N  
ATOM   1433  CA  ASP A 176     -26.049  37.665  44.746  1.00 19.52           C  
ATOM   1434  C   ASP A 176     -25.471  38.931  44.143  1.00 18.45           C  
ATOM   1435  O   ASP A 176     -25.924  40.038  44.516  1.00 18.27           O  
ATOM   1436  CB  ASP A 176     -27.535  37.568  44.472  1.00 20.93           C  
ATOM   1437  CG  ASP A 176     -27.806  37.463  42.987  1.00 23.08           C  
ATOM   1438  OD1 ASP A 176     -27.556  36.376  42.418  1.00 29.53           O  
ATOM   1439  OD2 ASP A 176     -28.189  38.442  42.330  1.00 24.10           O  
ATOM   1440  N   ALA A 177     -24.558  38.767  43.170  1.00 19.01           N  
ATOM   1441  CA  ALA A 177     -23.867  39.925  42.593  1.00 19.36           C  
ATOM   1442  C   ALA A 177     -24.819  40.965  42.038  1.00 18.84           C  
ATOM   1443  O   ALA A 177     -24.689  42.155  42.292  1.00 19.23           O  
ATOM   1444  CB  ALA A 177     -22.869  39.470  41.507  1.00 19.39           C  
ATOM   1445  N   GLU A 178     -25.810  40.529  41.269  0.50 19.00           N  
ATOM   1447  CA  GLU A 178     -26.703  41.482  40.647  0.50 20.12           C  
ATOM   1449  C   GLU A 178     -27.649  42.183  41.622  0.50 19.65           C  
ATOM   1451  O   GLU A 178     -27.882  43.378  41.536  0.50 20.03           O  
ATOM   1453  CB  GLU A 178     -27.493  40.790  39.534  0.50 20.41           C  
ATOM   1455  CG  GLU A 178     -26.599  40.153  38.492  0.50 23.73           C  
ATOM   1457  CD  GLU A 178     -26.401  41.034  37.293  0.50 25.32           C  
ATOM   1459  OE1 GLU A 178     -27.065  42.094  37.214  0.50 27.13           O  
ATOM   1461  OE2 GLU A 178     -25.569  40.668  36.443  0.50 24.66           O  
ATOM   1463  N   GLU A 179     -28.186  41.422  42.568  1.00 20.88           N  
ATOM   1464  CA  GLU A 179     -29.088  41.972  43.541  1.00 20.27           C  
ATOM   1465  C   GLU A 179     -28.374  42.959  44.504  1.00 19.07           C  
ATOM   1466  O   GLU A 179     -28.848  44.103  44.697  1.00 17.61           O  
ATOM   1467  CB  GLU A 179     -29.619  40.769  44.337  1.00 22.67           C  
ATOM   1468  CG  GLU A 179     -30.598  41.080  45.437  1.00 27.92           C  
ATOM   1469  CD  GLU A 179     -31.147  39.794  46.076  1.00 33.88           C  
ATOM   1470  OE1 GLU A 179     -30.389  39.093  46.799  1.00 34.55           O  
ATOM   1471  OE2 GLU A 179     -32.336  39.470  45.828  1.00 37.52           O  
ATOM   1472  N   TYR A 180     -27.234  42.521  45.030  1.00 17.57           N  
ATOM   1473  CA  TYR A 180     -26.409  43.407  45.853  1.00 16.61           C  
ATOM   1474  C   TYR A 180     -25.947  44.618  45.040  1.00 16.39           C  
ATOM   1475  O   TYR A 180     -26.047  45.765  45.476  1.00 15.61           O  
ATOM   1476  CB  TYR A 180     -25.217  42.629  46.430  1.00 16.43           C  
ATOM   1477  CG  TYR A 180     -24.192  43.601  46.976  1.00 14.86           C  
ATOM   1478  CD1 TYR A 180     -24.345  44.179  48.246  1.00 16.13           C  
ATOM   1479  CD2 TYR A 180     -23.078  43.962  46.212  1.00 14.15           C  
ATOM   1480  CE1 TYR A 180     -23.443  45.122  48.715  1.00 15.45           C  
ATOM   1481  CE2 TYR A 180     -22.159  44.934  46.674  1.00 12.94           C  
ATOM   1482  CZ  TYR A 180     -22.372  45.495  47.924  1.00 13.12           C  
ATOM   1483  OH  TYR A 180     -21.513  46.434  48.433  1.00 14.53           O  
ATOM   1484  N   GLY A 181     -25.487  44.367  43.821  1.00 16.05           N  
ATOM   1485  CA  GLY A 181     -24.966  45.456  43.021  1.00 15.80           C  
ATOM   1486  C   GLY A 181     -25.948  46.525  42.672  1.00 16.43           C  
ATOM   1487  O   GLY A 181     -25.602  47.714  42.709  1.00 16.95           O  
ATOM   1488  N   LEU A 182     -27.206  46.132  42.374  1.00 16.77           N  
ATOM   1489  CA  LEU A 182     -28.194  47.166  42.147  1.00 18.71           C  
ATOM   1490  C   LEU A 182     -28.410  48.056  43.340  1.00 17.11           C  
ATOM   1491  O   LEU A 182     -28.568  49.275  43.199  1.00 18.06           O  
ATOM   1492  CB  LEU A 182     -29.542  46.571  41.729  1.00 20.45           C  
ATOM   1493  CG  LEU A 182     -29.594  46.116  40.298  1.00 22.30           C  
ATOM   1494  CD1 LEU A 182     -30.915  45.374  40.119  1.00 25.39           C  
ATOM   1495  CD2 LEU A 182     -29.481  47.343  39.350  1.00 20.83           C  
ATOM   1496  N   ASN A 183     -28.427  47.451  44.543  1.00 17.31           N  
ATOM   1497  CA  ASN A 183     -28.633  48.278  45.731  1.00 17.85           C  
ATOM   1498  C   ASN A 183     -27.432  49.189  45.983  1.00 16.33           C  
ATOM   1499  O   ASN A 183     -27.589  50.375  46.344  1.00 17.73           O  
ATOM   1500  CB  ASN A 183     -28.856  47.406  46.949  1.00 19.09           C  
ATOM   1501  CG  ASN A 183     -30.215  46.730  46.940  1.00 20.63           C  
ATOM   1502  OD1 ASN A 183     -30.319  45.569  47.311  1.00 24.07           O  
ATOM   1503  ND2 ASN A 183     -31.240  47.466  46.545  1.00 22.41           N  
ATOM   1504  N   MET A 184     -26.223  48.674  45.727  1.00 15.17           N  
ATOM   1505  CA  MET A 184     -25.029  49.493  45.942  1.00 13.56           C  
ATOM   1506  C   MET A 184     -24.971  50.666  44.962  1.00 14.37           C  
ATOM   1507  O   MET A 184     -24.704  51.797  45.333  1.00 14.52           O  
ATOM   1508  CB  MET A 184     -23.800  48.643  45.768  1.00 13.69           C  
ATOM   1509  CG  MET A 184     -22.513  49.439  46.125  1.00 12.67           C  
ATOM   1510  SD  MET A 184     -21.031  48.658  45.394  1.00 14.42           S  
ATOM   1511  CE  MET A 184     -21.250  49.169  43.701  1.00 15.60           C  
ATOM   1512  N   LEU A 185     -25.306  50.385  43.702  1.00 14.61           N  
ATOM   1513  CA  LEU A 185     -25.288  51.435  42.689  1.00 15.70           C  
ATOM   1514  C   LEU A 185     -26.337  52.516  42.987  1.00 17.01           C  
ATOM   1515  O   LEU A 185     -26.069  53.703  42.848  1.00 19.17           O  
ATOM   1516  CB  LEU A 185     -25.506  50.822  41.294  1.00 16.70           C  
ATOM   1517  CG  LEU A 185     -24.293  50.028  40.785  1.00 15.31           C  
ATOM   1518  CD1 LEU A 185     -24.663  49.232  39.515  1.00 16.71           C  
ATOM   1519  CD2 LEU A 185     -23.134  50.936  40.528  1.00 17.70           C  
ATOM   1520  N   LYS A 186     -27.514  52.083  43.451  1.00 19.59           N  
ATOM   1521  CA  LYS A 186     -28.614  52.996  43.774  1.00 21.84           C  
ATOM   1522  C   LYS A 186     -28.233  53.951  44.904  1.00 21.90           C  
ATOM   1523  O   LYS A 186     -28.604  55.132  44.925  1.00 22.33           O  
ATOM   1524  CB  LYS A 186     -29.866  52.188  44.148  1.00 22.96           C  
ATOM   1525  CG  LYS A 186     -31.091  52.999  44.538  1.00 27.89           C  
ATOM   1526  CD  LYS A 186     -32.342  52.142  44.411  1.00 32.73           C  
ATOM   1527  CE  LYS A 186     -32.656  51.392  45.699  1.00 36.47           C  
ATOM   1528  NZ  LYS A 186     -34.131  51.491  45.956  1.00 37.91           N  
ATOM   1529  N   ALA A 187     -27.378  53.449  45.810  1.00 21.76           N  
ATOM   1530  CA  ALA A 187     -26.942  54.223  46.946  1.00 21.96           C  
ATOM   1531  C   ALA A 187     -26.035  55.376  46.545  1.00 22.70           C  
ATOM   1532  O   ALA A 187     -25.892  56.339  47.297  1.00 23.46           O  
ATOM   1533  CB  ALA A 187     -26.219  53.301  47.985  1.00 21.36           C  
ATOM   1534  N   GLY A 188     -25.413  55.298  45.371  1.00 21.90           N  
ATOM   1535  CA  GLY A 188     -24.609  56.388  44.881  1.00 25.01           C  
ATOM   1536  C   GLY A 188     -25.370  57.365  44.028  1.00 27.08           C  
ATOM   1537  O   GLY A 188     -24.779  58.352  43.592  1.00 27.93           O  
ATOM   1538  OXT GLY A 188     -26.565  57.112  43.792  1.00 30.13           O  
TER    1539      GLY A 188                                                      
END
MOLECULE T0501_2_214.pdb
ATOM      1  CB  LEU     2      -9.118  30.738  34.125  1.00 51.67          
ATOM      2  CG  LEU     2     -10.314  30.118  34.866  1.00 53.86          
ATOM      3  CD1 LEU     2     -11.388  29.708  33.864  1.00 54.66          
ATOM      4  CD2 LEU     2      -9.859  28.897  35.667  1.00 54.00          
ATOM      5  C   LEU     2      -6.735  31.546  34.073  1.00 48.54          
ATOM      6  O   LEU     2      -5.767  30.796  34.138  1.00 49.26          
ATOM      7  N   LEU     2      -8.396  32.565  35.655  1.00 50.89          
ATOM      8  CA  LEU     2      -7.962  31.312  34.963  1.00 49.96          
ATOM      9  N   THR     3      -6.780  32.590  33.254  1.00 46.10          
ATOM     10  CA  THR     3      -5.683  32.929  32.353  1.00 45.01          
ATOM     11  CB  THR     3      -6.219  33.711  31.127  1.00 45.64          
ATOM     12  OG1 THR     3      -7.112  32.873  30.384  1.00 47.96          
ATOM     13  CG2 THR     3      -5.093  34.165  30.226  1.00 42.04          
ATOM     14  C   THR     3      -4.635  33.777  33.073  1.00 45.61          
ATOM     15  O   THR     3      -4.978  34.589  33.928  1.00 45.72          
ATOM     16  N   LYS     4      -3.361  33.589  32.727  1.00 45.17          
ATOM     17  CA  LYS     4      -2.269  34.343  33.350  1.00 44.57          
ATOM     18  CB  LYS     4      -0.961  33.536  33.320  1.00 45.36          
ATOM     19  CG  LYS     4      -0.965  32.307  34.221  1.00 48.99          
ATOM     20  CD  LYS     4       0.398  31.634  34.276  1.00 49.41          
ATOM     21  CE  LYS     4       0.359  30.402  35.179  1.00 52.94          
ATOM     22  NZ  LYS     4       1.684  29.705  35.252  1.00 53.72          
ATOM     23  C   LYS     4      -2.044  35.683  32.660  1.00 41.65          
ATOM     24  O   LYS     4      -1.392  35.751  31.622  1.00 43.14          
ATOM     25  N   VAL     5      -2.581  36.746  33.247  1.00 38.71          
ATOM     26  CA  VAL     5      -2.449  38.087  32.694  1.00 35.10          
ATOM     27  CB  VAL     5      -3.719  38.935  32.989  1.00 35.84          
ATOM     28  CG1 VAL     5      -3.490  40.413  32.581  1.00 35.47          
ATOM     29  CG2 VAL     5      -4.909  38.356  32.228  1.00 33.49          
ATOM     30  C   VAL     5      -1.230  38.803  33.256  1.00 34.67          
ATOM     31  O   VAL     5      -0.446  39.389  32.512  1.00 34.53          
ATOM     32  N   ILE     6      -1.081  38.777  34.575  1.00 35.13          
ATOM     33  CA  ILE     6       0.052  39.425  35.220  1.00 34.65          
ATOM     34  CB  ILE     6      -0.186  39.580  36.737  1.00 34.25          
ATOM     35  CG2 ILE     6       1.015  40.268  37.390  1.00 31.59          
ATOM     36  CG1 ILE     6      -1.479  40.370  36.987  1.00 33.48          
ATOM     37  CD  ILE     6      -1.867  40.457  38.449  1.00 28.08          
ATOM     38  C   ILE     6       1.316  38.592  35.005  1.00 36.03          
ATOM     39  O   ILE     6       1.293  37.358  35.133  1.00 34.96          
ATOM     40  N   ALA     7       2.410  39.270  34.677  1.00 35.53          
ATOM     41  CA  ALA     7       3.688  38.599  34.454  1.00 40.36          
ATOM     42  CB  ALA     7       4.716  39.599  33.927  1.00 38.81          
ATOM     43  C   ALA     7       4.207  37.938  35.732  1.00 40.87          
ATOM     44  O   ALA     7       4.298  38.573  36.779  1.00 45.09          
ATOM     45  N   GLN     8       4.545  36.657  35.636  1.00 42.36          
ATOM     46  CA  GLN     8       5.055  35.903  36.773  1.00 42.67          
ATOM     47  CB  GLN     8       5.416  34.485  36.337  1.00 42.33          
ATOM     48  CG  GLN     8       5.795  33.566  37.488  1.00 43.24          
ATOM     49  CD  GLN     8       4.603  33.197  38.345  1.00 42.83          
ATOM     50  OE1 GLN     8       3.578  32.755  37.829  1.00 43.63          
ATOM     51  NE2 GLN     8       4.730  33.369  39.659  1.00 42.46          
ATOM     52  C   GLN     8       6.285  36.560  37.406  1.00 43.98          
ATOM     53  O   GLN     8       6.493  36.463  38.617  1.00 45.06          
ATOM     54  N   ALA     9       7.111  37.210  36.593  1.00 42.49          
ATOM     55  CA  ALA     9       8.298  37.862  37.124  1.00 43.37          
ATOM     56  CB  ALA     9       9.098  38.497  36.005  1.00 42.79          
ATOM     57  C   ALA     9       7.874  38.922  38.133  1.00 43.16          
ATOM     58  O   ALA     9       8.433  39.003  39.224  1.00 43.57          
ATOM     59  N   HSD    10       6.879  39.728  37.767  1.00 43.39          
ATOM     60  CA  HSD    10       6.378  40.775  38.656  1.00 42.97          
ATOM     61  CB  HSD    10       5.314  41.637  37.953  1.00 43.19          
ATOM     62  CG  HSD    10       5.860  42.491  36.848  1.00 43.10          
ATOM     63  CD2 HSD    10       5.242  43.290  35.945  1.00 42.11          
ATOM     64  ND1 HSD    10       7.209  42.592  36.585  1.00 42.30          
ATOM     65  CE1 HSD    10       7.400  43.415  35.569  1.00 42.04          
ATOM     66  NE2 HSD    10       6.223  43.853  35.162  1.00 43.04          
ATOM     67  C   HSD    10       5.797  40.156  39.921  1.00 42.31          
ATOM     68  O   HSD    10       6.043  40.647  41.023  1.00 43.53          
ATOM     69  N   ILE    11       5.041  39.073  39.771  1.00 40.92          
ATOM     70  CA  ILE    11       4.459  38.406  40.933  1.00 39.12          
ATOM     71  CB  ILE    11       3.550  37.251  40.516  1.00 38.41          
ATOM     72  CG2 ILE    11       3.084  36.472  41.746  1.00 36.95          
ATOM     73  CG1 ILE    11       2.343  37.798  39.762  1.00 38.19          
ATOM     74  CD  ILE    11       1.493  36.728  39.145  1.00 36.04          
ATOM     75  C   ILE    11       5.555  37.859  41.845  1.00 40.95          
ATOM     76  O   ILE    11       5.434  37.897  43.070  1.00 41.13          
ATOM     77  N   ASP    12       6.625  37.345  41.250  1.00 41.17          
ATOM     78  CA  ASP    12       7.722  36.813  42.041  1.00 39.63          
ATOM     79  CB  ASP    12       8.733  36.075  41.145  1.00 41.10          
ATOM     80  CG  ASP    12       8.187  34.764  40.592  1.00 45.36          
ATOM     81  OD1 ASP    12       7.295  34.167  41.236  1.00 46.36          
ATOM     82  OD2 ASP    12       8.665  34.318  39.525  1.00 45.15          
ATOM     83  C   ASP    12       8.427  37.947  42.792  1.00 38.33          
ATOM     84  O   ASP    12       8.723  37.822  43.973  1.00 37.84          
ATOM     85  N   HSD    13       8.685  39.050  42.099  1.00 37.35          
ATOM     86  CA  HSD    13       9.360  40.196  42.690  1.00 39.45          
ATOM     87  CB  HSD    13       9.590  41.260  41.610  1.00 40.12          
ATOM     88  CG  HSD    13      10.658  42.253  41.949  1.00 41.22          
ATOM     89  CD2 HSD    13      11.393  42.426  43.072  1.00 42.23          
ATOM     90  ND1 HSD    13      11.090  43.212  41.058  1.00 42.76          
ATOM     91  CE1 HSD    13      12.046  43.933  41.617  1.00 41.42          
ATOM     92  NE2 HSD    13      12.250  43.476  42.839  1.00 40.50          
ATOM     93  C   HSD    13       8.562  40.786  43.860  1.00 40.08          
ATOM     94  O   HSD    13       9.110  41.060  44.929  1.00 41.01          
ATOM     95  N   PHE    14       7.261  40.970  43.661  1.00 39.38          
ATOM     96  CA  PHE    14       6.418  41.523  44.709  1.00 37.21          
ATOM     97  CB  PHE    14       5.003  41.780  44.192  1.00 36.26          
ATOM     98  CG  PHE    14       4.072  42.304  45.245  1.00 36.60          
ATOM     99  CD1 PHE    14       4.258  43.577  45.781  1.00 36.10          
ATOM    100  CD2 PHE    14       3.048  41.514  45.742  1.00 35.62          
ATOM    101  CE1 PHE    14       3.443  44.049  46.794  1.00 34.53          
ATOM    102  CE2 PHE    14       2.223  41.981  46.763  1.00 37.98          
ATOM    103  CZ  PHE    14       2.424  43.250  47.288  1.00 36.03          
ATOM    104  C   PHE    14       6.348  40.594  45.909  1.00 38.11          
ATOM    105  O   PHE    14       6.388  41.048  47.054  1.00 38.55          
ATOM    106  N   THR    15       6.222  39.296  45.653  1.00 37.59          
ATOM    107  CA  THR    15       6.157  38.325  46.735  1.00 39.05          
ATOM    108  CB  THR    15       6.103  36.890  46.205  1.00 36.44          
ATOM    109  OG1 THR    15       4.966  36.742  45.345  1.00 38.35          
ATOM    110  CG2 THR    15       5.963  35.912  47.352  1.00 34.02          
ATOM    111  C   THR    15       7.400  38.484  47.606  1.00 42.40          
ATOM    112  O   THR    15       7.339  38.328  48.828  1.00 42.29          
ATOM    113  N   LYS    16       8.527  38.797  46.969  1.00 44.18          
ATOM    114  CA  LYS    16       9.778  39.007  47.694  1.00 44.92          
ATOM    115  CB  LYS    16      10.915  39.323  46.713  1.00 48.14          
ATOM    116  CG  LYS    16      12.274  39.551  47.371  1.00 52.51          
ATOM    117  CD  LYS    16      13.345  39.979  46.361  1.00 55.04          
ATOM    118  CE  LYS    16      13.644  38.873  45.356  1.00 56.85          
ATOM    119  NZ  LYS    16      14.735  39.260  44.414  1.00 58.69          
ATOM    120  C   LYS    16       9.572  40.183  48.652  1.00 43.53          
ATOM    121  O   LYS    16       9.674  40.026  49.868  1.00 42.77          
ATOM    122  N   TRP    17       9.289  41.359  48.097  1.00 41.76          
ATOM    123  CA  TRP    17       9.045  42.553  48.901  1.00 41.20          
ATOM    124  CB  TRP    17       8.451  43.664  48.036  1.00 39.38          
ATOM    125  CG  TRP    17       9.375  44.302  47.035  1.00 37.40          
ATOM    126  CD2 TRP    17       9.049  45.382  46.143  1.00 34.69          
ATOM    127  CE2 TRP    17      10.204  45.659  45.381  1.00 32.93          
ATOM    128  CE3 TRP    17       7.890  46.136  45.915  1.00 31.13          
ATOM    129  CD1 TRP    17      10.678  43.983  46.787  1.00 36.45          
ATOM    130  NE1 TRP    17      11.184  44.796  45.792  1.00 34.75          
ATOM    131  CZ2 TRP    17      10.235  46.660  44.406  1.00 33.80          
ATOM    132  CZ3 TRP    17       7.919  47.130  44.949  1.00 32.34          
ATOM    133  CH2 TRP    17       9.084  47.383  44.203  1.00 33.90          
ATOM    134  C   TRP    17       8.044  42.244  50.022  1.00 43.35          
ATOM    135  O   TRP    17       8.238  42.608  51.179  1.00 43.42          
ATOM    136  N   PHE    18       6.968  41.564  49.645  1.00 44.83          
ATOM    137  CA  PHE    18       5.879  41.199  50.543  1.00 45.58          
ATOM    138  CB  PHE    18       4.843  40.373  49.771  1.00 44.15          
ATOM    139  CG  PHE    18       3.866  39.646  50.647  1.00 40.28          
ATOM    140  CD1 PHE    18       2.867  40.333  51.318  1.00 39.22          
ATOM    141  CD2 PHE    18       3.951  38.268  50.799  1.00 38.13          
ATOM    142  CE1 PHE    18       1.958  39.654  52.130  1.00 40.88          
ATOM    143  CE2 PHE    18       3.058  37.580  51.602  1.00 37.25          
ATOM    144  CZ  PHE    18       2.054  38.273  52.273  1.00 38.48          
ATOM    145  C   PHE    18       6.257  40.451  51.813  1.00 48.27          
ATOM    146  O   PHE    18       5.813  40.806  52.905  1.00 48.40          
ATOM    147  N   GLU    19       7.061  39.406  51.677  1.00 50.96          
ATOM    148  CA  GLU    19       7.450  38.619  52.834  1.00 52.43          
ATOM    149  CB  GLU    19       7.977  37.267  52.359  1.00 55.35          
ATOM    150  CG  GLU    19       6.900  36.491  51.606  1.00 59.69          
ATOM    151  CD  GLU    19       7.355  35.133  51.120  1.00 63.06          
ATOM    152  OE1 GLU    19       8.409  35.061  50.443  1.00 64.77          
ATOM    153  OE2 GLU    19       6.646  34.140  51.407  1.00 64.02          
ATOM    154  C   GLU    19       8.451  39.331  53.736  1.00 51.66          
ATOM    155  O   GLU    19       8.501  39.087  54.941  1.00 50.92          
ATOM    156  N   ARG    20       9.217  40.240  53.150  1.00 51.24          
ATOM    157  CA  ARG    20      10.220  40.998  53.883  1.00 52.55          
ATOM    158  CB  ARG    20      11.332  41.426  52.919  1.00 55.09          
ATOM    159  CG  ARG    20      12.409  42.314  53.530  1.00 60.07          
ATOM    160  CD  ARG    20      13.466  42.689  52.488  1.00 64.44          
ATOM    161  NE  ARG    20      14.431  43.670  52.986  1.00 67.58          
ATOM    162  CZ  ARG    20      15.436  44.161  52.263  1.00 68.91          
ATOM    163  NH1 ARG    20      15.609  43.759  51.008  1.00 68.88          
ATOM    164  NH2 ARG    20      16.263  45.059  52.789  1.00 69.46          
ATOM    165  C   ARG    20       9.642  42.238  54.580  1.00 51.72          
ATOM    166  O   ARG    20      10.138  42.663  55.627  1.00 51.01          
ATOM    167  N   ALA    21       8.588  42.803  53.999  1.00 49.64          
ATOM    168  CA  ALA    21       7.963  44.009  54.528  1.00 47.85          
ATOM    169  CB  ALA    21       6.974  44.561  53.498  1.00 49.46          
ATOM    170  C   ALA    21       7.262  43.872  55.875  1.00 47.01          
ATOM    171  O   ALA    21       6.695  42.825  56.189  1.00 47.44          
ATOM    172  N   ASP    22       7.317  44.945  56.665  1.00 45.09          
ATOM    173  CA  ASP    22       6.652  45.007  57.967  1.00 45.38          
ATOM    174  CB  ASP    22       7.620  45.424  59.083  1.00 47.61          
ATOM    175  CG  ASP    22       8.679  44.373  59.379  1.00 52.55          
ATOM    176  OD1 ASP    22       8.313  43.191  59.585  1.00 54.15          
ATOM    177  OD2 ASP    22       9.879  44.740  59.418  1.00 53.54          
ATOM    178  C   ASP    22       5.559  46.073  57.878  1.00 42.79          
ATOM    179  O   ASP    22       4.439  45.876  58.331  1.00 41.20          
ATOM    180  N   LYS    23       5.917  47.211  57.296  1.00 41.31          
ATOM    181  CA  LYS    23       5.007  48.338  57.156  1.00 40.07          
ATOM    182  CB  LYS    23       5.647  49.611  57.723  1.00 40.15          
ATOM    183  CG  LYS    23       5.723  49.667  59.242  1.00 42.44          
ATOM    184  CD  LYS    23       7.143  49.463  59.732  1.00 45.87          
ATOM    185  CE  LYS    23       7.257  49.684  61.238  1.00 47.87          
ATOM    186  NZ  LYS    23       8.680  49.605  61.691  1.00 47.06          
ATOM    187  C   LYS    23       4.652  48.567  55.700  1.00 38.87          
ATOM    188  O   LYS    23       5.535  48.732  54.851  1.00 39.02          
ATOM    189  N   ILE    24       3.358  48.584  55.408  1.00 37.82          
ATOM    190  CA  ILE    24       2.925  48.788  54.037  1.00 35.88          
ATOM    191  CB  ILE    24       2.339  47.494  53.427  1.00 35.91          
ATOM    192  CG2 ILE    24       2.009  47.724  51.954  1.00 35.08          
ATOM    193  CG1 ILE    24       3.343  46.346  53.559  1.00 35.23          
ATOM    194  CD  ILE    24       2.796  44.996  53.099  1.00 34.91          
ATOM    195  C   ILE    24       1.885  49.881  53.924  1.00 35.76          
ATOM    196  O   ILE    24       1.001  50.003  54.765  1.00 37.25          
ATOM    197  N   VAL    25       2.009  50.689  52.878  1.00 34.59          
ATOM    198  CA  VAL    25       1.058  51.753  52.632  1.00 31.66          
ATOM    199  CB  VAL    25       1.732  53.134  52.735  1.00 33.26          
ATOM    200  CG1 VAL    25       0.844  54.202  52.114  1.00 28.81          
ATOM    201  CG2 VAL    25       2.003  53.455  54.208  1.00 29.92          
ATOM    202  C   VAL    25       0.456  51.571  51.243  1.00 31.50          
ATOM    203  O   VAL    25       1.177  51.307  50.288  1.00 30.16          
ATOM    204  N   ILE    26      -0.870  51.690  51.160  1.00 30.40          
ATOM    205  CA  ILE    26      -1.617  51.567  49.915  1.00 29.14          
ATOM    206  CB  ILE    26      -2.797  50.582  50.066  1.00 28.76          
ATOM    207  CG2 ILE    26      -3.640  50.592  48.809  1.00 27.27          
ATOM    208  CG1 ILE    26      -2.281  49.164  50.345  1.00 28.35          
ATOM    209  CD  ILE    26      -3.368  48.215  50.877  1.00 27.30          
ATOM    210  C   ILE    26      -2.188  52.947  49.589  1.00 29.36          
ATOM    211  O   ILE    26      -2.909  53.531  50.405  1.00 28.32          
ATOM    212  N   VAL    27      -1.874  53.460  48.401  1.00 29.54          
ATOM    213  CA  VAL    27      -2.351  54.773  47.978  1.00 31.52          
ATOM    214  CB  VAL    27      -1.174  55.694  47.634  1.00 32.36          
ATOM    215  CG1 VAL    27      -1.690  57.060  47.194  1.00 35.16          
ATOM    216  CG2 VAL    27      -0.272  55.828  48.828  1.00 34.15          
ATOM    217  C   VAL    27      -3.255  54.704  46.756  1.00 30.07          
ATOM    218  O   VAL    27      -3.071  53.866  45.892  1.00 33.33          
ATOM    219  N   SER    28      -4.237  55.590  46.677  1.00 31.28          
ATOM    220  CA  SER    28      -5.129  55.597  45.525  1.00 32.25          
ATOM    221  CB  SER    28      -6.419  54.843  45.840  1.00 35.92          
ATOM    222  OG  SER    28      -7.076  54.470  44.640  1.00 36.38          
ATOM    223  C   SER    28      -5.406  57.039  45.124  1.00 32.58          
ATOM    224  O   SER    28      -5.047  57.964  45.855  1.00 33.65          
ATOM    225  N   HSD    29      -6.061  57.228  43.978  1.00 33.91          
ATOM    226  CA  HSD    29      -6.293  58.562  43.408  1.00 33.32          
ATOM    227  CB  HSD    29      -6.619  58.408  41.907  1.00 33.19          
ATOM    228  CG  HSD    29      -7.991  57.872  41.623  1.00 34.83          
ATOM    229  CD2 HSD    29      -8.396  56.703  41.068  1.00 32.63          
ATOM    230  ND1 HSD    29      -9.142  58.593  41.871  1.00 36.71          
ATOM    231  CE1 HSD    29     -10.193  57.894  41.477  1.00 34.83          
ATOM    232  NE2 HSD    29      -9.768  56.746  40.985  1.00 34.02          
ATOM    233  C   HSD    29      -7.270  59.560  44.040  1.00 33.50          
ATOM    234  O   HSD    29      -8.182  59.190  44.777  1.00 34.48          
ATOM    235  N   VAL    30      -7.045  60.839  43.734  1.00 33.88          
ATOM    236  CA  VAL    30      -7.872  61.949  44.214  1.00 32.40          
ATOM    237  CB  VAL    30      -7.470  63.287  43.519  1.00 34.85          
ATOM    238  CG1 VAL    30      -7.882  63.268  42.035  1.00 34.37          
ATOM    239  CG2 VAL    30      -8.101  64.471  44.238  1.00 34.77          
ATOM    240  C   VAL    30      -9.339  61.634  43.919  1.00 33.17          
ATOM    241  O   VAL    30      -9.652  60.980  42.919  1.00 34.06          
ATOM    242  N   SER    31     -10.234  62.096  44.785  1.00 32.93          
ATOM    243  CA  SER    31     -11.661  61.827  44.628  1.00 33.69          
ATOM    244  CB  SER    31     -12.251  62.660  43.491  1.00 34.58          
ATOM    245  OG  SER    31     -12.244  64.030  43.841  1.00 39.90          
ATOM    246  C   SER    31     -11.854  60.351  44.329  1.00 31.45          
ATOM    247  O   SER    31     -12.452  59.986  43.314  1.00 32.18          
ATOM    248  N   PRO    32     -11.347  59.480  45.219  1.00 30.81          
ATOM    249  CD  PRO    32     -10.776  59.775  46.546  1.00 28.03          
ATOM    250  CA  PRO    32     -11.476  58.035  45.016  1.00 28.92          
ATOM    251  CB  PRO    32     -10.767  57.446  46.244  1.00 28.88          
ATOM    252  CG  PRO    32     -11.023  58.483  47.300  1.00 27.92          
ATOM    253  C   PRO    32     -12.925  57.591  44.904  1.00 28.55          
ATOM    254  O   PRO    32     -13.799  58.114  45.603  1.00 30.11          
ATOM    255  N   ASP    33     -13.164  56.627  44.015  1.00 29.12          
ATOM    256  CA  ASP    33     -14.493  56.060  43.786  1.00 29.45          
ATOM    257  CB  ASP    33     -14.912  56.230  42.323  1.00 29.48          
ATOM    258  CG  ASP    33     -13.934  55.576  41.348  1.00 30.94          
ATOM    259  OD1 ASP    33     -13.019  54.848  41.778  1.00 32.90          
ATOM    260  OD2 ASP    33     -14.082  55.793  40.134  1.00 33.35          
ATOM    261  C   ASP    33     -14.534  54.570  44.149  1.00 28.90          
ATOM    262  O   ASP    33     -13.629  54.047  44.802  1.00 29.73          
ATOM    263  N   GLY    34     -15.590  53.896  43.703  1.00 26.63          
ATOM    264  CA  GLY    34     -15.758  52.486  43.991  1.00 26.40          
ATOM    265  C   GLY    34     -14.551  51.611  43.723  1.00 28.12          
ATOM    266  O   GLY    34     -14.171  50.807  44.580  1.00 28.23          
ATOM    267  N   ASP    35     -13.933  51.768  42.555  1.00 27.14          
ATOM    268  CA  ASP    35     -12.775  50.947  42.200  1.00 28.32          
ATOM    269  CB  ASP    35     -12.572  50.944  40.673  1.00 29.30          
ATOM    270  CG  ASP    35     -11.587  49.880  40.207  1.00 31.44          
ATOM    271  OD1 ASP    35     -11.466  48.836  40.882  1.00 31.59          
ATOM    272  OD2 ASP    35     -10.947  50.069  39.151  1.00 33.89          
ATOM    273  C   ASP    35     -11.498  51.382  42.914  1.00 26.35          
ATOM    274  O   ASP    35     -10.604  50.575  43.159  1.00 26.54          
ATOM    275  N   ALA    36     -11.398  52.652  43.261  1.00 25.47          
ATOM    276  CA  ALA    36     -10.202  53.096  43.965  1.00 26.79          
ATOM    277  CB  ALA    36     -10.138  54.639  43.984  1.00 24.48          
ATOM    278  C   ALA    36     -10.260  52.535  45.398  1.00 26.45          
ATOM    279  O   ALA    36      -9.297  51.958  45.898  1.00 23.78          
ATOM    280  N   ILE    37     -11.407  52.694  46.048  1.00 25.86          
ATOM    281  CA  ILE    37     -11.579  52.208  47.411  1.00 26.11          
ATOM    282  CB  ILE    37     -12.843  52.813  48.057  1.00 26.33          
ATOM    283  CG2 ILE    37     -12.962  52.332  49.500  1.00 29.36          
ATOM    284  CG1 ILE    37     -12.766  54.344  48.031  1.00 24.81          
ATOM    285  CD  ILE    37     -11.526  54.890  48.684  1.00 22.13          
ATOM    286  C   ILE    37     -11.669  50.676  47.503  1.00 27.36          
ATOM    287  O   ILE    37     -11.055  50.059  48.377  1.00 27.50          
ATOM    288  N   GLY    38     -12.442  50.074  46.604  1.00 27.18          
ATOM    289  CA  GLY    38     -12.605  48.630  46.596  1.00 25.23          
ATOM    290  C   GLY    38     -11.319  47.841  46.393  1.00 26.33          
ATOM    291  O   GLY    38     -11.101  46.850  47.073  1.00 26.12          
ATOM    292  N   SER    39     -10.468  48.271  45.467  1.00 25.60          
ATOM    293  CA  SER    39      -9.220  47.575  45.224  1.00 26.69          
ATOM    294  CB  SER    39      -8.580  48.037  43.909  1.00 27.38          
ATOM    295  OG  SER    39      -8.325  49.430  43.912  1.00 27.36          
ATOM    296  C   SER    39      -8.259  47.815  46.376  1.00 28.36          
ATOM    297  O   SER    39      -7.527  46.903  46.775  1.00 27.38          
ATOM    298  N   SER    40      -8.249  49.039  46.905  1.00 27.65          
ATOM    299  CA  SER    40      -7.375  49.357  48.029  1.00 28.89          
ATOM    300  CB  SER    40      -7.411  50.856  48.336  1.00 28.62          
ATOM    301  OG  SER    40      -6.895  51.600  47.251  1.00 31.32          
ATOM    302  C   SER    40      -7.766  48.568  49.277  1.00 28.20          
ATOM    303  O   SER    40      -6.905  48.034  49.966  1.00 29.02          
ATOM    304  N   LEU    41      -9.060  48.495  49.574  1.00 27.56          
ATOM    305  CA  LEU    41      -9.515  47.754  50.751  1.00 26.91          
ATOM    306  CB  LEU    41     -10.951  48.154  51.108  1.00 23.66          
ATOM    307  CG  LEU    41     -11.219  49.575  51.632  1.00 21.34          
ATOM    308  CD1 LEU    41     -12.706  49.721  51.960  1.00 18.05          
ATOM    309  CD2 LEU    41     -10.388  49.835  52.873  1.00 23.41          
ATOM    310  C   LEU    41      -9.431  46.234  50.518  1.00 27.04          
ATOM    311  O   LEU    41      -9.359  45.453  51.464  1.00 26.84          
ATOM    312  N   GLY    42      -9.457  45.818  49.254  1.00 28.17          
ATOM    313  CA  GLY    42      -9.344  44.404  48.949  1.00 26.80          
ATOM    314  C   GLY    42      -7.924  43.970  49.263  1.00 27.96          
ATOM    315  O   GLY    42      -7.702  42.948  49.910  1.00 30.68          
ATOM    316  N   LEU    43      -6.953  44.750  48.803  1.00 29.79          
ATOM    317  CA  LEU    43      -5.546  44.448  49.071  1.00 30.77          
ATOM    318  CB  LEU    43      -4.637  45.396  48.270  1.00 26.21          
ATOM    319  CG  LEU    43      -3.128  45.160  48.423  1.00 29.21          
ATOM    320  CD1 LEU    43      -2.794  43.731  48.047  1.00 28.13          
ATOM    321  CD2 LEU    43      -2.345  46.134  47.550  1.00 27.64          
ATOM    322  C   LEU    43      -5.303  44.616  50.582  1.00 31.49          
ATOM    323  O   LEU    43      -4.638  43.789  51.222  1.00 32.74          
ATOM    324  N   TYR    44      -5.862  45.684  51.148  1.00 30.11          
ATOM    325  CA  TYR    44      -5.735  45.953  52.575  1.00 30.63          
ATOM    326  CB  TYR    44      -6.651  47.109  52.979  1.00 32.54          
ATOM    327  CG  TYR    44      -6.771  47.318  54.470  1.00 34.40          
ATOM    328  CD1 TYR    44      -5.716  47.844  55.207  1.00 36.25          
ATOM    329  CE1 TYR    44      -5.833  48.048  56.580  1.00 37.78          
ATOM    330  CD2 TYR    44      -7.944  46.992  55.145  1.00 34.48          
ATOM    331  CE2 TYR    44      -8.068  47.187  56.515  1.00 34.71          
ATOM    332  CZ  TYR    44      -7.015  47.718  57.228  1.00 38.46          
ATOM    333  OH  TYR    44      -7.148  47.941  58.587  1.00 39.21          
ATOM    334  C   TYR    44      -6.109  44.726  53.398  1.00 30.77          
ATOM    335  O   TYR    44      -5.304  44.217  54.180  1.00 29.05          
ATOM    336  N   HSD    45      -7.338  44.251  53.235  1.00 31.49          
ATOM    337  CA  HSD    45      -7.774  43.094  54.005  1.00 32.78          
ATOM    338  CB  HSD    45      -9.193  42.698  53.631  1.00 33.36          
ATOM    339  CG  HSD    45     -10.234  43.601  54.208  1.00 35.68          
ATOM    340  CD2 HSD    45     -10.592  43.841  55.491  1.00 35.97          
ATOM    341  ND1 HSD    45     -11.059  44.380  53.428  1.00 36.28          
ATOM    342  CE1 HSD    45     -11.884  45.058  54.204  1.00 36.54          
ATOM    343  NE2 HSD    45     -11.621  44.750  55.460  1.00 37.43          
ATOM    344  C   HSD    45      -6.846  41.904  53.856  1.00 32.83          
ATOM    345  O   HSD    45      -6.539  41.227  54.845  1.00 31.46          
ATOM    346  N   PHE    46      -6.401  41.635  52.630  1.00 31.89          
ATOM    347  CA  PHE    46      -5.482  40.525  52.421  1.00 31.57          
ATOM    348  CB  PHE    46      -5.115  40.376  50.947  1.00 31.48          
ATOM    349  CG  PHE    46      -3.942  39.471  50.732  1.00 29.99          
ATOM    350  CD1 PHE    46      -4.001  38.139  51.143  1.00 29.60          
ATOM    351  CD2 PHE    46      -2.748  39.968  50.221  1.00 29.98          
ATOM    352  CE1 PHE    46      -2.889  37.316  51.060  1.00 29.82          
ATOM    353  CE2 PHE    46      -1.614  39.154  50.127  1.00 30.29          
ATOM    354  CZ  PHE    46      -1.685  37.825  50.551  1.00 32.13          
ATOM    355  C   PHE    46      -4.184  40.728  53.206  1.00 32.52          
ATOM    356  O   PHE    46      -3.769  39.874  53.983  1.00 33.32          
ATOM    357  N   LEU    47      -3.542  41.869  52.989  1.00 32.38          
ATOM    358  CA  LEU    47      -2.290  42.157  53.662  1.00 32.89          
ATOM    359  CB  LEU    47      -1.758  43.515  53.207  1.00 31.48          
ATOM    360  CG  LEU    47      -1.371  43.580  51.725  1.00 30.76          
ATOM    361  CD1 LEU    47      -0.965  44.991  51.368  1.00 28.94          
ATOM    362  CD2 LEU    47      -0.230  42.597  51.442  1.00 30.28          
ATOM    363  C   LEU    47      -2.422  42.126  55.185  1.00 34.82          
ATOM    364  O   LEU    47      -1.545  41.606  55.893  1.00 34.46          
ATOM    365  N   ASP    48      -3.525  42.672  55.688  1.00 36.77          
ATOM    366  CA  ASP    48      -3.756  42.704  57.120  1.00 36.93          
ATOM    367  CB  ASP    48      -4.973  43.577  57.434  1.00 38.42          
ATOM    368  CG  ASP    48      -5.044  43.974  58.897  1.00 41.42          
ATOM    369  OD1 ASP    48      -4.087  44.607  59.387  1.00 43.40          
ATOM    370  OD2 ASP    48      -6.052  43.653  59.558  1.00 43.69          
ATOM    371  C   ASP    48      -3.937  41.294  57.708  1.00 36.86          
ATOM    372  O   ASP    48      -3.667  41.079  58.888  1.00 38.68          
ATOM    373  N   SER    49      -4.382  40.336  56.897  1.00 35.52          
ATOM    374  CA  SER    49      -4.557  38.966  57.387  1.00 36.25          
ATOM    375  CB  SER    49      -5.418  38.134  56.433  1.00 36.08          
ATOM    376  OG  SER    49      -4.663  37.709  55.300  1.00 33.69          
ATOM    377  C   SER    49      -3.193  38.297  57.477  1.00 37.50          
ATOM    378  O   SER    49      -3.053  37.220  58.048  1.00 38.97          
ATOM    379  N   GLN    50      -2.187  38.931  56.898  1.00 37.44          
ATOM    380  CA  GLN    50      -0.855  38.364  56.908  1.00 39.18          
ATOM    381  CB  GLN    50      -0.257  38.461  55.504  1.00 38.23          
ATOM    382  CG  GLN    50      -1.070  37.728  54.463  1.00 35.52          
ATOM    383  CD  GLN    50      -1.122  36.244  54.740  1.00 34.46          
ATOM    384  OE1 GLN    50      -2.188  35.675  55.000  1.00 36.03          
ATOM    385  NE2 GLN    50       0.037  35.607  54.702  1.00 38.23          
ATOM    386  C   GLN    50       0.091  38.990  57.925  1.00 40.98          
ATOM    387  O   GLN    50       1.275  39.144  57.651  1.00 42.44          
ATOM    388  N   ASP    51      -0.433  39.350  59.095  1.00 43.39          
ATOM    389  CA  ASP    51       0.384  39.927  60.169  1.00 45.28          
ATOM    390  CB  ASP    51       1.256  38.826  60.809  1.00 47.56          
ATOM    391  CG  ASP    51       2.005  39.300  62.073  1.00 52.02          
ATOM    392  OD1 ASP    51       1.345  39.766  63.033  1.00 52.05          
ATOM    393  OD2 ASP    51       3.257  39.188  62.110  1.00 51.44          
ATOM    394  C   ASP    51       1.274  41.077  59.690  1.00 44.85          
ATOM    395  O   ASP    51       2.489  41.060  59.890  1.00 43.78          
ATOM    396  N   LYS    52       0.673  42.068  59.039  1.00 43.04          
ATOM    397  CA  LYS    52       1.441  43.216  58.579  1.00 41.75          
ATOM    398  CB  LYS    52       1.688  43.126  57.069  1.00 42.51          
ATOM    399  CG  LYS    52       2.677  42.019  56.751  1.00 46.54          
ATOM    400  CD  LYS    52       3.056  41.939  55.298  1.00 47.80          
ATOM    401  CE  LYS    52       3.862  40.665  55.035  1.00 48.07          
ATOM    402  NZ  LYS    52       5.131  40.604  55.822  1.00 45.53          
ATOM    403  C   LYS    52       0.756  44.521  58.942  1.00 38.98          
ATOM    404  O   LYS    52      -0.454  44.561  59.117  1.00 37.30          
ATOM    405  N   ILE    53       1.549  45.575  59.105  1.00 36.70          
ATOM    406  CA  ILE    53       1.009  46.886  59.427  1.00 35.00          
ATOM    407  CB  ILE    53       2.034  47.737  60.192  1.00 35.59          
ATOM    408  CG2 ILE    53       1.449  49.120  60.477  1.00 34.46          
ATOM    409  CG1 ILE    53       2.395  47.031  61.513  1.00 34.83          
ATOM    410  CD  ILE    53       3.561  47.667  62.272  1.00 33.44          
ATOM    411  C   ILE    53       0.679  47.497  58.078  1.00 33.10          
ATOM    412  O   ILE    53       1.555  47.648  57.224  1.00 32.73          
ATOM    413  N   VAL    54      -0.598  47.805  57.878  1.00 31.77          
ATOM    414  CA  VAL    54      -1.072  48.345  56.612  1.00 29.40          
ATOM    415  CB  VAL    54      -1.850  47.269  55.833  1.00 29.09          
ATOM    416  CG1 VAL    54      -1.776  47.546  54.354  1.00 30.04          
ATOM    417  CG2 VAL    54      -1.320  45.889  56.182  1.00 28.84          
ATOM    418  C   VAL    54      -2.015  49.526  56.808  1.00 29.37          
ATOM    419  O   VAL    54      -2.941  49.464  57.615  1.00 28.18          
ATOM    420  N   ASN    55      -1.783  50.591  56.050  1.00 29.03          
ATOM    421  CA  ASN    55      -2.612  51.787  56.112  1.00 26.75          
ATOM    422  CB  ASN    55      -1.874  52.922  56.818  1.00 26.03          
ATOM    423  CG  ASN    55      -1.659  52.651  58.286  1.00 26.40          
ATOM    424  OD1 ASN    55      -2.612  52.609  59.065  1.00 25.84          
ATOM    425  ND2 ASN    55      -0.407  52.456  58.677  1.00 26.86          
ATOM    426  C   ASN    55      -2.944  52.228  54.697  1.00 27.96          
ATOM    427  O   ASN    55      -2.060  52.287  53.838  1.00 29.55          
ATOM    428  N   VAL    56      -4.222  52.517  54.468  1.00 27.62          
ATOM    429  CA  VAL    56      -4.725  52.982  53.180  1.00 27.84          
ATOM    430  CB  VAL    56      -6.141  52.394  52.893  1.00 27.96          
ATOM    431  CG1 VAL    56      -6.672  52.909  51.566  1.00 27.29          
ATOM    432  CG2 VAL    56      -6.081  50.872  52.911  1.00 26.32          
ATOM    433  C   VAL    56      -4.819  54.504  53.295  1.00 29.56          
ATOM    434  O   VAL    56      -5.399  55.032  54.254  1.00 31.54          
ATOM    435  N   ILE    57      -4.242  55.203  52.323  1.00 29.78          
ATOM    436  CA  ILE    57      -4.219  56.665  52.312  1.00 29.55          
ATOM    437  CB  ILE    57      -2.795  57.210  52.593  1.00 30.14          
ATOM    438  CG2 ILE    57      -2.838  58.722  52.702  1.00 28.42          
ATOM    439  CG1 ILE    57      -2.229  56.601  53.881  1.00 32.53          
ATOM    440  CD  ILE    57      -0.798  57.048  54.208  1.00 30.80          
ATOM    441  C   ILE    57      -4.631  57.206  50.949  1.00 31.03          
ATOM    442  O   ILE    57      -4.083  56.803  49.926  1.00 30.07          
ATOM    443  N   VAL    58      -5.589  58.125  50.946  1.00 31.81          
ATOM    444  CA  VAL    58      -6.059  58.744  49.724  1.00 31.32          
ATOM    445  CB  VAL    58      -7.481  58.260  49.356  1.00 29.85          
ATOM    446  CG1 VAL    58      -7.470  56.732  49.131  1.00 26.17          
ATOM    447  CG2 VAL    58      -8.456  58.622  50.466  1.00 27.71          
ATOM    448  C   VAL    58      -6.051  60.249  49.990  1.00 34.66          
ATOM    449  O   VAL    58      -6.151  60.692  51.133  1.00 35.74          
ATOM    450  N   PRO    59      -5.935  61.064  48.938  1.00 36.20          
ATOM    451  CD  PRO    59      -5.712  60.777  47.507  1.00 35.64          
ATOM    452  CA  PRO    59      -5.913  62.502  49.199  1.00 37.92          
ATOM    453  CB  PRO    59      -5.257  63.056  47.934  1.00 37.96          
ATOM    454  CG  PRO    59      -5.768  62.150  46.882  1.00 37.41          
ATOM    455  C   PRO    59      -7.262  63.145  49.469  1.00 37.79          
ATOM    456  O   PRO    59      -7.333  64.254  49.991  1.00 37.77          
ATOM    457  N   ASN    60      -8.328  62.421  49.163  1.00 37.74          
ATOM    458  CA  ASN    60      -9.649  62.999  49.269  1.00 37.58          
ATOM    459  CB  ASN    60     -10.102  63.407  47.860  1.00 41.54          
ATOM    460  CG  ASN    60     -10.430  64.856  47.766  1.00 43.71          
ATOM    461  OD1 ASN    60     -10.838  65.356  46.710  1.00 42.06          
ATOM    462  ND2 ASN    60     -10.244  65.563  48.880  1.00 46.57          
ATOM    463  C   ASN    60     -10.711  62.100  49.843  1.00 36.65          
ATOM    464  O   ASN    60     -10.576  60.886  49.842  1.00 38.33          
ATOM    465  N   ALA    61     -11.796  62.716  50.291  1.00 32.40          
ATOM    466  CA  ALA    61     -12.922  61.965  50.818  1.00 31.75          
ATOM    467  CB  ALA    61     -13.935  62.923  51.455  1.00 27.37          
ATOM    468  C   ALA    61     -13.588  61.174  49.676  1.00 29.99          
ATOM    469  O   ALA    61     -13.589  61.613  48.528  1.00 29.09          
ATOM    470  N   PHE    62     -14.132  60.002  49.999  1.00 30.76          
ATOM    471  CA  PHE    62     -14.838  59.179  49.032  1.00 30.64          
ATOM    472  CB  PHE    62     -14.399  57.710  49.149  1.00 31.09          
ATOM    473  CG  PHE    62     -14.203  57.239  50.558  1.00 28.04          
ATOM    474  CD1 PHE    62     -15.243  56.676  51.267  1.00 28.08          
ATOM    475  CD2 PHE    62     -12.969  57.376  51.178  1.00 31.11          
ATOM    476  CE1 PHE    62     -15.065  56.259  52.578  1.00 29.65          
ATOM    477  CE2 PHE    62     -12.779  56.963  52.488  1.00 31.33          
ATOM    478  CZ  PHE    62     -13.829  56.402  53.190  1.00 30.85          
ATOM    479  C   PHE    62     -16.332  59.346  49.311  1.00 31.27          
ATOM    480  O   PHE    62     -16.712  59.788  50.376  1.00 31.45          
ATOM    481  N   PRO    63     -17.199  59.019  48.346  1.00 33.05          
ATOM    482  CD  PRO    63     -16.914  58.661  46.948  1.00 32.96          
ATOM    483  CA  PRO    63     -18.644  59.173  48.571  1.00 33.62          
ATOM    484  CB  PRO    63     -19.251  58.731  47.241  1.00 32.78          
ATOM    485  CG  PRO    63     -18.183  59.097  46.241  1.00 32.91          
ATOM    486  C   PRO    63     -19.222  58.386  49.752  1.00 34.25          
ATOM    487  O   PRO    63     -18.687  57.346  50.150  1.00 34.94          
ATOM    488  N   ASP    64     -20.327  58.891  50.292  1.00 33.47          
ATOM    489  CA  ASP    64     -21.005  58.266  51.414  1.00 33.89          
ATOM    490  CB  ASP    64     -22.157  59.150  51.919  1.00 36.56          
ATOM    491  CG  ASP    64     -21.674  60.400  52.659  1.00 40.84          
ATOM    492  OD1 ASP    64     -20.450  60.583  52.842  1.00 42.78          
ATOM    493  OD2 ASP    64     -22.538  61.207  53.065  1.00 44.20          
ATOM    494  C   ASP    64     -21.561  56.905  51.052  1.00 33.28          
ATOM    495  O   ASP    64     -21.734  56.056  51.923  1.00 34.03          
ATOM    496  N   PHE    65     -21.857  56.687  49.778  1.00 32.12          
ATOM    497  CA  PHE    65     -22.385  55.393  49.393  1.00 31.83          
ATOM    498  CB  PHE    65     -23.076  55.462  48.026  1.00 29.14          
ATOM    499  CG  PHE    65     -22.233  56.041  46.924  1.00 28.68          
ATOM    500  CD1 PHE    65     -21.184  55.314  46.376  1.00 29.64          
ATOM    501  CD2 PHE    65     -22.538  57.293  46.383  1.00 30.47          
ATOM    502  CE1 PHE    65     -20.448  55.809  45.304  1.00 28.66          
ATOM    503  CE2 PHE    65     -21.806  57.806  45.303  1.00 27.64          
ATOM    504  CZ  PHE    65     -20.763  57.062  44.762  1.00 32.72          
ATOM    505  C   PHE    65     -21.289  54.326  49.418  1.00 32.66          
ATOM    506  O   PHE    65     -21.525  53.169  49.088  1.00 34.42          
ATOM    507  N   LEU    66     -20.095  54.724  49.833  1.00 31.79          
ATOM    508  CA  LEU    66     -18.982  53.795  49.943  1.00 32.29          
ATOM    509  CB  LEU    66     -17.772  54.337  49.174  1.00 29.27          
ATOM    510  CG  LEU    66     -17.458  53.742  47.792  1.00 29.38          
ATOM    511  CD1 LEU    66     -18.720  53.490  47.016  1.00 27.89          
ATOM    512  CD2 LEU    66     -16.520  54.686  47.022  1.00 26.27          
ATOM    513  C   LEU    66     -18.608  53.542  51.422  1.00 34.02          
ATOM    514  O   LEU    66     -17.796  52.657  51.715  1.00 34.35          
ATOM    515  N   LYS    67     -19.214  54.300  52.343  1.00 34.06          
ATOM    516  CA  LYS    67     -18.922  54.172  53.784  1.00 35.32          
ATOM    517  CB  LYS    67     -19.717  55.202  54.608  1.00 35.07          
ATOM    518  CG  LYS    67     -19.405  56.658  54.305  1.00 40.09          
ATOM    519  CD  LYS    67     -17.937  56.978  54.510  1.00 40.44          
ATOM    520  CE  LYS    67     -17.627  58.424  54.103  1.00 43.21          
ATOM    521  NZ  LYS    67     -18.403  59.446  54.876  1.00 42.94          
ATOM    522  C   LYS    67     -19.204  52.789  54.375  1.00 33.77          
ATOM    523  O   LYS    67     -18.551  52.365  55.334  1.00 34.03          
ATOM    524  N   TRP    68     -20.189  52.099  53.822  1.00 31.42          
ATOM    525  CA  TRP    68     -20.540  50.784  54.326  1.00 30.37          
ATOM    526  CB  TRP    68     -21.740  50.255  53.557  1.00 29.25          
ATOM    527  CG  TRP    68     -21.440  50.113  52.090  1.00 27.99          
ATOM    528  CD2 TRP    68     -20.930  48.948  51.427  1.00 26.98          
ATOM    529  CE2 TRP    68     -20.816  49.264  50.055  1.00 27.98          
ATOM    530  CE3 TRP    68     -20.563  47.667  51.859  1.00 28.36          
ATOM    531  CD1 TRP    68     -21.595  51.066  51.122  1.00 27.96          
ATOM    532  NE1 TRP    68     -21.225  50.564  49.900  1.00 28.85          
ATOM    533  CZ2 TRP    68     -20.342  48.342  49.105  1.00 26.01          
ATOM    534  CZ3 TRP    68     -20.089  46.751  50.914  1.00 27.81          
ATOM    535  CH2 TRP    68     -19.989  47.097  49.553  1.00 28.09          
ATOM    536  C   TRP    68     -19.390  49.778  54.191  1.00 30.93          
ATOM    537  O   TRP    68     -19.351  48.774  54.891  1.00 31.65          
ATOM    538  N   MET    69     -18.456  50.041  53.287  1.00 31.64          
ATOM    539  CA  MET    69     -17.363  49.104  53.060  1.00 31.14          
ATOM    540  CB  MET    69     -16.485  49.621  51.923  1.00 31.66          
ATOM    541  CG  MET    69     -17.297  49.856  50.661  1.00 35.57          
ATOM    542  SD  MET    69     -16.258  50.298  49.110  0.82 40.99          
ATOM    543  CE  MET    69     -15.599  48.525  48.755  1.00 32.37          
ATOM    544  C   MET    69     -16.537  48.796  54.304  1.00 30.75          
ATOM    545  O   MET    69     -16.101  49.703  55.022  1.00 30.72          
ATOM    546  N   PRO    70     -16.302  47.501  54.577  1.00 28.17          
ATOM    547  CD  PRO    70     -16.736  46.286  53.859  1.00 28.83          
ATOM    548  CA  PRO    70     -15.514  47.169  55.774  1.00 27.85          
ATOM    549  CB  PRO    70     -15.621  45.641  55.859  1.00 25.83          
ATOM    550  CG  PRO    70     -15.823  45.229  54.423  1.00 28.24          
ATOM    551  C   PRO    70     -14.090  47.668  55.644  1.00 27.04          
ATOM    552  O   PRO    70     -13.412  47.368  54.672  1.00 27.87          
ATOM    553  N   GLY    71     -13.649  48.448  56.624  1.00 26.27          
ATOM    554  CA  GLY    71     -12.306  49.000  56.580  1.00 25.37          
ATOM    555  C   GLY    71     -12.282  50.438  56.088  1.00 26.27          
ATOM    556  O   GLY    71     -11.265  51.129  56.223  1.00 25.98          
ATOM    557  N   SER    72     -13.393  50.908  55.523  1.00 27.02          
ATOM    558  CA  SER    72     -13.426  52.282  55.007  1.00 29.27          
ATOM    559  CB  SER    72     -14.736  52.560  54.252  1.00 28.76          
ATOM    560  OG  SER    72     -15.845  52.561  55.125  1.00 30.29          
ATOM    561  C   SER    72     -13.205  53.355  56.070  1.00 29.72          
ATOM    562  O   SER    72     -12.609  54.395  55.783  1.00 32.66          
ATOM    563  N   LYS    73     -13.670  53.113  57.292  1.00 30.61          
ATOM    564  CA  LYS    73     -13.486  54.089  58.366  1.00 33.82          
ATOM    565  CB  LYS    73     -14.232  53.661  59.636  1.00 38.19          
ATOM    566  CG  LYS    73     -15.748  53.712  59.545  1.00 42.50          
ATOM    567  CD  LYS    73     -16.388  53.404  60.907  1.00 45.65          
ATOM    568  CE  LYS    73     -17.914  53.334  60.825  1.00 49.02          
ATOM    569  NZ  LYS    73     -18.518  53.057  62.163  1.00 49.92          
ATOM    570  C   LYS    73     -12.015  54.305  58.725  1.00 34.09          
ATOM    571  O   LYS    73     -11.656  55.332  59.294  1.00 32.84          
ATOM    572  N   ASP    74     -11.165  53.335  58.414  1.00 34.27          
ATOM    573  CA  ASP    74      -9.749  53.463  58.735  1.00 33.14          
ATOM    574  CB  ASP    74      -9.185  52.104  59.130  1.00 36.60          
ATOM    575  CG  ASP    74      -9.836  51.563  60.380  1.00 42.86          
ATOM    576  OD1 ASP    74      -9.601  52.144  61.465  1.00 42.82          
ATOM    577  OD2 ASP    74     -10.598  50.573  60.275  1.00 45.88          
ATOM    578  C   ASP    74      -8.933  54.063  57.609  1.00 31.29          
ATOM    579  O   ASP    74      -7.731  54.244  57.733  1.00 30.75          
ATOM    580  N   ILE    75      -9.587  54.364  56.501  1.00 31.72          
ATOM    581  CA  ILE    75      -8.891  54.972  55.383  1.00 29.07          
ATOM    582  CB  ILE    75      -9.791  54.988  54.146  1.00 28.66          
ATOM    583  CG2 ILE    75      -9.243  55.985  53.115  1.00 26.91          
ATOM    584  CG1 ILE    75      -9.906  53.552  53.603  1.00 25.62          
ATOM    585  CD  ILE    75     -10.723  53.401  52.336  1.00 23.30          
ATOM    586  C   ILE    75      -8.492  56.388  55.807  1.00 30.43          
ATOM    587  O   ILE    75      -9.304  57.135  56.358  1.00 28.26          
ATOM    588  N   LEU    76      -7.232  56.740  55.573  1.00 31.55          
ATOM    589  CA  LEU    76      -6.714  58.044  55.970  1.00 31.89          
ATOM    590  CB  LEU    76      -5.269  57.892  56.434  1.00 33.71          
ATOM    591  CG  LEU    76      -4.570  59.113  57.030  1.00 40.05          
ATOM    592  CD1 LEU    76      -5.274  59.539  58.319  1.00 41.69          
ATOM    593  CD2 LEU    76      -3.113  58.767  57.326  1.00 41.40          
ATOM    594  C   LEU    76      -6.797  59.083  54.862  1.00 33.23          
ATOM    595  O   LEU    76      -6.278  58.876  53.766  1.00 33.29          
ATOM    596  N   LEU    77      -7.460  60.200  55.158  1.00 32.61          
ATOM    597  CA  LEU    77      -7.616  61.290  54.203  1.00 32.41          
ATOM    598  CB  LEU    77      -8.928  62.031  54.472  1.00 29.66          
ATOM    599  CG  LEU    77     -10.166  61.551  53.700  1.00 33.37          
ATOM    600  CD1 LEU    77     -10.200  60.033  53.609  1.00 34.92          
ATOM    601  CD2 LEU    77     -11.421  62.076  54.380  1.00 33.03          
ATOM    602  C   LEU    77      -6.430  62.234  54.331  1.00 32.68          
ATOM    603  O   LEU    77      -6.239  62.862  55.370  1.00 34.95          
ATOM    604  N   TYR    78      -5.637  62.327  53.267  1.00 34.06          
ATOM    605  CA  TYR    78      -4.442  63.166  53.256  1.00 34.06          
ATOM    606  CB  TYR    78      -3.680  62.958  51.949  1.00 32.66          
ATOM    607  CG  TYR    78      -2.285  63.531  51.955  1.00 32.30          
ATOM    608  CD1 TYR    78      -2.024  64.788  51.414  1.00 30.89          
ATOM    609  CE1 TYR    78      -0.734  65.306  51.397  1.00 33.96          
ATOM    610  CD2 TYR    78      -1.221  62.805  52.487  1.00 33.50          
ATOM    611  CE2 TYR    78       0.077  63.309  52.476  1.00 33.03          
ATOM    612  CZ  TYR    78       0.313  64.557  51.924  1.00 35.44          
ATOM    613  OH  TYR    78       1.601  65.042  51.861  1.00 36.90          
ATOM    614  C   TYR    78      -4.655  64.662  53.490  1.00 33.92          
ATOM    615  O   TYR    78      -3.805  65.316  54.102  1.00 34.27          
ATOM    616  N   ASP    79      -5.766  65.206  53.007  1.00 35.91          
ATOM    617  CA  ASP    79      -6.046  66.622  53.195  1.00 38.79          
ATOM    618  CB  ASP    79      -7.097  67.113  52.185  1.00 38.82          
ATOM    619  CG  ASP    79      -8.456  66.429  52.347  1.00 41.50          
ATOM    620  OD1 ASP    79      -8.611  65.613  53.272  1.00 43.85          
ATOM    621  OD2 ASP    79      -9.379  66.712  51.544  1.00 40.81          
ATOM    622  C   ASP    79      -6.523  66.934  54.616  1.00 40.94          
ATOM    623  O   ASP    79      -7.037  68.024  54.871  1.00 40.44          
ATOM    624  N   ARG    80      -6.350  65.985  55.538  1.00 41.60          
ATOM    625  CA  ARG    80      -6.784  66.187  56.917  1.00 43.07          
ATOM    626  CB  ARG    80      -8.137  65.514  57.141  1.00 46.63          
ATOM    627  CG  ARG    80      -9.183  65.989  56.157  1.00 54.16          
ATOM    628  CD  ARG    80     -10.510  65.268  56.304  1.00 59.08          
ATOM    629  NE  ARG    80     -11.373  65.547  55.157  1.00 63.08          
ATOM    630  CZ  ARG    80     -12.647  65.179  55.067  1.00 65.70          
ATOM    631  NH1 ARG    80     -13.220  64.511  56.065  1.00 65.94          
ATOM    632  NH2 ARG    80     -13.349  65.482  53.980  1.00 64.66          
ATOM    633  C   ARG    80      -5.796  65.669  57.944  1.00 42.03          
ATOM    634  O   ARG    80      -5.856  66.049  59.108  1.00 41.92          
ATOM    635  N   TYR    81      -4.888  64.801  57.510  1.00 41.24          
ATOM    636  CA  TYR    81      -3.889  64.217  58.402  1.00 39.85          
ATOM    637  CB  TYR    81      -4.335  62.823  58.846  1.00 38.67          
ATOM    638  CG  TYR    81      -5.616  62.833  59.643  1.00 40.17          
ATOM    639  CD1 TYR    81      -5.663  63.403  60.912  1.00 39.13          
ATOM    640  CE1 TYR    81      -6.850  63.471  61.626  1.00 38.11          
ATOM    641  CD2 TYR    81      -6.799  62.322  59.108  1.00 41.32          
ATOM    642  CE2 TYR    81      -7.996  62.385  59.818  1.00 39.97          
ATOM    643  CZ  TYR    81      -8.009  62.964  61.074  1.00 40.07          
ATOM    644  OH  TYR    81      -9.189  63.046  61.771  1.00 39.26          
ATOM    645  C   TYR    81      -2.569  64.118  57.668  1.00 38.91          
ATOM    646  O   TYR    81      -1.912  63.072  57.688  1.00 37.78          
ATOM    647  N   GLN    82      -2.174  65.216  57.037  1.00 37.90          
ATOM    648  CA  GLN    82      -0.941  65.242  56.262  1.00 40.84          
ATOM    649  CB  GLN    82      -0.728  66.623  55.640  1.00 40.56          
ATOM    650  CG  GLN    82       0.516  66.689  54.789  1.00 44.88          
ATOM    651  CD  GLN    82       0.669  68.008  54.070  1.00 47.57          
ATOM    652  OE1 GLN    82       1.668  68.239  53.384  1.00 50.54          
ATOM    653  NE2 GLN    82      -0.321  68.879  54.209  1.00 46.33          
ATOM    654  C   GLN    82       0.302  64.830  57.023  1.00 42.03          
ATOM    655  O   GLN    82       1.054  63.971  56.560  1.00 43.23          
ATOM    656  N   GLU    83       0.526  65.441  58.182  1.00 43.36          
ATOM    657  CA  GLU    83       1.692  65.125  59.004  1.00 43.35          
ATOM    658  CB  GLU    83       1.588  65.843  60.357  1.00 46.89          
ATOM    659  CG  GLU    83       2.867  66.543  60.828  1.00 52.94          
ATOM    660  CD  GLU    83       3.923  65.591  61.386  1.00 57.16          
ATOM    661  OE1 GLU    83       3.705  65.003  62.479  1.00 57.43          
ATOM    662  OE2 GLU    83       4.980  65.434  60.729  1.00 58.63          
ATOM    663  C   GLU    83       1.733  63.615  59.220  1.00 41.35          
ATOM    664  O   GLU    83       2.724  62.963  58.927  1.00 42.06          
ATOM    665  N   PHE    84       0.635  63.074  59.735  1.00 40.42          
ATOM    666  CA  PHE    84       0.508  61.643  60.002  1.00 39.17          
ATOM    667  CB  PHE    84      -0.892  61.376  60.578  1.00 38.13          
ATOM    668  CG  PHE    84      -1.137  59.951  60.999  1.00 35.76          
ATOM    669  CD1 PHE    84      -0.082  59.086  61.279  1.00 34.07          
ATOM    670  CD2 PHE    84      -2.441  59.485  61.147  1.00 35.03          
ATOM    671  CE1 PHE    84      -0.333  57.776  61.701  1.00 34.76          
ATOM    672  CE2 PHE    84      -2.701  58.184  61.568  1.00 32.86          
ATOM    673  CZ  PHE    84      -1.647  57.327  61.844  1.00 33.63          
ATOM    674  C   PHE    84       0.742  60.839  58.713  1.00 38.18          
ATOM    675  O   PHE    84       1.596  59.949  58.673  1.00 37.58          
ATOM    676  N   ALA    85      -0.004  61.168  57.660  1.00 37.01          
ATOM    677  CA  ALA    85       0.140  60.476  56.381  1.00 37.48          
ATOM    678  CB  ALA    85      -0.719  61.140  55.324  1.00 36.13          
ATOM    679  C   ALA    85       1.597  60.476  55.934  1.00 38.07          
ATOM    680  O   ALA    85       2.167  59.418  55.646  1.00 38.53          
ATOM    681  N   ASP    86       2.200  61.662  55.887  1.00 38.63          
ATOM    682  CA  ASP    86       3.592  61.782  55.470  1.00 38.89          
ATOM    683  CB  ASP    86       4.093  63.211  55.664  1.00 38.29          
ATOM    684  CG  ASP    86       3.481  64.184  54.675  1.00 40.83          
ATOM    685  OD1 ASP    86       2.960  63.735  53.626  1.00 40.42          
ATOM    686  OD2 ASP    86       3.536  65.405  54.942  1.00 42.57          
ATOM    687  C   ASP    86       4.517  60.824  56.207  1.00 38.30          
ATOM    688  O   ASP    86       5.380  60.205  55.598  1.00 39.58          
ATOM    689  N   LYS    87       4.338  60.698  57.517  1.00 38.01          
ATOM    690  CA  LYS    87       5.174  59.804  58.308  1.00 35.88          
ATOM    691  CB  LYS    87       4.828  59.910  59.796  1.00 37.18          
ATOM    692  CG  LYS    87       5.474  61.057  60.546  1.00 38.89          
ATOM    693  CD  LYS    87       5.259  60.851  62.047  1.00 41.78          
ATOM    694  CE  LYS    87       6.029  61.848  62.891  1.00 43.14          
ATOM    695  NZ  LYS    87       5.903  61.486  64.333  1.00 46.08          
ATOM    696  C   LYS    87       5.013  58.360  57.865  1.00 34.44          
ATOM    697  O   LYS    87       5.997  57.651  57.687  1.00 35.58          
ATOM    698  N   LEU    88       3.767  57.915  57.712  1.00 34.03          
ATOM    699  CA  LEU    88       3.497  56.548  57.271  1.00 33.27          
ATOM    700  CB  LEU    88       1.987  56.301  57.194  1.00 32.14          
ATOM    701  CG  LEU    88       1.214  56.320  58.519  1.00 31.68          
ATOM    702  CD1 LEU    88      -0.287  56.264  58.268  1.00 30.17          
ATOM    703  CD2 LEU    88       1.654  55.144  59.361  1.00 30.35          
ATOM    704  C   LEU    88       4.121  56.301  55.894  1.00 32.41          
ATOM    705  O   LEU    88       4.744  55.268  55.668  1.00 32.09          
ATOM    706  N   ILE    89       3.948  57.254  54.979  1.00 33.64          
ATOM    707  CA  ILE    89       4.486  57.130  53.628  1.00 34.27          
ATOM    708  CB  ILE    89       3.984  58.290  52.734  1.00 33.66          
ATOM    709  CG2 ILE    89       4.684  58.281  51.386  1.00 33.00          
ATOM    710  CG1 ILE    89       2.472  58.152  52.528  1.00 32.47          
ATOM    711  CD  ILE    89       1.829  59.343  51.863  1.00 33.70          
ATOM    712  C   ILE    89       6.013  57.080  53.636  1.00 35.89          
ATOM    713  O   ILE    89       6.603  56.205  53.017  1.00 37.25          
ATOM    714  N   MET    90       6.653  57.995  54.359  1.00 37.05          
ATOM    715  CA  MET    90       8.110  58.018  54.414  1.00 38.99          
ATOM    716  CB  MET    90       8.599  59.264  55.150  1.00 41.56          
ATOM    717  CG  MET    90       8.408  60.580  54.395  1.00 41.92          
ATOM    718  SD  MET    90       9.402  60.619  52.728  0.74 46.55          
ATOM    719  CE  MET    90      11.162  60.273  53.427  1.00 38.88          
ATOM    720  C   MET    90       8.688  56.795  55.103  1.00 40.77          
ATOM    721  O   MET    90       9.826  56.414  54.843  1.00 41.78          
ATOM    722  N   GLU    91       7.901  56.166  55.969  1.00 40.75          
ATOM    723  CA  GLU    91       8.384  55.011  56.708  1.00 39.81          
ATOM    724  CB  GLU    91       7.946  55.131  58.172  1.00 39.54          
ATOM    725  CG  GLU    91       8.353  56.452  58.821  1.00 42.24          
ATOM    726  CD  GLU    91       8.164  56.456  60.334  1.00 42.27          
ATOM    727  OE1 GLU    91       7.069  56.099  60.814  1.00 39.94          
ATOM    728  OE2 GLU    91       9.116  56.826  61.049  1.00 44.46          
ATOM    729  C   GLU    91       7.981  53.642  56.160  1.00 39.90          
ATOM    730  O   GLU    91       8.396  52.615  56.698  1.00 38.09          
ATOM    731  N   ALA    92       7.188  53.619  55.091  1.00 38.87          
ATOM    732  CA  ALA    92       6.741  52.350  54.519  1.00 37.94          
ATOM    733  CB  ALA    92       5.589  52.601  53.556  1.00 38.28          
ATOM    734  C   ALA    92       7.830  51.523  53.819  1.00 38.26          
ATOM    735  O   ALA    92       8.633  52.049  53.038  1.00 35.92          
ATOM    736  N   ASP    93       7.853  50.221  54.099  1.00 36.50          
ATOM    737  CA  ASP    93       8.818  49.339  53.453  1.00 36.59          
ATOM    738  CB  ASP    93       8.840  47.966  54.134  1.00 37.39          
ATOM    739  CG  ASP    93       9.257  48.035  55.590  1.00 38.73          
ATOM    740  OD1 ASP    93      10.324  48.622  55.871  1.00 39.27          
ATOM    741  OD2 ASP    93       8.526  47.492  56.449  1.00 37.39          
ATOM    742  C   ASP    93       8.368  49.173  51.994  1.00 37.69          
ATOM    743  O   ASP    93       9.188  49.131  51.066  1.00 37.42          
ATOM    744  N   VAL    94       7.050  49.086  51.810  1.00 36.05          
ATOM    745  CA  VAL    94       6.445  48.917  50.493  1.00 35.77          
ATOM    746  CB  VAL    94       5.894  47.489  50.309  1.00 34.02          
ATOM    747  CG1 VAL    94       5.126  47.396  49.003  1.00 34.22          
ATOM    748  CG2 VAL    94       7.018  46.481  50.350  1.00 34.98          
ATOM    749  C   VAL    94       5.280  49.874  50.303  1.00 36.07          
ATOM    750  O   VAL    94       4.435  50.012  51.188  1.00 36.28          
ATOM    751  N   ILE    95       5.235  50.522  49.142  1.00 33.64          
ATOM    752  CA  ILE    95       4.159  51.454  48.825  1.00 32.60          
ATOM    753  CB  ILE    95       4.688  52.858  48.470  1.00 30.93          
ATOM    754  CG2 ILE    95       3.518  53.756  48.059  1.00 29.57          
ATOM    755  CG1 ILE    95       5.448  53.450  49.660  1.00 29.98          
ATOM    756  CD  ILE    95       5.824  54.901  49.491  1.00 28.21          
ATOM    757  C   ILE    95       3.402  50.946  47.608  1.00 34.39          
ATOM    758  O   ILE    95       3.940  50.939  46.500  1.00 33.57          
ATOM    759  N   CYS    96       2.157  50.522  47.806  1.00 33.80          
ATOM    760  CA  CYS    96       1.362  50.034  46.692  1.00 33.46          
ATOM    761  CB  CYS    96       0.449  48.904  47.152  1.00 32.49          
ATOM    762  SG  CYS    96       1.331  47.592  48.009  1.00 36.58          
ATOM    763  C   CYS    96       0.526  51.168  46.130  1.00 33.15          
ATOM    764  O   CYS    96      -0.277  51.752  46.841  1.00 32.93          
ATOM    765  N   CYS    97       0.717  51.478  44.853  1.00 32.89          
ATOM    766  CA  CYS    97      -0.045  52.538  44.202  1.00 33.12          
ATOM    767  CB  CYS    97       0.865  53.356  43.296  1.00 32.47          
ATOM    768  SG  CYS    97       2.281  53.974  44.196  1.00 39.10          
ATOM    769  C   CYS    97      -1.151  51.893  43.382  1.00 33.17          
ATOM    770  O   CYS    97      -0.903  51.348  42.298  1.00 31.81          
ATOM    771  N   LEU    98      -2.372  51.980  43.903  1.00 31.03          
ATOM    772  CA  LEU    98      -3.526  51.374  43.266  1.00 30.79          
ATOM    773  CB  LEU    98      -4.327  50.575  44.298  1.00 30.46          
ATOM    774  CG  LEU    98      -3.900  49.127  44.523  1.00 31.69          
ATOM    775  CD1 LEU    98      -2.470  49.060  45.042  1.00 33.03          
ATOM    776  CD2 LEU    98      -4.859  48.491  45.498  1.00 32.91          
ATOM    777  C   LEU    98      -4.482  52.282  42.521  1.00 32.04          
ATOM    778  O   LEU    98      -4.940  53.317  43.037  1.00 31.66          
ATOM    779  N   ASP    99      -4.773  51.860  41.293  1.00 29.79          
ATOM    780  CA  ASP    99      -5.712  52.531  40.427  1.00 29.72          
ATOM    781  CB  ASP    99      -7.072  52.604  41.128  1.00 29.36          
ATOM    782  CG  ASP    99      -8.213  52.739  40.159  1.00 29.17          
ATOM    783  OD1 ASP    99      -8.123  52.167  39.057  1.00 29.47          
ATOM    784  OD2 ASP    99      -9.206  53.408  40.497  1.00 32.53          
ATOM    785  C   ASP    99      -5.317  53.894  39.868  1.00 31.43          
ATOM    786  O   ASP    99      -6.175  54.721  39.545  1.00 30.39          
ATOM    787  N   PHE   100      -4.018  54.145  39.781  1.00 32.00          
ATOM    788  CA  PHE   100      -3.545  55.363  39.141  1.00 32.27          
ATOM    789  CB  PHE   100      -3.510  56.578  40.100  1.00 31.73          
ATOM    790  CG  PHE   100      -2.419  56.528  41.139  1.00 31.75          
ATOM    791  CD1 PHE   100      -2.607  55.846  42.334  1.00 30.17          
ATOM    792  CD2 PHE   100      -1.220  57.195  40.933  1.00 31.12          
ATOM    793  CE1 PHE   100      -1.615  55.831  43.315  1.00 30.63          
ATOM    794  CE2 PHE   100      -0.220  57.187  41.909  1.00 34.02          
ATOM    795  CZ  PHE   100      -0.420  56.501  43.106  1.00 30.26          
ATOM    796  C   PHE   100      -2.167  55.048  38.559  1.00 33.76          
ATOM    797  O   PHE   100      -1.455  54.163  39.052  1.00 32.82          
ATOM    798  N   ASN   101      -1.802  55.740  37.488  1.00 35.47          
ATOM    799  CA  ASN   101      -0.513  55.483  36.866  1.00 37.46          
ATOM    800  CB  ASN   101      -0.714  54.762  35.529  1.00 37.50          
ATOM    801  CG  ASN   101      -1.535  55.572  34.540  1.00 36.93          
ATOM    802  OD1 ASN   101      -1.809  56.748  34.755  1.00 39.46          
ATOM    803  ND2 ASN   101      -1.923  54.938  33.437  1.00 39.29          
ATOM    804  C   ASN   101       0.326  56.739  36.656  1.00 38.16          
ATOM    805  O   ASN   101       1.314  56.709  35.927  1.00 40.94          
ATOM    806  N   ALA   102      -0.060  57.834  37.302  1.00 37.53          
ATOM    807  CA  ALA   102       0.674  59.089  37.171  1.00 37.06          
ATOM    808  CB  ALA   102       0.153  59.877  35.980  1.00 38.93          
ATOM    809  C   ALA   102       0.524  59.898  38.452  1.00 37.20          
ATOM    810  O   ALA   102      -0.594  60.138  38.917  1.00 37.06          
ATOM    811  N   LEU   103       1.655  60.327  39.006  1.00 36.86          
ATOM    812  CA  LEU   103       1.671  61.075  40.255  1.00 36.56          
ATOM    813  CB  LEU   103       3.078  61.579  40.533  1.00 37.09          
ATOM    814  CG  LEU   103       4.120  60.496  40.805  1.00 39.01          
ATOM    815  CD1 LEU   103       5.517  61.083  40.651  1.00 39.86          
ATOM    816  CD2 LEU   103       3.909  59.927  42.191  1.00 37.66          
ATOM    817  C   LEU   103       0.692  62.235  40.350  1.00 37.82          
ATOM    818  O   LEU   103       0.283  62.602  41.447  1.00 38.03          
ATOM    819  N   LYS   104       0.309  62.814  39.217  1.00 37.38          
ATOM    820  CA  LYS   104      -0.629  63.927  39.242  1.00 39.02          
ATOM    821  CB  LYS   104      -0.715  64.609  37.876  1.00 39.65          
ATOM    822  CG  LYS   104      -1.176  63.721  36.744  1.00 41.55          
ATOM    823  CD  LYS   104      -1.295  64.535  35.463  1.00 45.19          
ATOM    824  CE  LYS   104      -1.074  63.682  34.227  1.00 45.32          
ATOM    825  NZ  LYS   104      -1.036  64.532  33.001  1.00 46.79          
ATOM    826  C   LYS   104      -2.007  63.448  39.654  1.00 38.14          
ATOM    827  O   LYS   104      -2.862  64.248  40.037  1.00 38.57          
ATOM    828  N   ARG   105      -2.221  62.138  39.573  1.00 36.45          
ATOM    829  CA  ARG   105      -3.498  61.561  39.963  1.00 34.98          
ATOM    830  CB  ARG   105      -3.636  60.128  39.418  1.00 35.72          
ATOM    831  CG  ARG   105      -3.792  60.040  37.891  1.00 35.17          
ATOM    832  CD  ARG   105      -5.049  60.774  37.432  1.00 33.44          
ATOM    833  NE  ARG   105      -6.260  60.214  38.036  1.00 33.96          
ATOM    834  CZ  ARG   105      -7.296  60.942  38.458  1.00 34.97          
ATOM    835  NH1 ARG   105      -7.270  62.268  38.351  1.00 33.45          
ATOM    836  NH2 ARG   105      -8.362  60.347  38.978  1.00 35.05          
ATOM    837  C   ARG   105      -3.685  61.562  41.478  1.00 34.78          
ATOM    838  O   ARG   105      -4.797  61.380  41.965  1.00 34.27          
ATOM    839  N   ILE   106      -2.606  61.772  42.226  1.00 33.67          
ATOM    840  CA  ILE   106      -2.735  61.806  43.675  1.00 36.15          
ATOM    841  CB  ILE   106      -1.778  60.823  44.379  1.00 34.05          
ATOM    842  CG2 ILE   106      -2.231  59.393  44.144  1.00 33.84          
ATOM    843  CG1 ILE   106      -0.358  60.983  43.853  1.00 33.37          
ATOM    844  CD  ILE   106       0.610  60.143  44.624  1.00 30.88          
ATOM    845  C   ILE   106      -2.641  63.198  44.311  1.00 38.43          
ATOM    846  O   ILE   106      -2.238  63.351  45.458  1.00 39.34          
ATOM    847  N   ASP   107      -3.000  64.207  43.524  1.00 40.16          
ATOM    848  CA  ASP   107      -3.129  65.602  43.971  1.00 41.70          
ATOM    849  CB  ASP   107      -4.611  65.901  44.055  1.00 42.91          
ATOM    850  CG  ASP   107      -5.046  67.003  43.158  1.00 45.25          
ATOM    851  OD1 ASP   107      -4.943  66.854  41.913  1.00 45.93          
ATOM    852  OD2 ASP   107      -5.532  68.019  43.717  1.00 41.75          
ATOM    853  C   ASP   107      -2.551  66.005  45.336  1.00 43.26          
ATOM    854  O   ASP   107      -3.274  65.930  46.336  1.00 42.06          
ATOM    855  N   GLU   108      -1.300  66.461  45.400  1.00 44.95          
ATOM    856  CA  GLU   108      -0.710  66.910  46.686  1.00 45.34          
ATOM    857  CB  GLU   108      -1.776  67.495  47.631  1.00 49.50          
ATOM    858  CG  GLU   108      -2.369  68.832  47.184  1.00 55.94          
ATOM    859  CD  GLU   108      -1.430  70.018  47.404  1.00 60.46          
ATOM    860  OE1 GLU   108      -0.344  70.060  46.781  1.00 60.93          
ATOM    861  OE2 GLU   108      -1.783  70.912  48.209  1.00 63.03          
ATOM    862  C   GLU   108       0.032  65.837  47.415  1.00 42.94          
ATOM    863  O   GLU   108       0.890  66.138  48.217  1.00 42.57          
ATOM    864  N   MET   109      -0.312  64.585  47.145  1.00 43.52          
ATOM    865  CA  MET   109       0.381  63.481  47.776  1.00 42.26          
ATOM    866  CB  MET   109      -0.523  62.253  47.862  1.00 42.58          
ATOM    867  CG  MET   109      -1.719  62.329  48.818  1.00 44.39          
ATOM    868  SD  MET   109      -2.490  60.556  49.010  0.84 47.67          
ATOM    869  CE  MET   109      -1.034  59.625  49.874  1.00 45.45          
ATOM    870  C   MET   109       1.613  63.142  46.942  1.00 41.67          
ATOM    871  O   MET   109       2.562  62.537  47.441  1.00 42.28          
ATOM    872  N   SER   110       1.606  63.547  45.673  1.00 40.59          
ATOM    873  CA  SER   110       2.712  63.234  44.768  1.00 41.10          
ATOM    874  CB  SER   110       2.546  64.005  43.448  1.00 41.33          
ATOM    875  OG  SER   110       2.156  65.336  43.681  1.00 47.73          
ATOM    876  C   SER   110       4.117  63.445  45.325  1.00 40.98          
ATOM    877  O   SER   110       4.978  62.580  45.172  1.00 40.69          
ATOM    878  N   ASP   111       4.352  64.583  45.965  1.00 41.29          
ATOM    879  CA  ASP   111       5.669  64.880  46.526  1.00 42.46          
ATOM    880  CB  ASP   111       5.650  66.244  47.199  1.00 45.19          
ATOM    881  CG  ASP   111       5.185  67.338  46.268  1.00 48.99          
ATOM    882  OD1 ASP   111       6.007  67.779  45.429  1.00 45.25          
ATOM    883  OD2 ASP   111       3.994  67.735  46.378  1.00 50.34          
ATOM    884  C   ASP   111       6.160  63.850  47.534  1.00 41.38          
ATOM    885  O   ASP   111       7.240  63.281  47.376  1.00 41.62          
ATOM    886  N   ILE   112       5.384  63.624  48.587  1.00 41.87          
ATOM    887  CA  ILE   112       5.781  62.655  49.611  1.00 41.89          
ATOM    888  CB  ILE   112       4.754  62.637  50.788  1.00 41.73          
ATOM    889  CG2 ILE   112       3.462  61.954  50.367  1.00 40.84          
ATOM    890  CG1 ILE   112       5.356  61.934  51.996  1.00 41.46          
ATOM    891  CD  ILE   112       6.499  62.697  52.605  1.00 44.60          
ATOM    892  C   ILE   112       5.944  61.235  49.021  1.00 40.88          
ATOM    893  O   ILE   112       6.907  60.530  49.345  1.00 41.92          
ATOM    894  N   VAL   113       5.017  60.822  48.153  1.00 39.40          
ATOM    895  CA  VAL   113       5.084  59.494  47.533  1.00 40.12          
ATOM    896  CB  VAL   113       3.843  59.192  46.653  1.00 39.76          
ATOM    897  CG1 VAL   113       4.052  57.879  45.906  1.00 38.38          
ATOM    898  CG2 VAL   113       2.590  59.113  47.508  1.00 37.65          
ATOM    899  C   VAL   113       6.313  59.372  46.647  1.00 40.75          
ATOM    900  O   VAL   113       6.992  58.343  46.644  1.00 41.48          
ATOM    901  N   ALA   114       6.596  60.424  45.890  1.00 40.29          
ATOM    902  CA  ALA   114       7.754  60.436  45.002  1.00 41.36          
ATOM    903  CB  ALA   114       7.740  61.694  44.152  1.00 38.78          
ATOM    904  C   ALA   114       9.073  60.352  45.767  1.00 41.98          
ATOM    905  O   ALA   114      10.003  59.671  45.335  1.00 43.70          
ATOM    906  N   ALA   115       9.142  61.041  46.903  1.00 43.36          
ATOM    907  CA  ALA   115      10.356  61.089  47.730  1.00 42.76          
ATOM    908  CB  ALA   115      10.329  62.332  48.600  1.00 43.26          
ATOM    909  C   ALA   115      10.606  59.875  48.612  1.00 42.28          
ATOM    910  O   ALA   115      11.755  59.539  48.893  1.00 43.94          
ATOM    911  N   SER   116       9.540  59.224  49.060  1.00 40.85          
ATOM    912  CA  SER   116       9.685  58.056  49.923  1.00 39.40          
ATOM    913  CB  SER   116       8.319  57.404  50.148  1.00 37.40          
ATOM    914  OG  SER   116       8.424  56.304  51.033  1.00 34.59          
ATOM    915  C   SER   116      10.666  57.021  49.356  1.00 39.21          
ATOM    916  O   SER   116      10.650  56.731  48.163  1.00 39.48          
ATOM    917  N   PRO   117      11.544  56.465  50.207  1.00 40.00          
ATOM    918  CD  PRO   117      11.852  56.888  51.587  1.00 39.39          
ATOM    919  CA  PRO   117      12.512  55.464  49.747  1.00 40.25          
ATOM    920  CB  PRO   117      13.641  55.594  50.756  1.00 41.57          
ATOM    921  CG  PRO   117      12.893  55.853  52.026  1.00 39.13          
ATOM    922  C   PRO   117      11.918  54.055  49.737  1.00 41.84          
ATOM    923  O   PRO   117      12.590  53.089  49.357  1.00 42.99          
ATOM    924  N   GLY   118      10.667  53.939  50.174  1.00 41.53          
ATOM    925  CA  GLY   118      10.006  52.646  50.191  1.00 40.70          
ATOM    926  C   GLY   118       9.884  52.077  48.789  1.00 40.90          
ATOM    927  O   GLY   118       9.941  52.813  47.807  1.00 40.91          
ATOM    928  N   ARG   119       9.724  50.759  48.698  1.00 42.48          
ATOM    929  CA  ARG   119       9.603  50.070  47.412  1.00 41.59          
ATOM    930  CB  ARG   119       9.887  48.580  47.598  1.00 44.27          
ATOM    931  CG  ARG   119      11.267  48.273  48.167  1.00 47.89          
ATOM    932  CD  ARG   119      11.352  46.824  48.645  1.00 53.75          
ATOM    933  NE  ARG   119      12.674  46.475  49.166  1.00 59.27          
ATOM    934  CZ  ARG   119      13.784  46.429  48.431  1.00 62.74          
ATOM    935  NH1 ARG   119      13.741  46.708  47.132  1.00 65.21          
ATOM    936  NH2 ARG   119      14.944  46.106  48.992  1.00 64.67          
ATOM    937  C   ARG   119       8.203  50.271  46.837  1.00 39.36          
ATOM    938  O   ARG   119       7.214  49.853  47.431  1.00 39.59          
ATOM    939  N   LYS   120       8.126  50.905  45.674  1.00 38.87          
ATOM    940  CA  LYS   120       6.840  51.183  45.044  1.00 37.65          
ATOM    941  CB  LYS   120       6.851  52.586  44.436  1.00 38.03          
ATOM    942  CG  LYS   120       7.350  53.686  45.353  1.00 37.98          
ATOM    943  CD  LYS   120       7.439  55.003  44.594  1.00 38.64          
ATOM    944  CE  LYS   120       8.096  56.100  45.419  1.00 39.68          
ATOM    945  NZ  LYS   120       9.497  55.767  45.766  1.00 39.24          
ATOM    946  C   LYS   120       6.421  50.191  43.956  1.00 37.15          
ATOM    947  O   LYS   120       7.229  49.759  43.129  1.00 36.54          
ATOM    948  N   ILE   121       5.143  49.843  43.964  1.00 34.69          
ATOM    949  CA  ILE   121       4.593  48.948  42.967  1.00 34.40          
ATOM    950  CB  ILE   121       4.360  47.517  43.511  1.00 34.24          
ATOM    951  CG2 ILE   121       3.529  47.559  44.780  1.00 32.10          
ATOM    952  CG1 ILE   121       3.668  46.666  42.436  1.00 34.61          
ATOM    953  CD  ILE   121       3.506  45.188  42.813  1.00 37.44          
ATOM    954  C   ILE   121       3.267  49.524  42.519  1.00 34.74          
ATOM    955  O   ILE   121       2.475  49.984  43.332  1.00 34.93          
ATOM    956  N   MET   122       3.038  49.504  41.215  1.00 35.73          
ATOM    957  CA  MET   122       1.809  50.020  40.647  1.00 34.81          
ATOM    958  CB  MET   122       2.145  50.871  39.429  1.00 35.89          
ATOM    959  CG  MET   122       0.944  51.487  38.740  1.00 40.74          
ATOM    960  SD  MET   122       1.355  52.204  36.975  0.76 44.96          
ATOM    961  CE  MET   122       0.561  50.811  35.944  1.00 46.12          
ATOM    962  C   MET   122       0.906  48.850  40.241  1.00 35.35          
ATOM    963  O   MET   122       1.385  47.855  39.715  1.00 35.95          
ATOM    964  N   ILE   123      -0.393  48.966  40.528  1.00 33.83          
ATOM    965  CA  ILE   123      -1.399  47.958  40.170  1.00 31.28          
ATOM    966  CB  ILE   123      -1.914  47.186  41.388  1.00 31.28          
ATOM    967  CG2 ILE   123      -2.907  46.112  40.926  1.00 33.86          
ATOM    968  CG1 ILE   123      -0.751  46.501  42.095  1.00 30.43          
ATOM    969  CD  ILE   123      -1.159  45.642  43.263  1.00 31.93          
ATOM    970  C   ILE   123      -2.514  48.816  39.599  1.00 30.35          
ATOM    971  O   ILE   123      -3.287  49.444  40.335  1.00 27.53          
ATOM    972  N   ASP   124      -2.606  48.829  38.278  1.00 30.16          
ATOM    973  CA  ASP   124      -3.539  49.713  37.623  1.00 29.64          
ATOM    974  CB  ASP   124      -2.828  51.055  37.490  1.00 30.77          
ATOM    975  CG  ASP   124      -3.674  52.096  36.854  1.00 33.01          
ATOM    976  OD1 ASP   124      -4.808  52.288  37.337  1.00 36.00          
ATOM    977  OD2 ASP   124      -3.196  52.721  35.884  1.00 33.84          
ATOM    978  C   ASP   124      -3.990  49.225  36.253  1.00 28.95          
ATOM    979  O   ASP   124      -3.320  48.405  35.626  1.00 30.32          
ATOM    980  N   HSD   125      -5.112  49.750  35.777  1.00 28.69          
ATOM    981  CA  HSD   125      -5.613  49.364  34.460  1.00 31.58          
ATOM    982  CB  HSD   125      -6.906  48.538  34.586  1.00 31.91          
ATOM    983  CG  HSD   125      -8.144  49.366  34.696  1.00 35.24          
ATOM    984  CD2 HSD   125      -9.170  49.544  33.833  1.00 36.10          
ATOM    985  ND1 HSD   125      -8.406  50.180  35.778  1.00 36.82          
ATOM    986  CE1 HSD   125      -9.538  50.825  35.574  1.00 38.66          
ATOM    987  NE2 HSD   125     -10.022  50.457  34.400  1.00 37.88          
ATOM    988  C   HSD   125      -5.855  50.565  33.528  1.00 30.90          
ATOM    989  O   HSD   125      -6.551  50.435  32.526  1.00 30.56          
ATOM    990  N   HSD   126      -5.281  51.725  33.853  1.00 29.49          
ATOM    991  CA  HSD   126      -5.435  52.913  33.007  1.00 31.03          
ATOM    992  CB  HSD   126      -5.311  54.188  33.851  1.00 31.51          
ATOM    993  CG  HSD   126      -6.409  54.348  34.858  1.00 34.84          
ATOM    994  CD2 HSD   126      -6.517  53.910  36.137  1.00 31.69          
ATOM    995  ND1 HSD   126      -7.620  54.930  34.551  1.00 34.35          
ATOM    996  CE1 HSD   126      -8.431  54.836  35.593  1.00 33.45          
ATOM    997  NE2 HSD   126      -7.786  54.219  36.568  1.00 33.01          
ATOM    998  C   HSD   126      -4.374  52.922  31.890  1.00 30.40          
ATOM    999  O   HSD   126      -3.332  52.275  32.014  1.00 29.46          
ATOM   1000  N   LEU   127      -4.637  53.652  30.807  1.00 29.08          
ATOM   1001  CA  LEU   127      -3.685  53.715  29.706  1.00 31.21          
ATOM   1002  CB  LEU   127      -4.393  54.030  28.373  1.00 30.35          
ATOM   1003  CG  LEU   127      -5.225  52.907  27.732  1.00 31.41          
ATOM   1004  CD1 LEU   127      -6.582  52.774  28.439  1.00 32.99          
ATOM   1005  CD2 LEU   127      -5.445  53.207  26.260  1.00 32.55          
ATOM   1006  C   LEU   127      -2.588  54.747  29.947  1.00 32.73          
ATOM   1007  O   LEU   127      -2.792  55.736  30.656  1.00 34.88          
ATOM   1008  N   TYR   128      -1.416  54.483  29.372  1.00 32.88          
ATOM   1009  CA  TYR   128      -0.261  55.383  29.453  1.00 31.90          
ATOM   1010  CB  TYR   128      -0.656  56.743  28.855  1.00 28.60          
ATOM   1011  CG  TYR   128      -1.486  56.627  27.592  1.00 29.14          
ATOM   1012  CD1 TYR   128      -1.077  55.813  26.532  1.00 29.87          
ATOM   1013  CE1 TYR   128      -1.858  55.692  25.366  1.00 27.90          
ATOM   1014  CD2 TYR   128      -2.686  57.319  27.456  1.00 27.85          
ATOM   1015  CE2 TYR   128      -3.464  57.211  26.302  1.00 23.10          
ATOM   1016  CZ  TYR   128      -3.051  56.400  25.270  1.00 26.65          
ATOM   1017  OH  TYR   128      -3.845  56.272  24.144  1.00 27.76          
ATOM   1018  C   TYR   128       0.328  55.587  30.854  1.00 32.36          
ATOM   1019  O   TYR   128       0.273  56.684  31.398  1.00 34.11          
ATOM   1020  N   PRO   129       0.937  54.546  31.439  1.00 32.76          
ATOM   1021  CD  PRO   129       1.108  53.189  30.886  1.00 31.40          
ATOM   1022  CA  PRO   129       1.527  54.637  32.781  1.00 34.04          
ATOM   1023  CB  PRO   129       1.650  53.179  33.178  1.00 34.12          
ATOM   1024  CG  PRO   129       2.075  52.554  31.863  1.00 30.03          
ATOM   1025  C   PRO   129       2.891  55.340  32.833  1.00 36.66          
ATOM   1026  O   PRO   129       3.653  55.264  31.879  1.00 36.19          
ATOM   1027  N   GLU   130       3.197  56.006  33.948  1.00 39.16          
ATOM   1028  CA  GLU   130       4.490  56.680  34.106  1.00 42.62          
ATOM   1029  CB  GLU   130       4.390  57.898  35.033  1.00 42.55          
ATOM   1030  CG  GLU   130       3.254  58.866  34.735  1.00 45.87          
ATOM   1031  CD  GLU   130       3.425  60.225  35.429  1.00 48.32          
ATOM   1032  OE1 GLU   130       3.887  60.263  36.597  1.00 47.97          
ATOM   1033  OE2 GLU   130       3.082  61.259  34.804  1.00 48.19          
ATOM   1034  C   GLU   130       5.427  55.648  34.732  1.00 43.40          
ATOM   1035  O   GLU   130       4.978  54.593  35.165  1.00 43.98          
ATOM   1036  N   ASP   131       6.718  55.939  34.800  1.00 46.61          
ATOM   1037  CA  ASP   131       7.646  54.971  35.382  1.00 49.52          
ATOM   1038  CB  ASP   131       8.840  54.754  34.440  1.00 53.09          
ATOM   1039  CG  ASP   131       9.697  56.006  34.281  1.00 59.72          
ATOM   1040  OD1 ASP   131      10.129  56.564  35.313  1.00 62.44          
ATOM   1041  OD2 ASP   131       9.947  56.431  33.129  1.00 62.89          
ATOM   1042  C   ASP   131       8.167  55.313  36.780  1.00 48.22          
ATOM   1043  O   ASP   131       9.329  55.046  37.079  1.00 49.85          
ATOM   1044  N   PHE   132       7.335  55.883  37.646  1.00 46.63          
ATOM   1045  CA  PHE   132       7.814  56.209  38.991  1.00 45.41          
ATOM   1046  CB  PHE   132       6.996  57.354  39.620  1.00 42.93          
ATOM   1047  CG  PHE   132       5.541  57.033  39.830  1.00 43.16          
ATOM   1048  CD1 PHE   132       4.606  57.282  38.828  1.00 41.40          
ATOM   1049  CD2 PHE   132       5.109  56.456  41.026  1.00 41.30          
ATOM   1050  CE1 PHE   132       3.261  56.959  39.013  1.00 42.87          
ATOM   1051  CE2 PHE   132       3.768  56.128  41.219  1.00 41.84          
ATOM   1052  CZ  PHE   132       2.840  56.379  40.211  1.00 42.28          
ATOM   1053  C   PHE   132       7.847  55.002  39.941  1.00 45.62          
ATOM   1054  O   PHE   132       8.362  55.102  41.053  1.00 46.69          
ATOM   1055  N   CYS   133       7.310  53.863  39.510  1.00 45.46          
ATOM   1056  CA  CYS   133       7.320  52.663  40.345  1.00 45.11          
ATOM   1057  CB  CYS   133       5.949  51.987  40.344  1.00 44.69          
ATOM   1058  SG  CYS   133       4.654  52.944  41.162  1.00 45.03          
ATOM   1059  C   CYS   133       8.374  51.680  39.851  1.00 46.08          
ATOM   1060  O   CYS   133       8.686  51.643  38.663  1.00 46.16          
ATOM   1061  N   ARG   134       8.915  50.887  40.771  1.00 48.10          
ATOM   1062  CA  ARG   134       9.945  49.901  40.446  1.00 50.01          
ATOM   1063  CB  ARG   134      10.746  49.547  41.705  1.00 52.85          
ATOM   1064  CG  ARG   134      11.745  48.412  41.533  1.00 59.74          
ATOM   1065  CD  ARG   134      12.873  48.755  40.562  1.00 65.44          
ATOM   1066  NE  ARG   134      13.905  47.713  40.521  1.00 69.14          
ATOM   1067  CZ  ARG   134      13.760  46.518  39.947  1.00 71.05          
ATOM   1068  NH1 ARG   134      12.620  46.189  39.348  1.00 71.80          
ATOM   1069  NH2 ARG   134      14.758  45.642  39.979  1.00 70.72          
ATOM   1070  C   ARG   134       9.330  48.642  39.837  1.00 49.12          
ATOM   1071  O   ARG   134       9.962  47.959  39.031  1.00 50.77          
ATOM   1072  N   ILE   135       8.106  48.327  40.245  1.00 46.06          
ATOM   1073  CA  ILE   135       7.385  47.179  39.707  1.00 43.55          
ATOM   1074  CB  ILE   135       7.039  46.141  40.776  1.00 41.87          
ATOM   1075  CG2 ILE   135       6.199  45.018  40.149  1.00 39.89          
ATOM   1076  CG1 ILE   135       8.322  45.578  41.385  1.00 40.13          
ATOM   1077  CD  ILE   135       8.085  44.541  42.459  1.00 39.37          
ATOM   1078  C   ILE   135       6.090  47.720  39.133  1.00 43.45          
ATOM   1079  O   ILE   135       5.272  48.305  39.855  1.00 43.77          
ATOM   1080  N   THR   136       5.904  47.528  37.834  1.00 42.66          
ATOM   1081  CA  THR   136       4.715  48.033  37.178  1.00 42.58          
ATOM   1082  CB  THR   136       5.086  48.970  36.039  1.00 41.52          
ATOM   1083  OG1 THR   136       5.927  50.013  36.545  1.00 41.82          
ATOM   1084  CG2 THR   136       3.834  49.568  35.419  1.00 39.61          
ATOM   1085  C   THR   136       3.797  46.958  36.626  1.00 42.96          
ATOM   1086  O   THR   136       4.196  46.156  35.784  1.00 42.81          
ATOM   1087  N   ILE   137       2.566  46.949  37.124  1.00 40.95          
ATOM   1088  CA  ILE   137       1.561  46.011  36.675  1.00 40.86          
ATOM   1089  CB  ILE   137       0.998  45.198  37.862  1.00 40.06          
ATOM   1090  CG2 ILE   137      -0.183  44.329  37.414  1.00 38.42          
ATOM   1091  CG1 ILE   137       2.121  44.331  38.445  1.00 39.32          
ATOM   1092  CD  ILE   137       1.709  43.459  39.623  1.00 38.28          
ATOM   1093  C   ILE   137       0.491  46.888  36.038  1.00 42.00          
ATOM   1094  O   ILE   137      -0.404  47.388  36.718  1.00 41.71          
ATOM   1095  N   SER   138       0.617  47.092  34.727  1.00 41.73          
ATOM   1096  CA  SER   138      -0.301  47.928  33.960  1.00 40.12          
ATOM   1097  CB  SER   138       0.473  49.058  33.289  1.00 39.40          
ATOM   1098  OG  SER   138      -0.377  49.875  32.507  1.00 40.81          
ATOM   1099  C   SER   138      -1.017  47.115  32.892  1.00 39.45          
ATOM   1100  O   SER   138      -0.428  46.762  31.868  1.00 40.12          
ATOM   1101  N   HSD   139      -2.292  46.827  33.120  1.00 38.65          
ATOM   1102  CA  HSD   139      -3.065  46.046  32.165  1.00 35.52          
ATOM   1103  CB  HSD   139      -3.338  44.665  32.764  1.00 37.65          
ATOM   1104  CG  HSD   139      -2.094  43.855  32.959  1.00 41.43          
ATOM   1105  CD2 HSD   139      -1.222  43.797  33.993  1.00 40.77          
ATOM   1106  ND1 HSD   139      -1.568  43.052  31.968  1.00 42.62          
ATOM   1107  CE1 HSD   139      -0.424  42.536  32.384  1.00 42.79          
ATOM   1108  NE2 HSD   139      -0.191  42.974  33.609  1.00 43.31          
ATOM   1109  C   HSD   139      -4.353  46.745  31.769  1.00 33.08          
ATOM   1110  O   HSD   139      -5.414  46.463  32.303  1.00 33.78          
ATOM   1111  N   PRO   140      -4.266  47.682  30.813  1.00 33.88          
ATOM   1112  CD  PRO   140      -3.041  48.126  30.117  1.00 30.46          
ATOM   1113  CA  PRO   140      -5.436  48.431  30.343  1.00 31.77          
ATOM   1114  CB  PRO   140      -4.843  49.407  29.328  1.00 33.32          
ATOM   1115  CG  PRO   140      -3.375  49.537  29.777  1.00 32.83          
ATOM   1116  C   PRO   140      -6.502  47.526  29.720  1.00 32.09          
ATOM   1117  O   PRO   140      -7.644  47.937  29.548  1.00 32.78          
ATOM   1118  N   GLU   141      -6.140  46.291  29.394  1.00 31.69          
ATOM   1119  CA  GLU   141      -7.117  45.387  28.805  1.00 32.14          
ATOM   1120  CB  GLU   141      -6.431  44.261  28.002  1.00 31.60          
ATOM   1121  CG  GLU   141      -5.774  43.165  28.832  1.00 31.70          
ATOM   1122  CD  GLU   141      -4.429  43.558  29.395  1.00 35.06          
ATOM   1123  OE1 GLU   141      -4.058  44.749  29.310  1.00 32.08          
ATOM   1124  OE2 GLU   141      -3.742  42.663  29.933  1.00 35.70          
ATOM   1125  C   GLU   141      -8.005  44.798  29.895  1.00 32.30          
ATOM   1126  O   GLU   141      -8.976  44.106  29.607  1.00 34.39          
ATOM   1127  N   ILE   142      -7.677  45.057  31.155  1.00 30.77          
ATOM   1128  CA  ILE   142      -8.514  44.545  32.239  1.00 29.25          
ATOM   1129  CB  ILE   142      -7.650  44.083  33.428  1.00 30.81          
ATOM   1130  CG2 ILE   142      -8.536  43.641  34.600  1.00 33.11          
ATOM   1131  CG1 ILE   142      -6.788  42.901  32.986  1.00 30.46          
ATOM   1132  CD  ILE   142      -7.606  41.660  32.561  1.00 27.12          
ATOM   1133  C   ILE   142      -9.462  45.686  32.623  1.00 28.20          
ATOM   1134  O   ILE   142      -9.048  46.840  32.680  1.00 27.30          
ATOM   1135  N   SER   143     -10.729  45.366  32.863  1.00 27.62          
ATOM   1136  CA  SER   143     -11.717  46.391  33.165  1.00 26.90          
ATOM   1137  CB  SER   143     -13.140  45.849  32.917  1.00 26.26          
ATOM   1138  OG  SER   143     -13.434  44.731  33.724  1.00 30.18          
ATOM   1139  C   SER   143     -11.637  47.092  34.527  1.00 26.94          
ATOM   1140  O   SER   143     -12.240  48.141  34.702  1.00 27.12          
ATOM   1141  N   SER   144     -10.904  46.548  35.489  1.00 26.93          
ATOM   1142  CA  SER   144     -10.782  47.247  36.771  1.00 25.34          
ATOM   1143  CB  SER   144     -12.004  46.978  37.668  1.00 23.94          
ATOM   1144  OG  SER   144     -12.124  45.606  38.003  1.00 24.96          
ATOM   1145  C   SER   144      -9.501  46.904  37.527  1.00 26.87          
ATOM   1146  O   SER   144      -8.832  45.918  37.219  1.00 28.73          
ATOM   1147  N   THR   145      -9.155  47.741  38.505  1.00 27.42          
ATOM   1148  CA  THR   145      -7.973  47.528  39.320  1.00 25.33          
ATOM   1149  CB  THR   145      -7.547  48.838  40.050  1.00 25.77          
ATOM   1150  OG1 THR   145      -7.239  49.837  39.072  1.00 25.47          
ATOM   1151  CG2 THR   145      -6.303  48.615  40.903  1.00 22.85          
ATOM   1152  C   THR   145      -8.323  46.454  40.329  1.00 26.01          
ATOM   1153  O   THR   145      -7.481  45.631  40.678  1.00 26.72          
ATOM   1154  N   SER   146      -9.572  46.464  40.792  1.00 27.09          
ATOM   1155  CA  SER   146     -10.048  45.481  41.751  1.00 27.15          
ATOM   1156  CB  SER   146     -11.557  45.636  41.991  1.00 28.82          
ATOM   1157  OG  SER   146     -11.867  46.839  42.664  1.00 29.92          
ATOM   1158  C   SER   146      -9.768  44.075  41.233  1.00 28.82          
ATOM   1159  O   SER   146      -9.333  43.197  41.985  1.00 30.47          
ATOM   1160  N   GLU   147     -10.018  43.860  39.946  1.00 30.06          
ATOM   1161  CA  GLU   147      -9.782  42.553  39.343  1.00 30.37          
ATOM   1162  CB  GLU   147     -10.334  42.509  37.912  1.00 30.53          
ATOM   1163  CG  GLU   147     -10.335  41.113  37.306  1.00 33.77          
ATOM   1164  CD  GLU   147     -10.665  41.085  35.809  1.00 33.91          
ATOM   1165  OE1 GLU   147     -11.543  41.845  35.351  1.00 35.36          
ATOM   1166  OE2 GLU   147     -10.050  40.279  35.089  1.00 33.44          
ATOM   1167  C   GLU   147      -8.284  42.204  39.326  1.00 30.28          
ATOM   1168  O   GLU   147      -7.912  41.041  39.500  1.00 27.29          
ATOM   1169  N   LEU   148      -7.426  43.199  39.103  1.00 28.62          
ATOM   1170  CA  LEU   148      -5.989  42.932  39.080  1.00 28.85          
ATOM   1171  CB  LEU   148      -5.209  44.137  38.556  1.00 28.47          
ATOM   1172  CG  LEU   148      -5.443  44.507  37.096  1.00 28.28          
ATOM   1173  CD1 LEU   148      -4.612  45.725  36.763  1.00 25.29          
ATOM   1174  CD2 LEU   148      -5.064  43.336  36.182  1.00 28.72          
ATOM   1175  C   LEU   148      -5.497  42.587  40.473  1.00 30.09          
ATOM   1176  O   LEU   148      -4.572  41.790  40.629  1.00 32.18          
ATOM   1177  N   VAL   149      -6.099  43.206  41.485  1.00 30.23          
ATOM   1178  CA  VAL   149      -5.718  42.932  42.866  1.00 27.30          
ATOM   1179  CB  VAL   149      -6.412  43.912  43.838  1.00 26.59          
ATOM   1180  CG1 VAL   149      -6.318  43.412  45.273  1.00 21.56          
ATOM   1181  CG2 VAL   149      -5.757  45.275  43.725  1.00 24.42          
ATOM   1182  C   VAL   149      -6.120  41.498  43.176  1.00 28.80          
ATOM   1183  O   VAL   149      -5.363  40.756  43.814  1.00 29.24          
ATOM   1184  N   PHE   150      -7.311  41.107  42.718  1.00 27.36          
ATOM   1185  CA  PHE   150      -7.796  39.747  42.925  1.00 26.97          
ATOM   1186  CB  PHE   150      -9.215  39.577  42.369  1.00 25.53          
ATOM   1187  CG  PHE   150      -9.750  38.169  42.489  1.00 27.27          
ATOM   1188  CD1 PHE   150      -9.523  37.233  41.487  1.00 28.90          
ATOM   1189  CD2 PHE   150     -10.449  37.772  43.629  1.00 28.85          
ATOM   1190  CE1 PHE   150      -9.983  35.912  41.617  1.00 31.04          
ATOM   1191  CE2 PHE   150     -10.911  36.462  43.777  1.00 29.05          
ATOM   1192  CZ  PHE   150     -10.676  35.526  42.765  1.00 31.17          
ATOM   1193  C   PHE   150      -6.858  38.753  42.236  1.00 28.65          
ATOM   1194  O   PHE   150      -6.441  37.762  42.832  1.00 28.46          
ATOM   1195  N   ARG   151      -6.539  39.014  40.976  1.00 27.60          
ATOM   1196  CA  ARG   151      -5.643  38.140  40.230  1.00 31.06          
ATOM   1197  CB  ARG   151      -5.444  38.675  38.803  1.00 28.29          
ATOM   1198  CG  ARG   151      -6.618  38.410  37.866  1.00 28.51          
ATOM   1199  CD  ARG   151      -6.486  39.198  36.554  1.00 31.13          
ATOM   1200  NE  ARG   151      -6.677  38.341  35.395  1.00 38.81          
ATOM   1201  CZ  ARG   151      -7.835  37.785  35.069  1.00 40.64          
ATOM   1202  NH1 ARG   151      -8.903  38.009  35.812  1.00 46.24          
ATOM   1203  NH2 ARG   151      -7.923  36.991  34.021  1.00 41.74          
ATOM   1204  C   ARG   151      -4.284  37.995  40.932  1.00 32.68          
ATOM   1205  O   ARG   151      -3.804  36.871  41.155  1.00 32.34          
ATOM   1206  N   LEU   152      -3.671  39.124  41.290  1.00 32.29          
ATOM   1207  CA  LEU   152      -2.367  39.097  41.954  1.00 33.82          
ATOM   1208  CB  LEU   152      -1.908  40.521  42.288  1.00 32.12          
ATOM   1209  CG  LEU   152      -0.630  40.682  43.125  1.00 32.33          
ATOM   1210  CD1 LEU   152       0.568  40.028  42.440  1.00 32.89          
ATOM   1211  CD2 LEU   152      -0.375  42.163  43.340  1.00 31.94          
ATOM   1212  C   LEU   152      -2.360  38.246  43.224  1.00 35.91          
ATOM   1213  O   LEU   152      -1.471  37.414  43.419  1.00 36.37          
ATOM   1214  N   ILE   153      -3.353  38.450  44.084  1.00 35.44          
ATOM   1215  CA  ILE   153      -3.432  37.695  45.323  1.00 33.78          
ATOM   1216  CB  ILE   153      -4.588  38.201  46.214  1.00 31.87          
ATOM   1217  CG2 ILE   153      -4.717  37.329  47.429  1.00 28.22          
ATOM   1218  CG1 ILE   153      -4.347  39.660  46.619  1.00 31.24          
ATOM   1219  CD  ILE   153      -5.524  40.288  47.356  1.00 31.56          
ATOM   1220  C   ILE   153      -3.632  36.209  45.033  1.00 34.72          
ATOM   1221  O   ILE   153      -3.121  35.356  45.750  1.00 33.97          
ATOM   1222  N   CYS   154      -4.377  35.903  43.977  1.00 36.23          
ATOM   1223  CA  CYS   154      -4.611  34.517  43.615  1.00 38.23          
ATOM   1224  CB  CYS   154      -5.744  34.429  42.596  1.00 41.01          
ATOM   1225  SG  CYS   154      -6.173  32.739  42.146  1.00 54.00          
ATOM   1226  C   CYS   154      -3.324  33.879  43.060  1.00 37.49          
ATOM   1227  O   CYS   154      -2.929  32.788  43.483  1.00 36.13          
ATOM   1228  N   ARG   155      -2.659  34.565  42.132  1.00 36.33          
ATOM   1229  CA  ARG   155      -1.417  34.048  41.562  1.00 35.61          
ATOM   1230  CB  ARG   155      -0.844  35.021  40.519  1.00 33.86          
ATOM   1231  CG  ARG   155      -1.609  35.078  39.193  1.00 34.43          
ATOM   1232  CD  ARG   155      -1.363  33.851  38.310  1.00 31.75          
ATOM   1233  NE  ARG   155       0.003  33.828  37.796  1.00 33.62          
ATOM   1234  CZ  ARG   155       0.454  34.622  36.831  1.00 35.35          
ATOM   1235  NH1 ARG   155      -0.362  35.499  36.260  1.00 33.15          
ATOM   1236  NH2 ARG   155       1.732  34.567  36.464  1.00 33.38          
ATOM   1237  C   ARG   155      -0.369  33.788  42.648  1.00 36.02          
ATOM   1238  O   ARG   155       0.470  32.903  42.494  1.00 39.16          
ATOM   1239  N   MET   156      -0.423  34.553  43.738  1.00 34.62          
ATOM   1240  CA  MET   156       0.521  34.409  44.855  1.00 34.40          
ATOM   1241  CB  MET   156       0.517  35.669  45.737  1.00 36.57          
ATOM   1242  CG  MET   156       1.217  36.881  45.136  1.00 37.44          
ATOM   1243  SD  MET   156       0.901  38.494  46.176  0.76 46.32          
ATOM   1244  CE  MET   156       2.223  38.222  47.573  1.00 46.33          
ATOM   1245  C   MET   156       0.182  33.197  45.717  1.00 34.41          
ATOM   1246  O   MET   156       0.914  32.872  46.655  1.00 33.86          
ATOM   1247  N   GLY   157      -0.935  32.547  45.393  1.00 33.63          
ATOM   1248  CA  GLY   157      -1.372  31.365  46.118  1.00 33.45          
ATOM   1249  C   GLY   157      -2.242  31.628  47.334  1.00 35.54          
ATOM   1250  O   GLY   157      -2.565  30.703  48.085  1.00 34.63          
ATOM   1251  N   TYR   158      -2.657  32.878  47.521  1.00 35.38          
ATOM   1252  CA  TYR   158      -3.453  33.225  48.694  1.00 34.82          
ATOM   1253  CB  TYR   158      -2.889  34.498  49.318  1.00 35.06          
ATOM   1254  CG  TYR   158      -1.497  34.327  49.865  1.00 36.35          
ATOM   1255  CD1 TYR   158      -1.284  33.710  51.096  1.00 38.52          
ATOM   1256  CE1 TYR   158       0.007  33.550  51.612  1.00 38.11          
ATOM   1257  CD2 TYR   158      -0.387  34.777  49.151  1.00 39.02          
ATOM   1258  CE2 TYR   158       0.906  34.619  49.654  1.00 39.49          
ATOM   1259  CZ  TYR   158       1.088  34.008  50.888  1.00 38.91          
ATOM   1260  OH  TYR   158       2.344  33.889  51.417  1.00 39.72          
ATOM   1261  C   TYR   158      -4.954  33.378  48.516  1.00 33.74          
ATOM   1262  O   TYR   158      -5.587  34.119  49.259  1.00 33.16          
ATOM   1263  N   PHE   159      -5.529  32.681  47.546  1.00 34.83          
ATOM   1264  CA  PHE   159      -6.963  32.773  47.330  1.00 35.85          
ATOM   1265  CB  PHE   159      -7.412  31.763  46.283  1.00 35.40          
ATOM   1266  CG  PHE   159      -8.901  31.723  46.083  1.00 34.82          
ATOM   1267  CD1 PHE   159      -9.571  32.815  45.543  1.00 34.98          
ATOM   1268  CD2 PHE   159      -9.633  30.589  46.425  1.00 34.12          
ATOM   1269  CE1 PHE   159     -10.952  32.784  45.341  1.00 36.22          
ATOM   1270  CE2 PHE   159     -11.010  30.543  46.229  1.00 34.96          
ATOM   1271  CZ  PHE   159     -11.676  31.648  45.682  1.00 37.47          
ATOM   1272  C   PHE   159      -7.728  32.502  48.615  1.00 38.04          
ATOM   1273  O   PHE   159      -8.736  33.160  48.892  1.00 38.13          
ATOM   1274  N   SER   160      -7.247  31.520  49.381  1.00 38.62          
ATOM   1275  CA  SER   160      -7.875  31.103  50.632  1.00 39.13          
ATOM   1276  CB  SER   160      -7.184  29.845  51.180  1.00 39.98          
ATOM   1277  OG  SER   160      -5.814  30.098  51.474  1.00 43.49          
ATOM   1278  C   SER   160      -7.877  32.178  51.706  1.00 37.85          
ATOM   1279  O   SER   160      -8.691  32.144  52.623  1.00 38.58          
ATOM   1280  N   ASP   161      -6.967  33.130  51.592  1.00 36.87          
ATOM   1281  CA  ASP   161      -6.880  34.197  52.568  1.00 36.59          
ATOM   1282  CB  ASP   161      -5.418  34.565  52.800  1.00 38.61          
ATOM   1283  CG  ASP   161      -4.653  33.452  53.485  1.00 39.71          
ATOM   1284  OD1 ASP   161      -5.237  32.818  54.382  1.00 42.10          
ATOM   1285  OD2 ASP   161      -3.478  33.217  53.140  1.00 42.01          
ATOM   1286  C   ASP   161      -7.683  35.437  52.197  1.00 36.21          
ATOM   1287  O   ASP   161      -7.527  36.493  52.811  1.00 35.70          
ATOM   1288  N   ILE   162      -8.526  35.323  51.177  1.00 34.45          
ATOM   1289  CA  ILE   162      -9.357  36.449  50.801  1.00 34.28          
ATOM   1290  CB  ILE   162      -9.661  36.480  49.290  1.00 35.57          
ATOM   1291  CG2 ILE   162     -10.737  37.549  48.993  1.00 33.75          
ATOM   1292  CG1 ILE   162      -8.382  36.779  48.507  1.00 32.37          
ATOM   1293  CD  ILE   162      -8.606  36.843  47.010  1.00 34.07          
ATOM   1294  C   ILE   162     -10.643  36.231  51.575  1.00 34.63          
ATOM   1295  O   ILE   162     -11.358  35.252  51.336  1.00 36.27          
ATOM   1296  N   SER   163     -10.919  37.131  52.517  1.00 32.02          
ATOM   1297  CA  SER   163     -12.109  37.033  53.354  1.00 32.47          
ATOM   1298  CB  SER   163     -11.888  37.791  54.661  1.00 33.83          
ATOM   1299  OG  SER   163     -11.709  39.181  54.405  1.00 36.56          
ATOM   1300  C   SER   163     -13.365  37.571  52.691  1.00 33.22          
ATOM   1301  O   SER   163     -13.316  38.208  51.639  1.00 35.63          
ATOM   1302  N   LYS   164     -14.500  37.314  53.330  1.00 33.29          
ATOM   1303  CA  LYS   164     -15.790  37.775  52.836  1.00 31.81          
ATOM   1304  CB  LYS   164     -16.868  37.373  53.848  1.00 32.57          
ATOM   1305  CG  LYS   164     -18.249  37.972  53.654  1.00 35.91          
ATOM   1306  CD  LYS   164     -19.034  37.792  54.944  1.00 40.37          
ATOM   1307  CE  LYS   164     -20.389  38.464  54.912  1.00 43.39          
ATOM   1308  NZ  LYS   164     -21.300  37.812  53.938  1.00 47.82          
ATOM   1309  C   LYS   164     -15.744  39.297  52.647  1.00 31.13          
ATOM   1310  O   LYS   164     -16.244  39.837  51.648  1.00 30.93          
ATOM   1311  N   GLU   165     -15.121  39.982  53.598  1.00 28.88          
ATOM   1312  CA  GLU   165     -15.008  41.437  53.549  1.00 28.11          
ATOM   1313  CB  GLU   165     -14.474  41.969  54.876  1.00 27.66          
ATOM   1314  CG  GLU   165     -15.364  41.596  56.045  1.00 31.07          
ATOM   1315  CD  GLU   165     -15.002  42.330  57.318  1.00 35.55          
ATOM   1316  OE1 GLU   165     -13.816  42.703  57.474  1.00 38.37          
ATOM   1317  OE2 GLU   165     -15.900  42.525  58.170  1.00 38.76          
ATOM   1318  C   GLU   165     -14.124  41.893  52.407  1.00 27.22          
ATOM   1319  O   GLU   165     -14.461  42.850  51.700  1.00 27.47          
ATOM   1320  N   GLY   166     -13.000  41.204  52.224  1.00 28.61          
ATOM   1321  CA  GLY   166     -12.087  41.536  51.144  1.00 26.26          
ATOM   1322  C   GLY   166     -12.767  41.300  49.807  1.00 25.80          
ATOM   1323  O   GLY   166     -12.592  42.077  48.865  1.00 25.53          
ATOM   1324  N   ALA   167     -13.560  40.230  49.729  1.00 24.96          
ATOM   1325  CA  ALA   167     -14.288  39.876  48.514  1.00 24.41          
ATOM   1326  CB  ALA   167     -14.900  38.477  48.656  1.00 23.92          
ATOM   1327  C   ALA   167     -15.387  40.897  48.207  1.00 25.29          
ATOM   1328  O   ALA   167     -15.723  41.118  47.056  1.00 26.94          
ATOM   1329  N   GLU   168     -15.961  41.492  49.246  1.00 25.80          
ATOM   1330  CA  GLU   168     -16.995  42.501  49.072  1.00 26.84          
ATOM   1331  CB  GLU   168     -17.607  42.891  50.424  1.00 27.74          
ATOM   1332  CG  GLU   168     -18.508  41.826  51.025  1.00 30.09          
ATOM   1333  CD  GLU   168     -18.925  42.164  52.440  1.00 32.85          
ATOM   1334  OE1 GLU   168     -18.454  43.187  52.982  1.00 32.58          
ATOM   1335  OE2 GLU   168     -19.723  41.400  53.016  1.00 34.25          
ATOM   1336  C   GLU   168     -16.377  43.739  48.447  1.00 26.11          
ATOM   1337  O   GLU   168     -16.970  44.370  47.581  1.00 27.62          
ATOM   1338  N   CYS   169     -15.176  44.076  48.895  1.00 25.36          
ATOM   1339  CA  CYS   169     -14.492  45.257  48.395  1.00 25.51          
ATOM   1340  CB  CYS   169     -13.317  45.580  49.314  1.00 26.47          
ATOM   1341  SG  CYS   169     -13.873  45.951  50.998  1.00 29.13          
ATOM   1342  C   CYS   169     -14.036  45.084  46.945  1.00 27.43          
ATOM   1343  O   CYS   169     -14.202  45.979  46.115  1.00 26.93          
ATOM   1344  N   ILE   170     -13.472  43.922  46.641  1.00 28.32          
ATOM   1345  CA  ILE   170     -13.031  43.637  45.286  1.00 28.24          
ATOM   1346  CB  ILE   170     -12.321  42.273  45.218  1.00 27.26          
ATOM   1347  CG2 ILE   170     -12.205  41.807  43.770  1.00 22.52          
ATOM   1348  CG1 ILE   170     -10.954  42.400  45.889  1.00 27.47          
ATOM   1349  CD  ILE   170     -10.271  41.078  46.166  1.00 31.01          
ATOM   1350  C   ILE   170     -14.223  43.643  44.335  1.00 28.14          
ATOM   1351  O   ILE   170     -14.156  44.220  43.254  1.00 28.90          
ATOM   1352  N   TYR   171     -15.322  43.009  44.729  1.00 26.16          
ATOM   1353  CA  TYR   171     -16.484  42.986  43.855  1.00 27.19          
ATOM   1354  CB  TYR   171     -17.606  42.145  44.464  1.00 27.05          
ATOM   1355  CG  TYR   171     -18.846  42.131  43.607  1.00 28.28          
ATOM   1356  CD1 TYR   171     -18.890  41.394  42.423  1.00 28.11          
ATOM   1357  CE1 TYR   171     -20.004  41.442  41.582  1.00 30.14          
ATOM   1358  CD2 TYR   171     -19.950  42.915  43.935  1.00 29.55          
ATOM   1359  CE2 TYR   171     -21.075  42.976  43.098  1.00 29.92          
ATOM   1360  CZ  TYR   171     -21.093  42.238  41.926  1.00 31.21          
ATOM   1361  OH  TYR   171     -22.187  42.307  41.093  1.00 31.95          
ATOM   1362  C   TYR   171     -16.993  44.418  43.585  1.00 28.05          
ATOM   1363  O   TYR   171     -17.315  44.776  42.452  1.00 28.96          
ATOM   1364  N   THR   172     -17.049  45.235  44.634  1.00 28.13          
ATOM   1365  CA  THR   172     -17.529  46.603  44.502  1.00 27.14          
ATOM   1366  CB  THR   172     -17.411  47.356  45.842  1.00 28.33          
ATOM   1367  OG1 THR   172     -18.253  46.721  46.807  1.00 30.25          
ATOM   1368  CG2 THR   172     -17.837  48.821  45.695  1.00 26.97          
ATOM   1369  C   THR   172     -16.772  47.361  43.417  1.00 26.85          
ATOM   1370  O   THR   172     -17.376  48.080  42.635  1.00 27.08          
ATOM   1371  N   GLY   173     -15.455  47.192  43.364  1.00 25.96          
ATOM   1372  CA  GLY   173     -14.666  47.889  42.367  1.00 24.87          
ATOM   1373  C   GLY   173     -14.959  47.406  40.959  1.00 26.12          
ATOM   1374  O   GLY   173     -15.051  48.202  40.022  1.00 27.09          
ATOM   1375  N   MET   174     -15.098  46.094  40.806  1.00 27.58          
ATOM   1376  CA  MET   174     -15.383  45.504  39.503  1.00 27.65          
ATOM   1377  CB  MET   174     -15.342  43.969  39.594  1.00 27.61          
ATOM   1378  CG  MET   174     -13.952  43.399  39.876  1.00 28.52          
ATOM   1379  SD  MET   174     -13.891  41.464  40.113  0.87 36.46          
ATOM   1380  CE  MET   174     -14.392  40.953  38.311  1.00 28.76          
ATOM   1381  C   MET   174     -16.757  45.968  39.022  1.00 27.10          
ATOM   1382  O   MET   174     -16.931  46.299  37.855  1.00 27.31          
ATOM   1383  N   MET   175     -17.726  45.994  39.929  1.00 27.16          
ATOM   1384  CA  MET   175     -19.086  46.420  39.585  1.00 30.18          
ATOM   1385  CB  MET   175     -20.014  46.220  40.782  1.00 28.11          
ATOM   1386  CG  MET   175     -21.393  46.839  40.626  1.00 31.10          
ATOM   1387  SD  MET   175     -22.425  46.704  42.265  0.83 38.55          
ATOM   1388  CE  MET   175     -23.410  45.066  41.844  1.00 40.78          
ATOM   1389  C   MET   175     -19.109  47.895  39.177  1.00 30.51          
ATOM   1390  O   MET   175     -19.649  48.281  38.150  1.00 33.21          
ATOM   1391  N   THR   176     -18.510  48.704  40.019  1.00 32.00          
ATOM   1392  CA  THR   176     -18.430  50.129  39.830  1.00 33.48          
ATOM   1393  CB  THR   176     -17.776  50.728  41.090  1.00 32.77          
ATOM   1394  OG1 THR   176     -18.811  51.272  41.921  1.00 36.49          
ATOM   1395  CG2 THR   176     -16.748  51.748  40.757  1.00 37.91          
ATOM   1396  C   THR   176     -17.718  50.574  38.543  1.00 33.25          
ATOM   1397  O   THR   176     -18.233  51.412  37.806  1.00 33.46          
ATOM   1398  N   ASP   177     -16.557  50.004  38.247  1.00 31.93          
ATOM   1399  CA  ASP   177     -15.846  50.430  37.046  1.00 31.98          
ATOM   1400  CB  ASP   177     -14.377  50.031  37.110  1.00 31.15          
ATOM   1401  CG  ASP   177     -13.464  51.177  36.738  1.00 33.75          
ATOM   1402  OD1 ASP   177     -13.397  52.134  37.529  1.00 33.92          
ATOM   1403  OD2 ASP   177     -12.833  51.144  35.651  1.00 34.05          
ATOM   1404  C   ASP   177     -16.448  49.968  35.721  1.00 29.47          
ATOM   1405  O   ASP   177     -16.066  50.476  34.679  1.00 30.03          
ATOM   1406  N   THR   178     -17.372  49.010  35.756  1.00 26.64          
ATOM   1407  CA  THR   178     -18.030  48.541  34.536  1.00 24.46          
ATOM   1408  CB  THR   178     -18.048  47.008  34.432  1.00 23.17          
ATOM   1409  OG1 THR   178     -18.662  46.475  35.612  1.00 21.83          
ATOM   1410  CG2 THR   178     -16.635  46.446  34.254  1.00 18.25          
ATOM   1411  C   THR   178     -19.501  48.977  34.502  1.00 24.93          
ATOM   1412  O   THR   178     -20.288  48.424  33.734  1.00 25.61          
ATOM   1413  N   GLY   179     -19.875  49.934  35.349  1.00 24.84          
ATOM   1414  CA  GLY   179     -21.257  50.396  35.389  1.00 26.11          
ATOM   1415  C   GLY   179     -22.224  49.264  35.699  1.00 27.41          
ATOM   1416  O   GLY   179     -23.289  49.140  35.078  1.00 26.05          
ATOM   1417  N   GLY   180     -21.856  48.429  36.662  1.00 26.42          
ATOM   1418  CA  GLY   180     -22.707  47.314  37.010  1.00 26.63          
ATOM   1419  C   GLY   180     -22.670  46.251  35.925  1.00 28.01          
ATOM   1420  O   GLY   180     -23.692  45.625  35.644  1.00 30.69          
ATOM   1421  N   PHE   181     -21.495  46.047  35.319  1.00 28.77          
ATOM   1422  CA  PHE   181     -21.293  45.052  34.252  1.00 29.65          
ATOM   1423  CB  PHE   181     -21.443  43.642  34.827  1.00 27.89          
ATOM   1424  CG  PHE   181     -20.507  43.372  35.967  1.00 29.12          
ATOM   1425  CD1 PHE   181     -19.146  43.153  35.731  1.00 25.36          
ATOM   1426  CD2 PHE   181     -20.962  43.430  37.282  1.00 26.39          
ATOM   1427  CE1 PHE   181     -18.253  43.005  36.787  1.00 23.94          
ATOM   1428  CE2 PHE   181     -20.080  43.288  38.345  1.00 28.32          
ATOM   1429  CZ  PHE   181     -18.714  43.074  38.098  1.00 25.88          
ATOM   1430  C   PHE   181     -22.206  45.247  33.036  1.00 30.64          
ATOM   1431  O   PHE   181     -22.848  44.304  32.527  1.00 29.85          
ATOM   1432  N   THR   182     -22.248  46.489  32.570  1.00 31.07          
ATOM   1433  CA  THR   182     -23.039  46.853  31.406  1.00 33.07          
ATOM   1434  CB  THR   182     -24.131  47.888  31.769  1.00 34.08          
ATOM   1435  OG1 THR   182     -23.523  49.080  32.291  1.00 30.35          
ATOM   1436  CG2 THR   182     -25.080  47.303  32.802  1.00 31.13          
ATOM   1437  C   THR   182     -22.115  47.461  30.361  1.00 35.11          
ATOM   1438  O   THR   182     -22.507  47.655  29.216  1.00 37.32          
ATOM   1439  N   TYR   183     -20.879  47.741  30.765  1.00 35.90          
ATOM   1440  CA  TYR   183     -19.895  48.352  29.892  1.00 37.98          
ATOM   1441  CB  TYR   183     -19.914  49.875  30.154  1.00 42.87          
ATOM   1442  CG  TYR   183     -18.571  50.572  30.134  1.00 47.63          
ATOM   1443  CD1 TYR   183     -17.841  50.775  31.311  1.00 49.33          
ATOM   1444  CE1 TYR   183     -16.578  51.395  31.283  1.00 52.30          
ATOM   1445  CD2 TYR   183     -18.014  51.007  28.928  1.00 52.35          
ATOM   1446  CE2 TYR   183     -16.757  51.628  28.882  1.00 55.10          
ATOM   1447  CZ  TYR   183     -16.043  51.818  30.058  1.00 54.65          
ATOM   1448  OH  TYR   183     -14.802  52.423  29.982  1.00 54.09          
ATOM   1449  C   TYR   183     -18.481  47.748  30.070  1.00 37.87          
ATOM   1450  O   TYR   183     -17.998  47.598  31.190  1.00 38.40          
ATOM   1451  N   ASN   184     -17.842  47.382  28.955  1.00 37.08          
ATOM   1452  CA  ASN   184     -16.487  46.817  28.957  1.00 36.25          
ATOM   1453  CB  ASN   184     -15.495  47.883  29.460  1.00 38.50          
ATOM   1454  CG  ASN   184     -14.037  47.491  29.250  1.00 41.70          
ATOM   1455  OD1 ASN   184     -13.691  46.814  28.275  1.00 43.17          
ATOM   1456  ND2 ASN   184     -13.166  47.939  30.158  1.00 43.13          
ATOM   1457  C   ASN   184     -16.401  45.554  29.818  1.00 35.55          
ATOM   1458  O   ASN   184     -15.401  45.307  30.484  1.00 33.07          
ATOM   1459  N   SER   185     -17.458  44.749  29.788  1.00 34.76          
ATOM   1460  CA  SER   185     -17.501  43.536  30.595  1.00 35.27          
ATOM   1461  CB  SER   185     -18.621  43.645  31.644  1.00 33.75          
ATOM   1462  OG  SER   185     -19.916  43.519  31.052  1.00 33.36          
ATOM   1463  C   SER   185     -17.702  42.257  29.792  1.00 34.83          
ATOM   1464  O   SER   185     -18.153  41.259  30.336  1.00 35.65          
ATOM   1465  N   ASN   186     -17.374  42.272  28.506  1.00 36.30          
ATOM   1466  CA  ASN   186     -17.548  41.069  27.683  1.00 37.20          
ATOM   1467  CB  ASN   186     -17.388  41.392  26.202  1.00 38.02          
ATOM   1468  CG  ASN   186     -18.690  41.774  25.562  1.00 41.93          
ATOM   1469  OD1 ASN   186     -19.718  41.129  25.799  1.00 44.55          
ATOM   1470  ND2 ASN   186     -18.666  42.824  24.742  1.00 42.63          
ATOM   1471  C   ASN   186     -16.648  39.885  27.991  1.00 35.72          
ATOM   1472  O   ASN   186     -16.934  38.777  27.567  1.00 37.06          
ATOM   1473  N   ASN   187     -15.564  40.113  28.719  1.00 35.37          
ATOM   1474  CA  ASN   187     -14.627  39.044  29.038  1.00 34.61          
ATOM   1475  CB  ASN   187     -13.366  39.654  29.644  1.00 34.20          
ATOM   1476  CG  ASN   187     -12.228  38.658  29.740  1.00 36.08          
ATOM   1477  OD1 ASN   187     -12.274  37.731  30.533  1.00 38.86          
ATOM   1478  ND2 ASN   187     -11.206  38.844  28.921  1.00 37.91          
ATOM   1479  C   ASN   187     -15.197  37.946  29.957  1.00 35.01          
ATOM   1480  O   ASN   187     -15.663  38.208  31.066  1.00 33.39          
ATOM   1481  N   ARG   188     -15.149  36.712  29.472  1.00 34.87          
ATOM   1482  CA  ARG   188     -15.638  35.546  30.203  1.00 36.55          
ATOM   1483  CB  ARG   188     -15.330  34.269  29.414  1.00 38.74          
ATOM   1484  CG  ARG   188     -15.954  34.198  28.038  1.00 45.42          
ATOM   1485  CD  ARG   188     -15.510  32.933  27.320  1.00 49.93          
ATOM   1486  NE  ARG   188     -15.802  31.738  28.105  1.00 54.73          
ATOM   1487  CZ  ARG   188     -15.416  30.509  27.772  1.00 57.44          
ATOM   1488  NH1 ARG   188     -14.716  30.308  26.659  1.00 58.34          
ATOM   1489  NH2 ARG   188     -15.723  29.481  28.556  1.00 57.11          
ATOM   1490  C   ARG   188     -15.054  35.364  31.605  1.00 35.34          
ATOM   1491  O   ARG   188     -15.734  34.903  32.512  1.00 33.02          
ATOM   1492  N   GLU   189     -13.784  35.703  31.772  1.00 35.80          
ATOM   1493  CA  GLU   189     -13.125  35.508  33.051  1.00 35.79          
ATOM   1494  CB  GLU   189     -11.612  35.645  32.878  1.00 39.48          
ATOM   1495  CG  GLU   189     -10.986  34.462  32.118  1.00 44.18          
ATOM   1496  CD  GLU   189      -9.510  34.662  31.809  1.00 47.71          
ATOM   1497  OE1 GLU   189      -8.712  34.797  32.753  1.00 46.93          
ATOM   1498  OE2 GLU   189      -9.143  34.690  30.615  1.00 52.27          
ATOM   1499  C   GLU   189     -13.630  36.399  34.175  1.00 36.30          
ATOM   1500  O   GLU   189     -13.349  36.140  35.343  1.00 35.97          
ATOM   1501  N   ILE   190     -14.375  37.445  33.824  1.00 34.55          
ATOM   1502  CA  ILE   190     -14.937  38.334  34.827  1.00 32.00          
ATOM   1503  CB  ILE   190     -15.669  39.531  34.177  1.00 32.80          
ATOM   1504  CG2 ILE   190     -16.560  40.208  35.197  1.00 31.52          
ATOM   1505  CG1 ILE   190     -14.664  40.529  33.596  1.00 32.56          
ATOM   1506  CD  ILE   190     -15.342  41.696  32.831  1.00 25.42          
ATOM   1507  C   ILE   190     -15.967  37.564  35.666  1.00 32.30          
ATOM   1508  O   ILE   190     -16.000  37.687  36.890  1.00 32.46          
ATOM   1509  N   TYR   191     -16.795  36.768  34.985  1.00 30.94          
ATOM   1510  CA  TYR   191     -17.864  35.990  35.613  1.00 29.63          
ATOM   1511  CB  TYR   191     -18.895  35.620  34.533  1.00 26.56          
ATOM   1512  CG  TYR   191     -19.298  36.888  33.823  1.00 27.05          
ATOM   1513  CD1 TYR   191     -20.177  37.793  34.433  1.00 27.31          
ATOM   1514  CE1 TYR   191     -20.371  39.079  33.918  1.00 27.13          
ATOM   1515  CD2 TYR   191     -18.638  37.298  32.660  1.00 26.65          
ATOM   1516  CE2 TYR   191     -18.820  38.585  32.134  1.00 28.47          
ATOM   1517  CZ  TYR   191     -19.682  39.471  32.776  1.00 29.42          
ATOM   1518  OH  TYR   191     -19.800  40.766  32.332  1.00 29.95          
ATOM   1519  C   TYR   191     -17.381  34.787  36.408  1.00 29.74          
ATOM   1520  O   TYR   191     -18.028  34.360  37.363  1.00 30.86          
ATOM   1521  N   PHE   192     -16.241  34.237  36.039  1.00 30.44          
ATOM   1522  CA  PHE   192     -15.713  33.143  36.826  1.00 29.53          
ATOM   1523  CB  PHE   192     -14.515  32.504  36.128  1.00 32.28          
ATOM   1524  CG  PHE   192     -13.824  31.453  36.960  1.00 35.87          
ATOM   1525  CD1 PHE   192     -14.430  30.219  37.193  1.00 34.97          
ATOM   1526  CD2 PHE   192     -12.575  31.710  37.532  1.00 35.73          
ATOM   1527  CE1 PHE   192     -13.802  29.250  37.987  1.00 37.32          
ATOM   1528  CE2 PHE   192     -11.939  30.750  38.326  1.00 37.87          
ATOM   1529  CZ  PHE   192     -12.554  29.518  38.553  1.00 38.02          
ATOM   1530  C   PHE   192     -15.256  33.796  38.140  1.00 29.35          
ATOM   1531  O   PHE   192     -15.447  33.250  39.219  1.00 30.15          
ATOM   1532  N   ILE   193     -14.664  34.985  38.043  1.00 29.06          
ATOM   1533  CA  ILE   193     -14.186  35.690  39.233  1.00 27.57          
ATOM   1534  CB  ILE   193     -13.341  36.930  38.824  1.00 28.35          
ATOM   1535  CG2 ILE   193     -13.057  37.831  40.042  1.00 25.51          
ATOM   1536  CG1 ILE   193     -12.017  36.454  38.190  1.00 24.46          
ATOM   1537  CD  ILE   193     -11.033  37.591  37.864  1.00 24.39          
ATOM   1538  C   ILE   193     -15.370  36.073  40.134  1.00 29.26          
ATOM   1539  O   ILE   193     -15.314  35.917  41.359  1.00 28.70          
ATOM   1540  N   ILE   194     -16.462  36.533  39.528  1.00 28.48          
ATOM   1541  CA  ILE   194     -17.628  36.889  40.314  1.00 27.23          
ATOM   1542  CB  ILE   194     -18.772  37.398  39.425  1.00 26.40          
ATOM   1543  CG2 ILE   194     -20.101  37.392  40.220  1.00 21.87          
ATOM   1544  CG1 ILE   194     -18.430  38.805  38.916  1.00 23.24          
ATOM   1545  CD  ILE   194     -19.428  39.353  37.895  1.00 25.70          
ATOM   1546  C   ILE   194     -18.087  35.643  41.062  1.00 28.71          
ATOM   1547  O   ILE   194     -18.419  35.695  42.244  1.00 28.58          
ATOM   1548  N   SER   195     -18.090  34.514  40.367  1.00 30.04          
ATOM   1549  CA  SER   195     -18.498  33.265  40.986  1.00 31.00          
ATOM   1550  CB  SER   195     -18.465  32.133  39.957  1.00 31.22          
ATOM   1551  OG  SER   195     -18.849  30.911  40.554  1.00 36.50          
ATOM   1552  C   SER   195     -17.588  32.934  42.169  1.00 31.24          
ATOM   1553  O   SER   195     -18.059  32.481  43.202  1.00 33.18          
ATOM   1554  N   GLU   196     -16.290  33.176  42.024  1.00 32.73          
ATOM   1555  CA  GLU   196     -15.332  32.901  43.092  1.00 33.94          
ATOM   1556  CB  GLU   196     -13.899  33.138  42.598  1.00 37.81          
ATOM   1557  CG  GLU   196     -13.478  32.233  41.461  1.00 41.38          
ATOM   1558  CD  GLU   196     -13.333  30.800  41.908  1.00 46.25          
ATOM   1559  OE1 GLU   196     -12.191  30.374  42.206  1.00 47.63          
ATOM   1560  OE2 GLU   196     -14.370  30.102  41.974  1.00 48.65          
ATOM   1561  C   GLU   196     -15.575  33.776  44.315  1.00 34.01          
ATOM   1562  O   GLU   196     -15.429  33.329  45.457  1.00 35.27          
ATOM   1563  N   LEU   197     -15.923  35.037  44.067  1.00 33.36          
ATOM   1564  CA  LEU   197     -16.183  35.990  45.140  1.00 29.03          
ATOM   1565  CB  LEU   197     -16.305  37.409  44.569  1.00 26.66          
ATOM   1566  CG  LEU   197     -15.010  37.970  43.958  1.00 25.48          
ATOM   1567  CD1 LEU   197     -15.297  39.260  43.196  1.00 24.52          
ATOM   1568  CD2 LEU   197     -13.989  38.207  45.062  1.00 24.18          
ATOM   1569  C   LEU   197     -17.455  35.606  45.885  1.00 29.57          
ATOM   1570  O   LEU   197     -17.521  35.727  47.109  1.00 29.13          
ATOM   1571  N   LEU   198     -18.458  35.136  45.145  1.00 30.03          
ATOM   1572  CA  LEU   198     -19.731  34.732  45.742  1.00 30.25          
ATOM   1573  CB  LEU   198     -20.751  34.383  44.657  1.00 28.58          
ATOM   1574  CG  LEU   198     -21.483  35.533  43.969  1.00 26.47          
ATOM   1575  CD1 LEU   198     -22.244  35.020  42.771  1.00 24.74          
ATOM   1576  CD2 LEU   198     -22.454  36.163  44.962  1.00 27.49          
ATOM   1577  C   LEU   198     -19.519  33.523  46.640  1.00 32.45          
ATOM   1578  O   LEU   198     -20.229  33.340  47.626  1.00 33.99          
ATOM   1579  N   SER   199     -18.534  32.701  46.304  1.00 33.73          
ATOM   1580  CA  SER   199     -18.258  31.522  47.107  1.00 35.25          
ATOM   1581  CB  SER   199     -17.304  30.562  46.371  1.00 35.31          
ATOM   1582  OG  SER   199     -15.969  31.059  46.332  1.00 38.05          
ATOM   1583  C   SER   199     -17.644  31.967  48.433  1.00 35.09          
ATOM   1584  O   SER   199     -17.490  31.162  49.342  1.00 36.33          
ATOM   1585  N   LYS   200     -17.299  33.250  48.540  1.00 34.71          
ATOM   1586  CA  LYS   200     -16.721  33.773  49.777  1.00 33.11          
ATOM   1587  CB  LYS   200     -15.753  34.915  49.497  1.00 35.23          
ATOM   1588  CG  LYS   200     -14.544  34.547  48.648  1.00 38.23          
ATOM   1589  CD  LYS   200     -13.511  33.766  49.427  1.00 41.15          
ATOM   1590  CE  LYS   200     -12.282  33.501  48.555  1.00 44.94          
ATOM   1591  NZ  LYS   200     -11.180  32.833  49.304  1.00 44.66          
ATOM   1592  C   LYS   200     -17.829  34.280  50.682  1.00 32.44          
ATOM   1593  O   LYS   200     -17.567  34.797  51.759  1.00 31.53          
ATOM   1594  N   GLY   201     -19.074  34.144  50.235  1.00 32.78          
ATOM   1595  CA  GLY   201     -20.194  34.576  51.054  1.00 30.44          
ATOM   1596  C   GLY   201     -20.776  35.958  50.817  1.00 30.41          
ATOM   1597  O   GLY   201     -21.658  36.380  51.563  1.00 28.74          
ATOM   1598  N   ILE   202     -20.328  36.670  49.787  1.00 30.88          
ATOM   1599  CA  ILE   202     -20.868  38.005  49.580  1.00 33.35          
ATOM   1600  CB  ILE   202     -19.982  38.881  48.655  1.00 33.04          
ATOM   1601  CG2 ILE   202     -18.533  38.814  49.094  1.00 32.09          
ATOM   1602  CG1 ILE   202     -20.149  38.447  47.202  1.00 34.24          
ATOM   1603  CD  ILE   202     -19.512  39.400  46.218  1.00 33.20          
ATOM   1604  C   ILE   202     -22.268  37.994  48.996  1.00 33.81          
ATOM   1605  O   ILE   202     -22.719  37.005  48.419  1.00 35.35          
ATOM   1606  N   ASP   203     -22.958  39.112  49.171  1.00 34.27          
ATOM   1607  CA  ASP   203     -24.295  39.273  48.639  1.00 31.99          
ATOM   1608  CB  ASP   203     -25.275  39.696  49.741  1.00 34.30          
ATOM   1609  CG  ASP   203     -26.706  39.772  49.240  1.00 35.91          
ATOM   1610  OD1 ASP   203     -26.896  39.860  48.006  1.00 36.40          
ATOM   1611  OD2 ASP   203     -27.642  39.749  50.068  1.00 36.83          
ATOM   1612  C   ASP   203     -24.143  40.389  47.623  1.00 30.24          
ATOM   1613  O   ASP   203     -24.156  41.560  47.985  1.00 30.86          
ATOM   1614  N   LYS   204     -24.003  40.034  46.351  1.00 28.91          
ATOM   1615  CA  LYS   204     -23.811  41.050  45.320  1.00 27.49          
ATOM   1616  CB  LYS   204     -23.404  40.402  43.984  1.00 25.75          
ATOM   1617  CG  LYS   204     -24.430  39.462  43.377  1.00 22.65          
ATOM   1618  CD  LYS   204     -23.849  38.694  42.178  1.00 26.13          
ATOM   1619  CE  LYS   204     -23.612  39.601  40.962  1.00 22.67          
ATOM   1620  NZ  LYS   204     -24.878  40.119  40.351  1.00 26.05          
ATOM   1621  C   LYS   204     -25.006  41.957  45.105  1.00 27.76          
ATOM   1622  O   LYS   204     -24.846  43.101  44.703  1.00 28.21          
ATOM   1623  N   ASP   205     -26.205  41.444  45.346  1.00 28.58          
ATOM   1624  CA  ASP   205     -27.393  42.256  45.160  1.00 29.45          
ATOM   1625  CB  ASP   205     -28.650  41.371  45.206  1.00 29.61          
ATOM   1626  CG  ASP   205     -28.794  40.500  43.945  1.00 32.48          
ATOM   1627  OD1 ASP   205     -28.212  40.883  42.897  1.00 31.51          
ATOM   1628  OD2 ASP   205     -29.494  39.448  43.988  1.00 26.53          
ATOM   1629  C   ASP   205     -27.426  43.349  46.228  1.00 31.45          
ATOM   1630  O   ASP   205     -27.769  44.497  45.942  1.00 32.07          
ATOM   1631  N   ASP   206     -27.036  43.001  47.451  1.00 32.36          
ATOM   1632  CA  ASP   206     -27.014  43.977  48.540  1.00 33.45          
ATOM   1633  CB  ASP   206     -26.750  43.286  49.882  1.00 34.82          
ATOM   1634  CG  ASP   206     -26.917  44.229  51.061  1.00 36.95          
ATOM   1635  OD1 ASP   206     -28.046  44.723  51.272  1.00 38.08          
ATOM   1636  OD2 ASP   206     -25.919  44.489  51.773  1.00 41.70          
ATOM   1637  C   ASP   206     -25.953  45.051  48.303  1.00 32.60          
ATOM   1638  O   ASP   206     -26.156  46.217  48.659  1.00 33.43          
ATOM   1639  N   ILE   207     -24.819  44.652  47.720  1.00 30.96          
ATOM   1640  CA  ILE   207     -23.720  45.579  47.427  1.00 28.75          
ATOM   1641  CB  ILE   207     -22.479  44.835  46.878  1.00 27.95          
ATOM   1642  CG2 ILE   207     -21.490  45.828  46.254  1.00 22.28          
ATOM   1643  CG1 ILE   207     -21.812  44.050  48.007  1.00 28.52          
ATOM   1644  CD  ILE   207     -20.519  43.372  47.593  1.00 31.28          
ATOM   1645  C   ILE   207     -24.195  46.584  46.391  1.00 29.34          
ATOM   1646  O   ILE   207     -23.880  47.773  46.464  1.00 27.18          
ATOM   1647  N   TYR   208     -24.954  46.089  45.420  1.00 30.26          
ATOM   1648  CA  TYR   208     -25.519  46.936  44.387  1.00 30.72          
ATOM   1649  CB  TYR   208     -26.386  46.118  43.435  1.00 31.93          
ATOM   1650  CG  TYR   208     -27.042  46.988  42.399  1.00 34.80          
ATOM   1651  CD1 TYR   208     -26.315  47.451  41.314  1.00 37.17          
ATOM   1652  CE1 TYR   208     -26.872  48.319  40.394  1.00 40.08          
ATOM   1653  CD2 TYR   208     -28.367  47.417  42.541  1.00 37.07          
ATOM   1654  CE2 TYR   208     -28.936  48.296  41.619  1.00 38.96          
ATOM   1655  CZ  TYR   208     -28.171  48.740  40.549  1.00 40.83          
ATOM   1656  OH  TYR   208     -28.668  49.624  39.616  1.00 47.44          
ATOM   1657  C   TYR   208     -26.406  48.014  45.017  1.00 30.74          
ATOM   1658  O   TYR   208     -26.286  49.203  44.693  1.00 32.39          
ATOM   1659  N   ARG   209     -27.309  47.587  45.896  1.00 29.59          
ATOM   1660  CA  ARG   209     -28.236  48.504  46.564  1.00 31.14          
ATOM   1661  CB  ARG   209     -29.246  47.731  47.429  1.00 28.96          
ATOM   1662  CG  ARG   209     -30.367  47.085  46.621  1.00 33.30          
ATOM   1663  CD  ARG   209     -31.462  46.536  47.516  1.00 36.06          
ATOM   1664  NE  ARG   209     -31.061  45.298  48.175  1.00 39.96          
ATOM   1665  CZ  ARG   209     -31.199  44.088  47.637  1.00 43.93          
ATOM   1666  NH1 ARG   209     -31.735  43.945  46.428  1.00 45.67          
ATOM   1667  NH2 ARG   209     -30.797  43.021  48.305  1.00 44.04          
ATOM   1668  C   ARG   209     -27.539  49.547  47.422  1.00 30.77          
ATOM   1669  O   ARG   209     -27.923  50.716  47.423  1.00 29.95          
ATOM   1670  N   LYS   210     -26.515  49.118  48.147  1.00 30.75          
ATOM   1671  CA  LYS   210     -25.763  50.005  49.018  1.00 30.54          
ATOM   1672  CB  LYS   210     -24.758  49.188  49.828  1.00 29.89          
ATOM   1673  CG  LYS   210     -25.389  48.417  50.984  1.00 31.07          
ATOM   1674  CD  LYS   210     -24.370  47.517  51.675  1.00 32.60          
ATOM   1675  CE  LYS   210     -24.546  47.541  53.172  1.00 33.06          
ATOM   1676  NZ  LYS   210     -25.961  47.315  53.527  1.00 36.41          
ATOM   1677  C   LYS   210     -25.044  51.128  48.272  1.00 31.25          
ATOM   1678  O   LYS   210     -24.890  52.227  48.793  1.00 34.02          
ATOM   1679  N   VAL   211     -24.620  50.851  47.046  1.00 30.57          
ATOM   1680  CA  VAL   211     -23.904  51.831  46.237  1.00 28.27          
ATOM   1681  CB  VAL   211     -22.827  51.126  45.350  1.00 25.73          
ATOM   1682  CG1 VAL   211     -22.190  52.110  44.376  1.00 19.95          
ATOM   1683  CG2 VAL   211     -21.768  50.494  46.225  1.00 20.49          
ATOM   1684  C   VAL   211     -24.812  52.672  45.331  1.00 32.06          
ATOM   1685  O   VAL   211     -24.604  53.885  45.189  1.00 32.03          
ATOM   1686  N   TYR   212     -25.823  52.041  44.736  1.00 31.92          
ATOM   1687  CA  TYR   212     -26.695  52.741  43.803  1.00 35.21          
ATOM   1688  CB  TYR   212     -26.794  51.937  42.511  1.00 33.86          
ATOM   1689  CG  TYR   212     -25.463  51.714  41.830  1.00 34.74          
ATOM   1690  CD1 TYR   212     -24.796  52.768  41.195  1.00 32.46          
ATOM   1691  CE1 TYR   212     -23.588  52.558  40.540  1.00 31.55          
ATOM   1692  CD2 TYR   212     -24.879  50.441  41.799  1.00 31.42          
ATOM   1693  CE2 TYR   212     -23.675  50.216  41.147  1.00 31.04          
ATOM   1694  CZ  TYR   212     -23.041  51.275  40.516  1.00 34.10          
ATOM   1695  OH  TYR   212     -21.899  51.045  39.806  1.00 36.56          
ATOM   1696  C   TYR   212     -28.105  53.114  44.249  1.00 38.85          
ATOM   1697  O   TYR   212     -28.734  53.988  43.636  1.00 38.01          
ATOM   1698  N   ASN   213     -28.610  52.464  45.292  1.00 41.30          
ATOM   1699  CA  ASN   213     -29.955  52.753  45.774  1.00 43.85          
ATOM   1700  CB  ASN   213     -30.769  51.470  45.817  1.00 44.64          
ATOM   1701  CG  ASN   213     -30.914  50.837  44.451  1.00 48.21          
ATOM   1702  OD1 ASN   213     -31.324  49.688  44.336  1.00 52.04          
ATOM   1703  ND2 ASN   213     -30.588  51.592  43.403  1.00 48.25          
ATOM   1704  C   ASN   213     -29.924  53.384  47.148  1.00 46.10          
ATOM   1705  O   ASN   213     -30.675  53.000  48.044  1.00 46.55          
ATOM   1706  N   THR   214     -29.049  54.363  47.314  1.00 49.38          
ATOM   1707  CA  THR   214     -28.932  55.026  48.593  1.00 54.47          
ATOM   1708  CB  THR   214     -27.792  54.426  49.444  1.00 56.19          
ATOM   1709  OG1 THR   214     -26.595  54.361  48.659  1.00 56.02          
ATOM   1710  CG2 THR   214     -28.177  53.026  49.962  1.00 56.49          
ATOM   1711  C   THR   214     -28.688  56.507  48.463  1.00 57.84          
ATOM   1712  O   THR   214     -27.545  56.967  48.483  1.00 59.27          
END
