
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  316 ( 2518),  selected  316 , name 3dev_A
# Molecule2: number of CA atoms  213 ( 1712),  selected  213 , name T0501_2_214.pdb
# PARAMETERS: 3dev_A.T0501_2_214.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      L       2           -
LGA    -       -      T       3           -
LGA    -       -      K       4           -
LGA    -       -      V       5           -
LGA    -       -      I       6           -
LGA    V     2_A      A       7           #
LGA    E     3_A      Q       8          2.412
LGA    -       -      A       9           -
LGA    I     4_A      X      10          0.429
LGA    F     5_A      I      11          1.386
LGA    N     6_A      D      12          1.605
LGA    E     7_A      X      13          0.854
LGA    I     8_A      F      14          1.365
LGA    X     9_A      T      15          2.038
LGA    Q    10_A      K      16          1.376
LGA    R    11_A      W      17          1.463
LGA    V    12_A      F      18          2.162
LGA    K    13_A      E      19          1.948
LGA    E    14_A      R      20          1.972
LGA    A    15_A      A      21          2.067
LGA    E    16_A      D      22          1.186
LGA    T    17_A      K      23          0.377
LGA    I    18_A      I      24          0.967
LGA    I    19_A      V      25          0.395
LGA    I    20_A      I      26          0.637
LGA    H    21_A      V      27          0.667
LGA    R    22_A      S      28          0.831
LGA    H    23_A      X      29          1.128
LGA    V    24_A      V      30          0.889
LGA    R    25_A      S      31          2.165
LGA    P    26_A      P      32          1.339
LGA    D    27_A      D      33          1.639
LGA    P    28_A      G      34          0.695
LGA    D    29_A      D      35          0.834
LGA    A    30_A      A      36          0.961
LGA    Y    31_A      I      37          0.974
LGA    G    32_A      G      38          0.693
LGA    S    33_A      S      39          0.710
LGA    Q    34_A      S      40          0.678
LGA    L    35_A      L      41          0.895
LGA    G    36_A      G      42          0.853
LGA    L    37_A      L      43          0.800
LGA    K    38_A      Y      44          0.951
LGA    L    39_A      X      45          0.796
LGA    Y    40_A      F      46          0.683
LGA    L    41_A      L      47          0.551
LGA    E    42_A      D      48          0.551
LGA    R    43_A      S      49          0.903
LGA    K    44_A      Q      50          1.975
LGA    F    45_A      D      51          2.971
LGA    P    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    K    48_A      K      52          2.183
LGA    N    49_A      I      53          0.833
LGA    I    50_A      V      54          0.482
LGA    Y    51_A      N      55          0.486
LGA    A    52_A      V      56          0.307
LGA    T    53_A      I      57          0.466
LGA    G    54_A      V      58          1.525
LGA    E    55_A      P      59          3.900
LGA    -       -      N      60           -
LGA    A    56_A      A      61          2.589
LGA    E    57_A      F      62          1.288
LGA    P    58_A      P      63          3.429
LGA    S    59_A      D      64          2.701
LGA    -       -      F      65           -
LGA    L    60_A      L      66          1.871
LGA    S    61_A      K      67          1.700
LGA    F    62_A      W      68          1.897
LGA    I    63_A      M      69          2.259
LGA    -       -      P      70           -
LGA    G    64_A      G      71          4.041
LGA    D    65_A      S      72          1.720
LGA    -       -      K      73           -
LGA    -       -      D      74           -
LGA    L    66_A      I      75          0.505
LGA    D    67_A      L      76          3.145
LGA    -       -      L      77           -
LGA    -       -      Y      78           -
LGA    -       -      D      79           -
LGA    -       -      R      80           -
LGA    E    68_A      Y      81          5.798
LGA    -       -      Q      82           -
LGA    -       -      E      83           -
LGA    I    69_A      F      84          4.165
LGA    D    70_A      A      85          3.999
LGA    D    71_A      D      86          1.882
LGA    S    72_A      K      87          1.671
LGA    V    73_A      L      88          2.590
LGA    Y    74_A      I      89          2.743
LGA    S    75_A      M      90          3.373
LGA    D    76_A      E      91          3.323
LGA    A    77_A      A      92          1.367
LGA    L    78_A      D      93          3.565
LGA    -       -      V      94           -
LGA    V    79_A      I      95          1.278
LGA    I    80_A      C      96          1.129
LGA    V    81_A      C      97          0.973
LGA    C    82_A      L      98          0.509
LGA    D    83_A      D      99          0.661
LGA    T    84_A      F     100          0.486
LGA    A    85_A      N     101          3.239
LGA    N    86_A      A     102          1.908
LGA    A    87_A      L     103          1.412
LGA    P    88_A      K     104          0.838
LGA    R    89_A      R     105          0.903
LGA    I    90_A      I     106          1.761
LGA    D    91_A      D     107          4.954
LGA    D    92_A      E     108          5.828
LGA    Q    93_A      M     109          0.871
LGA    -       -      S     110           -
LGA    -       -      D     111           -
LGA    R    94_A      I     112          2.295
LGA    Y    95_A      V     113          1.712
LGA    L    96_A      A     114          2.016
LGA    N    97_A      A     115          3.458
LGA    G    98_A      S     116          2.286
LGA    Q    99_A      P     117          2.224
LGA    S   100_A      G     118          3.094
LGA    -       -      R     119           -
LGA    L   101_A      K     120          1.751
LGA    I   102_A      I     121          1.434
LGA    K   103_A      M     122          0.911
LGA    I   104_A      I     123          0.983
LGA    D   105_A      D     124          0.565
LGA    H   106_A      X     125          0.616
LGA    H   107_A      X     126          1.100
LGA    P   108_A      L     127          1.460
LGA    A   109_A      Y     128          3.056
LGA    T   110_A      P     129          3.414
LGA    D   111_A      E     130          1.604
LGA    Q   112_A      D     131          2.831
LGA    Y   113_A      F     132          2.375
LGA    G   114_A      C     133          1.206
LGA    D   115_A      R     134          1.353
LGA    V   116_A      I     135          1.158
LGA    N   117_A      T     136          0.888
LGA    F   118_A      I     137          0.911
LGA    V   119_A      S     138          0.590
LGA    N   120_A      X     139          1.528
LGA    T   121_A      P     140          1.921
LGA    E   122_A      E     141          1.508
LGA    A   123_A      I     142          1.049
LGA    S   124_A      S     143          1.414
LGA    S   125_A      S     144          0.561
LGA    T   126_A      T     145          0.554
LGA    S   127_A      S     146          0.476
LGA    E   128_A      E     147          0.315
LGA    I   129_A      L     148          0.354
LGA    I   130_A      V     149          0.635
LGA    F   131_A      F     150          0.681
LGA    D   132_A      R     151          0.487
LGA    F   133_A      L     152          0.626
LGA    I   134_A      I     153          0.811
LGA    S   135_A      C     154          0.615
LGA    H   136_A      R     155          0.742
LGA    F   137_A      M     156          1.925
LGA    N   138_A      G     157          2.018
LGA    D   139_A      Y     158          1.215
LGA    L   140_A      F     159          1.447
LGA    S   141_A      S     160          1.161
LGA    I   142_A      D     161          1.373
LGA    I   143_A      I     162          1.436
LGA    D   144_A      S     163          1.019
LGA    E   145_A      K     164          0.461
LGA    H   146_A      E     165          0.757
LGA    V   147_A      G     166          0.372
LGA    A   148_A      A     167          0.230
LGA    R   149_A      E     168          0.471
LGA    V   150_A      C     169          0.317
LGA    L   151_A      I     170          0.106
LGA    Y   152_A      Y     171          0.364
LGA    L   153_A      T     172          0.630
LGA    G   154_A      G     173          0.631
LGA    I   155_A      M     174          0.281
LGA    V   156_A      M     175          0.420
LGA    G   157_A      T     176          0.448
LGA    D   158_A      D     177          0.469
LGA    T   159_A      T     178          0.691
LGA    G   160_A      G     179          1.295
LGA    R   161_A      G     180          1.669
LGA    F   162_A      F     181          1.439
LGA    L   163_A      T     182          1.198
LGA    F   164_A      Y     183          0.641
LGA    S   165_A      N     184          2.127
LGA    N   166_A      S     185          4.094
LGA    T   167_A      N     186          3.939
LGA    S   168_A      N     187          1.095
LGA    P   169_A      R     188          0.718
LGA    H   170_A      E     189          0.860
LGA    T   171_A      I     190          1.217
LGA    X   172_A      Y     191          1.478
LGA    E   173_A      F     192          1.237
LGA    V   174_A      I     193          0.945
LGA    A   175_A      I     194          1.217
LGA    S   176_A      S     195          1.354
LGA    Q   177_A      E     196          0.725
LGA    L   178_A      L     197          0.514
LGA    L   179_A      L     198          1.040
LGA    A   180_A      S     199          1.002
LGA    Y   181_A      K     200          1.260
LGA    P   182_A      G     201          1.567
LGA    F   183_A      I     202          2.812
LGA    N   184_A      D     203          1.561
LGA    H   185_A      K     204          1.643
LGA    N   186_A      D     205          1.512
LGA    A   187_A      D     206          1.410
LGA    E   188_A      I     207          1.703
LGA    L   189_A      Y     208          1.203
LGA    N   190_A      R     209          0.131
LGA    K   191_A      K     210          1.032
LGA    X   192_A      V     211          0.513
LGA    S   193_A      Y     212          0.759
LGA    E   194_A      N     213          1.972
LGA    K   195_A      T     214          4.731
LGA    D   196_A      -       -           -
LGA    P   197_A      -       -           -
LGA    K   198_A      -       -           -
LGA    L   199_A      -       -           -
LGA    X   200_A      -       -           -
LGA    P   201_A      -       -           -
LGA    F   202_A      -       -           -
LGA    Q   203_A      -       -           -
LGA    G   204_A      -       -           -
LGA    Y   205_A      -       -           -
LGA    V   206_A      -       -           -
LGA    L   207_A      -       -           -
LGA    Q   208_A      -       -           -
LGA    N   209_A      -       -           -
LGA    F   210_A      -       -           -
LGA    E   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    S   213_A      -       -           -
LGA    D   214_A      -       -           -
LGA    S   215_A      -       -           -
LGA    H   216_A      -       -           -
LGA    E   217_A      -       -           -
LGA    Y   218_A      -       -           -
LGA    C   219_A      -       -           -
LGA    Q   220_A      -       -           -
LGA    I   221_A      -       -           -
LGA    K   222_A      -       -           -
LGA    I   223_A      -       -           -
LGA    T   224_A      -       -           -
LGA    N   225_A      -       -           -
LGA    D   226_A      -       -           -
LGA    V   227_A      -       -           -
LGA    L   228_A      -       -           -
LGA    K   229_A      -       -           -
LGA    Q   230_A      -       -           -
LGA    F   231_A      -       -           -
LGA    D   232_A      -       -           -
LGA    I   233_A      -       -           -
LGA    Q   234_A      -       -           -
LGA    P   235_A      -       -           -
LGA    N   236_A      -       -           -
LGA    E   237_A      -       -           -
LGA    A   238_A      -       -           -
LGA    S   239_A      -       -           -
LGA    Q   240_A      -       -           -
LGA    F   241_A      -       -           -
LGA    V   242_A      -       -           -
LGA    N   243_A      -       -           -
LGA    T   244_A      -       -           -
LGA    V   245_A      -       -           -
LGA    A   246_A      -       -           -
LGA    D   247_A      -       -           -
LGA    I   248_A      -       -           -
LGA    S   249_A      -       -           -
LGA    G   250_A      -       -           -
LGA    L   251_A      -       -           -
LGA    K   252_A      -       -           -
LGA    I   253_A      -       -           -
LGA    W   254_A      -       -           -
LGA    X   255_A      -       -           -
LGA    F   256_A      -       -           -
LGA    G   257_A      -       -           -
LGA    V   258_A      -       -           -
LGA    D   259_A      -       -           -
LGA    E   260_A      -       -           -
LGA    G   261_A      -       -           -
LGA    D   262_A      -       -           -
LGA    Q   263_A      -       -           -
LGA    I   264_A      -       -           -
LGA    R   265_A      -       -           -
LGA    C   266_A      -       -           -
LGA    R   267_A      -       -           -
LGA    I   268_A      -       -           -
LGA    R   269_A      -       -           -
LGA    S   270_A      -       -           -
LGA    K   271_A      -       -           -
LGA    G   272_A      -       -           -
LGA    I   273_A      -       -           -
LGA    T   274_A      -       -           -
LGA    I   275_A      -       -           -
LGA    N   276_A      -       -           -
LGA    D   277_A      -       -           -
LGA    V   278_A      -       -           -
LGA    A   279_A      -       -           -
LGA    N   280_A      -       -           -
LGA    Q   281_A      -       -           -
LGA    F   282_A      -       -           -
LGA    G   283_A      -       -           -
LGA    G   284_A      -       -           -
LGA    G   285_A      -       -           -
LGA    G   286_A      -       -           -
LGA    H   287_A      -       -           -
LGA    P   288_A      -       -           -
LGA    N   289_A      -       -           -
LGA    A   290_A      -       -           -
LGA    S   291_A      -       -           -
LGA    G   292_A      -       -           -
LGA    V   293_A      -       -           -
LGA    S   294_A      -       -           -
LGA    V   295_A      -       -           -
LGA    Y   296_A      -       -           -
LGA    S   297_A      -       -           -
LGA    W   298_A      -       -           -
LGA    D   299_A      -       -           -
LGA    E   300_A      -       -           -
LGA    F   301_A      -       -           -
LGA    E   302_A      -       -           -
LGA    E   303_A      -       -           -
LGA    L   304_A      -       -           -
LGA    A   305_A      -       -           -
LGA    Q   306_A      -       -           -
LGA    A   307_A      -       -           -
LGA    L   308_A      -       -           -
LGA    R   309_A      -       -           -
LGA    Q   310_A      -       -           -
LGA    K   311_A      -       -           -
LGA    L   312_A      -       -           -
LGA    L   313_A      -       -           -
LGA    E   314_A      -       -           -
LGA    H   315_A      -       -           -
LGA    H   316_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  316  213    5.0    191    1.82    25.65     81.109     9.965

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.733148 * X  +   0.238752 * Y  +   0.636782 * Z  + -57.062729
  Y_new =   0.115738 * X  +  -0.878886 * Y  +   0.462778 * Z  +  12.341155
  Z_new =   0.670148 * X  +   0.412985 * Y  +   0.616721 * Z  + -37.473480 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.590063   -2.551530  [ DEG:    33.8081   -146.1919 ]
  Theta =  -0.734408   -2.407184  [ DEG:   -42.0785   -137.9215 ]
  Phi   =   2.985020   -0.156573  [ DEG:   171.0291     -8.9709 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3dev_A                                        
REMARK     2: T0501_2_214.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3dev_A.T0501_2_214.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  316  213   5.0  191   1.82   25.65  81.109
REMARK  ---------------------------------------------------------- 
MOLECULE 3dev_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   10-JUN-08   3DEV              
TITLE     CRYSTAL STRUCTURE OF SH1221 PROTEIN FROM STAPHYLOCOCCUS               
TITLE    2 HAEMOLYTICUS, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 TARGET SHR87                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SH1221;                                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS HAEMOLYTICUS JCSC1435;           
SOURCE   3 STRAIN: JCSC1435;                                                    
SOURCE   4 GENE: SH1221;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PET21;                                
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: BL21                                      
KEYWDS    ALPHA-BETA PROTEIN., STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG, UNKNOWN FUNCTION                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,R.XIAO,C.CICCOSANTI,           
AUTHOR   2 E.L.FOOTE,D.WANG,J.K.EVERETT,T.B.ACTON,G.T.MONTELIONE,               
AUTHOR   3 L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM             
AUTHOR   4 (NESG)                                                               
REVDAT   1   05-AUG-08 3DEV    0                                                
JRNL        AUTH   F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,R.XIAO,               
JRNL        AUTH 2 C.CICCOSANTI,E.L.FOOTE,D.WANG,J.K.EVERETT,                   
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,L.TONG,J.F.HUNT                     
JRNL        TITL   CRYSTAL STRUCTURE OF SH1221 PROTEIN FROM                     
JRNL        TITL 2 STAPHYLOCOCCUS HAEMOLYTICUS, NORTHEAST STRUCTURAL            
JRNL        TITL 3 GENOMICS CONSORTIUM TARGET SHR87                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 3.10 ANGSTROMS.                                          
DBREF  3DEV A    1   312  UNP    Q4L745   Q4L745_STAHJ     1    312             
DBREF  3DEV B    1   312  UNP    Q4L745   Q4L745_STAHJ     1    312             
SEQRES   1 A  320  MSE VAL GLU ILE PHE ASN GLU ILE MSE GLN ARG VAL LYS          
SEQRES   2 A  320  GLU ALA GLU THR ILE ILE ILE HIS ARG HIS VAL ARG PRO          
SEQRES   3 A  320  ASP PRO ASP ALA TYR GLY SER GLN LEU GLY LEU LYS LEU          
SEQRES   4 A  320  TYR LEU GLU ARG LYS PHE PRO GLU LYS ASN ILE TYR ALA          
SEQRES   5 A  320  THR GLY GLU ALA GLU PRO SER LEU SER PHE ILE GLY ASP          
SEQRES   6 A  320  LEU ASP GLU ILE ASP ASP SER VAL TYR SER ASP ALA LEU          
SEQRES   7 A  320  VAL ILE VAL CYS ASP THR ALA ASN ALA PRO ARG ILE ASP          
SEQRES   8 A  320  ASP GLN ARG TYR LEU ASN GLY GLN SER LEU ILE LYS ILE          
SEQRES   9 A  320  ASP HIS HIS PRO ALA THR ASP GLN TYR GLY ASP VAL ASN          
SEQRES  10 A  320  PHE VAL ASN THR GLU ALA SER SER THR SER GLU ILE ILE          
SEQRES  11 A  320  PHE ASP PHE ILE SER HIS PHE ASN ASP LEU SER ILE ILE          
SEQRES  12 A  320  ASP GLU HIS VAL ALA ARG VAL LEU TYR LEU GLY ILE VAL          
SEQRES  13 A  320  GLY ASP THR GLY ARG PHE LEU PHE SER ASN THR SER PRO          
SEQRES  14 A  320  HIS THR MSE GLU VAL ALA SER GLN LEU LEU ALA TYR PRO          
SEQRES  15 A  320  PHE ASN HIS ASN ALA GLU LEU ASN LYS MSE SER GLU LYS          
SEQRES  16 A  320  ASP PRO LYS LEU MSE PRO PHE GLN GLY TYR VAL LEU GLN          
SEQRES  17 A  320  ASN PHE GLU LEU SER ASP SER HIS GLU TYR CYS GLN ILE          
SEQRES  18 A  320  LYS ILE THR ASN ASP VAL LEU LYS GLN PHE ASP ILE GLN          
SEQRES  19 A  320  PRO ASN GLU ALA SER GLN PHE VAL ASN THR VAL ALA ASP          
SEQRES  20 A  320  ILE SER GLY LEU LYS ILE TRP MSE PHE GLY VAL ASP GLU          
SEQRES  21 A  320  GLY ASP GLN ILE ARG CYS ARG ILE ARG SER LYS GLY ILE          
SEQRES  22 A  320  THR ILE ASN ASP VAL ALA ASN GLN PHE GLY GLY GLY GLY          
SEQRES  23 A  320  HIS PRO ASN ALA SER GLY VAL SER VAL TYR SER TRP ASP          
SEQRES  24 A  320  GLU PHE GLU GLU LEU ALA GLN ALA LEU ARG GLN LYS LEU          
SEQRES  25 A  320  LEU GLU HIS HIS HIS HIS HIS HIS                              
SEQRES   1 B  320  MSE VAL GLU ILE PHE ASN GLU ILE MSE GLN ARG VAL LYS          
SEQRES   2 B  320  GLU ALA GLU THR ILE ILE ILE HIS ARG HIS VAL ARG PRO          
SEQRES   3 B  320  ASP PRO ASP ALA TYR GLY SER GLN LEU GLY LEU LYS LEU          
SEQRES   4 B  320  TYR LEU GLU ARG LYS PHE PRO GLU LYS ASN ILE TYR ALA          
SEQRES   5 B  320  THR GLY GLU ALA GLU PRO SER LEU SER PHE ILE GLY ASP          
SEQRES   6 B  320  LEU ASP GLU ILE ASP ASP SER VAL TYR SER ASP ALA LEU          
SEQRES   7 B  320  VAL ILE VAL CYS ASP THR ALA ASN ALA PRO ARG ILE ASP          
SEQRES   8 B  320  ASP GLN ARG TYR LEU ASN GLY GLN SER LEU ILE LYS ILE          
SEQRES   9 B  320  ASP HIS HIS PRO ALA THR ASP GLN TYR GLY ASP VAL ASN          
SEQRES  10 B  320  PHE VAL ASN THR GLU ALA SER SER THR SER GLU ILE ILE          
SEQRES  11 B  320  PHE ASP PHE ILE SER HIS PHE ASN ASP LEU SER ILE ILE          
SEQRES  12 B  320  ASP GLU HIS VAL ALA ARG VAL LEU TYR LEU GLY ILE VAL          
SEQRES  13 B  320  GLY ASP THR GLY ARG PHE LEU PHE SER ASN THR SER PRO          
SEQRES  14 B  320  HIS THR MSE GLU VAL ALA SER GLN LEU LEU ALA TYR PRO          
SEQRES  15 B  320  PHE ASN HIS ASN ALA GLU LEU ASN LYS MSE SER GLU LYS          
SEQRES  16 B  320  ASP PRO LYS LEU MSE PRO PHE GLN GLY TYR VAL LEU GLN          
SEQRES  17 B  320  ASN PHE GLU LEU SER ASP SER HIS GLU TYR CYS GLN ILE          
SEQRES  18 B  320  LYS ILE THR ASN ASP VAL LEU LYS GLN PHE ASP ILE GLN          
SEQRES  19 B  320  PRO ASN GLU ALA SER GLN PHE VAL ASN THR VAL ALA ASP          
SEQRES  20 B  320  ILE SER GLY LEU LYS ILE TRP MSE PHE GLY VAL ASP GLU          
SEQRES  21 B  320  GLY ASP GLN ILE ARG CYS ARG ILE ARG SER LYS GLY ILE          
SEQRES  22 B  320  THR ILE ASN ASP VAL ALA ASN GLN PHE GLY GLY GLY GLY          
SEQRES  23 B  320  HIS PRO ASN ALA SER GLY VAL SER VAL TYR SER TRP ASP          
SEQRES  24 B  320  GLU PHE GLU GLU LEU ALA GLN ALA LEU ARG GLN LYS LEU          
SEQRES  25 B  320  LEU GLU HIS HIS HIS HIS HIS HIS                              
HET    MSE  A   1       8                                                       
HET    MSE  A   9       8                                                       
HET    MSE  A 172       8                                                       
HET    MSE  A 192       8                                                       
HET    MSE  A 200       8                                                       
HET    MSE  A 255       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   9       8                                                       
HET    MSE  B 172       8                                                       
HET    MSE  B 192       8                                                       
HET    MSE  B 200       8                                                       
HET    MSE  B 255       8                                                       
HET    SO4  A 321       5                                                       
HET    SO4  A 322       5                                                       
HET    SO4  B 321       5                                                       
HET     MG  A 323       1                                                       
HET     MG  B 322       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6   MG    2(MG 2+)                                                     
FORMUL   8  HOH   *36(H2 O)                                                     
CRYST1  106.087  106.087   86.092  90.00  90.00 120.00 P 3           6          
HETATM    1  N   MSE A   1      13.237  40.224  36.707  1.00107.15           N  
HETATM    2  CA  MSE A   1      12.366  39.021  36.532  1.00110.20           C  
HETATM    3  C   MSE A   1      11.440  39.136  35.324  1.00103.11           C  
HETATM    4  O   MSE A   1      11.611  40.009  34.470  1.00101.63           O  
HETATM    5  CB  MSE A   1      11.513  38.786  37.785  1.00117.37           C  
HETATM    6  CG  MSE A   1      12.309  38.481  39.050  1.00128.00           C  
HETATM    7 SE   MSE A   1      11.185  37.938  40.547  1.00141.28          SE  
HETATM    8  CE  MSE A   1      11.557  36.025  40.584  1.00130.11           C  
ATOM      9  N   VAL A   2      10.468  38.232  35.251  1.00 90.22           N  
ATOM     10  CA  VAL A   2       9.497  38.239  34.168  1.00 80.97           C  
ATOM     11  C   VAL A   2       8.114  38.152  34.795  1.00 78.54           C  
ATOM     12  O   VAL A   2       7.110  38.521  34.178  1.00 78.95           O  
ATOM     13  CB  VAL A   2       9.705  37.048  33.196  1.00 74.80           C  
ATOM     14  CG1 VAL A   2       9.423  35.729  33.890  1.00 68.18           C  
ATOM     15  CG2 VAL A   2       8.817  37.216  31.978  1.00 69.04           C  
ATOM     16  N   GLU A   3       8.079  37.690  36.044  1.00 69.52           N  
ATOM     17  CA  GLU A   3       6.830  37.535  36.786  1.00 67.11           C  
ATOM     18  C   GLU A   3       6.656  38.599  37.867  1.00 65.96           C  
ATOM     19  O   GLU A   3       6.747  38.302  39.058  1.00 62.55           O  
ATOM     20  CB  GLU A   3       6.776  36.142  37.417  1.00 58.49           C  
ATOM     21  CG  GLU A   3       5.687  35.267  36.839  1.00 62.57           C  
ATOM     22  CD  GLU A   3       4.383  35.388  37.589  1.00 64.12           C  
ATOM     23  OE1 GLU A   3       4.012  36.508  37.991  1.00 65.77           O  
ATOM     24  OE2 GLU A   3       3.719  34.353  37.771  1.00 74.53           O  
ATOM     25  N   ILE A   4       6.376  39.828  37.434  1.00 64.33           N  
ATOM     26  CA  ILE A   4       6.198  40.977  38.324  1.00 64.95           C  
ATOM     27  C   ILE A   4       5.467  40.683  39.649  1.00 65.25           C  
ATOM     28  O   ILE A   4       5.866  41.187  40.701  1.00 61.15           O  
ATOM     29  CB  ILE A   4       5.478  42.161  37.577  1.00 65.33           C  
ATOM     30  CG1 ILE A   4       6.245  42.557  36.310  1.00 55.20           C  
ATOM     31  CG2 ILE A   4       5.402  43.387  38.476  1.00 68.18           C  
ATOM     32  CD1 ILE A   4       5.964  41.694  35.096  1.00 56.58           C  
ATOM     33  N   PHE A   5       4.408  39.877  39.611  1.00 66.16           N  
ATOM     34  CA  PHE A   5       3.662  39.536  40.834  1.00 65.41           C  
ATOM     35  C   PHE A   5       4.568  39.080  41.972  1.00 63.59           C  
ATOM     36  O   PHE A   5       4.336  39.410  43.131  1.00 56.06           O  
ATOM     37  CB  PHE A   5       2.665  38.402  40.575  1.00 65.88           C  
ATOM     38  CG  PHE A   5       1.328  38.852  40.066  1.00 63.57           C  
ATOM     39  CD1 PHE A   5       0.313  37.923  39.860  1.00 60.03           C  
ATOM     40  CD2 PHE A   5       1.079  40.186  39.782  1.00 65.50           C  
ATOM     41  CE1 PHE A   5      -0.923  38.311  39.383  1.00 53.84           C  
ATOM     42  CE2 PHE A   5      -0.159  40.587  39.301  1.00 61.36           C  
ATOM     43  CZ  PHE A   5      -1.160  39.646  39.102  1.00 60.79           C  
ATOM     44  N   ASN A   6       5.577  38.288  41.620  1.00 63.93           N  
ATOM     45  CA  ASN A   6       6.531  37.747  42.576  1.00 66.70           C  
ATOM     46  C   ASN A   6       7.441  38.835  43.133  1.00 69.75           C  
ATOM     47  O   ASN A   6       7.740  38.870  44.329  1.00 65.60           O  
ATOM     48  CB  ASN A   6       7.388  36.668  41.907  1.00 67.90           C  
ATOM     49  CG  ASN A   6       6.628  35.383  41.662  1.00 69.31           C  
ATOM     50  OD1 ASN A   6       7.150  34.443  41.060  1.00 73.17           O  
ATOM     51  ND2 ASN A   6       5.389  35.330  42.137  1.00 70.55           N  
ATOM     52  N   GLU A   7       7.887  39.717  42.249  1.00 69.02           N  
ATOM     53  CA  GLU A   7       8.759  40.800  42.642  1.00 69.01           C  
ATOM     54  C   GLU A   7       7.999  41.743  43.576  1.00 69.91           C  
ATOM     55  O   GLU A   7       8.581  42.352  44.470  1.00 77.83           O  
ATOM     56  CB  GLU A   7       9.258  41.522  41.398  1.00 66.05           C  
ATOM     57  CG  GLU A   7      10.150  42.696  41.672  1.00 78.21           C  
ATOM     58  CD  GLU A   7      10.993  43.052  40.463  1.00 90.68           C  
ATOM     59  OE1 GLU A   7      10.476  42.942  39.322  1.00 82.13           O  
ATOM     60  OE2 GLU A   7      12.166  43.456  40.655  1.00 95.04           O  
ATOM     61  N   ILE A   8       6.691  41.848  43.389  1.00 62.65           N  
ATOM     62  CA  ILE A   8       5.902  42.704  44.259  1.00 59.28           C  
ATOM     63  C   ILE A   8       5.829  42.046  45.627  1.00 59.51           C  
ATOM     64  O   ILE A   8       6.276  42.611  46.619  1.00 62.32           O  
ATOM     65  CB  ILE A   8       4.481  42.912  43.693  1.00 59.05           C  
ATOM     66  CG1 ILE A   8       4.566  43.759  42.437  1.00 39.80           C  
ATOM     67  CG2 ILE A   8       3.586  43.607  44.702  1.00 38.62           C  
ATOM     68  CD1 ILE A   8       3.290  43.799  41.692  1.00 45.10           C  
HETATM   69  N   MSE A   9       5.280  40.841  45.669  1.00 64.02           N  
HETATM   70  CA  MSE A   9       5.151  40.088  46.911  1.00 69.42           C  
HETATM   71  C   MSE A   9       6.462  40.016  47.681  1.00 71.01           C  
HETATM   72  O   MSE A   9       6.468  39.866  48.904  1.00 63.84           O  
HETATM   73  CB  MSE A   9       4.685  38.673  46.599  1.00 78.98           C  
HETATM   74  CG  MSE A   9       4.420  37.834  47.817  1.00 84.31           C  
HETATM   75 SE   MSE A   9       3.080  38.613  48.943  1.00102.94          SE  
HETATM   76  CE  MSE A   9       1.501  37.667  48.322  1.00 94.08           C  
ATOM     77  N   GLN A  10       7.572  40.097  46.953  1.00 74.03           N  
ATOM     78  CA  GLN A  10       8.887  40.049  47.575  1.00 75.12           C  
ATOM     79  C   GLN A  10       9.088  41.364  48.299  1.00 70.68           C  
ATOM     80  O   GLN A  10       9.243  41.390  49.516  1.00 72.11           O  
ATOM     81  CB  GLN A  10       9.973  39.864  46.517  1.00 83.91           C  
ATOM     82  CG  GLN A  10      11.392  39.775  47.077  1.00 95.65           C  
ATOM     83  CD  GLN A  10      11.515  38.765  48.217  1.00103.91           C  
ATOM     84  OE1 GLN A  10      10.892  37.696  48.184  1.00101.34           O  
ATOM     85  NE2 GLN A  10      12.332  39.094  49.222  1.00101.20           N  
ATOM     86  N   ARG A  11       9.068  42.455  47.544  1.00 61.18           N  
ATOM     87  CA  ARG A  11       9.229  43.777  48.120  1.00 61.78           C  
ATOM     88  C   ARG A  11       8.306  43.948  49.343  1.00 68.15           C  
ATOM     89  O   ARG A  11       8.643  44.657  50.294  1.00 66.41           O  
ATOM     90  CB  ARG A  11       8.901  44.829  47.070  1.00 56.91           C  
ATOM     91  CG  ARG A  11       9.443  46.207  47.367  1.00 68.10           C  
ATOM     92  CD  ARG A  11      10.787  46.396  46.715  1.00 77.71           C  
ATOM     93  NE  ARG A  11      10.855  45.697  45.429  1.00 80.20           N  
ATOM     94  CZ  ARG A  11      11.358  46.218  44.315  1.00 87.06           C  
ATOM     95  NH1 ARG A  11      11.380  45.491  43.205  1.00 87.08           N  
ATOM     96  NH2 ARG A  11      11.817  47.469  44.306  1.00 77.78           N  
ATOM     97  N   VAL A  12       7.147  43.292  49.307  1.00 74.58           N  
ATOM     98  CA  VAL A  12       6.159  43.337  50.391  1.00 72.35           C  
ATOM     99  C   VAL A  12       6.646  42.581  51.625  1.00 76.79           C  
ATOM    100  O   VAL A  12       6.627  43.113  52.733  1.00 80.09           O  
ATOM    101  CB  VAL A  12       4.808  42.703  49.950  1.00 69.83           C  
ATOM    102  CG1 VAL A  12       3.794  42.743  51.095  1.00 60.44           C  
ATOM    103  CG2 VAL A  12       4.278  43.422  48.732  1.00 57.70           C  
ATOM    104  N   LYS A  13       7.073  41.335  51.438  1.00 76.76           N  
ATOM    105  CA  LYS A  13       7.541  40.546  52.563  1.00 76.36           C  
ATOM    106  C   LYS A  13       8.711  41.214  53.272  1.00 76.22           C  
ATOM    107  O   LYS A  13       8.930  40.973  54.455  1.00 74.66           O  
ATOM    108  CB  LYS A  13       7.908  39.133  52.103  1.00 73.30           C  
ATOM    109  CG  LYS A  13       6.684  38.325  51.688  1.00 73.48           C  
ATOM    110  CD  LYS A  13       6.933  36.813  51.590  1.00 75.39           C  
ATOM    111  CE  LYS A  13       5.617  36.092  51.253  1.00 80.38           C  
ATOM    112  NZ  LYS A  13       5.678  34.610  51.105  1.00 67.32           N  
ATOM    113  N   GLU A  14       9.437  42.074  52.557  1.00 76.93           N  
ATOM    114  CA  GLU A  14      10.581  42.783  53.128  1.00 80.79           C  
ATOM    115  C   GLU A  14      10.277  44.260  53.424  1.00 81.93           C  
ATOM    116  O   GLU A  14      10.888  45.161  52.855  1.00 86.51           O  
ATOM    117  CB  GLU A  14      11.808  42.664  52.199  1.00 83.93           C  
ATOM    118  CG  GLU A  14      11.568  43.098  50.747  1.00 97.23           C  
ATOM    119  CD  GLU A  14      12.762  42.840  49.816  1.00101.75           C  
ATOM    120  OE1 GLU A  14      13.228  41.680  49.731  1.00101.61           O  
ATOM    121  OE2 GLU A  14      13.222  43.799  49.152  1.00100.06           O  
ATOM    122  N   ALA A  15       9.322  44.491  54.320  1.00 80.80           N  
ATOM    123  CA  ALA A  15       8.916  45.831  54.743  1.00 78.59           C  
ATOM    124  C   ALA A  15       7.909  45.604  55.869  1.00 85.10           C  
ATOM    125  O   ALA A  15       6.909  44.900  55.686  1.00 85.67           O  
ATOM    126  CB  ALA A  15       8.275  46.586  53.587  1.00 70.68           C  
ATOM    127  N   GLU A  16       8.178  46.175  57.038  1.00 93.23           N  
ATOM    128  CA  GLU A  16       7.298  45.976  58.192  1.00 96.92           C  
ATOM    129  C   GLU A  16       6.023  46.796  58.066  1.00 93.30           C  
ATOM    130  O   GLU A  16       5.029  46.540  58.749  1.00 89.24           O  
ATOM    131  CB  GLU A  16       8.046  46.325  59.493  1.00105.00           C  
ATOM    132  CG  GLU A  16       9.355  45.527  59.711  1.00116.38           C  
ATOM    133  CD  GLU A  16       9.142  44.005  59.780  1.00121.93           C  
ATOM    134  OE1 GLU A  16      10.147  43.250  59.730  1.00114.77           O  
ATOM    135  OE2 GLU A  16       7.972  43.568  59.892  1.00126.11           O  
ATOM    136  N   THR A  17       6.057  47.774  57.167  1.00 91.73           N  
ATOM    137  CA  THR A  17       4.909  48.633  56.943  1.00 88.43           C  
ATOM    138  C   THR A  17       4.845  49.152  55.510  1.00 83.22           C  
ATOM    139  O   THR A  17       5.834  49.648  54.965  1.00 78.02           O  
ATOM    140  CB  THR A  17       4.929  49.814  57.922  1.00 92.13           C  
ATOM    141  OG1 THR A  17       4.872  49.315  59.263  1.00 95.00           O  
ATOM    142  CG2 THR A  17       3.743  50.722  57.688  1.00 95.37           C  
ATOM    143  N   ILE A  18       3.669  49.006  54.906  1.00 80.75           N  
ATOM    144  CA  ILE A  18       3.417  49.455  53.540  1.00 75.49           C  
ATOM    145  C   ILE A  18       2.090  50.204  53.486  1.00 71.58           C  
ATOM    146  O   ILE A  18       1.112  49.806  54.125  1.00 66.96           O  
ATOM    147  CB  ILE A  18       3.351  48.263  52.525  1.00 78.94           C  
ATOM    148  CG1 ILE A  18       2.244  47.264  52.923  1.00 75.65           C  
ATOM    149  CG2 ILE A  18       4.709  47.599  52.409  1.00 78.39           C  
ATOM    150  CD1 ILE A  18       2.492  46.458  54.190  1.00 59.58           C  
ATOM    151  N   ILE A  19       2.063  51.294  52.730  1.00 70.83           N  
ATOM    152  CA  ILE A  19       0.850  52.086  52.588  1.00 75.22           C  
ATOM    153  C   ILE A  19       0.381  52.111  51.132  1.00 77.84           C  
ATOM    154  O   ILE A  19       1.189  52.118  50.199  1.00 77.00           O  
ATOM    155  CB  ILE A  19       1.063  53.523  53.119  1.00 76.55           C  
ATOM    156  CG1 ILE A  19       2.270  54.182  52.446  1.00 76.77           C  
ATOM    157  CG2 ILE A  19       1.252  53.482  54.622  1.00 67.64           C  
ATOM    158  CD1 ILE A  19       1.969  54.784  51.092  1.00 80.53           C  
ATOM    159  N   ILE A  20      -0.932  52.124  50.944  1.00 74.11           N  
ATOM    160  CA  ILE A  20      -1.504  52.112  49.607  1.00 70.93           C  
ATOM    161  C   ILE A  20      -2.232  53.409  49.252  1.00 71.56           C  
ATOM    162  O   ILE A  20      -2.917  54.001  50.088  1.00 67.70           O  
ATOM    163  CB  ILE A  20      -2.494  50.955  49.468  1.00 75.30           C  
ATOM    164  CG1 ILE A  20      -1.959  49.717  50.207  1.00 69.24           C  
ATOM    165  CG2 ILE A  20      -2.742  50.680  47.995  1.00 80.59           C  
ATOM    166  CD1 ILE A  20      -3.015  48.638  50.510  1.00 44.84           C  
ATOM    167  N   HIS A  21      -2.093  53.823  47.994  1.00 70.70           N  
ATOM    168  CA  HIS A  21      -2.713  55.044  47.487  1.00 75.04           C  
ATOM    169  C   HIS A  21      -3.607  54.775  46.285  1.00 81.34           C  
ATOM    170  O   HIS A  21      -3.623  53.673  45.744  1.00 86.97           O  
ATOM    171  CB  HIS A  21      -1.637  56.045  47.075  1.00 75.80           C  
ATOM    172  CG  HIS A  21      -0.950  56.699  48.230  1.00 81.20           C  
ATOM    173  ND1 HIS A  21       0.103  57.573  48.073  1.00 80.64           N  
ATOM    174  CD2 HIS A  21      -1.189  56.630  49.561  1.00 87.15           C  
ATOM    175  CE1 HIS A  21       0.481  58.017  49.258  1.00 81.10           C  
ATOM    176  NE2 HIS A  21      -0.285  57.461  50.178  1.00 83.55           N  
ATOM    177  N   ARG A  22      -4.337  55.799  45.856  1.00 81.37           N  
ATOM    178  CA  ARG A  22      -5.228  55.682  44.704  1.00 76.46           C  
ATOM    179  C   ARG A  22      -5.387  57.058  44.100  1.00 77.76           C  
ATOM    180  O   ARG A  22      -4.998  58.049  44.705  1.00 87.76           O  
ATOM    181  CB  ARG A  22      -6.577  55.171  45.155  1.00 68.47           C  
ATOM    182  CG  ARG A  22      -7.035  55.876  46.373  1.00 59.97           C  
ATOM    183  CD  ARG A  22      -8.409  55.455  46.740  1.00 62.85           C  
ATOM    184  NE  ARG A  22      -8.941  56.351  47.752  1.00 63.13           N  
ATOM    185  CZ  ARG A  22      -9.060  57.667  47.596  1.00 64.97           C  
ATOM    186  NH1 ARG A  22      -9.557  58.395  48.587  1.00 65.46           N  
ATOM    187  NH2 ARG A  22      -8.687  58.254  46.458  1.00 41.83           N  
ATOM    188  N   HIS A  23      -5.968  57.136  42.916  1.00 77.71           N  
ATOM    189  CA  HIS A  23      -6.120  58.436  42.300  1.00 87.00           C  
ATOM    190  C   HIS A  23      -7.066  59.354  43.076  1.00 88.14           C  
ATOM    191  O   HIS A  23      -7.782  58.910  43.973  1.00 81.29           O  
ATOM    192  CB  HIS A  23      -6.570  58.285  40.842  1.00 95.77           C  
ATOM    193  CG  HIS A  23      -7.770  57.414  40.656  1.00 94.22           C  
ATOM    194  ND1 HIS A  23      -9.004  57.724  41.184  1.00 94.89           N  
ATOM    195  CD2 HIS A  23      -7.934  56.258  39.967  1.00 94.58           C  
ATOM    196  CE1 HIS A  23      -9.877  56.799  40.828  1.00 97.53           C  
ATOM    197  NE2 HIS A  23      -9.253  55.898  40.089  1.00 93.56           N  
ATOM    198  N   VAL A  24      -7.028  60.640  42.737  1.00 94.15           N  
ATOM    199  CA  VAL A  24      -7.858  61.659  43.373  1.00 98.67           C  
ATOM    200  C   VAL A  24      -9.334  61.287  43.425  1.00105.20           C  
ATOM    201  O   VAL A  24      -9.735  60.534  44.309  1.00118.47           O  
ATOM    202  CB  VAL A  24      -7.701  62.997  42.657  1.00101.85           C  
ATOM    203  CG1 VAL A  24      -6.443  63.696  43.142  1.00102.64           C  
ATOM    204  CG2 VAL A  24      -7.627  62.761  41.148  1.00104.16           C  
ATOM    205  N   ARG A  25     -10.148  61.811  42.506  1.00101.84           N  
ATOM    206  CA  ARG A  25     -11.579  61.476  42.494  1.00 97.43           C  
ATOM    207  C   ARG A  25     -11.706  59.955  42.554  1.00 93.40           C  
ATOM    208  O   ARG A  25     -11.481  59.268  41.557  1.00 93.34           O  
ATOM    209  CB  ARG A  25     -12.266  61.976  41.217  1.00103.98           C  
ATOM    210  CG  ARG A  25     -12.573  63.472  41.153  1.00108.39           C  
ATOM    211  CD  ARG A  25     -11.416  64.291  40.584  1.00115.25           C  
ATOM    212  NE  ARG A  25     -11.868  65.603  40.113  1.00116.93           N  
ATOM    213  CZ  ARG A  25     -11.088  66.517  39.535  1.00119.82           C  
ATOM    214  NH1 ARG A  25      -9.791  66.279  39.346  1.00111.40           N  
ATOM    215  NH2 ARG A  25     -11.612  67.671  39.140  1.00114.97           N  
ATOM    216  N   PRO A  26     -12.082  59.414  43.725  1.00 87.24           N  
ATOM    217  CA  PRO A  26     -12.228  57.968  43.911  1.00 81.35           C  
ATOM    218  C   PRO A  26     -13.467  57.348  43.260  1.00 79.88           C  
ATOM    219  O   PRO A  26     -14.487  58.011  43.071  1.00 83.14           O  
ATOM    220  CB  PRO A  26     -12.248  57.832  45.426  1.00 73.46           C  
ATOM    221  CG  PRO A  26     -13.038  59.033  45.823  1.00 81.94           C  
ATOM    222  CD  PRO A  26     -12.470  60.140  44.951  1.00 81.00           C  
ATOM    223  N   ASP A  27     -13.359  56.072  42.907  1.00 73.62           N  
ATOM    224  CA  ASP A  27     -14.463  55.340  42.314  1.00 67.12           C  
ATOM    225  C   ASP A  27     -14.521  53.994  43.024  1.00 65.39           C  
ATOM    226  O   ASP A  27     -13.589  53.622  43.728  1.00 64.43           O  
ATOM    227  CB  ASP A  27     -14.247  55.160  40.804  1.00 67.53           C  
ATOM    228  CG  ASP A  27     -12.979  54.403  40.472  1.00 75.45           C  
ATOM    229  OD1 ASP A  27     -12.028  55.018  39.936  1.00 74.11           O  
ATOM    230  OD2 ASP A  27     -12.931  53.186  40.739  1.00 80.40           O  
ATOM    231  N   PRO A  28     -15.622  53.253  42.871  1.00 62.98           N  
ATOM    232  CA  PRO A  28     -15.703  51.955  43.546  1.00 61.89           C  
ATOM    233  C   PRO A  28     -14.470  51.047  43.371  1.00 56.77           C  
ATOM    234  O   PRO A  28     -14.044  50.408  44.330  1.00 57.28           O  
ATOM    235  CB  PRO A  28     -16.988  51.350  42.973  1.00 63.99           C  
ATOM    236  CG  PRO A  28     -17.133  52.038  41.646  1.00 66.06           C  
ATOM    237  CD  PRO A  28     -16.773  53.451  41.980  1.00 55.15           C  
ATOM    238  N   ASP A  29     -13.898  50.999  42.167  1.00 57.16           N  
ATOM    239  CA  ASP A  29     -12.708  50.173  41.897  1.00 56.46           C  
ATOM    240  C   ASP A  29     -11.510  50.705  42.681  1.00 59.34           C  
ATOM    241  O   ASP A  29     -10.884  49.979  43.459  1.00 59.77           O  
ATOM    242  CB  ASP A  29     -12.355  50.192  40.404  1.00 54.82           C  
ATOM    243  CG  ASP A  29     -11.257  49.198  40.043  1.00 50.47           C  
ATOM    244  OD1 ASP A  29     -10.415  49.522  39.180  1.00 41.38           O  
ATOM    245  OD2 ASP A  29     -11.248  48.087  40.610  1.00 44.74           O  
ATOM    246  N   ALA A  30     -11.185  51.975  42.450  1.00 55.71           N  
ATOM    247  CA  ALA A  30     -10.078  52.612  43.144  1.00 57.23           C  
ATOM    248  C   ALA A  30     -10.255  52.389  44.638  1.00 55.04           C  
ATOM    249  O   ALA A  30      -9.292  52.382  45.385  1.00 60.74           O  
ATOM    250  CB  ALA A  30     -10.048  54.094  42.842  1.00 45.15           C  
ATOM    251  N   TYR A  31     -11.492  52.198  45.073  1.00 53.14           N  
ATOM    252  CA  TYR A  31     -11.741  51.975  46.479  1.00 49.41           C  
ATOM    253  C   TYR A  31     -11.530  50.519  46.825  1.00 46.35           C  
ATOM    254  O   TYR A  31     -10.760  50.189  47.718  1.00 50.45           O  
ATOM    255  CB  TYR A  31     -13.159  52.386  46.840  1.00 51.36           C  
ATOM    256  CG  TYR A  31     -13.209  53.455  47.894  1.00 59.73           C  
ATOM    257  CD1 TYR A  31     -13.796  53.211  49.128  1.00 61.01           C  
ATOM    258  CD2 TYR A  31     -12.681  54.725  47.652  1.00 66.70           C  
ATOM    259  CE1 TYR A  31     -13.864  54.209  50.095  1.00 71.89           C  
ATOM    260  CE2 TYR A  31     -12.741  55.732  48.614  1.00 63.76           C  
ATOM    261  CZ  TYR A  31     -13.336  55.467  49.830  1.00 66.21           C  
ATOM    262  OH  TYR A  31     -13.423  56.449  50.787  1.00 64.58           O  
ATOM    263  N   GLY A  32     -12.216  49.647  46.104  1.00 47.31           N  
ATOM    264  CA  GLY A  32     -12.094  48.227  46.356  1.00 49.38           C  
ATOM    265  C   GLY A  32     -10.681  47.726  46.156  1.00 50.71           C  
ATOM    266  O   GLY A  32     -10.194  46.920  46.950  1.00 48.49           O  
ATOM    267  N   SER A  33     -10.019  48.197  45.101  1.00 46.84           N  
ATOM    268  CA  SER A  33      -8.659  47.756  44.828  1.00 51.13           C  
ATOM    269  C   SER A  33      -7.712  48.153  45.965  1.00 55.69           C  
ATOM    270  O   SER A  33      -6.834  47.377  46.347  1.00 52.32           O  
ATOM    271  CB  SER A  33      -8.157  48.303  43.481  1.00 44.25           C  
ATOM    272  OG  SER A  33      -8.294  49.704  43.382  1.00 41.66           O  
ATOM    273  N   GLN A  34      -7.897  49.345  46.525  1.00 52.80           N  
ATOM    274  CA  GLN A  34      -7.047  49.785  47.618  1.00 49.28           C  
ATOM    275  C   GLN A  34      -7.382  48.970  48.858  1.00 51.52           C  
ATOM    276  O   GLN A  34      -6.589  48.138  49.296  1.00 50.05           O  
ATOM    277  CB  GLN A  34      -7.262  51.268  47.887  1.00 57.71           C  
ATOM    278  CG  GLN A  34      -6.436  51.840  49.026  1.00 69.10           C  
ATOM    279  CD  GLN A  34      -6.763  53.312  49.303  1.00 75.68           C  
ATOM    280  OE1 GLN A  34      -7.905  53.656  49.640  1.00 70.86           O  
ATOM    281  NE2 GLN A  34      -5.760  54.184  49.161  1.00 72.03           N  
ATOM    282  N   LEU A  35      -8.565  49.194  49.420  1.00 54.85           N  
ATOM    283  CA  LEU A  35      -8.985  48.462  50.617  1.00 54.38           C  
ATOM    284  C   LEU A  35      -8.797  46.961  50.463  1.00 54.51           C  
ATOM    285  O   LEU A  35      -8.513  46.268  51.435  1.00 52.97           O  
ATOM    286  CB  LEU A  35     -10.445  48.771  50.929  1.00 46.86           C  
ATOM    287  CG  LEU A  35     -10.646  50.226  51.321  1.00 46.67           C  
ATOM    288  CD1 LEU A  35     -12.114  50.593  51.264  1.00 51.85           C  
ATOM    289  CD2 LEU A  35     -10.077  50.443  52.705  1.00 53.87           C  
ATOM    290  N   GLY A  36      -8.952  46.470  49.235  1.00 55.57           N  
ATOM    291  CA  GLY A  36      -8.790  45.052  48.970  1.00 51.80           C  
ATOM    292  C   GLY A  36      -7.361  44.581  49.173  1.00 51.67           C  
ATOM    293  O   GLY A  36      -7.114  43.643  49.934  1.00 49.17           O  
ATOM    294  N   LEU A  37      -6.415  45.222  48.492  1.00 45.15           N  
ATOM    295  CA  LEU A  37      -5.015  44.850  48.628  1.00 43.42           C  
ATOM    296  C   LEU A  37      -4.692  44.888  50.108  1.00 45.94           C  
ATOM    297  O   LEU A  37      -4.101  43.956  50.632  1.00 50.56           O  
ATOM    298  CB  LEU A  37      -4.115  45.835  47.885  1.00 42.84           C  
ATOM    299  CG  LEU A  37      -2.745  45.320  47.429  1.00 40.65           C  
ATOM    300  CD1 LEU A  37      -1.916  46.501  46.936  1.00 35.88           C  
ATOM    301  CD2 LEU A  37      -2.021  44.610  48.559  1.00 31.50           C  
ATOM    302  N   LYS A  38      -5.100  45.969  50.770  1.00 47.36           N  
ATOM    303  CA  LYS A  38      -4.882  46.151  52.204  1.00 48.26           C  
ATOM    304  C   LYS A  38      -5.447  44.998  53.038  1.00 45.52           C  
ATOM    305  O   LYS A  38      -4.701  44.283  53.708  1.00 46.22           O  
ATOM    306  CB  LYS A  38      -5.511  47.471  52.662  1.00 49.31           C  
ATOM    307  CG  LYS A  38      -5.497  47.671  54.169  1.00 51.33           C  
ATOM    308  CD  LYS A  38      -5.865  49.093  54.557  1.00 57.88           C  
ATOM    309  CE  LYS A  38      -6.075  49.216  56.056  1.00 65.07           C  
ATOM    310  NZ  LYS A  38      -7.235  48.395  56.507  1.00 71.97           N  
ATOM    311  N   LEU A  39      -6.766  44.835  52.999  1.00 43.91           N  
ATOM    312  CA  LEU A  39      -7.460  43.774  53.733  1.00 45.17           C  
ATOM    313  C   LEU A  39      -6.812  42.420  53.512  1.00 43.52           C  
ATOM    314  O   LEU A  39      -6.781  41.589  54.415  1.00 37.67           O  
ATOM    315  CB  LEU A  39      -8.928  43.712  53.298  1.00 52.38           C  
ATOM    316  CG  LEU A  39      -9.938  44.688  53.919  1.00 43.81           C  
ATOM    317  CD1 LEU A  39     -10.447  44.119  55.228  1.00 50.64           C  
ATOM    318  CD2 LEU A  39      -9.303  46.051  54.124  1.00 54.48           C  
ATOM    319  N   TYR A  40      -6.312  42.209  52.298  1.00 46.69           N  
ATOM    320  CA  TYR A  40      -5.624  40.970  51.922  1.00 46.29           C  
ATOM    321  C   TYR A  40      -4.320  40.855  52.685  1.00 44.83           C  
ATOM    322  O   TYR A  40      -4.097  39.875  53.386  1.00 37.99           O  
ATOM    323  CB  TYR A  40      -5.318  40.958  50.420  1.00 49.64           C  
ATOM    324  CG  TYR A  40      -4.295  39.921  49.966  1.00 50.24           C  
ATOM    325  CD1 TYR A  40      -4.407  38.577  50.338  1.00 43.85           C  
ATOM    326  CD2 TYR A  40      -3.254  40.279  49.098  1.00 49.03           C  
ATOM    327  CE1 TYR A  40      -3.513  37.611  49.852  1.00 36.39           C  
ATOM    328  CE2 TYR A  40      -2.357  39.323  48.606  1.00 42.72           C  
ATOM    329  CZ  TYR A  40      -2.496  37.988  48.986  1.00 49.91           C  
ATOM    330  OH  TYR A  40      -1.629  37.036  48.472  1.00 51.35           O  
ATOM    331  N   LEU A  41      -3.459  41.859  52.532  1.00 49.25           N  
ATOM    332  CA  LEU A  41      -2.169  41.870  53.207  1.00 47.24           C  
ATOM    333  C   LEU A  41      -2.359  41.676  54.698  1.00 53.07           C  
ATOM    334  O   LEU A  41      -1.778  40.758  55.280  1.00 52.77           O  
ATOM    335  CB  LEU A  41      -1.418  43.171  52.907  1.00 25.07           C  
ATOM    336  CG  LEU A  41      -1.074  43.352  51.415  1.00 34.66           C  
ATOM    337  CD1 LEU A  41       0.341  43.893  51.238  1.00 22.47           C  
ATOM    338  CD2 LEU A  41      -1.190  42.028  50.681  1.00 28.79           C  
ATOM    339  N   GLU A  42      -3.189  42.522  55.308  1.00 56.23           N  
ATOM    340  CA  GLU A  42      -3.477  42.422  56.738  1.00 64.96           C  
ATOM    341  C   GLU A  42      -3.858  40.995  57.157  1.00 64.26           C  
ATOM    342  O   GLU A  42      -3.746  40.633  58.324  1.00 60.34           O  
ATOM    343  CB  GLU A  42      -4.599  43.399  57.130  1.00 66.88           C  
ATOM    344  CG  GLU A  42      -4.135  44.856  57.232  1.00 71.60           C  
ATOM    345  CD  GLU A  42      -5.119  45.771  57.964  1.00 69.06           C  
ATOM    346  OE1 GLU A  42      -4.805  46.970  58.137  1.00 65.02           O  
ATOM    347  OE2 GLU A  42      -6.202  45.295  58.367  1.00 69.48           O  
ATOM    348  N   ARG A  43      -4.299  40.184  56.203  1.00 64.79           N  
ATOM    349  CA  ARG A  43      -4.676  38.810  56.505  1.00 64.96           C  
ATOM    350  C   ARG A  43      -3.466  37.894  56.357  1.00 68.80           C  
ATOM    351  O   ARG A  43      -3.368  36.868  57.024  1.00 74.67           O  
ATOM    352  CB  ARG A  43      -5.766  38.337  55.551  1.00 60.40           C  
ATOM    353  CG  ARG A  43      -6.749  37.338  56.144  1.00 65.65           C  
ATOM    354  CD  ARG A  43      -7.932  38.076  56.738  1.00 74.08           C  
ATOM    355  NE  ARG A  43      -8.000  39.440  56.198  1.00 81.58           N  
ATOM    356  CZ  ARG A  43      -8.962  40.316  56.472  1.00 77.58           C  
ATOM    357  NH1 ARG A  43      -9.955  39.972  57.286  1.00 78.57           N  
ATOM    358  NH2 ARG A  43      -8.924  41.529  55.936  1.00 65.35           N  
ATOM    359  N   LYS A  44      -2.548  38.274  55.474  1.00 66.49           N  
ATOM    360  CA  LYS A  44      -1.354  37.487  55.210  1.00 65.92           C  
ATOM    361  C   LYS A  44      -0.197  37.780  56.174  1.00 71.61           C  
ATOM    362  O   LYS A  44       0.433  36.852  56.671  1.00 74.45           O  
ATOM    363  CB  LYS A  44      -0.907  37.718  53.762  1.00 66.26           C  
ATOM    364  CG  LYS A  44       0.035  36.655  53.202  1.00 65.91           C  
ATOM    365  CD  LYS A  44       0.471  36.980  51.766  1.00 55.47           C  
ATOM    366  CE  LYS A  44       1.188  35.806  51.141  1.00 54.54           C  
ATOM    367  NZ  LYS A  44       0.380  34.560  51.295  1.00 52.16           N  
ATOM    368  N   PHE A  45       0.086  39.056  56.438  1.00 71.57           N  
ATOM    369  CA  PHE A  45       1.178  39.429  57.349  1.00 70.52           C  
ATOM    370  C   PHE A  45       0.702  40.338  58.489  1.00 72.48           C  
ATOM    371  O   PHE A  45       1.091  41.511  58.555  1.00 65.95           O  
ATOM    372  CB  PHE A  45       2.279  40.158  56.578  1.00 64.01           C  
ATOM    373  CG  PHE A  45       2.571  39.562  55.237  1.00 62.17           C  
ATOM    374  CD1 PHE A  45       2.753  38.194  55.095  1.00 61.20           C  
ATOM    375  CD2 PHE A  45       2.689  40.370  54.115  1.00 67.81           C  
ATOM    376  CE1 PHE A  45       3.044  37.641  53.855  1.00 64.75           C  
ATOM    377  CE2 PHE A  45       2.979  39.827  52.867  1.00 67.68           C  
ATOM    378  CZ  PHE A  45       3.160  38.462  52.740  1.00 64.56           C  
ATOM    379  N   PRO A  46      -0.120  39.804  59.414  1.00 72.79           N  
ATOM    380  CA  PRO A  46      -0.643  40.589  60.542  1.00 76.84           C  
ATOM    381  C   PRO A  46       0.428  41.279  61.383  1.00 81.07           C  
ATOM    382  O   PRO A  46       0.133  42.194  62.155  1.00 79.19           O  
ATOM    383  CB  PRO A  46      -1.448  39.560  61.331  1.00 70.31           C  
ATOM    384  CG  PRO A  46      -0.734  38.281  61.045  1.00 64.57           C  
ATOM    385  CD  PRO A  46      -0.452  38.376  59.575  1.00 64.37           C  
ATOM    386  N   GLU A  47       1.666  40.827  61.213  1.00 86.69           N  
ATOM    387  CA  GLU A  47       2.847  41.350  61.905  1.00 88.20           C  
ATOM    388  C   GLU A  47       3.307  42.688  61.308  1.00 87.08           C  
ATOM    389  O   GLU A  47       4.166  43.371  61.874  1.00 80.05           O  
ATOM    390  CB  GLU A  47       3.996  40.347  61.772  1.00 97.68           C  
ATOM    391  CG  GLU A  47       4.185  39.849  60.320  1.00106.22           C  
ATOM    392  CD  GLU A  47       5.640  39.692  59.886  1.00105.92           C  
ATOM    393  OE1 GLU A  47       5.859  39.293  58.721  1.00103.59           O  
ATOM    394  OE2 GLU A  47       6.556  39.966  60.694  1.00107.90           O  
ATOM    395  N   LYS A  48       2.754  43.043  60.150  1.00 82.77           N  
ATOM    396  CA  LYS A  48       3.122  44.285  59.472  1.00 79.98           C  
ATOM    397  C   LYS A  48       2.047  45.348  59.665  1.00 77.47           C  
ATOM    398  O   LYS A  48       1.005  45.092  60.269  1.00 76.18           O  
ATOM    399  CB  LYS A  48       3.321  44.041  57.967  1.00 83.87           C  
ATOM    400  CG  LYS A  48       4.365  42.988  57.602  1.00 88.96           C  
ATOM    401  CD  LYS A  48       4.504  42.836  56.088  1.00 83.44           C  
ATOM    402  CE  LYS A  48       5.498  41.743  55.703  1.00 81.55           C  
ATOM    403  NZ  LYS A  48       6.903  42.057  56.072  1.00 79.81           N  
ATOM    404  N   ASN A  49       2.303  46.542  59.142  1.00 76.44           N  
ATOM    405  CA  ASN A  49       1.340  47.630  59.249  1.00 76.55           C  
ATOM    406  C   ASN A  49       0.904  48.104  57.868  1.00 78.08           C  
ATOM    407  O   ASN A  49       1.674  48.738  57.149  1.00 78.84           O  
ATOM    408  CB  ASN A  49       1.943  48.793  60.029  1.00 68.96           C  
ATOM    409  CG  ASN A  49       2.391  48.381  61.413  1.00 72.44           C  
ATOM    410  OD1 ASN A  49       1.606  47.844  62.208  1.00 67.00           O  
ATOM    411  ND2 ASN A  49       3.658  48.630  61.715  1.00 74.82           N  
ATOM    412  N   ILE A  50      -0.331  47.783  57.501  1.00 71.80           N  
ATOM    413  CA  ILE A  50      -0.858  48.187  56.209  1.00 66.79           C  
ATOM    414  C   ILE A  50      -1.866  49.314  56.413  1.00 69.32           C  
ATOM    415  O   ILE A  50      -2.762  49.224  57.262  1.00 62.49           O  
ATOM    416  CB  ILE A  50      -1.545  47.010  55.483  1.00 74.45           C  
ATOM    417  CG1 ILE A  50      -0.597  45.814  55.389  1.00 71.78           C  
ATOM    418  CG2 ILE A  50      -1.944  47.423  54.090  1.00 81.32           C  
ATOM    419  CD1 ILE A  50      -0.634  44.917  56.599  1.00 74.75           C  
ATOM    420  N   TYR A  51      -1.698  50.377  55.626  1.00 71.57           N  
ATOM    421  CA  TYR A  51      -2.546  51.568  55.683  1.00 68.41           C  
ATOM    422  C   TYR A  51      -2.993  52.017  54.290  1.00 68.12           C  
ATOM    423  O   TYR A  51      -2.287  51.800  53.305  1.00 64.40           O  
ATOM    424  CB  TYR A  51      -1.768  52.719  56.334  1.00 71.39           C  
ATOM    425  CG  TYR A  51      -1.208  52.409  57.708  1.00 79.08           C  
ATOM    426  CD1 TYR A  51       0.137  52.673  58.015  1.00 75.38           C  
ATOM    427  CD2 TYR A  51      -2.015  51.832  58.698  1.00 77.52           C  
ATOM    428  CE1 TYR A  51       0.666  52.365  59.274  1.00 71.16           C  
ATOM    429  CE2 TYR A  51      -1.499  51.522  59.960  1.00 79.71           C  
ATOM    430  CZ  TYR A  51      -0.159  51.789  60.238  1.00 78.31           C  
ATOM    431  OH  TYR A  51       0.339  51.468  61.475  1.00 73.17           O  
ATOM    432  N   ALA A  52      -4.162  52.650  54.212  1.00 65.99           N  
ATOM    433  CA  ALA A  52      -4.673  53.164  52.939  1.00 62.83           C  
ATOM    434  C   ALA A  52      -5.016  54.643  53.123  1.00 62.55           C  
ATOM    435  O   ALA A  52      -5.938  54.987  53.860  1.00 56.65           O  
ATOM    436  CB  ALA A  52      -5.909  52.380  52.511  1.00 65.98           C  
ATOM    437  N   THR A  53      -4.250  55.515  52.470  1.00 67.05           N  
ATOM    438  CA  THR A  53      -4.467  56.960  52.574  1.00 74.72           C  
ATOM    439  C   THR A  53      -5.375  57.467  51.471  1.00 78.69           C  
ATOM    440  O   THR A  53      -5.335  56.980  50.338  1.00 79.08           O  
ATOM    441  CB  THR A  53      -3.159  57.790  52.446  1.00 71.24           C  
ATOM    442  OG1 THR A  53      -2.153  57.253  53.302  1.00 70.93           O  
ATOM    443  CG2 THR A  53      -3.414  59.250  52.837  1.00 75.81           C  
ATOM    444  N   GLY A  54      -6.167  58.476  51.805  1.00 78.35           N  
ATOM    445  CA  GLY A  54      -7.064  59.050  50.830  1.00 81.42           C  
ATOM    446  C   GLY A  54      -7.861  60.164  51.452  1.00 83.37           C  
ATOM    447  O   GLY A  54      -7.892  60.295  52.674  1.00 80.36           O  
ATOM    448  N   GLU A  55      -8.501  60.964  50.606  1.00 81.83           N  
ATOM    449  CA  GLU A  55      -9.312  62.078  51.063  1.00 82.98           C  
ATOM    450  C   GLU A  55     -10.539  61.526  51.784  1.00 82.50           C  
ATOM    451  O   GLU A  55     -11.006  62.120  52.756  1.00 82.45           O  
ATOM    452  CB  GLU A  55      -9.731  62.942  49.868  1.00 91.77           C  
ATOM    453  CG  GLU A  55      -9.893  64.441  50.172  1.00103.17           C  
ATOM    454  CD  GLU A  55      -8.648  65.062  50.803  1.00111.09           C  
ATOM    455  OE1 GLU A  55      -8.414  64.827  52.013  1.00112.37           O  
ATOM    456  OE2 GLU A  55      -7.899  65.777  50.092  1.00110.73           O  
ATOM    457  N   ALA A  56     -11.041  60.385  51.308  1.00 76.67           N  
ATOM    458  CA  ALA A  56     -12.210  59.718  51.889  1.00 76.48           C  
ATOM    459  C   ALA A  56     -13.541  60.313  51.404  1.00 79.17           C  
ATOM    460  O   ALA A  56     -14.054  61.270  51.984  1.00 79.58           O  
ATOM    461  CB  ALA A  56     -12.144  59.741  53.432  1.00 56.83           C  
ATOM    462  N   GLU A  57     -14.085  59.726  50.336  1.00 84.54           N  
ATOM    463  CA  GLU A  57     -15.358  60.131  49.727  1.00 78.60           C  
ATOM    464  C   GLU A  57     -16.540  59.506  50.484  1.00 74.64           C  
ATOM    465  O   GLU A  57     -16.739  58.295  50.419  1.00 74.62           O  
ATOM    466  CB  GLU A  57     -15.387  59.663  48.270  1.00 76.29           C  
ATOM    467  CG  GLU A  57     -16.758  59.732  47.644  1.00 86.97           C  
ATOM    468  CD  GLU A  57     -17.315  61.130  47.670  1.00 93.29           C  
ATOM    469  OE1 GLU A  57     -18.538  61.309  47.455  1.00 94.71           O  
ATOM    470  OE2 GLU A  57     -16.506  62.054  47.904  1.00 95.09           O  
ATOM    471  N   PRO A  58     -17.361  60.329  51.173  1.00 71.95           N  
ATOM    472  CA  PRO A  58     -18.511  59.824  51.935  1.00 69.10           C  
ATOM    473  C   PRO A  58     -19.467  58.973  51.102  1.00 69.16           C  
ATOM    474  O   PRO A  58     -20.257  58.187  51.637  1.00 69.80           O  
ATOM    475  CB  PRO A  58     -19.160  61.100  52.462  1.00 66.25           C  
ATOM    476  CG  PRO A  58     -18.881  62.086  51.377  1.00 71.88           C  
ATOM    477  CD  PRO A  58     -17.436  61.797  51.039  1.00 74.63           C  
ATOM    478  N   SER A  59     -19.382  59.140  49.787  1.00 66.38           N  
ATOM    479  CA  SER A  59     -20.200  58.395  48.839  1.00 65.76           C  
ATOM    480  C   SER A  59     -19.849  56.896  48.929  1.00 67.67           C  
ATOM    481  O   SER A  59     -20.736  56.039  48.923  1.00 62.39           O  
ATOM    482  CB  SER A  59     -19.945  58.953  47.426  1.00 61.72           C  
ATOM    483  OG  SER A  59     -20.431  58.110  46.401  1.00 62.42           O  
ATOM    484  N   LEU A  60     -18.554  56.597  49.043  1.00 69.09           N  
ATOM    485  CA  LEU A  60     -18.073  55.218  49.137  1.00 62.28           C  
ATOM    486  C   LEU A  60     -17.735  54.815  50.576  1.00 60.24           C  
ATOM    487  O   LEU A  60     -17.046  53.823  50.808  1.00 55.07           O  
ATOM    488  CB  LEU A  60     -16.834  55.015  48.252  1.00 57.38           C  
ATOM    489  CG  LEU A  60     -16.950  55.330  46.755  1.00 56.73           C  
ATOM    490  CD1 LEU A  60     -18.275  54.813  46.194  1.00 52.11           C  
ATOM    491  CD2 LEU A  60     -16.856  56.811  46.558  1.00 50.04           C  
ATOM    492  N   SER A  61     -18.228  55.593  51.533  1.00 60.93           N  
ATOM    493  CA  SER A  61     -18.006  55.334  52.946  1.00 62.66           C  
ATOM    494  C   SER A  61     -18.355  53.883  53.318  1.00 67.62           C  
ATOM    495  O   SER A  61     -17.645  53.237  54.096  1.00 62.43           O  
ATOM    496  CB  SER A  61     -18.845  56.332  53.771  1.00 66.49           C  
ATOM    497  OG  SER A  61     -19.425  55.760  54.947  1.00 67.99           O  
ATOM    498  N   PHE A  62     -19.431  53.363  52.739  1.00 65.48           N  
ATOM    499  CA  PHE A  62     -19.875  52.004  53.034  1.00 65.62           C  
ATOM    500  C   PHE A  62     -18.900  50.906  52.611  1.00 63.92           C  
ATOM    501  O   PHE A  62     -18.917  49.811  53.175  1.00 71.55           O  
ATOM    502  CB  PHE A  62     -21.208  51.736  52.361  1.00 67.85           C  
ATOM    503  CG  PHE A  62     -21.112  51.647  50.879  1.00 64.62           C  
ATOM    504  CD1 PHE A  62     -20.727  52.758  50.130  1.00 65.56           C  
ATOM    505  CD2 PHE A  62     -21.387  50.453  50.229  1.00 59.25           C  
ATOM    506  CE1 PHE A  62     -20.617  52.684  48.748  1.00 67.98           C  
ATOM    507  CE2 PHE A  62     -21.282  50.364  48.851  1.00 65.81           C  
ATOM    508  CZ  PHE A  62     -20.895  51.482  48.103  1.00 69.28           C  
ATOM    509  N   ILE A  63     -18.074  51.183  51.603  1.00 62.18           N  
ATOM    510  CA  ILE A  63     -17.094  50.210  51.108  1.00 56.67           C  
ATOM    511  C   ILE A  63     -16.065  49.940  52.192  1.00 58.83           C  
ATOM    512  O   ILE A  63     -15.714  48.792  52.464  1.00 55.41           O  
ATOM    513  CB  ILE A  63     -16.361  50.745  49.860  1.00 52.55           C  
ATOM    514  CG1 ILE A  63     -17.327  50.803  48.671  1.00 50.97           C  
ATOM    515  CG2 ILE A  63     -15.160  49.877  49.553  1.00 55.64           C  
ATOM    516  CD1 ILE A  63     -16.742  51.429  47.412  1.00 38.76           C  
ATOM    517  N   GLY A  64     -15.589  51.019  52.805  1.00 64.54           N  
ATOM    518  CA  GLY A  64     -14.600  50.919  53.862  1.00 68.23           C  
ATOM    519  C   GLY A  64     -13.967  52.263  54.167  1.00 72.79           C  
ATOM    520  O   GLY A  64     -13.885  53.126  53.295  1.00 79.99           O  
ATOM    521  N   ASP A  65     -13.519  52.447  55.405  1.00 73.58           N  
ATOM    522  CA  ASP A  65     -12.891  53.700  55.820  1.00 74.42           C  
ATOM    523  C   ASP A  65     -11.392  53.685  55.526  1.00 69.02           C  
ATOM    524  O   ASP A  65     -10.805  52.624  55.382  1.00 71.99           O  
ATOM    525  CB  ASP A  65     -13.124  53.896  57.313  1.00 81.50           C  
ATOM    526  CG  ASP A  65     -14.583  53.745  57.690  1.00 93.43           C  
ATOM    527  OD1 ASP A  65     -15.387  54.635  57.321  1.00 95.59           O  
ATOM    528  OD2 ASP A  65     -14.928  52.728  58.341  1.00 92.75           O  
ATOM    529  N   LEU A  66     -10.775  54.856  55.430  1.00 63.71           N  
ATOM    530  CA  LEU A  66      -9.345  54.925  55.167  1.00 63.02           C  
ATOM    531  C   LEU A  66      -8.547  55.090  56.470  1.00 69.21           C  
ATOM    532  O   LEU A  66      -9.124  55.135  57.563  1.00 64.47           O  
ATOM    533  CB  LEU A  66      -9.041  56.088  54.225  1.00 60.83           C  
ATOM    534  CG  LEU A  66      -9.850  56.075  52.932  1.00 66.77           C  
ATOM    535  CD1 LEU A  66      -9.642  57.379  52.174  1.00 71.00           C  
ATOM    536  CD2 LEU A  66      -9.442  54.892  52.088  1.00 70.56           C  
ATOM    537  N   ASP A  67      -7.223  55.174  56.356  1.00 71.99           N  
ATOM    538  CA  ASP A  67      -6.366  55.333  57.525  1.00 68.82           C  
ATOM    539  C   ASP A  67      -5.728  56.705  57.533  1.00 71.83           C  
ATOM    540  O   ASP A  67      -5.444  57.278  56.477  1.00 67.22           O  
ATOM    541  CB  ASP A  67      -5.252  54.286  57.542  1.00 68.63           C  
ATOM    542  CG  ASP A  67      -5.768  52.876  57.731  1.00 76.76           C  
ATOM    543  OD1 ASP A  67      -6.350  52.596  58.806  1.00 66.61           O  
ATOM    544  OD2 ASP A  67      -5.582  52.052  56.801  1.00 75.28           O  
ATOM    545  N   GLU A  68      -5.487  57.216  58.736  1.00 78.99           N  
ATOM    546  CA  GLU A  68      -4.862  58.524  58.914  1.00 82.63           C  
ATOM    547  C   GLU A  68      -3.357  58.340  59.123  1.00 80.23           C  
ATOM    548  O   GLU A  68      -2.888  58.040  60.224  1.00 69.16           O  
ATOM    549  CB  GLU A  68      -5.482  59.241  60.115  1.00 92.34           C  
ATOM    550  CG  GLU A  68      -5.416  60.769  60.047  1.00 98.47           C  
ATOM    551  CD  GLU A  68      -6.233  61.333  58.897  1.00102.68           C  
ATOM    552  OE1 GLU A  68      -7.443  61.020  58.819  1.00101.20           O  
ATOM    553  OE2 GLU A  68      -5.669  62.097  58.078  1.00105.71           O  
ATOM    554  N   ILE A  69      -2.615  58.522  58.040  1.00 79.75           N  
ATOM    555  CA  ILE A  69      -1.167  58.378  58.031  1.00 82.22           C  
ATOM    556  C   ILE A  69      -0.506  59.599  58.674  1.00 84.96           C  
ATOM    557  O   ILE A  69      -0.887  60.737  58.388  1.00 78.03           O  
ATOM    558  CB  ILE A  69      -0.678  58.220  56.572  1.00 87.07           C  
ATOM    559  CG1 ILE A  69       0.848  58.312  56.478  1.00 90.68           C  
ATOM    560  CG2 ILE A  69      -1.360  59.266  55.703  1.00 92.15           C  
ATOM    561  CD1 ILE A  69       1.562  57.002  56.675  1.00 94.22           C  
ATOM    562  N   ASP A  70       0.485  59.350  59.533  1.00 89.08           N  
ATOM    563  CA  ASP A  70       1.206  60.413  60.235  1.00 87.18           C  
ATOM    564  C   ASP A  70       2.419  60.967  59.488  1.00 84.39           C  
ATOM    565  O   ASP A  70       3.331  61.518  60.104  1.00 82.48           O  
ATOM    566  CB  ASP A  70       1.649  59.939  61.623  1.00 91.47           C  
ATOM    567  CG  ASP A  70       0.482  59.480  62.491  1.00 96.73           C  
ATOM    568  OD1 ASP A  70       0.154  58.268  62.448  1.00 91.95           O  
ATOM    569  OD2 ASP A  70      -0.106  60.332  63.209  1.00 89.31           O  
ATOM    570  N   ASP A  71       2.422  60.801  58.170  1.00 84.49           N  
ATOM    571  CA  ASP A  71       3.473  61.311  57.288  1.00 86.89           C  
ATOM    572  C   ASP A  71       4.925  60.968  57.662  1.00 80.88           C  
ATOM    573  O   ASP A  71       5.846  61.093  56.845  1.00 69.21           O  
ATOM    574  CB  ASP A  71       3.229  62.835  57.105  1.00 89.27           C  
ATOM    575  CG  ASP A  71       4.441  63.701  57.417  1.00 92.54           C  
ATOM    576  OD1 ASP A  71       4.887  63.727  58.586  1.00102.89           O  
ATOM    577  OD2 ASP A  71       4.929  64.388  56.488  1.00 86.87           O  
ATOM    578  N   SER A  72       5.110  60.487  58.882  1.00 81.52           N  
ATOM    579  CA  SER A  72       6.429  60.111  59.367  1.00 84.45           C  
ATOM    580  C   SER A  72       6.583  58.594  59.322  1.00 83.09           C  
ATOM    581  O   SER A  72       7.642  58.055  59.651  1.00 77.68           O  
ATOM    582  CB  SER A  72       6.611  60.593  60.800  1.00 89.71           C  
ATOM    583  OG  SER A  72       5.692  59.929  61.652  1.00 94.38           O  
ATOM    584  N   VAL A  73       5.514  57.904  58.930  1.00 81.53           N  
ATOM    585  CA  VAL A  73       5.560  56.449  58.834  1.00 76.72           C  
ATOM    586  C   VAL A  73       6.175  56.116  57.467  1.00 77.05           C  
ATOM    587  O   VAL A  73       6.696  55.020  57.243  1.00 74.05           O  
ATOM    588  CB  VAL A  73       4.138  55.820  58.995  1.00 69.87           C  
ATOM    589  CG1 VAL A  73       4.232  54.501  59.779  1.00 58.11           C  
ATOM    590  CG2 VAL A  73       3.217  56.786  59.726  1.00 64.40           C  
ATOM    591  N   TYR A  74       6.129  57.092  56.564  1.00 78.82           N  
ATOM    592  CA  TYR A  74       6.706  56.946  55.228  1.00 87.89           C  
ATOM    593  C   TYR A  74       8.222  56.751  55.275  1.00 97.18           C  
ATOM    594  O   TYR A  74       8.860  56.502  54.239  1.00 95.35           O  
ATOM    595  CB  TYR A  74       6.427  58.185  54.394  1.00 83.05           C  
ATOM    596  CG  TYR A  74       5.074  58.184  53.734  1.00 92.58           C  
ATOM    597  CD1 TYR A  74       3.913  58.495  54.453  1.00 89.80           C  
ATOM    598  CD2 TYR A  74       4.954  57.898  52.368  1.00 94.28           C  
ATOM    599  CE1 TYR A  74       2.670  58.527  53.816  1.00 83.47           C  
ATOM    600  CE2 TYR A  74       3.723  57.922  51.729  1.00 86.37           C  
ATOM    601  CZ  TYR A  74       2.594  58.243  52.454  1.00 84.55           C  
ATOM    602  OH  TYR A  74       1.402  58.311  51.793  1.00 82.74           O  
ATOM    603  N   SER A  75       8.781  56.888  56.478  1.00102.35           N  
ATOM    604  CA  SER A  75      10.215  56.760  56.730  1.00100.79           C  
ATOM    605  C   SER A  75      10.808  55.550  56.010  1.00102.83           C  
ATOM    606  O   SER A  75      11.521  55.676  55.004  1.00 96.20           O  
ATOM    607  CB  SER A  75      10.455  56.646  58.244  1.00 96.01           C  
ATOM    608  OG  SER A  75      11.818  56.891  58.581  1.00101.30           O  
ATOM    609  N   ASP A  76      10.513  54.367  56.528  1.00105.49           N  
ATOM    610  CA  ASP A  76      11.027  53.158  55.917  1.00108.74           C  
ATOM    611  C   ASP A  76       9.856  52.243  55.620  1.00108.85           C  
ATOM    612  O   ASP A  76       9.618  51.258  56.325  1.00108.26           O  
ATOM    613  CB  ASP A  76      12.027  52.479  56.851  1.00107.47           C  
ATOM    614  CG  ASP A  76      13.309  52.109  56.144  1.00105.20           C  
ATOM    615  OD1 ASP A  76      14.236  51.619  56.818  1.00 99.74           O  
ATOM    616  OD2 ASP A  76      13.380  52.313  54.908  1.00105.50           O  
ATOM    617  N   ALA A  77       9.123  52.593  54.566  1.00105.28           N  
ATOM    618  CA  ALA A  77       7.954  51.834  54.158  1.00 96.58           C  
ATOM    619  C   ALA A  77       7.815  51.770  52.650  1.00 91.92           C  
ATOM    620  O   ALA A  77       8.372  52.600  51.926  1.00 89.66           O  
ATOM    621  CB  ALA A  77       6.696  52.445  54.770  1.00 90.43           C  
ATOM    622  N   LEU A  78       7.058  50.772  52.195  1.00 86.87           N  
ATOM    623  CA  LEU A  78       6.802  50.553  50.775  1.00 75.91           C  
ATOM    624  C   LEU A  78       5.478  51.204  50.398  1.00 74.26           C  
ATOM    625  O   LEU A  78       4.453  50.972  51.040  1.00 69.13           O  
ATOM    626  CB  LEU A  78       6.739  49.051  50.479  1.00 67.67           C  
ATOM    627  CG  LEU A  78       6.494  48.634  49.031  1.00 68.02           C  
ATOM    628  CD1 LEU A  78       7.641  49.108  48.168  1.00 62.77           C  
ATOM    629  CD2 LEU A  78       6.349  47.122  48.945  1.00 64.95           C  
ATOM    630  N   VAL A  79       5.515  52.026  49.354  1.00 72.30           N  
ATOM    631  CA  VAL A  79       4.330  52.720  48.872  1.00 71.68           C  
ATOM    632  C   VAL A  79       3.789  52.032  47.617  1.00 73.78           C  
ATOM    633  O   VAL A  79       4.537  51.791  46.662  1.00 70.59           O  
ATOM    634  CB  VAL A  79       4.658  54.197  48.537  1.00 75.61           C  
ATOM    635  CG1 VAL A  79       3.424  54.911  48.020  1.00 75.04           C  
ATOM    636  CG2 VAL A  79       5.194  54.899  49.768  1.00 77.89           C  
ATOM    637  N   ILE A  80       2.490  51.719  47.636  1.00 69.81           N  
ATOM    638  CA  ILE A  80       1.801  51.059  46.520  1.00 63.55           C  
ATOM    639  C   ILE A  80       0.665  51.940  45.987  1.00 61.67           C  
ATOM    640  O   ILE A  80      -0.416  51.980  46.579  1.00 54.17           O  
ATOM    641  CB  ILE A  80       1.172  49.716  46.960  1.00 61.97           C  
ATOM    642  CG1 ILE A  80       2.122  48.955  47.876  1.00 60.39           C  
ATOM    643  CG2 ILE A  80       0.874  48.852  45.743  1.00 44.62           C  
ATOM    644  CD1 ILE A  80       1.502  47.689  48.444  1.00 52.01           C  
ATOM    645  N   VAL A  81       0.923  52.645  44.883  1.00 62.93           N  
ATOM    646  CA  VAL A  81      -0.077  53.509  44.255  1.00 74.00           C  
ATOM    647  C   VAL A  81      -0.979  52.651  43.392  1.00 76.62           C  
ATOM    648  O   VAL A  81      -0.724  52.393  42.207  1.00 76.47           O  
ATOM    649  CB  VAL A  81       0.548  54.593  43.356  1.00 81.61           C  
ATOM    650  CG1 VAL A  81      -0.556  55.381  42.629  1.00 80.11           C  
ATOM    651  CG2 VAL A  81       1.389  55.524  44.198  1.00 84.12           C  
ATOM    652  N   CYS A  82      -2.056  52.221  44.019  1.00 75.85           N  
ATOM    653  CA  CYS A  82      -3.034  51.362  43.397  1.00 73.43           C  
ATOM    654  C   CYS A  82      -4.009  52.137  42.496  1.00 72.83           C  
ATOM    655  O   CYS A  82      -4.571  53.147  42.907  1.00 76.67           O  
ATOM    656  CB  CYS A  82      -3.760  50.639  44.527  1.00 68.98           C  
ATOM    657  SG  CYS A  82      -4.907  49.414  44.018  1.00 72.61           S  
ATOM    658  N   ASP A  83      -4.184  51.671  41.262  1.00 71.91           N  
ATOM    659  CA  ASP A  83      -5.113  52.285  40.296  1.00 76.20           C  
ATOM    660  C   ASP A  83      -4.990  53.795  40.097  1.00 72.90           C  
ATOM    661  O   ASP A  83      -5.710  54.574  40.717  1.00 79.04           O  
ATOM    662  CB  ASP A  83      -6.570  51.946  40.682  1.00 78.89           C  
ATOM    663  CG  ASP A  83      -7.603  52.514  39.699  1.00 77.14           C  
ATOM    664  OD1 ASP A  83      -7.217  52.933  38.580  1.00 74.63           O  
ATOM    665  OD2 ASP A  83      -8.805  52.524  40.053  1.00 74.50           O  
ATOM    666  N   THR A  84      -4.096  54.206  39.211  1.00 67.61           N  
ATOM    667  CA  THR A  84      -3.910  55.623  38.952  1.00 63.31           C  
ATOM    668  C   THR A  84      -3.097  55.821  37.679  1.00 63.46           C  
ATOM    669  O   THR A  84      -1.905  55.492  37.619  1.00 60.08           O  
ATOM    670  CB  THR A  84      -3.189  56.332  40.136  1.00 65.60           C  
ATOM    671  OG1 THR A  84      -4.048  56.361  41.287  1.00 63.22           O  
ATOM    672  CG2 THR A  84      -2.811  57.763  39.753  1.00 61.10           C  
ATOM    673  N   ALA A  85      -3.766  56.357  36.662  1.00 68.88           N  
ATOM    674  CA  ALA A  85      -3.150  56.624  35.371  1.00 73.43           C  
ATOM    675  C   ALA A  85      -1.834  57.392  35.548  1.00 75.38           C  
ATOM    676  O   ALA A  85      -0.743  56.827  35.429  1.00 65.70           O  
ATOM    677  CB  ALA A  85      -4.124  57.427  34.503  1.00 69.36           C  
ATOM    678  N   ASN A  86      -1.956  58.682  35.843  1.00 81.28           N  
ATOM    679  CA  ASN A  86      -0.789  59.533  36.031  1.00 83.24           C  
ATOM    680  C   ASN A  86      -0.535  59.868  37.508  1.00 85.86           C  
ATOM    681  O   ASN A  86      -1.479  60.061  38.293  1.00 81.35           O  
ATOM    682  CB  ASN A  86      -0.943  60.825  35.215  1.00 83.42           C  
ATOM    683  CG  ASN A  86      -1.245  60.560  33.740  1.00 80.99           C  
ATOM    684  OD1 ASN A  86      -2.348  60.132  33.393  1.00 78.65           O  
ATOM    685  ND2 ASN A  86      -0.265  60.813  32.870  1.00 77.71           N  
ATOM    686  N   ALA A  87       0.751  59.935  37.865  1.00 83.54           N  
ATOM    687  CA  ALA A  87       1.204  60.227  39.227  1.00 79.11           C  
ATOM    688  C   ALA A  87       0.589  61.490  39.844  1.00 78.80           C  
ATOM    689  O   ALA A  87       0.058  61.439  40.952  1.00 75.34           O  
ATOM    690  CB  ALA A  87       2.727  60.329  39.248  1.00 81.49           C  
ATOM    691  N   PRO A  88       0.655  62.640  39.135  1.00 78.79           N  
ATOM    692  CA  PRO A  88       0.079  63.878  39.688  1.00 75.23           C  
ATOM    693  C   PRO A  88      -1.358  63.694  40.171  1.00 77.10           C  
ATOM    694  O   PRO A  88      -1.803  64.372  41.102  1.00 73.15           O  
ATOM    695  CB  PRO A  88       0.166  64.857  38.519  1.00 68.75           C  
ATOM    696  CG  PRO A  88       0.180  63.952  37.302  1.00 73.74           C  
ATOM    697  CD  PRO A  88       1.099  62.847  37.742  1.00 72.79           C  
ATOM    698  N   ARG A  89      -2.063  62.761  39.531  1.00 82.63           N  
ATOM    699  CA  ARG A  89      -3.461  62.455  39.838  1.00 77.33           C  
ATOM    700  C   ARG A  89      -3.614  61.509  41.020  1.00 69.79           C  
ATOM    701  O   ARG A  89      -4.721  61.092  41.333  1.00 58.84           O  
ATOM    702  CB  ARG A  89      -4.144  61.854  38.600  1.00 83.52           C  
ATOM    703  CG  ARG A  89      -4.509  62.859  37.491  1.00 89.50           C  
ATOM    704  CD  ARG A  89      -5.908  63.485  37.679  1.00 97.52           C  
ATOM    705  NE  ARG A  89      -6.990  62.486  37.643  1.00111.99           N  
ATOM    706  CZ  ARG A  89      -8.296  62.764  37.704  1.00111.76           C  
ATOM    707  NH1 ARG A  89      -9.189  61.780  37.669  1.00101.51           N  
ATOM    708  NH2 ARG A  89      -8.717  64.023  37.794  1.00110.28           N  
ATOM    709  N   ILE A  90      -2.500  61.163  41.660  1.00 70.49           N  
ATOM    710  CA  ILE A  90      -2.523  60.278  42.825  1.00 73.12           C  
ATOM    711  C   ILE A  90      -3.031  61.109  43.986  1.00 73.64           C  
ATOM    712  O   ILE A  90      -2.753  62.305  44.047  1.00 79.75           O  
ATOM    713  CB  ILE A  90      -1.117  59.763  43.164  1.00 70.06           C  
ATOM    714  CG1 ILE A  90      -0.625  58.858  42.036  1.00 65.83           C  
ATOM    715  CG2 ILE A  90      -1.127  59.050  44.517  1.00 60.19           C  
ATOM    716  CD1 ILE A  90       0.814  58.493  42.136  1.00 69.31           C  
ATOM    717  N   ASP A  91      -3.751  60.488  44.914  1.00 67.83           N  
ATOM    718  CA  ASP A  91      -4.301  61.247  46.020  1.00 76.17           C  
ATOM    719  C   ASP A  91      -3.255  61.848  46.928  1.00 83.81           C  
ATOM    720  O   ASP A  91      -2.712  62.915  46.644  1.00 94.08           O  
ATOM    721  CB  ASP A  91      -5.252  60.411  46.864  1.00 79.18           C  
ATOM    722  CG  ASP A  91      -6.207  61.277  47.658  1.00 80.57           C  
ATOM    723  OD1 ASP A  91      -6.601  60.894  48.783  1.00 78.60           O  
ATOM    724  OD2 ASP A  91      -6.561  62.358  47.138  1.00 75.50           O  
ATOM    725  N   ASP A  92      -2.987  61.186  48.042  1.00 84.74           N  
ATOM    726  CA  ASP A  92      -1.995  61.701  48.964  1.00 83.41           C  
ATOM    727  C   ASP A  92      -0.672  61.840  48.203  1.00 86.02           C  
ATOM    728  O   ASP A  92      -0.164  60.856  47.672  1.00 93.48           O  
ATOM    729  CB  ASP A  92      -1.840  60.737  50.121  1.00 78.66           C  
ATOM    730  CG  ASP A  92      -1.022  61.313  51.220  1.00 87.10           C  
ATOM    731  OD1 ASP A  92      -0.337  62.335  50.967  1.00 85.66           O  
ATOM    732  OD2 ASP A  92      -1.065  60.742  52.327  1.00 89.87           O  
ATOM    733  N   GLN A  93      -0.108  63.047  48.152  1.00 83.74           N  
ATOM    734  CA  GLN A  93       1.136  63.266  47.399  1.00 82.96           C  
ATOM    735  C   GLN A  93       2.459  62.915  48.093  1.00 81.14           C  
ATOM    736  O   GLN A  93       3.534  63.028  47.490  1.00 77.29           O  
ATOM    737  CB  GLN A  93       1.190  64.714  46.885  1.00 79.81           C  
ATOM    738  CG  GLN A  93       0.341  64.959  45.634  1.00 81.88           C  
ATOM    739  CD  GLN A  93       0.913  64.289  44.380  1.00 83.38           C  
ATOM    740  OE1 GLN A  93       0.255  64.223  43.335  1.00 80.83           O  
ATOM    741  NE2 GLN A  93       2.146  63.798  44.482  1.00 83.99           N  
ATOM    742  N   ARG A  94       2.387  62.472  49.344  1.00 75.06           N  
ATOM    743  CA  ARG A  94       3.598  62.113  50.067  1.00 73.13           C  
ATOM    744  C   ARG A  94       3.989  60.672  49.801  1.00 74.44           C  
ATOM    745  O   ARG A  94       4.754  60.078  50.550  1.00 80.55           O  
ATOM    746  CB  ARG A  94       3.421  62.357  51.571  1.00 65.41           C  
ATOM    747  CG  ARG A  94       2.127  61.846  52.154  1.00 57.32           C  
ATOM    748  CD  ARG A  94       1.610  62.845  53.167  1.00 54.29           C  
ATOM    749  NE  ARG A  94       1.548  62.332  54.539  1.00 63.22           N  
ATOM    750  CZ  ARG A  94       0.477  61.761  55.094  1.00 62.12           C  
ATOM    751  NH1 ARG A  94       0.516  61.336  56.351  1.00 49.97           N  
ATOM    752  NH2 ARG A  94      -0.642  61.620  54.398  1.00 58.19           N  
ATOM    753  N   TYR A  95       3.473  60.123  48.708  1.00 74.78           N  
ATOM    754  CA  TYR A  95       3.761  58.749  48.324  1.00 77.11           C  
ATOM    755  C   TYR A  95       5.227  58.611  47.900  1.00 81.19           C  
ATOM    756  O   TYR A  95       5.887  57.618  48.213  1.00 81.75           O  
ATOM    757  CB  TYR A  95       2.851  58.352  47.168  1.00 70.20           C  
ATOM    758  CG  TYR A  95       3.164  59.061  45.869  1.00 69.08           C  
ATOM    759  CD1 TYR A  95       4.081  58.512  44.962  1.00 64.30           C  
ATOM    760  CD2 TYR A  95       2.514  60.254  45.521  1.00 56.43           C  
ATOM    761  CE1 TYR A  95       4.339  59.124  43.740  1.00 61.84           C  
ATOM    762  CE2 TYR A  95       2.768  60.879  44.298  1.00 51.33           C  
ATOM    763  CZ  TYR A  95       3.677  60.301  43.409  1.00 58.89           C  
ATOM    764  OH  TYR A  95       3.907  60.859  42.173  1.00 52.28           O  
ATOM    765  N   LEU A  96       5.729  59.617  47.190  1.00 80.90           N  
ATOM    766  CA  LEU A  96       7.108  59.612  46.725  1.00 83.33           C  
ATOM    767  C   LEU A  96       8.078  59.727  47.895  1.00 85.51           C  
ATOM    768  O   LEU A  96       9.296  59.735  47.706  1.00 84.95           O  
ATOM    769  CB  LEU A  96       7.347  60.770  45.756  1.00 83.76           C  
ATOM    770  CG  LEU A  96       7.853  60.453  44.341  1.00 83.73           C  
ATOM    771  CD1 LEU A  96       8.076  61.782  43.608  1.00 74.47           C  
ATOM    772  CD2 LEU A  96       9.151  59.634  44.383  1.00 72.89           C  
ATOM    773  N   ASN A  97       7.534  59.818  49.103  1.00 88.63           N  
ATOM    774  CA  ASN A  97       8.353  59.933  50.301  1.00 89.06           C  
ATOM    775  C   ASN A  97       8.440  58.601  51.035  1.00 86.06           C  
ATOM    776  O   ASN A  97       8.364  58.540  52.263  1.00 81.37           O  
ATOM    777  CB  ASN A  97       7.780  61.013  51.228  1.00 91.08           C  
ATOM    778  CG  ASN A  97       7.712  62.379  50.562  1.00 94.81           C  
ATOM    779  OD1 ASN A  97       8.701  62.861  49.992  1.00 93.41           O  
ATOM    780  ND2 ASN A  97       6.545  63.015  50.637  1.00 95.44           N  
ATOM    781  N   GLY A  98       8.595  57.530  50.271  1.00 84.41           N  
ATOM    782  CA  GLY A  98       8.707  56.220  50.871  1.00 88.87           C  
ATOM    783  C   GLY A  98       9.996  55.583  50.406  1.00 93.76           C  
ATOM    784  O   GLY A  98      10.705  56.144  49.562  1.00 94.57           O  
ATOM    785  N   GLN A  99      10.304  54.416  50.963  1.00 94.60           N  
ATOM    786  CA  GLN A  99      11.509  53.673  50.602  1.00 95.06           C  
ATOM    787  C   GLN A  99      11.501  53.459  49.067  1.00 96.32           C  
ATOM    788  O   GLN A  99      12.263  54.107  48.339  1.00 92.12           O  
ATOM    789  CB  GLN A  99      11.504  52.340  51.365  1.00 95.58           C  
ATOM    790  CG  GLN A  99      12.864  51.862  51.812  1.00 99.62           C  
ATOM    791  CD  GLN A  99      13.743  51.446  50.651  1.00103.34           C  
ATOM    792  OE1 GLN A  99      14.894  51.876  50.548  1.00104.82           O  
ATOM    793  NE2 GLN A  99      13.208  50.601  49.769  1.00101.52           N  
ATOM    794  N   SER A 100      10.627  52.563  48.591  1.00 96.74           N  
ATOM    795  CA  SER A 100      10.468  52.271  47.155  1.00 89.54           C  
ATOM    796  C   SER A 100       8.991  52.406  46.728  1.00 87.28           C  
ATOM    797  O   SER A 100       8.079  52.293  47.557  1.00 82.83           O  
ATOM    798  CB  SER A 100      10.995  50.862  46.810  1.00 88.06           C  
ATOM    799  OG  SER A 100      10.445  49.849  47.638  1.00 86.97           O  
ATOM    800  N   LEU A 101       8.769  52.650  45.434  1.00 85.23           N  
ATOM    801  CA  LEU A 101       7.417  52.827  44.873  1.00 76.00           C  
ATOM    802  C   LEU A 101       7.023  51.727  43.901  1.00 74.42           C  
ATOM    803  O   LEU A 101       7.789  51.365  43.012  1.00 70.98           O  
ATOM    804  CB  LEU A 101       7.314  54.163  44.126  1.00 66.96           C  
ATOM    805  CG  LEU A 101       5.914  54.653  43.767  1.00 61.60           C  
ATOM    806  CD1 LEU A 101       5.210  55.088  45.051  1.00 48.27           C  
ATOM    807  CD2 LEU A 101       5.980  55.811  42.778  1.00 47.56           C  
ATOM    808  N   ILE A 102       5.802  51.231  44.055  1.00 74.04           N  
ATOM    809  CA  ILE A 102       5.286  50.184  43.191  1.00 65.34           C  
ATOM    810  C   ILE A 102       3.834  50.512  42.828  1.00 60.16           C  
ATOM    811  O   ILE A 102       3.026  50.825  43.705  1.00 56.26           O  
ATOM    812  CB  ILE A 102       5.378  48.829  43.905  1.00 61.38           C  
ATOM    813  CG1 ILE A 102       4.924  47.718  42.965  1.00 67.74           C  
ATOM    814  CG2 ILE A 102       4.558  48.864  45.189  1.00 54.48           C  
ATOM    815  CD1 ILE A 102       3.439  47.698  42.686  1.00 70.01           C  
ATOM    816  N   LYS A 103       3.512  50.442  41.536  1.00 56.02           N  
ATOM    817  CA  LYS A 103       2.161  50.747  41.068  1.00 55.92           C  
ATOM    818  C   LYS A 103       1.470  49.624  40.299  1.00 59.02           C  
ATOM    819  O   LYS A 103       2.087  48.899  39.518  1.00 59.81           O  
ATOM    820  CB  LYS A 103       2.158  51.987  40.178  1.00 57.04           C  
ATOM    821  CG  LYS A 103       2.597  51.724  38.743  1.00 48.13           C  
ATOM    822  CD  LYS A 103       1.895  52.676  37.785  1.00 51.27           C  
ATOM    823  CE  LYS A 103       2.355  52.471  36.351  1.00 63.46           C  
ATOM    824  NZ  LYS A 103       1.714  53.442  35.421  1.00 66.72           N  
ATOM    825  N   ILE A 104       0.163  49.521  40.505  1.00 56.75           N  
ATOM    826  CA  ILE A 104      -0.646  48.507  39.855  1.00 53.44           C  
ATOM    827  C   ILE A 104      -1.835  49.224  39.252  1.00 61.30           C  
ATOM    828  O   ILE A 104      -2.630  49.825  39.974  1.00 69.19           O  
ATOM    829  CB  ILE A 104      -1.179  47.502  40.868  1.00 44.92           C  
ATOM    830  CG1 ILE A 104      -0.033  46.947  41.705  1.00 44.71           C  
ATOM    831  CG2 ILE A 104      -1.915  46.402  40.147  1.00 51.91           C  
ATOM    832  CD1 ILE A 104      -0.495  46.173  42.908  1.00 36.00           C  
ATOM    833  N   ASP A 105      -1.974  49.158  37.939  1.00 62.01           N  
ATOM    834  CA  ASP A 105      -3.086  49.837  37.308  1.00 64.20           C  
ATOM    835  C   ASP A 105      -3.566  49.103  36.064  1.00 65.83           C  
ATOM    836  O   ASP A 105      -2.922  48.160  35.616  1.00 63.92           O  
ATOM    837  CB  ASP A 105      -2.659  51.260  36.970  1.00 71.58           C  
ATOM    838  CG  ASP A 105      -3.746  52.039  36.310  1.00 83.30           C  
ATOM    839  OD1 ASP A 105      -4.868  52.061  36.866  1.00 89.07           O  
ATOM    840  OD2 ASP A 105      -3.480  52.629  35.239  1.00 89.73           O  
ATOM    841  N   HIS A 106      -4.702  49.525  35.509  1.00 69.21           N  
ATOM    842  CA  HIS A 106      -5.251  48.890  34.308  1.00 66.92           C  
ATOM    843  C   HIS A 106      -5.470  49.895  33.195  1.00 66.76           C  
ATOM    844  O   HIS A 106      -6.148  49.599  32.212  1.00 65.83           O  
ATOM    845  CB  HIS A 106      -6.581  48.202  34.602  1.00 67.76           C  
ATOM    846  CG  HIS A 106      -7.655  49.139  35.057  1.00 69.70           C  
ATOM    847  ND1 HIS A 106      -8.988  48.932  34.784  1.00 71.49           N  
ATOM    848  CD2 HIS A 106      -7.594  50.274  35.795  1.00 69.25           C  
ATOM    849  CE1 HIS A 106      -9.703  49.897  35.331  1.00 72.89           C  
ATOM    850  NE2 HIS A 106      -8.881  50.724  35.952  1.00 72.95           N  
ATOM    851  N   HIS A 107      -4.916  51.090  33.364  1.00 67.17           N  
ATOM    852  CA  HIS A 107      -5.029  52.128  32.351  1.00 69.43           C  
ATOM    853  C   HIS A 107      -3.804  52.073  31.471  1.00 72.22           C  
ATOM    854  O   HIS A 107      -2.784  51.486  31.840  1.00 69.39           O  
ATOM    855  CB  HIS A 107      -5.105  53.509  32.988  1.00 62.96           C  
ATOM    856  CG  HIS A 107      -6.384  53.758  33.708  1.00 62.77           C  
ATOM    857  ND1 HIS A 107      -7.592  53.860  33.056  1.00 72.74           N  
ATOM    858  CD2 HIS A 107      -6.656  53.864  35.029  1.00 67.66           C  
ATOM    859  CE1 HIS A 107      -8.557  54.015  33.943  1.00 81.66           C  
ATOM    860  NE2 HIS A 107      -8.016  54.020  35.149  1.00 83.38           N  
ATOM    861  N   PRO A 108      -3.883  52.686  30.287  1.00 72.43           N  
ATOM    862  CA  PRO A 108      -2.719  52.662  29.405  1.00 69.10           C  
ATOM    863  C   PRO A 108      -1.452  53.166  30.111  1.00 69.71           C  
ATOM    864  O   PRO A 108      -1.471  54.182  30.814  1.00 60.76           O  
ATOM    865  CB  PRO A 108      -3.161  53.542  28.238  1.00 67.41           C  
ATOM    866  CG  PRO A 108      -4.221  54.444  28.845  1.00 69.42           C  
ATOM    867  CD  PRO A 108      -4.975  53.502  29.722  1.00 66.47           C  
ATOM    868  N   ALA A 109      -0.356  52.436  29.930  1.00 74.05           N  
ATOM    869  CA  ALA A 109       0.923  52.786  30.544  1.00 80.10           C  
ATOM    870  C   ALA A 109       1.563  54.011  29.907  1.00 81.78           C  
ATOM    871  O   ALA A 109       2.325  53.890  28.950  1.00 84.16           O  
ATOM    872  CB  ALA A 109       1.890  51.594  30.450  1.00 78.25           C  
ATOM    873  N   THR A 110       1.263  55.192  30.432  1.00 86.82           N  
ATOM    874  CA  THR A 110       1.853  56.407  29.880  1.00 95.11           C  
ATOM    875  C   THR A 110       2.769  57.069  30.909  1.00 98.10           C  
ATOM    876  O   THR A 110       3.693  57.800  30.547  1.00 97.96           O  
ATOM    877  CB  THR A 110       0.771  57.431  29.429  1.00 94.93           C  
ATOM    878  OG1 THR A 110       0.055  57.920  30.572  1.00105.06           O  
ATOM    879  CG2 THR A 110      -0.206  56.781  28.459  1.00 86.51           C  
ATOM    880  N   ASP A 111       2.518  56.802  32.190  1.00 96.68           N  
ATOM    881  CA  ASP A 111       3.327  57.381  33.253  1.00 96.22           C  
ATOM    882  C   ASP A 111       4.441  56.422  33.677  1.00 96.20           C  
ATOM    883  O   ASP A 111       5.616  56.791  33.695  1.00105.12           O  
ATOM    884  CB  ASP A 111       2.451  57.745  34.462  1.00 97.93           C  
ATOM    885  CG  ASP A 111       2.886  59.050  35.138  1.00 97.63           C  
ATOM    886  OD1 ASP A 111       2.700  60.135  34.544  1.00 88.67           O  
ATOM    887  OD2 ASP A 111       3.414  58.988  36.265  1.00 94.77           O  
ATOM    888  N   GLN A 112       4.087  55.186  34.005  1.00 90.95           N  
ATOM    889  CA  GLN A 112       5.091  54.211  34.430  1.00 84.92           C  
ATOM    890  C   GLN A 112       5.859  54.660  35.669  1.00 77.17           C  
ATOM    891  O   GLN A 112       6.984  54.221  35.901  1.00 70.63           O  
ATOM    892  CB  GLN A 112       6.076  53.930  33.294  1.00 84.00           C  
ATOM    893  CG  GLN A 112       5.504  53.035  32.227  1.00 93.89           C  
ATOM    894  CD  GLN A 112       5.107  51.669  32.773  1.00 99.40           C  
ATOM    895  OE1 GLN A 112       4.324  51.569  33.726  1.00 89.89           O  
ATOM    896  NE2 GLN A 112       5.649  50.607  32.171  1.00104.22           N  
ATOM    897  N   TYR A 113       5.244  55.541  36.454  1.00 67.96           N  
ATOM    898  CA  TYR A 113       5.838  56.050  37.683  1.00 63.29           C  
ATOM    899  C   TYR A 113       6.083  54.874  38.614  1.00 64.08           C  
ATOM    900  O   TYR A 113       5.424  53.854  38.497  1.00 73.23           O  
ATOM    901  CB  TYR A 113       4.885  57.061  38.332  1.00 63.25           C  
ATOM    902  CG  TYR A 113       3.514  56.522  38.723  1.00 62.85           C  
ATOM    903  CD1 TYR A 113       3.268  56.054  40.019  1.00 60.80           C  
ATOM    904  CD2 TYR A 113       2.467  56.460  37.791  1.00 66.17           C  
ATOM    905  CE1 TYR A 113       2.016  55.535  40.380  1.00 60.83           C  
ATOM    906  CE2 TYR A 113       1.209  55.941  38.141  1.00 70.34           C  
ATOM    907  CZ  TYR A 113       0.993  55.475  39.438  1.00 70.54           C  
ATOM    908  OH  TYR A 113      -0.230  54.925  39.780  1.00 66.96           O  
ATOM    909  N   GLY A 114       7.026  54.989  39.535  1.00 67.21           N  
ATOM    910  CA  GLY A 114       7.257  53.865  40.423  1.00 70.01           C  
ATOM    911  C   GLY A 114       8.253  52.859  39.875  1.00 77.10           C  
ATOM    912  O   GLY A 114       8.352  52.647  38.666  1.00 76.05           O  
ATOM    913  N   ASP A 115       8.991  52.241  40.794  1.00 81.96           N  
ATOM    914  CA  ASP A 115      10.023  51.251  40.493  1.00 82.98           C  
ATOM    915  C   ASP A 115       9.480  50.091  39.682  1.00 76.52           C  
ATOM    916  O   ASP A 115       9.863  49.893  38.531  1.00 80.49           O  
ATOM    917  CB  ASP A 115      10.613  50.728  41.806  1.00 90.71           C  
ATOM    918  CG  ASP A 115      11.157  51.851  42.699  1.00 94.78           C  
ATOM    919  OD1 ASP A 115      11.393  51.590  43.904  1.00100.72           O  
ATOM    920  OD2 ASP A 115      11.356  52.985  42.195  1.00 80.66           O  
ATOM    921  N   VAL A 116       8.594  49.321  40.301  1.00 76.20           N  
ATOM    922  CA  VAL A 116       7.975  48.175  39.654  1.00 73.83           C  
ATOM    923  C   VAL A 116       6.621  48.593  39.117  1.00 65.74           C  
ATOM    924  O   VAL A 116       5.764  49.043  39.872  1.00 60.39           O  
ATOM    925  CB  VAL A 116       7.752  47.021  40.650  1.00 78.33           C  
ATOM    926  CG1 VAL A 116       7.178  45.821  39.925  1.00 75.88           C  
ATOM    927  CG2 VAL A 116       9.058  46.659  41.342  1.00 76.03           C  
ATOM    928  N   ASN A 117       6.423  48.439  37.815  1.00 68.33           N  
ATOM    929  CA  ASN A 117       5.148  48.808  37.217  1.00 74.68           C  
ATOM    930  C   ASN A 117       4.432  47.620  36.584  1.00 76.63           C  
ATOM    931  O   ASN A 117       4.961  46.961  35.684  1.00 77.76           O  
ATOM    932  CB  ASN A 117       5.342  49.887  36.155  1.00 74.42           C  
ATOM    933  CG  ASN A 117       6.005  51.115  36.704  1.00 78.03           C  
ATOM    934  OD1 ASN A 117       5.611  51.613  37.755  1.00 72.38           O  
ATOM    935  ND2 ASN A 117       7.012  51.620  35.999  1.00 83.42           N  
ATOM    936  N   PHE A 118       3.220  47.351  37.058  1.00 74.89           N  
ATOM    937  CA  PHE A 118       2.423  46.263  36.518  1.00 72.03           C  
ATOM    938  C   PHE A 118       1.077  46.796  36.052  1.00 69.23           C  
ATOM    939  O   PHE A 118       0.229  47.130  36.875  1.00 68.60           O  
ATOM    940  CB  PHE A 118       2.206  45.187  37.571  1.00 65.20           C  
ATOM    941  CG  PHE A 118       1.311  44.081  37.113  1.00 67.97           C  
ATOM    942  CD1 PHE A 118      -0.060  44.143  37.317  1.00 69.13           C  
ATOM    943  CD2 PHE A 118       1.839  42.981  36.460  1.00 69.24           C  
ATOM    944  CE1 PHE A 118      -0.893  43.118  36.877  1.00 66.44           C  
ATOM    945  CE2 PHE A 118       1.018  41.953  36.017  1.00 69.78           C  
ATOM    946  CZ  PHE A 118      -0.350  42.023  36.228  1.00 74.48           C  
ATOM    947  N   VAL A 119       0.890  46.880  34.737  1.00 65.63           N  
ATOM    948  CA  VAL A 119      -0.358  47.376  34.160  1.00 67.29           C  
ATOM    949  C   VAL A 119      -1.012  46.355  33.230  1.00 73.38           C  
ATOM    950  O   VAL A 119      -0.545  46.133  32.109  1.00 82.31           O  
ATOM    951  CB  VAL A 119      -0.130  48.679  33.361  1.00 56.74           C  
ATOM    952  CG1 VAL A 119       0.065  49.850  34.301  1.00 66.93           C  
ATOM    953  CG2 VAL A 119       1.088  48.532  32.483  1.00 72.54           C  
ATOM    954  N   ASN A 120      -2.090  45.729  33.699  1.00 71.98           N  
ATOM    955  CA  ASN A 120      -2.816  44.734  32.908  1.00 67.79           C  
ATOM    956  C   ASN A 120      -3.877  45.505  32.143  1.00 65.34           C  
ATOM    957  O   ASN A 120      -5.037  45.584  32.548  1.00 63.91           O  
ATOM    958  CB  ASN A 120      -3.472  43.698  33.825  1.00 69.30           C  
ATOM    959  CG  ASN A 120      -4.000  42.485  33.072  1.00 66.05           C  
ATOM    960  OD1 ASN A 120      -4.304  42.551  31.880  1.00 55.43           O  
ATOM    961  ND2 ASN A 120      -4.133  41.372  33.783  1.00 67.52           N  
ATOM    962  N   THR A 121      -3.444  46.098  31.042  1.00 68.52           N  
ATOM    963  CA  THR A 121      -4.311  46.881  30.188  1.00 67.70           C  
ATOM    964  C   THR A 121      -5.609  46.135  29.878  1.00 66.25           C  
ATOM    965  O   THR A 121      -6.691  46.727  29.879  1.00 67.62           O  
ATOM    966  CB  THR A 121      -3.553  47.260  28.882  1.00 69.58           C  
ATOM    967  OG1 THR A 121      -4.492  47.548  27.841  1.00 81.78           O  
ATOM    968  CG2 THR A 121      -2.608  46.124  28.445  1.00 69.67           C  
ATOM    969  N   GLU A 122      -5.509  44.831  29.652  1.00 57.21           N  
ATOM    970  CA  GLU A 122      -6.684  44.042  29.332  1.00 57.46           C  
ATOM    971  C   GLU A 122      -7.583  43.652  30.513  1.00 52.72           C  
ATOM    972  O   GLU A 122      -8.567  42.928  30.342  1.00 55.55           O  
ATOM    973  CB  GLU A 122      -6.258  42.809  28.527  1.00 64.28           C  
ATOM    974  CG  GLU A 122      -6.717  42.836  27.074  1.00 74.83           C  
ATOM    975  CD  GLU A 122      -8.179  42.421  26.924  1.00 90.52           C  
ATOM    976  OE1 GLU A 122      -9.041  43.010  27.619  1.00 93.86           O  
ATOM    977  OE2 GLU A 122      -8.468  41.504  26.114  1.00 98.29           O  
ATOM    978  N   ALA A 123      -7.265  44.145  31.705  1.00 46.17           N  
ATOM    979  CA  ALA A 123      -8.070  43.862  32.900  1.00 50.25           C  
ATOM    980  C   ALA A 123      -9.309  44.787  32.989  1.00 52.97           C  
ATOM    981  O   ALA A 123      -9.259  45.960  32.602  1.00 57.68           O  
ATOM    982  CB  ALA A 123      -7.207  44.029  34.159  1.00 47.00           C  
ATOM    983  N   SER A 124     -10.413  44.266  33.513  1.00 45.90           N  
ATOM    984  CA  SER A 124     -11.625  45.057  33.625  1.00 37.43           C  
ATOM    985  C   SER A 124     -11.450  46.139  34.660  1.00 39.93           C  
ATOM    986  O   SER A 124     -12.111  47.171  34.606  1.00 47.74           O  
ATOM    987  CB  SER A 124     -12.793  44.196  34.067  1.00 41.50           C  
ATOM    988  OG  SER A 124     -12.781  44.077  35.473  1.00 37.30           O  
ATOM    989  N   SER A 125     -10.552  45.912  35.602  1.00 37.50           N  
ATOM    990  CA  SER A 125     -10.379  46.871  36.667  1.00 41.10           C  
ATOM    991  C   SER A 125      -9.204  46.487  37.514  1.00 47.16           C  
ATOM    992  O   SER A 125      -8.766  45.340  37.494  1.00 59.09           O  
ATOM    993  CB  SER A 125     -11.616  46.838  37.546  1.00 44.18           C  
ATOM    994  OG  SER A 125     -11.813  45.515  38.033  1.00 35.39           O  
ATOM    995  N   THR A 126      -8.720  47.432  38.305  1.00 47.62           N  
ATOM    996  CA  THR A 126      -7.606  47.138  39.181  1.00 51.75           C  
ATOM    997  C   THR A 126      -7.996  46.065  40.204  1.00 49.82           C  
ATOM    998  O   THR A 126      -7.194  45.187  40.519  1.00 45.59           O  
ATOM    999  CB  THR A 126      -7.141  48.394  39.886  1.00 53.78           C  
ATOM   1000  OG1 THR A 126      -6.642  49.316  38.908  1.00 56.68           O  
ATOM   1001  CG2 THR A 126      -6.046  48.066  40.873  1.00 49.67           C  
ATOM   1002  N   SER A 127      -9.227  46.137  40.708  1.00 49.10           N  
ATOM   1003  CA  SER A 127      -9.721  45.147  41.662  1.00 54.79           C  
ATOM   1004  C   SER A 127      -9.459  43.765  41.086  1.00 56.17           C  
ATOM   1005  O   SER A 127      -8.950  42.854  41.758  1.00 50.49           O  
ATOM   1006  CB  SER A 127     -11.231  45.301  41.883  1.00 50.13           C  
ATOM   1007  OG  SER A 127     -11.516  46.254  42.878  1.00 49.57           O  
ATOM   1008  N   GLU A 128      -9.828  43.617  39.824  1.00 51.85           N  
ATOM   1009  CA  GLU A 128      -9.637  42.358  39.142  1.00 54.55           C  
ATOM   1010  C   GLU A 128      -8.154  41.940  39.172  1.00 51.37           C  
ATOM   1011  O   GLU A 128      -7.830  40.769  39.384  1.00 41.49           O  
ATOM   1012  CB  GLU A 128     -10.147  42.481  37.711  1.00 48.24           C  
ATOM   1013  CG  GLU A 128     -10.089  41.194  36.954  1.00 50.35           C  
ATOM   1014  CD  GLU A 128     -10.658  41.339  35.579  1.00 53.73           C  
ATOM   1015  OE1 GLU A 128     -11.867  41.614  35.474  1.00 54.13           O  
ATOM   1016  OE2 GLU A 128      -9.902  41.191  34.595  1.00 60.71           O  
ATOM   1017  N   ILE A 129      -7.258  42.903  38.977  1.00 44.31           N  
ATOM   1018  CA  ILE A 129      -5.827  42.628  39.000  1.00 42.83           C  
ATOM   1019  C   ILE A 129      -5.433  42.126  40.384  1.00 42.10           C  
ATOM   1020  O   ILE A 129      -4.589  41.246  40.530  1.00 37.57           O  
ATOM   1021  CB  ILE A 129      -5.035  43.900  38.666  1.00 37.94           C  
ATOM   1022  CG1 ILE A 129      -5.391  44.345  37.262  1.00 30.30           C  
ATOM   1023  CG2 ILE A 129      -3.538  43.649  38.755  1.00 31.97           C  
ATOM   1024  CD1 ILE A 129      -4.763  45.635  36.887  1.00 44.40           C  
ATOM   1025  N   ILE A 130      -6.063  42.698  41.400  1.00 42.93           N  
ATOM   1026  CA  ILE A 130      -5.800  42.310  42.768  1.00 45.92           C  
ATOM   1027  C   ILE A 130      -6.232  40.869  42.997  1.00 48.75           C  
ATOM   1028  O   ILE A 130      -5.526  40.090  43.640  1.00 44.19           O  
ATOM   1029  CB  ILE A 130      -6.526  43.253  43.748  1.00 42.51           C  
ATOM   1030  CG1 ILE A 130      -5.804  44.591  43.777  1.00 34.01           C  
ATOM   1031  CG2 ILE A 130      -6.548  42.660  45.146  1.00 42.14           C  
ATOM   1032  CD1 ILE A 130      -4.360  44.470  44.200  1.00 24.55           C  
ATOM   1033  N   PHE A 131      -7.389  40.496  42.471  1.00 50.08           N  
ATOM   1034  CA  PHE A 131      -7.819  39.124  42.652  1.00 55.56           C  
ATOM   1035  C   PHE A 131      -6.812  38.171  42.021  1.00 56.90           C  
ATOM   1036  O   PHE A 131      -6.526  37.107  42.562  1.00 57.16           O  
ATOM   1037  CB  PHE A 131      -9.164  38.880  42.004  1.00 54.40           C  
ATOM   1038  CG  PHE A 131      -9.751  37.566  42.372  1.00 54.75           C  
ATOM   1039  CD1 PHE A 131     -10.506  37.444  43.533  1.00 50.76           C  
ATOM   1040  CD2 PHE A 131      -9.534  36.443  41.575  1.00 47.25           C  
ATOM   1041  CE1 PHE A 131     -11.039  36.227  43.900  1.00 51.69           C  
ATOM   1042  CE2 PHE A 131     -10.062  35.213  41.931  1.00 54.52           C  
ATOM   1043  CZ  PHE A 131     -10.821  35.102  43.098  1.00 54.20           C  
ATOM   1044  N   ASP A 132      -6.309  38.563  40.853  1.00 58.95           N  
ATOM   1045  CA  ASP A 132      -5.326  37.794  40.099  1.00 51.10           C  
ATOM   1046  C   ASP A 132      -4.082  37.581  40.942  1.00 47.91           C  
ATOM   1047  O   ASP A 132      -3.563  36.474  41.027  1.00 47.44           O  
ATOM   1048  CB  ASP A 132      -4.944  38.562  38.834  1.00 61.54           C  
ATOM   1049  CG  ASP A 132      -6.056  38.596  37.808  1.00 69.63           C  
ATOM   1050  OD1 ASP A 132      -5.921  39.357  36.822  1.00 70.78           O  
ATOM   1051  OD2 ASP A 132      -7.050  37.853  37.979  1.00 76.76           O  
ATOM   1052  N   PHE A 133      -3.616  38.666  41.552  1.00 44.24           N  
ATOM   1053  CA  PHE A 133      -2.435  38.669  42.406  1.00 40.30           C  
ATOM   1054  C   PHE A 133      -2.583  37.688  43.555  1.00 45.35           C  
ATOM   1055  O   PHE A 133      -1.789  36.753  43.703  1.00 43.60           O  
ATOM   1056  CB  PHE A 133      -2.231  40.066  42.965  1.00 30.21           C  
ATOM   1057  CG  PHE A 133      -1.075  40.193  43.904  1.00 32.75           C  
ATOM   1058  CD1 PHE A 133       0.182  40.533  43.431  1.00 44.42           C  
ATOM   1059  CD2 PHE A 133      -1.262  40.093  45.276  1.00 39.39           C  
ATOM   1060  CE1 PHE A 133       1.247  40.792  44.318  1.00 46.72           C  
ATOM   1061  CE2 PHE A 133      -0.208  40.347  46.171  1.00 42.51           C  
ATOM   1062  CZ  PHE A 133       1.044  40.702  45.685  1.00 38.45           C  
ATOM   1063  N   ILE A 134      -3.611  37.892  44.373  1.00 49.47           N  
ATOM   1064  CA  ILE A 134      -3.819  37.008  45.514  1.00 52.96           C  
ATOM   1065  C   ILE A 134      -4.077  35.580  45.053  1.00 47.92           C  
ATOM   1066  O   ILE A 134      -3.700  34.628  45.724  1.00 48.70           O  
ATOM   1067  CB  ILE A 134      -4.999  37.481  46.426  1.00 51.67           C  
ATOM   1068  CG1 ILE A 134      -6.327  37.015  45.875  1.00 57.11           C  
ATOM   1069  CG2 ILE A 134      -5.049  38.993  46.495  1.00 43.02           C  
ATOM   1070  CD1 ILE A 134      -7.448  37.342  46.808  1.00 68.04           C  
ATOM   1071  N   SER A 135      -4.703  35.441  43.894  1.00 46.39           N  
ATOM   1072  CA  SER A 135      -5.012  34.129  43.358  1.00 48.48           C  
ATOM   1073  C   SER A 135      -3.726  33.443  42.936  1.00 51.94           C  
ATOM   1074  O   SER A 135      -3.653  32.220  42.876  1.00 55.13           O  
ATOM   1075  CB  SER A 135      -5.952  34.263  42.159  1.00 46.85           C  
ATOM   1076  OG  SER A 135      -6.916  33.231  42.138  1.00 45.25           O  
ATOM   1077  N   HIS A 136      -2.706  34.241  42.645  1.00 56.48           N  
ATOM   1078  CA  HIS A 136      -1.407  33.717  42.226  1.00 61.40           C  
ATOM   1079  C   HIS A 136      -0.611  33.223  43.417  1.00 62.09           C  
ATOM   1080  O   HIS A 136       0.478  32.672  43.271  1.00 64.25           O  
ATOM   1081  CB  HIS A 136      -0.593  34.807  41.546  1.00 60.70           C  
ATOM   1082  CG  HIS A 136       0.820  34.410  41.264  1.00 61.60           C  
ATOM   1083  ND1 HIS A 136       1.143  33.392  40.395  1.00 64.82           N  
ATOM   1084  CD2 HIS A 136       1.994  34.901  41.725  1.00 59.09           C  
ATOM   1085  CE1 HIS A 136       2.456  33.277  40.325  1.00 64.58           C  
ATOM   1086  NE2 HIS A 136       2.998  34.182  41.122  1.00 62.79           N  
ATOM   1087  N   PHE A 137      -1.148  33.439  44.604  1.00 57.08           N  
ATOM   1088  CA  PHE A 137      -0.445  33.027  45.784  1.00 52.17           C  
ATOM   1089  C   PHE A 137      -1.295  32.047  46.558  1.00 50.82           C  
ATOM   1090  O   PHE A 137      -1.109  31.851  47.748  1.00 60.07           O  
ATOM   1091  CB  PHE A 137      -0.085  34.268  46.612  1.00 53.79           C  
ATOM   1092  CG  PHE A 137       0.939  35.183  45.944  1.00 56.70           C  
ATOM   1093  CD1 PHE A 137       2.256  34.755  45.720  1.00 55.48           C  
ATOM   1094  CD2 PHE A 137       0.599  36.479  45.574  1.00 53.11           C  
ATOM   1095  CE1 PHE A 137       3.217  35.608  45.145  1.00 39.24           C  
ATOM   1096  CE2 PHE A 137       1.559  37.333  45.000  1.00 47.79           C  
ATOM   1097  CZ  PHE A 137       2.864  36.892  44.788  1.00 40.49           C  
ATOM   1098  N   ASN A 138      -2.227  31.421  45.852  1.00 54.30           N  
ATOM   1099  CA  ASN A 138      -3.133  30.433  46.438  1.00 63.13           C  
ATOM   1100  C   ASN A 138      -3.753  30.862  47.769  1.00 59.30           C  
ATOM   1101  O   ASN A 138      -4.128  30.032  48.607  1.00 56.36           O  
ATOM   1102  CB  ASN A 138      -2.413  29.093  46.607  1.00 59.92           C  
ATOM   1103  CG  ASN A 138      -3.357  27.915  46.482  1.00 68.16           C  
ATOM   1104  OD1 ASN A 138      -2.991  26.865  45.949  1.00 63.27           O  
ATOM   1105  ND2 ASN A 138      -4.593  28.084  46.970  1.00 72.42           N  
ATOM   1106  N   ASP A 139      -3.877  32.169  47.948  1.00 54.37           N  
ATOM   1107  CA  ASP A 139      -4.445  32.708  49.167  1.00 57.07           C  
ATOM   1108  C   ASP A 139      -5.959  32.890  49.085  1.00 59.72           C  
ATOM   1109  O   ASP A 139      -6.523  33.700  49.817  1.00 63.49           O  
ATOM   1110  CB  ASP A 139      -3.774  34.038  49.503  1.00 57.75           C  
ATOM   1111  CG  ASP A 139      -2.322  33.868  49.889  1.00 66.68           C  
ATOM   1112  OD1 ASP A 139      -1.530  34.817  49.677  1.00 70.81           O  
ATOM   1113  OD2 ASP A 139      -1.972  32.782  50.414  1.00 68.82           O  
ATOM   1114  N   LEU A 140      -6.626  32.143  48.207  1.00 58.44           N  
ATOM   1115  CA  LEU A 140      -8.081  32.257  48.089  1.00 56.10           C  
ATOM   1116  C   LEU A 140      -8.783  31.699  49.325  1.00 56.10           C  
ATOM   1117  O   LEU A 140     -10.006  31.743  49.440  1.00 58.57           O  
ATOM   1118  CB  LEU A 140      -8.589  31.513  46.853  1.00 53.86           C  
ATOM   1119  CG  LEU A 140      -8.253  32.069  45.471  1.00 54.82           C  
ATOM   1120  CD1 LEU A 140      -9.063  31.280  44.455  1.00 50.11           C  
ATOM   1121  CD2 LEU A 140      -8.574  33.559  45.373  1.00 41.28           C  
ATOM   1122  N   SER A 141      -7.987  31.175  50.244  1.00 59.80           N  
ATOM   1123  CA  SER A 141      -8.471  30.586  51.483  1.00 57.77           C  
ATOM   1124  C   SER A 141      -8.233  31.554  52.640  1.00 61.24           C  
ATOM   1125  O   SER A 141      -9.038  31.647  53.568  1.00 62.12           O  
ATOM   1126  CB  SER A 141      -7.716  29.283  51.714  1.00 53.78           C  
ATOM   1127  OG  SER A 141      -6.405  29.387  51.165  1.00 46.69           O  
ATOM   1128  N   ILE A 142      -7.114  32.269  52.564  1.00 64.86           N  
ATOM   1129  CA  ILE A 142      -6.722  33.259  53.559  1.00 64.43           C  
ATOM   1130  C   ILE A 142      -7.672  34.458  53.491  1.00 69.68           C  
ATOM   1131  O   ILE A 142      -7.902  35.143  54.490  1.00 75.80           O  
ATOM   1132  CB  ILE A 142      -5.276  33.746  53.299  1.00 62.06           C  
ATOM   1133  CG1 ILE A 142      -4.282  32.597  53.527  1.00 66.12           C  
ATOM   1134  CG2 ILE A 142      -4.946  34.910  54.199  1.00 63.62           C  
ATOM   1135  CD1 ILE A 142      -4.201  31.595  52.390  1.00 63.85           C  
ATOM   1136  N   ILE A 143      -8.220  34.701  52.303  1.00 69.50           N  
ATOM   1137  CA  ILE A 143      -9.159  35.796  52.064  1.00 59.63           C  
ATOM   1138  C   ILE A 143     -10.537  35.425  52.631  1.00 62.99           C  
ATOM   1139  O   ILE A 143     -10.866  34.244  52.761  1.00 50.26           O  
ATOM   1140  CB  ILE A 143      -9.280  36.069  50.542  1.00 56.67           C  
ATOM   1141  CG1 ILE A 143     -10.182  37.253  50.276  1.00 63.70           C  
ATOM   1142  CG2 ILE A 143      -9.900  34.879  49.835  1.00 52.94           C  
ATOM   1143  CD1 ILE A 143     -10.323  37.546  48.811  1.00 60.33           C  
ATOM   1144  N   ASP A 144     -11.332  36.433  52.984  1.00 69.33           N  
ATOM   1145  CA  ASP A 144     -12.674  36.204  53.535  1.00 72.46           C  
ATOM   1146  C   ASP A 144     -13.728  37.182  53.015  1.00 71.16           C  
ATOM   1147  O   ASP A 144     -13.456  38.001  52.140  1.00 70.21           O  
ATOM   1148  CB  ASP A 144     -12.637  36.264  55.065  1.00 75.54           C  
ATOM   1149  CG  ASP A 144     -12.049  37.564  55.583  1.00 80.78           C  
ATOM   1150  OD1 ASP A 144     -11.779  37.656  56.804  1.00 80.46           O  
ATOM   1151  OD2 ASP A 144     -11.858  38.494  54.765  1.00 79.58           O  
ATOM   1152  N   GLU A 145     -14.926  37.095  53.583  1.00 74.54           N  
ATOM   1153  CA  GLU A 145     -16.045  37.942  53.182  1.00 73.93           C  
ATOM   1154  C   GLU A 145     -15.697  39.415  53.144  1.00 69.31           C  
ATOM   1155  O   GLU A 145     -16.149  40.133  52.260  1.00 74.02           O  
ATOM   1156  CB  GLU A 145     -17.242  37.745  54.117  1.00 78.35           C  
ATOM   1157  CG  GLU A 145     -17.364  36.340  54.664  1.00 97.81           C  
ATOM   1158  CD  GLU A 145     -16.481  36.134  55.874  1.00110.98           C  
ATOM   1159  OE1 GLU A 145     -15.928  35.015  56.045  1.00109.22           O  
ATOM   1160  OE2 GLU A 145     -16.352  37.106  56.659  1.00118.55           O  
ATOM   1161  N   HIS A 146     -14.892  39.875  54.091  1.00 66.12           N  
ATOM   1162  CA  HIS A 146     -14.538  41.289  54.123  1.00 66.32           C  
ATOM   1163  C   HIS A 146     -13.721  41.767  52.936  1.00 59.70           C  
ATOM   1164  O   HIS A 146     -13.956  42.855  52.413  1.00 51.34           O  
ATOM   1165  CB  HIS A 146     -13.813  41.619  55.426  1.00 72.79           C  
ATOM   1166  CG  HIS A 146     -14.732  41.739  56.600  1.00 82.95           C  
ATOM   1167  ND1 HIS A 146     -15.438  40.668  57.103  1.00 82.39           N  
ATOM   1168  CD2 HIS A 146     -15.100  42.814  57.335  1.00 83.81           C  
ATOM   1169  CE1 HIS A 146     -16.205  41.079  58.097  1.00 83.99           C  
ATOM   1170  NE2 HIS A 146     -16.020  42.378  58.258  1.00 89.02           N  
ATOM   1171  N   VAL A 147     -12.772  40.947  52.506  1.00 52.19           N  
ATOM   1172  CA  VAL A 147     -11.928  41.296  51.379  1.00 50.76           C  
ATOM   1173  C   VAL A 147     -12.657  41.247  50.057  1.00 54.08           C  
ATOM   1174  O   VAL A 147     -12.581  42.172  49.254  1.00 56.91           O  
ATOM   1175  CB  VAL A 147     -10.767  40.350  51.254  1.00 48.07           C  
ATOM   1176  CG1 VAL A 147      -9.826  40.844  50.167  1.00 42.85           C  
ATOM   1177  CG2 VAL A 147     -10.082  40.219  52.583  1.00 45.17           C  
ATOM   1178  N   ALA A 148     -13.348  40.142  49.828  1.00 54.81           N  
ATOM   1179  CA  ALA A 148     -14.089  39.959  48.595  1.00 54.05           C  
ATOM   1180  C   ALA A 148     -15.102  41.074  48.374  1.00 50.54           C  
ATOM   1181  O   ALA A 148     -15.350  41.476  47.240  1.00 49.91           O  
ATOM   1182  CB  ALA A 148     -14.792  38.613  48.618  1.00 55.47           C  
ATOM   1183  N   ARG A 149     -15.691  41.558  49.464  1.00 47.19           N  
ATOM   1184  CA  ARG A 149     -16.674  42.625  49.394  1.00 44.50           C  
ATOM   1185  C   ARG A 149     -16.194  43.768  48.522  1.00 47.19           C  
ATOM   1186  O   ARG A 149     -16.819  44.104  47.510  1.00 44.75           O  
ATOM   1187  CB  ARG A 149     -16.975  43.184  50.783  1.00 46.94           C  
ATOM   1188  CG  ARG A 149     -18.252  42.670  51.401  1.00 49.84           C  
ATOM   1189  CD  ARG A 149     -18.693  43.482  52.626  1.00 64.81           C  
ATOM   1190  NE  ARG A 149     -19.001  44.883  52.324  1.00 59.53           N  
ATOM   1191  CZ  ARG A 149     -18.115  45.873  52.379  1.00 62.80           C  
ATOM   1192  NH1 ARG A 149     -18.489  47.111  52.084  1.00 65.34           N  
ATOM   1193  NH2 ARG A 149     -16.859  45.624  52.744  1.00 65.00           N  
ATOM   1194  N   VAL A 150     -15.078  44.365  48.919  1.00 42.57           N  
ATOM   1195  CA  VAL A 150     -14.540  45.493  48.188  1.00 41.01           C  
ATOM   1196  C   VAL A 150     -14.200  45.137  46.760  1.00 39.94           C  
ATOM   1197  O   VAL A 150     -14.588  45.848  45.839  1.00 43.40           O  
ATOM   1198  CB  VAL A 150     -13.304  46.063  48.901  1.00 42.42           C  
ATOM   1199  CG1 VAL A 150     -13.671  46.398  50.341  1.00 33.75           C  
ATOM   1200  CG2 VAL A 150     -12.149  45.073  48.852  1.00 46.47           C  
ATOM   1201  N   LEU A 151     -13.492  44.027  46.583  1.00 34.62           N  
ATOM   1202  CA  LEU A 151     -13.106  43.565  45.262  1.00 34.86           C  
ATOM   1203  C   LEU A 151     -14.331  43.448  44.326  1.00 38.75           C  
ATOM   1204  O   LEU A 151     -14.290  43.921  43.185  1.00 38.82           O  
ATOM   1205  CB  LEU A 151     -12.352  42.232  45.392  1.00 41.09           C  
ATOM   1206  CG  LEU A 151     -10.942  42.301  46.024  1.00 41.70           C  
ATOM   1207  CD1 LEU A 151     -10.397  40.898  46.280  1.00 44.55           C  
ATOM   1208  CD2 LEU A 151      -9.994  43.067  45.116  1.00 30.56           C  
ATOM   1209  N   TYR A 152     -15.413  42.827  44.802  1.00 39.94           N  
ATOM   1210  CA  TYR A 152     -16.652  42.704  44.012  1.00 42.23           C  
ATOM   1211  C   TYR A 152     -17.094  44.119  43.639  1.00 45.19           C  
ATOM   1212  O   TYR A 152     -17.012  44.539  42.480  1.00 42.87           O  
ATOM   1213  CB  TYR A 152     -17.783  42.070  44.842  1.00 43.04           C  
ATOM   1214  CG  TYR A 152     -19.042  41.731  44.052  1.00 37.12           C  
ATOM   1215  CD1 TYR A 152     -19.026  40.720  43.098  1.00 38.99           C  
ATOM   1216  CD2 TYR A 152     -20.245  42.379  44.294  1.00 28.60           C  
ATOM   1217  CE1 TYR A 152     -20.168  40.352  42.405  1.00 38.00           C  
ATOM   1218  CE2 TYR A 152     -21.404  42.022  43.603  1.00 36.10           C  
ATOM   1219  CZ  TYR A 152     -21.359  41.003  42.661  1.00 47.17           C  
ATOM   1220  OH  TYR A 152     -22.488  40.602  41.964  1.00 46.62           O  
ATOM   1221  N   LEU A 153     -17.580  44.838  44.644  1.00 37.75           N  
ATOM   1222  CA  LEU A 153     -18.018  46.207  44.472  1.00 35.07           C  
ATOM   1223  C   LEU A 153     -17.123  46.952  43.477  1.00 37.72           C  
ATOM   1224  O   LEU A 153     -17.609  47.694  42.619  1.00 35.57           O  
ATOM   1225  CB  LEU A 153     -17.981  46.898  45.827  1.00 30.64           C  
ATOM   1226  CG  LEU A 153     -19.273  47.364  46.502  1.00 31.65           C  
ATOM   1227  CD1 LEU A 153     -20.479  46.499  46.157  1.00 15.97           C  
ATOM   1228  CD2 LEU A 153     -18.999  47.360  47.994  1.00 23.72           C  
ATOM   1229  N   GLY A 154     -15.813  46.742  43.594  1.00 40.75           N  
ATOM   1230  CA  GLY A 154     -14.859  47.392  42.706  1.00 39.11           C  
ATOM   1231  C   GLY A 154     -15.064  47.016  41.254  1.00 39.97           C  
ATOM   1232  O   GLY A 154     -15.234  47.876  40.387  1.00 32.78           O  
ATOM   1233  N   ILE A 155     -15.047  45.721  40.977  1.00 37.59           N  
ATOM   1234  CA  ILE A 155     -15.257  45.278  39.614  1.00 38.07           C  
ATOM   1235  C   ILE A 155     -16.639  45.780  39.166  1.00 41.64           C  
ATOM   1236  O   ILE A 155     -16.791  46.355  38.080  1.00 33.91           O  
ATOM   1237  CB  ILE A 155     -15.129  43.742  39.533  1.00 31.71           C  
ATOM   1238  CG1 ILE A 155     -13.710  43.354  40.025  1.00 28.67           C  
ATOM   1239  CG2 ILE A 155     -15.450  43.261  38.107  1.00 13.27           C  
ATOM   1240  CD1 ILE A 155     -13.446  41.875  40.252  1.00 17.40           C  
ATOM   1241  N   VAL A 156     -17.631  45.614  40.039  1.00 47.33           N  
ATOM   1242  CA  VAL A 156     -19.009  46.048  39.764  1.00 46.82           C  
ATOM   1243  C   VAL A 156     -19.111  47.491  39.254  1.00 43.80           C  
ATOM   1244  O   VAL A 156     -19.646  47.727  38.173  1.00 38.22           O  
ATOM   1245  CB  VAL A 156     -19.902  45.902  41.035  1.00 47.38           C  
ATOM   1246  CG1 VAL A 156     -21.364  46.253  40.709  1.00 32.35           C  
ATOM   1247  CG2 VAL A 156     -19.807  44.478  41.564  1.00 46.32           C  
ATOM   1248  N   GLY A 157     -18.614  48.446  40.033  1.00 34.85           N  
ATOM   1249  CA  GLY A 157     -18.679  49.829  39.610  1.00 39.61           C  
ATOM   1250  C   GLY A 157     -17.908  50.151  38.333  1.00 46.70           C  
ATOM   1251  O   GLY A 157     -18.440  50.800  37.432  1.00 46.39           O  
ATOM   1252  N   ASP A 158     -16.658  49.698  38.247  1.00 49.69           N  
ATOM   1253  CA  ASP A 158     -15.810  49.964  37.083  1.00 50.96           C  
ATOM   1254  C   ASP A 158     -16.375  49.408  35.779  1.00 49.01           C  
ATOM   1255  O   ASP A 158     -15.973  49.836  34.702  1.00 49.51           O  
ATOM   1256  CB  ASP A 158     -14.404  49.391  37.312  1.00 62.24           C  
ATOM   1257  CG  ASP A 158     -13.282  50.389  36.977  1.00 64.85           C  
ATOM   1258  OD1 ASP A 158     -13.115  51.385  37.722  1.00 60.00           O  
ATOM   1259  OD2 ASP A 158     -12.565  50.167  35.976  1.00 65.41           O  
ATOM   1260  N   THR A 159     -17.298  48.455  35.869  1.00 46.08           N  
ATOM   1261  CA  THR A 159     -17.908  47.874  34.670  1.00 45.77           C  
ATOM   1262  C   THR A 159     -19.417  48.090  34.631  1.00 50.41           C  
ATOM   1263  O   THR A 159     -20.106  47.534  33.764  1.00 46.60           O  
ATOM   1264  CB  THR A 159     -17.705  46.365  34.600  1.00 42.76           C  
ATOM   1265  OG1 THR A 159     -18.288  45.761  35.761  1.00 36.98           O  
ATOM   1266  CG2 THR A 159     -16.237  46.025  34.528  1.00 47.02           C  
ATOM   1267  N   GLY A 160     -19.922  48.883  35.574  1.00 46.62           N  
ATOM   1268  CA  GLY A 160     -21.350  49.131  35.651  1.00 53.90           C  
ATOM   1269  C   GLY A 160     -22.145  47.830  35.708  1.00 58.00           C  
ATOM   1270  O   GLY A 160     -23.055  47.615  34.904  1.00 58.69           O  
ATOM   1271  N   ARG A 161     -21.809  46.964  36.663  1.00 54.15           N  
ATOM   1272  CA  ARG A 161     -22.475  45.673  36.812  1.00 46.18           C  
ATOM   1273  C   ARG A 161     -22.319  44.819  35.571  1.00 45.68           C  
ATOM   1274  O   ARG A 161     -23.304  44.419  34.956  1.00 47.91           O  
ATOM   1275  CB  ARG A 161     -23.955  45.850  37.112  1.00 50.16           C  
ATOM   1276  CG  ARG A 161     -24.286  45.635  38.570  1.00 57.44           C  
ATOM   1277  CD  ARG A 161     -25.229  44.457  38.739  1.00 51.09           C  
ATOM   1278  NE  ARG A 161     -26.382  44.581  37.861  1.00 54.95           N  
ATOM   1279  CZ  ARG A 161     -27.205  45.626  37.839  1.00 56.40           C  
ATOM   1280  NH1 ARG A 161     -28.223  45.628  36.989  1.00 60.46           N  
ATOM   1281  NH2 ARG A 161     -27.020  46.659  38.659  1.00 46.55           N  
ATOM   1282  N   PHE A 162     -21.066  44.550  35.212  1.00 46.74           N  
ATOM   1283  CA  PHE A 162     -20.720  43.748  34.047  1.00 45.65           C  
ATOM   1284  C   PHE A 162     -21.542  44.155  32.836  1.00 50.88           C  
ATOM   1285  O   PHE A 162     -22.120  43.309  32.169  1.00 61.89           O  
ATOM   1286  CB  PHE A 162     -20.937  42.263  34.350  1.00 37.40           C  
ATOM   1287  CG  PHE A 162     -20.621  41.896  35.761  1.00 44.59           C  
ATOM   1288  CD1 PHE A 162     -19.311  41.910  36.221  1.00 47.45           C  
ATOM   1289  CD2 PHE A 162     -21.644  41.636  36.666  1.00 48.13           C  
ATOM   1290  CE1 PHE A 162     -19.020  41.678  37.573  1.00 47.54           C  
ATOM   1291  CE2 PHE A 162     -21.366  41.403  38.021  1.00 51.19           C  
ATOM   1292  CZ  PHE A 162     -20.052  41.428  38.474  1.00 44.68           C  
ATOM   1293  N   LEU A 163     -21.608  45.445  32.540  1.00 45.17           N  
ATOM   1294  CA  LEU A 163     -22.375  45.856  31.376  1.00 44.76           C  
ATOM   1295  C   LEU A 163     -21.459  46.404  30.306  1.00 53.75           C  
ATOM   1296  O   LEU A 163     -21.624  46.114  29.117  1.00 49.92           O  
ATOM   1297  CB  LEU A 163     -23.393  46.916  31.754  1.00 44.31           C  
ATOM   1298  CG  LEU A 163     -23.751  47.916  30.654  1.00 36.50           C  
ATOM   1299  CD1 LEU A 163     -24.380  47.252  29.450  1.00 34.06           C  
ATOM   1300  CD2 LEU A 163     -24.689  48.911  31.265  1.00 44.30           C  
ATOM   1301  N   PHE A 164     -20.490  47.199  30.743  1.00 56.93           N  
ATOM   1302  CA  PHE A 164     -19.535  47.824  29.841  1.00 56.96           C  
ATOM   1303  C   PHE A 164     -18.746  46.818  29.029  1.00 57.21           C  
ATOM   1304  O   PHE A 164     -18.670  45.635  29.366  1.00 51.46           O  
ATOM   1305  CB  PHE A 164     -18.582  48.714  30.634  1.00 61.20           C  
ATOM   1306  CG  PHE A 164     -19.275  49.773  31.431  1.00 63.95           C  
ATOM   1307  CD1 PHE A 164     -18.628  50.397  32.490  1.00 66.29           C  
ATOM   1308  CD2 PHE A 164     -20.592  50.122  31.151  1.00 64.66           C  
ATOM   1309  CE1 PHE A 164     -19.289  51.352  33.267  1.00 76.01           C  
ATOM   1310  CE2 PHE A 164     -21.261  51.072  31.918  1.00 68.27           C  
ATOM   1311  CZ  PHE A 164     -20.610  51.688  32.980  1.00 72.50           C  
ATOM   1312  N   SER A 165     -18.163  47.305  27.945  1.00 56.05           N  
ATOM   1313  CA  SER A 165     -17.386  46.459  27.063  1.00 59.58           C  
ATOM   1314  C   SER A 165     -16.138  45.882  27.728  1.00 59.50           C  
ATOM   1315  O   SER A 165     -15.631  44.860  27.287  1.00 53.68           O  
ATOM   1316  CB  SER A 165     -17.012  47.244  25.811  1.00 58.94           C  
ATOM   1317  OG  SER A 165     -16.589  48.548  26.154  1.00 71.99           O  
ATOM   1318  N   ASN A 166     -15.656  46.525  28.788  1.00 59.25           N  
ATOM   1319  CA  ASN A 166     -14.464  46.053  29.499  1.00 54.21           C  
ATOM   1320  C   ASN A 166     -14.722  44.765  30.285  1.00 59.24           C  
ATOM   1321  O   ASN A 166     -13.831  44.270  30.979  1.00 57.15           O  
ATOM   1322  CB  ASN A 166     -13.980  47.111  30.480  1.00 52.58           C  
ATOM   1323  CG  ASN A 166     -15.023  47.451  31.527  1.00 60.42           C  
ATOM   1324  OD1 ASN A 166     -14.713  48.026  32.574  1.00 63.46           O  
ATOM   1325  ND2 ASN A 166     -16.269  47.100  31.250  1.00 65.80           N  
ATOM   1326  N   THR A 167     -15.942  44.240  30.184  1.00 55.30           N  
ATOM   1327  CA  THR A 167     -16.322  43.018  30.879  1.00 47.34           C  
ATOM   1328  C   THR A 167     -15.958  41.806  30.043  1.00 49.08           C  
ATOM   1329  O   THR A 167     -16.499  41.605  28.963  1.00 55.36           O  
ATOM   1330  CB  THR A 167     -17.834  42.997  31.152  1.00 48.25           C  
ATOM   1331  OG1 THR A 167     -18.178  44.105  31.993  1.00 41.72           O  
ATOM   1332  CG2 THR A 167     -18.252  41.684  31.823  1.00 45.31           C  
ATOM   1333  N   SER A 168     -15.032  40.998  30.542  1.00 50.86           N  
ATOM   1334  CA  SER A 168     -14.606  39.805  29.825  1.00 48.98           C  
ATOM   1335  C   SER A 168     -15.093  38.567  30.549  1.00 52.71           C  
ATOM   1336  O   SER A 168     -15.509  38.618  31.708  1.00 45.16           O  
ATOM   1337  CB  SER A 168     -13.098  39.732  29.778  1.00 50.88           C  
ATOM   1338  OG  SER A 168     -12.612  39.302  31.039  1.00 49.94           O  
ATOM   1339  N   PRO A 169     -15.014  37.418  29.880  1.00 57.10           N  
ATOM   1340  CA  PRO A 169     -15.458  36.175  30.499  1.00 62.02           C  
ATOM   1341  C   PRO A 169     -14.650  35.894  31.763  1.00 61.55           C  
ATOM   1342  O   PRO A 169     -15.121  35.215  32.674  1.00 62.78           O  
ATOM   1343  CB  PRO A 169     -15.221  35.141  29.400  1.00 63.65           C  
ATOM   1344  CG  PRO A 169     -14.038  35.695  28.673  1.00 69.05           C  
ATOM   1345  CD  PRO A 169     -14.404  37.160  28.566  1.00 62.61           C  
ATOM   1346  N   HIS A 170     -13.430  36.413  31.826  1.00 59.81           N  
ATOM   1347  CA  HIS A 170     -12.616  36.200  33.013  1.00 53.42           C  
ATOM   1348  C   HIS A 170     -13.203  37.083  34.100  1.00 50.72           C  
ATOM   1349  O   HIS A 170     -13.362  36.653  35.241  1.00 54.10           O  
ATOM   1350  CB  HIS A 170     -11.158  36.579  32.740  1.00 50.38           C  
ATOM   1351  CG  HIS A 170     -10.277  36.528  33.950  1.00 52.87           C  
ATOM   1352  ND1 HIS A 170     -10.008  35.360  34.632  1.00 59.38           N  
ATOM   1353  CD2 HIS A 170      -9.600  37.507  34.599  1.00 53.59           C  
ATOM   1354  CE1 HIS A 170      -9.202  35.622  35.647  1.00 61.98           C  
ATOM   1355  NE2 HIS A 170      -8.940  36.917  35.649  1.00 55.91           N  
ATOM   1356  N   THR A 171     -13.551  38.312  33.738  1.00 46.42           N  
ATOM   1357  CA  THR A 171     -14.116  39.225  34.707  1.00 44.95           C  
ATOM   1358  C   THR A 171     -15.282  38.544  35.376  1.00 45.73           C  
ATOM   1359  O   THR A 171     -15.372  38.514  36.591  1.00 52.44           O  
ATOM   1360  CB  THR A 171     -14.600  40.504  34.051  1.00 45.81           C  
ATOM   1361  OG1 THR A 171     -13.566  41.021  33.209  1.00 51.45           O  
ATOM   1362  CG2 THR A 171     -14.943  41.540  35.104  1.00 41.15           C  
HETATM 1363  N   MSE A 172     -16.178  37.979  34.590  1.00 44.38           N  
HETATM 1364  CA  MSE A 172     -17.309  37.290  35.179  1.00 47.73           C  
HETATM 1365  C   MSE A 172     -16.824  36.249  36.164  1.00 43.93           C  
HETATM 1366  O   MSE A 172     -17.240  36.237  37.311  1.00 46.91           O  
HETATM 1367  CB  MSE A 172     -18.114  36.604  34.096  1.00 65.03           C  
HETATM 1368  CG  MSE A 172     -18.583  37.561  33.029  1.00 82.03           C  
HETATM 1369 SE   MSE A 172     -20.424  38.036  33.267  1.00 97.85          SE  
HETATM 1370  CE  MSE A 172     -20.279  38.998  34.934  1.00 84.24           C  
ATOM   1371  N   GLU A 173     -15.932  35.378  35.708  1.00 46.37           N  
ATOM   1372  CA  GLU A 173     -15.408  34.307  36.543  1.00 45.36           C  
ATOM   1373  C   GLU A 173     -14.909  34.801  37.885  1.00 42.74           C  
ATOM   1374  O   GLU A 173     -15.163  34.184  38.919  1.00 42.35           O  
ATOM   1375  CB  GLU A 173     -14.292  33.596  35.805  1.00 53.95           C  
ATOM   1376  CG  GLU A 173     -13.725  32.395  36.516  1.00 71.38           C  
ATOM   1377  CD  GLU A 173     -12.651  31.734  35.676  1.00 86.39           C  
ATOM   1378  OE1 GLU A 173     -11.660  32.435  35.330  1.00 84.83           O  
ATOM   1379  OE2 GLU A 173     -12.801  30.524  35.358  1.00 97.04           O  
ATOM   1380  N   VAL A 174     -14.185  35.909  37.868  1.00 41.37           N  
ATOM   1381  CA  VAL A 174     -13.680  36.478  39.105  1.00 42.12           C  
ATOM   1382  C   VAL A 174     -14.887  36.865  39.967  1.00 39.88           C  
ATOM   1383  O   VAL A 174     -14.948  36.535  41.145  1.00 41.83           O  
ATOM   1384  CB  VAL A 174     -12.794  37.705  38.820  1.00 37.87           C  
ATOM   1385  CG1 VAL A 174     -12.328  38.331  40.113  1.00 28.60           C  
ATOM   1386  CG2 VAL A 174     -11.610  37.281  37.980  1.00 30.57           C  
ATOM   1387  N   ALA A 175     -15.861  37.539  39.363  1.00 38.35           N  
ATOM   1388  CA  ALA A 175     -17.069  37.944  40.078  1.00 42.43           C  
ATOM   1389  C   ALA A 175     -17.697  36.695  40.667  1.00 42.12           C  
ATOM   1390  O   ALA A 175     -18.117  36.670  41.823  1.00 43.73           O  
ATOM   1391  CB  ALA A 175     -18.053  38.621  39.124  1.00 31.16           C  
ATOM   1392  N   SER A 176     -17.764  35.660  39.842  1.00 40.53           N  
ATOM   1393  CA  SER A 176     -18.316  34.390  40.254  1.00 43.15           C  
ATOM   1394  C   SER A 176     -17.638  33.928  41.536  1.00 44.01           C  
ATOM   1395  O   SER A 176     -18.288  33.631  42.538  1.00 38.42           O  
ATOM   1396  CB  SER A 176     -18.097  33.355  39.154  1.00 35.02           C  
ATOM   1397  OG  SER A 176     -18.333  32.051  39.633  1.00 43.45           O  
ATOM   1398  N   GLN A 177     -16.315  33.881  41.505  1.00 44.69           N  
ATOM   1399  CA  GLN A 177     -15.558  33.439  42.661  1.00 51.25           C  
ATOM   1400  C   GLN A 177     -15.716  34.260  43.930  1.00 52.55           C  
ATOM   1401  O   GLN A 177     -15.714  33.699  45.023  1.00 54.25           O  
ATOM   1402  CB  GLN A 177     -14.089  33.338  42.294  1.00 50.54           C  
ATOM   1403  CG  GLN A 177     -13.800  32.088  41.517  1.00 53.14           C  
ATOM   1404  CD  GLN A 177     -12.347  31.938  41.211  1.00 55.48           C  
ATOM   1405  OE1 GLN A 177     -11.820  32.634  40.344  1.00 65.69           O  
ATOM   1406  NE2 GLN A 177     -11.671  31.042  41.935  1.00 49.85           N  
ATOM   1407  N   LEU A 178     -15.851  35.576  43.792  1.00 50.41           N  
ATOM   1408  CA  LEU A 178     -16.010  36.437  44.953  1.00 44.61           C  
ATOM   1409  C   LEU A 178     -17.331  36.190  45.674  1.00 46.67           C  
ATOM   1410  O   LEU A 178     -17.364  36.172  46.907  1.00 48.73           O  
ATOM   1411  CB  LEU A 178     -15.911  37.912  44.553  1.00 42.75           C  
ATOM   1412  CG  LEU A 178     -14.547  38.615  44.344  1.00 49.23           C  
ATOM   1413  CD1 LEU A 178     -13.523  38.061  45.306  1.00 38.91           C  
ATOM   1414  CD2 LEU A 178     -14.071  38.448  42.921  1.00 47.44           C  
ATOM   1415  N   LEU A 179     -18.407  35.985  44.910  1.00 47.19           N  
ATOM   1416  CA  LEU A 179     -19.747  35.737  45.477  1.00 49.27           C  
ATOM   1417  C   LEU A 179     -19.801  34.487  46.340  1.00 45.36           C  
ATOM   1418  O   LEU A 179     -20.709  34.331  47.152  1.00 44.96           O  
ATOM   1419  CB  LEU A 179     -20.800  35.617  44.365  1.00 51.59           C  
ATOM   1420  CG  LEU A 179     -21.241  36.864  43.588  1.00 43.62           C  
ATOM   1421  CD1 LEU A 179     -22.290  36.485  42.546  1.00 37.70           C  
ATOM   1422  CD2 LEU A 179     -21.798  37.876  44.567  1.00 48.05           C  
ATOM   1423  N   ALA A 180     -18.831  33.599  46.145  1.00 48.17           N  
ATOM   1424  CA  ALA A 180     -18.755  32.372  46.924  1.00 51.93           C  
ATOM   1425  C   ALA A 180     -18.739  32.776  48.397  1.00 56.94           C  
ATOM   1426  O   ALA A 180     -19.457  32.201  49.221  1.00 59.02           O  
ATOM   1427  CB  ALA A 180     -17.494  31.601  46.570  1.00 50.32           C  
ATOM   1428  N   TYR A 181     -17.937  33.791  48.708  1.00 55.10           N  
ATOM   1429  CA  TYR A 181     -17.821  34.314  50.068  1.00 60.16           C  
ATOM   1430  C   TYR A 181     -19.108  34.977  50.561  1.00 65.05           C  
ATOM   1431  O   TYR A 181     -19.690  35.816  49.858  1.00 62.03           O  
ATOM   1432  CB  TYR A 181     -16.696  35.336  50.128  1.00 57.38           C  
ATOM   1433  CG  TYR A 181     -15.399  34.765  49.679  1.00 66.15           C  
ATOM   1434  CD1 TYR A 181     -14.770  33.776  50.429  1.00 73.30           C  
ATOM   1435  CD2 TYR A 181     -14.807  35.179  48.492  1.00 65.16           C  
ATOM   1436  CE1 TYR A 181     -13.582  33.207  50.013  1.00 76.31           C  
ATOM   1437  CE2 TYR A 181     -13.611  34.615  48.062  1.00 71.71           C  
ATOM   1438  CZ  TYR A 181     -13.004  33.626  48.832  1.00 70.12           C  
ATOM   1439  OH  TYR A 181     -11.826  33.047  48.431  1.00 63.89           O  
ATOM   1440  N   PRO A 182     -19.557  34.626  51.786  1.00 65.29           N  
ATOM   1441  CA  PRO A 182     -20.781  35.197  52.367  1.00 59.65           C  
ATOM   1442  C   PRO A 182     -20.737  36.701  52.638  1.00 60.86           C  
ATOM   1443  O   PRO A 182     -19.973  37.159  53.485  1.00 63.16           O  
ATOM   1444  CB  PRO A 182     -20.949  34.399  53.654  1.00 52.86           C  
ATOM   1445  CG  PRO A 182     -19.540  34.081  54.031  1.00 43.66           C  
ATOM   1446  CD  PRO A 182     -18.953  33.651  52.716  1.00 49.88           C  
ATOM   1447  N   PHE A 183     -21.563  37.466  51.930  1.00 59.03           N  
ATOM   1448  CA  PHE A 183     -21.592  38.908  52.143  1.00 66.01           C  
ATOM   1449  C   PHE A 183     -22.831  39.567  51.533  1.00 70.35           C  
ATOM   1450  O   PHE A 183     -23.104  40.744  51.777  1.00 73.42           O  
ATOM   1451  CB  PHE A 183     -20.314  39.556  51.594  1.00 56.94           C  
ATOM   1452  CG  PHE A 183     -20.246  39.594  50.104  1.00 56.60           C  
ATOM   1453  CD1 PHE A 183     -20.831  38.594  49.346  1.00 68.08           C  
ATOM   1454  CD2 PHE A 183     -19.581  40.620  49.456  1.00 53.07           C  
ATOM   1455  CE1 PHE A 183     -20.754  38.620  47.964  1.00 75.20           C  
ATOM   1456  CE2 PHE A 183     -19.495  40.655  48.076  1.00 57.20           C  
ATOM   1457  CZ  PHE A 183     -20.080  39.658  47.327  1.00 66.08           C  
ATOM   1458  N   ASN A 184     -23.581  38.796  50.751  1.00 71.30           N  
ATOM   1459  CA  ASN A 184     -24.809  39.282  50.113  1.00 73.70           C  
ATOM   1460  C   ASN A 184     -24.589  40.457  49.175  1.00 71.42           C  
ATOM   1461  O   ASN A 184     -24.536  41.619  49.591  1.00 54.65           O  
ATOM   1462  CB  ASN A 184     -25.849  39.661  51.176  1.00 71.08           C  
ATOM   1463  CG  ASN A 184     -27.135  40.213  50.570  1.00 70.40           C  
ATOM   1464  OD1 ASN A 184     -27.420  40.013  49.383  1.00 70.05           O  
ATOM   1465  ND2 ASN A 184     -27.929  40.894  51.393  1.00 61.10           N  
ATOM   1466  N   HIS A 185     -24.479  40.143  47.893  1.00 72.78           N  
ATOM   1467  CA  HIS A 185     -24.263  41.168  46.896  1.00 75.00           C  
ATOM   1468  C   HIS A 185     -25.486  42.059  46.748  1.00 74.61           C  
ATOM   1469  O   HIS A 185     -25.351  43.274  46.641  1.00 82.41           O  
ATOM   1470  CB  HIS A 185     -23.930  40.529  45.550  1.00 67.42           C  
ATOM   1471  CG  HIS A 185     -25.060  39.750  44.966  1.00 68.60           C  
ATOM   1472  ND1 HIS A 185     -25.780  38.828  45.697  1.00 78.14           N  
ATOM   1473  CD2 HIS A 185     -25.599  39.751  43.724  1.00 66.91           C  
ATOM   1474  CE1 HIS A 185     -26.714  38.295  44.929  1.00 81.29           C  
ATOM   1475  NE2 HIS A 185     -26.626  38.839  43.728  1.00 75.86           N  
ATOM   1476  N   ASN A 186     -26.680  41.470  46.758  1.00 74.68           N  
ATOM   1477  CA  ASN A 186     -27.903  42.255  46.583  1.00 72.28           C  
ATOM   1478  C   ASN A 186     -27.945  43.474  47.502  1.00 68.37           C  
ATOM   1479  O   ASN A 186     -28.248  44.585  47.057  1.00 69.15           O  
ATOM   1480  CB  ASN A 186     -29.144  41.388  46.811  1.00 75.34           C  
ATOM   1481  CG  ASN A 186     -30.366  41.924  46.078  1.00 79.73           C  
ATOM   1482  OD1 ASN A 186     -31.451  41.343  46.142  1.00 85.68           O  
ATOM   1483  ND2 ASN A 186     -30.191  43.038  45.369  1.00 67.78           N  
ATOM   1484  N   ALA A 187     -27.633  43.256  48.778  1.00 59.88           N  
ATOM   1485  CA  ALA A 187     -27.607  44.325  49.770  1.00 50.95           C  
ATOM   1486  C   ALA A 187     -26.554  45.356  49.393  1.00 53.79           C  
ATOM   1487  O   ALA A 187     -26.871  46.511  49.102  1.00 46.78           O  
ATOM   1488  CB  ALA A 187     -27.292  43.751  51.129  1.00 42.97           C  
ATOM   1489  N   GLU A 188     -25.297  44.919  49.396  1.00 56.00           N  
ATOM   1490  CA  GLU A 188     -24.172  45.780  49.056  1.00 55.31           C  
ATOM   1491  C   GLU A 188     -24.460  46.573  47.793  1.00 54.26           C  
ATOM   1492  O   GLU A 188     -24.240  47.775  47.757  1.00 54.71           O  
ATOM   1493  CB  GLU A 188     -22.901  44.952  48.852  1.00 55.15           C  
ATOM   1494  CG  GLU A 188     -22.385  44.213  50.092  1.00 64.93           C  
ATOM   1495  CD  GLU A 188     -21.933  45.133  51.226  1.00 66.04           C  
ATOM   1496  OE1 GLU A 188     -21.642  46.321  50.962  1.00 66.83           O  
ATOM   1497  OE2 GLU A 188     -21.857  44.654  52.383  1.00 69.73           O  
ATOM   1498  N   LEU A 189     -24.956  45.896  46.762  1.00 59.14           N  
ATOM   1499  CA  LEU A 189     -25.267  46.555  45.500  1.00 61.29           C  
ATOM   1500  C   LEU A 189     -26.250  47.712  45.655  1.00 66.88           C  
ATOM   1501  O   LEU A 189     -26.008  48.810  45.148  1.00 67.50           O  
ATOM   1502  CB  LEU A 189     -25.807  45.540  44.490  1.00 56.67           C  
ATOM   1503  CG  LEU A 189     -24.752  44.592  43.896  1.00 66.65           C  
ATOM   1504  CD1 LEU A 189     -25.413  43.683  42.859  1.00 66.90           C  
ATOM   1505  CD2 LEU A 189     -23.625  45.395  43.250  1.00 56.89           C  
ATOM   1506  N   ASN A 190     -27.349  47.471  46.364  1.00 67.77           N  
ATOM   1507  CA  ASN A 190     -28.364  48.499  46.588  1.00 67.73           C  
ATOM   1508  C   ASN A 190     -27.833  49.738  47.289  1.00 68.10           C  
ATOM   1509  O   ASN A 190     -28.058  50.862  46.840  1.00 67.95           O  
ATOM   1510  CB  ASN A 190     -29.512  47.897  47.376  1.00 69.75           C  
ATOM   1511  CG  ASN A 190     -30.277  46.896  46.560  1.00 78.15           C  
ATOM   1512  OD1 ASN A 190     -30.867  45.955  47.092  1.00 83.90           O  
ATOM   1513  ND2 ASN A 190     -30.274  47.093  45.240  1.00 70.03           N  
ATOM   1514  N   LYS A 191     -27.131  49.532  48.394  1.00 66.30           N  
ATOM   1515  CA  LYS A 191     -26.564  50.648  49.124  1.00 64.42           C  
ATOM   1516  C   LYS A 191     -25.640  51.448  48.206  1.00 67.84           C  
ATOM   1517  O   LYS A 191     -25.321  52.599  48.488  1.00 70.92           O  
ATOM   1518  CB  LYS A 191     -25.789  50.131  50.335  1.00 67.59           C  
ATOM   1519  CG  LYS A 191     -25.214  51.204  51.253  1.00 70.92           C  
ATOM   1520  CD  LYS A 191     -24.850  50.599  52.614  1.00 91.36           C  
ATOM   1521  CE  LYS A 191     -23.928  49.368  52.472  1.00 99.24           C  
ATOM   1522  NZ  LYS A 191     -23.724  48.603  53.750  1.00100.87           N  
HETATM 1523  N   MSE A 192     -25.210  50.846  47.105  1.00 67.61           N  
HETATM 1524  CA  MSE A 192     -24.326  51.544  46.183  1.00 67.01           C  
HETATM 1525  C   MSE A 192     -25.151  52.237  45.111  1.00 67.03           C  
HETATM 1526  O   MSE A 192     -24.734  53.240  44.529  1.00 66.39           O  
HETATM 1527  CB  MSE A 192     -23.355  50.556  45.537  1.00 75.71           C  
HETATM 1528  CG  MSE A 192     -22.297  51.217  44.656  1.00 91.79           C  
HETATM 1529 SE   MSE A 192     -21.023  49.980  43.834  1.00100.67          SE  
HETATM 1530  CE  MSE A 192     -22.115  49.432  42.310  1.00100.81           C  
ATOM   1531  N   SER A 193     -26.338  51.694  44.872  1.00 64.28           N  
ATOM   1532  CA  SER A 193     -27.243  52.220  43.864  1.00 57.41           C  
ATOM   1533  C   SER A 193     -28.207  53.254  44.403  1.00 57.39           C  
ATOM   1534  O   SER A 193     -28.960  53.859  43.641  1.00 54.71           O  
ATOM   1535  CB  SER A 193     -28.025  51.071  43.236  1.00 56.14           C  
ATOM   1536  OG  SER A 193     -27.165  50.232  42.500  1.00 58.75           O  
ATOM   1537  N   GLU A 194     -28.191  53.456  45.713  1.00 59.64           N  
ATOM   1538  CA  GLU A 194     -29.082  54.437  46.310  1.00 72.74           C  
ATOM   1539  C   GLU A 194     -29.002  55.762  45.564  1.00 76.44           C  
ATOM   1540  O   GLU A 194     -27.998  56.057  44.919  1.00 80.44           O  
ATOM   1541  CB  GLU A 194     -28.733  54.676  47.773  1.00 70.83           C  
ATOM   1542  CG  GLU A 194     -29.050  53.518  48.683  1.00 83.96           C  
ATOM   1543  CD  GLU A 194     -29.139  53.959  50.132  1.00 93.30           C  
ATOM   1544  OE1 GLU A 194     -28.303  54.799  50.538  1.00 92.18           O  
ATOM   1545  OE2 GLU A 194     -30.032  53.463  50.865  1.00 94.09           O  
ATOM   1546  N   LYS A 195     -30.066  56.555  45.653  1.00 77.20           N  
ATOM   1547  CA  LYS A 195     -30.129  57.855  44.995  1.00 74.51           C  
ATOM   1548  C   LYS A 195     -30.772  58.869  45.939  1.00 73.48           C  
ATOM   1549  O   LYS A 195     -31.488  58.495  46.869  1.00 74.71           O  
ATOM   1550  CB  LYS A 195     -30.940  57.740  43.703  1.00 73.48           C  
ATOM   1551  CG  LYS A 195     -30.376  56.732  42.716  1.00 82.44           C  
ATOM   1552  CD  LYS A 195     -31.273  56.582  41.501  1.00 92.74           C  
ATOM   1553  CE  LYS A 195     -30.714  55.564  40.516  1.00 96.84           C  
ATOM   1554  NZ  LYS A 195     -31.647  55.337  39.371  1.00100.50           N  
ATOM   1555  N   ASP A 196     -30.511  60.151  45.702  1.00 71.14           N  
ATOM   1556  CA  ASP A 196     -31.070  61.212  46.537  1.00 68.84           C  
ATOM   1557  C   ASP A 196     -32.406  61.692  45.971  1.00 67.29           C  
ATOM   1558  O   ASP A 196     -32.462  62.218  44.856  1.00 66.17           O  
ATOM   1559  CB  ASP A 196     -30.090  62.391  46.615  1.00 73.90           C  
ATOM   1560  CG  ASP A 196     -30.495  63.432  47.657  1.00 76.08           C  
ATOM   1561  OD1 ASP A 196     -29.755  64.423  47.831  1.00 82.05           O  
ATOM   1562  OD2 ASP A 196     -31.546  63.265  48.307  1.00 80.58           O  
ATOM   1563  N   PRO A 197     -33.504  61.515  46.730  1.00 63.73           N  
ATOM   1564  CA  PRO A 197     -34.813  61.955  46.247  1.00 59.59           C  
ATOM   1565  C   PRO A 197     -34.824  63.443  45.934  1.00 62.82           C  
ATOM   1566  O   PRO A 197     -35.582  63.897  45.080  1.00 65.24           O  
ATOM   1567  CB  PRO A 197     -35.740  61.590  47.400  1.00 54.50           C  
ATOM   1568  CG  PRO A 197     -34.847  61.656  48.594  1.00 51.27           C  
ATOM   1569  CD  PRO A 197     -33.612  60.975  48.096  1.00 62.10           C  
ATOM   1570  N   LYS A 198     -33.974  64.192  46.630  1.00 66.06           N  
ATOM   1571  CA  LYS A 198     -33.865  65.636  46.435  1.00 64.18           C  
ATOM   1572  C   LYS A 198     -33.664  66.002  44.966  1.00 60.63           C  
ATOM   1573  O   LYS A 198     -34.316  66.900  44.446  1.00 61.21           O  
ATOM   1574  CB  LYS A 198     -32.692  66.191  47.247  1.00 68.33           C  
ATOM   1575  CG  LYS A 198     -32.871  66.170  48.763  1.00 78.56           C  
ATOM   1576  CD  LYS A 198     -33.993  67.110  49.212  1.00 85.01           C  
ATOM   1577  CE  LYS A 198     -33.713  67.728  50.587  1.00 80.87           C  
ATOM   1578  NZ  LYS A 198     -33.496  66.718  51.665  1.00 83.78           N  
ATOM   1579  N   LEU A 199     -32.762  65.297  44.300  1.00 57.43           N  
ATOM   1580  CA  LEU A 199     -32.467  65.573  42.905  1.00 55.75           C  
ATOM   1581  C   LEU A 199     -33.443  64.924  41.934  1.00 60.25           C  
ATOM   1582  O   LEU A 199     -33.470  65.267  40.752  1.00 64.26           O  
ATOM   1583  CB  LEU A 199     -31.054  65.092  42.582  1.00 58.76           C  
ATOM   1584  CG  LEU A 199     -30.006  65.335  43.669  1.00 59.32           C  
ATOM   1585  CD1 LEU A 199     -28.735  64.580  43.330  1.00 60.52           C  
ATOM   1586  CD2 LEU A 199     -29.744  66.816  43.808  1.00 61.41           C  
HETATM 1587  N   MSE A 200     -34.245  63.985  42.414  1.00 63.64           N  
HETATM 1588  CA  MSE A 200     -35.187  63.284  41.536  1.00 67.05           C  
HETATM 1589  C   MSE A 200     -36.189  64.131  40.776  1.00 63.36           C  
HETATM 1590  O   MSE A 200     -36.500  63.827  39.627  1.00 50.96           O  
HETATM 1591  CB  MSE A 200     -35.955  62.249  42.333  1.00 78.89           C  
HETATM 1592  CG  MSE A 200     -36.002  60.909  41.663  1.00 86.86           C  
HETATM 1593 SE   MSE A 200     -35.833  59.594  43.052  1.00 98.17          SE  
HETATM 1594  CE  MSE A 200     -33.929  59.743  43.354  1.00 98.92           C  
ATOM   1595  N   PRO A 201     -36.736  65.180  41.427  1.00 64.40           N  
ATOM   1596  CA  PRO A 201     -37.714  66.076  40.803  1.00 58.00           C  
ATOM   1597  C   PRO A 201     -37.096  66.748  39.585  1.00 60.78           C  
ATOM   1598  O   PRO A 201     -37.722  66.822  38.523  1.00 51.80           O  
ATOM   1599  CB  PRO A 201     -38.024  67.064  41.922  1.00 59.44           C  
ATOM   1600  CG  PRO A 201     -36.735  67.107  42.691  1.00 50.74           C  
ATOM   1601  CD  PRO A 201     -36.413  65.653  42.788  1.00 53.32           C  
ATOM   1602  N   PHE A 202     -35.864  67.237  39.763  1.00 60.57           N  
ATOM   1603  CA  PHE A 202     -35.109  67.889  38.692  1.00 60.04           C  
ATOM   1604  C   PHE A 202     -34.909  66.920  37.523  1.00 57.78           C  
ATOM   1605  O   PHE A 202     -35.141  67.269  36.364  1.00 54.08           O  
ATOM   1606  CB  PHE A 202     -33.737  68.368  39.189  1.00 51.39           C  
ATOM   1607  CG  PHE A 202     -32.757  68.649  38.070  1.00 58.93           C  
ATOM   1608  CD1 PHE A 202     -33.035  69.621  37.109  1.00 61.42           C  
ATOM   1609  CD2 PHE A 202     -31.585  67.902  37.943  1.00 55.18           C  
ATOM   1610  CE1 PHE A 202     -32.165  69.839  36.036  1.00 58.44           C  
ATOM   1611  CE2 PHE A 202     -30.711  68.114  36.874  1.00 50.99           C  
ATOM   1612  CZ  PHE A 202     -31.001  69.081  35.921  1.00 54.10           C  
ATOM   1613  N   GLN A 203     -34.477  65.703  37.849  1.00 55.23           N  
ATOM   1614  CA  GLN A 203     -34.248  64.659  36.861  1.00 53.24           C  
ATOM   1615  C   GLN A 203     -35.496  64.464  36.016  1.00 52.09           C  
ATOM   1616  O   GLN A 203     -35.419  64.056  34.858  1.00 42.42           O  
ATOM   1617  CB  GLN A 203     -33.891  63.343  37.560  1.00 53.90           C  
ATOM   1618  CG  GLN A 203     -33.790  62.157  36.610  1.00 52.64           C  
ATOM   1619  CD  GLN A 203     -33.247  60.909  37.271  1.00 51.79           C  
ATOM   1620  OE1 GLN A 203     -33.805  60.414  38.244  1.00 56.96           O  
ATOM   1621  NE2 GLN A 203     -32.152  60.388  36.737  1.00 59.63           N  
ATOM   1622  N   GLY A 204     -36.648  64.749  36.618  1.00 55.87           N  
ATOM   1623  CA  GLY A 204     -37.913  64.614  35.923  1.00 52.17           C  
ATOM   1624  C   GLY A 204     -38.006  65.701  34.880  1.00 57.29           C  
ATOM   1625  O   GLY A 204     -38.595  65.514  33.818  1.00 56.77           O  
ATOM   1626  N   TYR A 205     -37.412  66.846  35.202  1.00 56.55           N  
ATOM   1627  CA  TYR A 205     -37.382  67.997  34.308  1.00 62.95           C  
ATOM   1628  C   TYR A 205     -36.585  67.656  33.047  1.00 58.05           C  
ATOM   1629  O   TYR A 205     -36.986  67.953  31.921  1.00 53.70           O  
ATOM   1630  CB  TYR A 205     -36.725  69.179  35.017  1.00 65.98           C  
ATOM   1631  CG  TYR A 205     -36.556  70.373  34.115  1.00 74.54           C  
ATOM   1632  CD1 TYR A 205     -37.656  71.133  33.721  1.00 69.57           C  
ATOM   1633  CD2 TYR A 205     -35.302  70.727  33.623  1.00 73.09           C  
ATOM   1634  CE1 TYR A 205     -37.502  72.214  32.858  1.00 72.45           C  
ATOM   1635  CE2 TYR A 205     -35.148  71.805  32.762  1.00 70.71           C  
ATOM   1636  CZ  TYR A 205     -36.246  72.538  32.387  1.00 61.46           C  
ATOM   1637  OH  TYR A 205     -36.092  73.597  31.539  1.00 60.65           O  
ATOM   1638  N   VAL A 206     -35.432  67.043  33.267  1.00 51.80           N  
ATOM   1639  CA  VAL A 206     -34.571  66.626  32.189  1.00 42.77           C  
ATOM   1640  C   VAL A 206     -35.336  65.708  31.264  1.00 45.99           C  
ATOM   1641  O   VAL A 206     -35.191  65.774  30.048  1.00 49.76           O  
ATOM   1642  CB  VAL A 206     -33.393  65.854  32.732  1.00 39.51           C  
ATOM   1643  CG1 VAL A 206     -32.511  65.397  31.597  1.00 31.56           C  
ATOM   1644  CG2 VAL A 206     -32.637  66.717  33.731  1.00 38.96           C  
ATOM   1645  N   LEU A 207     -36.159  64.849  31.845  1.00 50.82           N  
ATOM   1646  CA  LEU A 207     -36.938  63.894  31.067  1.00 54.35           C  
ATOM   1647  C   LEU A 207     -38.090  64.543  30.328  1.00 56.24           C  
ATOM   1648  O   LEU A 207     -38.559  64.017  29.316  1.00 48.22           O  
ATOM   1649  CB  LEU A 207     -37.464  62.793  31.989  1.00 57.16           C  
ATOM   1650  CG  LEU A 207     -36.369  62.011  32.718  1.00 50.08           C  
ATOM   1651  CD1 LEU A 207     -36.959  61.230  33.846  1.00 45.90           C  
ATOM   1652  CD2 LEU A 207     -35.673  61.096  31.739  1.00 62.57           C  
ATOM   1653  N   GLN A 208     -38.537  65.687  30.847  1.00 58.46           N  
ATOM   1654  CA  GLN A 208     -39.645  66.445  30.260  1.00 63.18           C  
ATOM   1655  C   GLN A 208     -39.170  67.515  29.260  1.00 59.12           C  
ATOM   1656  O   GLN A 208     -39.978  68.115  28.546  1.00 54.97           O  
ATOM   1657  CB  GLN A 208     -40.479  67.105  31.371  1.00 67.64           C  
ATOM   1658  CG  GLN A 208     -41.339  66.144  32.208  1.00 71.65           C  
ATOM   1659  CD  GLN A 208     -42.084  66.842  33.355  1.00 78.77           C  
ATOM   1660  OE1 GLN A 208     -42.869  66.214  34.070  1.00 80.99           O  
ATOM   1661  NE2 GLN A 208     -41.835  68.141  33.532  1.00 82.62           N  
ATOM   1662  N   ASN A 209     -37.861  67.740  29.207  1.00 56.61           N  
ATOM   1663  CA  ASN A 209     -37.297  68.715  28.292  1.00 56.97           C  
ATOM   1664  C   ASN A 209     -36.138  68.120  27.514  1.00 56.08           C  
ATOM   1665  O   ASN A 209     -34.971  68.291  27.858  1.00 54.22           O  
ATOM   1666  CB  ASN A 209     -36.832  69.946  29.061  1.00 63.96           C  
ATOM   1667  CG  ASN A 209     -37.903  70.497  29.959  1.00 60.37           C  
ATOM   1668  OD1 ASN A 209     -38.205  69.907  30.989  1.00 59.41           O  
ATOM   1669  ND2 ASN A 209     -38.507  71.621  29.564  1.00 53.17           N  
ATOM   1670  N   PHE A 210     -36.483  67.402  26.461  1.00 63.99           N  
ATOM   1671  CA  PHE A 210     -35.487  66.771  25.628  1.00 70.59           C  
ATOM   1672  C   PHE A 210     -35.109  67.634  24.478  1.00 71.36           C  
ATOM   1673  O   PHE A 210     -35.199  68.856  24.530  1.00 76.38           O  
ATOM   1674  CB  PHE A 210     -36.017  65.474  25.054  1.00 79.02           C  
ATOM   1675  CG  PHE A 210     -35.969  64.369  25.994  1.00 78.35           C  
ATOM   1676  CD1 PHE A 210     -36.689  63.214  25.755  1.00 71.95           C  
ATOM   1677  CD2 PHE A 210     -35.222  64.496  27.156  1.00 76.31           C  
ATOM   1678  CE1 PHE A 210     -36.675  62.197  26.669  1.00 95.79           C  
ATOM   1679  CE2 PHE A 210     -35.197  63.494  28.079  1.00 94.10           C  
ATOM   1680  CZ  PHE A 210     -35.925  62.332  27.847  1.00102.08           C  
ATOM   1681  N   GLU A 211     -34.719  66.951  23.414  1.00 68.61           N  
ATOM   1682  CA  GLU A 211     -34.319  67.598  22.200  1.00 65.20           C  
ATOM   1683  C   GLU A 211     -33.790  66.492  21.294  1.00 65.81           C  
ATOM   1684  O   GLU A 211     -32.589  66.425  21.034  1.00 71.28           O  
ATOM   1685  CB  GLU A 211     -33.225  68.627  22.512  1.00 73.07           C  
ATOM   1686  CG  GLU A 211     -33.252  69.890  21.648  1.00 76.81           C  
ATOM   1687  CD  GLU A 211     -33.771  71.118  22.387  1.00 75.05           C  
ATOM   1688  OE1 GLU A 211     -33.088  71.616  23.314  1.00 62.92           O  
ATOM   1689  OE2 GLU A 211     -34.868  71.594  22.030  1.00 85.33           O  
ATOM   1690  N   LEU A 212     -34.670  65.604  20.836  1.00 56.49           N  
ATOM   1691  CA  LEU A 212     -34.225  64.531  19.948  1.00 61.62           C  
ATOM   1692  C   LEU A 212     -34.401  64.861  18.484  1.00 61.16           C  
ATOM   1693  O   LEU A 212     -35.354  65.526  18.097  1.00 57.06           O  
ATOM   1694  CB  LEU A 212     -34.969  63.230  20.211  1.00 57.92           C  
ATOM   1695  CG  LEU A 212     -34.566  62.445  21.435  1.00 68.34           C  
ATOM   1696  CD1 LEU A 212     -35.219  63.051  22.674  1.00 78.43           C  
ATOM   1697  CD2 LEU A 212     -35.019  61.008  21.246  1.00 72.24           C  
ATOM   1698  N   SER A 213     -33.471  64.384  17.671  1.00 66.28           N  
ATOM   1699  CA  SER A 213     -33.543  64.596  16.242  1.00 82.97           C  
ATOM   1700  C   SER A 213     -34.742  63.799  15.728  1.00 90.43           C  
ATOM   1701  O   SER A 213     -35.287  62.955  16.444  1.00 92.54           O  
ATOM   1702  CB  SER A 213     -32.255  64.096  15.571  1.00 89.42           C  
ATOM   1703  OG  SER A 213     -32.372  64.058  14.147  1.00 97.73           O  
ATOM   1704  N   ASP A 214     -35.155  64.070  14.495  1.00 97.23           N  
ATOM   1705  CA  ASP A 214     -36.275  63.353  13.898  1.00 96.83           C  
ATOM   1706  C   ASP A 214     -35.847  61.889  13.750  1.00 92.28           C  
ATOM   1707  O   ASP A 214     -36.677  60.984  13.697  1.00 94.82           O  
ATOM   1708  CB  ASP A 214     -36.606  63.960  12.527  1.00106.96           C  
ATOM   1709  CG  ASP A 214     -37.012  65.429  12.613  1.00116.81           C  
ATOM   1710  OD1 ASP A 214     -37.068  66.097  11.551  1.00122.60           O  
ATOM   1711  OD2 ASP A 214     -37.284  65.914  13.738  1.00118.65           O  
ATOM   1712  N   SER A 215     -34.535  61.680  13.718  1.00 86.05           N  
ATOM   1713  CA  SER A 215     -33.936  60.365  13.562  1.00 73.83           C  
ATOM   1714  C   SER A 215     -33.579  59.713  14.884  1.00 73.16           C  
ATOM   1715  O   SER A 215     -33.190  58.552  14.913  1.00 75.71           O  
ATOM   1716  CB  SER A 215     -32.674  60.500  12.715  1.00 77.11           C  
ATOM   1717  OG  SER A 215     -31.865  61.565  13.201  1.00 68.69           O  
ATOM   1718  N   HIS A 216     -33.705  60.471  15.969  1.00 72.38           N  
ATOM   1719  CA  HIS A 216     -33.384  60.006  17.324  1.00 68.80           C  
ATOM   1720  C   HIS A 216     -31.883  59.857  17.580  1.00 64.36           C  
ATOM   1721  O   HIS A 216     -31.486  59.526  18.693  1.00 63.17           O  
ATOM   1722  CB  HIS A 216     -34.069  58.666  17.636  1.00 72.30           C  
ATOM   1723  CG  HIS A 216     -35.559  58.759  17.783  1.00 86.45           C  
ATOM   1724  ND1 HIS A 216     -36.311  57.750  18.345  1.00 87.62           N  
ATOM   1725  CD2 HIS A 216     -36.436  59.733  17.437  1.00 88.80           C  
ATOM   1726  CE1 HIS A 216     -37.586  58.097  18.342  1.00 91.27           C  
ATOM   1727  NE2 HIS A 216     -37.690  59.295  17.796  1.00 88.30           N  
ATOM   1728  N   GLU A 217     -31.054  60.118  16.572  1.00 59.27           N  
ATOM   1729  CA  GLU A 217     -29.604  59.967  16.721  1.00 56.59           C  
ATOM   1730  C   GLU A 217     -28.938  61.012  17.629  1.00 55.96           C  
ATOM   1731  O   GLU A 217     -27.906  60.737  18.252  1.00 38.97           O  
ATOM   1732  CB  GLU A 217     -28.927  59.996  15.346  1.00 62.16           C  
ATOM   1733  CG  GLU A 217     -29.427  58.968  14.320  1.00 71.34           C  
ATOM   1734  CD  GLU A 217     -28.734  59.121  12.957  1.00 86.58           C  
ATOM   1735  OE1 GLU A 217     -28.745  60.250  12.402  1.00 94.35           O  
ATOM   1736  OE2 GLU A 217     -28.187  58.119  12.428  1.00 84.30           O  
ATOM   1737  N   TYR A 218     -29.528  62.208  17.687  1.00 59.62           N  
ATOM   1738  CA  TYR A 218     -29.013  63.315  18.502  1.00 52.18           C  
ATOM   1739  C   TYR A 218     -30.029  63.761  19.547  1.00 52.98           C  
ATOM   1740  O   TYR A 218     -31.229  63.841  19.263  1.00 42.95           O  
ATOM   1741  CB  TYR A 218     -28.634  64.519  17.611  1.00 46.70           C  
ATOM   1742  CG  TYR A 218     -28.125  65.724  18.386  1.00 45.13           C  
ATOM   1743  CD1 TYR A 218     -28.919  66.862  18.564  1.00 44.82           C  
ATOM   1744  CD2 TYR A 218     -26.886  65.690  19.016  1.00 38.94           C  
ATOM   1745  CE1 TYR A 218     -28.490  67.933  19.362  1.00 39.62           C  
ATOM   1746  CE2 TYR A 218     -26.450  66.748  19.816  1.00 45.55           C  
ATOM   1747  CZ  TYR A 218     -27.257  67.868  19.991  1.00 48.08           C  
ATOM   1748  OH  TYR A 218     -26.834  68.894  20.819  1.00 34.25           O  
ATOM   1749  N   CYS A 219     -29.530  64.048  20.751  1.00 52.49           N  
ATOM   1750  CA  CYS A 219     -30.349  64.512  21.874  1.00 55.25           C  
ATOM   1751  C   CYS A 219     -29.568  65.484  22.785  1.00 52.82           C  
ATOM   1752  O   CYS A 219     -28.403  65.239  23.095  1.00 48.24           O  
ATOM   1753  CB  CYS A 219     -30.833  63.308  22.688  1.00 56.05           C  
ATOM   1754  SG  CYS A 219     -31.913  63.715  24.080  1.00 55.64           S  
ATOM   1755  N   GLN A 220     -30.209  66.583  23.194  1.00 48.07           N  
ATOM   1756  CA  GLN A 220     -29.588  67.587  24.073  1.00 43.56           C  
ATOM   1757  C   GLN A 220     -30.553  68.084  25.144  1.00 47.24           C  
ATOM   1758  O   GLN A 220     -31.765  67.875  25.048  1.00 45.95           O  
ATOM   1759  CB  GLN A 220     -29.088  68.793  23.267  1.00 44.08           C  
ATOM   1760  CG  GLN A 220     -29.921  69.096  22.025  1.00 55.30           C  
ATOM   1761  CD  GLN A 220     -29.676  70.486  21.432  1.00 54.70           C  
ATOM   1762  OE1 GLN A 220     -30.071  70.764  20.294  1.00 53.29           O  
ATOM   1763  NE2 GLN A 220     -29.043  71.364  22.205  1.00 47.47           N  
ATOM   1764  N   ILE A 221     -29.999  68.736  26.164  1.00 45.68           N  
ATOM   1765  CA  ILE A 221     -30.779  69.270  27.279  1.00 48.53           C  
ATOM   1766  C   ILE A 221     -30.192  70.581  27.742  1.00 55.31           C  
ATOM   1767  O   ILE A 221     -29.075  70.609  28.262  1.00 55.53           O  
ATOM   1768  CB  ILE A 221     -30.740  68.377  28.531  1.00 53.52           C  
ATOM   1769  CG1 ILE A 221     -30.915  66.911  28.151  1.00 68.95           C  
ATOM   1770  CG2 ILE A 221     -31.784  68.845  29.524  1.00 43.09           C  
ATOM   1771  CD1 ILE A 221     -29.622  66.263  27.613  1.00 76.97           C  
ATOM   1772  N   LYS A 222     -30.943  71.664  27.590  1.00 57.66           N  
ATOM   1773  CA  LYS A 222     -30.467  72.976  28.026  1.00 52.72           C  
ATOM   1774  C   LYS A 222     -30.942  73.293  29.455  1.00 49.73           C  
ATOM   1775  O   LYS A 222     -32.135  73.474  29.697  1.00 44.94           O  
ATOM   1776  CB  LYS A 222     -30.966  74.046  27.055  1.00 48.59           C  
ATOM   1777  CG  LYS A 222     -30.479  73.870  25.634  1.00 55.46           C  
ATOM   1778  CD  LYS A 222     -30.948  75.009  24.746  1.00 67.38           C  
ATOM   1779  CE  LYS A 222     -32.453  75.017  24.605  1.00 70.64           C  
ATOM   1780  NZ  LYS A 222     -32.929  76.373  24.225  1.00 75.59           N  
ATOM   1781  N   ILE A 223     -30.005  73.348  30.398  1.00 45.91           N  
ATOM   1782  CA  ILE A 223     -30.337  73.658  31.789  1.00 47.38           C  
ATOM   1783  C   ILE A 223     -30.050  75.134  32.051  1.00 50.48           C  
ATOM   1784  O   ILE A 223     -28.939  75.505  32.429  1.00 47.95           O  
ATOM   1785  CB  ILE A 223     -29.515  72.782  32.797  1.00 45.20           C  
ATOM   1786  CG1 ILE A 223     -29.806  71.309  32.550  1.00 41.44           C  
ATOM   1787  CG2 ILE A 223     -29.940  73.049  34.234  1.00 34.65           C  
ATOM   1788  CD1 ILE A 223     -31.249  70.958  32.763  1.00 35.61           C  
ATOM   1789  N   THR A 224     -31.062  75.970  31.829  1.00 57.45           N  
ATOM   1790  CA  THR A 224     -30.938  77.413  32.021  1.00 65.94           C  
ATOM   1791  C   THR A 224     -30.760  77.751  33.489  1.00 66.57           C  
ATOM   1792  O   THR A 224     -31.209  77.019  34.361  1.00 67.87           O  
ATOM   1793  CB  THR A 224     -32.190  78.172  31.481  1.00 66.98           C  
ATOM   1794  OG1 THR A 224     -32.028  79.582  31.697  1.00 74.37           O  
ATOM   1795  CG2 THR A 224     -33.456  77.693  32.176  1.00 57.44           C  
ATOM   1796  N   ASN A 225     -30.111  78.869  33.769  1.00 68.20           N  
ATOM   1797  CA  ASN A 225     -29.919  79.237  35.152  1.00 73.77           C  
ATOM   1798  C   ASN A 225     -31.242  79.230  35.919  1.00 77.15           C  
ATOM   1799  O   ASN A 225     -31.275  78.922  37.112  1.00 74.54           O  
ATOM   1800  CB  ASN A 225     -29.262  80.608  35.254  1.00 80.95           C  
ATOM   1801  CG  ASN A 225     -28.905  80.964  36.678  1.00 86.47           C  
ATOM   1802  OD1 ASN A 225     -29.752  81.427  37.441  1.00 84.92           O  
ATOM   1803  ND2 ASN A 225     -27.646  80.733  37.052  1.00 89.42           N  
ATOM   1804  N   ASP A 226     -32.335  79.558  35.238  1.00 84.53           N  
ATOM   1805  CA  ASP A 226     -33.651  79.587  35.885  1.00 86.75           C  
ATOM   1806  C   ASP A 226     -33.983  78.258  36.550  1.00 81.60           C  
ATOM   1807  O   ASP A 226     -34.230  78.206  37.758  1.00 78.82           O  
ATOM   1808  CB  ASP A 226     -34.763  79.941  34.877  1.00 92.04           C  
ATOM   1809  CG  ASP A 226     -34.627  81.358  34.317  1.00100.08           C  
ATOM   1810  OD1 ASP A 226     -34.354  82.302  35.104  1.00 95.37           O  
ATOM   1811  OD2 ASP A 226     -34.811  81.530  33.090  1.00105.53           O  
ATOM   1812  N   VAL A 227     -33.991  77.191  35.756  1.00 74.27           N  
ATOM   1813  CA  VAL A 227     -34.300  75.866  36.282  1.00 74.11           C  
ATOM   1814  C   VAL A 227     -33.304  75.469  37.380  1.00 71.46           C  
ATOM   1815  O   VAL A 227     -33.655  74.743  38.313  1.00 67.38           O  
ATOM   1816  CB  VAL A 227     -34.309  74.795  35.155  1.00 69.34           C  
ATOM   1817  CG1 VAL A 227     -35.174  75.261  34.007  1.00 63.08           C  
ATOM   1818  CG2 VAL A 227     -32.906  74.509  34.683  1.00 76.69           C  
ATOM   1819  N   LEU A 228     -32.070  75.954  37.282  1.00 66.99           N  
ATOM   1820  CA  LEU A 228     -31.074  75.633  38.296  1.00 63.41           C  
ATOM   1821  C   LEU A 228     -31.469  76.134  39.672  1.00 65.41           C  
ATOM   1822  O   LEU A 228     -31.006  75.611  40.683  1.00 57.04           O  
ATOM   1823  CB  LEU A 228     -29.711  76.210  37.936  1.00 51.55           C  
ATOM   1824  CG  LEU A 228     -28.794  75.264  37.179  1.00 55.94           C  
ATOM   1825  CD1 LEU A 228     -27.398  75.858  37.175  1.00 60.85           C  
ATOM   1826  CD2 LEU A 228     -28.763  73.896  37.844  1.00 53.90           C  
ATOM   1827  N   LYS A 229     -32.317  77.155  39.712  1.00 73.95           N  
ATOM   1828  CA  LYS A 229     -32.760  77.706  40.987  1.00 78.93           C  
ATOM   1829  C   LYS A 229     -34.225  77.401  41.238  1.00 75.84           C  
ATOM   1830  O   LYS A 229     -34.688  77.456  42.380  1.00 75.57           O  
ATOM   1831  CB  LYS A 229     -32.489  79.215  41.041  1.00 84.23           C  
ATOM   1832  CG  LYS A 229     -31.003  79.547  41.282  1.00 95.32           C  
ATOM   1833  CD  LYS A 229     -30.463  78.832  42.537  1.00 90.85           C  
ATOM   1834  CE  LYS A 229     -28.941  78.939  42.670  1.00 86.31           C  
ATOM   1835  NZ  LYS A 229     -28.197  78.301  41.545  1.00 68.41           N  
ATOM   1836  N   GLN A 230     -34.939  77.075  40.161  1.00 72.07           N  
ATOM   1837  CA  GLN A 230     -36.344  76.705  40.240  1.00 66.42           C  
ATOM   1838  C   GLN A 230     -36.418  75.375  40.992  1.00 65.77           C  
ATOM   1839  O   GLN A 230     -37.356  75.133  41.750  1.00 70.44           O  
ATOM   1840  CB  GLN A 230     -36.942  76.510  38.849  1.00 58.14           C  
ATOM   1841  CG  GLN A 230     -38.394  76.083  38.903  1.00 66.92           C  
ATOM   1842  CD  GLN A 230     -38.844  75.312  37.675  1.00 77.98           C  
ATOM   1843  OE1 GLN A 230     -38.656  75.757  36.538  1.00 81.31           O  
ATOM   1844  NE2 GLN A 230     -39.464  74.151  37.899  1.00 75.76           N  
ATOM   1845  N   PHE A 231     -35.427  74.515  40.765  1.00 62.96           N  
ATOM   1846  CA  PHE A 231     -35.363  73.216  41.427  1.00 53.72           C  
ATOM   1847  C   PHE A 231     -34.361  73.247  42.547  1.00 55.46           C  
ATOM   1848  O   PHE A 231     -34.117  72.227  43.178  1.00 51.61           O  
ATOM   1849  CB  PHE A 231     -34.947  72.129  40.451  1.00 46.60           C  
ATOM   1850  CG  PHE A 231     -36.039  71.688  39.548  1.00 46.94           C  
ATOM   1851  CD1 PHE A 231     -36.806  70.573  39.861  1.00 44.22           C  
ATOM   1852  CD2 PHE A 231     -36.304  72.385  38.373  1.00 45.59           C  
ATOM   1853  CE1 PHE A 231     -37.825  70.150  39.009  1.00 43.95           C  
ATOM   1854  CE2 PHE A 231     -37.318  71.976  37.513  1.00 47.45           C  
ATOM   1855  CZ  PHE A 231     -38.080  70.855  37.830  1.00 49.84           C  
ATOM   1856  N   ASP A 232     -33.781  74.422  42.777  1.00 64.35           N  
ATOM   1857  CA  ASP A 232     -32.783  74.616  43.827  1.00 76.65           C  
ATOM   1858  C   ASP A 232     -31.697  73.535  43.806  1.00 78.92           C  
ATOM   1859  O   ASP A 232     -31.706  72.611  44.627  1.00 79.93           O  
ATOM   1860  CB  ASP A 232     -33.468  74.656  45.204  1.00 87.97           C  
ATOM   1861  CG  ASP A 232     -32.475  74.681  46.370  1.00 95.44           C  
ATOM   1862  OD1 ASP A 232     -31.768  75.699  46.551  1.00 88.17           O  
ATOM   1863  OD2 ASP A 232     -32.411  73.664  47.105  1.00100.84           O  
ATOM   1864  N   ILE A 233     -30.775  73.650  42.849  1.00 78.38           N  
ATOM   1865  CA  ILE A 233     -29.651  72.716  42.711  1.00 73.64           C  
ATOM   1866  C   ILE A 233     -28.441  73.429  42.173  1.00 69.34           C  
ATOM   1867  O   ILE A 233     -28.557  74.310  41.334  1.00 66.88           O  
ATOM   1868  CB  ILE A 233     -29.934  71.548  41.731  1.00 72.86           C  
ATOM   1869  CG1 ILE A 233     -30.671  72.065  40.498  1.00 67.27           C  
ATOM   1870  CG2 ILE A 233     -30.686  70.440  42.437  1.00 74.65           C  
ATOM   1871  CD1 ILE A 233     -31.013  70.985  39.514  1.00 62.49           C  
ATOM   1872  N   GLN A 234     -27.273  73.040  42.654  1.00 71.53           N  
ATOM   1873  CA  GLN A 234     -26.058  73.658  42.183  1.00 77.43           C  
ATOM   1874  C   GLN A 234     -25.748  73.179  40.774  1.00 78.88           C  
ATOM   1875  O   GLN A 234     -26.172  72.090  40.367  1.00 70.09           O  
ATOM   1876  CB  GLN A 234     -24.895  73.322  43.119  1.00 85.34           C  
ATOM   1877  CG  GLN A 234     -25.029  73.975  44.474  1.00 89.05           C  
ATOM   1878  CD  GLN A 234     -25.160  75.484  44.367  1.00 94.02           C  
ATOM   1879  OE1 GLN A 234     -24.223  76.173  43.947  1.00 99.13           O  
ATOM   1880  NE2 GLN A 234     -26.331  76.007  44.731  1.00 88.96           N  
ATOM   1881  N   PRO A 235     -25.012  74.000  40.008  1.00 80.65           N  
ATOM   1882  CA  PRO A 235     -24.647  73.644  38.638  1.00 79.40           C  
ATOM   1883  C   PRO A 235     -23.905  72.309  38.620  1.00 76.99           C  
ATOM   1884  O   PRO A 235     -24.053  71.523  37.694  1.00 73.39           O  
ATOM   1885  CB  PRO A 235     -23.788  74.828  38.198  1.00 74.43           C  
ATOM   1886  CG  PRO A 235     -23.170  75.292  39.485  1.00 77.84           C  
ATOM   1887  CD  PRO A 235     -24.335  75.242  40.425  1.00 77.76           C  
ATOM   1888  N   ASN A 236     -23.116  72.045  39.651  1.00 78.46           N  
ATOM   1889  CA  ASN A 236     -22.399  70.786  39.709  1.00 83.68           C  
ATOM   1890  C   ASN A 236     -23.352  69.621  39.796  1.00 82.33           C  
ATOM   1891  O   ASN A 236     -23.319  68.723  38.965  1.00 83.93           O  
ATOM   1892  CB  ASN A 236     -21.462  70.762  40.904  1.00 90.73           C  
ATOM   1893  CG  ASN A 236     -20.116  71.348  40.575  1.00100.41           C  
ATOM   1894  OD1 ASN A 236     -19.413  71.847  41.456  1.00112.41           O  
ATOM   1895  ND2 ASN A 236     -19.738  71.284  39.294  1.00 90.19           N  
ATOM   1896  N   GLU A 237     -24.209  69.647  40.804  1.00 85.37           N  
ATOM   1897  CA  GLU A 237     -25.180  68.584  41.020  1.00 85.28           C  
ATOM   1898  C   GLU A 237     -25.967  68.200  39.770  1.00 83.01           C  
ATOM   1899  O   GLU A 237     -26.032  67.027  39.410  1.00 79.95           O  
ATOM   1900  CB  GLU A 237     -26.147  68.994  42.126  1.00 84.55           C  
ATOM   1901  CG  GLU A 237     -25.441  69.412  43.398  1.00 89.41           C  
ATOM   1902  CD  GLU A 237     -26.405  69.828  44.479  1.00 88.32           C  
ATOM   1903  OE1 GLU A 237     -27.256  70.706  44.201  1.00 87.23           O  
ATOM   1904  OE2 GLU A 237     -26.301  69.288  45.604  1.00 83.38           O  
ATOM   1905  N   ALA A 238     -26.567  69.186  39.113  1.00 79.31           N  
ATOM   1906  CA  ALA A 238     -27.353  68.922  37.914  1.00 76.30           C  
ATOM   1907  C   ALA A 238     -26.519  68.308  36.796  1.00 74.39           C  
ATOM   1908  O   ALA A 238     -27.027  67.545  35.974  1.00 71.92           O  
ATOM   1909  CB  ALA A 238     -27.999  70.209  37.430  1.00 80.95           C  
ATOM   1910  N   SER A 239     -25.236  68.642  36.769  1.00 76.41           N  
ATOM   1911  CA  SER A 239     -24.330  68.135  35.739  1.00 78.61           C  
ATOM   1912  C   SER A 239     -24.049  66.641  35.812  1.00 77.40           C  
ATOM   1913  O   SER A 239     -23.348  66.107  34.954  1.00 73.41           O  
ATOM   1914  CB  SER A 239     -22.998  68.881  35.805  1.00 79.74           C  
ATOM   1915  OG  SER A 239     -23.179  70.259  35.552  1.00 84.82           O  
ATOM   1916  N   GLN A 240     -24.581  65.967  36.830  1.00 76.77           N  
ATOM   1917  CA  GLN A 240     -24.345  64.534  36.973  1.00 73.92           C  
ATOM   1918  C   GLN A 240     -25.429  63.739  36.249  1.00 66.52           C  
ATOM   1919  O   GLN A 240     -25.349  62.519  36.120  1.00 62.47           O  
ATOM   1920  CB  GLN A 240     -24.281  64.129  38.459  1.00 77.21           C  
ATOM   1921  CG  GLN A 240     -25.612  64.204  39.213  1.00 91.41           C  
ATOM   1922  CD  GLN A 240     -25.589  63.491  40.570  1.00 91.59           C  
ATOM   1923  OE1 GLN A 240     -24.979  63.966  41.536  1.00 80.88           O  
ATOM   1924  NE2 GLN A 240     -26.259  62.340  40.638  1.00 83.30           N  
ATOM   1925  N   PHE A 241     -26.436  64.443  35.755  1.00 60.29           N  
ATOM   1926  CA  PHE A 241     -27.521  63.784  35.052  1.00 59.61           C  
ATOM   1927  C   PHE A 241     -27.275  63.801  33.551  1.00 57.28           C  
ATOM   1928  O   PHE A 241     -28.154  64.124  32.764  1.00 61.32           O  
ATOM   1929  CB  PHE A 241     -28.841  64.472  35.408  1.00 52.69           C  
ATOM   1930  CG  PHE A 241     -29.252  64.259  36.832  1.00 53.99           C  
ATOM   1931  CD1 PHE A 241     -30.137  63.248  37.163  1.00 55.32           C  
ATOM   1932  CD2 PHE A 241     -28.691  65.020  37.854  1.00 58.14           C  
ATOM   1933  CE1 PHE A 241     -30.457  62.990  38.494  1.00 60.84           C  
ATOM   1934  CE2 PHE A 241     -29.002  64.772  39.191  1.00 51.05           C  
ATOM   1935  CZ  PHE A 241     -29.885  63.755  39.508  1.00 58.55           C  
ATOM   1936  N   VAL A 242     -26.075  63.442  33.135  1.00 52.54           N  
ATOM   1937  CA  VAL A 242     -25.816  63.483  31.714  1.00 46.02           C  
ATOM   1938  C   VAL A 242     -26.434  62.287  31.049  1.00 55.24           C  
ATOM   1939  O   VAL A 242     -27.240  62.407  30.126  1.00 51.62           O  
ATOM   1940  CB  VAL A 242     -24.339  63.466  31.415  1.00 38.18           C  
ATOM   1941  CG1 VAL A 242     -24.105  64.121  30.090  1.00 29.96           C  
ATOM   1942  CG2 VAL A 242     -23.579  64.172  32.512  1.00 38.84           C  
ATOM   1943  N   ASN A 243     -26.059  61.120  31.545  1.00 66.05           N  
ATOM   1944  CA  ASN A 243     -26.544  59.869  30.994  1.00 74.16           C  
ATOM   1945  C   ASN A 243     -27.999  59.562  31.376  1.00 73.20           C  
ATOM   1946  O   ASN A 243     -28.404  58.399  31.470  1.00 76.13           O  
ATOM   1947  CB  ASN A 243     -25.604  58.744  31.432  1.00 76.23           C  
ATOM   1948  CG  ASN A 243     -24.191  58.961  30.946  1.00 71.62           C  
ATOM   1949  OD1 ASN A 243     -23.402  58.025  30.846  1.00 77.29           O  
ATOM   1950  ND2 ASN A 243     -23.864  60.206  30.643  1.00 74.86           N  
ATOM   1951  N   THR A 244     -28.794  60.605  31.578  1.00 67.06           N  
ATOM   1952  CA  THR A 244     -30.183  60.383  31.935  1.00 62.98           C  
ATOM   1953  C   THR A 244     -31.030  60.247  30.673  1.00 59.18           C  
ATOM   1954  O   THR A 244     -32.233  60.046  30.749  1.00 59.67           O  
ATOM   1955  CB  THR A 244     -30.722  61.529  32.841  1.00 62.07           C  
ATOM   1956  OG1 THR A 244     -29.911  61.636  34.023  1.00 69.74           O  
ATOM   1957  CG2 THR A 244     -32.149  61.245  33.273  1.00 59.36           C  
ATOM   1958  N   VAL A 245     -30.391  60.324  29.510  1.00 56.60           N  
ATOM   1959  CA  VAL A 245     -31.107  60.218  28.232  1.00 54.30           C  
ATOM   1960  C   VAL A 245     -30.410  59.199  27.324  1.00 62.75           C  
ATOM   1961  O   VAL A 245     -30.855  58.939  26.195  1.00 57.79           O  
ATOM   1962  CB  VAL A 245     -31.108  61.560  27.472  1.00 43.58           C  
ATOM   1963  CG1 VAL A 245     -32.404  61.749  26.752  1.00 15.14           C  
ATOM   1964  CG2 VAL A 245     -30.821  62.691  28.420  1.00 36.62           C  
ATOM   1965  N   ALA A 246     -29.313  58.638  27.829  1.00 68.16           N  
ATOM   1966  CA  ALA A 246     -28.496  57.671  27.099  1.00 68.06           C  
ATOM   1967  C   ALA A 246     -29.220  56.416  26.623  1.00 70.26           C  
ATOM   1968  O   ALA A 246     -28.882  55.858  25.577  1.00 70.46           O  
ATOM   1969  CB  ALA A 246     -27.300  57.283  27.949  1.00 63.42           C  
ATOM   1970  N   ASP A 247     -30.218  55.974  27.384  1.00 73.43           N  
ATOM   1971  CA  ASP A 247     -30.967  54.768  27.034  1.00 73.92           C  
ATOM   1972  C   ASP A 247     -32.014  54.928  25.923  1.00 71.02           C  
ATOM   1973  O   ASP A 247     -32.660  53.951  25.545  1.00 69.79           O  
ATOM   1974  CB  ASP A 247     -31.635  54.186  28.287  1.00 76.66           C  
ATOM   1975  CG  ASP A 247     -30.690  53.311  29.116  1.00 87.00           C  
ATOM   1976  OD1 ASP A 247     -31.151  52.785  30.160  1.00 93.96           O  
ATOM   1977  OD2 ASP A 247     -29.502  53.137  28.736  1.00 79.82           O  
ATOM   1978  N   ILE A 248     -32.181  56.140  25.390  1.00 68.92           N  
ATOM   1979  CA  ILE A 248     -33.167  56.351  24.329  1.00 58.35           C  
ATOM   1980  C   ILE A 248     -32.817  55.468  23.156  1.00 53.39           C  
ATOM   1981  O   ILE A 248     -31.657  55.364  22.767  1.00 50.30           O  
ATOM   1982  CB  ILE A 248     -33.220  57.824  23.834  1.00 54.83           C  
ATOM   1983  CG1 ILE A 248     -33.655  58.734  24.974  1.00 48.20           C  
ATOM   1984  CG2 ILE A 248     -34.204  57.957  22.664  1.00 43.51           C  
ATOM   1985  CD1 ILE A 248     -34.002  60.111  24.541  1.00 37.48           C  
ATOM   1986  N   SER A 249     -33.838  54.846  22.590  1.00 49.68           N  
ATOM   1987  CA  SER A 249     -33.656  53.953  21.462  1.00 57.75           C  
ATOM   1988  C   SER A 249     -33.132  54.631  20.197  1.00 53.82           C  
ATOM   1989  O   SER A 249     -33.796  55.487  19.621  1.00 58.27           O  
ATOM   1990  CB  SER A 249     -34.978  53.268  21.161  1.00 55.26           C  
ATOM   1991  OG  SER A 249     -35.999  54.243  21.108  1.00 63.93           O  
ATOM   1992  N   GLY A 250     -31.938  54.237  19.768  1.00 52.27           N  
ATOM   1993  CA  GLY A 250     -31.368  54.805  18.564  1.00 48.72           C  
ATOM   1994  C   GLY A 250     -30.424  55.964  18.789  1.00 51.60           C  
ATOM   1995  O   GLY A 250     -29.740  56.392  17.862  1.00 47.31           O  
ATOM   1996  N   LEU A 251     -30.371  56.469  20.017  1.00 56.24           N  
ATOM   1997  CA  LEU A 251     -29.508  57.603  20.331  1.00 57.84           C  
ATOM   1998  C   LEU A 251     -28.060  57.277  20.021  1.00 58.86           C  
ATOM   1999  O   LEU A 251     -27.529  56.269  20.482  1.00 61.28           O  
ATOM   2000  CB  LEU A 251     -29.621  57.986  21.812  1.00 59.62           C  
ATOM   2001  CG  LEU A 251     -29.620  59.484  22.150  1.00 55.70           C  
ATOM   2002  CD1 LEU A 251     -29.319  59.670  23.626  1.00 52.02           C  
ATOM   2003  CD2 LEU A 251     -28.593  60.217  21.316  1.00 58.78           C  
ATOM   2004  N   LYS A 252     -27.419  58.142  19.244  1.00 61.07           N  
ATOM   2005  CA  LYS A 252     -26.025  57.945  18.883  1.00 63.51           C  
ATOM   2006  C   LYS A 252     -25.136  58.999  19.530  1.00 64.61           C  
ATOM   2007  O   LYS A 252     -24.002  58.721  19.907  1.00 72.34           O  
ATOM   2008  CB  LYS A 252     -25.854  57.974  17.357  1.00 60.97           C  
ATOM   2009  CG  LYS A 252     -26.538  56.825  16.620  1.00 64.83           C  
ATOM   2010  CD  LYS A 252     -26.296  56.904  15.125  1.00 73.50           C  
ATOM   2011  CE  LYS A 252     -26.977  55.764  14.371  1.00 88.97           C  
ATOM   2012  NZ  LYS A 252     -26.710  55.820  12.890  1.00 93.94           N  
ATOM   2013  N   ILE A 253     -25.644  60.215  19.672  1.00 62.76           N  
ATOM   2014  CA  ILE A 253     -24.839  61.267  20.280  1.00 64.52           C  
ATOM   2015  C   ILE A 253     -25.712  62.247  21.056  1.00 61.09           C  
ATOM   2016  O   ILE A 253     -26.783  62.662  20.605  1.00 58.26           O  
ATOM   2017  CB  ILE A 253     -24.009  61.992  19.200  1.00 71.22           C  
ATOM   2018  CG1 ILE A 253     -23.313  63.213  19.791  1.00 73.00           C  
ATOM   2019  CG2 ILE A 253     -24.897  62.358  18.026  1.00 82.19           C  
ATOM   2020  CD1 ILE A 253     -22.646  64.081  18.733  1.00 72.31           C  
ATOM   2021  N   TRP A 254     -25.241  62.613  22.235  1.00 51.80           N  
ATOM   2022  CA  TRP A 254     -26.010  63.478  23.090  1.00 50.46           C  
ATOM   2023  C   TRP A 254     -25.160  64.466  23.867  1.00 55.16           C  
ATOM   2024  O   TRP A 254     -24.039  64.165  24.270  1.00 58.66           O  
ATOM   2025  CB  TRP A 254     -26.841  62.619  24.055  1.00 47.00           C  
ATOM   2026  CG  TRP A 254     -26.164  61.343  24.469  1.00 53.56           C  
ATOM   2027  CD1 TRP A 254     -25.953  60.216  23.694  1.00 63.16           C  
ATOM   2028  CD2 TRP A 254     -25.537  61.077  25.718  1.00 58.24           C  
ATOM   2029  NE1 TRP A 254     -25.226  59.280  24.391  1.00 44.48           N  
ATOM   2030  CE2 TRP A 254     -24.956  59.780  25.635  1.00 59.78           C  
ATOM   2031  CE3 TRP A 254     -25.397  61.804  26.905  1.00 59.63           C  
ATOM   2032  CZ2 TRP A 254     -24.256  59.204  26.690  1.00 71.52           C  
ATOM   2033  CZ3 TRP A 254     -24.696  61.234  27.961  1.00 76.05           C  
ATOM   2034  CH2 TRP A 254     -24.131  59.942  27.847  1.00 82.35           C  
HETATM 2035  N   MSE A 255     -25.703  65.658  24.064  1.00 57.76           N  
HETATM 2036  CA  MSE A 255     -25.008  66.692  24.801  1.00 55.57           C  
HETATM 2037  C   MSE A 255     -25.900  67.242  25.909  1.00 55.60           C  
HETATM 2038  O   MSE A 255     -27.123  67.384  25.753  1.00 46.92           O  
HETATM 2039  CB  MSE A 255     -24.577  67.799  23.844  1.00 67.23           C  
HETATM 2040  CG  MSE A 255     -24.023  69.035  24.526  1.00 75.88           C  
HETATM 2041 SE   MSE A 255     -23.353  70.329  23.236  1.00 87.47          SE  
HETATM 2042  CE  MSE A 255     -21.467  69.918  23.452  1.00 81.56           C  
ATOM   2043  N   PHE A 256     -25.259  67.543  27.032  1.00 55.88           N  
ATOM   2044  CA  PHE A 256     -25.932  68.055  28.213  1.00 58.31           C  
ATOM   2045  C   PHE A 256     -25.246  69.338  28.639  1.00 54.72           C  
ATOM   2046  O   PHE A 256     -24.129  69.314  29.144  1.00 47.75           O  
ATOM   2047  CB  PHE A 256     -25.851  67.026  29.346  1.00 62.01           C  
ATOM   2048  CG  PHE A 256     -26.759  67.322  30.501  1.00 64.21           C  
ATOM   2049  CD1 PHE A 256     -28.140  67.251  30.348  1.00 67.62           C  
ATOM   2050  CD2 PHE A 256     -26.236  67.684  31.739  1.00 61.68           C  
ATOM   2051  CE1 PHE A 256     -28.988  67.538  31.409  1.00 68.08           C  
ATOM   2052  CE2 PHE A 256     -27.068  67.974  32.810  1.00 59.25           C  
ATOM   2053  CZ  PHE A 256     -28.448  67.901  32.648  1.00 68.57           C  
ATOM   2054  N   GLY A 257     -25.927  70.457  28.428  1.00 59.92           N  
ATOM   2055  CA  GLY A 257     -25.360  71.739  28.792  1.00 68.83           C  
ATOM   2056  C   GLY A 257     -26.086  72.448  29.920  1.00 69.64           C  
ATOM   2057  O   GLY A 257     -27.287  72.725  29.833  1.00 71.60           O  
ATOM   2058  N   VAL A 258     -25.353  72.744  30.987  1.00 63.12           N  
ATOM   2059  CA  VAL A 258     -25.924  73.435  32.130  1.00 60.47           C  
ATOM   2060  C   VAL A 258     -25.197  74.772  32.327  1.00 65.59           C  
ATOM   2061  O   VAL A 258     -23.965  74.833  32.347  1.00 62.21           O  
ATOM   2062  CB  VAL A 258     -25.844  72.544  33.403  1.00 55.04           C  
ATOM   2063  CG1 VAL A 258     -24.471  71.929  33.530  1.00 49.67           C  
ATOM   2064  CG2 VAL A 258     -26.183  73.352  34.635  1.00 45.18           C  
ATOM   2065  N   ASP A 259     -25.977  75.844  32.434  1.00 65.49           N  
ATOM   2066  CA  ASP A 259     -25.453  77.197  32.609  1.00 64.62           C  
ATOM   2067  C   ASP A 259     -24.901  77.423  34.013  1.00 63.56           C  
ATOM   2068  O   ASP A 259     -25.616  77.266  34.998  1.00 61.39           O  
ATOM   2069  CB  ASP A 259     -26.565  78.210  32.292  1.00 67.96           C  
ATOM   2070  CG  ASP A 259     -26.268  79.602  32.816  1.00 69.09           C  
ATOM   2071  OD1 ASP A 259     -25.124  80.080  32.661  1.00 72.97           O  
ATOM   2072  OD2 ASP A 259     -27.192  80.232  33.370  1.00 68.49           O  
ATOM   2073  N   GLU A 260     -23.623  77.787  34.099  1.00 68.00           N  
ATOM   2074  CA  GLU A 260     -22.984  78.037  35.391  1.00 74.52           C  
ATOM   2075  C   GLU A 260     -23.005  79.526  35.736  1.00 81.73           C  
ATOM   2076  O   GLU A 260     -22.638  79.925  36.847  1.00 87.63           O  
ATOM   2077  CB  GLU A 260     -21.535  77.549  35.386  1.00 68.04           C  
ATOM   2078  CG  GLU A 260     -21.364  76.131  34.882  1.00 79.08           C  
ATOM   2079  CD  GLU A 260     -19.940  75.628  35.023  1.00 86.44           C  
ATOM   2080  OE1 GLU A 260     -18.999  76.394  34.710  1.00 90.37           O  
ATOM   2081  OE2 GLU A 260     -19.757  74.459  35.427  1.00 91.91           O  
ATOM   2082  N   GLY A 261     -23.437  80.345  34.779  1.00 83.35           N  
ATOM   2083  CA  GLY A 261     -23.503  81.781  34.993  1.00 78.87           C  
ATOM   2084  C   GLY A 261     -22.791  82.527  33.886  1.00 78.97           C  
ATOM   2085  O   GLY A 261     -23.413  83.041  32.949  1.00 77.99           O  
ATOM   2086  N   ASP A 262     -21.471  82.583  33.989  1.00 78.13           N  
ATOM   2087  CA  ASP A 262     -20.677  83.265  32.982  1.00 85.88           C  
ATOM   2088  C   ASP A 262     -20.178  82.309  31.903  1.00 82.57           C  
ATOM   2089  O   ASP A 262     -19.321  82.670  31.102  1.00 90.11           O  
ATOM   2090  CB  ASP A 262     -19.481  83.963  33.626  1.00 91.07           C  
ATOM   2091  CG  ASP A 262     -18.670  83.032  34.491  1.00 93.83           C  
ATOM   2092  OD1 ASP A 262     -18.428  81.880  34.060  1.00 84.12           O  
ATOM   2093  OD2 ASP A 262     -18.268  83.461  35.594  1.00101.64           O  
ATOM   2094  N   GLN A 263     -20.701  81.092  31.894  1.00 73.75           N  
ATOM   2095  CA  GLN A 263     -20.319  80.116  30.892  1.00 65.97           C  
ATOM   2096  C   GLN A 263     -21.233  78.911  31.008  1.00 63.13           C  
ATOM   2097  O   GLN A 263     -21.738  78.614  32.083  1.00 64.36           O  
ATOM   2098  CB  GLN A 263     -18.869  79.692  31.062  1.00 60.48           C  
ATOM   2099  CG  GLN A 263     -18.504  79.334  32.460  1.00 71.52           C  
ATOM   2100  CD  GLN A 263     -17.378  78.325  32.504  1.00 78.96           C  
ATOM   2101  OE1 GLN A 263     -17.576  77.143  32.211  1.00 74.27           O  
ATOM   2102  NE2 GLN A 263     -16.180  78.790  32.851  1.00 84.57           N  
ATOM   2103  N   ILE A 264     -21.459  78.231  29.893  1.00 60.53           N  
ATOM   2104  CA  ILE A 264     -22.330  77.074  29.881  1.00 53.73           C  
ATOM   2105  C   ILE A 264     -21.501  75.821  29.692  1.00 63.39           C  
ATOM   2106  O   ILE A 264     -21.254  75.401  28.558  1.00 58.61           O  
ATOM   2107  CB  ILE A 264     -23.327  77.163  28.741  1.00 50.11           C  
ATOM   2108  CG1 ILE A 264     -24.118  78.458  28.848  1.00 42.73           C  
ATOM   2109  CG2 ILE A 264     -24.244  75.959  28.769  1.00 54.86           C  
ATOM   2110  CD1 ILE A 264     -25.025  78.696  27.672  1.00 32.91           C  
ATOM   2111  N   ARG A 265     -21.071  75.237  30.808  1.00 68.22           N  
ATOM   2112  CA  ARG A 265     -20.264  74.018  30.801  1.00 67.18           C  
ATOM   2113  C   ARG A 265     -21.084  72.868  30.267  1.00 69.25           C  
ATOM   2114  O   ARG A 265     -21.958  72.345  30.962  1.00 70.87           O  
ATOM   2115  CB  ARG A 265     -19.795  73.673  32.215  1.00 63.36           C  
ATOM   2116  CG  ARG A 265     -19.290  72.239  32.367  1.00 69.36           C  
ATOM   2117  CD  ARG A 265     -19.954  71.549  33.565  1.00 71.70           C  
ATOM   2118  NE  ARG A 265     -19.384  70.228  33.852  1.00 70.72           N  
ATOM   2119  CZ  ARG A 265     -19.412  69.646  35.048  1.00 66.52           C  
ATOM   2120  NH1 ARG A 265     -18.858  68.449  35.216  1.00 49.15           N  
ATOM   2121  NH2 ARG A 265     -19.980  70.274  36.078  1.00 64.81           N  
ATOM   2122  N   CYS A 266     -20.806  72.464  29.034  1.00 72.27           N  
ATOM   2123  CA  CYS A 266     -21.549  71.360  28.461  1.00 71.18           C  
ATOM   2124  C   CYS A 266     -20.721  70.105  28.263  1.00 68.49           C  
ATOM   2125  O   CYS A 266     -19.646  70.130  27.680  1.00 62.24           O  
ATOM   2126  CB  CYS A 266     -22.231  71.773  27.150  1.00 73.45           C  
ATOM   2127  SG  CYS A 266     -21.334  72.881  26.087  1.00 61.26           S  
ATOM   2128  N   ARG A 267     -21.250  69.012  28.797  1.00 70.66           N  
ATOM   2129  CA  ARG A 267     -20.638  67.705  28.724  1.00 65.72           C  
ATOM   2130  C   ARG A 267     -21.292  66.975  27.553  1.00 68.07           C  
ATOM   2131  O   ARG A 267     -22.525  66.837  27.500  1.00 67.77           O  
ATOM   2132  CB  ARG A 267     -20.891  66.953  30.021  1.00 58.29           C  
ATOM   2133  CG  ARG A 267     -20.732  67.811  31.243  1.00 57.57           C  
ATOM   2134  CD  ARG A 267     -21.007  66.998  32.478  1.00 69.19           C  
ATOM   2135  NE  ARG A 267     -19.850  66.197  32.857  1.00 79.35           N  
ATOM   2136  CZ  ARG A 267     -19.817  65.374  33.903  1.00 82.87           C  
ATOM   2137  NH1 ARG A 267     -20.886  65.236  34.678  1.00 77.95           N  
ATOM   2138  NH2 ARG A 267     -18.707  64.702  34.188  1.00 89.65           N  
ATOM   2139  N   ILE A 268     -20.462  66.512  26.617  1.00 67.04           N  
ATOM   2140  CA  ILE A 268     -20.945  65.820  25.424  1.00 57.59           C  
ATOM   2141  C   ILE A 268     -20.444  64.364  25.331  1.00 54.91           C  
ATOM   2142  O   ILE A 268     -19.250  64.092  25.324  1.00 54.81           O  
ATOM   2143  CB  ILE A 268     -20.589  66.677  24.131  1.00 52.92           C  
ATOM   2144  CG1 ILE A 268     -21.202  66.039  22.896  1.00 54.61           C  
ATOM   2145  CG2 ILE A 268     -19.089  66.868  23.971  1.00 34.56           C  
ATOM   2146  CD1 ILE A 268     -20.751  64.618  22.613  1.00 69.20           C  
ATOM   2147  N   ARG A 269     -21.387  63.432  25.270  1.00 55.66           N  
ATOM   2148  CA  ARG A 269     -21.055  62.020  25.185  1.00 59.75           C  
ATOM   2149  C   ARG A 269     -21.736  61.371  23.954  1.00 64.67           C  
ATOM   2150  O   ARG A 269     -22.833  61.778  23.554  1.00 66.82           O  
ATOM   2151  CB  ARG A 269     -21.445  61.298  26.504  1.00 49.71           C  
ATOM   2152  CG  ARG A 269     -20.632  61.711  27.791  1.00 53.03           C  
ATOM   2153  CD  ARG A 269     -20.579  60.531  28.793  1.00 72.88           C  
ATOM   2154  NE  ARG A 269     -19.910  60.775  30.093  1.00 84.30           N  
ATOM   2155  CZ  ARG A 269     -19.695  59.819  31.018  1.00 85.23           C  
ATOM   2156  NH1 ARG A 269     -19.100  60.097  32.176  1.00 60.16           N  
ATOM   2157  NH2 ARG A 269     -20.068  58.558  30.786  1.00 66.10           N  
ATOM   2158  N   SER A 270     -21.076  60.390  23.333  1.00 75.71           N  
ATOM   2159  CA  SER A 270     -21.634  59.699  22.157  1.00 74.27           C  
ATOM   2160  C   SER A 270     -21.646  58.187  22.347  1.00 73.31           C  
ATOM   2161  O   SER A 270     -20.865  57.626  23.123  1.00 62.59           O  
ATOM   2162  CB  SER A 270     -20.826  60.011  20.896  1.00 75.73           C  
ATOM   2163  OG  SER A 270     -19.699  59.156  20.790  1.00 74.33           O  
ATOM   2164  N   LYS A 271     -22.525  57.531  21.602  1.00 78.93           N  
ATOM   2165  CA  LYS A 271     -22.669  56.085  21.679  1.00 79.73           C  
ATOM   2166  C   LYS A 271     -21.358  55.411  21.316  1.00 80.68           C  
ATOM   2167  O   LYS A 271     -20.858  54.571  22.065  1.00 87.21           O  
ATOM   2168  CB  LYS A 271     -23.793  55.617  20.748  1.00 75.61           C  
ATOM   2169  CG  LYS A 271     -24.722  54.573  21.376  1.00 72.63           C  
ATOM   2170  CD  LYS A 271     -25.328  55.074  22.687  1.00 62.86           C  
ATOM   2171  CE  LYS A 271     -26.116  53.988  23.407  1.00 68.91           C  
ATOM   2172  NZ  LYS A 271     -26.494  54.397  24.791  1.00 60.91           N  
ATOM   2173  N   GLY A 272     -20.800  55.786  20.173  1.00 78.29           N  
ATOM   2174  CA  GLY A 272     -19.536  55.211  19.765  1.00 83.44           C  
ATOM   2175  C   GLY A 272     -19.003  55.906  18.532  1.00 87.79           C  
ATOM   2176  O   GLY A 272     -18.685  55.253  17.543  1.00 97.94           O  
ATOM   2177  N   ILE A 273     -18.906  57.228  18.579  1.00 80.96           N  
ATOM   2178  CA  ILE A 273     -18.416  57.980  17.435  1.00 71.18           C  
ATOM   2179  C   ILE A 273     -17.430  59.022  17.900  1.00 78.39           C  
ATOM   2180  O   ILE A 273     -17.667  59.681  18.911  1.00 81.34           O  
ATOM   2181  CB  ILE A 273     -19.540  58.733  16.725  1.00 64.00           C  
ATOM   2182  CG1 ILE A 273     -20.707  57.806  16.421  1.00 59.09           C  
ATOM   2183  CG2 ILE A 273     -19.021  59.331  15.437  1.00 59.72           C  
ATOM   2184  CD1 ILE A 273     -21.851  58.548  15.796  1.00 55.16           C  
ATOM   2185  N   THR A 274     -16.335  59.181  17.160  1.00 88.36           N  
ATOM   2186  CA  THR A 274     -15.314  60.173  17.507  1.00 86.94           C  
ATOM   2187  C   THR A 274     -15.994  61.545  17.672  1.00 80.13           C  
ATOM   2188  O   THR A 274     -16.455  62.148  16.701  1.00 76.96           O  
ATOM   2189  CB  THR A 274     -14.167  60.219  16.416  1.00 91.10           C  
ATOM   2190  OG1 THR A 274     -14.732  60.330  15.101  1.00 96.07           O  
ATOM   2191  CG2 THR A 274     -13.302  58.949  16.481  1.00 81.48           C  
ATOM   2192  N   ILE A 275     -16.065  62.019  18.919  1.00 75.69           N  
ATOM   2193  CA  ILE A 275     -16.720  63.285  19.241  1.00 61.81           C  
ATOM   2194  C   ILE A 275     -15.812  64.405  19.744  1.00 59.44           C  
ATOM   2195  O   ILE A 275     -16.077  65.574  19.479  1.00 49.18           O  
ATOM   2196  CB  ILE A 275     -17.874  63.035  20.254  1.00 52.59           C  
ATOM   2197  CG1 ILE A 275     -19.108  63.727  19.742  1.00 52.77           C  
ATOM   2198  CG2 ILE A 275     -17.520  63.515  21.657  1.00 43.22           C  
ATOM   2199  CD1 ILE A 275     -19.392  63.358  18.324  1.00 64.22           C  
ATOM   2200  N   ASN A 276     -14.745  64.034  20.456  1.00 59.40           N  
ATOM   2201  CA  ASN A 276     -13.778  64.986  21.001  1.00 54.90           C  
ATOM   2202  C   ASN A 276     -13.219  65.813  19.871  1.00 52.28           C  
ATOM   2203  O   ASN A 276     -12.535  66.809  20.079  1.00 43.81           O  
ATOM   2204  CB  ASN A 276     -12.642  64.247  21.709  1.00 59.49           C  
ATOM   2205  CG  ASN A 276     -11.743  63.494  20.752  1.00 63.40           C  
ATOM   2206  OD1 ASN A 276     -12.184  62.604  20.025  1.00 68.14           O  
ATOM   2207  ND2 ASN A 276     -10.464  63.846  20.755  1.00 69.58           N  
ATOM   2208  N   ASP A 277     -13.524  65.365  18.664  1.00 61.87           N  
ATOM   2209  CA  ASP A 277     -13.105  66.018  17.435  1.00 68.77           C  
ATOM   2210  C   ASP A 277     -13.639  67.457  17.470  1.00 64.66           C  
ATOM   2211  O   ASP A 277     -12.874  68.418  17.604  1.00 54.44           O  
ATOM   2212  CB  ASP A 277     -13.698  65.236  16.250  1.00 78.60           C  
ATOM   2213  CG  ASP A 277     -12.925  65.433  14.955  1.00 91.71           C  
ATOM   2214  OD1 ASP A 277     -13.239  66.384  14.200  1.00 95.68           O  
ATOM   2215  OD2 ASP A 277     -11.992  64.630  14.697  1.00100.15           O  
ATOM   2216  N   VAL A 278     -14.963  67.579  17.364  1.00 64.28           N  
ATOM   2217  CA  VAL A 278     -15.655  68.864  17.384  1.00 54.60           C  
ATOM   2218  C   VAL A 278     -15.375  69.611  18.686  1.00 52.50           C  
ATOM   2219  O   VAL A 278     -15.417  70.842  18.734  1.00 54.55           O  
ATOM   2220  CB  VAL A 278     -17.185  68.669  17.219  1.00 47.62           C  
ATOM   2221  CG1 VAL A 278     -17.502  68.105  15.834  1.00 42.46           C  
ATOM   2222  CG2 VAL A 278     -17.701  67.738  18.282  1.00 46.29           C  
ATOM   2223  N   ALA A 279     -15.082  68.858  19.739  1.00 43.86           N  
ATOM   2224  CA  ALA A 279     -14.780  69.442  21.033  1.00 43.92           C  
ATOM   2225  C   ALA A 279     -13.660  70.476  20.894  1.00 52.14           C  
ATOM   2226  O   ALA A 279     -13.774  71.600  21.395  1.00 45.25           O  
ATOM   2227  CB  ALA A 279     -14.364  68.345  21.994  1.00 43.47           C  
ATOM   2228  N   ASN A 280     -12.587  70.079  20.204  1.00 56.51           N  
ATOM   2229  CA  ASN A 280     -11.403  70.915  19.969  1.00 48.77           C  
ATOM   2230  C   ASN A 280     -11.747  72.118  19.129  1.00 47.60           C  
ATOM   2231  O   ASN A 280     -11.148  73.183  19.272  1.00 46.15           O  
ATOM   2232  CB  ASN A 280     -10.337  70.123  19.223  1.00 49.48           C  
ATOM   2233  CG  ASN A 280      -9.871  68.906  19.984  1.00 58.47           C  
ATOM   2234  OD1 ASN A 280      -9.192  68.042  19.419  1.00 71.66           O  
ATOM   2235  ND2 ASN A 280     -10.218  68.828  21.270  1.00 52.71           N  
ATOM   2236  N   GLN A 281     -12.696  71.932  18.224  1.00 46.56           N  
ATOM   2237  CA  GLN A 281     -13.108  73.018  17.358  1.00 55.41           C  
ATOM   2238  C   GLN A 281     -13.613  74.191  18.203  1.00 59.39           C  
ATOM   2239  O   GLN A 281     -13.454  75.361  17.847  1.00 57.03           O  
ATOM   2240  CB  GLN A 281     -14.213  72.549  16.431  1.00 51.45           C  
ATOM   2241  CG  GLN A 281     -14.551  73.573  15.393  1.00 55.41           C  
ATOM   2242  CD  GLN A 281     -15.900  73.334  14.776  1.00 60.14           C  
ATOM   2243  OE1 GLN A 281     -16.150  72.284  14.163  1.00 53.67           O  
ATOM   2244  NE2 GLN A 281     -16.793  74.310  14.934  1.00 58.00           N  
ATOM   2245  N   PHE A 282     -14.222  73.863  19.334  1.00 59.81           N  
ATOM   2246  CA  PHE A 282     -14.751  74.867  20.229  1.00 55.57           C  
ATOM   2247  C   PHE A 282     -13.845  75.123  21.422  1.00 55.64           C  
ATOM   2248  O   PHE A 282     -14.279  75.651  22.440  1.00 58.48           O  
ATOM   2249  CB  PHE A 282     -16.132  74.428  20.685  1.00 50.55           C  
ATOM   2250  CG  PHE A 282     -17.172  74.554  19.621  1.00 58.74           C  
ATOM   2251  CD1 PHE A 282     -17.924  75.724  19.497  1.00 58.94           C  
ATOM   2252  CD2 PHE A 282     -17.386  73.525  18.717  1.00 57.18           C  
ATOM   2253  CE1 PHE A 282     -18.880  75.865  18.481  1.00 53.97           C  
ATOM   2254  CE2 PHE A 282     -18.339  73.661  17.698  1.00 59.53           C  
ATOM   2255  CZ  PHE A 282     -19.088  74.835  17.581  1.00 44.07           C  
ATOM   2256  N   GLY A 283     -12.580  74.750  21.293  1.00 56.38           N  
ATOM   2257  CA  GLY A 283     -11.644  74.956  22.379  1.00 55.67           C  
ATOM   2258  C   GLY A 283     -11.807  73.969  23.517  1.00 55.37           C  
ATOM   2259  O   GLY A 283     -11.350  74.230  24.626  1.00 55.51           O  
ATOM   2260  N   GLY A 284     -12.452  72.837  23.255  1.00 52.75           N  
ATOM   2261  CA  GLY A 284     -12.640  71.845  24.299  1.00 57.18           C  
ATOM   2262  C   GLY A 284     -11.716  70.654  24.130  1.00 59.32           C  
ATOM   2263  O   GLY A 284     -10.538  70.819  23.829  1.00 65.99           O  
ATOM   2264  N   GLY A 285     -12.244  69.450  24.330  1.00 59.03           N  
ATOM   2265  CA  GLY A 285     -11.430  68.259  24.177  1.00 60.86           C  
ATOM   2266  C   GLY A 285     -11.861  67.145  25.105  1.00 62.35           C  
ATOM   2267  O   GLY A 285     -12.882  67.250  25.775  1.00 56.91           O  
ATOM   2268  N   GLY A 286     -11.080  66.074  25.149  1.00 67.12           N  
ATOM   2269  CA  GLY A 286     -11.413  64.956  26.010  1.00 69.92           C  
ATOM   2270  C   GLY A 286     -11.380  63.657  25.238  1.00 75.83           C  
ATOM   2271  O   GLY A 286     -10.855  63.600  24.127  1.00 75.53           O  
ATOM   2272  N   HIS A 287     -11.935  62.605  25.826  1.00 78.78           N  
ATOM   2273  CA  HIS A 287     -11.961  61.318  25.154  1.00 81.94           C  
ATOM   2274  C   HIS A 287     -12.883  61.436  23.949  1.00 85.60           C  
ATOM   2275  O   HIS A 287     -13.769  62.296  23.907  1.00 84.32           O  
ATOM   2276  CB  HIS A 287     -12.471  60.242  26.097  1.00 87.42           C  
ATOM   2277  CG  HIS A 287     -11.665  60.113  27.351  1.00 97.12           C  
ATOM   2278  ND1 HIS A 287     -10.344  59.721  27.347  1.00103.18           N  
ATOM   2279  CD2 HIS A 287     -11.993  60.318  28.650  1.00 99.37           C  
ATOM   2280  CE1 HIS A 287      -9.893  59.686  28.587  1.00104.75           C  
ATOM   2281  NE2 HIS A 287     -10.873  60.045  29.398  1.00102.20           N  
ATOM   2282  N   PRO A 288     -12.677  60.580  22.940  1.00 84.46           N  
ATOM   2283  CA  PRO A 288     -13.515  60.617  21.737  1.00 79.11           C  
ATOM   2284  C   PRO A 288     -14.971  60.208  21.988  1.00 74.27           C  
ATOM   2285  O   PRO A 288     -15.825  60.401  21.129  1.00 67.89           O  
ATOM   2286  CB  PRO A 288     -12.793  59.660  20.792  1.00 77.79           C  
ATOM   2287  CG  PRO A 288     -12.183  58.661  21.736  1.00 81.05           C  
ATOM   2288  CD  PRO A 288     -11.637  59.539  22.837  1.00 78.03           C  
ATOM   2289  N   ASN A 289     -15.252  59.650  23.164  1.00 68.46           N  
ATOM   2290  CA  ASN A 289     -16.603  59.217  23.481  1.00 62.03           C  
ATOM   2291  C   ASN A 289     -17.279  60.002  24.601  1.00 64.05           C  
ATOM   2292  O   ASN A 289     -18.460  59.797  24.874  1.00 55.69           O  
ATOM   2293  CB  ASN A 289     -16.592  57.740  23.826  1.00 63.28           C  
ATOM   2294  CG  ASN A 289     -17.250  56.901  22.759  1.00 75.44           C  
ATOM   2295  OD1 ASN A 289     -17.356  55.682  22.889  1.00 88.57           O  
ATOM   2296  ND2 ASN A 289     -17.704  57.554  21.689  1.00 69.26           N  
ATOM   2297  N   ALA A 290     -16.519  60.891  25.240  1.00 62.71           N  
ATOM   2298  CA  ALA A 290     -17.007  61.727  26.331  1.00 56.04           C  
ATOM   2299  C   ALA A 290     -16.070  62.915  26.573  1.00 66.18           C  
ATOM   2300  O   ALA A 290     -15.102  62.824  27.340  1.00 64.64           O  
ATOM   2301  CB  ALA A 290     -17.146  60.900  27.594  1.00 45.82           C  
ATOM   2302  N   SER A 291     -16.361  64.028  25.901  1.00 77.32           N  
ATOM   2303  CA  SER A 291     -15.577  65.262  26.030  1.00 77.18           C  
ATOM   2304  C   SER A 291     -16.396  66.364  26.714  1.00 71.46           C  
ATOM   2305  O   SER A 291     -17.528  66.139  27.143  1.00 66.11           O  
ATOM   2306  CB  SER A 291     -15.119  65.742  24.651  1.00 73.71           C  
ATOM   2307  OG  SER A 291     -14.128  64.879  24.123  1.00 82.01           O  
ATOM   2308  N   GLY A 292     -15.813  67.551  26.811  1.00 67.26           N  
ATOM   2309  CA  GLY A 292     -16.495  68.660  27.442  1.00 59.36           C  
ATOM   2310  C   GLY A 292     -16.099  69.979  26.815  1.00 59.93           C  
ATOM   2311  O   GLY A 292     -14.981  70.142  26.332  1.00 60.17           O  
ATOM   2312  N   VAL A 293     -17.024  70.928  26.825  1.00 61.64           N  
ATOM   2313  CA  VAL A 293     -16.794  72.243  26.251  1.00 57.67           C  
ATOM   2314  C   VAL A 293     -17.424  73.268  27.175  1.00 60.90           C  
ATOM   2315  O   VAL A 293     -18.318  72.934  27.953  1.00 63.44           O  
ATOM   2316  CB  VAL A 293     -17.455  72.350  24.870  1.00 56.76           C  
ATOM   2317  CG1 VAL A 293     -17.342  73.770  24.346  1.00 54.74           C  
ATOM   2318  CG2 VAL A 293     -16.820  71.355  23.914  1.00 46.12           C  
ATOM   2319  N   SER A 294     -16.967  74.511  27.097  1.00 59.50           N  
ATOM   2320  CA  SER A 294     -17.517  75.555  27.947  1.00 62.45           C  
ATOM   2321  C   SER A 294     -17.856  76.786  27.134  1.00 61.96           C  
ATOM   2322  O   SER A 294     -17.148  77.791  27.180  1.00 66.01           O  
ATOM   2323  CB  SER A 294     -16.526  75.929  29.055  1.00 65.66           C  
ATOM   2324  OG  SER A 294     -16.233  74.807  29.882  1.00 81.22           O  
ATOM   2325  N   VAL A 295     -18.949  76.701  26.388  1.00 60.02           N  
ATOM   2326  CA  VAL A 295     -19.408  77.809  25.564  1.00 63.49           C  
ATOM   2327  C   VAL A 295     -19.784  79.022  26.428  1.00 65.33           C  
ATOM   2328  O   VAL A 295     -19.988  78.893  27.635  1.00 65.62           O  
ATOM   2329  CB  VAL A 295     -20.632  77.374  24.709  1.00 62.99           C  
ATOM   2330  CG1 VAL A 295     -20.225  76.240  23.790  1.00 71.62           C  
ATOM   2331  CG2 VAL A 295     -21.782  76.920  25.602  1.00 58.66           C  
ATOM   2332  N   TYR A 296     -19.860  80.197  25.811  1.00 61.99           N  
ATOM   2333  CA  TYR A 296     -20.217  81.420  26.522  1.00 52.97           C  
ATOM   2334  C   TYR A 296     -21.660  81.836  26.279  1.00 49.90           C  
ATOM   2335  O   TYR A 296     -22.098  82.861  26.785  1.00 50.85           O  
ATOM   2336  CB  TYR A 296     -19.302  82.573  26.104  1.00 58.69           C  
ATOM   2337  CG  TYR A 296     -17.957  82.580  26.789  1.00 57.55           C  
ATOM   2338  CD1 TYR A 296     -17.865  82.541  28.171  1.00 61.16           C  
ATOM   2339  CD2 TYR A 296     -16.777  82.629  26.054  1.00 63.26           C  
ATOM   2340  CE1 TYR A 296     -16.635  82.545  28.809  1.00 67.35           C  
ATOM   2341  CE2 TYR A 296     -15.535  82.637  26.684  1.00 64.26           C  
ATOM   2342  CZ  TYR A 296     -15.477  82.593  28.064  1.00 65.82           C  
ATOM   2343  OH  TYR A 296     -14.269  82.595  28.711  1.00 77.72           O  
ATOM   2344  N   SER A 297     -22.398  81.058  25.497  1.00 50.23           N  
ATOM   2345  CA  SER A 297     -23.785  81.396  25.218  1.00 47.21           C  
ATOM   2346  C   SER A 297     -24.535  80.227  24.629  1.00 45.63           C  
ATOM   2347  O   SER A 297     -23.921  79.282  24.136  1.00 41.30           O  
ATOM   2348  CB  SER A 297     -23.860  82.565  24.240  1.00 54.95           C  
ATOM   2349  OG  SER A 297     -23.625  82.131  22.912  1.00 55.99           O  
ATOM   2350  N   TRP A 298     -25.865  80.293  24.673  1.00 51.23           N  
ATOM   2351  CA  TRP A 298     -26.667  79.212  24.110  1.00 61.83           C  
ATOM   2352  C   TRP A 298     -26.633  79.280  22.597  1.00 64.54           C  
ATOM   2353  O   TRP A 298     -26.848  78.272  21.924  1.00 69.91           O  
ATOM   2354  CB  TRP A 298     -28.127  79.261  24.583  1.00 58.58           C  
ATOM   2355  CG  TRP A 298     -28.278  78.998  26.034  1.00 54.96           C  
ATOM   2356  CD1 TRP A 298     -28.557  79.913  26.991  1.00 55.31           C  
ATOM   2357  CD2 TRP A 298     -28.051  77.757  26.717  1.00 57.78           C  
ATOM   2358  NE1 TRP A 298     -28.508  79.332  28.232  1.00 61.01           N  
ATOM   2359  CE2 TRP A 298     -28.197  78.005  28.092  1.00 57.65           C  
ATOM   2360  CE3 TRP A 298     -27.729  76.462  26.299  1.00 63.08           C  
ATOM   2361  CZ2 TRP A 298     -28.036  77.014  29.058  1.00 58.04           C  
ATOM   2362  CZ3 TRP A 298     -27.566  75.469  27.262  1.00 60.67           C  
ATOM   2363  CH2 TRP A 298     -27.718  75.754  28.625  1.00 62.03           C  
ATOM   2364  N   ASP A 299     -26.365  80.463  22.055  1.00 63.32           N  
ATOM   2365  CA  ASP A 299     -26.292  80.597  20.604  1.00 69.74           C  
ATOM   2366  C   ASP A 299     -25.092  79.794  20.081  1.00 62.77           C  
ATOM   2367  O   ASP A 299     -25.136  79.203  18.994  1.00 51.05           O  
ATOM   2368  CB  ASP A 299     -26.174  82.074  20.211  1.00 78.89           C  
ATOM   2369  CG  ASP A 299     -27.317  82.527  19.311  1.00 87.75           C  
ATOM   2370  OD1 ASP A 299     -27.600  81.815  18.309  1.00 93.84           O  
ATOM   2371  OD2 ASP A 299     -27.923  83.590  19.603  1.00 75.46           O  
ATOM   2372  N   GLU A 300     -24.030  79.789  20.885  1.00 57.45           N  
ATOM   2373  CA  GLU A 300     -22.792  79.066  20.608  1.00 57.43           C  
ATOM   2374  C   GLU A 300     -23.025  77.593  20.898  1.00 56.30           C  
ATOM   2375  O   GLU A 300     -22.476  76.724  20.228  1.00 61.33           O  
ATOM   2376  CB  GLU A 300     -21.659  79.624  21.491  1.00 58.98           C  
ATOM   2377  CG  GLU A 300     -20.449  78.707  21.717  1.00 64.18           C  
ATOM   2378  CD  GLU A 300     -19.254  79.429  22.389  1.00 76.60           C  
ATOM   2379  OE1 GLU A 300     -19.472  80.334  23.232  1.00 62.80           O  
ATOM   2380  OE2 GLU A 300     -18.088  79.079  22.083  1.00 77.83           O  
ATOM   2381  N   PHE A 301     -23.844  77.327  21.909  1.00 54.06           N  
ATOM   2382  CA  PHE A 301     -24.185  75.964  22.302  1.00 49.13           C  
ATOM   2383  C   PHE A 301     -24.843  75.289  21.117  1.00 52.57           C  
ATOM   2384  O   PHE A 301     -24.665  74.093  20.875  1.00 43.21           O  
ATOM   2385  CB  PHE A 301     -25.178  76.000  23.447  1.00 41.33           C  
ATOM   2386  CG  PHE A 301     -25.598  74.653  23.932  1.00 41.41           C  
ATOM   2387  CD1 PHE A 301     -24.775  73.923  24.789  1.00 47.49           C  
ATOM   2388  CD2 PHE A 301     -26.846  74.148  23.607  1.00 34.63           C  
ATOM   2389  CE1 PHE A 301     -25.193  72.707  25.330  1.00 37.89           C  
ATOM   2390  CE2 PHE A 301     -27.273  72.935  24.141  1.00 43.57           C  
ATOM   2391  CZ  PHE A 301     -26.440  72.213  25.011  1.00 42.82           C  
ATOM   2392  N   GLU A 302     -25.615  76.079  20.384  1.00 55.27           N  
ATOM   2393  CA  GLU A 302     -26.306  75.576  19.222  1.00 60.08           C  
ATOM   2394  C   GLU A 302     -25.329  75.334  18.088  1.00 60.36           C  
ATOM   2395  O   GLU A 302     -25.493  74.396  17.314  1.00 65.16           O  
ATOM   2396  CB  GLU A 302     -27.383  76.556  18.773  1.00 65.91           C  
ATOM   2397  CG  GLU A 302     -27.903  76.267  17.370  1.00 76.19           C  
ATOM   2398  CD  GLU A 302     -28.572  74.907  17.245  1.00 75.80           C  
ATOM   2399  OE1 GLU A 302     -28.902  74.526  16.100  1.00 70.37           O  
ATOM   2400  OE2 GLU A 302     -28.777  74.227  18.280  1.00 74.94           O  
ATOM   2401  N   GLU A 303     -24.315  76.176  17.960  1.00 56.32           N  
ATOM   2402  CA  GLU A 303     -23.357  75.945  16.893  1.00 59.82           C  
ATOM   2403  C   GLU A 303     -22.715  74.595  17.129  1.00 61.19           C  
ATOM   2404  O   GLU A 303     -22.443  73.855  16.183  1.00 64.57           O  
ATOM   2405  CB  GLU A 303     -22.292  77.021  16.884  1.00 61.81           C  
ATOM   2406  CG  GLU A 303     -22.850  78.372  16.574  1.00 73.11           C  
ATOM   2407  CD  GLU A 303     -21.771  79.408  16.479  1.00 76.29           C  
ATOM   2408  OE1 GLU A 303     -22.112  80.605  16.319  1.00 83.19           O  
ATOM   2409  OE2 GLU A 303     -20.582  79.021  16.565  1.00 68.20           O  
ATOM   2410  N   LEU A 304     -22.486  74.280  18.402  1.00 57.92           N  
ATOM   2411  CA  LEU A 304     -21.894  73.007  18.791  1.00 48.59           C  
ATOM   2412  C   LEU A 304     -22.832  71.884  18.392  1.00 51.37           C  
ATOM   2413  O   LEU A 304     -22.399  70.848  17.890  1.00 48.68           O  
ATOM   2414  CB  LEU A 304     -21.670  72.955  20.296  1.00 38.38           C  
ATOM   2415  CG  LEU A 304     -20.354  72.270  20.640  1.00 42.05           C  
ATOM   2416  CD1 LEU A 304     -20.052  72.463  22.107  1.00 42.43           C  
ATOM   2417  CD2 LEU A 304     -20.413  70.807  20.270  1.00 42.39           C  
ATOM   2418  N   ALA A 305     -24.125  72.090  18.627  1.00 50.79           N  
ATOM   2419  CA  ALA A 305     -25.115  71.082  18.277  1.00 53.95           C  
ATOM   2420  C   ALA A 305     -25.059  70.824  16.773  1.00 52.17           C  
ATOM   2421  O   ALA A 305     -25.079  69.677  16.329  1.00 51.16           O  
ATOM   2422  CB  ALA A 305     -26.516  71.547  18.692  1.00 41.16           C  
ATOM   2423  N   GLN A 306     -24.978  71.902  16.002  1.00 49.23           N  
ATOM   2424  CA  GLN A 306     -24.927  71.817  14.556  1.00 59.78           C  
ATOM   2425  C   GLN A 306     -23.697  71.035  14.120  1.00 62.70           C  
ATOM   2426  O   GLN A 306     -23.774  70.173  13.237  1.00 65.25           O  
ATOM   2427  CB  GLN A 306     -24.891  73.225  13.954  1.00 74.65           C  
ATOM   2428  CG  GLN A 306     -26.203  74.016  14.055  1.00 89.12           C  
ATOM   2429  CD  GLN A 306     -27.128  73.822  12.841  1.00 97.33           C  
ATOM   2430  OE1 GLN A 306     -26.780  74.186  11.709  1.00 93.65           O  
ATOM   2431  NE2 GLN A 306     -28.311  73.255  13.079  1.00102.05           N  
ATOM   2432  N   ALA A 307     -22.562  71.339  14.742  1.00 55.29           N  
ATOM   2433  CA  ALA A 307     -21.307  70.665  14.424  1.00 52.67           C  
ATOM   2434  C   ALA A 307     -21.398  69.179  14.755  1.00 56.25           C  
ATOM   2435  O   ALA A 307     -20.954  68.334  13.974  1.00 58.29           O  
ATOM   2436  CB  ALA A 307     -20.172  71.302  15.199  1.00 45.35           C  
ATOM   2437  N   LEU A 308     -21.974  68.871  15.918  1.00 54.18           N  
ATOM   2438  CA  LEU A 308     -22.141  67.491  16.361  1.00 50.64           C  
ATOM   2439  C   LEU A 308     -23.079  66.732  15.445  1.00 55.87           C  
ATOM   2440  O   LEU A 308     -22.801  65.602  15.037  1.00 58.83           O  
ATOM   2441  CB  LEU A 308     -22.711  67.439  17.771  1.00 39.32           C  
ATOM   2442  CG  LEU A 308     -21.768  67.781  18.911  1.00 36.95           C  
ATOM   2443  CD1 LEU A 308     -22.547  67.753  20.211  1.00 38.97           C  
ATOM   2444  CD2 LEU A 308     -20.638  66.803  18.942  1.00 17.42           C  
ATOM   2445  N   ARG A 309     -24.204  67.358  15.131  1.00 60.58           N  
ATOM   2446  CA  ARG A 309     -25.192  66.736  14.277  1.00 55.79           C  
ATOM   2447  C   ARG A 309     -24.630  66.446  12.884  1.00 57.38           C  
ATOM   2448  O   ARG A 309     -24.926  65.393  12.312  1.00 56.48           O  
ATOM   2449  CB  ARG A 309     -26.437  67.626  14.207  1.00 54.39           C  
ATOM   2450  CG  ARG A 309     -27.714  66.931  14.700  1.00 61.51           C  
ATOM   2451  CD  ARG A 309     -28.913  67.883  14.714  1.00 61.44           C  
ATOM   2452  NE  ARG A 309     -28.817  68.839  15.814  1.00 68.65           N  
ATOM   2453  CZ  ARG A 309     -29.016  70.149  15.694  1.00 71.38           C  
ATOM   2454  NH1 ARG A 309     -29.325  70.663  14.507  1.00 69.73           N  
ATOM   2455  NH2 ARG A 309     -28.909  70.940  16.763  1.00 59.96           N  
ATOM   2456  N   GLN A 310     -23.805  67.356  12.353  1.00 53.68           N  
ATOM   2457  CA  GLN A 310     -23.194  67.198  11.019  1.00 52.27           C  
ATOM   2458  C   GLN A 310     -22.284  65.971  10.988  1.00 52.38           C  
ATOM   2459  O   GLN A 310     -22.066  65.360   9.937  1.00 41.67           O  
ATOM   2460  CB  GLN A 310     -22.368  68.440  10.655  1.00 57.18           C  
ATOM   2461  CG  GLN A 310     -22.050  68.581   9.155  1.00 55.98           C  
ATOM   2462  CD  GLN A 310     -20.913  69.570   8.856  1.00 60.30           C  
ATOM   2463  OE1 GLN A 310     -20.730  69.990   7.716  1.00 63.61           O  
ATOM   2464  NE2 GLN A 310     -20.141  69.929   9.881  1.00 63.36           N  
ATOM   2465  N   LYS A 311     -21.744  65.637  12.155  1.00 52.38           N  
ATOM   2466  CA  LYS A 311     -20.872  64.488  12.314  1.00 54.89           C  
ATOM   2467  C   LYS A 311     -21.660  63.221  12.006  1.00 62.24           C  
ATOM   2468  O   LYS A 311     -21.098  62.214  11.574  1.00 71.76           O  
ATOM   2469  CB  LYS A 311     -20.344  64.430  13.745  1.00 49.70           C  
ATOM   2470  CG  LYS A 311     -18.875  64.758  13.887  1.00 55.75           C  
ATOM   2471  CD  LYS A 311     -18.013  63.610  13.392  1.00 56.21           C  
ATOM   2472  CE  LYS A 311     -16.520  63.943  13.452  1.00 65.58           C  
ATOM   2473  NZ  LYS A 311     -15.994  64.171  14.836  1.00 69.15           N  
ATOM   2474  N   LEU A 312     -22.969  63.277  12.227  1.00 61.87           N  
ATOM   2475  CA  LEU A 312     -23.832  62.134  11.970  1.00 60.55           C  
ATOM   2476  C   LEU A 312     -24.115  61.945  10.485  1.00 65.70           C  
ATOM   2477  O   LEU A 312     -24.659  60.922  10.089  1.00 62.64           O  
ATOM   2478  CB  LEU A 312     -25.154  62.296  12.720  1.00 55.36           C  
ATOM   2479  CG  LEU A 312     -25.283  61.695  14.119  1.00 54.70           C  
ATOM   2480  CD1 LEU A 312     -24.094  62.054  15.005  1.00 57.59           C  
ATOM   2481  CD2 LEU A 312     -26.579  62.191  14.707  1.00 55.00           C  
ATOM   2482  N   LEU A 313     -23.755  62.918   9.657  1.00 69.33           N  
ATOM   2483  CA  LEU A 313     -24.025  62.780   8.237  1.00 74.64           C  
ATOM   2484  C   LEU A 313     -22.965  61.900   7.578  1.00 86.65           C  
ATOM   2485  O   LEU A 313     -23.260  61.177   6.621  1.00 90.77           O  
ATOM   2486  CB  LEU A 313     -24.101  64.164   7.567  1.00 69.23           C  
ATOM   2487  CG  LEU A 313     -24.797  64.296   6.193  1.00 73.68           C  
ATOM   2488  CD1 LEU A 313     -26.208  63.743   6.267  1.00 72.96           C  
ATOM   2489  CD2 LEU A 313     -24.838  65.755   5.751  1.00 64.44           C  
ATOM   2490  N   GLU A 314     -21.738  61.935   8.100  1.00 94.95           N  
ATOM   2491  CA  GLU A 314     -20.642  61.127   7.542  1.00102.28           C  
ATOM   2492  C   GLU A 314     -20.845  59.630   7.789  1.00104.12           C  
ATOM   2493  O   GLU A 314     -20.275  58.788   7.093  1.00101.63           O  
ATOM   2494  CB  GLU A 314     -19.296  61.563   8.139  1.00105.26           C  
ATOM   2495  CG  GLU A 314     -18.882  62.995   7.811  1.00107.09           C  
ATOM   2496  CD  GLU A 314     -17.488  63.332   8.320  1.00111.27           C  
ATOM   2497  OE1 GLU A 314     -17.079  64.510   8.217  1.00104.85           O  
ATOM   2498  OE2 GLU A 314     -16.796  62.415   8.821  1.00110.94           O  
ATOM   2499  N   HIS A 315     -21.663  59.311   8.785  1.00106.24           N  
ATOM   2500  CA  HIS A 315     -21.945  57.926   9.133  1.00108.00           C  
ATOM   2501  C   HIS A 315     -23.426  57.639   8.864  1.00113.67           C  
ATOM   2502  O   HIS A 315     -24.273  58.502   9.089  1.00120.07           O  
ATOM   2503  CB  HIS A 315     -21.627  57.697  10.611  1.00102.96           C  
ATOM   2504  CG  HIS A 315     -20.310  58.267  11.043  1.00107.46           C  
ATOM   2505  ND1 HIS A 315     -19.962  59.583  10.830  1.00110.18           N  
ATOM   2506  CD2 HIS A 315     -19.268  57.707  11.703  1.00111.51           C  
ATOM   2507  CE1 HIS A 315     -18.765  59.811  11.340  1.00110.51           C  
ATOM   2508  NE2 HIS A 315     -18.321  58.689  11.877  1.00114.31           N  
ATOM   2509  N   HIS A 316     -23.732  56.435   8.379  1.00116.19           N  
ATOM   2510  CA  HIS A 316     -25.111  56.028   8.086  1.00113.29           C  
ATOM   2511  C   HIS A 316     -25.158  54.595   7.546  1.00109.20           C  
ATOM   2512  O   HIS A 316     -24.114  53.909   7.628  1.00103.32           O  
ATOM   2513  CB  HIS A 316     -25.765  57.001   7.089  1.00113.10           C  
ATOM   2514  CG  HIS A 316     -26.857  57.839   7.687  1.00119.03           C  
ATOM   2515  ND1 HIS A 316     -27.523  58.816   6.978  1.00118.10           N  
ATOM   2516  CD2 HIS A 316     -27.413  57.830   8.924  1.00119.46           C  
ATOM   2517  CE1 HIS A 316     -28.442  59.372   7.749  1.00116.84           C  
ATOM   2518  NE2 HIS A 316     -28.396  58.790   8.936  1.00117.36           N  
TER    2519      HIS A 316                                                      
END
MOLECULE T0501_2_214.pdb
ATOM      1  CB  LEU     2      -9.118  30.738  34.125  1.00 51.67          
ATOM      2  CG  LEU     2     -10.314  30.118  34.866  1.00 53.86          
ATOM      3  CD1 LEU     2     -11.388  29.708  33.864  1.00 54.66          
ATOM      4  CD2 LEU     2      -9.859  28.897  35.667  1.00 54.00          
ATOM      5  C   LEU     2      -6.735  31.546  34.073  1.00 48.54          
ATOM      6  O   LEU     2      -5.767  30.796  34.138  1.00 49.26          
ATOM      7  N   LEU     2      -8.396  32.565  35.655  1.00 50.89          
ATOM      8  CA  LEU     2      -7.962  31.312  34.963  1.00 49.96          
ATOM      9  N   THR     3      -6.780  32.590  33.254  1.00 46.10          
ATOM     10  CA  THR     3      -5.683  32.929  32.353  1.00 45.01          
ATOM     11  CB  THR     3      -6.219  33.711  31.127  1.00 45.64          
ATOM     12  OG1 THR     3      -7.112  32.873  30.384  1.00 47.96          
ATOM     13  CG2 THR     3      -5.093  34.165  30.226  1.00 42.04          
ATOM     14  C   THR     3      -4.635  33.777  33.073  1.00 45.61          
ATOM     15  O   THR     3      -4.978  34.589  33.928  1.00 45.72          
ATOM     16  N   LYS     4      -3.361  33.589  32.727  1.00 45.17          
ATOM     17  CA  LYS     4      -2.269  34.343  33.350  1.00 44.57          
ATOM     18  CB  LYS     4      -0.961  33.536  33.320  1.00 45.36          
ATOM     19  CG  LYS     4      -0.965  32.307  34.221  1.00 48.99          
ATOM     20  CD  LYS     4       0.398  31.634  34.276  1.00 49.41          
ATOM     21  CE  LYS     4       0.359  30.402  35.179  1.00 52.94          
ATOM     22  NZ  LYS     4       1.684  29.705  35.252  1.00 53.72          
ATOM     23  C   LYS     4      -2.044  35.683  32.660  1.00 41.65          
ATOM     24  O   LYS     4      -1.392  35.751  31.622  1.00 43.14          
ATOM     25  N   VAL     5      -2.581  36.746  33.247  1.00 38.71          
ATOM     26  CA  VAL     5      -2.449  38.087  32.694  1.00 35.10          
ATOM     27  CB  VAL     5      -3.719  38.935  32.989  1.00 35.84          
ATOM     28  CG1 VAL     5      -3.490  40.413  32.581  1.00 35.47          
ATOM     29  CG2 VAL     5      -4.909  38.356  32.228  1.00 33.49          
ATOM     30  C   VAL     5      -1.230  38.803  33.256  1.00 34.67          
ATOM     31  O   VAL     5      -0.446  39.389  32.512  1.00 34.53          
ATOM     32  N   ILE     6      -1.081  38.777  34.575  1.00 35.13          
ATOM     33  CA  ILE     6       0.052  39.425  35.220  1.00 34.65          
ATOM     34  CB  ILE     6      -0.186  39.580  36.737  1.00 34.25          
ATOM     35  CG2 ILE     6       1.015  40.268  37.390  1.00 31.59          
ATOM     36  CG1 ILE     6      -1.479  40.370  36.987  1.00 33.48          
ATOM     37  CD  ILE     6      -1.867  40.457  38.449  1.00 28.08          
ATOM     38  C   ILE     6       1.316  38.592  35.005  1.00 36.03          
ATOM     39  O   ILE     6       1.293  37.358  35.133  1.00 34.96          
ATOM     40  N   ALA     7       2.410  39.270  34.677  1.00 35.53          
ATOM     41  CA  ALA     7       3.688  38.599  34.454  1.00 40.36          
ATOM     42  CB  ALA     7       4.716  39.599  33.927  1.00 38.81          
ATOM     43  C   ALA     7       4.207  37.938  35.732  1.00 40.87          
ATOM     44  O   ALA     7       4.298  38.573  36.779  1.00 45.09          
ATOM     45  N   GLN     8       4.545  36.657  35.636  1.00 42.36          
ATOM     46  CA  GLN     8       5.055  35.903  36.773  1.00 42.67          
ATOM     47  CB  GLN     8       5.416  34.485  36.337  1.00 42.33          
ATOM     48  CG  GLN     8       5.795  33.566  37.488  1.00 43.24          
ATOM     49  CD  GLN     8       4.603  33.197  38.345  1.00 42.83          
ATOM     50  OE1 GLN     8       3.578  32.755  37.829  1.00 43.63          
ATOM     51  NE2 GLN     8       4.730  33.369  39.659  1.00 42.46          
ATOM     52  C   GLN     8       6.285  36.560  37.406  1.00 43.98          
ATOM     53  O   GLN     8       6.493  36.463  38.617  1.00 45.06          
ATOM     54  N   ALA     9       7.111  37.210  36.593  1.00 42.49          
ATOM     55  CA  ALA     9       8.298  37.862  37.124  1.00 43.37          
ATOM     56  CB  ALA     9       9.098  38.497  36.005  1.00 42.79          
ATOM     57  C   ALA     9       7.874  38.922  38.133  1.00 43.16          
ATOM     58  O   ALA     9       8.433  39.003  39.224  1.00 43.57          
ATOM     59  N   HSD    10       6.879  39.728  37.767  1.00 43.39          
ATOM     60  CA  HSD    10       6.378  40.775  38.656  1.00 42.97          
ATOM     61  CB  HSD    10       5.314  41.637  37.953  1.00 43.19          
ATOM     62  CG  HSD    10       5.860  42.491  36.848  1.00 43.10          
ATOM     63  CD2 HSD    10       5.242  43.290  35.945  1.00 42.11          
ATOM     64  ND1 HSD    10       7.209  42.592  36.585  1.00 42.30          
ATOM     65  CE1 HSD    10       7.400  43.415  35.569  1.00 42.04          
ATOM     66  NE2 HSD    10       6.223  43.853  35.162  1.00 43.04          
ATOM     67  C   HSD    10       5.797  40.156  39.921  1.00 42.31          
ATOM     68  O   HSD    10       6.043  40.647  41.023  1.00 43.53          
ATOM     69  N   ILE    11       5.041  39.073  39.771  1.00 40.92          
ATOM     70  CA  ILE    11       4.459  38.406  40.933  1.00 39.12          
ATOM     71  CB  ILE    11       3.550  37.251  40.516  1.00 38.41          
ATOM     72  CG2 ILE    11       3.084  36.472  41.746  1.00 36.95          
ATOM     73  CG1 ILE    11       2.343  37.798  39.762  1.00 38.19          
ATOM     74  CD  ILE    11       1.493  36.728  39.145  1.00 36.04          
ATOM     75  C   ILE    11       5.555  37.859  41.845  1.00 40.95          
ATOM     76  O   ILE    11       5.434  37.897  43.070  1.00 41.13          
ATOM     77  N   ASP    12       6.625  37.345  41.250  1.00 41.17          
ATOM     78  CA  ASP    12       7.722  36.813  42.041  1.00 39.63          
ATOM     79  CB  ASP    12       8.733  36.075  41.145  1.00 41.10          
ATOM     80  CG  ASP    12       8.187  34.764  40.592  1.00 45.36          
ATOM     81  OD1 ASP    12       7.295  34.167  41.236  1.00 46.36          
ATOM     82  OD2 ASP    12       8.665  34.318  39.525  1.00 45.15          
ATOM     83  C   ASP    12       8.427  37.947  42.792  1.00 38.33          
ATOM     84  O   ASP    12       8.723  37.822  43.973  1.00 37.84          
ATOM     85  N   HSD    13       8.685  39.050  42.099  1.00 37.35          
ATOM     86  CA  HSD    13       9.360  40.196  42.690  1.00 39.45          
ATOM     87  CB  HSD    13       9.590  41.260  41.610  1.00 40.12          
ATOM     88  CG  HSD    13      10.658  42.253  41.949  1.00 41.22          
ATOM     89  CD2 HSD    13      11.393  42.426  43.072  1.00 42.23          
ATOM     90  ND1 HSD    13      11.090  43.212  41.058  1.00 42.76          
ATOM     91  CE1 HSD    13      12.046  43.933  41.617  1.00 41.42          
ATOM     92  NE2 HSD    13      12.250  43.476  42.839  1.00 40.50          
ATOM     93  C   HSD    13       8.562  40.786  43.860  1.00 40.08          
ATOM     94  O   HSD    13       9.110  41.060  44.929  1.00 41.01          
ATOM     95  N   PHE    14       7.261  40.970  43.661  1.00 39.38          
ATOM     96  CA  PHE    14       6.418  41.523  44.709  1.00 37.21          
ATOM     97  CB  PHE    14       5.003  41.780  44.192  1.00 36.26          
ATOM     98  CG  PHE    14       4.072  42.304  45.245  1.00 36.60          
ATOM     99  CD1 PHE    14       4.258  43.577  45.781  1.00 36.10          
ATOM    100  CD2 PHE    14       3.048  41.514  45.742  1.00 35.62          
ATOM    101  CE1 PHE    14       3.443  44.049  46.794  1.00 34.53          
ATOM    102  CE2 PHE    14       2.223  41.981  46.763  1.00 37.98          
ATOM    103  CZ  PHE    14       2.424  43.250  47.288  1.00 36.03          
ATOM    104  C   PHE    14       6.348  40.594  45.909  1.00 38.11          
ATOM    105  O   PHE    14       6.388  41.048  47.054  1.00 38.55          
ATOM    106  N   THR    15       6.222  39.296  45.653  1.00 37.59          
ATOM    107  CA  THR    15       6.157  38.325  46.735  1.00 39.05          
ATOM    108  CB  THR    15       6.103  36.890  46.205  1.00 36.44          
ATOM    109  OG1 THR    15       4.966  36.742  45.345  1.00 38.35          
ATOM    110  CG2 THR    15       5.963  35.912  47.352  1.00 34.02          
ATOM    111  C   THR    15       7.400  38.484  47.606  1.00 42.40          
ATOM    112  O   THR    15       7.339  38.328  48.828  1.00 42.29          
ATOM    113  N   LYS    16       8.527  38.797  46.969  1.00 44.18          
ATOM    114  CA  LYS    16       9.778  39.007  47.694  1.00 44.92          
ATOM    115  CB  LYS    16      10.915  39.323  46.713  1.00 48.14          
ATOM    116  CG  LYS    16      12.274  39.551  47.371  1.00 52.51          
ATOM    117  CD  LYS    16      13.345  39.979  46.361  1.00 55.04          
ATOM    118  CE  LYS    16      13.644  38.873  45.356  1.00 56.85          
ATOM    119  NZ  LYS    16      14.735  39.260  44.414  1.00 58.69          
ATOM    120  C   LYS    16       9.572  40.183  48.652  1.00 43.53          
ATOM    121  O   LYS    16       9.674  40.026  49.868  1.00 42.77          
ATOM    122  N   TRP    17       9.289  41.359  48.097  1.00 41.76          
ATOM    123  CA  TRP    17       9.045  42.553  48.901  1.00 41.20          
ATOM    124  CB  TRP    17       8.451  43.664  48.036  1.00 39.38          
ATOM    125  CG  TRP    17       9.375  44.302  47.035  1.00 37.40          
ATOM    126  CD2 TRP    17       9.049  45.382  46.143  1.00 34.69          
ATOM    127  CE2 TRP    17      10.204  45.659  45.381  1.00 32.93          
ATOM    128  CE3 TRP    17       7.890  46.136  45.915  1.00 31.13          
ATOM    129  CD1 TRP    17      10.678  43.983  46.787  1.00 36.45          
ATOM    130  NE1 TRP    17      11.184  44.796  45.792  1.00 34.75          
ATOM    131  CZ2 TRP    17      10.235  46.660  44.406  1.00 33.80          
ATOM    132  CZ3 TRP    17       7.919  47.130  44.949  1.00 32.34          
ATOM    133  CH2 TRP    17       9.084  47.383  44.203  1.00 33.90          
ATOM    134  C   TRP    17       8.044  42.244  50.022  1.00 43.35          
ATOM    135  O   TRP    17       8.238  42.608  51.179  1.00 43.42          
ATOM    136  N   PHE    18       6.968  41.564  49.645  1.00 44.83          
ATOM    137  CA  PHE    18       5.879  41.199  50.543  1.00 45.58          
ATOM    138  CB  PHE    18       4.843  40.373  49.771  1.00 44.15          
ATOM    139  CG  PHE    18       3.866  39.646  50.647  1.00 40.28          
ATOM    140  CD1 PHE    18       2.867  40.333  51.318  1.00 39.22          
ATOM    141  CD2 PHE    18       3.951  38.268  50.799  1.00 38.13          
ATOM    142  CE1 PHE    18       1.958  39.654  52.130  1.00 40.88          
ATOM    143  CE2 PHE    18       3.058  37.580  51.602  1.00 37.25          
ATOM    144  CZ  PHE    18       2.054  38.273  52.273  1.00 38.48          
ATOM    145  C   PHE    18       6.257  40.451  51.813  1.00 48.27          
ATOM    146  O   PHE    18       5.813  40.806  52.905  1.00 48.40          
ATOM    147  N   GLU    19       7.061  39.406  51.677  1.00 50.96          
ATOM    148  CA  GLU    19       7.450  38.619  52.834  1.00 52.43          
ATOM    149  CB  GLU    19       7.977  37.267  52.359  1.00 55.35          
ATOM    150  CG  GLU    19       6.900  36.491  51.606  1.00 59.69          
ATOM    151  CD  GLU    19       7.355  35.133  51.120  1.00 63.06          
ATOM    152  OE1 GLU    19       8.409  35.061  50.443  1.00 64.77          
ATOM    153  OE2 GLU    19       6.646  34.140  51.407  1.00 64.02          
ATOM    154  C   GLU    19       8.451  39.331  53.736  1.00 51.66          
ATOM    155  O   GLU    19       8.501  39.087  54.941  1.00 50.92          
ATOM    156  N   ARG    20       9.217  40.240  53.150  1.00 51.24          
ATOM    157  CA  ARG    20      10.220  40.998  53.883  1.00 52.55          
ATOM    158  CB  ARG    20      11.332  41.426  52.919  1.00 55.09          
ATOM    159  CG  ARG    20      12.409  42.314  53.530  1.00 60.07          
ATOM    160  CD  ARG    20      13.466  42.689  52.488  1.00 64.44          
ATOM    161  NE  ARG    20      14.431  43.670  52.986  1.00 67.58          
ATOM    162  CZ  ARG    20      15.436  44.161  52.263  1.00 68.91          
ATOM    163  NH1 ARG    20      15.609  43.759  51.008  1.00 68.88          
ATOM    164  NH2 ARG    20      16.263  45.059  52.789  1.00 69.46          
ATOM    165  C   ARG    20       9.642  42.238  54.580  1.00 51.72          
ATOM    166  O   ARG    20      10.138  42.663  55.627  1.00 51.01          
ATOM    167  N   ALA    21       8.588  42.803  53.999  1.00 49.64          
ATOM    168  CA  ALA    21       7.963  44.009  54.528  1.00 47.85          
ATOM    169  CB  ALA    21       6.974  44.561  53.498  1.00 49.46          
ATOM    170  C   ALA    21       7.262  43.872  55.875  1.00 47.01          
ATOM    171  O   ALA    21       6.695  42.825  56.189  1.00 47.44          
ATOM    172  N   ASP    22       7.317  44.945  56.665  1.00 45.09          
ATOM    173  CA  ASP    22       6.652  45.007  57.967  1.00 45.38          
ATOM    174  CB  ASP    22       7.620  45.424  59.083  1.00 47.61          
ATOM    175  CG  ASP    22       8.679  44.373  59.379  1.00 52.55          
ATOM    176  OD1 ASP    22       8.313  43.191  59.585  1.00 54.15          
ATOM    177  OD2 ASP    22       9.879  44.740  59.418  1.00 53.54          
ATOM    178  C   ASP    22       5.559  46.073  57.878  1.00 42.79          
ATOM    179  O   ASP    22       4.439  45.876  58.331  1.00 41.20          
ATOM    180  N   LYS    23       5.917  47.211  57.296  1.00 41.31          
ATOM    181  CA  LYS    23       5.007  48.338  57.156  1.00 40.07          
ATOM    182  CB  LYS    23       5.647  49.611  57.723  1.00 40.15          
ATOM    183  CG  LYS    23       5.723  49.667  59.242  1.00 42.44          
ATOM    184  CD  LYS    23       7.143  49.463  59.732  1.00 45.87          
ATOM    185  CE  LYS    23       7.257  49.684  61.238  1.00 47.87          
ATOM    186  NZ  LYS    23       8.680  49.605  61.691  1.00 47.06          
ATOM    187  C   LYS    23       4.652  48.567  55.700  1.00 38.87          
ATOM    188  O   LYS    23       5.535  48.732  54.851  1.00 39.02          
ATOM    189  N   ILE    24       3.358  48.584  55.408  1.00 37.82          
ATOM    190  CA  ILE    24       2.925  48.788  54.037  1.00 35.88          
ATOM    191  CB  ILE    24       2.339  47.494  53.427  1.00 35.91          
ATOM    192  CG2 ILE    24       2.009  47.724  51.954  1.00 35.08          
ATOM    193  CG1 ILE    24       3.343  46.346  53.559  1.00 35.23          
ATOM    194  CD  ILE    24       2.796  44.996  53.099  1.00 34.91          
ATOM    195  C   ILE    24       1.885  49.881  53.924  1.00 35.76          
ATOM    196  O   ILE    24       1.001  50.003  54.765  1.00 37.25          
ATOM    197  N   VAL    25       2.009  50.689  52.878  1.00 34.59          
ATOM    198  CA  VAL    25       1.058  51.753  52.632  1.00 31.66          
ATOM    199  CB  VAL    25       1.732  53.134  52.735  1.00 33.26          
ATOM    200  CG1 VAL    25       0.844  54.202  52.114  1.00 28.81          
ATOM    201  CG2 VAL    25       2.003  53.455  54.208  1.00 29.92          
ATOM    202  C   VAL    25       0.456  51.571  51.243  1.00 31.50          
ATOM    203  O   VAL    25       1.177  51.307  50.288  1.00 30.16          
ATOM    204  N   ILE    26      -0.870  51.690  51.160  1.00 30.40          
ATOM    205  CA  ILE    26      -1.617  51.567  49.915  1.00 29.14          
ATOM    206  CB  ILE    26      -2.797  50.582  50.066  1.00 28.76          
ATOM    207  CG2 ILE    26      -3.640  50.592  48.809  1.00 27.27          
ATOM    208  CG1 ILE    26      -2.281  49.164  50.345  1.00 28.35          
ATOM    209  CD  ILE    26      -3.368  48.215  50.877  1.00 27.30          
ATOM    210  C   ILE    26      -2.188  52.947  49.589  1.00 29.36          
ATOM    211  O   ILE    26      -2.909  53.531  50.405  1.00 28.32          
ATOM    212  N   VAL    27      -1.874  53.460  48.401  1.00 29.54          
ATOM    213  CA  VAL    27      -2.351  54.773  47.978  1.00 31.52          
ATOM    214  CB  VAL    27      -1.174  55.694  47.634  1.00 32.36          
ATOM    215  CG1 VAL    27      -1.690  57.060  47.194  1.00 35.16          
ATOM    216  CG2 VAL    27      -0.272  55.828  48.828  1.00 34.15          
ATOM    217  C   VAL    27      -3.255  54.704  46.756  1.00 30.07          
ATOM    218  O   VAL    27      -3.071  53.866  45.892  1.00 33.33          
ATOM    219  N   SER    28      -4.237  55.590  46.677  1.00 31.28          
ATOM    220  CA  SER    28      -5.129  55.597  45.525  1.00 32.25          
ATOM    221  CB  SER    28      -6.419  54.843  45.840  1.00 35.92          
ATOM    222  OG  SER    28      -7.076  54.470  44.640  1.00 36.38          
ATOM    223  C   SER    28      -5.406  57.039  45.124  1.00 32.58          
ATOM    224  O   SER    28      -5.047  57.964  45.855  1.00 33.65          
ATOM    225  N   HSD    29      -6.061  57.228  43.978  1.00 33.91          
ATOM    226  CA  HSD    29      -6.293  58.562  43.408  1.00 33.32          
ATOM    227  CB  HSD    29      -6.619  58.408  41.907  1.00 33.19          
ATOM    228  CG  HSD    29      -7.991  57.872  41.623  1.00 34.83          
ATOM    229  CD2 HSD    29      -8.396  56.703  41.068  1.00 32.63          
ATOM    230  ND1 HSD    29      -9.142  58.593  41.871  1.00 36.71          
ATOM    231  CE1 HSD    29     -10.193  57.894  41.477  1.00 34.83          
ATOM    232  NE2 HSD    29      -9.768  56.746  40.985  1.00 34.02          
ATOM    233  C   HSD    29      -7.270  59.560  44.040  1.00 33.50          
ATOM    234  O   HSD    29      -8.182  59.190  44.777  1.00 34.48          
ATOM    235  N   VAL    30      -7.045  60.839  43.734  1.00 33.88          
ATOM    236  CA  VAL    30      -7.872  61.949  44.214  1.00 32.40          
ATOM    237  CB  VAL    30      -7.470  63.287  43.519  1.00 34.85          
ATOM    238  CG1 VAL    30      -7.882  63.268  42.035  1.00 34.37          
ATOM    239  CG2 VAL    30      -8.101  64.471  44.238  1.00 34.77          
ATOM    240  C   VAL    30      -9.339  61.634  43.919  1.00 33.17          
ATOM    241  O   VAL    30      -9.652  60.980  42.919  1.00 34.06          
ATOM    242  N   SER    31     -10.234  62.096  44.785  1.00 32.93          
ATOM    243  CA  SER    31     -11.661  61.827  44.628  1.00 33.69          
ATOM    244  CB  SER    31     -12.251  62.660  43.491  1.00 34.58          
ATOM    245  OG  SER    31     -12.244  64.030  43.841  1.00 39.90          
ATOM    246  C   SER    31     -11.854  60.351  44.329  1.00 31.45          
ATOM    247  O   SER    31     -12.452  59.986  43.314  1.00 32.18          
ATOM    248  N   PRO    32     -11.347  59.480  45.219  1.00 30.81          
ATOM    249  CD  PRO    32     -10.776  59.775  46.546  1.00 28.03          
ATOM    250  CA  PRO    32     -11.476  58.035  45.016  1.00 28.92          
ATOM    251  CB  PRO    32     -10.767  57.446  46.244  1.00 28.88          
ATOM    252  CG  PRO    32     -11.023  58.483  47.300  1.00 27.92          
ATOM    253  C   PRO    32     -12.925  57.591  44.904  1.00 28.55          
ATOM    254  O   PRO    32     -13.799  58.114  45.603  1.00 30.11          
ATOM    255  N   ASP    33     -13.164  56.627  44.015  1.00 29.12          
ATOM    256  CA  ASP    33     -14.493  56.060  43.786  1.00 29.45          
ATOM    257  CB  ASP    33     -14.912  56.230  42.323  1.00 29.48          
ATOM    258  CG  ASP    33     -13.934  55.576  41.348  1.00 30.94          
ATOM    259  OD1 ASP    33     -13.019  54.848  41.778  1.00 32.90          
ATOM    260  OD2 ASP    33     -14.082  55.793  40.134  1.00 33.35          
ATOM    261  C   ASP    33     -14.534  54.570  44.149  1.00 28.90          
ATOM    262  O   ASP    33     -13.629  54.047  44.802  1.00 29.73          
ATOM    263  N   GLY    34     -15.590  53.896  43.703  1.00 26.63          
ATOM    264  CA  GLY    34     -15.758  52.486  43.991  1.00 26.40          
ATOM    265  C   GLY    34     -14.551  51.611  43.723  1.00 28.12          
ATOM    266  O   GLY    34     -14.171  50.807  44.580  1.00 28.23          
ATOM    267  N   ASP    35     -13.933  51.768  42.555  1.00 27.14          
ATOM    268  CA  ASP    35     -12.775  50.947  42.200  1.00 28.32          
ATOM    269  CB  ASP    35     -12.572  50.944  40.673  1.00 29.30          
ATOM    270  CG  ASP    35     -11.587  49.880  40.207  1.00 31.44          
ATOM    271  OD1 ASP    35     -11.466  48.836  40.882  1.00 31.59          
ATOM    272  OD2 ASP    35     -10.947  50.069  39.151  1.00 33.89          
ATOM    273  C   ASP    35     -11.498  51.382  42.914  1.00 26.35          
ATOM    274  O   ASP    35     -10.604  50.575  43.159  1.00 26.54          
ATOM    275  N   ALA    36     -11.398  52.652  43.261  1.00 25.47          
ATOM    276  CA  ALA    36     -10.202  53.096  43.965  1.00 26.79          
ATOM    277  CB  ALA    36     -10.138  54.639  43.984  1.00 24.48          
ATOM    278  C   ALA    36     -10.260  52.535  45.398  1.00 26.45          
ATOM    279  O   ALA    36      -9.297  51.958  45.898  1.00 23.78          
ATOM    280  N   ILE    37     -11.407  52.694  46.048  1.00 25.86          
ATOM    281  CA  ILE    37     -11.579  52.208  47.411  1.00 26.11          
ATOM    282  CB  ILE    37     -12.843  52.813  48.057  1.00 26.33          
ATOM    283  CG2 ILE    37     -12.962  52.332  49.500  1.00 29.36          
ATOM    284  CG1 ILE    37     -12.766  54.344  48.031  1.00 24.81          
ATOM    285  CD  ILE    37     -11.526  54.890  48.684  1.00 22.13          
ATOM    286  C   ILE    37     -11.669  50.676  47.503  1.00 27.36          
ATOM    287  O   ILE    37     -11.055  50.059  48.377  1.00 27.50          
ATOM    288  N   GLY    38     -12.442  50.074  46.604  1.00 27.18          
ATOM    289  CA  GLY    38     -12.605  48.630  46.596  1.00 25.23          
ATOM    290  C   GLY    38     -11.319  47.841  46.393  1.00 26.33          
ATOM    291  O   GLY    38     -11.101  46.850  47.073  1.00 26.12          
ATOM    292  N   SER    39     -10.468  48.271  45.467  1.00 25.60          
ATOM    293  CA  SER    39      -9.220  47.575  45.224  1.00 26.69          
ATOM    294  CB  SER    39      -8.580  48.037  43.909  1.00 27.38          
ATOM    295  OG  SER    39      -8.325  49.430  43.912  1.00 27.36          
ATOM    296  C   SER    39      -8.259  47.815  46.376  1.00 28.36          
ATOM    297  O   SER    39      -7.527  46.903  46.775  1.00 27.38          
ATOM    298  N   SER    40      -8.249  49.039  46.905  1.00 27.65          
ATOM    299  CA  SER    40      -7.375  49.357  48.029  1.00 28.89          
ATOM    300  CB  SER    40      -7.411  50.856  48.336  1.00 28.62          
ATOM    301  OG  SER    40      -6.895  51.600  47.251  1.00 31.32          
ATOM    302  C   SER    40      -7.766  48.568  49.277  1.00 28.20          
ATOM    303  O   SER    40      -6.905  48.034  49.966  1.00 29.02          
ATOM    304  N   LEU    41      -9.060  48.495  49.574  1.00 27.56          
ATOM    305  CA  LEU    41      -9.515  47.754  50.751  1.00 26.91          
ATOM    306  CB  LEU    41     -10.951  48.154  51.108  1.00 23.66          
ATOM    307  CG  LEU    41     -11.219  49.575  51.632  1.00 21.34          
ATOM    308  CD1 LEU    41     -12.706  49.721  51.960  1.00 18.05          
ATOM    309  CD2 LEU    41     -10.388  49.835  52.873  1.00 23.41          
ATOM    310  C   LEU    41      -9.431  46.234  50.518  1.00 27.04          
ATOM    311  O   LEU    41      -9.359  45.453  51.464  1.00 26.84          
ATOM    312  N   GLY    42      -9.457  45.818  49.254  1.00 28.17          
ATOM    313  CA  GLY    42      -9.344  44.404  48.949  1.00 26.80          
ATOM    314  C   GLY    42      -7.924  43.970  49.263  1.00 27.96          
ATOM    315  O   GLY    42      -7.702  42.948  49.910  1.00 30.68          
ATOM    316  N   LEU    43      -6.953  44.750  48.803  1.00 29.79          
ATOM    317  CA  LEU    43      -5.546  44.448  49.071  1.00 30.77          
ATOM    318  CB  LEU    43      -4.637  45.396  48.270  1.00 26.21          
ATOM    319  CG  LEU    43      -3.128  45.160  48.423  1.00 29.21          
ATOM    320  CD1 LEU    43      -2.794  43.731  48.047  1.00 28.13          
ATOM    321  CD2 LEU    43      -2.345  46.134  47.550  1.00 27.64          
ATOM    322  C   LEU    43      -5.303  44.616  50.582  1.00 31.49          
ATOM    323  O   LEU    43      -4.638  43.789  51.222  1.00 32.74          
ATOM    324  N   TYR    44      -5.862  45.684  51.148  1.00 30.11          
ATOM    325  CA  TYR    44      -5.735  45.953  52.575  1.00 30.63          
ATOM    326  CB  TYR    44      -6.651  47.109  52.979  1.00 32.54          
ATOM    327  CG  TYR    44      -6.771  47.318  54.470  1.00 34.40          
ATOM    328  CD1 TYR    44      -5.716  47.844  55.207  1.00 36.25          
ATOM    329  CE1 TYR    44      -5.833  48.048  56.580  1.00 37.78          
ATOM    330  CD2 TYR    44      -7.944  46.992  55.145  1.00 34.48          
ATOM    331  CE2 TYR    44      -8.068  47.187  56.515  1.00 34.71          
ATOM    332  CZ  TYR    44      -7.015  47.718  57.228  1.00 38.46          
ATOM    333  OH  TYR    44      -7.148  47.941  58.587  1.00 39.21          
ATOM    334  C   TYR    44      -6.109  44.726  53.398  1.00 30.77          
ATOM    335  O   TYR    44      -5.304  44.217  54.180  1.00 29.05          
ATOM    336  N   HSD    45      -7.338  44.251  53.235  1.00 31.49          
ATOM    337  CA  HSD    45      -7.774  43.094  54.005  1.00 32.78          
ATOM    338  CB  HSD    45      -9.193  42.698  53.631  1.00 33.36          
ATOM    339  CG  HSD    45     -10.234  43.601  54.208  1.00 35.68          
ATOM    340  CD2 HSD    45     -10.592  43.841  55.491  1.00 35.97          
ATOM    341  ND1 HSD    45     -11.059  44.380  53.428  1.00 36.28          
ATOM    342  CE1 HSD    45     -11.884  45.058  54.204  1.00 36.54          
ATOM    343  NE2 HSD    45     -11.621  44.750  55.460  1.00 37.43          
ATOM    344  C   HSD    45      -6.846  41.904  53.856  1.00 32.83          
ATOM    345  O   HSD    45      -6.539  41.227  54.845  1.00 31.46          
ATOM    346  N   PHE    46      -6.401  41.635  52.630  1.00 31.89          
ATOM    347  CA  PHE    46      -5.482  40.525  52.421  1.00 31.57          
ATOM    348  CB  PHE    46      -5.115  40.376  50.947  1.00 31.48          
ATOM    349  CG  PHE    46      -3.942  39.471  50.732  1.00 29.99          
ATOM    350  CD1 PHE    46      -4.001  38.139  51.143  1.00 29.60          
ATOM    351  CD2 PHE    46      -2.748  39.968  50.221  1.00 29.98          
ATOM    352  CE1 PHE    46      -2.889  37.316  51.060  1.00 29.82          
ATOM    353  CE2 PHE    46      -1.614  39.154  50.127  1.00 30.29          
ATOM    354  CZ  PHE    46      -1.685  37.825  50.551  1.00 32.13          
ATOM    355  C   PHE    46      -4.184  40.728  53.206  1.00 32.52          
ATOM    356  O   PHE    46      -3.769  39.874  53.983  1.00 33.32          
ATOM    357  N   LEU    47      -3.542  41.869  52.989  1.00 32.38          
ATOM    358  CA  LEU    47      -2.290  42.157  53.662  1.00 32.89          
ATOM    359  CB  LEU    47      -1.758  43.515  53.207  1.00 31.48          
ATOM    360  CG  LEU    47      -1.371  43.580  51.725  1.00 30.76          
ATOM    361  CD1 LEU    47      -0.965  44.991  51.368  1.00 28.94          
ATOM    362  CD2 LEU    47      -0.230  42.597  51.442  1.00 30.28          
ATOM    363  C   LEU    47      -2.422  42.126  55.185  1.00 34.82          
ATOM    364  O   LEU    47      -1.545  41.606  55.893  1.00 34.46          
ATOM    365  N   ASP    48      -3.525  42.672  55.688  1.00 36.77          
ATOM    366  CA  ASP    48      -3.756  42.704  57.120  1.00 36.93          
ATOM    367  CB  ASP    48      -4.973  43.577  57.434  1.00 38.42          
ATOM    368  CG  ASP    48      -5.044  43.974  58.897  1.00 41.42          
ATOM    369  OD1 ASP    48      -4.087  44.607  59.387  1.00 43.40          
ATOM    370  OD2 ASP    48      -6.052  43.653  59.558  1.00 43.69          
ATOM    371  C   ASP    48      -3.937  41.294  57.708  1.00 36.86          
ATOM    372  O   ASP    48      -3.667  41.079  58.888  1.00 38.68          
ATOM    373  N   SER    49      -4.382  40.336  56.897  1.00 35.52          
ATOM    374  CA  SER    49      -4.557  38.966  57.387  1.00 36.25          
ATOM    375  CB  SER    49      -5.418  38.134  56.433  1.00 36.08          
ATOM    376  OG  SER    49      -4.663  37.709  55.300  1.00 33.69          
ATOM    377  C   SER    49      -3.193  38.297  57.477  1.00 37.50          
ATOM    378  O   SER    49      -3.053  37.220  58.048  1.00 38.97          
ATOM    379  N   GLN    50      -2.187  38.931  56.898  1.00 37.44          
ATOM    380  CA  GLN    50      -0.855  38.364  56.908  1.00 39.18          
ATOM    381  CB  GLN    50      -0.257  38.461  55.504  1.00 38.23          
ATOM    382  CG  GLN    50      -1.070  37.728  54.463  1.00 35.52          
ATOM    383  CD  GLN    50      -1.122  36.244  54.740  1.00 34.46          
ATOM    384  OE1 GLN    50      -2.188  35.675  55.000  1.00 36.03          
ATOM    385  NE2 GLN    50       0.037  35.607  54.702  1.00 38.23          
ATOM    386  C   GLN    50       0.091  38.990  57.925  1.00 40.98          
ATOM    387  O   GLN    50       1.275  39.144  57.651  1.00 42.44          
ATOM    388  N   ASP    51      -0.433  39.350  59.095  1.00 43.39          
ATOM    389  CA  ASP    51       0.384  39.927  60.169  1.00 45.28          
ATOM    390  CB  ASP    51       1.256  38.826  60.809  1.00 47.56          
ATOM    391  CG  ASP    51       2.005  39.300  62.073  1.00 52.02          
ATOM    392  OD1 ASP    51       1.345  39.766  63.033  1.00 52.05          
ATOM    393  OD2 ASP    51       3.257  39.188  62.110  1.00 51.44          
ATOM    394  C   ASP    51       1.274  41.077  59.690  1.00 44.85          
ATOM    395  O   ASP    51       2.489  41.060  59.890  1.00 43.78          
ATOM    396  N   LYS    52       0.673  42.068  59.039  1.00 43.04          
ATOM    397  CA  LYS    52       1.441  43.216  58.579  1.00 41.75          
ATOM    398  CB  LYS    52       1.688  43.126  57.069  1.00 42.51          
ATOM    399  CG  LYS    52       2.677  42.019  56.751  1.00 46.54          
ATOM    400  CD  LYS    52       3.056  41.939  55.298  1.00 47.80          
ATOM    401  CE  LYS    52       3.862  40.665  55.035  1.00 48.07          
ATOM    402  NZ  LYS    52       5.131  40.604  55.822  1.00 45.53          
ATOM    403  C   LYS    52       0.756  44.521  58.942  1.00 38.98          
ATOM    404  O   LYS    52      -0.454  44.561  59.117  1.00 37.30          
ATOM    405  N   ILE    53       1.549  45.575  59.105  1.00 36.70          
ATOM    406  CA  ILE    53       1.009  46.886  59.427  1.00 35.00          
ATOM    407  CB  ILE    53       2.034  47.737  60.192  1.00 35.59          
ATOM    408  CG2 ILE    53       1.449  49.120  60.477  1.00 34.46          
ATOM    409  CG1 ILE    53       2.395  47.031  61.513  1.00 34.83          
ATOM    410  CD  ILE    53       3.561  47.667  62.272  1.00 33.44          
ATOM    411  C   ILE    53       0.679  47.497  58.078  1.00 33.10          
ATOM    412  O   ILE    53       1.555  47.648  57.224  1.00 32.73          
ATOM    413  N   VAL    54      -0.598  47.805  57.878  1.00 31.77          
ATOM    414  CA  VAL    54      -1.072  48.345  56.612  1.00 29.40          
ATOM    415  CB  VAL    54      -1.850  47.269  55.833  1.00 29.09          
ATOM    416  CG1 VAL    54      -1.776  47.546  54.354  1.00 30.04          
ATOM    417  CG2 VAL    54      -1.320  45.889  56.182  1.00 28.84          
ATOM    418  C   VAL    54      -2.015  49.526  56.808  1.00 29.37          
ATOM    419  O   VAL    54      -2.941  49.464  57.615  1.00 28.18          
ATOM    420  N   ASN    55      -1.783  50.591  56.050  1.00 29.03          
ATOM    421  CA  ASN    55      -2.612  51.787  56.112  1.00 26.75          
ATOM    422  CB  ASN    55      -1.874  52.922  56.818  1.00 26.03          
ATOM    423  CG  ASN    55      -1.659  52.651  58.286  1.00 26.40          
ATOM    424  OD1 ASN    55      -2.612  52.609  59.065  1.00 25.84          
ATOM    425  ND2 ASN    55      -0.407  52.456  58.677  1.00 26.86          
ATOM    426  C   ASN    55      -2.944  52.228  54.697  1.00 27.96          
ATOM    427  O   ASN    55      -2.060  52.287  53.838  1.00 29.55          
ATOM    428  N   VAL    56      -4.222  52.517  54.468  1.00 27.62          
ATOM    429  CA  VAL    56      -4.725  52.982  53.180  1.00 27.84          
ATOM    430  CB  VAL    56      -6.141  52.394  52.893  1.00 27.96          
ATOM    431  CG1 VAL    56      -6.672  52.909  51.566  1.00 27.29          
ATOM    432  CG2 VAL    56      -6.081  50.872  52.911  1.00 26.32          
ATOM    433  C   VAL    56      -4.819  54.504  53.295  1.00 29.56          
ATOM    434  O   VAL    56      -5.399  55.032  54.254  1.00 31.54          
ATOM    435  N   ILE    57      -4.242  55.203  52.323  1.00 29.78          
ATOM    436  CA  ILE    57      -4.219  56.665  52.312  1.00 29.55          
ATOM    437  CB  ILE    57      -2.795  57.210  52.593  1.00 30.14          
ATOM    438  CG2 ILE    57      -2.838  58.722  52.702  1.00 28.42          
ATOM    439  CG1 ILE    57      -2.229  56.601  53.881  1.00 32.53          
ATOM    440  CD  ILE    57      -0.798  57.048  54.208  1.00 30.80          
ATOM    441  C   ILE    57      -4.631  57.206  50.949  1.00 31.03          
ATOM    442  O   ILE    57      -4.083  56.803  49.926  1.00 30.07          
ATOM    443  N   VAL    58      -5.589  58.125  50.946  1.00 31.81          
ATOM    444  CA  VAL    58      -6.059  58.744  49.724  1.00 31.32          
ATOM    445  CB  VAL    58      -7.481  58.260  49.356  1.00 29.85          
ATOM    446  CG1 VAL    58      -7.470  56.732  49.131  1.00 26.17          
ATOM    447  CG2 VAL    58      -8.456  58.622  50.466  1.00 27.71          
ATOM    448  C   VAL    58      -6.051  60.249  49.990  1.00 34.66          
ATOM    449  O   VAL    58      -6.151  60.692  51.133  1.00 35.74          
ATOM    450  N   PRO    59      -5.935  61.064  48.938  1.00 36.20          
ATOM    451  CD  PRO    59      -5.712  60.777  47.507  1.00 35.64          
ATOM    452  CA  PRO    59      -5.913  62.502  49.199  1.00 37.92          
ATOM    453  CB  PRO    59      -5.257  63.056  47.934  1.00 37.96          
ATOM    454  CG  PRO    59      -5.768  62.150  46.882  1.00 37.41          
ATOM    455  C   PRO    59      -7.262  63.145  49.469  1.00 37.79          
ATOM    456  O   PRO    59      -7.333  64.254  49.991  1.00 37.77          
ATOM    457  N   ASN    60      -8.328  62.421  49.163  1.00 37.74          
ATOM    458  CA  ASN    60      -9.649  62.999  49.269  1.00 37.58          
ATOM    459  CB  ASN    60     -10.102  63.407  47.860  1.00 41.54          
ATOM    460  CG  ASN    60     -10.430  64.856  47.766  1.00 43.71          
ATOM    461  OD1 ASN    60     -10.838  65.356  46.710  1.00 42.06          
ATOM    462  ND2 ASN    60     -10.244  65.563  48.880  1.00 46.57          
ATOM    463  C   ASN    60     -10.711  62.100  49.843  1.00 36.65          
ATOM    464  O   ASN    60     -10.576  60.886  49.842  1.00 38.33          
ATOM    465  N   ALA    61     -11.796  62.716  50.291  1.00 32.40          
ATOM    466  CA  ALA    61     -12.922  61.965  50.818  1.00 31.75          
ATOM    467  CB  ALA    61     -13.935  62.923  51.455  1.00 27.37          
ATOM    468  C   ALA    61     -13.588  61.174  49.676  1.00 29.99          
ATOM    469  O   ALA    61     -13.589  61.613  48.528  1.00 29.09          
ATOM    470  N   PHE    62     -14.132  60.002  49.999  1.00 30.76          
ATOM    471  CA  PHE    62     -14.838  59.179  49.032  1.00 30.64          
ATOM    472  CB  PHE    62     -14.399  57.710  49.149  1.00 31.09          
ATOM    473  CG  PHE    62     -14.203  57.239  50.558  1.00 28.04          
ATOM    474  CD1 PHE    62     -15.243  56.676  51.267  1.00 28.08          
ATOM    475  CD2 PHE    62     -12.969  57.376  51.178  1.00 31.11          
ATOM    476  CE1 PHE    62     -15.065  56.259  52.578  1.00 29.65          
ATOM    477  CE2 PHE    62     -12.779  56.963  52.488  1.00 31.33          
ATOM    478  CZ  PHE    62     -13.829  56.402  53.190  1.00 30.85          
ATOM    479  C   PHE    62     -16.332  59.346  49.311  1.00 31.27          
ATOM    480  O   PHE    62     -16.712  59.788  50.376  1.00 31.45          
ATOM    481  N   PRO    63     -17.199  59.019  48.346  1.00 33.05          
ATOM    482  CD  PRO    63     -16.914  58.661  46.948  1.00 32.96          
ATOM    483  CA  PRO    63     -18.644  59.173  48.571  1.00 33.62          
ATOM    484  CB  PRO    63     -19.251  58.731  47.241  1.00 32.78          
ATOM    485  CG  PRO    63     -18.183  59.097  46.241  1.00 32.91          
ATOM    486  C   PRO    63     -19.222  58.386  49.752  1.00 34.25          
ATOM    487  O   PRO    63     -18.687  57.346  50.150  1.00 34.94          
ATOM    488  N   ASP    64     -20.327  58.891  50.292  1.00 33.47          
ATOM    489  CA  ASP    64     -21.005  58.266  51.414  1.00 33.89          
ATOM    490  CB  ASP    64     -22.157  59.150  51.919  1.00 36.56          
ATOM    491  CG  ASP    64     -21.674  60.400  52.659  1.00 40.84          
ATOM    492  OD1 ASP    64     -20.450  60.583  52.842  1.00 42.78          
ATOM    493  OD2 ASP    64     -22.538  61.207  53.065  1.00 44.20          
ATOM    494  C   ASP    64     -21.561  56.905  51.052  1.00 33.28          
ATOM    495  O   ASP    64     -21.734  56.056  51.923  1.00 34.03          
ATOM    496  N   PHE    65     -21.857  56.687  49.778  1.00 32.12          
ATOM    497  CA  PHE    65     -22.385  55.393  49.393  1.00 31.83          
ATOM    498  CB  PHE    65     -23.076  55.462  48.026  1.00 29.14          
ATOM    499  CG  PHE    65     -22.233  56.041  46.924  1.00 28.68          
ATOM    500  CD1 PHE    65     -21.184  55.314  46.376  1.00 29.64          
ATOM    501  CD2 PHE    65     -22.538  57.293  46.383  1.00 30.47          
ATOM    502  CE1 PHE    65     -20.448  55.809  45.304  1.00 28.66          
ATOM    503  CE2 PHE    65     -21.806  57.806  45.303  1.00 27.64          
ATOM    504  CZ  PHE    65     -20.763  57.062  44.762  1.00 32.72          
ATOM    505  C   PHE    65     -21.289  54.326  49.418  1.00 32.66          
ATOM    506  O   PHE    65     -21.525  53.169  49.088  1.00 34.42          
ATOM    507  N   LEU    66     -20.095  54.724  49.833  1.00 31.79          
ATOM    508  CA  LEU    66     -18.982  53.795  49.943  1.00 32.29          
ATOM    509  CB  LEU    66     -17.772  54.337  49.174  1.00 29.27          
ATOM    510  CG  LEU    66     -17.458  53.742  47.792  1.00 29.38          
ATOM    511  CD1 LEU    66     -18.720  53.490  47.016  1.00 27.89          
ATOM    512  CD2 LEU    66     -16.520  54.686  47.022  1.00 26.27          
ATOM    513  C   LEU    66     -18.608  53.542  51.422  1.00 34.02          
ATOM    514  O   LEU    66     -17.796  52.657  51.715  1.00 34.35          
ATOM    515  N   LYS    67     -19.214  54.300  52.343  1.00 34.06          
ATOM    516  CA  LYS    67     -18.922  54.172  53.784  1.00 35.32          
ATOM    517  CB  LYS    67     -19.717  55.202  54.608  1.00 35.07          
ATOM    518  CG  LYS    67     -19.405  56.658  54.305  1.00 40.09          
ATOM    519  CD  LYS    67     -17.937  56.978  54.510  1.00 40.44          
ATOM    520  CE  LYS    67     -17.627  58.424  54.103  1.00 43.21          
ATOM    521  NZ  LYS    67     -18.403  59.446  54.876  1.00 42.94          
ATOM    522  C   LYS    67     -19.204  52.789  54.375  1.00 33.77          
ATOM    523  O   LYS    67     -18.551  52.365  55.334  1.00 34.03          
ATOM    524  N   TRP    68     -20.189  52.099  53.822  1.00 31.42          
ATOM    525  CA  TRP    68     -20.540  50.784  54.326  1.00 30.37          
ATOM    526  CB  TRP    68     -21.740  50.255  53.557  1.00 29.25          
ATOM    527  CG  TRP    68     -21.440  50.113  52.090  1.00 27.99          
ATOM    528  CD2 TRP    68     -20.930  48.948  51.427  1.00 26.98          
ATOM    529  CE2 TRP    68     -20.816  49.264  50.055  1.00 27.98          
ATOM    530  CE3 TRP    68     -20.563  47.667  51.859  1.00 28.36          
ATOM    531  CD1 TRP    68     -21.595  51.066  51.122  1.00 27.96          
ATOM    532  NE1 TRP    68     -21.225  50.564  49.900  1.00 28.85          
ATOM    533  CZ2 TRP    68     -20.342  48.342  49.105  1.00 26.01          
ATOM    534  CZ3 TRP    68     -20.089  46.751  50.914  1.00 27.81          
ATOM    535  CH2 TRP    68     -19.989  47.097  49.553  1.00 28.09          
ATOM    536  C   TRP    68     -19.390  49.778  54.191  1.00 30.93          
ATOM    537  O   TRP    68     -19.351  48.774  54.891  1.00 31.65          
ATOM    538  N   MET    69     -18.456  50.041  53.287  1.00 31.64          
ATOM    539  CA  MET    69     -17.363  49.104  53.060  1.00 31.14          
ATOM    540  CB  MET    69     -16.485  49.621  51.923  1.00 31.66          
ATOM    541  CG  MET    69     -17.297  49.856  50.661  1.00 35.57          
ATOM    542  SD  MET    69     -16.258  50.298  49.110  0.82 40.99          
ATOM    543  CE  MET    69     -15.599  48.525  48.755  1.00 32.37          
ATOM    544  C   MET    69     -16.537  48.796  54.304  1.00 30.75          
ATOM    545  O   MET    69     -16.101  49.703  55.022  1.00 30.72          
ATOM    546  N   PRO    70     -16.302  47.501  54.577  1.00 28.17          
ATOM    547  CD  PRO    70     -16.736  46.286  53.859  1.00 28.83          
ATOM    548  CA  PRO    70     -15.514  47.169  55.774  1.00 27.85          
ATOM    549  CB  PRO    70     -15.621  45.641  55.859  1.00 25.83          
ATOM    550  CG  PRO    70     -15.823  45.229  54.423  1.00 28.24          
ATOM    551  C   PRO    70     -14.090  47.668  55.644  1.00 27.04          
ATOM    552  O   PRO    70     -13.412  47.368  54.672  1.00 27.87          
ATOM    553  N   GLY    71     -13.649  48.448  56.624  1.00 26.27          
ATOM    554  CA  GLY    71     -12.306  49.000  56.580  1.00 25.37          
ATOM    555  C   GLY    71     -12.282  50.438  56.088  1.00 26.27          
ATOM    556  O   GLY    71     -11.265  51.129  56.223  1.00 25.98          
ATOM    557  N   SER    72     -13.393  50.908  55.523  1.00 27.02          
ATOM    558  CA  SER    72     -13.426  52.282  55.007  1.00 29.27          
ATOM    559  CB  SER    72     -14.736  52.560  54.252  1.00 28.76          
ATOM    560  OG  SER    72     -15.845  52.561  55.125  1.00 30.29          
ATOM    561  C   SER    72     -13.205  53.355  56.070  1.00 29.72          
ATOM    562  O   SER    72     -12.609  54.395  55.783  1.00 32.66          
ATOM    563  N   LYS    73     -13.670  53.113  57.292  1.00 30.61          
ATOM    564  CA  LYS    73     -13.486  54.089  58.366  1.00 33.82          
ATOM    565  CB  LYS    73     -14.232  53.661  59.636  1.00 38.19          
ATOM    566  CG  LYS    73     -15.748  53.712  59.545  1.00 42.50          
ATOM    567  CD  LYS    73     -16.388  53.404  60.907  1.00 45.65          
ATOM    568  CE  LYS    73     -17.914  53.334  60.825  1.00 49.02          
ATOM    569  NZ  LYS    73     -18.518  53.057  62.163  1.00 49.92          
ATOM    570  C   LYS    73     -12.015  54.305  58.725  1.00 34.09          
ATOM    571  O   LYS    73     -11.656  55.332  59.294  1.00 32.84          
ATOM    572  N   ASP    74     -11.165  53.335  58.414  1.00 34.27          
ATOM    573  CA  ASP    74      -9.749  53.463  58.735  1.00 33.14          
ATOM    574  CB  ASP    74      -9.185  52.104  59.130  1.00 36.60          
ATOM    575  CG  ASP    74      -9.836  51.563  60.380  1.00 42.86          
ATOM    576  OD1 ASP    74      -9.601  52.144  61.465  1.00 42.82          
ATOM    577  OD2 ASP    74     -10.598  50.573  60.275  1.00 45.88          
ATOM    578  C   ASP    74      -8.933  54.063  57.609  1.00 31.29          
ATOM    579  O   ASP    74      -7.731  54.244  57.733  1.00 30.75          
ATOM    580  N   ILE    75      -9.587  54.364  56.501  1.00 31.72          
ATOM    581  CA  ILE    75      -8.891  54.972  55.383  1.00 29.07          
ATOM    582  CB  ILE    75      -9.791  54.988  54.146  1.00 28.66          
ATOM    583  CG2 ILE    75      -9.243  55.985  53.115  1.00 26.91          
ATOM    584  CG1 ILE    75      -9.906  53.552  53.603  1.00 25.62          
ATOM    585  CD  ILE    75     -10.723  53.401  52.336  1.00 23.30          
ATOM    586  C   ILE    75      -8.492  56.388  55.807  1.00 30.43          
ATOM    587  O   ILE    75      -9.304  57.135  56.358  1.00 28.26          
ATOM    588  N   LEU    76      -7.232  56.740  55.573  1.00 31.55          
ATOM    589  CA  LEU    76      -6.714  58.044  55.970  1.00 31.89          
ATOM    590  CB  LEU    76      -5.269  57.892  56.434  1.00 33.71          
ATOM    591  CG  LEU    76      -4.570  59.113  57.030  1.00 40.05          
ATOM    592  CD1 LEU    76      -5.274  59.539  58.319  1.00 41.69          
ATOM    593  CD2 LEU    76      -3.113  58.767  57.326  1.00 41.40          
ATOM    594  C   LEU    76      -6.797  59.083  54.862  1.00 33.23          
ATOM    595  O   LEU    76      -6.278  58.876  53.766  1.00 33.29          
ATOM    596  N   LEU    77      -7.460  60.200  55.158  1.00 32.61          
ATOM    597  CA  LEU    77      -7.616  61.290  54.203  1.00 32.41          
ATOM    598  CB  LEU    77      -8.928  62.031  54.472  1.00 29.66          
ATOM    599  CG  LEU    77     -10.166  61.551  53.700  1.00 33.37          
ATOM    600  CD1 LEU    77     -10.200  60.033  53.609  1.00 34.92          
ATOM    601  CD2 LEU    77     -11.421  62.076  54.380  1.00 33.03          
ATOM    602  C   LEU    77      -6.430  62.234  54.331  1.00 32.68          
ATOM    603  O   LEU    77      -6.239  62.862  55.370  1.00 34.95          
ATOM    604  N   TYR    78      -5.637  62.327  53.267  1.00 34.06          
ATOM    605  CA  TYR    78      -4.442  63.166  53.256  1.00 34.06          
ATOM    606  CB  TYR    78      -3.680  62.958  51.949  1.00 32.66          
ATOM    607  CG  TYR    78      -2.285  63.531  51.955  1.00 32.30          
ATOM    608  CD1 TYR    78      -2.024  64.788  51.414  1.00 30.89          
ATOM    609  CE1 TYR    78      -0.734  65.306  51.397  1.00 33.96          
ATOM    610  CD2 TYR    78      -1.221  62.805  52.487  1.00 33.50          
ATOM    611  CE2 TYR    78       0.077  63.309  52.476  1.00 33.03          
ATOM    612  CZ  TYR    78       0.313  64.557  51.924  1.00 35.44          
ATOM    613  OH  TYR    78       1.601  65.042  51.861  1.00 36.90          
ATOM    614  C   TYR    78      -4.655  64.662  53.490  1.00 33.92          
ATOM    615  O   TYR    78      -3.805  65.316  54.102  1.00 34.27          
ATOM    616  N   ASP    79      -5.766  65.206  53.007  1.00 35.91          
ATOM    617  CA  ASP    79      -6.046  66.622  53.195  1.00 38.79          
ATOM    618  CB  ASP    79      -7.097  67.113  52.185  1.00 38.82          
ATOM    619  CG  ASP    79      -8.456  66.429  52.347  1.00 41.50          
ATOM    620  OD1 ASP    79      -8.611  65.613  53.272  1.00 43.85          
ATOM    621  OD2 ASP    79      -9.379  66.712  51.544  1.00 40.81          
ATOM    622  C   ASP    79      -6.523  66.934  54.616  1.00 40.94          
ATOM    623  O   ASP    79      -7.037  68.024  54.871  1.00 40.44          
ATOM    624  N   ARG    80      -6.350  65.985  55.538  1.00 41.60          
ATOM    625  CA  ARG    80      -6.784  66.187  56.917  1.00 43.07          
ATOM    626  CB  ARG    80      -8.137  65.514  57.141  1.00 46.63          
ATOM    627  CG  ARG    80      -9.183  65.989  56.157  1.00 54.16          
ATOM    628  CD  ARG    80     -10.510  65.268  56.304  1.00 59.08          
ATOM    629  NE  ARG    80     -11.373  65.547  55.157  1.00 63.08          
ATOM    630  CZ  ARG    80     -12.647  65.179  55.067  1.00 65.70          
ATOM    631  NH1 ARG    80     -13.220  64.511  56.065  1.00 65.94          
ATOM    632  NH2 ARG    80     -13.349  65.482  53.980  1.00 64.66          
ATOM    633  C   ARG    80      -5.796  65.669  57.944  1.00 42.03          
ATOM    634  O   ARG    80      -5.856  66.049  59.108  1.00 41.92          
ATOM    635  N   TYR    81      -4.888  64.801  57.510  1.00 41.24          
ATOM    636  CA  TYR    81      -3.889  64.217  58.402  1.00 39.85          
ATOM    637  CB  TYR    81      -4.335  62.823  58.846  1.00 38.67          
ATOM    638  CG  TYR    81      -5.616  62.833  59.643  1.00 40.17          
ATOM    639  CD1 TYR    81      -5.663  63.403  60.912  1.00 39.13          
ATOM    640  CE1 TYR    81      -6.850  63.471  61.626  1.00 38.11          
ATOM    641  CD2 TYR    81      -6.799  62.322  59.108  1.00 41.32          
ATOM    642  CE2 TYR    81      -7.996  62.385  59.818  1.00 39.97          
ATOM    643  CZ  TYR    81      -8.009  62.964  61.074  1.00 40.07          
ATOM    644  OH  TYR    81      -9.189  63.046  61.771  1.00 39.26          
ATOM    645  C   TYR    81      -2.569  64.118  57.668  1.00 38.91          
ATOM    646  O   TYR    81      -1.912  63.072  57.688  1.00 37.78          
ATOM    647  N   GLN    82      -2.174  65.216  57.037  1.00 37.90          
ATOM    648  CA  GLN    82      -0.941  65.242  56.262  1.00 40.84          
ATOM    649  CB  GLN    82      -0.728  66.623  55.640  1.00 40.56          
ATOM    650  CG  GLN    82       0.516  66.689  54.789  1.00 44.88          
ATOM    651  CD  GLN    82       0.669  68.008  54.070  1.00 47.57          
ATOM    652  OE1 GLN    82       1.668  68.239  53.384  1.00 50.54          
ATOM    653  NE2 GLN    82      -0.321  68.879  54.209  1.00 46.33          
ATOM    654  C   GLN    82       0.302  64.830  57.023  1.00 42.03          
ATOM    655  O   GLN    82       1.054  63.971  56.560  1.00 43.23          
ATOM    656  N   GLU    83       0.526  65.441  58.182  1.00 43.36          
ATOM    657  CA  GLU    83       1.692  65.125  59.004  1.00 43.35          
ATOM    658  CB  GLU    83       1.588  65.843  60.357  1.00 46.89          
ATOM    659  CG  GLU    83       2.867  66.543  60.828  1.00 52.94          
ATOM    660  CD  GLU    83       3.923  65.591  61.386  1.00 57.16          
ATOM    661  OE1 GLU    83       3.705  65.003  62.479  1.00 57.43          
ATOM    662  OE2 GLU    83       4.980  65.434  60.729  1.00 58.63          
ATOM    663  C   GLU    83       1.733  63.615  59.220  1.00 41.35          
ATOM    664  O   GLU    83       2.724  62.963  58.927  1.00 42.06          
ATOM    665  N   PHE    84       0.635  63.074  59.735  1.00 40.42          
ATOM    666  CA  PHE    84       0.508  61.643  60.002  1.00 39.17          
ATOM    667  CB  PHE    84      -0.892  61.376  60.578  1.00 38.13          
ATOM    668  CG  PHE    84      -1.137  59.951  60.999  1.00 35.76          
ATOM    669  CD1 PHE    84      -0.082  59.086  61.279  1.00 34.07          
ATOM    670  CD2 PHE    84      -2.441  59.485  61.147  1.00 35.03          
ATOM    671  CE1 PHE    84      -0.333  57.776  61.701  1.00 34.76          
ATOM    672  CE2 PHE    84      -2.701  58.184  61.568  1.00 32.86          
ATOM    673  CZ  PHE    84      -1.647  57.327  61.844  1.00 33.63          
ATOM    674  C   PHE    84       0.742  60.839  58.713  1.00 38.18          
ATOM    675  O   PHE    84       1.596  59.949  58.673  1.00 37.58          
ATOM    676  N   ALA    85      -0.004  61.168  57.660  1.00 37.01          
ATOM    677  CA  ALA    85       0.140  60.476  56.381  1.00 37.48          
ATOM    678  CB  ALA    85      -0.719  61.140  55.324  1.00 36.13          
ATOM    679  C   ALA    85       1.597  60.476  55.934  1.00 38.07          
ATOM    680  O   ALA    85       2.167  59.418  55.646  1.00 38.53          
ATOM    681  N   ASP    86       2.200  61.662  55.887  1.00 38.63          
ATOM    682  CA  ASP    86       3.592  61.782  55.470  1.00 38.89          
ATOM    683  CB  ASP    86       4.093  63.211  55.664  1.00 38.29          
ATOM    684  CG  ASP    86       3.481  64.184  54.675  1.00 40.83          
ATOM    685  OD1 ASP    86       2.960  63.735  53.626  1.00 40.42          
ATOM    686  OD2 ASP    86       3.536  65.405  54.942  1.00 42.57          
ATOM    687  C   ASP    86       4.517  60.824  56.207  1.00 38.30          
ATOM    688  O   ASP    86       5.380  60.205  55.598  1.00 39.58          
ATOM    689  N   LYS    87       4.338  60.698  57.517  1.00 38.01          
ATOM    690  CA  LYS    87       5.174  59.804  58.308  1.00 35.88          
ATOM    691  CB  LYS    87       4.828  59.910  59.796  1.00 37.18          
ATOM    692  CG  LYS    87       5.474  61.057  60.546  1.00 38.89          
ATOM    693  CD  LYS    87       5.259  60.851  62.047  1.00 41.78          
ATOM    694  CE  LYS    87       6.029  61.848  62.891  1.00 43.14          
ATOM    695  NZ  LYS    87       5.903  61.486  64.333  1.00 46.08          
ATOM    696  C   LYS    87       5.013  58.360  57.865  1.00 34.44          
ATOM    697  O   LYS    87       5.997  57.651  57.687  1.00 35.58          
ATOM    698  N   LEU    88       3.767  57.915  57.712  1.00 34.03          
ATOM    699  CA  LEU    88       3.497  56.548  57.271  1.00 33.27          
ATOM    700  CB  LEU    88       1.987  56.301  57.194  1.00 32.14          
ATOM    701  CG  LEU    88       1.214  56.320  58.519  1.00 31.68          
ATOM    702  CD1 LEU    88      -0.287  56.264  58.268  1.00 30.17          
ATOM    703  CD2 LEU    88       1.654  55.144  59.361  1.00 30.35          
ATOM    704  C   LEU    88       4.121  56.301  55.894  1.00 32.41          
ATOM    705  O   LEU    88       4.744  55.268  55.668  1.00 32.09          
ATOM    706  N   ILE    89       3.948  57.254  54.979  1.00 33.64          
ATOM    707  CA  ILE    89       4.486  57.130  53.628  1.00 34.27          
ATOM    708  CB  ILE    89       3.984  58.290  52.734  1.00 33.66          
ATOM    709  CG2 ILE    89       4.684  58.281  51.386  1.00 33.00          
ATOM    710  CG1 ILE    89       2.472  58.152  52.528  1.00 32.47          
ATOM    711  CD  ILE    89       1.829  59.343  51.863  1.00 33.70          
ATOM    712  C   ILE    89       6.013  57.080  53.636  1.00 35.89          
ATOM    713  O   ILE    89       6.603  56.205  53.017  1.00 37.25          
ATOM    714  N   MET    90       6.653  57.995  54.359  1.00 37.05          
ATOM    715  CA  MET    90       8.110  58.018  54.414  1.00 38.99          
ATOM    716  CB  MET    90       8.599  59.264  55.150  1.00 41.56          
ATOM    717  CG  MET    90       8.408  60.580  54.395  1.00 41.92          
ATOM    718  SD  MET    90       9.402  60.619  52.728  0.74 46.55          
ATOM    719  CE  MET    90      11.162  60.273  53.427  1.00 38.88          
ATOM    720  C   MET    90       8.688  56.795  55.103  1.00 40.77          
ATOM    721  O   MET    90       9.826  56.414  54.843  1.00 41.78          
ATOM    722  N   GLU    91       7.901  56.166  55.969  1.00 40.75          
ATOM    723  CA  GLU    91       8.384  55.011  56.708  1.00 39.81          
ATOM    724  CB  GLU    91       7.946  55.131  58.172  1.00 39.54          
ATOM    725  CG  GLU    91       8.353  56.452  58.821  1.00 42.24          
ATOM    726  CD  GLU    91       8.164  56.456  60.334  1.00 42.27          
ATOM    727  OE1 GLU    91       7.069  56.099  60.814  1.00 39.94          
ATOM    728  OE2 GLU    91       9.116  56.826  61.049  1.00 44.46          
ATOM    729  C   GLU    91       7.981  53.642  56.160  1.00 39.90          
ATOM    730  O   GLU    91       8.396  52.615  56.698  1.00 38.09          
ATOM    731  N   ALA    92       7.188  53.619  55.091  1.00 38.87          
ATOM    732  CA  ALA    92       6.741  52.350  54.519  1.00 37.94          
ATOM    733  CB  ALA    92       5.589  52.601  53.556  1.00 38.28          
ATOM    734  C   ALA    92       7.830  51.523  53.819  1.00 38.26          
ATOM    735  O   ALA    92       8.633  52.049  53.038  1.00 35.92          
ATOM    736  N   ASP    93       7.853  50.221  54.099  1.00 36.50          
ATOM    737  CA  ASP    93       8.818  49.339  53.453  1.00 36.59          
ATOM    738  CB  ASP    93       8.840  47.966  54.134  1.00 37.39          
ATOM    739  CG  ASP    93       9.257  48.035  55.590  1.00 38.73          
ATOM    740  OD1 ASP    93      10.324  48.622  55.871  1.00 39.27          
ATOM    741  OD2 ASP    93       8.526  47.492  56.449  1.00 37.39          
ATOM    742  C   ASP    93       8.368  49.173  51.994  1.00 37.69          
ATOM    743  O   ASP    93       9.188  49.131  51.066  1.00 37.42          
ATOM    744  N   VAL    94       7.050  49.086  51.810  1.00 36.05          
ATOM    745  CA  VAL    94       6.445  48.917  50.493  1.00 35.77          
ATOM    746  CB  VAL    94       5.894  47.489  50.309  1.00 34.02          
ATOM    747  CG1 VAL    94       5.126  47.396  49.003  1.00 34.22          
ATOM    748  CG2 VAL    94       7.018  46.481  50.350  1.00 34.98          
ATOM    749  C   VAL    94       5.280  49.874  50.303  1.00 36.07          
ATOM    750  O   VAL    94       4.435  50.012  51.188  1.00 36.28          
ATOM    751  N   ILE    95       5.235  50.522  49.142  1.00 33.64          
ATOM    752  CA  ILE    95       4.159  51.454  48.825  1.00 32.60          
ATOM    753  CB  ILE    95       4.688  52.858  48.470  1.00 30.93          
ATOM    754  CG2 ILE    95       3.518  53.756  48.059  1.00 29.57          
ATOM    755  CG1 ILE    95       5.448  53.450  49.660  1.00 29.98          
ATOM    756  CD  ILE    95       5.824  54.901  49.491  1.00 28.21          
ATOM    757  C   ILE    95       3.402  50.946  47.608  1.00 34.39          
ATOM    758  O   ILE    95       3.940  50.939  46.500  1.00 33.57          
ATOM    759  N   CYS    96       2.157  50.522  47.806  1.00 33.80          
ATOM    760  CA  CYS    96       1.362  50.034  46.692  1.00 33.46          
ATOM    761  CB  CYS    96       0.449  48.904  47.152  1.00 32.49          
ATOM    762  SG  CYS    96       1.331  47.592  48.009  1.00 36.58          
ATOM    763  C   CYS    96       0.526  51.168  46.130  1.00 33.15          
ATOM    764  O   CYS    96      -0.277  51.752  46.841  1.00 32.93          
ATOM    765  N   CYS    97       0.717  51.478  44.853  1.00 32.89          
ATOM    766  CA  CYS    97      -0.045  52.538  44.202  1.00 33.12          
ATOM    767  CB  CYS    97       0.865  53.356  43.296  1.00 32.47          
ATOM    768  SG  CYS    97       2.281  53.974  44.196  1.00 39.10          
ATOM    769  C   CYS    97      -1.151  51.893  43.382  1.00 33.17          
ATOM    770  O   CYS    97      -0.903  51.348  42.298  1.00 31.81          
ATOM    771  N   LEU    98      -2.372  51.980  43.903  1.00 31.03          
ATOM    772  CA  LEU    98      -3.526  51.374  43.266  1.00 30.79          
ATOM    773  CB  LEU    98      -4.327  50.575  44.298  1.00 30.46          
ATOM    774  CG  LEU    98      -3.900  49.127  44.523  1.00 31.69          
ATOM    775  CD1 LEU    98      -2.470  49.060  45.042  1.00 33.03          
ATOM    776  CD2 LEU    98      -4.859  48.491  45.498  1.00 32.91          
ATOM    777  C   LEU    98      -4.482  52.282  42.521  1.00 32.04          
ATOM    778  O   LEU    98      -4.940  53.317  43.037  1.00 31.66          
ATOM    779  N   ASP    99      -4.773  51.860  41.293  1.00 29.79          
ATOM    780  CA  ASP    99      -5.712  52.531  40.427  1.00 29.72          
ATOM    781  CB  ASP    99      -7.072  52.604  41.128  1.00 29.36          
ATOM    782  CG  ASP    99      -8.213  52.739  40.159  1.00 29.17          
ATOM    783  OD1 ASP    99      -8.123  52.167  39.057  1.00 29.47          
ATOM    784  OD2 ASP    99      -9.206  53.408  40.497  1.00 32.53          
ATOM    785  C   ASP    99      -5.317  53.894  39.868  1.00 31.43          
ATOM    786  O   ASP    99      -6.175  54.721  39.545  1.00 30.39          
ATOM    787  N   PHE   100      -4.018  54.145  39.781  1.00 32.00          
ATOM    788  CA  PHE   100      -3.545  55.363  39.141  1.00 32.27          
ATOM    789  CB  PHE   100      -3.510  56.578  40.100  1.00 31.73          
ATOM    790  CG  PHE   100      -2.419  56.528  41.139  1.00 31.75          
ATOM    791  CD1 PHE   100      -2.607  55.846  42.334  1.00 30.17          
ATOM    792  CD2 PHE   100      -1.220  57.195  40.933  1.00 31.12          
ATOM    793  CE1 PHE   100      -1.615  55.831  43.315  1.00 30.63          
ATOM    794  CE2 PHE   100      -0.220  57.187  41.909  1.00 34.02          
ATOM    795  CZ  PHE   100      -0.420  56.501  43.106  1.00 30.26          
ATOM    796  C   PHE   100      -2.167  55.048  38.559  1.00 33.76          
ATOM    797  O   PHE   100      -1.455  54.163  39.052  1.00 32.82          
ATOM    798  N   ASN   101      -1.802  55.740  37.488  1.00 35.47          
ATOM    799  CA  ASN   101      -0.513  55.483  36.866  1.00 37.46          
ATOM    800  CB  ASN   101      -0.714  54.762  35.529  1.00 37.50          
ATOM    801  CG  ASN   101      -1.535  55.572  34.540  1.00 36.93          
ATOM    802  OD1 ASN   101      -1.809  56.748  34.755  1.00 39.46          
ATOM    803  ND2 ASN   101      -1.923  54.938  33.437  1.00 39.29          
ATOM    804  C   ASN   101       0.326  56.739  36.656  1.00 38.16          
ATOM    805  O   ASN   101       1.314  56.709  35.927  1.00 40.94          
ATOM    806  N   ALA   102      -0.060  57.834  37.302  1.00 37.53          
ATOM    807  CA  ALA   102       0.674  59.089  37.171  1.00 37.06          
ATOM    808  CB  ALA   102       0.153  59.877  35.980  1.00 38.93          
ATOM    809  C   ALA   102       0.524  59.898  38.452  1.00 37.20          
ATOM    810  O   ALA   102      -0.594  60.138  38.917  1.00 37.06          
ATOM    811  N   LEU   103       1.655  60.327  39.006  1.00 36.86          
ATOM    812  CA  LEU   103       1.671  61.075  40.255  1.00 36.56          
ATOM    813  CB  LEU   103       3.078  61.579  40.533  1.00 37.09          
ATOM    814  CG  LEU   103       4.120  60.496  40.805  1.00 39.01          
ATOM    815  CD1 LEU   103       5.517  61.083  40.651  1.00 39.86          
ATOM    816  CD2 LEU   103       3.909  59.927  42.191  1.00 37.66          
ATOM    817  C   LEU   103       0.692  62.235  40.350  1.00 37.82          
ATOM    818  O   LEU   103       0.283  62.602  41.447  1.00 38.03          
ATOM    819  N   LYS   104       0.309  62.814  39.217  1.00 37.38          
ATOM    820  CA  LYS   104      -0.629  63.927  39.242  1.00 39.02          
ATOM    821  CB  LYS   104      -0.715  64.609  37.876  1.00 39.65          
ATOM    822  CG  LYS   104      -1.176  63.721  36.744  1.00 41.55          
ATOM    823  CD  LYS   104      -1.295  64.535  35.463  1.00 45.19          
ATOM    824  CE  LYS   104      -1.074  63.682  34.227  1.00 45.32          
ATOM    825  NZ  LYS   104      -1.036  64.532  33.001  1.00 46.79          
ATOM    826  C   LYS   104      -2.007  63.448  39.654  1.00 38.14          
ATOM    827  O   LYS   104      -2.862  64.248  40.037  1.00 38.57          
ATOM    828  N   ARG   105      -2.221  62.138  39.573  1.00 36.45          
ATOM    829  CA  ARG   105      -3.498  61.561  39.963  1.00 34.98          
ATOM    830  CB  ARG   105      -3.636  60.128  39.418  1.00 35.72          
ATOM    831  CG  ARG   105      -3.792  60.040  37.891  1.00 35.17          
ATOM    832  CD  ARG   105      -5.049  60.774  37.432  1.00 33.44          
ATOM    833  NE  ARG   105      -6.260  60.214  38.036  1.00 33.96          
ATOM    834  CZ  ARG   105      -7.296  60.942  38.458  1.00 34.97          
ATOM    835  NH1 ARG   105      -7.270  62.268  38.351  1.00 33.45          
ATOM    836  NH2 ARG   105      -8.362  60.347  38.978  1.00 35.05          
ATOM    837  C   ARG   105      -3.685  61.562  41.478  1.00 34.78          
ATOM    838  O   ARG   105      -4.797  61.380  41.965  1.00 34.27          
ATOM    839  N   ILE   106      -2.606  61.772  42.226  1.00 33.67          
ATOM    840  CA  ILE   106      -2.735  61.806  43.675  1.00 36.15          
ATOM    841  CB  ILE   106      -1.778  60.823  44.379  1.00 34.05          
ATOM    842  CG2 ILE   106      -2.231  59.393  44.144  1.00 33.84          
ATOM    843  CG1 ILE   106      -0.358  60.983  43.853  1.00 33.37          
ATOM    844  CD  ILE   106       0.610  60.143  44.624  1.00 30.88          
ATOM    845  C   ILE   106      -2.641  63.198  44.311  1.00 38.43          
ATOM    846  O   ILE   106      -2.238  63.351  45.458  1.00 39.34          
ATOM    847  N   ASP   107      -3.000  64.207  43.524  1.00 40.16          
ATOM    848  CA  ASP   107      -3.129  65.602  43.971  1.00 41.70          
ATOM    849  CB  ASP   107      -4.611  65.901  44.055  1.00 42.91          
ATOM    850  CG  ASP   107      -5.046  67.003  43.158  1.00 45.25          
ATOM    851  OD1 ASP   107      -4.943  66.854  41.913  1.00 45.93          
ATOM    852  OD2 ASP   107      -5.532  68.019  43.717  1.00 41.75          
ATOM    853  C   ASP   107      -2.551  66.005  45.336  1.00 43.26          
ATOM    854  O   ASP   107      -3.274  65.930  46.336  1.00 42.06          
ATOM    855  N   GLU   108      -1.300  66.461  45.400  1.00 44.95          
ATOM    856  CA  GLU   108      -0.710  66.910  46.686  1.00 45.34          
ATOM    857  CB  GLU   108      -1.776  67.495  47.631  1.00 49.50          
ATOM    858  CG  GLU   108      -2.369  68.832  47.184  1.00 55.94          
ATOM    859  CD  GLU   108      -1.430  70.018  47.404  1.00 60.46          
ATOM    860  OE1 GLU   108      -0.344  70.060  46.781  1.00 60.93          
ATOM    861  OE2 GLU   108      -1.783  70.912  48.209  1.00 63.03          
ATOM    862  C   GLU   108       0.032  65.837  47.415  1.00 42.94          
ATOM    863  O   GLU   108       0.890  66.138  48.217  1.00 42.57          
ATOM    864  N   MET   109      -0.312  64.585  47.145  1.00 43.52          
ATOM    865  CA  MET   109       0.381  63.481  47.776  1.00 42.26          
ATOM    866  CB  MET   109      -0.523  62.253  47.862  1.00 42.58          
ATOM    867  CG  MET   109      -1.719  62.329  48.818  1.00 44.39          
ATOM    868  SD  MET   109      -2.490  60.556  49.010  0.84 47.67          
ATOM    869  CE  MET   109      -1.034  59.625  49.874  1.00 45.45          
ATOM    870  C   MET   109       1.613  63.142  46.942  1.00 41.67          
ATOM    871  O   MET   109       2.562  62.537  47.441  1.00 42.28          
ATOM    872  N   SER   110       1.606  63.547  45.673  1.00 40.59          
ATOM    873  CA  SER   110       2.712  63.234  44.768  1.00 41.10          
ATOM    874  CB  SER   110       2.546  64.005  43.448  1.00 41.33          
ATOM    875  OG  SER   110       2.156  65.336  43.681  1.00 47.73          
ATOM    876  C   SER   110       4.117  63.445  45.325  1.00 40.98          
ATOM    877  O   SER   110       4.978  62.580  45.172  1.00 40.69          
ATOM    878  N   ASP   111       4.352  64.583  45.965  1.00 41.29          
ATOM    879  CA  ASP   111       5.669  64.880  46.526  1.00 42.46          
ATOM    880  CB  ASP   111       5.650  66.244  47.199  1.00 45.19          
ATOM    881  CG  ASP   111       5.185  67.338  46.268  1.00 48.99          
ATOM    882  OD1 ASP   111       6.007  67.779  45.429  1.00 45.25          
ATOM    883  OD2 ASP   111       3.994  67.735  46.378  1.00 50.34          
ATOM    884  C   ASP   111       6.160  63.850  47.534  1.00 41.38          
ATOM    885  O   ASP   111       7.240  63.281  47.376  1.00 41.62          
ATOM    886  N   ILE   112       5.384  63.624  48.587  1.00 41.87          
ATOM    887  CA  ILE   112       5.781  62.655  49.611  1.00 41.89          
ATOM    888  CB  ILE   112       4.754  62.637  50.788  1.00 41.73          
ATOM    889  CG2 ILE   112       3.462  61.954  50.367  1.00 40.84          
ATOM    890  CG1 ILE   112       5.356  61.934  51.996  1.00 41.46          
ATOM    891  CD  ILE   112       6.499  62.697  52.605  1.00 44.60          
ATOM    892  C   ILE   112       5.944  61.235  49.021  1.00 40.88          
ATOM    893  O   ILE   112       6.907  60.530  49.345  1.00 41.92          
ATOM    894  N   VAL   113       5.017  60.822  48.153  1.00 39.40          
ATOM    895  CA  VAL   113       5.084  59.494  47.533  1.00 40.12          
ATOM    896  CB  VAL   113       3.843  59.192  46.653  1.00 39.76          
ATOM    897  CG1 VAL   113       4.052  57.879  45.906  1.00 38.38          
ATOM    898  CG2 VAL   113       2.590  59.113  47.508  1.00 37.65          
ATOM    899  C   VAL   113       6.313  59.372  46.647  1.00 40.75          
ATOM    900  O   VAL   113       6.992  58.343  46.644  1.00 41.48          
ATOM    901  N   ALA   114       6.596  60.424  45.890  1.00 40.29          
ATOM    902  CA  ALA   114       7.754  60.436  45.002  1.00 41.36          
ATOM    903  CB  ALA   114       7.740  61.694  44.152  1.00 38.78          
ATOM    904  C   ALA   114       9.073  60.352  45.767  1.00 41.98          
ATOM    905  O   ALA   114      10.003  59.671  45.335  1.00 43.70          
ATOM    906  N   ALA   115       9.142  61.041  46.903  1.00 43.36          
ATOM    907  CA  ALA   115      10.356  61.089  47.730  1.00 42.76          
ATOM    908  CB  ALA   115      10.329  62.332  48.600  1.00 43.26          
ATOM    909  C   ALA   115      10.606  59.875  48.612  1.00 42.28          
ATOM    910  O   ALA   115      11.755  59.539  48.893  1.00 43.94          
ATOM    911  N   SER   116       9.540  59.224  49.060  1.00 40.85          
ATOM    912  CA  SER   116       9.685  58.056  49.923  1.00 39.40          
ATOM    913  CB  SER   116       8.319  57.404  50.148  1.00 37.40          
ATOM    914  OG  SER   116       8.424  56.304  51.033  1.00 34.59          
ATOM    915  C   SER   116      10.666  57.021  49.356  1.00 39.21          
ATOM    916  O   SER   116      10.650  56.731  48.163  1.00 39.48          
ATOM    917  N   PRO   117      11.544  56.465  50.207  1.00 40.00          
ATOM    918  CD  PRO   117      11.852  56.888  51.587  1.00 39.39          
ATOM    919  CA  PRO   117      12.512  55.464  49.747  1.00 40.25          
ATOM    920  CB  PRO   117      13.641  55.594  50.756  1.00 41.57          
ATOM    921  CG  PRO   117      12.893  55.853  52.026  1.00 39.13          
ATOM    922  C   PRO   117      11.918  54.055  49.737  1.00 41.84          
ATOM    923  O   PRO   117      12.590  53.089  49.357  1.00 42.99          
ATOM    924  N   GLY   118      10.667  53.939  50.174  1.00 41.53          
ATOM    925  CA  GLY   118      10.006  52.646  50.191  1.00 40.70          
ATOM    926  C   GLY   118       9.884  52.077  48.789  1.00 40.90          
ATOM    927  O   GLY   118       9.941  52.813  47.807  1.00 40.91          
ATOM    928  N   ARG   119       9.724  50.759  48.698  1.00 42.48          
ATOM    929  CA  ARG   119       9.603  50.070  47.412  1.00 41.59          
ATOM    930  CB  ARG   119       9.887  48.580  47.598  1.00 44.27          
ATOM    931  CG  ARG   119      11.267  48.273  48.167  1.00 47.89          
ATOM    932  CD  ARG   119      11.352  46.824  48.645  1.00 53.75          
ATOM    933  NE  ARG   119      12.674  46.475  49.166  1.00 59.27          
ATOM    934  CZ  ARG   119      13.784  46.429  48.431  1.00 62.74          
ATOM    935  NH1 ARG   119      13.741  46.708  47.132  1.00 65.21          
ATOM    936  NH2 ARG   119      14.944  46.106  48.992  1.00 64.67          
ATOM    937  C   ARG   119       8.203  50.271  46.837  1.00 39.36          
ATOM    938  O   ARG   119       7.214  49.853  47.431  1.00 39.59          
ATOM    939  N   LYS   120       8.126  50.905  45.674  1.00 38.87          
ATOM    940  CA  LYS   120       6.840  51.183  45.044  1.00 37.65          
ATOM    941  CB  LYS   120       6.851  52.586  44.436  1.00 38.03          
ATOM    942  CG  LYS   120       7.350  53.686  45.353  1.00 37.98          
ATOM    943  CD  LYS   120       7.439  55.003  44.594  1.00 38.64          
ATOM    944  CE  LYS   120       8.096  56.100  45.419  1.00 39.68          
ATOM    945  NZ  LYS   120       9.497  55.767  45.766  1.00 39.24          
ATOM    946  C   LYS   120       6.421  50.191  43.956  1.00 37.15          
ATOM    947  O   LYS   120       7.229  49.759  43.129  1.00 36.54          
ATOM    948  N   ILE   121       5.143  49.843  43.964  1.00 34.69          
ATOM    949  CA  ILE   121       4.593  48.948  42.967  1.00 34.40          
ATOM    950  CB  ILE   121       4.360  47.517  43.511  1.00 34.24          
ATOM    951  CG2 ILE   121       3.529  47.559  44.780  1.00 32.10          
ATOM    952  CG1 ILE   121       3.668  46.666  42.436  1.00 34.61          
ATOM    953  CD  ILE   121       3.506  45.188  42.813  1.00 37.44          
ATOM    954  C   ILE   121       3.267  49.524  42.519  1.00 34.74          
ATOM    955  O   ILE   121       2.475  49.984  43.332  1.00 34.93          
ATOM    956  N   MET   122       3.038  49.504  41.215  1.00 35.73          
ATOM    957  CA  MET   122       1.809  50.020  40.647  1.00 34.81          
ATOM    958  CB  MET   122       2.145  50.871  39.429  1.00 35.89          
ATOM    959  CG  MET   122       0.944  51.487  38.740  1.00 40.74          
ATOM    960  SD  MET   122       1.355  52.204  36.975  0.76 44.96          
ATOM    961  CE  MET   122       0.561  50.811  35.944  1.00 46.12          
ATOM    962  C   MET   122       0.906  48.850  40.241  1.00 35.35          
ATOM    963  O   MET   122       1.385  47.855  39.715  1.00 35.95          
ATOM    964  N   ILE   123      -0.393  48.966  40.528  1.00 33.83          
ATOM    965  CA  ILE   123      -1.399  47.958  40.170  1.00 31.28          
ATOM    966  CB  ILE   123      -1.914  47.186  41.388  1.00 31.28          
ATOM    967  CG2 ILE   123      -2.907  46.112  40.926  1.00 33.86          
ATOM    968  CG1 ILE   123      -0.751  46.501  42.095  1.00 30.43          
ATOM    969  CD  ILE   123      -1.159  45.642  43.263  1.00 31.93          
ATOM    970  C   ILE   123      -2.514  48.816  39.599  1.00 30.35          
ATOM    971  O   ILE   123      -3.287  49.444  40.335  1.00 27.53          
ATOM    972  N   ASP   124      -2.606  48.829  38.278  1.00 30.16          
ATOM    973  CA  ASP   124      -3.539  49.713  37.623  1.00 29.64          
ATOM    974  CB  ASP   124      -2.828  51.055  37.490  1.00 30.77          
ATOM    975  CG  ASP   124      -3.674  52.096  36.854  1.00 33.01          
ATOM    976  OD1 ASP   124      -4.808  52.288  37.337  1.00 36.00          
ATOM    977  OD2 ASP   124      -3.196  52.721  35.884  1.00 33.84          
ATOM    978  C   ASP   124      -3.990  49.225  36.253  1.00 28.95          
ATOM    979  O   ASP   124      -3.320  48.405  35.626  1.00 30.32          
ATOM    980  N   HSD   125      -5.112  49.750  35.777  1.00 28.69          
ATOM    981  CA  HSD   125      -5.613  49.364  34.460  1.00 31.58          
ATOM    982  CB  HSD   125      -6.906  48.538  34.586  1.00 31.91          
ATOM    983  CG  HSD   125      -8.144  49.366  34.696  1.00 35.24          
ATOM    984  CD2 HSD   125      -9.170  49.544  33.833  1.00 36.10          
ATOM    985  ND1 HSD   125      -8.406  50.180  35.778  1.00 36.82          
ATOM    986  CE1 HSD   125      -9.538  50.825  35.574  1.00 38.66          
ATOM    987  NE2 HSD   125     -10.022  50.457  34.400  1.00 37.88          
ATOM    988  C   HSD   125      -5.855  50.565  33.528  1.00 30.90          
ATOM    989  O   HSD   125      -6.551  50.435  32.526  1.00 30.56          
ATOM    990  N   HSD   126      -5.281  51.725  33.853  1.00 29.49          
ATOM    991  CA  HSD   126      -5.435  52.913  33.007  1.00 31.03          
ATOM    992  CB  HSD   126      -5.311  54.188  33.851  1.00 31.51          
ATOM    993  CG  HSD   126      -6.409  54.348  34.858  1.00 34.84          
ATOM    994  CD2 HSD   126      -6.517  53.910  36.137  1.00 31.69          
ATOM    995  ND1 HSD   126      -7.620  54.930  34.551  1.00 34.35          
ATOM    996  CE1 HSD   126      -8.431  54.836  35.593  1.00 33.45          
ATOM    997  NE2 HSD   126      -7.786  54.219  36.568  1.00 33.01          
ATOM    998  C   HSD   126      -4.374  52.922  31.890  1.00 30.40          
ATOM    999  O   HSD   126      -3.332  52.275  32.014  1.00 29.46          
ATOM   1000  N   LEU   127      -4.637  53.652  30.807  1.00 29.08          
ATOM   1001  CA  LEU   127      -3.685  53.715  29.706  1.00 31.21          
ATOM   1002  CB  LEU   127      -4.393  54.030  28.373  1.00 30.35          
ATOM   1003  CG  LEU   127      -5.225  52.907  27.732  1.00 31.41          
ATOM   1004  CD1 LEU   127      -6.582  52.774  28.439  1.00 32.99          
ATOM   1005  CD2 LEU   127      -5.445  53.207  26.260  1.00 32.55          
ATOM   1006  C   LEU   127      -2.588  54.747  29.947  1.00 32.73          
ATOM   1007  O   LEU   127      -2.792  55.736  30.656  1.00 34.88          
ATOM   1008  N   TYR   128      -1.416  54.483  29.372  1.00 32.88          
ATOM   1009  CA  TYR   128      -0.261  55.383  29.453  1.00 31.90          
ATOM   1010  CB  TYR   128      -0.656  56.743  28.855  1.00 28.60          
ATOM   1011  CG  TYR   128      -1.486  56.627  27.592  1.00 29.14          
ATOM   1012  CD1 TYR   128      -1.077  55.813  26.532  1.00 29.87          
ATOM   1013  CE1 TYR   128      -1.858  55.692  25.366  1.00 27.90          
ATOM   1014  CD2 TYR   128      -2.686  57.319  27.456  1.00 27.85          
ATOM   1015  CE2 TYR   128      -3.464  57.211  26.302  1.00 23.10          
ATOM   1016  CZ  TYR   128      -3.051  56.400  25.270  1.00 26.65          
ATOM   1017  OH  TYR   128      -3.845  56.272  24.144  1.00 27.76          
ATOM   1018  C   TYR   128       0.328  55.587  30.854  1.00 32.36          
ATOM   1019  O   TYR   128       0.273  56.684  31.398  1.00 34.11          
ATOM   1020  N   PRO   129       0.937  54.546  31.439  1.00 32.76          
ATOM   1021  CD  PRO   129       1.108  53.189  30.886  1.00 31.40          
ATOM   1022  CA  PRO   129       1.527  54.637  32.781  1.00 34.04          
ATOM   1023  CB  PRO   129       1.650  53.179  33.178  1.00 34.12          
ATOM   1024  CG  PRO   129       2.075  52.554  31.863  1.00 30.03          
ATOM   1025  C   PRO   129       2.891  55.340  32.833  1.00 36.66          
ATOM   1026  O   PRO   129       3.653  55.264  31.879  1.00 36.19          
ATOM   1027  N   GLU   130       3.197  56.006  33.948  1.00 39.16          
ATOM   1028  CA  GLU   130       4.490  56.680  34.106  1.00 42.62          
ATOM   1029  CB  GLU   130       4.390  57.898  35.033  1.00 42.55          
ATOM   1030  CG  GLU   130       3.254  58.866  34.735  1.00 45.87          
ATOM   1031  CD  GLU   130       3.425  60.225  35.429  1.00 48.32          
ATOM   1032  OE1 GLU   130       3.887  60.263  36.597  1.00 47.97          
ATOM   1033  OE2 GLU   130       3.082  61.259  34.804  1.00 48.19          
ATOM   1034  C   GLU   130       5.427  55.648  34.732  1.00 43.40          
ATOM   1035  O   GLU   130       4.978  54.593  35.165  1.00 43.98          
ATOM   1036  N   ASP   131       6.718  55.939  34.800  1.00 46.61          
ATOM   1037  CA  ASP   131       7.646  54.971  35.382  1.00 49.52          
ATOM   1038  CB  ASP   131       8.840  54.754  34.440  1.00 53.09          
ATOM   1039  CG  ASP   131       9.697  56.006  34.281  1.00 59.72          
ATOM   1040  OD1 ASP   131      10.129  56.564  35.313  1.00 62.44          
ATOM   1041  OD2 ASP   131       9.947  56.431  33.129  1.00 62.89          
ATOM   1042  C   ASP   131       8.167  55.313  36.780  1.00 48.22          
ATOM   1043  O   ASP   131       9.329  55.046  37.079  1.00 49.85          
ATOM   1044  N   PHE   132       7.335  55.883  37.646  1.00 46.63          
ATOM   1045  CA  PHE   132       7.814  56.209  38.991  1.00 45.41          
ATOM   1046  CB  PHE   132       6.996  57.354  39.620  1.00 42.93          
ATOM   1047  CG  PHE   132       5.541  57.033  39.830  1.00 43.16          
ATOM   1048  CD1 PHE   132       4.606  57.282  38.828  1.00 41.40          
ATOM   1049  CD2 PHE   132       5.109  56.456  41.026  1.00 41.30          
ATOM   1050  CE1 PHE   132       3.261  56.959  39.013  1.00 42.87          
ATOM   1051  CE2 PHE   132       3.768  56.128  41.219  1.00 41.84          
ATOM   1052  CZ  PHE   132       2.840  56.379  40.211  1.00 42.28          
ATOM   1053  C   PHE   132       7.847  55.002  39.941  1.00 45.62          
ATOM   1054  O   PHE   132       8.362  55.102  41.053  1.00 46.69          
ATOM   1055  N   CYS   133       7.310  53.863  39.510  1.00 45.46          
ATOM   1056  CA  CYS   133       7.320  52.663  40.345  1.00 45.11          
ATOM   1057  CB  CYS   133       5.949  51.987  40.344  1.00 44.69          
ATOM   1058  SG  CYS   133       4.654  52.944  41.162  1.00 45.03          
ATOM   1059  C   CYS   133       8.374  51.680  39.851  1.00 46.08          
ATOM   1060  O   CYS   133       8.686  51.643  38.663  1.00 46.16          
ATOM   1061  N   ARG   134       8.915  50.887  40.771  1.00 48.10          
ATOM   1062  CA  ARG   134       9.945  49.901  40.446  1.00 50.01          
ATOM   1063  CB  ARG   134      10.746  49.547  41.705  1.00 52.85          
ATOM   1064  CG  ARG   134      11.745  48.412  41.533  1.00 59.74          
ATOM   1065  CD  ARG   134      12.873  48.755  40.562  1.00 65.44          
ATOM   1066  NE  ARG   134      13.905  47.713  40.521  1.00 69.14          
ATOM   1067  CZ  ARG   134      13.760  46.518  39.947  1.00 71.05          
ATOM   1068  NH1 ARG   134      12.620  46.189  39.348  1.00 71.80          
ATOM   1069  NH2 ARG   134      14.758  45.642  39.979  1.00 70.72          
ATOM   1070  C   ARG   134       9.330  48.642  39.837  1.00 49.12          
ATOM   1071  O   ARG   134       9.962  47.959  39.031  1.00 50.77          
ATOM   1072  N   ILE   135       8.106  48.327  40.245  1.00 46.06          
ATOM   1073  CA  ILE   135       7.385  47.179  39.707  1.00 43.55          
ATOM   1074  CB  ILE   135       7.039  46.141  40.776  1.00 41.87          
ATOM   1075  CG2 ILE   135       6.199  45.018  40.149  1.00 39.89          
ATOM   1076  CG1 ILE   135       8.322  45.578  41.385  1.00 40.13          
ATOM   1077  CD  ILE   135       8.085  44.541  42.459  1.00 39.37          
ATOM   1078  C   ILE   135       6.090  47.720  39.133  1.00 43.45          
ATOM   1079  O   ILE   135       5.272  48.305  39.855  1.00 43.77          
ATOM   1080  N   THR   136       5.904  47.528  37.834  1.00 42.66          
ATOM   1081  CA  THR   136       4.715  48.033  37.178  1.00 42.58          
ATOM   1082  CB  THR   136       5.086  48.970  36.039  1.00 41.52          
ATOM   1083  OG1 THR   136       5.927  50.013  36.545  1.00 41.82          
ATOM   1084  CG2 THR   136       3.834  49.568  35.419  1.00 39.61          
ATOM   1085  C   THR   136       3.797  46.958  36.626  1.00 42.96          
ATOM   1086  O   THR   136       4.196  46.156  35.784  1.00 42.81          
ATOM   1087  N   ILE   137       2.566  46.949  37.124  1.00 40.95          
ATOM   1088  CA  ILE   137       1.561  46.011  36.675  1.00 40.86          
ATOM   1089  CB  ILE   137       0.998  45.198  37.862  1.00 40.06          
ATOM   1090  CG2 ILE   137      -0.183  44.329  37.414  1.00 38.42          
ATOM   1091  CG1 ILE   137       2.121  44.331  38.445  1.00 39.32          
ATOM   1092  CD  ILE   137       1.709  43.459  39.623  1.00 38.28          
ATOM   1093  C   ILE   137       0.491  46.888  36.038  1.00 42.00          
ATOM   1094  O   ILE   137      -0.404  47.388  36.718  1.00 41.71          
ATOM   1095  N   SER   138       0.617  47.092  34.727  1.00 41.73          
ATOM   1096  CA  SER   138      -0.301  47.928  33.960  1.00 40.12          
ATOM   1097  CB  SER   138       0.473  49.058  33.289  1.00 39.40          
ATOM   1098  OG  SER   138      -0.377  49.875  32.507  1.00 40.81          
ATOM   1099  C   SER   138      -1.017  47.115  32.892  1.00 39.45          
ATOM   1100  O   SER   138      -0.428  46.762  31.868  1.00 40.12          
ATOM   1101  N   HSD   139      -2.292  46.827  33.120  1.00 38.65          
ATOM   1102  CA  HSD   139      -3.065  46.046  32.165  1.00 35.52          
ATOM   1103  CB  HSD   139      -3.338  44.665  32.764  1.00 37.65          
ATOM   1104  CG  HSD   139      -2.094  43.855  32.959  1.00 41.43          
ATOM   1105  CD2 HSD   139      -1.222  43.797  33.993  1.00 40.77          
ATOM   1106  ND1 HSD   139      -1.568  43.052  31.968  1.00 42.62          
ATOM   1107  CE1 HSD   139      -0.424  42.536  32.384  1.00 42.79          
ATOM   1108  NE2 HSD   139      -0.191  42.974  33.609  1.00 43.31          
ATOM   1109  C   HSD   139      -4.353  46.745  31.769  1.00 33.08          
ATOM   1110  O   HSD   139      -5.414  46.463  32.303  1.00 33.78          
ATOM   1111  N   PRO   140      -4.266  47.682  30.813  1.00 33.88          
ATOM   1112  CD  PRO   140      -3.041  48.126  30.117  1.00 30.46          
ATOM   1113  CA  PRO   140      -5.436  48.431  30.343  1.00 31.77          
ATOM   1114  CB  PRO   140      -4.843  49.407  29.328  1.00 33.32          
ATOM   1115  CG  PRO   140      -3.375  49.537  29.777  1.00 32.83          
ATOM   1116  C   PRO   140      -6.502  47.526  29.720  1.00 32.09          
ATOM   1117  O   PRO   140      -7.644  47.937  29.548  1.00 32.78          
ATOM   1118  N   GLU   141      -6.140  46.291  29.394  1.00 31.69          
ATOM   1119  CA  GLU   141      -7.117  45.387  28.805  1.00 32.14          
ATOM   1120  CB  GLU   141      -6.431  44.261  28.002  1.00 31.60          
ATOM   1121  CG  GLU   141      -5.774  43.165  28.832  1.00 31.70          
ATOM   1122  CD  GLU   141      -4.429  43.558  29.395  1.00 35.06          
ATOM   1123  OE1 GLU   141      -4.058  44.749  29.310  1.00 32.08          
ATOM   1124  OE2 GLU   141      -3.742  42.663  29.933  1.00 35.70          
ATOM   1125  C   GLU   141      -8.005  44.798  29.895  1.00 32.30          
ATOM   1126  O   GLU   141      -8.976  44.106  29.607  1.00 34.39          
ATOM   1127  N   ILE   142      -7.677  45.057  31.155  1.00 30.77          
ATOM   1128  CA  ILE   142      -8.514  44.545  32.239  1.00 29.25          
ATOM   1129  CB  ILE   142      -7.650  44.083  33.428  1.00 30.81          
ATOM   1130  CG2 ILE   142      -8.536  43.641  34.600  1.00 33.11          
ATOM   1131  CG1 ILE   142      -6.788  42.901  32.986  1.00 30.46          
ATOM   1132  CD  ILE   142      -7.606  41.660  32.561  1.00 27.12          
ATOM   1133  C   ILE   142      -9.462  45.686  32.623  1.00 28.20          
ATOM   1134  O   ILE   142      -9.048  46.840  32.680  1.00 27.30          
ATOM   1135  N   SER   143     -10.729  45.366  32.863  1.00 27.62          
ATOM   1136  CA  SER   143     -11.717  46.391  33.165  1.00 26.90          
ATOM   1137  CB  SER   143     -13.140  45.849  32.917  1.00 26.26          
ATOM   1138  OG  SER   143     -13.434  44.731  33.724  1.00 30.18          
ATOM   1139  C   SER   143     -11.637  47.092  34.527  1.00 26.94          
ATOM   1140  O   SER   143     -12.240  48.141  34.702  1.00 27.12          
ATOM   1141  N   SER   144     -10.904  46.548  35.489  1.00 26.93          
ATOM   1142  CA  SER   144     -10.782  47.247  36.771  1.00 25.34          
ATOM   1143  CB  SER   144     -12.004  46.978  37.668  1.00 23.94          
ATOM   1144  OG  SER   144     -12.124  45.606  38.003  1.00 24.96          
ATOM   1145  C   SER   144      -9.501  46.904  37.527  1.00 26.87          
ATOM   1146  O   SER   144      -8.832  45.918  37.219  1.00 28.73          
ATOM   1147  N   THR   145      -9.155  47.741  38.505  1.00 27.42          
ATOM   1148  CA  THR   145      -7.973  47.528  39.320  1.00 25.33          
ATOM   1149  CB  THR   145      -7.547  48.838  40.050  1.00 25.77          
ATOM   1150  OG1 THR   145      -7.239  49.837  39.072  1.00 25.47          
ATOM   1151  CG2 THR   145      -6.303  48.615  40.903  1.00 22.85          
ATOM   1152  C   THR   145      -8.323  46.454  40.329  1.00 26.01          
ATOM   1153  O   THR   145      -7.481  45.631  40.678  1.00 26.72          
ATOM   1154  N   SER   146      -9.572  46.464  40.792  1.00 27.09          
ATOM   1155  CA  SER   146     -10.048  45.481  41.751  1.00 27.15          
ATOM   1156  CB  SER   146     -11.557  45.636  41.991  1.00 28.82          
ATOM   1157  OG  SER   146     -11.867  46.839  42.664  1.00 29.92          
ATOM   1158  C   SER   146      -9.768  44.075  41.233  1.00 28.82          
ATOM   1159  O   SER   146      -9.333  43.197  41.985  1.00 30.47          
ATOM   1160  N   GLU   147     -10.018  43.860  39.946  1.00 30.06          
ATOM   1161  CA  GLU   147      -9.782  42.553  39.343  1.00 30.37          
ATOM   1162  CB  GLU   147     -10.334  42.509  37.912  1.00 30.53          
ATOM   1163  CG  GLU   147     -10.335  41.113  37.306  1.00 33.77          
ATOM   1164  CD  GLU   147     -10.665  41.085  35.809  1.00 33.91          
ATOM   1165  OE1 GLU   147     -11.543  41.845  35.351  1.00 35.36          
ATOM   1166  OE2 GLU   147     -10.050  40.279  35.089  1.00 33.44          
ATOM   1167  C   GLU   147      -8.284  42.204  39.326  1.00 30.28          
ATOM   1168  O   GLU   147      -7.912  41.041  39.500  1.00 27.29          
ATOM   1169  N   LEU   148      -7.426  43.199  39.103  1.00 28.62          
ATOM   1170  CA  LEU   148      -5.989  42.932  39.080  1.00 28.85          
ATOM   1171  CB  LEU   148      -5.209  44.137  38.556  1.00 28.47          
ATOM   1172  CG  LEU   148      -5.443  44.507  37.096  1.00 28.28          
ATOM   1173  CD1 LEU   148      -4.612  45.725  36.763  1.00 25.29          
ATOM   1174  CD2 LEU   148      -5.064  43.336  36.182  1.00 28.72          
ATOM   1175  C   LEU   148      -5.497  42.587  40.473  1.00 30.09          
ATOM   1176  O   LEU   148      -4.572  41.790  40.629  1.00 32.18          
ATOM   1177  N   VAL   149      -6.099  43.206  41.485  1.00 30.23          
ATOM   1178  CA  VAL   149      -5.718  42.932  42.866  1.00 27.30          
ATOM   1179  CB  VAL   149      -6.412  43.912  43.838  1.00 26.59          
ATOM   1180  CG1 VAL   149      -6.318  43.412  45.273  1.00 21.56          
ATOM   1181  CG2 VAL   149      -5.757  45.275  43.725  1.00 24.42          
ATOM   1182  C   VAL   149      -6.120  41.498  43.176  1.00 28.80          
ATOM   1183  O   VAL   149      -5.363  40.756  43.814  1.00 29.24          
ATOM   1184  N   PHE   150      -7.311  41.107  42.718  1.00 27.36          
ATOM   1185  CA  PHE   150      -7.796  39.747  42.925  1.00 26.97          
ATOM   1186  CB  PHE   150      -9.215  39.577  42.369  1.00 25.53          
ATOM   1187  CG  PHE   150      -9.750  38.169  42.489  1.00 27.27          
ATOM   1188  CD1 PHE   150      -9.523  37.233  41.487  1.00 28.90          
ATOM   1189  CD2 PHE   150     -10.449  37.772  43.629  1.00 28.85          
ATOM   1190  CE1 PHE   150      -9.983  35.912  41.617  1.00 31.04          
ATOM   1191  CE2 PHE   150     -10.911  36.462  43.777  1.00 29.05          
ATOM   1192  CZ  PHE   150     -10.676  35.526  42.765  1.00 31.17          
ATOM   1193  C   PHE   150      -6.858  38.753  42.236  1.00 28.65          
ATOM   1194  O   PHE   150      -6.441  37.762  42.832  1.00 28.46          
ATOM   1195  N   ARG   151      -6.539  39.014  40.976  1.00 27.60          
ATOM   1196  CA  ARG   151      -5.643  38.140  40.230  1.00 31.06          
ATOM   1197  CB  ARG   151      -5.444  38.675  38.803  1.00 28.29          
ATOM   1198  CG  ARG   151      -6.618  38.410  37.866  1.00 28.51          
ATOM   1199  CD  ARG   151      -6.486  39.198  36.554  1.00 31.13          
ATOM   1200  NE  ARG   151      -6.677  38.341  35.395  1.00 38.81          
ATOM   1201  CZ  ARG   151      -7.835  37.785  35.069  1.00 40.64          
ATOM   1202  NH1 ARG   151      -8.903  38.009  35.812  1.00 46.24          
ATOM   1203  NH2 ARG   151      -7.923  36.991  34.021  1.00 41.74          
ATOM   1204  C   ARG   151      -4.284  37.995  40.932  1.00 32.68          
ATOM   1205  O   ARG   151      -3.804  36.871  41.155  1.00 32.34          
ATOM   1206  N   LEU   152      -3.671  39.124  41.290  1.00 32.29          
ATOM   1207  CA  LEU   152      -2.367  39.097  41.954  1.00 33.82          
ATOM   1208  CB  LEU   152      -1.908  40.521  42.288  1.00 32.12          
ATOM   1209  CG  LEU   152      -0.630  40.682  43.125  1.00 32.33          
ATOM   1210  CD1 LEU   152       0.568  40.028  42.440  1.00 32.89          
ATOM   1211  CD2 LEU   152      -0.375  42.163  43.340  1.00 31.94          
ATOM   1212  C   LEU   152      -2.360  38.246  43.224  1.00 35.91          
ATOM   1213  O   LEU   152      -1.471  37.414  43.419  1.00 36.37          
ATOM   1214  N   ILE   153      -3.353  38.450  44.084  1.00 35.44          
ATOM   1215  CA  ILE   153      -3.432  37.695  45.323  1.00 33.78          
ATOM   1216  CB  ILE   153      -4.588  38.201  46.214  1.00 31.87          
ATOM   1217  CG2 ILE   153      -4.717  37.329  47.429  1.00 28.22          
ATOM   1218  CG1 ILE   153      -4.347  39.660  46.619  1.00 31.24          
ATOM   1219  CD  ILE   153      -5.524  40.288  47.356  1.00 31.56          
ATOM   1220  C   ILE   153      -3.632  36.209  45.033  1.00 34.72          
ATOM   1221  O   ILE   153      -3.121  35.356  45.750  1.00 33.97          
ATOM   1222  N   CYS   154      -4.377  35.903  43.977  1.00 36.23          
ATOM   1223  CA  CYS   154      -4.611  34.517  43.615  1.00 38.23          
ATOM   1224  CB  CYS   154      -5.744  34.429  42.596  1.00 41.01          
ATOM   1225  SG  CYS   154      -6.173  32.739  42.146  1.00 54.00          
ATOM   1226  C   CYS   154      -3.324  33.879  43.060  1.00 37.49          
ATOM   1227  O   CYS   154      -2.929  32.788  43.483  1.00 36.13          
ATOM   1228  N   ARG   155      -2.659  34.565  42.132  1.00 36.33          
ATOM   1229  CA  ARG   155      -1.417  34.048  41.562  1.00 35.61          
ATOM   1230  CB  ARG   155      -0.844  35.021  40.519  1.00 33.86          
ATOM   1231  CG  ARG   155      -1.609  35.078  39.193  1.00 34.43          
ATOM   1232  CD  ARG   155      -1.363  33.851  38.310  1.00 31.75          
ATOM   1233  NE  ARG   155       0.003  33.828  37.796  1.00 33.62          
ATOM   1234  CZ  ARG   155       0.454  34.622  36.831  1.00 35.35          
ATOM   1235  NH1 ARG   155      -0.362  35.499  36.260  1.00 33.15          
ATOM   1236  NH2 ARG   155       1.732  34.567  36.464  1.00 33.38          
ATOM   1237  C   ARG   155      -0.369  33.788  42.648  1.00 36.02          
ATOM   1238  O   ARG   155       0.470  32.903  42.494  1.00 39.16          
ATOM   1239  N   MET   156      -0.423  34.553  43.738  1.00 34.62          
ATOM   1240  CA  MET   156       0.521  34.409  44.855  1.00 34.40          
ATOM   1241  CB  MET   156       0.517  35.669  45.737  1.00 36.57          
ATOM   1242  CG  MET   156       1.217  36.881  45.136  1.00 37.44          
ATOM   1243  SD  MET   156       0.901  38.494  46.176  0.76 46.32          
ATOM   1244  CE  MET   156       2.223  38.222  47.573  1.00 46.33          
ATOM   1245  C   MET   156       0.182  33.197  45.717  1.00 34.41          
ATOM   1246  O   MET   156       0.914  32.872  46.655  1.00 33.86          
ATOM   1247  N   GLY   157      -0.935  32.547  45.393  1.00 33.63          
ATOM   1248  CA  GLY   157      -1.372  31.365  46.118  1.00 33.45          
ATOM   1249  C   GLY   157      -2.242  31.628  47.334  1.00 35.54          
ATOM   1250  O   GLY   157      -2.565  30.703  48.085  1.00 34.63          
ATOM   1251  N   TYR   158      -2.657  32.878  47.521  1.00 35.38          
ATOM   1252  CA  TYR   158      -3.453  33.225  48.694  1.00 34.82          
ATOM   1253  CB  TYR   158      -2.889  34.498  49.318  1.00 35.06          
ATOM   1254  CG  TYR   158      -1.497  34.327  49.865  1.00 36.35          
ATOM   1255  CD1 TYR   158      -1.284  33.710  51.096  1.00 38.52          
ATOM   1256  CE1 TYR   158       0.007  33.550  51.612  1.00 38.11          
ATOM   1257  CD2 TYR   158      -0.387  34.777  49.151  1.00 39.02          
ATOM   1258  CE2 TYR   158       0.906  34.619  49.654  1.00 39.49          
ATOM   1259  CZ  TYR   158       1.088  34.008  50.888  1.00 38.91          
ATOM   1260  OH  TYR   158       2.344  33.889  51.417  1.00 39.72          
ATOM   1261  C   TYR   158      -4.954  33.378  48.516  1.00 33.74          
ATOM   1262  O   TYR   158      -5.587  34.119  49.259  1.00 33.16          
ATOM   1263  N   PHE   159      -5.529  32.681  47.546  1.00 34.83          
ATOM   1264  CA  PHE   159      -6.963  32.773  47.330  1.00 35.85          
ATOM   1265  CB  PHE   159      -7.412  31.763  46.283  1.00 35.40          
ATOM   1266  CG  PHE   159      -8.901  31.723  46.083  1.00 34.82          
ATOM   1267  CD1 PHE   159      -9.571  32.815  45.543  1.00 34.98          
ATOM   1268  CD2 PHE   159      -9.633  30.589  46.425  1.00 34.12          
ATOM   1269  CE1 PHE   159     -10.952  32.784  45.341  1.00 36.22          
ATOM   1270  CE2 PHE   159     -11.010  30.543  46.229  1.00 34.96          
ATOM   1271  CZ  PHE   159     -11.676  31.648  45.682  1.00 37.47          
ATOM   1272  C   PHE   159      -7.728  32.502  48.615  1.00 38.04          
ATOM   1273  O   PHE   159      -8.736  33.160  48.892  1.00 38.13          
ATOM   1274  N   SER   160      -7.247  31.520  49.381  1.00 38.62          
ATOM   1275  CA  SER   160      -7.875  31.103  50.632  1.00 39.13          
ATOM   1276  CB  SER   160      -7.184  29.845  51.180  1.00 39.98          
ATOM   1277  OG  SER   160      -5.814  30.098  51.474  1.00 43.49          
ATOM   1278  C   SER   160      -7.877  32.178  51.706  1.00 37.85          
ATOM   1279  O   SER   160      -8.691  32.144  52.623  1.00 38.58          
ATOM   1280  N   ASP   161      -6.967  33.130  51.592  1.00 36.87          
ATOM   1281  CA  ASP   161      -6.880  34.197  52.568  1.00 36.59          
ATOM   1282  CB  ASP   161      -5.418  34.565  52.800  1.00 38.61          
ATOM   1283  CG  ASP   161      -4.653  33.452  53.485  1.00 39.71          
ATOM   1284  OD1 ASP   161      -5.237  32.818  54.382  1.00 42.10          
ATOM   1285  OD2 ASP   161      -3.478  33.217  53.140  1.00 42.01          
ATOM   1286  C   ASP   161      -7.683  35.437  52.197  1.00 36.21          
ATOM   1287  O   ASP   161      -7.527  36.493  52.811  1.00 35.70          
ATOM   1288  N   ILE   162      -8.526  35.323  51.177  1.00 34.45          
ATOM   1289  CA  ILE   162      -9.357  36.449  50.801  1.00 34.28          
ATOM   1290  CB  ILE   162      -9.661  36.480  49.290  1.00 35.57          
ATOM   1291  CG2 ILE   162     -10.737  37.549  48.993  1.00 33.75          
ATOM   1292  CG1 ILE   162      -8.382  36.779  48.507  1.00 32.37          
ATOM   1293  CD  ILE   162      -8.606  36.843  47.010  1.00 34.07          
ATOM   1294  C   ILE   162     -10.643  36.231  51.575  1.00 34.63          
ATOM   1295  O   ILE   162     -11.358  35.252  51.336  1.00 36.27          
ATOM   1296  N   SER   163     -10.919  37.131  52.517  1.00 32.02          
ATOM   1297  CA  SER   163     -12.109  37.033  53.354  1.00 32.47          
ATOM   1298  CB  SER   163     -11.888  37.791  54.661  1.00 33.83          
ATOM   1299  OG  SER   163     -11.709  39.181  54.405  1.00 36.56          
ATOM   1300  C   SER   163     -13.365  37.571  52.691  1.00 33.22          
ATOM   1301  O   SER   163     -13.316  38.208  51.639  1.00 35.63          
ATOM   1302  N   LYS   164     -14.500  37.314  53.330  1.00 33.29          
ATOM   1303  CA  LYS   164     -15.790  37.775  52.836  1.00 31.81          
ATOM   1304  CB  LYS   164     -16.868  37.373  53.848  1.00 32.57          
ATOM   1305  CG  LYS   164     -18.249  37.972  53.654  1.00 35.91          
ATOM   1306  CD  LYS   164     -19.034  37.792  54.944  1.00 40.37          
ATOM   1307  CE  LYS   164     -20.389  38.464  54.912  1.00 43.39          
ATOM   1308  NZ  LYS   164     -21.300  37.812  53.938  1.00 47.82          
ATOM   1309  C   LYS   164     -15.744  39.297  52.647  1.00 31.13          
ATOM   1310  O   LYS   164     -16.244  39.837  51.648  1.00 30.93          
ATOM   1311  N   GLU   165     -15.121  39.982  53.598  1.00 28.88          
ATOM   1312  CA  GLU   165     -15.008  41.437  53.549  1.00 28.11          
ATOM   1313  CB  GLU   165     -14.474  41.969  54.876  1.00 27.66          
ATOM   1314  CG  GLU   165     -15.364  41.596  56.045  1.00 31.07          
ATOM   1315  CD  GLU   165     -15.002  42.330  57.318  1.00 35.55          
ATOM   1316  OE1 GLU   165     -13.816  42.703  57.474  1.00 38.37          
ATOM   1317  OE2 GLU   165     -15.900  42.525  58.170  1.00 38.76          
ATOM   1318  C   GLU   165     -14.124  41.893  52.407  1.00 27.22          
ATOM   1319  O   GLU   165     -14.461  42.850  51.700  1.00 27.47          
ATOM   1320  N   GLY   166     -13.000  41.204  52.224  1.00 28.61          
ATOM   1321  CA  GLY   166     -12.087  41.536  51.144  1.00 26.26          
ATOM   1322  C   GLY   166     -12.767  41.300  49.807  1.00 25.80          
ATOM   1323  O   GLY   166     -12.592  42.077  48.865  1.00 25.53          
ATOM   1324  N   ALA   167     -13.560  40.230  49.729  1.00 24.96          
ATOM   1325  CA  ALA   167     -14.288  39.876  48.514  1.00 24.41          
ATOM   1326  CB  ALA   167     -14.900  38.477  48.656  1.00 23.92          
ATOM   1327  C   ALA   167     -15.387  40.897  48.207  1.00 25.29          
ATOM   1328  O   ALA   167     -15.723  41.118  47.056  1.00 26.94          
ATOM   1329  N   GLU   168     -15.961  41.492  49.246  1.00 25.80          
ATOM   1330  CA  GLU   168     -16.995  42.501  49.072  1.00 26.84          
ATOM   1331  CB  GLU   168     -17.607  42.891  50.424  1.00 27.74          
ATOM   1332  CG  GLU   168     -18.508  41.826  51.025  1.00 30.09          
ATOM   1333  CD  GLU   168     -18.925  42.164  52.440  1.00 32.85          
ATOM   1334  OE1 GLU   168     -18.454  43.187  52.982  1.00 32.58          
ATOM   1335  OE2 GLU   168     -19.723  41.400  53.016  1.00 34.25          
ATOM   1336  C   GLU   168     -16.377  43.739  48.447  1.00 26.11          
ATOM   1337  O   GLU   168     -16.970  44.370  47.581  1.00 27.62          
ATOM   1338  N   CYS   169     -15.176  44.076  48.895  1.00 25.36          
ATOM   1339  CA  CYS   169     -14.492  45.257  48.395  1.00 25.51          
ATOM   1340  CB  CYS   169     -13.317  45.580  49.314  1.00 26.47          
ATOM   1341  SG  CYS   169     -13.873  45.951  50.998  1.00 29.13          
ATOM   1342  C   CYS   169     -14.036  45.084  46.945  1.00 27.43          
ATOM   1343  O   CYS   169     -14.202  45.979  46.115  1.00 26.93          
ATOM   1344  N   ILE   170     -13.472  43.922  46.641  1.00 28.32          
ATOM   1345  CA  ILE   170     -13.031  43.637  45.286  1.00 28.24          
ATOM   1346  CB  ILE   170     -12.321  42.273  45.218  1.00 27.26          
ATOM   1347  CG2 ILE   170     -12.205  41.807  43.770  1.00 22.52          
ATOM   1348  CG1 ILE   170     -10.954  42.400  45.889  1.00 27.47          
ATOM   1349  CD  ILE   170     -10.271  41.078  46.166  1.00 31.01          
ATOM   1350  C   ILE   170     -14.223  43.643  44.335  1.00 28.14          
ATOM   1351  O   ILE   170     -14.156  44.220  43.254  1.00 28.90          
ATOM   1352  N   TYR   171     -15.322  43.009  44.729  1.00 26.16          
ATOM   1353  CA  TYR   171     -16.484  42.986  43.855  1.00 27.19          
ATOM   1354  CB  TYR   171     -17.606  42.145  44.464  1.00 27.05          
ATOM   1355  CG  TYR   171     -18.846  42.131  43.607  1.00 28.28          
ATOM   1356  CD1 TYR   171     -18.890  41.394  42.423  1.00 28.11          
ATOM   1357  CE1 TYR   171     -20.004  41.442  41.582  1.00 30.14          
ATOM   1358  CD2 TYR   171     -19.950  42.915  43.935  1.00 29.55          
ATOM   1359  CE2 TYR   171     -21.075  42.976  43.098  1.00 29.92          
ATOM   1360  CZ  TYR   171     -21.093  42.238  41.926  1.00 31.21          
ATOM   1361  OH  TYR   171     -22.187  42.307  41.093  1.00 31.95          
ATOM   1362  C   TYR   171     -16.993  44.418  43.585  1.00 28.05          
ATOM   1363  O   TYR   171     -17.315  44.776  42.452  1.00 28.96          
ATOM   1364  N   THR   172     -17.049  45.235  44.634  1.00 28.13          
ATOM   1365  CA  THR   172     -17.529  46.603  44.502  1.00 27.14          
ATOM   1366  CB  THR   172     -17.411  47.356  45.842  1.00 28.33          
ATOM   1367  OG1 THR   172     -18.253  46.721  46.807  1.00 30.25          
ATOM   1368  CG2 THR   172     -17.837  48.821  45.695  1.00 26.97          
ATOM   1369  C   THR   172     -16.772  47.361  43.417  1.00 26.85          
ATOM   1370  O   THR   172     -17.376  48.080  42.635  1.00 27.08          
ATOM   1371  N   GLY   173     -15.455  47.192  43.364  1.00 25.96          
ATOM   1372  CA  GLY   173     -14.666  47.889  42.367  1.00 24.87          
ATOM   1373  C   GLY   173     -14.959  47.406  40.959  1.00 26.12          
ATOM   1374  O   GLY   173     -15.051  48.202  40.022  1.00 27.09          
ATOM   1375  N   MET   174     -15.098  46.094  40.806  1.00 27.58          
ATOM   1376  CA  MET   174     -15.383  45.504  39.503  1.00 27.65          
ATOM   1377  CB  MET   174     -15.342  43.969  39.594  1.00 27.61          
ATOM   1378  CG  MET   174     -13.952  43.399  39.876  1.00 28.52          
ATOM   1379  SD  MET   174     -13.891  41.464  40.113  0.87 36.46          
ATOM   1380  CE  MET   174     -14.392  40.953  38.311  1.00 28.76          
ATOM   1381  C   MET   174     -16.757  45.968  39.022  1.00 27.10          
ATOM   1382  O   MET   174     -16.931  46.299  37.855  1.00 27.31          
ATOM   1383  N   MET   175     -17.726  45.994  39.929  1.00 27.16          
ATOM   1384  CA  MET   175     -19.086  46.420  39.585  1.00 30.18          
ATOM   1385  CB  MET   175     -20.014  46.220  40.782  1.00 28.11          
ATOM   1386  CG  MET   175     -21.393  46.839  40.626  1.00 31.10          
ATOM   1387  SD  MET   175     -22.425  46.704  42.265  0.83 38.55          
ATOM   1388  CE  MET   175     -23.410  45.066  41.844  1.00 40.78          
ATOM   1389  C   MET   175     -19.109  47.895  39.177  1.00 30.51          
ATOM   1390  O   MET   175     -19.649  48.281  38.150  1.00 33.21          
ATOM   1391  N   THR   176     -18.510  48.704  40.019  1.00 32.00          
ATOM   1392  CA  THR   176     -18.430  50.129  39.830  1.00 33.48          
ATOM   1393  CB  THR   176     -17.776  50.728  41.090  1.00 32.77          
ATOM   1394  OG1 THR   176     -18.811  51.272  41.921  1.00 36.49          
ATOM   1395  CG2 THR   176     -16.748  51.748  40.757  1.00 37.91          
ATOM   1396  C   THR   176     -17.718  50.574  38.543  1.00 33.25          
ATOM   1397  O   THR   176     -18.233  51.412  37.806  1.00 33.46          
ATOM   1398  N   ASP   177     -16.557  50.004  38.247  1.00 31.93          
ATOM   1399  CA  ASP   177     -15.846  50.430  37.046  1.00 31.98          
ATOM   1400  CB  ASP   177     -14.377  50.031  37.110  1.00 31.15          
ATOM   1401  CG  ASP   177     -13.464  51.177  36.738  1.00 33.75          
ATOM   1402  OD1 ASP   177     -13.397  52.134  37.529  1.00 33.92          
ATOM   1403  OD2 ASP   177     -12.833  51.144  35.651  1.00 34.05          
ATOM   1404  C   ASP   177     -16.448  49.968  35.721  1.00 29.47          
ATOM   1405  O   ASP   177     -16.066  50.476  34.679  1.00 30.03          
ATOM   1406  N   THR   178     -17.372  49.010  35.756  1.00 26.64          
ATOM   1407  CA  THR   178     -18.030  48.541  34.536  1.00 24.46          
ATOM   1408  CB  THR   178     -18.048  47.008  34.432  1.00 23.17          
ATOM   1409  OG1 THR   178     -18.662  46.475  35.612  1.00 21.83          
ATOM   1410  CG2 THR   178     -16.635  46.446  34.254  1.00 18.25          
ATOM   1411  C   THR   178     -19.501  48.977  34.502  1.00 24.93          
ATOM   1412  O   THR   178     -20.288  48.424  33.734  1.00 25.61          
ATOM   1413  N   GLY   179     -19.875  49.934  35.349  1.00 24.84          
ATOM   1414  CA  GLY   179     -21.257  50.396  35.389  1.00 26.11          
ATOM   1415  C   GLY   179     -22.224  49.264  35.699  1.00 27.41          
ATOM   1416  O   GLY   179     -23.289  49.140  35.078  1.00 26.05          
ATOM   1417  N   GLY   180     -21.856  48.429  36.662  1.00 26.42          
ATOM   1418  CA  GLY   180     -22.707  47.314  37.010  1.00 26.63          
ATOM   1419  C   GLY   180     -22.670  46.251  35.925  1.00 28.01          
ATOM   1420  O   GLY   180     -23.692  45.625  35.644  1.00 30.69          
ATOM   1421  N   PHE   181     -21.495  46.047  35.319  1.00 28.77          
ATOM   1422  CA  PHE   181     -21.293  45.052  34.252  1.00 29.65          
ATOM   1423  CB  PHE   181     -21.443  43.642  34.827  1.00 27.89          
ATOM   1424  CG  PHE   181     -20.507  43.372  35.967  1.00 29.12          
ATOM   1425  CD1 PHE   181     -19.146  43.153  35.731  1.00 25.36          
ATOM   1426  CD2 PHE   181     -20.962  43.430  37.282  1.00 26.39          
ATOM   1427  CE1 PHE   181     -18.253  43.005  36.787  1.00 23.94          
ATOM   1428  CE2 PHE   181     -20.080  43.288  38.345  1.00 28.32          
ATOM   1429  CZ  PHE   181     -18.714  43.074  38.098  1.00 25.88          
ATOM   1430  C   PHE   181     -22.206  45.247  33.036  1.00 30.64          
ATOM   1431  O   PHE   181     -22.848  44.304  32.527  1.00 29.85          
ATOM   1432  N   THR   182     -22.248  46.489  32.570  1.00 31.07          
ATOM   1433  CA  THR   182     -23.039  46.853  31.406  1.00 33.07          
ATOM   1434  CB  THR   182     -24.131  47.888  31.769  1.00 34.08          
ATOM   1435  OG1 THR   182     -23.523  49.080  32.291  1.00 30.35          
ATOM   1436  CG2 THR   182     -25.080  47.303  32.802  1.00 31.13          
ATOM   1437  C   THR   182     -22.115  47.461  30.361  1.00 35.11          
ATOM   1438  O   THR   182     -22.507  47.655  29.216  1.00 37.32          
ATOM   1439  N   TYR   183     -20.879  47.741  30.765  1.00 35.90          
ATOM   1440  CA  TYR   183     -19.895  48.352  29.892  1.00 37.98          
ATOM   1441  CB  TYR   183     -19.914  49.875  30.154  1.00 42.87          
ATOM   1442  CG  TYR   183     -18.571  50.572  30.134  1.00 47.63          
ATOM   1443  CD1 TYR   183     -17.841  50.775  31.311  1.00 49.33          
ATOM   1444  CE1 TYR   183     -16.578  51.395  31.283  1.00 52.30          
ATOM   1445  CD2 TYR   183     -18.014  51.007  28.928  1.00 52.35          
ATOM   1446  CE2 TYR   183     -16.757  51.628  28.882  1.00 55.10          
ATOM   1447  CZ  TYR   183     -16.043  51.818  30.058  1.00 54.65          
ATOM   1448  OH  TYR   183     -14.802  52.423  29.982  1.00 54.09          
ATOM   1449  C   TYR   183     -18.481  47.748  30.070  1.00 37.87          
ATOM   1450  O   TYR   183     -17.998  47.598  31.190  1.00 38.40          
ATOM   1451  N   ASN   184     -17.842  47.382  28.955  1.00 37.08          
ATOM   1452  CA  ASN   184     -16.487  46.817  28.957  1.00 36.25          
ATOM   1453  CB  ASN   184     -15.495  47.883  29.460  1.00 38.50          
ATOM   1454  CG  ASN   184     -14.037  47.491  29.250  1.00 41.70          
ATOM   1455  OD1 ASN   184     -13.691  46.814  28.275  1.00 43.17          
ATOM   1456  ND2 ASN   184     -13.166  47.939  30.158  1.00 43.13          
ATOM   1457  C   ASN   184     -16.401  45.554  29.818  1.00 35.55          
ATOM   1458  O   ASN   184     -15.401  45.307  30.484  1.00 33.07          
ATOM   1459  N   SER   185     -17.458  44.749  29.788  1.00 34.76          
ATOM   1460  CA  SER   185     -17.501  43.536  30.595  1.00 35.27          
ATOM   1461  CB  SER   185     -18.621  43.645  31.644  1.00 33.75          
ATOM   1462  OG  SER   185     -19.916  43.519  31.052  1.00 33.36          
ATOM   1463  C   SER   185     -17.702  42.257  29.792  1.00 34.83          
ATOM   1464  O   SER   185     -18.153  41.259  30.336  1.00 35.65          
ATOM   1465  N   ASN   186     -17.374  42.272  28.506  1.00 36.30          
ATOM   1466  CA  ASN   186     -17.548  41.069  27.683  1.00 37.20          
ATOM   1467  CB  ASN   186     -17.388  41.392  26.202  1.00 38.02          
ATOM   1468  CG  ASN   186     -18.690  41.774  25.562  1.00 41.93          
ATOM   1469  OD1 ASN   186     -19.718  41.129  25.799  1.00 44.55          
ATOM   1470  ND2 ASN   186     -18.666  42.824  24.742  1.00 42.63          
ATOM   1471  C   ASN   186     -16.648  39.885  27.991  1.00 35.72          
ATOM   1472  O   ASN   186     -16.934  38.777  27.567  1.00 37.06          
ATOM   1473  N   ASN   187     -15.564  40.113  28.719  1.00 35.37          
ATOM   1474  CA  ASN   187     -14.627  39.044  29.038  1.00 34.61          
ATOM   1475  CB  ASN   187     -13.366  39.654  29.644  1.00 34.20          
ATOM   1476  CG  ASN   187     -12.228  38.658  29.740  1.00 36.08          
ATOM   1477  OD1 ASN   187     -12.274  37.731  30.533  1.00 38.86          
ATOM   1478  ND2 ASN   187     -11.206  38.844  28.921  1.00 37.91          
ATOM   1479  C   ASN   187     -15.197  37.946  29.957  1.00 35.01          
ATOM   1480  O   ASN   187     -15.663  38.208  31.066  1.00 33.39          
ATOM   1481  N   ARG   188     -15.149  36.712  29.472  1.00 34.87          
ATOM   1482  CA  ARG   188     -15.638  35.546  30.203  1.00 36.55          
ATOM   1483  CB  ARG   188     -15.330  34.269  29.414  1.00 38.74          
ATOM   1484  CG  ARG   188     -15.954  34.198  28.038  1.00 45.42          
ATOM   1485  CD  ARG   188     -15.510  32.933  27.320  1.00 49.93          
ATOM   1486  NE  ARG   188     -15.802  31.738  28.105  1.00 54.73          
ATOM   1487  CZ  ARG   188     -15.416  30.509  27.772  1.00 57.44          
ATOM   1488  NH1 ARG   188     -14.716  30.308  26.659  1.00 58.34          
ATOM   1489  NH2 ARG   188     -15.723  29.481  28.556  1.00 57.11          
ATOM   1490  C   ARG   188     -15.054  35.364  31.605  1.00 35.34          
ATOM   1491  O   ARG   188     -15.734  34.903  32.512  1.00 33.02          
ATOM   1492  N   GLU   189     -13.784  35.703  31.772  1.00 35.80          
ATOM   1493  CA  GLU   189     -13.125  35.508  33.051  1.00 35.79          
ATOM   1494  CB  GLU   189     -11.612  35.645  32.878  1.00 39.48          
ATOM   1495  CG  GLU   189     -10.986  34.462  32.118  1.00 44.18          
ATOM   1496  CD  GLU   189      -9.510  34.662  31.809  1.00 47.71          
ATOM   1497  OE1 GLU   189      -8.712  34.797  32.753  1.00 46.93          
ATOM   1498  OE2 GLU   189      -9.143  34.690  30.615  1.00 52.27          
ATOM   1499  C   GLU   189     -13.630  36.399  34.175  1.00 36.30          
ATOM   1500  O   GLU   189     -13.349  36.140  35.343  1.00 35.97          
ATOM   1501  N   ILE   190     -14.375  37.445  33.824  1.00 34.55          
ATOM   1502  CA  ILE   190     -14.937  38.334  34.827  1.00 32.00          
ATOM   1503  CB  ILE   190     -15.669  39.531  34.177  1.00 32.80          
ATOM   1504  CG2 ILE   190     -16.560  40.208  35.197  1.00 31.52          
ATOM   1505  CG1 ILE   190     -14.664  40.529  33.596  1.00 32.56          
ATOM   1506  CD  ILE   190     -15.342  41.696  32.831  1.00 25.42          
ATOM   1507  C   ILE   190     -15.967  37.564  35.666  1.00 32.30          
ATOM   1508  O   ILE   190     -16.000  37.687  36.890  1.00 32.46          
ATOM   1509  N   TYR   191     -16.795  36.768  34.985  1.00 30.94          
ATOM   1510  CA  TYR   191     -17.864  35.990  35.613  1.00 29.63          
ATOM   1511  CB  TYR   191     -18.895  35.620  34.533  1.00 26.56          
ATOM   1512  CG  TYR   191     -19.298  36.888  33.823  1.00 27.05          
ATOM   1513  CD1 TYR   191     -20.177  37.793  34.433  1.00 27.31          
ATOM   1514  CE1 TYR   191     -20.371  39.079  33.918  1.00 27.13          
ATOM   1515  CD2 TYR   191     -18.638  37.298  32.660  1.00 26.65          
ATOM   1516  CE2 TYR   191     -18.820  38.585  32.134  1.00 28.47          
ATOM   1517  CZ  TYR   191     -19.682  39.471  32.776  1.00 29.42          
ATOM   1518  OH  TYR   191     -19.800  40.766  32.332  1.00 29.95          
ATOM   1519  C   TYR   191     -17.381  34.787  36.408  1.00 29.74          
ATOM   1520  O   TYR   191     -18.028  34.360  37.363  1.00 30.86          
ATOM   1521  N   PHE   192     -16.241  34.237  36.039  1.00 30.44          
ATOM   1522  CA  PHE   192     -15.713  33.143  36.826  1.00 29.53          
ATOM   1523  CB  PHE   192     -14.515  32.504  36.128  1.00 32.28          
ATOM   1524  CG  PHE   192     -13.824  31.453  36.960  1.00 35.87          
ATOM   1525  CD1 PHE   192     -14.430  30.219  37.193  1.00 34.97          
ATOM   1526  CD2 PHE   192     -12.575  31.710  37.532  1.00 35.73          
ATOM   1527  CE1 PHE   192     -13.802  29.250  37.987  1.00 37.32          
ATOM   1528  CE2 PHE   192     -11.939  30.750  38.326  1.00 37.87          
ATOM   1529  CZ  PHE   192     -12.554  29.518  38.553  1.00 38.02          
ATOM   1530  C   PHE   192     -15.256  33.796  38.140  1.00 29.35          
ATOM   1531  O   PHE   192     -15.447  33.250  39.219  1.00 30.15          
ATOM   1532  N   ILE   193     -14.664  34.985  38.043  1.00 29.06          
ATOM   1533  CA  ILE   193     -14.186  35.690  39.233  1.00 27.57          
ATOM   1534  CB  ILE   193     -13.341  36.930  38.824  1.00 28.35          
ATOM   1535  CG2 ILE   193     -13.057  37.831  40.042  1.00 25.51          
ATOM   1536  CG1 ILE   193     -12.017  36.454  38.190  1.00 24.46          
ATOM   1537  CD  ILE   193     -11.033  37.591  37.864  1.00 24.39          
ATOM   1538  C   ILE   193     -15.370  36.073  40.134  1.00 29.26          
ATOM   1539  O   ILE   193     -15.314  35.917  41.359  1.00 28.70          
ATOM   1540  N   ILE   194     -16.462  36.533  39.528  1.00 28.48          
ATOM   1541  CA  ILE   194     -17.628  36.889  40.314  1.00 27.23          
ATOM   1542  CB  ILE   194     -18.772  37.398  39.425  1.00 26.40          
ATOM   1543  CG2 ILE   194     -20.101  37.392  40.220  1.00 21.87          
ATOM   1544  CG1 ILE   194     -18.430  38.805  38.916  1.00 23.24          
ATOM   1545  CD  ILE   194     -19.428  39.353  37.895  1.00 25.70          
ATOM   1546  C   ILE   194     -18.087  35.643  41.062  1.00 28.71          
ATOM   1547  O   ILE   194     -18.419  35.695  42.244  1.00 28.58          
ATOM   1548  N   SER   195     -18.090  34.514  40.367  1.00 30.04          
ATOM   1549  CA  SER   195     -18.498  33.265  40.986  1.00 31.00          
ATOM   1550  CB  SER   195     -18.465  32.133  39.957  1.00 31.22          
ATOM   1551  OG  SER   195     -18.849  30.911  40.554  1.00 36.50          
ATOM   1552  C   SER   195     -17.588  32.934  42.169  1.00 31.24          
ATOM   1553  O   SER   195     -18.059  32.481  43.202  1.00 33.18          
ATOM   1554  N   GLU   196     -16.290  33.176  42.024  1.00 32.73          
ATOM   1555  CA  GLU   196     -15.332  32.901  43.092  1.00 33.94          
ATOM   1556  CB  GLU   196     -13.899  33.138  42.598  1.00 37.81          
ATOM   1557  CG  GLU   196     -13.478  32.233  41.461  1.00 41.38          
ATOM   1558  CD  GLU   196     -13.333  30.800  41.908  1.00 46.25          
ATOM   1559  OE1 GLU   196     -12.191  30.374  42.206  1.00 47.63          
ATOM   1560  OE2 GLU   196     -14.370  30.102  41.974  1.00 48.65          
ATOM   1561  C   GLU   196     -15.575  33.776  44.315  1.00 34.01          
ATOM   1562  O   GLU   196     -15.429  33.329  45.457  1.00 35.27          
ATOM   1563  N   LEU   197     -15.923  35.037  44.067  1.00 33.36          
ATOM   1564  CA  LEU   197     -16.183  35.990  45.140  1.00 29.03          
ATOM   1565  CB  LEU   197     -16.305  37.409  44.569  1.00 26.66          
ATOM   1566  CG  LEU   197     -15.010  37.970  43.958  1.00 25.48          
ATOM   1567  CD1 LEU   197     -15.297  39.260  43.196  1.00 24.52          
ATOM   1568  CD2 LEU   197     -13.989  38.207  45.062  1.00 24.18          
ATOM   1569  C   LEU   197     -17.455  35.606  45.885  1.00 29.57          
ATOM   1570  O   LEU   197     -17.521  35.727  47.109  1.00 29.13          
ATOM   1571  N   LEU   198     -18.458  35.136  45.145  1.00 30.03          
ATOM   1572  CA  LEU   198     -19.731  34.732  45.742  1.00 30.25          
ATOM   1573  CB  LEU   198     -20.751  34.383  44.657  1.00 28.58          
ATOM   1574  CG  LEU   198     -21.483  35.533  43.969  1.00 26.47          
ATOM   1575  CD1 LEU   198     -22.244  35.020  42.771  1.00 24.74          
ATOM   1576  CD2 LEU   198     -22.454  36.163  44.962  1.00 27.49          
ATOM   1577  C   LEU   198     -19.519  33.523  46.640  1.00 32.45          
ATOM   1578  O   LEU   198     -20.229  33.340  47.626  1.00 33.99          
ATOM   1579  N   SER   199     -18.534  32.701  46.304  1.00 33.73          
ATOM   1580  CA  SER   199     -18.258  31.522  47.107  1.00 35.25          
ATOM   1581  CB  SER   199     -17.304  30.562  46.371  1.00 35.31          
ATOM   1582  OG  SER   199     -15.969  31.059  46.332  1.00 38.05          
ATOM   1583  C   SER   199     -17.644  31.967  48.433  1.00 35.09          
ATOM   1584  O   SER   199     -17.490  31.162  49.342  1.00 36.33          
ATOM   1585  N   LYS   200     -17.299  33.250  48.540  1.00 34.71          
ATOM   1586  CA  LYS   200     -16.721  33.773  49.777  1.00 33.11          
ATOM   1587  CB  LYS   200     -15.753  34.915  49.497  1.00 35.23          
ATOM   1588  CG  LYS   200     -14.544  34.547  48.648  1.00 38.23          
ATOM   1589  CD  LYS   200     -13.511  33.766  49.427  1.00 41.15          
ATOM   1590  CE  LYS   200     -12.282  33.501  48.555  1.00 44.94          
ATOM   1591  NZ  LYS   200     -11.180  32.833  49.304  1.00 44.66          
ATOM   1592  C   LYS   200     -17.829  34.280  50.682  1.00 32.44          
ATOM   1593  O   LYS   200     -17.567  34.797  51.759  1.00 31.53          
ATOM   1594  N   GLY   201     -19.074  34.144  50.235  1.00 32.78          
ATOM   1595  CA  GLY   201     -20.194  34.576  51.054  1.00 30.44          
ATOM   1596  C   GLY   201     -20.776  35.958  50.817  1.00 30.41          
ATOM   1597  O   GLY   201     -21.658  36.380  51.563  1.00 28.74          
ATOM   1598  N   ILE   202     -20.328  36.670  49.787  1.00 30.88          
ATOM   1599  CA  ILE   202     -20.868  38.005  49.580  1.00 33.35          
ATOM   1600  CB  ILE   202     -19.982  38.881  48.655  1.00 33.04          
ATOM   1601  CG2 ILE   202     -18.533  38.814  49.094  1.00 32.09          
ATOM   1602  CG1 ILE   202     -20.149  38.447  47.202  1.00 34.24          
ATOM   1603  CD  ILE   202     -19.512  39.400  46.218  1.00 33.20          
ATOM   1604  C   ILE   202     -22.268  37.994  48.996  1.00 33.81          
ATOM   1605  O   ILE   202     -22.719  37.005  48.419  1.00 35.35          
ATOM   1606  N   ASP   203     -22.958  39.112  49.171  1.00 34.27          
ATOM   1607  CA  ASP   203     -24.295  39.273  48.639  1.00 31.99          
ATOM   1608  CB  ASP   203     -25.275  39.696  49.741  1.00 34.30          
ATOM   1609  CG  ASP   203     -26.706  39.772  49.240  1.00 35.91          
ATOM   1610  OD1 ASP   203     -26.896  39.860  48.006  1.00 36.40          
ATOM   1611  OD2 ASP   203     -27.642  39.749  50.068  1.00 36.83          
ATOM   1612  C   ASP   203     -24.143  40.389  47.623  1.00 30.24          
ATOM   1613  O   ASP   203     -24.156  41.560  47.985  1.00 30.86          
ATOM   1614  N   LYS   204     -24.003  40.034  46.351  1.00 28.91          
ATOM   1615  CA  LYS   204     -23.811  41.050  45.320  1.00 27.49          
ATOM   1616  CB  LYS   204     -23.404  40.402  43.984  1.00 25.75          
ATOM   1617  CG  LYS   204     -24.430  39.462  43.377  1.00 22.65          
ATOM   1618  CD  LYS   204     -23.849  38.694  42.178  1.00 26.13          
ATOM   1619  CE  LYS   204     -23.612  39.601  40.962  1.00 22.67          
ATOM   1620  NZ  LYS   204     -24.878  40.119  40.351  1.00 26.05          
ATOM   1621  C   LYS   204     -25.006  41.957  45.105  1.00 27.76          
ATOM   1622  O   LYS   204     -24.846  43.101  44.703  1.00 28.21          
ATOM   1623  N   ASP   205     -26.205  41.444  45.346  1.00 28.58          
ATOM   1624  CA  ASP   205     -27.393  42.256  45.160  1.00 29.45          
ATOM   1625  CB  ASP   205     -28.650  41.371  45.206  1.00 29.61          
ATOM   1626  CG  ASP   205     -28.794  40.500  43.945  1.00 32.48          
ATOM   1627  OD1 ASP   205     -28.212  40.883  42.897  1.00 31.51          
ATOM   1628  OD2 ASP   205     -29.494  39.448  43.988  1.00 26.53          
ATOM   1629  C   ASP   205     -27.426  43.349  46.228  1.00 31.45          
ATOM   1630  O   ASP   205     -27.769  44.497  45.942  1.00 32.07          
ATOM   1631  N   ASP   206     -27.036  43.001  47.451  1.00 32.36          
ATOM   1632  CA  ASP   206     -27.014  43.977  48.540  1.00 33.45          
ATOM   1633  CB  ASP   206     -26.750  43.286  49.882  1.00 34.82          
ATOM   1634  CG  ASP   206     -26.917  44.229  51.061  1.00 36.95          
ATOM   1635  OD1 ASP   206     -28.046  44.723  51.272  1.00 38.08          
ATOM   1636  OD2 ASP   206     -25.919  44.489  51.773  1.00 41.70          
ATOM   1637  C   ASP   206     -25.953  45.051  48.303  1.00 32.60          
ATOM   1638  O   ASP   206     -26.156  46.217  48.659  1.00 33.43          
ATOM   1639  N   ILE   207     -24.819  44.652  47.720  1.00 30.96          
ATOM   1640  CA  ILE   207     -23.720  45.579  47.427  1.00 28.75          
ATOM   1641  CB  ILE   207     -22.479  44.835  46.878  1.00 27.95          
ATOM   1642  CG2 ILE   207     -21.490  45.828  46.254  1.00 22.28          
ATOM   1643  CG1 ILE   207     -21.812  44.050  48.007  1.00 28.52          
ATOM   1644  CD  ILE   207     -20.519  43.372  47.593  1.00 31.28          
ATOM   1645  C   ILE   207     -24.195  46.584  46.391  1.00 29.34          
ATOM   1646  O   ILE   207     -23.880  47.773  46.464  1.00 27.18          
ATOM   1647  N   TYR   208     -24.954  46.089  45.420  1.00 30.26          
ATOM   1648  CA  TYR   208     -25.519  46.936  44.387  1.00 30.72          
ATOM   1649  CB  TYR   208     -26.386  46.118  43.435  1.00 31.93          
ATOM   1650  CG  TYR   208     -27.042  46.988  42.399  1.00 34.80          
ATOM   1651  CD1 TYR   208     -26.315  47.451  41.314  1.00 37.17          
ATOM   1652  CE1 TYR   208     -26.872  48.319  40.394  1.00 40.08          
ATOM   1653  CD2 TYR   208     -28.367  47.417  42.541  1.00 37.07          
ATOM   1654  CE2 TYR   208     -28.936  48.296  41.619  1.00 38.96          
ATOM   1655  CZ  TYR   208     -28.171  48.740  40.549  1.00 40.83          
ATOM   1656  OH  TYR   208     -28.668  49.624  39.616  1.00 47.44          
ATOM   1657  C   TYR   208     -26.406  48.014  45.017  1.00 30.74          
ATOM   1658  O   TYR   208     -26.286  49.203  44.693  1.00 32.39          
ATOM   1659  N   ARG   209     -27.309  47.587  45.896  1.00 29.59          
ATOM   1660  CA  ARG   209     -28.236  48.504  46.564  1.00 31.14          
ATOM   1661  CB  ARG   209     -29.246  47.731  47.429  1.00 28.96          
ATOM   1662  CG  ARG   209     -30.367  47.085  46.621  1.00 33.30          
ATOM   1663  CD  ARG   209     -31.462  46.536  47.516  1.00 36.06          
ATOM   1664  NE  ARG   209     -31.061  45.298  48.175  1.00 39.96          
ATOM   1665  CZ  ARG   209     -31.199  44.088  47.637  1.00 43.93          
ATOM   1666  NH1 ARG   209     -31.735  43.945  46.428  1.00 45.67          
ATOM   1667  NH2 ARG   209     -30.797  43.021  48.305  1.00 44.04          
ATOM   1668  C   ARG   209     -27.539  49.547  47.422  1.00 30.77          
ATOM   1669  O   ARG   209     -27.923  50.716  47.423  1.00 29.95          
ATOM   1670  N   LYS   210     -26.515  49.118  48.147  1.00 30.75          
ATOM   1671  CA  LYS   210     -25.763  50.005  49.018  1.00 30.54          
ATOM   1672  CB  LYS   210     -24.758  49.188  49.828  1.00 29.89          
ATOM   1673  CG  LYS   210     -25.389  48.417  50.984  1.00 31.07          
ATOM   1674  CD  LYS   210     -24.370  47.517  51.675  1.00 32.60          
ATOM   1675  CE  LYS   210     -24.546  47.541  53.172  1.00 33.06          
ATOM   1676  NZ  LYS   210     -25.961  47.315  53.527  1.00 36.41          
ATOM   1677  C   LYS   210     -25.044  51.128  48.272  1.00 31.25          
ATOM   1678  O   LYS   210     -24.890  52.227  48.793  1.00 34.02          
ATOM   1679  N   VAL   211     -24.620  50.851  47.046  1.00 30.57          
ATOM   1680  CA  VAL   211     -23.904  51.831  46.237  1.00 28.27          
ATOM   1681  CB  VAL   211     -22.827  51.126  45.350  1.00 25.73          
ATOM   1682  CG1 VAL   211     -22.190  52.110  44.376  1.00 19.95          
ATOM   1683  CG2 VAL   211     -21.768  50.494  46.225  1.00 20.49          
ATOM   1684  C   VAL   211     -24.812  52.672  45.331  1.00 32.06          
ATOM   1685  O   VAL   211     -24.604  53.885  45.189  1.00 32.03          
ATOM   1686  N   TYR   212     -25.823  52.041  44.736  1.00 31.92          
ATOM   1687  CA  TYR   212     -26.695  52.741  43.803  1.00 35.21          
ATOM   1688  CB  TYR   212     -26.794  51.937  42.511  1.00 33.86          
ATOM   1689  CG  TYR   212     -25.463  51.714  41.830  1.00 34.74          
ATOM   1690  CD1 TYR   212     -24.796  52.768  41.195  1.00 32.46          
ATOM   1691  CE1 TYR   212     -23.588  52.558  40.540  1.00 31.55          
ATOM   1692  CD2 TYR   212     -24.879  50.441  41.799  1.00 31.42          
ATOM   1693  CE2 TYR   212     -23.675  50.216  41.147  1.00 31.04          
ATOM   1694  CZ  TYR   212     -23.041  51.275  40.516  1.00 34.10          
ATOM   1695  OH  TYR   212     -21.899  51.045  39.806  1.00 36.56          
ATOM   1696  C   TYR   212     -28.105  53.114  44.249  1.00 38.85          
ATOM   1697  O   TYR   212     -28.734  53.988  43.636  1.00 38.01          
ATOM   1698  N   ASN   213     -28.610  52.464  45.292  1.00 41.30          
ATOM   1699  CA  ASN   213     -29.955  52.753  45.774  1.00 43.85          
ATOM   1700  CB  ASN   213     -30.769  51.470  45.817  1.00 44.64          
ATOM   1701  CG  ASN   213     -30.914  50.837  44.451  1.00 48.21          
ATOM   1702  OD1 ASN   213     -31.324  49.688  44.336  1.00 52.04          
ATOM   1703  ND2 ASN   213     -30.588  51.592  43.403  1.00 48.25          
ATOM   1704  C   ASN   213     -29.924  53.384  47.148  1.00 46.10          
ATOM   1705  O   ASN   213     -30.675  53.000  48.044  1.00 46.55          
ATOM   1706  N   THR   214     -29.049  54.363  47.314  1.00 49.38          
ATOM   1707  CA  THR   214     -28.932  55.026  48.593  1.00 54.47          
ATOM   1708  CB  THR   214     -27.792  54.426  49.444  1.00 56.19          
ATOM   1709  OG1 THR   214     -26.595  54.361  48.659  1.00 56.02          
ATOM   1710  CG2 THR   214     -28.177  53.026  49.962  1.00 56.49          
ATOM   1711  C   THR   214     -28.688  56.507  48.463  1.00 57.84          
ATOM   1712  O   THR   214     -27.545  56.967  48.483  1.00 59.27          
END
