
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 ( 1846),  selected  119 , name 2gsb_A
# Molecule2: number of CA atoms  126 ( 1003),  selected  126 , name T0501_215_342.pdb
# PARAMETERS: 2gsb_A.T0501_215_342.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      Y     215           -
LGA    S     2_A      S     216           -
LGA    S     3_A      E     217           -
LGA    G     4_A      S     218           -
LGA    S     5_A      R     219           -
LGA    S     6_A      L     220           -
LGA    G     7_A      R     221           -
LGA    R     8_A      L     222           -
LGA    E     9_A      M     223           -
LGA    E    10_A      G     224           -
LGA    D    11_A      Y     225           -
LGA    P    12_A      -       -           -
LGA    H    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    G    15_A      V     226           #
LGA    K    16_A      L     227           -
LGA    -       -      S     228           -
LGA    I    17_A      N     229          2.823
LGA    -       -      M     230           -
LGA    -       -      K     231           -
LGA    -       -      V     232           -
LGA    -       -      Y     233           -
LGA    -       -      K     234           -
LGA    -       -      D     235           -
LGA    -       -      Y     236           -
LGA    -       -      N     237           -
LGA    -       -      S     238           -
LGA    -       -      A     239           -
LGA    -       -      L     240           -
LGA    W    18_A      I     241          2.529
LGA    F    19_A      S     242          1.868
LGA    H    20_A      L     243          1.646
LGA    -       -      T     244           -
LGA    -       -      K     245           -
LGA    -       -      E     246           -
LGA    -       -      E     247           -
LGA    G    21_A      Q     248          2.875
LGA    -       -      G     249           -
LGA    -       -      K     250           -
LGA    K    22_A      F     251          4.060
LGA    -       -      D     252           -
LGA    I    23_A      Y     253          4.946
LGA    S    24_A      I     254          4.857
LGA    K    25_A      K     255          4.668
LGA    Q    26_A      G     256          2.007
LGA    E    27_A      D     257          2.972
LGA    A    28_A      S     258          2.122
LGA    Y    29_A      E     259          2.483
LGA    N    30_A      G     260          1.827
LGA    L    31_A      F     261          1.969
LGA    L    32_A      V     262          2.086
LGA    M    33_A      N     263          2.587
LGA    T    34_A      I     264          3.504
LGA    V    35_A      P     265           #
LGA    G    36_A      L     266          4.599
LGA    Q    37_A      S     267          4.969
LGA    -       -      I     268           -
LGA    -       -      K     269           -
LGA    -       -      N     270           -
LGA    -       -      V     271           -
LGA    V    38_A      C     272          3.538
LGA    C    39_A      F     273          0.612
LGA    S    40_A      S     274          0.920
LGA    F    41_A      C     275          0.675
LGA    L    42_A      F     276          1.171
LGA    V    43_A      L     277          0.670
LGA    R    44_A      R     278          0.539
LGA    P    45_A      E     279          1.352
LGA    S    46_A      D     280          1.444
LGA    D    47_A      -       -           -
LGA    N    48_A      -       -           -
LGA    T    49_A      -       -           -
LGA    P    50_A      T     281          1.465
LGA    G    51_A      E     282          1.388
LGA    D    52_A      M     285          1.246
LGA    Y    53_A      I     286          1.527
LGA    S    54_A      K     287          0.618
LGA    L    55_A      I     288          0.850
LGA    Y    56_A      S     289          0.797
LGA    F    57_A      L     290          0.769
LGA    R    58_A      R     291          0.544
LGA    T    59_A      S     292          2.001
LGA    N    60_A      V     293          3.047
LGA    -       -      G     294           -
LGA    -       -      K     295           -
LGA    -       -      F     296           -
LGA    -       -      P     297           -
LGA    -       -      C     298           -
LGA    -       -      N     299           -
LGA    -       -      R     300           -
LGA    -       -      L     301           -
LGA    -       -      A     302           -
LGA    -       -      A     303           -
LGA    -       -      E     304           -
LGA    -       -      F     305           -
LGA    -       -      F     306           -
LGA    -       -      N     307           -
LGA    -       -      G     308           -
LGA    -       -      G     309           -
LGA    -       -      G     310           -
LGA    -       -      X     311           -
LGA    E    61_A      L     312          4.309
LGA    N    62_A      N     313          3.401
LGA    I    63_A      A     314          2.247
LGA    Q    64_A      S     315          1.099
LGA    R    65_A      G     316          1.006
LGA    F    66_A      G     317          1.123
LGA    K    67_A      E     318          1.102
LGA    I    68_A      F     319          1.074
LGA    C    69_A      Y     320          2.086
LGA    P    70_A      G     321          3.818
LGA    T    71_A      -       -           -
LGA    P    72_A      -       -           -
LGA    N    73_A      -       -           -
LGA    N    74_A      -       -           -
LGA    Q    75_A      -       -           -
LGA    F    76_A      -       -           -
LGA    M    77_A      -       -           -
LGA    M    78_A      -       -           -
LGA    G    79_A      -       -           -
LGA    G    80_A      -       -           -
LGA    R    81_A      -       -           -
LGA    Y    82_A      -       -           -
LGA    Y    83_A      -       -           -
LGA    N    84_A      -       -           -
LGA    S    85_A      T     322          5.243
LGA    I    86_A      M     323          3.824
LGA    -       -      E     324           -
LGA    -       -      E     325           -
LGA    -       -      A     326           -
LGA    G    87_A      V     327          3.012
LGA    D    88_A      K     328          1.480
LGA    I    89_A      V     329          1.251
LGA    I    90_A      F     330          2.196
LGA    D    91_A      E     331          2.220
LGA    H    92_A      Q     332          1.679
LGA    Y    93_A      A     333          2.146
LGA    R    94_A      L     334          2.363
LGA    K    95_A      E     335          0.274
LGA    E    96_A      K     336          1.571
LGA    Q    97_A      Y     337          2.852
LGA    I    98_A      K     338           -
LGA    V    99_A      P     339           -
LGA    E   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    Y   102_A      L     340           #
LGA    Y   103_A      L     341           #
LGA    L   104_A      K     342           -
LGA    K   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    P   107_A      -       -           -
LGA    V   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    M   110_A      -       -           -
LGA    Q   111_A      -       -           -
LGA    D   112_A      -       -           -
LGA    Q   113_A      -       -           -
LGA    S   114_A      -       -           -
LGA    G   115_A      -       -           -
LGA    P   116_A      -       -           -
LGA    S   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    G   119_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119  126    5.0     63    2.54     7.94     36.311     2.383

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.255385 * X  +  -0.042096 * Y  +   0.965922 * Z  + -19.915173
  Y_new =  -0.503678 * X  +  -0.846983 * Y  +  -0.170083 * Z  +  70.951172
  Z_new =   0.825280 * X  +  -0.529951 * Y  +   0.195104 * Z  +  33.733486 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.218040    1.923553  [ DEG:   -69.7885    110.2115 ]
  Theta =  -0.970697   -2.170895  [ DEG:   -55.6169   -124.3831 ]
  Phi   =  -2.040061    1.101532  [ DEG:  -116.8869     63.1131 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gsb_A                                        
REMARK     2: T0501_215_342.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gsb_A.T0501_215_342.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119  126   5.0   63   2.54    7.94  36.311
REMARK  ---------------------------------------------------------- 
MOLECULE 2gsb_A
HEADER    SIGNALING PROTEIN                       26-APR-06   2GSB              
TITLE     SOLUTION STRUCTURE OF THE SECOND SH2 DOMAIN OF HUMAN RAS              
TITLE    2 GTPASE-ACTIVATING PROTEIN 1                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RAS GTPASE-ACTIVATING PROTEIN 1;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH2 DOMAIN;                                                
COMPND   5 SYNONYM: GTPASE-ACTIVATING PROTEIN, GAP, RAS P21 PROTEIN             
COMPND   6 ACTIVATOR, P120GAP, RASGAP;                                          
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: RASA1, RASA;                                                   
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050711-17;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    GTPASE-ACTIVATING PROTEIN, GAP, RAS P21 PROTEIN ACTIVATOR,            
KEYWDS   2 P120GAP, RASGAP, STRUCTURAL GENOMICS, NPPSFA, NATIONAL               
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    C.KUROSAKI,T.SUETAKE,M.YOSHIDA,F.HAYASHI,S.YOKOYMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   01-MAY-07 2GSB    0                                                
JRNL        AUTH   C.KUROSAKI,T.SUETAKE,M.YOSHIDA,F.HAYASHI,S.YOKOYMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE SECOND SH2 DOMAIN OF               
JRNL        TITL 2 HUMAN RAS GTPASE-ACTIVATING PROTEIN 1                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2GSB A    8   113  UNP    P20936   RASA1_HUMAN    341    446             
SEQRES   1 A  119  GLY SER SER GLY SER SER GLY ARG GLU GLU ASP PRO HIS          
SEQRES   2 A  119  GLU GLY LYS ILE TRP PHE HIS GLY LYS ILE SER LYS GLN          
SEQRES   3 A  119  GLU ALA TYR ASN LEU LEU MET THR VAL GLY GLN VAL CYS          
SEQRES   4 A  119  SER PHE LEU VAL ARG PRO SER ASP ASN THR PRO GLY ASP          
SEQRES   5 A  119  TYR SER LEU TYR PHE ARG THR ASN GLU ASN ILE GLN ARG          
SEQRES   6 A  119  PHE LYS ILE CYS PRO THR PRO ASN ASN GLN PHE MET MET          
SEQRES   7 A  119  GLY GLY ARG TYR TYR ASN SER ILE GLY ASP ILE ILE ASP          
SEQRES   8 A  119  HIS TYR ARG LYS GLU GLN ILE VAL GLU GLY TYR TYR LEU          
SEQRES   9 A  119  LYS GLU PRO VAL PRO MET GLN ASP GLN SER GLY PRO SER          
SEQRES  10 A  119  SER GLY                                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -47.313 102.226  45.533  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -47.971 101.048  45.000  1.00  0.00           C  
ATOM      3  C   GLY A   1     -46.986  99.990  44.542  1.00  0.00           C  
ATOM      4  O   GLY A   1     -46.289 100.173  43.544  1.00  0.00           O  
ATOM      5  HA2 GLY A   1     -48.606 100.626  45.765  1.00  0.00           H  
ATOM      6  HA3 GLY A   1     -48.583 101.341  44.159  1.00  0.00           H  
ATOM      7  H1  GLY A   1     -47.560 102.563  46.419  1.00  0.00           H  
ATOM      8  N   SER A   2     -46.927  98.882  45.274  1.00  0.00           N  
ATOM      9  CA  SER A   2     -46.016  97.794  44.940  1.00  0.00           C  
ATOM     10  C   SER A   2     -46.039  97.505  43.443  1.00  0.00           C  
ATOM     11  O   SER A   2     -45.009  97.206  42.840  1.00  0.00           O  
ATOM     12  CB  SER A   2     -46.387  96.532  45.721  1.00  0.00           C  
ATOM     13  OG  SER A   2     -45.778  96.525  47.001  1.00  0.00           O  
ATOM     14  H   SER A   2     -47.508  98.796  46.058  1.00  0.00           H  
ATOM     15  HA  SER A   2     -45.018  98.099  45.221  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -47.459  96.491  45.845  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -46.055  95.662  45.172  1.00  0.00           H  
ATOM     18  HG  SER A   2     -45.888  97.386  47.411  1.00  0.00           H  
ATOM     19  N   SER A   3     -47.224  97.596  42.847  1.00  0.00           N  
ATOM     20  CA  SER A   3     -47.386  97.341  41.421  1.00  0.00           C  
ATOM     21  C   SER A   3     -46.537  96.151  40.983  1.00  0.00           C  
ATOM     22  O   SER A   3     -45.816  96.222  39.988  1.00  0.00           O  
ATOM     23  CB  SER A   3     -47.000  98.581  40.613  1.00  0.00           C  
ATOM     24  OG  SER A   3     -48.068  99.513  40.568  1.00  0.00           O  
ATOM     25  H   SER A   3     -48.010  97.838  43.382  1.00  0.00           H  
ATOM     26  HA  SER A   3     -48.425  97.112  41.240  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -46.145  99.056  41.070  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -46.751  98.287  39.603  1.00  0.00           H  
ATOM     29  HG  SER A   3     -48.841  99.095  40.180  1.00  0.00           H  
ATOM     30  N   GLY A   4     -46.628  95.058  41.735  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -45.864  93.868  41.408  1.00  0.00           C  
ATOM     32  C   GLY A   4     -45.716  92.932  42.592  1.00  0.00           C  
ATOM     33  O   GLY A   4     -46.098  93.272  43.712  1.00  0.00           O  
ATOM     34  H   GLY A   4     -47.220  95.060  42.516  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -46.361  93.342  40.607  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -44.881  94.166  41.075  1.00  0.00           H  
ATOM     37  N   SER A   5     -45.161  91.751  42.344  1.00  0.00           N  
ATOM     38  CA  SER A   5     -44.968  90.761  43.397  1.00  0.00           C  
ATOM     39  C   SER A   5     -43.495  90.650  43.776  1.00  0.00           C  
ATOM     40  O   SER A   5     -42.638  91.297  43.174  1.00  0.00           O  
ATOM     41  CB  SER A   5     -45.495  89.396  42.946  1.00  0.00           C  
ATOM     42  OG  SER A   5     -44.589  88.769  42.055  1.00  0.00           O  
ATOM     43  H   SER A   5     -44.877  91.539  41.430  1.00  0.00           H  
ATOM     44  HA  SER A   5     -45.527  91.084  44.263  1.00  0.00           H  
ATOM     45  HB2 SER A   5     -45.628  88.761  43.809  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -46.442  89.527  42.445  1.00  0.00           H  
ATOM     47  HG  SER A   5     -45.065  88.454  41.283  1.00  0.00           H  
ATOM     48  N   SER A   6     -43.209  89.825  44.779  1.00  0.00           N  
ATOM     49  CA  SER A   6     -41.839  89.632  45.242  1.00  0.00           C  
ATOM     50  C   SER A   6     -41.761  88.480  46.239  1.00  0.00           C  
ATOM     51  O   SER A   6     -42.708  88.218  46.979  1.00  0.00           O  
ATOM     52  CB  SER A   6     -41.310  90.915  45.885  1.00  0.00           C  
ATOM     53  OG  SER A   6     -39.926  90.810  46.169  1.00  0.00           O  
ATOM     54  H   SER A   6     -43.936  89.337  45.218  1.00  0.00           H  
ATOM     55  HA  SER A   6     -41.230  89.392  44.383  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -41.465  91.744  45.211  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -41.842  91.097  46.808  1.00  0.00           H  
ATOM     58  HG  SER A   6     -39.500  90.276  45.494  1.00  0.00           H  
ATOM     59  N   GLY A   7     -40.623  87.793  46.251  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -40.440  86.676  47.160  1.00  0.00           C  
ATOM     61  C   GLY A   7     -40.098  85.389  46.437  1.00  0.00           C  
ATOM     62  O   GLY A   7     -38.950  84.946  46.451  1.00  0.00           O  
ATOM     63  H   GLY A   7     -39.900  88.046  45.639  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -39.641  86.913  47.848  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -41.352  86.529  47.720  1.00  0.00           H  
ATOM     66  N   ARG A   8     -41.098  84.785  45.801  1.00  0.00           N  
ATOM     67  CA  ARG A   8     -40.898  83.539  45.071  1.00  0.00           C  
ATOM     68  C   ARG A   8     -40.815  83.797  43.570  1.00  0.00           C  
ATOM     69  O   ARG A   8     -41.821  84.095  42.926  1.00  0.00           O  
ATOM     70  CB  ARG A   8     -42.035  82.561  45.370  1.00  0.00           C  
ATOM     71  CG  ARG A   8     -43.419  83.172  45.226  1.00  0.00           C  
ATOM     72  CD  ARG A   8     -44.461  82.118  44.884  1.00  0.00           C  
ATOM     73  NE  ARG A   8     -44.695  81.200  45.994  1.00  0.00           N  
ATOM     74  CZ  ARG A   8     -45.502  80.147  45.920  1.00  0.00           C  
ATOM     75  NH1 ARG A   8     -46.147  79.881  44.793  1.00  0.00           N  
ATOM     76  NH2 ARG A   8     -45.663  79.357  46.974  1.00  0.00           N  
ATOM     77  H   ARG A   8     -41.992  85.187  45.827  1.00  0.00           H  
ATOM     78  HA  ARG A   8     -39.966  83.107  45.402  1.00  0.00           H  
ATOM     79  HB2 ARG A   8     -41.963  81.725  44.689  1.00  0.00           H  
ATOM     80  HB3 ARG A   8     -41.928  82.201  46.382  1.00  0.00           H  
ATOM     81  HG2 ARG A   8     -43.692  83.644  46.157  1.00  0.00           H  
ATOM     82  HG3 ARG A   8     -43.396  83.911  44.438  1.00  0.00           H  
ATOM     83  HD2 ARG A   8     -45.388  82.614  44.638  1.00  0.00           H  
ATOM     84  HD3 ARG A   8     -44.116  81.555  44.029  1.00  0.00           H  
ATOM     85  HE  ARG A   8     -44.228  81.378  46.837  1.00  0.00           H  
ATOM     86 HH11 ARG A   8     -46.027  80.473  43.997  1.00  0.00           H  
ATOM     87 HH12 ARG A   8     -46.753  79.086  44.739  1.00  0.00           H  
ATOM     88 HH21 ARG A   8     -45.177  79.555  47.826  1.00  0.00           H  
ATOM     89 HH22 ARG A   8     -46.270  78.566  46.918  1.00  0.00           H  
ATOM     90  N   GLU A   9     -39.610  83.681  43.020  1.00  0.00           N  
ATOM     91  CA  GLU A   9     -39.397  83.903  41.595  1.00  0.00           C  
ATOM     92  C   GLU A   9     -38.421  82.877  41.024  1.00  0.00           C  
ATOM     93  O   GLU A   9     -37.688  82.224  41.766  1.00  0.00           O  
ATOM     94  CB  GLU A   9     -38.868  85.317  41.350  1.00  0.00           C  
ATOM     95  CG  GLU A   9     -39.889  86.407  41.631  1.00  0.00           C  
ATOM     96  CD  GLU A   9     -40.778  86.695  40.437  1.00  0.00           C  
ATOM     97  OE1 GLU A   9     -41.742  85.931  40.218  1.00  0.00           O  
ATOM     98  OE2 GLU A   9     -40.512  87.684  39.723  1.00  0.00           O  
ATOM     99  H   GLU A   9     -38.848  83.441  43.587  1.00  0.00           H  
ATOM    100  HA  GLU A   9     -40.348  83.793  41.096  1.00  0.00           H  
ATOM    101  HB2 GLU A   9     -38.010  85.483  41.986  1.00  0.00           H  
ATOM    102  HB3 GLU A   9     -38.561  85.400  40.317  1.00  0.00           H  
ATOM    103  HG2 GLU A   9     -40.511  86.094  42.457  1.00  0.00           H  
ATOM    104  HG3 GLU A   9     -39.366  87.313  41.898  1.00  0.00           H  
ATOM    105  N   GLU A  10     -38.420  82.742  39.702  1.00  0.00           N  
ATOM    106  CA  GLU A  10     -37.536  81.795  39.032  1.00  0.00           C  
ATOM    107  C   GLU A  10     -36.614  82.512  38.050  1.00  0.00           C  
ATOM    108  O   GLU A  10     -36.997  83.510  37.439  1.00  0.00           O  
ATOM    109  CB  GLU A  10     -38.354  80.731  38.298  1.00  0.00           C  
ATOM    110  CG  GLU A  10     -39.204  79.873  39.220  1.00  0.00           C  
ATOM    111  CD  GLU A  10     -38.375  79.104  40.230  1.00  0.00           C  
ATOM    112  OE1 GLU A  10     -37.751  78.095  39.840  1.00  0.00           O  
ATOM    113  OE2 GLU A  10     -38.351  79.511  41.410  1.00  0.00           O  
ATOM    114  H   GLU A  10     -39.027  83.291  39.165  1.00  0.00           H  
ATOM    115  HA  GLU A  10     -36.933  81.314  39.788  1.00  0.00           H  
ATOM    116  HB2 GLU A  10     -39.007  81.221  37.591  1.00  0.00           H  
ATOM    117  HB3 GLU A  10     -37.678  80.082  37.760  1.00  0.00           H  
ATOM    118  HG2 GLU A  10     -39.891  80.513  39.754  1.00  0.00           H  
ATOM    119  HG3 GLU A  10     -39.762  79.168  38.621  1.00  0.00           H  
ATOM    120  N   ASP A  11     -35.399  81.996  37.904  1.00  0.00           N  
ATOM    121  CA  ASP A  11     -34.422  82.585  36.995  1.00  0.00           C  
ATOM    122  C   ASP A  11     -34.449  81.886  35.640  1.00  0.00           C  
ATOM    123  O   ASP A  11     -34.822  80.718  35.524  1.00  0.00           O  
ATOM    124  CB  ASP A  11     -33.020  82.505  37.598  1.00  0.00           C  
ATOM    125  CG  ASP A  11     -32.765  83.592  38.623  1.00  0.00           C  
ATOM    126  OD1 ASP A  11     -32.799  84.783  38.246  1.00  0.00           O  
ATOM    127  OD2 ASP A  11     -32.535  83.253  39.802  1.00  0.00           O  
ATOM    128  H   ASP A  11     -35.153  81.199  38.418  1.00  0.00           H  
ATOM    129  HA  ASP A  11     -34.684  83.624  36.855  1.00  0.00           H  
ATOM    130  HB2 ASP A  11     -32.897  81.545  38.081  1.00  0.00           H  
ATOM    131  HB3 ASP A  11     -32.289  82.601  36.808  1.00  0.00           H  
ATOM    132  N   PRO A  12     -34.044  82.614  34.589  1.00  0.00           N  
ATOM    133  CA  PRO A  12     -34.013  82.084  33.223  1.00  0.00           C  
ATOM    134  C   PRO A  12     -32.926  81.030  33.035  1.00  0.00           C  
ATOM    135  O   PRO A  12     -33.138  80.018  32.366  1.00  0.00           O  
ATOM    136  CB  PRO A  12     -33.712  83.319  32.370  1.00  0.00           C  
ATOM    137  CG  PRO A  12     -33.000  84.251  33.289  1.00  0.00           C  
ATOM    138  CD  PRO A  12     -33.585  84.012  34.654  1.00  0.00           C  
ATOM    139  HA  PRO A  12     -34.968  81.669  32.936  1.00  0.00           H  
ATOM    140  HB2 PRO A  12     -33.090  83.037  31.532  1.00  0.00           H  
ATOM    141  HB3 PRO A  12     -34.636  83.747  32.012  1.00  0.00           H  
ATOM    142  HG2 PRO A  12     -31.944  84.030  33.290  1.00  0.00           H  
ATOM    143  HG3 PRO A  12     -33.173  85.271  32.981  1.00  0.00           H  
ATOM    144  HD2 PRO A  12     -32.828  84.135  35.415  1.00  0.00           H  
ATOM    145  HD3 PRO A  12     -34.413  84.682  34.831  1.00  0.00           H  
ATOM    146  N   HIS A  13     -31.763  81.273  33.630  1.00  0.00           N  
ATOM    147  CA  HIS A  13     -30.643  80.344  33.529  1.00  0.00           C  
ATOM    148  C   HIS A  13     -30.984  79.010  34.186  1.00  0.00           C  
ATOM    149  O   HIS A  13     -30.526  77.956  33.745  1.00  0.00           O  
ATOM    150  CB  HIS A  13     -29.396  80.941  34.180  1.00  0.00           C  
ATOM    151  CG  HIS A  13     -28.114  80.462  33.571  1.00  0.00           C  
ATOM    152  ND1 HIS A  13     -27.068  81.304  33.258  1.00  0.00           N  
ATOM    153  CD2 HIS A  13     -27.712  79.218  33.218  1.00  0.00           C  
ATOM    154  CE1 HIS A  13     -26.079  80.600  32.739  1.00  0.00           C  
ATOM    155  NE2 HIS A  13     -26.444  79.331  32.703  1.00  0.00           N  
ATOM    156  H   HIS A  13     -31.655  82.097  34.149  1.00  0.00           H  
ATOM    157  HA  HIS A  13     -30.446  80.175  32.481  1.00  0.00           H  
ATOM    158  HB2 HIS A  13     -29.427  82.017  34.082  1.00  0.00           H  
ATOM    159  HB3 HIS A  13     -29.384  80.681  35.228  1.00  0.00           H  
ATOM    160  HD1 HIS A  13     -27.054  82.274  33.396  1.00  0.00           H  
ATOM    161  HD2 HIS A  13     -28.283  78.306  33.322  1.00  0.00           H  
ATOM    162  HE1 HIS A  13     -25.132  80.994  32.400  1.00  0.00           H  
ATOM    163  N   GLU A  14     -31.790  79.063  35.241  1.00  0.00           N  
ATOM    164  CA  GLU A  14     -32.191  77.859  35.958  1.00  0.00           C  
ATOM    165  C   GLU A  14     -33.344  77.159  35.246  1.00  0.00           C  
ATOM    166  O   GLU A  14     -33.880  76.165  35.735  1.00  0.00           O  
ATOM    167  CB  GLU A  14     -32.597  78.203  37.393  1.00  0.00           C  
ATOM    168  CG  GLU A  14     -31.469  78.803  38.218  1.00  0.00           C  
ATOM    169  CD  GLU A  14     -31.849  78.992  39.673  1.00  0.00           C  
ATOM    170  OE1 GLU A  14     -32.597  78.146  40.206  1.00  0.00           O  
ATOM    171  OE2 GLU A  14     -31.400  79.988  40.279  1.00  0.00           O  
ATOM    172  H   GLU A  14     -32.124  79.934  35.544  1.00  0.00           H  
ATOM    173  HA  GLU A  14     -31.342  77.192  35.985  1.00  0.00           H  
ATOM    174  HB2 GLU A  14     -33.410  78.913  37.363  1.00  0.00           H  
ATOM    175  HB3 GLU A  14     -32.935  77.304  37.884  1.00  0.00           H  
ATOM    176  HG2 GLU A  14     -30.616  78.144  38.167  1.00  0.00           H  
ATOM    177  HG3 GLU A  14     -31.206  79.764  37.800  1.00  0.00           H  
ATOM    178  N   GLY A  15     -33.723  77.687  34.085  1.00  0.00           N  
ATOM    179  CA  GLY A  15     -34.811  77.101  33.324  1.00  0.00           C  
ATOM    180  C   GLY A  15     -34.318  76.236  32.182  1.00  0.00           C  
ATOM    181  O   GLY A  15     -35.092  75.490  31.578  1.00  0.00           O  
ATOM    182  H   GLY A  15     -33.259  78.480  33.743  1.00  0.00           H  
ATOM    183  HA2 GLY A  15     -35.414  76.497  33.985  1.00  0.00           H  
ATOM    184  HA3 GLY A  15     -35.421  77.895  32.921  1.00  0.00           H  
ATOM    185  N   LYS A  16     -33.028  76.334  31.880  1.00  0.00           N  
ATOM    186  CA  LYS A  16     -32.433  75.555  30.801  1.00  0.00           C  
ATOM    187  C   LYS A  16     -32.518  74.061  31.097  1.00  0.00           C  
ATOM    188  O   LYS A  16     -32.459  73.644  32.255  1.00  0.00           O  
ATOM    189  CB  LYS A  16     -30.971  75.961  30.597  1.00  0.00           C  
ATOM    190  CG  LYS A  16     -30.779  77.453  30.385  1.00  0.00           C  
ATOM    191  CD  LYS A  16     -31.367  77.908  29.060  1.00  0.00           C  
ATOM    192  CE  LYS A  16     -31.222  79.411  28.872  1.00  0.00           C  
ATOM    193  NZ  LYS A  16     -31.557  79.831  27.484  1.00  0.00           N  
ATOM    194  H   LYS A  16     -32.462  76.946  32.396  1.00  0.00           H  
ATOM    195  HA  LYS A  16     -32.985  75.763  29.897  1.00  0.00           H  
ATOM    196  HB2 LYS A  16     -30.403  75.666  31.467  1.00  0.00           H  
ATOM    197  HB3 LYS A  16     -30.583  75.443  29.732  1.00  0.00           H  
ATOM    198  HG2 LYS A  16     -31.268  77.988  31.186  1.00  0.00           H  
ATOM    199  HG3 LYS A  16     -29.721  77.675  30.395  1.00  0.00           H  
ATOM    200  HD2 LYS A  16     -30.853  77.405  28.256  1.00  0.00           H  
ATOM    201  HD3 LYS A  16     -32.418  77.652  29.035  1.00  0.00           H  
ATOM    202  HE2 LYS A  16     -31.884  79.912  29.561  1.00  0.00           H  
ATOM    203  HE3 LYS A  16     -30.201  79.690  29.087  1.00  0.00           H  
ATOM    204  HZ1 LYS A  16     -31.683  78.995  26.878  1.00  0.00           H  
ATOM    205  HZ2 LYS A  16     -30.791  80.416  27.093  1.00  0.00           H  
ATOM    206  HZ3 LYS A  16     -32.438  80.383  27.481  1.00  0.00           H  
ATOM    207  N   ILE A  17     -32.656  73.260  30.045  1.00  0.00           N  
ATOM    208  CA  ILE A  17     -32.747  71.813  30.194  1.00  0.00           C  
ATOM    209  C   ILE A  17     -31.366  71.190  30.363  1.00  0.00           C  
ATOM    210  O   ILE A  17     -31.225  70.121  30.957  1.00  0.00           O  
ATOM    211  CB  ILE A  17     -33.446  71.166  28.984  1.00  0.00           C  
ATOM    212  CG1 ILE A  17     -33.644  69.668  29.223  1.00  0.00           C  
ATOM    213  CG2 ILE A  17     -32.639  71.404  27.717  1.00  0.00           C  
ATOM    214  CD1 ILE A  17     -34.728  69.057  28.363  1.00  0.00           C  
ATOM    215  H   ILE A  17     -32.698  73.652  29.148  1.00  0.00           H  
ATOM    216  HA  ILE A  17     -33.335  71.606  31.077  1.00  0.00           H  
ATOM    217  HB  ILE A  17     -34.411  71.635  28.860  1.00  0.00           H  
ATOM    218 HG12 ILE A  17     -32.722  69.150  29.009  1.00  0.00           H  
ATOM    219 HG13 ILE A  17     -33.911  69.509  30.257  1.00  0.00           H  
ATOM    220 HG21 ILE A  17     -32.854  72.390  27.333  1.00  0.00           H  
ATOM    221 HG22 ILE A  17     -31.586  71.328  27.942  1.00  0.00           H  
ATOM    222 HG23 ILE A  17     -32.903  70.664  26.976  1.00  0.00           H  
ATOM    223 HD11 ILE A  17     -34.823  69.621  27.447  1.00  0.00           H  
ATOM    224 HD12 ILE A  17     -34.473  68.034  28.133  1.00  0.00           H  
ATOM    225 HD13 ILE A  17     -35.668  69.081  28.898  1.00  0.00           H  
ATOM    226  N   TRP A  18     -30.350  71.866  29.838  1.00  0.00           N  
ATOM    227  CA  TRP A  18     -28.979  71.379  29.932  1.00  0.00           C  
ATOM    228  C   TRP A  18     -28.334  71.819  31.242  1.00  0.00           C  
ATOM    229  O   TRP A  18     -27.337  71.242  31.679  1.00  0.00           O  
ATOM    230  CB  TRP A  18     -28.153  71.885  28.748  1.00  0.00           C  
ATOM    231  CG  TRP A  18     -28.380  73.335  28.443  1.00  0.00           C  
ATOM    232  CD1 TRP A  18     -29.197  73.853  27.479  1.00  0.00           C  
ATOM    233  CD2 TRP A  18     -27.780  74.454  29.106  1.00  0.00           C  
ATOM    234  NE1 TRP A  18     -29.140  75.225  27.502  1.00  0.00           N  
ATOM    235  CE2 TRP A  18     -28.278  75.619  28.491  1.00  0.00           C  
ATOM    236  CE3 TRP A  18     -26.870  74.584  30.159  1.00  0.00           C  
ATOM    237  CZ2 TRP A  18     -27.897  76.895  28.895  1.00  0.00           C  
ATOM    238  CZ3 TRP A  18     -26.492  75.852  30.558  1.00  0.00           C  
ATOM    239  CH2 TRP A  18     -27.006  76.994  29.928  1.00  0.00           C  
ATOM    240  H   TRP A  18     -30.527  72.713  29.376  1.00  0.00           H  
ATOM    241  HA  TRP A  18     -29.009  70.300  29.904  1.00  0.00           H  
ATOM    242  HB2 TRP A  18     -27.105  71.750  28.964  1.00  0.00           H  
ATOM    243  HB3 TRP A  18     -28.414  71.314  27.868  1.00  0.00           H  
ATOM    244  HD1 TRP A  18     -29.793  73.257  26.804  1.00  0.00           H  
ATOM    245  HE1 TRP A  18     -29.638  75.824  26.906  1.00  0.00           H  
ATOM    246  HE3 TRP A  18     -26.464  73.717  30.656  1.00  0.00           H  
ATOM    247  HZ2 TRP A  18     -28.283  77.785  28.420  1.00  0.00           H  
ATOM    248  HZ3 TRP A  18     -25.790  75.973  31.371  1.00  0.00           H  
ATOM    249  HH2 TRP A  18     -26.682  77.964  30.274  1.00  0.00           H  
ATOM    250  N   PHE A  19     -28.909  72.842  31.866  1.00  0.00           N  
ATOM    251  CA  PHE A  19     -28.388  73.359  33.126  1.00  0.00           C  
ATOM    252  C   PHE A  19     -28.828  72.484  34.296  1.00  0.00           C  
ATOM    253  O   PHE A  19     -29.917  71.908  34.280  1.00  0.00           O  
ATOM    254  CB  PHE A  19     -28.860  74.798  33.345  1.00  0.00           C  
ATOM    255  CG  PHE A  19     -28.373  75.400  34.632  1.00  0.00           C  
ATOM    256  CD1 PHE A  19     -27.041  75.746  34.789  1.00  0.00           C  
ATOM    257  CD2 PHE A  19     -29.247  75.618  35.685  1.00  0.00           C  
ATOM    258  CE1 PHE A  19     -26.590  76.298  35.973  1.00  0.00           C  
ATOM    259  CE2 PHE A  19     -28.802  76.170  36.871  1.00  0.00           C  
ATOM    260  CZ  PHE A  19     -27.472  76.512  37.015  1.00  0.00           C  
ATOM    261  H   PHE A  19     -29.701  73.260  31.468  1.00  0.00           H  
ATOM    262  HA  PHE A  19     -27.311  73.348  33.069  1.00  0.00           H  
ATOM    263  HB2 PHE A  19     -28.501  75.414  32.534  1.00  0.00           H  
ATOM    264  HB3 PHE A  19     -29.940  74.817  33.356  1.00  0.00           H  
ATOM    265  HD1 PHE A  19     -26.350  75.581  33.975  1.00  0.00           H  
ATOM    266  HD2 PHE A  19     -30.289  75.351  35.572  1.00  0.00           H  
ATOM    267  HE1 PHE A  19     -25.550  76.566  36.083  1.00  0.00           H  
ATOM    268  HE2 PHE A  19     -29.495  76.337  37.682  1.00  0.00           H  
ATOM    269  HZ  PHE A  19     -27.122  76.944  37.940  1.00  0.00           H  
ATOM    270  N   HIS A  20     -27.974  72.388  35.310  1.00  0.00           N  
ATOM    271  CA  HIS A  20     -28.274  71.583  36.488  1.00  0.00           C  
ATOM    272  C   HIS A  20     -27.774  72.269  37.756  1.00  0.00           C  
ATOM    273  O   HIS A  20     -26.605  72.643  37.852  1.00  0.00           O  
ATOM    274  CB  HIS A  20     -27.640  70.198  36.361  1.00  0.00           C  
ATOM    275  CG  HIS A  20     -28.433  69.252  35.512  1.00  0.00           C  
ATOM    276  ND1 HIS A  20     -29.171  68.210  36.034  1.00  0.00           N  
ATOM    277  CD2 HIS A  20     -28.604  69.197  34.170  1.00  0.00           C  
ATOM    278  CE1 HIS A  20     -29.759  67.554  35.050  1.00  0.00           C  
ATOM    279  NE2 HIS A  20     -29.432  68.133  33.909  1.00  0.00           N  
ATOM    280  H   HIS A  20     -27.122  72.870  35.264  1.00  0.00           H  
ATOM    281  HA  HIS A  20     -29.345  71.474  36.552  1.00  0.00           H  
ATOM    282  HB2 HIS A  20     -26.660  70.296  35.918  1.00  0.00           H  
ATOM    283  HB3 HIS A  20     -27.543  69.761  37.344  1.00  0.00           H  
ATOM    284  HD1 HIS A  20     -29.250  67.984  36.984  1.00  0.00           H  
ATOM    285  HD2 HIS A  20     -28.170  69.865  33.440  1.00  0.00           H  
ATOM    286  HE1 HIS A  20     -30.399  66.691  35.159  1.00  0.00           H  
ATOM    287  N   GLY A  21     -28.667  72.431  38.728  1.00  0.00           N  
ATOM    288  CA  GLY A  21     -28.297  73.074  39.976  1.00  0.00           C  
ATOM    289  C   GLY A  21     -28.847  72.346  41.186  1.00  0.00           C  
ATOM    290  O   GLY A  21     -28.181  72.250  42.218  1.00  0.00           O  
ATOM    291  H   GLY A  21     -29.584  72.114  38.595  1.00  0.00           H  
ATOM    292  HA2 GLY A  21     -27.219  73.105  40.046  1.00  0.00           H  
ATOM    293  HA3 GLY A  21     -28.677  74.084  39.974  1.00  0.00           H  
ATOM    294  N   LYS A  22     -30.067  71.834  41.063  1.00  0.00           N  
ATOM    295  CA  LYS A  22     -30.708  71.112  42.156  1.00  0.00           C  
ATOM    296  C   LYS A  22     -29.870  69.909  42.579  1.00  0.00           C  
ATOM    297  O   LYS A  22     -29.754  69.610  43.767  1.00  0.00           O  
ATOM    298  CB  LYS A  22     -32.106  70.652  41.739  1.00  0.00           C  
ATOM    299  CG  LYS A  22     -33.142  71.762  41.757  1.00  0.00           C  
ATOM    300  CD  LYS A  22     -34.419  71.345  41.045  1.00  0.00           C  
ATOM    301  CE  LYS A  22     -35.293  70.472  41.934  1.00  0.00           C  
ATOM    302  NZ  LYS A  22     -36.542  70.051  41.243  1.00  0.00           N  
ATOM    303  H   LYS A  22     -30.547  71.943  40.215  1.00  0.00           H  
ATOM    304  HA  LYS A  22     -30.795  71.788  42.994  1.00  0.00           H  
ATOM    305  HB2 LYS A  22     -32.057  70.250  40.737  1.00  0.00           H  
ATOM    306  HB3 LYS A  22     -32.433  69.873  42.413  1.00  0.00           H  
ATOM    307  HG2 LYS A  22     -33.378  72.007  42.782  1.00  0.00           H  
ATOM    308  HG3 LYS A  22     -32.734  72.632  41.262  1.00  0.00           H  
ATOM    309  HD2 LYS A  22     -34.974  72.230  40.773  1.00  0.00           H  
ATOM    310  HD3 LYS A  22     -34.160  70.791  40.155  1.00  0.00           H  
ATOM    311  HE2 LYS A  22     -34.733  69.594  42.216  1.00  0.00           H  
ATOM    312  HE3 LYS A  22     -35.553  71.032  42.821  1.00  0.00           H  
ATOM    313  HZ1 LYS A  22     -37.320  69.970  41.928  1.00  0.00           H  
ATOM    314  HZ2 LYS A  22     -36.402  69.128  40.784  1.00  0.00           H  
ATOM    315  HZ3 LYS A  22     -36.803  70.749  40.519  1.00  0.00           H  
ATOM    316  N   ILE A  23     -29.288  69.226  41.599  1.00  0.00           N  
ATOM    317  CA  ILE A  23     -28.459  68.059  41.871  1.00  0.00           C  
ATOM    318  C   ILE A  23     -27.111  68.465  42.457  1.00  0.00           C  
ATOM    319  O   ILE A  23     -26.867  69.642  42.722  1.00  0.00           O  
ATOM    320  CB  ILE A  23     -28.223  67.227  40.597  1.00  0.00           C  
ATOM    321  CG1 ILE A  23     -27.351  68.005  39.609  1.00  0.00           C  
ATOM    322  CG2 ILE A  23     -29.550  66.849  39.956  1.00  0.00           C  
ATOM    323  CD1 ILE A  23     -26.607  67.119  38.632  1.00  0.00           C  
ATOM    324  H   ILE A  23     -29.418  69.514  40.672  1.00  0.00           H  
ATOM    325  HA  ILE A  23     -28.980  67.441  42.589  1.00  0.00           H  
ATOM    326  HB  ILE A  23     -27.714  66.317  40.877  1.00  0.00           H  
ATOM    327 HG12 ILE A  23     -27.974  68.675  39.039  1.00  0.00           H  
ATOM    328 HG13 ILE A  23     -26.621  68.579  40.160  1.00  0.00           H  
ATOM    329 HG21 ILE A  23     -29.387  66.574  38.925  1.00  0.00           H  
ATOM    330 HG22 ILE A  23     -29.981  66.013  40.487  1.00  0.00           H  
ATOM    331 HG23 ILE A  23     -30.225  67.691  40.002  1.00  0.00           H  
ATOM    332 HD11 ILE A  23     -25.767  67.661  38.223  1.00  0.00           H  
ATOM    333 HD12 ILE A  23     -26.253  66.237  39.144  1.00  0.00           H  
ATOM    334 HD13 ILE A  23     -27.272  66.829  37.833  1.00  0.00           H  
ATOM    335  N   SER A  24     -26.238  67.483  42.655  1.00  0.00           N  
ATOM    336  CA  SER A  24     -24.914  67.738  43.211  1.00  0.00           C  
ATOM    337  C   SER A  24     -23.824  67.232  42.272  1.00  0.00           C  
ATOM    338  O   SER A  24     -24.109  66.718  41.190  1.00  0.00           O  
ATOM    339  CB  SER A  24     -24.775  67.068  44.579  1.00  0.00           C  
ATOM    340  OG  SER A  24     -23.796  67.720  45.370  1.00  0.00           O  
ATOM    341  H   SER A  24     -26.491  66.564  42.424  1.00  0.00           H  
ATOM    342  HA  SER A  24     -24.804  68.805  43.330  1.00  0.00           H  
ATOM    343  HB2 SER A  24     -25.722  67.109  45.095  1.00  0.00           H  
ATOM    344  HB3 SER A  24     -24.482  66.036  44.444  1.00  0.00           H  
ATOM    345  HG  SER A  24     -23.187  67.069  45.726  1.00  0.00           H  
ATOM    346  N   LYS A  25     -22.573  67.382  42.692  1.00  0.00           N  
ATOM    347  CA  LYS A  25     -21.437  66.941  41.892  1.00  0.00           C  
ATOM    348  C   LYS A  25     -21.426  65.422  41.754  1.00  0.00           C  
ATOM    349  O   LYS A  25     -21.270  64.891  40.654  1.00  0.00           O  
ATOM    350  CB  LYS A  25     -20.126  67.416  42.524  1.00  0.00           C  
ATOM    351  CG  LYS A  25     -18.889  66.806  41.887  1.00  0.00           C  
ATOM    352  CD  LYS A  25     -17.615  67.392  42.472  1.00  0.00           C  
ATOM    353  CE  LYS A  25     -17.285  66.776  43.823  1.00  0.00           C  
ATOM    354  NZ  LYS A  25     -15.975  67.253  44.346  1.00  0.00           N  
ATOM    355  H   LYS A  25     -22.408  67.800  43.565  1.00  0.00           H  
ATOM    356  HA  LYS A  25     -21.533  67.379  40.910  1.00  0.00           H  
ATOM    357  HB2 LYS A  25     -20.062  68.489  42.428  1.00  0.00           H  
ATOM    358  HB3 LYS A  25     -20.130  67.157  43.572  1.00  0.00           H  
ATOM    359  HG2 LYS A  25     -18.895  65.739  42.061  1.00  0.00           H  
ATOM    360  HG3 LYS A  25     -18.908  66.999  40.824  1.00  0.00           H  
ATOM    361  HD2 LYS A  25     -16.796  67.202  41.793  1.00  0.00           H  
ATOM    362  HD3 LYS A  25     -17.743  68.458  42.595  1.00  0.00           H  
ATOM    363  HE2 LYS A  25     -18.063  67.040  44.524  1.00  0.00           H  
ATOM    364  HE3 LYS A  25     -17.250  65.702  43.714  1.00  0.00           H  
ATOM    365  HZ1 LYS A  25     -15.343  67.497  43.557  1.00  0.00           H  
ATOM    366  HZ2 LYS A  25     -15.526  66.508  44.918  1.00  0.00           H  
ATOM    367  HZ3 LYS A  25     -16.114  68.095  44.940  1.00  0.00           H  
ATOM    368  N   GLN A  26     -21.593  64.729  42.876  1.00  0.00           N  
ATOM    369  CA  GLN A  26     -21.603  63.270  42.879  1.00  0.00           C  
ATOM    370  C   GLN A  26     -22.763  62.733  42.047  1.00  0.00           C  
ATOM    371  O   GLN A  26     -22.583  61.845  41.216  1.00  0.00           O  
ATOM    372  CB  GLN A  26     -21.699  62.743  44.311  1.00  0.00           C  
ATOM    373  CG  GLN A  26     -20.353  62.627  45.008  1.00  0.00           C  
ATOM    374  CD  GLN A  26     -19.553  63.915  44.951  1.00  0.00           C  
ATOM    375  OE1 GLN A  26     -19.198  64.390  43.872  1.00  0.00           O  
ATOM    376  NE2 GLN A  26     -19.267  64.486  46.115  1.00  0.00           N  
ATOM    377  H   GLN A  26     -21.713  65.209  43.721  1.00  0.00           H  
ATOM    378  HA  GLN A  26     -20.676  62.933  42.441  1.00  0.00           H  
ATOM    379  HB2 GLN A  26     -22.322  63.410  44.887  1.00  0.00           H  
ATOM    380  HB3 GLN A  26     -22.155  61.764  44.292  1.00  0.00           H  
ATOM    381  HG2 GLN A  26     -20.519  62.371  46.043  1.00  0.00           H  
ATOM    382  HG3 GLN A  26     -19.781  61.845  44.532  1.00  0.00           H  
ATOM    383 HE21 GLN A  26     -19.582  64.049  46.935  1.00  0.00           H  
ATOM    384 HE22 GLN A  26     -18.751  65.318  46.107  1.00  0.00           H  
ATOM    385  N   GLU A  27     -23.954  63.278  42.279  1.00  0.00           N  
ATOM    386  CA  GLU A  27     -25.144  62.850  41.552  1.00  0.00           C  
ATOM    387  C   GLU A  27     -24.938  62.986  40.046  1.00  0.00           C  
ATOM    388  O   GLU A  27     -25.189  62.049  39.288  1.00  0.00           O  
ATOM    389  CB  GLU A  27     -26.357  63.673  41.988  1.00  0.00           C  
ATOM    390  CG  GLU A  27     -26.925  63.255  43.334  1.00  0.00           C  
ATOM    391  CD  GLU A  27     -27.646  64.385  44.041  1.00  0.00           C  
ATOM    392  OE1 GLU A  27     -28.784  64.706  43.638  1.00  0.00           O  
ATOM    393  OE2 GLU A  27     -27.074  64.950  44.996  1.00  0.00           O  
ATOM    394  H   GLU A  27     -24.034  63.983  42.955  1.00  0.00           H  
ATOM    395  HA  GLU A  27     -25.321  61.812  41.787  1.00  0.00           H  
ATOM    396  HB2 GLU A  27     -26.070  64.713  42.049  1.00  0.00           H  
ATOM    397  HB3 GLU A  27     -27.135  63.567  41.245  1.00  0.00           H  
ATOM    398  HG2 GLU A  27     -27.622  62.445  43.180  1.00  0.00           H  
ATOM    399  HG3 GLU A  27     -26.114  62.916  43.962  1.00  0.00           H  
ATOM    400  N   ALA A  28     -24.481  64.159  39.620  1.00  0.00           N  
ATOM    401  CA  ALA A  28     -24.241  64.417  38.206  1.00  0.00           C  
ATOM    402  C   ALA A  28     -23.583  63.218  37.533  1.00  0.00           C  
ATOM    403  O   ALA A  28     -23.950  62.839  36.421  1.00  0.00           O  
ATOM    404  CB  ALA A  28     -23.379  65.659  38.035  1.00  0.00           C  
ATOM    405  H   ALA A  28     -24.300  64.867  40.273  1.00  0.00           H  
ATOM    406  HA  ALA A  28     -25.194  64.604  37.734  1.00  0.00           H  
ATOM    407  HB1 ALA A  28     -22.491  65.406  37.474  1.00  0.00           H  
ATOM    408  HB2 ALA A  28     -23.937  66.415  37.505  1.00  0.00           H  
ATOM    409  HB3 ALA A  28     -23.094  66.037  39.007  1.00  0.00           H  
ATOM    410  N   TYR A  29     -22.608  62.624  38.213  1.00  0.00           N  
ATOM    411  CA  TYR A  29     -21.896  61.469  37.679  1.00  0.00           C  
ATOM    412  C   TYR A  29     -22.858  60.318  37.400  1.00  0.00           C  
ATOM    413  O   TYR A  29     -23.024  59.896  36.256  1.00  0.00           O  
ATOM    414  CB  TYR A  29     -20.811  61.016  38.657  1.00  0.00           C  
ATOM    415  CG  TYR A  29     -19.502  61.755  38.494  1.00  0.00           C  
ATOM    416  CD1 TYR A  29     -18.676  61.511  37.404  1.00  0.00           C  
ATOM    417  CD2 TYR A  29     -19.092  62.695  39.430  1.00  0.00           C  
ATOM    418  CE1 TYR A  29     -17.479  62.183  37.251  1.00  0.00           C  
ATOM    419  CE2 TYR A  29     -17.897  63.374  39.284  1.00  0.00           C  
ATOM    420  CZ  TYR A  29     -17.094  63.114  38.194  1.00  0.00           C  
ATOM    421  OH  TYR A  29     -15.902  63.786  38.046  1.00  0.00           O  
ATOM    422  H   TYR A  29     -22.360  62.973  39.095  1.00  0.00           H  
ATOM    423  HA  TYR A  29     -21.430  61.766  36.752  1.00  0.00           H  
ATOM    424  HB2 TYR A  29     -21.157  61.174  39.667  1.00  0.00           H  
ATOM    425  HB3 TYR A  29     -20.619  59.964  38.508  1.00  0.00           H  
ATOM    426  HD1 TYR A  29     -18.980  60.781  36.667  1.00  0.00           H  
ATOM    427  HD2 TYR A  29     -19.723  62.897  40.283  1.00  0.00           H  
ATOM    428  HE1 TYR A  29     -16.849  61.980  36.397  1.00  0.00           H  
ATOM    429  HE2 TYR A  29     -17.595  64.103  40.022  1.00  0.00           H  
ATOM    430  HH  TYR A  29     -15.262  63.212  37.619  1.00  0.00           H  
ATOM    431  N   ASN A  30     -23.491  59.815  38.455  1.00  0.00           N  
ATOM    432  CA  ASN A  30     -24.438  58.713  38.326  1.00  0.00           C  
ATOM    433  C   ASN A  30     -25.607  59.103  37.428  1.00  0.00           C  
ATOM    434  O   ASN A  30     -26.294  58.243  36.876  1.00  0.00           O  
ATOM    435  CB  ASN A  30     -24.955  58.293  39.703  1.00  0.00           C  
ATOM    436  CG  ASN A  30     -25.743  56.998  39.654  1.00  0.00           C  
ATOM    437  OD1 ASN A  30     -25.363  56.053  38.963  1.00  0.00           O  
ATOM    438  ND2 ASN A  30     -26.847  56.950  40.389  1.00  0.00           N  
ATOM    439  H   ASN A  30     -23.318  60.194  39.342  1.00  0.00           H  
ATOM    440  HA  ASN A  30     -23.916  57.881  37.877  1.00  0.00           H  
ATOM    441  HB2 ASN A  30     -24.116  58.156  40.370  1.00  0.00           H  
ATOM    442  HB3 ASN A  30     -25.596  59.069  40.092  1.00  0.00           H  
ATOM    443 HD21 ASN A  30     -27.089  57.741  40.914  1.00  0.00           H  
ATOM    444 HD22 ASN A  30     -27.375  56.124  40.377  1.00  0.00           H  
ATOM    445  N   LEU A  31     -25.828  60.406  37.284  1.00  0.00           N  
ATOM    446  CA  LEU A  31     -26.914  60.911  36.453  1.00  0.00           C  
ATOM    447  C   LEU A  31     -26.603  60.716  34.973  1.00  0.00           C  
ATOM    448  O   LEU A  31     -27.376  60.098  34.240  1.00  0.00           O  
ATOM    449  CB  LEU A  31     -27.158  62.393  36.743  1.00  0.00           C  
ATOM    450  CG  LEU A  31     -28.027  62.704  37.962  1.00  0.00           C  
ATOM    451  CD1 LEU A  31     -27.940  64.180  38.319  1.00  0.00           C  
ATOM    452  CD2 LEU A  31     -29.472  62.301  37.704  1.00  0.00           C  
ATOM    453  H   LEU A  31     -25.247  61.043  37.750  1.00  0.00           H  
ATOM    454  HA  LEU A  31     -27.806  60.353  36.697  1.00  0.00           H  
ATOM    455  HB2 LEU A  31     -26.199  62.862  36.894  1.00  0.00           H  
ATOM    456  HB3 LEU A  31     -27.636  62.824  35.876  1.00  0.00           H  
ATOM    457  HG  LEU A  31     -27.667  62.135  38.808  1.00  0.00           H  
ATOM    458 HD11 LEU A  31     -28.127  64.774  37.437  1.00  0.00           H  
ATOM    459 HD12 LEU A  31     -26.953  64.400  38.698  1.00  0.00           H  
ATOM    460 HD13 LEU A  31     -28.676  64.412  39.075  1.00  0.00           H  
ATOM    461 HD21 LEU A  31     -29.497  61.493  36.987  1.00  0.00           H  
ATOM    462 HD22 LEU A  31     -30.017  63.147  37.311  1.00  0.00           H  
ATOM    463 HD23 LEU A  31     -29.927  61.977  38.628  1.00  0.00           H  
ATOM    464  N   LEU A  32     -25.463  61.245  34.538  1.00  0.00           N  
ATOM    465  CA  LEU A  32     -25.047  61.126  33.146  1.00  0.00           C  
ATOM    466  C   LEU A  32     -24.943  59.662  32.730  1.00  0.00           C  
ATOM    467  O   LEU A  32     -24.840  59.349  31.545  1.00  0.00           O  
ATOM    468  CB  LEU A  32     -23.704  61.826  32.933  1.00  0.00           C  
ATOM    469  CG  LEU A  32     -23.757  63.346  32.770  1.00  0.00           C  
ATOM    470  CD1 LEU A  32     -22.393  63.960  33.048  1.00  0.00           C  
ATOM    471  CD2 LEU A  32     -24.237  63.716  31.375  1.00  0.00           C  
ATOM    472  H   LEU A  32     -24.888  61.725  35.168  1.00  0.00           H  
ATOM    473  HA  LEU A  32     -25.796  61.609  32.535  1.00  0.00           H  
ATOM    474  HB2 LEU A  32     -23.078  61.606  33.785  1.00  0.00           H  
ATOM    475  HB3 LEU A  32     -23.253  61.413  32.042  1.00  0.00           H  
ATOM    476  HG  LEU A  32     -24.458  63.754  33.485  1.00  0.00           H  
ATOM    477 HD11 LEU A  32     -22.068  63.683  34.039  1.00  0.00           H  
ATOM    478 HD12 LEU A  32     -22.462  65.035  32.978  1.00  0.00           H  
ATOM    479 HD13 LEU A  32     -21.680  63.598  32.321  1.00  0.00           H  
ATOM    480 HD21 LEU A  32     -24.665  64.707  31.392  1.00  0.00           H  
ATOM    481 HD22 LEU A  32     -24.985  63.007  31.051  1.00  0.00           H  
ATOM    482 HD23 LEU A  32     -23.401  63.697  30.690  1.00  0.00           H  
ATOM    483  N   MET A  33     -24.971  58.770  33.715  1.00  0.00           N  
ATOM    484  CA  MET A  33     -24.883  57.339  33.451  1.00  0.00           C  
ATOM    485  C   MET A  33     -26.270  56.708  33.406  1.00  0.00           C  
ATOM    486  O   MET A  33     -26.479  55.686  32.750  1.00  0.00           O  
ATOM    487  CB  MET A  33     -24.032  56.653  34.521  1.00  0.00           C  
ATOM    488  CG  MET A  33     -22.590  57.134  34.553  1.00  0.00           C  
ATOM    489  SD  MET A  33     -21.446  55.863  35.123  1.00  0.00           S  
ATOM    490  CE  MET A  33     -21.795  54.547  33.958  1.00  0.00           C  
ATOM    491  H   MET A  33     -25.054  59.081  34.641  1.00  0.00           H  
ATOM    492  HA  MET A  33     -24.409  57.208  32.489  1.00  0.00           H  
ATOM    493  HB2 MET A  33     -24.472  56.840  35.489  1.00  0.00           H  
ATOM    494  HB3 MET A  33     -24.029  55.589  34.335  1.00  0.00           H  
ATOM    495  HG2 MET A  33     -22.303  57.435  33.556  1.00  0.00           H  
ATOM    496  HG3 MET A  33     -22.523  57.983  35.217  1.00  0.00           H  
ATOM    497  HE1 MET A  33     -20.868  54.151  33.572  1.00  0.00           H  
ATOM    498  HE2 MET A  33     -22.341  53.760  34.458  1.00  0.00           H  
ATOM    499  HE3 MET A  33     -22.388  54.936  33.143  1.00  0.00           H  
ATOM    500  N   THR A  34     -27.218  57.322  34.108  1.00  0.00           N  
ATOM    501  CA  THR A  34     -28.586  56.818  34.149  1.00  0.00           C  
ATOM    502  C   THR A  34     -29.516  57.685  33.308  1.00  0.00           C  
ATOM    503  O   THR A  34     -29.995  57.260  32.257  1.00  0.00           O  
ATOM    504  CB  THR A  34     -29.120  56.763  35.593  1.00  0.00           C  
ATOM    505  OG1 THR A  34     -28.950  58.036  36.227  1.00  0.00           O  
ATOM    506  CG2 THR A  34     -28.399  55.690  36.396  1.00  0.00           C  
ATOM    507  H   THR A  34     -26.990  58.131  34.611  1.00  0.00           H  
ATOM    508  HA  THR A  34     -28.584  55.815  33.749  1.00  0.00           H  
ATOM    509  HB  THR A  34     -30.173  56.522  35.562  1.00  0.00           H  
ATOM    510  HG1 THR A  34     -28.828  57.909  37.172  1.00  0.00           H  
ATOM    511 HG21 THR A  34     -28.597  55.835  37.448  1.00  0.00           H  
ATOM    512 HG22 THR A  34     -27.337  55.758  36.215  1.00  0.00           H  
ATOM    513 HG23 THR A  34     -28.755  54.717  36.095  1.00  0.00           H  
ATOM    514  N   VAL A  35     -29.765  58.904  33.776  1.00  0.00           N  
ATOM    515  CA  VAL A  35     -30.638  59.831  33.065  1.00  0.00           C  
ATOM    516  C   VAL A  35     -30.029  60.243  31.730  1.00  0.00           C  
ATOM    517  O   VAL A  35     -30.740  60.638  30.807  1.00  0.00           O  
ATOM    518  CB  VAL A  35     -30.914  61.094  33.902  1.00  0.00           C  
ATOM    519  CG1 VAL A  35     -31.510  60.722  35.251  1.00  0.00           C  
ATOM    520  CG2 VAL A  35     -29.640  61.906  34.080  1.00  0.00           C  
ATOM    521  H   VAL A  35     -29.354  59.185  34.620  1.00  0.00           H  
ATOM    522  HA  VAL A  35     -31.578  59.333  32.884  1.00  0.00           H  
ATOM    523  HB  VAL A  35     -31.632  61.703  33.372  1.00  0.00           H  
ATOM    524 HG11 VAL A  35     -31.805  61.619  35.774  1.00  0.00           H  
ATOM    525 HG12 VAL A  35     -32.374  60.091  35.102  1.00  0.00           H  
ATOM    526 HG13 VAL A  35     -30.774  60.191  35.836  1.00  0.00           H  
ATOM    527 HG21 VAL A  35     -29.048  61.476  34.874  1.00  0.00           H  
ATOM    528 HG22 VAL A  35     -29.071  61.890  33.160  1.00  0.00           H  
ATOM    529 HG23 VAL A  35     -29.892  62.925  34.329  1.00  0.00           H  
ATOM    530  N   GLY A  36     -28.706  60.149  31.634  1.00  0.00           N  
ATOM    531  CA  GLY A  36     -28.024  60.515  30.407  1.00  0.00           C  
ATOM    532  C   GLY A  36     -27.403  59.321  29.710  1.00  0.00           C  
ATOM    533  O   GLY A  36     -27.617  58.178  30.115  1.00  0.00           O  
ATOM    534  H   GLY A  36     -28.189  59.828  32.402  1.00  0.00           H  
ATOM    535  HA2 GLY A  36     -28.732  60.980  29.738  1.00  0.00           H  
ATOM    536  HA3 GLY A  36     -27.244  61.226  30.640  1.00  0.00           H  
ATOM    537  N   GLN A  37     -26.632  59.584  28.660  1.00  0.00           N  
ATOM    538  CA  GLN A  37     -25.979  58.521  27.906  1.00  0.00           C  
ATOM    539  C   GLN A  37     -24.967  59.095  26.919  1.00  0.00           C  
ATOM    540  O   GLN A  37     -24.863  60.311  26.758  1.00  0.00           O  
ATOM    541  CB  GLN A  37     -27.020  57.685  27.158  1.00  0.00           C  
ATOM    542  CG  GLN A  37     -26.556  56.271  26.847  1.00  0.00           C  
ATOM    543  CD  GLN A  37     -27.706  55.288  26.745  1.00  0.00           C  
ATOM    544  OE1 GLN A  37     -28.731  55.577  26.126  1.00  0.00           O  
ATOM    545  NE2 GLN A  37     -27.542  54.119  27.352  1.00  0.00           N  
ATOM    546  H   GLN A  37     -26.498  60.515  28.387  1.00  0.00           H  
ATOM    547  HA  GLN A  37     -25.459  57.887  28.607  1.00  0.00           H  
ATOM    548  HB2 GLN A  37     -27.914  57.623  27.760  1.00  0.00           H  
ATOM    549  HB3 GLN A  37     -27.257  58.176  26.226  1.00  0.00           H  
ATOM    550  HG2 GLN A  37     -26.025  56.279  25.907  1.00  0.00           H  
ATOM    551  HG3 GLN A  37     -25.891  55.944  27.633  1.00  0.00           H  
ATOM    552 HE21 GLN A  37     -26.699  53.959  27.826  1.00  0.00           H  
ATOM    553 HE22 GLN A  37     -28.269  53.466  27.302  1.00  0.00           H  
ATOM    554  N   VAL A  38     -24.225  58.212  26.260  1.00  0.00           N  
ATOM    555  CA  VAL A  38     -23.222  58.631  25.288  1.00  0.00           C  
ATOM    556  C   VAL A  38     -23.711  59.821  24.472  1.00  0.00           C  
ATOM    557  O   VAL A  38     -24.879  59.885  24.088  1.00  0.00           O  
ATOM    558  CB  VAL A  38     -22.853  57.482  24.330  1.00  0.00           C  
ATOM    559  CG1 VAL A  38     -21.571  57.802  23.579  1.00  0.00           C  
ATOM    560  CG2 VAL A  38     -22.721  56.173  25.094  1.00  0.00           C  
ATOM    561  H   VAL A  38     -24.354  57.255  26.431  1.00  0.00           H  
ATOM    562  HA  VAL A  38     -22.332  58.918  25.830  1.00  0.00           H  
ATOM    563  HB  VAL A  38     -23.650  57.373  23.609  1.00  0.00           H  
ATOM    564 HG11 VAL A  38     -21.140  58.711  23.974  1.00  0.00           H  
ATOM    565 HG12 VAL A  38     -20.870  56.989  23.697  1.00  0.00           H  
ATOM    566 HG13 VAL A  38     -21.793  57.937  22.530  1.00  0.00           H  
ATOM    567 HG21 VAL A  38     -23.703  55.800  25.343  1.00  0.00           H  
ATOM    568 HG22 VAL A  38     -22.205  55.448  24.482  1.00  0.00           H  
ATOM    569 HG23 VAL A  38     -22.159  56.341  26.001  1.00  0.00           H  
ATOM    570  N   CYS A  39     -22.810  60.762  24.209  1.00  0.00           N  
ATOM    571  CA  CYS A  39     -23.149  61.952  23.438  1.00  0.00           C  
ATOM    572  C   CYS A  39     -24.079  62.866  24.230  1.00  0.00           C  
ATOM    573  O   CYS A  39     -24.948  63.527  23.662  1.00  0.00           O  
ATOM    574  CB  CYS A  39     -23.808  61.558  22.115  1.00  0.00           C  
ATOM    575  SG  CYS A  39     -23.225  59.984  21.441  1.00  0.00           S  
ATOM    576  H   CYS A  39     -21.894  60.653  24.543  1.00  0.00           H  
ATOM    577  HA  CYS A  39     -22.233  62.483  23.230  1.00  0.00           H  
ATOM    578  HB2 CYS A  39     -24.875  61.476  22.263  1.00  0.00           H  
ATOM    579  HB3 CYS A  39     -23.610  62.324  21.381  1.00  0.00           H  
ATOM    580  HG  CYS A  39     -21.902  60.010  21.428  1.00  0.00           H  
ATOM    581  N   SER A  40     -23.890  62.897  25.545  1.00  0.00           N  
ATOM    582  CA  SER A  40     -24.715  63.726  26.417  1.00  0.00           C  
ATOM    583  C   SER A  40     -23.849  64.524  27.387  1.00  0.00           C  
ATOM    584  O   SER A  40     -22.916  63.990  27.988  1.00  0.00           O  
ATOM    585  CB  SER A  40     -25.705  62.856  27.195  1.00  0.00           C  
ATOM    586  OG  SER A  40     -26.500  62.078  26.318  1.00  0.00           O  
ATOM    587  H   SER A  40     -23.180  62.348  25.939  1.00  0.00           H  
ATOM    588  HA  SER A  40     -25.266  64.415  25.794  1.00  0.00           H  
ATOM    589  HB2 SER A  40     -25.160  62.195  27.851  1.00  0.00           H  
ATOM    590  HB3 SER A  40     -26.352  63.491  27.782  1.00  0.00           H  
ATOM    591  HG  SER A  40     -27.187  62.629  25.935  1.00  0.00           H  
ATOM    592  N   PHE A  41     -24.165  65.807  27.534  1.00  0.00           N  
ATOM    593  CA  PHE A  41     -23.416  66.680  28.429  1.00  0.00           C  
ATOM    594  C   PHE A  41     -24.358  67.458  29.343  1.00  0.00           C  
ATOM    595  O   PHE A  41     -25.580  67.378  29.208  1.00  0.00           O  
ATOM    596  CB  PHE A  41     -22.552  67.653  27.623  1.00  0.00           C  
ATOM    597  CG  PHE A  41     -23.318  68.820  27.070  1.00  0.00           C  
ATOM    598  CD1 PHE A  41     -23.451  69.988  27.802  1.00  0.00           C  
ATOM    599  CD2 PHE A  41     -23.907  68.747  25.818  1.00  0.00           C  
ATOM    600  CE1 PHE A  41     -24.155  71.064  27.295  1.00  0.00           C  
ATOM    601  CE2 PHE A  41     -24.612  69.820  25.306  1.00  0.00           C  
ATOM    602  CZ  PHE A  41     -24.738  70.980  26.046  1.00  0.00           C  
ATOM    603  H   PHE A  41     -24.920  66.174  27.027  1.00  0.00           H  
ATOM    604  HA  PHE A  41     -22.775  66.061  29.036  1.00  0.00           H  
ATOM    605  HB2 PHE A  41     -21.770  68.041  28.259  1.00  0.00           H  
ATOM    606  HB3 PHE A  41     -22.106  67.123  26.794  1.00  0.00           H  
ATOM    607  HD1 PHE A  41     -22.996  70.055  28.780  1.00  0.00           H  
ATOM    608  HD2 PHE A  41     -23.810  67.841  25.238  1.00  0.00           H  
ATOM    609  HE1 PHE A  41     -24.251  71.969  27.877  1.00  0.00           H  
ATOM    610  HE2 PHE A  41     -25.067  69.752  24.328  1.00  0.00           H  
ATOM    611  HZ  PHE A  41     -25.288  71.819  25.648  1.00  0.00           H  
ATOM    612  N   LEU A  42     -23.782  68.211  30.274  1.00  0.00           N  
ATOM    613  CA  LEU A  42     -24.569  69.003  31.212  1.00  0.00           C  
ATOM    614  C   LEU A  42     -23.697  70.036  31.920  1.00  0.00           C  
ATOM    615  O   LEU A  42     -22.524  69.784  32.199  1.00  0.00           O  
ATOM    616  CB  LEU A  42     -25.240  68.093  32.243  1.00  0.00           C  
ATOM    617  CG  LEU A  42     -24.355  67.621  33.398  1.00  0.00           C  
ATOM    618  CD1 LEU A  42     -24.144  68.744  34.401  1.00  0.00           C  
ATOM    619  CD2 LEU A  42     -24.968  66.404  34.076  1.00  0.00           C  
ATOM    620  H   LEU A  42     -22.804  68.234  30.333  1.00  0.00           H  
ATOM    621  HA  LEU A  42     -25.332  69.521  30.650  1.00  0.00           H  
ATOM    622  HB2 LEU A  42     -26.074  68.631  32.665  1.00  0.00           H  
ATOM    623  HB3 LEU A  42     -25.603  67.218  31.723  1.00  0.00           H  
ATOM    624  HG  LEU A  42     -23.387  67.337  33.008  1.00  0.00           H  
ATOM    625 HD11 LEU A  42     -24.536  68.445  35.362  1.00  0.00           H  
ATOM    626 HD12 LEU A  42     -24.658  69.631  34.063  1.00  0.00           H  
ATOM    627 HD13 LEU A  42     -23.087  68.952  34.492  1.00  0.00           H  
ATOM    628 HD21 LEU A  42     -24.290  66.034  34.830  1.00  0.00           H  
ATOM    629 HD22 LEU A  42     -25.143  65.633  33.340  1.00  0.00           H  
ATOM    630 HD23 LEU A  42     -25.903  66.682  34.537  1.00  0.00           H  
ATOM    631  N   VAL A  43     -24.276  71.196  32.207  1.00  0.00           N  
ATOM    632  CA  VAL A  43     -23.553  72.265  32.885  1.00  0.00           C  
ATOM    633  C   VAL A  43     -24.000  72.398  34.336  1.00  0.00           C  
ATOM    634  O   VAL A  43     -25.192  72.320  34.639  1.00  0.00           O  
ATOM    635  CB  VAL A  43     -23.751  73.617  32.173  1.00  0.00           C  
ATOM    636  CG1 VAL A  43     -23.048  74.729  32.935  1.00  0.00           C  
ATOM    637  CG2 VAL A  43     -23.247  73.541  30.739  1.00  0.00           C  
ATOM    638  H   VAL A  43     -25.214  71.337  31.958  1.00  0.00           H  
ATOM    639  HA  VAL A  43     -22.500  72.022  32.864  1.00  0.00           H  
ATOM    640  HB  VAL A  43     -24.808  73.837  32.150  1.00  0.00           H  
ATOM    641 HG11 VAL A  43     -21.998  74.730  32.685  1.00  0.00           H  
ATOM    642 HG12 VAL A  43     -23.484  75.681  32.666  1.00  0.00           H  
ATOM    643 HG13 VAL A  43     -23.165  74.568  33.996  1.00  0.00           H  
ATOM    644 HG21 VAL A  43     -22.302  74.057  30.663  1.00  0.00           H  
ATOM    645 HG22 VAL A  43     -23.116  72.506  30.457  1.00  0.00           H  
ATOM    646 HG23 VAL A  43     -23.966  74.005  30.080  1.00  0.00           H  
ATOM    647  N   ARG A  44     -23.038  72.599  35.230  1.00  0.00           N  
ATOM    648  CA  ARG A  44     -23.333  72.742  36.651  1.00  0.00           C  
ATOM    649  C   ARG A  44     -22.459  73.821  37.282  1.00  0.00           C  
ATOM    650  O   ARG A  44     -21.290  73.990  36.934  1.00  0.00           O  
ATOM    651  CB  ARG A  44     -23.120  71.410  37.374  1.00  0.00           C  
ATOM    652  CG  ARG A  44     -21.684  70.912  37.323  1.00  0.00           C  
ATOM    653  CD  ARG A  44     -21.490  69.686  38.201  1.00  0.00           C  
ATOM    654  NE  ARG A  44     -21.807  69.958  39.600  1.00  0.00           N  
ATOM    655  CZ  ARG A  44     -23.033  69.873  40.104  1.00  0.00           C  
ATOM    656  NH1 ARG A  44     -24.050  69.525  39.329  1.00  0.00           N  
ATOM    657  NH2 ARG A  44     -23.244  70.136  41.388  1.00  0.00           N  
ATOM    658  H   ARG A  44     -22.107  72.650  34.928  1.00  0.00           H  
ATOM    659  HA  ARG A  44     -24.368  73.032  36.748  1.00  0.00           H  
ATOM    660  HB2 ARG A  44     -23.400  71.528  38.411  1.00  0.00           H  
ATOM    661  HB3 ARG A  44     -23.754  70.663  36.921  1.00  0.00           H  
ATOM    662  HG2 ARG A  44     -21.439  70.654  36.304  1.00  0.00           H  
ATOM    663  HG3 ARG A  44     -21.028  71.699  37.666  1.00  0.00           H  
ATOM    664  HD2 ARG A  44     -22.133  68.897  37.842  1.00  0.00           H  
ATOM    665  HD3 ARG A  44     -20.459  69.370  38.130  1.00  0.00           H  
ATOM    666  HE  ARG A  44     -21.070  70.217  40.191  1.00  0.00           H  
ATOM    667 HH11 ARG A  44     -23.895  69.325  38.362  1.00  0.00           H  
ATOM    668 HH12 ARG A  44     -24.972  69.461  39.712  1.00  0.00           H  
ATOM    669 HH21 ARG A  44     -22.479  70.398  41.976  1.00  0.00           H  
ATOM    670 HH22 ARG A  44     -24.166  70.072  41.767  1.00  0.00           H  
ATOM    671  N   PRO A  45     -23.036  74.571  38.231  1.00  0.00           N  
ATOM    672  CA  PRO A  45     -22.329  75.647  38.931  1.00  0.00           C  
ATOM    673  C   PRO A  45     -21.249  75.117  39.869  1.00  0.00           C  
ATOM    674  O   PRO A  45     -21.536  74.357  40.794  1.00  0.00           O  
ATOM    675  CB  PRO A  45     -23.436  76.341  39.729  1.00  0.00           C  
ATOM    676  CG  PRO A  45     -24.476  75.292  39.925  1.00  0.00           C  
ATOM    677  CD  PRO A  45     -24.426  74.426  38.697  1.00  0.00           C  
ATOM    678  HA  PRO A  45     -21.888  76.348  38.238  1.00  0.00           H  
ATOM    679  HB2 PRO A  45     -23.040  76.688  40.673  1.00  0.00           H  
ATOM    680  HB3 PRO A  45     -23.821  77.177  39.164  1.00  0.00           H  
ATOM    681  HG2 PRO A  45     -24.248  74.709  40.804  1.00  0.00           H  
ATOM    682  HG3 PRO A  45     -25.448  75.753  40.019  1.00  0.00           H  
ATOM    683  HD2 PRO A  45     -24.643  73.399  38.951  1.00  0.00           H  
ATOM    684  HD3 PRO A  45     -25.121  74.787  37.952  1.00  0.00           H  
ATOM    685  N   SER A  46     -20.008  75.523  39.625  1.00  0.00           N  
ATOM    686  CA  SER A  46     -18.885  75.086  40.446  1.00  0.00           C  
ATOM    687  C   SER A  46     -19.164  75.338  41.925  1.00  0.00           C  
ATOM    688  O   SER A  46     -19.260  76.483  42.364  1.00  0.00           O  
ATOM    689  CB  SER A  46     -17.605  75.813  40.027  1.00  0.00           C  
ATOM    690  OG  SER A  46     -16.985  75.162  38.931  1.00  0.00           O  
ATOM    691  H   SER A  46     -19.842  76.130  38.872  1.00  0.00           H  
ATOM    692  HA  SER A  46     -18.754  74.025  40.291  1.00  0.00           H  
ATOM    693  HB2 SER A  46     -17.847  76.825  39.738  1.00  0.00           H  
ATOM    694  HB3 SER A  46     -16.915  75.830  40.858  1.00  0.00           H  
ATOM    695  HG  SER A  46     -17.659  74.782  38.362  1.00  0.00           H  
ATOM    696  N   ASP A  47     -19.293  74.257  42.687  1.00  0.00           N  
ATOM    697  CA  ASP A  47     -19.559  74.357  44.117  1.00  0.00           C  
ATOM    698  C   ASP A  47     -18.341  74.898  44.861  1.00  0.00           C  
ATOM    699  O   ASP A  47     -18.354  76.024  45.357  1.00  0.00           O  
ATOM    700  CB  ASP A  47     -19.951  72.992  44.682  1.00  0.00           C  
ATOM    701  CG  ASP A  47     -21.445  72.741  44.603  1.00  0.00           C  
ATOM    702  OD1 ASP A  47     -22.093  73.298  43.693  1.00  0.00           O  
ATOM    703  OD2 ASP A  47     -21.964  71.986  45.452  1.00  0.00           O  
ATOM    704  H   ASP A  47     -19.205  73.370  42.278  1.00  0.00           H  
ATOM    705  HA  ASP A  47     -20.382  75.044  44.254  1.00  0.00           H  
ATOM    706  HB2 ASP A  47     -19.445  72.219  44.122  1.00  0.00           H  
ATOM    707  HB3 ASP A  47     -19.649  72.937  45.717  1.00  0.00           H  
ATOM    708  N   ASN A  48     -17.291  74.087  44.934  1.00  0.00           N  
ATOM    709  CA  ASN A  48     -16.065  74.483  45.618  1.00  0.00           C  
ATOM    710  C   ASN A  48     -15.673  75.910  45.247  1.00  0.00           C  
ATOM    711  O   ASN A  48     -14.982  76.593  46.004  1.00  0.00           O  
ATOM    712  CB  ASN A  48     -14.928  73.522  45.268  1.00  0.00           C  
ATOM    713  CG  ASN A  48     -14.699  73.417  43.773  1.00  0.00           C  
ATOM    714  OD1 ASN A  48     -14.567  74.427  43.081  1.00  0.00           O  
ATOM    715  ND2 ASN A  48     -14.651  72.190  43.267  1.00  0.00           N  
ATOM    716  H   ASN A  48     -17.341  73.201  44.518  1.00  0.00           H  
ATOM    717  HA  ASN A  48     -16.249  74.437  46.680  1.00  0.00           H  
ATOM    718  HB2 ASN A  48     -14.015  73.871  45.729  1.00  0.00           H  
ATOM    719  HB3 ASN A  48     -15.165  72.539  45.647  1.00  0.00           H  
ATOM    720 HD21 ASN A  48     -14.764  71.432  43.878  1.00  0.00           H  
ATOM    721 HD22 ASN A  48     -14.503  72.093  42.303  1.00  0.00           H  
ATOM    722  N   THR A  49     -16.118  76.355  44.076  1.00  0.00           N  
ATOM    723  CA  THR A  49     -15.812  77.700  43.604  1.00  0.00           C  
ATOM    724  C   THR A  49     -17.074  78.421  43.146  1.00  0.00           C  
ATOM    725  O   THR A  49     -17.521  78.281  42.007  1.00  0.00           O  
ATOM    726  CB  THR A  49     -14.801  77.672  42.442  1.00  0.00           C  
ATOM    727  OG1 THR A  49     -13.534  77.194  42.907  1.00  0.00           O  
ATOM    728  CG2 THR A  49     -14.635  79.057  41.835  1.00  0.00           C  
ATOM    729  H   THR A  49     -16.663  75.764  43.517  1.00  0.00           H  
ATOM    730  HA  THR A  49     -15.372  78.249  44.424  1.00  0.00           H  
ATOM    731  HB  THR A  49     -15.172  77.003  41.679  1.00  0.00           H  
ATOM    732  HG1 THR A  49     -13.414  77.447  43.826  1.00  0.00           H  
ATOM    733 HG21 THR A  49     -13.646  79.147  41.410  1.00  0.00           H  
ATOM    734 HG22 THR A  49     -14.766  79.805  42.603  1.00  0.00           H  
ATOM    735 HG23 THR A  49     -15.374  79.202  41.062  1.00  0.00           H  
ATOM    736  N   PRO A  50     -17.665  79.214  44.053  1.00  0.00           N  
ATOM    737  CA  PRO A  50     -18.885  79.975  43.764  1.00  0.00           C  
ATOM    738  C   PRO A  50     -18.638  81.116  42.784  1.00  0.00           C  
ATOM    739  O   PRO A  50     -18.300  82.229  43.185  1.00  0.00           O  
ATOM    740  CB  PRO A  50     -19.293  80.525  45.133  1.00  0.00           C  
ATOM    741  CG  PRO A  50     -18.024  80.583  45.911  1.00  0.00           C  
ATOM    742  CD  PRO A  50     -17.190  79.428  45.430  1.00  0.00           C  
ATOM    743  HA  PRO A  50     -19.669  79.337  43.383  1.00  0.00           H  
ATOM    744  HB2 PRO A  50     -19.730  81.506  45.014  1.00  0.00           H  
ATOM    745  HB3 PRO A  50     -20.007  79.860  45.594  1.00  0.00           H  
ATOM    746  HG2 PRO A  50     -17.518  81.517  45.720  1.00  0.00           H  
ATOM    747  HG3 PRO A  50     -18.234  80.478  46.965  1.00  0.00           H  
ATOM    748  HD2 PRO A  50     -16.142  79.690  45.439  1.00  0.00           H  
ATOM    749  HD3 PRO A  50     -17.367  78.554  46.039  1.00  0.00           H  
ATOM    750  N   GLY A  51     -18.809  80.832  41.496  1.00  0.00           N  
ATOM    751  CA  GLY A  51     -18.601  81.845  40.479  1.00  0.00           C  
ATOM    752  C   GLY A  51     -18.115  81.260  39.168  1.00  0.00           C  
ATOM    753  O   GLY A  51     -18.076  81.949  38.149  1.00  0.00           O  
ATOM    754  H   GLY A  51     -19.080  79.927  41.235  1.00  0.00           H  
ATOM    755  HA2 GLY A  51     -19.531  82.364  40.306  1.00  0.00           H  
ATOM    756  HA3 GLY A  51     -17.867  82.553  40.837  1.00  0.00           H  
ATOM    757  N   ASP A  52     -17.742  79.985  39.194  1.00  0.00           N  
ATOM    758  CA  ASP A  52     -17.256  79.307  37.998  1.00  0.00           C  
ATOM    759  C   ASP A  52     -18.237  78.229  37.547  1.00  0.00           C  
ATOM    760  O   ASP A  52     -19.324  78.090  38.110  1.00  0.00           O  
ATOM    761  CB  ASP A  52     -15.883  78.686  38.261  1.00  0.00           C  
ATOM    762  CG  ASP A  52     -14.748  79.651  37.981  1.00  0.00           C  
ATOM    763  OD1 ASP A  52     -14.840  80.817  38.419  1.00  0.00           O  
ATOM    764  OD2 ASP A  52     -13.768  79.241  37.324  1.00  0.00           O  
ATOM    765  H   ASP A  52     -17.796  79.488  40.037  1.00  0.00           H  
ATOM    766  HA  ASP A  52     -17.164  80.042  37.213  1.00  0.00           H  
ATOM    767  HB2 ASP A  52     -15.825  78.381  39.295  1.00  0.00           H  
ATOM    768  HB3 ASP A  52     -15.760  77.820  37.627  1.00  0.00           H  
ATOM    769  N   TYR A  53     -17.847  77.470  36.529  1.00  0.00           N  
ATOM    770  CA  TYR A  53     -18.695  76.407  36.000  1.00  0.00           C  
ATOM    771  C   TYR A  53     -17.856  75.213  35.555  1.00  0.00           C  
ATOM    772  O   TYR A  53     -16.636  75.311  35.425  1.00  0.00           O  
ATOM    773  CB  TYR A  53     -19.527  76.926  34.827  1.00  0.00           C  
ATOM    774  CG  TYR A  53     -20.520  77.998  35.215  1.00  0.00           C  
ATOM    775  CD1 TYR A  53     -20.137  79.330  35.299  1.00  0.00           C  
ATOM    776  CD2 TYR A  53     -21.842  77.677  35.498  1.00  0.00           C  
ATOM    777  CE1 TYR A  53     -21.041  80.313  35.655  1.00  0.00           C  
ATOM    778  CE2 TYR A  53     -22.754  78.653  35.853  1.00  0.00           C  
ATOM    779  CZ  TYR A  53     -22.348  79.969  35.930  1.00  0.00           C  
ATOM    780  OH  TYR A  53     -23.252  80.944  36.283  1.00  0.00           O  
ATOM    781  H   TYR A  53     -16.971  77.629  36.122  1.00  0.00           H  
ATOM    782  HA  TYR A  53     -19.361  76.091  36.790  1.00  0.00           H  
ATOM    783  HB2 TYR A  53     -18.867  77.341  34.082  1.00  0.00           H  
ATOM    784  HB3 TYR A  53     -20.078  76.103  34.394  1.00  0.00           H  
ATOM    785  HD1 TYR A  53     -19.113  79.595  35.082  1.00  0.00           H  
ATOM    786  HD2 TYR A  53     -22.157  76.645  35.436  1.00  0.00           H  
ATOM    787  HE1 TYR A  53     -20.724  81.344  35.715  1.00  0.00           H  
ATOM    788  HE2 TYR A  53     -23.777  78.384  36.069  1.00  0.00           H  
ATOM    789  HH  TYR A  53     -23.024  81.767  35.842  1.00  0.00           H  
ATOM    790  N   SER A  54     -18.521  74.086  35.323  1.00  0.00           N  
ATOM    791  CA  SER A  54     -17.838  72.870  34.896  1.00  0.00           C  
ATOM    792  C   SER A  54     -18.745  72.019  34.014  1.00  0.00           C  
ATOM    793  O   SER A  54     -19.892  71.740  34.367  1.00  0.00           O  
ATOM    794  CB  SER A  54     -17.384  72.060  36.112  1.00  0.00           C  
ATOM    795  OG  SER A  54     -18.305  72.187  37.182  1.00  0.00           O  
ATOM    796  H   SER A  54     -19.493  74.070  35.445  1.00  0.00           H  
ATOM    797  HA  SER A  54     -16.969  73.161  34.324  1.00  0.00           H  
ATOM    798  HB2 SER A  54     -17.310  71.019  35.840  1.00  0.00           H  
ATOM    799  HB3 SER A  54     -16.418  72.417  36.438  1.00  0.00           H  
ATOM    800  HG  SER A  54     -17.831  72.161  38.016  1.00  0.00           H  
ATOM    801  N   LEU A  55     -18.225  71.608  32.862  1.00  0.00           N  
ATOM    802  CA  LEU A  55     -18.987  70.789  31.927  1.00  0.00           C  
ATOM    803  C   LEU A  55     -18.719  69.305  32.160  1.00  0.00           C  
ATOM    804  O   LEU A  55     -17.580  68.898  32.392  1.00  0.00           O  
ATOM    805  CB  LEU A  55     -18.634  71.161  30.486  1.00  0.00           C  
ATOM    806  CG  LEU A  55     -19.686  70.825  29.428  1.00  0.00           C  
ATOM    807  CD1 LEU A  55     -20.648  71.987  29.244  1.00  0.00           C  
ATOM    808  CD2 LEU A  55     -19.019  70.466  28.108  1.00  0.00           C  
ATOM    809  H   LEU A  55     -17.306  71.862  32.635  1.00  0.00           H  
ATOM    810  HA  LEU A  55     -20.036  70.983  32.093  1.00  0.00           H  
ATOM    811  HB2 LEU A  55     -18.462  72.226  30.452  1.00  0.00           H  
ATOM    812  HB3 LEU A  55     -17.722  70.642  30.225  1.00  0.00           H  
ATOM    813  HG  LEU A  55     -20.257  69.968  29.758  1.00  0.00           H  
ATOM    814 HD11 LEU A  55     -21.017  72.305  30.206  1.00  0.00           H  
ATOM    815 HD12 LEU A  55     -21.477  71.673  28.626  1.00  0.00           H  
ATOM    816 HD13 LEU A  55     -20.133  72.808  28.765  1.00  0.00           H  
ATOM    817 HD21 LEU A  55     -19.506  70.997  27.304  1.00  0.00           H  
ATOM    818 HD22 LEU A  55     -19.102  69.402  27.940  1.00  0.00           H  
ATOM    819 HD23 LEU A  55     -17.976  70.744  28.145  1.00  0.00           H  
ATOM    820  N   TYR A  56     -19.776  68.501  32.096  1.00  0.00           N  
ATOM    821  CA  TYR A  56     -19.654  67.063  32.300  1.00  0.00           C  
ATOM    822  C   TYR A  56     -20.148  66.295  31.078  1.00  0.00           C  
ATOM    823  O   TYR A  56     -21.351  66.199  30.835  1.00  0.00           O  
ATOM    824  CB  TYR A  56     -20.444  66.635  33.538  1.00  0.00           C  
ATOM    825  CG  TYR A  56     -19.778  67.014  34.842  1.00  0.00           C  
ATOM    826  CD1 TYR A  56     -19.603  68.346  35.193  1.00  0.00           C  
ATOM    827  CD2 TYR A  56     -19.325  66.039  35.722  1.00  0.00           C  
ATOM    828  CE1 TYR A  56     -18.995  68.697  36.383  1.00  0.00           C  
ATOM    829  CE2 TYR A  56     -18.718  66.380  36.915  1.00  0.00           C  
ATOM    830  CZ  TYR A  56     -18.554  67.710  37.241  1.00  0.00           C  
ATOM    831  OH  TYR A  56     -17.948  68.055  38.427  1.00  0.00           O  
ATOM    832  H   TYR A  56     -20.657  68.884  31.908  1.00  0.00           H  
ATOM    833  HA  TYR A  56     -18.610  66.837  32.456  1.00  0.00           H  
ATOM    834  HB2 TYR A  56     -21.417  67.101  33.516  1.00  0.00           H  
ATOM    835  HB3 TYR A  56     -20.565  65.560  33.526  1.00  0.00           H  
ATOM    836  HD1 TYR A  56     -19.950  69.117  34.519  1.00  0.00           H  
ATOM    837  HD2 TYR A  56     -19.453  64.998  35.463  1.00  0.00           H  
ATOM    838  HE1 TYR A  56     -18.868  69.739  36.639  1.00  0.00           H  
ATOM    839  HE2 TYR A  56     -18.372  65.608  37.586  1.00  0.00           H  
ATOM    840  HH  TYR A  56     -17.095  68.456  38.246  1.00  0.00           H  
ATOM    841  N   PHE A  57     -19.210  65.750  30.311  1.00  0.00           N  
ATOM    842  CA  PHE A  57     -19.547  64.990  29.113  1.00  0.00           C  
ATOM    843  C   PHE A  57     -19.445  63.491  29.372  1.00  0.00           C  
ATOM    844  O   PHE A  57     -18.645  63.046  30.195  1.00  0.00           O  
ATOM    845  CB  PHE A  57     -18.624  65.384  27.957  1.00  0.00           C  
ATOM    846  CG  PHE A  57     -19.042  64.809  26.634  1.00  0.00           C  
ATOM    847  CD1 PHE A  57     -20.374  64.814  26.251  1.00  0.00           C  
ATOM    848  CD2 PHE A  57     -18.103  64.263  25.774  1.00  0.00           C  
ATOM    849  CE1 PHE A  57     -20.761  64.285  25.034  1.00  0.00           C  
ATOM    850  CE2 PHE A  57     -18.484  63.733  24.556  1.00  0.00           C  
ATOM    851  CZ  PHE A  57     -19.816  63.743  24.185  1.00  0.00           C  
ATOM    852  H   PHE A  57     -18.267  65.861  30.557  1.00  0.00           H  
ATOM    853  HA  PHE A  57     -20.565  65.229  28.846  1.00  0.00           H  
ATOM    854  HB2 PHE A  57     -18.615  66.460  27.862  1.00  0.00           H  
ATOM    855  HB3 PHE A  57     -17.625  65.037  28.171  1.00  0.00           H  
ATOM    856  HD1 PHE A  57     -21.115  65.237  26.915  1.00  0.00           H  
ATOM    857  HD2 PHE A  57     -17.062  64.253  26.062  1.00  0.00           H  
ATOM    858  HE1 PHE A  57     -21.802  64.295  24.748  1.00  0.00           H  
ATOM    859  HE2 PHE A  57     -17.743  63.310  23.894  1.00  0.00           H  
ATOM    860  HZ  PHE A  57     -20.116  63.331  23.234  1.00  0.00           H  
ATOM    861  N   ARG A  58     -20.260  62.716  28.664  1.00  0.00           N  
ATOM    862  CA  ARG A  58     -20.264  61.267  28.819  1.00  0.00           C  
ATOM    863  C   ARG A  58     -19.856  60.581  27.518  1.00  0.00           C  
ATOM    864  O   ARG A  58     -20.450  60.817  26.466  1.00  0.00           O  
ATOM    865  CB  ARG A  58     -21.648  60.782  29.252  1.00  0.00           C  
ATOM    866  CG  ARG A  58     -21.830  59.278  29.137  1.00  0.00           C  
ATOM    867  CD  ARG A  58     -21.125  58.543  30.266  1.00  0.00           C  
ATOM    868  NE  ARG A  58     -21.098  57.099  30.047  1.00  0.00           N  
ATOM    869  CZ  ARG A  58     -22.174  56.323  30.133  1.00  0.00           C  
ATOM    870  NH1 ARG A  58     -23.353  56.849  30.431  1.00  0.00           N  
ATOM    871  NH2 ARG A  58     -22.069  55.017  29.921  1.00  0.00           N  
ATOM    872  H   ARG A  58     -20.876  63.130  28.023  1.00  0.00           H  
ATOM    873  HA  ARG A  58     -19.548  61.013  29.585  1.00  0.00           H  
ATOM    874  HB2 ARG A  58     -21.810  61.064  30.283  1.00  0.00           H  
ATOM    875  HB3 ARG A  58     -22.394  61.261  28.635  1.00  0.00           H  
ATOM    876  HG2 ARG A  58     -22.885  59.047  29.176  1.00  0.00           H  
ATOM    877  HG3 ARG A  58     -21.422  58.946  28.193  1.00  0.00           H  
ATOM    878  HD2 ARG A  58     -20.110  58.905  30.335  1.00  0.00           H  
ATOM    879  HD3 ARG A  58     -21.644  58.749  31.190  1.00  0.00           H  
ATOM    880  HE  ARG A  58     -20.237  56.689  29.826  1.00  0.00           H  
ATOM    881 HH11 ARG A  58     -23.435  57.833  30.590  1.00  0.00           H  
ATOM    882 HH12 ARG A  58     -24.161  56.263  30.493  1.00  0.00           H  
ATOM    883 HH21 ARG A  58     -21.181  54.617  29.696  1.00  0.00           H  
ATOM    884 HH22 ARG A  58     -22.878  54.434  29.985  1.00  0.00           H  
ATOM    885  N   THR A  59     -18.839  59.729  27.598  1.00  0.00           N  
ATOM    886  CA  THR A  59     -18.351  59.010  26.428  1.00  0.00           C  
ATOM    887  C   THR A  59     -18.288  57.509  26.692  1.00  0.00           C  
ATOM    888  O   THR A  59     -18.065  57.077  27.822  1.00  0.00           O  
ATOM    889  CB  THR A  59     -16.954  59.504  26.007  1.00  0.00           C  
ATOM    890  OG1 THR A  59     -16.033  59.354  27.094  1.00  0.00           O  
ATOM    891  CG2 THR A  59     -17.003  60.962  25.576  1.00  0.00           C  
ATOM    892  H   THR A  59     -18.406  59.583  28.465  1.00  0.00           H  
ATOM    893  HA  THR A  59     -19.036  59.194  25.614  1.00  0.00           H  
ATOM    894  HB  THR A  59     -16.615  58.909  25.172  1.00  0.00           H  
ATOM    895  HG1 THR A  59     -16.058  60.138  27.646  1.00  0.00           H  
ATOM    896 HG21 THR A  59     -17.130  61.591  26.446  1.00  0.00           H  
ATOM    897 HG22 THR A  59     -17.833  61.110  24.900  1.00  0.00           H  
ATOM    898 HG23 THR A  59     -16.083  61.221  25.077  1.00  0.00           H  
ATOM    899  N   ASN A  60     -18.485  56.720  25.642  1.00  0.00           N  
ATOM    900  CA  ASN A  60     -18.451  55.267  25.760  1.00  0.00           C  
ATOM    901  C   ASN A  60     -17.286  54.821  26.638  1.00  0.00           C  
ATOM    902  O   ASN A  60     -17.381  53.823  27.351  1.00  0.00           O  
ATOM    903  CB  ASN A  60     -18.338  54.624  24.377  1.00  0.00           C  
ATOM    904  CG  ASN A  60     -17.546  55.478  23.406  1.00  0.00           C  
ATOM    905  OD1 ASN A  60     -16.350  55.703  23.592  1.00  0.00           O  
ATOM    906  ND2 ASN A  60     -18.212  55.958  22.362  1.00  0.00           N  
ATOM    907  H   ASN A  60     -18.660  57.124  24.766  1.00  0.00           H  
ATOM    908  HA  ASN A  60     -19.374  54.950  26.220  1.00  0.00           H  
ATOM    909  HB2 ASN A  60     -17.843  53.668  24.470  1.00  0.00           H  
ATOM    910  HB3 ASN A  60     -19.327  54.475  23.973  1.00  0.00           H  
ATOM    911 HD21 ASN A  60     -19.163  55.737  22.277  1.00  0.00           H  
ATOM    912 HD22 ASN A  60     -17.724  56.513  21.717  1.00  0.00           H  
ATOM    913  N   GLU A  61     -16.188  55.567  26.579  1.00  0.00           N  
ATOM    914  CA  GLU A  61     -15.004  55.247  27.369  1.00  0.00           C  
ATOM    915  C   GLU A  61     -15.233  55.561  28.844  1.00  0.00           C  
ATOM    916  O   GLU A  61     -15.247  54.663  29.686  1.00  0.00           O  
ATOM    917  CB  GLU A  61     -13.793  56.028  26.852  1.00  0.00           C  
ATOM    918  CG  GLU A  61     -13.072  55.342  25.704  1.00  0.00           C  
ATOM    919  CD  GLU A  61     -12.472  54.008  26.105  1.00  0.00           C  
ATOM    920  OE1 GLU A  61     -11.393  54.007  26.734  1.00  0.00           O  
ATOM    921  OE2 GLU A  61     -13.081  52.966  25.789  1.00  0.00           O  
ATOM    922  H   GLU A  61     -16.172  56.351  25.991  1.00  0.00           H  
ATOM    923  HA  GLU A  61     -14.811  54.190  27.264  1.00  0.00           H  
ATOM    924  HB2 GLU A  61     -14.123  56.999  26.515  1.00  0.00           H  
ATOM    925  HB3 GLU A  61     -13.091  56.157  27.663  1.00  0.00           H  
ATOM    926  HG2 GLU A  61     -13.776  55.176  24.902  1.00  0.00           H  
ATOM    927  HG3 GLU A  61     -12.279  55.988  25.358  1.00  0.00           H  
ATOM    928  N   ASN A  62     -15.412  56.842  29.150  1.00  0.00           N  
ATOM    929  CA  ASN A  62     -15.640  57.276  30.523  1.00  0.00           C  
ATOM    930  C   ASN A  62     -16.148  58.714  30.563  1.00  0.00           C  
ATOM    931  O   ASN A  62     -16.186  59.398  29.540  1.00  0.00           O  
ATOM    932  CB  ASN A  62     -14.351  57.156  31.339  1.00  0.00           C  
ATOM    933  CG  ASN A  62     -14.616  57.033  32.826  1.00  0.00           C  
ATOM    934  OD1 ASN A  62     -14.216  57.892  33.612  1.00  0.00           O  
ATOM    935  ND2 ASN A  62     -15.294  55.961  33.220  1.00  0.00           N  
ATOM    936  H   ASN A  62     -15.391  57.512  28.435  1.00  0.00           H  
ATOM    937  HA  ASN A  62     -16.390  56.630  30.955  1.00  0.00           H  
ATOM    938  HB2 ASN A  62     -13.808  56.279  31.016  1.00  0.00           H  
ATOM    939  HB3 ASN A  62     -13.742  58.031  31.171  1.00  0.00           H  
ATOM    940 HD21 ASN A  62     -15.581  55.318  32.538  1.00  0.00           H  
ATOM    941 HD22 ASN A  62     -15.481  55.857  34.176  1.00  0.00           H  
ATOM    942  N   ILE A  63     -16.537  59.165  31.751  1.00  0.00           N  
ATOM    943  CA  ILE A  63     -17.041  60.523  31.924  1.00  0.00           C  
ATOM    944  C   ILE A  63     -15.899  61.510  32.134  1.00  0.00           C  
ATOM    945  O   ILE A  63     -15.015  61.286  32.961  1.00  0.00           O  
ATOM    946  CB  ILE A  63     -18.010  60.615  33.117  1.00  0.00           C  
ATOM    947  CG1 ILE A  63     -19.294  59.837  32.821  1.00  0.00           C  
ATOM    948  CG2 ILE A  63     -18.327  62.070  33.431  1.00  0.00           C  
ATOM    949  CD1 ILE A  63     -20.021  59.376  34.065  1.00  0.00           C  
ATOM    950  H   ILE A  63     -16.483  58.573  32.529  1.00  0.00           H  
ATOM    951  HA  ILE A  63     -17.579  60.795  31.027  1.00  0.00           H  
ATOM    952  HB  ILE A  63     -17.526  60.182  33.980  1.00  0.00           H  
ATOM    953 HG12 ILE A  63     -19.967  60.465  32.258  1.00  0.00           H  
ATOM    954 HG13 ILE A  63     -19.049  58.962  32.235  1.00  0.00           H  
ATOM    955 HG21 ILE A  63     -19.353  62.153  33.754  1.00  0.00           H  
ATOM    956 HG22 ILE A  63     -17.673  62.418  34.217  1.00  0.00           H  
ATOM    957 HG23 ILE A  63     -18.179  62.670  32.545  1.00  0.00           H  
ATOM    958 HD11 ILE A  63     -19.472  59.689  34.940  1.00  0.00           H  
ATOM    959 HD12 ILE A  63     -21.010  59.807  34.084  1.00  0.00           H  
ATOM    960 HD13 ILE A  63     -20.100  58.298  34.056  1.00  0.00           H  
ATOM    961  N   GLN A  64     -15.924  62.605  31.379  1.00  0.00           N  
ATOM    962  CA  GLN A  64     -14.890  63.628  31.483  1.00  0.00           C  
ATOM    963  C   GLN A  64     -15.387  64.823  32.289  1.00  0.00           C  
ATOM    964  O   GLN A  64     -16.494  64.804  32.829  1.00  0.00           O  
ATOM    965  CB  GLN A  64     -14.452  64.084  30.090  1.00  0.00           C  
ATOM    966  CG  GLN A  64     -14.191  62.936  29.129  1.00  0.00           C  
ATOM    967  CD  GLN A  64     -14.120  63.389  27.684  1.00  0.00           C  
ATOM    968  OE1 GLN A  64     -13.473  64.387  27.366  1.00  0.00           O  
ATOM    969  NE2 GLN A  64     -14.786  62.657  26.799  1.00  0.00           N  
ATOM    970  H   GLN A  64     -16.654  62.726  30.737  1.00  0.00           H  
ATOM    971  HA  GLN A  64     -14.044  63.193  31.993  1.00  0.00           H  
ATOM    972  HB2 GLN A  64     -15.225  64.709  29.669  1.00  0.00           H  
ATOM    973  HB3 GLN A  64     -13.543  64.660  30.183  1.00  0.00           H  
ATOM    974  HG2 GLN A  64     -13.252  62.470  29.390  1.00  0.00           H  
ATOM    975  HG3 GLN A  64     -14.989  62.214  29.225  1.00  0.00           H  
ATOM    976 HE21 GLN A  64     -15.281  61.875  27.125  1.00  0.00           H  
ATOM    977 HE22 GLN A  64     -14.758  62.927  25.859  1.00  0.00           H  
ATOM    978  N   ARG A  65     -14.563  65.863  32.367  1.00  0.00           N  
ATOM    979  CA  ARG A  65     -14.918  67.066  33.109  1.00  0.00           C  
ATOM    980  C   ARG A  65     -14.082  68.256  32.647  1.00  0.00           C  
ATOM    981  O   ARG A  65     -12.862  68.275  32.816  1.00  0.00           O  
ATOM    982  CB  ARG A  65     -14.722  66.843  34.609  1.00  0.00           C  
ATOM    983  CG  ARG A  65     -15.303  67.952  35.471  1.00  0.00           C  
ATOM    984  CD  ARG A  65     -14.630  68.009  36.834  1.00  0.00           C  
ATOM    985  NE  ARG A  65     -15.097  69.142  37.627  1.00  0.00           N  
ATOM    986  CZ  ARG A  65     -14.848  69.284  38.925  1.00  0.00           C  
ATOM    987  NH1 ARG A  65     -14.141  68.367  39.571  1.00  0.00           N  
ATOM    988  NH2 ARG A  65     -15.308  70.343  39.578  1.00  0.00           N  
ATOM    989  H   ARG A  65     -13.694  65.818  31.915  1.00  0.00           H  
ATOM    990  HA  ARG A  65     -15.959  67.277  32.919  1.00  0.00           H  
ATOM    991  HB2 ARG A  65     -15.196  65.914  34.888  1.00  0.00           H  
ATOM    992  HB3 ARG A  65     -13.665  66.774  34.815  1.00  0.00           H  
ATOM    993  HG2 ARG A  65     -15.159  68.898  34.971  1.00  0.00           H  
ATOM    994  HG3 ARG A  65     -16.359  67.772  35.608  1.00  0.00           H  
ATOM    995  HD2 ARG A  65     -14.847  67.095  37.367  1.00  0.00           H  
ATOM    996  HD3 ARG A  65     -13.564  68.098  36.690  1.00  0.00           H  
ATOM    997  HE  ARG A  65     -15.623  69.831  37.170  1.00  0.00           H  
ATOM    998 HH11 ARG A  65     -13.792  67.568  39.080  1.00  0.00           H  
ATOM    999 HH12 ARG A  65     -13.953  68.477  40.547  1.00  0.00           H  
ATOM   1000 HH21 ARG A  65     -15.842  71.035  39.095  1.00  0.00           H  
ATOM   1001 HH22 ARG A  65     -15.120  70.448  40.554  1.00  0.00           H  
ATOM   1002  N   PHE A  66     -14.746  69.248  32.062  1.00  0.00           N  
ATOM   1003  CA  PHE A  66     -14.064  70.441  31.575  1.00  0.00           C  
ATOM   1004  C   PHE A  66     -14.128  71.563  32.605  1.00  0.00           C  
ATOM   1005  O   PHE A  66     -14.889  71.494  33.570  1.00  0.00           O  
ATOM   1006  CB  PHE A  66     -14.687  70.907  30.257  1.00  0.00           C  
ATOM   1007  CG  PHE A  66     -14.456  69.958  29.115  1.00  0.00           C  
ATOM   1008  CD1 PHE A  66     -13.239  69.932  28.454  1.00  0.00           C  
ATOM   1009  CD2 PHE A  66     -15.457  69.092  28.704  1.00  0.00           C  
ATOM   1010  CE1 PHE A  66     -13.023  69.059  27.404  1.00  0.00           C  
ATOM   1011  CE2 PHE A  66     -15.247  68.218  27.655  1.00  0.00           C  
ATOM   1012  CZ  PHE A  66     -14.029  68.202  27.003  1.00  0.00           C  
ATOM   1013  H   PHE A  66     -15.717  69.175  31.955  1.00  0.00           H  
ATOM   1014  HA  PHE A  66     -13.030  70.184  31.402  1.00  0.00           H  
ATOM   1015  HB2 PHE A  66     -15.753  71.013  30.388  1.00  0.00           H  
ATOM   1016  HB3 PHE A  66     -14.264  71.863  29.986  1.00  0.00           H  
ATOM   1017  HD1 PHE A  66     -12.451  70.603  28.767  1.00  0.00           H  
ATOM   1018  HD2 PHE A  66     -16.410  69.104  29.212  1.00  0.00           H  
ATOM   1019  HE1 PHE A  66     -12.070  69.050  26.897  1.00  0.00           H  
ATOM   1020  HE2 PHE A  66     -16.035  67.549  27.343  1.00  0.00           H  
ATOM   1021  HZ  PHE A  66     -13.863  67.519  26.184  1.00  0.00           H  
ATOM   1022  N   LYS A  67     -13.322  72.599  32.394  1.00  0.00           N  
ATOM   1023  CA  LYS A  67     -13.285  73.738  33.303  1.00  0.00           C  
ATOM   1024  C   LYS A  67     -13.658  75.026  32.577  1.00  0.00           C  
ATOM   1025  O   LYS A  67     -13.069  75.363  31.549  1.00  0.00           O  
ATOM   1026  CB  LYS A  67     -11.894  73.876  33.927  1.00  0.00           C  
ATOM   1027  CG  LYS A  67     -10.831  74.335  32.944  1.00  0.00           C  
ATOM   1028  CD  LYS A  67      -9.449  74.330  33.576  1.00  0.00           C  
ATOM   1029  CE  LYS A  67      -9.192  75.606  34.364  1.00  0.00           C  
ATOM   1030  NZ  LYS A  67      -8.230  75.385  35.479  1.00  0.00           N  
ATOM   1031  H   LYS A  67     -12.738  72.597  31.607  1.00  0.00           H  
ATOM   1032  HA  LYS A  67     -14.005  73.560  34.088  1.00  0.00           H  
ATOM   1033  HB2 LYS A  67     -11.943  74.592  34.733  1.00  0.00           H  
ATOM   1034  HB3 LYS A  67     -11.596  72.917  34.326  1.00  0.00           H  
ATOM   1035  HG2 LYS A  67     -10.828  73.670  32.093  1.00  0.00           H  
ATOM   1036  HG3 LYS A  67     -11.065  75.339  32.618  1.00  0.00           H  
ATOM   1037  HD2 LYS A  67      -9.370  73.486  34.245  1.00  0.00           H  
ATOM   1038  HD3 LYS A  67      -8.706  74.245  32.795  1.00  0.00           H  
ATOM   1039  HE2 LYS A  67      -8.790  76.352  33.695  1.00  0.00           H  
ATOM   1040  HE3 LYS A  67     -10.129  75.956  34.772  1.00  0.00           H  
ATOM   1041  HZ1 LYS A  67      -8.558  74.606  36.084  1.00  0.00           H  
ATOM   1042  HZ2 LYS A  67      -8.148  76.246  36.056  1.00  0.00           H  
ATOM   1043  HZ3 LYS A  67      -7.292  75.143  35.099  1.00  0.00           H  
ATOM   1044  N   ILE A  68     -14.637  75.744  33.118  1.00  0.00           N  
ATOM   1045  CA  ILE A  68     -15.086  76.995  32.521  1.00  0.00           C  
ATOM   1046  C   ILE A  68     -14.928  78.156  33.497  1.00  0.00           C  
ATOM   1047  O   ILE A  68     -15.799  78.401  34.333  1.00  0.00           O  
ATOM   1048  CB  ILE A  68     -16.557  76.911  32.074  1.00  0.00           C  
ATOM   1049  CG1 ILE A  68     -16.748  75.758  31.087  1.00  0.00           C  
ATOM   1050  CG2 ILE A  68     -16.998  78.228  31.452  1.00  0.00           C  
ATOM   1051  CD1 ILE A  68     -18.189  75.544  30.679  1.00  0.00           C  
ATOM   1052  H   ILE A  68     -15.068  75.423  33.938  1.00  0.00           H  
ATOM   1053  HA  ILE A  68     -14.476  77.186  31.650  1.00  0.00           H  
ATOM   1054  HB  ILE A  68     -17.166  76.733  32.947  1.00  0.00           H  
ATOM   1055 HG12 ILE A  68     -16.177  75.959  30.194  1.00  0.00           H  
ATOM   1056 HG13 ILE A  68     -16.392  74.844  31.540  1.00  0.00           H  
ATOM   1057 HG21 ILE A  68     -16.527  78.345  30.486  1.00  0.00           H  
ATOM   1058 HG22 ILE A  68     -18.071  78.227  31.330  1.00  0.00           H  
ATOM   1059 HG23 ILE A  68     -16.709  79.045  32.095  1.00  0.00           H  
ATOM   1060 HD11 ILE A  68     -18.823  75.606  31.551  1.00  0.00           H  
ATOM   1061 HD12 ILE A  68     -18.478  76.303  29.967  1.00  0.00           H  
ATOM   1062 HD13 ILE A  68     -18.294  74.569  30.227  1.00  0.00           H  
ATOM   1063  N   CYS A  69     -13.813  78.870  33.383  1.00  0.00           N  
ATOM   1064  CA  CYS A  69     -13.541  80.007  34.255  1.00  0.00           C  
ATOM   1065  C   CYS A  69     -14.111  81.294  33.665  1.00  0.00           C  
ATOM   1066  O   CYS A  69     -14.073  81.521  32.456  1.00  0.00           O  
ATOM   1067  CB  CYS A  69     -12.036  80.158  34.478  1.00  0.00           C  
ATOM   1068  SG  CYS A  69     -11.347  78.992  35.676  1.00  0.00           S  
ATOM   1069  H   CYS A  69     -13.157  78.626  32.697  1.00  0.00           H  
ATOM   1070  HA  CYS A  69     -14.020  79.818  35.204  1.00  0.00           H  
ATOM   1071  HB2 CYS A  69     -11.524  80.003  33.539  1.00  0.00           H  
ATOM   1072  HB3 CYS A  69     -11.830  81.157  34.831  1.00  0.00           H  
ATOM   1073  HG  CYS A  69     -10.666  79.687  36.575  1.00  0.00           H  
ATOM   1074  N   PRO A  70     -14.655  82.155  34.537  1.00  0.00           N  
ATOM   1075  CA  PRO A  70     -15.245  83.432  34.126  1.00  0.00           C  
ATOM   1076  C   PRO A  70     -14.194  84.428  33.648  1.00  0.00           C  
ATOM   1077  O   PRO A  70     -13.068  84.447  34.146  1.00  0.00           O  
ATOM   1078  CB  PRO A  70     -15.920  83.939  35.404  1.00  0.00           C  
ATOM   1079  CG  PRO A  70     -15.164  83.293  36.513  1.00  0.00           C  
ATOM   1080  CD  PRO A  70     -14.735  81.948  35.993  1.00  0.00           C  
ATOM   1081  HA  PRO A  70     -15.988  83.296  33.354  1.00  0.00           H  
ATOM   1082  HB2 PRO A  70     -15.846  85.016  35.449  1.00  0.00           H  
ATOM   1083  HB3 PRO A  70     -16.958  83.644  35.407  1.00  0.00           H  
ATOM   1084  HG2 PRO A  70     -14.302  83.889  36.767  1.00  0.00           H  
ATOM   1085  HG3 PRO A  70     -15.807  83.174  37.373  1.00  0.00           H  
ATOM   1086  HD2 PRO A  70     -13.771  81.677  36.399  1.00  0.00           H  
ATOM   1087  HD3 PRO A  70     -15.472  81.197  36.236  1.00  0.00           H  
ATOM   1088  N   THR A  71     -14.569  85.257  32.678  1.00  0.00           N  
ATOM   1089  CA  THR A  71     -13.659  86.256  32.132  1.00  0.00           C  
ATOM   1090  C   THR A  71     -14.144  87.667  32.439  1.00  0.00           C  
ATOM   1091  O   THR A  71     -15.341  87.927  32.556  1.00  0.00           O  
ATOM   1092  CB  THR A  71     -13.503  86.099  30.606  1.00  0.00           C  
ATOM   1093  OG1 THR A  71     -14.767  86.292  29.962  1.00  0.00           O  
ATOM   1094  CG2 THR A  71     -12.955  84.724  30.258  1.00  0.00           C  
ATOM   1095  H   THR A  71     -15.480  85.194  32.322  1.00  0.00           H  
ATOM   1096  HA  THR A  71     -12.691  86.110  32.587  1.00  0.00           H  
ATOM   1097  HB  THR A  71     -12.809  86.847  30.252  1.00  0.00           H  
ATOM   1098  HG1 THR A  71     -15.474  86.047  30.564  1.00  0.00           H  
ATOM   1099 HG21 THR A  71     -13.669  84.197  29.641  1.00  0.00           H  
ATOM   1100 HG22 THR A  71     -12.782  84.164  31.165  1.00  0.00           H  
ATOM   1101 HG23 THR A  71     -12.027  84.834  29.718  1.00  0.00           H  
ATOM   1102  N   PRO A  72     -13.193  88.604  32.572  1.00  0.00           N  
ATOM   1103  CA  PRO A  72     -13.499  90.007  32.867  1.00  0.00           C  
ATOM   1104  C   PRO A  72     -14.168  90.713  31.692  1.00  0.00           C  
ATOM   1105  O   PRO A  72     -14.469  91.904  31.761  1.00  0.00           O  
ATOM   1106  CB  PRO A  72     -12.125  90.620  33.146  1.00  0.00           C  
ATOM   1107  CG  PRO A  72     -11.166  89.753  32.405  1.00  0.00           C  
ATOM   1108  CD  PRO A  72     -11.745  88.366  32.445  1.00  0.00           C  
ATOM   1109  HA  PRO A  72     -14.123  90.102  33.743  1.00  0.00           H  
ATOM   1110  HB2 PRO A  72     -12.101  91.638  32.784  1.00  0.00           H  
ATOM   1111  HB3 PRO A  72     -11.930  90.606  34.208  1.00  0.00           H  
ATOM   1112  HG2 PRO A  72     -11.077  90.093  31.385  1.00  0.00           H  
ATOM   1113  HG3 PRO A  72     -10.203  89.771  32.893  1.00  0.00           H  
ATOM   1114  HD2 PRO A  72     -11.521  87.837  31.531  1.00  0.00           H  
ATOM   1115  HD3 PRO A  72     -11.368  87.824  33.300  1.00  0.00           H  
ATOM   1116  N   ASN A  73     -14.398  89.970  30.614  1.00  0.00           N  
ATOM   1117  CA  ASN A  73     -15.031  90.526  29.423  1.00  0.00           C  
ATOM   1118  C   ASN A  73     -16.424  89.937  29.223  1.00  0.00           C  
ATOM   1119  O   ASN A  73     -16.838  89.666  28.097  1.00  0.00           O  
ATOM   1120  CB  ASN A  73     -14.169  90.258  28.189  1.00  0.00           C  
ATOM   1121  CG  ASN A  73     -12.802  90.909  28.285  1.00  0.00           C  
ATOM   1122  OD1 ASN A  73     -12.412  91.405  29.343  1.00  0.00           O  
ATOM   1123  ND2 ASN A  73     -12.068  90.910  27.179  1.00  0.00           N  
ATOM   1124  H   ASN A  73     -14.135  89.026  30.619  1.00  0.00           H  
ATOM   1125  HA  ASN A  73     -15.122  91.593  29.564  1.00  0.00           H  
ATOM   1126  HB2 ASN A  73     -14.031  89.191  28.078  1.00  0.00           H  
ATOM   1127  HB3 ASN A  73     -14.671  90.645  27.314  1.00  0.00           H  
ATOM   1128 HD21 ASN A  73     -12.443  90.497  26.374  1.00  0.00           H  
ATOM   1129 HD22 ASN A  73     -11.181  91.324  27.214  1.00  0.00           H  
ATOM   1130  N   ASN A  74     -17.143  89.741  30.324  1.00  0.00           N  
ATOM   1131  CA  ASN A  74     -18.489  89.183  30.268  1.00  0.00           C  
ATOM   1132  C   ASN A  74     -18.546  87.993  29.316  1.00  0.00           C  
ATOM   1133  O   ASN A  74     -19.399  87.936  28.430  1.00  0.00           O  
ATOM   1134  CB  ASN A  74     -19.489  90.253  29.827  1.00  0.00           C  
ATOM   1135  CG  ASN A  74     -20.877  90.015  30.388  1.00  0.00           C  
ATOM   1136  OD1 ASN A  74     -21.038  89.722  31.573  1.00  0.00           O  
ATOM   1137  ND2 ASN A  74     -21.888  90.137  29.537  1.00  0.00           N  
ATOM   1138  H   ASN A  74     -16.758  89.977  31.194  1.00  0.00           H  
ATOM   1139  HA  ASN A  74     -18.749  88.848  31.261  1.00  0.00           H  
ATOM   1140  HB2 ASN A  74     -19.147  91.221  30.167  1.00  0.00           H  
ATOM   1141  HB3 ASN A  74     -19.552  90.256  28.749  1.00  0.00           H  
ATOM   1142 HD21 ASN A  74     -21.686  90.373  28.607  1.00  0.00           H  
ATOM   1143 HD22 ASN A  74     -22.797  89.989  29.873  1.00  0.00           H  
ATOM   1144  N   GLN A  75     -17.633  87.046  29.505  1.00  0.00           N  
ATOM   1145  CA  GLN A  75     -17.581  85.857  28.662  1.00  0.00           C  
ATOM   1146  C   GLN A  75     -17.074  84.653  29.450  1.00  0.00           C  
ATOM   1147  O   GLN A  75     -16.735  84.767  30.629  1.00  0.00           O  
ATOM   1148  CB  GLN A  75     -16.680  86.105  27.452  1.00  0.00           C  
ATOM   1149  CG  GLN A  75     -17.314  86.992  26.393  1.00  0.00           C  
ATOM   1150  CD  GLN A  75     -16.361  87.323  25.261  1.00  0.00           C  
ATOM   1151  OE1 GLN A  75     -15.219  86.862  25.241  1.00  0.00           O  
ATOM   1152  NE2 GLN A  75     -16.825  88.125  24.310  1.00  0.00           N  
ATOM   1153  H   GLN A  75     -16.980  87.149  30.228  1.00  0.00           H  
ATOM   1154  HA  GLN A  75     -18.582  85.650  28.318  1.00  0.00           H  
ATOM   1155  HB2 GLN A  75     -15.768  86.575  27.786  1.00  0.00           H  
ATOM   1156  HB3 GLN A  75     -16.439  85.156  26.997  1.00  0.00           H  
ATOM   1157  HG2 GLN A  75     -18.173  86.484  25.982  1.00  0.00           H  
ATOM   1158  HG3 GLN A  75     -17.632  87.914  26.857  1.00  0.00           H  
ATOM   1159 HE21 GLN A  75     -17.746  88.454  24.392  1.00  0.00           H  
ATOM   1160 HE22 GLN A  75     -16.231  88.355  23.567  1.00  0.00           H  
ATOM   1161  N   PHE A  76     -17.025  83.501  28.792  1.00  0.00           N  
ATOM   1162  CA  PHE A  76     -16.562  82.274  29.432  1.00  0.00           C  
ATOM   1163  C   PHE A  76     -15.388  81.672  28.665  1.00  0.00           C  
ATOM   1164  O   PHE A  76     -15.306  81.787  27.442  1.00  0.00           O  
ATOM   1165  CB  PHE A  76     -17.702  81.258  29.521  1.00  0.00           C  
ATOM   1166  CG  PHE A  76     -18.806  81.676  30.450  1.00  0.00           C  
ATOM   1167  CD1 PHE A  76     -19.629  82.745  30.133  1.00  0.00           C  
ATOM   1168  CD2 PHE A  76     -19.022  81.000  31.640  1.00  0.00           C  
ATOM   1169  CE1 PHE A  76     -20.644  83.132  30.985  1.00  0.00           C  
ATOM   1170  CE2 PHE A  76     -20.037  81.382  32.497  1.00  0.00           C  
ATOM   1171  CZ  PHE A  76     -20.850  82.449  32.169  1.00  0.00           C  
ATOM   1172  H   PHE A  76     -17.308  83.472  27.854  1.00  0.00           H  
ATOM   1173  HA  PHE A  76     -16.235  82.524  30.429  1.00  0.00           H  
ATOM   1174  HB2 PHE A  76     -18.130  81.119  28.540  1.00  0.00           H  
ATOM   1175  HB3 PHE A  76     -17.308  80.317  29.874  1.00  0.00           H  
ATOM   1176  HD1 PHE A  76     -19.470  83.279  29.208  1.00  0.00           H  
ATOM   1177  HD2 PHE A  76     -18.386  80.164  31.897  1.00  0.00           H  
ATOM   1178  HE1 PHE A  76     -21.279  83.966  30.726  1.00  0.00           H  
ATOM   1179  HE2 PHE A  76     -20.194  80.846  33.420  1.00  0.00           H  
ATOM   1180  HZ  PHE A  76     -21.643  82.749  32.837  1.00  0.00           H  
ATOM   1181  N   MET A  77     -14.480  81.029  29.394  1.00  0.00           N  
ATOM   1182  CA  MET A  77     -13.311  80.408  28.784  1.00  0.00           C  
ATOM   1183  C   MET A  77     -13.376  78.889  28.905  1.00  0.00           C  
ATOM   1184  O   MET A  77     -13.649  78.354  29.978  1.00  0.00           O  
ATOM   1185  CB  MET A  77     -12.030  80.929  29.438  1.00  0.00           C  
ATOM   1186  CG  MET A  77     -11.457  82.162  28.757  1.00  0.00           C  
ATOM   1187  SD  MET A  77     -10.197  82.982  29.752  1.00  0.00           S  
ATOM   1188  CE  MET A  77      -9.276  81.571  30.361  1.00  0.00           C  
ATOM   1189  H   MET A  77     -14.601  80.971  30.365  1.00  0.00           H  
ATOM   1190  HA  MET A  77     -13.303  80.675  27.737  1.00  0.00           H  
ATOM   1191  HB2 MET A  77     -12.242  81.178  30.467  1.00  0.00           H  
ATOM   1192  HB3 MET A  77     -11.283  80.150  29.411  1.00  0.00           H  
ATOM   1193  HG2 MET A  77     -11.017  81.866  27.818  1.00  0.00           H  
ATOM   1194  HG3 MET A  77     -12.261  82.859  28.572  1.00  0.00           H  
ATOM   1195  HE1 MET A  77      -9.699  81.243  31.299  1.00  0.00           H  
ATOM   1196  HE2 MET A  77      -9.329  80.768  29.642  1.00  0.00           H  
ATOM   1197  HE3 MET A  77      -8.244  81.854  30.512  1.00  0.00           H  
ATOM   1198  N   MET A  78     -13.126  78.200  27.796  1.00  0.00           N  
ATOM   1199  CA  MET A  78     -13.155  76.742  27.780  1.00  0.00           C  
ATOM   1200  C   MET A  78     -12.011  76.184  26.941  1.00  0.00           C  
ATOM   1201  O   MET A  78     -11.991  76.337  25.720  1.00  0.00           O  
ATOM   1202  CB  MET A  78     -14.495  76.244  27.232  1.00  0.00           C  
ATOM   1203  CG  MET A  78     -14.803  74.802  27.600  1.00  0.00           C  
ATOM   1204  SD  MET A  78     -16.525  74.361  27.299  1.00  0.00           S  
ATOM   1205  CE  MET A  78     -16.353  72.654  26.786  1.00  0.00           C  
ATOM   1206  H   MET A  78     -12.914  78.683  26.970  1.00  0.00           H  
ATOM   1207  HA  MET A  78     -13.043  76.397  28.797  1.00  0.00           H  
ATOM   1208  HB2 MET A  78     -15.284  76.869  27.622  1.00  0.00           H  
ATOM   1209  HB3 MET A  78     -14.482  76.323  26.156  1.00  0.00           H  
ATOM   1210  HG2 MET A  78     -14.172  74.152  27.013  1.00  0.00           H  
ATOM   1211  HG3 MET A  78     -14.587  74.659  28.648  1.00  0.00           H  
ATOM   1212  HE1 MET A  78     -15.692  72.597  25.935  1.00  0.00           H  
ATOM   1213  HE2 MET A  78     -15.943  72.074  27.600  1.00  0.00           H  
ATOM   1214  HE3 MET A  78     -17.322  72.260  26.516  1.00  0.00           H  
ATOM   1215  N   GLY A  79     -11.058  75.536  27.604  1.00  0.00           N  
ATOM   1216  CA  GLY A  79      -9.922  74.966  26.903  1.00  0.00           C  
ATOM   1217  C   GLY A  79      -9.138  76.005  26.126  1.00  0.00           C  
ATOM   1218  O   GLY A  79      -8.753  75.774  24.981  1.00  0.00           O  
ATOM   1219  H   GLY A  79     -11.125  75.444  28.577  1.00  0.00           H  
ATOM   1220  HA2 GLY A  79      -9.267  74.499  27.622  1.00  0.00           H  
ATOM   1221  HA3 GLY A  79     -10.280  74.213  26.215  1.00  0.00           H  
ATOM   1222  N   GLY A  80      -8.903  77.156  26.751  1.00  0.00           N  
ATOM   1223  CA  GLY A  80      -8.164  78.217  26.095  1.00  0.00           C  
ATOM   1224  C   GLY A  80      -8.967  78.894  25.003  1.00  0.00           C  
ATOM   1225  O   GLY A  80      -8.402  79.409  24.036  1.00  0.00           O  
ATOM   1226  H   GLY A  80      -9.235  77.283  27.664  1.00  0.00           H  
ATOM   1227  HA2 GLY A  80      -7.884  78.956  26.833  1.00  0.00           H  
ATOM   1228  HA3 GLY A  80      -7.266  77.801  25.661  1.00  0.00           H  
ATOM   1229  N   ARG A  81     -10.287  78.894  25.154  1.00  0.00           N  
ATOM   1230  CA  ARG A  81     -11.170  79.511  24.170  1.00  0.00           C  
ATOM   1231  C   ARG A  81     -11.918  80.693  24.778  1.00  0.00           C  
ATOM   1232  O   ARG A  81     -11.808  80.963  25.975  1.00  0.00           O  
ATOM   1233  CB  ARG A  81     -12.167  78.483  23.634  1.00  0.00           C  
ATOM   1234  CG  ARG A  81     -11.517  77.194  23.158  1.00  0.00           C  
ATOM   1235  CD  ARG A  81     -11.037  77.310  21.720  1.00  0.00           C  
ATOM   1236  NE  ARG A  81      -9.655  77.776  21.639  1.00  0.00           N  
ATOM   1237  CZ  ARG A  81      -8.952  77.800  20.512  1.00  0.00           C  
ATOM   1238  NH1 ARG A  81      -9.499  77.389  19.378  1.00  0.00           N  
ATOM   1239  NH2 ARG A  81      -7.700  78.239  20.520  1.00  0.00           N  
ATOM   1240  H   ARG A  81     -10.678  78.468  25.946  1.00  0.00           H  
ATOM   1241  HA  ARG A  81     -10.559  79.867  23.354  1.00  0.00           H  
ATOM   1242  HB2 ARG A  81     -12.870  78.238  24.417  1.00  0.00           H  
ATOM   1243  HB3 ARG A  81     -12.702  78.919  22.804  1.00  0.00           H  
ATOM   1244  HG2 ARG A  81     -10.670  76.973  23.792  1.00  0.00           H  
ATOM   1245  HG3 ARG A  81     -12.238  76.393  23.225  1.00  0.00           H  
ATOM   1246  HD2 ARG A  81     -11.107  76.340  21.251  1.00  0.00           H  
ATOM   1247  HD3 ARG A  81     -11.674  78.009  21.198  1.00  0.00           H  
ATOM   1248  HE  ARG A  81      -9.232  78.085  22.467  1.00  0.00           H  
ATOM   1249 HH11 ARG A  81     -10.443  77.059  19.368  1.00  0.00           H  
ATOM   1250 HH12 ARG A  81      -8.968  77.409  18.529  1.00  0.00           H  
ATOM   1251 HH21 ARG A  81      -7.285  78.550  21.374  1.00  0.00           H  
ATOM   1252 HH22 ARG A  81      -7.172  78.257  19.672  1.00  0.00           H  
ATOM   1253  N   TYR A  82     -12.677  81.396  23.946  1.00  0.00           N  
ATOM   1254  CA  TYR A  82     -13.442  82.552  24.399  1.00  0.00           C  
ATOM   1255  C   TYR A  82     -14.731  82.701  23.596  1.00  0.00           C  
ATOM   1256  O   TYR A  82     -14.704  83.038  22.413  1.00  0.00           O  
ATOM   1257  CB  TYR A  82     -12.603  83.824  24.278  1.00  0.00           C  
ATOM   1258  CG  TYR A  82     -11.149  83.628  24.645  1.00  0.00           C  
ATOM   1259  CD1 TYR A  82     -10.721  83.762  25.961  1.00  0.00           C  
ATOM   1260  CD2 TYR A  82     -10.204  83.310  23.679  1.00  0.00           C  
ATOM   1261  CE1 TYR A  82      -9.394  83.585  26.301  1.00  0.00           C  
ATOM   1262  CE2 TYR A  82      -8.876  83.130  24.010  1.00  0.00           C  
ATOM   1263  CZ  TYR A  82      -8.476  83.268  25.323  1.00  0.00           C  
ATOM   1264  OH  TYR A  82      -7.152  83.090  25.657  1.00  0.00           O  
ATOM   1265  H   TYR A  82     -12.725  81.133  23.002  1.00  0.00           H  
ATOM   1266  HA  TYR A  82     -13.694  82.396  25.437  1.00  0.00           H  
ATOM   1267  HB2 TYR A  82     -12.641  84.178  23.259  1.00  0.00           H  
ATOM   1268  HB3 TYR A  82     -13.011  84.581  24.932  1.00  0.00           H  
ATOM   1269  HD1 TYR A  82     -11.443  84.011  26.726  1.00  0.00           H  
ATOM   1270  HD2 TYR A  82     -10.521  83.203  22.651  1.00  0.00           H  
ATOM   1271  HE1 TYR A  82      -9.080  83.694  27.330  1.00  0.00           H  
ATOM   1272  HE2 TYR A  82      -8.156  82.882  23.244  1.00  0.00           H  
ATOM   1273  HH  TYR A  82      -6.658  83.884  25.440  1.00  0.00           H  
ATOM   1274  N   TYR A  83     -15.859  82.449  24.251  1.00  0.00           N  
ATOM   1275  CA  TYR A  83     -17.160  82.553  23.599  1.00  0.00           C  
ATOM   1276  C   TYR A  83     -18.007  83.645  24.246  1.00  0.00           C  
ATOM   1277  O   TYR A  83     -17.725  84.087  25.359  1.00  0.00           O  
ATOM   1278  CB  TYR A  83     -17.897  81.214  23.667  1.00  0.00           C  
ATOM   1279  CG  TYR A  83     -17.153  80.079  23.001  1.00  0.00           C  
ATOM   1280  CD1 TYR A  83     -16.125  79.415  23.660  1.00  0.00           C  
ATOM   1281  CD2 TYR A  83     -17.477  79.672  21.714  1.00  0.00           C  
ATOM   1282  CE1 TYR A  83     -15.442  78.378  23.055  1.00  0.00           C  
ATOM   1283  CE2 TYR A  83     -16.799  78.635  21.101  1.00  0.00           C  
ATOM   1284  CZ  TYR A  83     -15.783  77.992  21.776  1.00  0.00           C  
ATOM   1285  OH  TYR A  83     -15.106  76.958  21.169  1.00  0.00           O  
ATOM   1286  H   TYR A  83     -15.818  82.185  25.193  1.00  0.00           H  
ATOM   1287  HA  TYR A  83     -16.993  82.809  22.564  1.00  0.00           H  
ATOM   1288  HB2 TYR A  83     -18.050  80.948  24.702  1.00  0.00           H  
ATOM   1289  HB3 TYR A  83     -18.856  81.314  23.181  1.00  0.00           H  
ATOM   1290  HD1 TYR A  83     -15.861  79.720  24.662  1.00  0.00           H  
ATOM   1291  HD2 TYR A  83     -18.273  80.179  21.188  1.00  0.00           H  
ATOM   1292  HE1 TYR A  83     -14.646  77.873  23.583  1.00  0.00           H  
ATOM   1293  HE2 TYR A  83     -17.065  78.332  20.099  1.00  0.00           H  
ATOM   1294  HH  TYR A  83     -14.986  76.242  21.797  1.00  0.00           H  
ATOM   1295  N   ASN A  84     -19.046  84.077  23.537  1.00  0.00           N  
ATOM   1296  CA  ASN A  84     -19.935  85.118  24.040  1.00  0.00           C  
ATOM   1297  C   ASN A  84     -20.579  84.693  25.357  1.00  0.00           C  
ATOM   1298  O   ASN A  84     -20.622  85.464  26.316  1.00  0.00           O  
ATOM   1299  CB  ASN A  84     -21.019  85.434  23.008  1.00  0.00           C  
ATOM   1300  CG  ASN A  84     -20.456  86.085  21.760  1.00  0.00           C  
ATOM   1301  OD1 ASN A  84     -19.583  85.527  21.095  1.00  0.00           O  
ATOM   1302  ND2 ASN A  84     -20.954  87.273  21.437  1.00  0.00           N  
ATOM   1303  H   ASN A  84     -19.219  83.685  22.656  1.00  0.00           H  
ATOM   1304  HA  ASN A  84     -19.344  86.005  24.212  1.00  0.00           H  
ATOM   1305  HB2 ASN A  84     -21.513  84.516  22.721  1.00  0.00           H  
ATOM   1306  HB3 ASN A  84     -21.742  86.105  23.448  1.00  0.00           H  
ATOM   1307 HD21 ASN A  84     -21.648  87.657  22.012  1.00  0.00           H  
ATOM   1308 HD22 ASN A  84     -20.610  87.716  20.633  1.00  0.00           H  
ATOM   1309  N   SER A  85     -21.078  83.462  25.395  1.00  0.00           N  
ATOM   1310  CA  SER A  85     -21.723  82.936  26.593  1.00  0.00           C  
ATOM   1311  C   SER A  85     -21.830  81.415  26.529  1.00  0.00           C  
ATOM   1312  O   SER A  85     -21.614  80.812  25.478  1.00  0.00           O  
ATOM   1313  CB  SER A  85     -23.114  83.550  26.761  1.00  0.00           C  
ATOM   1314  OG  SER A  85     -23.969  83.173  25.695  1.00  0.00           O  
ATOM   1315  H   SER A  85     -21.014  82.895  24.599  1.00  0.00           H  
ATOM   1316  HA  SER A  85     -21.115  83.207  27.443  1.00  0.00           H  
ATOM   1317  HB2 SER A  85     -23.546  83.210  27.690  1.00  0.00           H  
ATOM   1318  HB3 SER A  85     -23.030  84.627  26.776  1.00  0.00           H  
ATOM   1319  HG  SER A  85     -24.882  83.345  25.940  1.00  0.00           H  
ATOM   1320  N   ILE A  86     -22.164  80.804  27.660  1.00  0.00           N  
ATOM   1321  CA  ILE A  86     -22.301  79.355  27.732  1.00  0.00           C  
ATOM   1322  C   ILE A  86     -23.183  78.828  26.606  1.00  0.00           C  
ATOM   1323  O   ILE A  86     -22.722  78.094  25.733  1.00  0.00           O  
ATOM   1324  CB  ILE A  86     -22.894  78.912  29.083  1.00  0.00           C  
ATOM   1325  CG1 ILE A  86     -21.954  79.292  30.228  1.00  0.00           C  
ATOM   1326  CG2 ILE A  86     -23.157  77.414  29.082  1.00  0.00           C  
ATOM   1327  CD1 ILE A  86     -22.286  78.609  31.536  1.00  0.00           C  
ATOM   1328  H   ILE A  86     -22.323  81.340  28.464  1.00  0.00           H  
ATOM   1329  HA  ILE A  86     -21.316  78.922  27.636  1.00  0.00           H  
ATOM   1330  HB  ILE A  86     -23.838  79.418  29.220  1.00  0.00           H  
ATOM   1331 HG12 ILE A  86     -20.944  79.023  29.960  1.00  0.00           H  
ATOM   1332 HG13 ILE A  86     -22.006  80.360  30.388  1.00  0.00           H  
ATOM   1333 HG21 ILE A  86     -23.560  77.117  30.039  1.00  0.00           H  
ATOM   1334 HG22 ILE A  86     -23.866  77.173  28.304  1.00  0.00           H  
ATOM   1335 HG23 ILE A  86     -22.232  76.887  28.901  1.00  0.00           H  
ATOM   1336 HD11 ILE A  86     -21.765  77.665  31.591  1.00  0.00           H  
ATOM   1337 HD12 ILE A  86     -21.981  79.238  32.358  1.00  0.00           H  
ATOM   1338 HD13 ILE A  86     -23.351  78.436  31.590  1.00  0.00           H  
ATOM   1339  N   GLY A  87     -24.456  79.210  26.631  1.00  0.00           N  
ATOM   1340  CA  GLY A  87     -25.384  78.770  25.605  1.00  0.00           C  
ATOM   1341  C   GLY A  87     -24.732  78.665  24.240  1.00  0.00           C  
ATOM   1342  O   GLY A  87     -24.990  77.723  23.492  1.00  0.00           O  
ATOM   1343  H   GLY A  87     -24.769  79.796  27.352  1.00  0.00           H  
ATOM   1344  HA2 GLY A  87     -25.775  77.801  25.880  1.00  0.00           H  
ATOM   1345  HA3 GLY A  87     -26.201  79.473  25.548  1.00  0.00           H  
ATOM   1346  N   ASP A  88     -23.886  79.637  23.915  1.00  0.00           N  
ATOM   1347  CA  ASP A  88     -23.196  79.651  22.631  1.00  0.00           C  
ATOM   1348  C   ASP A  88     -22.199  78.501  22.537  1.00  0.00           C  
ATOM   1349  O   ASP A  88     -22.263  77.685  21.616  1.00  0.00           O  
ATOM   1350  CB  ASP A  88     -22.474  80.986  22.430  1.00  0.00           C  
ATOM   1351  CG  ASP A  88     -23.384  82.055  21.857  1.00  0.00           C  
ATOM   1352  OD1 ASP A  88     -24.585  82.058  22.200  1.00  0.00           O  
ATOM   1353  OD2 ASP A  88     -22.894  82.889  21.067  1.00  0.00           O  
ATOM   1354  H   ASP A  88     -23.721  80.362  24.555  1.00  0.00           H  
ATOM   1355  HA  ASP A  88     -23.937  79.533  21.854  1.00  0.00           H  
ATOM   1356  HB2 ASP A  88     -22.100  81.331  23.382  1.00  0.00           H  
ATOM   1357  HB3 ASP A  88     -21.647  80.841  21.752  1.00  0.00           H  
ATOM   1358  N   ILE A  89     -21.278  78.443  23.493  1.00  0.00           N  
ATOM   1359  CA  ILE A  89     -20.268  77.393  23.517  1.00  0.00           C  
ATOM   1360  C   ILE A  89     -20.837  76.071  23.013  1.00  0.00           C  
ATOM   1361  O   ILE A  89     -20.190  75.358  22.244  1.00  0.00           O  
ATOM   1362  CB  ILE A  89     -19.703  77.187  24.935  1.00  0.00           C  
ATOM   1363  CG1 ILE A  89     -19.007  78.461  25.419  1.00  0.00           C  
ATOM   1364  CG2 ILE A  89     -18.740  76.010  24.956  1.00  0.00           C  
ATOM   1365  CD1 ILE A  89     -18.399  78.331  26.799  1.00  0.00           C  
ATOM   1366  H   ILE A  89     -21.279  79.122  24.199  1.00  0.00           H  
ATOM   1367  HA  ILE A  89     -19.458  77.695  22.869  1.00  0.00           H  
ATOM   1368  HB  ILE A  89     -20.525  76.962  25.596  1.00  0.00           H  
ATOM   1369 HG12 ILE A  89     -18.215  78.715  24.731  1.00  0.00           H  
ATOM   1370 HG13 ILE A  89     -19.726  79.267  25.448  1.00  0.00           H  
ATOM   1371 HG21 ILE A  89     -18.742  75.526  23.991  1.00  0.00           H  
ATOM   1372 HG22 ILE A  89     -17.744  76.364  25.178  1.00  0.00           H  
ATOM   1373 HG23 ILE A  89     -19.049  75.305  25.713  1.00  0.00           H  
ATOM   1374 HD11 ILE A  89     -18.895  77.536  27.337  1.00  0.00           H  
ATOM   1375 HD12 ILE A  89     -17.347  78.105  26.709  1.00  0.00           H  
ATOM   1376 HD13 ILE A  89     -18.524  79.260  27.336  1.00  0.00           H  
ATOM   1377  N   ILE A  90     -22.051  75.751  23.449  1.00  0.00           N  
ATOM   1378  CA  ILE A  90     -22.709  74.516  23.039  1.00  0.00           C  
ATOM   1379  C   ILE A  90     -23.075  74.553  21.559  1.00  0.00           C  
ATOM   1380  O   ILE A  90     -22.606  73.730  20.772  1.00  0.00           O  
ATOM   1381  CB  ILE A  90     -23.981  74.256  23.865  1.00  0.00           C  
ATOM   1382  CG1 ILE A  90     -23.629  74.082  25.344  1.00  0.00           C  
ATOM   1383  CG2 ILE A  90     -24.710  73.027  23.342  1.00  0.00           C  
ATOM   1384  CD1 ILE A  90     -24.765  74.432  26.280  1.00  0.00           C  
ATOM   1385  H   ILE A  90     -22.515  76.360  24.059  1.00  0.00           H  
ATOM   1386  HA  ILE A  90     -22.020  73.701  23.208  1.00  0.00           H  
ATOM   1387  HB  ILE A  90     -24.636  75.106  23.755  1.00  0.00           H  
ATOM   1388 HG12 ILE A  90     -23.355  73.056  25.525  1.00  0.00           H  
ATOM   1389 HG13 ILE A  90     -22.792  74.722  25.583  1.00  0.00           H  
ATOM   1390 HG21 ILE A  90     -24.052  72.171  23.389  1.00  0.00           H  
ATOM   1391 HG22 ILE A  90     -25.584  72.842  23.948  1.00  0.00           H  
ATOM   1392 HG23 ILE A  90     -25.010  73.194  22.319  1.00  0.00           H  
ATOM   1393 HD11 ILE A  90     -24.889  75.505  26.313  1.00  0.00           H  
ATOM   1394 HD12 ILE A  90     -25.676  73.974  25.928  1.00  0.00           H  
ATOM   1395 HD13 ILE A  90     -24.539  74.067  27.272  1.00  0.00           H  
ATOM   1396  N   ASP A  91     -23.914  75.514  21.188  1.00  0.00           N  
ATOM   1397  CA  ASP A  91     -24.342  75.661  19.801  1.00  0.00           C  
ATOM   1398  C   ASP A  91     -23.151  75.563  18.852  1.00  0.00           C  
ATOM   1399  O   ASP A  91     -23.285  75.102  17.717  1.00  0.00           O  
ATOM   1400  CB  ASP A  91     -25.056  76.999  19.605  1.00  0.00           C  
ATOM   1401  CG  ASP A  91     -25.894  77.028  18.342  1.00  0.00           C  
ATOM   1402  OD1 ASP A  91     -25.349  77.379  17.275  1.00  0.00           O  
ATOM   1403  OD2 ASP A  91     -27.096  76.697  18.421  1.00  0.00           O  
ATOM   1404  H   ASP A  91     -24.252  76.140  21.862  1.00  0.00           H  
ATOM   1405  HA  ASP A  91     -25.030  74.859  19.580  1.00  0.00           H  
ATOM   1406  HB2 ASP A  91     -25.704  77.181  20.450  1.00  0.00           H  
ATOM   1407  HB3 ASP A  91     -24.320  77.787  19.544  1.00  0.00           H  
ATOM   1408  N   HIS A  92     -21.987  75.997  19.323  1.00  0.00           N  
ATOM   1409  CA  HIS A  92     -20.773  75.958  18.516  1.00  0.00           C  
ATOM   1410  C   HIS A  92     -20.221  74.538  18.434  1.00  0.00           C  
ATOM   1411  O   HIS A  92     -19.919  74.040  17.349  1.00  0.00           O  
ATOM   1412  CB  HIS A  92     -19.716  76.896  19.100  1.00  0.00           C  
ATOM   1413  CG  HIS A  92     -18.663  77.299  18.115  1.00  0.00           C  
ATOM   1414  ND1 HIS A  92     -17.523  76.558  17.886  1.00  0.00           N  
ATOM   1415  CD2 HIS A  92     -18.581  78.373  17.295  1.00  0.00           C  
ATOM   1416  CE1 HIS A  92     -16.786  77.159  16.970  1.00  0.00           C  
ATOM   1417  NE2 HIS A  92     -17.406  78.263  16.595  1.00  0.00           N  
ATOM   1418  H   HIS A  92     -21.943  76.353  20.235  1.00  0.00           H  
ATOM   1419  HA  HIS A  92     -21.026  76.290  17.520  1.00  0.00           H  
ATOM   1420  HB2 HIS A  92     -20.198  77.794  19.455  1.00  0.00           H  
ATOM   1421  HB3 HIS A  92     -19.226  76.405  19.928  1.00  0.00           H  
ATOM   1422  HD1 HIS A  92     -17.288  75.717  18.330  1.00  0.00           H  
ATOM   1423  HD2 HIS A  92     -19.306  79.171  17.209  1.00  0.00           H  
ATOM   1424  HE1 HIS A  92     -15.837  76.808  16.591  1.00  0.00           H  
ATOM   1425  N   TYR A  93     -20.089  73.893  19.587  1.00  0.00           N  
ATOM   1426  CA  TYR A  93     -19.570  72.531  19.646  1.00  0.00           C  
ATOM   1427  C   TYR A  93     -20.394  71.596  18.767  1.00  0.00           C  
ATOM   1428  O   TYR A  93     -19.877  70.618  18.225  1.00  0.00           O  
ATOM   1429  CB  TYR A  93     -19.570  72.025  21.089  1.00  0.00           C  
ATOM   1430  CG  TYR A  93     -18.343  72.432  21.874  1.00  0.00           C  
ATOM   1431  CD1 TYR A  93     -17.072  72.307  21.326  1.00  0.00           C  
ATOM   1432  CD2 TYR A  93     -18.455  72.939  23.162  1.00  0.00           C  
ATOM   1433  CE1 TYR A  93     -15.948  72.676  22.039  1.00  0.00           C  
ATOM   1434  CE2 TYR A  93     -17.337  73.313  23.882  1.00  0.00           C  
ATOM   1435  CZ  TYR A  93     -16.085  73.179  23.317  1.00  0.00           C  
ATOM   1436  OH  TYR A  93     -14.969  73.549  24.030  1.00  0.00           O  
ATOM   1437  H   TYR A  93     -20.345  74.342  20.419  1.00  0.00           H  
ATOM   1438  HA  TYR A  93     -18.554  72.547  19.281  1.00  0.00           H  
ATOM   1439  HB2 TYR A  93     -20.435  72.418  21.602  1.00  0.00           H  
ATOM   1440  HB3 TYR A  93     -19.619  70.946  21.085  1.00  0.00           H  
ATOM   1441  HD1 TYR A  93     -16.968  71.914  20.325  1.00  0.00           H  
ATOM   1442  HD2 TYR A  93     -19.435  73.043  23.603  1.00  0.00           H  
ATOM   1443  HE1 TYR A  93     -14.968  72.573  21.597  1.00  0.00           H  
ATOM   1444  HE2 TYR A  93     -17.444  73.705  24.882  1.00  0.00           H  
ATOM   1445  HH  TYR A  93     -15.082  74.443  24.360  1.00  0.00           H  
ATOM   1446  N   ARG A  94     -21.680  71.902  18.630  1.00  0.00           N  
ATOM   1447  CA  ARG A  94     -22.577  71.089  17.817  1.00  0.00           C  
ATOM   1448  C   ARG A  94     -22.076  70.998  16.379  1.00  0.00           C  
ATOM   1449  O   ARG A  94     -22.559  70.185  15.592  1.00  0.00           O  
ATOM   1450  CB  ARG A  94     -23.990  71.674  17.841  1.00  0.00           C  
ATOM   1451  CG  ARG A  94     -24.624  71.681  19.222  1.00  0.00           C  
ATOM   1452  CD  ARG A  94     -26.013  72.300  19.194  1.00  0.00           C  
ATOM   1453  NE  ARG A  94     -26.584  72.423  20.534  1.00  0.00           N  
ATOM   1454  CZ  ARG A  94     -27.634  73.185  20.817  1.00  0.00           C  
ATOM   1455  NH1 ARG A  94     -28.226  73.886  19.860  1.00  0.00           N  
ATOM   1456  NH2 ARG A  94     -28.096  73.244  22.059  1.00  0.00           N  
ATOM   1457  H   ARG A  94     -22.034  72.694  19.087  1.00  0.00           H  
ATOM   1458  HA  ARG A  94     -22.600  70.096  18.241  1.00  0.00           H  
ATOM   1459  HB2 ARG A  94     -23.953  72.691  17.481  1.00  0.00           H  
ATOM   1460  HB3 ARG A  94     -24.619  71.091  17.183  1.00  0.00           H  
ATOM   1461  HG2 ARG A  94     -24.704  70.663  19.577  1.00  0.00           H  
ATOM   1462  HG3 ARG A  94     -23.998  72.250  19.893  1.00  0.00           H  
ATOM   1463  HD2 ARG A  94     -25.945  73.283  18.751  1.00  0.00           H  
ATOM   1464  HD3 ARG A  94     -26.659  71.677  18.594  1.00  0.00           H  
ATOM   1465  HE  ARG A  94     -26.162  71.913  21.255  1.00  0.00           H  
ATOM   1466 HH11 ARG A  94     -27.881  73.842  18.924  1.00  0.00           H  
ATOM   1467 HH12 ARG A  94     -29.019  74.457  20.077  1.00  0.00           H  
ATOM   1468 HH21 ARG A  94     -27.652  72.716  22.783  1.00  0.00           H  
ATOM   1469 HH22 ARG A  94     -28.886  73.817  22.272  1.00  0.00           H  
ATOM   1470  N   LYS A  95     -21.103  71.839  16.043  1.00  0.00           N  
ATOM   1471  CA  LYS A  95     -20.535  71.855  14.700  1.00  0.00           C  
ATOM   1472  C   LYS A  95     -19.076  71.411  14.722  1.00  0.00           C  
ATOM   1473  O   LYS A  95     -18.581  70.830  13.757  1.00  0.00           O  
ATOM   1474  CB  LYS A  95     -20.644  73.256  14.094  1.00  0.00           C  
ATOM   1475  CG  LYS A  95     -22.075  73.697  13.836  1.00  0.00           C  
ATOM   1476  CD  LYS A  95     -22.668  74.401  15.043  1.00  0.00           C  
ATOM   1477  CE  LYS A  95     -23.836  75.293  14.651  1.00  0.00           C  
ATOM   1478  NZ  LYS A  95     -25.070  74.504  14.382  1.00  0.00           N  
ATOM   1479  H   LYS A  95     -20.759  72.465  16.715  1.00  0.00           H  
ATOM   1480  HA  LYS A  95     -21.100  71.164  14.093  1.00  0.00           H  
ATOM   1481  HB2 LYS A  95     -20.188  73.964  14.770  1.00  0.00           H  
ATOM   1482  HB3 LYS A  95     -20.109  73.272  13.155  1.00  0.00           H  
ATOM   1483  HG2 LYS A  95     -22.086  74.376  12.996  1.00  0.00           H  
ATOM   1484  HG3 LYS A  95     -22.674  72.827  13.606  1.00  0.00           H  
ATOM   1485  HD2 LYS A  95     -23.017  73.659  15.747  1.00  0.00           H  
ATOM   1486  HD3 LYS A  95     -21.903  75.007  15.508  1.00  0.00           H  
ATOM   1487  HE2 LYS A  95     -24.030  75.985  15.456  1.00  0.00           H  
ATOM   1488  HE3 LYS A  95     -23.568  75.843  13.761  1.00  0.00           H  
ATOM   1489  HZ1 LYS A  95     -24.856  73.487  14.408  1.00  0.00           H  
ATOM   1490  HZ2 LYS A  95     -25.448  74.743  13.443  1.00  0.00           H  
ATOM   1491  HZ3 LYS A  95     -25.793  74.714  15.099  1.00  0.00           H  
ATOM   1492  N   GLU A  96     -18.394  71.687  15.829  1.00  0.00           N  
ATOM   1493  CA  GLU A  96     -16.992  71.315  15.975  1.00  0.00           C  
ATOM   1494  C   GLU A  96     -16.798  70.382  17.168  1.00  0.00           C  
ATOM   1495  O   GLU A  96     -16.979  70.783  18.317  1.00  0.00           O  
ATOM   1496  CB  GLU A  96     -16.125  72.564  16.144  1.00  0.00           C  
ATOM   1497  CG  GLU A  96     -15.966  73.372  14.868  1.00  0.00           C  
ATOM   1498  CD  GLU A  96     -14.813  74.353  14.938  1.00  0.00           C  
ATOM   1499  OE1 GLU A  96     -14.592  74.933  16.023  1.00  0.00           O  
ATOM   1500  OE2 GLU A  96     -14.130  74.542  13.910  1.00  0.00           O  
ATOM   1501  H   GLU A  96     -18.845  72.152  16.565  1.00  0.00           H  
ATOM   1502  HA  GLU A  96     -16.691  70.798  15.077  1.00  0.00           H  
ATOM   1503  HB2 GLU A  96     -16.572  73.199  16.895  1.00  0.00           H  
ATOM   1504  HB3 GLU A  96     -15.143  72.263  16.479  1.00  0.00           H  
ATOM   1505  HG2 GLU A  96     -15.792  72.694  14.047  1.00  0.00           H  
ATOM   1506  HG3 GLU A  96     -16.878  73.924  14.690  1.00  0.00           H  
ATOM   1507  N   GLN A  97     -16.429  69.137  16.883  1.00  0.00           N  
ATOM   1508  CA  GLN A  97     -16.212  68.146  17.932  1.00  0.00           C  
ATOM   1509  C   GLN A  97     -15.487  68.765  19.123  1.00  0.00           C  
ATOM   1510  O   GLN A  97     -14.476  69.449  18.959  1.00  0.00           O  
ATOM   1511  CB  GLN A  97     -15.408  66.965  17.387  1.00  0.00           C  
ATOM   1512  CG  GLN A  97     -14.246  67.378  16.498  1.00  0.00           C  
ATOM   1513  CD  GLN A  97     -13.924  66.340  15.440  1.00  0.00           C  
ATOM   1514  OE1 GLN A  97     -14.166  66.554  14.252  1.00  0.00           O  
ATOM   1515  NE2 GLN A  97     -13.375  65.210  15.867  1.00  0.00           N  
ATOM   1516  H   GLN A  97     -16.302  68.878  15.948  1.00  0.00           H  
ATOM   1517  HA  GLN A  97     -17.178  67.794  18.259  1.00  0.00           H  
ATOM   1518  HB2 GLN A  97     -15.014  66.399  18.219  1.00  0.00           H  
ATOM   1519  HB3 GLN A  97     -16.067  66.332  16.811  1.00  0.00           H  
ATOM   1520  HG2 GLN A  97     -14.498  68.305  16.006  1.00  0.00           H  
ATOM   1521  HG3 GLN A  97     -13.373  67.525  17.115  1.00  0.00           H  
ATOM   1522 HE21 GLN A  97     -13.212  65.109  16.829  1.00  0.00           H  
ATOM   1523 HE22 GLN A  97     -13.157  64.522  15.205  1.00  0.00           H  
ATOM   1524  N   ILE A  98     -16.010  68.521  20.319  1.00  0.00           N  
ATOM   1525  CA  ILE A  98     -15.412  69.053  21.536  1.00  0.00           C  
ATOM   1526  C   ILE A  98     -14.295  68.146  22.042  1.00  0.00           C  
ATOM   1527  O   ILE A  98     -13.458  68.561  22.844  1.00  0.00           O  
ATOM   1528  CB  ILE A  98     -16.461  69.226  22.650  1.00  0.00           C  
ATOM   1529  CG1 ILE A  98     -15.779  69.578  23.974  1.00  0.00           C  
ATOM   1530  CG2 ILE A  98     -17.292  67.961  22.797  1.00  0.00           C  
ATOM   1531  CD1 ILE A  98     -16.748  69.955  25.073  1.00  0.00           C  
ATOM   1532  H   ILE A  98     -16.816  67.969  20.384  1.00  0.00           H  
ATOM   1533  HA  ILE A  98     -14.996  70.024  21.307  1.00  0.00           H  
ATOM   1534  HB  ILE A  98     -17.122  70.032  22.369  1.00  0.00           H  
ATOM   1535 HG12 ILE A  98     -15.207  68.729  24.314  1.00  0.00           H  
ATOM   1536 HG13 ILE A  98     -15.114  70.415  23.816  1.00  0.00           H  
ATOM   1537 HG21 ILE A  98     -18.303  68.154  22.468  1.00  0.00           H  
ATOM   1538 HG22 ILE A  98     -16.861  67.176  22.193  1.00  0.00           H  
ATOM   1539 HG23 ILE A  98     -17.302  67.654  23.832  1.00  0.00           H  
ATOM   1540 HD11 ILE A  98     -17.430  70.709  24.709  1.00  0.00           H  
ATOM   1541 HD12 ILE A  98     -17.305  69.082  25.377  1.00  0.00           H  
ATOM   1542 HD13 ILE A  98     -16.200  70.345  25.917  1.00  0.00           H  
ATOM   1543  N   VAL A  99     -14.287  66.905  21.567  1.00  0.00           N  
ATOM   1544  CA  VAL A  99     -13.272  65.939  21.968  1.00  0.00           C  
ATOM   1545  C   VAL A  99     -12.494  65.425  20.762  1.00  0.00           C  
ATOM   1546  O   VAL A  99     -12.805  65.766  19.621  1.00  0.00           O  
ATOM   1547  CB  VAL A  99     -13.896  64.742  22.709  1.00  0.00           C  
ATOM   1548  CG1 VAL A  99     -12.895  64.131  23.677  1.00  0.00           C  
ATOM   1549  CG2 VAL A  99     -15.162  65.170  23.439  1.00  0.00           C  
ATOM   1550  H   VAL A  99     -14.980  66.633  20.930  1.00  0.00           H  
ATOM   1551  HA  VAL A  99     -12.586  66.434  22.641  1.00  0.00           H  
ATOM   1552  HB  VAL A  99     -14.163  63.992  21.980  1.00  0.00           H  
ATOM   1553 HG11 VAL A  99     -12.074  64.817  23.826  1.00  0.00           H  
ATOM   1554 HG12 VAL A  99     -13.380  63.937  24.623  1.00  0.00           H  
ATOM   1555 HG13 VAL A  99     -12.519  63.205  23.268  1.00  0.00           H  
ATOM   1556 HG21 VAL A  99     -14.938  66.002  24.089  1.00  0.00           H  
ATOM   1557 HG22 VAL A  99     -15.910  65.468  22.718  1.00  0.00           H  
ATOM   1558 HG23 VAL A  99     -15.536  64.344  24.025  1.00  0.00           H  
ATOM   1559  N   GLU A 100     -11.482  64.603  21.022  1.00  0.00           N  
ATOM   1560  CA  GLU A 100     -10.661  64.043  19.956  1.00  0.00           C  
ATOM   1561  C   GLU A 100     -11.531  63.427  18.865  1.00  0.00           C  
ATOM   1562  O   GLU A 100     -11.133  63.358  17.703  1.00  0.00           O  
ATOM   1563  CB  GLU A 100      -9.707  62.987  20.519  1.00  0.00           C  
ATOM   1564  CG  GLU A 100     -10.415  61.773  21.097  1.00  0.00           C  
ATOM   1565  CD  GLU A 100      -9.480  60.869  21.876  1.00  0.00           C  
ATOM   1566  OE1 GLU A 100      -8.725  60.106  21.240  1.00  0.00           O  
ATOM   1567  OE2 GLU A 100      -9.504  60.925  23.124  1.00  0.00           O  
ATOM   1568  H   GLU A 100     -11.284  64.369  21.953  1.00  0.00           H  
ATOM   1569  HA  GLU A 100     -10.081  64.846  19.527  1.00  0.00           H  
ATOM   1570  HB2 GLU A 100      -9.052  62.652  19.728  1.00  0.00           H  
ATOM   1571  HB3 GLU A 100      -9.112  63.437  21.300  1.00  0.00           H  
ATOM   1572  HG2 GLU A 100     -11.198  62.111  21.759  1.00  0.00           H  
ATOM   1573  HG3 GLU A 100     -10.849  61.206  20.288  1.00  0.00           H  
ATOM   1574  N   GLY A 101     -12.724  62.979  19.248  1.00  0.00           N  
ATOM   1575  CA  GLY A 101     -13.632  62.375  18.291  1.00  0.00           C  
ATOM   1576  C   GLY A 101     -15.030  62.200  18.850  1.00  0.00           C  
ATOM   1577  O   GLY A 101     -15.579  61.099  18.833  1.00  0.00           O  
ATOM   1578  H   GLY A 101     -12.988  63.061  20.188  1.00  0.00           H  
ATOM   1579  HA2 GLY A 101     -13.682  63.001  17.413  1.00  0.00           H  
ATOM   1580  HA3 GLY A 101     -13.246  61.406  18.009  1.00  0.00           H  
ATOM   1581  N   TYR A 102     -15.607  63.289  19.347  1.00  0.00           N  
ATOM   1582  CA  TYR A 102     -16.948  63.250  19.917  1.00  0.00           C  
ATOM   1583  C   TYR A 102     -17.685  64.562  19.666  1.00  0.00           C  
ATOM   1584  O   TYR A 102     -17.076  65.630  19.621  1.00  0.00           O  
ATOM   1585  CB  TYR A 102     -16.878  62.972  21.420  1.00  0.00           C  
ATOM   1586  CG  TYR A 102     -16.410  61.573  21.756  1.00  0.00           C  
ATOM   1587  CD1 TYR A 102     -15.063  61.238  21.695  1.00  0.00           C  
ATOM   1588  CD2 TYR A 102     -17.314  60.590  22.135  1.00  0.00           C  
ATOM   1589  CE1 TYR A 102     -14.631  59.962  22.000  1.00  0.00           C  
ATOM   1590  CE2 TYR A 102     -16.891  59.311  22.443  1.00  0.00           C  
ATOM   1591  CZ  TYR A 102     -15.549  59.002  22.374  1.00  0.00           C  
ATOM   1592  OH  TYR A 102     -15.122  57.730  22.680  1.00  0.00           O  
ATOM   1593  H   TYR A 102     -15.119  64.138  19.332  1.00  0.00           H  
ATOM   1594  HA  TYR A 102     -17.489  62.448  19.437  1.00  0.00           H  
ATOM   1595  HB2 TYR A 102     -16.194  63.669  21.876  1.00  0.00           H  
ATOM   1596  HB3 TYR A 102     -17.860  63.105  21.850  1.00  0.00           H  
ATOM   1597  HD1 TYR A 102     -14.347  61.992  21.402  1.00  0.00           H  
ATOM   1598  HD2 TYR A 102     -18.366  60.834  22.188  1.00  0.00           H  
ATOM   1599  HE1 TYR A 102     -13.580  59.720  21.946  1.00  0.00           H  
ATOM   1600  HE2 TYR A 102     -17.609  58.559  22.736  1.00  0.00           H  
ATOM   1601  HH  TYR A 102     -14.162  57.712  22.703  1.00  0.00           H  
ATOM   1602  N   TYR A 103     -19.000  64.471  19.502  1.00  0.00           N  
ATOM   1603  CA  TYR A 103     -19.822  65.650  19.252  1.00  0.00           C  
ATOM   1604  C   TYR A 103     -20.989  65.718  20.234  1.00  0.00           C  
ATOM   1605  O   TYR A 103     -21.463  64.693  20.724  1.00  0.00           O  
ATOM   1606  CB  TYR A 103     -20.349  65.635  17.816  1.00  0.00           C  
ATOM   1607  CG  TYR A 103     -19.323  66.062  16.791  1.00  0.00           C  
ATOM   1608  CD1 TYR A 103     -19.160  67.400  16.458  1.00  0.00           C  
ATOM   1609  CD2 TYR A 103     -18.517  65.126  16.155  1.00  0.00           C  
ATOM   1610  CE1 TYR A 103     -18.224  67.795  15.521  1.00  0.00           C  
ATOM   1611  CE2 TYR A 103     -17.577  65.510  15.218  1.00  0.00           C  
ATOM   1612  CZ  TYR A 103     -17.435  66.846  14.904  1.00  0.00           C  
ATOM   1613  OH  TYR A 103     -16.501  67.235  13.972  1.00  0.00           O  
ATOM   1614  H   TYR A 103     -19.429  63.591  19.548  1.00  0.00           H  
ATOM   1615  HA  TYR A 103     -19.200  66.522  19.389  1.00  0.00           H  
ATOM   1616  HB2 TYR A 103     -20.669  64.636  17.567  1.00  0.00           H  
ATOM   1617  HB3 TYR A 103     -21.192  66.308  17.743  1.00  0.00           H  
ATOM   1618  HD1 TYR A 103     -19.779  68.141  16.944  1.00  0.00           H  
ATOM   1619  HD2 TYR A 103     -18.630  64.080  16.404  1.00  0.00           H  
ATOM   1620  HE1 TYR A 103     -18.111  68.840  15.275  1.00  0.00           H  
ATOM   1621  HE2 TYR A 103     -16.959  64.768  14.735  1.00  0.00           H  
ATOM   1622  HH  TYR A 103     -16.914  67.284  13.106  1.00  0.00           H  
ATOM   1623  N   LEU A 104     -21.447  66.933  20.514  1.00  0.00           N  
ATOM   1624  CA  LEU A 104     -22.559  67.137  21.436  1.00  0.00           C  
ATOM   1625  C   LEU A 104     -23.892  66.859  20.749  1.00  0.00           C  
ATOM   1626  O   LEU A 104     -24.329  67.620  19.886  1.00  0.00           O  
ATOM   1627  CB  LEU A 104     -22.540  68.567  21.980  1.00  0.00           C  
ATOM   1628  CG  LEU A 104     -21.262  68.993  22.703  1.00  0.00           C  
ATOM   1629  CD1 LEU A 104     -21.442  70.359  23.346  1.00  0.00           C  
ATOM   1630  CD2 LEU A 104     -20.869  67.958  23.747  1.00  0.00           C  
ATOM   1631  H   LEU A 104     -21.028  67.711  20.092  1.00  0.00           H  
ATOM   1632  HA  LEU A 104     -22.439  66.446  22.257  1.00  0.00           H  
ATOM   1633  HB2 LEU A 104     -22.689  69.238  21.149  1.00  0.00           H  
ATOM   1634  HB3 LEU A 104     -23.363  68.666  22.673  1.00  0.00           H  
ATOM   1635  HG  LEU A 104     -20.457  69.067  21.985  1.00  0.00           H  
ATOM   1636 HD11 LEU A 104     -22.126  70.947  22.754  1.00  0.00           H  
ATOM   1637 HD12 LEU A 104     -20.488  70.861  23.400  1.00  0.00           H  
ATOM   1638 HD13 LEU A 104     -21.841  70.237  24.343  1.00  0.00           H  
ATOM   1639 HD21 LEU A 104     -20.211  67.228  23.301  1.00  0.00           H  
ATOM   1640 HD22 LEU A 104     -21.758  67.463  24.114  1.00  0.00           H  
ATOM   1641 HD23 LEU A 104     -20.364  68.446  24.566  1.00  0.00           H  
ATOM   1642  N   LYS A 105     -24.537  65.766  21.142  1.00  0.00           N  
ATOM   1643  CA  LYS A 105     -25.824  65.389  20.568  1.00  0.00           C  
ATOM   1644  C   LYS A 105     -26.970  66.072  21.306  1.00  0.00           C  
ATOM   1645  O   LYS A 105     -27.673  66.907  20.739  1.00  0.00           O  
ATOM   1646  CB  LYS A 105     -26.003  63.869  20.622  1.00  0.00           C  
ATOM   1647  CG  LYS A 105     -25.239  63.128  19.538  1.00  0.00           C  
ATOM   1648  CD  LYS A 105     -26.056  63.007  18.263  1.00  0.00           C  
ATOM   1649  CE  LYS A 105     -25.174  62.703  17.063  1.00  0.00           C  
ATOM   1650  NZ  LYS A 105     -24.305  63.859  16.706  1.00  0.00           N  
ATOM   1651  H   LYS A 105     -24.138  65.199  21.835  1.00  0.00           H  
ATOM   1652  HA  LYS A 105     -25.834  65.707  19.537  1.00  0.00           H  
ATOM   1653  HB2 LYS A 105     -25.662  63.513  21.582  1.00  0.00           H  
ATOM   1654  HB3 LYS A 105     -27.053  63.639  20.514  1.00  0.00           H  
ATOM   1655  HG2 LYS A 105     -24.328  63.667  19.320  1.00  0.00           H  
ATOM   1656  HG3 LYS A 105     -24.997  62.138  19.896  1.00  0.00           H  
ATOM   1657  HD2 LYS A 105     -26.772  62.208  18.380  1.00  0.00           H  
ATOM   1658  HD3 LYS A 105     -26.577  63.938  18.090  1.00  0.00           H  
ATOM   1659  HE2 LYS A 105     -24.549  61.853  17.296  1.00  0.00           H  
ATOM   1660  HE3 LYS A 105     -25.805  62.465  16.219  1.00  0.00           H  
ATOM   1661  HZ1 LYS A 105     -23.804  63.669  15.814  1.00  0.00           H  
ATOM   1662  HZ2 LYS A 105     -23.602  64.023  17.455  1.00  0.00           H  
ATOM   1663  HZ3 LYS A 105     -24.880  64.718  16.592  1.00  0.00           H  
ATOM   1664  N   GLU A 106     -27.151  65.713  22.573  1.00  0.00           N  
ATOM   1665  CA  GLU A 106     -28.212  66.294  23.387  1.00  0.00           C  
ATOM   1666  C   GLU A 106     -27.830  66.288  24.865  1.00  0.00           C  
ATOM   1667  O   GLU A 106     -27.261  65.325  25.380  1.00  0.00           O  
ATOM   1668  CB  GLU A 106     -29.519  65.525  23.185  1.00  0.00           C  
ATOM   1669  CG  GLU A 106     -29.504  64.128  23.781  1.00  0.00           C  
ATOM   1670  CD  GLU A 106     -30.585  63.235  23.207  1.00  0.00           C  
ATOM   1671  OE1 GLU A 106     -30.517  62.921  22.000  1.00  0.00           O  
ATOM   1672  OE2 GLU A 106     -31.502  62.851  23.964  1.00  0.00           O  
ATOM   1673  H   GLU A 106     -26.557  65.041  22.969  1.00  0.00           H  
ATOM   1674  HA  GLU A 106     -28.352  67.316  23.069  1.00  0.00           H  
ATOM   1675  HB2 GLU A 106     -30.324  66.081  23.642  1.00  0.00           H  
ATOM   1676  HB3 GLU A 106     -29.711  65.439  22.125  1.00  0.00           H  
ATOM   1677  HG2 GLU A 106     -28.543  63.677  23.584  1.00  0.00           H  
ATOM   1678  HG3 GLU A 106     -29.650  64.205  24.849  1.00  0.00           H  
ATOM   1679  N   PRO A 107     -28.149  67.388  25.562  1.00  0.00           N  
ATOM   1680  CA  PRO A 107     -27.848  67.534  26.989  1.00  0.00           C  
ATOM   1681  C   PRO A 107     -28.701  66.617  27.859  1.00  0.00           C  
ATOM   1682  O   PRO A 107     -29.583  65.917  27.361  1.00  0.00           O  
ATOM   1683  CB  PRO A 107     -28.181  69.001  27.274  1.00  0.00           C  
ATOM   1684  CG  PRO A 107     -29.185  69.369  26.236  1.00  0.00           C  
ATOM   1685  CD  PRO A 107     -28.827  68.572  25.012  1.00  0.00           C  
ATOM   1686  HA  PRO A 107     -26.803  67.355  27.196  1.00  0.00           H  
ATOM   1687  HB2 PRO A 107     -28.589  69.094  28.271  1.00  0.00           H  
ATOM   1688  HB3 PRO A 107     -27.287  69.600  27.187  1.00  0.00           H  
ATOM   1689  HG2 PRO A 107     -30.176  69.109  26.577  1.00  0.00           H  
ATOM   1690  HG3 PRO A 107     -29.124  70.426  26.026  1.00  0.00           H  
ATOM   1691  HD2 PRO A 107     -29.719  68.290  24.471  1.00  0.00           H  
ATOM   1692  HD3 PRO A 107     -28.161  69.138  24.376  1.00  0.00           H  
ATOM   1693  N   VAL A 108     -28.433  66.625  29.160  1.00  0.00           N  
ATOM   1694  CA  VAL A 108     -29.178  65.795  30.100  1.00  0.00           C  
ATOM   1695  C   VAL A 108     -30.408  66.527  30.625  1.00  0.00           C  
ATOM   1696  O   VAL A 108     -30.346  67.692  31.019  1.00  0.00           O  
ATOM   1697  CB  VAL A 108     -28.299  65.369  31.291  1.00  0.00           C  
ATOM   1698  CG1 VAL A 108     -29.137  64.666  32.348  1.00  0.00           C  
ATOM   1699  CG2 VAL A 108     -27.161  64.476  30.821  1.00  0.00           C  
ATOM   1700  H   VAL A 108     -27.719  67.205  29.498  1.00  0.00           H  
ATOM   1701  HA  VAL A 108     -29.496  64.904  29.578  1.00  0.00           H  
ATOM   1702  HB  VAL A 108     -27.873  66.257  31.733  1.00  0.00           H  
ATOM   1703 HG11 VAL A 108     -29.471  63.712  31.967  1.00  0.00           H  
ATOM   1704 HG12 VAL A 108     -28.541  64.512  33.236  1.00  0.00           H  
ATOM   1705 HG13 VAL A 108     -29.995  65.276  32.591  1.00  0.00           H  
ATOM   1706 HG21 VAL A 108     -26.576  64.162  31.672  1.00  0.00           H  
ATOM   1707 HG22 VAL A 108     -27.567  63.607  30.323  1.00  0.00           H  
ATOM   1708 HG23 VAL A 108     -26.534  65.023  30.134  1.00  0.00           H  
ATOM   1709  N   PRO A 109     -31.552  65.829  30.635  1.00  0.00           N  
ATOM   1710  CA  PRO A 109     -32.819  66.392  31.112  1.00  0.00           C  
ATOM   1711  C   PRO A 109     -32.825  66.610  32.621  1.00  0.00           C  
ATOM   1712  O   PRO A 109     -32.226  65.841  33.371  1.00  0.00           O  
ATOM   1713  CB  PRO A 109     -33.849  65.329  30.721  1.00  0.00           C  
ATOM   1714  CG  PRO A 109     -33.075  64.058  30.655  1.00  0.00           C  
ATOM   1715  CD  PRO A 109     -31.699  64.435  30.182  1.00  0.00           C  
ATOM   1716  HA  PRO A 109     -33.052  67.322  30.614  1.00  0.00           H  
ATOM   1717  HB2 PRO A 109     -34.625  65.282  31.473  1.00  0.00           H  
ATOM   1718  HB3 PRO A 109     -34.283  65.578  29.763  1.00  0.00           H  
ATOM   1719  HG2 PRO A 109     -33.025  63.607  31.633  1.00  0.00           H  
ATOM   1720  HG3 PRO A 109     -33.541  63.382  29.951  1.00  0.00           H  
ATOM   1721  HD2 PRO A 109     -30.955  63.801  30.641  1.00  0.00           H  
ATOM   1722  HD3 PRO A 109     -31.639  64.373  29.105  1.00  0.00           H  
ATOM   1723  N   MET A 110     -33.507  67.663  33.060  1.00  0.00           N  
ATOM   1724  CA  MET A 110     -33.592  67.981  34.480  1.00  0.00           C  
ATOM   1725  C   MET A 110     -34.712  67.189  35.148  1.00  0.00           C  
ATOM   1726  O   MET A 110     -35.712  66.856  34.512  1.00  0.00           O  
ATOM   1727  CB  MET A 110     -33.824  69.480  34.676  1.00  0.00           C  
ATOM   1728  CG  MET A 110     -35.102  69.987  34.028  1.00  0.00           C  
ATOM   1729  SD  MET A 110     -36.572  69.612  35.003  1.00  0.00           S  
ATOM   1730  CE  MET A 110     -37.747  69.221  33.707  1.00  0.00           C  
ATOM   1731  H   MET A 110     -33.964  68.241  32.413  1.00  0.00           H  
ATOM   1732  HA  MET A 110     -32.652  67.709  34.937  1.00  0.00           H  
ATOM   1733  HB2 MET A 110     -33.876  69.688  35.735  1.00  0.00           H  
ATOM   1734  HB3 MET A 110     -32.992  70.021  34.252  1.00  0.00           H  
ATOM   1735  HG2 MET A 110     -35.030  71.058  33.910  1.00  0.00           H  
ATOM   1736  HG3 MET A 110     -35.203  69.527  33.056  1.00  0.00           H  
ATOM   1737  HE1 MET A 110     -37.688  68.168  33.473  1.00  0.00           H  
ATOM   1738  HE2 MET A 110     -38.744  69.461  34.042  1.00  0.00           H  
ATOM   1739  HE3 MET A 110     -37.513  69.800  32.824  1.00  0.00           H  
ATOM   1740  N   GLN A 111     -34.536  66.891  36.431  1.00  0.00           N  
ATOM   1741  CA  GLN A 111     -35.532  66.137  37.183  1.00  0.00           C  
ATOM   1742  C   GLN A 111     -36.449  67.074  37.962  1.00  0.00           C  
ATOM   1743  O   GLN A 111     -35.985  67.991  38.639  1.00  0.00           O  
ATOM   1744  CB  GLN A 111     -34.848  65.161  38.142  1.00  0.00           C  
ATOM   1745  CG  GLN A 111     -34.111  64.033  37.438  1.00  0.00           C  
ATOM   1746  CD  GLN A 111     -35.045  63.110  36.679  1.00  0.00           C  
ATOM   1747  OE1 GLN A 111     -36.104  62.732  37.181  1.00  0.00           O  
ATOM   1748  NE2 GLN A 111     -34.657  62.743  35.464  1.00  0.00           N  
ATOM   1749  H   GLN A 111     -33.718  67.184  36.882  1.00  0.00           H  
ATOM   1750  HA  GLN A 111     -36.126  65.577  36.477  1.00  0.00           H  
ATOM   1751  HB2 GLN A 111     -34.135  65.706  38.743  1.00  0.00           H  
ATOM   1752  HB3 GLN A 111     -35.595  64.726  38.788  1.00  0.00           H  
ATOM   1753  HG2 GLN A 111     -33.407  64.460  36.739  1.00  0.00           H  
ATOM   1754  HG3 GLN A 111     -33.577  63.453  38.176  1.00  0.00           H  
ATOM   1755 HE21 GLN A 111     -33.800  63.083  35.129  1.00  0.00           H  
ATOM   1756 HE22 GLN A 111     -35.241  62.146  34.952  1.00  0.00           H  
ATOM   1757  N   ASP A 112     -37.753  66.837  37.861  1.00  0.00           N  
ATOM   1758  CA  ASP A 112     -38.736  67.659  38.556  1.00  0.00           C  
ATOM   1759  C   ASP A 112     -39.415  66.869  39.669  1.00  0.00           C  
ATOM   1760  O   ASP A 112     -40.497  66.312  39.476  1.00  0.00           O  
ATOM   1761  CB  ASP A 112     -39.783  68.181  37.572  1.00  0.00           C  
ATOM   1762  CG  ASP A 112     -41.074  68.583  38.259  1.00  0.00           C  
ATOM   1763  OD1 ASP A 112     -41.005  69.293  39.283  1.00  0.00           O  
ATOM   1764  OD2 ASP A 112     -42.154  68.185  37.773  1.00  0.00           O  
ATOM   1765  H   ASP A 112     -38.061  66.091  37.304  1.00  0.00           H  
ATOM   1766  HA  ASP A 112     -38.216  68.499  38.993  1.00  0.00           H  
ATOM   1767  HB2 ASP A 112     -39.387  69.047  37.060  1.00  0.00           H  
ATOM   1768  HB3 ASP A 112     -40.005  67.411  36.849  1.00  0.00           H  
ATOM   1769  N   GLN A 113     -38.774  66.822  40.833  1.00  0.00           N  
ATOM   1770  CA  GLN A 113     -39.317  66.098  41.975  1.00  0.00           C  
ATOM   1771  C   GLN A 113     -40.822  66.311  42.090  1.00  0.00           C  
ATOM   1772  O   GLN A 113     -41.598  65.356  42.070  1.00  0.00           O  
ATOM   1773  CB  GLN A 113     -38.626  66.545  43.265  1.00  0.00           C  
ATOM   1774  CG  GLN A 113     -38.600  65.476  44.345  1.00  0.00           C  
ATOM   1775  CD  GLN A 113     -39.940  64.784  44.513  1.00  0.00           C  
ATOM   1776  OE1 GLN A 113     -40.209  63.765  43.878  1.00  0.00           O  
ATOM   1777  NE2 GLN A 113     -40.787  65.336  45.373  1.00  0.00           N  
ATOM   1778  H   GLN A 113     -37.916  67.286  40.923  1.00  0.00           H  
ATOM   1779  HA  GLN A 113     -39.125  65.046  41.822  1.00  0.00           H  
ATOM   1780  HB2 GLN A 113     -37.608  66.821  43.036  1.00  0.00           H  
ATOM   1781  HB3 GLN A 113     -39.145  67.408  43.656  1.00  0.00           H  
ATOM   1782  HG2 GLN A 113     -37.861  64.734  44.082  1.00  0.00           H  
ATOM   1783  HG3 GLN A 113     -38.329  65.936  45.283  1.00  0.00           H  
ATOM   1784 HE21 GLN A 113     -40.505  66.150  45.843  1.00  0.00           H  
ATOM   1785 HE22 GLN A 113     -41.660  64.912  45.500  1.00  0.00           H  
ATOM   1786  N   SER A 114     -41.229  67.570  42.212  1.00  0.00           N  
ATOM   1787  CA  SER A 114     -42.642  67.910  42.334  1.00  0.00           C  
ATOM   1788  C   SER A 114     -43.503  66.957  41.510  1.00  0.00           C  
ATOM   1789  O   SER A 114     -43.353  66.862  40.292  1.00  0.00           O  
ATOM   1790  CB  SER A 114     -42.883  69.351  41.884  1.00  0.00           C  
ATOM   1791  OG  SER A 114     -42.102  70.259  42.640  1.00  0.00           O  
ATOM   1792  H   SER A 114     -40.562  68.289  42.221  1.00  0.00           H  
ATOM   1793  HA  SER A 114     -42.916  67.815  43.374  1.00  0.00           H  
ATOM   1794  HB2 SER A 114     -42.619  69.449  40.842  1.00  0.00           H  
ATOM   1795  HB3 SER A 114     -43.928  69.597  42.015  1.00  0.00           H  
ATOM   1796  HG  SER A 114     -41.172  70.128  42.439  1.00  0.00           H  
ATOM   1797  N   GLY A 115     -44.405  66.250  42.184  1.00  0.00           N  
ATOM   1798  CA  GLY A 115     -45.277  65.314  41.500  1.00  0.00           C  
ATOM   1799  C   GLY A 115     -46.075  64.455  42.461  1.00  0.00           C  
ATOM   1800  O   GLY A 115     -45.711  64.287  43.625  1.00  0.00           O  
ATOM   1801  H   GLY A 115     -44.480  66.367  43.155  1.00  0.00           H  
ATOM   1802  HA2 GLY A 115     -45.962  65.867  40.875  1.00  0.00           H  
ATOM   1803  HA3 GLY A 115     -44.675  64.670  40.876  1.00  0.00           H  
ATOM   1804  N   PRO A 116     -47.192  63.897  41.974  1.00  0.00           N  
ATOM   1805  CA  PRO A 116     -48.068  63.043  42.782  1.00  0.00           C  
ATOM   1806  C   PRO A 116     -47.425  61.701  43.114  1.00  0.00           C  
ATOM   1807  O   PRO A 116     -47.646  61.143  44.188  1.00  0.00           O  
ATOM   1808  CB  PRO A 116     -49.293  62.842  41.887  1.00  0.00           C  
ATOM   1809  CG  PRO A 116     -48.783  63.030  40.499  1.00  0.00           C  
ATOM   1810  CD  PRO A 116     -47.688  64.055  40.596  1.00  0.00           C  
ATOM   1811  HA  PRO A 116     -48.366  63.534  43.697  1.00  0.00           H  
ATOM   1812  HB2 PRO A 116     -49.689  61.848  42.032  1.00  0.00           H  
ATOM   1813  HB3 PRO A 116     -50.047  63.575  42.132  1.00  0.00           H  
ATOM   1814  HG2 PRO A 116     -48.392  62.097  40.123  1.00  0.00           H  
ATOM   1815  HG3 PRO A 116     -49.578  63.390  39.862  1.00  0.00           H  
ATOM   1816  HD2 PRO A 116     -46.908  63.844  39.880  1.00  0.00           H  
ATOM   1817  HD3 PRO A 116     -48.085  65.048  40.442  1.00  0.00           H  
ATOM   1818  N   SER A 117     -46.626  61.187  42.182  1.00  0.00           N  
ATOM   1819  CA  SER A 117     -45.953  59.908  42.375  1.00  0.00           C  
ATOM   1820  C   SER A 117     -45.227  59.872  43.716  1.00  0.00           C  
ATOM   1821  O   SER A 117     -44.135  60.425  43.859  1.00  0.00           O  
ATOM   1822  CB  SER A 117     -44.961  59.655  41.238  1.00  0.00           C  
ATOM   1823  OG  SER A 117     -44.593  58.287  41.177  1.00  0.00           O  
ATOM   1824  H   SER A 117     -46.489  61.680  41.346  1.00  0.00           H  
ATOM   1825  HA  SER A 117     -46.704  59.133  42.366  1.00  0.00           H  
ATOM   1826  HB2 SER A 117     -45.414  59.935  40.299  1.00  0.00           H  
ATOM   1827  HB3 SER A 117     -44.073  60.247  41.400  1.00  0.00           H  
ATOM   1828  HG  SER A 117     -45.334  57.744  41.457  1.00  0.00           H  
ATOM   1829  N   SER A 118     -45.840  59.218  44.697  1.00  0.00           N  
ATOM   1830  CA  SER A 118     -45.256  59.114  46.029  1.00  0.00           C  
ATOM   1831  C   SER A 118     -45.107  57.652  46.443  1.00  0.00           C  
ATOM   1832  O   SER A 118     -45.590  56.750  45.760  1.00  0.00           O  
ATOM   1833  CB  SER A 118     -46.118  59.859  47.048  1.00  0.00           C  
ATOM   1834  OG  SER A 118     -45.518  59.845  48.332  1.00  0.00           O  
ATOM   1835  H   SER A 118     -46.709  58.800  44.521  1.00  0.00           H  
ATOM   1836  HA  SER A 118     -44.276  59.568  45.997  1.00  0.00           H  
ATOM   1837  HB2 SER A 118     -46.239  60.884  46.732  1.00  0.00           H  
ATOM   1838  HB3 SER A 118     -47.087  59.386  47.111  1.00  0.00           H  
ATOM   1839  HG  SER A 118     -45.241  60.733  48.566  1.00  0.00           H  
ATOM   1840  N   GLY A 119     -44.435  57.428  47.569  1.00  0.00           N  
ATOM   1841  CA  GLY A 119     -44.235  56.076  48.055  1.00  0.00           C  
ATOM   1842  C   GLY A 119     -45.491  55.233  47.960  1.00  0.00           C  
ATOM   1843  O   GLY A 119     -45.960  54.692  48.961  1.00  0.00           O  
ATOM   1844  H   GLY A 119     -44.073  58.187  48.071  1.00  0.00           H  
ATOM   1845  HA2 GLY A 119     -43.455  55.608  47.473  1.00  0.00           H  
ATOM   1846  HA3 GLY A 119     -43.923  56.120  49.088  1.00  0.00           H  
TER    1847      GLY A 119                                                      
END
MOLECULE T0501_215_342.pdb
ATOM   1713  N   TYR   215     -29.768  57.258  48.318  1.00 60.97          
ATOM   1714  CA  TYR   215     -29.643  58.695  48.234  1.00 64.94          
ATOM   1715  CB  TYR   215     -28.896  59.097  46.962  1.00 68.48          
ATOM   1716  CG  TYR   215     -29.442  58.569  45.659  1.00 70.87          
ATOM   1717  CD1 TYR   215     -30.726  58.895  45.226  1.00 70.95          
ATOM   1718  CE1 TYR   215     -31.173  58.513  43.966  1.00 73.22          
ATOM   1719  CD2 TYR   215     -28.624  57.833  44.802  1.00 72.47          
ATOM   1720  CE2 TYR   215     -29.058  57.447  43.550  1.00 73.60          
ATOM   1721  CZ  TYR   215     -30.329  57.790  43.134  1.00 73.73          
ATOM   1722  OH  TYR   215     -30.737  57.422  41.873  1.00 76.16          
ATOM   1723  C   TYR   215     -30.955  59.450  48.360  1.00 65.33          
ATOM   1724  O   TYR   215     -32.026  58.937  48.031  1.00 65.22          
ATOM   1725  N   SER   216     -30.831  60.677  48.860  1.00 65.24          
ATOM   1726  CA  SER   216     -31.943  61.584  49.112  1.00 64.65          
ATOM   1727  CB  SER   216     -31.414  63.004  49.313  1.00 64.60          
ATOM   1728  OG  SER   216     -30.841  63.506  48.120  1.00 63.79          
ATOM   1729  C   SER   216     -33.026  61.620  48.056  1.00 64.75          
ATOM   1730  O   SER   216     -32.791  61.322  46.887  1.00 64.09          
ATOM   1731  N   GLU   217     -34.223  62.003  48.489  1.00 64.67          
ATOM   1732  CA  GLU   217     -35.349  62.112  47.581  1.00 64.51          
ATOM   1733  CB  GLU   217     -36.671  62.143  48.359  1.00 64.82          
ATOM   1734  CG  GLU   217     -37.009  63.481  48.995  1.00 66.08          
ATOM   1735  CD  GLU   217     -38.432  63.525  49.532  1.00 67.22          
ATOM   1736  OE1 GLU   217     -38.706  62.864  50.558  1.00 67.19          
ATOM   1737  OE2 GLU   217     -39.279  64.212  48.921  1.00 66.61          
ATOM   1738  C   GLU   217     -35.161  63.408  46.793  1.00 63.35          
ATOM   1739  O   GLU   217     -35.590  63.520  45.647  1.00 62.99          
ATOM   1740  N   SER   218     -34.508  64.387  47.411  1.00 62.49          
ATOM   1741  CA  SER   218     -34.269  65.653  46.734  1.00 62.13          
ATOM   1742  CB  SER   218     -33.729  66.706  47.713  1.00 62.09          
ATOM   1743  OG  SER   218     -32.549  66.272  48.364  1.00 63.59          
ATOM   1744  C   SER   218     -33.290  65.436  45.583  1.00 60.92          
ATOM   1745  O   SER   218     -33.449  66.016  44.508  1.00 61.29          
ATOM   1746  N   ARG   219     -32.287  64.589  45.801  1.00 59.33          
ATOM   1747  CA  ARG   219     -31.306  64.314  44.756  1.00 57.64          
ATOM   1748  CB  ARG   219     -30.192  63.405  45.262  1.00 56.77          
ATOM   1749  CG  ARG   219     -29.184  63.118  44.177  1.00 56.78          
ATOM   1750  CD  ARG   219     -28.209  62.018  44.521  1.00 56.74          
ATOM   1751  NE  ARG   219     -27.357  61.741  43.367  1.00 56.32          
ATOM   1752  CZ  ARG   219     -26.617  60.648  43.214  1.00 55.49          
ATOM   1753  NH1 ARG   219     -26.607  59.705  44.147  1.00 54.32          
ATOM   1754  NH2 ARG   219     -25.897  60.494  42.112  1.00 54.53          
ATOM   1755  C   ARG   219     -31.964  63.652  43.554  1.00 57.05          
ATOM   1756  O   ARG   219     -31.607  63.934  42.414  1.00 57.65          
ATOM   1757  N   LEU   220     -32.926  62.772  43.813  1.00 56.18          
ATOM   1758  CA  LEU   220     -33.621  62.072  42.743  1.00 54.89          
ATOM   1759  CB  LEU   220     -34.394  60.877  43.308  1.00 52.70          
ATOM   1760  CG  LEU   220     -35.102  59.972  42.293  1.00 53.13          
ATOM   1761  CD1 LEU   220     -34.079  59.301  41.374  1.00 50.43          
ATOM   1762  CD2 LEU   220     -35.928  58.929  43.040  1.00 51.08          
ATOM   1763  C   LEU   220     -34.573  63.020  42.024  1.00 56.59          
ATOM   1764  O   LEU   220     -34.759  62.928  40.805  1.00 57.40          
ATOM   1765  N   ARG   221     -35.184  63.931  42.776  1.00 57.64          
ATOM   1766  CA  ARG   221     -36.101  64.892  42.172  1.00 57.29          
ATOM   1767  CB  ARG   221     -36.896  65.647  43.251  1.00 59.13          
ATOM   1768  CG  ARG   221     -37.879  66.672  42.674  1.00 62.76          
ATOM   1769  CD  ARG   221     -38.806  67.295  43.726  1.00 64.56          
ATOM   1770  NE  ARG   221     -39.776  66.345  44.271  1.00 64.79          
ATOM   1771  CZ  ARG   221     -39.683  65.789  45.474  1.00 63.56          
ATOM   1772  NH1 ARG   221     -38.661  66.084  46.269  1.00 63.93          
ATOM   1773  NH2 ARG   221     -40.620  64.948  45.889  1.00 63.73          
ATOM   1774  C   ARG   221     -35.256  65.862  41.348  1.00 55.73          
ATOM   1775  O   ARG   221     -35.691  66.367  40.310  1.00 55.20          
ATOM   1776  N   LEU   222     -34.040  66.112  41.822  1.00 53.75          
ATOM   1777  CA  LEU   222     -33.109  66.993  41.129  1.00 52.91          
ATOM   1778  CB  LEU   222     -31.843  67.168  41.973  1.00 51.72          
ATOM   1779  CG  LEU   222     -30.618  67.835  41.340  1.00 51.16          
ATOM   1780  CD1 LEU   222     -31.001  69.171  40.715  1.00 49.88          
ATOM   1781  CD2 LEU   222     -29.548  68.017  42.405  1.00 47.57          
ATOM   1782  C   LEU   222     -32.772  66.357  39.775  1.00 52.81          
ATOM   1783  O   LEU   222     -32.778  67.026  38.737  1.00 51.55          
ATOM   1784  N   MET   223     -32.492  65.056  39.796  1.00 52.32          
ATOM   1785  CA  MET   223     -32.173  64.328  38.577  1.00 51.62          
ATOM   1786  CB  MET   223     -31.941  62.843  38.880  1.00 48.73          
ATOM   1787  CG  MET   223     -31.503  62.018  37.674  1.00 44.87          
ATOM   1788  SD  MET   223     -31.406  60.134  38.077  0.13 37.73          
ATOM   1789  CE  MET   223     -33.088  59.686  37.369  1.00 34.67          
ATOM   1790  C   MET   223     -33.344  64.482  37.631  1.00 52.14          
ATOM   1791  O   MET   223     -33.161  64.767  36.451  1.00 52.20          
ATOM   1792  N   GLY   224     -34.549  64.306  38.167  1.00 53.78          
ATOM   1793  CA  GLY   224     -35.749  64.426  37.361  1.00 56.08          
ATOM   1794  C   GLY   224     -35.899  65.804  36.744  1.00 57.39          
ATOM   1795  O   GLY   224     -36.400  65.947  35.631  1.00 57.13          
ATOM   1796  N   TYR   225     -35.462  66.826  37.467  1.00 59.05          
ATOM   1797  CA  TYR   225     -35.556  68.192  36.970  1.00 61.25          
ATOM   1798  CB  TYR   225     -35.102  69.178  38.053  1.00 63.88          
ATOM   1799  CG  TYR   225     -35.257  70.631  37.669  1.00 67.10          
ATOM   1800  CD1 TYR   225     -36.522  71.191  37.476  1.00 67.74          
ATOM   1801  CE1 TYR   225     -36.669  72.530  37.109  1.00 69.01          
ATOM   1802  CD2 TYR   225     -34.138  71.448  37.486  1.00 67.94          
ATOM   1803  CE2 TYR   225     -34.273  72.783  37.120  1.00 68.57          
ATOM   1804  CZ  TYR   225     -35.541  73.317  36.933  1.00 69.55          
ATOM   1805  OH  TYR   225     -35.679  74.635  36.562  1.00 70.89          
ATOM   1806  C   TYR   225     -34.661  68.320  35.744  1.00 60.59          
ATOM   1807  O   TYR   225     -35.141  68.571  34.634  1.00 61.05          
ATOM   1808  N   VAL   226     -33.360  68.137  35.967  1.00 59.42          
ATOM   1809  CA  VAL   226     -32.343  68.221  34.923  1.00 57.86          
ATOM   1810  CB  VAL   226     -31.014  67.608  35.414  1.00 57.41          
ATOM   1811  CG1 VAL   226     -30.003  67.571  34.292  1.00 56.88          
ATOM   1812  CG2 VAL   226     -30.474  68.418  36.573  1.00 56.65          
ATOM   1813  C   VAL   226     -32.768  67.520  33.640  1.00 58.20          
ATOM   1814  O   VAL   226     -32.519  68.012  32.539  1.00 57.93          
ATOM   1815  N   LEU   227     -33.407  66.369  33.784  1.00 58.38          
ATOM   1816  CA  LEU   227     -33.867  65.617  32.630  1.00 60.01          
ATOM   1817  CB  LEU   227     -34.303  64.207  33.051  1.00 59.18          
ATOM   1818  CG  LEU   227     -33.181  63.241  33.446  1.00 59.72          
ATOM   1819  CD1 LEU   227     -33.770  61.922  33.949  1.00 59.96          
ATOM   1820  CD2 LEU   227     -32.278  63.009  32.251  1.00 57.39          
ATOM   1821  C   LEU   227     -35.021  66.328  31.932  1.00 61.44          
ATOM   1822  O   LEU   227     -35.031  66.449  30.706  1.00 61.68          
ATOM   1823  N   SER   228     -35.995  66.792  32.712  1.00 62.54          
ATOM   1824  CA  SER   228     -37.152  67.491  32.156  1.00 62.62          
ATOM   1825  CB  SER   228     -38.081  67.982  33.272  1.00 63.05          
ATOM   1826  OG  SER   228     -38.848  66.919  33.806  1.00 63.58          
ATOM   1827  C   SER   228     -36.729  68.679  31.311  1.00 62.47          
ATOM   1828  O   SER   228     -37.395  69.015  30.337  1.00 61.89          
ATOM   1829  N   ASN   229     -35.613  69.302  31.681  1.00 62.45          
ATOM   1830  CA  ASN   229     -35.109  70.471  30.964  1.00 63.79          
ATOM   1831  CB  ASN   229     -34.639  71.529  31.972  1.00 64.43          
ATOM   1832  CG  ASN   229     -35.714  71.886  32.996  1.00 66.67          
ATOM   1833  OD1 ASN   229     -35.455  72.614  33.953  1.00 68.15          
ATOM   1834  ND2 ASN   229     -36.921  71.374  32.797  1.00 66.23          
ATOM   1835  C   ASN   229     -33.966  70.148  29.998  1.00 63.54          
ATOM   1836  O   ASN   229     -33.242  71.047  29.563  1.00 63.49          
ATOM   1837  N   MET   230     -33.811  68.876  29.647  1.00 63.01          
ATOM   1838  CA  MET   230     -32.726  68.482  28.752  1.00 62.77          
ATOM   1839  CB  MET   230     -32.529  66.956  28.771  1.00 62.90          
ATOM   1840  CG  MET   230     -33.360  66.170  27.759  1.00 63.84          
ATOM   1841  SD  MET   230     -32.791  64.310  27.624  0.73 64.10          
ATOM   1842  CE  MET   230     -30.937  64.546  28.085  1.00 61.93          
ATOM   1843  C   MET   230     -32.940  68.953  27.319  1.00 61.65          
ATOM   1844  O   MET   230     -34.072  69.027  26.843  1.00 60.54          
ATOM   1845  N   LYS   231     -31.838  69.269  26.643  1.00 61.07          
ATOM   1846  CA  LYS   231     -31.881  69.723  25.255  1.00 61.28          
ATOM   1847  CB  LYS   231     -31.219  71.102  25.138  1.00 62.21          
ATOM   1848  CG  LYS   231     -31.777  71.988  24.031  1.00 64.31          
ATOM   1849  CD  LYS   231     -31.597  71.371  22.653  1.00 65.78          
ATOM   1850  CE  LYS   231     -32.195  72.256  21.568  1.00 66.58          
ATOM   1851  NZ  LYS   231     -31.576  73.614  21.563  1.00 67.76          
ATOM   1852  C   LYS   231     -31.149  68.701  24.372  1.00 61.10          
ATOM   1853  O   LYS   231     -29.974  68.392  24.594  1.00 60.65          
ATOM   1854  N   VAL   232     -31.852  68.173  23.377  1.00 61.18          
ATOM   1855  CA  VAL   232     -31.281  67.182  22.472  1.00 61.23          
ATOM   1856  CB  VAL   232     -32.205  65.964  22.326  1.00 59.94          
ATOM   1857  CG1 VAL   232     -31.622  64.995  21.314  1.00 60.27          
ATOM   1858  CG2 VAL   232     -32.396  65.287  23.664  1.00 60.43          
ATOM   1859  C   VAL   232     -31.040  67.728  21.069  1.00 62.68          
ATOM   1860  O   VAL   232     -31.986  68.100  20.373  1.00 63.22          
ATOM   1861  N   TYR   233     -29.779  67.763  20.646  1.00 62.65          
ATOM   1862  CA  TYR   233     -29.450  68.239  19.309  1.00 62.43          
ATOM   1863  CB  TYR   233     -28.021  68.761  19.270  1.00 62.71          
ATOM   1864  CG  TYR   233     -27.788  69.920  20.207  1.00 63.03          
ATOM   1865  CD1 TYR   233     -27.814  69.740  21.584  1.00 62.72          
ATOM   1866  CE1 TYR   233     -27.586  70.800  22.450  1.00 63.76          
ATOM   1867  CD2 TYR   233     -27.532  71.199  19.715  1.00 63.88          
ATOM   1868  CE2 TYR   233     -27.302  72.269  20.575  1.00 63.76          
ATOM   1869  CZ  TYR   233     -27.329  72.060  21.940  1.00 64.26          
ATOM   1870  OH  TYR   233     -27.082  73.106  22.803  1.00 66.30          
ATOM   1871  C   TYR   233     -29.627  67.066  18.354  1.00 62.99          
ATOM   1872  O   TYR   233     -28.673  66.388  17.982  1.00 62.09          
ATOM   1873  N   LYS   234     -30.880  66.852  17.975  1.00 63.83          
ATOM   1874  CA  LYS   234     -31.310  65.766  17.103  1.00 65.43          
ATOM   1875  CB  LYS   234     -32.729  66.066  16.608  1.00 65.86          
ATOM   1876  CG  LYS   234     -33.388  64.934  15.852  1.00 66.38          
ATOM   1877  CD  LYS   234     -34.877  65.199  15.641  1.00 69.15          
ATOM   1878  CE  LYS   234     -35.679  65.120  16.943  1.00 69.37          
ATOM   1879  NZ  LYS   234     -35.321  66.190  17.922  1.00 70.38          
ATOM   1880  C   LYS   234     -30.426  65.410  15.916  1.00 66.31          
ATOM   1881  O   LYS   234     -30.399  64.258  15.486  1.00 67.07          
ATOM   1882  N   ASP   235     -29.699  66.384  15.389  1.00 67.22          
ATOM   1883  CA  ASP   235     -28.863  66.134  14.224  1.00 67.90          
ATOM   1884  CB  ASP   235     -28.997  67.312  13.254  1.00 70.19          
ATOM   1885  CG  ASP   235     -28.384  67.027  11.905  1.00 72.04          
ATOM   1886  OD1 ASP   235     -28.774  66.014  11.279  1.00 72.93          
ATOM   1887  OD2 ASP   235     -27.517  67.817  11.470  1.00 73.64          
ATOM   1888  C   ASP   235     -27.388  65.875  14.536  1.00 66.92          
ATOM   1889  O   ASP   235     -26.606  65.549  13.643  1.00 66.83          
ATOM   1890  N   TYR   236     -27.009  66.009  15.801  1.00 65.48          
ATOM   1891  CA  TYR   236     -25.624  65.793  16.201  1.00 63.24          
ATOM   1892  CB  TYR   236     -25.092  67.027  16.935  1.00 65.76          
ATOM   1893  CG  TYR   236     -25.100  68.288  16.099  1.00 69.42          
ATOM   1894  CD1 TYR   236     -26.280  68.754  15.510  1.00 70.19          
ATOM   1895  CE1 TYR   236     -26.292  69.912  14.735  1.00 71.86          
ATOM   1896  CD2 TYR   236     -23.926  69.019  15.890  1.00 70.25          
ATOM   1897  CE2 TYR   236     -23.928  70.182  15.115  1.00 71.36          
ATOM   1898  CZ  TYR   236     -25.115  70.618  14.542  1.00 71.89          
ATOM   1899  OH  TYR   236     -25.130  71.755  13.771  1.00 73.46          
ATOM   1900  C   TYR   236     -25.489  64.569  17.099  1.00 60.81          
ATOM   1901  O   TYR   236     -24.403  64.287  17.611  1.00 58.59          
ATOM   1902  N   ASN   237     -26.598  63.853  17.279  1.00 57.88          
ATOM   1903  CA  ASN   237     -26.638  62.657  18.117  1.00 55.27          
ATOM   1904  CB  ASN   237     -25.868  61.522  17.438  1.00 55.59          
ATOM   1905  CG  ASN   237     -26.551  61.027  16.175  1.00 57.91          
ATOM   1906  OD1 ASN   237     -25.898  60.525  15.263  1.00 59.05          
ATOM   1907  ND2 ASN   237     -27.875  61.154  16.122  1.00 58.52          
ATOM   1908  C   ASN   237     -26.041  62.951  19.489  1.00 53.61          
ATOM   1909  O   ASN   237     -25.306  62.131  20.059  1.00 51.38          
ATOM   1910  N   SER   238     -26.361  64.129  20.015  1.00 50.85          
ATOM   1911  CA  SER   238     -25.844  64.547  21.306  1.00 50.13          
ATOM   1912  CB  SER   238     -24.691  65.527  21.110  1.00 50.06          
ATOM   1913  OG  SER   238     -23.744  65.005  20.194  1.00 49.61          
ATOM   1914  C   SER   238     -26.922  65.198  22.153  1.00 49.94          
ATOM   1915  O   SER   238     -27.911  65.706  21.627  1.00 50.94          
ATOM   1916  N   ALA   239     -26.726  65.178  23.468  1.00 49.31          
ATOM   1917  CA  ALA   239     -27.681  65.775  24.393  1.00 49.09          
ATOM   1918  CB  ALA   239     -28.481  64.695  25.091  1.00 47.63          
ATOM   1919  C   ALA   239     -26.954  66.637  25.418  1.00 50.50          
ATOM   1920  O   ALA   239     -25.797  66.376  25.761  1.00 50.02          
ATOM   1921  N   LEU   240     -27.640  67.672  25.893  1.00 51.89          
ATOM   1922  CA  LEU   240     -27.075  68.585  26.871  1.00 52.67          
ATOM   1923  CB  LEU   240     -26.758  69.926  26.203  1.00 54.70          
ATOM   1924  CG  LEU   240     -26.214  71.079  27.056  1.00 55.50          
ATOM   1925  CD1 LEU   240     -24.842  70.732  27.620  1.00 54.72          
ATOM   1926  CD2 LEU   240     -26.131  72.334  26.182  1.00 56.24          
ATOM   1927  C   LEU   240     -28.044  68.806  28.023  1.00 51.93          
ATOM   1928  O   LEU   240     -29.245  68.993  27.816  1.00 52.19          
ATOM   1929  N   ILE   241     -27.512  68.775  29.237  1.00 49.82          
ATOM   1930  CA  ILE   241     -28.307  68.993  30.436  1.00 49.60          
ATOM   1931  CB  ILE   241     -28.503  67.686  31.222  1.00 48.78          
ATOM   1932  CG2 ILE   241     -29.488  66.793  30.487  1.00 44.17          
ATOM   1933  CG1 ILE   241     -27.152  66.996  31.424  1.00 48.12          
ATOM   1934  CD  ILE   241     -27.221  65.736  32.269  1.00 50.16          
ATOM   1935  C   ILE   241     -27.548  69.994  31.286  1.00 50.76          
ATOM   1936  O   ILE   241     -26.331  70.123  31.143  1.00 50.83          
ATOM   1937  N   SER   242     -28.241  70.699  32.175  1.00 52.14          
ATOM   1938  CA  SER   242     -27.547  71.697  32.983  1.00 54.45          
ATOM   1939  CB  SER   242     -27.386  72.973  32.165  1.00 53.65          
ATOM   1940  OG  SER   242     -28.652  73.464  31.756  1.00 52.20          
ATOM   1941  C   SER   242     -28.160  72.059  34.323  1.00 55.95          
ATOM   1942  O   SER   242     -29.325  71.783  34.588  1.00 56.13          
ATOM   1943  N   LEU   243     -27.343  72.685  35.166  1.00 59.12          
ATOM   1944  CA  LEU   243     -27.762  73.147  36.485  1.00 62.12          
ATOM   1945  CB  LEU   243     -27.428  72.118  37.569  1.00 61.85          
ATOM   1946  CG  LEU   243     -28.501  71.073  37.893  1.00 61.98          
ATOM   1947  CD1 LEU   243     -28.025  70.223  39.060  1.00 61.89          
ATOM   1948  CD2 LEU   243     -29.818  71.755  38.250  1.00 61.29          
ATOM   1949  C   LEU   243     -27.099  74.475  36.833  1.00 63.90          
ATOM   1950  O   LEU   243     -25.879  74.622  36.731  1.00 63.74          
ATOM   1951  N   THR   244     -27.916  75.441  37.239  1.00 66.79          
ATOM   1952  CA  THR   244     -27.425  76.765  37.617  1.00 69.00          
ATOM   1953  CB  THR   244     -28.403  77.876  37.171  1.00 69.03          
ATOM   1954  OG1 THR   244     -29.583  77.830  37.983  1.00 69.06          
ATOM   1955  CG2 THR   244     -28.801  77.686  35.713  1.00 68.67          
ATOM   1956  C   THR   244     -27.296  76.824  39.136  1.00 70.26          
ATOM   1957  O   THR   244     -27.713  75.900  39.831  1.00 70.29          
ATOM   1958  N   LYS   245     -26.726  77.910  39.650  1.00 72.86          
ATOM   1959  CA  LYS   245     -26.566  78.068  41.093  1.00 74.97          
ATOM   1960  CB  LYS   245     -25.669  79.266  41.406  1.00 75.54          
ATOM   1961  CG  LYS   245     -26.167  80.576  40.818  1.00 76.76          
ATOM   1962  CD  LYS   245     -25.101  81.654  40.910  1.00 77.11          
ATOM   1963  CE  LYS   245     -25.420  82.813  39.983  1.00 77.08          
ATOM   1964  NZ  LYS   245     -24.245  83.706  39.818  1.00 76.60          
ATOM   1965  C   LYS   245     -27.922  78.257  41.763  1.00 76.01          
ATOM   1966  O   LYS   245     -28.102  77.888  42.925  1.00 76.44          
ATOM   1967  N   GLU   246     -28.871  78.834  41.026  1.00 77.01          
ATOM   1968  CA  GLU   246     -30.212  79.066  41.557  1.00 78.21          
ATOM   1969  CB  GLU   246     -30.952  80.123  40.724  1.00 79.95          
ATOM   1970  CG  GLU   246     -32.323  80.509  41.293  1.00 82.18          
ATOM   1971  CD  GLU   246     -32.986  81.672  40.557  1.00 83.26          
ATOM   1972  OE1 GLU   246     -34.123  82.044  40.930  1.00 81.91          
ATOM   1973  OE2 GLU   246     -32.372  82.214  39.609  1.00 84.69          
ATOM   1974  C   GLU   246     -31.001  77.759  41.563  1.00 77.36          
ATOM   1975  O   GLU   246     -31.775  77.494  42.484  1.00 77.18          
ATOM   1976  N   GLU   247     -30.798  76.947  40.531  1.00 76.98          
ATOM   1977  CA  GLU   247     -31.478  75.662  40.433  1.00 76.38          
ATOM   1978  CB  GLU   247     -31.241  75.034  39.059  1.00 75.83          
ATOM   1979  CG  GLU   247     -31.804  75.842  37.908  1.00 74.75          
ATOM   1980  CD  GLU   247     -31.505  75.219  36.564  1.00 74.37          
ATOM   1981  OE1 GLU   247     -30.309  75.047  36.246  1.00 73.41          
ATOM   1982  OE2 GLU   247     -32.464  74.903  35.826  1.00 73.42          
ATOM   1983  C   GLU   247     -30.945  74.738  41.519  1.00 76.51          
ATOM   1984  O   GLU   247     -31.719  74.087  42.221  1.00 76.22          
ATOM   1985  N   GLN   248     -29.621  74.692  41.656  1.00 76.48          
ATOM   1986  CA  GLN   248     -28.979  73.848  42.659  1.00 76.95          
ATOM   1987  CB  GLN   248     -27.458  74.024  42.621  1.00 76.96          
ATOM   1988  CG  GLN   248     -26.809  73.682  41.289  1.00 75.45          
ATOM   1989  CD  GLN   248     -25.343  74.069  41.252  1.00 75.09          
ATOM   1990  OE1 GLN   248     -24.745  74.193  40.183  1.00 73.81          
ATOM   1991  NE2 GLN   248     -24.757  74.260  42.425  1.00 74.63          
ATOM   1992  C   GLN   248     -29.486  74.192  44.052  1.00 77.44          
ATOM   1993  O   GLN   248     -29.993  73.326  44.767  1.00 78.20          
ATOM   1994  N   GLY   249     -29.346  75.460  44.431  1.00 78.06          
ATOM   1995  CA  GLY   249     -29.796  75.904  45.742  1.00 77.96          
ATOM   1996  C   GLY   249     -31.246  75.552  46.027  1.00 77.76          
ATOM   1997  O   GLY   249     -31.595  75.161  47.144  1.00 77.46          
ATOM   1998  N   LYS   250     -32.093  75.694  45.013  1.00 77.40          
ATOM   1999  CA  LYS   250     -33.511  75.386  45.141  1.00 77.73          
ATOM   2000  CB  LYS   250     -34.200  75.551  43.783  1.00 78.19          
ATOM   2001  CG  LYS   250     -35.622  75.020  43.730  1.00 79.73          
ATOM   2002  CD  LYS   250     -36.200  75.135  42.328  1.00 80.69          
ATOM   2003  CE  LYS   250     -37.622  74.598  42.268  1.00 81.46          
ATOM   2004  NZ  LYS   250     -38.171  74.636  40.882  1.00 82.06          
ATOM   2005  C   LYS   250     -33.723  73.963  45.653  1.00 77.61          
ATOM   2006  O   LYS   250     -34.460  73.741  46.614  1.00 77.61          
ATOM   2007  N   PHE   251     -33.062  73.008  45.004  1.00 77.50          
ATOM   2008  CA  PHE   251     -33.168  71.594  45.349  1.00 76.85          
ATOM   2009  CB  PHE   251     -32.851  70.745  44.115  1.00 76.33          
ATOM   2010  CG  PHE   251     -33.924  70.776  43.063  1.00 75.87          
ATOM   2011  CD1 PHE   251     -34.994  69.885  43.116  1.00 75.60          
ATOM   2012  CD2 PHE   251     -33.872  71.702  42.026  1.00 75.53          
ATOM   2013  CE1 PHE   251     -35.999  69.915  42.148  1.00 76.83          
ATOM   2014  CE2 PHE   251     -34.870  71.744  41.053  1.00 76.82          
ATOM   2015  CZ  PHE   251     -35.938  70.848  41.113  1.00 76.97          
ATOM   2016  C   PHE   251     -32.268  71.161  46.508  1.00 76.91          
ATOM   2017  O   PHE   251     -32.169  69.970  46.810  1.00 77.40          
ATOM   2018  N   ASP   252     -31.620  72.122  47.158  1.00 76.00          
ATOM   2019  CA  ASP   252     -30.733  71.816  48.276  1.00 75.91          
ATOM   2020  CB  ASP   252     -31.515  71.152  49.418  1.00 76.78          
ATOM   2021  CG  ASP   252     -32.714  71.971  49.865  1.00 77.95          
ATOM   2022  OD1 ASP   252     -32.528  73.142  50.259  1.00 77.71          
ATOM   2023  OD2 ASP   252     -33.846  71.438  49.827  1.00 78.71          
ATOM   2024  C   ASP   252     -29.620  70.879  47.807  1.00 75.38          
ATOM   2025  O   ASP   252     -29.371  69.835  48.414  1.00 74.73          
ATOM   2026  N   TYR   253     -28.958  71.261  46.719  1.00 74.62          
ATOM   2027  CA  TYR   253     -27.875  70.467  46.152  1.00 73.46          
ATOM   2028  CB  TYR   253     -27.342  71.156  44.882  1.00 72.21          
ATOM   2029  CG  TYR   253     -26.191  70.446  44.190  1.00 70.31          
ATOM   2030  CD1 TYR   253     -24.880  70.584  44.650  1.00 69.91          
ATOM   2031  CE1 TYR   253     -23.823  69.921  44.029  1.00 69.45          
ATOM   2032  CD2 TYR   253     -26.414  69.624  43.082  1.00 69.05          
ATOM   2033  CE2 TYR   253     -25.364  68.955  42.454  1.00 68.12          
ATOM   2034  CZ  TYR   253     -24.073  69.105  42.934  1.00 68.44          
ATOM   2035  OH  TYR   253     -23.032  68.423  42.341  1.00 68.23          
ATOM   2036  C   TYR   253     -26.746  70.249  47.162  1.00 73.91          
ATOM   2037  O   TYR   253     -26.449  71.121  47.980  1.00 74.03          
ATOM   2038  N   ILE   254     -26.140  69.065  47.103  1.00 73.80          
ATOM   2039  CA  ILE   254     -25.028  68.686  47.974  1.00 72.94          
ATOM   2040  CB  ILE   254     -25.459  67.611  48.987  1.00 73.40          
ATOM   2041  CG2 ILE   254     -24.336  67.356  49.988  1.00 72.95          
ATOM   2042  CG1 ILE   254     -26.733  68.061  49.706  1.00 73.37          
ATOM   2043  CD  ILE   254     -27.318  67.020  50.636  1.00 73.80          
ATOM   2044  C   ILE   254     -23.982  68.098  47.033  1.00 72.12          
ATOM   2045  O   ILE   254     -24.338  67.592  45.973  1.00 72.37          
ATOM   2046  N   LYS   255     -22.704  68.153  47.398  1.00 71.86          
ATOM   2047  CA  LYS   255     -21.677  67.623  46.504  1.00 71.59          
ATOM   2048  CB  LYS   255     -20.271  67.817  47.095  1.00 71.80          
ATOM   2049  CG  LYS   255     -19.169  67.752  46.027  1.00 72.97          
ATOM   2050  CD  LYS   255     -17.777  68.099  46.554  1.00 72.67          
ATOM   2051  CE  LYS   255     -17.199  66.989  47.426  1.00 72.87          
ATOM   2052  NZ  LYS   255     -15.789  67.264  47.843  1.00 69.77          
ATOM   2053  C   LYS   255     -21.912  66.149  46.177  1.00 70.54          
ATOM   2054  O   LYS   255     -22.161  65.338  47.071  1.00 69.93          
ATOM   2055  N   GLY   256     -21.847  65.820  44.887  1.00 70.17          
ATOM   2056  CA  GLY   256     -22.048  64.451  44.439  1.00 68.43          
ATOM   2057  C   GLY   256     -23.465  64.137  43.987  1.00 67.92          
ATOM   2058  O   GLY   256     -23.780  62.998  43.644  1.00 66.56          
ATOM   2059  N   ASP   257     -24.326  65.147  43.975  1.00 67.91          
ATOM   2060  CA  ASP   257     -25.713  64.953  43.573  1.00 66.98          
ATOM   2061  CB  ASP   257     -26.577  66.106  44.102  1.00 67.98          
ATOM   2062  CG  ASP   257     -26.938  65.940  45.573  1.00 69.49          
ATOM   2063  OD1 ASP   257     -26.056  65.537  46.359  1.00 70.79          
ATOM   2064  OD2 ASP   257     -28.100  66.216  45.949  1.00 70.20          
ATOM   2065  C   ASP   257     -25.889  64.810  42.066  1.00 65.70          
ATOM   2066  O   ASP   257     -26.775  64.088  41.604  1.00 65.79          
ATOM   2067  N   SER   258     -25.043  65.488  41.299  1.00 63.91          
ATOM   2068  CA  SER   258     -25.132  65.425  39.847  1.00 62.99          
ATOM   2069  CB  SER   258     -24.648  66.744  39.245  1.00 63.58          
ATOM   2070  OG  SER   258     -23.331  67.046  39.666  1.00 65.68          
ATOM   2071  C   SER   258     -24.337  64.249  39.267  1.00 61.56          
ATOM   2072  O   SER   258     -24.241  64.088  38.050  1.00 61.27          
ATOM   2073  N   GLU   259     -23.774  63.433  40.152  1.00 59.92          
ATOM   2074  CA  GLU   259     -23.001  62.260  39.757  1.00 57.63          
ATOM   2075  CB  GLU   259     -22.458  61.565  41.012  1.00 58.28          
ATOM   2076  CG  GLU   259     -21.715  60.258  40.770  1.00 59.74          
ATOM   2077  CD  GLU   259     -20.229  60.456  40.506  1.00 62.20          
ATOM   2078  OE1 GLU   259     -19.865  61.022  39.451  1.00 62.40          
ATOM   2079  OE2 GLU   259     -19.421  60.042  41.370  1.00 64.06          
ATOM   2080  C   GLU   259     -23.888  61.289  38.971  1.00 56.01          
ATOM   2081  O   GLU   259     -24.990  60.945  39.411  1.00 56.34          
ATOM   2082  N   GLY   260     -23.406  60.855  37.808  1.00 53.75          
ATOM   2083  CA  GLY   260     -24.158  59.923  36.986  1.00 49.47          
ATOM   2084  C   GLY   260     -25.164  60.575  36.058  1.00 48.53          
ATOM   2085  O   GLY   260     -25.625  59.944  35.108  1.00 47.16          
ATOM   2086  N   PHE   261     -25.509  61.832  36.337  1.00 47.23          
ATOM   2087  CA  PHE   261     -26.467  62.590  35.527  1.00 46.68          
ATOM   2088  CB  PHE   261     -26.577  64.033  36.044  1.00 48.25          
ATOM   2089  CG  PHE   261     -27.512  64.208  37.214  1.00 49.81          
ATOM   2090  CD1 PHE   261     -27.703  63.187  38.138  1.00 49.16          
ATOM   2091  CD2 PHE   261     -28.179  65.421  37.406  1.00 51.35          
ATOM   2092  CE1 PHE   261     -28.543  63.366  39.235  1.00 49.80          
ATOM   2093  CE2 PHE   261     -29.023  65.613  38.502  1.00 50.90          
ATOM   2094  CZ  PHE   261     -29.203  64.581  39.419  1.00 50.56          
ATOM   2095  C   PHE   261     -26.076  62.640  34.051  1.00 44.84          
ATOM   2096  O   PHE   261     -26.919  62.495  33.168  1.00 43.76          
ATOM   2097  N   VAL   262     -24.794  62.848  33.785  1.00 43.47          
ATOM   2098  CA  VAL   262     -24.329  62.941  32.408  1.00 42.83          
ATOM   2099  CB  VAL   262     -22.830  63.310  32.356  1.00 39.89          
ATOM   2100  CG1 VAL   262     -21.994  62.162  32.887  1.00 36.29          
ATOM   2101  CG2 VAL   262     -22.431  63.675  30.929  1.00 37.94          
ATOM   2102  C   VAL   262     -24.557  61.644  31.636  1.00 44.48          
ATOM   2103  O   VAL   262     -24.559  61.634  30.409  1.00 44.05          
ATOM   2104  N   ASN   263     -24.772  60.553  32.359  1.00 46.25          
ATOM   2105  CA  ASN   263     -24.977  59.260  31.722  1.00 48.15          
ATOM   2106  CB  ASN   263     -24.540  58.141  32.674  1.00 51.19          
ATOM   2107  CG  ASN   263     -23.041  57.955  32.701  1.00 55.18          
ATOM   2108  OD1 ASN   263     -22.474  57.293  31.828  1.00 60.38          
ATOM   2109  ND2 ASN   263     -22.384  58.548  33.691  1.00 55.73          
ATOM   2110  C   ASN   263     -26.406  59.003  31.264  1.00 46.85          
ATOM   2111  O   ASN   263     -26.628  58.356  30.242  1.00 47.80          
ATOM   2112  N   ILE   264     -27.377  59.522  32.000  1.00 45.29          
ATOM   2113  CA  ILE   264     -28.766  59.272  31.655  1.00 44.85          
ATOM   2114  CB  ILE   264     -29.725  60.091  32.536  1.00 46.67          
ATOM   2115  CG2 ILE   264     -31.122  59.507  32.435  1.00 45.56          
ATOM   2116  CG1 ILE   264     -29.255  60.074  33.994  1.00 46.85          
ATOM   2117  CD  ILE   264     -29.044  58.693  34.556  1.00 49.49          
ATOM   2118  C   ILE   264     -29.129  59.508  30.192  1.00 43.97          
ATOM   2119  O   ILE   264     -29.777  58.666  29.572  1.00 43.29          
ATOM   2120  N   PRO   265     -28.719  60.654  29.621  1.00 43.30          
ATOM   2121  CD  PRO   265     -28.000  61.755  30.290  1.00 42.82          
ATOM   2122  CA  PRO   265     -29.011  60.998  28.221  1.00 42.39          
ATOM   2123  CB  PRO   265     -28.289  62.335  28.038  1.00 43.46          
ATOM   2124  CG  PRO   265     -28.341  62.935  29.415  1.00 43.91          
ATOM   2125  C   PRO   265     -28.582  59.956  27.177  1.00 41.95          
ATOM   2126  O   PRO   265     -29.156  59.887  26.088  1.00 38.94          
ATOM   2127  N   LEU   266     -27.572  59.153  27.505  1.00 40.94          
ATOM   2128  CA  LEU   266     -27.094  58.123  26.590  1.00 41.21          
ATOM   2129  CB  LEU   266     -25.784  57.510  27.100  1.00 40.50          
ATOM   2130  CG  LEU   266     -24.624  58.486  27.316  1.00 39.55          
ATOM   2131  CD1 LEU   266     -23.380  57.732  27.751  1.00 38.12          
ATOM   2132  CD2 LEU   266     -24.368  59.256  26.026  1.00 40.49          
ATOM   2133  C   LEU   266     -28.120  57.012  26.392  1.00 42.39          
ATOM   2134  O   LEU   266     -28.006  56.222  25.449  1.00 43.31          
ATOM   2135  N   SER   267     -29.125  56.946  27.262  1.00 41.73          
ATOM   2136  CA  SER   267     -30.130  55.900  27.135  1.00 43.45          
ATOM   2137  CB  SER   267     -30.798  55.614  28.486  1.00 42.85          
ATOM   2138  OG  SER   267     -31.515  56.738  28.945  1.00 45.89          
ATOM   2139  C   SER   267     -31.174  56.249  26.085  1.00 44.18          
ATOM   2140  O   SER   267     -32.154  55.529  25.893  1.00 44.07          
ATOM   2141  N   ILE   268     -30.964  57.370  25.411  1.00 45.17          
ATOM   2142  CA  ILE   268     -31.859  57.784  24.344  1.00 47.38          
ATOM   2143  CB  ILE   268     -31.894  59.323  24.176  1.00 47.09          
ATOM   2144  CG2 ILE   268     -32.534  59.680  22.840  1.00 44.33          
ATOM   2145  CG1 ILE   268     -32.662  59.960  25.339  1.00 47.82          
ATOM   2146  CD  ILE   268     -32.706  61.470  25.302  1.00 49.06          
ATOM   2147  C   ILE   268     -31.277  57.180  23.077  1.00 49.03          
ATOM   2148  O   ILE   268     -30.075  57.294  22.823  1.00 49.27          
ATOM   2149  N   LYS   269     -32.123  56.536  22.283  1.00 51.14          
ATOM   2150  CA  LYS   269     -31.665  55.924  21.050  1.00 52.71          
ATOM   2151  CB  LYS   269     -32.837  55.241  20.339  1.00 53.25          
ATOM   2152  CG  LYS   269     -32.417  54.449  19.109  1.00 56.16          
ATOM   2153  CD  LYS   269     -33.573  53.686  18.505  1.00 56.44          
ATOM   2154  CE  LYS   269     -33.129  52.972  17.248  1.00 56.83          
ATOM   2155  NZ  LYS   269     -32.024  52.019  17.544  1.00 58.15          
ATOM   2156  C   LYS   269     -31.016  56.965  20.129  1.00 53.81          
ATOM   2157  O   LYS   269     -31.538  58.071  19.950  1.00 53.87          
ATOM   2158  N   ASN   270     -29.864  56.604  19.568  1.00 53.65          
ATOM   2159  CA  ASN   270     -29.117  57.464  18.649  1.00 53.53          
ATOM   2160  CB  ASN   270     -30.028  57.967  17.520  1.00 54.21          
ATOM   2161  CG  ASN   270     -30.406  56.862  16.542  1.00 55.95          
ATOM   2162  OD1 ASN   270     -29.539  56.149  16.034  1.00 56.98          
ATOM   2163  ND2 ASN   270     -31.702  56.721  16.268  1.00 55.39          
ATOM   2164  C   ASN   270     -28.377  58.642  19.284  1.00 53.25          
ATOM   2165  O   ASN   270     -27.831  59.491  18.578  1.00 55.58          
ATOM   2166  N   VAL   271     -28.365  58.701  20.611  1.00 49.60          
ATOM   2167  CA  VAL   271     -27.638  59.747  21.313  1.00 45.91          
ATOM   2168  CB  VAL   271     -28.473  60.359  22.453  1.00 44.85          
ATOM   2169  CG1 VAL   271     -27.589  61.212  23.355  1.00 42.57          
ATOM   2170  CG2 VAL   271     -29.576  61.216  21.868  1.00 45.77          
ATOM   2171  C   VAL   271     -26.413  59.040  21.881  1.00 45.90          
ATOM   2172  O   VAL   271     -26.531  58.149  22.728  1.00 45.37          
ATOM   2173  N   CYS   272     -25.237  59.433  21.410  1.00 45.61          
ATOM   2174  CA  CYS   272     -24.008  58.793  21.842  1.00 46.61          
ATOM   2175  CB  CYS   272     -23.296  58.206  20.627  1.00 47.63          
ATOM   2176  SG  CYS   272     -22.682  59.470  19.478  1.00 53.34          
ATOM   2177  C   CYS   272     -23.057  59.720  22.570  1.00 45.53          
ATOM   2178  O   CYS   272     -22.024  59.284  23.080  1.00 45.67          
ATOM   2179  N   PHE   273     -23.406  60.996  22.621  1.00 46.03          
ATOM   2180  CA  PHE   273     -22.563  61.996  23.267  1.00 46.36          
ATOM   2181  CB  PHE   273     -21.916  62.870  22.184  1.00 47.85          
ATOM   2182  CG  PHE   273     -20.963  63.899  22.713  1.00 49.35          
ATOM   2183  CD1 PHE   273     -19.945  63.542  23.589  1.00 50.09          
ATOM   2184  CD2 PHE   273     -21.081  65.231  22.327  1.00 50.78          
ATOM   2185  CE1 PHE   273     -19.057  64.492  24.077  1.00 50.56          
ATOM   2186  CE2 PHE   273     -20.197  66.188  22.809  1.00 52.29          
ATOM   2187  CZ  PHE   273     -19.183  65.814  23.688  1.00 51.68          
ATOM   2188  C   PHE   273     -23.426  62.826  24.211  1.00 46.39          
ATOM   2189  O   PHE   273     -24.460  63.363  23.805  1.00 47.00          
ATOM   2190  N   SER   274     -23.015  62.922  25.471  1.00 44.66          
ATOM   2191  CA  SER   274     -23.798  63.664  26.450  1.00 46.88          
ATOM   2192  CB  SER   274     -24.513  62.695  27.403  1.00 49.30          
ATOM   2193  OG  SER   274     -25.373  63.388  28.304  1.00 50.33          
ATOM   2194  C   SER   274     -22.976  64.642  27.257  1.00 47.82          
ATOM   2195  O   SER   274     -21.899  64.309  27.743  1.00 47.00          
ATOM   2196  N   CYS   275     -23.511  65.849  27.412  1.00 49.35          
ATOM   2197  CA  CYS   275     -22.841  66.905  28.158  1.00 52.15          
ATOM   2198  CB  CYS   275     -22.415  68.025  27.199  1.00 52.99          
ATOM   2199  SG  CYS   275     -21.682  69.463  28.017  1.00 57.44          
ATOM   2200  C   CYS   275     -23.708  67.486  29.278  1.00 52.24          
ATOM   2201  O   CYS   275     -24.894  67.747  29.097  1.00 52.29          
ATOM   2202  N   PHE   276     -23.090  67.693  30.435  1.00 53.61          
ATOM   2203  CA  PHE   276     -23.767  68.243  31.600  1.00 55.18          
ATOM   2204  CB  PHE   276     -23.826  67.185  32.706  1.00 54.02          
ATOM   2205  CG  PHE   276     -24.374  67.693  34.006  1.00 53.13          
ATOM   2206  CD1 PHE   276     -25.653  68.234  34.078  1.00 53.10          
ATOM   2207  CD2 PHE   276     -23.604  67.633  35.162  1.00 53.04          
ATOM   2208  CE1 PHE   276     -26.161  68.713  35.291  1.00 52.61          
ATOM   2209  CE2 PHE   276     -24.093  68.106  36.376  1.00 52.27          
ATOM   2210  CZ  PHE   276     -25.376  68.648  36.443  1.00 52.93          
ATOM   2211  C   PHE   276     -23.014  69.478  32.089  1.00 57.03          
ATOM   2212  O   PHE   276     -21.826  69.400  32.415  1.00 58.70          
ATOM   2213  N   LEU   277     -23.707  70.615  32.138  1.00 58.22          
ATOM   2214  CA  LEU   277     -23.102  71.877  32.577  1.00 59.85          
ATOM   2215  CB  LEU   277     -23.367  72.969  31.533  1.00 59.82          
ATOM   2216  CG  LEU   277     -22.783  72.753  30.133  1.00 58.74          
ATOM   2217  CD1 LEU   277     -23.229  73.876  29.217  1.00 58.83          
ATOM   2218  CD2 LEU   277     -21.270  72.701  30.209  1.00 58.97          
ATOM   2219  C   LEU   277     -23.636  72.332  33.941  1.00 60.62          
ATOM   2220  O   LEU   277     -24.845  72.466  34.127  1.00 60.34          
ATOM   2221  N   ARG   278     -22.732  72.579  34.885  1.00 62.10          
ATOM   2222  CA  ARG   278     -23.125  73.004  36.229  1.00 63.43          
ATOM   2223  CB  ARG   278     -23.011  71.815  37.193  1.00 63.42          
ATOM   2224  CG  ARG   278     -23.465  72.106  38.613  1.00 65.17          
ATOM   2225  CD  ARG   278     -23.430  70.850  39.473  1.00 67.71          
ATOM   2226  NE  ARG   278     -22.077  70.318  39.613  1.00 70.02          
ATOM   2227  CZ  ARG   278     -21.130  70.859  40.373  1.00 71.07          
ATOM   2228  NH1 ARG   278     -21.384  71.956  41.078  1.00 70.59          
ATOM   2229  NH2 ARG   278     -19.923  70.308  40.421  1.00 71.77          
ATOM   2230  C   ARG   278     -22.281  74.175  36.745  1.00 63.69          
ATOM   2231  O   ARG   278     -21.055  74.141  36.671  1.00 63.90          
ATOM   2232  N   GLU   279     -22.937  75.206  37.273  1.00 64.48          
ATOM   2233  CA  GLU   279     -22.228  76.378  37.798  1.00 66.41          
ATOM   2234  CB  GLU   279     -23.190  77.553  37.989  1.00 67.98          
ATOM   2235  CG  GLU   279     -23.943  78.001  36.742  1.00 69.88          
ATOM   2236  CD  GLU   279     -24.911  79.143  37.034  1.00 71.49          
ATOM   2237  OE1 GLU   279     -25.641  79.566  36.108  1.00 72.20          
ATOM   2238  OE2 GLU   279     -24.939  79.616  38.195  1.00 70.52          
ATOM   2239  C   GLU   279     -21.569  76.072  39.142  1.00 67.23          
ATOM   2240  O   GLU   279     -22.171  75.423  39.996  1.00 66.82          
ATOM   2241  N   ASP   280     -20.341  76.552  39.331  1.00 67.87          
ATOM   2242  CA  ASP   280     -19.613  76.327  40.576  1.00 69.16          
ATOM   2243  CB  ASP   280     -18.101  76.358  40.322  1.00 69.12          
ATOM   2244  CG  ASP   280     -17.303  75.633  41.405  1.00 69.55          
ATOM   2245  OD1 ASP   280     -17.476  75.938  42.606  1.00 69.25          
ATOM   2246  OD2 ASP   280     -16.490  74.753  41.051  1.00 67.80          
ATOM   2247  C   ASP   280     -19.983  77.423  41.575  1.00 70.41          
ATOM   2248  O   ASP   280     -21.002  78.105  41.420  1.00 70.89          
ATOM   2249  N   THR   281     -19.148  77.584  42.598  1.00 70.75          
ATOM   2250  CA  THR   281     -19.359  78.595  43.627  1.00 71.34          
ATOM   2251  CB  THR   281     -18.850  78.104  45.003  1.00 72.16          
ATOM   2252  OG1 THR   281     -19.207  79.055  46.013  1.00 72.53          
ATOM   2253  CG2 THR   281     -17.329  77.932  44.985  1.00 72.13          
ATOM   2254  C   THR   281     -18.603  79.869  43.250  1.00 71.06          
ATOM   2255  O   THR   281     -18.142  80.612  44.118  1.00 71.26          
ATOM   2256  N   GLU   282     -18.477  80.110  41.947  1.00 70.70          
ATOM   2257  CA  GLU   282     -17.776  81.284  41.444  1.00 69.98          
ATOM   2258  CB  GLU   282     -16.265  81.059  41.550  1.00 70.39          
ATOM   2259  CG  GLU   282     -15.782  79.778  40.881  1.00 71.06          
ATOM   2260  CD  GLU   282     -14.365  79.402  41.288  1.00 72.07          
ATOM   2261  OE1 GLU   282     -13.816  78.432  40.711  1.00 72.27          
ATOM   2262  OE2 GLU   282     -13.805  80.071  42.188  1.00 71.87          
ATOM   2263  C   GLU   282     -18.170  81.576  39.997  1.00 69.27          
ATOM   2264  O   GLU   282     -17.343  81.992  39.183  1.00 68.96          
ATOM   2265  N   MET   285     -16.134  79.114  36.092  1.00 84.53          
ATOM   2266  CA  MET   285     -17.424  79.185  36.770  1.00 84.78          
ATOM   2267  CB  MET   285     -18.143  80.492  36.417  1.00 90.11          
ATOM   2268  CG  MET   285     -19.459  80.681  37.168  1.00 98.16          
ATOM   2269  SD  MET   285     -20.754  81.798  36.241  1.00  8.50          
ATOM   2270  CE  MET   285     -20.342  83.509  37.060  1.00  6.87          
ATOM   2271  C   MET   285     -18.313  78.002  36.386  1.00 81.12          
ATOM   2272  O   MET   285     -18.891  77.343  37.252  1.00 80.56          
ATOM   2273  N   ILE   286     -18.426  77.746  35.086  1.00 77.08          
ATOM   2274  CA  ILE   286     -19.240  76.642  34.593  1.00 73.80          
ATOM   2275  CB  ILE   286     -19.744  76.919  33.157  1.00 72.31          
ATOM   2276  CG2 ILE   286     -20.644  75.785  32.690  1.00 71.11          
ATOM   2277  CG1 ILE   286     -20.509  78.246  33.118  1.00 70.76          
ATOM   2278  CD  ILE   286     -21.751  78.283  33.990  1.00 68.67          
ATOM   2279  C   ILE   286     -18.420  75.352  34.603  1.00 72.79          
ATOM   2280  O   ILE   286     -17.278  75.324  34.141  1.00 72.60          
ATOM   2281  N   LYS   287     -19.008  74.289  35.144  1.00 71.10          
ATOM   2282  CA  LYS   287     -18.342  72.992  35.232  1.00 68.64          
ATOM   2283  CB  LYS   287     -18.596  72.370  36.609  1.00 69.58          
ATOM   2284  CG  LYS   287     -17.808  71.107  36.884  1.00 70.77          
ATOM   2285  CD  LYS   287     -16.317  71.396  36.972  1.00 72.03          
ATOM   2286  CE  LYS   287     -15.530  70.123  37.270  1.00 71.88          
ATOM   2287  NZ  LYS   287     -16.012  69.456  38.518  1.00 71.82          
ATOM   2288  C   LYS   287     -18.850  72.058  34.134  1.00 66.13          
ATOM   2289  O   LYS   287     -20.058  71.901  33.946  1.00 66.28          
ATOM   2290  N   ILE   288     -17.921  71.439  33.412  1.00 63.40          
ATOM   2291  CA  ILE   288     -18.281  70.535  32.327  1.00 60.47          
ATOM   2292  CB  ILE   288     -17.532  70.900  31.012  1.00 60.96          
ATOM   2293  CG2 ILE   288     -17.730  69.805  29.966  1.00 60.29          
ATOM   2294  CG1 ILE   288     -18.041  72.237  30.465  1.00 60.29          
ATOM   2295  CD  ILE   288     -17.628  73.444  31.283  1.00 60.80          
ATOM   2296  C   ILE   288     -18.024  69.057  32.632  1.00 57.97          
ATOM   2297  O   ILE   288     -17.001  68.688  33.219  1.00 56.69          
ATOM   2298  N   SER   289     -18.983  68.228  32.230  1.00 55.25          
ATOM   2299  CA  SER   289     -18.914  66.780  32.388  1.00 52.56          
ATOM   2300  CB  SER   289     -19.844  66.315  33.509  1.00 51.87          
ATOM   2301  OG  SER   289     -19.364  66.753  34.766  1.00 51.22          
ATOM   2302  C   SER   289     -19.355  66.178  31.059  1.00 50.44          
ATOM   2303  O   SER   289     -20.439  66.495  30.565  1.00 49.86          
ATOM   2304  N   LEU   290     -18.515  65.327  30.478  1.00 47.46          
ATOM   2305  CA  LEU   290     -18.837  64.706  29.196  1.00 46.67          
ATOM   2306  CB  LEU   290     -17.874  65.194  28.111  1.00 48.99          
ATOM   2307  CG  LEU   290     -17.683  66.710  28.026  1.00 50.70          
ATOM   2308  CD1 LEU   290     -16.740  67.048  26.885  1.00 51.49          
ATOM   2309  CD2 LEU   290     -19.030  67.380  27.822  1.00 52.30          
ATOM   2310  C   LEU   290     -18.811  63.186  29.232  1.00 46.02          
ATOM   2311  O   LEU   290     -17.943  62.570  29.865  1.00 44.16          
ATOM   2312  N   ARG   291     -19.772  62.590  28.536  1.00 44.36          
ATOM   2313  CA  ARG   291     -19.886  61.143  28.448  1.00 45.87          
ATOM   2314  CB  ARG   291     -20.985  60.623  29.378  1.00 47.89          
ATOM   2315  CG  ARG   291     -20.518  60.263  30.773  1.00 51.90          
ATOM   2316  CD  ARG   291     -19.486  59.153  30.735  1.00 54.62          
ATOM   2317  NE  ARG   291     -19.862  58.003  31.552  1.00 56.67          
ATOM   2318  CZ  ARG   291     -19.128  56.899  31.662  1.00 58.64          
ATOM   2319  NH1 ARG   291     -17.978  56.803  31.004  1.00 59.59          
ATOM   2320  NH2 ARG   291     -19.538  55.894  32.427  1.00 56.81          
ATOM   2321  C   ARG   291     -20.224  60.735  27.028  1.00 44.43          
ATOM   2322  O   ARG   291     -20.956  61.434  26.335  1.00 45.56          
ATOM   2323  N   SER   292     -19.683  59.604  26.593  1.00 44.07          
ATOM   2324  CA  SER   292     -19.974  59.094  25.261  1.00 44.04          
ATOM   2325  CB  SER   292     -18.859  59.430  24.269  1.00 41.53          
ATOM   2326  OG  SER   292     -17.754  58.576  24.467  1.00 39.31          
ATOM   2327  C   SER   292     -20.112  57.589  25.324  1.00 43.53          
ATOM   2328  O   SER   292     -19.501  56.925  26.167  1.00 42.55          
ATOM   2329  N   VAL   293     -20.932  57.057  24.431  1.00 43.18          
ATOM   2330  CA  VAL   293     -21.129  55.630  24.352  1.00 43.59          
ATOM   2331  CB  VAL   293     -22.630  55.269  24.406  1.00 45.19          
ATOM   2332  CG1 VAL   293     -23.377  55.912  23.244  1.00 44.19          
ATOM   2333  CG2 VAL   293     -22.798  53.756  24.400  1.00 46.09          
ATOM   2334  C   VAL   293     -20.536  55.326  22.995  1.00 44.74          
ATOM   2335  O   VAL   293     -20.760  56.073  22.042  1.00 45.27          
ATOM   2336  N   GLY   294     -19.752  54.259  22.907  1.00 44.96          
ATOM   2337  CA  GLY   294     -19.128  53.928  21.640  1.00 44.08          
ATOM   2338  C   GLY   294     -17.709  54.464  21.595  1.00 45.06          
ATOM   2339  O   GLY   294     -17.003  54.437  22.601  1.00 42.32          
ATOM   2340  N   LYS   295     -17.292  54.990  20.448  1.00 46.84          
ATOM   2341  CA  LYS   295     -15.924  55.481  20.321  1.00 48.14          
ATOM   2342  CB  LYS   295     -15.241  54.731  19.171  1.00 49.55          
ATOM   2343  CG  LYS   295     -15.271  53.200  19.312  1.00 52.36          
ATOM   2344  CD  LYS   295     -14.651  52.748  20.636  1.00 55.08          
ATOM   2345  CE  LYS   295     -14.366  51.252  20.668  1.00 55.82          
ATOM   2346  NZ  LYS   295     -15.576  50.425  20.487  1.00 57.27          
ATOM   2347  C   LYS   295     -15.680  56.993  20.177  1.00 48.66          
ATOM   2348  O   LYS   295     -14.562  57.408  19.869  1.00 49.20          
ATOM   2349  N   PHE   296     -16.695  57.820  20.410  1.00 49.50          
ATOM   2350  CA  PHE   296     -16.517  59.274  20.296  1.00 50.75          
ATOM   2351  CB  PHE   296     -17.867  59.992  20.385  1.00 50.69          
ATOM   2352  CG  PHE   296     -17.781  61.471  20.119  1.00 50.92          
ATOM   2353  CD1 PHE   296     -17.589  61.948  18.825  1.00 50.78          
ATOM   2354  CD2 PHE   296     -17.856  62.387  21.164  1.00 49.68          
ATOM   2355  CE1 PHE   296     -17.470  63.319  18.577  1.00 51.37          
ATOM   2356  CE2 PHE   296     -17.739  63.756  20.926  1.00 51.08          
ATOM   2357  CZ  PHE   296     -17.545  64.223  19.630  1.00 51.04          
ATOM   2358  C   PHE   296     -15.580  59.827  21.382  1.00 51.14          
ATOM   2359  O   PHE   296     -15.835  59.669  22.570  1.00 51.80          
ATOM   2360  N   PRO   297     -14.487  60.494  20.977  1.00 52.03          
ATOM   2361  CD  PRO   297     -14.025  60.575  19.581  1.00 52.69          
ATOM   2362  CA  PRO   297     -13.486  61.084  21.878  1.00 52.58          
ATOM   2363  CB  PRO   297     -12.409  61.588  20.915  1.00 52.92          
ATOM   2364  CG  PRO   297     -12.533  60.679  19.756  1.00 53.24          
ATOM   2365  C   PRO   297     -13.959  62.197  22.819  1.00 52.79          
ATOM   2366  O   PRO   297     -13.957  63.374  22.453  1.00 52.16          
ATOM   2367  N   CYS   298     -14.345  61.823  24.035  1.00 53.29          
ATOM   2368  CA  CYS   298     -14.787  62.797  25.029  1.00 53.16          
ATOM   2369  CB  CYS   298     -15.430  62.096  26.228  1.00 52.70          
ATOM   2370  SG  CYS   298     -17.159  61.714  26.006  1.00 54.53          
ATOM   2371  C   CYS   298     -13.621  63.639  25.525  1.00 53.32          
ATOM   2372  O   CYS   298     -13.776  64.827  25.797  1.00 52.96          
ATOM   2373  N   ASN   299     -12.454  63.015  25.647  1.00 54.63          
ATOM   2374  CA  ASN   299     -11.264  63.718  26.122  1.00 56.23          
ATOM   2375  CB  ASN   299     -10.184  62.718  26.552  1.00 53.03          
ATOM   2376  CG  ASN   299     -10.056  61.543  25.602  1.00 51.95          
ATOM   2377  OD1 ASN   299      -9.316  60.600  25.871  1.00 51.43          
ATOM   2378  ND2 ASN   299     -10.776  61.591  24.491  1.00 51.45          
ATOM   2379  C   ASN   299     -10.697  64.704  25.105  1.00 57.69          
ATOM   2380  O   ASN   299     -10.160  65.747  25.487  1.00 57.89          
ATOM   2381  N   ARG   300     -10.814  64.382  23.818  1.00 58.96          
ATOM   2382  CA  ARG   300     -10.317  65.276  22.783  1.00 60.49          
ATOM   2383  CB  ARG   300     -10.427  64.629  21.400  1.00 62.14          
ATOM   2384  CG  ARG   300      -9.961  65.538  20.261  1.00 65.48          
ATOM   2385  CD  ARG   300      -9.978  64.816  18.923  1.00 67.40          
ATOM   2386  NE  ARG   300      -8.883  63.852  18.792  1.00 70.47          
ATOM   2387  CZ  ARG   300      -7.655  64.160  18.381  1.00 71.56          
ATOM   2388  NH1 ARG   300      -7.359  65.412  18.054  1.00 72.02          
ATOM   2389  NH2 ARG   300      -6.724  63.217  18.288  1.00 71.39          
ATOM   2390  C   ARG   300     -11.111  66.580  22.808  1.00 60.14          
ATOM   2391  O   ARG   300     -10.527  67.662  22.876  1.00 59.17          
ATOM   2392  N   LEU   301     -12.437  66.479  22.757  1.00 60.40          
ATOM   2393  CA  LEU   301     -13.274  67.672  22.785  1.00 62.20          
ATOM   2394  CB  LEU   301     -14.755  67.305  22.757  1.00 61.32          
ATOM   2395  CG  LEU   301     -15.424  67.444  21.393  1.00 61.98          
ATOM   2396  CD1 LEU   301     -14.889  66.378  20.447  1.00 61.87          
ATOM   2397  CD2 LEU   301     -16.929  67.318  21.551  1.00 60.63          
ATOM   2398  C   LEU   301     -12.995  68.509  24.023  1.00 64.01          
ATOM   2399  O   LEU   301     -12.823  69.721  23.933  1.00 64.06          
ATOM   2400  N   ALA   302     -12.950  67.856  25.179  1.00 65.51          
ATOM   2401  CA  ALA   302     -12.689  68.550  26.430  1.00 66.77          
ATOM   2402  CB  ALA   302     -12.763  67.569  27.598  1.00 66.37          
ATOM   2403  C   ALA   302     -11.320  69.221  26.396  1.00 68.07          
ATOM   2404  O   ALA   302     -11.126  70.286  26.986  1.00 68.58          
ATOM   2405  N   ALA   303     -10.379  68.590  25.699  1.00 68.62          
ATOM   2406  CA  ALA   303      -9.014  69.103  25.589  1.00 69.46          
ATOM   2407  CB  ALA   303      -8.140  68.098  24.838  1.00 69.94          
ATOM   2408  C   ALA   303      -8.952  70.465  24.900  1.00 69.92          
ATOM   2409  O   ALA   303      -8.051  71.265  25.165  1.00 69.55          
ATOM   2410  N   GLU   304      -9.909  70.723  24.015  1.00 70.31          
ATOM   2411  CA  GLU   304      -9.945  71.985  23.292  1.00 71.45          
ATOM   2412  CB  GLU   304     -10.393  71.762  21.845  1.00 72.58          
ATOM   2413  CG  GLU   304      -9.696  70.623  21.129  1.00 76.22          
ATOM   2414  CD  GLU   304     -10.095  70.528  19.667  1.00 77.91          
ATOM   2415  OE1 GLU   304     -11.285  70.754  19.362  1.00 79.09          
ATOM   2416  OE2 GLU   304      -9.223  70.218  18.825  1.00 79.10          
ATOM   2417  C   GLU   304     -10.894  72.984  23.941  1.00 71.46          
ATOM   2418  O   GLU   304     -10.485  73.841  24.727  1.00 72.14          
ATOM   2419  N   PHE   305     -12.169  72.836  23.598  1.00 70.61          
ATOM   2420  CA  PHE   305     -13.250  73.696  24.055  1.00 70.40          
ATOM   2421  CB  PHE   305     -14.555  73.177  23.458  1.00 71.06          
ATOM   2422  CG  PHE   305     -14.547  73.122  21.959  1.00 71.79          
ATOM   2423  CD1 PHE   305     -15.013  74.195  21.206  1.00 71.87          
ATOM   2424  CD2 PHE   305     -14.049  72.005  21.298  1.00 71.72          
ATOM   2425  CE1 PHE   305     -14.984  74.158  19.814  1.00 72.72          
ATOM   2426  CE2 PHE   305     -14.014  71.956  19.909  1.00 72.80          
ATOM   2427  CZ  PHE   305     -14.483  73.035  19.163  1.00 72.64          
ATOM   2428  C   PHE   305     -13.435  73.947  25.552  1.00 70.31          
ATOM   2429  O   PHE   305     -14.064  74.935  25.928  1.00 71.42          
ATOM   2430  N   PHE   306     -12.911  73.084  26.415  1.00 69.63          
ATOM   2431  CA  PHE   306     -13.086  73.309  27.850  1.00 69.31          
ATOM   2432  CB  PHE   306     -14.248  72.465  28.383  1.00 69.71          
ATOM   2433  CG  PHE   306     -15.545  72.690  27.657  1.00 70.22          
ATOM   2434  CD1 PHE   306     -15.940  71.839  26.629  1.00 70.43          
ATOM   2435  CD2 PHE   306     -16.364  73.764  27.990  1.00 71.06          
ATOM   2436  CE1 PHE   306     -17.133  72.054  25.941  1.00 71.51          
ATOM   2437  CE2 PHE   306     -17.561  73.992  27.310  1.00 72.03          
ATOM   2438  CZ  PHE   306     -17.948  73.134  26.282  1.00 71.90          
ATOM   2439  C   PHE   306     -11.842  73.041  28.691  1.00 69.60          
ATOM   2440  O   PHE   306     -11.948  72.685  29.875  1.00 68.33          
ATOM   2441  N   ASN   307     -10.671  73.223  28.082  1.00 69.57          
ATOM   2442  CA  ASN   307      -9.393  73.006  28.758  1.00 70.26          
ATOM   2443  CB  ASN   307      -8.923  74.306  29.423  1.00 72.51          
ATOM   2444  CG  ASN   307     -10.013  74.963  30.251  1.00 74.00          
ATOM   2445  OD1 ASN   307     -10.533  74.370  31.198  1.00 76.45          
ATOM   2446  ND2 ASN   307     -10.374  76.190  29.889  1.00 73.51          
ATOM   2447  C   ASN   307      -9.431  71.884  29.794  1.00 69.33          
ATOM   2448  O   ASN   307      -8.952  72.046  30.915  1.00 69.48          
ATOM   2449  N   GLY   308      -9.997  70.744  29.413  1.00 68.08          
ATOM   2450  CA  GLY   308     -10.087  69.623  30.329  1.00 66.74          
ATOM   2451  C   GLY   308      -9.321  68.411  29.853  1.00 65.58          
ATOM   2452  O   GLY   308      -8.213  68.529  29.331  1.00 66.86          
ATOM   2453  N   GLY   309      -9.909  67.236  30.031  1.00 64.44          
ATOM   2454  CA  GLY   309      -9.236  66.022  29.617  1.00 62.09          
ATOM   2455  C   GLY   309      -9.852  64.833  30.321  1.00 61.34          
ATOM   2456  O   GLY   309     -10.794  64.990  31.098  1.00 61.15          
ATOM   2457  N   GLY   310      -9.315  63.646  30.068  1.00 59.31          
ATOM   2458  CA  GLY   310      -9.843  62.463  30.711  1.00 58.45          
ATOM   2459  C   GLY   310      -9.706  61.219  29.864  1.00 57.31          
ATOM   2460  O   GLY   310      -8.649  60.970  29.286  1.00 56.90          
ATOM   2461  N   HSD   311     -10.784  60.445  29.785  1.00 56.48          
ATOM   2462  CA  HSD   311     -10.790  59.199  29.034  1.00 56.44          
ATOM   2463  CB  HSD   311     -11.270  58.055  29.943  1.00 56.60          
ATOM   2464  CG  HSD   311     -10.626  58.048  31.298  1.00 56.93          
ATOM   2465  CD2 HSD   311     -11.154  58.216  32.535  1.00 56.42          
ATOM   2466  ND1 HSD   311      -9.268  57.881  31.481  1.00 55.50          
ATOM   2467  CE1 HSD   311      -8.990  57.953  32.771  1.00 57.34          
ATOM   2468  NE2 HSD   311     -10.116  58.156  33.432  1.00 57.61          
ATOM   2469  C   HSD   311     -11.691  59.321  27.810  1.00 56.30          
ATOM   2470  O   HSD   311     -12.429  60.301  27.655  1.00 57.76          
ATOM   2471  N   LEU   312     -11.629  58.311  26.952  1.00 53.93          
ATOM   2472  CA  LEU   312     -12.413  58.273  25.726  1.00 51.97          
ATOM   2473  CB  LEU   312     -12.146  56.937  25.019  1.00 50.43          
ATOM   2474  CG  LEU   312     -12.276  56.780  23.498  1.00 51.21          
ATOM   2475  CD1 LEU   312     -13.541  56.014  23.163  1.00 50.88          
ATOM   2476  CD2 LEU   312     -12.243  58.141  22.824  1.00 49.67          
ATOM   2477  C   LEU   312     -13.919  58.471  25.944  1.00 50.62          
ATOM   2478  O   LEU   312     -14.545  59.284  25.265  1.00 48.36          
ATOM   2479  N   ASN   313     -14.486  57.736  26.898  1.00 49.55          
ATOM   2480  CA  ASN   313     -15.918  57.818  27.177  1.00 49.42          
ATOM   2481  CB  ASN   313     -16.481  56.406  27.363  1.00 49.77          
ATOM   2482  CG  ASN   313     -16.311  55.550  26.119  1.00 50.98          
ATOM   2483  OD1 ASN   313     -16.746  55.933  25.037  1.00 50.74          
ATOM   2484  ND2 ASN   313     -15.666  54.396  26.264  1.00 50.79          
ATOM   2485  C   ASN   313     -16.330  58.701  28.361  1.00 48.87          
ATOM   2486  O   ASN   313     -17.514  58.814  28.665  1.00 47.96          
ATOM   2487  N   ALA   314     -15.368  59.333  29.022  1.00 48.34          
ATOM   2488  CA  ALA   314     -15.694  60.188  30.157  1.00 50.01          
ATOM   2489  CB  ALA   314     -16.036  59.334  31.391  1.00 47.28          
ATOM   2490  C   ALA   314     -14.578  61.168  30.502  1.00 50.65          
ATOM   2491  O   ALA   314     -13.427  60.781  30.708  1.00 50.38          
ATOM   2492  N   SER   315     -14.930  62.446  30.565  1.00 52.46          
ATOM   2493  CA  SER   315     -13.965  63.477  30.909  1.00 55.62          
ATOM   2494  CB  SER   315     -13.009  63.714  29.731  1.00 56.15          
ATOM   2495  OG  SER   315     -13.713  63.980  28.536  1.00 58.84          
ATOM   2496  C   SER   315     -14.683  64.764  31.310  1.00 56.46          
ATOM   2497  O   SER   315     -15.904  64.848  31.221  1.00 57.45          
ATOM   2498  N   GLY   316     -13.931  65.757  31.773  1.00 58.63          
ATOM   2499  CA  GLY   316     -14.547  67.009  32.176  1.00 60.35          
ATOM   2500  C   GLY   316     -13.652  68.220  32.004  1.00 62.23          
ATOM   2501  O   GLY   316     -12.568  68.134  31.422  1.00 61.87          
ATOM   2502  N   GLY   317     -14.113  69.357  32.515  1.00 64.69          
ATOM   2503  CA  GLY   317     -13.348  70.589  32.426  1.00 66.85          
ATOM   2504  C   GLY   317     -14.198  71.765  32.860  1.00 68.22          
ATOM   2505  O   GLY   317     -15.422  71.664  32.877  1.00 67.49          
ATOM   2506  N   GLU   318     -13.557  72.875  33.217  1.00 70.78          
ATOM   2507  CA  GLU   318     -14.280  74.069  33.645  1.00 72.60          
ATOM   2508  CB  GLU   318     -13.700  74.607  34.969  1.00 73.68          
ATOM   2509  CG  GLU   318     -14.233  75.997  35.391  1.00 74.81          
ATOM   2510  CD  GLU   318     -14.329  76.189  36.913  1.00 73.68          
ATOM   2511  OE1 GLU   318     -13.371  75.846  37.636  1.00 73.00          
ATOM   2512  OE2 GLU   318     -15.370  76.696  37.382  1.00 71.60          
ATOM   2513  C   GLU   318     -14.245  75.153  32.573  1.00 72.64          
ATOM   2514  O   GLU   318     -13.264  75.291  31.844  1.00 73.24          
ATOM   2515  N   PHE   319     -15.337  75.902  32.473  1.00 72.69          
ATOM   2516  CA  PHE   319     -15.458  76.991  31.514  1.00 73.13          
ATOM   2517  CB  PHE   319     -16.506  76.644  30.451  1.00 73.25          
ATOM   2518  CG  PHE   319     -16.920  77.811  29.595  1.00 73.30          
ATOM   2519  CD1 PHE   319     -17.949  78.660  29.999  1.00 73.57          
ATOM   2520  CD2 PHE   319     -16.283  78.064  28.387  1.00 72.83          
ATOM   2521  CE1 PHE   319     -18.337  79.738  29.213  1.00 73.65          
ATOM   2522  CE2 PHE   319     -16.664  79.141  27.594  1.00 73.06          
ATOM   2523  CZ  PHE   319     -17.694  79.979  28.009  1.00 72.84          
ATOM   2524  C   PHE   319     -15.864  78.248  32.275  1.00 74.14          
ATOM   2525  O   PHE   319     -16.982  78.344  32.788  1.00 73.69          
ATOM   2526  N   TYR   320     -14.943  79.205  32.352  1.00 74.48          
ATOM   2527  CA  TYR   320     -15.193  80.455  33.062  1.00 73.72          
ATOM   2528  CB  TYR   320     -13.865  81.081  33.493  1.00 73.49          
ATOM   2529  CG  TYR   320     -13.049  80.181  34.402  1.00 73.97          
ATOM   2530  CD1 TYR   320     -12.271  79.144  33.880  1.00 73.87          
ATOM   2531  CE1 TYR   320     -11.536  78.298  34.718  1.00 74.03          
ATOM   2532  CD2 TYR   320     -13.075  80.351  35.790  1.00 74.09          
ATOM   2533  CE2 TYR   320     -12.346  79.511  36.636  1.00 74.04          
ATOM   2534  CZ  TYR   320     -11.578  78.490  36.095  1.00 74.13          
ATOM   2535  OH  TYR   320     -10.844  77.673  36.930  1.00 74.34          
ATOM   2536  C   TYR   320     -16.005  81.439  32.221  1.00 73.14          
ATOM   2537  O   TYR   320     -15.496  82.039  31.272  1.00 71.79          
ATOM   2538  N   GLY   321     -17.276  81.585  32.588  1.00 72.43          
ATOM   2539  CA  GLY   321     -18.182  82.473  31.883  1.00 71.89          
ATOM   2540  C   GLY   321     -19.606  82.178  32.317  1.00 72.23          
ATOM   2541  O   GLY   321     -19.824  81.715  33.432  1.00 71.34          
ATOM   2542  N   THR   322     -20.577  82.439  31.448  1.00 73.00          
ATOM   2543  CA  THR   322     -21.977  82.181  31.775  1.00 74.27          
ATOM   2544  CB  THR   322     -22.886  83.341  31.309  1.00 74.98          
ATOM   2545  OG1 THR   322     -22.637  83.620  29.924  1.00 74.49          
ATOM   2546  CG2 THR   322     -22.627  84.594  32.142  1.00 74.97          
ATOM   2547  C   THR   322     -22.478  80.886  31.136  1.00 74.37          
ATOM   2548  O   THR   322     -21.808  80.307  30.283  1.00 74.48          
ATOM   2549  N   MET   323     -23.660  80.442  31.552  1.00 74.49          
ATOM   2550  CA  MET   323     -24.247  79.217  31.022  1.00 74.29          
ATOM   2551  CB  MET   323     -25.587  78.928  31.704  1.00 71.82          
ATOM   2552  CG  MET   323     -25.533  77.787  32.713  1.00 70.52          
ATOM   2553  SD  MET   323     -25.059  76.209  31.966  1.00 63.79          
ATOM   2554  CE  MET   323     -26.531  75.864  31.026  1.00 63.92          
ATOM   2555  C   MET   323     -24.440  79.266  29.509  1.00 75.53          
ATOM   2556  O   MET   323     -23.747  78.562  28.774  1.00 75.80          
ATOM   2557  N   GLU   324     -25.376  80.088  29.043  1.00 76.56          
ATOM   2558  CA  GLU   324     -25.629  80.205  27.608  1.00 77.78          
ATOM   2559  CB  GLU   324     -26.630  81.326  27.323  1.00 78.83          
ATOM   2560  CG  GLU   324     -26.991  81.453  25.851  1.00 81.33          
ATOM   2561  CD  GLU   324     -27.525  82.830  25.488  1.00 83.20          
ATOM   2562  OE1 GLU   324     -27.819  83.057  24.293  1.00 84.01          
ATOM   2563  OE2 GLU   324     -27.645  83.685  26.392  1.00 83.77          
ATOM   2564  C   GLU   324     -24.325  80.487  26.861  1.00 77.43          
ATOM   2565  O   GLU   324     -24.233  80.292  25.650  1.00 76.89          
ATOM   2566  N   GLU   325     -23.318  80.953  27.590  1.00 77.67          
ATOM   2567  CA  GLU   325     -22.021  81.246  26.994  1.00 78.15          
ATOM   2568  CB  GLU   325     -21.170  82.076  27.968  1.00 78.50          
ATOM   2569  CG  GLU   325     -20.271  83.120  27.303  1.00 79.02          
ATOM   2570  CD  GLU   325     -19.646  84.087  28.302  1.00 79.53          
ATOM   2571  OE1 GLU   325     -18.794  83.654  29.109  1.00 79.74          
ATOM   2572  OE2 GLU   325     -20.012  85.283  28.284  1.00 78.67          
ATOM   2573  C   GLU   325     -21.343  79.908  26.696  1.00 78.00          
ATOM   2574  O   GLU   325     -20.899  79.660  25.573  1.00 78.07          
ATOM   2575  N   ALA   326     -21.289  79.048  27.712  1.00 77.16          
ATOM   2576  CA  ALA   326     -20.686  77.723  27.595  1.00 75.86          
ATOM   2577  CB  ALA   326     -20.601  77.063  28.968  1.00 76.17          
ATOM   2578  C   ALA   326     -21.494  76.845  26.648  1.00 74.79          
ATOM   2579  O   ALA   326     -20.938  75.990  25.962  1.00 74.65          
ATOM   2580  N   VAL   327     -22.808  77.054  26.621  1.00 73.85          
ATOM   2581  CA  VAL   327     -23.684  76.287  25.742  1.00 72.78          
ATOM   2582  CB  VAL   327     -25.167  76.690  25.916  1.00 71.71          
ATOM   2583  CG1 VAL   327     -26.034  75.921  24.930  1.00 70.10          
ATOM   2584  CG2 VAL   327     -25.618  76.418  27.335  1.00 71.25          
ATOM   2585  C   VAL   327     -23.291  76.540  24.295  1.00 72.93          
ATOM   2586  O   VAL   327     -23.089  75.603  23.522  1.00 72.55          
ATOM   2587  N   LYS   328     -23.186  77.818  23.940  1.00 73.68          
ATOM   2588  CA  LYS   328     -22.818  78.221  22.586  1.00 73.63          
ATOM   2589  CB  LYS   328     -22.664  79.745  22.509  1.00 73.92          
ATOM   2590  CG  LYS   328     -23.183  80.364  21.210  1.00 73.74          
ATOM   2591  CD  LYS   328     -24.697  80.211  21.091  1.00 72.95          
ATOM   2592  CE  LYS   328     -25.210  80.730  19.750  1.00 72.48          
ATOM   2593  NZ  LYS   328     -26.685  80.544  19.597  1.00 70.95          
ATOM   2594  C   LYS   328     -21.505  77.539  22.219  1.00 72.96          
ATOM   2595  O   LYS   328     -21.314  77.104  21.084  1.00 72.91          
ATOM   2596  N   VAL   329     -20.601  77.448  23.189  1.00 72.45          
ATOM   2597  CA  VAL   329     -19.319  76.792  22.966  1.00 71.75          
ATOM   2598  CB  VAL   329     -18.434  76.829  24.230  1.00 72.03          
ATOM   2599  CG1 VAL   329     -17.087  76.190  23.936  1.00 72.15          
ATOM   2600  CG2 VAL   329     -18.258  78.258  24.706  1.00 71.97          
ATOM   2601  C   VAL   329     -19.614  75.332  22.624  1.00 71.46          
ATOM   2602  O   VAL   329     -19.072  74.783  21.667  1.00 71.06          
ATOM   2603  N   PHE   330     -20.482  74.715  23.422  1.00 70.79          
ATOM   2604  CA  PHE   330     -20.871  73.326  23.218  1.00 69.94          
ATOM   2605  CB  PHE   330     -21.943  72.929  24.247  1.00 69.34          
ATOM   2606  CG  PHE   330     -22.487  71.535  24.062  1.00 68.19          
ATOM   2607  CD1 PHE   330     -21.655  70.424  24.176  1.00 67.05          
ATOM   2608  CD2 PHE   330     -23.831  71.335  23.759  1.00 67.31          
ATOM   2609  CE1 PHE   330     -22.152  69.136  23.989  1.00 65.80          
ATOM   2610  CE2 PHE   330     -24.336  70.047  23.570  1.00 67.13          
ATOM   2611  CZ  PHE   330     -23.493  68.948  23.685  1.00 65.44          
ATOM   2612  C   PHE   330     -21.411  73.156  21.798  1.00 69.75          
ATOM   2613  O   PHE   330     -21.068  72.199  21.102  1.00 69.64          
ATOM   2614  N   GLU   331     -22.250  74.096  21.371  1.00 69.26          
ATOM   2615  CA  GLU   331     -22.836  74.046  20.036  1.00 68.88          
ATOM   2616  CB  GLU   331     -23.896  75.139  19.887  1.00 67.31          
ATOM   2617  CG  GLU   331     -24.748  75.336  21.133  1.00 65.73          
ATOM   2618  CD  GLU   331     -26.060  76.041  20.845  1.00 63.57          
ATOM   2619  OE1 GLU   331     -27.030  75.356  20.458  1.00 61.70          
ATOM   2620  OE2 GLU   331     -26.116  77.280  20.997  1.00 63.17          
ATOM   2621  C   GLU   331     -21.759  74.208  18.965  1.00 69.41          
ATOM   2622  O   GLU   331     -21.979  73.892  17.796  1.00 69.70          
ATOM   2623  N   GLN   332     -20.596  74.705  19.372  1.00 70.07          
ATOM   2624  CA  GLN   332     -19.478  74.891  18.453  1.00 71.81          
ATOM   2625  CB  GLN   332     -18.507  75.952  18.988  1.00 73.98          
ATOM   2626  CG  GLN   332     -19.030  77.381  18.907  1.00 77.97          
ATOM   2627  CD  GLN   332     -18.051  78.402  19.472  1.00 80.35          
ATOM   2628  OE1 GLN   332     -16.840  78.312  19.243  1.00 81.64          
ATOM   2629  NE2 GLN   332     -18.573  79.388  20.202  1.00 80.38          
ATOM   2630  C   GLN   332     -18.740  73.568  18.277  1.00 71.55          
ATOM   2631  O   GLN   332     -18.557  73.090  17.154  1.00 72.15          
ATOM   2632  N   ALA   333     -18.317  72.982  19.396  1.00 70.52          
ATOM   2633  CA  ALA   333     -17.606  71.711  19.374  1.00 68.50          
ATOM   2634  CB  ALA   333     -17.333  71.240  20.796  1.00 68.38          
ATOM   2635  C   ALA   333     -18.433  70.673  18.621  1.00 67.29          
ATOM   2636  O   ALA   333     -17.887  69.844  17.897  1.00 66.96          
ATOM   2637  N   LEU   334     -19.750  70.724  18.790  1.00 65.98          
ATOM   2638  CA  LEU   334     -20.628  69.785  18.104  1.00 66.09          
ATOM   2639  CB  LEU   334     -22.076  69.942  18.584  1.00 64.92          
ATOM   2640  CG  LEU   334     -22.413  69.432  19.987  1.00 64.54          
ATOM   2641  CD1 LEU   334     -23.903  69.611  20.252  1.00 64.28          
ATOM   2642  CD2 LEU   334     -22.028  67.961  20.103  1.00 63.76          
ATOM   2643  C   LEU   334     -20.563  70.027  16.602  1.00 66.39          
ATOM   2644  O   LEU   334     -20.620  69.092  15.802  1.00 66.24          
ATOM   2645  N   GLU   335     -20.438  71.295  16.228  1.00 66.39          
ATOM   2646  CA  GLU   335     -20.373  71.673  14.824  1.00 66.89          
ATOM   2647  CB  GLU   335     -20.508  73.192  14.683  1.00 67.34          
ATOM   2648  CG  GLU   335     -21.023  73.647  13.331  1.00 68.58          
ATOM   2649  CD  GLU   335     -22.486  73.299  13.120  1.00 69.87          
ATOM   2650  OE1 GLU   335     -23.302  73.601  14.019  1.00 69.95          
ATOM   2651  OE2 GLU   335     -22.821  72.734  12.055  1.00 70.47          
ATOM   2652  C   GLU   335     -19.048  71.211  14.222  1.00 65.62          
ATOM   2653  O   GLU   335     -19.006  70.722  13.092  1.00 64.66          
ATOM   2654  N   LYS   336     -17.966  71.362  14.978  1.00 64.97          
ATOM   2655  CA  LYS   336     -16.667  70.944  14.484  1.00 64.97          
ATOM   2656  CB  LYS   336     -15.547  71.423  15.408  1.00 64.07          
ATOM   2657  CG  LYS   336     -14.160  71.127  14.842  1.00 64.61          
ATOM   2658  CD  LYS   336     -13.040  71.578  15.760  1.00 64.73          
ATOM   2659  CE  LYS   336     -11.685  71.173  15.197  1.00 64.42          
ATOM   2660  NZ  LYS   336     -10.563  71.494  16.126  1.00 63.92          
ATOM   2661  C   LYS   336     -16.592  69.427  14.343  1.00 65.72          
ATOM   2662  O   LYS   336     -16.154  68.919  13.312  1.00 64.96          
ATOM   2663  N   TYR   337     -17.024  68.703  15.374  1.00 65.79          
ATOM   2664  CA  TYR   337     -16.977  67.245  15.336  1.00 66.32          
ATOM   2665  CB  TYR   337     -16.647  66.689  16.724  1.00 68.89          
ATOM   2666  CG  TYR   337     -15.245  67.016  17.183  1.00 72.24          
ATOM   2667  CD1 TYR   337     -14.935  68.272  17.706  1.00 73.43          
ATOM   2668  CE1 TYR   337     -13.632  68.590  18.091  1.00 74.87          
ATOM   2669  CD2 TYR   337     -14.215  66.082  17.056  1.00 73.53          
ATOM   2670  CE2 TYR   337     -12.909  66.390  17.436  1.00 74.63          
ATOM   2671  CZ  TYR   337     -12.626  67.643  17.952  1.00 75.08          
ATOM   2672  OH  TYR   337     -11.339  67.946  18.331  1.00 75.76          
ATOM   2673  C   TYR   337     -18.243  66.577  14.812  1.00 65.32          
ATOM   2674  O   TYR   337     -18.390  65.357  14.907  1.00 64.99          
ATOM   2675  N   LYS   338     -19.151  67.368  14.253  1.00 63.98          
ATOM   2676  CA  LYS   338     -20.401  66.826  13.723  1.00 63.51          
ATOM   2677  CB  LYS   338     -21.197  67.921  13.000  1.00 63.48          
ATOM   2678  CG  LYS   338     -22.593  67.491  12.566  1.00 64.00          
ATOM   2679  CD  LYS   338     -23.353  68.644  11.920  1.00 63.98          
ATOM   2680  CE  LYS   338     -24.753  68.224  11.518  1.00 62.32          
ATOM   2681  NZ  LYS   338     -24.748  67.065  10.581  1.00 61.42          
ATOM   2682  C   LYS   338     -20.164  65.643  12.779  1.00 62.74          
ATOM   2683  O   LYS   338     -20.855  64.631  12.864  1.00 62.40          
ATOM   2684  N   PRO   339     -19.189  65.756  11.861  1.00 62.74          
ATOM   2685  CD  PRO   339     -18.278  66.870  11.545  1.00 62.52          
ATOM   2686  CA  PRO   339     -18.958  64.625  10.958  1.00 62.92          
ATOM   2687  CB  PRO   339     -17.904  65.162   9.992  1.00 61.47          
ATOM   2688  CG  PRO   339     -17.163  66.163  10.821  1.00 61.98          
ATOM   2689  C   PRO   339     -18.510  63.361  11.691  1.00 63.54          
ATOM   2690  O   PRO   339     -19.044  62.284  11.440  1.00 64.73          
ATOM   2691  N   LEU   340     -17.548  63.486  12.604  1.00 64.18          
ATOM   2692  CA  LEU   340     -17.071  62.321  13.350  1.00 64.82          
ATOM   2693  CB  LEU   340     -16.009  62.724  14.386  1.00 64.94          
ATOM   2694  CG  LEU   340     -14.913  61.695  14.720  1.00 64.47          
ATOM   2695  CD1 LEU   340     -14.133  62.160  15.941  1.00 64.44          
ATOM   2696  CD2 LEU   340     -15.518  60.333  14.988  1.00 64.92          
ATOM   2697  C   LEU   340     -18.256  61.665  14.059  1.00 64.96          
ATOM   2698  O   LEU   340     -18.331  60.442  14.162  1.00 64.58          
ATOM   2699  N   LEU   341     -19.180  62.490  14.542  1.00 65.68          
ATOM   2700  CA  LEU   341     -20.368  61.997  15.234  1.00 66.31          
ATOM   2701  CB  LEU   341     -21.204  63.169  15.760  1.00 65.54          
ATOM   2702  CG  LEU   341     -20.663  63.956  16.956  1.00 66.01          
ATOM   2703  CD1 LEU   341     -21.472  65.236  17.142  1.00 64.35          
ATOM   2704  CD2 LEU   341     -20.731  63.090  18.204  1.00 65.12          
ATOM   2705  C   LEU   341     -21.238  61.136  14.329  1.00 67.65          
ATOM   2706  O   LEU   341     -21.954  60.260  14.808  1.00 68.79          
ATOM   2707  N   LYS   342     -21.177  61.385  13.022  1.00 69.00          
ATOM   2708  CA  LYS   342     -21.984  60.631  12.067  1.00 69.68          
ATOM   2709  CB  LYS   342     -22.235  61.465  10.801  1.00 71.33          
ATOM   2710  CG  LYS   342     -23.247  62.589  11.000  1.00 72.00          
ATOM   2711  CD  LYS   342     -23.959  62.952   9.701  1.00 73.47          
ATOM   2712  CE  LYS   342     -25.151  63.875   9.964  1.00 74.12          
ATOM   2713  NZ  LYS   342     -25.987  64.119   8.749  1.00 72.91          
ATOM   2714  C   LYS   342     -21.424  59.266  11.683  1.00 69.69          
ATOM   2715  O   LYS   342     -21.728  58.741  10.616  1.00 70.15          
END
