
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  465),  selected   59 , name 1mhn_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 1mhn_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    89_A      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    Q    90_A      Q       6          6.889
LGA    Q    91_A      G       7          2.684
LGA    -       -      D       8           -
LGA    W    92_A      L       9          1.487
LGA    K    93_A      I      10          1.916
LGA    V    94_A      V      11          1.418
LGA    G    95_A      S      12          0.820
LGA    D    96_A      M      13          1.177
LGA    K    97_A      R      14          0.951
LGA    C    98_A      I      15          0.687
LGA    S    99_A      L      16          0.317
LGA    A   100_A      G      17          1.393
LGA    I   101_A      K      18          1.288
LGA    W   102_A      K      19          0.597
LGA    S   103_A      R      20          1.447
LGA    E   104_A      T      21          3.078
LGA    D   105_A      -       -           -
LGA    G   106_A      K      22          0.930
LGA    C   107_A      T      23          0.668
LGA    I   108_A      W      24          0.927
LGA    Y   109_A      X      25          0.177
LGA    P   110_A      K      26          0.523
LGA    A   111_A      G      27          0.952
LGA    T   112_A      T      28          0.458
LGA    I   113_A      L      29          0.873
LGA    A   114_A      I      30          1.365
LGA    S   115_A      A      31          1.205
LGA    I   116_A      I      32          1.029
LGA    D   117_A      Q      33          0.506
LGA    F   118_A      T      34          2.330
LGA    K   119_A      V      35          2.730
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    R   120_A      G      38          3.065
LGA    E   121_A      K      39          0.213
LGA    T   122_A      K      40          0.436
LGA    C   123_A      Y      41          1.573
LGA    V   124_A      K      42          1.103
LGA    V   125_A      V      43          0.359
LGA    V   126_A      K      44          0.770
LGA    Y   127_A      F      45          0.810
LGA    T   128_A      D      46          1.323
LGA    G   129_A      N      47          2.889
LGA    Y   130_A      -       -           -
LGA    G   131_A      K      48          3.014
LGA    N   132_A      G      49          0.917
LGA    R   133_A      K      50          0.961
LGA    E   134_A      S      51          0.755
LGA    E   135_A      L      52          0.999
LGA    Q   136_A      L      53          0.428
LGA    N   137_A      S      54          0.630
LGA    L   138_A      G      55          2.084
LGA    S   139_A      N      56          3.244
LGA    D   140_A      X      57          2.584
LGA    L   141_A      I      58          1.481
LGA    L   142_A      A      59          0.277
LGA    S   143_A      Y      60          1.102
LGA    P   144_A      D      61          1.281
LGA    I   145_A      Y      62          2.970
LGA    C   146_A      -       -           -
LGA    E   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   62    5.0     54    1.81     9.26     80.886     2.828

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.101462 * X  +   0.339782 * Y  +  -0.935015 * Z  +  43.885876
  Y_new =  -0.759354 * X  +  -0.580751 * Y  +  -0.293443 * Z  +  62.397312
  Z_new =  -0.642718 * X  +   0.739781 * Y  +   0.199091 * Z  +   5.208874 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.307904   -1.833689  [ DEG:    74.9374   -105.0626 ]
  Theta =   0.698041    2.443552  [ DEG:    39.9948    140.0052 ]
  Phi   =  -1.437967    1.703626  [ DEG:   -82.3895     97.6105 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1mhn_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1mhn_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   62   5.0   54   1.81    9.26  80.886
REMARK  ---------------------------------------------------------- 
MOLECULE 1mhn_A
HEADER    RNA BINDING PROTEIN                     20-AUG-02   1MHN              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF THE SMN TUDOR DOMAIN             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: SMN, COMPONENT OF GEMS 1, GEMIN1;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET24D (MODIFIED)                     
KEYWDS    SMN, SMA, SPINAL MUSCULAR ATROPHY                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                            
REVDAT   1   25-MAR-03 1MHN    0                                                
JRNL        AUTH   R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                   
JRNL        TITL   HIGH RESOLUTION X-RAY AND NMR STRUCTURES OF THE              
JRNL        TITL 2 SMN TUDOR DOMAIN: CONFORMATIONAL VARIATION IN THE            
JRNL        TITL 3 BINDING SITE FOR SYMMETRICALLY DIMETHYLATED                  
JRNL        TITL 4 ARGININE RESIDUES                                            
JRNL        REF    J.MOL.BIOL.                   V. 327   507 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1MHN A   89   147  UNP    Q16637   SMN_HUMAN       89    147             
SEQRES   1 A   59  LEU GLN GLN TRP LYS VAL GLY ASP LYS CYS SER ALA ILE          
SEQRES   2 A   59  TRP SER GLU ASP GLY CYS ILE TYR PRO ALA THR ILE ALA          
SEQRES   3 A   59  SER ILE ASP PHE LYS ARG GLU THR CYS VAL VAL VAL TYR          
SEQRES   4 A   59  THR GLY TYR GLY ASN ARG GLU GLU GLN ASN LEU SER ASP          
SEQRES   5 A   59  LEU LEU SER PRO ILE CYS GLU                                  
FORMUL   2  HOH   *65(H2 O)                                                     
CRYST1   27.652   27.652  110.299  90.00  90.00 120.00 P 65          6          
ATOM      1  N   LEU A  89      29.662  77.869  -2.438  1.00 24.98           N  
ATOM      2  CA  LEU A  89      31.120  77.663  -2.518  1.00 24.12           C  
ATOM      3  C   LEU A  89      31.722  78.412  -1.358  1.00 23.96           C  
ATOM      4  O   LEU A  89      31.232  79.487  -0.976  1.00 24.32           O  
ATOM      5  CB  LEU A  89      31.704  78.217  -3.840  1.00 23.63           C  
ATOM      6  CG  LEU A  89      31.371  77.563  -5.170  1.00 26.77           C  
ATOM      7  CD1 LEU A  89      31.618  78.478  -6.336  1.00 25.38           C  
ATOM      8  CD2 LEU A  89      32.180  76.281  -5.345  1.00 25.60           C  
ATOM      9  N   GLN A  90      32.792  77.854  -0.793  1.00 22.23           N  
ATOM     10  CA  GLN A  90      33.648  78.607   0.105  1.00 22.13           C  
ATOM     11  C   GLN A  90      34.941  78.969  -0.632  1.00 20.54           C  
ATOM     12  O   GLN A  90      35.242  78.448  -1.717  1.00 18.15           O  
ATOM     13  CB  GLN A  90      33.931  77.802   1.385  1.00 22.97           C  
ATOM     14  CG  GLN A  90      32.672  77.143   1.942  1.00 28.57           C  
ATOM     15  CD  GLN A  90      32.793  76.705   3.370  1.00 36.43           C  
ATOM     16  OE1 GLN A  90      33.279  75.595   3.646  1.00 38.45           O  
ATOM     17  NE2 GLN A  90      32.337  77.559   4.297  1.00 39.04           N  
ATOM     18  N   GLN A  91      35.719  79.862  -0.038  1.00 19.57           N  
ATOM     19  CA  GLN A  91      36.974  80.283  -0.623  1.00 18.47           C  
ATOM     20  C   GLN A  91      38.012  79.228  -0.238  1.00 18.52           C  
ATOM     21  O   GLN A  91      38.275  78.915   0.972  1.00 20.83           O  
ATOM     22  CB  GLN A  91      37.401  81.686  -0.130  1.00 19.16           C  
ATOM     23  CG  GLN A  91      36.494  82.804  -0.619  1.00 22.55           C  
ATOM     24  CD  GLN A  91      36.599  84.119   0.184  1.00 28.43           C  
ATOM     25  OE1 GLN A  91      36.988  84.132   1.370  1.00 33.66           O  
ATOM     26  NE2 GLN A  91      36.228  85.214  -0.454  1.00 27.12           N  
ATOM     27  N   TRP A  92      38.587  78.650  -1.258  1.00 16.19           N  
ATOM     28  CA  TRP A  92      39.598  77.657  -1.052  1.00 14.81           C  
ATOM     29  C   TRP A  92      40.821  78.092  -1.834  1.00 15.35           C  
ATOM     30  O   TRP A  92      40.709  78.790  -2.865  1.00 15.05           O  
ATOM     31  CB  TRP A  92      39.078  76.325  -1.576  1.00 14.17           C  
ATOM     32  CG  TRP A  92      37.968  75.784  -0.741  1.00 12.91           C  
ATOM     33  CD1 TRP A  92      36.627  75.735  -1.078  1.00 13.33           C  
ATOM     34  CD2 TRP A  92      38.065  75.214   0.575  1.00 13.52           C  
ATOM     35  NE1 TRP A  92      35.900  75.142  -0.072  1.00 15.53           N  
ATOM     36  CE2 TRP A  92      36.753  74.825   0.964  1.00 15.15           C  
ATOM     37  CE3 TRP A  92      39.136  74.968   1.463  1.00 11.66           C  
ATOM     38  CZ2 TRP A  92      36.479  74.216   2.209  1.00 15.45           C  
ATOM     39  CZ3 TRP A  92      38.868  74.365   2.691  1.00 12.34           C  
ATOM     40  CH2 TRP A  92      37.540  73.994   3.054  1.00 13.15           C  
ATOM     41  N   LYS A  93      41.975  77.599  -1.391  1.00 15.43           N  
ATOM     42  CA  LYS A  93      43.209  77.832  -2.122  1.00 14.65           C  
ATOM     43  C   LYS A  93      44.040  76.565  -2.142  1.00 14.04           C  
ATOM     44  O   LYS A  93      43.873  75.674  -1.293  1.00 12.98           O  
ATOM     45  CB  LYS A  93      43.989  79.009  -1.535  1.00 15.47           C  
ATOM     46  CG  LYS A  93      44.503  78.856  -0.162  1.00 19.62           C  
ATOM     47  CD  LYS A  93      44.587  80.270   0.498  1.00 27.90           C  
ATOM     48  CE  LYS A  93      44.960  80.153   1.986  1.00 27.15           C  
ATOM     49  NZ  LYS A  93      46.379  79.780   1.971  1.00 32.85           N  
ATOM     50  N   VAL A  94      44.922  76.472  -3.109  1.00 12.55           N  
ATOM     51  CA  VAL A  94      45.798  75.310  -3.217  1.00 13.46           C  
ATOM     52  C   VAL A  94      46.574  75.225  -1.905  1.00 13.78           C  
ATOM     53  O   VAL A  94      47.052  76.269  -1.346  1.00 14.88           O  
ATOM     54  CB  VAL A  94      46.756  75.431  -4.427  1.00 13.04           C  
ATOM     55  CG1 VAL A  94      47.778  74.284  -4.454  1.00 12.39           C  
ATOM     56  CG2 VAL A  94      45.970  75.375  -5.747  1.00 14.56           C  
ATOM     57  N   GLY A  95      46.700  74.005  -1.394  1.00 13.03           N  
ATOM     58  CA  GLY A  95      47.450  73.780  -0.172  1.00 13.55           C  
ATOM     59  C   GLY A  95      46.565  73.846   1.071  1.00 12.52           C  
ATOM     60  O   GLY A  95      47.012  73.477   2.157  1.00 14.03           O  
ATOM     61  N   ASP A  96      45.335  74.340   0.945  1.00 13.27           N  
ATOM     62  CA  ASP A  96      44.423  74.443   2.124  1.00 11.63           C  
ATOM     63  C   ASP A  96      44.125  73.082   2.694  1.00 12.60           C  
ATOM     64  O   ASP A  96      44.060  72.103   1.947  1.00 10.59           O  
ATOM     65  CB  ASP A  96      43.071  75.051   1.773  1.00 12.58           C  
ATOM     66  CG  ASP A  96      43.040  76.525   1.900  1.00 15.59           C  
ATOM     67  OD1 ASP A  96      43.966  77.106   2.564  1.00 17.45           O  
ATOM     68  OD2 ASP A  96      42.083  77.194   1.391  1.00 15.07           O  
ATOM     69  N   LYS A  97      43.997  73.002   4.023  1.00 10.27           N  
ATOM     70  CA  LYS A  97      43.523  71.779   4.638  1.00 11.34           C  
ATOM     71  C   LYS A  97      41.996  71.768   4.560  1.00 10.56           C  
ATOM     72  O   LYS A  97      41.331  72.777   4.837  1.00 10.62           O  
ATOM     73  CB  LYS A  97      43.893  71.750   6.116  1.00 10.78           C  
ATOM     74  CG  LYS A  97      45.388  71.651   6.398  1.00 16.39           C  
ATOM     75  CD  LYS A  97      45.467  71.777   7.973  1.00 23.84           C  
ATOM     76  CE  LYS A  97      46.854  71.633   8.565  1.00 31.15           C  
ATOM     77  NZ  LYS A  97      46.811  70.589   9.634  1.00 33.93           N  
ATOM     78  N   CYS A  98      41.422  70.613   4.266  1.00 11.64           N  
ATOM     79  CA  CYS A  98      39.976  70.525   4.227  1.00 10.84           C  
ATOM     80  C   CYS A  98      39.635  69.066   4.622  1.00 11.41           C  
ATOM     81  O   CYS A  98      40.526  68.280   4.977  1.00 12.26           O  
ATOM     82  CB  CYS A  98      39.441  70.842   2.812  1.00 12.56           C  
ATOM     83  SG  CYS A  98      39.961  69.636   1.572  1.00 13.22           S  
ATOM     84  N   SER A  99      38.354  68.710   4.562  1.00 10.29           N  
ATOM     85  CA  SER A  99      37.985  67.308   4.622  1.00  9.74           C  
ATOM     86  C   SER A  99      37.027  67.051   3.469  1.00  9.45           C  
ATOM     87  O   SER A  99      36.473  67.974   2.910  1.00  9.89           O  
ATOM     88  CB  SER A  99      37.332  67.023   5.965  1.00 11.97           C  
ATOM     89  OG  SER A  99      38.378  67.172   6.965  1.00 10.62           O  
ATOM     90  N   ALA A 100      36.930  65.800   3.047  1.00 10.80           N  
ATOM     91  CA  ALA A 100      36.021  65.517   1.948  1.00 10.51           C  
ATOM     92  C   ALA A 100      35.530  64.101   2.036  1.00 11.16           C  
ATOM     93  O   ALA A 100      36.144  63.258   2.687  1.00 10.85           O  
ATOM     94  CB  ALA A 100      36.775  65.779   0.583  1.00 11.66           C  
ATOM     95  N   ILE A 101      34.387  63.834   1.393  1.00 12.15           N  
ATOM     96  CA  ILE A 101      33.877  62.476   1.328  1.00 12.14           C  
ATOM     97  C   ILE A 101      34.591  61.715   0.235  1.00 13.09           C  
ATOM     98  O   ILE A 101      34.497  62.074  -0.952  1.00 12.15           O  
ATOM     99  CB  ILE A 101      32.306  62.530   1.056  1.00 11.75           C  
ATOM    100  CG1 ILE A 101      31.622  63.409   2.128  1.00 12.63           C  
ATOM    101  CG2 ILE A 101      31.732  61.140   0.923  1.00 11.99           C  
ATOM    102  CD1 ILE A 101      30.099  63.818   1.802  1.00 13.30           C  
ATOM    103  N   TRP A 102      35.252  60.625   0.586  1.00 13.23           N  
ATOM    104  CA  TRP A 102      35.921  59.823  -0.419  1.00 15.00           C  
ATOM    105  C   TRP A 102      34.900  58.962  -1.167  1.00 16.94           C  
ATOM    106  O   TRP A 102      34.055  58.313  -0.541  1.00 15.64           O  
ATOM    107  CB  TRP A 102      36.910  58.918   0.274  1.00 17.63           C  
ATOM    108  CG  TRP A 102      37.986  58.362  -0.591  1.00 19.22           C  
ATOM    109  CD1 TRP A 102      38.003  58.226  -1.964  1.00 20.09           C  
ATOM    110  CD2 TRP A 102      39.236  57.867  -0.115  1.00 21.77           C  
ATOM    111  NE1 TRP A 102      39.205  57.669  -2.356  1.00 22.51           N  
ATOM    112  CE2 TRP A 102      39.979  57.454  -1.237  1.00 23.67           C  
ATOM    113  CE3 TRP A 102      39.822  57.765   1.169  1.00 23.79           C  
ATOM    114  CZ2 TRP A 102      41.274  56.909  -1.114  1.00 26.89           C  
ATOM    115  CZ3 TRP A 102      41.099  57.245   1.300  1.00 25.93           C  
ATOM    116  CH2 TRP A 102      41.818  56.818   0.159  1.00 27.49           C  
ATOM    117  N   SER A 103      34.974  58.960  -2.491  1.00 17.32           N  
ATOM    118  CA  SER A 103      33.911  58.317  -3.274  1.00 20.48           C  
ATOM    119  C   SER A 103      33.988  56.804  -3.180  1.00 20.42           C  
ATOM    120  O   SER A 103      33.026  56.102  -3.538  1.00 20.80           O  
ATOM    121  CB  SER A 103      33.880  58.780  -4.744  1.00 20.20           C  
ATOM    122  OG  SER A 103      35.067  58.387  -5.417  1.00 26.42           O  
ATOM    123  N   GLU A 104      35.115  56.304  -2.700  1.00 20.34           N  
ATOM    124  CA  GLU A 104      35.331  54.867  -2.598  1.00 22.28           C  
ATOM    125  C   GLU A 104      34.525  54.237  -1.464  1.00 20.57           C  
ATOM    126  O   GLU A 104      34.087  53.072  -1.559  1.00 20.50           O  
ATOM    127  CB  GLU A 104      36.845  54.588  -2.458  1.00 24.78           C  
ATOM    128  CG  GLU A 104      37.287  53.775  -1.260  1.00 30.32           C  
ATOM    129  CD  GLU A 104      38.598  54.275  -0.675  1.00 38.29           C  
ATOM    130  OE1 GLU A 104      39.624  54.239  -1.416  1.00 39.09           O  
ATOM    131  OE2 GLU A 104      38.572  54.715   0.513  1.00 38.17           O  
ATOM    132  N   ASP A 105      34.318  54.973  -0.384  1.00 18.29           N  
ATOM    133  CA  ASP A 105      33.622  54.361   0.758  1.00 17.58           C  
ATOM    134  C   ASP A 105      32.563  55.229   1.389  1.00 14.68           C  
ATOM    135  O   ASP A 105      31.887  54.766   2.296  1.00 16.83           O  
ATOM    136  CB  ASP A 105      34.594  53.800   1.820  1.00 17.63           C  
ATOM    137  CG  ASP A 105      35.281  54.900   2.620  1.00 20.47           C  
ATOM    138  OD1 ASP A 105      35.137  56.094   2.258  1.00 16.43           O  
ATOM    139  OD2 ASP A 105      35.949  54.660   3.632  1.00 20.50           O  
ATOM    140  N   GLY A 106      32.388  56.466   0.893  1.00 13.48           N  
ATOM    141  CA  GLY A 106      31.396  57.397   1.413  1.00 11.88           C  
ATOM    142  C   GLY A 106      31.690  57.933   2.805  1.00 13.55           C  
ATOM    143  O   GLY A 106      30.776  58.360   3.496  1.00 13.22           O  
ATOM    144  N   CYS A 107      32.964  57.888   3.209  1.00 13.06           N  
ATOM    145  CA  CYS A 107      33.369  58.377   4.539  1.00 14.57           C  
ATOM    146  C   CYS A 107      34.154  59.665   4.395  1.00 13.39           C  
ATOM    147  O   CYS A 107      34.739  59.901   3.349  1.00 13.06           O  
ATOM    148  CB  CYS A 107      34.277  57.365   5.204  1.00 14.21           C  
ATOM    149  SG  CYS A 107      33.385  55.825   5.655  1.00 20.69           S  
ATOM    150  N   ILE A 108      34.212  60.433   5.478  1.00 12.60           N  
ATOM    151  CA  ILE A 108      34.909  61.713   5.469  1.00 12.49           C  
ATOM    152  C   ILE A 108      36.385  61.461   5.779  1.00 11.02           C  
ATOM    153  O   ILE A 108      36.672  60.697   6.713  1.00 11.27           O  
ATOM    154  CB  ILE A 108      34.357  62.606   6.545  1.00 12.05           C  
ATOM    155  CG1 ILE A 108      32.905  63.016   6.239  1.00 14.13           C  
ATOM    156  CG2 ILE A 108      35.235  63.936   6.669  1.00 12.86           C  
ATOM    157  CD1 ILE A 108      32.218  63.743   7.446  1.00 18.26           C  
ATOM    158  N   TYR A 109      37.304  62.131   5.062  1.00 10.20           N  
ATOM    159  CA  TYR A 109      38.727  61.983   5.351  1.00 10.90           C  
ATOM    160  C   TYR A 109      39.366  63.330   5.342  1.00 11.43           C  
ATOM    161  O   TYR A 109      38.918  64.185   4.598  1.00 10.59           O  
ATOM    162  CB  TYR A 109      39.406  61.124   4.311  1.00 12.34           C  
ATOM    163  CG  TYR A 109      39.049  59.661   4.453  1.00 14.56           C  
ATOM    164  CD1 TYR A 109      37.935  59.110   3.746  1.00 15.29           C  
ATOM    165  CD2 TYR A 109      39.781  58.836   5.254  1.00 17.04           C  
ATOM    166  CE1 TYR A 109      37.584  57.803   3.854  1.00 14.67           C  
ATOM    167  CE2 TYR A 109      39.430  57.455   5.367  1.00 17.35           C  
ATOM    168  CZ  TYR A 109      38.324  56.962   4.661  1.00 18.16           C  
ATOM    169  OH  TYR A 109      37.992  55.625   4.745  1.00 20.05           O  
ATOM    170  N   PRO A 110      40.434  63.553   6.140  1.00 11.19           N  
ATOM    171  CA  PRO A 110      41.192  64.805   6.017  1.00 11.58           C  
ATOM    172  C   PRO A 110      41.892  64.838   4.662  1.00 10.75           C  
ATOM    173  O   PRO A 110      42.367  63.809   4.160  1.00 11.36           O  
ATOM    174  CB  PRO A 110      42.285  64.664   7.108  1.00 10.04           C  
ATOM    175  CG  PRO A 110      42.453  63.125   7.322  1.00 11.06           C  
ATOM    176  CD  PRO A 110      41.011  62.646   7.154  1.00 13.79           C  
ATOM    177  N   ALA A 111      42.030  66.041   4.103  1.00 10.42           N  
ATOM    178  CA  ALA A 111      42.658  66.197   2.799  1.00 10.95           C  
ATOM    179  C   ALA A 111      43.344  67.555   2.689  1.00 11.55           C  
ATOM    180  O   ALA A 111      43.126  68.430   3.542  1.00 10.55           O  
ATOM    181  CB  ALA A 111      41.605  66.054   1.719  1.00  9.80           C  
ATOM    182  N   THR A 112      44.234  67.665   1.691  1.00 11.13           N  
ATOM    183  CA  THR A 112      44.882  68.920   1.252  1.00 12.64           C  
ATOM    184  C   THR A 112      44.492  69.160  -0.225  1.00 12.50           C  
ATOM    185  O   THR A 112      44.441  68.213  -1.012  1.00 13.72           O  
ATOM    186  CB  THR A 112      46.405  68.744   1.305  1.00 11.23           C  
ATOM    187  OG1 THR A 112      46.777  68.352   2.644  1.00 17.52           O  
ATOM    188  CG2 THR A 112      47.041  70.057   1.121  1.00 15.61           C  
ATOM    189  N   ILE A 113      44.202  70.414  -0.587  1.00 12.93           N  
ATOM    190  CA  ILE A 113      43.908  70.757  -1.963  1.00 11.97           C  
ATOM    191  C   ILE A 113      45.191  70.845  -2.771  1.00 12.75           C  
ATOM    192  O   ILE A 113      46.082  71.614  -2.431  1.00 12.84           O  
ATOM    193  CB  ILE A 113      43.126  72.061  -2.079  1.00 12.62           C  
ATOM    194  CG1 ILE A 113      41.791  71.968  -1.307  1.00  9.88           C  
ATOM    195  CG2 ILE A 113      42.888  72.378  -3.587  1.00 10.79           C  
ATOM    196  CD1 ILE A 113      41.079  73.346  -1.154  1.00 10.89           C  
ATOM    197  N   ALA A 114      45.256  70.045  -3.825  1.00 13.06           N  
ATOM    198  CA  ALA A 114      46.439  69.907  -4.700  1.00 14.44           C  
ATOM    199  C   ALA A 114      46.350  70.833  -5.919  1.00 14.15           C  
ATOM    200  O   ALA A 114      47.368  71.248  -6.446  1.00 13.53           O  
ATOM    201  CB  ALA A 114      46.557  68.450  -5.197  1.00 13.48           C  
ATOM    202  N   SER A 115      45.136  71.089  -6.385  1.00 13.78           N  
ATOM    203  CA  SER A 115      44.926  71.898  -7.588  1.00 13.59           C  
ATOM    204  C   SER A 115      43.485  72.333  -7.597  1.00 12.87           C  
ATOM    205  O   SER A 115      42.622  71.632  -7.054  1.00 12.31           O  
ATOM    206  CB  SER A 115      45.270  71.128  -8.869  1.00 14.19           C  
ATOM    207  OG  SER A 115      44.416  70.009  -9.075  1.00 16.14           O  
ATOM    208  N   ILE A 116      43.208  73.487  -8.184  1.00 12.82           N  
ATOM    209  CA  ILE A 116      41.813  73.894  -8.360  1.00 13.35           C  
ATOM    210  C   ILE A 116      41.587  74.261  -9.857  1.00 13.79           C  
ATOM    211  O   ILE A 116      42.426  74.894 -10.482  1.00 15.12           O  
ATOM    212  CB  ILE A 116      41.479  75.096  -7.461  1.00 13.26           C  
ATOM    213  CG1 ILE A 116      41.685  74.784  -5.951  1.00 12.72           C  
ATOM    214  CG2 ILE A 116      40.030  75.623  -7.684  1.00 12.87           C  
ATOM    215  CD1 ILE A 116      41.703  76.006  -5.097  1.00 13.05           C  
ATOM    216  N   ASP A 117      40.461  73.857 -10.391  1.00 13.13           N  
ATOM    217  CA  ASP A 117      40.046  74.267 -11.728  1.00 14.69           C  
ATOM    218  C   ASP A 117      38.835  75.131 -11.576  1.00 15.18           C  
ATOM    219  O   ASP A 117      37.684  74.654 -11.426  1.00 15.48           O  
ATOM    220  CB  ASP A 117      39.780  73.004 -12.568  1.00 14.24           C  
ATOM    221  CG  ASP A 117      39.338  73.310 -13.990  1.00 18.13           C  
ATOM    222  OD1 ASP A 117      38.890  74.445 -14.283  1.00 19.47           O  
ATOM    223  OD2 ASP A 117      39.395  72.423 -14.849  1.00 20.06           O  
ATOM    224  N   PHE A 118      39.092  76.439 -11.583  1.00 15.31           N  
ATOM    225  CA  PHE A 118      38.061  77.395 -11.238  1.00 16.43           C  
ATOM    226  C   PHE A 118      36.971  77.400 -12.304  1.00 17.80           C  
ATOM    227  O   PHE A 118      35.801  77.510 -11.971  1.00 19.78           O  
ATOM    228  CB  PHE A 118      38.681  78.788 -11.032  1.00 15.86           C  
ATOM    229  CG  PHE A 118      39.323  78.956  -9.686  1.00 15.90           C  
ATOM    230  CD1 PHE A 118      40.715  79.134  -9.568  1.00 18.31           C  
ATOM    231  CD2 PHE A 118      38.558  78.900  -8.527  1.00 17.37           C  
ATOM    232  CE1 PHE A 118      41.297  79.213  -8.313  1.00 15.60           C  
ATOM    233  CE2 PHE A 118      39.154  79.004  -7.257  1.00 17.36           C  
ATOM    234  CZ  PHE A 118      40.512  79.174  -7.165  1.00 14.32           C  
ATOM    235  N   LYS A 119      37.338  77.225 -13.569  1.00 18.51           N  
ATOM    236  CA  LYS A 119      36.331  77.267 -14.643  1.00 20.39           C  
ATOM    237  C   LYS A 119      35.309  76.134 -14.524  1.00 18.80           C  
ATOM    238  O   LYS A 119      34.114  76.330 -14.800  1.00 20.18           O  
ATOM    239  CB  LYS A 119      36.977  77.269 -16.038  1.00 21.63           C  
ATOM    240  CG  LYS A 119      36.814  78.633 -16.796  1.00 28.48           C  
ATOM    241  CD  LYS A 119      38.050  78.968 -17.676  1.00 36.13           C  
ATOM    242  CE  LYS A 119      38.260  80.491 -17.911  1.00 38.94           C  
ATOM    243  NZ  LYS A 119      39.728  80.892 -17.803  1.00 41.55           N  
ATOM    244  N   ARG A 120      35.770  74.962 -14.084  1.00 17.23           N  
ATOM    245  CA  ARG A 120      34.862  73.832 -13.895  1.00 15.97           C  
ATOM    246  C   ARG A 120      34.347  73.700 -12.465  1.00 16.15           C  
ATOM    247  O   ARG A 120      33.467  72.887 -12.191  1.00 15.94           O  
ATOM    248  CB  ARG A 120      35.524  72.544 -14.358  1.00 16.59           C  
ATOM    249  CG  ARG A 120      35.970  72.614 -15.815  1.00 15.54           C  
ATOM    250  CD  ARG A 120      36.105  71.278 -16.482  1.00 16.50           C  
ATOM    251  NE  ARG A 120      36.671  71.438 -17.836  1.00 15.46           N  
ATOM    252  CZ  ARG A 120      35.912  71.564 -18.950  1.00 15.79           C  
ATOM    253  NH1 ARG A 120      34.583  71.502 -18.884  1.00 13.86           N  
ATOM    254  NH2 ARG A 120      36.490  71.678 -20.127  1.00 13.79           N  
ATOM    255  N   GLU A 121      34.879  74.541 -11.575  1.00 15.83           N  
ATOM    256  CA  GLU A 121      34.545  74.543 -10.145  1.00 16.50           C  
ATOM    257  C   GLU A 121      34.877  73.204  -9.486  1.00 15.79           C  
ATOM    258  O   GLU A 121      34.156  72.705  -8.620  1.00 17.02           O  
ATOM    259  CB  GLU A 121      33.077  74.941  -9.926  1.00 16.84           C  
ATOM    260  CG  GLU A 121      32.756  76.325 -10.454  1.00 21.26           C  
ATOM    261  CD  GLU A 121      33.330  77.499  -9.645  1.00 27.84           C  
ATOM    262  OE1 GLU A 121      34.298  77.382  -8.891  1.00 30.26           O  
ATOM    263  OE2 GLU A 121      32.789  78.605  -9.790  1.00 34.42           O  
ATOM    264  N   THR A 122      35.978  72.635  -9.893  1.00 14.63           N  
ATOM    265  CA  THR A 122      36.414  71.399  -9.287  1.00 14.44           C  
ATOM    266  C   THR A 122      37.796  71.612  -8.708  1.00 12.73           C  
ATOM    267  O   THR A 122      38.479  72.634  -8.974  1.00 12.77           O  
ATOM    268  CB  THR A 122      36.440  70.201 -10.294  1.00 15.00           C  
ATOM    269  OG1 THR A 122      37.368  70.456 -11.358  1.00 14.90           O  
ATOM    270  CG2 THR A 122      35.093  70.036 -11.020  1.00 17.82           C  
ATOM    271  N   CYS A 123      38.208  70.631  -7.928  1.00 12.36           N  
ATOM    272  CA  CYS A 123      39.591  70.586  -7.462  1.00 12.67           C  
ATOM    273  C   CYS A 123      40.034  69.138  -7.360  1.00 12.83           C  
ATOM    274  O   CYS A 123      39.212  68.223  -7.516  1.00 13.81           O  
ATOM    275  CB  CYS A 123      39.715  71.296  -6.122  1.00 11.40           C  
ATOM    276  SG  CYS A 123      38.684  70.491  -4.844  1.00 13.78           S  
ATOM    277  N   VAL A 124      41.331  68.922  -7.151  1.00 11.72           N  
ATOM    278  CA  VAL A 124      41.843  67.626  -6.787  1.00 12.15           C  
ATOM    279  C   VAL A 124      42.310  67.759  -5.310  1.00 12.46           C  
ATOM    280  O   VAL A 124      43.062  68.665  -4.961  1.00 11.23           O  
ATOM    281  CB  VAL A 124      43.021  67.207  -7.623  1.00 13.52           C  
ATOM    282  CG1 VAL A 124      43.684  65.873  -7.082  1.00 14.49           C  
ATOM    283  CG2 VAL A 124      42.602  67.041  -9.069  1.00 13.54           C  
ATOM    284  N   VAL A 125      41.856  66.822  -4.488  1.00 11.94           N  
ATOM    285  CA  VAL A 125      42.364  66.693  -3.107  1.00 12.01           C  
ATOM    286  C   VAL A 125      43.188  65.434  -2.929  1.00 11.98           C  
ATOM    287  O   VAL A 125      43.002  64.413  -3.641  1.00 14.06           O  
ATOM    288  CB  VAL A 125      41.220  66.744  -2.062  1.00 11.85           C  
ATOM    289  CG1 VAL A 125      40.390  67.953  -2.298  1.00 10.80           C  
ATOM    290  CG2 VAL A 125      40.295  65.494  -2.158  1.00 13.39           C  
ATOM    291  N   VAL A 126      44.115  65.503  -1.970  1.00 11.36           N  
ATOM    292  CA  VAL A 126      44.913  64.367  -1.613  1.00 12.68           C  
ATOM    293  C   VAL A 126      44.536  64.007  -0.185  1.00 12.94           C  
ATOM    294  O   VAL A 126      44.651  64.827   0.718  1.00 12.27           O  
ATOM    295  CB  VAL A 126      46.410  64.701  -1.685  1.00 13.33           C  
ATOM    296  CG1 VAL A 126      47.275  63.537  -1.178  1.00 14.79           C  
ATOM    297  CG2 VAL A 126      46.820  65.106  -3.147  1.00 14.04           C  
ATOM    298  N   TYR A 127      44.102  62.778   0.010  1.00 13.53           N  
ATOM    299  CA  TYR A 127      43.683  62.355   1.334  1.00 13.83           C  
ATOM    300  C   TYR A 127      44.922  62.114   2.166  1.00 15.12           C  
ATOM    301  O   TYR A 127      45.727  61.248   1.859  1.00 14.70           O  
ATOM    302  CB  TYR A 127      42.813  61.116   1.256  1.00 12.96           C  
ATOM    303  CG  TYR A 127      41.539  61.411   0.544  1.00 12.64           C  
ATOM    304  CD1 TYR A 127      41.322  60.895  -0.740  1.00 12.69           C  
ATOM    305  CD2 TYR A 127      40.569  62.294   1.116  1.00 12.95           C  
ATOM    306  CE1 TYR A 127      40.107  61.195  -1.461  1.00 14.20           C  
ATOM    307  CE2 TYR A 127      39.392  62.598   0.391  1.00 14.11           C  
ATOM    308  CZ  TYR A 127      39.169  62.023  -0.875  1.00 13.71           C  
ATOM    309  OH  TYR A 127      38.009  62.324  -1.586  1.00 14.52           O  
ATOM    310  N   THR A 128      45.026  62.927   3.207  1.00 16.87           N  
ATOM    311  CA  THR A 128      46.221  63.064   4.072  1.00 17.00           C  
ATOM    312  C   THR A 128      46.579  61.803   4.783  1.00 16.18           C  
ATOM    313  O   THR A 128      45.879  61.393   5.725  1.00 19.10           O  
ATOM    314  CB  THR A 128      45.873  64.081   5.179  1.00 17.63           C  
ATOM    315  OG1 THR A 128      45.622  65.345   4.605  1.00 18.88           O  
ATOM    316  CG2 THR A 128      47.054  64.357   6.095  1.00 21.38           C  
ATOM    317  N   GLY A 129      47.692  61.198   4.398  1.00 16.38           N  
ATOM    318  CA  GLY A 129      48.128  59.994   5.035  1.00 16.60           C  
ATOM    319  C   GLY A 129      47.453  58.757   4.481  1.00 18.07           C  
ATOM    320  O   GLY A 129      47.657  57.642   5.005  1.00 18.86           O  
ATOM    321  N   TYR A 130      46.666  58.935   3.417  1.00 17.89           N  
ATOM    322  CA  TYR A 130      45.986  57.825   2.779  1.00 18.37           C  
ATOM    323  C   TYR A 130      46.472  57.556   1.344  1.00 19.33           C  
ATOM    324  O   TYR A 130      45.951  56.649   0.670  1.00 19.21           O  
ATOM    325  CB  TYR A 130      44.486  58.065   2.788  1.00 18.52           C  
ATOM    326  CG  TYR A 130      43.914  58.148   4.176  1.00 18.99           C  
ATOM    327  CD1 TYR A 130      43.769  59.368   4.819  1.00 20.70           C  
ATOM    328  CD2 TYR A 130      43.544  56.992   4.871  1.00 18.98           C  
ATOM    329  CE1 TYR A 130      43.243  59.445   6.109  1.00 21.80           C  
ATOM    330  CE2 TYR A 130      43.015  57.068   6.136  1.00 20.61           C  
ATOM    331  CZ  TYR A 130      42.873  58.293   6.758  1.00 23.14           C  
ATOM    332  OH  TYR A 130      42.358  58.391   8.047  1.00 27.79           O  
ATOM    333  N   GLY A 131      47.407  58.389   0.864  1.00 18.30           N  
ATOM    334  CA  GLY A 131      48.148  58.156  -0.365  1.00 18.95           C  
ATOM    335  C   GLY A 131      47.381  58.203  -1.650  1.00 20.71           C  
ATOM    336  O   GLY A 131      47.850  57.689  -2.665  1.00 21.00           O  
ATOM    337  N   ASN A 132      46.189  58.794  -1.618  1.00 20.36           N  
ATOM    338  CA  ASN A 132      45.280  58.709  -2.742  1.00 21.54           C  
ATOM    339  C   ASN A 132      44.700  60.088  -3.008  1.00 20.96           C  
ATOM    340  O   ASN A 132      44.656  60.924  -2.110  1.00 20.70           O  
ATOM    341  CB  ASN A 132      44.122  57.746  -2.413  1.00 22.58           C  
ATOM    342  CG  ASN A 132      44.367  56.327  -2.914  1.00 27.86           C  
ATOM    343  OD1 ASN A 132      44.441  55.379  -2.115  1.00 31.24           O  
ATOM    344  ND2 ASN A 132      44.500  56.168  -4.247  1.00 32.44           N  
ATOM    345  N   ARG A 133      44.245  60.324  -4.236  1.00 20.25           N  
ATOM    346  CA  ARG A 133      43.709  61.616  -4.596  1.00 19.80           C  
ATOM    347  C   ARG A 133      42.399  61.454  -5.359  1.00 20.40           C  
ATOM    348  O   ARG A 133      42.088  60.380  -5.892  1.00 19.90           O  
ATOM    349  CB  ARG A 133      44.736  62.385  -5.443  1.00 20.38           C  
ATOM    350  CG  ARG A 133      44.781  61.862  -6.869  1.00 22.71           C  
ATOM    351  CD  ARG A 133      45.768  62.576  -7.730  1.00 25.76           C  
ATOM    352  NE  ARG A 133      47.102  62.291  -7.252  1.00 26.60           N  
ATOM    353  CZ  ARG A 133      48.161  62.963  -7.632  1.00 26.60           C  
ATOM    354  NH1 ARG A 133      48.010  63.945  -8.508  1.00 28.78           N  
ATOM    355  NH2 ARG A 133      49.355  62.641  -7.151  1.00 22.60           N  
ATOM    356  N   GLU A 134      41.650  62.534  -5.459  1.00 18.63           N  
ATOM    357  CA  GLU A 134      40.355  62.444  -6.078  1.00 20.06           C  
ATOM    358  C   GLU A 134      39.924  63.839  -6.498  1.00 19.00           C  
ATOM    359  O   GLU A 134      40.223  64.802  -5.798  1.00 18.38           O  
ATOM    360  CB  GLU A 134      39.402  61.838  -5.034  1.00 19.72           C  
ATOM    361  CG  GLU A 134      37.955  62.117  -5.183  1.00 24.74           C  
ATOM    362  CD  GLU A 134      37.176  60.991  -4.565  1.00 28.00           C  
ATOM    363  OE1 GLU A 134      36.886  61.056  -3.379  1.00 25.35           O  
ATOM    364  OE2 GLU A 134      36.901  60.027  -5.293  1.00 34.34           O  
ATOM    365  N   GLU A 135      39.233  63.946  -7.647  1.00 18.23           N  
ATOM    366  CA  GLU A 135      38.540  65.173  -8.004  1.00 17.78           C  
ATOM    367  C   GLU A 135      37.322  65.324  -7.155  1.00 16.52           C  
ATOM    368  O   GLU A 135      36.581  64.350  -6.918  1.00 16.85           O  
ATOM    369  CB  GLU A 135      38.144  65.145  -9.499  1.00 20.25           C  
ATOM    370  CG  GLU A 135      37.559  66.440 -10.048  1.00 25.46           C  
ATOM    371  CD  GLU A 135      37.882  66.564 -11.531  1.00 35.03           C  
ATOM    372  OE1 GLU A 135      37.066  66.087 -12.350  1.00 35.95           O  
ATOM    373  OE2 GLU A 135      38.986  67.072 -11.867  1.00 39.30           O  
ATOM    374  N   GLN A 136      37.093  66.551  -6.712  1.00 14.27           N  
ATOM    375  CA  GLN A 136      35.950  66.946  -5.917  1.00 14.69           C  
ATOM    376  C   GLN A 136      35.387  68.228  -6.515  1.00 15.36           C  
ATOM    377  O   GLN A 136      36.142  69.083  -7.012  1.00 15.68           O  
ATOM    378  CB  GLN A 136      36.354  67.275  -4.454  1.00 14.28           C  
ATOM    379  CG  GLN A 136      36.792  66.106  -3.610  1.00 13.40           C  
ATOM    380  CD  GLN A 136      35.655  65.256  -3.023  1.00 15.88           C  
ATOM    381  OE1 GLN A 136      34.510  65.706  -2.896  1.00 16.89           O  
ATOM    382  NE2 GLN A 136      35.997  64.027  -2.631  1.00 14.22           N  
ATOM    383  N   ASN A 137      34.071  68.388  -6.470  1.00 15.31           N  
ATOM    384  CA  ASN A 137      33.502  69.711  -6.684  1.00 16.53           C  
ATOM    385  C   ASN A 137      33.925  70.582  -5.527  1.00 15.03           C  
ATOM    386  O   ASN A 137      33.913  70.126  -4.375  1.00 13.44           O  
ATOM    387  CB  ASN A 137      31.986  69.660  -6.722  1.00 18.97           C  
ATOM    388  CG  ASN A 137      31.480  68.808  -7.860  1.00 22.69           C  
ATOM    389  OD1 ASN A 137      31.997  68.882  -8.976  1.00 21.51           O  
ATOM    390  ND2 ASN A 137      30.503  67.945  -7.566  1.00 23.88           N  
ATOM    391  N   LEU A 138      34.341  71.815  -5.818  1.00 13.95           N  
ATOM    392  CA  LEU A 138      34.629  72.757  -4.724  1.00 13.03           C  
ATOM    393  C   LEU A 138      33.437  72.863  -3.745  1.00 13.55           C  
ATOM    394  O   LEU A 138      33.661  72.956  -2.527  1.00 12.76           O  
ATOM    395  CB  LEU A 138      34.973  74.150  -5.257  1.00 12.70           C  
ATOM    396  CG  LEU A 138      36.327  74.276  -5.946  1.00 14.13           C  
ATOM    397  CD1 LEU A 138      36.376  75.511  -6.731  1.00 15.22           C  
ATOM    398  CD2 LEU A 138      37.420  74.292  -4.858  1.00 12.31           C  
ATOM    399  N   SER A 139      32.194  72.812  -4.245  1.00 12.04           N  
ATOM    400  CA  SER A 139      31.024  72.964  -3.360  1.00 14.70           C  
ATOM    401  C   SER A 139      30.905  71.841  -2.323  1.00 14.00           C  
ATOM    402  O   SER A 139      30.171  71.995  -1.355  1.00 16.53           O  
ATOM    403  CB  SER A 139      29.702  73.054  -4.147  1.00 13.76           C  
ATOM    404  OG  SER A 139      29.630  71.946  -5.002  1.00 17.61           O  
ATOM    405  N   ASP A 140      31.574  70.725  -2.560  1.00 14.52           N  
ATOM    406  CA  ASP A 140      31.450  69.533  -1.731  1.00 13.21           C  
ATOM    407  C   ASP A 140      32.536  69.452  -0.662  1.00 13.57           C  
ATOM    408  O   ASP A 140      32.509  68.515   0.148  1.00 13.77           O  
ATOM    409  CB  ASP A 140      31.515  68.257  -2.572  1.00 13.35           C  
ATOM    410  CG  ASP A 140      30.284  68.054  -3.444  1.00 14.72           C  
ATOM    411  OD1 ASP A 140      29.216  68.608  -3.113  1.00 18.24           O  
ATOM    412  OD2 ASP A 140      30.333  67.336  -4.461  1.00 17.84           O  
ATOM    413  N   LEU A 141      33.480  70.410  -0.644  1.00 11.97           N  
ATOM    414  CA  LEU A 141      34.574  70.338   0.369  1.00 11.52           C  
ATOM    415  C   LEU A 141      33.989  70.720   1.719  1.00 11.40           C  
ATOM    416  O   LEU A 141      33.022  71.515   1.816  1.00 11.40           O  
ATOM    417  CB  LEU A 141      35.733  71.289  -0.009  1.00 10.24           C  
ATOM    418  CG  LEU A 141      36.462  70.868  -1.289  1.00 10.59           C  
ATOM    419  CD1 LEU A 141      37.596  71.937  -1.477  1.00 10.72           C  
ATOM    420  CD2 LEU A 141      37.063  69.449  -1.319  1.00  8.38           C  
ATOM    421  N   LEU A 142      34.584  70.148   2.769  1.00 12.13           N  
ATOM    422  CA  LEU A 142      34.146  70.384   4.115  1.00 10.57           C  
ATOM    423  C   LEU A 142      35.259  71.016   4.943  1.00 11.42           C  
ATOM    424  O   LEU A 142      36.461  70.892   4.640  1.00 10.91           O  
ATOM    425  CB  LEU A 142      33.769  69.069   4.786  1.00 10.93           C  
ATOM    426  CG  LEU A 142      32.857  68.070   4.032  1.00 13.72           C  
ATOM    427  CD1 LEU A 142      32.860  66.692   4.652  1.00 13.71           C  
ATOM    428  CD2 LEU A 142      31.470  68.685   3.991  1.00 15.19           C  
ATOM    429  N   SER A 143      34.827  71.641   6.015  1.00 11.77           N  
ATOM    430  CA  SER A 143      35.737  72.129   7.063  1.00 12.35           C  
ATOM    431  C   SER A 143      36.762  71.102   7.463  1.00 11.34           C  
ATOM    432  O   SER A 143      36.403  69.940   7.666  1.00 12.53           O  
ATOM    433  CB  SER A 143      34.929  72.420   8.328  1.00 12.83           C  
ATOM    434  OG  SER A 143      35.831  72.797   9.364  1.00 17.49           O  
ATOM    435  N   PRO A 144      38.037  71.500   7.662  1.00 11.95           N  
ATOM    436  CA  PRO A 144      39.024  70.517   8.071  1.00 12.92           C  
ATOM    437  C   PRO A 144      38.741  69.980   9.481  1.00 13.91           C  
ATOM    438  O   PRO A 144      39.362  69.018   9.826  1.00 12.67           O  
ATOM    439  CB  PRO A 144      40.362  71.271   8.002  1.00 13.67           C  
ATOM    440  CG  PRO A 144      40.019  72.698   8.122  1.00 13.27           C  
ATOM    441  CD  PRO A 144      38.660  72.818   7.374  1.00 11.28           C  
ATOM    442  N   ILE A 145      37.842  70.606  10.251  1.00 15.28           N  
ATOM    443  CA  ILE A 145      37.419  70.041  11.544  1.00 18.46           C  
ATOM    444  C   ILE A 145      36.627  68.719  11.411  1.00 19.93           C  
ATOM    445  O   ILE A 145      36.693  67.851  12.306  1.00 19.05           O  
ATOM    446  CB  ILE A 145      36.632  71.077  12.317  1.00 18.94           C  
ATOM    447  CG1 ILE A 145      37.528  72.291  12.620  1.00 21.76           C  
ATOM    448  CG2 ILE A 145      36.020  70.487  13.631  1.00 21.94           C  
ATOM    449  CD1 ILE A 145      36.749  73.481  13.166  1.00 27.58           C  
ATOM    450  N   CYS A 146      35.873  68.539  10.320  1.00 21.33           N  
ATOM    451  CA  CYS A 146      35.142  67.271  10.131  1.00 23.96           C  
ATOM    452  C   CYS A 146      36.061  66.135   9.886  1.00 24.98           C  
ATOM    453  O   CYS A 146      36.772  66.133   8.885  1.00 25.48           O  
ATOM    454  CB  CYS A 146      34.214  67.295   8.936  1.00 25.09           C  
ATOM    455  SG  CYS A 146      33.358  68.790   8.955  1.00 27.50           S  
ATOM    456  N   GLU A 147      36.003  65.134  10.744  1.00 26.02           N  
ATOM    457  CA  GLU A 147      36.792  63.927  10.499  1.00 28.66           C  
ATOM    458  C   GLU A 147      36.017  62.632  10.773  1.00 28.95           C  
ATOM    459  O   GLU A 147      36.451  61.505  10.547  1.00 29.73           O  
ATOM    460  CB  GLU A 147      38.133  64.019  11.242  1.00 29.32           C  
ATOM    461  CG  GLU A 147      39.111  64.945  10.519  1.00 31.74           C  
ATOM    462  CD  GLU A 147      40.456  65.101  11.188  1.00 33.34           C  
ATOM    463  OE1 GLU A 147      41.460  64.679  10.574  1.00 36.57           O  
ATOM    464  OE2 GLU A 147      40.529  65.697  12.281  1.00 33.03           O  
ATOM    465  OXT GLU A 147      34.868  62.662  11.209  1.00 30.39           O  
TER     466      GLU A 147                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
