
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 ( 1611),  selected  100 , name 2efi_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2efi_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    K    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    D    13_A      E       1           #
LGA    P    14_A      N       2           -
LGA    K    15_A      L       3           #
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    P    16_A      Q       6          1.897
LGA    K    17_A      G       7          3.082
LGA    -       -      D       8           -
LGA    F    18_A      L       9          1.319
LGA    Q    19_A      I      10          0.833
LGA    E    20_A      V      11          0.845
LGA    G    21_A      S      12          1.003
LGA    E    22_A      M      13          0.699
LGA    R    23_A      R      14          0.661
LGA    V    24_A      I      15          0.511
LGA    L    25_A      L      16          0.538
LGA    C    26_A      G      17          0.534
LGA    F    27_A      K      18          0.715
LGA    H    28_A      K      19          1.081
LGA    G    29_A      R      20          3.421
LGA    -       -      T      21           -
LGA    P    30_A      K      22          2.172
LGA    L    31_A      T      23          0.609
LGA    L    32_A      W      24          0.284
LGA    Y    33_A      X      25          1.108
LGA    E    34_A      K      26          0.786
LGA    A    35_A      G      27          0.560
LGA    K    36_A      T      28          0.897
LGA    C    37_A      L      29          0.519
LGA    V    38_A      I      30          0.335
LGA    K    39_A      A      31          0.780
LGA    V    40_A      I      32          0.923
LGA    A    41_A      Q      33          0.859
LGA    I    42_A      T      34          0.810
LGA    K    43_A      V      35          0.985
LGA    D    44_A      G      36          4.474
LGA    K    45_A      P      37          1.678
LGA    Q    46_A      G      38          1.375
LGA    V    47_A      K      39          1.342
LGA    K    48_A      K      40          1.182
LGA    Y    49_A      Y      41          1.324
LGA    F    50_A      K      42          1.137
LGA    I    51_A      V      43          0.441
LGA    H    52_A      K      44          0.236
LGA    Y    53_A      F      45          0.936
LGA    S    54_A      D      46          0.698
LGA    G    55_A      N      47          0.774
LGA    W    56_A      K      48          3.504
LGA    N    57_A      -       -           -
LGA    K    58_A      -       -           -
LGA    N    59_A      -       -           -
LGA    W    60_A      G      49          3.841
LGA    D    61_A      K      50          1.483
LGA    E    62_A      S      51          1.726
LGA    W    63_A      L      52          0.891
LGA    V    64_A      L      53          0.913
LGA    P    65_A      S      54          1.542
LGA    E    66_A      G      55          1.297
LGA    S    67_A      N      56          1.160
LGA    R    68_A      X      57          0.933
LGA    V    69_A      I      58          1.136
LGA    L    70_A      A      59          0.981
LGA    K    71_A      Y      60          1.419
LGA    Y    72_A      D      61          1.218
LGA    V    73_A      Y      62          1.391
LGA    D    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    N    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    Q    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    R    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    Q    84_A      -       -           -
LGA    K    85_A      -       -           -
LGA    A    86_A      -       -           -
LGA    N    87_A      -       -           -
LGA    Q    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    Q    90_A      -       -           -
LGA    Y    91_A      -       -           -
LGA    A    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    M    96_A      -       -           -
LGA    R    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    A    99_A      -       -           -
LGA    A   100_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100   62    5.0     55    1.51     7.27     84.861     3.412

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.157221 * X  +  -0.081044 * Y  +  -0.984232 * Z  +  39.416313
  Y_new =   0.795275 * X  +   0.580491 * Y  +  -0.174836 * Z  +  66.737488
  Z_new =   0.585507 * X  +  -0.810223 * Y  +  -0.026813 * Z  +  -0.534536 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.603878    1.537715  [ DEG:   -91.8954     88.1046 ]
  Theta =  -0.625506   -2.516087  [ DEG:   -35.8388   -144.1611 ]
  Phi   =   1.765973   -1.375620  [ DEG:   101.1828    -78.8172 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2efi_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2efi_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100   62   5.0   55   1.51    7.27  84.861
REMARK  ---------------------------------------------------------- 
MOLECULE 2efi_A
HEADER    TRANSCRIPTION                           22-FEB-07   2EFI              
TITLE     SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF MORTALITY FACTOR           
TITLE    2 4-LIKE PROTEIN 1 FROM HUMAN                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORTALITY FACTOR 4-LIKE PROTEIN 1;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 SYNONYM: MORF-RELATED GENE 15 PROTEIN, TRANSCRIPTION                 
COMPND   6 FACTOR-LIKE PROTEIN MRG15, MSL3-1 PROTEIN;                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MORF4L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060522-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    CHROMO DOMAIN, MORTALITY FACTOR 4-LIKE PROTEIN 1,                     
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, TRANSCRIPTION                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,                   
AUTHOR   2 S.WATANABE,T.KIGAWA,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   28-AUG-07 2EFI    0                                                
JRNL        AUTH   H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,          
JRNL        AUTH 2 S.WATANABE,T.KIGAWA,S.YOKOYAMA                               
JRNL        TITL   SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF                   
JRNL        TITL 2 MORTALITY FACTOR 4-LIKE PROTEIN 1 FROM HUMAN                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EFI A    8   100  UNP    Q9UBU8   MO4L1_HUMAN      1     93             
SEQRES   1 A  100  GLY SER SER GLY SER SER GLY MET ALA PRO LYS GLN ASP          
SEQRES   2 A  100  PRO LYS PRO LYS PHE GLN GLU GLY GLU ARG VAL LEU CYS          
SEQRES   3 A  100  PHE HIS GLY PRO LEU LEU TYR GLU ALA LYS CYS VAL LYS          
SEQRES   4 A  100  VAL ALA ILE LYS ASP LYS GLN VAL LYS TYR PHE ILE HIS          
SEQRES   5 A  100  TYR SER GLY TRP ASN LYS ASN TRP ASP GLU TRP VAL PRO          
SEQRES   6 A  100  GLU SER ARG VAL LEU LYS TYR VAL ASP THR ASN LEU GLN          
SEQRES   7 A  100  LYS GLN ARG GLU LEU GLN LYS ALA ASN GLN GLU GLN TYR          
SEQRES   8 A  100  ALA GLU GLY LYS MET ARG GLY ALA ALA                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      43.532  86.586   5.989  1.00  0.00           N  
ATOM      2  CA  GLY A   1      43.118  87.844   5.396  1.00  0.00           C  
ATOM      3  C   GLY A   1      41.970  88.488   6.148  1.00  0.00           C  
ATOM      4  O   GLY A   1      40.847  87.984   6.128  1.00  0.00           O  
ATOM      5  H1  GLY A   1      43.290  86.379   6.915  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      43.958  88.522   5.394  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      42.810  87.665   4.377  1.00  0.00           H  
ATOM      8  N   SER A   2      42.251  89.603   6.813  1.00  0.00           N  
ATOM      9  CA  SER A   2      41.233  90.314   7.580  1.00  0.00           C  
ATOM     10  C   SER A   2      41.097  91.754   7.096  1.00  0.00           C  
ATOM     11  O   SER A   2      42.021  92.555   7.230  1.00  0.00           O  
ATOM     12  CB  SER A   2      41.581  90.295   9.069  1.00  0.00           C  
ATOM     13  OG  SER A   2      41.089  89.121   9.693  1.00  0.00           O  
ATOM     14  H   SER A   2      43.166  89.955   6.791  1.00  0.00           H  
ATOM     15  HA  SER A   2      40.292  89.806   7.431  1.00  0.00           H  
ATOM     16  HB2 SER A   2      42.653  90.327   9.186  1.00  0.00           H  
ATOM     17  HB3 SER A   2      41.140  91.156   9.550  1.00  0.00           H  
ATOM     18  HG  SER A   2      41.557  88.355   9.350  1.00  0.00           H  
ATOM     19  N   SER A   3      39.936  92.075   6.533  1.00  0.00           N  
ATOM     20  CA  SER A   3      39.678  93.418   6.026  1.00  0.00           C  
ATOM     21  C   SER A   3      38.229  93.558   5.571  1.00  0.00           C  
ATOM     22  O   SER A   3      37.470  92.589   5.570  1.00  0.00           O  
ATOM     23  CB  SER A   3      40.622  93.737   4.865  1.00  0.00           C  
ATOM     24  OG  SER A   3      40.849  95.132   4.763  1.00  0.00           O  
ATOM     25  H   SER A   3      39.238  91.392   6.455  1.00  0.00           H  
ATOM     26  HA  SER A   3      39.860  94.117   6.829  1.00  0.00           H  
ATOM     27  HB2 SER A   3      41.567  93.242   5.026  1.00  0.00           H  
ATOM     28  HB3 SER A   3      40.184  93.387   3.942  1.00  0.00           H  
ATOM     29  HG  SER A   3      41.486  95.302   4.064  1.00  0.00           H  
ATOM     30  N   GLY A   4      37.851  94.772   5.185  1.00  0.00           N  
ATOM     31  CA  GLY A   4      36.494  95.018   4.732  1.00  0.00           C  
ATOM     32  C   GLY A   4      36.159  94.259   3.463  1.00  0.00           C  
ATOM     33  O   GLY A   4      37.031  94.011   2.632  1.00  0.00           O  
ATOM     34  H   GLY A   4      38.498  95.507   5.206  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      35.807  94.719   5.510  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      36.374  96.075   4.547  1.00  0.00           H  
ATOM     37  N   SER A   5      34.891  93.887   3.315  1.00  0.00           N  
ATOM     38  CA  SER A   5      34.444  93.147   2.141  1.00  0.00           C  
ATOM     39  C   SER A   5      33.621  94.040   1.217  1.00  0.00           C  
ATOM     40  O   SER A   5      32.391  94.043   1.273  1.00  0.00           O  
ATOM     41  CB  SER A   5      33.618  91.930   2.563  1.00  0.00           C  
ATOM     42  OG  SER A   5      34.455  90.846   2.925  1.00  0.00           O  
ATOM     43  H   SER A   5      34.241  94.114   4.014  1.00  0.00           H  
ATOM     44  HA  SER A   5      35.321  92.809   1.609  1.00  0.00           H  
ATOM     45  HB2 SER A   5      33.003  92.193   3.410  1.00  0.00           H  
ATOM     46  HB3 SER A   5      32.987  91.624   1.741  1.00  0.00           H  
ATOM     47  HG  SER A   5      35.288  90.913   2.451  1.00  0.00           H  
ATOM     48  N   SER A   6      34.308  94.796   0.368  1.00  0.00           N  
ATOM     49  CA  SER A   6      33.642  95.696  -0.567  1.00  0.00           C  
ATOM     50  C   SER A   6      34.395  95.758  -1.892  1.00  0.00           C  
ATOM     51  O   SER A   6      35.587  96.055  -1.928  1.00  0.00           O  
ATOM     52  CB  SER A   6      33.531  97.098   0.036  1.00  0.00           C  
ATOM     53  OG  SER A   6      32.420  97.191   0.910  1.00  0.00           O  
ATOM     54  H   SER A   6      35.288  94.749   0.371  1.00  0.00           H  
ATOM     55  HA  SER A   6      32.650  95.311  -0.746  1.00  0.00           H  
ATOM     56  HB2 SER A   6      34.429  97.321   0.590  1.00  0.00           H  
ATOM     57  HB3 SER A   6      33.409  97.819  -0.760  1.00  0.00           H  
ATOM     58  HG  SER A   6      32.728  97.215   1.819  1.00  0.00           H  
ATOM     59  N   GLY A   7      33.687  95.473  -2.981  1.00  0.00           N  
ATOM     60  CA  GLY A   7      34.303  95.502  -4.294  1.00  0.00           C  
ATOM     61  C   GLY A   7      33.517  94.708  -5.320  1.00  0.00           C  
ATOM     62  O   GLY A   7      33.326  93.502  -5.168  1.00  0.00           O  
ATOM     63  H   GLY A   7      32.738  95.242  -2.892  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      34.373  96.526  -4.625  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      35.298  95.088  -4.221  1.00  0.00           H  
ATOM     66  N   MET A   8      33.060  95.386  -6.367  1.00  0.00           N  
ATOM     67  CA  MET A   8      32.290  94.737  -7.422  1.00  0.00           C  
ATOM     68  C   MET A   8      33.196  93.893  -8.314  1.00  0.00           C  
ATOM     69  O   MET A   8      34.403  94.119  -8.379  1.00  0.00           O  
ATOM     70  CB  MET A   8      31.555  95.782  -8.263  1.00  0.00           C  
ATOM     71  CG  MET A   8      30.316  96.345  -7.585  1.00  0.00           C  
ATOM     72  SD  MET A   8      29.324  97.367  -8.690  1.00  0.00           S  
ATOM     73  CE  MET A   8      29.883  99.005  -8.230  1.00  0.00           C  
ATOM     74  H   MET A   8      33.244  96.346  -6.433  1.00  0.00           H  
ATOM     75  HA  MET A   8      31.564  94.090  -6.951  1.00  0.00           H  
ATOM     76  HB2 MET A   8      32.228  96.599  -8.471  1.00  0.00           H  
ATOM     77  HB3 MET A   8      31.252  95.328  -9.195  1.00  0.00           H  
ATOM     78  HG2 MET A   8      29.709  95.525  -7.235  1.00  0.00           H  
ATOM     79  HG3 MET A   8      30.627  96.946  -6.743  1.00  0.00           H  
ATOM     80  HE1 MET A   8      30.875  98.941  -7.806  1.00  0.00           H  
ATOM     81  HE2 MET A   8      29.906  99.637  -9.105  1.00  0.00           H  
ATOM     82  HE3 MET A   8      29.206  99.425  -7.500  1.00  0.00           H  
ATOM     83  N   ALA A   9      32.603  92.922  -9.000  1.00  0.00           N  
ATOM     84  CA  ALA A   9      33.356  92.046  -9.891  1.00  0.00           C  
ATOM     85  C   ALA A   9      32.636  91.865 -11.222  1.00  0.00           C  
ATOM     86  O   ALA A   9      31.406  91.866 -11.296  1.00  0.00           O  
ATOM     87  CB  ALA A   9      33.592  90.697  -9.228  1.00  0.00           C  
ATOM     88  H   ALA A   9      31.637  92.791  -8.906  1.00  0.00           H  
ATOM     89  HA  ALA A   9      34.319  92.503 -10.072  1.00  0.00           H  
ATOM     90  HB1 ALA A   9      34.474  90.749  -8.608  1.00  0.00           H  
ATOM     91  HB2 ALA A   9      32.736  90.441  -8.619  1.00  0.00           H  
ATOM     92  HB3 ALA A   9      33.730  89.942  -9.988  1.00  0.00           H  
ATOM     93  N   PRO A  10      33.416  91.709 -12.301  1.00  0.00           N  
ATOM     94  CA  PRO A  10      32.873  91.525 -13.651  1.00  0.00           C  
ATOM     95  C   PRO A  10      32.195  90.170 -13.823  1.00  0.00           C  
ATOM     96  O   PRO A  10      31.997  89.435 -12.854  1.00  0.00           O  
ATOM     97  CB  PRO A  10      34.110  91.620 -14.546  1.00  0.00           C  
ATOM     98  CG  PRO A  10      35.246  91.221 -13.668  1.00  0.00           C  
ATOM     99  CD  PRO A  10      34.888  91.697 -12.288  1.00  0.00           C  
ATOM    100  HA  PRO A  10      32.178  92.309 -13.909  1.00  0.00           H  
ATOM    101  HB2 PRO A  10      34.003  90.947 -15.386  1.00  0.00           H  
ATOM    102  HB3 PRO A  10      34.223  92.633 -14.903  1.00  0.00           H  
ATOM    103  HG2 PRO A  10      35.359  90.148 -13.678  1.00  0.00           H  
ATOM    104  HG3 PRO A  10      36.155  91.698 -14.005  1.00  0.00           H  
ATOM    105  HD2 PRO A  10      35.262  91.010 -11.543  1.00  0.00           H  
ATOM    106  HD3 PRO A  10      35.279  92.690 -12.117  1.00  0.00           H  
ATOM    107  N   LYS A  11      31.838  89.844 -15.061  1.00  0.00           N  
ATOM    108  CA  LYS A  11      31.184  88.577 -15.360  1.00  0.00           C  
ATOM    109  C   LYS A  11      32.210  87.499 -15.692  1.00  0.00           C  
ATOM    110  O   LYS A  11      32.120  86.841 -16.730  1.00  0.00           O  
ATOM    111  CB  LYS A  11      30.211  88.747 -16.530  1.00  0.00           C  
ATOM    112  CG  LYS A  11      29.015  89.625 -16.204  1.00  0.00           C  
ATOM    113  CD  LYS A  11      29.339  91.098 -16.386  1.00  0.00           C  
ATOM    114  CE  LYS A  11      28.270  91.985 -15.767  1.00  0.00           C  
ATOM    115  NZ  LYS A  11      28.663  93.421 -15.783  1.00  0.00           N  
ATOM    116  H   LYS A  11      32.023  90.472 -15.791  1.00  0.00           H  
ATOM    117  HA  LYS A  11      30.631  88.273 -14.485  1.00  0.00           H  
ATOM    118  HB2 LYS A  11      30.739  89.189 -17.361  1.00  0.00           H  
ATOM    119  HB3 LYS A  11      29.846  87.772 -16.824  1.00  0.00           H  
ATOM    120  HG2 LYS A  11      28.198  89.363 -16.859  1.00  0.00           H  
ATOM    121  HG3 LYS A  11      28.724  89.454 -15.177  1.00  0.00           H  
ATOM    122  HD2 LYS A  11      30.286  91.311 -15.912  1.00  0.00           H  
ATOM    123  HD3 LYS A  11      29.407  91.315 -17.443  1.00  0.00           H  
ATOM    124  HE2 LYS A  11      27.354  91.865 -16.324  1.00  0.00           H  
ATOM    125  HE3 LYS A  11      28.112  91.676 -14.745  1.00  0.00           H  
ATOM    126  HZ1 LYS A  11      28.494  93.827 -16.726  1.00  0.00           H  
ATOM    127  HZ2 LYS A  11      29.672  93.518 -15.552  1.00  0.00           H  
ATOM    128  HZ3 LYS A  11      28.106  93.952 -15.083  1.00  0.00           H  
ATOM    129  N   GLN A  12      33.184  87.322 -14.805  1.00  0.00           N  
ATOM    130  CA  GLN A  12      34.226  86.323 -15.005  1.00  0.00           C  
ATOM    131  C   GLN A  12      34.023  85.131 -14.076  1.00  0.00           C  
ATOM    132  O   GLN A  12      33.250  85.200 -13.121  1.00  0.00           O  
ATOM    133  CB  GLN A  12      35.606  86.939 -14.767  1.00  0.00           C  
ATOM    134  CG  GLN A  12      36.756  86.036 -15.181  1.00  0.00           C  
ATOM    135  CD  GLN A  12      38.060  86.790 -15.346  1.00  0.00           C  
ATOM    136  OE1 GLN A  12      39.029  86.545 -14.626  1.00  0.00           O  
ATOM    137  NE2 GLN A  12      38.094  87.714 -16.300  1.00  0.00           N  
ATOM    138  H   GLN A  12      33.202  87.878 -13.998  1.00  0.00           H  
ATOM    139  HA  GLN A  12      34.166  85.981 -16.028  1.00  0.00           H  
ATOM    140  HB2 GLN A  12      35.678  87.858 -15.329  1.00  0.00           H  
ATOM    141  HB3 GLN A  12      35.712  87.161 -13.715  1.00  0.00           H  
ATOM    142  HG2 GLN A  12      36.892  85.276 -14.424  1.00  0.00           H  
ATOM    143  HG3 GLN A  12      36.507  85.565 -16.120  1.00  0.00           H  
ATOM    144 HE21 GLN A  12      37.284  87.854 -16.835  1.00  0.00           H  
ATOM    145 HE22 GLN A  12      38.923  88.216 -16.429  1.00  0.00           H  
ATOM    146  N   ASP A  13      34.721  84.037 -14.363  1.00  0.00           N  
ATOM    147  CA  ASP A  13      34.616  82.829 -13.553  1.00  0.00           C  
ATOM    148  C   ASP A  13      34.518  83.175 -12.071  1.00  0.00           C  
ATOM    149  O   ASP A  13      35.059  84.179 -11.606  1.00  0.00           O  
ATOM    150  CB  ASP A  13      35.822  81.920 -13.798  1.00  0.00           C  
ATOM    151  CG  ASP A  13      37.077  82.700 -14.134  1.00  0.00           C  
ATOM    152  OD1 ASP A  13      37.559  83.452 -13.261  1.00  0.00           O  
ATOM    153  OD2 ASP A  13      37.577  82.560 -15.270  1.00  0.00           O  
ATOM    154  H   ASP A  13      35.321  84.043 -15.138  1.00  0.00           H  
ATOM    155  HA  ASP A  13      33.718  82.307 -13.848  1.00  0.00           H  
ATOM    156  HB2 ASP A  13      36.010  81.335 -12.909  1.00  0.00           H  
ATOM    157  HB3 ASP A  13      35.602  81.256 -14.621  1.00  0.00           H  
ATOM    158  N   PRO A  14      33.811  82.327 -11.310  1.00  0.00           N  
ATOM    159  CA  PRO A  14      33.624  82.523  -9.869  1.00  0.00           C  
ATOM    160  C   PRO A  14      34.913  82.307  -9.083  1.00  0.00           C  
ATOM    161  O   PRO A  14      35.866  81.708  -9.584  1.00  0.00           O  
ATOM    162  CB  PRO A  14      32.587  81.460  -9.498  1.00  0.00           C  
ATOM    163  CG  PRO A  14      32.745  80.400 -10.533  1.00  0.00           C  
ATOM    164  CD  PRO A  14      33.138  81.111 -11.798  1.00  0.00           C  
ATOM    165  HA  PRO A  14      33.231  83.505  -9.650  1.00  0.00           H  
ATOM    166  HB2 PRO A  14      32.796  81.081  -8.508  1.00  0.00           H  
ATOM    167  HB3 PRO A  14      31.598  81.893  -9.523  1.00  0.00           H  
ATOM    168  HG2 PRO A  14      33.517  79.708 -10.235  1.00  0.00           H  
ATOM    169  HG3 PRO A  14      31.807  79.881 -10.672  1.00  0.00           H  
ATOM    170  HD2 PRO A  14      33.816  80.502 -12.378  1.00  0.00           H  
ATOM    171  HD3 PRO A  14      32.263  81.361 -12.378  1.00  0.00           H  
ATOM    172  N   LYS A  15      34.937  82.798  -7.849  1.00  0.00           N  
ATOM    173  CA  LYS A  15      36.108  82.658  -6.992  1.00  0.00           C  
ATOM    174  C   LYS A  15      35.907  81.539  -5.976  1.00  0.00           C  
ATOM    175  O   LYS A  15      34.833  81.379  -5.395  1.00  0.00           O  
ATOM    176  CB  LYS A  15      36.396  83.975  -6.267  1.00  0.00           C  
ATOM    177  CG  LYS A  15      37.834  84.109  -5.797  1.00  0.00           C  
ATOM    178  CD  LYS A  15      38.081  85.454  -5.136  1.00  0.00           C  
ATOM    179  CE  LYS A  15      39.533  85.607  -4.707  1.00  0.00           C  
ATOM    180  NZ  LYS A  15      40.395  86.071  -5.829  1.00  0.00           N  
ATOM    181  H   LYS A  15      34.146  83.266  -7.506  1.00  0.00           H  
ATOM    182  HA  LYS A  15      36.951  82.411  -7.620  1.00  0.00           H  
ATOM    183  HB2 LYS A  15      36.179  84.795  -6.935  1.00  0.00           H  
ATOM    184  HB3 LYS A  15      35.749  84.045  -5.403  1.00  0.00           H  
ATOM    185  HG2 LYS A  15      38.045  83.326  -5.084  1.00  0.00           H  
ATOM    186  HG3 LYS A  15      38.492  84.011  -6.649  1.00  0.00           H  
ATOM    187  HD2 LYS A  15      37.841  86.240  -5.837  1.00  0.00           H  
ATOM    188  HD3 LYS A  15      37.447  85.540  -4.265  1.00  0.00           H  
ATOM    189  HE2 LYS A  15      39.584  86.326  -3.904  1.00  0.00           H  
ATOM    190  HE3 LYS A  15      39.894  84.651  -4.358  1.00  0.00           H  
ATOM    191  HZ1 LYS A  15      40.109  85.610  -6.715  1.00  0.00           H  
ATOM    192  HZ2 LYS A  15      41.391  85.836  -5.633  1.00  0.00           H  
ATOM    193  HZ3 LYS A  15      40.311  87.101  -5.942  1.00  0.00           H  
ATOM    194  N   PRO A  16      36.966  80.744  -5.751  1.00  0.00           N  
ATOM    195  CA  PRO A  16      36.930  79.627  -4.803  1.00  0.00           C  
ATOM    196  C   PRO A  16      36.853  80.099  -3.355  1.00  0.00           C  
ATOM    197  O   PRO A  16      37.107  81.267  -3.057  1.00  0.00           O  
ATOM    198  CB  PRO A  16      38.253  78.901  -5.060  1.00  0.00           C  
ATOM    199  CG  PRO A  16      39.156  79.947  -5.617  1.00  0.00           C  
ATOM    200  CD  PRO A  16      38.277  80.876  -6.407  1.00  0.00           C  
ATOM    201  HA  PRO A  16      36.105  78.961  -5.006  1.00  0.00           H  
ATOM    202  HB2 PRO A  16      38.634  78.504  -4.130  1.00  0.00           H  
ATOM    203  HB3 PRO A  16      38.096  78.099  -5.765  1.00  0.00           H  
ATOM    204  HG2 PRO A  16      39.640  80.481  -4.812  1.00  0.00           H  
ATOM    205  HG3 PRO A  16      39.893  79.490  -6.261  1.00  0.00           H  
ATOM    206  HD2 PRO A  16      38.642  81.891  -6.339  1.00  0.00           H  
ATOM    207  HD3 PRO A  16      38.225  80.560  -7.438  1.00  0.00           H  
ATOM    208  N   LYS A  17      36.503  79.185  -2.456  1.00  0.00           N  
ATOM    209  CA  LYS A  17      36.396  79.506  -1.039  1.00  0.00           C  
ATOM    210  C   LYS A  17      37.609  78.993  -0.271  1.00  0.00           C  
ATOM    211  O   LYS A  17      38.130  79.672   0.613  1.00  0.00           O  
ATOM    212  CB  LYS A  17      35.116  78.903  -0.454  1.00  0.00           C  
ATOM    213  CG  LYS A  17      33.846  79.417  -1.110  1.00  0.00           C  
ATOM    214  CD  LYS A  17      32.616  78.693  -0.589  1.00  0.00           C  
ATOM    215  CE  LYS A  17      31.385  79.583  -0.634  1.00  0.00           C  
ATOM    216  NZ  LYS A  17      30.126  78.787  -0.687  1.00  0.00           N  
ATOM    217  H   LYS A  17      36.313  78.270  -2.756  1.00  0.00           H  
ATOM    218  HA  LYS A  17      36.353  80.581  -0.944  1.00  0.00           H  
ATOM    219  HB2 LYS A  17      35.150  77.830  -0.574  1.00  0.00           H  
ATOM    220  HB3 LYS A  17      35.072  79.137   0.600  1.00  0.00           H  
ATOM    221  HG2 LYS A  17      33.746  80.471  -0.901  1.00  0.00           H  
ATOM    222  HG3 LYS A  17      33.916  79.265  -2.178  1.00  0.00           H  
ATOM    223  HD2 LYS A  17      32.439  77.819  -1.198  1.00  0.00           H  
ATOM    224  HD3 LYS A  17      32.795  78.390   0.433  1.00  0.00           H  
ATOM    225  HE2 LYS A  17      31.371  80.203   0.249  1.00  0.00           H  
ATOM    226  HE3 LYS A  17      31.441  80.208  -1.513  1.00  0.00           H  
ATOM    227  HZ1 LYS A  17      30.336  77.778  -0.550  1.00  0.00           H  
ATOM    228  HZ2 LYS A  17      29.663  78.912  -1.609  1.00  0.00           H  
ATOM    229  HZ3 LYS A  17      29.474  79.099   0.061  1.00  0.00           H  
ATOM    230  N   PHE A  18      38.056  77.789  -0.615  1.00  0.00           N  
ATOM    231  CA  PHE A  18      39.209  77.185   0.042  1.00  0.00           C  
ATOM    232  C   PHE A  18      40.506  77.603  -0.643  1.00  0.00           C  
ATOM    233  O   PHE A  18      40.503  78.001  -1.808  1.00  0.00           O  
ATOM    234  CB  PHE A  18      39.084  75.660   0.037  1.00  0.00           C  
ATOM    235  CG  PHE A  18      37.728  75.168   0.456  1.00  0.00           C  
ATOM    236  CD1 PHE A  18      36.718  75.003  -0.477  1.00  0.00           C  
ATOM    237  CD2 PHE A  18      37.465  74.870   1.783  1.00  0.00           C  
ATOM    238  CE1 PHE A  18      35.469  74.551  -0.095  1.00  0.00           C  
ATOM    239  CE2 PHE A  18      36.218  74.416   2.172  1.00  0.00           C  
ATOM    240  CZ  PHE A  18      35.219  74.256   1.231  1.00  0.00           C  
ATOM    241  H   PHE A  18      37.598  77.295  -1.327  1.00  0.00           H  
ATOM    242  HA  PHE A  18      39.227  77.533   1.064  1.00  0.00           H  
ATOM    243  HB2 PHE A  18      39.276  75.293  -0.960  1.00  0.00           H  
ATOM    244  HB3 PHE A  18      39.814  75.244   0.716  1.00  0.00           H  
ATOM    245  HD1 PHE A  18      36.912  75.232  -1.515  1.00  0.00           H  
ATOM    246  HD2 PHE A  18      38.245  74.994   2.520  1.00  0.00           H  
ATOM    247  HE1 PHE A  18      34.691  74.426  -0.832  1.00  0.00           H  
ATOM    248  HE2 PHE A  18      36.026  74.188   3.209  1.00  0.00           H  
ATOM    249  HZ  PHE A  18      34.245  73.903   1.533  1.00  0.00           H  
ATOM    250  N   GLN A  19      41.612  77.509   0.089  1.00  0.00           N  
ATOM    251  CA  GLN A  19      42.916  77.879  -0.448  1.00  0.00           C  
ATOM    252  C   GLN A  19      43.867  76.686  -0.439  1.00  0.00           C  
ATOM    253  O   GLN A  19      43.703  75.758   0.351  1.00  0.00           O  
ATOM    254  CB  GLN A  19      43.516  79.031   0.359  1.00  0.00           C  
ATOM    255  CG  GLN A  19      42.847  80.370   0.098  1.00  0.00           C  
ATOM    256  CD  GLN A  19      43.022  81.345   1.247  1.00  0.00           C  
ATOM    257  OE1 GLN A  19      44.143  81.630   1.667  1.00  0.00           O  
ATOM    258  NE2 GLN A  19      41.911  81.859   1.761  1.00  0.00           N  
ATOM    259  H   GLN A  19      41.549  77.185   1.011  1.00  0.00           H  
ATOM    260  HA  GLN A  19      42.775  78.203  -1.469  1.00  0.00           H  
ATOM    261  HB2 GLN A  19      43.422  78.805   1.411  1.00  0.00           H  
ATOM    262  HB3 GLN A  19      44.563  79.122   0.112  1.00  0.00           H  
ATOM    263  HG2 GLN A  19      43.278  80.806  -0.791  1.00  0.00           H  
ATOM    264  HG3 GLN A  19      41.791  80.206  -0.058  1.00  0.00           H  
ATOM    265 HE21 GLN A  19      41.053  81.585   1.376  1.00  0.00           H  
ATOM    266 HE22 GLN A  19      41.995  82.490   2.505  1.00  0.00           H  
ATOM    267  N   GLU A  20      44.859  76.719  -1.323  1.00  0.00           N  
ATOM    268  CA  GLU A  20      45.835  75.640  -1.416  1.00  0.00           C  
ATOM    269  C   GLU A  20      46.660  75.540  -0.136  1.00  0.00           C  
ATOM    270  O   GLU A  20      47.119  76.548   0.399  1.00  0.00           O  
ATOM    271  CB  GLU A  20      46.759  75.860  -2.616  1.00  0.00           C  
ATOM    272  CG  GLU A  20      46.026  75.925  -3.945  1.00  0.00           C  
ATOM    273  CD  GLU A  20      46.729  76.808  -4.957  1.00  0.00           C  
ATOM    274  OE1 GLU A  20      47.977  76.776  -5.007  1.00  0.00           O  
ATOM    275  OE2 GLU A  20      46.032  77.531  -5.699  1.00  0.00           O  
ATOM    276  H   GLU A  20      44.937  77.488  -1.926  1.00  0.00           H  
ATOM    277  HA  GLU A  20      45.294  74.716  -1.554  1.00  0.00           H  
ATOM    278  HB2 GLU A  20      47.295  76.787  -2.477  1.00  0.00           H  
ATOM    279  HB3 GLU A  20      47.469  75.048  -2.661  1.00  0.00           H  
ATOM    280  HG2 GLU A  20      45.952  74.927  -4.351  1.00  0.00           H  
ATOM    281  HG3 GLU A  20      45.033  76.318  -3.776  1.00  0.00           H  
ATOM    282  N   GLY A  21      46.843  74.316   0.350  1.00  0.00           N  
ATOM    283  CA  GLY A  21      47.611  74.106   1.563  1.00  0.00           C  
ATOM    284  C   GLY A  21      46.730  73.952   2.787  1.00  0.00           C  
ATOM    285  O   GLY A  21      47.128  73.327   3.769  1.00  0.00           O  
ATOM    286  H   GLY A  21      46.452  73.549  -0.120  1.00  0.00           H  
ATOM    287  HA2 GLY A  21      48.209  73.215   1.447  1.00  0.00           H  
ATOM    288  HA3 GLY A  21      48.267  74.951   1.710  1.00  0.00           H  
ATOM    289  N   GLU A  22      45.532  74.525   2.728  1.00  0.00           N  
ATOM    290  CA  GLU A  22      44.595  74.449   3.844  1.00  0.00           C  
ATOM    291  C   GLU A  22      44.002  73.048   3.961  1.00  0.00           C  
ATOM    292  O   GLU A  22      43.595  72.449   2.965  1.00  0.00           O  
ATOM    293  CB  GLU A  22      43.475  75.476   3.668  1.00  0.00           C  
ATOM    294  CG  GLU A  22      42.560  75.591   4.875  1.00  0.00           C  
ATOM    295  CD  GLU A  22      43.185  76.384   6.007  1.00  0.00           C  
ATOM    296  OE1 GLU A  22      44.335  76.077   6.382  1.00  0.00           O  
ATOM    297  OE2 GLU A  22      42.521  77.312   6.517  1.00  0.00           O  
ATOM    298  H   GLU A  22      45.273  75.009   1.918  1.00  0.00           H  
ATOM    299  HA  GLU A  22      45.138  74.673   4.749  1.00  0.00           H  
ATOM    300  HB2 GLU A  22      43.917  76.444   3.483  1.00  0.00           H  
ATOM    301  HB3 GLU A  22      42.877  75.194   2.814  1.00  0.00           H  
ATOM    302  HG2 GLU A  22      41.647  76.082   4.574  1.00  0.00           H  
ATOM    303  HG3 GLU A  22      42.331  74.598   5.234  1.00  0.00           H  
ATOM    304  N   ARG A  23      43.955  72.532   5.185  1.00  0.00           N  
ATOM    305  CA  ARG A  23      43.414  71.201   5.433  1.00  0.00           C  
ATOM    306  C   ARG A  23      41.898  71.189   5.258  1.00  0.00           C  
ATOM    307  O   ARG A  23      41.187  71.994   5.860  1.00  0.00           O  
ATOM    308  CB  ARG A  23      43.779  70.734   6.843  1.00  0.00           C  
ATOM    309  CG  ARG A  23      43.467  69.268   7.099  1.00  0.00           C  
ATOM    310  CD  ARG A  23      43.903  68.840   8.491  1.00  0.00           C  
ATOM    311  NE  ARG A  23      45.273  68.334   8.505  1.00  0.00           N  
ATOM    312  CZ  ARG A  23      46.042  68.324   9.587  1.00  0.00           C  
ATOM    313  NH1 ARG A  23      45.578  68.790  10.739  1.00  0.00           N  
ATOM    314  NH2 ARG A  23      47.279  67.846   9.520  1.00  0.00           N  
ATOM    315  H   ARG A  23      44.295  73.058   5.938  1.00  0.00           H  
ATOM    316  HA  ARG A  23      43.852  70.525   4.715  1.00  0.00           H  
ATOM    317  HB2 ARG A  23      44.836  70.887   6.998  1.00  0.00           H  
ATOM    318  HB3 ARG A  23      43.228  71.325   7.559  1.00  0.00           H  
ATOM    319  HG2 ARG A  23      42.403  69.114   7.003  1.00  0.00           H  
ATOM    320  HG3 ARG A  23      43.987  68.667   6.368  1.00  0.00           H  
ATOM    321  HD2 ARG A  23      43.839  69.692   9.152  1.00  0.00           H  
ATOM    322  HD3 ARG A  23      43.238  68.064   8.839  1.00  0.00           H  
ATOM    323  HE  ARG A  23      45.636  67.984   7.665  1.00  0.00           H  
ATOM    324 HH11 ARG A  23      44.647  69.150  10.792  1.00  0.00           H  
ATOM    325 HH12 ARG A  23      46.159  68.781  11.553  1.00  0.00           H  
ATOM    326 HH21 ARG A  23      47.631  67.493   8.654  1.00  0.00           H  
ATOM    327 HH22 ARG A  23      47.856  67.838  10.335  1.00  0.00           H  
ATOM    328  N   VAL A  24      41.410  70.272   4.429  1.00  0.00           N  
ATOM    329  CA  VAL A  24      39.979  70.156   4.174  1.00  0.00           C  
ATOM    330  C   VAL A  24      39.545  68.695   4.136  1.00  0.00           C  
ATOM    331  O   VAL A  24      40.379  67.789   4.080  1.00  0.00           O  
ATOM    332  CB  VAL A  24      39.588  70.832   2.847  1.00  0.00           C  
ATOM    333  CG1 VAL A  24      39.881  72.323   2.900  1.00  0.00           C  
ATOM    334  CG2 VAL A  24      40.316  70.178   1.683  1.00  0.00           C  
ATOM    335  H   VAL A  24      42.027  69.659   3.977  1.00  0.00           H  
ATOM    336  HA  VAL A  24      39.456  70.657   4.976  1.00  0.00           H  
ATOM    337  HB  VAL A  24      38.527  70.701   2.699  1.00  0.00           H  
ATOM    338 HG11 VAL A  24      40.649  72.565   2.180  1.00  0.00           H  
ATOM    339 HG12 VAL A  24      38.982  72.875   2.669  1.00  0.00           H  
ATOM    340 HG13 VAL A  24      40.221  72.588   3.890  1.00  0.00           H  
ATOM    341 HG21 VAL A  24      41.373  70.386   1.756  1.00  0.00           H  
ATOM    342 HG22 VAL A  24      40.156  69.111   1.711  1.00  0.00           H  
ATOM    343 HG23 VAL A  24      39.936  70.574   0.751  1.00  0.00           H  
ATOM    344  N   LEU A  25      38.235  68.472   4.165  1.00  0.00           N  
ATOM    345  CA  LEU A  25      37.689  67.119   4.133  1.00  0.00           C  
ATOM    346  C   LEU A  25      37.031  66.830   2.788  1.00  0.00           C  
ATOM    347  O   LEU A  25      36.066  67.492   2.404  1.00  0.00           O  
ATOM    348  CB  LEU A  25      36.675  66.932   5.261  1.00  0.00           C  
ATOM    349  CG  LEU A  25      37.216  67.080   6.683  1.00  0.00           C  
ATOM    350  CD1 LEU A  25      36.075  67.120   7.689  1.00  0.00           C  
ATOM    351  CD2 LEU A  25      38.177  65.944   7.009  1.00  0.00           C  
ATOM    352  H   LEU A  25      37.621  69.233   4.210  1.00  0.00           H  
ATOM    353  HA  LEU A  25      38.507  66.429   4.276  1.00  0.00           H  
ATOM    354  HB2 LEU A  25      35.892  67.663   5.128  1.00  0.00           H  
ATOM    355  HB3 LEU A  25      36.256  65.939   5.167  1.00  0.00           H  
ATOM    356  HG  LEU A  25      37.760  68.011   6.759  1.00  0.00           H  
ATOM    357 HD11 LEU A  25      35.720  68.134   7.788  1.00  0.00           H  
ATOM    358 HD12 LEU A  25      36.427  66.765   8.646  1.00  0.00           H  
ATOM    359 HD13 LEU A  25      35.270  66.487   7.344  1.00  0.00           H  
ATOM    360 HD21 LEU A  25      37.665  65.000   6.907  1.00  0.00           H  
ATOM    361 HD22 LEU A  25      38.532  66.054   8.023  1.00  0.00           H  
ATOM    362 HD23 LEU A  25      39.015  65.976   6.328  1.00  0.00           H  
ATOM    363  N   CYS A  26      37.557  65.838   2.078  1.00  0.00           N  
ATOM    364  CA  CYS A  26      37.020  65.461   0.776  1.00  0.00           C  
ATOM    365  C   CYS A  26      36.025  64.313   0.911  1.00  0.00           C  
ATOM    366  O   CYS A  26      36.041  63.577   1.898  1.00  0.00           O  
ATOM    367  CB  CYS A  26      38.153  65.061  -0.170  1.00  0.00           C  
ATOM    368  SG  CYS A  26      37.612  64.688  -1.854  1.00  0.00           S  
ATOM    369  H   CYS A  26      38.326  65.349   2.438  1.00  0.00           H  
ATOM    370  HA  CYS A  26      36.507  66.319   0.368  1.00  0.00           H  
ATOM    371  HB2 CYS A  26      38.867  65.869  -0.227  1.00  0.00           H  
ATOM    372  HB3 CYS A  26      38.644  64.183   0.221  1.00  0.00           H  
ATOM    373  HG  CYS A  26      37.335  63.395  -1.918  1.00  0.00           H  
ATOM    374  N   PHE A  27      35.159  64.167  -0.085  1.00  0.00           N  
ATOM    375  CA  PHE A  27      34.154  63.110  -0.077  1.00  0.00           C  
ATOM    376  C   PHE A  27      34.492  62.030  -1.101  1.00  0.00           C  
ATOM    377  O   PHE A  27      34.266  62.201  -2.298  1.00  0.00           O  
ATOM    378  CB  PHE A  27      32.770  63.691  -0.371  1.00  0.00           C  
ATOM    379  CG  PHE A  27      32.025  64.119   0.861  1.00  0.00           C  
ATOM    380  CD1 PHE A  27      31.624  63.186   1.803  1.00  0.00           C  
ATOM    381  CD2 PHE A  27      31.726  65.455   1.077  1.00  0.00           C  
ATOM    382  CE1 PHE A  27      30.939  63.577   2.939  1.00  0.00           C  
ATOM    383  CE2 PHE A  27      31.043  65.852   2.210  1.00  0.00           C  
ATOM    384  CZ  PHE A  27      30.648  64.912   3.142  1.00  0.00           C  
ATOM    385  H   PHE A  27      35.195  64.785  -0.846  1.00  0.00           H  
ATOM    386  HA  PHE A  27      34.148  62.667   0.907  1.00  0.00           H  
ATOM    387  HB2 PHE A  27      32.878  64.555  -1.010  1.00  0.00           H  
ATOM    388  HB3 PHE A  27      32.174  62.946  -0.877  1.00  0.00           H  
ATOM    389  HD1 PHE A  27      31.852  62.142   1.646  1.00  0.00           H  
ATOM    390  HD2 PHE A  27      32.034  66.191   0.348  1.00  0.00           H  
ATOM    391  HE1 PHE A  27      30.632  62.839   3.666  1.00  0.00           H  
ATOM    392  HE2 PHE A  27      30.815  66.896   2.366  1.00  0.00           H  
ATOM    393  HZ  PHE A  27      30.114  65.220   4.028  1.00  0.00           H  
ATOM    394  N   HIS A  28      35.037  60.917  -0.619  1.00  0.00           N  
ATOM    395  CA  HIS A  28      35.406  59.807  -1.491  1.00  0.00           C  
ATOM    396  C   HIS A  28      34.504  58.602  -1.249  1.00  0.00           C  
ATOM    397  O   HIS A  28      34.942  57.456  -1.349  1.00  0.00           O  
ATOM    398  CB  HIS A  28      36.868  59.420  -1.266  1.00  0.00           C  
ATOM    399  CG  HIS A  28      37.365  58.376  -2.219  1.00  0.00           C  
ATOM    400  ND1 HIS A  28      37.879  57.164  -1.808  1.00  0.00           N  
ATOM    401  CD2 HIS A  28      37.423  58.368  -3.570  1.00  0.00           C  
ATOM    402  CE1 HIS A  28      38.232  56.458  -2.865  1.00  0.00           C  
ATOM    403  NE2 HIS A  28      37.967  57.164  -3.948  1.00  0.00           N  
ATOM    404  H   HIS A  28      35.193  60.839   0.345  1.00  0.00           H  
ATOM    405  HA  HIS A  28      35.284  60.134  -2.512  1.00  0.00           H  
ATOM    406  HB2 HIS A  28      37.489  60.296  -1.382  1.00  0.00           H  
ATOM    407  HB3 HIS A  28      36.981  59.034  -0.262  1.00  0.00           H  
ATOM    408  HD1 HIS A  28      37.972  56.869  -0.879  1.00  0.00           H  
ATOM    409  HD2 HIS A  28      37.103  59.161  -4.232  1.00  0.00           H  
ATOM    410  HE1 HIS A  28      38.666  55.468  -2.849  1.00  0.00           H  
ATOM    411  HE2 HIS A  28      38.209  56.911  -4.862  1.00  0.00           H  
ATOM    412  N   GLY A  29      33.242  58.868  -0.927  1.00  0.00           N  
ATOM    413  CA  GLY A  29      32.299  57.794  -0.674  1.00  0.00           C  
ATOM    414  C   GLY A  29      31.448  58.048   0.553  1.00  0.00           C  
ATOM    415  O   GLY A  29      31.256  59.187   0.978  1.00  0.00           O  
ATOM    416  H   GLY A  29      32.949  59.801  -0.861  1.00  0.00           H  
ATOM    417  HA2 GLY A  29      31.653  57.687  -1.532  1.00  0.00           H  
ATOM    418  HA3 GLY A  29      32.847  56.874  -0.534  1.00  0.00           H  
ATOM    419  N   PRO A  30      30.918  56.967   1.145  1.00  0.00           N  
ATOM    420  CA  PRO A  30      30.072  57.052   2.340  1.00  0.00           C  
ATOM    421  C   PRO A  30      30.859  57.466   3.578  1.00  0.00           C  
ATOM    422  O   PRO A  30      30.312  57.532   4.680  1.00  0.00           O  
ATOM    423  CB  PRO A  30      29.536  55.627   2.497  1.00  0.00           C  
ATOM    424  CG  PRO A  30      30.551  54.764   1.832  1.00  0.00           C  
ATOM    425  CD  PRO A  30      31.104  55.578   0.694  1.00  0.00           C  
ATOM    426  HA  PRO A  30      29.248  57.734   2.194  1.00  0.00           H  
ATOM    427  HB2 PRO A  30      29.442  55.389   3.548  1.00  0.00           H  
ATOM    428  HB3 PRO A  30      28.573  55.545   2.016  1.00  0.00           H  
ATOM    429  HG2 PRO A  30      31.337  54.515   2.530  1.00  0.00           H  
ATOM    430  HG3 PRO A  30      30.082  53.867   1.457  1.00  0.00           H  
ATOM    431  HD2 PRO A  30      32.151  55.357   0.546  1.00  0.00           H  
ATOM    432  HD3 PRO A  30      30.545  55.389  -0.211  1.00  0.00           H  
ATOM    433  N   LEU A  31      32.145  57.742   3.392  1.00  0.00           N  
ATOM    434  CA  LEU A  31      33.008  58.150   4.495  1.00  0.00           C  
ATOM    435  C   LEU A  31      33.928  59.291   4.074  1.00  0.00           C  
ATOM    436  O   LEU A  31      34.347  59.371   2.918  1.00  0.00           O  
ATOM    437  CB  LEU A  31      33.838  56.963   4.985  1.00  0.00           C  
ATOM    438  CG  LEU A  31      33.051  55.770   5.527  1.00  0.00           C  
ATOM    439  CD1 LEU A  31      33.825  54.478   5.316  1.00  0.00           C  
ATOM    440  CD2 LEU A  31      32.735  55.968   7.003  1.00  0.00           C  
ATOM    441  H   LEU A  31      32.524  57.671   2.491  1.00  0.00           H  
ATOM    442  HA  LEU A  31      32.375  58.493   5.301  1.00  0.00           H  
ATOM    443  HB2 LEU A  31      34.437  56.615   4.156  1.00  0.00           H  
ATOM    444  HB3 LEU A  31      34.490  57.317   5.771  1.00  0.00           H  
ATOM    445  HG  LEU A  31      32.115  55.691   4.991  1.00  0.00           H  
ATOM    446 HD11 LEU A  31      33.134  53.675   5.111  1.00  0.00           H  
ATOM    447 HD12 LEU A  31      34.392  54.248   6.204  1.00  0.00           H  
ATOM    448 HD13 LEU A  31      34.498  54.596   4.479  1.00  0.00           H  
ATOM    449 HD21 LEU A  31      32.937  55.053   7.540  1.00  0.00           H  
ATOM    450 HD22 LEU A  31      31.693  56.229   7.115  1.00  0.00           H  
ATOM    451 HD23 LEU A  31      33.349  56.763   7.400  1.00  0.00           H  
ATOM    452  N   LEU A  32      34.240  60.171   5.018  1.00  0.00           N  
ATOM    453  CA  LEU A  32      35.113  61.308   4.745  1.00  0.00           C  
ATOM    454  C   LEU A  32      36.575  60.941   4.987  1.00  0.00           C  
ATOM    455  O   LEU A  32      36.888  60.143   5.870  1.00  0.00           O  
ATOM    456  CB  LEU A  32      34.723  62.499   5.623  1.00  0.00           C  
ATOM    457  CG  LEU A  32      33.604  63.391   5.084  1.00  0.00           C  
ATOM    458  CD1 LEU A  32      33.146  64.374   6.149  1.00  0.00           C  
ATOM    459  CD2 LEU A  32      34.066  64.130   3.836  1.00  0.00           C  
ATOM    460  H   LEU A  32      33.875  60.056   5.920  1.00  0.00           H  
ATOM    461  HA  LEU A  32      34.990  61.579   3.708  1.00  0.00           H  
ATOM    462  HB2 LEU A  32      34.407  62.115   6.580  1.00  0.00           H  
ATOM    463  HB3 LEU A  32      35.602  63.112   5.756  1.00  0.00           H  
ATOM    464  HG  LEU A  32      32.758  62.774   4.815  1.00  0.00           H  
ATOM    465 HD11 LEU A  32      32.404  65.038   5.732  1.00  0.00           H  
ATOM    466 HD12 LEU A  32      33.992  64.953   6.493  1.00  0.00           H  
ATOM    467 HD13 LEU A  32      32.720  63.833   6.980  1.00  0.00           H  
ATOM    468 HD21 LEU A  32      34.016  63.465   2.986  1.00  0.00           H  
ATOM    469 HD22 LEU A  32      35.083  64.465   3.973  1.00  0.00           H  
ATOM    470 HD23 LEU A  32      33.426  64.983   3.666  1.00  0.00           H  
ATOM    471  N   TYR A  33      37.465  61.532   4.198  1.00  0.00           N  
ATOM    472  CA  TYR A  33      38.893  61.268   4.325  1.00  0.00           C  
ATOM    473  C   TYR A  33      39.681  62.571   4.434  1.00  0.00           C  
ATOM    474  O   TYR A  33      39.389  63.544   3.740  1.00  0.00           O  
ATOM    475  CB  TYR A  33      39.392  60.456   3.128  1.00  0.00           C  
ATOM    476  CG  TYR A  33      38.621  59.176   2.903  1.00  0.00           C  
ATOM    477  CD1 TYR A  33      37.358  59.195   2.324  1.00  0.00           C  
ATOM    478  CD2 TYR A  33      39.156  57.946   3.267  1.00  0.00           C  
ATOM    479  CE1 TYR A  33      36.650  58.026   2.117  1.00  0.00           C  
ATOM    480  CE2 TYR A  33      38.456  56.773   3.063  1.00  0.00           C  
ATOM    481  CZ  TYR A  33      37.203  56.818   2.487  1.00  0.00           C  
ATOM    482  OH  TYR A  33      36.501  55.652   2.281  1.00  0.00           O  
ATOM    483  H   TYR A  33      37.154  62.160   3.513  1.00  0.00           H  
ATOM    484  HA  TYR A  33      39.045  60.693   5.227  1.00  0.00           H  
ATOM    485  HB2 TYR A  33      39.308  61.055   2.235  1.00  0.00           H  
ATOM    486  HB3 TYR A  33      40.428  60.197   3.286  1.00  0.00           H  
ATOM    487  HD1 TYR A  33      36.927  60.142   2.035  1.00  0.00           H  
ATOM    488  HD2 TYR A  33      40.137  57.914   3.718  1.00  0.00           H  
ATOM    489  HE1 TYR A  33      35.669  58.061   1.666  1.00  0.00           H  
ATOM    490  HE2 TYR A  33      38.888  55.827   3.352  1.00  0.00           H  
ATOM    491  HH  TYR A  33      35.643  55.717   2.706  1.00  0.00           H  
ATOM    492  N   GLU A  34      40.681  62.579   5.310  1.00  0.00           N  
ATOM    493  CA  GLU A  34      41.511  63.762   5.509  1.00  0.00           C  
ATOM    494  C   GLU A  34      42.321  64.075   4.256  1.00  0.00           C  
ATOM    495  O   GLU A  34      42.977  63.199   3.692  1.00  0.00           O  
ATOM    496  CB  GLU A  34      42.449  63.557   6.700  1.00  0.00           C  
ATOM    497  CG  GLU A  34      43.403  64.718   6.929  1.00  0.00           C  
ATOM    498  CD  GLU A  34      44.488  64.391   7.937  1.00  0.00           C  
ATOM    499  OE1 GLU A  34      44.180  64.350   9.147  1.00  0.00           O  
ATOM    500  OE2 GLU A  34      45.644  64.177   7.516  1.00  0.00           O  
ATOM    501  H   GLU A  34      40.864  61.772   5.834  1.00  0.00           H  
ATOM    502  HA  GLU A  34      40.856  64.594   5.718  1.00  0.00           H  
ATOM    503  HB2 GLU A  34      41.856  63.424   7.593  1.00  0.00           H  
ATOM    504  HB3 GLU A  34      43.035  62.666   6.531  1.00  0.00           H  
ATOM    505  HG2 GLU A  34      43.871  64.973   5.991  1.00  0.00           H  
ATOM    506  HG3 GLU A  34      42.839  65.565   7.290  1.00  0.00           H  
ATOM    507  N   ALA A  35      42.270  65.331   3.824  1.00  0.00           N  
ATOM    508  CA  ALA A  35      43.001  65.761   2.639  1.00  0.00           C  
ATOM    509  C   ALA A  35      43.315  67.252   2.699  1.00  0.00           C  
ATOM    510  O   ALA A  35      42.837  67.964   3.582  1.00  0.00           O  
ATOM    511  CB  ALA A  35      42.206  65.438   1.383  1.00  0.00           C  
ATOM    512  H   ALA A  35      41.730  65.984   4.316  1.00  0.00           H  
ATOM    513  HA  ALA A  35      43.930  65.209   2.599  1.00  0.00           H  
ATOM    514  HB1 ALA A  35      41.515  66.242   1.177  1.00  0.00           H  
ATOM    515  HB2 ALA A  35      42.883  65.323   0.548  1.00  0.00           H  
ATOM    516  HB3 ALA A  35      41.658  64.520   1.530  1.00  0.00           H  
ATOM    517  N   LYS A  36      44.123  67.721   1.753  1.00  0.00           N  
ATOM    518  CA  LYS A  36      44.502  69.128   1.697  1.00  0.00           C  
ATOM    519  C   LYS A  36      44.338  69.679   0.284  1.00  0.00           C  
ATOM    520  O   LYS A  36      44.553  68.969  -0.699  1.00  0.00           O  
ATOM    521  CB  LYS A  36      45.949  69.306   2.161  1.00  0.00           C  
ATOM    522  CG  LYS A  36      46.513  70.688   1.876  1.00  0.00           C  
ATOM    523  CD  LYS A  36      47.178  70.748   0.511  1.00  0.00           C  
ATOM    524  CE  LYS A  36      48.606  70.225   0.564  1.00  0.00           C  
ATOM    525  NZ  LYS A  36      48.667  68.753   0.352  1.00  0.00           N  
ATOM    526  H   LYS A  36      44.472  67.104   1.075  1.00  0.00           H  
ATOM    527  HA  LYS A  36      43.849  69.674   2.361  1.00  0.00           H  
ATOM    528  HB2 LYS A  36      45.996  69.134   3.226  1.00  0.00           H  
ATOM    529  HB3 LYS A  36      46.568  68.578   1.658  1.00  0.00           H  
ATOM    530  HG2 LYS A  36      45.709  71.408   1.903  1.00  0.00           H  
ATOM    531  HG3 LYS A  36      47.243  70.932   2.633  1.00  0.00           H  
ATOM    532  HD2 LYS A  36      46.612  70.143  -0.183  1.00  0.00           H  
ATOM    533  HD3 LYS A  36      47.191  71.773   0.170  1.00  0.00           H  
ATOM    534  HE2 LYS A  36      49.183  70.716  -0.205  1.00  0.00           H  
ATOM    535  HE3 LYS A  36      49.025  70.459   1.531  1.00  0.00           H  
ATOM    536  HZ1 LYS A  36      49.006  68.281   1.214  1.00  0.00           H  
ATOM    537  HZ2 LYS A  36      49.316  68.531  -0.430  1.00  0.00           H  
ATOM    538  HZ3 LYS A  36      47.723  68.386   0.117  1.00  0.00           H  
ATOM    539  N   CYS A  37      43.957  70.949   0.191  1.00  0.00           N  
ATOM    540  CA  CYS A  37      43.765  71.595  -1.103  1.00  0.00           C  
ATOM    541  C   CYS A  37      45.088  71.718  -1.851  1.00  0.00           C  
ATOM    542  O   CYS A  37      45.898  72.600  -1.563  1.00  0.00           O  
ATOM    543  CB  CYS A  37      43.141  72.980  -0.916  1.00  0.00           C  
ATOM    544  SG  CYS A  37      42.417  73.672  -2.422  1.00  0.00           S  
ATOM    545  H   CYS A  37      43.801  71.463   1.009  1.00  0.00           H  
ATOM    546  HA  CYS A  37      43.093  70.982  -1.683  1.00  0.00           H  
ATOM    547  HB2 CYS A  37      42.357  72.915  -0.176  1.00  0.00           H  
ATOM    548  HB3 CYS A  37      43.900  73.665  -0.569  1.00  0.00           H  
ATOM    549  HG  CYS A  37      43.224  73.385  -3.432  1.00  0.00           H  
ATOM    550  N   VAL A  38      45.303  70.827  -2.813  1.00  0.00           N  
ATOM    551  CA  VAL A  38      46.529  70.834  -3.603  1.00  0.00           C  
ATOM    552  C   VAL A  38      46.493  71.930  -4.662  1.00  0.00           C  
ATOM    553  O   VAL A  38      47.464  72.664  -4.845  1.00  0.00           O  
ATOM    554  CB  VAL A  38      46.760  69.476  -4.292  1.00  0.00           C  
ATOM    555  CG1 VAL A  38      48.177  69.389  -4.837  1.00  0.00           C  
ATOM    556  CG2 VAL A  38      46.480  68.334  -3.327  1.00  0.00           C  
ATOM    557  H   VAL A  38      44.620  70.148  -2.997  1.00  0.00           H  
ATOM    558  HA  VAL A  38      47.356  71.021  -2.934  1.00  0.00           H  
ATOM    559  HB  VAL A  38      46.074  69.394  -5.122  1.00  0.00           H  
ATOM    560 HG11 VAL A  38      48.342  68.407  -5.256  1.00  0.00           H  
ATOM    561 HG12 VAL A  38      48.315  70.136  -5.605  1.00  0.00           H  
ATOM    562 HG13 VAL A  38      48.882  69.561  -4.036  1.00  0.00           H  
ATOM    563 HG21 VAL A  38      47.379  68.097  -2.779  1.00  0.00           H  
ATOM    564 HG22 VAL A  38      45.705  68.630  -2.636  1.00  0.00           H  
ATOM    565 HG23 VAL A  38      46.156  67.466  -3.881  1.00  0.00           H  
ATOM    566  N   LYS A  39      45.366  72.035  -5.359  1.00  0.00           N  
ATOM    567  CA  LYS A  39      45.201  73.043  -6.399  1.00  0.00           C  
ATOM    568  C   LYS A  39      43.752  73.513  -6.478  1.00  0.00           C  
ATOM    569  O   LYS A  39      42.860  72.911  -5.878  1.00  0.00           O  
ATOM    570  CB  LYS A  39      45.640  72.482  -7.754  1.00  0.00           C  
ATOM    571  CG  LYS A  39      47.145  72.340  -7.896  1.00  0.00           C  
ATOM    572  CD  LYS A  39      47.550  72.101  -9.340  1.00  0.00           C  
ATOM    573  CE  LYS A  39      48.831  71.287  -9.433  1.00  0.00           C  
ATOM    574  NZ  LYS A  39      48.562  69.823  -9.405  1.00  0.00           N  
ATOM    575  H   LYS A  39      44.627  71.421  -5.167  1.00  0.00           H  
ATOM    576  HA  LYS A  39      45.827  73.885  -6.149  1.00  0.00           H  
ATOM    577  HB2 LYS A  39      45.192  71.509  -7.890  1.00  0.00           H  
ATOM    578  HB3 LYS A  39      45.287  73.142  -8.535  1.00  0.00           H  
ATOM    579  HG2 LYS A  39      47.618  73.245  -7.545  1.00  0.00           H  
ATOM    580  HG3 LYS A  39      47.476  71.503  -7.296  1.00  0.00           H  
ATOM    581  HD2 LYS A  39      46.759  71.564  -9.843  1.00  0.00           H  
ATOM    582  HD3 LYS A  39      47.703  73.055  -9.825  1.00  0.00           H  
ATOM    583  HE2 LYS A  39      49.333  71.534 -10.356  1.00  0.00           H  
ATOM    584  HE3 LYS A  39      49.466  71.543  -8.597  1.00  0.00           H  
ATOM    585  HZ1 LYS A  39      48.567  69.440 -10.373  1.00  0.00           H  
ATOM    586  HZ2 LYS A  39      47.632  69.639  -8.976  1.00  0.00           H  
ATOM    587  HZ3 LYS A  39      49.291  69.336  -8.847  1.00  0.00           H  
ATOM    588  N   VAL A  40      43.523  74.591  -7.220  1.00  0.00           N  
ATOM    589  CA  VAL A  40      42.182  75.140  -7.378  1.00  0.00           C  
ATOM    590  C   VAL A  40      41.919  75.544  -8.825  1.00  0.00           C  
ATOM    591  O   VAL A  40      42.429  76.559  -9.298  1.00  0.00           O  
ATOM    592  CB  VAL A  40      41.967  76.364  -6.468  1.00  0.00           C  
ATOM    593  CG1 VAL A  40      40.552  76.903  -6.624  1.00  0.00           C  
ATOM    594  CG2 VAL A  40      42.252  76.007  -5.017  1.00  0.00           C  
ATOM    595  H   VAL A  40      44.275  75.028  -7.674  1.00  0.00           H  
ATOM    596  HA  VAL A  40      41.473  74.377  -7.093  1.00  0.00           H  
ATOM    597  HB  VAL A  40      42.657  77.138  -6.769  1.00  0.00           H  
ATOM    598 HG11 VAL A  40      39.856  76.078  -6.667  1.00  0.00           H  
ATOM    599 HG12 VAL A  40      40.312  77.535  -5.782  1.00  0.00           H  
ATOM    600 HG13 VAL A  40      40.484  77.477  -7.537  1.00  0.00           H  
ATOM    601 HG21 VAL A  40      41.707  76.674  -4.367  1.00  0.00           H  
ATOM    602 HG22 VAL A  40      41.943  74.989  -4.830  1.00  0.00           H  
ATOM    603 HG23 VAL A  40      43.312  76.102  -4.824  1.00  0.00           H  
ATOM    604  N   ALA A  41      41.122  74.741  -9.521  1.00  0.00           N  
ATOM    605  CA  ALA A  41      40.790  75.015 -10.914  1.00  0.00           C  
ATOM    606  C   ALA A  41      39.312  75.358 -11.068  1.00  0.00           C  
ATOM    607  O   ALA A  41      38.498  75.040 -10.201  1.00  0.00           O  
ATOM    608  CB  ALA A  41      41.151  73.824 -11.787  1.00  0.00           C  
ATOM    609  H   ALA A  41      40.747  73.947  -9.088  1.00  0.00           H  
ATOM    610  HA  ALA A  41      41.380  75.860 -11.238  1.00  0.00           H  
ATOM    611  HB1 ALA A  41      42.107  73.427 -11.477  1.00  0.00           H  
ATOM    612  HB2 ALA A  41      40.393  73.060 -11.685  1.00  0.00           H  
ATOM    613  HB3 ALA A  41      41.209  74.137 -12.819  1.00  0.00           H  
ATOM    614  N   ILE A  42      38.973  76.009 -12.176  1.00  0.00           N  
ATOM    615  CA  ILE A  42      37.594  76.394 -12.443  1.00  0.00           C  
ATOM    616  C   ILE A  42      37.231  76.162 -13.906  1.00  0.00           C  
ATOM    617  O   ILE A  42      37.884  76.685 -14.810  1.00  0.00           O  
ATOM    618  CB  ILE A  42      37.344  77.873 -12.093  1.00  0.00           C  
ATOM    619  CG1 ILE A  42      37.680  78.135 -10.623  1.00  0.00           C  
ATOM    620  CG2 ILE A  42      35.899  78.251 -12.386  1.00  0.00           C  
ATOM    621  CD1 ILE A  42      37.934  79.593 -10.312  1.00  0.00           C  
ATOM    622  H   ILE A  42      39.667  76.235 -12.829  1.00  0.00           H  
ATOM    623  HA  ILE A  42      36.951  75.785 -11.823  1.00  0.00           H  
ATOM    624  HB  ILE A  42      37.982  78.481 -12.715  1.00  0.00           H  
ATOM    625 HG12 ILE A  42      36.858  77.805 -10.008  1.00  0.00           H  
ATOM    626 HG13 ILE A  42      38.568  77.579 -10.360  1.00  0.00           H  
ATOM    627 HG21 ILE A  42      35.876  79.154 -12.979  1.00  0.00           H  
ATOM    628 HG22 ILE A  42      35.423  77.450 -12.933  1.00  0.00           H  
ATOM    629 HG23 ILE A  42      35.374  78.415 -11.458  1.00  0.00           H  
ATOM    630 HD11 ILE A  42      37.988  79.729  -9.242  1.00  0.00           H  
ATOM    631 HD12 ILE A  42      38.870  79.899 -10.760  1.00  0.00           H  
ATOM    632 HD13 ILE A  42      37.131  80.193 -10.711  1.00  0.00           H  
ATOM    633  N   LYS A  43      36.184  75.376 -14.134  1.00  0.00           N  
ATOM    634  CA  LYS A  43      35.731  75.077 -15.486  1.00  0.00           C  
ATOM    635  C   LYS A  43      34.292  74.571 -15.479  1.00  0.00           C  
ATOM    636  O   LYS A  43      33.698  74.378 -14.419  1.00  0.00           O  
ATOM    637  CB  LYS A  43      36.645  74.033 -16.133  1.00  0.00           C  
ATOM    638  CG  LYS A  43      37.852  74.632 -16.834  1.00  0.00           C  
ATOM    639  CD  LYS A  43      38.411  73.689 -17.886  1.00  0.00           C  
ATOM    640  CE  LYS A  43      39.757  74.171 -18.407  1.00  0.00           C  
ATOM    641  NZ  LYS A  43      39.627  75.420 -19.207  1.00  0.00           N  
ATOM    642  H   LYS A  43      35.703  74.989 -13.372  1.00  0.00           H  
ATOM    643  HA  LYS A  43      35.777  75.989 -16.062  1.00  0.00           H  
ATOM    644  HB2 LYS A  43      36.998  73.358 -15.368  1.00  0.00           H  
ATOM    645  HB3 LYS A  43      36.075  73.473 -16.860  1.00  0.00           H  
ATOM    646  HG2 LYS A  43      37.557  75.555 -17.314  1.00  0.00           H  
ATOM    647  HG3 LYS A  43      38.619  74.836 -16.100  1.00  0.00           H  
ATOM    648  HD2 LYS A  43      38.537  72.710 -17.448  1.00  0.00           H  
ATOM    649  HD3 LYS A  43      37.716  73.631 -18.711  1.00  0.00           H  
ATOM    650  HE2 LYS A  43      40.407  74.358 -17.567  1.00  0.00           H  
ATOM    651  HE3 LYS A  43      40.185  73.398 -19.028  1.00  0.00           H  
ATOM    652  HZ1 LYS A  43      39.827  76.248 -18.610  1.00  0.00           H  
ATOM    653  HZ2 LYS A  43      38.663  75.503 -19.586  1.00  0.00           H  
ATOM    654  HZ3 LYS A  43      40.299  75.408 -20.000  1.00  0.00           H  
ATOM    655  N   ASP A  44      33.738  74.359 -16.668  1.00  0.00           N  
ATOM    656  CA  ASP A  44      32.369  73.874 -16.798  1.00  0.00           C  
ATOM    657  C   ASP A  44      31.435  74.623 -15.852  1.00  0.00           C  
ATOM    658  O   ASP A  44      30.462  74.061 -15.349  1.00  0.00           O  
ATOM    659  CB  ASP A  44      32.308  72.373 -16.512  1.00  0.00           C  
ATOM    660  CG  ASP A  44      31.183  71.686 -17.261  1.00  0.00           C  
ATOM    661  OD1 ASP A  44      31.377  71.354 -18.449  1.00  0.00           O  
ATOM    662  OD2 ASP A  44      30.107  71.482 -16.660  1.00  0.00           O  
ATOM    663  H   ASP A  44      34.264  74.532 -17.477  1.00  0.00           H  
ATOM    664  HA  ASP A  44      32.050  74.050 -17.814  1.00  0.00           H  
ATOM    665  HB2 ASP A  44      33.243  71.918 -16.808  1.00  0.00           H  
ATOM    666  HB3 ASP A  44      32.157  72.220 -15.454  1.00  0.00           H  
ATOM    667  N   LYS A  45      31.738  75.894 -15.614  1.00  0.00           N  
ATOM    668  CA  LYS A  45      30.927  76.721 -14.728  1.00  0.00           C  
ATOM    669  C   LYS A  45      30.900  76.144 -13.316  1.00  0.00           C  
ATOM    670  O   LYS A  45      29.871  76.173 -12.643  1.00  0.00           O  
ATOM    671  CB  LYS A  45      29.500  76.837 -15.270  1.00  0.00           C  
ATOM    672  CG  LYS A  45      29.357  77.845 -16.397  1.00  0.00           C  
ATOM    673  CD  LYS A  45      29.850  77.277 -17.718  1.00  0.00           C  
ATOM    674  CE  LYS A  45      29.696  78.283 -18.848  1.00  0.00           C  
ATOM    675  NZ  LYS A  45      30.798  79.285 -18.854  1.00  0.00           N  
ATOM    676  H   LYS A  45      32.527  76.286 -16.044  1.00  0.00           H  
ATOM    677  HA  LYS A  45      31.371  77.705 -14.694  1.00  0.00           H  
ATOM    678  HB2 LYS A  45      29.188  75.870 -15.637  1.00  0.00           H  
ATOM    679  HB3 LYS A  45      28.845  77.135 -14.464  1.00  0.00           H  
ATOM    680  HG2 LYS A  45      28.316  78.111 -16.499  1.00  0.00           H  
ATOM    681  HG3 LYS A  45      29.935  78.725 -16.156  1.00  0.00           H  
ATOM    682  HD2 LYS A  45      30.895  77.020 -17.621  1.00  0.00           H  
ATOM    683  HD3 LYS A  45      29.280  76.391 -17.955  1.00  0.00           H  
ATOM    684  HE2 LYS A  45      29.699  77.752 -19.788  1.00  0.00           H  
ATOM    685  HE3 LYS A  45      28.754  78.797 -18.729  1.00  0.00           H  
ATOM    686  HZ1 LYS A  45      31.705  78.821 -18.647  1.00  0.00           H  
ATOM    687  HZ2 LYS A  45      30.620  80.015 -18.134  1.00  0.00           H  
ATOM    688  HZ3 LYS A  45      30.859  79.743 -19.786  1.00  0.00           H  
ATOM    689  N   GLN A  46      32.040  75.622 -12.874  1.00  0.00           N  
ATOM    690  CA  GLN A  46      32.147  75.038 -11.542  1.00  0.00           C  
ATOM    691  C   GLN A  46      33.569  75.161 -11.006  1.00  0.00           C  
ATOM    692  O   GLN A  46      34.534  75.161 -11.770  1.00  0.00           O  
ATOM    693  CB  GLN A  46      31.725  73.568 -11.570  1.00  0.00           C  
ATOM    694  CG  GLN A  46      32.837  72.624 -12.001  1.00  0.00           C  
ATOM    695  CD  GLN A  46      32.485  71.167 -11.777  1.00  0.00           C  
ATOM    696  OE1 GLN A  46      31.918  70.805 -10.746  1.00  0.00           O  
ATOM    697  NE2 GLN A  46      32.820  70.321 -12.744  1.00  0.00           N  
ATOM    698  H   GLN A  46      32.827  75.627 -13.458  1.00  0.00           H  
ATOM    699  HA  GLN A  46      31.481  75.581 -10.889  1.00  0.00           H  
ATOM    700  HB2 GLN A  46      31.400  73.279 -10.582  1.00  0.00           H  
ATOM    701  HB3 GLN A  46      30.900  73.455 -12.259  1.00  0.00           H  
ATOM    702  HG2 GLN A  46      33.030  72.774 -13.053  1.00  0.00           H  
ATOM    703  HG3 GLN A  46      33.727  72.857 -11.436  1.00  0.00           H  
ATOM    704 HE21 GLN A  46      33.271  70.681 -13.537  1.00  0.00           H  
ATOM    705 HE22 GLN A  46      32.605  69.373 -12.625  1.00  0.00           H  
ATOM    706  N   VAL A  47      33.691  75.267  -9.687  1.00  0.00           N  
ATOM    707  CA  VAL A  47      34.996  75.391  -9.048  1.00  0.00           C  
ATOM    708  C   VAL A  47      35.428  74.069  -8.421  1.00  0.00           C  
ATOM    709  O   VAL A  47      34.703  73.484  -7.618  1.00  0.00           O  
ATOM    710  CB  VAL A  47      34.989  76.482  -7.962  1.00  0.00           C  
ATOM    711  CG1 VAL A  47      36.408  76.806  -7.521  1.00  0.00           C  
ATOM    712  CG2 VAL A  47      34.280  77.730  -8.467  1.00  0.00           C  
ATOM    713  H   VAL A  47      32.886  75.261  -9.129  1.00  0.00           H  
ATOM    714  HA  VAL A  47      35.714  75.670  -9.805  1.00  0.00           H  
ATOM    715  HB  VAL A  47      34.446  76.107  -7.107  1.00  0.00           H  
ATOM    716 HG11 VAL A  47      36.449  77.824  -7.161  1.00  0.00           H  
ATOM    717 HG12 VAL A  47      36.702  76.132  -6.730  1.00  0.00           H  
ATOM    718 HG13 VAL A  47      37.079  76.695  -8.359  1.00  0.00           H  
ATOM    719 HG21 VAL A  47      33.479  77.989  -7.790  1.00  0.00           H  
ATOM    720 HG22 VAL A  47      34.985  78.547  -8.520  1.00  0.00           H  
ATOM    721 HG23 VAL A  47      33.874  77.541  -9.450  1.00  0.00           H  
ATOM    722  N   LYS A  48      36.616  73.605  -8.795  1.00  0.00           N  
ATOM    723  CA  LYS A  48      37.147  72.352  -8.269  1.00  0.00           C  
ATOM    724  C   LYS A  48      38.431  72.595  -7.482  1.00  0.00           C  
ATOM    725  O   LYS A  48      38.958  73.707  -7.463  1.00  0.00           O  
ATOM    726  CB  LYS A  48      37.416  71.370  -9.411  1.00  0.00           C  
ATOM    727  CG  LYS A  48      36.152  70.794 -10.027  1.00  0.00           C  
ATOM    728  CD  LYS A  48      36.384  69.393 -10.570  1.00  0.00           C  
ATOM    729  CE  LYS A  48      35.342  69.019 -11.612  1.00  0.00           C  
ATOM    730  NZ  LYS A  48      35.684  67.747 -12.307  1.00  0.00           N  
ATOM    731  H   LYS A  48      37.148  74.116  -9.441  1.00  0.00           H  
ATOM    732  HA  LYS A  48      36.408  71.929  -7.607  1.00  0.00           H  
ATOM    733  HB2 LYS A  48      37.969  71.878 -10.186  1.00  0.00           H  
ATOM    734  HB3 LYS A  48      38.011  70.551  -9.033  1.00  0.00           H  
ATOM    735  HG2 LYS A  48      35.381  70.753  -9.273  1.00  0.00           H  
ATOM    736  HG3 LYS A  48      35.834  71.435 -10.837  1.00  0.00           H  
ATOM    737  HD2 LYS A  48      37.363  69.350 -11.024  1.00  0.00           H  
ATOM    738  HD3 LYS A  48      36.333  68.687  -9.752  1.00  0.00           H  
ATOM    739  HE2 LYS A  48      34.387  68.907 -11.123  1.00  0.00           H  
ATOM    740  HE3 LYS A  48      35.282  69.813 -12.342  1.00  0.00           H  
ATOM    741  HZ1 LYS A  48      35.648  67.882 -13.338  1.00  0.00           H  
ATOM    742  HZ2 LYS A  48      35.007  67.003 -12.042  1.00  0.00           H  
ATOM    743  HZ3 LYS A  48      36.641  67.441 -12.041  1.00  0.00           H  
ATOM    744  N   TYR A  49      38.929  71.547  -6.833  1.00  0.00           N  
ATOM    745  CA  TYR A  49      40.149  71.647  -6.043  1.00  0.00           C  
ATOM    746  C   TYR A  49      40.878  70.307  -5.994  1.00  0.00           C  
ATOM    747  O   TYR A  49      40.330  69.307  -5.530  1.00  0.00           O  
ATOM    748  CB  TYR A  49      39.826  72.118  -4.624  1.00  0.00           C  
ATOM    749  CG  TYR A  49      38.832  73.255  -4.574  1.00  0.00           C  
ATOM    750  CD1 TYR A  49      37.512  73.068  -4.969  1.00  0.00           C  
ATOM    751  CD2 TYR A  49      39.210  74.517  -4.132  1.00  0.00           C  
ATOM    752  CE1 TYR A  49      36.601  74.105  -4.926  1.00  0.00           C  
ATOM    753  CE2 TYR A  49      38.306  75.559  -4.084  1.00  0.00           C  
ATOM    754  CZ  TYR A  49      37.002  75.348  -4.483  1.00  0.00           C  
ATOM    755  OH  TYR A  49      36.096  76.384  -4.438  1.00  0.00           O  
ATOM    756  H   TYR A  49      38.463  70.687  -6.886  1.00  0.00           H  
ATOM    757  HA  TYR A  49      40.792  72.376  -6.515  1.00  0.00           H  
ATOM    758  HB2 TYR A  49      39.413  71.293  -4.064  1.00  0.00           H  
ATOM    759  HB3 TYR A  49      40.736  72.451  -4.146  1.00  0.00           H  
ATOM    760  HD1 TYR A  49      37.202  72.094  -5.315  1.00  0.00           H  
ATOM    761  HD2 TYR A  49      40.233  74.678  -3.820  1.00  0.00           H  
ATOM    762  HE1 TYR A  49      35.580  73.941  -5.238  1.00  0.00           H  
ATOM    763  HE2 TYR A  49      38.619  76.532  -3.737  1.00  0.00           H  
ATOM    764  HH  TYR A  49      35.364  76.194  -5.027  1.00  0.00           H  
ATOM    765  N   PHE A  50      42.116  70.297  -6.475  1.00  0.00           N  
ATOM    766  CA  PHE A  50      42.922  69.081  -6.487  1.00  0.00           C  
ATOM    767  C   PHE A  50      43.187  68.590  -5.067  1.00  0.00           C  
ATOM    768  O   PHE A  50      44.033  69.137  -4.358  1.00  0.00           O  
ATOM    769  CB  PHE A  50      44.246  69.329  -7.210  1.00  0.00           C  
ATOM    770  CG  PHE A  50      45.041  68.077  -7.451  1.00  0.00           C  
ATOM    771  CD1 PHE A  50      44.420  66.920  -7.893  1.00  0.00           C  
ATOM    772  CD2 PHE A  50      46.410  68.057  -7.236  1.00  0.00           C  
ATOM    773  CE1 PHE A  50      45.148  65.767  -8.115  1.00  0.00           C  
ATOM    774  CE2 PHE A  50      47.144  66.907  -7.456  1.00  0.00           C  
ATOM    775  CZ  PHE A  50      46.512  65.761  -7.898  1.00  0.00           C  
ATOM    776  H   PHE A  50      42.497  71.126  -6.832  1.00  0.00           H  
ATOM    777  HA  PHE A  50      42.368  68.323  -7.019  1.00  0.00           H  
ATOM    778  HB2 PHE A  50      44.046  69.784  -8.168  1.00  0.00           H  
ATOM    779  HB3 PHE A  50      44.852  69.998  -6.618  1.00  0.00           H  
ATOM    780  HD1 PHE A  50      43.353  66.924  -8.064  1.00  0.00           H  
ATOM    781  HD2 PHE A  50      46.905  68.954  -6.891  1.00  0.00           H  
ATOM    782  HE1 PHE A  50      44.652  64.872  -8.460  1.00  0.00           H  
ATOM    783  HE2 PHE A  50      48.210  66.906  -7.285  1.00  0.00           H  
ATOM    784  HZ  PHE A  50      47.083  64.860  -8.069  1.00  0.00           H  
ATOM    785  N   ILE A  51      42.458  67.558  -4.657  1.00  0.00           N  
ATOM    786  CA  ILE A  51      42.616  66.994  -3.323  1.00  0.00           C  
ATOM    787  C   ILE A  51      43.763  65.991  -3.282  1.00  0.00           C  
ATOM    788  O   ILE A  51      44.081  65.352  -4.287  1.00  0.00           O  
ATOM    789  CB  ILE A  51      41.325  66.300  -2.849  1.00  0.00           C  
ATOM    790  CG1 ILE A  51      40.162  67.294  -2.834  1.00  0.00           C  
ATOM    791  CG2 ILE A  51      41.527  65.691  -1.470  1.00  0.00           C  
ATOM    792  CD1 ILE A  51      40.358  68.438  -1.864  1.00  0.00           C  
ATOM    793  H   ILE A  51      41.800  67.165  -5.268  1.00  0.00           H  
ATOM    794  HA  ILE A  51      42.835  67.804  -2.643  1.00  0.00           H  
ATOM    795  HB  ILE A  51      41.097  65.502  -3.539  1.00  0.00           H  
ATOM    796 HG12 ILE A  51      40.042  67.713  -3.820  1.00  0.00           H  
ATOM    797 HG13 ILE A  51      39.257  66.774  -2.555  1.00  0.00           H  
ATOM    798 HG21 ILE A  51      42.265  64.905  -1.528  1.00  0.00           H  
ATOM    799 HG22 ILE A  51      41.867  66.454  -0.786  1.00  0.00           H  
ATOM    800 HG23 ILE A  51      40.592  65.281  -1.117  1.00  0.00           H  
ATOM    801 HD11 ILE A  51      39.452  69.025  -1.811  1.00  0.00           H  
ATOM    802 HD12 ILE A  51      40.589  68.046  -0.885  1.00  0.00           H  
ATOM    803 HD13 ILE A  51      41.171  69.064  -2.203  1.00  0.00           H  
ATOM    804  N   HIS A  52      44.381  65.854  -2.114  1.00  0.00           N  
ATOM    805  CA  HIS A  52      45.494  64.926  -1.939  1.00  0.00           C  
ATOM    806  C   HIS A  52      45.282  64.049  -0.708  1.00  0.00           C  
ATOM    807  O   HIS A  52      45.653  64.424   0.403  1.00  0.00           O  
ATOM    808  CB  HIS A  52      46.810  65.692  -1.816  1.00  0.00           C  
ATOM    809  CG  HIS A  52      47.946  64.854  -1.313  1.00  0.00           C  
ATOM    810  ND1 HIS A  52      48.669  64.003  -2.123  1.00  0.00           N  
ATOM    811  CD2 HIS A  52      48.482  64.740  -0.076  1.00  0.00           C  
ATOM    812  CE1 HIS A  52      49.601  63.401  -1.405  1.00  0.00           C  
ATOM    813  NE2 HIS A  52      49.508  63.831  -0.159  1.00  0.00           N  
ATOM    814  H   HIS A  52      44.083  66.390  -1.349  1.00  0.00           H  
ATOM    815  HA  HIS A  52      45.536  64.293  -2.814  1.00  0.00           H  
ATOM    816  HB2 HIS A  52      47.088  66.078  -2.786  1.00  0.00           H  
ATOM    817  HB3 HIS A  52      46.676  66.516  -1.129  1.00  0.00           H  
ATOM    818  HD1 HIS A  52      48.520  63.861  -3.081  1.00  0.00           H  
ATOM    819  HD2 HIS A  52      48.162  65.265   0.813  1.00  0.00           H  
ATOM    820  HE1 HIS A  52      50.316  62.681  -1.772  1.00  0.00           H  
ATOM    821  HE2 HIS A  52      50.024  63.483   0.598  1.00  0.00           H  
ATOM    822  N   TYR A  53      44.685  62.880  -0.916  1.00  0.00           N  
ATOM    823  CA  TYR A  53      44.422  61.953   0.178  1.00  0.00           C  
ATOM    824  C   TYR A  53      45.669  61.752   1.033  1.00  0.00           C  
ATOM    825  O   TYR A  53      46.687  61.250   0.558  1.00  0.00           O  
ATOM    826  CB  TYR A  53      43.944  60.607  -0.372  1.00  0.00           C  
ATOM    827  CG  TYR A  53      42.609  60.681  -1.078  1.00  0.00           C  
ATOM    828  CD1 TYR A  53      41.542  61.370  -0.516  1.00  0.00           C  
ATOM    829  CD2 TYR A  53      42.416  60.060  -2.306  1.00  0.00           C  
ATOM    830  CE1 TYR A  53      40.320  61.440  -1.157  1.00  0.00           C  
ATOM    831  CE2 TYR A  53      41.198  60.126  -2.955  1.00  0.00           C  
ATOM    832  CZ  TYR A  53      40.154  60.816  -2.377  1.00  0.00           C  
ATOM    833  OH  TYR A  53      38.938  60.882  -3.019  1.00  0.00           O  
ATOM    834  H   TYR A  53      44.413  62.637  -1.825  1.00  0.00           H  
ATOM    835  HA  TYR A  53      43.642  62.378   0.792  1.00  0.00           H  
ATOM    836  HB2 TYR A  53      44.672  60.235  -1.077  1.00  0.00           H  
ATOM    837  HB3 TYR A  53      43.850  59.907   0.445  1.00  0.00           H  
ATOM    838  HD1 TYR A  53      41.675  61.857   0.439  1.00  0.00           H  
ATOM    839  HD2 TYR A  53      43.237  59.520  -2.756  1.00  0.00           H  
ATOM    840  HE1 TYR A  53      39.501  61.980  -0.706  1.00  0.00           H  
ATOM    841  HE2 TYR A  53      41.067  59.637  -3.909  1.00  0.00           H  
ATOM    842  HH  TYR A  53      38.402  61.570  -2.618  1.00  0.00           H  
ATOM    843  N   SER A  54      45.579  62.147   2.299  1.00  0.00           N  
ATOM    844  CA  SER A  54      46.700  62.014   3.222  1.00  0.00           C  
ATOM    845  C   SER A  54      47.033  60.545   3.464  1.00  0.00           C  
ATOM    846  O   SER A  54      48.201  60.162   3.515  1.00  0.00           O  
ATOM    847  CB  SER A  54      46.378  62.701   4.551  1.00  0.00           C  
ATOM    848  OG  SER A  54      47.563  63.051   5.245  1.00  0.00           O  
ATOM    849  H   SER A  54      44.740  62.540   2.619  1.00  0.00           H  
ATOM    850  HA  SER A  54      47.556  62.497   2.776  1.00  0.00           H  
ATOM    851  HB2 SER A  54      45.810  63.599   4.360  1.00  0.00           H  
ATOM    852  HB3 SER A  54      45.798  62.031   5.169  1.00  0.00           H  
ATOM    853  HG  SER A  54      47.657  62.493   6.021  1.00  0.00           H  
ATOM    854  N   GLY A  55      45.996  59.726   3.615  1.00  0.00           N  
ATOM    855  CA  GLY A  55      46.198  58.308   3.850  1.00  0.00           C  
ATOM    856  C   GLY A  55      47.414  57.769   3.124  1.00  0.00           C  
ATOM    857  O   GLY A  55      48.374  57.323   3.753  1.00  0.00           O  
ATOM    858  H   GLY A  55      45.086  60.088   3.564  1.00  0.00           H  
ATOM    859  HA2 GLY A  55      46.322  58.145   4.909  1.00  0.00           H  
ATOM    860  HA3 GLY A  55      45.324  57.771   3.512  1.00  0.00           H  
ATOM    861  N   TRP A  56      47.374  57.806   1.797  1.00  0.00           N  
ATOM    862  CA  TRP A  56      48.481  57.314   0.985  1.00  0.00           C  
ATOM    863  C   TRP A  56      48.939  58.373  -0.012  1.00  0.00           C  
ATOM    864  O   TRP A  56      48.120  59.063  -0.617  1.00  0.00           O  
ATOM    865  CB  TRP A  56      48.070  56.041   0.243  1.00  0.00           C  
ATOM    866  CG  TRP A  56      48.230  54.797   1.063  1.00  0.00           C  
ATOM    867  CD1 TRP A  56      49.163  54.569   2.035  1.00  0.00           C  
ATOM    868  CD2 TRP A  56      47.434  53.609   0.983  1.00  0.00           C  
ATOM    869  NE1 TRP A  56      48.994  53.312   2.563  1.00  0.00           N  
ATOM    870  CE2 TRP A  56      47.940  52.703   1.934  1.00  0.00           C  
ATOM    871  CE3 TRP A  56      46.343  53.223   0.199  1.00  0.00           C  
ATOM    872  CZ2 TRP A  56      47.392  51.437   2.121  1.00  0.00           C  
ATOM    873  CZ3 TRP A  56      45.800  51.966   0.386  1.00  0.00           C  
ATOM    874  CH2 TRP A  56      46.324  51.086   1.342  1.00  0.00           C  
ATOM    875  H   TRP A  56      46.581  58.173   1.352  1.00  0.00           H  
ATOM    876  HA  TRP A  56      49.302  57.083   1.649  1.00  0.00           H  
ATOM    877  HB2 TRP A  56      47.033  56.119  -0.046  1.00  0.00           H  
ATOM    878  HB3 TRP A  56      48.680  55.938  -0.643  1.00  0.00           H  
ATOM    879  HD1 TRP A  56      49.916  55.282   2.333  1.00  0.00           H  
ATOM    880  HE1 TRP A  56      49.540  52.916   3.275  1.00  0.00           H  
ATOM    881  HE3 TRP A  56      45.925  53.889  -0.542  1.00  0.00           H  
ATOM    882  HZ2 TRP A  56      47.784  50.747   2.854  1.00  0.00           H  
ATOM    883  HZ3 TRP A  56      44.957  51.651  -0.210  1.00  0.00           H  
ATOM    884  HH2 TRP A  56      45.869  50.114   1.453  1.00  0.00           H  
ATOM    885  N   ASN A  57      50.251  58.497  -0.176  1.00  0.00           N  
ATOM    886  CA  ASN A  57      50.817  59.474  -1.100  1.00  0.00           C  
ATOM    887  C   ASN A  57      50.378  59.185  -2.532  1.00  0.00           C  
ATOM    888  O   ASN A  57      50.342  58.032  -2.962  1.00  0.00           O  
ATOM    889  CB  ASN A  57      52.344  59.466  -1.012  1.00  0.00           C  
ATOM    890  CG  ASN A  57      52.864  60.367   0.092  1.00  0.00           C  
ATOM    891  OD1 ASN A  57      52.222  60.529   1.131  1.00  0.00           O  
ATOM    892  ND2 ASN A  57      54.033  60.957  -0.128  1.00  0.00           N  
ATOM    893  H   ASN A  57      50.854  57.918   0.335  1.00  0.00           H  
ATOM    894  HA  ASN A  57      50.453  60.449  -0.814  1.00  0.00           H  
ATOM    895  HB2 ASN A  57      52.683  58.458  -0.816  1.00  0.00           H  
ATOM    896  HB3 ASN A  57      52.756  59.803  -1.951  1.00  0.00           H  
ATOM    897 HD21 ASN A  57      54.488  60.781  -0.978  1.00  0.00           H  
ATOM    898 HD22 ASN A  57      54.393  61.544   0.570  1.00  0.00           H  
ATOM    899  N   LYS A  58      50.046  60.241  -3.268  1.00  0.00           N  
ATOM    900  CA  LYS A  58      49.611  60.104  -4.653  1.00  0.00           C  
ATOM    901  C   LYS A  58      48.662  58.920  -4.810  1.00  0.00           C  
ATOM    902  O   LYS A  58      48.817  58.105  -5.719  1.00  0.00           O  
ATOM    903  CB  LYS A  58      50.821  59.927  -5.573  1.00  0.00           C  
ATOM    904  CG  LYS A  58      50.606  60.478  -6.973  1.00  0.00           C  
ATOM    905  CD  LYS A  58      49.926  59.461  -7.874  1.00  0.00           C  
ATOM    906  CE  LYS A  58      49.929  59.913  -9.327  1.00  0.00           C  
ATOM    907  NZ  LYS A  58      49.068  61.110  -9.536  1.00  0.00           N  
ATOM    908  H   LYS A  58      50.096  61.135  -2.869  1.00  0.00           H  
ATOM    909  HA  LYS A  58      49.088  61.007  -4.928  1.00  0.00           H  
ATOM    910  HB2 LYS A  58      51.668  60.435  -5.136  1.00  0.00           H  
ATOM    911  HB3 LYS A  58      51.046  58.874  -5.655  1.00  0.00           H  
ATOM    912  HG2 LYS A  58      49.984  61.359  -6.911  1.00  0.00           H  
ATOM    913  HG3 LYS A  58      51.564  60.739  -7.399  1.00  0.00           H  
ATOM    914  HD2 LYS A  58      50.453  58.520  -7.801  1.00  0.00           H  
ATOM    915  HD3 LYS A  58      48.904  59.330  -7.549  1.00  0.00           H  
ATOM    916  HE2 LYS A  58      50.940  60.154  -9.613  1.00  0.00           H  
ATOM    917  HE3 LYS A  58      49.563  59.104  -9.942  1.00  0.00           H  
ATOM    918  HZ1 LYS A  58      49.276  61.543 -10.457  1.00  0.00           H  
ATOM    919  HZ2 LYS A  58      49.243  61.811  -8.787  1.00  0.00           H  
ATOM    920  HZ3 LYS A  58      48.065  60.837  -9.511  1.00  0.00           H  
ATOM    921  N   ASN A  59      47.680  58.832  -3.920  1.00  0.00           N  
ATOM    922  CA  ASN A  59      46.706  57.747  -3.960  1.00  0.00           C  
ATOM    923  C   ASN A  59      45.621  58.030  -4.995  1.00  0.00           C  
ATOM    924  O   ASN A  59      44.518  58.455  -4.652  1.00  0.00           O  
ATOM    925  CB  ASN A  59      46.072  57.551  -2.581  1.00  0.00           C  
ATOM    926  CG  ASN A  59      45.539  56.145  -2.386  1.00  0.00           C  
ATOM    927  OD1 ASN A  59      46.182  55.166  -2.769  1.00  0.00           O  
ATOM    928  ND2 ASN A  59      44.359  56.037  -1.787  1.00  0.00           N  
ATOM    929  H   ASN A  59      47.609  59.512  -3.217  1.00  0.00           H  
ATOM    930  HA  ASN A  59      47.226  56.844  -4.240  1.00  0.00           H  
ATOM    931  HB2 ASN A  59      46.814  57.742  -1.821  1.00  0.00           H  
ATOM    932  HB3 ASN A  59      45.255  58.246  -2.466  1.00  0.00           H  
ATOM    933 HD21 ASN A  59      43.904  56.860  -1.510  1.00  0.00           H  
ATOM    934 HD22 ASN A  59      43.991  55.140  -1.648  1.00  0.00           H  
ATOM    935  N   TRP A  60      45.942  57.790  -6.261  1.00  0.00           N  
ATOM    936  CA  TRP A  60      44.994  58.018  -7.347  1.00  0.00           C  
ATOM    937  C   TRP A  60      44.275  59.351  -7.170  1.00  0.00           C  
ATOM    938  O   TRP A  60      43.073  59.455  -7.415  1.00  0.00           O  
ATOM    939  CB  TRP A  60      43.976  56.879  -7.409  1.00  0.00           C  
ATOM    940  CG  TRP A  60      44.601  55.519  -7.343  1.00  0.00           C  
ATOM    941  CD1 TRP A  60      45.418  54.945  -8.275  1.00  0.00           C  
ATOM    942  CD2 TRP A  60      44.459  54.561  -6.288  1.00  0.00           C  
ATOM    943  NE1 TRP A  60      45.793  53.689  -7.864  1.00  0.00           N  
ATOM    944  CE2 TRP A  60      45.217  53.430  -6.648  1.00  0.00           C  
ATOM    945  CE3 TRP A  60      43.766  54.549  -5.075  1.00  0.00           C  
ATOM    946  CZ2 TRP A  60      45.299  52.301  -5.837  1.00  0.00           C  
ATOM    947  CZ3 TRP A  60      43.847  53.428  -4.272  1.00  0.00           C  
ATOM    948  CH2 TRP A  60      44.611  52.316  -4.655  1.00  0.00           C  
ATOM    949  H   TRP A  60      46.838  57.452  -6.472  1.00  0.00           H  
ATOM    950  HA  TRP A  60      45.552  58.043  -8.272  1.00  0.00           H  
ATOM    951  HB2 TRP A  60      43.290  56.971  -6.581  1.00  0.00           H  
ATOM    952  HB3 TRP A  60      43.426  56.949  -8.338  1.00  0.00           H  
ATOM    953  HD1 TRP A  60      45.717  55.421  -9.197  1.00  0.00           H  
ATOM    954  HE1 TRP A  60      46.377  53.079  -8.361  1.00  0.00           H  
ATOM    955  HE3 TRP A  60      43.172  55.396  -4.763  1.00  0.00           H  
ATOM    956  HZ2 TRP A  60      45.884  51.437  -6.118  1.00  0.00           H  
ATOM    957  HZ3 TRP A  60      43.319  53.401  -3.330  1.00  0.00           H  
ATOM    958  HH2 TRP A  60      44.646  51.462  -3.996  1.00  0.00           H  
ATOM    959  N   ASP A  61      45.017  60.367  -6.744  1.00  0.00           N  
ATOM    960  CA  ASP A  61      44.449  61.694  -6.535  1.00  0.00           C  
ATOM    961  C   ASP A  61      43.360  61.986  -7.562  1.00  0.00           C  
ATOM    962  O   ASP A  61      43.398  61.480  -8.683  1.00  0.00           O  
ATOM    963  CB  ASP A  61      45.544  62.759  -6.618  1.00  0.00           C  
ATOM    964  CG  ASP A  61      46.272  62.944  -5.302  1.00  0.00           C  
ATOM    965  OD1 ASP A  61      46.741  61.934  -4.737  1.00  0.00           O  
ATOM    966  OD2 ASP A  61      46.375  64.100  -4.837  1.00  0.00           O  
ATOM    967  H   ASP A  61      45.970  60.221  -6.565  1.00  0.00           H  
ATOM    968  HA  ASP A  61      44.012  61.717  -5.548  1.00  0.00           H  
ATOM    969  HB2 ASP A  61      46.264  62.468  -7.370  1.00  0.00           H  
ATOM    970  HB3 ASP A  61      45.098  63.703  -6.898  1.00  0.00           H  
ATOM    971  N   GLU A  62      42.388  62.804  -7.170  1.00  0.00           N  
ATOM    972  CA  GLU A  62      41.286  63.161  -8.056  1.00  0.00           C  
ATOM    973  C   GLU A  62      40.787  64.573  -7.763  1.00  0.00           C  
ATOM    974  O   GLU A  62      40.961  65.087  -6.658  1.00  0.00           O  
ATOM    975  CB  GLU A  62      40.137  62.161  -7.906  1.00  0.00           C  
ATOM    976  CG  GLU A  62      39.905  61.712  -6.474  1.00  0.00           C  
ATOM    977  CD  GLU A  62      40.874  60.630  -6.037  1.00  0.00           C  
ATOM    978  OE1 GLU A  62      40.587  59.440  -6.283  1.00  0.00           O  
ATOM    979  OE2 GLU A  62      41.920  60.974  -5.448  1.00  0.00           O  
ATOM    980  H   GLU A  62      42.412  63.175  -6.263  1.00  0.00           H  
ATOM    981  HA  GLU A  62      41.652  63.125  -9.070  1.00  0.00           H  
ATOM    982  HB2 GLU A  62      39.229  62.618  -8.271  1.00  0.00           H  
ATOM    983  HB3 GLU A  62      40.355  61.289  -8.504  1.00  0.00           H  
ATOM    984  HG2 GLU A  62      40.020  62.563  -5.819  1.00  0.00           H  
ATOM    985  HG3 GLU A  62      38.899  61.328  -6.389  1.00  0.00           H  
ATOM    986  N   TRP A  63      40.168  65.193  -8.760  1.00  0.00           N  
ATOM    987  CA  TRP A  63      39.644  66.547  -8.609  1.00  0.00           C  
ATOM    988  C   TRP A  63      38.233  66.523  -8.032  1.00  0.00           C  
ATOM    989  O   TRP A  63      37.414  65.683  -8.401  1.00  0.00           O  
ATOM    990  CB  TRP A  63      39.644  67.269  -9.958  1.00  0.00           C  
ATOM    991  CG  TRP A  63      40.992  67.793 -10.351  1.00  0.00           C  
ATOM    992  CD1 TRP A  63      41.936  67.148 -11.099  1.00  0.00           C  
ATOM    993  CD2 TRP A  63      41.546  69.069 -10.015  1.00  0.00           C  
ATOM    994  NE1 TRP A  63      43.044  67.948 -11.247  1.00  0.00           N  
ATOM    995  CE2 TRP A  63      42.829  69.132 -10.593  1.00  0.00           C  
ATOM    996  CE3 TRP A  63      41.083  70.166  -9.284  1.00  0.00           C  
ATOM    997  CZ2 TRP A  63      43.652  70.247 -10.460  1.00  0.00           C  
ATOM    998  CZ3 TRP A  63      41.901  71.273  -9.153  1.00  0.00           C  
ATOM    999  CH2 TRP A  63      43.172  71.307  -9.739  1.00  0.00           C  
ATOM   1000  H   TRP A  63      40.060  64.732  -9.617  1.00  0.00           H  
ATOM   1001  HA  TRP A  63      40.292  67.078  -7.927  1.00  0.00           H  
ATOM   1002  HB2 TRP A  63      39.316  66.583 -10.726  1.00  0.00           H  
ATOM   1003  HB3 TRP A  63      38.962  68.105  -9.910  1.00  0.00           H  
ATOM   1004  HD1 TRP A  63      41.816  66.156 -11.505  1.00  0.00           H  
ATOM   1005  HE1 TRP A  63      43.855  67.709 -11.743  1.00  0.00           H  
ATOM   1006  HE3 TRP A  63      40.105  70.160  -8.825  1.00  0.00           H  
ATOM   1007  HZ2 TRP A  63      44.635  70.289 -10.906  1.00  0.00           H  
ATOM   1008  HZ3 TRP A  63      41.559  72.130  -8.591  1.00  0.00           H  
ATOM   1009  HH2 TRP A  63      43.777  72.192  -9.610  1.00  0.00           H  
ATOM   1010  N   VAL A  64      37.956  67.452  -7.122  1.00  0.00           N  
ATOM   1011  CA  VAL A  64      36.642  67.538  -6.494  1.00  0.00           C  
ATOM   1012  C   VAL A  64      36.106  68.965  -6.535  1.00  0.00           C  
ATOM   1013  O   VAL A  64      36.861  69.938  -6.549  1.00  0.00           O  
ATOM   1014  CB  VAL A  64      36.688  67.061  -5.030  1.00  0.00           C  
ATOM   1015  CG1 VAL A  64      37.578  65.835  -4.896  1.00  0.00           C  
ATOM   1016  CG2 VAL A  64      37.169  68.181  -4.120  1.00  0.00           C  
ATOM   1017  H   VAL A  64      38.650  68.095  -6.868  1.00  0.00           H  
ATOM   1018  HA  VAL A  64      35.968  66.896  -7.040  1.00  0.00           H  
ATOM   1019  HB  VAL A  64      35.687  66.787  -4.731  1.00  0.00           H  
ATOM   1020 HG11 VAL A  64      37.045  65.060  -4.365  1.00  0.00           H  
ATOM   1021 HG12 VAL A  64      37.850  65.478  -5.879  1.00  0.00           H  
ATOM   1022 HG13 VAL A  64      38.471  66.097  -4.347  1.00  0.00           H  
ATOM   1023 HG21 VAL A  64      37.618  67.757  -3.234  1.00  0.00           H  
ATOM   1024 HG22 VAL A  64      37.898  68.782  -4.643  1.00  0.00           H  
ATOM   1025 HG23 VAL A  64      36.330  68.799  -3.836  1.00  0.00           H  
ATOM   1026  N   PRO A  65      34.772  69.096  -6.555  1.00  0.00           N  
ATOM   1027  CA  PRO A  65      34.105  70.400  -6.593  1.00  0.00           C  
ATOM   1028  C   PRO A  65      34.258  71.170  -5.285  1.00  0.00           C  
ATOM   1029  O   PRO A  65      35.084  70.820  -4.443  1.00  0.00           O  
ATOM   1030  CB  PRO A  65      32.636  70.040  -6.832  1.00  0.00           C  
ATOM   1031  CG  PRO A  65      32.493  68.658  -6.295  1.00  0.00           C  
ATOM   1032  CD  PRO A  65      33.812  67.980  -6.540  1.00  0.00           C  
ATOM   1033  HA  PRO A  65      34.465  71.006  -7.411  1.00  0.00           H  
ATOM   1034  HB2 PRO A  65      32.001  70.738  -6.304  1.00  0.00           H  
ATOM   1035  HB3 PRO A  65      32.419  70.076  -7.889  1.00  0.00           H  
ATOM   1036  HG2 PRO A  65      32.281  68.696  -5.237  1.00  0.00           H  
ATOM   1037  HG3 PRO A  65      31.702  68.140  -6.819  1.00  0.00           H  
ATOM   1038  HD2 PRO A  65      34.035  67.289  -5.740  1.00  0.00           H  
ATOM   1039  HD3 PRO A  65      33.802  67.467  -7.491  1.00  0.00           H  
ATOM   1040  N   GLU A  66      33.457  72.217  -5.123  1.00  0.00           N  
ATOM   1041  CA  GLU A  66      33.506  73.036  -3.916  1.00  0.00           C  
ATOM   1042  C   GLU A  66      32.536  72.509  -2.862  1.00  0.00           C  
ATOM   1043  O   GLU A  66      32.600  72.897  -1.696  1.00  0.00           O  
ATOM   1044  CB  GLU A  66      33.175  74.492  -4.248  1.00  0.00           C  
ATOM   1045  CG  GLU A  66      33.412  75.448  -3.090  1.00  0.00           C  
ATOM   1046  CD  GLU A  66      32.721  76.784  -3.286  1.00  0.00           C  
ATOM   1047  OE1 GLU A  66      31.507  76.871  -3.008  1.00  0.00           O  
ATOM   1048  OE2 GLU A  66      33.396  77.742  -3.719  1.00  0.00           O  
ATOM   1049  H   GLU A  66      32.818  72.445  -5.830  1.00  0.00           H  
ATOM   1050  HA  GLU A  66      34.509  72.984  -3.522  1.00  0.00           H  
ATOM   1051  HB2 GLU A  66      33.787  74.807  -5.081  1.00  0.00           H  
ATOM   1052  HB3 GLU A  66      32.136  74.556  -4.532  1.00  0.00           H  
ATOM   1053  HG2 GLU A  66      33.038  74.997  -2.184  1.00  0.00           H  
ATOM   1054  HG3 GLU A  66      34.474  75.620  -2.995  1.00  0.00           H  
ATOM   1055  N   SER A  67      31.637  71.624  -3.283  1.00  0.00           N  
ATOM   1056  CA  SER A  67      30.651  71.048  -2.378  1.00  0.00           C  
ATOM   1057  C   SER A  67      31.177  69.761  -1.748  1.00  0.00           C  
ATOM   1058  O   SER A  67      30.679  69.314  -0.715  1.00  0.00           O  
ATOM   1059  CB  SER A  67      29.344  70.767  -3.124  1.00  0.00           C  
ATOM   1060  OG  SER A  67      28.255  70.668  -2.224  1.00  0.00           O  
ATOM   1061  H   SER A  67      31.636  71.355  -4.225  1.00  0.00           H  
ATOM   1062  HA  SER A  67      30.460  71.766  -1.594  1.00  0.00           H  
ATOM   1063  HB2 SER A  67      29.151  71.569  -3.819  1.00  0.00           H  
ATOM   1064  HB3 SER A  67      29.436  69.835  -3.665  1.00  0.00           H  
ATOM   1065  HG  SER A  67      27.661  71.411  -2.358  1.00  0.00           H  
ATOM   1066  N   ARG A  68      32.187  69.171  -2.379  1.00  0.00           N  
ATOM   1067  CA  ARG A  68      32.781  67.936  -1.883  1.00  0.00           C  
ATOM   1068  C   ARG A  68      33.884  68.231  -0.871  1.00  0.00           C  
ATOM   1069  O   ARG A  68      34.411  67.323  -0.228  1.00  0.00           O  
ATOM   1070  CB  ARG A  68      33.345  67.114  -3.044  1.00  0.00           C  
ATOM   1071  CG  ARG A  68      32.301  66.274  -3.759  1.00  0.00           C  
ATOM   1072  CD  ARG A  68      32.912  65.015  -4.355  1.00  0.00           C  
ATOM   1073  NE  ARG A  68      32.146  64.523  -5.498  1.00  0.00           N  
ATOM   1074  CZ  ARG A  68      32.616  63.640  -6.371  1.00  0.00           C  
ATOM   1075  NH1 ARG A  68      33.842  63.154  -6.235  1.00  0.00           N  
ATOM   1076  NH2 ARG A  68      31.858  63.240  -7.385  1.00  0.00           N  
ATOM   1077  H   ARG A  68      32.541  69.577  -3.199  1.00  0.00           H  
ATOM   1078  HA  ARG A  68      32.004  67.367  -1.395  1.00  0.00           H  
ATOM   1079  HB2 ARG A  68      33.789  67.787  -3.763  1.00  0.00           H  
ATOM   1080  HB3 ARG A  68      34.109  66.454  -2.662  1.00  0.00           H  
ATOM   1081  HG2 ARG A  68      31.536  65.988  -3.052  1.00  0.00           H  
ATOM   1082  HG3 ARG A  68      31.861  66.861  -4.551  1.00  0.00           H  
ATOM   1083  HD2 ARG A  68      33.918  65.238  -4.678  1.00  0.00           H  
ATOM   1084  HD3 ARG A  68      32.939  64.249  -3.595  1.00  0.00           H  
ATOM   1085  HE  ARG A  68      31.238  64.870  -5.618  1.00  0.00           H  
ATOM   1086 HH11 ARG A  68      34.414  63.452  -5.471  1.00  0.00           H  
ATOM   1087 HH12 ARG A  68      34.192  62.488  -6.893  1.00  0.00           H  
ATOM   1088 HH21 ARG A  68      30.934  63.605  -7.492  1.00  0.00           H  
ATOM   1089 HH22 ARG A  68      32.213  62.576  -8.042  1.00  0.00           H  
ATOM   1090  N   VAL A  69      34.230  69.508  -0.735  1.00  0.00           N  
ATOM   1091  CA  VAL A  69      35.269  69.923   0.199  1.00  0.00           C  
ATOM   1092  C   VAL A  69      34.675  70.679   1.381  1.00  0.00           C  
ATOM   1093  O   VAL A  69      33.754  71.482   1.221  1.00  0.00           O  
ATOM   1094  CB  VAL A  69      36.320  70.814  -0.491  1.00  0.00           C  
ATOM   1095  CG1 VAL A  69      37.547  70.976   0.393  1.00  0.00           C  
ATOM   1096  CG2 VAL A  69      36.701  70.235  -1.846  1.00  0.00           C  
ATOM   1097  H   VAL A  69      33.773  70.186  -1.276  1.00  0.00           H  
ATOM   1098  HA  VAL A  69      35.765  69.035   0.563  1.00  0.00           H  
ATOM   1099  HB  VAL A  69      35.886  71.790  -0.649  1.00  0.00           H  
ATOM   1100 HG11 VAL A  69      38.270  71.601  -0.107  1.00  0.00           H  
ATOM   1101 HG12 VAL A  69      37.258  71.433   1.328  1.00  0.00           H  
ATOM   1102 HG13 VAL A  69      37.982  70.005   0.585  1.00  0.00           H  
ATOM   1103 HG21 VAL A  69      35.822  70.167  -2.469  1.00  0.00           H  
ATOM   1104 HG22 VAL A  69      37.429  70.878  -2.318  1.00  0.00           H  
ATOM   1105 HG23 VAL A  69      37.124  69.250  -1.710  1.00  0.00           H  
ATOM   1106  N   LEU A  70      35.208  70.420   2.570  1.00  0.00           N  
ATOM   1107  CA  LEU A  70      34.731  71.077   3.782  1.00  0.00           C  
ATOM   1108  C   LEU A  70      35.779  72.042   4.327  1.00  0.00           C  
ATOM   1109  O   LEU A  70      36.952  71.975   3.957  1.00  0.00           O  
ATOM   1110  CB  LEU A  70      34.378  70.036   4.845  1.00  0.00           C  
ATOM   1111  CG  LEU A  70      33.509  68.868   4.378  1.00  0.00           C  
ATOM   1112  CD1 LEU A  70      33.232  67.914   5.531  1.00  0.00           C  
ATOM   1113  CD2 LEU A  70      32.205  69.378   3.782  1.00  0.00           C  
ATOM   1114  H   LEU A  70      35.939  69.771   2.636  1.00  0.00           H  
ATOM   1115  HA  LEU A  70      33.842  71.636   3.529  1.00  0.00           H  
ATOM   1116  HB2 LEU A  70      35.301  69.628   5.229  1.00  0.00           H  
ATOM   1117  HB3 LEU A  70      33.853  70.543   5.643  1.00  0.00           H  
ATOM   1118  HG  LEU A  70      34.037  68.318   3.611  1.00  0.00           H  
ATOM   1119 HD11 LEU A  70      32.479  68.340   6.176  1.00  0.00           H  
ATOM   1120 HD12 LEU A  70      34.141  67.755   6.092  1.00  0.00           H  
ATOM   1121 HD13 LEU A  70      32.881  66.970   5.140  1.00  0.00           H  
ATOM   1122 HD21 LEU A  70      31.550  69.707   4.574  1.00  0.00           H  
ATOM   1123 HD22 LEU A  70      31.728  68.584   3.226  1.00  0.00           H  
ATOM   1124 HD23 LEU A  70      32.414  70.206   3.118  1.00  0.00           H  
ATOM   1125  N   LYS A  71      35.350  72.936   5.211  1.00  0.00           N  
ATOM   1126  CA  LYS A  71      36.252  73.913   5.810  1.00  0.00           C  
ATOM   1127  C   LYS A  71      37.013  73.302   6.983  1.00  0.00           C  
ATOM   1128  O   LYS A  71      37.707  74.006   7.718  1.00  0.00           O  
ATOM   1129  CB  LYS A  71      35.466  75.140   6.282  1.00  0.00           C  
ATOM   1130  CG  LYS A  71      34.916  75.983   5.145  1.00  0.00           C  
ATOM   1131  CD  LYS A  71      33.778  75.276   4.427  1.00  0.00           C  
ATOM   1132  CE  LYS A  71      33.158  76.162   3.357  1.00  0.00           C  
ATOM   1133  NZ  LYS A  71      34.194  76.825   2.518  1.00  0.00           N  
ATOM   1134  H   LYS A  71      34.403  72.939   5.467  1.00  0.00           H  
ATOM   1135  HA  LYS A  71      36.960  74.218   5.056  1.00  0.00           H  
ATOM   1136  HB2 LYS A  71      34.639  74.810   6.892  1.00  0.00           H  
ATOM   1137  HB3 LYS A  71      36.118  75.761   6.880  1.00  0.00           H  
ATOM   1138  HG2 LYS A  71      34.550  76.916   5.545  1.00  0.00           H  
ATOM   1139  HG3 LYS A  71      35.710  76.180   4.438  1.00  0.00           H  
ATOM   1140  HD2 LYS A  71      34.161  74.381   3.959  1.00  0.00           H  
ATOM   1141  HD3 LYS A  71      33.019  75.011   5.148  1.00  0.00           H  
ATOM   1142  HE2 LYS A  71      32.530  75.556   2.725  1.00  0.00           H  
ATOM   1143  HE3 LYS A  71      32.559  76.920   3.840  1.00  0.00           H  
ATOM   1144  HZ1 LYS A  71      35.106  76.336   2.620  1.00  0.00           H  
ATOM   1145  HZ2 LYS A  71      34.310  77.816   2.810  1.00  0.00           H  
ATOM   1146  HZ3 LYS A  71      33.912  76.803   1.517  1.00  0.00           H  
ATOM   1147  N   TYR A  72      36.880  71.992   7.151  1.00  0.00           N  
ATOM   1148  CA  TYR A  72      37.554  71.287   8.234  1.00  0.00           C  
ATOM   1149  C   TYR A  72      37.303  71.976   9.572  1.00  0.00           C  
ATOM   1150  O   TYR A  72      38.209  72.109  10.395  1.00  0.00           O  
ATOM   1151  CB  TYR A  72      39.058  71.210   7.962  1.00  0.00           C  
ATOM   1152  CG  TYR A  72      39.717  69.981   8.546  1.00  0.00           C  
ATOM   1153  CD1 TYR A  72      40.147  69.961   9.867  1.00  0.00           C  
ATOM   1154  CD2 TYR A  72      39.911  68.840   7.777  1.00  0.00           C  
ATOM   1155  CE1 TYR A  72      40.750  68.840  10.405  1.00  0.00           C  
ATOM   1156  CE2 TYR A  72      40.512  67.715   8.307  1.00  0.00           C  
ATOM   1157  CZ  TYR A  72      40.930  67.720   9.622  1.00  0.00           C  
ATOM   1158  OH  TYR A  72      41.530  66.602  10.152  1.00  0.00           O  
ATOM   1159  H   TYR A  72      36.313  71.485   6.532  1.00  0.00           H  
ATOM   1160  HA  TYR A  72      37.155  70.285   8.277  1.00  0.00           H  
ATOM   1161  HB2 TYR A  72      39.224  71.199   6.896  1.00  0.00           H  
ATOM   1162  HB3 TYR A  72      39.539  72.079   8.387  1.00  0.00           H  
ATOM   1163  HD1 TYR A  72      40.005  70.841  10.479  1.00  0.00           H  
ATOM   1164  HD2 TYR A  72      39.582  68.840   6.748  1.00  0.00           H  
ATOM   1165  HE1 TYR A  72      41.077  68.844  11.434  1.00  0.00           H  
ATOM   1166  HE2 TYR A  72      40.653  66.838   7.693  1.00  0.00           H  
ATOM   1167  HH  TYR A  72      42.039  66.157   9.471  1.00  0.00           H  
ATOM   1168  N   VAL A  73      36.066  72.412   9.782  1.00  0.00           N  
ATOM   1169  CA  VAL A  73      35.692  73.085  11.020  1.00  0.00           C  
ATOM   1170  C   VAL A  73      34.912  72.153  11.940  1.00  0.00           C  
ATOM   1171  O   VAL A  73      34.390  71.127  11.502  1.00  0.00           O  
ATOM   1172  CB  VAL A  73      34.845  74.342  10.742  1.00  0.00           C  
ATOM   1173  CG1 VAL A  73      35.665  75.385   9.998  1.00  0.00           C  
ATOM   1174  CG2 VAL A  73      33.593  73.977   9.957  1.00  0.00           C  
ATOM   1175  H   VAL A  73      35.386  72.276   9.089  1.00  0.00           H  
ATOM   1176  HA  VAL A  73      36.599  73.393  11.520  1.00  0.00           H  
ATOM   1177  HB  VAL A  73      34.541  74.763  11.689  1.00  0.00           H  
ATOM   1178 HG11 VAL A  73      36.609  74.955   9.699  1.00  0.00           H  
ATOM   1179 HG12 VAL A  73      35.124  75.712   9.123  1.00  0.00           H  
ATOM   1180 HG13 VAL A  73      35.846  76.230  10.647  1.00  0.00           H  
ATOM   1181 HG21 VAL A  73      33.403  72.919  10.055  1.00  0.00           H  
ATOM   1182 HG22 VAL A  73      32.753  74.533  10.344  1.00  0.00           H  
ATOM   1183 HG23 VAL A  73      33.738  74.222   8.915  1.00  0.00           H  
ATOM   1184  N   ASP A  74      34.835  72.517  13.215  1.00  0.00           N  
ATOM   1185  CA  ASP A  74      34.117  71.713  14.197  1.00  0.00           C  
ATOM   1186  C   ASP A  74      32.897  71.048  13.567  1.00  0.00           C  
ATOM   1187  O   ASP A  74      32.799  69.822  13.523  1.00  0.00           O  
ATOM   1188  CB  ASP A  74      33.685  72.581  15.381  1.00  0.00           C  
ATOM   1189  CG  ASP A  74      34.690  73.673  15.694  1.00  0.00           C  
ATOM   1190  OD1 ASP A  74      35.906  73.411  15.578  1.00  0.00           O  
ATOM   1191  OD2 ASP A  74      34.261  74.789  16.057  1.00  0.00           O  
ATOM   1192  H   ASP A  74      35.272  73.346  13.502  1.00  0.00           H  
ATOM   1193  HA  ASP A  74      34.787  70.945  14.551  1.00  0.00           H  
ATOM   1194  HB2 ASP A  74      32.737  73.046  15.152  1.00  0.00           H  
ATOM   1195  HB3 ASP A  74      33.574  71.957  16.255  1.00  0.00           H  
ATOM   1196  N   THR A  75      31.967  71.866  13.083  1.00  0.00           N  
ATOM   1197  CA  THR A  75      30.753  71.358  12.458  1.00  0.00           C  
ATOM   1198  C   THR A  75      31.065  70.214  11.500  1.00  0.00           C  
ATOM   1199  O   THR A  75      30.568  69.100  11.664  1.00  0.00           O  
ATOM   1200  CB  THR A  75      30.009  72.466  11.691  1.00  0.00           C  
ATOM   1201  OG1 THR A  75      29.876  73.629  12.516  1.00  0.00           O  
ATOM   1202  CG2 THR A  75      28.633  71.991  11.251  1.00  0.00           C  
ATOM   1203  H   THR A  75      32.103  72.835  13.148  1.00  0.00           H  
ATOM   1204  HA  THR A  75      30.103  70.992  13.240  1.00  0.00           H  
ATOM   1205  HB  THR A  75      30.583  72.723  10.812  1.00  0.00           H  
ATOM   1206  HG1 THR A  75      29.724  73.361  13.426  1.00  0.00           H  
ATOM   1207 HG21 THR A  75      27.894  72.733  11.516  1.00  0.00           H  
ATOM   1208 HG22 THR A  75      28.400  71.058  11.743  1.00  0.00           H  
ATOM   1209 HG23 THR A  75      28.627  71.845  10.181  1.00  0.00           H  
ATOM   1210  N   ASN A  76      31.892  70.496  10.499  1.00  0.00           N  
ATOM   1211  CA  ASN A  76      32.271  69.490   9.513  1.00  0.00           C  
ATOM   1212  C   ASN A  76      32.853  68.255  10.194  1.00  0.00           C  
ATOM   1213  O   ASN A  76      32.554  67.123   9.810  1.00  0.00           O  
ATOM   1214  CB  ASN A  76      33.286  70.068   8.526  1.00  0.00           C  
ATOM   1215  CG  ASN A  76      32.670  71.097   7.599  1.00  0.00           C  
ATOM   1216  OD1 ASN A  76      31.515  70.968   7.191  1.00  0.00           O  
ATOM   1217  ND2 ASN A  76      33.439  72.125   7.260  1.00  0.00           N  
ATOM   1218  H   ASN A  76      32.256  71.402  10.419  1.00  0.00           H  
ATOM   1219  HA  ASN A  76      31.381  69.203   8.973  1.00  0.00           H  
ATOM   1220  HB2 ASN A  76      34.085  70.543   9.078  1.00  0.00           H  
ATOM   1221  HB3 ASN A  76      33.695  69.269   7.927  1.00  0.00           H  
ATOM   1222 HD21 ASN A  76      34.348  72.162   7.622  1.00  0.00           H  
ATOM   1223 HD22 ASN A  76      33.064  72.805   6.661  1.00  0.00           H  
ATOM   1224  N   LEU A  77      33.685  68.479  11.205  1.00  0.00           N  
ATOM   1225  CA  LEU A  77      34.309  67.385  11.940  1.00  0.00           C  
ATOM   1226  C   LEU A  77      33.254  66.468  12.552  1.00  0.00           C  
ATOM   1227  O   LEU A  77      33.366  65.245  12.481  1.00  0.00           O  
ATOM   1228  CB  LEU A  77      35.221  67.937  13.037  1.00  0.00           C  
ATOM   1229  CG  LEU A  77      36.476  68.668  12.563  1.00  0.00           C  
ATOM   1230  CD1 LEU A  77      37.191  69.319  13.737  1.00  0.00           C  
ATOM   1231  CD2 LEU A  77      37.407  67.709  11.835  1.00  0.00           C  
ATOM   1232  H   LEU A  77      33.883  69.403  11.464  1.00  0.00           H  
ATOM   1233  HA  LEU A  77      34.903  66.814  11.243  1.00  0.00           H  
ATOM   1234  HB2 LEU A  77      34.642  68.627  13.633  1.00  0.00           H  
ATOM   1235  HB3 LEU A  77      35.532  67.106  13.655  1.00  0.00           H  
ATOM   1236  HG  LEU A  77      36.191  69.449  11.871  1.00  0.00           H  
ATOM   1237 HD11 LEU A  77      36.531  70.030  14.210  1.00  0.00           H  
ATOM   1238 HD12 LEU A  77      38.075  69.828  13.382  1.00  0.00           H  
ATOM   1239 HD13 LEU A  77      37.475  68.560  14.450  1.00  0.00           H  
ATOM   1240 HD21 LEU A  77      38.250  67.473  12.469  1.00  0.00           H  
ATOM   1241 HD22 LEU A  77      37.760  68.173  10.924  1.00  0.00           H  
ATOM   1242 HD23 LEU A  77      36.873  66.802  11.593  1.00  0.00           H  
ATOM   1243  N   GLN A  78      32.230  67.070  13.150  1.00  0.00           N  
ATOM   1244  CA  GLN A  78      31.155  66.306  13.771  1.00  0.00           C  
ATOM   1245  C   GLN A  78      30.736  65.136  12.888  1.00  0.00           C  
ATOM   1246  O   GLN A  78      30.424  64.052  13.381  1.00  0.00           O  
ATOM   1247  CB  GLN A  78      29.951  67.210  14.046  1.00  0.00           C  
ATOM   1248  CG  GLN A  78      30.285  68.428  14.894  1.00  0.00           C  
ATOM   1249  CD  GLN A  78      30.107  68.172  16.377  1.00  0.00           C  
ATOM   1250  OE1 GLN A  78      30.538  67.142  16.897  1.00  0.00           O  
ATOM   1251  NE2 GLN A  78      29.470  69.110  17.067  1.00  0.00           N  
ATOM   1252  H   GLN A  78      32.198  68.048  13.173  1.00  0.00           H  
ATOM   1253  HA  GLN A  78      31.523  65.919  14.710  1.00  0.00           H  
ATOM   1254  HB2 GLN A  78      29.552  67.554  13.103  1.00  0.00           H  
ATOM   1255  HB3 GLN A  78      29.195  66.636  14.561  1.00  0.00           H  
ATOM   1256  HG2 GLN A  78      31.314  68.705  14.713  1.00  0.00           H  
ATOM   1257  HG3 GLN A  78      29.638  69.241  14.603  1.00  0.00           H  
ATOM   1258 HE21 GLN A  78      29.154  69.904  16.586  1.00  0.00           H  
ATOM   1259 HE22 GLN A  78      29.340  68.970  18.028  1.00  0.00           H  
ATOM   1260  N   LYS A  79      30.730  65.362  11.579  1.00  0.00           N  
ATOM   1261  CA  LYS A  79      30.350  64.327  10.625  1.00  0.00           C  
ATOM   1262  C   LYS A  79      31.527  63.405  10.325  1.00  0.00           C  
ATOM   1263  O   LYS A  79      31.507  62.225  10.673  1.00  0.00           O  
ATOM   1264  CB  LYS A  79      29.842  64.961   9.328  1.00  0.00           C  
ATOM   1265  CG  LYS A  79      29.537  63.951   8.236  1.00  0.00           C  
ATOM   1266  CD  LYS A  79      29.069  64.632   6.960  1.00  0.00           C  
ATOM   1267  CE  LYS A  79      28.128  63.741   6.166  1.00  0.00           C  
ATOM   1268  NZ  LYS A  79      26.818  63.566   6.852  1.00  0.00           N  
ATOM   1269  H   LYS A  79      30.988  66.248  11.246  1.00  0.00           H  
ATOM   1270  HA  LYS A  79      29.555  63.744  11.066  1.00  0.00           H  
ATOM   1271  HB2 LYS A  79      28.938  65.513   9.541  1.00  0.00           H  
ATOM   1272  HB3 LYS A  79      30.592  65.645   8.958  1.00  0.00           H  
ATOM   1273  HG2 LYS A  79      30.431  63.385   8.021  1.00  0.00           H  
ATOM   1274  HG3 LYS A  79      28.761  63.283   8.582  1.00  0.00           H  
ATOM   1275  HD2 LYS A  79      28.552  65.544   7.219  1.00  0.00           H  
ATOM   1276  HD3 LYS A  79      29.930  64.867   6.351  1.00  0.00           H  
ATOM   1277  HE2 LYS A  79      27.959  64.189   5.198  1.00  0.00           H  
ATOM   1278  HE3 LYS A  79      28.590  62.774   6.038  1.00  0.00           H  
ATOM   1279  HZ1 LYS A  79      26.492  64.475   7.237  1.00  0.00           H  
ATOM   1280  HZ2 LYS A  79      26.913  62.884   7.633  1.00  0.00           H  
ATOM   1281  HZ3 LYS A  79      26.107  63.211   6.181  1.00  0.00           H  
ATOM   1282  N   GLN A  80      32.552  63.952   9.679  1.00  0.00           N  
ATOM   1283  CA  GLN A  80      33.738  63.178   9.333  1.00  0.00           C  
ATOM   1284  C   GLN A  80      34.026  62.120  10.394  1.00  0.00           C  
ATOM   1285  O   GLN A  80      34.480  61.019  10.079  1.00  0.00           O  
ATOM   1286  CB  GLN A  80      34.948  64.101   9.176  1.00  0.00           C  
ATOM   1287  CG  GLN A  80      36.263  63.356   9.010  1.00  0.00           C  
ATOM   1288  CD  GLN A  80      37.452  64.158   9.500  1.00  0.00           C  
ATOM   1289  OE1 GLN A  80      37.298  65.255  10.038  1.00  0.00           O  
ATOM   1290  NE2 GLN A  80      38.650  63.614   9.316  1.00  0.00           N  
ATOM   1291  H   GLN A  80      32.509  64.898   9.428  1.00  0.00           H  
ATOM   1292  HA  GLN A  80      33.549  62.684   8.392  1.00  0.00           H  
ATOM   1293  HB2 GLN A  80      34.798  64.724   8.307  1.00  0.00           H  
ATOM   1294  HB3 GLN A  80      35.022  64.728  10.051  1.00  0.00           H  
ATOM   1295  HG2 GLN A  80      36.214  62.435   9.570  1.00  0.00           H  
ATOM   1296  HG3 GLN A  80      36.405  63.133   7.963  1.00  0.00           H  
ATOM   1297 HE21 GLN A  80      38.697  62.738   8.879  1.00  0.00           H  
ATOM   1298 HE22 GLN A  80      39.436  64.111   9.623  1.00  0.00           H  
ATOM   1299  N   ARG A  81      33.758  62.460  11.649  1.00  0.00           N  
ATOM   1300  CA  ARG A  81      33.989  61.541  12.757  1.00  0.00           C  
ATOM   1301  C   ARG A  81      32.841  60.543  12.884  1.00  0.00           C  
ATOM   1302  O   ARG A  81      33.064  59.343  13.035  1.00  0.00           O  
ATOM   1303  CB  ARG A  81      34.154  62.315  14.066  1.00  0.00           C  
ATOM   1304  CG  ARG A  81      32.873  62.978  14.546  1.00  0.00           C  
ATOM   1305  CD  ARG A  81      33.082  63.701  15.868  1.00  0.00           C  
ATOM   1306  NE  ARG A  81      33.582  62.806  16.908  1.00  0.00           N  
ATOM   1307  CZ  ARG A  81      33.768  63.177  18.170  1.00  0.00           C  
ATOM   1308  NH1 ARG A  81      33.497  64.420  18.546  1.00  0.00           N  
ATOM   1309  NH2 ARG A  81      34.226  62.305  19.058  1.00  0.00           N  
ATOM   1310  H   ARG A  81      33.397  63.352  11.837  1.00  0.00           H  
ATOM   1311  HA  ARG A  81      34.901  60.999  12.553  1.00  0.00           H  
ATOM   1312  HB2 ARG A  81      34.491  61.634  14.834  1.00  0.00           H  
ATOM   1313  HB3 ARG A  81      34.899  63.083  13.925  1.00  0.00           H  
ATOM   1314  HG2 ARG A  81      32.549  63.693  13.805  1.00  0.00           H  
ATOM   1315  HG3 ARG A  81      32.114  62.221  14.676  1.00  0.00           H  
ATOM   1316  HD2 ARG A  81      33.794  64.498  15.718  1.00  0.00           H  
ATOM   1317  HD3 ARG A  81      32.138  64.117  16.187  1.00  0.00           H  
ATOM   1318  HE  ARG A  81      33.789  61.883  16.652  1.00  0.00           H  
ATOM   1319 HH11 ARG A  81      33.150  65.079  17.879  1.00  0.00           H  
ATOM   1320 HH12 ARG A  81      33.636  64.696  19.497  1.00  0.00           H  
ATOM   1321 HH21 ARG A  81      34.432  61.368  18.778  1.00  0.00           H  
ATOM   1322 HH22 ARG A  81      34.367  62.586  20.008  1.00  0.00           H  
ATOM   1323  N   GLU A  82      31.614  61.051  12.823  1.00  0.00           N  
ATOM   1324  CA  GLU A  82      30.432  60.204  12.933  1.00  0.00           C  
ATOM   1325  C   GLU A  82      30.484  59.062  11.921  1.00  0.00           C  
ATOM   1326  O   GLU A  82      30.047  57.946  12.205  1.00  0.00           O  
ATOM   1327  CB  GLU A  82      29.163  61.032  12.718  1.00  0.00           C  
ATOM   1328  CG  GLU A  82      28.679  61.042  11.278  1.00  0.00           C  
ATOM   1329  CD  GLU A  82      27.424  61.872  11.090  1.00  0.00           C  
ATOM   1330  OE1 GLU A  82      26.586  61.899  12.017  1.00  0.00           O  
ATOM   1331  OE2 GLU A  82      27.278  62.494  10.017  1.00  0.00           O  
ATOM   1332  H   GLU A  82      31.501  62.016  12.701  1.00  0.00           H  
ATOM   1333  HA  GLU A  82      30.414  59.786  13.928  1.00  0.00           H  
ATOM   1334  HB2 GLU A  82      28.375  60.628  13.339  1.00  0.00           H  
ATOM   1335  HB3 GLU A  82      29.358  62.051  13.018  1.00  0.00           H  
ATOM   1336  HG2 GLU A  82      29.459  61.451  10.652  1.00  0.00           H  
ATOM   1337  HG3 GLU A  82      28.470  60.026  10.974  1.00  0.00           H  
ATOM   1338  N   LEU A  83      31.022  59.349  10.741  1.00  0.00           N  
ATOM   1339  CA  LEU A  83      31.132  58.348   9.687  1.00  0.00           C  
ATOM   1340  C   LEU A  83      32.314  57.417   9.941  1.00  0.00           C  
ATOM   1341  O   LEU A  83      32.166  56.195   9.930  1.00  0.00           O  
ATOM   1342  CB  LEU A  83      31.289  59.028   8.325  1.00  0.00           C  
ATOM   1343  CG  LEU A  83      30.421  60.265   8.090  1.00  0.00           C  
ATOM   1344  CD1 LEU A  83      30.958  61.079   6.922  1.00  0.00           C  
ATOM   1345  CD2 LEU A  83      28.974  59.863   7.840  1.00  0.00           C  
ATOM   1346  H   LEU A  83      31.353  60.256  10.575  1.00  0.00           H  
ATOM   1347  HA  LEU A  83      30.223  57.765   9.687  1.00  0.00           H  
ATOM   1348  HB2 LEU A  83      32.321  59.323   8.219  1.00  0.00           H  
ATOM   1349  HB3 LEU A  83      31.043  58.301   7.563  1.00  0.00           H  
ATOM   1350  HG  LEU A  83      30.448  60.889   8.972  1.00  0.00           H  
ATOM   1351 HD11 LEU A  83      31.646  61.825   7.290  1.00  0.00           H  
ATOM   1352 HD12 LEU A  83      30.138  61.565   6.415  1.00  0.00           H  
ATOM   1353 HD13 LEU A  83      31.470  60.424   6.233  1.00  0.00           H  
ATOM   1354 HD21 LEU A  83      28.383  60.086   8.716  1.00  0.00           H  
ATOM   1355 HD22 LEU A  83      28.926  58.804   7.633  1.00  0.00           H  
ATOM   1356 HD23 LEU A  83      28.588  60.413   6.995  1.00  0.00           H  
ATOM   1357  N   GLN A  84      33.484  58.003  10.170  1.00  0.00           N  
ATOM   1358  CA  GLN A  84      34.690  57.226  10.429  1.00  0.00           C  
ATOM   1359  C   GLN A  84      34.465  56.232  11.565  1.00  0.00           C  
ATOM   1360  O   GLN A  84      35.082  55.168  11.606  1.00  0.00           O  
ATOM   1361  CB  GLN A  84      35.857  58.153  10.771  1.00  0.00           C  
ATOM   1362  CG  GLN A  84      36.560  58.723   9.550  1.00  0.00           C  
ATOM   1363  CD  GLN A  84      37.826  59.477   9.904  1.00  0.00           C  
ATOM   1364  OE1 GLN A  84      38.504  59.152  10.879  1.00  0.00           O  
ATOM   1365  NE2 GLN A  84      38.153  60.491   9.110  1.00  0.00           N  
ATOM   1366  H   GLN A  84      33.538  58.981  10.165  1.00  0.00           H  
ATOM   1367  HA  GLN A  84      34.930  56.677   9.530  1.00  0.00           H  
ATOM   1368  HB2 GLN A  84      35.485  58.977  11.363  1.00  0.00           H  
ATOM   1369  HB3 GLN A  84      36.581  57.601  11.351  1.00  0.00           H  
ATOM   1370  HG2 GLN A  84      36.817  57.911   8.886  1.00  0.00           H  
ATOM   1371  HG3 GLN A  84      35.885  59.398   9.044  1.00  0.00           H  
ATOM   1372 HE21 GLN A  84      37.565  60.693   8.353  1.00  0.00           H  
ATOM   1373 HE22 GLN A  84      38.966  60.996   9.317  1.00  0.00           H  
ATOM   1374  N   LYS A  85      33.575  56.588  12.486  1.00  0.00           N  
ATOM   1375  CA  LYS A  85      33.266  55.727  13.622  1.00  0.00           C  
ATOM   1376  C   LYS A  85      32.043  54.862  13.333  1.00  0.00           C  
ATOM   1377  O   LYS A  85      31.958  53.722  13.787  1.00  0.00           O  
ATOM   1378  CB  LYS A  85      33.021  56.573  14.875  1.00  0.00           C  
ATOM   1379  CG  LYS A  85      31.637  57.193  14.929  1.00  0.00           C  
ATOM   1380  CD  LYS A  85      31.358  57.819  16.286  1.00  0.00           C  
ATOM   1381  CE  LYS A  85      30.756  56.810  17.252  1.00  0.00           C  
ATOM   1382  NZ  LYS A  85      31.802  55.970  17.899  1.00  0.00           N  
ATOM   1383  H   LYS A  85      33.114  57.449  12.398  1.00  0.00           H  
ATOM   1384  HA  LYS A  85      34.116  55.085  13.793  1.00  0.00           H  
ATOM   1385  HB2 LYS A  85      33.147  55.947  15.747  1.00  0.00           H  
ATOM   1386  HB3 LYS A  85      33.751  57.369  14.905  1.00  0.00           H  
ATOM   1387  HG2 LYS A  85      31.565  57.959  14.171  1.00  0.00           H  
ATOM   1388  HG3 LYS A  85      30.900  56.426  14.739  1.00  0.00           H  
ATOM   1389  HD2 LYS A  85      32.286  58.187  16.700  1.00  0.00           H  
ATOM   1390  HD3 LYS A  85      30.667  58.640  16.159  1.00  0.00           H  
ATOM   1391  HE2 LYS A  85      30.211  57.343  18.015  1.00  0.00           H  
ATOM   1392  HE3 LYS A  85      30.078  56.170  16.707  1.00  0.00           H  
ATOM   1393  HZ1 LYS A  85      32.746  56.348  17.686  1.00  0.00           H  
ATOM   1394  HZ2 LYS A  85      31.742  54.993  17.547  1.00  0.00           H  
ATOM   1395  HZ3 LYS A  85      31.667  55.964  18.930  1.00  0.00           H  
ATOM   1396  N   ALA A  86      31.101  55.412  12.575  1.00  0.00           N  
ATOM   1397  CA  ALA A  86      29.885  54.689  12.223  1.00  0.00           C  
ATOM   1398  C   ALA A  86      30.212  53.373  11.526  1.00  0.00           C  
ATOM   1399  O   ALA A  86      29.598  52.343  11.804  1.00  0.00           O  
ATOM   1400  CB  ALA A  86      28.996  55.550  11.339  1.00  0.00           C  
ATOM   1401  H   ALA A  86      31.226  56.326  12.243  1.00  0.00           H  
ATOM   1402  HA  ALA A  86      29.347  54.477  13.136  1.00  0.00           H  
ATOM   1403  HB1 ALA A  86      28.321  54.917  10.783  1.00  0.00           H  
ATOM   1404  HB2 ALA A  86      28.426  56.230  11.956  1.00  0.00           H  
ATOM   1405  HB3 ALA A  86      29.609  56.114  10.652  1.00  0.00           H  
ATOM   1406  N   ASN A  87      31.182  53.414  10.618  1.00  0.00           N  
ATOM   1407  CA  ASN A  87      31.589  52.224   9.880  1.00  0.00           C  
ATOM   1408  C   ASN A  87      33.104  52.047   9.926  1.00  0.00           C  
ATOM   1409  O   ASN A  87      33.835  52.667   9.155  1.00  0.00           O  
ATOM   1410  CB  ASN A  87      31.120  52.314   8.427  1.00  0.00           C  
ATOM   1411  CG  ASN A  87      29.783  53.018   8.294  1.00  0.00           C  
ATOM   1412  OD1 ASN A  87      28.727  52.394   8.405  1.00  0.00           O  
ATOM   1413  ND2 ASN A  87      29.823  54.323   8.053  1.00  0.00           N  
ATOM   1414  H   ASN A  87      31.635  54.265  10.441  1.00  0.00           H  
ATOM   1415  HA  ASN A  87      31.124  51.369  10.347  1.00  0.00           H  
ATOM   1416  HB2 ASN A  87      31.852  52.862   7.852  1.00  0.00           H  
ATOM   1417  HB3 ASN A  87      31.023  51.318   8.023  1.00  0.00           H  
ATOM   1418 HD21 ASN A  87      30.700  54.753   7.977  1.00  0.00           H  
ATOM   1419 HD22 ASN A  87      28.973  54.803   7.964  1.00  0.00           H  
ATOM   1420  N   GLN A  88      33.568  51.195  10.836  1.00  0.00           N  
ATOM   1421  CA  GLN A  88      34.994  50.937  10.983  1.00  0.00           C  
ATOM   1422  C   GLN A  88      35.478  49.941   9.934  1.00  0.00           C  
ATOM   1423  O   GLN A  88      36.307  50.272   9.087  1.00  0.00           O  
ATOM   1424  CB  GLN A  88      35.297  50.407  12.385  1.00  0.00           C  
ATOM   1425  CG  GLN A  88      35.071  51.431  13.485  1.00  0.00           C  
ATOM   1426  CD  GLN A  88      33.632  51.472  13.959  1.00  0.00           C  
ATOM   1427  OE1 GLN A  88      32.706  51.194  13.195  1.00  0.00           O  
ATOM   1428  NE2 GLN A  88      33.434  51.819  15.226  1.00  0.00           N  
ATOM   1429  H   GLN A  88      32.935  50.732  11.423  1.00  0.00           H  
ATOM   1430  HA  GLN A  88      35.517  51.871  10.842  1.00  0.00           H  
ATOM   1431  HB2 GLN A  88      34.662  49.555  12.581  1.00  0.00           H  
ATOM   1432  HB3 GLN A  88      36.329  50.092  12.424  1.00  0.00           H  
ATOM   1433  HG2 GLN A  88      35.703  51.184  14.326  1.00  0.00           H  
ATOM   1434  HG3 GLN A  88      35.339  52.408  13.110  1.00  0.00           H  
ATOM   1435 HE21 GLN A  88      34.218  52.028  15.775  1.00  0.00           H  
ATOM   1436 HE22 GLN A  88      32.513  51.854  15.558  1.00  0.00           H  
ATOM   1437  N   GLU A  89      34.955  48.721  10.000  1.00  0.00           N  
ATOM   1438  CA  GLU A  89      35.335  47.677   9.055  1.00  0.00           C  
ATOM   1439  C   GLU A  89      35.450  48.237   7.641  1.00  0.00           C  
ATOM   1440  O   GLU A  89      36.536  48.274   7.064  1.00  0.00           O  
ATOM   1441  CB  GLU A  89      34.315  46.537   9.083  1.00  0.00           C  
ATOM   1442  CG  GLU A  89      34.547  45.539  10.205  1.00  0.00           C  
ATOM   1443  CD  GLU A  89      33.611  44.349  10.129  1.00  0.00           C  
ATOM   1444  OE1 GLU A  89      32.487  44.441  10.665  1.00  0.00           O  
ATOM   1445  OE2 GLU A  89      34.004  43.323   9.534  1.00  0.00           O  
ATOM   1446  H   GLU A  89      34.299  48.518  10.699  1.00  0.00           H  
ATOM   1447  HA  GLU A  89      36.298  47.292   9.356  1.00  0.00           H  
ATOM   1448  HB2 GLU A  89      33.327  46.957   9.200  1.00  0.00           H  
ATOM   1449  HB3 GLU A  89      34.360  46.007   8.143  1.00  0.00           H  
ATOM   1450  HG2 GLU A  89      35.564  45.182  10.147  1.00  0.00           H  
ATOM   1451  HG3 GLU A  89      34.395  46.039  11.151  1.00  0.00           H  
ATOM   1452  N   GLN A  90      34.321  48.671   7.089  1.00  0.00           N  
ATOM   1453  CA  GLN A  90      34.295  49.229   5.742  1.00  0.00           C  
ATOM   1454  C   GLN A  90      35.494  50.142   5.507  1.00  0.00           C  
ATOM   1455  O   GLN A  90      36.230  49.978   4.534  1.00  0.00           O  
ATOM   1456  CB  GLN A  90      32.997  50.004   5.514  1.00  0.00           C  
ATOM   1457  CG  GLN A  90      31.834  49.128   5.073  1.00  0.00           C  
ATOM   1458  CD  GLN A  90      30.500  49.842   5.161  1.00  0.00           C  
ATOM   1459  OE1 GLN A  90      30.134  50.372   6.211  1.00  0.00           O  
ATOM   1460  NE2 GLN A  90      29.762  49.857   4.057  1.00  0.00           N  
ATOM   1461  H   GLN A  90      33.487  48.615   7.599  1.00  0.00           H  
ATOM   1462  HA  GLN A  90      34.341  48.407   5.043  1.00  0.00           H  
ATOM   1463  HB2 GLN A  90      32.719  50.497   6.433  1.00  0.00           H  
ATOM   1464  HB3 GLN A  90      33.165  50.749   4.751  1.00  0.00           H  
ATOM   1465  HG2 GLN A  90      31.996  48.825   4.050  1.00  0.00           H  
ATOM   1466  HG3 GLN A  90      31.801  48.252   5.705  1.00  0.00           H  
ATOM   1467 HE21 GLN A  90      30.117  49.412   3.258  1.00  0.00           H  
ATOM   1468 HE22 GLN A  90      28.896  50.311   4.085  1.00  0.00           H  
ATOM   1469  N   TYR A  91      35.684  51.102   6.404  1.00  0.00           N  
ATOM   1470  CA  TYR A  91      36.792  52.044   6.292  1.00  0.00           C  
ATOM   1471  C   TYR A  91      38.127  51.307   6.220  1.00  0.00           C  
ATOM   1472  O   TYR A  91      39.029  51.706   5.483  1.00  0.00           O  
ATOM   1473  CB  TYR A  91      36.793  53.006   7.482  1.00  0.00           C  
ATOM   1474  CG  TYR A  91      37.605  54.260   7.244  1.00  0.00           C  
ATOM   1475  CD1 TYR A  91      38.983  54.197   7.081  1.00  0.00           C  
ATOM   1476  CD2 TYR A  91      36.994  55.507   7.187  1.00  0.00           C  
ATOM   1477  CE1 TYR A  91      39.730  55.339   6.866  1.00  0.00           C  
ATOM   1478  CE2 TYR A  91      37.732  56.655   6.970  1.00  0.00           C  
ATOM   1479  CZ  TYR A  91      39.100  56.566   6.810  1.00  0.00           C  
ATOM   1480  OH  TYR A  91      39.839  57.706   6.596  1.00  0.00           O  
ATOM   1481  H   TYR A  91      35.064  51.183   7.158  1.00  0.00           H  
ATOM   1482  HA  TYR A  91      36.656  52.610   5.384  1.00  0.00           H  
ATOM   1483  HB2 TYR A  91      35.778  53.305   7.695  1.00  0.00           H  
ATOM   1484  HB3 TYR A  91      37.203  52.502   8.343  1.00  0.00           H  
ATOM   1485  HD1 TYR A  91      39.473  53.236   7.125  1.00  0.00           H  
ATOM   1486  HD2 TYR A  91      35.923  55.572   7.312  1.00  0.00           H  
ATOM   1487  HE1 TYR A  91      40.800  55.271   6.741  1.00  0.00           H  
ATOM   1488  HE2 TYR A  91      37.239  57.613   6.927  1.00  0.00           H  
ATOM   1489  HH  TYR A  91      39.356  58.295   6.011  1.00  0.00           H  
ATOM   1490  N   ALA A  92      38.243  50.230   6.989  1.00  0.00           N  
ATOM   1491  CA  ALA A  92      39.466  49.436   7.010  1.00  0.00           C  
ATOM   1492  C   ALA A  92      39.644  48.668   5.705  1.00  0.00           C  
ATOM   1493  O   ALA A  92      40.742  48.616   5.152  1.00  0.00           O  
ATOM   1494  CB  ALA A  92      39.451  48.476   8.191  1.00  0.00           C  
ATOM   1495  H   ALA A  92      37.489  49.962   7.554  1.00  0.00           H  
ATOM   1496  HA  ALA A  92      40.300  50.111   7.137  1.00  0.00           H  
ATOM   1497  HB1 ALA A  92      39.299  49.033   9.105  1.00  0.00           H  
ATOM   1498  HB2 ALA A  92      38.648  47.765   8.066  1.00  0.00           H  
ATOM   1499  HB3 ALA A  92      40.393  47.951   8.240  1.00  0.00           H  
ATOM   1500  N   GLU A  93      38.558  48.075   5.219  1.00  0.00           N  
ATOM   1501  CA  GLU A  93      38.597  47.308   3.979  1.00  0.00           C  
ATOM   1502  C   GLU A  93      39.418  48.034   2.917  1.00  0.00           C  
ATOM   1503  O   GLU A  93      39.255  49.235   2.704  1.00  0.00           O  
ATOM   1504  CB  GLU A  93      37.179  47.060   3.462  1.00  0.00           C  
ATOM   1505  CG  GLU A  93      36.421  46.001   4.246  1.00  0.00           C  
ATOM   1506  CD  GLU A  93      34.949  45.955   3.890  1.00  0.00           C  
ATOM   1507  OE1 GLU A  93      34.633  45.826   2.689  1.00  0.00           O  
ATOM   1508  OE2 GLU A  93      34.112  46.048   4.813  1.00  0.00           O  
ATOM   1509  H   GLU A  93      37.711  48.153   5.706  1.00  0.00           H  
ATOM   1510  HA  GLU A  93      39.065  46.358   4.191  1.00  0.00           H  
ATOM   1511  HB2 GLU A  93      36.622  47.984   3.514  1.00  0.00           H  
ATOM   1512  HB3 GLU A  93      37.235  46.743   2.431  1.00  0.00           H  
ATOM   1513  HG2 GLU A  93      36.858  45.036   4.036  1.00  0.00           H  
ATOM   1514  HG3 GLU A  93      36.516  46.216   5.300  1.00  0.00           H  
ATOM   1515  N   GLY A  94      40.303  47.295   2.254  1.00  0.00           N  
ATOM   1516  CA  GLY A  94      41.136  47.884   1.223  1.00  0.00           C  
ATOM   1517  C   GLY A  94      42.509  48.268   1.736  1.00  0.00           C  
ATOM   1518  O   GLY A  94      43.522  47.991   1.093  1.00  0.00           O  
ATOM   1519  H   GLY A  94      40.389  46.342   2.466  1.00  0.00           H  
ATOM   1520  HA2 GLY A  94      41.250  47.174   0.417  1.00  0.00           H  
ATOM   1521  HA3 GLY A  94      40.647  48.769   0.841  1.00  0.00           H  
ATOM   1522  N   LYS A  95      42.546  48.911   2.899  1.00  0.00           N  
ATOM   1523  CA  LYS A  95      43.805  49.334   3.500  1.00  0.00           C  
ATOM   1524  C   LYS A  95      44.621  48.131   3.961  1.00  0.00           C  
ATOM   1525  O   LYS A  95      44.065  47.084   4.294  1.00  0.00           O  
ATOM   1526  CB  LYS A  95      43.540  50.266   4.684  1.00  0.00           C  
ATOM   1527  CG  LYS A  95      43.280  51.707   4.278  1.00  0.00           C  
ATOM   1528  CD  LYS A  95      42.631  52.496   5.403  1.00  0.00           C  
ATOM   1529  CE  LYS A  95      42.685  53.992   5.137  1.00  0.00           C  
ATOM   1530  NZ  LYS A  95      41.649  54.419   4.156  1.00  0.00           N  
ATOM   1531  H   LYS A  95      41.705  49.103   3.365  1.00  0.00           H  
ATOM   1532  HA  LYS A  95      44.367  49.870   2.750  1.00  0.00           H  
ATOM   1533  HB2 LYS A  95      42.677  49.906   5.225  1.00  0.00           H  
ATOM   1534  HB3 LYS A  95      44.398  50.249   5.340  1.00  0.00           H  
ATOM   1535  HG2 LYS A  95      44.219  52.174   4.021  1.00  0.00           H  
ATOM   1536  HG3 LYS A  95      42.625  51.717   3.418  1.00  0.00           H  
ATOM   1537  HD2 LYS A  95      41.598  52.194   5.492  1.00  0.00           H  
ATOM   1538  HD3 LYS A  95      43.151  52.283   6.326  1.00  0.00           H  
ATOM   1539  HE2 LYS A  95      42.525  54.515   6.068  1.00  0.00           H  
ATOM   1540  HE3 LYS A  95      43.662  54.240   4.748  1.00  0.00           H  
ATOM   1541  HZ1 LYS A  95      40.701  54.298   4.563  1.00  0.00           H  
ATOM   1542  HZ2 LYS A  95      41.721  53.848   3.290  1.00  0.00           H  
ATOM   1543  HZ3 LYS A  95      41.784  55.421   3.908  1.00  0.00           H  
ATOM   1544  N   MET A  96      45.940  48.287   3.978  1.00  0.00           N  
ATOM   1545  CA  MET A  96      46.832  47.213   4.400  1.00  0.00           C  
ATOM   1546  C   MET A  96      47.241  47.388   5.859  1.00  0.00           C  
ATOM   1547  O   MET A  96      48.092  48.218   6.179  1.00  0.00           O  
ATOM   1548  CB  MET A  96      48.076  47.174   3.511  1.00  0.00           C  
ATOM   1549  CG  MET A  96      48.742  45.809   3.457  1.00  0.00           C  
ATOM   1550  SD  MET A  96      50.333  45.845   2.609  1.00  0.00           S  
ATOM   1551  CE  MET A  96      49.817  45.602   0.912  1.00  0.00           C  
ATOM   1552  H   MET A  96      46.324  49.146   3.700  1.00  0.00           H  
ATOM   1553  HA  MET A  96      46.298  46.280   4.297  1.00  0.00           H  
ATOM   1554  HB2 MET A  96      47.795  47.453   2.506  1.00  0.00           H  
ATOM   1555  HB3 MET A  96      48.794  47.887   3.886  1.00  0.00           H  
ATOM   1556  HG2 MET A  96      48.898  45.458   4.467  1.00  0.00           H  
ATOM   1557  HG3 MET A  96      48.088  45.125   2.938  1.00  0.00           H  
ATOM   1558  HE1 MET A  96      50.621  45.885   0.247  1.00  0.00           H  
ATOM   1559  HE2 MET A  96      49.570  44.562   0.755  1.00  0.00           H  
ATOM   1560  HE3 MET A  96      48.950  46.212   0.708  1.00  0.00           H  
ATOM   1561  N   ARG A  97      46.629  46.603   6.739  1.00  0.00           N  
ATOM   1562  CA  ARG A  97      46.930  46.673   8.164  1.00  0.00           C  
ATOM   1563  C   ARG A  97      48.431  46.561   8.410  1.00  0.00           C  
ATOM   1564  O   ARG A  97      49.215  46.421   7.472  1.00  0.00           O  
ATOM   1565  CB  ARG A  97      46.194  45.562   8.918  1.00  0.00           C  
ATOM   1566  CG  ARG A  97      46.921  44.227   8.893  1.00  0.00           C  
ATOM   1567  CD  ARG A  97      46.260  43.217   9.818  1.00  0.00           C  
ATOM   1568  NE  ARG A  97      45.205  42.466   9.144  1.00  0.00           N  
ATOM   1569  CZ  ARG A  97      45.437  41.550   8.210  1.00  0.00           C  
ATOM   1570  NH1 ARG A  97      46.679  41.272   7.842  1.00  0.00           N  
ATOM   1571  NH2 ARG A  97      44.423  40.908   7.643  1.00  0.00           N  
ATOM   1572  H   ARG A  97      45.959  45.961   6.423  1.00  0.00           H  
ATOM   1573  HA  ARG A  97      46.587  47.630   8.528  1.00  0.00           H  
ATOM   1574  HB2 ARG A  97      46.072  45.861   9.948  1.00  0.00           H  
ATOM   1575  HB3 ARG A  97      45.221  45.425   8.471  1.00  0.00           H  
ATOM   1576  HG2 ARG A  97      46.907  43.838   7.886  1.00  0.00           H  
ATOM   1577  HG3 ARG A  97      47.942  44.378   9.210  1.00  0.00           H  
ATOM   1578  HD2 ARG A  97      47.011  42.526  10.171  1.00  0.00           H  
ATOM   1579  HD3 ARG A  97      45.834  43.743  10.659  1.00  0.00           H  
ATOM   1580  HE  ARG A  97      44.278  42.654   9.401  1.00  0.00           H  
ATOM   1581 HH11 ARG A  97      47.445  41.753   8.269  1.00  0.00           H  
ATOM   1582 HH12 ARG A  97      46.852  40.581   7.140  1.00  0.00           H  
ATOM   1583 HH21 ARG A  97      43.484  41.114   7.917  1.00  0.00           H  
ATOM   1584 HH22 ARG A  97      44.598  40.219   6.940  1.00  0.00           H  
ATOM   1585  N   GLY A  98      48.825  46.626   9.678  1.00  0.00           N  
ATOM   1586  CA  GLY A  98      50.231  46.531  10.024  1.00  0.00           C  
ATOM   1587  C   GLY A  98      50.656  47.592  11.020  1.00  0.00           C  
ATOM   1588  O   GLY A  98      49.817  48.209  11.674  1.00  0.00           O  
ATOM   1589  H   GLY A  98      48.155  46.738  10.385  1.00  0.00           H  
ATOM   1590  HA2 GLY A  98      50.421  45.556  10.449  1.00  0.00           H  
ATOM   1591  HA3 GLY A  98      50.819  46.641   9.124  1.00  0.00           H  
ATOM   1592  N   ALA A  99      51.963  47.804  11.134  1.00  0.00           N  
ATOM   1593  CA  ALA A  99      52.498  48.797  12.057  1.00  0.00           C  
ATOM   1594  C   ALA A  99      51.833  48.691  13.424  1.00  0.00           C  
ATOM   1595  O   ALA A  99      51.434  49.696  14.012  1.00  0.00           O  
ATOM   1596  CB  ALA A  99      52.316  50.197  11.487  1.00  0.00           C  
ATOM   1597  H   ALA A  99      52.582  47.280  10.584  1.00  0.00           H  
ATOM   1598  HA  ALA A  99      53.557  48.615  12.167  1.00  0.00           H  
ATOM   1599  HB1 ALA A  99      53.219  50.496  10.975  1.00  0.00           H  
ATOM   1600  HB2 ALA A  99      51.490  50.197  10.791  1.00  0.00           H  
ATOM   1601  HB3 ALA A  99      52.112  50.889  12.290  1.00  0.00           H  
ATOM   1602  N   ALA A 100      51.716  47.466  13.927  1.00  0.00           N  
ATOM   1603  CA  ALA A 100      51.100  47.228  15.227  1.00  0.00           C  
ATOM   1604  C   ALA A 100      52.097  47.462  16.356  1.00  0.00           C  
ATOM   1605  O   ALA A 100      53.309  47.398  16.152  1.00  0.00           O  
ATOM   1606  CB  ALA A 100      50.542  45.815  15.295  1.00  0.00           C  
ATOM   1607  H   ALA A 100      52.053  46.704  13.411  1.00  0.00           H  
ATOM   1608  HA  ALA A 100      50.277  47.920  15.337  1.00  0.00           H  
ATOM   1609  HB1 ALA A 100      50.430  45.423  14.296  1.00  0.00           H  
ATOM   1610  HB2 ALA A 100      51.223  45.187  15.854  1.00  0.00           H  
ATOM   1611  HB3 ALA A 100      49.581  45.831  15.787  1.00  0.00           H  
TER    1612      ALA A 100                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
