
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   66 ( 1028),  selected   66 , name 2eqj_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2eqj_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    C    12_A      L       3          5.643
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    K    13_A      Q       6          2.062
LGA    -       -      G       7           -
LGA    -       -      D       8           -
LGA    F    14_A      L       9          1.915
LGA    E    15_A      I      10          0.948
LGA    E    16_A      V      11          0.761
LGA    G    17_A      S      12          0.568
LGA    Q    18_A      M      13          0.491
LGA    D    19_A      R      14          0.511
LGA    V    20_A      I      15          0.340
LGA    L    21_A      L      16          0.371
LGA    A    22_A      G      17          0.409
LGA    R    23_A      K      18          0.601
LGA    W    24_A      K      19          1.132
LGA    S    25_A      R      20          1.677
LGA    D    26_A      T      21          1.806
LGA    G    27_A      K      22          1.150
LGA    L    28_A      T      23          1.027
LGA    F    29_A      W      24          0.744
LGA    Y    30_A      X      25          0.745
LGA    L    31_A      K      26          0.598
LGA    G    32_A      G      27          0.292
LGA    T    33_A      T      28          0.293
LGA    I    34_A      L      29          0.541
LGA    K    35_A      I      30          0.375
LGA    K    36_A      A      31          0.440
LGA    I    37_A      I      32          0.525
LGA    N    38_A      Q      33          1.163
LGA    I    39_A      T      34          2.086
LGA    L    40_A      V      35          1.770
LGA    K    41_A      G      36           #
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    Q    42_A      K      39          1.757
LGA    S    43_A      K      40          1.375
LGA    C    44_A      Y      41          1.152
LGA    F    45_A      K      42          1.171
LGA    I    46_A      V      43          0.867
LGA    I    47_A      K      44          0.746
LGA    F    48_A      F      45          0.530
LGA    E    49_A      D      46          1.044
LGA    D    50_A      N      47          1.431
LGA    S    51_A      K      48          4.087
LGA    S    52_A      G      49          1.064
LGA    K    53_A      K      50          0.912
LGA    S    54_A      S      51          0.825
LGA    W    55_A      L      52          0.707
LGA    V    56_A      L      53          1.520
LGA    L    57_A      S      54          1.231
LGA    W    58_A      G      55          0.861
LGA    K    59_A      N      56          0.961
LGA    D    60_A      X      57          0.461
LGA    I    61_A      I      58          0.752
LGA    Q    62_A      A      59          0.554
LGA    T    63_A      Y      60          1.803
LGA    G    64_A      D      61          2.477
LGA    A    65_A      Y      62          4.539
LGA    T    66_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   66   62    5.0     53    1.58    15.09     81.437     3.150

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.051010 * X  +  -0.688842 * Y  +   0.723114 * Z  +  39.312931
  Y_new =   0.879607 * X  +   0.373884 * Y  +   0.294114 * Z  +  69.549973
  Z_new =  -0.472959 * X  +   0.621053 * Y  +   0.624982 * Z  +  -1.675876 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.782245   -2.359348  [ DEG:    44.8193   -135.1807 ]
  Theta =   0.492646    2.648947  [ DEG:    28.2265    151.7735 ]
  Phi   =   1.512869   -1.628724  [ DEG:    86.6810    -93.3190 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eqj_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eqj_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   66   62   5.0   53   1.58   15.09  81.437
REMARK  ---------------------------------------------------------- 
MOLECULE 2eqj_A
HEADER    TRANSCRIPTION                           30-MAR-07   2EQJ              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF METAL-RESPONSE              
TITLE    2 ELEMENT-BINDING TRANSCRIPTION FACTOR 2                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METAL-RESPONSE ELEMENT-BINDING TRANSCRIPTION               
COMPND   3 FACTOR 2;                                                            
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   6 SYNONYM: ZINC-REGULATED FACTOR 1, ZIRF1, METAL-RESPONSE              
COMPND   7 ELEMENT DNA-BINDING PROTEIN M96, METAL-REGULATORY                    
COMPND   8 TRANSCRIPTION FACTOR 2, PCL2;                                        
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: MTF2;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P061002-01;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR,STRUCTURE GENOMICS,TUDOR DOMAIN, METAL-RESPONSE ELEMENT-          
KEYWDS   2 BINDING TRANSCRIPTION FACTOR 2, ZINC-REGULATED FACTOR 1,             
KEYWDS   3 ZIRF1, METAL-RESPONSE ELEMENT DNA-BINDING PROTEIN M96,               
KEYWDS   4 METAL-REGULATORY TRANSCRIPTION FACTOR 2, PCL2, STRUCTURAL            
KEYWDS   5 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   6 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   7 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,K.ISONO,S.WATANABE,T.TARADA,T.KIGAWA,H.KOSEKI,          
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   08-APR-08 2EQJ    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,K.ISONO,S.WATANABE,T.TARADA,T.KIGAWA,          
JRNL        AUTH 2 H.KOSEKI,S.YOKOYAMA                                          
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF                    
JRNL        TITL 2 METAL-RESPONSE ELEMENT-BINDING TRANSCRIPTION                 
JRNL        TITL 3 FACTOR 2                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQJ A    8    66  UNP    Q02395   MTF2_MOUSE      40     98             
SEQRES   1 A   66  GLY SER SER GLY SER SER GLY LYS LYS PRO ALA CYS LYS          
SEQRES   2 A   66  PHE GLU GLU GLY GLN ASP VAL LEU ALA ARG TRP SER ASP          
SEQRES   3 A   66  GLY LEU PHE TYR LEU GLY THR ILE LYS LYS ILE ASN ILE          
SEQRES   4 A   66  LEU LYS GLN SER CYS PHE ILE ILE PHE GLU ASP SER SER          
SEQRES   5 A   66  LYS SER TRP VAL LEU TRP LYS ASP ILE GLN THR GLY ALA          
SEQRES   6 A   66  THR                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      26.144  90.245 -24.294  1.00  0.00           N  
ATOM      2  CA  GLY A   1      25.975  90.244 -25.737  1.00  0.00           C  
ATOM      3  C   GLY A   1      27.286  90.427 -26.474  1.00  0.00           C  
ATOM      4  O   GLY A   1      28.350  90.080 -25.960  1.00  0.00           O  
ATOM      5  H1  GLY A   1      25.936  91.051 -23.778  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      25.533  89.305 -26.035  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      25.306  91.047 -26.008  1.00  0.00           H  
ATOM      8  N   SER A   2      27.211  90.973 -27.684  1.00  0.00           N  
ATOM      9  CA  SER A   2      28.400  91.197 -28.497  1.00  0.00           C  
ATOM     10  C   SER A   2      29.247  92.328 -27.921  1.00  0.00           C  
ATOM     11  O   SER A   2      30.427  92.145 -27.622  1.00  0.00           O  
ATOM     12  CB  SER A   2      28.006  91.523 -29.938  1.00  0.00           C  
ATOM     13  OG  SER A   2      27.712  90.343 -30.666  1.00  0.00           O  
ATOM     14  H   SER A   2      26.334  91.229 -28.039  1.00  0.00           H  
ATOM     15  HA  SER A   2      28.983  90.288 -28.489  1.00  0.00           H  
ATOM     16  HB2 SER A   2      27.131  92.156 -29.934  1.00  0.00           H  
ATOM     17  HB3 SER A   2      28.822  92.039 -30.424  1.00  0.00           H  
ATOM     18  HG  SER A   2      26.960  90.501 -31.242  1.00  0.00           H  
ATOM     19  N   SER A   3      28.635  93.498 -27.768  1.00  0.00           N  
ATOM     20  CA  SER A   3      29.331  94.662 -27.232  1.00  0.00           C  
ATOM     21  C   SER A   3      29.608  94.490 -25.741  1.00  0.00           C  
ATOM     22  O   SER A   3      28.707  94.612 -24.913  1.00  0.00           O  
ATOM     23  CB  SER A   3      28.507  95.929 -27.466  1.00  0.00           C  
ATOM     24  OG  SER A   3      28.659  96.397 -28.795  1.00  0.00           O  
ATOM     25  H   SER A   3      27.692  93.581 -28.025  1.00  0.00           H  
ATOM     26  HA  SER A   3      30.273  94.753 -27.753  1.00  0.00           H  
ATOM     27  HB2 SER A   3      27.464  95.714 -27.290  1.00  0.00           H  
ATOM     28  HB3 SER A   3      28.837  96.700 -26.785  1.00  0.00           H  
ATOM     29  HG  SER A   3      29.547  96.203 -29.104  1.00  0.00           H  
ATOM     30  N   GLY A   4      30.864  94.205 -25.409  1.00  0.00           N  
ATOM     31  CA  GLY A   4      31.238  94.020 -24.017  1.00  0.00           C  
ATOM     32  C   GLY A   4      31.269  92.559 -23.615  1.00  0.00           C  
ATOM     33  O   GLY A   4      31.037  91.675 -24.440  1.00  0.00           O  
ATOM     34  H   GLY A   4      31.541  94.119 -26.112  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      32.218  94.447 -23.861  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      30.526  94.539 -23.393  1.00  0.00           H  
ATOM     37  N   SER A   5      31.554  92.304 -22.342  1.00  0.00           N  
ATOM     38  CA  SER A   5      31.619  90.940 -21.832  1.00  0.00           C  
ATOM     39  C   SER A   5      30.350  90.587 -21.061  1.00  0.00           C  
ATOM     40  O   SER A   5      29.904  91.344 -20.199  1.00  0.00           O  
ATOM     41  CB  SER A   5      32.843  90.767 -20.930  1.00  0.00           C  
ATOM     42  OG  SER A   5      34.025  91.189 -21.588  1.00  0.00           O  
ATOM     43  H   SER A   5      31.727  93.051 -21.732  1.00  0.00           H  
ATOM     44  HA  SER A   5      31.709  90.273 -22.677  1.00  0.00           H  
ATOM     45  HB2 SER A   5      32.713  91.357 -20.035  1.00  0.00           H  
ATOM     46  HB3 SER A   5      32.946  89.725 -20.663  1.00  0.00           H  
ATOM     47  HG  SER A   5      34.089  92.147 -21.547  1.00  0.00           H  
ATOM     48  N   SER A   6      29.775  89.431 -21.377  1.00  0.00           N  
ATOM     49  CA  SER A   6      28.555  88.979 -20.717  1.00  0.00           C  
ATOM     50  C   SER A   6      28.818  87.721 -19.896  1.00  0.00           C  
ATOM     51  O   SER A   6      29.207  86.685 -20.432  1.00  0.00           O  
ATOM     52  CB  SER A   6      27.461  88.707 -21.752  1.00  0.00           C  
ATOM     53  OG  SER A   6      27.855  87.687 -22.654  1.00  0.00           O  
ATOM     54  H   SER A   6      30.178  88.871 -22.073  1.00  0.00           H  
ATOM     55  HA  SER A   6      28.225  89.765 -20.056  1.00  0.00           H  
ATOM     56  HB2 SER A   6      26.560  88.394 -21.246  1.00  0.00           H  
ATOM     57  HB3 SER A   6      27.266  89.610 -22.311  1.00  0.00           H  
ATOM     58  HG  SER A   6      28.488  87.107 -22.225  1.00  0.00           H  
ATOM     59  N   GLY A   7      28.600  87.821 -18.587  1.00  0.00           N  
ATOM     60  CA  GLY A   7      28.819  86.685 -17.710  1.00  0.00           C  
ATOM     61  C   GLY A   7      30.146  86.760 -16.982  1.00  0.00           C  
ATOM     62  O   GLY A   7      30.983  87.610 -17.288  1.00  0.00           O  
ATOM     63  H   GLY A   7      28.290  88.672 -18.215  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      28.022  86.648 -16.982  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      28.796  85.780 -18.299  1.00  0.00           H  
ATOM     66  N   LYS A   8      30.340  85.871 -16.015  1.00  0.00           N  
ATOM     67  CA  LYS A   8      31.575  85.840 -15.240  1.00  0.00           C  
ATOM     68  C   LYS A   8      31.592  84.644 -14.293  1.00  0.00           C  
ATOM     69  O   LYS A   8      30.563  84.267 -13.732  1.00  0.00           O  
ATOM     70  CB  LYS A   8      31.734  87.137 -14.443  1.00  0.00           C  
ATOM     71  CG  LYS A   8      33.177  87.463 -14.096  1.00  0.00           C  
ATOM     72  CD  LYS A   8      33.269  88.669 -13.176  1.00  0.00           C  
ATOM     73  CE  LYS A   8      34.643  88.776 -12.533  1.00  0.00           C  
ATOM     74  NZ  LYS A   8      34.616  89.610 -11.301  1.00  0.00           N  
ATOM     75  H   LYS A   8      29.634  85.219 -15.817  1.00  0.00           H  
ATOM     76  HA  LYS A   8      32.398  85.748 -15.931  1.00  0.00           H  
ATOM     77  HB2 LYS A   8      31.332  87.953 -15.025  1.00  0.00           H  
ATOM     78  HB3 LYS A   8      31.174  87.051 -13.523  1.00  0.00           H  
ATOM     79  HG2 LYS A   8      33.620  86.612 -13.602  1.00  0.00           H  
ATOM     80  HG3 LYS A   8      33.718  87.674 -15.007  1.00  0.00           H  
ATOM     81  HD2 LYS A   8      33.083  89.565 -13.750  1.00  0.00           H  
ATOM     82  HD3 LYS A   8      32.524  88.576 -12.398  1.00  0.00           H  
ATOM     83  HE2 LYS A   8      34.985  87.784 -12.279  1.00  0.00           H  
ATOM     84  HE3 LYS A   8      35.324  89.219 -13.244  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8      33.634  89.817 -11.030  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8      35.115  90.508 -11.466  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8      35.081  89.108 -10.518  1.00  0.00           H  
ATOM     88  N   LYS A   9      32.769  84.051 -14.117  1.00  0.00           N  
ATOM     89  CA  LYS A   9      32.921  82.900 -13.236  1.00  0.00           C  
ATOM     90  C   LYS A   9      33.438  83.328 -11.865  1.00  0.00           C  
ATOM     91  O   LYS A   9      34.198  84.288 -11.734  1.00  0.00           O  
ATOM     92  CB  LYS A   9      33.879  81.880 -13.857  1.00  0.00           C  
ATOM     93  CG  LYS A   9      33.244  81.038 -14.950  1.00  0.00           C  
ATOM     94  CD  LYS A   9      32.506  79.841 -14.373  1.00  0.00           C  
ATOM     95  CE  LYS A   9      31.776  79.062 -15.456  1.00  0.00           C  
ATOM     96  NZ  LYS A   9      31.054  77.883 -14.902  1.00  0.00           N  
ATOM     97  H   LYS A   9      33.554  84.398 -14.591  1.00  0.00           H  
ATOM     98  HA  LYS A   9      31.951  82.444 -13.114  1.00  0.00           H  
ATOM     99  HB2 LYS A   9      34.721  82.407 -14.281  1.00  0.00           H  
ATOM    100  HB3 LYS A   9      34.232  81.218 -13.081  1.00  0.00           H  
ATOM    101  HG2 LYS A   9      32.544  81.647 -15.500  1.00  0.00           H  
ATOM    102  HG3 LYS A   9      34.019  80.685 -15.615  1.00  0.00           H  
ATOM    103  HD2 LYS A   9      33.218  79.187 -13.893  1.00  0.00           H  
ATOM    104  HD3 LYS A   9      31.787  80.189 -13.646  1.00  0.00           H  
ATOM    105  HE2 LYS A   9      31.064  79.717 -15.935  1.00  0.00           H  
ATOM    106  HE3 LYS A   9      32.497  78.721 -16.185  1.00  0.00           H  
ATOM    107  HZ1 LYS A   9      30.814  78.049 -13.903  1.00  0.00           H  
ATOM    108  HZ2 LYS A   9      31.651  77.035 -14.968  1.00  0.00           H  
ATOM    109  HZ3 LYS A   9      30.177  77.718 -15.435  1.00  0.00           H  
ATOM    110  N   PRO A  10      33.018  82.601 -10.819  1.00  0.00           N  
ATOM    111  CA  PRO A  10      33.428  82.886  -9.442  1.00  0.00           C  
ATOM    112  C   PRO A  10      34.899  82.569  -9.197  1.00  0.00           C  
ATOM    113  O   PRO A  10      35.544  81.906 -10.008  1.00  0.00           O  
ATOM    114  CB  PRO A  10      32.535  81.962  -8.608  1.00  0.00           C  
ATOM    115  CG  PRO A  10      32.187  80.843  -9.527  1.00  0.00           C  
ATOM    116  CD  PRO A  10      32.112  81.443 -10.903  1.00  0.00           C  
ATOM    117  HA  PRO A  10      33.233  83.915  -9.174  1.00  0.00           H  
ATOM    118  HB2 PRO A  10      33.084  81.611  -7.745  1.00  0.00           H  
ATOM    119  HB3 PRO A  10      31.655  82.499  -8.288  1.00  0.00           H  
ATOM    120  HG2 PRO A  10      32.956  80.085  -9.490  1.00  0.00           H  
ATOM    121  HG3 PRO A  10      31.232  80.423  -9.248  1.00  0.00           H  
ATOM    122  HD2 PRO A  10      32.455  80.736 -11.643  1.00  0.00           H  
ATOM    123  HD3 PRO A  10      31.102  81.761 -11.121  1.00  0.00           H  
ATOM    124  N   ALA A  11      35.423  83.047  -8.073  1.00  0.00           N  
ATOM    125  CA  ALA A  11      36.818  82.812  -7.720  1.00  0.00           C  
ATOM    126  C   ALA A  11      36.962  81.566  -6.853  1.00  0.00           C  
ATOM    127  O   ALA A  11      36.012  81.145  -6.192  1.00  0.00           O  
ATOM    128  CB  ALA A  11      37.393  84.025  -7.005  1.00  0.00           C  
ATOM    129  H   ALA A  11      34.858  83.568  -7.466  1.00  0.00           H  
ATOM    130  HA  ALA A  11      37.374  82.668  -8.636  1.00  0.00           H  
ATOM    131  HB1 ALA A  11      36.598  84.559  -6.507  1.00  0.00           H  
ATOM    132  HB2 ALA A  11      38.122  83.700  -6.277  1.00  0.00           H  
ATOM    133  HB3 ALA A  11      37.869  84.675  -7.725  1.00  0.00           H  
ATOM    134  N   CYS A  12      38.154  80.982  -6.859  1.00  0.00           N  
ATOM    135  CA  CYS A  12      38.423  79.783  -6.073  1.00  0.00           C  
ATOM    136  C   CYS A  12      38.624  80.130  -4.602  1.00  0.00           C  
ATOM    137  O   CYS A  12      39.748  80.122  -4.098  1.00  0.00           O  
ATOM    138  CB  CYS A  12      39.659  79.060  -6.612  1.00  0.00           C  
ATOM    139  SG  CYS A  12      41.152  80.078  -6.649  1.00  0.00           S  
ATOM    140  H   CYS A  12      38.872  81.364  -7.406  1.00  0.00           H  
ATOM    141  HA  CYS A  12      37.568  79.131  -6.162  1.00  0.00           H  
ATOM    142  HB2 CYS A  12      39.863  78.199  -5.991  1.00  0.00           H  
ATOM    143  HB3 CYS A  12      39.461  78.728  -7.620  1.00  0.00           H  
ATOM    144  HG  CYS A  12      41.829  79.770  -7.744  1.00  0.00           H  
ATOM    145  N   LYS A  13      37.528  80.438  -3.917  1.00  0.00           N  
ATOM    146  CA  LYS A  13      37.582  80.790  -2.503  1.00  0.00           C  
ATOM    147  C   LYS A  13      38.533  79.867  -1.749  1.00  0.00           C  
ATOM    148  O   LYS A  13      39.204  80.287  -0.805  1.00  0.00           O  
ATOM    149  CB  LYS A  13      36.184  80.716  -1.884  1.00  0.00           C  
ATOM    150  CG  LYS A  13      35.559  79.334  -1.958  1.00  0.00           C  
ATOM    151  CD  LYS A  13      34.110  79.352  -1.501  1.00  0.00           C  
ATOM    152  CE  LYS A  13      33.601  77.950  -1.204  1.00  0.00           C  
ATOM    153  NZ  LYS A  13      33.900  77.537   0.195  1.00  0.00           N  
ATOM    154  H   LYS A  13      36.660  80.428  -4.374  1.00  0.00           H  
ATOM    155  HA  LYS A  13      37.946  81.803  -2.427  1.00  0.00           H  
ATOM    156  HB2 LYS A  13      36.248  81.005  -0.845  1.00  0.00           H  
ATOM    157  HB3 LYS A  13      35.536  81.409  -2.402  1.00  0.00           H  
ATOM    158  HG2 LYS A  13      35.599  78.984  -2.978  1.00  0.00           H  
ATOM    159  HG3 LYS A  13      36.118  78.662  -1.322  1.00  0.00           H  
ATOM    160  HD2 LYS A  13      34.031  79.949  -0.604  1.00  0.00           H  
ATOM    161  HD3 LYS A  13      33.501  79.789  -2.281  1.00  0.00           H  
ATOM    162  HE2 LYS A  13      32.532  77.929  -1.356  1.00  0.00           H  
ATOM    163  HE3 LYS A  13      34.075  77.259  -1.884  1.00  0.00           H  
ATOM    164  HZ1 LYS A  13      34.920  77.613   0.380  1.00  0.00           H  
ATOM    165  HZ2 LYS A  13      33.604  76.551   0.347  1.00  0.00           H  
ATOM    166  HZ3 LYS A  13      33.390  78.147   0.865  1.00  0.00           H  
ATOM    167  N   PHE A  14      38.587  78.608  -2.170  1.00  0.00           N  
ATOM    168  CA  PHE A  14      39.456  77.626  -1.535  1.00  0.00           C  
ATOM    169  C   PHE A  14      40.894  78.133  -1.471  1.00  0.00           C  
ATOM    170  O   PHE A  14      41.215  79.188  -2.014  1.00  0.00           O  
ATOM    171  CB  PHE A  14      39.405  76.299  -2.296  1.00  0.00           C  
ATOM    172  CG  PHE A  14      38.139  75.525  -2.065  1.00  0.00           C  
ATOM    173  CD1 PHE A  14      38.038  74.633  -1.009  1.00  0.00           C  
ATOM    174  CD2 PHE A  14      37.048  75.688  -2.904  1.00  0.00           C  
ATOM    175  CE1 PHE A  14      36.874  73.920  -0.795  1.00  0.00           C  
ATOM    176  CE2 PHE A  14      35.882  74.978  -2.696  1.00  0.00           C  
ATOM    177  CZ  PHE A  14      35.794  74.093  -1.638  1.00  0.00           C  
ATOM    178  H   PHE A  14      38.028  78.333  -2.927  1.00  0.00           H  
ATOM    179  HA  PHE A  14      39.098  77.468  -0.529  1.00  0.00           H  
ATOM    180  HB2 PHE A  14      39.486  76.496  -3.354  1.00  0.00           H  
ATOM    181  HB3 PHE A  14      40.234  75.682  -1.984  1.00  0.00           H  
ATOM    182  HD1 PHE A  14      38.881  74.498  -0.347  1.00  0.00           H  
ATOM    183  HD2 PHE A  14      37.116  76.381  -3.731  1.00  0.00           H  
ATOM    184  HE1 PHE A  14      36.808  73.229   0.032  1.00  0.00           H  
ATOM    185  HE2 PHE A  14      35.039  75.116  -3.357  1.00  0.00           H  
ATOM    186  HZ  PHE A  14      34.884  73.536  -1.474  1.00  0.00           H  
ATOM    187  N   GLU A  15      41.755  77.371  -0.803  1.00  0.00           N  
ATOM    188  CA  GLU A  15      43.158  77.743  -0.667  1.00  0.00           C  
ATOM    189  C   GLU A  15      44.069  76.562  -0.990  1.00  0.00           C  
ATOM    190  O   GLU A  15      43.719  75.410  -0.739  1.00  0.00           O  
ATOM    191  CB  GLU A  15      43.441  78.246   0.751  1.00  0.00           C  
ATOM    192  CG  GLU A  15      44.875  78.699   0.961  1.00  0.00           C  
ATOM    193  CD  GLU A  15      45.778  77.576   1.432  1.00  0.00           C  
ATOM    194  OE1 GLU A  15      45.464  76.402   1.148  1.00  0.00           O  
ATOM    195  OE2 GLU A  15      46.802  77.872   2.084  1.00  0.00           O  
ATOM    196  H   GLU A  15      41.439  76.539  -0.392  1.00  0.00           H  
ATOM    197  HA  GLU A  15      43.360  78.540  -1.368  1.00  0.00           H  
ATOM    198  HB2 GLU A  15      42.787  79.079   0.962  1.00  0.00           H  
ATOM    199  HB3 GLU A  15      43.231  77.450   1.450  1.00  0.00           H  
ATOM    200  HG2 GLU A  15      45.259  79.082   0.028  1.00  0.00           H  
ATOM    201  HG3 GLU A  15      44.886  79.485   1.703  1.00  0.00           H  
ATOM    202  N   GLU A  16      45.238  76.859  -1.549  1.00  0.00           N  
ATOM    203  CA  GLU A  16      46.198  75.822  -1.907  1.00  0.00           C  
ATOM    204  C   GLU A  16      47.026  75.405  -0.696  1.00  0.00           C  
ATOM    205  O   GLU A  16      47.708  76.226  -0.084  1.00  0.00           O  
ATOM    206  CB  GLU A  16      47.120  76.314  -3.025  1.00  0.00           C  
ATOM    207  CG  GLU A  16      46.463  76.329  -4.394  1.00  0.00           C  
ATOM    208  CD  GLU A  16      47.389  76.841  -5.481  1.00  0.00           C  
ATOM    209  OE1 GLU A  16      47.996  77.915  -5.285  1.00  0.00           O  
ATOM    210  OE2 GLU A  16      47.505  76.168  -6.526  1.00  0.00           O  
ATOM    211  H   GLU A  16      45.460  77.798  -1.723  1.00  0.00           H  
ATOM    212  HA  GLU A  16      45.644  74.966  -2.262  1.00  0.00           H  
ATOM    213  HB2 GLU A  16      47.443  77.317  -2.792  1.00  0.00           H  
ATOM    214  HB3 GLU A  16      47.986  75.668  -3.071  1.00  0.00           H  
ATOM    215  HG2 GLU A  16      46.161  75.323  -4.645  1.00  0.00           H  
ATOM    216  HG3 GLU A  16      45.591  76.966  -4.355  1.00  0.00           H  
ATOM    217  N   GLY A  17      46.961  74.121  -0.355  1.00  0.00           N  
ATOM    218  CA  GLY A  17      47.710  73.617   0.782  1.00  0.00           C  
ATOM    219  C   GLY A  17      46.901  73.641   2.064  1.00  0.00           C  
ATOM    220  O   GLY A  17      47.459  73.550   3.158  1.00  0.00           O  
ATOM    221  H   GLY A  17      46.401  73.512  -0.880  1.00  0.00           H  
ATOM    222  HA2 GLY A  17      48.010  72.600   0.578  1.00  0.00           H  
ATOM    223  HA3 GLY A  17      48.593  74.224   0.915  1.00  0.00           H  
ATOM    224  N   GLN A  18      45.585  73.767   1.931  1.00  0.00           N  
ATOM    225  CA  GLN A  18      44.700  73.807   3.089  1.00  0.00           C  
ATOM    226  C   GLN A  18      44.112  72.429   3.371  1.00  0.00           C  
ATOM    227  O   GLN A  18      43.481  71.823   2.504  1.00  0.00           O  
ATOM    228  CB  GLN A  18      43.575  74.819   2.863  1.00  0.00           C  
ATOM    229  CG  GLN A  18      42.502  74.784   3.938  1.00  0.00           C  
ATOM    230  CD  GLN A  18      41.622  76.019   3.925  1.00  0.00           C  
ATOM    231  OE1 GLN A  18      42.087  77.129   4.184  1.00  0.00           O  
ATOM    232  NE2 GLN A  18      40.343  75.832   3.623  1.00  0.00           N  
ATOM    233  H   GLN A  18      45.201  73.837   1.032  1.00  0.00           H  
ATOM    234  HA  GLN A  18      45.284  74.117   3.942  1.00  0.00           H  
ATOM    235  HB2 GLN A  18      43.999  75.811   2.839  1.00  0.00           H  
ATOM    236  HB3 GLN A  18      43.107  74.613   1.912  1.00  0.00           H  
ATOM    237  HG2 GLN A  18      41.878  73.916   3.780  1.00  0.00           H  
ATOM    238  HG3 GLN A  18      42.980  74.710   4.904  1.00  0.00           H  
ATOM    239 HE21 GLN A  18      40.042  74.918   3.430  1.00  0.00           H  
ATOM    240 HE22 GLN A  18      39.751  76.612   3.608  1.00  0.00           H  
ATOM    241  N   ASP A  19      44.322  71.940   4.588  1.00  0.00           N  
ATOM    242  CA  ASP A  19      43.812  70.632   4.985  1.00  0.00           C  
ATOM    243  C   ASP A  19      42.299  70.673   5.170  1.00  0.00           C  
ATOM    244  O   ASP A  19      41.781  71.449   5.974  1.00  0.00           O  
ATOM    245  CB  ASP A  19      44.484  70.170   6.279  1.00  0.00           C  
ATOM    246  CG  ASP A  19      45.943  70.575   6.350  1.00  0.00           C  
ATOM    247  OD1 ASP A  19      46.629  70.506   5.309  1.00  0.00           O  
ATOM    248  OD2 ASP A  19      46.400  70.961   7.446  1.00  0.00           O  
ATOM    249  H   ASP A  19      44.833  72.470   5.234  1.00  0.00           H  
ATOM    250  HA  ASP A  19      44.047  69.932   4.199  1.00  0.00           H  
ATOM    251  HB2 ASP A  19      43.967  70.608   7.122  1.00  0.00           H  
ATOM    252  HB3 ASP A  19      44.424  69.094   6.344  1.00  0.00           H  
ATOM    253  N   VAL A  20      41.593  69.833   4.419  1.00  0.00           N  
ATOM    254  CA  VAL A  20      40.138  69.773   4.500  1.00  0.00           C  
ATOM    255  C   VAL A  20      39.640  68.336   4.392  1.00  0.00           C  
ATOM    256  O   VAL A  20      40.419  67.415   4.144  1.00  0.00           O  
ATOM    257  CB  VAL A  20      39.479  70.617   3.393  1.00  0.00           C  
ATOM    258  CG1 VAL A  20      39.789  72.094   3.592  1.00  0.00           C  
ATOM    259  CG2 VAL A  20      39.938  70.148   2.021  1.00  0.00           C  
ATOM    260  H   VAL A  20      42.061  69.239   3.796  1.00  0.00           H  
ATOM    261  HA  VAL A  20      39.840  70.176   5.457  1.00  0.00           H  
ATOM    262  HB  VAL A  20      38.409  70.485   3.457  1.00  0.00           H  
ATOM    263 HG11 VAL A  20      40.325  72.227   4.520  1.00  0.00           H  
ATOM    264 HG12 VAL A  20      40.395  72.448   2.771  1.00  0.00           H  
ATOM    265 HG13 VAL A  20      38.867  72.653   3.627  1.00  0.00           H  
ATOM    266 HG21 VAL A  20      40.843  69.570   2.122  1.00  0.00           H  
ATOM    267 HG22 VAL A  20      39.167  69.537   1.574  1.00  0.00           H  
ATOM    268 HG23 VAL A  20      40.126  71.005   1.391  1.00  0.00           H  
ATOM    269  N   LEU A  21      38.338  68.152   4.579  1.00  0.00           N  
ATOM    270  CA  LEU A  21      37.735  66.825   4.502  1.00  0.00           C  
ATOM    271  C   LEU A  21      36.996  66.639   3.179  1.00  0.00           C  
ATOM    272  O   LEU A  21      35.990  67.299   2.921  1.00  0.00           O  
ATOM    273  CB  LEU A  21      36.772  66.613   5.671  1.00  0.00           C  
ATOM    274  CG  LEU A  21      37.418  66.315   7.025  1.00  0.00           C  
ATOM    275  CD1 LEU A  21      36.399  66.461   8.145  1.00  0.00           C  
ATOM    276  CD2 LEU A  21      38.024  64.920   7.032  1.00  0.00           C  
ATOM    277  H   LEU A  21      37.768  68.923   4.773  1.00  0.00           H  
ATOM    278  HA  LEU A  21      38.529  66.097   4.562  1.00  0.00           H  
ATOM    279  HB2 LEU A  21      36.178  67.507   5.777  1.00  0.00           H  
ATOM    280  HB3 LEU A  21      36.128  65.782   5.421  1.00  0.00           H  
ATOM    281  HG  LEU A  21      38.211  67.027   7.203  1.00  0.00           H  
ATOM    282 HD11 LEU A  21      35.642  67.174   7.853  1.00  0.00           H  
ATOM    283 HD12 LEU A  21      36.894  66.807   9.040  1.00  0.00           H  
ATOM    284 HD13 LEU A  21      35.936  65.504   8.337  1.00  0.00           H  
ATOM    285 HD21 LEU A  21      37.240  64.186   6.912  1.00  0.00           H  
ATOM    286 HD22 LEU A  21      38.533  64.754   7.970  1.00  0.00           H  
ATOM    287 HD23 LEU A  21      38.730  64.831   6.219  1.00  0.00           H  
ATOM    288  N   ALA A  22      37.503  65.735   2.347  1.00  0.00           N  
ATOM    289  CA  ALA A  22      36.889  65.459   1.054  1.00  0.00           C  
ATOM    290  C   ALA A  22      36.072  64.172   1.098  1.00  0.00           C  
ATOM    291  O   ALA A  22      36.445  63.212   1.772  1.00  0.00           O  
ATOM    292  CB  ALA A  22      37.954  65.375  -0.029  1.00  0.00           C  
ATOM    293  H   ALA A  22      38.307  65.242   2.610  1.00  0.00           H  
ATOM    294  HA  ALA A  22      36.231  66.283   0.815  1.00  0.00           H  
ATOM    295  HB1 ALA A  22      38.185  66.367  -0.384  1.00  0.00           H  
ATOM    296  HB2 ALA A  22      38.845  64.921   0.380  1.00  0.00           H  
ATOM    297  HB3 ALA A  22      37.587  64.775  -0.848  1.00  0.00           H  
ATOM    298  N   ARG A  23      34.957  64.159   0.376  1.00  0.00           N  
ATOM    299  CA  ARG A  23      34.087  62.990   0.333  1.00  0.00           C  
ATOM    300  C   ARG A  23      34.477  62.064  -0.815  1.00  0.00           C  
ATOM    301  O   ARG A  23      34.341  62.420  -1.985  1.00  0.00           O  
ATOM    302  CB  ARG A  23      32.626  63.420   0.184  1.00  0.00           C  
ATOM    303  CG  ARG A  23      31.632  62.375   0.665  1.00  0.00           C  
ATOM    304  CD  ARG A  23      30.325  62.454  -0.107  1.00  0.00           C  
ATOM    305  NE  ARG A  23      30.525  62.291  -1.544  1.00  0.00           N  
ATOM    306  CZ  ARG A  23      29.541  62.342  -2.434  1.00  0.00           C  
ATOM    307  NH1 ARG A  23      28.294  62.553  -2.038  1.00  0.00           N  
ATOM    308  NH2 ARG A  23      29.804  62.184  -3.725  1.00  0.00           N  
ATOM    309  H   ARG A  23      34.713  64.955  -0.141  1.00  0.00           H  
ATOM    310  HA  ARG A  23      34.202  62.457   1.265  1.00  0.00           H  
ATOM    311  HB2 ARG A  23      32.469  64.324   0.753  1.00  0.00           H  
ATOM    312  HB3 ARG A  23      32.429  63.621  -0.858  1.00  0.00           H  
ATOM    313  HG2 ARG A  23      32.060  61.394   0.526  1.00  0.00           H  
ATOM    314  HG3 ARG A  23      31.432  62.539   1.713  1.00  0.00           H  
ATOM    315  HD2 ARG A  23      29.666  61.675   0.246  1.00  0.00           H  
ATOM    316  HD3 ARG A  23      29.871  63.418   0.076  1.00  0.00           H  
ATOM    317  HE  ARG A  23      31.440  62.134  -1.859  1.00  0.00           H  
ATOM    318 HH11 ARG A  23      28.093  62.674  -1.066  1.00  0.00           H  
ATOM    319 HH12 ARG A  23      27.556  62.593  -2.711  1.00  0.00           H  
ATOM    320 HH21 ARG A  23      30.744  62.024  -4.028  1.00  0.00           H  
ATOM    321 HH22 ARG A  23      29.063  62.223  -4.395  1.00  0.00           H  
ATOM    322  N   TRP A  24      34.960  60.875  -0.472  1.00  0.00           N  
ATOM    323  CA  TRP A  24      35.369  59.898  -1.473  1.00  0.00           C  
ATOM    324  C   TRP A  24      34.159  59.334  -2.209  1.00  0.00           C  
ATOM    325  O   TRP A  24      33.015  59.597  -1.837  1.00  0.00           O  
ATOM    326  CB  TRP A  24      36.157  58.763  -0.817  1.00  0.00           C  
ATOM    327  CG  TRP A  24      37.640  58.984  -0.835  1.00  0.00           C  
ATOM    328  CD1 TRP A  24      38.389  59.600   0.127  1.00  0.00           C  
ATOM    329  CD2 TRP A  24      38.553  58.589  -1.866  1.00  0.00           C  
ATOM    330  NE1 TRP A  24      39.712  59.613  -0.244  1.00  0.00           N  
ATOM    331  CE2 TRP A  24      39.839  58.999  -1.462  1.00  0.00           C  
ATOM    332  CE3 TRP A  24      38.410  57.930  -3.089  1.00  0.00           C  
ATOM    333  CZ2 TRP A  24      40.970  58.770  -2.239  1.00  0.00           C  
ATOM    334  CZ3 TRP A  24      39.534  57.704  -3.860  1.00  0.00           C  
ATOM    335  CH2 TRP A  24      40.801  58.122  -3.433  1.00  0.00           C  
ATOM    336  H   TRP A  24      35.044  60.649   0.479  1.00  0.00           H  
ATOM    337  HA  TRP A  24      36.006  60.402  -2.186  1.00  0.00           H  
ATOM    338  HB2 TRP A  24      35.848  58.666   0.212  1.00  0.00           H  
ATOM    339  HB3 TRP A  24      35.951  57.841  -1.341  1.00  0.00           H  
ATOM    340  HD1 TRP A  24      37.986  60.013   1.038  1.00  0.00           H  
ATOM    341  HE1 TRP A  24      40.445  59.999   0.280  1.00  0.00           H  
ATOM    342  HE3 TRP A  24      37.441  57.600  -3.435  1.00  0.00           H  
ATOM    343  HZ2 TRP A  24      41.955  59.086  -1.924  1.00  0.00           H  
ATOM    344  HZ3 TRP A  24      39.442  57.195  -4.809  1.00  0.00           H  
ATOM    345  HH2 TRP A  24      41.652  57.925  -4.066  1.00  0.00           H  
ATOM    346  N   SER A  25      34.418  58.555  -3.256  1.00  0.00           N  
ATOM    347  CA  SER A  25      33.348  57.956  -4.045  1.00  0.00           C  
ATOM    348  C   SER A  25      32.423  57.122  -3.163  1.00  0.00           C  
ATOM    349  O   SER A  25      31.230  56.998  -3.440  1.00  0.00           O  
ATOM    350  CB  SER A  25      33.934  57.083  -5.157  1.00  0.00           C  
ATOM    351  OG  SER A  25      34.214  57.851  -6.313  1.00  0.00           O  
ATOM    352  H   SER A  25      35.351  58.381  -3.503  1.00  0.00           H  
ATOM    353  HA  SER A  25      32.777  58.755  -4.491  1.00  0.00           H  
ATOM    354  HB2 SER A  25      34.850  56.630  -4.810  1.00  0.00           H  
ATOM    355  HB3 SER A  25      33.225  56.310  -5.415  1.00  0.00           H  
ATOM    356  HG  SER A  25      33.425  57.911  -6.858  1.00  0.00           H  
ATOM    357  N   ASP A  26      32.983  56.553  -2.101  1.00  0.00           N  
ATOM    358  CA  ASP A  26      32.209  55.732  -1.177  1.00  0.00           C  
ATOM    359  C   ASP A  26      31.102  56.550  -0.519  1.00  0.00           C  
ATOM    360  O   ASP A  26      30.019  56.038  -0.243  1.00  0.00           O  
ATOM    361  CB  ASP A  26      33.123  55.133  -0.107  1.00  0.00           C  
ATOM    362  CG  ASP A  26      33.911  53.944  -0.618  1.00  0.00           C  
ATOM    363  OD1 ASP A  26      33.430  53.272  -1.555  1.00  0.00           O  
ATOM    364  OD2 ASP A  26      35.008  53.682  -0.081  1.00  0.00           O  
ATOM    365  H   ASP A  26      33.939  56.690  -1.934  1.00  0.00           H  
ATOM    366  HA  ASP A  26      31.759  54.931  -1.743  1.00  0.00           H  
ATOM    367  HB2 ASP A  26      33.820  55.887   0.225  1.00  0.00           H  
ATOM    368  HB3 ASP A  26      32.522  54.811   0.730  1.00  0.00           H  
ATOM    369  N   GLY A  27      31.384  57.825  -0.271  1.00  0.00           N  
ATOM    370  CA  GLY A  27      30.403  58.694   0.354  1.00  0.00           C  
ATOM    371  C   GLY A  27      30.874  59.235   1.689  1.00  0.00           C  
ATOM    372  O   GLY A  27      30.277  60.163   2.238  1.00  0.00           O  
ATOM    373  H   GLY A  27      32.265  58.180  -0.513  1.00  0.00           H  
ATOM    374  HA2 GLY A  27      30.199  59.522  -0.307  1.00  0.00           H  
ATOM    375  HA3 GLY A  27      29.491  58.135   0.507  1.00  0.00           H  
ATOM    376  N   LEU A  28      31.947  58.655   2.215  1.00  0.00           N  
ATOM    377  CA  LEU A  28      32.498  59.084   3.496  1.00  0.00           C  
ATOM    378  C   LEU A  28      33.529  60.192   3.302  1.00  0.00           C  
ATOM    379  O   LEU A  28      34.122  60.322   2.231  1.00  0.00           O  
ATOM    380  CB  LEU A  28      33.137  57.898   4.221  1.00  0.00           C  
ATOM    381  CG  LEU A  28      32.221  56.706   4.495  1.00  0.00           C  
ATOM    382  CD1 LEU A  28      33.040  55.470   4.835  1.00  0.00           C  
ATOM    383  CD2 LEU A  28      31.248  57.028   5.619  1.00  0.00           C  
ATOM    384  H   LEU A  28      32.380  57.921   1.731  1.00  0.00           H  
ATOM    385  HA  LEU A  28      31.685  59.466   4.095  1.00  0.00           H  
ATOM    386  HB2 LEU A  28      33.964  57.550   3.620  1.00  0.00           H  
ATOM    387  HB3 LEU A  28      33.512  58.255   5.170  1.00  0.00           H  
ATOM    388  HG  LEU A  28      31.647  56.490   3.604  1.00  0.00           H  
ATOM    389 HD11 LEU A  28      32.518  54.885   5.577  1.00  0.00           H  
ATOM    390 HD12 LEU A  28      34.001  55.772   5.224  1.00  0.00           H  
ATOM    391 HD13 LEU A  28      33.183  54.877   3.943  1.00  0.00           H  
ATOM    392 HD21 LEU A  28      30.313  56.516   5.444  1.00  0.00           H  
ATOM    393 HD22 LEU A  28      31.074  58.093   5.649  1.00  0.00           H  
ATOM    394 HD23 LEU A  28      31.665  56.704   6.561  1.00  0.00           H  
ATOM    395  N   PHE A  29      33.739  60.986   4.346  1.00  0.00           N  
ATOM    396  CA  PHE A  29      34.699  62.083   4.291  1.00  0.00           C  
ATOM    397  C   PHE A  29      36.052  61.649   4.847  1.00  0.00           C  
ATOM    398  O   PHE A  29      36.126  60.956   5.861  1.00  0.00           O  
ATOM    399  CB  PHE A  29      34.175  63.288   5.076  1.00  0.00           C  
ATOM    400  CG  PHE A  29      33.263  64.173   4.277  1.00  0.00           C  
ATOM    401  CD1 PHE A  29      31.922  63.856   4.131  1.00  0.00           C  
ATOM    402  CD2 PHE A  29      33.746  65.322   3.672  1.00  0.00           C  
ATOM    403  CE1 PHE A  29      31.079  64.669   3.395  1.00  0.00           C  
ATOM    404  CE2 PHE A  29      32.908  66.139   2.935  1.00  0.00           C  
ATOM    405  CZ  PHE A  29      31.574  65.812   2.797  1.00  0.00           C  
ATOM    406  H   PHE A  29      33.236  60.833   5.173  1.00  0.00           H  
ATOM    407  HA  PHE A  29      34.822  62.364   3.256  1.00  0.00           H  
ATOM    408  HB2 PHE A  29      33.626  62.936   5.936  1.00  0.00           H  
ATOM    409  HB3 PHE A  29      35.012  63.884   5.407  1.00  0.00           H  
ATOM    410  HD1 PHE A  29      31.534  62.963   4.599  1.00  0.00           H  
ATOM    411  HD2 PHE A  29      34.791  65.578   3.779  1.00  0.00           H  
ATOM    412  HE1 PHE A  29      30.036  64.412   3.290  1.00  0.00           H  
ATOM    413  HE2 PHE A  29      33.298  67.032   2.469  1.00  0.00           H  
ATOM    414  HZ  PHE A  29      30.918  66.449   2.222  1.00  0.00           H  
ATOM    415  N   TYR A  30      37.121  62.062   4.174  1.00  0.00           N  
ATOM    416  CA  TYR A  30      38.472  61.714   4.598  1.00  0.00           C  
ATOM    417  C   TYR A  30      39.352  62.957   4.687  1.00  0.00           C  
ATOM    418  O   TYR A  30      39.044  63.995   4.098  1.00  0.00           O  
ATOM    419  CB  TYR A  30      39.090  60.706   3.627  1.00  0.00           C  
ATOM    420  CG  TYR A  30      38.489  59.324   3.726  1.00  0.00           C  
ATOM    421  CD1 TYR A  30      37.267  59.031   3.131  1.00  0.00           C  
ATOM    422  CD2 TYR A  30      39.141  58.307   4.414  1.00  0.00           C  
ATOM    423  CE1 TYR A  30      36.713  57.769   3.219  1.00  0.00           C  
ATOM    424  CE2 TYR A  30      38.595  57.042   4.506  1.00  0.00           C  
ATOM    425  CZ  TYR A  30      37.381  56.778   3.908  1.00  0.00           C  
ATOM    426  OH  TYR A  30      36.834  55.518   3.997  1.00  0.00           O  
ATOM    427  H   TYR A  30      36.999  62.613   3.373  1.00  0.00           H  
ATOM    428  HA  TYR A  30      38.407  61.262   5.577  1.00  0.00           H  
ATOM    429  HB2 TYR A  30      38.949  61.058   2.616  1.00  0.00           H  
ATOM    430  HB3 TYR A  30      40.148  60.625   3.829  1.00  0.00           H  
ATOM    431  HD1 TYR A  30      36.746  59.810   2.592  1.00  0.00           H  
ATOM    432  HD2 TYR A  30      40.091  58.519   4.882  1.00  0.00           H  
ATOM    433  HE1 TYR A  30      35.763  57.561   2.750  1.00  0.00           H  
ATOM    434  HE2 TYR A  30      39.118  56.267   5.045  1.00  0.00           H  
ATOM    435  HH  TYR A  30      36.473  55.389   4.877  1.00  0.00           H  
ATOM    436  N   LEU A  31      40.449  62.845   5.427  1.00  0.00           N  
ATOM    437  CA  LEU A  31      41.377  63.959   5.594  1.00  0.00           C  
ATOM    438  C   LEU A  31      42.280  64.102   4.375  1.00  0.00           C  
ATOM    439  O   LEU A  31      42.805  63.116   3.858  1.00  0.00           O  
ATOM    440  CB  LEU A  31      42.225  63.757   6.852  1.00  0.00           C  
ATOM    441  CG  LEU A  31      43.006  64.979   7.337  1.00  0.00           C  
ATOM    442  CD1 LEU A  31      43.618  64.713   8.703  1.00  0.00           C  
ATOM    443  CD2 LEU A  31      44.084  65.357   6.332  1.00  0.00           C  
ATOM    444  H   LEU A  31      40.642  61.993   5.872  1.00  0.00           H  
ATOM    445  HA  LEU A  31      40.794  64.861   5.704  1.00  0.00           H  
ATOM    446  HB2 LEU A  31      41.568  63.447   7.648  1.00  0.00           H  
ATOM    447  HB3 LEU A  31      42.937  62.969   6.646  1.00  0.00           H  
ATOM    448  HG  LEU A  31      42.328  65.817   7.433  1.00  0.00           H  
ATOM    449 HD11 LEU A  31      44.116  63.755   8.694  1.00  0.00           H  
ATOM    450 HD12 LEU A  31      42.839  64.707   9.452  1.00  0.00           H  
ATOM    451 HD13 LEU A  31      44.332  65.490   8.935  1.00  0.00           H  
ATOM    452 HD21 LEU A  31      44.986  65.633   6.858  1.00  0.00           H  
ATOM    453 HD22 LEU A  31      43.744  66.192   5.738  1.00  0.00           H  
ATOM    454 HD23 LEU A  31      44.286  64.514   5.687  1.00  0.00           H  
ATOM    455  N   GLY A  32      42.460  65.339   3.920  1.00  0.00           N  
ATOM    456  CA  GLY A  32      43.303  65.590   2.765  1.00  0.00           C  
ATOM    457  C   GLY A  32      43.768  67.031   2.689  1.00  0.00           C  
ATOM    458  O   GLY A  32      43.238  67.901   3.380  1.00  0.00           O  
ATOM    459  H   GLY A  32      42.017  66.088   4.372  1.00  0.00           H  
ATOM    460  HA2 GLY A  32      44.168  64.945   2.818  1.00  0.00           H  
ATOM    461  HA3 GLY A  32      42.746  65.356   1.870  1.00  0.00           H  
ATOM    462  N   THR A  33      44.762  67.286   1.845  1.00  0.00           N  
ATOM    463  CA  THR A  33      45.301  68.630   1.682  1.00  0.00           C  
ATOM    464  C   THR A  33      45.065  69.150   0.269  1.00  0.00           C  
ATOM    465  O   THR A  33      45.354  68.462  -0.711  1.00  0.00           O  
ATOM    466  CB  THR A  33      46.811  68.672   1.986  1.00  0.00           C  
ATOM    467  OG1 THR A  33      47.046  68.302   3.349  1.00  0.00           O  
ATOM    468  CG2 THR A  33      47.377  70.059   1.727  1.00  0.00           C  
ATOM    469  H   THR A  33      45.144  66.551   1.321  1.00  0.00           H  
ATOM    470  HA  THR A  33      44.796  69.279   2.383  1.00  0.00           H  
ATOM    471  HB  THR A  33      47.312  67.968   1.338  1.00  0.00           H  
ATOM    472  HG1 THR A  33      46.457  68.799   3.923  1.00  0.00           H  
ATOM    473 HG21 THR A  33      48.443  70.049   1.893  1.00  0.00           H  
ATOM    474 HG22 THR A  33      46.915  70.768   2.399  1.00  0.00           H  
ATOM    475 HG23 THR A  33      47.174  70.347   0.706  1.00  0.00           H  
ATOM    476  N   ILE A  34      44.540  70.366   0.170  1.00  0.00           N  
ATOM    477  CA  ILE A  34      44.267  70.978  -1.124  1.00  0.00           C  
ATOM    478  C   ILE A  34      45.555  71.201  -1.910  1.00  0.00           C  
ATOM    479  O   ILE A  34      46.509  71.794  -1.405  1.00  0.00           O  
ATOM    480  CB  ILE A  34      43.534  72.323  -0.968  1.00  0.00           C  
ATOM    481  CG1 ILE A  34      42.173  72.114  -0.302  1.00  0.00           C  
ATOM    482  CG2 ILE A  34      43.369  72.996  -2.323  1.00  0.00           C  
ATOM    483  CD1 ILE A  34      41.420  73.401  -0.046  1.00  0.00           C  
ATOM    484  H   ILE A  34      44.332  70.865   0.987  1.00  0.00           H  
ATOM    485  HA  ILE A  34      43.630  70.307  -1.683  1.00  0.00           H  
ATOM    486  HB  ILE A  34      44.137  72.966  -0.345  1.00  0.00           H  
ATOM    487 HG12 ILE A  34      41.561  71.492  -0.936  1.00  0.00           H  
ATOM    488 HG13 ILE A  34      42.319  71.619   0.648  1.00  0.00           H  
ATOM    489 HG21 ILE A  34      42.807  73.911  -2.203  1.00  0.00           H  
ATOM    490 HG22 ILE A  34      44.342  73.223  -2.733  1.00  0.00           H  
ATOM    491 HG23 ILE A  34      42.840  72.335  -2.992  1.00  0.00           H  
ATOM    492 HD11 ILE A  34      40.835  73.654  -0.919  1.00  0.00           H  
ATOM    493 HD12 ILE A  34      40.764  73.272   0.802  1.00  0.00           H  
ATOM    494 HD13 ILE A  34      42.123  74.194   0.158  1.00  0.00           H  
ATOM    495  N   LYS A  35      45.577  70.724  -3.149  1.00  0.00           N  
ATOM    496  CA  LYS A  35      46.746  70.874  -4.007  1.00  0.00           C  
ATOM    497  C   LYS A  35      46.422  71.735  -5.223  1.00  0.00           C  
ATOM    498  O   LYS A  35      47.248  72.530  -5.673  1.00  0.00           O  
ATOM    499  CB  LYS A  35      47.250  69.501  -4.460  1.00  0.00           C  
ATOM    500  CG  LYS A  35      47.238  68.455  -3.360  1.00  0.00           C  
ATOM    501  CD  LYS A  35      48.555  68.424  -2.603  1.00  0.00           C  
ATOM    502  CE  LYS A  35      48.569  69.437  -1.468  1.00  0.00           C  
ATOM    503  NZ  LYS A  35      49.952  69.725  -0.999  1.00  0.00           N  
ATOM    504  H   LYS A  35      44.785  70.260  -3.496  1.00  0.00           H  
ATOM    505  HA  LYS A  35      47.519  71.359  -3.433  1.00  0.00           H  
ATOM    506  HB2 LYS A  35      46.626  69.151  -5.269  1.00  0.00           H  
ATOM    507  HB3 LYS A  35      48.264  69.605  -4.818  1.00  0.00           H  
ATOM    508  HG2 LYS A  35      46.442  68.683  -2.667  1.00  0.00           H  
ATOM    509  HG3 LYS A  35      47.064  67.484  -3.801  1.00  0.00           H  
ATOM    510  HD2 LYS A  35      48.702  67.437  -2.192  1.00  0.00           H  
ATOM    511  HD3 LYS A  35      49.358  68.654  -3.288  1.00  0.00           H  
ATOM    512  HE2 LYS A  35      48.117  70.354  -1.815  1.00  0.00           H  
ATOM    513  HE3 LYS A  35      47.993  69.041  -0.644  1.00  0.00           H  
ATOM    514  HZ1 LYS A  35      50.517  70.125  -1.775  1.00  0.00           H  
ATOM    515  HZ2 LYS A  35      50.407  68.850  -0.669  1.00  0.00           H  
ATOM    516  HZ3 LYS A  35      49.928  70.407  -0.214  1.00  0.00           H  
ATOM    517  N   LYS A  36      45.213  71.573  -5.752  1.00  0.00           N  
ATOM    518  CA  LYS A  36      44.778  72.337  -6.915  1.00  0.00           C  
ATOM    519  C   LYS A  36      43.301  72.701  -6.805  1.00  0.00           C  
ATOM    520  O   LYS A  36      42.552  72.078  -6.050  1.00  0.00           O  
ATOM    521  CB  LYS A  36      45.022  71.539  -8.197  1.00  0.00           C  
ATOM    522  CG  LYS A  36      46.397  71.768  -8.803  1.00  0.00           C  
ATOM    523  CD  LYS A  36      46.420  71.410 -10.280  1.00  0.00           C  
ATOM    524  CE  LYS A  36      46.679  69.926 -10.489  1.00  0.00           C  
ATOM    525  NZ  LYS A  36      47.283  69.651 -11.822  1.00  0.00           N  
ATOM    526  H   LYS A  36      44.598  70.924  -5.349  1.00  0.00           H  
ATOM    527  HA  LYS A  36      45.358  73.247  -6.951  1.00  0.00           H  
ATOM    528  HB2 LYS A  36      44.920  70.487  -7.976  1.00  0.00           H  
ATOM    529  HB3 LYS A  36      44.279  71.818  -8.929  1.00  0.00           H  
ATOM    530  HG2 LYS A  36      46.660  72.809  -8.692  1.00  0.00           H  
ATOM    531  HG3 LYS A  36      47.117  71.154  -8.281  1.00  0.00           H  
ATOM    532  HD2 LYS A  36      45.467  71.664 -10.719  1.00  0.00           H  
ATOM    533  HD3 LYS A  36      47.204  71.975 -10.765  1.00  0.00           H  
ATOM    534  HE2 LYS A  36      47.351  69.579  -9.720  1.00  0.00           H  
ATOM    535  HE3 LYS A  36      45.740  69.396 -10.413  1.00  0.00           H  
ATOM    536  HZ1 LYS A  36      48.218  69.210 -11.707  1.00  0.00           H  
ATOM    537  HZ2 LYS A  36      47.394  70.538 -12.355  1.00  0.00           H  
ATOM    538  HZ3 LYS A  36      46.673  69.007 -12.366  1.00  0.00           H  
ATOM    539  N   ILE A  37      42.887  73.712  -7.562  1.00  0.00           N  
ATOM    540  CA  ILE A  37      41.498  74.156  -7.550  1.00  0.00           C  
ATOM    541  C   ILE A  37      41.003  74.447  -8.962  1.00  0.00           C  
ATOM    542  O   ILE A  37      41.400  75.435  -9.579  1.00  0.00           O  
ATOM    543  CB  ILE A  37      41.318  75.417  -6.684  1.00  0.00           C  
ATOM    544  CG1 ILE A  37      41.802  75.156  -5.256  1.00  0.00           C  
ATOM    545  CG2 ILE A  37      39.861  75.855  -6.683  1.00  0.00           C  
ATOM    546  CD1 ILE A  37      42.134  76.418  -4.491  1.00  0.00           C  
ATOM    547  H   ILE A  37      43.530  74.170  -8.142  1.00  0.00           H  
ATOM    548  HA  ILE A  37      40.899  73.364  -7.125  1.00  0.00           H  
ATOM    549  HB  ILE A  37      41.908  76.211  -7.117  1.00  0.00           H  
ATOM    550 HG12 ILE A  37      41.033  74.631  -4.713  1.00  0.00           H  
ATOM    551 HG13 ILE A  37      42.692  74.544  -5.293  1.00  0.00           H  
ATOM    552 HG21 ILE A  37      39.723  76.647  -7.405  1.00  0.00           H  
ATOM    553 HG22 ILE A  37      39.233  75.017  -6.946  1.00  0.00           H  
ATOM    554 HG23 ILE A  37      39.593  76.213  -5.700  1.00  0.00           H  
ATOM    555 HD11 ILE A  37      41.462  76.515  -3.650  1.00  0.00           H  
ATOM    556 HD12 ILE A  37      43.152  76.364  -4.132  1.00  0.00           H  
ATOM    557 HD13 ILE A  37      42.024  77.272  -5.139  1.00  0.00           H  
ATOM    558  N   ASN A  38      40.130  73.581  -9.468  1.00  0.00           N  
ATOM    559  CA  ASN A  38      39.578  73.747 -10.808  1.00  0.00           C  
ATOM    560  C   ASN A  38      38.186  74.368 -10.750  1.00  0.00           C  
ATOM    561  O   ASN A  38      37.258  73.782 -10.192  1.00  0.00           O  
ATOM    562  CB  ASN A  38      39.518  72.397 -11.526  1.00  0.00           C  
ATOM    563  CG  ASN A  38      38.955  72.515 -12.929  1.00  0.00           C  
ATOM    564  OD1 ASN A  38      38.294  73.498 -13.266  1.00  0.00           O  
ATOM    565  ND2 ASN A  38      39.216  71.510 -13.758  1.00  0.00           N  
ATOM    566  H   ASN A  38      39.851  72.813  -8.927  1.00  0.00           H  
ATOM    567  HA  ASN A  38      40.233  74.408 -11.356  1.00  0.00           H  
ATOM    568  HB2 ASN A  38      40.515  71.987 -11.593  1.00  0.00           H  
ATOM    569  HB3 ASN A  38      38.892  71.723 -10.962  1.00  0.00           H  
ATOM    570 HD21 ASN A  38      39.749  70.759 -13.422  1.00  0.00           H  
ATOM    571 HD22 ASN A  38      38.864  71.560 -14.671  1.00  0.00           H  
ATOM    572  N   ILE A  39      38.049  75.556 -11.329  1.00  0.00           N  
ATOM    573  CA  ILE A  39      36.771  76.255 -11.345  1.00  0.00           C  
ATOM    574  C   ILE A  39      35.873  75.734 -12.462  1.00  0.00           C  
ATOM    575  O   ILE A  39      34.654  75.659 -12.309  1.00  0.00           O  
ATOM    576  CB  ILE A  39      36.961  77.773 -11.521  1.00  0.00           C  
ATOM    577  CG1 ILE A  39      38.085  78.276 -10.613  1.00  0.00           C  
ATOM    578  CG2 ILE A  39      35.663  78.508 -11.222  1.00  0.00           C  
ATOM    579  CD1 ILE A  39      38.358  79.758 -10.754  1.00  0.00           C  
ATOM    580  H   ILE A  39      38.827  75.971 -11.756  1.00  0.00           H  
ATOM    581  HA  ILE A  39      36.284  76.081 -10.395  1.00  0.00           H  
ATOM    582  HB  ILE A  39      37.226  77.964 -12.549  1.00  0.00           H  
ATOM    583 HG12 ILE A  39      37.823  78.085  -9.584  1.00  0.00           H  
ATOM    584 HG13 ILE A  39      38.996  77.746 -10.852  1.00  0.00           H  
ATOM    585 HG21 ILE A  39      35.215  78.837 -12.148  1.00  0.00           H  
ATOM    586 HG22 ILE A  39      34.984  77.843 -10.711  1.00  0.00           H  
ATOM    587 HG23 ILE A  39      35.869  79.364 -10.597  1.00  0.00           H  
ATOM    588 HD11 ILE A  39      38.425  80.206  -9.774  1.00  0.00           H  
ATOM    589 HD12 ILE A  39      39.291  79.904 -11.279  1.00  0.00           H  
ATOM    590 HD13 ILE A  39      37.556  80.221 -11.308  1.00  0.00           H  
ATOM    591  N   LEU A  40      36.484  75.372 -13.584  1.00  0.00           N  
ATOM    592  CA  LEU A  40      35.741  74.855 -14.728  1.00  0.00           C  
ATOM    593  C   LEU A  40      34.984  73.584 -14.356  1.00  0.00           C  
ATOM    594  O   LEU A  40      33.820  73.413 -14.718  1.00  0.00           O  
ATOM    595  CB  LEU A  40      36.690  74.574 -15.894  1.00  0.00           C  
ATOM    596  CG  LEU A  40      37.843  75.562 -16.073  1.00  0.00           C  
ATOM    597  CD1 LEU A  40      38.592  75.280 -17.366  1.00  0.00           C  
ATOM    598  CD2 LEU A  40      37.327  76.994 -16.057  1.00  0.00           C  
ATOM    599  H   LEU A  40      37.458  75.455 -13.647  1.00  0.00           H  
ATOM    600  HA  LEU A  40      35.029  75.609 -15.028  1.00  0.00           H  
ATOM    601  HB2 LEU A  40      37.116  73.594 -15.745  1.00  0.00           H  
ATOM    602  HB3 LEU A  40      36.106  74.577 -16.804  1.00  0.00           H  
ATOM    603  HG  LEU A  40      38.539  75.448 -15.254  1.00  0.00           H  
ATOM    604 HD11 LEU A  40      39.544  74.824 -17.139  1.00  0.00           H  
ATOM    605 HD12 LEU A  40      38.755  76.205 -17.899  1.00  0.00           H  
ATOM    606 HD13 LEU A  40      38.009  74.609 -17.981  1.00  0.00           H  
ATOM    607 HD21 LEU A  40      37.339  77.369 -15.044  1.00  0.00           H  
ATOM    608 HD22 LEU A  40      36.316  77.015 -16.437  1.00  0.00           H  
ATOM    609 HD23 LEU A  40      37.958  77.612 -16.679  1.00  0.00           H  
ATOM    610  N   LYS A  41      35.653  72.695 -13.629  1.00  0.00           N  
ATOM    611  CA  LYS A  41      35.044  71.440 -13.204  1.00  0.00           C  
ATOM    612  C   LYS A  41      34.520  71.547 -11.775  1.00  0.00           C  
ATOM    613  O   LYS A  41      33.898  70.616 -11.263  1.00  0.00           O  
ATOM    614  CB  LYS A  41      36.057  70.298 -13.304  1.00  0.00           C  
ATOM    615  CG  LYS A  41      36.384  69.899 -14.733  1.00  0.00           C  
ATOM    616  CD  LYS A  41      36.907  68.475 -14.809  1.00  0.00           C  
ATOM    617  CE  LYS A  41      38.322  68.371 -14.262  1.00  0.00           C  
ATOM    618  NZ  LYS A  41      38.809  66.963 -14.245  1.00  0.00           N  
ATOM    619  H   LYS A  41      36.579  72.888 -13.371  1.00  0.00           H  
ATOM    620  HA  LYS A  41      34.214  71.234 -13.863  1.00  0.00           H  
ATOM    621  HB2 LYS A  41      36.973  70.601 -12.818  1.00  0.00           H  
ATOM    622  HB3 LYS A  41      35.658  69.433 -12.794  1.00  0.00           H  
ATOM    623  HG2 LYS A  41      35.490  69.975 -15.333  1.00  0.00           H  
ATOM    624  HG3 LYS A  41      37.137  70.571 -15.121  1.00  0.00           H  
ATOM    625  HD2 LYS A  41      36.261  67.832 -14.228  1.00  0.00           H  
ATOM    626  HD3 LYS A  41      36.904  68.153 -15.840  1.00  0.00           H  
ATOM    627  HE2 LYS A  41      38.979  68.962 -14.882  1.00  0.00           H  
ATOM    628  HE3 LYS A  41      38.334  68.758 -13.253  1.00  0.00           H  
ATOM    629  HZ1 LYS A  41      38.571  66.513 -13.339  1.00  0.00           H  
ATOM    630  HZ2 LYS A  41      39.841  66.942 -14.371  1.00  0.00           H  
ATOM    631  HZ3 LYS A  41      38.367  66.424 -15.016  1.00  0.00           H  
ATOM    632  N   GLN A  42      34.778  72.684 -11.138  1.00  0.00           N  
ATOM    633  CA  GLN A  42      34.332  72.910  -9.768  1.00  0.00           C  
ATOM    634  C   GLN A  42      34.863  71.826  -8.837  1.00  0.00           C  
ATOM    635  O   GLN A  42      34.136  71.314  -7.987  1.00  0.00           O  
ATOM    636  CB  GLN A  42      32.803  72.948  -9.707  1.00  0.00           C  
ATOM    637  CG  GLN A  42      32.178  73.901 -10.713  1.00  0.00           C  
ATOM    638  CD  GLN A  42      30.670  73.983 -10.579  1.00  0.00           C  
ATOM    639  OE1 GLN A  42      29.993  72.966 -10.419  1.00  0.00           O  
ATOM    640  NE2 GLN A  42      30.135  75.197 -10.641  1.00  0.00           N  
ATOM    641  H   GLN A  42      35.279  73.387 -11.600  1.00  0.00           H  
ATOM    642  HA  GLN A  42      34.720  73.865  -9.447  1.00  0.00           H  
ATOM    643  HB2 GLN A  42      32.423  71.956  -9.897  1.00  0.00           H  
ATOM    644  HB3 GLN A  42      32.503  73.257  -8.716  1.00  0.00           H  
ATOM    645  HG2 GLN A  42      32.591  74.886 -10.563  1.00  0.00           H  
ATOM    646  HG3 GLN A  42      32.418  73.559 -11.710  1.00  0.00           H  
ATOM    647 HE21 GLN A  42      30.737  75.961 -10.771  1.00  0.00           H  
ATOM    648 HE22 GLN A  42      29.163  75.279 -10.559  1.00  0.00           H  
ATOM    649  N   SER A  43      36.136  71.481  -9.004  1.00  0.00           N  
ATOM    650  CA  SER A  43      36.764  70.454  -8.181  1.00  0.00           C  
ATOM    651  C   SER A  43      38.080  70.957  -7.597  1.00  0.00           C  
ATOM    652  O   SER A  43      38.494  72.089  -7.851  1.00  0.00           O  
ATOM    653  CB  SER A  43      37.009  69.189  -9.005  1.00  0.00           C  
ATOM    654  OG  SER A  43      37.636  69.497 -10.237  1.00  0.00           O  
ATOM    655  H   SER A  43      36.664  71.926  -9.699  1.00  0.00           H  
ATOM    656  HA  SER A  43      36.090  70.221  -7.370  1.00  0.00           H  
ATOM    657  HB2 SER A  43      37.645  68.518  -8.449  1.00  0.00           H  
ATOM    658  HB3 SER A  43      36.063  68.705  -9.207  1.00  0.00           H  
ATOM    659  HG  SER A  43      37.251  68.962 -10.935  1.00  0.00           H  
ATOM    660  N   CYS A  44      38.735  70.107  -6.812  1.00  0.00           N  
ATOM    661  CA  CYS A  44      40.005  70.464  -6.190  1.00  0.00           C  
ATOM    662  C   CYS A  44      40.863  69.225  -5.958  1.00  0.00           C  
ATOM    663  O   CYS A  44      40.410  68.243  -5.371  1.00  0.00           O  
ATOM    664  CB  CYS A  44      39.761  71.185  -4.863  1.00  0.00           C  
ATOM    665  SG  CYS A  44      38.561  72.534  -4.965  1.00  0.00           S  
ATOM    666  H   CYS A  44      38.354  69.219  -6.646  1.00  0.00           H  
ATOM    667  HA  CYS A  44      40.526  71.129  -6.861  1.00  0.00           H  
ATOM    668  HB2 CYS A  44      39.395  70.475  -4.137  1.00  0.00           H  
ATOM    669  HB3 CYS A  44      40.694  71.599  -4.511  1.00  0.00           H  
ATOM    670  HG  CYS A  44      38.681  73.272  -3.872  1.00  0.00           H  
ATOM    671  N   PHE A  45      42.106  69.278  -6.426  1.00  0.00           N  
ATOM    672  CA  PHE A  45      43.028  68.158  -6.273  1.00  0.00           C  
ATOM    673  C   PHE A  45      43.575  68.095  -4.850  1.00  0.00           C  
ATOM    674  O   PHE A  45      44.528  68.795  -4.507  1.00  0.00           O  
ATOM    675  CB  PHE A  45      44.183  68.282  -7.270  1.00  0.00           C  
ATOM    676  CG  PHE A  45      44.746  66.959  -7.702  1.00  0.00           C  
ATOM    677  CD1 PHE A  45      43.904  65.923  -8.078  1.00  0.00           C  
ATOM    678  CD2 PHE A  45      46.114  66.749  -7.735  1.00  0.00           C  
ATOM    679  CE1 PHE A  45      44.419  64.705  -8.477  1.00  0.00           C  
ATOM    680  CE2 PHE A  45      46.635  65.532  -8.132  1.00  0.00           C  
ATOM    681  CZ  PHE A  45      45.786  64.509  -8.505  1.00  0.00           C  
ATOM    682  H   PHE A  45      42.410  70.088  -6.887  1.00  0.00           H  
ATOM    683  HA  PHE A  45      42.483  67.250  -6.478  1.00  0.00           H  
ATOM    684  HB2 PHE A  45      43.835  68.798  -8.151  1.00  0.00           H  
ATOM    685  HB3 PHE A  45      44.981  68.851  -6.816  1.00  0.00           H  
ATOM    686  HD1 PHE A  45      42.836  66.075  -8.059  1.00  0.00           H  
ATOM    687  HD2 PHE A  45      46.780  67.550  -7.443  1.00  0.00           H  
ATOM    688  HE1 PHE A  45      43.754  63.906  -8.768  1.00  0.00           H  
ATOM    689  HE2 PHE A  45      47.705  65.383  -8.153  1.00  0.00           H  
ATOM    690  HZ  PHE A  45      46.191  63.557  -8.816  1.00  0.00           H  
ATOM    691  N   ILE A  46      42.963  67.251  -4.025  1.00  0.00           N  
ATOM    692  CA  ILE A  46      43.388  67.094  -2.640  1.00  0.00           C  
ATOM    693  C   ILE A  46      44.089  65.758  -2.427  1.00  0.00           C  
ATOM    694  O   ILE A  46      43.731  64.753  -3.042  1.00  0.00           O  
ATOM    695  CB  ILE A  46      42.196  67.197  -1.670  1.00  0.00           C  
ATOM    696  CG1 ILE A  46      41.644  68.624  -1.654  1.00  0.00           C  
ATOM    697  CG2 ILE A  46      42.612  66.768  -0.271  1.00  0.00           C  
ATOM    698  CD1 ILE A  46      40.165  68.697  -1.351  1.00  0.00           C  
ATOM    699  H   ILE A  46      42.210  66.720  -4.357  1.00  0.00           H  
ATOM    700  HA  ILE A  46      44.081  67.892  -2.412  1.00  0.00           H  
ATOM    701  HB  ILE A  46      41.423  66.525  -2.013  1.00  0.00           H  
ATOM    702 HG12 ILE A  46      42.165  69.196  -0.902  1.00  0.00           H  
ATOM    703 HG13 ILE A  46      41.809  69.076  -2.621  1.00  0.00           H  
ATOM    704 HG21 ILE A  46      43.683  66.864  -0.169  1.00  0.00           H  
ATOM    705 HG22 ILE A  46      42.124  67.398   0.458  1.00  0.00           H  
ATOM    706 HG23 ILE A  46      42.326  65.740  -0.110  1.00  0.00           H  
ATOM    707 HD11 ILE A  46      39.765  69.629  -1.727  1.00  0.00           H  
ATOM    708 HD12 ILE A  46      39.658  67.871  -1.829  1.00  0.00           H  
ATOM    709 HD13 ILE A  46      40.012  68.646  -0.284  1.00  0.00           H  
ATOM    710  N   ILE A  47      45.088  65.752  -1.551  1.00  0.00           N  
ATOM    711  CA  ILE A  47      45.837  64.537  -1.254  1.00  0.00           C  
ATOM    712  C   ILE A  47      45.459  63.979   0.114  1.00  0.00           C  
ATOM    713  O   ILE A  47      45.762  64.579   1.146  1.00  0.00           O  
ATOM    714  CB  ILE A  47      47.356  64.788  -1.293  1.00  0.00           C  
ATOM    715  CG1 ILE A  47      47.879  64.660  -2.724  1.00  0.00           C  
ATOM    716  CG2 ILE A  47      48.076  63.817  -0.370  1.00  0.00           C  
ATOM    717  CD1 ILE A  47      49.276  65.211  -2.909  1.00  0.00           C  
ATOM    718  H   ILE A  47      45.326  66.584  -1.092  1.00  0.00           H  
ATOM    719  HA  ILE A  47      45.594  63.804  -2.010  1.00  0.00           H  
ATOM    720  HB  ILE A  47      47.541  65.791  -0.937  1.00  0.00           H  
ATOM    721 HG12 ILE A  47      47.895  63.619  -3.004  1.00  0.00           H  
ATOM    722 HG13 ILE A  47      47.220  65.198  -3.391  1.00  0.00           H  
ATOM    723 HG21 ILE A  47      47.535  62.884  -0.336  1.00  0.00           H  
ATOM    724 HG22 ILE A  47      49.074  63.641  -0.743  1.00  0.00           H  
ATOM    725 HG23 ILE A  47      48.133  64.238   0.623  1.00  0.00           H  
ATOM    726 HD11 ILE A  47      49.239  66.078  -3.554  1.00  0.00           H  
ATOM    727 HD12 ILE A  47      49.681  65.496  -1.949  1.00  0.00           H  
ATOM    728 HD13 ILE A  47      49.906  64.456  -3.357  1.00  0.00           H  
ATOM    729  N   PHE A  48      44.799  62.827   0.115  1.00  0.00           N  
ATOM    730  CA  PHE A  48      44.382  62.186   1.357  1.00  0.00           C  
ATOM    731  C   PHE A  48      45.571  61.541   2.064  1.00  0.00           C  
ATOM    732  O   PHE A  48      46.549  61.156   1.425  1.00  0.00           O  
ATOM    733  CB  PHE A  48      43.309  61.132   1.075  1.00  0.00           C  
ATOM    734  CG  PHE A  48      42.064  61.694   0.452  1.00  0.00           C  
ATOM    735  CD1 PHE A  48      42.009  61.946  -0.910  1.00  0.00           C  
ATOM    736  CD2 PHE A  48      40.949  61.971   1.227  1.00  0.00           C  
ATOM    737  CE1 PHE A  48      40.865  62.466  -1.486  1.00  0.00           C  
ATOM    738  CE2 PHE A  48      39.802  62.489   0.655  1.00  0.00           C  
ATOM    739  CZ  PHE A  48      39.760  62.736  -0.703  1.00  0.00           C  
ATOM    740  H   PHE A  48      44.587  62.397  -0.740  1.00  0.00           H  
ATOM    741  HA  PHE A  48      43.966  62.947   1.998  1.00  0.00           H  
ATOM    742  HB2 PHE A  48      43.710  60.390   0.403  1.00  0.00           H  
ATOM    743  HB3 PHE A  48      43.031  60.656   2.004  1.00  0.00           H  
ATOM    744  HD1 PHE A  48      42.872  61.735  -1.524  1.00  0.00           H  
ATOM    745  HD2 PHE A  48      40.981  61.779   2.289  1.00  0.00           H  
ATOM    746  HE1 PHE A  48      40.834  62.657  -2.549  1.00  0.00           H  
ATOM    747  HE2 PHE A  48      38.940  62.700   1.271  1.00  0.00           H  
ATOM    748  HZ  PHE A  48      38.864  63.142  -1.151  1.00  0.00           H  
ATOM    749  N   GLU A  49      45.477  61.430   3.385  1.00  0.00           N  
ATOM    750  CA  GLU A  49      46.545  60.834   4.178  1.00  0.00           C  
ATOM    751  C   GLU A  49      47.043  59.542   3.538  1.00  0.00           C  
ATOM    752  O   GLU A  49      48.159  59.094   3.803  1.00  0.00           O  
ATOM    753  CB  GLU A  49      46.060  60.556   5.602  1.00  0.00           C  
ATOM    754  CG  GLU A  49      46.112  61.773   6.512  1.00  0.00           C  
ATOM    755  CD  GLU A  49      47.528  62.154   6.895  1.00  0.00           C  
ATOM    756  OE1 GLU A  49      48.379  61.247   6.995  1.00  0.00           O  
ATOM    757  OE2 GLU A  49      47.785  63.360   7.096  1.00  0.00           O  
ATOM    758  H   GLU A  49      44.671  61.757   3.837  1.00  0.00           H  
ATOM    759  HA  GLU A  49      47.362  61.540   4.218  1.00  0.00           H  
ATOM    760  HB2 GLU A  49      45.038  60.207   5.560  1.00  0.00           H  
ATOM    761  HB3 GLU A  49      46.677  59.784   6.035  1.00  0.00           H  
ATOM    762  HG2 GLU A  49      45.656  62.608   6.001  1.00  0.00           H  
ATOM    763  HG3 GLU A  49      45.557  61.557   7.412  1.00  0.00           H  
ATOM    764  N   ASP A  50      46.207  58.948   2.694  1.00  0.00           N  
ATOM    765  CA  ASP A  50      46.561  57.707   2.014  1.00  0.00           C  
ATOM    766  C   ASP A  50      47.438  57.985   0.797  1.00  0.00           C  
ATOM    767  O   ASP A  50      47.619  57.120  -0.060  1.00  0.00           O  
ATOM    768  CB  ASP A  50      45.299  56.956   1.588  1.00  0.00           C  
ATOM    769  CG  ASP A  50      44.447  56.536   2.770  1.00  0.00           C  
ATOM    770  OD1 ASP A  50      44.938  55.744   3.603  1.00  0.00           O  
ATOM    771  OD2 ASP A  50      43.292  57.000   2.863  1.00  0.00           O  
ATOM    772  H   ASP A  50      45.331  59.353   2.523  1.00  0.00           H  
ATOM    773  HA  ASP A  50      47.115  57.094   2.709  1.00  0.00           H  
ATOM    774  HB2 ASP A  50      44.705  57.595   0.950  1.00  0.00           H  
ATOM    775  HB3 ASP A  50      45.583  56.070   1.039  1.00  0.00           H  
ATOM    776  N   SER A  51      47.980  59.196   0.729  1.00  0.00           N  
ATOM    777  CA  SER A  51      48.834  59.590  -0.385  1.00  0.00           C  
ATOM    778  C   SER A  51      48.112  59.401  -1.716  1.00  0.00           C  
ATOM    779  O   SER A  51      48.743  59.216  -2.757  1.00  0.00           O  
ATOM    780  CB  SER A  51      50.129  58.775  -0.375  1.00  0.00           C  
ATOM    781  OG  SER A  51      50.736  58.799   0.905  1.00  0.00           O  
ATOM    782  H   SER A  51      47.798  59.842   1.444  1.00  0.00           H  
ATOM    783  HA  SER A  51      49.075  60.635  -0.265  1.00  0.00           H  
ATOM    784  HB2 SER A  51      49.909  57.752  -0.638  1.00  0.00           H  
ATOM    785  HB3 SER A  51      50.819  59.193  -1.095  1.00  0.00           H  
ATOM    786  HG  SER A  51      50.064  58.947   1.576  1.00  0.00           H  
ATOM    787  N   SER A  52      46.784  59.451  -1.674  1.00  0.00           N  
ATOM    788  CA  SER A  52      45.975  59.282  -2.875  1.00  0.00           C  
ATOM    789  C   SER A  52      45.405  60.619  -3.338  1.00  0.00           C  
ATOM    790  O   SER A  52      44.764  61.335  -2.568  1.00  0.00           O  
ATOM    791  CB  SER A  52      44.837  58.292  -2.614  1.00  0.00           C  
ATOM    792  OG  SER A  52      45.334  56.977  -2.441  1.00  0.00           O  
ATOM    793  H   SER A  52      46.339  59.601  -0.814  1.00  0.00           H  
ATOM    794  HA  SER A  52      46.612  58.887  -3.652  1.00  0.00           H  
ATOM    795  HB2 SER A  52      44.308  58.584  -1.720  1.00  0.00           H  
ATOM    796  HB3 SER A  52      44.157  58.301  -3.454  1.00  0.00           H  
ATOM    797  HG  SER A  52      45.150  56.459  -3.228  1.00  0.00           H  
ATOM    798  N   LYS A  53      45.641  60.949  -4.603  1.00  0.00           N  
ATOM    799  CA  LYS A  53      45.152  62.199  -5.173  1.00  0.00           C  
ATOM    800  C   LYS A  53      43.836  61.982  -5.911  1.00  0.00           C  
ATOM    801  O   LYS A  53      43.734  61.111  -6.776  1.00  0.00           O  
ATOM    802  CB  LYS A  53      46.193  62.792  -6.126  1.00  0.00           C  
ATOM    803  CG  LYS A  53      47.621  62.407  -5.783  1.00  0.00           C  
ATOM    804  CD  LYS A  53      48.596  62.865  -6.855  1.00  0.00           C  
ATOM    805  CE  LYS A  53      49.156  64.245  -6.544  1.00  0.00           C  
ATOM    806  NZ  LYS A  53      49.927  64.801  -7.690  1.00  0.00           N  
ATOM    807  H   LYS A  53      46.159  60.337  -5.168  1.00  0.00           H  
ATOM    808  HA  LYS A  53      44.986  62.891  -4.361  1.00  0.00           H  
ATOM    809  HB2 LYS A  53      45.980  62.449  -7.128  1.00  0.00           H  
ATOM    810  HB3 LYS A  53      46.116  63.869  -6.100  1.00  0.00           H  
ATOM    811  HG2 LYS A  53      47.893  62.865  -4.844  1.00  0.00           H  
ATOM    812  HG3 LYS A  53      47.682  61.330  -5.691  1.00  0.00           H  
ATOM    813  HD2 LYS A  53      49.413  62.162  -6.912  1.00  0.00           H  
ATOM    814  HD3 LYS A  53      48.081  62.901  -7.806  1.00  0.00           H  
ATOM    815  HE2 LYS A  53      48.337  64.909  -6.316  1.00  0.00           H  
ATOM    816  HE3 LYS A  53      49.807  64.169  -5.686  1.00  0.00           H  
ATOM    817  HZ1 LYS A  53      49.557  65.738  -7.949  1.00  0.00           H  
ATOM    818  HZ2 LYS A  53      49.850  64.170  -8.513  1.00  0.00           H  
ATOM    819  HZ3 LYS A  53      50.930  64.895  -7.434  1.00  0.00           H  
ATOM    820  N   SER A  54      42.830  62.780  -5.566  1.00  0.00           N  
ATOM    821  CA  SER A  54      41.519  62.673  -6.195  1.00  0.00           C  
ATOM    822  C   SER A  54      40.850  64.040  -6.291  1.00  0.00           C  
ATOM    823  O   SER A  54      40.820  64.799  -5.323  1.00  0.00           O  
ATOM    824  CB  SER A  54      40.628  61.711  -5.406  1.00  0.00           C  
ATOM    825  OG  SER A  54      40.741  60.389  -5.901  1.00  0.00           O  
ATOM    826  H   SER A  54      42.973  63.455  -4.870  1.00  0.00           H  
ATOM    827  HA  SER A  54      41.661  62.283  -7.192  1.00  0.00           H  
ATOM    828  HB2 SER A  54      40.924  61.720  -4.368  1.00  0.00           H  
ATOM    829  HB3 SER A  54      39.598  62.028  -5.489  1.00  0.00           H  
ATOM    830  HG  SER A  54      41.501  59.960  -5.502  1.00  0.00           H  
ATOM    831  N   TRP A  55      40.313  64.347  -7.468  1.00  0.00           N  
ATOM    832  CA  TRP A  55      39.644  65.624  -7.693  1.00  0.00           C  
ATOM    833  C   TRP A  55      38.284  65.653  -7.005  1.00  0.00           C  
ATOM    834  O   TRP A  55      37.313  65.080  -7.502  1.00  0.00           O  
ATOM    835  CB  TRP A  55      39.478  65.878  -9.191  1.00  0.00           C  
ATOM    836  CG  TRP A  55      40.686  66.496  -9.827  1.00  0.00           C  
ATOM    837  CD1 TRP A  55      41.647  65.856 -10.556  1.00  0.00           C  
ATOM    838  CD2 TRP A  55      41.062  67.878  -9.788  1.00  0.00           C  
ATOM    839  NE1 TRP A  55      42.598  66.756 -10.972  1.00  0.00           N  
ATOM    840  CE2 TRP A  55      42.262  68.002 -10.515  1.00  0.00           C  
ATOM    841  CE3 TRP A  55      40.501  69.020  -9.212  1.00  0.00           C  
ATOM    842  CZ2 TRP A  55      42.909  69.224 -10.679  1.00  0.00           C  
ATOM    843  CZ3 TRP A  55      41.144  70.232  -9.375  1.00  0.00           C  
ATOM    844  CH2 TRP A  55      42.337  70.327 -10.104  1.00  0.00           C  
ATOM    845  H   TRP A  55      40.369  63.700  -8.203  1.00  0.00           H  
ATOM    846  HA  TRP A  55      40.265  66.401  -7.271  1.00  0.00           H  
ATOM    847  HB2 TRP A  55      39.282  64.940  -9.690  1.00  0.00           H  
ATOM    848  HB3 TRP A  55      38.641  66.544  -9.345  1.00  0.00           H  
ATOM    849  HD1 TRP A  55      41.648  64.798 -10.763  1.00  0.00           H  
ATOM    850  HE1 TRP A  55      43.388  66.539 -11.511  1.00  0.00           H  
ATOM    851  HE3 TRP A  55      39.582  68.968  -8.648  1.00  0.00           H  
ATOM    852  HZ2 TRP A  55      43.829  69.315 -11.238  1.00  0.00           H  
ATOM    853  HZ3 TRP A  55      40.726  71.127  -8.936  1.00  0.00           H  
ATOM    854  HH2 TRP A  55      42.806  71.295 -10.205  1.00  0.00           H  
ATOM    855  N   VAL A  56      38.219  66.324  -5.860  1.00  0.00           N  
ATOM    856  CA  VAL A  56      36.975  66.430  -5.105  1.00  0.00           C  
ATOM    857  C   VAL A  56      36.159  67.635  -5.556  1.00  0.00           C  
ATOM    858  O   VAL A  56      36.712  68.678  -5.908  1.00  0.00           O  
ATOM    859  CB  VAL A  56      37.245  66.544  -3.593  1.00  0.00           C  
ATOM    860  CG1 VAL A  56      35.958  66.355  -2.805  1.00  0.00           C  
ATOM    861  CG2 VAL A  56      38.298  65.533  -3.163  1.00  0.00           C  
ATOM    862  H   VAL A  56      39.025  66.760  -5.515  1.00  0.00           H  
ATOM    863  HA  VAL A  56      36.401  65.531  -5.280  1.00  0.00           H  
ATOM    864  HB  VAL A  56      37.624  67.534  -3.389  1.00  0.00           H  
ATOM    865 HG11 VAL A  56      35.171  66.941  -3.255  1.00  0.00           H  
ATOM    866 HG12 VAL A  56      35.681  65.310  -2.814  1.00  0.00           H  
ATOM    867 HG13 VAL A  56      36.109  66.678  -1.785  1.00  0.00           H  
ATOM    868 HG21 VAL A  56      39.055  65.452  -3.927  1.00  0.00           H  
ATOM    869 HG22 VAL A  56      38.752  65.858  -2.238  1.00  0.00           H  
ATOM    870 HG23 VAL A  56      37.832  64.569  -3.014  1.00  0.00           H  
ATOM    871  N   LEU A  57      34.839  67.486  -5.544  1.00  0.00           N  
ATOM    872  CA  LEU A  57      33.944  68.564  -5.952  1.00  0.00           C  
ATOM    873  C   LEU A  57      33.832  69.621  -4.859  1.00  0.00           C  
ATOM    874  O   LEU A  57      33.791  69.300  -3.671  1.00  0.00           O  
ATOM    875  CB  LEU A  57      32.558  68.005  -6.280  1.00  0.00           C  
ATOM    876  CG  LEU A  57      32.475  67.095  -7.507  1.00  0.00           C  
ATOM    877  CD1 LEU A  57      31.082  66.497  -7.634  1.00  0.00           C  
ATOM    878  CD2 LEU A  57      32.843  67.864  -8.767  1.00  0.00           C  
ATOM    879  H   LEU A  57      34.457  66.632  -5.254  1.00  0.00           H  
ATOM    880  HA  LEU A  57      34.358  69.020  -6.838  1.00  0.00           H  
ATOM    881  HB2 LEU A  57      32.219  67.439  -5.427  1.00  0.00           H  
ATOM    882  HB3 LEU A  57      31.894  68.843  -6.443  1.00  0.00           H  
ATOM    883  HG  LEU A  57      33.177  66.282  -7.393  1.00  0.00           H  
ATOM    884 HD11 LEU A  57      31.153  65.502  -8.048  1.00  0.00           H  
ATOM    885 HD12 LEU A  57      30.482  67.116  -8.287  1.00  0.00           H  
ATOM    886 HD13 LEU A  57      30.620  66.451  -6.659  1.00  0.00           H  
ATOM    887 HD21 LEU A  57      33.859  68.225  -8.684  1.00  0.00           H  
ATOM    888 HD22 LEU A  57      32.172  68.701  -8.887  1.00  0.00           H  
ATOM    889 HD23 LEU A  57      32.762  67.211  -9.624  1.00  0.00           H  
ATOM    890  N   TRP A  58      33.781  70.883  -5.269  1.00  0.00           N  
ATOM    891  CA  TRP A  58      33.671  71.990  -4.324  1.00  0.00           C  
ATOM    892  C   TRP A  58      32.562  71.732  -3.311  1.00  0.00           C  
ATOM    893  O   TRP A  58      32.634  72.183  -2.167  1.00  0.00           O  
ATOM    894  CB  TRP A  58      33.404  73.299  -5.069  1.00  0.00           C  
ATOM    895  CG  TRP A  58      34.600  73.816  -5.810  1.00  0.00           C  
ATOM    896  CD1 TRP A  58      35.806  73.193  -5.955  1.00  0.00           C  
ATOM    897  CD2 TRP A  58      34.704  75.063  -6.505  1.00  0.00           C  
ATOM    898  NE1 TRP A  58      36.655  73.977  -6.698  1.00  0.00           N  
ATOM    899  CE2 TRP A  58      36.002  75.130  -7.049  1.00  0.00           C  
ATOM    900  CE3 TRP A  58      33.827  76.129  -6.723  1.00  0.00           C  
ATOM    901  CZ2 TRP A  58      36.441  76.220  -7.794  1.00  0.00           C  
ATOM    902  CZ3 TRP A  58      34.265  77.211  -7.463  1.00  0.00           C  
ATOM    903  CH2 TRP A  58      35.561  77.250  -7.993  1.00  0.00           C  
ATOM    904  H   TRP A  58      33.818  71.078  -6.229  1.00  0.00           H  
ATOM    905  HA  TRP A  58      34.611  72.070  -3.799  1.00  0.00           H  
ATOM    906  HB2 TRP A  58      32.610  73.143  -5.785  1.00  0.00           H  
ATOM    907  HB3 TRP A  58      33.100  74.053  -4.357  1.00  0.00           H  
ATOM    908  HD1 TRP A  58      36.045  72.226  -5.538  1.00  0.00           H  
ATOM    909  HE1 TRP A  58      37.576  73.748  -6.939  1.00  0.00           H  
ATOM    910  HE3 TRP A  58      32.823  76.117  -6.324  1.00  0.00           H  
ATOM    911  HZ2 TRP A  58      37.438  76.265  -8.209  1.00  0.00           H  
ATOM    912  HZ3 TRP A  58      33.601  78.044  -7.642  1.00  0.00           H  
ATOM    913  HH2 TRP A  58      35.860  78.115  -8.563  1.00  0.00           H  
ATOM    914  N   LYS A  59      31.535  71.003  -3.735  1.00  0.00           N  
ATOM    915  CA  LYS A  59      30.410  70.683  -2.864  1.00  0.00           C  
ATOM    916  C   LYS A  59      30.729  69.476  -1.986  1.00  0.00           C  
ATOM    917  O   LYS A  59      30.150  69.308  -0.913  1.00  0.00           O  
ATOM    918  CB  LYS A  59      29.158  70.405  -3.697  1.00  0.00           C  
ATOM    919  CG  LYS A  59      29.251  69.142  -4.535  1.00  0.00           C  
ATOM    920  CD  LYS A  59      27.884  68.699  -5.030  1.00  0.00           C  
ATOM    921  CE  LYS A  59      27.985  67.960  -6.356  1.00  0.00           C  
ATOM    922  NZ  LYS A  59      28.344  68.873  -7.475  1.00  0.00           N  
ATOM    923  H   LYS A  59      31.534  70.671  -4.658  1.00  0.00           H  
ATOM    924  HA  LYS A  59      30.230  71.537  -2.229  1.00  0.00           H  
ATOM    925  HB2 LYS A  59      28.312  70.309  -3.032  1.00  0.00           H  
ATOM    926  HB3 LYS A  59      28.988  71.240  -4.361  1.00  0.00           H  
ATOM    927  HG2 LYS A  59      29.886  69.332  -5.387  1.00  0.00           H  
ATOM    928  HG3 LYS A  59      29.679  68.353  -3.933  1.00  0.00           H  
ATOM    929  HD2 LYS A  59      27.441  68.042  -4.298  1.00  0.00           H  
ATOM    930  HD3 LYS A  59      27.258  69.570  -5.161  1.00  0.00           H  
ATOM    931  HE2 LYS A  59      28.742  67.195  -6.270  1.00  0.00           H  
ATOM    932  HE3 LYS A  59      27.032  67.499  -6.569  1.00  0.00           H  
ATOM    933  HZ1 LYS A  59      27.498  69.377  -7.811  1.00  0.00           H  
ATOM    934  HZ2 LYS A  59      28.747  68.330  -8.265  1.00  0.00           H  
ATOM    935  HZ3 LYS A  59      29.046  69.571  -7.156  1.00  0.00           H  
ATOM    936  N   ASP A  60      31.652  68.640  -2.449  1.00  0.00           N  
ATOM    937  CA  ASP A  60      32.048  67.451  -1.705  1.00  0.00           C  
ATOM    938  C   ASP A  60      33.207  67.761  -0.763  1.00  0.00           C  
ATOM    939  O   ASP A  60      33.536  66.962   0.115  1.00  0.00           O  
ATOM    940  CB  ASP A  60      32.442  66.329  -2.667  1.00  0.00           C  
ATOM    941  CG  ASP A  60      31.238  65.608  -3.240  1.00  0.00           C  
ATOM    942  OD1 ASP A  60      30.100  66.024  -2.940  1.00  0.00           O  
ATOM    943  OD2 ASP A  60      31.435  64.626  -3.988  1.00  0.00           O  
ATOM    944  H   ASP A  60      32.077  68.828  -3.312  1.00  0.00           H  
ATOM    945  HA  ASP A  60      31.201  67.129  -1.119  1.00  0.00           H  
ATOM    946  HB2 ASP A  60      33.011  66.748  -3.485  1.00  0.00           H  
ATOM    947  HB3 ASP A  60      33.054  65.611  -2.141  1.00  0.00           H  
ATOM    948  N   ILE A  61      33.821  68.924  -0.951  1.00  0.00           N  
ATOM    949  CA  ILE A  61      34.943  69.339  -0.117  1.00  0.00           C  
ATOM    950  C   ILE A  61      34.466  70.148   1.083  1.00  0.00           C  
ATOM    951  O   ILE A  61      34.018  71.285   0.938  1.00  0.00           O  
ATOM    952  CB  ILE A  61      35.959  70.175  -0.917  1.00  0.00           C  
ATOM    953  CG1 ILE A  61      36.435  69.402  -2.148  1.00  0.00           C  
ATOM    954  CG2 ILE A  61      37.139  70.559  -0.037  1.00  0.00           C  
ATOM    955  CD1 ILE A  61      36.809  70.291  -3.313  1.00  0.00           C  
ATOM    956  H   ILE A  61      33.513  69.517  -1.667  1.00  0.00           H  
ATOM    957  HA  ILE A  61      35.441  68.448   0.237  1.00  0.00           H  
ATOM    958  HB  ILE A  61      35.470  71.083  -1.238  1.00  0.00           H  
ATOM    959 HG12 ILE A  61      37.303  68.817  -1.885  1.00  0.00           H  
ATOM    960 HG13 ILE A  61      35.646  68.739  -2.474  1.00  0.00           H  
ATOM    961 HG21 ILE A  61      37.858  69.753  -0.027  1.00  0.00           H  
ATOM    962 HG22 ILE A  61      37.605  71.451  -0.428  1.00  0.00           H  
ATOM    963 HG23 ILE A  61      36.793  70.743   0.969  1.00  0.00           H  
ATOM    964 HD11 ILE A  61      37.490  69.761  -3.965  1.00  0.00           H  
ATOM    965 HD12 ILE A  61      35.919  70.556  -3.864  1.00  0.00           H  
ATOM    966 HD13 ILE A  61      37.287  71.185  -2.945  1.00  0.00           H  
ATOM    967  N   GLN A  62      34.568  69.555   2.268  1.00  0.00           N  
ATOM    968  CA  GLN A  62      34.147  70.223   3.495  1.00  0.00           C  
ATOM    969  C   GLN A  62      35.270  71.088   4.055  1.00  0.00           C  
ATOM    970  O   GLN A  62      36.376  70.605   4.306  1.00  0.00           O  
ATOM    971  CB  GLN A  62      33.711  69.192   4.537  1.00  0.00           C  
ATOM    972  CG  GLN A  62      32.641  69.704   5.488  1.00  0.00           C  
ATOM    973  CD  GLN A  62      31.865  68.583   6.151  1.00  0.00           C  
ATOM    974  OE1 GLN A  62      30.638  68.525   6.065  1.00  0.00           O  
ATOM    975  NE2 GLN A  62      32.579  67.683   6.818  1.00  0.00           N  
ATOM    976  H   GLN A  62      34.933  68.648   2.319  1.00  0.00           H  
ATOM    977  HA  GLN A  62      33.307  70.857   3.255  1.00  0.00           H  
ATOM    978  HB2 GLN A  62      33.324  68.323   4.028  1.00  0.00           H  
ATOM    979  HB3 GLN A  62      34.572  68.903   5.122  1.00  0.00           H  
ATOM    980  HG2 GLN A  62      33.113  70.297   6.256  1.00  0.00           H  
ATOM    981  HG3 GLN A  62      31.950  70.321   4.932  1.00  0.00           H  
ATOM    982 HE21 GLN A  62      33.552  67.793   6.845  1.00  0.00           H  
ATOM    983 HE22 GLN A  62      32.103  66.949   7.257  1.00  0.00           H  
ATOM    984  N   THR A  63      34.982  72.371   4.251  1.00  0.00           N  
ATOM    985  CA  THR A  63      35.968  73.305   4.781  1.00  0.00           C  
ATOM    986  C   THR A  63      35.930  73.337   6.304  1.00  0.00           C  
ATOM    987  O   THR A  63      34.972  73.823   6.901  1.00  0.00           O  
ATOM    988  CB  THR A  63      35.739  74.729   4.243  1.00  0.00           C  
ATOM    989  OG1 THR A  63      34.456  75.210   4.659  1.00  0.00           O  
ATOM    990  CG2 THR A  63      35.828  74.754   2.724  1.00  0.00           C  
ATOM    991  H   THR A  63      34.084  72.697   4.031  1.00  0.00           H  
ATOM    992  HA  THR A  63      36.946  72.974   4.461  1.00  0.00           H  
ATOM    993  HB  THR A  63      36.505  75.376   4.643  1.00  0.00           H  
ATOM    994  HG1 THR A  63      33.804  74.513   4.553  1.00  0.00           H  
ATOM    995 HG21 THR A  63      36.019  73.757   2.358  1.00  0.00           H  
ATOM    996 HG22 THR A  63      36.630  75.410   2.421  1.00  0.00           H  
ATOM    997 HG23 THR A  63      34.895  75.115   2.315  1.00  0.00           H  
ATOM    998  N   GLY A  64      36.983  72.816   6.929  1.00  0.00           N  
ATOM    999  CA  GLY A  64      37.050  72.796   8.379  1.00  0.00           C  
ATOM   1000  C   GLY A  64      37.762  74.009   8.942  1.00  0.00           C  
ATOM   1001  O   GLY A  64      37.126  74.917   9.478  1.00  0.00           O  
ATOM   1002  H   GLY A  64      37.719  72.441   6.400  1.00  0.00           H  
ATOM   1003  HA2 GLY A  64      36.046  72.764   8.774  1.00  0.00           H  
ATOM   1004  HA3 GLY A  64      37.576  71.906   8.690  1.00  0.00           H  
ATOM   1005  N   ALA A  65      39.085  74.025   8.824  1.00  0.00           N  
ATOM   1006  CA  ALA A  65      39.884  75.136   9.326  1.00  0.00           C  
ATOM   1007  C   ALA A  65      39.188  76.469   9.075  1.00  0.00           C  
ATOM   1008  O   ALA A  65      39.031  76.894   7.931  1.00  0.00           O  
ATOM   1009  CB  ALA A  65      41.262  75.128   8.681  1.00  0.00           C  
ATOM   1010  H   ALA A  65      39.535  73.271   8.387  1.00  0.00           H  
ATOM   1011  HA  ALA A  65      40.011  75.001  10.390  1.00  0.00           H  
ATOM   1012  HB1 ALA A  65      41.756  76.068   8.877  1.00  0.00           H  
ATOM   1013  HB2 ALA A  65      41.849  74.321   9.096  1.00  0.00           H  
ATOM   1014  HB3 ALA A  65      41.161  74.989   7.616  1.00  0.00           H  
ATOM   1015  N   THR A  66      38.772  77.127  10.154  1.00  0.00           N  
ATOM   1016  CA  THR A  66      38.092  78.410  10.051  1.00  0.00           C  
ATOM   1017  C   THR A  66      39.021  79.483   9.495  1.00  0.00           C  
ATOM   1018  O   THR A  66      40.170  79.204   9.149  1.00  0.00           O  
ATOM   1019  CB  THR A  66      37.553  78.872  11.419  1.00  0.00           C  
ATOM   1020  OG1 THR A  66      36.712  77.859  11.981  1.00  0.00           O  
ATOM   1021  CG2 THR A  66      36.771  80.169  11.281  1.00  0.00           C  
ATOM   1022  H   THR A  66      38.927  76.735  11.039  1.00  0.00           H  
ATOM   1023  HA  THR A  66      37.253  78.291   9.380  1.00  0.00           H  
ATOM   1024  HB  THR A  66      38.391  79.043  12.079  1.00  0.00           H  
ATOM   1025  HG1 THR A  66      36.025  77.628  11.353  1.00  0.00           H  
ATOM   1026 HG21 THR A  66      37.141  80.726  10.434  1.00  0.00           H  
ATOM   1027 HG22 THR A  66      36.892  80.760  12.178  1.00  0.00           H  
ATOM   1028 HG23 THR A  66      35.724  79.945  11.137  1.00  0.00           H  
TER    1029      THR A  66                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
