
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   85 (  723),  selected   85 , name 2f5k_B
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2f5k_B.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_B      E       1           -
LGA    P     7_B      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    K     8_B      Q       6          3.687
LGA    P     9_B      G       7          3.612
LGA    K    10_B      D       8          4.260
LGA    F    11_B      L       9          1.895
LGA    Q    12_B      I      10          1.471
LGA    E    13_B      V      11          0.597
LGA    G    14_B      S      12          0.276
LGA    E    15_B      M      13          0.415
LGA    R    16_B      R      14          0.113
LGA    V    17_B      I      15          0.126
LGA    L    18_B      L      16          0.517
LGA    C    19_B      G      17          0.767
LGA    F    20_B      K      18          0.756
LGA    H    21_B      K      19          0.988
LGA    G    22_B      R      20          2.907
LGA    -       -      T      21           -
LGA    P    23_B      K      22          1.548
LGA    L    24_B      T      23          0.423
LGA    L    25_B      W      24          0.638
LGA    Y    26_B      X      25          0.282
LGA    E    27_B      K      26          0.363
LGA    A    28_B      G      27          0.626
LGA    K    29_B      T      28          0.526
LGA    C    30_B      L      29          0.268
LGA    V    31_B      I      30          0.396
LGA    K    32_B      A      31          0.718
LGA    V    33_B      I      32          1.071
LGA    A    34_B      Q      33          1.343
LGA    I    35_B      T      34          1.486
LGA    K    36_B      V      35          1.559
LGA    D    37_B      G      36          1.831
LGA    K    38_B      P      37          1.785
LGA    Q    39_B      G      38          1.913
LGA    V    40_B      K      39          1.629
LGA    K    41_B      K      40          0.771
LGA    Y    42_B      Y      41          0.870
LGA    F    43_B      K      42          0.938
LGA    I    44_B      V      43          0.760
LGA    H    45_B      K      44          0.192
LGA    Y    46_B      F      45          0.400
LGA    S    47_B      D      46          0.533
LGA    G    48_B      N      47          1.769
LGA    W    49_B      K      48          2.032
LGA    N    50_B      -       -           -
LGA    K    51_B      -       -           -
LGA    N    52_B      -       -           -
LGA    W    53_B      G      49          2.039
LGA    D    54_B      K      50          0.902
LGA    E    55_B      S      51          1.853
LGA    W    56_B      L      52          1.188
LGA    V    57_B      L      53          0.927
LGA    P    58_B      S      54          0.954
LGA    E    59_B      G      55          0.483
LGA    S    60_B      N      56          0.775
LGA    R    61_B      X      57          0.239
LGA    V    62_B      I      58          0.537
LGA    L    63_B      A      59          0.280
LGA    K    64_B      Y      60          0.392
LGA    Y    65_B      D      61          0.674
LGA    V    66_B      Y      62          0.567
LGA    D    67_B      -       -           -
LGA    T    68_B      -       -           -
LGA    N    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    Q    71_B      -       -           -
LGA    K    72_B      -       -           -
LGA    Q    73_B      -       -           -
LGA    R    74_B      -       -           -
LGA    E    75_B      -       -           -
LGA    L    76_B      -       -           -
LGA    Q    77_B      -       -           -
LGA    K    78_B      -       -           -
LGA    A    79_B      -       -           -
LGA    N    80_B      -       -           -
LGA    Q    81_B      -       -           -
LGA    E    82_B      -       -           -
LGA    Q    83_B      -       -           -
LGA    Y    84_B      -       -           -
LGA    A    85_B      -       -           -
LGA    E    86_B      -       -           -
LGA    G    87_B      -       -           -
LGA    K    88_B      -       -           -
LGA    M    89_B      -       -           -
LGA    R    90_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   85   62    5.0     56    1.41     7.14     85.774     3.708

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.096300 * X  +   0.508482 * Y  +  -0.855671 * Z  +  47.309414
  Y_new =   0.016673 * X  +   0.860370 * Y  +   0.509397 * Z  +  60.989174
  Z_new =   0.995213 * X  +   0.034788 * Y  +  -0.091332 * Z  +   6.123209 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.777662   -0.363931  [ DEG:   159.1483    -20.8517 ]
  Theta =  -1.472907   -1.668686  [ DEG:   -84.3914    -95.6086 ]
  Phi   =   2.970152   -0.171440  [ DEG:   170.1772     -9.8228 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f5k_B                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f5k_B.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   85   62   5.0   56   1.41    7.14  85.774
REMARK  ---------------------------------------------------------- 
MOLECULE 2f5k_B
HEADER    GENE REGULATION                         26-NOV-05   2F5K              
TITLE     CRYSTAL STRUCTURE OF THE CHROMO DOMAIN OF HUMAN MRG15                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORF-RELATED GENE 15 ISOFORM 1;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-3E-HIS                                
KEYWDS    BETA BARREL, GENE REGULATION                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.ZHANG,J.DU,J.DING                                                   
REVDAT   2   25-DEC-07 2F5K    1       JRNL                                     
REVDAT   1   14-NOV-06 2F5K    0                                                
JRNL        AUTH   P.ZHANG,J.DU,B.SUN,X.DONG,G.XU,J.ZHOU,Q.HUANG,               
JRNL        AUTH 2 Q.LIU,Q.HAO,J.DING                                           
JRNL        TITL   STRUCTURE OF HUMAN MRG15 CHROMO DOMAIN AND ITS               
JRNL        TITL 2 BINDING TO LYS36-METHYLATED HISTONE H3.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  6621 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2F5K A    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K B    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K C    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K D    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K E    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K F    1    90  GB     5803102  NP_006782        1     90             
SEQRES   1 A  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 A  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 A  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 A  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 A  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 A  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 A  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 A  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 B  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 B  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 B  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 B  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 B  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 B  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 B  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 B  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 C  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 C  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 C  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 C  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 C  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 C  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 C  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 C  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 D  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 D  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 D  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 D  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 D  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 D  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 D  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 D  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 E  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 E  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 E  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 E  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 E  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 E  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 E  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 E  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 F  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 F  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 F  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 F  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 F  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 F  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 F  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 F  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
FORMUL   7  HOH   *457(H2 O)                                                    
CRYST1  109.480   80.313   81.285  90.00 123.91  90.00 C 1 2 1      24          
ATOM    705  N   ASP B   6      31.849  80.798 -10.674  1.00 86.07           N  
ATOM    706  CA  ASP B   6      31.958  81.229  -9.259  1.00 85.84           C  
ATOM    707  C   ASP B   6      33.280  81.970  -9.084  1.00 84.75           C  
ATOM    708  O   ASP B   6      34.339  81.345  -9.080  1.00 85.22           O  
ATOM    709  CB  ASP B   6      31.917  80.001  -8.354  1.00 86.56           C  
ATOM    710  CG  ASP B   6      30.891  80.122  -7.237  1.00 88.13           C  
ATOM    711  OD1 ASP B   6      31.080  80.976  -6.338  1.00 89.16           O  
ATOM    712  OD2 ASP B   6      29.876  79.386  -7.170  1.00 89.35           O  
ATOM    713  N   PRO B   7      33.220  83.297  -8.959  1.00 83.26           N  
ATOM    714  CA  PRO B   7      34.428  84.121  -8.807  1.00 81.19           C  
ATOM    715  C   PRO B   7      35.392  83.641  -7.706  1.00 78.55           C  
ATOM    716  O   PRO B   7      36.568  83.365  -7.995  1.00 78.85           O  
ATOM    717  CB  PRO B   7      33.862  85.511  -8.472  1.00 81.77           C  
ATOM    718  CG  PRO B   7      32.508  85.534  -9.122  1.00 82.83           C  
ATOM    719  CD  PRO B   7      31.988  84.116  -8.980  1.00 83.49           C  
ATOM    720  N   LYS B   8      34.906  83.523  -6.471  1.00 74.64           N  
ATOM    721  CA  LYS B   8      35.786  83.173  -5.356  1.00 70.53           C  
ATOM    722  C   LYS B   8      35.651  81.743  -4.796  1.00 66.37           C  
ATOM    723  O   LYS B   8      34.547  81.254  -4.538  1.00 66.05           O  
ATOM    724  CB  LYS B   8      35.687  84.235  -4.259  1.00 71.12           C  
ATOM    725  CG  LYS B   8      36.602  85.417  -4.499  1.00 72.89           C  
ATOM    726  CD  LYS B   8      36.152  86.623  -3.699  1.00 75.27           C  
ATOM    727  CE  LYS B   8      35.158  87.470  -4.489  1.00 76.32           C  
ATOM    728  NZ  LYS B   8      34.929  88.770  -3.796  1.00 76.64           N  
ATOM    729  N   PRO B   9      36.797  81.082  -4.634  1.00 62.00           N  
ATOM    730  CA  PRO B   9      36.867  79.694  -4.149  1.00 57.91           C  
ATOM    731  C   PRO B   9      36.749  79.559  -2.637  1.00 53.09           C  
ATOM    732  O   PRO B   9      37.312  80.313  -1.857  1.00 52.36           O  
ATOM    733  CB  PRO B   9      38.261  79.276  -4.588  1.00 58.16           C  
ATOM    734  CG  PRO B   9      39.016  80.518  -4.343  1.00 60.32           C  
ATOM    735  CD  PRO B   9      38.139  81.605  -4.948  1.00 61.74           C  
ATOM    736  N   LYS B  10      36.026  78.549  -2.221  1.00 48.25           N  
ATOM    737  CA  LYS B  10      35.775  78.358  -0.811  1.00 43.87           C  
ATOM    738  C   LYS B  10      37.009  77.863  -0.089  1.00 41.17           C  
ATOM    739  O   LYS B  10      37.191  78.111   1.096  1.00 39.77           O  
ATOM    740  CB  LYS B  10      34.627  77.372  -0.664  1.00 43.59           C  
ATOM    741  CG  LYS B  10      34.276  76.993   0.748  1.00 40.29           C  
ATOM    742  CD  LYS B  10      32.960  76.311   0.707  1.00 37.36           C  
ATOM    743  CE  LYS B  10      32.494  75.926   2.099  1.00 36.53           C  
ATOM    744  NZ  LYS B  10      31.250  75.105   1.961  1.00 35.26           N  
ATOM    745  N   PHE B  11      37.894  77.200  -0.815  1.00 38.49           N  
ATOM    746  CA  PHE B  11      39.081  76.650  -0.173  1.00 36.96           C  
ATOM    747  C   PHE B  11      40.328  77.144  -0.924  1.00 36.88           C  
ATOM    748  O   PHE B  11      40.220  77.559  -2.032  1.00 35.43           O  
ATOM    749  CB  PHE B  11      39.036  75.122  -0.221  1.00 35.53           C  
ATOM    750  CG  PHE B  11      37.893  74.513   0.555  1.00 33.09           C  
ATOM    751  CD1 PHE B  11      36.687  74.213  -0.078  1.00 32.58           C  
ATOM    752  CD2 PHE B  11      38.006  74.258   1.911  1.00 28.67           C  
ATOM    753  CE1 PHE B  11      35.622  73.629   0.637  1.00 30.86           C  
ATOM    754  CE2 PHE B  11      36.939  73.693   2.626  1.00 28.65           C  
ATOM    755  CZ  PHE B  11      35.751  73.369   1.985  1.00 28.73           C  
ATOM    756  N   GLN B  12      41.501  77.086  -0.319  1.00 37.35           N  
ATOM    757  CA  GLN B  12      42.707  77.441  -1.046  1.00 37.93           C  
ATOM    758  C   GLN B  12      43.781  76.359  -1.021  1.00 37.73           C  
ATOM    759  O   GLN B  12      43.760  75.430  -0.199  1.00 36.06           O  
ATOM    760  CB  GLN B  12      43.307  78.676  -0.450  1.00 38.80           C  
ATOM    761  CG  GLN B  12      43.859  78.413   0.881  1.00 41.80           C  
ATOM    762  CD  GLN B  12      44.331  79.667   1.525  1.00 47.41           C  
ATOM    763  OE1 GLN B  12      43.638  80.704   1.459  1.00 51.24           O  
ATOM    764  NE2 GLN B  12      45.510  79.604   2.162  1.00 47.90           N  
ATOM    765  N   GLU B  13      44.752  76.532  -1.913  1.00 37.96           N  
ATOM    766  CA  GLU B  13      45.845  75.588  -2.087  1.00 38.22           C  
ATOM    767  C   GLU B  13      46.626  75.470  -0.836  1.00 35.99           C  
ATOM    768  O   GLU B  13      46.985  76.455  -0.259  1.00 36.23           O  
ATOM    769  CB  GLU B  13      46.763  76.018  -3.257  1.00 40.14           C  
ATOM    770  CG  GLU B  13      46.062  75.953  -4.610  1.00 44.04           C  
ATOM    771  CD  GLU B  13      46.975  76.267  -5.795  1.00 48.83           C  
ATOM    772  OE1 GLU B  13      48.210  76.016  -5.687  1.00 48.30           O  
ATOM    773  OE2 GLU B  13      46.432  76.759  -6.836  1.00 51.77           O  
ATOM    774  N   GLY B  14      46.888  74.256  -0.398  1.00 34.60           N  
ATOM    775  CA  GLY B  14      47.638  74.087   0.828  1.00 32.73           C  
ATOM    776  C   GLY B  14      46.716  73.916   2.025  1.00 31.66           C  
ATOM    777  O   GLY B  14      47.166  73.483   3.080  1.00 31.63           O  
ATOM    778  N   GLU B  15      45.431  74.226   1.877  1.00 30.35           N  
ATOM    779  CA  GLU B  15      44.505  74.102   3.015  1.00 30.03           C  
ATOM    780  C   GLU B  15      44.193  72.638   3.323  1.00 29.76           C  
ATOM    781  O   GLU B  15      43.831  71.851   2.402  1.00 29.38           O  
ATOM    782  CB  GLU B  15      43.180  74.787   2.710  1.00 30.89           C  
ATOM    783  CG  GLU B  15      42.241  75.020   3.896  1.00 31.79           C  
ATOM    784  CD  GLU B  15      40.956  75.739   3.472  1.00 33.75           C  
ATOM    785  OE1 GLU B  15      40.932  76.335   2.382  1.00 33.19           O  
ATOM    786  OE2 GLU B  15      39.960  75.708   4.220  1.00 34.57           O  
ATOM    787  N   ARG B  16      44.359  72.279   4.596  1.00 28.23           N  
ATOM    788  CA  ARG B  16      43.969  70.988   5.083  1.00 28.03           C  
ATOM    789  C   ARG B  16      42.440  70.983   5.088  1.00 26.90           C  
ATOM    790  O   ARG B  16      41.793  71.926   5.550  1.00 26.70           O  
ATOM    791  CB  ARG B  16      44.497  70.777   6.499  1.00 27.75           C  
ATOM    792  CG  ARG B  16      44.014  69.486   7.119  1.00 31.69           C  
ATOM    793  CD  ARG B  16      44.634  69.176   8.496  1.00 36.95           C  
ATOM    794  NE  ARG B  16      44.419  70.301   9.391  1.00 40.35           N  
ATOM    795  CZ  ARG B  16      44.581  70.281  10.724  1.00 42.98           C  
ATOM    796  NH1 ARG B  16      44.941  69.178  11.376  1.00 43.50           N  
ATOM    797  NH2 ARG B  16      44.334  71.385  11.404  1.00 43.43           N  
ATOM    798  N   VAL B  17      41.849  69.921   4.582  1.00 25.64           N  
ATOM    799  CA  VAL B  17      40.403  69.901   4.505  1.00 25.19           C  
ATOM    800  C   VAL B  17      39.854  68.532   4.867  1.00 23.90           C  
ATOM    801  O   VAL B  17      40.632  67.598   5.156  1.00 21.67           O  
ATOM    802  CB  VAL B  17      39.963  70.253   3.106  1.00 25.87           C  
ATOM    803  CG1 VAL B  17      38.521  70.186   3.036  1.00 30.80           C  
ATOM    804  CG2 VAL B  17      40.365  71.716   2.727  1.00 26.04           C  
ATOM    805  N   LEU B  18      38.529  68.413   4.892  1.00 22.86           N  
ATOM    806  CA  LEU B  18      37.922  67.102   5.010  1.00 24.97           C  
ATOM    807  C   LEU B  18      37.262  66.872   3.684  1.00 25.50           C  
ATOM    808  O   LEU B  18      36.737  67.803   3.088  1.00 27.32           O  
ATOM    809  CB  LEU B  18      36.875  67.029   6.112  1.00 25.40           C  
ATOM    810  CG  LEU B  18      37.386  67.043   7.542  1.00 26.79           C  
ATOM    811  CD1 LEU B  18      36.175  67.079   8.563  1.00 25.90           C  
ATOM    812  CD2 LEU B  18      38.213  65.772   7.733  1.00 27.83           C  
ATOM    813  N   CYS B  19      37.292  65.664   3.176  1.00 24.66           N  
ATOM    814  CA  CYS B  19      36.764  65.479   1.838  1.00 24.54           C  
ATOM    815  C   CYS B  19      36.054  64.165   1.741  1.00 25.41           C  
ATOM    816  O   CYS B  19      36.572  63.138   2.192  1.00 24.72           O  
ATOM    817  CB  CYS B  19      37.893  65.540   0.789  1.00 23.76           C  
ATOM    818  SG  CYS B  19      37.377  65.430  -0.963  1.00 26.21           S  
ATOM    819  N   PHE B  20      34.902  64.173   1.074  1.00 26.72           N  
ATOM    820  CA  PHE B  20      34.152  62.932   0.836  1.00 28.76           C  
ATOM    821  C   PHE B  20      34.754  62.063  -0.251  1.00 30.50           C  
ATOM    822  O   PHE B  20      35.082  62.552  -1.316  1.00 31.12           O  
ATOM    823  CB  PHE B  20      32.721  63.227   0.408  1.00 28.20           C  
ATOM    824  CG  PHE B  20      31.803  63.464   1.549  1.00 30.54           C  
ATOM    825  CD1 PHE B  20      31.400  64.730   1.876  1.00 31.80           C  
ATOM    826  CD2 PHE B  20      31.366  62.411   2.313  1.00 32.57           C  
ATOM    827  CE1 PHE B  20      30.535  64.948   2.961  1.00 31.42           C  
ATOM    828  CE2 PHE B  20      30.514  62.615   3.361  1.00 33.11           C  
ATOM    829  CZ  PHE B  20      30.105  63.912   3.688  1.00 31.64           C  
ATOM    830  N   HIS B  21      34.843  60.762   0.011  1.00 32.28           N  
ATOM    831  CA  HIS B  21      35.252  59.836  -1.003  1.00 34.78           C  
ATOM    832  C   HIS B  21      34.312  58.660  -0.805  1.00 35.41           C  
ATOM    833  O   HIS B  21      34.466  57.881   0.126  1.00 35.64           O  
ATOM    834  CB  HIS B  21      36.714  59.434  -0.820  1.00 36.34           C  
ATOM    835  CG  HIS B  21      37.202  58.535  -1.900  1.00 39.19           C  
ATOM    836  ND1 HIS B  21      37.215  57.164  -1.771  1.00 41.91           N  
ATOM    837  CD2 HIS B  21      37.643  58.805  -3.149  1.00 42.44           C  
ATOM    838  CE1 HIS B  21      37.649  56.623  -2.897  1.00 43.54           C  
ATOM    839  NE2 HIS B  21      37.918  57.597  -3.751  1.00 44.52           N  
ATOM    840  N   GLY B  22      33.319  58.527  -1.671  1.00 35.91           N  
ATOM    841  CA  GLY B  22      32.272  57.573  -1.366  1.00 37.67           C  
ATOM    842  C   GLY B  22      31.477  58.131  -0.186  1.00 37.68           C  
ATOM    843  O   GLY B  22      31.283  59.331  -0.099  1.00 38.55           O  
ATOM    844  N   PRO B  23      31.030  57.280   0.714  1.00 38.07           N  
ATOM    845  CA  PRO B  23      30.212  57.694   1.862  1.00 37.87           C  
ATOM    846  C   PRO B  23      30.955  58.175   3.096  1.00 37.57           C  
ATOM    847  O   PRO B  23      30.320  58.412   4.119  1.00 38.49           O  
ATOM    848  CB  PRO B  23      29.478  56.389   2.202  1.00 38.30           C  
ATOM    849  CG  PRO B  23      30.609  55.356   2.010  1.00 38.39           C  
ATOM    850  CD  PRO B  23      31.216  55.805   0.672  1.00 38.80           C  
ATOM    851  N   LEU B  24      32.273  58.323   3.029  1.00 37.15           N  
ATOM    852  CA  LEU B  24      33.059  58.683   4.212  1.00 34.97           C  
ATOM    853  C   LEU B  24      33.884  59.927   3.999  1.00 32.79           C  
ATOM    854  O   LEU B  24      34.244  60.253   2.869  1.00 32.13           O  
ATOM    855  CB  LEU B  24      33.993  57.526   4.552  1.00 35.92           C  
ATOM    856  CG  LEU B  24      33.334  56.257   5.115  1.00 37.63           C  
ATOM    857  CD1 LEU B  24      34.351  55.105   5.158  1.00 37.39           C  
ATOM    858  CD2 LEU B  24      32.778  56.590   6.524  1.00 38.16           C  
ATOM    859  N   LEU B  25      34.163  60.610   5.094  1.00 30.98           N  
ATOM    860  CA  LEU B  25      34.947  61.838   5.121  1.00 30.10           C  
ATOM    861  C   LEU B  25      36.387  61.535   5.522  1.00 29.23           C  
ATOM    862  O   LEU B  25      36.627  60.897   6.533  1.00 28.12           O  
ATOM    863  CB  LEU B  25      34.369  62.857   6.117  1.00 29.97           C  
ATOM    864  CG  LEU B  25      33.235  63.717   5.558  1.00 29.53           C  
ATOM    865  CD1 LEU B  25      32.486  64.382   6.688  1.00 27.82           C  
ATOM    866  CD2 LEU B  25      33.759  64.741   4.546  1.00 27.53           C  
ATOM    867  N   TYR B  26      37.331  62.032   4.729  1.00 28.93           N  
ATOM    868  CA  TYR B  26      38.742  61.798   4.979  1.00 28.77           C  
ATOM    869  C   TYR B  26      39.501  63.101   5.099  1.00 27.65           C  
ATOM    870  O   TYR B  26      39.193  64.072   4.409  1.00 26.81           O  
ATOM    871  CB  TYR B  26      39.335  61.036   3.804  1.00 29.86           C  
ATOM    872  CG  TYR B  26      38.769  59.660   3.648  1.00 32.77           C  
ATOM    873  CD1 TYR B  26      37.684  59.416   2.810  1.00 35.95           C  
ATOM    874  CD2 TYR B  26      39.293  58.606   4.362  1.00 35.40           C  
ATOM    875  CE1 TYR B  26      37.147  58.122   2.688  1.00 38.38           C  
ATOM    876  CE2 TYR B  26      38.765  57.324   4.251  1.00 38.48           C  
ATOM    877  CZ  TYR B  26      37.705  57.089   3.414  1.00 38.96           C  
ATOM    878  OH  TYR B  26      37.218  55.810   3.309  1.00 40.91           O  
ATOM    879  N   GLU B  27      40.505  63.092   5.970  1.00 26.19           N  
ATOM    880  CA  GLU B  27      41.430  64.183   6.078  1.00 26.24           C  
ATOM    881  C   GLU B  27      42.145  64.326   4.725  1.00 25.83           C  
ATOM    882  O   GLU B  27      42.526  63.337   4.091  1.00 25.51           O  
ATOM    883  CB  GLU B  27      42.405  63.918   7.204  1.00 25.31           C  
ATOM    884  CG  GLU B  27      43.343  65.071   7.428  1.00 28.15           C  
ATOM    885  CD  GLU B  27      44.314  64.783   8.544  1.00 31.40           C  
ATOM    886  OE1 GLU B  27      44.066  63.851   9.341  1.00 33.35           O  
ATOM    887  OE2 GLU B  27      45.320  65.462   8.615  1.00 31.79           O  
ATOM    888  N   ALA B  28      42.268  65.543   4.248  1.00 26.14           N  
ATOM    889  CA  ALA B  28      42.874  65.768   2.950  1.00 27.30           C  
ATOM    890  C   ALA B  28      43.450  67.175   2.831  1.00 29.01           C  
ATOM    891  O   ALA B  28      43.255  68.019   3.716  1.00 29.26           O  
ATOM    892  CB  ALA B  28      41.849  65.541   1.852  1.00 25.81           C  
ATOM    893  N   LYS B  29      44.135  67.416   1.717  1.00 30.56           N  
ATOM    894  CA  LYS B  29      44.759  68.686   1.430  1.00 33.47           C  
ATOM    895  C   LYS B  29      44.431  69.173   0.000  1.00 34.73           C  
ATOM    896  O   LYS B  29      44.424  68.411  -0.968  1.00 33.85           O  
ATOM    897  CB  LYS B  29      46.269  68.630   1.674  1.00 34.22           C  
ATOM    898  CG  LYS B  29      46.656  68.901   3.172  1.00 38.89           C  
ATOM    899  CD  LYS B  29      46.431  67.663   4.109  1.00 43.01           C  
ATOM    900  CE  LYS B  29      46.823  67.943   5.591  1.00 44.39           C  
ATOM    901  NZ  LYS B  29      46.644  66.759   6.541  1.00 44.99           N  
ATOM    902  N   CYS B  30      44.111  70.444  -0.109  1.00 36.93           N  
ATOM    903  CA  CYS B  30      43.836  71.027  -1.415  1.00 39.77           C  
ATOM    904  C   CYS B  30      45.176  71.290  -2.110  1.00 41.44           C  
ATOM    905  O   CYS B  30      45.988  72.119  -1.649  1.00 41.51           O  
ATOM    906  CB  CYS B  30      43.071  72.316  -1.258  1.00 39.49           C  
ATOM    907  SG  CYS B  30      42.845  73.134  -2.857  1.00 44.17           S  
ATOM    908  N   VAL B  31      45.444  70.557  -3.178  1.00 42.97           N  
ATOM    909  CA  VAL B  31      46.725  70.746  -3.859  1.00 45.01           C  
ATOM    910  C   VAL B  31      46.602  71.833  -4.917  1.00 46.19           C  
ATOM    911  O   VAL B  31      47.477  72.661  -5.065  1.00 45.73           O  
ATOM    912  CB  VAL B  31      47.247  69.440  -4.503  1.00 45.02           C  
ATOM    913  CG1 VAL B  31      48.644  69.660  -5.111  1.00 45.62           C  
ATOM    914  CG2 VAL B  31      47.294  68.318  -3.468  1.00 45.43           C  
ATOM    915  N   LYS B  32      45.497  71.838  -5.638  1.00 48.25           N  
ATOM    916  CA  LYS B  32      45.296  72.838  -6.671  1.00 50.98           C  
ATOM    917  C   LYS B  32      43.838  73.267  -6.791  1.00 52.15           C  
ATOM    918  O   LYS B  32      42.938  72.455  -6.726  1.00 51.96           O  
ATOM    919  CB  LYS B  32      45.828  72.355  -8.039  1.00 51.26           C  
ATOM    920  CG  LYS B  32      47.210  72.936  -8.418  1.00 53.72           C  
ATOM    921  CD  LYS B  32      47.551  72.754  -9.915  1.00 55.98           C  
ATOM    922  CE  LYS B  32      48.691  73.715 -10.354  1.00 57.97           C  
ATOM    923  NZ  LYS B  32      49.397  73.329 -11.620  1.00 57.06           N  
ATOM    924  N   VAL B  33      43.621  74.560  -6.983  1.00 54.48           N  
ATOM    925  CA  VAL B  33      42.277  75.088  -7.160  1.00 56.70           C  
ATOM    926  C   VAL B  33      42.113  75.439  -8.626  1.00 58.98           C  
ATOM    927  O   VAL B  33      43.046  75.937  -9.235  1.00 59.38           O  
ATOM    928  CB  VAL B  33      42.071  76.345  -6.308  1.00 56.26           C  
ATOM    929  CG1 VAL B  33      40.667  76.897  -6.488  1.00 55.79           C  
ATOM    930  CG2 VAL B  33      42.373  76.047  -4.857  1.00 54.66           C  
ATOM    931  N   ALA B  34      40.950  75.153  -9.201  1.00 61.82           N  
ATOM    932  CA  ALA B  34      40.689  75.484 -10.602  1.00 64.49           C  
ATOM    933  C   ALA B  34      39.217  75.739 -10.853  1.00 66.80           C  
ATOM    934  O   ALA B  34      38.345  75.045 -10.320  1.00 66.82           O  
ATOM    935  CB  ALA B  34      41.185  74.399 -11.513  1.00 64.39           C  
ATOM    936  N   ILE B  35      38.937  76.738 -11.678  1.00 69.43           N  
ATOM    937  CA  ILE B  35      37.558  77.070 -11.979  1.00 72.19           C  
ATOM    938  C   ILE B  35      37.212  76.709 -13.412  1.00 73.92           C  
ATOM    939  O   ILE B  35      37.707  77.316 -14.350  1.00 74.02           O  
ATOM    940  CB  ILE B  35      37.286  78.555 -11.707  1.00 72.15           C  
ATOM    941  CG1 ILE B  35      37.524  78.866 -10.227  1.00 72.15           C  
ATOM    942  CG2 ILE B  35      35.868  78.900 -12.101  1.00 72.49           C  
ATOM    943  CD1 ILE B  35      37.480  80.326  -9.881  1.00 71.70           C  
ATOM    944  N   LYS B  36      36.371  75.697 -13.569  1.00 76.12           N  
ATOM    945  CA  LYS B  36      35.958  75.255 -14.888  1.00 78.21           C  
ATOM    946  C   LYS B  36      34.485  75.566 -15.131  1.00 79.07           C  
ATOM    947  O   LYS B  36      33.614  75.097 -14.397  1.00 79.11           O  
ATOM    948  CB  LYS B  36      36.213  73.756 -15.055  1.00 78.77           C  
ATOM    949  CG  LYS B  36      35.654  73.171 -16.347  1.00 80.67           C  
ATOM    950  CD  LYS B  36      35.800  71.648 -16.390  1.00 83.63           C  
ATOM    951  CE  LYS B  36      35.407  71.087 -17.763  1.00 85.61           C  
ATOM    952  NZ  LYS B  36      35.426  69.598 -17.817  1.00 86.71           N  
ATOM    953  N   ASP B  37      34.205  76.378 -16.145  1.00 80.03           N  
ATOM    954  CA  ASP B  37      32.819  76.668 -16.490  1.00 80.95           C  
ATOM    955  C   ASP B  37      32.112  77.336 -15.326  1.00 80.66           C  
ATOM    956  O   ASP B  37      30.917  77.137 -15.111  1.00 80.85           O  
ATOM    957  CB  ASP B  37      32.108  75.359 -16.815  1.00 81.74           C  
ATOM    958  CG  ASP B  37      31.286  75.450 -18.058  1.00 83.76           C  
ATOM    959  OD1 ASP B  37      30.834  76.573 -18.376  1.00 85.51           O  
ATOM    960  OD2 ASP B  37      31.046  74.454 -18.776  1.00 85.41           O  
ATOM    961  N   LYS B  38      32.876  78.105 -14.561  1.00 80.09           N  
ATOM    962  CA  LYS B  38      32.389  78.786 -13.366  1.00 79.20           C  
ATOM    963  C   LYS B  38      31.800  77.849 -12.305  1.00 77.56           C  
ATOM    964  O   LYS B  38      30.870  78.189 -11.587  1.00 77.64           O  
ATOM    965  CB  LYS B  38      31.446  79.925 -13.722  1.00 80.01           C  
ATOM    966  CG  LYS B  38      31.887  81.241 -13.117  1.00 82.13           C  
ATOM    967  CD  LYS B  38      30.897  82.351 -13.439  1.00 85.95           C  
ATOM    968  CE  LYS B  38      31.231  83.650 -12.705  1.00 87.83           C  
ATOM    969  NZ  LYS B  38      30.201  84.703 -12.959  1.00 89.02           N  
ATOM    970  N   GLN B  39      32.339  76.642 -12.245  1.00 75.32           N  
ATOM    971  CA  GLN B  39      32.058  75.745 -11.147  1.00 72.93           C  
ATOM    972  C   GLN B  39      33.446  75.646 -10.555  1.00 70.30           C  
ATOM    973  O   GLN B  39      34.436  75.753 -11.287  1.00 70.23           O  
ATOM    974  CB  GLN B  39      31.575  74.372 -11.625  1.00 73.58           C  
ATOM    975  CG  GLN B  39      30.227  74.359 -12.359  1.00 74.92           C  
ATOM    976  CD  GLN B  39      29.045  74.701 -11.470  1.00 76.27           C  
ATOM    977  OE1 GLN B  39      29.197  74.882 -10.265  1.00 76.52           O  
ATOM    978  NE2 GLN B  39      27.865  74.799 -12.066  1.00 76.89           N  
ATOM    979  N   VAL B  40      33.561  75.503  -9.244  1.00 66.90           N  
ATOM    980  CA  VAL B  40      34.908  75.387  -8.684  1.00 63.45           C  
ATOM    981  C   VAL B  40      35.261  73.924  -8.485  1.00 60.27           C  
ATOM    982  O   VAL B  40      34.413  73.143  -8.051  1.00 60.42           O  
ATOM    983  CB  VAL B  40      35.076  76.173  -7.368  1.00 63.64           C  
ATOM    984  CG1 VAL B  40      36.549  76.457  -7.104  1.00 63.01           C  
ATOM    985  CG2 VAL B  40      34.290  77.478  -7.427  1.00 64.21           C  
ATOM    986  N   LYS B  41      36.497  73.558  -8.827  1.00 56.35           N  
ATOM    987  CA  LYS B  41      36.983  72.185  -8.682  1.00 52.31           C  
ATOM    988  C   LYS B  41      38.296  72.180  -7.929  1.00 48.51           C  
ATOM    989  O   LYS B  41      39.040  73.153  -7.975  1.00 48.09           O  
ATOM    990  CB  LYS B  41      37.134  71.516 -10.045  1.00 53.02           C  
ATOM    991  CG  LYS B  41      35.822  71.014 -10.615  1.00 54.73           C  
ATOM    992  CD  LYS B  41      36.034  70.175 -11.869  1.00 56.73           C  
ATOM    993  CE  LYS B  41      34.720  69.842 -12.531  1.00 58.27           C  
ATOM    994  NZ  LYS B  41      34.917  68.956 -13.696  1.00 59.51           N  
ATOM    995  N   TYR B  42      38.563  71.110  -7.198  1.00 43.83           N  
ATOM    996  CA  TYR B  42      39.791  71.054  -6.411  1.00 40.31           C  
ATOM    997  C   TYR B  42      40.517  69.761  -6.676  1.00 38.09           C  
ATOM    998  O   TYR B  42      39.888  68.738  -6.906  1.00 37.68           O  
ATOM    999  CB  TYR B  42      39.528  71.205  -4.885  1.00 39.54           C  
ATOM   1000  CG  TYR B  42      38.851  72.507  -4.511  1.00 38.25           C  
ATOM   1001  CD1 TYR B  42      37.474  72.659  -4.638  1.00 38.52           C  
ATOM   1002  CD2 TYR B  42      39.578  73.581  -4.058  1.00 35.99           C  
ATOM   1003  CE1 TYR B  42      36.869  73.842  -4.330  1.00 37.25           C  
ATOM   1004  CE2 TYR B  42      38.983  74.750  -3.736  1.00 35.51           C  
ATOM   1005  CZ  TYR B  42      37.621  74.877  -3.865  1.00 34.65           C  
ATOM   1006  OH  TYR B  42      37.019  76.052  -3.537  1.00 31.58           O  
ATOM   1007  N   PHE B  43      41.842  69.824  -6.640  1.00 36.11           N  
ATOM   1008  CA  PHE B  43      42.675  68.642  -6.806  1.00 34.21           C  
ATOM   1009  C   PHE B  43      43.074  68.289  -5.400  1.00 32.63           C  
ATOM   1010  O   PHE B  43      43.726  69.080  -4.696  1.00 32.16           O  
ATOM   1011  CB  PHE B  43      43.913  68.939  -7.692  1.00 34.87           C  
ATOM   1012  CG  PHE B  43      44.664  67.694  -8.091  1.00 33.75           C  
ATOM   1013  CD1 PHE B  43      44.109  66.803  -8.980  1.00 33.66           C  
ATOM   1014  CD2 PHE B  43      45.890  67.396  -7.526  1.00 33.31           C  
ATOM   1015  CE1 PHE B  43      44.767  65.663  -9.329  1.00 33.78           C  
ATOM   1016  CE2 PHE B  43      46.537  66.247  -7.858  1.00 34.06           C  
ATOM   1017  CZ  PHE B  43      45.960  65.382  -8.766  1.00 34.65           C  
ATOM   1018  N   ILE B  44      42.664  67.103  -4.987  1.00 30.79           N  
ATOM   1019  CA  ILE B  44      42.786  66.669  -3.601  1.00 29.63           C  
ATOM   1020  C   ILE B  44      43.761  65.535  -3.426  1.00 29.09           C  
ATOM   1021  O   ILE B  44      43.739  64.545  -4.189  1.00 29.25           O  
ATOM   1022  CB  ILE B  44      41.408  66.105  -3.111  1.00 29.39           C  
ATOM   1023  CG1 ILE B  44      40.332  67.199  -3.017  1.00 29.69           C  
ATOM   1024  CG2 ILE B  44      41.563  65.374  -1.769  1.00 28.65           C  
ATOM   1025  CD1 ILE B  44      40.667  68.349  -1.976  1.00 30.94           C  
ATOM   1026  N   HIS B  45      44.597  65.671  -2.413  1.00 27.47           N  
ATOM   1027  CA  HIS B  45      45.408  64.561  -1.960  1.00 26.32           C  
ATOM   1028  C   HIS B  45      44.898  64.121  -0.586  1.00 25.55           C  
ATOM   1029  O   HIS B  45      44.785  64.945   0.346  1.00 24.96           O  
ATOM   1030  CB  HIS B  45      46.884  64.943  -1.852  1.00 26.72           C  
ATOM   1031  CG  HIS B  45      47.698  63.894  -1.166  1.00 28.13           C  
ATOM   1032  ND1 HIS B  45      48.162  64.045   0.124  1.00 28.46           N  
ATOM   1033  CD2 HIS B  45      48.027  62.634  -1.542  1.00 28.75           C  
ATOM   1034  CE1 HIS B  45      48.776  62.935   0.497  1.00 29.42           C  
ATOM   1035  NE2 HIS B  45      48.718  62.067  -0.497  1.00 28.79           N  
ATOM   1036  N   TYR B  46      44.545  62.852  -0.474  1.00 23.98           N  
ATOM   1037  CA  TYR B  46      44.092  62.268   0.769  1.00 23.83           C  
ATOM   1038  C   TYR B  46      45.294  61.892   1.592  1.00 24.80           C  
ATOM   1039  O   TYR B  46      46.238  61.178   1.102  1.00 23.62           O  
ATOM   1040  CB  TYR B  46      43.266  61.038   0.518  1.00 24.04           C  
ATOM   1041  CG  TYR B  46      42.022  61.325  -0.286  1.00 24.72           C  
ATOM   1042  CD1 TYR B  46      42.022  61.222  -1.656  1.00 24.52           C  
ATOM   1043  CD2 TYR B  46      40.854  61.750   0.331  1.00 26.29           C  
ATOM   1044  CE1 TYR B  46      40.872  61.473  -2.413  1.00 27.15           C  
ATOM   1045  CE2 TYR B  46      39.682  62.001  -0.412  1.00 26.58           C  
ATOM   1046  CZ  TYR B  46      39.715  61.871  -1.788  1.00 28.39           C  
ATOM   1047  OH  TYR B  46      38.586  62.151  -2.558  1.00 30.83           O  
ATOM   1048  N   SER B  47      45.262  62.388   2.833  1.00 23.43           N  
ATOM   1049  CA  SER B  47      46.327  62.221   3.766  1.00 24.10           C  
ATOM   1050  C   SER B  47      46.526  60.766   4.067  1.00 24.31           C  
ATOM   1051  O   SER B  47      45.605  60.129   4.503  1.00 22.37           O  
ATOM   1052  CB  SER B  47      46.014  62.947   5.077  1.00 23.51           C  
ATOM   1053  OG  SER B  47      45.775  64.279   4.788  1.00 25.42           O  
ATOM   1054  N   GLY B  48      47.760  60.281   3.889  1.00 25.56           N  
ATOM   1055  CA  GLY B  48      48.090  58.898   4.197  1.00 27.37           C  
ATOM   1056  C   GLY B  48      47.835  58.024   2.996  1.00 29.50           C  
ATOM   1057  O   GLY B  48      48.080  56.820   3.032  1.00 30.89           O  
ATOM   1058  N   TRP B  49      47.331  58.595   1.916  1.00 30.07           N  
ATOM   1059  CA  TRP B  49      47.028  57.745   0.773  1.00 31.06           C  
ATOM   1060  C   TRP B  49      48.061  57.944  -0.293  1.00 31.30           C  
ATOM   1061  O   TRP B  49      48.587  59.047  -0.494  1.00 28.67           O  
ATOM   1062  CB  TRP B  49      45.673  58.032   0.100  1.00 31.03           C  
ATOM   1063  CG  TRP B  49      44.413  57.797   0.905  1.00 35.18           C  
ATOM   1064  CD1 TRP B  49      44.298  57.746   2.263  1.00 36.62           C  
ATOM   1065  CD2 TRP B  49      43.081  57.633   0.383  1.00 37.09           C  
ATOM   1066  NE1 TRP B  49      42.997  57.503   2.620  1.00 38.53           N  
ATOM   1067  CE2 TRP B  49      42.220  57.465   1.486  1.00 39.17           C  
ATOM   1068  CE3 TRP B  49      42.527  57.620  -0.908  1.00 37.47           C  
ATOM   1069  CZ2 TRP B  49      40.833  57.291   1.334  1.00 39.16           C  
ATOM   1070  CZ3 TRP B  49      41.162  57.442  -1.058  1.00 38.04           C  
ATOM   1071  CH2 TRP B  49      40.329  57.288   0.056  1.00 39.06           C  
ATOM   1072  N   ASN B  50      48.259  56.889  -1.067  1.00 32.68           N  
ATOM   1073  CA  ASN B  50      49.141  57.041  -2.195  1.00 35.01           C  
ATOM   1074  C   ASN B  50      48.632  58.083  -3.207  1.00 34.68           C  
ATOM   1075  O   ASN B  50      47.416  58.321  -3.357  1.00 33.13           O  
ATOM   1076  CB  ASN B  50      49.377  55.681  -2.852  1.00 36.93           C  
ATOM   1077  CG  ASN B  50      50.276  55.791  -4.002  1.00 40.82           C  
ATOM   1078  OD1 ASN B  50      51.422  56.222  -3.867  1.00 46.91           O  
ATOM   1079  ND2 ASN B  50      49.757  55.522  -5.155  1.00 43.40           N  
ATOM   1080  N   LYS B  51      49.575  58.720  -3.881  1.00 35.47           N  
ATOM   1081  CA  LYS B  51      49.263  59.722  -4.889  1.00 37.16           C  
ATOM   1082  C   LYS B  51      48.432  59.303  -6.101  1.00 36.55           C  
ATOM   1083  O   LYS B  51      47.837  60.162  -6.774  1.00 36.43           O  
ATOM   1084  CB  LYS B  51      50.537  60.409  -5.366  1.00 38.14           C  
ATOM   1085  CG  LYS B  51      50.844  61.604  -4.490  1.00 43.27           C  
ATOM   1086  CD  LYS B  51      51.757  62.610  -5.177  1.00 49.68           C  
ATOM   1087  CE  LYS B  51      52.288  63.616  -4.168  1.00 52.86           C  
ATOM   1088  NZ  LYS B  51      53.116  64.633  -4.885  1.00 56.14           N  
ATOM   1089  N   ASN B  52      48.403  58.014  -6.404  1.00 36.28           N  
ATOM   1090  CA  ASN B  52      47.543  57.527  -7.491  1.00 36.72           C  
ATOM   1091  C   ASN B  52      46.083  57.790  -7.130  1.00 36.75           C  
ATOM   1092  O   ASN B  52      45.187  57.723  -7.976  1.00 36.40           O  
ATOM   1093  CB  ASN B  52      47.770  56.024  -7.728  1.00 36.04           C  
ATOM   1094  CG  ASN B  52      49.205  55.717  -8.215  1.00 35.99           C  
ATOM   1095  OD1 ASN B  52      49.954  56.608  -8.695  1.00 31.98           O  
ATOM   1096  ND2 ASN B  52      49.597  54.449  -8.073  1.00 36.42           N  
ATOM   1097  N   TRP B  53      45.852  58.078  -5.852  1.00 36.65           N  
ATOM   1098  CA  TRP B  53      44.490  58.412  -5.422  1.00 37.27           C  
ATOM   1099  C   TRP B  53      44.088  59.870  -5.583  1.00 36.39           C  
ATOM   1100  O   TRP B  53      42.899  60.160  -5.533  1.00 36.75           O  
ATOM   1101  CB  TRP B  53      44.252  57.989  -3.992  1.00 37.93           C  
ATOM   1102  CG  TRP B  53      44.429  56.579  -3.798  1.00 41.85           C  
ATOM   1103  CD1 TRP B  53      45.558  55.962  -3.374  1.00 44.25           C  
ATOM   1104  CD2 TRP B  53      43.453  55.554  -3.992  1.00 45.67           C  
ATOM   1105  NE1 TRP B  53      45.351  54.609  -3.292  1.00 46.84           N  
ATOM   1106  CE2 TRP B  53      44.067  54.329  -3.670  1.00 47.00           C  
ATOM   1107  CE3 TRP B  53      42.116  55.544  -4.413  1.00 48.48           C  
ATOM   1108  CZ2 TRP B  53      43.407  53.103  -3.742  1.00 50.62           C  
ATOM   1109  CZ3 TRP B  53      41.441  54.301  -4.493  1.00 51.78           C  
ATOM   1110  CH2 TRP B  53      42.099  53.103  -4.156  1.00 52.18           C  
ATOM   1111  N   ASP B  54      45.056  60.782  -5.751  1.00 35.46           N  
ATOM   1112  CA  ASP B  54      44.754  62.207  -5.896  1.00 35.13           C  
ATOM   1113  C   ASP B  54      43.718  62.393  -6.992  1.00 35.95           C  
ATOM   1114  O   ASP B  54      43.747  61.690  -8.002  1.00 37.52           O  
ATOM   1115  CB  ASP B  54      45.982  63.032  -6.298  1.00 34.14           C  
ATOM   1116  CG  ASP B  54      47.133  62.920  -5.336  1.00 32.78           C  
ATOM   1117  OD1 ASP B  54      47.034  62.309  -4.248  1.00 33.32           O  
ATOM   1118  OD2 ASP B  54      48.214  63.435  -5.620  1.00 30.50           O  
ATOM   1119  N   GLU B  55      42.827  63.358  -6.852  1.00 36.07           N  
ATOM   1120  CA  GLU B  55      41.772  63.528  -7.877  1.00 36.33           C  
ATOM   1121  C   GLU B  55      41.131  64.896  -7.837  1.00 36.54           C  
ATOM   1122  O   GLU B  55      41.191  65.627  -6.834  1.00 36.23           O  
ATOM   1123  CB  GLU B  55      40.667  62.502  -7.732  1.00 35.64           C  
ATOM   1124  CG  GLU B  55      40.052  62.505  -6.336  1.00 35.75           C  
ATOM   1125  CD  GLU B  55      38.879  61.552  -6.156  1.00 35.87           C  
ATOM   1126  OE1 GLU B  55      38.400  61.369  -5.016  1.00 35.00           O  
ATOM   1127  OE2 GLU B  55      38.425  60.961  -7.152  1.00 38.10           O  
ATOM   1128  N   TRP B  56      40.505  65.225  -8.946  1.00 36.41           N  
ATOM   1129  CA  TRP B  56      39.793  66.469  -9.063  1.00 36.94           C  
ATOM   1130  C   TRP B  56      38.436  66.237  -8.496  1.00 36.52           C  
ATOM   1131  O   TRP B  56      37.808  65.232  -8.795  1.00 36.52           O  
ATOM   1132  CB  TRP B  56      39.713  66.917 -10.515  1.00 36.75           C  
ATOM   1133  CG  TRP B  56      40.953  67.558 -10.921  1.00 39.03           C  
ATOM   1134  CD1 TRP B  56      41.996  66.988 -11.611  1.00 41.24           C  
ATOM   1135  CD2 TRP B  56      41.328  68.909 -10.675  1.00 39.95           C  
ATOM   1136  NE1 TRP B  56      42.981  67.924 -11.821  1.00 41.44           N  
ATOM   1137  CE2 TRP B  56      42.590  69.110 -11.261  1.00 40.97           C  
ATOM   1138  CE3 TRP B  56      40.711  69.982 -10.033  1.00 41.00           C  
ATOM   1139  CZ2 TRP B  56      43.253  70.321 -11.201  1.00 43.49           C  
ATOM   1140  CZ3 TRP B  56      41.363  71.196  -9.975  1.00 42.43           C  
ATOM   1141  CH2 TRP B  56      42.616  71.360 -10.560  1.00 44.41           C  
ATOM   1142  N   VAL B  57      37.995  67.172  -7.669  1.00 36.58           N  
ATOM   1143  CA  VAL B  57      36.715  67.040  -6.965  1.00 36.57           C  
ATOM   1144  C   VAL B  57      35.981  68.370  -7.003  1.00 36.59           C  
ATOM   1145  O   VAL B  57      36.600  69.425  -6.851  1.00 36.14           O  
ATOM   1146  CB  VAL B  57      37.000  66.633  -5.484  1.00 36.28           C  
ATOM   1147  CG1 VAL B  57      35.788  66.558  -4.700  1.00 38.25           C  
ATOM   1148  CG2 VAL B  57      37.675  65.275  -5.442  1.00 35.24           C  
ATOM   1149  N   PRO B  58      34.659  68.334  -7.146  1.00 37.09           N  
ATOM   1150  CA  PRO B  58      33.872  69.565  -7.129  1.00 37.71           C  
ATOM   1151  C   PRO B  58      33.704  70.005  -5.668  1.00 37.42           C  
ATOM   1152  O   PRO B  58      33.820  69.185  -4.744  1.00 37.19           O  
ATOM   1153  CB  PRO B  58      32.537  69.110  -7.717  1.00 37.66           C  
ATOM   1154  CG  PRO B  58      32.383  67.763  -7.094  1.00 38.28           C  
ATOM   1155  CD  PRO B  58      33.790  67.148  -7.227  1.00 37.24           C  
ATOM   1156  N   GLU B  59      33.502  71.296  -5.485  1.00 37.01           N  
ATOM   1157  CA  GLU B  59      33.309  71.925  -4.194  1.00 37.71           C  
ATOM   1158  C   GLU B  59      32.437  71.153  -3.215  1.00 36.72           C  
ATOM   1159  O   GLU B  59      32.787  71.017  -2.056  1.00 37.20           O  
ATOM   1160  CB  GLU B  59      32.617  73.240  -4.416  1.00 38.63           C  
ATOM   1161  CG  GLU B  59      33.549  74.367  -4.724  1.00 43.19           C  
ATOM   1162  CD  GLU B  59      33.575  75.337  -3.581  1.00 46.73           C  
ATOM   1163  OE1 GLU B  59      33.261  76.515  -3.788  1.00 45.89           O  
ATOM   1164  OE2 GLU B  59      33.872  74.868  -2.469  1.00 50.08           O  
ATOM   1165  N   SER B  60      31.289  70.703  -3.693  1.00 35.45           N  
ATOM   1166  CA  SER B  60      30.329  69.961  -2.898  1.00 35.27           C  
ATOM   1167  C   SER B  60      30.972  68.857  -2.041  1.00 33.68           C  
ATOM   1168  O   SER B  60      30.566  68.635  -0.966  1.00 33.52           O  
ATOM   1169  CB  SER B  60      29.213  69.418  -3.803  1.00 35.49           C  
ATOM   1170  OG  SER B  60      29.211  68.000  -3.889  1.00 38.24           O  
ATOM   1171  N   ARG B  61      31.998  68.170  -2.514  1.00 33.00           N  
ATOM   1172  CA  ARG B  61      32.596  67.095  -1.705  1.00 30.66           C  
ATOM   1173  C   ARG B  61      33.611  67.577  -0.684  1.00 27.79           C  
ATOM   1174  O   ARG B  61      34.119  66.810   0.107  1.00 26.14           O  
ATOM   1175  CB  ARG B  61      33.246  66.089  -2.632  1.00 31.84           C  
ATOM   1176  CG  ARG B  61      32.219  65.255  -3.328  1.00 34.53           C  
ATOM   1177  CD  ARG B  61      32.756  64.317  -4.353  1.00 35.63           C  
ATOM   1178  NE  ARG B  61      33.850  63.503  -3.835  1.00 37.79           N  
ATOM   1179  CZ  ARG B  61      34.799  62.961  -4.630  1.00 36.32           C  
ATOM   1180  NH1 ARG B  61      34.744  63.179  -5.953  1.00 34.51           N  
ATOM   1181  NH2 ARG B  61      35.775  62.213  -4.103  1.00 30.74           N  
ATOM   1182  N   VAL B  62      33.899  68.868  -0.679  1.00 26.48           N  
ATOM   1183  CA  VAL B  62      34.959  69.347   0.208  1.00 25.96           C  
ATOM   1184  C   VAL B  62      34.426  70.054   1.420  1.00 25.58           C  
ATOM   1185  O   VAL B  62      33.564  70.886   1.292  1.00 25.14           O  
ATOM   1186  CB  VAL B  62      35.960  70.216  -0.539  1.00 25.97           C  
ATOM   1187  CG1 VAL B  62      37.160  70.591   0.372  1.00 24.71           C  
ATOM   1188  CG2 VAL B  62      36.436  69.424  -1.760  1.00 26.58           C  
ATOM   1189  N   LEU B  63      34.952  69.722   2.595  1.00 25.21           N  
ATOM   1190  CA  LEU B  63      34.490  70.355   3.833  1.00 25.75           C  
ATOM   1191  C   LEU B  63      35.614  71.005   4.644  1.00 25.90           C  
ATOM   1192  O   LEU B  63      36.731  70.486   4.721  1.00 26.14           O  
ATOM   1193  CB  LEU B  63      33.732  69.330   4.685  1.00 25.02           C  
ATOM   1194  CG  LEU B  63      32.313  68.927   4.227  1.00 27.11           C  
ATOM   1195  CD1 LEU B  63      31.819  67.826   5.128  1.00 28.09           C  
ATOM   1196  CD2 LEU B  63      31.305  70.149   4.354  1.00 27.69           C  
ATOM   1197  N   LYS B  64      35.315  72.130   5.262  1.00 25.87           N  
ATOM   1198  CA  LYS B  64      36.262  72.832   6.102  1.00 26.92           C  
ATOM   1199  C   LYS B  64      36.702  71.971   7.319  1.00 27.11           C  
ATOM   1200  O   LYS B  64      35.905  71.217   7.936  1.00 26.09           O  
ATOM   1201  CB  LYS B  64      35.635  74.164   6.549  1.00 26.96           C  
ATOM   1202  CG  LYS B  64      36.474  75.432   6.285  1.00 30.58           C  
ATOM   1203  CD  LYS B  64      36.596  75.866   4.888  1.00 32.37           C  
ATOM   1204  CE  LYS B  64      37.502  77.067   4.832  1.00 32.40           C  
ATOM   1205  NZ  LYS B  64      38.141  77.425   3.559  1.00 27.99           N  
ATOM   1206  N   TYR B  65      37.962  72.106   7.687  1.00 26.28           N  
ATOM   1207  CA  TYR B  65      38.482  71.299   8.763  1.00 27.28           C  
ATOM   1208  C   TYR B  65      38.163  71.958  10.117  1.00 27.15           C  
ATOM   1209  O   TYR B  65      38.975  72.654  10.635  1.00 26.52           O  
ATOM   1210  CB  TYR B  65      39.981  71.102   8.591  1.00 27.70           C  
ATOM   1211  CG  TYR B  65      40.539  69.956   9.415  1.00 29.34           C  
ATOM   1212  CD1 TYR B  65      40.552  68.671   8.928  1.00 28.45           C  
ATOM   1213  CD2 TYR B  65      41.052  70.176  10.699  1.00 30.86           C  
ATOM   1214  CE1 TYR B  65      41.081  67.604   9.709  1.00 29.56           C  
ATOM   1215  CE2 TYR B  65      41.553  69.123  11.466  1.00 30.92           C  
ATOM   1216  CZ  TYR B  65      41.566  67.846  10.951  1.00 30.94           C  
ATOM   1217  OH  TYR B  65      42.056  66.793  11.726  1.00 33.70           O  
ATOM   1218  N   VAL B  66      36.951  71.772  10.627  1.00 27.07           N  
ATOM   1219  CA  VAL B  66      36.535  72.438  11.861  1.00 26.83           C  
ATOM   1220  C   VAL B  66      35.726  71.470  12.698  1.00 27.97           C  
ATOM   1221  O   VAL B  66      35.219  70.470  12.181  1.00 27.74           O  
ATOM   1222  CB  VAL B  66      35.663  73.698  11.553  1.00 27.05           C  
ATOM   1223  CG1 VAL B  66      36.494  74.837  10.962  1.00 23.57           C  
ATOM   1224  CG2 VAL B  66      34.508  73.367  10.638  1.00 25.42           C  
ATOM   1225  N   ASP B  67      35.598  71.753  13.995  1.00 29.40           N  
ATOM   1226  CA  ASP B  67      34.894  70.841  14.894  1.00 30.16           C  
ATOM   1227  C   ASP B  67      33.612  70.272  14.376  1.00 29.60           C  
ATOM   1228  O   ASP B  67      33.394  69.092  14.439  1.00 30.93           O  
ATOM   1229  CB  ASP B  67      34.716  71.468  16.280  1.00 30.77           C  
ATOM   1230  CG  ASP B  67      36.036  71.676  16.966  1.00 35.05           C  
ATOM   1231  OD1 ASP B  67      36.974  70.941  16.604  1.00 38.91           O  
ATOM   1232  OD2 ASP B  67      36.264  72.551  17.846  1.00 38.57           O  
ATOM   1233  N   THR B  68      32.741  71.094  13.861  1.00 29.63           N  
ATOM   1234  CA  THR B  68      31.488  70.592  13.356  1.00 30.79           C  
ATOM   1235  C   THR B  68      31.650  69.477  12.334  1.00 28.47           C  
ATOM   1236  O   THR B  68      30.882  68.506  12.325  1.00 28.23           O  
ATOM   1237  CB  THR B  68      30.682  71.765  12.726  1.00 31.94           C  
ATOM   1238  OG1 THR B  68      30.090  72.485  13.793  1.00 38.38           O  
ATOM   1239  CG2 THR B  68      29.436  71.263  12.053  1.00 34.14           C  
ATOM   1240  N   ASN B  69      32.573  69.657  11.404  1.00 26.56           N  
ATOM   1241  CA  ASN B  69      32.719  68.651  10.357  1.00 24.95           C  
ATOM   1242  C   ASN B  69      33.511  67.475  10.862  1.00 23.84           C  
ATOM   1243  O   ASN B  69      33.265  66.373  10.414  1.00 22.07           O  
ATOM   1244  CB  ASN B  69      33.307  69.238   9.075  1.00 25.37           C  
ATOM   1245  CG  ASN B  69      32.359  70.258   8.437  1.00 25.76           C  
ATOM   1246  OD1 ASN B  69      31.120  70.133   8.511  1.00 24.39           O  
ATOM   1247  ND2 ASN B  69      32.928  71.250   7.816  1.00 24.70           N  
ATOM   1248  N   LEU B  70      34.422  67.681  11.816  1.00 24.03           N  
ATOM   1249  CA  LEU B  70      35.125  66.517  12.399  1.00 26.09           C  
ATOM   1250  C   LEU B  70      34.103  65.623  13.123  1.00 27.66           C  
ATOM   1251  O   LEU B  70      34.153  64.405  12.996  1.00 27.74           O  
ATOM   1252  CB  LEU B  70      36.207  66.939  13.373  1.00 26.02           C  
ATOM   1253  CG  LEU B  70      37.497  67.406  12.682  1.00 27.15           C  
ATOM   1254  CD1 LEU B  70      38.543  68.021  13.658  1.00 24.63           C  
ATOM   1255  CD2 LEU B  70      38.099  66.238  11.781  1.00 27.27           C  
ATOM   1256  N   GLN B  71      33.155  66.238  13.838  1.00 28.67           N  
ATOM   1257  CA  GLN B  71      32.109  65.468  14.504  1.00 30.55           C  
ATOM   1258  C   GLN B  71      31.268  64.714  13.450  1.00 30.62           C  
ATOM   1259  O   GLN B  71      30.892  63.565  13.631  1.00 30.84           O  
ATOM   1260  CB  GLN B  71      31.208  66.393  15.333  1.00 31.61           C  
ATOM   1261  CG  GLN B  71      30.020  65.668  16.009  1.00 35.16           C  
ATOM   1262  CD  GLN B  71      30.512  64.655  17.067  1.00 40.75           C  
ATOM   1263  OE1 GLN B  71      31.543  64.879  17.716  1.00 41.48           O  
ATOM   1264  NE2 GLN B  71      29.773  63.548  17.234  1.00 43.45           N  
ATOM   1265  N   LYS B  72      30.993  65.352  12.325  1.00 30.21           N  
ATOM   1266  CA  LYS B  72      30.222  64.665  11.309  1.00 29.85           C  
ATOM   1267  C   LYS B  72      31.069  63.484  10.857  1.00 28.37           C  
ATOM   1268  O   LYS B  72      30.554  62.380  10.669  1.00 26.63           O  
ATOM   1269  CB  LYS B  72      29.891  65.586  10.101  1.00 30.87           C  
ATOM   1270  CG  LYS B  72      29.280  64.842   8.840  1.00 33.81           C  
ATOM   1271  CD  LYS B  72      29.181  65.774   7.569  1.00 38.08           C  
ATOM   1272  CE  LYS B  72      28.065  66.829   7.677  1.00 39.48           C  
ATOM   1273  NZ  LYS B  72      26.783  66.156   7.634  1.00 40.91           N  
ATOM   1274  N   GLN B  73      32.367  63.723  10.674  1.00 27.37           N  
ATOM   1275  CA  GLN B  73      33.264  62.633  10.251  1.00 27.88           C  
ATOM   1276  C   GLN B  73      33.197  61.415  11.210  1.00 27.66           C  
ATOM   1277  O   GLN B  73      33.101  60.270  10.789  1.00 26.59           O  
ATOM   1278  CB  GLN B  73      34.725  63.093  10.110  1.00 27.24           C  
ATOM   1279  CG  GLN B  73      35.700  61.918   9.871  1.00 27.44           C  
ATOM   1280  CD  GLN B  73      37.180  62.338   9.732  1.00 28.83           C  
ATOM   1281  OE1 GLN B  73      37.697  63.084  10.565  1.00 31.20           O  
ATOM   1282  NE2 GLN B  73      37.850  61.836   8.697  1.00 27.22           N  
ATOM   1283  N   ARG B  74      33.263  61.716  12.487  1.00 29.15           N  
ATOM   1284  CA  ARG B  74      33.220  60.747  13.594  1.00 32.37           C  
ATOM   1285  C   ARG B  74      31.896  59.937  13.490  1.00 32.51           C  
ATOM   1286  O   ARG B  74      31.889  58.696  13.558  1.00 33.01           O  
ATOM   1287  CB  ARG B  74      33.213  61.578  14.878  1.00 33.32           C  
ATOM   1288  CG  ARG B  74      33.936  61.035  16.079  1.00 39.67           C  
ATOM   1289  CD  ARG B  74      34.695  62.133  16.941  1.00 42.47           C  
ATOM   1290  NE  ARG B  74      35.992  62.473  16.352  1.00 46.93           N  
ATOM   1291  CZ  ARG B  74      36.490  63.725  16.285  1.00 48.59           C  
ATOM   1292  NH1 ARG B  74      35.787  64.743  16.783  1.00 49.10           N  
ATOM   1293  NH2 ARG B  74      37.677  63.956  15.722  1.00 47.47           N  
ATOM   1294  N   GLU B  75      30.800  60.674  13.281  1.00 31.30           N  
ATOM   1295  CA  GLU B  75      29.467  60.110  13.195  1.00 30.99           C  
ATOM   1296  C   GLU B  75      29.329  59.206  11.990  1.00 30.66           C  
ATOM   1297  O   GLU B  75      28.680  58.167  12.082  1.00 29.63           O  
ATOM   1298  CB  GLU B  75      28.360  61.217  13.231  1.00 31.41           C  
ATOM   1299  CG  GLU B  75      28.123  61.864  14.610  1.00 31.72           C  
ATOM   1300  CD  GLU B  75      27.092  63.024  14.611  1.00 34.66           C  
ATOM   1301  OE1 GLU B  75      26.450  63.307  13.597  1.00 33.67           O  
ATOM   1302  OE2 GLU B  75      26.924  63.697  15.655  1.00 37.18           O  
ATOM   1303  N   LEU B  76      29.973  59.556  10.874  1.00 30.51           N  
ATOM   1304  CA  LEU B  76      29.881  58.703   9.690  1.00 31.71           C  
ATOM   1305  C   LEU B  76      30.705  57.434   9.875  1.00 32.75           C  
ATOM   1306  O   LEU B  76      30.350  56.388   9.358  1.00 32.44           O  
ATOM   1307  CB  LEU B  76      30.322  59.394   8.401  1.00 31.07           C  
ATOM   1308  CG  LEU B  76      29.510  60.554   7.846  1.00 31.65           C  
ATOM   1309  CD1 LEU B  76      30.183  61.048   6.600  1.00 31.54           C  
ATOM   1310  CD2 LEU B  76      28.125  60.050   7.524  1.00 32.05           C  
ATOM   1311  N   GLN B  77      31.826  57.536  10.583  1.00 34.03           N  
ATOM   1312  CA  GLN B  77      32.630  56.347  10.842  1.00 36.00           C  
ATOM   1313  C   GLN B  77      31.907  55.372  11.771  1.00 37.02           C  
ATOM   1314  O   GLN B  77      32.001  54.174  11.600  1.00 36.85           O  
ATOM   1315  CB  GLN B  77      33.977  56.735  11.419  1.00 35.88           C  
ATOM   1316  CG  GLN B  77      34.829  57.465  10.386  1.00 38.51           C  
ATOM   1317  CD  GLN B  77      36.042  58.151  10.998  1.00 39.41           C  
ATOM   1318  OE1 GLN B  77      36.071  58.444  12.197  1.00 39.97           O  
ATOM   1319  NE2 GLN B  77      37.043  58.395  10.176  1.00 40.35           N  
ATOM   1320  N   LYS B  78      31.227  55.906  12.769  1.00 38.92           N  
ATOM   1321  CA  LYS B  78      30.434  55.118  13.687  1.00 41.56           C  
ATOM   1322  C   LYS B  78      29.315  54.423  12.920  1.00 42.54           C  
ATOM   1323  O   LYS B  78      29.091  53.230  13.088  1.00 42.05           O  
ATOM   1324  CB  LYS B  78      29.813  56.069  14.714  1.00 42.57           C  
ATOM   1325  CG  LYS B  78      29.073  55.430  15.888  1.00 45.65           C  
ATOM   1326  CD  LYS B  78      28.679  56.586  16.837  1.00 51.06           C  
ATOM   1327  CE  LYS B  78      28.007  56.157  18.153  1.00 53.63           C  
ATOM   1328  NZ  LYS B  78      27.500  57.359  18.948  1.00 53.87           N  
ATOM   1329  N   ALA B  79      28.593  55.179  12.082  1.00 43.66           N  
ATOM   1330  CA  ALA B  79      27.502  54.592  11.301  1.00 44.95           C  
ATOM   1331  C   ALA B  79      28.035  53.448  10.456  1.00 46.22           C  
ATOM   1332  O   ALA B  79      27.390  52.414  10.279  1.00 44.96           O  
ATOM   1333  CB  ALA B  79      26.832  55.633  10.407  1.00 44.12           C  
ATOM   1334  N   ASN B  80      29.218  53.653   9.905  1.00 48.51           N  
ATOM   1335  CA  ASN B  80      29.816  52.616   9.091  1.00 51.03           C  
ATOM   1336  C   ASN B  80      30.269  51.422   9.920  1.00 51.74           C  
ATOM   1337  O   ASN B  80      30.276  50.312   9.434  1.00 51.02           O  
ATOM   1338  CB  ASN B  80      30.966  53.163   8.273  1.00 51.85           C  
ATOM   1339  CG  ASN B  80      30.613  53.294   6.805  1.00 55.25           C  
ATOM   1340  OD1 ASN B  80      29.708  54.067   6.426  1.00 57.22           O  
ATOM   1341  ND2 ASN B  80      31.301  52.509   5.963  1.00 56.82           N  
ATOM   1342  N   GLN B  81      30.650  51.662  11.165  1.00 53.55           N  
ATOM   1343  CA  GLN B  81      31.059  50.574  12.045  1.00 56.21           C  
ATOM   1344  C   GLN B  81      29.816  49.789  12.447  1.00 57.28           C  
ATOM   1345  O   GLN B  81      29.878  48.581  12.614  1.00 57.24           O  
ATOM   1346  CB  GLN B  81      31.808  51.080  13.287  1.00 56.13           C  
ATOM   1347  CG  GLN B  81      33.348  51.036  13.143  1.00 58.18           C  
ATOM   1348  CD  GLN B  81      33.994  52.381  12.733  1.00 59.81           C  
ATOM   1349  OE1 GLN B  81      34.141  53.290  13.568  1.00 59.22           O  
ATOM   1350  NE2 GLN B  81      34.406  52.491  11.459  1.00 60.46           N  
ATOM   1351  N   GLU B  82      28.696  50.491  12.573  1.00 58.87           N  
ATOM   1352  CA  GLU B  82      27.438  49.874  12.923  1.00 61.23           C  
ATOM   1353  C   GLU B  82      26.880  49.089  11.763  1.00 63.06           C  
ATOM   1354  O   GLU B  82      26.058  48.201  11.957  1.00 62.91           O  
ATOM   1355  CB  GLU B  82      26.422  50.907  13.371  1.00 60.98           C  
ATOM   1356  CG  GLU B  82      26.592  51.331  14.813  1.00 61.84           C  
ATOM   1357  CD  GLU B  82      25.830  52.606  15.128  1.00 62.46           C  
ATOM   1358  OE1 GLU B  82      25.668  52.926  16.326  1.00 62.90           O  
ATOM   1359  OE2 GLU B  82      25.400  53.292  14.173  1.00 61.57           O  
ATOM   1360  N   GLN B  83      27.319  49.411  10.556  1.00 65.39           N  
ATOM   1361  CA  GLN B  83      26.854  48.665   9.409  1.00 68.32           C  
ATOM   1362  C   GLN B  83      27.689  47.418   9.254  1.00 70.26           C  
ATOM   1363  O   GLN B  83      27.172  46.377   8.872  1.00 70.22           O  
ATOM   1364  CB  GLN B  83      26.898  49.507   8.141  1.00 68.58           C  
ATOM   1365  CG  GLN B  83      25.788  50.537   8.080  1.00 70.10           C  
ATOM   1366  CD  GLN B  83      25.757  51.294   6.769  1.00 72.10           C  
ATOM   1367  OE1 GLN B  83      26.715  52.000   6.426  1.00 72.49           O  
ATOM   1368  NE2 GLN B  83      24.656  51.155   6.032  1.00 72.76           N  
ATOM   1369  N   TYR B  84      28.982  47.529   9.559  1.00 72.79           N  
ATOM   1370  CA  TYR B  84      29.898  46.397   9.492  1.00 75.51           C  
ATOM   1371  C   TYR B  84      29.602  45.419  10.630  1.00 77.21           C  
ATOM   1372  O   TYR B  84      29.903  44.233  10.531  1.00 77.06           O  
ATOM   1373  CB  TYR B  84      31.349  46.875   9.560  1.00 75.78           C  
ATOM   1374  CG  TYR B  84      32.386  45.768   9.496  1.00 77.27           C  
ATOM   1375  CD1 TYR B  84      32.731  45.172   8.284  1.00 78.12           C  
ATOM   1376  CD2 TYR B  84      33.031  45.323  10.650  1.00 78.36           C  
ATOM   1377  CE1 TYR B  84      33.678  44.158   8.224  1.00 78.66           C  
ATOM   1378  CE2 TYR B  84      33.985  44.307  10.594  1.00 78.87           C  
ATOM   1379  CZ  TYR B  84      34.300  43.733   9.382  1.00 79.02           C  
ATOM   1380  OH  TYR B  84      35.237  42.728   9.329  1.00 79.85           O  
ATOM   1381  N   ALA B  85      29.000  45.933  11.702  1.00 79.48           N  
ATOM   1382  CA  ALA B  85      28.652  45.131  12.863  1.00 81.77           C  
ATOM   1383  C   ALA B  85      27.422  44.307  12.552  1.00 83.58           C  
ATOM   1384  O   ALA B  85      27.199  43.260  13.142  1.00 83.96           O  
ATOM   1385  CB  ALA B  85      28.398  46.022  14.070  1.00 81.67           C  
ATOM   1386  N   GLU B  86      26.624  44.774  11.607  1.00 85.74           N  
ATOM   1387  CA  GLU B  86      25.402  44.072  11.265  1.00 88.05           C  
ATOM   1388  C   GLU B  86      25.584  43.183  10.045  1.00 89.07           C  
ATOM   1389  O   GLU B  86      24.644  42.525   9.596  1.00 89.29           O  
ATOM   1390  CB  GLU B  86      24.243  45.059  11.098  1.00 88.56           C  
ATOM   1391  CG  GLU B  86      23.944  45.796  12.396  1.00 90.48           C  
ATOM   1392  CD  GLU B  86      22.958  46.942  12.247  1.00 92.89           C  
ATOM   1393  OE1 GLU B  86      22.374  47.103  11.148  1.00 94.11           O  
ATOM   1394  OE2 GLU B  86      22.766  47.681  13.242  1.00 93.69           O  
ATOM   1395  N   GLY B  87      26.802  43.163   9.520  1.00 90.09           N  
ATOM   1396  CA  GLY B  87      27.122  42.304   8.405  1.00 91.42           C  
ATOM   1397  C   GLY B  87      27.643  41.014   8.990  1.00 92.50           C  
ATOM   1398  O   GLY B  87      27.454  39.938   8.421  1.00 92.53           O  
ATOM   1399  N   LYS B  88      28.286  41.143  10.149  1.00 93.50           N  
ATOM   1400  CA  LYS B  88      28.872  40.014  10.861  1.00 94.57           C  
ATOM   1401  C   LYS B  88      27.802  39.240  11.621  1.00 95.56           C  
ATOM   1402  O   LYS B  88      28.068  38.170  12.163  1.00 95.76           O  
ATOM   1403  CB  LYS B  88      29.965  40.491  11.821  1.00 94.46           C  
ATOM   1404  CG  LYS B  88      31.204  41.019  11.124  1.00 94.25           C  
ATOM   1405  CD  LYS B  88      32.186  41.677  12.087  1.00 93.94           C  
ATOM   1406  CE  LYS B  88      33.098  40.673  12.789  1.00 93.83           C  
ATOM   1407  NZ  LYS B  88      32.695  40.458  14.200  1.00 93.60           N  
ATOM   1408  N   MET B  89      26.591  39.783  11.662  1.00 96.61           N  
ATOM   1409  CA  MET B  89      25.495  39.112  12.346  1.00 97.73           C  
ATOM   1410  C   MET B  89      24.614  38.314  11.377  1.00 98.84           C  
ATOM   1411  O   MET B  89      23.555  37.822  11.762  1.00 98.83           O  
ATOM   1412  CB  MET B  89      24.654  40.110  13.147  1.00 97.48           C  
ATOM   1413  CG  MET B  89      25.175  40.400  14.552  1.00 96.92           C  
ATOM   1414  SD  MET B  89      23.900  41.097  15.642  1.00 96.00           S  
ATOM   1415  CE  MET B  89      24.088  42.847  15.380  1.00 96.20           C  
ATOM   1416  N   ARG B  90      25.057  38.182  10.128  1.00100.16           N  
ATOM   1417  CA  ARG B  90      24.304  37.432   9.121  1.00101.50           C  
ATOM   1418  C   ARG B  90      25.173  36.390   8.410  1.00101.66           C  
ATOM   1419  O   ARG B  90      25.603  36.561   7.267  1.00101.72           O  
ATOM   1420  CB  ARG B  90      23.686  38.381   8.094  1.00102.17           C  
ATOM   1421  CG  ARG B  90      24.712  39.098   7.237  1.00104.50           C  
ATOM   1422  CD  ARG B  90      24.116  40.042   6.215  1.00108.02           C  
ATOM   1423  NE  ARG B  90      25.131  40.582   5.315  1.00110.75           N  
ATOM   1424  CZ  ARG B  90      24.965  41.674   4.576  1.00112.52           C  
ATOM   1425  NH1 ARG B  90      23.819  42.344   4.629  1.00113.19           N  
ATOM   1426  NH2 ARG B  90      25.940  42.098   3.780  1.00113.32           N  
ATOM   1427  OXT ARG B  90      25.477  35.322   8.942  1.00101.85           O  
TER    1428      ARG B  90                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
