
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  689),  selected   90 , name 2hqx_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2hqx_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     8_A      E       1           -
LGA    Q     9_A      N       2           -
LGA    F    10_A      L       3           -
LGA    Q    11_A      Y       4           -
LGA    K    12_A      F       5           -
LGA    L    13_A      Q       6           -
LGA    M    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    M    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    N    19_A      -       -           -
LGA    D    20_A      -       -           -
LGA    I    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    H    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    P    26_A      -       -           -
LGA    V    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    Y    31_A      G       7           #
LGA    A    32_A      D       8          4.025
LGA    P    33_A      L       9          2.893
LGA    R    34_A      I      10          1.544
LGA    R    35_A      V      11          0.443
LGA    G    36_A      S      12          0.321
LGA    E    37_A      M      13          0.177
LGA    F    38_A      R      14          0.268
LGA    C    39_A      I      15          0.349
LGA    I    40_A      L      16          0.305
LGA    A    41_A      G      17          0.409
LGA    K    42_A      K      18          0.793
LGA    F    43_A      K      19          1.115
LGA    V    44_A      R      20          1.385
LGA    D    45_A      T      21          1.309
LGA    G    46_A      K      22          0.822
LGA    E    47_A      T      23          0.469
LGA    W    48_A      W      24          0.341
LGA    Y    49_A      X      25          0.448
LGA    R    50_A      K      26          0.247
LGA    A    51_A      G      27          0.793
LGA    R    52_A      T      28          0.366
LGA    V    53_A      L      29          0.505
LGA    E    54_A      I      30          0.515
LGA    K    55_A      A      31          0.740
LGA    V    56_A      I      32          0.565
LGA    E    57_A      Q      33          0.408
LGA    S    58_A      T      34          2.504
LGA    P    59_A      V      35           -
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    A    60_A      K      39          2.857
LGA    K    61_A      K      40          1.070
LGA    I    62_A      Y      41          0.816
LGA    H    63_A      K      42          0.870
LGA    V    64_A      V      43          0.821
LGA    F    65_A      K      44          0.241
LGA    Y    66_A      F      45          0.302
LGA    I    67_A      D      46          1.214
LGA    D    68_A      N      47          2.417
LGA    Y    69_A      K      48          2.306
LGA    G    70_A      -       -           -
LGA    N    71_A      G      49          0.791
LGA    R    72_A      K      50          0.390
LGA    E    73_A      S      51          0.449
LGA    V    74_A      L      52          0.404
LGA    L    75_A      L      53          0.517
LGA    P    76_A      S      54          0.729
LGA    S    77_A      G      55          0.814
LGA    T    78_A      N      56          0.648
LGA    R    79_A      X      57          0.614
LGA    L    80_A      I      58          0.677
LGA    G    81_A      A      59          0.684
LGA    T    82_A      Y      60          0.794
LGA    L    83_A      D      61          0.848
LGA    S    84_A      Y      62          2.686
LGA    P    85_A      -       -           -
LGA    A    86_A      -       -           -
LGA    F    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    L    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    A    96_A      -       -           -
LGA    T    97_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   62    5.0     51    1.25     9.80     79.987     3.767

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.627117 * X  +   0.563154 * Y  +   0.538128 * Z  +  39.707535
  Y_new =   0.577492 * X  +   0.127466 * Y  +  -0.806384 * Z  +  65.843315
  Z_new =  -0.522712 * X  +   0.816462 * Y  +  -0.245281 * Z  +   3.219755 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.862637   -1.278955  [ DEG:   106.7213    -73.2787 ]
  Theta =   0.550029    2.591564  [ DEG:    31.5143    148.4857 ]
  Phi   =   0.744225   -2.397367  [ DEG:    42.6410   -137.3590 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hqx_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hqx_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   62   5.0   51   1.25    9.80  79.987
REMARK  ---------------------------------------------------------- 
MOLECULE 2hqx_A
HEADER    TRANSCRIPTION                           19-JUL-06   2HQX              
TITLE     CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN CONSERVED                
TITLE    2 REGION                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P100 CO-ACTIVATOR TUDOR DOMAIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: CONSERVED REGION;                                          
COMPND   5 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   6 COACTIVATOR P100;                                                    
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    HUMAN P100 TUDOR DOMAIN, PROTEOLYTIC FRAGMENT, PSI,                   
KEYWDS   2 STRUCTURAL GENOMICS, SOUTHEAST COLLABORATORY FOR STRUCTURAL          
KEYWDS   3 GENOMICS, PROTEIN STRUCTURE INITIATIVE, SECSG                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG,                   
AUTHOR   2 SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS (SECSG)              
REVDAT   1   10-OCT-06 2HQX    0                                                
JRNL        AUTH   M.ZHAO,Z.J.LIU,H.XU,J.YANG,O.SILVENNOINEN,B.C.WANG           
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN P100 TUDOR DOMAIN                 
JRNL        TITL 2 CONSERVED REGION                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.42 ANGSTROMS.                                          
DBREF  2HQX A  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
DBREF  2HQX B  -32   213  UNP    Q7KZF4   SND1_HUMAN     665    910             
SEQRES   1 A  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 A  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 A  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 A  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 A  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 A  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 A  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 A  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 A  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 A  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 A  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 A  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 A  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 A  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 A  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 A  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 A  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 A  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 A  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
SEQRES   1 B  246  PRO VAL GLU GLU VAL MET PRO VAL LEU GLU GLU LYS GLU          
SEQRES   2 B  246  ARG SER ALA SER TYR LYS PRO VAL PHE VAL THR GLU ILE          
SEQRES   3 B  246  THR ASP ASP LEU HIS PHE TYR VAL GLN ASP VAL GLU THR          
SEQRES   4 B  246  GLY THR GLN PHE GLN LYS LEU MET GLU ASN MET ARG ASN          
SEQRES   5 B  246  ASP ILE ALA SER HIS PRO PRO VAL GLU GLY SER TYR ALA          
SEQRES   6 B  246  PRO ARG ARG GLY GLU PHE CYS ILE ALA LYS PHE VAL ASP          
SEQRES   7 B  246  GLY GLU TRP TYR ARG ALA ARG VAL GLU LYS VAL GLU SER          
SEQRES   8 B  246  PRO ALA LYS ILE HIS VAL PHE TYR ILE ASP TYR GLY ASN          
SEQRES   9 B  246  ARG GLU VAL LEU PRO SER THR ARG LEU GLY THR LEU SER          
SEQRES  10 B  246  PRO ALA PHE SER THR ARG VAL LEU PRO ALA GLN ALA THR          
SEQRES  11 B  246  GLU TYR ALA PHE ALA PHE ILE GLN VAL PRO GLN ASP ASP          
SEQRES  12 B  246  ASP ALA ARG THR ASP ALA VAL ASP SER VAL VAL ARG ASP          
SEQRES  13 B  246  ILE GLN ASN THR GLN CYS LEU LEU ASN VAL GLU HIS LEU          
SEQRES  14 B  246  SER ALA GLY CYS PRO HIS VAL THR LEU GLN PHE ALA ASP          
SEQRES  15 B  246  SER LYS GLY ASP VAL GLY LEU GLY LEU VAL LYS GLU GLY          
SEQRES  16 B  246  LEU VAL MET VAL GLU VAL ARG LYS GLU LYS GLN PHE GLN          
SEQRES  17 B  246  LYS VAL ILE THR GLU TYR LEU ASN ALA GLN GLU SER ALA          
SEQRES  18 B  246  LYS SER ALA ARG LEU ASN LEU TRP ARG TYR GLY ASP PHE          
SEQRES  19 B  246  ARG ALA ASP ASP ALA ASP GLU PHE GLY TYR SER ARG              
FORMUL   3  HOH   *238(H2 O)                                                    
CRYST1   30.777   37.684   40.202  90.03 105.32  99.72 P 1           2          
ATOM      1  N   THR A   8      44.173  51.220  15.756  1.00 16.75           N  
ATOM      2  CA  THR A   8      45.328  51.980  15.237  1.00 16.10           C  
ATOM      3  C   THR A   8      45.025  53.491  15.487  1.00 14.88           C  
ATOM      4  O   THR A   8      43.854  53.884  15.575  1.00 14.71           O  
ATOM      5  CB  THR A   8      45.491  51.580  13.755  1.00 17.47           C  
ATOM      6  OG1 THR A   8      46.729  50.891  13.514  1.00 19.52           O  
ATOM      7  CG2 THR A   8      45.264  52.714  12.820  1.00 15.31           C  
ATOM      8  N   GLN A   9      46.048  54.332  15.650  1.00 13.80           N  
ATOM      9  CA  GLN A   9      45.820  55.778  15.846  1.00 13.61           C  
ATOM     10  C   GLN A   9      44.991  56.379  14.717  1.00 12.48           C  
ATOM     11  O   GLN A   9      44.079  57.171  14.947  1.00 11.58           O  
ATOM     12  CB  GLN A   9      47.144  56.528  15.961  1.00 13.92           C  
ATOM     13  CG  GLN A   9      47.820  56.307  17.285  1.00 15.09           C  
ATOM     14  CD  GLN A   9      49.132  57.036  17.379  1.00 19.09           C  
ATOM     15  OE1 GLN A   9      49.172  58.212  17.743  1.00 20.50           O  
ATOM     16  NE2 GLN A   9      50.215  56.345  17.059  1.00 19.89           N  
ATOM     17  N   PHE A  10      45.319  55.984  13.494  1.00 11.78           N  
ATOM     18  CA  PHE A  10      44.574  56.407  12.321  1.00 12.54           C  
ATOM     19  C   PHE A  10      43.111  55.964  12.424  1.00 12.65           C  
ATOM     20  O   PHE A  10      42.196  56.763  12.216  1.00 11.53           O  
ATOM     21  CB  PHE A  10      45.236  55.788  11.103  1.00 13.20           C  
ATOM     22  CG  PHE A  10      44.730  56.289   9.791  1.00 15.30           C  
ATOM     23  CD1 PHE A  10      43.919  57.416   9.702  1.00 18.59           C  
ATOM     24  CD2 PHE A  10      45.176  55.677   8.624  1.00 16.10           C  
ATOM     25  CE1 PHE A  10      43.488  57.856   8.488  1.00 22.43           C  
ATOM     26  CE2 PHE A  10      44.765  56.119   7.406  1.00 20.68           C  
ATOM     27  CZ  PHE A  10      43.914  57.204   7.333  1.00 21.20           C  
ATOM     28  N   GLN A  11      42.877  54.697  12.748  1.00 12.37           N  
ATOM     29  CA  GLN A  11      41.514  54.164  12.842  1.00 12.83           C  
ATOM     30  C   GLN A  11      40.691  54.906  13.877  1.00 12.37           C  
ATOM     31  O   GLN A  11      39.535  55.228  13.633  1.00 12.13           O  
ATOM     32  CB  GLN A  11      41.528  52.659  13.139  1.00 12.82           C  
ATOM     33  CG  GLN A  11      41.901  51.802  11.922  1.00 14.23           C  
ATOM     34  CD  GLN A  11      42.075  50.318  12.265  1.00 15.49           C  
ATOM     35  OE1 GLN A  11      42.514  49.967  13.365  1.00 17.16           O  
ATOM     36  NE2 GLN A  11      41.704  49.446  11.331  1.00 20.39           N  
ATOM     37  N   LYS A  12      41.297  55.182  15.027  1.00 12.00           N  
ATOM     38  CA  LYS A  12      40.631  55.881  16.113  1.00 12.13           C  
ATOM     39  C   LYS A  12      40.313  57.315  15.714  1.00 11.57           C  
ATOM     40  O   LYS A  12      39.230  57.808  16.002  1.00 11.16           O  
ATOM     41  CB  LYS A  12      41.469  55.869  17.396  1.00 11.93           C  
ATOM     42  CG  LYS A  12      41.649  54.490  18.039  1.00 14.52           C  
ATOM     43  CD  LYS A  12      42.526  54.563  19.291  1.00 14.51           C  
ATOM     44  CE  LYS A  12      42.518  53.234  20.056  1.00 19.55           C  
ATOM     45  NZ  LYS A  12      43.059  52.114  19.238  1.00 24.55           N  
ATOM     46  N   LEU A  13      41.261  57.997  15.063  1.00 10.51           N  
ATOM     47  CA  LEU A  13      41.001  59.379  14.630  1.00 10.73           C  
ATOM     48  C   LEU A  13      39.868  59.422  13.605  1.00 10.21           C  
ATOM     49  O   LEU A  13      39.024  60.306  13.672  1.00 10.01           O  
ATOM     50  CB  LEU A  13      42.263  60.066  14.069  1.00 11.42           C  
ATOM     51  CG  LEU A  13      42.123  61.551  13.660  1.00 11.17           C  
ATOM     52  CD1 LEU A  13      42.152  62.476  14.873  1.00 16.37           C  
ATOM     53  CD2 LEU A  13      43.206  61.975  12.672  1.00 11.27           C  
ATOM     54  N   MET A  14      39.831  58.470  12.677  1.00 10.36           N  
ATOM     55  CA  MET A  14      38.793  58.483  11.639  1.00 10.20           C  
ATOM     56  C   MET A  14      37.424  58.280  12.226  1.00 10.43           C  
ATOM     57  O   MET A  14      36.465  58.920  11.813  1.00  9.31           O  
ATOM     58  CB  MET A  14      39.063  57.462  10.529  1.00 11.05           C  
ATOM     59  CG  MET A  14      40.227  57.846   9.675  1.00 11.11           C  
ATOM     60  SD  MET A  14      39.960  59.375   8.755  1.00  9.40           S  
ATOM     61  CE  MET A  14      39.907  58.646   7.141  1.00 17.93           C  
ATOM     62  N   GLU A  15      37.329  57.374  13.194  1.00 10.81           N  
ATOM     63  CA  GLU A  15      36.069  57.150  13.882  1.00 12.10           C  
ATOM     64  C   GLU A  15      35.615  58.414  14.594  1.00 10.89           C  
ATOM     65  O   GLU A  15      34.473  58.839  14.442  1.00 11.54           O  
ATOM     66  CB  GLU A  15      36.197  56.000  14.881  1.00 12.70           C  
ATOM     67  CG  GLU A  15      34.901  55.610  15.547  1.00 17.88           C  
ATOM     68  CD  GLU A  15      34.977  54.250  16.214  1.00 23.93           C  
ATOM     69  OE1 GLU A  15      35.896  54.035  17.039  1.00 27.87           O  
ATOM     70  OE2 GLU A  15      34.113  53.391  15.915  1.00 26.43           O  
ATOM     71  N   ASN A  16      36.517  59.021  15.355  1.00 10.07           N  
ATOM     72  CA  ASN A  16      36.149  60.209  16.119  1.00 10.59           C  
ATOM     73  C   ASN A  16      35.797  61.356  15.162  1.00  9.32           C  
ATOM     74  O   ASN A  16      34.798  62.020  15.340  1.00  9.80           O  
ATOM     75  CB  ASN A  16      37.261  60.609  17.091  1.00 11.24           C  
ATOM     76  CG  ASN A  16      37.392  59.643  18.258  1.00 15.04           C  
ATOM     77  OD1 ASN A  16      36.387  59.194  18.815  1.00 20.56           O  
ATOM     78  ND2 ASN A  16      38.632  59.347  18.659  1.00 17.70           N  
ATOM     79  N   MET A  17      36.610  61.542  14.114  1.00  7.97           N  
ATOM     80  CA  MET A  17      36.367  62.603  13.140  1.00  7.30           C  
ATOM     81  C   MET A  17      35.024  62.425  12.442  1.00  8.02           C  
ATOM     82  O   MET A  17      34.244  63.361  12.329  1.00  8.57           O  
ATOM     83  CB  MET A  17      37.510  62.666  12.109  1.00  7.38           C  
ATOM     84  CG  MET A  17      37.345  63.792  11.111  1.00  6.92           C  
ATOM     85  SD  MET A  17      38.652  63.848   9.869  1.00  6.16           S  
ATOM     86  CE  MET A  17      38.010  62.628   8.716  1.00 10.56           C  
ATOM     87  N   ARG A  18      34.752  61.215  11.954  1.00  7.24           N  
ATOM     88  CA  ARG A  18      33.497  60.930  11.256  1.00  7.54           C  
ATOM     89  C   ARG A  18      32.274  61.057  12.157  1.00  7.83           C  
ATOM     90  O   ARG A  18      31.223  61.536  11.708  1.00  7.75           O  
ATOM     91  CB  ARG A  18      33.535  59.557  10.557  1.00  6.41           C  
ATOM     92  CG  ARG A  18      34.566  59.560   9.419  1.00  5.70           C  
ATOM     93  CD  ARG A  18      34.803  58.220   8.789  1.00  7.84           C  
ATOM     94  NE  ARG A  18      35.734  58.374   7.671  1.00  8.77           N  
ATOM     95  CZ  ARG A  18      36.623  57.463   7.317  1.00 11.57           C  
ATOM     96  NH1 ARG A  18      37.426  57.710   6.293  1.00 11.75           N  
ATOM     97  NH2 ARG A  18      36.733  56.330   8.008  1.00 13.32           N  
ATOM     98  N   ASN A  19      32.418  60.691  13.428  1.00  7.94           N  
ATOM     99  CA  ASN A  19      31.305  60.895  14.368  1.00  9.63           C  
ATOM    100  C   ASN A  19      31.041  62.376  14.581  1.00  9.80           C  
ATOM    101  O   ASN A  19      29.890  62.814  14.663  1.00 10.63           O  
ATOM    102  CB  ASN A  19      31.559  60.175  15.685  1.00  9.99           C  
ATOM    103  CG  ASN A  19      31.482  58.676  15.545  1.00 10.90           C  
ATOM    104  OD1 ASN A  19      30.928  58.146  14.578  1.00 13.73           O  
ATOM    105  ND2 ASN A  19      32.057  57.972  16.516  1.00 14.33           N  
ATOM    106  N   ASP A  20      32.117  63.166  14.633  1.00 10.18           N  
ATOM    107  CA  ASP A  20      31.976  64.614  14.773  1.00 10.64           C  
ATOM    108  C   ASP A  20      31.379  65.248  13.512  1.00  9.95           C  
ATOM    109  O   ASP A  20      30.516  66.122  13.591  1.00 10.82           O  
ATOM    110  CB  ASP A  20      33.311  65.273  15.076  1.00 11.83           C  
ATOM    111  CG  ASP A  20      33.139  66.729  15.445  1.00 14.49           C  
ATOM    112  OD1 ASP A  20      33.456  67.604  14.612  1.00 16.19           O  
ATOM    113  OD2 ASP A  20      32.617  67.001  16.551  1.00 17.87           O  
ATOM    114  N   ILE A  21      31.846  64.822  12.339  1.00  8.95           N  
ATOM    115  CA  ILE A  21      31.299  65.355  11.082  1.00 10.19           C  
ATOM    116  C   ILE A  21      29.800  65.056  11.018  1.00 11.00           C  
ATOM    117  O   ILE A  21      29.019  65.910  10.644  1.00 11.76           O  
ATOM    118  CB  ILE A  21      32.024  64.795   9.833  1.00 10.21           C  
ATOM    119  CG1 ILE A  21      33.480  65.284   9.816  1.00  9.69           C  
ATOM    120  CG2 ILE A  21      31.321  65.199   8.531  1.00 11.20           C  
ATOM    121  CD1 ILE A  21      34.409  64.461   8.965  1.00  9.96           C  
ATOM    122  N   ALA A  22      29.397  63.851  11.407  1.00 12.28           N  
ATOM    123  CA  ALA A  22      27.987  63.478  11.381  1.00 14.08           C  
ATOM    124  C   ALA A  22      27.157  64.355  12.332  1.00 15.06           C  
ATOM    125  O   ALA A  22      26.006  64.676  12.019  1.00 16.83           O  
ATOM    126  CB  ALA A  22      27.843  62.003  11.715  1.00 13.99           C  
ATOM    127  N   SER A  23      27.746  64.780  13.452  1.00 15.85           N  
ATOM    128  CA  SER A  23      27.078  65.687  14.407  1.00 17.23           C  
ATOM    129  C   SER A  23      26.937  67.117  13.876  1.00 17.27           C  
ATOM    130  O   SER A  23      26.076  67.864  14.338  1.00 17.49           O  
ATOM    131  CB  SER A  23      27.842  65.776  15.732  1.00 17.43           C  
ATOM    132  OG  SER A  23      28.303  64.516  16.192  1.00 22.52           O  
ATOM    133  N   HIS A  24      27.805  67.496  12.939  1.00 16.17           N  
ATOM    134  CA  HIS A  24      27.865  68.861  12.409  1.00 16.68           C  
ATOM    135  C   HIS A  24      28.305  68.832  10.940  1.00 16.31           C  
ATOM    136  O   HIS A  24      29.417  69.248  10.592  1.00 16.05           O  
ATOM    137  CB  HIS A  24      28.835  69.724  13.263  1.00 16.85           C  
ATOM    138  N   PRO A  25      27.419  68.338  10.084  1.00 16.86           N  
ATOM    139  CA  PRO A  25      27.724  68.126   8.673  1.00 16.33           C  
ATOM    140  C   PRO A  25      28.173  69.430   8.012  1.00 16.33           C  
ATOM    141  O   PRO A  25      27.623  70.492   8.320  1.00 16.20           O  
ATOM    142  CB  PRO A  25      26.498  67.560   7.958  1.00 16.95           C  
ATOM    143  N   PRO A  26      29.176  69.371   7.110  1.00 15.96           N  
ATOM    144  CA  PRO A  26      29.594  70.615   6.461  1.00 15.73           C  
ATOM    145  C   PRO A  26      28.423  71.334   5.803  1.00 15.54           C  
ATOM    146  O   PRO A  26      27.553  70.683   5.205  1.00 15.34           O  
ATOM    147  CB  PRO A  26      30.568  70.136   5.379  1.00 16.16           C  
ATOM    148  CG  PRO A  26      31.119  68.871   5.917  1.00 15.87           C  
ATOM    149  CD  PRO A  26      29.987  68.222   6.663  1.00 16.27           C  
ATOM    150  N   VAL A  27      28.430  72.664   5.903  1.00 15.82           N  
ATOM    151  CA  VAL A  27      27.382  73.497   5.310  1.00 16.24           C  
ATOM    152  C   VAL A  27      27.846  74.027   3.965  1.00 16.84           C  
ATOM    153  O   VAL A  27      28.919  74.611   3.869  1.00 16.47           O  
ATOM    154  CB  VAL A  27      27.050  74.639   6.227  1.00 16.32           C  
ATOM    155  N   GLU A  28      27.031  73.834   2.929  1.00 17.35           N  
ATOM    156  CA  GLU A  28      27.399  74.273   1.588  1.00 17.90           C  
ATOM    157  C   GLU A  28      27.714  75.765   1.595  1.00 18.07           C  
ATOM    158  O   GLU A  28      26.948  76.570   2.126  1.00 18.38           O  
ATOM    159  CB  GLU A  28      26.295  73.935   0.584  1.00 18.46           C  
ATOM    160  N   GLY A  29      28.899  76.103   1.082  1.00 18.18           N  
ATOM    161  CA  GLY A  29      29.368  77.480   0.928  1.00 18.38           C  
ATOM    162  C   GLY A  29      30.231  77.995   2.079  1.00 18.05           C  
ATOM    163  O   GLY A  29      30.931  78.995   1.933  1.00 18.58           O  
ATOM    164  N   SER A  30      30.193  77.302   3.209  1.00 17.44           N  
ATOM    165  CA  SER A  30      30.942  77.737   4.365  1.00 16.41           C  
ATOM    166  C   SER A  30      32.464  77.545   4.167  1.00 16.16           C  
ATOM    167  O   SER A  30      33.240  78.472   4.410  1.00 16.83           O  
ATOM    168  CB  SER A  30      30.441  77.028   5.597  1.00 16.65           C  
ATOM    169  N   TYR A  31      32.890  76.362   3.718  1.00 14.74           N  
ATOM    170  CA  TYR A  31      34.315  76.130   3.452  1.00 14.07           C  
ATOM    171  C   TYR A  31      34.711  76.527   2.030  1.00 13.73           C  
ATOM    172  O   TYR A  31      34.101  76.059   1.073  1.00 14.48           O  
ATOM    173  CB  TYR A  31      34.736  74.671   3.709  1.00 13.89           C  
ATOM    174  CG  TYR A  31      36.196  74.459   3.361  1.00 12.59           C  
ATOM    175  CD1 TYR A  31      37.203  74.990   4.166  1.00 14.24           C  
ATOM    176  CD2 TYR A  31      36.567  73.793   2.205  1.00 11.84           C  
ATOM    177  CE1 TYR A  31      38.551  74.846   3.835  1.00 14.96           C  
ATOM    178  CE2 TYR A  31      37.928  73.621   1.860  1.00 11.87           C  
ATOM    179  CZ  TYR A  31      38.906  74.172   2.677  1.00 13.26           C  
ATOM    180  OH  TYR A  31      40.243  74.048   2.376  1.00 14.31           O  
ATOM    181  N   ALA A  32      35.738  77.365   1.910  1.00 13.28           N  
ATOM    182  CA  ALA A  32      36.269  77.791   0.615  1.00 13.65           C  
ATOM    183  C   ALA A  32      37.675  77.211   0.450  1.00 13.02           C  
ATOM    184  O   ALA A  32      38.538  77.432   1.295  1.00 14.27           O  
ATOM    185  CB  ALA A  32      36.303  79.310   0.531  1.00 14.64           C  
ATOM    186  N   PRO A  33      37.892  76.476  -0.638  1.00 13.08           N  
ATOM    187  CA  PRO A  33      39.167  75.794  -0.868  1.00 13.26           C  
ATOM    188  C   PRO A  33      40.264  76.776  -1.252  1.00 13.46           C  
ATOM    189  O   PRO A  33      40.055  77.659  -2.097  1.00 13.90           O  
ATOM    190  CB  PRO A  33      39.011  74.734  -1.950  1.00 13.84           C  
ATOM    191  N   ARG A  34      41.424  76.648  -0.624  1.00 12.70           N  
ATOM    192  CA  ARG A  34      42.598  77.401  -1.043  1.00 12.98           C  
ATOM    193  C   ARG A  34      43.817  76.493  -1.030  1.00 12.57           C  
ATOM    194  O   ARG A  34      43.947  75.621  -0.164  1.00 11.54           O  
ATOM    195  CB  ARG A  34      42.817  78.611  -0.141  1.00 14.13           C  
ATOM    196  N   ARG A  35      44.694  76.695  -2.012  1.00 11.58           N  
ATOM    197  CA  ARG A  35      45.866  75.862  -2.183  1.00 10.64           C  
ATOM    198  C   ARG A  35      46.671  75.786  -0.900  1.00 10.06           C  
ATOM    199  O   ARG A  35      46.951  76.808  -0.259  1.00 10.34           O  
ATOM    200  CB  ARG A  35      46.736  76.365  -3.347  1.00 10.80           C  
ATOM    201  CG  ARG A  35      47.849  75.421  -3.706  1.00 10.90           C  
ATOM    202  CD  ARG A  35      48.859  76.084  -4.637  1.00 14.85           C  
ATOM    203  NE  ARG A  35      48.492  76.007  -6.044  1.00 19.14           N  
ATOM    204  CZ  ARG A  35      49.200  75.387  -6.996  1.00 18.83           C  
ATOM    205  NH1 ARG A  35      50.339  74.755  -6.720  1.00 19.19           N  
ATOM    206  NH2 ARG A  35      48.752  75.403  -8.241  1.00 19.76           N  
ATOM    207  N   GLY A  36      47.010  74.550  -0.525  1.00  9.39           N  
ATOM    208  CA  GLY A  36      47.855  74.286   0.624  1.00 10.24           C  
ATOM    209  C   GLY A  36      47.117  74.114   1.943  1.00  9.55           C  
ATOM    210  O   GLY A  36      47.719  73.673   2.943  1.00 11.29           O  
ATOM    211  N   GLU A  37      45.824  74.442   1.954  1.00 10.51           N  
ATOM    212  CA  GLU A  37      44.998  74.297   3.159  1.00 10.26           C  
ATOM    213  C   GLU A  37      44.562  72.859   3.325  1.00 10.03           C  
ATOM    214  O   GLU A  37      44.352  72.147   2.340  1.00  9.59           O  
ATOM    215  CB  GLU A  37      43.770  75.200   3.099  1.00 10.87           C  
ATOM    216  N   PHE A  38      44.434  72.446   4.584  1.00  9.32           N  
ATOM    217  CA  PHE A  38      43.818  71.161   4.913  1.00  9.33           C  
ATOM    218  C   PHE A  38      42.296  71.304   4.991  1.00 10.00           C  
ATOM    219  O   PHE A  38      41.748  72.380   5.264  1.00 11.29           O  
ATOM    220  CB  PHE A  38      44.375  70.632   6.239  1.00  9.49           C  
ATOM    221  CG  PHE A  38      45.848  70.321   6.199  1.00  9.71           C  
ATOM    222  CD1 PHE A  38      46.796  71.255   6.623  1.00 10.29           C  
ATOM    223  CD2 PHE A  38      46.289  69.093   5.726  1.00 10.46           C  
ATOM    224  CE1 PHE A  38      48.157  70.942   6.573  1.00 12.80           C  
ATOM    225  CE2 PHE A  38      47.632  68.789   5.673  1.00 10.65           C  
ATOM    226  CZ  PHE A  38      48.567  69.714   6.094  1.00 12.32           C  
ATOM    227  N   CYS A  39      41.613  70.205   4.704  1.00  8.76           N  
ATOM    228  CA  CYS A  39      40.169  70.165   4.712  1.00  8.92           C  
ATOM    229  C   CYS A  39      39.726  68.740   4.909  1.00  9.07           C  
ATOM    230  O   CYS A  39      40.550  67.850   5.074  1.00  7.04           O  
ATOM    231  CB  CYS A  39      39.629  70.720   3.391  1.00  9.88           C  
ATOM    232  SG  CYS A  39      40.118  69.765   1.951  1.00 11.93           S  
ATOM    233  N   ILE A  40      38.418  68.511   4.903  1.00  7.30           N  
ATOM    234  CA  ILE A  40      37.926  67.152   4.759  1.00  7.17           C  
ATOM    235  C   ILE A  40      37.341  67.017   3.351  1.00  6.57           C  
ATOM    236  O   ILE A  40      36.847  67.994   2.781  1.00  7.57           O  
ATOM    237  CB  ILE A  40      36.901  66.751   5.854  1.00  7.18           C  
ATOM    238  CG1 ILE A  40      35.726  67.736   5.930  1.00  7.23           C  
ATOM    239  CG2 ILE A  40      37.604  66.614   7.185  1.00  8.07           C  
ATOM    240  CD1 ILE A  40      34.557  67.344   6.846  1.00  6.16           C  
ATOM    241  N   ALA A  41      37.426  65.818   2.792  1.00  6.55           N  
ATOM    242  CA  ALA A  41      36.967  65.539   1.440  1.00  7.00           C  
ATOM    243  C   ALA A  41      36.144  64.266   1.446  1.00  6.77           C  
ATOM    244  O   ALA A  41      36.543  63.279   2.097  1.00  7.27           O  
ATOM    245  CB  ALA A  41      38.167  65.405   0.493  1.00  8.18           C  
ATOM    246  N   LYS A  42      35.011  64.298   0.745  1.00  7.93           N  
ATOM    247  CA  LYS A  42      34.121  63.160   0.693  1.00  7.59           C  
ATOM    248  C   LYS A  42      34.453  62.285  -0.498  1.00  8.24           C  
ATOM    249  O   LYS A  42      34.224  62.672  -1.633  1.00  9.17           O  
ATOM    250  CB  LYS A  42      32.671  63.639   0.622  1.00  8.67           C  
ATOM    251  CG  LYS A  42      31.714  62.608   1.150  1.00 10.02           C  
ATOM    252  CD  LYS A  42      30.294  63.167   1.192  1.00 13.40           C  
ATOM    253  CE  LYS A  42      29.317  62.204   1.843  1.00 17.13           C  
ATOM    254  NZ  LYS A  42      27.916  62.726   1.833  1.00 20.07           N  
ATOM    255  N   PHE A  43      35.016  61.106  -0.224  1.00  8.28           N  
ATOM    256  CA  PHE A  43      35.526  60.209  -1.261  1.00  9.61           C  
ATOM    257  C   PHE A  43      34.358  59.480  -1.936  1.00 10.38           C  
ATOM    258  O   PHE A  43      33.197  59.635  -1.533  1.00 10.99           O  
ATOM    259  CB  PHE A  43      36.503  59.235  -0.600  1.00  9.52           C  
ATOM    260  CG  PHE A  43      37.257  58.351  -1.546  1.00  9.45           C  
ATOM    261  CD1 PHE A  43      37.937  58.877  -2.647  1.00 10.26           C  
ATOM    262  CD2 PHE A  43      37.334  56.993  -1.298  1.00  9.98           C  
ATOM    263  CE1 PHE A  43      38.663  58.042  -3.529  1.00 11.32           C  
ATOM    264  CE2 PHE A  43      38.055  56.149  -2.175  1.00 12.02           C  
ATOM    265  CZ  PHE A  43      38.704  56.680  -3.290  1.00 11.39           C  
ATOM    266  N   VAL A  44      34.660  58.655  -2.936  1.00 10.56           N  
ATOM    267  CA  VAL A  44      33.623  57.980  -3.719  1.00 12.17           C  
ATOM    268  C   VAL A  44      32.836  56.928  -2.925  1.00 12.29           C  
ATOM    269  O   VAL A  44      31.792  56.431  -3.389  1.00 13.89           O  
ATOM    270  CB  VAL A  44      34.207  57.329  -4.997  1.00 12.04           C  
ATOM    271  CG1 VAL A  44      34.924  58.363  -5.865  1.00 12.53           C  
ATOM    272  CG2 VAL A  44      35.094  56.128  -4.642  1.00 14.43           C  
ATOM    273  N   ASP A  45      33.324  56.573  -1.741  1.00 11.75           N  
ATOM    274  CA  ASP A  45      32.622  55.626  -0.863  1.00 11.56           C  
ATOM    275  C   ASP A  45      31.590  56.310   0.048  1.00 11.69           C  
ATOM    276  O   ASP A  45      30.937  55.660   0.876  1.00 12.71           O  
ATOM    277  CB  ASP A  45      33.623  54.799  -0.040  1.00 12.03           C  
ATOM    278  CG  ASP A  45      34.553  55.660   0.819  1.00 12.79           C  
ATOM    279  OD1 ASP A  45      34.492  56.903   0.728  1.00 13.95           O  
ATOM    280  OD2 ASP A  45      35.346  55.069   1.593  1.00 13.84           O  
ATOM    281  N   GLY A  46      31.446  57.621  -0.127  1.00 12.07           N  
ATOM    282  CA  GLY A  46      30.533  58.413   0.674  1.00 11.77           C  
ATOM    283  C   GLY A  46      31.069  58.708   2.068  1.00 11.72           C  
ATOM    284  O   GLY A  46      30.343  59.228   2.916  1.00 12.53           O  
ATOM    285  N   GLU A  47      32.345  58.387   2.303  1.00 11.04           N  
ATOM    286  CA  GLU A  47      32.999  58.672   3.588  1.00 10.73           C  
ATOM    287  C   GLU A  47      33.926  59.892   3.516  1.00  9.61           C  
ATOM    288  O   GLU A  47      34.491  60.197   2.454  1.00  8.04           O  
ATOM    289  CB  GLU A  47      33.778  57.451   4.108  1.00 11.61           C  
ATOM    290  CG  GLU A  47      32.924  56.199   4.431  1.00 13.87           C  
ATOM    291  CD  GLU A  47      31.961  56.371   5.614  1.00 19.30           C  
ATOM    292  OE1 GLU A  47      32.194  57.222   6.494  1.00 19.25           O  
ATOM    293  OE2 GLU A  47      30.963  55.619   5.671  1.00 22.42           O  
ATOM    294  N   TRP A  48      34.088  60.569   4.660  1.00  7.80           N  
ATOM    295  CA  TRP A  48      34.930  61.761   4.763  1.00  7.49           C  
ATOM    296  C   TRP A  48      36.346  61.353   5.181  1.00  6.22           C  
ATOM    297  O   TRP A  48      36.546  60.452   6.014  1.00  8.16           O  
ATOM    298  CB  TRP A  48      34.381  62.760   5.785  1.00  7.64           C  
ATOM    299  CG  TRP A  48      33.104  63.443   5.360  1.00  8.14           C  
ATOM    300  CD1 TRP A  48      31.836  63.050   5.694  1.00  9.85           C  
ATOM    301  CD2 TRP A  48      32.953  64.608   4.515  1.00  7.56           C  
ATOM    302  NE1 TRP A  48      30.905  63.904   5.121  1.00  9.76           N  
ATOM    303  CE2 TRP A  48      31.564  64.856   4.383  1.00  8.96           C  
ATOM    304  CE3 TRP A  48      33.853  65.456   3.847  1.00  8.13           C  
ATOM    305  CZ2 TRP A  48      31.061  65.922   3.634  1.00  9.76           C  
ATOM    306  CZ3 TRP A  48      33.353  66.514   3.111  1.00  8.12           C  
ATOM    307  CH2 TRP A  48      31.969  66.739   3.004  1.00  8.47           C  
ATOM    308  N   TYR A  49      37.312  62.040   4.577  1.00  6.59           N  
ATOM    309  CA  TYR A  49      38.740  61.806   4.795  1.00  5.81           C  
ATOM    310  C   TYR A  49      39.475  63.120   4.956  1.00  6.55           C  
ATOM    311  O   TYR A  49      39.020  64.143   4.446  1.00  6.22           O  
ATOM    312  CB  TYR A  49      39.366  61.050   3.601  1.00  6.84           C  
ATOM    313  CG  TYR A  49      38.891  59.620   3.412  1.00  4.42           C  
ATOM    314  CD1 TYR A  49      39.672  58.544   3.819  1.00  6.47           C  
ATOM    315  CD2 TYR A  49      37.679  59.364   2.785  1.00  6.71           C  
ATOM    316  CE1 TYR A  49      39.238  57.232   3.640  1.00  8.18           C  
ATOM    317  CE2 TYR A  49      37.247  58.060   2.589  1.00  6.74           C  
ATOM    318  CZ  TYR A  49      38.027  57.001   3.028  1.00  7.87           C  
ATOM    319  OH  TYR A  49      37.599  55.700   2.830  1.00  8.51           O  
ATOM    320  N   ARG A  50      40.616  63.108   5.639  1.00  5.91           N  
ATOM    321  CA  ARG A  50      41.451  64.310   5.706  1.00  6.00           C  
ATOM    322  C   ARG A  50      42.156  64.531   4.357  1.00  6.57           C  
ATOM    323  O   ARG A  50      42.629  63.593   3.690  1.00  6.30           O  
ATOM    324  CB  ARG A  50      42.489  64.234   6.841  1.00  6.85           C  
ATOM    325  CG  ARG A  50      41.891  63.882   8.188  1.00  6.36           C  
ATOM    326  CD  ARG A  50      42.861  64.158   9.342  1.00  6.42           C  
ATOM    327  NE  ARG A  50      44.058  63.334   9.279  1.00  8.38           N  
ATOM    328  CZ  ARG A  50      45.127  63.535  10.037  1.00  8.14           C  
ATOM    329  NH1 ARG A  50      45.121  64.504  10.958  1.00  5.80           N  
ATOM    330  NH2 ARG A  50      46.183  62.741   9.913  1.00  7.81           N  
ATOM    331  N   ALA A  51      42.233  65.795   3.951  1.00  6.13           N  
ATOM    332  CA  ALA A  51      42.823  66.105   2.664  1.00  6.66           C  
ATOM    333  C   ALA A  51      43.513  67.451   2.671  1.00  7.06           C  
ATOM    334  O   ALA A  51      43.383  68.248   3.596  1.00  7.33           O  
ATOM    335  CB  ALA A  51      41.755  66.043   1.546  1.00  7.24           C  
ATOM    336  N   ARG A  52      44.309  67.663   1.631  1.00  6.95           N  
ATOM    337  CA  ARG A  52      44.960  68.949   1.409  1.00  8.40           C  
ATOM    338  C   ARG A  52      44.690  69.415  -0.020  1.00  7.82           C  
ATOM    339  O   ARG A  52      44.734  68.628  -0.964  1.00  7.57           O  
ATOM    340  CB  ARG A  52      46.467  68.856   1.656  1.00  9.34           C  
ATOM    341  CG  ARG A  52      47.081  70.194   2.021  1.00 14.05           C  
ATOM    342  CD  ARG A  52      48.584  70.237   1.802  1.00 21.67           C  
ATOM    343  NE  ARG A  52      49.338  69.600   2.871  1.00 27.25           N  
ATOM    344  CZ  ARG A  52      50.616  69.865   3.163  1.00 30.14           C  
ATOM    345  NH1 ARG A  52      51.296  70.772   2.467  1.00 31.61           N  
ATOM    346  NH2 ARG A  52      51.217  69.222   4.155  1.00 31.46           N  
ATOM    347  N   VAL A  53      44.394  70.708  -0.166  1.00  7.72           N  
ATOM    348  CA  VAL A  53      44.091  71.260  -1.485  1.00  7.95           C  
ATOM    349  C   VAL A  53      45.408  71.495  -2.251  1.00  7.94           C  
ATOM    350  O   VAL A  53      46.316  72.169  -1.744  1.00  8.14           O  
ATOM    351  CB  VAL A  53      43.253  72.570  -1.371  1.00  7.49           C  
ATOM    352  CG1 VAL A  53      43.034  73.182  -2.743  1.00  8.67           C  
ATOM    353  CG2 VAL A  53      41.851  72.323  -0.705  1.00  9.36           C  
ATOM    354  N   GLU A  54      45.506  70.924  -3.456  1.00  8.91           N  
ATOM    355  CA  GLU A  54      46.693  71.076  -4.301  1.00 10.14           C  
ATOM    356  C   GLU A  54      46.544  72.077  -5.457  1.00 10.92           C  
ATOM    357  O   GLU A  54      47.558  72.646  -5.914  1.00 11.78           O  
ATOM    358  CB  GLU A  54      47.150  69.715  -4.826  1.00 11.42           C  
ATOM    359  CG  GLU A  54      47.698  68.847  -3.700  1.00 12.99           C  
ATOM    360  CD  GLU A  54      48.437  67.622  -4.184  1.00 15.12           C  
ATOM    361  OE1 GLU A  54      48.007  67.019  -5.191  1.00 17.54           O  
ATOM    362  OE2 GLU A  54      49.441  67.259  -3.535  1.00 18.66           O  
ATOM    363  N   LYS A  55      45.309  72.285  -5.927  1.00 10.13           N  
ATOM    364  CA  LYS A  55      45.056  73.207  -7.039  1.00 11.57           C  
ATOM    365  C   LYS A  55      43.565  73.448  -7.163  1.00 11.31           C  
ATOM    366  O   LYS A  55      42.758  72.517  -7.069  1.00 11.70           O  
ATOM    367  CB  LYS A  55      45.612  72.641  -8.343  1.00 11.44           C  
ATOM    368  CG  LYS A  55      45.354  73.482  -9.588  1.00 14.80           C  
ATOM    369  CD  LYS A  55      46.019  72.838 -10.789  1.00 18.11           C  
ATOM    370  CE  LYS A  55      45.133  72.959 -12.023  1.00 22.97           C  
ATOM    371  NZ  LYS A  55      45.627  72.134 -13.181  1.00 25.41           N  
ATOM    372  N   VAL A  56      43.210  74.705  -7.412  1.00 11.94           N  
ATOM    373  CA  VAL A  56      41.839  75.084  -7.659  1.00 13.37           C  
ATOM    374  C   VAL A  56      41.675  75.380  -9.144  1.00 14.42           C  
ATOM    375  O   VAL A  56      42.201  76.386  -9.658  1.00 15.27           O  
ATOM    376  CB  VAL A  56      41.418  76.300  -6.806  1.00 12.94           C  
ATOM    377  CG1 VAL A  56      40.009  76.698  -7.154  1.00 13.48           C  
ATOM    378  CG2 VAL A  56      41.511  75.982  -5.332  1.00 13.45           C  
ATOM    379  N   GLU A  57      40.940  74.501  -9.819  1.00 14.85           N  
ATOM    380  CA  GLU A  57      40.694  74.619 -11.259  1.00 17.44           C  
ATOM    381  C   GLU A  57      39.413  75.421 -11.524  1.00 16.69           C  
ATOM    382  O   GLU A  57      39.398  76.345 -12.360  1.00 17.75           O  
ATOM    383  CB  GLU A  57      40.638  73.213 -11.883  1.00 17.03           C  
ATOM    384  CG  GLU A  57      40.446  73.158 -13.411  1.00 19.50           C  
ATOM    385  CD  GLU A  57      40.334  71.733 -13.969  1.00 20.48           C  
ATOM    386  OE1 GLU A  57      39.856  71.591 -15.117  1.00 22.98           O  
ATOM    387  OE2 GLU A  57      40.718  70.753 -13.289  1.00 23.49           O  
ATOM    388  N   SER A  58      38.349  75.074 -10.806  1.00 16.72           N  
ATOM    389  CA  SER A  58      37.063  75.771 -10.865  1.00 15.59           C  
ATOM    390  C   SER A  58      36.237  75.395  -9.633  1.00 15.52           C  
ATOM    391  O   SER A  58      36.657  74.533  -8.867  1.00 15.12           O  
ATOM    392  CB  SER A  58      36.336  75.410 -12.169  1.00 15.52           C  
ATOM    393  OG  SER A  58      35.822  74.090 -12.153  1.00 16.88           O  
ATOM    394  N   PRO A  59      35.082  76.045  -9.404  1.00 14.52           N  
ATOM    395  CA  PRO A  59      34.250  75.621  -8.280  1.00 14.85           C  
ATOM    396  C   PRO A  59      33.875  74.140  -8.253  1.00 14.65           C  
ATOM    397  O   PRO A  59      33.630  73.589  -7.166  1.00 14.96           O  
ATOM    398  CB  PRO A  59      33.010  76.485  -8.458  1.00 14.79           C  
ATOM    399  CG  PRO A  59      33.550  77.734  -9.053  1.00 14.11           C  
ATOM    400  CD  PRO A  59      34.494  77.225 -10.072  1.00 14.37           C  
ATOM    401  N   ALA A  60      33.846  73.499  -9.427  1.00 14.00           N  
ATOM    402  CA  ALA A  60      33.462  72.096  -9.534  1.00 14.09           C  
ATOM    403  C   ALA A  60      34.690  71.198  -9.589  1.00 13.95           C  
ATOM    404  O   ALA A  60      34.552  69.984  -9.562  1.00 14.68           O  
ATOM    405  CB  ALA A  60      32.583  71.864 -10.763  1.00 14.66           C  
ATOM    406  N   LYS A  61      35.881  71.793  -9.683  1.00 13.50           N  
ATOM    407  CA  LYS A  61      37.099  71.005  -9.870  1.00 13.26           C  
ATOM    408  C   LYS A  61      38.266  71.424  -8.973  1.00 12.70           C  
ATOM    409  O   LYS A  61      39.100  72.258  -9.335  1.00 12.88           O  
ATOM    410  CB  LYS A  61      37.508  70.940 -11.353  1.00 14.17           C  
ATOM    411  CG  LYS A  61      36.549  70.070 -12.173  1.00 14.50           C  
ATOM    412  CD  LYS A  61      36.933  70.007 -13.651  1.00 14.60           C  
ATOM    413  CE  LYS A  61      35.815  69.391 -14.480  1.00 18.45           C  
ATOM    414  NZ  LYS A  61      36.213  69.290 -15.919  1.00 20.20           N  
ATOM    415  N   ILE A  62      38.303  70.822  -7.790  1.00 10.99           N  
ATOM    416  CA  ILE A  62      39.335  71.096  -6.804  1.00 10.38           C  
ATOM    417  C   ILE A  62      40.202  69.857  -6.668  1.00  9.57           C  
ATOM    418  O   ILE A  62      39.689  68.774  -6.400  1.00  9.85           O  
ATOM    419  CB  ILE A  62      38.720  71.475  -5.438  1.00 10.81           C  
ATOM    420  CG1 ILE A  62      37.678  72.577  -5.642  1.00 13.60           C  
ATOM    421  CG2 ILE A  62      39.807  71.892  -4.453  1.00 10.34           C  
ATOM    422  CD1 ILE A  62      36.944  73.026  -4.431  1.00 19.47           C  
ATOM    423  N   HIS A  63      41.506  70.023  -6.899  1.00  8.72           N  
ATOM    424  CA  HIS A  63      42.465  68.922  -6.829  1.00  9.01           C  
ATOM    425  C   HIS A  63      42.881  68.769  -5.384  1.00  8.69           C  
ATOM    426  O   HIS A  63      43.410  69.700  -4.800  1.00  8.99           O  
ATOM    427  CB  HIS A  63      43.704  69.192  -7.694  1.00 10.21           C  
ATOM    428  CG  HIS A  63      43.413  69.325  -9.161  1.00 11.62           C  
ATOM    429  ND1 HIS A  63      42.434  70.158  -9.660  1.00 15.19           N  
ATOM    430  CD2 HIS A  63      44.017  68.768 -10.236  1.00 14.31           C  
ATOM    431  CE1 HIS A  63      42.417  70.074 -10.978  1.00 15.96           C  
ATOM    432  NE2 HIS A  63      43.381  69.254 -11.355  1.00 14.96           N  
ATOM    433  N   VAL A  64      42.622  67.594  -4.813  1.00  7.77           N  
ATOM    434  CA  VAL A  64      43.036  67.309  -3.436  1.00  8.19           C  
ATOM    435  C   VAL A  64      43.909  66.068  -3.307  1.00  8.74           C  
ATOM    436  O   VAL A  64      43.925  65.192  -4.182  1.00  8.21           O  
ATOM    437  CB  VAL A  64      41.826  67.153  -2.473  1.00  8.10           C  
ATOM    438  CG1 VAL A  64      40.948  68.413  -2.518  1.00  9.03           C  
ATOM    439  CG2 VAL A  64      41.027  65.853  -2.760  1.00  7.74           C  
ATOM    440  N   PHE A  65      44.609  66.012  -2.188  1.00  7.92           N  
ATOM    441  CA  PHE A  65      45.490  64.910  -1.823  1.00  7.55           C  
ATOM    442  C   PHE A  65      44.961  64.386  -0.500  1.00  6.71           C  
ATOM    443  O   PHE A  65      44.833  65.140   0.461  1.00  6.44           O  
ATOM    444  CB  PHE A  65      46.918  65.444  -1.660  1.00  8.39           C  
ATOM    445  CG  PHE A  65      47.911  64.448  -1.117  1.00  8.22           C  
ATOM    446  CD1 PHE A  65      48.419  63.466  -1.943  1.00 11.38           C  
ATOM    447  CD2 PHE A  65      48.413  64.559   0.187  1.00 11.16           C  
ATOM    448  CE1 PHE A  65      49.381  62.545  -1.458  1.00 12.53           C  
ATOM    449  CE2 PHE A  65      49.357  63.648   0.677  1.00 11.65           C  
ATOM    450  CZ  PHE A  65      49.841  62.644  -0.160  1.00 11.67           C  
ATOM    451  N   TYR A  66      44.615  63.098  -0.479  1.00  7.49           N  
ATOM    452  CA  TYR A  66      44.149  62.451   0.736  1.00  7.11           C  
ATOM    453  C   TYR A  66      45.364  62.149   1.617  1.00  6.88           C  
ATOM    454  O   TYR A  66      46.136  61.218   1.329  1.00  6.36           O  
ATOM    455  CB  TYR A  66      43.372  61.175   0.396  1.00  7.67           C  
ATOM    456  CG  TYR A  66      42.032  61.448  -0.209  1.00  8.49           C  
ATOM    457  CD1 TYR A  66      40.944  61.758   0.587  1.00  8.17           C  
ATOM    458  CD2 TYR A  66      41.851  61.393  -1.582  1.00 10.47           C  
ATOM    459  CE1 TYR A  66      39.694  62.018   0.024  1.00  9.97           C  
ATOM    460  CE2 TYR A  66      40.586  61.637  -2.159  1.00 12.04           C  
ATOM    461  CZ  TYR A  66      39.530  61.947  -1.346  1.00 11.25           C  
ATOM    462  OH  TYR A  66      38.284  62.196  -1.887  1.00 11.44           O  
ATOM    463  N   ILE A  67      45.534  62.922   2.691  1.00  7.14           N  
ATOM    464  CA  ILE A  67      46.800  62.931   3.396  1.00  7.34           C  
ATOM    465  C   ILE A  67      47.100  61.668   4.172  1.00  7.59           C  
ATOM    466  O   ILE A  67      48.245  61.438   4.525  1.00  8.49           O  
ATOM    467  CB  ILE A  67      46.959  64.165   4.345  1.00  7.60           C  
ATOM    468  CG1 ILE A  67      45.970  64.110   5.524  1.00  7.26           C  
ATOM    469  CG2 ILE A  67      46.830  65.457   3.547  1.00  7.87           C  
ATOM    470  CD1 ILE A  67      46.226  65.155   6.652  1.00  7.54           C  
ATOM    471  N   ASP A  68      46.076  60.861   4.418  1.00  6.63           N  
ATOM    472  CA  ASP A  68      46.274  59.616   5.165  1.00  7.05           C  
ATOM    473  C   ASP A  68      46.374  58.385   4.287  1.00  9.18           C  
ATOM    474  O   ASP A  68      46.639  57.287   4.797  1.00  7.85           O  
ATOM    475  CB  ASP A  68      45.173  59.455   6.220  1.00  7.68           C  
ATOM    476  CG  ASP A  68      45.180  60.572   7.247  1.00  6.89           C  
ATOM    477  OD1 ASP A  68      46.289  60.924   7.717  1.00  7.64           O  
ATOM    478  OD2 ASP A  68      44.082  61.086   7.593  1.00  6.50           O  
ATOM    479  N   TYR A  69      46.202  58.573   2.979  1.00  9.32           N  
ATOM    480  CA  TYR A  69      46.131  57.468   2.021  1.00 11.47           C  
ATOM    481  C   TYR A  69      47.022  57.628   0.786  1.00 12.87           C  
ATOM    482  O   TYR A  69      47.375  56.630   0.158  1.00 15.01           O  
ATOM    483  CB  TYR A  69      44.657  57.204   1.652  1.00 12.57           C  
ATOM    484  CG  TYR A  69      43.883  56.652   2.828  1.00 13.30           C  
ATOM    485  CD1 TYR A  69      43.851  55.276   3.064  1.00 14.89           C  
ATOM    486  CD2 TYR A  69      43.228  57.495   3.742  1.00 13.30           C  
ATOM    487  CE1 TYR A  69      43.189  54.760   4.146  1.00 15.28           C  
ATOM    488  CE2 TYR A  69      42.544  56.972   4.839  1.00 14.23           C  
ATOM    489  CZ  TYR A  69      42.529  55.591   5.030  1.00 15.88           C  
ATOM    490  OH  TYR A  69      41.873  55.055   6.126  1.00 18.62           O  
ATOM    491  N   GLY A  70      47.375  58.860   0.416  1.00 12.41           N  
ATOM    492  CA  GLY A  70      48.379  59.077  -0.643  1.00 12.77           C  
ATOM    493  C   GLY A  70      47.894  59.209  -2.075  1.00 13.80           C  
ATOM    494  O   GLY A  70      48.695  59.331  -3.016  1.00 15.56           O  
ATOM    495  N   ASN A  71      46.580  59.218  -2.254  1.00 11.91           N  
ATOM    496  CA  ASN A  71      45.975  59.358  -3.574  1.00 12.06           C  
ATOM    497  C   ASN A  71      45.402  60.742  -3.761  1.00 11.00           C  
ATOM    498  O   ASN A  71      45.207  61.486  -2.800  1.00  9.86           O  
ATOM    499  CB  ASN A  71      44.849  58.353  -3.766  1.00 13.54           C  
ATOM    500  CG  ASN A  71      43.673  58.644  -2.877  1.00 15.80           C  
ATOM    501  OD1 ASN A  71      43.845  58.803  -1.672  1.00 17.84           O  
ATOM    502  ND2 ASN A  71      42.465  58.710  -3.454  1.00 20.38           N  
ATOM    503  N   ARG A  72      45.092  61.048  -5.010  1.00 10.26           N  
ATOM    504  CA  ARG A  72      44.524  62.328  -5.383  1.00 10.82           C  
ATOM    505  C   ARG A  72      43.153  62.170  -6.020  1.00 11.23           C  
ATOM    506  O   ARG A  72      42.803  61.100  -6.546  1.00 12.12           O  
ATOM    507  CB  ARG A  72      45.483  63.051  -6.323  1.00 10.82           C  
ATOM    508  CG  ARG A  72      46.769  63.413  -5.652  1.00 11.43           C  
ATOM    509  CD  ARG A  72      47.809  64.009  -6.552  1.00 16.64           C  
ATOM    510  NE  ARG A  72      48.842  64.633  -5.731  1.00 20.12           N  
ATOM    511  CZ  ARG A  72      49.835  63.990  -5.120  1.00 22.27           C  
ATOM    512  NH1 ARG A  72      49.973  62.670  -5.240  1.00 21.85           N  
ATOM    513  NH2 ARG A  72      50.703  64.676  -4.387  1.00 24.71           N  
ATOM    514  N   GLU A  73      42.362  63.233  -5.944  1.00 10.61           N  
ATOM    515  CA  GLU A  73      41.067  63.262  -6.597  1.00 11.24           C  
ATOM    516  C   GLU A  73      40.753  64.684  -6.969  1.00 11.43           C  
ATOM    517  O   GLU A  73      41.204  65.611  -6.301  1.00 10.84           O  
ATOM    518  CB  GLU A  73      39.960  62.706  -5.678  1.00 10.72           C  
ATOM    519  CG  GLU A  73      38.623  62.493  -6.394  1.00 11.40           C  
ATOM    520  CD  GLU A  73      37.522  61.927  -5.495  1.00 12.76           C  
ATOM    521  OE1 GLU A  73      36.405  61.702  -5.991  1.00 14.44           O  
ATOM    522  OE2 GLU A  73      37.754  61.709  -4.291  1.00 14.95           O  
ATOM    523  N   VAL A  74      39.978  64.846  -8.042  1.00 11.98           N  
ATOM    524  CA  VAL A  74      39.432  66.132  -8.435  1.00 12.92           C  
ATOM    525  C   VAL A  74      37.957  66.094  -8.104  1.00 13.54           C  
ATOM    526  O   VAL A  74      37.211  65.245  -8.615  1.00 14.80           O  
ATOM    527  CB  VAL A  74      39.606  66.388  -9.940  1.00 12.80           C  
ATOM    528  CG1 VAL A  74      38.982  67.727 -10.305  1.00 13.58           C  
ATOM    529  CG2 VAL A  74      41.091  66.376 -10.313  1.00 12.51           C  
ATOM    530  N   LEU A  75      37.523  66.998  -7.233  1.00 13.44           N  
ATOM    531  CA  LEU A  75      36.133  66.980  -6.786  1.00 14.25           C  
ATOM    532  C   LEU A  75      35.535  68.370  -6.624  1.00 13.22           C  
ATOM    533  O   LEU A  75      36.259  69.357  -6.549  1.00 12.25           O  
ATOM    534  CB  LEU A  75      35.955  66.139  -5.511  1.00 15.99           C  
ATOM    535  CG  LEU A  75      37.083  65.929  -4.512  1.00 17.07           C  
ATOM    536  CD1 LEU A  75      37.680  67.267  -4.062  1.00 20.86           C  
ATOM    537  CD2 LEU A  75      36.615  65.105  -3.331  1.00 15.99           C  
ATOM    538  N   PRO A  76      34.199  68.451  -6.585  1.00 12.74           N  
ATOM    539  CA  PRO A  76      33.575  69.755  -6.465  1.00 12.92           C  
ATOM    540  C   PRO A  76      33.680  70.298  -5.031  1.00 13.41           C  
ATOM    541  O   PRO A  76      33.883  69.521  -4.095  1.00 12.87           O  
ATOM    542  CB  PRO A  76      32.120  69.476  -6.849  1.00 12.86           C  
ATOM    543  CG  PRO A  76      31.879  68.074  -6.421  1.00 14.03           C  
ATOM    544  CD  PRO A  76      33.206  67.359  -6.645  1.00 13.02           C  
ATOM    545  N   SER A  77      33.553  71.616  -4.877  1.00 14.51           N  
ATOM    546  CA  SER A  77      33.569  72.268  -3.567  1.00 15.00           C  
ATOM    547  C   SER A  77      32.529  71.702  -2.600  1.00 14.09           C  
ATOM    548  O   SER A  77      32.700  71.768  -1.377  1.00 13.74           O  
ATOM    549  CB  SER A  77      33.369  73.790  -3.715  1.00 16.06           C  
ATOM    550  OG  SER A  77      33.052  74.364  -2.458  1.00 22.19           O  
ATOM    551  N   THR A  78      31.441  71.159  -3.149  1.00 13.92           N  
ATOM    552  CA  THR A  78      30.345  70.637  -2.337  1.00 14.96           C  
ATOM    553  C   THR A  78      30.800  69.425  -1.515  1.00 13.76           C  
ATOM    554  O   THR A  78      30.239  69.146  -0.460  1.00 14.77           O  
ATOM    555  CB  THR A  78      29.104  70.268  -3.185  1.00 15.98           C  
ATOM    556  OG1 THR A  78      28.803  71.323  -4.107  1.00 19.42           O  
ATOM    557  CG2 THR A  78      27.895  70.069  -2.293  1.00 17.39           C  
ATOM    558  N   ARG A  79      31.840  68.736  -1.991  1.00 11.80           N  
ATOM    559  CA  ARG A  79      32.332  67.547  -1.310  1.00 11.23           C  
ATOM    560  C   ARG A  79      33.571  67.845  -0.470  1.00  9.42           C  
ATOM    561  O   ARG A  79      34.343  66.938  -0.136  1.00 10.11           O  
ATOM    562  CB  ARG A  79      32.614  66.442  -2.318  1.00 10.10           C  
ATOM    563  CG  ARG A  79      31.345  65.959  -3.003  1.00 12.61           C  
ATOM    564  CD  ARG A  79      31.624  64.840  -3.969  1.00 15.74           C  
ATOM    565  NE  ARG A  79      31.802  63.562  -3.279  1.00 17.57           N  
ATOM    566  CZ  ARG A  79      30.810  62.762  -2.899  1.00 17.11           C  
ATOM    567  NH1 ARG A  79      29.539  63.109  -3.110  1.00 17.10           N  
ATOM    568  NH2 ARG A  79      31.088  61.613  -2.285  1.00 16.38           N  
ATOM    569  N   LEU A  80      33.755  69.108  -0.129  1.00  8.73           N  
ATOM    570  CA  LEU A  80      34.845  69.515   0.752  1.00  8.38           C  
ATOM    571  C   LEU A  80      34.261  70.225   1.961  1.00  8.09           C  
ATOM    572  O   LEU A  80      33.244  70.878   1.880  1.00  9.50           O  
ATOM    573  CB  LEU A  80      35.848  70.430   0.037  1.00  8.40           C  
ATOM    574  CG  LEU A  80      36.490  69.894  -1.240  1.00  8.76           C  
ATOM    575  CD1 LEU A  80      37.350  70.968  -1.829  1.00 11.21           C  
ATOM    576  CD2 LEU A  80      37.339  68.658  -0.987  1.00 10.32           C  
ATOM    577  N   GLY A  81      34.935  70.124   3.093  1.00  6.58           N  
ATOM    578  CA  GLY A  81      34.503  70.810   4.295  1.00  7.37           C  
ATOM    579  C   GLY A  81      35.678  71.236   5.158  1.00  7.23           C  
ATOM    580  O   GLY A  81      36.818  70.878   4.886  1.00  8.53           O  
ATOM    581  N   THR A  82      35.388  71.995   6.216  1.00  7.85           N  
ATOM    582  CA  THR A  82      36.414  72.421   7.148  1.00  8.67           C  
ATOM    583  C   THR A  82      36.941  71.227   7.929  1.00  8.64           C  
ATOM    584  O   THR A  82      36.166  70.397   8.415  1.00  9.11           O  
ATOM    585  CB  THR A  82      35.848  73.465   8.139  1.00  8.03           C  
ATOM    586  OG1 THR A  82      35.445  74.632   7.399  1.00 10.15           O  
ATOM    587  CG2 THR A  82      36.885  73.891   9.170  1.00  9.85           C  
ATOM    588  N   LEU A  83      38.263  71.160   8.081  1.00  8.23           N  
ATOM    589  CA  LEU A  83      38.886  70.187   8.971  1.00  9.11           C  
ATOM    590  C   LEU A  83      38.934  70.776  10.375  1.00  9.64           C  
ATOM    591  O   LEU A  83      39.645  71.739  10.627  1.00 11.99           O  
ATOM    592  CB  LEU A  83      40.304  69.837   8.506  1.00  8.12           C  
ATOM    593  CG  LEU A  83      41.091  68.829   9.348  1.00  9.31           C  
ATOM    594  CD1 LEU A  83      40.337  67.500   9.403  1.00  7.70           C  
ATOM    595  CD2 LEU A  83      42.469  68.627   8.740  1.00  9.48           C  
ATOM    596  N   SER A  84      38.147  70.221  11.285  1.00 11.22           N  
ATOM    597  CA  SER A  84      38.137  70.746  12.652  1.00 11.88           C  
ATOM    598  C   SER A  84      39.482  70.572  13.316  1.00 12.27           C  
ATOM    599  O   SER A  84      40.183  69.600  13.042  1.00 10.46           O  
ATOM    600  CB  SER A  84      37.041  70.104  13.482  1.00 13.17           C  
ATOM    601  OG  SER A  84      36.936  68.731  13.211  1.00 19.63           O  
ATOM    602  N   PRO A  85      39.882  71.562  14.136  1.00 12.42           N  
ATOM    603  CA  PRO A  85      41.164  71.522  14.836  1.00 12.91           C  
ATOM    604  C   PRO A  85      41.420  70.214  15.607  1.00 12.58           C  
ATOM    605  O   PRO A  85      42.573  69.799  15.705  1.00 13.12           O  
ATOM    606  CB  PRO A  85      41.069  72.709  15.801  1.00 13.18           C  
ATOM    607  CG  PRO A  85      40.146  73.665  15.120  1.00 13.97           C  
ATOM    608  CD  PRO A  85      39.153  72.829  14.372  1.00 12.73           C  
ATOM    609  N   ALA A  86      40.367  69.580  16.125  1.00 12.52           N  
ATOM    610  CA  ALA A  86      40.480  68.330  16.896  1.00 12.25           C  
ATOM    611  C   ALA A  86      41.036  67.161  16.089  1.00 11.58           C  
ATOM    612  O   ALA A  86      41.477  66.167  16.666  1.00 12.16           O  
ATOM    613  CB  ALA A  86      39.133  67.956  17.511  1.00 12.44           C  
ATOM    614  N   PHE A  87      41.011  67.288  14.760  1.00 10.45           N  
ATOM    615  CA  PHE A  87      41.450  66.217  13.854  1.00  9.91           C  
ATOM    616  C   PHE A  87      42.523  66.670  12.885  1.00  9.11           C  
ATOM    617  O   PHE A  87      42.760  66.030  11.854  1.00  8.99           O  
ATOM    618  CB  PHE A  87      40.242  65.653  13.102  1.00  9.75           C  
ATOM    619  CG  PHE A  87      39.075  65.398  14.003  1.00 10.67           C  
ATOM    620  CD1 PHE A  87      39.146  64.431  15.006  1.00 12.63           C  
ATOM    621  CD2 PHE A  87      37.948  66.187  13.912  1.00 11.81           C  
ATOM    622  CE1 PHE A  87      38.079  64.238  15.888  1.00 13.02           C  
ATOM    623  CE2 PHE A  87      36.878  65.990  14.787  1.00 13.06           C  
ATOM    624  CZ  PHE A  87      36.954  65.011  15.765  1.00 13.42           C  
ATOM    625  N   SER A  88      43.176  67.776  13.241  1.00  9.50           N  
ATOM    626  CA  SER A  88      44.216  68.382  12.416  1.00  9.78           C  
ATOM    627  C   SER A  88      45.531  67.583  12.470  1.00  9.08           C  
ATOM    628  O   SER A  88      45.672  66.605  13.228  1.00  8.46           O  
ATOM    629  CB  SER A  88      44.476  69.802  12.898  1.00 10.33           C  
ATOM    630  OG  SER A  88      45.157  69.801  14.134  1.00 12.56           O  
ATOM    631  N   THR A  89      46.496  68.012  11.659  1.00  9.54           N  
ATOM    632  CA  THR A  89      47.812  67.391  11.644  1.00 10.48           C  
ATOM    633  C   THR A  89      48.643  67.729  12.874  1.00 11.01           C  
ATOM    634  O   THR A  89      49.691  67.122  13.097  1.00 11.02           O  
ATOM    635  CB  THR A  89      48.610  67.730  10.369  1.00 10.45           C  
ATOM    636  OG1 THR A  89      48.662  69.150  10.187  1.00 13.43           O  
ATOM    637  CG2 THR A  89      47.974  67.078   9.143  1.00 11.31           C  
ATOM    638  N   ARG A  90      48.175  68.689  13.666  1.00 10.98           N  
ATOM    639  CA  ARG A  90      48.756  68.929  14.989  1.00 11.79           C  
ATOM    640  C   ARG A  90      48.405  67.781  15.931  1.00 12.16           C  
ATOM    641  O   ARG A  90      49.142  67.494  16.864  1.00 14.09           O  
ATOM    642  CB  ARG A  90      48.254  70.272  15.563  1.00 12.18           C  
ATOM    643  N   VAL A  91      47.263  67.134  15.685  1.00 12.40           N  
ATOM    644  CA  VAL A  91      46.792  66.018  16.520  1.00 11.61           C  
ATOM    645  C   VAL A  91      47.375  64.671  16.065  1.00 11.55           C  
ATOM    646  O   VAL A  91      47.885  63.887  16.886  1.00 11.34           O  
ATOM    647  CB  VAL A  91      45.245  65.978  16.570  1.00 12.01           C  
ATOM    648  CG1 VAL A  91      44.751  64.754  17.344  1.00 11.38           C  
ATOM    649  CG2 VAL A  91      44.697  67.263  17.202  1.00 13.46           C  
ATOM    650  N   LEU A  92      47.287  64.389  14.770  1.00 10.49           N  
ATOM    651  CA  LEU A  92      47.930  63.213  14.199  1.00 10.13           C  
ATOM    652  C   LEU A  92      48.491  63.601  12.845  1.00 10.20           C  
ATOM    653  O   LEU A  92      47.742  64.076  12.000  1.00 10.43           O  
ATOM    654  CB  LEU A  92      46.936  62.052  14.033  1.00 10.47           C  
ATOM    655  CG  LEU A  92      47.477  60.728  13.478  1.00 10.62           C  
ATOM    656  CD1 LEU A  92      48.348  60.022  14.518  1.00 12.68           C  
ATOM    657  CD2 LEU A  92      46.311  59.868  13.040  1.00 12.44           C  
ATOM    658  N   PRO A  93      49.809  63.410  12.628  1.00 10.99           N  
ATOM    659  CA  PRO A  93      50.419  63.746  11.342  1.00 10.94           C  
ATOM    660  C   PRO A  93      49.792  62.964  10.165  1.00 10.31           C  
ATOM    661  O   PRO A  93      49.108  61.938  10.390  1.00 10.05           O  
ATOM    662  CB  PRO A  93      51.899  63.332  11.535  1.00 11.38           C  
ATOM    663  CG  PRO A  93      52.099  63.356  13.018  1.00 12.85           C  
ATOM    664  CD  PRO A  93      50.797  62.860  13.574  1.00 11.33           C  
ATOM    665  N   ALA A  94      50.003  63.462   8.943  1.00 10.77           N  
ATOM    666  CA  ALA A  94      49.577  62.770   7.706  1.00 10.61           C  
ATOM    667  C   ALA A  94      50.083  61.326   7.701  1.00 11.01           C  
ATOM    668  O   ALA A  94      51.282  61.091   7.911  1.00 11.18           O  
ATOM    669  CB  ALA A  94      50.097  63.504   6.479  1.00 10.59           C  
ATOM    670  N   GLN A  95      49.181  60.378   7.435  1.00 11.03           N  
ATOM    671  CA  GLN A  95      49.503  58.950   7.555  1.00 11.79           C  
ATOM    672  C   GLN A  95      49.777  58.254   6.218  1.00 12.79           C  
ATOM    673  O   GLN A  95      49.892  57.023   6.187  1.00 12.98           O  
ATOM    674  CB  GLN A  95      48.404  58.211   8.343  1.00 12.29           C  
ATOM    675  CG  GLN A  95      48.204  58.727   9.775  1.00 13.45           C  
ATOM    676  CD  GLN A  95      49.367  58.376  10.718  1.00 13.31           C  
ATOM    677  OE1 GLN A  95      50.062  59.263  11.252  1.00 14.52           O  
ATOM    678  NE2 GLN A  95      49.605  57.080  10.899  1.00 13.82           N  
ATOM    679  N   ALA A  96      49.889  59.003   5.117  1.00 13.37           N  
ATOM    680  CA  ALA A  96      50.096  58.356   3.812  1.00 14.24           C  
ATOM    681  C   ALA A  96      51.320  57.455   3.915  1.00 15.32           C  
ATOM    682  O   ALA A  96      52.325  57.856   4.500  1.00 16.13           O  
ATOM    683  CB  ALA A  96      50.243  59.379   2.697  1.00 14.07           C  
ATOM    684  N   THR A  97      51.199  56.230   3.388  1.00 16.22           N  
ATOM    685  CA  THR A  97      52.258  55.206   3.478  1.00 16.79           C  
ATOM    686  C   THR A  97      53.285  55.344   2.361  1.00 17.26           C  
ATOM    687  CB  THR A  97      51.706  53.741   3.465  1.00 17.23           C  
ATOM    688  OG1 THR A  97      51.262  53.360   2.147  1.00 19.66           O  
ATOM    689  CG2 THR A  97      50.566  53.574   4.456  1.00 17.25           C  
TER     690      THR A  97                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
