
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1508),  selected   92 , name 2ro0_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2ro0_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -2_A      E       1           -
LGA    S    -1_A      N       2           -
LGA    H     0_A      L       3           -
LGA    M     1_A      Y       4           -
LGA    S     2_A      F       5           -
LGA    H     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    K     6_A      -       -           -
LGA    E     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    K    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    I    15_A      -       -           -
LGA    N    16_A      -       -           -
LGA    S    17_A      -       -           -
LGA    V    18_A      Q       6          5.548
LGA    D    19_A      G       7          2.231
LGA    D    20_A      D       8          1.933
LGA    I    21_A      L       9          1.879
LGA    I    22_A      I      10          2.129
LGA    I    23_A      V      11          2.160
LGA    K    24_A      S      12          1.510
LGA    C    25_A      M      13          0.820
LGA    Q    26_A      R      14          1.263
LGA    C    27_A      I      15          0.459
LGA    W    28_A      L      16          0.206
LGA    V    29_A      G      17          0.830
LGA    Q    30_A      K      18          1.722
LGA    K    31_A      K      19          1.811
LGA    -       -      R      20           -
LGA    N    32_A      T      21          1.324
LGA    D    33_A      K      22          2.362
LGA    E    34_A      T      23          1.055
LGA    E    35_A      W      24          1.147
LGA    R    36_A      X      25          0.363
LGA    L    37_A      K      26          0.482
LGA    A    38_A      G      27          1.381
LGA    E    39_A      T      28          0.406
LGA    I    40_A      L      29          0.939
LGA    L    41_A      I      30          0.890
LGA    S    42_A      A      31          1.252
LGA    I    43_A      I      32          1.286
LGA    N    44_A      Q      33          0.704
LGA    T    45_A      T      34          2.019
LGA    R    46_A      V      35          2.152
LGA    K    47_A      G      36          3.834
LGA    A    48_A      P      37          2.799
LGA    P    49_A      G      38          3.368
LGA    P    50_A      K      39          0.775
LGA    K    51_A      K      40          0.966
LGA    F    52_A      Y      41          1.411
LGA    Y    53_A      K      42          1.085
LGA    V    54_A      V      43          0.759
LGA    H    55_A      K      44          0.478
LGA    Y    56_A      F      45          0.590
LGA    V    57_A      D      46          1.316
LGA    N    58_A      N      47          1.613
LGA    Y    59_A      K      48          2.007
LGA    N    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    R    62_A      -       -           -
LGA    L    63_A      G      49          1.343
LGA    D    64_A      K      50          0.552
LGA    E    65_A      S      51          2.090
LGA    W    66_A      L      52          1.282
LGA    I    67_A      L      53          0.832
LGA    T    68_A      S      54          0.958
LGA    T    69_A      G      55          0.602
LGA    D    70_A      N      56          1.476
LGA    R    71_A      X      57          1.008
LGA    I    72_A      I      58          1.089
LGA    N    73_A      A      59          1.562
LGA    L    74_A      Y      60          4.048
LGA    D    75_A      -       -           -
LGA    K    76_A      D      61          3.237
LGA    E    77_A      Y      62          1.510
LGA    V    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    Y    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    A    85_A      -       -           -
LGA    T    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    D    89_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   62    5.0     56    1.81    16.07     82.371     2.925

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.996347 * X  +  -0.059466 * Y  +  -0.061291 * Z  +  35.804203
  Y_new =  -0.038392 * X  +  -0.953000 * Y  +   0.300529 * Z  +  92.280800
  Z_new =  -0.076282 * X  +  -0.297078 * Y  +  -0.951801 * Z  +  24.358791 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.839052    0.302540  [ DEG:  -162.6657     17.3343 ]
  Theta =   0.076356    3.065237  [ DEG:     4.3749    175.6251 ]
  Phi   =  -0.038513    3.103079  [ DEG:    -2.2067    177.7933 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ro0_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ro0_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   62   5.0   56   1.81   16.07  82.371
REMARK  ---------------------------------------------------------- 
MOLECULE 2ro0_A
HEADER    TRANSFERASE                             01-MAR-08   2RO0              
TITLE     SOLUTION STRUCTURE OF THE KNOTTED TUDOR DOMAIN OF THE YEAST           
TITLE    2 HISTONE ACETYLTRANSFERASE, ESA1                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE ACETYLTRANSFERASE ESA1;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-89;                                             
COMPND   5 EC: 2.3.1.48;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 GENUS: SACCHAROMYCES;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_GENUS: ESCHERICHIA;                                
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    ESA1, HAT, CHROMODOMAIN, TUDOR DOMAIN, RNA BINDING,                   
KEYWDS   2 ACTIVATOR, CHROMATIN REGULATOR, TRANSCRIPTION,                       
KEYWDS   3 TRANSCRIPTION REGULATION, TRANSFERASE                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,Y.NISHIMURA           
REVDAT   2   03-JUN-08 2RO0    1       JRNL                                     
REVDAT   1   29-APR-08 2RO0    0                                                
JRNL        AUTH   H.SHIMOJO,N.SANO,Y.MORIWAKI,M.OKUDA,M.HORIKOSHI,             
JRNL        AUTH 2 Y.NISHIMURA                                                  
JRNL        TITL   NOVEL STRUCTURAL AND FUNCTIONAL MODE OF A KNOT               
JRNL        TITL 2 ESSENTIAL FOR RNA BINDING ACTIVITY OF THE ESA1               
JRNL        TITL 3 PRESUMED CHROMODOMAIN                                        
JRNL        REF    J.MOL.BIOL.                   V. 378   987 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2RO0 A    1    89  UNP    Q08649   ESA1_YEAST       1     89             
SEQRES   1 A   92  GLY SER HIS MET SER HIS ASP GLY LYS GLU GLU PRO GLY          
SEQRES   2 A   92  ILE ALA LYS LYS ILE ASN SER VAL ASP ASP ILE ILE ILE          
SEQRES   3 A   92  LYS CYS GLN CYS TRP VAL GLN LYS ASN ASP GLU GLU ARG          
SEQRES   4 A   92  LEU ALA GLU ILE LEU SER ILE ASN THR ARG LYS ALA PRO          
SEQRES   5 A   92  PRO LYS PHE TYR VAL HIS TYR VAL ASN TYR ASN LYS ARG          
SEQRES   6 A   92  LEU ASP GLU TRP ILE THR THR ASP ARG ILE ASN LEU ASP          
SEQRES   7 A   92  LYS GLU VAL LEU TYR PRO LYS LEU LYS ALA THR ASP GLU          
SEQRES   8 A   92  ASP                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  -2      37.129  92.230  24.257  1.00  0.00           N  
ATOM      2  CA  GLY A  -2      37.944  91.826  25.387  1.00  0.00           C  
ATOM      3  C   GLY A  -2      39.380  91.539  24.994  1.00  0.00           C  
ATOM      4  O   GLY A  -2      39.635  90.888  23.981  1.00  0.00           O  
ATOM      5  H1  GLY A  -2      37.556  92.469  23.408  1.00  0.00           H  
ATOM      6  HA2 GLY A  -2      37.934  92.614  26.125  1.00  0.00           H  
ATOM      7  HA3 GLY A  -2      37.518  90.933  25.823  1.00  0.00           H  
ATOM      8  N   SER A  -1      40.321  92.029  25.795  1.00  0.00           N  
ATOM      9  CA  SER A  -1      41.739  91.826  25.522  1.00  0.00           C  
ATOM     10  C   SER A  -1      42.506  91.546  26.811  1.00  0.00           C  
ATOM     11  O   SER A  -1      42.174  92.077  27.872  1.00  0.00           O  
ATOM     12  CB  SER A  -1      42.325  93.053  24.822  1.00  0.00           C  
ATOM     13  OG  SER A  -1      41.438  93.550  23.836  1.00  0.00           O  
ATOM     14  H   SER A  -1      40.055  92.540  26.588  1.00  0.00           H  
ATOM     15  HA  SER A  -1      41.832  90.970  24.869  1.00  0.00           H  
ATOM     16  HB2 SER A  -1      42.505  93.828  25.551  1.00  0.00           H  
ATOM     17  HB3 SER A  -1      43.257  92.782  24.347  1.00  0.00           H  
ATOM     18  HG  SER A  -1      41.131  94.423  24.092  1.00  0.00           H  
ATOM     19  N   HIS A   0      43.534  90.709  26.711  1.00  0.00           N  
ATOM     20  CA  HIS A   0      44.349  90.359  27.869  1.00  0.00           C  
ATOM     21  C   HIS A   0      45.797  90.107  27.456  1.00  0.00           C  
ATOM     22  O   HIS A   0      46.143  90.200  26.279  1.00  0.00           O  
ATOM     23  CB  HIS A   0      43.783  89.121  28.563  1.00  0.00           C  
ATOM     24  CG  HIS A   0      42.359  89.279  29.001  1.00  0.00           C  
ATOM     25  ND1 HIS A   0      41.291  88.782  28.284  1.00  0.00           N  
ATOM     26  CD2 HIS A   0      41.830  89.882  30.092  1.00  0.00           C  
ATOM     27  CE1 HIS A   0      40.166  89.075  28.913  1.00  0.00           C  
ATOM     28  NE2 HIS A   0      40.467  89.741  30.014  1.00  0.00           N  
ATOM     29  H   HIS A   0      43.749  90.319  25.838  1.00  0.00           H  
ATOM     30  HA  HIS A   0      44.324  91.190  28.556  1.00  0.00           H  
ATOM     31  HB2 HIS A   0      43.828  88.283  27.883  1.00  0.00           H  
ATOM     32  HB3 HIS A   0      44.377  88.901  29.438  1.00  0.00           H  
ATOM     33  HD1 HIS A   0      41.348  88.291  27.438  1.00  0.00           H  
ATOM     34  HD2 HIS A   0      42.379  90.382  30.877  1.00  0.00           H  
ATOM     35  HE1 HIS A   0      39.172  88.813  28.586  1.00  0.00           H  
ATOM     36  N   MET A   1      46.639  89.791  28.435  1.00  0.00           N  
ATOM     37  CA  MET A   1      48.049  89.526  28.173  1.00  0.00           C  
ATOM     38  C   MET A   1      48.216  88.299  27.281  1.00  0.00           C  
ATOM     39  O   MET A   1      48.052  87.166  27.733  1.00  0.00           O  
ATOM     40  CB  MET A   1      48.804  89.322  29.488  1.00  0.00           C  
ATOM     41  CG  MET A   1      48.890  90.578  30.340  1.00  0.00           C  
ATOM     42  SD  MET A   1      49.898  90.346  31.817  1.00  0.00           S  
ATOM     43  CE  MET A   1      48.929  89.128  32.702  1.00  0.00           C  
ATOM     44  H   MET A   1      46.305  89.733  29.354  1.00  0.00           H  
ATOM     45  HA  MET A   1      48.458  90.385  27.663  1.00  0.00           H  
ATOM     46  HB2 MET A   1      48.304  88.556  30.061  1.00  0.00           H  
ATOM     47  HB3 MET A   1      49.809  88.995  29.265  1.00  0.00           H  
ATOM     48  HG2 MET A   1      49.323  91.370  29.748  1.00  0.00           H  
ATOM     49  HG3 MET A   1      47.892  90.859  30.643  1.00  0.00           H  
ATOM     50  HE1 MET A   1      47.877  89.337  32.567  1.00  0.00           H  
ATOM     51  HE2 MET A   1      49.150  88.143  32.319  1.00  0.00           H  
ATOM     52  HE3 MET A   1      49.171  89.169  33.753  1.00  0.00           H  
ATOM     53  N   SER A   2      48.541  88.533  26.015  1.00  0.00           N  
ATOM     54  CA  SER A   2      48.725  87.447  25.059  1.00  0.00           C  
ATOM     55  C   SER A   2      50.208  87.187  24.812  1.00  0.00           C  
ATOM     56  O   SER A   2      50.825  87.812  23.949  1.00  0.00           O  
ATOM     57  CB  SER A   2      48.028  87.778  23.738  1.00  0.00           C  
ATOM     58  OG  SER A   2      46.689  88.188  23.957  1.00  0.00           O  
ATOM     59  H   SER A   2      48.657  89.460  25.715  1.00  0.00           H  
ATOM     60  HA  SER A   2      48.281  86.558  25.479  1.00  0.00           H  
ATOM     61  HB2 SER A   2      48.559  88.576  23.243  1.00  0.00           H  
ATOM     62  HB3 SER A   2      48.024  86.901  23.107  1.00  0.00           H  
ATOM     63  HG  SER A   2      46.221  87.506  24.445  1.00  0.00           H  
ATOM     64  N   HIS A   3      50.775  86.259  25.577  1.00  0.00           N  
ATOM     65  CA  HIS A   3      52.185  85.914  25.441  1.00  0.00           C  
ATOM     66  C   HIS A   3      52.388  84.879  24.339  1.00  0.00           C  
ATOM     67  O   HIS A   3      51.425  84.387  23.751  1.00  0.00           O  
ATOM     68  CB  HIS A   3      52.730  85.378  26.766  1.00  0.00           C  
ATOM     69  CG  HIS A   3      52.597  86.344  27.903  1.00  0.00           C  
ATOM     70  ND1 HIS A   3      52.334  85.951  29.199  1.00  0.00           N  
ATOM     71  CD2 HIS A   3      52.693  87.694  27.933  1.00  0.00           C  
ATOM     72  CE1 HIS A   3      52.273  87.016  29.976  1.00  0.00           C  
ATOM     73  NE2 HIS A   3      52.489  88.088  29.233  1.00  0.00           N  
ATOM     74  H   HIS A   3      50.231  85.794  26.246  1.00  0.00           H  
ATOM     75  HA  HIS A   3      52.723  86.812  25.179  1.00  0.00           H  
ATOM     76  HB2 HIS A   3      52.193  84.479  27.031  1.00  0.00           H  
ATOM     77  HB3 HIS A   3      53.779  85.144  26.649  1.00  0.00           H  
ATOM     78  HD1 HIS A   3      52.209  85.028  29.501  1.00  0.00           H  
ATOM     79  HD2 HIS A   3      52.895  88.342  27.092  1.00  0.00           H  
ATOM     80  HE1 HIS A   3      52.081  87.014  31.038  1.00  0.00           H  
ATOM     81  N   ASP A   4      53.647  84.554  24.064  1.00  0.00           N  
ATOM     82  CA  ASP A   4      53.976  83.577  23.031  1.00  0.00           C  
ATOM     83  C   ASP A   4      54.531  82.298  23.651  1.00  0.00           C  
ATOM     84  O   ASP A   4      53.939  81.228  23.523  1.00  0.00           O  
ATOM     85  CB  ASP A   4      54.991  84.165  22.050  1.00  0.00           C  
ATOM     86  CG  ASP A   4      54.416  85.311  21.240  1.00  0.00           C  
ATOM     87  OD1 ASP A   4      53.831  85.046  20.169  1.00  0.00           O  
ATOM     88  OD2 ASP A   4      54.551  86.473  21.677  1.00  0.00           O  
ATOM     89  H   ASP A   4      54.372  84.980  24.568  1.00  0.00           H  
ATOM     90  HA  ASP A   4      53.069  83.340  22.498  1.00  0.00           H  
ATOM     91  HB2 ASP A   4      55.845  84.531  22.600  1.00  0.00           H  
ATOM     92  HB3 ASP A   4      55.312  83.392  21.368  1.00  0.00           H  
ATOM     93  N   GLY A   5      55.673  82.419  24.321  1.00  0.00           N  
ATOM     94  CA  GLY A   5      56.290  81.264  24.949  1.00  0.00           C  
ATOM     95  C   GLY A   5      56.851  80.286  23.937  1.00  0.00           C  
ATOM     96  O   GLY A   5      57.873  80.553  23.303  1.00  0.00           O  
ATOM     97  H   GLY A   5      56.101  83.298  24.390  1.00  0.00           H  
ATOM     98  HA2 GLY A   5      57.090  81.601  25.590  1.00  0.00           H  
ATOM     99  HA3 GLY A   5      55.550  80.757  25.550  1.00  0.00           H  
ATOM    100  N   LYS A   6      56.186  79.146  23.785  1.00  0.00           N  
ATOM    101  CA  LYS A   6      56.623  78.122  22.844  1.00  0.00           C  
ATOM    102  C   LYS A   6      55.428  77.463  22.162  1.00  0.00           C  
ATOM    103  O   LYS A   6      55.058  76.337  22.493  1.00  0.00           O  
ATOM    104  CB  LYS A   6      57.462  77.064  23.563  1.00  0.00           C  
ATOM    105  CG  LYS A   6      58.947  77.383  23.595  1.00  0.00           C  
ATOM    106  CD  LYS A   6      59.789  76.119  23.594  1.00  0.00           C  
ATOM    107  CE  LYS A   6      61.167  76.369  23.002  1.00  0.00           C  
ATOM    108  NZ  LYS A   6      62.086  75.219  23.231  1.00  0.00           N  
ATOM    109  H   LYS A   6      55.377  78.990  24.319  1.00  0.00           H  
ATOM    110  HA  LYS A   6      57.232  78.602  22.091  1.00  0.00           H  
ATOM    111  HB2 LYS A   6      57.111  76.974  24.581  1.00  0.00           H  
ATOM    112  HB3 LYS A   6      57.330  76.115  23.062  1.00  0.00           H  
ATOM    113  HG2 LYS A   6      59.199  77.972  22.726  1.00  0.00           H  
ATOM    114  HG3 LYS A   6      59.164  77.949  24.491  1.00  0.00           H  
ATOM    115  HD2 LYS A   6      59.905  75.771  24.610  1.00  0.00           H  
ATOM    116  HD3 LYS A   6      59.286  75.363  23.008  1.00  0.00           H  
ATOM    117  HE2 LYS A   6      61.065  76.530  21.940  1.00  0.00           H  
ATOM    118  HE3 LYS A   6      61.588  77.251  23.461  1.00  0.00           H  
ATOM    119  HZ1 LYS A   6      62.669  75.390  24.075  1.00  0.00           H  
ATOM    120  HZ2 LYS A   6      62.712  75.093  22.410  1.00  0.00           H  
ATOM    121  HZ3 LYS A   6      61.538  74.347  23.372  1.00  0.00           H  
ATOM    122  N   GLU A   7      54.832  78.171  21.208  1.00  0.00           N  
ATOM    123  CA  GLU A   7      53.679  77.652  20.481  1.00  0.00           C  
ATOM    124  C   GLU A   7      54.103  77.071  19.134  1.00  0.00           C  
ATOM    125  O   GLU A   7      55.200  77.341  18.649  1.00  0.00           O  
ATOM    126  CB  GLU A   7      52.643  78.758  20.269  1.00  0.00           C  
ATOM    127  CG  GLU A   7      53.052  79.784  19.226  1.00  0.00           C  
ATOM    128  CD  GLU A   7      52.215  81.048  19.291  1.00  0.00           C  
ATOM    129  OE1 GLU A   7      51.800  81.427  20.405  1.00  0.00           O  
ATOM    130  OE2 GLU A   7      51.978  81.656  18.226  1.00  0.00           O  
ATOM    131  H   GLU A   7      55.173  79.063  20.990  1.00  0.00           H  
ATOM    132  HA  GLU A   7      53.238  76.867  21.076  1.00  0.00           H  
ATOM    133  HB2 GLU A   7      51.713  78.307  19.955  1.00  0.00           H  
ATOM    134  HB3 GLU A   7      52.485  79.271  21.206  1.00  0.00           H  
ATOM    135  HG2 GLU A   7      54.087  80.047  19.385  1.00  0.00           H  
ATOM    136  HG3 GLU A   7      52.940  79.346  18.245  1.00  0.00           H  
ATOM    137  N   GLU A   8      53.222  76.273  18.539  1.00  0.00           N  
ATOM    138  CA  GLU A   8      53.505  75.653  17.250  1.00  0.00           C  
ATOM    139  C   GLU A   8      52.640  76.262  16.151  1.00  0.00           C  
ATOM    140  O   GLU A   8      51.611  76.887  16.410  1.00  0.00           O  
ATOM    141  CB  GLU A   8      53.269  74.142  17.322  1.00  0.00           C  
ATOM    142  CG  GLU A   8      54.538  73.337  17.546  1.00  0.00           C  
ATOM    143  CD  GLU A   8      55.451  73.964  18.581  1.00  0.00           C  
ATOM    144  OE1 GLU A   8      54.949  74.350  19.658  1.00  0.00           O  
ATOM    145  OE2 GLU A   8      56.666  74.068  18.317  1.00  0.00           O  
ATOM    146  H   GLU A   8      52.364  76.095  18.976  1.00  0.00           H  
ATOM    147  HA  GLU A   8      54.543  75.833  17.015  1.00  0.00           H  
ATOM    148  HB2 GLU A   8      52.587  73.936  18.134  1.00  0.00           H  
ATOM    149  HB3 GLU A   8      52.819  73.816  16.396  1.00  0.00           H  
ATOM    150  HG2 GLU A   8      54.266  72.347  17.880  1.00  0.00           H  
ATOM    151  HG3 GLU A   8      55.073  73.266  16.611  1.00  0.00           H  
ATOM    152  N   PRO A   9      53.065  76.078  14.892  1.00  0.00           N  
ATOM    153  CA  PRO A   9      52.345  76.601  13.728  1.00  0.00           C  
ATOM    154  C   PRO A   9      51.023  75.879  13.491  1.00  0.00           C  
ATOM    155  O   PRO A   9      50.630  75.011  14.271  1.00  0.00           O  
ATOM    156  CB  PRO A   9      53.310  76.345  12.569  1.00  0.00           C  
ATOM    157  CG  PRO A   9      54.146  75.198  13.018  1.00  0.00           C  
ATOM    158  CD  PRO A   9      54.283  75.344  14.509  1.00  0.00           C  
ATOM    159  HA  PRO A   9      52.162  77.662  13.819  1.00  0.00           H  
ATOM    160  HB2 PRO A   9      52.750  76.101  11.677  1.00  0.00           H  
ATOM    161  HB3 PRO A   9      53.910  77.225  12.393  1.00  0.00           H  
ATOM    162  HG2 PRO A   9      53.655  74.268  12.776  1.00  0.00           H  
ATOM    163  HG3 PRO A   9      55.118  75.245  12.547  1.00  0.00           H  
ATOM    164  HD2 PRO A   9      54.314  74.373  14.982  1.00  0.00           H  
ATOM    165  HD3 PRO A   9      55.168  75.913  14.753  1.00  0.00           H  
ATOM    166  N   GLY A  10      50.342  76.240  12.408  1.00  0.00           N  
ATOM    167  CA  GLY A  10      49.072  75.615  12.088  1.00  0.00           C  
ATOM    168  C   GLY A  10      47.887  76.421  12.582  1.00  0.00           C  
ATOM    169  O   GLY A  10      47.688  76.568  13.789  1.00  0.00           O  
ATOM    170  H   GLY A  10      50.703  76.937  11.822  1.00  0.00           H  
ATOM    171  HA2 GLY A  10      48.997  75.505  11.016  1.00  0.00           H  
ATOM    172  HA3 GLY A  10      49.041  74.636  12.543  1.00  0.00           H  
ATOM    173  N   ILE A  11      47.100  76.947  11.650  1.00  0.00           N  
ATOM    174  CA  ILE A  11      45.930  77.744  11.998  1.00  0.00           C  
ATOM    175  C   ILE A  11      44.641  77.004  11.660  1.00  0.00           C  
ATOM    176  O   ILE A  11      44.436  76.581  10.522  1.00  0.00           O  
ATOM    177  CB  ILE A  11      45.937  79.101  11.270  1.00  0.00           C  
ATOM    178  CG1 ILE A  11      47.247  79.843  11.537  1.00  0.00           C  
ATOM    179  CG2 ILE A  11      44.747  79.941  11.708  1.00  0.00           C  
ATOM    180  CD1 ILE A  11      48.317  79.572  10.504  1.00  0.00           C  
ATOM    181  H   ILE A  11      47.312  76.796  10.706  1.00  0.00           H  
ATOM    182  HA  ILE A  11      45.959  77.929  13.062  1.00  0.00           H  
ATOM    183  HB  ILE A  11      45.845  78.916  10.210  1.00  0.00           H  
ATOM    184 HG12 ILE A  11      47.058  80.905  11.548  1.00  0.00           H  
ATOM    185 HG13 ILE A  11      47.633  79.541  12.502  1.00  0.00           H  
ATOM    186 HG21 ILE A  11      44.017  79.975  10.912  1.00  0.00           H  
ATOM    187 HG22 ILE A  11      44.300  79.502  12.586  1.00  0.00           H  
ATOM    188 HG23 ILE A  11      45.078  80.944  11.933  1.00  0.00           H  
ATOM    189 HD11 ILE A  11      47.860  79.177   9.607  1.00  0.00           H  
ATOM    190 HD12 ILE A  11      48.832  80.492  10.268  1.00  0.00           H  
ATOM    191 HD13 ILE A  11      49.022  78.853  10.893  1.00  0.00           H  
ATOM    192  N   ALA A  12      43.774  76.852  12.655  1.00  0.00           N  
ATOM    193  CA  ALA A  12      42.503  76.166  12.462  1.00  0.00           C  
ATOM    194  C   ALA A  12      41.345  77.158  12.419  1.00  0.00           C  
ATOM    195  O   ALA A  12      41.023  77.796  13.422  1.00  0.00           O  
ATOM    196  CB  ALA A  12      42.282  75.142  13.566  1.00  0.00           C  
ATOM    197  H   ALA A  12      43.994  77.211  13.539  1.00  0.00           H  
ATOM    198  HA  ALA A  12      42.547  75.639  11.519  1.00  0.00           H  
ATOM    199  HB1 ALA A  12      42.961  74.313  13.428  1.00  0.00           H  
ATOM    200  HB2 ALA A  12      42.466  75.602  14.525  1.00  0.00           H  
ATOM    201  HB3 ALA A  12      41.264  74.785  13.527  1.00  0.00           H  
ATOM    202  N   LYS A  13      40.723  77.284  11.252  1.00  0.00           N  
ATOM    203  CA  LYS A  13      39.599  78.198  11.078  1.00  0.00           C  
ATOM    204  C   LYS A  13      38.490  77.545  10.259  1.00  0.00           C  
ATOM    205  O   LYS A  13      38.756  76.780   9.332  1.00  0.00           O  
ATOM    206  CB  LYS A  13      40.065  79.484  10.392  1.00  0.00           C  
ATOM    207  CG  LYS A  13      40.293  79.330   8.898  1.00  0.00           C  
ATOM    208  CD  LYS A  13      40.785  80.624   8.273  1.00  0.00           C  
ATOM    209  CE  LYS A  13      42.206  80.949   8.709  1.00  0.00           C  
ATOM    210  NZ  LYS A  13      42.230  81.881   9.869  1.00  0.00           N  
ATOM    211  H   LYS A  13      41.026  76.748  10.489  1.00  0.00           H  
ATOM    212  HA  LYS A  13      39.214  78.440  12.056  1.00  0.00           H  
ATOM    213  HB2 LYS A  13      39.317  80.249  10.544  1.00  0.00           H  
ATOM    214  HB3 LYS A  13      40.991  79.805  10.845  1.00  0.00           H  
ATOM    215  HG2 LYS A  13      41.033  78.560   8.735  1.00  0.00           H  
ATOM    216  HG3 LYS A  13      39.363  79.044   8.429  1.00  0.00           H  
ATOM    217  HD2 LYS A  13      40.765  80.525   7.197  1.00  0.00           H  
ATOM    218  HD3 LYS A  13      40.131  81.431   8.574  1.00  0.00           H  
ATOM    219  HE2 LYS A  13      42.702  80.031   8.984  1.00  0.00           H  
ATOM    220  HE3 LYS A  13      42.727  81.406   7.880  1.00  0.00           H  
ATOM    221  HZ1 LYS A  13      42.689  81.426  10.683  1.00  0.00           H  
ATOM    222  HZ2 LYS A  13      41.259  82.145  10.136  1.00  0.00           H  
ATOM    223  HZ3 LYS A  13      42.757  82.743   9.625  1.00  0.00           H  
ATOM    224  N   LYS A  14      37.246  77.854  10.607  1.00  0.00           N  
ATOM    225  CA  LYS A  14      36.094  77.302   9.904  1.00  0.00           C  
ATOM    226  C   LYS A  14      35.542  78.302   8.893  1.00  0.00           C  
ATOM    227  O   LYS A  14      35.119  79.399   9.260  1.00  0.00           O  
ATOM    228  CB  LYS A  14      35.001  76.911  10.900  1.00  0.00           C  
ATOM    229  CG  LYS A  14      34.885  75.412  11.121  1.00  0.00           C  
ATOM    230  CD  LYS A  14      33.637  75.060  11.911  1.00  0.00           C  
ATOM    231  CE  LYS A  14      33.913  75.036  13.407  1.00  0.00           C  
ATOM    232  NZ  LYS A  14      34.266  73.670  13.884  1.00  0.00           N  
ATOM    233  H   LYS A  14      37.097  78.471  11.356  1.00  0.00           H  
ATOM    234  HA  LYS A  14      36.421  76.418   9.376  1.00  0.00           H  
ATOM    235  HB2 LYS A  14      35.213  77.378  11.851  1.00  0.00           H  
ATOM    236  HB3 LYS A  14      34.050  77.274  10.535  1.00  0.00           H  
ATOM    237  HG2 LYS A  14      34.841  74.919  10.161  1.00  0.00           H  
ATOM    238  HG3 LYS A  14      35.754  75.070  11.665  1.00  0.00           H  
ATOM    239  HD2 LYS A  14      32.873  75.796  11.710  1.00  0.00           H  
ATOM    240  HD3 LYS A  14      33.289  74.083  11.603  1.00  0.00           H  
ATOM    241  HE2 LYS A  14      34.733  75.705  13.619  1.00  0.00           H  
ATOM    242  HE3 LYS A  14      33.029  75.373  13.929  1.00  0.00           H  
ATOM    243  HZ1 LYS A  14      35.172  73.693  14.395  1.00  0.00           H  
ATOM    244  HZ2 LYS A  14      34.352  73.021  13.076  1.00  0.00           H  
ATOM    245  HZ3 LYS A  14      33.528  73.313  14.524  1.00  0.00           H  
ATOM    246  N   ILE A  15      35.547  77.916   7.622  1.00  0.00           N  
ATOM    247  CA  ILE A  15      35.043  78.778   6.560  1.00  0.00           C  
ATOM    248  C   ILE A  15      33.720  78.257   6.009  1.00  0.00           C  
ATOM    249  O   ILE A  15      33.232  77.209   6.428  1.00  0.00           O  
ATOM    250  CB  ILE A  15      36.056  78.899   5.405  1.00  0.00           C  
ATOM    251  CG1 ILE A  15      36.270  77.537   4.742  1.00  0.00           C  
ATOM    252  CG2 ILE A  15      37.375  79.460   5.915  1.00  0.00           C  
ATOM    253  CD1 ILE A  15      37.136  77.598   3.503  1.00  0.00           C  
ATOM    254  H   ILE A  15      35.897  77.030   7.393  1.00  0.00           H  
ATOM    255  HA  ILE A  15      34.885  79.762   6.977  1.00  0.00           H  
ATOM    256  HB  ILE A  15      35.657  79.587   4.676  1.00  0.00           H  
ATOM    257 HG12 ILE A  15      36.746  76.872   5.446  1.00  0.00           H  
ATOM    258 HG13 ILE A  15      35.312  77.128   4.459  1.00  0.00           H  
ATOM    259 HG21 ILE A  15      37.718  78.870   6.752  1.00  0.00           H  
ATOM    260 HG22 ILE A  15      38.110  79.424   5.124  1.00  0.00           H  
ATOM    261 HG23 ILE A  15      37.235  80.483   6.229  1.00  0.00           H  
ATOM    262 HD11 ILE A  15      36.609  77.148   2.673  1.00  0.00           H  
ATOM    263 HD12 ILE A  15      37.359  78.629   3.269  1.00  0.00           H  
ATOM    264 HD13 ILE A  15      38.056  77.061   3.678  1.00  0.00           H  
ATOM    265  N   ASN A  16      33.147  78.996   5.065  1.00  0.00           N  
ATOM    266  CA  ASN A  16      31.881  78.608   4.455  1.00  0.00           C  
ATOM    267  C   ASN A  16      31.895  78.880   2.953  1.00  0.00           C  
ATOM    268  O   ASN A  16      30.850  78.873   2.302  1.00  0.00           O  
ATOM    269  CB  ASN A  16      30.722  79.362   5.110  1.00  0.00           C  
ATOM    270  CG  ASN A  16      30.206  78.663   6.353  1.00  0.00           C  
ATOM    271  OD1 ASN A  16      30.349  79.167   7.467  1.00  0.00           O  
ATOM    272  ND2 ASN A  16      29.603  77.495   6.167  1.00  0.00           N  
ATOM    273  H   ASN A  16      33.585  79.822   4.772  1.00  0.00           H  
ATOM    274  HA  ASN A  16      31.746  77.549   4.616  1.00  0.00           H  
ATOM    275  HB2 ASN A  16      31.057  80.351   5.390  1.00  0.00           H  
ATOM    276  HB3 ASN A  16      29.910  79.448   4.404  1.00  0.00           H  
ATOM    277 HD21 ASN A  16      29.525  77.154   5.251  1.00  0.00           H  
ATOM    278 HD22 ASN A  16      29.259  77.021   6.953  1.00  0.00           H  
ATOM    279  N   SER A  17      33.085  79.118   2.412  1.00  0.00           N  
ATOM    280  CA  SER A  17      33.234  79.395   0.987  1.00  0.00           C  
ATOM    281  C   SER A  17      34.477  78.708   0.429  1.00  0.00           C  
ATOM    282  O   SER A  17      35.573  78.844   0.973  1.00  0.00           O  
ATOM    283  CB  SER A  17      33.319  80.903   0.747  1.00  0.00           C  
ATOM    284  OG  SER A  17      32.410  81.605   1.576  1.00  0.00           O  
ATOM    285  H   SER A  17      33.880  79.109   2.984  1.00  0.00           H  
ATOM    286  HA  SER A  17      32.364  79.007   0.481  1.00  0.00           H  
ATOM    287  HB2 SER A  17      34.320  81.244   0.962  1.00  0.00           H  
ATOM    288  HB3 SER A  17      33.082  81.114  -0.286  1.00  0.00           H  
ATOM    289  HG  SER A  17      31.511  81.421   1.294  1.00  0.00           H  
ATOM    290  N   VAL A  18      34.297  77.970  -0.663  1.00  0.00           N  
ATOM    291  CA  VAL A  18      35.402  77.263  -1.298  1.00  0.00           C  
ATOM    292  C   VAL A  18      36.359  78.235  -1.977  1.00  0.00           C  
ATOM    293  O   VAL A  18      37.489  77.878  -2.311  1.00  0.00           O  
ATOM    294  CB  VAL A  18      34.894  76.248  -2.339  1.00  0.00           C  
ATOM    295  CG1 VAL A  18      33.888  75.296  -1.711  1.00  0.00           C  
ATOM    296  CG2 VAL A  18      34.285  76.969  -3.532  1.00  0.00           C  
ATOM    297  H   VAL A  18      33.399  77.901  -1.050  1.00  0.00           H  
ATOM    298  HA  VAL A  18      35.937  76.722  -0.531  1.00  0.00           H  
ATOM    299  HB  VAL A  18      35.736  75.668  -2.687  1.00  0.00           H  
ATOM    300 HG11 VAL A  18      34.380  74.695  -0.960  1.00  0.00           H  
ATOM    301 HG12 VAL A  18      33.091  75.864  -1.252  1.00  0.00           H  
ATOM    302 HG13 VAL A  18      33.477  74.651  -2.474  1.00  0.00           H  
ATOM    303 HG21 VAL A  18      33.667  76.282  -4.092  1.00  0.00           H  
ATOM    304 HG22 VAL A  18      33.681  77.794  -3.183  1.00  0.00           H  
ATOM    305 HG23 VAL A  18      35.074  77.344  -4.168  1.00  0.00           H  
ATOM    306  N   ASP A  19      35.900  79.466  -2.176  1.00  0.00           N  
ATOM    307  CA  ASP A  19      36.717  80.491  -2.815  1.00  0.00           C  
ATOM    308  C   ASP A  19      37.976  80.770  -1.999  1.00  0.00           C  
ATOM    309  O   ASP A  19      39.050  80.999  -2.555  1.00  0.00           O  
ATOM    310  CB  ASP A  19      35.911  81.780  -2.989  1.00  0.00           C  
ATOM    311  CG  ASP A  19      36.737  82.904  -3.584  1.00  0.00           C  
ATOM    312  OD1 ASP A  19      37.316  82.702  -4.672  1.00  0.00           O  
ATOM    313  OD2 ASP A  19      36.802  83.984  -2.963  1.00  0.00           O  
ATOM    314  H   ASP A  19      34.991  79.690  -1.887  1.00  0.00           H  
ATOM    315  HA  ASP A  19      37.008  80.126  -3.789  1.00  0.00           H  
ATOM    316  HB2 ASP A  19      35.074  81.588  -3.644  1.00  0.00           H  
ATOM    317  HB3 ASP A  19      35.543  82.099  -2.025  1.00  0.00           H  
ATOM    318  N   ASP A  20      37.834  80.750  -0.679  1.00  0.00           N  
ATOM    319  CA  ASP A  20      38.960  81.001   0.215  1.00  0.00           C  
ATOM    320  C   ASP A  20      39.788  79.735   0.412  1.00  0.00           C  
ATOM    321  O   ASP A  20      40.004  79.293   1.541  1.00  0.00           O  
ATOM    322  CB  ASP A  20      38.461  81.515   1.566  1.00  0.00           C  
ATOM    323  CG  ASP A  20      38.220  83.012   1.562  1.00  0.00           C  
ATOM    324  OD1 ASP A  20      39.206  83.772   1.451  1.00  0.00           O  
ATOM    325  OD2 ASP A  20      37.047  83.424   1.670  1.00  0.00           O  
ATOM    326  H   ASP A  20      36.952  80.562  -0.295  1.00  0.00           H  
ATOM    327  HA  ASP A  20      39.582  81.756  -0.240  1.00  0.00           H  
ATOM    328  HB2 ASP A  20      37.533  81.021   1.812  1.00  0.00           H  
ATOM    329  HB3 ASP A  20      39.197  81.289   2.323  1.00  0.00           H  
ATOM    330  N   ILE A  21      40.249  79.157  -0.692  1.00  0.00           N  
ATOM    331  CA  ILE A  21      41.053  77.943  -0.640  1.00  0.00           C  
ATOM    332  C   ILE A  21      42.354  78.111  -1.418  1.00  0.00           C  
ATOM    333  O   ILE A  21      42.374  78.719  -2.489  1.00  0.00           O  
ATOM    334  CB  ILE A  21      40.284  76.733  -1.201  1.00  0.00           C  
ATOM    335  CG1 ILE A  21      39.052  76.440  -0.342  1.00  0.00           C  
ATOM    336  CG2 ILE A  21      41.191  75.513  -1.269  1.00  0.00           C  
ATOM    337  CD1 ILE A  21      38.156  75.365  -0.917  1.00  0.00           C  
ATOM    338  H   ILE A  21      40.043  79.556  -1.562  1.00  0.00           H  
ATOM    339  HA  ILE A  21      41.289  77.744   0.396  1.00  0.00           H  
ATOM    340  HB  ILE A  21      39.966  76.971  -2.205  1.00  0.00           H  
ATOM    341 HG12 ILE A  21      39.371  76.118   0.635  1.00  0.00           H  
ATOM    342 HG13 ILE A  21      38.468  77.344  -0.246  1.00  0.00           H  
ATOM    343 HG21 ILE A  21      41.609  75.321  -0.291  1.00  0.00           H  
ATOM    344 HG22 ILE A  21      40.618  74.655  -1.588  1.00  0.00           H  
ATOM    345 HG23 ILE A  21      41.990  75.696  -1.972  1.00  0.00           H  
ATOM    346 HD11 ILE A  21      38.692  74.427  -0.944  1.00  0.00           H  
ATOM    347 HD12 ILE A  21      37.278  75.259  -0.298  1.00  0.00           H  
ATOM    348 HD13 ILE A  21      37.860  75.640  -1.918  1.00  0.00           H  
ATOM    349  N   ILE A  22      43.437  77.567  -0.874  1.00  0.00           N  
ATOM    350  CA  ILE A  22      44.741  77.654  -1.520  1.00  0.00           C  
ATOM    351  C   ILE A  22      45.401  76.283  -1.613  1.00  0.00           C  
ATOM    352  O   ILE A  22      44.820  75.274  -1.212  1.00  0.00           O  
ATOM    353  CB  ILE A  22      45.680  78.613  -0.765  1.00  0.00           C  
ATOM    354  CG1 ILE A  22      45.757  78.228   0.714  1.00  0.00           C  
ATOM    355  CG2 ILE A  22      45.205  80.051  -0.919  1.00  0.00           C  
ATOM    356  CD1 ILE A  22      46.899  78.890   1.451  1.00  0.00           C  
ATOM    357  H   ILE A  22      43.357  77.095  -0.020  1.00  0.00           H  
ATOM    358  HA  ILE A  22      44.593  78.038  -2.519  1.00  0.00           H  
ATOM    359  HB  ILE A  22      46.663  78.536  -1.201  1.00  0.00           H  
ATOM    360 HG12 ILE A  22      44.838  78.512   1.202  1.00  0.00           H  
ATOM    361 HG13 ILE A  22      45.886  77.158   0.792  1.00  0.00           H  
ATOM    362 HG21 ILE A  22      44.730  80.373  -0.004  1.00  0.00           H  
ATOM    363 HG22 ILE A  22      46.049  80.688  -1.131  1.00  0.00           H  
ATOM    364 HG23 ILE A  22      44.496  80.110  -1.732  1.00  0.00           H  
ATOM    365 HD11 ILE A  22      47.824  78.701   0.927  1.00  0.00           H  
ATOM    366 HD12 ILE A  22      46.726  79.955   1.502  1.00  0.00           H  
ATOM    367 HD13 ILE A  22      46.964  78.487   2.451  1.00  0.00           H  
ATOM    368  N   ILE A  23      46.620  76.253  -2.141  1.00  0.00           N  
ATOM    369  CA  ILE A  23      47.361  75.005  -2.283  1.00  0.00           C  
ATOM    370  C   ILE A  23      47.845  74.498  -0.930  1.00  0.00           C  
ATOM    371  O   ILE A  23      48.069  73.300  -0.748  1.00  0.00           O  
ATOM    372  CB  ILE A  23      48.571  75.174  -3.220  1.00  0.00           C  
ATOM    373  CG1 ILE A  23      48.105  75.525  -4.635  1.00  0.00           C  
ATOM    374  CG2 ILE A  23      49.411  73.905  -3.234  1.00  0.00           C  
ATOM    375  CD1 ILE A  23      47.855  77.002  -4.840  1.00  0.00           C  
ATOM    376  H   ILE A  23      47.031  77.090  -2.442  1.00  0.00           H  
ATOM    377  HA  ILE A  23      46.696  74.272  -2.715  1.00  0.00           H  
ATOM    378  HB  ILE A  23      49.183  75.978  -2.841  1.00  0.00           H  
ATOM    379 HG12 ILE A  23      48.857  75.215  -5.343  1.00  0.00           H  
ATOM    380 HG13 ILE A  23      47.183  75.000  -4.842  1.00  0.00           H  
ATOM    381 HG21 ILE A  23      50.086  73.929  -4.076  1.00  0.00           H  
ATOM    382 HG22 ILE A  23      49.981  73.842  -2.318  1.00  0.00           H  
ATOM    383 HG23 ILE A  23      48.764  73.045  -3.315  1.00  0.00           H  
ATOM    384 HD11 ILE A  23      46.870  77.255  -4.475  1.00  0.00           H  
ATOM    385 HD12 ILE A  23      48.595  77.572  -4.297  1.00  0.00           H  
ATOM    386 HD13 ILE A  23      47.919  77.237  -5.891  1.00  0.00           H  
ATOM    387  N   LYS A  24      48.005  75.415   0.017  1.00  0.00           N  
ATOM    388  CA  LYS A  24      48.462  75.060   1.356  1.00  0.00           C  
ATOM    389  C   LYS A  24      47.278  74.841   2.294  1.00  0.00           C  
ATOM    390  O   LYS A  24      47.456  74.615   3.491  1.00  0.00           O  
ATOM    391  CB  LYS A  24      49.371  76.158   1.915  1.00  0.00           C  
ATOM    392  CG  LYS A  24      50.758  76.170   1.299  1.00  0.00           C  
ATOM    393  CD  LYS A  24      50.834  77.115   0.112  1.00  0.00           C  
ATOM    394  CE  LYS A  24      52.275  77.372  -0.305  1.00  0.00           C  
ATOM    395  NZ  LYS A  24      52.974  78.282   0.644  1.00  0.00           N  
ATOM    396  H   LYS A  24      47.812  76.354  -0.189  1.00  0.00           H  
ATOM    397  HA  LYS A  24      49.023  74.142   1.283  1.00  0.00           H  
ATOM    398  HB2 LYS A  24      48.910  77.118   1.732  1.00  0.00           H  
ATOM    399  HB3 LYS A  24      49.474  76.015   2.981  1.00  0.00           H  
ATOM    400  HG2 LYS A  24      51.471  76.488   2.046  1.00  0.00           H  
ATOM    401  HG3 LYS A  24      51.004  75.171   0.968  1.00  0.00           H  
ATOM    402  HD2 LYS A  24      50.302  76.679  -0.719  1.00  0.00           H  
ATOM    403  HD3 LYS A  24      50.374  78.056   0.382  1.00  0.00           H  
ATOM    404  HE2 LYS A  24      52.799  76.429  -0.339  1.00  0.00           H  
ATOM    405  HE3 LYS A  24      52.276  77.820  -1.288  1.00  0.00           H  
ATOM    406  HZ1 LYS A  24      52.324  78.576   1.401  1.00  0.00           H  
ATOM    407  HZ2 LYS A  24      53.312  79.129   0.143  1.00  0.00           H  
ATOM    408  HZ3 LYS A  24      53.788  77.796   1.070  1.00  0.00           H  
ATOM    409  N   CYS A  25      46.071  74.906   1.741  1.00  0.00           N  
ATOM    410  CA  CYS A  25      44.859  74.713   2.528  1.00  0.00           C  
ATOM    411  C   CYS A  25      44.473  73.238   2.580  1.00  0.00           C  
ATOM    412  O   CYS A  25      44.568  72.527   1.580  1.00  0.00           O  
ATOM    413  CB  CYS A  25      43.709  75.533   1.939  1.00  0.00           C  
ATOM    414  SG  CYS A  25      42.078  75.077   2.574  1.00  0.00           S  
ATOM    415  H   CYS A  25      45.994  75.089   0.781  1.00  0.00           H  
ATOM    416  HA  CYS A  25      45.058  75.056   3.531  1.00  0.00           H  
ATOM    417  HB2 CYS A  25      43.869  76.577   2.165  1.00  0.00           H  
ATOM    418  HB3 CYS A  25      43.695  75.402   0.868  1.00  0.00           H  
ATOM    419  HG  CYS A  25      41.558  74.177   1.754  1.00  0.00           H  
ATOM    420  N   GLN A  26      44.040  72.788   3.753  1.00  0.00           N  
ATOM    421  CA  GLN A  26      43.643  71.396   3.936  1.00  0.00           C  
ATOM    422  C   GLN A  26      42.218  71.302   4.469  1.00  0.00           C  
ATOM    423  O   GLN A  26      41.852  72.002   5.416  1.00  0.00           O  
ATOM    424  CB  GLN A  26      44.606  70.690   4.891  1.00  0.00           C  
ATOM    425  CG  GLN A  26      46.048  70.686   4.410  1.00  0.00           C  
ATOM    426  CD  GLN A  26      47.027  70.296   5.500  1.00  0.00           C  
ATOM    427  OE1 GLN A  26      47.261  69.112   5.746  1.00  0.00           O  
ATOM    428  NE2 GLN A  26      47.604  71.292   6.161  1.00  0.00           N  
ATOM    429  H   GLN A  26      43.986  73.403   4.512  1.00  0.00           H  
ATOM    430  HA  GLN A  26      43.686  70.910   2.972  1.00  0.00           H  
ATOM    431  HB2 GLN A  26      44.570  71.186   5.850  1.00  0.00           H  
ATOM    432  HB3 GLN A  26      44.287  69.666   5.013  1.00  0.00           H  
ATOM    433  HG2 GLN A  26      46.140  69.981   3.596  1.00  0.00           H  
ATOM    434  HG3 GLN A  26      46.299  71.675   4.058  1.00  0.00           H  
ATOM    435 HE21 GLN A  26      47.369  72.211   5.911  1.00  0.00           H  
ATOM    436 HE22 GLN A  26      48.240  71.070   6.871  1.00  0.00           H  
ATOM    437  N   CYS A  27      41.418  70.437   3.858  1.00  0.00           N  
ATOM    438  CA  CYS A  27      40.031  70.253   4.271  1.00  0.00           C  
ATOM    439  C   CYS A  27      39.641  68.778   4.228  1.00  0.00           C  
ATOM    440  O   CYS A  27      40.442  67.926   3.842  1.00  0.00           O  
ATOM    441  CB  CYS A  27      39.097  71.066   3.374  1.00  0.00           C  
ATOM    442  SG  CYS A  27      39.287  70.725   1.609  1.00  0.00           S  
ATOM    443  H   CYS A  27      41.767  69.908   3.111  1.00  0.00           H  
ATOM    444  HA  CYS A  27      39.939  70.606   5.287  1.00  0.00           H  
ATOM    445  HB2 CYS A  27      38.073  70.849   3.642  1.00  0.00           H  
ATOM    446  HB3 CYS A  27      39.287  72.118   3.530  1.00  0.00           H  
ATOM    447  HG  CYS A  27      38.549  69.665   1.316  1.00  0.00           H  
ATOM    448  N   TRP A  28      38.409  68.485   4.627  1.00  0.00           N  
ATOM    449  CA  TRP A  28      37.914  67.114   4.634  1.00  0.00           C  
ATOM    450  C   TRP A  28      37.071  66.832   3.396  1.00  0.00           C  
ATOM    451  O   TRP A  28      36.298  67.682   2.953  1.00  0.00           O  
ATOM    452  CB  TRP A  28      37.090  66.854   5.897  1.00  0.00           C  
ATOM    453  CG  TRP A  28      37.928  66.699   7.130  1.00  0.00           C  
ATOM    454  CD1 TRP A  28      38.409  67.700   7.926  1.00  0.00           C  
ATOM    455  CD2 TRP A  28      38.384  65.472   7.708  1.00  0.00           C  
ATOM    456  NE1 TRP A  28      39.136  67.169   8.963  1.00  0.00           N  
ATOM    457  CE2 TRP A  28      39.136  65.804   8.853  1.00  0.00           C  
ATOM    458  CE3 TRP A  28      38.230  64.125   7.372  1.00  0.00           C  
ATOM    459  CZ2 TRP A  28      39.731  64.836   9.659  1.00  0.00           C  
ATOM    460  CZ3 TRP A  28      38.822  63.166   8.172  1.00  0.00           C  
ATOM    461  CH2 TRP A  28      39.564  63.525   9.305  1.00  0.00           C  
ATOM    462  H   TRP A  28      37.817  69.209   4.923  1.00  0.00           H  
ATOM    463  HA  TRP A  28      38.770  66.453   4.631  1.00  0.00           H  
ATOM    464  HB2 TRP A  28      36.415  67.681   6.055  1.00  0.00           H  
ATOM    465  HB3 TRP A  28      36.519  65.946   5.765  1.00  0.00           H  
ATOM    466  HD1 TRP A  28      38.235  68.752   7.752  1.00  0.00           H  
ATOM    467  HE1 TRP A  28      39.581  67.684   9.668  1.00  0.00           H  
ATOM    468  HE3 TRP A  28      37.663  63.828   6.502  1.00  0.00           H  
ATOM    469  HZ2 TRP A  28      40.306  65.097  10.535  1.00  0.00           H  
ATOM    470  HZ3 TRP A  28      38.714  62.119   7.927  1.00  0.00           H  
ATOM    471  HH2 TRP A  28      40.008  62.743   9.901  1.00  0.00           H  
ATOM    472  N   VAL A  29      37.224  65.635   2.841  1.00  0.00           N  
ATOM    473  CA  VAL A  29      36.474  65.240   1.653  1.00  0.00           C  
ATOM    474  C   VAL A  29      35.662  63.977   1.910  1.00  0.00           C  
ATOM    475  O   VAL A  29      36.154  63.024   2.514  1.00  0.00           O  
ATOM    476  CB  VAL A  29      37.410  65.002   0.453  1.00  0.00           C  
ATOM    477  CG1 VAL A  29      36.603  64.787  -0.818  1.00  0.00           C  
ATOM    478  CG2 VAL A  29      38.376  66.166   0.291  1.00  0.00           C  
ATOM    479  H   VAL A  29      37.854  65.000   3.239  1.00  0.00           H  
ATOM    480  HA  VAL A  29      35.800  66.046   1.401  1.00  0.00           H  
ATOM    481  HB  VAL A  29      37.985  64.107   0.643  1.00  0.00           H  
ATOM    482 HG11 VAL A  29      37.214  64.279  -1.551  1.00  0.00           H  
ATOM    483 HG12 VAL A  29      35.733  64.187  -0.596  1.00  0.00           H  
ATOM    484 HG13 VAL A  29      36.292  65.743  -1.212  1.00  0.00           H  
ATOM    485 HG21 VAL A  29      38.929  66.305   1.208  1.00  0.00           H  
ATOM    486 HG22 VAL A  29      39.062  65.953  -0.516  1.00  0.00           H  
ATOM    487 HG23 VAL A  29      37.822  67.066   0.065  1.00  0.00           H  
ATOM    488  N   GLN A  30      34.416  63.977   1.446  1.00  0.00           N  
ATOM    489  CA  GLN A  30      33.535  62.829   1.627  1.00  0.00           C  
ATOM    490  C   GLN A  30      33.819  61.755   0.581  1.00  0.00           C  
ATOM    491  O   GLN A  30      33.658  61.982  -0.618  1.00  0.00           O  
ATOM    492  CB  GLN A  30      32.071  63.265   1.543  1.00  0.00           C  
ATOM    493  CG  GLN A  30      31.090  62.105   1.551  1.00  0.00           C  
ATOM    494  CD  GLN A  30      29.710  62.510   2.030  1.00  0.00           C  
ATOM    495  OE1 GLN A  30      29.138  63.491   1.554  1.00  0.00           O  
ATOM    496  NE2 GLN A  30      29.167  61.756   2.979  1.00  0.00           N  
ATOM    497  H   GLN A  30      34.082  64.766   0.973  1.00  0.00           H  
ATOM    498  HA  GLN A  30      33.723  62.418   2.607  1.00  0.00           H  
ATOM    499  HB2 GLN A  30      31.849  63.902   2.385  1.00  0.00           H  
ATOM    500  HB3 GLN A  30      31.926  63.824   0.630  1.00  0.00           H  
ATOM    501  HG2 GLN A  30      31.004  61.715   0.546  1.00  0.00           H  
ATOM    502  HG3 GLN A  30      31.469  61.333   2.203  1.00  0.00           H  
ATOM    503 HE21 GLN A  30      29.682  60.991   3.312  1.00  0.00           H  
ATOM    504 HE22 GLN A  30      28.277  61.996   3.308  1.00  0.00           H  
ATOM    505  N   LYS A  31      34.243  60.584   1.044  1.00  0.00           N  
ATOM    506  CA  LYS A  31      34.549  59.473   0.150  1.00  0.00           C  
ATOM    507  C   LYS A  31      34.124  58.145   0.767  1.00  0.00           C  
ATOM    508  O   LYS A  31      34.353  57.897   1.949  1.00  0.00           O  
ATOM    509  CB  LYS A  31      36.047  59.445  -0.166  1.00  0.00           C  
ATOM    510  CG  LYS A  31      36.355  59.169  -1.628  1.00  0.00           C  
ATOM    511  CD  LYS A  31      35.800  60.258  -2.530  1.00  0.00           C  
ATOM    512  CE  LYS A  31      36.377  60.166  -3.935  1.00  0.00           C  
ATOM    513  NZ  LYS A  31      36.081  61.385  -4.737  1.00  0.00           N  
ATOM    514  H   LYS A  31      34.352  60.463   2.010  1.00  0.00           H  
ATOM    515  HA  LYS A  31      33.999  59.625  -0.767  1.00  0.00           H  
ATOM    516  HB2 LYS A  31      36.476  60.400   0.096  1.00  0.00           H  
ATOM    517  HB3 LYS A  31      36.513  58.674   0.430  1.00  0.00           H  
ATOM    518  HG2 LYS A  31      37.425  59.118  -1.758  1.00  0.00           H  
ATOM    519  HG3 LYS A  31      35.911  58.222  -1.906  1.00  0.00           H  
ATOM    520  HD2 LYS A  31      34.726  60.155  -2.587  1.00  0.00           H  
ATOM    521  HD3 LYS A  31      36.049  61.223  -2.110  1.00  0.00           H  
ATOM    522  HE2 LYS A  31      37.447  60.045  -3.862  1.00  0.00           H  
ATOM    523  HE3 LYS A  31      35.950  59.307  -4.429  1.00  0.00           H  
ATOM    524  HZ1 LYS A  31      36.778  61.489  -5.501  1.00  0.00           H  
ATOM    525  HZ2 LYS A  31      36.117  62.229  -4.131  1.00  0.00           H  
ATOM    526  HZ3 LYS A  31      35.131  61.315  -5.156  1.00  0.00           H  
ATOM    527  N   ASN A  32      33.504  57.293  -0.043  1.00  0.00           N  
ATOM    528  CA  ASN A  32      33.047  55.989   0.423  1.00  0.00           C  
ATOM    529  C   ASN A  32      32.201  56.129   1.685  1.00  0.00           C  
ATOM    530  O   ASN A  32      32.441  55.452   2.684  1.00  0.00           O  
ATOM    531  CB  ASN A  32      34.243  55.074   0.696  1.00  0.00           C  
ATOM    532  CG  ASN A  32      33.826  53.640   0.953  1.00  0.00           C  
ATOM    533  OD1 ASN A  32      33.223  52.994   0.096  1.00  0.00           O  
ATOM    534  ND2 ASN A  32      34.146  53.134   2.139  1.00  0.00           N  
ATOM    535  H   ASN A  32      33.350  57.547  -0.977  1.00  0.00           H  
ATOM    536  HA  ASN A  32      32.442  55.552  -0.356  1.00  0.00           H  
ATOM    537  HB2 ASN A  32      34.903  55.090  -0.159  1.00  0.00           H  
ATOM    538  HB3 ASN A  32      34.775  55.436   1.563  1.00  0.00           H  
ATOM    539 HD21 ASN A  32      34.627  53.706   2.773  1.00  0.00           H  
ATOM    540 HD22 ASN A  32      33.889  52.207   2.331  1.00  0.00           H  
ATOM    541  N   ASP A  33      31.209  57.011   1.631  1.00  0.00           N  
ATOM    542  CA  ASP A  33      30.325  57.239   2.768  1.00  0.00           C  
ATOM    543  C   ASP A  33      31.129  57.528   4.031  1.00  0.00           C  
ATOM    544  O   ASP A  33      30.688  57.228   5.140  1.00  0.00           O  
ATOM    545  CB  ASP A  33      29.421  56.025   2.989  1.00  0.00           C  
ATOM    546  CG  ASP A  33      28.085  56.402   3.598  1.00  0.00           C  
ATOM    547  OD1 ASP A  33      27.381  57.247   3.006  1.00  0.00           O  
ATOM    548  OD2 ASP A  33      27.742  55.851   4.664  1.00  0.00           O  
ATOM    549  H   ASP A  33      31.068  57.521   0.805  1.00  0.00           H  
ATOM    550  HA  ASP A  33      29.710  58.098   2.543  1.00  0.00           H  
ATOM    551  HB2 ASP A  33      29.240  55.540   2.041  1.00  0.00           H  
ATOM    552  HB3 ASP A  33      29.917  55.332   3.654  1.00  0.00           H  
ATOM    553  N   GLU A  34      32.311  58.111   3.855  1.00  0.00           N  
ATOM    554  CA  GLU A  34      33.176  58.439   4.981  1.00  0.00           C  
ATOM    555  C   GLU A  34      33.845  59.795   4.777  1.00  0.00           C  
ATOM    556  O   GLU A  34      33.692  60.422   3.731  1.00  0.00           O  
ATOM    557  CB  GLU A  34      34.240  57.355   5.167  1.00  0.00           C  
ATOM    558  CG  GLU A  34      33.742  56.138   5.929  1.00  0.00           C  
ATOM    559  CD  GLU A  34      34.874  55.258   6.426  1.00  0.00           C  
ATOM    560  OE1 GLU A  34      36.023  55.743   6.476  1.00  0.00           O  
ATOM    561  OE2 GLU A  34      34.609  54.086   6.765  1.00  0.00           O  
ATOM    562  H   GLU A  34      32.606  58.326   2.945  1.00  0.00           H  
ATOM    563  HA  GLU A  34      32.562  58.484   5.868  1.00  0.00           H  
ATOM    564  HB2 GLU A  34      34.581  57.032   4.196  1.00  0.00           H  
ATOM    565  HB3 GLU A  34      35.073  57.776   5.710  1.00  0.00           H  
ATOM    566  HG2 GLU A  34      33.166  56.470   6.778  1.00  0.00           H  
ATOM    567  HG3 GLU A  34      33.113  55.553   5.274  1.00  0.00           H  
ATOM    568  N   GLU A  35      34.589  60.240   5.786  1.00  0.00           N  
ATOM    569  CA  GLU A  35      35.280  61.521   5.717  1.00  0.00           C  
ATOM    570  C   GLU A  35      36.787  61.335   5.869  1.00  0.00           C  
ATOM    571  O   GLU A  35      37.255  60.720   6.828  1.00  0.00           O  
ATOM    572  CB  GLU A  35      34.761  62.465   6.804  1.00  0.00           C  
ATOM    573  CG  GLU A  35      33.774  63.500   6.290  1.00  0.00           C  
ATOM    574  CD  GLU A  35      32.822  63.984   7.365  1.00  0.00           C  
ATOM    575  OE1 GLU A  35      32.864  63.436   8.487  1.00  0.00           O  
ATOM    576  OE2 GLU A  35      32.033  64.911   7.086  1.00  0.00           O  
ATOM    577  H   GLU A  35      34.673  59.693   6.595  1.00  0.00           H  
ATOM    578  HA  GLU A  35      35.079  61.955   4.750  1.00  0.00           H  
ATOM    579  HB2 GLU A  35      34.271  61.880   7.568  1.00  0.00           H  
ATOM    580  HB3 GLU A  35      35.599  62.985   7.243  1.00  0.00           H  
ATOM    581  HG2 GLU A  35      34.325  64.347   5.911  1.00  0.00           H  
ATOM    582  HG3 GLU A  35      33.196  63.061   5.489  1.00  0.00           H  
ATOM    583  N   ARG A  36      37.542  61.870   4.915  1.00  0.00           N  
ATOM    584  CA  ARG A  36      38.996  61.761   4.940  1.00  0.00           C  
ATOM    585  C   ARG A  36      39.646  63.130   4.759  1.00  0.00           C  
ATOM    586  O   ARG A  36      39.213  63.930   3.929  1.00  0.00           O  
ATOM    587  CB  ARG A  36      39.476  60.807   3.845  1.00  0.00           C  
ATOM    588  CG  ARG A  36      38.892  59.408   3.956  1.00  0.00           C  
ATOM    589  CD  ARG A  36      39.753  58.385   3.232  1.00  0.00           C  
ATOM    590  NE  ARG A  36      40.826  57.873   4.080  1.00  0.00           N  
ATOM    591  CZ  ARG A  36      40.621  57.074   5.121  1.00  0.00           C  
ATOM    592  NH1 ARG A  36      39.390  56.697   5.440  1.00  0.00           N  
ATOM    593  NH2 ARG A  36      41.648  56.650   5.845  1.00  0.00           N  
ATOM    594  H   ARG A  36      37.111  62.347   4.176  1.00  0.00           H  
ATOM    595  HA  ARG A  36      39.282  61.365   5.903  1.00  0.00           H  
ATOM    596  HB2 ARG A  36      39.202  61.213   2.884  1.00  0.00           H  
ATOM    597  HB3 ARG A  36      40.553  60.729   3.900  1.00  0.00           H  
ATOM    598  HG2 ARG A  36      38.830  59.136   5.000  1.00  0.00           H  
ATOM    599  HG3 ARG A  36      37.903  59.407   3.522  1.00  0.00           H  
ATOM    600  HD2 ARG A  36      39.126  57.563   2.923  1.00  0.00           H  
ATOM    601  HD3 ARG A  36      40.187  58.853   2.361  1.00  0.00           H  
ATOM    602  HE  ARG A  36      41.743  58.139   3.862  1.00  0.00           H  
ATOM    603 HH11 ARG A  36      38.614  57.015   4.896  1.00  0.00           H  
ATOM    604 HH12 ARG A  36      39.239  56.094   6.224  1.00  0.00           H  
ATOM    605 HH21 ARG A  36      42.577  56.930   5.607  1.00  0.00           H  
ATOM    606 HH22 ARG A  36      41.493  56.048   6.628  1.00  0.00           H  
ATOM    607  N   LEU A  37      40.687  63.392   5.541  1.00  0.00           N  
ATOM    608  CA  LEU A  37      41.398  64.664   5.468  1.00  0.00           C  
ATOM    609  C   LEU A  37      42.215  64.758   4.182  1.00  0.00           C  
ATOM    610  O   LEU A  37      43.231  64.080   4.030  1.00  0.00           O  
ATOM    611  CB  LEU A  37      42.316  64.829   6.681  1.00  0.00           C  
ATOM    612  CG  LEU A  37      42.885  66.230   6.906  1.00  0.00           C  
ATOM    613  CD1 LEU A  37      41.928  67.068   7.739  1.00  0.00           C  
ATOM    614  CD2 LEU A  37      44.249  66.150   7.576  1.00  0.00           C  
ATOM    615  H   LEU A  37      40.988  62.715   6.183  1.00  0.00           H  
ATOM    616  HA  LEU A  37      40.663  65.455   5.472  1.00  0.00           H  
ATOM    617  HB2 LEU A  37      41.752  64.557   7.560  1.00  0.00           H  
ATOM    618  HB3 LEU A  37      43.146  64.148   6.562  1.00  0.00           H  
ATOM    619  HG  LEU A  37      43.009  66.719   5.949  1.00  0.00           H  
ATOM    620 HD11 LEU A  37      41.059  67.318   7.148  1.00  0.00           H  
ATOM    621 HD12 LEU A  37      42.422  67.975   8.052  1.00  0.00           H  
ATOM    622 HD13 LEU A  37      41.622  66.506   8.610  1.00  0.00           H  
ATOM    623 HD21 LEU A  37      44.906  66.888   7.142  1.00  0.00           H  
ATOM    624 HD22 LEU A  37      44.664  65.164   7.428  1.00  0.00           H  
ATOM    625 HD23 LEU A  37      44.141  66.340   8.634  1.00  0.00           H  
ATOM    626  N   ALA A  38      41.765  65.605   3.263  1.00  0.00           N  
ATOM    627  CA  ALA A  38      42.456  65.792   1.992  1.00  0.00           C  
ATOM    628  C   ALA A  38      43.135  67.156   1.932  1.00  0.00           C  
ATOM    629  O   ALA A  38      42.565  68.161   2.354  1.00  0.00           O  
ATOM    630  CB  ALA A  38      41.483  65.632   0.834  1.00  0.00           C  
ATOM    631  H   ALA A  38      40.950  66.118   3.443  1.00  0.00           H  
ATOM    632  HA  ALA A  38      43.209  65.021   1.907  1.00  0.00           H  
ATOM    633  HB1 ALA A  38      42.031  65.387  -0.064  1.00  0.00           H  
ATOM    634  HB2 ALA A  38      40.784  64.840   1.058  1.00  0.00           H  
ATOM    635  HB3 ALA A  38      40.945  66.556   0.687  1.00  0.00           H  
ATOM    636  N   GLU A  39      44.355  67.182   1.405  1.00  0.00           N  
ATOM    637  CA  GLU A  39      45.111  68.424   1.292  1.00  0.00           C  
ATOM    638  C   GLU A  39      45.033  68.981  -0.126  1.00  0.00           C  
ATOM    639  O   GLU A  39      45.269  68.264  -1.100  1.00  0.00           O  
ATOM    640  CB  GLU A  39      46.573  68.193   1.681  1.00  0.00           C  
ATOM    641  CG  GLU A  39      47.477  69.378   1.380  1.00  0.00           C  
ATOM    642  CD  GLU A  39      48.865  69.218   1.969  1.00  0.00           C  
ATOM    643  OE1 GLU A  39      49.305  68.062   2.141  1.00  0.00           O  
ATOM    644  OE2 GLU A  39      49.509  70.247   2.259  1.00  0.00           O  
ATOM    645  H   GLU A  39      44.756  66.346   1.086  1.00  0.00           H  
ATOM    646  HA  GLU A  39      44.676  69.140   1.972  1.00  0.00           H  
ATOM    647  HB2 GLU A  39      46.624  67.988   2.740  1.00  0.00           H  
ATOM    648  HB3 GLU A  39      46.946  67.337   1.139  1.00  0.00           H  
ATOM    649  HG2 GLU A  39      47.566  69.482   0.309  1.00  0.00           H  
ATOM    650  HG3 GLU A  39      47.028  70.270   1.790  1.00  0.00           H  
ATOM    651  N   ILE A  40      44.697  70.262  -0.235  1.00  0.00           N  
ATOM    652  CA  ILE A  40      44.588  70.915  -1.533  1.00  0.00           C  
ATOM    653  C   ILE A  40      45.933  70.945  -2.249  1.00  0.00           C  
ATOM    654  O   ILE A  40      46.977  71.138  -1.624  1.00  0.00           O  
ATOM    655  CB  ILE A  40      44.060  72.356  -1.395  1.00  0.00           C  
ATOM    656  CG1 ILE A  40      42.716  72.362  -0.664  1.00  0.00           C  
ATOM    657  CG2 ILE A  40      43.928  73.004  -2.765  1.00  0.00           C  
ATOM    658  CD1 ILE A  40      41.601  71.703  -1.445  1.00  0.00           C  
ATOM    659  H   ILE A  40      44.521  70.780   0.578  1.00  0.00           H  
ATOM    660  HA  ILE A  40      43.885  70.352  -2.130  1.00  0.00           H  
ATOM    661  HB  ILE A  40      44.777  72.924  -0.822  1.00  0.00           H  
ATOM    662 HG12 ILE A  40      42.820  71.838   0.272  1.00  0.00           H  
ATOM    663 HG13 ILE A  40      42.426  73.385  -0.470  1.00  0.00           H  
ATOM    664 HG21 ILE A  40      44.885  73.404  -3.068  1.00  0.00           H  
ATOM    665 HG22 ILE A  40      43.604  72.266  -3.482  1.00  0.00           H  
ATOM    666 HG23 ILE A  40      43.202  73.803  -2.717  1.00  0.00           H  
ATOM    667 HD11 ILE A  40      42.014  71.198  -2.307  1.00  0.00           H  
ATOM    668 HD12 ILE A  40      41.099  70.983  -0.816  1.00  0.00           H  
ATOM    669 HD13 ILE A  40      40.895  72.452  -1.770  1.00  0.00           H  
ATOM    670  N   LEU A  41      45.902  70.755  -3.563  1.00  0.00           N  
ATOM    671  CA  LEU A  41      47.120  70.761  -4.367  1.00  0.00           C  
ATOM    672  C   LEU A  41      47.084  71.883  -5.399  1.00  0.00           C  
ATOM    673  O   LEU A  41      48.107  72.501  -5.693  1.00  0.00           O  
ATOM    674  CB  LEU A  41      47.299  69.413  -5.067  1.00  0.00           C  
ATOM    675  CG  LEU A  41      47.808  68.265  -4.195  1.00  0.00           C  
ATOM    676  CD1 LEU A  41      47.939  66.990  -5.013  1.00  0.00           C  
ATOM    677  CD2 LEU A  41      49.140  68.631  -3.556  1.00  0.00           C  
ATOM    678  H   LEU A  41      45.040  70.605  -4.006  1.00  0.00           H  
ATOM    679  HA  LEU A  41      47.954  70.926  -3.702  1.00  0.00           H  
ATOM    680  HB2 LEU A  41      46.342  69.121  -5.473  1.00  0.00           H  
ATOM    681  HB3 LEU A  41      48.003  69.552  -5.876  1.00  0.00           H  
ATOM    682  HG  LEU A  41      47.096  68.080  -3.403  1.00  0.00           H  
ATOM    683 HD11 LEU A  41      46.964  66.677  -5.351  1.00  0.00           H  
ATOM    684 HD12 LEU A  41      48.376  66.214  -4.403  1.00  0.00           H  
ATOM    685 HD13 LEU A  41      48.574  67.175  -5.868  1.00  0.00           H  
ATOM    686 HD21 LEU A  41      49.739  69.184  -4.264  1.00  0.00           H  
ATOM    687 HD22 LEU A  41      49.661  67.729  -3.271  1.00  0.00           H  
ATOM    688 HD23 LEU A  41      48.964  69.238  -2.680  1.00  0.00           H  
ATOM    689  N   SER A  42      45.900  72.141  -5.945  1.00  0.00           N  
ATOM    690  CA  SER A  42      45.733  73.189  -6.945  1.00  0.00           C  
ATOM    691  C   SER A  42      44.264  73.578  -7.084  1.00  0.00           C  
ATOM    692  O   SER A  42      43.384  72.936  -6.508  1.00  0.00           O  
ATOM    693  CB  SER A  42      46.279  72.724  -8.297  1.00  0.00           C  
ATOM    694  OG  SER A  42      47.161  73.687  -8.849  1.00  0.00           O  
ATOM    695  H   SER A  42      45.122  71.614  -5.670  1.00  0.00           H  
ATOM    696  HA  SER A  42      46.292  74.053  -6.619  1.00  0.00           H  
ATOM    697  HB2 SER A  42      46.814  71.796  -8.167  1.00  0.00           H  
ATOM    698  HB3 SER A  42      45.456  72.572  -8.982  1.00  0.00           H  
ATOM    699  HG  SER A  42      46.657  74.446  -9.151  1.00  0.00           H  
ATOM    700  N   ILE A  43      44.007  74.631  -7.851  1.00  0.00           N  
ATOM    701  CA  ILE A  43      42.645  75.105  -8.066  1.00  0.00           C  
ATOM    702  C   ILE A  43      42.347  75.263  -9.553  1.00  0.00           C  
ATOM    703  O   ILE A  43      43.204  75.686 -10.327  1.00  0.00           O  
ATOM    704  CB  ILE A  43      42.399  76.451  -7.358  1.00  0.00           C  
ATOM    705  CG1 ILE A  43      42.734  76.338  -5.870  1.00  0.00           C  
ATOM    706  CG2 ILE A  43      40.956  76.894  -7.550  1.00  0.00           C  
ATOM    707  CD1 ILE A  43      42.776  77.671  -5.157  1.00  0.00           C  
ATOM    708  H   ILE A  43      44.750  75.100  -8.283  1.00  0.00           H  
ATOM    709  HA  ILE A  43      41.969  74.373  -7.650  1.00  0.00           H  
ATOM    710  HB  ILE A  43      43.040  77.192  -7.810  1.00  0.00           H  
ATOM    711 HG12 ILE A  43      41.989  75.726  -5.385  1.00  0.00           H  
ATOM    712 HG13 ILE A  43      43.702  75.872  -5.761  1.00  0.00           H  
ATOM    713 HG21 ILE A  43      40.296  76.057  -7.373  1.00  0.00           H  
ATOM    714 HG22 ILE A  43      40.727  77.685  -6.853  1.00  0.00           H  
ATOM    715 HG23 ILE A  43      40.820  77.253  -8.560  1.00  0.00           H  
ATOM    716 HD11 ILE A  43      42.920  78.461  -5.880  1.00  0.00           H  
ATOM    717 HD12 ILE A  43      41.845  77.829  -4.633  1.00  0.00           H  
ATOM    718 HD13 ILE A  43      43.592  77.677  -4.451  1.00  0.00           H  
ATOM    719  N   ASN A  44      41.123  74.923  -9.945  1.00  0.00           N  
ATOM    720  CA  ASN A  44      40.711  75.028 -11.339  1.00  0.00           C  
ATOM    721  C   ASN A  44      39.341  75.692 -11.454  1.00  0.00           C  
ATOM    722  O   ASN A  44      38.309  75.051 -11.257  1.00  0.00           O  
ATOM    723  CB  ASN A  44      40.673  73.642 -11.989  1.00  0.00           C  
ATOM    724  CG  ASN A  44      40.060  73.670 -13.375  1.00  0.00           C  
ATOM    725  OD1 ASN A  44      40.210  74.644 -14.113  1.00  0.00           O  
ATOM    726  ND2 ASN A  44      39.365  72.598 -13.736  1.00  0.00           N  
ATOM    727  H   ASN A  44      40.483  74.592  -9.281  1.00  0.00           H  
ATOM    728  HA  ASN A  44      41.437  75.637 -11.856  1.00  0.00           H  
ATOM    729  HB2 ASN A  44      41.681  73.262 -12.069  1.00  0.00           H  
ATOM    730  HB3 ASN A  44      40.089  72.978 -11.370  1.00  0.00           H  
ATOM    731 HD21 ASN A  44      39.288  71.859 -13.096  1.00  0.00           H  
ATOM    732 HD22 ASN A  44      38.959  72.589 -14.628  1.00  0.00           H  
ATOM    733  N   THR A  45      39.341  76.983 -11.772  1.00  0.00           N  
ATOM    734  CA  THR A  45      38.100  77.735 -11.910  1.00  0.00           C  
ATOM    735  C   THR A  45      37.710  77.884 -13.376  1.00  0.00           C  
ATOM    736  O   THR A  45      37.682  78.993 -13.911  1.00  0.00           O  
ATOM    737  CB  THR A  45      38.218  79.134 -11.278  1.00  0.00           C  
ATOM    738  OG1 THR A  45      39.299  79.856 -11.879  1.00  0.00           O  
ATOM    739  CG2 THR A  45      38.443  79.032  -9.776  1.00  0.00           C  
ATOM    740  H   THR A  45      40.196  77.439 -11.915  1.00  0.00           H  
ATOM    741  HA  THR A  45      37.322  77.193 -11.394  1.00  0.00           H  
ATOM    742  HB  THR A  45      37.296  79.670 -11.453  1.00  0.00           H  
ATOM    743  HG1 THR A  45      39.083  80.791 -11.908  1.00  0.00           H  
ATOM    744 HG21 THR A  45      39.479  79.239  -9.553  1.00  0.00           H  
ATOM    745 HG22 THR A  45      38.196  78.035  -9.442  1.00  0.00           H  
ATOM    746 HG23 THR A  45      37.815  79.748  -9.269  1.00  0.00           H  
ATOM    747  N   ARG A  46      37.408  76.762 -14.021  1.00  0.00           N  
ATOM    748  CA  ARG A  46      37.018  76.769 -15.426  1.00  0.00           C  
ATOM    749  C   ARG A  46      35.607  76.217 -15.602  1.00  0.00           C  
ATOM    750  O   ARG A  46      35.153  75.986 -16.723  1.00  0.00           O  
ATOM    751  CB  ARG A  46      38.006  75.946 -16.255  1.00  0.00           C  
ATOM    752  CG  ARG A  46      39.260  76.712 -16.644  1.00  0.00           C  
ATOM    753  CD  ARG A  46      38.992  77.675 -17.790  1.00  0.00           C  
ATOM    754  NE  ARG A  46      40.190  77.927 -18.586  1.00  0.00           N  
ATOM    755  CZ  ARG A  46      40.166  78.464 -19.800  1.00  0.00           C  
ATOM    756  NH1 ARG A  46      39.011  78.804 -20.355  1.00  0.00           N  
ATOM    757  NH2 ARG A  46      41.298  78.661 -20.462  1.00  0.00           N  
ATOM    758  H   ARG A  46      37.449  75.909 -13.541  1.00  0.00           H  
ATOM    759  HA  ARG A  46      37.037  77.792 -15.771  1.00  0.00           H  
ATOM    760  HB2 ARG A  46      38.303  75.079 -15.683  1.00  0.00           H  
ATOM    761  HB3 ARG A  46      37.515  75.620 -17.159  1.00  0.00           H  
ATOM    762  HG2 ARG A  46      39.608  77.273 -15.790  1.00  0.00           H  
ATOM    763  HG3 ARG A  46      40.021  76.008 -16.948  1.00  0.00           H  
ATOM    764  HD2 ARG A  46      38.230  77.253 -18.427  1.00  0.00           H  
ATOM    765  HD3 ARG A  46      38.640  78.610 -17.380  1.00  0.00           H  
ATOM    766  HE  ARG A  46      41.054  77.683 -18.194  1.00  0.00           H  
ATOM    767 HH11 ARG A  46      38.156  78.657 -19.859  1.00  0.00           H  
ATOM    768 HH12 ARG A  46      38.995  79.209 -21.270  1.00  0.00           H  
ATOM    769 HH21 ARG A  46      42.171  78.406 -20.048  1.00  0.00           H  
ATOM    770 HH22 ARG A  46      41.279  79.065 -21.377  1.00  0.00           H  
ATOM    771  N   LYS A  47      34.916  76.008 -14.487  1.00  0.00           N  
ATOM    772  CA  LYS A  47      33.556  75.484 -14.515  1.00  0.00           C  
ATOM    773  C   LYS A  47      32.683  76.180 -13.476  1.00  0.00           C  
ATOM    774  O   LYS A  47      33.158  77.022 -12.717  1.00  0.00           O  
ATOM    775  CB  LYS A  47      33.563  73.974 -14.262  1.00  0.00           C  
ATOM    776  CG  LYS A  47      32.645  73.198 -15.190  1.00  0.00           C  
ATOM    777  CD  LYS A  47      33.241  73.064 -16.581  1.00  0.00           C  
ATOM    778  CE  LYS A  47      33.961  71.736 -16.754  1.00  0.00           C  
ATOM    779  NZ  LYS A  47      35.438  71.887 -16.643  1.00  0.00           N  
ATOM    780  H   LYS A  47      35.331  76.211 -13.622  1.00  0.00           H  
ATOM    781  HA  LYS A  47      33.148  75.673 -15.496  1.00  0.00           H  
ATOM    782  HB2 LYS A  47      34.570  73.605 -14.393  1.00  0.00           H  
ATOM    783  HB3 LYS A  47      33.251  73.791 -13.244  1.00  0.00           H  
ATOM    784  HG2 LYS A  47      32.487  72.211 -14.782  1.00  0.00           H  
ATOM    785  HG3 LYS A  47      31.698  73.715 -15.262  1.00  0.00           H  
ATOM    786  HD2 LYS A  47      32.447  73.128 -17.311  1.00  0.00           H  
ATOM    787  HD3 LYS A  47      33.944  73.869 -16.741  1.00  0.00           H  
ATOM    788  HE2 LYS A  47      33.618  71.053 -15.992  1.00  0.00           H  
ATOM    789  HE3 LYS A  47      33.721  71.336 -17.729  1.00  0.00           H  
ATOM    790  HZ1 LYS A  47      35.740  71.737 -15.659  1.00  0.00           H  
ATOM    791  HZ2 LYS A  47      35.722  72.842 -16.940  1.00  0.00           H  
ATOM    792  HZ3 LYS A  47      35.915  71.191 -17.251  1.00  0.00           H  
ATOM    793  N   ALA A  48      31.403  75.821 -13.449  1.00  0.00           N  
ATOM    794  CA  ALA A  48      30.465  76.409 -12.502  1.00  0.00           C  
ATOM    795  C   ALA A  48      29.503  75.358 -11.957  1.00  0.00           C  
ATOM    796  O   ALA A  48      28.579  74.914 -12.639  1.00  0.00           O  
ATOM    797  CB  ALA A  48      29.691  77.543 -13.159  1.00  0.00           C  
ATOM    798  H   ALA A  48      31.083  75.144 -14.082  1.00  0.00           H  
ATOM    799  HA  ALA A  48      31.033  76.821 -11.681  1.00  0.00           H  
ATOM    800  HB1 ALA A  48      29.480  77.285 -14.186  1.00  0.00           H  
ATOM    801  HB2 ALA A  48      28.764  77.701 -12.628  1.00  0.00           H  
ATOM    802  HB3 ALA A  48      30.283  78.446 -13.129  1.00  0.00           H  
ATOM    803  N   PRO A  49      29.725  74.947 -10.700  1.00  0.00           N  
ATOM    804  CA  PRO A  49      30.824  75.466  -9.879  1.00  0.00           C  
ATOM    805  C   PRO A  49      32.189  75.002 -10.377  1.00  0.00           C  
ATOM    806  O   PRO A  49      32.302  74.075 -11.179  1.00  0.00           O  
ATOM    807  CB  PRO A  49      30.535  74.888  -8.492  1.00  0.00           C  
ATOM    808  CG  PRO A  49      29.740  73.655  -8.754  1.00  0.00           C  
ATOM    809  CD  PRO A  49      28.922  73.942  -9.982  1.00  0.00           C  
ATOM    810  HA  PRO A  49      30.808  76.546  -9.832  1.00  0.00           H  
ATOM    811  HB2 PRO A  49      31.466  74.660  -7.993  1.00  0.00           H  
ATOM    812  HB3 PRO A  49      29.973  75.603  -7.909  1.00  0.00           H  
ATOM    813  HG2 PRO A  49      30.403  72.822  -8.931  1.00  0.00           H  
ATOM    814  HG3 PRO A  49      29.094  73.450  -7.913  1.00  0.00           H  
ATOM    815  HD2 PRO A  49      28.804  73.047 -10.575  1.00  0.00           H  
ATOM    816  HD3 PRO A  49      27.958  74.346  -9.707  1.00  0.00           H  
ATOM    817  N   PRO A  50      33.251  75.660  -9.890  1.00  0.00           N  
ATOM    818  CA  PRO A  50      34.629  75.331 -10.271  1.00  0.00           C  
ATOM    819  C   PRO A  50      35.079  73.987  -9.709  1.00  0.00           C  
ATOM    820  O   PRO A  50      34.317  73.297  -9.033  1.00  0.00           O  
ATOM    821  CB  PRO A  50      35.448  76.468  -9.658  1.00  0.00           C  
ATOM    822  CG  PRO A  50      34.625  76.955  -8.515  1.00  0.00           C  
ATOM    823  CD  PRO A  50      33.191  76.775  -8.931  1.00  0.00           C  
ATOM    824  HA  PRO A  50      34.754  75.331 -11.344  1.00  0.00           H  
ATOM    825  HB2 PRO A  50      36.403  76.089  -9.325  1.00  0.00           H  
ATOM    826  HB3 PRO A  50      35.599  77.244 -10.394  1.00  0.00           H  
ATOM    827  HG2 PRO A  50      34.836  76.368  -7.634  1.00  0.00           H  
ATOM    828  HG3 PRO A  50      34.834  77.999  -8.331  1.00  0.00           H  
ATOM    829  HD2 PRO A  50      32.581  76.518  -8.078  1.00  0.00           H  
ATOM    830  HD3 PRO A  50      32.821  77.671  -9.406  1.00  0.00           H  
ATOM    831  N   LYS A  51      36.325  73.621  -9.993  1.00  0.00           N  
ATOM    832  CA  LYS A  51      36.881  72.360  -9.513  1.00  0.00           C  
ATOM    833  C   LYS A  51      38.155  72.597  -8.711  1.00  0.00           C  
ATOM    834  O   LYS A  51      38.807  73.631  -8.853  1.00  0.00           O  
ATOM    835  CB  LYS A  51      37.173  71.428 -10.692  1.00  0.00           C  
ATOM    836  CG  LYS A  51      35.947  70.692 -11.204  1.00  0.00           C  
ATOM    837  CD  LYS A  51      36.286  69.797 -12.385  1.00  0.00           C  
ATOM    838  CE  LYS A  51      35.236  68.715 -12.584  1.00  0.00           C  
ATOM    839  NZ  LYS A  51      35.517  67.886 -13.789  1.00  0.00           N  
ATOM    840  H   LYS A  51      36.886  74.214 -10.536  1.00  0.00           H  
ATOM    841  HA  LYS A  51      36.146  71.896  -8.873  1.00  0.00           H  
ATOM    842  HB2 LYS A  51      37.582  72.011 -11.503  1.00  0.00           H  
ATOM    843  HB3 LYS A  51      37.904  70.695 -10.382  1.00  0.00           H  
ATOM    844  HG2 LYS A  51      35.546  70.082 -10.408  1.00  0.00           H  
ATOM    845  HG3 LYS A  51      35.207  71.416 -11.514  1.00  0.00           H  
ATOM    846  HD2 LYS A  51      36.339  70.401 -13.279  1.00  0.00           H  
ATOM    847  HD3 LYS A  51      37.244  69.329 -12.207  1.00  0.00           H  
ATOM    848  HE2 LYS A  51      35.226  68.077 -11.713  1.00  0.00           H  
ATOM    849  HE3 LYS A  51      34.271  69.185 -12.697  1.00  0.00           H  
ATOM    850  HZ1 LYS A  51      34.628  67.521 -14.186  1.00  0.00           H  
ATOM    851  HZ2 LYS A  51      36.127  67.083 -13.536  1.00  0.00           H  
ATOM    852  HZ3 LYS A  51      35.997  68.457 -14.512  1.00  0.00           H  
ATOM    853  N   PHE A  52      38.506  71.630  -7.868  1.00  0.00           N  
ATOM    854  CA  PHE A  52      39.703  71.735  -7.042  1.00  0.00           C  
ATOM    855  C   PHE A  52      40.441  70.400  -6.985  1.00  0.00           C  
ATOM    856  O   PHE A  52      39.829  69.335  -7.075  1.00  0.00           O  
ATOM    857  CB  PHE A  52      39.335  72.188  -5.627  1.00  0.00           C  
ATOM    858  CG  PHE A  52      38.639  73.518  -5.587  1.00  0.00           C  
ATOM    859  CD1 PHE A  52      37.296  73.622  -5.914  1.00  0.00           C  
ATOM    860  CD2 PHE A  52      39.326  74.664  -5.222  1.00  0.00           C  
ATOM    861  CE1 PHE A  52      36.651  74.844  -5.877  1.00  0.00           C  
ATOM    862  CE2 PHE A  52      38.687  75.889  -5.183  1.00  0.00           C  
ATOM    863  CZ  PHE A  52      37.348  75.979  -5.512  1.00  0.00           C  
ATOM    864  H   PHE A  52      37.945  70.830  -7.799  1.00  0.00           H  
ATOM    865  HA  PHE A  52      40.351  72.471  -7.490  1.00  0.00           H  
ATOM    866  HB2 PHE A  52      38.679  71.456  -5.182  1.00  0.00           H  
ATOM    867  HB3 PHE A  52      40.236  72.265  -5.037  1.00  0.00           H  
ATOM    868  HD1 PHE A  52      36.750  72.733  -6.200  1.00  0.00           H  
ATOM    869  HD2 PHE A  52      40.373  74.596  -4.966  1.00  0.00           H  
ATOM    870  HE1 PHE A  52      35.605  74.910  -6.135  1.00  0.00           H  
ATOM    871  HE2 PHE A  52      39.234  76.775  -4.897  1.00  0.00           H  
ATOM    872  HZ  PHE A  52      36.847  76.935  -5.482  1.00  0.00           H  
ATOM    873  N   TYR A  53      41.759  70.466  -6.835  1.00  0.00           N  
ATOM    874  CA  TYR A  53      42.582  69.264  -6.767  1.00  0.00           C  
ATOM    875  C   TYR A  53      42.930  68.922  -5.323  1.00  0.00           C  
ATOM    876  O   TYR A  53      43.610  69.687  -4.637  1.00  0.00           O  
ATOM    877  CB  TYR A  53      43.863  69.452  -7.582  1.00  0.00           C  
ATOM    878  CG  TYR A  53      44.481  68.153  -8.046  1.00  0.00           C  
ATOM    879  CD1 TYR A  53      43.708  67.170  -8.653  1.00  0.00           C  
ATOM    880  CD2 TYR A  53      45.839  67.908  -7.879  1.00  0.00           C  
ATOM    881  CE1 TYR A  53      44.269  65.981  -9.079  1.00  0.00           C  
ATOM    882  CE2 TYR A  53      46.408  66.722  -8.303  1.00  0.00           C  
ATOM    883  CZ  TYR A  53      45.619  65.762  -8.902  1.00  0.00           C  
ATOM    884  OH  TYR A  53      46.181  64.579  -9.325  1.00  0.00           O  
ATOM    885  H   TYR A  53      42.189  71.344  -6.768  1.00  0.00           H  
ATOM    886  HA  TYR A  53      42.013  68.449  -7.191  1.00  0.00           H  
ATOM    887  HB2 TYR A  53      43.642  70.044  -8.457  1.00  0.00           H  
ATOM    888  HB3 TYR A  53      44.593  69.970  -6.977  1.00  0.00           H  
ATOM    889  HD1 TYR A  53      42.651  67.346  -8.791  1.00  0.00           H  
ATOM    890  HD2 TYR A  53      46.454  68.661  -7.410  1.00  0.00           H  
ATOM    891  HE1 TYR A  53      43.651  65.230  -9.548  1.00  0.00           H  
ATOM    892  HE2 TYR A  53      47.465  66.550  -8.163  1.00  0.00           H  
ATOM    893  HH  TYR A  53      46.741  64.746 -10.087  1.00  0.00           H  
ATOM    894  N   VAL A  54      42.460  67.766  -4.864  1.00  0.00           N  
ATOM    895  CA  VAL A  54      42.723  67.320  -3.502  1.00  0.00           C  
ATOM    896  C   VAL A  54      43.610  66.079  -3.490  1.00  0.00           C  
ATOM    897  O   VAL A  54      43.673  65.340  -4.473  1.00  0.00           O  
ATOM    898  CB  VAL A  54      41.414  67.008  -2.751  1.00  0.00           C  
ATOM    899  CG1 VAL A  54      40.667  68.292  -2.424  1.00  0.00           C  
ATOM    900  CG2 VAL A  54      40.543  66.068  -3.570  1.00  0.00           C  
ATOM    901  H   VAL A  54      41.924  67.199  -5.458  1.00  0.00           H  
ATOM    902  HA  VAL A  54      43.230  68.118  -2.981  1.00  0.00           H  
ATOM    903  HB  VAL A  54      41.664  66.515  -1.823  1.00  0.00           H  
ATOM    904 HG11 VAL A  54      40.072  68.589  -3.275  1.00  0.00           H  
ATOM    905 HG12 VAL A  54      40.024  68.127  -1.572  1.00  0.00           H  
ATOM    906 HG13 VAL A  54      41.378  69.073  -2.193  1.00  0.00           H  
ATOM    907 HG21 VAL A  54      41.049  65.122  -3.694  1.00  0.00           H  
ATOM    908 HG22 VAL A  54      39.604  65.911  -3.059  1.00  0.00           H  
ATOM    909 HG23 VAL A  54      40.354  66.505  -4.540  1.00  0.00           H  
ATOM    910  N   HIS A  55      44.294  65.858  -2.373  1.00  0.00           N  
ATOM    911  CA  HIS A  55      45.178  64.706  -2.232  1.00  0.00           C  
ATOM    912  C   HIS A  55      45.049  64.089  -0.843  1.00  0.00           C  
ATOM    913  O   HIS A  55      45.359  64.729   0.162  1.00  0.00           O  
ATOM    914  CB  HIS A  55      46.629  65.115  -2.490  1.00  0.00           C  
ATOM    915  CG  HIS A  55      47.630  64.160  -1.920  1.00  0.00           C  
ATOM    916  ND1 HIS A  55      47.510  62.790  -2.026  1.00  0.00           N  
ATOM    917  CD2 HIS A  55      48.777  64.383  -1.235  1.00  0.00           C  
ATOM    918  CE1 HIS A  55      48.538  62.212  -1.431  1.00  0.00           C  
ATOM    919  NE2 HIS A  55      49.321  63.157  -0.943  1.00  0.00           N  
ATOM    920  H   HIS A  55      44.202  66.484  -1.624  1.00  0.00           H  
ATOM    921  HA  HIS A  55      44.885  63.972  -2.967  1.00  0.00           H  
ATOM    922  HB2 HIS A  55      46.795  65.175  -3.554  1.00  0.00           H  
ATOM    923  HB3 HIS A  55      46.805  66.086  -2.047  1.00  0.00           H  
ATOM    924  HD1 HIS A  55      46.779  62.313  -2.471  1.00  0.00           H  
ATOM    925  HD2 HIS A  55      49.188  65.346  -0.967  1.00  0.00           H  
ATOM    926  HE1 HIS A  55      48.710  61.149  -1.357  1.00  0.00           H  
ATOM    927  N   TYR A  56      44.592  62.842  -0.795  1.00  0.00           N  
ATOM    928  CA  TYR A  56      44.419  62.141   0.470  1.00  0.00           C  
ATOM    929  C   TYR A  56      45.759  61.954   1.177  1.00  0.00           C  
ATOM    930  O   TYR A  56      46.582  61.135   0.768  1.00  0.00           O  
ATOM    931  CB  TYR A  56      43.761  60.780   0.238  1.00  0.00           C  
ATOM    932  CG  TYR A  56      42.363  60.874  -0.332  1.00  0.00           C  
ATOM    933  CD1 TYR A  56      41.260  61.010   0.502  1.00  0.00           C  
ATOM    934  CD2 TYR A  56      42.146  60.827  -1.704  1.00  0.00           C  
ATOM    935  CE1 TYR A  56      39.981  61.095  -0.014  1.00  0.00           C  
ATOM    936  CE2 TYR A  56      40.870  60.914  -2.228  1.00  0.00           C  
ATOM    937  CZ  TYR A  56      39.791  61.047  -1.379  1.00  0.00           C  
ATOM    938  OH  TYR A  56      38.520  61.133  -1.897  1.00  0.00           O  
ATOM    939  H   TYR A  56      44.362  62.385  -1.631  1.00  0.00           H  
ATOM    940  HA  TYR A  56      43.775  62.739   1.097  1.00  0.00           H  
ATOM    941  HB2 TYR A  56      44.361  60.210  -0.455  1.00  0.00           H  
ATOM    942  HB3 TYR A  56      43.702  60.250   1.176  1.00  0.00           H  
ATOM    943  HD1 TYR A  56      41.412  61.048   1.570  1.00  0.00           H  
ATOM    944  HD2 TYR A  56      42.992  60.722  -2.366  1.00  0.00           H  
ATOM    945  HE1 TYR A  56      39.136  61.200   0.650  1.00  0.00           H  
ATOM    946  HE2 TYR A  56      40.722  60.875  -3.297  1.00  0.00           H  
ATOM    947  HH  TYR A  56      38.367  62.022  -2.224  1.00  0.00           H  
ATOM    948  N   VAL A  57      45.970  62.721   2.242  1.00  0.00           N  
ATOM    949  CA  VAL A  57      47.208  62.641   3.008  1.00  0.00           C  
ATOM    950  C   VAL A  57      47.400  61.250   3.600  1.00  0.00           C  
ATOM    951  O   VAL A  57      48.526  60.809   3.823  1.00  0.00           O  
ATOM    952  CB  VAL A  57      47.231  63.678   4.147  1.00  0.00           C  
ATOM    953  CG1 VAL A  57      48.512  63.552   4.958  1.00  0.00           C  
ATOM    954  CG2 VAL A  57      47.080  65.085   3.589  1.00  0.00           C  
ATOM    955  H   VAL A  57      45.276  63.355   2.520  1.00  0.00           H  
ATOM    956  HA  VAL A  57      48.029  62.854   2.340  1.00  0.00           H  
ATOM    957  HB  VAL A  57      46.395  63.482   4.802  1.00  0.00           H  
ATOM    958 HG11 VAL A  57      48.539  62.585   5.439  1.00  0.00           H  
ATOM    959 HG12 VAL A  57      49.365  63.655   4.303  1.00  0.00           H  
ATOM    960 HG13 VAL A  57      48.539  64.328   5.710  1.00  0.00           H  
ATOM    961 HG21 VAL A  57      47.673  65.771   4.175  1.00  0.00           H  
ATOM    962 HG22 VAL A  57      47.417  65.103   2.563  1.00  0.00           H  
ATOM    963 HG23 VAL A  57      46.042  65.381   3.632  1.00  0.00           H  
ATOM    964  N   ASN A  58      46.290  60.561   3.851  1.00  0.00           N  
ATOM    965  CA  ASN A  58      46.336  59.218   4.417  1.00  0.00           C  
ATOM    966  C   ASN A  58      46.754  58.197   3.363  1.00  0.00           C  
ATOM    967  O   ASN A  58      47.272  57.128   3.688  1.00  0.00           O  
ATOM    968  CB  ASN A  58      44.972  58.839   4.996  1.00  0.00           C  
ATOM    969  CG  ASN A  58      44.463  59.862   5.993  1.00  0.00           C  
ATOM    970  OD1 ASN A  58      44.894  59.889   7.146  1.00  0.00           O  
ATOM    971  ND2 ASN A  58      43.542  60.711   5.552  1.00  0.00           N  
ATOM    972  H   ASN A  58      45.420  60.966   3.651  1.00  0.00           H  
ATOM    973  HA  ASN A  58      47.067  59.217   5.211  1.00  0.00           H  
ATOM    974  HB2 ASN A  58      44.255  58.762   4.191  1.00  0.00           H  
ATOM    975  HB3 ASN A  58      45.052  57.885   5.495  1.00  0.00           H  
ATOM    976 HD21 ASN A  58      43.246  60.630   4.621  1.00  0.00           H  
ATOM    977 HD22 ASN A  58      43.196  61.383   6.176  1.00  0.00           H  
ATOM    978  N   TYR A  59      46.527  58.534   2.098  1.00  0.00           N  
ATOM    979  CA  TYR A  59      46.878  57.647   0.995  1.00  0.00           C  
ATOM    980  C   TYR A  59      48.045  58.212   0.192  1.00  0.00           C  
ATOM    981  O   TYR A  59      48.622  59.237   0.552  1.00  0.00           O  
ATOM    982  CB  TYR A  59      45.670  57.435   0.080  1.00  0.00           C  
ATOM    983  CG  TYR A  59      44.530  56.698   0.744  1.00  0.00           C  
ATOM    984  CD1 TYR A  59      44.709  55.421   1.262  1.00  0.00           C  
ATOM    985  CD2 TYR A  59      43.272  57.278   0.854  1.00  0.00           C  
ATOM    986  CE1 TYR A  59      43.669  54.744   1.870  1.00  0.00           C  
ATOM    987  CE2 TYR A  59      42.226  56.609   1.461  1.00  0.00           C  
ATOM    988  CZ  TYR A  59      42.430  55.342   1.966  1.00  0.00           C  
ATOM    989  OH  TYR A  59      41.392  54.671   2.572  1.00  0.00           O  
ATOM    990  H   TYR A  59      46.110  59.399   1.901  1.00  0.00           H  
ATOM    991  HA  TYR A  59      47.170  56.696   1.415  1.00  0.00           H  
ATOM    992  HB2 TYR A  59      45.300  58.395  -0.245  1.00  0.00           H  
ATOM    993  HB3 TYR A  59      45.978  56.862  -0.783  1.00  0.00           H  
ATOM    994  HD1 TYR A  59      45.682  54.956   1.185  1.00  0.00           H  
ATOM    995  HD2 TYR A  59      43.116  58.271   0.457  1.00  0.00           H  
ATOM    996  HE1 TYR A  59      43.829  53.752   2.266  1.00  0.00           H  
ATOM    997  HE2 TYR A  59      41.256  57.077   1.537  1.00  0.00           H  
ATOM    998  HH  TYR A  59      40.811  55.303   3.001  1.00  0.00           H  
ATOM    999  N   ASN A  60      48.388  57.535  -0.899  1.00  0.00           N  
ATOM   1000  CA  ASN A  60      49.486  57.968  -1.754  1.00  0.00           C  
ATOM   1001  C   ASN A  60      49.035  59.075  -2.702  1.00  0.00           C  
ATOM   1002  O   ASN A  60      47.849  59.401  -2.775  1.00  0.00           O  
ATOM   1003  CB  ASN A  60      50.031  56.785  -2.558  1.00  0.00           C  
ATOM   1004  CG  ASN A  60      50.796  55.802  -1.694  1.00  0.00           C  
ATOM   1005  OD1 ASN A  60      51.989  55.976  -1.443  1.00  0.00           O  
ATOM   1006  ND2 ASN A  60      50.112  54.761  -1.233  1.00  0.00           N  
ATOM   1007  H   ASN A  60      47.890  56.724  -1.134  1.00  0.00           H  
ATOM   1008  HA  ASN A  60      50.270  58.351  -1.119  1.00  0.00           H  
ATOM   1009  HB2 ASN A  60      49.207  56.262  -3.021  1.00  0.00           H  
ATOM   1010  HB3 ASN A  60      50.694  57.154  -3.326  1.00  0.00           H  
ATOM   1011 HD21 ASN A  60      49.164  54.687  -1.473  1.00  0.00           H  
ATOM   1012 HD22 ASN A  60      50.581  54.111  -0.671  1.00  0.00           H  
ATOM   1013  N   LYS A  61      49.987  59.651  -3.427  1.00  0.00           N  
ATOM   1014  CA  LYS A  61      49.689  60.722  -4.371  1.00  0.00           C  
ATOM   1015  C   LYS A  61      48.880  60.195  -5.552  1.00  0.00           C  
ATOM   1016  O   LYS A  61      48.341  60.970  -6.342  1.00  0.00           O  
ATOM   1017  CB  LYS A  61      50.985  61.364  -4.872  1.00  0.00           C  
ATOM   1018  CG  LYS A  61      50.767  62.661  -5.630  1.00  0.00           C  
ATOM   1019  CD  LYS A  61      51.931  63.620  -5.441  1.00  0.00           C  
ATOM   1020  CE  LYS A  61      52.064  64.575  -6.617  1.00  0.00           C  
ATOM   1021  NZ  LYS A  61      52.774  65.827  -6.238  1.00  0.00           N  
ATOM   1022  H   LYS A  61      50.914  59.349  -3.325  1.00  0.00           H  
ATOM   1023  HA  LYS A  61      49.105  61.467  -3.854  1.00  0.00           H  
ATOM   1024  HB2 LYS A  61      51.622  61.569  -4.025  1.00  0.00           H  
ATOM   1025  HB3 LYS A  61      51.487  60.667  -5.529  1.00  0.00           H  
ATOM   1026  HG2 LYS A  61      50.665  62.440  -6.682  1.00  0.00           H  
ATOM   1027  HG3 LYS A  61      49.863  63.131  -5.269  1.00  0.00           H  
ATOM   1028  HD2 LYS A  61      51.770  64.195  -4.541  1.00  0.00           H  
ATOM   1029  HD3 LYS A  61      52.844  63.049  -5.346  1.00  0.00           H  
ATOM   1030  HE2 LYS A  61      52.615  64.082  -7.403  1.00  0.00           H  
ATOM   1031  HE3 LYS A  61      51.076  64.824  -6.974  1.00  0.00           H  
ATOM   1032  HZ1 LYS A  61      53.584  65.607  -5.624  1.00  0.00           H  
ATOM   1033  HZ2 LYS A  61      52.128  66.462  -5.727  1.00  0.00           H  
ATOM   1034  HZ3 LYS A  61      53.119  66.314  -7.089  1.00  0.00           H  
ATOM   1035  N   ARG A  62      48.800  58.874  -5.667  1.00  0.00           N  
ATOM   1036  CA  ARG A  62      48.057  58.244  -6.752  1.00  0.00           C  
ATOM   1037  C   ARG A  62      46.563  58.214  -6.441  1.00  0.00           C  
ATOM   1038  O   ARG A  62      45.763  57.725  -7.240  1.00  0.00           O  
ATOM   1039  CB  ARG A  62      48.568  56.822  -6.990  1.00  0.00           C  
ATOM   1040  CG  ARG A  62      48.417  55.910  -5.784  1.00  0.00           C  
ATOM   1041  CD  ARG A  62      49.519  54.863  -5.735  1.00  0.00           C  
ATOM   1042  NE  ARG A  62      49.466  53.958  -6.881  1.00  0.00           N  
ATOM   1043  CZ  ARG A  62      50.318  52.957  -7.067  1.00  0.00           C  
ATOM   1044  NH1 ARG A  62      51.285  52.733  -6.188  1.00  0.00           N  
ATOM   1045  NH2 ARG A  62      50.205  52.177  -8.134  1.00  0.00           N  
ATOM   1046  H   ARG A  62      49.252  58.308  -5.006  1.00  0.00           H  
ATOM   1047  HA  ARG A  62      48.215  58.829  -7.645  1.00  0.00           H  
ATOM   1048  HB2 ARG A  62      48.019  56.388  -7.813  1.00  0.00           H  
ATOM   1049  HB3 ARG A  62      49.615  56.868  -7.251  1.00  0.00           H  
ATOM   1050  HG2 ARG A  62      48.463  56.506  -4.885  1.00  0.00           H  
ATOM   1051  HG3 ARG A  62      47.461  55.411  -5.840  1.00  0.00           H  
ATOM   1052  HD2 ARG A  62      50.475  55.365  -5.731  1.00  0.00           H  
ATOM   1053  HD3 ARG A  62      49.411  54.288  -4.828  1.00  0.00           H  
ATOM   1054  HE  ARG A  62      48.759  54.105  -7.543  1.00  0.00           H  
ATOM   1055 HH11 ARG A  62      51.373  53.319  -5.382  1.00  0.00           H  
ATOM   1056 HH12 ARG A  62      51.926  51.978  -6.330  1.00  0.00           H  
ATOM   1057 HH21 ARG A  62      49.477  52.342  -8.799  1.00  0.00           H  
ATOM   1058 HH22 ARG A  62      50.847  51.424  -8.274  1.00  0.00           H  
ATOM   1059  N   LEU A  63      46.195  58.738  -5.277  1.00  0.00           N  
ATOM   1060  CA  LEU A  63      44.798  58.770  -4.861  1.00  0.00           C  
ATOM   1061  C   LEU A  63      44.185  60.144  -5.117  1.00  0.00           C  
ATOM   1062  O   LEU A  63      42.968  60.276  -5.249  1.00  0.00           O  
ATOM   1063  CB  LEU A  63      44.679  58.415  -3.378  1.00  0.00           C  
ATOM   1064  CG  LEU A  63      44.319  56.963  -3.062  1.00  0.00           C  
ATOM   1065  CD1 LEU A  63      42.987  56.593  -3.698  1.00  0.00           C  
ATOM   1066  CD2 LEU A  63      45.417  56.025  -3.539  1.00  0.00           C  
ATOM   1067  H   LEU A  63      46.879  59.111  -4.683  1.00  0.00           H  
ATOM   1068  HA  LEU A  63      44.261  58.036  -5.443  1.00  0.00           H  
ATOM   1069  HB2 LEU A  63      45.626  58.630  -2.910  1.00  0.00           H  
ATOM   1070  HB3 LEU A  63      43.915  59.047  -2.947  1.00  0.00           H  
ATOM   1071  HG  LEU A  63      44.220  56.847  -1.992  1.00  0.00           H  
ATOM   1072 HD11 LEU A  63      43.163  55.999  -4.582  1.00  0.00           H  
ATOM   1073 HD12 LEU A  63      42.455  57.493  -3.968  1.00  0.00           H  
ATOM   1074 HD13 LEU A  63      42.398  56.024  -2.993  1.00  0.00           H  
ATOM   1075 HD21 LEU A  63      46.381  56.478  -3.357  1.00  0.00           H  
ATOM   1076 HD22 LEU A  63      45.299  55.840  -4.596  1.00  0.00           H  
ATOM   1077 HD23 LEU A  63      45.351  55.090  -3.001  1.00  0.00           H  
ATOM   1078  N   ASP A  64      45.036  61.160  -5.190  1.00  0.00           N  
ATOM   1079  CA  ASP A  64      44.579  62.524  -5.434  1.00  0.00           C  
ATOM   1080  C   ASP A  64      43.678  62.583  -6.663  1.00  0.00           C  
ATOM   1081  O   ASP A  64      43.693  61.680  -7.499  1.00  0.00           O  
ATOM   1082  CB  ASP A  64      45.775  63.461  -5.617  1.00  0.00           C  
ATOM   1083  CG  ASP A  64      46.585  63.128  -6.855  1.00  0.00           C  
ATOM   1084  OD1 ASP A  64      46.300  62.092  -7.490  1.00  0.00           O  
ATOM   1085  OD2 ASP A  64      47.504  63.905  -7.188  1.00  0.00           O  
ATOM   1086  H   ASP A  64      45.995  60.991  -5.076  1.00  0.00           H  
ATOM   1087  HA  ASP A  64      44.012  62.843  -4.573  1.00  0.00           H  
ATOM   1088  HB2 ASP A  64      45.418  64.476  -5.704  1.00  0.00           H  
ATOM   1089  HB3 ASP A  64      46.420  63.382  -4.755  1.00  0.00           H  
ATOM   1090  N   GLU A  65      42.894  63.651  -6.766  1.00  0.00           N  
ATOM   1091  CA  GLU A  65      41.985  63.826  -7.893  1.00  0.00           C  
ATOM   1092  C   GLU A  65      41.343  65.210  -7.864  1.00  0.00           C  
ATOM   1093  O   GLU A  65      41.624  66.017  -6.979  1.00  0.00           O  
ATOM   1094  CB  GLU A  65      40.899  62.748  -7.872  1.00  0.00           C  
ATOM   1095  CG  GLU A  65      40.126  62.687  -6.566  1.00  0.00           C  
ATOM   1096  CD  GLU A  65      38.937  61.748  -6.635  1.00  0.00           C  
ATOM   1097  OE1 GLU A  65      39.142  60.521  -6.525  1.00  0.00           O  
ATOM   1098  OE2 GLU A  65      37.801  62.241  -6.799  1.00  0.00           O  
ATOM   1099  H   GLU A  65      42.927  64.338  -6.068  1.00  0.00           H  
ATOM   1100  HA  GLU A  65      42.560  63.727  -8.801  1.00  0.00           H  
ATOM   1101  HB2 GLU A  65      40.200  62.942  -8.673  1.00  0.00           H  
ATOM   1102  HB3 GLU A  65      41.362  61.785  -8.037  1.00  0.00           H  
ATOM   1103  HG2 GLU A  65      40.789  62.347  -5.786  1.00  0.00           H  
ATOM   1104  HG3 GLU A  65      39.769  63.678  -6.328  1.00  0.00           H  
ATOM   1105  N   TRP A  66      40.482  65.475  -8.840  1.00  0.00           N  
ATOM   1106  CA  TRP A  66      39.800  66.761  -8.928  1.00  0.00           C  
ATOM   1107  C   TRP A  66      38.368  66.655  -8.417  1.00  0.00           C  
ATOM   1108  O   TRP A  66      37.499  66.102  -9.091  1.00  0.00           O  
ATOM   1109  CB  TRP A  66      39.803  67.266 -10.372  1.00  0.00           C  
ATOM   1110  CG  TRP A  66      41.181  67.456 -10.931  1.00  0.00           C  
ATOM   1111  CD1 TRP A  66      41.989  66.493 -11.465  1.00  0.00           C  
ATOM   1112  CD2 TRP A  66      41.912  68.685 -11.010  1.00  0.00           C  
ATOM   1113  NE1 TRP A  66      43.178  67.050 -11.871  1.00  0.00           N  
ATOM   1114  CE2 TRP A  66      43.155  68.393 -11.604  1.00  0.00           C  
ATOM   1115  CE3 TRP A  66      41.635  70.004 -10.640  1.00  0.00           C  
ATOM   1116  CZ2 TRP A  66      44.119  69.370 -11.833  1.00  0.00           C  
ATOM   1117  CZ3 TRP A  66      42.594  70.974 -10.869  1.00  0.00           C  
ATOM   1118  CH2 TRP A  66      43.822  70.654 -11.461  1.00  0.00           C  
ATOM   1119  H   TRP A  66      40.299  64.790  -9.517  1.00  0.00           H  
ATOM   1120  HA  TRP A  66      40.339  67.465  -8.310  1.00  0.00           H  
ATOM   1121  HB2 TRP A  66      39.285  66.554 -10.997  1.00  0.00           H  
ATOM   1122  HB3 TRP A  66      39.291  68.217 -10.415  1.00  0.00           H  
ATOM   1123  HD1 TRP A  66      41.720  65.451 -11.547  1.00  0.00           H  
ATOM   1124  HE1 TRP A  66      43.921  66.562 -12.286  1.00  0.00           H  
ATOM   1125  HE3 TRP A  66      40.694  70.270 -10.183  1.00  0.00           H  
ATOM   1126  HZ2 TRP A  66      45.070  69.141 -12.290  1.00  0.00           H  
ATOM   1127  HZ3 TRP A  66      42.399  71.998 -10.588  1.00  0.00           H  
ATOM   1128  HH2 TRP A  66      44.541  71.443 -11.619  1.00  0.00           H  
ATOM   1129  N   ILE A  67      38.128  67.189  -7.224  1.00  0.00           N  
ATOM   1130  CA  ILE A  67      36.800  67.154  -6.625  1.00  0.00           C  
ATOM   1131  C   ILE A  67      36.078  68.484  -6.811  1.00  0.00           C  
ATOM   1132  O   ILE A  67      36.690  69.494  -7.160  1.00  0.00           O  
ATOM   1133  CB  ILE A  67      36.869  66.826  -5.121  1.00  0.00           C  
ATOM   1134  CG1 ILE A  67      37.709  67.873  -4.387  1.00  0.00           C  
ATOM   1135  CG2 ILE A  67      37.443  65.433  -4.909  1.00  0.00           C  
ATOM   1136  CD1 ILE A  67      37.526  67.850  -2.886  1.00  0.00           C  
ATOM   1137  H   ILE A  67      38.862  67.616  -6.736  1.00  0.00           H  
ATOM   1138  HA  ILE A  67      36.233  66.376  -7.117  1.00  0.00           H  
ATOM   1139  HB  ILE A  67      35.864  66.839  -4.727  1.00  0.00           H  
ATOM   1140 HG12 ILE A  67      38.752  67.699  -4.597  1.00  0.00           H  
ATOM   1141 HG13 ILE A  67      37.434  68.857  -4.740  1.00  0.00           H  
ATOM   1142 HG21 ILE A  67      36.984  64.745  -5.602  1.00  0.00           H  
ATOM   1143 HG22 ILE A  67      38.509  65.455  -5.077  1.00  0.00           H  
ATOM   1144 HG23 ILE A  67      37.244  65.112  -3.897  1.00  0.00           H  
ATOM   1145 HD11 ILE A  67      36.476  67.938  -2.650  1.00  0.00           H  
ATOM   1146 HD12 ILE A  67      37.905  66.918  -2.491  1.00  0.00           H  
ATOM   1147 HD13 ILE A  67      38.065  68.674  -2.444  1.00  0.00           H  
ATOM   1148  N   THR A  68      34.769  68.478  -6.575  1.00  0.00           N  
ATOM   1149  CA  THR A  68      33.963  69.684  -6.716  1.00  0.00           C  
ATOM   1150  C   THR A  68      33.516  70.209  -5.356  1.00  0.00           C  
ATOM   1151  O   THR A  68      33.749  69.575  -4.327  1.00  0.00           O  
ATOM   1152  CB  THR A  68      32.719  69.429  -7.589  1.00  0.00           C  
ATOM   1153  OG1 THR A  68      32.314  68.061  -7.477  1.00  0.00           O  
ATOM   1154  CG2 THR A  68      33.003  69.762  -9.046  1.00  0.00           C  
ATOM   1155  H   THR A  68      34.337  67.643  -6.300  1.00  0.00           H  
ATOM   1156  HA  THR A  68      34.569  70.436  -7.201  1.00  0.00           H  
ATOM   1157  HB  THR A  68      31.917  70.064  -7.240  1.00  0.00           H  
ATOM   1158  HG1 THR A  68      31.549  67.906  -8.036  1.00  0.00           H  
ATOM   1159 HG21 THR A  68      33.815  69.147  -9.403  1.00  0.00           H  
ATOM   1160 HG22 THR A  68      33.276  70.803  -9.131  1.00  0.00           H  
ATOM   1161 HG23 THR A  68      32.121  69.570  -9.637  1.00  0.00           H  
ATOM   1162  N   THR A  69      32.872  71.372  -5.359  1.00  0.00           N  
ATOM   1163  CA  THR A  69      32.393  71.983  -4.125  1.00  0.00           C  
ATOM   1164  C   THR A  69      31.483  71.030  -3.357  1.00  0.00           C  
ATOM   1165  O   THR A  69      31.565  70.931  -2.132  1.00  0.00           O  
ATOM   1166  CB  THR A  69      31.627  73.289  -4.405  1.00  0.00           C  
ATOM   1167  OG1 THR A  69      30.418  73.005  -5.119  1.00  0.00           O  
ATOM   1168  CG2 THR A  69      32.482  74.256  -5.211  1.00  0.00           C  
ATOM   1169  H   THR A  69      32.716  71.830  -6.210  1.00  0.00           H  
ATOM   1170  HA  THR A  69      33.251  72.217  -3.513  1.00  0.00           H  
ATOM   1171  HB  THR A  69      31.378  73.753  -3.461  1.00  0.00           H  
ATOM   1172  HG1 THR A  69      30.594  72.348  -5.797  1.00  0.00           H  
ATOM   1173 HG21 THR A  69      33.461  74.329  -4.762  1.00  0.00           H  
ATOM   1174 HG22 THR A  69      32.016  75.230  -5.217  1.00  0.00           H  
ATOM   1175 HG23 THR A  69      32.577  73.894  -6.224  1.00  0.00           H  
ATOM   1176  N   ASP A  70      30.620  70.329  -4.083  1.00  0.00           N  
ATOM   1177  CA  ASP A  70      29.697  69.382  -3.469  1.00  0.00           C  
ATOM   1178  C   ASP A  70      30.450  68.198  -2.870  1.00  0.00           C  
ATOM   1179  O   ASP A  70      29.889  67.416  -2.104  1.00  0.00           O  
ATOM   1180  CB  ASP A  70      28.681  68.886  -4.499  1.00  0.00           C  
ATOM   1181  CG  ASP A  70      27.561  69.881  -4.733  1.00  0.00           C  
ATOM   1182  OD1 ASP A  70      27.763  71.080  -4.449  1.00  0.00           O  
ATOM   1183  OD2 ASP A  70      26.482  69.460  -5.200  1.00  0.00           O  
ATOM   1184  H   ASP A  70      30.603  70.451  -5.056  1.00  0.00           H  
ATOM   1185  HA  ASP A  70      29.171  69.895  -2.678  1.00  0.00           H  
ATOM   1186  HB2 ASP A  70      29.185  68.714  -5.439  1.00  0.00           H  
ATOM   1187  HB3 ASP A  70      28.249  67.959  -4.153  1.00  0.00           H  
ATOM   1188  N   ARG A  71      31.725  68.074  -3.227  1.00  0.00           N  
ATOM   1189  CA  ARG A  71      32.555  66.984  -2.726  1.00  0.00           C  
ATOM   1190  C   ARG A  71      33.432  67.456  -1.570  1.00  0.00           C  
ATOM   1191  O   ARG A  71      34.206  66.680  -1.008  1.00  0.00           O  
ATOM   1192  CB  ARG A  71      33.430  66.425  -3.849  1.00  0.00           C  
ATOM   1193  CG  ARG A  71      32.649  65.669  -4.911  1.00  0.00           C  
ATOM   1194  CD  ARG A  71      33.518  64.638  -5.613  1.00  0.00           C  
ATOM   1195  NE  ARG A  71      32.741  63.789  -6.513  1.00  0.00           N  
ATOM   1196  CZ  ARG A  71      32.031  62.742  -6.106  1.00  0.00           C  
ATOM   1197  NH1 ARG A  71      32.000  62.418  -4.822  1.00  0.00           N  
ATOM   1198  NH2 ARG A  71      31.351  62.019  -6.987  1.00  0.00           N  
ATOM   1199  H   ARG A  71      32.116  68.729  -3.841  1.00  0.00           H  
ATOM   1200  HA  ARG A  71      31.899  66.204  -2.370  1.00  0.00           H  
ATOM   1201  HB2 ARG A  71      33.948  67.243  -4.328  1.00  0.00           H  
ATOM   1202  HB3 ARG A  71      34.157  65.751  -3.420  1.00  0.00           H  
ATOM   1203  HG2 ARG A  71      31.818  65.165  -4.443  1.00  0.00           H  
ATOM   1204  HG3 ARG A  71      32.280  66.373  -5.642  1.00  0.00           H  
ATOM   1205  HD2 ARG A  71      34.276  65.152  -6.184  1.00  0.00           H  
ATOM   1206  HD3 ARG A  71      33.990  64.016  -4.866  1.00  0.00           H  
ATOM   1207  HE  ARG A  71      32.751  64.011  -7.467  1.00  0.00           H  
ATOM   1208 HH11 ARG A  71      32.511  62.961  -4.156  1.00  0.00           H  
ATOM   1209 HH12 ARG A  71      31.464  61.629  -4.519  1.00  0.00           H  
ATOM   1210 HH21 ARG A  71      31.371  62.262  -7.957  1.00  0.00           H  
ATOM   1211 HH22 ARG A  71      30.817  61.232  -6.680  1.00  0.00           H  
ATOM   1212  N   ILE A  72      33.305  68.732  -1.220  1.00  0.00           N  
ATOM   1213  CA  ILE A  72      34.085  69.306  -0.131  1.00  0.00           C  
ATOM   1214  C   ILE A  72      33.262  69.389   1.150  1.00  0.00           C  
ATOM   1215  O   ILE A  72      32.067  69.675   1.115  1.00  0.00           O  
ATOM   1216  CB  ILE A  72      34.600  70.712  -0.488  1.00  0.00           C  
ATOM   1217  CG1 ILE A  72      35.477  70.654  -1.740  1.00  0.00           C  
ATOM   1218  CG2 ILE A  72      35.375  71.305   0.680  1.00  0.00           C  
ATOM   1219  CD1 ILE A  72      35.607  71.985  -2.450  1.00  0.00           C  
ATOM   1220  H   ILE A  72      32.671  69.300  -1.705  1.00  0.00           H  
ATOM   1221  HA  ILE A  72      34.937  68.664   0.042  1.00  0.00           H  
ATOM   1222  HB  ILE A  72      33.749  71.345  -0.682  1.00  0.00           H  
ATOM   1223 HG12 ILE A  72      36.468  70.328  -1.465  1.00  0.00           H  
ATOM   1224 HG13 ILE A  72      35.050  69.948  -2.437  1.00  0.00           H  
ATOM   1225 HG21 ILE A  72      36.008  70.545   1.115  1.00  0.00           H  
ATOM   1226 HG22 ILE A  72      35.986  72.122   0.328  1.00  0.00           H  
ATOM   1227 HG23 ILE A  72      34.682  71.667   1.425  1.00  0.00           H  
ATOM   1228 HD11 ILE A  72      36.502  72.487  -2.110  1.00  0.00           H  
ATOM   1229 HD12 ILE A  72      35.670  71.821  -3.515  1.00  0.00           H  
ATOM   1230 HD13 ILE A  72      34.745  72.596  -2.229  1.00  0.00           H  
ATOM   1231  N   ASN A  73      33.912  69.138   2.283  1.00  0.00           N  
ATOM   1232  CA  ASN A  73      33.241  69.186   3.576  1.00  0.00           C  
ATOM   1233  C   ASN A  73      33.520  70.508   4.285  1.00  0.00           C  
ATOM   1234  O   ASN A  73      34.613  70.725   4.809  1.00  0.00           O  
ATOM   1235  CB  ASN A  73      33.696  68.017   4.453  1.00  0.00           C  
ATOM   1236  CG  ASN A  73      33.402  66.671   3.821  1.00  0.00           C  
ATOM   1237  OD1 ASN A  73      33.764  66.420   2.672  1.00  0.00           O  
ATOM   1238  ND2 ASN A  73      32.741  65.797   4.571  1.00  0.00           N  
ATOM   1239  H   ASN A  73      34.866  68.915   2.247  1.00  0.00           H  
ATOM   1240  HA  ASN A  73      32.179  69.101   3.402  1.00  0.00           H  
ATOM   1241  HB2 ASN A  73      34.761  68.092   4.617  1.00  0.00           H  
ATOM   1242  HB3 ASN A  73      33.185  68.068   5.403  1.00  0.00           H  
ATOM   1243 HD21 ASN A  73      32.484  66.065   5.478  1.00  0.00           H  
ATOM   1244 HD22 ASN A  73      32.538  64.918   4.188  1.00  0.00           H  
ATOM   1245  N   LEU A  74      32.524  71.387   4.299  1.00  0.00           N  
ATOM   1246  CA  LEU A  74      32.662  72.687   4.944  1.00  0.00           C  
ATOM   1247  C   LEU A  74      32.136  72.643   6.375  1.00  0.00           C  
ATOM   1248  O   LEU A  74      31.818  73.677   6.963  1.00  0.00           O  
ATOM   1249  CB  LEU A  74      31.911  73.756   4.147  1.00  0.00           C  
ATOM   1250  CG  LEU A  74      32.615  74.276   2.893  1.00  0.00           C  
ATOM   1251  CD1 LEU A  74      31.734  75.277   2.162  1.00  0.00           C  
ATOM   1252  CD2 LEU A  74      33.953  74.906   3.255  1.00  0.00           C  
ATOM   1253  H   LEU A  74      31.677  71.157   3.865  1.00  0.00           H  
ATOM   1254  HA  LEU A  74      33.712  72.938   4.966  1.00  0.00           H  
ATOM   1255  HB2 LEU A  74      30.963  73.338   3.844  1.00  0.00           H  
ATOM   1256  HB3 LEU A  74      31.738  74.597   4.803  1.00  0.00           H  
ATOM   1257  HG  LEU A  74      32.805  73.448   2.224  1.00  0.00           H  
ATOM   1258 HD11 LEU A  74      30.907  74.759   1.700  1.00  0.00           H  
ATOM   1259 HD12 LEU A  74      32.314  75.780   1.402  1.00  0.00           H  
ATOM   1260 HD13 LEU A  74      31.356  76.005   2.865  1.00  0.00           H  
ATOM   1261 HD21 LEU A  74      34.083  75.821   2.698  1.00  0.00           H  
ATOM   1262 HD22 LEU A  74      34.751  74.219   3.011  1.00  0.00           H  
ATOM   1263 HD23 LEU A  74      33.975  75.121   4.314  1.00  0.00           H  
ATOM   1264  N   ASP A  75      32.051  71.440   6.932  1.00  0.00           N  
ATOM   1265  CA  ASP A  75      31.567  71.261   8.296  1.00  0.00           C  
ATOM   1266  C   ASP A  75      32.732  71.081   9.265  1.00  0.00           C  
ATOM   1267  O   ASP A  75      32.596  71.313  10.466  1.00  0.00           O  
ATOM   1268  CB  ASP A  75      30.633  70.054   8.373  1.00  0.00           C  
ATOM   1269  CG  ASP A  75      29.702  70.118   9.569  1.00  0.00           C  
ATOM   1270  OD1 ASP A  75      29.104  71.191   9.798  1.00  0.00           O  
ATOM   1271  OD2 ASP A  75      29.571  69.097  10.276  1.00  0.00           O  
ATOM   1272  H   ASP A  75      32.319  70.653   6.412  1.00  0.00           H  
ATOM   1273  HA  ASP A  75      31.019  72.148   8.573  1.00  0.00           H  
ATOM   1274  HB2 ASP A  75      30.032  70.012   7.476  1.00  0.00           H  
ATOM   1275  HB3 ASP A  75      31.223  69.152   8.448  1.00  0.00           H  
ATOM   1276  N   LYS A  76      33.878  70.665   8.736  1.00  0.00           N  
ATOM   1277  CA  LYS A  76      35.066  70.454   9.552  1.00  0.00           C  
ATOM   1278  C   LYS A  76      36.020  71.639   9.440  1.00  0.00           C  
ATOM   1279  O   LYS A  76      36.156  72.239   8.375  1.00  0.00           O  
ATOM   1280  CB  LYS A  76      35.781  69.169   9.127  1.00  0.00           C  
ATOM   1281  CG  LYS A  76      35.267  67.926   9.832  1.00  0.00           C  
ATOM   1282  CD  LYS A  76      33.976  67.424   9.208  1.00  0.00           C  
ATOM   1283  CE  LYS A  76      33.608  66.041   9.723  1.00  0.00           C  
ATOM   1284  NZ  LYS A  76      32.135  65.828   9.739  1.00  0.00           N  
ATOM   1285  H   LYS A  76      33.924  70.496   7.770  1.00  0.00           H  
ATOM   1286  HA  LYS A  76      34.751  70.358  10.580  1.00  0.00           H  
ATOM   1287  HB2 LYS A  76      35.650  69.033   8.063  1.00  0.00           H  
ATOM   1288  HB3 LYS A  76      36.835  69.269   9.342  1.00  0.00           H  
ATOM   1289  HG2 LYS A  76      36.014  67.148   9.762  1.00  0.00           H  
ATOM   1290  HG3 LYS A  76      35.087  68.161  10.872  1.00  0.00           H  
ATOM   1291  HD2 LYS A  76      33.178  68.110   9.453  1.00  0.00           H  
ATOM   1292  HD3 LYS A  76      34.098  67.378   8.136  1.00  0.00           H  
ATOM   1293  HE2 LYS A  76      34.064  65.300   9.084  1.00  0.00           H  
ATOM   1294  HE3 LYS A  76      33.990  65.932  10.727  1.00  0.00           H  
ATOM   1295  HZ1 LYS A  76      31.921  64.814   9.835  1.00  0.00           H  
ATOM   1296  HZ2 LYS A  76      31.713  66.178   8.855  1.00  0.00           H  
ATOM   1297  HZ3 LYS A  76      31.708  66.339  10.538  1.00  0.00           H  
ATOM   1298  N   GLU A  77      36.680  71.968  10.547  1.00  0.00           N  
ATOM   1299  CA  GLU A  77      37.621  73.081  10.571  1.00  0.00           C  
ATOM   1300  C   GLU A  77      38.637  72.960   9.439  1.00  0.00           C  
ATOM   1301  O   GLU A  77      39.014  71.857   9.044  1.00  0.00           O  
ATOM   1302  CB  GLU A  77      38.346  73.136  11.918  1.00  0.00           C  
ATOM   1303  CG  GLU A  77      37.411  73.233  13.110  1.00  0.00           C  
ATOM   1304  CD  GLU A  77      38.139  73.111  14.434  1.00  0.00           C  
ATOM   1305  OE1 GLU A  77      38.496  71.977  14.812  1.00  0.00           O  
ATOM   1306  OE2 GLU A  77      38.350  74.151  15.094  1.00  0.00           O  
ATOM   1307  H   GLU A  77      36.528  71.452  11.365  1.00  0.00           H  
ATOM   1308  HA  GLU A  77      37.060  73.994  10.439  1.00  0.00           H  
ATOM   1309  HB2 GLU A  77      38.945  72.243  12.027  1.00  0.00           H  
ATOM   1310  HB3 GLU A  77      38.999  73.997  11.927  1.00  0.00           H  
ATOM   1311  HG2 GLU A  77      36.908  74.189  13.079  1.00  0.00           H  
ATOM   1312  HG3 GLU A  77      36.680  72.441  13.043  1.00  0.00           H  
ATOM   1313  N   VAL A  78      39.075  74.103   8.919  1.00  0.00           N  
ATOM   1314  CA  VAL A  78      40.046  74.126   7.832  1.00  0.00           C  
ATOM   1315  C   VAL A  78      41.439  74.474   8.347  1.00  0.00           C  
ATOM   1316  O   VAL A  78      41.589  75.283   9.262  1.00  0.00           O  
ATOM   1317  CB  VAL A  78      39.645  75.139   6.743  1.00  0.00           C  
ATOM   1318  CG1 VAL A  78      40.704  75.197   5.653  1.00  0.00           C  
ATOM   1319  CG2 VAL A  78      38.286  74.783   6.160  1.00  0.00           C  
ATOM   1320  H   VAL A  78      38.737  74.951   9.276  1.00  0.00           H  
ATOM   1321  HA  VAL A  78      40.072  73.142   7.386  1.00  0.00           H  
ATOM   1322  HB  VAL A  78      39.575  76.116   7.198  1.00  0.00           H  
ATOM   1323 HG11 VAL A  78      40.893  74.199   5.282  1.00  0.00           H  
ATOM   1324 HG12 VAL A  78      40.355  75.822   4.844  1.00  0.00           H  
ATOM   1325 HG13 VAL A  78      41.616  75.608   6.058  1.00  0.00           H  
ATOM   1326 HG21 VAL A  78      38.233  73.719   5.990  1.00  0.00           H  
ATOM   1327 HG22 VAL A  78      37.510  75.078   6.851  1.00  0.00           H  
ATOM   1328 HG23 VAL A  78      38.149  75.304   5.223  1.00  0.00           H  
ATOM   1329  N   LEU A  79      42.453  73.857   7.752  1.00  0.00           N  
ATOM   1330  CA  LEU A  79      43.836  74.101   8.150  1.00  0.00           C  
ATOM   1331  C   LEU A  79      44.540  75.006   7.144  1.00  0.00           C  
ATOM   1332  O   LEU A  79      44.532  74.740   5.942  1.00  0.00           O  
ATOM   1333  CB  LEU A  79      44.592  72.777   8.279  1.00  0.00           C  
ATOM   1334  CG  LEU A  79      44.821  72.271   9.703  1.00  0.00           C  
ATOM   1335  CD1 LEU A  79      45.816  73.160  10.432  1.00  0.00           C  
ATOM   1336  CD2 LEU A  79      43.505  72.205  10.464  1.00  0.00           C  
ATOM   1337  H   LEU A  79      42.270  73.222   7.028  1.00  0.00           H  
ATOM   1338  HA  LEU A  79      43.822  74.593   9.111  1.00  0.00           H  
ATOM   1339  HB2 LEU A  79      44.031  72.024   7.746  1.00  0.00           H  
ATOM   1340  HB3 LEU A  79      45.558  72.902   7.811  1.00  0.00           H  
ATOM   1341  HG  LEU A  79      45.234  71.272   9.661  1.00  0.00           H  
ATOM   1342 HD11 LEU A  79      46.707  73.270   9.831  1.00  0.00           H  
ATOM   1343 HD12 LEU A  79      46.075  72.710  11.379  1.00  0.00           H  
ATOM   1344 HD13 LEU A  79      45.374  74.130  10.602  1.00  0.00           H  
ATOM   1345 HD21 LEU A  79      43.401  73.087  11.080  1.00  0.00           H  
ATOM   1346 HD22 LEU A  79      43.495  71.325  11.090  1.00  0.00           H  
ATOM   1347 HD23 LEU A  79      42.685  72.157   9.762  1.00  0.00           H  
ATOM   1348  N   TYR A  80      45.150  76.074   7.644  1.00  0.00           N  
ATOM   1349  CA  TYR A  80      45.859  77.019   6.789  1.00  0.00           C  
ATOM   1350  C   TYR A  80      47.324  77.132   7.200  1.00  0.00           C  
ATOM   1351  O   TYR A  80      47.700  76.848   8.337  1.00  0.00           O  
ATOM   1352  CB  TYR A  80      45.193  78.394   6.850  1.00  0.00           C  
ATOM   1353  CG  TYR A  80      43.880  78.465   6.104  1.00  0.00           C  
ATOM   1354  CD1 TYR A  80      43.843  78.786   4.753  1.00  0.00           C  
ATOM   1355  CD2 TYR A  80      42.676  78.209   6.749  1.00  0.00           C  
ATOM   1356  CE1 TYR A  80      42.646  78.853   4.067  1.00  0.00           C  
ATOM   1357  CE2 TYR A  80      41.474  78.272   6.071  1.00  0.00           C  
ATOM   1358  CZ  TYR A  80      41.464  78.594   4.730  1.00  0.00           C  
ATOM   1359  OH  TYR A  80      40.269  78.658   4.050  1.00  0.00           O  
ATOM   1360  H   TYR A  80      45.122  76.233   8.610  1.00  0.00           H  
ATOM   1361  HA  TYR A  80      45.809  76.651   5.775  1.00  0.00           H  
ATOM   1362  HB2 TYR A  80      45.000  78.648   7.881  1.00  0.00           H  
ATOM   1363  HB3 TYR A  80      45.859  79.130   6.422  1.00  0.00           H  
ATOM   1364  HD1 TYR A  80      44.770  78.988   4.236  1.00  0.00           H  
ATOM   1365  HD2 TYR A  80      42.687  77.957   7.800  1.00  0.00           H  
ATOM   1366  HE1 TYR A  80      42.637  79.105   3.016  1.00  0.00           H  
ATOM   1367  HE2 TYR A  80      40.549  78.071   6.590  1.00  0.00           H  
ATOM   1368  HH  TYR A  80      40.175  77.880   3.496  1.00  0.00           H  
ATOM   1369  N   PRO A  81      48.172  77.560   6.253  1.00  0.00           N  
ATOM   1370  CA  PRO A  81      49.609  77.722   6.492  1.00  0.00           C  
ATOM   1371  C   PRO A  81      49.913  78.888   7.428  1.00  0.00           C  
ATOM   1372  O   PRO A  81      49.083  79.778   7.619  1.00  0.00           O  
ATOM   1373  CB  PRO A  81      50.172  77.998   5.095  1.00  0.00           C  
ATOM   1374  CG  PRO A  81      49.030  78.579   4.334  1.00  0.00           C  
ATOM   1375  CD  PRO A  81      47.793  77.918   4.875  1.00  0.00           C  
ATOM   1376  HA  PRO A  81      50.050  76.820   6.888  1.00  0.00           H  
ATOM   1377  HB2 PRO A  81      50.995  78.694   5.168  1.00  0.00           H  
ATOM   1378  HB3 PRO A  81      50.512  77.074   4.652  1.00  0.00           H  
ATOM   1379  HG2 PRO A  81      48.987  79.645   4.495  1.00  0.00           H  
ATOM   1380  HG3 PRO A  81      49.142  78.361   3.283  1.00  0.00           H  
ATOM   1381  HD2 PRO A  81      46.964  78.609   4.871  1.00  0.00           H  
ATOM   1382  HD3 PRO A  81      47.554  77.035   4.301  1.00  0.00           H  
ATOM   1383  N   LYS A  82      51.107  78.878   8.009  1.00  0.00           N  
ATOM   1384  CA  LYS A  82      51.522  79.934   8.924  1.00  0.00           C  
ATOM   1385  C   LYS A  82      52.507  80.884   8.248  1.00  0.00           C  
ATOM   1386  O   LYS A  82      53.321  80.466   7.423  1.00  0.00           O  
ATOM   1387  CB  LYS A  82      52.159  79.330  10.178  1.00  0.00           C  
ATOM   1388  CG  LYS A  82      52.690  80.368  11.151  1.00  0.00           C  
ATOM   1389  CD  LYS A  82      52.387  79.990  12.590  1.00  0.00           C  
ATOM   1390  CE  LYS A  82      52.587  81.169  13.531  1.00  0.00           C  
ATOM   1391  NZ  LYS A  82      51.643  82.282  13.235  1.00  0.00           N  
ATOM   1392  H   LYS A  82      51.726  78.142   7.817  1.00  0.00           H  
ATOM   1393  HA  LYS A  82      50.642  80.491   9.210  1.00  0.00           H  
ATOM   1394  HB2 LYS A  82      51.419  78.733  10.690  1.00  0.00           H  
ATOM   1395  HB3 LYS A  82      52.980  78.694   9.880  1.00  0.00           H  
ATOM   1396  HG2 LYS A  82      53.760  80.450  11.029  1.00  0.00           H  
ATOM   1397  HG3 LYS A  82      52.227  81.321  10.934  1.00  0.00           H  
ATOM   1398  HD2 LYS A  82      51.361  79.660  12.660  1.00  0.00           H  
ATOM   1399  HD3 LYS A  82      53.046  79.187  12.889  1.00  0.00           H  
ATOM   1400  HE2 LYS A  82      52.430  80.835  14.545  1.00  0.00           H  
ATOM   1401  HE3 LYS A  82      53.599  81.530  13.424  1.00  0.00           H  
ATOM   1402  HZ1 LYS A  82      52.063  82.932  12.541  1.00  0.00           H  
ATOM   1403  HZ2 LYS A  82      51.430  82.809  14.106  1.00  0.00           H  
ATOM   1404  HZ3 LYS A  82      50.755  81.903  12.847  1.00  0.00           H  
ATOM   1405  N   LEU A  83      52.429  82.161   8.603  1.00  0.00           N  
ATOM   1406  CA  LEU A  83      53.314  83.170   8.033  1.00  0.00           C  
ATOM   1407  C   LEU A  83      54.008  83.970   9.130  1.00  0.00           C  
ATOM   1408  O   LEU A  83      53.377  84.396  10.097  1.00  0.00           O  
ATOM   1409  CB  LEU A  83      52.525  84.112   7.121  1.00  0.00           C  
ATOM   1410  CG  LEU A  83      51.804  83.458   5.942  1.00  0.00           C  
ATOM   1411  CD1 LEU A  83      50.782  84.413   5.345  1.00  0.00           C  
ATOM   1412  CD2 LEU A  83      52.805  83.015   4.884  1.00  0.00           C  
ATOM   1413  H   LEU A  83      51.759  82.434   9.266  1.00  0.00           H  
ATOM   1414  HA  LEU A  83      54.063  82.660   7.447  1.00  0.00           H  
ATOM   1415  HB2 LEU A  83      51.783  84.613   7.725  1.00  0.00           H  
ATOM   1416  HB3 LEU A  83      53.216  84.843   6.724  1.00  0.00           H  
ATOM   1417  HG  LEU A  83      51.276  82.582   6.292  1.00  0.00           H  
ATOM   1418 HD11 LEU A  83      50.930  85.401   5.754  1.00  0.00           H  
ATOM   1419 HD12 LEU A  83      49.787  84.070   5.582  1.00  0.00           H  
ATOM   1420 HD13 LEU A  83      50.905  84.445   4.271  1.00  0.00           H  
ATOM   1421 HD21 LEU A  83      53.788  82.940   5.327  1.00  0.00           H  
ATOM   1422 HD22 LEU A  83      52.825  83.739   4.083  1.00  0.00           H  
ATOM   1423 HD23 LEU A  83      52.512  82.052   4.493  1.00  0.00           H  
ATOM   1424  N   LYS A  84      55.313  84.170   8.974  1.00  0.00           N  
ATOM   1425  CA  LYS A  84      56.094  84.922   9.949  1.00  0.00           C  
ATOM   1426  C   LYS A  84      57.160  85.766   9.258  1.00  0.00           C  
ATOM   1427  O   LYS A  84      57.806  85.314   8.313  1.00  0.00           O  
ATOM   1428  CB  LYS A  84      56.751  83.969  10.950  1.00  0.00           C  
ATOM   1429  CG  LYS A  84      57.513  84.679  12.056  1.00  0.00           C  
ATOM   1430  CD  LYS A  84      56.608  85.011  13.231  1.00  0.00           C  
ATOM   1431  CE  LYS A  84      56.340  83.786  14.091  1.00  0.00           C  
ATOM   1432  NZ  LYS A  84      55.781  84.154  15.421  1.00  0.00           N  
ATOM   1433  H   LYS A  84      55.761  83.805   8.182  1.00  0.00           H  
ATOM   1434  HA  LYS A  84      55.420  85.578  10.479  1.00  0.00           H  
ATOM   1435  HB2 LYS A  84      55.985  83.358  11.404  1.00  0.00           H  
ATOM   1436  HB3 LYS A  84      57.442  83.329  10.420  1.00  0.00           H  
ATOM   1437  HG2 LYS A  84      58.311  84.038  12.400  1.00  0.00           H  
ATOM   1438  HG3 LYS A  84      57.929  85.596  11.663  1.00  0.00           H  
ATOM   1439  HD2 LYS A  84      57.085  85.765  13.838  1.00  0.00           H  
ATOM   1440  HD3 LYS A  84      55.669  85.389  12.855  1.00  0.00           H  
ATOM   1441  HE2 LYS A  84      55.635  83.150  13.579  1.00  0.00           H  
ATOM   1442  HE3 LYS A  84      57.268  83.253  14.235  1.00  0.00           H  
ATOM   1443  HZ1 LYS A  84      54.749  84.263  15.359  1.00  0.00           H  
ATOM   1444  HZ2 LYS A  84      56.195  85.052  15.746  1.00  0.00           H  
ATOM   1445  HZ3 LYS A  84      56.000  83.413  16.118  1.00  0.00           H  
ATOM   1446  N   ALA A  85      57.340  86.991   9.737  1.00  0.00           N  
ATOM   1447  CA  ALA A  85      58.331  87.896   9.168  1.00  0.00           C  
ATOM   1448  C   ALA A  85      59.745  87.366   9.380  1.00  0.00           C  
ATOM   1449  O   ALA A  85      60.231  87.294  10.510  1.00  0.00           O  
ATOM   1450  CB  ALA A  85      58.191  89.284   9.776  1.00  0.00           C  
ATOM   1451  H   ALA A  85      56.796  87.294  10.493  1.00  0.00           H  
ATOM   1452  HA  ALA A  85      58.142  87.974   8.107  1.00  0.00           H  
ATOM   1453  HB1 ALA A  85      57.832  89.196  10.792  1.00  0.00           H  
ATOM   1454  HB2 ALA A  85      59.151  89.778   9.774  1.00  0.00           H  
ATOM   1455  HB3 ALA A  85      57.487  89.862   9.195  1.00  0.00           H  
ATOM   1456  N   THR A  86      60.403  86.993   8.286  1.00  0.00           N  
ATOM   1457  CA  THR A  86      61.761  86.467   8.352  1.00  0.00           C  
ATOM   1458  C   THR A  86      62.644  87.089   7.276  1.00  0.00           C  
ATOM   1459  O   THR A  86      62.420  86.887   6.083  1.00  0.00           O  
ATOM   1460  CB  THR A  86      61.778  84.936   8.192  1.00  0.00           C  
ATOM   1461  OG1 THR A  86      60.594  84.370   8.766  1.00  0.00           O  
ATOM   1462  CG2 THR A  86      63.006  84.335   8.860  1.00  0.00           C  
ATOM   1463  H   THR A  86      59.963  87.074   7.415  1.00  0.00           H  
ATOM   1464  HA  THR A  86      62.166  86.712   9.323  1.00  0.00           H  
ATOM   1465  HB  THR A  86      61.808  84.699   7.138  1.00  0.00           H  
ATOM   1466  HG1 THR A  86      60.762  83.457   9.013  1.00  0.00           H  
ATOM   1467 HG21 THR A  86      63.838  85.017   8.760  1.00  0.00           H  
ATOM   1468 HG22 THR A  86      63.251  83.396   8.386  1.00  0.00           H  
ATOM   1469 HG23 THR A  86      62.802  84.169   9.907  1.00  0.00           H  
ATOM   1470  N   ASP A  87      63.648  87.845   7.706  1.00  0.00           N  
ATOM   1471  CA  ASP A  87      64.568  88.495   6.780  1.00  0.00           C  
ATOM   1472  C   ASP A  87      65.948  87.848   6.840  1.00  0.00           C  
ATOM   1473  O   ASP A  87      66.934  88.499   7.181  1.00  0.00           O  
ATOM   1474  CB  ASP A  87      64.676  89.987   7.097  1.00  0.00           C  
ATOM   1475  CG  ASP A  87      65.456  90.748   6.043  1.00  0.00           C  
ATOM   1476  OD1 ASP A  87      65.015  90.762   4.874  1.00  0.00           O  
ATOM   1477  OD2 ASP A  87      66.505  91.330   6.387  1.00  0.00           O  
ATOM   1478  H   ASP A  87      63.775  87.967   8.671  1.00  0.00           H  
ATOM   1479  HA  ASP A  87      64.172  88.376   5.782  1.00  0.00           H  
ATOM   1480  HB2 ASP A  87      63.683  90.408   7.158  1.00  0.00           H  
ATOM   1481  HB3 ASP A  87      65.174  90.110   8.047  1.00  0.00           H  
ATOM   1482  N   GLU A  88      66.008  86.563   6.506  1.00  0.00           N  
ATOM   1483  CA  GLU A  88      67.268  85.828   6.523  1.00  0.00           C  
ATOM   1484  C   GLU A  88      67.757  85.550   5.105  1.00  0.00           C  
ATOM   1485  O   GLU A  88      67.092  85.899   4.128  1.00  0.00           O  
ATOM   1486  CB  GLU A  88      67.105  84.511   7.286  1.00  0.00           C  
ATOM   1487  CG  GLU A  88      67.088  84.680   8.795  1.00  0.00           C  
ATOM   1488  CD  GLU A  88      67.319  83.374   9.531  1.00  0.00           C  
ATOM   1489  OE1 GLU A  88      68.202  82.601   9.102  1.00  0.00           O  
ATOM   1490  OE2 GLU A  88      66.619  83.125  10.534  1.00  0.00           O  
ATOM   1491  H   GLU A  88      65.187  86.097   6.240  1.00  0.00           H  
ATOM   1492  HA  GLU A  88      68.001  86.438   7.030  1.00  0.00           H  
ATOM   1493  HB2 GLU A  88      66.177  84.047   6.984  1.00  0.00           H  
ATOM   1494  HB3 GLU A  88      67.924  83.856   7.027  1.00  0.00           H  
ATOM   1495  HG2 GLU A  88      67.864  85.375   9.076  1.00  0.00           H  
ATOM   1496  HG3 GLU A  88      66.128  85.076   9.089  1.00  0.00           H  
ATOM   1497  N   ASP A  89      68.921  84.920   4.999  1.00  0.00           N  
ATOM   1498  CA  ASP A  89      69.499  84.594   3.700  1.00  0.00           C  
ATOM   1499  C   ASP A  89      70.012  83.157   3.679  1.00  0.00           C  
ATOM   1500  O   ASP A  89      70.998  82.830   4.342  1.00  0.00           O  
ATOM   1501  CB  ASP A  89      70.637  85.561   3.367  1.00  0.00           C  
ATOM   1502  CG  ASP A  89      71.510  85.060   2.234  1.00  0.00           C  
ATOM   1503  OD1 ASP A  89      70.978  84.853   1.123  1.00  0.00           O  
ATOM   1504  OD2 ASP A  89      72.724  84.875   2.457  1.00  0.00           O  
ATOM   1505  H   ASP A  89      69.403  84.667   5.814  1.00  0.00           H  
ATOM   1506  HA  ASP A  89      68.724  84.697   2.956  1.00  0.00           H  
ATOM   1507  HB2 ASP A  89      70.218  86.514   3.081  1.00  0.00           H  
ATOM   1508  HB3 ASP A  89      71.256  85.692   4.243  1.00  0.00           H  
TER    1509      ASP A  89                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
