
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  864),  selected   56 , name 1g5v_A
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 1g5v_A.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M     156           -
LGA    Q    90_A      V     157          5.725
LGA    Q    91_A      L     158          2.256
LGA    W    92_A      L     159          1.123
LGA    K    93_A      K     160          1.145
LGA    V    94_A      S     161          1.168
LGA    G    95_A      G     162          1.143
LGA    D    96_A      Q     163          0.309
LGA    K    97_A      L     164          0.463
LGA    C    98_A      I     165          1.037
LGA    S    99_A      K     166          1.352
LGA    A   100_A      T     167          1.059
LGA    I   101_A      E     168          1.053
LGA    W   102_A      W     169          1.118
LGA    S   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    D   105_A      E     170          2.478
LGA    G   106_A      G     171          2.034
LGA    C   107_A      T     172          1.389
LGA    I   108_A      W     173          1.093
LGA    Y   109_A      W     174          0.808
LGA    P   110_A      K     175          1.082
LGA    A   111_A      S     176          0.926
LGA    T   112_A      R     177          0.507
LGA    I   113_A      V     178          0.530
LGA    A   114_A      E     179          0.195
LGA    S   115_A      E     180          0.445
LGA    I   116_A      V     181          0.994
LGA    D   117_A      D     182          0.649
LGA    F   118_A      G     183          0.671
LGA    K   119_A      -       -           -
LGA    R   120_A      -       -           -
LGA    E   121_A      S     184          1.308
LGA    T   122_A      L     185          0.784
LGA    C   123_A      V     186          1.145
LGA    V   124_A      R     187          0.657
LGA    V   125_A      I     188          0.407
LGA    V   126_A      L     189          0.586
LGA    Y   127_A      F     190          0.748
LGA    T   128_A      L     191          1.298
LGA    G   129_A      D     192          1.518
LGA    Y   130_A      D     193          1.010
LGA    G   131_A      K     194          0.139
LGA    N   132_A      R     195          0.968
LGA    R   133_A      C     196          0.772
LGA    E   134_A      E     197          1.011
LGA    E   135_A      W     198          1.081
LGA    Q   136_A      I     199          0.799
LGA    N   137_A      Y     200          1.084
LGA    L   138_A      R     201          0.792
LGA    S   139_A      G     202          1.010
LGA    D   140_A      S     203          1.841
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    L   141_A      L     206          2.074
LGA    L   142_A      E     207          1.373
LGA    S   143_A      P     208          2.906
LGA    P   144_A      -       -           -
LGA    I   145_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   53    5.0     50    1.44    14.00     90.036     3.244

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.281122 * X  +  -0.339095 * Y  +   0.897767 * Z  +  10.083104
  Y_new =   0.414637 * X  +   0.886587 * Y  +   0.205035 * Z  +  52.898125
  Z_new =  -0.865475 * X  +   0.314607 * Y  +   0.389841 * Z  +  16.761593 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.679003   -2.462590  [ DEG:    38.9040   -141.0960 ]
  Theta =   1.046098    2.095495  [ DEG:    59.9370    120.0630 ]
  Phi   =   0.974991   -2.166602  [ DEG:    55.8629   -124.1371 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1g5v_A                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1g5v_A.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   53   5.0   50   1.44   14.00  90.036
REMARK  ---------------------------------------------------------- 
MOLECULE 1g5v_A
HEADER    TRANSLATION                             02-NOV-00   1G5V              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF THE HUMAN SMN               
TITLE    2 PROTEIN                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN 1;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET9D;                                    
SOURCE  10 EXPRESSION_SYSTEM_GENE: EXPRESSED AS FUSION PROTEIN WITH N-          
SOURCE  11 TERMINAL HIS6-GST AND TEV CLEAVAGE SITE                              
KEYWDS    MRNA PROCESSING                                                       
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    P.SELENKO,R.SPRANGERS,G.STIER,D.BUEHLER,U.FISCHER,M.SATTLER           
REVDAT   2   01-APR-03 1G5V    1       JRNL                                     
REVDAT   1   02-MAY-01 1G5V    0                                                
JRNL        AUTH   P.SELENKO,R.SPRANGERS,G.STIER,D.BUHLER,U.FISCHER,            
JRNL        AUTH 2 M.SATTLER                                                    
JRNL        TITL   SMN TUDOR DOMAIN STRUCTURE AND ITS INTERACTION               
JRNL        TITL 2 WITH THE SM PROTEINS.                                        
JRNL        REF    NAT.STRUCT.BIOL.              V.   8    27 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1G5V A   82   169  UNP    Q16637   SMN_HUMAN       82    169             
SEQRES   1 A   88  LYS LYS ASN THR ALA ALA SER LEU GLN GLN TRP LYS VAL          
SEQRES   2 A   88  GLY ASP LYS CYS SER ALA ILE TRP SER GLU ASP GLY CYS          
SEQRES   3 A   88  ILE TYR PRO ALA THR ILE ALA SER ILE ASP PHE LYS ARG          
SEQRES   4 A   88  GLU THR CYS VAL VAL VAL TYR THR GLY TYR GLY ASN ARG          
SEQRES   5 A   88  GLU GLU GLN ASN LEU SER ASP LEU LEU SER PRO ILE CYS          
SEQRES   6 A   88  GLU VAL ALA ASN ASN ILE GLU GLN ASN ALA GLN GLU ASN          
SEQRES   7 A   88  GLU ASN GLU SER GLN VAL SER THR ASP GLU                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLN A  90      -1.822  58.968  19.307  1.00  7.42           N  
ATOM      2  CA  GLN A  90      -0.803  59.973  19.037  1.00  8.00           C  
ATOM      3  C   GLN A  90       0.187  60.061  20.195  1.00  8.02           C  
ATOM      4  O   GLN A  90       0.037  59.367  21.202  1.00  8.02           O  
ATOM      5  CB  GLN A  90      -1.448  61.339  18.795  1.00  8.61           C  
ATOM      6  CG  GLN A  90      -2.478  61.721  19.848  1.00  9.27           C  
ATOM      7  CD  GLN A  90      -1.991  62.825  20.767  1.00  9.99           C  
ATOM      8  OE1 GLN A  90      -1.343  63.775  20.326  1.00 10.31           O  
ATOM      9  NE2 GLN A  90      -2.301  62.706  22.051  1.00 10.47           N  
ATOM     10  H   GLN A  90      -2.752  59.251  19.437  1.00  7.43           H  
ATOM     11  HA  GLN A  90      -0.269  59.675  18.147  1.00  8.21           H  
ATOM     12  HB2 GLN A  90      -0.677  62.093  18.789  1.00  8.80           H  
ATOM     13  HB3 GLN A  90      -1.937  61.329  17.833  1.00  8.62           H  
ATOM     14  HG2 GLN A  90      -3.374  62.059  19.350  1.00  9.33           H  
ATOM     15  HG3 GLN A  90      -2.705  60.850  20.444  1.00  9.38           H  
ATOM     16 HE21 GLN A  90      -2.821  61.921  22.332  1.00 10.35           H  
ATOM     17 HE22 GLN A  90      -1.999  63.403  22.669  1.00 11.04           H  
ATOM     18  N   GLN A  91       1.195  60.915  20.046  1.00  8.30           N  
ATOM     19  CA  GLN A  91       2.213  61.097  21.077  1.00  8.58           C  
ATOM     20  C   GLN A  91       2.936  59.783  21.369  1.00  7.86           C  
ATOM     21  O   GLN A  91       2.448  58.950  22.133  1.00  7.55           O  
ATOM     22  CB  GLN A  91       1.584  61.641  22.361  1.00  9.49           C  
ATOM     23  CG  GLN A  91       2.599  61.983  23.440  1.00  9.88           C  
ATOM     24  CD  GLN A  91       2.179  63.171  24.283  1.00 10.82           C  
ATOM     25  OE1 GLN A  91       1.010  63.560  24.291  1.00 11.18           O  
ATOM     26  NE2 GLN A  91       3.131  63.754  24.997  1.00 11.40           N  
ATOM     27  H   GLN A  91       1.258  61.438  19.219  1.00  8.47           H  
ATOM     28  HA  GLN A  91       2.933  61.813  20.709  1.00  8.82           H  
ATOM     29  HB2 GLN A  91       1.028  62.537  22.123  1.00  9.92           H  
ATOM     30  HB3 GLN A  91       0.903  60.902  22.757  1.00  9.67           H  
ATOM     31  HG2 GLN A  91       2.717  61.127  24.087  1.00  9.76           H  
ATOM     32  HG3 GLN A  91       3.544  62.209  22.969  1.00  9.84           H  
ATOM     33 HE21 GLN A  91       4.040  63.390  24.944  1.00 11.23           H  
ATOM     34 HE22 GLN A  91       2.888  64.525  25.554  1.00 12.09           H  
ATOM     35  N   TRP A  92       4.100  59.607  20.753  1.00  7.74           N  
ATOM     36  CA  TRP A  92       4.889  58.397  20.944  1.00  7.12           C  
ATOM     37  C   TRP A  92       5.556  58.387  22.316  1.00  7.81           C  
ATOM     38  O   TRP A  92       6.088  59.403  22.766  1.00  8.60           O  
ATOM     39  CB  TRP A  92       5.947  58.280  19.846  1.00  6.73           C  
ATOM     40  CG  TRP A  92       5.368  58.026  18.486  1.00  6.11           C  
ATOM     41  CD1 TRP A  92       5.514  58.807  17.376  1.00  6.47           C  
ATOM     42  CD2 TRP A  92       4.546  56.920  18.096  1.00  5.26           C  
ATOM     43  NE1 TRP A  92       4.835  58.254  16.318  1.00  5.95           N  
ATOM     44  CE2 TRP A  92       4.234  57.094  16.735  1.00  5.17           C  
ATOM     45  CE3 TRP A  92       4.046  55.798  18.763  1.00  4.81           C  
ATOM     46  CZ2 TRP A  92       3.442  56.190  16.030  1.00  4.65           C  
ATOM     47  CZ3 TRP A  92       3.264  54.899  18.062  1.00  4.27           C  
ATOM     48  CH2 TRP A  92       2.968  55.101  16.708  1.00  4.18           C  
ATOM     49  H   TRP A  92       4.436  60.308  20.156  1.00  8.17           H  
ATOM     50  HA  TRP A  92       4.221  57.551  20.876  1.00  6.55           H  
ATOM     51  HB2 TRP A  92       6.514  59.198  19.802  1.00  7.42           H  
ATOM     52  HB3 TRP A  92       6.614  57.463  20.083  1.00  6.37           H  
ATOM     53  HD1 TRP A  92       6.084  59.725  17.347  1.00  7.20           H  
ATOM     54  HE1 TRP A  92       4.789  58.624  15.412  1.00  6.25           H  
ATOM     55  HE3 TRP A  92       4.264  55.626  19.807  1.00  5.13           H  
ATOM     56  HZ2 TRP A  92       3.206  56.329  14.985  1.00  4.86           H  
ATOM     57  HZ3 TRP A  92       2.867  54.028  18.562  1.00  4.21           H  
ATOM     58  HH2 TRP A  92       2.351  54.374  16.200  1.00  4.03           H  
ATOM     59  N   LYS A  93       5.528  57.230  22.974  1.00  7.67           N  
ATOM     60  CA  LYS A  93       6.134  57.083  24.294  1.00  8.46           C  
ATOM     61  C   LYS A  93       6.772  55.705  24.445  1.00  8.08           C  
ATOM     62  O   LYS A  93       6.595  54.832  23.594  1.00  7.25           O  
ATOM     63  CB  LYS A  93       5.086  57.297  25.391  1.00  9.25           C  
ATOM     64  CG  LYS A  93       4.026  56.209  25.445  1.00 10.03           C  
ATOM     65  CD  LYS A  93       3.281  56.222  26.771  1.00 10.80           C  
ATOM     66  CE  LYS A  93       3.201  54.832  27.380  1.00 11.72           C  
ATOM     67  NZ  LYS A  93       2.407  53.898  26.535  1.00 12.39           N  
ATOM     68  H   LYS A  93       5.092  56.456  22.560  1.00  7.13           H  
ATOM     69  HA  LYS A  93       6.903  57.834  24.391  1.00  8.90           H  
ATOM     70  HB2 LYS A  93       5.587  57.328  26.347  1.00  9.17           H  
ATOM     71  HB3 LYS A  93       4.593  58.243  25.222  1.00  9.53           H  
ATOM     72  HG2 LYS A  93       3.318  56.370  24.645  1.00 10.14           H  
ATOM     73  HG3 LYS A  93       4.502  55.248  25.318  1.00 10.10           H  
ATOM     74  HD2 LYS A  93       3.800  56.876  27.456  1.00 10.94           H  
ATOM     75  HD3 LYS A  93       2.280  56.592  26.607  1.00 10.75           H  
ATOM     76  HE2 LYS A  93       4.203  54.441  27.486  1.00 11.97           H  
ATOM     77  HE3 LYS A  93       2.740  54.905  28.354  1.00 11.81           H  
ATOM     78  HZ1 LYS A  93       1.456  53.776  26.936  1.00 12.71           H  
ATOM     79  HZ2 LYS A  93       2.874  52.970  26.490  1.00 12.53           H  
ATOM     80  HZ3 LYS A  93       2.320  54.277  25.571  1.00 12.60           H  
ATOM     81  N   VAL A  94       7.512  55.518  25.533  1.00  8.81           N  
ATOM     82  CA  VAL A  94       8.174  54.244  25.794  1.00  8.73           C  
ATOM     83  C   VAL A  94       7.154  53.137  26.037  1.00  8.69           C  
ATOM     84  O   VAL A  94       6.192  53.319  26.783  1.00  9.36           O  
ATOM     85  CB  VAL A  94       9.117  54.334  27.009  1.00  9.74           C  
ATOM     86  CG1 VAL A  94      10.131  53.200  26.980  1.00  9.66           C  
ATOM     87  CG2 VAL A  94       9.818  55.682  27.050  1.00 10.15           C  
ATOM     88  H   VAL A  94       7.614  56.251  26.175  1.00  9.49           H  
ATOM     89  HA  VAL A  94       8.764  53.992  24.924  1.00  8.07           H  
ATOM     90  HB  VAL A  94       8.526  54.231  27.906  1.00 10.36           H  
ATOM     91 HG11 VAL A  94       9.658  52.287  27.310  1.00  9.56           H  
ATOM     92 HG12 VAL A  94      10.497  53.071  25.973  1.00  9.67           H  
ATOM     93 HG13 VAL A  94      10.953  53.436  27.636  1.00  9.89           H  
ATOM     94 HG21 VAL A  94      10.205  55.919  26.069  1.00 10.19           H  
ATOM     95 HG22 VAL A  94       9.115  56.445  27.350  1.00 10.42           H  
ATOM     96 HG23 VAL A  94      10.633  55.645  27.757  1.00 10.36           H  
ATOM     97  N   GLY A  95       7.371  51.992  25.398  1.00  8.04           N  
ATOM     98  CA  GLY A  95       6.459  50.872  25.551  1.00  8.20           C  
ATOM     99  C   GLY A  95       5.201  51.036  24.724  1.00  7.64           C  
ATOM    100  O   GLY A  95       4.125  51.299  25.262  1.00  8.10           O  
ATOM    101  H   GLY A  95       8.151  51.906  24.813  1.00  7.54           H  
ATOM    102  HA2 GLY A  95       6.964  49.967  25.245  1.00  8.06           H  
ATOM    103  HA3 GLY A  95       6.186  50.785  26.592  1.00  9.01           H  
ATOM    104  N   ASP A  96       5.336  50.885  23.409  1.00  6.70           N  
ATOM    105  CA  ASP A  96       4.202  51.020  22.503  1.00  6.20           C  
ATOM    106  C   ASP A  96       4.357  50.102  21.295  1.00  5.53           C  
ATOM    107  O   ASP A  96       5.450  49.958  20.748  1.00  4.92           O  
ATOM    108  CB  ASP A  96       4.066  52.473  22.040  1.00  5.87           C  
ATOM    109  CG  ASP A  96       2.792  53.125  22.541  1.00  6.35           C  
ATOM    110  OD1 ASP A  96       2.250  52.662  23.566  1.00  6.81           O  
ATOM    111  OD2 ASP A  96       2.338  54.103  21.910  1.00  6.44           O  
ATOM    112  H   ASP A  96       6.219  50.678  23.040  1.00  6.39           H  
ATOM    113  HA  ASP A  96       3.309  50.739  23.043  1.00  6.75           H  
ATOM    114  HB2 ASP A  96       4.906  53.041  22.406  1.00  6.15           H  
ATOM    115  HB3 ASP A  96       4.062  52.500  20.959  1.00  5.22           H  
ATOM    116  N   LYS A  97       3.252  49.485  20.886  1.00  5.83           N  
ATOM    117  CA  LYS A  97       3.259  48.579  19.741  1.00  5.62           C  
ATOM    118  C   LYS A  97       3.108  49.353  18.437  1.00  4.80           C  
ATOM    119  O   LYS A  97       2.004  49.747  18.061  1.00  4.86           O  
ATOM    120  CB  LYS A  97       2.131  47.553  19.872  1.00  6.55           C  
ATOM    121  CG  LYS A  97       2.570  46.241  20.500  1.00  7.39           C  
ATOM    122  CD  LYS A  97       2.363  45.071  19.552  1.00  7.70           C  
ATOM    123  CE  LYS A  97       3.563  44.137  19.547  1.00  8.21           C  
ATOM    124  NZ  LYS A  97       3.160  42.713  19.700  1.00  9.10           N  
ATOM    125  H   LYS A  97       2.412  49.642  21.365  1.00  6.34           H  
ATOM    126  HA  LYS A  97       4.205  48.061  19.734  1.00  5.59           H  
ATOM    127  HB2 LYS A  97       1.345  47.974  20.482  1.00  6.81           H  
ATOM    128  HB3 LYS A  97       1.737  47.342  18.889  1.00  6.52           H  
ATOM    129  HG2 LYS A  97       3.620  46.306  20.750  1.00  7.35           H  
ATOM    130  HG3 LYS A  97       1.995  46.073  21.399  1.00  8.01           H  
ATOM    131  HD2 LYS A  97       1.491  44.515  19.866  1.00  8.14           H  
ATOM    132  HD3 LYS A  97       2.208  45.450  18.554  1.00  7.34           H  
ATOM    133  HE2 LYS A  97       4.089  44.253  18.611  1.00  7.96           H  
ATOM    134  HE3 LYS A  97       4.217  44.408  20.364  1.00  8.38           H  
ATOM    135  HZ1 LYS A  97       2.279  42.532  19.177  1.00  9.44           H  
ATOM    136  HZ2 LYS A  97       3.004  42.490  20.704  1.00  9.31           H  
ATOM    137  HZ3 LYS A  97       3.904  42.087  19.330  1.00  9.40           H  
ATOM    138  N   CYS A  98       4.225  49.566  17.749  1.00  4.16           N  
ATOM    139  CA  CYS A  98       4.220  50.293  16.484  1.00  3.60           C  
ATOM    140  C   CYS A  98       4.706  49.405  15.343  1.00  3.78           C  
ATOM    141  O   CYS A  98       4.903  48.204  15.522  1.00  4.46           O  
ATOM    142  CB  CYS A  98       5.102  51.540  16.586  1.00  2.97           C  
ATOM    143  SG  CYS A  98       6.874  51.191  16.597  1.00  2.58           S  
ATOM    144  H   CYS A  98       5.076  49.229  18.101  1.00  4.21           H  
ATOM    145  HA  CYS A  98       3.204  50.598  16.281  1.00  3.89           H  
ATOM    146  HB2 CYS A  98       4.900  52.185  15.745  1.00  2.90           H  
ATOM    147  HB3 CYS A  98       4.864  52.066  17.500  1.00  3.27           H  
ATOM    148  HG  CYS A  98       7.229  50.837  15.369  1.00  2.63           H  
ATOM    149  N   SER A  99       4.898  50.004  14.172  1.00  3.54           N  
ATOM    150  CA  SER A  99       5.362  49.267  13.001  1.00  4.08           C  
ATOM    151  C   SER A  99       6.529  49.988  12.337  1.00  3.73           C  
ATOM    152  O   SER A  99       6.453  51.186  12.055  1.00  3.54           O  
ATOM    153  CB  SER A  99       4.222  49.091  11.997  1.00  5.02           C  
ATOM    154  OG  SER A  99       3.952  47.718  11.769  1.00  5.76           O  
ATOM    155  H   SER A  99       4.722  50.963  14.093  1.00  3.26           H  
ATOM    156  HA  SER A  99       5.694  48.296  13.330  1.00  4.35           H  
ATOM    157  HB2 SER A  99       3.329  49.560  12.384  1.00  4.95           H  
ATOM    158  HB3 SER A  99       4.494  49.552  11.060  1.00  5.41           H  
ATOM    159  HG  SER A  99       3.596  47.323  12.567  1.00  6.10           H  
ATOM    160  N   ALA A 100       7.613  49.256  12.092  1.00  3.97           N  
ATOM    161  CA  ALA A 100       8.796  49.833  11.464  1.00  3.95           C  
ATOM    162  C   ALA A 100       9.249  49.007  10.265  1.00  4.93           C  
ATOM    163  O   ALA A 100       9.166  47.778  10.274  1.00  5.47           O  
ATOM    164  CB  ALA A 100       9.922  49.952  12.481  1.00  3.19           C  
ATOM    165  H   ALA A 100       7.617  48.308  12.340  1.00  4.37           H  
ATOM    166  HA  ALA A 100       8.542  50.826  11.128  1.00  4.02           H  
ATOM    167  HB1 ALA A 100       9.548  49.706  13.464  1.00  3.13           H  
ATOM    168  HB2 ALA A 100      10.717  49.269  12.218  1.00  3.18           H  
ATOM    169  HB3 ALA A 100      10.301  50.963  12.481  1.00  3.31           H  
ATOM    170  N   ILE A 101       9.728  49.696   9.233  1.00  5.36           N  
ATOM    171  CA  ILE A 101      10.198  49.039   8.020  1.00  6.34           C  
ATOM    172  C   ILE A 101      11.650  48.592   8.169  1.00  6.26           C  
ATOM    173  O   ILE A 101      12.455  49.271   8.807  1.00  5.81           O  
ATOM    174  CB  ILE A 101      10.081  49.966   6.794  1.00  7.10           C  
ATOM    175  CG1 ILE A 101       8.805  50.806   6.882  1.00  7.16           C  
ATOM    176  CG2 ILE A 101      10.099  49.152   5.510  1.00  8.16           C  
ATOM    177  CD1 ILE A 101       9.061  52.297   6.874  1.00  7.47           C  
ATOM    178  H   ILE A 101       9.763  50.673   9.289  1.00  5.16           H  
ATOM    179  HA  ILE A 101       9.581  48.168   7.850  1.00  6.77           H  
ATOM    180  HB  ILE A 101      10.937  50.623   6.785  1.00  6.97           H  
ATOM    181 HG12 ILE A 101       8.171  50.575   6.038  1.00  7.79           H  
ATOM    182 HG13 ILE A 101       8.283  50.563   7.796  1.00  6.50           H  
ATOM    183 HG21 ILE A 101       9.227  48.515   5.475  1.00  8.60           H  
ATOM    184 HG22 ILE A 101      10.088  49.819   4.662  1.00  8.42           H  
ATOM    185 HG23 ILE A 101      10.990  48.544   5.479  1.00  8.42           H  
ATOM    186 HD11 ILE A 101       8.919  52.682   5.875  1.00  7.80           H  
ATOM    187 HD12 ILE A 101       8.374  52.786   7.549  1.00  7.53           H  
ATOM    188 HD13 ILE A 101      10.076  52.491   7.193  1.00  7.60           H  
ATOM    189  N   TRP A 102      11.976  47.446   7.578  1.00  6.86           N  
ATOM    190  CA  TRP A 102      13.330  46.908   7.646  1.00  6.96           C  
ATOM    191  C   TRP A 102      14.187  47.433   6.497  1.00  7.60           C  
ATOM    192  O   TRP A 102      13.699  47.625   5.384  1.00  8.38           O  
ATOM    193  CB  TRP A 102      13.296  45.377   7.618  1.00  7.61           C  
ATOM    194  CG  TRP A 102      14.433  44.730   8.354  1.00  7.54           C  
ATOM    195  CD1 TRP A 102      15.408  45.354   9.083  1.00  6.89           C  
ATOM    196  CD2 TRP A 102      14.716  43.328   8.428  1.00  8.31           C  
ATOM    197  NE1 TRP A 102      16.275  44.425   9.604  1.00  7.22           N  
ATOM    198  CE2 TRP A 102      15.871  43.174   9.216  1.00  8.10           C  
ATOM    199  CE3 TRP A 102      14.102  42.186   7.902  1.00  9.26           C  
ATOM    200  CZ2 TRP A 102      16.426  41.926   9.491  1.00  8.82           C  
ATOM    201  CZ3 TRP A 102      14.652  40.947   8.177  1.00  9.95           C  
ATOM    202  CH2 TRP A 102      15.804  40.828   8.965  1.00  9.73           C  
ATOM    203  H   TRP A 102      11.290  46.951   7.086  1.00  7.33           H  
ATOM    204  HA  TRP A 102      13.767  47.232   8.580  1.00  6.25           H  
ATOM    205  HB2 TRP A 102      12.375  45.039   8.071  1.00  7.50           H  
ATOM    206  HB3 TRP A 102      13.328  45.044   6.592  1.00  8.39           H  
ATOM    207  HD1 TRP A 102      15.472  46.421   9.222  1.00  6.33           H  
ATOM    208  HE1 TRP A 102      17.055  44.626  10.163  1.00  6.98           H  
ATOM    209  HE3 TRP A 102      13.214  42.260   7.292  1.00  9.54           H  
ATOM    210  HZ2 TRP A 102      17.312  41.816  10.098  1.00  8.75           H  
ATOM    211  HZ3 TRP A 102      14.194  40.056   7.780  1.00 10.73           H  
ATOM    212  HH2 TRP A 102      16.200  39.841   9.154  1.00 10.36           H  
ATOM    213  N   SER A 103      15.465  47.665   6.781  1.00  7.36           N  
ATOM    214  CA  SER A 103      16.393  48.168   5.774  1.00  8.04           C  
ATOM    215  C   SER A 103      17.142  47.022   5.104  1.00  8.76           C  
ATOM    216  O   SER A 103      18.209  47.221   4.520  1.00  9.24           O  
ATOM    217  CB  SER A 103      17.389  49.140   6.412  1.00  7.63           C  
ATOM    218  OG  SER A 103      16.914  50.474   6.348  1.00  7.51           O  
ATOM    219  H   SER A 103      15.792  47.494   7.688  1.00  6.79           H  
ATOM    220  HA  SER A 103      15.819  48.694   5.026  1.00  8.46           H  
ATOM    221  HB2 SER A 103      17.533  48.874   7.450  1.00  7.67           H  
ATOM    222  HB3 SER A 103      18.333  49.080   5.890  1.00  7.68           H  
ATOM    223  HG  SER A 103      17.244  50.893   5.548  1.00  7.54           H  
ATOM    224  N   GLU A 104      16.579  45.820   5.191  1.00  8.96           N  
ATOM    225  CA  GLU A 104      17.194  44.641   4.595  1.00  9.78           C  
ATOM    226  C   GLU A 104      16.407  44.171   3.377  1.00 10.72           C  
ATOM    227  O   GLU A 104      16.989  43.754   2.372  1.00 11.50           O  
ATOM    228  CB  GLU A 104      17.283  43.513   5.624  1.00  9.65           C  
ATOM    229  CG  GLU A 104      18.337  43.747   6.694  1.00  9.77           C  
ATOM    230  CD  GLU A 104      19.254  42.555   6.883  1.00 10.55           C  
ATOM    231  OE1 GLU A 104      19.379  41.746   5.940  1.00 10.87           O  
ATOM    232  OE2 GLU A 104      19.850  42.433   7.974  1.00 10.99           O  
ATOM    233  H   GLU A 104      15.728  45.726   5.671  1.00  8.64           H  
ATOM    234  HA  GLU A 104      18.192  44.910   4.282  1.00  9.92           H  
ATOM    235  HB2 GLU A 104      16.324  43.407   6.110  1.00  9.03           H  
ATOM    236  HB3 GLU A 104      17.521  42.592   5.112  1.00 10.24           H  
ATOM    237  HG2 GLU A 104      18.935  44.601   6.411  1.00  9.51           H  
ATOM    238  HG3 GLU A 104      17.839  43.954   7.630  1.00  9.72           H  
ATOM    239  N   ASP A 105      15.083  44.239   3.471  1.00 10.68           N  
ATOM    240  CA  ASP A 105      14.216  43.819   2.374  1.00 11.61           C  
ATOM    241  C   ASP A 105      13.184  44.896   2.055  1.00 11.51           C  
ATOM    242  O   ASP A 105      12.498  44.827   1.035  1.00 12.31           O  
ATOM    243  CB  ASP A 105      13.508  42.511   2.727  1.00 12.02           C  
ATOM    244  CG  ASP A 105      14.433  41.311   2.644  1.00 12.58           C  
ATOM    245  OD1 ASP A 105      15.233  41.245   1.685  1.00 12.80           O  
ATOM    246  OD2 ASP A 105      14.359  40.438   3.534  1.00 12.93           O  
ATOM    247  H   ASP A 105      14.679  44.579   4.295  1.00 10.04           H  
ATOM    248  HA  ASP A 105      14.835  43.661   1.504  1.00 12.21           H  
ATOM    249  HB2 ASP A 105      13.125  42.575   3.735  1.00 11.64           H  
ATOM    250  HB3 ASP A 105      12.685  42.356   2.043  1.00 12.44           H  
ATOM    251  N   GLY A 106      13.083  45.889   2.932  1.00 10.59           N  
ATOM    252  CA  GLY A 106      12.133  46.966   2.726  1.00 10.51           C  
ATOM    253  C   GLY A 106      10.695  46.503   2.866  1.00 10.58           C  
ATOM    254  O   GLY A 106       9.920  46.566   1.910  1.00 11.27           O  
ATOM    255  H   GLY A 106      13.656  45.890   3.727  1.00 10.02           H  
ATOM    256  HA2 GLY A 106      12.322  47.743   3.451  1.00  9.82           H  
ATOM    257  HA3 GLY A 106      12.274  47.372   1.736  1.00 11.16           H  
ATOM    258  N   CYS A 107      10.340  46.037   4.058  1.00  9.96           N  
ATOM    259  CA  CYS A 107       8.986  45.560   4.321  1.00 10.08           C  
ATOM    260  C   CYS A 107       8.520  45.985   5.709  1.00  9.03           C  
ATOM    261  O   CYS A 107       9.332  46.337   6.566  1.00  8.22           O  
ATOM    262  CB  CYS A 107       8.927  44.037   4.195  1.00 10.82           C  
ATOM    263  SG  CYS A 107       8.526  43.448   2.532  1.00 12.07           S  
ATOM    264  H   CYS A 107      11.002  46.010   4.779  1.00  9.48           H  
ATOM    265  HA  CYS A 107       8.331  45.998   3.583  1.00 10.51           H  
ATOM    266  HB2 CYS A 107       9.886  43.623   4.465  1.00 10.74           H  
ATOM    267  HB3 CYS A 107       8.174  43.655   4.869  1.00 10.81           H  
ATOM    268  HG  CYS A 107       7.869  44.413   1.905  1.00 12.45           H  
ATOM    269  N   ILE A 108       7.208  45.951   5.927  1.00  9.09           N  
ATOM    270  CA  ILE A 108       6.636  46.335   7.214  1.00  8.18           C  
ATOM    271  C   ILE A 108       6.636  45.161   8.188  1.00  8.20           C  
ATOM    272  O   ILE A 108       6.159  44.074   7.864  1.00  9.05           O  
ATOM    273  CB  ILE A 108       5.193  46.853   7.056  1.00  8.31           C  
ATOM    274  CG1 ILE A 108       5.118  47.886   5.930  1.00  8.80           C  
ATOM    275  CG2 ILE A 108       4.696  47.448   8.364  1.00  7.33           C  
ATOM    276  CD1 ILE A 108       4.442  47.368   4.680  1.00  9.51           C  
ATOM    277  H   ILE A 108       6.611  45.661   5.205  1.00  9.78           H  
ATOM    278  HA  ILE A 108       7.240  47.130   7.623  1.00  7.48           H  
ATOM    279  HB  ILE A 108       4.559  46.013   6.806  1.00  8.90           H  
ATOM    280 HG12 ILE A 108       4.563  48.745   6.276  1.00  8.60           H  
ATOM    281 HG13 ILE A 108       6.119  48.194   5.666  1.00  9.01           H  
ATOM    282 HG21 ILE A 108       4.491  48.499   8.228  1.00  7.23           H  
ATOM    283 HG22 ILE A 108       3.793  46.943   8.669  1.00  7.20           H  
ATOM    284 HG23 ILE A 108       5.451  47.326   9.126  1.00  7.09           H  
ATOM    285 HD11 ILE A 108       3.635  46.707   4.955  1.00  9.82           H  
ATOM    286 HD12 ILE A 108       4.051  48.199   4.112  1.00  9.78           H  
ATOM    287 HD13 ILE A 108       5.160  46.831   4.079  1.00  9.63           H  
ATOM    288  N   TYR A 109       7.171  45.390   9.382  1.00  7.40           N  
ATOM    289  CA  TYR A 109       7.229  44.352  10.406  1.00  7.58           C  
ATOM    290  C   TYR A 109       6.947  44.937  11.788  1.00  6.75           C  
ATOM    291  O   TYR A 109       7.342  46.065  12.082  1.00  5.79           O  
ATOM    292  CB  TYR A 109       8.600  43.671  10.395  1.00  7.78           C  
ATOM    293  CG  TYR A 109       8.837  42.790   9.187  1.00  8.74           C  
ATOM    294  CD1 TYR A 109       7.982  41.735   8.893  1.00  9.44           C  
ATOM    295  CD2 TYR A 109       9.917  43.017   8.341  1.00  9.05           C  
ATOM    296  CE1 TYR A 109       8.196  40.931   7.790  1.00 10.35           C  
ATOM    297  CE2 TYR A 109      10.136  42.217   7.235  1.00  9.98           C  
ATOM    298  CZ  TYR A 109       9.274  41.177   6.964  1.00 10.60           C  
ATOM    299  OH  TYR A 109       9.488  40.376   5.865  1.00 11.54           O  
ATOM    300  H   TYR A 109       7.533  46.279   9.583  1.00  6.76           H  
ATOM    301  HA  TYR A 109       6.471  43.618  10.176  1.00  8.35           H  
ATOM    302  HB2 TYR A 109       9.370  44.428  10.410  1.00  7.11           H  
ATOM    303  HB3 TYR A 109       8.694  43.055  11.278  1.00  7.98           H  
ATOM    304  HD1 TYR A 109       7.138  41.546   9.539  1.00  9.32           H  
ATOM    305  HD2 TYR A 109      10.590  43.833   8.556  1.00  8.62           H  
ATOM    306  HE1 TYR A 109       7.521  40.116   7.577  1.00 10.91           H  
ATOM    307  HE2 TYR A 109      10.980  42.409   6.590  1.00 10.28           H  
ATOM    308  HH  TYR A 109       8.781  39.732   5.795  1.00 11.63           H  
ATOM    309  N   PRO A 110       6.254  44.178  12.658  1.00  7.22           N  
ATOM    310  CA  PRO A 110       5.921  44.630  14.015  1.00  6.71           C  
ATOM    311  C   PRO A 110       7.136  45.169  14.763  1.00  6.03           C  
ATOM    312  O   PRO A 110       8.247  44.661  14.611  1.00  6.34           O  
ATOM    313  CB  PRO A 110       5.394  43.362  14.688  1.00  7.77           C  
ATOM    314  CG  PRO A 110       4.846  42.549  13.568  1.00  8.66           C  
ATOM    315  CD  PRO A 110       5.741  42.818  12.391  1.00  8.42           C  
ATOM    316  HA  PRO A 110       5.146  45.383  14.001  1.00  6.30           H  
ATOM    317  HB2 PRO A 110       6.204  42.850  15.188  1.00  7.86           H  
ATOM    318  HB3 PRO A 110       4.627  43.620  15.402  1.00  7.87           H  
ATOM    319  HG2 PRO A 110       4.867  41.501  13.828  1.00  9.09           H  
ATOM    320  HG3 PRO A 110       3.835  42.861  13.349  1.00  9.14           H  
ATOM    321  HD2 PRO A 110       6.546  42.099  12.358  1.00  8.74           H  
ATOM    322  HD3 PRO A 110       5.174  42.794  11.471  1.00  8.86           H  
ATOM    323  N   ALA A 111       6.918  46.204  15.569  1.00  5.22           N  
ATOM    324  CA  ALA A 111       7.996  46.816  16.338  1.00  4.71           C  
ATOM    325  C   ALA A 111       7.500  47.317  17.689  1.00  4.65           C  
ATOM    326  O   ALA A 111       6.295  47.381  17.936  1.00  4.72           O  
ATOM    327  CB  ALA A 111       8.619  47.958  15.551  1.00  3.76           C  
ATOM    328  H   ALA A 111       6.011  46.567  15.646  1.00  5.07           H  
ATOM    329  HA  ALA A 111       8.757  46.067  16.501  1.00  5.28           H  
ATOM    330  HB1 ALA A 111       8.843  48.776  16.219  1.00  3.53           H  
ATOM    331  HB2 ALA A 111       9.531  47.618  15.082  1.00  3.83           H  
ATOM    332  HB3 ALA A 111       7.927  48.292  14.792  1.00  3.72           H  
ATOM    333  N   THR A 112       8.440  47.672  18.562  1.00  4.78           N  
ATOM    334  CA  THR A 112       8.105  48.172  19.891  1.00  5.14           C  
ATOM    335  C   THR A 112       9.094  49.243  20.338  1.00  4.91           C  
ATOM    336  O   THR A 112      10.283  48.971  20.512  1.00  5.15           O  
ATOM    337  CB  THR A 112       8.092  47.036  20.932  1.00  6.32           C  
ATOM    338  OG1 THR A 112       7.491  45.862  20.370  1.00  6.81           O  
ATOM    339  CG2 THR A 112       7.326  47.453  22.178  1.00  6.83           C  
ATOM    340  H   THR A 112       9.381  47.596  18.303  1.00  4.82           H  
ATOM    341  HA  THR A 112       7.115  48.603  19.847  1.00  4.95           H  
ATOM    342  HB  THR A 112       9.111  46.811  21.211  1.00  6.59           H  
ATOM    343  HG1 THR A 112       7.413  45.187  21.046  1.00  6.86           H  
ATOM    344 HG21 THR A 112       7.607  48.458  22.453  1.00  6.78           H  
ATOM    345 HG22 THR A 112       7.562  46.779  22.989  1.00  7.40           H  
ATOM    346 HG23 THR A 112       6.266  47.419  21.978  1.00  6.91           H  
ATOM    347  N   ILE A 113       8.596  50.463  20.521  1.00  4.70           N  
ATOM    348  CA  ILE A 113       9.436  51.578  20.946  1.00  4.93           C  
ATOM    349  C   ILE A 113      10.033  51.319  22.327  1.00  6.00           C  
ATOM    350  O   ILE A 113       9.330  51.362  23.336  1.00  6.70           O  
ATOM    351  CB  ILE A 113       8.644  52.900  20.971  1.00  4.99           C  
ATOM    352  CG1 ILE A 113       8.002  53.160  19.607  1.00  4.08           C  
ATOM    353  CG2 ILE A 113       9.553  54.054  21.362  1.00  5.66           C  
ATOM    354  CD1 ILE A 113       6.512  53.426  19.677  1.00  4.34           C  
ATOM    355  H   ILE A 113       7.640  50.617  20.366  1.00  4.58           H  
ATOM    356  HA  ILE A 113      10.240  51.678  20.232  1.00  4.50           H  
ATOM    357  HB  ILE A 113       7.869  52.816  21.718  1.00  5.46           H  
ATOM    358 HG12 ILE A 113       8.469  54.021  19.154  1.00  4.02           H  
ATOM    359 HG13 ILE A 113       8.156  52.299  18.974  1.00  3.58           H  
ATOM    360 HG21 ILE A 113       9.958  53.876  22.348  1.00  6.04           H  
ATOM    361 HG22 ILE A 113      10.362  54.132  20.649  1.00  5.85           H  
ATOM    362 HG23 ILE A 113       8.987  54.973  21.365  1.00  5.84           H  
ATOM    363 HD11 ILE A 113       6.339  54.375  20.163  1.00  4.53           H  
ATOM    364 HD12 ILE A 113       6.104  53.453  18.678  1.00  4.66           H  
ATOM    365 HD13 ILE A 113       6.033  52.640  20.242  1.00  4.37           H  
ATOM    366  N   ALA A 114      11.331  51.033  22.359  1.00  6.19           N  
ATOM    367  CA  ALA A 114      12.025  50.744  23.611  1.00  7.25           C  
ATOM    368  C   ALA A 114      12.597  52.003  24.263  1.00  7.83           C  
ATOM    369  O   ALA A 114      12.586  52.131  25.487  1.00  8.77           O  
ATOM    370  CB  ALA A 114      13.134  49.731  23.369  1.00  7.35           C  
ATOM    371  H   ALA A 114      11.830  50.996  21.517  1.00  5.66           H  
ATOM    372  HA  ALA A 114      11.311  50.300  24.289  1.00  7.70           H  
ATOM    373  HB1 ALA A 114      12.704  48.743  23.276  1.00  7.34           H  
ATOM    374  HB2 ALA A 114      13.660  49.980  22.460  1.00  7.27           H  
ATOM    375  HB3 ALA A 114      13.823  49.745  24.200  1.00  7.76           H  
ATOM    376  N   SER A 115      13.101  52.927  23.449  1.00  7.42           N  
ATOM    377  CA  SER A 115      13.680  54.162  23.970  1.00  8.19           C  
ATOM    378  C   SER A 115      13.477  55.312  22.992  1.00  7.84           C  
ATOM    379  O   SER A 115      13.305  55.098  21.793  1.00  6.96           O  
ATOM    380  CB  SER A 115      15.171  53.973  24.249  1.00  8.69           C  
ATOM    381  OG  SER A 115      15.419  53.826  25.636  1.00  9.20           O  
ATOM    382  H   SER A 115      13.091  52.777  22.481  1.00  6.69           H  
ATOM    383  HA  SER A 115      13.177  54.400  24.895  1.00  8.81           H  
ATOM    384  HB2 SER A 115      15.522  53.088  23.738  1.00  8.76           H  
ATOM    385  HB3 SER A 115      15.715  54.836  23.888  1.00  8.78           H  
ATOM    386  HG  SER A 115      14.584  53.816  26.110  1.00  9.31           H  
ATOM    387  N   ILE A 116      13.491  56.535  23.512  1.00  8.68           N  
ATOM    388  CA  ILE A 116      13.304  57.721  22.683  1.00  8.72           C  
ATOM    389  C   ILE A 116      14.213  58.859  23.130  1.00  9.82           C  
ATOM    390  O   ILE A 116      14.491  59.015  24.319  1.00 10.64           O  
ATOM    391  CB  ILE A 116      11.841  58.203  22.726  1.00  8.70           C  
ATOM    392  CG1 ILE A 116      10.891  57.077  22.331  1.00  7.65           C  
ATOM    393  CG2 ILE A 116      11.645  59.409  21.816  1.00  8.99           C  
ATOM    394  CD1 ILE A 116       9.784  56.852  23.334  1.00  7.79           C  
ATOM    395  H   ILE A 116      13.625  56.643  24.477  1.00  9.37           H  
ATOM    396  HA  ILE A 116      13.544  57.459  21.663  1.00  8.07           H  
ATOM    397  HB  ILE A 116      11.621  58.509  23.737  1.00  9.38           H  
ATOM    398 HG12 ILE A 116      10.438  57.310  21.379  1.00  6.99           H  
ATOM    399 HG13 ILE A 116      11.451  56.158  22.242  1.00  7.54           H  
ATOM    400 HG21 ILE A 116      11.827  60.315  22.376  1.00  9.25           H  
ATOM    401 HG22 ILE A 116      12.336  59.351  20.989  1.00  9.06           H  
ATOM    402 HG23 ILE A 116      10.633  59.416  21.440  1.00  9.11           H  
ATOM    403 HD11 ILE A 116       8.968  56.327  22.859  1.00  7.72           H  
ATOM    404 HD12 ILE A 116      10.159  56.267  24.159  1.00  7.97           H  
ATOM    405 HD13 ILE A 116       9.432  57.806  23.701  1.00  7.97           H  
ATOM    406  N   ASP A 117      14.667  59.658  22.167  1.00  9.92           N  
ATOM    407  CA  ASP A 117      15.538  60.788  22.460  1.00 11.01           C  
ATOM    408  C   ASP A 117      14.985  62.067  21.837  1.00 11.42           C  
ATOM    409  O   ASP A 117      15.279  62.388  20.686  1.00 11.09           O  
ATOM    410  CB  ASP A 117      16.952  60.522  21.943  1.00 11.04           C  
ATOM    411  CG  ASP A 117      17.395  59.091  22.175  1.00 11.32           C  
ATOM    412  OD1 ASP A 117      17.024  58.216  21.365  1.00 11.56           O  
ATOM    413  OD2 ASP A 117      18.112  58.846  23.168  1.00 11.44           O  
ATOM    414  H   ASP A 117      14.402  59.483  21.241  1.00  9.31           H  
ATOM    415  HA  ASP A 117      15.570  60.909  23.533  1.00 11.61           H  
ATOM    416  HB2 ASP A 117      16.986  60.721  20.882  1.00 10.47           H  
ATOM    417  HB3 ASP A 117      17.643  61.182  22.450  1.00 11.55           H  
ATOM    418  N   PHE A 118      14.173  62.787  22.607  1.00 12.23           N  
ATOM    419  CA  PHE A 118      13.561  64.027  22.138  1.00 12.79           C  
ATOM    420  C   PHE A 118      14.608  65.019  21.635  1.00 13.61           C  
ATOM    421  O   PHE A 118      14.294  65.920  20.855  1.00 14.24           O  
ATOM    422  CB  PHE A 118      12.740  64.666  23.260  1.00 13.45           C  
ATOM    423  CG  PHE A 118      11.648  63.781  23.785  1.00 12.78           C  
ATOM    424  CD1 PHE A 118      10.549  63.470  22.997  1.00 12.45           C  
ATOM    425  CD2 PHE A 118      11.716  63.259  25.068  1.00 12.56           C  
ATOM    426  CE1 PHE A 118       9.542  62.658  23.477  1.00 11.89           C  
ATOM    427  CE2 PHE A 118      10.709  62.444  25.554  1.00 12.01           C  
ATOM    428  CZ  PHE A 118       9.623  62.143  24.757  1.00 11.67           C  
ATOM    429  H   PHE A 118      13.970  62.468  23.510  1.00 12.52           H  
ATOM    430  HA  PHE A 118      12.900  63.780  21.322  1.00 12.17           H  
ATOM    431  HB2 PHE A 118      13.397  64.909  24.083  1.00 14.05           H  
ATOM    432  HB3 PHE A 118      12.286  65.575  22.890  1.00 13.92           H  
ATOM    433  HD1 PHE A 118      10.487  63.872  21.996  1.00 12.68           H  
ATOM    434  HD2 PHE A 118      12.566  63.494  25.690  1.00 12.88           H  
ATOM    435  HE1 PHE A 118       8.691  62.423  22.853  1.00 11.70           H  
ATOM    436  HE2 PHE A 118      10.775  62.044  26.554  1.00 11.91           H  
ATOM    437  HZ  PHE A 118       8.836  61.505  25.134  1.00 11.29           H  
ATOM    438  N   LYS A 119      15.849  64.854  22.084  1.00 13.66           N  
ATOM    439  CA  LYS A 119      16.934  65.742  21.675  1.00 14.45           C  
ATOM    440  C   LYS A 119      17.037  65.820  20.154  1.00 14.19           C  
ATOM    441  O   LYS A 119      16.782  66.864  19.558  1.00 14.83           O  
ATOM    442  CB  LYS A 119      18.268  65.276  22.267  1.00 14.52           C  
ATOM    443  CG  LYS A 119      18.386  63.766  22.403  1.00 15.42           C  
ATOM    444  CD  LYS A 119      18.981  63.372  23.744  1.00 16.01           C  
ATOM    445  CE  LYS A 119      20.470  63.681  23.811  1.00 16.53           C  
ATOM    446  NZ  LYS A 119      21.214  63.092  22.662  1.00 16.87           N  
ATOM    447  H   LYS A 119      16.039  64.121  22.706  1.00 13.20           H  
ATOM    448  HA  LYS A 119      16.711  66.729  22.056  1.00 15.26           H  
ATOM    449  HB2 LYS A 119      19.070  65.623  21.633  1.00 14.10           H  
ATOM    450  HB3 LYS A 119      18.382  65.713  23.249  1.00 14.43           H  
ATOM    451  HG2 LYS A 119      17.404  63.327  22.313  1.00 15.78           H  
ATOM    452  HG3 LYS A 119      19.022  63.392  21.613  1.00 15.41           H  
ATOM    453  HD2 LYS A 119      18.477  63.921  24.525  1.00 16.18           H  
ATOM    454  HD3 LYS A 119      18.836  62.313  23.894  1.00 16.03           H  
ATOM    455  HE2 LYS A 119      20.603  64.751  23.803  1.00 16.67           H  
ATOM    456  HE3 LYS A 119      20.867  63.278  24.732  1.00 16.65           H  
ATOM    457  HZ1 LYS A 119      22.238  63.136  22.840  1.00 17.07           H  
ATOM    458  HZ2 LYS A 119      21.001  63.619  21.792  1.00 16.84           H  
ATOM    459  HZ3 LYS A 119      20.938  62.098  22.530  1.00 17.09           H  
ATOM    460  N   ARG A 120      17.414  64.704  19.532  1.00 13.31           N  
ATOM    461  CA  ARG A 120      17.551  64.646  18.082  1.00 13.08           C  
ATOM    462  C   ARG A 120      16.290  64.081  17.433  1.00 12.15           C  
ATOM    463  O   ARG A 120      16.336  63.561  16.317  1.00 11.68           O  
ATOM    464  CB  ARG A 120      18.764  63.794  17.697  1.00 12.82           C  
ATOM    465  CG  ARG A 120      20.053  64.590  17.581  1.00 13.39           C  
ATOM    466  CD  ARG A 120      20.194  65.227  16.208  1.00 13.47           C  
ATOM    467  NE  ARG A 120      20.430  66.666  16.294  1.00 14.06           N  
ATOM    468  CZ  ARG A 120      21.600  67.239  16.018  1.00 14.44           C  
ATOM    469  NH1 ARG A 120      22.634  66.499  15.643  1.00 14.31           N  
ATOM    470  NH2 ARG A 120      21.734  68.554  16.120  1.00 15.09           N  
ATOM    471  H   ARG A 120      17.604  63.903  20.063  1.00 12.85           H  
ATOM    472  HA  ARG A 120      17.703  65.653  17.723  1.00 13.86           H  
ATOM    473  HB2 ARG A 120      18.901  63.029  18.447  1.00 12.38           H  
ATOM    474  HB3 ARG A 120      18.569  63.322  16.745  1.00 12.75           H  
ATOM    475  HG2 ARG A 120      20.054  65.368  18.329  1.00 13.86           H  
ATOM    476  HG3 ARG A 120      20.889  63.926  17.750  1.00 13.42           H  
ATOM    477  HD2 ARG A 120      21.026  64.766  15.696  1.00 13.44           H  
ATOM    478  HD3 ARG A 120      19.287  65.054  15.650  1.00 13.26           H  
ATOM    479  HE  ARG A 120      19.682  67.234  16.570  1.00 14.28           H  
ATOM    480 HH11 ARG A 120      22.537  65.507  15.565  1.00 13.92           H  
ATOM    481 HH12 ARG A 120      23.511  66.934  15.436  1.00 14.68           H  
ATOM    482 HH21 ARG A 120      20.958  69.116  16.403  1.00 15.30           H  
ATOM    483 HH22 ARG A 120      22.612  68.984  15.912  1.00 15.44           H  
ATOM    484  N   GLU A 121      15.167  64.198  18.139  1.00 11.98           N  
ATOM    485  CA  GLU A 121      13.881  63.710  17.643  1.00 11.15           C  
ATOM    486  C   GLU A 121      14.020  62.331  17.001  1.00 10.00           C  
ATOM    487  O   GLU A 121      13.739  62.155  15.813  1.00  9.65           O  
ATOM    488  CB  GLU A 121      13.295  64.702  16.636  1.00 11.64           C  
ATOM    489  CG  GLU A 121      12.894  66.031  17.256  1.00 12.24           C  
ATOM    490  CD  GLU A 121      12.473  67.055  16.221  1.00 13.04           C  
ATOM    491  OE1 GLU A 121      11.927  66.654  15.173  1.00 13.22           O  
ATOM    492  OE2 GLU A 121      12.690  68.265  16.461  1.00 13.61           O  
ATOM    493  H   GLU A 121      15.205  64.634  19.016  1.00 12.47           H  
ATOM    494  HA  GLU A 121      13.210  63.632  18.485  1.00 11.10           H  
ATOM    495  HB2 GLU A 121      14.029  64.893  15.866  1.00 12.14           H  
ATOM    496  HB3 GLU A 121      12.418  64.262  16.182  1.00 11.21           H  
ATOM    497  HG2 GLU A 121      12.069  65.866  17.930  1.00 12.02           H  
ATOM    498  HG3 GLU A 121      13.736  66.423  17.809  1.00 12.45           H  
ATOM    499  N   THR A 122      14.456  61.354  17.791  1.00  9.51           N  
ATOM    500  CA  THR A 122      14.633  59.994  17.297  1.00  8.44           C  
ATOM    501  C   THR A 122      14.127  58.974  18.312  1.00  7.82           C  
ATOM    502  O   THR A 122      13.624  59.338  19.374  1.00  8.35           O  
ATOM    503  CB  THR A 122      16.110  59.695  16.983  1.00  8.64           C  
ATOM    504  OG1 THR A 122      16.957  60.352  17.934  1.00  9.57           O  
ATOM    505  CG2 THR A 122      16.468  60.156  15.578  1.00  8.95           C  
ATOM    506  H   THR A 122      14.661  61.553  18.728  1.00  9.95           H  
ATOM    507  HA  THR A 122      14.063  59.892  16.384  1.00  8.02           H  
ATOM    508  HB  THR A 122      16.269  58.628  17.047  1.00  7.97           H  
ATOM    509  HG1 THR A 122      16.512  61.129  18.276  1.00  9.63           H  
ATOM    510 HG21 THR A 122      16.081  59.450  14.858  1.00  9.10           H  
ATOM    511 HG22 THR A 122      17.543  60.213  15.482  1.00  9.07           H  
ATOM    512 HG23 THR A 122      16.038  61.128  15.398  1.00  9.12           H  
ATOM    513  N   CYS A 123      14.268  57.694  17.979  1.00  6.82           N  
ATOM    514  CA  CYS A 123      13.828  56.621  18.861  1.00  6.32           C  
ATOM    515  C   CYS A 123      14.402  55.278  18.421  1.00  5.48           C  
ATOM    516  O   CYS A 123      14.991  55.167  17.346  1.00  5.04           O  
ATOM    517  CB  CYS A 123      12.299  56.552  18.891  1.00  5.96           C  
ATOM    518  SG  CYS A 123      11.567  55.765  17.437  1.00  5.05           S  
ATOM    519  H   CYS A 123      14.677  57.467  17.118  1.00  6.52           H  
ATOM    520  HA  CYS A 123      14.187  56.842  19.856  1.00  6.99           H  
ATOM    521  HB2 CYS A 123      11.987  55.989  19.760  1.00  5.78           H  
ATOM    522  HB3 CYS A 123      11.901  57.554  18.959  1.00  6.61           H  
ATOM    523  HG  CYS A 123      10.308  55.460  17.726  1.00  4.94           H  
ATOM    524  N   VAL A 124      14.221  54.263  19.258  1.00  5.51           N  
ATOM    525  CA  VAL A 124      14.714  52.923  18.964  1.00  5.03           C  
ATOM    526  C   VAL A 124      13.567  51.920  18.963  1.00  4.47           C  
ATOM    527  O   VAL A 124      12.795  51.848  19.921  1.00  4.86           O  
ATOM    528  CB  VAL A 124      15.775  52.478  19.989  1.00  5.88           C  
ATOM    529  CG1 VAL A 124      16.246  51.060  19.696  1.00  5.71           C  
ATOM    530  CG2 VAL A 124      16.947  53.446  19.998  1.00  6.50           C  
ATOM    531  H   VAL A 124      13.742  54.419  20.097  1.00  6.04           H  
ATOM    532  HA  VAL A 124      15.169  52.940  17.983  1.00  4.69           H  
ATOM    533  HB  VAL A 124      15.322  52.485  20.969  1.00  6.36           H  
ATOM    534 HG11 VAL A 124      15.717  50.367  20.332  1.00  5.77           H  
ATOM    535 HG12 VAL A 124      16.048  50.822  18.661  1.00  5.91           H  
ATOM    536 HG13 VAL A 124      17.308  50.987  19.885  1.00  5.68           H  
ATOM    537 HG21 VAL A 124      17.755  53.038  19.407  1.00  6.91           H  
ATOM    538 HG22 VAL A 124      16.636  54.391  19.579  1.00  6.56           H  
ATOM    539 HG23 VAL A 124      17.282  53.596  21.014  1.00  6.75           H  
ATOM    540  N   VAL A 125      13.451  51.151  17.885  1.00  3.79           N  
ATOM    541  CA  VAL A 125      12.387  50.162  17.771  1.00  3.55           C  
ATOM    542  C   VAL A 125      12.933  48.740  17.836  1.00  4.11           C  
ATOM    543  O   VAL A 125      14.005  48.448  17.304  1.00  4.19           O  
ATOM    544  CB  VAL A 125      11.602  50.333  16.457  1.00  2.74           C  
ATOM    545  CG1 VAL A 125      10.740  51.585  16.509  1.00  2.53           C  
ATOM    546  CG2 VAL A 125      12.550  50.378  15.268  1.00  2.61           C  
ATOM    547  H   VAL A 125      14.090  51.253  17.149  1.00  3.68           H  
ATOM    548  HA  VAL A 125      11.705  50.311  18.593  1.00  3.91           H  
ATOM    549  HB  VAL A 125      10.950  49.479  16.340  1.00  2.91           H  
ATOM    550 HG11 VAL A 125      10.666  52.011  15.521  1.00  2.50           H  
ATOM    551 HG12 VAL A 125       9.754  51.327  16.867  1.00  2.81           H  
ATOM    552 HG13 VAL A 125      11.190  52.302  17.178  1.00  2.85           H  
ATOM    553 HG21 VAL A 125      13.012  51.351  15.212  1.00  2.85           H  
ATOM    554 HG22 VAL A 125      13.315  49.624  15.388  1.00  2.89           H  
ATOM    555 HG23 VAL A 125      11.998  50.188  14.359  1.00  2.69           H  
ATOM    556  N   VAL A 126      12.177  47.860  18.484  1.00  4.74           N  
ATOM    557  CA  VAL A 126      12.564  46.461  18.618  1.00  5.60           C  
ATOM    558  C   VAL A 126      11.730  45.587  17.689  1.00  5.78           C  
ATOM    559  O   VAL A 126      10.502  45.674  17.677  1.00  5.73           O  
ATOM    560  CB  VAL A 126      12.393  45.964  20.065  1.00  6.59           C  
ATOM    561  CG1 VAL A 126      13.041  44.598  20.244  1.00  7.53           C  
ATOM    562  CG2 VAL A 126      12.973  46.971  21.047  1.00  6.75           C  
ATOM    563  H   VAL A 126      11.330  48.157  18.878  1.00  4.75           H  
ATOM    564  HA  VAL A 126      13.606  46.372  18.344  1.00  5.61           H  
ATOM    565  HB  VAL A 126      11.336  45.865  20.268  1.00  6.71           H  
ATOM    566 HG11 VAL A 126      13.856  44.493  19.543  1.00  7.85           H  
ATOM    567 HG12 VAL A 126      13.417  44.508  21.252  1.00  7.90           H  
ATOM    568 HG13 VAL A 126      12.308  43.827  20.062  1.00  7.73           H  
ATOM    569 HG21 VAL A 126      13.928  47.321  20.681  1.00  6.86           H  
ATOM    570 HG22 VAL A 126      12.298  47.807  21.148  1.00  7.04           H  
ATOM    571 HG23 VAL A 126      13.110  46.500  22.009  1.00  6.78           H  
ATOM    572  N   TYR A 127      12.400  44.746  16.908  1.00  6.19           N  
ATOM    573  CA  TYR A 127      11.714  43.863  15.973  1.00  6.72           C  
ATOM    574  C   TYR A 127      11.145  42.642  16.688  1.00  7.79           C  
ATOM    575  O   TYR A 127      11.880  41.730  17.063  1.00  8.59           O  
ATOM    576  CB  TYR A 127      12.667  43.426  14.859  1.00  7.03           C  
ATOM    577  CG  TYR A 127      12.775  44.428  13.730  1.00  6.28           C  
ATOM    578  CD1 TYR A 127      13.214  45.725  13.970  1.00  5.71           C  
ATOM    579  CD2 TYR A 127      12.433  44.080  12.430  1.00  6.38           C  
ATOM    580  CE1 TYR A 127      13.310  46.646  12.944  1.00  5.23           C  
ATOM    581  CE2 TYR A 127      12.528  44.997  11.398  1.00  5.99           C  
ATOM    582  CZ  TYR A 127      12.968  46.277  11.661  1.00  5.42           C  
ATOM    583  OH  TYR A 127      13.062  47.191  10.640  1.00  5.31           O  
ATOM    584  H   TYR A 127      13.379  44.722  16.959  1.00  6.26           H  
ATOM    585  HA  TYR A 127      10.898  44.419  15.534  1.00  6.24           H  
ATOM    586  HB2 TYR A 127      13.654  43.286  15.273  1.00  7.27           H  
ATOM    587  HB3 TYR A 127      12.320  42.491  14.441  1.00  7.71           H  
ATOM    588  HD1 TYR A 127      13.483  46.011  14.975  1.00  5.81           H  
ATOM    589  HD2 TYR A 127      12.089  43.077  12.228  1.00  6.93           H  
ATOM    590  HE1 TYR A 127      13.655  47.648  13.151  1.00  4.94           H  
ATOM    591  HE2 TYR A 127      12.258  44.708  10.394  1.00  6.30           H  
ATOM    592  HH  TYR A 127      13.173  48.071  11.007  1.00  5.35           H  
ATOM    593  N   THR A 128       9.830  42.643  16.877  1.00  7.86           N  
ATOM    594  CA  THR A 128       9.148  41.544  17.552  1.00  8.91           C  
ATOM    595  C   THR A 128       9.405  40.214  16.850  1.00  9.91           C  
ATOM    596  O   THR A 128       8.860  39.951  15.779  1.00 10.27           O  
ATOM    597  CB  THR A 128       7.630  41.786  17.623  1.00  8.84           C  
ATOM    598  OG1 THR A 128       7.325  43.118  17.196  1.00  7.77           O  
ATOM    599  CG2 THR A 128       7.113  41.572  19.038  1.00  9.50           C  
ATOM    600  H   THR A 128       9.305  43.406  16.559  1.00  7.23           H  
ATOM    601  HA  THR A 128       9.531  41.486  18.562  1.00  9.14           H  
ATOM    602  HB  THR A 128       7.138  41.083  16.966  1.00  9.27           H  
ATOM    603  HG1 THR A 128       6.541  43.430  17.652  1.00  7.67           H  
ATOM    604 HG21 THR A 128       6.412  42.354  19.286  1.00  9.78           H  
ATOM    605 HG22 THR A 128       7.942  41.598  19.731  1.00  9.69           H  
ATOM    606 HG23 THR A 128       6.622  40.614  19.102  1.00  9.70           H  
ATOM    607  N   GLY A 129      10.238  39.377  17.464  1.00 10.49           N  
ATOM    608  CA  GLY A 129      10.547  38.082  16.888  1.00 11.51           C  
ATOM    609  C   GLY A 129      11.965  37.996  16.358  1.00 11.53           C  
ATOM    610  O   GLY A 129      12.534  36.908  16.266  1.00 12.41           O  
ATOM    611  H   GLY A 129      10.639  39.640  18.319  1.00 10.32           H  
ATOM    612  HA2 GLY A 129      10.413  37.323  17.644  1.00 12.25           H  
ATOM    613  HA3 GLY A 129       9.860  37.888  16.076  1.00 11.63           H  
ATOM    614  N   TYR A 130      12.539  39.143  16.011  1.00 10.62           N  
ATOM    615  CA  TYR A 130      13.899  39.189  15.484  1.00 10.62           C  
ATOM    616  C   TYR A 130      14.889  39.615  16.566  1.00 10.60           C  
ATOM    617  O   TYR A 130      16.058  39.228  16.539  1.00 11.27           O  
ATOM    618  CB  TYR A 130      13.975  40.150  14.296  1.00  9.73           C  
ATOM    619  CG  TYR A 130      13.125  39.726  13.118  1.00 10.03           C  
ATOM    620  CD1 TYR A 130      11.771  40.034  13.066  1.00  9.83           C  
ATOM    621  CD2 TYR A 130      13.678  39.016  12.060  1.00 10.64           C  
ATOM    622  CE1 TYR A 130      10.993  39.648  11.992  1.00 10.27           C  
ATOM    623  CE2 TYR A 130      12.905  38.625  10.983  1.00 11.09           C  
ATOM    624  CZ  TYR A 130      11.565  38.944  10.954  1.00 10.92           C  
ATOM    625  OH  TYR A 130      10.792  38.558   9.881  1.00 11.49           O  
ATOM    626  H   TYR A 130      12.039  39.981  16.106  1.00  9.98           H  
ATOM    627  HA  TYR A 130      14.158  38.196  15.149  1.00 11.41           H  
ATOM    628  HB2 TYR A 130      13.640  41.127  14.610  1.00  8.96           H  
ATOM    629  HB3 TYR A 130      15.000  40.216  13.961  1.00  9.70           H  
ATOM    630  HD1 TYR A 130      11.327  40.587  13.881  1.00  9.40           H  
ATOM    631  HD2 TYR A 130      14.728  38.766  12.087  1.00 10.84           H  
ATOM    632  HE1 TYR A 130       9.942  39.898  11.968  1.00 10.18           H  
ATOM    633  HE2 TYR A 130      13.353  38.075  10.170  1.00 11.63           H  
ATOM    634  HH  TYR A 130       9.922  38.299  10.191  1.00 11.63           H  
ATOM    635  N   GLY A 131      14.410  40.410  17.518  1.00  9.97           N  
ATOM    636  CA  GLY A 131      15.261  40.873  18.600  1.00 10.07           C  
ATOM    637  C   GLY A 131      16.085  42.090  18.225  1.00  9.30           C  
ATOM    638  O   GLY A 131      16.359  42.943  19.071  1.00  9.47           O  
ATOM    639  H   GLY A 131      13.470  40.680  17.489  1.00  9.52           H  
ATOM    640  HA2 GLY A 131      14.640  41.121  19.447  1.00 10.03           H  
ATOM    641  HA3 GLY A 131      15.931  40.073  18.882  1.00 10.86           H  
ATOM    642  N   ASN A 132      16.489  42.169  16.959  1.00  8.58           N  
ATOM    643  CA  ASN A 132      17.294  43.287  16.476  1.00  7.89           C  
ATOM    644  C   ASN A 132      16.640  44.628  16.800  1.00  6.95           C  
ATOM    645  O   ASN A 132      15.417  44.760  16.755  1.00  6.64           O  
ATOM    646  CB  ASN A 132      17.509  43.172  14.966  1.00  7.85           C  
ATOM    647  CG  ASN A 132      17.992  41.795  14.551  1.00  7.69           C  
ATOM    648  OD1 ASN A 132      18.503  41.030  15.367  1.00  7.99           O  
ATOM    649  ND2 ASN A 132      17.834  41.475  13.271  1.00  7.49           N  
ATOM    650  H   ASN A 132      16.246  41.455  16.334  1.00  8.60           H  
ATOM    651  HA  ASN A 132      18.254  43.241  16.968  1.00  8.25           H  
ATOM    652  HB2 ASN A 132      16.577  43.371  14.460  1.00  8.44           H  
ATOM    653  HB3 ASN A 132      18.245  43.901  14.656  1.00  7.60           H  
ATOM    654 HD21 ASN A 132      17.421  42.135  12.677  1.00  7.44           H  
ATOM    655 HD22 ASN A 132      18.140  40.592  12.975  1.00  7.57           H  
ATOM    656  N   ARG A 133      17.467  45.619  17.119  1.00  6.59           N  
ATOM    657  CA  ARG A 133      16.981  46.955  17.443  1.00  5.87           C  
ATOM    658  C   ARG A 133      17.651  47.994  16.550  1.00  5.31           C  
ATOM    659  O   ARG A 133      18.878  48.060  16.478  1.00  5.65           O  
ATOM    660  CB  ARG A 133      17.251  47.279  18.914  1.00  6.37           C  
ATOM    661  CG  ARG A 133      16.274  46.619  19.874  1.00  6.55           C  
ATOM    662  CD  ARG A 133      16.961  46.191  21.161  1.00  7.46           C  
ATOM    663  NE  ARG A 133      17.689  47.291  21.787  1.00  7.96           N  
ATOM    664  CZ  ARG A 133      18.422  47.163  22.891  1.00  8.74           C  
ATOM    665  NH1 ARG A 133      18.521  45.985  23.491  1.00  9.12           N  
ATOM    666  NH2 ARG A 133      19.055  48.212  23.393  1.00  9.35           N  
ATOM    667  H   ARG A 133      18.432  45.451  17.132  1.00  6.92           H  
ATOM    668  HA  ARG A 133      15.916  46.975  17.265  1.00  5.60           H  
ATOM    669  HB2 ARG A 133      18.249  46.950  19.167  1.00  7.06           H  
ATOM    670  HB3 ARG A 133      17.190  48.350  19.052  1.00  6.16           H  
ATOM    671  HG2 ARG A 133      15.491  47.322  20.114  1.00  6.06           H  
ATOM    672  HG3 ARG A 133      15.847  45.751  19.397  1.00  6.73           H  
ATOM    673  HD2 ARG A 133      16.213  45.829  21.850  1.00  7.83           H  
ATOM    674  HD3 ARG A 133      17.656  45.394  20.935  1.00  7.63           H  
ATOM    675  HE  ARG A 133      17.632  48.173  21.361  1.00  7.87           H  
ATOM    676 HH11 ARG A 133      18.043  45.189  23.116  1.00  8.86           H  
ATOM    677 HH12 ARG A 133      19.072  45.891  24.321  1.00  9.80           H  
ATOM    678 HH21 ARG A 133      18.984  49.103  22.943  1.00  9.27           H  
ATOM    679 HH22 ARG A 133      19.605  48.115  24.223  1.00 10.00           H  
ATOM    680  N   GLU A 134      16.843  48.797  15.866  1.00  4.60           N  
ATOM    681  CA  GLU A 134      17.371  49.823  14.970  1.00  4.37           C  
ATOM    682  C   GLU A 134      16.778  51.193  15.287  1.00  4.10           C  
ATOM    683  O   GLU A 134      15.605  51.305  15.647  1.00  3.69           O  
ATOM    684  CB  GLU A 134      17.083  49.454  13.514  1.00  4.32           C  
ATOM    685  CG  GLU A 134      17.315  47.985  13.199  1.00  4.69           C  
ATOM    686  CD  GLU A 134      18.420  47.771  12.182  1.00  5.28           C  
ATOM    687  OE1 GLU A 134      19.598  47.715  12.593  1.00  5.81           O  
ATOM    688  OE2 GLU A 134      18.106  47.662  10.979  1.00  5.49           O  
ATOM    689  H   GLU A 134      15.872  48.694  15.959  1.00  4.39           H  
ATOM    690  HA  GLU A 134      18.439  49.868  15.116  1.00  4.78           H  
ATOM    691  HB2 GLU A 134      16.053  49.690  13.292  1.00  4.29           H  
ATOM    692  HB3 GLU A 134      17.723  50.043  12.872  1.00  4.53           H  
ATOM    693  HG2 GLU A 134      17.582  47.472  14.112  1.00  4.93           H  
ATOM    694  HG3 GLU A 134      16.399  47.565  12.807  1.00  4.73           H  
ATOM    695  N   GLU A 135      17.597  52.232  15.149  1.00  4.58           N  
ATOM    696  CA  GLU A 135      17.158  53.598  15.415  1.00  4.87           C  
ATOM    697  C   GLU A 135      16.396  54.165  14.221  1.00  4.79           C  
ATOM    698  O   GLU A 135      16.860  54.090  13.083  1.00  5.09           O  
ATOM    699  CB  GLU A 135      18.362  54.486  15.737  1.00  5.81           C  
ATOM    700  CG  GLU A 135      18.015  55.705  16.575  1.00  6.48           C  
ATOM    701  CD  GLU A 135      18.837  56.924  16.200  1.00  7.38           C  
ATOM    702  OE1 GLU A 135      18.600  57.488  15.112  1.00  7.78           O  
ATOM    703  OE2 GLU A 135      19.719  57.313  16.995  1.00  7.86           O  
ATOM    704  H   GLU A 135      18.519  52.077  14.857  1.00  4.92           H  
ATOM    705  HA  GLU A 135      16.500  53.575  16.271  1.00  4.73           H  
ATOM    706  HB2 GLU A 135      19.092  53.901  16.277  1.00  5.97           H  
ATOM    707  HB3 GLU A 135      18.801  54.827  14.810  1.00  6.02           H  
ATOM    708  HG2 GLU A 135      16.970  55.938  16.434  1.00  6.60           H  
ATOM    709  HG3 GLU A 135      18.194  55.474  17.615  1.00  6.41           H  
ATOM    710  N   GLN A 136      15.225  54.734  14.488  1.00  4.64           N  
ATOM    711  CA  GLN A 136      14.393  55.312  13.439  1.00  4.84           C  
ATOM    712  C   GLN A 136      13.852  56.674  13.861  1.00  5.56           C  
ATOM    713  O   GLN A 136      14.055  57.109  14.997  1.00  5.86           O  
ATOM    714  CB  GLN A 136      13.236  54.369  13.103  1.00  4.04           C  
ATOM    715  CG  GLN A 136      12.955  54.253  11.613  1.00  4.34           C  
ATOM    716  CD  GLN A 136      13.152  52.844  11.090  1.00  4.37           C  
ATOM    717  OE1 GLN A 136      13.545  51.941  11.832  1.00  4.53           O  
ATOM    718  NE2 GLN A 136      12.879  52.646   9.805  1.00  4.63           N  
ATOM    719  H   GLN A 136      14.909  54.760  15.415  1.00  4.55           H  
ATOM    720  HA  GLN A 136      15.010  55.440  12.560  1.00  5.29           H  
ATOM    721  HB2 GLN A 136      13.470  53.385  13.480  1.00  3.65           H  
ATOM    722  HB3 GLN A 136      12.341  54.728  13.590  1.00  3.98           H  
ATOM    723  HG2 GLN A 136      11.934  54.549  11.429  1.00  4.33           H  
ATOM    724  HG3 GLN A 136      13.622  54.915  11.081  1.00  4.99           H  
ATOM    725 HE21 GLN A 136      12.567  53.410   9.276  1.00  4.79           H  
ATOM    726 HE22 GLN A 136      12.997  51.745   9.441  1.00  4.88           H  
ATOM    727  N   ASN A 137      13.158  57.342  12.945  1.00  6.06           N  
ATOM    728  CA  ASN A 137      12.582  58.654  13.225  1.00  6.90           C  
ATOM    729  C   ASN A 137      11.133  58.521  13.681  1.00  6.54           C  
ATOM    730  O   ASN A 137      10.365  57.742  13.116  1.00  5.95           O  
ATOM    731  CB  ASN A 137      12.660  59.543  11.982  1.00  7.87           C  
ATOM    732  CG  ASN A 137      12.050  60.911  12.212  1.00  8.40           C  
ATOM    733  OD1 ASN A 137      12.207  61.506  13.278  1.00  8.92           O  
ATOM    734  ND2 ASN A 137      11.348  61.422  11.205  1.00  8.47           N  
ATOM    735  H   ASN A 137      13.027  56.942  12.059  1.00  5.98           H  
ATOM    736  HA  ASN A 137      13.159  59.106  14.019  1.00  7.24           H  
ATOM    737  HB2 ASN A 137      13.695  59.674  11.705  1.00  7.82           H  
ATOM    738  HB3 ASN A 137      12.133  59.064  11.171  1.00  8.38           H  
ATOM    739 HD21 ASN A 137      11.265  60.894  10.384  1.00  8.23           H  
ATOM    740 HD22 ASN A 137      10.941  62.306  11.326  1.00  8.87           H  
ATOM    741  N   LEU A 138      10.766  59.279  14.710  1.00  7.04           N  
ATOM    742  CA  LEU A 138       9.409  59.239  15.248  1.00  6.90           C  
ATOM    743  C   LEU A 138       8.378  59.574  14.173  1.00  7.16           C  
ATOM    744  O   LEU A 138       7.296  58.988  14.135  1.00  6.67           O  
ATOM    745  CB  LEU A 138       9.273  60.214  16.420  1.00  7.77           C  
ATOM    746  CG  LEU A 138       9.989  59.790  17.702  1.00  7.75           C  
ATOM    747  CD1 LEU A 138      10.202  60.988  18.616  1.00  8.95           C  
ATOM    748  CD2 LEU A 138       9.200  58.704  18.419  1.00  7.32           C  
ATOM    749  H   LEU A 138      11.426  59.873  15.129  1.00  7.61           H  
ATOM    750  HA  LEU A 138       9.224  58.237  15.604  1.00  6.08           H  
ATOM    751  HB2 LEU A 138       9.666  61.171  16.111  1.00  8.57           H  
ATOM    752  HB3 LEU A 138       8.223  60.331  16.641  1.00  7.78           H  
ATOM    753  HG  LEU A 138      10.960  59.388  17.450  1.00  7.33           H  
ATOM    754 HD11 LEU A 138      10.687  61.779  18.064  1.00  9.31           H  
ATOM    755 HD12 LEU A 138       9.245  61.337  18.980  1.00  9.31           H  
ATOM    756 HD13 LEU A 138      10.821  60.697  19.452  1.00  9.28           H  
ATOM    757 HD21 LEU A 138       8.173  58.722  18.081  1.00  7.31           H  
ATOM    758 HD22 LEU A 138       9.633  57.740  18.200  1.00  7.16           H  
ATOM    759 HD23 LEU A 138       9.231  58.879  19.485  1.00  7.45           H  
ATOM    760  N   SER A 139       8.719  60.520  13.301  1.00  8.07           N  
ATOM    761  CA  SER A 139       7.819  60.933  12.228  1.00  8.59           C  
ATOM    762  C   SER A 139       7.664  59.824  11.190  1.00  8.04           C  
ATOM    763  O   SER A 139       6.780  59.881  10.334  1.00  8.40           O  
ATOM    764  CB  SER A 139       8.342  62.206  11.559  1.00  9.76           C  
ATOM    765  OG  SER A 139       8.087  62.195  10.165  1.00 10.26           O  
ATOM    766  H   SER A 139       9.595  60.952  13.383  1.00  8.46           H  
ATOM    767  HA  SER A 139       6.854  61.136  12.665  1.00  8.66           H  
ATOM    768  HB2 SER A 139       7.853  63.065  11.994  1.00 10.08           H  
ATOM    769  HB3 SER A 139       9.408  62.281  11.716  1.00 10.07           H  
ATOM    770  HG  SER A 139       8.889  62.426   9.689  1.00 10.60           H  
ATOM    771  N   ASP A 140       8.527  58.817  11.272  1.00  7.28           N  
ATOM    772  CA  ASP A 140       8.485  57.697  10.340  1.00  6.90           C  
ATOM    773  C   ASP A 140       7.895  56.453  10.998  1.00  5.82           C  
ATOM    774  O   ASP A 140       7.913  55.365  10.423  1.00  5.53           O  
ATOM    775  CB  ASP A 140       9.890  57.391   9.817  1.00  6.97           C  
ATOM    776  CG  ASP A 140      10.356  58.400   8.784  1.00  7.80           C  
ATOM    777  OD1 ASP A 140       9.657  58.569   7.763  1.00  8.30           O  
ATOM    778  OD2 ASP A 140      11.416  59.023   8.999  1.00  8.12           O  
ATOM    779  H   ASP A 140       9.207  58.828  11.976  1.00  7.09           H  
ATOM    780  HA  ASP A 140       7.857  57.981   9.509  1.00  7.50           H  
ATOM    781  HB2 ASP A 140      10.586  57.404  10.643  1.00  7.25           H  
ATOM    782  HB3 ASP A 140       9.895  56.411   9.364  1.00  6.31           H  
ATOM    783  N   LEU A 141       7.370  56.622  12.209  1.00  5.41           N  
ATOM    784  CA  LEU A 141       6.773  55.512  12.944  1.00  4.46           C  
ATOM    785  C   LEU A 141       5.366  55.213  12.432  1.00  4.72           C  
ATOM    786  O   LEU A 141       4.515  56.100  12.385  1.00  5.47           O  
ATOM    787  CB  LEU A 141       6.727  55.825  14.443  1.00  4.23           C  
ATOM    788  CG  LEU A 141       8.017  55.529  15.211  1.00  3.96           C  
ATOM    789  CD1 LEU A 141       7.868  55.921  16.673  1.00  4.31           C  
ATOM    790  CD2 LEU A 141       8.388  54.056  15.090  1.00  3.01           C  
ATOM    791  H   LEU A 141       7.385  57.513  12.617  1.00  5.88           H  
ATOM    792  HA  LEU A 141       7.391  54.640  12.787  1.00  3.96           H  
ATOM    793  HB2 LEU A 141       6.495  56.875  14.561  1.00  4.97           H  
ATOM    794  HB3 LEU A 141       5.931  55.247  14.885  1.00  3.83           H  
ATOM    795  HG  LEU A 141       8.822  56.112  14.790  1.00  4.49           H  
ATOM    796 HD11 LEU A 141       8.194  55.104  17.301  1.00  4.36           H  
ATOM    797 HD12 LEU A 141       8.473  56.793  16.876  1.00  4.74           H  
ATOM    798 HD13 LEU A 141       6.834  56.145  16.884  1.00  4.50           H  
ATOM    799 HD21 LEU A 141       9.429  53.969  14.815  1.00  2.90           H  
ATOM    800 HD22 LEU A 141       8.222  53.565  16.039  1.00  2.92           H  
ATOM    801 HD23 LEU A 141       7.775  53.594  14.332  1.00  3.12           H  
ATOM    802  N   LEU A 142       5.132  53.962  12.051  1.00  4.30           N  
ATOM    803  CA  LEU A 142       3.829  53.549  11.543  1.00  4.79           C  
ATOM    804  C   LEU A 142       2.946  53.021  12.671  1.00  4.37           C  
ATOM    805  O   LEU A 142       3.443  52.509  13.673  1.00  3.72           O  
ATOM    806  CB  LEU A 142       3.991  52.475  10.463  1.00  5.32           C  
ATOM    807  CG  LEU A 142       5.095  52.745   9.439  1.00  5.88           C  
ATOM    808  CD1 LEU A 142       5.462  51.467   8.702  1.00  6.01           C  
ATOM    809  CD2 LEU A 142       4.659  53.822   8.459  1.00  6.92           C  
ATOM    810  H   LEU A 142       5.852  53.300  12.114  1.00  3.81           H  
ATOM    811  HA  LEU A 142       3.354  54.413  11.106  1.00  5.36           H  
ATOM    812  HB2 LEU A 142       4.204  51.533  10.953  1.00  4.99           H  
ATOM    813  HB3 LEU A 142       3.056  52.382   9.935  1.00  5.85           H  
ATOM    814  HG  LEU A 142       5.977  53.096   9.956  1.00  5.62           H  
ATOM    815 HD11 LEU A 142       5.460  51.654   7.637  1.00  6.04           H  
ATOM    816 HD12 LEU A 142       6.445  51.142   9.007  1.00  6.13           H  
ATOM    817 HD13 LEU A 142       4.741  50.697   8.934  1.00  6.31           H  
ATOM    818 HD21 LEU A 142       4.400  53.365   7.515  1.00  7.24           H  
ATOM    819 HD22 LEU A 142       3.800  54.342   8.854  1.00  7.20           H  
ATOM    820 HD23 LEU A 142       5.468  54.523   8.309  1.00  7.31           H  
ATOM    821  N   SER A 143       1.634  53.152  12.499  1.00  4.93           N  
ATOM    822  CA  SER A 143       0.679  52.690  13.500  1.00  4.89           C  
ATOM    823  C   SER A 143       0.590  51.164  13.506  1.00  5.19           C  
ATOM    824  O   SER A 143       0.915  50.513  12.513  1.00  5.64           O  
ATOM    825  CB  SER A 143      -0.701  53.296  13.229  1.00  5.50           C  
ATOM    826  OG  SER A 143      -0.600  54.455  12.420  1.00  6.07           O  
ATOM    827  H   SER A 143       1.300  53.571  11.677  1.00  5.50           H  
ATOM    828  HA  SER A 143       1.026  53.024  14.468  1.00  4.45           H  
ATOM    829  HB2 SER A 143      -1.318  52.571  12.720  1.00  5.79           H  
ATOM    830  HB3 SER A 143      -1.163  53.567  14.167  1.00  5.46           H  
ATOM    831  HG  SER A 143       0.011  55.076  12.824  1.00  6.37           H  
ATOM    832  N   PRO A 144       0.146  50.568  14.630  1.00  5.25           N  
ATOM    833  CA  PRO A 144       0.019  49.110  14.754  1.00  5.91           C  
ATOM    834  C   PRO A 144      -1.023  48.535  13.801  1.00  6.73           C  
ATOM    835  O   PRO A 144      -1.648  49.267  13.031  1.00  7.04           O  
ATOM    836  CB  PRO A 144      -0.419  48.906  16.210  1.00  6.05           C  
ATOM    837  CG  PRO A 144      -1.019  50.207  16.617  1.00  5.71           C  
ATOM    838  CD  PRO A 144      -0.264  51.262  15.865  1.00  5.04           C  
ATOM    839  HA  PRO A 144       0.965  48.618  14.587  1.00  5.88           H  
ATOM    840  HB2 PRO A 144      -1.142  48.103  16.260  1.00  6.76           H  
ATOM    841  HB3 PRO A 144       0.441  48.662  16.815  1.00  5.88           H  
ATOM    842  HG2 PRO A 144      -2.065  50.229  16.347  1.00  6.14           H  
ATOM    843  HG3 PRO A 144      -0.901  50.348  17.681  1.00  5.70           H  
ATOM    844  HD2 PRO A 144      -0.907  52.102  15.640  1.00  5.15           H  
ATOM    845  HD3 PRO A 144       0.599  51.585  16.428  1.00  4.57           H  
ATOM    846  N   ILE A 145      -1.206  47.218  13.856  1.00  7.30           N  
ATOM    847  CA  ILE A 145      -2.171  46.543  12.995  1.00  8.19           C  
ATOM    848  C   ILE A 145      -3.234  45.823  13.819  1.00  8.35           C  
ATOM    849  O   ILE A 145      -2.998  45.457  14.972  1.00  8.81           O  
ATOM    850  CB  ILE A 145      -1.483  45.524  12.064  1.00  8.86           C  
ATOM    851  CG1 ILE A 145      -0.088  46.016  11.672  1.00  9.14           C  
ATOM    852  CG2 ILE A 145      -2.334  45.283  10.826  1.00  9.47           C  
ATOM    853  CD1 ILE A 145       0.764  44.960  10.998  1.00  9.94           C  
ATOM    854  H   ILE A 145      -0.678  46.690  14.489  1.00  7.24           H  
ATOM    855  HA  ILE A 145      -2.652  47.291  12.383  1.00  8.49           H  
ATOM    856  HB  ILE A 145      -1.392  44.589  12.596  1.00  8.99           H  
ATOM    857 HG12 ILE A 145      -0.184  46.848  10.989  1.00  9.06           H  
ATOM    858 HG13 ILE A 145       0.433  46.345  12.560  1.00  9.11           H  
ATOM    859 HG21 ILE A 145      -2.747  44.285  10.861  1.00  9.85           H  
ATOM    860 HG22 ILE A 145      -3.137  46.005  10.794  1.00  9.78           H  
ATOM    861 HG23 ILE A 145      -1.721  45.387   9.941  1.00  9.44           H  
ATOM    862 HD11 ILE A 145       1.801  45.116  11.254  1.00 10.24           H  
ATOM    863 HD12 ILE A 145       0.454  43.981  11.333  1.00 10.18           H  
ATOM    864 HD13 ILE A 145       0.642  45.028   9.927  1.00 10.18           H  
TER     865      ILE A 145                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
