
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  465),  selected   59 , name 1mhn_A
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 1mhn_A.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    89_A      M     156          1.024
LGA    Q    90_A      V     157          1.888
LGA    Q    91_A      L     158          1.626
LGA    W    92_A      L     159          0.909
LGA    K    93_A      K     160          0.523
LGA    V    94_A      S     161          0.865
LGA    G    95_A      G     162          0.932
LGA    D    96_A      Q     163          0.561
LGA    K    97_A      L     164          0.596
LGA    C    98_A      I     165          0.889
LGA    S    99_A      K     166          1.065
LGA    A   100_A      T     167          1.011
LGA    I   101_A      E     168          1.172
LGA    W   102_A      W     169          1.785
LGA    S   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    D   105_A      E     170          1.634
LGA    G   106_A      G     171          2.600
LGA    C   107_A      T     172          1.913
LGA    I   108_A      W     173          1.418
LGA    Y   109_A      W     174          0.750
LGA    P   110_A      K     175          1.185
LGA    A   111_A      S     176          0.550
LGA    T   112_A      R     177          0.246
LGA    I   113_A      V     178          0.424
LGA    A   114_A      E     179          0.513
LGA    S   115_A      E     180          0.618
LGA    I   116_A      V     181          0.855
LGA    D   117_A      D     182          0.917
LGA    F   118_A      G     183          1.038
LGA    K   119_A      -       -           -
LGA    R   120_A      -       -           -
LGA    E   121_A      S     184          0.895
LGA    T   122_A      L     185          0.910
LGA    C   123_A      V     186          1.040
LGA    V   124_A      R     187          0.799
LGA    V   125_A      I     188          0.400
LGA    V   126_A      L     189          0.508
LGA    Y   127_A      F     190          0.755
LGA    T   128_A      L     191          1.378
LGA    G   129_A      D     192          2.174
LGA    Y   130_A      D     193          1.886
LGA    G   131_A      K     194          1.424
LGA    N   132_A      R     195          1.393
LGA    R   133_A      C     196          1.319
LGA    E   134_A      E     197          1.016
LGA    E   135_A      W     198          1.149
LGA    Q   136_A      I     199          0.970
LGA    N   137_A      Y     200          0.856
LGA    L   138_A      R     201          0.809
LGA    S   139_A      G     202          1.127
LGA    D   140_A      S     203          2.079
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    L   141_A      L     206          1.720
LGA    L   142_A      E     207          1.359
LGA    S   143_A      P     208          3.475
LGA    P   144_A      -       -           -
LGA    I   145_A      -       -           -
LGA    C   146_A      -       -           -
LGA    E   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   53    5.0     51    1.30    13.73     91.303     3.638

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.957345 * X  +  -0.258896 * Y  +  -0.128310 * Z  +   8.144044
  Y_new =  -0.226172 * X  +  -0.947780 * Y  +   0.224855 * Z  +  42.186588
  Z_new =  -0.179824 * X  +  -0.186243 * Y  +  -0.965907 * Z  +  15.295498 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.951113    0.190479  [ DEG:  -169.0863     10.9137 ]
  Theta =   0.180807    2.960786  [ DEG:    10.3595    169.6405 ]
  Phi   =  -0.231996    2.909597  [ DEG:   -13.2924    166.7076 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1mhn_A                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1mhn_A.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   53   5.0   51   1.30   13.73  91.303
REMARK  ---------------------------------------------------------- 
MOLECULE 1mhn_A
HEADER    RNA BINDING PROTEIN                     20-AUG-02   1MHN              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF THE SMN TUDOR DOMAIN             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: SMN, COMPONENT OF GEMS 1, GEMIN1;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET24D (MODIFIED)                     
KEYWDS    SMN, SMA, SPINAL MUSCULAR ATROPHY                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                            
REVDAT   1   25-MAR-03 1MHN    0                                                
JRNL        AUTH   R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                   
JRNL        TITL   HIGH RESOLUTION X-RAY AND NMR STRUCTURES OF THE              
JRNL        TITL 2 SMN TUDOR DOMAIN: CONFORMATIONAL VARIATION IN THE            
JRNL        TITL 3 BINDING SITE FOR SYMMETRICALLY DIMETHYLATED                  
JRNL        TITL 4 ARGININE RESIDUES                                            
JRNL        REF    J.MOL.BIOL.                   V. 327   507 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1MHN A   89   147  UNP    Q16637   SMN_HUMAN       89    147             
SEQRES   1 A   59  LEU GLN GLN TRP LYS VAL GLY ASP LYS CYS SER ALA ILE          
SEQRES   2 A   59  TRP SER GLU ASP GLY CYS ILE TYR PRO ALA THR ILE ALA          
SEQRES   3 A   59  SER ILE ASP PHE LYS ARG GLU THR CYS VAL VAL VAL TYR          
SEQRES   4 A   59  THR GLY TYR GLY ASN ARG GLU GLU GLN ASN LEU SER ASP          
SEQRES   5 A   59  LEU LEU SER PRO ILE CYS GLU                                  
FORMUL   2  HOH   *65(H2 O)                                                     
CRYST1   27.652   27.652  110.299  90.00  90.00 120.00 P 65          6          
ATOM      1  N   LEU A  89       4.334  64.144  13.421  1.00 24.98           N  
ATOM      2  CA  LEU A  89       4.700  63.240  14.527  1.00 24.12           C  
ATOM      3  C   LEU A  89       3.408  62.805  15.168  1.00 23.96           C  
ATOM      4  O   LEU A  89       2.447  63.587  15.252  1.00 24.32           O  
ATOM      5  CB  LEU A  89       5.577  63.955  15.584  1.00 23.63           C  
ATOM      6  CG  LEU A  89       6.994  64.391  15.249  1.00 26.77           C  
ATOM      7  CD1 LEU A  89       7.502  65.450  16.186  1.00 25.38           C  
ATOM      8  CD2 LEU A  89       7.935  63.190  15.274  1.00 25.60           C  
ATOM      9  N   GLN A  90       3.377  61.556  15.632  1.00 22.23           N  
ATOM     10  CA  GLN A  90       2.334  61.116  16.540  1.00 22.13           C  
ATOM     11  C   GLN A  90       2.919  61.012  17.951  1.00 20.54           C  
ATOM     12  O   GLN A  90       4.142  61.057  18.157  1.00 18.15           O  
ATOM     13  CB  GLN A  90       1.739  59.776  16.073  1.00 22.97           C  
ATOM     14  CG  GLN A  90       1.468  59.759  14.571  1.00 28.57           C  
ATOM     15  CD  GLN A  90       0.531  58.674  14.133  1.00 36.43           C  
ATOM     16  OE1 GLN A  90       0.962  57.535  13.886  1.00 38.45           O  
ATOM     17  NE2 GLN A  90      -0.760  59.014  14.010  1.00 39.04           N  
ATOM     18  N   GLN A  91       2.044  60.862  18.935  1.00 19.57           N  
ATOM     19  CA  GLN A  91       2.467  60.741  20.314  1.00 18.47           C  
ATOM     20  C   GLN A  91       2.848  59.276  20.527  1.00 18.52           C  
ATOM     21  O   GLN A  91       2.044  58.305  20.318  1.00 20.83           O  
ATOM     22  CB  GLN A  91       1.354  61.172  21.300  1.00 19.16           C  
ATOM     23  CG  GLN A  91       1.042  62.659  21.250  1.00 22.55           C  
ATOM     24  CD  GLN A  91      -0.321  63.054  21.858  1.00 28.43           C  
ATOM     25  OE1 GLN A  91      -1.266  62.240  21.930  1.00 33.66           O  
ATOM     26  NE2 GLN A  91      -0.428  64.304  22.269  1.00 27.12           N  
ATOM     27  N   TRP A  92       4.083  59.099  20.913  1.00 16.19           N  
ATOM     28  CA  TRP A  92       4.577  57.780  21.175  1.00 14.81           C  
ATOM     29  C   TRP A  92       5.152  57.786  22.577  1.00 15.35           C  
ATOM     30  O   TRP A  92       5.619  58.833  23.075  1.00 15.05           O  
ATOM     31  CB  TRP A  92       5.664  57.462  20.156  1.00 14.17           C  
ATOM     32  CG  TRP A  92       5.118  57.297  18.779  1.00 12.91           C  
ATOM     33  CD1 TRP A  92       5.251  58.182  17.724  1.00 13.33           C  
ATOM     34  CD2 TRP A  92       4.342  56.197  18.276  1.00 13.52           C  
ATOM     35  NE1 TRP A  92       4.640  57.683  16.598  1.00 15.53           N  
ATOM     36  CE2 TRP A  92       4.058  56.471  16.910  1.00 15.15           C  
ATOM     37  CE3 TRP A  92       3.874  54.987  18.835  1.00 11.66           C  
ATOM     38  CZ2 TRP A  92       3.315  55.587  16.096  1.00 15.45           C  
ATOM     39  CZ3 TRP A  92       3.142  54.112  18.033  1.00 12.34           C  
ATOM     40  CH2 TRP A  92       2.868  54.421  16.668  1.00 13.15           C  
ATOM     41  N   LYS A  93       5.198  56.595  23.170  1.00 15.43           N  
ATOM     42  CA  LYS A  93       5.840  56.437  24.464  1.00 14.65           C  
ATOM     43  C   LYS A  93       6.647  55.154  24.481  1.00 14.04           C  
ATOM     44  O   LYS A  93       6.399  54.229  23.691  1.00 12.98           O  
ATOM     45  CB  LYS A  93       4.818  56.476  25.601  1.00 15.47           C  
ATOM     46  CG  LYS A  93       3.823  55.389  25.647  1.00 19.62           C  
ATOM     47  CD  LYS A  93       2.523  55.933  26.322  1.00 27.90           C  
ATOM     48  CE  LYS A  93       1.395  54.888  26.247  1.00 27.15           C  
ATOM     49  NZ  LYS A  93       1.792  53.863  27.220  1.00 32.85           N  
ATOM     50  N   VAL A  94       7.616  55.097  25.365  1.00 12.55           N  
ATOM     51  CA  VAL A  94       8.445  53.904  25.494  1.00 13.46           C  
ATOM     52  C   VAL A  94       7.499  52.747  25.805  1.00 13.78           C  
ATOM     53  O   VAL A  94       6.533  52.880  26.629  1.00 14.88           O  
ATOM     54  CB  VAL A  94       9.510  54.069  26.605  1.00 13.04           C  
ATOM     55  CG1 VAL A  94      10.283  52.763  26.844  1.00 12.39           C  
ATOM     56  CG2 VAL A  94      10.538  55.144  26.212  1.00 14.56           C  
ATOM     57  N   GLY A  95       7.748  51.615  25.155  1.00 13.03           N  
ATOM     58  CA  GLY A  95       6.949  50.426  25.390  1.00 13.55           C  
ATOM     59  C   GLY A  95       5.764  50.326  24.431  1.00 12.52           C  
ATOM     60  O   GLY A  95       5.116  49.281  24.371  1.00 14.03           O  
ATOM     61  N   ASP A  96       5.444  51.398  23.708  1.00 13.27           N  
ATOM     62  CA  ASP A  96       4.289  51.369  22.760  1.00 11.63           C  
ATOM     63  C   ASP A  96       4.509  50.350  21.675  1.00 12.60           C  
ATOM     64  O   ASP A  96       5.651  50.126  21.264  1.00 10.59           O  
ATOM     65  CB  ASP A  96       4.079  52.699  22.046  1.00 12.58           C  
ATOM     66  CG  ASP A  96       3.175  53.617  22.772  1.00 15.59           C  
ATOM     67  OD1 ASP A  96       2.429  53.145  23.697  1.00 17.45           O  
ATOM     68  OD2 ASP A  96       3.114  54.848  22.448  1.00 15.07           O  
ATOM     69  N   LYS A  97       3.430  49.689  21.242  1.00 10.27           N  
ATOM     70  CA  LYS A  97       3.516  48.836  20.074  1.00 11.34           C  
ATOM     71  C   LYS A  97       3.390  49.716  18.831  1.00 10.56           C  
ATOM     72  O   LYS A  97       2.529  50.606  18.758  1.00 10.62           O  
ATOM     73  CB  LYS A  97       2.349  47.856  20.046  1.00 10.78           C  
ATOM     74  CG  LYS A  97       2.361  46.817  21.162  1.00 16.39           C  
ATOM     75  CD  LYS A  97       0.992  46.051  20.955  1.00 23.84           C  
ATOM     76  CE  LYS A  97       0.756  44.885  21.892  1.00 31.15           C  
ATOM     77  NZ  LYS A  97       0.423  43.677  21.076  1.00 33.93           N  
ATOM     78  N   CYS A  98       4.183  49.427  17.813  1.00 11.64           N  
ATOM     79  CA  CYS A  98       4.076  50.192  16.587  1.00 10.84           C  
ATOM     80  C   CYS A  98       4.489  49.222  15.451  1.00 11.41           C  
ATOM     81  O   CYS A  98       4.732  48.030  15.692  1.00 12.26           O  
ATOM     82  CB  CYS A  98       5.014  51.421  16.618  1.00 12.56           C  
ATOM     83  SG  CYS A  98       6.763  50.974  16.674  1.00 13.22           S  
ATOM     84  N   SER A  99       4.566  49.731  14.223  1.00 10.29           N  
ATOM     85  CA  SER A  99       5.223  48.985  13.166  1.00  9.74           C  
ATOM     86  C   SER A  99       6.199  49.937  12.491  1.00  9.45           C  
ATOM     87  O   SER A  99       6.095  51.136  12.643  1.00  9.89           O  
ATOM     88  CB  SER A  99       4.175  48.475  12.192  1.00 11.97           C  
ATOM     89  OG  SER A  99       3.398  47.480  12.915  1.00 10.62           O  
ATOM     90  N   ALA A 100       7.211  49.386  11.841  1.00 10.80           N  
ATOM     91  CA  ALA A 100       8.161  50.266  11.181  1.00 10.51           C  
ATOM     92  C   ALA A 100       8.788  49.565  10.011  1.00 11.16           C  
ATOM     93  O   ALA A 100       8.780  48.338   9.930  1.00 10.85           O  
ATOM     94  CB  ALA A 100       9.254  50.718  12.231  1.00 11.66           C  
ATOM     95  N   ILE A 101       9.320  50.353   9.069  1.00 12.15           N  
ATOM     96  CA  ILE A 101      10.040  49.779   7.946  1.00 12.14           C  
ATOM     97  C   ILE A 101      11.452  49.441   8.365  1.00 13.09           C  
ATOM     98  O   ILE A 101      12.234  50.336   8.732  1.00 12.15           O  
ATOM     99  CB  ILE A 101      10.034  50.825   6.742  1.00 11.75           C  
ATOM    100  CG1 ILE A 101       8.579  51.235   6.414  1.00 12.63           C  
ATOM    101  CG2 ILE A 101      10.819  50.300   5.565  1.00 11.99           C  
ATOM    102  CD1 ILE A 101       8.434  52.515   5.449  1.00 13.30           C  
ATOM    103  N   TRP A 102      11.832  48.180   8.257  1.00 13.23           N  
ATOM    104  CA  TRP A 102      13.187  47.795   8.599  1.00 15.00           C  
ATOM    105  C   TRP A 102      14.142  48.180   7.466  1.00 16.94           C  
ATOM    106  O   TRP A 102      13.862  47.903   6.294  1.00 15.64           O  
ATOM    107  CB  TRP A 102      13.226  46.299   8.785  1.00 17.63           C  
ATOM    108  CG  TRP A 102      14.384  45.779   9.561  1.00 19.22           C  
ATOM    109  CD1 TRP A 102      15.603  46.381   9.798  1.00 20.09           C  
ATOM    110  CD2 TRP A 102      14.417  44.517  10.225  1.00 21.77           C  
ATOM    111  NE1 TRP A 102      16.385  45.549  10.575  1.00 22.51           N  
ATOM    112  CE2 TRP A 102      15.669  44.406  10.858  1.00 23.67           C  
ATOM    113  CE3 TRP A 102      13.479  43.468  10.376  1.00 23.79           C  
ATOM    114  CZ2 TRP A 102      16.027  43.267  11.607  1.00 26.89           C  
ATOM    115  CZ3 TRP A 102      13.815  42.350  11.122  1.00 25.93           C  
ATOM    116  CH2 TRP A 102      15.087  42.254  11.733  1.00 27.49           C  
ATOM    117  N   SER A 103      15.255  48.814   7.809  1.00 17.32           N  
ATOM    118  CA  SER A 103      16.116  49.382   6.765  1.00 20.48           C  
ATOM    119  C   SER A 103      16.863  48.299   6.009  1.00 20.42           C  
ATOM    120  O   SER A 103      17.415  48.556   4.924  1.00 20.80           O  
ATOM    121  CB  SER A 103      17.085  50.455   7.299  1.00 20.20           C  
ATOM    122  OG  SER A 103      18.011  49.881   8.211  1.00 26.42           O  
ATOM    123  N   GLU A 104      16.878  47.099   6.568  1.00 20.34           N  
ATOM    124  CA  GLU A 104      17.596  45.985   5.965  1.00 22.28           C  
ATOM    125  C   GLU A 104      16.887  45.439   4.726  1.00 20.57           C  
ATOM    126  O   GLU A 104      17.538  44.967   3.771  1.00 20.50           O  
ATOM    127  CB  GLU A 104      17.825  44.889   7.031  1.00 24.78           C  
ATOM    128  CG  GLU A 104      17.324  43.498   6.708  1.00 30.32           C  
ATOM    129  CD  GLU A 104      16.736  42.799   7.923  1.00 38.29           C  
ATOM    130  OE1 GLU A 104      17.504  42.585   8.906  1.00 39.09           O  
ATOM    131  OE2 GLU A 104      15.506  42.496   7.880  1.00 38.17           O  
ATOM    132  N   ASP A 105      15.566  45.485   4.713  1.00 18.29           N  
ATOM    133  CA  ASP A 105      14.854  44.887   3.573  1.00 17.58           C  
ATOM    134  C   ASP A 105      13.725  45.721   3.026  1.00 14.68           C  
ATOM    135  O   ASP A 105      13.131  45.330   2.031  1.00 16.83           O  
ATOM    136  CB  ASP A 105      14.399  43.436   3.848  1.00 17.63           C  
ATOM    137  CG  ASP A 105      13.229  43.368   4.822  1.00 20.47           C  
ATOM    138  OD1 ASP A 105      12.867  44.416   5.412  1.00 16.43           O  
ATOM    139  OD2 ASP A 105      12.601  42.322   5.026  1.00 20.50           O  
ATOM    140  N   GLY A 106      13.448  46.884   3.642  1.00 13.48           N  
ATOM    141  CA  GLY A 106      12.386  47.780   3.207  1.00 11.88           C  
ATOM    142  C   GLY A 106      10.977  47.257   3.433  1.00 13.55           C  
ATOM    143  O   GLY A 106      10.053  47.692   2.759  1.00 13.22           O  
ATOM    144  N   CYS A 107      10.828  46.314   4.370  1.00 13.06           N  
ATOM    145  CA  CYS A 107       9.510  45.730   4.675  1.00 14.57           C  
ATOM    146  C   CYS A 107       9.037  46.213   6.031  1.00 13.39           C  
ATOM    147  O   CYS A 107       9.856  46.578   6.861  1.00 13.06           O  
ATOM    148  CB  CYS A 107       9.619  44.222   4.744  1.00 14.21           C  
ATOM    149  SG  CYS A 107       9.958  43.476   3.101  1.00 20.69           S  
ATOM    150  N   ILE A 108       7.729  46.131   6.252  1.00 12.60           N  
ATOM    151  CA  ILE A 108       7.137  46.588   7.503  1.00 12.49           C  
ATOM    152  C   ILE A 108       7.205  45.446   8.516  1.00 11.02           C  
ATOM    153  O   ILE A 108       6.877  44.307   8.148  1.00 11.27           O  
ATOM    154  CB  ILE A 108       5.689  46.932   7.291  1.00 12.05           C  
ATOM    155  CG1 ILE A 108       5.535  48.164   6.379  1.00 14.13           C  
ATOM    156  CG2 ILE A 108       4.983  47.253   8.687  1.00 12.86           C  
ATOM    157  CD1 ILE A 108       4.050  48.405   5.940  1.00 18.26           C  
ATOM    158  N   TYR A 109       7.560  45.741   9.779  1.00 10.20           N  
ATOM    159  CA  TYR A 109       7.583  44.706  10.807  1.00 10.90           C  
ATOM    160  C   TYR A 109       6.947  45.240  12.046  1.00 11.43           C  
ATOM    161  O   TYR A 109       7.047  46.430  12.289  1.00 10.59           O  
ATOM    162  CB  TYR A 109       9.000  44.297  11.134  1.00 12.34           C  
ATOM    163  CG  TYR A 109       9.623  43.462  10.038  1.00 14.56           C  
ATOM    164  CD1 TYR A 109      10.365  44.081   8.983  1.00 15.29           C  
ATOM    165  CD2 TYR A 109       9.496  42.106  10.032  1.00 17.04           C  
ATOM    166  CE1 TYR A 109      10.934  43.364   7.982  1.00 14.67           C  
ATOM    167  CE2 TYR A 109      10.101  41.337   8.990  1.00 17.35           C  
ATOM    168  CZ  TYR A 109      10.811  41.988   7.973  1.00 18.16           C  
ATOM    169  OH  TYR A 109      11.419  41.252   6.976  1.00 20.05           O  
ATOM    170  N   PRO A 110       6.301  44.385  12.870  1.00 11.19           N  
ATOM    171  CA  PRO A 110       5.826  44.849  14.181  1.00 11.58           C  
ATOM    172  C   PRO A 110       7.026  45.174  15.064  1.00 10.75           C  
ATOM    173  O   PRO A 110       8.060  44.492  15.018  1.00 11.36           O  
ATOM    174  CB  PRO A 110       5.135  43.592  14.770  1.00 10.04           C  
ATOM    175  CG  PRO A 110       5.808  42.380  14.049  1.00 11.06           C  
ATOM    176  CD  PRO A 110       6.019  42.952  12.648  1.00 13.79           C  
ATOM    177  N   ALA A 111       6.861  46.173  15.932  1.00 10.42           N  
ATOM    178  CA  ALA A 111       7.944  46.593  16.811  1.00 10.95           C  
ATOM    179  C   ALA A 111       7.392  47.160  18.115  1.00 11.55           C  
ATOM    180  O   ALA A 111       6.182  47.419  18.215  1.00 10.55           O  
ATOM    181  CB  ALA A 111       8.784  47.636  16.101  1.00  9.80           C  
ATOM    182  N   THR A 112       8.278  47.247  19.119  1.00 11.13           N  
ATOM    183  CA  THR A 112       8.051  47.936  20.408  1.00 12.64           C  
ATOM    184  C   THR A 112       9.101  49.064  20.531  1.00 12.50           C  
ATOM    185  O   THR A 112      10.259  48.874  20.158  1.00 13.72           O  
ATOM    186  CB  THR A 112       8.298  46.948  21.555  1.00 11.23           C  
ATOM    187  OG1 THR A 112       7.443  45.800  21.366  1.00 17.52           O  
ATOM    188  CG2 THR A 112       7.826  47.550  22.811  1.00 15.61           C  
ATOM    189  N   ILE A 113       8.689  50.233  21.033  1.00 12.93           N  
ATOM    190  CA  ILE A 113       9.611  51.325  21.268  1.00 11.97           C  
ATOM    191  C   ILE A 113      10.402  51.083  22.541  1.00 12.75           C  
ATOM    192  O   ILE A 113       9.819  50.919  23.606  1.00 12.84           O  
ATOM    193  CB  ILE A 113       8.904  52.674  21.338  1.00 12.62           C  
ATOM    194  CG1 ILE A 113       8.139  52.959  20.027  1.00  9.88           C  
ATOM    195  CG2 ILE A 113       9.957  53.784  21.634  1.00 10.79           C  
ATOM    196  CD1 ILE A 113       7.177  54.181  20.137  1.00 10.89           C  
ATOM    197  N   ALA A 114      11.719  51.061  22.398  1.00 13.06           N  
ATOM    198  CA  ALA A 114      12.674  50.760  23.485  1.00 14.44           C  
ATOM    199  C   ALA A 114      13.178  52.040  24.163  1.00 14.15           C  
ATOM    200  O   ALA A 114      13.524  52.017  25.331  1.00 13.53           O  
ATOM    201  CB  ALA A 114      13.889  49.993  22.919  1.00 13.48           C  
ATOM    202  N   SER A 115      13.271  53.121  23.401  1.00 13.78           N  
ATOM    203  CA  SER A 115      13.810  54.383  23.913  1.00 13.59           C  
ATOM    204  C   SER A 115      13.396  55.473  22.960  1.00 12.87           C  
ATOM    205  O   SER A 115      13.211  55.214  21.764  1.00 12.31           O  
ATOM    206  CB  SER A 115      15.335  54.340  24.064  1.00 14.19           C  
ATOM    207  OG  SER A 115      15.999  54.186  22.815  1.00 16.14           O  
ATOM    208  N   ILE A 116      13.227  56.683  23.469  1.00 12.82           N  
ATOM    209  CA  ILE A 116      12.975  57.815  22.575  1.00 13.35           C  
ATOM    210  C   ILE A 116      13.993  58.946  22.904  1.00 13.79           C  
ATOM    211  O   ILE A 116      14.281  59.215  24.062  1.00 15.12           O  
ATOM    212  CB  ILE A 116      11.535  58.331  22.742  1.00 13.26           C  
ATOM    213  CG1 ILE A 116      10.473  57.239  22.423  1.00 12.72           C  
ATOM    214  CG2 ILE A 116      11.250  59.595  21.879  1.00 12.87           C  
ATOM    215  CD1 ILE A 116       9.105  57.595  22.900  1.00 13.05           C  
ATOM    216  N   ASP A 117      14.511  59.580  21.880  1.00 13.13           N  
ATOM    217  CA  ASP A 117      15.349  60.763  22.043  1.00 14.69           C  
ATOM    218  C   ASP A 117      14.600  61.924  21.472  1.00 15.18           C  
ATOM    219  O   ASP A 117      14.584  62.174  20.242  1.00 15.48           O  
ATOM    220  CB  ASP A 117      16.695  60.510  21.338  1.00 14.24           C  
ATOM    221  CG  ASP A 117      17.656  61.684  21.440  1.00 18.13           C  
ATOM    222  OD1 ASP A 117      17.231  62.827  21.735  1.00 19.47           O  
ATOM    223  OD2 ASP A 117      18.856  61.509  21.203  1.00 20.06           O  
ATOM    224  N   PHE A 118      13.935  62.643  22.375  1.00 15.31           N  
ATOM    225  CA  PHE A 118      12.998  63.667  21.959  1.00 16.43           C  
ATOM    226  C   PHE A 118      13.743  64.820  21.295  1.00 17.80           C  
ATOM    227  O   PHE A 118      13.255  65.371  20.320  1.00 19.78           O  
ATOM    228  CB  PHE A 118      12.157  64.131  23.159  1.00 15.86           C  
ATOM    229  CG  PHE A 118      11.028  63.197  23.487  1.00 15.90           C  
ATOM    230  CD1 PHE A 118      11.014  62.481  24.699  1.00 18.31           C  
ATOM    231  CD2 PHE A 118       9.995  62.993  22.581  1.00 17.37           C  
ATOM    232  CE1 PHE A 118      10.002  61.568  24.950  1.00 15.60           C  
ATOM    233  CE2 PHE A 118       8.958  62.081  22.853  1.00 17.36           C  
ATOM    234  CZ  PHE A 118       8.966  61.391  24.038  1.00 14.32           C  
ATOM    235  N   LYS A 119      14.937  65.147  21.775  1.00 18.51           N  
ATOM    236  CA  LYS A 119      15.678  66.284  21.200  1.00 20.39           C  
ATOM    237  C   LYS A 119      16.058  66.047  19.737  1.00 18.80           C  
ATOM    238  O   LYS A 119      16.028  66.980  18.917  1.00 20.18           O  
ATOM    239  CB  LYS A 119      16.922  66.638  22.031  1.00 21.63           C  
ATOM    240  CG  LYS A 119      16.797  68.012  22.780  1.00 28.48           C  
ATOM    241  CD  LYS A 119      17.508  67.995  24.161  1.00 36.13           C  
ATOM    242  CE  LYS A 119      16.910  68.998  25.189  1.00 38.94           C  
ATOM    243  NZ  LYS A 119      16.793  68.390  26.584  1.00 41.55           N  
ATOM    244  N   ARG A 120      16.383  64.796  19.402  1.00 17.23           N  
ATOM    245  CA  ARG A 120      16.718  64.463  18.018  1.00 15.97           C  
ATOM    246  C   ARG A 120      15.532  63.931  17.218  1.00 16.15           C  
ATOM    247  O   ARG A 120      15.628  63.746  16.007  1.00 15.94           O  
ATOM    248  CB  ARG A 120      17.883  63.486  17.982  1.00 16.59           C  
ATOM    249  CG  ARG A 120      19.115  64.029  18.697  1.00 15.54           C  
ATOM    250  CD  ARG A 120      20.408  63.419  18.246  1.00 16.50           C  
ATOM    251  NE  ARG A 120      21.522  63.901  19.086  1.00 15.46           N  
ATOM    252  CZ  ARG A 120      22.283  64.974  18.768  1.00 15.79           C  
ATOM    253  NH1 ARG A 120      22.091  65.638  17.629  1.00 13.86           N  
ATOM    254  NH2 ARG A 120      23.276  65.330  19.555  1.00 13.79           N  
ATOM    255  N   GLU A 121      14.406  63.733  17.909  1.00 15.83           N  
ATOM    256  CA  GLU A 121      13.171  63.189  17.329  1.00 16.50           C  
ATOM    257  C   GLU A 121      13.388  61.789  16.753  1.00 15.79           C  
ATOM    258  O   GLU A 121      12.843  61.420  15.711  1.00 17.02           O  
ATOM    259  CB  GLU A 121      12.586  64.153  16.287  1.00 16.84           C  
ATOM    260  CG  GLU A 121      12.238  65.509  16.867  1.00 21.26           C  
ATOM    261  CD  GLU A 121      11.006  65.548  17.785  1.00 27.84           C  
ATOM    262  OE1 GLU A 121      10.566  64.548  18.356  1.00 30.26           O  
ATOM    263  OE2 GLU A 121      10.461  66.648  17.955  1.00 34.42           O  
ATOM    264  N   THR A 122      14.176  61.012  17.445  1.00 14.63           N  
ATOM    265  CA  THR A 122      14.393  59.649  17.020  1.00 14.44           C  
ATOM    266  C   THR A 122      13.976  58.726  18.144  1.00 12.73           C  
ATOM    267  O   THR A 122      13.734  59.153  19.302  1.00 12.77           O  
ATOM    268  CB  THR A 122      15.881  59.364  16.625  1.00 15.00           C  
ATOM    269  OG1 THR A 122      16.749  59.559  17.750  1.00 14.90           O  
ATOM    270  CG2 THR A 122      16.400  60.375  15.587  1.00 17.82           C  
ATOM    271  N   CYS A 123      13.908  57.455  17.796  1.00 12.36           N  
ATOM    272  CA  CYS A 123      13.723  56.419  18.810  1.00 12.67           C  
ATOM    273  C   CYS A 123      14.476  55.172  18.387  1.00 12.83           C  
ATOM    274  O   CYS A 123      14.992  55.107  17.262  1.00 13.81           O  
ATOM    275  CB  CYS A 123      12.241  56.132  18.999  1.00 11.40           C  
ATOM    276  SG  CYS A 123      11.478  55.523  17.453  1.00 13.78           S  
ATOM    277  N   VAL A 124      14.586  54.203  19.294  1.00 11.72           N  
ATOM    278  CA  VAL A 124      15.047  52.882  18.952  1.00 12.15           C  
ATOM    279  C   VAL A 124      13.807  51.955  19.089  1.00 12.46           C  
ATOM    280  O   VAL A 124      13.124  51.953  20.111  1.00 11.23           O  
ATOM    281  CB  VAL A 124      16.121  52.380  19.878  1.00 13.52           C  
ATOM    282  CG1 VAL A 124      16.476  50.861  19.602  1.00 14.49           C  
ATOM    283  CG2 VAL A 124      17.360  53.242  19.756  1.00 13.54           C  
ATOM    284  N   VAL A 125      13.568  51.173  18.045  1.00 11.94           N  
ATOM    285  CA  VAL A 125      12.554  50.100  18.098  1.00 12.01           C  
ATOM    286  C   VAL A 125      13.191  48.725  18.072  1.00 11.98           C  
ATOM    287  O   VAL A 125      14.310  48.522  17.532  1.00 14.06           O  
ATOM    288  CB  VAL A 125      11.509  50.235  16.960  1.00 11.85           C  
ATOM    289  CG1 VAL A 125      10.947  51.610  16.968  1.00 10.80           C  
ATOM    290  CG2 VAL A 125      12.143  49.977  15.561  1.00 13.39           C  
ATOM    291  N   VAL A 126      12.476  47.766  18.664  1.00 11.36           N  
ATOM    292  CA  VAL A 126      12.894  46.395  18.644  1.00 12.68           C  
ATOM    293  C   VAL A 126      11.850  45.638  17.837  1.00 12.94           C  
ATOM    294  O   VAL A 126      10.671  45.651  18.170  1.00 12.27           O  
ATOM    295  CB  VAL A 126      12.966  45.820  20.065  1.00 13.33           C  
ATOM    296  CG1 VAL A 126      13.283  44.316  20.052  1.00 14.79           C  
ATOM    297  CG2 VAL A 126      14.018  46.605  20.929  1.00 14.04           C  
ATOM    298  N   TYR A 127      12.294  44.973  16.790  1.00 13.53           N  
ATOM    299  CA  TYR A 127      11.366  44.252  15.937  1.00 13.83           C  
ATOM    300  C   TYR A 127      10.963  42.980  16.649  1.00 15.12           C  
ATOM    301  O   TYR A 127      11.789  42.122  16.920  1.00 14.70           O  
ATOM    302  CB  TYR A 127      11.987  43.962  14.585  1.00 12.96           C  
ATOM    303  CG  TYR A 127      12.256  45.227  13.847  1.00 12.64           C  
ATOM    304  CD1 TYR A 127      13.574  45.665  13.671  1.00 12.69           C  
ATOM    305  CD2 TYR A 127      11.179  46.052  13.393  1.00 12.95           C  
ATOM    306  CE1 TYR A 127      13.856  46.904  12.987  1.00 14.20           C  
ATOM    307  CE2 TYR A 127      11.466  47.276  12.743  1.00 14.11           C  
ATOM    308  CZ  TYR A 127      12.801  47.669  12.527  1.00 13.71           C  
ATOM    309  OH  TYR A 127      13.081  48.874  11.885  1.00 14.52           O  
ATOM    310  N   THR A 128       9.672  42.924  16.941  1.00 16.87           N  
ATOM    311  CA  THR A 128       9.032  41.909  17.810  1.00 17.00           C  
ATOM    312  C   THR A 128       9.166  40.519  17.286  1.00 16.18           C  
ATOM    313  O   THR A 128       8.513  40.158  16.292  1.00 19.10           O  
ATOM    314  CB  THR A 128       7.518  42.204  17.824  1.00 17.63           C  
ATOM    315  OG1 THR A 128       7.282  43.466  18.409  1.00 18.88           O  
ATOM    316  CG2 THR A 128       6.760  41.261  18.743  1.00 21.38           C  
ATOM    317  N   GLY A 129       9.957  39.701  17.963  1.00 16.38           N  
ATOM    318  CA  GLY A 129      10.132  38.343  17.549  1.00 16.60           C  
ATOM    319  C   GLY A 129      11.173  38.190  16.460  1.00 18.07           C  
ATOM    320  O   GLY A 129      11.364  37.077  15.926  1.00 18.86           O  
ATOM    321  N   TYR A 130      11.861  39.287  16.135  1.00 17.89           N  
ATOM    322  CA  TYR A 130      12.902  39.262  15.128  1.00 18.37           C  
ATOM    323  C   TYR A 130      14.305  39.549  15.692  1.00 19.33           C  
ATOM    324  O   TYR A 130      15.287  39.588  14.930  1.00 19.21           O  
ATOM    325  CB  TYR A 130      12.571  40.248  14.020  1.00 18.52           C  
ATOM    326  CG  TYR A 130      11.297  39.911  13.296  1.00 18.99           C  
ATOM    327  CD1 TYR A 130      10.086  40.463  13.683  1.00 20.70           C  
ATOM    328  CD2 TYR A 130      11.294  39.002  12.233  1.00 18.98           C  
ATOM    329  CE1 TYR A 130       8.903  40.146  13.015  1.00 21.80           C  
ATOM    330  CE2 TYR A 130      10.132  38.699  11.566  1.00 20.61           C  
ATOM    331  CZ  TYR A 130       8.936  39.265  11.963  1.00 23.14           C  
ATOM    332  OH  TYR A 130       7.744  38.956  11.316  1.00 27.79           O  
ATOM    333  N   GLY A 131      14.376  39.822  17.003  1.00 18.30           N  
ATOM    334  CA  GLY A 131      15.619  39.885  17.753  1.00 18.95           C  
ATOM    335  C   GLY A 131      16.565  40.998  17.423  1.00 20.71           C  
ATOM    336  O   GLY A 131      17.748  40.920  17.755  1.00 21.00           O  
ATOM    337  N   ASN A 132      16.066  42.032  16.749  1.00 20.36           N  
ATOM    338  CA  ASN A 132      16.930  43.055  16.198  1.00 21.54           C  
ATOM    339  C   ASN A 132      16.333  44.418  16.508  1.00 20.96           C  
ATOM    340  O   ASN A 132      15.130  44.532  16.720  1.00 20.70           O  
ATOM    341  CB  ASN A 132      17.026  42.898  14.667  1.00 22.58           C  
ATOM    342  CG  ASN A 132      18.239  42.087  14.227  1.00 27.86           C  
ATOM    343  OD1 ASN A 132      18.095  41.016  13.616  1.00 31.24           O  
ATOM    344  ND2 ASN A 132      19.452  42.590  14.539  1.00 32.44           N  
ATOM    345  N   ARG A 133      17.169  45.453  16.522  1.00 20.25           N  
ATOM    346  CA  ARG A 133      16.704  46.783  16.840  1.00 19.80           C  
ATOM    347  C   ARG A 133      17.257  47.793  15.843  1.00 20.40           C  
ATOM    348  O   ARG A 133      18.239  47.534  15.134  1.00 19.90           O  
ATOM    349  CB  ARG A 133      17.127  47.150  18.272  1.00 20.38           C  
ATOM    350  CG  ARG A 133      18.602  47.510  18.340  1.00 22.71           C  
ATOM    351  CD  ARG A 133      19.060  47.871  19.711  1.00 25.76           C  
ATOM    352  NE  ARG A 133      18.989  46.698  20.555  1.00 26.60           N  
ATOM    353  CZ  ARG A 133      19.079  46.746  21.861  1.00 26.60           C  
ATOM    354  NH1 ARG A 133      19.260  47.922  22.444  1.00 28.78           N  
ATOM    355  NH2 ARG A 133      19.007  45.626  22.569  1.00 22.60           N  
ATOM    356  N   GLU A 134      16.661  48.969  15.819  1.00 18.63           N  
ATOM    357  CA  GLU A 134      17.058  49.946  14.840  1.00 20.06           C  
ATOM    358  C   GLU A 134      16.599  51.315  15.313  1.00 19.00           C  
ATOM    359  O   GLU A 134      15.537  51.423  15.917  1.00 18.38           O  
ATOM    360  CB  GLU A 134      16.392  49.543  13.514  1.00 19.72           C  
ATOM    361  CG  GLU A 134      16.179  50.606  12.504  1.00 24.74           C  
ATOM    362  CD  GLU A 134      16.171  49.984  11.137  1.00 28.00           C  
ATOM    363  OE1 GLU A 134      15.111  49.581  10.678  1.00 25.35           O  
ATOM    364  OE2 GLU A 134      17.261  49.876  10.557  1.00 34.34           O  
ATOM    365  N   GLU A 135      17.410  52.356  15.048  1.00 18.23           N  
ATOM    366  CA  GLU A 135      16.956  53.728  15.204  1.00 17.78           C  
ATOM    367  C   GLU A 135      16.010  54.070  14.100  1.00 16.52           C  
ATOM    368  O   GLU A 135      16.242  53.721  12.926  1.00 16.85           O  
ATOM    369  CB  GLU A 135      18.164  54.693  15.184  1.00 20.25           C  
ATOM    370  CG  GLU A 135      17.848  56.149  15.505  1.00 25.46           C  
ATOM    371  CD  GLU A 135      19.057  56.808  16.154  1.00 35.03           C  
ATOM    372  OE1 GLU A 135      19.891  57.367  15.408  1.00 35.95           O  
ATOM    373  OE2 GLU A 135      19.205  56.701  17.402  1.00 39.30           O  
ATOM    374  N   GLN A 136      14.950  54.775  14.466  1.00 14.27           N  
ATOM    375  CA  GLN A 136      13.929  55.263  13.565  1.00 14.69           C  
ATOM    376  C   GLN A 136      13.662  56.723  13.907  1.00 15.36           C  
ATOM    377  O   GLN A 136      13.713  57.119  15.085  1.00 15.68           O  
ATOM    378  CB  GLN A 136      12.585  54.507  13.756  1.00 14.28           C  
ATOM    379  CG  GLN A 136      12.570  53.066  13.318  1.00 13.40           C  
ATOM    380  CD  GLN A 136      12.393  52.839  11.809  1.00 15.88           C  
ATOM    381  OE1 GLN A 136      11.896  53.705  11.078  1.00 16.89           O  
ATOM    382  NE2 GLN A 136      12.773  51.642  11.356  1.00 14.22           N  
ATOM    383  N   ASN A 137      13.369  57.535  12.901  1.00 15.31           N  
ATOM    384  CA  ASN A 137      12.761  58.829  13.178  1.00 16.53           C  
ATOM    385  C   ASN A 137      11.383  58.574  13.737  1.00 15.03           C  
ATOM    386  O   ASN A 137      10.668  57.693  13.239  1.00 13.44           O  
ATOM    387  CB  ASN A 137      12.624  59.656  11.913  1.00 18.97           C  
ATOM    388  CG  ASN A 137      13.965  59.959  11.291  1.00 22.69           C  
ATOM    389  OD1 ASN A 137      14.920  60.291  11.995  1.00 21.51           O  
ATOM    390  ND2 ASN A 137      14.059  59.786   9.970  1.00 23.88           N  
ATOM    391  N   LEU A 138      11.014  59.301  14.792  1.00 13.95           N  
ATOM    392  CA  LEU A 138       9.633  59.200  15.292  1.00 13.03           C  
ATOM    393  C   LEU A 138       8.608  59.431  14.159  1.00 13.55           C  
ATOM    394  O   LEU A 138       7.572  58.745  14.130  1.00 12.76           O  
ATOM    395  CB  LEU A 138       9.370  60.195  16.425  1.00 12.70           C  
ATOM    396  CG  LEU A 138      10.050  59.878  17.752  1.00 14.13           C  
ATOM    397  CD1 LEU A 138      10.045  61.063  18.612  1.00 15.22           C  
ATOM    398  CD2 LEU A 138       9.278  58.726  18.425  1.00 12.31           C  
ATOM    399  N   SER A 139       8.890  60.344  13.218  1.00 12.04           N  
ATOM    400  CA  SER A 139       7.921  60.640  12.147  1.00 14.70           C  
ATOM    401  C   SER A 139       7.648  59.440  11.233  1.00 14.00           C  
ATOM    402  O   SER A 139       6.664  59.454  10.505  1.00 16.53           O  
ATOM    403  CB  SER A 139       8.357  61.836  11.277  1.00 13.76           C  
ATOM    404  OG  SER A 139       9.655  61.586  10.816  1.00 17.61           O  
ATOM    405  N   ASP A 140       8.532  58.457  11.245  1.00 14.52           N  
ATOM    406  CA  ASP A 140       8.469  57.321  10.336  1.00 13.21           C  
ATOM    407  C   ASP A 140       7.763  56.118  10.956  1.00 13.57           C  
ATOM    408  O   ASP A 140       7.590  55.104  10.264  1.00 13.77           O  
ATOM    409  CB  ASP A 140       9.865  56.877   9.896  1.00 13.35           C  
ATOM    410  CG  ASP A 140      10.541  57.872   8.964  1.00 14.72           C  
ATOM    411  OD1 ASP A 140       9.829  58.660   8.308  1.00 18.24           O  
ATOM    412  OD2 ASP A 140      11.781  57.894   8.843  1.00 17.84           O  
ATOM    413  N   LEU A 141       7.354  56.213  12.233  1.00 11.97           N  
ATOM    414  CA  LEU A 141       6.690  55.041  12.877  1.00 11.52           C  
ATOM    415  C   LEU A 141       5.285  54.926  12.308  1.00 11.40           C  
ATOM    416  O   LEU A 141       4.651  55.936  11.913  1.00 11.40           O  
ATOM    417  CB  LEU A 141       6.643  55.214  14.412  1.00 10.24           C  
ATOM    418  CG  LEU A 141       8.029  55.187  15.064  1.00 10.59           C  
ATOM    419  CD1 LEU A 141       7.755  55.355  16.600  1.00 10.72           C  
ATOM    420  CD2 LEU A 141       8.896  53.938  14.814  1.00  8.38           C  
ATOM    421  N   LEU A 142       4.797  53.684  12.270  1.00 12.13           N  
ATOM    422  CA  LEU A 142       3.492  53.394  11.746  1.00 10.57           C  
ATOM    423  C   LEU A 142       2.606  52.768  12.817  1.00 11.42           C  
ATOM    424  O   LEU A 142       3.081  52.174  13.804  1.00 10.91           O  
ATOM    425  CB  LEU A 142       3.594  52.398  10.598  1.00 10.93           C  
ATOM    426  CG  LEU A 142       4.642  52.633   9.483  1.00 13.72           C  
ATOM    427  CD1 LEU A 142       4.869  51.411   8.624  1.00 13.71           C  
ATOM    428  CD2 LEU A 142       4.165  53.828   8.677  1.00 15.19           C  
ATOM    429  N   SER A 143       1.321  52.870  12.562  1.00 11.77           N  
ATOM    430  CA  SER A 143       0.304  52.149  13.342  1.00 12.35           C  
ATOM    431  C   SER A 143       0.656  50.702  13.557  1.00 11.34           C  
ATOM    432  O   SER A 143       1.067  50.035  12.603  1.00 12.53           O  
ATOM    433  CB  SER A 143      -1.010  52.143  12.561  1.00 12.83           C  
ATOM    434  OG  SER A 143      -1.960  51.360  13.279  1.00 17.49           O  
ATOM    435  N   PRO A 144       0.441  50.153  14.771  1.00 11.95           N  
ATOM    436  CA  PRO A 144       0.757  48.751  14.976  1.00 12.92           C  
ATOM    437  C   PRO A 144      -0.163  47.835  14.157  1.00 13.91           C  
ATOM    438  O   PRO A 144       0.149  46.684  14.085  1.00 12.67           O  
ATOM    439  CB  PRO A 144       0.582  48.539  16.488  1.00 13.67           C  
ATOM    440  CG  PRO A 144      -0.332  49.604  16.934  1.00 13.27           C  
ATOM    441  CD  PRO A 144       0.051  50.820  16.042  1.00 11.28           C  
ATOM    442  N   ILE A 145      -1.257  48.352  13.584  1.00 15.28           N  
ATOM    443  CA  ILE A 145      -2.084  47.556  12.660  1.00 18.46           C  
ATOM    444  C   ILE A 145      -1.363  47.195  11.340  1.00 19.93           C  
ATOM    445  O   ILE A 145      -1.632  46.132  10.744  1.00 19.05           O  
ATOM    446  CB  ILE A 145      -3.388  48.277  12.395  1.00 18.94           C  
ATOM    447  CG1 ILE A 145      -4.178  48.421  13.707  1.00 21.76           C  
ATOM    448  CG2 ILE A 145      -4.242  47.558  11.298  1.00 21.94           C  
ATOM    449  CD1 ILE A 145      -5.375  49.356  13.579  1.00 27.58           C  
ATOM    450  N   CYS A 146      -0.456  48.054  10.859  1.00 21.33           N  
ATOM    451  CA  CYS A 146       0.291  47.724   9.630  1.00 23.96           C  
ATOM    452  C   CYS A 146       1.226  46.593   9.837  1.00 24.98           C  
ATOM    453  O   CYS A 146       2.152  46.709  10.635  1.00 25.48           O  
ATOM    454  CB  CYS A 146       1.153  48.866   9.137  1.00 25.09           C  
ATOM    455  SG  CYS A 146       0.221  50.312   9.218  1.00 27.50           S  
ATOM    456  N   GLU A 147       1.043  45.531   9.077  1.00 26.02           N  
ATOM    457  CA  GLU A 147       2.001  44.425   9.140  1.00 28.66           C  
ATOM    458  C   GLU A 147       2.370  43.866   7.761  1.00 28.95           C  
ATOM    459  O   GLU A 147       3.221  43.001   7.571  1.00 29.73           O  
ATOM    460  CB  GLU A 147       1.505  43.362  10.131  1.00 29.32           C  
ATOM    461  CG  GLU A 147       1.734  43.796  11.579  1.00 31.74           C  
ATOM    462  CD  GLU A 147       1.267  42.810  12.623  1.00 33.34           C  
ATOM    463  OE1 GLU A 147       2.135  42.289  13.356  1.00 36.57           O  
ATOM    464  OE2 GLU A 147       0.045  42.602  12.764  1.00 33.03           O  
ATOM    465  OXT GLU A 147       1.842  44.301   6.739  1.00 30.39           O  
TER     466      GLU A 147                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
