
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1582),  selected  107 , name 1wjq_A
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 1wjq_A.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    H    12_A      M     156          4.107
LGA    G    13_A      V     157          3.240
LGA    F    14_A      L     158          2.646
LGA    -       -      L     159           -
LGA    Q    15_A      K     160          1.449
LGA    K    16_A      S     161          1.244
LGA    K    17_A      G     162          0.399
LGA    M    18_A      Q     163          0.491
LGA    K    19_A      L     164          0.799
LGA    L    20_A      I     165          0.897
LGA    E    21_A      K     166          0.914
LGA    V    22_A      T     167          0.549
LGA    V    23_A      E     168          0.584
LGA    D    24_A      W     169          0.309
LGA    K    25_A      -       -           -
LGA    R    26_A      -       -           -
LGA    N    27_A      E     170          1.212
LGA    P    28_A      G     171          1.873
LGA    M    29_A      -       -           -
LGA    F    30_A      T     172          0.925
LGA    I    31_A      W     173          0.688
LGA    R    32_A      W     174          0.964
LGA    V    33_A      K     175          1.026
LGA    A    34_A      S     176          0.820
LGA    T    35_A      R     177          0.192
LGA    V    36_A      V     178          0.215
LGA    A    37_A      E     179          0.383
LGA    D    38_A      E     180          0.359
LGA    T    39_A      V     181          0.913
LGA    D    40_A      D     182          1.277
LGA    D    41_A      G     183          0.579
LGA    H    42_A      S     184          0.696
LGA    R    43_A      L     185          0.820
LGA    V    44_A      V     186          0.341
LGA    K    45_A      R     187          0.540
LGA    V    46_A      I     188          0.702
LGA    H    47_A      L     189          0.330
LGA    F    48_A      F     190          1.034
LGA    D    49_A      L     191          1.260
LGA    G    50_A      D     192          3.343
LGA    W    51_A      D     193          1.325
LGA    N    52_A      K     194          2.955
LGA    N    53_A      R     195          2.910
LGA    C    54_A      -       -           -
LGA    Y    55_A      -       -           -
LGA    D    56_A      C     196          1.018
LGA    Y    57_A      E     197          0.660
LGA    W    58_A      W     198          0.145
LGA    I    59_A      I     199          0.574
LGA    D    60_A      Y     200          0.682
LGA    A    61_A      R     201          0.948
LGA    D    62_A      G     202          0.540
LGA    S    63_A      S     203          0.336
LGA    P    64_A      T     204          1.424
LGA    D    65_A      R     205          1.860
LGA    I    66_A      L     206          1.108
LGA    H    67_A      E     207          0.460
LGA    P    68_A      P     208          2.707
LGA    V    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    W    71_A      -       -           -
LGA    C    72_A      -       -           -
LGA    S    73_A      -       -           -
LGA    K    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    H    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    P    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    S    84_A      -       -           -
LGA    P    85_A      -       -           -
LGA    L    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    L    88_A      -       -           -
LGA    M    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    A    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    H    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    G    96_A      -       -           -
LGA    C    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    T    99_A      -       -           -
LGA    P   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    G   103_A      -       -           -
LGA    P   104_A      -       -           -
LGA    S   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    G   107_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107   53    5.0     52    1.43    15.38     93.289     3.398

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.052004 * X  +  -0.319416 * Y  +  -0.946186 * Z  +   3.521274
  Y_new =   0.922806 * X  +   0.377546 * Y  +  -0.076734 * Z  +  45.523602
  Z_new =   0.381739 * X  +  -0.869156 * Y  +   0.314393 * Z  +  15.056740 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.223717    1.917876  [ DEG:   -70.1138    109.8862 ]
  Theta =  -0.391677   -2.749916  [ DEG:   -22.4414   -157.5586 ]
  Phi   =   1.514502   -1.627091  [ DEG:    86.7746    -93.2254 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wjq_A                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wjq_A.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107   53   5.0   52   1.43   15.38  93.289
REMARK  ---------------------------------------------------------- 
MOLECULE 1wjq_A
HEADER    PROTEIN BINDING                         29-MAY-04   1WJQ              
TITLE     SOLUTION STRUCTURE OF THE THIRD MBT DOMAIN FROM HUMAN                 
TITLE    2 KIAA1798 PROTEIN                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KIAA1798 PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: MBT DOMAIN;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA FJ20547;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040119-32;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    MBT DOMAIN, KIAA1798, STRUCTURAL GENOMICS, RIKEN STRUCTURAL           
KEYWDS   2 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.TOMIZAWA,T.KIGAWA,S.KOSHIBA,M.INOUE,S.YOKOYAMA,RIKEN                
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   29-NOV-04 1WJQ    0                                                
JRNL        AUTH   T.TOMIZAWA,T.KIGAWA,S.KOSHIBA,M.INOUE,S.YOKOYAMA             
JRNL        TITL   SOLUTION STRUCTURE OF THE THIRD MBT DOMAIN FROM              
JRNL        TITL 2 HUMAN KIAA1798 PROTEIN                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WJQ A    8   101  UNP    Q96JM7   LMBL3_HUMAN    470    563             
SEQRES   1 A  107  GLY SER SER GLY SER SER GLY VAL LYS PRO PRO HIS GLY          
SEQRES   2 A  107  PHE GLN LYS LYS MET LYS LEU GLU VAL VAL ASP LYS ARG          
SEQRES   3 A  107  ASN PRO MET PHE ILE ARG VAL ALA THR VAL ALA ASP THR          
SEQRES   4 A  107  ASP ASP HIS ARG VAL LYS VAL HIS PHE ASP GLY TRP ASN          
SEQRES   5 A  107  ASN CYS TYR ASP TYR TRP ILE ASP ALA ASP SER PRO ASP          
SEQRES   6 A  107  ILE HIS PRO VAL GLY TRP CYS SER LYS THR GLY HIS PRO          
SEQRES   7 A  107  LEU GLN PRO PRO LEU SER PRO LEU GLU LEU MET GLU ALA          
SEQRES   8 A  107  SER GLU HIS GLY GLY CYS SER THR PRO GLY SER GLY PRO          
SEQRES   9 A  107  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       0.974  59.430  45.373  1.00  0.00           N  
ATOM      2  CA  GLY A   1       1.151  60.684  44.662  1.00  0.00           C  
ATOM      3  C   GLY A   1      -0.157  61.243  44.138  1.00  0.00           C  
ATOM      4  O   GLY A   1      -1.038  61.608  44.915  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       1.597  61.405  45.331  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       1.819  60.520  43.829  1.00  0.00           H  
ATOM      7  H1  GLY A   1       0.368  59.388  46.142  1.00  0.00           H  
ATOM      8  N   SER A   2      -0.282  61.310  42.817  1.00  0.00           N  
ATOM      9  CA  SER A   2      -1.490  61.834  42.189  1.00  0.00           C  
ATOM     10  C   SER A   2      -2.003  63.060  42.938  1.00  0.00           C  
ATOM     11  O   SER A   2      -3.204  63.208  43.160  1.00  0.00           O  
ATOM     12  CB  SER A   2      -2.576  60.758  42.146  1.00  0.00           C  
ATOM     13  OG  SER A   2      -2.873  60.281  43.448  1.00  0.00           O  
ATOM     14  H   SER A   2       0.457  61.003  42.250  1.00  0.00           H  
ATOM     15  HA  SER A   2      -1.240  62.122  41.179  1.00  0.00           H  
ATOM     16  HB2 SER A   2      -3.473  61.171  41.713  1.00  0.00           H  
ATOM     17  HB3 SER A   2      -2.234  59.929  41.542  1.00  0.00           H  
ATOM     18  HG  SER A   2      -3.751  60.576  43.704  1.00  0.00           H  
ATOM     19  N   SER A   3      -1.082  63.937  43.325  1.00  0.00           N  
ATOM     20  CA  SER A   3      -1.440  65.150  44.052  1.00  0.00           C  
ATOM     21  C   SER A   3      -0.965  66.392  43.304  1.00  0.00           C  
ATOM     22  O   SER A   3       0.183  66.814  43.445  1.00  0.00           O  
ATOM     23  CB  SER A   3      -0.836  65.124  45.457  1.00  0.00           C  
ATOM     24  OG  SER A   3      -1.593  65.917  46.354  1.00  0.00           O  
ATOM     25  H   SER A   3      -0.140  63.764  43.118  1.00  0.00           H  
ATOM     26  HA  SER A   3      -2.516  65.183  44.133  1.00  0.00           H  
ATOM     27  HB2 SER A   3      -0.819  64.107  45.821  1.00  0.00           H  
ATOM     28  HB3 SER A   3       0.174  65.509  45.419  1.00  0.00           H  
ATOM     29  HG  SER A   3      -1.055  66.648  46.669  1.00  0.00           H  
ATOM     30  N   GLY A   4      -1.856  66.974  42.509  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -1.511  68.162  41.751  1.00  0.00           C  
ATOM     32  C   GLY A   4      -1.872  68.038  40.283  1.00  0.00           C  
ATOM     33  O   GLY A   4      -2.901  67.459  39.936  1.00  0.00           O  
ATOM     34  H   GLY A   4      -2.757  66.594  42.437  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -2.035  69.007  42.169  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -0.448  68.332  41.834  1.00  0.00           H  
ATOM     37  N   SER A   5      -1.022  68.584  39.419  1.00  0.00           N  
ATOM     38  CA  SER A   5      -1.259  68.537  37.981  1.00  0.00           C  
ATOM     39  C   SER A   5       0.047  68.700  37.209  1.00  0.00           C  
ATOM     40  O   SER A   5       1.002  69.301  37.703  1.00  0.00           O  
ATOM     41  CB  SER A   5      -2.247  69.630  37.569  1.00  0.00           C  
ATOM     42  OG  SER A   5      -3.586  69.205  37.760  1.00  0.00           O  
ATOM     43  H   SER A   5      -0.218  69.032  39.757  1.00  0.00           H  
ATOM     44  HA  SER A   5      -1.684  67.572  37.746  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -2.073  70.512  38.166  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -2.103  69.867  36.525  1.00  0.00           H  
ATOM     47  HG  SER A   5      -4.183  69.824  37.332  1.00  0.00           H  
ATOM     48  N   SER A   6       0.081  68.160  35.995  1.00  0.00           N  
ATOM     49  CA  SER A   6       1.271  68.241  35.155  1.00  0.00           C  
ATOM     50  C   SER A   6       0.913  68.042  33.686  1.00  0.00           C  
ATOM     51  O   SER A   6       0.617  66.929  33.253  1.00  0.00           O  
ATOM     52  CB  SER A   6       2.299  67.194  35.588  1.00  0.00           C  
ATOM     53  OG  SER A   6       1.838  65.882  35.316  1.00  0.00           O  
ATOM     54  H   SER A   6      -0.712  67.693  35.657  1.00  0.00           H  
ATOM     55  HA  SER A   6       1.697  69.225  35.280  1.00  0.00           H  
ATOM     56  HB2 SER A   6       3.221  67.356  35.053  1.00  0.00           H  
ATOM     57  HB3 SER A   6       2.478  67.287  36.650  1.00  0.00           H  
ATOM     58  HG  SER A   6       0.878  65.875  35.315  1.00  0.00           H  
ATOM     59  N   GLY A   7       0.942  69.131  32.923  1.00  0.00           N  
ATOM     60  CA  GLY A   7       0.619  69.056  31.510  1.00  0.00           C  
ATOM     61  C   GLY A   7       1.812  69.360  30.625  1.00  0.00           C  
ATOM     62  O   GLY A   7       2.553  70.311  30.877  1.00  0.00           O  
ATOM     63  H   GLY A   7       1.185  69.992  33.323  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       0.262  68.061  31.286  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      -0.165  69.766  31.295  1.00  0.00           H  
ATOM     66  N   VAL A   8       1.999  68.551  29.588  1.00  0.00           N  
ATOM     67  CA  VAL A   8       3.111  68.739  28.664  1.00  0.00           C  
ATOM     68  C   VAL A   8       2.740  68.279  27.259  1.00  0.00           C  
ATOM     69  O   VAL A   8       1.707  67.641  27.053  1.00  0.00           O  
ATOM     70  CB  VAL A   8       4.363  67.972  29.129  1.00  0.00           C  
ATOM     71  CG1 VAL A   8       4.809  68.459  30.499  1.00  0.00           C  
ATOM     72  CG2 VAL A   8       4.094  66.475  29.148  1.00  0.00           C  
ATOM     73  H   VAL A   8       1.375  67.811  29.441  1.00  0.00           H  
ATOM     74  HA  VAL A   8       3.348  69.792  28.636  1.00  0.00           H  
ATOM     75  HB  VAL A   8       5.161  68.165  28.427  1.00  0.00           H  
ATOM     76 HG11 VAL A   8       5.818  68.123  30.690  1.00  0.00           H  
ATOM     77 HG12 VAL A   8       4.776  69.539  30.527  1.00  0.00           H  
ATOM     78 HG13 VAL A   8       4.148  68.059  31.255  1.00  0.00           H  
ATOM     79 HG21 VAL A   8       3.581  66.191  28.242  1.00  0.00           H  
ATOM     80 HG22 VAL A   8       5.033  65.941  29.210  1.00  0.00           H  
ATOM     81 HG23 VAL A   8       3.483  66.229  30.002  1.00  0.00           H  
ATOM     82  N   LYS A   9       3.590  68.606  26.292  1.00  0.00           N  
ATOM     83  CA  LYS A   9       3.354  68.226  24.904  1.00  0.00           C  
ATOM     84  C   LYS A   9       4.404  67.227  24.427  1.00  0.00           C  
ATOM     85  O   LYS A   9       5.577  67.298  24.798  1.00  0.00           O  
ATOM     86  CB  LYS A   9       3.368  69.464  24.004  1.00  0.00           C  
ATOM     87  CG  LYS A   9       2.303  70.487  24.362  1.00  0.00           C  
ATOM     88  CD  LYS A   9       2.768  71.411  25.474  1.00  0.00           C  
ATOM     89  CE  LYS A   9       1.627  72.264  26.005  1.00  0.00           C  
ATOM     90  NZ  LYS A   9       1.306  73.393  25.089  1.00  0.00           N  
ATOM     91  H   LYS A   9       4.397  69.116  26.517  1.00  0.00           H  
ATOM     92  HA  LYS A   9       2.382  67.761  24.847  1.00  0.00           H  
ATOM     93  HB2 LYS A   9       4.335  69.940  24.081  1.00  0.00           H  
ATOM     94  HB3 LYS A   9       3.210  69.154  22.982  1.00  0.00           H  
ATOM     95  HG2 LYS A   9       2.077  71.079  23.487  1.00  0.00           H  
ATOM     96  HG3 LYS A   9       1.413  69.967  24.687  1.00  0.00           H  
ATOM     97  HD2 LYS A   9       3.164  70.816  26.284  1.00  0.00           H  
ATOM     98  HD3 LYS A   9       3.543  72.060  25.090  1.00  0.00           H  
ATOM     99  HE2 LYS A   9       0.752  71.642  26.115  1.00  0.00           H  
ATOM    100  HE3 LYS A   9       1.909  72.661  26.968  1.00  0.00           H  
ATOM    101  HZ1 LYS A   9       1.903  74.215  25.313  1.00  0.00           H  
ATOM    102  HZ2 LYS A   9       0.308  73.666  25.194  1.00  0.00           H  
ATOM    103  HZ3 LYS A   9       1.477  73.113  24.103  1.00  0.00           H  
ATOM    104  N   PRO A  10       3.977  66.274  23.584  1.00  0.00           N  
ATOM    105  CA  PRO A  10       4.867  65.245  23.038  1.00  0.00           C  
ATOM    106  C   PRO A  10       5.869  65.815  22.040  1.00  0.00           C  
ATOM    107  O   PRO A  10       5.592  66.780  21.328  1.00  0.00           O  
ATOM    108  CB  PRO A  10       3.905  64.281  22.338  1.00  0.00           C  
ATOM    109  CG  PRO A  10       2.716  65.112  22.000  1.00  0.00           C  
ATOM    110  CD  PRO A  10       2.594  66.130  23.101  1.00  0.00           C  
ATOM    111  HA  PRO A  10       5.396  64.722  23.821  1.00  0.00           H  
ATOM    112  HB2 PRO A  10       4.374  63.882  21.450  1.00  0.00           H  
ATOM    113  HB3 PRO A  10       3.645  63.476  23.008  1.00  0.00           H  
ATOM    114  HG2 PRO A  10       2.868  65.603  21.051  1.00  0.00           H  
ATOM    115  HG3 PRO A  10       1.832  64.491  21.965  1.00  0.00           H  
ATOM    116  HD2 PRO A  10       2.222  67.065  22.711  1.00  0.00           H  
ATOM    117  HD3 PRO A  10       1.949  65.763  23.885  1.00  0.00           H  
ATOM    118  N   PRO A  11       7.062  65.206  21.986  1.00  0.00           N  
ATOM    119  CA  PRO A  11       8.130  65.635  21.078  1.00  0.00           C  
ATOM    120  C   PRO A  11       7.803  65.340  19.619  1.00  0.00           C  
ATOM    121  O   PRO A  11       7.920  66.212  18.757  1.00  0.00           O  
ATOM    122  CB  PRO A  11       9.337  64.810  21.534  1.00  0.00           C  
ATOM    123  CG  PRO A  11       8.748  63.599  22.171  1.00  0.00           C  
ATOM    124  CD  PRO A  11       7.461  64.049  22.807  1.00  0.00           C  
ATOM    125  HA  PRO A  11       8.348  66.687  21.192  1.00  0.00           H  
ATOM    126  HB2 PRO A  11       9.943  64.551  20.678  1.00  0.00           H  
ATOM    127  HB3 PRO A  11       9.923  65.381  22.238  1.00  0.00           H  
ATOM    128  HG2 PRO A  11       8.553  62.847  21.423  1.00  0.00           H  
ATOM    129  HG3 PRO A  11       9.423  63.216  22.924  1.00  0.00           H  
ATOM    130  HD2 PRO A  11       6.720  63.265  22.754  1.00  0.00           H  
ATOM    131  HD3 PRO A  11       7.630  64.345  23.832  1.00  0.00           H  
ATOM    132  N   HIS A  12       7.393  64.105  19.347  1.00  0.00           N  
ATOM    133  CA  HIS A  12       7.049  63.695  17.989  1.00  0.00           C  
ATOM    134  C   HIS A  12       5.628  63.141  17.933  1.00  0.00           C  
ATOM    135  O   HIS A  12       4.864  63.457  17.024  1.00  0.00           O  
ATOM    136  CB  HIS A  12       8.039  62.646  17.484  1.00  0.00           C  
ATOM    137  CG  HIS A  12       8.617  61.795  18.572  1.00  0.00           C  
ATOM    138  ND1 HIS A  12       7.943  60.730  19.133  1.00  0.00           N  
ATOM    139  CD2 HIS A  12       9.813  61.855  19.202  1.00  0.00           C  
ATOM    140  CE1 HIS A  12       8.699  60.173  20.061  1.00  0.00           C  
ATOM    141  NE2 HIS A  12       9.840  60.836  20.123  1.00  0.00           N  
ATOM    142  H   HIS A  12       7.322  63.454  20.075  1.00  0.00           H  
ATOM    143  HA  HIS A  12       7.107  64.568  17.355  1.00  0.00           H  
ATOM    144  HB2 HIS A  12       7.537  61.995  16.785  1.00  0.00           H  
ATOM    145  HB3 HIS A  12       8.857  63.143  16.982  1.00  0.00           H  
ATOM    146  HD1 HIS A  12       7.044  60.428  18.887  1.00  0.00           H  
ATOM    147  HD2 HIS A  12      10.601  62.570  19.016  1.00  0.00           H  
ATOM    148  HE1 HIS A  12       8.432  59.320  20.667  1.00  0.00           H  
ATOM    149  HE2 HIS A  12      10.545  60.685  20.786  1.00  0.00           H  
ATOM    150  N   GLY A  13       5.284  62.312  18.914  1.00  0.00           N  
ATOM    151  CA  GLY A  13       3.957  61.725  18.957  1.00  0.00           C  
ATOM    152  C   GLY A  13       3.991  60.225  19.169  1.00  0.00           C  
ATOM    153  O   GLY A  13       3.081  59.510  18.751  1.00  0.00           O  
ATOM    154  H   GLY A  13       5.935  62.095  19.613  1.00  0.00           H  
ATOM    155  HA2 GLY A  13       3.400  62.180  19.763  1.00  0.00           H  
ATOM    156  HA3 GLY A  13       3.453  61.933  18.024  1.00  0.00           H  
ATOM    157  N   PHE A  14       5.047  59.746  19.819  1.00  0.00           N  
ATOM    158  CA  PHE A  14       5.198  58.320  20.085  1.00  0.00           C  
ATOM    159  C   PHE A  14       5.416  58.064  21.573  1.00  0.00           C  
ATOM    160  O   PHE A  14       5.792  58.966  22.320  1.00  0.00           O  
ATOM    161  CB  PHE A  14       6.372  57.752  19.282  1.00  0.00           C  
ATOM    162  CG  PHE A  14       6.064  57.561  17.825  1.00  0.00           C  
ATOM    163  CD1 PHE A  14       5.767  58.648  17.017  1.00  0.00           C  
ATOM    164  CD2 PHE A  14       6.070  56.295  17.261  1.00  0.00           C  
ATOM    165  CE1 PHE A  14       5.483  58.476  15.675  1.00  0.00           C  
ATOM    166  CE2 PHE A  14       5.788  56.117  15.920  1.00  0.00           C  
ATOM    167  CZ  PHE A  14       5.494  57.208  15.126  1.00  0.00           C  
ATOM    168  H   PHE A  14       5.740  60.366  20.128  1.00  0.00           H  
ATOM    169  HA  PHE A  14       4.290  57.827  19.775  1.00  0.00           H  
ATOM    170  HB2 PHE A  14       7.211  58.427  19.358  1.00  0.00           H  
ATOM    171  HB3 PHE A  14       6.648  56.793  19.692  1.00  0.00           H  
ATOM    172  HD1 PHE A  14       5.760  59.640  17.446  1.00  0.00           H  
ATOM    173  HD2 PHE A  14       6.299  55.440  17.881  1.00  0.00           H  
ATOM    174  HE1 PHE A  14       5.254  59.332  15.058  1.00  0.00           H  
ATOM    175  HE2 PHE A  14       5.795  55.126  15.494  1.00  0.00           H  
ATOM    176  HZ  PHE A  14       5.273  57.072  14.079  1.00  0.00           H  
ATOM    177  N   GLN A  15       5.172  56.826  21.996  1.00  0.00           N  
ATOM    178  CA  GLN A  15       5.340  56.452  23.395  1.00  0.00           C  
ATOM    179  C   GLN A  15       6.187  55.189  23.522  1.00  0.00           C  
ATOM    180  O   GLN A  15       6.468  54.515  22.532  1.00  0.00           O  
ATOM    181  CB  GLN A  15       3.976  56.234  24.052  1.00  0.00           C  
ATOM    182  CG  GLN A  15       3.044  57.427  23.929  1.00  0.00           C  
ATOM    183  CD  GLN A  15       1.855  57.340  24.867  1.00  0.00           C  
ATOM    184  OE1 GLN A  15       0.778  56.884  24.481  1.00  0.00           O  
ATOM    185  NE2 GLN A  15       2.046  57.776  26.107  1.00  0.00           N  
ATOM    186  H   GLN A  15       4.875  56.152  21.352  1.00  0.00           H  
ATOM    187  HA  GLN A  15       5.846  57.262  23.897  1.00  0.00           H  
ATOM    188  HB2 GLN A  15       3.499  55.382  23.591  1.00  0.00           H  
ATOM    189  HB3 GLN A  15       4.125  56.027  25.102  1.00  0.00           H  
ATOM    190  HG2 GLN A  15       3.598  58.326  24.159  1.00  0.00           H  
ATOM    191  HG3 GLN A  15       2.680  57.480  22.914  1.00  0.00           H  
ATOM    192 HE21 GLN A  15       2.931  58.126  26.343  1.00  0.00           H  
ATOM    193 HE22 GLN A  15       1.295  57.731  26.734  1.00  0.00           H  
ATOM    194  N   LYS A  16       6.591  54.876  24.748  1.00  0.00           N  
ATOM    195  CA  LYS A  16       7.405  53.695  25.008  1.00  0.00           C  
ATOM    196  C   LYS A  16       6.539  52.527  25.470  1.00  0.00           C  
ATOM    197  O   LYS A  16       5.434  52.722  25.976  1.00  0.00           O  
ATOM    198  CB  LYS A  16       8.468  54.004  26.065  1.00  0.00           C  
ATOM    199  CG  LYS A  16       9.690  54.712  25.508  1.00  0.00           C  
ATOM    200  CD  LYS A  16      10.394  55.532  26.577  1.00  0.00           C  
ATOM    201  CE  LYS A  16       9.632  56.811  26.891  1.00  0.00           C  
ATOM    202  NZ  LYS A  16       9.856  57.259  28.293  1.00  0.00           N  
ATOM    203  H   LYS A  16       6.333  55.453  25.498  1.00  0.00           H  
ATOM    204  HA  LYS A  16       7.895  53.421  24.086  1.00  0.00           H  
ATOM    205  HB2 LYS A  16       8.029  54.631  26.826  1.00  0.00           H  
ATOM    206  HB3 LYS A  16       8.790  53.076  26.516  1.00  0.00           H  
ATOM    207  HG2 LYS A  16      10.379  53.975  25.124  1.00  0.00           H  
ATOM    208  HG3 LYS A  16       9.381  55.370  24.709  1.00  0.00           H  
ATOM    209  HD2 LYS A  16      10.472  54.943  27.478  1.00  0.00           H  
ATOM    210  HD3 LYS A  16      11.383  55.790  26.227  1.00  0.00           H  
ATOM    211  HE2 LYS A  16       9.962  57.587  26.217  1.00  0.00           H  
ATOM    212  HE3 LYS A  16       8.577  56.631  26.743  1.00  0.00           H  
ATOM    213  HZ1 LYS A  16      10.337  58.181  28.300  1.00  0.00           H  
ATOM    214  HZ2 LYS A  16      10.445  56.569  28.800  1.00  0.00           H  
ATOM    215  HZ3 LYS A  16       8.945  57.353  28.788  1.00  0.00           H  
ATOM    216  N   LYS A  17       7.047  51.312  25.292  1.00  0.00           N  
ATOM    217  CA  LYS A  17       6.322  50.113  25.693  1.00  0.00           C  
ATOM    218  C   LYS A  17       5.044  49.950  24.875  1.00  0.00           C  
ATOM    219  O   LYS A  17       4.072  49.353  25.337  1.00  0.00           O  
ATOM    220  CB  LYS A  17       5.982  50.171  27.183  1.00  0.00           C  
ATOM    221  CG  LYS A  17       7.145  50.612  28.056  1.00  0.00           C  
ATOM    222  CD  LYS A  17       6.849  50.393  29.531  1.00  0.00           C  
ATOM    223  CE  LYS A  17       6.141  51.593  30.141  1.00  0.00           C  
ATOM    224  NZ  LYS A  17       5.694  51.322  31.536  1.00  0.00           N  
ATOM    225  H   LYS A  17       7.933  51.220  24.882  1.00  0.00           H  
ATOM    226  HA  LYS A  17       6.961  49.262  25.511  1.00  0.00           H  
ATOM    227  HB2 LYS A  17       5.168  50.867  27.328  1.00  0.00           H  
ATOM    228  HB3 LYS A  17       5.667  49.190  27.508  1.00  0.00           H  
ATOM    229  HG2 LYS A  17       8.020  50.041  27.787  1.00  0.00           H  
ATOM    230  HG3 LYS A  17       7.331  51.662  27.887  1.00  0.00           H  
ATOM    231  HD2 LYS A  17       6.217  49.523  29.637  1.00  0.00           H  
ATOM    232  HD3 LYS A  17       7.781  50.230  30.055  1.00  0.00           H  
ATOM    233  HE2 LYS A  17       6.820  52.431  30.145  1.00  0.00           H  
ATOM    234  HE3 LYS A  17       5.279  51.831  29.535  1.00  0.00           H  
ATOM    235  HZ1 LYS A  17       5.813  50.313  31.759  1.00  0.00           H  
ATOM    236  HZ2 LYS A  17       4.691  51.574  31.645  1.00  0.00           H  
ATOM    237  HZ3 LYS A  17       6.256  51.884  32.206  1.00  0.00           H  
ATOM    238  N   MET A  18       5.054  50.485  23.657  1.00  0.00           N  
ATOM    239  CA  MET A  18       3.896  50.397  22.776  1.00  0.00           C  
ATOM    240  C   MET A  18       4.225  49.583  21.528  1.00  0.00           C  
ATOM    241  O   MET A  18       5.327  49.050  21.393  1.00  0.00           O  
ATOM    242  CB  MET A  18       3.425  51.796  22.376  1.00  0.00           C  
ATOM    243  CG  MET A  18       4.160  52.365  21.174  1.00  0.00           C  
ATOM    244  SD  MET A  18       3.473  53.939  20.621  1.00  0.00           S  
ATOM    245  CE  MET A  18       4.569  54.325  19.259  1.00  0.00           C  
ATOM    246  H   MET A  18       5.858  50.949  23.345  1.00  0.00           H  
ATOM    247  HA  MET A  18       3.105  49.900  23.317  1.00  0.00           H  
ATOM    248  HB2 MET A  18       2.372  51.754  22.141  1.00  0.00           H  
ATOM    249  HB3 MET A  18       3.573  52.465  23.211  1.00  0.00           H  
ATOM    250  HG2 MET A  18       5.196  52.515  21.440  1.00  0.00           H  
ATOM    251  HG3 MET A  18       4.097  51.656  20.362  1.00  0.00           H  
ATOM    252  HE1 MET A  18       5.075  53.427  18.936  1.00  0.00           H  
ATOM    253  HE2 MET A  18       3.995  54.730  18.439  1.00  0.00           H  
ATOM    254  HE3 MET A  18       5.300  55.054  19.581  1.00  0.00           H  
ATOM    255  N   LYS A  19       3.263  49.490  20.616  1.00  0.00           N  
ATOM    256  CA  LYS A  19       3.449  48.743  19.379  1.00  0.00           C  
ATOM    257  C   LYS A  19       3.274  49.648  18.165  1.00  0.00           C  
ATOM    258  O   LYS A  19       2.550  50.644  18.219  1.00  0.00           O  
ATOM    259  CB  LYS A  19       2.458  47.579  19.308  1.00  0.00           C  
ATOM    260  CG  LYS A  19       2.767  46.457  20.284  1.00  0.00           C  
ATOM    261  CD  LYS A  19       4.090  45.782  19.957  1.00  0.00           C  
ATOM    262  CE  LYS A  19       4.388  44.646  20.922  1.00  0.00           C  
ATOM    263  NZ  LYS A  19       4.910  45.145  22.224  1.00  0.00           N  
ATOM    264  H   LYS A  19       2.405  49.937  20.781  1.00  0.00           H  
ATOM    265  HA  LYS A  19       4.454  48.349  19.377  1.00  0.00           H  
ATOM    266  HB2 LYS A  19       1.467  47.951  19.522  1.00  0.00           H  
ATOM    267  HB3 LYS A  19       2.471  47.172  18.307  1.00  0.00           H  
ATOM    268  HG2 LYS A  19       2.820  46.863  21.282  1.00  0.00           H  
ATOM    269  HG3 LYS A  19       1.977  45.721  20.234  1.00  0.00           H  
ATOM    270  HD2 LYS A  19       4.043  45.385  18.954  1.00  0.00           H  
ATOM    271  HD3 LYS A  19       4.882  46.515  20.020  1.00  0.00           H  
ATOM    272  HE2 LYS A  19       3.479  44.091  21.098  1.00  0.00           H  
ATOM    273  HE3 LYS A  19       5.125  43.995  20.474  1.00  0.00           H  
ATOM    274  HZ1 LYS A  19       5.843  44.728  22.418  1.00  0.00           H  
ATOM    275  HZ2 LYS A  19       4.260  44.886  22.994  1.00  0.00           H  
ATOM    276  HZ3 LYS A  19       5.004  46.180  22.197  1.00  0.00           H  
ATOM    277  N   LEU A  20       3.939  49.297  17.069  1.00  0.00           N  
ATOM    278  CA  LEU A  20       3.855  50.078  15.839  1.00  0.00           C  
ATOM    279  C   LEU A  20       4.449  49.309  14.664  1.00  0.00           C  
ATOM    280  O   LEU A  20       5.440  48.595  14.816  1.00  0.00           O  
ATOM    281  CB  LEU A  20       4.581  51.413  16.010  1.00  0.00           C  
ATOM    282  CG  LEU A  20       6.056  51.431  15.605  1.00  0.00           C  
ATOM    283  CD1 LEU A  20       6.202  51.809  14.140  1.00  0.00           C  
ATOM    284  CD2 LEU A  20       6.838  52.393  16.487  1.00  0.00           C  
ATOM    285  H   LEU A  20       4.499  48.494  17.087  1.00  0.00           H  
ATOM    286  HA  LEU A  20       2.811  50.268  15.639  1.00  0.00           H  
ATOM    287  HB2 LEU A  20       4.066  52.149  15.412  1.00  0.00           H  
ATOM    288  HB3 LEU A  20       4.519  51.692  17.052  1.00  0.00           H  
ATOM    289  HG  LEU A  20       6.471  50.442  15.738  1.00  0.00           H  
ATOM    290 HD11 LEU A  20       7.068  52.443  14.016  1.00  0.00           H  
ATOM    291 HD12 LEU A  20       5.319  52.340  13.814  1.00  0.00           H  
ATOM    292 HD13 LEU A  20       6.323  50.914  13.548  1.00  0.00           H  
ATOM    293 HD21 LEU A  20       7.160  51.881  17.382  1.00  0.00           H  
ATOM    294 HD22 LEU A  20       6.208  53.228  16.758  1.00  0.00           H  
ATOM    295 HD23 LEU A  20       7.702  52.754  15.948  1.00  0.00           H  
ATOM    296  N   GLU A  21       3.838  49.462  13.494  1.00  0.00           N  
ATOM    297  CA  GLU A  21       4.309  48.782  12.293  1.00  0.00           C  
ATOM    298  C   GLU A  21       5.459  49.551  11.647  1.00  0.00           C  
ATOM    299  O   GLU A  21       5.286  50.682  11.194  1.00  0.00           O  
ATOM    300  CB  GLU A  21       3.164  48.619  11.291  1.00  0.00           C  
ATOM    301  CG  GLU A  21       2.043  47.721  11.788  1.00  0.00           C  
ATOM    302  CD  GLU A  21       1.065  47.348  10.691  1.00  0.00           C  
ATOM    303  OE1 GLU A  21       1.432  47.464   9.503  1.00  0.00           O  
ATOM    304  OE2 GLU A  21      -0.068  46.940  11.021  1.00  0.00           O  
ATOM    305  H   GLU A  21       3.052  50.044  13.437  1.00  0.00           H  
ATOM    306  HA  GLU A  21       4.664  47.805  12.582  1.00  0.00           H  
ATOM    307  HB2 GLU A  21       2.749  49.592  11.075  1.00  0.00           H  
ATOM    308  HB3 GLU A  21       3.558  48.196  10.379  1.00  0.00           H  
ATOM    309  HG2 GLU A  21       2.475  46.815  12.186  1.00  0.00           H  
ATOM    310  HG3 GLU A  21       1.506  48.236  12.569  1.00  0.00           H  
ATOM    311  N   VAL A  22       6.632  48.928  11.611  1.00  0.00           N  
ATOM    312  CA  VAL A  22       7.810  49.552  11.022  1.00  0.00           C  
ATOM    313  C   VAL A  22       8.191  48.876   9.708  1.00  0.00           C  
ATOM    314  O   VAL A  22       8.103  47.656   9.577  1.00  0.00           O  
ATOM    315  CB  VAL A  22       9.014  49.498  11.981  1.00  0.00           C  
ATOM    316  CG1 VAL A  22      10.212  50.214  11.377  1.00  0.00           C  
ATOM    317  CG2 VAL A  22       8.647  50.100  13.329  1.00  0.00           C  
ATOM    318  H   VAL A  22       6.707  48.027  11.988  1.00  0.00           H  
ATOM    319  HA  VAL A  22       7.577  50.589  10.827  1.00  0.00           H  
ATOM    320  HB  VAL A  22       9.281  48.463  12.134  1.00  0.00           H  
ATOM    321 HG11 VAL A  22      10.781  49.519  10.777  1.00  0.00           H  
ATOM    322 HG12 VAL A  22       9.869  51.031  10.758  1.00  0.00           H  
ATOM    323 HG13 VAL A  22      10.837  50.601  12.169  1.00  0.00           H  
ATOM    324 HG21 VAL A  22       8.398  51.143  13.201  1.00  0.00           H  
ATOM    325 HG22 VAL A  22       7.795  49.575  13.739  1.00  0.00           H  
ATOM    326 HG23 VAL A  22       9.483  50.009  14.005  1.00  0.00           H  
ATOM    327  N   VAL A  23       8.616  49.680   8.738  1.00  0.00           N  
ATOM    328  CA  VAL A  23       9.011  49.159   7.435  1.00  0.00           C  
ATOM    329  C   VAL A  23      10.475  48.730   7.436  1.00  0.00           C  
ATOM    330  O   VAL A  23      11.372  49.546   7.645  1.00  0.00           O  
ATOM    331  CB  VAL A  23       8.796  50.205   6.324  1.00  0.00           C  
ATOM    332  CG1 VAL A  23       9.382  49.716   5.008  1.00  0.00           C  
ATOM    333  CG2 VAL A  23       7.317  50.525   6.173  1.00  0.00           C  
ATOM    334  H   VAL A  23       8.663  50.644   8.902  1.00  0.00           H  
ATOM    335  HA  VAL A  23       8.394  48.301   7.215  1.00  0.00           H  
ATOM    336  HB  VAL A  23       9.312  51.112   6.606  1.00  0.00           H  
ATOM    337 HG11 VAL A  23       8.925  48.775   4.740  1.00  0.00           H  
ATOM    338 HG12 VAL A  23       9.188  50.444   4.234  1.00  0.00           H  
ATOM    339 HG13 VAL A  23      10.448  49.579   5.117  1.00  0.00           H  
ATOM    340 HG21 VAL A  23       6.816  50.356   7.114  1.00  0.00           H  
ATOM    341 HG22 VAL A  23       7.200  51.560   5.883  1.00  0.00           H  
ATOM    342 HG23 VAL A  23       6.886  49.889   5.416  1.00  0.00           H  
ATOM    343  N   ASP A  24      10.707  47.443   7.201  1.00  0.00           N  
ATOM    344  CA  ASP A  24      12.061  46.903   7.173  1.00  0.00           C  
ATOM    345  C   ASP A  24      12.952  47.719   6.242  1.00  0.00           C  
ATOM    346  O   ASP A  24      12.787  47.687   5.022  1.00  0.00           O  
ATOM    347  CB  ASP A  24      12.041  45.440   6.729  1.00  0.00           C  
ATOM    348  CG  ASP A  24      13.215  44.653   7.278  1.00  0.00           C  
ATOM    349  OD1 ASP A  24      13.688  44.984   8.385  1.00  0.00           O  
ATOM    350  OD2 ASP A  24      13.661  43.703   6.599  1.00  0.00           O  
ATOM    351  H   ASP A  24       9.949  46.842   7.042  1.00  0.00           H  
ATOM    352  HA  ASP A  24      12.461  46.961   8.174  1.00  0.00           H  
ATOM    353  HB2 ASP A  24      11.128  44.978   7.076  1.00  0.00           H  
ATOM    354  HB3 ASP A  24      12.074  45.398   5.651  1.00  0.00           H  
ATOM    355  N   LYS A  25      13.897  48.450   6.824  1.00  0.00           N  
ATOM    356  CA  LYS A  25      14.815  49.274   6.048  1.00  0.00           C  
ATOM    357  C   LYS A  25      15.337  48.511   4.834  1.00  0.00           C  
ATOM    358  O   LYS A  25      15.166  48.947   3.695  1.00  0.00           O  
ATOM    359  CB  LYS A  25      15.987  49.729   6.919  1.00  0.00           C  
ATOM    360  CG  LYS A  25      15.597  50.020   8.359  1.00  0.00           C  
ATOM    361  CD  LYS A  25      14.348  50.881   8.435  1.00  0.00           C  
ATOM    362  CE  LYS A  25      14.653  52.335   8.113  1.00  0.00           C  
ATOM    363  NZ  LYS A  25      13.446  53.062   7.630  1.00  0.00           N  
ATOM    364  H   LYS A  25      13.980  48.433   7.801  1.00  0.00           H  
ATOM    365  HA  LYS A  25      14.273  50.143   5.706  1.00  0.00           H  
ATOM    366  HB2 LYS A  25      16.741  48.956   6.922  1.00  0.00           H  
ATOM    367  HB3 LYS A  25      16.408  50.629   6.495  1.00  0.00           H  
ATOM    368  HG2 LYS A  25      15.409  49.085   8.866  1.00  0.00           H  
ATOM    369  HG3 LYS A  25      16.411  50.538   8.845  1.00  0.00           H  
ATOM    370  HD2 LYS A  25      13.622  50.511   7.725  1.00  0.00           H  
ATOM    371  HD3 LYS A  25      13.940  50.820   9.435  1.00  0.00           H  
ATOM    372  HE2 LYS A  25      15.020  52.819   9.005  1.00  0.00           H  
ATOM    373  HE3 LYS A  25      15.413  52.369   7.347  1.00  0.00           H  
ATOM    374  HZ1 LYS A  25      12.767  53.182   8.408  1.00  0.00           H  
ATOM    375  HZ2 LYS A  25      12.988  52.524   6.866  1.00  0.00           H  
ATOM    376  HZ3 LYS A  25      13.713  53.999   7.268  1.00  0.00           H  
ATOM    377  N   ARG A  26      15.973  47.371   5.085  1.00  0.00           N  
ATOM    378  CA  ARG A  26      16.519  46.549   4.013  1.00  0.00           C  
ATOM    379  C   ARG A  26      15.424  46.128   3.038  1.00  0.00           C  
ATOM    380  O   ARG A  26      15.680  45.919   1.853  1.00  0.00           O  
ATOM    381  CB  ARG A  26      17.205  45.310   4.591  1.00  0.00           C  
ATOM    382  CG  ARG A  26      16.506  44.742   5.816  1.00  0.00           C  
ATOM    383  CD  ARG A  26      17.114  45.278   7.103  1.00  0.00           C  
ATOM    384  NE  ARG A  26      18.180  44.415   7.605  1.00  0.00           N  
ATOM    385  CZ  ARG A  26      18.922  44.706   8.668  1.00  0.00           C  
ATOM    386  NH1 ARG A  26      18.714  45.832   9.337  1.00  0.00           N  
ATOM    387  NH2 ARG A  26      19.874  43.870   9.063  1.00  0.00           N  
ATOM    388  H   ARG A  26      16.078  47.077   6.014  1.00  0.00           H  
ATOM    389  HA  ARG A  26      17.251  47.139   3.482  1.00  0.00           H  
ATOM    390  HB2 ARG A  26      17.234  44.541   3.832  1.00  0.00           H  
ATOM    391  HB3 ARG A  26      18.215  45.568   4.868  1.00  0.00           H  
ATOM    392  HG2 ARG A  26      15.462  45.017   5.782  1.00  0.00           H  
ATOM    393  HG3 ARG A  26      16.598  43.666   5.804  1.00  0.00           H  
ATOM    394  HD2 ARG A  26      17.519  46.261   6.912  1.00  0.00           H  
ATOM    395  HD3 ARG A  26      16.338  45.348   7.850  1.00  0.00           H  
ATOM    396  HE  ARG A  26      18.351  43.578   7.125  1.00  0.00           H  
ATOM    397 HH11 ARG A  26      17.996  46.462   9.043  1.00  0.00           H  
ATOM    398 HH12 ARG A  26      19.272  46.048  10.138  1.00  0.00           H  
ATOM    399 HH21 ARG A  26      20.033  43.020   8.561  1.00  0.00           H  
ATOM    400 HH22 ARG A  26      20.430  44.090   9.863  1.00  0.00           H  
ATOM    401  N   ASN A  27      14.201  46.008   3.546  1.00  0.00           N  
ATOM    402  CA  ASN A  27      13.067  45.611   2.720  1.00  0.00           C  
ATOM    403  C   ASN A  27      11.896  46.573   2.906  1.00  0.00           C  
ATOM    404  O   ASN A  27      11.072  46.420   3.808  1.00  0.00           O  
ATOM    405  CB  ASN A  27      12.630  44.186   3.066  1.00  0.00           C  
ATOM    406  CG  ASN A  27      13.807  43.279   3.367  1.00  0.00           C  
ATOM    407  OD1 ASN A  27      13.883  42.677   4.439  1.00  0.00           O  
ATOM    408  ND2 ASN A  27      14.732  43.175   2.420  1.00  0.00           N  
ATOM    409  H   ASN A  27      14.059  46.188   4.498  1.00  0.00           H  
ATOM    410  HA  ASN A  27      13.381  45.641   1.688  1.00  0.00           H  
ATOM    411  HB2 ASN A  27      11.989  44.213   3.936  1.00  0.00           H  
ATOM    412  HB3 ASN A  27      12.082  43.771   2.234  1.00  0.00           H  
ATOM    413 HD21 ASN A  27      14.605  43.682   1.592  1.00  0.00           H  
ATOM    414 HD22 ASN A  27      15.503  42.594   2.588  1.00  0.00           H  
ATOM    415  N   PRO A  28      11.820  47.587   2.032  1.00  0.00           N  
ATOM    416  CA  PRO A  28      10.754  48.593   2.079  1.00  0.00           C  
ATOM    417  C   PRO A  28       9.398  48.020   1.681  1.00  0.00           C  
ATOM    418  O   PRO A  28       8.374  48.696   1.781  1.00  0.00           O  
ATOM    419  CB  PRO A  28      11.211  49.641   1.061  1.00  0.00           C  
ATOM    420  CG  PRO A  28      12.086  48.893   0.114  1.00  0.00           C  
ATOM    421  CD  PRO A  28      12.767  47.831   0.932  1.00  0.00           C  
ATOM    422  HA  PRO A  28      10.679  49.047   3.057  1.00  0.00           H  
ATOM    423  HB2 PRO A  28      10.350  50.058   0.559  1.00  0.00           H  
ATOM    424  HB3 PRO A  28      11.755  50.425   1.565  1.00  0.00           H  
ATOM    425  HG2 PRO A  28      11.487  48.443  -0.662  1.00  0.00           H  
ATOM    426  HG3 PRO A  28      12.817  49.562  -0.314  1.00  0.00           H  
ATOM    427  HD2 PRO A  28      12.912  46.937   0.344  1.00  0.00           H  
ATOM    428  HD3 PRO A  28      13.712  48.193   1.310  1.00  0.00           H  
ATOM    429  N   MET A  29       9.399  46.769   1.230  1.00  0.00           N  
ATOM    430  CA  MET A  29       8.168  46.106   0.820  1.00  0.00           C  
ATOM    431  C   MET A  29       7.703  45.115   1.883  1.00  0.00           C  
ATOM    432  O   MET A  29       6.809  44.303   1.641  1.00  0.00           O  
ATOM    433  CB  MET A  29       8.372  45.383  -0.513  1.00  0.00           C  
ATOM    434  CG  MET A  29       8.527  46.324  -1.697  1.00  0.00           C  
ATOM    435  SD  MET A  29       7.166  47.498  -1.833  1.00  0.00           S  
ATOM    436  CE  MET A  29       8.062  49.044  -1.951  1.00  0.00           C  
ATOM    437  H   MET A  29      10.246  46.281   1.173  1.00  0.00           H  
ATOM    438  HA  MET A  29       7.408  46.863   0.695  1.00  0.00           H  
ATOM    439  HB2 MET A  29       9.262  44.774  -0.446  1.00  0.00           H  
ATOM    440  HB3 MET A  29       7.522  44.744  -0.698  1.00  0.00           H  
ATOM    441  HG2 MET A  29       9.449  46.875  -1.585  1.00  0.00           H  
ATOM    442  HG3 MET A  29       8.570  45.737  -2.602  1.00  0.00           H  
ATOM    443  HE1 MET A  29       9.092  48.886  -1.666  1.00  0.00           H  
ATOM    444  HE2 MET A  29       8.022  49.406  -2.967  1.00  0.00           H  
ATOM    445  HE3 MET A  29       7.614  49.772  -1.290  1.00  0.00           H  
ATOM    446  N   PHE A  30       8.316  45.185   3.059  1.00  0.00           N  
ATOM    447  CA  PHE A  30       7.967  44.293   4.158  1.00  0.00           C  
ATOM    448  C   PHE A  30       7.781  45.075   5.455  1.00  0.00           C  
ATOM    449  O   PHE A  30       8.597  45.932   5.798  1.00  0.00           O  
ATOM    450  CB  PHE A  30       9.049  43.227   4.342  1.00  0.00           C  
ATOM    451  CG  PHE A  30       9.162  42.281   3.182  1.00  0.00           C  
ATOM    452  CD1 PHE A  30       9.602  42.729   1.946  1.00  0.00           C  
ATOM    453  CD2 PHE A  30       8.831  40.944   3.327  1.00  0.00           C  
ATOM    454  CE1 PHE A  30       9.706  41.859   0.876  1.00  0.00           C  
ATOM    455  CE2 PHE A  30       8.933  40.070   2.260  1.00  0.00           C  
ATOM    456  CZ  PHE A  30       9.372  40.528   1.034  1.00  0.00           C  
ATOM    457  H   PHE A  30       9.022  45.854   3.191  1.00  0.00           H  
ATOM    458  HA  PHE A  30       7.036  43.808   3.908  1.00  0.00           H  
ATOM    459  HB2 PHE A  30      10.006  43.713   4.467  1.00  0.00           H  
ATOM    460  HB3 PHE A  30       8.828  42.648   5.226  1.00  0.00           H  
ATOM    461  HD1 PHE A  30       9.864  43.769   1.821  1.00  0.00           H  
ATOM    462  HD2 PHE A  30       8.486  40.583   4.286  1.00  0.00           H  
ATOM    463  HE1 PHE A  30      10.050  42.220  -0.082  1.00  0.00           H  
ATOM    464  HE2 PHE A  30       8.671  39.030   2.388  1.00  0.00           H  
ATOM    465  HZ  PHE A  30       9.452  39.848   0.199  1.00  0.00           H  
ATOM    466  N   ILE A  31       6.704  44.774   6.172  1.00  0.00           N  
ATOM    467  CA  ILE A  31       6.411  45.447   7.431  1.00  0.00           C  
ATOM    468  C   ILE A  31       6.136  44.440   8.542  1.00  0.00           C  
ATOM    469  O   ILE A  31       5.533  43.393   8.308  1.00  0.00           O  
ATOM    470  CB  ILE A  31       5.201  46.392   7.296  1.00  0.00           C  
ATOM    471  CG1 ILE A  31       5.478  47.464   6.241  1.00  0.00           C  
ATOM    472  CG2 ILE A  31       4.878  47.032   8.638  1.00  0.00           C  
ATOM    473  CD1 ILE A  31       4.227  47.999   5.580  1.00  0.00           C  
ATOM    474  H   ILE A  31       6.092  44.082   5.846  1.00  0.00           H  
ATOM    475  HA  ILE A  31       7.275  46.038   7.701  1.00  0.00           H  
ATOM    476  HB  ILE A  31       4.349  45.805   6.989  1.00  0.00           H  
ATOM    477 HG12 ILE A  31       5.989  48.293   6.705  1.00  0.00           H  
ATOM    478 HG13 ILE A  31       6.109  47.044   5.470  1.00  0.00           H  
ATOM    479 HG21 ILE A  31       4.242  47.892   8.482  1.00  0.00           H  
ATOM    480 HG22 ILE A  31       4.367  46.316   9.264  1.00  0.00           H  
ATOM    481 HG23 ILE A  31       5.793  47.343   9.119  1.00  0.00           H  
ATOM    482 HD11 ILE A  31       3.771  48.740   6.219  1.00  0.00           H  
ATOM    483 HD12 ILE A  31       4.483  48.446   4.632  1.00  0.00           H  
ATOM    484 HD13 ILE A  31       3.531  47.188   5.419  1.00  0.00           H  
ATOM    485  N   ARG A  32       6.578  44.766   9.752  1.00  0.00           N  
ATOM    486  CA  ARG A  32       6.378  43.891  10.900  1.00  0.00           C  
ATOM    487  C   ARG A  32       6.119  44.704  12.166  1.00  0.00           C  
ATOM    488  O   ARG A  32       6.316  45.919  12.186  1.00  0.00           O  
ATOM    489  CB  ARG A  32       7.598  42.990  11.100  1.00  0.00           C  
ATOM    490  CG  ARG A  32       7.936  42.143   9.885  1.00  0.00           C  
ATOM    491  CD  ARG A  32       9.407  41.756   9.866  1.00  0.00           C  
ATOM    492  NE  ARG A  32       9.738  40.916   8.718  1.00  0.00           N  
ATOM    493  CZ  ARG A  32       9.384  39.641   8.615  1.00  0.00           C  
ATOM    494  NH1 ARG A  32       8.690  39.060   9.586  1.00  0.00           N  
ATOM    495  NH2 ARG A  32       9.722  38.942   7.538  1.00  0.00           N  
ATOM    496  H   ARG A  32       7.051  45.616   9.875  1.00  0.00           H  
ATOM    497  HA  ARG A  32       5.516  43.273  10.700  1.00  0.00           H  
ATOM    498  HB2 ARG A  32       8.454  43.609  11.330  1.00  0.00           H  
ATOM    499  HB3 ARG A  32       7.410  42.328  11.932  1.00  0.00           H  
ATOM    500  HG2 ARG A  32       7.339  41.243   9.907  1.00  0.00           H  
ATOM    501  HG3 ARG A  32       7.710  42.706   8.991  1.00  0.00           H  
ATOM    502  HD2 ARG A  32      10.002  42.657   9.825  1.00  0.00           H  
ATOM    503  HD3 ARG A  32       9.635  41.216  10.773  1.00  0.00           H  
ATOM    504  HE  ARG A  32      10.250  41.325   7.990  1.00  0.00           H  
ATOM    505 HH11 ARG A  32       8.433  39.585  10.397  1.00  0.00           H  
ATOM    506 HH12 ARG A  32       8.424  38.100   9.504  1.00  0.00           H  
ATOM    507 HH21 ARG A  32      10.245  39.375   6.805  1.00  0.00           H  
ATOM    508 HH22 ARG A  32       9.455  37.982   7.463  1.00  0.00           H  
ATOM    509  N   VAL A  33       5.676  44.024  13.219  1.00  0.00           N  
ATOM    510  CA  VAL A  33       5.392  44.682  14.488  1.00  0.00           C  
ATOM    511  C   VAL A  33       6.672  45.183  15.148  1.00  0.00           C  
ATOM    512  O   VAL A  33       7.748  44.625  14.940  1.00  0.00           O  
ATOM    513  CB  VAL A  33       4.663  43.735  15.460  1.00  0.00           C  
ATOM    514  CG1 VAL A  33       4.506  44.388  16.825  1.00  0.00           C  
ATOM    515  CG2 VAL A  33       3.309  43.331  14.895  1.00  0.00           C  
ATOM    516  H   VAL A  33       5.540  43.057  13.141  1.00  0.00           H  
ATOM    517  HA  VAL A  33       4.747  45.526  14.289  1.00  0.00           H  
ATOM    518  HB  VAL A  33       5.261  42.844  15.579  1.00  0.00           H  
ATOM    519 HG11 VAL A  33       5.483  44.582  17.245  1.00  0.00           H  
ATOM    520 HG12 VAL A  33       3.967  45.318  16.721  1.00  0.00           H  
ATOM    521 HG13 VAL A  33       3.958  43.726  17.480  1.00  0.00           H  
ATOM    522 HG21 VAL A  33       2.537  43.567  15.611  1.00  0.00           H  
ATOM    523 HG22 VAL A  33       3.126  43.871  13.977  1.00  0.00           H  
ATOM    524 HG23 VAL A  33       3.305  42.271  14.696  1.00  0.00           H  
ATOM    525  N   ALA A  34       6.546  46.239  15.945  1.00  0.00           N  
ATOM    526  CA  ALA A  34       7.693  46.814  16.637  1.00  0.00           C  
ATOM    527  C   ALA A  34       7.321  47.239  18.054  1.00  0.00           C  
ATOM    528  O   ALA A  34       6.143  47.318  18.401  1.00  0.00           O  
ATOM    529  CB  ALA A  34       8.243  47.997  15.855  1.00  0.00           C  
ATOM    530  H   ALA A  34       5.661  46.641  16.070  1.00  0.00           H  
ATOM    531  HA  ALA A  34       8.465  46.059  16.689  1.00  0.00           H  
ATOM    532  HB1 ALA A  34       9.275  48.160  16.130  1.00  0.00           H  
ATOM    533  HB2 ALA A  34       8.179  47.792  14.797  1.00  0.00           H  
ATOM    534  HB3 ALA A  34       7.665  48.880  16.086  1.00  0.00           H  
ATOM    535  N   THR A  35       8.336  47.512  18.870  1.00  0.00           N  
ATOM    536  CA  THR A  35       8.115  47.928  20.249  1.00  0.00           C  
ATOM    537  C   THR A  35       9.013  49.104  20.618  1.00  0.00           C  
ATOM    538  O   THR A  35      10.235  48.969  20.685  1.00  0.00           O  
ATOM    539  CB  THR A  35       8.374  46.771  21.233  1.00  0.00           C  
ATOM    540  OG1 THR A  35       7.566  45.642  20.883  1.00  0.00           O  
ATOM    541  CG2 THR A  35       8.070  47.197  22.660  1.00  0.00           C  
ATOM    542  H   THR A  35       9.253  47.431  18.534  1.00  0.00           H  
ATOM    543  HA  THR A  35       7.083  48.232  20.345  1.00  0.00           H  
ATOM    544  HB  THR A  35       9.416  46.491  21.169  1.00  0.00           H  
ATOM    545  HG1 THR A  35       6.656  45.924  20.762  1.00  0.00           H  
ATOM    546 HG21 THR A  35       7.061  46.910  22.915  1.00  0.00           H  
ATOM    547 HG22 THR A  35       8.173  48.268  22.746  1.00  0.00           H  
ATOM    548 HG23 THR A  35       8.761  46.714  23.335  1.00  0.00           H  
ATOM    549  N   VAL A  36       8.399  50.258  20.860  1.00  0.00           N  
ATOM    550  CA  VAL A  36       9.143  51.458  21.225  1.00  0.00           C  
ATOM    551  C   VAL A  36       9.841  51.284  22.569  1.00  0.00           C  
ATOM    552  O   VAL A  36       9.210  51.357  23.622  1.00  0.00           O  
ATOM    553  CB  VAL A  36       8.221  52.690  21.293  1.00  0.00           C  
ATOM    554  CG1 VAL A  36       9.039  53.959  21.476  1.00  0.00           C  
ATOM    555  CG2 VAL A  36       7.355  52.778  20.045  1.00  0.00           C  
ATOM    556  H   VAL A  36       7.422  50.304  20.791  1.00  0.00           H  
ATOM    557  HA  VAL A  36       9.888  51.634  20.462  1.00  0.00           H  
ATOM    558  HB  VAL A  36       7.570  52.581  22.149  1.00  0.00           H  
ATOM    559 HG11 VAL A  36      10.088  53.730  21.360  1.00  0.00           H  
ATOM    560 HG12 VAL A  36       8.743  54.688  20.735  1.00  0.00           H  
ATOM    561 HG13 VAL A  36       8.866  54.360  22.464  1.00  0.00           H  
ATOM    562 HG21 VAL A  36       6.687  51.930  20.010  1.00  0.00           H  
ATOM    563 HG22 VAL A  36       6.778  53.691  20.071  1.00  0.00           H  
ATOM    564 HG23 VAL A  36       7.987  52.777  19.169  1.00  0.00           H  
ATOM    565  N   ALA A  37      11.149  51.054  22.523  1.00  0.00           N  
ATOM    566  CA  ALA A  37      11.935  50.871  23.737  1.00  0.00           C  
ATOM    567  C   ALA A  37      12.290  52.214  24.368  1.00  0.00           C  
ATOM    568  O   ALA A  37      12.054  52.434  25.556  1.00  0.00           O  
ATOM    569  CB  ALA A  37      13.197  50.078  23.435  1.00  0.00           C  
ATOM    570  H   ALA A  37      11.596  51.006  21.653  1.00  0.00           H  
ATOM    571  HA  ALA A  37      11.341  50.302  24.438  1.00  0.00           H  
ATOM    572  HB1 ALA A  37      14.056  50.729  23.503  1.00  0.00           H  
ATOM    573  HB2 ALA A  37      13.297  49.274  24.150  1.00  0.00           H  
ATOM    574  HB3 ALA A  37      13.134  49.668  22.439  1.00  0.00           H  
ATOM    575  N   ASP A  38      12.858  53.107  23.566  1.00  0.00           N  
ATOM    576  CA  ASP A  38      13.245  54.428  24.046  1.00  0.00           C  
ATOM    577  C   ASP A  38      12.909  55.501  23.014  1.00  0.00           C  
ATOM    578  O   ASP A  38      13.178  55.340  21.824  1.00  0.00           O  
ATOM    579  CB  ASP A  38      14.741  54.460  24.364  1.00  0.00           C  
ATOM    580  CG  ASP A  38      15.080  55.459  25.453  1.00  0.00           C  
ATOM    581  OD1 ASP A  38      14.419  55.428  26.512  1.00  0.00           O  
ATOM    582  OD2 ASP A  38      16.006  56.272  25.246  1.00  0.00           O  
ATOM    583  H   ASP A  38      13.020  52.872  22.628  1.00  0.00           H  
ATOM    584  HA  ASP A  38      12.690  54.629  24.950  1.00  0.00           H  
ATOM    585  HB2 ASP A  38      15.055  53.480  24.690  1.00  0.00           H  
ATOM    586  HB3 ASP A  38      15.286  54.730  23.470  1.00  0.00           H  
ATOM    587  N   THR A  39      12.316  56.596  23.480  1.00  0.00           N  
ATOM    588  CA  THR A  39      11.939  57.694  22.599  1.00  0.00           C  
ATOM    589  C   THR A  39      12.879  58.884  22.770  1.00  0.00           C  
ATOM    590  O   THR A  39      12.892  59.530  23.818  1.00  0.00           O  
ATOM    591  CB  THR A  39      10.493  58.155  22.861  1.00  0.00           C  
ATOM    592  OG1 THR A  39      10.353  58.579  24.221  1.00  0.00           O  
ATOM    593  CG2 THR A  39       9.507  57.034  22.569  1.00  0.00           C  
ATOM    594  H   THR A  39      12.127  56.666  24.439  1.00  0.00           H  
ATOM    595  HA  THR A  39      12.004  57.342  21.580  1.00  0.00           H  
ATOM    596  HB  THR A  39      10.273  58.988  22.208  1.00  0.00           H  
ATOM    597  HG1 THR A  39      10.992  59.271  24.409  1.00  0.00           H  
ATOM    598 HG21 THR A  39       8.616  57.174  23.164  1.00  0.00           H  
ATOM    599 HG22 THR A  39       9.959  56.085  22.816  1.00  0.00           H  
ATOM    600 HG23 THR A  39       9.247  57.048  21.522  1.00  0.00           H  
ATOM    601  N   ASP A  40      13.661  59.167  21.735  1.00  0.00           N  
ATOM    602  CA  ASP A  40      14.602  60.280  21.771  1.00  0.00           C  
ATOM    603  C   ASP A  40      13.906  61.592  21.422  1.00  0.00           C  
ATOM    604  O   ASP A  40      12.698  61.621  21.186  1.00  0.00           O  
ATOM    605  CB  ASP A  40      15.759  60.028  20.803  1.00  0.00           C  
ATOM    606  CG  ASP A  40      17.034  60.729  21.229  1.00  0.00           C  
ATOM    607  OD1 ASP A  40      17.229  60.916  22.449  1.00  0.00           O  
ATOM    608  OD2 ASP A  40      17.837  61.090  20.344  1.00  0.00           O  
ATOM    609  H   ASP A  40      13.604  58.615  20.927  1.00  0.00           H  
ATOM    610  HA  ASP A  40      14.994  60.352  22.774  1.00  0.00           H  
ATOM    611  HB2 ASP A  40      15.954  58.968  20.752  1.00  0.00           H  
ATOM    612  HB3 ASP A  40      15.484  60.387  19.822  1.00  0.00           H  
ATOM    613  N   ASP A  41      14.676  62.675  21.391  1.00  0.00           N  
ATOM    614  CA  ASP A  41      14.133  63.989  21.071  1.00  0.00           C  
ATOM    615  C   ASP A  41      13.245  63.924  19.833  1.00  0.00           C  
ATOM    616  O   ASP A  41      12.072  64.295  19.877  1.00  0.00           O  
ATOM    617  CB  ASP A  41      15.267  64.992  20.848  1.00  0.00           C  
ATOM    618  CG  ASP A  41      16.297  64.958  21.960  1.00  0.00           C  
ATOM    619  OD1 ASP A  41      15.964  65.376  23.089  1.00  0.00           O  
ATOM    620  OD2 ASP A  41      17.436  64.515  21.702  1.00  0.00           O  
ATOM    621  H   ASP A  41      15.632  62.587  21.588  1.00  0.00           H  
ATOM    622  HA  ASP A  41      13.537  64.316  21.909  1.00  0.00           H  
ATOM    623  HB2 ASP A  41      15.763  64.762  19.916  1.00  0.00           H  
ATOM    624  HB3 ASP A  41      14.853  65.988  20.794  1.00  0.00           H  
ATOM    625  N   HIS A  42      13.811  63.450  18.727  1.00  0.00           N  
ATOM    626  CA  HIS A  42      13.071  63.336  17.476  1.00  0.00           C  
ATOM    627  C   HIS A  42      13.251  61.951  16.862  1.00  0.00           C  
ATOM    628  O   HIS A  42      13.222  61.795  15.642  1.00  0.00           O  
ATOM    629  CB  HIS A  42      13.530  64.409  16.488  1.00  0.00           C  
ATOM    630  CG  HIS A  42      13.989  65.674  17.147  1.00  0.00           C  
ATOM    631  ND1 HIS A  42      13.196  66.796  17.256  1.00  0.00           N  
ATOM    632  CD2 HIS A  42      15.167  65.988  17.735  1.00  0.00           C  
ATOM    633  CE1 HIS A  42      13.866  67.748  17.879  1.00  0.00           C  
ATOM    634  NE2 HIS A  42      15.065  67.283  18.183  1.00  0.00           N  
ATOM    635  H   HIS A  42      14.750  63.170  18.754  1.00  0.00           H  
ATOM    636  HA  HIS A  42      12.024  63.486  17.696  1.00  0.00           H  
ATOM    637  HB2 HIS A  42      14.352  64.023  15.904  1.00  0.00           H  
ATOM    638  HB3 HIS A  42      12.710  64.656  15.829  1.00  0.00           H  
ATOM    639  HD1 HIS A  42      12.279  66.883  16.922  1.00  0.00           H  
ATOM    640  HD2 HIS A  42      16.028  65.342  17.834  1.00  0.00           H  
ATOM    641  HE1 HIS A  42      13.498  68.737  18.106  1.00  0.00           H  
ATOM    642  HE2 HIS A  42      15.793  67.810  18.572  1.00  0.00           H  
ATOM    643  N   ARG A  43      13.439  60.951  17.716  1.00  0.00           N  
ATOM    644  CA  ARG A  43      13.626  59.579  17.257  1.00  0.00           C  
ATOM    645  C   ARG A  43      13.053  58.586  18.264  1.00  0.00           C  
ATOM    646  O   ARG A  43      12.643  58.965  19.361  1.00  0.00           O  
ATOM    647  CB  ARG A  43      15.112  59.293  17.030  1.00  0.00           C  
ATOM    648  CG  ARG A  43      15.822  60.365  16.219  1.00  0.00           C  
ATOM    649  CD  ARG A  43      17.090  59.827  15.576  1.00  0.00           C  
ATOM    650  NE  ARG A  43      16.836  59.265  14.252  1.00  0.00           N  
ATOM    651  CZ  ARG A  43      17.733  58.564  13.567  1.00  0.00           C  
ATOM    652  NH1 ARG A  43      18.936  58.340  14.078  1.00  0.00           N  
ATOM    653  NH2 ARG A  43      17.427  58.085  12.367  1.00  0.00           N  
ATOM    654  H   ARG A  43      13.453  61.138  18.677  1.00  0.00           H  
ATOM    655  HA  ARG A  43      13.100  59.468  16.321  1.00  0.00           H  
ATOM    656  HB2 ARG A  43      15.602  59.216  17.990  1.00  0.00           H  
ATOM    657  HB3 ARG A  43      15.209  58.353  16.509  1.00  0.00           H  
ATOM    658  HG2 ARG A  43      15.158  60.714  15.442  1.00  0.00           H  
ATOM    659  HG3 ARG A  43      16.079  61.186  16.872  1.00  0.00           H  
ATOM    660  HD2 ARG A  43      17.801  60.635  15.483  1.00  0.00           H  
ATOM    661  HD3 ARG A  43      17.502  59.057  16.210  1.00  0.00           H  
ATOM    662  HE  ARG A  43      15.953  59.418  13.855  1.00  0.00           H  
ATOM    663 HH11 ARG A  43      19.169  58.698  14.982  1.00  0.00           H  
ATOM    664 HH12 ARG A  43      19.609  57.811  13.560  1.00  0.00           H  
ATOM    665 HH21 ARG A  43      16.522  58.251  11.980  1.00  0.00           H  
ATOM    666 HH22 ARG A  43      18.102  57.557  11.853  1.00  0.00           H  
ATOM    667  N   VAL A  44      13.029  57.313  17.883  1.00  0.00           N  
ATOM    668  CA  VAL A  44      12.507  56.265  18.752  1.00  0.00           C  
ATOM    669  C   VAL A  44      13.102  54.908  18.394  1.00  0.00           C  
ATOM    670  O   VAL A  44      12.983  54.444  17.260  1.00  0.00           O  
ATOM    671  CB  VAL A  44      10.972  56.178  18.667  1.00  0.00           C  
ATOM    672  CG1 VAL A  44      10.336  57.479  19.134  1.00  0.00           C  
ATOM    673  CG2 VAL A  44      10.535  55.840  17.249  1.00  0.00           C  
ATOM    674  H   VAL A  44      13.371  57.073  16.996  1.00  0.00           H  
ATOM    675  HA  VAL A  44      12.778  56.508  19.769  1.00  0.00           H  
ATOM    676  HB  VAL A  44      10.639  55.386  19.322  1.00  0.00           H  
ATOM    677 HG11 VAL A  44      10.677  58.290  18.507  1.00  0.00           H  
ATOM    678 HG12 VAL A  44       9.262  57.399  19.070  1.00  0.00           H  
ATOM    679 HG13 VAL A  44      10.623  57.672  20.157  1.00  0.00           H  
ATOM    680 HG21 VAL A  44      10.152  54.832  17.222  1.00  0.00           H  
ATOM    681 HG22 VAL A  44       9.761  56.528  16.937  1.00  0.00           H  
ATOM    682 HG23 VAL A  44      11.380  55.924  16.583  1.00  0.00           H  
ATOM    683  N   LYS A  45      13.745  54.274  19.369  1.00  0.00           N  
ATOM    684  CA  LYS A  45      14.358  52.968  19.160  1.00  0.00           C  
ATOM    685  C   LYS A  45      13.295  51.889  18.985  1.00  0.00           C  
ATOM    686  O   LYS A  45      12.685  51.441  19.957  1.00  0.00           O  
ATOM    687  CB  LYS A  45      15.270  52.615  20.338  1.00  0.00           C  
ATOM    688  CG  LYS A  45      16.225  51.471  20.045  1.00  0.00           C  
ATOM    689  CD  LYS A  45      17.297  51.352  21.116  1.00  0.00           C  
ATOM    690  CE  LYS A  45      18.393  50.381  20.702  1.00  0.00           C  
ATOM    691  NZ  LYS A  45      19.063  49.766  21.881  1.00  0.00           N  
ATOM    692  H   LYS A  45      13.807  54.695  20.253  1.00  0.00           H  
ATOM    693  HA  LYS A  45      14.951  53.020  18.259  1.00  0.00           H  
ATOM    694  HB2 LYS A  45      15.853  53.485  20.599  1.00  0.00           H  
ATOM    695  HB3 LYS A  45      14.655  52.336  21.182  1.00  0.00           H  
ATOM    696  HG2 LYS A  45      15.666  50.547  20.007  1.00  0.00           H  
ATOM    697  HG3 LYS A  45      16.701  51.646  19.090  1.00  0.00           H  
ATOM    698  HD2 LYS A  45      17.737  52.324  21.282  1.00  0.00           H  
ATOM    699  HD3 LYS A  45      16.842  50.999  22.031  1.00  0.00           H  
ATOM    700  HE2 LYS A  45      17.956  49.601  20.099  1.00  0.00           H  
ATOM    701  HE3 LYS A  45      19.128  50.916  20.120  1.00  0.00           H  
ATOM    702  HZ1 LYS A  45      18.451  49.035  22.298  1.00  0.00           H  
ATOM    703  HZ2 LYS A  45      19.256  50.491  22.601  1.00  0.00           H  
ATOM    704  HZ3 LYS A  45      19.961  49.329  21.594  1.00  0.00           H  
ATOM    705  N   VAL A  46      13.078  51.473  17.742  1.00  0.00           N  
ATOM    706  CA  VAL A  46      12.089  50.445  17.441  1.00  0.00           C  
ATOM    707  C   VAL A  46      12.696  49.050  17.555  1.00  0.00           C  
ATOM    708  O   VAL A  46      13.604  48.693  16.804  1.00  0.00           O  
ATOM    709  CB  VAL A  46      11.505  50.624  16.027  1.00  0.00           C  
ATOM    710  CG1 VAL A  46      10.490  51.757  16.009  1.00  0.00           C  
ATOM    711  CG2 VAL A  46      12.616  50.876  15.020  1.00  0.00           C  
ATOM    712  H   VAL A  46      13.596  51.867  17.009  1.00  0.00           H  
ATOM    713  HA  VAL A  46      11.283  50.536  18.155  1.00  0.00           H  
ATOM    714  HB  VAL A  46      10.997  49.711  15.751  1.00  0.00           H  
ATOM    715 HG11 VAL A  46      10.096  51.903  17.004  1.00  0.00           H  
ATOM    716 HG12 VAL A  46      10.970  52.665  15.673  1.00  0.00           H  
ATOM    717 HG13 VAL A  46       9.684  51.506  15.336  1.00  0.00           H  
ATOM    718 HG21 VAL A  46      13.573  50.703  15.489  1.00  0.00           H  
ATOM    719 HG22 VAL A  46      12.501  50.206  14.181  1.00  0.00           H  
ATOM    720 HG23 VAL A  46      12.564  51.898  14.674  1.00  0.00           H  
ATOM    721  N   HIS A  47      12.186  48.265  18.498  1.00  0.00           N  
ATOM    722  CA  HIS A  47      12.676  46.908  18.710  1.00  0.00           C  
ATOM    723  C   HIS A  47      11.697  45.881  18.148  1.00  0.00           C  
ATOM    724  O   HIS A  47      10.534  45.832  18.550  1.00  0.00           O  
ATOM    725  CB  HIS A  47      12.901  46.651  20.201  1.00  0.00           C  
ATOM    726  CG  HIS A  47      12.855  45.201  20.572  1.00  0.00           C  
ATOM    727  ND1 HIS A  47      13.985  44.454  20.832  1.00  0.00           N  
ATOM    728  CD2 HIS A  47      11.806  44.360  20.729  1.00  0.00           C  
ATOM    729  CE1 HIS A  47      13.633  43.216  21.130  1.00  0.00           C  
ATOM    730  NE2 HIS A  47      12.317  43.133  21.076  1.00  0.00           N  
ATOM    731  H   HIS A  47      11.463  48.605  19.065  1.00  0.00           H  
ATOM    732  HA  HIS A  47      13.617  46.810  18.192  1.00  0.00           H  
ATOM    733  HB2 HIS A  47      13.870  47.034  20.484  1.00  0.00           H  
ATOM    734  HB3 HIS A  47      12.137  47.163  20.767  1.00  0.00           H  
ATOM    735  HD1 HIS A  47      14.908  44.782  20.800  1.00  0.00           H  
ATOM    736  HD2 HIS A  47      10.762  44.606  20.605  1.00  0.00           H  
ATOM    737  HE1 HIS A  47      14.307  42.409  21.378  1.00  0.00           H  
ATOM    738  HE2 HIS A  47      11.799  42.306  21.170  1.00  0.00           H  
ATOM    739  N   PHE A  48      12.174  45.066  17.214  1.00  0.00           N  
ATOM    740  CA  PHE A  48      11.340  44.042  16.594  1.00  0.00           C  
ATOM    741  C   PHE A  48      11.206  42.825  17.504  1.00  0.00           C  
ATOM    742  O   PHE A  48      12.149  42.048  17.663  1.00  0.00           O  
ATOM    743  CB  PHE A  48      11.929  43.622  15.246  1.00  0.00           C  
ATOM    744  CG  PHE A  48      11.730  44.641  14.161  1.00  0.00           C  
ATOM    745  CD1 PHE A  48      12.106  45.962  14.355  1.00  0.00           C  
ATOM    746  CD2 PHE A  48      11.168  44.281  12.947  1.00  0.00           C  
ATOM    747  CE1 PHE A  48      11.925  46.903  13.360  1.00  0.00           C  
ATOM    748  CE2 PHE A  48      10.984  45.218  11.948  1.00  0.00           C  
ATOM    749  CZ  PHE A  48      11.363  46.530  12.155  1.00  0.00           C  
ATOM    750  H   PHE A  48      13.110  45.154  16.934  1.00  0.00           H  
ATOM    751  HA  PHE A  48      10.361  44.466  16.434  1.00  0.00           H  
ATOM    752  HB2 PHE A  48      12.990  43.461  15.359  1.00  0.00           H  
ATOM    753  HB3 PHE A  48      11.461  42.702  14.927  1.00  0.00           H  
ATOM    754  HD1 PHE A  48      12.546  46.254  15.299  1.00  0.00           H  
ATOM    755  HD2 PHE A  48      10.870  43.256  12.785  1.00  0.00           H  
ATOM    756  HE1 PHE A  48      12.221  47.927  13.525  1.00  0.00           H  
ATOM    757  HE2 PHE A  48      10.544  44.924  11.006  1.00  0.00           H  
ATOM    758  HZ  PHE A  48      11.220  47.264  11.375  1.00  0.00           H  
ATOM    759  N   ASP A  49      10.030  42.665  18.101  1.00  0.00           N  
ATOM    760  CA  ASP A  49       9.771  41.544  18.995  1.00  0.00           C  
ATOM    761  C   ASP A  49      10.413  40.266  18.464  1.00  0.00           C  
ATOM    762  O   ASP A  49      10.059  39.782  17.390  1.00  0.00           O  
ATOM    763  CB  ASP A  49       8.266  41.339  19.169  1.00  0.00           C  
ATOM    764  CG  ASP A  49       7.942  40.178  20.089  1.00  0.00           C  
ATOM    765  OD1 ASP A  49       8.521  40.116  21.194  1.00  0.00           O  
ATOM    766  OD2 ASP A  49       7.109  39.331  19.704  1.00  0.00           O  
ATOM    767  H   ASP A  49       9.318  43.319  17.935  1.00  0.00           H  
ATOM    768  HA  ASP A  49      10.206  41.778  19.955  1.00  0.00           H  
ATOM    769  HB2 ASP A  49       7.833  42.236  19.587  1.00  0.00           H  
ATOM    770  HB3 ASP A  49       7.822  41.146  18.204  1.00  0.00           H  
ATOM    771  N   GLY A  50      11.361  39.725  19.223  1.00  0.00           N  
ATOM    772  CA  GLY A  50      12.038  38.509  18.811  1.00  0.00           C  
ATOM    773  C   GLY A  50      13.394  38.782  18.192  1.00  0.00           C  
ATOM    774  O   GLY A  50      14.425  38.395  18.743  1.00  0.00           O  
ATOM    775  H   GLY A  50      11.602  40.155  20.071  1.00  0.00           H  
ATOM    776  HA2 GLY A  50      12.169  37.873  19.674  1.00  0.00           H  
ATOM    777  HA3 GLY A  50      11.421  37.995  18.089  1.00  0.00           H  
ATOM    778  N   TRP A  51      13.394  39.448  17.043  1.00  0.00           N  
ATOM    779  CA  TRP A  51      14.634  39.770  16.347  1.00  0.00           C  
ATOM    780  C   TRP A  51      15.707  40.228  17.329  1.00  0.00           C  
ATOM    781  O   TRP A  51      15.493  41.156  18.107  1.00  0.00           O  
ATOM    782  CB  TRP A  51      14.387  40.857  15.299  1.00  0.00           C  
ATOM    783  CG  TRP A  51      13.514  40.405  14.168  1.00  0.00           C  
ATOM    784  CD1 TRP A  51      12.172  40.162  14.215  1.00  0.00           C  
ATOM    785  CD2 TRP A  51      13.925  40.139  12.822  1.00  0.00           C  
ATOM    786  NE1 TRP A  51      11.723  39.761  12.980  1.00  0.00           N  
ATOM    787  CE2 TRP A  51      12.778  39.739  12.108  1.00  0.00           C  
ATOM    788  CE3 TRP A  51      15.149  40.201  12.151  1.00  0.00           C  
ATOM    789  CZ2 TRP A  51      12.823  39.405  10.758  1.00  0.00           C  
ATOM    790  CZ3 TRP A  51      15.191  39.867  10.810  1.00  0.00           C  
ATOM    791  CH2 TRP A  51      14.034  39.474  10.124  1.00  0.00           C  
ATOM    792  H   TRP A  51      12.540  39.730  16.653  1.00  0.00           H  
ATOM    793  HA  TRP A  51      14.977  38.875  15.849  1.00  0.00           H  
ATOM    794  HB2 TRP A  51      13.909  41.702  15.771  1.00  0.00           H  
ATOM    795  HB3 TRP A  51      15.335  41.169  14.886  1.00  0.00           H  
ATOM    796  HD1 TRP A  51      11.565  40.271  15.101  1.00  0.00           H  
ATOM    797  HE1 TRP A  51      10.796  39.530  12.760  1.00  0.00           H  
ATOM    798  HE3 TRP A  51      16.052  40.502  12.661  1.00  0.00           H  
ATOM    799  HZ2 TRP A  51      11.939  39.099  10.215  1.00  0.00           H  
ATOM    800  HZ3 TRP A  51      16.128  39.909  10.275  1.00  0.00           H  
ATOM    801  HH2 TRP A  51      14.113  39.223   9.078  1.00  0.00           H  
ATOM    802  N   ASN A  52      16.861  39.571  17.287  1.00  0.00           N  
ATOM    803  CA  ASN A  52      17.967  39.911  18.174  1.00  0.00           C  
ATOM    804  C   ASN A  52      18.063  41.422  18.371  1.00  0.00           C  
ATOM    805  O   ASN A  52      18.124  42.180  17.404  1.00  0.00           O  
ATOM    806  CB  ASN A  52      19.285  39.375  17.612  1.00  0.00           C  
ATOM    807  CG  ASN A  52      20.413  39.436  18.622  1.00  0.00           C  
ATOM    808  OD1 ASN A  52      21.457  40.040  18.369  1.00  0.00           O  
ATOM    809  ND2 ASN A  52      20.210  38.809  19.774  1.00  0.00           N  
ATOM    810  H   ASN A  52      16.972  38.839  16.644  1.00  0.00           H  
ATOM    811  HA  ASN A  52      17.780  39.447  19.131  1.00  0.00           H  
ATOM    812  HB2 ASN A  52      19.149  38.345  17.314  1.00  0.00           H  
ATOM    813  HB3 ASN A  52      19.566  39.960  16.749  1.00  0.00           H  
ATOM    814 HD21 ASN A  52      19.355  38.348  19.907  1.00  0.00           H  
ATOM    815 HD22 ASN A  52      20.924  38.833  20.446  1.00  0.00           H  
ATOM    816  N   ASN A  53      18.076  41.850  19.629  1.00  0.00           N  
ATOM    817  CA  ASN A  53      18.164  43.269  19.952  1.00  0.00           C  
ATOM    818  C   ASN A  53      19.072  43.996  18.966  1.00  0.00           C  
ATOM    819  O   ASN A  53      18.729  45.066  18.462  1.00  0.00           O  
ATOM    820  CB  ASN A  53      18.686  43.457  21.378  1.00  0.00           C  
ATOM    821  CG  ASN A  53      17.659  43.071  22.425  1.00  0.00           C  
ATOM    822  OD1 ASN A  53      16.745  42.291  22.156  1.00  0.00           O  
ATOM    823  ND2 ASN A  53      17.805  43.618  23.626  1.00  0.00           N  
ATOM    824  H   ASN A  53      18.024  41.196  20.357  1.00  0.00           H  
ATOM    825  HA  ASN A  53      17.170  43.686  19.884  1.00  0.00           H  
ATOM    826  HB2 ASN A  53      19.563  42.842  21.518  1.00  0.00           H  
ATOM    827  HB3 ASN A  53      18.951  44.494  21.525  1.00  0.00           H  
ATOM    828 HD21 ASN A  53      18.556  44.232  23.767  1.00  0.00           H  
ATOM    829 HD22 ASN A  53      17.156  43.387  24.322  1.00  0.00           H  
ATOM    830  N   CYS A  54      20.233  43.408  18.695  1.00  0.00           N  
ATOM    831  CA  CYS A  54      21.192  44.000  17.769  1.00  0.00           C  
ATOM    832  C   CYS A  54      20.477  44.671  16.601  1.00  0.00           C  
ATOM    833  O   CYS A  54      20.800  45.799  16.228  1.00  0.00           O  
ATOM    834  CB  CYS A  54      22.155  42.932  17.247  1.00  0.00           C  
ATOM    835  SG  CYS A  54      23.292  43.523  15.972  1.00  0.00           S  
ATOM    836  H   CYS A  54      20.450  42.557  19.128  1.00  0.00           H  
ATOM    837  HA  CYS A  54      21.754  44.747  18.308  1.00  0.00           H  
ATOM    838  HB2 CYS A  54      22.749  42.562  18.070  1.00  0.00           H  
ATOM    839  HB3 CYS A  54      21.583  42.117  16.829  1.00  0.00           H  
ATOM    840  HG  CYS A  54      23.175  44.840  15.898  1.00  0.00           H  
ATOM    841  N   TYR A  55      19.506  43.970  16.027  1.00  0.00           N  
ATOM    842  CA  TYR A  55      18.748  44.496  14.898  1.00  0.00           C  
ATOM    843  C   TYR A  55      18.201  45.886  15.209  1.00  0.00           C  
ATOM    844  O   TYR A  55      18.288  46.798  14.386  1.00  0.00           O  
ATOM    845  CB  TYR A  55      17.598  43.551  14.544  1.00  0.00           C  
ATOM    846  CG  TYR A  55      17.986  42.465  13.567  1.00  0.00           C  
ATOM    847  CD1 TYR A  55      18.062  42.726  12.203  1.00  0.00           C  
ATOM    848  CD2 TYR A  55      18.275  41.178  14.005  1.00  0.00           C  
ATOM    849  CE1 TYR A  55      18.416  41.736  11.306  1.00  0.00           C  
ATOM    850  CE2 TYR A  55      18.630  40.184  13.115  1.00  0.00           C  
ATOM    851  CZ  TYR A  55      18.699  40.467  11.767  1.00  0.00           C  
ATOM    852  OH  TYR A  55      19.052  39.478  10.877  1.00  0.00           O  
ATOM    853  H   TYR A  55      19.295  43.076  16.369  1.00  0.00           H  
ATOM    854  HA  TYR A  55      19.416  44.565  14.052  1.00  0.00           H  
ATOM    855  HB2 TYR A  55      17.243  43.074  15.445  1.00  0.00           H  
ATOM    856  HB3 TYR A  55      16.794  44.123  14.104  1.00  0.00           H  
ATOM    857  HD1 TYR A  55      17.841  43.720  11.846  1.00  0.00           H  
ATOM    858  HD2 TYR A  55      18.219  40.960  15.062  1.00  0.00           H  
ATOM    859  HE1 TYR A  55      18.470  41.958  10.251  1.00  0.00           H  
ATOM    860  HE2 TYR A  55      18.852  39.190  13.476  1.00  0.00           H  
ATOM    861  HH  TYR A  55      19.518  38.780  11.343  1.00  0.00           H  
ATOM    862  N   ASP A  56      17.638  46.040  16.402  1.00  0.00           N  
ATOM    863  CA  ASP A  56      17.078  47.318  16.825  1.00  0.00           C  
ATOM    864  C   ASP A  56      17.909  48.479  16.288  1.00  0.00           C  
ATOM    865  O   ASP A  56      19.133  48.386  16.188  1.00  0.00           O  
ATOM    866  CB  ASP A  56      17.008  47.388  18.352  1.00  0.00           C  
ATOM    867  CG  ASP A  56      16.331  46.174  18.957  1.00  0.00           C  
ATOM    868  OD1 ASP A  56      15.614  45.465  18.219  1.00  0.00           O  
ATOM    869  OD2 ASP A  56      16.520  45.932  20.166  1.00  0.00           O  
ATOM    870  H   ASP A  56      17.598  45.274  17.014  1.00  0.00           H  
ATOM    871  HA  ASP A  56      16.079  47.391  16.424  1.00  0.00           H  
ATOM    872  HB2 ASP A  56      18.010  47.453  18.750  1.00  0.00           H  
ATOM    873  HB3 ASP A  56      16.452  48.268  18.640  1.00  0.00           H  
ATOM    874  N   TYR A  57      17.237  49.571  15.944  1.00  0.00           N  
ATOM    875  CA  TYR A  57      17.912  50.750  15.414  1.00  0.00           C  
ATOM    876  C   TYR A  57      17.133  52.020  15.745  1.00  0.00           C  
ATOM    877  O   TYR A  57      15.924  51.976  15.974  1.00  0.00           O  
ATOM    878  CB  TYR A  57      18.087  50.625  13.900  1.00  0.00           C  
ATOM    879  CG  TYR A  57      16.850  50.129  13.185  1.00  0.00           C  
ATOM    880  CD1 TYR A  57      15.727  50.939  13.056  1.00  0.00           C  
ATOM    881  CD2 TYR A  57      16.803  48.852  12.641  1.00  0.00           C  
ATOM    882  CE1 TYR A  57      14.594  50.489  12.405  1.00  0.00           C  
ATOM    883  CE2 TYR A  57      15.675  48.395  11.987  1.00  0.00           C  
ATOM    884  CZ  TYR A  57      14.573  49.218  11.872  1.00  0.00           C  
ATOM    885  OH  TYR A  57      13.447  48.767  11.222  1.00  0.00           O  
ATOM    886  H   TYR A  57      16.262  49.586  16.048  1.00  0.00           H  
ATOM    887  HA  TYR A  57      18.887  50.809  15.875  1.00  0.00           H  
ATOM    888  HB2 TYR A  57      18.339  51.592  13.492  1.00  0.00           H  
ATOM    889  HB3 TYR A  57      18.889  49.932  13.693  1.00  0.00           H  
ATOM    890  HD1 TYR A  57      15.749  51.934  13.473  1.00  0.00           H  
ATOM    891  HD2 TYR A  57      17.668  48.211  12.733  1.00  0.00           H  
ATOM    892  HE1 TYR A  57      13.732  51.134  12.314  1.00  0.00           H  
ATOM    893  HE2 TYR A  57      15.657  47.399  11.570  1.00  0.00           H  
ATOM    894  HH  TYR A  57      12.688  48.847  11.805  1.00  0.00           H  
ATOM    895  N   TRP A  58      17.834  53.147  15.764  1.00  0.00           N  
ATOM    896  CA  TRP A  58      17.209  54.430  16.065  1.00  0.00           C  
ATOM    897  C   TRP A  58      16.531  55.008  14.828  1.00  0.00           C  
ATOM    898  O   TRP A  58      17.197  55.508  13.922  1.00  0.00           O  
ATOM    899  CB  TRP A  58      18.250  55.415  16.600  1.00  0.00           C  
ATOM    900  CG  TRP A  58      18.488  55.286  18.074  1.00  0.00           C  
ATOM    901  CD1 TRP A  58      19.599  54.778  18.682  1.00  0.00           C  
ATOM    902  CD2 TRP A  58      17.593  55.671  19.123  1.00  0.00           C  
ATOM    903  NE1 TRP A  58      19.450  54.824  20.048  1.00  0.00           N  
ATOM    904  CE2 TRP A  58      18.228  55.369  20.344  1.00  0.00           C  
ATOM    905  CE3 TRP A  58      16.319  56.245  19.150  1.00  0.00           C  
ATOM    906  CZ2 TRP A  58      17.629  55.619  21.576  1.00  0.00           C  
ATOM    907  CZ3 TRP A  58      15.726  56.492  20.374  1.00  0.00           C  
ATOM    908  CH2 TRP A  58      16.381  56.180  21.573  1.00  0.00           C  
ATOM    909  H   TRP A  58      18.795  53.117  15.572  1.00  0.00           H  
ATOM    910  HA  TRP A  58      16.461  54.263  16.826  1.00  0.00           H  
ATOM    911  HB2 TRP A  58      19.190  55.245  16.094  1.00  0.00           H  
ATOM    912  HB3 TRP A  58      17.915  56.423  16.402  1.00  0.00           H  
ATOM    913  HD1 TRP A  58      20.462  54.397  18.157  1.00  0.00           H  
ATOM    914  HE1 TRP A  58      20.111  54.518  20.703  1.00  0.00           H  
ATOM    915  HE3 TRP A  58      15.798  56.492  18.237  1.00  0.00           H  
ATOM    916  HZ2 TRP A  58      18.122  55.384  22.508  1.00  0.00           H  
ATOM    917  HZ3 TRP A  58      14.742  56.935  20.415  1.00  0.00           H  
ATOM    918  HH2 TRP A  58      15.880  56.390  22.505  1.00  0.00           H  
ATOM    919  N   ILE A  59      15.204  54.938  14.799  1.00  0.00           N  
ATOM    920  CA  ILE A  59      14.438  55.457  13.673  1.00  0.00           C  
ATOM    921  C   ILE A  59      13.680  56.723  14.061  1.00  0.00           C  
ATOM    922  O   ILE A  59      13.182  56.843  15.180  1.00  0.00           O  
ATOM    923  CB  ILE A  59      13.434  54.413  13.147  1.00  0.00           C  
ATOM    924  CG1 ILE A  59      12.969  54.786  11.738  1.00  0.00           C  
ATOM    925  CG2 ILE A  59      12.245  54.299  14.090  1.00  0.00           C  
ATOM    926  CD1 ILE A  59      12.310  53.644  10.997  1.00  0.00           C  
ATOM    927  H   ILE A  59      14.730  54.529  15.552  1.00  0.00           H  
ATOM    928  HA  ILE A  59      15.130  55.694  12.878  1.00  0.00           H  
ATOM    929  HB  ILE A  59      13.929  53.456  13.113  1.00  0.00           H  
ATOM    930 HG12 ILE A  59      12.257  55.594  11.803  1.00  0.00           H  
ATOM    931 HG13 ILE A  59      13.822  55.110  11.159  1.00  0.00           H  
ATOM    932 HG21 ILE A  59      11.503  53.645  13.655  1.00  0.00           H  
ATOM    933 HG22 ILE A  59      12.574  53.891  15.034  1.00  0.00           H  
ATOM    934 HG23 ILE A  59      11.816  55.277  14.249  1.00  0.00           H  
ATOM    935 HD11 ILE A  59      11.450  54.014  10.457  1.00  0.00           H  
ATOM    936 HD12 ILE A  59      13.013  53.210  10.304  1.00  0.00           H  
ATOM    937 HD13 ILE A  59      11.991  52.892  11.705  1.00  0.00           H  
ATOM    938  N   ASP A  60      13.597  57.665  13.127  1.00  0.00           N  
ATOM    939  CA  ASP A  60      12.898  58.921  13.369  1.00  0.00           C  
ATOM    940  C   ASP A  60      11.402  58.686  13.544  1.00  0.00           C  
ATOM    941  O   ASP A  60      10.748  58.109  12.676  1.00  0.00           O  
ATOM    942  CB  ASP A  60      13.142  59.896  12.215  1.00  0.00           C  
ATOM    943  CG  ASP A  60      14.601  60.285  12.085  1.00  0.00           C  
ATOM    944  OD1 ASP A  60      15.355  59.548  11.414  1.00  0.00           O  
ATOM    945  OD2 ASP A  60      14.991  61.326  12.654  1.00  0.00           O  
ATOM    946  H   ASP A  60      14.015  57.510  12.254  1.00  0.00           H  
ATOM    947  HA  ASP A  60      13.292  59.350  14.278  1.00  0.00           H  
ATOM    948  HB2 ASP A  60      12.828  59.433  11.290  1.00  0.00           H  
ATOM    949  HB3 ASP A  60      12.562  60.791  12.380  1.00  0.00           H  
ATOM    950  N   ALA A  61      10.866  59.135  14.675  1.00  0.00           N  
ATOM    951  CA  ALA A  61       9.446  58.974  14.964  1.00  0.00           C  
ATOM    952  C   ALA A  61       8.590  59.704  13.935  1.00  0.00           C  
ATOM    953  O   ALA A  61       7.393  59.444  13.812  1.00  0.00           O  
ATOM    954  CB  ALA A  61       9.133  59.476  16.365  1.00  0.00           C  
ATOM    955  H   ALA A  61      11.439  59.587  15.329  1.00  0.00           H  
ATOM    956  HA  ALA A  61       9.215  57.919  14.926  1.00  0.00           H  
ATOM    957  HB1 ALA A  61       8.365  58.856  16.805  1.00  0.00           H  
ATOM    958  HB2 ALA A  61      10.025  59.430  16.972  1.00  0.00           H  
ATOM    959  HB3 ALA A  61       8.785  60.497  16.313  1.00  0.00           H  
ATOM    960  N   ASP A  62       9.211  60.619  13.197  1.00  0.00           N  
ATOM    961  CA  ASP A  62       8.505  61.387  12.178  1.00  0.00           C  
ATOM    962  C   ASP A  62       8.771  60.818  10.788  1.00  0.00           C  
ATOM    963  O   ASP A  62       8.359  61.395   9.781  1.00  0.00           O  
ATOM    964  CB  ASP A  62       8.929  62.856  12.231  1.00  0.00           C  
ATOM    965  CG  ASP A  62       8.519  63.530  13.526  1.00  0.00           C  
ATOM    966  OD1 ASP A  62       7.305  63.743  13.726  1.00  0.00           O  
ATOM    967  OD2 ASP A  62       9.413  63.844  14.340  1.00  0.00           O  
ATOM    968  H   ASP A  62      10.166  60.781  13.342  1.00  0.00           H  
ATOM    969  HA  ASP A  62       7.447  61.320  12.385  1.00  0.00           H  
ATOM    970  HB2 ASP A  62      10.003  62.917  12.139  1.00  0.00           H  
ATOM    971  HB3 ASP A  62       8.470  63.385  11.409  1.00  0.00           H  
ATOM    972  N   SER A  63       9.461  59.683  10.741  1.00  0.00           N  
ATOM    973  CA  SER A  63       9.787  59.039   9.475  1.00  0.00           C  
ATOM    974  C   SER A  63       8.524  58.540   8.779  1.00  0.00           C  
ATOM    975  O   SER A  63       7.589  58.049   9.411  1.00  0.00           O  
ATOM    976  CB  SER A  63      10.751  57.872   9.703  1.00  0.00           C  
ATOM    977  OG  SER A  63      11.341  57.452   8.486  1.00  0.00           O  
ATOM    978  H   SER A  63       9.763  59.272  11.579  1.00  0.00           H  
ATOM    979  HA  SER A  63      10.266  59.772   8.843  1.00  0.00           H  
ATOM    980  HB2 SER A  63      11.532  58.183  10.381  1.00  0.00           H  
ATOM    981  HB3 SER A  63      10.211  57.042  10.134  1.00  0.00           H  
ATOM    982  HG  SER A  63      10.743  56.857   8.028  1.00  0.00           H  
ATOM    983  N   PRO A  64       8.494  58.669   7.443  1.00  0.00           N  
ATOM    984  CA  PRO A  64       7.353  58.238   6.632  1.00  0.00           C  
ATOM    985  C   PRO A  64       7.216  56.720   6.585  1.00  0.00           C  
ATOM    986  O   PRO A  64       6.137  56.193   6.310  1.00  0.00           O  
ATOM    987  CB  PRO A  64       7.680  58.787   5.241  1.00  0.00           C  
ATOM    988  CG  PRO A  64       9.165  58.905   5.219  1.00  0.00           C  
ATOM    989  CD  PRO A  64       9.574  59.246   6.624  1.00  0.00           C  
ATOM    990  HA  PRO A  64       6.429  58.672   6.984  1.00  0.00           H  
ATOM    991  HB2 PRO A  64       7.326  58.099   4.486  1.00  0.00           H  
ATOM    992  HB3 PRO A  64       7.206  59.749   5.109  1.00  0.00           H  
ATOM    993  HG2 PRO A  64       9.603  57.965   4.918  1.00  0.00           H  
ATOM    994  HG3 PRO A  64       9.461  59.692   4.541  1.00  0.00           H  
ATOM    995  HD2 PRO A  64      10.524  58.791   6.862  1.00  0.00           H  
ATOM    996  HD3 PRO A  64       9.625  60.317   6.753  1.00  0.00           H  
ATOM    997  N   ASP A  65       8.313  56.023   6.858  1.00  0.00           N  
ATOM    998  CA  ASP A  65       8.313  54.564   6.850  1.00  0.00           C  
ATOM    999  C   ASP A  65       7.579  54.013   8.067  1.00  0.00           C  
ATOM   1000  O   ASP A  65       6.918  52.977   7.990  1.00  0.00           O  
ATOM   1001  CB  ASP A  65       9.748  54.034   6.820  1.00  0.00           C  
ATOM   1002  CG  ASP A  65      10.678  54.924   6.020  1.00  0.00           C  
ATOM   1003  OD1 ASP A  65      10.392  55.163   4.828  1.00  0.00           O  
ATOM   1004  OD2 ASP A  65      11.693  55.382   6.586  1.00  0.00           O  
ATOM   1005  H   ASP A  65       9.142  56.500   7.071  1.00  0.00           H  
ATOM   1006  HA  ASP A  65       7.800  54.237   5.957  1.00  0.00           H  
ATOM   1007  HB2 ASP A  65      10.122  53.970   7.832  1.00  0.00           H  
ATOM   1008  HB3 ASP A  65       9.751  53.049   6.377  1.00  0.00           H  
ATOM   1009  N   ILE A  66       7.700  54.712   9.191  1.00  0.00           N  
ATOM   1010  CA  ILE A  66       7.047  54.292  10.425  1.00  0.00           C  
ATOM   1011  C   ILE A  66       5.529  54.363  10.296  1.00  0.00           C  
ATOM   1012  O   ILE A  66       4.974  55.394   9.914  1.00  0.00           O  
ATOM   1013  CB  ILE A  66       7.489  55.160  11.618  1.00  0.00           C  
ATOM   1014  CG1 ILE A  66       8.913  54.790  12.045  1.00  0.00           C  
ATOM   1015  CG2 ILE A  66       6.523  54.993  12.781  1.00  0.00           C  
ATOM   1016  CD1 ILE A  66       9.410  55.580  13.236  1.00  0.00           C  
ATOM   1017  H   ILE A  66       8.240  55.529   9.190  1.00  0.00           H  
ATOM   1018  HA  ILE A  66       7.334  53.270  10.622  1.00  0.00           H  
ATOM   1019  HB  ILE A  66       7.470  56.194  11.311  1.00  0.00           H  
ATOM   1020 HG12 ILE A  66       8.943  53.744  12.306  1.00  0.00           H  
ATOM   1021 HG13 ILE A  66       9.585  54.973  11.220  1.00  0.00           H  
ATOM   1022 HG21 ILE A  66       7.031  55.221  13.707  1.00  0.00           H  
ATOM   1023 HG22 ILE A  66       5.689  55.668  12.654  1.00  0.00           H  
ATOM   1024 HG23 ILE A  66       6.163  53.976  12.808  1.00  0.00           H  
ATOM   1025 HD11 ILE A  66       8.737  56.402  13.430  1.00  0.00           H  
ATOM   1026 HD12 ILE A  66       9.454  54.936  14.102  1.00  0.00           H  
ATOM   1027 HD13 ILE A  66      10.396  55.966  13.024  1.00  0.00           H  
ATOM   1028  N   HIS A  67       4.862  53.259  10.617  1.00  0.00           N  
ATOM   1029  CA  HIS A  67       3.406  53.196  10.540  1.00  0.00           C  
ATOM   1030  C   HIS A  67       2.815  52.672  11.845  1.00  0.00           C  
ATOM   1031  O   HIS A  67       3.375  51.793  12.500  1.00  0.00           O  
ATOM   1032  CB  HIS A  67       2.976  52.302   9.376  1.00  0.00           C  
ATOM   1033  CG  HIS A  67       3.462  52.779   8.042  1.00  0.00           C  
ATOM   1034  ND1 HIS A  67       3.002  53.933   7.442  1.00  0.00           N  
ATOM   1035  CD2 HIS A  67       4.374  52.253   7.193  1.00  0.00           C  
ATOM   1036  CE1 HIS A  67       3.609  54.094   6.280  1.00  0.00           C  
ATOM   1037  NE2 HIS A  67       4.448  53.088   6.106  1.00  0.00           N  
ATOM   1038  H   HIS A  67       5.359  52.469  10.915  1.00  0.00           H  
ATOM   1039  HA  HIS A  67       3.040  54.196  10.368  1.00  0.00           H  
ATOM   1040  HB2 HIS A  67       3.364  51.306   9.533  1.00  0.00           H  
ATOM   1041  HB3 HIS A  67       1.896  52.262   9.342  1.00  0.00           H  
ATOM   1042  HD1 HIS A  67       2.329  54.541   7.812  1.00  0.00           H  
ATOM   1043  HD2 HIS A  67       4.940  51.343   7.341  1.00  0.00           H  
ATOM   1044  HE1 HIS A  67       3.448  54.908   5.591  1.00  0.00           H  
ATOM   1045  HE2 HIS A  67       4.960  52.917   5.288  1.00  0.00           H  
ATOM   1046  N   PRO A  68       1.656  53.225  12.234  1.00  0.00           N  
ATOM   1047  CA  PRO A  68       0.964  52.829  13.464  1.00  0.00           C  
ATOM   1048  C   PRO A  68       0.377  51.425  13.373  1.00  0.00           C  
ATOM   1049  O   PRO A  68       0.225  50.874  12.283  1.00  0.00           O  
ATOM   1050  CB  PRO A  68      -0.152  53.869  13.592  1.00  0.00           C  
ATOM   1051  CG  PRO A  68      -0.399  54.333  12.199  1.00  0.00           C  
ATOM   1052  CD  PRO A  68       0.933  54.278  11.502  1.00  0.00           C  
ATOM   1053  HA  PRO A  68       1.616  52.891  14.323  1.00  0.00           H  
ATOM   1054  HB2 PRO A  68      -1.033  53.405  14.017  1.00  0.00           H  
ATOM   1055  HB3 PRO A  68       0.176  54.678  14.227  1.00  0.00           H  
ATOM   1056  HG2 PRO A  68      -1.105  53.679  11.712  1.00  0.00           H  
ATOM   1057  HG3 PRO A  68      -0.772  55.347  12.212  1.00  0.00           H  
ATOM   1058  HD2 PRO A  68       0.804  54.008  10.464  1.00  0.00           H  
ATOM   1059  HD3 PRO A  68       1.443  55.226  11.587  1.00  0.00           H  
ATOM   1060  N   VAL A  69       0.046  50.850  14.525  1.00  0.00           N  
ATOM   1061  CA  VAL A  69      -0.526  49.510  14.574  1.00  0.00           C  
ATOM   1062  C   VAL A  69      -1.871  49.460  13.860  1.00  0.00           C  
ATOM   1063  O   VAL A  69      -2.883  49.920  14.387  1.00  0.00           O  
ATOM   1064  CB  VAL A  69      -0.711  49.033  16.027  1.00  0.00           C  
ATOM   1065  CG1 VAL A  69      -1.665  47.849  16.082  1.00  0.00           C  
ATOM   1066  CG2 VAL A  69       0.632  48.675  16.645  1.00  0.00           C  
ATOM   1067  H   VAL A  69       0.191  51.340  15.361  1.00  0.00           H  
ATOM   1068  HA  VAL A  69       0.159  48.836  14.080  1.00  0.00           H  
ATOM   1069  HB  VAL A  69      -1.142  49.842  16.598  1.00  0.00           H  
ATOM   1070 HG11 VAL A  69      -1.249  47.082  16.718  1.00  0.00           H  
ATOM   1071 HG12 VAL A  69      -2.616  48.171  16.481  1.00  0.00           H  
ATOM   1072 HG13 VAL A  69      -1.806  47.454  15.087  1.00  0.00           H  
ATOM   1073 HG21 VAL A  69       1.174  49.580  16.875  1.00  0.00           H  
ATOM   1074 HG22 VAL A  69       0.472  48.111  17.553  1.00  0.00           H  
ATOM   1075 HG23 VAL A  69       1.203  48.080  15.948  1.00  0.00           H  
ATOM   1076  N   GLY A  70      -1.874  48.899  12.654  1.00  0.00           N  
ATOM   1077  CA  GLY A  70      -3.101  48.798  11.886  1.00  0.00           C  
ATOM   1078  C   GLY A  70      -2.977  49.427  10.511  1.00  0.00           C  
ATOM   1079  O   GLY A  70      -3.964  49.543   9.784  1.00  0.00           O  
ATOM   1080  H   GLY A  70      -1.037  48.550  12.284  1.00  0.00           H  
ATOM   1081  HA2 GLY A  70      -3.357  47.756  11.771  1.00  0.00           H  
ATOM   1082  HA3 GLY A  70      -3.892  49.297  12.426  1.00  0.00           H  
ATOM   1083  N   TRP A  71      -1.764  49.836  10.157  1.00  0.00           N  
ATOM   1084  CA  TRP A  71      -1.516  50.458   8.861  1.00  0.00           C  
ATOM   1085  C   TRP A  71      -1.691  49.449   7.731  1.00  0.00           C  
ATOM   1086  O   TRP A  71      -1.754  49.822   6.559  1.00  0.00           O  
ATOM   1087  CB  TRP A  71      -0.107  51.050   8.819  1.00  0.00           C  
ATOM   1088  CG  TRP A  71       0.386  51.312   7.428  1.00  0.00           C  
ATOM   1089  CD1 TRP A  71       0.510  52.526   6.816  1.00  0.00           C  
ATOM   1090  CD2 TRP A  71       0.819  50.335   6.474  1.00  0.00           C  
ATOM   1091  NE1 TRP A  71       0.994  52.365   5.541  1.00  0.00           N  
ATOM   1092  CE2 TRP A  71       1.192  51.029   5.308  1.00  0.00           C  
ATOM   1093  CE3 TRP A  71       0.929  48.942   6.494  1.00  0.00           C  
ATOM   1094  CZ2 TRP A  71       1.666  50.376   4.173  1.00  0.00           C  
ATOM   1095  CZ3 TRP A  71       1.400  48.296   5.367  1.00  0.00           C  
ATOM   1096  CH2 TRP A  71       1.764  49.012   4.220  1.00  0.00           C  
ATOM   1097  H   TRP A  71      -1.018  49.716  10.781  1.00  0.00           H  
ATOM   1098  HA  TRP A  71      -2.235  51.253   8.733  1.00  0.00           H  
ATOM   1099  HB2 TRP A  71      -0.101  51.987   9.356  1.00  0.00           H  
ATOM   1100  HB3 TRP A  71       0.579  50.364   9.293  1.00  0.00           H  
ATOM   1101  HD1 TRP A  71       0.259  53.468   7.280  1.00  0.00           H  
ATOM   1102  HE1 TRP A  71       1.170  53.088   4.903  1.00  0.00           H  
ATOM   1103  HE3 TRP A  71       0.654  48.372   7.369  1.00  0.00           H  
ATOM   1104  HZ2 TRP A  71       1.952  50.915   3.281  1.00  0.00           H  
ATOM   1105  HZ3 TRP A  71       1.492  47.219   5.364  1.00  0.00           H  
ATOM   1106  HH2 TRP A  71       2.126  48.465   3.363  1.00  0.00           H  
ATOM   1107  N   CYS A  72      -1.768  48.173   8.090  1.00  0.00           N  
ATOM   1108  CA  CYS A  72      -1.935  47.111   7.104  1.00  0.00           C  
ATOM   1109  C   CYS A  72      -3.306  47.195   6.441  1.00  0.00           C  
ATOM   1110  O   CYS A  72      -3.462  46.849   5.270  1.00  0.00           O  
ATOM   1111  CB  CYS A  72      -1.757  45.742   7.764  1.00  0.00           C  
ATOM   1112  SG  CYS A  72      -3.069  45.309   8.930  1.00  0.00           S  
ATOM   1113  H   CYS A  72      -1.711  47.938   9.039  1.00  0.00           H  
ATOM   1114  HA  CYS A  72      -1.175  47.237   6.348  1.00  0.00           H  
ATOM   1115  HB2 CYS A  72      -1.736  44.981   6.997  1.00  0.00           H  
ATOM   1116  HB3 CYS A  72      -0.820  45.729   8.300  1.00  0.00           H  
ATOM   1117  HG  CYS A  72      -2.499  44.938  10.067  1.00  0.00           H  
ATOM   1118  N   SER A  73      -4.297  47.655   7.198  1.00  0.00           N  
ATOM   1119  CA  SER A  73      -5.657  47.779   6.685  1.00  0.00           C  
ATOM   1120  C   SER A  73      -5.820  49.068   5.886  1.00  0.00           C  
ATOM   1121  O   SER A  73      -6.303  49.052   4.753  1.00  0.00           O  
ATOM   1122  CB  SER A  73      -6.662  47.750   7.837  1.00  0.00           C  
ATOM   1123  OG  SER A  73      -6.603  46.517   8.535  1.00  0.00           O  
ATOM   1124  H   SER A  73      -4.109  47.914   8.125  1.00  0.00           H  
ATOM   1125  HA  SER A  73      -5.843  46.938   6.034  1.00  0.00           H  
ATOM   1126  HB2 SER A  73      -6.441  48.550   8.526  1.00  0.00           H  
ATOM   1127  HB3 SER A  73      -7.661  47.879   7.444  1.00  0.00           H  
ATOM   1128  HG  SER A  73      -7.492  46.173   8.651  1.00  0.00           H  
ATOM   1129  N   LYS A  74      -5.413  50.183   6.483  1.00  0.00           N  
ATOM   1130  CA  LYS A  74      -5.511  51.481   5.827  1.00  0.00           C  
ATOM   1131  C   LYS A  74      -5.156  51.373   4.348  1.00  0.00           C  
ATOM   1132  O   LYS A  74      -5.987  51.639   3.478  1.00  0.00           O  
ATOM   1133  CB  LYS A  74      -4.588  52.493   6.511  1.00  0.00           C  
ATOM   1134  CG  LYS A  74      -4.761  52.552   8.019  1.00  0.00           C  
ATOM   1135  CD  LYS A  74      -4.132  53.805   8.604  1.00  0.00           C  
ATOM   1136  CE  LYS A  74      -2.614  53.712   8.616  1.00  0.00           C  
ATOM   1137  NZ  LYS A  74      -1.977  55.056   8.690  1.00  0.00           N  
ATOM   1138  H   LYS A  74      -5.035  50.131   7.386  1.00  0.00           H  
ATOM   1139  HA  LYS A  74      -6.532  51.822   5.917  1.00  0.00           H  
ATOM   1140  HB2 LYS A  74      -3.563  52.227   6.298  1.00  0.00           H  
ATOM   1141  HB3 LYS A  74      -4.787  53.475   6.108  1.00  0.00           H  
ATOM   1142  HG2 LYS A  74      -5.816  52.551   8.251  1.00  0.00           H  
ATOM   1143  HG3 LYS A  74      -4.293  51.685   8.461  1.00  0.00           H  
ATOM   1144  HD2 LYS A  74      -4.423  54.657   8.007  1.00  0.00           H  
ATOM   1145  HD3 LYS A  74      -4.485  53.936   9.617  1.00  0.00           H  
ATOM   1146  HE2 LYS A  74      -2.309  53.132   9.474  1.00  0.00           H  
ATOM   1147  HE3 LYS A  74      -2.289  53.217   7.714  1.00  0.00           H  
ATOM   1148  HZ1 LYS A  74      -1.266  55.074   9.449  1.00  0.00           H  
ATOM   1149  HZ2 LYS A  74      -2.694  55.782   8.886  1.00  0.00           H  
ATOM   1150  HZ3 LYS A  74      -1.511  55.280   7.787  1.00  0.00           H  
ATOM   1151  N   THR A  75      -3.918  50.980   4.068  1.00  0.00           N  
ATOM   1152  CA  THR A  75      -3.453  50.835   2.694  1.00  0.00           C  
ATOM   1153  C   THR A  75      -3.915  49.513   2.094  1.00  0.00           C  
ATOM   1154  O   THR A  75      -4.180  49.422   0.896  1.00  0.00           O  
ATOM   1155  CB  THR A  75      -1.918  50.916   2.608  1.00  0.00           C  
ATOM   1156  OG1 THR A  75      -1.331  49.764   3.225  1.00  0.00           O  
ATOM   1157  CG2 THR A  75      -1.404  52.177   3.287  1.00  0.00           C  
ATOM   1158  H   THR A  75      -3.303  50.782   4.804  1.00  0.00           H  
ATOM   1159  HA  THR A  75      -3.868  51.647   2.115  1.00  0.00           H  
ATOM   1160  HB  THR A  75      -1.631  50.943   1.566  1.00  0.00           H  
ATOM   1161  HG1 THR A  75      -1.470  49.803   4.174  1.00  0.00           H  
ATOM   1162 HG21 THR A  75      -2.204  52.636   3.849  1.00  0.00           H  
ATOM   1163 HG22 THR A  75      -1.047  52.869   2.538  1.00  0.00           H  
ATOM   1164 HG23 THR A  75      -0.596  51.922   3.955  1.00  0.00           H  
ATOM   1165  N   GLY A  76      -4.011  48.487   2.934  1.00  0.00           N  
ATOM   1166  CA  GLY A  76      -4.442  47.183   2.467  1.00  0.00           C  
ATOM   1167  C   GLY A  76      -3.276  46.268   2.144  1.00  0.00           C  
ATOM   1168  O   GLY A  76      -3.370  45.422   1.255  1.00  0.00           O  
ATOM   1169  H   GLY A  76      -3.786  48.617   3.879  1.00  0.00           H  
ATOM   1170  HA2 GLY A  76      -5.047  46.720   3.233  1.00  0.00           H  
ATOM   1171  HA3 GLY A  76      -5.040  47.311   1.578  1.00  0.00           H  
ATOM   1172  N   HIS A  77      -2.174  46.439   2.866  1.00  0.00           N  
ATOM   1173  CA  HIS A  77      -0.984  45.622   2.651  1.00  0.00           C  
ATOM   1174  C   HIS A  77      -0.884  44.520   3.701  1.00  0.00           C  
ATOM   1175  O   HIS A  77      -1.225  44.709   4.870  1.00  0.00           O  
ATOM   1176  CB  HIS A  77       0.272  46.494   2.689  1.00  0.00           C  
ATOM   1177  CG  HIS A  77       0.638  47.074   1.357  1.00  0.00           C  
ATOM   1178  ND1 HIS A  77       0.581  46.354   0.181  1.00  0.00           N  
ATOM   1179  CD2 HIS A  77       1.066  48.312   1.018  1.00  0.00           C  
ATOM   1180  CE1 HIS A  77       0.960  47.125  -0.822  1.00  0.00           C  
ATOM   1181  NE2 HIS A  77       1.260  48.318  -0.342  1.00  0.00           N  
ATOM   1182  H   HIS A  77      -2.161  47.129   3.562  1.00  0.00           H  
ATOM   1183  HA  HIS A  77      -1.067  45.168   1.676  1.00  0.00           H  
ATOM   1184  HB2 HIS A  77       0.112  47.314   3.374  1.00  0.00           H  
ATOM   1185  HB3 HIS A  77       1.105  45.899   3.033  1.00  0.00           H  
ATOM   1186  HD1 HIS A  77       0.306  45.419   0.097  1.00  0.00           H  
ATOM   1187  HD2 HIS A  77       1.227  49.142   1.692  1.00  0.00           H  
ATOM   1188  HE1 HIS A  77       1.016  46.830  -1.859  1.00  0.00           H  
ATOM   1189  HE2 HIS A  77       1.650  49.053  -0.859  1.00  0.00           H  
ATOM   1190  N   PRO A  78      -0.406  43.341   3.278  1.00  0.00           N  
ATOM   1191  CA  PRO A  78      -0.250  42.185   4.167  1.00  0.00           C  
ATOM   1192  C   PRO A  78       0.867  42.383   5.185  1.00  0.00           C  
ATOM   1193  O   PRO A  78       1.928  42.921   4.863  1.00  0.00           O  
ATOM   1194  CB  PRO A  78       0.097  41.044   3.207  1.00  0.00           C  
ATOM   1195  CG  PRO A  78       0.712  41.715   2.028  1.00  0.00           C  
ATOM   1196  CD  PRO A  78       0.020  43.044   1.901  1.00  0.00           C  
ATOM   1197  HA  PRO A  78      -1.171  41.955   4.683  1.00  0.00           H  
ATOM   1198  HB2 PRO A  78       0.793  40.369   3.685  1.00  0.00           H  
ATOM   1199  HB3 PRO A  78      -0.801  40.512   2.934  1.00  0.00           H  
ATOM   1200  HG2 PRO A  78       1.769  41.858   2.196  1.00  0.00           H  
ATOM   1201  HG3 PRO A  78       0.548  41.122   1.141  1.00  0.00           H  
ATOM   1202  HD2 PRO A  78       0.708  43.796   1.539  1.00  0.00           H  
ATOM   1203  HD3 PRO A  78      -0.833  42.964   1.243  1.00  0.00           H  
ATOM   1204  N   LEU A  79       0.623  41.947   6.416  1.00  0.00           N  
ATOM   1205  CA  LEU A  79       1.609  42.076   7.484  1.00  0.00           C  
ATOM   1206  C   LEU A  79       2.272  40.734   7.777  1.00  0.00           C  
ATOM   1207  O   LEU A  79       1.633  39.686   7.703  1.00  0.00           O  
ATOM   1208  CB  LEU A  79       0.949  42.620   8.751  1.00  0.00           C  
ATOM   1209  CG  LEU A  79       1.897  43.021   9.882  1.00  0.00           C  
ATOM   1210  CD1 LEU A  79       2.614  44.319   9.542  1.00  0.00           C  
ATOM   1211  CD2 LEU A  79       1.136  43.159  11.193  1.00  0.00           C  
ATOM   1212  H   LEU A  79      -0.240  41.527   6.613  1.00  0.00           H  
ATOM   1213  HA  LEU A  79       2.365  42.772   7.153  1.00  0.00           H  
ATOM   1214  HB2 LEU A  79       0.374  43.491   8.478  1.00  0.00           H  
ATOM   1215  HB3 LEU A  79       0.284  41.857   9.131  1.00  0.00           H  
ATOM   1216  HG  LEU A  79       2.644  42.250  10.007  1.00  0.00           H  
ATOM   1217 HD11 LEU A  79       2.841  44.854  10.452  1.00  0.00           H  
ATOM   1218 HD12 LEU A  79       1.980  44.928   8.914  1.00  0.00           H  
ATOM   1219 HD13 LEU A  79       3.532  44.095   9.017  1.00  0.00           H  
ATOM   1220 HD21 LEU A  79       0.553  42.266  11.364  1.00  0.00           H  
ATOM   1221 HD22 LEU A  79       0.478  44.014  11.139  1.00  0.00           H  
ATOM   1222 HD23 LEU A  79       1.837  43.293  12.003  1.00  0.00           H  
ATOM   1223  N   GLN A  80       3.558  40.776   8.113  1.00  0.00           N  
ATOM   1224  CA  GLN A  80       4.306  39.563   8.420  1.00  0.00           C  
ATOM   1225  C   GLN A  80       4.541  39.433   9.922  1.00  0.00           C  
ATOM   1226  O   GLN A  80       4.914  40.390  10.601  1.00  0.00           O  
ATOM   1227  CB  GLN A  80       5.646  39.565   7.681  1.00  0.00           C  
ATOM   1228  CG  GLN A  80       5.507  39.638   6.169  1.00  0.00           C  
ATOM   1229  CD  GLN A  80       4.588  38.566   5.615  1.00  0.00           C  
ATOM   1230  OE1 GLN A  80       3.371  38.741   5.565  1.00  0.00           O  
ATOM   1231  NE2 GLN A  80       5.168  37.448   5.195  1.00  0.00           N  
ATOM   1232  H   GLN A  80       4.012  41.643   8.156  1.00  0.00           H  
ATOM   1233  HA  GLN A  80       3.722  38.719   8.085  1.00  0.00           H  
ATOM   1234  HB2 GLN A  80       6.223  40.416   8.010  1.00  0.00           H  
ATOM   1235  HB3 GLN A  80       6.181  38.660   7.928  1.00  0.00           H  
ATOM   1236  HG2 GLN A  80       5.106  40.605   5.904  1.00  0.00           H  
ATOM   1237  HG3 GLN A  80       6.483  39.519   5.725  1.00  0.00           H  
ATOM   1238 HE21 GLN A  80       6.144  37.379   5.267  1.00  0.00           H  
ATOM   1239 HE22 GLN A  80       4.599  36.739   4.833  1.00  0.00           H  
ATOM   1240  N   PRO A  81       4.316  38.222  10.453  1.00  0.00           N  
ATOM   1241  CA  PRO A  81       4.496  37.939  11.880  1.00  0.00           C  
ATOM   1242  C   PRO A  81       5.964  37.956  12.294  1.00  0.00           C  
ATOM   1243  O   PRO A  81       6.860  37.663  11.501  1.00  0.00           O  
ATOM   1244  CB  PRO A  81       3.913  36.532  12.039  1.00  0.00           C  
ATOM   1245  CG  PRO A  81       4.040  35.915  10.689  1.00  0.00           C  
ATOM   1246  CD  PRO A  81       3.869  37.037   9.703  1.00  0.00           C  
ATOM   1247  HA  PRO A  81       3.942  38.631  12.496  1.00  0.00           H  
ATOM   1248  HB2 PRO A  81       4.480  35.986  12.780  1.00  0.00           H  
ATOM   1249  HB3 PRO A  81       2.880  36.600  12.346  1.00  0.00           H  
ATOM   1250  HG2 PRO A  81       5.015  35.466  10.581  1.00  0.00           H  
ATOM   1251  HG3 PRO A  81       3.267  35.174  10.551  1.00  0.00           H  
ATOM   1252  HD2 PRO A  81       4.490  36.874   8.834  1.00  0.00           H  
ATOM   1253  HD3 PRO A  81       2.833  37.132   9.415  1.00  0.00           H  
ATOM   1254  N   PRO A  82       6.218  38.306  13.563  1.00  0.00           N  
ATOM   1255  CA  PRO A  82       7.576  38.369  14.110  1.00  0.00           C  
ATOM   1256  C   PRO A  82       8.205  36.987  14.263  1.00  0.00           C  
ATOM   1257  O   PRO A  82       7.664  35.992  13.777  1.00  0.00           O  
ATOM   1258  CB  PRO A  82       7.377  39.019  15.482  1.00  0.00           C  
ATOM   1259  CG  PRO A  82       5.970  38.696  15.853  1.00  0.00           C  
ATOM   1260  CD  PRO A  82       5.198  38.667  14.563  1.00  0.00           C  
ATOM   1261  HA  PRO A  82       8.220  38.990  13.505  1.00  0.00           H  
ATOM   1262  HB2 PRO A  82       8.079  38.598  16.188  1.00  0.00           H  
ATOM   1263  HB3 PRO A  82       7.531  40.085  15.404  1.00  0.00           H  
ATOM   1264  HG2 PRO A  82       5.930  37.733  16.337  1.00  0.00           H  
ATOM   1265  HG3 PRO A  82       5.579  39.463  16.506  1.00  0.00           H  
ATOM   1266  HD2 PRO A  82       4.419  37.920  14.606  1.00  0.00           H  
ATOM   1267  HD3 PRO A  82       4.780  39.639  14.351  1.00  0.00           H  
ATOM   1268  N   LEU A  83       9.347  36.932  14.939  1.00  0.00           N  
ATOM   1269  CA  LEU A  83      10.048  35.672  15.155  1.00  0.00           C  
ATOM   1270  C   LEU A  83       9.193  34.706  15.968  1.00  0.00           C  
ATOM   1271  O   LEU A  83       8.214  35.105  16.597  1.00  0.00           O  
ATOM   1272  CB  LEU A  83      11.376  35.923  15.873  1.00  0.00           C  
ATOM   1273  CG  LEU A  83      12.589  36.162  14.973  1.00  0.00           C  
ATOM   1274  CD1 LEU A  83      13.853  36.303  15.809  1.00  0.00           C  
ATOM   1275  CD2 LEU A  83      12.738  35.034  13.964  1.00  0.00           C  
ATOM   1276  H   LEU A  83       9.728  37.759  15.302  1.00  0.00           H  
ATOM   1277  HA  LEU A  83      10.247  35.234  14.189  1.00  0.00           H  
ATOM   1278  HB2 LEU A  83      11.254  36.791  16.502  1.00  0.00           H  
ATOM   1279  HB3 LEU A  83      11.585  35.059  16.488  1.00  0.00           H  
ATOM   1280  HG  LEU A  83      12.447  37.084  14.427  1.00  0.00           H  
ATOM   1281 HD11 LEU A  83      13.865  37.271  16.284  1.00  0.00           H  
ATOM   1282 HD12 LEU A  83      14.718  36.205  15.170  1.00  0.00           H  
ATOM   1283 HD13 LEU A  83      13.874  35.530  16.563  1.00  0.00           H  
ATOM   1284 HD21 LEU A  83      13.723  34.601  14.051  1.00  0.00           H  
ATOM   1285 HD22 LEU A  83      12.601  35.423  12.965  1.00  0.00           H  
ATOM   1286 HD23 LEU A  83      11.993  34.276  14.160  1.00  0.00           H  
ATOM   1287  N   SER A  84       9.571  33.432  15.950  1.00  0.00           N  
ATOM   1288  CA  SER A  84       8.837  32.407  16.683  1.00  0.00           C  
ATOM   1289  C   SER A  84       8.998  32.596  18.190  1.00  0.00           C  
ATOM   1290  O   SER A  84       9.939  33.233  18.664  1.00  0.00           O  
ATOM   1291  CB  SER A  84       9.322  31.013  16.279  1.00  0.00           C  
ATOM   1292  OG  SER A  84       8.690  30.580  15.087  1.00  0.00           O  
ATOM   1293  H   SER A  84      10.360  33.174  15.430  1.00  0.00           H  
ATOM   1294  HA  SER A  84       7.791  32.502  16.431  1.00  0.00           H  
ATOM   1295  HB2 SER A  84      10.389  31.040  16.116  1.00  0.00           H  
ATOM   1296  HB3 SER A  84       9.095  30.312  17.069  1.00  0.00           H  
ATOM   1297  HG  SER A  84       7.781  30.889  15.075  1.00  0.00           H  
ATOM   1298  N   PRO A  85       8.058  32.028  18.960  1.00  0.00           N  
ATOM   1299  CA  PRO A  85       8.074  32.120  20.423  1.00  0.00           C  
ATOM   1300  C   PRO A  85       9.209  31.312  21.043  1.00  0.00           C  
ATOM   1301  O   PRO A  85       9.335  31.235  22.266  1.00  0.00           O  
ATOM   1302  CB  PRO A  85       6.718  31.535  20.829  1.00  0.00           C  
ATOM   1303  CG  PRO A  85       6.347  30.626  19.708  1.00  0.00           C  
ATOM   1304  CD  PRO A  85       6.909  31.253  18.462  1.00  0.00           C  
ATOM   1305  HA  PRO A  85       8.139  33.145  20.756  1.00  0.00           H  
ATOM   1306  HB2 PRO A  85       6.820  30.995  21.760  1.00  0.00           H  
ATOM   1307  HB3 PRO A  85       5.999  32.332  20.945  1.00  0.00           H  
ATOM   1308  HG2 PRO A  85       6.782  29.651  19.866  1.00  0.00           H  
ATOM   1309  HG3 PRO A  85       5.271  30.552  19.638  1.00  0.00           H  
ATOM   1310  HD2 PRO A  85       7.230  30.491  17.769  1.00  0.00           H  
ATOM   1311  HD3 PRO A  85       6.178  31.901  18.003  1.00  0.00           H  
ATOM   1312  N   LEU A  86      10.033  30.710  20.192  1.00  0.00           N  
ATOM   1313  CA  LEU A  86      11.160  29.908  20.656  1.00  0.00           C  
ATOM   1314  C   LEU A  86      12.480  30.472  20.141  1.00  0.00           C  
ATOM   1315  O   LEU A  86      13.551  30.109  20.624  1.00  0.00           O  
ATOM   1316  CB  LEU A  86      11.000  28.457  20.201  1.00  0.00           C  
ATOM   1317  CG  LEU A  86      10.505  28.253  18.768  1.00  0.00           C  
ATOM   1318  CD1 LEU A  86      11.008  26.929  18.213  1.00  0.00           C  
ATOM   1319  CD2 LEU A  86       8.986  28.314  18.714  1.00  0.00           C  
ATOM   1320  H   LEU A  86       9.882  30.807  19.229  1.00  0.00           H  
ATOM   1321  HA  LEU A  86      11.166  29.939  21.736  1.00  0.00           H  
ATOM   1322  HB2 LEU A  86      11.960  27.974  20.290  1.00  0.00           H  
ATOM   1323  HB3 LEU A  86      10.295  27.977  20.866  1.00  0.00           H  
ATOM   1324  HG  LEU A  86      10.895  29.046  18.144  1.00  0.00           H  
ATOM   1325 HD11 LEU A  86      11.210  26.251  19.028  1.00  0.00           H  
ATOM   1326 HD12 LEU A  86      11.914  27.097  17.649  1.00  0.00           H  
ATOM   1327 HD13 LEU A  86      10.256  26.502  17.565  1.00  0.00           H  
ATOM   1328 HD21 LEU A  86       8.659  28.247  17.687  1.00  0.00           H  
ATOM   1329 HD22 LEU A  86       8.648  29.247  19.139  1.00  0.00           H  
ATOM   1330 HD23 LEU A  86       8.573  27.489  19.278  1.00  0.00           H  
ATOM   1331  N   GLU A  87      12.392  31.363  19.157  1.00  0.00           N  
ATOM   1332  CA  GLU A  87      13.581  31.978  18.577  1.00  0.00           C  
ATOM   1333  C   GLU A  87      14.096  33.108  19.464  1.00  0.00           C  
ATOM   1334  O   GLU A  87      15.222  33.577  19.299  1.00  0.00           O  
ATOM   1335  CB  GLU A  87      13.273  32.513  17.177  1.00  0.00           C  
ATOM   1336  CG  GLU A  87      13.307  31.445  16.097  1.00  0.00           C  
ATOM   1337  CD  GLU A  87      14.704  31.206  15.557  1.00  0.00           C  
ATOM   1338  OE1 GLU A  87      15.286  32.149  14.980  1.00  0.00           O  
ATOM   1339  OE2 GLU A  87      15.214  30.077  15.710  1.00  0.00           O  
ATOM   1340  H   GLU A  87      11.509  31.611  18.813  1.00  0.00           H  
ATOM   1341  HA  GLU A  87      14.344  31.219  18.503  1.00  0.00           H  
ATOM   1342  HB2 GLU A  87      12.290  32.959  17.183  1.00  0.00           H  
ATOM   1343  HB3 GLU A  87      14.000  33.271  16.927  1.00  0.00           H  
ATOM   1344  HG2 GLU A  87      12.934  30.520  16.511  1.00  0.00           H  
ATOM   1345  HG3 GLU A  87      12.670  31.756  15.282  1.00  0.00           H  
ATOM   1346  N   LEU A  88      13.263  33.541  20.404  1.00  0.00           N  
ATOM   1347  CA  LEU A  88      13.633  34.617  21.317  1.00  0.00           C  
ATOM   1348  C   LEU A  88      14.151  34.056  22.638  1.00  0.00           C  
ATOM   1349  O   LEU A  88      14.600  34.802  23.507  1.00  0.00           O  
ATOM   1350  CB  LEU A  88      12.433  35.530  21.573  1.00  0.00           C  
ATOM   1351  CG  LEU A  88      11.417  35.033  22.602  1.00  0.00           C  
ATOM   1352  CD1 LEU A  88      10.763  36.204  23.317  1.00  0.00           C  
ATOM   1353  CD2 LEU A  88      10.366  34.158  21.934  1.00  0.00           C  
ATOM   1354  H   LEU A  88      12.378  33.128  20.487  1.00  0.00           H  
ATOM   1355  HA  LEU A  88      14.420  35.191  20.852  1.00  0.00           H  
ATOM   1356  HB2 LEU A  88      12.810  36.483  21.915  1.00  0.00           H  
ATOM   1357  HB3 LEU A  88      11.915  35.665  20.634  1.00  0.00           H  
ATOM   1358  HG  LEU A  88      11.930  34.434  23.343  1.00  0.00           H  
ATOM   1359 HD11 LEU A  88      11.078  37.128  22.856  1.00  0.00           H  
ATOM   1360 HD12 LEU A  88      11.056  36.201  24.356  1.00  0.00           H  
ATOM   1361 HD13 LEU A  88       9.689  36.114  23.246  1.00  0.00           H  
ATOM   1362 HD21 LEU A  88      10.702  33.885  20.944  1.00  0.00           H  
ATOM   1363 HD22 LEU A  88       9.437  34.704  21.862  1.00  0.00           H  
ATOM   1364 HD23 LEU A  88      10.215  33.264  22.522  1.00  0.00           H  
ATOM   1365  N   MET A  89      14.085  32.735  22.781  1.00  0.00           N  
ATOM   1366  CA  MET A  89      14.551  32.075  23.995  1.00  0.00           C  
ATOM   1367  C   MET A  89      16.072  31.963  24.004  1.00  0.00           C  
ATOM   1368  O   MET A  89      16.635  31.001  23.484  1.00  0.00           O  
ATOM   1369  CB  MET A  89      13.925  30.684  24.115  1.00  0.00           C  
ATOM   1370  CG  MET A  89      14.459  29.878  25.288  1.00  0.00           C  
ATOM   1371  SD  MET A  89      13.636  28.282  25.465  1.00  0.00           S  
ATOM   1372  CE  MET A  89      14.306  27.398  24.059  1.00  0.00           C  
ATOM   1373  H   MET A  89      13.716  32.193  22.053  1.00  0.00           H  
ATOM   1374  HA  MET A  89      14.240  32.674  24.837  1.00  0.00           H  
ATOM   1375  HB2 MET A  89      12.857  30.791  24.237  1.00  0.00           H  
ATOM   1376  HB3 MET A  89      14.122  30.133  23.207  1.00  0.00           H  
ATOM   1377  HG2 MET A  89      15.514  29.707  25.140  1.00  0.00           H  
ATOM   1378  HG3 MET A  89      14.311  30.446  26.194  1.00  0.00           H  
ATOM   1379  HE1 MET A  89      14.308  28.045  23.194  1.00  0.00           H  
ATOM   1380  HE2 MET A  89      15.315  27.086  24.278  1.00  0.00           H  
ATOM   1381  HE3 MET A  89      13.695  26.530  23.857  1.00  0.00           H  
ATOM   1382  N   GLU A  90      16.730  32.954  24.597  1.00  0.00           N  
ATOM   1383  CA  GLU A  90      18.186  32.966  24.673  1.00  0.00           C  
ATOM   1384  C   GLU A  90      18.663  32.541  26.058  1.00  0.00           C  
ATOM   1385  O   GLU A  90      17.880  32.488  27.006  1.00  0.00           O  
ATOM   1386  CB  GLU A  90      18.725  34.358  24.340  1.00  0.00           C  
ATOM   1387  CG  GLU A  90      18.323  35.423  25.347  1.00  0.00           C  
ATOM   1388  CD  GLU A  90      18.402  36.826  24.776  1.00  0.00           C  
ATOM   1389  OE1 GLU A  90      18.161  36.986  23.561  1.00  0.00           O  
ATOM   1390  OE2 GLU A  90      18.706  37.763  25.544  1.00  0.00           O  
ATOM   1391  H   GLU A  90      16.225  33.694  24.994  1.00  0.00           H  
ATOM   1392  HA  GLU A  90      18.562  32.262  23.945  1.00  0.00           H  
ATOM   1393  HB2 GLU A  90      19.804  34.315  24.303  1.00  0.00           H  
ATOM   1394  HB3 GLU A  90      18.353  34.653  23.370  1.00  0.00           H  
ATOM   1395  HG2 GLU A  90      17.307  35.237  25.662  1.00  0.00           H  
ATOM   1396  HG3 GLU A  90      18.982  35.360  26.200  1.00  0.00           H  
ATOM   1397  N   ALA A  91      19.953  32.241  26.167  1.00  0.00           N  
ATOM   1398  CA  ALA A  91      20.535  31.822  27.436  1.00  0.00           C  
ATOM   1399  C   ALA A  91      19.817  30.599  27.994  1.00  0.00           C  
ATOM   1400  O   ALA A  91      19.533  30.523  29.189  1.00  0.00           O  
ATOM   1401  CB  ALA A  91      20.490  32.966  28.439  1.00  0.00           C  
ATOM   1402  H   ALA A  91      20.527  32.303  25.375  1.00  0.00           H  
ATOM   1403  HA  ALA A  91      21.571  31.571  27.261  1.00  0.00           H  
ATOM   1404  HB1 ALA A  91      19.670  32.809  29.126  1.00  0.00           H  
ATOM   1405  HB2 ALA A  91      21.419  32.998  28.990  1.00  0.00           H  
ATOM   1406  HB3 ALA A  91      20.348  33.899  27.915  1.00  0.00           H  
ATOM   1407  N   SER A  92      19.524  29.641  27.119  1.00  0.00           N  
ATOM   1408  CA  SER A  92      18.835  28.421  27.523  1.00  0.00           C  
ATOM   1409  C   SER A  92      19.765  27.215  27.431  1.00  0.00           C  
ATOM   1410  O   SER A  92      19.903  26.605  26.371  1.00  0.00           O  
ATOM   1411  CB  SER A  92      17.599  28.195  26.650  1.00  0.00           C  
ATOM   1412  OG  SER A  92      16.617  27.442  27.339  1.00  0.00           O  
ATOM   1413  H   SER A  92      19.777  29.758  26.180  1.00  0.00           H  
ATOM   1414  HA  SER A  92      18.522  28.542  28.549  1.00  0.00           H  
ATOM   1415  HB2 SER A  92      17.177  29.150  26.375  1.00  0.00           H  
ATOM   1416  HB3 SER A  92      17.887  27.659  25.756  1.00  0.00           H  
ATOM   1417  HG  SER A  92      16.507  27.795  28.226  1.00  0.00           H  
ATOM   1418  N   GLU A  93      20.399  26.878  28.549  1.00  0.00           N  
ATOM   1419  CA  GLU A  93      21.316  25.745  28.595  1.00  0.00           C  
ATOM   1420  C   GLU A  93      20.644  24.525  29.218  1.00  0.00           C  
ATOM   1421  O   GLU A  93      20.233  24.555  30.379  1.00  0.00           O  
ATOM   1422  CB  GLU A  93      22.573  26.109  29.388  1.00  0.00           C  
ATOM   1423  CG  GLU A  93      23.673  26.722  28.536  1.00  0.00           C  
ATOM   1424  CD  GLU A  93      25.052  26.523  29.135  1.00  0.00           C  
ATOM   1425  OE1 GLU A  93      25.216  26.785  30.345  1.00  0.00           O  
ATOM   1426  OE2 GLU A  93      25.967  26.106  28.393  1.00  0.00           O  
ATOM   1427  H   GLU A  93      20.247  27.403  29.363  1.00  0.00           H  
ATOM   1428  HA  GLU A  93      21.599  25.506  27.581  1.00  0.00           H  
ATOM   1429  HB2 GLU A  93      22.306  26.818  30.157  1.00  0.00           H  
ATOM   1430  HB3 GLU A  93      22.962  25.216  29.852  1.00  0.00           H  
ATOM   1431  HG2 GLU A  93      23.652  26.263  27.560  1.00  0.00           H  
ATOM   1432  HG3 GLU A  93      23.489  27.781  28.439  1.00  0.00           H  
ATOM   1433  N   HIS A  94      20.536  23.453  28.440  1.00  0.00           N  
ATOM   1434  CA  HIS A  94      19.914  22.222  28.914  1.00  0.00           C  
ATOM   1435  C   HIS A  94      20.965  21.144  29.164  1.00  0.00           C  
ATOM   1436  O   HIS A  94      21.482  20.540  28.226  1.00  0.00           O  
ATOM   1437  CB  HIS A  94      18.884  21.723  27.902  1.00  0.00           C  
ATOM   1438  CG  HIS A  94      17.519  22.305  28.099  1.00  0.00           C  
ATOM   1439  ND1 HIS A  94      16.361  21.645  27.748  1.00  0.00           N  
ATOM   1440  CD2 HIS A  94      17.129  23.494  28.617  1.00  0.00           C  
ATOM   1441  CE1 HIS A  94      15.318  22.402  28.039  1.00  0.00           C  
ATOM   1442  NE2 HIS A  94      15.757  23.530  28.568  1.00  0.00           N  
ATOM   1443  H   HIS A  94      20.883  23.492  27.524  1.00  0.00           H  
ATOM   1444  HA  HIS A  94      19.414  22.442  29.845  1.00  0.00           H  
ATOM   1445  HB2 HIS A  94      19.213  21.981  26.905  1.00  0.00           H  
ATOM   1446  HB3 HIS A  94      18.802  20.648  27.981  1.00  0.00           H  
ATOM   1447  HD1 HIS A  94      16.310  20.754  27.344  1.00  0.00           H  
ATOM   1448  HD2 HIS A  94      17.777  24.271  28.997  1.00  0.00           H  
ATOM   1449  HE1 HIS A  94      14.282  22.144  27.875  1.00  0.00           H  
ATOM   1450  HE2 HIS A  94      15.198  24.302  28.795  1.00  0.00           H  
ATOM   1451  N   GLY A  95      21.274  20.910  30.435  1.00  0.00           N  
ATOM   1452  CA  GLY A  95      22.261  19.905  30.784  1.00  0.00           C  
ATOM   1453  C   GLY A  95      21.629  18.596  31.213  1.00  0.00           C  
ATOM   1454  O   GLY A  95      21.446  18.348  32.404  1.00  0.00           O  
ATOM   1455  H   GLY A  95      20.829  21.422  31.141  1.00  0.00           H  
ATOM   1456  HA2 GLY A  95      22.894  19.725  29.928  1.00  0.00           H  
ATOM   1457  HA3 GLY A  95      22.869  20.280  31.595  1.00  0.00           H  
ATOM   1458  N   GLY A  96      21.295  17.754  30.239  1.00  0.00           N  
ATOM   1459  CA  GLY A  96      20.682  16.474  30.542  1.00  0.00           C  
ATOM   1460  C   GLY A  96      20.618  15.562  29.333  1.00  0.00           C  
ATOM   1461  O   GLY A  96      20.567  16.031  28.195  1.00  0.00           O  
ATOM   1462  H   GLY A  96      21.466  18.005  29.307  1.00  0.00           H  
ATOM   1463  HA2 GLY A  96      21.255  15.988  31.317  1.00  0.00           H  
ATOM   1464  HA3 GLY A  96      19.679  16.645  30.903  1.00  0.00           H  
ATOM   1465  N   CYS A  97      20.621  14.257  29.580  1.00  0.00           N  
ATOM   1466  CA  CYS A  97      20.565  13.276  28.501  1.00  0.00           C  
ATOM   1467  C   CYS A  97      19.221  13.332  27.784  1.00  0.00           C  
ATOM   1468  O   CYS A  97      18.238  13.840  28.324  1.00  0.00           O  
ATOM   1469  CB  CYS A  97      20.805  11.869  29.051  1.00  0.00           C  
ATOM   1470  SG  CYS A  97      19.545  11.309  30.221  1.00  0.00           S  
ATOM   1471  H   CYS A  97      20.662  13.945  30.507  1.00  0.00           H  
ATOM   1472  HA  CYS A  97      21.346  13.515  27.795  1.00  0.00           H  
ATOM   1473  HB2 CYS A  97      20.822  11.167  28.229  1.00  0.00           H  
ATOM   1474  HB3 CYS A  97      21.758  11.846  29.556  1.00  0.00           H  
ATOM   1475  HG  CYS A  97      18.809  10.388  29.621  1.00  0.00           H  
ATOM   1476  N   SER A  98      19.185  12.810  26.562  1.00  0.00           N  
ATOM   1477  CA  SER A  98      17.961  12.805  25.767  1.00  0.00           C  
ATOM   1478  C   SER A  98      17.745  11.445  25.111  1.00  0.00           C  
ATOM   1479  O   SER A  98      18.668  10.637  25.008  1.00  0.00           O  
ATOM   1480  CB  SER A  98      18.020  13.897  24.697  1.00  0.00           C  
ATOM   1481  OG  SER A  98      18.103  15.184  25.285  1.00  0.00           O  
ATOM   1482  H   SER A  98      20.001  12.419  26.185  1.00  0.00           H  
ATOM   1483  HA  SER A  98      17.135  13.007  26.431  1.00  0.00           H  
ATOM   1484  HB2 SER A  98      18.890  13.742  24.076  1.00  0.00           H  
ATOM   1485  HB3 SER A  98      17.129  13.849  24.089  1.00  0.00           H  
ATOM   1486  HG  SER A  98      17.679  15.170  26.146  1.00  0.00           H  
ATOM   1487  N   THR A  99      16.516  11.198  24.667  1.00  0.00           N  
ATOM   1488  CA  THR A  99      16.175   9.937  24.023  1.00  0.00           C  
ATOM   1489  C   THR A  99      16.060  10.105  22.512  1.00  0.00           C  
ATOM   1490  O   THR A  99      15.554  11.111  22.012  1.00  0.00           O  
ATOM   1491  CB  THR A  99      14.851   9.367  24.567  1.00  0.00           C  
ATOM   1492  OG1 THR A  99      14.598   8.081  23.989  1.00  0.00           O  
ATOM   1493  CG2 THR A  99      13.693  10.304  24.261  1.00  0.00           C  
ATOM   1494  H   THR A  99      15.822  11.882  24.778  1.00  0.00           H  
ATOM   1495  HA  THR A  99      16.963   9.230  24.237  1.00  0.00           H  
ATOM   1496  HB  THR A  99      14.937   9.261  25.639  1.00  0.00           H  
ATOM   1497  HG1 THR A  99      13.651   7.922  23.967  1.00  0.00           H  
ATOM   1498 HG21 THR A  99      12.984   9.803  23.618  1.00  0.00           H  
ATOM   1499 HG22 THR A  99      14.066  11.189  23.767  1.00  0.00           H  
ATOM   1500 HG23 THR A  99      13.205  10.585  25.183  1.00  0.00           H  
ATOM   1501  N   PRO A 100      16.537   9.099  21.765  1.00  0.00           N  
ATOM   1502  CA  PRO A 100      16.497   9.112  20.300  1.00  0.00           C  
ATOM   1503  C   PRO A 100      15.079   8.973  19.757  1.00  0.00           C  
ATOM   1504  O   PRO A 100      14.307   8.133  20.219  1.00  0.00           O  
ATOM   1505  CB  PRO A 100      17.341   7.896  19.911  1.00  0.00           C  
ATOM   1506  CG  PRO A 100      17.252   6.983  21.083  1.00  0.00           C  
ATOM   1507  CD  PRO A 100      17.152   7.870  22.294  1.00  0.00           C  
ATOM   1508  HA  PRO A 100      16.947  10.008  19.899  1.00  0.00           H  
ATOM   1509  HB2 PRO A 100      16.931   7.440  19.021  1.00  0.00           H  
ATOM   1510  HB3 PRO A 100      18.360   8.205  19.726  1.00  0.00           H  
ATOM   1511  HG2 PRO A 100      16.372   6.362  21.000  1.00  0.00           H  
ATOM   1512  HG3 PRO A 100      18.141   6.371  21.140  1.00  0.00           H  
ATOM   1513  HD2 PRO A 100      16.523   7.416  23.044  1.00  0.00           H  
ATOM   1514  HD3 PRO A 100      18.135   8.073  22.694  1.00  0.00           H  
ATOM   1515  N   GLY A 101      14.742   9.800  18.773  1.00  0.00           N  
ATOM   1516  CA  GLY A 101      13.417   9.751  18.183  1.00  0.00           C  
ATOM   1517  C   GLY A 101      13.421   9.143  16.795  1.00  0.00           C  
ATOM   1518  O   GLY A 101      13.060   9.802  15.820  1.00  0.00           O  
ATOM   1519  H   GLY A 101      15.399  10.449  18.444  1.00  0.00           H  
ATOM   1520  HA2 GLY A 101      12.773   9.164  18.821  1.00  0.00           H  
ATOM   1521  HA3 GLY A 101      13.025  10.756  18.122  1.00  0.00           H  
ATOM   1522  N   SER A 102      13.834   7.883  16.704  1.00  0.00           N  
ATOM   1523  CA  SER A 102      13.890   7.187  15.424  1.00  0.00           C  
ATOM   1524  C   SER A 102      13.859   5.675  15.624  1.00  0.00           C  
ATOM   1525  O   SER A 102      14.347   5.161  16.630  1.00  0.00           O  
ATOM   1526  CB  SER A 102      15.154   7.585  14.658  1.00  0.00           C  
ATOM   1527  OG  SER A 102      14.937   8.752  13.885  1.00  0.00           O  
ATOM   1528  H   SER A 102      14.110   7.411  17.517  1.00  0.00           H  
ATOM   1529  HA  SER A 102      13.025   7.481  14.849  1.00  0.00           H  
ATOM   1530  HB2 SER A 102      15.952   7.776  15.361  1.00  0.00           H  
ATOM   1531  HB3 SER A 102      15.441   6.779  13.999  1.00  0.00           H  
ATOM   1532  HG  SER A 102      14.596   9.450  14.448  1.00  0.00           H  
ATOM   1533  N   GLY A 103      13.278   4.968  14.660  1.00  0.00           N  
ATOM   1534  CA  GLY A 103      13.192   3.522  14.749  1.00  0.00           C  
ATOM   1535  C   GLY A 103      12.008   2.965  13.983  1.00  0.00           C  
ATOM   1536  O   GLY A 103      10.943   2.711  14.545  1.00  0.00           O  
ATOM   1537  H   GLY A 103      12.906   5.433  13.881  1.00  0.00           H  
ATOM   1538  HA2 GLY A 103      14.100   3.093  14.351  1.00  0.00           H  
ATOM   1539  HA3 GLY A 103      13.099   3.242  15.788  1.00  0.00           H  
ATOM   1540  N   PRO A 104      12.189   2.765  12.669  1.00  0.00           N  
ATOM   1541  CA  PRO A 104      11.138   2.232  11.798  1.00  0.00           C  
ATOM   1542  C   PRO A 104      10.841   0.763  12.080  1.00  0.00           C  
ATOM   1543  O   PRO A 104      11.520   0.126  12.884  1.00  0.00           O  
ATOM   1544  CB  PRO A 104      11.724   2.399  10.393  1.00  0.00           C  
ATOM   1545  CG  PRO A 104      13.200   2.399  10.595  1.00  0.00           C  
ATOM   1546  CD  PRO A 104      13.434   3.044  11.934  1.00  0.00           C  
ATOM   1547  HA  PRO A 104      10.225   2.805  11.880  1.00  0.00           H  
ATOM   1548  HB2 PRO A 104      11.409   1.574   9.769  1.00  0.00           H  
ATOM   1549  HB3 PRO A 104      11.383   3.331   9.967  1.00  0.00           H  
ATOM   1550  HG2 PRO A 104      13.570   1.386  10.597  1.00  0.00           H  
ATOM   1551  HG3 PRO A 104      13.676   2.974   9.815  1.00  0.00           H  
ATOM   1552  HD2 PRO A 104      14.283   2.593  12.426  1.00  0.00           H  
ATOM   1553  HD3 PRO A 104      13.583   4.107  11.820  1.00  0.00           H  
ATOM   1554  N   SER A 105       9.822   0.231  11.411  1.00  0.00           N  
ATOM   1555  CA  SER A 105       9.433  -1.163  11.593  1.00  0.00           C  
ATOM   1556  C   SER A 105       9.177  -1.834  10.247  1.00  0.00           C  
ATOM   1557  O   SER A 105       8.550  -1.255   9.361  1.00  0.00           O  
ATOM   1558  CB  SER A 105       8.182  -1.255  12.468  1.00  0.00           C  
ATOM   1559  OG  SER A 105       7.051  -0.725  11.799  1.00  0.00           O  
ATOM   1560  H   SER A 105       9.319   0.791  10.784  1.00  0.00           H  
ATOM   1561  HA  SER A 105      10.247  -1.672  12.087  1.00  0.00           H  
ATOM   1562  HB2 SER A 105       7.990  -2.290  12.710  1.00  0.00           H  
ATOM   1563  HB3 SER A 105       8.341  -0.696  13.379  1.00  0.00           H  
ATOM   1564  HG  SER A 105       6.435  -1.433  11.601  1.00  0.00           H  
ATOM   1565  N   SER A 106       9.669  -3.061  10.103  1.00  0.00           N  
ATOM   1566  CA  SER A 106       9.497  -3.812   8.865  1.00  0.00           C  
ATOM   1567  C   SER A 106       9.727  -5.302   9.096  1.00  0.00           C  
ATOM   1568  O   SER A 106      10.428  -5.696  10.028  1.00  0.00           O  
ATOM   1569  CB  SER A 106      10.460  -3.296   7.793  1.00  0.00           C  
ATOM   1570  OG  SER A 106      10.275  -3.984   6.568  1.00  0.00           O  
ATOM   1571  H   SER A 106      10.160  -3.469  10.846  1.00  0.00           H  
ATOM   1572  HA  SER A 106       8.482  -3.665   8.525  1.00  0.00           H  
ATOM   1573  HB2 SER A 106      10.284  -2.244   7.632  1.00  0.00           H  
ATOM   1574  HB3 SER A 106      11.477  -3.445   8.126  1.00  0.00           H  
ATOM   1575  HG  SER A 106      11.073  -3.917   6.039  1.00  0.00           H  
ATOM   1576  N   GLY A 107       9.131  -6.128   8.241  1.00  0.00           N  
ATOM   1577  CA  GLY A 107       9.282  -7.565   8.369  1.00  0.00           C  
ATOM   1578  C   GLY A 107       8.609  -8.321   7.241  1.00  0.00           C  
ATOM   1579  O   GLY A 107       8.614  -9.552   7.220  1.00  0.00           O  
ATOM   1580  H   GLY A 107       8.583  -5.756   7.518  1.00  0.00           H  
ATOM   1581  HA2 GLY A 107      10.334  -7.806   8.374  1.00  0.00           H  
ATOM   1582  HA3 GLY A 107       8.847  -7.879   9.307  1.00  0.00           H  
TER    1583      GLY A 107                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
