
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 ( 1462),  selected   88 , name 2eqm_A
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 2eqm_A.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    K    10_A      -       -           -
LGA    K    11_A      M     156          5.249
LGA    P    12_A      V     157          2.911
LGA    P    13_A      -       -           -
LGA    N    14_A      -       -           -
LGA    R    15_A      -       -           -
LGA    P    16_A      -       -           -
LGA    G    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    T    19_A      L     158          4.542
LGA    F    20_A      L     159          1.598
LGA    E    21_A      K     160          1.637
LGA    I    22_A      S     161          1.632
LGA    G    23_A      G     162          1.243
LGA    A    24_A      Q     163          0.740
LGA    R    25_A      L     164          0.435
LGA    L    26_A      I     165          0.154
LGA    E    27_A      K     166          0.469
LGA    A    28_A      T     167          0.334
LGA    L    29_A      E     168          0.381
LGA    D    30_A      W     169          0.285
LGA    Y    31_A      E     170          2.741
LGA    L    32_A      -       -           -
LGA    Q    33_A      G     171          0.485
LGA    K    34_A      T     172          0.946
LGA    W    35_A      W     173          0.757
LGA    Y    36_A      W     174          0.879
LGA    P    37_A      K     175          0.707
LGA    S    38_A      S     176          0.503
LGA    R    39_A      R     177          0.744
LGA    I    40_A      V     178          0.677
LGA    E    41_A      E     179          0.755
LGA    K    42_A      E     180          0.698
LGA    I    43_A      V     181          0.913
LGA    D    44_A      D     182          1.282
LGA    Y    45_A      G     183          1.008
LGA    E    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    G    48_A      S     184          2.099
LGA    K    49_A      L     185          1.444
LGA    M    50_A      V     186          0.879
LGA    L    51_A      R     187          0.570
LGA    V    52_A      I     188          0.420
LGA    H    53_A      L     189          0.217
LGA    F    54_A      F     190          0.237
LGA    E    55_A      L     191          1.333
LGA    R    56_A      D     192          2.160
LGA    W    57_A      D     193          1.258
LGA    S    58_A      -       -           -
LGA    H    59_A      -       -           -
LGA    R    60_A      K     194          2.032
LGA    Y    61_A      R     195          0.734
LGA    D    62_A      C     196          0.926
LGA    E    63_A      E     197          1.031
LGA    W    64_A      W     198          0.877
LGA    I    65_A      I     199          1.163
LGA    Y    66_A      Y     200          1.109
LGA    W    67_A      R     201          1.007
LGA    D    68_A      G     202          1.432
LGA    S    69_A      S     203          1.053
LGA    N    70_A      T     204          1.552
LGA    R    71_A      R     205          1.283
LGA    L    72_A      L     206          1.606
LGA    R    73_A      E     207          1.431
LGA    P    74_A      P     208          4.219
LGA    L    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    R    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    A    79_A      -       -           -
LGA    L    80_A      -       -           -
LGA    R    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    K    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    E    88_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   53    5.0     53    1.63    28.30     94.331     3.070

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.500743 * X  +   0.647805 * Y  +  -0.574112 * Z  +   6.134658
  Y_new =   0.150875 * X  +   0.718423 * Y  +   0.679047 * Z  +  51.785442
  Z_new =   0.852346 * X  +   0.253409 * Y  +  -0.457483 * Z  +  16.604750 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.635746   -0.505847  [ DEG:   151.0171    -28.9829 ]
  Theta =  -1.020454   -2.121139  [ DEG:   -58.4677   -121.5323 ]
  Phi   =   2.848941   -0.292651  [ DEG:   163.2323    -16.7677 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eqm_A                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eqm_A.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   53   5.0   53   1.63   28.30  94.331
REMARK  ---------------------------------------------------------- 
MOLECULE 2eqm_A
HEADER    TRANSCRIPTION                           30-MAR-07   2EQM              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 20-LIKE 1 [HOMO SAPIENS]                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 20-LIKE 1;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF20L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060911-19;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN,PHD FINGER PROTEIN 20-LIKE 1, HOMO                  
KEYWDS   2 SAPIENS, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON            
KEYWDS   3 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   4 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,                     
KEYWDS   5 TRANSCRIPTION                                                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   02-OCT-07 2EQM    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 20-LIKE 1 [HOMO SAPIENS]                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQM A    8    88  UNP    Q96BT0   Q96BT0_HUMAN     1     81             
SEQRES   1 A   88  GLY SER SER GLY SER SER GLY MET SER LYS LYS PRO PRO          
SEQRES   2 A   88  ASN ARG PRO GLY ILE THR PHE GLU ILE GLY ALA ARG LEU          
SEQRES   3 A   88  GLU ALA LEU ASP TYR LEU GLN LYS TRP TYR PRO SER ARG          
SEQRES   4 A   88  ILE GLU LYS ILE ASP TYR GLU GLU GLY LYS MET LEU VAL          
SEQRES   5 A   88  HIS PHE GLU ARG TRP SER HIS ARG TYR ASP GLU TRP ILE          
SEQRES   6 A   88  TYR TRP ASP SER ASN ARG LEU ARG PRO LEU GLU ARG PRO          
SEQRES   7 A   88  ALA LEU ARG LYS GLU GLY LEU LYS ASP GLU                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       3.857  70.523  -5.466  1.00  0.00           N  
ATOM      2  CA  GLY A   1       4.202  69.789  -4.263  1.00  0.00           C  
ATOM      3  C   GLY A   1       3.947  70.589  -3.001  1.00  0.00           C  
ATOM      4  O   GLY A   1       3.776  71.807  -3.056  1.00  0.00           O  
ATOM      5  H1  GLY A   1       3.126  71.175  -5.447  1.00  0.00           H  
ATOM      6  HA2 GLY A   1       3.617  68.882  -4.226  1.00  0.00           H  
ATOM      7  HA3 GLY A   1       5.250  69.526  -4.303  1.00  0.00           H  
ATOM      8  N   SER A   2       3.921  69.904  -1.863  1.00  0.00           N  
ATOM      9  CA  SER A   2       3.680  70.560  -0.583  1.00  0.00           C  
ATOM     10  C   SER A   2       4.450  69.865   0.537  1.00  0.00           C  
ATOM     11  O   SER A   2       4.317  68.658   0.740  1.00  0.00           O  
ATOM     12  CB  SER A   2       2.184  70.562  -0.262  1.00  0.00           C  
ATOM     13  OG  SER A   2       1.903  71.390   0.855  1.00  0.00           O  
ATOM     14  H   SER A   2       4.066  68.935  -1.885  1.00  0.00           H  
ATOM     15  HA  SER A   2       4.024  71.580  -0.662  1.00  0.00           H  
ATOM     16  HB2 SER A   2       1.636  70.932  -1.115  1.00  0.00           H  
ATOM     17  HB3 SER A   2       1.865  69.554  -0.038  1.00  0.00           H  
ATOM     18  HG  SER A   2       2.583  72.063   0.933  1.00  0.00           H  
ATOM     19  N   SER A   3       5.256  70.637   1.259  1.00  0.00           N  
ATOM     20  CA  SER A   3       6.051  70.097   2.355  1.00  0.00           C  
ATOM     21  C   SER A   3       5.533  70.597   3.700  1.00  0.00           C  
ATOM     22  O   SER A   3       5.142  71.756   3.835  1.00  0.00           O  
ATOM     23  CB  SER A   3       7.521  70.484   2.186  1.00  0.00           C  
ATOM     24  OG  SER A   3       7.694  71.888   2.284  1.00  0.00           O  
ATOM     25  H   SER A   3       5.319  71.591   1.047  1.00  0.00           H  
ATOM     26  HA  SER A   3       5.966  69.021   2.328  1.00  0.00           H  
ATOM     27  HB2 SER A   3       8.108  70.008   2.956  1.00  0.00           H  
ATOM     28  HB3 SER A   3       7.868  70.158   1.215  1.00  0.00           H  
ATOM     29  HG  SER A   3       8.629  72.092   2.355  1.00  0.00           H  
ATOM     30  N   GLY A   4       5.534  69.713   4.693  1.00  0.00           N  
ATOM     31  CA  GLY A   4       5.062  70.083   6.015  1.00  0.00           C  
ATOM     32  C   GLY A   4       6.091  69.814   7.095  1.00  0.00           C  
ATOM     33  O   GLY A   4       7.141  70.456   7.134  1.00  0.00           O  
ATOM     34  H   GLY A   4       5.858  68.803   4.527  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       4.819  71.135   6.017  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       4.168  69.518   6.237  1.00  0.00           H  
ATOM     37  N   SER A   5       5.791  68.863   7.973  1.00  0.00           N  
ATOM     38  CA  SER A   5       6.696  68.514   9.062  1.00  0.00           C  
ATOM     39  C   SER A   5       7.296  69.767   9.693  1.00  0.00           C  
ATOM     40  O   SER A   5       8.492  69.822   9.975  1.00  0.00           O  
ATOM     41  CB  SER A   5       7.813  67.601   8.553  1.00  0.00           C  
ATOM     42  OG  SER A   5       7.284  66.412   7.993  1.00  0.00           O  
ATOM     43  H   SER A   5       4.938  68.387   7.889  1.00  0.00           H  
ATOM     44  HA  SER A   5       6.124  67.986   9.811  1.00  0.00           H  
ATOM     45  HB2 SER A   5       8.380  68.120   7.795  1.00  0.00           H  
ATOM     46  HB3 SER A   5       8.463  67.340   9.374  1.00  0.00           H  
ATOM     47  HG  SER A   5       7.113  66.546   7.058  1.00  0.00           H  
ATOM     48  N   SER A   6       6.454  70.774   9.910  1.00  0.00           N  
ATOM     49  CA  SER A   6       6.900  72.028  10.504  1.00  0.00           C  
ATOM     50  C   SER A   6       6.305  72.212  11.897  1.00  0.00           C  
ATOM     51  O   SER A   6       6.946  72.761  12.791  1.00  0.00           O  
ATOM     52  CB  SER A   6       6.510  73.206   9.610  1.00  0.00           C  
ATOM     53  OG  SER A   6       7.055  74.420  10.099  1.00  0.00           O  
ATOM     54  H   SER A   6       5.510  70.669   9.664  1.00  0.00           H  
ATOM     55  HA  SER A   6       7.976  71.991  10.588  1.00  0.00           H  
ATOM     56  HB2 SER A   6       6.882  73.036   8.612  1.00  0.00           H  
ATOM     57  HB3 SER A   6       5.433  73.294   9.584  1.00  0.00           H  
ATOM     58  HG  SER A   6       7.118  75.054   9.382  1.00  0.00           H  
ATOM     59  N   GLY A   7       5.071  71.748  12.072  1.00  0.00           N  
ATOM     60  CA  GLY A   7       4.408  71.872  13.357  1.00  0.00           C  
ATOM     61  C   GLY A   7       5.009  70.961  14.409  1.00  0.00           C  
ATOM     62  O   GLY A   7       4.493  69.874  14.667  1.00  0.00           O  
ATOM     63  H   GLY A   7       4.607  71.320  11.323  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       4.487  72.895  13.694  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       3.363  71.622  13.236  1.00  0.00           H  
ATOM     66  N   MET A   8       6.104  71.405  15.018  1.00  0.00           N  
ATOM     67  CA  MET A   8       6.776  70.622  16.048  1.00  0.00           C  
ATOM     68  C   MET A   8       6.889  69.158  15.631  1.00  0.00           C  
ATOM     69  O   MET A   8       6.504  68.259  16.378  1.00  0.00           O  
ATOM     70  CB  MET A   8       6.022  70.728  17.374  1.00  0.00           C  
ATOM     71  CG  MET A   8       6.120  72.102  18.020  1.00  0.00           C  
ATOM     72  SD  MET A   8       7.701  72.371  18.844  1.00  0.00           S  
ATOM     73  CE  MET A   8       8.587  73.286  17.586  1.00  0.00           C  
ATOM     74  H   MET A   8       6.468  72.280  14.770  1.00  0.00           H  
ATOM     75  HA  MET A   8       7.769  71.025  16.175  1.00  0.00           H  
ATOM     76  HB2 MET A   8       4.979  70.511  17.201  1.00  0.00           H  
ATOM     77  HB3 MET A   8       6.424  70.002  18.064  1.00  0.00           H  
ATOM     78  HG2 MET A   8       5.997  72.854  17.255  1.00  0.00           H  
ATOM     79  HG3 MET A   8       5.328  72.199  18.748  1.00  0.00           H  
ATOM     80  HE1 MET A   8       9.631  73.007  17.606  1.00  0.00           H  
ATOM     81  HE2 MET A   8       8.172  73.059  16.615  1.00  0.00           H  
ATOM     82  HE3 MET A   8       8.494  74.345  17.779  1.00  0.00           H  
ATOM     83  N   SER A   9       7.420  68.928  14.433  1.00  0.00           N  
ATOM     84  CA  SER A   9       7.580  67.575  13.916  1.00  0.00           C  
ATOM     85  C   SER A   9       7.956  66.607  15.034  1.00  0.00           C  
ATOM     86  O   SER A   9       7.388  65.520  15.148  1.00  0.00           O  
ATOM     87  CB  SER A   9       8.647  67.547  12.821  1.00  0.00           C  
ATOM     88  OG  SER A   9       9.850  68.148  13.267  1.00  0.00           O  
ATOM     89  H   SER A   9       7.708  69.687  13.885  1.00  0.00           H  
ATOM     90  HA  SER A   9       6.635  67.267  13.494  1.00  0.00           H  
ATOM     91  HB2 SER A   9       8.850  66.524  12.546  1.00  0.00           H  
ATOM     92  HB3 SER A   9       8.286  68.088  11.957  1.00  0.00           H  
ATOM     93  HG  SER A   9       9.721  69.095  13.359  1.00  0.00           H  
ATOM     94  N   LYS A  10       8.919  67.009  15.857  1.00  0.00           N  
ATOM     95  CA  LYS A  10       9.373  66.180  16.966  1.00  0.00           C  
ATOM     96  C   LYS A  10       8.215  65.382  17.559  1.00  0.00           C  
ATOM     97  O   LYS A  10       8.102  64.176  17.341  1.00  0.00           O  
ATOM     98  CB  LYS A  10      10.015  67.049  18.050  1.00  0.00           C  
ATOM     99  CG  LYS A  10      11.179  67.886  17.548  1.00  0.00           C  
ATOM    100  CD  LYS A  10      12.368  67.019  17.169  1.00  0.00           C  
ATOM    101  CE  LYS A  10      13.275  67.722  16.171  1.00  0.00           C  
ATOM    102  NZ  LYS A  10      14.255  68.617  16.847  1.00  0.00           N  
ATOM    103  H   LYS A  10       9.334  67.886  15.714  1.00  0.00           H  
ATOM    104  HA  LYS A  10      10.111  65.490  16.585  1.00  0.00           H  
ATOM    105  HB2 LYS A  10       9.266  67.716  18.451  1.00  0.00           H  
ATOM    106  HB3 LYS A  10      10.375  66.409  18.842  1.00  0.00           H  
ATOM    107  HG2 LYS A  10      10.861  68.443  16.678  1.00  0.00           H  
ATOM    108  HG3 LYS A  10      11.479  68.573  18.327  1.00  0.00           H  
ATOM    109  HD2 LYS A  10      12.935  66.794  18.058  1.00  0.00           H  
ATOM    110  HD3 LYS A  10      12.006  66.101  16.728  1.00  0.00           H  
ATOM    111  HE2 LYS A  10      13.812  66.977  15.606  1.00  0.00           H  
ATOM    112  HE3 LYS A  10      12.664  68.311  15.502  1.00  0.00           H  
ATOM    113  HZ1 LYS A  10      13.982  68.759  17.841  1.00  0.00           H  
ATOM    114  HZ2 LYS A  10      14.282  69.542  16.371  1.00  0.00           H  
ATOM    115  HZ3 LYS A  10      15.204  68.196  16.815  1.00  0.00           H  
ATOM    116  N   LYS A  11       7.357  66.065  18.309  1.00  0.00           N  
ATOM    117  CA  LYS A  11       6.206  65.421  18.932  1.00  0.00           C  
ATOM    118  C   LYS A  11       5.336  64.730  17.885  1.00  0.00           C  
ATOM    119  O   LYS A  11       5.333  65.093  16.709  1.00  0.00           O  
ATOM    120  CB  LYS A  11       5.374  66.451  19.702  1.00  0.00           C  
ATOM    121  CG  LYS A  11       4.297  67.113  18.861  1.00  0.00           C  
ATOM    122  CD  LYS A  11       3.638  68.263  19.606  1.00  0.00           C  
ATOM    123  CE  LYS A  11       2.457  67.785  20.436  1.00  0.00           C  
ATOM    124  NZ  LYS A  11       1.897  68.875  21.282  1.00  0.00           N  
ATOM    125  H   LYS A  11       7.499  67.025  18.447  1.00  0.00           H  
ATOM    126  HA  LYS A  11       6.574  64.678  19.623  1.00  0.00           H  
ATOM    127  HB2 LYS A  11       4.898  65.959  20.537  1.00  0.00           H  
ATOM    128  HB3 LYS A  11       6.034  67.220  20.075  1.00  0.00           H  
ATOM    129  HG2 LYS A  11       4.743  67.494  17.955  1.00  0.00           H  
ATOM    130  HG3 LYS A  11       3.544  66.379  18.613  1.00  0.00           H  
ATOM    131  HD2 LYS A  11       4.364  68.718  20.263  1.00  0.00           H  
ATOM    132  HD3 LYS A  11       3.291  68.993  18.888  1.00  0.00           H  
ATOM    133  HE2 LYS A  11       1.687  67.427  19.770  1.00  0.00           H  
ATOM    134  HE3 LYS A  11       2.785  66.978  21.074  1.00  0.00           H  
ATOM    135  HZ1 LYS A  11       0.870  68.753  21.389  1.00  0.00           H  
ATOM    136  HZ2 LYS A  11       2.083  69.800  20.843  1.00  0.00           H  
ATOM    137  HZ3 LYS A  11       2.338  68.858  22.224  1.00  0.00           H  
ATOM    138  N   PRO A  12       4.579  63.713  18.322  1.00  0.00           N  
ATOM    139  CA  PRO A  12       3.690  62.952  17.438  1.00  0.00           C  
ATOM    140  C   PRO A  12       2.492  63.774  16.976  1.00  0.00           C  
ATOM    141  O   PRO A  12       1.594  64.099  17.753  1.00  0.00           O  
ATOM    142  CB  PRO A  12       3.232  61.785  18.316  1.00  0.00           C  
ATOM    143  CG  PRO A  12       3.357  62.290  19.713  1.00  0.00           C  
ATOM    144  CD  PRO A  12       4.533  63.227  19.711  1.00  0.00           C  
ATOM    145  HA  PRO A  12       4.218  62.571  16.577  1.00  0.00           H  
ATOM    146  HB2 PRO A  12       2.209  61.532  18.077  1.00  0.00           H  
ATOM    147  HB3 PRO A  12       3.869  60.930  18.147  1.00  0.00           H  
ATOM    148  HG2 PRO A  12       2.457  62.817  19.995  1.00  0.00           H  
ATOM    149  HG3 PRO A  12       3.536  61.465  20.386  1.00  0.00           H  
ATOM    150  HD2 PRO A  12       4.367  64.042  20.400  1.00  0.00           H  
ATOM    151  HD3 PRO A  12       5.438  62.696  19.963  1.00  0.00           H  
ATOM    152  N   PRO A  13       2.475  64.118  15.679  1.00  0.00           N  
ATOM    153  CA  PRO A  13       1.391  64.904  15.083  1.00  0.00           C  
ATOM    154  C   PRO A  13       0.087  64.120  14.993  1.00  0.00           C  
ATOM    155  O   PRO A  13       0.057  62.916  15.243  1.00  0.00           O  
ATOM    156  CB  PRO A  13       1.917  65.229  13.683  1.00  0.00           C  
ATOM    157  CG  PRO A  13       2.886  64.139  13.380  1.00  0.00           C  
ATOM    158  CD  PRO A  13       3.511  63.764  14.695  1.00  0.00           C  
ATOM    159  HA  PRO A  13       1.221  65.821  15.627  1.00  0.00           H  
ATOM    160  HB2 PRO A  13       1.095  65.236  12.980  1.00  0.00           H  
ATOM    161  HB3 PRO A  13       2.399  66.195  13.691  1.00  0.00           H  
ATOM    162  HG2 PRO A  13       2.367  63.293  12.956  1.00  0.00           H  
ATOM    163  HG3 PRO A  13       3.640  64.499  12.695  1.00  0.00           H  
ATOM    164  HD2 PRO A  13       3.725  62.706  14.723  1.00  0.00           H  
ATOM    165  HD3 PRO A  13       4.411  64.337  14.862  1.00  0.00           H  
ATOM    166  N   ASN A  14      -0.991  64.810  14.634  1.00  0.00           N  
ATOM    167  CA  ASN A  14      -2.299  64.177  14.511  1.00  0.00           C  
ATOM    168  C   ASN A  14      -2.211  62.903  13.678  1.00  0.00           C  
ATOM    169  O   ASN A  14      -2.188  62.953  12.448  1.00  0.00           O  
ATOM    170  CB  ASN A  14      -3.299  65.146  13.877  1.00  0.00           C  
ATOM    171  CG  ASN A  14      -4.663  64.514  13.669  1.00  0.00           C  
ATOM    172  OD1 ASN A  14      -4.946  63.958  12.607  1.00  0.00           O  
ATOM    173  ND2 ASN A  14      -5.514  64.598  14.684  1.00  0.00           N  
ATOM    174  H   ASN A  14      -0.905  65.769  14.447  1.00  0.00           H  
ATOM    175  HA  ASN A  14      -2.638  63.923  15.504  1.00  0.00           H  
ATOM    176  HB2 ASN A  14      -3.418  66.005  14.522  1.00  0.00           H  
ATOM    177  HB3 ASN A  14      -2.922  65.468  12.919  1.00  0.00           H  
ATOM    178 HD21 ASN A  14      -5.221  65.057  15.499  1.00  0.00           H  
ATOM    179 HD22 ASN A  14      -6.402  64.198  14.577  1.00  0.00           H  
ATOM    180  N   ARG A  15      -2.160  61.761  14.357  1.00  0.00           N  
ATOM    181  CA  ARG A  15      -2.073  60.473  13.680  1.00  0.00           C  
ATOM    182  C   ARG A  15      -3.040  59.467  14.299  1.00  0.00           C  
ATOM    183  O   ARG A  15      -2.773  58.876  15.345  1.00  0.00           O  
ATOM    184  CB  ARG A  15      -0.645  59.932  13.749  1.00  0.00           C  
ATOM    185  CG  ARG A  15      -0.274  59.038  12.577  1.00  0.00           C  
ATOM    186  CD  ARG A  15       1.208  59.132  12.250  1.00  0.00           C  
ATOM    187  NE  ARG A  15       1.519  60.315  11.454  1.00  0.00           N  
ATOM    188  CZ  ARG A  15       2.749  60.793  11.297  1.00  0.00           C  
ATOM    189  NH1 ARG A  15       3.777  60.191  11.878  1.00  0.00           N  
ATOM    190  NH2 ARG A  15       2.952  61.875  10.556  1.00  0.00           N  
ATOM    191  H   ARG A  15      -2.181  61.786  15.337  1.00  0.00           H  
ATOM    192  HA  ARG A  15      -2.342  60.623  12.645  1.00  0.00           H  
ATOM    193  HB2 ARG A  15       0.044  60.764  13.769  1.00  0.00           H  
ATOM    194  HB3 ARG A  15      -0.532  59.361  14.658  1.00  0.00           H  
ATOM    195  HG2 ARG A  15      -0.512  58.014  12.827  1.00  0.00           H  
ATOM    196  HG3 ARG A  15      -0.845  59.341  11.712  1.00  0.00           H  
ATOM    197  HD2 ARG A  15       1.764  59.177  13.176  1.00  0.00           H  
ATOM    198  HD3 ARG A  15       1.498  58.251  11.698  1.00  0.00           H  
ATOM    199  HE  ARG A  15       0.774  60.776  11.015  1.00  0.00           H  
ATOM    200 HH11 ARG A  15       3.628  59.375  12.436  1.00  0.00           H  
ATOM    201 HH12 ARG A  15       4.702  60.551  11.757  1.00  0.00           H  
ATOM    202 HH21 ARG A  15       2.180  62.332  10.115  1.00  0.00           H  
ATOM    203 HH22 ARG A  15       3.877  62.233  10.437  1.00  0.00           H  
ATOM    204  N   PRO A  16      -4.190  59.269  13.639  1.00  0.00           N  
ATOM    205  CA  PRO A  16      -5.220  58.334  14.106  1.00  0.00           C  
ATOM    206  C   PRO A  16      -4.782  56.879  13.980  1.00  0.00           C  
ATOM    207  O   PRO A  16      -5.161  56.186  13.037  1.00  0.00           O  
ATOM    208  CB  PRO A  16      -6.404  58.620  13.178  1.00  0.00           C  
ATOM    209  CG  PRO A  16      -5.789  59.174  11.939  1.00  0.00           C  
ATOM    210  CD  PRO A  16      -4.575  59.939  12.386  1.00  0.00           C  
ATOM    211  HA  PRO A  16      -5.505  58.537  15.127  1.00  0.00           H  
ATOM    212  HB2 PRO A  16      -6.937  57.701  12.979  1.00  0.00           H  
ATOM    213  HB3 PRO A  16      -7.067  59.333  13.643  1.00  0.00           H  
ATOM    214  HG2 PRO A  16      -5.504  58.368  11.279  1.00  0.00           H  
ATOM    215  HG3 PRO A  16      -6.488  59.834  11.447  1.00  0.00           H  
ATOM    216  HD2 PRO A  16      -3.789  59.862  11.650  1.00  0.00           H  
ATOM    217  HD3 PRO A  16      -4.826  60.974  12.564  1.00  0.00           H  
ATOM    218  N   GLY A  17      -3.982  56.422  14.938  1.00  0.00           N  
ATOM    219  CA  GLY A  17      -3.507  55.051  14.916  1.00  0.00           C  
ATOM    220  C   GLY A  17      -2.159  54.893  15.591  1.00  0.00           C  
ATOM    221  O   GLY A  17      -2.045  54.215  16.614  1.00  0.00           O  
ATOM    222  H   GLY A  17      -3.712  57.020  15.667  1.00  0.00           H  
ATOM    223  HA2 GLY A  17      -4.227  54.424  15.420  1.00  0.00           H  
ATOM    224  HA3 GLY A  17      -3.422  54.728  13.889  1.00  0.00           H  
ATOM    225  N   ILE A  18      -1.136  55.520  15.020  1.00  0.00           N  
ATOM    226  CA  ILE A  18       0.210  55.444  15.573  1.00  0.00           C  
ATOM    227  C   ILE A  18       0.413  56.485  16.669  1.00  0.00           C  
ATOM    228  O   ILE A  18      -0.109  57.598  16.589  1.00  0.00           O  
ATOM    229  CB  ILE A  18       1.279  55.648  14.483  1.00  0.00           C  
ATOM    230  CG1 ILE A  18       0.858  54.950  13.189  1.00  0.00           C  
ATOM    231  CG2 ILE A  18       2.627  55.126  14.959  1.00  0.00           C  
ATOM    232  CD1 ILE A  18       1.921  54.983  12.112  1.00  0.00           C  
ATOM    233  H   ILE A  18      -1.290  56.044  14.207  1.00  0.00           H  
ATOM    234  HA  ILE A  18       0.341  54.459  15.999  1.00  0.00           H  
ATOM    235  HB  ILE A  18       1.376  56.707  14.299  1.00  0.00           H  
ATOM    236 HG12 ILE A  18       0.634  53.917  13.400  1.00  0.00           H  
ATOM    237 HG13 ILE A  18      -0.025  55.435  12.799  1.00  0.00           H  
ATOM    238 HG21 ILE A  18       2.921  55.654  15.854  1.00  0.00           H  
ATOM    239 HG22 ILE A  18       2.548  54.071  15.174  1.00  0.00           H  
ATOM    240 HG23 ILE A  18       3.366  55.283  14.188  1.00  0.00           H  
ATOM    241 HD11 ILE A  18       2.434  55.934  12.142  1.00  0.00           H  
ATOM    242 HD12 ILE A  18       2.629  54.186  12.281  1.00  0.00           H  
ATOM    243 HD13 ILE A  18       1.457  54.856  11.145  1.00  0.00           H  
ATOM    244  N   THR A  19       1.175  56.117  17.694  1.00  0.00           N  
ATOM    245  CA  THR A  19       1.448  57.018  18.806  1.00  0.00           C  
ATOM    246  C   THR A  19       2.857  56.810  19.351  1.00  0.00           C  
ATOM    247  O   THR A  19       3.139  55.803  20.001  1.00  0.00           O  
ATOM    248  CB  THR A  19       0.435  56.823  19.949  1.00  0.00           C  
ATOM    249  OG1 THR A  19      -0.880  57.176  19.504  1.00  0.00           O  
ATOM    250  CG2 THR A  19       0.810  57.669  21.157  1.00  0.00           C  
ATOM    251  H   THR A  19       1.564  55.217  17.701  1.00  0.00           H  
ATOM    252  HA  THR A  19       1.359  58.032  18.444  1.00  0.00           H  
ATOM    253  HB  THR A  19       0.440  55.782  20.241  1.00  0.00           H  
ATOM    254  HG1 THR A  19      -0.942  57.046  18.554  1.00  0.00           H  
ATOM    255 HG21 THR A  19       1.640  57.210  21.672  1.00  0.00           H  
ATOM    256 HG22 THR A  19      -0.035  57.737  21.826  1.00  0.00           H  
ATOM    257 HG23 THR A  19       1.091  58.658  20.829  1.00  0.00           H  
ATOM    258  N   PHE A  20       3.738  57.766  19.082  1.00  0.00           N  
ATOM    259  CA  PHE A  20       5.118  57.688  19.546  1.00  0.00           C  
ATOM    260  C   PHE A  20       5.191  57.822  21.063  1.00  0.00           C  
ATOM    261  O   PHE A  20       5.050  58.916  21.608  1.00  0.00           O  
ATOM    262  CB  PHE A  20       5.965  58.778  18.884  1.00  0.00           C  
ATOM    263  CG  PHE A  20       5.724  58.911  17.407  1.00  0.00           C  
ATOM    264  CD1 PHE A  20       5.579  57.785  16.613  1.00  0.00           C  
ATOM    265  CD2 PHE A  20       5.643  60.160  16.815  1.00  0.00           C  
ATOM    266  CE1 PHE A  20       5.360  57.904  15.253  1.00  0.00           C  
ATOM    267  CE2 PHE A  20       5.423  60.285  15.456  1.00  0.00           C  
ATOM    268  CZ  PHE A  20       5.279  59.156  14.674  1.00  0.00           C  
ATOM    269  H   PHE A  20       3.453  58.546  18.559  1.00  0.00           H  
ATOM    270  HA  PHE A  20       5.507  56.721  19.262  1.00  0.00           H  
ATOM    271  HB2 PHE A  20       5.736  59.728  19.343  1.00  0.00           H  
ATOM    272  HB3 PHE A  20       7.010  58.553  19.033  1.00  0.00           H  
ATOM    273  HD1 PHE A  20       5.640  56.805  17.063  1.00  0.00           H  
ATOM    274  HD2 PHE A  20       5.755  61.045  17.426  1.00  0.00           H  
ATOM    275  HE1 PHE A  20       5.247  57.019  14.644  1.00  0.00           H  
ATOM    276  HE2 PHE A  20       5.360  61.265  15.007  1.00  0.00           H  
ATOM    277  HZ  PHE A  20       5.108  59.251  13.612  1.00  0.00           H  
ATOM    278  N   GLU A  21       5.412  56.700  21.741  1.00  0.00           N  
ATOM    279  CA  GLU A  21       5.502  56.691  23.196  1.00  0.00           C  
ATOM    280  C   GLU A  21       6.502  55.642  23.674  1.00  0.00           C  
ATOM    281  O   GLU A  21       7.127  54.953  22.868  1.00  0.00           O  
ATOM    282  CB  GLU A  21       4.128  56.421  23.813  1.00  0.00           C  
ATOM    283  CG  GLU A  21       3.321  57.681  24.078  1.00  0.00           C  
ATOM    284  CD  GLU A  21       2.379  57.533  25.256  1.00  0.00           C  
ATOM    285  OE1 GLU A  21       1.943  56.394  25.528  1.00  0.00           O  
ATOM    286  OE2 GLU A  21       2.076  58.556  25.906  1.00  0.00           O  
ATOM    287  H   GLU A  21       5.516  55.858  21.251  1.00  0.00           H  
ATOM    288  HA  GLU A  21       5.843  57.665  23.513  1.00  0.00           H  
ATOM    289  HB2 GLU A  21       3.563  55.790  23.142  1.00  0.00           H  
ATOM    290  HB3 GLU A  21       4.264  55.902  24.751  1.00  0.00           H  
ATOM    291  HG2 GLU A  21       4.002  58.493  24.282  1.00  0.00           H  
ATOM    292  HG3 GLU A  21       2.740  57.913  23.197  1.00  0.00           H  
ATOM    293  N   ILE A  22       6.646  55.527  24.989  1.00  0.00           N  
ATOM    294  CA  ILE A  22       7.568  54.561  25.575  1.00  0.00           C  
ATOM    295  C   ILE A  22       6.873  53.231  25.846  1.00  0.00           C  
ATOM    296  O   ILE A  22       6.031  53.130  26.737  1.00  0.00           O  
ATOM    297  CB  ILE A  22       8.176  55.088  26.889  1.00  0.00           C  
ATOM    298  CG1 ILE A  22       9.030  56.328  26.620  1.00  0.00           C  
ATOM    299  CG2 ILE A  22       9.004  54.004  27.561  1.00  0.00           C  
ATOM    300  CD1 ILE A  22      10.015  56.150  25.487  1.00  0.00           C  
ATOM    301  H   ILE A  22       6.119  56.104  25.581  1.00  0.00           H  
ATOM    302  HA  ILE A  22       8.372  54.399  24.870  1.00  0.00           H  
ATOM    303  HB  ILE A  22       7.367  55.353  27.552  1.00  0.00           H  
ATOM    304 HG12 ILE A  22       8.383  57.155  26.369  1.00  0.00           H  
ATOM    305 HG13 ILE A  22       9.589  56.571  27.512  1.00  0.00           H  
ATOM    306 HG21 ILE A  22       9.990  54.387  27.779  1.00  0.00           H  
ATOM    307 HG22 ILE A  22       8.525  53.704  28.481  1.00  0.00           H  
ATOM    308 HG23 ILE A  22       9.085  53.152  26.903  1.00  0.00           H  
ATOM    309 HD11 ILE A  22       9.478  56.059  24.554  1.00  0.00           H  
ATOM    310 HD12 ILE A  22      10.671  57.007  25.441  1.00  0.00           H  
ATOM    311 HD13 ILE A  22      10.599  55.257  25.653  1.00  0.00           H  
ATOM    312  N   GLY A  23       7.234  52.212  25.072  1.00  0.00           N  
ATOM    313  CA  GLY A  23       6.636  50.901  25.245  1.00  0.00           C  
ATOM    314  C   GLY A  23       5.495  50.652  24.280  1.00  0.00           C  
ATOM    315  O   GLY A  23       4.943  49.553  24.231  1.00  0.00           O  
ATOM    316  H   GLY A  23       7.910  52.352  24.377  1.00  0.00           H  
ATOM    317  HA2 GLY A  23       7.396  50.149  25.091  1.00  0.00           H  
ATOM    318  HA3 GLY A  23       6.262  50.819  26.255  1.00  0.00           H  
ATOM    319  N   ALA A  24       5.138  51.675  23.510  1.00  0.00           N  
ATOM    320  CA  ALA A  24       4.055  51.561  22.542  1.00  0.00           C  
ATOM    321  C   ALA A  24       4.323  50.437  21.547  1.00  0.00           C  
ATOM    322  O   ALA A  24       5.464  50.217  21.137  1.00  0.00           O  
ATOM    323  CB  ALA A  24       3.862  52.881  21.809  1.00  0.00           C  
ATOM    324  H   ALA A  24       5.617  52.526  23.596  1.00  0.00           H  
ATOM    325  HA  ALA A  24       3.146  51.341  23.082  1.00  0.00           H  
ATOM    326  HB1 ALA A  24       3.540  53.637  22.509  1.00  0.00           H  
ATOM    327  HB2 ALA A  24       4.797  53.182  21.358  1.00  0.00           H  
ATOM    328  HB3 ALA A  24       3.113  52.759  21.041  1.00  0.00           H  
ATOM    329  N   ARG A  25       3.267  49.727  21.165  1.00  0.00           N  
ATOM    330  CA  ARG A  25       3.390  48.623  20.220  1.00  0.00           C  
ATOM    331  C   ARG A  25       2.923  49.043  18.830  1.00  0.00           C  
ATOM    332  O   ARG A  25       1.758  49.394  18.634  1.00  0.00           O  
ATOM    333  CB  ARG A  25       2.578  47.419  20.701  1.00  0.00           C  
ATOM    334  CG  ARG A  25       2.922  46.977  22.114  1.00  0.00           C  
ATOM    335  CD  ARG A  25       1.774  46.213  22.754  1.00  0.00           C  
ATOM    336  NE  ARG A  25       2.002  45.970  24.176  1.00  0.00           N  
ATOM    337  CZ  ARG A  25       1.071  45.505  25.002  1.00  0.00           C  
ATOM    338  NH1 ARG A  25      -0.145  45.235  24.548  1.00  0.00           N  
ATOM    339  NH2 ARG A  25       1.357  45.311  26.282  1.00  0.00           N  
ATOM    340  H   ARG A  25       2.385  49.949  21.527  1.00  0.00           H  
ATOM    341  HA  ARG A  25       4.432  48.345  20.169  1.00  0.00           H  
ATOM    342  HB2 ARG A  25       1.528  47.674  20.673  1.00  0.00           H  
ATOM    343  HB3 ARG A  25       2.757  46.589  20.034  1.00  0.00           H  
ATOM    344  HG2 ARG A  25       3.791  46.336  22.079  1.00  0.00           H  
ATOM    345  HG3 ARG A  25       3.140  47.850  22.711  1.00  0.00           H  
ATOM    346  HD2 ARG A  25       0.868  46.790  22.639  1.00  0.00           H  
ATOM    347  HD3 ARG A  25       1.664  45.265  22.249  1.00  0.00           H  
ATOM    348  HE  ARG A  25       2.895  46.163  24.531  1.00  0.00           H  
ATOM    349 HH11 ARG A  25      -0.363  45.380  23.584  1.00  0.00           H  
ATOM    350 HH12 ARG A  25      -0.843  44.884  25.173  1.00  0.00           H  
ATOM    351 HH21 ARG A  25       2.273  45.513  26.627  1.00  0.00           H  
ATOM    352 HH22 ARG A  25       0.656  44.961  26.904  1.00  0.00           H  
ATOM    353  N   LEU A  26       3.839  49.006  17.868  1.00  0.00           N  
ATOM    354  CA  LEU A  26       3.520  49.383  16.495  1.00  0.00           C  
ATOM    355  C   LEU A  26       4.355  48.580  15.502  1.00  0.00           C  
ATOM    356  O   LEU A  26       5.114  47.693  15.891  1.00  0.00           O  
ATOM    357  CB  LEU A  26       3.762  50.880  16.287  1.00  0.00           C  
ATOM    358  CG  LEU A  26       5.161  51.388  16.637  1.00  0.00           C  
ATOM    359  CD1 LEU A  26       5.371  51.383  18.143  1.00  0.00           C  
ATOM    360  CD2 LEU A  26       6.223  50.547  15.945  1.00  0.00           C  
ATOM    361  H   LEU A  26       4.749  48.718  18.084  1.00  0.00           H  
ATOM    362  HA  LEU A  26       2.476  49.168  16.325  1.00  0.00           H  
ATOM    363  HB2 LEU A  26       3.579  51.103  15.247  1.00  0.00           H  
ATOM    364  HB3 LEU A  26       3.051  51.417  16.900  1.00  0.00           H  
ATOM    365  HG  LEU A  26       5.264  52.408  16.289  1.00  0.00           H  
ATOM    366 HD11 LEU A  26       4.468  51.048  18.631  1.00  0.00           H  
ATOM    367 HD12 LEU A  26       5.609  52.383  18.476  1.00  0.00           H  
ATOM    368 HD13 LEU A  26       6.184  50.718  18.390  1.00  0.00           H  
ATOM    369 HD21 LEU A  26       7.151  51.097  15.906  1.00  0.00           H  
ATOM    370 HD22 LEU A  26       5.899  50.313  14.941  1.00  0.00           H  
ATOM    371 HD23 LEU A  26       6.371  49.629  16.498  1.00  0.00           H  
ATOM    372  N   GLU A  27       4.210  48.899  14.220  1.00  0.00           N  
ATOM    373  CA  GLU A  27       4.951  48.207  13.172  1.00  0.00           C  
ATOM    374  C   GLU A  27       5.964  49.141  12.515  1.00  0.00           C  
ATOM    375  O   GLU A  27       5.794  50.360  12.520  1.00  0.00           O  
ATOM    376  CB  GLU A  27       3.991  47.654  12.117  1.00  0.00           C  
ATOM    377  CG  GLU A  27       3.076  46.559  12.642  1.00  0.00           C  
ATOM    378  CD  GLU A  27       2.686  45.562  11.568  1.00  0.00           C  
ATOM    379  OE1 GLU A  27       3.567  44.805  11.111  1.00  0.00           O  
ATOM    380  OE2 GLU A  27       1.498  45.539  11.185  1.00  0.00           O  
ATOM    381  H   GLU A  27       3.589  49.615  13.973  1.00  0.00           H  
ATOM    382  HA  GLU A  27       5.482  47.385  13.629  1.00  0.00           H  
ATOM    383  HB2 GLU A  27       3.377  48.462  11.747  1.00  0.00           H  
ATOM    384  HB3 GLU A  27       4.570  47.249  11.300  1.00  0.00           H  
ATOM    385  HG2 GLU A  27       3.585  46.031  13.434  1.00  0.00           H  
ATOM    386  HG3 GLU A  27       2.179  47.015  13.032  1.00  0.00           H  
ATOM    387  N   ALA A  28       7.016  48.560  11.950  1.00  0.00           N  
ATOM    388  CA  ALA A  28       8.055  49.338  11.287  1.00  0.00           C  
ATOM    389  C   ALA A  28       8.410  48.738   9.930  1.00  0.00           C  
ATOM    390  O   ALA A  28       8.388  47.519   9.754  1.00  0.00           O  
ATOM    391  CB  ALA A  28       9.292  49.425  12.168  1.00  0.00           C  
ATOM    392  H   ALA A  28       7.095  47.583  11.978  1.00  0.00           H  
ATOM    393  HA  ALA A  28       7.678  50.340  11.139  1.00  0.00           H  
ATOM    394  HB1 ALA A  28      10.149  49.053  11.623  1.00  0.00           H  
ATOM    395  HB2 ALA A  28       9.462  50.454  12.448  1.00  0.00           H  
ATOM    396  HB3 ALA A  28       9.145  48.829  13.056  1.00  0.00           H  
ATOM    397  N   LEU A  29       8.736  49.601   8.974  1.00  0.00           N  
ATOM    398  CA  LEU A  29       9.096  49.156   7.632  1.00  0.00           C  
ATOM    399  C   LEU A  29      10.598  48.922   7.520  1.00  0.00           C  
ATOM    400  O   LEU A  29      11.381  49.871   7.461  1.00  0.00           O  
ATOM    401  CB  LEU A  29       8.649  50.188   6.595  1.00  0.00           C  
ATOM    402  CG  LEU A  29       8.639  49.717   5.140  1.00  0.00           C  
ATOM    403  CD1 LEU A  29       7.361  48.951   4.835  1.00  0.00           C  
ATOM    404  CD2 LEU A  29       8.794  50.899   4.196  1.00  0.00           C  
ATOM    405  H   LEU A  29       8.735  50.560   9.175  1.00  0.00           H  
ATOM    406  HA  LEU A  29       8.583  48.223   7.445  1.00  0.00           H  
ATOM    407  HB2 LEU A  29       7.646  50.498   6.849  1.00  0.00           H  
ATOM    408  HB3 LEU A  29       9.315  51.036   6.666  1.00  0.00           H  
ATOM    409  HG  LEU A  29       9.474  49.048   4.980  1.00  0.00           H  
ATOM    410 HD11 LEU A  29       7.320  48.062   5.445  1.00  0.00           H  
ATOM    411 HD12 LEU A  29       7.349  48.673   3.792  1.00  0.00           H  
ATOM    412 HD13 LEU A  29       6.507  49.578   5.050  1.00  0.00           H  
ATOM    413 HD21 LEU A  29       9.158  51.754   4.746  1.00  0.00           H  
ATOM    414 HD22 LEU A  29       7.837  51.134   3.755  1.00  0.00           H  
ATOM    415 HD23 LEU A  29       9.498  50.647   3.415  1.00  0.00           H  
ATOM    416  N   ASP A  30      10.993  47.655   7.489  1.00  0.00           N  
ATOM    417  CA  ASP A  30      12.403  47.296   7.380  1.00  0.00           C  
ATOM    418  C   ASP A  30      12.923  47.560   5.971  1.00  0.00           C  
ATOM    419  O   ASP A  30      12.145  47.712   5.029  1.00  0.00           O  
ATOM    420  CB  ASP A  30      12.607  45.825   7.745  1.00  0.00           C  
ATOM    421  CG  ASP A  30      12.003  44.885   6.721  1.00  0.00           C  
ATOM    422  OD1 ASP A  30      11.720  45.339   5.592  1.00  0.00           O  
ATOM    423  OD2 ASP A  30      11.813  43.695   7.048  1.00  0.00           O  
ATOM    424  H   ASP A  30      10.322  46.943   7.539  1.00  0.00           H  
ATOM    425  HA  ASP A  30      12.956  47.910   8.075  1.00  0.00           H  
ATOM    426  HB2 ASP A  30      13.666  45.621   7.813  1.00  0.00           H  
ATOM    427  HB3 ASP A  30      12.146  45.631   8.702  1.00  0.00           H  
ATOM    428  N   TYR A  31      14.244  47.613   5.833  1.00  0.00           N  
ATOM    429  CA  TYR A  31      14.868  47.861   4.540  1.00  0.00           C  
ATOM    430  C   TYR A  31      14.279  46.952   3.466  1.00  0.00           C  
ATOM    431  O   TYR A  31      14.357  47.248   2.273  1.00  0.00           O  
ATOM    432  CB  TYR A  31      16.380  47.649   4.630  1.00  0.00           C  
ATOM    433  CG  TYR A  31      16.770  46.350   5.298  1.00  0.00           C  
ATOM    434  CD1 TYR A  31      16.856  46.257   6.682  1.00  0.00           C  
ATOM    435  CD2 TYR A  31      17.053  45.216   4.547  1.00  0.00           C  
ATOM    436  CE1 TYR A  31      17.213  45.072   7.298  1.00  0.00           C  
ATOM    437  CE2 TYR A  31      17.409  44.027   5.153  1.00  0.00           C  
ATOM    438  CZ  TYR A  31      17.488  43.960   6.528  1.00  0.00           C  
ATOM    439  OH  TYR A  31      17.843  42.778   7.137  1.00  0.00           O  
ATOM    440  H   TYR A  31      14.813  47.483   6.621  1.00  0.00           H  
ATOM    441  HA  TYR A  31      14.675  48.890   4.270  1.00  0.00           H  
ATOM    442  HB2 TYR A  31      16.797  47.648   3.635  1.00  0.00           H  
ATOM    443  HB3 TYR A  31      16.817  48.458   5.196  1.00  0.00           H  
ATOM    444  HD1 TYR A  31      16.641  47.129   7.281  1.00  0.00           H  
ATOM    445  HD2 TYR A  31      16.991  45.272   3.469  1.00  0.00           H  
ATOM    446  HE1 TYR A  31      17.274  45.019   8.374  1.00  0.00           H  
ATOM    447  HE2 TYR A  31      17.624  43.157   4.551  1.00  0.00           H  
ATOM    448  HH  TYR A  31      17.103  42.167   7.105  1.00  0.00           H  
ATOM    449  N   LEU A  32      13.689  45.844   3.899  1.00  0.00           N  
ATOM    450  CA  LEU A  32      13.084  44.888   2.976  1.00  0.00           C  
ATOM    451  C   LEU A  32      11.650  45.285   2.644  1.00  0.00           C  
ATOM    452  O   LEU A  32      10.874  44.477   2.135  1.00  0.00           O  
ATOM    453  CB  LEU A  32      13.110  43.482   3.578  1.00  0.00           C  
ATOM    454  CG  LEU A  32      14.481  42.959   4.004  1.00  0.00           C  
ATOM    455  CD1 LEU A  32      14.340  41.651   4.768  1.00  0.00           C  
ATOM    456  CD2 LEU A  32      15.384  42.778   2.793  1.00  0.00           C  
ATOM    457  H   LEU A  32      13.658  45.661   4.861  1.00  0.00           H  
ATOM    458  HA  LEU A  32      13.667  44.892   2.067  1.00  0.00           H  
ATOM    459  HB2 LEU A  32      12.471  43.483   4.447  1.00  0.00           H  
ATOM    460  HB3 LEU A  32      12.709  42.801   2.840  1.00  0.00           H  
ATOM    461  HG  LEU A  32      14.946  43.681   4.663  1.00  0.00           H  
ATOM    462 HD11 LEU A  32      15.306  41.177   4.850  1.00  0.00           H  
ATOM    463 HD12 LEU A  32      13.662  40.998   4.240  1.00  0.00           H  
ATOM    464 HD13 LEU A  32      13.951  41.851   5.756  1.00  0.00           H  
ATOM    465 HD21 LEU A  32      16.332  43.259   2.975  1.00  0.00           H  
ATOM    466 HD22 LEU A  32      14.915  43.220   1.926  1.00  0.00           H  
ATOM    467 HD23 LEU A  32      15.542  41.722   2.617  1.00  0.00           H  
ATOM    468  N   GLN A  33      11.305  46.537   2.931  1.00  0.00           N  
ATOM    469  CA  GLN A  33       9.965  47.042   2.661  1.00  0.00           C  
ATOM    470  C   GLN A  33       8.905  46.098   3.221  1.00  0.00           C  
ATOM    471  O   GLN A  33       7.786  46.032   2.711  1.00  0.00           O  
ATOM    472  CB  GLN A  33       9.759  47.224   1.156  1.00  0.00           C  
ATOM    473  CG  GLN A  33      10.734  48.203   0.523  1.00  0.00           C  
ATOM    474  CD  GLN A  33      10.173  48.865  -0.719  1.00  0.00           C  
ATOM    475  OE1 GLN A  33       8.962  49.058  -0.841  1.00  0.00           O  
ATOM    476  NE2 GLN A  33      11.050  49.217  -1.652  1.00  0.00           N  
ATOM    477  H   GLN A  33      11.969  47.134   3.336  1.00  0.00           H  
ATOM    478  HA  GLN A  33       9.867  48.001   3.147  1.00  0.00           H  
ATOM    479  HB2 GLN A  33       9.877  46.267   0.670  1.00  0.00           H  
ATOM    480  HB3 GLN A  33       8.756  47.585   0.984  1.00  0.00           H  
ATOM    481  HG2 GLN A  33      10.972  48.972   1.245  1.00  0.00           H  
ATOM    482  HG3 GLN A  33      11.635  47.672   0.255  1.00  0.00           H  
ATOM    483 HE21 GLN A  33      11.999  49.031  -1.486  1.00  0.00           H  
ATOM    484 HE22 GLN A  33      10.715  49.646  -2.465  1.00  0.00           H  
ATOM    485  N   LYS A  34       9.265  45.368   4.271  1.00  0.00           N  
ATOM    486  CA  LYS A  34       8.345  44.428   4.902  1.00  0.00           C  
ATOM    487  C   LYS A  34       7.751  45.020   6.176  1.00  0.00           C  
ATOM    488  O   LYS A  34       8.372  45.858   6.830  1.00  0.00           O  
ATOM    489  CB  LYS A  34       9.065  43.117   5.224  1.00  0.00           C  
ATOM    490  CG  LYS A  34       9.366  42.272   3.998  1.00  0.00           C  
ATOM    491  CD  LYS A  34       8.109  41.614   3.452  1.00  0.00           C  
ATOM    492  CE  LYS A  34       7.814  40.303   4.162  1.00  0.00           C  
ATOM    493  NZ  LYS A  34       6.793  39.497   3.435  1.00  0.00           N  
ATOM    494  H   LYS A  34      10.172  45.466   4.632  1.00  0.00           H  
ATOM    495  HA  LYS A  34       7.546  44.229   4.205  1.00  0.00           H  
ATOM    496  HB2 LYS A  34       9.999  43.344   5.716  1.00  0.00           H  
ATOM    497  HB3 LYS A  34       8.448  42.536   5.893  1.00  0.00           H  
ATOM    498  HG2 LYS A  34       9.791  42.902   3.231  1.00  0.00           H  
ATOM    499  HG3 LYS A  34      10.075  41.503   4.268  1.00  0.00           H  
ATOM    500  HD2 LYS A  34       7.274  42.283   3.594  1.00  0.00           H  
ATOM    501  HD3 LYS A  34       8.243  41.421   2.398  1.00  0.00           H  
ATOM    502  HE2 LYS A  34       8.727  39.731   4.232  1.00  0.00           H  
ATOM    503  HE3 LYS A  34       7.448  40.520   5.155  1.00  0.00           H  
ATOM    504  HZ1 LYS A  34       6.864  39.669   2.413  1.00  0.00           H  
ATOM    505  HZ2 LYS A  34       5.839  39.758   3.755  1.00  0.00           H  
ATOM    506  HZ3 LYS A  34       6.943  38.484   3.618  1.00  0.00           H  
ATOM    507  N   TRP A  35       6.548  44.579   6.522  1.00  0.00           N  
ATOM    508  CA  TRP A  35       5.871  45.065   7.719  1.00  0.00           C  
ATOM    509  C   TRP A  35       6.000  44.063   8.861  1.00  0.00           C  
ATOM    510  O   TRP A  35       5.794  42.864   8.674  1.00  0.00           O  
ATOM    511  CB  TRP A  35       4.394  45.332   7.422  1.00  0.00           C  
ATOM    512  CG  TRP A  35       4.166  46.562   6.599  1.00  0.00           C  
ATOM    513  CD1 TRP A  35       3.678  46.618   5.325  1.00  0.00           C  
ATOM    514  CD2 TRP A  35       4.421  47.916   6.992  1.00  0.00           C  
ATOM    515  NE1 TRP A  35       3.613  47.924   4.903  1.00  0.00           N  
ATOM    516  CE2 TRP A  35       4.063  48.740   5.907  1.00  0.00           C  
ATOM    517  CE3 TRP A  35       4.914  48.512   8.156  1.00  0.00           C  
ATOM    518  CZ2 TRP A  35       4.184  50.126   5.954  1.00  0.00           C  
ATOM    519  CZ3 TRP A  35       5.035  49.887   8.201  1.00  0.00           C  
ATOM    520  CH2 TRP A  35       4.671  50.682   7.106  1.00  0.00           C  
ATOM    521  H   TRP A  35       6.103  43.910   5.959  1.00  0.00           H  
ATOM    522  HA  TRP A  35       6.342  45.991   8.012  1.00  0.00           H  
ATOM    523  HB2 TRP A  35       3.984  44.490   6.884  1.00  0.00           H  
ATOM    524  HB3 TRP A  35       3.864  45.450   8.355  1.00  0.00           H  
ATOM    525  HD1 TRP A  35       3.391  45.754   4.746  1.00  0.00           H  
ATOM    526  HE1 TRP A  35       3.294  48.223   4.024  1.00  0.00           H  
ATOM    527  HE3 TRP A  35       5.200  47.916   9.010  1.00  0.00           H  
ATOM    528  HZ2 TRP A  35       3.907  50.752   5.119  1.00  0.00           H  
ATOM    529  HZ3 TRP A  35       5.415  50.366   9.091  1.00  0.00           H  
ATOM    530  HH2 TRP A  35       4.782  51.753   7.184  1.00  0.00           H  
ATOM    531  N   TYR A  36       6.340  44.562  10.044  1.00  0.00           N  
ATOM    532  CA  TYR A  36       6.499  43.710  11.216  1.00  0.00           C  
ATOM    533  C   TYR A  36       6.257  44.497  12.499  1.00  0.00           C  
ATOM    534  O   TYR A  36       6.419  45.717  12.550  1.00  0.00           O  
ATOM    535  CB  TYR A  36       7.899  43.093  11.239  1.00  0.00           C  
ATOM    536  CG  TYR A  36       8.134  42.083  10.139  1.00  0.00           C  
ATOM    537  CD1 TYR A  36       7.356  40.936  10.044  1.00  0.00           C  
ATOM    538  CD2 TYR A  36       9.134  42.277   9.193  1.00  0.00           C  
ATOM    539  CE1 TYR A  36       7.568  40.010   9.040  1.00  0.00           C  
ATOM    540  CE2 TYR A  36       9.352  41.357   8.186  1.00  0.00           C  
ATOM    541  CZ  TYR A  36       8.567  40.225   8.114  1.00  0.00           C  
ATOM    542  OH  TYR A  36       8.780  39.306   7.112  1.00  0.00           O  
ATOM    543  H   TYR A  36       6.492  45.526  10.131  1.00  0.00           H  
ATOM    544  HA  TYR A  36       5.768  42.917  11.151  1.00  0.00           H  
ATOM    545  HB2 TYR A  36       8.632  43.877  11.130  1.00  0.00           H  
ATOM    546  HB3 TYR A  36       8.049  42.594  12.186  1.00  0.00           H  
ATOM    547  HD1 TYR A  36       6.574  40.771  10.770  1.00  0.00           H  
ATOM    548  HD2 TYR A  36       9.748  43.164   9.253  1.00  0.00           H  
ATOM    549  HE1 TYR A  36       6.953  39.125   8.983  1.00  0.00           H  
ATOM    550  HE2 TYR A  36      10.134  41.525   7.460  1.00  0.00           H  
ATOM    551  HH  TYR A  36       8.921  39.766   6.281  1.00  0.00           H  
ATOM    552  N   PRO A  37       5.860  43.785  13.564  1.00  0.00           N  
ATOM    553  CA  PRO A  37       5.588  44.396  14.869  1.00  0.00           C  
ATOM    554  C   PRO A  37       6.858  44.893  15.552  1.00  0.00           C  
ATOM    555  O   PRO A  37       7.954  44.410  15.272  1.00  0.00           O  
ATOM    556  CB  PRO A  37       4.961  43.253  15.671  1.00  0.00           C  
ATOM    557  CG  PRO A  37       5.487  42.012  15.038  1.00  0.00           C  
ATOM    558  CD  PRO A  37       5.646  42.328  13.577  1.00  0.00           C  
ATOM    559  HA  PRO A  37       4.882  45.210  14.786  1.00  0.00           H  
ATOM    560  HB2 PRO A  37       5.264  43.329  16.707  1.00  0.00           H  
ATOM    561  HB3 PRO A  37       3.885  43.307  15.600  1.00  0.00           H  
ATOM    562  HG2 PRO A  37       6.441  41.755  15.472  1.00  0.00           H  
ATOM    563  HG3 PRO A  37       4.781  41.205  15.172  1.00  0.00           H  
ATOM    564  HD2 PRO A  37       6.501  41.809  13.169  1.00  0.00           H  
ATOM    565  HD3 PRO A  37       4.750  42.066  13.033  1.00  0.00           H  
ATOM    566  N   SER A  38       6.700  45.860  16.450  1.00  0.00           N  
ATOM    567  CA  SER A  38       7.835  46.425  17.172  1.00  0.00           C  
ATOM    568  C   SER A  38       7.363  47.276  18.346  1.00  0.00           C  
ATOM    569  O   SER A  38       6.168  47.525  18.506  1.00  0.00           O  
ATOM    570  CB  SER A  38       8.696  47.268  16.229  1.00  0.00           C  
ATOM    571  OG  SER A  38       9.328  46.459  15.254  1.00  0.00           O  
ATOM    572  H   SER A  38       5.800  46.203  16.630  1.00  0.00           H  
ATOM    573  HA  SER A  38       8.427  45.605  17.551  1.00  0.00           H  
ATOM    574  HB2 SER A  38       8.073  47.994  15.729  1.00  0.00           H  
ATOM    575  HB3 SER A  38       9.455  47.780  16.803  1.00  0.00           H  
ATOM    576  HG  SER A  38       8.703  46.252  14.556  1.00  0.00           H  
ATOM    577  N   ARG A  39       8.310  47.718  19.167  1.00  0.00           N  
ATOM    578  CA  ARG A  39       7.992  48.540  20.328  1.00  0.00           C  
ATOM    579  C   ARG A  39       8.989  49.686  20.473  1.00  0.00           C  
ATOM    580  O   ARG A  39      10.060  49.670  19.867  1.00  0.00           O  
ATOM    581  CB  ARG A  39       7.992  47.687  21.598  1.00  0.00           C  
ATOM    582  CG  ARG A  39       6.632  47.099  21.938  1.00  0.00           C  
ATOM    583  CD  ARG A  39       6.698  46.222  23.179  1.00  0.00           C  
ATOM    584  NE  ARG A  39       5.701  45.156  23.148  1.00  0.00           N  
ATOM    585  CZ  ARG A  39       5.727  44.148  22.281  1.00  0.00           C  
ATOM    586  NH1 ARG A  39       6.696  44.072  21.380  1.00  0.00           N  
ATOM    587  NH2 ARG A  39       4.784  43.216  22.317  1.00  0.00           N  
ATOM    588  H   ARG A  39       9.245  47.486  18.988  1.00  0.00           H  
ATOM    589  HA  ARG A  39       7.005  48.952  20.183  1.00  0.00           H  
ATOM    590  HB2 ARG A  39       8.690  46.871  21.471  1.00  0.00           H  
ATOM    591  HB3 ARG A  39       8.313  48.298  22.429  1.00  0.00           H  
ATOM    592  HG2 ARG A  39       5.936  47.906  22.119  1.00  0.00           H  
ATOM    593  HG3 ARG A  39       6.289  46.505  21.105  1.00  0.00           H  
ATOM    594  HD2 ARG A  39       7.681  45.780  23.239  1.00  0.00           H  
ATOM    595  HD3 ARG A  39       6.526  46.837  24.048  1.00  0.00           H  
ATOM    596  HE  ARG A  39       4.976  45.193  23.806  1.00  0.00           H  
ATOM    597 HH11 ARG A  39       7.409  44.772  21.352  1.00  0.00           H  
ATOM    598 HH12 ARG A  39       6.715  43.311  20.729  1.00  0.00           H  
ATOM    599 HH21 ARG A  39       4.052  43.270  22.995  1.00  0.00           H  
ATOM    600 HH22 ARG A  39       4.805  42.460  21.664  1.00  0.00           H  
ATOM    601  N   ILE A  40       8.627  50.679  21.278  1.00  0.00           N  
ATOM    602  CA  ILE A  40       9.489  51.833  21.501  1.00  0.00           C  
ATOM    603  C   ILE A  40      10.199  51.737  22.849  1.00  0.00           C  
ATOM    604  O   ILE A  40       9.606  52.008  23.892  1.00  0.00           O  
ATOM    605  CB  ILE A  40       8.693  53.150  21.446  1.00  0.00           C  
ATOM    606  CG1 ILE A  40       8.289  53.466  20.005  1.00  0.00           C  
ATOM    607  CG2 ILE A  40       9.513  54.289  22.034  1.00  0.00           C  
ATOM    608  CD1 ILE A  40       7.149  54.455  19.900  1.00  0.00           C  
ATOM    609  H   ILE A  40       7.761  50.635  21.733  1.00  0.00           H  
ATOM    610  HA  ILE A  40      10.232  51.851  20.717  1.00  0.00           H  
ATOM    611  HB  ILE A  40       7.804  53.033  22.045  1.00  0.00           H  
ATOM    612 HG12 ILE A  40       9.136  53.882  19.482  1.00  0.00           H  
ATOM    613 HG13 ILE A  40       7.984  52.553  19.516  1.00  0.00           H  
ATOM    614 HG21 ILE A  40       9.301  55.201  21.495  1.00  0.00           H  
ATOM    615 HG22 ILE A  40       9.254  54.419  23.074  1.00  0.00           H  
ATOM    616 HG23 ILE A  40      10.565  54.058  21.951  1.00  0.00           H  
ATOM    617 HD11 ILE A  40       7.161  54.916  18.923  1.00  0.00           H  
ATOM    618 HD12 ILE A  40       6.211  53.938  20.042  1.00  0.00           H  
ATOM    619 HD13 ILE A  40       7.260  55.215  20.657  1.00  0.00           H  
ATOM    620  N   GLU A  41      11.470  51.351  22.816  1.00  0.00           N  
ATOM    621  CA  GLU A  41      12.259  51.219  24.035  1.00  0.00           C  
ATOM    622  C   GLU A  41      12.598  52.590  24.613  1.00  0.00           C  
ATOM    623  O   GLU A  41      12.504  52.808  25.822  1.00  0.00           O  
ATOM    624  CB  GLU A  41      13.546  50.440  23.756  1.00  0.00           C  
ATOM    625  CG  GLU A  41      13.317  48.960  23.497  1.00  0.00           C  
ATOM    626  CD  GLU A  41      12.574  48.278  24.629  1.00  0.00           C  
ATOM    627  OE1 GLU A  41      13.099  48.271  25.762  1.00  0.00           O  
ATOM    628  OE2 GLU A  41      11.468  47.752  24.382  1.00  0.00           O  
ATOM    629  H   GLU A  41      11.886  51.148  21.953  1.00  0.00           H  
ATOM    630  HA  GLU A  41      11.669  50.674  24.756  1.00  0.00           H  
ATOM    631  HB2 GLU A  41      14.028  50.866  22.888  1.00  0.00           H  
ATOM    632  HB3 GLU A  41      14.204  50.537  24.606  1.00  0.00           H  
ATOM    633  HG2 GLU A  41      12.739  48.851  22.591  1.00  0.00           H  
ATOM    634  HG3 GLU A  41      14.274  48.477  23.372  1.00  0.00           H  
ATOM    635  N   LYS A  42      12.994  53.512  23.742  1.00  0.00           N  
ATOM    636  CA  LYS A  42      13.347  54.862  24.163  1.00  0.00           C  
ATOM    637  C   LYS A  42      12.993  55.880  23.083  1.00  0.00           C  
ATOM    638  O   LYS A  42      12.745  55.517  21.933  1.00  0.00           O  
ATOM    639  CB  LYS A  42      14.842  54.944  24.486  1.00  0.00           C  
ATOM    640  CG  LYS A  42      15.195  54.417  25.865  1.00  0.00           C  
ATOM    641  CD  LYS A  42      16.695  54.223  26.020  1.00  0.00           C  
ATOM    642  CE  LYS A  42      17.017  53.259  27.151  1.00  0.00           C  
ATOM    643  NZ  LYS A  42      16.643  53.817  28.480  1.00  0.00           N  
ATOM    644  H   LYS A  42      13.050  53.278  22.792  1.00  0.00           H  
ATOM    645  HA  LYS A  42      12.782  55.090  25.055  1.00  0.00           H  
ATOM    646  HB2 LYS A  42      15.387  54.370  23.752  1.00  0.00           H  
ATOM    647  HB3 LYS A  42      15.154  55.977  24.426  1.00  0.00           H  
ATOM    648  HG2 LYS A  42      14.856  55.123  26.608  1.00  0.00           H  
ATOM    649  HG3 LYS A  42      14.701  53.468  26.016  1.00  0.00           H  
ATOM    650  HD2 LYS A  42      17.094  53.826  25.099  1.00  0.00           H  
ATOM    651  HD3 LYS A  42      17.153  55.179  26.231  1.00  0.00           H  
ATOM    652  HE2 LYS A  42      16.474  52.340  26.990  1.00  0.00           H  
ATOM    653  HE3 LYS A  42      18.078  53.056  27.142  1.00  0.00           H  
ATOM    654  HZ1 LYS A  42      16.357  54.812  28.382  1.00  0.00           H  
ATOM    655  HZ2 LYS A  42      17.451  53.762  29.132  1.00  0.00           H  
ATOM    656  HZ3 LYS A  42      15.849  53.278  28.883  1.00  0.00           H  
ATOM    657  N   ILE A  43      12.972  57.153  23.461  1.00  0.00           N  
ATOM    658  CA  ILE A  43      12.651  58.222  22.522  1.00  0.00           C  
ATOM    659  C   ILE A  43      13.513  59.454  22.777  1.00  0.00           C  
ATOM    660  O   ILE A  43      13.626  59.923  23.909  1.00  0.00           O  
ATOM    661  CB  ILE A  43      11.166  58.622  22.611  1.00  0.00           C  
ATOM    662  CG1 ILE A  43      10.273  57.426  22.276  1.00  0.00           C  
ATOM    663  CG2 ILE A  43      10.874  59.786  21.678  1.00  0.00           C  
ATOM    664  CD1 ILE A  43       8.795  57.713  22.430  1.00  0.00           C  
ATOM    665  H   ILE A  43      13.178  57.380  24.391  1.00  0.00           H  
ATOM    666  HA  ILE A  43      12.845  57.859  21.524  1.00  0.00           H  
ATOM    667  HB  ILE A  43      10.962  58.942  23.621  1.00  0.00           H  
ATOM    668 HG12 ILE A  43      10.447  57.129  21.253  1.00  0.00           H  
ATOM    669 HG13 ILE A  43      10.522  56.605  22.933  1.00  0.00           H  
ATOM    670 HG21 ILE A  43       9.959  60.273  21.983  1.00  0.00           H  
ATOM    671 HG22 ILE A  43      11.688  60.495  21.721  1.00  0.00           H  
ATOM    672 HG23 ILE A  43      10.768  59.420  20.668  1.00  0.00           H  
ATOM    673 HD11 ILE A  43       8.450  57.327  23.378  1.00  0.00           H  
ATOM    674 HD12 ILE A  43       8.630  58.780  22.396  1.00  0.00           H  
ATOM    675 HD13 ILE A  43       8.250  57.238  21.628  1.00  0.00           H  
ATOM    676  N   ASP A  44      14.119  59.974  21.715  1.00  0.00           N  
ATOM    677  CA  ASP A  44      14.968  61.154  21.821  1.00  0.00           C  
ATOM    678  C   ASP A  44      14.292  62.370  21.195  1.00  0.00           C  
ATOM    679  O   ASP A  44      14.210  62.486  19.972  1.00  0.00           O  
ATOM    680  CB  ASP A  44      16.317  60.901  21.144  1.00  0.00           C  
ATOM    681  CG  ASP A  44      17.390  61.865  21.610  1.00  0.00           C  
ATOM    682  OD1 ASP A  44      17.038  62.992  22.018  1.00  0.00           O  
ATOM    683  OD2 ASP A  44      18.581  61.492  21.568  1.00  0.00           O  
ATOM    684  H   ASP A  44      13.989  59.555  20.838  1.00  0.00           H  
ATOM    685  HA  ASP A  44      15.134  61.350  22.869  1.00  0.00           H  
ATOM    686  HB2 ASP A  44      16.641  59.894  21.369  1.00  0.00           H  
ATOM    687  HB3 ASP A  44      16.201  61.007  20.076  1.00  0.00           H  
ATOM    688  N   TYR A  45      13.809  63.273  22.041  1.00  0.00           N  
ATOM    689  CA  TYR A  45      13.137  64.478  21.572  1.00  0.00           C  
ATOM    690  C   TYR A  45      14.148  65.563  21.219  1.00  0.00           C  
ATOM    691  O   TYR A  45      13.839  66.498  20.480  1.00  0.00           O  
ATOM    692  CB  TYR A  45      12.167  64.994  22.637  1.00  0.00           C  
ATOM    693  CG  TYR A  45      10.931  64.139  22.797  1.00  0.00           C  
ATOM    694  CD1 TYR A  45      11.008  62.869  23.355  1.00  0.00           C  
ATOM    695  CD2 TYR A  45       9.685  64.601  22.390  1.00  0.00           C  
ATOM    696  CE1 TYR A  45       9.882  62.083  23.502  1.00  0.00           C  
ATOM    697  CE2 TYR A  45       8.553  63.822  22.535  1.00  0.00           C  
ATOM    698  CZ  TYR A  45       8.657  62.564  23.091  1.00  0.00           C  
ATOM    699  OH  TYR A  45       7.531  61.786  23.237  1.00  0.00           O  
ATOM    700  H   TYR A  45      13.906  63.124  23.005  1.00  0.00           H  
ATOM    701  HA  TYR A  45      12.577  64.221  20.685  1.00  0.00           H  
ATOM    702  HB2 TYR A  45      12.674  65.026  23.590  1.00  0.00           H  
ATOM    703  HB3 TYR A  45      11.849  65.992  22.371  1.00  0.00           H  
ATOM    704  HD1 TYR A  45      11.970  62.495  23.676  1.00  0.00           H  
ATOM    705  HD2 TYR A  45       9.607  65.586  21.955  1.00  0.00           H  
ATOM    706  HE1 TYR A  45       9.963  61.097  23.937  1.00  0.00           H  
ATOM    707  HE2 TYR A  45       7.594  64.199  22.212  1.00  0.00           H  
ATOM    708  HH  TYR A  45       7.394  61.268  22.439  1.00  0.00           H  
ATOM    709  N   GLU A  46      15.358  65.432  21.754  1.00  0.00           N  
ATOM    710  CA  GLU A  46      16.416  66.402  21.496  1.00  0.00           C  
ATOM    711  C   GLU A  46      17.066  66.150  20.139  1.00  0.00           C  
ATOM    712  O   GLU A  46      17.591  67.069  19.511  1.00  0.00           O  
ATOM    713  CB  GLU A  46      17.474  66.342  22.601  1.00  0.00           C  
ATOM    714  CG  GLU A  46      17.052  67.036  23.886  1.00  0.00           C  
ATOM    715  CD  GLU A  46      16.734  68.504  23.679  1.00  0.00           C  
ATOM    716  OE1 GLU A  46      17.683  69.299  23.515  1.00  0.00           O  
ATOM    717  OE2 GLU A  46      15.537  68.858  23.681  1.00  0.00           O  
ATOM    718  H   GLU A  46      15.543  64.666  22.336  1.00  0.00           H  
ATOM    719  HA  GLU A  46      15.970  67.385  21.491  1.00  0.00           H  
ATOM    720  HB2 GLU A  46      17.683  65.307  22.826  1.00  0.00           H  
ATOM    721  HB3 GLU A  46      18.377  66.814  22.242  1.00  0.00           H  
ATOM    722  HG2 GLU A  46      16.173  66.544  24.273  1.00  0.00           H  
ATOM    723  HG3 GLU A  46      17.855  66.954  24.603  1.00  0.00           H  
ATOM    724  N   GLU A  47      17.028  64.898  19.695  1.00  0.00           N  
ATOM    725  CA  GLU A  47      17.616  64.524  18.414  1.00  0.00           C  
ATOM    726  C   GLU A  47      16.530  64.196  17.393  1.00  0.00           C  
ATOM    727  O   GLU A  47      16.605  64.609  16.236  1.00  0.00           O  
ATOM    728  CB  GLU A  47      18.549  63.324  18.586  1.00  0.00           C  
ATOM    729  CG  GLU A  47      19.909  63.688  19.158  1.00  0.00           C  
ATOM    730  CD  GLU A  47      20.472  64.962  18.560  1.00  0.00           C  
ATOM    731  OE1 GLU A  47      20.732  64.978  17.338  1.00  0.00           O  
ATOM    732  OE2 GLU A  47      20.654  65.942  19.311  1.00  0.00           O  
ATOM    733  H   GLU A  47      16.596  64.209  20.242  1.00  0.00           H  
ATOM    734  HA  GLU A  47      18.189  65.365  18.054  1.00  0.00           H  
ATOM    735  HB2 GLU A  47      18.081  62.611  19.248  1.00  0.00           H  
ATOM    736  HB3 GLU A  47      18.701  62.861  17.621  1.00  0.00           H  
ATOM    737  HG2 GLU A  47      19.811  63.823  20.225  1.00  0.00           H  
ATOM    738  HG3 GLU A  47      20.597  62.880  18.961  1.00  0.00           H  
ATOM    739  N   GLY A  48      15.521  63.449  17.830  1.00  0.00           N  
ATOM    740  CA  GLY A  48      14.434  63.077  16.943  1.00  0.00           C  
ATOM    741  C   GLY A  48      14.484  61.613  16.548  1.00  0.00           C  
ATOM    742  O   GLY A  48      13.948  61.224  15.511  1.00  0.00           O  
ATOM    743  H   GLY A  48      15.513  63.148  18.763  1.00  0.00           H  
ATOM    744  HA2 GLY A  48      13.495  63.274  17.438  1.00  0.00           H  
ATOM    745  HA3 GLY A  48      14.492  63.680  16.049  1.00  0.00           H  
ATOM    746  N   LYS A  49      15.130  60.801  17.377  1.00  0.00           N  
ATOM    747  CA  LYS A  49      15.249  59.372  17.111  1.00  0.00           C  
ATOM    748  C   LYS A  49      14.744  58.554  18.294  1.00  0.00           C  
ATOM    749  O   LYS A  49      14.945  58.929  19.450  1.00  0.00           O  
ATOM    750  CB  LYS A  49      16.704  59.008  16.807  1.00  0.00           C  
ATOM    751  CG  LYS A  49      17.688  59.528  17.841  1.00  0.00           C  
ATOM    752  CD  LYS A  49      18.913  58.634  17.944  1.00  0.00           C  
ATOM    753  CE  LYS A  49      19.548  58.715  19.323  1.00  0.00           C  
ATOM    754  NZ  LYS A  49      20.674  57.752  19.474  1.00  0.00           N  
ATOM    755  H   LYS A  49      15.537  61.171  18.189  1.00  0.00           H  
ATOM    756  HA  LYS A  49      14.642  59.144  16.246  1.00  0.00           H  
ATOM    757  HB2 LYS A  49      16.792  57.933  16.766  1.00  0.00           H  
ATOM    758  HB3 LYS A  49      16.972  59.420  15.846  1.00  0.00           H  
ATOM    759  HG2 LYS A  49      18.004  60.521  17.556  1.00  0.00           H  
ATOM    760  HG3 LYS A  49      17.199  59.565  18.803  1.00  0.00           H  
ATOM    761  HD2 LYS A  49      18.618  57.612  17.756  1.00  0.00           H  
ATOM    762  HD3 LYS A  49      19.637  58.943  17.203  1.00  0.00           H  
ATOM    763  HE2 LYS A  49      19.920  59.717  19.475  1.00  0.00           H  
ATOM    764  HE3 LYS A  49      18.795  58.496  20.065  1.00  0.00           H  
ATOM    765  HZ1 LYS A  49      21.375  58.124  20.145  1.00  0.00           H  
ATOM    766  HZ2 LYS A  49      21.136  57.598  18.555  1.00  0.00           H  
ATOM    767  HZ3 LYS A  49      20.319  56.841  19.828  1.00  0.00           H  
ATOM    768  N   MET A  50      14.091  57.434  18.000  1.00  0.00           N  
ATOM    769  CA  MET A  50      13.561  56.563  19.041  1.00  0.00           C  
ATOM    770  C   MET A  50      14.099  55.144  18.889  1.00  0.00           C  
ATOM    771  O   MET A  50      14.234  54.636  17.774  1.00  0.00           O  
ATOM    772  CB  MET A  50      12.032  56.548  18.995  1.00  0.00           C  
ATOM    773  CG  MET A  50      11.464  56.794  17.607  1.00  0.00           C  
ATOM    774  SD  MET A  50       9.704  56.415  17.500  1.00  0.00           S  
ATOM    775  CE  MET A  50       9.706  55.156  16.227  1.00  0.00           C  
ATOM    776  H   MET A  50      13.963  57.189  17.059  1.00  0.00           H  
ATOM    777  HA  MET A  50      13.879  56.955  19.995  1.00  0.00           H  
ATOM    778  HB2 MET A  50      11.683  55.586  19.338  1.00  0.00           H  
ATOM    779  HB3 MET A  50      11.655  57.315  19.655  1.00  0.00           H  
ATOM    780  HG2 MET A  50      11.609  57.833  17.351  1.00  0.00           H  
ATOM    781  HG3 MET A  50      11.996  56.174  16.900  1.00  0.00           H  
ATOM    782  HE1 MET A  50      10.372  54.355  16.515  1.00  0.00           H  
ATOM    783  HE2 MET A  50       8.707  54.765  16.104  1.00  0.00           H  
ATOM    784  HE3 MET A  50      10.042  55.586  15.294  1.00  0.00           H  
ATOM    785  N   LEU A  51      14.407  54.508  20.014  1.00  0.00           N  
ATOM    786  CA  LEU A  51      14.931  53.147  20.004  1.00  0.00           C  
ATOM    787  C   LEU A  51      13.805  52.130  19.847  1.00  0.00           C  
ATOM    788  O   LEU A  51      13.105  51.810  20.808  1.00  0.00           O  
ATOM    789  CB  LEU A  51      15.708  52.869  21.293  1.00  0.00           C  
ATOM    790  CG  LEU A  51      16.823  51.828  21.194  1.00  0.00           C  
ATOM    791  CD1 LEU A  51      17.229  51.346  22.578  1.00  0.00           C  
ATOM    792  CD2 LEU A  51      16.384  50.658  20.327  1.00  0.00           C  
ATOM    793  H   LEU A  51      14.278  54.964  20.871  1.00  0.00           H  
ATOM    794  HA  LEU A  51      15.602  53.056  19.163  1.00  0.00           H  
ATOM    795  HB2 LEU A  51      16.150  53.798  21.619  1.00  0.00           H  
ATOM    796  HB3 LEU A  51      15.001  52.530  22.036  1.00  0.00           H  
ATOM    797  HG  LEU A  51      17.690  52.282  20.732  1.00  0.00           H  
ATOM    798 HD11 LEU A  51      18.001  50.598  22.487  1.00  0.00           H  
ATOM    799 HD12 LEU A  51      16.371  50.920  23.076  1.00  0.00           H  
ATOM    800 HD13 LEU A  51      17.601  52.181  23.155  1.00  0.00           H  
ATOM    801 HD21 LEU A  51      15.685  50.045  20.876  1.00  0.00           H  
ATOM    802 HD22 LEU A  51      17.246  50.066  20.058  1.00  0.00           H  
ATOM    803 HD23 LEU A  51      15.911  51.031  19.431  1.00  0.00           H  
ATOM    804  N   VAL A  52      13.637  51.624  18.629  1.00  0.00           N  
ATOM    805  CA  VAL A  52      12.599  50.641  18.347  1.00  0.00           C  
ATOM    806  C   VAL A  52      13.188  49.240  18.217  1.00  0.00           C  
ATOM    807  O   VAL A  52      14.255  49.057  17.630  1.00  0.00           O  
ATOM    808  CB  VAL A  52      11.835  50.987  17.054  1.00  0.00           C  
ATOM    809  CG1 VAL A  52      12.794  51.078  15.876  1.00  0.00           C  
ATOM    810  CG2 VAL A  52      10.746  49.958  16.788  1.00  0.00           C  
ATOM    811  H   VAL A  52      14.227  51.918  17.904  1.00  0.00           H  
ATOM    812  HA  VAL A  52      11.897  50.651  19.168  1.00  0.00           H  
ATOM    813  HB  VAL A  52      11.366  51.951  17.184  1.00  0.00           H  
ATOM    814 HG11 VAL A  52      13.580  50.348  15.995  1.00  0.00           H  
ATOM    815 HG12 VAL A  52      12.256  50.885  14.959  1.00  0.00           H  
ATOM    816 HG13 VAL A  52      13.225  52.068  15.840  1.00  0.00           H  
ATOM    817 HG21 VAL A  52      11.003  49.028  17.271  1.00  0.00           H  
ATOM    818 HG22 VAL A  52       9.807  50.321  17.178  1.00  0.00           H  
ATOM    819 HG23 VAL A  52      10.655  49.798  15.723  1.00  0.00           H  
ATOM    820  N   HIS A  53      12.485  48.256  18.767  1.00  0.00           N  
ATOM    821  CA  HIS A  53      12.938  46.870  18.711  1.00  0.00           C  
ATOM    822  C   HIS A  53      12.055  46.047  17.777  1.00  0.00           C  
ATOM    823  O   HIS A  53      10.836  46.211  17.756  1.00  0.00           O  
ATOM    824  CB  HIS A  53      12.934  46.254  20.110  1.00  0.00           C  
ATOM    825  CG  HIS A  53      11.655  45.553  20.453  1.00  0.00           C  
ATOM    826  ND1 HIS A  53      11.170  44.481  19.735  1.00  0.00           N  
ATOM    827  CD2 HIS A  53      10.761  45.777  21.444  1.00  0.00           C  
ATOM    828  CE1 HIS A  53      10.031  44.076  20.270  1.00  0.00           C  
ATOM    829  NE2 HIS A  53       9.762  44.846  21.309  1.00  0.00           N  
ATOM    830  H   HIS A  53      11.642  48.465  19.220  1.00  0.00           H  
ATOM    831  HA  HIS A  53      13.947  46.867  18.328  1.00  0.00           H  
ATOM    832  HB2 HIS A  53      13.736  45.534  20.181  1.00  0.00           H  
ATOM    833  HB3 HIS A  53      13.092  47.034  20.841  1.00  0.00           H  
ATOM    834  HD1 HIS A  53      11.595  44.077  18.950  1.00  0.00           H  
ATOM    835  HD2 HIS A  53      10.823  46.546  22.202  1.00  0.00           H  
ATOM    836  HE1 HIS A  53       9.424  43.255  19.918  1.00  0.00           H  
ATOM    837  N   PHE A  54      12.681  45.163  17.007  1.00  0.00           N  
ATOM    838  CA  PHE A  54      11.953  44.316  16.070  1.00  0.00           C  
ATOM    839  C   PHE A  54      11.738  42.920  16.651  1.00  0.00           C  
ATOM    840  O   PHE A  54      12.572  42.415  17.401  1.00  0.00           O  
ATOM    841  CB  PHE A  54      12.710  44.216  14.745  1.00  0.00           C  
ATOM    842  CG  PHE A  54      12.743  45.506  13.975  1.00  0.00           C  
ATOM    843  CD1 PHE A  54      13.715  46.459  14.235  1.00  0.00           C  
ATOM    844  CD2 PHE A  54      11.803  45.765  12.991  1.00  0.00           C  
ATOM    845  CE1 PHE A  54      13.747  47.647  13.530  1.00  0.00           C  
ATOM    846  CE2 PHE A  54      11.831  46.951  12.281  1.00  0.00           C  
ATOM    847  CZ  PHE A  54      12.805  47.893  12.550  1.00  0.00           C  
ATOM    848  H   PHE A  54      13.656  45.079  17.070  1.00  0.00           H  
ATOM    849  HA  PHE A  54      10.990  44.770  15.891  1.00  0.00           H  
ATOM    850  HB2 PHE A  54      13.730  43.923  14.942  1.00  0.00           H  
ATOM    851  HB3 PHE A  54      12.238  43.470  14.123  1.00  0.00           H  
ATOM    852  HD1 PHE A  54      14.453  46.267  15.001  1.00  0.00           H  
ATOM    853  HD2 PHE A  54      11.041  45.029  12.779  1.00  0.00           H  
ATOM    854  HE1 PHE A  54      14.509  48.381  13.742  1.00  0.00           H  
ATOM    855  HE2 PHE A  54      11.092  47.141  11.516  1.00  0.00           H  
ATOM    856  HZ  PHE A  54      12.827  48.821  11.998  1.00  0.00           H  
ATOM    857  N   GLU A  55      10.613  42.307  16.299  1.00  0.00           N  
ATOM    858  CA  GLU A  55      10.288  40.972  16.787  1.00  0.00           C  
ATOM    859  C   GLU A  55      10.772  39.902  15.812  1.00  0.00           C  
ATOM    860  O   GLU A  55      11.450  38.952  16.202  1.00  0.00           O  
ATOM    861  CB  GLU A  55       8.779  40.836  17.001  1.00  0.00           C  
ATOM    862  CG  GLU A  55       8.118  42.110  17.501  1.00  0.00           C  
ATOM    863  CD  GLU A  55       6.904  41.836  18.366  1.00  0.00           C  
ATOM    864  OE1 GLU A  55       6.711  40.668  18.766  1.00  0.00           O  
ATOM    865  OE2 GLU A  55       6.145  42.788  18.645  1.00  0.00           O  
ATOM    866  H   GLU A  55       9.988  42.761  15.698  1.00  0.00           H  
ATOM    867  HA  GLU A  55      10.790  40.833  17.732  1.00  0.00           H  
ATOM    868  HB2 GLU A  55       8.318  40.559  16.064  1.00  0.00           H  
ATOM    869  HB3 GLU A  55       8.600  40.054  17.726  1.00  0.00           H  
ATOM    870  HG2 GLU A  55       8.837  42.669  18.082  1.00  0.00           H  
ATOM    871  HG3 GLU A  55       7.810  42.698  16.649  1.00  0.00           H  
ATOM    872  N   ARG A  56      10.419  40.066  14.541  1.00  0.00           N  
ATOM    873  CA  ARG A  56      10.815  39.115  13.509  1.00  0.00           C  
ATOM    874  C   ARG A  56      12.198  38.539  13.803  1.00  0.00           C  
ATOM    875  O   ARG A  56      12.332  37.361  14.135  1.00  0.00           O  
ATOM    876  CB  ARG A  56      10.814  39.790  12.136  1.00  0.00           C  
ATOM    877  CG  ARG A  56      10.594  38.824  10.983  1.00  0.00           C  
ATOM    878  CD  ARG A  56      11.904  38.213  10.509  1.00  0.00           C  
ATOM    879  NE  ARG A  56      12.229  36.987  11.233  1.00  0.00           N  
ATOM    880  CZ  ARG A  56      11.680  35.808  10.963  1.00  0.00           C  
ATOM    881  NH1 ARG A  56      10.784  35.696   9.992  1.00  0.00           N  
ATOM    882  NH2 ARG A  56      12.027  34.737  11.665  1.00  0.00           N  
ATOM    883  H   ARG A  56       9.878  40.844  14.291  1.00  0.00           H  
ATOM    884  HA  ARG A  56      10.096  38.310  13.506  1.00  0.00           H  
ATOM    885  HB2 ARG A  56      10.027  40.529  12.112  1.00  0.00           H  
ATOM    886  HB3 ARG A  56      11.764  40.281  11.989  1.00  0.00           H  
ATOM    887  HG2 ARG A  56       9.937  38.031  11.310  1.00  0.00           H  
ATOM    888  HG3 ARG A  56      10.137  39.357  10.163  1.00  0.00           H  
ATOM    889  HD2 ARG A  56      11.820  37.989   9.457  1.00  0.00           H  
ATOM    890  HD3 ARG A  56      12.696  38.931  10.663  1.00  0.00           H  
ATOM    891  HE  ARG A  56      12.889  37.047  11.954  1.00  0.00           H  
ATOM    892 HH11 ARG A  56      10.521  36.502   9.461  1.00  0.00           H  
ATOM    893 HH12 ARG A  56      10.373  34.807   9.790  1.00  0.00           H  
ATOM    894 HH21 ARG A  56      12.703  34.817  12.398  1.00  0.00           H  
ATOM    895 HH22 ARG A  56      11.614  33.850  11.462  1.00  0.00           H  
ATOM    896  N   TRP A  57      13.221  39.376  13.679  1.00  0.00           N  
ATOM    897  CA  TRP A  57      14.592  38.950  13.931  1.00  0.00           C  
ATOM    898  C   TRP A  57      14.697  38.207  15.258  1.00  0.00           C  
ATOM    899  O   TRP A  57      14.736  38.822  16.323  1.00  0.00           O  
ATOM    900  CB  TRP A  57      15.531  40.157  13.933  1.00  0.00           C  
ATOM    901  CG  TRP A  57      15.876  40.645  12.558  1.00  0.00           C  
ATOM    902  CD1 TRP A  57      16.915  40.228  11.777  1.00  0.00           C  
ATOM    903  CD2 TRP A  57      15.179  41.643  11.803  1.00  0.00           C  
ATOM    904  NE1 TRP A  57      16.908  40.907  10.582  1.00  0.00           N  
ATOM    905  CE2 TRP A  57      15.852  41.780  10.574  1.00  0.00           C  
ATOM    906  CE3 TRP A  57      14.052  42.433  12.046  1.00  0.00           C  
ATOM    907  CZ2 TRP A  57      15.434  42.675   9.592  1.00  0.00           C  
ATOM    908  CZ3 TRP A  57      13.639  43.321  11.072  1.00  0.00           C  
ATOM    909  CH2 TRP A  57      14.328  43.436   9.857  1.00  0.00           C  
ATOM    910  H   TRP A  57      13.050  40.304  13.411  1.00  0.00           H  
ATOM    911  HA  TRP A  57      14.883  38.282  13.133  1.00  0.00           H  
ATOM    912  HB2 TRP A  57      15.061  40.970  14.467  1.00  0.00           H  
ATOM    913  HB3 TRP A  57      16.451  39.888  14.432  1.00  0.00           H  
ATOM    914  HD1 TRP A  57      17.631  39.475  12.069  1.00  0.00           H  
ATOM    915  HE1 TRP A  57      17.552  40.783   9.854  1.00  0.00           H  
ATOM    916  HE3 TRP A  57      13.508  42.359  12.976  1.00  0.00           H  
ATOM    917  HZ2 TRP A  57      15.953  42.774   8.650  1.00  0.00           H  
ATOM    918  HZ3 TRP A  57      12.771  43.941  11.241  1.00  0.00           H  
ATOM    919  HH2 TRP A  57      13.969  44.142   9.125  1.00  0.00           H  
ATOM    920  N   SER A  58      14.740  36.880  15.186  1.00  0.00           N  
ATOM    921  CA  SER A  58      14.836  36.054  16.384  1.00  0.00           C  
ATOM    922  C   SER A  58      15.676  36.743  17.455  1.00  0.00           C  
ATOM    923  O   SER A  58      15.176  37.093  18.524  1.00  0.00           O  
ATOM    924  CB  SER A  58      15.444  34.692  16.041  1.00  0.00           C  
ATOM    925  OG  SER A  58      14.498  33.861  15.390  1.00  0.00           O  
ATOM    926  H   SER A  58      14.705  36.448  14.308  1.00  0.00           H  
ATOM    927  HA  SER A  58      13.837  35.907  16.766  1.00  0.00           H  
ATOM    928  HB2 SER A  58      16.291  34.832  15.389  1.00  0.00           H  
ATOM    929  HB3 SER A  58      15.766  34.206  16.951  1.00  0.00           H  
ATOM    930  HG  SER A  58      14.263  33.130  15.965  1.00  0.00           H  
ATOM    931  N   HIS A  59      16.958  36.935  17.159  1.00  0.00           N  
ATOM    932  CA  HIS A  59      17.870  37.584  18.096  1.00  0.00           C  
ATOM    933  C   HIS A  59      17.446  39.026  18.355  1.00  0.00           C  
ATOM    934  O   HIS A  59      17.448  39.858  17.448  1.00  0.00           O  
ATOM    935  CB  HIS A  59      19.300  37.550  17.554  1.00  0.00           C  
ATOM    936  CG  HIS A  59      20.272  38.329  18.384  1.00  0.00           C  
ATOM    937  ND1 HIS A  59      20.317  39.707  18.395  1.00  0.00           N  
ATOM    938  CD2 HIS A  59      21.240  37.917  19.235  1.00  0.00           C  
ATOM    939  CE1 HIS A  59      21.271  40.108  19.216  1.00  0.00           C  
ATOM    940  NE2 HIS A  59      21.845  39.041  19.740  1.00  0.00           N  
ATOM    941  H   HIS A  59      17.299  36.635  16.291  1.00  0.00           H  
ATOM    942  HA  HIS A  59      17.833  37.038  19.025  1.00  0.00           H  
ATOM    943  HB2 HIS A  59      19.640  36.526  17.520  1.00  0.00           H  
ATOM    944  HB3 HIS A  59      19.309  37.962  16.555  1.00  0.00           H  
ATOM    945  HD1 HIS A  59      19.737  40.303  17.876  1.00  0.00           H  
ATOM    946  HD2 HIS A  59      21.490  36.892  19.476  1.00  0.00           H  
ATOM    947  HE1 HIS A  59      21.537  41.134  19.424  1.00  0.00           H  
ATOM    948  N   ARG A  60      17.082  39.315  19.601  1.00  0.00           N  
ATOM    949  CA  ARG A  60      16.654  40.656  19.979  1.00  0.00           C  
ATOM    950  C   ARG A  60      17.422  41.715  19.193  1.00  0.00           C  
ATOM    951  O   ARG A  60      18.519  42.117  19.584  1.00  0.00           O  
ATOM    952  CB  ARG A  60      16.855  40.874  21.481  1.00  0.00           C  
ATOM    953  CG  ARG A  60      18.228  40.452  21.979  1.00  0.00           C  
ATOM    954  CD  ARG A  60      18.241  38.994  22.408  1.00  0.00           C  
ATOM    955  NE  ARG A  60      19.210  38.745  23.471  1.00  0.00           N  
ATOM    956  CZ  ARG A  60      19.572  37.529  23.866  1.00  0.00           C  
ATOM    957  NH1 ARG A  60      19.047  36.457  23.288  1.00  0.00           N  
ATOM    958  NH2 ARG A  60      20.460  37.384  24.841  1.00  0.00           N  
ATOM    959  H   ARG A  60      17.101  38.610  20.281  1.00  0.00           H  
ATOM    960  HA  ARG A  60      15.603  40.747  19.750  1.00  0.00           H  
ATOM    961  HB2 ARG A  60      16.722  41.923  21.701  1.00  0.00           H  
ATOM    962  HB3 ARG A  60      16.110  40.305  22.017  1.00  0.00           H  
ATOM    963  HG2 ARG A  60      18.946  40.589  21.183  1.00  0.00           H  
ATOM    964  HG3 ARG A  60      18.499  41.070  22.822  1.00  0.00           H  
ATOM    965  HD2 ARG A  60      17.256  38.728  22.762  1.00  0.00           H  
ATOM    966  HD3 ARG A  60      18.493  38.384  21.553  1.00  0.00           H  
ATOM    967  HE  ARG A  60      19.610  39.523  23.911  1.00  0.00           H  
ATOM    968 HH11 ARG A  60      18.378  36.563  22.554  1.00  0.00           H  
ATOM    969 HH12 ARG A  60      19.322  35.543  23.587  1.00  0.00           H  
ATOM    970 HH21 ARG A  60      20.857  38.190  25.279  1.00  0.00           H  
ATOM    971 HH22 ARG A  60      20.731  36.468  25.138  1.00  0.00           H  
ATOM    972  N   TYR A  61      16.839  42.161  18.087  1.00  0.00           N  
ATOM    973  CA  TYR A  61      17.471  43.170  17.244  1.00  0.00           C  
ATOM    974  C   TYR A  61      16.749  44.510  17.366  1.00  0.00           C  
ATOM    975  O   TYR A  61      15.612  44.657  16.920  1.00  0.00           O  
ATOM    976  CB  TYR A  61      17.479  42.714  15.785  1.00  0.00           C  
ATOM    977  CG  TYR A  61      17.503  43.855  14.793  1.00  0.00           C  
ATOM    978  CD1 TYR A  61      18.634  44.647  14.644  1.00  0.00           C  
ATOM    979  CD2 TYR A  61      16.394  44.141  14.007  1.00  0.00           C  
ATOM    980  CE1 TYR A  61      18.661  45.692  13.740  1.00  0.00           C  
ATOM    981  CE2 TYR A  61      16.412  45.183  13.100  1.00  0.00           C  
ATOM    982  CZ  TYR A  61      17.548  45.956  12.970  1.00  0.00           C  
ATOM    983  OH  TYR A  61      17.569  46.995  12.068  1.00  0.00           O  
ATOM    984  H   TYR A  61      15.965  41.802  17.828  1.00  0.00           H  
ATOM    985  HA  TYR A  61      18.490  43.292  17.579  1.00  0.00           H  
ATOM    986  HB2 TYR A  61      18.352  42.105  15.610  1.00  0.00           H  
ATOM    987  HB3 TYR A  61      16.593  42.126  15.594  1.00  0.00           H  
ATOM    988  HD1 TYR A  61      19.506  44.438  15.248  1.00  0.00           H  
ATOM    989  HD2 TYR A  61      15.506  43.535  14.112  1.00  0.00           H  
ATOM    990  HE1 TYR A  61      19.550  46.296  13.638  1.00  0.00           H  
ATOM    991  HE2 TYR A  61      15.540  45.390  12.497  1.00  0.00           H  
ATOM    992  HH  TYR A  61      18.447  47.070  11.687  1.00  0.00           H  
ATOM    993  N   ASP A  62      17.420  45.482  17.972  1.00  0.00           N  
ATOM    994  CA  ASP A  62      16.847  46.810  18.152  1.00  0.00           C  
ATOM    995  C   ASP A  62      17.673  47.864  17.421  1.00  0.00           C  
ATOM    996  O   ASP A  62      18.895  47.748  17.322  1.00  0.00           O  
ATOM    997  CB  ASP A  62      16.759  47.155  19.639  1.00  0.00           C  
ATOM    998  CG  ASP A  62      18.040  46.833  20.384  1.00  0.00           C  
ATOM    999  OD1 ASP A  62      19.129  47.019  19.801  1.00  0.00           O  
ATOM   1000  OD2 ASP A  62      17.954  46.397  21.551  1.00  0.00           O  
ATOM   1001  H   ASP A  62      18.325  45.303  18.306  1.00  0.00           H  
ATOM   1002  HA  ASP A  62      15.850  46.800  17.735  1.00  0.00           H  
ATOM   1003  HB2 ASP A  62      16.559  48.211  19.747  1.00  0.00           H  
ATOM   1004  HB3 ASP A  62      15.953  46.592  20.086  1.00  0.00           H  
ATOM   1005  N   GLU A  63      16.999  48.888  16.909  1.00  0.00           N  
ATOM   1006  CA  GLU A  63      17.673  49.961  16.186  1.00  0.00           C  
ATOM   1007  C   GLU A  63      16.865  51.254  16.254  1.00  0.00           C  
ATOM   1008  O   GLU A  63      15.642  51.241  16.128  1.00  0.00           O  
ATOM   1009  CB  GLU A  63      17.893  49.561  14.726  1.00  0.00           C  
ATOM   1010  CG  GLU A  63      18.143  50.741  13.802  1.00  0.00           C  
ATOM   1011  CD  GLU A  63      18.699  50.321  12.456  1.00  0.00           C  
ATOM   1012  OE1 GLU A  63      19.862  49.868  12.408  1.00  0.00           O  
ATOM   1013  OE2 GLU A  63      17.970  50.443  11.448  1.00  0.00           O  
ATOM   1014  H   GLU A  63      16.026  48.925  17.021  1.00  0.00           H  
ATOM   1015  HA  GLU A  63      18.633  50.124  16.653  1.00  0.00           H  
ATOM   1016  HB2 GLU A  63      18.746  48.899  14.670  1.00  0.00           H  
ATOM   1017  HB3 GLU A  63      17.018  49.035  14.374  1.00  0.00           H  
ATOM   1018  HG2 GLU A  63      17.211  51.261  13.643  1.00  0.00           H  
ATOM   1019  HG3 GLU A  63      18.849  51.408  14.274  1.00  0.00           H  
ATOM   1020  N   TRP A  64      17.561  52.368  16.455  1.00  0.00           N  
ATOM   1021  CA  TRP A  64      16.909  53.670  16.541  1.00  0.00           C  
ATOM   1022  C   TRP A  64      16.358  54.094  15.184  1.00  0.00           C  
ATOM   1023  O   TRP A  64      17.083  54.114  14.189  1.00  0.00           O  
ATOM   1024  CB  TRP A  64      17.893  54.722  17.056  1.00  0.00           C  
ATOM   1025  CG  TRP A  64      18.300  54.507  18.483  1.00  0.00           C  
ATOM   1026  CD1 TRP A  64      19.269  53.662  18.940  1.00  0.00           C  
ATOM   1027  CD2 TRP A  64      17.745  55.147  19.637  1.00  0.00           C  
ATOM   1028  NE1 TRP A  64      19.352  53.737  20.310  1.00  0.00           N  
ATOM   1029  CE2 TRP A  64      18.428  54.643  20.762  1.00  0.00           C  
ATOM   1030  CE3 TRP A  64      16.741  56.100  19.831  1.00  0.00           C  
ATOM   1031  CZ2 TRP A  64      18.136  55.057  22.058  1.00  0.00           C  
ATOM   1032  CZ3 TRP A  64      16.452  56.510  21.119  1.00  0.00           C  
ATOM   1033  CH2 TRP A  64      17.147  55.991  22.219  1.00  0.00           C  
ATOM   1034  H   TRP A  64      18.535  52.313  16.548  1.00  0.00           H  
ATOM   1035  HA  TRP A  64      16.090  53.584  17.239  1.00  0.00           H  
ATOM   1036  HB2 TRP A  64      18.785  54.701  16.449  1.00  0.00           H  
ATOM   1037  HB3 TRP A  64      17.435  55.698  16.983  1.00  0.00           H  
ATOM   1038  HD1 TRP A  64      19.873  53.030  18.307  1.00  0.00           H  
ATOM   1039  HE1 TRP A  64      19.973  53.227  20.872  1.00  0.00           H  
ATOM   1040  HE3 TRP A  64      16.194  56.512  18.997  1.00  0.00           H  
ATOM   1041  HZ2 TRP A  64      18.663  54.668  22.916  1.00  0.00           H  
ATOM   1042  HZ3 TRP A  64      15.679  57.246  21.288  1.00  0.00           H  
ATOM   1043  HH2 TRP A  64      16.889  56.341  23.206  1.00  0.00           H  
ATOM   1044  N   ILE A  65      15.073  54.430  15.152  1.00  0.00           N  
ATOM   1045  CA  ILE A  65      14.426  54.853  13.917  1.00  0.00           C  
ATOM   1046  C   ILE A  65      13.750  56.210  14.087  1.00  0.00           C  
ATOM   1047  O   ILE A  65      12.815  56.354  14.874  1.00  0.00           O  
ATOM   1048  CB  ILE A  65      13.379  53.826  13.448  1.00  0.00           C  
ATOM   1049  CG1 ILE A  65      14.036  52.463  13.219  1.00  0.00           C  
ATOM   1050  CG2 ILE A  65      12.692  54.310  12.179  1.00  0.00           C  
ATOM   1051  CD1 ILE A  65      13.069  51.396  12.755  1.00  0.00           C  
ATOM   1052  H   ILE A  65      14.548  54.392  15.978  1.00  0.00           H  
ATOM   1053  HA  ILE A  65      15.186  54.935  13.154  1.00  0.00           H  
ATOM   1054  HB  ILE A  65      12.630  53.731  14.219  1.00  0.00           H  
ATOM   1055 HG12 ILE A  65      14.804  52.563  12.469  1.00  0.00           H  
ATOM   1056 HG13 ILE A  65      14.482  52.128  14.144  1.00  0.00           H  
ATOM   1057 HG21 ILE A  65      12.359  55.328  12.316  1.00  0.00           H  
ATOM   1058 HG22 ILE A  65      13.389  54.268  11.356  1.00  0.00           H  
ATOM   1059 HG23 ILE A  65      11.844  53.678  11.965  1.00  0.00           H  
ATOM   1060 HD11 ILE A  65      13.063  51.361  11.675  1.00  0.00           H  
ATOM   1061 HD12 ILE A  65      13.377  50.437  13.144  1.00  0.00           H  
ATOM   1062 HD13 ILE A  65      12.076  51.629  13.113  1.00  0.00           H  
ATOM   1063  N   TYR A  66      14.229  57.201  13.344  1.00  0.00           N  
ATOM   1064  CA  TYR A  66      13.672  58.546  13.413  1.00  0.00           C  
ATOM   1065  C   TYR A  66      12.147  58.505  13.418  1.00  0.00           C  
ATOM   1066  O   TYR A  66      11.525  58.031  12.468  1.00  0.00           O  
ATOM   1067  CB  TYR A  66      14.167  59.387  12.235  1.00  0.00           C  
ATOM   1068  CG  TYR A  66      15.648  59.688  12.284  1.00  0.00           C  
ATOM   1069  CD1 TYR A  66      16.241  60.160  13.449  1.00  0.00           C  
ATOM   1070  CD2 TYR A  66      16.453  59.502  11.168  1.00  0.00           C  
ATOM   1071  CE1 TYR A  66      17.594  60.437  13.499  1.00  0.00           C  
ATOM   1072  CE2 TYR A  66      17.806  59.774  11.209  1.00  0.00           C  
ATOM   1073  CZ  TYR A  66      18.372  60.243  12.377  1.00  0.00           C  
ATOM   1074  OH  TYR A  66      19.720  60.517  12.423  1.00  0.00           O  
ATOM   1075  H   TYR A  66      14.977  57.024  12.735  1.00  0.00           H  
ATOM   1076  HA  TYR A  66      14.012  59.000  14.332  1.00  0.00           H  
ATOM   1077  HB2 TYR A  66      13.968  58.858  11.315  1.00  0.00           H  
ATOM   1078  HB3 TYR A  66      13.636  60.328  12.225  1.00  0.00           H  
ATOM   1079  HD1 TYR A  66      15.630  60.312  14.326  1.00  0.00           H  
ATOM   1080  HD2 TYR A  66      16.007  59.135  10.255  1.00  0.00           H  
ATOM   1081  HE1 TYR A  66      18.038  60.803  14.414  1.00  0.00           H  
ATOM   1082  HE2 TYR A  66      18.416  59.623  10.331  1.00  0.00           H  
ATOM   1083  HH  TYR A  66      20.194  59.742  12.735  1.00  0.00           H  
ATOM   1084  N   TRP A  67      11.552  59.006  14.494  1.00  0.00           N  
ATOM   1085  CA  TRP A  67      10.100  59.028  14.624  1.00  0.00           C  
ATOM   1086  C   TRP A  67       9.467  59.869  13.521  1.00  0.00           C  
ATOM   1087  O   TRP A  67       8.245  59.890  13.367  1.00  0.00           O  
ATOM   1088  CB  TRP A  67       9.697  59.576  15.994  1.00  0.00           C  
ATOM   1089  CG  TRP A  67      10.297  60.917  16.297  1.00  0.00           C  
ATOM   1090  CD1 TRP A  67      11.233  61.581  15.558  1.00  0.00           C  
ATOM   1091  CD2 TRP A  67      10.001  61.752  17.421  1.00  0.00           C  
ATOM   1092  NE1 TRP A  67      11.537  62.781  16.154  1.00  0.00           N  
ATOM   1093  CE2 TRP A  67      10.795  62.911  17.298  1.00  0.00           C  
ATOM   1094  CE3 TRP A  67       9.142  61.638  18.517  1.00  0.00           C  
ATOM   1095  CZ2 TRP A  67      10.753  63.942  18.232  1.00  0.00           C  
ATOM   1096  CZ3 TRP A  67       9.103  62.663  19.443  1.00  0.00           C  
ATOM   1097  CH2 TRP A  67       9.904  63.804  19.295  1.00  0.00           C  
ATOM   1098  H   TRP A  67      12.103  59.370  15.219  1.00  0.00           H  
ATOM   1099  HA  TRP A  67       9.745  58.011  14.535  1.00  0.00           H  
ATOM   1100  HB2 TRP A  67       8.623  59.674  16.034  1.00  0.00           H  
ATOM   1101  HB3 TRP A  67      10.022  58.885  16.759  1.00  0.00           H  
ATOM   1102  HD1 TRP A  67      11.663  61.206  14.642  1.00  0.00           H  
ATOM   1103  HE1 TRP A  67      12.180  63.439  15.814  1.00  0.00           H  
ATOM   1104  HE3 TRP A  67       8.517  60.767  18.649  1.00  0.00           H  
ATOM   1105  HZ2 TRP A  67      11.364  64.829  18.132  1.00  0.00           H  
ATOM   1106  HZ3 TRP A  67       8.446  62.591  20.297  1.00  0.00           H  
ATOM   1107  HH2 TRP A  67       9.840  64.579  20.043  1.00  0.00           H  
ATOM   1108  N   ASP A  68      10.305  60.560  12.756  1.00  0.00           N  
ATOM   1109  CA  ASP A  68       9.827  61.402  11.665  1.00  0.00           C  
ATOM   1110  C   ASP A  68      10.158  60.780  10.313  1.00  0.00           C  
ATOM   1111  O   ASP A  68      10.190  61.468   9.293  1.00  0.00           O  
ATOM   1112  CB  ASP A  68      10.443  62.799  11.763  1.00  0.00           C  
ATOM   1113  CG  ASP A  68      10.071  63.679  10.586  1.00  0.00           C  
ATOM   1114  OD1 ASP A  68       8.886  63.673  10.191  1.00  0.00           O  
ATOM   1115  OD2 ASP A  68      10.964  64.375  10.060  1.00  0.00           O  
ATOM   1116  H   ASP A  68      11.268  60.502  12.928  1.00  0.00           H  
ATOM   1117  HA  ASP A  68       8.754  61.485  11.756  1.00  0.00           H  
ATOM   1118  HB2 ASP A  68      10.096  63.276  12.669  1.00  0.00           H  
ATOM   1119  HB3 ASP A  68      11.519  62.709  11.797  1.00  0.00           H  
ATOM   1120  N   SER A  69      10.405  59.475  10.313  1.00  0.00           N  
ATOM   1121  CA  SER A  69      10.739  58.760   9.086  1.00  0.00           C  
ATOM   1122  C   SER A  69       9.482  58.449   8.278  1.00  0.00           C  
ATOM   1123  O   SER A  69       9.527  58.355   7.053  1.00  0.00           O  
ATOM   1124  CB  SER A  69      11.483  57.463   9.413  1.00  0.00           C  
ATOM   1125  OG  SER A  69      12.347  57.090   8.354  1.00  0.00           O  
ATOM   1126  H   SER A  69      10.365  58.980  11.158  1.00  0.00           H  
ATOM   1127  HA  SER A  69      11.384  59.395   8.497  1.00  0.00           H  
ATOM   1128  HB2 SER A  69      12.069  57.603  10.308  1.00  0.00           H  
ATOM   1129  HB3 SER A  69      10.765  56.670   9.572  1.00  0.00           H  
ATOM   1130  HG  SER A  69      13.139  57.632   8.381  1.00  0.00           H  
ATOM   1131  N   ASN A  70       8.363  58.291   8.977  1.00  0.00           N  
ATOM   1132  CA  ASN A  70       7.093  57.989   8.326  1.00  0.00           C  
ATOM   1133  C   ASN A  70       7.110  56.590   7.718  1.00  0.00           C  
ATOM   1134  O   ASN A  70       6.472  56.337   6.697  1.00  0.00           O  
ATOM   1135  CB  ASN A  70       6.794  59.026   7.240  1.00  0.00           C  
ATOM   1136  CG  ASN A  70       6.935  60.449   7.744  1.00  0.00           C  
ATOM   1137  OD1 ASN A  70       6.323  60.827   8.743  1.00  0.00           O  
ATOM   1138  ND2 ASN A  70       7.741  61.245   7.053  1.00  0.00           N  
ATOM   1139  H   ASN A  70       8.391  58.378   9.953  1.00  0.00           H  
ATOM   1140  HA  ASN A  70       6.317  58.035   9.076  1.00  0.00           H  
ATOM   1141  HB2 ASN A  70       7.484  58.886   6.419  1.00  0.00           H  
ATOM   1142  HB3 ASN A  70       5.784  58.886   6.885  1.00  0.00           H  
ATOM   1143 HD21 ASN A  70       8.195  60.875   6.267  1.00  0.00           H  
ATOM   1144 HD22 ASN A  70       7.850  62.170   7.356  1.00  0.00           H  
ATOM   1145  N   ARG A  71       7.846  55.684   8.355  1.00  0.00           N  
ATOM   1146  CA  ARG A  71       7.948  54.310   7.878  1.00  0.00           C  
ATOM   1147  C   ARG A  71       7.298  53.343   8.863  1.00  0.00           C  
ATOM   1148  O   ARG A  71       7.576  52.143   8.846  1.00  0.00           O  
ATOM   1149  CB  ARG A  71       9.414  53.930   7.664  1.00  0.00           C  
ATOM   1150  CG  ARG A  71      10.165  54.887   6.752  1.00  0.00           C  
ATOM   1151  CD  ARG A  71      11.669  54.703   6.871  1.00  0.00           C  
ATOM   1152  NE  ARG A  71      12.403  55.624   6.005  1.00  0.00           N  
ATOM   1153  CZ  ARG A  71      13.658  55.425   5.617  1.00  0.00           C  
ATOM   1154  NH1 ARG A  71      14.315  54.345   6.015  1.00  0.00           N  
ATOM   1155  NH2 ARG A  71      14.257  56.308   4.830  1.00  0.00           N  
ATOM   1156  H   ARG A  71       8.332  55.946   9.165  1.00  0.00           H  
ATOM   1157  HA  ARG A  71       7.426  54.248   6.934  1.00  0.00           H  
ATOM   1158  HB2 ARG A  71       9.913  53.913   8.621  1.00  0.00           H  
ATOM   1159  HB3 ARG A  71       9.457  52.943   7.227  1.00  0.00           H  
ATOM   1160  HG2 ARG A  71       9.869  54.703   5.730  1.00  0.00           H  
ATOM   1161  HG3 ARG A  71       9.912  55.901   7.025  1.00  0.00           H  
ATOM   1162  HD2 ARG A  71      11.961  54.878   7.894  1.00  0.00           H  
ATOM   1163  HD3 ARG A  71      11.916  53.689   6.594  1.00  0.00           H  
ATOM   1164  HE  ARG A  71      11.936  56.428   5.700  1.00  0.00           H  
ATOM   1165 HH11 ARG A  71      13.866  53.677   6.609  1.00  0.00           H  
ATOM   1166 HH12 ARG A  71      15.260  54.197   5.721  1.00  0.00           H  
ATOM   1167 HH21 ARG A  71      13.765  57.124   4.528  1.00  0.00           H  
ATOM   1168 HH22 ARG A  71      15.202  56.159   4.539  1.00  0.00           H  
ATOM   1169  N   LEU A  72       6.434  53.873   9.721  1.00  0.00           N  
ATOM   1170  CA  LEU A  72       5.746  53.057  10.716  1.00  0.00           C  
ATOM   1171  C   LEU A  72       4.234  53.116  10.516  1.00  0.00           C  
ATOM   1172  O   LEU A  72       3.695  54.133  10.077  1.00  0.00           O  
ATOM   1173  CB  LEU A  72       6.104  53.526  12.127  1.00  0.00           C  
ATOM   1174  CG  LEU A  72       7.561  53.932  12.349  1.00  0.00           C  
ATOM   1175  CD1 LEU A  72       7.658  55.006  13.421  1.00  0.00           C  
ATOM   1176  CD2 LEU A  72       8.402  52.721  12.726  1.00  0.00           C  
ATOM   1177  H   LEU A  72       6.254  54.835   9.687  1.00  0.00           H  
ATOM   1178  HA  LEU A  72       6.073  52.035  10.590  1.00  0.00           H  
ATOM   1179  HB2 LEU A  72       5.484  54.378  12.360  1.00  0.00           H  
ATOM   1180  HB3 LEU A  72       5.877  52.719  12.810  1.00  0.00           H  
ATOM   1181  HG  LEU A  72       7.958  54.343  11.430  1.00  0.00           H  
ATOM   1182 HD11 LEU A  72       6.723  55.066  13.956  1.00  0.00           H  
ATOM   1183 HD12 LEU A  72       7.869  55.959  12.958  1.00  0.00           H  
ATOM   1184 HD13 LEU A  72       8.453  54.757  14.110  1.00  0.00           H  
ATOM   1185 HD21 LEU A  72       9.275  52.678  12.093  1.00  0.00           H  
ATOM   1186 HD22 LEU A  72       7.817  51.823  12.595  1.00  0.00           H  
ATOM   1187 HD23 LEU A  72       8.709  52.804  13.759  1.00  0.00           H  
ATOM   1188  N   ARG A  73       3.555  52.022  10.845  1.00  0.00           N  
ATOM   1189  CA  ARG A  73       2.106  51.950  10.703  1.00  0.00           C  
ATOM   1190  C   ARG A  73       1.448  51.583  12.030  1.00  0.00           C  
ATOM   1191  O   ARG A  73       2.046  50.938  12.890  1.00  0.00           O  
ATOM   1192  CB  ARG A  73       1.727  50.926   9.632  1.00  0.00           C  
ATOM   1193  CG  ARG A  73       2.269  49.532   9.904  1.00  0.00           C  
ATOM   1194  CD  ARG A  73       2.046  48.607   8.717  1.00  0.00           C  
ATOM   1195  NE  ARG A  73       0.681  48.091   8.674  1.00  0.00           N  
ATOM   1196  CZ  ARG A  73      -0.335  48.745   8.123  1.00  0.00           C  
ATOM   1197  NH1 ARG A  73      -0.141  49.935   7.571  1.00  0.00           N  
ATOM   1198  NH2 ARG A  73      -1.549  48.209   8.123  1.00  0.00           N  
ATOM   1199  H   ARG A  73       4.041  51.244  11.189  1.00  0.00           H  
ATOM   1200  HA  ARG A  73       1.754  52.924  10.398  1.00  0.00           H  
ATOM   1201  HB2 ARG A  73       0.650  50.865   9.574  1.00  0.00           H  
ATOM   1202  HB3 ARG A  73       2.113  51.259   8.680  1.00  0.00           H  
ATOM   1203  HG2 ARG A  73       3.329  49.600  10.099  1.00  0.00           H  
ATOM   1204  HG3 ARG A  73       1.767  49.123  10.768  1.00  0.00           H  
ATOM   1205  HD2 ARG A  73       2.242  49.156   7.809  1.00  0.00           H  
ATOM   1206  HD3 ARG A  73       2.733  47.777   8.792  1.00  0.00           H  
ATOM   1207  HE  ARG A  73       0.515  47.214   9.077  1.00  0.00           H  
ATOM   1208 HH11 ARG A  73       0.774  50.340   7.569  1.00  0.00           H  
ATOM   1209 HH12 ARG A  73      -0.907  50.426   7.156  1.00  0.00           H  
ATOM   1210 HH21 ARG A  73      -1.700  47.313   8.539  1.00  0.00           H  
ATOM   1211 HH22 ARG A  73      -2.313  48.704   7.709  1.00  0.00           H  
ATOM   1212  N   PRO A  74       0.186  52.003  12.200  1.00  0.00           N  
ATOM   1213  CA  PRO A  74      -0.582  51.729  13.419  1.00  0.00           C  
ATOM   1214  C   PRO A  74      -0.950  50.256  13.553  1.00  0.00           C  
ATOM   1215  O   PRO A  74      -1.928  49.793  12.965  1.00  0.00           O  
ATOM   1216  CB  PRO A  74      -1.841  52.581  13.244  1.00  0.00           C  
ATOM   1217  CG  PRO A  74      -1.988  52.742  11.770  1.00  0.00           C  
ATOM   1218  CD  PRO A  74      -0.590  52.776  11.216  1.00  0.00           C  
ATOM   1219  HA  PRO A  74      -0.050  52.048  14.302  1.00  0.00           H  
ATOM   1220  HB2 PRO A  74      -2.690  52.067  13.672  1.00  0.00           H  
ATOM   1221  HB3 PRO A  74      -1.707  53.534  13.733  1.00  0.00           H  
ATOM   1222  HG2 PRO A  74      -2.533  51.905  11.361  1.00  0.00           H  
ATOM   1223  HG3 PRO A  74      -2.500  53.667  11.551  1.00  0.00           H  
ATOM   1224  HD2 PRO A  74      -0.558  52.307  10.245  1.00  0.00           H  
ATOM   1225  HD3 PRO A  74      -0.232  53.794  11.157  1.00  0.00           H  
ATOM   1226  N   LEU A  75      -0.162  49.522  14.332  1.00  0.00           N  
ATOM   1227  CA  LEU A  75      -0.406  48.101  14.545  1.00  0.00           C  
ATOM   1228  C   LEU A  75      -1.802  47.866  15.116  1.00  0.00           C  
ATOM   1229  O   LEU A  75      -2.353  48.726  15.801  1.00  0.00           O  
ATOM   1230  CB  LEU A  75       0.647  47.518  15.489  1.00  0.00           C  
ATOM   1231  CG  LEU A  75       0.395  46.092  15.979  1.00  0.00           C  
ATOM   1232  CD1 LEU A  75       0.887  45.080  14.955  1.00  0.00           C  
ATOM   1233  CD2 LEU A  75       1.069  45.863  17.324  1.00  0.00           C  
ATOM   1234  H   LEU A  75       0.601  49.947  14.775  1.00  0.00           H  
ATOM   1235  HA  LEU A  75      -0.334  47.605  13.589  1.00  0.00           H  
ATOM   1236  HB2 LEU A  75       1.595  47.527  14.972  1.00  0.00           H  
ATOM   1237  HB3 LEU A  75       0.707  48.161  16.356  1.00  0.00           H  
ATOM   1238  HG  LEU A  75      -0.668  45.945  16.108  1.00  0.00           H  
ATOM   1239 HD11 LEU A  75       1.074  44.137  15.443  1.00  0.00           H  
ATOM   1240 HD12 LEU A  75       1.800  45.440  14.505  1.00  0.00           H  
ATOM   1241 HD13 LEU A  75       0.136  44.948  14.190  1.00  0.00           H  
ATOM   1242 HD21 LEU A  75       1.010  46.764  17.915  1.00  0.00           H  
ATOM   1243 HD22 LEU A  75       2.105  45.602  17.167  1.00  0.00           H  
ATOM   1244 HD23 LEU A  75       0.571  45.057  17.844  1.00  0.00           H  
ATOM   1245  N   GLU A  76      -2.364  46.696  14.830  1.00  0.00           N  
ATOM   1246  CA  GLU A  76      -3.694  46.349  15.316  1.00  0.00           C  
ATOM   1247  C   GLU A  76      -3.866  46.769  16.774  1.00  0.00           C  
ATOM   1248  O   GLU A  76      -3.053  46.422  17.630  1.00  0.00           O  
ATOM   1249  CB  GLU A  76      -3.936  44.845  15.175  1.00  0.00           C  
ATOM   1250  CG  GLU A  76      -4.108  44.389  13.736  1.00  0.00           C  
ATOM   1251  CD  GLU A  76      -5.251  45.096  13.032  1.00  0.00           C  
ATOM   1252  OE1 GLU A  76      -6.420  44.811  13.367  1.00  0.00           O  
ATOM   1253  OE2 GLU A  76      -4.977  45.932  12.147  1.00  0.00           O  
ATOM   1254  H   GLU A  76      -1.873  46.052  14.279  1.00  0.00           H  
ATOM   1255  HA  GLU A  76      -4.416  46.880  14.714  1.00  0.00           H  
ATOM   1256  HB2 GLU A  76      -3.098  44.315  15.601  1.00  0.00           H  
ATOM   1257  HB3 GLU A  76      -4.830  44.585  15.722  1.00  0.00           H  
ATOM   1258  HG2 GLU A  76      -3.195  44.590  13.196  1.00  0.00           H  
ATOM   1259  HG3 GLU A  76      -4.303  43.327  13.729  1.00  0.00           H  
ATOM   1260  N   ARG A  77      -4.930  47.517  17.045  1.00  0.00           N  
ATOM   1261  CA  ARG A  77      -5.210  47.985  18.397  1.00  0.00           C  
ATOM   1262  C   ARG A  77      -5.661  46.833  19.290  1.00  0.00           C  
ATOM   1263  O   ARG A  77      -6.314  45.889  18.844  1.00  0.00           O  
ATOM   1264  CB  ARG A  77      -6.283  49.075  18.372  1.00  0.00           C  
ATOM   1265  CG  ARG A  77      -7.701  48.531  18.301  1.00  0.00           C  
ATOM   1266  CD  ARG A  77      -8.721  49.652  18.174  1.00  0.00           C  
ATOM   1267  NE  ARG A  77     -10.086  49.174  18.380  1.00  0.00           N  
ATOM   1268  CZ  ARG A  77     -10.795  48.550  17.446  1.00  0.00           C  
ATOM   1269  NH1 ARG A  77     -10.271  48.329  16.248  1.00  0.00           N  
ATOM   1270  NH2 ARG A  77     -12.031  48.146  17.708  1.00  0.00           N  
ATOM   1271  H   ARG A  77      -5.542  47.761  16.320  1.00  0.00           H  
ATOM   1272  HA  ARG A  77      -4.298  48.401  18.799  1.00  0.00           H  
ATOM   1273  HB2 ARG A  77      -6.195  49.672  19.267  1.00  0.00           H  
ATOM   1274  HB3 ARG A  77      -6.119  49.704  17.509  1.00  0.00           H  
ATOM   1275  HG2 ARG A  77      -7.786  47.884  17.440  1.00  0.00           H  
ATOM   1276  HG3 ARG A  77      -7.906  47.969  19.199  1.00  0.00           H  
ATOM   1277  HD2 ARG A  77      -8.500  50.407  18.913  1.00  0.00           H  
ATOM   1278  HD3 ARG A  77      -8.645  50.080  17.187  1.00  0.00           H  
ATOM   1279  HE  ARG A  77     -10.494  49.327  19.258  1.00  0.00           H  
ATOM   1280 HH11 ARG A  77      -9.340  48.632  16.047  1.00  0.00           H  
ATOM   1281 HH12 ARG A  77     -10.807  47.859  15.547  1.00  0.00           H  
ATOM   1282 HH21 ARG A  77     -12.430  48.310  18.610  1.00  0.00           H  
ATOM   1283 HH22 ARG A  77     -12.563  47.677  17.005  1.00  0.00           H  
ATOM   1284  N   PRO A  78      -5.304  46.908  20.581  1.00  0.00           N  
ATOM   1285  CA  PRO A  78      -5.661  45.880  21.562  1.00  0.00           C  
ATOM   1286  C   PRO A  78      -7.154  45.870  21.874  1.00  0.00           C  
ATOM   1287  O   PRO A  78      -7.937  46.567  21.228  1.00  0.00           O  
ATOM   1288  CB  PRO A  78      -4.858  46.280  22.803  1.00  0.00           C  
ATOM   1289  CG  PRO A  78      -4.642  47.746  22.658  1.00  0.00           C  
ATOM   1290  CD  PRO A  78      -4.524  48.004  21.181  1.00  0.00           C  
ATOM   1291  HA  PRO A  78      -5.357  44.896  21.236  1.00  0.00           H  
ATOM   1292  HB2 PRO A  78      -5.428  46.050  23.693  1.00  0.00           H  
ATOM   1293  HB3 PRO A  78      -3.922  45.742  22.818  1.00  0.00           H  
ATOM   1294  HG2 PRO A  78      -5.484  48.284  23.066  1.00  0.00           H  
ATOM   1295  HG3 PRO A  78      -3.732  48.034  23.161  1.00  0.00           H  
ATOM   1296  HD2 PRO A  78      -4.952  48.964  20.930  1.00  0.00           H  
ATOM   1297  HD3 PRO A  78      -3.491  47.956  20.870  1.00  0.00           H  
ATOM   1298  N   ALA A  79      -7.541  45.078  22.869  1.00  0.00           N  
ATOM   1299  CA  ALA A  79      -8.940  44.981  23.267  1.00  0.00           C  
ATOM   1300  C   ALA A  79      -9.235  45.884  24.460  1.00  0.00           C  
ATOM   1301  O   ALA A  79      -8.721  45.667  25.558  1.00  0.00           O  
ATOM   1302  CB  ALA A  79      -9.296  43.538  23.594  1.00  0.00           C  
ATOM   1303  H   ALA A  79      -6.869  44.547  23.345  1.00  0.00           H  
ATOM   1304  HA  ALA A  79      -9.548  45.295  22.431  1.00  0.00           H  
ATOM   1305  HB1 ALA A  79     -10.278  43.313  23.206  1.00  0.00           H  
ATOM   1306  HB2 ALA A  79      -8.570  42.878  23.143  1.00  0.00           H  
ATOM   1307  HB3 ALA A  79      -9.292  43.400  24.665  1.00  0.00           H  
ATOM   1308  N   LEU A  80     -10.065  46.897  24.237  1.00  0.00           N  
ATOM   1309  CA  LEU A  80     -10.428  47.835  25.294  1.00  0.00           C  
ATOM   1310  C   LEU A  80     -11.269  47.147  26.366  1.00  0.00           C  
ATOM   1311  O   LEU A  80     -12.434  46.819  26.139  1.00  0.00           O  
ATOM   1312  CB  LEU A  80     -11.197  49.021  24.709  1.00  0.00           C  
ATOM   1313  CG  LEU A  80     -12.629  48.735  24.257  1.00  0.00           C  
ATOM   1314  CD1 LEU A  80     -13.609  48.998  25.390  1.00  0.00           C  
ATOM   1315  CD2 LEU A  80     -12.983  49.575  23.038  1.00  0.00           C  
ATOM   1316  H   LEU A  80     -10.443  47.018  23.342  1.00  0.00           H  
ATOM   1317  HA  LEU A  80      -9.516  48.194  25.745  1.00  0.00           H  
ATOM   1318  HB2 LEU A  80     -11.236  49.793  25.461  1.00  0.00           H  
ATOM   1319  HB3 LEU A  80     -10.645  49.382  23.853  1.00  0.00           H  
ATOM   1320  HG  LEU A  80     -12.712  47.692  23.981  1.00  0.00           H  
ATOM   1321 HD11 LEU A  80     -14.348  48.211  25.418  1.00  0.00           H  
ATOM   1322 HD12 LEU A  80     -14.099  49.947  25.228  1.00  0.00           H  
ATOM   1323 HD13 LEU A  80     -13.075  49.025  26.329  1.00  0.00           H  
ATOM   1324 HD21 LEU A  80     -12.077  49.854  22.520  1.00  0.00           H  
ATOM   1325 HD22 LEU A  80     -13.506  50.464  23.355  1.00  0.00           H  
ATOM   1326 HD23 LEU A  80     -13.615  49.000  22.376  1.00  0.00           H  
ATOM   1327  N   ARG A  81     -10.671  46.937  27.534  1.00  0.00           N  
ATOM   1328  CA  ARG A  81     -11.366  46.290  28.641  1.00  0.00           C  
ATOM   1329  C   ARG A  81     -12.353  45.245  28.128  1.00  0.00           C  
ATOM   1330  O   ARG A  81     -13.536  45.275  28.466  1.00  0.00           O  
ATOM   1331  CB  ARG A  81     -12.101  47.331  29.487  1.00  0.00           C  
ATOM   1332  CG  ARG A  81     -13.149  48.115  28.713  1.00  0.00           C  
ATOM   1333  CD  ARG A  81     -14.295  48.551  29.612  1.00  0.00           C  
ATOM   1334  NE  ARG A  81     -15.318  47.517  29.737  1.00  0.00           N  
ATOM   1335  CZ  ARG A  81     -16.245  47.285  28.814  1.00  0.00           C  
ATOM   1336  NH1 ARG A  81     -16.276  48.011  27.704  1.00  0.00           N  
ATOM   1337  NH2 ARG A  81     -17.142  46.325  28.999  1.00  0.00           N  
ATOM   1338  H   ARG A  81      -9.741  47.221  27.654  1.00  0.00           H  
ATOM   1339  HA  ARG A  81     -10.626  45.797  29.255  1.00  0.00           H  
ATOM   1340  HB2 ARG A  81     -12.592  46.829  30.307  1.00  0.00           H  
ATOM   1341  HB3 ARG A  81     -11.380  48.029  29.884  1.00  0.00           H  
ATOM   1342  HG2 ARG A  81     -12.686  48.992  28.287  1.00  0.00           H  
ATOM   1343  HG3 ARG A  81     -13.539  47.491  27.923  1.00  0.00           H  
ATOM   1344  HD2 ARG A  81     -13.901  48.774  30.593  1.00  0.00           H  
ATOM   1345  HD3 ARG A  81     -14.743  49.440  29.195  1.00  0.00           H  
ATOM   1346  HE  ARG A  81     -15.313  46.968  30.549  1.00  0.00           H  
ATOM   1347 HH11 ARG A  81     -15.600  48.733  27.562  1.00  0.00           H  
ATOM   1348 HH12 ARG A  81     -16.974  47.833  27.010  1.00  0.00           H  
ATOM   1349 HH21 ARG A  81     -17.122  45.776  29.834  1.00  0.00           H  
ATOM   1350 HH22 ARG A  81     -17.839  46.152  28.304  1.00  0.00           H  
ATOM   1351  N   LYS A  82     -11.858  44.323  27.310  1.00  0.00           N  
ATOM   1352  CA  LYS A  82     -12.695  43.269  26.750  1.00  0.00           C  
ATOM   1353  C   LYS A  82     -13.674  42.739  27.794  1.00  0.00           C  
ATOM   1354  O   LYS A  82     -13.329  42.602  28.966  1.00  0.00           O  
ATOM   1355  CB  LYS A  82     -11.826  42.124  26.224  1.00  0.00           C  
ATOM   1356  CG  LYS A  82     -12.623  40.988  25.606  1.00  0.00           C  
ATOM   1357  CD  LYS A  82     -13.077  41.329  24.197  1.00  0.00           C  
ATOM   1358  CE  LYS A  82     -14.339  40.566  23.819  1.00  0.00           C  
ATOM   1359  NZ  LYS A  82     -14.681  40.739  22.380  1.00  0.00           N  
ATOM   1360  H   LYS A  82     -10.907  44.352  27.077  1.00  0.00           H  
ATOM   1361  HA  LYS A  82     -13.255  43.690  25.930  1.00  0.00           H  
ATOM   1362  HB2 LYS A  82     -11.154  42.514  25.474  1.00  0.00           H  
ATOM   1363  HB3 LYS A  82     -11.244  41.724  27.043  1.00  0.00           H  
ATOM   1364  HG2 LYS A  82     -12.004  40.104  25.570  1.00  0.00           H  
ATOM   1365  HG3 LYS A  82     -13.493  40.797  26.219  1.00  0.00           H  
ATOM   1366  HD2 LYS A  82     -13.281  42.387  24.139  1.00  0.00           H  
ATOM   1367  HD3 LYS A  82     -12.291  41.072  23.502  1.00  0.00           H  
ATOM   1368  HE2 LYS A  82     -14.184  39.517  24.020  1.00  0.00           H  
ATOM   1369  HE3 LYS A  82     -15.158  40.930  24.422  1.00  0.00           H  
ATOM   1370  HZ1 LYS A  82     -14.413  39.888  21.844  1.00  0.00           H  
ATOM   1371  HZ2 LYS A  82     -14.172  41.557  21.987  1.00  0.00           H  
ATOM   1372  HZ3 LYS A  82     -15.702  40.896  22.272  1.00  0.00           H  
ATOM   1373  N   GLU A  83     -14.894  42.442  27.357  1.00  0.00           N  
ATOM   1374  CA  GLU A  83     -15.921  41.927  28.255  1.00  0.00           C  
ATOM   1375  C   GLU A  83     -15.690  40.448  28.554  1.00  0.00           C  
ATOM   1376  O   GLU A  83     -15.646  39.619  27.647  1.00  0.00           O  
ATOM   1377  CB  GLU A  83     -17.310  42.123  27.643  1.00  0.00           C  
ATOM   1378  CG  GLU A  83     -17.678  43.581  27.425  1.00  0.00           C  
ATOM   1379  CD  GLU A  83     -19.142  43.767  27.078  1.00  0.00           C  
ATOM   1380  OE1 GLU A  83     -19.999  43.286  27.847  1.00  0.00           O  
ATOM   1381  OE2 GLU A  83     -19.430  44.394  26.036  1.00  0.00           O  
ATOM   1382  H   GLU A  83     -15.108  42.573  26.410  1.00  0.00           H  
ATOM   1383  HA  GLU A  83     -15.863  42.482  29.179  1.00  0.00           H  
ATOM   1384  HB2 GLU A  83     -17.345  41.617  26.690  1.00  0.00           H  
ATOM   1385  HB3 GLU A  83     -18.045  41.683  28.301  1.00  0.00           H  
ATOM   1386  HG2 GLU A  83     -17.466  44.132  28.329  1.00  0.00           H  
ATOM   1387  HG3 GLU A  83     -17.078  43.973  26.616  1.00  0.00           H  
ATOM   1388  N   GLY A  84     -15.542  40.126  29.836  1.00  0.00           N  
ATOM   1389  CA  GLY A  84     -15.316  38.749  30.234  1.00  0.00           C  
ATOM   1390  C   GLY A  84     -14.298  38.051  29.354  1.00  0.00           C  
ATOM   1391  O   GLY A  84     -14.646  37.168  28.569  1.00  0.00           O  
ATOM   1392  H   GLY A  84     -15.586  40.830  30.517  1.00  0.00           H  
ATOM   1393  HA2 GLY A  84     -14.965  38.734  31.254  1.00  0.00           H  
ATOM   1394  HA3 GLY A  84     -16.251  38.212  30.177  1.00  0.00           H  
ATOM   1395  N   LEU A  85     -13.037  38.447  29.482  1.00  0.00           N  
ATOM   1396  CA  LEU A  85     -11.964  37.855  28.690  1.00  0.00           C  
ATOM   1397  C   LEU A  85     -11.962  36.335  28.828  1.00  0.00           C  
ATOM   1398  O   LEU A  85     -12.007  35.611  27.834  1.00  0.00           O  
ATOM   1399  CB  LEU A  85     -10.611  38.421  29.124  1.00  0.00           C  
ATOM   1400  CG  LEU A  85      -9.491  38.355  28.086  1.00  0.00           C  
ATOM   1401  CD1 LEU A  85      -8.377  39.326  28.441  1.00  0.00           C  
ATOM   1402  CD2 LEU A  85      -8.951  36.938  27.972  1.00  0.00           C  
ATOM   1403  H   LEU A  85     -12.821  39.155  30.124  1.00  0.00           H  
ATOM   1404  HA  LEU A  85     -12.137  38.110  27.655  1.00  0.00           H  
ATOM   1405  HB2 LEU A  85     -10.756  39.457  29.390  1.00  0.00           H  
ATOM   1406  HB3 LEU A  85     -10.288  37.869  29.996  1.00  0.00           H  
ATOM   1407  HG  LEU A  85      -9.888  38.641  27.121  1.00  0.00           H  
ATOM   1408 HD11 LEU A  85      -8.659  40.323  28.139  1.00  0.00           H  
ATOM   1409 HD12 LEU A  85      -7.471  39.038  27.927  1.00  0.00           H  
ATOM   1410 HD13 LEU A  85      -8.207  39.306  29.507  1.00  0.00           H  
ATOM   1411 HD21 LEU A  85      -9.713  36.294  27.558  1.00  0.00           H  
ATOM   1412 HD22 LEU A  85      -8.671  36.580  28.952  1.00  0.00           H  
ATOM   1413 HD23 LEU A  85      -8.085  36.933  27.326  1.00  0.00           H  
ATOM   1414  N   LYS A  86     -11.910  35.860  30.068  1.00  0.00           N  
ATOM   1415  CA  LYS A  86     -11.904  34.426  30.338  1.00  0.00           C  
ATOM   1416  C   LYS A  86     -13.317  33.918  30.607  1.00  0.00           C  
ATOM   1417  O   LYS A  86     -14.272  34.695  30.635  1.00  0.00           O  
ATOM   1418  CB  LYS A  86     -11.003  34.115  31.535  1.00  0.00           C  
ATOM   1419  CG  LYS A  86     -11.439  34.799  32.819  1.00  0.00           C  
ATOM   1420  CD  LYS A  86     -12.446  33.957  33.585  1.00  0.00           C  
ATOM   1421  CE  LYS A  86     -12.759  34.564  34.944  1.00  0.00           C  
ATOM   1422  NZ  LYS A  86     -13.568  33.642  35.789  1.00  0.00           N  
ATOM   1423  H   LYS A  86     -11.875  36.487  30.820  1.00  0.00           H  
ATOM   1424  HA  LYS A  86     -11.514  33.926  29.464  1.00  0.00           H  
ATOM   1425  HB2 LYS A  86     -11.002  33.048  31.702  1.00  0.00           H  
ATOM   1426  HB3 LYS A  86      -9.997  34.436  31.305  1.00  0.00           H  
ATOM   1427  HG2 LYS A  86     -10.572  34.961  33.442  1.00  0.00           H  
ATOM   1428  HG3 LYS A  86     -11.891  35.750  32.574  1.00  0.00           H  
ATOM   1429  HD2 LYS A  86     -13.359  33.894  33.012  1.00  0.00           H  
ATOM   1430  HD3 LYS A  86     -12.038  32.967  33.727  1.00  0.00           H  
ATOM   1431  HE2 LYS A  86     -11.831  34.782  35.449  1.00  0.00           H  
ATOM   1432  HE3 LYS A  86     -13.313  35.480  34.795  1.00  0.00           H  
ATOM   1433  HZ1 LYS A  86     -14.435  33.365  35.287  1.00  0.00           H  
ATOM   1434  HZ2 LYS A  86     -13.830  34.111  36.679  1.00  0.00           H  
ATOM   1435  HZ3 LYS A  86     -13.020  32.787  36.010  1.00  0.00           H  
ATOM   1436  N   ASP A  87     -13.443  32.611  30.805  1.00  0.00           N  
ATOM   1437  CA  ASP A  87     -14.739  32.000  31.074  1.00  0.00           C  
ATOM   1438  C   ASP A  87     -14.715  31.233  32.393  1.00  0.00           C  
ATOM   1439  O   ASP A  87     -15.615  31.372  33.218  1.00  0.00           O  
ATOM   1440  CB  ASP A  87     -15.132  31.061  29.931  1.00  0.00           C  
ATOM   1441  CG  ASP A  87     -15.402  31.806  28.639  1.00  0.00           C  
ATOM   1442  OD1 ASP A  87     -14.572  32.659  28.261  1.00  0.00           O  
ATOM   1443  OD2 ASP A  87     -16.442  31.534  28.004  1.00  0.00           O  
ATOM   1444  H   ASP A  87     -12.645  32.043  30.770  1.00  0.00           H  
ATOM   1445  HA  ASP A  87     -15.470  32.790  31.145  1.00  0.00           H  
ATOM   1446  HB2 ASP A  87     -14.330  30.359  29.759  1.00  0.00           H  
ATOM   1447  HB3 ASP A  87     -16.024  30.521  30.209  1.00  0.00           H  
ATOM   1448  N   GLU A  88     -13.678  30.422  32.581  1.00  0.00           N  
ATOM   1449  CA  GLU A  88     -13.538  29.632  33.799  1.00  0.00           C  
ATOM   1450  C   GLU A  88     -13.742  30.500  35.037  1.00  0.00           C  
ATOM   1451  O   GLU A  88     -14.682  30.294  35.803  1.00  0.00           O  
ATOM   1452  CB  GLU A  88     -12.160  28.969  33.849  1.00  0.00           C  
ATOM   1453  CG  GLU A  88     -11.854  28.300  35.177  1.00  0.00           C  
ATOM   1454  CD  GLU A  88     -10.369  28.077  35.389  1.00  0.00           C  
ATOM   1455  OE1 GLU A  88      -9.780  27.261  34.650  1.00  0.00           O  
ATOM   1456  OE2 GLU A  88      -9.796  28.718  36.295  1.00  0.00           O  
ATOM   1457  H   GLU A  88     -12.992  30.354  31.885  1.00  0.00           H  
ATOM   1458  HA  GLU A  88     -14.296  28.863  33.784  1.00  0.00           H  
ATOM   1459  HB2 GLU A  88     -12.105  28.222  33.070  1.00  0.00           H  
ATOM   1460  HB3 GLU A  88     -11.406  29.721  33.666  1.00  0.00           H  
ATOM   1461  HG2 GLU A  88     -12.226  28.924  35.975  1.00  0.00           H  
ATOM   1462  HG3 GLU A  88     -12.354  27.343  35.207  1.00  0.00           H  
TER    1463      GLU A  88                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
