
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   85 (  723),  selected   85 , name 2f5k_B
# Molecule2: number of CA atoms   53 (  447),  selected   53 , name T0504_156_208.pdb
# PARAMETERS: 2f5k_B.T0504_156_208.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_B      -       -           -
LGA    P     7_B      -       -           -
LGA    K     8_B      M     156           #
LGA    P     9_B      V     157          5.216
LGA    K    10_B      L     158          1.575
LGA    F    11_B      L     159          1.462
LGA    Q    12_B      K     160          1.219
LGA    E    13_B      S     161          0.918
LGA    G    14_B      G     162          0.619
LGA    E    15_B      Q     163          0.232
LGA    R    16_B      L     164          0.235
LGA    V    17_B      I     165          0.428
LGA    L    18_B      K     166          0.543
LGA    C    19_B      T     167          0.442
LGA    F    20_B      E     168          0.978
LGA    H    21_B      W     169          1.185
LGA    G    22_B      E     170          2.757
LGA    P    23_B      G     171          1.216
LGA    L    24_B      T     172          1.081
LGA    L    25_B      W     173          1.004
LGA    Y    26_B      W     174          0.679
LGA    E    27_B      K     175          0.800
LGA    A    28_B      S     176          0.290
LGA    K    29_B      R     177          0.225
LGA    C    30_B      V     178          0.396
LGA    V    31_B      E     179          0.366
LGA    K    32_B      E     180          0.585
LGA    V    33_B      V     181          0.921
LGA    A    34_B      D     182          1.191
LGA    I    35_B      G     183          1.149
LGA    K    36_B      -       -           -
LGA    D    37_B      -       -           -
LGA    K    38_B      -       -           -
LGA    Q    39_B      -       -           -
LGA    V    40_B      S     184          1.579
LGA    K    41_B      L     185          1.146
LGA    Y    42_B      V     186          0.784
LGA    F    43_B      R     187          0.274
LGA    I    44_B      I     188          0.562
LGA    H    45_B      L     189          0.480
LGA    Y    46_B      F     190          0.671
LGA    S    47_B      L     191          1.187
LGA    G    48_B      D     192          1.555
LGA    W    49_B      D     193          1.075
LGA    N    50_B      K     194          2.872
LGA    K    51_B      R     195          3.048
LGA    N    52_B      -       -           -
LGA    W    53_B      -       -           -
LGA    D    54_B      C     196          0.771
LGA    E    55_B      E     197          0.791
LGA    W    56_B      W     198          0.247
LGA    V    57_B      I     199          0.819
LGA    P    58_B      Y     200          1.227
LGA    E    59_B      R     201          1.996
LGA    -       -      G     202           -
LGA    S    60_B      S     203          1.231
LGA    R    61_B      T     204          3.700
LGA    -       -      R     205           -
LGA    V    62_B      L     206          1.036
LGA    L    63_B      E     207          1.696
LGA    K    64_B      P     208          3.229
LGA    Y    65_B      -       -           -
LGA    V    66_B      -       -           -
LGA    D    67_B      -       -           -
LGA    T    68_B      -       -           -
LGA    N    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    Q    71_B      -       -           -
LGA    K    72_B      -       -           -
LGA    Q    73_B      -       -           -
LGA    R    74_B      -       -           -
LGA    E    75_B      -       -           -
LGA    L    76_B      -       -           -
LGA    Q    77_B      -       -           -
LGA    K    78_B      -       -           -
LGA    A    79_B      -       -           -
LGA    N    80_B      -       -           -
LGA    Q    81_B      -       -           -
LGA    E    82_B      -       -           -
LGA    Q    83_B      -       -           -
LGA    Y    84_B      -       -           -
LGA    A    85_B      -       -           -
LGA    E    86_B      -       -           -
LGA    G    87_B      -       -           -
LGA    K    88_B      -       -           -
LGA    M    89_B      -       -           -
LGA    R    90_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   85   53    5.0     50    1.55    12.00     89.896     3.039

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.881422 * X  +  -0.351152 * Y  +  -0.315892 * Z  +   8.059109
  Y_new =  -0.425117 * X  +   0.298328 * Y  +   0.854562 * Z  +  38.944180
  Z_new =  -0.205842 * X  +   0.887521 * Y  +  -0.412233 * Z  +  17.234787 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.005624   -1.135968  [ DEG:   114.9138    -65.0862 ]
  Theta =   0.207324    2.934269  [ DEG:    11.8788    168.1212 ]
  Phi   =  -2.692198    0.449395  [ DEG:  -154.2516     25.7484 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f5k_B                                        
REMARK     2: T0504_156_208.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f5k_B.T0504_156_208.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   85   53   5.0   50   1.55   12.00  89.896
REMARK  ---------------------------------------------------------- 
MOLECULE 2f5k_B
HEADER    GENE REGULATION                         26-NOV-05   2F5K              
TITLE     CRYSTAL STRUCTURE OF THE CHROMO DOMAIN OF HUMAN MRG15                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORF-RELATED GENE 15 ISOFORM 1;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-3E-HIS                                
KEYWDS    BETA BARREL, GENE REGULATION                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.ZHANG,J.DU,J.DING                                                   
REVDAT   2   25-DEC-07 2F5K    1       JRNL                                     
REVDAT   1   14-NOV-06 2F5K    0                                                
JRNL        AUTH   P.ZHANG,J.DU,B.SUN,X.DONG,G.XU,J.ZHOU,Q.HUANG,               
JRNL        AUTH 2 Q.LIU,Q.HAO,J.DING                                           
JRNL        TITL   STRUCTURE OF HUMAN MRG15 CHROMO DOMAIN AND ITS               
JRNL        TITL 2 BINDING TO LYS36-METHYLATED HISTONE H3.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  6621 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2F5K A    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K B    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K C    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K D    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K E    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K F    1    90  GB     5803102  NP_006782        1     90             
SEQRES   1 A  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 A  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 A  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 A  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 A  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 A  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 A  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 A  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 B  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 B  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 B  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 B  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 B  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 B  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 B  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 B  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 C  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 C  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 C  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 C  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 C  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 C  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 C  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 C  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 D  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 D  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 D  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 D  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 D  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 D  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 D  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 D  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 E  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 E  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 E  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 E  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 E  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 E  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 E  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 E  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 F  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 F  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 F  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 F  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 F  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 F  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 F  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 F  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
FORMUL   7  HOH   *457(H2 O)                                                    
CRYST1  109.480   80.313   81.285  90.00 123.91  90.00 C 1 2 1      24          
ATOM    705  N   ASP B   6      10.320  69.082  17.686  1.00 86.07           N  
ATOM    706  CA  ASP B   6       8.916  68.624  17.820  1.00 85.84           C  
ATOM    707  C   ASP B   6       8.645  68.333  19.293  1.00 84.75           C  
ATOM    708  O   ASP B   6       9.127  67.333  19.822  1.00 85.22           O  
ATOM    709  CB  ASP B   6       8.717  67.361  16.987  1.00 86.56           C  
ATOM    710  CG  ASP B   6       7.516  67.447  16.056  1.00 88.13           C  
ATOM    711  OD1 ASP B   6       6.368  67.489  16.559  1.00 89.16           O  
ATOM    712  OD2 ASP B   6       7.631  67.458  14.806  1.00 89.35           O  
ATOM    713  N   PRO B   7       7.892  69.213  19.956  1.00 83.26           N  
ATOM    714  CA  PRO B   7       7.582  69.052  21.385  1.00 81.19           C  
ATOM    715  C   PRO B   7       7.034  67.664  21.765  1.00 78.55           C  
ATOM    716  O   PRO B   7       7.622  66.983  22.620  1.00 78.85           O  
ATOM    717  CB  PRO B   7       6.529  70.144  21.637  1.00 81.77           C  
ATOM    718  CG  PRO B   7       6.839  71.209  20.623  1.00 82.83           C  
ATOM    719  CD  PRO B   7       7.302  70.448  19.396  1.00 83.49           C  
ATOM    720  N   LYS B   8       5.941  67.239  21.131  1.00 74.64           N  
ATOM    721  CA  LYS B   8       5.305  65.978  21.512  1.00 70.53           C  
ATOM    722  C   LYS B   8       5.482  64.796  20.537  1.00 66.37           C  
ATOM    723  O   LYS B   8       5.298  64.929  19.323  1.00 66.05           O  
ATOM    724  CB  LYS B   8       3.836  66.220  21.864  1.00 71.12           C  
ATOM    725  CG  LYS B   8       3.639  66.655  23.301  1.00 72.89           C  
ATOM    726  CD  LYS B   8       2.295  67.330  23.485  1.00 75.27           C  
ATOM    727  CE  LYS B   8       2.395  68.834  23.240  1.00 76.32           C  
ATOM    728  NZ  LYS B   8       1.137  69.507  23.671  1.00 76.64           N  
ATOM    729  N   PRO B   9       5.860  63.647  21.095  1.00 62.00           N  
ATOM    730  CA  PRO B   9       6.119  62.421  20.323  1.00 57.91           C  
ATOM    731  C   PRO B   9       4.862  61.650  19.945  1.00 53.09           C  
ATOM    732  O   PRO B   9       3.929  61.480  20.717  1.00 52.36           O  
ATOM    733  CB  PRO B   9       6.943  61.599  21.302  1.00 58.16           C  
ATOM    734  CG  PRO B   9       6.272  61.922  22.574  1.00 60.32           C  
ATOM    735  CD  PRO B   9       6.118  63.436  22.531  1.00 61.74           C  
ATOM    736  N   LYS B  10       4.858  61.143  18.737  1.00 48.25           N  
ATOM    737  CA  LYS B  10       3.692  60.456  18.233  1.00 43.87           C  
ATOM    738  C   LYS B  10       3.525  59.097  18.879  1.00 41.17           C  
ATOM    739  O   LYS B  10       2.418  58.587  19.004  1.00 39.77           O  
ATOM    740  CB  LYS B  10       3.833  60.326  16.726  1.00 43.59           C  
ATOM    741  CG  LYS B  10       2.737  59.563  16.035  1.00 40.29           C  
ATOM    742  CD  LYS B  10       2.866  59.824  14.581  1.00 37.36           C  
ATOM    743  CE  LYS B  10       1.769  59.129  13.796  1.00 36.53           C  
ATOM    744  NZ  LYS B  10       2.061  59.304  12.338  1.00 35.26           N  
ATOM    745  N   PHE B  11       4.623  58.523  19.342  1.00 38.49           N  
ATOM    746  CA  PHE B  11       4.543  57.192  19.931  1.00 36.96           C  
ATOM    747  C   PHE B  11       5.173  57.227  21.332  1.00 36.88           C  
ATOM    748  O   PHE B  11       5.909  58.114  21.622  1.00 35.43           O  
ATOM    749  CB  PHE B  11       5.305  56.193  19.059  1.00 35.53           C  
ATOM    750  CG  PHE B  11       4.727  56.011  17.677  1.00 33.09           C  
ATOM    751  CD1 PHE B  11       5.202  56.766  16.604  1.00 32.58           C  
ATOM    752  CD2 PHE B  11       3.702  55.109  17.445  1.00 28.67           C  
ATOM    753  CE1 PHE B  11       4.678  56.588  15.308  1.00 30.86           C  
ATOM    754  CE2 PHE B  11       3.168  54.946  16.157  1.00 28.65           C  
ATOM    755  CZ  PHE B  11       3.665  55.679  15.088  1.00 28.73           C  
ATOM    756  N   GLN B  12       4.887  56.259  22.184  1.00 37.35           N  
ATOM    757  CA  GLN B  12       5.556  56.209  23.472  1.00 37.93           C  
ATOM    758  C   GLN B  12       6.241  54.877  23.758  1.00 37.73           C  
ATOM    759  O   GLN B  12       5.974  53.849  23.118  1.00 36.06           O  
ATOM    760  CB  GLN B  12       4.559  56.439  24.564  1.00 38.80           C  
ATOM    761  CG  GLN B  12       3.637  55.309  24.693  1.00 41.80           C  
ATOM    762  CD  GLN B  12       2.567  55.597  25.684  1.00 47.41           C  
ATOM    763  OE1 GLN B  12       2.006  56.713  25.693  1.00 51.24           O  
ATOM    764  NE2 GLN B  12       2.258  54.607  26.534  1.00 47.90           N  
ATOM    765  N   GLU B  13       7.097  54.911  24.775  1.00 37.96           N  
ATOM    766  CA  GLU B  13       7.892  53.760  25.180  1.00 38.22           C  
ATOM    767  C   GLU B  13       7.010  52.646  25.587  1.00 35.99           C  
ATOM    768  O   GLU B  13       6.106  52.844  26.346  1.00 36.23           O  
ATOM    769  CB  GLU B  13       8.855  54.135  26.332  1.00 40.14           C  
ATOM    770  CG  GLU B  13       9.927  55.132  25.903  1.00 44.04           C  
ATOM    771  CD  GLU B  13      10.958  55.437  26.990  1.00 48.83           C  
ATOM    772  OE1 GLU B  13      11.203  54.547  27.854  1.00 48.30           O  
ATOM    773  OE2 GLU B  13      11.523  56.577  26.955  1.00 51.77           O  
ATOM    774  N   GLY B  14       7.259  51.457  25.076  1.00 34.60           N  
ATOM    775  CA  GLY B  14       6.417  50.336  25.434  1.00 32.73           C  
ATOM    776  C   GLY B  14       5.305  50.129  24.417  1.00 31.66           C  
ATOM    777  O   GLY B  14       4.684  49.072  24.406  1.00 31.63           O  
ATOM    778  N   GLU B  15       5.057  51.106  23.549  1.00 30.35           N  
ATOM    779  CA  GLU B  15       3.974  50.961  22.563  1.00 30.03           C  
ATOM    780  C   GLU B  15       4.353  49.975  21.458  1.00 29.76           C  
ATOM    781  O   GLU B  15       5.458  50.083  20.852  1.00 29.38           O  
ATOM    782  CB  GLU B  15       3.675  52.294  21.889  1.00 30.89           C  
ATOM    783  CG  GLU B  15       2.377  52.377  21.082  1.00 31.79           C  
ATOM    784  CD  GLU B  15       2.172  53.769  20.478  1.00 33.75           C  
ATOM    785  OE1 GLU B  15       2.821  54.725  20.933  1.00 33.19           O  
ATOM    786  OE2 GLU B  15       1.367  53.917  19.537  1.00 34.57           O  
ATOM    787  N   ARG B  16       3.459  49.015  21.224  1.00 28.23           N  
ATOM    788  CA  ARG B  16       3.588  48.102  20.126  1.00 28.03           C  
ATOM    789  C   ARG B  16       3.316  48.920  18.862  1.00 26.90           C  
ATOM    790  O   ARG B  16       2.353  49.687  18.786  1.00 26.70           O  
ATOM    791  CB  ARG B  16       2.563  46.978  20.251  1.00 27.75           C  
ATOM    792  CG  ARG B  16       2.561  46.050  19.059  1.00 31.69           C  
ATOM    793  CD  ARG B  16       1.633  44.828  19.211  1.00 36.95           C  
ATOM    794  NE  ARG B  16       0.288  45.275  19.532  1.00 40.35           N  
ATOM    795  CZ  ARG B  16      -0.821  44.520  19.472  1.00 42.98           C  
ATOM    796  NH1 ARG B  16      -0.791  43.250  19.073  1.00 43.50           N  
ATOM    797  NH2 ARG B  16      -1.977  45.075  19.783  1.00 43.43           N  
ATOM    798  N   VAL B  17       4.154  48.759  17.860  1.00 25.64           N  
ATOM    799  CA  VAL B  17       3.974  49.562  16.669  1.00 25.19           C  
ATOM    800  C   VAL B  17       4.220  48.742  15.414  1.00 23.90           C  
ATOM    801  O   VAL B  17       4.555  47.541  15.502  1.00 21.67           O  
ATOM    802  CB  VAL B  17       4.932  50.727  16.691  1.00 25.87           C  
ATOM    803  CG1 VAL B  17       4.770  51.492  15.475  1.00 30.80           C  
ATOM    804  CG2 VAL B  17       4.630  51.698  17.878  1.00 26.04           C  
ATOM    805  N   LEU B  18       4.021  49.362  14.254  1.00 22.86           N  
ATOM    806  CA  LEU B  18       4.439  48.733  13.016  1.00 24.97           C  
ATOM    807  C   LEU B  18       5.573  49.582  12.527  1.00 25.50           C  
ATOM    808  O   LEU B  18       5.548  50.795  12.687  1.00 27.32           O  
ATOM    809  CB  LEU B  18       3.341  48.706  11.964  1.00 25.40           C  
ATOM    810  CG  LEU B  18       2.193  47.738  12.197  1.00 26.79           C  
ATOM    811  CD1 LEU B  18       1.083  47.915  11.080  1.00 25.90           C  
ATOM    812  CD2 LEU B  18       2.782  46.329  12.153  1.00 27.83           C  
ATOM    813  N   CYS B  19       6.592  48.987  11.956  1.00 24.66           N  
ATOM    814  CA  CYS B  19       7.739  49.802  11.602  1.00 24.54           C  
ATOM    815  C   CYS B  19       8.325  49.332  10.307  1.00 25.41           C  
ATOM    816  O   CYS B  19       8.520  48.128  10.107  1.00 24.72           O  
ATOM    817  CB  CYS B  19       8.812  49.751  12.708  1.00 23.76           C  
ATOM    818  SG  CYS B  19      10.282  50.813  12.462  1.00 26.21           S  
ATOM    819  N   PHE B  20       8.691  50.286   9.453  1.00 26.72           N  
ATOM    820  CA  PHE B  20       9.357  49.956   8.184  1.00 28.76           C  
ATOM    821  C   PHE B  20      10.814  49.570   8.351  1.00 30.50           C  
ATOM    822  O   PHE B  20      11.555  50.251   9.036  1.00 31.12           O  
ATOM    823  CB  PHE B  20       9.332  51.139   7.227  1.00 28.20           C  
ATOM    824  CG  PHE B  20       8.075  51.236   6.445  1.00 30.54           C  
ATOM    825  CD1 PHE B  20       7.117  52.159   6.765  1.00 31.80           C  
ATOM    826  CD2 PHE B  20       7.843  50.375   5.402  1.00 32.57           C  
ATOM    827  CE1 PHE B  20       5.927  52.242   6.024  1.00 31.42           C  
ATOM    828  CE2 PHE B  20       6.693  50.459   4.668  1.00 33.11           C  
ATOM    829  CZ  PHE B  20       5.719  51.408   5.001  1.00 31.64           C  
ATOM    830  N   HIS B  21      11.225  48.503   7.673  1.00 32.28           N  
ATOM    831  CA  HIS B  21      12.613  48.146   7.638  1.00 34.78           C  
ATOM    832  C   HIS B  21      12.838  47.749   6.190  1.00 35.41           C  
ATOM    833  O   HIS B  21      12.437  46.676   5.762  1.00 35.64           O  
ATOM    834  CB  HIS B  21      12.906  46.993   8.597  1.00 36.34           C  
ATOM    835  CG  HIS B  21      14.351  46.644   8.651  1.00 39.19           C  
ATOM    836  ND1 HIS B  21      14.897  45.635   7.890  1.00 41.91           N  
ATOM    837  CD2 HIS B  21      15.374  47.204   9.334  1.00 42.44           C  
ATOM    838  CE1 HIS B  21      16.201  45.584   8.104  1.00 43.54           C  
ATOM    839  NE2 HIS B  21      16.518  46.525   8.978  1.00 44.52           N  
ATOM    840  N   GLY B  22      13.472  48.618   5.416  1.00 35.91           N  
ATOM    841  CA  GLY B  22      13.480  48.379   3.988  1.00 37.67           C  
ATOM    842  C   GLY B  22      12.057  48.610   3.479  1.00 37.68           C  
ATOM    843  O   GLY B  22      11.375  49.494   3.968  1.00 38.55           O  
ATOM    844  N   PRO B  23      11.610  47.826   2.520  1.00 38.07           N  
ATOM    845  CA  PRO B  23      10.280  47.987   1.917  1.00 37.87           C  
ATOM    846  C   PRO B  23       9.120  47.311   2.625  1.00 37.57           C  
ATOM    847  O   PRO B  23       8.015  47.313   2.094  1.00 38.49           O  
ATOM    848  CB  PRO B  23      10.482  47.322   0.548  1.00 38.30           C  
ATOM    849  CG  PRO B  23      11.340  46.099   0.938  1.00 38.39           C  
ATOM    850  CD  PRO B  23      12.384  46.737   1.867  1.00 38.80           C  
ATOM    851  N   LEU B  24       9.340  46.736   3.802  1.00 37.15           N  
ATOM    852  CA  LEU B  24       8.289  45.977   4.486  1.00 34.97           C  
ATOM    853  C   LEU B  24       8.023  46.490   5.880  1.00 32.79           C  
ATOM    854  O   LEU B  24       8.904  47.074   6.510  1.00 32.13           O  
ATOM    855  CB  LEU B  24       8.714  44.515   4.572  1.00 35.92           C  
ATOM    856  CG  LEU B  24       8.719  43.725   3.255  1.00 37.63           C  
ATOM    857  CD1 LEU B  24       9.412  42.367   3.454  1.00 37.39           C  
ATOM    858  CD2 LEU B  24       7.249  43.561   2.788  1.00 38.16           C  
ATOM    859  N   LEU B  25       6.804  46.270   6.336  1.00 30.98           N  
ATOM    860  CA  LEU B  25       6.333  46.676   7.653  1.00 30.10           C  
ATOM    861  C   LEU B  25       6.386  45.496   8.619  1.00 29.23           C  
ATOM    862  O   LEU B  25       5.864  44.433   8.328  1.00 28.12           O  
ATOM    863  CB  LEU B  25       4.886  47.196   7.602  1.00 29.97           C  
ATOM    864  CG  LEU B  25       4.757  48.670   7.218  1.00 29.53           C  
ATOM    865  CD1 LEU B  25       3.334  48.975   6.812  1.00 27.82           C  
ATOM    866  CD2 LEU B  25       5.230  49.586   8.350  1.00 27.53           C  
ATOM    867  N   TYR B  26       6.998  45.717   9.778  1.00 28.93           N  
ATOM    868  CA  TYR B  26       7.144  44.674  10.778  1.00 28.77           C  
ATOM    869  C   TYR B  26       6.552  45.099  12.103  1.00 27.65           C  
ATOM    870  O   TYR B  26       6.628  46.268  12.478  1.00 26.81           O  
ATOM    871  CB  TYR B  26       8.624  44.409  11.007  1.00 29.86           C  
ATOM    872  CG  TYR B  26       9.315  43.849   9.805  1.00 32.77           C  
ATOM    873  CD1 TYR B  26       9.962  44.678   8.891  1.00 35.95           C  
ATOM    874  CD2 TYR B  26       9.298  42.494   9.560  1.00 35.40           C  
ATOM    875  CE1 TYR B  26      10.590  44.140   7.753  1.00 38.38           C  
ATOM    876  CE2 TYR B  26       9.912  41.955   8.435  1.00 38.48           C  
ATOM    877  CZ  TYR B  26      10.557  42.775   7.546  1.00 38.96           C  
ATOM    878  OH  TYR B  26      11.172  42.213   6.455  1.00 40.91           O  
ATOM    879  N   GLU B  27       5.984  44.125  12.807  1.00 26.19           N  
ATOM    880  CA  GLU B  27       5.534  44.321  14.155  1.00 26.24           C  
ATOM    881  C   GLU B  27       6.757  44.697  15.007  1.00 25.83           C  
ATOM    882  O   GLU B  27       7.842  44.126  14.863  1.00 25.51           O  
ATOM    883  CB  GLU B  27       4.863  43.061  14.658  1.00 25.31           C  
ATOM    884  CG  GLU B  27       4.285  43.235  16.034  1.00 28.15           C  
ATOM    885  CD  GLU B  27       3.635  41.967  16.524  1.00 31.40           C  
ATOM    886  OE1 GLU B  27       3.350  41.072  15.699  1.00 33.35           O  
ATOM    887  OE2 GLU B  27       3.426  41.856  17.718  1.00 31.79           O  
ATOM    888  N   ALA B  28       6.607  45.699  15.842  1.00 26.14           N  
ATOM    889  CA  ALA B  28       7.723  46.163  16.643  1.00 27.30           C  
ATOM    890  C   ALA B  28       7.256  46.875  17.907  1.00 29.01           C  
ATOM    891  O   ALA B  28       6.056  47.124  18.090  1.00 29.26           O  
ATOM    892  CB  ALA B  28       8.596  47.099  15.823  1.00 25.81           C  
ATOM    893  N   LYS B  29       8.220  47.218  18.756  1.00 30.56           N  
ATOM    894  CA  LYS B  29       7.971  47.893  20.008  1.00 33.47           C  
ATOM    895  C   LYS B  29       8.910  49.105  20.201  1.00 34.73           C  
ATOM    896  O   LYS B  29      10.107  49.061  19.908  1.00 33.85           O  
ATOM    897  CB  LYS B  29       8.054  46.921  21.188  1.00 34.22           C  
ATOM    898  CG  LYS B  29       6.704  46.163  21.451  1.00 38.89           C  
ATOM    899  CD  LYS B  29       6.449  44.977  20.457  1.00 43.01           C  
ATOM    900  CE  LYS B  29       5.109  44.230  20.732  1.00 44.39           C  
ATOM    901  NZ  LYS B  29       4.826  43.049  19.804  1.00 44.99           N  
ATOM    902  N   CYS B  30       8.341  50.201  20.652  1.00 36.93           N  
ATOM    903  CA  CYS B  30       9.137  51.389  20.923  1.00 39.77           C  
ATOM    904  C   CYS B  30       9.847  51.189  22.267  1.00 41.44           C  
ATOM    905  O   CYS B  30       9.197  51.093  23.329  1.00 41.51           O  
ATOM    906  CB  CYS B  30       8.251  52.607  20.981  1.00 39.49           C  
ATOM    907  SG  CYS B  30       9.197  54.074  21.463  1.00 44.17           S  
ATOM    908  N   VAL B  31      11.162  51.067  22.230  1.00 42.97           N  
ATOM    909  CA  VAL B  31      11.885  50.840  23.482  1.00 45.01           C  
ATOM    910  C   VAL B  31      12.254  52.170  24.123  1.00 46.19           C  
ATOM    911  O   VAL B  31      12.141  52.338  25.320  1.00 45.73           O  
ATOM    912  CB  VAL B  31      13.155  49.980  23.281  1.00 45.02           C  
ATOM    913  CG1 VAL B  31      13.820  49.677  24.636  1.00 45.62           C  
ATOM    914  CG2 VAL B  31      12.809  48.680  22.562  1.00 45.43           C  
ATOM    915  N   LYS B  32      12.678  53.122  23.314  1.00 48.25           N  
ATOM    916  CA  LYS B  32      13.053  54.422  23.839  1.00 50.98           C  
ATOM    917  C   LYS B  32      12.694  55.560  22.890  1.00 52.15           C  
ATOM    918  O   LYS B  32      12.867  55.458  21.693  1.00 51.96           O  
ATOM    919  CB  LYS B  32      14.555  54.477  24.198  1.00 51.26           C  
ATOM    920  CG  LYS B  32      14.848  54.316  25.708  1.00 53.72           C  
ATOM    921  CD  LYS B  32      16.284  54.743  26.093  1.00 55.98           C  
ATOM    922  CE  LYS B  32      16.403  55.002  27.621  1.00 57.97           C  
ATOM    923  NZ  LYS B  32      17.802  54.979  28.163  1.00 57.06           N  
ATOM    924  N   VAL B  33      12.203  56.657  23.449  1.00 54.48           N  
ATOM    925  CA  VAL B  33      11.866  57.829  22.656  1.00 56.70           C  
ATOM    926  C   VAL B  33      12.931  58.878  22.915  1.00 58.98           C  
ATOM    927  O   VAL B  33      13.382  59.015  24.041  1.00 59.38           O  
ATOM    928  CB  VAL B  33      10.496  58.383  23.062  1.00 56.26           C  
ATOM    929  CG1 VAL B  33      10.139  59.606  22.233  1.00 55.79           C  
ATOM    930  CG2 VAL B  33       9.443  57.304  22.949  1.00 54.66           C  
ATOM    931  N   ALA B  34      13.357  59.590  21.877  1.00 61.82           N  
ATOM    932  CA  ALA B  34      14.358  60.645  22.036  1.00 64.49           C  
ATOM    933  C   ALA B  34      14.193  61.737  20.997  1.00 66.80           C  
ATOM    934  O   ALA B  34      13.912  61.468  19.825  1.00 66.82           O  
ATOM    935  CB  ALA B  34      15.748  60.082  21.972  1.00 64.39           C  
ATOM    936  N   ILE B  35      14.376  62.975  21.428  1.00 69.43           N  
ATOM    937  CA  ILE B  35      14.232  64.093  20.516  1.00 72.19           C  
ATOM    938  C   ILE B  35      15.577  64.736  20.228  1.00 73.92           C  
ATOM    939  O   ILE B  35      16.182  65.345  21.097  1.00 74.02           O  
ATOM    940  CB  ILE B  35      13.241  65.124  21.072  1.00 72.15           C  
ATOM    941  CG1 ILE B  35      11.861  64.482  21.237  1.00 72.15           C  
ATOM    942  CG2 ILE B  35      13.165  66.317  20.147  1.00 72.49           C  
ATOM    943  CD1 ILE B  35      10.858  65.337  21.957  1.00 71.70           C  
ATOM    944  N   LYS B  36      16.047  64.572  19.000  1.00 76.12           N  
ATOM    945  CA  LYS B  36      17.321  65.140  18.596  1.00 78.21           C  
ATOM    946  C   LYS B  36      17.121  66.265  17.587  1.00 79.07           C  
ATOM    947  O   LYS B  36      16.560  66.053  16.511  1.00 79.11           O  
ATOM    948  CB  LYS B  36      18.225  64.057  18.004  1.00 78.77           C  
ATOM    949  CG  LYS B  36      19.518  64.592  17.397  1.00 80.67           C  
ATOM    950  CD  LYS B  36      20.308  63.491  16.686  1.00 83.63           C  
ATOM    951  CE  LYS B  36      21.688  63.993  16.241  1.00 85.61           C  
ATOM    952  NZ  LYS B  36      22.450  62.989  15.445  1.00 86.71           N  
ATOM    953  N   ASP B  37      17.556  67.470  17.941  1.00 80.03           N  
ATOM    954  CA  ASP B  37      17.470  68.584  17.006  1.00 80.95           C  
ATOM    955  C   ASP B  37      16.023  68.851  16.633  1.00 80.66           C  
ATOM    956  O   ASP B  37      15.723  69.254  15.509  1.00 80.85           O  
ATOM    957  CB  ASP B  37      18.249  68.230  15.745  1.00 81.74           C  
ATOM    958  CG  ASP B  37      19.130  69.346  15.286  1.00 83.76           C  
ATOM    959  OD1 ASP B  37      18.788  70.514  15.576  1.00 85.51           O  
ATOM    960  OD2 ASP B  37      20.181  69.145  14.639  1.00 85.41           O  
ATOM    961  N   LYS B  38      15.133  68.591  17.580  1.00 80.09           N  
ATOM    962  CA  LYS B  38      13.693  68.733  17.391  1.00 79.20           C  
ATOM    963  C   LYS B  38      13.124  67.888  16.245  1.00 77.56           C  
ATOM    964  O   LYS B  38      12.179  68.270  15.568  1.00 77.64           O  
ATOM    965  CB  LYS B  38      13.289  70.196  17.289  1.00 80.01           C  
ATOM    966  CG  LYS B  38      12.217  70.563  18.294  1.00 82.13           C  
ATOM    967  CD  LYS B  38      11.790  72.015  18.133  1.00 85.95           C  
ATOM    968  CE  LYS B  38      10.596  72.364  19.023  1.00 87.83           C  
ATOM    969  NZ  LYS B  38      10.130  73.765  18.788  1.00 89.02           N  
ATOM    970  N   GLN B  39      13.744  66.742  16.017  1.00 75.32           N  
ATOM    971  CA  GLN B  39      13.178  65.740  15.143  1.00 72.93           C  
ATOM    972  C   GLN B  39      12.961  64.634  16.151  1.00 70.30           C  
ATOM    973  O   GLN B  39      13.715  64.533  17.126  1.00 70.23           O  
ATOM    974  CB  GLN B  39      14.160  65.295  14.054  1.00 73.58           C  
ATOM    975  CG  GLN B  39      14.560  66.371  13.037  1.00 74.92           C  
ATOM    976  CD  GLN B  39      13.422  66.806  12.130  1.00 76.27           C  
ATOM    977  OE1 GLN B  39      12.326  66.257  12.191  1.00 76.52           O  
ATOM    978  NE2 GLN B  39      13.680  67.801  11.293  1.00 76.89           N  
ATOM    979  N   VAL B  40      11.922  63.831  15.989  1.00 66.90           N  
ATOM    980  CA  VAL B  40      11.733  62.751  16.958  1.00 63.45           C  
ATOM    981  C   VAL B  40      12.323  61.461  16.416  1.00 60.27           C  
ATOM    982  O   VAL B  40      12.173  61.170  15.229  1.00 60.42           O  
ATOM    983  CB  VAL B  40      10.254  62.553  17.350  1.00 63.64           C  
ATOM    984  CG1 VAL B  40      10.152  61.825  18.683  1.00 63.01           C  
ATOM    985  CG2 VAL B  40       9.544  63.899  17.428  1.00 64.21           C  
ATOM    986  N   LYS B  41      13.011  60.713  17.280  1.00 56.35           N  
ATOM    987  CA  LYS B  41      13.627  59.439  16.906  1.00 52.31           C  
ATOM    988  C   LYS B  41      13.214  58.359  17.882  1.00 48.51           C  
ATOM    989  O   LYS B  41      12.920  58.648  19.036  1.00 48.09           O  
ATOM    990  CB  LYS B  41      15.146  59.569  16.847  1.00 53.02           C  
ATOM    991  CG  LYS B  41      15.645  60.212  15.569  1.00 54.73           C  
ATOM    992  CD  LYS B  41      17.163  60.138  15.453  1.00 56.73           C  
ATOM    993  CE  LYS B  41      17.659  60.943  14.276  1.00 58.27           C  
ATOM    994  NZ  LYS B  41      19.120  60.801  14.111  1.00 59.51           N  
ATOM    995  N   TYR B  42      13.143  57.124  17.414  1.00 43.83           N  
ATOM    996  CA  TYR B  42      12.709  56.038  18.287  1.00 40.31           C  
ATOM    997  C   TYR B  42      13.684  54.892  18.210  1.00 38.09           C  
ATOM    998  O   TYR B  42      14.259  54.643  17.160  1.00 37.68           O  
ATOM    999  CB  TYR B  42      11.278  55.535  17.945  1.00 39.54           C  
ATOM   1000  CG  TYR B  42      10.214  56.607  18.053  1.00 38.25           C  
ATOM   1001  CD1 TYR B  42      10.008  57.515  17.020  1.00 38.52           C  
ATOM   1002  CD2 TYR B  42       9.440  56.728  19.181  1.00 35.99           C  
ATOM   1003  CE1 TYR B  42       9.070  58.500  17.130  1.00 37.25           C  
ATOM   1004  CE2 TYR B  42       8.499  57.692  19.290  1.00 35.51           C  
ATOM   1005  CZ  TYR B  42       8.309  58.576  18.256  1.00 34.65           C  
ATOM   1006  OH  TYR B  42       7.359  59.544  18.361  1.00 31.58           O  
ATOM   1007  N   PHE B  43      13.856  54.203  19.331  1.00 36.11           N  
ATOM   1008  CA  PHE B  43      14.711  53.027  19.390  1.00 34.21           C  
ATOM   1009  C   PHE B  43      13.740  51.880  19.332  1.00 32.63           C  
ATOM   1010  O   PHE B  43      12.871  51.725  20.209  1.00 32.16           O  
ATOM   1011  CB  PHE B  43      15.550  52.998  20.693  1.00 34.87           C  
ATOM   1012  CG  PHE B  43      16.621  51.937  20.682  1.00 33.75           C  
ATOM   1013  CD1 PHE B  43      17.714  52.061  19.856  1.00 33.66           C  
ATOM   1014  CD2 PHE B  43      16.493  50.795  21.451  1.00 33.31           C  
ATOM   1015  CE1 PHE B  43      18.674  51.098  19.818  1.00 33.78           C  
ATOM   1016  CE2 PHE B  43      17.442  49.822  21.398  1.00 34.06           C  
ATOM   1017  CZ  PHE B  43      18.536  49.986  20.570  1.00 34.65           C  
ATOM   1018  N   ILE B  44      13.879  51.086  18.286  1.00 30.79           N  
ATOM   1019  CA  ILE B  44      12.915  50.042  17.958  1.00 29.63           C  
ATOM   1020  C   ILE B  44      13.478  48.655  18.115  1.00 29.09           C  
ATOM   1021  O   ILE B  44      14.604  48.363  17.656  1.00 29.25           O  
ATOM   1022  CB  ILE B  44      12.519  50.158  16.446  1.00 29.39           C  
ATOM   1023  CG1 ILE B  44      11.726  51.441  16.149  1.00 29.69           C  
ATOM   1024  CG2 ILE B  44      11.741  48.916  15.989  1.00 28.65           C  
ATOM   1025  CD1 ILE B  44      10.340  51.538  16.916  1.00 30.94           C  
ATOM   1026  N   HIS B  45      12.689  47.800  18.740  1.00 27.47           N  
ATOM   1027  CA  HIS B  45      12.973  46.382  18.735  1.00 26.32           C  
ATOM   1028  C   HIS B  45      11.911  45.681  17.886  1.00 25.55           C  
ATOM   1029  O   HIS B  45      10.695  45.848  18.119  1.00 24.96           O  
ATOM   1030  CB  HIS B  45      12.958  45.795  20.147  1.00 26.72           C  
ATOM   1031  CG  HIS B  45      13.013  44.301  20.147  1.00 28.13           C  
ATOM   1032  ND1 HIS B  45      11.913  43.522  20.436  1.00 28.46           N  
ATOM   1033  CD2 HIS B  45      13.996  43.446  19.776  1.00 28.75           C  
ATOM   1034  CE1 HIS B  45      12.230  42.248  20.281  1.00 29.42           C  
ATOM   1035  NE2 HIS B  45      13.490  42.172  19.891  1.00 28.79           N  
ATOM   1036  N   TYR B  46      12.358  44.947  16.882  1.00 23.98           N  
ATOM   1037  CA  TYR B  46      11.487  44.180  16.018  1.00 23.83           C  
ATOM   1038  C   TYR B  46      11.171  42.871  16.689  1.00 24.80           C  
ATOM   1039  O   TYR B  46      12.101  42.115  17.140  1.00 23.62           O  
ATOM   1040  CB  TYR B  46      12.145  43.906  14.694  1.00 24.04           C  
ATOM   1041  CG  TYR B  46      12.481  45.167  13.937  1.00 24.72           C  
ATOM   1042  CD1 TYR B  46      13.709  45.769  14.067  1.00 24.52           C  
ATOM   1043  CD2 TYR B  46      11.540  45.784  13.125  1.00 26.29           C  
ATOM   1044  CE1 TYR B  46      14.037  46.931  13.361  1.00 27.15           C  
ATOM   1045  CE2 TYR B  46      11.853  46.953  12.399  1.00 26.58           C  
ATOM   1046  CZ  TYR B  46      13.104  47.521  12.542  1.00 28.39           C  
ATOM   1047  OH  TYR B  46      13.434  48.698  11.871  1.00 30.83           O  
ATOM   1048  N   SER B  47       9.861  42.620  16.766  1.00 23.43           N  
ATOM   1049  CA  SER B  47       9.326  41.473  17.424  1.00 24.10           C  
ATOM   1050  C   SER B  47       9.797  40.222  16.747  1.00 24.31           C  
ATOM   1051  O   SER B  47       9.564  40.068  15.578  1.00 22.37           O  
ATOM   1052  CB  SER B  47       7.796  41.496  17.387  1.00 23.51           C  
ATOM   1053  OG  SER B  47       7.365  42.679  17.963  1.00 25.42           O  
ATOM   1054  N   GLY B  48      10.400  39.313  17.521  1.00 25.56           N  
ATOM   1055  CA  GLY B  48      10.853  38.037  16.990  1.00 27.37           C  
ATOM   1056  C   GLY B  48      12.260  38.164  16.463  1.00 29.50           C  
ATOM   1057  O   GLY B  48      12.847  37.190  15.997  1.00 30.89           O  
ATOM   1058  N   TRP B  49      12.827  39.357  16.509  1.00 30.07           N  
ATOM   1059  CA  TRP B  49      14.164  39.500  15.948  1.00 31.06           C  
ATOM   1060  C   TRP B  49      15.168  39.603  17.053  1.00 31.30           C  
ATOM   1061  O   TRP B  49      14.907  40.173  18.120  1.00 28.67           O  
ATOM   1062  CB  TRP B  49      14.366  40.756  15.081  1.00 31.03           C  
ATOM   1063  CG  TRP B  49      13.564  40.879  13.804  1.00 35.18           C  
ATOM   1064  CD1 TRP B  49      12.399  40.239  13.496  1.00 36.62           C  
ATOM   1065  CD2 TRP B  49      13.855  41.740  12.687  1.00 37.09           C  
ATOM   1066  NE1 TRP B  49      11.977  40.598  12.242  1.00 38.53           N  
ATOM   1067  CE2 TRP B  49      12.835  41.547  11.736  1.00 39.17           C  
ATOM   1068  CE3 TRP B  49      14.875  42.663  12.400  1.00 37.47           C  
ATOM   1069  CZ2 TRP B  49      12.803  42.250  10.518  1.00 39.16           C  
ATOM   1070  CZ3 TRP B  49      14.848  43.350  11.197  1.00 38.04           C  
ATOM   1071  CH2 TRP B  49      13.816  43.147  10.275  1.00 39.06           C  
ATOM   1072  N   ASN B  50      16.373  39.154  16.741  1.00 32.68           N  
ATOM   1073  CA  ASN B  50      17.428  39.336  17.706  1.00 35.01           C  
ATOM   1074  C   ASN B  50      17.710  40.820  17.997  1.00 34.68           C  
ATOM   1075  O   ASN B  50      17.511  41.712  17.147  1.00 33.13           O  
ATOM   1076  CB  ASN B  50      18.684  38.600  17.241  1.00 36.93           C  
ATOM   1077  CG  ASN B  50      19.780  38.755  18.200  1.00 40.82           C  
ATOM   1078  OD1 ASN B  50      19.660  38.367  19.362  1.00 46.91           O  
ATOM   1079  ND2 ASN B  50      20.809  39.416  17.780  1.00 43.40           N  
ATOM   1080  N   LYS B  51      18.152  41.079  19.217  1.00 35.47           N  
ATOM   1081  CA  LYS B  51      18.486  42.429  19.648  1.00 37.16           C  
ATOM   1082  C   LYS B  51      19.583  43.184  18.899  1.00 36.55           C  
ATOM   1083  O   LYS B  51      19.646  44.423  18.973  1.00 36.43           O  
ATOM   1084  CB  LYS B  51      18.794  42.447  21.141  1.00 38.14           C  
ATOM   1085  CG  LYS B  51      17.524  42.670  21.932  1.00 43.27           C  
ATOM   1086  CD  LYS B  51      17.795  43.204  23.331  1.00 49.68           C  
ATOM   1087  CE  LYS B  51      16.540  43.112  24.184  1.00 52.86           C  
ATOM   1088  NZ  LYS B  51      16.817  43.715  25.524  1.00 56.14           N  
ATOM   1089  N   ASN B  52      20.454  42.465  18.207  1.00 36.28           N  
ATOM   1090  CA  ASN B  52      21.470  43.128  17.378  1.00 36.72           C  
ATOM   1091  C   ASN B  52      20.776  43.918  16.271  1.00 36.75           C  
ATOM   1092  O   ASN B  52      21.378  44.770  15.611  1.00 36.40           O  
ATOM   1093  CB  ASN B  52      22.432  42.093  16.770  1.00 36.04           C  
ATOM   1094  CG  ASN B  52      23.252  41.349  17.851  1.00 35.99           C  
ATOM   1095  OD1 ASN B  52      23.371  41.792  19.023  1.00 31.98           O  
ATOM   1096  ND2 ASN B  52      23.805  40.200  17.456  1.00 36.42           N  
ATOM   1097  N   TRP B  53      19.498  43.612  16.065  1.00 36.65           N  
ATOM   1098  CA  TRP B  53      18.728  44.363  15.068  1.00 37.27           C  
ATOM   1099  C   TRP B  53      18.099  45.658  15.561  1.00 36.39           C  
ATOM   1100  O   TRP B  53      17.707  46.472  14.735  1.00 36.75           O  
ATOM   1101  CB  TRP B  53      17.657  43.500  14.444  1.00 37.93           C  
ATOM   1102  CG  TRP B  53      18.195  42.344  13.788  1.00 41.85           C  
ATOM   1103  CD1 TRP B  53      18.324  41.105  14.321  1.00 44.25           C  
ATOM   1104  CD2 TRP B  53      18.679  42.263  12.446  1.00 45.67           C  
ATOM   1105  NE1 TRP B  53      18.864  40.250  13.394  1.00 46.84           N  
ATOM   1106  CE2 TRP B  53      19.096  40.935  12.235  1.00 47.00           C  
ATOM   1107  CE3 TRP B  53      18.810  43.183  11.397  1.00 48.48           C  
ATOM   1108  CZ2 TRP B  53      19.627  40.486  11.026  1.00 50.62           C  
ATOM   1109  CZ3 TRP B  53      19.354  42.734  10.168  1.00 51.78           C  
ATOM   1110  CH2 TRP B  53      19.752  41.394  10.005  1.00 52.18           C  
ATOM   1111  N   ASP B  54      17.979  45.843  16.883  1.00 35.46           N  
ATOM   1112  CA  ASP B  54      17.369  47.053  17.438  1.00 35.13           C  
ATOM   1113  C   ASP B  54      18.041  48.276  16.836  1.00 35.95           C  
ATOM   1114  O   ASP B  54      19.251  48.275  16.611  1.00 37.52           O  
ATOM   1115  CB  ASP B  54      17.538  47.154  18.958  1.00 34.14           C  
ATOM   1116  CG  ASP B  54      16.967  45.985  19.714  1.00 32.78           C  
ATOM   1117  OD1 ASP B  54      16.305  45.086  19.148  1.00 33.32           O  
ATOM   1118  OD2 ASP B  54      17.156  45.895  20.927  1.00 30.50           O  
ATOM   1119  N   GLU B  55      17.302  49.348  16.615  1.00 36.07           N  
ATOM   1120  CA  GLU B  55      17.917  50.536  15.979  1.00 36.33           C  
ATOM   1121  C   GLU B  55      17.115  51.799  16.197  1.00 36.54           C  
ATOM   1122  O   GLU B  55      15.914  51.775  16.512  1.00 36.23           O  
ATOM   1123  CB  GLU B  55      18.086  50.358  14.484  1.00 35.64           C  
ATOM   1124  CG  GLU B  55      16.775  50.005  13.789  1.00 35.75           C  
ATOM   1125  CD  GLU B  55      16.868  49.896  12.273  1.00 35.87           C  
ATOM   1126  OE1 GLU B  55      15.891  49.469  11.623  1.00 35.00           O  
ATOM   1127  OE2 GLU B  55      17.928  50.225  11.710  1.00 38.10           O  
ATOM   1128  N   TRP B  56      17.802  52.905  16.014  1.00 36.41           N  
ATOM   1129  CA  TRP B  56      17.182  54.198  16.127  1.00 36.94           C  
ATOM   1130  C   TRP B  56      16.565  54.492  14.805  1.00 36.52           C  
ATOM   1131  O   TRP B  56      17.192  54.289  13.775  1.00 36.52           O  
ATOM   1132  CB  TRP B  56      18.204  55.261  16.506  1.00 36.75           C  
ATOM   1133  CG  TRP B  56      18.466  55.231  17.935  1.00 39.03           C  
ATOM   1134  CD1 TRP B  56      19.516  54.618  18.576  1.00 41.24           C  
ATOM   1135  CD2 TRP B  56      17.675  55.834  18.954  1.00 39.95           C  
ATOM   1136  NE1 TRP B  56      19.424  54.831  19.930  1.00 41.44           N  
ATOM   1137  CE2 TRP B  56      18.306  55.579  20.184  1.00 40.97           C  
ATOM   1138  CE3 TRP B  56      16.500  56.586  18.949  1.00 41.00           C  
ATOM   1139  CZ2 TRP B  56      17.793  56.022  21.388  1.00 43.49           C  
ATOM   1140  CZ3 TRP B  56      15.986  57.038  20.146  1.00 42.43           C  
ATOM   1141  CH2 TRP B  56      16.632  56.762  21.348  1.00 44.41           C  
ATOM   1142  N   VAL B  57      15.329  54.964  14.844  1.00 36.58           N  
ATOM   1143  CA  VAL B  57      14.560  55.217  13.619  1.00 36.57           C  
ATOM   1144  C   VAL B  57      13.828  56.542  13.752  1.00 36.59           C  
ATOM   1145  O   VAL B  57      13.303  56.857  14.822  1.00 36.14           O  
ATOM   1146  CB  VAL B  57      13.531  54.059  13.429  1.00 36.28           C  
ATOM   1147  CG1 VAL B  57      12.678  54.275  12.282  1.00 38.25           C  
ATOM   1148  CG2 VAL B  57      14.263  52.744  13.232  1.00 35.24           C  
ATOM   1149  N   PRO B  58      13.735  57.300  12.663  1.00 37.09           N  
ATOM   1150  CA  PRO B  58      12.993  58.559  12.690  1.00 37.71           C  
ATOM   1151  C   PRO B  58      11.496  58.233  12.594  1.00 37.42           C  
ATOM   1152  O   PRO B  58      11.113  57.156  12.112  1.00 37.19           O  
ATOM   1153  CB  PRO B  58      13.481  59.254  11.419  1.00 37.66           C  
ATOM   1154  CG  PRO B  58      13.561  58.109  10.466  1.00 38.28           C  
ATOM   1155  CD  PRO B  58      14.218  56.996  11.305  1.00 37.24           C  
ATOM   1156  N   GLU B  59      10.686  59.136  13.113  1.00 37.01           N  
ATOM   1157  CA  GLU B  59       9.240  59.038  13.124  1.00 37.71           C  
ATOM   1158  C   GLU B  59       8.613  58.498  11.847  1.00 36.72           C  
ATOM   1159  O   GLU B  59       7.742  57.648  11.903  1.00 37.20           O  
ATOM   1160  CB  GLU B  59       8.681  60.420  13.308  1.00 38.63           C  
ATOM   1161  CG  GLU B  59       8.572  60.841  14.737  1.00 43.19           C  
ATOM   1162  CD  GLU B  59       7.130  60.930  15.136  1.00 46.73           C  
ATOM   1163  OE1 GLU B  59       6.690  62.008  15.554  1.00 45.89           O  
ATOM   1164  OE2 GLU B  59       6.450  59.904  14.971  1.00 50.08           O  
ATOM   1165  N   SER B  60       9.036  59.043  10.719  1.00 35.45           N  
ATOM   1166  CA  SER B  60       8.537  58.662   9.411  1.00 35.27           C  
ATOM   1167  C   SER B  60       8.441  57.139   9.217  1.00 33.68           C  
ATOM   1168  O   SER B  60       7.550  56.677   8.614  1.00 33.52           O  
ATOM   1169  CB  SER B  60       9.378  59.335   8.317  1.00 35.49           C  
ATOM   1170  OG  SER B  60      10.129  58.407   7.547  1.00 38.24           O  
ATOM   1171  N   ARG B  61       9.358  56.347   9.749  1.00 33.00           N  
ATOM   1172  CA  ARG B  61       9.280  54.892   9.539  1.00 30.66           C  
ATOM   1173  C   ARG B  61       8.351  54.175  10.502  1.00 27.79           C  
ATOM   1174  O   ARG B  61       8.126  52.987  10.391  1.00 26.14           O  
ATOM   1175  CB  ARG B  61      10.673  54.308   9.648  1.00 31.84           C  
ATOM   1176  CG  ARG B  61      11.490  54.631   8.438  1.00 34.53           C  
ATOM   1177  CD  ARG B  61      12.914  54.203   8.504  1.00 35.63           C  
ATOM   1178  NE  ARG B  61      13.050  52.802   8.886  1.00 37.79           N  
ATOM   1179  CZ  ARG B  61      14.161  52.309   9.479  1.00 36.32           C  
ATOM   1180  NH1 ARG B  61      15.186  53.138   9.734  1.00 34.51           N  
ATOM   1181  NH2 ARG B  61      14.238  51.013   9.800  1.00 30.74           N  
ATOM   1182  N   VAL B  62       7.780  54.902  11.448  1.00 26.48           N  
ATOM   1183  CA  VAL B  62       6.975  54.223  12.465  1.00 25.96           C  
ATOM   1184  C   VAL B  62       5.501  54.399  12.249  1.00 25.58           C  
ATOM   1185  O   VAL B  62       5.060  55.496  12.015  1.00 25.14           O  
ATOM   1186  CB  VAL B  62       7.380  54.646  13.870  1.00 25.97           C  
ATOM   1187  CG1 VAL B  62       6.629  53.809  14.940  1.00 24.71           C  
ATOM   1188  CG2 VAL B  62       8.893  54.447  13.992  1.00 26.58           C  
ATOM   1189  N   LEU B  63       4.741  53.312  12.340  1.00 25.21           N  
ATOM   1190  CA  LEU B  63       3.292  53.387  12.139  1.00 25.75           C  
ATOM   1191  C   LEU B  63       2.481  52.829  13.312  1.00 25.90           C  
ATOM   1192  O   LEU B  63       2.860  51.834  13.936  1.00 26.14           O  
ATOM   1193  CB  LEU B  63       2.914  52.675  10.834  1.00 25.02           C  
ATOM   1194  CG  LEU B  63       3.250  53.389   9.506  1.00 27.11           C  
ATOM   1195  CD1 LEU B  63       2.914  52.458   8.370  1.00 28.09           C  
ATOM   1196  CD2 LEU B  63       2.379  54.706   9.330  1.00 27.69           C  
ATOM   1197  N   LYS B  64       1.359  53.457  13.600  1.00 25.87           N  
ATOM   1198  CA  LYS B  64       0.468  53.016  14.652  1.00 26.92           C  
ATOM   1199  C   LYS B  64      -0.090  51.591  14.375  1.00 27.11           C  
ATOM   1200  O   LYS B  64      -0.402  51.202  13.219  1.00 26.09           O  
ATOM   1201  CB  LYS B  64      -0.664  54.046  14.807  1.00 26.96           C  
ATOM   1202  CG  LYS B  64      -0.893  54.593  16.232  1.00 30.58           C  
ATOM   1203  CD  LYS B  64       0.123  55.510  16.762  1.00 32.37           C  
ATOM   1204  CE  LYS B  64      -0.243  55.872  18.176  1.00 32.40           C  
ATOM   1205  NZ  LYS B  64       0.794  56.398  19.074  1.00 27.99           N  
ATOM   1206  N   TYR B  65      -0.249  50.825  15.437  1.00 26.28           N  
ATOM   1207  CA  TYR B  65      -0.697  49.464  15.275  1.00 27.28           C  
ATOM   1208  C   TYR B  65      -2.233  49.423  15.190  1.00 27.15           C  
ATOM   1209  O   TYR B  65      -2.868  49.208  16.171  1.00 26.52           O  
ATOM   1210  CB  TYR B  65      -0.190  48.607  16.424  1.00 27.70           C  
ATOM   1211  CG  TYR B  65      -0.253  47.117  16.142  1.00 29.34           C  
ATOM   1212  CD1 TYR B  65       0.782  46.469  15.512  1.00 28.45           C  
ATOM   1213  CD2 TYR B  65      -1.373  46.361  16.511  1.00 30.86           C  
ATOM   1214  CE1 TYR B  65       0.713  45.070  15.254  1.00 29.56           C  
ATOM   1215  CE2 TYR B  65      -1.441  44.993  16.239  1.00 30.92           C  
ATOM   1216  CZ  TYR B  65      -0.386  44.364  15.618  1.00 30.94           C  
ATOM   1217  OH  TYR B  65      -0.463  42.999  15.336  1.00 33.70           O  
ATOM   1218  N   VAL B  66      -2.798  49.698  14.019  1.00 27.07           N  
ATOM   1219  CA  VAL B  66      -4.251  49.772  13.875  1.00 26.83           C  
ATOM   1220  C   VAL B  66      -4.652  49.134  12.562  1.00 27.97           C  
ATOM   1221  O   VAL B  66      -3.819  48.977  11.664  1.00 27.74           O  
ATOM   1222  CB  VAL B  66      -4.742  51.256  13.892  1.00 27.05           C  
ATOM   1223  CG1 VAL B  66      -4.631  51.878  15.284  1.00 23.57           C  
ATOM   1224  CG2 VAL B  66      -4.000  52.101  12.883  1.00 25.42           C  
ATOM   1225  N   ASP B  67      -5.926  48.761  12.436  1.00 29.40           N  
ATOM   1226  CA  ASP B  67      -6.388  48.074  11.230  1.00 30.16           C  
ATOM   1227  C   ASP B  67      -5.897  48.629   9.933  1.00 29.60           C  
ATOM   1228  O   ASP B  67      -5.426  47.907   9.095  1.00 30.93           O  
ATOM   1229  CB  ASP B  67      -7.912  47.919  11.240  1.00 30.77           C  
ATOM   1230  CG  ASP B  67      -8.369  47.014  12.348  1.00 35.05           C  
ATOM   1231  OD1 ASP B  67      -7.540  46.183  12.766  1.00 38.91           O  
ATOM   1232  OD2 ASP B  67      -9.503  47.059  12.898  1.00 38.57           O  
ATOM   1233  N   THR B  68      -6.000  49.914   9.737  1.00 29.63           N  
ATOM   1234  CA  THR B  68      -5.547  50.493   8.498  1.00 30.79           C  
ATOM   1235  C   THR B  68      -4.107  50.143   8.157  1.00 28.47           C  
ATOM   1236  O   THR B  68      -3.770  49.897   6.991  1.00 28.23           O  
ATOM   1237  CB  THR B  68      -5.708  52.040   8.565  1.00 31.94           C  
ATOM   1238  OG1 THR B  68      -7.075  52.328   8.328  1.00 38.38           O  
ATOM   1239  CG2 THR B  68      -5.109  52.697   7.353  1.00 34.14           C  
ATOM   1240  N   ASN B  69      -3.229  50.226   9.143  1.00 26.56           N  
ATOM   1241  CA  ASN B  69      -1.821  49.972   8.852  1.00 24.95           C  
ATOM   1242  C   ASN B  69      -1.555  48.493   8.789  1.00 23.84           C  
ATOM   1243  O   ASN B  69      -0.686  48.090   8.041  1.00 22.07           O  
ATOM   1244  CB  ASN B  69      -0.896  50.687   9.835  1.00 25.37           C  
ATOM   1245  CG  ASN B  69      -1.001  52.209   9.702  1.00 25.76           C  
ATOM   1246  OD1 ASN B  69      -1.224  52.755   8.602  1.00 24.39           O  
ATOM   1247  ND2 ASN B  69      -0.840  52.887  10.801  1.00 24.70           N  
ATOM   1248  N   LEU B  70      -2.313  47.675   9.524  1.00 24.03           N  
ATOM   1249  CA  LEU B  70      -2.135  46.213   9.382  1.00 26.09           C  
ATOM   1250  C   LEU B  70      -2.511  45.795   7.950  1.00 27.66           C  
ATOM   1251  O   LEU B  70      -1.811  44.997   7.338  1.00 27.74           O  
ATOM   1252  CB  LEU B  70      -2.983  45.441  10.373  1.00 26.02           C  
ATOM   1253  CG  LEU B  70      -2.384  45.406  11.787  1.00 27.15           C  
ATOM   1254  CD1 LEU B  70      -3.333  44.784  12.855  1.00 24.63           C  
ATOM   1255  CD2 LEU B  70      -0.944  44.723  11.764  1.00 27.27           C  
ATOM   1256  N   GLN B  71      -3.587  46.377   7.410  1.00 28.67           N  
ATOM   1257  CA  GLN B  71      -3.978  46.086   6.034  1.00 30.55           C  
ATOM   1258  C   GLN B  71      -2.859  46.540   5.069  1.00 30.62           C  
ATOM   1259  O   GLN B  71      -2.532  45.866   4.103  1.00 30.84           O  
ATOM   1260  CB  GLN B  71      -5.292  46.798   5.688  1.00 31.61           C  
ATOM   1261  CG  GLN B  71      -5.737  46.610   4.217  1.00 35.16           C  
ATOM   1262  CD  GLN B  71      -6.077  45.131   3.922  1.00 40.75           C  
ATOM   1263  OE1 GLN B  71      -6.560  44.410   4.806  1.00 41.48           O  
ATOM   1264  NE2 GLN B  71      -5.822  44.689   2.680  1.00 43.45           N  
ATOM   1265  N   LYS B  72      -2.244  47.677   5.347  1.00 30.21           N  
ATOM   1266  CA  LYS B  72      -1.178  48.120   4.472  1.00 29.85           C  
ATOM   1267  C   LYS B  72      -0.075  47.077   4.582  1.00 28.37           C  
ATOM   1268  O   LYS B  72       0.523  46.690   3.577  1.00 26.63           O  
ATOM   1269  CB  LYS B  72      -0.637  49.522   4.871  1.00 30.87           C  
ATOM   1270  CG  LYS B  72       0.696  49.961   4.131  1.00 33.81           C  
ATOM   1271  CD  LYS B  72       1.328  51.275   4.735  1.00 38.08           C  
ATOM   1272  CE  LYS B  72       0.533  52.546   4.381  1.00 39.48           C  
ATOM   1273  NZ  LYS B  72       0.665  52.797   2.961  1.00 40.91           N  
ATOM   1274  N   GLN B  73       0.197  46.631   5.808  1.00 27.37           N  
ATOM   1275  CA  GLN B  73       1.241  45.608   6.005  1.00 27.88           C  
ATOM   1276  C   GLN B  73       0.985  44.340   5.149  1.00 27.66           C  
ATOM   1277  O   GLN B  73       1.878  43.814   4.498  1.00 26.59           O  
ATOM   1278  CB  GLN B  73       1.400  45.207   7.481  1.00 27.24           C  
ATOM   1279  CG  GLN B  73       2.340  43.994   7.670  1.00 27.44           C  
ATOM   1280  CD  GLN B  73       2.521  43.553   9.140  1.00 28.83           C  
ATOM   1281  OE1 GLN B  73       1.538  43.377   9.862  1.00 31.20           O  
ATOM   1282  NE2 GLN B  73       3.770  43.356   9.557  1.00 27.22           N  
ATOM   1283  N   ARG B  74      -0.246  43.884   5.196  1.00 29.15           N  
ATOM   1284  CA  ARG B  74      -0.743  42.700   4.475  1.00 32.37           C  
ATOM   1285  C   ARG B  74      -0.500  42.910   2.954  1.00 32.51           C  
ATOM   1286  O   ARG B  74       0.033  42.031   2.256  1.00 33.01           O  
ATOM   1287  CB  ARG B  74      -2.246  42.643   4.752  1.00 33.32           C  
ATOM   1288  CG  ARG B  74      -2.893  41.292   4.885  1.00 39.67           C  
ATOM   1289  CD  ARG B  74      -4.025  41.212   5.997  1.00 42.47           C  
ATOM   1290  NE  ARG B  74      -3.451  41.037   7.333  1.00 46.93           N  
ATOM   1291  CZ  ARG B  74      -3.904  41.658   8.441  1.00 48.59           C  
ATOM   1292  NH1 ARG B  74      -4.943  42.490   8.354  1.00 49.10           N  
ATOM   1293  NH2 ARG B  74      -3.320  41.454   9.623  1.00 47.47           N  
ATOM   1294  N   GLU B  75      -0.866  44.107   2.484  1.00 31.30           N  
ATOM   1295  CA  GLU B  75      -0.757  44.481   1.088  1.00 30.99           C  
ATOM   1296  C   GLU B  75       0.687  44.528   0.641  1.00 30.66           C  
ATOM   1297  O   GLU B  75       0.989  44.121  -0.478  1.00 29.63           O  
ATOM   1298  CB  GLU B  75      -1.513  45.818   0.780  1.00 31.41           C  
ATOM   1299  CG  GLU B  75      -3.051  45.712   0.752  1.00 31.72           C  
ATOM   1300  CD  GLU B  75      -3.788  47.062   0.541  1.00 34.66           C  
ATOM   1301  OE1 GLU B  75      -3.164  48.099   0.306  1.00 33.67           O  
ATOM   1302  OE2 GLU B  75      -5.038  47.101   0.631  1.00 37.18           O  
ATOM   1303  N   LEU B  76       1.593  44.968   1.516  1.00 30.51           N  
ATOM   1304  CA  LEU B  76       3.003  45.015   1.132  1.00 31.71           C  
ATOM   1305  C   LEU B  76       3.596  43.611   1.088  1.00 32.75           C  
ATOM   1306  O   LEU B  76       4.478  43.339   0.290  1.00 32.44           O  
ATOM   1307  CB  LEU B  76       3.861  45.883   2.052  1.00 31.07           C  
ATOM   1308  CG  LEU B  76       3.641  47.387   2.097  1.00 31.65           C  
ATOM   1309  CD1 LEU B  76       4.595  47.975   3.093  1.00 31.54           C  
ATOM   1310  CD2 LEU B  76       3.914  47.946   0.722  1.00 32.05           C  
ATOM   1311  N   GLN B  77       3.136  42.729   1.971  1.00 34.03           N  
ATOM   1312  CA  GLN B  77       3.624  41.355   1.944  1.00 36.00           C  
ATOM   1313  C   GLN B  77       3.162  40.621   0.686  1.00 37.02           C  
ATOM   1314  O   GLN B  77       3.898  39.834   0.127  1.00 36.85           O  
ATOM   1315  CB  GLN B  77       3.179  40.613   3.188  1.00 35.88           C  
ATOM   1316  CG  GLN B  77       3.869  41.160   4.432  1.00 38.51           C  
ATOM   1317  CD  GLN B  77       3.230  40.676   5.726  1.00 39.41           C  
ATOM   1318  OE1 GLN B  77       2.063  40.273   5.748  1.00 39.97           O  
ATOM   1319  NE2 GLN B  77       3.997  40.708   6.797  1.00 40.35           N  
ATOM   1320  N   LYS B  78       1.928  40.863   0.282  1.00 38.92           N  
ATOM   1321  CA  LYS B  78       1.374  40.300  -0.929  1.00 41.56           C  
ATOM   1322  C   LYS B  78       2.168  40.803  -2.129  1.00 42.54           C  
ATOM   1323  O   LYS B  78       2.555  40.024  -2.992  1.00 42.05           O  
ATOM   1324  CB  LYS B  78      -0.074  40.781  -1.058  1.00 42.57           C  
ATOM   1325  CG  LYS B  78      -0.910  40.167  -2.179  1.00 45.65           C  
ATOM   1326  CD  LYS B  78      -2.348  40.705  -1.997  1.00 51.06           C  
ATOM   1327  CE  LYS B  78      -3.394  40.127  -2.966  1.00 53.63           C  
ATOM   1328  NZ  LYS B  78      -4.743  40.833  -2.831  1.00 53.87           N  
ATOM   1329  N   ALA B  79       2.401  42.121  -2.194  1.00 43.66           N  
ATOM   1330  CA  ALA B  79       3.161  42.690  -3.309  1.00 44.95           C  
ATOM   1331  C   ALA B  79       4.529  42.035  -3.384  1.00 46.22           C  
ATOM   1332  O   ALA B  79       5.061  41.760  -4.460  1.00 44.96           O  
ATOM   1333  CB  ALA B  79       3.315  44.202  -3.167  1.00 44.12           C  
ATOM   1334  N   ASN B  80       5.113  41.808  -2.221  1.00 48.51           N  
ATOM   1335  CA  ASN B  80       6.415  41.174  -2.188  1.00 51.03           C  
ATOM   1336  C   ASN B  80       6.352  39.706  -2.585  1.00 51.74           C  
ATOM   1337  O   ASN B  80       7.302  39.181  -3.124  1.00 51.02           O  
ATOM   1338  CB  ASN B  80       7.061  41.332  -0.829  1.00 51.85           C  
ATOM   1339  CG  ASN B  80       8.200  42.331  -0.847  1.00 55.25           C  
ATOM   1340  OD1 ASN B  80       7.997  43.534  -1.116  1.00 57.22           O  
ATOM   1341  ND2 ASN B  80       9.421  41.837  -0.598  1.00 56.82           N  
ATOM   1342  N   GLN B  81       5.234  39.054  -2.308  1.00 53.55           N  
ATOM   1343  CA  GLN B  81       5.068  37.657  -2.691  1.00 56.21           C  
ATOM   1344  C   GLN B  81       4.878  37.592  -4.201  1.00 57.28           C  
ATOM   1345  O   GLN B  81       5.323  36.649  -4.837  1.00 57.24           O  
ATOM   1346  CB  GLN B  81       3.890  36.990  -1.965  1.00 56.13           C  
ATOM   1347  CG  GLN B  81       4.307  36.202  -0.700  1.00 58.18           C  
ATOM   1348  CD  GLN B  81       4.131  36.976   0.628  1.00 59.81           C  
ATOM   1349  OE1 GLN B  81       3.004  37.110   1.135  1.00 59.22           O  
ATOM   1350  NE2 GLN B  81       5.248  37.455   1.201  1.00 60.46           N  
ATOM   1351  N   GLU B  82       4.236  38.614  -4.754  1.00 58.87           N  
ATOM   1352  CA  GLU B  82       4.007  38.696  -6.179  1.00 61.23           C  
ATOM   1353  C   GLU B  82       5.282  39.029  -6.913  1.00 63.06           C  
ATOM   1354  O   GLU B  82       5.394  38.769  -8.104  1.00 62.91           O  
ATOM   1355  CB  GLU B  82       2.950  39.732  -6.508  1.00 60.98           C  
ATOM   1356  CG  GLU B  82       1.536  39.223  -6.332  1.00 61.84           C  
ATOM   1357  CD  GLU B  82       0.521  40.353  -6.301  1.00 62.46           C  
ATOM   1358  OE1 GLU B  82      -0.692  40.071  -6.422  1.00 62.90           O  
ATOM   1359  OE2 GLU B  82       0.939  41.522  -6.147  1.00 61.57           O  
ATOM   1360  N   GLN B  83       6.244  39.606  -6.209  1.00 65.39           N  
ATOM   1361  CA  GLN B  83       7.506  39.908  -6.845  1.00 68.32           C  
ATOM   1362  C   GLN B  83       8.383  38.680  -6.823  1.00 70.26           C  
ATOM   1363  O   GLN B  83       9.118  38.433  -7.769  1.00 70.22           O  
ATOM   1364  CB  GLN B  83       8.203  41.083  -6.173  1.00 68.58           C  
ATOM   1365  CG  GLN B  83       7.567  42.416  -6.513  1.00 70.10           C  
ATOM   1366  CD  GLN B  83       8.328  43.595  -5.943  1.00 72.10           C  
ATOM   1367  OE1 GLN B  83       8.455  43.731  -4.718  1.00 72.49           O  
ATOM   1368  NE2 GLN B  83       8.834  44.455  -6.826  1.00 72.76           N  
ATOM   1369  N   TYR B  84       8.295  37.910  -5.738  1.00 72.79           N  
ATOM   1370  CA  TYR B  84       9.056  36.675  -5.597  1.00 75.51           C  
ATOM   1371  C   TYR B  84       8.491  35.606  -6.534  1.00 77.21           C  
ATOM   1372  O   TYR B  84       9.196  34.680  -6.925  1.00 77.06           O  
ATOM   1373  CB  TYR B  84       9.025  36.187  -4.147  1.00 75.78           C  
ATOM   1374  CG  TYR B  84       9.792  34.902  -3.894  1.00 77.27           C  
ATOM   1375  CD1 TYR B  84      11.181  34.903  -3.772  1.00 78.12           C  
ATOM   1376  CD2 TYR B  84       9.126  33.683  -3.765  1.00 78.36           C  
ATOM   1377  CE1 TYR B  84      11.884  33.727  -3.542  1.00 78.66           C  
ATOM   1378  CE2 TYR B  84       9.828  32.501  -3.529  1.00 78.87           C  
ATOM   1379  CZ  TYR B  84      11.201  32.533  -3.422  1.00 79.02           C  
ATOM   1380  OH  TYR B  84      11.891  31.366  -3.195  1.00 79.85           O  
ATOM   1381  N   ALA B  85       7.217  35.756  -6.894  1.00 79.48           N  
ATOM   1382  CA  ALA B  85       6.539  34.824  -7.779  1.00 81.77           C  
ATOM   1383  C   ALA B  85       6.984  35.075  -9.204  1.00 83.58           C  
ATOM   1384  O   ALA B  85       6.937  34.189 -10.044  1.00 83.96           O  
ATOM   1385  CB  ALA B  85       5.031  34.979  -7.663  1.00 81.67           C  
ATOM   1386  N   GLU B  86       7.433  36.288  -9.475  1.00 85.74           N  
ATOM   1387  CA  GLU B  86       7.847  36.633 -10.822  1.00 88.05           C  
ATOM   1388  C   GLU B  86       9.354  36.525 -10.994  1.00 89.07           C  
ATOM   1389  O   GLU B  86       9.888  36.801 -12.070  1.00 89.29           O  
ATOM   1390  CB  GLU B  86       7.314  38.016 -11.210  1.00 88.56           C  
ATOM   1391  CG  GLU B  86       5.792  38.045 -11.229  1.00 90.48           C  
ATOM   1392  CD  GLU B  86       5.199  39.434 -11.390  1.00 92.89           C  
ATOM   1393  OE1 GLU B  86       5.964  40.397 -11.633  1.00 94.11           O  
ATOM   1394  OE2 GLU B  86       3.956  39.555 -11.277  1.00 93.69           O  
ATOM   1395  N   GLY B  87      10.030  36.113  -9.931  1.00 90.09           N  
ATOM   1396  CA  GLY B  87      11.457  35.900  -9.988  1.00 91.42           C  
ATOM   1397  C   GLY B  87      11.661  34.449 -10.348  1.00 92.50           C  
ATOM   1398  O   GLY B  87      12.632  34.092 -11.018  1.00 92.53           O  
ATOM   1399  N   LYS B  88      10.716  33.621  -9.905  1.00 93.50           N  
ATOM   1400  CA  LYS B  88      10.746  32.183 -10.141  1.00 94.57           C  
ATOM   1401  C   LYS B  88      10.273  31.857 -11.551  1.00 95.56           C  
ATOM   1402  O   LYS B  88      10.365  30.715 -11.995  1.00 95.76           O  
ATOM   1403  CB  LYS B  88       9.885  31.450  -9.109  1.00 94.46           C  
ATOM   1404  CG  LYS B  88      10.451  31.486  -7.702  1.00 94.25           C  
ATOM   1405  CD  LYS B  88       9.481  30.935  -6.662  1.00 93.94           C  
ATOM   1406  CE  LYS B  88       9.518  29.412  -6.559  1.00 93.83           C  
ATOM   1407  NZ  LYS B  88       8.336  28.790  -7.202  1.00 93.60           N  
ATOM   1408  N   MET B  89       9.764  32.861 -12.256  1.00 96.61           N  
ATOM   1409  CA  MET B  89       9.302  32.655 -13.621  1.00 97.73           C  
ATOM   1410  C   MET B  89      10.362  33.059 -14.654  1.00 98.84           C  
ATOM   1411  O   MET B  89      10.079  33.103 -15.850  1.00 98.83           O  
ATOM   1412  CB  MET B  89       7.988  33.399 -13.874  1.00 97.48           C  
ATOM   1413  CG  MET B  89       6.732  32.628 -13.477  1.00 96.92           C  
ATOM   1414  SD  MET B  89       5.236  33.256 -14.293  1.00 96.00           S  
ATOM   1415  CE  MET B  89       4.659  34.483 -13.140  1.00 96.20           C  
ATOM   1416  N   ARG B  90      11.578  33.343 -14.191  1.00100.16           N  
ATOM   1417  CA  ARG B  90      12.670  33.729 -15.087  1.00101.50           C  
ATOM   1418  C   ARG B  90      13.934  32.897 -14.848  1.00101.66           C  
ATOM   1419  O   ARG B  90      14.911  33.343 -14.244  1.00101.72           O  
ATOM   1420  CB  ARG B  90      12.992  35.216 -14.934  1.00102.17           C  
ATOM   1421  CG  ARG B  90      13.567  35.575 -13.578  1.00104.50           C  
ATOM   1422  CD  ARG B  90      13.891  37.044 -13.411  1.00108.02           C  
ATOM   1423  NE  ARG B  90      14.587  37.309 -12.154  1.00110.75           N  
ATOM   1424  CZ  ARG B  90      14.671  38.509 -11.590  1.00112.52           C  
ATOM   1425  NH1 ARG B  90      14.103  39.560 -12.172  1.00113.19           N  
ATOM   1426  NH2 ARG B  90      15.326  38.665 -10.444  1.00113.32           N  
ATOM   1427  OXT ARG B  90      14.039  31.740 -15.258  1.00101.85           O  
TER    1428      ARG B  90                                                      
END
MOLECULE T0504_156_208.pdb
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58          
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91          
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72          
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80          
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27          
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73          
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88          
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77          
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68          
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94          
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31          
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02          
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19          
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70          
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12          
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86          
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34          
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76          
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71          
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52          
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91          
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36          
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38          
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39          
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82          
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48          
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98          
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19          
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71          
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84          
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14          
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05          
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85          
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53          
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66          
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77          
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29          
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32          
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60          
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59          
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08          
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57          
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74          
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20          
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82          
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39          
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79          
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54          
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96          
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12          
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51          
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64          
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76          
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65          
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28          
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12          
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38          
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12          
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39          
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12          
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66          
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46          
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68          
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83          
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29          
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79          
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92          
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19          
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22          
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55          
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94          
ATOM   1327  CD  ILE   165       6.209  52.315  15.886  1.00 31.23          
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32          
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55          
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72          
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69          
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62          
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02          
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39          
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70          
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81          
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59          
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66          
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59          
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49          
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44          
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65          
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70          
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83          
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50          
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37          
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23          
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42          
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75          
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02          
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37          
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81          
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83          
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47          
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48          
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67          
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31          
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92          
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33          
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61          
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22          
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95          
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43          
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18          
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32          
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82          
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67          
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81          
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65          
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53          
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22          
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81          
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48          
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91          
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38          
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53          
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91          
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93          
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29          
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97          
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96          
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58          
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03          
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14          
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39          
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72          
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96          
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58          
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06          
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62          
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25          
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07          
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76          
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53          
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95          
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13          
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72          
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76          
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92          
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47          
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94          
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59          
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02          
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27          
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02          
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07          
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96          
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25          
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15          
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78          
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29          
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76          
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16          
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08          
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93          
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03          
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12          
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58          
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08          
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32          
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83          
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01          
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96          
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78          
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65          
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82          
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57          
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13          
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30          
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50          
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23          
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69          
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37          
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78          
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90          
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76          
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41          
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84          
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54          
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82          
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67          
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14          
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15          
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17          
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26          
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41          
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74          
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77          
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35          
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94          
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10          
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30          
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27          
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60          
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02          
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04          
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81          
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78          
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10          
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01          
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48          
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67          
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28          
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92          
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88          
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40          
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39          
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18          
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81          
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39          
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32          
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58          
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76          
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51          
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24          
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81          
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85          
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36          
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04          
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46          
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63          
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34          
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28          
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60          
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82          
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12          
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15          
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45          
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55          
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99          
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01          
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84          
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91          
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02          
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76          
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01          
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62          
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91          
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03          
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69          
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74          
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00          
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67          
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49          
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21          
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37          
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33          
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21          
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88          
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64          
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81          
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28          
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49          
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90          
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02          
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12          
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09          
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66          
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30          
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33          
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61          
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16          
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49          
ATOM   1524  CD  ILE   188      10.070  52.171  17.195  1.00 22.12          
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97          
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24          
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98          
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53          
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66          
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05          
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76          
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44          
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56          
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30          
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61          
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27          
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14          
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24          
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90          
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65          
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09          
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22          
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07          
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13          
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23          
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45          
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88          
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39          
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37          
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18          
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11          
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76          
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98          
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06          
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15          
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12          
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35          
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17          
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49          
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48          
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20          
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84          
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46          
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90          
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22          
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81          
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17          
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73          
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40          
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81          
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79          
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00          
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11          
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34          
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22          
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08          
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25          
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17          
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60          
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73          
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18          
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44          
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65          
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06          
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18          
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07          
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04          
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77          
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81          
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67          
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17          
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89          
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26          
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76          
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18          
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50          
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36          
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74          
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30          
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31          
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51          
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61          
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47          
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94          
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12          
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46          
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05          
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37          
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69          
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54          
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80          
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60          
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83          
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73          
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65          
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44          
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23          
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26          
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58          
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43          
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27          
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13          
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58          
ATOM   1624  CD  ILE   199      12.999  52.559  12.729  1.00 20.55          
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51          
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19          
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92          
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19          
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38          
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91          
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47          
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20          
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57          
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44          
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50          
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12          
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97          
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26          
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54          
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69          
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36          
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88          
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58          
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28          
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92          
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45          
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56          
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01          
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86          
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26          
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88          
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49          
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20          
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50          
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52          
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94          
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80          
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15          
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74          
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11          
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13          
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63          
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86          
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83          
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24          
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93          
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95          
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76          
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56          
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52          
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50          
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97          
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21          
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11          
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43          
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70          
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63          
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00          
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37          
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66          
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91          
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37          
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02          
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72          
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09          
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64          
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26          
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27          
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33          
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61          
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10          
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09          
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83          
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60          
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76          
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26          
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94          
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04          
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06          
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74          
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96          
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24          
END
