
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 2097),  selected  133 , name 1wgs_A
# Molecule2: number of CA atoms  208 ( 1702),  selected  208 , name T0504.pdb
# PARAMETERS: 1wgs_A.T0504.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      Q       6           -
LGA    G     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    V    11_A      G       7          5.260
LGA    T    12_A      D       8          3.237
LGA    V    13_A      L       9          1.709
LGA    E    14_A      I      10          2.081
LGA    I    15_A      V      11          1.629
LGA    G    16_A      S      12          1.193
LGA    E    17_A      M      13          1.083
LGA    T    18_A      R      14          1.309
LGA    Y    19_A      I      15          1.163
LGA    L    20_A      L      16          1.145
LGA    C    21_A      G      17          0.905
LGA    R    22_A      K      18          1.423
LGA    R    23_A      K      19          2.446
LGA    P    24_A      R      20          3.002
LGA    D    25_A      T      21          2.907
LGA    S    26_A      K      22          3.532
LGA    T    27_A      T      23          1.624
LGA    W    28_A      W      24          0.753
LGA    H    29_A      H      25          1.112
LGA    S    30_A      K      26          1.392
LGA    A    31_A      G      27          1.535
LGA    E    32_A      T      28          0.360
LGA    V    33_A      L      29          0.421
LGA    I    34_A      I      30          0.716
LGA    Q    35_A      A      31          1.981
LGA    S    36_A      I      32          1.363
LGA    R    37_A      Q      33          1.564
LGA    V    38_A      T      34          0.806
LGA    N    39_A      V      35          0.894
LGA    D    40_A      G      36          2.246
LGA    Q    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    G    43_A      P      37          2.622
LGA    R    44_A      G      38          0.416
LGA    E    45_A      K      39          0.490
LGA    E    46_A      K      40          1.066
LGA    F    47_A      Y      41          1.429
LGA    Y    48_A      K      42          1.389
LGA    V    49_A      V      43          0.912
LGA    H    50_A      K      44          0.506
LGA    Y    51_A      F      45          0.761
LGA    V    52_A      D      46          0.847
LGA    G    53_A      N      47          1.281
LGA    F    54_A      K      48          1.726
LGA    N    55_A      G      49          3.605
LGA    R    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    D    59_A      K      50          1.655
LGA    E    60_A      S      51          2.623
LGA    W    61_A      L      52          1.871
LGA    V    62_A      L      53          1.260
LGA    D    63_A      S      54          1.242
LGA    K    64_A      G      55          0.861
LGA    N    65_A      N      56          0.464
LGA    R    66_A      H      57          0.605
LGA    L    67_A      I      58          0.775
LGA    A    68_A      A      59          1.167
LGA    L    69_A      Y      60          4.914
LGA    -       -      D      61           -
LGA    -       -      Y      62           -
LGA    T    70_A      H      63           #
LGA    K    71_A      P      64          5.048
LGA    -       -      P      65           -
LGA    -       -      A      66           -
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    -       -      L      69           -
LGA    -       -      Y      70           -
LGA    -       -      V      71           -
LGA    -       -      G      72           -
LGA    T    72_A      S      73          3.833
LGA    V    73_A      R      74          2.788
LGA    K    74_A      V      75          2.253
LGA    D    75_A      V      76          2.352
LGA    -       -      A      77           -
LGA    -       -      K      78           -
LGA    -       -      Y      79           -
LGA    -       -      K      80           -
LGA    -       -      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    -       -      Q      84           -
LGA    -       -      V      85           -
LGA    -       -      W      86           -
LGA    -       -      L      87           -
LGA    -       -      Y      88           -
LGA    -       -      A      89           -
LGA    -       -      G      90           -
LGA    -       -      I      91           -
LGA    -       -      V      92           -
LGA    -       -      A      93           -
LGA    -       -      E      94           -
LGA    -       -      T      95           -
LGA    -       -      P      96           -
LGA    -       -      N      97           -
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    -       -      L     102           -
LGA    -       -      R     103           -
LGA    -       -      F     104           -
LGA    -       -      L     105           -
LGA    A    76_A      I     106          5.176
LGA    V    77_A      F     107           -
LGA    -       -      F     108           -
LGA    -       -      D     109           -
LGA    -       -      D     110           -
LGA    -       -      G     111           -
LGA    -       -      Y     112           -
LGA    -       -      A     113           -
LGA    -       -      S     114           -
LGA    Q    78_A      Y     115          4.543
LGA    K    79_A      V     116          3.313
LGA    -       -      T     117           -
LGA    N    80_A      Q     118          3.445
LGA    S    81_A      S     119          1.923
LGA    E    82_A      E     120           #
LGA    K    83_A      L     121           -
LGA    Y    84_A      Y     122           -
LGA    L    85_A      P     123           -
LGA    S    86_A      I     124           -
LGA    E    87_A      C     125           -
LGA    L    88_A      R     126           -
LGA    A    89_A      P     127           -
LGA    E    90_A      L     128           -
LGA    Q    91_A      K     129           -
LGA    P    92_A      K     130           -
LGA    E    93_A      T     131           -
LGA    R    94_A      W     132           -
LGA    K    95_A      E     133           -
LGA    I    96_A      D     134           -
LGA    T    97_A      I     135           -
LGA    R    98_A      E     136           -
LGA    N    99_A      D     137           -
LGA    Q   100_A      I     138           -
LGA    K   101_A      S     139           -
LGA    R   102_A      C     140           -
LGA    K   103_A      R     141           -
LGA    H   104_A      D     142           -
LGA    D   105_A      F     143           -
LGA    E   106_A      I     144           -
LGA    I   107_A      E     145           -
LGA    N   108_A      E     146           -
LGA    H   109_A      Y     147           -
LGA    V   110_A      V     148           -
LGA    Q   111_A      T     149           -
LGA    K   112_A      A     150           -
LGA    T   113_A      Y     151           -
LGA    Y   114_A      P     152           -
LGA    A   115_A      N     153           -
LGA    E   116_A      R     154           -
LGA    M   117_A      P     155           -
LGA    D   118_A      M     156           -
LGA    P   119_A      V     157           -
LGA    T   120_A      L     158           -
LGA    T   121_A      L     159           -
LGA    A   122_A      K     160           -
LGA    A   123_A      S     161           -
LGA    L   124_A      G     162           -
LGA    E   125_A      Q     163           -
LGA    K   126_A      L     164           -
LGA    E   127_A      I     165           -
LGA    S   128_A      K     166           -
LGA    G   129_A      T     167           -
LGA    P   130_A      E     168           -
LGA    S   131_A      W     169           -
LGA    S   132_A      E     170           -
LGA    G   133_A      G     171           -
LGA    -       -      T     172           -
LGA    -       -      W     173           -
LGA    -       -      W     174           -
LGA    -       -      K     175           -
LGA    -       -      S     176           -
LGA    -       -      R     177           -
LGA    -       -      V     178           -
LGA    -       -      E     179           -
LGA    -       -      E     180           -
LGA    -       -      V     181           -
LGA    -       -      D     182           -
LGA    -       -      G     183           -
LGA    -       -      S     184           -
LGA    -       -      L     185           -
LGA    -       -      V     186           -
LGA    -       -      R     187           -
LGA    -       -      I     188           -
LGA    -       -      L     189           -
LGA    -       -      F     190           -
LGA    -       -      L     191           -
LGA    -       -      D     192           -
LGA    -       -      D     193           -
LGA    -       -      K     194           -
LGA    -       -      R     195           -
LGA    -       -      C     196           -
LGA    -       -      E     197           -
LGA    -       -      W     198           -
LGA    -       -      I     199           -
LGA    -       -      Y     200           -
LGA    -       -      R     201           -
LGA    -       -      G     202           -
LGA    -       -      S     203           -
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    -       -      L     206           -
LGA    -       -      E     207           -
LGA    -       -      P     208           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  208    5.0     64    2.26    14.06     25.298     2.713

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.361399 * X  +   0.567830 * Y  +   0.739567 * Z  +  13.143391
  Y_new =  -0.234775 * X  +  -0.823039 * Y  +   0.517193 * Z  +  58.078384
  Z_new =   0.902370 * X  +   0.013282 * Y  +   0.430758 * Z  +  50.274647 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.030823   -3.110770  [ DEG:     1.7660   -178.2340 ]
  Theta =  -1.125237   -2.016355  [ DEG:   -64.4714   -115.5286 ]
  Phi   =  -2.565480    0.576113  [ DEG:  -146.9912     33.0088 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wgs_A                                        
REMARK     2: T0504.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wgs_A.T0504.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  208   5.0   64   2.26   14.06  25.298
REMARK  ---------------------------------------------------------- 
MOLECULE 1wgs_A
HEADER    TRANSFERASE                             28-MAY-04   1WGS              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE                     
TITLE    2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                           
TITLE    3 ACETYLTRANSFERASE                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYST HISTONE ACETYLTRANSFERASE 1;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN 5830450F21RIK;                         
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 5830450F21;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P031110-09;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, MYST FAMILY, HISTONE ACETYLTRANFERASE,                  
KEYWDS   2 STRUCTURAL GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   3 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN              
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   28-NOV-04 1WGS    0                                                
JRNL        AUTH   H.LI,K.SAITO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA           
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN FROM MOUSE            
JRNL        TITL 2 HYPOTHETICAL PROTEIN HOMOLOGOUS TO HISTONE                   
JRNL        TITL 3 ACETYLTRANSFERASE                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WGS A    8   127  UNP    Q9D1P2   MYST1_MOUSE     50    169             
SEQRES   1 A  133  GLY SER SER GLY SER SER GLY GLU PRO GLU VAL THR VAL          
SEQRES   2 A  133  GLU ILE GLY GLU THR TYR LEU CYS ARG ARG PRO ASP SER          
SEQRES   3 A  133  THR TRP HIS SER ALA GLU VAL ILE GLN SER ARG VAL ASN          
SEQRES   4 A  133  ASP GLN GLU GLY ARG GLU GLU PHE TYR VAL HIS TYR VAL          
SEQRES   5 A  133  GLY PHE ASN ARG ARG LEU ASP GLU TRP VAL ASP LYS ASN          
SEQRES   6 A  133  ARG LEU ALA LEU THR LYS THR VAL LYS ASP ALA VAL GLN          
SEQRES   7 A  133  LYS ASN SER GLU LYS TYR LEU SER GLU LEU ALA GLU GLN          
SEQRES   8 A  133  PRO GLU ARG LYS ILE THR ARG ASN GLN LYS ARG LYS HIS          
SEQRES   9 A  133  ASP GLU ILE ASN HIS VAL GLN LYS THR TYR ALA GLU MET          
SEQRES  10 A  133  ASP PRO THR THR ALA ALA LEU GLU LYS GLU SER GLY PRO          
SEQRES  11 A  133  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       8.868  84.159  10.408  1.00  0.00           N  
ATOM      2  CA  GLY A   1       8.676  84.443   8.997  1.00  0.00           C  
ATOM      3  C   GLY A   1       9.820  83.868   8.160  1.00  0.00           C  
ATOM      4  O   GLY A   1      10.044  82.659   8.156  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       7.728  84.020   8.662  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       8.614  85.521   8.845  1.00  0.00           H  
ATOM      7  H1  GLY A   1       9.736  83.716  10.635  1.00  0.00           H  
ATOM      8  N   SER A   2      10.514  84.762   7.471  1.00  0.00           N  
ATOM      9  CA  SER A   2      11.630  84.359   6.633  1.00  0.00           C  
ATOM     10  C   SER A   2      11.148  83.390   5.551  1.00  0.00           C  
ATOM     11  O   SER A   2      10.894  82.219   5.829  1.00  0.00           O  
ATOM     12  CB  SER A   2      12.741  83.715   7.466  1.00  0.00           C  
ATOM     13  OG  SER A   2      13.662  84.680   7.964  1.00  0.00           O  
ATOM     14  H   SER A   2      10.325  85.743   7.480  1.00  0.00           H  
ATOM     15  HA  SER A   2      12.001  85.280   6.183  1.00  0.00           H  
ATOM     16  HB2 SER A   2      12.299  83.171   8.299  1.00  0.00           H  
ATOM     17  HB3 SER A   2      13.275  82.986   6.856  1.00  0.00           H  
ATOM     18  HG  SER A   2      14.349  84.234   8.537  1.00  0.00           H  
ATOM     19  N   SER A   3      11.037  83.914   4.339  1.00  0.00           N  
ATOM     20  CA  SER A   3      10.590  83.110   3.214  1.00  0.00           C  
ATOM     21  C   SER A   3      11.478  83.375   1.996  1.00  0.00           C  
ATOM     22  O   SER A   3      12.103  82.456   1.469  1.00  0.00           O  
ATOM     23  CB  SER A   3       9.126  83.400   2.877  1.00  0.00           C  
ATOM     24  OG  SER A   3       8.368  82.205   2.716  1.00  0.00           O  
ATOM     25  H   SER A   3      11.245  84.867   4.121  1.00  0.00           H  
ATOM     26  HA  SER A   3      10.689  82.075   3.542  1.00  0.00           H  
ATOM     27  HB2 SER A   3       8.684  84.006   3.669  1.00  0.00           H  
ATOM     28  HB3 SER A   3       9.075  83.989   1.960  1.00  0.00           H  
ATOM     29  HG  SER A   3       8.756  81.475   3.280  1.00  0.00           H  
ATOM     30  N   GLY A   4      11.504  84.634   1.586  1.00  0.00           N  
ATOM     31  CA  GLY A   4      12.305  85.031   0.440  1.00  0.00           C  
ATOM     32  C   GLY A   4      13.647  85.615   0.886  1.00  0.00           C  
ATOM     33  O   GLY A   4      13.686  86.598   1.625  1.00  0.00           O  
ATOM     34  H   GLY A   4      10.993  85.375   2.021  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      12.476  84.169  -0.204  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      11.761  85.768  -0.150  1.00  0.00           H  
ATOM     37  N   SER A   5      14.715  84.986   0.416  1.00  0.00           N  
ATOM     38  CA  SER A   5      16.056  85.432   0.758  1.00  0.00           C  
ATOM     39  C   SER A   5      16.495  86.547  -0.195  1.00  0.00           C  
ATOM     40  O   SER A   5      16.294  86.449  -1.404  1.00  0.00           O  
ATOM     41  CB  SER A   5      17.051  84.271   0.710  1.00  0.00           C  
ATOM     42  OG  SER A   5      16.989  83.466   1.883  1.00  0.00           O  
ATOM     43  H   SER A   5      14.675  84.188  -0.184  1.00  0.00           H  
ATOM     44  HA  SER A   5      15.984  85.807   1.779  1.00  0.00           H  
ATOM     45  HB2 SER A   5      16.845  83.653  -0.164  1.00  0.00           H  
ATOM     46  HB3 SER A   5      18.060  84.664   0.592  1.00  0.00           H  
ATOM     47  HG  SER A   5      16.182  83.709   2.423  1.00  0.00           H  
ATOM     48  N   SER A   6      17.084  87.580   0.387  1.00  0.00           N  
ATOM     49  CA  SER A   6      17.552  88.712  -0.395  1.00  0.00           C  
ATOM     50  C   SER A   6      19.072  88.838  -0.274  1.00  0.00           C  
ATOM     51  O   SER A   6      19.572  89.638   0.516  1.00  0.00           O  
ATOM     52  CB  SER A   6      16.876  90.009   0.054  1.00  0.00           C  
ATOM     53  OG  SER A   6      15.595  90.179  -0.548  1.00  0.00           O  
ATOM     54  H   SER A   6      17.243  87.652   1.372  1.00  0.00           H  
ATOM     55  HA  SER A   6      17.267  88.491  -1.422  1.00  0.00           H  
ATOM     56  HB2 SER A   6      16.768  90.006   1.138  1.00  0.00           H  
ATOM     57  HB3 SER A   6      17.511  90.857  -0.201  1.00  0.00           H  
ATOM     58  HG  SER A   6      15.449  91.142  -0.776  1.00  0.00           H  
ATOM     59  N   GLY A   7      19.765  88.036  -1.069  1.00  0.00           N  
ATOM     60  CA  GLY A   7      21.218  88.047  -1.061  1.00  0.00           C  
ATOM     61  C   GLY A   7      21.771  86.922  -0.184  1.00  0.00           C  
ATOM     62  O   GLY A   7      21.130  86.513   0.783  1.00  0.00           O  
ATOM     63  H   GLY A   7      19.351  87.389  -1.709  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      21.592  87.936  -2.080  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      21.576  89.009  -0.694  1.00  0.00           H  
ATOM     66  N   GLU A   8      22.954  86.455  -0.552  1.00  0.00           N  
ATOM     67  CA  GLU A   8      23.601  85.386   0.190  1.00  0.00           C  
ATOM     68  C   GLU A   8      25.119  85.455   0.008  1.00  0.00           C  
ATOM     69  O   GLU A   8      25.603  85.925  -1.020  1.00  0.00           O  
ATOM     70  CB  GLU A   8      23.060  84.019  -0.235  1.00  0.00           C  
ATOM     71  CG  GLU A   8      23.344  83.752  -1.714  1.00  0.00           C  
ATOM     72  CD  GLU A   8      22.198  82.970  -2.359  1.00  0.00           C  
ATOM     73  OE1 GLU A   8      22.122  81.751  -2.090  1.00  0.00           O  
ATOM     74  OE2 GLU A   8      21.426  83.607  -3.107  1.00  0.00           O  
ATOM     75  H   GLU A   8      23.469  86.794  -1.339  1.00  0.00           H  
ATOM     76  HA  GLU A   8      23.345  85.562   1.235  1.00  0.00           H  
ATOM     77  HB2 GLU A   8      23.517  83.238   0.374  1.00  0.00           H  
ATOM     78  HB3 GLU A   8      21.986  83.977  -0.053  1.00  0.00           H  
ATOM     79  HG2 GLU A   8      23.482  84.698  -2.237  1.00  0.00           H  
ATOM     80  HG3 GLU A   8      24.274  83.193  -1.814  1.00  0.00           H  
ATOM     81  N   PRO A   9      25.845  84.967   1.049  1.00  0.00           N  
ATOM     82  CA  PRO A   9      27.298  84.970   1.014  1.00  0.00           C  
ATOM     83  C   PRO A   9      27.825  83.873   0.087  1.00  0.00           C  
ATOM     84  O   PRO A   9      27.119  82.908  -0.203  1.00  0.00           O  
ATOM     85  CB  PRO A   9      27.726  84.783   2.460  1.00  0.00           C  
ATOM     86  CG  PRO A   9      26.515  84.218   3.185  1.00  0.00           C  
ATOM     87  CD  PRO A   9      25.305  84.403   2.283  1.00  0.00           C  
ATOM     88  HA  PRO A   9      27.634  85.832   0.636  1.00  0.00           H  
ATOM     89  HB2 PRO A   9      28.575  84.102   2.531  1.00  0.00           H  
ATOM     90  HB3 PRO A   9      28.039  85.728   2.900  1.00  0.00           H  
ATOM     91  HG2 PRO A   9      26.663  83.163   3.413  1.00  0.00           H  
ATOM     92  HG3 PRO A   9      26.365  84.733   4.134  1.00  0.00           H  
ATOM     93  HD2 PRO A   9      24.801  83.455   2.097  1.00  0.00           H  
ATOM     94  HD3 PRO A   9      24.571  85.071   2.735  1.00  0.00           H  
ATOM     95  N   GLU A  10      29.061  84.058  -0.352  1.00  0.00           N  
ATOM     96  CA  GLU A  10      29.692  83.096  -1.241  1.00  0.00           C  
ATOM     97  C   GLU A  10      30.831  82.374  -0.518  1.00  0.00           C  
ATOM     98  O   GLU A  10      31.745  83.013   0.001  1.00  0.00           O  
ATOM     99  CB  GLU A  10      30.194  83.776  -2.516  1.00  0.00           C  
ATOM    100  CG  GLU A  10      31.461  84.588  -2.242  1.00  0.00           C  
ATOM    101  CD  GLU A  10      31.871  85.398  -3.474  1.00  0.00           C  
ATOM    102  OE1 GLU A  10      30.954  85.948  -4.121  1.00  0.00           O  
ATOM    103  OE2 GLU A  10      33.091  85.448  -3.740  1.00  0.00           O  
ATOM    104  H   GLU A  10      29.628  84.845  -0.112  1.00  0.00           H  
ATOM    105  HA  GLU A  10      28.908  82.385  -1.500  1.00  0.00           H  
ATOM    106  HB2 GLU A  10      30.400  83.022  -3.277  1.00  0.00           H  
ATOM    107  HB3 GLU A  10      29.419  84.429  -2.915  1.00  0.00           H  
ATOM    108  HG2 GLU A  10      31.290  85.261  -1.400  1.00  0.00           H  
ATOM    109  HG3 GLU A  10      32.273  83.920  -1.955  1.00  0.00           H  
ATOM    110  N   VAL A  11      30.739  81.051  -0.509  1.00  0.00           N  
ATOM    111  CA  VAL A  11      31.751  80.237   0.141  1.00  0.00           C  
ATOM    112  C   VAL A  11      33.100  80.462  -0.545  1.00  0.00           C  
ATOM    113  O   VAL A  11      33.179  81.169  -1.549  1.00  0.00           O  
ATOM    114  CB  VAL A  11      31.319  78.768   0.140  1.00  0.00           C  
ATOM    115  CG1 VAL A  11      31.534  78.134  -1.236  1.00  0.00           C  
ATOM    116  CG2 VAL A  11      32.052  77.981   1.228  1.00  0.00           C  
ATOM    117  H   VAL A  11      29.993  80.541  -0.934  1.00  0.00           H  
ATOM    118  HA  VAL A  11      31.824  80.566   1.177  1.00  0.00           H  
ATOM    119  HB  VAL A  11      30.251  78.733   0.363  1.00  0.00           H  
ATOM    120 HG11 VAL A  11      32.373  77.441  -1.188  1.00  0.00           H  
ATOM    121 HG12 VAL A  11      30.633  77.595  -1.531  1.00  0.00           H  
ATOM    122 HG13 VAL A  11      31.747  78.914  -1.965  1.00  0.00           H  
ATOM    123 HG21 VAL A  11      31.368  77.262   1.679  1.00  0.00           H  
ATOM    124 HG22 VAL A  11      32.896  77.452   0.787  1.00  0.00           H  
ATOM    125 HG23 VAL A  11      32.413  78.668   1.993  1.00  0.00           H  
ATOM    126  N   THR A  12      34.126  79.849   0.025  1.00  0.00           N  
ATOM    127  CA  THR A  12      35.469  79.976  -0.518  1.00  0.00           C  
ATOM    128  C   THR A  12      36.362  78.847   0.002  1.00  0.00           C  
ATOM    129  O   THR A  12      36.156  78.346   1.105  1.00  0.00           O  
ATOM    130  CB  THR A  12      35.989  81.372  -0.172  1.00  0.00           C  
ATOM    131  OG1 THR A  12      35.634  82.164  -1.302  1.00  0.00           O  
ATOM    132  CG2 THR A  12      37.518  81.434  -0.139  1.00  0.00           C  
ATOM    133  H   THR A  12      34.054  79.277   0.842  1.00  0.00           H  
ATOM    134  HA  THR A  12      35.412  79.866  -1.601  1.00  0.00           H  
ATOM    135  HB  THR A  12      35.565  81.725   0.767  1.00  0.00           H  
ATOM    136  HG1 THR A  12      35.871  83.122  -1.136  1.00  0.00           H  
ATOM    137 HG21 THR A  12      37.834  82.387   0.287  1.00  0.00           H  
ATOM    138 HG22 THR A  12      37.902  80.618   0.472  1.00  0.00           H  
ATOM    139 HG23 THR A  12      37.908  81.344  -1.153  1.00  0.00           H  
ATOM    140  N   VAL A  13      37.336  78.481  -0.819  1.00  0.00           N  
ATOM    141  CA  VAL A  13      38.262  77.422  -0.456  1.00  0.00           C  
ATOM    142  C   VAL A  13      39.666  78.009  -0.302  1.00  0.00           C  
ATOM    143  O   VAL A  13      40.032  78.946  -1.009  1.00  0.00           O  
ATOM    144  CB  VAL A  13      38.195  76.294  -1.487  1.00  0.00           C  
ATOM    145  CG1 VAL A  13      39.464  75.440  -1.447  1.00  0.00           C  
ATOM    146  CG2 VAL A  13      36.948  75.433  -1.277  1.00  0.00           C  
ATOM    147  H   VAL A  13      37.497  78.894  -1.716  1.00  0.00           H  
ATOM    148  HA  VAL A  13      37.942  77.021   0.506  1.00  0.00           H  
ATOM    149  HB  VAL A  13      38.127  76.746  -2.476  1.00  0.00           H  
ATOM    150 HG11 VAL A  13      39.848  75.406  -0.427  1.00  0.00           H  
ATOM    151 HG12 VAL A  13      39.232  74.428  -1.781  1.00  0.00           H  
ATOM    152 HG13 VAL A  13      40.217  75.875  -2.105  1.00  0.00           H  
ATOM    153 HG21 VAL A  13      37.155  74.670  -0.526  1.00  0.00           H  
ATOM    154 HG22 VAL A  13      36.125  76.062  -0.939  1.00  0.00           H  
ATOM    155 HG23 VAL A  13      36.676  74.952  -2.217  1.00  0.00           H  
ATOM    156  N   GLU A  14      40.415  77.433   0.626  1.00  0.00           N  
ATOM    157  CA  GLU A  14      41.772  77.887   0.882  1.00  0.00           C  
ATOM    158  C   GLU A  14      42.773  76.778   0.556  1.00  0.00           C  
ATOM    159  O   GLU A  14      42.599  75.635   0.977  1.00  0.00           O  
ATOM    160  CB  GLU A  14      41.927  78.359   2.330  1.00  0.00           C  
ATOM    161  CG  GLU A  14      41.094  79.614   2.591  1.00  0.00           C  
ATOM    162  CD  GLU A  14      41.721  80.470   3.693  1.00  0.00           C  
ATOM    163  OE1 GLU A  14      42.968  80.478   3.765  1.00  0.00           O  
ATOM    164  OE2 GLU A  14      40.936  81.098   4.438  1.00  0.00           O  
ATOM    165  H   GLU A  14      40.110  76.670   1.198  1.00  0.00           H  
ATOM    166  HA  GLU A  14      41.925  78.733   0.213  1.00  0.00           H  
ATOM    167  HB2 GLU A  14      41.620  77.565   3.010  1.00  0.00           H  
ATOM    168  HB3 GLU A  14      42.978  78.567   2.536  1.00  0.00           H  
ATOM    169  HG2 GLU A  14      41.012  80.198   1.674  1.00  0.00           H  
ATOM    170  HG3 GLU A  14      40.081  79.329   2.877  1.00  0.00           H  
ATOM    171  N   ILE A  15      43.801  77.153  -0.190  1.00  0.00           N  
ATOM    172  CA  ILE A  15      44.832  76.204  -0.578  1.00  0.00           C  
ATOM    173  C   ILE A  15      45.820  76.031   0.577  1.00  0.00           C  
ATOM    174  O   ILE A  15      45.999  76.940   1.387  1.00  0.00           O  
ATOM    175  CB  ILE A  15      45.488  76.634  -1.892  1.00  0.00           C  
ATOM    176  CG1 ILE A  15      44.435  77.037  -2.926  1.00  0.00           C  
ATOM    177  CG2 ILE A  15      46.421  75.541  -2.420  1.00  0.00           C  
ATOM    178  CD1 ILE A  15      43.544  75.849  -3.293  1.00  0.00           C  
ATOM    179  H   ILE A  15      43.937  78.084  -0.529  1.00  0.00           H  
ATOM    180  HA  ILE A  15      44.342  75.247  -0.760  1.00  0.00           H  
ATOM    181  HB  ILE A  15      46.101  77.513  -1.696  1.00  0.00           H  
ATOM    182 HG12 ILE A  15      43.822  77.847  -2.528  1.00  0.00           H  
ATOM    183 HG13 ILE A  15      44.926  77.419  -3.820  1.00  0.00           H  
ATOM    184 HG21 ILE A  15      46.687  75.760  -3.454  1.00  0.00           H  
ATOM    185 HG22 ILE A  15      47.324  75.509  -1.811  1.00  0.00           H  
ATOM    186 HG23 ILE A  15      45.916  74.577  -2.371  1.00  0.00           H  
ATOM    187 HD11 ILE A  15      43.421  75.809  -4.376  1.00  0.00           H  
ATOM    188 HD12 ILE A  15      44.007  74.925  -2.946  1.00  0.00           H  
ATOM    189 HD13 ILE A  15      42.569  75.966  -2.821  1.00  0.00           H  
ATOM    190  N   GLY A  16      46.437  74.860   0.616  1.00  0.00           N  
ATOM    191  CA  GLY A  16      47.403  74.556   1.657  1.00  0.00           C  
ATOM    192  C   GLY A  16      46.720  73.927   2.873  1.00  0.00           C  
ATOM    193  O   GLY A  16      47.342  73.171   3.617  1.00  0.00           O  
ATOM    194  H   GLY A  16      46.286  74.126  -0.048  1.00  0.00           H  
ATOM    195  HA2 GLY A  16      48.161  73.875   1.269  1.00  0.00           H  
ATOM    196  HA3 GLY A  16      47.918  75.468   1.957  1.00  0.00           H  
ATOM    197  N   GLU A  17      45.448  74.262   3.035  1.00  0.00           N  
ATOM    198  CA  GLU A  17      44.673  73.740   4.148  1.00  0.00           C  
ATOM    199  C   GLU A  17      44.066  72.384   3.782  1.00  0.00           C  
ATOM    200  O   GLU A  17      44.013  72.020   2.607  1.00  0.00           O  
ATOM    201  CB  GLU A  17      43.587  74.730   4.572  1.00  0.00           C  
ATOM    202  CG  GLU A  17      44.128  75.733   5.593  1.00  0.00           C  
ATOM    203  CD  GLU A  17      44.095  77.157   5.033  1.00  0.00           C  
ATOM    204  OE1 GLU A  17      45.096  77.537   4.389  1.00  0.00           O  
ATOM    205  OE2 GLU A  17      43.069  77.833   5.262  1.00  0.00           O  
ATOM    206  H   GLU A  17      44.949  74.877   2.425  1.00  0.00           H  
ATOM    207  HA  GLU A  17      45.384  73.618   4.965  1.00  0.00           H  
ATOM    208  HB2 GLU A  17      43.213  75.262   3.698  1.00  0.00           H  
ATOM    209  HB3 GLU A  17      42.743  74.188   5.001  1.00  0.00           H  
ATOM    210  HG2 GLU A  17      43.535  75.684   6.507  1.00  0.00           H  
ATOM    211  HG3 GLU A  17      45.150  75.468   5.862  1.00  0.00           H  
ATOM    212  N   THR A  18      43.623  71.674   4.808  1.00  0.00           N  
ATOM    213  CA  THR A  18      43.022  70.365   4.609  1.00  0.00           C  
ATOM    214  C   THR A  18      41.507  70.438   4.817  1.00  0.00           C  
ATOM    215  O   THR A  18      41.033  71.124   5.721  1.00  0.00           O  
ATOM    216  CB  THR A  18      43.717  69.377   5.547  1.00  0.00           C  
ATOM    217  OG1 THR A  18      45.106  69.601   5.320  1.00  0.00           O  
ATOM    218  CG2 THR A  18      43.501  67.922   5.129  1.00  0.00           C  
ATOM    219  H   THR A  18      43.670  71.976   5.760  1.00  0.00           H  
ATOM    220  HA  THR A  18      43.188  70.065   3.575  1.00  0.00           H  
ATOM    221  HB  THR A  18      43.406  69.536   6.580  1.00  0.00           H  
ATOM    222  HG1 THR A  18      45.649  68.971   5.874  1.00  0.00           H  
ATOM    223 HG21 THR A  18      44.352  67.321   5.450  1.00  0.00           H  
ATOM    224 HG22 THR A  18      42.592  67.541   5.595  1.00  0.00           H  
ATOM    225 HG23 THR A  18      43.406  67.865   4.045  1.00  0.00           H  
ATOM    226  N   TYR A  19      40.791  69.719   3.964  1.00  0.00           N  
ATOM    227  CA  TYR A  19      39.340  69.693   4.043  1.00  0.00           C  
ATOM    228  C   TYR A  19      38.812  68.259   3.958  1.00  0.00           C  
ATOM    229  O   TYR A  19      39.521  67.358   3.514  1.00  0.00           O  
ATOM    230  CB  TYR A  19      38.838  70.481   2.832  1.00  0.00           C  
ATOM    231  CG  TYR A  19      39.167  71.975   2.881  1.00  0.00           C  
ATOM    232  CD1 TYR A  19      40.481  72.394   2.836  1.00  0.00           C  
ATOM    233  CD2 TYR A  19      38.150  72.903   2.972  1.00  0.00           C  
ATOM    234  CE1 TYR A  19      40.791  73.799   2.882  1.00  0.00           C  
ATOM    235  CE2 TYR A  19      38.460  74.308   3.019  1.00  0.00           C  
ATOM    236  CZ  TYR A  19      39.764  74.688   2.972  1.00  0.00           C  
ATOM    237  OH  TYR A  19      40.057  76.015   3.015  1.00  0.00           O  
ATOM    238  H   TYR A  19      41.184  69.163   3.232  1.00  0.00           H  
ATOM    239  HA  TYR A  19      39.047  70.124   5.000  1.00  0.00           H  
ATOM    240  HB2 TYR A  19      39.271  70.054   1.928  1.00  0.00           H  
ATOM    241  HB3 TYR A  19      37.757  70.360   2.755  1.00  0.00           H  
ATOM    242  HD1 TYR A  19      41.284  71.660   2.764  1.00  0.00           H  
ATOM    243  HD2 TYR A  19      37.111  72.572   3.008  1.00  0.00           H  
ATOM    244  HE1 TYR A  19      41.824  74.143   2.846  1.00  0.00           H  
ATOM    245  HE2 TYR A  19      37.665  75.052   3.090  1.00  0.00           H  
ATOM    246  HH  TYR A  19      39.316  76.514   3.464  1.00  0.00           H  
ATOM    247  N   LEU A  20      37.571  68.093   4.391  1.00  0.00           N  
ATOM    248  CA  LEU A  20      36.940  66.785   4.369  1.00  0.00           C  
ATOM    249  C   LEU A  20      36.304  66.552   2.997  1.00  0.00           C  
ATOM    250  O   LEU A  20      35.369  67.255   2.615  1.00  0.00           O  
ATOM    251  CB  LEU A  20      35.958  66.644   5.534  1.00  0.00           C  
ATOM    252  CG  LEU A  20      36.525  66.926   6.927  1.00  0.00           C  
ATOM    253  CD1 LEU A  20      37.668  65.965   7.259  1.00  0.00           C  
ATOM    254  CD2 LEU A  20      36.950  68.389   7.061  1.00  0.00           C  
ATOM    255  H   LEU A  20      37.001  68.832   4.751  1.00  0.00           H  
ATOM    256  HA  LEU A  20      37.724  66.041   4.517  1.00  0.00           H  
ATOM    257  HB2 LEU A  20      35.121  67.321   5.361  1.00  0.00           H  
ATOM    258  HB3 LEU A  20      35.557  65.631   5.525  1.00  0.00           H  
ATOM    259  HG  LEU A  20      35.736  66.751   7.659  1.00  0.00           H  
ATOM    260 HD11 LEU A  20      37.477  65.489   8.221  1.00  0.00           H  
ATOM    261 HD12 LEU A  20      37.737  65.201   6.484  1.00  0.00           H  
ATOM    262 HD13 LEU A  20      38.606  66.519   7.307  1.00  0.00           H  
ATOM    263 HD21 LEU A  20      36.971  68.667   8.115  1.00  0.00           H  
ATOM    264 HD22 LEU A  20      37.942  68.520   6.631  1.00  0.00           H  
ATOM    265 HD23 LEU A  20      36.238  69.024   6.532  1.00  0.00           H  
ATOM    266  N   CYS A  21      36.835  65.564   2.294  1.00  0.00           N  
ATOM    267  CA  CYS A  21      36.332  65.230   0.973  1.00  0.00           C  
ATOM    268  C   CYS A  21      35.422  64.007   1.100  1.00  0.00           C  
ATOM    269  O   CYS A  21      35.811  62.998   1.687  1.00  0.00           O  
ATOM    270  CB  CYS A  21      37.469  64.995  -0.024  1.00  0.00           C  
ATOM    271  SG  CYS A  21      36.819  65.031  -1.734  1.00  0.00           S  
ATOM    272  H   CYS A  21      37.595  64.997   2.612  1.00  0.00           H  
ATOM    273  HA  CYS A  21      35.769  66.096   0.625  1.00  0.00           H  
ATOM    274  HB2 CYS A  21      38.235  65.760   0.098  1.00  0.00           H  
ATOM    275  HB3 CYS A  21      37.943  64.034   0.173  1.00  0.00           H  
ATOM    276  HG  CYS A  21      37.183  66.284  -1.995  1.00  0.00           H  
ATOM    277  N   ARG A  22      34.228  64.136   0.541  1.00  0.00           N  
ATOM    278  CA  ARG A  22      33.260  63.053   0.584  1.00  0.00           C  
ATOM    279  C   ARG A  22      33.867  61.774   0.005  1.00  0.00           C  
ATOM    280  O   ARG A  22      34.822  61.831  -0.768  1.00  0.00           O  
ATOM    281  CB  ARG A  22      31.997  63.412  -0.201  1.00  0.00           C  
ATOM    282  CG  ARG A  22      30.740  62.963   0.547  1.00  0.00           C  
ATOM    283  CD  ARG A  22      29.675  64.062   0.537  1.00  0.00           C  
ATOM    284  NE  ARG A  22      28.442  63.565  -0.114  1.00  0.00           N  
ATOM    285  CZ  ARG A  22      27.233  64.121   0.044  1.00  0.00           C  
ATOM    286  NH1 ARG A  22      27.087  65.195   0.832  1.00  0.00           N  
ATOM    287  NH2 ARG A  22      26.169  63.602  -0.585  1.00  0.00           N  
ATOM    288  H   ARG A  22      33.919  64.959   0.066  1.00  0.00           H  
ATOM    289  HA  ARG A  22      33.025  62.932   1.642  1.00  0.00           H  
ATOM    290  HB2 ARG A  22      31.961  64.488  -0.368  1.00  0.00           H  
ATOM    291  HB3 ARG A  22      32.028  62.938  -1.182  1.00  0.00           H  
ATOM    292  HG2 ARG A  22      30.340  62.060   0.087  1.00  0.00           H  
ATOM    293  HG3 ARG A  22      30.996  62.710   1.575  1.00  0.00           H  
ATOM    294  HD2 ARG A  22      29.456  64.377   1.556  1.00  0.00           H  
ATOM    295  HD3 ARG A  22      30.049  64.937   0.006  1.00  0.00           H  
ATOM    296  HE  ARG A  22      28.516  62.764  -0.708  1.00  0.00           H  
ATOM    297 HH11 ARG A  22      27.880  65.582   1.302  1.00  0.00           H  
ATOM    298 HH12 ARG A  22      26.185  65.609   0.949  1.00  0.00           H  
ATOM    299 HH21 ARG A  22      26.278  62.801  -1.174  1.00  0.00           H  
ATOM    300 HH22 ARG A  22      25.267  64.017  -0.468  1.00  0.00           H  
ATOM    301  N   ARG A  23      33.288  60.650   0.401  1.00  0.00           N  
ATOM    302  CA  ARG A  23      33.761  59.359  -0.070  1.00  0.00           C  
ATOM    303  C   ARG A  23      32.577  58.456  -0.419  1.00  0.00           C  
ATOM    304  O   ARG A  23      31.502  58.582   0.166  1.00  0.00           O  
ATOM    305  CB  ARG A  23      34.624  58.670   0.988  1.00  0.00           C  
ATOM    306  CG  ARG A  23      35.849  59.520   1.336  1.00  0.00           C  
ATOM    307  CD  ARG A  23      37.060  59.107   0.496  1.00  0.00           C  
ATOM    308  NE  ARG A  23      36.919  59.624  -0.882  1.00  0.00           N  
ATOM    309  CZ  ARG A  23      37.601  59.151  -1.935  1.00  0.00           C  
ATOM    310  NH1 ARG A  23      38.475  58.148  -1.772  1.00  0.00           N  
ATOM    311  NH2 ARG A  23      37.410  59.682  -3.150  1.00  0.00           N  
ATOM    312  H   ARG A  23      32.512  60.613   1.029  1.00  0.00           H  
ATOM    313  HA  ARG A  23      34.356  59.586  -0.954  1.00  0.00           H  
ATOM    314  HB2 ARG A  23      34.033  58.493   1.886  1.00  0.00           H  
ATOM    315  HB3 ARG A  23      34.947  57.695   0.622  1.00  0.00           H  
ATOM    316  HG2 ARG A  23      35.625  60.573   1.164  1.00  0.00           H  
ATOM    317  HG3 ARG A  23      36.082  59.412   2.395  1.00  0.00           H  
ATOM    318  HD2 ARG A  23      37.973  59.493   0.947  1.00  0.00           H  
ATOM    319  HD3 ARG A  23      37.147  58.021   0.480  1.00  0.00           H  
ATOM    320  HE  ARG A  23      36.276  60.373  -1.039  1.00  0.00           H  
ATOM    321 HH11 ARG A  23      38.617  57.752  -0.865  1.00  0.00           H  
ATOM    322 HH12 ARG A  23      38.983  57.795  -2.557  1.00  0.00           H  
ATOM    323 HH21 ARG A  23      36.759  60.431  -3.272  1.00  0.00           H  
ATOM    324 HH22 ARG A  23      37.918  59.330  -3.936  1.00  0.00           H  
ATOM    325  N   PRO A  24      32.820  57.542  -1.397  1.00  0.00           N  
ATOM    326  CA  PRO A  24      31.786  56.618  -1.831  1.00  0.00           C  
ATOM    327  C   PRO A  24      31.574  55.509  -0.799  1.00  0.00           C  
ATOM    328  O   PRO A  24      31.664  54.326  -1.125  1.00  0.00           O  
ATOM    329  CB  PRO A  24      32.266  56.095  -3.176  1.00  0.00           C  
ATOM    330  CG  PRO A  24      33.757  56.385  -3.228  1.00  0.00           C  
ATOM    331  CD  PRO A  24      34.081  57.365  -2.112  1.00  0.00           C  
ATOM    332  HA  PRO A  24      30.909  57.090  -1.909  1.00  0.00           H  
ATOM    333  HB2 PRO A  24      32.072  55.026  -3.270  1.00  0.00           H  
ATOM    334  HB3 PRO A  24      31.743  56.587  -3.995  1.00  0.00           H  
ATOM    335  HG2 PRO A  24      34.330  55.465  -3.106  1.00  0.00           H  
ATOM    336  HG3 PRO A  24      34.030  56.805  -4.196  1.00  0.00           H  
ATOM    337  HD2 PRO A  24      34.857  56.974  -1.454  1.00  0.00           H  
ATOM    338  HD3 PRO A  24      34.446  58.311  -2.509  1.00  0.00           H  
ATOM    339  N   ASP A  25      31.294  55.930   0.426  1.00  0.00           N  
ATOM    340  CA  ASP A  25      31.068  54.987   1.508  1.00  0.00           C  
ATOM    341  C   ASP A  25      30.344  55.695   2.654  1.00  0.00           C  
ATOM    342  O   ASP A  25      30.498  55.322   3.816  1.00  0.00           O  
ATOM    343  CB  ASP A  25      32.390  54.441   2.049  1.00  0.00           C  
ATOM    344  CG  ASP A  25      32.258  53.476   3.229  1.00  0.00           C  
ATOM    345  OD1 ASP A  25      31.440  52.539   3.107  1.00  0.00           O  
ATOM    346  OD2 ASP A  25      32.978  53.697   4.227  1.00  0.00           O  
ATOM    347  H   ASP A  25      31.223  56.893   0.684  1.00  0.00           H  
ATOM    348  HA  ASP A  25      30.471  54.186   1.070  1.00  0.00           H  
ATOM    349  HB2 ASP A  25      32.915  53.932   1.240  1.00  0.00           H  
ATOM    350  HB3 ASP A  25      33.015  55.281   2.355  1.00  0.00           H  
ATOM    351  N   SER A  26      29.572  56.708   2.287  1.00  0.00           N  
ATOM    352  CA  SER A  26      28.825  57.473   3.271  1.00  0.00           C  
ATOM    353  C   SER A  26      29.761  57.955   4.381  1.00  0.00           C  
ATOM    354  O   SER A  26      29.415  57.892   5.560  1.00  0.00           O  
ATOM    355  CB  SER A  26      27.682  56.644   3.862  1.00  0.00           C  
ATOM    356  OG  SER A  26      26.683  56.344   2.892  1.00  0.00           O  
ATOM    357  H   SER A  26      29.453  57.005   1.340  1.00  0.00           H  
ATOM    358  HA  SER A  26      28.411  58.320   2.724  1.00  0.00           H  
ATOM    359  HB2 SER A  26      28.082  55.716   4.270  1.00  0.00           H  
ATOM    360  HB3 SER A  26      27.231  57.189   4.692  1.00  0.00           H  
ATOM    361  HG  SER A  26      26.584  57.109   2.255  1.00  0.00           H  
ATOM    362  N   THR A  27      30.928  58.424   3.965  1.00  0.00           N  
ATOM    363  CA  THR A  27      31.916  58.916   4.910  1.00  0.00           C  
ATOM    364  C   THR A  27      32.698  60.084   4.304  1.00  0.00           C  
ATOM    365  O   THR A  27      32.482  60.447   3.149  1.00  0.00           O  
ATOM    366  CB  THR A  27      32.804  57.739   5.321  1.00  0.00           C  
ATOM    367  OG1 THR A  27      33.066  57.058   4.097  1.00  0.00           O  
ATOM    368  CG2 THR A  27      32.055  56.708   6.167  1.00  0.00           C  
ATOM    369  H   THR A  27      31.201  58.471   3.004  1.00  0.00           H  
ATOM    370  HA  THR A  27      31.394  59.301   5.785  1.00  0.00           H  
ATOM    371  HB  THR A  27      33.700  58.088   5.834  1.00  0.00           H  
ATOM    372  HG1 THR A  27      32.206  56.841   3.635  1.00  0.00           H  
ATOM    373 HG21 THR A  27      31.755  57.164   7.112  1.00  0.00           H  
ATOM    374 HG22 THR A  27      31.169  56.371   5.630  1.00  0.00           H  
ATOM    375 HG23 THR A  27      32.706  55.858   6.364  1.00  0.00           H  
ATOM    376  N   TRP A  28      33.587  60.641   5.112  1.00  0.00           N  
ATOM    377  CA  TRP A  28      34.402  61.760   4.671  1.00  0.00           C  
ATOM    378  C   TRP A  28      35.859  61.450   5.016  1.00  0.00           C  
ATOM    379  O   TRP A  28      36.139  60.817   6.033  1.00  0.00           O  
ATOM    380  CB  TRP A  28      33.908  63.073   5.284  1.00  0.00           C  
ATOM    381  CG  TRP A  28      32.573  63.560   4.718  1.00  0.00           C  
ATOM    382  CD1 TRP A  28      31.392  62.928   4.730  1.00  0.00           C  
ATOM    383  CD2 TRP A  28      32.330  64.818   4.053  1.00  0.00           C  
ATOM    384  NE1 TRP A  28      30.408  63.683   4.123  1.00  0.00           N  
ATOM    385  CE2 TRP A  28      30.997  64.868   3.699  1.00  0.00           C  
ATOM    386  CE3 TRP A  28      33.206  65.878   3.761  1.00  0.00           C  
ATOM    387  CZ2 TRP A  28      30.421  65.957   3.032  1.00  0.00           C  
ATOM    388  CZ3 TRP A  28      32.616  66.958   3.095  1.00  0.00           C  
ATOM    389  CH2 TRP A  28      31.276  67.024   2.731  1.00  0.00           C  
ATOM    390  H   TRP A  28      33.756  60.340   6.050  1.00  0.00           H  
ATOM    391  HA  TRP A  28      34.286  61.851   3.591  1.00  0.00           H  
ATOM    392  HB2 TRP A  28      33.809  62.943   6.362  1.00  0.00           H  
ATOM    393  HB3 TRP A  28      34.662  63.843   5.124  1.00  0.00           H  
ATOM    394  HD1 TRP A  28      31.228  61.942   5.163  1.00  0.00           H  
ATOM    395  HE1 TRP A  28      29.363  63.401   4.000  1.00  0.00           H  
ATOM    396  HE3 TRP A  28      34.262  65.861   4.030  1.00  0.00           H  
ATOM    397  HZ2 TRP A  28      29.365  65.973   2.763  1.00  0.00           H  
ATOM    398  HZ3 TRP A  28      33.252  67.807   2.844  1.00  0.00           H  
ATOM    399  HH2 TRP A  28      30.892  67.904   2.213  1.00  0.00           H  
ATOM    400  N   HIS A  29      36.751  61.910   4.150  1.00  0.00           N  
ATOM    401  CA  HIS A  29      38.173  61.689   4.350  1.00  0.00           C  
ATOM    402  C   HIS A  29      38.937  62.984   4.071  1.00  0.00           C  
ATOM    403  O   HIS A  29      38.753  63.605   3.025  1.00  0.00           O  
ATOM    404  CB  HIS A  29      38.665  60.514   3.502  1.00  0.00           C  
ATOM    405  CG  HIS A  29      39.133  59.328   4.309  1.00  0.00           C  
ATOM    406  ND1 HIS A  29      40.407  59.238   4.842  1.00  0.00           N  
ATOM    407  CD2 HIS A  29      38.484  58.182   4.669  1.00  0.00           C  
ATOM    408  CE1 HIS A  29      40.509  58.087   5.490  1.00  0.00           C  
ATOM    409  NE2 HIS A  29      39.317  57.434   5.382  1.00  0.00           N  
ATOM    410  H   HIS A  29      36.515  62.423   3.325  1.00  0.00           H  
ATOM    411  HA  HIS A  29      38.303  61.419   5.398  1.00  0.00           H  
ATOM    412  HB2 HIS A  29      37.861  60.196   2.838  1.00  0.00           H  
ATOM    413  HB3 HIS A  29      39.484  60.856   2.869  1.00  0.00           H  
ATOM    414  HD1 HIS A  29      41.127  59.926   4.754  1.00  0.00           H  
ATOM    415  HD2 HIS A  29      37.456  57.927   4.413  1.00  0.00           H  
ATOM    416  HE1 HIS A  29      41.392  57.726   6.019  1.00  0.00           H  
ATOM    417  N   SER A  30      39.779  63.354   5.026  1.00  0.00           N  
ATOM    418  CA  SER A  30      40.572  64.564   4.895  1.00  0.00           C  
ATOM    419  C   SER A  30      41.319  64.560   3.560  1.00  0.00           C  
ATOM    420  O   SER A  30      41.557  63.500   2.981  1.00  0.00           O  
ATOM    421  CB  SER A  30      41.560  64.702   6.055  1.00  0.00           C  
ATOM    422  OG  SER A  30      42.196  63.465   6.365  1.00  0.00           O  
ATOM    423  H   SER A  30      39.922  62.844   5.873  1.00  0.00           H  
ATOM    424  HA  SER A  30      39.855  65.385   4.929  1.00  0.00           H  
ATOM    425  HB2 SER A  30      42.317  65.445   5.800  1.00  0.00           H  
ATOM    426  HB3 SER A  30      41.035  65.071   6.936  1.00  0.00           H  
ATOM    427  HG  SER A  30      41.675  62.979   7.067  1.00  0.00           H  
ATOM    428  N   ALA A  31      41.668  65.755   3.109  1.00  0.00           N  
ATOM    429  CA  ALA A  31      42.383  65.903   1.852  1.00  0.00           C  
ATOM    430  C   ALA A  31      42.951  67.320   1.757  1.00  0.00           C  
ATOM    431  O   ALA A  31      42.206  68.297   1.812  1.00  0.00           O  
ATOM    432  CB  ALA A  31      41.445  65.570   0.690  1.00  0.00           C  
ATOM    433  H   ALA A  31      41.471  66.613   3.585  1.00  0.00           H  
ATOM    434  HA  ALA A  31      43.207  65.190   1.854  1.00  0.00           H  
ATOM    435  HB1 ALA A  31      41.946  65.787  -0.253  1.00  0.00           H  
ATOM    436  HB2 ALA A  31      41.180  64.515   0.727  1.00  0.00           H  
ATOM    437  HB3 ALA A  31      40.542  66.175   0.768  1.00  0.00           H  
ATOM    438  N   GLU A  32      44.266  67.387   1.614  1.00  0.00           N  
ATOM    439  CA  GLU A  32      44.943  68.669   1.511  1.00  0.00           C  
ATOM    440  C   GLU A  32      44.673  69.302   0.144  1.00  0.00           C  
ATOM    441  O   GLU A  32      44.763  68.633  -0.884  1.00  0.00           O  
ATOM    442  CB  GLU A  32      46.446  68.517   1.757  1.00  0.00           C  
ATOM    443  CG  GLU A  32      47.111  67.732   0.625  1.00  0.00           C  
ATOM    444  CD  GLU A  32      48.635  67.854   0.695  1.00  0.00           C  
ATOM    445  OE1 GLU A  32      49.098  68.946   1.088  1.00  0.00           O  
ATOM    446  OE2 GLU A  32      49.300  66.853   0.351  1.00  0.00           O  
ATOM    447  H   GLU A  32      44.866  66.588   1.570  1.00  0.00           H  
ATOM    448  HA  GLU A  32      44.513  69.288   2.297  1.00  0.00           H  
ATOM    449  HB2 GLU A  32      46.905  69.502   1.841  1.00  0.00           H  
ATOM    450  HB3 GLU A  32      46.612  68.006   2.705  1.00  0.00           H  
ATOM    451  HG2 GLU A  32      46.823  66.683   0.687  1.00  0.00           H  
ATOM    452  HG3 GLU A  32      46.756  68.103  -0.337  1.00  0.00           H  
ATOM    453  N   VAL A  33      44.347  70.587   0.177  1.00  0.00           N  
ATOM    454  CA  VAL A  33      44.063  71.318  -1.045  1.00  0.00           C  
ATOM    455  C   VAL A  33      45.380  71.739  -1.700  1.00  0.00           C  
ATOM    456  O   VAL A  33      46.063  72.637  -1.209  1.00  0.00           O  
ATOM    457  CB  VAL A  33      43.139  72.501  -0.745  1.00  0.00           C  
ATOM    458  CG1 VAL A  33      42.654  73.160  -2.039  1.00  0.00           C  
ATOM    459  CG2 VAL A  33      41.959  72.067   0.126  1.00  0.00           C  
ATOM    460  H   VAL A  33      44.276  71.124   1.018  1.00  0.00           H  
ATOM    461  HA  VAL A  33      43.537  70.641  -1.719  1.00  0.00           H  
ATOM    462  HB  VAL A  33      43.713  73.241  -0.187  1.00  0.00           H  
ATOM    463 HG11 VAL A  33      43.409  73.033  -2.816  1.00  0.00           H  
ATOM    464 HG12 VAL A  33      41.723  72.692  -2.357  1.00  0.00           H  
ATOM    465 HG13 VAL A  33      42.486  74.221  -1.864  1.00  0.00           H  
ATOM    466 HG21 VAL A  33      42.068  72.492   1.123  1.00  0.00           H  
ATOM    467 HG22 VAL A  33      41.029  72.420  -0.321  1.00  0.00           H  
ATOM    468 HG23 VAL A  33      41.939  70.979   0.195  1.00  0.00           H  
ATOM    469  N   ILE A  34      45.697  71.071  -2.800  1.00  0.00           N  
ATOM    470  CA  ILE A  34      46.919  71.365  -3.527  1.00  0.00           C  
ATOM    471  C   ILE A  34      46.798  72.740  -4.187  1.00  0.00           C  
ATOM    472  O   ILE A  34      47.591  73.638  -3.911  1.00  0.00           O  
ATOM    473  CB  ILE A  34      47.243  70.237  -4.510  1.00  0.00           C  
ATOM    474  CG1 ILE A  34      47.205  68.876  -3.813  1.00  0.00           C  
ATOM    475  CG2 ILE A  34      48.581  70.486  -5.209  1.00  0.00           C  
ATOM    476  CD1 ILE A  34      48.591  68.483  -3.299  1.00  0.00           C  
ATOM    477  H   ILE A  34      45.136  70.343  -3.194  1.00  0.00           H  
ATOM    478  HA  ILE A  34      47.732  71.402  -2.801  1.00  0.00           H  
ATOM    479  HB  ILE A  34      46.474  70.226  -5.282  1.00  0.00           H  
ATOM    480 HG12 ILE A  34      46.501  68.909  -2.982  1.00  0.00           H  
ATOM    481 HG13 ILE A  34      46.842  68.118  -4.508  1.00  0.00           H  
ATOM    482 HG21 ILE A  34      49.381  70.498  -4.468  1.00  0.00           H  
ATOM    483 HG22 ILE A  34      48.767  69.691  -5.931  1.00  0.00           H  
ATOM    484 HG23 ILE A  34      48.550  71.446  -5.724  1.00  0.00           H  
ATOM    485 HD11 ILE A  34      49.215  68.173  -4.137  1.00  0.00           H  
ATOM    486 HD12 ILE A  34      49.050  69.338  -2.802  1.00  0.00           H  
ATOM    487 HD13 ILE A  34      48.497  67.659  -2.592  1.00  0.00           H  
ATOM    488  N   GLN A  35      45.798  72.861  -5.049  1.00  0.00           N  
ATOM    489  CA  GLN A  35      45.562  74.110  -5.750  1.00  0.00           C  
ATOM    490  C   GLN A  35      44.076  74.259  -6.085  1.00  0.00           C  
ATOM    491  O   GLN A  35      43.252  73.465  -5.633  1.00  0.00           O  
ATOM    492  CB  GLN A  35      46.421  74.201  -7.014  1.00  0.00           C  
ATOM    493  CG  GLN A  35      47.689  75.017  -6.758  1.00  0.00           C  
ATOM    494  CD  GLN A  35      47.395  76.518  -6.813  1.00  0.00           C  
ATOM    495  OE1 GLN A  35      46.622  76.996  -7.627  1.00  0.00           O  
ATOM    496  NE2 GLN A  35      48.053  77.232  -5.904  1.00  0.00           N  
ATOM    497  H   GLN A  35      45.157  72.125  -5.267  1.00  0.00           H  
ATOM    498  HA  GLN A  35      45.865  74.895  -5.056  1.00  0.00           H  
ATOM    499  HB2 GLN A  35      46.690  73.198  -7.346  1.00  0.00           H  
ATOM    500  HB3 GLN A  35      45.844  74.659  -7.817  1.00  0.00           H  
ATOM    501  HG2 GLN A  35      48.101  74.760  -5.782  1.00  0.00           H  
ATOM    502  HG3 GLN A  35      48.445  74.764  -7.501  1.00  0.00           H  
ATOM    503 HE21 GLN A  35      48.673  76.778  -5.265  1.00  0.00           H  
ATOM    504 HE22 GLN A  35      47.927  78.223  -5.861  1.00  0.00           H  
ATOM    505  N   SER A  36      43.780  75.281  -6.875  1.00  0.00           N  
ATOM    506  CA  SER A  36      42.408  75.543  -7.276  1.00  0.00           C  
ATOM    507  C   SER A  36      42.354  75.884  -8.766  1.00  0.00           C  
ATOM    508  O   SER A  36      43.263  76.522  -9.294  1.00  0.00           O  
ATOM    509  CB  SER A  36      41.800  76.678  -6.449  1.00  0.00           C  
ATOM    510  OG  SER A  36      42.659  77.814  -6.390  1.00  0.00           O  
ATOM    511  H   SER A  36      44.456  75.921  -7.239  1.00  0.00           H  
ATOM    512  HA  SER A  36      41.866  74.618  -7.075  1.00  0.00           H  
ATOM    513  HB2 SER A  36      40.842  76.970  -6.882  1.00  0.00           H  
ATOM    514  HB3 SER A  36      41.598  76.323  -5.439  1.00  0.00           H  
ATOM    515  HG  SER A  36      43.574  77.537  -6.101  1.00  0.00           H  
ATOM    516  N   ARG A  37      41.279  75.443  -9.403  1.00  0.00           N  
ATOM    517  CA  ARG A  37      41.095  75.693 -10.822  1.00  0.00           C  
ATOM    518  C   ARG A  37      39.605  75.809 -11.153  1.00  0.00           C  
ATOM    519  O   ARG A  37      38.765  75.249 -10.450  1.00  0.00           O  
ATOM    520  CB  ARG A  37      41.711  74.573 -11.664  1.00  0.00           C  
ATOM    521  CG  ARG A  37      40.918  73.274 -11.512  1.00  0.00           C  
ATOM    522  CD  ARG A  37      41.383  72.226 -12.526  1.00  0.00           C  
ATOM    523  NE  ARG A  37      40.212  71.594 -13.173  1.00  0.00           N  
ATOM    524  CZ  ARG A  37      40.294  70.719 -14.186  1.00  0.00           C  
ATOM    525  NH1 ARG A  37      41.493  70.370 -14.672  1.00  0.00           N  
ATOM    526  NH2 ARG A  37      39.179  70.195 -14.711  1.00  0.00           N  
ATOM    527  H   ARG A  37      40.543  74.924  -8.967  1.00  0.00           H  
ATOM    528  HA  ARG A  37      41.612  76.635 -11.009  1.00  0.00           H  
ATOM    529  HB2 ARG A  37      41.732  74.871 -12.712  1.00  0.00           H  
ATOM    530  HB3 ARG A  37      42.745  74.410 -11.358  1.00  0.00           H  
ATOM    531  HG2 ARG A  37      41.038  72.886 -10.501  1.00  0.00           H  
ATOM    532  HG3 ARG A  37      39.855  73.474 -11.652  1.00  0.00           H  
ATOM    533  HD2 ARG A  37      42.016  72.694 -13.279  1.00  0.00           H  
ATOM    534  HD3 ARG A  37      41.987  71.469 -12.027  1.00  0.00           H  
ATOM    535  HE  ARG A  37      39.302  71.833 -12.833  1.00  0.00           H  
ATOM    536 HH11 ARG A  37      42.326  70.760 -14.280  1.00  0.00           H  
ATOM    537 HH12 ARG A  37      41.554  69.717 -15.428  1.00  0.00           H  
ATOM    538 HH21 ARG A  37      38.285  70.456 -14.347  1.00  0.00           H  
ATOM    539 HH22 ARG A  37      39.240  69.543 -15.467  1.00  0.00           H  
ATOM    540  N   VAL A  38      39.323  76.539 -12.221  1.00  0.00           N  
ATOM    541  CA  VAL A  38      37.950  76.735 -12.653  1.00  0.00           C  
ATOM    542  C   VAL A  38      37.801  76.259 -14.099  1.00  0.00           C  
ATOM    543  O   VAL A  38      38.713  76.423 -14.907  1.00  0.00           O  
ATOM    544  CB  VAL A  38      37.545  78.199 -12.461  1.00  0.00           C  
ATOM    545  CG1 VAL A  38      36.417  78.586 -13.419  1.00  0.00           C  
ATOM    546  CG2 VAL A  38      37.149  78.471 -11.008  1.00  0.00           C  
ATOM    547  H   VAL A  38      40.013  76.991 -12.787  1.00  0.00           H  
ATOM    548  HA  VAL A  38      37.314  76.123 -12.014  1.00  0.00           H  
ATOM    549  HB  VAL A  38      38.410  78.819 -12.694  1.00  0.00           H  
ATOM    550 HG11 VAL A  38      35.893  79.458 -13.029  1.00  0.00           H  
ATOM    551 HG12 VAL A  38      36.836  78.820 -14.397  1.00  0.00           H  
ATOM    552 HG13 VAL A  38      35.718  77.754 -13.512  1.00  0.00           H  
ATOM    553 HG21 VAL A  38      36.627  79.427 -10.947  1.00  0.00           H  
ATOM    554 HG22 VAL A  38      36.493  77.676 -10.654  1.00  0.00           H  
ATOM    555 HG23 VAL A  38      38.044  78.507 -10.387  1.00  0.00           H  
ATOM    556  N   ASN A  39      36.644  75.678 -14.381  1.00  0.00           N  
ATOM    557  CA  ASN A  39      36.364  75.175 -15.715  1.00  0.00           C  
ATOM    558  C   ASN A  39      35.519  76.201 -16.474  1.00  0.00           C  
ATOM    559  O   ASN A  39      34.483  76.644 -15.980  1.00  0.00           O  
ATOM    560  CB  ASN A  39      35.577  73.865 -15.656  1.00  0.00           C  
ATOM    561  CG  ASN A  39      36.517  72.668 -15.493  1.00  0.00           C  
ATOM    562  OD1 ASN A  39      37.704  72.807 -15.245  1.00  0.00           O  
ATOM    563  ND2 ASN A  39      35.922  71.488 -15.644  1.00  0.00           N  
ATOM    564  H   ASN A  39      35.908  75.547 -13.716  1.00  0.00           H  
ATOM    565  HA  ASN A  39      37.341  75.019 -16.172  1.00  0.00           H  
ATOM    566  HB2 ASN A  39      34.873  73.896 -14.825  1.00  0.00           H  
ATOM    567  HB3 ASN A  39      34.991  73.748 -16.568  1.00  0.00           H  
ATOM    568 HD21 ASN A  39      34.943  71.444 -15.845  1.00  0.00           H  
ATOM    569 HD22 ASN A  39      36.452  70.646 -15.554  1.00  0.00           H  
ATOM    570  N   ASP A  40      35.993  76.548 -17.661  1.00  0.00           N  
ATOM    571  CA  ASP A  40      35.294  77.513 -18.493  1.00  0.00           C  
ATOM    572  C   ASP A  40      34.308  76.776 -19.402  1.00  0.00           C  
ATOM    573  O   ASP A  40      33.155  77.183 -19.533  1.00  0.00           O  
ATOM    574  CB  ASP A  40      36.271  78.285 -19.382  1.00  0.00           C  
ATOM    575  CG  ASP A  40      36.133  79.807 -19.325  1.00  0.00           C  
ATOM    576  OD1 ASP A  40      34.982  80.267 -19.167  1.00  0.00           O  
ATOM    577  OD2 ASP A  40      37.181  80.477 -19.440  1.00  0.00           O  
ATOM    578  H   ASP A  40      36.836  76.182 -18.055  1.00  0.00           H  
ATOM    579  HA  ASP A  40      34.795  78.185 -17.795  1.00  0.00           H  
ATOM    580  HB2 ASP A  40      37.288  78.015 -19.096  1.00  0.00           H  
ATOM    581  HB3 ASP A  40      36.134  77.961 -20.413  1.00  0.00           H  
ATOM    582  N   GLN A  41      34.799  75.705 -20.008  1.00  0.00           N  
ATOM    583  CA  GLN A  41      33.976  74.907 -20.902  1.00  0.00           C  
ATOM    584  C   GLN A  41      32.763  74.351 -20.152  1.00  0.00           C  
ATOM    585  O   GLN A  41      31.640  74.407 -20.651  1.00  0.00           O  
ATOM    586  CB  GLN A  41      34.790  73.780 -21.539  1.00  0.00           C  
ATOM    587  CG  GLN A  41      35.820  74.337 -22.526  1.00  0.00           C  
ATOM    588  CD  GLN A  41      35.131  74.959 -23.742  1.00  0.00           C  
ATOM    589  OE1 GLN A  41      33.917  74.981 -23.857  1.00  0.00           O  
ATOM    590  NE2 GLN A  41      35.972  75.461 -24.641  1.00  0.00           N  
ATOM    591  H   GLN A  41      35.738  75.380 -19.896  1.00  0.00           H  
ATOM    592  HA  GLN A  41      33.646  75.594 -21.682  1.00  0.00           H  
ATOM    593  HB2 GLN A  41      35.299  73.209 -20.761  1.00  0.00           H  
ATOM    594  HB3 GLN A  41      34.123  73.090 -22.054  1.00  0.00           H  
ATOM    595  HG2 GLN A  41      36.435  75.087 -22.030  1.00  0.00           H  
ATOM    596  HG3 GLN A  41      36.487  73.539 -22.849  1.00  0.00           H  
ATOM    597 HE21 GLN A  41      36.959  75.412 -24.486  1.00  0.00           H  
ATOM    598 HE22 GLN A  41      35.618  75.890 -25.472  1.00  0.00           H  
ATOM    599  N   GLU A  42      33.031  73.826 -18.966  1.00  0.00           N  
ATOM    600  CA  GLU A  42      31.976  73.260 -18.142  1.00  0.00           C  
ATOM    601  C   GLU A  42      31.295  74.360 -17.324  1.00  0.00           C  
ATOM    602  O   GLU A  42      30.071  74.377 -17.201  1.00  0.00           O  
ATOM    603  CB  GLU A  42      32.522  72.158 -17.232  1.00  0.00           C  
ATOM    604  CG  GLU A  42      32.532  70.809 -17.953  1.00  0.00           C  
ATOM    605  CD  GLU A  42      31.125  70.212 -18.020  1.00  0.00           C  
ATOM    606  OE1 GLU A  42      30.598  69.875 -16.938  1.00  0.00           O  
ATOM    607  OE2 GLU A  42      30.606  70.107 -19.152  1.00  0.00           O  
ATOM    608  H   GLU A  42      33.947  73.784 -18.566  1.00  0.00           H  
ATOM    609  HA  GLU A  42      31.263  72.825 -18.843  1.00  0.00           H  
ATOM    610  HB2 GLU A  42      33.533  72.412 -16.914  1.00  0.00           H  
ATOM    611  HB3 GLU A  42      31.912  72.090 -16.332  1.00  0.00           H  
ATOM    612  HG2 GLU A  42      32.927  70.932 -18.960  1.00  0.00           H  
ATOM    613  HG3 GLU A  42      33.198  70.119 -17.432  1.00  0.00           H  
ATOM    614  N   GLY A  43      32.116  75.248 -16.786  1.00  0.00           N  
ATOM    615  CA  GLY A  43      31.608  76.347 -15.983  1.00  0.00           C  
ATOM    616  C   GLY A  43      31.416  75.919 -14.527  1.00  0.00           C  
ATOM    617  O   GLY A  43      30.347  76.121 -13.951  1.00  0.00           O  
ATOM    618  H   GLY A  43      33.111  75.226 -16.891  1.00  0.00           H  
ATOM    619  HA2 GLY A  43      32.301  77.187 -16.030  1.00  0.00           H  
ATOM    620  HA3 GLY A  43      30.659  76.693 -16.392  1.00  0.00           H  
ATOM    621  N   ARG A  44      32.468  75.335 -13.972  1.00  0.00           N  
ATOM    622  CA  ARG A  44      32.428  74.877 -12.593  1.00  0.00           C  
ATOM    623  C   ARG A  44      33.798  75.054 -11.935  1.00  0.00           C  
ATOM    624  O   ARG A  44      34.763  75.439 -12.595  1.00  0.00           O  
ATOM    625  CB  ARG A  44      32.018  73.405 -12.513  1.00  0.00           C  
ATOM    626  CG  ARG A  44      30.713  73.157 -13.274  1.00  0.00           C  
ATOM    627  CD  ARG A  44      30.046  71.861 -12.809  1.00  0.00           C  
ATOM    628  NE  ARG A  44      30.628  70.706 -13.527  1.00  0.00           N  
ATOM    629  CZ  ARG A  44      30.601  69.447 -13.071  1.00  0.00           C  
ATOM    630  NH1 ARG A  44      30.019  69.172 -11.896  1.00  0.00           N  
ATOM    631  NH2 ARG A  44      31.155  68.461 -13.790  1.00  0.00           N  
ATOM    632  H   ARG A  44      33.333  75.174 -14.445  1.00  0.00           H  
ATOM    633  HA  ARG A  44      31.678  75.505 -12.111  1.00  0.00           H  
ATOM    634  HB2 ARG A  44      32.809  72.780 -12.928  1.00  0.00           H  
ATOM    635  HB3 ARG A  44      31.896  73.113 -11.469  1.00  0.00           H  
ATOM    636  HG2 ARG A  44      30.034  73.996 -13.120  1.00  0.00           H  
ATOM    637  HG3 ARG A  44      30.918  73.103 -14.343  1.00  0.00           H  
ATOM    638  HD2 ARG A  44      30.180  71.738 -11.734  1.00  0.00           H  
ATOM    639  HD3 ARG A  44      28.973  71.910 -12.992  1.00  0.00           H  
ATOM    640  HE  ARG A  44      31.071  70.876 -14.408  1.00  0.00           H  
ATOM    641 HH11 ARG A  44      29.606  69.908 -11.359  1.00  0.00           H  
ATOM    642 HH12 ARG A  44      29.999  68.232 -11.556  1.00  0.00           H  
ATOM    643 HH21 ARG A  44      31.589  68.665 -14.668  1.00  0.00           H  
ATOM    644 HH22 ARG A  44      31.134  67.521 -13.450  1.00  0.00           H  
ATOM    645  N   GLU A  45      33.841  74.764 -10.643  1.00  0.00           N  
ATOM    646  CA  GLU A  45      35.077  74.886  -9.889  1.00  0.00           C  
ATOM    647  C   GLU A  45      35.617  73.501  -9.527  1.00  0.00           C  
ATOM    648  O   GLU A  45      34.850  72.552  -9.375  1.00  0.00           O  
ATOM    649  CB  GLU A  45      34.873  75.740  -8.636  1.00  0.00           C  
ATOM    650  CG  GLU A  45      34.314  77.118  -8.996  1.00  0.00           C  
ATOM    651  CD  GLU A  45      33.214  77.536  -8.019  1.00  0.00           C  
ATOM    652  OE1 GLU A  45      32.381  76.662  -7.695  1.00  0.00           O  
ATOM    653  OE2 GLU A  45      33.230  78.720  -7.619  1.00  0.00           O  
ATOM    654  H   GLU A  45      33.052  74.452 -10.114  1.00  0.00           H  
ATOM    655  HA  GLU A  45      35.775  75.392 -10.556  1.00  0.00           H  
ATOM    656  HB2 GLU A  45      34.189  75.233  -7.954  1.00  0.00           H  
ATOM    657  HB3 GLU A  45      35.821  75.854  -8.111  1.00  0.00           H  
ATOM    658  HG2 GLU A  45      35.117  77.855  -8.982  1.00  0.00           H  
ATOM    659  HG3 GLU A  45      33.916  77.099 -10.011  1.00  0.00           H  
ATOM    660  N   GLU A  46      36.934  73.430  -9.398  1.00  0.00           N  
ATOM    661  CA  GLU A  46      37.585  72.176  -9.057  1.00  0.00           C  
ATOM    662  C   GLU A  46      38.850  72.442  -8.237  1.00  0.00           C  
ATOM    663  O   GLU A  46      39.658  73.298  -8.595  1.00  0.00           O  
ATOM    664  CB  GLU A  46      37.907  71.365 -10.314  1.00  0.00           C  
ATOM    665  CG  GLU A  46      36.911  70.218 -10.496  1.00  0.00           C  
ATOM    666  CD  GLU A  46      35.935  70.516 -11.635  1.00  0.00           C  
ATOM    667  OE1 GLU A  46      35.217  71.533 -11.518  1.00  0.00           O  
ATOM    668  OE2 GLU A  46      35.928  69.719 -12.598  1.00  0.00           O  
ATOM    669  H   GLU A  46      37.551  74.207  -9.523  1.00  0.00           H  
ATOM    670  HA  GLU A  46      36.862  71.629  -8.454  1.00  0.00           H  
ATOM    671  HB2 GLU A  46      37.881  72.016 -11.188  1.00  0.00           H  
ATOM    672  HB3 GLU A  46      38.919  70.965 -10.244  1.00  0.00           H  
ATOM    673  HG2 GLU A  46      37.450  69.294 -10.705  1.00  0.00           H  
ATOM    674  HG3 GLU A  46      36.358  70.062  -9.570  1.00  0.00           H  
ATOM    675  N   PHE A  47      38.982  71.693  -7.153  1.00  0.00           N  
ATOM    676  CA  PHE A  47      40.134  71.836  -6.279  1.00  0.00           C  
ATOM    677  C   PHE A  47      40.901  70.517  -6.163  1.00  0.00           C  
ATOM    678  O   PHE A  47      40.333  69.496  -5.777  1.00  0.00           O  
ATOM    679  CB  PHE A  47      39.603  72.228  -4.899  1.00  0.00           C  
ATOM    680  CG  PHE A  47      38.992  73.629  -4.842  1.00  0.00           C  
ATOM    681  CD1 PHE A  47      39.786  74.708  -4.604  1.00  0.00           C  
ATOM    682  CD2 PHE A  47      37.656  73.796  -5.029  1.00  0.00           C  
ATOM    683  CE1 PHE A  47      39.218  76.008  -4.551  1.00  0.00           C  
ATOM    684  CE2 PHE A  47      37.088  75.097  -4.976  1.00  0.00           C  
ATOM    685  CZ  PHE A  47      37.882  76.175  -4.738  1.00  0.00           C  
ATOM    686  H   PHE A  47      38.320  70.999  -6.868  1.00  0.00           H  
ATOM    687  HA  PHE A  47      40.782  72.593  -6.721  1.00  0.00           H  
ATOM    688  HB2 PHE A  47      38.851  71.502  -4.591  1.00  0.00           H  
ATOM    689  HB3 PHE A  47      40.417  72.169  -4.177  1.00  0.00           H  
ATOM    690  HD1 PHE A  47      40.856  74.574  -4.454  1.00  0.00           H  
ATOM    691  HD2 PHE A  47      37.019  72.932  -5.220  1.00  0.00           H  
ATOM    692  HE1 PHE A  47      39.854  76.873  -4.361  1.00  0.00           H  
ATOM    693  HE2 PHE A  47      36.016  75.231  -5.126  1.00  0.00           H  
ATOM    694  HZ  PHE A  47      37.446  77.174  -4.697  1.00  0.00           H  
ATOM    695  N   TYR A  48      42.180  70.581  -6.501  1.00  0.00           N  
ATOM    696  CA  TYR A  48      43.030  69.405  -6.440  1.00  0.00           C  
ATOM    697  C   TYR A  48      43.386  69.062  -4.992  1.00  0.00           C  
ATOM    698  O   TYR A  48      44.350  69.593  -4.443  1.00  0.00           O  
ATOM    699  CB  TYR A  48      44.311  69.770  -7.194  1.00  0.00           C  
ATOM    700  CG  TYR A  48      45.108  68.561  -7.687  1.00  0.00           C  
ATOM    701  CD1 TYR A  48      44.461  67.521  -8.325  1.00  0.00           C  
ATOM    702  CD2 TYR A  48      46.473  68.510  -7.495  1.00  0.00           C  
ATOM    703  CE1 TYR A  48      45.213  66.383  -8.790  1.00  0.00           C  
ATOM    704  CE2 TYR A  48      47.224  67.372  -7.959  1.00  0.00           C  
ATOM    705  CZ  TYR A  48      46.556  66.365  -8.584  1.00  0.00           C  
ATOM    706  OH  TYR A  48      47.265  65.291  -9.023  1.00  0.00           O  
ATOM    707  H   TYR A  48      42.634  71.415  -6.814  1.00  0.00           H  
ATOM    708  HA  TYR A  48      42.484  68.570  -6.879  1.00  0.00           H  
ATOM    709  HB2 TYR A  48      44.050  70.394  -8.049  1.00  0.00           H  
ATOM    710  HB3 TYR A  48      44.946  70.369  -6.543  1.00  0.00           H  
ATOM    711  HD1 TYR A  48      43.383  67.562  -8.478  1.00  0.00           H  
ATOM    712  HD2 TYR A  48      46.983  69.330  -6.991  1.00  0.00           H  
ATOM    713  HE1 TYR A  48      44.714  65.556  -9.295  1.00  0.00           H  
ATOM    714  HE2 TYR A  48      48.303  67.319  -7.813  1.00  0.00           H  
ATOM    715  HH  TYR A  48      48.199  65.328  -8.668  1.00  0.00           H  
ATOM    716  N   VAL A  49      42.589  68.175  -4.415  1.00  0.00           N  
ATOM    717  CA  VAL A  49      42.808  67.754  -3.041  1.00  0.00           C  
ATOM    718  C   VAL A  49      43.601  66.446  -3.033  1.00  0.00           C  
ATOM    719  O   VAL A  49      43.447  65.617  -3.930  1.00  0.00           O  
ATOM    720  CB  VAL A  49      41.470  67.647  -2.307  1.00  0.00           C  
ATOM    721  CG1 VAL A  49      40.639  68.917  -2.494  1.00  0.00           C  
ATOM    722  CG2 VAL A  49      40.692  66.410  -2.763  1.00  0.00           C  
ATOM    723  H   VAL A  49      41.807  67.746  -4.868  1.00  0.00           H  
ATOM    724  HA  VAL A  49      43.401  68.527  -2.551  1.00  0.00           H  
ATOM    725  HB  VAL A  49      41.679  67.536  -1.243  1.00  0.00           H  
ATOM    726 HG11 VAL A  49      40.285  69.266  -1.524  1.00  0.00           H  
ATOM    727 HG12 VAL A  49      41.254  69.689  -2.956  1.00  0.00           H  
ATOM    728 HG13 VAL A  49      39.784  68.701  -3.135  1.00  0.00           H  
ATOM    729 HG21 VAL A  49      40.963  66.170  -3.791  1.00  0.00           H  
ATOM    730 HG22 VAL A  49      40.938  65.568  -2.116  1.00  0.00           H  
ATOM    731 HG23 VAL A  49      39.622  66.612  -2.706  1.00  0.00           H  
ATOM    732  N   HIS A  50      44.431  66.300  -2.011  1.00  0.00           N  
ATOM    733  CA  HIS A  50      45.248  65.106  -1.874  1.00  0.00           C  
ATOM    734  C   HIS A  50      44.840  64.346  -0.611  1.00  0.00           C  
ATOM    735  O   HIS A  50      44.888  64.894   0.490  1.00  0.00           O  
ATOM    736  CB  HIS A  50      46.737  65.461  -1.898  1.00  0.00           C  
ATOM    737  CG  HIS A  50      47.649  64.301  -1.580  1.00  0.00           C  
ATOM    738  ND1 HIS A  50      48.310  63.578  -2.557  1.00  0.00           N  
ATOM    739  CD2 HIS A  50      48.005  63.748  -0.384  1.00  0.00           C  
ATOM    740  CE1 HIS A  50      49.027  62.634  -1.965  1.00  0.00           C  
ATOM    741  NE2 HIS A  50      48.836  62.741  -0.619  1.00  0.00           N  
ATOM    742  H   HIS A  50      44.550  66.978  -1.286  1.00  0.00           H  
ATOM    743  HA  HIS A  50      45.041  64.484  -2.745  1.00  0.00           H  
ATOM    744  HB2 HIS A  50      46.991  65.851  -2.884  1.00  0.00           H  
ATOM    745  HB3 HIS A  50      46.920  66.261  -1.182  1.00  0.00           H  
ATOM    746  HD1 HIS A  50      48.257  63.740  -3.542  1.00  0.00           H  
ATOM    747  HD2 HIS A  50      47.662  64.078   0.596  1.00  0.00           H  
ATOM    748  HE1 HIS A  50      49.660  61.901  -2.466  1.00  0.00           H  
ATOM    749  N   TYR A  51      44.448  63.097  -0.811  1.00  0.00           N  
ATOM    750  CA  TYR A  51      44.032  62.256   0.298  1.00  0.00           C  
ATOM    751  C   TYR A  51      45.240  61.764   1.096  1.00  0.00           C  
ATOM    752  O   TYR A  51      45.919  60.825   0.685  1.00  0.00           O  
ATOM    753  CB  TYR A  51      43.324  61.053  -0.327  1.00  0.00           C  
ATOM    754  CG  TYR A  51      41.938  61.371  -0.891  1.00  0.00           C  
ATOM    755  CD1 TYR A  51      40.875  61.582  -0.036  1.00  0.00           C  
ATOM    756  CD2 TYR A  51      41.750  61.446  -2.257  1.00  0.00           C  
ATOM    757  CE1 TYR A  51      39.571  61.880  -0.569  1.00  0.00           C  
ATOM    758  CE2 TYR A  51      40.446  61.745  -2.789  1.00  0.00           C  
ATOM    759  CZ  TYR A  51      39.420  61.948  -1.919  1.00  0.00           C  
ATOM    760  OH  TYR A  51      38.189  62.230  -2.421  1.00  0.00           O  
ATOM    761  H   TYR A  51      44.412  62.660  -1.710  1.00  0.00           H  
ATOM    762  HA  TYR A  51      43.393  62.853   0.951  1.00  0.00           H  
ATOM    763  HB2 TYR A  51      43.948  60.652  -1.126  1.00  0.00           H  
ATOM    764  HB3 TYR A  51      43.227  60.269   0.425  1.00  0.00           H  
ATOM    765  HD1 TYR A  51      41.024  61.522   1.041  1.00  0.00           H  
ATOM    766  HD2 TYR A  51      42.589  61.279  -2.933  1.00  0.00           H  
ATOM    767  HE1 TYR A  51      38.723  62.050   0.096  1.00  0.00           H  
ATOM    768  HE2 TYR A  51      40.284  61.808  -3.865  1.00  0.00           H  
ATOM    769  HH  TYR A  51      38.199  62.146  -3.417  1.00  0.00           H  
ATOM    770  N   VAL A  52      45.471  62.420   2.224  1.00  0.00           N  
ATOM    771  CA  VAL A  52      46.587  62.062   3.084  1.00  0.00           C  
ATOM    772  C   VAL A  52      46.217  60.821   3.900  1.00  0.00           C  
ATOM    773  O   VAL A  52      46.140  60.880   5.125  1.00  0.00           O  
ATOM    774  CB  VAL A  52      46.980  63.255   3.957  1.00  0.00           C  
ATOM    775  CG1 VAL A  52      47.305  64.478   3.097  1.00  0.00           C  
ATOM    776  CG2 VAL A  52      45.885  63.575   4.975  1.00  0.00           C  
ATOM    777  H   VAL A  52      44.914  63.183   2.552  1.00  0.00           H  
ATOM    778  HA  VAL A  52      47.433  61.819   2.441  1.00  0.00           H  
ATOM    779  HB  VAL A  52      47.882  62.984   4.508  1.00  0.00           H  
ATOM    780 HG11 VAL A  52      47.472  65.341   3.742  1.00  0.00           H  
ATOM    781 HG12 VAL A  52      48.203  64.283   2.512  1.00  0.00           H  
ATOM    782 HG13 VAL A  52      46.471  64.682   2.425  1.00  0.00           H  
ATOM    783 HG21 VAL A  52      46.281  63.456   5.984  1.00  0.00           H  
ATOM    784 HG22 VAL A  52      45.547  64.602   4.835  1.00  0.00           H  
ATOM    785 HG23 VAL A  52      45.046  62.894   4.832  1.00  0.00           H  
ATOM    786  N   GLY A  53      45.997  59.726   3.187  1.00  0.00           N  
ATOM    787  CA  GLY A  53      45.638  58.474   3.828  1.00  0.00           C  
ATOM    788  C   GLY A  53      44.785  57.606   2.900  1.00  0.00           C  
ATOM    789  O   GLY A  53      43.630  57.314   3.202  1.00  0.00           O  
ATOM    790  H   GLY A  53      46.062  59.686   2.189  1.00  0.00           H  
ATOM    791  HA2 GLY A  53      46.541  57.933   4.111  1.00  0.00           H  
ATOM    792  HA3 GLY A  53      45.087  58.677   4.748  1.00  0.00           H  
ATOM    793  N   PHE A  54      45.391  57.217   1.787  1.00  0.00           N  
ATOM    794  CA  PHE A  54      44.703  56.388   0.811  1.00  0.00           C  
ATOM    795  C   PHE A  54      45.690  55.789  -0.192  1.00  0.00           C  
ATOM    796  O   PHE A  54      45.992  54.597  -0.135  1.00  0.00           O  
ATOM    797  CB  PHE A  54      43.723  57.295   0.065  1.00  0.00           C  
ATOM    798  CG  PHE A  54      42.251  56.983   0.343  1.00  0.00           C  
ATOM    799  CD1 PHE A  54      41.595  56.066  -0.418  1.00  0.00           C  
ATOM    800  CD2 PHE A  54      41.598  57.622   1.349  1.00  0.00           C  
ATOM    801  CE1 PHE A  54      40.229  55.775  -0.161  1.00  0.00           C  
ATOM    802  CE2 PHE A  54      40.232  57.333   1.607  1.00  0.00           C  
ATOM    803  CZ  PHE A  54      39.577  56.415   0.845  1.00  0.00           C  
ATOM    804  H   PHE A  54      46.331  57.457   1.548  1.00  0.00           H  
ATOM    805  HA  PHE A  54      44.211  55.584   1.359  1.00  0.00           H  
ATOM    806  HB2 PHE A  54      43.921  58.331   0.340  1.00  0.00           H  
ATOM    807  HB3 PHE A  54      43.906  57.208  -1.005  1.00  0.00           H  
ATOM    808  HD1 PHE A  54      42.118  55.553  -1.226  1.00  0.00           H  
ATOM    809  HD2 PHE A  54      42.123  58.357   1.959  1.00  0.00           H  
ATOM    810  HE1 PHE A  54      39.704  55.041  -0.771  1.00  0.00           H  
ATOM    811  HE2 PHE A  54      39.708  57.845   2.414  1.00  0.00           H  
ATOM    812  HZ  PHE A  54      38.527  56.193   1.043  1.00  0.00           H  
ATOM    813  N   ASN A  55      46.164  56.641  -1.089  1.00  0.00           N  
ATOM    814  CA  ASN A  55      47.110  56.210  -2.103  1.00  0.00           C  
ATOM    815  C   ASN A  55      47.802  57.436  -2.703  1.00  0.00           C  
ATOM    816  O   ASN A  55      47.303  58.554  -2.584  1.00  0.00           O  
ATOM    817  CB  ASN A  55      46.402  55.465  -3.237  1.00  0.00           C  
ATOM    818  CG  ASN A  55      47.034  54.092  -3.469  1.00  0.00           C  
ATOM    819  OD1 ASN A  55      47.781  53.577  -2.654  1.00  0.00           O  
ATOM    820  ND2 ASN A  55      46.694  53.529  -4.626  1.00  0.00           N  
ATOM    821  H   ASN A  55      45.913  57.608  -1.128  1.00  0.00           H  
ATOM    822  HA  ASN A  55      47.806  55.551  -1.585  1.00  0.00           H  
ATOM    823  HB2 ASN A  55      45.345  55.348  -2.995  1.00  0.00           H  
ATOM    824  HB3 ASN A  55      46.455  56.055  -4.152  1.00  0.00           H  
ATOM    825 HD21 ASN A  55      46.077  54.006  -5.251  1.00  0.00           H  
ATOM    826 HD22 ASN A  55      47.057  52.630  -4.870  1.00  0.00           H  
ATOM    827  N   ARG A  56      48.940  57.185  -3.333  1.00  0.00           N  
ATOM    828  CA  ARG A  56      49.704  58.255  -3.952  1.00  0.00           C  
ATOM    829  C   ARG A  56      49.315  58.403  -5.423  1.00  0.00           C  
ATOM    830  O   ARG A  56      49.591  59.431  -6.042  1.00  0.00           O  
ATOM    831  CB  ARG A  56      51.207  57.985  -3.854  1.00  0.00           C  
ATOM    832  CG  ARG A  56      51.785  58.561  -2.558  1.00  0.00           C  
ATOM    833  CD  ARG A  56      52.257  60.001  -2.762  1.00  0.00           C  
ATOM    834  NE  ARG A  56      53.688  60.120  -2.401  1.00  0.00           N  
ATOM    835  CZ  ARG A  56      54.407  61.242  -2.540  1.00  0.00           C  
ATOM    836  NH1 ARG A  56      53.834  62.348  -3.035  1.00  0.00           N  
ATOM    837  NH2 ARG A  56      55.699  61.258  -2.186  1.00  0.00           N  
ATOM    838  H   ARG A  56      49.339  56.272  -3.425  1.00  0.00           H  
ATOM    839  HA  ARG A  56      49.443  59.148  -3.384  1.00  0.00           H  
ATOM    840  HB2 ARG A  56      51.391  56.911  -3.892  1.00  0.00           H  
ATOM    841  HB3 ARG A  56      51.717  58.426  -4.711  1.00  0.00           H  
ATOM    842  HG2 ARG A  56      51.029  58.530  -1.774  1.00  0.00           H  
ATOM    843  HG3 ARG A  56      52.619  57.945  -2.223  1.00  0.00           H  
ATOM    844  HD2 ARG A  56      52.110  60.298  -3.801  1.00  0.00           H  
ATOM    845  HD3 ARG A  56      51.662  60.678  -2.151  1.00  0.00           H  
ATOM    846  HE  ARG A  56      54.146  59.313  -2.030  1.00  0.00           H  
ATOM    847 HH11 ARG A  56      52.870  62.336  -3.299  1.00  0.00           H  
ATOM    848 HH12 ARG A  56      54.371  63.185  -3.138  1.00  0.00           H  
ATOM    849 HH21 ARG A  56      56.127  60.433  -1.818  1.00  0.00           H  
ATOM    850 HH22 ARG A  56      56.236  62.096  -2.290  1.00  0.00           H  
ATOM    851  N   ARG A  57      48.681  57.363  -5.944  1.00  0.00           N  
ATOM    852  CA  ARG A  57      48.251  57.364  -7.331  1.00  0.00           C  
ATOM    853  C   ARG A  57      46.827  57.910  -7.445  1.00  0.00           C  
ATOM    854  O   ARG A  57      46.071  57.506  -8.328  1.00  0.00           O  
ATOM    855  CB  ARG A  57      48.299  55.955  -7.925  1.00  0.00           C  
ATOM    856  CG  ARG A  57      47.315  55.026  -7.211  1.00  0.00           C  
ATOM    857  CD  ARG A  57      46.185  54.598  -8.149  1.00  0.00           C  
ATOM    858  NE  ARG A  57      46.167  53.123  -8.279  1.00  0.00           N  
ATOM    859  CZ  ARG A  57      47.052  52.421  -9.000  1.00  0.00           C  
ATOM    860  NH1 ARG A  57      48.031  53.054  -9.660  1.00  0.00           N  
ATOM    861  NH2 ARG A  57      46.958  51.086  -9.060  1.00  0.00           N  
ATOM    862  H   ARG A  57      48.460  56.531  -5.434  1.00  0.00           H  
ATOM    863  HA  ARG A  57      48.962  58.014  -7.842  1.00  0.00           H  
ATOM    864  HB2 ARG A  57      48.060  55.995  -8.987  1.00  0.00           H  
ATOM    865  HB3 ARG A  57      49.309  55.555  -7.840  1.00  0.00           H  
ATOM    866  HG2 ARG A  57      47.841  54.145  -6.843  1.00  0.00           H  
ATOM    867  HG3 ARG A  57      46.897  55.533  -6.341  1.00  0.00           H  
ATOM    868  HD2 ARG A  57      45.228  54.948  -7.765  1.00  0.00           H  
ATOM    869  HD3 ARG A  57      46.323  55.055  -9.129  1.00  0.00           H  
ATOM    870  HE  ARG A  57      45.449  52.619  -7.799  1.00  0.00           H  
ATOM    871 HH11 ARG A  57      48.101  54.051  -9.615  1.00  0.00           H  
ATOM    872 HH12 ARG A  57      48.691  52.531 -10.198  1.00  0.00           H  
ATOM    873 HH21 ARG A  57      46.227  50.613  -8.567  1.00  0.00           H  
ATOM    874 HH22 ARG A  57      47.619  50.562  -9.598  1.00  0.00           H  
ATOM    875  N   LEU A  58      46.501  58.821  -6.538  1.00  0.00           N  
ATOM    876  CA  LEU A  58      45.181  59.427  -6.526  1.00  0.00           C  
ATOM    877  C   LEU A  58      45.303  60.912  -6.870  1.00  0.00           C  
ATOM    878  O   LEU A  58      45.523  61.269  -8.026  1.00  0.00           O  
ATOM    879  CB  LEU A  58      44.482  59.159  -5.191  1.00  0.00           C  
ATOM    880  CG  LEU A  58      44.151  57.696  -4.888  1.00  0.00           C  
ATOM    881  CD1 LEU A  58      43.853  57.499  -3.400  1.00  0.00           C  
ATOM    882  CD2 LEU A  58      43.006  57.198  -5.772  1.00  0.00           C  
ATOM    883  H   LEU A  58      47.122  59.144  -5.823  1.00  0.00           H  
ATOM    884  HA  LEU A  58      44.591  58.939  -7.301  1.00  0.00           H  
ATOM    885  HB2 LEU A  58      45.114  59.542  -4.390  1.00  0.00           H  
ATOM    886  HB3 LEU A  58      43.555  59.733  -5.168  1.00  0.00           H  
ATOM    887  HG  LEU A  58      45.027  57.093  -5.124  1.00  0.00           H  
ATOM    888 HD11 LEU A  58      44.783  57.547  -2.834  1.00  0.00           H  
ATOM    889 HD12 LEU A  58      43.177  58.282  -3.058  1.00  0.00           H  
ATOM    890 HD13 LEU A  58      43.387  56.525  -3.250  1.00  0.00           H  
ATOM    891 HD21 LEU A  58      43.360  57.092  -6.799  1.00  0.00           H  
ATOM    892 HD22 LEU A  58      42.658  56.232  -5.406  1.00  0.00           H  
ATOM    893 HD23 LEU A  58      42.186  57.916  -5.743  1.00  0.00           H  
ATOM    894  N   ASP A  59      45.153  61.739  -5.845  1.00  0.00           N  
ATOM    895  CA  ASP A  59      45.243  63.177  -6.024  1.00  0.00           C  
ATOM    896  C   ASP A  59      44.424  63.586  -7.249  1.00  0.00           C  
ATOM    897  O   ASP A  59      44.929  63.572  -8.371  1.00  0.00           O  
ATOM    898  CB  ASP A  59      46.691  63.613  -6.257  1.00  0.00           C  
ATOM    899  CG  ASP A  59      47.709  62.473  -6.313  1.00  0.00           C  
ATOM    900  OD1 ASP A  59      48.055  61.968  -5.223  1.00  0.00           O  
ATOM    901  OD2 ASP A  59      48.118  62.133  -7.444  1.00  0.00           O  
ATOM    902  H   ASP A  59      44.974  61.439  -4.907  1.00  0.00           H  
ATOM    903  HA  ASP A  59      44.855  63.606  -5.101  1.00  0.00           H  
ATOM    904  HB2 ASP A  59      46.740  64.172  -7.191  1.00  0.00           H  
ATOM    905  HB3 ASP A  59      46.980  64.300  -5.461  1.00  0.00           H  
ATOM    906  N   GLU A  60      43.173  63.941  -6.994  1.00  0.00           N  
ATOM    907  CA  GLU A  60      42.279  64.354  -8.063  1.00  0.00           C  
ATOM    908  C   GLU A  60      41.500  65.604  -7.651  1.00  0.00           C  
ATOM    909  O   GLU A  60      41.426  65.931  -6.467  1.00  0.00           O  
ATOM    910  CB  GLU A  60      41.329  63.219  -8.451  1.00  0.00           C  
ATOM    911  CG  GLU A  60      40.381  62.879  -7.298  1.00  0.00           C  
ATOM    912  CD  GLU A  60      39.942  61.414  -7.365  1.00  0.00           C  
ATOM    913  OE1 GLU A  60      40.768  60.594  -7.819  1.00  0.00           O  
ATOM    914  OE2 GLU A  60      38.790  61.149  -6.958  1.00  0.00           O  
ATOM    915  H   GLU A  60      42.770  63.950  -6.079  1.00  0.00           H  
ATOM    916  HA  GLU A  60      42.926  64.583  -8.910  1.00  0.00           H  
ATOM    917  HB2 GLU A  60      40.750  63.509  -9.328  1.00  0.00           H  
ATOM    918  HB3 GLU A  60      41.904  62.335  -8.726  1.00  0.00           H  
ATOM    919  HG2 GLU A  60      40.877  63.071  -6.347  1.00  0.00           H  
ATOM    920  HG3 GLU A  60      39.506  63.527  -7.340  1.00  0.00           H  
ATOM    921  N   TRP A  61      40.938  66.269  -8.649  1.00  0.00           N  
ATOM    922  CA  TRP A  61      40.168  67.476  -8.405  1.00  0.00           C  
ATOM    923  C   TRP A  61      38.827  67.065  -7.792  1.00  0.00           C  
ATOM    924  O   TRP A  61      38.331  65.971  -8.053  1.00  0.00           O  
ATOM    925  CB  TRP A  61      40.013  68.297  -9.687  1.00  0.00           C  
ATOM    926  CG  TRP A  61      41.322  68.513 -10.449  1.00  0.00           C  
ATOM    927  CD1 TRP A  61      41.931  67.672 -11.296  1.00  0.00           C  
ATOM    928  CD2 TRP A  61      42.164  69.684 -10.399  1.00  0.00           C  
ATOM    929  NE1 TRP A  61      43.099  68.213 -11.795  1.00  0.00           N  
ATOM    930  CE2 TRP A  61      43.244  69.475 -11.231  1.00  0.00           C  
ATOM    931  CE3 TRP A  61      42.016  70.880  -9.675  1.00  0.00           C  
ATOM    932  CZ2 TRP A  61      44.261  70.420 -11.418  1.00  0.00           C  
ATOM    933  CZ3 TRP A  61      43.040  71.814  -9.872  1.00  0.00           C  
ATOM    934  CH2 TRP A  61      44.136  71.619 -10.706  1.00  0.00           C  
ATOM    935  H   TRP A  61      41.003  65.995  -9.609  1.00  0.00           H  
ATOM    936  HA  TRP A  61      40.726  68.092  -7.700  1.00  0.00           H  
ATOM    937  HB2 TRP A  61      39.301  67.797 -10.343  1.00  0.00           H  
ATOM    938  HB3 TRP A  61      39.587  69.268  -9.435  1.00  0.00           H  
ATOM    939  HD1 TRP A  61      41.552  66.684 -11.560  1.00  0.00           H  
ATOM    940  HE1 TRP A  61      43.781  67.738 -12.500  1.00  0.00           H  
ATOM    941  HE3 TRP A  61      41.172  71.068  -9.011  1.00  0.00           H  
ATOM    942  HZ2 TRP A  61      45.106  70.232 -12.081  1.00  0.00           H  
ATOM    943  HZ3 TRP A  61      42.975  72.759  -9.333  1.00  0.00           H  
ATOM    944  HH2 TRP A  61      44.892  72.397 -10.806  1.00  0.00           H  
ATOM    945  N   VAL A  62      38.278  67.966  -6.991  1.00  0.00           N  
ATOM    946  CA  VAL A  62      37.005  67.711  -6.340  1.00  0.00           C  
ATOM    947  C   VAL A  62      36.099  68.935  -6.503  1.00  0.00           C  
ATOM    948  O   VAL A  62      36.492  69.923  -7.119  1.00  0.00           O  
ATOM    949  CB  VAL A  62      37.233  67.328  -4.876  1.00  0.00           C  
ATOM    950  CG1 VAL A  62      38.334  66.272  -4.751  1.00  0.00           C  
ATOM    951  CG2 VAL A  62      37.556  68.560  -4.029  1.00  0.00           C  
ATOM    952  H   VAL A  62      38.688  68.855  -6.784  1.00  0.00           H  
ATOM    953  HA  VAL A  62      36.542  66.863  -6.843  1.00  0.00           H  
ATOM    954  HB  VAL A  62      36.308  66.892  -4.495  1.00  0.00           H  
ATOM    955 HG11 VAL A  62      39.308  66.761  -4.767  1.00  0.00           H  
ATOM    956 HG12 VAL A  62      38.213  65.731  -3.813  1.00  0.00           H  
ATOM    957 HG13 VAL A  62      38.265  65.575  -5.585  1.00  0.00           H  
ATOM    958 HG21 VAL A  62      36.676  69.201  -3.970  1.00  0.00           H  
ATOM    959 HG22 VAL A  62      37.845  68.246  -3.027  1.00  0.00           H  
ATOM    960 HG23 VAL A  62      38.377  69.111  -4.488  1.00  0.00           H  
ATOM    961  N   ASP A  63      34.906  68.826  -5.938  1.00  0.00           N  
ATOM    962  CA  ASP A  63      33.942  69.911  -6.013  1.00  0.00           C  
ATOM    963  C   ASP A  63      33.734  70.501  -4.617  1.00  0.00           C  
ATOM    964  O   ASP A  63      33.863  69.796  -3.617  1.00  0.00           O  
ATOM    965  CB  ASP A  63      32.588  69.411  -6.522  1.00  0.00           C  
ATOM    966  CG  ASP A  63      32.528  69.119  -8.022  1.00  0.00           C  
ATOM    967  OD1 ASP A  63      32.803  70.062  -8.795  1.00  0.00           O  
ATOM    968  OD2 ASP A  63      32.207  67.960  -8.364  1.00  0.00           O  
ATOM    969  H   ASP A  63      34.594  68.018  -5.439  1.00  0.00           H  
ATOM    970  HA  ASP A  63      34.373  70.629  -6.710  1.00  0.00           H  
ATOM    971  HB2 ASP A  63      32.327  68.501  -5.980  1.00  0.00           H  
ATOM    972  HB3 ASP A  63      31.828  70.154  -6.280  1.00  0.00           H  
ATOM    973  N   LYS A  64      33.417  71.786  -4.594  1.00  0.00           N  
ATOM    974  CA  LYS A  64      33.190  72.479  -3.337  1.00  0.00           C  
ATOM    975  C   LYS A  64      32.213  71.668  -2.482  1.00  0.00           C  
ATOM    976  O   LYS A  64      32.479  71.405  -1.310  1.00  0.00           O  
ATOM    977  CB  LYS A  64      32.736  73.917  -3.592  1.00  0.00           C  
ATOM    978  CG  LYS A  64      33.873  74.755  -4.180  1.00  0.00           C  
ATOM    979  CD  LYS A  64      33.647  76.246  -3.920  1.00  0.00           C  
ATOM    980  CE  LYS A  64      34.757  76.823  -3.039  1.00  0.00           C  
ATOM    981  NZ  LYS A  64      34.882  78.283  -3.254  1.00  0.00           N  
ATOM    982  H   LYS A  64      33.314  72.352  -5.412  1.00  0.00           H  
ATOM    983  HA  LYS A  64      34.145  72.530  -2.815  1.00  0.00           H  
ATOM    984  HB2 LYS A  64      31.887  73.919  -4.275  1.00  0.00           H  
ATOM    985  HB3 LYS A  64      32.394  74.365  -2.658  1.00  0.00           H  
ATOM    986  HG2 LYS A  64      34.822  74.446  -3.742  1.00  0.00           H  
ATOM    987  HG3 LYS A  64      33.944  74.576  -5.253  1.00  0.00           H  
ATOM    988  HD2 LYS A  64      33.614  76.783  -4.869  1.00  0.00           H  
ATOM    989  HD3 LYS A  64      32.681  76.392  -3.438  1.00  0.00           H  
ATOM    990  HE2 LYS A  64      34.539  76.621  -1.990  1.00  0.00           H  
ATOM    991  HE3 LYS A  64      35.703  76.334  -3.269  1.00  0.00           H  
ATOM    992  HZ1 LYS A  64      34.691  78.497  -4.212  1.00  0.00           H  
ATOM    993  HZ2 LYS A  64      34.227  78.763  -2.668  1.00  0.00           H  
ATOM    994  HZ3 LYS A  64      35.810  78.574  -3.024  1.00  0.00           H  
ATOM    995  N   ASN A  65      31.103  71.296  -3.102  1.00  0.00           N  
ATOM    996  CA  ASN A  65      30.086  70.520  -2.412  1.00  0.00           C  
ATOM    997  C   ASN A  65      30.721  69.253  -1.835  1.00  0.00           C  
ATOM    998  O   ASN A  65      30.500  68.918  -0.672  1.00  0.00           O  
ATOM    999  CB  ASN A  65      28.972  70.096  -3.372  1.00  0.00           C  
ATOM   1000  CG  ASN A  65      27.655  70.793  -3.024  1.00  0.00           C  
ATOM   1001  OD1 ASN A  65      27.349  71.063  -1.875  1.00  0.00           O  
ATOM   1002  ND2 ASN A  65      26.894  71.068  -4.080  1.00  0.00           N  
ATOM   1003  H   ASN A  65      30.895  71.513  -4.055  1.00  0.00           H  
ATOM   1004  HA  ASN A  65      29.697  71.181  -1.638  1.00  0.00           H  
ATOM   1005  HB2 ASN A  65      29.256  70.338  -4.395  1.00  0.00           H  
ATOM   1006  HB3 ASN A  65      28.838  69.015  -3.326  1.00  0.00           H  
ATOM   1007 HD21 ASN A  65      27.203  70.818  -4.998  1.00  0.00           H  
ATOM   1008 HD22 ASN A  65      26.012  71.524  -3.956  1.00  0.00           H  
ATOM   1009  N   ARG A  66      31.494  68.582  -2.675  1.00  0.00           N  
ATOM   1010  CA  ARG A  66      32.163  67.359  -2.262  1.00  0.00           C  
ATOM   1011  C   ARG A  66      33.022  67.615  -1.023  1.00  0.00           C  
ATOM   1012  O   ARG A  66      33.304  66.695  -0.258  1.00  0.00           O  
ATOM   1013  CB  ARG A  66      33.049  66.811  -3.383  1.00  0.00           C  
ATOM   1014  CG  ARG A  66      32.203  66.176  -4.489  1.00  0.00           C  
ATOM   1015  CD  ARG A  66      33.089  65.506  -5.541  1.00  0.00           C  
ATOM   1016  NE  ARG A  66      32.316  65.273  -6.782  1.00  0.00           N  
ATOM   1017  CZ  ARG A  66      31.425  64.284  -6.936  1.00  0.00           C  
ATOM   1018  NH1 ARG A  66      31.191  63.430  -5.931  1.00  0.00           N  
ATOM   1019  NH2 ARG A  66      30.769  64.149  -8.097  1.00  0.00           N  
ATOM   1020  H   ARG A  66      31.669  68.861  -3.620  1.00  0.00           H  
ATOM   1021  HA  ARG A  66      31.354  66.661  -2.043  1.00  0.00           H  
ATOM   1022  HB2 ARG A  66      33.654  67.615  -3.800  1.00  0.00           H  
ATOM   1023  HB3 ARG A  66      33.737  66.070  -2.978  1.00  0.00           H  
ATOM   1024  HG2 ARG A  66      31.526  65.439  -4.057  1.00  0.00           H  
ATOM   1025  HG3 ARG A  66      31.584  66.939  -4.962  1.00  0.00           H  
ATOM   1026  HD2 ARG A  66      33.953  66.136  -5.755  1.00  0.00           H  
ATOM   1027  HD3 ARG A  66      33.472  64.561  -5.159  1.00  0.00           H  
ATOM   1028  HE  ARG A  66      32.466  65.893  -7.552  1.00  0.00           H  
ATOM   1029 HH11 ARG A  66      31.681  63.531  -5.065  1.00  0.00           H  
ATOM   1030 HH12 ARG A  66      30.527  62.691  -6.047  1.00  0.00           H  
ATOM   1031 HH21 ARG A  66      30.944  64.786  -8.847  1.00  0.00           H  
ATOM   1032 HH22 ARG A  66      30.105  63.410  -8.213  1.00  0.00           H  
ATOM   1033  N   LEU A  67      33.413  68.871  -0.862  1.00  0.00           N  
ATOM   1034  CA  LEU A  67      34.233  69.261   0.272  1.00  0.00           C  
ATOM   1035  C   LEU A  67      33.328  69.707   1.422  1.00  0.00           C  
ATOM   1036  O   LEU A  67      32.111  69.791   1.262  1.00  0.00           O  
ATOM   1037  CB  LEU A  67      35.261  70.314  -0.146  1.00  0.00           C  
ATOM   1038  CG  LEU A  67      36.282  69.874  -1.197  1.00  0.00           C  
ATOM   1039  CD1 LEU A  67      36.747  71.062  -2.041  1.00  0.00           C  
ATOM   1040  CD2 LEU A  67      37.456  69.138  -0.547  1.00  0.00           C  
ATOM   1041  H   LEU A  67      33.178  69.615  -1.489  1.00  0.00           H  
ATOM   1042  HA  LEU A  67      34.788  68.377   0.592  1.00  0.00           H  
ATOM   1043  HB2 LEU A  67      34.725  71.182  -0.530  1.00  0.00           H  
ATOM   1044  HB3 LEU A  67      35.801  70.639   0.743  1.00  0.00           H  
ATOM   1045  HG  LEU A  67      35.796  69.170  -1.873  1.00  0.00           H  
ATOM   1046 HD11 LEU A  67      36.408  71.990  -1.580  1.00  0.00           H  
ATOM   1047 HD12 LEU A  67      37.835  71.062  -2.100  1.00  0.00           H  
ATOM   1048 HD13 LEU A  67      36.329  70.981  -3.044  1.00  0.00           H  
ATOM   1049 HD21 LEU A  67      37.410  68.080  -0.805  1.00  0.00           H  
ATOM   1050 HD22 LEU A  67      38.394  69.559  -0.908  1.00  0.00           H  
ATOM   1051 HD23 LEU A  67      37.401  69.251   0.536  1.00  0.00           H  
ATOM   1052  N   ALA A  68      33.957  69.982   2.555  1.00  0.00           N  
ATOM   1053  CA  ALA A  68      33.223  70.418   3.731  1.00  0.00           C  
ATOM   1054  C   ALA A  68      33.470  71.910   3.957  1.00  0.00           C  
ATOM   1055  O   ALA A  68      34.546  72.305   4.402  1.00  0.00           O  
ATOM   1056  CB  ALA A  68      33.639  69.570   4.936  1.00  0.00           C  
ATOM   1057  H   ALA A  68      34.946  69.910   2.677  1.00  0.00           H  
ATOM   1058  HA  ALA A  68      32.162  70.257   3.540  1.00  0.00           H  
ATOM   1059  HB1 ALA A  68      33.548  68.513   4.685  1.00  0.00           H  
ATOM   1060  HB2 ALA A  68      34.673  69.793   5.198  1.00  0.00           H  
ATOM   1061  HB3 ALA A  68      32.991  69.799   5.782  1.00  0.00           H  
ATOM   1062  N   LEU A  69      32.454  72.700   3.639  1.00  0.00           N  
ATOM   1063  CA  LEU A  69      32.547  74.141   3.801  1.00  0.00           C  
ATOM   1064  C   LEU A  69      31.566  74.592   4.885  1.00  0.00           C  
ATOM   1065  O   LEU A  69      30.368  74.709   4.633  1.00  0.00           O  
ATOM   1066  CB  LEU A  69      32.346  74.845   2.458  1.00  0.00           C  
ATOM   1067  CG  LEU A  69      33.240  74.369   1.311  1.00  0.00           C  
ATOM   1068  CD1 LEU A  69      32.600  74.673  -0.046  1.00  0.00           C  
ATOM   1069  CD2 LEU A  69      34.644  74.966   1.427  1.00  0.00           C  
ATOM   1070  H   LEU A  69      31.582  72.370   3.277  1.00  0.00           H  
ATOM   1071  HA  LEU A  69      33.560  74.367   4.135  1.00  0.00           H  
ATOM   1072  HB2 LEU A  69      31.306  74.721   2.157  1.00  0.00           H  
ATOM   1073  HB3 LEU A  69      32.511  75.913   2.602  1.00  0.00           H  
ATOM   1074  HG  LEU A  69      33.343  73.288   1.383  1.00  0.00           H  
ATOM   1075 HD11 LEU A  69      31.653  74.139  -0.126  1.00  0.00           H  
ATOM   1076 HD12 LEU A  69      32.423  75.745  -0.132  1.00  0.00           H  
ATOM   1077 HD13 LEU A  69      33.268  74.348  -0.843  1.00  0.00           H  
ATOM   1078 HD21 LEU A  69      35.087  74.672   2.379  1.00  0.00           H  
ATOM   1079 HD22 LEU A  69      35.264  74.598   0.610  1.00  0.00           H  
ATOM   1080 HD23 LEU A  69      34.583  76.054   1.375  1.00  0.00           H  
ATOM   1081  N   THR A  70      32.111  74.833   6.068  1.00  0.00           N  
ATOM   1082  CA  THR A  70      31.299  75.269   7.192  1.00  0.00           C  
ATOM   1083  C   THR A  70      30.400  74.129   7.673  1.00  0.00           C  
ATOM   1084  O   THR A  70      30.140  73.182   6.933  1.00  0.00           O  
ATOM   1085  CB  THR A  70      30.523  76.513   6.758  1.00  0.00           C  
ATOM   1086  OG1 THR A  70      31.516  77.362   6.190  1.00  0.00           O  
ATOM   1087  CG2 THR A  70      29.987  77.313   7.949  1.00  0.00           C  
ATOM   1088  H   THR A  70      33.087  74.735   6.265  1.00  0.00           H  
ATOM   1089  HA  THR A  70      31.964  75.523   8.018  1.00  0.00           H  
ATOM   1090  HB  THR A  70      29.718  76.251   6.072  1.00  0.00           H  
ATOM   1091  HG1 THR A  70      31.887  76.946   5.359  1.00  0.00           H  
ATOM   1092 HG21 THR A  70      30.821  77.663   8.556  1.00  0.00           H  
ATOM   1093 HG22 THR A  70      29.418  78.169   7.584  1.00  0.00           H  
ATOM   1094 HG23 THR A  70      29.339  76.677   8.552  1.00  0.00           H  
ATOM   1095  N   LYS A  71      29.951  74.257   8.914  1.00  0.00           N  
ATOM   1096  CA  LYS A  71      29.086  73.249   9.503  1.00  0.00           C  
ATOM   1097  C   LYS A  71      27.906  72.983   8.566  1.00  0.00           C  
ATOM   1098  O   LYS A  71      27.306  71.910   8.606  1.00  0.00           O  
ATOM   1099  CB  LYS A  71      28.667  73.662  10.916  1.00  0.00           C  
ATOM   1100  CG  LYS A  71      29.635  73.101  11.961  1.00  0.00           C  
ATOM   1101  CD  LYS A  71      30.415  74.225  12.645  1.00  0.00           C  
ATOM   1102  CE  LYS A  71      31.882  73.834  12.839  1.00  0.00           C  
ATOM   1103  NZ  LYS A  71      32.750  74.602  11.919  1.00  0.00           N  
ATOM   1104  H   LYS A  71      30.166  75.030   9.510  1.00  0.00           H  
ATOM   1105  HA  LYS A  71      29.668  72.332   9.595  1.00  0.00           H  
ATOM   1106  HB2 LYS A  71      28.640  74.750  10.988  1.00  0.00           H  
ATOM   1107  HB3 LYS A  71      27.658  73.305  11.119  1.00  0.00           H  
ATOM   1108  HG2 LYS A  71      29.079  72.533  12.707  1.00  0.00           H  
ATOM   1109  HG3 LYS A  71      30.327  72.409  11.484  1.00  0.00           H  
ATOM   1110  HD2 LYS A  71      30.354  75.133  12.044  1.00  0.00           H  
ATOM   1111  HD3 LYS A  71      29.964  74.451  13.611  1.00  0.00           H  
ATOM   1112  HE2 LYS A  71      32.180  74.019  13.871  1.00  0.00           H  
ATOM   1113  HE3 LYS A  71      32.006  72.766  12.658  1.00  0.00           H  
ATOM   1114  HZ1 LYS A  71      33.607  74.830  12.381  1.00  0.00           H  
ATOM   1115  HZ2 LYS A  71      32.945  74.052  11.107  1.00  0.00           H  
ATOM   1116  HZ3 LYS A  71      32.283  75.445  11.647  1.00  0.00           H  
ATOM   1117  N   THR A  72      27.610  73.977   7.743  1.00  0.00           N  
ATOM   1118  CA  THR A  72      26.513  73.864   6.797  1.00  0.00           C  
ATOM   1119  C   THR A  72      26.460  72.452   6.209  1.00  0.00           C  
ATOM   1120  O   THR A  72      25.406  71.819   6.202  1.00  0.00           O  
ATOM   1121  CB  THR A  72      26.686  74.957   5.739  1.00  0.00           C  
ATOM   1122  OG1 THR A  72      26.078  76.105   6.324  1.00  0.00           O  
ATOM   1123  CG2 THR A  72      25.853  74.693   4.483  1.00  0.00           C  
ATOM   1124  H   THR A  72      28.103  74.847   7.716  1.00  0.00           H  
ATOM   1125  HA  THR A  72      25.578  74.022   7.333  1.00  0.00           H  
ATOM   1126  HB  THR A  72      27.738  75.091   5.488  1.00  0.00           H  
ATOM   1127  HG1 THR A  72      25.154  75.882   6.636  1.00  0.00           H  
ATOM   1128 HG21 THR A  72      26.054  73.686   4.118  1.00  0.00           H  
ATOM   1129 HG22 THR A  72      24.794  74.788   4.723  1.00  0.00           H  
ATOM   1130 HG23 THR A  72      26.117  75.417   3.713  1.00  0.00           H  
ATOM   1131  N   VAL A  73      27.610  72.002   5.729  1.00  0.00           N  
ATOM   1132  CA  VAL A  73      27.708  70.677   5.140  1.00  0.00           C  
ATOM   1133  C   VAL A  73      28.726  69.848   5.926  1.00  0.00           C  
ATOM   1134  O   VAL A  73      29.780  70.354   6.309  1.00  0.00           O  
ATOM   1135  CB  VAL A  73      28.048  70.790   3.652  1.00  0.00           C  
ATOM   1136  CG1 VAL A  73      27.037  71.679   2.924  1.00  0.00           C  
ATOM   1137  CG2 VAL A  73      29.475  71.306   3.454  1.00  0.00           C  
ATOM   1138  H   VAL A  73      28.462  72.525   5.737  1.00  0.00           H  
ATOM   1139  HA  VAL A  73      26.729  70.206   5.227  1.00  0.00           H  
ATOM   1140  HB  VAL A  73      27.990  69.791   3.219  1.00  0.00           H  
ATOM   1141 HG11 VAL A  73      26.103  71.700   3.484  1.00  0.00           H  
ATOM   1142 HG12 VAL A  73      27.436  72.690   2.841  1.00  0.00           H  
ATOM   1143 HG13 VAL A  73      26.854  71.279   1.927  1.00  0.00           H  
ATOM   1144 HG21 VAL A  73      29.766  71.175   2.411  1.00  0.00           H  
ATOM   1145 HG22 VAL A  73      29.519  72.363   3.714  1.00  0.00           H  
ATOM   1146 HG23 VAL A  73      30.156  70.746   4.094  1.00  0.00           H  
ATOM   1147  N   LYS A  74      28.376  68.590   6.142  1.00  0.00           N  
ATOM   1148  CA  LYS A  74      29.246  67.687   6.875  1.00  0.00           C  
ATOM   1149  C   LYS A  74      28.535  66.344   7.066  1.00  0.00           C  
ATOM   1150  O   LYS A  74      27.383  66.185   6.666  1.00  0.00           O  
ATOM   1151  CB  LYS A  74      29.706  68.330   8.184  1.00  0.00           C  
ATOM   1152  CG  LYS A  74      31.209  68.615   8.155  1.00  0.00           C  
ATOM   1153  CD  LYS A  74      31.632  69.451   9.364  1.00  0.00           C  
ATOM   1154  CE  LYS A  74      31.996  68.555  10.550  1.00  0.00           C  
ATOM   1155  NZ  LYS A  74      30.791  68.232  11.346  1.00  0.00           N  
ATOM   1156  H   LYS A  74      27.516  68.186   5.827  1.00  0.00           H  
ATOM   1157  HA  LYS A  74      30.134  67.522   6.266  1.00  0.00           H  
ATOM   1158  HB2 LYS A  74      29.160  69.259   8.349  1.00  0.00           H  
ATOM   1159  HB3 LYS A  74      29.473  67.670   9.019  1.00  0.00           H  
ATOM   1160  HG2 LYS A  74      31.761  67.675   8.147  1.00  0.00           H  
ATOM   1161  HG3 LYS A  74      31.466  69.143   7.236  1.00  0.00           H  
ATOM   1162  HD2 LYS A  74      32.486  70.075   9.100  1.00  0.00           H  
ATOM   1163  HD3 LYS A  74      30.823  70.123   9.647  1.00  0.00           H  
ATOM   1164  HE2 LYS A  74      32.458  67.636  10.190  1.00  0.00           H  
ATOM   1165  HE3 LYS A  74      32.731  69.056  11.180  1.00  0.00           H  
ATOM   1166  HZ1 LYS A  74      30.463  67.320  11.099  1.00  0.00           H  
ATOM   1167  HZ2 LYS A  74      31.018  68.254  12.319  1.00  0.00           H  
ATOM   1168  HZ3 LYS A  74      30.076  68.906  11.156  1.00  0.00           H  
ATOM   1169  N   ASP A  75      29.253  65.413   7.678  1.00  0.00           N  
ATOM   1170  CA  ASP A  75      28.705  64.090   7.928  1.00  0.00           C  
ATOM   1171  C   ASP A  75      27.488  64.212   8.846  1.00  0.00           C  
ATOM   1172  O   ASP A  75      26.428  63.658   8.555  1.00  0.00           O  
ATOM   1173  CB  ASP A  75      29.732  63.192   8.620  1.00  0.00           C  
ATOM   1174  CG  ASP A  75      29.172  61.882   9.178  1.00  0.00           C  
ATOM   1175  OD1 ASP A  75      28.009  61.572   8.841  1.00  0.00           O  
ATOM   1176  OD2 ASP A  75      29.920  61.221   9.931  1.00  0.00           O  
ATOM   1177  H   ASP A  75      30.189  65.551   8.000  1.00  0.00           H  
ATOM   1178  HA  ASP A  75      28.449  63.697   6.944  1.00  0.00           H  
ATOM   1179  HB2 ASP A  75      30.524  62.956   7.909  1.00  0.00           H  
ATOM   1180  HB3 ASP A  75      30.190  63.751   9.435  1.00  0.00           H  
ATOM   1181  N   ALA A  76      27.679  64.940   9.937  1.00  0.00           N  
ATOM   1182  CA  ALA A  76      26.611  65.140  10.899  1.00  0.00           C  
ATOM   1183  C   ALA A  76      27.088  66.096  11.994  1.00  0.00           C  
ATOM   1184  O   ALA A  76      28.134  65.875  12.603  1.00  0.00           O  
ATOM   1185  CB  ALA A  76      26.166  63.788  11.460  1.00  0.00           C  
ATOM   1186  H   ALA A  76      28.544  65.386  10.166  1.00  0.00           H  
ATOM   1187  HA  ALA A  76      25.770  65.595  10.373  1.00  0.00           H  
ATOM   1188  HB1 ALA A  76      25.305  63.930  12.113  1.00  0.00           H  
ATOM   1189  HB2 ALA A  76      25.895  63.126  10.638  1.00  0.00           H  
ATOM   1190  HB3 ALA A  76      26.984  63.344  12.028  1.00  0.00           H  
ATOM   1191  N   VAL A  77      26.299  67.138  12.212  1.00  0.00           N  
ATOM   1192  CA  VAL A  77      26.629  68.128  13.223  1.00  0.00           C  
ATOM   1193  C   VAL A  77      25.966  67.741  14.546  1.00  0.00           C  
ATOM   1194  O   VAL A  77      25.448  68.598  15.260  1.00  0.00           O  
ATOM   1195  CB  VAL A  77      26.227  69.524  12.739  1.00  0.00           C  
ATOM   1196  CG1 VAL A  77      26.969  69.893  11.453  1.00  0.00           C  
ATOM   1197  CG2 VAL A  77      24.712  69.621  12.546  1.00  0.00           C  
ATOM   1198  H   VAL A  77      25.450  67.310  11.712  1.00  0.00           H  
ATOM   1199  HA  VAL A  77      27.711  68.116  13.354  1.00  0.00           H  
ATOM   1200  HB  VAL A  77      26.514  70.240  13.508  1.00  0.00           H  
ATOM   1201 HG11 VAL A  77      28.025  70.049  11.675  1.00  0.00           H  
ATOM   1202 HG12 VAL A  77      26.865  69.085  10.729  1.00  0.00           H  
ATOM   1203 HG13 VAL A  77      26.545  70.808  11.039  1.00  0.00           H  
ATOM   1204 HG21 VAL A  77      24.282  70.223  13.347  1.00  0.00           H  
ATOM   1205 HG22 VAL A  77      24.498  70.090  11.585  1.00  0.00           H  
ATOM   1206 HG23 VAL A  77      24.278  68.622  12.569  1.00  0.00           H  
ATOM   1207  N   GLN A  78      26.004  66.447  14.833  1.00  0.00           N  
ATOM   1208  CA  GLN A  78      25.413  65.936  16.058  1.00  0.00           C  
ATOM   1209  C   GLN A  78      26.295  66.285  17.259  1.00  0.00           C  
ATOM   1210  O   GLN A  78      25.835  66.921  18.206  1.00  0.00           O  
ATOM   1211  CB  GLN A  78      25.185  64.425  15.967  1.00  0.00           C  
ATOM   1212  CG  GLN A  78      23.722  64.074  16.247  1.00  0.00           C  
ATOM   1213  CD  GLN A  78      23.534  62.560  16.366  1.00  0.00           C  
ATOM   1214  OE1 GLN A  78      23.977  61.926  17.308  1.00  0.00           O  
ATOM   1215  NE2 GLN A  78      22.854  62.020  15.359  1.00  0.00           N  
ATOM   1216  H   GLN A  78      26.427  65.757  14.247  1.00  0.00           H  
ATOM   1217  HA  GLN A  78      24.450  66.438  16.147  1.00  0.00           H  
ATOM   1218  HB2 GLN A  78      25.464  64.071  14.975  1.00  0.00           H  
ATOM   1219  HB3 GLN A  78      25.828  63.913  16.681  1.00  0.00           H  
ATOM   1220  HG2 GLN A  78      23.399  64.558  17.169  1.00  0.00           H  
ATOM   1221  HG3 GLN A  78      23.091  64.461  15.447  1.00  0.00           H  
ATOM   1222 HE21 GLN A  78      22.517  62.597  14.615  1.00  0.00           H  
ATOM   1223 HE22 GLN A  78      22.680  61.036  15.345  1.00  0.00           H  
ATOM   1224  N   LYS A  79      27.546  65.854  17.180  1.00  0.00           N  
ATOM   1225  CA  LYS A  79      28.495  66.113  18.248  1.00  0.00           C  
ATOM   1226  C   LYS A  79      29.235  67.421  17.960  1.00  0.00           C  
ATOM   1227  O   LYS A  79      28.979  68.438  18.602  1.00  0.00           O  
ATOM   1228  CB  LYS A  79      29.422  64.912  18.444  1.00  0.00           C  
ATOM   1229  CG  LYS A  79      30.069  64.941  19.831  1.00  0.00           C  
ATOM   1230  CD  LYS A  79      30.599  63.558  20.217  1.00  0.00           C  
ATOM   1231  CE  LYS A  79      29.670  62.877  21.224  1.00  0.00           C  
ATOM   1232  NZ  LYS A  79      28.867  61.826  20.561  1.00  0.00           N  
ATOM   1233  H   LYS A  79      27.910  65.337  16.406  1.00  0.00           H  
ATOM   1234  HA  LYS A  79      27.925  66.235  19.169  1.00  0.00           H  
ATOM   1235  HB2 LYS A  79      28.857  63.988  18.322  1.00  0.00           H  
ATOM   1236  HB3 LYS A  79      30.196  64.915  17.677  1.00  0.00           H  
ATOM   1237  HG2 LYS A  79      30.887  65.661  19.839  1.00  0.00           H  
ATOM   1238  HG3 LYS A  79      29.342  65.274  20.569  1.00  0.00           H  
ATOM   1239  HD2 LYS A  79      30.691  62.937  19.325  1.00  0.00           H  
ATOM   1240  HD3 LYS A  79      31.597  63.653  20.643  1.00  0.00           H  
ATOM   1241  HE2 LYS A  79      30.258  62.439  22.031  1.00  0.00           H  
ATOM   1242  HE3 LYS A  79      29.010  63.617  21.676  1.00  0.00           H  
ATOM   1243  HZ1 LYS A  79      28.653  61.105  21.220  1.00  0.00           H  
ATOM   1244  HZ2 LYS A  79      28.018  62.224  20.214  1.00  0.00           H  
ATOM   1245  HZ3 LYS A  79      29.388  61.439  19.800  1.00  0.00           H  
ATOM   1246  N   ASN A  80      30.140  67.351  16.994  1.00  0.00           N  
ATOM   1247  CA  ASN A  80      30.920  68.515  16.613  1.00  0.00           C  
ATOM   1248  C   ASN A  80      31.802  68.941  17.790  1.00  0.00           C  
ATOM   1249  O   ASN A  80      31.308  69.489  18.774  1.00  0.00           O  
ATOM   1250  CB  ASN A  80      30.012  69.693  16.254  1.00  0.00           C  
ATOM   1251  CG  ASN A  80      30.698  70.633  15.261  1.00  0.00           C  
ATOM   1252  OD1 ASN A  80      30.501  70.561  14.060  1.00  0.00           O  
ATOM   1253  ND2 ASN A  80      31.514  71.517  15.829  1.00  0.00           N  
ATOM   1254  H   ASN A  80      30.344  66.519  16.478  1.00  0.00           H  
ATOM   1255  HA  ASN A  80      31.503  68.200  15.748  1.00  0.00           H  
ATOM   1256  HB2 ASN A  80      29.081  69.321  15.825  1.00  0.00           H  
ATOM   1257  HB3 ASN A  80      29.748  70.243  17.158  1.00  0.00           H  
ATOM   1258 HD21 ASN A  80      31.632  71.524  16.822  1.00  0.00           H  
ATOM   1259 HD22 ASN A  80      32.010  72.175  15.262  1.00  0.00           H  
ATOM   1260  N   SER A  81      33.092  68.672  17.649  1.00  0.00           N  
ATOM   1261  CA  SER A  81      34.046  69.019  18.687  1.00  0.00           C  
ATOM   1262  C   SER A  81      35.289  69.657  18.063  1.00  0.00           C  
ATOM   1263  O   SER A  81      36.081  68.976  17.412  1.00  0.00           O  
ATOM   1264  CB  SER A  81      34.438  67.790  19.510  1.00  0.00           C  
ATOM   1265  OG  SER A  81      35.428  68.094  20.487  1.00  0.00           O  
ATOM   1266  H   SER A  81      33.484  68.225  16.844  1.00  0.00           H  
ATOM   1267  HA  SER A  81      33.530  69.734  19.326  1.00  0.00           H  
ATOM   1268  HB2 SER A  81      33.552  67.388  20.004  1.00  0.00           H  
ATOM   1269  HB3 SER A  81      34.812  67.012  18.845  1.00  0.00           H  
ATOM   1270  HG  SER A  81      36.323  68.185  20.051  1.00  0.00           H  
ATOM   1271  N   GLU A  82      35.422  70.957  18.282  1.00  0.00           N  
ATOM   1272  CA  GLU A  82      36.555  71.693  17.748  1.00  0.00           C  
ATOM   1273  C   GLU A  82      36.798  72.961  18.571  1.00  0.00           C  
ATOM   1274  O   GLU A  82      35.869  73.513  19.158  1.00  0.00           O  
ATOM   1275  CB  GLU A  82      36.343  72.031  16.271  1.00  0.00           C  
ATOM   1276  CG  GLU A  82      37.378  71.325  15.394  1.00  0.00           C  
ATOM   1277  CD  GLU A  82      36.812  71.039  14.001  1.00  0.00           C  
ATOM   1278  OE1 GLU A  82      36.008  71.874  13.534  1.00  0.00           O  
ATOM   1279  OE2 GLU A  82      37.197  69.993  13.436  1.00  0.00           O  
ATOM   1280  H   GLU A  82      34.773  71.503  18.812  1.00  0.00           H  
ATOM   1281  HA  GLU A  82      37.408  71.022  17.842  1.00  0.00           H  
ATOM   1282  HB2 GLU A  82      35.340  71.735  15.967  1.00  0.00           H  
ATOM   1283  HB3 GLU A  82      36.415  73.110  16.128  1.00  0.00           H  
ATOM   1284  HG2 GLU A  82      38.271  71.944  15.307  1.00  0.00           H  
ATOM   1285  HG3 GLU A  82      37.683  70.390  15.865  1.00  0.00           H  
ATOM   1286  N   LYS A  83      38.054  73.385  18.588  1.00  0.00           N  
ATOM   1287  CA  LYS A  83      38.431  74.576  19.328  1.00  0.00           C  
ATOM   1288  C   LYS A  83      37.972  75.817  18.560  1.00  0.00           C  
ATOM   1289  O   LYS A  83      37.262  75.705  17.561  1.00  0.00           O  
ATOM   1290  CB  LYS A  83      39.930  74.563  19.637  1.00  0.00           C  
ATOM   1291  CG  LYS A  83      40.224  73.742  20.894  1.00  0.00           C  
ATOM   1292  CD  LYS A  83      41.658  73.210  20.878  1.00  0.00           C  
ATOM   1293  CE  LYS A  83      42.306  73.335  22.259  1.00  0.00           C  
ATOM   1294  NZ  LYS A  83      43.711  72.877  22.216  1.00  0.00           N  
ATOM   1295  H   LYS A  83      38.804  72.930  18.108  1.00  0.00           H  
ATOM   1296  HA  LYS A  83      37.906  74.547  20.283  1.00  0.00           H  
ATOM   1297  HB2 LYS A  83      40.475  74.147  18.790  1.00  0.00           H  
ATOM   1298  HB3 LYS A  83      40.286  75.584  19.774  1.00  0.00           H  
ATOM   1299  HG2 LYS A  83      40.071  74.359  21.780  1.00  0.00           H  
ATOM   1300  HG3 LYS A  83      39.524  72.910  20.962  1.00  0.00           H  
ATOM   1301  HD2 LYS A  83      41.659  72.166  20.566  1.00  0.00           H  
ATOM   1302  HD3 LYS A  83      42.247  73.762  20.145  1.00  0.00           H  
ATOM   1303  HE2 LYS A  83      42.265  74.373  22.593  1.00  0.00           H  
ATOM   1304  HE3 LYS A  83      41.746  72.746  22.985  1.00  0.00           H  
ATOM   1305  HZ1 LYS A  83      43.936  72.408  23.070  1.00  0.00           H  
ATOM   1306  HZ2 LYS A  83      43.834  72.247  21.448  1.00  0.00           H  
ATOM   1307  HZ3 LYS A  83      44.316  73.665  22.099  1.00  0.00           H  
ATOM   1308  N   TYR A  84      38.397  76.970  19.054  1.00  0.00           N  
ATOM   1309  CA  TYR A  84      38.038  78.231  18.426  1.00  0.00           C  
ATOM   1310  C   TYR A  84      39.282  78.970  17.930  1.00  0.00           C  
ATOM   1311  O   TYR A  84      40.404  78.610  18.284  1.00  0.00           O  
ATOM   1312  CB  TYR A  84      37.363  79.068  19.514  1.00  0.00           C  
ATOM   1313  CG  TYR A  84      36.451  80.171  18.975  1.00  0.00           C  
ATOM   1314  CD1 TYR A  84      36.995  81.349  18.506  1.00  0.00           C  
ATOM   1315  CD2 TYR A  84      35.082  79.988  18.956  1.00  0.00           C  
ATOM   1316  CE1 TYR A  84      36.137  82.388  17.999  1.00  0.00           C  
ATOM   1317  CE2 TYR A  84      34.224  81.027  18.449  1.00  0.00           C  
ATOM   1318  CZ  TYR A  84      34.794  82.176  17.995  1.00  0.00           C  
ATOM   1319  OH  TYR A  84      33.983  83.156  17.515  1.00  0.00           O  
ATOM   1320  H   TYR A  84      38.974  77.052  19.867  1.00  0.00           H  
ATOM   1321  HA  TYR A  84      37.391  78.011  17.576  1.00  0.00           H  
ATOM   1322  HB2 TYR A  84      36.777  78.408  20.155  1.00  0.00           H  
ATOM   1323  HB3 TYR A  84      38.132  79.519  20.140  1.00  0.00           H  
ATOM   1324  HD1 TYR A  84      38.075  81.493  18.521  1.00  0.00           H  
ATOM   1325  HD2 TYR A  84      34.652  79.057  19.327  1.00  0.00           H  
ATOM   1326  HE1 TYR A  84      36.554  83.324  17.626  1.00  0.00           H  
ATOM   1327  HE2 TYR A  84      33.142  80.895  18.429  1.00  0.00           H  
ATOM   1328  HH  TYR A  84      33.902  83.077  16.521  1.00  0.00           H  
ATOM   1329  N   LEU A  85      39.041  79.989  17.118  1.00  0.00           N  
ATOM   1330  CA  LEU A  85      40.129  80.782  16.570  1.00  0.00           C  
ATOM   1331  C   LEU A  85      41.216  80.954  17.633  1.00  0.00           C  
ATOM   1332  O   LEU A  85      40.947  81.444  18.728  1.00  0.00           O  
ATOM   1333  CB  LEU A  85      39.600  82.105  16.013  1.00  0.00           C  
ATOM   1334  CG  LEU A  85      39.660  83.304  16.962  1.00  0.00           C  
ATOM   1335  CD1 LEU A  85      41.109  83.721  17.226  1.00  0.00           C  
ATOM   1336  CD2 LEU A  85      38.818  84.466  16.431  1.00  0.00           C  
ATOM   1337  H   LEU A  85      38.126  80.275  16.836  1.00  0.00           H  
ATOM   1338  HA  LEU A  85      40.549  80.225  15.732  1.00  0.00           H  
ATOM   1339  HB2 LEU A  85      40.164  82.349  15.113  1.00  0.00           H  
ATOM   1340  HB3 LEU A  85      38.564  81.960  15.710  1.00  0.00           H  
ATOM   1341  HG  LEU A  85      39.232  83.006  17.918  1.00  0.00           H  
ATOM   1342 HD11 LEU A  85      41.234  84.776  16.985  1.00  0.00           H  
ATOM   1343 HD12 LEU A  85      41.348  83.557  18.276  1.00  0.00           H  
ATOM   1344 HD13 LEU A  85      41.778  83.125  16.604  1.00  0.00           H  
ATOM   1345 HD21 LEU A  85      38.464  84.230  15.428  1.00  0.00           H  
ATOM   1346 HD22 LEU A  85      37.964  84.626  17.090  1.00  0.00           H  
ATOM   1347 HD23 LEU A  85      39.425  85.370  16.399  1.00  0.00           H  
ATOM   1348  N   SER A  86      42.422  80.539  17.272  1.00  0.00           N  
ATOM   1349  CA  SER A  86      43.551  80.640  18.182  1.00  0.00           C  
ATOM   1350  C   SER A  86      44.533  81.702  17.681  1.00  0.00           C  
ATOM   1351  O   SER A  86      45.498  81.382  16.988  1.00  0.00           O  
ATOM   1352  CB  SER A  86      44.258  79.292  18.333  1.00  0.00           C  
ATOM   1353  OG  SER A  86      44.551  78.994  19.695  1.00  0.00           O  
ATOM   1354  H   SER A  86      42.632  80.141  16.379  1.00  0.00           H  
ATOM   1355  HA  SER A  86      43.124  80.936  19.139  1.00  0.00           H  
ATOM   1356  HB2 SER A  86      43.631  78.504  17.915  1.00  0.00           H  
ATOM   1357  HB3 SER A  86      45.184  79.302  17.757  1.00  0.00           H  
ATOM   1358  HG  SER A  86      45.529  78.818  19.805  1.00  0.00           H  
ATOM   1359  N   GLU A  87      44.252  82.943  18.050  1.00  0.00           N  
ATOM   1360  CA  GLU A  87      45.098  84.053  17.647  1.00  0.00           C  
ATOM   1361  C   GLU A  87      44.858  85.261  18.555  1.00  0.00           C  
ATOM   1362  O   GLU A  87      43.729  85.738  18.673  1.00  0.00           O  
ATOM   1363  CB  GLU A  87      44.864  84.415  16.179  1.00  0.00           C  
ATOM   1364  CG  GLU A  87      45.827  85.516  15.726  1.00  0.00           C  
ATOM   1365  CD  GLU A  87      45.120  86.872  15.668  1.00  0.00           C  
ATOM   1366  OE1 GLU A  87      44.004  86.906  15.109  1.00  0.00           O  
ATOM   1367  OE2 GLU A  87      45.715  87.843  16.185  1.00  0.00           O  
ATOM   1368  H   GLU A  87      43.465  83.194  18.613  1.00  0.00           H  
ATOM   1369  HA  GLU A  87      46.121  83.696  17.768  1.00  0.00           H  
ATOM   1370  HB2 GLU A  87      44.999  83.531  15.556  1.00  0.00           H  
ATOM   1371  HB3 GLU A  87      43.836  84.749  16.042  1.00  0.00           H  
ATOM   1372  HG2 GLU A  87      46.672  85.570  16.413  1.00  0.00           H  
ATOM   1373  HG3 GLU A  87      46.231  85.269  14.744  1.00  0.00           H  
ATOM   1374  N   LEU A  88      45.935  85.720  19.174  1.00  0.00           N  
ATOM   1375  CA  LEU A  88      45.856  86.863  20.068  1.00  0.00           C  
ATOM   1376  C   LEU A  88      47.013  87.819  19.771  1.00  0.00           C  
ATOM   1377  O   LEU A  88      48.146  87.383  19.571  1.00  0.00           O  
ATOM   1378  CB  LEU A  88      45.797  86.401  21.524  1.00  0.00           C  
ATOM   1379  CG  LEU A  88      44.501  85.712  21.957  1.00  0.00           C  
ATOM   1380  CD1 LEU A  88      43.306  86.657  21.821  1.00  0.00           C  
ATOM   1381  CD2 LEU A  88      44.290  84.406  21.188  1.00  0.00           C  
ATOM   1382  H   LEU A  88      46.849  85.326  19.072  1.00  0.00           H  
ATOM   1383  HA  LEU A  88      44.920  87.379  19.855  1.00  0.00           H  
ATOM   1384  HB2 LEU A  88      46.626  85.715  21.701  1.00  0.00           H  
ATOM   1385  HB3 LEU A  88      45.957  87.267  22.167  1.00  0.00           H  
ATOM   1386  HG  LEU A  88      44.587  85.454  23.013  1.00  0.00           H  
ATOM   1387 HD11 LEU A  88      42.766  86.699  22.767  1.00  0.00           H  
ATOM   1388 HD12 LEU A  88      43.658  87.654  21.560  1.00  0.00           H  
ATOM   1389 HD13 LEU A  88      42.640  86.290  21.039  1.00  0.00           H  
ATOM   1390 HD21 LEU A  88      45.208  84.143  20.662  1.00  0.00           H  
ATOM   1391 HD22 LEU A  88      44.031  83.611  21.887  1.00  0.00           H  
ATOM   1392 HD23 LEU A  88      43.482  84.534  20.469  1.00  0.00           H  
ATOM   1393  N   ALA A  89      46.689  89.102  19.753  1.00  0.00           N  
ATOM   1394  CA  ALA A  89      47.689  90.123  19.486  1.00  0.00           C  
ATOM   1395  C   ALA A  89      47.076  91.505  19.721  1.00  0.00           C  
ATOM   1396  O   ALA A  89      45.923  91.614  20.137  1.00  0.00           O  
ATOM   1397  CB  ALA A  89      48.219  89.956  18.060  1.00  0.00           C  
ATOM   1398  H   ALA A  89      45.766  89.448  19.917  1.00  0.00           H  
ATOM   1399  HA  ALA A  89      48.510  89.975  20.186  1.00  0.00           H  
ATOM   1400  HB1 ALA A  89      48.674  88.971  17.955  1.00  0.00           H  
ATOM   1401  HB2 ALA A  89      47.396  90.053  17.352  1.00  0.00           H  
ATOM   1402  HB3 ALA A  89      48.965  90.724  17.858  1.00  0.00           H  
ATOM   1403  N   GLU A  90      47.874  92.526  19.446  1.00  0.00           N  
ATOM   1404  CA  GLU A  90      47.424  93.896  19.622  1.00  0.00           C  
ATOM   1405  C   GLU A  90      46.376  94.252  18.567  1.00  0.00           C  
ATOM   1406  O   GLU A  90      46.720  94.581  17.433  1.00  0.00           O  
ATOM   1407  CB  GLU A  90      48.603  94.870  19.574  1.00  0.00           C  
ATOM   1408  CG  GLU A  90      48.255  96.187  20.272  1.00  0.00           C  
ATOM   1409  CD  GLU A  90      49.462  97.127  20.302  1.00  0.00           C  
ATOM   1410  OE1 GLU A  90      50.476  96.730  20.915  1.00  0.00           O  
ATOM   1411  OE2 GLU A  90      49.344  98.222  19.710  1.00  0.00           O  
ATOM   1412  H   GLU A  90      48.810  92.428  19.108  1.00  0.00           H  
ATOM   1413  HA  GLU A  90      46.975  93.928  20.615  1.00  0.00           H  
ATOM   1414  HB2 GLU A  90      49.472  94.419  20.054  1.00  0.00           H  
ATOM   1415  HB3 GLU A  90      48.877  95.065  18.538  1.00  0.00           H  
ATOM   1416  HG2 GLU A  90      47.427  96.669  19.752  1.00  0.00           H  
ATOM   1417  HG3 GLU A  90      47.920  95.987  21.289  1.00  0.00           H  
ATOM   1418  N   GLN A  91      45.118  94.172  18.977  1.00  0.00           N  
ATOM   1419  CA  GLN A  91      44.018  94.481  18.080  1.00  0.00           C  
ATOM   1420  C   GLN A  91      44.093  95.942  17.631  1.00  0.00           C  
ATOM   1421  O   GLN A  91      44.596  96.794  18.361  1.00  0.00           O  
ATOM   1422  CB  GLN A  91      42.671  94.179  18.740  1.00  0.00           C  
ATOM   1423  CG  GLN A  91      42.356  95.201  19.833  1.00  0.00           C  
ATOM   1424  CD  GLN A  91      42.250  94.525  21.202  1.00  0.00           C  
ATOM   1425  OE1 GLN A  91      42.564  93.358  21.372  1.00  0.00           O  
ATOM   1426  NE2 GLN A  91      41.790  95.320  22.165  1.00  0.00           N  
ATOM   1427  H   GLN A  91      44.848  93.903  19.901  1.00  0.00           H  
ATOM   1428  HA  GLN A  91      44.151  93.824  17.221  1.00  0.00           H  
ATOM   1429  HB2 GLN A  91      41.882  94.190  17.988  1.00  0.00           H  
ATOM   1430  HB3 GLN A  91      42.689  93.176  19.168  1.00  0.00           H  
ATOM   1431  HG2 GLN A  91      43.133  95.964  19.860  1.00  0.00           H  
ATOM   1432  HG3 GLN A  91      41.419  95.709  19.601  1.00  0.00           H  
ATOM   1433 HE21 GLN A  91      41.550  96.268  21.957  1.00  0.00           H  
ATOM   1434 HE22 GLN A  91      41.686  94.969  23.095  1.00  0.00           H  
ATOM   1435  N   PRO A  92      43.572  96.193  16.401  1.00  0.00           N  
ATOM   1436  CA  PRO A  92      43.575  97.536  15.846  1.00  0.00           C  
ATOM   1437  C   PRO A  92      42.508  98.407  16.513  1.00  0.00           C  
ATOM   1438  O   PRO A  92      41.314  98.192  16.317  1.00  0.00           O  
ATOM   1439  CB  PRO A  92      43.340  97.347  14.356  1.00  0.00           C  
ATOM   1440  CG  PRO A  92      42.754  95.953  14.200  1.00  0.00           C  
ATOM   1441  CD  PRO A  92      42.968  95.208  15.507  1.00  0.00           C  
ATOM   1442  HA  PRO A  92      44.449  97.986  16.029  1.00  0.00           H  
ATOM   1443  HB2 PRO A  92      42.657  98.104  13.970  1.00  0.00           H  
ATOM   1444  HB3 PRO A  92      44.272  97.444  13.799  1.00  0.00           H  
ATOM   1445  HG2 PRO A  92      41.691  96.011  13.962  1.00  0.00           H  
ATOM   1446  HG3 PRO A  92      43.236  95.426  13.377  1.00  0.00           H  
ATOM   1447  HD2 PRO A  92      42.026  94.835  15.909  1.00  0.00           H  
ATOM   1448  HD3 PRO A  92      43.620  94.346  15.370  1.00  0.00           H  
ATOM   1449  N   GLU A  93      42.980  99.373  17.289  1.00  0.00           N  
ATOM   1450  CA  GLU A  93      42.081 100.277  17.987  1.00  0.00           C  
ATOM   1451  C   GLU A  93      42.838 101.523  18.450  1.00  0.00           C  
ATOM   1452  O   GLU A  93      43.653 101.454  19.369  1.00  0.00           O  
ATOM   1453  CB  GLU A  93      41.405  99.576  19.166  1.00  0.00           C  
ATOM   1454  CG  GLU A  93      40.217 100.392  19.681  1.00  0.00           C  
ATOM   1455  CD  GLU A  93      40.608 101.212  20.912  1.00  0.00           C  
ATOM   1456  OE1 GLU A  93      40.595 100.622  22.014  1.00  0.00           O  
ATOM   1457  OE2 GLU A  93      40.911 102.410  20.725  1.00  0.00           O  
ATOM   1458  H   GLU A  93      43.953  99.541  17.443  1.00  0.00           H  
ATOM   1459  HA  GLU A  93      41.324 100.555  17.254  1.00  0.00           H  
ATOM   1460  HB2 GLU A  93      41.064  98.587  18.860  1.00  0.00           H  
ATOM   1461  HB3 GLU A  93      42.125  99.430  19.969  1.00  0.00           H  
ATOM   1462  HG2 GLU A  93      39.862 101.059  18.895  1.00  0.00           H  
ATOM   1463  HG3 GLU A  93      39.393  99.724  19.930  1.00  0.00           H  
ATOM   1464  N   ARG A  94      42.542 102.635  17.793  1.00  0.00           N  
ATOM   1465  CA  ARG A  94      43.185 103.896  18.127  1.00  0.00           C  
ATOM   1466  C   ARG A  94      42.280 105.070  17.746  1.00  0.00           C  
ATOM   1467  O   ARG A  94      41.419 104.938  16.877  1.00  0.00           O  
ATOM   1468  CB  ARG A  94      44.525 104.039  17.404  1.00  0.00           C  
ATOM   1469  CG  ARG A  94      44.331 104.061  15.887  1.00  0.00           C  
ATOM   1470  CD  ARG A  94      45.627 104.449  15.173  1.00  0.00           C  
ATOM   1471  NE  ARG A  94      45.846 103.566  14.006  1.00  0.00           N  
ATOM   1472  CZ  ARG A  94      46.961 103.569  13.262  1.00  0.00           C  
ATOM   1473  NH1 ARG A  94      47.962 104.409  13.557  1.00  0.00           N  
ATOM   1474  NH2 ARG A  94      47.073 102.732  12.220  1.00  0.00           N  
ATOM   1475  H   ARG A  94      41.878 102.684  17.047  1.00  0.00           H  
ATOM   1476  HA  ARG A  94      43.339 103.853  19.205  1.00  0.00           H  
ATOM   1477  HB2 ARG A  94      45.020 104.956  17.724  1.00  0.00           H  
ATOM   1478  HB3 ARG A  94      45.181 103.212  17.678  1.00  0.00           H  
ATOM   1479  HG2 ARG A  94      44.003 103.079  15.543  1.00  0.00           H  
ATOM   1480  HG3 ARG A  94      43.542 104.768  15.628  1.00  0.00           H  
ATOM   1481  HD2 ARG A  94      45.576 105.489  14.849  1.00  0.00           H  
ATOM   1482  HD3 ARG A  94      46.468 104.372  15.862  1.00  0.00           H  
ATOM   1483  HE  ARG A  94      45.118 102.927  13.758  1.00  0.00           H  
ATOM   1484 HH11 ARG A  94      47.879 105.033  14.334  1.00  0.00           H  
ATOM   1485 HH12 ARG A  94      48.794 104.411  13.001  1.00  0.00           H  
ATOM   1486 HH21 ARG A  94      46.326 102.106  11.999  1.00  0.00           H  
ATOM   1487 HH22 ARG A  94      47.904 102.734  11.665  1.00  0.00           H  
ATOM   1488  N   LYS A  95      42.506 106.190  18.415  1.00  0.00           N  
ATOM   1489  CA  LYS A  95      41.722 107.386  18.158  1.00  0.00           C  
ATOM   1490  C   LYS A  95      42.318 108.559  18.940  1.00  0.00           C  
ATOM   1491  O   LYS A  95      41.773 108.967  19.964  1.00  0.00           O  
ATOM   1492  CB  LYS A  95      40.244 107.133  18.460  1.00  0.00           C  
ATOM   1493  CG  LYS A  95      39.347 107.979  17.554  1.00  0.00           C  
ATOM   1494  CD  LYS A  95      38.940 107.198  16.303  1.00  0.00           C  
ATOM   1495  CE  LYS A  95      39.530 107.836  15.043  1.00  0.00           C  
ATOM   1496  NZ  LYS A  95      38.611 107.664  13.896  1.00  0.00           N  
ATOM   1497  H   LYS A  95      43.208 106.289  19.121  1.00  0.00           H  
ATOM   1498  HA  LYS A  95      41.801 107.606  17.094  1.00  0.00           H  
ATOM   1499  HB2 LYS A  95      40.016 106.077  18.320  1.00  0.00           H  
ATOM   1500  HB3 LYS A  95      40.037 107.368  19.505  1.00  0.00           H  
ATOM   1501  HG2 LYS A  95      38.456 108.285  18.103  1.00  0.00           H  
ATOM   1502  HG3 LYS A  95      39.871 108.890  17.265  1.00  0.00           H  
ATOM   1503  HD2 LYS A  95      39.280 106.166  16.387  1.00  0.00           H  
ATOM   1504  HD3 LYS A  95      37.853 107.170  16.225  1.00  0.00           H  
ATOM   1505  HE2 LYS A  95      39.712 108.896  15.215  1.00  0.00           H  
ATOM   1506  HE3 LYS A  95      40.493 107.380  14.816  1.00  0.00           H  
ATOM   1507  HZ1 LYS A  95      38.142 108.529  13.712  1.00  0.00           H  
ATOM   1508  HZ2 LYS A  95      39.132 107.390  13.089  1.00  0.00           H  
ATOM   1509  HZ3 LYS A  95      37.936 106.959  14.112  1.00  0.00           H  
ATOM   1510  N   ILE A  96      43.428 109.068  18.427  1.00  0.00           N  
ATOM   1511  CA  ILE A  96      44.104 110.185  19.064  1.00  0.00           C  
ATOM   1512  C   ILE A  96      43.190 111.412  19.035  1.00  0.00           C  
ATOM   1513  O   ILE A  96      42.157 111.405  18.367  1.00  0.00           O  
ATOM   1514  CB  ILE A  96      45.472 110.422  18.421  1.00  0.00           C  
ATOM   1515  CG1 ILE A  96      46.316 111.379  19.266  1.00  0.00           C  
ATOM   1516  CG2 ILE A  96      45.323 110.909  16.979  1.00  0.00           C  
ATOM   1517  CD1 ILE A  96      47.798 111.264  18.907  1.00  0.00           C  
ATOM   1518  H   ILE A  96      43.866 108.730  17.594  1.00  0.00           H  
ATOM   1519  HA  ILE A  96      44.280 109.911  20.105  1.00  0.00           H  
ATOM   1520  HB  ILE A  96      46.002 109.470  18.387  1.00  0.00           H  
ATOM   1521 HG12 ILE A  96      45.978 112.403  19.106  1.00  0.00           H  
ATOM   1522 HG13 ILE A  96      46.175 111.158  20.323  1.00  0.00           H  
ATOM   1523 HG21 ILE A  96      44.266 111.047  16.749  1.00  0.00           H  
ATOM   1524 HG22 ILE A  96      45.847 111.857  16.858  1.00  0.00           H  
ATOM   1525 HG23 ILE A  96      45.748 110.169  16.300  1.00  0.00           H  
ATOM   1526 HD11 ILE A  96      48.383 111.906  19.566  1.00  0.00           H  
ATOM   1527 HD12 ILE A  96      48.121 110.230  19.028  1.00  0.00           H  
ATOM   1528 HD13 ILE A  96      47.948 111.573  17.873  1.00  0.00           H  
ATOM   1529  N   THR A  97      43.603 112.436  19.768  1.00  0.00           N  
ATOM   1530  CA  THR A  97      42.833 113.667  19.833  1.00  0.00           C  
ATOM   1531  C   THR A  97      43.664 114.780  20.477  1.00  0.00           C  
ATOM   1532  O   THR A  97      44.627 114.507  21.191  1.00  0.00           O  
ATOM   1533  CB  THR A  97      41.531 113.371  20.580  1.00  0.00           C  
ATOM   1534  OG1 THR A  97      40.846 114.622  20.590  1.00  0.00           O  
ATOM   1535  CG2 THR A  97      41.762 113.061  22.061  1.00  0.00           C  
ATOM   1536  H   THR A  97      44.443 112.433  20.308  1.00  0.00           H  
ATOM   1537  HA  THR A  97      42.606 113.985  18.816  1.00  0.00           H  
ATOM   1538  HB  THR A  97      40.978 112.568  20.094  1.00  0.00           H  
ATOM   1539  HG1 THR A  97      40.034 114.561  21.170  1.00  0.00           H  
ATOM   1540 HG21 THR A  97      41.034 113.603  22.663  1.00  0.00           H  
ATOM   1541 HG22 THR A  97      41.649 111.989  22.228  1.00  0.00           H  
ATOM   1542 HG23 THR A  97      42.769 113.368  22.343  1.00  0.00           H  
ATOM   1543  N   ARG A  98      43.260 116.011  20.199  1.00  0.00           N  
ATOM   1544  CA  ARG A  98      43.954 117.167  20.742  1.00  0.00           C  
ATOM   1545  C   ARG A  98      43.307 118.458  20.238  1.00  0.00           C  
ATOM   1546  O   ARG A  98      42.607 118.453  19.227  1.00  0.00           O  
ATOM   1547  CB  ARG A  98      45.433 117.156  20.347  1.00  0.00           C  
ATOM   1548  CG  ARG A  98      46.317 116.801  21.543  1.00  0.00           C  
ATOM   1549  CD  ARG A  98      47.233 117.969  21.913  1.00  0.00           C  
ATOM   1550  NE  ARG A  98      47.684 117.835  23.316  1.00  0.00           N  
ATOM   1551  CZ  ARG A  98      46.912 118.094  24.381  1.00  0.00           C  
ATOM   1552  NH1 ARG A  98      45.647 118.502  24.208  1.00  0.00           N  
ATOM   1553  NH2 ARG A  98      47.405 117.945  25.618  1.00  0.00           N  
ATOM   1554  H   ARG A  98      42.476 116.225  19.617  1.00  0.00           H  
ATOM   1555  HA  ARG A  98      43.851 117.072  21.823  1.00  0.00           H  
ATOM   1556  HB2 ARG A  98      45.593 116.436  19.545  1.00  0.00           H  
ATOM   1557  HB3 ARG A  98      45.715 118.134  19.958  1.00  0.00           H  
ATOM   1558  HG2 ARG A  98      45.692 116.541  22.398  1.00  0.00           H  
ATOM   1559  HG3 ARG A  98      46.918 115.923  21.307  1.00  0.00           H  
ATOM   1560  HD2 ARG A  98      48.096 117.991  21.246  1.00  0.00           H  
ATOM   1561  HD3 ARG A  98      46.705 118.913  21.780  1.00  0.00           H  
ATOM   1562  HE  ARG A  98      48.623 117.533  23.480  1.00  0.00           H  
ATOM   1563 HH11 ARG A  98      45.280 118.615  23.285  1.00  0.00           H  
ATOM   1564 HH12 ARG A  98      45.072 118.696  25.003  1.00  0.00           H  
ATOM   1565 HH21 ARG A  98      48.349 117.640  25.747  1.00  0.00           H  
ATOM   1566 HH22 ARG A  98      46.829 118.138  26.412  1.00  0.00           H  
ATOM   1567  N   ASN A  99      43.566 119.535  20.967  1.00  0.00           N  
ATOM   1568  CA  ASN A  99      43.018 120.831  20.607  1.00  0.00           C  
ATOM   1569  C   ASN A  99      43.368 121.848  21.695  1.00  0.00           C  
ATOM   1570  O   ASN A  99      43.519 121.488  22.861  1.00  0.00           O  
ATOM   1571  CB  ASN A  99      41.494 120.771  20.488  1.00  0.00           C  
ATOM   1572  CG  ASN A  99      40.870 120.169  21.749  1.00  0.00           C  
ATOM   1573  OD1 ASN A  99      40.856 120.767  22.813  1.00  0.00           O  
ATOM   1574  ND2 ASN A  99      40.355 118.956  21.571  1.00  0.00           N  
ATOM   1575  H   ASN A  99      44.136 119.530  21.788  1.00  0.00           H  
ATOM   1576  HA  ASN A  99      43.470 121.076  19.646  1.00  0.00           H  
ATOM   1577  HB2 ASN A  99      41.099 121.775  20.326  1.00  0.00           H  
ATOM   1578  HB3 ASN A  99      41.216 120.175  19.620  1.00  0.00           H  
ATOM   1579 HD21 ASN A  99      40.401 118.521  20.671  1.00  0.00           H  
ATOM   1580 HD22 ASN A  99      39.924 118.478  22.337  1.00  0.00           H  
ATOM   1581  N   GLN A 100      43.489 123.100  21.275  1.00  0.00           N  
ATOM   1582  CA  GLN A 100      43.818 124.170  22.199  1.00  0.00           C  
ATOM   1583  C   GLN A 100      43.758 125.523  21.487  1.00  0.00           C  
ATOM   1584  O   GLN A 100      43.785 125.584  20.258  1.00  0.00           O  
ATOM   1585  CB  GLN A 100      45.193 123.944  22.832  1.00  0.00           C  
ATOM   1586  CG  GLN A 100      45.164 124.251  24.331  1.00  0.00           C  
ATOM   1587  CD  GLN A 100      44.739 123.021  25.134  1.00  0.00           C  
ATOM   1588  OE1 GLN A 100      45.529 122.143  25.439  1.00  0.00           O  
ATOM   1589  NE2 GLN A 100      43.449 123.006  25.458  1.00  0.00           N  
ATOM   1590  H   GLN A 100      43.365 123.384  20.325  1.00  0.00           H  
ATOM   1591  HA  GLN A 100      43.056 124.127  22.977  1.00  0.00           H  
ATOM   1592  HB2 GLN A 100      45.504 122.913  22.675  1.00  0.00           H  
ATOM   1593  HB3 GLN A 100      45.932 124.579  22.342  1.00  0.00           H  
ATOM   1594  HG2 GLN A 100      46.150 124.581  24.657  1.00  0.00           H  
ATOM   1595  HG3 GLN A 100      44.474 125.073  24.524  1.00  0.00           H  
ATOM   1596 HE21 GLN A 100      42.853 123.758  25.176  1.00  0.00           H  
ATOM   1597 HE22 GLN A 100      43.074 122.242  25.984  1.00  0.00           H  
ATOM   1598  N   LYS A 101      43.679 126.575  22.288  1.00  0.00           N  
ATOM   1599  CA  LYS A 101      43.615 127.923  21.750  1.00  0.00           C  
ATOM   1600  C   LYS A 101      43.681 128.931  22.900  1.00  0.00           C  
ATOM   1601  O   LYS A 101      43.617 128.550  24.067  1.00  0.00           O  
ATOM   1602  CB  LYS A 101      42.381 128.087  20.858  1.00  0.00           C  
ATOM   1603  CG  LYS A 101      41.095 128.004  21.683  1.00  0.00           C  
ATOM   1604  CD  LYS A 101      40.628 129.395  22.114  1.00  0.00           C  
ATOM   1605  CE  LYS A 101      39.355 129.802  21.369  1.00  0.00           C  
ATOM   1606  NZ  LYS A 101      38.387 130.426  22.300  1.00  0.00           N  
ATOM   1607  H   LYS A 101      43.658 126.517  23.286  1.00  0.00           H  
ATOM   1608  HA  LYS A 101      44.490 128.064  21.116  1.00  0.00           H  
ATOM   1609  HB2 LYS A 101      42.425 129.045  20.342  1.00  0.00           H  
ATOM   1610  HB3 LYS A 101      42.377 127.312  20.092  1.00  0.00           H  
ATOM   1611  HG2 LYS A 101      40.314 127.519  21.096  1.00  0.00           H  
ATOM   1612  HG3 LYS A 101      41.262 127.383  22.563  1.00  0.00           H  
ATOM   1613  HD2 LYS A 101      40.446 129.406  23.188  1.00  0.00           H  
ATOM   1614  HD3 LYS A 101      41.416 130.123  21.918  1.00  0.00           H  
ATOM   1615  HE2 LYS A 101      39.601 130.499  20.569  1.00  0.00           H  
ATOM   1616  HE3 LYS A 101      38.905 128.926  20.902  1.00  0.00           H  
ATOM   1617  HZ1 LYS A 101      37.520 129.931  22.259  1.00  0.00           H  
ATOM   1618  HZ2 LYS A 101      38.750 130.389  23.231  1.00  0.00           H  
ATOM   1619  HZ3 LYS A 101      38.240 131.380  22.037  1.00  0.00           H  
ATOM   1620  N   ARG A 102      43.808 130.196  22.528  1.00  0.00           N  
ATOM   1621  CA  ARG A 102      43.882 131.261  23.515  1.00  0.00           C  
ATOM   1622  C   ARG A 102      43.974 132.622  22.819  1.00  0.00           C  
ATOM   1623  O   ARG A 102      44.573 132.738  21.752  1.00  0.00           O  
ATOM   1624  CB  ARG A 102      45.095 131.080  24.429  1.00  0.00           C  
ATOM   1625  CG  ARG A 102      44.735 131.388  25.884  1.00  0.00           C  
ATOM   1626  CD  ARG A 102      45.722 130.724  26.846  1.00  0.00           C  
ATOM   1627  NE  ARG A 102      45.773 131.477  28.119  1.00  0.00           N  
ATOM   1628  CZ  ARG A 102      46.667 131.249  29.091  1.00  0.00           C  
ATOM   1629  NH1 ARG A 102      47.587 130.288  28.943  1.00  0.00           N  
ATOM   1630  NH2 ARG A 102      46.637 131.981  30.213  1.00  0.00           N  
ATOM   1631  H   ARG A 102      43.858 130.497  21.576  1.00  0.00           H  
ATOM   1632  HA  ARG A 102      42.959 131.175  24.088  1.00  0.00           H  
ATOM   1633  HB2 ARG A 102      45.464 130.057  24.351  1.00  0.00           H  
ATOM   1634  HB3 ARG A 102      45.902 131.737  24.103  1.00  0.00           H  
ATOM   1635  HG2 ARG A 102      44.738 132.467  26.042  1.00  0.00           H  
ATOM   1636  HG3 ARG A 102      43.725 131.037  26.095  1.00  0.00           H  
ATOM   1637  HD2 ARG A 102      45.422 129.693  27.035  1.00  0.00           H  
ATOM   1638  HD3 ARG A 102      46.714 130.689  26.395  1.00  0.00           H  
ATOM   1639  HE  ARG A 102      45.099 132.201  28.262  1.00  0.00           H  
ATOM   1640 HH11 ARG A 102      47.609 129.741  28.106  1.00  0.00           H  
ATOM   1641 HH12 ARG A 102      48.254 130.118  29.669  1.00  0.00           H  
ATOM   1642 HH21 ARG A 102      45.949 132.698  30.325  1.00  0.00           H  
ATOM   1643 HH22 ARG A 102      47.302 131.811  30.939  1.00  0.00           H  
ATOM   1644  N   LYS A 103      43.372 133.616  23.455  1.00  0.00           N  
ATOM   1645  CA  LYS A 103      43.378 134.964  22.912  1.00  0.00           C  
ATOM   1646  C   LYS A 103      43.198 135.969  24.051  1.00  0.00           C  
ATOM   1647  O   LYS A 103      42.443 135.720  24.989  1.00  0.00           O  
ATOM   1648  CB  LYS A 103      42.335 135.099  21.801  1.00  0.00           C  
ATOM   1649  CG  LYS A 103      43.002 135.159  20.426  1.00  0.00           C  
ATOM   1650  CD  LYS A 103      43.095 136.600  19.923  1.00  0.00           C  
ATOM   1651  CE  LYS A 103      44.476 136.885  19.328  1.00  0.00           C  
ATOM   1652  NZ  LYS A 103      45.380 137.440  20.358  1.00  0.00           N  
ATOM   1653  H   LYS A 103      42.886 133.513  24.323  1.00  0.00           H  
ATOM   1654  HA  LYS A 103      44.355 135.128  22.457  1.00  0.00           H  
ATOM   1655  HB2 LYS A 103      41.646 134.255  21.840  1.00  0.00           H  
ATOM   1656  HB3 LYS A 103      41.742 136.000  21.961  1.00  0.00           H  
ATOM   1657  HG2 LYS A 103      44.000 134.724  20.483  1.00  0.00           H  
ATOM   1658  HG3 LYS A 103      42.433 134.558  19.715  1.00  0.00           H  
ATOM   1659  HD2 LYS A 103      42.327 136.778  19.171  1.00  0.00           H  
ATOM   1660  HD3 LYS A 103      42.901 137.290  20.746  1.00  0.00           H  
ATOM   1661  HE2 LYS A 103      44.898 135.967  18.920  1.00  0.00           H  
ATOM   1662  HE3 LYS A 103      44.382 137.588  18.500  1.00  0.00           H  
ATOM   1663  HZ1 LYS A 103      46.320 137.156  20.166  1.00  0.00           H  
ATOM   1664  HZ2 LYS A 103      45.325 138.438  20.348  1.00  0.00           H  
ATOM   1665  HZ3 LYS A 103      45.107 137.101  21.259  1.00  0.00           H  
ATOM   1666  N   HIS A 104      43.904 137.084  23.931  1.00  0.00           N  
ATOM   1667  CA  HIS A 104      43.831 138.128  24.938  1.00  0.00           C  
ATOM   1668  C   HIS A 104      44.121 139.485  24.293  1.00  0.00           C  
ATOM   1669  O   HIS A 104      44.639 139.550  23.180  1.00  0.00           O  
ATOM   1670  CB  HIS A 104      44.765 137.818  26.111  1.00  0.00           C  
ATOM   1671  CG  HIS A 104      46.202 137.591  25.708  1.00  0.00           C  
ATOM   1672  ND1 HIS A 104      47.004 136.629  26.298  1.00  0.00           N  
ATOM   1673  CD2 HIS A 104      46.972 138.211  24.768  1.00  0.00           C  
ATOM   1674  CE1 HIS A 104      48.201 136.679  25.732  1.00  0.00           C  
ATOM   1675  NE2 HIS A 104      48.179 137.659  24.785  1.00  0.00           N  
ATOM   1676  H   HIS A 104      44.516 137.279  23.164  1.00  0.00           H  
ATOM   1677  HA  HIS A 104      42.810 138.126  25.318  1.00  0.00           H  
ATOM   1678  HB2 HIS A 104      44.723 138.641  26.823  1.00  0.00           H  
ATOM   1679  HB3 HIS A 104      44.399 136.930  26.627  1.00  0.00           H  
ATOM   1680  HD1 HIS A 104      46.727 136.004  27.027  1.00  0.00           H  
ATOM   1681  HD2 HIS A 104      46.651 139.022  24.115  1.00  0.00           H  
ATOM   1682  HE1 HIS A 104      49.053 136.045  25.980  1.00  0.00           H  
ATOM   1683  N   ASP A 105      43.773 140.536  25.022  1.00  0.00           N  
ATOM   1684  CA  ASP A 105      43.989 141.888  24.534  1.00  0.00           C  
ATOM   1685  C   ASP A 105      43.587 142.887  25.622  1.00  0.00           C  
ATOM   1686  O   ASP A 105      42.956 142.515  26.610  1.00  0.00           O  
ATOM   1687  CB  ASP A 105      43.137 142.169  23.296  1.00  0.00           C  
ATOM   1688  CG  ASP A 105      41.626 142.135  23.528  1.00  0.00           C  
ATOM   1689  OD1 ASP A 105      41.105 143.157  24.025  1.00  0.00           O  
ATOM   1690  OD2 ASP A 105      41.025 141.087  23.204  1.00  0.00           O  
ATOM   1691  H   ASP A 105      43.352 140.474  25.926  1.00  0.00           H  
ATOM   1692  HA  ASP A 105      45.051 141.939  24.293  1.00  0.00           H  
ATOM   1693  HB2 ASP A 105      43.407 143.150  22.903  1.00  0.00           H  
ATOM   1694  HB3 ASP A 105      43.388 141.438  22.527  1.00  0.00           H  
ATOM   1695  N   GLU A 106      43.970 144.136  25.402  1.00  0.00           N  
ATOM   1696  CA  GLU A 106      43.657 145.192  26.351  1.00  0.00           C  
ATOM   1697  C   GLU A 106      43.657 146.552  25.651  1.00  0.00           C  
ATOM   1698  O   GLU A 106      44.527 146.830  24.827  1.00  0.00           O  
ATOM   1699  CB  GLU A 106      44.636 145.181  27.527  1.00  0.00           C  
ATOM   1700  CG  GLU A 106      44.083 145.977  28.710  1.00  0.00           C  
ATOM   1701  CD  GLU A 106      45.215 146.561  29.556  1.00  0.00           C  
ATOM   1702  OE1 GLU A 106      46.155 147.112  28.945  1.00  0.00           O  
ATOM   1703  OE2 GLU A 106      45.115 146.441  30.797  1.00  0.00           O  
ATOM   1704  H   GLU A 106      44.483 144.431  24.596  1.00  0.00           H  
ATOM   1705  HA  GLU A 106      42.656 144.965  26.717  1.00  0.00           H  
ATOM   1706  HB2 GLU A 106      44.829 144.152  27.834  1.00  0.00           H  
ATOM   1707  HB3 GLU A 106      45.591 145.604  27.214  1.00  0.00           H  
ATOM   1708  HG2 GLU A 106      43.445 146.782  28.344  1.00  0.00           H  
ATOM   1709  HG3 GLU A 106      43.457 145.331  29.327  1.00  0.00           H  
ATOM   1710  N   ILE A 107      42.672 147.364  26.004  1.00  0.00           N  
ATOM   1711  CA  ILE A 107      42.548 148.688  25.420  1.00  0.00           C  
ATOM   1712  C   ILE A 107      43.536 149.637  26.101  1.00  0.00           C  
ATOM   1713  O   ILE A 107      44.236 149.244  27.033  1.00  0.00           O  
ATOM   1714  CB  ILE A 107      41.095 149.166  25.479  1.00  0.00           C  
ATOM   1715  CG1 ILE A 107      40.614 149.278  26.926  1.00  0.00           C  
ATOM   1716  CG2 ILE A 107      40.186 148.265  24.641  1.00  0.00           C  
ATOM   1717  CD1 ILE A 107      40.567 150.740  27.377  1.00  0.00           C  
ATOM   1718  H   ILE A 107      41.968 147.130  26.675  1.00  0.00           H  
ATOM   1719  HA  ILE A 107      42.818 148.607  24.366  1.00  0.00           H  
ATOM   1720  HB  ILE A 107      41.046 150.165  25.045  1.00  0.00           H  
ATOM   1721 HG12 ILE A 107      39.623 148.833  27.020  1.00  0.00           H  
ATOM   1722 HG13 ILE A 107      41.280 148.714  27.579  1.00  0.00           H  
ATOM   1723 HG21 ILE A 107      39.232 148.765  24.475  1.00  0.00           H  
ATOM   1724 HG22 ILE A 107      40.662 148.062  23.681  1.00  0.00           H  
ATOM   1725 HG23 ILE A 107      40.019 147.326  25.168  1.00  0.00           H  
ATOM   1726 HD11 ILE A 107      41.524 151.014  27.819  1.00  0.00           H  
ATOM   1727 HD12 ILE A 107      40.365 151.379  26.518  1.00  0.00           H  
ATOM   1728 HD13 ILE A 107      39.775 150.866  28.117  1.00  0.00           H  
ATOM   1729  N   ASN A 108      43.560 150.867  25.611  1.00  0.00           N  
ATOM   1730  CA  ASN A 108      44.451 151.876  26.161  1.00  0.00           C  
ATOM   1731  C   ASN A 108      44.133 153.231  25.527  1.00  0.00           C  
ATOM   1732  O   ASN A 108      43.582 153.294  24.429  1.00  0.00           O  
ATOM   1733  CB  ASN A 108      45.913 151.542  25.859  1.00  0.00           C  
ATOM   1734  CG  ASN A 108      46.536 150.728  26.995  1.00  0.00           C  
ATOM   1735  OD1 ASN A 108      46.010 150.643  28.093  1.00  0.00           O  
ATOM   1736  ND2 ASN A 108      47.682 150.137  26.670  1.00  0.00           N  
ATOM   1737  H   ASN A 108      42.986 151.179  24.853  1.00  0.00           H  
ATOM   1738  HA  ASN A 108      44.266 151.864  27.235  1.00  0.00           H  
ATOM   1739  HB2 ASN A 108      45.977 150.981  24.927  1.00  0.00           H  
ATOM   1740  HB3 ASN A 108      46.477 152.464  25.715  1.00  0.00           H  
ATOM   1741 HD21 ASN A 108      48.059 150.247  25.751  1.00  0.00           H  
ATOM   1742 HD22 ASN A 108      48.166 149.581  27.347  1.00  0.00           H  
ATOM   1743  N   HIS A 109      44.495 154.284  26.246  1.00  0.00           N  
ATOM   1744  CA  HIS A 109      44.257 155.635  25.767  1.00  0.00           C  
ATOM   1745  C   HIS A 109      44.912 156.639  26.717  1.00  0.00           C  
ATOM   1746  O   HIS A 109      45.276 156.291  27.839  1.00  0.00           O  
ATOM   1747  CB  HIS A 109      42.759 155.887  25.579  1.00  0.00           C  
ATOM   1748  CG  HIS A 109      42.439 156.934  24.538  1.00  0.00           C  
ATOM   1749  ND1 HIS A 109      42.025 156.615  23.257  1.00  0.00           N  
ATOM   1750  CD2 HIS A 109      42.477 158.297  24.603  1.00  0.00           C  
ATOM   1751  CE1 HIS A 109      41.825 157.743  22.589  1.00  0.00           C  
ATOM   1752  NE2 HIS A 109      42.106 158.783  23.425  1.00  0.00           N  
ATOM   1753  H   HIS A 109      44.943 154.225  27.139  1.00  0.00           H  
ATOM   1754  HA  HIS A 109      44.731 155.708  24.789  1.00  0.00           H  
ATOM   1755  HB2 HIS A 109      42.275 154.951  25.298  1.00  0.00           H  
ATOM   1756  HB3 HIS A 109      42.330 156.195  26.532  1.00  0.00           H  
ATOM   1757  HD1 HIS A 109      41.898 155.692  22.896  1.00  0.00           H  
ATOM   1758  HD2 HIS A 109      42.762 158.884  25.475  1.00  0.00           H  
ATOM   1759  HE1 HIS A 109      41.495 157.824  21.554  1.00  0.00           H  
ATOM   1760  N   VAL A 110      45.042 157.865  26.233  1.00  0.00           N  
ATOM   1761  CA  VAL A 110      45.647 158.923  27.024  1.00  0.00           C  
ATOM   1762  C   VAL A 110      44.937 160.246  26.728  1.00  0.00           C  
ATOM   1763  O   VAL A 110      44.489 160.477  25.606  1.00  0.00           O  
ATOM   1764  CB  VAL A 110      47.152 158.980  26.757  1.00  0.00           C  
ATOM   1765  CG1 VAL A 110      47.508 160.179  25.877  1.00  0.00           C  
ATOM   1766  CG2 VAL A 110      47.941 159.009  28.068  1.00  0.00           C  
ATOM   1767  H   VAL A 110      44.743 158.140  25.319  1.00  0.00           H  
ATOM   1768  HA  VAL A 110      45.499 158.672  28.075  1.00  0.00           H  
ATOM   1769  HB  VAL A 110      47.432 158.074  26.218  1.00  0.00           H  
ATOM   1770 HG11 VAL A 110      47.581 161.074  26.494  1.00  0.00           H  
ATOM   1771 HG12 VAL A 110      48.464 159.999  25.386  1.00  0.00           H  
ATOM   1772 HG13 VAL A 110      46.733 160.319  25.123  1.00  0.00           H  
ATOM   1773 HG21 VAL A 110      48.944 159.391  27.880  1.00  0.00           H  
ATOM   1774 HG22 VAL A 110      47.433 159.657  28.783  1.00  0.00           H  
ATOM   1775 HG23 VAL A 110      48.006 158.000  28.476  1.00  0.00           H  
ATOM   1776  N   GLN A 111      44.855 161.079  27.756  1.00  0.00           N  
ATOM   1777  CA  GLN A 111      44.207 162.372  27.620  1.00  0.00           C  
ATOM   1778  C   GLN A 111      44.849 163.389  28.566  1.00  0.00           C  
ATOM   1779  O   GLN A 111      45.440 163.014  29.577  1.00  0.00           O  
ATOM   1780  CB  GLN A 111      42.703 162.261  27.874  1.00  0.00           C  
ATOM   1781  CG  GLN A 111      42.008 161.509  26.736  1.00  0.00           C  
ATOM   1782  CD  GLN A 111      42.431 162.064  25.374  1.00  0.00           C  
ATOM   1783  OE1 GLN A 111      42.612 161.339  24.409  1.00  0.00           O  
ATOM   1784  NE2 GLN A 111      42.579 163.385  25.351  1.00  0.00           N  
ATOM   1785  H   GLN A 111      45.222 160.883  28.665  1.00  0.00           H  
ATOM   1786  HA  GLN A 111      44.373 162.672  26.585  1.00  0.00           H  
ATOM   1787  HB2 GLN A 111      42.527 161.744  28.817  1.00  0.00           H  
ATOM   1788  HB3 GLN A 111      42.272 163.258  27.972  1.00  0.00           H  
ATOM   1789  HG2 GLN A 111      42.253 160.449  26.793  1.00  0.00           H  
ATOM   1790  HG3 GLN A 111      40.927 161.593  26.847  1.00  0.00           H  
ATOM   1791 HE21 GLN A 111      42.416 163.921  26.178  1.00  0.00           H  
ATOM   1792 HE22 GLN A 111      42.854 163.842  24.504  1.00  0.00           H  
ATOM   1793  N   LYS A 112      44.711 164.656  28.203  1.00  0.00           N  
ATOM   1794  CA  LYS A 112      45.270 165.730  29.007  1.00  0.00           C  
ATOM   1795  C   LYS A 112      44.749 167.072  28.490  1.00  0.00           C  
ATOM   1796  O   LYS A 112      44.499 167.227  27.295  1.00  0.00           O  
ATOM   1797  CB  LYS A 112      46.797 165.635  29.039  1.00  0.00           C  
ATOM   1798  CG  LYS A 112      47.376 166.503  30.158  1.00  0.00           C  
ATOM   1799  CD  LYS A 112      47.858 167.849  29.613  1.00  0.00           C  
ATOM   1800  CE  LYS A 112      48.380 168.743  30.740  1.00  0.00           C  
ATOM   1801  NZ  LYS A 112      49.155 169.876  30.187  1.00  0.00           N  
ATOM   1802  H   LYS A 112      44.228 164.952  27.379  1.00  0.00           H  
ATOM   1803  HA  LYS A 112      44.916 165.591  30.028  1.00  0.00           H  
ATOM   1804  HB2 LYS A 112      47.098 164.597  29.188  1.00  0.00           H  
ATOM   1805  HB3 LYS A 112      47.205 165.951  28.079  1.00  0.00           H  
ATOM   1806  HG2 LYS A 112      46.618 166.669  30.925  1.00  0.00           H  
ATOM   1807  HG3 LYS A 112      48.205 165.982  30.636  1.00  0.00           H  
ATOM   1808  HD2 LYS A 112      48.647 167.687  28.878  1.00  0.00           H  
ATOM   1809  HD3 LYS A 112      47.040 168.351  29.095  1.00  0.00           H  
ATOM   1810  HE2 LYS A 112      47.545 169.119  31.330  1.00  0.00           H  
ATOM   1811  HE3 LYS A 112      49.007 168.159  31.414  1.00  0.00           H  
ATOM   1812  HZ1 LYS A 112      49.440 169.660  29.253  1.00  0.00           H  
ATOM   1813  HZ2 LYS A 112      48.585 170.698  30.181  1.00  0.00           H  
ATOM   1814  HZ3 LYS A 112      49.963 170.034  30.754  1.00  0.00           H  
ATOM   1815  N   THR A 113      44.599 168.008  29.415  1.00  0.00           N  
ATOM   1816  CA  THR A 113      44.112 169.332  29.068  1.00  0.00           C  
ATOM   1817  C   THR A 113      44.721 170.386  29.996  1.00  0.00           C  
ATOM   1818  O   THR A 113      45.298 170.048  31.029  1.00  0.00           O  
ATOM   1819  CB  THR A 113      42.583 169.300  29.107  1.00  0.00           C  
ATOM   1820  OG1 THR A 113      42.230 168.336  28.118  1.00  0.00           O  
ATOM   1821  CG2 THR A 113      41.956 170.600  28.602  1.00  0.00           C  
ATOM   1822  H   THR A 113      44.804 167.875  30.384  1.00  0.00           H  
ATOM   1823  HA  THR A 113      44.445 169.567  28.056  1.00  0.00           H  
ATOM   1824  HB  THR A 113      42.224 169.058  30.108  1.00  0.00           H  
ATOM   1825  HG1 THR A 113      42.476 168.674  27.210  1.00  0.00           H  
ATOM   1826 HG21 THR A 113      42.514 170.960  27.738  1.00  0.00           H  
ATOM   1827 HG22 THR A 113      40.920 170.416  28.314  1.00  0.00           H  
ATOM   1828 HG23 THR A 113      41.986 171.349  29.391  1.00  0.00           H  
ATOM   1829  N   TYR A 114      44.571 171.639  29.595  1.00  0.00           N  
ATOM   1830  CA  TYR A 114      45.100 172.743  30.378  1.00  0.00           C  
ATOM   1831  C   TYR A 114      44.224 173.989  30.230  1.00  0.00           C  
ATOM   1832  O   TYR A 114      43.242 173.978  29.488  1.00  0.00           O  
ATOM   1833  CB  TYR A 114      46.488 173.039  29.808  1.00  0.00           C  
ATOM   1834  CG  TYR A 114      46.472 173.921  28.557  1.00  0.00           C  
ATOM   1835  CD1 TYR A 114      46.442 175.294  28.682  1.00  0.00           C  
ATOM   1836  CD2 TYR A 114      46.486 173.341  27.305  1.00  0.00           C  
ATOM   1837  CE1 TYR A 114      46.427 176.124  27.506  1.00  0.00           C  
ATOM   1838  CE2 TYR A 114      46.471 174.171  26.127  1.00  0.00           C  
ATOM   1839  CZ  TYR A 114      46.443 175.522  26.287  1.00  0.00           C  
ATOM   1840  OH  TYR A 114      46.428 176.306  25.175  1.00  0.00           O  
ATOM   1841  H   TYR A 114      44.101 171.905  28.754  1.00  0.00           H  
ATOM   1842  HA  TYR A 114      45.110 172.439  31.425  1.00  0.00           H  
ATOM   1843  HB2 TYR A 114      47.088 173.527  30.575  1.00  0.00           H  
ATOM   1844  HB3 TYR A 114      46.979 172.096  29.569  1.00  0.00           H  
ATOM   1845  HD1 TYR A 114      46.430 175.752  29.672  1.00  0.00           H  
ATOM   1846  HD2 TYR A 114      46.509 172.256  27.206  1.00  0.00           H  
ATOM   1847  HE1 TYR A 114      46.405 177.211  27.590  1.00  0.00           H  
ATOM   1848  HE2 TYR A 114      46.483 173.727  25.132  1.00  0.00           H  
ATOM   1849  HH  TYR A 114      45.676 176.962  25.229  1.00  0.00           H  
ATOM   1850  N   ALA A 115      44.611 175.034  30.946  1.00  0.00           N  
ATOM   1851  CA  ALA A 115      43.873 176.285  30.903  1.00  0.00           C  
ATOM   1852  C   ALA A 115      44.859 177.455  30.947  1.00  0.00           C  
ATOM   1853  O   ALA A 115      45.915 177.358  31.569  1.00  0.00           O  
ATOM   1854  CB  ALA A 115      42.868 176.327  32.056  1.00  0.00           C  
ATOM   1855  H   ALA A 115      45.410 175.036  31.547  1.00  0.00           H  
ATOM   1856  HA  ALA A 115      43.328 176.317  29.960  1.00  0.00           H  
ATOM   1857  HB1 ALA A 115      42.433 177.324  32.125  1.00  0.00           H  
ATOM   1858  HB2 ALA A 115      42.079 175.597  31.876  1.00  0.00           H  
ATOM   1859  HB3 ALA A 115      43.377 176.088  32.990  1.00  0.00           H  
ATOM   1860  N   GLU A 116      44.477 178.534  30.281  1.00  0.00           N  
ATOM   1861  CA  GLU A 116      45.314 179.721  30.235  1.00  0.00           C  
ATOM   1862  C   GLU A 116      44.833 180.749  31.261  1.00  0.00           C  
ATOM   1863  O   GLU A 116      43.691 181.205  31.200  1.00  0.00           O  
ATOM   1864  CB  GLU A 116      45.340 180.321  28.828  1.00  0.00           C  
ATOM   1865  CG  GLU A 116      46.690 180.076  28.153  1.00  0.00           C  
ATOM   1866  CD  GLU A 116      46.636 180.449  26.669  1.00  0.00           C  
ATOM   1867  OE1 GLU A 116      46.660 181.666  26.389  1.00  0.00           O  
ATOM   1868  OE2 GLU A 116      46.572 179.507  25.849  1.00  0.00           O  
ATOM   1869  H   GLU A 116      43.615 178.606  29.778  1.00  0.00           H  
ATOM   1870  HA  GLU A 116      46.316 179.380  30.497  1.00  0.00           H  
ATOM   1871  HB2 GLU A 116      44.543 179.883  28.228  1.00  0.00           H  
ATOM   1872  HB3 GLU A 116      45.145 181.393  28.883  1.00  0.00           H  
ATOM   1873  HG2 GLU A 116      47.462 180.662  28.650  1.00  0.00           H  
ATOM   1874  HG3 GLU A 116      46.968 179.027  28.257  1.00  0.00           H  
ATOM   1875  N   MET A 117      45.726 181.085  32.180  1.00  0.00           N  
ATOM   1876  CA  MET A 117      45.407 182.050  33.218  1.00  0.00           C  
ATOM   1877  C   MET A 117      45.955 183.435  32.866  1.00  0.00           C  
ATOM   1878  O   MET A 117      46.796 183.566  31.976  1.00  0.00           O  
ATOM   1879  CB  MET A 117      46.004 181.587  34.548  1.00  0.00           C  
ATOM   1880  CG  MET A 117      47.532 181.649  34.514  1.00  0.00           C  
ATOM   1881  SD  MET A 117      48.220 180.156  35.209  1.00  0.00           S  
ATOM   1882  CE  MET A 117      47.966 179.034  33.844  1.00  0.00           C  
ATOM   1883  H   MET A 117      46.652 180.710  32.222  1.00  0.00           H  
ATOM   1884  HA  MET A 117      44.319 182.084  33.261  1.00  0.00           H  
ATOM   1885  HB2 MET A 117      45.629 182.213  35.357  1.00  0.00           H  
ATOM   1886  HB3 MET A 117      45.682 180.568  34.760  1.00  0.00           H  
ATOM   1887  HG2 MET A 117      47.876 181.774  33.488  1.00  0.00           H  
ATOM   1888  HG3 MET A 117      47.881 182.515  35.076  1.00  0.00           H  
ATOM   1889  HE1 MET A 117      46.902 178.972  33.616  1.00  0.00           H  
ATOM   1890  HE2 MET A 117      48.504 179.399  32.968  1.00  0.00           H  
ATOM   1891  HE3 MET A 117      48.338 178.045  34.112  1.00  0.00           H  
ATOM   1892  N   ASP A 118      45.458 184.433  33.582  1.00  0.00           N  
ATOM   1893  CA  ASP A 118      45.889 185.802  33.357  1.00  0.00           C  
ATOM   1894  C   ASP A 118      47.324 185.970  33.858  1.00  0.00           C  
ATOM   1895  O   ASP A 118      47.702 185.391  34.875  1.00  0.00           O  
ATOM   1896  CB  ASP A 118      45.003 186.790  34.119  1.00  0.00           C  
ATOM   1897  CG  ASP A 118      45.216 188.261  33.758  1.00  0.00           C  
ATOM   1898  OD1 ASP A 118      44.841 188.628  32.623  1.00  0.00           O  
ATOM   1899  OD2 ASP A 118      45.751 188.987  34.624  1.00  0.00           O  
ATOM   1900  H   ASP A 118      44.776 184.317  34.303  1.00  0.00           H  
ATOM   1901  HA  ASP A 118      45.802 185.956  32.281  1.00  0.00           H  
ATOM   1902  HB2 ASP A 118      43.960 186.534  33.936  1.00  0.00           H  
ATOM   1903  HB3 ASP A 118      45.179 186.664  35.187  1.00  0.00           H  
ATOM   1904  N   PRO A 119      48.106 186.787  33.102  1.00  0.00           N  
ATOM   1905  CA  PRO A 119      49.491 187.039  33.460  1.00  0.00           C  
ATOM   1906  C   PRO A 119      49.585 187.995  34.651  1.00  0.00           C  
ATOM   1907  O   PRO A 119      49.935 187.582  35.756  1.00  0.00           O  
ATOM   1908  CB  PRO A 119      50.128 187.599  32.198  1.00  0.00           C  
ATOM   1909  CG  PRO A 119      48.976 188.075  31.327  1.00  0.00           C  
ATOM   1910  CD  PRO A 119      47.692 187.491  31.891  1.00  0.00           C  
ATOM   1911  HA  PRO A 119      49.933 186.191  33.753  1.00  0.00           H  
ATOM   1912  HB2 PRO A 119      50.804 188.421  32.433  1.00  0.00           H  
ATOM   1913  HB3 PRO A 119      50.716 186.838  31.686  1.00  0.00           H  
ATOM   1914  HG2 PRO A 119      48.929 189.164  31.317  1.00  0.00           H  
ATOM   1915  HG3 PRO A 119      49.120 187.753  30.295  1.00  0.00           H  
ATOM   1916  HD2 PRO A 119      46.967 188.274  32.117  1.00  0.00           H  
ATOM   1917  HD3 PRO A 119      47.219 186.813  31.182  1.00  0.00           H  
ATOM   1918  N   THR A 120      49.267 189.253  34.387  1.00  0.00           N  
ATOM   1919  CA  THR A 120      49.311 190.270  35.423  1.00  0.00           C  
ATOM   1920  C   THR A 120      48.544 191.518  34.980  1.00  0.00           C  
ATOM   1921  O   THR A 120      48.537 191.859  33.799  1.00  0.00           O  
ATOM   1922  CB  THR A 120      50.779 190.545  35.753  1.00  0.00           C  
ATOM   1923  OG1 THR A 120      50.725 191.468  36.838  1.00  0.00           O  
ATOM   1924  CG2 THR A 120      51.494 191.318  34.643  1.00  0.00           C  
ATOM   1925  H   THR A 120      48.984 189.580  33.485  1.00  0.00           H  
ATOM   1926  HA  THR A 120      48.806 189.881  36.307  1.00  0.00           H  
ATOM   1927  HB  THR A 120      51.307 189.619  35.985  1.00  0.00           H  
ATOM   1928  HG1 THR A 120      50.293 192.319  36.541  1.00  0.00           H  
ATOM   1929 HG21 THR A 120      51.965 192.206  35.064  1.00  0.00           H  
ATOM   1930 HG22 THR A 120      52.256 190.682  34.191  1.00  0.00           H  
ATOM   1931 HG23 THR A 120      50.772 191.615  33.883  1.00  0.00           H  
ATOM   1932  N   THR A 121      47.916 192.163  35.952  1.00  0.00           N  
ATOM   1933  CA  THR A 121      47.148 193.366  35.677  1.00  0.00           C  
ATOM   1934  C   THR A 121      47.197 194.316  36.875  1.00  0.00           C  
ATOM   1935  O   THR A 121      47.451 193.890  38.000  1.00  0.00           O  
ATOM   1936  CB  THR A 121      45.729 192.942  35.295  1.00  0.00           C  
ATOM   1937  OG1 THR A 121      45.095 194.158  34.906  1.00  0.00           O  
ATOM   1938  CG2 THR A 121      44.914 192.468  36.501  1.00  0.00           C  
ATOM   1939  H   THR A 121      47.927 191.879  36.911  1.00  0.00           H  
ATOM   1940  HA  THR A 121      47.611 193.884  34.837  1.00  0.00           H  
ATOM   1941  HB  THR A 121      45.746 192.182  34.514  1.00  0.00           H  
ATOM   1942  HG1 THR A 121      45.498 194.496  34.055  1.00  0.00           H  
ATOM   1943 HG21 THR A 121      43.955 192.986  36.519  1.00  0.00           H  
ATOM   1944 HG22 THR A 121      44.746 191.394  36.427  1.00  0.00           H  
ATOM   1945 HG23 THR A 121      45.462 192.688  37.418  1.00  0.00           H  
ATOM   1946  N   ALA A 122      46.952 195.587  36.592  1.00  0.00           N  
ATOM   1947  CA  ALA A 122      46.965 196.602  37.631  1.00  0.00           C  
ATOM   1948  C   ALA A 122      46.556 197.948  37.030  1.00  0.00           C  
ATOM   1949  O   ALA A 122      46.292 198.042  35.833  1.00  0.00           O  
ATOM   1950  CB  ALA A 122      48.350 196.649  38.280  1.00  0.00           C  
ATOM   1951  H   ALA A 122      46.747 195.925  35.673  1.00  0.00           H  
ATOM   1952  HA  ALA A 122      46.234 196.312  38.386  1.00  0.00           H  
ATOM   1953  HB1 ALA A 122      48.635 195.648  38.604  1.00  0.00           H  
ATOM   1954  HB2 ALA A 122      49.078 197.018  37.557  1.00  0.00           H  
ATOM   1955  HB3 ALA A 122      48.325 197.316  39.142  1.00  0.00           H  
ATOM   1956  N   ALA A 123      46.516 198.956  37.889  1.00  0.00           N  
ATOM   1957  CA  ALA A 123      46.143 200.292  37.457  1.00  0.00           C  
ATOM   1958  C   ALA A 123      47.329 201.238  37.660  1.00  0.00           C  
ATOM   1959  O   ALA A 123      48.426 200.799  38.002  1.00  0.00           O  
ATOM   1960  CB  ALA A 123      44.898 200.746  38.221  1.00  0.00           C  
ATOM   1961  H   ALA A 123      46.732 198.870  38.861  1.00  0.00           H  
ATOM   1962  HA  ALA A 123      45.906 200.243  36.395  1.00  0.00           H  
ATOM   1963  HB1 ALA A 123      45.015 201.788  38.521  1.00  0.00           H  
ATOM   1964  HB2 ALA A 123      44.022 200.649  37.579  1.00  0.00           H  
ATOM   1965  HB3 ALA A 123      44.768 200.125  39.108  1.00  0.00           H  
ATOM   1966  N   LEU A 124      47.067 202.518  37.441  1.00  0.00           N  
ATOM   1967  CA  LEU A 124      48.099 203.529  37.596  1.00  0.00           C  
ATOM   1968  C   LEU A 124      47.805 204.367  38.842  1.00  0.00           C  
ATOM   1969  O   LEU A 124      47.908 203.874  39.964  1.00  0.00           O  
ATOM   1970  CB  LEU A 124      48.234 204.357  36.316  1.00  0.00           C  
ATOM   1971  CG  LEU A 124      46.925 204.848  35.694  1.00  0.00           C  
ATOM   1972  CD1 LEU A 124      47.071 206.274  35.162  1.00  0.00           C  
ATOM   1973  CD2 LEU A 124      46.436 203.881  34.613  1.00  0.00           C  
ATOM   1974  H   LEU A 124      46.172 202.867  37.164  1.00  0.00           H  
ATOM   1975  HA  LEU A 124      49.046 203.010  37.745  1.00  0.00           H  
ATOM   1976  HB2 LEU A 124      48.857 205.224  36.532  1.00  0.00           H  
ATOM   1977  HB3 LEU A 124      48.765 203.760  35.575  1.00  0.00           H  
ATOM   1978  HG  LEU A 124      46.163 204.870  36.473  1.00  0.00           H  
ATOM   1979 HD11 LEU A 124      46.803 206.297  34.105  1.00  0.00           H  
ATOM   1980 HD12 LEU A 124      46.411 206.939  35.719  1.00  0.00           H  
ATOM   1981 HD13 LEU A 124      48.104 206.603  35.282  1.00  0.00           H  
ATOM   1982 HD21 LEU A 124      45.862 204.430  33.867  1.00  0.00           H  
ATOM   1983 HD22 LEU A 124      47.294 203.406  34.135  1.00  0.00           H  
ATOM   1984 HD23 LEU A 124      45.805 203.117  35.067  1.00  0.00           H  
ATOM   1985  N   GLU A 125      47.442 205.619  38.602  1.00  0.00           N  
ATOM   1986  CA  GLU A 125      47.131 206.529  39.692  1.00  0.00           C  
ATOM   1987  C   GLU A 125      46.849 207.931  39.147  1.00  0.00           C  
ATOM   1988  O   GLU A 125      47.721 208.552  38.541  1.00  0.00           O  
ATOM   1989  CB  GLU A 125      48.261 206.557  40.722  1.00  0.00           C  
ATOM   1990  CG  GLU A 125      47.709 206.438  42.144  1.00  0.00           C  
ATOM   1991  CD  GLU A 125      48.840 206.236  43.155  1.00  0.00           C  
ATOM   1992  OE1 GLU A 125      49.404 205.120  43.161  1.00  0.00           O  
ATOM   1993  OE2 GLU A 125      49.115 207.202  43.900  1.00  0.00           O  
ATOM   1994  H   GLU A 125      47.359 206.011  37.686  1.00  0.00           H  
ATOM   1995  HA  GLU A 125      46.232 206.127  40.158  1.00  0.00           H  
ATOM   1996  HB2 GLU A 125      48.956 205.740  40.528  1.00  0.00           H  
ATOM   1997  HB3 GLU A 125      48.825 207.486  40.624  1.00  0.00           H  
ATOM   1998  HG2 GLU A 125      47.147 207.337  42.397  1.00  0.00           H  
ATOM   1999  HG3 GLU A 125      47.014 205.601  42.198  1.00  0.00           H  
ATOM   2000  N   LYS A 126      45.628 208.389  39.384  1.00  0.00           N  
ATOM   2001  CA  LYS A 126      45.222 209.706  38.924  1.00  0.00           C  
ATOM   2002  C   LYS A 126      45.552 210.741  40.001  1.00  0.00           C  
ATOM   2003  O   LYS A 126      45.701 210.397  41.173  1.00  0.00           O  
ATOM   2004  CB  LYS A 126      43.749 209.698  38.510  1.00  0.00           C  
ATOM   2005  CG  LYS A 126      42.937 210.683  39.354  1.00  0.00           C  
ATOM   2006  CD  LYS A 126      41.476 210.718  38.902  1.00  0.00           C  
ATOM   2007  CE  LYS A 126      40.886 212.120  39.062  1.00  0.00           C  
ATOM   2008  NZ  LYS A 126      39.561 212.204  38.407  1.00  0.00           N  
ATOM   2009  H   LYS A 126      44.925 207.878  39.877  1.00  0.00           H  
ATOM   2010  HA  LYS A 126      45.806 209.937  38.033  1.00  0.00           H  
ATOM   2011  HB2 LYS A 126      43.662 209.958  37.456  1.00  0.00           H  
ATOM   2012  HB3 LYS A 126      43.342 208.693  38.624  1.00  0.00           H  
ATOM   2013  HG2 LYS A 126      42.988 210.395  40.404  1.00  0.00           H  
ATOM   2014  HG3 LYS A 126      43.370 211.680  39.274  1.00  0.00           H  
ATOM   2015  HD2 LYS A 126      41.407 210.408  37.858  1.00  0.00           H  
ATOM   2016  HD3 LYS A 126      40.893 210.005  39.484  1.00  0.00           H  
ATOM   2017  HE2 LYS A 126      40.791 212.362  40.121  1.00  0.00           H  
ATOM   2018  HE3 LYS A 126      41.560 212.857  38.626  1.00  0.00           H  
ATOM   2019  HZ1 LYS A 126      39.160 213.103  38.580  1.00  0.00           H  
ATOM   2020  HZ2 LYS A 126      39.667 212.070  37.422  1.00  0.00           H  
ATOM   2021  HZ3 LYS A 126      38.961 211.495  38.777  1.00  0.00           H  
ATOM   2022  N   GLU A 127      45.658 211.988  39.566  1.00  0.00           N  
ATOM   2023  CA  GLU A 127      45.968 213.075  40.478  1.00  0.00           C  
ATOM   2024  C   GLU A 127      45.676 214.424  39.816  1.00  0.00           C  
ATOM   2025  O   GLU A 127      45.389 214.483  38.621  1.00  0.00           O  
ATOM   2026  CB  GLU A 127      47.422 212.999  40.949  1.00  0.00           C  
ATOM   2027  CG  GLU A 127      48.387 213.252  39.789  1.00  0.00           C  
ATOM   2028  CD  GLU A 127      49.576 212.291  39.846  1.00  0.00           C  
ATOM   2029  OE1 GLU A 127      50.388 212.447  40.783  1.00  0.00           O  
ATOM   2030  OE2 GLU A 127      49.646 211.422  38.950  1.00  0.00           O  
ATOM   2031  H   GLU A 127      45.535 212.260  38.611  1.00  0.00           H  
ATOM   2032  HA  GLU A 127      45.308 212.933  41.334  1.00  0.00           H  
ATOM   2033  HB2 GLU A 127      47.592 213.734  41.736  1.00  0.00           H  
ATOM   2034  HB3 GLU A 127      47.616 212.017  41.381  1.00  0.00           H  
ATOM   2035  HG2 GLU A 127      47.862 213.133  38.842  1.00  0.00           H  
ATOM   2036  HG3 GLU A 127      48.745 214.281  39.828  1.00  0.00           H  
ATOM   2037  N   SER A 128      45.760 215.473  40.621  1.00  0.00           N  
ATOM   2038  CA  SER A 128      45.509 216.816  40.128  1.00  0.00           C  
ATOM   2039  C   SER A 128      45.938 217.847  41.174  1.00  0.00           C  
ATOM   2040  O   SER A 128      46.303 217.487  42.291  1.00  0.00           O  
ATOM   2041  CB  SER A 128      44.033 217.005  39.771  1.00  0.00           C  
ATOM   2042  OG  SER A 128      43.224 217.199  40.928  1.00  0.00           O  
ATOM   2043  H   SER A 128      45.995 215.416  41.591  1.00  0.00           H  
ATOM   2044  HA  SER A 128      46.115 216.911  39.227  1.00  0.00           H  
ATOM   2045  HB2 SER A 128      43.927 217.862  39.107  1.00  0.00           H  
ATOM   2046  HB3 SER A 128      43.678 216.132  39.223  1.00  0.00           H  
ATOM   2047  HG  SER A 128      42.469 216.546  40.931  1.00  0.00           H  
ATOM   2048  N   GLY A 129      45.879 219.108  40.774  1.00  0.00           N  
ATOM   2049  CA  GLY A 129      46.256 220.194  41.664  1.00  0.00           C  
ATOM   2050  C   GLY A 129      45.638 221.517  41.208  1.00  0.00           C  
ATOM   2051  O   GLY A 129      45.412 221.723  40.018  1.00  0.00           O  
ATOM   2052  H   GLY A 129      45.581 219.394  39.864  1.00  0.00           H  
ATOM   2053  HA2 GLY A 129      45.932 219.966  42.679  1.00  0.00           H  
ATOM   2054  HA3 GLY A 129      47.342 220.286  41.689  1.00  0.00           H  
ATOM   2055  N   PRO A 130      45.374 222.402  42.207  1.00  0.00           N  
ATOM   2056  CA  PRO A 130      44.787 223.699  41.922  1.00  0.00           C  
ATOM   2057  C   PRO A 130      45.818 224.646  41.307  1.00  0.00           C  
ATOM   2058  O   PRO A 130      46.936 224.235  40.997  1.00  0.00           O  
ATOM   2059  CB  PRO A 130      44.250 224.191  43.256  1.00  0.00           C  
ATOM   2060  CG  PRO A 130      44.963 223.371  44.319  1.00  0.00           C  
ATOM   2061  CD  PRO A 130      45.630 222.191  43.629  1.00  0.00           C  
ATOM   2062  HA  PRO A 130      44.060 223.608  41.240  1.00  0.00           H  
ATOM   2063  HB2 PRO A 130      44.445 225.255  43.387  1.00  0.00           H  
ATOM   2064  HB3 PRO A 130      43.170 224.054  43.317  1.00  0.00           H  
ATOM   2065  HG2 PRO A 130      45.704 223.979  44.836  1.00  0.00           H  
ATOM   2066  HG3 PRO A 130      44.256 223.022  45.071  1.00  0.00           H  
ATOM   2067  HD2 PRO A 130      46.699 222.162  43.840  1.00  0.00           H  
ATOM   2068  HD3 PRO A 130      45.212 221.245  43.971  1.00  0.00           H  
ATOM   2069  N   SER A 131      45.408 225.896  41.148  1.00  0.00           N  
ATOM   2070  CA  SER A 131      46.283 226.904  40.576  1.00  0.00           C  
ATOM   2071  C   SER A 131      46.279 228.159  41.452  1.00  0.00           C  
ATOM   2072  O   SER A 131      47.326 228.590  41.932  1.00  0.00           O  
ATOM   2073  CB  SER A 131      45.863 227.253  39.148  1.00  0.00           C  
ATOM   2074  OG  SER A 131      46.105 226.179  38.243  1.00  0.00           O  
ATOM   2075  H   SER A 131      44.497 226.222  41.402  1.00  0.00           H  
ATOM   2076  HA  SER A 131      47.275 226.452  40.563  1.00  0.00           H  
ATOM   2077  HB2 SER A 131      44.803 227.507  39.133  1.00  0.00           H  
ATOM   2078  HB3 SER A 131      46.406 228.138  38.815  1.00  0.00           H  
ATOM   2079  HG  SER A 131      46.310 225.343  38.751  1.00  0.00           H  
ATOM   2080  N   SER A 132      45.087 228.711  41.634  1.00  0.00           N  
ATOM   2081  CA  SER A 132      44.932 229.907  42.443  1.00  0.00           C  
ATOM   2082  C   SER A 132      45.758 229.783  43.724  1.00  0.00           C  
ATOM   2083  O   SER A 132      46.164 228.686  44.102  1.00  0.00           O  
ATOM   2084  CB  SER A 132      43.460 230.154  42.784  1.00  0.00           C  
ATOM   2085  OG  SER A 132      42.758 230.763  41.703  1.00  0.00           O  
ATOM   2086  H   SER A 132      44.240 228.353  41.240  1.00  0.00           H  
ATOM   2087  HA  SER A 132      45.303 230.724  41.825  1.00  0.00           H  
ATOM   2088  HB2 SER A 132      42.983 229.209  43.039  1.00  0.00           H  
ATOM   2089  HB3 SER A 132      43.394 230.793  43.665  1.00  0.00           H  
ATOM   2090  HG  SER A 132      41.781 230.565  41.777  1.00  0.00           H  
ATOM   2091  N   GLY A 133      45.986 230.925  44.357  1.00  0.00           N  
ATOM   2092  CA  GLY A 133      46.757 230.958  45.588  1.00  0.00           C  
ATOM   2093  C   GLY A 133      48.161 230.389  45.370  1.00  0.00           C  
ATOM   2094  O   GLY A 133      49.148 230.978  45.807  1.00  0.00           O  
ATOM   2095  H   GLY A 133      45.652 231.815  44.043  1.00  0.00           H  
ATOM   2096  HA2 GLY A 133      46.829 231.984  45.948  1.00  0.00           H  
ATOM   2097  HA3 GLY A 133      46.244 230.384  46.359  1.00  0.00           H  
TER    2098      GLY A 133                                                      
END
MOLECULE T0504.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37      A    N   
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83      A    C   
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78      A    C   
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39      A    C   
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16      A    C   
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97      A    O   
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44      A    O   
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49      A    C   
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06      A    O   
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86      A    N   
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98      A    C   
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58      A    C   
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84      A    C   
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71      A    O   
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97      A    N   
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53      A    C   
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15      A    O   
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85      A    N   
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02      A    C   
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25      A    C   
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02      A    C   
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09      A    C   
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44      A    C   
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19      A    C   
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84      A    O   
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57      A    N   
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42      A    C   
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98      A    C   
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50      A    C   
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82      A    C   
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45      A    C   
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13      A    C   
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65      A    O   
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20      A    C   
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73      A    C   
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61      A    C   
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26      A    O   
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30      A    N   
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43      A    C   
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10      A    C   
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27      A    C   
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53      A    C   
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63      A    C   
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66      A    C   
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69      A    C   
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08      A    C   
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65      A    C   
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56      A    O   
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36      A    N   
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14      A    C   
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23      A    C   
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69      A    C   
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80      A    C   
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70      A    O   
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90      A    N   
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19      A    C   
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02      A    O   
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63      A    N   
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46      A    C   
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41      A    C   
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44      A    O   
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77      A    N   
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30      A    C   
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54      A    C   
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43      A    C   
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86      A    O   
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63      A    O   
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60      A    C   
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73      A    O   
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56      A    N   
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77      A    C   
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79      A    C   
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44      A    C   
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81      A    C   
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75      A    C   
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16      A    C   
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21      A    O   
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94      A    N   
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76      A    C   
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23      A    C   
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89      A    C   
ATOM     82  CD1 ILE    10      43.756  81.529   2.264  1.00 19.82      A    C   
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10      A    C   
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82      A    C   
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77      A    O   
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59      A    N   
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06      A    C   
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08      A    C   
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60      A    C   
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92      A    C   
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05      A    C   
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69      A    O   
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61      A    N   
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09      A    C   
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98      A    C   
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77      A    O   
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91      A    C   
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32      A    O   
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08      A    N   
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70      A    C   
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79      A    C   
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89      A    C   
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11      A    S   
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35      A    C   
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22      A    C   
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56      A    O   
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80      A    N   
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49      A    C   
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73      A    C   
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59      A    C   
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95      A    C   
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61      A    N   
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50      A    C   
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44      A    N   
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31      A    N   
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43      A    C   
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04      A    O   
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91      A    N   
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92      A    C   
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59      A    C   
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51      A    C   
ATOM    122  CD1 ILE    15      39.996  70.306   0.585  1.00 27.05      A    C   
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98      A    C   
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96      A    C   
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85      A    O   
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39      A    N   
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24      A    C   
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17      A    C   
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85      A    C   
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99      A    C   
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18      A    C   
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28      A    C   
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31      A    O   
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22      A    N   
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80      A    C   
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12      A    C   
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61      A    O   
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83      A    N   
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17      A    C   
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50      A    C   
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64      A    C   
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12      A    C   
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74      A    C   
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73      A    N   
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38      A    C   
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23      A    O   
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11      A    N   
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79      A    C   
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26      A    C   
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88      A    C   
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99      A    C   
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04      A    C   
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94      A    N   
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81      A    C   
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30      A    O   
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76      A    N   
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24      A    C   
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99      A    C   
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44      A    C   
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93      A    C   
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65      A    N   
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27      A    C   
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35      A    N   
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75      A    N   
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01      A    C   
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04      A    O   
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23      A    N   
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54      A    C   
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45      A    C   
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78      A    O   
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28      A    C   
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38      A    C   
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92      A    O   
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59      A    N   
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14      A    C   
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57      A    C   
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45      A    C   
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60      A    C   
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60      A    C   
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41      A    N   
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65      A    C   
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29      A    O   
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11      A    N   
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84      A    C   
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56      A    C   
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85      A    O   
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10      A    C   
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11      A    C   
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72      A    O   
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67      A    N   
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31      A    C   
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09      A    C   
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47      A    C   
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88      A    C   
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63      A    N   
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14      A    C   
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29      A    C   
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05      A    C   
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65      A    C   
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25      A    C   
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47      A    C   
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55      A    C   
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75      A    O   
ATOM    204  N   HIS    25      37.463  62.079   4.725  1.00 21.41      A    N   
ATOM    205  CA  HIS    25      38.827  61.919   5.220  1.00 21.79      A    C   
ATOM    206  CB  HIS    25      39.499  60.706   4.534  1.00 22.01      A    C   
ATOM    207  CG  HIS    25      38.761  59.428   4.754  1.00 21.78      A    C   
ATOM    208  ND1 HIS    25      37.736  59.007   3.930  1.00 24.64      A    N   
ATOM    209  CE1 HIS    25      37.239  57.871   4.392  1.00 21.18      A    C   
ATOM    210  NE2 HIS    25      37.889  57.555   5.498  1.00 25.69      A    N   
ATOM    211  CD2 HIS    25      38.845  58.514   5.748  1.00 20.97      A    C   
ATOM    212  C   HIS    25      39.676  63.161   5.020  1.00 22.34      A    C   
ATOM    213  O   HIS    25      39.459  63.941   4.095  1.00 22.06      A    O   
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29      A    N   
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67      A    C   
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03      A    C   
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30      A    C   
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62      A    C   
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11      A    C   
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57      A    N   
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07      A    C   
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59      A    O   
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33      A    N   
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34      A    C   
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08      A    C   
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58      A    O   
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74      A    N   
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93      A    C   
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06      A    C   
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73      A    O   
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50      A    C   
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32      A    C   
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70      A    O   
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17      A    N   
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39      A    C   
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00      A    C   
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05      A    C   
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84      A    C   
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24      A    C   
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77      A    C   
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81      A    O   
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86      A    N   
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29      A    C   
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12      A    C   
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65      A    C   
ATOM    246  CD1 ILE    30      47.190  67.505  -5.529  1.00 23.75      A    C   
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13      A    C   
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92      A    C   
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81      A    O   
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57      A    N   
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70      A    C   
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85      A    C   
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21      A    C   
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86      A    O   
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51      A    N   
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06      A    C   
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62      A    C   
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72      A    C   
ATOM    259  CD1 ILE    32      41.312  76.990  -4.538  1.00 21.43      A    C   
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89      A    C   
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59      A    C   
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54      A    O   
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30      A    N   
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55      A    C   
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71      A    C   
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65      A    C   
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37      A    C   
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45      A    O   
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01      A    N   
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54      A    C   
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76      A    O   
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78      A    N   
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41      A    C   
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30      A    C   
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81      A    O   
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36      A    C   
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52      A    C   
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01      A    O   
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56      A    N   
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84      A    C   
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18      A    C   
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09      A    C   
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61      A    C   
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94      A    C   
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63      A    O   
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84      A    N   
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85      A    C   
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67      A    C   
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99      A    O   
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19      A    N   
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16      A    C   
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59      A    C   
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83      A    C   
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32      A    C   
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79      A    C   
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51      A    O   
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42      A    N   
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23      A    C   
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59      A    C   
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97      A    O   
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52      A    N   
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99      A    C   
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28      A    C   
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73      A    C   
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93      A    C   
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28      A    C   
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24      A    N   
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68      A    C   
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89      A    O   
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54      A    N   
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74      A    C   
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45      A    C   
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21      A    C   
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42      A    C   
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38      A    C   
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30      A    N   
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98      A    C   
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60      A    O   
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67      A    N   
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61      A    C   
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74      A    C   
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37      A    C   
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43      A    C   
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08      A    C   
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70      A    C   
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71      A    O   
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29      A    C   
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84      A    C   
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85      A    C   
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49      A    O   
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94      A    N   
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02      A    C   
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22      A    C   
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67      A    C   
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84      A    C   
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36      A    C   
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81      A    N   
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53      A    C   
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05      A    O   
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35      A    N   
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92      A    C   
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50      A    C   
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28      A    C   
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88      A    C   
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25      A    C   
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86      A    O   
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74      A    N   
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81      A    C   
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63      A    C   
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17      A    C   
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45      A    C   
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65      A    C   
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07      A    N   
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00      A    C   
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51      A    O   
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53      A    N   
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40      A    C   
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65      A    C   
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24      A    C   
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75      A    C   
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50      A    C   
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86      A    C   
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89      A    C   
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72      A    C   
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99      A    C   
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81      A    O   
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71      A    N   
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20      A    C   
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20      A    C   
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31      A    C   
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82      A    O   
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86      A    O   
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51      A    C   
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78      A    O   
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36      A    N   
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07      A    C   
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82      A    C   
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15      A    O   
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00           N   
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00           C   
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00           C   
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00           C   
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89      A    O   
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66      A    N   
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00      A    C   
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62      A    C   
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03      A    O   
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46      A    N   
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65      A    C   
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92      A    C   
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50      A    C   
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70      A    C   
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53      A    C   
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89      A    N   
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83      A    C   
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32      A    O   
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37      A    N   
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75      A    C   
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54      A    C   
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38      A    O   
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54      A    C   
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69      A    O   
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75      A    N   
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31      A    C   
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47      A    C   
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39      A    C   
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20      A    C   
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52      A    C   
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65      A    C   
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95      A    O   
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72      A    N   
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96      A    C   
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56      A    C   
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20      A    C   
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98      A    C   
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46      A    C   
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06      A    C   
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74      A    O   
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72      A    N   
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06      A    C   
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95      A    C   
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54      A    O   
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42      A    C   
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57      A    O   
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72      A    N   
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16      A    C   
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50      A    C   
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73      A    O   
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83      A    N   
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79      A    C   
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23      A    C   
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56      A    C   
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74      A    O   
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32      A    N   
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90      A    C   
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34      A    O   
ATOM    437  N   HIS    57      31.698  68.348  -2.203  1.00 18.92      A    N   
ATOM    438  CA  HIS    57      32.361  67.115  -1.745  1.00 19.22      A    C   
ATOM    439  CB  HIS    57      32.520  66.145  -2.914  1.00 19.81      A    C   
ATOM    440  CG  HIS    57      31.219  65.568  -3.378  1.00 20.14      A    C   
ATOM    441  ND1 HIS    57      31.049  65.028  -4.633  1.00 22.60      A    N   
ATOM    442  CE1 HIS    57      29.809  64.583  -4.748  1.00 22.65      A    C   
ATOM    443  NE2 HIS    57      29.171  64.824  -3.616  1.00 21.53      A    N   
ATOM    444  CD2 HIS    57      30.028  65.448  -2.747  1.00 20.42      A    C   
ATOM    445  C   HIS    57      33.680  67.336  -0.975  1.00 19.11      A    C   
ATOM    446  O   HIS    57      34.538  66.434  -0.828  1.00 18.12      A    O   
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70      A    N   
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51      A    C   
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69      A    C   
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12      A    C   
ATOM    451  CD1 ILE    58      36.427  72.053  -1.279  1.00 20.43      A    C   
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86      A    C   
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50      A    C   
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32      A    O   
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26      A    N   
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14      A    C   
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64      A    C   
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13      A    C   
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21      A    O   
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54      A    N   
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93      A    C   
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71      A    C   
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24      A    C   
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29      A    C   
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49      A    C   
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43      A    C   
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41      A    O   
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82      A    C   
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93      A    C   
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12      A    C   
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61      A    O   
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95      A    N   
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35      A    C   
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77      A    C   
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11      A    C   
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02      A    O   
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95      A    O   
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08      A    C   
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03      A    O   
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41      A    N   
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63      A    C   
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27      A    C   
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13      A    C   
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54      A    C   
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38      A    C   
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74      A    C   
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51      A    O   
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91      A    C   
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32      A    C   
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84      A    C   
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97      A    O   
ATOM    492  N   HIS    63      35.010  73.105  13.440  1.00 24.32      A    N   
ATOM    493  CA  HIS    63      33.615  73.111  13.872  1.00 25.56      A    C   
ATOM    494  CB  HIS    63      33.519  72.477  15.263  1.00 24.97      A    C   
ATOM    495  CG  HIS    63      34.160  71.127  15.321  1.00 24.22      A    C   
ATOM    496  ND1 HIS    63      35.270  70.847  16.088  1.00 28.07      A    N   
ATOM    497  CE1 HIS    63      35.632  69.590  15.888  1.00 26.20      A    C   
ATOM    498  NE2 HIS    63      34.807  69.053  15.003  1.00 26.25      A    N   
ATOM    499  CD2 HIS    63      33.881  69.993  14.634  1.00 22.43      A    C   
ATOM    500  C   HIS    63      33.056  74.547  13.817  1.00 27.28      A    C   
ATOM    501  O   HIS    63      33.586  75.443  14.467  1.00 29.56      A    O   
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66      A    N   
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40      A    C   
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92      A    C   
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74      A    C   
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41      A    C   
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53      A    C   
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81      A    O   
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51      A    N   
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90      A    C   
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10      A    C   
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99      A    C   
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84      A    C   
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20      A    C   
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73      A    O   
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87      A    N   
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85      A    C   
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88      A    C   
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29      A    C   
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66      A    O   
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76      A    N   
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53      A    C   
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00      A    C   
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77      A    C   
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49      A    O   
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84      A    O   
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00      A    C   
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51      A    O   
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05      A    N   
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09      A    C   
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00      A    C   
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64      A    C   
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82      A    C   
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10      A    C   
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28      A    N   
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41      A    C   
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19      A    O   
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13      A    N   
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80      A    C   
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60      A    C   
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76      A    C   
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41      A    C   
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04      A    C   
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41      A    C   
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95      A    O   
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13      A    N   
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67      A    C   
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50      A    C   
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84      A    C   
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92      A    C   
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60      A    C   
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62      A    C   
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75      A    O   
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82      A    C   
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32      A    C   
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40      A    C   
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25      A    O   
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95      A    N   
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52      A    C   
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43      A    C   
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15      A    C   
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14      A    C   
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13      A    C   
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79      A    O   
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52      A    N   
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27      A    C   
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65      A    C   
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42      A    O   
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32      A    N   
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94      A    C   
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83      A    C   
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16      A    O   
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98      A    C   
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46      A    O   
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33      A    N   
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00      A    C   
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66      A    C   
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27      A    C   
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00      A    C   
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45      A    N   
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96      A    C   
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65      A    N   
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44      A    N   
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93      A    C   
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89      A    O   
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79      A    N   
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83      A    C   
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62      A    C   
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43      A    C   
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70      A    C   
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62      A    C   
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18      A    O   
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40      A    N   
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21      A    C   
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42      A    C   
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77      A    C   
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22      A    C   
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24      A    C   
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16      A    O   
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51      A    N   
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54      A    C   
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86      A    C   
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89      A    C   
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43      A    O   
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68      A    N   
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04      A    C   
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30      A    C   
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63      A    C   
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97      A    C   
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00      A    C   
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09      A    N   
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29      A    C   
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83      A    O   
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82      A    N   
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33      A    C   
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99      A    C   
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73      A    C   
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64      A    C   
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11      A    C   
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97      A    C   
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65      A    O   
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25      A    C   
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71      A    C   
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65      A    C   
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57      A    O   
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32      A    N   
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27      A    C   
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32      A    C   
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72      A    C   
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04      A    C   
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43      A    C   
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93      A    N   
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48      A    C   
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81      A    O   
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78      A    N   
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62      A    C   
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24      A    C   
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99      A    C   
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44      A    O   
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57      A    O   
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52      A    C   
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39      A    O   
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60      A    N   
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72      A    C   
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07      A    C   
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78      A    O   
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49      A    N   
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85      A    C   
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92      A    C   
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01      A    C   
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64      A    O   
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43      A    N   
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94      A    C   
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99      A    O   
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49      A    N   
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91      A    C   
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50      A    C   
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10      A    C   
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73      A    C   
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41      A    O   
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20      A    N   
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46      A    C   
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29      A    O   
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39      A    N   
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91      A    C   
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56      A    C   
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69      A    C   
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70      A    C   
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15      A    C   
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90      A    O   
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99      A    N   
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21      A    C   
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50      A    C   
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34      A    C   
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51      A    C   
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04      A    N   
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89      A    C   
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94      A    C   
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27      A    C   
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48      A    C   
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06      A    C   
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81      A    C   
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19      A    C   
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63      A    O   
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91      A    N   
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62      A    C   
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68      A    C   
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51      A    C   
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55      A    C   
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57      A    C   
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15      A    C   
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15      A    O   
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09      A    N   
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91      A    C   
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64      A    C   
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36      A    C   
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44      A    C   
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12      A    C   
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12      A    C   
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59      A    O   
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18      A    C   
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61      A    C   
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17      A    C   
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43      A    O   
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08      A    N   
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00      A    C   
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19      A    C   
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22      A    C   
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28      A    O   
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54      A    N   
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43      A    C   
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72      A    C   
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00      A    O   
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87      A    N   
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36      A    C   
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32      A    C   
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77      A    C   
ATOM    718  CD1 ILE    91      21.004  68.804   3.522  1.00 26.35      A    C   
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37      A    C   
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40      A    C   
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69      A    O   
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01      A    N   
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58      A    C   
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01      A    C   
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99      A    C   
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64      A    C   
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26      A    C   
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42      A    O   
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59      A    N   
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19      A    C   
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13      A    C   
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92      A    C   
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56      A    O   
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37      A    N   
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21      A    C   
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92      A    C   
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03      A    C   
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98      A    C   
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90      A    O   
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28      A    O   
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23      A    C   
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59      A    O   
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37      A    N   
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74      A    C   
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84      A    C   
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78      A    O   
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52      A    C   
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60      A    C   
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69      A    O   
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69      A    N   
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59      A    C   
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22      A    C   
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67      A    C   
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43      A    C   
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84      A    C   
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06      A    O   
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07      A    N   
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93      A    C   
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42      A    C   
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70      A    C   
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18      A    O   
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03      A    N   
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34      A    C   
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04      A    O   
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73      A    N   
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02      A    C   
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18      A    C   
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17      A    C   
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25      A    C   
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86      A    C   
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40      A    O   
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93      A    N   
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74      A    C   
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01      A    C   
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21      A    C   
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77      A    C   
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90      A    C   
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85      A    N   
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32      A    C   
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38      A    O   
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61      A    N   
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96      A    C   
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58      A    C   
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24      A    C   
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88      A    O   
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73      A    N   
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87      A    C   
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07      A    O   
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69      A    N   
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96      A    C   
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57      A    C   
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38      A    C   
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44      A    C   
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30      A    C   
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55      A    N   
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33      A    C   
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46      A    O   
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23      A    N   
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59      A    C   
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55      A    C   
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10      A    C   
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70      A    C   
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74      A    C   
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80      A    C   
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60      A    O   
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82      A    N   
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44      A    C   
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22      A    C   
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32      A    C   
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56      A    C   
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24      A    N   
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25      A    C   
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17      A    N   
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74      A    N   
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49      A    C   
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66      A    O   
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03      A    N   
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77      A    C   
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90      A    C   
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91      A    C   
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77      A    C   
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30      A    C   
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62      A    C   
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79      A    C   
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41      A    C   
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73      A    C   
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07      A    O   
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95      A    N   
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90      A    C   
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16      A    C   
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79      A    C   
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70      A    C   
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00      A    C   
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31      A    C   
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80      A    O   
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01      A    N   
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24      A    C   
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24      A    C   
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43      A    C   
ATOM    840  CD1 ILE   106      23.603  67.212  12.165  1.00 20.23      A    C   
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52      A    C   
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58      A    C   
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61      A    O   
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23      A    N   
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45      A    C   
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44      A    C   
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93      A    C   
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99      A    C   
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41      A    C   
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32      A    C   
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50      A    C   
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35      A    C   
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80      A    C   
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67      A    O   
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44      A    N   
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55      A    C   
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60      A    C   
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49      A    C   
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81      A    C   
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08      A    C   
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48      A    C   
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72      A    C   
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79      A    C   
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19      A    C   
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68      A    O   
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03      A    N   
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13      A    C   
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75      A    C   
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93      A    C   
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78      A    O   
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40      A    O   
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28      A    C   
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96      A    O   
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54      A    N   
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57      A    C   
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39      A    C   
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68      A    C   
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45      A    O   
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92      A    O   
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52      A    C   
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49      A    O   
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29      A    N   
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31      A    C   
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94      A    C   
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78      A    O   
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27      A    N   
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81      A    C   
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78      A    C   
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13      A    C   
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13      A    C   
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46      A    C   
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51      A    C   
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35      A    O   
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49      A    C   
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42      A    C   
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38      A    C   
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60      A    O   
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28      A    N   
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48      A    C   
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94      A    C   
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88      A    C   
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02      A    O   
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78      A    N   
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51      A    C   
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32      A    C   
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59      A    O   
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14      A    C   
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10      A    O   
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88      A    N   
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97      A    C   
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23      A    C   
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98      A    C   
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69      A    C   
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06      A    C   
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17      A    C   
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32      A    O   
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57      A    C   
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00      A    C   
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83      A    C   
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57      A    O   
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72      A    N   
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52      A    C   
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69      A    C   
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00      A    C   
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31      A    C   
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61      A    C   
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30      A    O   
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89      A    N   
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98      A    C   
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31      A    C   
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79      A    O   
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61      A    C   
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21      A    C   
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79      A    O   
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01      A    N   
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28      A    C   
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49      A    C   
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99      A    C   
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55      A    C   
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72      A    O   
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57      A    N   
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10      A    C   
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56      A    O   
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49      A    N   
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07      A    C   
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47      A    C   
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78      A    O   
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32      A    C   
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85      A    O   
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18      A    N   
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24      A    C   
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92      A    C   
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83      A    C   
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58      A    C   
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17      A    O   
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52      A    O   
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67      A    C   
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73      A    O   
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86      A    N   
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32      A    C   
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01      A    C   
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02      A    C   
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23      A    C   
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86      A    C   
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96      A    C   
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86      A    O   
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66      A    N   
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39      A    C   
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52      A    C   
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82      A    C   
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09      A    C   
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95      A    C   
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50      A    C   
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88      A    O   
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16      A    C   
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29      A    C   
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68      A    C   
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71      A    O   
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87      A    N   
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79      A    C   
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35      A    C   
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92      A    C   
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87      A    C   
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69      A    C   
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01      A    O   
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52      A    N   
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49      A    C   
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21      A    C   
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81      A    C   
ATOM    990  CD1 ILE   124      28.803  68.039   3.091  1.00 25.49      A    C   
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25      A    C   
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92      A    C   
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39      A    O   
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68      A    N   
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92      A    C   
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66      A    C   
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72      A    S   
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26      A    C   
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07      A    O   
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14      A    N   
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10      A    C   
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44      A    C   
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05      A    C   
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38      A    C   
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14      A    N   
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93      A    C   
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80      A    N   
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37      A    N   
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61      A    C   
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58      A    O   
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84      A    N   
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55      A    C   
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73      A    C   
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71      A    C   
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69      A    C   
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20      A    C   
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13      A    O   
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93      A    N   
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11      A    C   
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11      A    C   
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78      A    C   
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21      A    C   
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11      A    C   
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10      A    C   
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50      A    O   
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83      A    N   
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96      A    C   
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23      A    C   
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25      A    C   
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12      A    C   
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73      A    C   
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80      A    N   
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59      A    C   
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18      A    O   
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19      A    N   
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79      A    C   
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69      A    C   
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99      A    C   
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29      A    C   
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81      A    C   
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82      A    N   
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63      A    C   
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95      A    O   
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22      A    N   
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50      A    C   
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06      A    C   
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82      A    O   
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04      A    C   
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62      A    C   
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97      A    O   
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04      A    N   
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89      A    C   
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11      A    C   
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44      A    C   
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59      A    C   
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49      A    N   
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16      A    C   
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91      A    C   
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11      A    C   
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36      A    C   
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08      A    C   
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78      A    C   
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73      A    C   
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50      A    O   
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66      A    N   
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34      A    C   
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61      A    C   
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64      A    C   
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80      A    C   
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45      A    O   
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15      A    O   
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32      A    C   
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86      A    O   
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24      A    N   
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25      A    C   
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54      A    C   
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08      A    C   
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87      A    O   
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84      A    O   
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00      A    C   
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24      A    O   
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19      A    N   
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87      A    C   
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06      A    C   
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49      A    C   
ATOM   1086  CD1 ILE   135      19.824  64.761   1.305  1.00 23.82      A    C   
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41      A    C   
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62      A    C   
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83      A    O   
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22      A    N   
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84      A    C   
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33      A    C   
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07      A    C   
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16      A    C   
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64      A    O   
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16      A    O   
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21      A    C   
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43      A    O   
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97      A    N   
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33      A    C   
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96      A    C   
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40      A    C   
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12      A    O   
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44      A    O   
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22      A    C   
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47      A    O   
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01      A    N   
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20      A    C   
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03      A    C   
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30      A    C   
ATOM   1111  CD1 ILE   138      16.726  60.053  -7.522  1.00 39.39      A    C   
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48      A    C   
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36      A    C   
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12      A    O   
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01      A    N   
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00      A    C   
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18      A    C   
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34      A    O   
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51      A    C   
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97      A    O   
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81      A    N   
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88      A    C   
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25      A    C   
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11      A    S   
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83      A    C   
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62      A    O   
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66      A    N   
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46      A    C   
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64      A    C   
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59      A    C   
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60      A    C   
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75      A    N   
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41      A    C   
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78      A    N   
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62      A    N   
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45      A    C   
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66      A    O   
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96      A    N   
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71      A    C   
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78      A    C   
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65      A    C   
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59      A    O   
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79      A    O   
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31      A    C   
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37      A    O   
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25      A    N   
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37      A    C   
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32      A    C   
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89      A    C   
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74      A    C   
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27      A    C   
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23      A    C   
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99      A    C   
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83      A    C   
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84      A    C   
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22      A    O   
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15      A    N   
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71      A    C   
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41      A    C   
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65      A    C   
ATOM   1161  CD1 ILE   144      16.433  64.307   5.309  1.00 32.59      A    C   
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38      A    C   
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23      A    C   
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99      A    O   
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54      A    N   
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22      A    C   
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83      A    C   
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06      A    C   
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55      A    C   
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48      A    O   
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38      A    O   
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02      A    C   
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51      A    O   
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22      A    N   
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31      A    C   
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99      A    C   
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93      A    C   
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96      A    C   
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56      A    O   
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44      A    O   
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30      A    C   
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67      A    O   
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95      A    N   
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26      A    C   
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62      A    C   
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42      A    C   
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78      A    C   
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51      A    C   
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34      A    C   
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94      A    O   
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26      A    C   
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68      A    C   
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42      A    C   
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71      A    O   
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89      A    N   
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22      A    C   
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51      A    C   
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81      A    C   
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91      A    C   
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19      A    C   
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11      A    O   
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28      A    N   
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60      A    C   
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71      A    C   
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07      A    O   
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99      A    C   
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95      A    C   
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70      A    O   
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59      A    N   
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60      A    C   
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85      A    C   
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59      A    C   
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80      A    O   
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51      A    N   
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02      A    C   
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25      A    C   
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64      A    C   
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89      A    C   
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64      A    C   
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96      A    C   
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53      A    O   
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39      A    C   
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63      A    C   
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26      A    C   
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36      A    O   
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02      A    N   
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87      A    C   
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97      A    C   
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14      A    C   
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10      A    C   
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49      A    C   
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95      A    O   
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00           N   
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00           C   
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00           C   
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00           C   
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11      A    O   
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24      A    N   
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67      A    C   
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22      A    C   
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95      A    C   
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24      A    C   
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56      A    N   
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65      A    C   
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10      A    N   
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91      A    N   
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48      A    C   
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60      A    O   
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81      A    N   
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57      A    C   
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30      A    C   
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91      A    C   
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74      A    C   
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68      A    C   
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45      A    O   
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58      A    N   
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91      A    C   
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72      A    C   
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80      A    C   
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27      A    S   
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73      A    C   
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88      A    C   
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77      A    O   
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68      A    N   
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94      A    C   
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31      A    C   
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02      A    C   
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19      A    C   
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70      A    C   
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12      A    O   
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86      A    N   
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34      A    C   
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76      A    C   
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71      A    C   
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52      A    C   
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91      A    C   
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36      A    C   
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38      A    O   
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39      A    N   
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82      A    C   
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48      A    C   
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98      A    C   
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19      A    C   
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71      A    C   
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84      A    C   
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14      A    O   
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05      A    N   
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85      A    C   
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53      A    C   
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66      A    C   
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77      A    C   
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29      A    C   
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32      A    N   
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60      A    C   
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59      A    O   
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08      A    N   
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57      A    C   
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74      A    C   
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20      A    O   
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82      A    C   
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39      A    O   
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79      A    N   
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54      A    C   
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96      A    C   
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12      A    O   
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51      A    N   
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64      A    C   
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76      A    C   
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65      A    C   
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28      A    C   
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12      A    O   
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38      A    N   
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12      A    C   
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39      A    O   
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12      A    N   
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66      A    C   
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46      A    C   
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68      A    C   
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83      A    C   
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29      A    C   
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79      A    C   
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92      A    O   
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19      A    N   
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22      A    C   
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55      A    C   
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94      A    C   
ATOM   1327  CD1 ILE   165       6.209  52.315  15.886  1.00 31.23      A    C   
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32      A    C   
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55      A    C   
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72      A    O   
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69      A    N   
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62      A    C   
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02      A    C   
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39      A    C   
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70      A    C   
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81      A    C   
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59      A    N   
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66      A    C   
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59      A    O   
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49      A    N   
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44      A    C   
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65      A    C   
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70      A    O   
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83      A    C   
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50      A    C   
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37      A    O   
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23      A    N   
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42      A    C   
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75      A    C   
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02      A    C   
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37      A    C   
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81      A    O   
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83      A    O   
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47      A    C   
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48      A    O   
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67      A    N   
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31      A    C   
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92      A    C   
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33      A    C   
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61      A    C   
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22      A    N   
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95      A    C   
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43      A    C   
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18      A    C   
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32      A    C   
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82      A    C   
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67      A    C   
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81      A    C   
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65      A    O   
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53      A    N   
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22      A    C   
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81      A    C   
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48      A    C   
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91      A    C   
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38      A    O   
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53      A    O   
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91      A    C   
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93      A    O   
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29      A    N   
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97      A    C   
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96      A    C   
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58      A    O   
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03      A    N   
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14      A    C   
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39      A    C   
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72      A    O   
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96      A    C   
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58      A    C   
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06      A    O   
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62      A    N   
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25      A    C   
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07      A    C   
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76      A    C   
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53      A    C   
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95      A    N   
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13      A    C   
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72      A    C   
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76      A    C   
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92      A    C   
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47      A    C   
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94      A    C   
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59      A    C   
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02      A    O   
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27      A    N   
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02      A    C   
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07      A    C   
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96      A    C   
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25      A    C   
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15      A    N   
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78      A    C   
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29      A    C   
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76      A    C   
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16      A    C   
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08      A    C   
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93      A    C   
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03      A    C   
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12      A    O   
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58      A    N   
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08      A    C   
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32      A    C   
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83      A    C   
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01      A    C   
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96      A    C   
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78      A    N   
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65      A    C   
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82      A    O   
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57      A    N   
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13      A    C   
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30      A    C   
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50      A    O   
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23      A    C   
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69      A    O   
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37      A    N   
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78      A    C   
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90      A    C   
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76      A    C   
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41      A    C   
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84      A    N   
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54      A    C   
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82      A    N   
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67      A    N   
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14      A    C   
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15      A    O   
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17      A    N   
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26      A    C   
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41      A    C   
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74      A    C   
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77      A    C   
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35      A    C   
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94      A    O   
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10      A    N   
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30      A    C   
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27      A    C   
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60      A    C   
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02      A    C   
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04      A    O   
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81      A    O   
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78      A    C   
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10      A    O   
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01      A    N   
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48      A    C   
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67      A    C   
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28      A    C   
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92      A    C   
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88      A    O   
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40      A    O   
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39      A    C   
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18      A    O   
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81      A    N   
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39      A    C   
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32      A    C   
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58      A    C   
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76      A    C   
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51      A    C   
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24      A    O   
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81      A    N   
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85      A    C   
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36      A    C   
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04      A    C   
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46      A    O   
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63      A    O   
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34      A    C   
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28      A    O   
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60      A    N   
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82      A    C   
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12      A    C   
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15      A    O   
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45      A    N   
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55      A    C   
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99      A    C   
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01      A    O   
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84      A    C   
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91      A    O   
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02      A    N   
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76      A    C   
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01      A    C   
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62      A    C   
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91      A    C   
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03      A    C   
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69      A    C   
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74      A    O   
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00      A    N   
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67      A    C   
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49      A    C   
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21      A    C   
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37      A    C   
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33      A    C   
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21      A    O   
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88      A    N   
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64      A    C   
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81      A    C   
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28      A    C   
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49      A    C   
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90      A    N   
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02      A    C   
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12      A    N   
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09      A    N   
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66      A    C   
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30      A    O   
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33      A    N   
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61      A    C   
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16      A    C   
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49      A    C   
ATOM   1524  CD1 ILE   188      10.070  52.171  17.195  1.00 22.12      A    C   
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97      A    C   
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24      A    C   
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98      A    O   
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53      A    N   
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66      A    C   
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05      A    C   
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76      A    C   
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44      A    C   
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56      A    C   
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30      A    C   
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61      A    O   
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27      A    N   
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14      A    C   
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24      A    C   
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90      A    C   
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65      A    C   
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09      A    C   
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22      A    C   
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07      A    C   
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13      A    C   
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23      A    C   
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45      A    O   
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88      A    N   
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39      A    C   
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37      A    C   
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18      A    C   
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11      A    C   
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76      A    C   
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98      A    C   
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06      A    O   
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15      A    N   
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12      A    C   
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35      A    C   
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17      A    C   
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49      A    O   
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48      A    O   
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20      A    C   
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84      A    O   
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46      A    N   
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90      A    C   
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22      A    C   
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81      A    C   
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17      A    O   
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73      A    O   
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40      A    C   
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81      A    O   
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79      A    N   
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00      A    C   
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11      A    C   
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34      A    C   
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22      A    C   
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08      A    C   
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25      A    N   
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17      A    C   
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60      A    O   
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73      A    N   
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18      A    C   
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44      A    C   
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65      A    C   
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06      A    C   
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18      A    N   
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07      A    C   
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04      A    N   
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77      A    N   
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81      A    C   
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67      A    O   
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17      A    N   
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89      A    C   
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26      A    C   
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76      A    S   
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18      A    C   
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50      A    O   
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36      A    N   
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74      A    C   
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30      A    C   
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31      A    C   
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51      A    C   
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61      A    O   
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47      A    O   
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94      A    C   
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12      A    O   
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46      A    N   
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05      A    C   
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37      A    C   
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69      A    C   
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54      A    C   
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80      A    N   
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60      A    C   
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83      A    C   
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73      A    C   
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65      A    C   
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44      A    C   
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23      A    C   
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26      A    C   
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58      A    O   
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43      A    N   
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27      A    C   
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13      A    C   
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58      A    C   
ATOM   1624  CD1 ILE   199      12.999  52.559  12.729  1.00 20.55      A    C   
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51      A    C   
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19      A    C   
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92      A    O   
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19      A    N   
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38      A    C   
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91      A    C   
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47      A    C   
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20      A    C   
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57      A    C   
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44      A    C   
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50      A    O   
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12      A    C   
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97      A    C   
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26      A    C   
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54      A    O   
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69      A    N   
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36      A    C   
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88      A    C   
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58      A    C   
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28      A    C   
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92      A    N   
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45      A    C   
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56      A    N   
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01      A    N   
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86      A    C   
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26      A    O   
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88      A    N   
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49      A    C   
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20      A    C   
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50      A    O   
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52      A    N   
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94      A    C   
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80      A    C   
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15      A    O   
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74      A    C   
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11      A    O   
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13      A    N   
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63      A    C   
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86      A    C   
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83      A    O   
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24      A    C   
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93      A    C   
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95      A    O   
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76      A    N   
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56      A    C   
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52      A    C   
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50      A    C   
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97      A    C   
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21      A    N   
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11      A    C   
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43      A    N   
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70      A    N   
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63      A    C   
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00      A    O   
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37      A    N   
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66      A    C   
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91      A    C   
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37      A    C   
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02      A    C   
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72      A    C   
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09      A    C   
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64      A    O   
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26      A    N   
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27      A    C   
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33      A    C   
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61      A    C   
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10      A    C   
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09      A    O   
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83      A    O   
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60      A    C   
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76      A    O   
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26      A    N   
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94      A    C   
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04      A    C   
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06      A    C   
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74      A    C   
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96      A    C   
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24      A    O   
END
