
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 ( 1611),  selected  100 , name 2efi_A
# Molecule2: number of CA atoms  208 ( 1702),  selected  208 , name T0504.pdb
# PARAMETERS: 2efi_A.T0504.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    K    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    D    13_A      E       1          6.512
LGA    P    14_A      N       2           -
LGA    K    15_A      -       -           -
LGA    P    16_A      L       3          6.130
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    K    17_A      Q       6          2.725
LGA    -       -      G       7           -
LGA    -       -      D       8           -
LGA    F    18_A      L       9          1.610
LGA    Q    19_A      I      10          1.347
LGA    E    20_A      V      11          1.348
LGA    G    21_A      S      12          1.019
LGA    E    22_A      M      13          0.371
LGA    R    23_A      R      14          0.869
LGA    V    24_A      I      15          0.939
LGA    L    25_A      L      16          1.150
LGA    C    26_A      G      17          0.894
LGA    F    27_A      K      18          1.411
LGA    H    28_A      K      19          1.673
LGA    -       -      R      20           -
LGA    G    29_A      T      21          4.167
LGA    P    30_A      K      22          3.188
LGA    L    31_A      T      23          1.920
LGA    L    32_A      W      24          1.300
LGA    Y    33_A      H      25          0.923
LGA    E    34_A      K      26          0.873
LGA    A    35_A      G      27          1.021
LGA    K    36_A      T      28          1.091
LGA    C    37_A      L      29          0.202
LGA    V    38_A      I      30          1.112
LGA    K    39_A      A      31          1.292
LGA    V    40_A      I      32          1.446
LGA    A    41_A      Q      33          1.387
LGA    I    42_A      T      34          1.364
LGA    K    43_A      V      35          1.660
LGA    D    44_A      G      36           #
LGA    K    45_A      P      37          2.971
LGA    Q    46_A      G      38          1.072
LGA    V    47_A      K      39          1.139
LGA    K    48_A      K      40          1.027
LGA    Y    49_A      Y      41          1.532
LGA    F    50_A      K      42          1.186
LGA    I    51_A      V      43          0.398
LGA    H    52_A      K      44          0.815
LGA    Y    53_A      F      45          1.044
LGA    S    54_A      D      46          0.871
LGA    G    55_A      N      47          2.460
LGA    W    56_A      K      48          3.421
LGA    N    57_A      -       -           -
LGA    K    58_A      -       -           -
LGA    N    59_A      -       -           -
LGA    W    60_A      G      49          3.269
LGA    D    61_A      K      50          1.482
LGA    E    62_A      S      51          1.212
LGA    W    63_A      L      52          0.505
LGA    V    64_A      L      53          0.748
LGA    P    65_A      S      54          1.697
LGA    E    66_A      G      55          1.791
LGA    S    67_A      N      56          1.894
LGA    R    68_A      H      57          1.363
LGA    V    69_A      I      58          1.626
LGA    L    70_A      A      59          1.848
LGA    K    71_A      Y      60          2.489
LGA    Y    72_A      D      61          2.206
LGA    V    73_A      Y      62          2.542
LGA    D    74_A      H      63          0.548
LGA    T    75_A      P      64          3.290
LGA    N    76_A      P      65           -
LGA    L    77_A      A      66           -
LGA    Q    78_A      D      67           -
LGA    -       -      K      68           -
LGA    -       -      L      69           -
LGA    -       -      Y      70           -
LGA    -       -      V      71           -
LGA    -       -      G      72           -
LGA    -       -      S      73           -
LGA    -       -      R      74           -
LGA    K    79_A      V      75          4.920
LGA    Q    80_A      V      76          3.798
LGA    R    81_A      A      77          4.231
LGA    E    82_A      K      78          1.504
LGA    L    83_A      Y      79          2.872
LGA    Q    84_A      -       -           -
LGA    K    85_A      -       -           -
LGA    A    86_A      K      80          2.167
LGA    N    87_A      D      81           #
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    Q    88_A      Q      84          3.108
LGA    E    89_A      V      85           #
LGA    Q    90_A      -       -           -
LGA    Y    91_A      W      86          5.390
LGA    A    92_A      L      87           -
LGA    E    93_A      Y      88           -
LGA    G    94_A      A      89           -
LGA    K    95_A      G      90           -
LGA    M    96_A      I      91           -
LGA    R    97_A      V      92           -
LGA    G    98_A      A      93           -
LGA    A    99_A      E      94           -
LGA    A   100_A      T      95           -
LGA    -       -      P      96           -
LGA    -       -      N      97           -
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    -       -      L     102           -
LGA    -       -      R     103           -
LGA    -       -      F     104           -
LGA    -       -      L     105           -
LGA    -       -      I     106           -
LGA    -       -      F     107           -
LGA    -       -      F     108           -
LGA    -       -      D     109           -
LGA    -       -      D     110           -
LGA    -       -      G     111           -
LGA    -       -      Y     112           -
LGA    -       -      A     113           -
LGA    -       -      S     114           -
LGA    -       -      Y     115           -
LGA    -       -      V     116           -
LGA    -       -      T     117           -
LGA    -       -      Q     118           -
LGA    -       -      S     119           -
LGA    -       -      E     120           -
LGA    -       -      L     121           -
LGA    -       -      Y     122           -
LGA    -       -      P     123           -
LGA    -       -      I     124           -
LGA    -       -      C     125           -
LGA    -       -      R     126           -
LGA    -       -      P     127           -
LGA    -       -      L     128           -
LGA    -       -      K     129           -
LGA    -       -      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    -       -      E     133           -
LGA    -       -      D     134           -
LGA    -       -      I     135           -
LGA    -       -      E     136           -
LGA    -       -      D     137           -
LGA    -       -      I     138           -
LGA    -       -      S     139           -
LGA    -       -      C     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      F     143           -
LGA    -       -      I     144           -
LGA    -       -      E     145           -
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -
LGA    -       -      M     156           -
LGA    -       -      V     157           -
LGA    -       -      L     158           -
LGA    -       -      L     159           -
LGA    -       -      K     160           -
LGA    -       -      S     161           -
LGA    -       -      G     162           -
LGA    -       -      Q     163           -
LGA    -       -      L     164           -
LGA    -       -      I     165           -
LGA    -       -      K     166           -
LGA    -       -      T     167           -
LGA    -       -      E     168           -
LGA    -       -      W     169           -
LGA    -       -      E     170           -
LGA    -       -      G     171           -
LGA    -       -      T     172           -
LGA    -       -      W     173           -
LGA    -       -      W     174           -
LGA    -       -      K     175           -
LGA    -       -      S     176           -
LGA    -       -      R     177           -
LGA    -       -      V     178           -
LGA    -       -      E     179           -
LGA    -       -      E     180           -
LGA    -       -      V     181           -
LGA    -       -      D     182           -
LGA    -       -      G     183           -
LGA    -       -      S     184           -
LGA    -       -      L     185           -
LGA    -       -      V     186           -
LGA    -       -      R     187           -
LGA    -       -      I     188           -
LGA    -       -      L     189           -
LGA    -       -      F     190           -
LGA    -       -      L     191           -
LGA    -       -      D     192           -
LGA    -       -      D     193           -
LGA    -       -      K     194           -
LGA    -       -      R     195           -
LGA    -       -      C     196           -
LGA    -       -      E     197           -
LGA    -       -      W     198           -
LGA    -       -      I     199           -
LGA    -       -      Y     200           -
LGA    -       -      R     201           -
LGA    -       -      G     202           -
LGA    -       -      S     203           -
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    -       -      L     206           -
LGA    -       -      E     207           -
LGA    -       -      P     208           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100  208    5.0     65    2.35     7.69     27.418     2.649

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.115617 * X  +   0.001984 * Y  +  -0.993292 * Z  +  39.136734
  Y_new =   0.857418 * X  +   0.505048 * Y  +  -0.098793 * Z  +  66.786530
  Z_new =   0.501464 * X  +  -0.863089 * Y  +  -0.060094 * Z  +  -0.386715 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.640311    1.501282  [ DEG:   -93.9829     86.0171 ]
  Theta =  -0.525291   -2.616302  [ DEG:   -30.0969   -149.9031 ]
  Phi   =   1.704831   -1.436761  [ DEG:    97.6796    -82.3204 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2efi_A                                        
REMARK     2: T0504.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2efi_A.T0504.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100  208   5.0   65   2.35    7.69  27.418
REMARK  ---------------------------------------------------------- 
MOLECULE 2efi_A
HEADER    TRANSCRIPTION                           22-FEB-07   2EFI              
TITLE     SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF MORTALITY FACTOR           
TITLE    2 4-LIKE PROTEIN 1 FROM HUMAN                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORTALITY FACTOR 4-LIKE PROTEIN 1;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 SYNONYM: MORF-RELATED GENE 15 PROTEIN, TRANSCRIPTION                 
COMPND   6 FACTOR-LIKE PROTEIN MRG15, MSL3-1 PROTEIN;                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MORF4L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060522-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    CHROMO DOMAIN, MORTALITY FACTOR 4-LIKE PROTEIN 1,                     
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, TRANSCRIPTION                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,                   
AUTHOR   2 S.WATANABE,T.KIGAWA,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   28-AUG-07 2EFI    0                                                
JRNL        AUTH   H.LI,M.SATO,N.TOCHIO,T.TOMIZAWA,S.KOSHIBA,T.HARADA,          
JRNL        AUTH 2 S.WATANABE,T.KIGAWA,S.YOKOYAMA                               
JRNL        TITL   SOLUTION STRUCTURE OF THE CHROMO DOMAIN OF                   
JRNL        TITL 2 MORTALITY FACTOR 4-LIKE PROTEIN 1 FROM HUMAN                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EFI A    8   100  UNP    Q9UBU8   MO4L1_HUMAN      1     93             
SEQRES   1 A  100  GLY SER SER GLY SER SER GLY MET ALA PRO LYS GLN ASP          
SEQRES   2 A  100  PRO LYS PRO LYS PHE GLN GLU GLY GLU ARG VAL LEU CYS          
SEQRES   3 A  100  PHE HIS GLY PRO LEU LEU TYR GLU ALA LYS CYS VAL LYS          
SEQRES   4 A  100  VAL ALA ILE LYS ASP LYS GLN VAL LYS TYR PHE ILE HIS          
SEQRES   5 A  100  TYR SER GLY TRP ASN LYS ASN TRP ASP GLU TRP VAL PRO          
SEQRES   6 A  100  GLU SER ARG VAL LEU LYS TYR VAL ASP THR ASN LEU GLN          
SEQRES   7 A  100  LYS GLN ARG GLU LEU GLN LYS ALA ASN GLN GLU GLN TYR          
SEQRES   8 A  100  ALA GLU GLY LYS MET ARG GLY ALA ALA                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      44.601  86.782   4.487  1.00  0.00           N  
ATOM      2  CA  GLY A   1      44.319  88.007   3.762  1.00  0.00           C  
ATOM      3  C   GLY A   1      43.196  88.808   4.393  1.00  0.00           C  
ATOM      4  O   GLY A   1      42.037  88.394   4.363  1.00  0.00           O  
ATOM      5  H1  GLY A   1      44.303  86.684   5.415  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      45.211  88.614   3.740  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      44.041  87.756   2.749  1.00  0.00           H  
ATOM      8  N   SER A   2      43.541  89.956   4.967  1.00  0.00           N  
ATOM      9  CA  SER A   2      42.553  90.814   5.612  1.00  0.00           C  
ATOM     10  C   SER A   2      42.558  92.208   4.993  1.00  0.00           C  
ATOM     11  O   SER A   2      43.539  92.943   5.098  1.00  0.00           O  
ATOM     12  CB  SER A   2      42.835  90.910   7.113  1.00  0.00           C  
ATOM     13  OG  SER A   2      42.221  89.843   7.816  1.00  0.00           O  
ATOM     14  H   SER A   2      44.481  90.231   4.957  1.00  0.00           H  
ATOM     15  HA  SER A   2      41.581  90.370   5.464  1.00  0.00           H  
ATOM     16  HB2 SER A   2      43.900  90.869   7.280  1.00  0.00           H  
ATOM     17  HB3 SER A   2      42.446  91.845   7.490  1.00  0.00           H  
ATOM     18  HG  SER A   2      42.638  89.014   7.569  1.00  0.00           H  
ATOM     19  N   SER A   3      41.452  92.564   4.345  1.00  0.00           N  
ATOM     20  CA  SER A   3      41.328  93.868   3.704  1.00  0.00           C  
ATOM     21  C   SER A   3      39.916  94.077   3.166  1.00  0.00           C  
ATOM     22  O   SER A   3      39.081  93.175   3.216  1.00  0.00           O  
ATOM     23  CB  SER A   3      42.344  94.000   2.567  1.00  0.00           C  
ATOM     24  OG  SER A   3      42.691  95.357   2.349  1.00  0.00           O  
ATOM     25  H   SER A   3      40.704  91.934   4.295  1.00  0.00           H  
ATOM     26  HA  SER A   3      41.533  94.624   4.448  1.00  0.00           H  
ATOM     27  HB2 SER A   3      43.237  93.450   2.821  1.00  0.00           H  
ATOM     28  HB3 SER A   3      41.919  93.599   1.660  1.00  0.00           H  
ATOM     29  HG  SER A   3      43.368  95.409   1.671  1.00  0.00           H  
ATOM     30  N   GLY A   4      39.657  95.275   2.651  1.00  0.00           N  
ATOM     31  CA  GLY A   4      38.346  95.582   2.111  1.00  0.00           C  
ATOM     32  C   GLY A   4      38.004  94.734   0.901  1.00  0.00           C  
ATOM     33  O   GLY A   4      38.887  94.341   0.141  1.00  0.00           O  
ATOM     34  H   GLY A   4      40.362  95.956   2.638  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      37.604  95.413   2.877  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      38.322  96.623   1.824  1.00  0.00           H  
ATOM     37  N   SER A   5      36.717  94.451   0.724  1.00  0.00           N  
ATOM     38  CA  SER A   5      36.260  93.639  -0.398  1.00  0.00           C  
ATOM     39  C   SER A   5      35.554  94.502  -1.439  1.00  0.00           C  
ATOM     40  O   SER A   5      34.328  94.606  -1.446  1.00  0.00           O  
ATOM     41  CB  SER A   5      35.319  92.536   0.092  1.00  0.00           C  
ATOM     42  OG  SER A   5      36.048  91.430   0.593  1.00  0.00           O  
ATOM     43  H   SER A   5      36.059  94.794   1.366  1.00  0.00           H  
ATOM     44  HA  SER A   5      37.128  93.185  -0.852  1.00  0.00           H  
ATOM     45  HB2 SER A   5      34.692  92.927   0.880  1.00  0.00           H  
ATOM     46  HB3 SER A   5      34.700  92.204  -0.729  1.00  0.00           H  
ATOM     47  HG  SER A   5      36.903  91.385   0.158  1.00  0.00           H  
ATOM     48  N   SER A   6      36.337  95.117  -2.319  1.00  0.00           N  
ATOM     49  CA  SER A   6      35.789  95.973  -3.364  1.00  0.00           C  
ATOM     50  C   SER A   6      36.600  95.849  -4.650  1.00  0.00           C  
ATOM     51  O   SER A   6      37.814  96.047  -4.653  1.00  0.00           O  
ATOM     52  CB  SER A   6      35.769  97.431  -2.900  1.00  0.00           C  
ATOM     53  OG  SER A   6      34.633  97.694  -2.095  1.00  0.00           O  
ATOM     54  H   SER A   6      37.309  94.993  -2.262  1.00  0.00           H  
ATOM     55  HA  SER A   6      34.776  95.652  -3.558  1.00  0.00           H  
ATOM     56  HB2 SER A   6      36.658  97.635  -2.324  1.00  0.00           H  
ATOM     57  HB3 SER A   6      35.741  98.080  -3.763  1.00  0.00           H  
ATOM     58  HG  SER A   6      34.903  97.780  -1.177  1.00  0.00           H  
ATOM     59  N   GLY A   7      35.918  95.518  -5.743  1.00  0.00           N  
ATOM     60  CA  GLY A   7      36.589  95.373  -7.021  1.00  0.00           C  
ATOM     61  C   GLY A   7      35.785  94.549  -8.007  1.00  0.00           C  
ATOM     62  O   GLY A   7      35.489  93.382  -7.755  1.00  0.00           O  
ATOM     63  H   GLY A   7      34.950  95.372  -5.681  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      36.759  96.352  -7.440  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      37.543  94.891  -6.860  1.00  0.00           H  
ATOM     66  N   MET A   8      35.431  95.158  -9.134  1.00  0.00           N  
ATOM     67  CA  MET A   8      34.656  94.473 -10.162  1.00  0.00           C  
ATOM     68  C   MET A   8      35.526  93.479 -10.927  1.00  0.00           C  
ATOM     69  O   MET A   8      36.749  93.603 -10.951  1.00  0.00           O  
ATOM     70  CB  MET A   8      34.046  95.487 -11.132  1.00  0.00           C  
ATOM     71  CG  MET A   8      32.831  96.209 -10.571  1.00  0.00           C  
ATOM     72  SD  MET A   8      31.974  97.195 -11.813  1.00  0.00           S  
ATOM     73  CE  MET A   8      32.647  98.821 -11.478  1.00  0.00           C  
ATOM     74  H   MET A   8      35.697  96.090  -9.278  1.00  0.00           H  
ATOM     75  HA  MET A   8      33.859  93.933  -9.671  1.00  0.00           H  
ATOM     76  HB2 MET A   8      34.793  96.225 -11.379  1.00  0.00           H  
ATOM     77  HB3 MET A   8      33.747  94.972 -12.032  1.00  0.00           H  
ATOM     78  HG2 MET A   8      32.143  95.475 -10.178  1.00  0.00           H  
ATOM     79  HG3 MET A   8      33.154  96.861  -9.773  1.00  0.00           H  
ATOM     80  HE1 MET A   8      33.612  98.720 -11.001  1.00  0.00           H  
ATOM     81  HE2 MET A   8      32.760  99.362 -12.406  1.00  0.00           H  
ATOM     82  HE3 MET A   8      31.977  99.360 -10.825  1.00  0.00           H  
ATOM     83  N   ALA A   9      34.884  92.496 -11.550  1.00  0.00           N  
ATOM     84  CA  ALA A   9      35.599  91.483 -12.317  1.00  0.00           C  
ATOM     85  C   ALA A   9      34.924  91.233 -13.661  1.00  0.00           C  
ATOM     86  O   ALA A   9      33.703  91.324 -13.796  1.00  0.00           O  
ATOM     87  CB  ALA A   9      35.694  90.190 -11.523  1.00  0.00           C  
ATOM     88  H   ALA A   9      33.908  92.451 -11.493  1.00  0.00           H  
ATOM     89  HA  ALA A   9      36.604  91.844 -12.491  1.00  0.00           H  
ATOM     90  HB1 ALA A   9      36.550  90.231 -10.866  1.00  0.00           H  
ATOM     91  HB2 ALA A   9      34.795  90.061 -10.936  1.00  0.00           H  
ATOM     92  HB3 ALA A   9      35.802  89.357 -12.202  1.00  0.00           H  
ATOM     93  N   PRO A  10      35.734  90.914 -14.680  1.00  0.00           N  
ATOM     94  CA  PRO A  10      35.236  90.645 -16.033  1.00  0.00           C  
ATOM     95  C   PRO A  10      34.456  89.337 -16.114  1.00  0.00           C  
ATOM     96  O   PRO A  10      34.157  88.716 -15.093  1.00  0.00           O  
ATOM     97  CB  PRO A  10      36.513  90.557 -16.870  1.00  0.00           C  
ATOM     98  CG  PRO A  10      37.574  90.156 -15.904  1.00  0.00           C  
ATOM     99  CD  PRO A  10      37.198  90.788 -14.592  1.00  0.00           C  
ATOM    100  HA  PRO A  10      34.620  91.454 -16.396  1.00  0.00           H  
ATOM    101  HB2 PRO A  10      36.387  89.818 -17.649  1.00  0.00           H  
ATOM    102  HB3 PRO A  10      36.725  91.520 -17.312  1.00  0.00           H  
ATOM    103  HG2 PRO A  10      37.598  89.081 -15.809  1.00  0.00           H  
ATOM    104  HG3 PRO A  10      38.533  90.526 -16.237  1.00  0.00           H  
ATOM    105  HD2 PRO A  10      37.482  90.148 -13.770  1.00  0.00           H  
ATOM    106  HD3 PRO A  10      37.663  91.759 -14.494  1.00  0.00           H  
ATOM    107  N   LYS A  11      34.127  88.924 -17.333  1.00  0.00           N  
ATOM    108  CA  LYS A  11      33.382  87.689 -17.548  1.00  0.00           C  
ATOM    109  C   LYS A  11      34.329  86.507 -17.727  1.00  0.00           C  
ATOM    110  O   LYS A  11      34.229  85.763 -18.703  1.00  0.00           O  
ATOM    111  CB  LYS A  11      32.478  87.822 -18.775  1.00  0.00           C  
ATOM    112  CG  LYS A  11      31.346  88.820 -18.592  1.00  0.00           C  
ATOM    113  CD  LYS A  11      31.799  90.238 -18.891  1.00  0.00           C  
ATOM    114  CE  LYS A  11      30.781  91.262 -18.411  1.00  0.00           C  
ATOM    115  NZ  LYS A  11      31.292  92.654 -18.539  1.00  0.00           N  
ATOM    116  H   LYS A  11      34.394  89.463 -18.108  1.00  0.00           H  
ATOM    117  HA  LYS A  11      32.769  87.515 -16.677  1.00  0.00           H  
ATOM    118  HB2 LYS A  11      33.076  88.140 -19.616  1.00  0.00           H  
ATOM    119  HB3 LYS A  11      32.046  86.856 -18.996  1.00  0.00           H  
ATOM    120  HG2 LYS A  11      30.539  88.561 -19.261  1.00  0.00           H  
ATOM    121  HG3 LYS A  11      30.998  88.771 -17.569  1.00  0.00           H  
ATOM    122  HD2 LYS A  11      32.739  90.420 -18.393  1.00  0.00           H  
ATOM    123  HD3 LYS A  11      31.929  90.347 -19.960  1.00  0.00           H  
ATOM    124  HE2 LYS A  11      29.883  91.161 -19.000  1.00  0.00           H  
ATOM    125  HE3 LYS A  11      30.555  91.064 -17.374  1.00  0.00           H  
ATOM    126  HZ1 LYS A  11      31.198  92.980 -19.522  1.00  0.00           H  
ATOM    127  HZ2 LYS A  11      32.295  92.693 -18.267  1.00  0.00           H  
ATOM    128  HZ3 LYS A  11      30.752  93.291 -17.920  1.00  0.00           H  
ATOM    129  N   GLN A  12      35.246  86.340 -16.780  1.00  0.00           N  
ATOM    130  CA  GLN A  12      36.210  85.247 -16.835  1.00  0.00           C  
ATOM    131  C   GLN A  12      35.868  84.169 -15.812  1.00  0.00           C  
ATOM    132  O   GLN A  12      35.064  84.390 -14.907  1.00  0.00           O  
ATOM    133  CB  GLN A  12      37.624  85.774 -16.585  1.00  0.00           C  
ATOM    134  CG  GLN A  12      38.712  84.747 -16.856  1.00  0.00           C  
ATOM    135  CD  GLN A  12      40.080  85.378 -17.024  1.00  0.00           C  
ATOM    136  OE1 GLN A  12      40.994  85.128 -16.237  1.00  0.00           O  
ATOM    137  NE2 GLN A  12      40.231  86.200 -18.056  1.00  0.00           N  
ATOM    138  H   GLN A  12      35.276  86.967 -16.028  1.00  0.00           H  
ATOM    139  HA  GLN A  12      36.166  84.815 -17.823  1.00  0.00           H  
ATOM    140  HB2 GLN A  12      37.797  86.626 -17.225  1.00  0.00           H  
ATOM    141  HB3 GLN A  12      37.703  86.085 -15.554  1.00  0.00           H  
ATOM    142  HG2 GLN A  12      38.752  84.055 -16.027  1.00  0.00           H  
ATOM    143  HG3 GLN A  12      38.465  84.210 -17.760  1.00  0.00           H  
ATOM    144 HE21 GLN A  12      39.459  86.353 -18.642  1.00  0.00           H  
ATOM    145 HE22 GLN A  12      41.104  86.622 -18.188  1.00  0.00           H  
ATOM    146  N   ASP A  13      36.485  83.001 -15.962  1.00  0.00           N  
ATOM    147  CA  ASP A  13      36.247  81.888 -15.051  1.00  0.00           C  
ATOM    148  C   ASP A  13      36.115  82.381 -13.613  1.00  0.00           C  
ATOM    149  O   ASP A  13      36.716  83.380 -13.216  1.00  0.00           O  
ATOM    150  CB  ASP A  13      37.382  80.868 -15.151  1.00  0.00           C  
ATOM    151  CG  ASP A  13      38.711  81.512 -15.493  1.00  0.00           C  
ATOM    152  OD1 ASP A  13      39.216  82.303 -14.669  1.00  0.00           O  
ATOM    153  OD2 ASP A  13      39.245  81.226 -16.585  1.00  0.00           O  
ATOM    154  H   ASP A  13      37.116  82.887 -16.703  1.00  0.00           H  
ATOM    155  HA  ASP A  13      35.322  81.413 -15.342  1.00  0.00           H  
ATOM    156  HB2 ASP A  13      37.483  80.358 -14.203  1.00  0.00           H  
ATOM    157  HB3 ASP A  13      37.143  80.148 -15.919  1.00  0.00           H  
ATOM    158  N   PRO A  14      35.308  81.668 -12.814  1.00  0.00           N  
ATOM    159  CA  PRO A  14      35.076  82.015 -11.409  1.00  0.00           C  
ATOM    160  C   PRO A  14      36.308  81.774 -10.542  1.00  0.00           C  
ATOM    161  O   PRO A  14      37.228  81.057 -10.938  1.00  0.00           O  
ATOM    162  CB  PRO A  14      33.940  81.076 -10.994  1.00  0.00           C  
ATOM    163  CG  PRO A  14      34.053  79.913 -11.919  1.00  0.00           C  
ATOM    164  CD  PRO A  14      34.558  80.467 -13.222  1.00  0.00           C  
ATOM    165  HA  PRO A  14      34.756  83.041 -11.301  1.00  0.00           H  
ATOM    166  HB2 PRO A  14      34.074  80.778  -9.965  1.00  0.00           H  
ATOM    167  HB3 PRO A  14      32.992  81.581 -11.109  1.00  0.00           H  
ATOM    168  HG2 PRO A  14      34.752  79.195 -11.520  1.00  0.00           H  
ATOM    169  HG3 PRO A  14      33.082  79.459 -12.056  1.00  0.00           H  
ATOM    170  HD2 PRO A  14      35.207  79.755 -13.709  1.00  0.00           H  
ATOM    171  HD3 PRO A  14      33.732  80.729 -13.866  1.00  0.00           H  
ATOM    172  N   LYS A  15      36.320  82.377  -9.359  1.00  0.00           N  
ATOM    173  CA  LYS A  15      37.438  82.228  -8.435  1.00  0.00           C  
ATOM    174  C   LYS A  15      37.101  81.230  -7.332  1.00  0.00           C  
ATOM    175  O   LYS A  15      35.995  81.212  -6.794  1.00  0.00           O  
ATOM    176  CB  LYS A  15      37.802  83.581  -7.820  1.00  0.00           C  
ATOM    177  CG  LYS A  15      39.226  83.647  -7.293  1.00  0.00           C  
ATOM    178  CD  LYS A  15      39.555  85.025  -6.746  1.00  0.00           C  
ATOM    179  CE  LYS A  15      40.995  85.104  -6.261  1.00  0.00           C  
ATOM    180  NZ  LYS A  15      41.940  85.390  -7.375  1.00  0.00           N  
ATOM    181  H   LYS A  15      35.557  82.937  -9.100  1.00  0.00           H  
ATOM    182  HA  LYS A  15      38.283  81.857  -8.995  1.00  0.00           H  
ATOM    183  HB2 LYS A  15      37.683  84.348  -8.571  1.00  0.00           H  
ATOM    184  HB3 LYS A  15      37.127  83.784  -7.000  1.00  0.00           H  
ATOM    185  HG2 LYS A  15      39.341  82.921  -6.502  1.00  0.00           H  
ATOM    186  HG3 LYS A  15      39.908  83.416  -8.098  1.00  0.00           H  
ATOM    187  HD2 LYS A  15      39.411  85.757  -7.528  1.00  0.00           H  
ATOM    188  HD3 LYS A  15      38.893  85.244  -5.920  1.00  0.00           H  
ATOM    189  HE2 LYS A  15      41.070  85.890  -5.525  1.00  0.00           H  
ATOM    190  HE3 LYS A  15      41.259  84.160  -5.808  1.00  0.00           H  
ATOM    191  HZ1 LYS A  15      41.654  84.870  -8.230  1.00  0.00           H  
ATOM    192  HZ2 LYS A  15      42.903  85.097  -7.110  1.00  0.00           H  
ATOM    193  HZ3 LYS A  15      41.946  86.408  -7.587  1.00  0.00           H  
ATOM    194  N   PRO A  16      38.080  80.380  -6.982  1.00  0.00           N  
ATOM    195  CA  PRO A  16      37.911  79.365  -5.938  1.00  0.00           C  
ATOM    196  C   PRO A  16      37.813  79.978  -4.546  1.00  0.00           C  
ATOM    197  O   PRO A  16      38.149  81.145  -4.344  1.00  0.00           O  
ATOM    198  CB  PRO A  16      39.179  78.517  -6.061  1.00  0.00           C  
ATOM    199  CG  PRO A  16      40.189  79.430  -6.666  1.00  0.00           C  
ATOM    200  CD  PRO A  16      39.424  80.346  -7.581  1.00  0.00           C  
ATOM    201  HA  PRO A  16      37.044  78.749  -6.121  1.00  0.00           H  
ATOM    202  HB2 PRO A  16      39.487  78.181  -5.081  1.00  0.00           H  
ATOM    203  HB3 PRO A  16      38.987  77.666  -6.696  1.00  0.00           H  
ATOM    204  HG2 PRO A  16      40.681  79.999  -5.890  1.00  0.00           H  
ATOM    205  HG3 PRO A  16      40.912  78.857  -7.227  1.00  0.00           H  
ATOM    206  HD2 PRO A  16      39.870  81.330  -7.588  1.00  0.00           H  
ATOM    207  HD3 PRO A  16      39.391  79.938  -8.580  1.00  0.00           H  
ATOM    208  N   LYS A  17      37.349  79.184  -3.586  1.00  0.00           N  
ATOM    209  CA  LYS A  17      37.209  79.646  -2.211  1.00  0.00           C  
ATOM    210  C   LYS A  17      38.342  79.115  -1.339  1.00  0.00           C  
ATOM    211  O   LYS A  17      38.879  79.833  -0.496  1.00  0.00           O  
ATOM    212  CB  LYS A  17      35.860  79.204  -1.638  1.00  0.00           C  
ATOM    213  CG  LYS A  17      34.666  79.751  -2.402  1.00  0.00           C  
ATOM    214  CD  LYS A  17      33.359  79.179  -1.879  1.00  0.00           C  
ATOM    215  CE  LYS A  17      32.209  80.154  -2.067  1.00  0.00           C  
ATOM    216  NZ  LYS A  17      30.892  79.458  -2.110  1.00  0.00           N  
ATOM    217  H   LYS A  17      37.097  78.262  -3.810  1.00  0.00           H  
ATOM    218  HA  LYS A  17      37.251  80.725  -2.218  1.00  0.00           H  
ATOM    219  HB2 LYS A  17      35.810  78.125  -1.658  1.00  0.00           H  
ATOM    220  HB3 LYS A  17      35.790  79.540  -0.614  1.00  0.00           H  
ATOM    221  HG2 LYS A  17      34.644  80.825  -2.296  1.00  0.00           H  
ATOM    222  HG3 LYS A  17      34.769  79.492  -3.446  1.00  0.00           H  
ATOM    223  HD2 LYS A  17      33.136  78.267  -2.414  1.00  0.00           H  
ATOM    224  HD3 LYS A  17      33.468  78.962  -0.826  1.00  0.00           H  
ATOM    225  HE2 LYS A  17      32.209  80.855  -1.247  1.00  0.00           H  
ATOM    226  HE3 LYS A  17      32.354  80.687  -2.996  1.00  0.00           H  
ATOM    227  HZ1 LYS A  17      31.012  78.454  -1.870  1.00  0.00           H  
ATOM    228  HZ2 LYS A  17      30.480  79.530  -3.062  1.00  0.00           H  
ATOM    229  HZ3 LYS A  17      30.237  79.891  -1.428  1.00  0.00           H  
ATOM    230  N   PHE A  18      38.701  77.853  -1.549  1.00  0.00           N  
ATOM    231  CA  PHE A  18      39.771  77.225  -0.781  1.00  0.00           C  
ATOM    232  C   PHE A  18      41.126  77.473  -1.436  1.00  0.00           C  
ATOM    233  O   PHE A  18      41.207  77.757  -2.631  1.00  0.00           O  
ATOM    234  CB  PHE A  18      39.521  75.721  -0.653  1.00  0.00           C  
ATOM    235  CG  PHE A  18      38.112  75.379  -0.259  1.00  0.00           C  
ATOM    236  CD1 PHE A  18      37.133  75.206  -1.223  1.00  0.00           C  
ATOM    237  CD2 PHE A  18      37.769  75.231   1.074  1.00  0.00           C  
ATOM    238  CE1 PHE A  18      35.836  74.892  -0.864  1.00  0.00           C  
ATOM    239  CE2 PHE A  18      36.473  74.916   1.440  1.00  0.00           C  
ATOM    240  CZ  PHE A  18      35.506  74.745   0.469  1.00  0.00           C  
ATOM    241  H   PHE A  18      38.235  77.330  -2.234  1.00  0.00           H  
ATOM    242  HA  PHE A  18      39.775  77.667   0.203  1.00  0.00           H  
ATOM    243  HB2 PHE A  18      39.724  75.247  -1.602  1.00  0.00           H  
ATOM    244  HB3 PHE A  18      40.184  75.316   0.097  1.00  0.00           H  
ATOM    245  HD1 PHE A  18      37.389  75.319  -2.266  1.00  0.00           H  
ATOM    246  HD2 PHE A  18      38.525  75.364   1.835  1.00  0.00           H  
ATOM    247  HE1 PHE A  18      35.081  74.758  -1.625  1.00  0.00           H  
ATOM    248  HE2 PHE A  18      36.219  74.803   2.483  1.00  0.00           H  
ATOM    249  HZ  PHE A  18      34.493  74.500   0.753  1.00  0.00           H  
ATOM    250  N   GLN A  19      42.189  77.363  -0.645  1.00  0.00           N  
ATOM    251  CA  GLN A  19      43.541  77.576  -1.147  1.00  0.00           C  
ATOM    252  C   GLN A  19      44.388  76.318  -0.980  1.00  0.00           C  
ATOM    253  O   GLN A  19      44.115  75.485  -0.118  1.00  0.00           O  
ATOM    254  CB  GLN A  19      44.199  78.750  -0.419  1.00  0.00           C  
ATOM    255  CG  GLN A  19      43.655  80.106  -0.835  1.00  0.00           C  
ATOM    256  CD  GLN A  19      43.862  81.169   0.226  1.00  0.00           C  
ATOM    257  OE1 GLN A  19      44.983  81.404   0.675  1.00  0.00           O  
ATOM    258  NE2 GLN A  19      42.776  81.816   0.635  1.00  0.00           N  
ATOM    259  H   GLN A  19      42.060  77.134   0.299  1.00  0.00           H  
ATOM    260  HA  GLN A  19      43.471  77.811  -2.198  1.00  0.00           H  
ATOM    261  HB2 GLN A  19      44.041  78.632   0.643  1.00  0.00           H  
ATOM    262  HB3 GLN A  19      45.260  78.733  -0.621  1.00  0.00           H  
ATOM    263  HG2 GLN A  19      44.159  80.420  -1.738  1.00  0.00           H  
ATOM    264  HG3 GLN A  19      42.597  80.011  -1.029  1.00  0.00           H  
ATOM    265 HE21 GLN A  19      41.915  81.574   0.234  1.00  0.00           H  
ATOM    266 HE22 GLN A  19      42.880  82.506   1.321  1.00  0.00           H  
ATOM    267  N   GLU A  20      45.417  76.189  -1.813  1.00  0.00           N  
ATOM    268  CA  GLU A  20      46.302  75.033  -1.757  1.00  0.00           C  
ATOM    269  C   GLU A  20      47.061  74.991  -0.434  1.00  0.00           C  
ATOM    270  O   GLU A  20      47.579  76.007   0.030  1.00  0.00           O  
ATOM    271  CB  GLU A  20      47.292  75.064  -2.924  1.00  0.00           C  
ATOM    272  CG  GLU A  20      46.624  75.060  -4.289  1.00  0.00           C  
ATOM    273  CD  GLU A  20      47.441  75.784  -5.340  1.00  0.00           C  
ATOM    274  OE1 GLU A  20      48.683  75.649  -5.325  1.00  0.00           O  
ATOM    275  OE2 GLU A  20      46.838  76.485  -6.180  1.00  0.00           O  
ATOM    276  H   GLU A  20      45.584  76.889  -2.479  1.00  0.00           H  
ATOM    277  HA  GLU A  20      45.694  74.145  -1.837  1.00  0.00           H  
ATOM    278  HB2 GLU A  20      47.896  75.955  -2.844  1.00  0.00           H  
ATOM    279  HB3 GLU A  20      47.934  74.198  -2.859  1.00  0.00           H  
ATOM    280  HG2 GLU A  20      46.485  74.036  -4.604  1.00  0.00           H  
ATOM    281  HG3 GLU A  20      45.661  75.543  -4.206  1.00  0.00           H  
ATOM    282  N   GLY A  21      47.121  73.808   0.171  1.00  0.00           N  
ATOM    283  CA  GLY A  21      47.817  73.656   1.435  1.00  0.00           C  
ATOM    284  C   GLY A  21      46.875  73.688   2.622  1.00  0.00           C  
ATOM    285  O   GLY A  21      47.178  73.131   3.677  1.00  0.00           O  
ATOM    286  H   GLY A  21      46.689  73.033  -0.245  1.00  0.00           H  
ATOM    287  HA2 GLY A  21      48.344  72.713   1.432  1.00  0.00           H  
ATOM    288  HA3 GLY A  21      48.533  74.457   1.537  1.00  0.00           H  
ATOM    289  N   GLU A  22      45.732  74.345   2.452  1.00  0.00           N  
ATOM    290  CA  GLU A  22      44.745  74.450   3.521  1.00  0.00           C  
ATOM    291  C   GLU A  22      44.033  73.118   3.736  1.00  0.00           C  
ATOM    292  O   GLU A  22      43.621  72.460   2.780  1.00  0.00           O  
ATOM    293  CB  GLU A  22      43.722  75.541   3.195  1.00  0.00           C  
ATOM    294  CG  GLU A  22      42.770  75.842   4.339  1.00  0.00           C  
ATOM    295  CD  GLU A  22      43.409  76.687   5.424  1.00  0.00           C  
ATOM    296  OE1 GLU A  22      44.513  76.329   5.883  1.00  0.00           O  
ATOM    297  OE2 GLU A  22      42.804  77.709   5.813  1.00  0.00           O  
ATOM    298  H   GLU A  22      45.548  74.769   1.588  1.00  0.00           H  
ATOM    299  HA  GLU A  22      45.266  74.717   4.428  1.00  0.00           H  
ATOM    300  HB2 GLU A  22      44.250  76.449   2.944  1.00  0.00           H  
ATOM    301  HB3 GLU A  22      43.140  75.227   2.341  1.00  0.00           H  
ATOM    302  HG2 GLU A  22      41.914  76.372   3.949  1.00  0.00           H  
ATOM    303  HG3 GLU A  22      42.444  74.909   4.776  1.00  0.00           H  
ATOM    304  N   ARG A  23      43.892  72.726   4.998  1.00  0.00           N  
ATOM    305  CA  ARG A  23      43.232  71.472   5.340  1.00  0.00           C  
ATOM    306  C   ARG A  23      41.729  71.563   5.090  1.00  0.00           C  
ATOM    307  O   ARG A  23      41.062  72.474   5.580  1.00  0.00           O  
ATOM    308  CB  ARG A  23      43.496  71.114   6.803  1.00  0.00           C  
ATOM    309  CG  ARG A  23      43.054  69.708   7.176  1.00  0.00           C  
ATOM    310  CD  ARG A  23      43.393  69.382   8.622  1.00  0.00           C  
ATOM    311  NE  ARG A  23      44.715  68.774   8.751  1.00  0.00           N  
ATOM    312  CZ  ARG A  23      45.433  68.807   9.867  1.00  0.00           C  
ATOM    313  NH1 ARG A  23      44.961  69.416  10.946  1.00  0.00           N  
ATOM    314  NH2 ARG A  23      46.628  68.229   9.906  1.00  0.00           N  
ATOM    315  H   ARG A  23      44.241  73.293   5.716  1.00  0.00           H  
ATOM    316  HA  ARG A  23      43.643  70.698   4.709  1.00  0.00           H  
ATOM    317  HB2 ARG A  23      44.556  71.197   6.997  1.00  0.00           H  
ATOM    318  HB3 ARG A  23      42.967  71.813   7.433  1.00  0.00           H  
ATOM    319  HG2 ARG A  23      41.985  69.630   7.042  1.00  0.00           H  
ATOM    320  HG3 ARG A  23      43.553  69.001   6.531  1.00  0.00           H  
ATOM    321  HD2 ARG A  23      43.371  70.296   9.198  1.00  0.00           H  
ATOM    322  HD3 ARG A  23      42.652  68.698   9.005  1.00  0.00           H  
ATOM    323  HE  ARG A  23      45.082  68.318   7.966  1.00  0.00           H  
ATOM    324 HH11 ARG A  23      44.062  69.851  10.920  1.00  0.00           H  
ATOM    325 HH12 ARG A  23      45.504  69.439  11.786  1.00  0.00           H  
ATOM    326 HH21 ARG A  23      46.987  67.768   9.095  1.00  0.00           H  
ATOM    327 HH22 ARG A  23      47.168  68.254  10.747  1.00  0.00           H  
ATOM    328  N   VAL A  24      41.203  70.612   4.325  1.00  0.00           N  
ATOM    329  CA  VAL A  24      39.780  70.584   4.011  1.00  0.00           C  
ATOM    330  C   VAL A  24      39.228  69.165   4.085  1.00  0.00           C  
ATOM    331  O   VAL A  24      39.985  68.195   4.154  1.00  0.00           O  
ATOM    332  CB  VAL A  24      39.502  71.159   2.609  1.00  0.00           C  
ATOM    333  CG1 VAL A  24      39.916  72.621   2.540  1.00  0.00           C  
ATOM    334  CG2 VAL A  24      40.224  70.342   1.548  1.00  0.00           C  
ATOM    335  H   VAL A  24      41.785  69.912   3.964  1.00  0.00           H  
ATOM    336  HA  VAL A  24      39.266  71.199   4.736  1.00  0.00           H  
ATOM    337  HB  VAL A  24      38.441  71.098   2.421  1.00  0.00           H  
ATOM    338 HG11 VAL A  24      40.731  72.732   1.840  1.00  0.00           H  
ATOM    339 HG12 VAL A  24      39.077  73.217   2.214  1.00  0.00           H  
ATOM    340 HG13 VAL A  24      40.234  72.952   3.518  1.00  0.00           H  
ATOM    341 HG21 VAL A  24      41.289  70.472   1.655  1.00  0.00           H  
ATOM    342 HG22 VAL A  24      39.974  69.298   1.666  1.00  0.00           H  
ATOM    343 HG23 VAL A  24      39.918  70.675   0.566  1.00  0.00           H  
ATOM    344  N   LEU A  25      37.904  69.049   4.069  1.00  0.00           N  
ATOM    345  CA  LEU A  25      37.250  67.747   4.133  1.00  0.00           C  
ATOM    346  C   LEU A  25      36.628  67.383   2.789  1.00  0.00           C  
ATOM    347  O   LEU A  25      35.738  68.079   2.298  1.00  0.00           O  
ATOM    348  CB  LEU A  25      36.176  67.748   5.222  1.00  0.00           C  
ATOM    349  CG  LEU A  25      36.667  67.988   6.649  1.00  0.00           C  
ATOM    350  CD1 LEU A  25      35.491  68.213   7.588  1.00  0.00           C  
ATOM    351  CD2 LEU A  25      37.515  66.817   7.126  1.00  0.00           C  
ATOM    352  H   LEU A  25      37.354  69.857   4.013  1.00  0.00           H  
ATOM    353  HA  LEU A  25      38.001  67.011   4.380  1.00  0.00           H  
ATOM    354  HB2 LEU A  25      35.463  68.523   4.983  1.00  0.00           H  
ATOM    355  HB3 LEU A  25      35.681  66.786   5.198  1.00  0.00           H  
ATOM    356  HG  LEU A  25      37.282  68.877   6.667  1.00  0.00           H  
ATOM    357 HD11 LEU A  25      35.217  69.257   7.577  1.00  0.00           H  
ATOM    358 HD12 LEU A  25      35.771  67.925   8.591  1.00  0.00           H  
ATOM    359 HD13 LEU A  25      34.652  67.616   7.264  1.00  0.00           H  
ATOM    360 HD21 LEU A  25      36.931  65.911   7.086  1.00  0.00           H  
ATOM    361 HD22 LEU A  25      37.835  66.995   8.142  1.00  0.00           H  
ATOM    362 HD23 LEU A  25      38.381  66.718   6.488  1.00  0.00           H  
ATOM    363  N   CYS A  26      37.100  66.290   2.201  1.00  0.00           N  
ATOM    364  CA  CYS A  26      36.589  65.833   0.914  1.00  0.00           C  
ATOM    365  C   CYS A  26      35.498  64.784   1.103  1.00  0.00           C  
ATOM    366  O   CYS A  26      35.410  64.147   2.152  1.00  0.00           O  
ATOM    367  CB  CYS A  26      37.724  65.257   0.066  1.00  0.00           C  
ATOM    368  SG  CYS A  26      37.226  64.768  -1.602  1.00  0.00           S  
ATOM    369  H   CYS A  26      37.810  65.778   2.642  1.00  0.00           H  
ATOM    370  HA  CYS A  26      36.167  66.686   0.404  1.00  0.00           H  
ATOM    371  HB2 CYS A  26      38.505  65.997  -0.029  1.00  0.00           H  
ATOM    372  HB3 CYS A  26      38.124  64.384   0.560  1.00  0.00           H  
ATOM    373  HG  CYS A  26      36.847  63.501  -1.560  1.00  0.00           H  
ATOM    374  N   PHE A  27      34.665  64.613   0.082  1.00  0.00           N  
ATOM    375  CA  PHE A  27      33.578  63.643   0.136  1.00  0.00           C  
ATOM    376  C   PHE A  27      33.868  62.448  -0.765  1.00  0.00           C  
ATOM    377  O   PHE A  27      33.708  62.520  -1.984  1.00  0.00           O  
ATOM    378  CB  PHE A  27      32.260  64.301  -0.279  1.00  0.00           C  
ATOM    379  CG  PHE A  27      31.501  64.902   0.870  1.00  0.00           C  
ATOM    380  CD1 PHE A  27      30.984  64.098   1.872  1.00  0.00           C  
ATOM    381  CD2 PHE A  27      31.305  66.272   0.947  1.00  0.00           C  
ATOM    382  CE1 PHE A  27      30.286  64.647   2.932  1.00  0.00           C  
ATOM    383  CE2 PHE A  27      30.609  66.827   2.003  1.00  0.00           C  
ATOM    384  CZ  PHE A  27      30.098  66.014   2.996  1.00  0.00           C  
ATOM    385  H   PHE A  27      34.786  65.151  -0.729  1.00  0.00           H  
ATOM    386  HA  PHE A  27      33.493  63.298   1.155  1.00  0.00           H  
ATOM    387  HB2 PHE A  27      32.466  65.089  -0.988  1.00  0.00           H  
ATOM    388  HB3 PHE A  27      31.627  63.560  -0.744  1.00  0.00           H  
ATOM    389  HD1 PHE A  27      31.132  63.028   1.823  1.00  0.00           H  
ATOM    390  HD2 PHE A  27      31.703  66.908   0.170  1.00  0.00           H  
ATOM    391  HE1 PHE A  27      29.888  64.009   3.706  1.00  0.00           H  
ATOM    392  HE2 PHE A  27      30.462  67.896   2.051  1.00  0.00           H  
ATOM    393  HZ  PHE A  27      29.554  66.446   3.823  1.00  0.00           H  
ATOM    394  N   HIS A  28      34.298  61.346  -0.157  1.00  0.00           N  
ATOM    395  CA  HIS A  28      34.611  60.133  -0.904  1.00  0.00           C  
ATOM    396  C   HIS A  28      33.603  59.031  -0.598  1.00  0.00           C  
ATOM    397  O   HIS A  28      33.948  57.850  -0.571  1.00  0.00           O  
ATOM    398  CB  HIS A  28      36.024  59.655  -0.571  1.00  0.00           C  
ATOM    399  CG  HIS A  28      36.473  58.490  -1.398  1.00  0.00           C  
ATOM    400  ND1 HIS A  28      36.867  57.286  -0.852  1.00  0.00           N  
ATOM    401  CD2 HIS A  28      36.588  58.348  -2.739  1.00  0.00           C  
ATOM    402  CE1 HIS A  28      37.206  56.456  -1.822  1.00  0.00           C  
ATOM    403  NE2 HIS A  28      37.046  57.075  -2.976  1.00  0.00           N  
ATOM    404  H   HIS A  28      34.406  61.349   0.816  1.00  0.00           H  
ATOM    405  HA  HIS A  28      34.559  60.369  -1.956  1.00  0.00           H  
ATOM    406  HB2 HIS A  28      36.720  60.464  -0.735  1.00  0.00           H  
ATOM    407  HB3 HIS A  28      36.062  59.359   0.468  1.00  0.00           H  
ATOM    408  HD1 HIS A  28      36.896  57.074   0.104  1.00  0.00           H  
ATOM    409  HD2 HIS A  28      36.363  59.097  -3.485  1.00  0.00           H  
ATOM    410  HE1 HIS A  28      37.554  55.442  -1.692  1.00  0.00           H  
ATOM    411  HE2 HIS A  28      37.305  56.717  -3.850  1.00  0.00           H  
ATOM    412  N   GLY A  29      32.354  59.424  -0.366  1.00  0.00           N  
ATOM    413  CA  GLY A  29      31.316  58.457  -0.063  1.00  0.00           C  
ATOM    414  C   GLY A  29      30.436  58.893   1.092  1.00  0.00           C  
ATOM    415  O   GLY A  29      30.322  60.079   1.400  1.00  0.00           O  
ATOM    416  H   GLY A  29      32.137  60.379  -0.400  1.00  0.00           H  
ATOM    417  HA2 GLY A  29      30.700  58.320  -0.939  1.00  0.00           H  
ATOM    418  HA3 GLY A  29      31.779  57.514   0.189  1.00  0.00           H  
ATOM    419  N   PRO A  30      29.794  57.918   1.753  1.00  0.00           N  
ATOM    420  CA  PRO A  30      28.908  58.183   2.890  1.00  0.00           C  
ATOM    421  C   PRO A  30      29.673  58.650   4.124  1.00  0.00           C  
ATOM    422  O   PRO A  30      29.087  58.864   5.186  1.00  0.00           O  
ATOM    423  CB  PRO A  30      28.249  56.826   3.150  1.00  0.00           C  
ATOM    424  CG  PRO A  30      29.217  55.827   2.619  1.00  0.00           C  
ATOM    425  CD  PRO A  30      29.884  56.482   1.441  1.00  0.00           C  
ATOM    426  HA  PRO A  30      28.150  58.911   2.641  1.00  0.00           H  
ATOM    427  HB2 PRO A  30      28.091  56.698   4.213  1.00  0.00           H  
ATOM    428  HB3 PRO A  30      27.304  56.774   2.631  1.00  0.00           H  
ATOM    429  HG2 PRO A  30      29.949  55.584   3.376  1.00  0.00           H  
ATOM    430  HG3 PRO A  30      28.691  54.938   2.305  1.00  0.00           H  
ATOM    431  HD2 PRO A  30      30.913  56.166   1.366  1.00  0.00           H  
ATOM    432  HD3 PRO A  30      29.350  56.252   0.530  1.00  0.00           H  
ATOM    433  N   LEU A  31      30.984  58.806   3.978  1.00  0.00           N  
ATOM    434  CA  LEU A  31      31.830  59.248   5.081  1.00  0.00           C  
ATOM    435  C   LEU A  31      32.859  60.268   4.604  1.00  0.00           C  
ATOM    436  O   LEU A  31      33.331  60.204   3.468  1.00  0.00           O  
ATOM    437  CB  LEU A  31      32.538  58.052   5.718  1.00  0.00           C  
ATOM    438  CG  LEU A  31      31.632  56.982   6.328  1.00  0.00           C  
ATOM    439  CD1 LEU A  31      32.304  55.619   6.275  1.00  0.00           C  
ATOM    440  CD2 LEU A  31      31.270  57.344   7.761  1.00  0.00           C  
ATOM    441  H   LEU A  31      31.394  58.620   3.108  1.00  0.00           H  
ATOM    442  HA  LEU A  31      31.194  59.715   5.820  1.00  0.00           H  
ATOM    443  HB2 LEU A  31      33.140  57.580   4.956  1.00  0.00           H  
ATOM    444  HB3 LEU A  31      33.182  58.427   6.501  1.00  0.00           H  
ATOM    445  HG  LEU A  31      30.716  56.925   5.755  1.00  0.00           H  
ATOM    446 HD11 LEU A  31      31.558  54.856   6.110  1.00  0.00           H  
ATOM    447 HD12 LEU A  31      32.812  55.431   7.208  1.00  0.00           H  
ATOM    448 HD13 LEU A  31      33.020  55.603   5.466  1.00  0.00           H  
ATOM    449 HD21 LEU A  31      31.372  56.471   8.390  1.00  0.00           H  
ATOM    450 HD22 LEU A  31      30.250  57.695   7.796  1.00  0.00           H  
ATOM    451 HD23 LEU A  31      31.931  58.122   8.114  1.00  0.00           H  
ATOM    452  N   LEU A  32      33.202  61.207   5.478  1.00  0.00           N  
ATOM    453  CA  LEU A  32      34.177  62.240   5.146  1.00  0.00           C  
ATOM    454  C   LEU A  32      35.592  61.785   5.493  1.00  0.00           C  
ATOM    455  O   LEU A  32      35.799  61.053   6.460  1.00  0.00           O  
ATOM    456  CB  LEU A  32      33.850  63.537   5.890  1.00  0.00           C  
ATOM    457  CG  LEU A  32      32.833  64.458   5.216  1.00  0.00           C  
ATOM    458  CD1 LEU A  32      32.413  65.572   6.162  1.00  0.00           C  
ATOM    459  CD2 LEU A  32      33.407  65.036   3.930  1.00  0.00           C  
ATOM    460  H   LEU A  32      32.790  61.208   6.367  1.00  0.00           H  
ATOM    461  HA  LEU A  32      34.121  62.421   4.083  1.00  0.00           H  
ATOM    462  HB2 LEU A  32      33.462  63.272   6.861  1.00  0.00           H  
ATOM    463  HB3 LEU A  32      34.770  64.089   6.010  1.00  0.00           H  
ATOM    464  HG  LEU A  32      31.951  63.887   4.962  1.00  0.00           H  
ATOM    465 HD11 LEU A  32      31.747  66.249   5.648  1.00  0.00           H  
ATOM    466 HD12 LEU A  32      33.289  66.112   6.493  1.00  0.00           H  
ATOM    467 HD13 LEU A  32      31.908  65.148   7.017  1.00  0.00           H  
ATOM    468 HD21 LEU A  32      33.338  64.300   3.143  1.00  0.00           H  
ATOM    469 HD22 LEU A  32      34.442  65.302   4.087  1.00  0.00           H  
ATOM    470 HD23 LEU A  32      32.848  65.917   3.650  1.00  0.00           H  
ATOM    471  N   TYR A  33      36.560  62.226   4.699  1.00  0.00           N  
ATOM    472  CA  TYR A  33      37.955  61.864   4.922  1.00  0.00           C  
ATOM    473  C   TYR A  33      38.843  63.105   4.950  1.00  0.00           C  
ATOM    474  O   TYR A  33      38.662  64.027   4.156  1.00  0.00           O  
ATOM    475  CB  TYR A  33      38.436  60.905   3.831  1.00  0.00           C  
ATOM    476  CG  TYR A  33      37.571  59.673   3.685  1.00  0.00           C  
ATOM    477  CD1 TYR A  33      36.340  59.736   3.045  1.00  0.00           C  
ATOM    478  CD2 TYR A  33      37.987  58.445   4.188  1.00  0.00           C  
ATOM    479  CE1 TYR A  33      35.547  58.613   2.910  1.00  0.00           C  
ATOM    480  CE2 TYR A  33      37.201  57.318   4.056  1.00  0.00           C  
ATOM    481  CZ  TYR A  33      35.982  57.406   3.417  1.00  0.00           C  
ATOM    482  OH  TYR A  33      35.195  56.284   3.284  1.00  0.00           O  
ATOM    483  H   TYR A  33      36.333  62.808   3.944  1.00  0.00           H  
ATOM    484  HA  TYR A  33      38.020  61.368   5.879  1.00  0.00           H  
ATOM    485  HB2 TYR A  33      38.440  61.421   2.884  1.00  0.00           H  
ATOM    486  HB3 TYR A  33      39.439  60.581   4.063  1.00  0.00           H  
ATOM    487  HD1 TYR A  33      36.002  60.683   2.649  1.00  0.00           H  
ATOM    488  HD2 TYR A  33      38.942  58.380   4.688  1.00  0.00           H  
ATOM    489  HE1 TYR A  33      34.593  58.681   2.410  1.00  0.00           H  
ATOM    490  HE2 TYR A  33      37.541  56.372   4.453  1.00  0.00           H  
ATOM    491  HH  TYR A  33      34.328  56.456   3.657  1.00  0.00           H  
ATOM    492  N   GLU A  34      39.802  63.118   5.871  1.00  0.00           N  
ATOM    493  CA  GLU A  34      40.717  64.246   6.002  1.00  0.00           C  
ATOM    494  C   GLU A  34      41.604  64.374   4.767  1.00  0.00           C  
ATOM    495  O   GLU A  34      42.208  63.399   4.320  1.00  0.00           O  
ATOM    496  CB  GLU A  34      41.584  64.083   7.253  1.00  0.00           C  
ATOM    497  CG  GLU A  34      42.620  65.182   7.422  1.00  0.00           C  
ATOM    498  CD  GLU A  34      43.631  64.869   8.509  1.00  0.00           C  
ATOM    499  OE1 GLU A  34      43.269  64.968   9.700  1.00  0.00           O  
ATOM    500  OE2 GLU A  34      44.782  64.525   8.168  1.00  0.00           O  
ATOM    501  H   GLU A  34      39.894  62.353   6.475  1.00  0.00           H  
ATOM    502  HA  GLU A  34      40.126  65.143   6.101  1.00  0.00           H  
ATOM    503  HB2 GLU A  34      40.945  64.083   8.122  1.00  0.00           H  
ATOM    504  HB3 GLU A  34      42.101  63.136   7.196  1.00  0.00           H  
ATOM    505  HG2 GLU A  34      43.147  65.309   6.488  1.00  0.00           H  
ATOM    506  HG3 GLU A  34      42.114  66.101   7.675  1.00  0.00           H  
ATOM    507  N   ALA A  35      41.676  65.583   4.220  1.00  0.00           N  
ATOM    508  CA  ALA A  35      42.490  65.840   3.039  1.00  0.00           C  
ATOM    509  C   ALA A  35      42.923  67.299   2.977  1.00  0.00           C  
ATOM    510  O   ALA A  35      42.469  68.128   3.767  1.00  0.00           O  
ATOM    511  CB  ALA A  35      41.725  65.461   1.779  1.00  0.00           C  
ATOM    512  H   ALA A  35      41.171  66.320   4.623  1.00  0.00           H  
ATOM    513  HA  ALA A  35      43.370  65.215   3.097  1.00  0.00           H  
ATOM    514  HB1 ALA A  35      41.112  66.293   1.467  1.00  0.00           H  
ATOM    515  HB2 ALA A  35      42.425  65.214   0.994  1.00  0.00           H  
ATOM    516  HB3 ALA A  35      41.097  64.607   1.983  1.00  0.00           H  
ATOM    517  N   LYS A  36      43.807  67.611   2.034  1.00  0.00           N  
ATOM    518  CA  LYS A  36      44.303  68.972   1.869  1.00  0.00           C  
ATOM    519  C   LYS A  36      44.245  69.398   0.405  1.00  0.00           C  
ATOM    520  O   LYS A  36      44.443  68.582  -0.496  1.00  0.00           O  
ATOM    521  CB  LYS A  36      45.739  69.080   2.386  1.00  0.00           C  
ATOM    522  CG  LYS A  36      46.427  70.379   2.005  1.00  0.00           C  
ATOM    523  CD  LYS A  36      47.152  70.257   0.675  1.00  0.00           C  
ATOM    524  CE  LYS A  36      48.529  69.631   0.848  1.00  0.00           C  
ATOM    525  NZ  LYS A  36      48.476  68.145   0.775  1.00  0.00           N  
ATOM    526  H   LYS A  36      44.132  66.907   1.434  1.00  0.00           H  
ATOM    527  HA  LYS A  36      43.670  69.629   2.447  1.00  0.00           H  
ATOM    528  HB2 LYS A  36      45.726  69.007   3.464  1.00  0.00           H  
ATOM    529  HB3 LYS A  36      46.316  68.261   1.985  1.00  0.00           H  
ATOM    530  HG2 LYS A  36      45.685  71.160   1.925  1.00  0.00           H  
ATOM    531  HG3 LYS A  36      47.142  70.637   2.772  1.00  0.00           H  
ATOM    532  HD2 LYS A  36      46.568  69.635   0.012  1.00  0.00           H  
ATOM    533  HD3 LYS A  36      47.264  71.240   0.243  1.00  0.00           H  
ATOM    534  HE2 LYS A  36      49.176  69.999   0.067  1.00  0.00           H  
ATOM    535  HE3 LYS A  36      48.924  69.923   1.809  1.00  0.00           H  
ATOM    536  HZ1 LYS A  36      48.738  67.733   1.693  1.00  0.00           H  
ATOM    537  HZ2 LYS A  36      49.138  67.799   0.050  1.00  0.00           H  
ATOM    538  HZ3 LYS A  36      47.516  67.833   0.528  1.00  0.00           H  
ATOM    539  N   CYS A  37      43.976  70.678   0.177  1.00  0.00           N  
ATOM    540  CA  CYS A  37      43.893  71.212  -1.179  1.00  0.00           C  
ATOM    541  C   CYS A  37      45.253  71.158  -1.868  1.00  0.00           C  
ATOM    542  O   CYS A  37      46.120  71.997  -1.621  1.00  0.00           O  
ATOM    543  CB  CYS A  37      43.379  72.652  -1.152  1.00  0.00           C  
ATOM    544  SG  CYS A  37      42.779  73.252  -2.749  1.00  0.00           S  
ATOM    545  H   CYS A  37      43.828  71.279   0.936  1.00  0.00           H  
ATOM    546  HA  CYS A  37      43.198  70.600  -1.733  1.00  0.00           H  
ATOM    547  HB2 CYS A  37      42.561  72.720  -0.448  1.00  0.00           H  
ATOM    548  HB3 CYS A  37      44.176  73.306  -0.831  1.00  0.00           H  
ATOM    549  HG  CYS A  37      43.602  72.807  -3.687  1.00  0.00           H  
ATOM    550  N   VAL A  38      45.434  70.165  -2.732  1.00  0.00           N  
ATOM    551  CA  VAL A  38      46.688  70.000  -3.457  1.00  0.00           C  
ATOM    552  C   VAL A  38      46.789  70.990  -4.612  1.00  0.00           C  
ATOM    553  O   VAL A  38      47.824  71.624  -4.813  1.00  0.00           O  
ATOM    554  CB  VAL A  38      46.836  68.569  -4.006  1.00  0.00           C  
ATOM    555  CG1 VAL A  38      48.263  68.319  -4.468  1.00  0.00           C  
ATOM    556  CG2 VAL A  38      46.422  67.550  -2.955  1.00  0.00           C  
ATOM    557  H   VAL A  38      44.706  69.527  -2.887  1.00  0.00           H  
ATOM    558  HA  VAL A  38      47.499  70.184  -2.767  1.00  0.00           H  
ATOM    559  HB  VAL A  38      46.181  68.462  -4.859  1.00  0.00           H  
ATOM    560 HG11 VAL A  38      48.363  67.292  -4.787  1.00  0.00           H  
ATOM    561 HG12 VAL A  38      48.495  68.977  -5.294  1.00  0.00           H  
ATOM    562 HG13 VAL A  38      48.944  68.511  -3.652  1.00  0.00           H  
ATOM    563 HG21 VAL A  38      47.274  67.296  -2.343  1.00  0.00           H  
ATOM    564 HG22 VAL A  38      45.644  67.971  -2.335  1.00  0.00           H  
ATOM    565 HG23 VAL A  38      46.050  66.661  -3.443  1.00  0.00           H  
ATOM    566  N   LYS A  39      45.706  71.116  -5.372  1.00  0.00           N  
ATOM    567  CA  LYS A  39      45.669  72.029  -6.507  1.00  0.00           C  
ATOM    568  C   LYS A  39      44.269  72.602  -6.701  1.00  0.00           C  
ATOM    569  O   LYS A  39      43.305  72.133  -6.094  1.00  0.00           O  
ATOM    570  CB  LYS A  39      46.117  71.309  -7.781  1.00  0.00           C  
ATOM    571  CG  LYS A  39      47.610  71.036  -7.833  1.00  0.00           C  
ATOM    572  CD  LYS A  39      48.055  70.630  -9.227  1.00  0.00           C  
ATOM    573  CE  LYS A  39      49.267  69.713  -9.181  1.00  0.00           C  
ATOM    574  NZ  LYS A  39      48.877  68.283  -9.032  1.00  0.00           N  
ATOM    575  H   LYS A  39      44.910  70.583  -5.162  1.00  0.00           H  
ATOM    576  HA  LYS A  39      46.352  72.840  -6.303  1.00  0.00           H  
ATOM    577  HB2 LYS A  39      45.597  70.366  -7.849  1.00  0.00           H  
ATOM    578  HB3 LYS A  39      45.854  71.917  -8.636  1.00  0.00           H  
ATOM    579  HG2 LYS A  39      48.141  71.931  -7.544  1.00  0.00           H  
ATOM    580  HG3 LYS A  39      47.844  70.237  -7.143  1.00  0.00           H  
ATOM    581  HD2 LYS A  39      47.244  70.111  -9.718  1.00  0.00           H  
ATOM    582  HD3 LYS A  39      48.308  71.518  -9.789  1.00  0.00           H  
ATOM    583  HE2 LYS A  39      49.827  69.830 -10.096  1.00  0.00           H  
ATOM    584  HE3 LYS A  39      49.885  69.997  -8.341  1.00  0.00           H  
ATOM    585  HZ1 LYS A  39      48.891  67.810  -9.959  1.00  0.00           H  
ATOM    586  HZ2 LYS A  39      47.917  68.215  -8.635  1.00  0.00           H  
ATOM    587  HZ3 LYS A  39      49.538  67.796  -8.396  1.00  0.00           H  
ATOM    588  N   VAL A  40      44.162  73.620  -7.549  1.00  0.00           N  
ATOM    589  CA  VAL A  40      42.879  74.254  -7.824  1.00  0.00           C  
ATOM    590  C   VAL A  40      42.712  74.537  -9.313  1.00  0.00           C  
ATOM    591  O   VAL A  40      43.324  75.460  -9.852  1.00  0.00           O  
ATOM    592  CB  VAL A  40      42.727  75.573  -7.042  1.00  0.00           C  
ATOM    593  CG1 VAL A  40      41.370  76.203  -7.318  1.00  0.00           C  
ATOM    594  CG2 VAL A  40      42.919  75.334  -5.553  1.00  0.00           C  
ATOM    595  H   VAL A  40      44.966  73.950  -8.003  1.00  0.00           H  
ATOM    596  HA  VAL A  40      42.097  73.580  -7.507  1.00  0.00           H  
ATOM    597  HB  VAL A  40      43.491  76.257  -7.378  1.00  0.00           H  
ATOM    598 HG11 VAL A  40      40.610  75.436  -7.320  1.00  0.00           H  
ATOM    599 HG12 VAL A  40      41.148  76.930  -6.551  1.00  0.00           H  
ATOM    600 HG13 VAL A  40      41.389  76.691  -8.282  1.00  0.00           H  
ATOM    601 HG21 VAL A  40      42.404  76.101  -4.995  1.00  0.00           H  
ATOM    602 HG22 VAL A  40      42.519  74.367  -5.289  1.00  0.00           H  
ATOM    603 HG23 VAL A  40      43.974  75.364  -5.316  1.00  0.00           H  
ATOM    604  N   ALA A  41      41.882  73.737  -9.972  1.00  0.00           N  
ATOM    605  CA  ALA A  41      41.633  73.902 -11.399  1.00  0.00           C  
ATOM    606  C   ALA A  41      40.197  74.344 -11.658  1.00  0.00           C  
ATOM    607  O   ALA A  41      39.322  74.174 -10.808  1.00  0.00           O  
ATOM    608  CB  ALA A  41      41.932  72.608 -12.140  1.00  0.00           C  
ATOM    609  H   ALA A  41      41.424  73.019  -9.487  1.00  0.00           H  
ATOM    610  HA  ALA A  41      42.305  74.663 -11.769  1.00  0.00           H  
ATOM    611  HB1 ALA A  41      42.837  72.169 -11.748  1.00  0.00           H  
ATOM    612  HB2 ALA A  41      41.109  71.919 -12.006  1.00  0.00           H  
ATOM    613  HB3 ALA A  41      42.059  72.816 -13.192  1.00  0.00           H  
ATOM    614  N   ILE A  42      39.961  74.910 -12.837  1.00  0.00           N  
ATOM    615  CA  ILE A  42      38.630  75.376 -13.207  1.00  0.00           C  
ATOM    616  C   ILE A  42      38.312  75.034 -14.659  1.00  0.00           C  
ATOM    617  O   ILE A  42      39.044  75.415 -15.573  1.00  0.00           O  
ATOM    618  CB  ILE A  42      38.489  76.896 -13.007  1.00  0.00           C  
ATOM    619  CG1 ILE A  42      38.783  77.270 -11.553  1.00  0.00           C  
ATOM    620  CG2 ILE A  42      37.094  77.356 -13.406  1.00  0.00           C  
ATOM    621  CD1 ILE A  42      39.144  78.727 -11.364  1.00  0.00           C  
ATOM    622  H   ILE A  42      40.698  75.018 -13.472  1.00  0.00           H  
ATOM    623  HA  ILE A  42      37.914  74.880 -12.567  1.00  0.00           H  
ATOM    624  HB  ILE A  42      39.202  77.390 -13.649  1.00  0.00           H  
ATOM    625 HG12 ILE A  42      37.911  77.065 -10.951  1.00  0.00           H  
ATOM    626 HG13 ILE A  42      39.610  76.673 -11.195  1.00  0.00           H  
ATOM    627 HG21 ILE A  42      37.172  78.198 -14.079  1.00  0.00           H  
ATOM    628 HG22 ILE A  42      36.577  76.547 -13.900  1.00  0.00           H  
ATOM    629 HG23 ILE A  42      36.546  77.649 -12.524  1.00  0.00           H  
ATOM    630 HD11 ILE A  42      39.163  78.959 -10.310  1.00  0.00           H  
ATOM    631 HD12 ILE A  42      40.120  78.914 -11.790  1.00  0.00           H  
ATOM    632 HD13 ILE A  42      38.410  79.347 -11.856  1.00  0.00           H  
ATOM    633  N   LYS A  43      37.214  74.314 -14.866  1.00  0.00           N  
ATOM    634  CA  LYS A  43      36.797  73.924 -16.207  1.00  0.00           C  
ATOM    635  C   LYS A  43      35.321  73.536 -16.225  1.00  0.00           C  
ATOM    636  O   LYS A  43      34.668  73.492 -15.183  1.00  0.00           O  
ATOM    637  CB  LYS A  43      37.648  72.755 -16.708  1.00  0.00           C  
ATOM    638  CG  LYS A  43      38.929  73.188 -17.400  1.00  0.00           C  
ATOM    639  CD  LYS A  43      39.453  72.107 -18.331  1.00  0.00           C  
ATOM    640  CE  LYS A  43      40.855  72.430 -18.825  1.00  0.00           C  
ATOM    641  NZ  LYS A  43      40.863  73.603 -19.743  1.00  0.00           N  
ATOM    642  H   LYS A  43      36.671  74.041 -14.097  1.00  0.00           H  
ATOM    643  HA  LYS A  43      36.942  74.770 -16.860  1.00  0.00           H  
ATOM    644  HB2 LYS A  43      37.911  72.129 -15.867  1.00  0.00           H  
ATOM    645  HB3 LYS A  43      37.065  72.174 -17.408  1.00  0.00           H  
ATOM    646  HG2 LYS A  43      38.732  74.080 -17.976  1.00  0.00           H  
ATOM    647  HG3 LYS A  43      39.678  73.399 -16.649  1.00  0.00           H  
ATOM    648  HD2 LYS A  43      39.478  71.167 -17.799  1.00  0.00           H  
ATOM    649  HD3 LYS A  43      38.790  72.025 -19.181  1.00  0.00           H  
ATOM    650  HE2 LYS A  43      41.482  72.645 -17.974  1.00  0.00           H  
ATOM    651  HE3 LYS A  43      41.243  71.570 -19.351  1.00  0.00           H  
ATOM    652  HZ1 LYS A  43      41.105  74.467 -19.215  1.00  0.00           H  
ATOM    653  HZ2 LYS A  43      39.926  73.725 -20.175  1.00  0.00           H  
ATOM    654  HZ3 LYS A  43      41.565  73.462 -20.496  1.00  0.00           H  
ATOM    655  N   ASP A  44      34.803  73.255 -17.416  1.00  0.00           N  
ATOM    656  CA  ASP A  44      33.405  72.869 -17.570  1.00  0.00           C  
ATOM    657  C   ASP A  44      32.497  73.775 -16.745  1.00  0.00           C  
ATOM    658  O   ASP A  44      31.460  73.342 -16.242  1.00  0.00           O  
ATOM    659  CB  ASP A  44      33.209  71.411 -17.151  1.00  0.00           C  
ATOM    660  CG  ASP A  44      32.063  70.746 -17.889  1.00  0.00           C  
ATOM    661  OD1 ASP A  44      32.279  70.288 -19.030  1.00  0.00           O  
ATOM    662  OD2 ASP A  44      30.950  70.686 -17.327  1.00  0.00           O  
ATOM    663  H   ASP A  44      35.375  73.309 -18.211  1.00  0.00           H  
ATOM    664  HA  ASP A  44      33.146  72.972 -18.612  1.00  0.00           H  
ATOM    665  HB2 ASP A  44      34.114  70.858 -17.357  1.00  0.00           H  
ATOM    666  HB3 ASP A  44      33.000  71.373 -16.092  1.00  0.00           H  
ATOM    667  N   LYS A  45      32.894  75.036 -16.609  1.00  0.00           N  
ATOM    668  CA  LYS A  45      32.117  76.005 -15.844  1.00  0.00           C  
ATOM    669  C   LYS A  45      31.983  75.569 -14.389  1.00  0.00           C  
ATOM    670  O   LYS A  45      30.931  75.743 -13.774  1.00  0.00           O  
ATOM    671  CB  LYS A  45      30.730  76.180 -16.466  1.00  0.00           C  
ATOM    672  CG  LYS A  45      30.719  77.084 -17.686  1.00  0.00           C  
ATOM    673  CD  LYS A  45      31.219  76.356 -18.923  1.00  0.00           C  
ATOM    674  CE  LYS A  45      31.196  77.258 -20.147  1.00  0.00           C  
ATOM    675  NZ  LYS A  45      32.377  78.165 -20.190  1.00  0.00           N  
ATOM    676  H   LYS A  45      33.731  75.322 -17.033  1.00  0.00           H  
ATOM    677  HA  LYS A  45      32.639  76.949 -15.879  1.00  0.00           H  
ATOM    678  HB2 LYS A  45      30.354  75.210 -16.758  1.00  0.00           H  
ATOM    679  HB3 LYS A  45      30.068  76.604 -15.724  1.00  0.00           H  
ATOM    680  HG2 LYS A  45      29.708  77.420 -17.865  1.00  0.00           H  
ATOM    681  HG3 LYS A  45      31.356  77.935 -17.498  1.00  0.00           H  
ATOM    682  HD2 LYS A  45      32.234  76.028 -18.750  1.00  0.00           H  
ATOM    683  HD3 LYS A  45      30.588  75.499 -19.107  1.00  0.00           H  
ATOM    684  HE2 LYS A  45      31.196  76.641 -21.033  1.00  0.00           H  
ATOM    685  HE3 LYS A  45      30.296  77.853 -20.123  1.00  0.00           H  
ATOM    686  HZ1 LYS A  45      33.233  77.653 -19.895  1.00  0.00           H  
ATOM    687  HZ2 LYS A  45      32.230  78.972 -19.550  1.00  0.00           H  
ATOM    688  HZ3 LYS A  45      32.516  78.526 -21.156  1.00  0.00           H  
ATOM    689  N   GLN A  46      33.055  75.003 -13.844  1.00  0.00           N  
ATOM    690  CA  GLN A  46      33.056  74.543 -12.460  1.00  0.00           C  
ATOM    691  C   GLN A  46      34.460  74.605 -11.867  1.00  0.00           C  
ATOM    692  O   GLN A  46      35.453  74.456 -12.579  1.00  0.00           O  
ATOM    693  CB  GLN A  46      32.516  73.115 -12.375  1.00  0.00           C  
ATOM    694  CG  GLN A  46      33.563  72.050 -12.661  1.00  0.00           C  
ATOM    695  CD  GLN A  46      33.082  70.653 -12.322  1.00  0.00           C  
ATOM    696  OE1 GLN A  46      32.444  70.437 -11.292  1.00  0.00           O  
ATOM    697  NE2 GLN A  46      33.387  69.694 -13.189  1.00  0.00           N  
ATOM    698  H   GLN A  46      33.864  74.891 -14.385  1.00  0.00           H  
ATOM    699  HA  GLN A  46      32.410  75.196 -11.894  1.00  0.00           H  
ATOM    700  HB2 GLN A  46      32.126  72.948 -11.382  1.00  0.00           H  
ATOM    701  HB3 GLN A  46      31.714  73.002 -13.091  1.00  0.00           H  
ATOM    702  HG2 GLN A  46      33.812  72.083 -13.712  1.00  0.00           H  
ATOM    703  HG3 GLN A  46      34.444  72.265 -12.076  1.00  0.00           H  
ATOM    704 HE21 GLN A  46      33.899  69.940 -13.988  1.00  0.00           H  
ATOM    705 HE22 GLN A  46      33.090  68.783 -12.995  1.00  0.00           H  
ATOM    706  N   VAL A  47      34.534  74.827 -10.559  1.00  0.00           N  
ATOM    707  CA  VAL A  47      35.816  74.908  -9.869  1.00  0.00           C  
ATOM    708  C   VAL A  47      36.110  73.622  -9.103  1.00  0.00           C  
ATOM    709  O   VAL A  47      35.306  73.175  -8.286  1.00  0.00           O  
ATOM    710  CB  VAL A  47      35.853  76.095  -8.889  1.00  0.00           C  
ATOM    711  CG1 VAL A  47      37.274  76.347  -8.409  1.00  0.00           C  
ATOM    712  CG2 VAL A  47      35.272  77.340  -9.542  1.00  0.00           C  
ATOM    713  H   VAL A  47      33.707  74.937 -10.044  1.00  0.00           H  
ATOM    714  HA  VAL A  47      36.586  75.056 -10.612  1.00  0.00           H  
ATOM    715  HB  VAL A  47      35.245  75.847  -8.032  1.00  0.00           H  
ATOM    716 HG11 VAL A  47      37.384  77.389  -8.142  1.00  0.00           H  
ATOM    717 HG12 VAL A  47      37.477  75.730  -7.546  1.00  0.00           H  
ATOM    718 HG13 VAL A  47      37.969  76.104  -9.199  1.00  0.00           H  
ATOM    719 HG21 VAL A  47      34.467  77.725  -8.933  1.00  0.00           H  
ATOM    720 HG22 VAL A  47      36.044  78.091  -9.634  1.00  0.00           H  
ATOM    721 HG23 VAL A  47      34.894  77.091 -10.523  1.00  0.00           H  
ATOM    722  N   LYS A  48      37.270  73.032  -9.372  1.00  0.00           N  
ATOM    723  CA  LYS A  48      37.673  71.798  -8.708  1.00  0.00           C  
ATOM    724  C   LYS A  48      38.937  72.014  -7.882  1.00  0.00           C  
ATOM    725  O   LYS A  48      39.554  73.077  -7.939  1.00  0.00           O  
ATOM    726  CB  LYS A  48      37.908  70.693  -9.740  1.00  0.00           C  
ATOM    727  CG  LYS A  48      36.628  70.161 -10.363  1.00  0.00           C  
ATOM    728  CD  LYS A  48      36.766  68.702 -10.763  1.00  0.00           C  
ATOM    729  CE  LYS A  48      35.742  68.313 -11.818  1.00  0.00           C  
ATOM    730  NZ  LYS A  48      36.006  66.958 -12.375  1.00  0.00           N  
ATOM    731  H   LYS A  48      37.870  73.436 -10.035  1.00  0.00           H  
ATOM    732  HA  LYS A  48      36.873  71.500  -8.048  1.00  0.00           H  
ATOM    733  HB2 LYS A  48      38.534  71.080 -10.529  1.00  0.00           H  
ATOM    734  HB3 LYS A  48      38.416  69.870  -9.259  1.00  0.00           H  
ATOM    735  HG2 LYS A  48      35.825  70.253  -9.648  1.00  0.00           H  
ATOM    736  HG3 LYS A  48      36.399  70.745 -11.243  1.00  0.00           H  
ATOM    737  HD2 LYS A  48      37.757  68.539 -11.162  1.00  0.00           H  
ATOM    738  HD3 LYS A  48      36.622  68.083  -9.888  1.00  0.00           H  
ATOM    739  HE2 LYS A  48      34.760  68.324 -11.369  1.00  0.00           H  
ATOM    740  HE3 LYS A  48      35.779  69.036 -12.619  1.00  0.00           H  
ATOM    741  HZ1 LYS A  48      36.026  66.995 -13.414  1.00  0.00           H  
ATOM    742  HZ2 LYS A  48      35.260  66.298 -12.077  1.00  0.00           H  
ATOM    743  HZ3 LYS A  48      36.923  66.604 -12.034  1.00  0.00           H  
ATOM    744  N   TYR A  49      39.318  70.997  -7.116  1.00  0.00           N  
ATOM    745  CA  TYR A  49      40.508  71.075  -6.279  1.00  0.00           C  
ATOM    746  C   TYR A  49      41.120  69.693  -6.070  1.00  0.00           C  
ATOM    747  O   TYR A  49      40.473  68.788  -5.544  1.00  0.00           O  
ATOM    748  CB  TYR A  49      40.165  71.703  -4.926  1.00  0.00           C  
ATOM    749  CG  TYR A  49      39.267  72.915  -5.031  1.00  0.00           C  
ATOM    750  CD1 TYR A  49      37.955  72.795  -5.473  1.00  0.00           C  
ATOM    751  CD2 TYR A  49      39.730  74.179  -4.688  1.00  0.00           C  
ATOM    752  CE1 TYR A  49      37.131  73.900  -5.571  1.00  0.00           C  
ATOM    753  CE2 TYR A  49      38.913  75.289  -4.782  1.00  0.00           C  
ATOM    754  CZ  TYR A  49      37.615  75.144  -5.224  1.00  0.00           C  
ATOM    755  OH  TYR A  49      36.797  76.247  -5.320  1.00  0.00           O  
ATOM    756  H   TYR A  49      38.786  70.174  -7.113  1.00  0.00           H  
ATOM    757  HA  TYR A  49      41.228  71.703  -6.782  1.00  0.00           H  
ATOM    758  HB2 TYR A  49      39.662  70.970  -4.314  1.00  0.00           H  
ATOM    759  HB3 TYR A  49      41.078  72.008  -4.436  1.00  0.00           H  
ATOM    760  HD1 TYR A  49      37.580  71.819  -5.743  1.00  0.00           H  
ATOM    761  HD2 TYR A  49      40.748  74.288  -4.341  1.00  0.00           H  
ATOM    762  HE1 TYR A  49      36.114  73.787  -5.918  1.00  0.00           H  
ATOM    763  HE2 TYR A  49      39.291  76.263  -4.510  1.00  0.00           H  
ATOM    764  HH  TYR A  49      36.077  76.060  -5.926  1.00  0.00           H  
ATOM    765  N   PHE A  50      42.373  69.540  -6.486  1.00  0.00           N  
ATOM    766  CA  PHE A  50      43.075  68.268  -6.345  1.00  0.00           C  
ATOM    767  C   PHE A  50      43.238  67.896  -4.874  1.00  0.00           C  
ATOM    768  O   PHE A  50      44.095  68.441  -4.177  1.00  0.00           O  
ATOM    769  CB  PHE A  50      44.445  68.341  -7.020  1.00  0.00           C  
ATOM    770  CG  PHE A  50      45.143  67.014  -7.106  1.00  0.00           C  
ATOM    771  CD1 PHE A  50      44.447  65.873  -7.471  1.00  0.00           C  
ATOM    772  CD2 PHE A  50      46.495  66.907  -6.821  1.00  0.00           C  
ATOM    773  CE1 PHE A  50      45.086  64.650  -7.548  1.00  0.00           C  
ATOM    774  CE2 PHE A  50      47.140  65.687  -6.898  1.00  0.00           C  
ATOM    775  CZ  PHE A  50      46.435  64.558  -7.263  1.00  0.00           C  
ATOM    776  H   PHE A  50      42.837  70.299  -6.897  1.00  0.00           H  
ATOM    777  HA  PHE A  50      42.483  67.509  -6.833  1.00  0.00           H  
ATOM    778  HB2 PHE A  50      44.325  68.717  -8.025  1.00  0.00           H  
ATOM    779  HB3 PHE A  50      45.079  69.015  -6.462  1.00  0.00           H  
ATOM    780  HD1 PHE A  50      43.393  65.944  -7.694  1.00  0.00           H  
ATOM    781  HD2 PHE A  50      47.048  67.792  -6.535  1.00  0.00           H  
ATOM    782  HE1 PHE A  50      44.533  63.768  -7.834  1.00  0.00           H  
ATOM    783  HE2 PHE A  50      48.195  65.619  -6.674  1.00  0.00           H  
ATOM    784  HZ  PHE A  50      46.936  63.603  -7.323  1.00  0.00           H  
ATOM    785  N   ILE A  51      42.409  66.968  -4.409  1.00  0.00           N  
ATOM    786  CA  ILE A  51      42.462  66.523  -3.023  1.00  0.00           C  
ATOM    787  C   ILE A  51      43.520  65.442  -2.832  1.00  0.00           C  
ATOM    788  O   ILE A  51      43.826  64.687  -3.757  1.00  0.00           O  
ATOM    789  CB  ILE A  51      41.100  65.982  -2.553  1.00  0.00           C  
ATOM    790  CG1 ILE A  51      40.024  67.061  -2.687  1.00  0.00           C  
ATOM    791  CG2 ILE A  51      41.191  65.493  -1.115  1.00  0.00           C  
ATOM    792  CD1 ILE A  51      40.272  68.273  -1.817  1.00  0.00           C  
ATOM    793  H   ILE A  51      41.747  66.572  -5.013  1.00  0.00           H  
ATOM    794  HA  ILE A  51      42.719  67.375  -2.409  1.00  0.00           H  
ATOM    795  HB  ILE A  51      40.836  65.142  -3.177  1.00  0.00           H  
ATOM    796 HG12 ILE A  51      39.980  67.392  -3.712  1.00  0.00           H  
ATOM    797 HG13 ILE A  51      39.067  66.642  -2.407  1.00  0.00           H  
ATOM    798 HG21 ILE A  51      41.864  64.649  -1.063  1.00  0.00           H  
ATOM    799 HG22 ILE A  51      41.564  66.289  -0.488  1.00  0.00           H  
ATOM    800 HG23 ILE A  51      40.212  65.193  -0.773  1.00  0.00           H  
ATOM    801 HD11 ILE A  51      39.416  68.932  -1.864  1.00  0.00           H  
ATOM    802 HD12 ILE A  51      40.428  67.959  -0.796  1.00  0.00           H  
ATOM    803 HD13 ILE A  51      41.148  68.798  -2.171  1.00  0.00           H  
ATOM    804  N   HIS A  52      44.074  65.369  -1.627  1.00  0.00           N  
ATOM    805  CA  HIS A  52      45.097  64.377  -1.312  1.00  0.00           C  
ATOM    806  C   HIS A  52      44.762  63.642  -0.018  1.00  0.00           C  
ATOM    807  O   HIS A  52      45.114  64.091   1.071  1.00  0.00           O  
ATOM    808  CB  HIS A  52      46.466  65.046  -1.193  1.00  0.00           C  
ATOM    809  CG  HIS A  52      47.506  64.173  -0.560  1.00  0.00           C  
ATOM    810  ND1 HIS A  52      48.190  63.195  -1.251  1.00  0.00           N  
ATOM    811  CD2 HIS A  52      47.978  64.137   0.708  1.00  0.00           C  
ATOM    812  CE1 HIS A  52      49.037  62.593  -0.434  1.00  0.00           C  
ATOM    813  NE2 HIS A  52      48.928  63.146   0.760  1.00  0.00           N  
ATOM    814  H   HIS A  52      43.790  65.998  -0.930  1.00  0.00           H  
ATOM    815  HA  HIS A  52      45.125  63.663  -2.122  1.00  0.00           H  
ATOM    816  HB2 HIS A  52      46.816  65.314  -2.179  1.00  0.00           H  
ATOM    817  HB3 HIS A  52      46.372  65.940  -0.593  1.00  0.00           H  
ATOM    818  HD1 HIS A  52      48.071  62.974  -2.197  1.00  0.00           H  
ATOM    819  HD2 HIS A  52      47.665  64.768   1.528  1.00  0.00           H  
ATOM    820  HE1 HIS A  52      49.705  61.788  -0.698  1.00  0.00           H  
ATOM    821  HE2 HIS A  52      49.380  62.833   1.571  1.00  0.00           H  
ATOM    822  N   TYR A  53      44.079  62.509  -0.147  1.00  0.00           N  
ATOM    823  CA  TYR A  53      43.693  61.714   1.012  1.00  0.00           C  
ATOM    824  C   TYR A  53      44.882  61.498   1.944  1.00  0.00           C  
ATOM    825  O   TYR A  53      45.874  60.875   1.569  1.00  0.00           O  
ATOM    826  CB  TYR A  53      43.130  60.363   0.564  1.00  0.00           C  
ATOM    827  CG  TYR A  53      41.837  60.474  -0.212  1.00  0.00           C  
ATOM    828  CD1 TYR A  53      40.807  61.295   0.231  1.00  0.00           C  
ATOM    829  CD2 TYR A  53      41.645  59.756  -1.385  1.00  0.00           C  
ATOM    830  CE1 TYR A  53      39.624  61.399  -0.475  1.00  0.00           C  
ATOM    831  CE2 TYR A  53      40.466  59.855  -2.098  1.00  0.00           C  
ATOM    832  CZ  TYR A  53      39.459  60.677  -1.639  1.00  0.00           C  
ATOM    833  OH  TYR A  53      38.281  60.777  -2.345  1.00  0.00           O  
ATOM    834  H   TYR A  53      43.827  62.202  -1.043  1.00  0.00           H  
ATOM    835  HA  TYR A  53      42.926  62.255   1.545  1.00  0.00           H  
ATOM    836  HB2 TYR A  53      43.853  59.870  -0.066  1.00  0.00           H  
ATOM    837  HB3 TYR A  53      42.944  59.754   1.436  1.00  0.00           H  
ATOM    838  HD1 TYR A  53      40.940  61.859   1.142  1.00  0.00           H  
ATOM    839  HD2 TYR A  53      42.437  59.113  -1.742  1.00  0.00           H  
ATOM    840  HE1 TYR A  53      38.834  62.043  -0.116  1.00  0.00           H  
ATOM    841  HE2 TYR A  53      40.336  59.289  -3.009  1.00  0.00           H  
ATOM    842  HH  TYR A  53      37.787  61.540  -2.036  1.00  0.00           H  
ATOM    843  N   SER A  54      44.771  62.018   3.162  1.00  0.00           N  
ATOM    844  CA  SER A  54      45.837  61.886   4.149  1.00  0.00           C  
ATOM    845  C   SER A  54      46.036  60.425   4.541  1.00  0.00           C  
ATOM    846  O   SER A  54      47.165  59.959   4.685  1.00  0.00           O  
ATOM    847  CB  SER A  54      45.517  62.720   5.391  1.00  0.00           C  
ATOM    848  OG  SER A  54      46.696  63.040   6.109  1.00  0.00           O  
ATOM    849  H   SER A  54      43.954  62.504   3.402  1.00  0.00           H  
ATOM    850  HA  SER A  54      46.749  62.255   3.704  1.00  0.00           H  
ATOM    851  HB2 SER A  54      45.033  63.638   5.091  1.00  0.00           H  
ATOM    852  HB3 SER A  54      44.857  62.160   6.037  1.00  0.00           H  
ATOM    853  HG  SER A  54      46.710  62.553   6.936  1.00  0.00           H  
ATOM    854  N   GLY A  55      44.929  59.709   4.713  1.00  0.00           N  
ATOM    855  CA  GLY A  55      45.004  58.308   5.087  1.00  0.00           C  
ATOM    856  C   GLY A  55      46.201  57.608   4.476  1.00  0.00           C  
ATOM    857  O   GLY A  55      47.092  57.150   5.191  1.00  0.00           O  
ATOM    858  H   GLY A  55      44.056  60.134   4.584  1.00  0.00           H  
ATOM    859  HA2 GLY A  55      45.068  58.237   6.162  1.00  0.00           H  
ATOM    860  HA3 GLY A  55      44.103  57.812   4.757  1.00  0.00           H  
ATOM    861  N   TRP A  56      46.220  57.521   3.151  1.00  0.00           N  
ATOM    862  CA  TRP A  56      47.316  56.869   2.444  1.00  0.00           C  
ATOM    863  C   TRP A  56      47.902  57.789   1.379  1.00  0.00           C  
ATOM    864  O   TRP A  56      47.170  58.480   0.673  1.00  0.00           O  
ATOM    865  CB  TRP A  56      46.833  55.567   1.802  1.00  0.00           C  
ATOM    866  CG  TRP A  56      46.854  54.399   2.740  1.00  0.00           C  
ATOM    867  CD1 TRP A  56      47.723  54.192   3.774  1.00  0.00           C  
ATOM    868  CD2 TRP A  56      45.967  53.274   2.729  1.00  0.00           C  
ATOM    869  NE1 TRP A  56      47.429  53.008   4.406  1.00  0.00           N  
ATOM    870  CE2 TRP A  56      46.355  52.426   3.784  1.00  0.00           C  
ATOM    871  CE3 TRP A  56      44.882  52.902   1.931  1.00  0.00           C  
ATOM    872  CZ2 TRP A  56      45.696  51.231   4.059  1.00  0.00           C  
ATOM    873  CZ3 TRP A  56      44.229  51.715   2.204  1.00  0.00           C  
ATOM    874  CH2 TRP A  56      44.638  50.891   3.262  1.00  0.00           C  
ATOM    875  H   TRP A  56      45.480  57.905   2.635  1.00  0.00           H  
ATOM    876  HA  TRP A  56      48.086  56.638   3.167  1.00  0.00           H  
ATOM    877  HB2 TRP A  56      45.819  55.698   1.456  1.00  0.00           H  
ATOM    878  HB3 TRP A  56      47.470  55.332   0.961  1.00  0.00           H  
ATOM    879  HD1 TRP A  56      48.519  54.869   4.043  1.00  0.00           H  
ATOM    880  HE1 TRP A  56      47.909  52.640   5.178  1.00  0.00           H  
ATOM    881  HE3 TRP A  56      44.552  53.525   1.111  1.00  0.00           H  
ATOM    882  HZ2 TRP A  56      45.998  50.585   4.870  1.00  0.00           H  
ATOM    883  HZ3 TRP A  56      43.389  51.412   1.598  1.00  0.00           H  
ATOM    884  HH2 TRP A  56      44.099  49.974   3.439  1.00  0.00           H  
ATOM    885  N   ASN A  57      49.226  57.793   1.270  1.00  0.00           N  
ATOM    886  CA  ASN A  57      49.910  58.630   0.290  1.00  0.00           C  
ATOM    887  C   ASN A  57      49.510  58.241  -1.130  1.00  0.00           C  
ATOM    888  O   ASN A  57      49.397  57.059  -1.453  1.00  0.00           O  
ATOM    889  CB  ASN A  57      51.426  58.510   0.455  1.00  0.00           C  
ATOM    890  CG  ASN A  57      51.972  59.469   1.497  1.00  0.00           C  
ATOM    891  OD1 ASN A  57      51.301  59.779   2.482  1.00  0.00           O  
ATOM    892  ND2 ASN A  57      53.193  59.942   1.283  1.00  0.00           N  
ATOM    893  H   ASN A  57      49.757  57.220   1.862  1.00  0.00           H  
ATOM    894  HA  ASN A  57      49.616  59.653   0.466  1.00  0.00           H  
ATOM    895  HB2 ASN A  57      51.671  57.502   0.759  1.00  0.00           H  
ATOM    896  HB3 ASN A  57      51.904  58.723  -0.489  1.00  0.00           H  
ATOM    897 HD21 ASN A  57      53.668  59.650   0.476  1.00  0.00           H  
ATOM    898 HD22 ASN A  57      53.571  60.563   1.940  1.00  0.00           H  
ATOM    899  N   LYS A  58      49.298  59.245  -1.975  1.00  0.00           N  
ATOM    900  CA  LYS A  58      48.913  59.010  -3.362  1.00  0.00           C  
ATOM    901  C   LYS A  58      47.877  57.895  -3.457  1.00  0.00           C  
ATOM    902  O   LYS A  58      48.002  56.987  -4.279  1.00  0.00           O  
ATOM    903  CB  LYS A  58      50.142  58.652  -4.200  1.00  0.00           C  
ATOM    904  CG  LYS A  58      50.033  59.082  -5.653  1.00  0.00           C  
ATOM    905  CD  LYS A  58      49.311  58.040  -6.491  1.00  0.00           C  
ATOM    906  CE  LYS A  58      49.413  58.350  -7.976  1.00  0.00           C  
ATOM    907  NZ  LYS A  58      48.664  59.585  -8.337  1.00  0.00           N  
ATOM    908  H   LYS A  58      49.405  60.166  -1.658  1.00  0.00           H  
ATOM    909  HA  LYS A  58      48.479  59.921  -3.744  1.00  0.00           H  
ATOM    910  HB2 LYS A  58      51.009  59.131  -3.770  1.00  0.00           H  
ATOM    911  HB3 LYS A  58      50.282  57.581  -4.173  1.00  0.00           H  
ATOM    912  HG2 LYS A  58      49.485  60.011  -5.704  1.00  0.00           H  
ATOM    913  HG3 LYS A  58      51.027  59.225  -6.053  1.00  0.00           H  
ATOM    914  HD2 LYS A  58      49.754  57.072  -6.305  1.00  0.00           H  
ATOM    915  HD3 LYS A  58      48.269  58.021  -6.206  1.00  0.00           H  
ATOM    916  HE2 LYS A  58      50.453  58.482  -8.233  1.00  0.00           H  
ATOM    917  HE3 LYS A  58      49.008  57.517  -8.533  1.00  0.00           H  
ATOM    918  HZ1 LYS A  58      48.946  59.910  -9.283  1.00  0.00           H  
ATOM    919  HZ2 LYS A  58      48.864  60.338  -7.648  1.00  0.00           H  
ATOM    920  HZ3 LYS A  58      47.642  59.395  -8.338  1.00  0.00           H  
ATOM    921  N   ASN A  59      46.854  57.970  -2.613  1.00  0.00           N  
ATOM    922  CA  ASN A  59      45.796  56.966  -2.603  1.00  0.00           C  
ATOM    923  C   ASN A  59      44.783  57.233  -3.713  1.00  0.00           C  
ATOM    924  O   ASN A  59      43.706  57.774  -3.466  1.00  0.00           O  
ATOM    925  CB  ASN A  59      45.090  56.952  -1.245  1.00  0.00           C  
ATOM    926  CG  ASN A  59      44.434  55.618  -0.949  1.00  0.00           C  
ATOM    927  OD1 ASN A  59      45.009  54.560  -1.208  1.00  0.00           O  
ATOM    928  ND2 ASN A  59      43.224  55.661  -0.403  1.00  0.00           N  
ATOM    929  H   ASN A  59      46.809  58.717  -1.980  1.00  0.00           H  
ATOM    930  HA  ASN A  59      46.251  56.002  -2.772  1.00  0.00           H  
ATOM    931  HB2 ASN A  59      45.812  57.157  -0.469  1.00  0.00           H  
ATOM    932  HB3 ASN A  59      44.329  57.717  -1.235  1.00  0.00           H  
ATOM    933 HD21 ASN A  59      42.828  56.539  -0.226  1.00  0.00           H  
ATOM    934 HD22 ASN A  59      42.778  54.813  -0.200  1.00  0.00           H  
ATOM    935  N   TRP A  60      45.137  56.848  -4.934  1.00  0.00           N  
ATOM    936  CA  TRP A  60      44.259  57.046  -6.082  1.00  0.00           C  
ATOM    937  C   TRP A  60      43.646  58.442  -6.064  1.00  0.00           C  
ATOM    938  O   TRP A  60      42.467  58.616  -6.378  1.00  0.00           O  
ATOM    939  CB  TRP A  60      43.153  55.990  -6.091  1.00  0.00           C  
ATOM    940  CG  TRP A  60      43.660  54.597  -5.868  1.00  0.00           C  
ATOM    941  CD1 TRP A  60      44.466  53.874  -6.702  1.00  0.00           C  
ATOM    942  CD2 TRP A  60      43.394  53.759  -4.739  1.00  0.00           C  
ATOM    943  NE1 TRP A  60      44.717  52.638  -6.159  1.00  0.00           N  
ATOM    944  CE2 TRP A  60      44.071  52.542  -4.955  1.00  0.00           C  
ATOM    945  CE3 TRP A  60      42.651  53.917  -3.566  1.00  0.00           C  
ATOM    946  CZ2 TRP A  60      44.024  51.492  -4.041  1.00  0.00           C  
ATOM    947  CZ3 TRP A  60      42.605  52.874  -2.661  1.00  0.00           C  
ATOM    948  CH2 TRP A  60      43.290  51.675  -2.901  1.00  0.00           C  
ATOM    949  H   TRP A  60      46.010  56.423  -5.067  1.00  0.00           H  
ATOM    950  HA  TRP A  60      44.855  56.939  -6.976  1.00  0.00           H  
ATOM    951  HB2 TRP A  60      42.442  56.214  -5.310  1.00  0.00           H  
ATOM    952  HB3 TRP A  60      42.651  56.013  -7.048  1.00  0.00           H  
ATOM    953  HD1 TRP A  60      44.842  54.236  -7.647  1.00  0.00           H  
ATOM    954  HE1 TRP A  60      45.269  51.939  -6.567  1.00  0.00           H  
ATOM    955  HE3 TRP A  60      42.116  54.833  -3.363  1.00  0.00           H  
ATOM    956  HZ2 TRP A  60      44.547  50.563  -4.211  1.00  0.00           H  
ATOM    957  HZ3 TRP A  60      42.036  52.979  -1.748  1.00  0.00           H  
ATOM    958  HH2 TRP A  60      43.226  50.888  -2.166  1.00  0.00           H  
ATOM    959  N   ASP A  61      44.450  59.433  -5.696  1.00  0.00           N  
ATOM    960  CA  ASP A  61      43.986  60.813  -5.639  1.00  0.00           C  
ATOM    961  C   ASP A  61      42.969  61.091  -6.742  1.00  0.00           C  
ATOM    962  O   ASP A  61      43.013  60.479  -7.808  1.00  0.00           O  
ATOM    963  CB  ASP A  61      45.167  61.777  -5.764  1.00  0.00           C  
ATOM    964  CG  ASP A  61      45.852  62.029  -4.436  1.00  0.00           C  
ATOM    965  OD1 ASP A  61      46.211  61.044  -3.757  1.00  0.00           O  
ATOM    966  OD2 ASP A  61      46.030  63.212  -4.074  1.00  0.00           O  
ATOM    967  H   ASP A  61      45.379  59.229  -5.457  1.00  0.00           H  
ATOM    968  HA  ASP A  61      43.510  60.965  -4.681  1.00  0.00           H  
ATOM    969  HB2 ASP A  61      45.892  61.360  -6.449  1.00  0.00           H  
ATOM    970  HB3 ASP A  61      44.814  62.721  -6.152  1.00  0.00           H  
ATOM    971  N   GLU A  62      42.052  62.017  -6.475  1.00  0.00           N  
ATOM    972  CA  GLU A  62      41.023  62.372  -7.445  1.00  0.00           C  
ATOM    973  C   GLU A  62      40.631  63.841  -7.308  1.00  0.00           C  
ATOM    974  O   GLU A  62      40.800  64.443  -6.248  1.00  0.00           O  
ATOM    975  CB  GLU A  62      39.790  61.485  -7.262  1.00  0.00           C  
ATOM    976  CG  GLU A  62      39.460  61.194  -5.808  1.00  0.00           C  
ATOM    977  CD  GLU A  62      40.316  60.086  -5.226  1.00  0.00           C  
ATOM    978  OE1 GLU A  62      39.943  58.905  -5.376  1.00  0.00           O  
ATOM    979  OE2 GLU A  62      41.362  60.402  -4.619  1.00  0.00           O  
ATOM    980  H   GLU A  62      42.069  62.470  -5.607  1.00  0.00           H  
ATOM    981  HA  GLU A  62      41.428  62.212  -8.432  1.00  0.00           H  
ATOM    982  HB2 GLU A  62      38.939  61.975  -7.712  1.00  0.00           H  
ATOM    983  HB3 GLU A  62      39.960  60.545  -7.766  1.00  0.00           H  
ATOM    984  HG2 GLU A  62      39.618  62.092  -5.229  1.00  0.00           H  
ATOM    985  HG3 GLU A  62      38.423  60.901  -5.739  1.00  0.00           H  
ATOM    986  N   TRP A  63      40.108  64.410  -8.387  1.00  0.00           N  
ATOM    987  CA  TRP A  63      39.692  65.809  -8.388  1.00  0.00           C  
ATOM    988  C   TRP A  63      38.261  65.951  -7.883  1.00  0.00           C  
ATOM    989  O   TRP A  63      37.391  65.146  -8.214  1.00  0.00           O  
ATOM    990  CB  TRP A  63      39.809  66.396  -9.796  1.00  0.00           C  
ATOM    991  CG  TRP A  63      41.212  66.773 -10.167  1.00  0.00           C  
ATOM    992  CD1 TRP A  63      42.131  65.988 -10.804  1.00  0.00           C  
ATOM    993  CD2 TRP A  63      41.855  68.028  -9.922  1.00  0.00           C  
ATOM    994  NE1 TRP A  63      43.306  66.680 -10.969  1.00  0.00           N  
ATOM    995  CE2 TRP A  63      43.162  67.934 -10.438  1.00  0.00           C  
ATOM    996  CE3 TRP A  63      41.453  69.223  -9.319  1.00  0.00           C  
ATOM    997  CZ2 TRP A  63      44.068  68.989 -10.367  1.00  0.00           C  
ATOM    998  CZ3 TRP A  63      42.354  70.269  -9.249  1.00  0.00           C  
ATOM    999  CH2 TRP A  63      43.648  70.147  -9.771  1.00  0.00           C  
ATOM   1000  H   TRP A  63      39.999  63.879  -9.204  1.00  0.00           H  
ATOM   1001  HA  TRP A  63      40.352  66.350  -7.726  1.00  0.00           H  
ATOM   1002  HB2 TRP A  63      39.459  65.668 -10.513  1.00  0.00           H  
ATOM   1003  HB3 TRP A  63      39.197  67.284  -9.859  1.00  0.00           H  
ATOM   1004  HD1 TRP A  63      41.946  64.974 -11.123  1.00  0.00           H  
ATOM   1005  HE1 TRP A  63      44.115  66.332 -11.400  1.00  0.00           H  
ATOM   1006  HE3 TRP A  63      40.460  69.337  -8.911  1.00  0.00           H  
ATOM   1007  HZ2 TRP A  63      45.069  68.911 -10.765  1.00  0.00           H  
ATOM   1008  HZ3 TRP A  63      42.061  71.200  -8.786  1.00  0.00           H  
ATOM   1009  HH2 TRP A  63      44.318  70.990  -9.694  1.00  0.00           H  
ATOM   1010  N   VAL A  64      38.023  66.982  -7.077  1.00  0.00           N  
ATOM   1011  CA  VAL A  64      36.695  67.230  -6.526  1.00  0.00           C  
ATOM   1012  C   VAL A  64      36.282  68.684  -6.725  1.00  0.00           C  
ATOM   1013  O   VAL A  64      37.114  69.589  -6.790  1.00  0.00           O  
ATOM   1014  CB  VAL A  64      36.639  66.892  -5.024  1.00  0.00           C  
ATOM   1015  CG1 VAL A  64      37.418  65.618  -4.734  1.00  0.00           C  
ATOM   1016  CG2 VAL A  64      37.171  68.053  -4.198  1.00  0.00           C  
ATOM   1017  H   VAL A  64      38.756  67.589  -6.849  1.00  0.00           H  
ATOM   1018  HA  VAL A  64      35.994  66.593  -7.044  1.00  0.00           H  
ATOM   1019  HB  VAL A  64      35.607  66.727  -4.752  1.00  0.00           H  
ATOM   1020 HG11 VAL A  64      36.800  64.942  -4.162  1.00  0.00           H  
ATOM   1021 HG12 VAL A  64      37.701  65.150  -5.665  1.00  0.00           H  
ATOM   1022 HG13 VAL A  64      38.305  65.861  -4.167  1.00  0.00           H  
ATOM   1023 HG21 VAL A  64      37.546  67.682  -3.255  1.00  0.00           H  
ATOM   1024 HG22 VAL A  64      37.970  68.542  -4.736  1.00  0.00           H  
ATOM   1025 HG23 VAL A  64      36.375  68.760  -4.014  1.00  0.00           H  
ATOM   1026  N   PRO A  65      34.965  68.917  -6.823  1.00  0.00           N  
ATOM   1027  CA  PRO A  65      34.410  70.260  -7.014  1.00  0.00           C  
ATOM   1028  C   PRO A  65      34.571  71.136  -5.777  1.00  0.00           C  
ATOM   1029  O   PRO A  65      35.328  70.804  -4.866  1.00  0.00           O  
ATOM   1030  CB  PRO A  65      32.928  69.995  -7.293  1.00  0.00           C  
ATOM   1031  CG  PRO A  65      32.648  68.686  -6.639  1.00  0.00           C  
ATOM   1032  CD  PRO A  65      33.916  67.886  -6.755  1.00  0.00           C  
ATOM   1033  HA  PRO A  65      34.854  70.755  -7.866  1.00  0.00           H  
ATOM   1034  HB2 PRO A  65      32.331  70.787  -6.864  1.00  0.00           H  
ATOM   1035  HB3 PRO A  65      32.761  69.947  -8.359  1.00  0.00           H  
ATOM   1036  HG2 PRO A  65      32.395  68.841  -5.601  1.00  0.00           H  
ATOM   1037  HG3 PRO A  65      31.840  68.184  -7.153  1.00  0.00           H  
ATOM   1038  HD2 PRO A  65      34.046  67.259  -5.885  1.00  0.00           H  
ATOM   1039  HD3 PRO A  65      33.904  67.287  -7.654  1.00  0.00           H  
ATOM   1040  N   GLU A  66      33.854  72.254  -5.752  1.00  0.00           N  
ATOM   1041  CA  GLU A  66      33.918  73.178  -4.625  1.00  0.00           C  
ATOM   1042  C   GLU A  66      32.864  72.832  -3.577  1.00  0.00           C  
ATOM   1043  O   GLU A  66      32.910  73.323  -2.449  1.00  0.00           O  
ATOM   1044  CB  GLU A  66      33.723  74.617  -5.105  1.00  0.00           C  
ATOM   1045  CG  GLU A  66      33.990  75.658  -4.029  1.00  0.00           C  
ATOM   1046  CD  GLU A  66      33.421  77.019  -4.381  1.00  0.00           C  
ATOM   1047  OE1 GLU A  66      32.207  77.227  -4.173  1.00  0.00           O  
ATOM   1048  OE2 GLU A  66      34.190  77.876  -4.865  1.00  0.00           O  
ATOM   1049  H   GLU A  66      33.266  72.463  -6.509  1.00  0.00           H  
ATOM   1050  HA  GLU A  66      34.896  73.085  -4.177  1.00  0.00           H  
ATOM   1051  HB2 GLU A  66      34.394  74.802  -5.931  1.00  0.00           H  
ATOM   1052  HB3 GLU A  66      32.706  74.735  -5.446  1.00  0.00           H  
ATOM   1053  HG2 GLU A  66      33.541  75.325  -3.105  1.00  0.00           H  
ATOM   1054  HG3 GLU A  66      35.057  75.753  -3.897  1.00  0.00           H  
ATOM   1055  N   SER A  67      31.913  71.984  -3.959  1.00  0.00           N  
ATOM   1056  CA  SER A  67      30.845  71.576  -3.056  1.00  0.00           C  
ATOM   1057  C   SER A  67      31.236  70.318  -2.285  1.00  0.00           C  
ATOM   1058  O   SER A  67      30.659  70.012  -1.242  1.00  0.00           O  
ATOM   1059  CB  SER A  67      29.553  71.328  -3.837  1.00  0.00           C  
ATOM   1060  OG  SER A  67      28.421  71.401  -2.988  1.00  0.00           O  
ATOM   1061  H   SER A  67      31.931  71.627  -4.872  1.00  0.00           H  
ATOM   1062  HA  SER A  67      30.682  72.378  -2.351  1.00  0.00           H  
ATOM   1063  HB2 SER A  67      29.456  72.073  -4.612  1.00  0.00           H  
ATOM   1064  HB3 SER A  67      29.590  70.345  -4.285  1.00  0.00           H  
ATOM   1065  HG  SER A  67      27.897  72.173  -3.220  1.00  0.00           H  
ATOM   1066  N   ARG A  68      32.220  69.593  -2.808  1.00  0.00           N  
ATOM   1067  CA  ARG A  68      32.687  68.368  -2.171  1.00  0.00           C  
ATOM   1068  C   ARG A  68      33.767  68.671  -1.136  1.00  0.00           C  
ATOM   1069  O   ARG A  68      34.188  67.790  -0.387  1.00  0.00           O  
ATOM   1070  CB  ARG A  68      33.230  67.398  -3.222  1.00  0.00           C  
ATOM   1071  CG  ARG A  68      32.151  66.577  -3.909  1.00  0.00           C  
ATOM   1072  CD  ARG A  68      32.681  65.223  -4.355  1.00  0.00           C  
ATOM   1073  NE  ARG A  68      31.926  64.686  -5.485  1.00  0.00           N  
ATOM   1074  CZ  ARG A  68      32.359  63.689  -6.249  1.00  0.00           C  
ATOM   1075  NH1 ARG A  68      33.533  63.124  -6.007  1.00  0.00           N  
ATOM   1076  NH2 ARG A  68      31.614  63.255  -7.259  1.00  0.00           N  
ATOM   1077  H   ARG A  68      32.640  69.889  -3.642  1.00  0.00           H  
ATOM   1078  HA  ARG A  68      31.845  67.911  -1.673  1.00  0.00           H  
ATOM   1079  HB2 ARG A  68      33.758  67.961  -3.977  1.00  0.00           H  
ATOM   1080  HB3 ARG A  68      33.920  66.718  -2.743  1.00  0.00           H  
ATOM   1081  HG2 ARG A  68      31.336  66.421  -3.217  1.00  0.00           H  
ATOM   1082  HG3 ARG A  68      31.796  67.118  -4.772  1.00  0.00           H  
ATOM   1083  HD2 ARG A  68      33.715  65.334  -4.646  1.00  0.00           H  
ATOM   1084  HD3 ARG A  68      32.612  64.534  -3.527  1.00  0.00           H  
ATOM   1085  HE  ARG A  68      31.056  65.090  -5.682  1.00  0.00           H  
ATOM   1086 HH11 ARG A  68      34.095  63.447  -5.246  1.00  0.00           H  
ATOM   1087 HH12 ARG A  68      33.855  62.373  -6.583  1.00  0.00           H  
ATOM   1088 HH21 ARG A  68      30.728  63.680  -7.445  1.00  0.00           H  
ATOM   1089 HH22 ARG A  68      31.940  62.505  -7.834  1.00  0.00           H  
ATOM   1090  N   VAL A  69      34.211  69.923  -1.101  1.00  0.00           N  
ATOM   1091  CA  VAL A  69      35.240  70.343  -0.158  1.00  0.00           C  
ATOM   1092  C   VAL A  69      34.661  71.253   0.919  1.00  0.00           C  
ATOM   1093  O   VAL A  69      33.818  72.107   0.639  1.00  0.00           O  
ATOM   1094  CB  VAL A  69      36.389  71.079  -0.873  1.00  0.00           C  
ATOM   1095  CG1 VAL A  69      37.587  71.228   0.054  1.00  0.00           C  
ATOM   1096  CG2 VAL A  69      36.779  70.346  -2.148  1.00  0.00           C  
ATOM   1097  H   VAL A  69      33.836  70.581  -1.724  1.00  0.00           H  
ATOM   1098  HA  VAL A  69      35.644  69.458   0.311  1.00  0.00           H  
ATOM   1099  HB  VAL A  69      36.046  72.067  -1.142  1.00  0.00           H  
ATOM   1100 HG11 VAL A  69      38.381  71.743  -0.466  1.00  0.00           H  
ATOM   1101 HG12 VAL A  69      37.298  71.793   0.927  1.00  0.00           H  
ATOM   1102 HG13 VAL A  69      37.932  70.249   0.355  1.00  0.00           H  
ATOM   1103 HG21 VAL A  69      35.925  70.287  -2.805  1.00  0.00           H  
ATOM   1104 HG22 VAL A  69      37.577  70.881  -2.640  1.00  0.00           H  
ATOM   1105 HG23 VAL A  69      37.113  69.347  -1.902  1.00  0.00           H  
ATOM   1106  N   LEU A  70      35.119  71.067   2.152  1.00  0.00           N  
ATOM   1107  CA  LEU A  70      34.647  71.872   3.273  1.00  0.00           C  
ATOM   1108  C   LEU A  70      35.748  72.800   3.779  1.00  0.00           C  
ATOM   1109  O   LEU A  70      36.926  72.607   3.476  1.00  0.00           O  
ATOM   1110  CB  LEU A  70      34.164  70.969   4.408  1.00  0.00           C  
ATOM   1111  CG  LEU A  70      33.222  69.833   4.007  1.00  0.00           C  
ATOM   1112  CD1 LEU A  70      32.818  69.018   5.226  1.00  0.00           C  
ATOM   1113  CD2 LEU A  70      31.992  70.385   3.301  1.00  0.00           C  
ATOM   1114  H   LEU A  70      35.791  70.373   2.314  1.00  0.00           H  
ATOM   1115  HA  LEU A  70      33.819  72.473   2.925  1.00  0.00           H  
ATOM   1116  HB2 LEU A  70      35.033  70.528   4.873  1.00  0.00           H  
ATOM   1117  HB3 LEU A  70      33.649  71.589   5.128  1.00  0.00           H  
ATOM   1118  HG  LEU A  70      33.735  69.173   3.321  1.00  0.00           H  
ATOM   1119 HD11 LEU A  70      32.076  69.562   5.792  1.00  0.00           H  
ATOM   1120 HD12 LEU A  70      33.685  68.843   5.845  1.00  0.00           H  
ATOM   1121 HD13 LEU A  70      32.407  68.072   4.907  1.00  0.00           H  
ATOM   1122 HD21 LEU A  70      31.333  70.838   4.026  1.00  0.00           H  
ATOM   1123 HD22 LEU A  70      31.475  69.581   2.798  1.00  0.00           H  
ATOM   1124 HD23 LEU A  70      32.296  71.127   2.576  1.00  0.00           H  
ATOM   1125  N   LYS A  71      35.357  73.806   4.554  1.00  0.00           N  
ATOM   1126  CA  LYS A  71      36.310  74.761   5.106  1.00  0.00           C  
ATOM   1127  C   LYS A  71      36.967  74.207   6.366  1.00  0.00           C  
ATOM   1128  O   LYS A  71      37.685  74.921   7.068  1.00  0.00           O  
ATOM   1129  CB  LYS A  71      35.609  76.085   5.423  1.00  0.00           C  
ATOM   1130  CG  LYS A  71      35.179  76.857   4.188  1.00  0.00           C  
ATOM   1131  CD  LYS A  71      34.019  76.176   3.481  1.00  0.00           C  
ATOM   1132  CE  LYS A  71      33.521  77.002   2.305  1.00  0.00           C  
ATOM   1133  NZ  LYS A  71      34.643  77.499   1.461  1.00  0.00           N  
ATOM   1134  H   LYS A  71      34.403  73.907   4.761  1.00  0.00           H  
ATOM   1135  HA  LYS A  71      37.072  74.936   4.363  1.00  0.00           H  
ATOM   1136  HB2 LYS A  71      34.732  75.881   6.019  1.00  0.00           H  
ATOM   1137  HB3 LYS A  71      36.284  76.708   5.994  1.00  0.00           H  
ATOM   1138  HG2 LYS A  71      34.876  77.850   4.482  1.00  0.00           H  
ATOM   1139  HG3 LYS A  71      36.017  76.922   3.506  1.00  0.00           H  
ATOM   1140  HD2 LYS A  71      34.346  75.213   3.117  1.00  0.00           H  
ATOM   1141  HD3 LYS A  71      33.210  76.042   4.185  1.00  0.00           H  
ATOM   1142  HE2 LYS A  71      32.872  76.389   1.700  1.00  0.00           H  
ATOM   1143  HE3 LYS A  71      32.966  77.846   2.685  1.00  0.00           H  
ATOM   1144  HZ1 LYS A  71      35.506  76.951   1.654  1.00  0.00           H  
ATOM   1145  HZ2 LYS A  71      34.828  78.501   1.667  1.00  0.00           H  
ATOM   1146  HZ3 LYS A  71      34.403  77.403   0.454  1.00  0.00           H  
ATOM   1147  N   TYR A  72      36.719  72.933   6.647  1.00  0.00           N  
ATOM   1148  CA  TYR A  72      37.286  72.284   7.823  1.00  0.00           C  
ATOM   1149  C   TYR A  72      37.036  73.116   9.078  1.00  0.00           C  
ATOM   1150  O   TYR A  72      37.914  73.255   9.929  1.00  0.00           O  
ATOM   1151  CB  TYR A  72      38.788  72.064   7.635  1.00  0.00           C  
ATOM   1152  CG  TYR A  72      39.318  70.849   8.362  1.00  0.00           C  
ATOM   1153  CD1 TYR A  72      39.688  70.921   9.699  1.00  0.00           C  
ATOM   1154  CD2 TYR A  72      39.448  69.628   7.712  1.00  0.00           C  
ATOM   1155  CE1 TYR A  72      40.172  69.813  10.367  1.00  0.00           C  
ATOM   1156  CE2 TYR A  72      39.931  68.515   8.372  1.00  0.00           C  
ATOM   1157  CZ  TYR A  72      40.292  68.612   9.700  1.00  0.00           C  
ATOM   1158  OH  TYR A  72      40.774  67.506  10.360  1.00  0.00           O  
ATOM   1159  H   TYR A  72      36.139  72.416   6.050  1.00  0.00           H  
ATOM   1160  HA  TYR A  72      36.803  71.325   7.938  1.00  0.00           H  
ATOM   1161  HB2 TYR A  72      38.998  71.938   6.584  1.00  0.00           H  
ATOM   1162  HB3 TYR A  72      39.321  72.929   8.002  1.00  0.00           H  
ATOM   1163  HD1 TYR A  72      39.593  71.864  10.219  1.00  0.00           H  
ATOM   1164  HD2 TYR A  72      39.165  69.555   6.671  1.00  0.00           H  
ATOM   1165  HE1 TYR A  72      40.454  69.889  11.407  1.00  0.00           H  
ATOM   1166  HE2 TYR A  72      40.025  67.575   7.849  1.00  0.00           H  
ATOM   1167  HH  TYR A  72      41.273  66.960   9.749  1.00  0.00           H  
ATOM   1168  N   VAL A  73      35.831  73.666   9.184  1.00  0.00           N  
ATOM   1169  CA  VAL A  73      35.462  74.481  10.335  1.00  0.00           C  
ATOM   1170  C   VAL A  73      34.568  73.705  11.296  1.00  0.00           C  
ATOM   1171  O   VAL A  73      33.982  72.686  10.929  1.00  0.00           O  
ATOM   1172  CB  VAL A  73      34.735  75.768   9.901  1.00  0.00           C  
ATOM   1173  CG1 VAL A  73      35.669  76.668   9.107  1.00  0.00           C  
ATOM   1174  CG2 VAL A  73      33.491  75.430   9.091  1.00  0.00           C  
ATOM   1175  H   VAL A  73      35.173  73.518   8.473  1.00  0.00           H  
ATOM   1176  HA  VAL A  73      36.369  74.763  10.850  1.00  0.00           H  
ATOM   1177  HB  VAL A  73      34.426  76.300  10.789  1.00  0.00           H  
ATOM   1178 HG11 VAL A  73      36.586  76.138   8.896  1.00  0.00           H  
ATOM   1179 HG12 VAL A  73      35.194  76.952   8.179  1.00  0.00           H  
ATOM   1180 HG13 VAL A  73      35.891  77.554   9.683  1.00  0.00           H  
ATOM   1181 HG21 VAL A  73      33.210  74.404   9.276  1.00  0.00           H  
ATOM   1182 HG22 VAL A  73      32.684  76.084   9.383  1.00  0.00           H  
ATOM   1183 HG23 VAL A  73      33.700  75.562   8.039  1.00  0.00           H  
ATOM   1184  N   ASP A  74      34.468  74.194  12.527  1.00  0.00           N  
ATOM   1185  CA  ASP A  74      33.644  73.547  13.542  1.00  0.00           C  
ATOM   1186  C   ASP A  74      32.401  72.922  12.915  1.00  0.00           C  
ATOM   1187  O   ASP A  74      32.204  71.709  12.978  1.00  0.00           O  
ATOM   1188  CB  ASP A  74      33.236  74.555  14.617  1.00  0.00           C  
ATOM   1189  CG  ASP A  74      34.313  75.589  14.880  1.00  0.00           C  
ATOM   1190  OD1 ASP A  74      35.507  75.222  14.850  1.00  0.00           O  
ATOM   1191  OD2 ASP A  74      33.964  76.765  15.116  1.00  0.00           O  
ATOM   1192  H   ASP A  74      34.959  75.010  12.759  1.00  0.00           H  
ATOM   1193  HA  ASP A  74      34.233  72.766  13.998  1.00  0.00           H  
ATOM   1194  HB2 ASP A  74      32.340  75.069  14.300  1.00  0.00           H  
ATOM   1195  HB3 ASP A  74      33.036  74.028  15.539  1.00  0.00           H  
ATOM   1196  N   THR A  75      31.564  73.761  12.311  1.00  0.00           N  
ATOM   1197  CA  THR A  75      30.339  73.292  11.676  1.00  0.00           C  
ATOM   1198  C   THR A  75      30.597  72.041  10.844  1.00  0.00           C  
ATOM   1199  O   THR A  75      30.002  70.991  11.084  1.00  0.00           O  
ATOM   1200  CB  THR A  75      29.723  74.377  10.773  1.00  0.00           C  
ATOM   1201  OG1 THR A  75      29.652  75.620  11.481  1.00  0.00           O  
ATOM   1202  CG2 THR A  75      28.333  73.972  10.310  1.00  0.00           C  
ATOM   1203  H   THR A  75      31.777  74.717  12.294  1.00  0.00           H  
ATOM   1204  HA  THR A  75      29.629  73.055  12.454  1.00  0.00           H  
ATOM   1205  HB  THR A  75      30.354  74.502   9.905  1.00  0.00           H  
ATOM   1206  HG1 THR A  75      29.440  75.453  12.403  1.00  0.00           H  
ATOM   1207 HG21 THR A  75      27.648  74.791  10.469  1.00  0.00           H  
ATOM   1208 HG22 THR A  75      28.003  73.111  10.874  1.00  0.00           H  
ATOM   1209 HG23 THR A  75      28.360  73.725   9.260  1.00  0.00           H  
ATOM   1210  N   ASN A  76      31.486  72.160   9.863  1.00  0.00           N  
ATOM   1211  CA  ASN A  76      31.822  71.038   8.994  1.00  0.00           C  
ATOM   1212  C   ASN A  76      32.270  69.831   9.814  1.00  0.00           C  
ATOM   1213  O   ASN A  76      31.895  68.695   9.521  1.00  0.00           O  
ATOM   1214  CB  ASN A  76      32.923  71.438   8.011  1.00  0.00           C  
ATOM   1215  CG  ASN A  76      32.434  72.419   6.963  1.00  0.00           C  
ATOM   1216  OD1 ASN A  76      31.291  72.343   6.511  1.00  0.00           O  
ATOM   1217  ND2 ASN A  76      33.299  73.346   6.570  1.00  0.00           N  
ATOM   1218  H   ASN A  76      31.927  73.023   9.719  1.00  0.00           H  
ATOM   1219  HA  ASN A  76      30.935  70.772   8.439  1.00  0.00           H  
ATOM   1220  HB2 ASN A  76      33.734  71.899   8.556  1.00  0.00           H  
ATOM   1221  HB3 ASN A  76      33.289  70.555   7.509  1.00  0.00           H  
ATOM   1222 HD21 ASN A  76      34.192  73.346   6.973  1.00  0.00           H  
ATOM   1223 HD22 ASN A  76      33.008  73.993   5.894  1.00  0.00           H  
ATOM   1224  N   LEU A  77      33.073  70.086  10.841  1.00  0.00           N  
ATOM   1225  CA  LEU A  77      33.573  69.021  11.703  1.00  0.00           C  
ATOM   1226  C   LEU A  77      32.421  68.252  12.343  1.00  0.00           C  
ATOM   1227  O   LEU A  77      32.434  67.023  12.391  1.00  0.00           O  
ATOM   1228  CB  LEU A  77      34.480  69.602  12.790  1.00  0.00           C  
ATOM   1229  CG  LEU A  77      35.811  70.183  12.314  1.00  0.00           C  
ATOM   1230  CD1 LEU A  77      36.526  70.886  13.458  1.00  0.00           C  
ATOM   1231  CD2 LEU A  77      36.689  69.089  11.725  1.00  0.00           C  
ATOM   1232  H   LEU A  77      33.337  71.011  11.024  1.00  0.00           H  
ATOM   1233  HA  LEU A  77      34.147  68.341  11.092  1.00  0.00           H  
ATOM   1234  HB2 LEU A  77      33.935  70.389  13.290  1.00  0.00           H  
ATOM   1235  HB3 LEU A  77      34.695  68.812  13.496  1.00  0.00           H  
ATOM   1236  HG  LEU A  77      35.621  70.915  11.540  1.00  0.00           H  
ATOM   1237 HD11 LEU A  77      35.908  71.688  13.830  1.00  0.00           H  
ATOM   1238 HD12 LEU A  77      37.463  71.287  13.103  1.00  0.00           H  
ATOM   1239 HD13 LEU A  77      36.716  70.178  14.251  1.00  0.00           H  
ATOM   1240 HD21 LEU A  77      37.481  68.850  12.419  1.00  0.00           H  
ATOM   1241 HD22 LEU A  77      37.118  69.435  10.795  1.00  0.00           H  
ATOM   1242 HD23 LEU A  77      36.092  68.208  11.540  1.00  0.00           H  
ATOM   1243  N   GLN A  78      31.425  68.987  12.831  1.00  0.00           N  
ATOM   1244  CA  GLN A  78      30.265  68.373  13.465  1.00  0.00           C  
ATOM   1245  C   GLN A  78      29.788  67.160  12.673  1.00  0.00           C  
ATOM   1246  O   GLN A  78      29.367  66.156  13.247  1.00  0.00           O  
ATOM   1247  CB  GLN A  78      29.130  69.391  13.595  1.00  0.00           C  
ATOM   1248  CG  GLN A  78      29.527  70.653  14.343  1.00  0.00           C  
ATOM   1249  CD  GLN A  78      29.266  70.555  15.833  1.00  0.00           C  
ATOM   1250  OE1 GLN A  78      29.587  69.549  16.466  1.00  0.00           O  
ATOM   1251  NE2 GLN A  78      28.679  71.603  16.401  1.00  0.00           N  
ATOM   1252  H   GLN A  78      31.473  69.963  12.762  1.00  0.00           H  
ATOM   1253  HA  GLN A  78      30.560  68.049  14.453  1.00  0.00           H  
ATOM   1254  HB2 GLN A  78      28.801  69.673  12.605  1.00  0.00           H  
ATOM   1255  HB3 GLN A  78      28.308  68.930  14.122  1.00  0.00           H  
ATOM   1256  HG2 GLN A  78      30.582  70.831  14.189  1.00  0.00           H  
ATOM   1257  HG3 GLN A  78      28.962  71.483  13.947  1.00  0.00           H  
ATOM   1258 HE21 GLN A  78      28.451  72.369  15.834  1.00  0.00           H  
ATOM   1259 HE22 GLN A  78      28.498  71.565  17.363  1.00  0.00           H  
ATOM   1260  N   LYS A  79      29.857  67.260  11.350  1.00  0.00           N  
ATOM   1261  CA  LYS A  79      29.434  66.171  10.477  1.00  0.00           C  
ATOM   1262  C   LYS A  79      30.543  65.135  10.322  1.00  0.00           C  
ATOM   1263  O   LYS A  79      30.410  64.000  10.776  1.00  0.00           O  
ATOM   1264  CB  LYS A  79      29.036  66.717   9.103  1.00  0.00           C  
ATOM   1265  CG  LYS A  79      28.695  65.634   8.095  1.00  0.00           C  
ATOM   1266  CD  LYS A  79      28.340  66.225   6.740  1.00  0.00           C  
ATOM   1267  CE  LYS A  79      27.363  65.339   5.984  1.00  0.00           C  
ATOM   1268  NZ  LYS A  79      26.015  65.333   6.617  1.00  0.00           N  
ATOM   1269  H   LYS A  79      30.202  68.087  10.950  1.00  0.00           H  
ATOM   1270  HA  LYS A  79      28.575  65.697  10.930  1.00  0.00           H  
ATOM   1271  HB2 LYS A  79      28.173  67.356   9.219  1.00  0.00           H  
ATOM   1272  HB3 LYS A  79      29.855  67.301   8.710  1.00  0.00           H  
ATOM   1273  HG2 LYS A  79      29.548  64.982   7.978  1.00  0.00           H  
ATOM   1274  HG3 LYS A  79      27.852  65.066   8.461  1.00  0.00           H  
ATOM   1275  HD2 LYS A  79      27.890  67.196   6.888  1.00  0.00           H  
ATOM   1276  HD3 LYS A  79      29.243  66.332   6.156  1.00  0.00           H  
ATOM   1277  HE2 LYS A  79      27.274  65.705   4.972  1.00  0.00           H  
ATOM   1278  HE3 LYS A  79      27.749  64.330   5.969  1.00  0.00           H  
ATOM   1279  HZ1 LYS A  79      25.749  66.298   6.901  1.00  0.00           H  
ATOM   1280  HZ2 LYS A  79      26.020  64.724   7.461  1.00  0.00           H  
ATOM   1281  HZ3 LYS A  79      25.307  64.973   5.947  1.00  0.00           H  
ATOM   1282  N   GLN A  80      31.636  65.536   9.681  1.00  0.00           N  
ATOM   1283  CA  GLN A  80      32.767  64.642   9.468  1.00  0.00           C  
ATOM   1284  C   GLN A  80      32.921  63.671  10.634  1.00  0.00           C  
ATOM   1285  O   GLN A  80      33.295  62.513  10.445  1.00  0.00           O  
ATOM   1286  CB  GLN A  80      34.055  65.448   9.288  1.00  0.00           C  
ATOM   1287  CG  GLN A  80      35.310  64.590   9.257  1.00  0.00           C  
ATOM   1288  CD  GLN A  80      36.539  65.339   9.730  1.00  0.00           C  
ATOM   1289  OE1 GLN A  80      36.453  66.492  10.158  1.00  0.00           O  
ATOM   1290  NE2 GLN A  80      37.695  64.688   9.658  1.00  0.00           N  
ATOM   1291  H   GLN A  80      31.682  66.454   9.343  1.00  0.00           H  
ATOM   1292  HA  GLN A  80      32.578  64.077   8.568  1.00  0.00           H  
ATOM   1293  HB2 GLN A  80      33.995  65.996   8.359  1.00  0.00           H  
ATOM   1294  HB3 GLN A  80      34.144  66.148  10.104  1.00  0.00           H  
ATOM   1295  HG2 GLN A  80      35.161  63.733   9.896  1.00  0.00           H  
ATOM   1296  HG3 GLN A  80      35.477  64.257   8.243  1.00  0.00           H  
ATOM   1297 HE21 GLN A  80      37.687  63.773   9.306  1.00  0.00           H  
ATOM   1298 HE22 GLN A  80      38.505  65.148   9.957  1.00  0.00           H  
ATOM   1299  N   ARG A  81      32.629  64.150  11.838  1.00  0.00           N  
ATOM   1300  CA  ARG A  81      32.735  63.325  13.036  1.00  0.00           C  
ATOM   1301  C   ARG A  81      31.504  62.437  13.196  1.00  0.00           C  
ATOM   1302  O   ARG A  81      31.620  61.243  13.467  1.00  0.00           O  
ATOM   1303  CB  ARG A  81      32.908  64.205  14.275  1.00  0.00           C  
ATOM   1304  CG  ARG A  81      31.667  65.009  14.628  1.00  0.00           C  
ATOM   1305  CD  ARG A  81      31.878  65.837  15.886  1.00  0.00           C  
ATOM   1306  NE  ARG A  81      32.258  65.008  17.028  1.00  0.00           N  
ATOM   1307  CZ  ARG A  81      32.420  65.482  18.258  1.00  0.00           C  
ATOM   1308  NH1 ARG A  81      32.237  66.773  18.504  1.00  0.00           N  
ATOM   1309  NH2 ARG A  81      32.766  64.666  19.245  1.00  0.00           N  
ATOM   1310  H   ARG A  81      32.335  65.081  11.925  1.00  0.00           H  
ATOM   1311  HA  ARG A  81      33.607  62.696  12.928  1.00  0.00           H  
ATOM   1312  HB2 ARG A  81      33.154  63.576  15.118  1.00  0.00           H  
ATOM   1313  HB3 ARG A  81      33.720  64.895  14.102  1.00  0.00           H  
ATOM   1314  HG2 ARG A  81      31.435  65.674  13.809  1.00  0.00           H  
ATOM   1315  HG3 ARG A  81      30.843  64.330  14.788  1.00  0.00           H  
ATOM   1316  HD2 ARG A  81      32.660  66.557  15.700  1.00  0.00           H  
ATOM   1317  HD3 ARG A  81      30.960  66.354  16.118  1.00  0.00           H  
ATOM   1318  HE  ARG A  81      32.398  64.052  16.868  1.00  0.00           H  
ATOM   1319 HH11 ARG A  81      31.974  67.390  17.763  1.00  0.00           H  
ATOM   1320 HH12 ARG A  81      32.358  67.127  19.432  1.00  0.00           H  
ATOM   1321 HH21 ARG A  81      32.905  63.693  19.062  1.00  0.00           H  
ATOM   1322 HH22 ARG A  81      32.889  65.024  20.170  1.00  0.00           H  
ATOM   1323  N   GLU A  82      30.328  63.031  13.027  1.00  0.00           N  
ATOM   1324  CA  GLU A  82      29.075  62.294  13.154  1.00  0.00           C  
ATOM   1325  C   GLU A  82      29.076  61.060  12.256  1.00  0.00           C  
ATOM   1326  O   GLU A  82      28.536  60.014  12.618  1.00  0.00           O  
ATOM   1327  CB  GLU A  82      27.890  63.195  12.801  1.00  0.00           C  
ATOM   1328  CG  GLU A  82      27.470  63.105  11.344  1.00  0.00           C  
ATOM   1329  CD  GLU A  82      26.298  64.009  11.018  1.00  0.00           C  
ATOM   1330  OE1 GLU A  82      25.426  64.190  11.895  1.00  0.00           O  
ATOM   1331  OE2 GLU A  82      26.249  64.536   9.887  1.00  0.00           O  
ATOM   1332  H   GLU A  82      30.300  63.986  12.811  1.00  0.00           H  
ATOM   1333  HA  GLU A  82      28.980  61.976  14.181  1.00  0.00           H  
ATOM   1334  HB2 GLU A  82      27.046  62.915  13.416  1.00  0.00           H  
ATOM   1335  HB3 GLU A  82      28.155  64.219  13.016  1.00  0.00           H  
ATOM   1336  HG2 GLU A  82      28.307  63.390  10.723  1.00  0.00           H  
ATOM   1337  HG3 GLU A  82      27.191  62.085  11.124  1.00  0.00           H  
ATOM   1338  N   LEU A  83      29.686  61.191  11.083  1.00  0.00           N  
ATOM   1339  CA  LEU A  83      29.758  60.088  10.131  1.00  0.00           C  
ATOM   1340  C   LEU A  83      30.846  59.096  10.529  1.00  0.00           C  
ATOM   1341  O   LEU A  83      30.597  57.893  10.623  1.00  0.00           O  
ATOM   1342  CB  LEU A  83      30.027  60.620   8.723  1.00  0.00           C  
ATOM   1343  CG  LEU A  83      29.276  61.893   8.332  1.00  0.00           C  
ATOM   1344  CD1 LEU A  83      29.928  62.547   7.123  1.00  0.00           C  
ATOM   1345  CD2 LEU A  83      27.813  61.584   8.048  1.00  0.00           C  
ATOM   1346  H   LEU A  83      30.098  62.049  10.851  1.00  0.00           H  
ATOM   1347  HA  LEU A  83      28.804  59.580  10.139  1.00  0.00           H  
ATOM   1348  HB2 LEU A  83      31.084  60.822   8.642  1.00  0.00           H  
ATOM   1349  HB3 LEU A  83      29.755  59.845   8.020  1.00  0.00           H  
ATOM   1350  HG  LEU A  83      29.318  62.595   9.153  1.00  0.00           H  
ATOM   1351 HD11 LEU A  83      30.659  63.268   7.455  1.00  0.00           H  
ATOM   1352 HD12 LEU A  83      29.174  63.046   6.532  1.00  0.00           H  
ATOM   1353 HD13 LEU A  83      30.413  61.792   6.523  1.00  0.00           H  
ATOM   1354 HD21 LEU A  83      27.206  61.935   8.869  1.00  0.00           H  
ATOM   1355 HD22 LEU A  83      27.686  60.517   7.937  1.00  0.00           H  
ATOM   1356 HD23 LEU A  83      27.511  62.079   7.137  1.00  0.00           H  
ATOM   1357  N   GLN A  84      32.050  59.607  10.762  1.00  0.00           N  
ATOM   1358  CA  GLN A  84      33.175  58.766  11.151  1.00  0.00           C  
ATOM   1359  C   GLN A  84      32.820  57.906  12.361  1.00  0.00           C  
ATOM   1360  O   GLN A  84      33.345  56.805  12.530  1.00  0.00           O  
ATOM   1361  CB  GLN A  84      34.399  59.626  11.465  1.00  0.00           C  
ATOM   1362  CG  GLN A  84      35.199  60.021  10.234  1.00  0.00           C  
ATOM   1363  CD  GLN A  84      36.506  60.703  10.580  1.00  0.00           C  
ATOM   1364  OE1 GLN A  84      37.113  60.421  11.614  1.00  0.00           O  
ATOM   1365  NE2 GLN A  84      36.950  61.608   9.714  1.00  0.00           N  
ATOM   1366  H   GLN A  84      32.185  60.572  10.670  1.00  0.00           H  
ATOM   1367  HA  GLN A  84      33.406  58.117  10.320  1.00  0.00           H  
ATOM   1368  HB2 GLN A  84      34.072  60.530  11.960  1.00  0.00           H  
ATOM   1369  HB3 GLN A  84      35.050  59.077  12.129  1.00  0.00           H  
ATOM   1370  HG2 GLN A  84      35.415  59.131   9.661  1.00  0.00           H  
ATOM   1371  HG3 GLN A  84      34.604  60.695   9.635  1.00  0.00           H  
ATOM   1372 HE21 GLN A  84      36.413  61.783   8.913  1.00  0.00           H  
ATOM   1373 HE22 GLN A  84      37.792  62.065   9.914  1.00  0.00           H  
ATOM   1374  N   LYS A  85      31.924  58.416  13.200  1.00  0.00           N  
ATOM   1375  CA  LYS A  85      31.496  57.695  14.393  1.00  0.00           C  
ATOM   1376  C   LYS A  85      30.220  56.905  14.124  1.00  0.00           C  
ATOM   1377  O   LYS A  85      30.022  55.823  14.675  1.00  0.00           O  
ATOM   1378  CB  LYS A  85      31.270  58.673  15.549  1.00  0.00           C  
ATOM   1379  CG  LYS A  85      29.940  59.403  15.477  1.00  0.00           C  
ATOM   1380  CD  LYS A  85      29.657  60.175  16.754  1.00  0.00           C  
ATOM   1381  CE  LYS A  85      28.933  59.313  17.778  1.00  0.00           C  
ATOM   1382  NZ  LYS A  85      29.876  58.459  18.551  1.00  0.00           N  
ATOM   1383  H   LYS A  85      31.540  59.298  13.011  1.00  0.00           H  
ATOM   1384  HA  LYS A  85      32.282  57.007  14.664  1.00  0.00           H  
ATOM   1385  HB2 LYS A  85      31.306  58.125  16.480  1.00  0.00           H  
ATOM   1386  HB3 LYS A  85      32.061  59.408  15.543  1.00  0.00           H  
ATOM   1387  HG2 LYS A  85      29.965  60.096  14.648  1.00  0.00           H  
ATOM   1388  HG3 LYS A  85      29.152  58.680  15.321  1.00  0.00           H  
ATOM   1389  HD2 LYS A  85      30.593  60.507  17.179  1.00  0.00           H  
ATOM   1390  HD3 LYS A  85      29.043  61.032  16.518  1.00  0.00           H  
ATOM   1391  HE2 LYS A  85      28.402  59.958  18.460  1.00  0.00           H  
ATOM   1392  HE3 LYS A  85      28.228  58.679  17.260  1.00  0.00           H  
ATOM   1393  HZ1 LYS A  85      30.857  58.740  18.351  1.00  0.00           H  
ATOM   1394  HZ2 LYS A  85      29.751  57.460  18.287  1.00  0.00           H  
ATOM   1395  HZ3 LYS A  85      29.698  58.562  19.570  1.00  0.00           H  
ATOM   1396  N   ALA A  86      29.360  57.452  13.272  1.00  0.00           N  
ATOM   1397  CA  ALA A  86      28.105  56.796  12.927  1.00  0.00           C  
ATOM   1398  C   ALA A  86      28.351  55.398  12.371  1.00  0.00           C  
ATOM   1399  O   ALA A  86      27.642  54.451  12.711  1.00  0.00           O  
ATOM   1400  CB  ALA A  86      27.328  57.636  11.924  1.00  0.00           C  
ATOM   1401  H   ALA A  86      29.574  58.317  12.864  1.00  0.00           H  
ATOM   1402  HA  ALA A  86      27.512  56.716  13.827  1.00  0.00           H  
ATOM   1403  HB1 ALA A  86      26.627  57.008  11.395  1.00  0.00           H  
ATOM   1404  HB2 ALA A  86      26.791  58.415  12.447  1.00  0.00           H  
ATOM   1405  HB3 ALA A  86      28.015  58.082  11.220  1.00  0.00           H  
ATOM   1406  N   ASN A  87      29.358  55.277  11.513  1.00  0.00           N  
ATOM   1407  CA  ASN A  87      29.697  53.993  10.909  1.00  0.00           C  
ATOM   1408  C   ASN A  87      31.188  53.702  11.047  1.00  0.00           C  
ATOM   1409  O   ASN A  87      32.000  54.187  10.259  1.00  0.00           O  
ATOM   1410  CB  ASN A  87      29.299  53.981   9.431  1.00  0.00           C  
ATOM   1411  CG  ASN A  87      28.032  54.772   9.167  1.00  0.00           C  
ATOM   1412  OD1 ASN A  87      26.924  54.246   9.282  1.00  0.00           O  
ATOM   1413  ND2 ASN A  87      28.190  56.041   8.811  1.00  0.00           N  
ATOM   1414  H   ASN A  87      29.887  56.068  11.281  1.00  0.00           H  
ATOM   1415  HA  ASN A  87      29.142  53.226  11.428  1.00  0.00           H  
ATOM   1416  HB2 ASN A  87      30.098  54.412   8.846  1.00  0.00           H  
ATOM   1417  HB3 ASN A  87      29.137  52.961   9.116  1.00  0.00           H  
ATOM   1418 HD21 ASN A  87      29.102  56.391   8.739  1.00  0.00           H  
ATOM   1419 HD22 ASN A  87      27.388  56.575   8.635  1.00  0.00           H  
ATOM   1420  N   GLN A  88      31.540  52.908  12.053  1.00  0.00           N  
ATOM   1421  CA  GLN A  88      32.933  52.554  12.294  1.00  0.00           C  
ATOM   1422  C   GLN A  88      33.377  51.428  11.367  1.00  0.00           C  
ATOM   1423  O   GLN A  88      34.266  51.610  10.536  1.00  0.00           O  
ATOM   1424  CB  GLN A  88      33.131  52.138  13.753  1.00  0.00           C  
ATOM   1425  CG  GLN A  88      32.944  53.277  14.741  1.00  0.00           C  
ATOM   1426  CD  GLN A  88      31.494  53.475  15.137  1.00  0.00           C  
ATOM   1427  OE1 GLN A  88      30.582  53.199  14.356  1.00  0.00           O  
ATOM   1428  NE2 GLN A  88      31.271  53.956  16.355  1.00  0.00           N  
ATOM   1429  H   GLN A  88      30.847  52.554  12.647  1.00  0.00           H  
ATOM   1430  HA  GLN A  88      33.537  53.426  12.094  1.00  0.00           H  
ATOM   1431  HB2 GLN A  88      32.419  51.361  13.993  1.00  0.00           H  
ATOM   1432  HB3 GLN A  88      34.131  51.748  13.872  1.00  0.00           H  
ATOM   1433  HG2 GLN A  88      33.516  53.062  15.632  1.00  0.00           H  
ATOM   1434  HG3 GLN A  88      33.307  54.189  14.292  1.00  0.00           H  
ATOM   1435 HE21 GLN A  88      32.046  54.155  16.922  1.00  0.00           H  
ATOM   1436 HE22 GLN A  88      30.344  54.095  16.636  1.00  0.00           H  
ATOM   1437  N   GLU A  89      32.753  50.264  11.518  1.00  0.00           N  
ATOM   1438  CA  GLU A  89      33.085  49.108  10.694  1.00  0.00           C  
ATOM   1439  C   GLU A  89      33.306  49.519   9.241  1.00  0.00           C  
ATOM   1440  O   GLU A  89      34.415  49.416   8.719  1.00  0.00           O  
ATOM   1441  CB  GLU A  89      31.973  48.059  10.774  1.00  0.00           C  
ATOM   1442  CG  GLU A  89      32.074  47.158  11.993  1.00  0.00           C  
ATOM   1443  CD  GLU A  89      31.047  46.043  11.980  1.00  0.00           C  
ATOM   1444  OE1 GLU A  89      29.912  46.274  12.448  1.00  0.00           O  
ATOM   1445  OE2 GLU A  89      31.378  44.938  11.502  1.00  0.00           O  
ATOM   1446  H   GLU A  89      32.052  50.181  12.199  1.00  0.00           H  
ATOM   1447  HA  GLU A  89      33.998  48.679  11.076  1.00  0.00           H  
ATOM   1448  HB2 GLU A  89      31.019  48.565  10.802  1.00  0.00           H  
ATOM   1449  HB3 GLU A  89      32.015  47.440   9.890  1.00  0.00           H  
ATOM   1450  HG2 GLU A  89      33.059  46.718  12.019  1.00  0.00           H  
ATOM   1451  HG3 GLU A  89      31.923  47.756  12.880  1.00  0.00           H  
ATOM   1452  N   GLN A  90      32.241  49.987   8.596  1.00  0.00           N  
ATOM   1453  CA  GLN A  90      32.319  50.413   7.204  1.00  0.00           C  
ATOM   1454  C   GLN A  90      33.598  51.203   6.947  1.00  0.00           C  
ATOM   1455  O   GLN A  90      34.360  50.890   6.031  1.00  0.00           O  
ATOM   1456  CB  GLN A  90      31.100  51.263   6.841  1.00  0.00           C  
ATOM   1457  CG  GLN A  90      29.889  50.443   6.424  1.00  0.00           C  
ATOM   1458  CD  GLN A  90      28.616  51.264   6.379  1.00  0.00           C  
ATOM   1459  OE1 GLN A  90      28.251  51.919   7.356  1.00  0.00           O  
ATOM   1460  NE2 GLN A  90      27.930  51.232   5.243  1.00  0.00           N  
ATOM   1461  H   GLN A  90      31.385  50.045   9.067  1.00  0.00           H  
ATOM   1462  HA  GLN A  90      32.327  49.528   6.586  1.00  0.00           H  
ATOM   1463  HB2 GLN A  90      30.826  51.862   7.696  1.00  0.00           H  
ATOM   1464  HB3 GLN A  90      31.363  51.916   6.022  1.00  0.00           H  
ATOM   1465  HG2 GLN A  90      30.069  50.031   5.442  1.00  0.00           H  
ATOM   1466  HG3 GLN A  90      29.756  49.637   7.131  1.00  0.00           H  
ATOM   1467 HE21 GLN A  90      28.280  50.686   4.507  1.00  0.00           H  
ATOM   1468 HE22 GLN A  90      27.103  51.752   5.185  1.00  0.00           H  
ATOM   1469  N   TYR A  91      33.829  52.227   7.760  1.00  0.00           N  
ATOM   1470  CA  TYR A  91      35.015  53.063   7.618  1.00  0.00           C  
ATOM   1471  C   TYR A  91      36.286  52.221   7.681  1.00  0.00           C  
ATOM   1472  O   TYR A  91      37.249  52.475   6.957  1.00  0.00           O  
ATOM   1473  CB  TYR A  91      35.045  54.132   8.713  1.00  0.00           C  
ATOM   1474  CG  TYR A  91      35.967  55.289   8.403  1.00  0.00           C  
ATOM   1475  CD1 TYR A  91      37.341  55.103   8.316  1.00  0.00           C  
ATOM   1476  CD2 TYR A  91      35.464  56.569   8.200  1.00  0.00           C  
ATOM   1477  CE1 TYR A  91      38.188  56.158   8.034  1.00  0.00           C  
ATOM   1478  CE2 TYR A  91      36.304  57.630   7.917  1.00  0.00           C  
ATOM   1479  CZ  TYR A  91      37.665  57.419   7.835  1.00  0.00           C  
ATOM   1480  OH  TYR A  91      38.505  58.472   7.554  1.00  0.00           O  
ATOM   1481  H   TYR A  91      33.186  52.427   8.471  1.00  0.00           H  
ATOM   1482  HA  TYR A  91      34.965  53.549   6.656  1.00  0.00           H  
ATOM   1483  HB2 TYR A  91      34.050  54.529   8.846  1.00  0.00           H  
ATOM   1484  HB3 TYR A  91      35.375  53.682   9.637  1.00  0.00           H  
ATOM   1485  HD1 TYR A  91      37.748  54.115   8.472  1.00  0.00           H  
ATOM   1486  HD2 TYR A  91      34.399  56.730   8.265  1.00  0.00           H  
ATOM   1487  HE1 TYR A  91      39.254  55.994   7.970  1.00  0.00           H  
ATOM   1488  HE2 TYR A  91      35.895  58.616   7.762  1.00  0.00           H  
ATOM   1489  HH  TYR A  91      38.098  59.039   6.894  1.00  0.00           H  
ATOM   1490  N   ALA A  92      36.280  51.216   8.551  1.00  0.00           N  
ATOM   1491  CA  ALA A  92      37.430  50.334   8.705  1.00  0.00           C  
ATOM   1492  C   ALA A  92      37.600  49.433   7.487  1.00  0.00           C  
ATOM   1493  O   ALA A  92      38.712  49.242   6.997  1.00  0.00           O  
ATOM   1494  CB  ALA A  92      37.285  49.496   9.968  1.00  0.00           C  
ATOM   1495  H   ALA A  92      35.483  51.064   9.099  1.00  0.00           H  
ATOM   1496  HA  ALA A  92      38.311  50.950   8.812  1.00  0.00           H  
ATOM   1497  HB1 ALA A  92      37.142  50.147  10.817  1.00  0.00           H  
ATOM   1498  HB2 ALA A  92      36.432  48.841   9.867  1.00  0.00           H  
ATOM   1499  HB3 ALA A  92      38.178  48.905  10.112  1.00  0.00           H  
ATOM   1500  N   GLU A  93      36.491  48.884   7.004  1.00  0.00           N  
ATOM   1501  CA  GLU A  93      36.519  48.002   5.843  1.00  0.00           C  
ATOM   1502  C   GLU A  93      37.441  48.556   4.761  1.00  0.00           C  
ATOM   1503  O   GLU A  93      37.388  49.740   4.431  1.00  0.00           O  
ATOM   1504  CB  GLU A  93      35.108  47.818   5.280  1.00  0.00           C  
ATOM   1505  CG  GLU A  93      34.232  46.901   6.119  1.00  0.00           C  
ATOM   1506  CD  GLU A  93      32.778  46.936   5.695  1.00  0.00           C  
ATOM   1507  OE1 GLU A  93      32.503  46.719   4.496  1.00  0.00           O  
ATOM   1508  OE2 GLU A  93      31.912  47.182   6.562  1.00  0.00           O  
ATOM   1509  H   GLU A  93      35.633  49.074   7.438  1.00  0.00           H  
ATOM   1510  HA  GLU A  93      36.897  47.042   6.164  1.00  0.00           H  
ATOM   1511  HB2 GLU A  93      34.628  48.783   5.219  1.00  0.00           H  
ATOM   1512  HB3 GLU A  93      35.182  47.399   4.287  1.00  0.00           H  
ATOM   1513  HG2 GLU A  93      34.596  45.889   6.020  1.00  0.00           H  
ATOM   1514  HG3 GLU A  93      34.300  47.207   7.152  1.00  0.00           H  
ATOM   1515  N   GLY A  94      38.289  47.690   4.214  1.00  0.00           N  
ATOM   1516  CA  GLY A  94      39.212  48.111   3.176  1.00  0.00           C  
ATOM   1517  C   GLY A  94      40.589  48.433   3.721  1.00  0.00           C  
ATOM   1518  O   GLY A  94      41.602  48.017   3.157  1.00  0.00           O  
ATOM   1519  H   GLY A  94      38.287  46.758   4.516  1.00  0.00           H  
ATOM   1520  HA2 GLY A  94      39.301  47.320   2.446  1.00  0.00           H  
ATOM   1521  HA3 GLY A  94      38.815  48.990   2.691  1.00  0.00           H  
ATOM   1522  N   LYS A  95      40.629  49.178   4.820  1.00  0.00           N  
ATOM   1523  CA  LYS A  95      41.892  49.557   5.442  1.00  0.00           C  
ATOM   1524  C   LYS A  95      42.585  48.343   6.052  1.00  0.00           C  
ATOM   1525  O   LYS A  95      41.931  47.379   6.451  1.00  0.00           O  
ATOM   1526  CB  LYS A  95      41.655  50.616   6.521  1.00  0.00           C  
ATOM   1527  CG  LYS A  95      41.533  52.028   5.972  1.00  0.00           C  
ATOM   1528  CD  LYS A  95      40.904  52.969   6.985  1.00  0.00           C  
ATOM   1529  CE  LYS A  95      41.093  54.424   6.587  1.00  0.00           C  
ATOM   1530  NZ  LYS A  95      40.139  54.835   5.520  1.00  0.00           N  
ATOM   1531  H   LYS A  95      39.788  49.480   5.224  1.00  0.00           H  
ATOM   1532  HA  LYS A  95      42.528  49.973   4.675  1.00  0.00           H  
ATOM   1533  HB2 LYS A  95      40.743  50.378   7.048  1.00  0.00           H  
ATOM   1534  HB3 LYS A  95      42.480  50.595   7.218  1.00  0.00           H  
ATOM   1535  HG2 LYS A  95      42.517  52.393   5.720  1.00  0.00           H  
ATOM   1536  HG3 LYS A  95      40.918  52.006   5.083  1.00  0.00           H  
ATOM   1537  HD2 LYS A  95      39.846  52.759   7.050  1.00  0.00           H  
ATOM   1538  HD3 LYS A  95      41.365  52.805   7.950  1.00  0.00           H  
ATOM   1539  HE2 LYS A  95      40.938  55.045   7.456  1.00  0.00           H  
ATOM   1540  HE3 LYS A  95      42.102  54.556   6.227  1.00  0.00           H  
ATOM   1541  HZ1 LYS A  95      39.167  54.828   5.888  1.00  0.00           H  
ATOM   1542  HZ2 LYS A  95      40.200  54.180   4.715  1.00  0.00           H  
ATOM   1543  HZ3 LYS A  95      40.367  55.795   5.189  1.00  0.00           H  
ATOM   1544  N   MET A  96      43.911  48.396   6.121  1.00  0.00           N  
ATOM   1545  CA  MET A  96      44.691  47.301   6.684  1.00  0.00           C  
ATOM   1546  C   MET A  96      45.051  47.581   8.140  1.00  0.00           C  
ATOM   1547  O   MET A  96      45.953  48.369   8.425  1.00  0.00           O  
ATOM   1548  CB  MET A  96      45.965  47.080   5.866  1.00  0.00           C  
ATOM   1549  CG  MET A  96      46.518  45.667   5.971  1.00  0.00           C  
ATOM   1550  SD  MET A  96      48.140  45.497   5.205  1.00  0.00           S  
ATOM   1551  CE  MET A  96      47.679  45.134   3.513  1.00  0.00           C  
ATOM   1552  H   MET A  96      44.376  49.191   5.785  1.00  0.00           H  
ATOM   1553  HA  MET A  96      44.087  46.407   6.641  1.00  0.00           H  
ATOM   1554  HB2 MET A  96      45.751  47.282   4.826  1.00  0.00           H  
ATOM   1555  HB3 MET A  96      46.723  47.766   6.209  1.00  0.00           H  
ATOM   1556  HG2 MET A  96      46.600  45.404   7.015  1.00  0.00           H  
ATOM   1557  HG3 MET A  96      45.831  44.991   5.484  1.00  0.00           H  
ATOM   1558  HE1 MET A  96      48.531  45.289   2.866  1.00  0.00           H  
ATOM   1559  HE2 MET A  96      47.353  44.107   3.440  1.00  0.00           H  
ATOM   1560  HE3 MET A  96      46.875  45.789   3.210  1.00  0.00           H  
ATOM   1561  N   ARG A  97      44.339  46.934   9.056  1.00  0.00           N  
ATOM   1562  CA  ARG A  97      44.583  47.116  10.482  1.00  0.00           C  
ATOM   1563  C   ARG A  97      46.059  46.911  10.812  1.00  0.00           C  
ATOM   1564  O   ARG A  97      46.868  46.621   9.932  1.00  0.00           O  
ATOM   1565  CB  ARG A  97      43.727  46.143  11.296  1.00  0.00           C  
ATOM   1566  CG  ARG A  97      44.341  44.759  11.431  1.00  0.00           C  
ATOM   1567  CD  ARG A  97      43.560  43.897  12.410  1.00  0.00           C  
ATOM   1568  NE  ARG A  97      42.476  43.171  11.755  1.00  0.00           N  
ATOM   1569  CZ  ARG A  97      42.670  42.154  10.922  1.00  0.00           C  
ATOM   1570  NH1 ARG A  97      43.901  41.746  10.644  1.00  0.00           N  
ATOM   1571  NH2 ARG A  97      41.632  41.543  10.366  1.00  0.00           N  
ATOM   1572  H   ARG A  97      43.633  46.320   8.767  1.00  0.00           H  
ATOM   1573  HA  ARG A  97      44.306  48.128  10.739  1.00  0.00           H  
ATOM   1574  HB2 ARG A  97      43.586  46.549  12.287  1.00  0.00           H  
ATOM   1575  HB3 ARG A  97      42.765  46.041  10.816  1.00  0.00           H  
ATOM   1576  HG2 ARG A  97      44.338  44.278  10.464  1.00  0.00           H  
ATOM   1577  HG3 ARG A  97      45.356  44.859  11.784  1.00  0.00           H  
ATOM   1578  HD2 ARG A  97      44.235  43.186  12.862  1.00  0.00           H  
ATOM   1579  HD3 ARG A  97      43.143  44.533  13.176  1.00  0.00           H  
ATOM   1580  HE  ARG A  97      41.558  43.455  11.947  1.00  0.00           H  
ATOM   1581 HH11 ARG A  97      44.684  42.204  11.064  1.00  0.00           H  
ATOM   1582 HH12 ARG A  97      44.045  40.980  10.018  1.00  0.00           H  
ATOM   1583 HH21 ARG A  97      40.703  41.847  10.573  1.00  0.00           H  
ATOM   1584 HH22 ARG A  97      41.779  40.778   9.739  1.00  0.00           H  
ATOM   1585  N   GLY A  98      46.402  47.065  12.087  1.00  0.00           N  
ATOM   1586  CA  GLY A  98      47.779  46.894  12.510  1.00  0.00           C  
ATOM   1587  C   GLY A  98      48.248  48.009  13.425  1.00  0.00           C  
ATOM   1588  O   GLY A  98      47.436  48.750  13.977  1.00  0.00           O  
ATOM   1589  H   GLY A  98      45.714  47.297  12.746  1.00  0.00           H  
ATOM   1590  HA2 GLY A  98      47.869  45.952  13.033  1.00  0.00           H  
ATOM   1591  HA3 GLY A  98      48.412  46.871  11.635  1.00  0.00           H  
ATOM   1592  N   ALA A  99      49.561  48.127  13.585  1.00  0.00           N  
ATOM   1593  CA  ALA A  99      50.137  49.159  14.438  1.00  0.00           C  
ATOM   1594  C   ALA A  99      49.408  49.236  15.775  1.00  0.00           C  
ATOM   1595  O   ALA A  99      49.069  50.321  16.247  1.00  0.00           O  
ATOM   1596  CB  ALA A  99      50.097  50.508  13.734  1.00  0.00           C  
ATOM   1597  H   ALA A  99      50.158  47.506  13.117  1.00  0.00           H  
ATOM   1598  HA  ALA A  99      51.172  48.905  14.618  1.00  0.00           H  
ATOM   1599  HB1 ALA A  99      51.042  50.685  13.243  1.00  0.00           H  
ATOM   1600  HB2 ALA A  99      49.304  50.507  13.000  1.00  0.00           H  
ATOM   1601  HB3 ALA A  99      49.916  51.287  14.459  1.00  0.00           H  
ATOM   1602  N   ALA A 100      49.169  48.077  16.381  1.00  0.00           N  
ATOM   1603  CA  ALA A 100      48.480  48.014  17.664  1.00  0.00           C  
ATOM   1604  C   ALA A 100      49.445  48.276  18.816  1.00  0.00           C  
ATOM   1605  O   ALA A 100      50.655  48.097  18.680  1.00  0.00           O  
ATOM   1606  CB  ALA A 100      47.805  46.662  17.834  1.00  0.00           C  
ATOM   1607  H   ALA A 100      49.463  47.246  15.954  1.00  0.00           H  
ATOM   1608  HA  ALA A 100      47.714  48.776  17.669  1.00  0.00           H  
ATOM   1609  HB1 ALA A 100      47.703  46.187  16.871  1.00  0.00           H  
ATOM   1610  HB2 ALA A 100      48.407  46.039  18.482  1.00  0.00           H  
ATOM   1611  HB3 ALA A 100      46.828  46.801  18.274  1.00  0.00           H  
TER    1612      ALA A 100                                                      
END
MOLECULE T0504.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37      A    N   
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83      A    C   
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78      A    C   
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39      A    C   
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16      A    C   
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97      A    O   
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44      A    O   
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49      A    C   
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06      A    O   
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86      A    N   
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98      A    C   
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58      A    C   
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84      A    C   
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71      A    O   
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97      A    N   
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53      A    C   
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15      A    O   
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85      A    N   
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02      A    C   
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25      A    C   
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02      A    C   
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09      A    C   
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44      A    C   
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19      A    C   
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84      A    O   
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57      A    N   
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42      A    C   
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98      A    C   
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50      A    C   
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82      A    C   
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45      A    C   
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13      A    C   
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65      A    O   
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20      A    C   
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73      A    C   
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61      A    C   
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26      A    O   
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30      A    N   
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43      A    C   
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10      A    C   
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27      A    C   
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53      A    C   
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63      A    C   
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66      A    C   
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69      A    C   
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08      A    C   
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65      A    C   
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56      A    O   
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36      A    N   
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14      A    C   
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23      A    C   
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69      A    C   
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80      A    C   
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70      A    O   
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90      A    N   
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19      A    C   
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02      A    O   
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63      A    N   
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46      A    C   
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41      A    C   
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44      A    O   
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77      A    N   
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30      A    C   
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54      A    C   
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43      A    C   
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86      A    O   
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63      A    O   
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60      A    C   
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73      A    O   
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56      A    N   
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77      A    C   
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79      A    C   
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44      A    C   
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81      A    C   
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75      A    C   
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16      A    C   
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21      A    O   
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94      A    N   
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76      A    C   
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23      A    C   
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89      A    C   
ATOM     82  CD1 ILE    10      43.756  81.529   2.264  1.00 19.82      A    C   
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10      A    C   
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82      A    C   
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77      A    O   
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59      A    N   
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06      A    C   
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08      A    C   
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60      A    C   
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92      A    C   
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05      A    C   
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69      A    O   
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61      A    N   
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09      A    C   
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98      A    C   
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77      A    O   
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91      A    C   
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32      A    O   
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08      A    N   
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70      A    C   
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79      A    C   
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89      A    C   
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11      A    S   
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35      A    C   
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22      A    C   
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56      A    O   
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80      A    N   
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49      A    C   
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73      A    C   
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59      A    C   
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95      A    C   
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61      A    N   
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50      A    C   
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44      A    N   
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31      A    N   
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43      A    C   
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04      A    O   
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91      A    N   
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92      A    C   
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59      A    C   
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51      A    C   
ATOM    122  CD1 ILE    15      39.996  70.306   0.585  1.00 27.05      A    C   
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98      A    C   
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96      A    C   
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85      A    O   
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39      A    N   
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24      A    C   
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17      A    C   
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85      A    C   
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99      A    C   
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18      A    C   
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28      A    C   
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31      A    O   
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22      A    N   
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80      A    C   
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12      A    C   
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61      A    O   
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83      A    N   
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17      A    C   
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50      A    C   
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64      A    C   
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12      A    C   
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74      A    C   
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73      A    N   
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38      A    C   
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23      A    O   
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11      A    N   
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79      A    C   
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26      A    C   
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88      A    C   
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99      A    C   
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04      A    C   
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94      A    N   
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81      A    C   
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30      A    O   
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76      A    N   
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24      A    C   
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99      A    C   
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44      A    C   
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93      A    C   
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65      A    N   
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27      A    C   
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35      A    N   
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75      A    N   
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01      A    C   
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04      A    O   
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23      A    N   
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54      A    C   
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45      A    C   
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78      A    O   
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28      A    C   
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38      A    C   
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92      A    O   
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59      A    N   
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14      A    C   
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57      A    C   
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45      A    C   
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60      A    C   
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60      A    C   
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41      A    N   
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65      A    C   
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29      A    O   
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11      A    N   
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84      A    C   
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56      A    C   
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85      A    O   
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10      A    C   
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11      A    C   
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72      A    O   
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67      A    N   
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31      A    C   
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09      A    C   
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47      A    C   
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88      A    C   
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63      A    N   
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14      A    C   
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29      A    C   
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05      A    C   
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65      A    C   
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25      A    C   
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47      A    C   
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55      A    C   
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75      A    O   
ATOM    204  N   HIS    25      37.463  62.079   4.725  1.00 21.41      A    N   
ATOM    205  CA  HIS    25      38.827  61.919   5.220  1.00 21.79      A    C   
ATOM    206  CB  HIS    25      39.499  60.706   4.534  1.00 22.01      A    C   
ATOM    207  CG  HIS    25      38.761  59.428   4.754  1.00 21.78      A    C   
ATOM    208  ND1 HIS    25      37.736  59.007   3.930  1.00 24.64      A    N   
ATOM    209  CE1 HIS    25      37.239  57.871   4.392  1.00 21.18      A    C   
ATOM    210  NE2 HIS    25      37.889  57.555   5.498  1.00 25.69      A    N   
ATOM    211  CD2 HIS    25      38.845  58.514   5.748  1.00 20.97      A    C   
ATOM    212  C   HIS    25      39.676  63.161   5.020  1.00 22.34      A    C   
ATOM    213  O   HIS    25      39.459  63.941   4.095  1.00 22.06      A    O   
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29      A    N   
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67      A    C   
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03      A    C   
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30      A    C   
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62      A    C   
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11      A    C   
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57      A    N   
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07      A    C   
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59      A    O   
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33      A    N   
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34      A    C   
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08      A    C   
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58      A    O   
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74      A    N   
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93      A    C   
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06      A    C   
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73      A    O   
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50      A    C   
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32      A    C   
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70      A    O   
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17      A    N   
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39      A    C   
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00      A    C   
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05      A    C   
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84      A    C   
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24      A    C   
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77      A    C   
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81      A    O   
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86      A    N   
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29      A    C   
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12      A    C   
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65      A    C   
ATOM    246  CD1 ILE    30      47.190  67.505  -5.529  1.00 23.75      A    C   
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13      A    C   
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92      A    C   
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81      A    O   
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57      A    N   
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70      A    C   
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85      A    C   
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21      A    C   
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86      A    O   
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51      A    N   
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06      A    C   
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62      A    C   
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72      A    C   
ATOM    259  CD1 ILE    32      41.312  76.990  -4.538  1.00 21.43      A    C   
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89      A    C   
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59      A    C   
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54      A    O   
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30      A    N   
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55      A    C   
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71      A    C   
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65      A    C   
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37      A    C   
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45      A    O   
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01      A    N   
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54      A    C   
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76      A    O   
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78      A    N   
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41      A    C   
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30      A    C   
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81      A    O   
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36      A    C   
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52      A    C   
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01      A    O   
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56      A    N   
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84      A    C   
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18      A    C   
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09      A    C   
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61      A    C   
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94      A    C   
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63      A    O   
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84      A    N   
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85      A    C   
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67      A    C   
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99      A    O   
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19      A    N   
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16      A    C   
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59      A    C   
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83      A    C   
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32      A    C   
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79      A    C   
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51      A    O   
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42      A    N   
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23      A    C   
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59      A    C   
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97      A    O   
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52      A    N   
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99      A    C   
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28      A    C   
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73      A    C   
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93      A    C   
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28      A    C   
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24      A    N   
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68      A    C   
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89      A    O   
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54      A    N   
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74      A    C   
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45      A    C   
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21      A    C   
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42      A    C   
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38      A    C   
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30      A    N   
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98      A    C   
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60      A    O   
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67      A    N   
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61      A    C   
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74      A    C   
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37      A    C   
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43      A    C   
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08      A    C   
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70      A    C   
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71      A    O   
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29      A    C   
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84      A    C   
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85      A    C   
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49      A    O   
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94      A    N   
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02      A    C   
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22      A    C   
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67      A    C   
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84      A    C   
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36      A    C   
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81      A    N   
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53      A    C   
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05      A    O   
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35      A    N   
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92      A    C   
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50      A    C   
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28      A    C   
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88      A    C   
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25      A    C   
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86      A    O   
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74      A    N   
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81      A    C   
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63      A    C   
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17      A    C   
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45      A    C   
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65      A    C   
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07      A    N   
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00      A    C   
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51      A    O   
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53      A    N   
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40      A    C   
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65      A    C   
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24      A    C   
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75      A    C   
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50      A    C   
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86      A    C   
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89      A    C   
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72      A    C   
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99      A    C   
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81      A    O   
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71      A    N   
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20      A    C   
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20      A    C   
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31      A    C   
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82      A    O   
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86      A    O   
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51      A    C   
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78      A    O   
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36      A    N   
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07      A    C   
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82      A    C   
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15      A    O   
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00           N   
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00           C   
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00           C   
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00           C   
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89      A    O   
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66      A    N   
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00      A    C   
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62      A    C   
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03      A    O   
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46      A    N   
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65      A    C   
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92      A    C   
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50      A    C   
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70      A    C   
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53      A    C   
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89      A    N   
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83      A    C   
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32      A    O   
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37      A    N   
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75      A    C   
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54      A    C   
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38      A    O   
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54      A    C   
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69      A    O   
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75      A    N   
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31      A    C   
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47      A    C   
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39      A    C   
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20      A    C   
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52      A    C   
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65      A    C   
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95      A    O   
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72      A    N   
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96      A    C   
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56      A    C   
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20      A    C   
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98      A    C   
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46      A    C   
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06      A    C   
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74      A    O   
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72      A    N   
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06      A    C   
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95      A    C   
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54      A    O   
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42      A    C   
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57      A    O   
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72      A    N   
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16      A    C   
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50      A    C   
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73      A    O   
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83      A    N   
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79      A    C   
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23      A    C   
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56      A    C   
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74      A    O   
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32      A    N   
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90      A    C   
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34      A    O   
ATOM    437  N   HIS    57      31.698  68.348  -2.203  1.00 18.92      A    N   
ATOM    438  CA  HIS    57      32.361  67.115  -1.745  1.00 19.22      A    C   
ATOM    439  CB  HIS    57      32.520  66.145  -2.914  1.00 19.81      A    C   
ATOM    440  CG  HIS    57      31.219  65.568  -3.378  1.00 20.14      A    C   
ATOM    441  ND1 HIS    57      31.049  65.028  -4.633  1.00 22.60      A    N   
ATOM    442  CE1 HIS    57      29.809  64.583  -4.748  1.00 22.65      A    C   
ATOM    443  NE2 HIS    57      29.171  64.824  -3.616  1.00 21.53      A    N   
ATOM    444  CD2 HIS    57      30.028  65.448  -2.747  1.00 20.42      A    C   
ATOM    445  C   HIS    57      33.680  67.336  -0.975  1.00 19.11      A    C   
ATOM    446  O   HIS    57      34.538  66.434  -0.828  1.00 18.12      A    O   
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70      A    N   
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51      A    C   
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69      A    C   
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12      A    C   
ATOM    451  CD1 ILE    58      36.427  72.053  -1.279  1.00 20.43      A    C   
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86      A    C   
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50      A    C   
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32      A    O   
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26      A    N   
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14      A    C   
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64      A    C   
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13      A    C   
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21      A    O   
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54      A    N   
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93      A    C   
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71      A    C   
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24      A    C   
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29      A    C   
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49      A    C   
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43      A    C   
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41      A    O   
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82      A    C   
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93      A    C   
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12      A    C   
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61      A    O   
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95      A    N   
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35      A    C   
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77      A    C   
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11      A    C   
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02      A    O   
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95      A    O   
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08      A    C   
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03      A    O   
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41      A    N   
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63      A    C   
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27      A    C   
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13      A    C   
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54      A    C   
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38      A    C   
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74      A    C   
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51      A    O   
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91      A    C   
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32      A    C   
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84      A    C   
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97      A    O   
ATOM    492  N   HIS    63      35.010  73.105  13.440  1.00 24.32      A    N   
ATOM    493  CA  HIS    63      33.615  73.111  13.872  1.00 25.56      A    C   
ATOM    494  CB  HIS    63      33.519  72.477  15.263  1.00 24.97      A    C   
ATOM    495  CG  HIS    63      34.160  71.127  15.321  1.00 24.22      A    C   
ATOM    496  ND1 HIS    63      35.270  70.847  16.088  1.00 28.07      A    N   
ATOM    497  CE1 HIS    63      35.632  69.590  15.888  1.00 26.20      A    C   
ATOM    498  NE2 HIS    63      34.807  69.053  15.003  1.00 26.25      A    N   
ATOM    499  CD2 HIS    63      33.881  69.993  14.634  1.00 22.43      A    C   
ATOM    500  C   HIS    63      33.056  74.547  13.817  1.00 27.28      A    C   
ATOM    501  O   HIS    63      33.586  75.443  14.467  1.00 29.56      A    O   
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66      A    N   
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40      A    C   
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92      A    C   
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74      A    C   
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41      A    C   
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53      A    C   
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81      A    O   
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51      A    N   
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90      A    C   
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10      A    C   
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99      A    C   
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84      A    C   
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20      A    C   
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73      A    O   
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87      A    N   
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85      A    C   
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88      A    C   
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29      A    C   
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66      A    O   
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76      A    N   
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53      A    C   
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00      A    C   
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77      A    C   
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49      A    O   
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84      A    O   
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00      A    C   
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51      A    O   
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05      A    N   
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09      A    C   
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00      A    C   
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64      A    C   
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82      A    C   
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10      A    C   
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28      A    N   
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41      A    C   
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19      A    O   
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13      A    N   
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80      A    C   
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60      A    C   
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76      A    C   
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41      A    C   
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04      A    C   
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41      A    C   
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95      A    O   
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13      A    N   
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67      A    C   
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50      A    C   
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84      A    C   
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92      A    C   
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60      A    C   
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62      A    C   
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75      A    O   
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82      A    C   
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32      A    C   
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40      A    C   
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25      A    O   
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95      A    N   
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52      A    C   
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43      A    C   
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15      A    C   
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14      A    C   
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13      A    C   
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79      A    O   
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52      A    N   
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27      A    C   
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65      A    C   
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42      A    O   
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32      A    N   
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94      A    C   
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83      A    C   
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16      A    O   
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98      A    C   
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46      A    O   
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33      A    N   
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00      A    C   
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66      A    C   
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27      A    C   
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00      A    C   
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45      A    N   
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96      A    C   
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65      A    N   
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44      A    N   
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93      A    C   
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89      A    O   
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79      A    N   
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83      A    C   
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62      A    C   
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43      A    C   
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70      A    C   
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62      A    C   
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18      A    O   
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40      A    N   
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21      A    C   
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42      A    C   
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77      A    C   
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22      A    C   
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24      A    C   
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16      A    O   
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51      A    N   
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54      A    C   
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86      A    C   
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89      A    C   
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43      A    O   
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68      A    N   
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04      A    C   
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30      A    C   
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63      A    C   
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97      A    C   
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00      A    C   
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09      A    N   
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29      A    C   
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83      A    O   
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82      A    N   
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33      A    C   
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99      A    C   
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73      A    C   
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64      A    C   
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11      A    C   
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97      A    C   
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65      A    O   
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25      A    C   
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71      A    C   
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65      A    C   
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57      A    O   
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32      A    N   
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27      A    C   
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32      A    C   
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72      A    C   
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04      A    C   
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43      A    C   
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93      A    N   
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48      A    C   
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81      A    O   
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78      A    N   
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62      A    C   
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24      A    C   
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99      A    C   
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44      A    O   
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57      A    O   
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52      A    C   
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39      A    O   
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60      A    N   
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72      A    C   
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07      A    C   
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78      A    O   
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49      A    N   
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85      A    C   
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92      A    C   
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01      A    C   
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64      A    O   
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43      A    N   
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94      A    C   
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99      A    O   
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49      A    N   
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91      A    C   
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50      A    C   
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10      A    C   
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73      A    C   
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41      A    O   
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20      A    N   
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46      A    C   
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29      A    O   
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39      A    N   
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91      A    C   
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56      A    C   
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69      A    C   
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70      A    C   
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15      A    C   
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90      A    O   
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99      A    N   
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21      A    C   
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50      A    C   
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34      A    C   
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51      A    C   
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04      A    N   
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89      A    C   
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94      A    C   
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27      A    C   
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48      A    C   
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06      A    C   
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81      A    C   
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19      A    C   
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63      A    O   
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91      A    N   
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62      A    C   
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68      A    C   
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51      A    C   
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55      A    C   
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57      A    C   
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15      A    C   
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15      A    O   
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09      A    N   
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91      A    C   
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64      A    C   
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36      A    C   
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44      A    C   
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12      A    C   
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12      A    C   
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59      A    O   
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18      A    C   
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61      A    C   
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17      A    C   
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43      A    O   
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08      A    N   
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00      A    C   
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19      A    C   
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22      A    C   
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28      A    O   
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54      A    N   
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43      A    C   
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72      A    C   
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00      A    O   
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87      A    N   
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36      A    C   
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32      A    C   
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77      A    C   
ATOM    718  CD1 ILE    91      21.004  68.804   3.522  1.00 26.35      A    C   
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37      A    C   
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40      A    C   
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69      A    O   
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01      A    N   
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58      A    C   
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01      A    C   
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99      A    C   
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64      A    C   
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26      A    C   
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42      A    O   
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59      A    N   
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19      A    C   
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13      A    C   
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92      A    C   
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56      A    O   
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37      A    N   
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21      A    C   
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92      A    C   
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03      A    C   
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98      A    C   
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90      A    O   
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28      A    O   
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23      A    C   
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59      A    O   
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37      A    N   
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74      A    C   
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84      A    C   
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78      A    O   
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52      A    C   
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60      A    C   
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69      A    O   
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69      A    N   
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59      A    C   
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22      A    C   
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67      A    C   
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43      A    C   
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84      A    C   
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06      A    O   
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07      A    N   
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93      A    C   
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42      A    C   
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70      A    C   
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18      A    O   
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03      A    N   
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34      A    C   
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04      A    O   
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73      A    N   
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02      A    C   
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18      A    C   
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17      A    C   
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25      A    C   
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86      A    C   
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40      A    O   
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93      A    N   
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74      A    C   
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01      A    C   
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21      A    C   
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77      A    C   
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90      A    C   
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85      A    N   
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32      A    C   
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38      A    O   
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61      A    N   
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96      A    C   
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58      A    C   
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24      A    C   
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88      A    O   
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73      A    N   
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87      A    C   
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07      A    O   
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69      A    N   
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96      A    C   
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57      A    C   
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38      A    C   
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44      A    C   
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30      A    C   
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55      A    N   
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33      A    C   
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46      A    O   
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23      A    N   
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59      A    C   
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55      A    C   
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10      A    C   
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70      A    C   
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74      A    C   
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80      A    C   
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60      A    O   
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82      A    N   
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44      A    C   
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22      A    C   
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32      A    C   
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56      A    C   
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24      A    N   
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25      A    C   
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17      A    N   
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74      A    N   
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49      A    C   
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66      A    O   
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03      A    N   
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77      A    C   
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90      A    C   
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91      A    C   
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77      A    C   
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30      A    C   
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62      A    C   
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79      A    C   
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41      A    C   
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73      A    C   
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07      A    O   
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95      A    N   
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90      A    C   
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16      A    C   
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79      A    C   
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70      A    C   
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00      A    C   
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31      A    C   
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80      A    O   
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01      A    N   
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24      A    C   
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24      A    C   
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43      A    C   
ATOM    840  CD1 ILE   106      23.603  67.212  12.165  1.00 20.23      A    C   
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52      A    C   
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58      A    C   
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61      A    O   
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23      A    N   
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45      A    C   
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44      A    C   
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93      A    C   
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99      A    C   
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41      A    C   
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32      A    C   
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50      A    C   
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35      A    C   
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80      A    C   
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67      A    O   
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44      A    N   
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55      A    C   
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60      A    C   
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49      A    C   
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81      A    C   
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08      A    C   
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48      A    C   
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72      A    C   
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79      A    C   
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19      A    C   
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68      A    O   
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03      A    N   
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13      A    C   
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75      A    C   
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93      A    C   
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78      A    O   
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40      A    O   
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28      A    C   
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96      A    O   
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54      A    N   
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57      A    C   
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39      A    C   
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68      A    C   
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45      A    O   
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92      A    O   
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52      A    C   
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49      A    O   
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29      A    N   
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31      A    C   
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94      A    C   
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78      A    O   
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27      A    N   
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81      A    C   
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78      A    C   
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13      A    C   
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13      A    C   
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46      A    C   
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51      A    C   
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35      A    O   
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49      A    C   
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42      A    C   
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38      A    C   
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60      A    O   
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28      A    N   
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48      A    C   
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94      A    C   
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88      A    C   
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02      A    O   
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78      A    N   
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51      A    C   
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32      A    C   
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59      A    O   
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14      A    C   
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10      A    O   
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88      A    N   
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97      A    C   
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23      A    C   
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98      A    C   
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69      A    C   
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06      A    C   
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17      A    C   
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32      A    O   
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57      A    C   
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00      A    C   
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83      A    C   
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57      A    O   
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72      A    N   
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52      A    C   
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69      A    C   
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00      A    C   
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31      A    C   
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61      A    C   
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30      A    O   
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89      A    N   
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98      A    C   
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31      A    C   
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79      A    O   
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61      A    C   
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21      A    C   
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79      A    O   
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01      A    N   
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28      A    C   
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49      A    C   
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99      A    C   
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55      A    C   
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72      A    O   
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57      A    N   
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10      A    C   
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56      A    O   
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49      A    N   
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07      A    C   
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47      A    C   
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78      A    O   
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32      A    C   
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85      A    O   
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18      A    N   
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24      A    C   
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92      A    C   
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83      A    C   
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58      A    C   
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17      A    O   
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52      A    O   
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67      A    C   
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73      A    O   
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86      A    N   
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32      A    C   
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01      A    C   
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02      A    C   
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23      A    C   
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86      A    C   
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96      A    C   
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86      A    O   
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66      A    N   
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39      A    C   
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52      A    C   
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82      A    C   
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09      A    C   
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95      A    C   
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50      A    C   
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88      A    O   
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16      A    C   
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29      A    C   
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68      A    C   
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71      A    O   
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87      A    N   
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79      A    C   
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35      A    C   
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92      A    C   
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87      A    C   
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69      A    C   
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01      A    O   
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52      A    N   
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49      A    C   
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21      A    C   
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81      A    C   
ATOM    990  CD1 ILE   124      28.803  68.039   3.091  1.00 25.49      A    C   
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25      A    C   
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92      A    C   
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39      A    O   
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68      A    N   
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92      A    C   
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66      A    C   
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72      A    S   
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26      A    C   
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07      A    O   
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14      A    N   
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10      A    C   
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44      A    C   
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05      A    C   
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38      A    C   
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14      A    N   
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93      A    C   
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80      A    N   
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37      A    N   
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61      A    C   
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58      A    O   
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84      A    N   
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55      A    C   
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73      A    C   
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71      A    C   
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69      A    C   
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20      A    C   
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13      A    O   
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93      A    N   
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11      A    C   
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11      A    C   
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78      A    C   
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21      A    C   
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11      A    C   
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10      A    C   
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50      A    O   
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83      A    N   
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96      A    C   
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23      A    C   
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25      A    C   
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12      A    C   
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73      A    C   
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80      A    N   
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59      A    C   
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18      A    O   
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19      A    N   
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79      A    C   
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69      A    C   
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99      A    C   
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29      A    C   
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81      A    C   
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82      A    N   
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63      A    C   
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95      A    O   
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22      A    N   
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50      A    C   
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06      A    C   
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82      A    O   
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04      A    C   
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62      A    C   
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97      A    O   
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04      A    N   
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89      A    C   
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11      A    C   
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44      A    C   
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59      A    C   
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49      A    N   
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16      A    C   
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91      A    C   
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11      A    C   
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36      A    C   
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08      A    C   
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78      A    C   
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73      A    C   
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50      A    O   
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66      A    N   
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34      A    C   
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61      A    C   
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64      A    C   
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80      A    C   
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45      A    O   
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15      A    O   
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32      A    C   
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86      A    O   
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24      A    N   
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25      A    C   
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54      A    C   
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08      A    C   
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87      A    O   
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84      A    O   
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00      A    C   
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24      A    O   
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19      A    N   
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87      A    C   
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06      A    C   
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49      A    C   
ATOM   1086  CD1 ILE   135      19.824  64.761   1.305  1.00 23.82      A    C   
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41      A    C   
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62      A    C   
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83      A    O   
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22      A    N   
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84      A    C   
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33      A    C   
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07      A    C   
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16      A    C   
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64      A    O   
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16      A    O   
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21      A    C   
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43      A    O   
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97      A    N   
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33      A    C   
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96      A    C   
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40      A    C   
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12      A    O   
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44      A    O   
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22      A    C   
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47      A    O   
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01      A    N   
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20      A    C   
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03      A    C   
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30      A    C   
ATOM   1111  CD1 ILE   138      16.726  60.053  -7.522  1.00 39.39      A    C   
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48      A    C   
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36      A    C   
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12      A    O   
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01      A    N   
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00      A    C   
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18      A    C   
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34      A    O   
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51      A    C   
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97      A    O   
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81      A    N   
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88      A    C   
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25      A    C   
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11      A    S   
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83      A    C   
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62      A    O   
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66      A    N   
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46      A    C   
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64      A    C   
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59      A    C   
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60      A    C   
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75      A    N   
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41      A    C   
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78      A    N   
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62      A    N   
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45      A    C   
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66      A    O   
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96      A    N   
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71      A    C   
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78      A    C   
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65      A    C   
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59      A    O   
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79      A    O   
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31      A    C   
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37      A    O   
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25      A    N   
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37      A    C   
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32      A    C   
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89      A    C   
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74      A    C   
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27      A    C   
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23      A    C   
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99      A    C   
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83      A    C   
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84      A    C   
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22      A    O   
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15      A    N   
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71      A    C   
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41      A    C   
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65      A    C   
ATOM   1161  CD1 ILE   144      16.433  64.307   5.309  1.00 32.59      A    C   
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38      A    C   
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23      A    C   
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99      A    O   
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54      A    N   
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22      A    C   
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83      A    C   
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06      A    C   
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55      A    C   
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48      A    O   
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38      A    O   
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02      A    C   
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51      A    O   
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22      A    N   
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31      A    C   
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99      A    C   
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93      A    C   
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96      A    C   
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56      A    O   
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44      A    O   
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30      A    C   
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67      A    O   
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95      A    N   
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26      A    C   
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62      A    C   
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42      A    C   
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78      A    C   
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51      A    C   
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34      A    C   
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94      A    O   
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26      A    C   
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68      A    C   
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42      A    C   
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71      A    O   
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89      A    N   
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22      A    C   
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51      A    C   
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81      A    C   
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91      A    C   
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19      A    C   
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11      A    O   
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28      A    N   
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60      A    C   
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71      A    C   
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07      A    O   
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99      A    C   
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95      A    C   
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70      A    O   
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59      A    N   
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60      A    C   
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85      A    C   
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59      A    C   
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80      A    O   
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51      A    N   
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02      A    C   
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25      A    C   
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64      A    C   
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89      A    C   
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64      A    C   
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96      A    C   
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53      A    O   
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39      A    C   
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63      A    C   
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26      A    C   
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36      A    O   
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02      A    N   
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87      A    C   
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97      A    C   
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14      A    C   
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10      A    C   
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49      A    C   
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95      A    O   
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00           N   
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00           C   
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00           C   
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00           C   
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11      A    O   
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24      A    N   
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67      A    C   
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22      A    C   
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95      A    C   
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24      A    C   
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56      A    N   
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65      A    C   
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10      A    N   
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91      A    N   
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48      A    C   
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60      A    O   
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81      A    N   
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57      A    C   
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30      A    C   
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91      A    C   
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74      A    C   
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68      A    C   
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45      A    O   
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58      A    N   
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91      A    C   
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72      A    C   
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80      A    C   
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27      A    S   
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73      A    C   
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88      A    C   
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77      A    O   
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68      A    N   
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94      A    C   
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31      A    C   
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02      A    C   
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19      A    C   
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70      A    C   
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12      A    O   
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86      A    N   
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34      A    C   
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76      A    C   
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71      A    C   
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52      A    C   
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91      A    C   
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36      A    C   
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38      A    O   
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39      A    N   
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82      A    C   
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48      A    C   
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98      A    C   
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19      A    C   
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71      A    C   
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84      A    C   
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14      A    O   
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05      A    N   
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85      A    C   
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53      A    C   
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66      A    C   
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77      A    C   
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29      A    C   
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32      A    N   
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60      A    C   
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59      A    O   
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08      A    N   
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57      A    C   
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74      A    C   
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20      A    O   
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82      A    C   
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39      A    O   
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79      A    N   
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54      A    C   
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96      A    C   
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12      A    O   
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51      A    N   
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64      A    C   
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76      A    C   
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65      A    C   
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28      A    C   
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12      A    O   
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38      A    N   
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12      A    C   
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39      A    O   
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12      A    N   
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66      A    C   
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46      A    C   
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68      A    C   
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83      A    C   
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29      A    C   
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79      A    C   
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92      A    O   
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19      A    N   
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22      A    C   
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55      A    C   
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94      A    C   
ATOM   1327  CD1 ILE   165       6.209  52.315  15.886  1.00 31.23      A    C   
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32      A    C   
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55      A    C   
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72      A    O   
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69      A    N   
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62      A    C   
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02      A    C   
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39      A    C   
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70      A    C   
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81      A    C   
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59      A    N   
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66      A    C   
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59      A    O   
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49      A    N   
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44      A    C   
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65      A    C   
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70      A    O   
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83      A    C   
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50      A    C   
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37      A    O   
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23      A    N   
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42      A    C   
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75      A    C   
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02      A    C   
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37      A    C   
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81      A    O   
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83      A    O   
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47      A    C   
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48      A    O   
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67      A    N   
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31      A    C   
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92      A    C   
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33      A    C   
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61      A    C   
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22      A    N   
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95      A    C   
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43      A    C   
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18      A    C   
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32      A    C   
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82      A    C   
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67      A    C   
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81      A    C   
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65      A    O   
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53      A    N   
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22      A    C   
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81      A    C   
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48      A    C   
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91      A    C   
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38      A    O   
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53      A    O   
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91      A    C   
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93      A    O   
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29      A    N   
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97      A    C   
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96      A    C   
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58      A    O   
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03      A    N   
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14      A    C   
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39      A    C   
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72      A    O   
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96      A    C   
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58      A    C   
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06      A    O   
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62      A    N   
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25      A    C   
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07      A    C   
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76      A    C   
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53      A    C   
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95      A    N   
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13      A    C   
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72      A    C   
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76      A    C   
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92      A    C   
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47      A    C   
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94      A    C   
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59      A    C   
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02      A    O   
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27      A    N   
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02      A    C   
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07      A    C   
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96      A    C   
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25      A    C   
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15      A    N   
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78      A    C   
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29      A    C   
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76      A    C   
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16      A    C   
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08      A    C   
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93      A    C   
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03      A    C   
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12      A    O   
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58      A    N   
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08      A    C   
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32      A    C   
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83      A    C   
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01      A    C   
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96      A    C   
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78      A    N   
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65      A    C   
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82      A    O   
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57      A    N   
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13      A    C   
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30      A    C   
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50      A    O   
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23      A    C   
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69      A    O   
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37      A    N   
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78      A    C   
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90      A    C   
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76      A    C   
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41      A    C   
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84      A    N   
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54      A    C   
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82      A    N   
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67      A    N   
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14      A    C   
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15      A    O   
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17      A    N   
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26      A    C   
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41      A    C   
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74      A    C   
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77      A    C   
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35      A    C   
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94      A    O   
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10      A    N   
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30      A    C   
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27      A    C   
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60      A    C   
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02      A    C   
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04      A    O   
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81      A    O   
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78      A    C   
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10      A    O   
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01      A    N   
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48      A    C   
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67      A    C   
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28      A    C   
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92      A    C   
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88      A    O   
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40      A    O   
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39      A    C   
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18      A    O   
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81      A    N   
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39      A    C   
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32      A    C   
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58      A    C   
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76      A    C   
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51      A    C   
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24      A    O   
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81      A    N   
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85      A    C   
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36      A    C   
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04      A    C   
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46      A    O   
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63      A    O   
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34      A    C   
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28      A    O   
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60      A    N   
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82      A    C   
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12      A    C   
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15      A    O   
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45      A    N   
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55      A    C   
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99      A    C   
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01      A    O   
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84      A    C   
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91      A    O   
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02      A    N   
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76      A    C   
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01      A    C   
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62      A    C   
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91      A    C   
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03      A    C   
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69      A    C   
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74      A    O   
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00      A    N   
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67      A    C   
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49      A    C   
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21      A    C   
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37      A    C   
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33      A    C   
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21      A    O   
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88      A    N   
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64      A    C   
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81      A    C   
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28      A    C   
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49      A    C   
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90      A    N   
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02      A    C   
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12      A    N   
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09      A    N   
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66      A    C   
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30      A    O   
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33      A    N   
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61      A    C   
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16      A    C   
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49      A    C   
ATOM   1524  CD1 ILE   188      10.070  52.171  17.195  1.00 22.12      A    C   
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97      A    C   
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24      A    C   
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98      A    O   
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53      A    N   
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66      A    C   
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05      A    C   
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76      A    C   
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44      A    C   
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56      A    C   
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30      A    C   
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61      A    O   
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27      A    N   
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14      A    C   
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24      A    C   
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90      A    C   
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65      A    C   
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09      A    C   
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22      A    C   
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07      A    C   
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13      A    C   
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23      A    C   
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45      A    O   
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88      A    N   
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39      A    C   
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37      A    C   
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18      A    C   
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11      A    C   
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76      A    C   
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98      A    C   
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06      A    O   
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15      A    N   
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12      A    C   
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35      A    C   
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17      A    C   
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49      A    O   
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48      A    O   
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20      A    C   
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84      A    O   
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46      A    N   
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90      A    C   
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22      A    C   
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81      A    C   
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17      A    O   
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73      A    O   
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40      A    C   
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81      A    O   
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79      A    N   
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00      A    C   
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11      A    C   
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34      A    C   
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22      A    C   
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08      A    C   
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25      A    N   
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17      A    C   
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60      A    O   
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73      A    N   
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18      A    C   
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44      A    C   
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65      A    C   
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06      A    C   
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18      A    N   
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07      A    C   
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04      A    N   
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77      A    N   
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81      A    C   
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67      A    O   
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17      A    N   
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89      A    C   
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26      A    C   
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76      A    S   
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18      A    C   
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50      A    O   
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36      A    N   
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74      A    C   
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30      A    C   
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31      A    C   
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51      A    C   
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61      A    O   
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47      A    O   
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94      A    C   
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12      A    O   
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46      A    N   
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05      A    C   
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37      A    C   
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69      A    C   
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54      A    C   
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80      A    N   
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60      A    C   
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83      A    C   
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73      A    C   
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65      A    C   
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44      A    C   
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23      A    C   
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26      A    C   
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58      A    O   
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43      A    N   
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27      A    C   
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13      A    C   
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58      A    C   
ATOM   1624  CD1 ILE   199      12.999  52.559  12.729  1.00 20.55      A    C   
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51      A    C   
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19      A    C   
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92      A    O   
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19      A    N   
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38      A    C   
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91      A    C   
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47      A    C   
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20      A    C   
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57      A    C   
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44      A    C   
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50      A    O   
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12      A    C   
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97      A    C   
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26      A    C   
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54      A    O   
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69      A    N   
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36      A    C   
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88      A    C   
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58      A    C   
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28      A    C   
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92      A    N   
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45      A    C   
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56      A    N   
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01      A    N   
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86      A    C   
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26      A    O   
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88      A    N   
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49      A    C   
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20      A    C   
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50      A    O   
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52      A    N   
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94      A    C   
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80      A    C   
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15      A    O   
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74      A    C   
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11      A    O   
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13      A    N   
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63      A    C   
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86      A    C   
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83      A    O   
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24      A    C   
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93      A    C   
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95      A    O   
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76      A    N   
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56      A    C   
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52      A    C   
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50      A    C   
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97      A    C   
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21      A    N   
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11      A    C   
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43      A    N   
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70      A    N   
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63      A    C   
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00      A    O   
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37      A    N   
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66      A    C   
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91      A    C   
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37      A    C   
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02      A    C   
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72      A    C   
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09      A    C   
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64      A    O   
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26      A    N   
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27      A    C   
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33      A    C   
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61      A    C   
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10      A    C   
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09      A    O   
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83      A    O   
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60      A    C   
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76      A    O   
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26      A    N   
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94      A    C   
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04      A    C   
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06      A    C   
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74      A    C   
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96      A    C   
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24      A    O   
END
