
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  246 ( 1973),  selected  246 , name 2fue_A
# Molecule2: number of CA atoms  275 ( 2161),  selected  275 , name T0505.pdb
# PARAMETERS: 2fue_A.T0505.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R    13_A      K       6           #
LGA    V    14_A      Q       7          1.237
LGA    L    15_A      L       8          1.467
LGA    C    16_A      L       9          1.265
LGA    L    17_A      A      10          1.367
LGA    F    18_A      L      11          1.182
LGA    D    19_A      N      12          1.688
LGA    V    20_A      I      13          1.724
LGA    D    21_A      D      14          1.672
LGA    G    22_A      G      15          1.437
LGA    T    23_A      A      16          1.733
LGA    L    24_A      L      17          1.493
LGA    T    25_A      L      18          1.312
LGA    P    26_A      R      19          2.718
LGA    A    27_A      S      20           #
LGA    R    28_A      N      21           -
LGA    Q    29_A      G      22          1.745
LGA    K    30_A      K      23          2.621
LGA    I    31_A      I      24          1.443
LGA    D    32_A      H      25          1.377
LGA    P    33_A      Q      26          2.089
LGA    E    34_A      A      27          1.996
LGA    V    35_A      T      28          1.186
LGA    A    36_A      K      29          1.471
LGA    A    37_A      D      30          1.874
LGA    F    38_A      A      31          1.659
LGA    L    39_A      I      32          1.103
LGA    Q    40_A      E      33          0.793
LGA    K    41_A      Y      34          1.593
LGA    L    42_A      V      35          1.891
LGA    R    43_A      K      36          1.501
LGA    S    44_A      K      37          1.247
LGA    R    45_A      K      38          0.965
LGA    V    46_A      G      39          3.209
LGA    Q    47_A      I      40          2.575
LGA    -       -      Y      41           -
LGA    I    48_A      V      42          1.305
LGA    G    49_A      T      43          1.285
LGA    V    50_A      L      44          1.157
LGA    V    51_A      V      45          0.983
LGA    G    52_A      T      46          0.572
LGA    G    53_A      N      47          1.079
LGA    S    54_A      R      48          0.717
LGA    D    55_A      H      49          0.630
LGA    Y    56_A      F      50          1.954
LGA    C    57_A      R      51          2.420
LGA    K    58_A      S      52          2.381
LGA    I    59_A      A      53          2.419
LGA    A    60_A      Q      54          3.873
LGA    E    61_A      K      55          4.839
LGA    Q    62_A      I      56          4.778
LGA    L    63_A      A      57           #
LGA    G    64_A      -       -           -
LGA    D    65_A      -       -           -
LGA    G    66_A      -       -           -
LGA    D    67_A      K      58          4.141
LGA    E    68_A      S      59          3.606
LGA    V    69_A      L      60          4.786
LGA    I    70_A      -       -           -
LGA    E    71_A      -       -           -
LGA    K    72_A      K      61          1.472
LGA    F    73_A      L      62          1.539
LGA    D    74_A      D      63          4.064
LGA    Y    75_A      A      64          2.251
LGA    V    76_A      K      65          4.430
LGA    F    77_A      L      66          1.846
LGA    -       -      I      67           -
LGA    A    78_A      T      68          1.621
LGA    E    79_A      H      69          1.556
LGA    N    80_A      S      70          3.083
LGA    G    81_A      G      71          3.633
LGA    T    82_A      A      72          3.109
LGA    V    83_A      Y      73          2.655
LGA    Q    84_A      I      74          2.830
LGA    Y    85_A      A      75          3.562
LGA    K    86_A      E      76          4.425
LGA    H    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    R    89_A      K      77          4.668
LGA    L    90_A      I      78          5.128
LGA    -       -      D      79           -
LGA    -       -      A      80           -
LGA    L    91_A      P      81          2.987
LGA    S    92_A      F      82          4.114
LGA    K    93_A      F      83          4.223
LGA    Q    94_A      E      84          2.513
LGA    T    95_A      K      85          2.925
LGA    I    96_A      R      86          1.909
LGA    -       -      I      87           -
LGA    Q    97_A      S      88          3.753
LGA    N    98_A      D      89           -
LGA    H    99_A      -       -           -
LGA    L   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    E   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    L   104_A      -       -           -
LGA    L   105_A      D      90          5.388
LGA    Q   106_A      H      91          2.580
LGA    D   107_A      T      92           -
LGA    L   108_A      -       -           -
LGA    I   109_A      F      93          3.146
LGA    N   110_A      N      94          1.820
LGA    F   111_A      I      95          4.771
LGA    C   112_A      V      96          3.391
LGA    L   113_A      Q      97          1.138
LGA    S   114_A      V      98          4.766
LGA    Y   115_A      L      99          5.251
LGA    X   116_A      E     100          1.702
LGA    A   117_A      -       -           -
LGA    L   118_A      S     101          4.441
LGA    L   119_A      Y     102          5.348
LGA    R   120_A      Q     103           #
LGA    L   121_A      C     104           #
LGA    P   122_A      -       -           -
LGA    K   123_A      -       -           -
LGA    K   124_A      -       -           -
LGA    R   125_A      N     105           #
LGA    G   126_A      -       -           -
LGA    T   127_A      -       -           -
LGA    F   128_A      I     106          5.041
LGA    I   129_A      R     107           #
LGA    E   130_A      L     108          1.699
LGA    F   131_A      L     109           #
LGA    R   132_A      H     110          2.761
LGA    N   133_A      E     111           #
LGA    G   134_A      K     112           -
LGA    X   135_A      Y     113           -
LGA    L   136_A      S     114           -
LGA    N   137_A      -       -           -
LGA    I   138_A      I     115           #
LGA    S   139_A      G     116           #
LGA    P   140_A      -       -           -
LGA    I   141_A      N     117          3.846
LGA    G   142_A      K     118          3.804
LGA    -       -      K     119           -
LGA    -       -      K     120           -
LGA    -       -      V     121           -
LGA    -       -      N     122           -
LGA    -       -      S     123           -
LGA    -       -      N     124           -
LGA    -       -      L     125           -
LGA    -       -      L     126           -
LGA    -       -      G     127           -
LGA    -       -      K     128           -
LGA    -       -      A     129           -
LGA    -       -      L     130           -
LGA    -       -      I     131           -
LGA    -       -      H     132           -
LGA    -       -      P     133           -
LGA    -       -      S     134           -
LGA    -       -      D     135           -
LGA    -       -      P     136           -
LGA    -       -      I     137           -
LGA    -       -      F     138           -
LGA    -       -      Y     139           -
LGA    -       -      P     140           -
LGA    -       -      V     141           -
LGA    R   143_A      Q     142           #
LGA    S   144_A      F     143          1.310
LGA    C   145_A      V     144           #
LGA    T   146_A      E     145           -
LGA    L   147_A      S     146           -
LGA    E   148_A      L     147           -
LGA    E   149_A      S     148           -
LGA    R   150_A      D     149           -
LGA    I   151_A      L     150           -
LGA    E   152_A      L     151           -
LGA    -       -      M     152           -
LGA    -       -      D     153           -
LGA    -       -      E     154           -
LGA    -       -      P     155           -
LGA    -       -      V     156           -
LGA    -       -      S     157           -
LGA    -       -      A     158           -
LGA    -       -      P     159           -
LGA    -       -      V     160           -
LGA    -       -      I     161           -
LGA    -       -      E     162           -
LGA    -       -      V     163           -
LGA    F   153_A      Y     164           #
LGA    S   154_A      -       -           -
LGA    E   155_A      -       -           -
LGA    L   156_A      -       -           -
LGA    D   157_A      T     165          4.716
LGA    K   158_A      E     166          3.101
LGA    K   159_A      H     167           -
LGA    E   160_A      -       -           -
LGA    K   161_A      D     168          4.393
LGA    I   162_A      I     169          5.488
LGA    R   163_A      Q     170          5.519
LGA    E   164_A      H     171          5.198
LGA    K   165_A      D     172          3.786
LGA    F   166_A      I     173          3.126
LGA    V   167_A      T     174          3.152
LGA    E   168_A      E     175          3.287
LGA    A   169_A      T     176          2.066
LGA    L   170_A      I     177          1.743
LGA    K   171_A      T     178          2.642
LGA    T   172_A      K     179          3.303
LGA    E   173_A      A     180          2.851
LGA    F   174_A      F     181          3.746
LGA    A   175_A      -       -           -
LGA    G   176_A      -       -           -
LGA    K   177_A      P     182          2.313
LGA    G   178_A      A     183          5.335
LGA    L   179_A      V     184          2.816
LGA    R   180_A      D     185          2.145
LGA    F   181_A      V     186          1.859
LGA    S   182_A      I     187          3.680
LGA    -       -      R     188           -
LGA    -       -      V     189           -
LGA    -       -      N     190           -
LGA    -       -      D     191           -
LGA    -       -      E     192           -
LGA    R   183_A      K     193          1.816
LGA    G   184_A      L     194          4.724
LGA    G   185_A      -       -           -
LGA    X   186_A      -       -           -
LGA    I   187_A      -       -           -
LGA    S   188_A      -       -           -
LGA    F   189_A      -       -           -
LGA    D   190_A      N     195          2.288
LGA    V   191_A      I     196          0.831
LGA    F   192_A      V     197          0.973
LGA    P   193_A      P     198          2.707
LGA    E   194_A      K     199          3.679
LGA    G   195_A      G     200          3.066
LGA    W   196_A      V     201          1.407
LGA    D   197_A      S     202          1.462
LGA    K   198_A      K     203          0.567
LGA    R   199_A      E     204          1.542
LGA    Y   200_A      A     205          2.701
LGA    C   201_A      G     206          2.135
LGA    -       -      L     207           -
LGA    L   202_A      A     208          1.608
LGA    D   203_A      L     209          1.243
LGA    S   204_A      V     210          2.908
LGA    L   205_A      A     211          2.177
LGA    D   206_A      S     212          0.547
LGA    Q   207_A      E     213          2.117
LGA    D   208_A      L     214          0.957
LGA    S   209_A      G     215          2.336
LGA    F   210_A      L     216          3.503
LGA    D   211_A      S     217           #
LGA    -       -      M     218           -
LGA    -       -      D     219           -
LGA    T   212_A      D     220          1.848
LGA    I   213_A      V     221          1.832
LGA    H   214_A      V     222          1.573
LGA    F   215_A      A     223          1.411
LGA    F   216_A      I     224          1.662
LGA    G   217_A      G     225          1.646
LGA    N   218_A      H     226          2.172
LGA    E   219_A      Q     227          2.969
LGA    T   220_A      -       -           -
LGA    S   221_A      -       -           -
LGA    P   222_A      -       -           -
LGA    G   223_A      -       -           -
LGA    G   224_A      Y     228          0.814
LGA    N   225_A      D     229          1.248
LGA    D   226_A      D     230          0.942
LGA    F   227_A      L     231          1.235
LGA    E   228_A      P     232          1.418
LGA    I   229_A      M     233          1.504
LGA    F   230_A      I     234          1.829
LGA    A   231_A      E     235          1.928
LGA    D   232_A      L     236          2.174
LGA    P   233_A      -       -           -
LGA    R   234_A      A     237           #
LGA    T   235_A      G     238          3.856
LGA    V   236_A      L     239          3.010
LGA    G   237_A      G     240          2.064
LGA    H   238_A      V     241          2.300
LGA    S   239_A      A     242          2.510
LGA    V   240_A      M     243          2.794
LGA    V   241_A      G     244          1.743
LGA    -       -      N     245           -
LGA    -       -      A     246           -
LGA    -       -      V     247           -
LGA    -       -      P     248           -
LGA    -       -      E     249           -
LGA    -       -      I     250           -
LGA    -       -      K     251           -
LGA    -       -      R     252           -
LGA    -       -      K     253           -
LGA    -       -      A     254           -
LGA    -       -      D     255           -
LGA    -       -      W     256           -
LGA    -       -      V     257           -
LGA    -       -      T     258           -
LGA    -       -      R     259           -
LGA    S   242_A      S     260          2.278
LGA    P   243_A      N     261          3.668
LGA    -       -      D     262           -
LGA    -       -      E     263           -
LGA    Q   244_A      Q     264          2.236
LGA    D   245_A      G     265          2.529
LGA    T   246_A      V     266          2.406
LGA    V   247_A      A     267          1.751
LGA    Q   248_A      Y     268          1.956
LGA    R   249_A      M     269          1.874
LGA    C   250_A      M     270          1.146
LGA    R   251_A      K     271          1.245
LGA    E   252_A      E     272          1.463
LGA    I   253_A      Y     273          1.580
LGA    F   254_A      F     274          2.231
LGA    F   255_A      R     275          3.932
LGA    P   256_A      M     276          3.828
LGA    -       -      Q     277           -
LGA    E   257_A      Q     278          3.758
LGA    T   258_A      R     279           -
LGA    -       -      K     280           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  246  275    5.0    177    2.78    13.56     39.647     6.139

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.398691 * X  +   0.827941 * Y  +  -0.394409 * Z  +  76.568863
  Y_new =  -0.700019 * X  +   0.003095 * Y  +   0.714118 * Z  + -25.077698
  Z_new =   0.592469 * X  +   0.560806 * Y  +   0.578340 * Z  +  -5.368434 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.770007   -2.371586  [ DEG:    44.1181   -135.8819 ]
  Theta =  -0.634120   -2.507473  [ DEG:   -36.3324   -143.6676 ]
  Phi   =  -2.088521    1.053072  [ DEG:  -119.6634     60.3366 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fue_A                                        
REMARK     2: T0505.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fue_A.T0505.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  246  275   5.0  177   2.78   13.56  39.647
REMARK  ---------------------------------------------------------- 
MOLECULE 2fue_A
HEADER    ISOMERASE                               26-JAN-06   2FUE              
TITLE     HUMAN ALPHA-PHOSPHOMANNOMUTASE 1 WITH D-MANNOSE 1-PHOSPHATE           
TITLE    2 AND MG2+ COFACTOR BOUND                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOMANNOMUTASE 1;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PMM 1, PMMH-22;                                             
COMPND   5 EC: 5.4.2.8;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-28B                                   
KEYWDS    PHOSPHOMANNOMUTASE, ENZYME-PRODUCT COMPLEX, PROTEIN                   
KEYWDS   2 GLYCOSYLATION, CARBOHYDRATE-DEFICIENT GLYCOPROTEIN SYNDROME,         
KEYWDS   3 HALOALKANOIC ACID DEHALOGENASE SUPERFAMILY                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.R.SILVAGGI,C.ZHANG,Z.LU,D.DUNAWAY-MARIANO,K.N.ALLEN                 
REVDAT   2   07-NOV-06 2FUE    1       JRNL                                     
REVDAT   1   21-MAR-06 2FUE    0                                                
JRNL        AUTH   N.R.SILVAGGI,C.ZHANG,Z.LU,J.DAI,D.DUNAWAY-MARIANO,           
JRNL        AUTH 2 K.N.ALLEN                                                    
JRNL        TITL   THE X-RAY CRYSTAL STRUCTURES OF HUMAN                        
JRNL        TITL 2 ALPHA-PHOSPHOMANNOMUTASE 1 REVEAL THE STRUCTURAL             
JRNL        TITL 3 BASIS OF CONGENITAL DISORDER OF GLYCOSYLATION TYPE           
JRNL        TITL 4 1A.                                                          
JRNL        REF    J.BIOL.CHEM.                  V. 281 14918 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  2FUE A    1   262  UNP    Q92871   PMM1_HUMAN       1    262             
SEQRES   1 A  262  MSE ALA VAL THR ALA GLN ALA ALA ARG ARG LYS GLU ARG          
SEQRES   2 A  262  VAL LEU CYS LEU PHE ASP VAL ASP GLY THR LEU THR PRO          
SEQRES   3 A  262  ALA ARG GLN LYS ILE ASP PRO GLU VAL ALA ALA PHE LEU          
SEQRES   4 A  262  GLN LYS LEU ARG SER ARG VAL GLN ILE GLY VAL VAL GLY          
SEQRES   5 A  262  GLY SER ASP TYR CYS LYS ILE ALA GLU GLN LEU GLY ASP          
SEQRES   6 A  262  GLY ASP GLU VAL ILE GLU LYS PHE ASP TYR VAL PHE ALA          
SEQRES   7 A  262  GLU ASN GLY THR VAL GLN TYR LYS HIS GLY ARG LEU LEU          
SEQRES   8 A  262  SER LYS GLN THR ILE GLN ASN HIS LEU GLY GLU GLU LEU          
SEQRES   9 A  262  LEU GLN ASP LEU ILE ASN PHE CYS LEU SER TYR MSE ALA          
SEQRES  10 A  262  LEU LEU ARG LEU PRO LYS LYS ARG GLY THR PHE ILE GLU          
SEQRES  11 A  262  PHE ARG ASN GLY MSE LEU ASN ILE SER PRO ILE GLY ARG          
SEQRES  12 A  262  SER CYS THR LEU GLU GLU ARG ILE GLU PHE SER GLU LEU          
SEQRES  13 A  262  ASP LYS LYS GLU LYS ILE ARG GLU LYS PHE VAL GLU ALA          
SEQRES  14 A  262  LEU LYS THR GLU PHE ALA GLY LYS GLY LEU ARG PHE SER          
SEQRES  15 A  262  ARG GLY GLY MSE ILE SER PHE ASP VAL PHE PRO GLU GLY          
SEQRES  16 A  262  TRP ASP LYS ARG TYR CYS LEU ASP SER LEU ASP GLN ASP          
SEQRES  17 A  262  SER PHE ASP THR ILE HIS PHE PHE GLY ASN GLU THR SER          
SEQRES  18 A  262  PRO GLY GLY ASN ASP PHE GLU ILE PHE ALA ASP PRO ARG          
SEQRES  19 A  262  THR VAL GLY HIS SER VAL VAL SER PRO GLN ASP THR VAL          
SEQRES  20 A  262  GLN ARG CYS ARG GLU ILE PHE PHE PRO GLU THR ALA HIS          
SEQRES  21 A  262  GLU ALA                                                      
HET    MSE  A 116       8                                                       
HET    MSE  A 135       8                                                       
HET    MSE  A 186      13                                                       
HET    M1P    400      16                                                       
HET     MG    500       1                                                       
HET     MG    501       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     M1P ALPHA-D-MANNOSE 1-PHOSPHATE                                      
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  M1P    C6 H13 O9 P                                                  
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   5  HOH   *238(H2 O)                                                    
CRYST1   51.390   51.390  214.603  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   ARG A  13      28.139  10.726  53.942  1.00 37.79           N  
ATOM      2  CA  ARG A  13      28.421  11.735  54.997  1.00 37.68           C  
ATOM      3  C   ARG A  13      29.733  11.416  55.702  1.00 36.50           C  
ATOM      4  O   ARG A  13      29.791  10.519  56.537  1.00 36.04           O  
ATOM      5  CB  ARG A  13      27.301  11.764  56.030  1.00 38.08           C  
ATOM      6  CG  ARG A  13      26.010  12.361  55.522  1.00 39.26           C  
ATOM      7  CD  ARG A  13      24.952  12.376  56.601  1.00 39.17           C  
ATOM      8  NE  ARG A  13      25.337  13.182  57.755  1.00 40.89           N  
ATOM      9  CZ  ARG A  13      25.277  14.509  57.820  1.00 39.95           C  
ATOM     10  NH1 ARG A  13      24.862  15.224  56.779  1.00 41.36           N  
ATOM     11  NH2 ARG A  13      25.637  15.118  58.938  1.00 39.40           N  
ATOM     12  N   VAL A  14      30.776  12.163  55.362  1.00 35.36           N  
ATOM     13  CA  VAL A  14      32.100  11.905  55.888  1.00 34.79           C  
ATOM     14  C   VAL A  14      32.602  13.153  56.603  1.00 34.36           C  
ATOM     15  O   VAL A  14      32.343  14.267  56.150  1.00 34.27           O  
ATOM     16  CB  VAL A  14      33.071  11.501  54.762  1.00 35.21           C  
ATOM     17  CG1 VAL A  14      34.462  11.286  55.311  1.00 34.33           C  
ATOM     18  CG2 VAL A  14      32.588  10.238  54.057  1.00 35.20           C  
ATOM     19  N   LEU A  15      33.277  12.948  57.733  1.00 34.15           N  
ATOM     20  CA  LEU A  15      33.981  14.010  58.448  1.00 33.95           C  
ATOM     21  C   LEU A  15      35.462  13.713  58.421  1.00 33.96           C  
ATOM     22  O   LEU A  15      35.872  12.598  58.742  1.00 34.07           O  
ATOM     23  CB  LEU A  15      33.518  14.105  59.902  1.00 33.71           C  
ATOM     24  CG  LEU A  15      34.251  15.109  60.805  1.00 33.54           C  
ATOM     25  CD1 LEU A  15      34.098  16.548  60.291  1.00 32.87           C  
ATOM     26  CD2 LEU A  15      33.767  14.994  62.259  1.00 33.48           C  
ATOM     27  N   CYS A  16      36.266  14.702  58.042  1.00 33.52           N  
ATOM     28  CA  CYS A  16      37.701  14.651  58.321  1.00 33.56           C  
ATOM     29  C   CYS A  16      37.985  15.530  59.527  1.00 33.60           C  
ATOM     30  O   CYS A  16      37.656  16.725  59.535  1.00 32.88           O  
ATOM     31  CB  CYS A  16      38.530  15.077  57.114  1.00 34.06           C  
ATOM     32  SG  CYS A  16      38.512  13.830  55.787  1.00 35.12           S  
ATOM     33  N   LEU A  17      38.583  14.920  60.544  1.00 33.26           N  
ATOM     34  CA  LEU A  17      38.851  15.562  61.811  1.00 33.38           C  
ATOM     35  C   LEU A  17      40.347  15.597  62.041  1.00 33.74           C  
ATOM     36  O   LEU A  17      41.006  14.553  62.044  1.00 33.48           O  
ATOM     37  CB  LEU A  17      38.167  14.789  62.931  1.00 33.39           C  
ATOM     38  CG  LEU A  17      38.216  15.349  64.339  1.00 33.96           C  
ATOM     39  CD1 LEU A  17      37.589  16.729  64.432  1.00 33.33           C  
ATOM     40  CD2 LEU A  17      37.511  14.363  65.270  1.00 33.50           C  
ATOM     41  N   PHE A  18      40.876  16.799  62.259  1.00 33.75           N  
ATOM     42  CA  PHE A  18      42.318  17.005  62.306  1.00 33.87           C  
ATOM     43  C   PHE A  18      42.791  17.542  63.639  1.00 33.51           C  
ATOM     44  O   PHE A  18      42.272  18.537  64.136  1.00 33.44           O  
ATOM     45  CB  PHE A  18      42.747  18.016  61.250  1.00 33.80           C  
ATOM     46  CG  PHE A  18      42.359  17.656  59.849  1.00 33.96           C  
ATOM     47  CD1 PHE A  18      41.166  18.105  59.315  1.00 34.53           C  
ATOM     48  CD2 PHE A  18      43.202  16.886  59.054  1.00 33.95           C  
ATOM     49  CE1 PHE A  18      40.806  17.792  58.019  1.00 34.36           C  
ATOM     50  CE2 PHE A  18      42.843  16.554  57.759  1.00 33.96           C  
ATOM     51  CZ  PHE A  18      41.642  17.024  57.236  1.00 34.39           C  
ATOM     52  N   ASP A  19      43.815  16.906  64.197  1.00 33.47           N  
ATOM     53  CA  ASP A  19      44.677  17.582  65.172  1.00 33.24           C  
ATOM     54  C   ASP A  19      45.216  18.857  64.524  1.00 33.10           C  
ATOM     55  O   ASP A  19      45.259  18.954  63.295  1.00 33.64           O  
ATOM     56  CB  ASP A  19      45.837  16.665  65.543  1.00 33.15           C  
ATOM     57  CG  ASP A  19      46.896  17.351  66.356  1.00 33.76           C  
ATOM     58  OD1 ASP A  19      46.592  17.888  67.438  1.00 34.15           O  
ATOM     59  OD2 ASP A  19      48.067  17.296  65.925  1.00 32.39           O  
ATOM     60  N   VAL A  20      45.611  19.841  65.321  1.00 33.13           N  
ATOM     61  CA  VAL A  20      46.135  21.090  64.753  1.00 33.81           C  
ATOM     62  C   VAL A  20      47.659  21.097  64.695  1.00 34.09           C  
ATOM     63  O   VAL A  20      48.243  21.114  63.610  1.00 34.37           O  
ATOM     64  CB  VAL A  20      45.594  22.324  65.487  1.00 34.03           C  
ATOM     65  CG1 VAL A  20      46.194  23.611  64.896  1.00 33.87           C  
ATOM     66  CG2 VAL A  20      44.058  22.351  65.365  1.00 34.92           C  
ATOM     67  N   ASP A  21      48.304  21.064  65.852  1.00 34.56           N  
ATOM     68  CA  ASP A  21      49.756  21.276  65.911  1.00 34.87           C  
ATOM     69  C   ASP A  21      50.537  20.123  65.278  1.00 35.03           C  
ATOM     70  O   ASP A  21      50.457  18.976  65.735  1.00 35.31           O  
ATOM     71  CB  ASP A  21      50.194  21.497  67.363  1.00 35.52           C  
ATOM     72  CG  ASP A  21      49.769  22.854  67.900  1.00 37.67           C  
ATOM     73  OD1 ASP A  21      49.754  23.823  67.111  1.00 36.53           O  
ATOM     74  OD2 ASP A  21      49.449  22.958  69.113  1.00 39.23           O  
ATOM     75  N   GLY A  22      51.277  20.424  64.208  1.00 34.76           N  
ATOM     76  CA  GLY A  22      52.084  19.423  63.510  1.00 34.78           C  
ATOM     77  C   GLY A  22      51.319  18.563  62.516  1.00 35.03           C  
ATOM     78  O   GLY A  22      51.923  17.752  61.803  1.00 35.09           O  
ATOM     79  N   THR A  23      50.000  18.753  62.471  1.00 34.59           N  
ATOM     80  CA  THR A  23      49.119  18.028  61.584  1.00 33.97           C  
ATOM     81  C   THR A  23      48.587  18.959  60.498  1.00 34.31           C  
ATOM     82  O   THR A  23      48.564  18.580  59.325  1.00 34.25           O  
ATOM     83  CB  THR A  23      47.966  17.393  62.385  1.00 34.07           C  
ATOM     84  OG1 THR A  23      48.511  16.454  63.325  1.00 33.22           O  
ATOM     85  CG2 THR A  23      46.958  16.718  61.465  1.00 33.93           C  
ATOM     86  N   LEU A  24      48.158  20.167  60.882  1.00 34.14           N  
ATOM     87  CA  LEU A  24      47.724  21.188  59.917  1.00 34.18           C  
ATOM     88  C   LEU A  24      48.656  22.399  59.887  1.00 34.01           C  
ATOM     89  O   LEU A  24      48.763  23.069  58.863  1.00 33.59           O  
ATOM     90  CB  LEU A  24      46.300  21.672  60.218  1.00 34.51           C  
ATOM     91  CG  LEU A  24      45.169  20.658  60.030  1.00 34.64           C  
ATOM     92  CD1 LEU A  24      43.797  21.345  60.209  1.00 35.11           C  
ATOM     93  CD2 LEU A  24      45.257  19.979  58.657  1.00 33.95           C  
ATOM     94  N   THR A  25      49.301  22.685  61.015  1.00 33.53           N  
ATOM     95  CA  THR A  25      50.184  23.833  61.138  1.00 34.06           C  
ATOM     96  C   THR A  25      51.506  23.410  61.761  1.00 34.38           C  
ATOM     97  O   THR A  25      51.569  22.370  62.435  1.00 35.05           O  
ATOM     98  CB  THR A  25      49.574  24.899  62.062  1.00 34.03           C  
ATOM     99  OG1 THR A  25      49.747  24.502  63.428  1.00 33.97           O  
ATOM    100  CG2 THR A  25      48.102  25.086  61.789  1.00 34.34           C  
ATOM    101  N   PRO A  26      52.559  24.211  61.556  1.00 34.53           N  
ATOM    102  CA  PRO A  26      53.732  24.083  62.422  1.00 34.68           C  
ATOM    103  C   PRO A  26      53.292  24.315  63.860  1.00 35.05           C  
ATOM    104  O   PRO A  26      52.374  25.102  64.099  1.00 34.42           O  
ATOM    105  CB  PRO A  26      54.647  25.213  61.949  1.00 34.72           C  
ATOM    106  CG  PRO A  26      54.213  25.502  60.561  1.00 34.70           C  
ATOM    107  CD  PRO A  26      52.738  25.280  60.556  1.00 34.43           C  
ATOM    108  N   ALA A  27      53.925  23.633  64.806  1.00 35.33           N  
ATOM    109  CA  ALA A  27      53.450  23.647  66.188  1.00 35.64           C  
ATOM    110  C   ALA A  27      53.253  25.069  66.709  1.00 35.95           C  
ATOM    111  O   ALA A  27      54.193  25.858  66.737  1.00 36.12           O  
ATOM    112  CB  ALA A  27      54.398  22.880  67.082  1.00 35.84           C  
ATOM    113  N   ARG A  28      52.014  25.378  67.093  1.00 36.04           N  
ATOM    114  CA  ARG A  28      51.627  26.659  67.699  1.00 36.57           C  
ATOM    115  C   ARG A  28      51.715  27.879  66.775  1.00 35.96           C  
ATOM    116  O   ARG A  28      51.657  29.012  67.245  1.00 36.64           O  
ATOM    117  CB  ARG A  28      52.417  26.905  68.990  1.00 36.73           C  
ATOM    118  CG  ARG A  28      52.325  25.722  69.961  1.00 38.06           C  
ATOM    119  CD  ARG A  28      52.768  26.121  71.345  1.00 38.94           C  
ATOM    120  NE  ARG A  28      51.843  27.077  71.956  1.00 41.38           N  
ATOM    121  CZ  ARG A  28      50.741  26.762  72.643  1.00 42.10           C  
ATOM    122  NH1 ARG A  28      50.381  25.496  72.819  1.00 41.71           N  
ATOM    123  NH2 ARG A  28      49.995  27.737  73.153  1.00 42.75           N  
ATOM    124  N   GLN A  29      51.803  27.641  65.466  1.00 35.79           N  
ATOM    125  CA  GLN A  29      51.954  28.717  64.486  1.00 35.84           C  
ATOM    126  C   GLN A  29      50.800  28.748  63.491  1.00 35.60           C  
ATOM    127  O   GLN A  29      49.979  27.825  63.427  1.00 35.36           O  
ATOM    128  CB  GLN A  29      53.260  28.559  63.705  1.00 35.65           C  
ATOM    129  CG  GLN A  29      54.497  28.361  64.554  1.00 36.28           C  
ATOM    130  CD  GLN A  29      54.649  29.388  65.662  1.00 37.56           C  
ATOM    131  OE1 GLN A  29      54.392  30.581  65.481  1.00 36.68           O  
ATOM    132  NE2 GLN A  29      55.097  28.921  66.826  1.00 41.56           N  
ATOM    133  N   LYS A  30      50.774  29.817  62.706  1.00 36.01           N  
ATOM    134  CA  LYS A  30      49.791  29.999  61.648  1.00 35.95           C  
ATOM    135  C   LYS A  30      49.904  28.911  60.573  1.00 35.73           C  
ATOM    136  O   LYS A  30      51.005  28.467  60.221  1.00 35.39           O  
ATOM    137  CB  LYS A  30      49.970  31.378  61.005  1.00 36.59           C  
ATOM    138  CG  LYS A  30      48.804  31.836  60.138  1.00 37.79           C  
ATOM    139  CD  LYS A  30      47.619  32.318  60.971  1.00 40.42           C  
ATOM    140  CE  LYS A  30      47.773  33.767  61.426  1.00 41.52           C  
ATOM    141  NZ  LYS A  30      46.521  34.267  62.086  1.00 41.07           N  
ATOM    142  N   ILE A  31      48.749  28.507  60.061  1.00 35.24           N  
ATOM    143  CA  ILE A  31      48.639  27.563  58.952  1.00 34.95           C  
ATOM    144  C   ILE A  31      49.196  28.157  57.654  1.00 34.76           C  
ATOM    145  O   ILE A  31      49.156  29.370  57.446  1.00 34.39           O  
ATOM    146  CB  ILE A  31      47.148  27.146  58.756  1.00 34.85           C  
ATOM    147  CG1 ILE A  31      47.022  25.960  57.797  1.00 34.89           C  
ATOM    148  CG2 ILE A  31      46.322  28.336  58.266  1.00 35.13           C  
ATOM    149  CD1 ILE A  31      45.677  25.247  57.880  1.00 34.73           C  
ATOM    150  N   ASP A  32      49.741  27.292  56.804  1.00 34.61           N  
ATOM    151  CA  ASP A  32      50.279  27.686  55.495  1.00 34.77           C  
ATOM    152  C   ASP A  32      49.078  27.911  54.581  1.00 34.50           C  
ATOM    153  O   ASP A  32      48.203  27.050  54.510  1.00 33.83           O  
ATOM    154  CB  ASP A  32      51.170  26.547  54.963  1.00 35.07           C  
ATOM    155  CG  ASP A  32      51.759  26.819  53.585  1.00 35.62           C  
ATOM    156  OD1 ASP A  32      51.594  27.921  53.026  1.00 38.15           O  
ATOM    157  OD2 ASP A  32      52.422  25.902  53.055  1.00 39.07           O  
ATOM    158  N   PRO A  33      49.006  29.074  53.903  1.00 34.68           N  
ATOM    159  CA  PRO A  33      47.891  29.335  52.988  1.00 34.90           C  
ATOM    160  C   PRO A  33      47.574  28.201  52.006  1.00 35.18           C  
ATOM    161  O   PRO A  33      46.403  27.985  51.685  1.00 35.15           O  
ATOM    162  CB  PRO A  33      48.350  30.590  52.238  1.00 34.96           C  
ATOM    163  CG  PRO A  33      49.213  31.295  53.202  1.00 34.74           C  
ATOM    164  CD  PRO A  33      49.918  30.231  53.987  1.00 34.54           C  
ATOM    165  N   GLU A  34      48.598  27.488  51.540  1.00 35.57           N  
ATOM    166  CA  GLU A  34      48.403  26.354  50.624  1.00 35.89           C  
ATOM    167  C   GLU A  34      47.644  25.217  51.290  1.00 35.53           C  
ATOM    168  O   GLU A  34      46.764  24.600  50.677  1.00 35.50           O  
ATOM    169  CB  GLU A  34      49.742  25.808  50.124  1.00 36.07           C  
ATOM    170  CG  GLU A  34      50.304  26.502  48.905  1.00 37.53           C  
ATOM    171  CD  GLU A  34      51.310  25.642  48.152  1.00 37.80           C  
ATOM    172  OE1 GLU A  34      51.262  24.396  48.278  1.00 41.90           O  
ATOM    173  OE2 GLU A  34      52.146  26.212  47.429  1.00 41.55           O  
ATOM    174  N   VAL A  35      48.008  24.918  52.533  1.00 35.03           N  
ATOM    175  CA  VAL A  35      47.289  23.920  53.304  1.00 34.75           C  
ATOM    176  C   VAL A  35      45.864  24.399  53.563  1.00 34.58           C  
ATOM    177  O   VAL A  35      44.930  23.637  53.392  1.00 34.29           O  
ATOM    178  CB  VAL A  35      47.986  23.587  54.633  1.00 34.60           C  
ATOM    179  CG1 VAL A  35      47.146  22.585  55.434  1.00 34.32           C  
ATOM    180  CG2 VAL A  35      49.369  23.024  54.366  1.00 35.01           C  
ATOM    181  N   ALA A  36      45.701  25.668  53.944  1.00 34.34           N  
ATOM    182  CA  ALA A  36      44.363  26.224  54.182  1.00 34.52           C  
ATOM    183  C   ALA A  36      43.478  26.097  52.940  1.00 34.76           C  
ATOM    184  O   ALA A  36      42.314  25.688  53.029  1.00 34.89           O  
ATOM    185  CB  ALA A  36      44.455  27.678  54.629  1.00 34.48           C  
ATOM    186  N   ALA A  37      44.044  26.426  51.783  1.00 34.62           N  
ATOM    187  CA  ALA A  37      43.320  26.345  50.515  1.00 34.96           C  
ATOM    188  C   ALA A  37      42.885  24.914  50.211  1.00 35.06           C  
ATOM    189  O   ALA A  37      41.758  24.683  49.747  1.00 35.15           O  
ATOM    190  CB  ALA A  37      44.175  26.893  49.382  1.00 34.50           C  
ATOM    191  N   PHE A  38      43.765  23.951  50.473  1.00 35.37           N  
ATOM    192  CA  PHE A  38      43.416  22.556  50.229  1.00 35.64           C  
ATOM    193  C   PHE A  38      42.253  22.088  51.106  1.00 36.06           C  
ATOM    194  O   PHE A  38      41.385  21.337  50.656  1.00 36.36           O  
ATOM    195  CB  PHE A  38      44.593  21.612  50.456  1.00 35.57           C  
ATOM    196  CG  PHE A  38      44.192  20.173  50.377  1.00 35.51           C  
ATOM    197  CD1 PHE A  38      43.891  19.600  49.151  1.00 35.75           C  
ATOM    198  CD2 PHE A  38      44.039  19.412  51.524  1.00 35.38           C  
ATOM    199  CE1 PHE A  38      43.481  18.284  49.070  1.00 35.42           C  
ATOM    200  CE2 PHE A  38      43.625  18.104  51.446  1.00 36.46           C  
ATOM    201  CZ  PHE A  38      43.345  17.535  50.215  1.00 35.48           C  
ATOM    202  N   LEU A  39      42.257  22.509  52.365  1.00 36.37           N  
ATOM    203  CA  LEU A  39      41.204  22.121  53.293  1.00 36.40           C  
ATOM    204  C   LEU A  39      39.832  22.578  52.822  1.00 36.99           C  
ATOM    205  O   LEU A  39      38.848  21.857  52.982  1.00 36.90           O  
ATOM    206  CB  LEU A  39      41.495  22.658  54.694  1.00 36.50           C  
ATOM    207  CG  LEU A  39      42.687  22.007  55.384  1.00 36.59           C  
ATOM    208  CD1 LEU A  39      42.973  22.723  56.690  1.00 35.88           C  
ATOM    209  CD2 LEU A  39      42.450  20.499  55.608  1.00 37.27           C  
ATOM    210  N   GLN A  40      39.766  23.764  52.223  1.00 37.34           N  
ATOM    211  CA  GLN A  40      38.502  24.255  51.693  1.00 37.69           C  
ATOM    212  C   GLN A  40      38.082  23.465  50.454  1.00 37.72           C  
ATOM    213  O   GLN A  40      36.896  23.231  50.253  1.00 37.69           O  
ATOM    214  CB  GLN A  40      38.575  25.755  51.408  1.00 37.79           C  
ATOM    215  CG  GLN A  40      38.777  26.595  52.671  1.00 38.26           C  
ATOM    216  CD  GLN A  40      37.731  26.315  53.743  1.00 38.40           C  
ATOM    217  OE1 GLN A  40      36.532  26.380  53.480  1.00 39.42           O  
ATOM    218  NE2 GLN A  40      38.184  25.996  54.954  1.00 38.13           N  
ATOM    219  N   LYS A  41      39.053  23.044  49.644  1.00 37.99           N  
ATOM    220  CA  LYS A  41      38.797  22.160  48.494  1.00 38.14           C  
ATOM    221  C   LYS A  41      38.260  20.795  48.949  1.00 38.00           C  
ATOM    222  O   LYS A  41      37.270  20.295  48.406  1.00 38.40           O  
ATOM    223  CB  LYS A  41      40.085  21.972  47.689  1.00 38.28           C  
ATOM    224  CG  LYS A  41      39.929  21.188  46.395  1.00 38.73           C  
ATOM    225  CD  LYS A  41      41.197  21.295  45.556  1.00 39.19           C  
ATOM    226  CE  LYS A  41      41.059  20.587  44.218  1.00 39.53           C  
ATOM    227  NZ  LYS A  41      42.062  21.093  43.225  1.00 40.11           N  
ATOM    228  N   LEU A  42      38.926  20.203  49.936  1.00 37.81           N  
ATOM    229  CA  LEU A  42      38.472  18.960  50.579  1.00 37.69           C  
ATOM    230  C   LEU A  42      37.026  19.077  51.061  1.00 37.89           C  
ATOM    231  O   LEU A  42      36.247  18.122  50.990  1.00 37.57           O  
ATOM    232  CB  LEU A  42      39.391  18.633  51.765  1.00 37.46           C  
ATOM    233  CG  LEU A  42      39.169  17.332  52.538  1.00 37.64           C  
ATOM    234  CD1 LEU A  42      39.308  16.127  51.626  1.00 35.53           C  
ATOM    235  CD2 LEU A  42      40.157  17.238  53.693  1.00 36.26           C  
ATOM    236  N   ARG A  43      36.673  20.275  51.516  1.00 38.21           N  
ATOM    237  CA  ARG A  43      35.349  20.574  52.057  1.00 38.47           C  
ATOM    238  C   ARG A  43      34.212  20.435  51.035  1.00 38.26           C  
ATOM    239  O   ARG A  43      33.037  20.393  51.410  1.00 38.51           O  
ATOM    240  CB  ARG A  43      35.350  21.985  52.666  1.00 38.76           C  
ATOM    241  CG  ARG A  43      34.552  22.109  53.937  1.00 39.06           C  
ATOM    242  CD  ARG A  43      34.541  23.542  54.398  1.00 39.13           C  
ATOM    243  NE  ARG A  43      33.583  23.789  55.470  1.00 39.72           N  
ATOM    244  CZ  ARG A  43      33.263  25.004  55.903  1.00 39.87           C  
ATOM    245  NH1 ARG A  43      33.822  26.074  55.356  1.00 39.54           N  
ATOM    246  NH2 ARG A  43      32.388  25.153  56.886  1.00 40.13           N  
ATOM    247  N   SER A  44      34.555  20.369  49.750  1.00 38.04           N  
ATOM    248  CA  SER A  44      33.573  20.124  48.695  1.00 38.07           C  
ATOM    249  C   SER A  44      33.125  18.662  48.649  1.00 38.02           C  
ATOM    250  O   SER A  44      32.162  18.327  47.964  1.00 38.01           O  
ATOM    251  CB  SER A  44      34.138  20.540  47.332  1.00 38.02           C  
ATOM    252  OG  SER A  44      35.164  19.662  46.895  1.00 37.69           O  
ATOM    253  N   ARG A  45      33.830  17.789  49.365  1.00 37.70           N  
ATOM    254  CA  ARG A  45      33.491  16.364  49.403  1.00 37.80           C  
ATOM    255  C   ARG A  45      33.128  15.856  50.784  1.00 37.53           C  
ATOM    256  O   ARG A  45      32.346  14.911  50.909  1.00 37.98           O  
ATOM    257  CB  ARG A  45      34.665  15.546  48.891  1.00 38.36           C  
ATOM    258  CG  ARG A  45      35.134  16.013  47.550  1.00 39.84           C  
ATOM    259  CD  ARG A  45      35.571  14.877  46.689  1.00 41.14           C  
ATOM    260  NE  ARG A  45      35.585  15.282  45.294  1.00 41.80           N  
ATOM    261  CZ  ARG A  45      36.047  14.537  44.302  1.00 42.20           C  
ATOM    262  NH1 ARG A  45      36.543  13.331  44.540  1.00 42.60           N  
ATOM    263  NH2 ARG A  45      36.016  15.001  43.066  1.00 42.02           N  
ATOM    264  N   VAL A  46      33.722  16.457  51.812  1.00 36.65           N  
ATOM    265  CA  VAL A  46      33.496  16.044  53.190  1.00 36.09           C  
ATOM    266  C   VAL A  46      33.356  17.254  54.094  1.00 35.54           C  
ATOM    267  O   VAL A  46      33.726  18.373  53.715  1.00 35.25           O  
ATOM    268  CB  VAL A  46      34.662  15.176  53.712  1.00 36.00           C  
ATOM    269  CG1 VAL A  46      34.872  13.980  52.809  1.00 35.15           C  
ATOM    270  CG2 VAL A  46      35.950  16.000  53.828  1.00 35.73           C  
ATOM    271  N   GLN A  47      32.812  17.032  55.289  1.00 34.73           N  
ATOM    272  CA  GLN A  47      32.871  18.049  56.332  1.00 34.06           C  
ATOM    273  C   GLN A  47      34.259  17.990  56.967  1.00 33.52           C  
ATOM    274  O   GLN A  47      34.893  16.937  57.000  1.00 32.80           O  
ATOM    275  CB  GLN A  47      31.771  17.844  57.377  1.00 33.92           C  
ATOM    276  CG  GLN A  47      30.368  18.076  56.825  1.00 34.49           C  
ATOM    277  CD  GLN A  47      29.313  18.255  57.899  1.00 34.39           C  
ATOM    278  OE1 GLN A  47      29.496  19.016  58.848  1.00 36.79           O  
ATOM    279  NE2 GLN A  47      28.183  17.582  57.730  1.00 36.24           N  
ATOM    280  N   ILE A  48      34.744  19.128  57.453  1.00 33.25           N  
ATOM    281  CA  ILE A  48      36.068  19.180  58.068  1.00 33.24           C  
ATOM    282  C   ILE A  48      35.979  19.778  59.458  1.00 33.14           C  
ATOM    283  O   ILE A  48      35.154  20.656  59.716  1.00 32.74           O  
ATOM    284  CB  ILE A  48      37.095  19.960  57.193  1.00 33.38           C  
ATOM    285  CG1 ILE A  48      36.758  21.456  57.115  1.00 33.06           C  
ATOM    286  CG2 ILE A  48      37.175  19.334  55.793  1.00 33.10           C  
ATOM    287  CD1 ILE A  48      37.789  22.273  56.345  1.00 33.47           C  
ATOM    288  N   GLY A  49      36.817  19.272  60.355  1.00 33.32           N  
ATOM    289  CA  GLY A  49      36.845  19.739  61.730  1.00 33.34           C  
ATOM    290  C   GLY A  49      38.237  19.684  62.319  1.00 33.83           C  
ATOM    291  O   GLY A  49      39.110  18.953  61.835  1.00 33.21           O  
ATOM    292  N   VAL A  50      38.447  20.485  63.354  1.00 33.69           N  
ATOM    293  CA  VAL A  50      39.703  20.468  64.074  1.00 34.23           C  
ATOM    294  C   VAL A  50      39.426  20.169  65.530  1.00 34.04           C  
ATOM    295  O   VAL A  50      38.383  20.547  66.070  1.00 34.15           O  
ATOM    296  CB  VAL A  50      40.499  21.796  63.939  1.00 34.10           C  
ATOM    297  CG1 VAL A  50      40.947  21.980  62.508  1.00 34.91           C  
ATOM    298  CG2 VAL A  50      39.690  22.995  64.422  1.00 34.86           C  
ATOM    299  N   VAL A  51      40.370  19.476  66.144  1.00 34.34           N  
ATOM    300  CA  VAL A  51      40.368  19.253  67.576  1.00 34.85           C  
ATOM    301  C   VAL A  51      41.790  19.490  68.099  1.00 35.13           C  
ATOM    302  O   VAL A  51      42.765  18.937  67.583  1.00 35.97           O  
ATOM    303  CB  VAL A  51      39.838  17.850  67.951  1.00 35.24           C  
ATOM    304  CG1 VAL A  51      40.600  16.728  67.218  1.00 35.21           C  
ATOM    305  CG2 VAL A  51      39.874  17.640  69.470  1.00 34.53           C  
ATOM    306  N   GLY A  52      41.903  20.348  69.098  1.00 34.77           N  
ATOM    307  CA  GLY A  52      43.197  20.695  69.676  1.00 34.62           C  
ATOM    308  C   GLY A  52      43.065  20.831  71.168  1.00 34.31           C  
ATOM    309  O   GLY A  52      41.975  21.090  71.665  1.00 34.21           O  
ATOM    310  N   GLY A  53      44.173  20.634  71.886  1.00 34.13           N  
ATOM    311  CA  GLY A  53      44.185  20.826  73.329  1.00 34.29           C  
ATOM    312  C   GLY A  53      44.231  22.301  73.718  1.00 34.06           C  
ATOM    313  O   GLY A  53      43.869  22.664  74.840  1.00 33.99           O  
ATOM    314  N   SER A  54      44.677  23.157  72.797  1.00 34.40           N  
ATOM    315  CA  SER A  54      44.753  24.603  73.060  1.00 34.34           C  
ATOM    316  C   SER A  54      43.349  25.202  73.171  1.00 34.29           C  
ATOM    317  O   SER A  54      42.377  24.587  72.719  1.00 34.27           O  
ATOM    318  CB  SER A  54      45.499  25.320  71.932  1.00 34.75           C  
ATOM    319  OG  SER A  54      46.872  24.974  71.907  1.00 36.44           O  
ATOM    320  N   ASP A  55      43.255  26.407  73.744  1.00 33.84           N  
ATOM    321  CA  ASP A  55      41.962  27.100  73.858  1.00 33.82           C  
ATOM    322  C   ASP A  55      41.504  27.650  72.513  1.00 33.98           C  
ATOM    323  O   ASP A  55      42.264  27.705  71.544  1.00 33.36           O  
ATOM    324  CB  ASP A  55      41.927  28.180  74.976  1.00 34.05           C  
ATOM    325  CG  ASP A  55      42.885  29.365  74.755  1.00 33.95           C  
ATOM    326  OD1 ASP A  55      43.266  29.700  73.611  1.00 33.68           O  
ATOM    327  OD2 ASP A  55      43.245  30.004  75.771  1.00 35.18           O  
ATOM    328  N   TYR A  56      40.244  28.044  72.460  1.00 34.22           N  
ATOM    329  CA  TYR A  56      39.660  28.516  71.219  1.00 35.16           C  
ATOM    330  C   TYR A  56      40.452  29.670  70.603  1.00 35.29           C  
ATOM    331  O   TYR A  56      40.737  29.672  69.400  1.00 35.51           O  
ATOM    332  CB  TYR A  56      38.201  28.932  71.427  1.00 35.53           C  
ATOM    333  CG  TYR A  56      37.668  29.656  70.220  1.00 35.93           C  
ATOM    334  CD1 TYR A  56      37.319  28.955  69.066  1.00 36.18           C  
ATOM    335  CD2 TYR A  56      37.563  31.038  70.210  1.00 36.43           C  
ATOM    336  CE1 TYR A  56      36.854  29.615  67.945  1.00 37.05           C  
ATOM    337  CE2 TYR A  56      37.104  31.703  69.098  1.00 36.46           C  
ATOM    338  CZ  TYR A  56      36.748  30.994  67.972  1.00 36.04           C  
ATOM    339  OH  TYR A  56      36.296  31.676  66.865  1.00 37.90           O  
ATOM    340  N   CYS A  57      40.803  30.647  71.430  1.00 35.55           N  
ATOM    341  CA  CYS A  57      41.511  31.842  70.962  1.00 35.91           C  
ATOM    342  C   CYS A  57      42.796  31.478  70.224  1.00 35.40           C  
ATOM    343  O   CYS A  57      43.055  31.994  69.136  1.00 35.45           O  
ATOM    344  CB  CYS A  57      41.792  32.780  72.133  1.00 36.71           C  
ATOM    345  SG  CYS A  57      40.281  33.535  72.802  1.00 42.21           S  
ATOM    346  N   LYS A  58      43.557  30.542  70.797  1.00 34.69           N  
ATOM    347  CA  LYS A  58      44.810  30.071  70.212  1.00 34.25           C  
ATOM    348  C   LYS A  58      44.569  29.393  68.865  1.00 34.04           C  
ATOM    349  O   LYS A  58      45.221  29.691  67.872  1.00 33.23           O  
ATOM    350  CB  LYS A  58      45.470  29.089  71.179  1.00 34.14           C  
ATOM    351  CG  LYS A  58      46.868  28.636  70.787  1.00 35.06           C  
ATOM    352  CD  LYS A  58      47.880  29.698  71.115  0.00 20.00           C  
ATOM    353  CE  LYS A  58      47.817  30.461  72.524  0.00 20.00           C  
ATOM    354  NZ  LYS A  58      47.624  29.687  73.856  0.00 20.00           N  
ATOM    355  N   ILE A  59      43.624  28.465  68.850  1.00 33.33           N  
ATOM    356  CA  ILE A  59      43.310  27.723  67.642  1.00 34.14           C  
ATOM    357  C   ILE A  59      42.797  28.667  66.558  1.00 34.18           C  
ATOM    358  O   ILE A  59      43.152  28.541  65.378  1.00 34.43           O  
ATOM    359  CB  ILE A  59      42.262  26.633  67.930  1.00 34.14           C  
ATOM    360  CG1 ILE A  59      42.835  25.581  68.885  1.00 34.35           C  
ATOM    361  CG2 ILE A  59      41.809  25.972  66.636  1.00 33.77           C  
ATOM    362  CD1 ILE A  59      41.784  24.569  69.370  1.00 34.48           C  
ATOM    363  N   ALA A  60      41.951  29.607  66.962  1.00 34.54           N  
ATOM    364  CA  ALA A  60      41.417  30.615  66.047  1.00 35.19           C  
ATOM    365  C   ALA A  60      42.534  31.434  65.418  1.00 35.61           C  
ATOM    366  O   ALA A  60      42.496  31.739  64.223  1.00 36.23           O  
ATOM    367  CB  ALA A  60      40.449  31.526  66.778  1.00 34.82           C  
ATOM    368  N   GLU A  61      43.529  31.776  66.232  1.00 36.17           N  
ATOM    369  CA  GLU A  61      44.673  32.584  65.799  1.00 36.38           C  
ATOM    370  C   GLU A  61      45.505  31.815  64.765  1.00 35.88           C  
ATOM    371  O   GLU A  61      45.963  32.388  63.778  1.00 35.68           O  
ATOM    372  CB  GLU A  61      45.522  32.950  67.028  1.00 36.62           C  
ATOM    373  CG  GLU A  61      46.652  33.917  66.801  1.00 37.62           C  
ATOM    374  CD  GLU A  61      47.346  34.309  68.108  1.00 38.71           C  
ATOM    375  OE1 GLU A  61      47.319  33.513  69.079  1.00 43.11           O  
ATOM    376  OE2 GLU A  61      47.914  35.413  68.163  1.00 42.92           O  
ATOM    377  N   GLN A  62      45.669  30.511  64.981  1.00 35.84           N  
ATOM    378  CA  GLN A  62      46.434  29.669  64.065  1.00 35.74           C  
ATOM    379  C   GLN A  62      45.734  29.428  62.731  1.00 35.75           C  
ATOM    380  O   GLN A  62      46.402  29.287  61.708  1.00 35.99           O  
ATOM    381  CB  GLN A  62      46.736  28.318  64.710  1.00 36.00           C  
ATOM    382  CG  GLN A  62      47.679  28.406  65.896  1.00 35.68           C  
ATOM    383  CD  GLN A  62      47.964  27.047  66.466  1.00 36.80           C  
ATOM    384  OE1 GLN A  62      48.695  26.257  65.872  1.00 39.01           O  
ATOM    385  NE2 GLN A  62      47.362  26.747  67.607  1.00 37.05           N  
ATOM    386  N   LEU A  63      44.403  29.384  62.730  1.00 35.42           N  
ATOM    387  CA  LEU A  63      43.666  28.905  61.554  1.00 35.80           C  
ATOM    388  C   LEU A  63      42.971  29.983  60.722  1.00 36.43           C  
ATOM    389  O   LEU A  63      42.351  29.662  59.698  1.00 36.34           O  
ATOM    390  CB  LEU A  63      42.675  27.810  61.975  1.00 35.79           C  
ATOM    391  CG  LEU A  63      43.372  26.572  62.543  1.00 35.38           C  
ATOM    392  CD1 LEU A  63      42.368  25.534  63.068  1.00 34.94           C  
ATOM    393  CD2 LEU A  63      44.277  25.947  61.497  1.00 35.98           C  
ATOM    394  N   GLY A  64      43.089  31.243  61.144  1.00 36.67           N  
ATOM    395  CA  GLY A  64      42.572  32.382  60.377  1.00 37.12           C  
ATOM    396  C   GLY A  64      42.688  33.706  61.111  1.00 38.00           C  
ATOM    397  O   GLY A  64      43.318  33.790  62.167  1.00 37.71           O  
ATOM    398  N   ASP A  65      42.086  34.746  60.536  1.00 38.53           N  
ATOM    399  CA  ASP A  65      41.977  36.042  61.193  1.00 39.56           C  
ATOM    400  C   ASP A  65      40.672  36.084  61.980  1.00 39.59           C  
ATOM    401  O   ASP A  65      39.662  35.526  61.546  1.00 39.87           O  
ATOM    402  CB  ASP A  65      41.986  37.175  60.163  1.00 39.95           C  
ATOM    403  CG  ASP A  65      43.212  37.142  59.260  1.00 41.79           C  
ATOM    404  OD1 ASP A  65      44.342  37.065  59.785  1.00 42.96           O  
ATOM    405  OD2 ASP A  65      43.039  37.214  58.020  1.00 45.55           O  
ATOM    406  N   GLY A  66      40.695  36.739  63.137  1.00 39.44           N  
ATOM    407  CA  GLY A  66      39.495  36.900  63.959  1.00 39.36           C  
ATOM    408  C   GLY A  66      38.858  35.565  64.294  1.00 39.15           C  
ATOM    409  O   GLY A  66      39.541  34.646  64.737  1.00 39.07           O  
ATOM    410  N   ASP A  67      37.548  35.456  64.064  1.00 38.75           N  
ATOM    411  CA  ASP A  67      36.819  34.209  64.294  1.00 38.71           C  
ATOM    412  C   ASP A  67      36.545  33.451  62.995  1.00 38.33           C  
ATOM    413  O   ASP A  67      35.615  32.652  62.929  1.00 38.22           O  
ATOM    414  CB  ASP A  67      35.501  34.500  65.020  1.00 38.84           C  
ATOM    415  CG  ASP A  67      35.718  35.003  66.429  1.00 39.29           C  
ATOM    416  OD1 ASP A  67      36.469  34.350  67.183  1.00 39.74           O  
ATOM    417  OD2 ASP A  67      35.148  36.058  66.776  1.00 41.41           O  
ATOM    418  N   GLU A  68      37.362  33.681  61.969  1.00 37.92           N  
ATOM    419  CA  GLU A  68      37.187  32.987  60.690  1.00 37.75           C  
ATOM    420  C   GLU A  68      37.189  31.468  60.831  1.00 37.20           C  
ATOM    421  O   GLU A  68      36.544  30.777  60.047  1.00 37.20           O  
ATOM    422  CB  GLU A  68      38.276  33.388  59.700  1.00 37.86           C  
ATOM    423  CG  GLU A  68      38.050  34.731  59.042  1.00 38.14           C  
ATOM    424  CD  GLU A  68      39.248  35.197  58.233  1.00 38.26           C  
ATOM    425  OE1 GLU A  68      40.279  34.492  58.219  1.00 38.36           O  
ATOM    426  OE2 GLU A  68      39.157  36.281  57.617  1.00 39.42           O  
ATOM    427  N   VAL A  69      37.920  30.950  61.817  1.00 36.72           N  
ATOM    428  CA  VAL A  69      38.037  29.504  61.999  1.00 36.35           C  
ATOM    429  C   VAL A  69      36.676  28.803  62.069  1.00 36.14           C  
ATOM    430  O   VAL A  69      36.521  27.704  61.523  1.00 35.61           O  
ATOM    431  CB  VAL A  69      38.904  29.143  63.244  1.00 36.44           C  
ATOM    432  CG1 VAL A  69      38.181  29.487  64.542  1.00 36.25           C  
ATOM    433  CG2 VAL A  69      39.283  27.670  63.217  1.00 36.61           C  
ATOM    434  N   ILE A  70      35.683  29.438  62.698  1.00 35.33           N  
ATOM    435  CA  ILE A  70      34.379  28.775  62.868  1.00 35.10           C  
ATOM    436  C   ILE A  70      33.554  28.802  61.584  1.00 34.47           C  
ATOM    437  O   ILE A  70      32.567  28.070  61.470  1.00 34.73           O  
ATOM    438  CB  ILE A  70      33.551  29.316  64.073  1.00 35.17           C  
ATOM    439  CG1 ILE A  70      33.107  30.760  63.851  1.00 35.54           C  
ATOM    440  CG2 ILE A  70      34.355  29.167  65.379  1.00 35.84           C  
ATOM    441  CD1 ILE A  70      32.403  31.380  65.050  1.00 36.03           C  
ATOM    442  N   GLU A  71      33.970  29.630  60.629  1.00 33.74           N  
ATOM    443  CA  GLU A  71      33.376  29.656  59.295  1.00 34.17           C  
ATOM    444  C   GLU A  71      34.121  28.717  58.343  1.00 34.46           C  
ATOM    445  O   GLU A  71      33.498  28.087  57.490  1.00 35.32           O  
ATOM    446  CB  GLU A  71      33.356  31.081  58.742  1.00 34.26           C  
ATOM    447  CG  GLU A  71      32.404  31.986  59.472  0.00 20.00           C  
ATOM    448  CD  GLU A  71      32.439  33.401  58.926  0.00 20.00           C  
ATOM    449  OE1 GLU A  71      33.234  33.661  57.999  0.00 20.00           O  
ATOM    450  OE2 GLU A  71      31.673  34.253  59.425  0.00 20.00           O  
ATOM    451  N   LYS A  72      35.441  28.607  58.508  1.00 34.62           N  
ATOM    452  CA  LYS A  72      36.282  27.789  57.623  1.00 34.72           C  
ATOM    453  C   LYS A  72      36.166  26.287  57.894  1.00 34.38           C  
ATOM    454  O   LYS A  72      36.435  25.480  57.011  1.00 34.26           O  
ATOM    455  CB  LYS A  72      37.752  28.216  57.759  1.00 34.94           C  
ATOM    456  CG  LYS A  72      38.067  29.606  57.182  1.00 35.96           C  
ATOM    457  CD  LYS A  72      39.505  30.007  57.498  1.00 36.63           C  
ATOM    458  CE  LYS A  72      39.882  31.364  56.913  1.00 38.45           C  
ATOM    459  NZ  LYS A  72      39.818  31.391  55.429  1.00 40.36           N  
ATOM    460  N   PHE A  73      35.787  25.925  59.118  1.00 34.31           N  
ATOM    461  CA  PHE A  73      35.640  24.524  59.521  1.00 34.33           C  
ATOM    462  C   PHE A  73      34.228  24.267  60.011  1.00 33.87           C  
ATOM    463  O   PHE A  73      33.617  25.123  60.635  1.00 33.77           O  
ATOM    464  CB  PHE A  73      36.640  24.181  60.624  1.00 34.72           C  
ATOM    465  CG  PHE A  73      38.073  24.217  60.169  1.00 34.85           C  
ATOM    466  CD1 PHE A  73      38.715  23.061  59.761  1.00 35.56           C  
ATOM    467  CD2 PHE A  73      38.774  25.411  60.143  1.00 36.42           C  
ATOM    468  CE1 PHE A  73      40.023  23.093  59.328  1.00 36.25           C  
ATOM    469  CE2 PHE A  73      40.088  25.450  59.712  1.00 37.13           C  
ATOM    470  CZ  PHE A  73      40.716  24.292  59.305  1.00 36.87           C  
ATOM    471  N   ASP A  74      33.713  23.078  59.721  1.00 33.15           N  
ATOM    472  CA  ASP A  74      32.383  22.693  60.170  1.00 32.83           C  
ATOM    473  C   ASP A  74      32.350  22.454  61.684  1.00 32.94           C  
ATOM    474  O   ASP A  74      31.350  22.738  62.343  1.00 32.83           O  
ATOM    475  CB  ASP A  74      31.923  21.471  59.381  1.00 32.39           C  
ATOM    476  CG  ASP A  74      31.878  21.752  57.901  1.00 32.75           C  
ATOM    477  OD1 ASP A  74      31.056  22.592  57.521  1.00 32.85           O  
ATOM    478  OD2 ASP A  74      32.661  21.180  57.117  1.00 32.85           O  
ATOM    479  N   TYR A  75      33.462  21.968  62.234  1.00 32.82           N  
ATOM    480  CA  TYR A  75      33.599  21.787  63.671  1.00 32.60           C  
ATOM    481  C   TYR A  75      34.901  22.377  64.162  1.00 32.52           C  
ATOM    482  O   TYR A  75      35.947  22.185  63.539  1.00 31.82           O  
ATOM    483  CB  TYR A  75      33.603  20.311  64.030  1.00 33.24           C  
ATOM    484  CG  TYR A  75      32.320  19.618  63.717  1.00 33.51           C  
ATOM    485  CD1 TYR A  75      31.340  19.458  64.688  1.00 34.08           C  
ATOM    486  CD2 TYR A  75      32.069  19.129  62.442  1.00 34.85           C  
ATOM    487  CE1 TYR A  75      30.146  18.814  64.397  1.00 33.59           C  
ATOM    488  CE2 TYR A  75      30.889  18.484  62.150  1.00 33.50           C  
ATOM    489  CZ  TYR A  75      29.930  18.336  63.130  1.00 34.00           C  
ATOM    490  OH  TYR A  75      28.753  17.689  62.838  1.00 34.68           O  
ATOM    491  N   VAL A  76      34.834  23.093  65.280  1.00 32.66           N  
ATOM    492  CA  VAL A  76      36.027  23.532  65.980  1.00 32.76           C  
ATOM    493  C   VAL A  76      35.919  23.039  67.410  1.00 32.54           C  
ATOM    494  O   VAL A  76      35.102  23.525  68.180  1.00 33.65           O  
ATOM    495  CB  VAL A  76      36.222  25.067  65.953  1.00 32.43           C  
ATOM    496  CG1 VAL A  76      37.536  25.450  66.644  1.00 33.22           C  
ATOM    497  CG2 VAL A  76      36.192  25.589  64.509  1.00 32.90           C  
ATOM    498  N   PHE A  77      36.733  22.055  67.749  1.00 33.02           N  
ATOM    499  CA  PHE A  77      36.754  21.506  69.085  1.00 32.89           C  
ATOM    500  C   PHE A  77      38.004  22.022  69.772  1.00 32.97           C  
ATOM    501  O   PHE A  77      39.119  21.645  69.401  1.00 34.25           O  
ATOM    502  CB  PHE A  77      36.785  19.984  69.021  1.00 32.83           C  
ATOM    503  CG  PHE A  77      35.526  19.366  68.497  1.00 33.34           C  
ATOM    504  CD1 PHE A  77      34.383  19.323  69.277  1.00 32.86           C  
ATOM    505  CD2 PHE A  77      35.492  18.798  67.229  1.00 33.37           C  
ATOM    506  CE1 PHE A  77      33.236  18.732  68.803  1.00 34.14           C  
ATOM    507  CE2 PHE A  77      34.342  18.211  66.748  1.00 33.13           C  
ATOM    508  CZ  PHE A  77      33.213  18.177  67.534  1.00 33.09           C  
ATOM    509  N   ALA A  78      37.832  22.904  70.750  1.00 33.03           N  
ATOM    510  CA  ALA A  78      38.955  23.407  71.535  1.00 32.85           C  
ATOM    511  C   ALA A  78      38.985  22.690  72.875  1.00 32.71           C  
ATOM    512  O   ALA A  78      37.984  22.099  73.300  1.00 33.07           O  
ATOM    513  CB  ALA A  78      38.843  24.929  71.730  1.00 32.09           C  
ATOM    514  N   GLU A  79      40.141  22.724  73.522  1.00 32.75           N  
ATOM    515  CA  GLU A  79      40.356  22.026  74.784  1.00 32.57           C  
ATOM    516  C   GLU A  79      39.842  20.590  74.710  1.00 33.25           C  
ATOM    517  O   GLU A  79      39.056  20.148  75.546  1.00 33.33           O  
ATOM    518  CB  GLU A  79      39.740  22.823  75.934  1.00 32.38           C  
ATOM    519  CG  GLU A  79      40.357  24.232  76.052  1.00 32.04           C  
ATOM    520  CD  GLU A  79      39.848  25.019  77.244  1.00 32.37           C  
ATOM    521  OE1 GLU A  79      39.890  24.500  78.384  1.00 32.19           O  
ATOM    522  OE2 GLU A  79      39.420  26.182  77.050  1.00 31.46           O  
ATOM    523  N   ASN A  80      40.310  19.893  73.671  1.00 33.36           N  
ATOM    524  CA  ASN A  80      40.001  18.481  73.399  1.00 33.88           C  
ATOM    525  C   ASN A  80      38.528  18.187  73.134  1.00 34.25           C  
ATOM    526  O   ASN A  80      38.111  17.023  73.121  1.00 35.75           O  
ATOM    527  CB  ASN A  80      40.559  17.577  74.510  1.00 34.31           C  
ATOM    528  CG  ASN A  80      42.059  17.464  74.462  1.00 35.16           C  
ATOM    529  OD1 ASN A  80      42.690  17.793  73.452  1.00 36.95           O  
ATOM    530  ND2 ASN A  80      42.651  16.982  75.553  1.00 36.99           N  
ATOM    531  N   GLY A  81      37.750  19.228  72.868  1.00 33.96           N  
ATOM    532  CA  GLY A  81      36.321  19.079  72.623  1.00 33.89           C  
ATOM    533  C   GLY A  81      35.407  19.463  73.768  1.00 34.00           C  
ATOM    534  O   GLY A  81      34.184  19.382  73.635  1.00 33.77           O  
ATOM    535  N   THR A  82      35.965  19.909  74.894  1.00 33.54           N  
ATOM    536  CA  THR A  82      35.128  20.434  75.973  1.00 33.38           C  
ATOM    537  C   THR A  82      34.537  21.782  75.575  1.00 33.72           C  
ATOM    538  O   THR A  82      33.573  22.247  76.173  1.00 33.96           O  
ATOM    539  CB  THR A  82      35.897  20.588  77.290  1.00 33.08           C  
ATOM    540  OG1 THR A  82      36.995  21.490  77.100  1.00 32.60           O  
ATOM    541  CG2 THR A  82      36.399  19.226  77.760  1.00 32.86           C  
ATOM    542  N   VAL A  83      35.123  22.403  74.557  1.00 34.09           N  
ATOM    543  CA  VAL A  83      34.552  23.598  73.948  1.00 34.10           C  
ATOM    544  C   VAL A  83      34.289  23.279  72.481  1.00 34.24           C  
ATOM    545  O   VAL A  83      35.195  22.860  71.770  1.00 33.78           O  
ATOM    546  CB  VAL A  83      35.514  24.796  74.090  1.00 34.29           C  
ATOM    547  CG1 VAL A  83      35.003  25.998  73.318  1.00 32.83           C  
ATOM    548  CG2 VAL A  83      35.707  25.153  75.564  1.00 33.71           C  
ATOM    549  N   GLN A  84      33.043  23.446  72.041  1.00 34.91           N  
ATOM    550  CA  GLN A  84      32.661  23.062  70.685  1.00 35.31           C  
ATOM    551  C   GLN A  84      31.935  24.162  69.950  1.00 35.04           C  
ATOM    552  O   GLN A  84      30.947  24.713  70.448  1.00 35.23           O  
ATOM    553  CB  GLN A  84      31.764  21.811  70.660  1.00 35.54           C  
ATOM    554  CG  GLN A  84      31.269  21.490  69.232  1.00 35.70           C  
ATOM    555  CD  GLN A  84      30.404  20.253  69.138  1.00 37.41           C  
ATOM    556  OE1 GLN A  84      30.114  19.594  70.142  1.00 40.53           O  
ATOM    557  NE2 GLN A  84      29.992  19.921  67.916  1.00 39.04           N  
ATOM    558  N   TYR A  85      32.439  24.458  68.751  1.00 35.40           N  
ATOM    559  CA  TYR A  85      31.698  25.203  67.739  1.00 35.58           C  
ATOM    560  C   TYR A  85      31.262  24.231  66.645  1.00 35.36           C  
ATOM    561  O   TYR A  85      32.094  23.527  66.061  1.00 34.84           O  
ATOM    562  CB  TYR A  85      32.556  26.320  67.142  1.00 36.22           C  
ATOM    563  CG  TYR A  85      32.876  27.420  68.121  1.00 36.55           C  
ATOM    564  CD1 TYR A  85      32.172  28.620  68.115  1.00 37.76           C  
ATOM    565  CD2 TYR A  85      33.882  27.257  69.066  1.00 37.30           C  
ATOM    566  CE1 TYR A  85      32.469  29.633  69.026  1.00 37.49           C  
ATOM    567  CE2 TYR A  85      34.180  28.259  69.976  1.00 36.82           C  
ATOM    568  CZ  TYR A  85      33.477  29.439  69.951  1.00 37.31           C  
ATOM    569  OH  TYR A  85      33.786  30.424  70.863  1.00 38.06           O  
ATOM    570  N   LYS A  86      29.958  24.189  66.386  1.00 35.27           N  
ATOM    571  CA  LYS A  86      29.367  23.340  65.350  1.00 35.53           C  
ATOM    572  C   LYS A  86      28.666  24.244  64.335  1.00 35.39           C  
ATOM    573  O   LYS A  86      27.690  24.919  64.676  1.00 35.07           O  
ATOM    574  CB  LYS A  86      28.362  22.381  65.973  1.00 35.46           C  
ATOM    575  CG  LYS A  86      27.712  21.419  64.989  1.00 35.56           C  
ATOM    576  CD  LYS A  86      26.675  20.558  65.675  1.00 35.94           C  
ATOM    577  CE  LYS A  86      25.960  19.636  64.696  1.00 36.28           C  
ATOM    578  NZ  LYS A  86      25.042  18.710  65.423  1.00 36.10           N  
ATOM    579  N   HIS A  87      29.185  24.259  63.106  1.00 35.66           N  
ATOM    580  CA  HIS A  87      28.694  25.133  62.031  1.00 36.05           C  
ATOM    581  C   HIS A  87      28.504  26.587  62.478  1.00 36.27           C  
ATOM    582  O   HIS A  87      27.466  27.211  62.227  1.00 35.86           O  
ATOM    583  CB  HIS A  87      27.425  24.543  61.407  1.00 36.57           C  
ATOM    584  CG  HIS A  87      27.590  23.119  60.975  1.00 35.95           C  
ATOM    585  ND1 HIS A  87      26.789  22.102  61.441  1.00 38.18           N  
ATOM    586  CD2 HIS A  87      28.492  22.538  60.150  1.00 36.54           C  
ATOM    587  CE1 HIS A  87      27.183  20.957  60.915  1.00 36.42           C  
ATOM    588  NE2 HIS A  87      28.213  21.194  60.124  1.00 36.64           N  
ATOM    589  N   GLY A  88      29.530  27.116  63.140  1.00 36.30           N  
ATOM    590  CA  GLY A  88      29.568  28.518  63.551  1.00 36.94           C  
ATOM    591  C   GLY A  88      28.920  28.813  64.892  1.00 37.31           C  
ATOM    592  O   GLY A  88      28.918  29.966  65.334  1.00 37.43           O  
ATOM    593  N   ARG A  89      28.388  27.782  65.549  1.00 37.78           N  
ATOM    594  CA  ARG A  89      27.596  27.965  66.765  1.00 38.27           C  
ATOM    595  C   ARG A  89      28.281  27.350  67.976  1.00 37.87           C  
ATOM    596  O   ARG A  89      28.620  26.174  67.969  1.00 38.02           O  
ATOM    597  CB  ARG A  89      26.205  27.343  66.592  1.00 38.38           C  
ATOM    598  CG  ARG A  89      25.330  27.395  67.845  1.00 38.87           C  
ATOM    599  CD  ARG A  89      23.906  26.943  67.541  1.00 40.17           C  
ATOM    600  NE  ARG A  89      23.876  25.544  67.118  1.00 41.82           N  
ATOM    601  CZ  ARG A  89      23.480  24.512  67.867  1.00 43.45           C  
ATOM    602  NH1 ARG A  89      23.037  24.686  69.113  1.00 44.39           N  
ATOM    603  NH2 ARG A  89      23.523  23.284  67.356  1.00 43.22           N  
ATOM    604  N   LEU A  90      28.449  28.148  69.029  1.00 38.04           N  
ATOM    605  CA  LEU A  90      29.031  27.655  70.275  1.00 38.53           C  
ATOM    606  C   LEU A  90      28.022  26.827  71.069  1.00 38.63           C  
ATOM    607  O   LEU A  90      26.956  27.322  71.443  1.00 37.70           O  
ATOM    608  CB  LEU A  90      29.521  28.817  71.143  1.00 38.30           C  
ATOM    609  CG  LEU A  90      30.123  28.448  72.504  1.00 38.12           C  
ATOM    610  CD1 LEU A  90      31.393  27.637  72.347  1.00 38.01           C  
ATOM    611  CD2 LEU A  90      30.398  29.707  73.298  1.00 38.64           C  
ATOM    612  N   LEU A  91      28.377  25.575  71.339  1.00 39.00           N  
ATOM    613  CA  LEU A  91      27.572  24.702  72.191  1.00 39.82           C  
ATOM    614  C   LEU A  91      27.896  24.939  73.661  1.00 40.36           C  
ATOM    615  O   LEU A  91      28.952  25.486  73.995  1.00 40.47           O  
ATOM    616  CB  LEU A  91      27.795  23.231  71.825  1.00 39.64           C  
ATOM    617  CG  LEU A  91      26.818  22.634  70.808  1.00 40.12           C  
ATOM    618  CD1 LEU A  91      26.401  23.640  69.726  1.00 40.34           C  
ATOM    619  CD2 LEU A  91      27.391  21.375  70.181  1.00 39.82           C  
ATOM    620  N   SER A  92      26.979  24.526  74.534  1.00 41.16           N  
ATOM    621  CA  SER A  92      27.152  24.687  75.978  1.00 41.83           C  
ATOM    622  C   SER A  92      28.291  23.814  76.488  1.00 42.33           C  
ATOM    623  O   SER A  92      28.610  22.787  75.893  1.00 42.47           O  
ATOM    624  CB  SER A  92      25.861  24.335  76.725  1.00 42.01           C  
ATOM    625  OG  SER A  92      25.534  22.964  76.557  1.00 43.08           O  
ATOM    626  N   LYS A  93      28.892  24.239  77.595  1.00 42.80           N  
ATOM    627  CA  LYS A  93      30.045  23.558  78.172  1.00 43.15           C  
ATOM    628  C   LYS A  93      29.639  22.699  79.372  1.00 43.27           C  
ATOM    629  O   LYS A  93      28.800  23.107  80.182  1.00 43.53           O  
ATOM    630  CB  LYS A  93      31.079  24.589  78.625  1.00 43.43           C  
ATOM    631  CG  LYS A  93      31.576  25.528  77.521  1.00 43.92           C  
ATOM    632  CD  LYS A  93      32.108  26.842  78.100  1.00 44.05           C  
ATOM    633  CE  LYS A  93      32.536  27.818  77.007  1.00 44.51           C  
ATOM    634  NZ  LYS A  93      32.570  29.232  77.493  1.00 45.16           N  
ATOM    635  N   GLN A  94      30.215  21.501  79.458  1.00 43.19           N  
ATOM    636  CA  GLN A  94      30.202  20.715  80.698  1.00 42.90           C  
ATOM    637  C   GLN A  94      31.441  21.127  81.474  1.00 42.75           C  
ATOM    638  O   GLN A  94      32.539  21.151  80.921  1.00 42.95           O  
ATOM    639  CB  GLN A  94      30.237  19.208  80.417  1.00 43.21           C  
ATOM    640  CG  GLN A  94      31.090  18.472  81.444  0.00 20.00           C  
ATOM    641  CD  GLN A  94      30.294  17.533  82.329  0.00 20.00           C  
ATOM    642  OE1 GLN A  94      30.443  16.309  82.230  0.00 20.00           O  
ATOM    643  NE2 GLN A  94      29.445  18.093  83.206  0.00 20.00           N  
ATOM    644  N   THR A  95      31.268  21.468  82.747  1.00 42.11           N  
ATOM    645  CA  THR A  95      32.370  21.990  83.545  1.00 41.54           C  
ATOM    646  C   THR A  95      33.089  20.861  84.279  1.00 40.99           C  
ATOM    647  O   THR A  95      32.493  19.836  84.597  1.00 40.77           O  
ATOM    648  CB  THR A  95      31.895  23.041  84.569  1.00 41.42           C  
ATOM    649  OG1 THR A  95      31.149  22.402  85.613  1.00 41.24           O  
ATOM    650  CG2 THR A  95      31.036  24.115  83.903  1.00 41.63           C  
ATOM    651  N   ILE A  96      34.371  21.071  84.550  1.00 40.45           N  
ATOM    652  CA  ILE A  96      35.175  20.091  85.270  1.00 40.17           C  
ATOM    653  C   ILE A  96      34.631  19.847  86.690  1.00 39.65           C  
ATOM    654  O   ILE A  96      34.640  18.710  87.161  1.00 38.82           O  
ATOM    655  CB  ILE A  96      36.669  20.512  85.303  1.00 40.40           C  
ATOM    656  CG1 ILE A  96      37.562  19.338  85.717  1.00 40.69           C  
ATOM    657  CG2 ILE A  96      36.867  21.698  86.233  1.00 39.98           C  
ATOM    658  CD1 ILE A  96      39.009  19.490  85.277  1.00 40.45           C  
ATOM    659  N   GLN A  97      34.132  20.893  87.355  1.00 39.19           N  
ATOM    660  CA  GLN A  97      33.575  20.736  88.712  1.00 38.95           C  
ATOM    661  C   GLN A  97      32.323  19.872  88.707  1.00 38.94           C  
ATOM    662  O   GLN A  97      32.100  19.114  89.650  1.00 39.29           O  
ATOM    663  CB  GLN A  97      33.287  22.081  89.410  1.00 38.72           C  
ATOM    664  CG  GLN A  97      32.262  22.996  88.728  1.00 37.89           C  
ATOM    665  CD  GLN A  97      32.897  23.928  87.724  1.00 36.04           C  
ATOM    666  OE1 GLN A  97      33.873  23.571  87.071  1.00 36.59           O  
ATOM    667  NE2 GLN A  97      32.352  25.129  87.596  1.00 34.91           N  
ATOM    668  N   ASN A  98      31.520  19.983  87.645  1.00 38.76           N  
ATOM    669  CA  ASN A  98      30.335  19.148  87.479  1.00 38.75           C  
ATOM    670  C   ASN A  98      30.728  17.691  87.300  1.00 38.44           C  
ATOM    671  O   ASN A  98      30.083  16.790  87.840  1.00 38.35           O  
ATOM    672  CB  ASN A  98      29.508  19.606  86.272  1.00 38.91           C  
ATOM    673  CG  ASN A  98      28.062  19.263  86.270  0.00 40.70           C  
ATOM    674  OD1 ASN A  98      27.323  19.718  87.140  0.00 43.88           O  
ATOM    675  ND2 ASN A  98      27.629  18.429  85.322  0.00 43.13           N  
ATOM    676  N   HIS A  99      31.800  17.459  86.547  1.00 38.04           N  
ATOM    677  CA  HIS A  99      32.236  16.099  86.269  1.00 37.42           C  
ATOM    678  C   HIS A  99      32.945  15.472  87.467  1.00 37.23           C  
ATOM    679  O   HIS A  99      32.633  14.346  87.851  1.00 37.15           O  
ATOM    680  CB  HIS A  99      33.157  16.071  85.054  1.00 37.56           C  
ATOM    681  CG  HIS A  99      33.444  14.692  84.565  1.00 37.89           C  
ATOM    682  ND1 HIS A  99      32.476  13.889  84.008  1.00 37.28           N  
ATOM    683  CD2 HIS A  99      34.583  13.963  84.569  1.00 37.76           C  
ATOM    684  CE1 HIS A  99      33.009  12.725  83.684  1.00 38.34           C  
ATOM    685  NE2 HIS A  99      34.289  12.747  84.008  1.00 37.41           N  
ATOM    686  N   LEU A 100      33.898  16.199  88.051  1.00 36.55           N  
ATOM    687  CA  LEU A 100      34.691  15.654  89.151  1.00 36.41           C  
ATOM    688  C   LEU A 100      33.979  15.722  90.505  1.00 35.83           C  
ATOM    689  O   LEU A 100      34.209  14.872  91.362  1.00 36.04           O  
ATOM    690  CB  LEU A 100      36.027  16.375  89.268  1.00 36.40           C  
ATOM    691  CG  LEU A 100      37.016  16.330  88.096  1.00 36.64           C  
ATOM    692  CD1 LEU A 100      38.316  17.007  88.513  1.00 37.39           C  
ATOM    693  CD2 LEU A 100      37.280  14.916  87.627  1.00 37.96           C  
ATOM    694  N   GLY A 101      33.144  16.738  90.692  1.00 35.67           N  
ATOM    695  CA  GLY A 101      32.533  17.043  91.990  1.00 35.42           C  
ATOM    696  C   GLY A 101      33.443  18.016  92.722  1.00 35.22           C  
ATOM    697  O   GLY A 101      34.648  18.030  92.479  1.00 34.45           O  
ATOM    698  N   GLU A 102      32.879  18.827  93.614  1.00 35.06           N  
ATOM    699  CA  GLU A 102      33.663  19.863  94.296  1.00 35.13           C  
ATOM    700  C   GLU A 102      34.694  19.302  95.269  1.00 34.99           C  
ATOM    701  O   GLU A 102      35.740  19.927  95.482  1.00 34.24           O  
ATOM    702  CB  GLU A 102      32.758  20.840  95.045  1.00 35.26           C  
ATOM    703  CG  GLU A 102      31.777  21.582  94.167  1.00 35.44           C  
ATOM    704  CD  GLU A 102      32.415  22.628  93.279  1.00 35.60           C  
ATOM    705  OE1 GLU A 102      33.633  22.894  93.400  1.00 35.70           O  
ATOM    706  OE2 GLU A 102      31.677  23.194  92.452  1.00 35.47           O  
ATOM    707  N   GLU A 103      34.410  18.144  95.867  1.00 35.04           N  
ATOM    708  CA  GLU A 103      35.321  17.595  96.876  1.00 35.53           C  
ATOM    709  C   GLU A 103      36.631  17.100  96.263  1.00 35.21           C  
ATOM    710  O   GLU A 103      37.714  17.472  96.729  1.00 35.24           O  
ATOM    711  CB  GLU A 103      34.636  16.500  97.705  1.00 36.27           C  
ATOM    712  CG  GLU A 103      33.486  17.020  98.558  1.00 38.97           C  
ATOM    713  CD  GLU A 103      33.853  18.264  99.355  1.00 42.31           C  
ATOM    714  OE1 GLU A 103      34.700  18.161 100.270  1.00 45.21           O  
ATOM    715  OE2 GLU A 103      33.299  19.345  99.059  1.00 43.89           O  
ATOM    716  N   LEU A 104      36.546  16.287  95.211  1.00 34.75           N  
ATOM    717  CA  LEU A 104      37.755  15.807  94.529  1.00 34.57           C  
ATOM    718  C   LEU A 104      38.534  16.978  93.941  1.00 33.99           C  
ATOM    719  O   LEU A 104      39.765  17.038  94.028  1.00 33.15           O  
ATOM    720  CB  LEU A 104      37.406  14.816  93.413  1.00 34.48           C  
ATOM    721  CG  LEU A 104      38.558  14.300  92.543  1.00 34.75           C  
ATOM    722  CD1 LEU A 104      39.684  13.676  93.383  1.00 34.52           C  
ATOM    723  CD2 LEU A 104      38.028  13.300  91.526  1.00 34.52           C  
ATOM    724  N   LEU A 105      37.813  17.904  93.324  1.00 34.18           N  
ATOM    725  CA  LEU A 105      38.455  19.058  92.704  1.00 34.19           C  
ATOM    726  C   LEU A 105      39.242  19.863  93.734  1.00 33.95           C  
ATOM    727  O   LEU A 105      40.371  20.275  93.472  1.00 33.83           O  
ATOM    728  CB  LEU A 105      37.405  19.936  92.029  1.00 34.44           C  
ATOM    729  CG  LEU A 105      37.877  21.244  91.409  1.00 34.27           C  
ATOM    730  CD1 LEU A 105      38.992  20.993  90.385  1.00 35.04           C  
ATOM    731  CD2 LEU A 105      36.688  21.958  90.768  1.00 35.52           C  
ATOM    732  N   GLN A 106      38.655  20.083  94.908  1.00 33.45           N  
ATOM    733  CA  GLN A 106      39.337  20.875  95.931  1.00 33.64           C  
ATOM    734  C   GLN A 106      40.468  20.085  96.593  1.00 33.15           C  
ATOM    735  O   GLN A 106      41.494  20.648  96.967  1.00 34.02           O  
ATOM    736  CB  GLN A 106      38.353  21.399  96.965  1.00 33.53           C  
ATOM    737  CG  GLN A 106      39.007  22.330  97.945  1.00 34.35           C  
ATOM    738  CD  GLN A 106      38.023  23.101  98.779  1.00 35.02           C  
ATOM    739  OE1 GLN A 106      36.799  22.975  98.628  1.00 39.54           O  
ATOM    740  NE2 GLN A 106      38.549  23.908  99.676  1.00 33.34           N  
ATOM    741  N   ASP A 107      40.286  18.778  96.728  1.00 33.08           N  
ATOM    742  CA  ASP A 107      41.364  17.895  97.181  1.00 32.54           C  
ATOM    743  C   ASP A 107      42.577  18.047  96.267  1.00 32.14           C  
ATOM    744  O   ASP A 107      43.719  18.193  96.732  1.00 31.97           O  
ATOM    745  CB  ASP A 107      40.907  16.431  97.151  1.00 32.31           C  
ATOM    746  CG  ASP A 107      39.987  16.059  98.305  1.00 33.77           C  
ATOM    747  OD1 ASP A 107      39.674  16.911  99.161  1.00 33.59           O  
ATOM    748  OD2 ASP A 107      39.563  14.885  98.336  1.00 33.95           O  
ATOM    749  N   LEU A 108      42.318  18.018  94.963  1.00 31.80           N  
ATOM    750  CA  LEU A 108      43.358  18.223  93.952  1.00 31.98           C  
ATOM    751  C   LEU A 108      44.004  19.593  94.085  1.00 31.76           C  
ATOM    752  O   LEU A 108      45.217  19.713  94.173  1.00 31.58           O  
ATOM    753  CB  LEU A 108      42.757  18.046  92.554  1.00 32.38           C  
ATOM    754  CG  LEU A 108      43.623  18.431  91.356  1.00 32.41           C  
ATOM    755  CD1 LEU A 108      44.902  17.584  91.334  1.00 31.87           C  
ATOM    756  CD2 LEU A 108      42.803  18.268  90.083  1.00 32.44           C  
ATOM    757  N   ILE A 109      43.183  20.629  94.085  1.00 31.94           N  
ATOM    758  CA  ILE A 109      43.680  21.983  94.225  1.00 32.01           C  
ATOM    759  C   ILE A 109      44.525  22.149  95.491  1.00 31.72           C  
ATOM    760  O   ILE A 109      45.628  22.693  95.444  1.00 32.26           O  
ATOM    761  CB  ILE A 109      42.522  22.999  94.190  1.00 32.05           C  
ATOM    762  CG1 ILE A 109      41.965  23.095  92.764  1.00 31.25           C  
ATOM    763  CG2 ILE A 109      43.000  24.388  94.646  1.00 32.74           C  
ATOM    764  CD1 ILE A 109      40.639  23.804  92.662  1.00 31.98           C  
ATOM    765  N   ASN A 110      44.036  21.685  96.631  1.00 31.61           N  
ATOM    766  CA  ASN A 110      44.798  21.908  97.861  1.00 32.31           C  
ATOM    767  C   ASN A 110      46.102  21.121  97.910  1.00 32.25           C  
ATOM    768  O   ASN A 110      47.106  21.613  98.441  1.00 32.62           O  
ATOM    769  CB  ASN A 110      43.931  21.661  99.086  1.00 31.68           C  
ATOM    770  CG  ASN A 110      42.945  22.798  99.333  1.00 32.94           C  
ATOM    771  OD1 ASN A 110      42.986  23.837  98.659  1.00 32.28           O  
ATOM    772  ND2 ASN A 110      42.069  22.619 100.322  1.00 33.60           N  
ATOM    773  N   PHE A 111      46.098  19.912  97.346  1.00 32.79           N  
ATOM    774  CA  PHE A 111      47.328  19.132  97.234  1.00 32.93           C  
ATOM    775  C   PHE A 111      48.376  19.899  96.419  1.00 33.02           C  
ATOM    776  O   PHE A 111      49.551  19.936  96.783  1.00 33.43           O  
ATOM    777  CB  PHE A 111      47.062  17.769  96.593  1.00 33.69           C  
ATOM    778  CG  PHE A 111      48.264  16.852  96.602  1.00 33.93           C  
ATOM    779  CD1 PHE A 111      48.413  15.892  97.582  1.00 36.28           C  
ATOM    780  CD2 PHE A 111      49.252  16.975  95.628  1.00 35.50           C  
ATOM    781  CE1 PHE A 111      49.524  15.056  97.592  1.00 35.98           C  
ATOM    782  CE2 PHE A 111      50.359  16.143  95.627  1.00 35.59           C  
ATOM    783  CZ  PHE A 111      50.494  15.188  96.608  1.00 35.25           C  
ATOM    784  N   CYS A 112      47.945  20.496  95.314  1.00 33.03           N  
ATOM    785  CA  CYS A 112      48.837  21.271  94.445  1.00 32.90           C  
ATOM    786  C   CYS A 112      49.358  22.534  95.137  1.00 32.98           C  
ATOM    787  O   CYS A 112      50.553  22.844  95.058  1.00 33.06           O  
ATOM    788  CB  CYS A 112      48.129  21.646  93.146  1.00 33.05           C  
ATOM    789  SG  CYS A 112      47.829  20.243  92.028  1.00 33.42           S  
ATOM    790  N   LEU A 113      48.473  23.261  95.817  1.00 33.10           N  
ATOM    791  CA  LEU A 113      48.879  24.451  96.576  1.00 33.14           C  
ATOM    792  C   LEU A 113      49.907  24.061  97.642  1.00 33.28           C  
ATOM    793  O   LEU A 113      50.940  24.718  97.801  1.00 32.79           O  
ATOM    794  CB  LEU A 113      47.669  25.142  97.227  1.00 33.30           C  
ATOM    795  CG  LEU A 113      46.633  25.772  96.294  1.00 33.06           C  
ATOM    796  CD1 LEU A 113      45.404  26.210  97.095  1.00 31.84           C  
ATOM    797  CD2 LEU A 113      47.251  26.959  95.507  1.00 31.92           C  
ATOM    798  N   SER A 114      49.636  22.968  98.352  1.00 33.30           N  
ATOM    799  CA  SER A 114      50.514  22.503  99.421  1.00 33.93           C  
ATOM    800  C   SER A 114      51.887  22.108  98.890  1.00 33.70           C  
ATOM    801  O   SER A 114      52.916  22.464  99.465  1.00 33.97           O  
ATOM    802  CB  SER A 114      49.885  21.302 100.135  1.00 34.33           C  
ATOM    803  OG  SER A 114      50.661  20.927 101.253  1.00 37.51           O  
ATOM    804  N   TYR A 115      51.890  21.368  97.788  1.00 33.44           N  
ATOM    805  CA  TYR A 115      53.123  20.902  97.155  1.00 33.63           C  
ATOM    806  C   TYR A 115      53.971  22.083  96.687  1.00 33.84           C  
ATOM    807  O   TYR A 115      55.177  22.164  96.953  1.00 34.34           O  
ATOM    808  CB  TYR A 115      52.771  20.009  95.954  1.00 33.49           C  
ATOM    809  CG  TYR A 115      53.969  19.310  95.342  1.00 32.71           C  
ATOM    810  CD1 TYR A 115      54.282  18.007  95.697  1.00 32.37           C  
ATOM    811  CD2 TYR A 115      54.803  19.964  94.431  1.00 32.25           C  
ATOM    812  CE1 TYR A 115      55.385  17.363  95.164  1.00 33.04           C  
ATOM    813  CE2 TYR A 115      55.912  19.325  93.889  1.00 33.06           C  
ATOM    814  CZ  TYR A 115      56.190  18.023  94.254  1.00 32.40           C  
ATOM    815  OH  TYR A 115      57.288  17.374  93.735  1.00 33.37           O  
HETATM  816  N   MSE A 116      53.334  23.004  95.974  1.00 34.43           N  
HETATM  817  CA  MSE A 116      54.034  24.154  95.418  1.00 34.95           C  
HETATM  818  C   MSE A 116      54.547  25.117  96.479  1.00 34.64           C  
HETATM  819  O   MSE A 116      55.559  25.762  96.267  1.00 34.82           O  
HETATM  820  CB  MSE A 116      53.129  24.887  94.432  1.00 34.69           C  
HETATM  821  CG  MSE A 116      52.968  24.131  93.141  1.00 35.45           C  
HETATM  822 SE   MSE A 116      52.078  25.188  91.762  1.00 37.99          SE  
HETATM  823  CE  MSE A 116      50.273  25.085  92.418  1.00 33.95           C  
ATOM    824  N   ALA A 117      53.872  25.191  97.627  1.00 34.83           N  
ATOM    825  CA  ALA A 117      54.317  26.055  98.730  1.00 35.36           C  
ATOM    826  C   ALA A 117      55.720  25.678  99.196  1.00 35.87           C  
ATOM    827  O   ALA A 117      56.476  26.527  99.696  1.00 36.17           O  
ATOM    828  CB  ALA A 117      53.337  25.991  99.894  1.00 35.04           C  
ATOM    829  N   LEU A 118      56.071  24.409  99.007  1.00 36.02           N  
ATOM    830  CA  LEU A 118      57.344  23.864  99.465  1.00 36.59           C  
ATOM    831  C   LEU A 118      58.425  23.863  98.383  1.00 36.93           C  
ATOM    832  O   LEU A 118      59.595  23.584  98.680  1.00 37.80           O  
ATOM    833  CB  LEU A 118      57.127  22.447  99.989  1.00 36.74           C  
ATOM    834  CG  LEU A 118      56.167  22.337 101.178  1.00 37.57           C  
ATOM    835  CD1 LEU A 118      55.807  20.883 101.449  1.00 38.72           C  
ATOM    836  CD2 LEU A 118      56.764  22.972 102.415  1.00 38.78           C  
ATOM    837  N   LEU A 119      58.048  24.180  97.144  1.00 36.80           N  
ATOM    838  CA  LEU A 119      59.009  24.316  96.044  1.00 36.51           C  
ATOM    839  C   LEU A 119      59.658  25.681  96.041  1.00 36.11           C  
ATOM    840  O   LEU A 119      58.973  26.695  96.055  1.00 35.35           O  
ATOM    841  CB  LEU A 119      58.331  24.137  94.681  1.00 36.82           C  
ATOM    842  CG  LEU A 119      57.857  22.781  94.222  1.00 37.54           C  
ATOM    843  CD1 LEU A 119      57.263  22.933  92.829  1.00 36.91           C  
ATOM    844  CD2 LEU A 119      58.987  21.739  94.225  1.00 37.83           C  
ATOM    845  N   ARG A 120      60.986  25.704  95.986  1.00 35.72           N  
ATOM    846  CA  ARG A 120      61.735  26.940  95.920  1.00 35.83           C  
ATOM    847  C   ARG A 120      62.392  27.026  94.544  1.00 36.03           C  
ATOM    848  O   ARG A 120      63.180  26.155  94.161  1.00 36.55           O  
ATOM    849  CB  ARG A 120      62.763  27.002  97.055  1.00 35.85           C  
ATOM    850  CG  ARG A 120      63.304  28.387  97.332  1.00 36.25           C  
ATOM    851  CD  ARG A 120      62.311  29.297  98.051  1.00 36.21           C  
ATOM    852  NE  ARG A 120      62.779  30.683  98.047  1.00 36.09           N  
ATOM    853  CZ  ARG A 120      62.195  31.692  98.696  1.00 35.20           C  
ATOM    854  NH1 ARG A 120      61.111  31.492  99.431  1.00 35.70           N  
ATOM    855  NH2 ARG A 120      62.708  32.908  98.610  1.00 35.56           N  
ATOM    856  N   LEU A 121      62.033  28.068  93.801  1.00 35.78           N  
ATOM    857  CA  LEU A 121      62.479  28.289  92.436  1.00 35.92           C  
ATOM    858  C   LEU A 121      63.235  29.608  92.342  1.00 36.04           C  
ATOM    859  O   LEU A 121      63.211  30.399  93.280  1.00 36.56           O  
ATOM    860  CB  LEU A 121      61.256  28.351  91.517  1.00 35.73           C  
ATOM    861  CG  LEU A 121      60.253  27.197  91.574  1.00 35.83           C  
ATOM    862  CD1 LEU A 121      59.162  27.429  90.546  1.00 34.40           C  
ATOM    863  CD2 LEU A 121      60.925  25.845  91.326  1.00 35.84           C  
ATOM    864  N   PRO A 122      63.919  29.857  91.211  1.00 36.09           N  
ATOM    865  CA  PRO A 122      64.564  31.158  91.051  1.00 35.69           C  
ATOM    866  C   PRO A 122      63.576  32.321  91.082  1.00 35.16           C  
ATOM    867  O   PRO A 122      63.873  33.386  91.627  1.00 34.37           O  
ATOM    868  CB  PRO A 122      65.229  31.053  89.673  1.00 35.64           C  
ATOM    869  CG  PRO A 122      65.400  29.591  89.444  1.00 36.69           C  
ATOM    870  CD  PRO A 122      64.183  28.975  90.057  1.00 36.13           C  
ATOM    871  N   LYS A 123      62.402  32.103  90.498  1.00 34.86           N  
ATOM    872  CA  LYS A 123      61.398  33.136  90.394  1.00 34.67           C  
ATOM    873  C   LYS A 123      60.024  32.490  90.515  1.00 33.95           C  
ATOM    874  O   LYS A 123      59.824  31.383  90.035  1.00 33.26           O  
ATOM    875  CB  LYS A 123      61.512  33.838  89.041  1.00 34.91           C  
ATOM    876  CG  LYS A 123      62.868  34.471  88.744  1.00 35.98           C  
ATOM    877  CD  LYS A 123      62.838  35.201  87.403  1.00 36.25           C  
ATOM    878  CE  LYS A 123      64.082  36.040  87.179  1.00 37.93           C  
ATOM    879  NZ  LYS A 123      65.312  35.212  87.173  1.00 37.18           N  
ATOM    880  N   LYS A 124      59.094  33.175  91.176  1.00 33.84           N  
ATOM    881  CA  LYS A 124      57.683  32.815  91.075  1.00 32.88           C  
ATOM    882  C   LYS A 124      56.870  34.056  90.785  1.00 32.99           C  
ATOM    883  O   LYS A 124      57.249  35.164  91.176  1.00 31.97           O  
ATOM    884  CB  LYS A 124      57.153  32.147  92.345  1.00 33.24           C  
ATOM    885  CG  LYS A 124      57.762  30.803  92.666  1.00 32.80           C  
ATOM    886  CD  LYS A 124      56.895  30.026  93.648  1.00 32.57           C  
ATOM    887  CE  LYS A 124      57.538  28.708  94.047  1.00 33.18           C  
ATOM    888  NZ  LYS A 124      56.646  27.891  94.902  1.00 32.45           N  
ATOM    889  N   ARG A 125      55.726  33.846  90.141  1.00 32.73           N  
ATOM    890  CA  ARG A 125      54.891  34.946  89.681  1.00 33.29           C  
ATOM    891  C   ARG A 125      53.440  34.788  90.125  1.00 33.24           C  
ATOM    892  O   ARG A 125      53.125  34.994  91.296  1.00 33.50           O  
ATOM    893  CB  ARG A 125      55.022  35.104  88.161  1.00 33.28           C  
ATOM    894  CG  ARG A 125      56.442  35.487  87.700  1.00 33.97           C  
ATOM    895  CD  ARG A 125      56.819  36.881  88.147  1.00 33.82           C  
ATOM    896  NE  ARG A 125      58.186  37.262  87.787  1.00 33.94           N  
ATOM    897  CZ  ARG A 125      59.224  37.257  88.617  1.00 34.12           C  
ATOM    898  NH1 ARG A 125      59.080  36.880  89.879  1.00 34.82           N  
ATOM    899  NH2 ARG A 125      60.425  37.638  88.179  1.00 35.33           N  
ATOM    900  N   GLY A 126      52.548  34.447  89.201  1.00 32.74           N  
ATOM    901  CA  GLY A 126      51.146  34.296  89.536  1.00 32.63           C  
ATOM    902  C   GLY A 126      50.520  33.291  88.600  1.00 32.04           C  
ATOM    903  O   GLY A 126      51.146  32.864  87.643  1.00 32.20           O  
ATOM    904  N   THR A 127      49.276  32.942  88.876  1.00 31.56           N  
ATOM    905  CA  THR A 127      48.527  31.958  88.106  1.00 31.41           C  
ATOM    906  C   THR A 127      49.255  30.599  88.090  1.00 31.09           C  
ATOM    907  O   THR A 127      49.650  30.070  87.050  1.00 30.53           O  
ATOM    908  CB  THR A 127      48.166  32.488  86.704  1.00 31.33           C  
ATOM    909  OG1 THR A 127      47.594  33.801  86.826  1.00 32.29           O  
ATOM    910  CG2 THR A 127      47.156  31.568  86.022  1.00 31.16           C  
ATOM    911  N   PHE A 128      49.389  30.041  89.287  1.00 31.08           N  
ATOM    912  CA  PHE A 128      49.992  28.730  89.489  1.00 30.90           C  
ATOM    913  C   PHE A 128      48.992  27.647  89.127  1.00 31.57           C  
ATOM    914  O   PHE A 128      49.368  26.555  88.739  1.00 31.68           O  
ATOM    915  CB  PHE A 128      50.425  28.582  90.937  1.00 31.48           C  
ATOM    916  CG  PHE A 128      51.383  29.630  91.354  1.00 29.43           C  
ATOM    917  CD1 PHE A 128      52.718  29.503  91.051  1.00 31.06           C  
ATOM    918  CD2 PHE A 128      50.948  30.787  91.967  1.00 30.75           C  
ATOM    919  CE1 PHE A 128      53.607  30.489  91.380  1.00 30.08           C  
ATOM    920  CE2 PHE A 128      51.831  31.784  92.294  1.00 30.64           C  
ATOM    921  CZ  PHE A 128      53.171  31.632  92.003  1.00 30.83           C  
ATOM    922  N   ILE A 129      47.711  27.982  89.274  1.00 31.97           N  
ATOM    923  CA  ILE A 129      46.638  27.063  88.936  1.00 32.03           C  
ATOM    924  C   ILE A 129      45.663  27.801  88.028  1.00 31.42           C  
ATOM    925  O   ILE A 129      44.999  28.739  88.452  1.00 32.05           O  
ATOM    926  CB  ILE A 129      45.932  26.531  90.195  1.00 31.83           C  
ATOM    927  CG1 ILE A 129      46.937  25.796  91.102  1.00 32.89           C  
ATOM    928  CG2 ILE A 129      44.751  25.599  89.798  1.00 32.33           C  
ATOM    929  CD1 ILE A 129      46.353  25.156  92.390  1.00 33.46           C  
ATOM    930  N   GLU A 130      45.596  27.404  86.755  1.00 31.99           N  
ATOM    931  CA  GLU A 130      44.660  28.032  85.824  1.00 32.62           C  
ATOM    932  C   GLU A 130      43.486  27.098  85.582  1.00 32.64           C  
ATOM    933  O   GLU A 130      43.663  25.984  85.095  1.00 33.03           O  
ATOM    934  CB  GLU A 130      45.330  28.390  84.488  1.00 32.72           C  
ATOM    935  CG  GLU A 130      44.464  29.325  83.654  1.00 32.66           C  
ATOM    936  CD  GLU A 130      45.143  29.827  82.393  1.00 33.55           C  
ATOM    937  OE1 GLU A 130      45.690  29.009  81.635  1.00 33.57           O  
ATOM    938  OE2 GLU A 130      45.098  31.046  82.135  1.00 35.80           O  
ATOM    939  N   PHE A 131      42.292  27.552  85.956  1.00 32.71           N  
ATOM    940  CA  PHE A 131      41.068  26.769  85.851  1.00 33.24           C  
ATOM    941  C   PHE A 131      40.517  26.980  84.448  1.00 32.89           C  
ATOM    942  O   PHE A 131      39.965  28.039  84.137  1.00 33.22           O  
ATOM    943  CB  PHE A 131      40.080  27.245  86.930  1.00 34.34           C  
ATOM    944  CG  PHE A 131      38.964  26.293  87.220  1.00 35.21           C  
ATOM    945  CD1 PHE A 131      39.122  25.280  88.155  1.00 37.05           C  
ATOM    946  CD2 PHE A 131      37.742  26.428  86.593  1.00 36.88           C  
ATOM    947  CE1 PHE A 131      38.088  24.396  88.434  1.00 37.97           C  
ATOM    948  CE2 PHE A 131      36.699  25.547  86.868  1.00 36.73           C  
ATOM    949  CZ  PHE A 131      36.877  24.531  87.788  1.00 36.63           C  
ATOM    950  N   ARG A 132      40.705  25.988  83.581  1.00 32.30           N  
ATOM    951  CA  ARG A 132      40.247  26.087  82.195  1.00 32.45           C  
ATOM    952  C   ARG A 132      38.953  25.300  82.027  1.00 33.02           C  
ATOM    953  O   ARG A 132      38.377  24.816  83.000  1.00 33.61           O  
ATOM    954  CB  ARG A 132      41.324  25.580  81.239  1.00 32.46           C  
ATOM    955  CG  ARG A 132      42.637  26.318  81.373  1.00 32.55           C  
ATOM    956  CD  ARG A 132      43.671  25.831  80.391  1.00 32.00           C  
ATOM    957  NE  ARG A 132      44.954  26.484  80.630  1.00 32.10           N  
ATOM    958  CZ  ARG A 132      46.111  26.101  80.103  1.00 32.55           C  
ATOM    959  NH1 ARG A 132      46.173  25.064  79.290  1.00 34.60           N  
ATOM    960  NH2 ARG A 132      47.219  26.766  80.396  1.00 33.80           N  
ATOM    961  N   ASN A 133      38.480  25.184  80.796  1.00 32.88           N  
ATOM    962  CA  ASN A 133      37.283  24.421  80.533  1.00 33.45           C  
ATOM    963  C   ASN A 133      37.544  22.918  80.632  1.00 33.48           C  
ATOM    964  O   ASN A 133      36.777  22.197  81.263  1.00 34.08           O  
ATOM    965  CB  ASN A 133      36.723  24.795  79.162  1.00 33.43           C  
ATOM    966  CG  ASN A 133      36.326  26.257  79.085  1.00 34.36           C  
ATOM    967  OD1 ASN A 133      35.377  26.683  79.741  1.00 35.87           O  
ATOM    968  ND2 ASN A 133      37.049  27.034  78.283  1.00 35.03           N  
ATOM    969  N   GLY A 134      38.639  22.462  80.029  1.00 33.54           N  
ATOM    970  CA  GLY A 134      38.924  21.032  79.917  1.00 33.35           C  
ATOM    971  C   GLY A 134      39.991  20.467  80.823  1.00 33.80           C  
ATOM    972  O   GLY A 134      40.285  19.272  80.759  1.00 33.82           O  
HETATM  973  N   MSE A 135      40.578  21.302  81.675  1.00 33.77           N  
HETATM  974  CA  MSE A 135      41.677  20.859  82.525  1.00 35.09           C  
HETATM  975  C   MSE A 135      41.922  21.902  83.598  1.00 33.84           C  
HETATM  976  O   MSE A 135      41.400  23.015  83.509  1.00 33.50           O  
HETATM  977  CB  MSE A 135      42.954  20.694  81.687  1.00 34.54           C  
HETATM  978  CG  MSE A 135      43.560  22.021  81.206  1.00 36.83           C  
HETATM  979 SE   MSE A 135      44.399  21.902  79.415  1.00 43.44          SE  
HETATM  980  CE  MSE A 135      42.734  22.100  78.398  1.00 40.43           C  
ATOM    981  N   LEU A 136      42.699  21.530  84.610  1.00 33.56           N  
ATOM    982  CA  LEU A 136      43.399  22.499  85.433  1.00 34.23           C  
ATOM    983  C   LEU A 136      44.845  22.498  84.974  1.00 33.53           C  
ATOM    984  O   LEU A 136      45.475  21.438  84.900  1.00 33.88           O  
ATOM    985  CB  LEU A 136      43.373  22.123  86.910  1.00 34.50           C  
ATOM    986  CG  LEU A 136      42.291  22.743  87.784  1.00 36.13           C  
ATOM    987  CD1 LEU A 136      40.931  22.427  87.214  1.00 39.46           C  
ATOM    988  CD2 LEU A 136      42.475  22.192  89.221  1.00 37.21           C  
ATOM    989  N   ASN A 137      45.378  23.675  84.685  1.00 32.25           N  
ATOM    990  CA  ASN A 137      46.782  23.791  84.312  1.00 32.38           C  
ATOM    991  C   ASN A 137      47.576  24.219  85.534  1.00 32.48           C  
ATOM    992  O   ASN A 137      47.177  25.166  86.212  1.00 31.85           O  
ATOM    993  CB  ASN A 137      46.953  24.786  83.168  1.00 32.47           C  
ATOM    994  CG  ASN A 137      48.396  24.939  82.757  1.00 33.05           C  
ATOM    995  OD1 ASN A 137      49.084  25.843  83.235  1.00 32.06           O  
ATOM    996  ND2 ASN A 137      48.878  24.037  81.923  1.00 32.89           N  
ATOM    997  N   ILE A 138      48.658  23.494  85.830  1.00 32.02           N  
ATOM    998  CA  ILE A 138      49.452  23.730  87.024  1.00 31.90           C  
ATOM    999  C   ILE A 138      50.844  24.152  86.590  1.00 32.01           C  
ATOM   1000  O   ILE A 138      51.519  23.415  85.866  1.00 31.70           O  
ATOM   1001  CB  ILE A 138      49.558  22.461  87.913  1.00 32.61           C  
ATOM   1002  CG1 ILE A 138      48.179  21.807  88.100  1.00 31.83           C  
ATOM   1003  CG2 ILE A 138      50.190  22.812  89.261  1.00 32.20           C  
ATOM   1004  CD1 ILE A 138      47.161  22.675  88.802  1.00 33.31           C  
ATOM   1005  N   SER A 139      51.250  25.339  87.028  1.00 31.53           N  
ATOM   1006  CA  SER A 139      52.543  25.938  86.674  1.00 31.90           C  
ATOM   1007  C   SER A 139      53.319  26.325  87.927  1.00 31.65           C  
ATOM   1008  O   SER A 139      52.954  27.269  88.611  1.00 32.36           O  
ATOM   1009  CB  SER A 139      52.349  27.198  85.841  1.00 31.63           C  
ATOM   1010  OG  SER A 139      53.617  27.784  85.575  1.00 32.14           O  
ATOM   1011  N   PRO A 140      54.391  25.595  88.238  1.00 32.18           N  
ATOM   1012  CA  PRO A 140      55.220  25.953  89.398  1.00 32.03           C  
ATOM   1013  C   PRO A 140      55.778  27.383  89.419  1.00 31.73           C  
ATOM   1014  O   PRO A 140      55.855  27.996  90.488  1.00 31.83           O  
ATOM   1015  CB  PRO A 140      56.337  24.907  89.357  1.00 31.88           C  
ATOM   1016  CG  PRO A 140      55.668  23.700  88.690  1.00 32.43           C  
ATOM   1017  CD  PRO A 140      54.839  24.342  87.603  1.00 32.19           C  
ATOM   1018  N   ILE A 141      56.164  27.913  88.264  1.00 31.87           N  
ATOM   1019  CA  ILE A 141      56.649  29.296  88.193  1.00 32.05           C  
ATOM   1020  C   ILE A 141      55.486  30.306  88.203  1.00 32.23           C  
ATOM   1021  O   ILE A 141      55.621  31.421  88.725  1.00 33.07           O  
ATOM   1022  CB  ILE A 141      57.550  29.519  86.950  1.00 31.90           C  
ATOM   1023  CG1 ILE A 141      57.924  31.004  86.820  1.00 32.04           C  
ATOM   1024  CG2 ILE A 141      56.842  29.046  85.678  1.00 31.68           C  
ATOM   1025  CD1 ILE A 141      59.160  31.289  85.961  1.00 32.53           C  
ATOM   1026  N   GLY A 142      54.354  29.909  87.628  1.00 32.63           N  
ATOM   1027  CA  GLY A 142      53.230  30.801  87.415  1.00 32.71           C  
ATOM   1028  C   GLY A 142      53.156  31.211  85.952  1.00 32.85           C  
ATOM   1029  O   GLY A 142      54.173  31.569  85.351  1.00 32.93           O  
ATOM   1030  N   ARG A 143      51.949  31.172  85.389  1.00 33.05           N  
ATOM   1031  CA  ARG A 143      51.711  31.489  83.972  1.00 33.89           C  
ATOM   1032  C   ARG A 143      52.065  32.919  83.579  1.00 34.03           C  
ATOM   1033  O   ARG A 143      52.346  33.199  82.405  1.00 34.18           O  
ATOM   1034  CB  ARG A 143      50.230  31.236  83.642  1.00 33.72           C  
ATOM   1035  CG  ARG A 143      49.808  31.476  82.203  1.00 34.85           C  
ATOM   1036  CD  ARG A 143      48.723  30.479  81.765  1.00 34.88           C  
ATOM   1037  NE  ARG A 143      49.240  29.131  81.905  1.00 33.79           N  
ATOM   1038  CZ  ARG A 143      50.097  28.556  81.059  1.00 34.81           C  
ATOM   1039  NH1 ARG A 143      50.495  29.178  79.960  1.00 34.36           N  
ATOM   1040  NH2 ARG A 143      50.551  27.344  81.312  1.00 33.94           N  
ATOM   1041  N   SER A 144      52.043  33.833  84.543  1.00 34.48           N  
ATOM   1042  CA  SER A 144      52.299  35.249  84.259  1.00 34.84           C  
ATOM   1043  C   SER A 144      53.787  35.612  84.193  1.00 35.52           C  
ATOM   1044  O   SER A 144      54.146  36.781  84.342  1.00 36.75           O  
ATOM   1045  CB  SER A 144      51.578  36.133  85.288  1.00 35.12           C  
ATOM   1046  OG  SER A 144      51.827  35.679  86.604  1.00 35.86           O  
ATOM   1047  N   CYS A 145      54.647  34.630  83.952  1.00 35.56           N  
ATOM   1048  CA  CYS A 145      56.072  34.911  83.772  1.00 35.38           C  
ATOM   1049  C   CYS A 145      56.349  35.408  82.360  1.00 35.59           C  
ATOM   1050  O   CYS A 145      55.570  35.158  81.436  1.00 35.29           O  
ATOM   1051  CB  CYS A 145      56.898  33.665  84.048  1.00 35.37           C  
ATOM   1052  SG  CYS A 145      56.496  32.287  82.965  1.00 35.01           S  
ATOM   1053  N   THR A 146      57.463  36.124  82.216  1.00 35.48           N  
ATOM   1054  CA  THR A 146      57.920  36.623  80.920  1.00 35.17           C  
ATOM   1055  C   THR A 146      58.536  35.498  80.092  1.00 35.10           C  
ATOM   1056  O   THR A 146      58.726  34.378  80.575  1.00 34.73           O  
ATOM   1057  CB  THR A 146      58.962  37.756  81.088  1.00 35.46           C  
ATOM   1058  OG1 THR A 146      60.147  37.247  81.715  1.00 34.80           O  
ATOM   1059  CG2 THR A 146      58.402  38.873  81.937  1.00 35.67           C  
ATOM   1060  N   LEU A 147      58.854  35.804  78.840  1.00 34.74           N  
ATOM   1061  CA  LEU A 147      59.500  34.837  77.952  1.00 34.57           C  
ATOM   1062  C   LEU A 147      60.829  34.330  78.520  1.00 34.07           C  
ATOM   1063  O   LEU A 147      61.064  33.125  78.566  1.00 33.97           O  
ATOM   1064  CB  LEU A 147      59.714  35.462  76.565  1.00 34.52           C  
ATOM   1065  CG  LEU A 147      60.444  34.621  75.515  1.00 34.69           C  
ATOM   1066  CD1 LEU A 147      59.867  33.210  75.424  1.00 35.45           C  
ATOM   1067  CD2 LEU A 147      60.395  35.323  74.158  1.00 35.15           C  
ATOM   1068  N   GLU A 148      61.697  35.244  78.950  1.00 33.79           N  
ATOM   1069  CA  GLU A 148      63.003  34.854  79.496  1.00 33.72           C  
ATOM   1070  C   GLU A 148      62.855  34.013  80.772  1.00 33.55           C  
ATOM   1071  O   GLU A 148      63.608  33.065  80.988  1.00 33.58           O  
ATOM   1072  CB  GLU A 148      63.882  36.088  79.753  1.00 33.58           C  
ATOM   1073  CG  GLU A 148      64.350  36.846  78.570  0.00 20.00           C  
ATOM   1074  CD  GLU A 148      65.181  38.072  78.902  0.00 20.00           C  
ATOM   1075  OE1 GLU A 148      65.365  38.358  80.103  0.00 20.00           O  
ATOM   1076  OE2 GLU A 148      65.646  38.749  77.960  0.00 20.00           O  
ATOM   1077  N   GLU A 149      61.874  34.360  81.604  1.00 33.74           N  
ATOM   1078  CA  GLU A 149      61.567  33.613  82.828  1.00 33.76           C  
ATOM   1079  C   GLU A 149      61.054  32.209  82.506  1.00 33.60           C  
ATOM   1080  O   GLU A 149      61.367  31.223  83.186  1.00 32.91           O  
ATOM   1081  CB  GLU A 149      60.533  34.384  83.645  1.00 34.02           C  
ATOM   1082  CG  GLU A 149      61.082  35.656  84.276  1.00 34.16           C  
ATOM   1083  CD  GLU A 149      60.017  36.649  84.707  1.00 35.21           C  
ATOM   1084  OE1 GLU A 149      58.816  36.378  84.524  1.00 36.24           O  
ATOM   1085  OE2 GLU A 149      60.391  37.734  85.205  1.00 36.60           O  
ATOM   1086  N   ARG A 150      60.254  32.136  81.457  1.00 33.35           N  
ATOM   1087  CA  ARG A 150      59.748  30.887  80.924  1.00 33.74           C  
ATOM   1088  C   ARG A 150      60.884  29.953  80.478  1.00 33.52           C  
ATOM   1089  O   ARG A 150      60.903  28.766  80.816  1.00 33.32           O  
ATOM   1090  CB  ARG A 150      58.840  31.251  79.760  1.00 34.42           C  
ATOM   1091  CG  ARG A 150      58.378  30.163  78.887  1.00 36.38           C  
ATOM   1092  CD  ARG A 150      57.099  30.646  78.217  1.00 39.52           C  
ATOM   1093  NE  ARG A 150      56.437  29.560  77.531  1.00 42.76           N  
ATOM   1094  CZ  ARG A 150      55.225  29.096  77.794  1.00 40.98           C  
ATOM   1095  NH1 ARG A 150      54.440  29.630  78.734  1.00 40.58           N  
ATOM   1096  NH2 ARG A 150      54.786  28.097  77.058  1.00 43.33           N  
ATOM   1097  N   ILE A 151      61.819  30.500  79.718  1.00 33.25           N  
ATOM   1098  CA  ILE A 151      62.982  29.740  79.259  1.00 33.19           C  
ATOM   1099  C   ILE A 151      63.852  29.336  80.453  1.00 32.89           C  
ATOM   1100  O   ILE A 151      64.336  28.210  80.512  1.00 32.72           O  
ATOM   1101  CB  ILE A 151      63.820  30.525  78.224  1.00 33.44           C  
ATOM   1102  CG1 ILE A 151      63.051  30.663  76.907  1.00 32.79           C  
ATOM   1103  CG2 ILE A 151      65.145  29.825  77.974  1.00 33.42           C  
ATOM   1104  CD1 ILE A 151      63.664  31.653  75.943  1.00 33.43           C  
ATOM   1105  N   GLU A 152      64.031  30.244  81.407  1.00 32.94           N  
ATOM   1106  CA  GLU A 152      64.788  29.934  82.621  1.00 33.27           C  
ATOM   1107  C   GLU A 152      64.179  28.753  83.387  1.00 33.15           C  
ATOM   1108  O   GLU A 152      64.898  27.854  83.827  1.00 32.76           O  
ATOM   1109  CB  GLU A 152      64.870  31.159  83.535  1.00 33.28           C  
ATOM   1110  CG  GLU A 152      65.696  30.922  84.791  1.00 33.98           C  
ATOM   1111  CD  GLU A 152      65.785  32.127  85.700  1.00 34.59           C  
ATOM   1112  OE1 GLU A 152      64.812  32.915  85.771  1.00 35.40           O  
ATOM   1113  OE2 GLU A 152      66.838  32.272  86.363  1.00 37.72           O  
ATOM   1114  N   PHE A 153      62.859  28.760  83.557  1.00 32.72           N  
ATOM   1115  CA  PHE A 153      62.210  27.673  84.267  1.00 32.91           C  
ATOM   1116  C   PHE A 153      62.351  26.360  83.497  1.00 33.09           C  
ATOM   1117  O   PHE A 153      62.643  25.322  84.079  1.00 32.51           O  
ATOM   1118  CB  PHE A 153      60.730  27.950  84.525  1.00 32.73           C  
ATOM   1119  CG  PHE A 153      60.027  26.786  85.142  1.00 32.02           C  
ATOM   1120  CD1 PHE A 153      60.163  26.531  86.495  1.00 31.29           C  
ATOM   1121  CD2 PHE A 153      59.307  25.901  84.366  1.00 32.73           C  
ATOM   1122  CE1 PHE A 153      59.565  25.439  87.075  1.00 32.07           C  
ATOM   1123  CE2 PHE A 153      58.707  24.805  84.939  1.00 32.71           C  
ATOM   1124  CZ  PHE A 153      58.830  24.575  86.298  1.00 31.94           C  
ATOM   1125  N   SER A 154      62.119  26.409  82.190  1.00 33.18           N  
ATOM   1126  CA  SER A 154      62.199  25.213  81.363  1.00 33.80           C  
ATOM   1127  C   SER A 154      63.549  24.517  81.523  1.00 33.82           C  
ATOM   1128  O   SER A 154      63.622  23.290  81.654  1.00 34.16           O  
ATOM   1129  CB  SER A 154      61.987  25.572  79.902  1.00 34.25           C  
ATOM   1130  OG  SER A 154      61.998  24.405  79.113  1.00 36.00           O  
ATOM   1131  N   GLU A 155      64.614  25.310  81.536  1.00 33.61           N  
ATOM   1132  CA  GLU A 155      65.956  24.768  81.645  1.00 34.07           C  
ATOM   1133  C   GLU A 155      66.170  24.151  83.023  1.00 33.70           C  
ATOM   1134  O   GLU A 155      66.717  23.054  83.129  1.00 33.77           O  
ATOM   1135  CB  GLU A 155      66.981  25.850  81.328  1.00 34.05           C  
ATOM   1136  CG  GLU A 155      66.930  26.247  79.855  1.00 35.65           C  
ATOM   1137  CD  GLU A 155      67.923  27.319  79.477  1.00 36.27           C  
ATOM   1138  OE1 GLU A 155      68.388  28.059  80.376  1.00 40.95           O  
ATOM   1139  OE2 GLU A 155      68.232  27.423  78.270  1.00 39.51           O  
ATOM   1140  N   LEU A 156      65.714  24.835  84.068  1.00 33.46           N  
ATOM   1141  CA  LEU A 156      65.784  24.290  85.422  1.00 33.70           C  
ATOM   1142  C   LEU A 156      64.962  23.003  85.529  1.00 33.46           C  
ATOM   1143  O   LEU A 156      65.402  22.016  86.115  1.00 33.41           O  
ATOM   1144  CB  LEU A 156      65.283  25.308  86.439  1.00 33.61           C  
ATOM   1145  CG  LEU A 156      65.297  24.871  87.906  1.00 34.02           C  
ATOM   1146  CD1 LEU A 156      66.732  24.718  88.447  1.00 33.92           C  
ATOM   1147  CD2 LEU A 156      64.487  25.860  88.740  1.00 34.84           C  
ATOM   1148  N   ASP A 157      63.765  23.018  84.955  1.00 33.43           N  
ATOM   1149  CA  ASP A 157      62.871  21.874  85.055  1.00 33.77           C  
ATOM   1150  C   ASP A 157      63.513  20.621  84.476  1.00 33.91           C  
ATOM   1151  O   ASP A 157      63.357  19.532  85.019  1.00 34.03           O  
ATOM   1152  CB  ASP A 157      61.558  22.158  84.338  1.00 33.33           C  
ATOM   1153  CG  ASP A 157      60.552  21.050  84.518  1.00 34.17           C  
ATOM   1154  OD1 ASP A 157      60.294  20.636  85.667  1.00 32.78           O  
ATOM   1155  OD2 ASP A 157      60.009  20.599  83.500  1.00 34.72           O  
ATOM   1156  N   LYS A 158      64.227  20.774  83.369  1.00 34.27           N  
ATOM   1157  CA  LYS A 158      64.907  19.636  82.758  1.00 34.86           C  
ATOM   1158  C   LYS A 158      65.963  19.066  83.702  1.00 34.88           C  
ATOM   1159  O   LYS A 158      66.130  17.852  83.792  1.00 34.57           O  
ATOM   1160  CB  LYS A 158      65.537  20.033  81.426  1.00 35.37           C  
ATOM   1161  CG  LYS A 158      64.502  20.343  80.347  1.00 36.64           C  
ATOM   1162  CD  LYS A 158      65.153  20.924  79.103  1.00 36.51           C  
ATOM   1163  CE  LYS A 158      64.199  21.823  78.329  1.00 37.79           C  
ATOM   1164  NZ  LYS A 158      64.958  22.671  77.365  1.00 39.40           N  
ATOM   1165  N   LYS A 159      66.665  19.948  84.408  1.00 34.68           N  
ATOM   1166  CA  LYS A 159      67.686  19.523  85.366  1.00 34.73           C  
ATOM   1167  C   LYS A 159      67.103  18.889  86.635  1.00 34.55           C  
ATOM   1168  O   LYS A 159      67.617  17.871  87.099  1.00 34.67           O  
ATOM   1169  CB  LYS A 159      68.585  20.703  85.745  1.00 34.65           C  
ATOM   1170  CG  LYS A 159      69.379  21.245  84.581  1.00 35.23           C  
ATOM   1171  CD  LYS A 159      70.473  22.191  85.027  1.00 35.22           C  
ATOM   1172  CE  LYS A 159      71.241  22.720  83.826  1.00 35.52           C  
ATOM   1173  NZ  LYS A 159      72.540  23.331  84.197  1.00 36.68           N  
ATOM   1174  N   GLU A 160      66.054  19.483  87.194  1.00 34.51           N  
ATOM   1175  CA  GLU A 160      65.509  19.043  88.487  1.00 34.89           C  
ATOM   1176  C   GLU A 160      64.272  18.145  88.389  1.00 34.85           C  
ATOM   1177  O   GLU A 160      63.799  17.644  89.408  1.00 35.08           O  
ATOM   1178  CB  GLU A 160      65.215  20.251  89.388  1.00 35.19           C  
ATOM   1179  CG  GLU A 160      66.474  20.894  89.950  1.00 36.27           C  
ATOM   1180  CD  GLU A 160      66.229  21.961  91.020  1.00 36.24           C  
ATOM   1181  OE1 GLU A 160      65.066  22.206  91.400  1.00 38.04           O  
ATOM   1182  OE2 GLU A 160      67.229  22.561  91.484  1.00 39.60           O  
ATOM   1183  N   LYS A 161      63.749  17.957  87.181  1.00 34.54           N  
ATOM   1184  CA  LYS A 161      62.514  17.190  86.965  1.00 34.91           C  
ATOM   1185  C   LYS A 161      61.404  17.633  87.909  1.00 33.98           C  
ATOM   1186  O   LYS A 161      60.743  16.816  88.557  1.00 33.77           O  
ATOM   1187  CB  LYS A 161      62.772  15.690  87.101  1.00 35.14           C  
ATOM   1188  CG  LYS A 161      63.840  15.186  86.162  1.00 36.48           C  
ATOM   1189  CD  LYS A 161      63.678  13.714  85.816  1.00 37.45           C  
ATOM   1190  CE  LYS A 161      63.790  12.823  87.039  1.00 39.22           C  
ATOM   1191  NZ  LYS A 161      64.095  11.413  86.652  1.00 39.95           N  
ATOM   1192  N   ILE A 162      61.191  18.942  87.962  1.00 33.20           N  
ATOM   1193  CA  ILE A 162      60.226  19.532  88.877  1.00 33.01           C  
ATOM   1194  C   ILE A 162      58.803  19.083  88.531  1.00 32.99           C  
ATOM   1195  O   ILE A 162      58.079  18.583  89.395  1.00 32.70           O  
ATOM   1196  CB  ILE A 162      60.316  21.086  88.867  1.00 32.93           C  
ATOM   1197  CG1 ILE A 162      61.703  21.547  89.317  1.00 32.70           C  
ATOM   1198  CG2 ILE A 162      59.240  21.699  89.763  1.00 33.15           C  
ATOM   1199  CD1 ILE A 162      61.960  23.030  89.103  1.00 33.18           C  
ATOM   1200  N   ARG A 163      58.391  19.252  87.279  1.00 32.67           N  
ATOM   1201  CA  ARG A 163      57.026  18.866  86.905  1.00 33.08           C  
ATOM   1202  C   ARG A 163      56.850  17.339  86.986  1.00 32.97           C  
ATOM   1203  O   ARG A 163      55.809  16.847  87.406  1.00 33.05           O  
ATOM   1204  CB  ARG A 163      56.683  19.341  85.498  1.00 33.01           C  
ATOM   1205  CG  ARG A 163      56.633  20.860  85.336  1.00 33.08           C  
ATOM   1206  CD  ARG A 163      56.265  21.216  83.905  1.00 34.46           C  
ATOM   1207  NE  ARG A 163      57.314  20.835  82.965  1.00 34.55           N  
ATOM   1208  CZ  ARG A 163      57.129  20.545  81.681  1.00 36.90           C  
ATOM   1209  NH1 ARG A 163      55.918  20.573  81.149  1.00 37.07           N  
ATOM   1210  NH2 ARG A 163      58.167  20.211  80.917  1.00 38.93           N  
ATOM   1211  N   GLU A 164      57.879  16.602  86.584  1.00 33.17           N  
ATOM   1212  CA  GLU A 164      57.809  15.144  86.579  1.00 33.58           C  
ATOM   1213  C   GLU A 164      57.601  14.584  87.991  1.00 33.44           C  
ATOM   1214  O   GLU A 164      56.757  13.701  88.203  1.00 33.77           O  
ATOM   1215  CB  GLU A 164      59.060  14.555  85.935  1.00 33.38           C  
ATOM   1216  CG  GLU A 164      59.007  13.063  85.699  1.00 34.58           C  
ATOM   1217  CD  GLU A 164      60.205  12.564  84.918  1.00 35.56           C  
ATOM   1218  OE1 GLU A 164      60.533  13.165  83.869  1.00 38.37           O  
ATOM   1219  OE2 GLU A 164      60.817  11.577  85.356  1.00 38.12           O  
ATOM   1220  N   LYS A 165      58.350  15.107  88.953  1.00 32.97           N  
ATOM   1221  CA  LYS A 165      58.218  14.681  90.346  1.00 33.18           C  
ATOM   1222  C   LYS A 165      56.861  15.062  90.943  1.00 32.05           C  
ATOM   1223  O   LYS A 165      56.276  14.306  91.732  1.00 31.56           O  
ATOM   1224  CB  LYS A 165      59.339  15.279  91.179  1.00 33.31           C  
ATOM   1225  CG  LYS A 165      60.671  14.622  90.927  1.00 34.93           C  
ATOM   1226  CD  LYS A 165      61.802  15.340  91.667  1.00 36.31           C  
ATOM   1227  CE  LYS A 165      61.814  15.011  93.161  1.00 38.77           C  
ATOM   1228  NZ  LYS A 165      62.378  13.665  93.450  1.00 40.59           N  
ATOM   1229  N   PHE A 166      56.370  16.236  90.558  1.00 31.70           N  
ATOM   1230  CA  PHE A 166      55.078  16.754  91.023  1.00 31.73           C  
ATOM   1231  C   PHE A 166      53.978  15.818  90.496  1.00 31.38           C  
ATOM   1232  O   PHE A 166      53.078  15.407  91.236  1.00 30.81           O  
ATOM   1233  CB  PHE A 166      54.915  18.189  90.467  1.00 31.84           C  
ATOM   1234  CG  PHE A 166      53.821  19.034  91.109  1.00 31.26           C  
ATOM   1235  CD1 PHE A 166      52.852  18.510  91.945  1.00 32.29           C  
ATOM   1236  CD2 PHE A 166      53.774  20.392  90.828  1.00 32.40           C  
ATOM   1237  CE1 PHE A 166      51.865  19.309  92.479  1.00 30.07           C  
ATOM   1238  CE2 PHE A 166      52.789  21.197  91.353  1.00 31.83           C  
ATOM   1239  CZ  PHE A 166      51.826  20.657  92.187  1.00 31.69           C  
ATOM   1240  N   VAL A 167      54.057  15.479  89.214  1.00 31.24           N  
ATOM   1241  CA  VAL A 167      53.064  14.594  88.596  1.00 31.31           C  
ATOM   1242  C   VAL A 167      53.096  13.184  89.207  1.00 31.15           C  
ATOM   1243  O   VAL A 167      52.049  12.592  89.445  1.00 31.42           O  
ATOM   1244  CB  VAL A 167      53.237  14.535  87.069  1.00 31.25           C  
ATOM   1245  CG1 VAL A 167      52.343  13.441  86.456  1.00 31.52           C  
ATOM   1246  CG2 VAL A 167      52.907  15.902  86.476  1.00 31.91           C  
ATOM   1247  N   GLU A 168      54.287  12.654  89.481  1.00 31.01           N  
ATOM   1248  CA  GLU A 168      54.382  11.364  90.173  1.00 30.75           C  
ATOM   1249  C   GLU A 168      53.619  11.368  91.500  1.00 30.64           C  
ATOM   1250  O   GLU A 168      52.876  10.423  91.798  1.00 31.54           O  
ATOM   1251  CB  GLU A 168      55.842  10.943  90.398  1.00 30.70           C  
ATOM   1252  CG  GLU A 168      56.564  10.471  89.154  1.00 30.22           C  
ATOM   1253  CD  GLU A 168      55.818   9.371  88.432  1.00 30.29           C  
ATOM   1254  OE1 GLU A 168      55.604   8.299  89.050  1.00 26.47           O  
ATOM   1255  OE2 GLU A 168      55.452   9.578  87.254  1.00 30.38           O  
ATOM   1256  N   ALA A 169      53.801  12.427  92.281  1.00 30.92           N  
ATOM   1257  CA  ALA A 169      53.185  12.548  93.608  1.00 30.65           C  
ATOM   1258  C   ALA A 169      51.672  12.661  93.487  1.00 30.23           C  
ATOM   1259  O   ALA A 169      50.923  12.065  94.267  1.00 30.35           O  
ATOM   1260  CB  ALA A 169      53.744  13.750  94.340  1.00 31.11           C  
ATOM   1261  N   LEU A 170      51.233  13.411  92.482  1.00 30.32           N  
ATOM   1262  CA  LEU A 170      49.808  13.581  92.217  1.00 30.67           C  
ATOM   1263  C   LEU A 170      49.157  12.274  91.758  1.00 30.54           C  
ATOM   1264  O   LEU A 170      48.074  11.916  92.222  1.00 31.01           O  
ATOM   1265  CB  LEU A 170      49.587  14.653  91.151  1.00 30.97           C  
ATOM   1266  CG  LEU A 170      49.574  16.102  91.617  1.00 31.41           C  
ATOM   1267  CD1 LEU A 170      49.759  17.058  90.434  1.00 31.13           C  
ATOM   1268  CD2 LEU A 170      48.296  16.406  92.371  1.00 33.63           C  
ATOM   1269  N   LYS A 171      49.777  11.580  90.810  1.00 30.30           N  
ATOM   1270  CA  LYS A 171      49.202  10.328  90.318  1.00 30.19           C  
ATOM   1271  C   LYS A 171      49.001   9.321  91.461  1.00 30.33           C  
ATOM   1272  O   LYS A 171      47.978   8.635  91.532  1.00 29.71           O  
ATOM   1273  CB  LYS A 171      50.070   9.703  89.221  1.00 30.45           C  
ATOM   1274  CG  LYS A 171      50.135  10.508  87.942  1.00 28.83           C  
ATOM   1275  CD  LYS A 171      50.852   9.767  86.830  1.00 30.02           C  
ATOM   1276  CE  LYS A 171      52.324   9.557  87.119  1.00 28.83           C  
ATOM   1277  NZ  LYS A 171      53.060   8.866  86.003  1.00 24.96           N  
ATOM   1278  N   THR A 172      49.990   9.237  92.342  1.00 30.51           N  
ATOM   1279  CA  THR A 172      49.939   8.324  93.478  1.00 30.66           C  
ATOM   1280  C   THR A 172      48.851   8.731  94.468  1.00 31.05           C  
ATOM   1281  O   THR A 172      48.074   7.882  94.925  1.00 30.68           O  
ATOM   1282  CB  THR A 172      51.304   8.243  94.176  1.00 30.59           C  
ATOM   1283  OG1 THR A 172      52.272   7.728  93.252  1.00 30.11           O  
ATOM   1284  CG2 THR A 172      51.241   7.328  95.395  1.00 30.46           C  
ATOM   1285  N   GLU A 173      48.789  10.023  94.785  1.00 31.42           N  
ATOM   1286  CA  GLU A 173      47.823  10.528  95.763  1.00 31.56           C  
ATOM   1287  C   GLU A 173      46.397  10.275  95.290  1.00 31.69           C  
ATOM   1288  O   GLU A 173      45.537   9.882  96.084  1.00 32.04           O  
ATOM   1289  CB  GLU A 173      48.036  12.020  96.020  1.00 32.36           C  
ATOM   1290  CG  GLU A 173      46.931  12.704  96.839  1.00 33.15           C  
ATOM   1291  CD  GLU A 173      46.905  12.308  98.306  1.00 37.09           C  
ATOM   1292  OE1 GLU A 173      47.805  11.583  98.780  1.00 38.58           O  
ATOM   1293  OE2 GLU A 173      45.961  12.742  98.999  1.00 40.03           O  
ATOM   1294  N   PHE A 174      46.157  10.480  93.999  1.00 31.51           N  
ATOM   1295  CA  PHE A 174      44.811  10.345  93.431  1.00 31.22           C  
ATOM   1296  C   PHE A 174      44.597   9.036  92.665  1.00 30.56           C  
ATOM   1297  O   PHE A 174      43.659   8.912  91.878  1.00 30.77           O  
ATOM   1298  CB  PHE A 174      44.508  11.585  92.587  1.00 31.46           C  
ATOM   1299  CG  PHE A 174      44.438  12.824  93.414  1.00 31.42           C  
ATOM   1300  CD1 PHE A 174      43.321  13.081  94.191  1.00 31.96           C  
ATOM   1301  CD2 PHE A 174      45.524  13.683  93.501  1.00 31.77           C  
ATOM   1302  CE1 PHE A 174      43.273  14.209  95.001  1.00 32.20           C  
ATOM   1303  CE2 PHE A 174      45.483  14.789  94.304  1.00 31.53           C  
ATOM   1304  CZ  PHE A 174      44.358  15.051  95.062  1.00 32.35           C  
ATOM   1305  N   ALA A 175      45.432   8.040  92.939  1.00 30.24           N  
ATOM   1306  CA  ALA A 175      45.302   6.721  92.317  1.00 30.55           C  
ATOM   1307  C   ALA A 175      43.872   6.200  92.395  1.00 30.76           C  
ATOM   1308  O   ALA A 175      43.267   6.174  93.470  1.00 30.57           O  
ATOM   1309  CB  ALA A 175      46.254   5.733  92.967  1.00 29.79           C  
ATOM   1310  N   GLY A 176      43.339   5.805  91.246  1.00 30.90           N  
ATOM   1311  CA  GLY A 176      41.987   5.271  91.153  1.00 31.82           C  
ATOM   1312  C   GLY A 176      40.867   6.298  91.080  1.00 32.38           C  
ATOM   1313  O   GLY A 176      39.711   5.920  90.908  1.00 33.06           O  
ATOM   1314  N   LYS A 177      41.191   7.588  91.173  1.00 32.83           N  
ATOM   1315  CA  LYS A 177      40.145   8.620  91.282  1.00 33.63           C  
ATOM   1316  C   LYS A 177      39.784   9.293  89.952  1.00 33.55           C  
ATOM   1317  O   LYS A 177      38.990  10.227  89.927  1.00 33.99           O  
ATOM   1318  CB  LYS A 177      40.518   9.638  92.359  1.00 34.41           C  
ATOM   1319  CG  LYS A 177      40.474   9.029  93.752  1.00 34.96           C  
ATOM   1320  CD  LYS A 177      40.638  10.047  94.854  1.00 36.18           C  
ATOM   1321  CE  LYS A 177      40.793   9.370  96.202  1.00 38.05           C  
ATOM   1322  NZ  LYS A 177      42.097   8.627  96.283  1.00 42.03           N  
ATOM   1323  N   GLY A 178      40.361   8.816  88.855  1.00 33.69           N  
ATOM   1324  CA  GLY A 178      39.942   9.224  87.509  1.00 33.68           C  
ATOM   1325  C   GLY A 178      40.593  10.474  86.946  1.00 33.73           C  
ATOM   1326  O   GLY A 178      39.990  11.162  86.122  1.00 33.77           O  
ATOM   1327  N   LEU A 179      41.826  10.752  87.361  1.00 33.79           N  
ATOM   1328  CA  LEU A 179      42.559  11.935  86.912  1.00 34.08           C  
ATOM   1329  C   LEU A 179      43.704  11.525  85.999  1.00 34.38           C  
ATOM   1330  O   LEU A 179      44.323  10.477  86.201  1.00 34.48           O  
ATOM   1331  CB  LEU A 179      43.109  12.716  88.110  1.00 34.29           C  
ATOM   1332  CG  LEU A 179      42.094  13.367  89.046  1.00 34.81           C  
ATOM   1333  CD1 LEU A 179      42.821  14.231  90.089  1.00 34.74           C  
ATOM   1334  CD2 LEU A 179      41.086  14.195  88.255  1.00 35.61           C  
ATOM   1335  N   ARG A 180      43.959  12.342  84.982  1.00 34.59           N  
ATOM   1336  CA  ARG A 180      45.043  12.119  84.041  1.00 35.09           C  
ATOM   1337  C   ARG A 180      45.922  13.355  83.995  1.00 35.81           C  
ATOM   1338  O   ARG A 180      45.462  14.456  84.291  1.00 34.68           O  
ATOM   1339  CB  ARG A 180      44.484  11.821  82.651  1.00 35.77           C  
ATOM   1340  CG  ARG A 180      43.539  10.626  82.613  1.00 36.98           C  
ATOM   1341  CD  ARG A 180      44.276   9.298  82.771  1.00 39.32           C  
ATOM   1342  NE  ARG A 180      43.357   8.149  82.862  1.00 40.58           N  
ATOM   1343  CZ  ARG A 180      42.933   7.578  83.995  1.00 41.11           C  
ATOM   1344  NH1 ARG A 180      43.322   8.012  85.195  1.00 41.45           N  
ATOM   1345  NH2 ARG A 180      42.099   6.554  83.930  1.00 40.64           N  
ATOM   1346  N   PHE A 181      47.178  13.163  83.613  1.00 36.93           N  
ATOM   1347  CA  PHE A 181      48.159  14.247  83.619  1.00 38.34           C  
ATOM   1348  C   PHE A 181      48.948  14.250  82.307  1.00 39.12           C  
ATOM   1349  O   PHE A 181      49.236  13.192  81.742  1.00 39.67           O  
ATOM   1350  CB  PHE A 181      49.097  14.099  84.819  1.00 38.22           C  
ATOM   1351  CG  PHE A 181      48.378  13.967  86.135  1.00 37.84           C  
ATOM   1352  CD1 PHE A 181      48.177  15.071  86.942  1.00 38.86           C  
ATOM   1353  CD2 PHE A 181      47.877  12.741  86.548  1.00 37.86           C  
ATOM   1354  CE1 PHE A 181      47.496  14.951  88.145  1.00 38.12           C  
ATOM   1355  CE2 PHE A 181      47.194  12.617  87.748  1.00 37.12           C  
ATOM   1356  CZ  PHE A 181      47.004  13.722  88.543  1.00 38.45           C  
ATOM   1357  N   SER A 182      49.266  15.436  81.803  1.00 39.79           N  
ATOM   1358  CA  SER A 182      50.133  15.563  80.637  1.00 40.50           C  
ATOM   1359  C   SER A 182      51.083  16.743  80.816  1.00 41.01           C  
ATOM   1360  O   SER A 182      50.687  17.775  81.340  1.00 40.24           O  
ATOM   1361  CB  SER A 182      49.313  15.731  79.357  1.00 41.00           C  
ATOM   1362  OG  SER A 182      48.460  16.867  79.418  1.00 43.21           O  
ATOM   1363  N   ARG A 183      52.331  16.571  80.383  1.00 41.80           N  
ATOM   1364  CA  ARG A 183      53.359  17.622  80.462  1.00 42.10           C  
ATOM   1365  C   ARG A 183      53.593  18.184  79.061  1.00 42.39           C  
ATOM   1366  O   ARG A 183      54.733  18.278  78.587  1.00 42.59           O  
ATOM   1367  CB  ARG A 183      54.665  17.056  81.044  1.00 42.64           C  
ATOM   1368  CG  ARG A 183      54.646  16.800  82.559  1.00 43.66           C  
ATOM   1369  CD  ARG A 183      55.641  15.888  82.611  0.00 20.00           C  
ATOM   1370  NE  ARG A 183      55.760  14.592  81.951  0.00 20.00           N  
ATOM   1371  CZ  ARG A 183      56.845  13.831  81.993  0.00 20.00           C  
ATOM   1372  NH1 ARG A 183      57.913  14.232  82.670  0.00 20.00           N  
ATOM   1373  NH2 ARG A 183      56.865  12.665  81.361  0.00 20.00           N  
ATOM   1374  N   GLY A 184      52.502  18.563  78.400  1.00 42.33           N  
ATOM   1375  CA  GLY A 184      52.560  19.040  77.025  1.00 41.84           C  
ATOM   1376  C   GLY A 184      53.265  20.374  76.908  1.00 41.49           C  
ATOM   1377  O   GLY A 184      53.982  20.630  75.934  1.00 41.77           O  
ATOM   1378  N   GLY A 185      53.068  21.220  77.910  1.00 40.29           N  
ATOM   1379  CA  GLY A 185      53.623  22.557  77.897  1.00 39.69           C  
ATOM   1380  C   GLY A 185      55.068  22.586  78.327  1.00 38.74           C  
ATOM   1381  O   GLY A 185      55.718  21.552  78.430  1.00 39.27           O  
HETATM 1382  N   MSE A 186      55.546  23.798  78.574  1.00 38.01           N  
HETATM 1383  CA  MSE A 186      56.925  24.032  78.959  0.50 37.13           C  
HETATM 1385  C   MSE A 186      57.044  24.421  80.433  1.00 36.88           C  
HETATM 1386  O   MSE A 186      57.979  23.995  81.118  1.00 37.06           O  
HETATM 1387  CB  MSE A 186      57.489  25.134  78.077  0.50 37.23           C  
HETATM 1389  CG  MSE A 186      58.904  25.521  78.385  0.50 37.47           C  
HETATM 1391 SE   MSE A 186      59.407  27.007  77.275  0.50 37.87          SE  
HETATM 1393  CE  MSE A 186      59.865  26.049  75.638  0.50 38.00           C  
ATOM   1395  N   ILE A 187      56.105  25.232  80.918  1.00 35.11           N  
ATOM   1396  CA  ILE A 187      56.161  25.731  82.292  1.00 34.44           C  
ATOM   1397  C   ILE A 187      55.088  25.110  83.180  1.00 33.48           C  
ATOM   1398  O   ILE A 187      54.915  25.519  84.330  1.00 33.16           O  
ATOM   1399  CB  ILE A 187      56.054  27.287  82.345  1.00 33.51           C  
ATOM   1400  CG1 ILE A 187      54.668  27.779  81.913  1.00 32.89           C  
ATOM   1401  CG2 ILE A 187      57.152  27.917  81.496  1.00 34.50           C  
ATOM   1402  CD1 ILE A 187      54.407  29.264  82.195  1.00 32.60           C  
ATOM   1403  N   SER A 188      54.382  24.109  82.655  1.00 32.92           N  
ATOM   1404  CA  SER A 188      53.194  23.591  83.319  1.00 32.69           C  
ATOM   1405  C   SER A 188      52.910  22.152  82.958  1.00 32.52           C  
ATOM   1406  O   SER A 188      53.512  21.597  82.048  1.00 31.78           O  
ATOM   1407  CB  SER A 188      51.969  24.433  82.908  1.00 32.57           C  
ATOM   1408  OG  SER A 188      51.667  24.226  81.527  1.00 33.16           O  
ATOM   1409  N   PHE A 189      51.952  21.558  83.668  1.00 32.22           N  
ATOM   1410  CA  PHE A 189      51.342  20.312  83.232  1.00 32.60           C  
ATOM   1411  C   PHE A 189      49.835  20.439  83.379  1.00 33.03           C  
ATOM   1412  O   PHE A 189      49.354  21.260  84.156  1.00 33.04           O  
ATOM   1413  CB  PHE A 189      51.886  19.111  84.020  1.00 32.16           C  
ATOM   1414  CG  PHE A 189      51.719  19.223  85.503  1.00 32.05           C  
ATOM   1415  CD1 PHE A 189      52.715  19.775  86.290  1.00 32.76           C  
ATOM   1416  CD2 PHE A 189      50.556  18.771  86.122  1.00 32.02           C  
ATOM   1417  CE1 PHE A 189      52.554  19.874  87.671  1.00 32.63           C  
ATOM   1418  CE2 PHE A 189      50.390  18.865  87.505  1.00 33.41           C  
ATOM   1419  CZ  PHE A 189      51.385  19.421  88.276  1.00 33.47           C  
ATOM   1420  N   ASP A 190      49.086  19.661  82.604  1.00 33.36           N  
ATOM   1421  CA  ASP A 190      47.626  19.706  82.694  1.00 33.54           C  
ATOM   1422  C   ASP A 190      47.069  18.502  83.430  1.00 32.60           C  
ATOM   1423  O   ASP A 190      47.583  17.402  83.296  1.00 32.98           O  
ATOM   1424  CB  ASP A 190      47.011  19.792  81.310  1.00 34.76           C  
ATOM   1425  CG  ASP A 190      47.486  21.026  80.545  1.00 38.55           C  
ATOM   1426  OD1 ASP A 190      46.837  22.086  80.716  1.00 44.85           O  
ATOM   1427  OD2 ASP A 190      48.492  20.949  79.807  1.00 42.79           O  
ATOM   1428  N   VAL A 191      46.020  18.747  84.210  1.00 31.30           N  
ATOM   1429  CA  VAL A 191      45.296  17.721  84.942  1.00 30.78           C  
ATOM   1430  C   VAL A 191      43.881  17.686  84.401  1.00 31.01           C  
ATOM   1431  O   VAL A 191      43.174  18.699  84.397  1.00 30.71           O  
ATOM   1432  CB  VAL A 191      45.231  18.026  86.448  1.00 30.63           C  
ATOM   1433  CG1 VAL A 191      44.596  16.847  87.195  1.00 29.64           C  
ATOM   1434  CG2 VAL A 191      46.636  18.342  86.983  1.00 30.77           C  
ATOM   1435  N   PHE A 192      43.474  16.530  83.910  1.00 31.23           N  
ATOM   1436  CA  PHE A 192      42.159  16.418  83.310  1.00 31.65           C  
ATOM   1437  C   PHE A 192      41.499  15.096  83.677  1.00 31.48           C  
ATOM   1438  O   PHE A 192      42.182  14.138  84.047  1.00 31.08           O  
ATOM   1439  CB  PHE A 192      42.234  16.619  81.789  1.00 32.61           C  
ATOM   1440  CG  PHE A 192      43.175  15.685  81.080  1.00 33.02           C  
ATOM   1441  CD1 PHE A 192      44.536  15.960  81.006  1.00 33.82           C  
ATOM   1442  CD2 PHE A 192      42.696  14.538  80.460  1.00 34.08           C  
ATOM   1443  CE1 PHE A 192      45.396  15.102  80.333  1.00 34.18           C  
ATOM   1444  CE2 PHE A 192      43.545  13.688  79.784  1.00 34.33           C  
ATOM   1445  CZ  PHE A 192      44.903  13.967  79.722  1.00 34.68           C  
ATOM   1446  N   PRO A 193      40.155  15.057  83.629  1.00 31.60           N  
ATOM   1447  CA  PRO A 193      39.451  13.824  83.923  1.00 31.72           C  
ATOM   1448  C   PRO A 193      39.741  12.751  82.889  1.00 32.07           C  
ATOM   1449  O   PRO A 193      39.919  13.051  81.704  1.00 31.27           O  
ATOM   1450  CB  PRO A 193      37.978  14.231  83.836  1.00 31.94           C  
ATOM   1451  CG  PRO A 193      37.972  15.702  83.981  1.00 31.15           C  
ATOM   1452  CD  PRO A 193      39.217  16.150  83.326  1.00 31.60           C  
ATOM   1453  N   GLU A 194      39.753  11.499  83.326  1.00 32.59           N  
ATOM   1454  CA  GLU A 194      39.906  10.398  82.389  1.00 33.44           C  
ATOM   1455  C   GLU A 194      38.850  10.534  81.282  1.00 32.87           C  
ATOM   1456  O   GLU A 194      37.690  10.877  81.548  1.00 32.68           O  
ATOM   1457  CB  GLU A 194      39.835   9.040  83.106  1.00 33.91           C  
ATOM   1458  CG  GLU A 194      38.571   8.782  83.904  1.00 35.87           C  
ATOM   1459  CD  GLU A 194      38.509   7.368  84.467  1.00 36.76           C  
ATOM   1460  OE1 GLU A 194      39.533   6.870  84.984  1.00 42.25           O  
ATOM   1461  OE2 GLU A 194      37.427   6.752  84.407  1.00 42.65           O  
ATOM   1462  N   GLY A 195      39.284  10.309  80.044  1.00 32.40           N  
ATOM   1463  CA  GLY A 195      38.442  10.457  78.858  1.00 32.27           C  
ATOM   1464  C   GLY A 195      38.337  11.863  78.290  1.00 31.89           C  
ATOM   1465  O   GLY A 195      37.649  12.068  77.286  1.00 31.82           O  
ATOM   1466  N   TRP A 196      38.992  12.839  78.926  1.00 31.48           N  
ATOM   1467  CA  TRP A 196      38.968  14.224  78.438  1.00 31.55           C  
ATOM   1468  C   TRP A 196      40.199  14.544  77.595  1.00 31.72           C  
ATOM   1469  O   TRP A 196      40.576  15.712  77.414  1.00 31.99           O  
ATOM   1470  CB  TRP A 196      38.809  15.203  79.599  1.00 31.29           C  
ATOM   1471  CG  TRP A 196      37.422  15.203  80.168  1.00 30.14           C  
ATOM   1472  CD1 TRP A 196      36.574  14.142  80.279  1.00 30.84           C  
ATOM   1473  CD2 TRP A 196      36.729  16.326  80.708  1.00 30.98           C  
ATOM   1474  NE1 TRP A 196      35.392  14.537  80.846  1.00 31.13           N  
ATOM   1475  CE2 TRP A 196      35.465  15.872  81.133  1.00 29.43           C  
ATOM   1476  CE3 TRP A 196      37.058  17.674  80.885  1.00 29.31           C  
ATOM   1477  CZ2 TRP A 196      34.526  16.720  81.710  1.00 31.15           C  
ATOM   1478  CZ3 TRP A 196      36.125  18.512  81.460  1.00 31.23           C  
ATOM   1479  CH2 TRP A 196      34.874  18.031  81.870  1.00 30.35           C  
ATOM   1480  N   ASP A 197      40.827  13.479  77.104  1.00 31.68           N  
ATOM   1481  CA  ASP A 197      41.735  13.544  75.966  1.00 32.15           C  
ATOM   1482  C   ASP A 197      40.884  13.855  74.735  1.00 31.98           C  
ATOM   1483  O   ASP A 197      39.691  14.120  74.860  1.00 31.13           O  
ATOM   1484  CB  ASP A 197      42.472  12.208  75.815  1.00 31.88           C  
ATOM   1485  CG  ASP A 197      41.526  11.029  75.723  1.00 32.85           C  
ATOM   1486  OD1 ASP A 197      40.920  10.824  74.654  1.00 32.09           O  
ATOM   1487  OD2 ASP A 197      41.376  10.300  76.725  1.00 35.42           O  
ATOM   1488  N   LYS A 198      41.480  13.806  73.549  1.00 33.16           N  
ATOM   1489  CA  LYS A 198      40.762  14.195  72.321  1.00 33.33           C  
ATOM   1490  C   LYS A 198      39.506  13.362  72.050  1.00 34.02           C  
ATOM   1491  O   LYS A 198      38.622  13.794  71.306  1.00 34.59           O  
ATOM   1492  CB  LYS A 198      41.685  14.131  71.100  1.00 33.75           C  
ATOM   1493  CG  LYS A 198      42.691  15.264  70.982  1.00 33.74           C  
ATOM   1494  CD  LYS A 198      43.310  15.291  69.564  1.00 33.86           C  
ATOM   1495  CE  LYS A 198      44.159  16.513  69.286  1.00 36.35           C  
ATOM   1496  NZ  LYS A 198      45.545  16.404  69.822  1.00 36.55           N  
ATOM   1497  N   ARG A 199      39.405  12.172  72.642  1.00 33.84           N  
ATOM   1498  CA  ARG A 199      38.194  11.358  72.444  1.00 33.85           C  
ATOM   1499  C   ARG A 199      36.928  12.074  72.880  1.00 33.42           C  
ATOM   1500  O   ARG A 199      35.838  11.725  72.438  1.00 32.50           O  
ATOM   1501  CB  ARG A 199      38.257  10.053  73.221  1.00 34.20           C  
ATOM   1502  CG  ARG A 199      39.106   8.988  72.598  1.00 35.21           C  
ATOM   1503  CD  ARG A 199      39.132   7.770  73.501  1.00 35.74           C  
ATOM   1504  NE  ARG A 199      39.704   8.067  74.811  1.00 37.50           N  
ATOM   1505  CZ  ARG A 199      39.848   7.184  75.798  1.00 38.55           C  
ATOM   1506  NH1 ARG A 199      39.456   5.928  75.640  1.00 39.06           N  
ATOM   1507  NH2 ARG A 199      40.385   7.556  76.957  1.00 39.26           N  
ATOM   1508  N   TYR A 200      37.064  13.048  73.775  1.00 33.33           N  
ATOM   1509  CA  TYR A 200      35.896  13.757  74.302  1.00 33.22           C  
ATOM   1510  C   TYR A 200      34.960  14.233  73.189  1.00 32.90           C  
ATOM   1511  O   TYR A 200      33.743  14.148  73.320  1.00 32.80           O  
ATOM   1512  CB  TYR A 200      36.327  14.952  75.165  1.00 33.80           C  
ATOM   1513  CG  TYR A 200      35.170  15.603  75.878  1.00 33.35           C  
ATOM   1514  CD1 TYR A 200      34.805  15.214  77.158  1.00 34.38           C  
ATOM   1515  CD2 TYR A 200      34.406  16.583  75.250  1.00 34.94           C  
ATOM   1516  CE1 TYR A 200      33.720  15.794  77.805  1.00 34.23           C  
ATOM   1517  CE2 TYR A 200      33.315  17.164  75.888  1.00 33.61           C  
ATOM   1518  CZ  TYR A 200      32.983  16.769  77.159  1.00 34.99           C  
ATOM   1519  OH  TYR A 200      31.914  17.355  77.798  1.00 35.66           O  
ATOM   1520  N   CYS A 201      35.531  14.733  72.099  1.00 32.92           N  
ATOM   1521  CA  CYS A 201      34.730  15.300  71.013  1.00 33.40           C  
ATOM   1522  C   CYS A 201      33.875  14.267  70.269  1.00 33.20           C  
ATOM   1523  O   CYS A 201      32.898  14.633  69.611  1.00 32.09           O  
ATOM   1524  CB  CYS A 201      35.623  16.037  70.022  1.00 33.45           C  
ATOM   1525  SG  CYS A 201      36.625  15.029  68.940  1.00 34.74           S  
ATOM   1526  N   LEU A 202      34.254  12.996  70.375  1.00 33.43           N  
ATOM   1527  CA  LEU A 202      33.591  11.923  69.635  1.00 33.68           C  
ATOM   1528  C   LEU A 202      32.163  11.651  70.100  1.00 34.05           C  
ATOM   1529  O   LEU A 202      31.350  11.171  69.320  1.00 34.44           O  
ATOM   1530  CB  LEU A 202      34.411  10.633  69.712  1.00 33.18           C  
ATOM   1531  CG  LEU A 202      35.782  10.657  69.045  1.00 33.26           C  
ATOM   1532  CD1 LEU A 202      36.461   9.295  69.206  1.00 33.40           C  
ATOM   1533  CD2 LEU A 202      35.668  11.063  67.567  1.00 33.27           C  
ATOM   1534  N   ASP A 203      31.854  11.935  71.362  1.00 35.14           N  
ATOM   1535  CA  ASP A 203      30.495  11.713  71.855  1.00 35.62           C  
ATOM   1536  C   ASP A 203      29.486  12.645  71.184  1.00 35.79           C  
ATOM   1537  O   ASP A 203      28.393  12.215  70.810  1.00 36.08           O  
ATOM   1538  CB  ASP A 203      30.444  11.841  73.376  1.00 36.53           C  
ATOM   1539  CG  ASP A 203      31.179  10.712  74.071  1.00 37.99           C  
ATOM   1540  OD1 ASP A 203      30.768   9.541  73.891  1.00 40.62           O  
ATOM   1541  OD2 ASP A 203      32.162  10.996  74.788  1.00 40.82           O  
ATOM   1542  N   SER A 204      29.851  13.914  71.001  1.00 35.92           N  
ATOM   1543  CA  SER A 204      28.987  14.830  70.257  1.00 35.95           C  
ATOM   1544  C   SER A 204      28.891  14.408  68.801  1.00 36.26           C  
ATOM   1545  O   SER A 204      27.807  14.420  68.218  1.00 36.85           O  
ATOM   1546  CB  SER A 204      29.479  16.280  70.336  1.00 36.05           C  
ATOM   1547  OG  SER A 204      28.495  17.144  69.774  1.00 36.96           O  
ATOM   1548  N   LEU A 205      30.021  14.015  68.220  1.00 36.31           N  
ATOM   1549  CA  LEU A 205      30.063  13.640  66.807  1.00 36.60           C  
ATOM   1550  C   LEU A 205      29.223  12.398  66.516  1.00 37.00           C  
ATOM   1551  O   LEU A 205      28.618  12.300  65.448  1.00 37.42           O  
ATOM   1552  CB  LEU A 205      31.501  13.439  66.345  1.00 36.35           C  
ATOM   1553  CG  LEU A 205      32.317  14.730  66.234  1.00 35.82           C  
ATOM   1554  CD1 LEU A 205      33.761  14.419  65.891  1.00 36.38           C  
ATOM   1555  CD2 LEU A 205      31.707  15.684  65.196  1.00 34.67           C  
ATOM   1556  N   ASP A 206      29.177  11.477  67.480  1.00 37.25           N  
ATOM   1557  CA  ASP A 206      28.305  10.283  67.426  1.00 38.01           C  
ATOM   1558  C   ASP A 206      26.865  10.587  67.067  1.00 37.45           C  
ATOM   1559  O   ASP A 206      26.160   9.742  66.509  1.00 38.46           O  
ATOM   1560  CB  ASP A 206      28.278   9.581  68.789  1.00 38.54           C  
ATOM   1561  CG  ASP A 206      29.300   8.492  68.905  1.00 42.07           C  
ATOM   1562  OD1 ASP A 206      29.707   7.950  67.846  1.00 46.93           O  
ATOM   1563  OD2 ASP A 206      29.665   8.156  70.062  1.00 44.38           O  
ATOM   1564  N   GLN A 207      26.416  11.784  67.429  1.00 36.72           N  
ATOM   1565  CA  GLN A 207      25.030  12.167  67.233  1.00 36.44           C  
ATOM   1566  C   GLN A 207      24.783  12.816  65.865  1.00 36.37           C  
ATOM   1567  O   GLN A 207      23.637  13.069  65.516  1.00 36.38           O  
ATOM   1568  CB  GLN A 207      24.605  13.139  68.346  1.00 36.55           C  
ATOM   1569  CG  GLN A 207      24.499  12.507  69.740  1.00 37.39           C  
ATOM   1570  CD  GLN A 207      24.084  13.423  70.811  0.00 20.00           C  
ATOM   1571  OE1 GLN A 207      23.873  14.607  70.549  0.00 20.00           O  
ATOM   1572  NE2 GLN A 207      23.978  12.925  72.040  0.00 20.00           N  
ATOM   1573  N   ASP A 208      25.838  13.043  65.086  1.00 36.46           N  
ATOM   1574  CA  ASP A 208      25.734  13.821  63.843  1.00 36.93           C  
ATOM   1575  C   ASP A 208      25.705  12.980  62.546  1.00 37.10           C  
ATOM   1576  O   ASP A 208      25.926  13.504  61.457  1.00 37.75           O  
ATOM   1577  CB  ASP A 208      26.868  14.858  63.805  1.00 36.84           C  
ATOM   1578  CG  ASP A 208      26.712  15.939  64.872  1.00 37.57           C  
ATOM   1579  OD1 ASP A 208      25.643  16.004  65.515  1.00 37.42           O  
ATOM   1580  OD2 ASP A 208      27.666  16.731  65.073  1.00 37.59           O  
ATOM   1581  N   SER A 209      25.441  11.683  62.672  1.00 37.33           N  
ATOM   1582  CA  SER A 209      25.142  10.807  61.524  1.00 37.30           C  
ATOM   1583  C   SER A 209      26.222  10.692  60.441  1.00 37.24           C  
ATOM   1584  O   SER A 209      25.913  10.552  59.252  1.00 37.72           O  
ATOM   1585  CB  SER A 209      23.808  11.224  60.898  1.00 37.67           C  
ATOM   1586  OG  SER A 209      22.768  11.138  61.857  1.00 38.50           O  
ATOM   1587  N   PHE A 210      27.489  10.705  60.837  1.00 36.68           N  
ATOM   1588  CA  PHE A 210      28.556  10.474  59.877  1.00 36.42           C  
ATOM   1589  C   PHE A 210      28.683   8.993  59.612  1.00 36.42           C  
ATOM   1590  O   PHE A 210      28.667   8.180  60.538  1.00 37.23           O  
ATOM   1591  CB  PHE A 210      29.878  11.074  60.361  1.00 36.02           C  
ATOM   1592  CG  PHE A 210      29.870  12.570  60.354  1.00 35.63           C  
ATOM   1593  CD1 PHE A 210      29.841  13.255  59.151  1.00 35.19           C  
ATOM   1594  CD2 PHE A 210      29.821  13.288  61.534  1.00 35.19           C  
ATOM   1595  CE1 PHE A 210      29.797  14.627  59.125  1.00 34.77           C  
ATOM   1596  CE2 PHE A 210      29.768  14.665  61.517  1.00 35.46           C  
ATOM   1597  CZ  PHE A 210      29.764  15.336  60.314  1.00 36.25           C  
ATOM   1598  N   ASP A 211      28.787   8.646  58.338  1.00 36.23           N  
ATOM   1599  CA  ASP A 211      29.079   7.279  57.937  1.00 36.15           C  
ATOM   1600  C   ASP A 211      30.487   6.944  58.386  1.00 35.55           C  
ATOM   1601  O   ASP A 211      30.769   5.835  58.830  1.00 35.01           O  
ATOM   1602  CB  ASP A 211      29.003   7.133  56.417  1.00 36.72           C  
ATOM   1603  CG  ASP A 211      27.626   7.440  55.865  1.00 38.59           C  
ATOM   1604  OD1 ASP A 211      26.625   7.056  56.505  1.00 41.45           O  
ATOM   1605  OD2 ASP A 211      27.547   8.055  54.781  1.00 41.69           O  
ATOM   1606  N   THR A 212      31.370   7.928  58.271  1.00 34.71           N  
ATOM   1607  CA  THR A 212      32.781   7.729  58.558  1.00 34.17           C  
ATOM   1608  C   THR A 212      33.394   8.991  59.142  1.00 33.68           C  
ATOM   1609  O   THR A 212      33.119  10.088  58.665  1.00 32.44           O  
ATOM   1610  CB  THR A 212      33.525   7.354  57.280  1.00 34.68           C  
ATOM   1611  OG1 THR A 212      32.830   6.266  56.647  1.00 35.17           O  
ATOM   1612  CG2 THR A 212      34.941   6.940  57.595  1.00 35.32           C  
ATOM   1613  N   ILE A 213      34.208   8.816  60.181  1.00 32.79           N  
ATOM   1614  CA  ILE A 213      35.008   9.908  60.757  1.00 33.06           C  
ATOM   1615  C   ILE A 213      36.460   9.515  60.613  1.00 33.48           C  
ATOM   1616  O   ILE A 213      36.896   8.533  61.212  1.00 33.87           O  
ATOM   1617  CB  ILE A 213      34.675  10.167  62.235  1.00 32.63           C  
ATOM   1618  CG1 ILE A 213      33.180  10.489  62.379  1.00 33.13           C  
ATOM   1619  CG2 ILE A 213      35.528  11.329  62.789  1.00 33.36           C  
ATOM   1620  CD1 ILE A 213      32.708  10.662  63.797  1.00 33.03           C  
ATOM   1621  N   HIS A 214      37.179  10.249  59.767  1.00 33.46           N  
ATOM   1622  CA  HIS A 214      38.610  10.058  59.586  1.00 33.47           C  
ATOM   1623  C   HIS A 214      39.310  11.008  60.523  1.00 33.56           C  
ATOM   1624  O   HIS A 214      39.039  12.212  60.511  1.00 33.86           O  
ATOM   1625  CB  HIS A 214      39.021  10.354  58.147  1.00 33.86           C  
ATOM   1626  CG  HIS A 214      38.544   9.334  57.162  1.00 34.57           C  
ATOM   1627  ND1 HIS A 214      37.311   9.399  56.555  1.00 37.28           N  
ATOM   1628  CD2 HIS A 214      39.134   8.206  56.696  1.00 34.47           C  
ATOM   1629  CE1 HIS A 214      37.165   8.365  55.746  1.00 35.86           C  
ATOM   1630  NE2 HIS A 214      38.253   7.620  55.822  1.00 36.80           N  
ATOM   1631  N   PHE A 215      40.200  10.474  61.351  1.00 32.49           N  
ATOM   1632  CA  PHE A 215      40.992  11.317  62.215  1.00 32.83           C  
ATOM   1633  C   PHE A 215      42.459  11.363  61.775  1.00 32.48           C  
ATOM   1634  O   PHE A 215      43.070  10.328  61.556  1.00 32.46           O  
ATOM   1635  CB  PHE A 215      40.942  10.854  63.665  1.00 32.72           C  
ATOM   1636  CG  PHE A 215      41.921  11.578  64.518  1.00 32.88           C  
ATOM   1637  CD1 PHE A 215      41.640  12.846  64.994  1.00 32.93           C  
ATOM   1638  CD2 PHE A 215      43.169  11.026  64.773  1.00 34.12           C  
ATOM   1639  CE1 PHE A 215      42.572  13.543  65.746  1.00 33.82           C  
ATOM   1640  CE2 PHE A 215      44.108  11.718  65.520  1.00 33.82           C  
ATOM   1641  CZ  PHE A 215      43.810  12.968  66.012  1.00 33.55           C  
ATOM   1642  N   PHE A 216      43.018  12.562  61.689  1.00 32.41           N  
ATOM   1643  CA  PHE A 216      44.424  12.727  61.319  1.00 32.69           C  
ATOM   1644  C   PHE A 216      45.188  13.352  62.479  1.00 32.72           C  
ATOM   1645  O   PHE A 216      44.763  14.353  63.039  1.00 32.44           O  
ATOM   1646  CB  PHE A 216      44.565  13.605  60.076  1.00 32.95           C  
ATOM   1647  CG  PHE A 216      43.832  13.078  58.870  1.00 33.09           C  
ATOM   1648  CD1 PHE A 216      44.519  12.439  57.850  1.00 32.26           C  
ATOM   1649  CD2 PHE A 216      42.454  13.226  58.760  1.00 33.02           C  
ATOM   1650  CE1 PHE A 216      43.846  11.947  56.741  1.00 33.96           C  
ATOM   1651  CE2 PHE A 216      41.773  12.750  57.637  1.00 33.15           C  
ATOM   1652  CZ  PHE A 216      42.468  12.108  56.637  1.00 33.37           C  
ATOM   1653  N   GLY A 217      46.315  12.756  62.842  1.00 33.13           N  
ATOM   1654  CA  GLY A 217      47.135  13.279  63.917  1.00 32.81           C  
ATOM   1655  C   GLY A 217      48.595  12.917  63.764  1.00 32.92           C  
ATOM   1656  O   GLY A 217      48.938  11.983  63.045  1.00 33.46           O  
ATOM   1657  N   ASN A 218      49.452  13.675  64.433  1.00 32.67           N  
ATOM   1658  CA  ASN A 218      50.894  13.448  64.349  1.00 32.86           C  
ATOM   1659  C   ASN A 218      51.503  12.885  65.629  1.00 33.13           C  
ATOM   1660  O   ASN A 218      52.726  12.693  65.710  1.00 31.67           O  
ATOM   1661  CB  ASN A 218      51.596  14.739  63.941  1.00 33.07           C  
ATOM   1662  CG  ASN A 218      51.616  15.773  65.045  1.00 32.42           C  
ATOM   1663  OD1 ASN A 218      50.580  16.107  65.620  1.00 33.20           O  
ATOM   1664  ND2 ASN A 218      52.800  16.301  65.334  1.00 32.92           N  
ATOM   1665  N   GLU A 219      50.654  12.612  66.617  1.00 33.03           N  
ATOM   1666  CA  GLU A 219      51.084  12.004  67.875  1.00 34.36           C  
ATOM   1667  C   GLU A 219      50.246  10.770  68.195  1.00 34.48           C  
ATOM   1668  O   GLU A 219      49.628  10.680  69.267  1.00 34.22           O  
ATOM   1669  CB  GLU A 219      50.965  13.005  69.014  1.00 34.73           C  
ATOM   1670  CG  GLU A 219      52.025  14.066  69.020  1.00 35.28           C  
ATOM   1671  CD  GLU A 219      51.943  14.937  70.254  1.00 36.26           C  
ATOM   1672  OE1 GLU A 219      51.530  14.418  71.320  1.00 38.28           O  
ATOM   1673  OE2 GLU A 219      52.292  16.140  70.159  1.00 37.44           O  
ATOM   1674  N   THR A 220      50.232   9.825  67.256  1.00 34.79           N  
ATOM   1675  CA  THR A 220      49.326   8.680  67.316  1.00 34.90           C  
ATOM   1676  C   THR A 220      49.937   7.448  67.970  1.00 35.11           C  
ATOM   1677  O   THR A 220      49.266   6.439  68.098  1.00 35.97           O  
ATOM   1678  CB  THR A 220      48.823   8.284  65.907  1.00 34.83           C  
ATOM   1679  OG1 THR A 220      49.935   7.864  65.104  1.00 34.19           O  
ATOM   1680  CG2 THR A 220      48.080   9.456  65.238  1.00 34.41           C  
ATOM   1681  N   SER A 221      51.207   7.526  68.374  1.00 35.59           N  
ATOM   1682  CA  SER A 221      51.849   6.439  69.119  1.00 35.93           C  
ATOM   1683  C   SER A 221      51.466   6.510  70.595  1.00 36.02           C  
ATOM   1684  O   SER A 221      51.036   7.556  71.065  1.00 36.02           O  
ATOM   1685  CB  SER A 221      53.368   6.509  68.968  1.00 36.17           C  
ATOM   1686  OG  SER A 221      53.733   6.183  67.637  1.00 37.72           O  
ATOM   1687  N   PRO A 222      51.609   5.388  71.330  1.00 36.26           N  
ATOM   1688  CA  PRO A 222      51.345   5.414  72.769  1.00 36.17           C  
ATOM   1689  C   PRO A 222      52.077   6.551  73.479  1.00 36.33           C  
ATOM   1690  O   PRO A 222      53.257   6.818  73.201  1.00 36.03           O  
ATOM   1691  CB  PRO A 222      51.844   4.049  73.235  1.00 36.39           C  
ATOM   1692  CG  PRO A 222      51.652   3.177  72.038  1.00 36.26           C  
ATOM   1693  CD  PRO A 222      51.991   4.041  70.872  1.00 36.27           C  
ATOM   1694  N   GLY A 223      51.359   7.232  74.365  1.00 36.15           N  
ATOM   1695  CA  GLY A 223      51.885   8.403  75.035  1.00 36.30           C  
ATOM   1696  C   GLY A 223      51.633   9.704  74.297  1.00 36.08           C  
ATOM   1697  O   GLY A 223      51.809  10.774  74.878  1.00 36.72           O  
ATOM   1698  N   GLY A 224      51.224   9.626  73.029  1.00 35.82           N  
ATOM   1699  CA  GLY A 224      50.972  10.824  72.221  1.00 35.39           C  
ATOM   1700  C   GLY A 224      49.567  11.352  72.440  1.00 34.98           C  
ATOM   1701  O   GLY A 224      48.658  10.595  72.774  1.00 34.36           O  
ATOM   1702  N   ASN A 225      49.369  12.653  72.268  1.00 34.58           N  
ATOM   1703  CA  ASN A 225      48.050  13.231  72.558  1.00 34.63           C  
ATOM   1704  C   ASN A 225      46.981  12.949  71.496  1.00 34.32           C  
ATOM   1705  O   ASN A 225      45.849  13.367  71.667  1.00 35.00           O  
ATOM   1706  CB  ASN A 225      48.116  14.728  72.912  1.00 34.75           C  
ATOM   1707  CG  ASN A 225      48.540  15.614  71.753  1.00 35.43           C  
ATOM   1708  OD1 ASN A 225      48.331  15.300  70.588  1.00 36.19           O  
ATOM   1709  ND2 ASN A 225      49.133  16.759  72.089  1.00 38.58           N  
ATOM   1710  N   ASP A 226      47.342  12.254  70.413  1.00 34.13           N  
ATOM   1711  CA  ASP A 226      46.363  11.745  69.435  1.00 33.60           C  
ATOM   1712  C   ASP A 226      46.086  10.247  69.572  1.00 33.57           C  
ATOM   1713  O   ASP A 226      45.253   9.707  68.848  1.00 32.46           O  
ATOM   1714  CB  ASP A 226      46.858  11.980  67.999  1.00 34.02           C  
ATOM   1715  CG  ASP A 226      47.099  13.451  67.681  1.00 33.88           C  
ATOM   1716  OD1 ASP A 226      46.264  14.297  68.073  1.00 34.71           O  
ATOM   1717  OD2 ASP A 226      48.124  13.744  67.005  1.00 33.78           O  
ATOM   1718  N   PHE A 227      46.785   9.560  70.467  1.00 33.47           N  
ATOM   1719  CA  PHE A 227      46.690   8.094  70.507  1.00 33.53           C  
ATOM   1720  C   PHE A 227      45.266   7.585  70.694  1.00 33.43           C  
ATOM   1721  O   PHE A 227      44.780   6.737  69.929  1.00 33.15           O  
ATOM   1722  CB  PHE A 227      47.541   7.513  71.622  1.00 34.30           C  
ATOM   1723  CG  PHE A 227      47.333   6.036  71.803  1.00 34.26           C  
ATOM   1724  CD1 PHE A 227      47.816   5.146  70.859  1.00 36.27           C  
ATOM   1725  CD2 PHE A 227      46.620   5.543  72.887  1.00 35.23           C  
ATOM   1726  CE1 PHE A 227      47.614   3.778  71.001  1.00 36.21           C  
ATOM   1727  CE2 PHE A 227      46.406   4.179  73.037  1.00 35.54           C  
ATOM   1728  CZ  PHE A 227      46.906   3.296  72.097  1.00 35.92           C  
ATOM   1729  N   GLU A 228      44.607   8.083  71.729  1.00 33.25           N  
ATOM   1730  CA  GLU A 228      43.278   7.578  72.096  1.00 33.01           C  
ATOM   1731  C   GLU A 228      42.212   7.823  71.031  1.00 32.73           C  
ATOM   1732  O   GLU A 228      41.424   6.927  70.720  1.00 32.46           O  
ATOM   1733  CB  GLU A 228      42.818   8.197  73.404  1.00 33.72           C  
ATOM   1734  CG  GLU A 228      43.727   7.898  74.590  1.00 34.03           C  
ATOM   1735  CD  GLU A 228      44.879   8.872  74.775  1.00 35.55           C  
ATOM   1736  OE1 GLU A 228      45.071   9.834  73.964  1.00 34.76           O  
ATOM   1737  OE2 GLU A 228      45.609   8.677  75.769  1.00 35.81           O  
ATOM   1738  N   ILE A 229      42.165   9.036  70.491  1.00 32.39           N  
ATOM   1739  CA  ILE A 229      41.199   9.351  69.427  1.00 32.46           C  
ATOM   1740  C   ILE A 229      41.505   8.572  68.131  1.00 32.30           C  
ATOM   1741  O   ILE A 229      40.588   8.099  67.459  1.00 31.58           O  
ATOM   1742  CB  ILE A 229      41.069  10.886  69.174  1.00 31.92           C  
ATOM   1743  CG1 ILE A 229      39.906  11.157  68.198  1.00 32.06           C  
ATOM   1744  CG2 ILE A 229      42.390  11.503  68.666  1.00 32.34           C  
ATOM   1745  CD1 ILE A 229      39.492  12.644  68.107  1.00 31.69           C  
ATOM   1746  N   PHE A 230      42.791   8.417  67.824  1.00 32.62           N  
ATOM   1747  CA  PHE A 230      43.270   7.603  66.684  1.00 32.62           C  
ATOM   1748  C   PHE A 230      42.817   6.150  66.803  1.00 32.70           C  
ATOM   1749  O   PHE A 230      42.262   5.572  65.854  1.00 32.07           O  
ATOM   1750  CB  PHE A 230      44.819   7.713  66.623  1.00 32.71           C  
ATOM   1751  CG  PHE A 230      45.502   6.708  65.723  1.00 33.06           C  
ATOM   1752  CD1 PHE A 230      45.615   6.929  64.360  1.00 32.79           C  
ATOM   1753  CD2 PHE A 230      46.119   5.579  66.261  1.00 33.14           C  
ATOM   1754  CE1 PHE A 230      46.283   6.014  63.547  1.00 32.75           C  
ATOM   1755  CE2 PHE A 230      46.777   4.672  65.450  1.00 33.12           C  
ATOM   1756  CZ  PHE A 230      46.853   4.896  64.088  1.00 33.42           C  
ATOM   1757  N   ALA A 231      43.050   5.573  67.979  1.00 32.36           N  
ATOM   1758  CA  ALA A 231      42.777   4.155  68.240  1.00 32.30           C  
ATOM   1759  C   ALA A 231      41.299   3.845  68.522  1.00 32.11           C  
ATOM   1760  O   ALA A 231      40.893   2.673  68.532  1.00 32.11           O  
ATOM   1761  CB  ALA A 231      43.631   3.698  69.402  1.00 31.55           C  
ATOM   1762  N   ASP A 232      40.501   4.883  68.765  1.00 31.83           N  
ATOM   1763  CA  ASP A 232      39.085   4.696  69.098  1.00 32.17           C  
ATOM   1764  C   ASP A 232      38.357   4.048  67.919  1.00 31.85           C  
ATOM   1765  O   ASP A 232      38.574   4.456  66.771  1.00 32.23           O  
ATOM   1766  CB  ASP A 232      38.431   6.041  69.435  1.00 32.12           C  
ATOM   1767  CG  ASP A 232      37.083   5.878  70.104  1.00 32.03           C  
ATOM   1768  OD1 ASP A 232      36.106   5.539  69.410  1.00 33.03           O  
ATOM   1769  OD2 ASP A 232      36.998   6.088  71.330  1.00 32.95           O  
ATOM   1770  N   PRO A 233      37.524   3.026  68.183  1.00 32.19           N  
ATOM   1771  CA  PRO A 233      36.763   2.352  67.111  1.00 31.84           C  
ATOM   1772  C   PRO A 233      35.828   3.254  66.313  1.00 31.71           C  
ATOM   1773  O   PRO A 233      35.388   2.868  65.231  1.00 30.96           O  
ATOM   1774  CB  PRO A 233      35.940   1.315  67.864  1.00 32.22           C  
ATOM   1775  CG  PRO A 233      36.609   1.119  69.126  1.00 33.05           C  
ATOM   1776  CD  PRO A 233      37.289   2.380  69.485  1.00 31.84           C  
ATOM   1777  N   ARG A 234      35.532   4.443  66.833  1.00 31.58           N  
ATOM   1778  CA  ARG A 234      34.648   5.385  66.139  1.00 31.77           C  
ATOM   1779  C   ARG A 234      35.314   6.159  65.011  1.00 31.73           C  
ATOM   1780  O   ARG A 234      34.622   6.825  64.243  1.00 32.48           O  
ATOM   1781  CB  ARG A 234      34.012   6.348  67.135  1.00 31.66           C  
ATOM   1782  CG  ARG A 234      33.028   5.668  68.048  1.00 32.25           C  
ATOM   1783  CD  ARG A 234      32.585   6.574  69.173  1.00 32.90           C  
ATOM   1784  NE  ARG A 234      33.647   6.803  70.149  1.00 33.56           N  
ATOM   1785  CZ  ARG A 234      33.498   7.532  71.248  1.00 33.65           C  
ATOM   1786  NH1 ARG A 234      32.340   8.112  71.516  1.00 31.78           N  
ATOM   1787  NH2 ARG A 234      34.513   7.689  72.077  1.00 34.95           N  
ATOM   1788  N   THR A 235      36.646   6.080  64.919  1.00 31.50           N  
ATOM   1789  CA  THR A 235      37.410   6.801  63.892  1.00 31.35           C  
ATOM   1790  C   THR A 235      38.217   5.873  62.996  1.00 31.19           C  
ATOM   1791  O   THR A 235      38.672   4.807  63.440  1.00 30.67           O  
ATOM   1792  CB  THR A 235      38.434   7.759  64.524  1.00 31.18           C  
ATOM   1793  OG1 THR A 235      39.414   6.992  65.235  1.00 31.40           O  
ATOM   1794  CG2 THR A 235      37.767   8.721  65.484  1.00 31.19           C  
ATOM   1795  N   VAL A 236      38.379   6.279  61.738  1.00 30.81           N  
ATOM   1796  CA  VAL A 236      39.390   5.700  60.878  1.00 31.21           C  
ATOM   1797  C   VAL A 236      40.637   6.529  61.144  1.00 31.89           C  
ATOM   1798  O   VAL A 236      40.638   7.735  60.941  1.00 31.46           O  
ATOM   1799  CB  VAL A 236      38.990   5.747  59.402  1.00 31.61           C  
ATOM   1800  CG1 VAL A 236      40.100   5.126  58.518  1.00 30.60           C  
ATOM   1801  CG2 VAL A 236      37.667   5.017  59.211  1.00 31.11           C  
ATOM   1802  N   GLY A 237      41.692   5.880  61.617  1.00 32.03           N  
ATOM   1803  CA  GLY A 237      42.860   6.611  62.115  1.00 32.05           C  
ATOM   1804  C   GLY A 237      43.948   6.799  61.079  1.00 32.01           C  
ATOM   1805  O   GLY A 237      44.276   5.881  60.329  1.00 31.76           O  
ATOM   1806  N   HIS A 238      44.528   7.994  61.056  1.00 32.63           N  
ATOM   1807  CA  HIS A 238      45.624   8.289  60.147  1.00 32.86           C  
ATOM   1808  C   HIS A 238      46.763   8.977  60.872  1.00 33.48           C  
ATOM   1809  O   HIS A 238      46.561   9.993  61.518  1.00 33.52           O  
ATOM   1810  CB  HIS A 238      45.130   9.180  59.024  1.00 32.74           C  
ATOM   1811  CG  HIS A 238      43.984   8.601  58.270  1.00 33.28           C  
ATOM   1812  ND1 HIS A 238      44.148   7.663  57.275  1.00 32.67           N  
ATOM   1813  CD2 HIS A 238      42.653   8.821  58.371  1.00 33.17           C  
ATOM   1814  CE1 HIS A 238      42.965   7.343  56.784  1.00 32.58           C  
ATOM   1815  NE2 HIS A 238      42.042   8.033  57.431  1.00 31.57           N  
ATOM   1816  N   SER A 239      47.961   8.407  60.751  1.00 33.82           N  
ATOM   1817  CA  SER A 239      49.164   8.978  61.335  1.00 34.26           C  
ATOM   1818  C   SER A 239      49.891   9.789  60.267  1.00 34.04           C  
ATOM   1819  O   SER A 239      50.174   9.274  59.186  1.00 33.77           O  
ATOM   1820  CB  SER A 239      50.081   7.866  61.855  1.00 34.75           C  
ATOM   1821  OG  SER A 239      49.384   7.003  62.748  1.00 37.58           O  
ATOM   1822  N   VAL A 240      50.171  11.060  60.568  1.00 33.96           N  
ATOM   1823  CA  VAL A 240      50.879  11.947  59.652  1.00 33.55           C  
ATOM   1824  C   VAL A 240      52.100  12.547  60.339  1.00 33.39           C  
ATOM   1825  O   VAL A 240      52.196  12.535  61.564  1.00 33.52           O  
ATOM   1826  CB  VAL A 240      49.960  13.083  59.137  1.00 33.59           C  
ATOM   1827  CG1 VAL A 240      48.739  12.501  58.447  1.00 34.41           C  
ATOM   1828  CG2 VAL A 240      49.547  14.013  60.279  1.00 34.37           C  
ATOM   1829  N   VAL A 241      53.033  13.063  59.546  1.00 33.08           N  
ATOM   1830  CA  VAL A 241      54.270  13.641  60.085  1.00 33.05           C  
ATOM   1831  C   VAL A 241      54.401  15.153  59.840  1.00 32.90           C  
ATOM   1832  O   VAL A 241      55.350  15.771  60.324  1.00 32.94           O  
ATOM   1833  CB  VAL A 241      55.522  12.919  59.524  1.00 33.14           C  
ATOM   1834  CG1 VAL A 241      55.502  11.440  59.889  1.00 33.00           C  
ATOM   1835  CG2 VAL A 241      55.623  13.088  58.015  1.00 33.45           C  
ATOM   1836  N   SER A 242      53.448  15.741  59.115  1.00 32.65           N  
ATOM   1837  CA  SER A 242      53.508  17.148  58.732  1.00 32.29           C  
ATOM   1838  C   SER A 242      52.204  17.554  58.062  1.00 32.07           C  
ATOM   1839  O   SER A 242      51.430  16.692  57.652  1.00 31.35           O  
ATOM   1840  CB  SER A 242      54.641  17.392  57.740  1.00 32.14           C  
ATOM   1841  OG  SER A 242      54.345  16.766  56.500  1.00 31.87           O  
ATOM   1842  N   PRO A 243      51.958  18.862  57.937  1.00 31.45           N  
ATOM   1843  CA  PRO A 243      50.792  19.295  57.174  1.00 31.44           C  
ATOM   1844  C   PRO A 243      50.805  18.907  55.690  1.00 31.45           C  
ATOM   1845  O   PRO A 243      49.740  18.667  55.111  1.00 31.92           O  
ATOM   1846  CB  PRO A 243      50.821  20.816  57.348  1.00 31.53           C  
ATOM   1847  CG  PRO A 243      51.569  21.021  58.613  1.00 30.89           C  
ATOM   1848  CD  PRO A 243      52.649  20.014  58.539  1.00 31.69           C  
ATOM   1849  N   GLN A 244      51.990  18.818  55.095  1.00 31.50           N  
ATOM   1850  CA  GLN A 244      52.121  18.403  53.692  1.00 31.16           C  
ATOM   1851  C   GLN A 244      51.718  16.933  53.531  1.00 30.59           C  
ATOM   1852  O   GLN A 244      51.098  16.548  52.538  1.00 30.11           O  
ATOM   1853  CB  GLN A 244      53.554  18.618  53.199  1.00 31.48           C  
ATOM   1854  CG  GLN A 244      53.948  20.086  53.083  1.00 32.25           C  
ATOM   1855  CD  GLN A 244      54.036  20.793  54.429  1.00 33.84           C  
ATOM   1856  OE1 GLN A 244      54.535  20.233  55.408  1.00 34.26           O  
ATOM   1857  NE2 GLN A 244      53.547  22.027  54.483  1.00 35.73           N  
ATOM   1858  N   ASP A 245      52.063  16.131  54.535  1.00 29.42           N  
ATOM   1859  CA  ASP A 245      51.712  14.723  54.586  1.00 29.84           C  
ATOM   1860  C   ASP A 245      50.197  14.561  54.723  1.00 29.71           C  
ATOM   1861  O   ASP A 245      49.575  13.712  54.058  1.00 30.34           O  
ATOM   1862  CB  ASP A 245      52.413  14.075  55.787  1.00 28.60           C  
ATOM   1863  CG  ASP A 245      52.298  12.558  55.801  1.00 31.23           C  
ATOM   1864  OD1 ASP A 245      51.828  11.957  54.800  1.00 30.21           O  
ATOM   1865  OD2 ASP A 245      52.684  11.940  56.828  1.00 29.79           O  
ATOM   1866  N   THR A 246      49.609  15.381  55.588  1.00 30.80           N  
ATOM   1867  CA  THR A 246      48.163  15.362  55.805  1.00 31.01           C  
ATOM   1868  C   THR A 246      47.432  15.650  54.501  1.00 31.18           C  
ATOM   1869  O   THR A 246      46.486  14.948  54.129  1.00 31.71           O  
ATOM   1870  CB  THR A 246      47.746  16.391  56.860  1.00 31.69           C  
ATOM   1871  OG1 THR A 246      48.426  16.109  58.097  1.00 32.00           O  
ATOM   1872  CG2 THR A 246      46.226  16.348  57.084  1.00 31.42           C  
ATOM   1873  N   VAL A 247      47.897  16.675  53.791  1.00 30.98           N  
ATOM   1874  CA  VAL A 247      47.316  17.023  52.494  1.00 30.82           C  
ATOM   1875  C   VAL A 247      47.430  15.886  51.480  1.00 30.58           C  
ATOM   1876  O   VAL A 247      46.466  15.565  50.779  1.00 30.89           O  
ATOM   1877  CB  VAL A 247      47.975  18.283  51.931  1.00 30.63           C  
ATOM   1878  CG1 VAL A 247      47.540  18.520  50.490  1.00 31.11           C  
ATOM   1879  CG2 VAL A 247      47.617  19.478  52.793  1.00 30.97           C  
ATOM   1880  N   GLN A 248      48.601  15.266  51.406  1.00 30.01           N  
ATOM   1881  CA  GLN A 248      48.832  14.159  50.478  1.00 30.41           C  
ATOM   1882  C   GLN A 248      47.873  13.011  50.773  1.00 31.19           C  
ATOM   1883  O   GLN A 248      47.232  12.469  49.872  1.00 31.52           O  
ATOM   1884  CB  GLN A 248      50.281  13.672  50.588  1.00 30.30           C  
ATOM   1885  CG  GLN A 248      50.818  13.001  49.354  1.00 30.92           C  
ATOM   1886  CD  GLN A 248      51.982  12.270  49.563  0.00 20.00           C  
ATOM   1887  OE1 GLN A 248      51.985  11.075  49.285  0.00 20.00           O  
ATOM   1888  NE2 GLN A 248      53.035  12.892  50.074  0.00 20.00           N  
ATOM   1889  N   ARG A 249      47.771  12.663  52.049  1.00 32.03           N  
ATOM   1890  CA  ARG A 249      46.891  11.598  52.510  1.00 32.98           C  
ATOM   1891  C   ARG A 249      45.441  11.873  52.139  1.00 33.36           C  
ATOM   1892  O   ARG A 249      44.737  10.976  51.688  1.00 33.26           O  
ATOM   1893  CB  ARG A 249      47.001  11.431  54.029  1.00 32.67           C  
ATOM   1894  CG  ARG A 249      46.510  10.064  54.545  1.00 33.02           C  
ATOM   1895  CD  ARG A 249      47.468   8.925  54.189  1.00 33.33           C  
ATOM   1896  NE  ARG A 249      48.825   9.244  54.619  1.00 34.09           N  
ATOM   1897  CZ  ARG A 249      49.271   9.174  55.873  1.00 34.58           C  
ATOM   1898  NH1 ARG A 249      48.492   8.748  56.854  1.00 35.18           N  
ATOM   1899  NH2 ARG A 249      50.518   9.536  56.142  1.00 34.44           N  
ATOM   1900  N   CYS A 250      45.005  13.118  52.331  1.00 34.10           N  
ATOM   1901  CA  CYS A 250      43.637  13.512  51.996  1.00 35.17           C  
ATOM   1902  C   CYS A 250      43.350  13.473  50.505  1.00 35.70           C  
ATOM   1903  O   CYS A 250      42.252  13.070  50.099  1.00 35.77           O  
ATOM   1904  CB  CYS A 250      43.329  14.900  52.548  1.00 35.06           C  
ATOM   1905  SG  CYS A 250      43.127  14.883  54.330  1.00 36.27           S  
ATOM   1906  N   ARG A 251      44.315  13.895  49.692  0.50 35.95           N  
ATOM   1908  CA  ARG A 251      44.174  13.810  48.236  0.50 36.32           C  
ATOM   1910  C   ARG A 251      44.044  12.357  47.792  0.50 36.50           C  
ATOM   1912  O   ARG A 251      43.255  12.040  46.896  0.50 36.42           O  
ATOM   1914  CB  ARG A 251      45.365  14.458  47.522  0.50 36.27           C  
ATOM   1916  CG  ARG A 251      45.386  15.982  47.558  0.50 36.88           C  
ATOM   1918  CD  ARG A 251      46.561  16.519  46.749  0.50 36.99           C  
ATOM   1920  NE  ARG A 251      46.948  17.885  47.109  0.50 37.77           N  
ATOM   1922  CZ  ARG A 251      46.394  19.000  46.629  0.50 38.06           C  
ATOM   1924  NH1 ARG A 251      45.385  18.953  45.762  0.50 38.44           N  
ATOM   1926  NH2 ARG A 251      46.852  20.180  47.034  0.50 38.13           N  
ATOM   1928  N   GLU A 252      44.827  11.481  48.417  1.00 36.49           N  
ATOM   1929  CA  GLU A 252      44.836  10.056  48.082  1.00 37.19           C  
ATOM   1930  C   GLU A 252      43.518   9.353  48.387  1.00 37.20           C  
ATOM   1931  O   GLU A 252      43.072   8.494  47.628  1.00 37.43           O  
ATOM   1932  CB  GLU A 252      45.962   9.356  48.845  1.00 37.32           C  
ATOM   1933  CG  GLU A 252      47.353   9.665  48.318  1.00 38.66           C  
ATOM   1934  CD  GLU A 252      48.451   9.022  49.150  1.00 39.09           C  
ATOM   1935  OE1 GLU A 252      48.228   8.772  50.353  1.00 41.77           O  
ATOM   1936  OE2 GLU A 252      49.540   8.767  48.596  1.00 43.23           O  
ATOM   1937  N   ILE A 253      42.905   9.722  49.502  1.00 37.48           N  
ATOM   1938  CA  ILE A 253      41.694   9.063  49.971  1.00 37.80           C  
ATOM   1939  C   ILE A 253      40.440   9.648  49.317  1.00 37.83           C  
ATOM   1940  O   ILE A 253      39.556   8.902  48.887  1.00 37.97           O  
ATOM   1941  CB  ILE A 253      41.583   9.180  51.508  1.00 37.62           C  
ATOM   1942  CG1 ILE A 253      42.782   8.504  52.179  1.00 37.88           C  
ATOM   1943  CG2 ILE A 253      40.281   8.567  52.010  1.00 37.77           C  
ATOM   1944  CD1 ILE A 253      42.939   8.853  53.643  1.00 38.12           C  
ATOM   1945  N   PHE A 254      40.371  10.976  49.237  1.00 38.18           N  
ATOM   1946  CA  PHE A 254      39.134  11.670  48.840  1.00 38.51           C  
ATOM   1947  C   PHE A 254      39.132  12.237  47.425  1.00 38.66           C  
ATOM   1948  O   PHE A 254      38.065  12.533  46.879  1.00 38.79           O  
ATOM   1949  CB  PHE A 254      38.809  12.755  49.864  1.00 38.68           C  
ATOM   1950  CG  PHE A 254      38.714  12.227  51.260  1.00 39.00           C  
ATOM   1951  CD1 PHE A 254      37.588  11.523  51.672  1.00 38.91           C  
ATOM   1952  CD2 PHE A 254      39.758  12.390  52.145  1.00 38.51           C  
ATOM   1953  CE1 PHE A 254      37.509  11.007  52.956  1.00 38.93           C  
ATOM   1954  CE2 PHE A 254      39.688  11.877  53.426  1.00 39.07           C  
ATOM   1955  CZ  PHE A 254      38.559  11.193  53.834  1.00 38.51           C  
ATOM   1956  N   PHE A 255      40.312  12.366  46.825  1.00 38.64           N  
ATOM   1957  CA  PHE A 255      40.433  12.720  45.413  1.00 38.85           C  
ATOM   1958  C   PHE A 255      41.286  11.672  44.694  1.00 39.10           C  
ATOM   1959  O   PHE A 255      42.295  12.007  44.081  1.00 39.10           O  
ATOM   1960  CB  PHE A 255      41.068  14.109  45.258  1.00 38.47           C  
ATOM   1961  CG  PHE A 255      40.298  15.216  45.923  1.00 38.03           C  
ATOM   1962  CD1 PHE A 255      39.212  15.803  45.291  1.00 36.80           C  
ATOM   1963  CD2 PHE A 255      40.670  15.686  47.173  1.00 37.88           C  
ATOM   1964  CE1 PHE A 255      38.507  16.827  45.896  1.00 36.81           C  
ATOM   1965  CE2 PHE A 255      39.970  16.714  47.784  1.00 37.97           C  
ATOM   1966  CZ  PHE A 255      38.891  17.288  47.149  1.00 37.76           C  
ATOM   1967  N   PRO A 256      40.887  10.389  44.768  1.00 39.48           N  
ATOM   1968  CA  PRO A 256      41.712   9.344  44.166  1.00 39.92           C  
ATOM   1969  C   PRO A 256      41.881   9.548  42.669  1.00 40.48           C  
ATOM   1970  O   PRO A 256      42.969   9.338  42.137  1.00 40.48           O  
ATOM   1971  CB  PRO A 256      40.915   8.061  44.437  1.00 39.92           C  
ATOM   1972  CG  PRO A 256      39.516   8.519  44.679  1.00 39.80           C  
ATOM   1973  CD  PRO A 256      39.660   9.840  45.366  1.00 39.43           C  
ATOM   1974  N   GLU A 257      40.806   9.972  42.008  1.00 41.11           N  
ATOM   1975  CA  GLU A 257      40.810  10.164  40.562  1.00 41.51           C  
ATOM   1976  C   GLU A 257      41.732  11.311  40.148  1.00 42.00           C  
ATOM   1977  O   GLU A 257      42.277  11.299  39.045  1.00 41.79           O  
ATOM   1978  CB  GLU A 257      39.388  10.421  40.055  1.00 41.75           C  
ATOM   1979  CG  GLU A 257      38.129   9.626  40.461  0.00 20.00           C  
ATOM   1980  CD  GLU A 257      36.730  10.087  40.099  0.00 20.00           C  
ATOM   1981  OE1 GLU A 257      36.570  11.273  39.739  0.00 20.00           O  
ATOM   1982  OE2 GLU A 257      35.792   9.266  40.175  0.00 20.00           O  
ATOM   1983  N   THR A 258      41.907  12.289  41.041  1.00 42.48           N  
ATOM   1984  CA  THR A 258      42.734  13.468  40.769  1.00 42.66           C  
ATOM   1985  C   THR A 258      44.142  13.304  41.332  1.00 43.46           C  
ATOM   1986  O   THR A 258      44.313  12.984  42.511  1.00 44.27           O  
ATOM   1987  CB  THR A 258      42.114  14.733  41.385  1.00 43.01           C  
ATOM   1988  OG1 THR A 258      43.050  15.848  41.111  0.00 20.00           O  
ATOM   1989  CG2 THR A 258      41.935  14.738  42.813  0.00 20.00           C  
TER    1990      THR A 258                                                      
END
MOLECULE T0505.pdb
ATOM      1  N   LYS     6      34.876   8.083  54.296  1.00 32.10           N  
ATOM      2  CA  LYS     6      35.022   8.794  55.595  1.00 30.60           C  
ATOM      3  C   LYS     6      34.171  10.050  55.575  1.00 30.04           C  
ATOM      4  O   LYS     6      33.987  10.662  54.513  1.00 31.08           O  
ATOM      5  CB  LYS     6      36.491   9.159  55.851  1.00 31.17           C  
ATOM      6  CG  LYS     6      37.392   7.952  56.020  1.00 33.54           C  
ATOM      7  CD  LYS     6      37.138   7.255  57.363  1.00 35.57           C  
ATOM      8  CE  LYS     6      38.133   6.150  57.642  1.00 36.27           C  
ATOM      9  NZ  LYS     6      37.853   4.949  56.798  1.00 38.14           N  
ATOM     10  N   GLN     7      33.690  10.451  56.753  1.00 27.59           N  
ATOM     11  CA  GLN     7      32.685  11.487  56.895  0.50 26.89           C  
ATOM     13  C   GLN     7      33.138  12.631  57.799  1.00 25.56           C  
ATOM     14  O   GLN     7      32.526  13.695  57.807  1.00 25.38           O  
ATOM     15  CB  GLN     7      31.426  10.868  57.485  0.50 26.93           C  
ATOM     17  CG  GLN     7      30.647  10.009  56.503  0.50 28.57           C  
ATOM     19  CD  GLN     7      29.661  10.836  55.717  0.50 29.35           C  
ATOM     21  OE1 GLN     7      29.854  11.087  54.530  0.50 30.06           O  
ATOM     23  NE2 GLN     7      28.612  11.308  56.395  0.50 29.45           N  
ATOM     25  N   LEU     8      34.200  12.400  58.577  0.50 24.45           N  
ATOM     27  CA  LEU     8      34.661  13.377  59.583  0.50 23.92           C  
ATOM     29  C   LEU     8      36.187  13.456  59.657  0.50 23.34           C  
ATOM     31  O   LEU     8      36.847  12.452  59.952  0.50 23.15           O  
ATOM     33  CB  LEU     8      34.101  13.028  60.972  0.50 24.05           C  
ATOM     35  CG  LEU     8      34.601  13.825  62.197  0.50 24.47           C  
ATOM     37  CD1 LEU     8      34.433  15.330  62.006  0.50 23.47           C  
ATOM     39  CD2 LEU     8      33.919  13.376  63.497  0.50 23.31           C  
ATOM     41  N   LEU     9      36.730  14.650  59.413  1.00 23.12           N  
ATOM     42  CA  LEU     9      38.176  14.891  59.468  1.00 23.12           C  
ATOM     43  C   LEU     9      38.484  15.724  60.712  1.00 22.53           C  
ATOM     44  O   LEU     9      37.954  16.839  60.871  1.00 23.46           O  
ATOM     45  CB  LEU     9      38.656  15.617  58.198  1.00 23.25           C  
ATOM     46  CG  LEU     9      40.093  16.142  58.238  1.00 25.00           C  
ATOM     47  CD1 LEU     9      41.072  14.935  58.280  1.00 26.13           C  
ATOM     48  CD2 LEU     9      40.418  17.054  57.039  1.00 24.10           C  
ATOM     49  N   ALA    10      39.282  15.171  61.620  1.00 22.09           N  
ATOM     50  CA  ALA    10      39.697  15.881  62.836  1.00 23.55           C  
ATOM     51  C   ALA    10      41.197  16.143  62.812  1.00 24.22           C  
ATOM     52  O   ALA    10      41.973  15.196  62.631  1.00 24.53           O  
ATOM     53  CB  ALA    10      39.325  15.052  64.049  1.00 25.36           C  
ATOM     54  N   LEU    11      41.581  17.415  62.969  1.00 23.75           N  
ATOM     55  CA  LEU    11      42.967  17.843  62.829  0.50 23.98           C  
ATOM     57  C   LEU    11      43.477  18.526  64.105  1.00 23.85           C  
ATOM     58  O   LEU    11      42.800  19.360  64.673  1.00 23.47           O  
ATOM     59  CB  LEU    11      43.102  18.860  61.664  0.50 24.46           C  
ATOM     61  CG  LEU    11      42.423  18.598  60.316  0.50 24.12           C  
ATOM     63  CD1 LEU    11      41.927  19.862  59.697  0.50 27.02           C  
ATOM     65  CD2 LEU    11      43.374  17.912  59.348  0.50 26.73           C  
ATOM     67  N   ASN    12      44.706  18.206  64.500  1.00 23.73           N  
ATOM     68  CA  ASN    12      45.425  19.070  65.448  1.00 23.73           C  
ATOM     69  C   ASN    12      45.664  20.434  64.786  1.00 23.97           C  
ATOM     70  O   ASN    12      45.753  20.542  63.562  1.00 23.62           O  
ATOM     71  CB  ASN    12      46.846  18.547  65.770  1.00 23.79           C  
ATOM     72  CG  ASN    12      46.888  17.356  66.714  1.00 25.38           C  
ATOM     73  OD1 ASN    12      47.905  16.688  66.770  1.00 26.57           O  
ATOM     74  ND2 ASN    12      45.834  17.118  67.483  1.00 25.65           N  
ATOM     75  N   ILE    13      45.828  21.453  65.605  1.00 23.30           N  
ATOM     76  CA  ILE    13      46.238  22.768  65.137  1.00 23.99           C  
ATOM     77  C   ILE    13      47.789  22.837  65.112  1.00 23.85           C  
ATOM     78  O   ILE    13      48.420  22.815  64.037  1.00 23.87           O  
ATOM     79  CB  ILE    13      45.632  23.862  66.060  1.00 22.93           C  
ATOM     80  CG1 ILE    13      44.086  23.825  65.985  1.00 24.81           C  
ATOM     81  CG2 ILE    13      46.199  25.239  65.708  1.00 23.98           C  
ATOM     82  CD1 ILE    13      43.379  24.872  66.896  1.00 24.97           C  
ATOM     83  N   ASP    14      48.402  22.882  66.293  1.00 24.30           N  
ATOM     84  CA  ASP    14      49.864  22.869  66.407  1.00 24.52           C  
ATOM     85  C   ASP    14      50.378  21.560  65.861  1.00 24.12           C  
ATOM     86  O   ASP    14      49.775  20.505  66.099  1.00 24.08           O  
ATOM     87  CB  ASP    14      50.303  23.017  67.872  1.00 25.34           C  
ATOM     88  CG  ASP    14      49.842  24.344  68.475  1.00 27.52           C  
ATOM     89  OD1 ASP    14      50.553  25.363  68.292  1.00 29.57           O  
ATOM     90  OD2 ASP    14      48.759  24.366  69.108  1.00 29.16           O  
ATOM     91  N   GLY    15      51.474  21.643  65.104  1.00 24.35           N  
ATOM     92  CA  GLY    15      52.109  20.442  64.523  1.00 24.03           C  
ATOM     93  C   GLY    15      51.370  19.759  63.375  1.00 24.06           C  
ATOM     94  O   GLY    15      51.829  18.728  62.915  1.00 24.44           O  
ATOM     95  N   ALA    16      50.237  20.303  62.919  1.00 24.06           N  
ATOM     96  CA  ALA    16      49.507  19.703  61.805  1.00 25.16           C  
ATOM     97  C   ALA    16      48.940  20.748  60.833  1.00 25.27           C  
ATOM     98  O   ALA    16      49.489  20.959  59.745  1.00 26.24           O  
ATOM     99  CB  ALA    16      48.424  18.744  62.299  1.00 25.08           C  
ATOM    100  N   LEU    17      47.865  21.415  61.239  1.00 24.72           N  
ATOM    101  CA  LEU    17      47.293  22.507  60.467  0.50 24.60           C  
ATOM    103  C   LEU    17      48.303  23.653  60.282  1.00 24.79           C  
ATOM    104  O   LEU    17      48.373  24.261  59.223  1.00 24.69           O  
ATOM    105  CB  LEU    17      46.048  23.045  61.188  0.50 24.67           C  
ATOM    107  CG  LEU    17      45.298  24.166  60.484  0.50 22.73           C  
ATOM    109  CD1 LEU    17      44.590  23.620  59.290  0.50 21.17           C  
ATOM    111  CD2 LEU    17      44.307  24.780  61.426  0.50 24.59           C  
ATOM    113  N   LEU    18      49.063  23.947  61.328  1.00 24.24           N  
ATOM    114  CA  LEU    18      49.948  25.112  61.313  1.00 24.06           C  
ATOM    115  C   LEU    18      51.362  24.684  61.027  1.00 23.97           C  
ATOM    116  O   LEU    18      51.832  23.682  61.581  1.00 23.46           O  
ATOM    117  CB  LEU    18      49.979  25.804  62.674  1.00 24.49           C  
ATOM    118  CG  LEU    18      48.695  26.396  63.242  1.00 26.89           C  
ATOM    119  CD1 LEU    18      49.022  27.243  64.441  1.00 28.82           C  
ATOM    120  CD2 LEU    18      47.977  27.204  62.171  1.00 30.68           C  
ATOM    121  N   ARG    19      52.048  25.466  60.196  1.00 22.83           N  
ATOM    122  CA  ARG    19      53.493  25.358  60.033  1.00 22.38           C  
ATOM    123  C   ARG    19      54.177  25.715  61.348  1.00 23.88           C  
ATOM    124  O   ARG    19      53.533  26.298  62.230  1.00 24.58           O  
ATOM    125  CB  ARG    19      53.948  26.318  58.936  1.00 21.76           C  
ATOM    126  CG  ARG    19      53.468  25.901  57.548  1.00 22.17           C  
ATOM    127  CD  ARG    19      53.934  26.920  56.486  1.00 22.97           C  
ATOM    128  NE  ARG    19      55.382  27.057  56.473  1.00 26.02           N  
ATOM    129  CZ  ARG    19      56.201  26.234  55.821  1.00 26.76           C  
ATOM    130  NH1 ARG    19      55.711  25.222  55.115  1.00 24.02           N  
ATOM    131  NH2 ARG    19      57.517  26.439  55.854  1.00 27.49           N  
ATOM    132  N   SER    20      55.474  25.442  61.480  1.00 23.98           N  
ATOM    133  CA  SER    20      56.170  25.724  62.749  0.50 24.69           C  
ATOM    135  C   SER    20      56.314  27.208  63.018  1.00 25.45           C  
ATOM    136  O   SER    20      56.571  27.609  64.158  1.00 27.08           O  
ATOM    137  CB  SER    20      57.532  25.038  62.816  0.50 24.83           C  
ATOM    139  OG  SER    20      58.378  25.470  61.782  0.50 22.79           O  
ATOM    141  N   ASN    21      56.145  28.033  61.990  1.00 25.31           N  
ATOM    142  CA  ASN    21      56.128  29.493  62.202  1.00 26.85           C  
ATOM    143  C   ASN    21      54.719  30.047  62.494  1.00 27.13           C  
ATOM    144  O   ASN    21      54.530  31.272  62.574  1.00 28.54           O  
ATOM    145  CB  ASN    21      56.766  30.217  61.013  1.00 27.65           C  
ATOM    146  CG  ASN    21      55.984  30.014  59.721  1.00 29.55           C  
ATOM    147  OD1 ASN    21      54.897  29.445  59.739  1.00 28.27           O  
ATOM    148  ND2 ASN    21      56.549  30.460  58.590  1.00 31.07           N  
ATOM    149  N   GLY    22      53.737  29.163  62.628  1.00 25.53           N  
ATOM    150  CA  GLY    22      52.387  29.527  63.002  1.00 25.70           C  
ATOM    151  C   GLY    22      51.485  29.910  61.853  1.00 25.79           C  
ATOM    152  O   GLY    22      50.292  30.178  62.058  1.00 27.47           O  
ATOM    153  N   LYS    23      52.021  29.911  60.645  1.00 24.24           N  
ATOM    154  CA  LYS    23      51.223  30.238  59.465  1.00 25.66           C  
ATOM    155  C   LYS    23      50.427  29.032  58.983  1.00 25.17           C  
ATOM    156  O   LYS    23      50.855  27.911  59.153  1.00 24.56           O  
ATOM    157  CB  LYS    23      52.117  30.762  58.330  1.00 25.43           C  
ATOM    158  CG  LYS    23      52.785  32.105  58.702  1.00 27.84           C  
ATOM    159  CD  LYS    23      53.244  32.848  57.454  1.00 30.68           C  
ATOM    160  CE  LYS    23      53.760  34.234  57.782  1.00 28.94           C  
ATOM    161  NZ  LYS    23      52.715  35.300  57.751  1.00 29.37           N  
ATOM    162  N   ILE    24      49.249  29.288  58.406  1.00 25.05           N  
ATOM    163  CA  ILE    24      48.492  28.250  57.692  1.00 24.61           C  
ATOM    164  C   ILE    24      48.836  28.392  56.223  1.00 24.55           C  
ATOM    165  O   ILE    24      48.561  29.435  55.618  1.00 23.98           O  
ATOM    166  CB  ILE    24      46.968  28.406  57.879  1.00 24.43           C  
ATOM    167  CG1 ILE    24      46.617  28.469  59.371  1.00 26.44           C  
ATOM    168  CG2 ILE    24      46.215  27.250  57.165  1.00 26.26           C  
ATOM    169  CD1 ILE    24      45.173  28.887  59.631  1.00 28.57           C  
ATOM    170  N   HIS    25      49.450  27.361  55.639  1.00 23.24           N  
ATOM    171  CA  HIS    25      49.853  27.392  54.219  1.00 23.46           C  
ATOM    172  C   HIS    25      48.615  27.448  53.296  1.00 23.13           C  
ATOM    173  O   HIS    25      47.581  26.857  53.600  1.00 22.32           O  
ATOM    174  CB  HIS    25      50.711  26.150  53.888  1.00 23.35           C  
ATOM    175  CG  HIS    25      51.489  26.271  52.617  1.00 24.93           C  
ATOM    176  ND1 HIS    25      50.970  25.915  51.391  1.00 25.91           N  
ATOM    177  CD2 HIS    25      52.750  26.707  52.383  1.00 25.47           C  
ATOM    178  CE1 HIS    25      51.877  26.134  50.452  1.00 29.41           C  
ATOM    179  NE2 HIS    25      52.966  26.617  51.029  1.00 27.47           N  
ATOM    180  N   GLN    26      48.711  28.178  52.186  1.00 23.33           N  
ATOM    181  CA  GLN    26      47.586  28.242  51.235  1.00 24.16           C  
ATOM    182  C   GLN    26      47.101  26.853  50.791  1.00 23.73           C  
ATOM    183  O   GLN    26      45.909  26.616  50.628  1.00 23.72           O  
ATOM    184  CB  GLN    26      47.951  29.079  50.005  1.00 25.56           C  
ATOM    185  CG  GLN    26      46.757  29.297  49.048  1.00 27.94           C  
ATOM    186  CD  GLN    26      45.643  30.104  49.695  1.00 29.07           C  
ATOM    187  OE1 GLN    26      45.884  31.167  50.253  1.00 31.50           O  
ATOM    188  NE2 GLN    26      44.424  29.598  49.627  1.00 31.03           N  
ATOM    189  N   ALA    27      48.026  25.925  50.620  1.00 23.38           N  
ATOM    190  CA  ALA    27      47.657  24.552  50.203  1.00 23.29           C  
ATOM    191  C   ALA    27      46.735  23.850  51.206  1.00 22.81           C  
ATOM    192  O   ALA    27      45.839  23.056  50.834  1.00 23.09           O  
ATOM    193  CB  ALA    27      48.915  23.708  49.930  1.00 22.66           C  
ATOM    194  N   THR    28      46.933  24.179  52.474  1.00 22.59           N  
ATOM    195  CA  THR    28      46.164  23.629  53.542  1.00 22.61           C  
ATOM    196  C   THR    28      44.731  24.189  53.494  1.00 22.57           C  
ATOM    197  O   THR    28      43.758  23.433  53.647  1.00 21.44           O  
ATOM    198  CB  THR    28      46.837  23.968  54.896  1.00 22.91           C  
ATOM    199  OG1 THR    28      48.216  23.533  54.845  1.00 24.83           O  
ATOM    200  CG2 THR    28      46.126  23.252  56.001  1.00 22.58           C  
ATOM    201  N   LYS    29      44.627  25.501  53.288  1.00 22.30           N  
ATOM    202  CA  LYS    29      43.359  26.181  53.109  1.00 23.06           C  
ATOM    203  C   LYS    29      42.612  25.581  51.924  1.00 23.15           C  
ATOM    204  O   LYS    29      41.420  25.279  52.029  1.00 22.86           O  
ATOM    205  CB  LYS    29      43.599  27.683  52.910  1.00 23.25           C  
ATOM    206  CG  LYS    29      44.128  28.315  54.166  1.00 26.35           C  
ATOM    207  CD  LYS    29      44.230  29.796  54.031  1.00 31.59           C  
ATOM    208  CE  LYS    29      44.681  30.363  55.349  1.00 34.35           C  
ATOM    209  NZ  LYS    29      44.844  31.817  55.183  1.00 37.71           N  
ATOM    210  N   ASP    30      43.318  25.381  50.805  1.00 23.81           N  
ATOM    211  CA  ASP    30      42.702  24.826  49.608  1.00 24.01           C  
ATOM    212  C   ASP    30      42.220  23.391  49.847  1.00 23.94           C  
ATOM    213  O   ASP    30      41.125  23.013  49.411  1.00 23.20           O  
ATOM    214  CB  ASP    30      43.652  24.895  48.400  1.00 24.83           C  
ATOM    215  CG  ASP    30      44.001  26.344  47.987  1.00 28.08           C  
ATOM    216  OD1 ASP    30      43.319  27.297  48.421  1.00 31.03           O  
ATOM    217  OD2 ASP    30      44.973  26.531  47.207  1.00 30.74           O  
ATOM    218  N   ALA    31      43.032  22.600  50.554  1.00 22.91           N  
ATOM    219  CA  ALA    31      42.656  21.219  50.851  1.00 23.25           C  
ATOM    220  C   ALA    31      41.406  21.159  51.735  1.00 22.86           C  
ATOM    221  O   ALA    31      40.491  20.378  51.456  1.00 23.53           O  
ATOM    222  CB  ALA    31      43.832  20.452  51.501  1.00 22.70           C  
ATOM    223  N   ILE    32      41.345  22.004  52.763  1.00 22.86           N  
ATOM    224  CA  ILE    32      40.174  22.022  53.676  1.00 24.08           C  
ATOM    225  C   ILE    32      38.897  22.482  52.960  1.00 24.09           C  
ATOM    226  O   ILE    32      37.834  21.899  53.157  1.00 23.39           O  
ATOM    227  CB  ILE    32      40.478  22.819  54.970  1.00 24.17           C  
ATOM    228  CG1 ILE    32      41.480  22.018  55.828  1.00 26.95           C  
ATOM    229  CG2 ILE    32      39.216  23.101  55.802  1.00 25.00           C  
ATOM    230  CD1 ILE    32      42.097  22.820  56.869  1.00 33.14           C  
ATOM    231  N   GLU    33      39.009  23.502  52.110  1.00 25.36           N  
ATOM    232  CA  GLU    33      37.880  23.960  51.299  1.00 27.05           C  
ATOM    233  C   GLU    33      37.351  22.819  50.425  1.00 26.16           C  
ATOM    234  O   GLU    33      36.147  22.583  50.344  1.00 26.64           O  
ATOM    235  CB  GLU    33      38.326  25.123  50.405  1.00 27.23           C  
ATOM    236  CG  GLU    33      37.236  25.620  49.481  1.00 29.62           C  
ATOM    237  CD  GLU    33      37.638  26.869  48.708  1.00 32.79           C  
ATOM    238  OE1 GLU    33      38.853  27.052  48.407  1.00 39.72           O  
ATOM    239  OE2 GLU    33      36.724  27.664  48.377  1.00 40.81           O  
ATOM    240  N   TYR    34      38.261  22.092  49.793  1.00 24.96           N  
ATOM    241  CA  TYR    34      37.861  20.961  48.968  1.00 25.67           C  
ATOM    242  C   TYR    34      37.136  19.878  49.790  1.00 25.32           C  
ATOM    243  O   TYR    34      36.093  19.371  49.368  1.00 26.28           O  
ATOM    244  CB  TYR    34      39.080  20.371  48.269  1.00 26.00           C  
ATOM    245  CG  TYR    34      38.715  19.304  47.255  1.00 27.85           C  
ATOM    246  CD1 TYR    34      38.370  19.649  45.954  1.00 28.71           C  
ATOM    247  CD2 TYR    34      38.702  17.955  47.609  1.00 28.41           C  
ATOM    248  CE1 TYR    34      38.040  18.675  45.016  1.00 30.02           C  
ATOM    249  CE2 TYR    34      38.376  16.967  46.676  1.00 30.06           C  
ATOM    250  CZ  TYR    34      38.041  17.339  45.392  1.00 29.85           C  
ATOM    251  OH  TYR    34      37.703  16.375  44.472  1.00 31.87           O  
ATOM    252  N   VAL    35      37.707  19.518  50.936  1.00 24.93           N  
ATOM    253  CA  VAL    35      37.145  18.495  51.844  1.00 25.76           C  
ATOM    254  C   VAL    35      35.690  18.832  52.214  1.00 26.68           C  
ATOM    255  O   VAL    35      34.787  17.983  52.122  1.00 26.22           O  
ATOM    256  CB  VAL    35      38.010  18.369  53.144  1.00 25.70           C  
ATOM    257  CG1 VAL    35      37.301  17.518  54.201  1.00 25.36           C  
ATOM    258  CG2 VAL    35      39.396  17.791  52.816  1.00 27.20           C  
ATOM    259  N   LYS    36      35.484  20.081  52.631  1.00 26.28           N  
ATOM    260  CA  LYS    36      34.158  20.606  52.971  1.00 27.35           C  
ATOM    261  C   LYS    36      33.184  20.574  51.782  1.00 28.31           C  
ATOM    262  O   LYS    36      32.012  20.256  51.950  1.00 28.21           O  
ATOM    263  CB  LYS    36      34.298  22.018  53.522  1.00 27.03           C  
ATOM    264  CG  LYS    36      34.806  22.052  54.954  1.00 28.56           C  
ATOM    265  CD  LYS    36      34.950  23.494  55.483  1.00 27.72           C  
ATOM    266  CE  LYS    36      33.587  24.133  55.783  1.00 32.60           C  
ATOM    267  NZ  LYS    36      32.768  23.365  56.795  1.00 34.40           N  
ATOM    268  N   LYS    37      33.679  20.892  50.589  1.00 29.26           N  
ATOM    269  CA  LYS    37      32.875  20.910  49.367  1.00 31.00           C  
ATOM    270  C   LYS    37      32.397  19.483  49.050  1.00 30.88           C  
ATOM    271  O   LYS    37      31.316  19.287  48.493  1.00 30.71           O  
ATOM    272  CB  LYS    37      33.714  21.498  48.216  1.00 30.85           C  
ATOM    273  CG  LYS    37      32.965  21.866  46.941  1.00 33.81           C  
ATOM    274  CD  LYS    37      33.954  22.296  45.849  1.00 33.63           C  
ATOM    275  CE  LYS    37      33.263  22.487  44.506  1.00 37.30           C  
ATOM    276  NZ  LYS    37      34.147  22.033  43.390  1.00 40.68           N  
ATOM    277  N   LYS    38      33.195  18.495  49.455  1.00 31.07           N  
ATOM    278  CA  LYS    38      32.858  17.080  49.266  1.00 31.54           C  
ATOM    279  C   LYS    38      31.920  16.521  50.339  1.00 31.64           C  
ATOM    280  O   LYS    38      31.583  15.336  50.311  1.00 32.09           O  
ATOM    281  CB  LYS    38      34.130  16.235  49.180  1.00 31.54           C  
ATOM    282  CG  LYS    38      34.977  16.547  47.962  1.00 33.50           C  
ATOM    283  CD  LYS    38      34.261  16.225  46.641  1.00 37.72           C  
ATOM    284  CE  LYS    38      34.129  14.711  46.450  1.00 41.39           C  
ATOM    285  NZ  LYS    38      33.660  14.331  45.082  1.00 42.99           N  
ATOM    286  N   GLY    39      31.523  17.364  51.288  1.00 30.54           N  
ATOM    287  CA  GLY    39      30.557  16.984  52.308  1.00 30.28           C  
ATOM    288  C   GLY    39      31.143  16.408  53.584  1.00 29.53           C  
ATOM    289  O   GLY    39      30.408  15.969  54.465  1.00 30.24           O  
ATOM    290  N   ILE    40      32.463  16.437  53.714  1.00 28.20           N  
ATOM    291  CA  ILE    40      33.113  15.914  54.912  1.00 27.30           C  
ATOM    292  C   ILE    40      33.134  16.977  56.021  1.00 26.53           C  
ATOM    293  O   ILE    40      33.489  18.126  55.766  1.00 25.76           O  
ATOM    294  CB  ILE    40      34.545  15.411  54.560  1.00 26.64           C  
ATOM    295  CG1 ILE    40      34.433  14.216  53.596  1.00 28.03           C  
ATOM    296  CG2 ILE    40      35.357  15.077  55.834  1.00 25.77           C  
ATOM    297  CD1 ILE    40      35.690  13.989  52.719  1.00 26.43           C  
ATOM    298  N   TYR    41      32.759  16.591  57.243  1.00 26.02           N  
ATOM    299  CA  TYR    41      32.716  17.522  58.373  1.00 25.38           C  
ATOM    300  C   TYR    41      34.156  17.697  58.843  1.00 25.27           C  
ATOM    301  O   TYR    41      34.865  16.693  59.047  1.00 24.68           O  
ATOM    302  CB  TYR    41      31.909  16.899  59.494  1.00 26.37           C  
ATOM    303  CG  TYR    41      31.554  17.785  60.700  1.00 27.48           C  
ATOM    304  CD1 TYR    41      30.309  18.382  60.786  1.00 28.59           C  
ATOM    305  CD2 TYR    41      32.450  17.970  61.775  1.00 28.27           C  
ATOM    306  CE1 TYR    41      29.947  19.155  61.889  1.00 29.47           C  
ATOM    307  CE2 TYR    41      32.092  18.754  62.897  1.00 29.43           C  
ATOM    308  CZ  TYR    41      30.827  19.332  62.936  1.00 29.11           C  
ATOM    309  OH  TYR    41      30.409  20.096  64.013  1.00 28.75           O  
ATOM    310  N   VAL    42      34.608  18.942  58.958  1.00 23.79           N  
ATOM    311  CA  VAL    42      36.002  19.208  59.371  1.00 23.71           C  
ATOM    312  C   VAL    42      36.002  19.914  60.731  1.00 24.94           C  
ATOM    313  O   VAL    42      35.384  20.981  60.907  1.00 25.46           O  
ATOM    314  CB  VAL    42      36.794  20.060  58.336  1.00 22.33           C  
ATOM    315  CG1 VAL    42      38.207  20.363  58.867  1.00 24.54           C  
ATOM    316  CG2 VAL    42      36.846  19.387  56.961  1.00 20.26           C  
ATOM    317  N   THR    43      36.712  19.341  61.692  1.00 25.37           N  
ATOM    318  CA  THR    43      36.816  19.992  62.990  1.00 26.04           C  
ATOM    319  C   THR    43      38.256  19.976  63.496  1.00 24.85           C  
ATOM    320  O   THR    43      39.131  19.283  62.926  1.00 25.08           O  
ATOM    321  CB  THR    43      35.881  19.367  64.023  1.00 26.77           C  
ATOM    322  OG1 THR    43      35.868  20.214  65.194  1.00 30.70           O  
ATOM    323  CG2 THR    43      36.333  17.945  64.392  1.00 26.35           C  
ATOM    324  N   LEU    44      38.480  20.721  64.568  1.00 23.09           N  
ATOM    325  CA  LEU    44      39.802  20.826  65.170  1.00 23.27           C  
ATOM    326  C   LEU    44      39.761  20.093  66.507  1.00 23.03           C  
ATOM    327  O   LEU    44      38.747  20.137  67.234  1.00 24.38           O  
ATOM    328  CB  LEU    44      40.193  22.306  65.365  1.00 22.31           C  
ATOM    329  CG  LEU    44      40.108  23.141  64.071  1.00 23.25           C  
ATOM    330  CD1 LEU    44      40.439  24.642  64.366  1.00 26.01           C  
ATOM    331  CD2 LEU    44      41.059  22.559  62.992  1.00 25.08           C  
ATOM    332  N   VAL    45      40.835  19.370  66.799  1.00 22.18           N  
ATOM    333  CA  VAL    45      40.983  18.659  68.061  0.50 22.15           C  
ATOM    335  C   VAL    45      42.315  19.106  68.647  1.00 22.54           C  
ATOM    336  O   VAL    45      43.365  18.795  68.091  1.00 23.44           O  
ATOM    337  CB  VAL    45      40.882  17.111  67.863  0.50 22.53           C  
ATOM    339  CG1 VAL    45      41.743  16.626  66.699  0.50 20.55           C  
ATOM    341  CG2 VAL    45      41.216  16.364  69.150  0.50 22.45           C  
ATOM    343  N   THR    46      42.268  19.832  69.763  1.00 21.76           N  
ATOM    344  CA  THR    46      43.431  20.613  70.192  1.00 21.81           C  
ATOM    345  C   THR    46      43.554  20.762  71.691  1.00 21.47           C  
ATOM    346  O   THR    46      42.546  20.719  72.425  1.00 21.29           O  
ATOM    347  CB  THR    46      43.389  22.038  69.512  1.00 23.35           C  
ATOM    348  OG1 THR    46      44.618  22.725  69.750  1.00 23.07           O  
ATOM    349  CG2 THR    46      42.189  22.914  70.046  1.00 24.16           C  
ATOM    350  N   ASN    47      44.793  20.935  72.130  1.00 21.21           N  
ATOM    351  CA  ASN    47      45.074  21.417  73.490  1.00 22.60           C  
ATOM    352  C   ASN    47      44.889  22.927  73.644  1.00 22.42           C  
ATOM    353  O   ASN    47      44.891  23.422  74.773  1.00 22.92           O  
ATOM    354  CB  ASN    47      46.514  21.061  73.901  1.00 22.46           C  
ATOM    355  CG  ASN    47      46.706  19.558  74.061  1.00 25.07           C  
ATOM    356  OD1 ASN    47      45.756  18.830  74.350  1.00 28.70           O  
ATOM    357  ND2 ASN    47      47.919  19.099  73.874  1.00 26.45           N  
ATOM    358  N   ARG    48      44.766  23.642  72.527  1.00 21.70           N  
ATOM    359  CA  ARG    48      44.621  25.128  72.590  1.00 22.31           C  
ATOM    360  C   ARG    48      43.334  25.546  73.281  1.00 21.33           C  
ATOM    361  O   ARG    48      42.367  24.793  73.281  1.00 21.43           O  
ATOM    362  CB  ARG    48      44.602  25.701  71.185  1.00 22.83           C  
ATOM    363  CG  ARG    48      46.020  25.748  70.580  1.00 26.34           C  
ATOM    364  CD  ARG    48      46.039  26.722  69.403  1.00 27.37           C  
ATOM    365  NE  ARG    48      47.403  26.804  68.879  1.00 28.67           N  
ATOM    366  CZ  ARG    48      47.886  27.842  68.223  1.00 30.50           C  
ATOM    367  NH1 ARG    48      47.106  28.904  68.015  1.00 30.63           N  
ATOM    368  NH2 ARG    48      49.151  27.813  67.782  1.00 28.11           N  
ATOM    369  N   HIS    49      43.340  26.753  73.837  1.00 20.28           N  
ATOM    370  CA  HIS    49      42.122  27.286  74.438  1.00 20.93           C  
ATOM    371  C   HIS    49      41.112  27.590  73.339  1.00 20.60           C  
ATOM    372  O   HIS    49      41.482  27.707  72.139  1.00 19.38           O  
ATOM    373  CB  HIS    49      42.432  28.486  75.362  1.00 20.36           C  
ATOM    374  CG  HIS    49      43.039  29.684  74.687  1.00 22.13           C  
ATOM    375  ND1 HIS    49      42.293  30.600  73.965  1.00 22.00           N  
ATOM    376  CD2 HIS    49      44.310  30.157  74.690  1.00 22.70           C  
ATOM    377  CE1 HIS    49      43.080  31.580  73.543  1.00 23.02           C  
ATOM    378  NE2 HIS    49      44.305  31.349  73.992  1.00 23.55           N  
ATOM    379  N   PHE    50      39.838  27.646  73.725  1.00 20.17           N  
ATOM    380  CA  PHE    50      38.758  27.704  72.750  1.00 20.73           C  
ATOM    381  C   PHE    50      38.892  28.914  71.799  1.00 21.11           C  
ATOM    382  O   PHE    50      38.740  28.799  70.551  1.00 21.34           O  
ATOM    383  CB  PHE    50      37.368  27.777  73.419  1.00 20.96           C  
ATOM    384  CG  PHE    50      36.269  27.807  72.391  1.00 21.48           C  
ATOM    385  CD1 PHE    50      35.951  26.638  71.710  1.00 21.51           C  
ATOM    386  CD2 PHE    50      35.669  29.013  72.009  1.00 22.59           C  
ATOM    387  CE1 PHE    50      34.993  26.646  70.684  1.00 23.30           C  
ATOM    388  CE2 PHE    50      34.695  29.024  70.990  1.00 20.94           C  
ATOM    389  CZ  PHE    50      34.356  27.834  70.344  1.00 20.08           C  
ATOM    390  N   ARG    51      39.145  30.075  72.377  1.00 20.54           N  
ATOM    391  CA  ARG    51      39.239  31.285  71.582  1.00 20.39           C  
ATOM    392  C   ARG    51      40.305  31.191  70.466  1.00 20.64           C  
ATOM    393  O   ARG    51      40.025  31.535  69.318  1.00 20.00           O  
ATOM    394  CB  ARG    51      39.476  32.492  72.485  1.00 21.15           C  
ATOM    395  CG  ARG    51      39.698  33.770  71.707  1.00 22.28           C  
ATOM    396  CD  ARG    51      39.879  34.931  72.698  1.00 21.76           C  
ATOM    397  NE  ARG    51      40.420  36.050  71.947  1.00 26.25           N  
ATOM    398  CZ  ARG    51      39.656  36.881  71.238  1.00 25.66           C  
ATOM    399  NH1 ARG    51      38.323  36.734  71.227  1.00 21.50           N  
ATOM    400  NH2 ARG    51      40.228  37.864  70.570  1.00 22.78           N  
ATOM    401  N   SER    52      41.501  30.708  70.784  1.00 20.61           N  
ATOM    402  CA  SER    52      42.523  30.554  69.758  1.00 22.63           C  
ATOM    403  C   SER    52      42.037  29.592  68.651  1.00 22.74           C  
ATOM    404  O   SER    52      42.141  29.902  67.431  1.00 21.96           O  
ATOM    405  CB  SER    52      43.832  30.074  70.387  1.00 22.87           C  
ATOM    406  OG  SER    52      44.788  29.862  69.357  1.00 26.87           O  
ATOM    407  N   ALA    53      41.493  28.437  69.060  1.00 20.89           N  
ATOM    408  CA  ALA    53      40.951  27.451  68.102  1.00 22.06           C  
ATOM    409  C   ALA    53      39.863  28.060  67.190  1.00 22.53           C  
ATOM    410  O   ALA    53      39.842  27.822  65.971  1.00 21.42           O  
ATOM    411  CB  ALA    53      40.381  26.209  68.844  1.00 20.73           C  
ATOM    412  N   GLN    54      38.972  28.852  67.784  1.00 21.77           N  
ATOM    413  CA  GLN    54      37.863  29.434  67.034  1.00 22.99           C  
ATOM    414  C   GLN    54      38.352  30.471  66.008  1.00 23.32           C  
ATOM    415  O   GLN    54      37.810  30.553  64.902  1.00 22.70           O  
ATOM    416  CB  GLN    54      36.818  30.043  67.983  1.00 23.51           C  
ATOM    417  CG  GLN    54      35.409  30.303  67.345  1.00 25.23           C  
ATOM    418  CD  GLN    54      35.338  31.586  66.526  1.00 29.86           C  
ATOM    419  OE1 GLN    54      36.043  32.576  66.813  1.00 25.97           O  
ATOM    420  NE2 GLN    54      34.484  31.573  65.470  1.00 31.74           N  
ATOM    421  N   LYS    55      39.360  31.270  66.354  1.00 22.59           N  
ATOM    422  CA  LYS    55      39.867  32.236  65.362  1.00 23.42           C  
ATOM    423  C   LYS    55      40.453  31.500  64.160  1.00 23.55           C  
ATOM    424  O   LYS    55      40.245  31.914  63.011  1.00 23.20           O  
ATOM    425  CB  LYS    55      40.909  33.165  65.993  1.00 23.58           C  
ATOM    426  CG  LYS    55      40.316  34.052  67.114  1.00 25.05           C  
ATOM    427  CD  LYS    55      39.268  35.041  66.621  1.00 27.47           C  
ATOM    428  CE  LYS    55      38.929  36.141  67.677  1.00 26.35           C  
ATOM    429  NZ  LYS    55      37.822  37.000  67.145  1.00 27.23           N  
ATOM    430  N   ILE    56      41.144  30.398  64.429  1.00 23.00           N  
ATOM    431  CA  ILE    56      41.709  29.540  63.366  1.00 24.02           C  
ATOM    432  C   ILE    56      40.572  28.924  62.527  1.00 23.51           C  
ATOM    433  O   ILE    56      40.601  28.985  61.296  1.00 22.40           O  
ATOM    434  CB  ILE    56      42.641  28.470  63.951  1.00 24.23           C  
ATOM    435  CG1 ILE    56      43.923  29.147  64.465  1.00 27.31           C  
ATOM    436  CG2 ILE    56      42.995  27.421  62.871  1.00 24.80           C  
ATOM    437  CD1 ILE    56      44.653  28.378  65.516  1.00 31.44           C  
ATOM    438  N   ALA    57      39.573  28.359  63.202  1.00 22.14           N  
ATOM    439  CA  ALA    57      38.357  27.865  62.520  1.00 22.65           C  
ATOM    440  C   ALA    57      37.681  28.943  61.649  1.00 23.56           C  
ATOM    441  O   ALA    57      37.234  28.665  60.517  1.00 24.43           O  
ATOM    442  CB  ALA    57      37.370  27.325  63.533  1.00 22.21           C  
ATOM    443  N   LYS    58      37.629  30.177  62.144  1.00 24.66           N  
ATOM    444  CA  LYS    58      37.056  31.275  61.381  1.00 26.83           C  
ATOM    445  C   LYS    58      37.842  31.502  60.081  1.00 26.21           C  
ATOM    446  O   LYS    58      37.247  31.711  59.014  1.00 26.97           O  
ATOM    447  CB  LYS    58      36.992  32.552  62.238  1.00 26.20           C  
ATOM    448  CG  LYS    58      36.160  33.654  61.624  1.00 28.89           C  
ATOM    449  CD  LYS    58      36.119  34.893  62.548  1.00 30.34           C  
ATOM    450  CE  LYS    58      35.429  36.020  61.816  1.00 36.90           C  
ATOM    451  NZ  LYS    58      35.490  37.304  62.544  1.00 39.28           N  
ATOM    452  N   SER    59      39.164  31.428  60.166  1.00 26.49           N  
ATOM    453  CA  SER    59      40.052  31.595  58.999  0.50 26.74           C  
ATOM    455  C   SER    59      39.793  30.531  57.939  1.00 27.28           C  
ATOM    456  O   SER    59      39.928  30.787  56.723  1.00 27.35           O  
ATOM    457  CB  SER    59      41.516  31.523  59.432  0.50 26.35           C  
ATOM    459  OG  SER    59      41.897  32.723  60.090  0.50 27.19           O  
ATOM    461  N   LEU    60      39.447  29.331  58.416  1.00 25.49           N  
ATOM    462  CA  LEU    60      39.179  28.172  57.546  1.00 26.35           C  
ATOM    463  C   LEU    60      37.705  28.037  57.199  1.00 26.59           C  
ATOM    464  O   LEU    60      37.310  27.069  56.526  1.00 26.80           O  
ATOM    465  CB  LEU    60      39.656  26.886  58.228  1.00 25.25           C  
ATOM    466  CG  LEU    60      41.138  26.779  58.538  1.00 27.58           C  
ATOM    467  CD1 LEU    60      41.387  25.562  59.387  1.00 28.20           C  
ATOM    468  CD2 LEU    60      41.902  26.711  57.211  1.00 28.42           C  
ATOM    469  N   LYS    61      36.897  28.989  57.665  1.00 27.23           N  
ATOM    470  CA  LYS    61      35.432  28.981  57.478  1.00 28.49           C  
ATOM    471  C   LYS    61      34.784  27.641  57.908  1.00 27.82           C  
ATOM    472  O   LYS    61      33.917  27.112  57.198  1.00 27.47           O  
ATOM    473  CB  LYS    61      35.076  29.295  56.004  1.00 28.70           C  
ATOM    474  CG  LYS    61      35.668  30.598  55.463  1.00 30.96           C  
ATOM    475  CD  LYS    61      35.543  30.753  53.935  1.00 32.09           C  
ATOM    476  CE  LYS    61      36.849  30.335  53.258  1.00 36.97           C  
ATOM    477  NZ  LYS    61      36.860  30.655  51.781  1.00 41.53           N  
ATOM    478  N   LEU    62      35.190  27.089  59.048  1.00 26.95           N  
ATOM    479  CA  LEU    62      34.717  25.753  59.448  1.00 27.46           C  
ATOM    480  C   LEU    62      33.252  25.648  59.899  1.00 29.60           C  
ATOM    481  O   LEU    62      32.591  24.655  59.602  1.00 30.44           O  
ATOM    482  CB  LEU    62      35.586  25.149  60.542  1.00 26.53           C  
ATOM    483  CG  LEU    62      37.049  24.843  60.217  1.00 26.51           C  
ATOM    484  CD1 LEU    62      37.672  24.005  61.374  1.00 25.49           C  
ATOM    485  CD2 LEU    62      37.160  24.116  58.867  1.00 25.94           C  
ATOM    486  N   ASP    63      32.775  26.618  60.661  1.00 31.37           N  
ATOM    487  CA  ASP    63      31.447  26.481  61.308  1.00 34.07           C  
ATOM    488  C   ASP    63      31.144  25.066  61.854  1.00 33.74           C  
ATOM    489  O   ASP    63      30.177  24.419  61.456  1.00 35.61           O  
ATOM    490  CB  ASP    63      30.357  26.950  60.343  1.00 35.41           C  
ATOM    491  CG  ASP    63      30.539  28.405  59.959  1.00 39.11           C  
ATOM    492  OD1 ASP    63      30.700  29.246  60.888  1.00 41.22           O  
ATOM    493  OD2 ASP    63      30.551  28.698  58.739  1.00 43.66           O  
ATOM    494  N   ALA    64      31.990  24.589  62.757  1.00 32.83           N  
ATOM    495  CA  ALA    64      31.909  23.216  63.257  1.00 30.86           C  
ATOM    496  C   ALA    64      32.060  23.248  64.770  1.00 29.07           C  
ATOM    497  O   ALA    64      32.556  24.223  65.310  1.00 29.36           O  
ATOM    498  CB  ALA    64      33.030  22.400  62.660  1.00 32.36           C  
ATOM    499  N   LYS    65      31.665  22.172  65.445  1.00 27.04           N  
ATOM    500  CA  LYS    65      31.967  22.001  66.873  1.00 25.79           C  
ATOM    501  C   LYS    65      33.456  21.687  67.034  1.00 24.88           C  
ATOM    502  O   LYS    65      33.943  20.690  66.483  1.00 26.80           O  
ATOM    503  CB  LYS    65      31.145  20.861  67.467  1.00 26.09           C  
ATOM    504  CG  LYS    65      29.645  21.189  67.709  1.00 24.81           C  
ATOM    505  CD  LYS    65      28.846  19.911  68.020  1.00 27.18           C  
ATOM    506  CE  LYS    65      27.327  20.155  68.132  1.00 30.13           C  
ATOM    507  NZ  LYS    65      26.732  20.900  66.973  1.00 31.93           N  
ATOM    508  N   LEU    66      34.169  22.513  67.793  1.00 22.23           N  
ATOM    509  CA  LEU    66      35.607  22.356  67.914  1.00 21.65           C  
ATOM    510  C   LEU    66      35.872  21.678  69.255  1.00 21.94           C  
ATOM    511  O   LEU    66      35.179  21.973  70.250  1.00 21.43           O  
ATOM    512  CB  LEU    66      36.280  23.737  67.899  1.00 21.77           C  
ATOM    513  CG  LEU    66      35.849  24.630  66.719  1.00 21.08           C  
ATOM    514  CD1 LEU    66      36.443  26.057  66.921  1.00 23.95           C  
ATOM    515  CD2 LEU    66      36.285  24.034  65.394  1.00 21.87           C  
ATOM    516  N   ILE    67      36.851  20.786  69.274  1.00 21.05           N  
ATOM    517  CA  ILE    67      37.226  20.056  70.494  1.00 21.79           C  
ATOM    518  C   ILE    67      38.489  20.699  71.055  1.00 21.05           C  
ATOM    519  O   ILE    67      39.567  20.585  70.479  1.00 20.88           O  
ATOM    520  CB  ILE    67      37.438  18.545  70.200  1.00 22.27           C  
ATOM    521  CG1 ILE    67      36.119  17.950  69.663  1.00 24.26           C  
ATOM    522  CG2 ILE    67      37.846  17.799  71.502  1.00 21.10           C  
ATOM    523  CD1 ILE    67      36.317  16.897  68.631  1.00 27.11           C  
ATOM    524  N   THR    68      38.335  21.429  72.157  1.00 19.41           N  
ATOM    525  CA  THR    68      39.412  22.313  72.640  1.00 19.84           C  
ATOM    526  C   THR    68      39.685  22.018  74.123  1.00 19.61           C  
ATOM    527  O   THR    68      38.961  21.215  74.761  1.00 20.40           O  
ATOM    528  CB  THR    68      39.033  23.825  72.394  1.00 19.80           C  
ATOM    529  OG1 THR    68      38.006  24.217  73.305  1.00 19.77           O  
ATOM    530  CG2 THR    68      38.499  23.997  70.973  1.00 21.02           C  
ATOM    531  N   HIS    69      40.721  22.659  74.663  1.00 19.41           N  
ATOM    532  CA  HIS    69      41.147  22.453  76.055  1.00 19.78           C  
ATOM    533  C   HIS    69      41.289  20.937  76.284  1.00 20.78           C  
ATOM    534  O   HIS    69      40.790  20.420  77.295  1.00 20.95           O  
ATOM    535  CB  HIS    69      40.138  23.082  77.062  1.00 19.33           C  
ATOM    536  CG  HIS    69      40.027  24.582  76.972  1.00 19.21           C  
ATOM    537  ND1 HIS    69      40.623  25.425  77.886  1.00 18.89           N  
ATOM    538  CD2 HIS    69      39.384  25.384  76.083  1.00 19.50           C  
ATOM    539  CE1 HIS    69      40.328  26.686  77.581  1.00 18.35           C  
ATOM    540  NE2 HIS    69      39.569  26.686  76.493  1.00 19.29           N  
ATOM    541  N   SER    70      41.930  20.221  75.335  1.00 20.83           N  
ATOM    542  CA  SER    70      42.220  18.789  75.517  0.50 21.41           C  
ATOM    544  C   SER    70      40.949  17.908  75.620  1.00 22.14           C  
ATOM    545  O   SER    70      40.992  16.797  76.208  1.00 22.78           O  
ATOM    546  CB  SER    70      43.086  18.618  76.773  0.50 21.80           C  
ATOM    548  OG  SER    70      43.785  17.398  76.758  0.50 21.52           O  
ATOM    550  N   GLY    71      39.823  18.399  75.087  1.00 21.30           N  
ATOM    551  CA  GLY    71      38.531  17.682  75.145  1.00 21.84           C  
ATOM    552  C   GLY    71      37.566  18.176  76.216  1.00 20.49           C  
ATOM    553  O   GLY    71      36.451  17.666  76.334  1.00 22.40           O  
ATOM    554  N   ALA    72      38.003  19.123  77.053  1.00 19.92           N  
ATOM    555  CA  ALA    72      37.170  19.600  78.164  1.00 20.96           C  
ATOM    556  C   ALA    72      36.155  20.646  77.731  1.00 21.33           C  
ATOM    557  O   ALA    72      35.248  20.972  78.484  1.00 22.16           O  
ATOM    558  CB  ALA    72      38.064  20.183  79.302  1.00 21.39           C  
ATOM    559  N   TYR    73      36.331  21.205  76.536  1.00 21.33           N  
ATOM    560  CA  TYR    73      35.467  22.316  76.085  1.00 21.67           C  
ATOM    561  C   TYR    73      35.156  22.166  74.603  1.00 21.49           C  
ATOM    562  O   TYR    73      36.061  22.265  73.755  1.00 21.48           O  
ATOM    563  CB  TYR    73      36.119  23.682  76.371  1.00 21.37           C  
ATOM    564  CG  TYR    73      35.080  24.761  76.456  1.00 21.71           C  
ATOM    565  CD1 TYR    73      34.381  24.960  77.663  1.00 23.03           C  
ATOM    566  CD2 TYR    73      34.778  25.582  75.357  1.00 23.35           C  
ATOM    567  CE1 TYR    73      33.374  25.928  77.776  1.00 26.01           C  
ATOM    568  CE2 TYR    73      33.747  26.588  75.461  1.00 21.42           C  
ATOM    569  CZ  TYR    73      33.081  26.748  76.670  1.00 25.65           C  
ATOM    570  OH  TYR    73      32.096  27.695  76.850  1.00 24.71           O  
ATOM    571  N   ILE    74      33.904  21.843  74.281  1.00 21.45           N  
ATOM    572  CA  ILE    74      33.530  21.515  72.889  1.00 21.25           C  
ATOM    573  C   ILE    74      32.403  22.451  72.530  1.00 21.83           C  
ATOM    574  O   ILE    74      31.382  22.491  73.221  1.00 21.41           O  
ATOM    575  CB  ILE    74      33.079  20.030  72.706  1.00 21.10           C  
ATOM    576  CG1 ILE    74      34.181  19.066  73.213  1.00 21.25           C  
ATOM    577  CG2 ILE    74      32.687  19.744  71.221  1.00 21.03           C  
ATOM    578  CD1 ILE    74      33.749  17.567  73.338  1.00 21.33           C  
ATOM    579  N   ALA    75      32.616  23.242  71.483  1.00 21.36           N  
ATOM    580  CA  ALA    75      31.686  24.331  71.193  1.00 21.45           C  
ATOM    581  C   ALA    75      31.867  24.891  69.799  1.00 21.63           C  
ATOM    582  O   ALA    75      32.903  24.688  69.162  1.00 20.86           O  
ATOM    583  CB  ALA    75      31.899  25.494  72.243  1.00 21.22           C  
ATOM    584  N   GLU    76      30.827  25.558  69.314  1.00 22.41           N  
ATOM    585  CA  GLU    76      30.984  26.384  68.125  0.50 22.73           C  
ATOM    587  C   GLU    76      31.083  27.854  68.505  1.00 23.14           C  
ATOM    588  O   GLU    76      31.827  28.629  67.858  1.00 23.26           O  
ATOM    589  CB  GLU    76      29.854  26.166  67.128  0.50 22.55           C  
ATOM    591  CG  GLU    76      30.171  26.782  65.765  0.50 23.11           C  
ATOM    593  CD  GLU    76      29.105  26.535  64.712  0.50 24.63           C  
ATOM    595  OE1 GLU    76      28.124  25.806  64.978  0.50 25.39           O  
ATOM    597  OE2 GLU    76      29.248  27.108  63.616  0.50 22.88           O  
ATOM    599  N   LYS    77      30.382  28.242  69.569  1.00 23.36           N  
ATOM    600  CA  LYS    77      30.450  29.622  70.066  1.00 24.10           C  
ATOM    601  C   LYS    77      30.680  29.580  71.569  1.00 22.97           C  
ATOM    602  O   LYS    77      30.090  28.767  72.269  1.00 22.29           O  
ATOM    603  CB  LYS    77      29.171  30.410  69.739  1.00 24.74           C  
ATOM    604  CG  LYS    77      28.963  30.705  68.229  1.00 25.92           C  
ATOM    605  CD  LYS    77      27.715  31.554  68.048  1.00 27.04           C  
ATOM    606  CE  LYS    77      27.350  31.768  66.560  1.00 30.16           C  
ATOM    607  NZ  LYS    77      26.213  32.750  66.465  1.00 32.73           N  
ATOM    608  N   ILE    78      31.583  30.435  72.043  1.00 22.60           N  
ATOM    609  CA  ILE    78      32.071  30.339  73.413  1.00 22.07           C  
ATOM    610  C   ILE    78      31.012  30.326  74.533  1.00 22.75           C  
ATOM    611  O   ILE    78      31.152  29.564  75.504  1.00 23.41           O  
ATOM    612  CB  ILE    78      33.171  31.402  73.697  1.00 21.45           C  
ATOM    613  CG1 ILE    78      33.998  30.962  74.928  1.00 23.92           C  
ATOM    614  CG2 ILE    78      32.562  32.812  73.824  1.00 21.51           C  
ATOM    615  CD1 ILE    78      35.292  31.689  75.027  1.00 24.33           C  
ATOM    616  N   ASP    79      29.970  31.146  74.440  1.00 23.59           N  
ATOM    617  CA  ASP    79      29.029  31.223  75.570  1.00 24.43           C  
ATOM    618  C   ASP    79      28.100  30.016  75.696  1.00 25.45           C  
ATOM    619  O   ASP    79      27.417  29.879  76.716  1.00 24.78           O  
ATOM    620  CB  ASP    79      28.210  32.536  75.557  1.00 24.23           C  
ATOM    621  CG  ASP    79      29.086  33.776  75.601  1.00 27.88           C  
ATOM    622  OD1 ASP    79      29.804  33.964  76.614  1.00 26.74           O  
ATOM    623  OD2 ASP    79      29.094  34.527  74.593  1.00 32.80           O  
ATOM    624  N   ALA    80      28.066  29.156  74.665  1.00 25.69           N  
ATOM    625  CA  ALA    80      27.047  28.111  74.563  1.00 26.54           C  
ATOM    626  C   ALA    80      27.682  26.765  74.211  1.00 26.30           C  
ATOM    627  O   ALA    80      27.503  26.249  73.096  1.00 27.12           O  
ATOM    628  CB  ALA    80      25.985  28.507  73.530  1.00 26.86           C  
ATOM    629  N   PRO    81      28.447  26.184  75.142  1.00 26.15           N  
ATOM    630  CA  PRO    81      29.122  24.949  74.732  1.00 24.68           C  
ATOM    631  C   PRO    81      28.218  23.743  74.545  1.00 24.12           C  
ATOM    632  O   PRO    81      27.161  23.624  75.174  1.00 22.35           O  
ATOM    633  CB  PRO    81      30.133  24.700  75.858  1.00 25.45           C  
ATOM    634  CG  PRO    81      29.445  25.319  77.098  1.00 26.62           C  
ATOM    635  CD  PRO    81      28.774  26.577  76.531  1.00 25.97           C  
ATOM    636  N   PHE    82      28.635  22.882  73.622  1.00 23.55           N  
ATOM    637  CA  PHE    82      28.009  21.589  73.410  1.00 23.30           C  
ATOM    638  C   PHE    82      28.340  20.635  74.570  1.00 23.67           C  
ATOM    639  O   PHE    82      27.463  19.880  75.036  1.00 22.81           O  
ATOM    640  CB  PHE    82      28.527  21.019  72.092  1.00 24.35           C  
ATOM    641  CG  PHE    82      28.172  19.587  71.875  1.00 25.21           C  
ATOM    642  CD1 PHE    82      26.838  19.213  71.728  1.00 28.92           C  
ATOM    643  CD2 PHE    82      29.165  18.615  71.831  1.00 27.78           C  
ATOM    644  CE1 PHE    82      26.501  17.867  71.539  1.00 30.70           C  
ATOM    645  CE2 PHE    82      28.833  17.275  71.630  1.00 31.51           C  
ATOM    646  CZ  PHE    82      27.502  16.912  71.485  1.00 30.20           C  
ATOM    647  N   PHE    83      29.607  20.662  75.011  1.00 22.68           N  
ATOM    648  CA  PHE    83      30.089  19.864  76.127  1.00 22.25           C  
ATOM    649  C   PHE    83      31.094  20.714  76.902  1.00 22.99           C  
ATOM    650  O   PHE    83      32.029  21.288  76.312  1.00 23.07           O  
ATOM    651  CB  PHE    83      30.776  18.557  75.645  1.00 23.52           C  
ATOM    652  CG  PHE    83      31.457  17.768  76.743  1.00 22.78           C  
ATOM    653  CD1 PHE    83      30.727  16.888  77.557  1.00 26.75           C  
ATOM    654  CD2 PHE    83      32.847  17.887  76.951  1.00 24.70           C  
ATOM    655  CE1 PHE    83      31.354  16.155  78.577  1.00 28.70           C  
ATOM    656  CE2 PHE    83      33.499  17.159  77.979  1.00 24.92           C  
ATOM    657  CZ  PHE    83      32.743  16.278  78.787  1.00 25.97           C  
ATOM    658  N   GLU    84      30.936  20.765  78.225  1.00 23.12           N  
ATOM    659  CA  GLU    84      31.992  21.343  79.050  1.00 23.53           C  
ATOM    660  C   GLU    84      32.175  20.569  80.340  1.00 23.50           C  
ATOM    661  O   GLU    84      31.204  20.097  80.934  1.00 23.03           O  
ATOM    662  CB  GLU    84      31.722  22.822  79.341  1.00 23.79           C  
ATOM    663  CG  GLU    84      30.401  23.073  80.119  1.00 26.04           C  
ATOM    664  CD  GLU    84      30.205  24.545  80.531  1.00 27.27           C  
ATOM    665  OE1 GLU    84      31.156  25.360  80.506  1.00 26.40           O  
ATOM    666  OE2 GLU    84      29.069  24.870  80.924  1.00 28.28           O  
ATOM    667  N   LYS    85      33.420  20.423  80.766  1.00 22.93           N  
ATOM    668  CA  LYS    85      33.724  19.846  82.086  0.50 23.87           C  
ATOM    670  C   LYS    85      34.910  20.625  82.634  1.00 23.56           C  
ATOM    671  O   LYS    85      35.825  20.950  81.895  1.00 23.95           O  
ATOM    672  CB  LYS    85      34.083  18.357  81.996  0.50 23.73           C  
ATOM    674  CG  LYS    85      32.957  17.384  82.336  0.50 24.82           C  
ATOM    676  CD  LYS    85      33.505  15.997  82.769  0.50 24.33           C  
ATOM    678  CE  LYS    85      33.555  15.811  84.294  0.50 25.99           C  
ATOM    680  NZ  LYS    85      33.861  14.401  84.745  0.50 26.26           N  
ATOM    682  N   ARG    86      34.903  20.903  83.919  1.00 23.57           N  
ATOM    683  CA  ARG    86      36.034  21.610  84.495  1.00 23.90           C  
ATOM    684  C   ARG    86      36.348  21.086  85.880  1.00 24.29           C  
ATOM    685  O   ARG    86      35.484  20.487  86.553  1.00 23.66           O  
ATOM    686  CB  ARG    86      35.786  23.128  84.490  1.00 24.99           C  
ATOM    687  CG  ARG    86      34.591  23.615  85.302  1.00 25.07           C  
ATOM    688  CD  ARG    86      34.303  25.123  85.038  1.00 25.14           C  
ATOM    689  NE  ARG    86      33.702  25.398  83.719  1.00 25.31           N  
ATOM    690  CZ  ARG    86      34.236  26.201  82.789  1.00 26.67           C  
ATOM    691  NH1 ARG    86      35.374  26.830  83.012  1.00 26.27           N  
ATOM    692  NH2 ARG    86      33.627  26.379  81.614  1.00 26.28           N  
ATOM    693  N   ILE    87      37.591  21.304  86.302  1.00 23.22           N  
ATOM    694  CA  ILE    87      38.047  20.923  87.641  1.00 23.10           C  
ATOM    695  C   ILE    87      37.449  21.940  88.647  1.00 24.10           C  
ATOM    696  O   ILE    87      37.432  23.160  88.378  1.00 24.17           O  
ATOM    697  CB  ILE    87      39.604  20.913  87.674  1.00 22.67           C  
ATOM    698  CG1 ILE    87      40.155  19.959  86.594  1.00 21.94           C  
ATOM    699  CG2 ILE    87      40.155  20.545  89.091  1.00 22.37           C  
ATOM    700  CD1 ILE    87      41.673  20.106  86.366  1.00 24.37           C  
ATOM    701  N   SER    88      36.896  21.460  89.764  1.00 23.35           N  
ATOM    702  CA  SER    88      36.274  22.367  90.747  1.00 23.33           C  
ATOM    703  C   SER    88      37.265  23.407  91.232  1.00 23.89           C  
ATOM    704  O   SER    88      38.486  23.190  91.140  1.00 22.80           O  
ATOM    705  CB  SER    88      35.722  21.610  91.964  1.00 23.72           C  
ATOM    706  OG  SER    88      36.795  21.101  92.744  1.00 23.82           O  
ATOM    707  N   ASP    89      36.763  24.531  91.735  1.00 23.87           N  
ATOM    708  CA  ASP    89      37.707  25.521  92.262  1.00 26.50           C  
ATOM    709  C   ASP    89      38.550  25.003  93.433  1.00 25.69           C  
ATOM    710  O   ASP    89      39.761  25.286  93.514  1.00 24.91           O  
ATOM    711  CB  ASP    89      37.099  26.927  92.521  1.00 27.17           C  
ATOM    712  CG  ASP    89      35.754  26.920  93.224  1.00 34.53           C  
ATOM    713  OD1 ASP    89      35.381  25.939  93.922  1.00 37.65           O  
ATOM    714  OD2 ASP    89      35.055  27.972  93.088  1.00 39.94           O  
ATOM    715  N   ASP    90      37.930  24.213  94.312  1.00 25.37           N  
ATOM    716  CA  ASP    90      38.670  23.688  95.451  0.50 25.31           C  
ATOM    718  C   ASP    90      39.719  22.673  95.024  1.00 24.86           C  
ATOM    719  O   ASP    90      40.851  22.735  95.504  1.00 24.95           O  
ATOM    720  CB  ASP    90      37.719  23.169  96.525  0.50 25.14           C  
ATOM    722  CG  ASP    90      36.780  24.263  97.018  0.50 26.90           C  
ATOM    724  OD1 ASP    90      37.266  25.386  97.275  0.50 26.76           O  
ATOM    726  OD2 ASP    90      35.561  24.010  97.107  0.50 28.34           O  
ATOM    728  N   HIS    91      39.370  21.771  94.104  1.00 24.96           N  
ATOM    729  CA  HIS    91      40.356  20.826  93.562  1.00 24.21           C  
ATOM    730  C   HIS    91      41.470  21.540  92.799  1.00 24.77           C  
ATOM    731  O   HIS    91      42.640  21.158  92.917  1.00 24.87           O  
ATOM    732  CB  HIS    91      39.685  19.793  92.654  1.00 24.69           C  
ATOM    733  CG  HIS    91      38.908  18.747  93.410  1.00 26.40           C  
ATOM    734  ND1 HIS    91      37.982  17.920  92.808  1.00 28.55           N  
ATOM    735  CD2 HIS    91      38.933  18.395  94.718  1.00 28.91           C  
ATOM    736  CE1 HIS    91      37.464  17.109  93.720  1.00 28.06           C  
ATOM    737  NE2 HIS    91      38.034  17.367  94.881  1.00 27.01           N  
ATOM    738  N   THR    92      41.117  22.567  92.019  1.00 23.57           N  
ATOM    739  CA  THR    92      42.132  23.372  91.320  1.00 23.55           C  
ATOM    740  C   THR    92      43.130  23.966  92.321  1.00 23.89           C  
ATOM    741  O   THR    92      44.352  23.837  92.148  1.00 23.39           O  
ATOM    742  CB  THR    92      41.464  24.477  90.469  1.00 24.44           C  
ATOM    743  OG1 THR    92      40.688  23.848  89.434  1.00 23.71           O  
ATOM    744  CG2 THR    92      42.491  25.426  89.820  1.00 23.99           C  
ATOM    745  N   PHE    93      42.619  24.555  93.399  1.00 23.98           N  
ATOM    746  CA  PHE    93      43.498  25.117  94.433  1.00 24.53           C  
ATOM    747  C   PHE    93      44.425  24.043  95.046  1.00 24.75           C  
ATOM    748  O   PHE    93      45.644  24.257  95.175  1.00 24.62           O  
ATOM    749  CB  PHE    93      42.656  25.808  95.518  1.00 24.20           C  
ATOM    750  CG  PHE    93      43.456  26.295  96.690  1.00 24.55           C  
ATOM    751  CD1 PHE    93      44.079  27.546  96.644  1.00 23.25           C  
ATOM    752  CD2 PHE    93      43.582  25.508  97.839  1.00 24.77           C  
ATOM    753  CE1 PHE    93      44.795  28.026  97.744  1.00 25.66           C  
ATOM    754  CE2 PHE    93      44.321  25.968  98.927  1.00 28.70           C  
ATOM    755  CZ  PHE    93      44.926  27.235  98.874  1.00 27.67           C  
ATOM    756  N   ASN    94      43.849  22.899  95.417  1.00 24.28           N  
ATOM    757  CA  ASN    94      44.615  21.821  96.053  1.00 25.00           C  
ATOM    758  C   ASN    94      45.670  21.242  95.113  1.00 24.16           C  
ATOM    759  O   ASN    94      46.787  20.912  95.540  1.00 23.37           O  
ATOM    760  CB  ASN    94      43.675  20.691  96.523  1.00 24.95           C  
ATOM    761  CG  ASN    94      42.833  21.082  97.717  1.00 28.63           C  
ATOM    762  OD1 ASN    94      43.170  21.988  98.466  1.00 30.96           O  
ATOM    763  ND2 ASN    94      41.726  20.374  97.908  1.00 33.96           N  
ATOM    764  N   ILE    95      45.301  21.098  93.838  1.00 23.11           N  
ATOM    765  CA  ILE    95      46.232  20.615  92.833  1.00 23.14           C  
ATOM    766  C   ILE    95      47.380  21.595  92.644  1.00 23.25           C  
ATOM    767  O   ILE    95      48.550  21.180  92.642  1.00 23.42           O  
ATOM    768  CB  ILE    95      45.539  20.303  91.496  1.00 22.15           C  
ATOM    769  CG1 ILE    95      44.625  19.059  91.666  1.00 23.25           C  
ATOM    770  CG2 ILE    95      46.600  20.110  90.374  1.00 22.80           C  
ATOM    771  CD1 ILE    95      43.608  18.920  90.526  1.00 22.98           C  
ATOM    772  N   VAL    96      47.060  22.888  92.545  1.00 22.69           N  
ATOM    773  CA  VAL    96      48.100  23.906  92.442  1.00 23.28           C  
ATOM    774  C   VAL    96      49.068  23.864  93.627  1.00 24.25           C  
ATOM    775  O   VAL    96      50.295  23.989  93.454  1.00 24.61           O  
ATOM    776  CB  VAL    96      47.488  25.317  92.278  1.00 23.65           C  
ATOM    777  CG1 VAL    96      48.516  26.412  92.512  1.00 24.35           C  
ATOM    778  CG2 VAL    96      46.859  25.471  90.874  1.00 23.57           C  
ATOM    779  N   GLN    97      48.541  23.709  94.838  1.00 25.36           N  
ATOM    780  CA  GLN    97      49.424  23.624  96.016  1.00 25.73           C  
ATOM    781  C   GLN    97      50.437  22.476  95.923  1.00 26.30           C  
ATOM    782  O   GLN    97      51.621  22.663  96.230  1.00 25.59           O  
ATOM    783  CB  GLN    97      48.607  23.465  97.284  1.00 26.58           C  
ATOM    784  CG  GLN    97      47.941  24.729  97.740  1.00 29.53           C  
ATOM    785  CD  GLN    97      47.556  24.621  99.202  1.00 34.30           C  
ATOM    786  OE1 GLN    97      46.953  23.630  99.634  1.00 38.22           O  
ATOM    787  NE2 GLN    97      47.909  25.625  99.965  1.00 33.95           N  
ATOM    788  N   VAL    98      49.975  21.294  95.507  1.00 25.44           N  
ATOM    789  CA  VAL    98      50.871  20.140  95.297  1.00 25.65           C  
ATOM    790  C   VAL    98      51.943  20.420  94.232  1.00 25.69           C  
ATOM    791  O   VAL    98      53.131  20.180  94.468  1.00 25.67           O  
ATOM    792  CB  VAL    98      50.074  18.830  94.944  1.00 25.00           C  
ATOM    793  CG1 VAL    98      51.016  17.668  94.604  1.00 25.34           C  
ATOM    794  CG2 VAL    98      49.144  18.437  96.107  1.00 25.98           C  
ATOM    795  N   LEU    99      51.514  20.923  93.074  1.00 24.55           N  
ATOM    796  CA  LEU    99      52.410  21.250  91.964  1.00 24.75           C  
ATOM    797  C   LEU    99      53.432  22.319  92.341  1.00 24.75           C  
ATOM    798  O   LEU    99      54.538  22.322  91.821  1.00 24.16           O  
ATOM    799  CB  LEU    99      51.590  21.751  90.771  1.00 24.18           C  
ATOM    800  CG  LEU    99      50.646  20.756  90.086  1.00 23.25           C  
ATOM    801  CD1 LEU    99      49.801  21.461  89.000  1.00 25.60           C  
ATOM    802  CD2 LEU    99      51.398  19.593  89.490  1.00 26.40           C  
ATOM    803  N   GLU   100      53.051  23.241  93.225  1.00 24.86           N  
ATOM    804  CA  GLU   100      53.987  24.257  93.719  1.00 25.62           C  
ATOM    805  C   GLU   100      55.195  23.703  94.483  1.00 25.99           C  
ATOM    806  O   GLU   100      56.229  24.373  94.588  1.00 26.50           O  
ATOM    807  CB  GLU   100      53.240  25.309  94.555  1.00 25.45           C  
ATOM    808  CG  GLU   100      52.480  26.276  93.656  1.00 25.86           C  
ATOM    809  CD  GLU   100      51.646  27.259  94.435  1.00 29.79           C  
ATOM    810  OE1 GLU   100      51.422  27.015  95.630  1.00 29.23           O  
ATOM    811  OE2 GLU   100      51.205  28.279  93.859  1.00 28.43           O  
ATOM    812  N   SER   101      55.070  22.491  95.008  1.00 26.91           N  
ATOM    813  CA  SER   101      56.191  21.837  95.686  1.00 27.88           C  
ATOM    814  C   SER   101      57.197  21.199  94.694  1.00 28.12           C  
ATOM    815  O   SER   101      58.288  20.756  95.101  1.00 27.43           O  
ATOM    816  CB  SER   101      55.663  20.827  96.693  1.00 27.76           C  
ATOM    817  OG  SER   101      55.126  19.698  96.013  1.00 30.42           O  
ATOM    818  N   TYR   102      56.848  21.171  93.404  1.00 27.81           N  
ATOM    819  CA  TYR   102      57.752  20.646  92.362  1.00 28.47           C  
ATOM    820  C   TYR   102      58.315  21.769  91.498  1.00 28.53           C  
ATOM    821  O   TYR   102      57.724  22.846  91.414  1.00 28.15           O  
ATOM    822  CB  TYR   102      57.016  19.689  91.419  1.00 29.44           C  
ATOM    823  CG  TYR   102      56.582  18.380  91.998  1.00 29.79           C  
ATOM    824  CD1 TYR   102      57.393  17.245  91.865  1.00 32.75           C  
ATOM    825  CD2 TYR   102      55.348  18.247  92.630  1.00 30.53           C  
ATOM    826  CE1 TYR   102      56.993  16.017  92.375  1.00 34.59           C  
ATOM    827  CE2 TYR   102      54.938  17.025  93.160  1.00 32.33           C  
ATOM    828  CZ  TYR   102      55.766  15.919  93.028  1.00 33.34           C  
ATOM    829  OH  TYR   102      55.399  14.694  93.536  1.00 34.62           O  
ATOM    830  N   GLN   103      59.435  21.501  90.825  1.00 27.96           N  
ATOM    831  CA  GLN   103      60.007  22.432  89.843  1.00 28.01           C  
ATOM    832  C   GLN   103      59.215  22.347  88.538  1.00 27.48           C  
ATOM    833  O   GLN   103      59.582  21.623  87.593  1.00 26.24           O  
ATOM    834  CB  GLN   103      61.508  22.149  89.606  1.00 28.39           C  
ATOM    835  CG  GLN   103      62.260  23.245  88.794  1.00 31.88           C  
ATOM    836  CD  GLN   103      62.241  24.634  89.443  1.00 35.99           C  
ATOM    837  OE1 GLN   103      62.423  24.784  90.658  1.00 37.49           O  
ATOM    838  NE2 GLN   103      62.026  25.659  88.623  1.00 36.64           N  
ATOM    839  N   CYS   104      58.102  23.073  88.490  1.00 26.82           N  
ATOM    840  CA  CYS   104      57.245  23.013  87.321  1.00 26.67           C  
ATOM    841  C   CYS   104      56.543  24.335  87.076  1.00 26.12           C  
ATOM    842  O   CYS   104      56.247  25.093  88.000  1.00 25.39           O  
ATOM    843  CB  CYS   104      56.246  21.858  87.427  1.00 27.15           C  
ATOM    844  SG  CYS   104      54.932  22.068  88.635  1.00 31.66           S  
ATOM    845  N   ASN   105      56.328  24.605  85.804  1.00 25.78           N  
ATOM    846  CA  ASN   105      55.584  25.768  85.366  1.00 25.96           C  
ATOM    847  C   ASN   105      54.135  25.312  85.218  1.00 25.15           C  
ATOM    848  O   ASN   105      53.872  24.277  84.611  1.00 23.84           O  
ATOM    849  CB  ASN   105      56.154  26.268  84.038  1.00 27.40           C  
ATOM    850  CG  ASN   105      55.475  27.535  83.579  1.00 33.06           C  
ATOM    851  OD1 ASN   105      54.409  27.486  82.956  1.00 38.49           O  
ATOM    852  ND2 ASN   105      56.038  28.681  83.963  1.00 30.86           N  
ATOM    853  N   ILE   106      53.219  26.056  85.828  1.00 24.15           N  
ATOM    854  CA  ILE   106      51.812  25.702  85.893  1.00 23.70           C  
ATOM    855  C   ILE   106      51.012  26.758  85.129  1.00 24.07           C  
ATOM    856  O   ILE   106      51.283  27.961  85.273  1.00 23.40           O  
ATOM    857  CB  ILE   106      51.315  25.707  87.370  1.00 23.94           C  
ATOM    858  CG1 ILE   106      52.172  24.822  88.287  1.00 24.39           C  
ATOM    859  CG2 ILE   106      49.812  25.278  87.470  1.00 25.84           C  
ATOM    860  CD1 ILE   106      51.981  25.208  89.792  1.00 23.01           C  
ATOM    861  N   ARG   107      50.028  26.325  84.338  0.50 24.04           N  
ATOM    863  CA  ARG   107      49.100  27.273  83.687  0.50 23.34           C  
ATOM    865  C   ARG   107      47.662  26.792  83.794  0.50 23.38           C  
ATOM    867  O   ARG   107      47.344  25.687  83.378  0.50 22.72           O  
ATOM    869  CB  ARG   107      49.456  27.488  82.218  0.50 24.11           C  
ATOM    871  CG  ARG   107      48.687  28.627  81.527  0.50 24.57           C  
ATOM    873  CD  ARG   107      49.311  28.860  80.166  0.50 31.13           C  
ATOM    875  NE  ARG   107      49.187  30.218  79.624  0.50 34.92           N  
ATOM    877  CZ  ARG   107      50.028  30.709  78.711  0.50 36.28           C  
ATOM    879  NH1 ARG   107      49.891  31.937  78.227  0.50 38.84           N  
ATOM    881  NH2 ARG   107      51.034  29.966  78.284  0.50 38.53           N  
ATOM    883  N   LEU   108      46.802  27.636  84.363  1.00 22.78           N  
ATOM    884  CA  LEU   108      45.371  27.345  84.442  1.00 23.07           C  
ATOM    885  C   LEU   108      44.784  27.829  83.126  1.00 23.31           C  
ATOM    886  O   LEU   108      44.761  29.032  82.856  1.00 23.84           O  
ATOM    887  CB  LEU   108      44.761  28.082  85.633  1.00 23.51           C  
ATOM    888  CG  LEU   108      45.548  27.835  86.936  1.00 23.62           C  
ATOM    889  CD1 LEU   108      44.924  28.674  88.092  1.00 27.25           C  
ATOM    890  CD2 LEU   108      45.526  26.358  87.255  1.00 24.88           C  
ATOM    891  N   LEU   109      44.350  26.895  82.290  1.00 23.14           N  
ATOM    892  CA  LEU   109      43.906  27.234  80.950  1.00 23.54           C  
ATOM    893  C   LEU   109      42.371  27.321  80.899  1.00 23.77           C  
ATOM    894  O   LEU   109      41.670  26.338  80.524  1.00 23.71           O  
ATOM    895  CB  LEU   109      44.483  26.250  79.911  1.00 23.98           C  
ATOM    896  CG  LEU   109      44.344  26.668  78.425  1.00 25.11           C  
ATOM    897  CD1 LEU   109      45.396  27.742  78.054  1.00 24.78           C  
ATOM    898  CD2 LEU   109      44.447  25.467  77.474  1.00 25.64           C  
ATOM    899  N   HIS   110      41.852  28.462  81.362  1.00 22.67           N  
ATOM    900  CA  HIS   110      40.377  28.713  81.353  1.00 22.13           C  
ATOM    901  C   HIS   110      39.998  29.153  79.949  1.00 21.73           C  
ATOM    902  O   HIS   110      40.876  29.580  79.174  1.00 22.49           O  
ATOM    903  CB  HIS   110      40.034  29.763  82.443  1.00 22.73           C  
ATOM    904  CG  HIS   110      38.567  29.938  82.715  1.00 22.61           C  
ATOM    905  ND1 HIS   110      37.757  30.759  81.963  1.00 24.29           N  
ATOM    906  CD2 HIS   110      37.790  29.454  83.719  1.00 23.03           C  
ATOM    907  CE1 HIS   110      36.528  30.753  82.469  1.00 25.00           C  
ATOM    908  NE2 HIS   110      36.522  29.962  83.538  1.00 25.22           N  
ATOM    909  N   GLU   111      38.716  29.037  79.575  1.00 21.19           N  
ATOM    910  CA  GLU   111      38.306  29.511  78.231  1.00 21.14           C  
ATOM    911  C   GLU   111      38.210  31.034  78.104  1.00 20.87           C  
ATOM    912  O   GLU   111      38.114  31.563  77.003  1.00 20.50           O  
ATOM    913  CB  GLU   111      37.042  28.786  77.746  1.00 23.05           C  
ATOM    914  CG  GLU   111      35.742  29.222  78.438  1.00 23.31           C  
ATOM    915  CD  GLU   111      35.458  28.586  79.810  1.00 26.37           C  
ATOM    916  OE1 GLU   111      36.334  27.994  80.494  1.00 24.08           O  
ATOM    917  OE2 GLU   111      34.280  28.711  80.238  1.00 27.05           O  
ATOM    918  N   LYS   112      38.245  31.721  79.250  0.50 20.92           N  
ATOM    920  CA  LYS   112      38.087  33.177  79.310  0.50 20.70           C  
ATOM    922  C   LYS   112      39.411  33.903  79.618  0.50 21.25           C  
ATOM    924  O   LYS   112      39.564  35.113  79.341  0.50 20.94           O  
ATOM    926  CB  LYS   112      36.999  33.550  80.361  0.50 20.26           C  
ATOM    928  CG  LYS   112      36.773  35.067  80.503  0.50 19.15           C  
ATOM    930  CD  LYS   112      36.331  35.672  79.152  0.50 20.20           C  
ATOM    932  CE  LYS   112      36.541  37.191  79.051  0.50 16.26           C  
ATOM    934  NZ  LYS   112      37.931  37.622  79.298  0.50  9.90           N  
ATOM    936  N   TYR   113      40.364  33.180  80.195  1.00 20.88           N  
ATOM    937  CA  TYR   113      41.644  33.777  80.572  1.00 21.91           C  
ATOM    938  C   TYR   113      42.609  32.662  80.866  1.00 22.49           C  
ATOM    939  O   TYR   113      42.204  31.497  81.013  1.00 21.81           O  
ATOM    940  CB  TYR   113      41.512  34.699  81.838  1.00 22.60           C  
ATOM    941  CG  TYR   113      40.792  33.962  82.959  1.00 24.25           C  
ATOM    942  CD1 TYR   113      41.488  33.060  83.770  1.00 25.82           C  
ATOM    943  CD2 TYR   113      39.435  34.120  83.174  1.00 27.52           C  
ATOM    944  CE1 TYR   113      40.835  32.355  84.794  1.00 26.93           C  
ATOM    945  CE2 TYR   113      38.768  33.403  84.192  1.00 28.33           C  
ATOM    946  CZ  TYR   113      39.482  32.520  84.966  1.00 27.71           C  
ATOM    947  OH  TYR   113      38.878  31.808  86.005  1.00 32.23           O  
ATOM    948  N   SER   114      43.889  33.007  80.988  1.00 22.58           N  
ATOM    949  CA  SER   114      44.862  32.027  81.438  1.00 23.73           C  
ATOM    950  C   SER   114      45.713  32.702  82.533  1.00 23.87           C  
ATOM    951  O   SER   114      46.090  33.887  82.417  1.00 22.05           O  
ATOM    952  CB  SER   114      45.689  31.562  80.243  1.00 25.99           C  
ATOM    953  OG  SER   114      46.805  30.826  80.655  1.00 34.48           O  
ATOM    954  N   ILE   115      46.051  31.937  83.572  1.00 23.45           N  
ATOM    955  CA  ILE   115      46.928  32.458  84.610  1.00 24.88           C  
ATOM    956  C   ILE   115      47.953  31.398  84.897  1.00 24.20           C  
ATOM    957  O   ILE   115      47.590  30.243  85.084  1.00 24.37           O  
ATOM    958  CB  ILE   115      46.165  32.731  85.930  1.00 25.11           C  
ATOM    959  CG1 ILE   115      44.833  33.404  85.669  1.00 26.95           C  
ATOM    960  CG2 ILE   115      47.031  33.614  86.880  1.00 26.89           C  
ATOM    961  CD1 ILE   115      43.951  33.559  86.953  1.00 28.56           C  
ATOM    962  N   GLY   116      49.216  31.791  84.969  1.00 24.03           N  
ATOM    963  CA  GLY   116      50.315  30.833  85.268  1.00 24.05           C  
ATOM    964  C   GLY   116      51.233  31.370  86.360  1.00 23.76           C  
ATOM    965  O   GLY   116      51.115  32.543  86.770  1.00 22.74           O  
ATOM    966  N   ASN   117      52.159  30.526  86.818  1.00 23.26           N  
ATOM    967  CA  ASN   117      53.212  30.957  87.726  1.00 23.63           C  
ATOM    968  C   ASN   117      54.449  31.425  86.946  1.00 23.90           C  
ATOM    969  O   ASN   117      54.405  31.524  85.722  1.00 23.64           O  
ATOM    970  CB  ASN   117      53.548  29.855  88.748  1.00 23.14           C  
ATOM    971  CG  ASN   117      54.198  28.612  88.122  1.00 24.21           C  
ATOM    972  OD1 ASN   117      54.250  28.447  86.896  1.00 25.61           O  
ATOM    973  ND2 ASN   117      54.696  27.728  88.977  1.00 26.73           N  
ATOM    974  N   LYS   118      55.529  31.724  87.650  1.00 23.62           N  
ATOM    975  CA  LYS   118      56.711  32.281  87.012  1.00 25.96           C  
ATOM    976  C   LYS   118      57.923  31.374  87.111  1.00 27.77           C  
ATOM    977  O   LYS   118      59.051  31.813  86.842  1.00 28.62           O  
ATOM    978  CB  LYS   118      57.034  33.653  87.623  1.00 25.98           C  
ATOM    979  CG  LYS   118      56.042  34.711  87.226  1.00 25.72           C  
ATOM    980  CD  LYS   118      56.415  36.069  87.807  1.00 28.58           C  
ATOM    981  CE  LYS   118      55.419  37.087  87.370  1.00 30.46           C  
ATOM    982  NZ  LYS   118      55.884  38.458  87.729  1.00 32.10           N  
ATOM    983  N   LYS   119      57.708  30.121  87.489  1.00 29.44           N  
ATOM    984  CA  LYS   119      58.841  29.200  87.654  1.00 32.60           C  
ATOM    985  C   LYS   119      59.461  28.888  86.300  1.00 33.59           C  
ATOM    986  O   LYS   119      58.738  28.571  85.338  1.00 33.10           O  
ATOM    987  CB  LYS   119      58.399  27.894  88.304  1.00 32.75           C  
ATOM    988  CG  LYS   119      58.288  27.960  89.798  1.00 35.91           C  
ATOM    989  CD  LYS   119      58.459  26.579  90.421  1.00 37.54           C  
ATOM    990  CE  LYS   119      58.129  26.650  91.897  1.00 39.43           C  
ATOM    991  NZ  LYS   119      57.866  25.305  92.472  1.00 40.56           N  
ATOM    992  N   LYS   120      60.790  29.007  86.240  1.00 36.02           N  
ATOM    993  CA  LYS   120      61.578  28.654  85.063  1.00 38.02           C  
ATOM    994  C   LYS   120      61.896  27.170  85.118  1.00 39.04           C  
ATOM    995  O   LYS   120      62.296  26.657  86.164  1.00 38.77           O  
ATOM    996  CB  LYS   120      62.886  29.453  85.030  1.00 38.32           C  
ATOM    997  CG  LYS   120      62.694  30.945  84.772  1.00 40.54           C  
ATOM    998  CD  LYS   120      63.861  31.747  85.335  1.00 44.73           C  
ATOM    999  CE  LYS   120      63.444  33.184  85.676  1.00 46.55           C  
ATOM   1000  NZ  LYS   120      62.821  33.882  84.512  1.00 48.28           N  
ATOM   1001  N   VAL   121      61.689  26.475  84.005  1.00 40.06           N  
ATOM   1002  CA  VAL   121      62.090  25.076  83.913  1.00 42.36           C  
ATOM   1003  C   VAL   121      63.024  24.879  82.729  1.00 43.96           C  
ATOM   1004  O   VAL   121      62.907  25.576  81.713  1.00 44.09           O  
ATOM   1005  CB  VAL   121      60.890  24.090  83.829  1.00 42.18           C  
ATOM   1006  CG1 VAL   121      60.113  24.078  85.145  1.00 42.37           C  
ATOM   1007  CG2 VAL   121      59.973  24.426  82.657  1.00 42.77           C  
ATOM   1008  N   ASN   122      63.956  23.942  82.881  1.00 46.08           N  
ATOM   1009  CA  ASN   122      64.798  23.497  81.784  1.00 48.39           C  
ATOM   1010  C   ASN   122      63.967  22.638  80.835  1.00 49.57           C  
ATOM   1011  O   ASN   122      63.999  21.405  80.907  1.00 50.16           O  
ATOM   1012  CB  ASN   122      66.000  22.705  82.317  1.00 48.37           C  
ATOM   1013  CG  ASN   122      66.775  23.462  83.391  1.00 50.19           C  
ATOM   1014  OD1 ASN   122      66.642  24.684  83.540  1.00 51.78           O  
ATOM   1015  ND2 ASN   122      67.594  22.733  84.150  1.00 51.79           N  
ATOM   1016  N   SER   123      63.204  23.306  79.970  1.00 50.84           N  
ATOM   1017  CA  SER   123      62.344  22.642  78.997  1.00 52.09           C  
ATOM   1018  C   SER   123      62.412  23.349  77.638  1.00 52.92           C  
ATOM   1019  O   SER   123      61.943  24.490  77.493  1.00 52.90           O  
ATOM   1020  CB  SER   123      60.897  22.581  79.517  1.00 51.99           C  
ATOM   1021  OG  SER   123      59.973  22.350  78.464  1.00 52.51           O  
ATOM   1022  N   ASN   124      62.996  22.661  76.655  1.00 54.00           N  
ATOM   1023  CA  ASN   124      63.103  23.175  75.284  1.00 55.02           C  
ATOM   1024  C   ASN   124      61.801  23.189  74.477  1.00 55.68           C  
ATOM   1025  O   ASN   124      61.641  24.014  73.570  1.00 55.59           O  
ATOM   1026  CB  ASN   124      64.182  22.418  74.520  1.00 55.34           C  
ATOM   1027  CG  ASN   124      65.570  22.887  74.882  1.00 56.21           C  
ATOM   1028  OD1 ASN   124      65.761  24.036  75.293  1.00 57.93           O  
ATOM   1029  ND2 ASN   124      66.551  22.002  74.740  1.00 57.10           N  
ATOM   1030  N   LEU   125      60.891  22.265  74.803  1.00 56.35           N  
ATOM   1031  CA  LEU   125      59.562  22.196  74.177  1.00 56.84           C  
ATOM   1032  C   LEU   125      58.695  23.350  74.654  1.00 57.24           C  
ATOM   1033  O   LEU   125      57.808  23.802  73.929  1.00 57.49           O  
ATOM   1034  CB  LEU   125      58.866  20.851  74.461  1.00 56.60           C  
ATOM   1035  CG  LEU   125      59.414  19.595  73.764  1.00 56.47           C  
ATOM   1036  CD1 LEU   125      58.959  18.320  74.476  1.00 54.67           C  
ATOM   1037  CD2 LEU   125      59.050  19.566  72.271  1.00 55.55           C  
ATOM   1038  N   LEU   126      58.945  23.818  75.876  1.00 57.73           N  
ATOM   1039  CA  LEU   126      58.324  25.055  76.352  1.00 58.17           C  
ATOM   1040  C   LEU   126      58.840  26.226  75.516  1.00 58.38           C  
ATOM   1041  O   LEU   126      58.062  27.066  75.082  1.00 58.75           O  
ATOM   1042  CB  LEU   126      58.581  25.290  77.852  1.00 58.02           C  
ATOM   1043  CG  LEU   126      57.955  26.537  78.497  1.00 57.92           C  
ATOM   1044  CD1 LEU   126      56.442  26.615  78.265  1.00 57.28           C  
ATOM   1045  CD2 LEU   126      58.279  26.613  79.991  1.00 58.15           C  
ATOM   1046  N   GLY   127      60.150  26.255  75.277  1.00 58.51           N  
ATOM   1047  CA  GLY   127      60.762  27.265  74.414  1.00 58.47           C  
ATOM   1048  C   GLY   127      60.290  27.216  72.967  1.00 58.45           C  
ATOM   1049  O   GLY   127      60.195  28.256  72.312  1.00 58.83           O  
ATOM   1050  N   LYS   128      59.991  26.014  72.469  1.00 57.98           N  
ATOM   1051  CA  LYS   128      59.581  25.817  71.069  1.00 57.26           C  
ATOM   1052  C   LYS   128      58.092  26.112  70.828  1.00 56.69           C  
ATOM   1053  O   LYS   128      57.711  26.555  69.737  1.00 56.67           O  
ATOM   1054  CB  LYS   128      59.929  24.404  70.605  1.00 57.30           C  
ATOM   1055  N   ALA   129      57.264  25.872  71.847  1.00 55.52           N  
ATOM   1056  CA  ALA   129      55.808  26.000  71.733  1.00 54.54           C  
ATOM   1057  C   ALA   129      55.388  27.394  71.249  1.00 53.82           C  
ATOM   1058  O   ALA   129      55.832  28.398  71.805  1.00 53.76           O  
ATOM   1059  CB  ALA   129      55.143  25.663  73.068  1.00 54.53           C  
ATOM   1060  N   LEU   130      54.543  27.440  70.211  1.00 52.88           N  
ATOM   1061  CA  LEU   130      54.035  28.707  69.641  1.00 51.94           C  
ATOM   1062  C   LEU   130      53.223  29.499  70.664  1.00 51.64           C  
ATOM   1063  O   LEU   130      52.291  28.969  71.270  1.00 51.01           O  
ATOM   1064  CB  LEU   130      53.172  28.455  68.392  1.00 51.60           C  
ATOM   1065  CG  LEU   130      53.828  27.999  67.081  1.00 51.08           C  
ATOM   1066  CD1 LEU   130      52.812  27.305  66.145  1.00 49.55           C  
ATOM   1067  CD2 LEU   130      54.536  29.169  66.372  1.00 50.62           C  
ATOM   1068  N   ILE   131      53.604  30.760  70.860  1.00 51.30           N  
ATOM   1069  CA  ILE   131      52.826  31.703  71.671  1.00 51.22           C  
ATOM   1070  C   ILE   131      51.834  32.416  70.748  1.00 50.60           C  
ATOM   1071  O   ILE   131      52.197  32.851  69.643  1.00 50.90           O  
ATOM   1072  CB  ILE   131      53.726  32.738  72.414  1.00 50.95           C  
ATOM   1073  CG1 ILE   131      54.705  32.021  73.351  1.00 51.52           C  
ATOM   1074  CG2 ILE   131      52.868  33.728  73.217  1.00 52.11           C  
ATOM   1075  CD1 ILE   131      55.385  32.932  74.394  1.00 52.02           C  
ATOM   1076  N   HIS   132      50.584  32.504  71.194  1.00 49.50           N  
ATOM   1077  CA  HIS   132      49.535  33.212  70.451  1.00 48.50           C  
ATOM   1078  C   HIS   132      48.919  34.304  71.336  1.00 47.17           C  
ATOM   1079  O   HIS   132      48.984  34.203  72.571  1.00 47.31           O  
ATOM   1080  CB  HIS   132      48.478  32.246  69.877  1.00 48.91           C  
ATOM   1081  CG  HIS   132      48.268  31.007  70.692  1.00 49.29           C  
ATOM   1082  ND1 HIS   132      47.175  30.834  71.514  1.00 49.90           N  
ATOM   1083  CD2 HIS   132      49.004  29.872  70.798  1.00 50.80           C  
ATOM   1084  CE1 HIS   132      47.246  29.647  72.095  1.00 51.14           C  
ATOM   1085  NE2 HIS   132      48.348  29.042  71.682  1.00 50.86           N  
ATOM   1086  N   PRO   133      48.316  35.336  70.708  1.00 45.46           N  
ATOM   1087  CA  PRO   133      47.994  36.583  71.396  1.00 43.38           C  
ATOM   1088  C   PRO   133      47.016  36.414  72.561  1.00 40.66           C  
ATOM   1089  O   PRO   133      46.119  35.565  72.520  1.00 41.64           O  
ATOM   1090  CB  PRO   133      47.329  37.423  70.302  1.00 43.53           C  
ATOM   1091  CG  PRO   133      47.768  36.811  69.009  1.00 45.34           C  
ATOM   1092  CD  PRO   133      47.876  35.365  69.296  1.00 45.87           C  
ATOM   1093  N   SER   134      47.199  37.212  73.596  1.00 36.90           N  
ATOM   1094  CA  SER   134      46.129  37.393  74.558  1.00 32.79           C  
ATOM   1095  C   SER   134      45.240  38.480  73.920  1.00 30.34           C  
ATOM   1096  O   SER   134      45.583  39.066  72.859  1.00 27.78           O  
ATOM   1097  CB  SER   134      46.681  37.865  75.905  1.00 32.87           C  
ATOM   1098  OG  SER   134      46.999  39.272  75.900  1.00 36.95           O  
ATOM   1099  N   ASP   135      44.110  38.758  74.562  1.00 26.67           N  
ATOM   1100  CA  ASP   135      43.355  39.956  74.228  1.00 24.35           C  
ATOM   1101  C   ASP   135      42.937  40.503  75.578  1.00 23.50           C  
ATOM   1102  O   ASP   135      42.429  39.743  76.426  1.00 22.77           O  
ATOM   1103  CB  ASP   135      42.143  39.649  73.336  1.00 25.82           C  
ATOM   1104  CG  ASP   135      41.363  40.911  72.984  1.00 25.41           C  
ATOM   1105  OD1 ASP   135      41.675  41.547  71.958  1.00 25.59           O  
ATOM   1106  OD2 ASP   135      40.490  41.331  73.771  1.00 24.43           O  
ATOM   1107  N   PRO   136      43.198  41.790  75.808  1.00 22.46           N  
ATOM   1108  CA  PRO   136      42.929  42.348  77.140  1.00 22.89           C  
ATOM   1109  C   PRO   136      41.455  42.294  77.548  1.00 22.23           C  
ATOM   1110  O   PRO   136      41.179  42.356  78.738  1.00 22.64           O  
ATOM   1111  CB  PRO   136      43.431  43.799  77.049  1.00 23.21           C  
ATOM   1112  CG  PRO   136      43.673  44.067  75.587  1.00 23.98           C  
ATOM   1113  CD  PRO   136      43.811  42.758  74.877  1.00 22.40           C  
ATOM   1114  N   ILE   137      40.524  42.184  76.591  1.00 20.68           N  
ATOM   1115  CA  ILE   137      39.112  41.996  76.964  1.00 19.92           C  
ATOM   1116  C   ILE   137      38.774  40.516  76.974  1.00 20.18           C  
ATOM   1117  O   ILE   137      38.279  40.006  77.986  1.00 20.43           O  
ATOM   1118  CB  ILE   137      38.137  42.764  76.029  1.00 20.48           C  
ATOM   1119  CG1 ILE   137      38.385  44.278  76.112  1.00 20.36           C  
ATOM   1120  CG2 ILE   137      36.627  42.411  76.341  1.00 22.15           C  
ATOM   1121  CD1 ILE   137      37.485  45.058  75.112  1.00 21.69           C  
ATOM   1122  N   PHE   138      39.016  39.836  75.853  1.00 18.81           N  
ATOM   1123  CA  PHE   138      38.439  38.488  75.650  1.00 19.03           C  
ATOM   1124  C   PHE   138      39.267  37.350  76.188  1.00 19.99           C  
ATOM   1125  O   PHE   138      38.754  36.210  76.400  1.00 19.78           O  
ATOM   1126  CB  PHE   138      38.096  38.292  74.155  1.00 19.06           C  
ATOM   1127  CG  PHE   138      37.009  39.214  73.704  1.00 19.34           C  
ATOM   1128  CD1 PHE   138      35.684  38.964  74.080  1.00 21.10           C  
ATOM   1129  CD2 PHE   138      37.302  40.382  73.015  1.00 16.73           C  
ATOM   1130  CE1 PHE   138      34.654  39.863  73.698  1.00 18.53           C  
ATOM   1131  CE2 PHE   138      36.335  41.269  72.634  1.00 18.95           C  
ATOM   1132  CZ  PHE   138      34.966  41.025  72.975  1.00 18.88           C  
ATOM   1133  N   TYR   139      40.574  37.598  76.353  1.00 19.75           N  
ATOM   1134  CA  TYR   139      41.473  36.518  76.824  1.00 20.53           C  
ATOM   1135  C   TYR   139      42.730  37.039  77.496  1.00 20.57           C  
ATOM   1136  O   TYR   139      43.808  36.972  76.900  1.00 21.22           O  
ATOM   1137  CB  TYR   139      41.863  35.509  75.694  1.00 20.94           C  
ATOM   1138  CG  TYR   139      42.222  34.171  76.296  1.00 21.08           C  
ATOM   1139  CD1 TYR   139      43.567  33.812  76.545  1.00 22.13           C  
ATOM   1140  CD2 TYR   139      41.214  33.276  76.683  1.00 20.13           C  
ATOM   1141  CE1 TYR   139      43.898  32.604  77.159  1.00 22.09           C  
ATOM   1142  CE2 TYR   139      41.532  32.055  77.296  1.00 21.50           C  
ATOM   1143  CZ  TYR   139      42.875  31.743  77.552  1.00 21.15           C  
ATOM   1144  OH  TYR   139      43.190  30.548  78.146  1.00 22.82           O  
ATOM   1145  N   PRO   140      42.597  37.619  78.700  1.00 21.01           N  
ATOM   1146  CA  PRO   140      43.777  38.101  79.413  1.00 22.31           C  
ATOM   1147  C   PRO   140      44.679  36.951  79.793  1.00 23.43           C  
ATOM   1148  O   PRO   140      44.191  35.850  80.126  1.00 23.59           O  
ATOM   1149  CB  PRO   140      43.192  38.797  80.681  1.00 21.99           C  
ATOM   1150  CG  PRO   140      41.750  38.988  80.419  1.00 21.63           C  
ATOM   1151  CD  PRO   140      41.343  37.925  79.415  1.00 20.43           C  
ATOM   1152  N   VAL   141      45.989  37.165  79.680  1.00 24.46           N  
ATOM   1153  CA  VAL   141      46.979  36.148  80.079  1.00 26.37           C  
ATOM   1154  C   VAL   141      47.938  36.813  81.087  1.00 27.37           C  
ATOM   1155  O   VAL   141      48.544  37.861  80.777  1.00 26.66           O  
ATOM   1156  CB  VAL   141      47.726  35.569  78.858  1.00 27.66           C  
ATOM   1157  CG1 VAL   141      48.822  34.571  79.312  1.00 28.57           C  
ATOM   1158  CG2 VAL   141      46.738  34.851  77.878  1.00 27.79           C  
ATOM   1159  N   GLN   142      48.012  36.276  82.304  1.00 26.50           N  
ATOM   1160  CA  GLN   142      48.876  36.842  83.335  0.50 27.56           C  
ATOM   1162  C   GLN   142      49.671  35.766  84.046  1.00 27.33           C  
ATOM   1163  O   GLN   142      49.246  34.621  84.121  1.00 27.54           O  
ATOM   1164  CB  GLN   142      48.087  37.634  84.385  0.50 28.43           C  
ATOM   1166  CG  GLN   142      48.949  37.900  85.613  0.50 30.06           C  
ATOM   1168  CD  GLN   142      48.548  39.080  86.480  0.50 30.99           C  
ATOM   1170  OE1 GLN   142      47.429  39.601  86.410  0.50 35.08           O  
ATOM   1172  NE2 GLN   142      49.482  39.516  87.299  0.50 32.11           N  
ATOM   1174  N   PHE   143      50.827  36.155  84.572  1.00 27.05           N  
ATOM   1175  CA  PHE   143      51.649  35.294  85.396  1.00 27.00           C  
ATOM   1176  C   PHE   143      51.794  35.938  86.762  1.00 27.02           C  
ATOM   1177  O   PHE   143      51.782  37.171  86.878  1.00 27.45           O  
ATOM   1178  CB  PHE   143      52.994  35.065  84.717  1.00 28.14           C  
ATOM   1179  CG  PHE   143      52.829  34.506  83.345  1.00 32.02           C  
ATOM   1180  CD1 PHE   143      52.469  33.192  83.179  1.00 35.41           C  
ATOM   1181  CD2 PHE   143      52.871  35.331  82.236  1.00 36.59           C  
ATOM   1182  CE1 PHE   143      52.244  32.657  81.901  1.00 39.26           C  
ATOM   1183  CE2 PHE   143      52.665  34.803  80.973  1.00 38.51           C  
ATOM   1184  CZ  PHE   143      52.362  33.463  80.808  1.00 36.64           C  
ATOM   1185  N   VAL   144      51.844  35.101  87.794  1.00 25.14           N  
ATOM   1186  CA  VAL   144      52.039  35.567  89.159  1.00 23.87           C  
ATOM   1187  C   VAL   144      53.121  34.715  89.777  1.00 23.62           C  
ATOM   1188  O   VAL   144      53.361  33.571  89.328  1.00 22.77           O  
ATOM   1189  CB  VAL   144      50.714  35.477  90.001  1.00 24.41           C  
ATOM   1190  CG1 VAL   144      49.709  36.495  89.505  1.00 25.17           C  
ATOM   1191  CG2 VAL   144      50.081  34.042  89.932  1.00 23.84           C  
ATOM   1192  N   GLU   145      53.765  35.250  90.813  1.00 22.68           N  
ATOM   1193  CA  GLU   145      54.763  34.491  91.551  0.50 22.85           C  
ATOM   1195  C   GLU   145      54.113  33.351  92.318  1.00 23.69           C  
ATOM   1196  O   GLU   145      54.665  32.250  92.375  1.00 23.67           O  
ATOM   1197  CB  GLU   145      55.522  35.400  92.504  0.50 22.64           C  
ATOM   1199  CG  GLU   145      56.665  34.738  93.232  0.50 20.07           C  
ATOM   1201  CD  GLU   145      57.330  35.678  94.201  0.50 20.81           C  
ATOM   1203  OE1 GLU   145      56.788  36.772  94.422  0.50 17.89           O  
ATOM   1205  OE2 GLU   145      58.399  35.328  94.737  0.50 20.29           O  
ATOM   1207  N   SER   146      52.933  33.608  92.906  1.00 23.58           N  
ATOM   1208  CA  SER   146      52.247  32.561  93.679  1.00 23.76           C  
ATOM   1209  C   SER   146      50.813  32.345  93.217  1.00 23.53           C  
ATOM   1210  O   SER   146      49.903  33.147  93.548  1.00 22.79           O  
ATOM   1211  CB  SER   146      52.261  32.844  95.188  1.00 25.42           C  
ATOM   1212  OG  SER   146      51.515  31.830  95.861  1.00 24.46           O  
ATOM   1213  N   LEU   147      50.606  31.269  92.467  1.00 22.89           N  
ATOM   1214  CA  LEU   147      49.248  30.958  91.999  1.00 23.97           C  
ATOM   1215  C   LEU   147      48.295  30.642  93.155  1.00 24.07           C  
ATOM   1216  O   LEU   147      47.162  31.144  93.202  1.00 24.91           O  
ATOM   1217  CB  LEU   147      49.252  29.761  91.056  1.00 24.97           C  
ATOM   1218  CG  LEU   147      49.391  30.006  89.573  1.00 28.73           C  
ATOM   1219  CD1 LEU   147      49.332  28.637  88.870  1.00 29.98           C  
ATOM   1220  CD2 LEU   147      48.277  30.946  89.055  1.00 29.01           C  
ATOM   1221  N   SER   148      48.743  29.812  94.089  1.00 23.93           N  
ATOM   1222  CA  SER   148      47.875  29.425  95.200  1.00 24.47           C  
ATOM   1223  C   SER   148      47.493  30.644  96.070  1.00 25.45           C  
ATOM   1224  O   SER   148      46.326  30.747  96.503  1.00 26.17           O  
ATOM   1225  CB  SER   148      48.506  28.300  96.018  1.00 24.85           C  
ATOM   1226  OG  SER   148      49.614  28.833  96.736  1.00 25.70           O  
ATOM   1227  N   ASP   149      48.400  31.608  96.265  1.00 24.13           N  
ATOM   1228  CA  ASP   149      48.009  32.829  96.992  1.00 25.46           C  
ATOM   1229  C   ASP   149      46.912  33.594  96.255  1.00 25.07           C  
ATOM   1230  O   ASP   149      45.987  34.094  96.886  1.00 24.95           O  
ATOM   1231  CB  ASP   149      49.182  33.792  97.289  1.00 25.22           C  
ATOM   1232  CG  ASP   149      50.063  33.338  98.455  1.00 27.73           C  
ATOM   1233  OD1 ASP   149      49.745  32.347  99.159  1.00 30.52           O  
ATOM   1234  OD2 ASP   149      51.114  33.988  98.674  1.00 28.84           O  
ATOM   1235  N   LEU   150      47.035  33.705  94.935  1.00 24.21           N  
ATOM   1236  CA  LEU   150      46.026  34.408  94.132  1.00 24.99           C  
ATOM   1237  C   LEU   150      44.669  33.736  94.275  1.00 23.83           C  
ATOM   1238  O   LEU   150      43.666  34.423  94.529  1.00 23.98           O  
ATOM   1239  CB  LEU   150      46.437  34.409  92.652  1.00 24.98           C  
ATOM   1240  CG  LEU   150      45.430  35.147  91.781  1.00 28.95           C  
ATOM   1241  CD1 LEU   150      45.747  36.615  91.911  1.00 33.55           C  
ATOM   1242  CD2 LEU   150      45.517  34.703  90.357  1.00 33.58           C  
ATOM   1243  N   LEU   151      44.661  32.402  94.155  1.00 23.37           N  
ATOM   1244  CA  LEU   151      43.430  31.578  94.210  1.00 24.42           C  
ATOM   1245  C   LEU   151      42.676  31.644  95.548  1.00 25.69           C  
ATOM   1246  O   LEU   151      41.456  31.361  95.610  1.00 24.99           O  
ATOM   1247  CB  LEU   151      43.743  30.109  93.857  1.00 24.38           C  
ATOM   1248  CG  LEU   151      44.292  29.812  92.448  1.00 25.82           C  
ATOM   1249  CD1 LEU   151      44.552  28.317  92.202  1.00 24.27           C  
ATOM   1250  CD2 LEU   151      43.390  30.322  91.365  1.00 27.53           C  
ATOM   1251  N   MET   152      43.384  32.015  96.608  1.00 27.18           N  
ATOM   1252  CA  MET   152      42.722  32.248  97.911  1.00 30.40           C  
ATOM   1253  C   MET   152      41.563  33.251  97.805  1.00 28.35           C  
ATOM   1254  O   MET   152      40.534  33.061  98.441  1.00 29.16           O  
ATOM   1255  CB  MET   152      43.714  32.773  98.945  1.00 29.91           C  
ATOM   1256  CG  MET   152      44.982  32.002  99.019  1.00 34.04           C  
ATOM   1257  SD  MET   152      45.240  31.124 100.702  0.40 39.80          SE  
ATOM   1258  CE  MET   152      43.660  29.981 100.571  1.00 36.69           C  
ATOM   1259  N   ASP   153      41.752  34.330  97.047  1.00 25.94           N  
ATOM   1260  CA  ASP   153      40.748  35.373  96.919  1.00 25.38           C  
ATOM   1261  C   ASP   153      40.095  35.363  95.539  1.00 24.78           C  
ATOM   1262  O   ASP   153      39.049  35.977  95.354  1.00 23.83           O  
ATOM   1263  CB  ASP   153      41.374  36.743  97.181  1.00 26.73           C  
ATOM   1264  CG  ASP   153      41.761  36.911  98.636  1.00 28.73           C  
ATOM   1265  OD1 ASP   153      40.846  36.873  99.479  1.00 32.78           O  
ATOM   1266  OD2 ASP   153      42.962  37.078  98.930  1.00 35.47           O  
ATOM   1267  N   GLU   154      40.729  34.673  94.587  1.00 23.72           N  
ATOM   1268  CA  GLU   154      40.212  34.586  93.214  1.00 23.81           C  
ATOM   1269  C   GLU   154      40.196  33.127  92.800  1.00 23.78           C  
ATOM   1270  O   GLU   154      41.078  32.679  92.090  1.00 24.78           O  
ATOM   1271  CB  GLU   154      41.075  35.402  92.234  1.00 24.00           C  
ATOM   1272  CG  GLU   154      41.017  36.942  92.468  1.00 24.87           C  
ATOM   1273  CD  GLU   154      39.622  37.565  92.203  1.00 26.70           C  
ATOM   1274  OE1 GLU   154      38.696  36.897  91.659  1.00 27.11           O  
ATOM   1275  OE2 GLU   154      39.454  38.759  92.527  1.00 28.82           O  
ATOM   1276  N   PRO   155      39.174  32.378  93.231  1.00 23.99           N  
ATOM   1277  CA  PRO   155      39.097  30.956  92.849  1.00 23.75           C  
ATOM   1278  C   PRO   155      39.028  30.812  91.328  1.00 23.44           C  
ATOM   1279  O   PRO   155      38.481  31.694  90.625  1.00 23.07           O  
ATOM   1280  CB  PRO   155      37.803  30.470  93.511  1.00 24.07           C  
ATOM   1281  CG  PRO   155      37.448  31.506  94.521  1.00 26.30           C  
ATOM   1282  CD  PRO   155      38.059  32.798  94.094  1.00 24.56           C  
ATOM   1283  N   VAL   156      39.615  29.740  90.817  1.00 21.71           N  
ATOM   1284  CA  VAL   156      39.513  29.441  89.369  1.00 23.19           C  
ATOM   1285  C   VAL   156      39.026  28.008  89.195  1.00 23.59           C  
ATOM   1286  O   VAL   156      39.521  27.102  89.864  1.00 23.15           O  
ATOM   1287  CB  VAL   156      40.891  29.621  88.672  1.00 22.90           C  
ATOM   1288  CG1 VAL   156      40.910  29.090  87.225  1.00 23.40           C  
ATOM   1289  CG2 VAL   156      41.298  31.112  88.662  1.00 22.77           C  
ATOM   1290  N   SER   157      38.051  27.804  88.307  1.00 24.28           N  
ATOM   1291  CA  SER   157      37.609  26.454  87.979  1.00 24.79           C  
ATOM   1292  C   SER   157      38.050  26.188  86.543  1.00 26.87           C  
ATOM   1293  O   SER   157      37.402  26.617  85.601  1.00 28.41           O  
ATOM   1294  CB  SER   157      36.087  26.321  88.133  1.00 24.36           C  
ATOM   1295  OG  SER   157      35.705  24.959  87.976  1.00 26.36           O  
ATOM   1296  N   ALA   158      39.170  25.495  86.443  1.00 28.06           N  
ATOM   1297  CA  ALA   158      39.968  25.298  85.239  1.00 29.72           C  
ATOM   1298  C   ALA   158      39.486  24.078  84.424  1.00 27.18           C  
ATOM   1299  O   ALA   158      39.467  23.000  84.980  1.00 28.44           O  
ATOM   1300  CB  ALA   158      41.404  25.023  85.736  1.00 30.50           C  
ATOM   1301  N   PRO   159      39.160  24.227  83.109  1.00 26.69           N  
ATOM   1302  CA  PRO   159      38.952  22.994  82.309  1.00 25.77           C  
ATOM   1303  C   PRO   159      40.219  22.126  82.200  1.00 25.72           C  
ATOM   1304  O   PRO   159      40.085  20.904  82.101  1.00 25.92           O  
ATOM   1305  CB  PRO   159      38.523  23.518  80.917  1.00 26.68           C  
ATOM   1306  CG  PRO   159      38.026  24.973  81.231  1.00 25.87           C  
ATOM   1307  CD  PRO   159      38.925  25.431  82.297  1.00 26.71           C  
ATOM   1308  N   VAL   160      41.406  22.760  82.177  1.00 25.07           N  
ATOM   1309  CA  VAL   160      42.715  22.083  82.031  0.50 24.81           C  
ATOM   1311  C   VAL   160      43.762  22.827  82.863  1.00 24.91           C  
ATOM   1312  O   VAL   160      43.764  24.069  82.888  1.00 24.66           O  
ATOM   1313  CB  VAL   160      43.206  22.066  80.553  0.50 25.24           C  
ATOM   1315  CG1 VAL   160      44.637  21.498  80.424  0.50 25.55           C  
ATOM   1317  CG2 VAL   160      42.258  21.266  79.680  0.50 23.82           C  
ATOM   1319  N   ILE   161      44.640  22.082  83.516  1.00 24.06           N  
ATOM   1320  CA  ILE   161      45.813  22.637  84.148  1.00 24.65           C  
ATOM   1321  C   ILE   161      47.008  22.055  83.368  1.00 24.59           C  
ATOM   1322  O   ILE   161      47.158  20.804  83.276  1.00 24.67           O  
ATOM   1323  CB  ILE   161      45.861  22.256  85.634  1.00 23.84           C  
ATOM   1324  CG1 ILE   161      44.647  22.865  86.383  1.00 23.65           C  
ATOM   1325  CG2 ILE   161      47.176  22.723  86.286  1.00 25.49           C  
ATOM   1326  CD1 ILE   161      44.449  22.316  87.832  1.00 24.81           C  
ATOM   1327  N   GLU   162      47.832  22.935  82.802  1.00 24.49           N  
ATOM   1328  CA  GLU   162      49.029  22.510  82.004  1.00 25.42           C  
ATOM   1329  C   GLU   162      50.263  22.550  82.886  1.00 25.47           C  
ATOM   1330  O   GLU   162      50.441  23.498  83.683  1.00 25.56           O  
ATOM   1331  CB  GLU   162      49.275  23.449  80.828  1.00 27.13           C  
ATOM   1332  CG  GLU   162      48.122  23.525  79.862  1.00 30.24           C  
ATOM   1333  CD  GLU   162      48.402  24.475  78.703  1.00 36.15           C  
ATOM   1334  OE1 GLU   162      48.943  25.589  78.935  1.00 38.12           O  
ATOM   1335  OE2 GLU   162      48.061  24.115  77.557  1.00 37.86           O  
ATOM   1336  N   VAL   163      51.086  21.519  82.791  1.00 24.32           N  
ATOM   1337  CA  VAL   163      52.240  21.381  83.679  1.00 24.67           C  
ATOM   1338  C   VAL   163      53.469  21.103  82.843  1.00 24.79           C  
ATOM   1339  O   VAL   163      53.529  20.071  82.175  1.00 23.66           O  
ATOM   1340  CB  VAL   163      52.047  20.224  84.669  1.00 24.67           C  
ATOM   1341  CG1 VAL   163      53.234  20.174  85.658  1.00 26.01           C  
ATOM   1342  CG2 VAL   163      50.701  20.365  85.407  1.00 25.37           C  
ATOM   1343  N   TYR   164      54.439  22.022  82.870  1.00 24.12           N  
ATOM   1344  CA  TYR   164      55.685  21.828  82.141  0.50 24.46           C  
ATOM   1346  C   TYR   164      56.800  21.548  83.121  1.00 25.01           C  
ATOM   1347  O   TYR   164      56.932  22.246  84.143  1.00 23.76           O  
ATOM   1348  CB  TYR   164      56.062  23.058  81.320  0.50 24.93           C  
ATOM   1350  CG  TYR   164      55.543  23.084  79.897  0.50 24.76           C  
ATOM   1352  CD1 TYR   164      56.242  22.459  78.865  0.50 25.67           C  
ATOM   1354  CD2 TYR   164      54.371  23.771  79.576  0.50 24.32           C  
ATOM   1356  CE1 TYR   164      55.777  22.495  77.549  0.50 25.23           C  
ATOM   1358  CE2 TYR   164      53.901  23.820  78.258  0.50 25.78           C  
ATOM   1360  CZ  TYR   164      54.618  23.179  77.255  0.50 24.58           C  
ATOM   1362  OH  TYR   164      54.183  23.205  75.955  0.50 26.05           O  
ATOM   1364  N   THR   165      57.598  20.524  82.810  1.00 24.60           N  
ATOM   1365  CA  THR   165      58.721  20.133  83.646  1.00 25.74           C  
ATOM   1366  C   THR   165      59.859  19.571  82.789  1.00 26.38           C  
ATOM   1367  O   THR   165      59.689  19.321  81.584  1.00 25.98           O  
ATOM   1368  CB  THR   165      58.308  19.026  84.664  1.00 26.13           C  
ATOM   1369  OG1 THR   165      58.062  17.796  83.970  1.00 28.08           O  
ATOM   1370  CG2 THR   165      57.063  19.407  85.423  1.00 27.71           C  
ATOM   1371  N   GLU   166      61.014  19.373  83.410  1.00 27.49           N  
ATOM   1372  CA  GLU   166      62.037  18.465  82.849  1.00 28.90           C  
ATOM   1373  C   GLU   166      61.443  17.041  82.813  1.00 28.62           C  
ATOM   1374  O   GLU   166      60.575  16.697  83.625  1.00 27.66           O  
ATOM   1375  CB  GLU   166      63.329  18.485  83.685  1.00 28.88           C  
ATOM   1376  CG  GLU   166      64.035  19.857  83.816  1.00 32.30           C  
ATOM   1377  CD  GLU   166      65.393  19.789  84.587  1.00 33.25           C  
ATOM   1378  OE1 GLU   166      66.261  18.938  84.260  1.00 38.60           O  
ATOM   1379  OE2 GLU   166      65.601  20.604  85.531  1.00 39.33           O  
ATOM   1380  N   HIS   167      61.925  16.187  81.909  1.00 28.85           N  
ATOM   1381  CA  HIS   167      61.309  14.868  81.797  1.00 30.00           C  
ATOM   1382  C   HIS   167      61.433  14.005  83.070  1.00 30.53           C  
ATOM   1383  O   HIS   167      60.535  13.219  83.379  1.00 31.01           O  
ATOM   1384  CB  HIS   167      61.812  14.113  80.568  1.00 30.10           C  
ATOM   1385  CG  HIS   167      61.131  12.793  80.364  1.00 31.45           C  
ATOM   1386  ND1 HIS   167      61.798  11.589  80.450  1.00 33.08           N  
ATOM   1387  CD2 HIS   167      59.834  12.489  80.126  1.00 30.79           C  
ATOM   1388  CE1 HIS   167      60.946  10.601  80.241  1.00 31.32           C  
ATOM   1389  NE2 HIS   167      59.748  11.120  80.042  1.00 34.30           N  
ATOM   1390  N   ASP   168      62.534  14.172  83.800  1.00 31.14           N  
ATOM   1391  CA  ASP   168      62.873  13.310  84.936  1.00 31.77           C  
ATOM   1392  C   ASP   168      61.814  13.207  86.061  1.00 30.99           C  
ATOM   1393  O   ASP   168      61.735  12.179  86.749  1.00 30.88           O  
ATOM   1394  CB  ASP   168      64.282  13.655  85.495  1.00 32.83           C  
ATOM   1395  CG  ASP   168      64.377  15.078  86.118  1.00 35.49           C  
ATOM   1396  OD1 ASP   168      63.511  15.957  85.887  1.00 39.03           O  
ATOM   1397  OD2 ASP   168      65.363  15.318  86.853  1.00 39.88           O  
ATOM   1398  N   ILE   169      60.998  14.248  86.229  1.00 30.06           N  
ATOM   1399  CA  ILE   169      59.994  14.280  87.299  1.00 29.13           C  
ATOM   1400  C   ILE   169      58.536  14.064  86.853  1.00 28.85           C  
ATOM   1401  O   ILE   169      57.628  14.071  87.691  1.00 28.39           O  
ATOM   1402  CB  ILE   169      60.120  15.563  88.179  1.00 29.06           C  
ATOM   1403  CG1 ILE   169      59.759  16.836  87.389  1.00 28.51           C  
ATOM   1404  CG2 ILE   169      61.539  15.629  88.828  1.00 29.06           C  
ATOM   1405  CD1 ILE   169      59.625  18.126  88.261  1.00 28.45           C  
ATOM   1406  N   GLN   170      58.302  13.860  85.554  1.00 28.77           N  
ATOM   1407  CA  GLN   170      56.925  13.670  85.046  1.00 28.63           C  
ATOM   1408  C   GLN   170      56.213  12.484  85.669  1.00 28.72           C  
ATOM   1409  O   GLN   170      55.042  12.559  85.992  1.00 28.16           O  
ATOM   1410  CB  GLN   170      56.906  13.423  83.545  1.00 29.18           C  
ATOM   1411  CG  GLN   170      56.876  14.606  82.707  1.00 28.65           C  
ATOM   1412  CD  GLN   170      56.437  14.259  81.310  1.00 30.21           C  
ATOM   1413  OE1 GLN   170      56.672  13.146  80.822  1.00 26.53           O  
ATOM   1414  NE2 GLN   170      55.799  15.208  80.653  1.00 28.23           N  
ATOM   1415  N   HIS   171      56.919  11.363  85.792  1.00 28.90           N  
ATOM   1416  CA  HIS   171      56.319  10.168  86.369  1.00 29.62           C  
ATOM   1417  C   HIS   171      55.887  10.394  87.832  1.00 29.02           C  
ATOM   1418  O   HIS   171      54.780  10.000  88.228  1.00 29.32           O  
ATOM   1419  CB  HIS   171      57.274   8.979  86.254  1.00 30.17           C  
ATOM   1420  CG  HIS   171      56.769   7.746  86.932  1.00 33.79           C  
ATOM   1421  ND1 HIS   171      55.731   6.993  86.424  1.00 36.44           N  
ATOM   1422  CD2 HIS   171      57.140   7.147  88.089  1.00 36.05           C  
ATOM   1423  CE1 HIS   171      55.503   5.966  87.225  1.00 37.12           C  
ATOM   1424  NE2 HIS   171      56.343   6.037  88.244  1.00 37.28           N  
ATOM   1425  N   ASP   172      56.759  11.031  88.617  1.00 28.48           N  
ATOM   1426  CA  ASP   172      56.457  11.347  90.008  0.50 28.54           C  
ATOM   1428  C   ASP   172      55.253  12.289  90.115  1.00 27.90           C  
ATOM   1429  O   ASP   172      54.340  12.065  90.929  1.00 27.33           O  
ATOM   1430  CB  ASP   172      57.686  11.961  90.689  0.50 29.24           C  
ATOM   1432  CG  ASP   172      57.489  12.207  92.190  0.50 31.34           C  
ATOM   1434  OD1 ASP   172      56.462  11.791  92.776  0.50 34.03           O  
ATOM   1436  OD2 ASP   172      58.388  12.823  92.797  0.50 33.97           O  
ATOM   1438  N   ILE   173      55.242  13.352  89.309  1.00 27.21           N  
ATOM   1439  CA  ILE   173      54.114  14.292  89.356  1.00 26.80           C  
ATOM   1440  C   ILE   173      52.846  13.543  88.987  1.00 27.04           C  
ATOM   1441  O   ILE   173      51.828  13.673  89.675  1.00 26.70           O  
ATOM   1442  CB  ILE   173      54.313  15.495  88.428  1.00 26.32           C  
ATOM   1443  CG1 ILE   173      55.455  16.353  88.959  1.00 28.14           C  
ATOM   1444  CG2 ILE   173      53.003  16.312  88.304  1.00 25.19           C  
ATOM   1445  CD1 ILE   173      55.732  17.600  88.138  1.00 31.54           C  
ATOM   1446  N   THR   174      52.931  12.744  87.921  1.00 27.34           N  
ATOM   1447  CA  THR   174      51.781  11.965  87.422  1.00 27.90           C  
ATOM   1448  C   THR   174      51.231  11.020  88.508  1.00 28.01           C  
ATOM   1449  O   THR   174      50.020  10.972  88.735  1.00 28.15           O  
ATOM   1450  CB  THR   174      52.132  11.156  86.143  1.00 27.98           C  
ATOM   1451  OG1 THR   174      52.556  12.050  85.099  1.00 28.20           O  
ATOM   1452  CG2 THR   174      50.933  10.338  85.675  1.00 27.86           C  
ATOM   1453  N   GLU   175      52.130  10.276  89.156  0.50 27.94           N  
ATOM   1455  CA  GLU   175      51.761   9.383  90.258  0.50 28.08           C  
ATOM   1457  C   GLU   175      51.100  10.168  91.392  0.50 27.46           C  
ATOM   1459  O   GLU   175      50.031   9.787  91.878  0.50 27.74           O  
ATOM   1461  CB  GLU   175      52.989   8.607  90.779  0.50 27.87           C  
ATOM   1463  CG  GLU   175      52.683   7.643  91.927  0.50 29.24           C  
ATOM   1465  CD  GLU   175      53.737   6.539  92.115  0.50 29.46           C  
ATOM   1467  OE1 GLU   175      54.903   6.858  92.439  0.50 31.34           O  
ATOM   1469  OE2 GLU   175      53.390   5.345  91.963  0.50 31.65           O  
ATOM   1471  N   THR   176      51.735  11.264  91.798  1.00 26.86           N  
ATOM   1472  CA  THR   176      51.290  12.040  92.961  1.00 26.79           C  
ATOM   1473  C   THR   176      49.898  12.629  92.753  1.00 26.75           C  
ATOM   1474  O   THR   176      49.036  12.510  93.620  1.00 26.04           O  
ATOM   1475  CB  THR   176      52.302  13.134  93.336  1.00 27.14           C  
ATOM   1476  OG1 THR   176      53.559  12.502  93.631  1.00 27.24           O  
ATOM   1477  CG2 THR   176      51.835  13.934  94.563  1.00 27.58           C  
ATOM   1478  N   ILE   177      49.688  13.240  91.588  1.00 25.71           N  
ATOM   1479  CA  ILE   177      48.384  13.785  91.234  1.00 26.22           C  
ATOM   1480  C   ILE   177      47.297  12.715  91.081  1.00 26.28           C  
ATOM   1481  O   ILE   177      46.218  12.859  91.651  1.00 26.63           O  
ATOM   1482  CB  ILE   177      48.468  14.681  89.955  1.00 25.48           C  
ATOM   1483  CG1 ILE   177      49.376  15.896  90.198  1.00 26.11           C  
ATOM   1484  CG2 ILE   177      47.074  15.098  89.477  1.00 25.45           C  
ATOM   1485  CD1 ILE   177      48.966  16.846  91.337  1.00 28.06           C  
ATOM   1486  N   THR   178      47.571  11.657  90.322  1.00 26.77           N  
ATOM   1487  CA  THR   178      46.582  10.592  90.107  1.00 27.62           C  
ATOM   1488  C   THR   178      46.105  10.020  91.439  1.00 28.01           C  
ATOM   1489  O   THR   178      44.894   9.869  91.655  1.00 28.34           O  
ATOM   1490  CB  THR   178      47.147   9.474  89.227  1.00 27.45           C  
ATOM   1491  OG1 THR   178      47.575  10.049  87.986  1.00 30.23           O  
ATOM   1492  CG2 THR   178      46.079   8.407  88.914  1.00 27.81           C  
ATOM   1493  N   LYS   179      47.056   9.726  92.329  1.00 28.10           N  
ATOM   1494  CA  LYS   179      46.759   9.198  93.667  1.00 29.30           C  
ATOM   1495  C   LYS   179      45.974  10.180  94.568  1.00 28.48           C  
ATOM   1496  O   LYS   179      45.034   9.781  95.254  1.00 28.59           O  
ATOM   1497  CB  LYS   179      48.072   8.748  94.344  1.00 28.31           C  
ATOM   1498  CG  LYS   179      47.945   7.921  95.595  1.00 32.52           C  
ATOM   1499  CD  LYS   179      49.318   7.282  95.904  1.00 31.76           C  
ATOM   1500  CE  LYS   179      49.357   6.506  97.228  1.00 36.71           C  
ATOM   1501  NZ  LYS   179      49.425   7.439  98.395  1.00 38.33           N  
ATOM   1502  N   ALA   180      46.353  11.455  94.583  1.00 28.41           N  
ATOM   1503  CA  ALA   180      45.706  12.417  95.473  1.00 28.03           C  
ATOM   1504  C   ALA   180      44.362  12.985  94.987  1.00 28.23           C  
ATOM   1505  O   ALA   180      43.579  13.493  95.802  1.00 26.75           O  
ATOM   1506  CB  ALA   180      46.671  13.569  95.819  1.00 28.73           C  
ATOM   1507  N   PHE   181      44.113  12.930  93.674  1.00 26.80           N  
ATOM   1508  CA  PHE   181      42.932  13.566  93.073  1.00 27.02           C  
ATOM   1509  C   PHE   181      42.165  12.637  92.124  1.00 26.89           C  
ATOM   1510  O   PHE   181      42.346  12.698  90.901  1.00 26.67           O  
ATOM   1511  CB  PHE   181      43.319  14.889  92.392  1.00 26.12           C  
ATOM   1512  CG  PHE   181      44.028  15.842  93.320  1.00 26.60           C  
ATOM   1513  CD1 PHE   181      43.305  16.619  94.221  1.00 26.91           C  
ATOM   1514  CD2 PHE   181      45.420  15.936  93.316  1.00 25.88           C  
ATOM   1515  CE1 PHE   181      43.960  17.502  95.105  1.00 26.01           C  
ATOM   1516  CE2 PHE   181      46.088  16.797  94.207  1.00 25.21           C  
ATOM   1517  CZ  PHE   181      45.350  17.580  95.101  1.00 26.35           C  
ATOM   1518  N   PRO   182      41.304  11.768  92.694  1.00 27.28           N  
ATOM   1519  CA  PRO   182      40.486  10.821  91.907  1.00 27.25           C  
ATOM   1520  C   PRO   182      39.524  11.513  90.933  1.00 26.41           C  
ATOM   1521  O   PRO   182      39.017  10.869  90.015  1.00 26.37           O  
ATOM   1522  CB  PRO   182      39.663  10.081  92.976  1.00 27.29           C  
ATOM   1523  CG  PRO   182      40.351  10.330  94.259  1.00 28.28           C  
ATOM   1524  CD  PRO   182      41.066  11.627  94.147  1.00 27.15           C  
ATOM   1525  N   ALA   183      39.257  12.803  91.146  1.00 25.54           N  
ATOM   1526  CA  ALA   183      38.359  13.520  90.247  1.00 24.99           C  
ATOM   1527  C   ALA   183      39.032  13.960  88.926  1.00 24.58           C  
ATOM   1528  O   ALA   183      38.354  14.481  88.032  1.00 24.53           O  
ATOM   1529  CB  ALA   183      37.714  14.717  90.954  1.00 24.64           C  
ATOM   1530  N   VAL   184      40.346  13.761  88.790  1.00 23.86           N  
ATOM   1531  CA  VAL   184      41.061  14.225  87.572  1.00 24.22           C  
ATOM   1532  C   VAL   184      41.838  13.083  86.933  1.00 23.90           C  
ATOM   1533  O   VAL   184      42.099  12.075  87.597  1.00 23.81           O  
ATOM   1534  CB  VAL   184      42.043  15.429  87.828  1.00 23.77           C  
ATOM   1535  CG1 VAL   184      41.318  16.626  88.477  1.00 26.01           C  
ATOM   1536  CG2 VAL   184      43.250  14.998  88.672  1.00 25.45           C  
ATOM   1537  N   ASP   185      42.204  13.253  85.654  1.00 23.63           N  
ATOM   1538  CA  ASP   185      43.120  12.365  84.960  1.00 24.73           C  
ATOM   1539  C   ASP   185      44.332  13.188  84.558  1.00 25.11           C  
ATOM   1540  O   ASP   185      44.217  14.401  84.317  1.00 24.08           O  
ATOM   1541  CB  ASP   185      42.485  11.796  83.673  1.00 24.93           C  
ATOM   1542  CG  ASP   185      41.478  10.655  83.947  1.00 29.15           C  
ATOM   1543  OD1 ASP   185      41.589  10.008  85.017  1.00 30.21           O  
ATOM   1544  OD2 ASP   185      40.571  10.410  83.105  1.00 28.23           O  
ATOM   1545  N   VAL   186      45.473  12.516  84.429  1.00 24.79           N  
ATOM   1546  CA  VAL   186      46.681  13.160  83.920  1.00 24.16           C  
ATOM   1547  C   VAL   186      46.963  12.609  82.524  1.00 24.33           C  
ATOM   1548  O   VAL   186      47.102  11.390  82.331  1.00 23.98           O  
ATOM   1549  CB  VAL   186      47.891  12.878  84.829  1.00 25.31           C  
ATOM   1550  CG1 VAL   186      49.156  13.472  84.224  1.00 25.57           C  
ATOM   1551  CG2 VAL   186      47.626  13.405  86.267  1.00 24.03           C  
ATOM   1552  N   ILE   187      47.088  13.510  81.564  1.00 23.30           N  
ATOM   1553  CA  ILE   187      47.397  13.144  80.183  1.00 23.86           C  
ATOM   1554  C   ILE   187      48.818  13.565  79.811  1.00 23.45           C  
ATOM   1555  O   ILE   187      49.156  14.734  79.908  1.00 22.45           O  
ATOM   1556  CB  ILE   187      46.362  13.718  79.202  1.00 23.85           C  
ATOM   1557  CG1 ILE   187      44.980  13.099  79.512  1.00 26.53           C  
ATOM   1558  CG2 ILE   187      46.795  13.383  77.735  1.00 25.15           C  
ATOM   1559  CD1 ILE   187      43.812  13.706  78.758  1.00 28.72           C  
ATOM   1560  N   ARG   188      49.652  12.602  79.416  1.00 22.73           N  
ATOM   1561  CA  ARG   188      50.999  12.938  78.990  1.00 23.62           C  
ATOM   1562  C   ARG   188      50.960  13.434  77.527  1.00 23.19           C  
ATOM   1563  O   ARG   188      50.550  12.714  76.631  1.00 23.50           O  
ATOM   1564  CB  ARG   188      51.935  11.739  79.166  1.00 24.18           C  
ATOM   1565  CG  ARG   188      53.358  12.066  78.854  1.00 29.11           C  
ATOM   1566  CD  ARG   188      54.182  10.781  78.804  1.00 36.71           C  
ATOM   1567  NE  ARG   188      55.594  11.107  78.671  1.00 41.91           N  
ATOM   1568  CZ  ARG   188      56.399  10.631  77.732  1.00 46.11           C  
ATOM   1569  NH1 ARG   188      55.964   9.748  76.826  1.00 48.26           N  
ATOM   1570  NH2 ARG   188      57.670  11.012  77.731  1.00 47.42           N  
ATOM   1571  N   VAL   189      51.380  14.676  77.296  1.00 22.79           N  
ATOM   1572  CA  VAL   189      51.366  15.243  75.939  1.00 22.54           C  
ATOM   1573  C   VAL   189      52.673  14.936  75.255  1.00 22.95           C  
ATOM   1574  O   VAL   189      52.687  14.427  74.133  1.00 23.11           O  
ATOM   1575  CB  VAL   189      51.084  16.775  75.951  1.00 21.83           C  
ATOM   1576  CG1 VAL   189      51.130  17.328  74.544  1.00 24.12           C  
ATOM   1577  CG2 VAL   189      49.723  17.084  76.638  1.00 22.40           C  
ATOM   1578  N   ASN   190      53.782  15.206  75.947  1.00 23.34           N  
ATOM   1579  CA  ASN   190      55.124  14.939  75.427  1.00 23.37           C  
ATOM   1580  C   ASN   190      56.065  14.813  76.613  1.00 24.01           C  
ATOM   1581  O   ASN   190      55.602  14.805  77.748  1.00 24.05           O  
ATOM   1582  CB  ASN   190      55.562  16.020  74.427  1.00 23.41           C  
ATOM   1583  CG  ASN   190      55.572  17.438  75.040  1.00 23.59           C  
ATOM   1584  OD1 ASN   190      56.091  17.629  76.121  1.00 23.01           O  
ATOM   1585  ND2 ASN   190      55.007  18.420  74.335  1.00 23.21           N  
ATOM   1586  N   ASP   191      57.373  14.735  76.367  1.00 24.18           N  
ATOM   1587  CA  ASP   191      58.333  14.466  77.451  1.00 25.89           C  
ATOM   1588  C   ASP   191      58.420  15.569  78.507  1.00 25.25           C  
ATOM   1589  O   ASP   191      58.990  15.354  79.577  1.00 24.90           O  
ATOM   1590  CB  ASP   191      59.735  14.205  76.873  1.00 26.80           C  
ATOM   1591  CG  ASP   191      59.851  12.841  76.208  1.00 30.70           C  
ATOM   1592  OD1 ASP   191      58.883  12.044  76.297  1.00 35.89           O  
ATOM   1593  OD2 ASP   191      60.898  12.564  75.580  1.00 33.80           O  
ATOM   1594  N   GLU   192      57.895  16.749  78.185  1.00 24.14           N  
ATOM   1595  CA  GLU   192      57.988  17.905  79.073  1.00 25.47           C  
ATOM   1596  C   GLU   192      56.658  18.541  79.432  1.00 24.52           C  
ATOM   1597  O   GLU   192      56.637  19.507  80.170  1.00 25.59           O  
ATOM   1598  CB  GLU   192      58.917  18.950  78.460  1.00 26.31           C  
ATOM   1599  CG  GLU   192      60.369  18.442  78.432  1.00 30.67           C  
ATOM   1600  CD  GLU   192      61.278  19.187  77.468  1.00 37.45           C  
ATOM   1601  OE1 GLU   192      60.932  20.300  77.012  1.00 39.13           O  
ATOM   1602  OE2 GLU   192      62.358  18.640  77.164  1.00 40.53           O  
ATOM   1603  N   LYS   193      55.557  18.003  78.926  1.00 22.75           N  
ATOM   1604  CA  LYS   193      54.232  18.578  79.189  1.00 22.40           C  
ATOM   1605  C   LYS   193      53.193  17.535  79.579  1.00 22.60           C  
ATOM   1606  O   LYS   193      53.074  16.511  78.890  1.00 22.61           O  
ATOM   1607  CB  LYS   193      53.727  19.351  77.963  1.00 21.34           C  
ATOM   1608  CG  LYS   193      52.448  20.175  78.282  1.00 23.45           C  
ATOM   1609  CD  LYS   193      51.908  20.848  77.041  1.00 27.98           C  
ATOM   1610  CE  LYS   193      50.708  21.741  77.436  1.00 32.37           C  
ATOM   1611  NZ  LYS   193      50.217  22.474  76.221  1.00 37.14           N  
ATOM   1612  N   LEU   194      52.478  17.808  80.677  1.00 23.12           N  
ATOM   1613  CA  LEU   194      51.277  17.062  81.118  1.00 23.93           C  
ATOM   1614  C   LEU   194      50.053  17.994  81.145  1.00 23.51           C  
ATOM   1615  O   LEU   194      50.155  19.187  81.476  1.00 25.01           O  
ATOM   1616  CB  LEU   194      51.435  16.505  82.562  1.00 24.36           C  
ATOM   1617  CG  LEU   194      52.599  15.609  82.915  1.00 26.27           C  
ATOM   1618  CD1 LEU   194      52.728  15.487  84.438  1.00 26.26           C  
ATOM   1619  CD2 LEU   194      52.383  14.244  82.252  1.00 29.88           C  
ATOM   1620  N   ASN   195      48.897  17.436  80.825  1.00 22.85           N  
ATOM   1621  CA  ASN   195      47.627  18.098  81.067  1.00 23.97           C  
ATOM   1622  C   ASN   195      46.917  17.373  82.192  1.00 23.50           C  
ATOM   1623  O   ASN   195      46.808  16.141  82.175  1.00 25.44           O  
ATOM   1624  CB  ASN   195      46.741  18.018  79.828  1.00 24.15           C  
ATOM   1625  CG  ASN   195      47.229  18.904  78.700  1.00 26.20           C  
ATOM   1626  OD1 ASN   195      47.997  19.823  78.923  1.00 27.66           O  
ATOM   1627  ND2 ASN   195      46.767  18.629  77.484  1.00 28.00           N  
ATOM   1628  N   ILE   196      46.410  18.127  83.152  1.00 22.67           N  
ATOM   1629  CA  ILE   196      45.526  17.574  84.157  1.00 22.84           C  
ATOM   1630  C   ILE   196      44.096  18.024  83.788  1.00 23.07           C  
ATOM   1631  O   ILE   196      43.841  19.242  83.650  1.00 23.10           O  
ATOM   1632  CB  ILE   196      45.883  18.079  85.550  1.00 22.56           C  
ATOM   1633  CG1 ILE   196      47.321  17.667  85.909  1.00 24.46           C  
ATOM   1634  CG2 ILE   196      44.854  17.574  86.572  1.00 24.19           C  
ATOM   1635  CD1 ILE   196      47.926  18.445  87.081  1.00 25.55           C  
ATOM   1636  N   VAL   197      43.189  17.055  83.641  1.00 22.22           N  
ATOM   1637  CA  VAL   197      41.827  17.312  83.118  1.00 21.63           C  
ATOM   1638  C   VAL   197      40.788  16.621  84.018  1.00 22.47           C  
ATOM   1639  O   VAL   197      41.141  15.737  84.810  1.00 22.16           O  
ATOM   1640  CB  VAL   197      41.641  16.791  81.641  1.00 20.72           C  
ATOM   1641  CG1 VAL   197      42.502  17.560  80.644  1.00 24.23           C  
ATOM   1642  CG2 VAL   197      41.948  15.267  81.541  1.00 19.32           C  
ATOM   1643  N   PRO   198      39.500  17.022  83.908  1.00 22.65           N  
ATOM   1644  CA  PRO   198      38.511  16.247  84.681  1.00 22.51           C  
ATOM   1645  C   PRO   198      38.528  14.774  84.265  1.00 22.53           C  
ATOM   1646  O   PRO   198      38.845  14.434  83.115  1.00 23.02           O  
ATOM   1647  CB  PRO   198      37.169  16.883  84.300  1.00 21.85           C  
ATOM   1648  CG  PRO   198      37.530  18.317  83.841  1.00 23.58           C  
ATOM   1649  CD  PRO   198      38.897  18.153  83.151  1.00 21.60           C  
ATOM   1650  N   LYS   199      38.157  13.897  85.186  1.00 22.88           N  
ATOM   1651  CA  LYS   199      38.168  12.474  84.881  1.00 22.86           C  
ATOM   1652  C   LYS   199      37.294  12.167  83.678  1.00 23.13           C  
ATOM   1653  O   LYS   199      36.173  12.663  83.556  1.00 23.11           O  
ATOM   1654  CB  LYS   199      37.757  11.642  86.114  1.00 23.14           C  
ATOM   1655  CG  LYS   199      37.963  10.141  85.884  1.00 26.25           C  
ATOM   1656  CD  LYS   199      38.082   9.393  87.188  1.00 31.96           C  
ATOM   1657  CE  LYS   199      38.436   7.907  86.975  1.00 36.76           C  
ATOM   1658  NZ  LYS   199      39.836   7.763  86.397  1.00 39.94           N  
ATOM   1659  N   GLY   200      37.830  11.360  82.770  1.00 23.34           N  
ATOM   1660  CA  GLY   200      37.103  10.945  81.573  1.00 24.15           C  
ATOM   1661  C   GLY   200      37.262  11.895  80.392  1.00 23.87           C  
ATOM   1662  O   GLY   200      36.852  11.566  79.278  1.00 24.98           O  
ATOM   1663  N   VAL   201      37.880  13.061  80.607  1.00 23.17           N  
ATOM   1664  CA  VAL   201      38.086  14.017  79.515  1.00 23.28           C  
ATOM   1665  C   VAL   201      39.338  13.660  78.712  1.00 23.78           C  
ATOM   1666  O   VAL   201      40.379  13.293  79.280  1.00 23.42           O  
ATOM   1667  CB  VAL   201      38.199  15.469  80.058  1.00 22.66           C  
ATOM   1668  CG1 VAL   201      38.784  16.473  79.002  1.00 23.26           C  
ATOM   1669  CG2 VAL   201      36.823  15.925  80.614  1.00 22.85           C  
ATOM   1670  N   SER   202      39.229  13.755  77.396  1.00 23.76           N  
ATOM   1671  CA  SER   202      40.381  13.594  76.515  1.00 23.73           C  
ATOM   1672  C   SER   202      40.013  14.008  75.100  1.00 23.53           C  
ATOM   1673  O   SER   202      38.820  14.117  74.756  1.00 23.55           O  
ATOM   1674  CB  SER   202      40.877  12.133  76.511  1.00 23.24           C  
ATOM   1675  OG  SER   202      39.953  11.270  75.866  1.00 25.09           O  
ATOM   1676  N   LYS   203      41.041  14.174  74.266  1.00 23.78           N  
ATOM   1677  CA  LYS   203      40.816  14.429  72.835  1.00 24.42           C  
ATOM   1678  C   LYS   203      39.967  13.338  72.193  1.00 24.78           C  
ATOM   1679  O   LYS   203      39.042  13.648  71.456  1.00 25.33           O  
ATOM   1680  CB  LYS   203      42.133  14.566  72.085  1.00 24.43           C  
ATOM   1681  CG  LYS   203      42.904  15.830  72.372  1.00 24.22           C  
ATOM   1682  CD  LYS   203      44.319  15.747  71.699  1.00 24.40           C  
ATOM   1683  CE  LYS   203      44.861  17.178  71.476  1.00 25.18           C  
ATOM   1684  NZ  LYS   203      46.372  17.189  71.101  1.00 27.07           N  
ATOM   1685  N   GLU   204      40.273  12.070  72.476  1.00 24.74           N  
ATOM   1686  CA  GLU   204      39.565  10.962  71.860  1.00 25.22           C  
ATOM   1687  C   GLU   204      38.110  10.856  72.355  1.00 25.34           C  
ATOM   1688  O   GLU   204      37.205  10.479  71.600  1.00 25.63           O  
ATOM   1689  CB  GLU   204      40.316   9.638  72.067  1.00 25.18           C  
ATOM   1690  CG  GLU   204      40.476   9.140  73.525  1.00 26.39           C  
ATOM   1691  CD  GLU   204      41.728   9.648  74.230  1.00 28.45           C  
ATOM   1692  OE1 GLU   204      42.320  10.686  73.810  1.00 27.42           O  
ATOM   1693  OE2 GLU   204      42.103   8.993  75.240  1.00 27.94           O  
ATOM   1694  N   ALA   205      37.896  11.155  73.633  1.00 25.21           N  
ATOM   1695  CA  ALA   205      36.551  11.140  74.178  1.00 25.48           C  
ATOM   1696  C   ALA   205      35.704  12.277  73.560  1.00 25.74           C  
ATOM   1697  O   ALA   205      34.506  12.085  73.256  1.00 24.87           O  
ATOM   1698  CB  ALA   205      36.602  11.262  75.696  1.00 26.78           C  
ATOM   1699  N   GLY   206      36.331  13.442  73.376  1.00 26.29           N  
ATOM   1700  CA  GLY   206      35.640  14.624  72.822  1.00 26.95           C  
ATOM   1701  C   GLY   206      35.268  14.331  71.360  1.00 27.05           C  
ATOM   1702  O   GLY   206      34.129  14.554  70.931  1.00 26.85           O  
ATOM   1703  N   LEU   207      36.233  13.798  70.615  1.00 27.18           N  
ATOM   1704  CA  LEU   207      36.010  13.370  69.240  1.00 28.57           C  
ATOM   1705  C   LEU   207      34.881  12.342  69.137  1.00 28.45           C  
ATOM   1706  O   LEU   207      34.008  12.481  68.286  1.00 29.73           O  
ATOM   1707  CB  LEU   207      37.306  12.843  68.603  1.00 28.40           C  
ATOM   1708  CG  LEU   207      37.299  12.573  67.080  1.00 30.73           C  
ATOM   1709  CD1 LEU   207      36.715  13.757  66.324  1.00 31.91           C  
ATOM   1710  CD2 LEU   207      38.732  12.337  66.627  1.00 29.73           C  
ATOM   1711  N   ALA   208      34.869  11.336  70.019  1.00 28.38           N  
ATOM   1712  CA  ALA   208      33.753  10.374  70.037  1.00 28.76           C  
ATOM   1713  C   ALA   208      32.393  11.036  70.262  1.00 28.80           C  
ATOM   1714  O   ALA   208      31.392  10.637  69.640  1.00 29.85           O  
ATOM   1715  CB  ALA   208      33.989   9.278  71.060  1.00 28.97           C  
ATOM   1716  N   LEU   209      32.341  12.038  71.147  1.00 28.07           N  
ATOM   1717  CA  LEU   209      31.084  12.727  71.442  0.50 27.57           C  
ATOM   1719  C   LEU   209      30.596  13.496  70.215  1.00 27.61           C  
ATOM   1720  O   LEU   209      29.392  13.520  69.912  1.00 26.72           O  
ATOM   1721  CB  LEU   209      31.220  13.676  72.640  0.50 27.41           C  
ATOM   1723  CG  LEU   209      31.416  13.169  74.076  0.50 27.68           C  
ATOM   1725  CD1 LEU   209      31.349  14.332  75.046  0.50 28.55           C  
ATOM   1727  CD2 LEU   209      30.382  12.113  74.470  0.50 28.32           C  
ATOM   1729  N   VAL   210      31.526  14.126  69.503  1.00 27.12           N  
ATOM   1730  CA  VAL   210      31.157  14.895  68.322  1.00 28.29           C  
ATOM   1731  C   VAL   210      30.689  13.954  67.202  1.00 28.23           C  
ATOM   1732  O   VAL   210      29.676  14.225  66.551  1.00 28.96           O  
ATOM   1733  CB  VAL   210      32.301  15.829  67.883  1.00 28.91           C  
ATOM   1734  CG1 VAL   210      32.044  16.463  66.500  1.00 30.73           C  
ATOM   1735  CG2 VAL   210      32.503  16.935  68.926  1.00 28.46           C  
ATOM   1736  N   ALA   211      31.405  12.855  67.008  1.00 27.53           N  
ATOM   1737  CA  ALA   211      31.037  11.889  65.955  1.00 29.77           C  
ATOM   1738  C   ALA   211      29.634  11.330  66.251  1.00 30.23           C  
ATOM   1739  O   ALA   211      28.777  11.275  65.357  1.00 31.50           O  
ATOM   1740  CB  ALA   211      32.052  10.785  65.874  1.00 28.32           C  
ATOM   1741  N   SER   212      29.389  10.948  67.507  1.00 31.44           N  
ATOM   1742  CA  SER   212      28.087  10.426  67.907  0.50 31.31           C  
ATOM   1744  C   SER   212      26.966  11.446  67.658  1.00 31.67           C  
ATOM   1745  O   SER   212      25.882  11.085  67.178  1.00 30.94           O  
ATOM   1746  CB  SER   212      28.103   9.983  69.378  0.50 31.80           C  
ATOM   1748  OG  SER   212      28.942   8.849  69.550  0.50 31.57           O  
ATOM   1750  N   GLU   213      27.228  12.714  67.983  1.00 31.98           N  
ATOM   1751  CA  GLU   213      26.271  13.804  67.745  1.00 32.98           C  
ATOM   1752  C   GLU   213      25.899  13.918  66.260  1.00 32.21           C  
ATOM   1753  O   GLU   213      24.760  14.240  65.919  1.00 31.44           O  
ATOM   1754  CB  GLU   213      26.815  15.143  68.288  1.00 33.71           C  
ATOM   1755  CG  GLU   213      25.921  16.357  68.005  1.00 36.91           C  
ATOM   1756  CD  GLU   213      24.602  16.358  68.767  1.00 41.90           C  
ATOM   1757  OE1 GLU   213      24.389  15.516  69.668  1.00 42.24           O  
ATOM   1758  OE2 GLU   213      23.759  17.233  68.466  1.00 44.94           O  
ATOM   1759  N   LEU   214      26.860  13.628  65.400  1.00 31.56           N  
ATOM   1760  CA  LEU   214      26.669  13.655  63.955  1.00 31.83           C  
ATOM   1761  C   LEU   214      26.129  12.349  63.367  1.00 31.36           C  
ATOM   1762  O   LEU   214      25.994  12.242  62.154  1.00 32.00           O  
ATOM   1763  CB  LEU   214      27.986  14.012  63.262  1.00 31.66           C  
ATOM   1764  CG  LEU   214      28.554  15.405  63.558  1.00 32.94           C  
ATOM   1765  CD1 LEU   214      29.941  15.500  62.964  1.00 32.27           C  
ATOM   1766  CD2 LEU   214      27.652  16.491  63.025  1.00 34.12           C  
ATOM   1767  N   GLY   215      25.837  11.363  64.211  1.00 30.66           N  
ATOM   1768  CA  GLY   215      25.340  10.066  63.730  1.00 31.52           C  
ATOM   1769  C   GLY   215      26.423   9.187  63.115  1.00 31.35           C  
ATOM   1770  O   GLY   215      26.134   8.258  62.348  1.00 30.33           O  
ATOM   1771  N   LEU   216      27.679   9.481  63.445  1.00 31.95           N  
ATOM   1772  CA  LEU   216      28.823   8.740  62.909  1.00 33.17           C  
ATOM   1773  C   LEU   216      29.469   7.892  63.993  1.00 34.61           C  
ATOM   1774  O   LEU   216      29.202   8.097  65.174  1.00 35.18           O  
ATOM   1775  CB  LEU   216      29.856   9.699  62.314  1.00 33.09           C  
ATOM   1776  CG  LEU   216      29.341  10.716  61.286  1.00 34.24           C  
ATOM   1777  CD1 LEU   216      30.383  11.781  61.015  1.00 35.51           C  
ATOM   1778  CD2 LEU   216      28.954  10.016  60.009  1.00 34.74           C  
ATOM   1779  N   SER   217      30.255   6.891  63.595  1.00 36.05           N  
ATOM   1780  CA  SER   217      31.118   6.198  64.550  1.00 37.27           C  
ATOM   1781  C   SER   217      32.572   6.603  64.317  1.00 37.16           C  
ATOM   1782  O   SER   217      32.890   7.227  63.295  1.00 37.08           O  
ATOM   1783  CB  SER   217      30.977   4.680  64.452  1.00 37.36           C  
ATOM   1784  OG  SER   217      31.434   4.162  63.207  1.00 39.38           O  
ATOM   1785  N   MET   218      33.450   6.241  65.252  1.00 36.89           N  
ATOM   1786  CA  MET   218      34.900   6.434  65.054  1.00 36.52           C  
ATOM   1787  C   MET   218      35.416   5.826  63.729  1.00 35.52           C  
ATOM   1788  O   MET   218      36.384   6.340  63.146  1.00 35.11           O  
ATOM   1789  CB  MET   218      35.699   5.948  66.279  1.00 36.94           C  
ATOM   1790  CG  MET   218      35.501   6.844  67.527  1.00 39.01           C  
ATOM   1791  SD  MET   218      35.943   8.725  67.266  0.50 41.58          SE  
ATOM   1792  CE  MET   218      37.884   8.654  67.325  1.00 41.87           C  
ATOM   1793  N   ASP   219      34.756   4.762  63.257  0.50 34.83           N  
ATOM   1795  CA  ASP   219      35.063   4.146  61.957  0.50 34.53           C  
ATOM   1797  C   ASP   219      35.023   5.116  60.772  0.50 34.07           C  
ATOM   1799  O   ASP   219      35.703   4.899  59.758  0.50 33.98           O  
ATOM   1801  CB  ASP   219      34.117   2.970  61.664  0.50 34.79           C  
ATOM   1803  CG  ASP   219      34.244   1.834  62.673  0.50 35.41           C  
ATOM   1805  OD1 ASP   219      35.291   1.713  63.352  0.50 35.59           O  
ATOM   1807  OD2 ASP   219      33.285   1.045  62.775  0.50 38.09           O  
ATOM   1809  N   ASP   220      34.222   6.167  60.910  1.00 33.45           N  
ATOM   1810  CA  ASP   220      33.965   7.135  59.846  1.00 33.21           C  
ATOM   1811  C   ASP   220      34.915   8.335  59.921  1.00 31.68           C  
ATOM   1812  O   ASP   220      34.766   9.296  59.152  1.00 31.82           O  
ATOM   1813  CB  ASP   220      32.513   7.654  59.956  1.00 33.38           C  
ATOM   1814  CG  ASP   220      31.467   6.539  59.830  1.00 36.94           C  
ATOM   1815  OD1 ASP   220      31.547   5.724  58.870  1.00 35.69           O  
ATOM   1816  OD2 ASP   220      30.552   6.495  60.694  1.00 39.56           O  
ATOM   1817  N   VAL   221      35.863   8.279  60.857  1.00 29.72           N  
ATOM   1818  CA  VAL   221      36.720   9.418  61.186  1.00 29.05           C  
ATOM   1819  C   VAL   221      38.148   9.248  60.657  1.00 28.17           C  
ATOM   1820  O   VAL   221      38.740   8.159  60.765  1.00 28.41           O  
ATOM   1821  CB  VAL   221      36.790   9.635  62.712  1.00 28.79           C  
ATOM   1822  CG1 VAL   221      37.689  10.800  63.041  1.00 30.06           C  
ATOM   1823  CG2 VAL   221      35.380   9.848  63.307  1.00 31.31           C  
ATOM   1824  N   VAL   222      38.672  10.319  60.057  1.00 27.83           N  
ATOM   1825  CA  VAL   222      40.110  10.473  59.815  1.00 28.23           C  
ATOM   1826  C   VAL   222      40.653  11.421  60.884  1.00 27.20           C  
ATOM   1827  O   VAL   222      40.133  12.543  61.058  1.00 27.97           O  
ATOM   1828  CB  VAL   222      40.425  11.042  58.399  1.00 28.20           C  
ATOM   1829  CG1 VAL   222      41.961  11.195  58.185  1.00 29.34           C  
ATOM   1830  CG2 VAL   222      39.803  10.172  57.328  1.00 30.60           C  
ATOM   1831  N   ALA   223      41.658  10.972  61.643  1.00 26.30           N  
ATOM   1832  CA  ALA   223      42.220  11.821  62.692  1.00 25.77           C  
ATOM   1833  C   ALA   223      43.707  12.042  62.431  1.00 26.13           C  
ATOM   1834  O   ALA   223      44.431  11.092  62.163  1.00 25.66           O  
ATOM   1835  CB  ALA   223      41.999  11.215  64.064  1.00 26.54           C  
ATOM   1836  N   ILE   224      44.157  13.296  62.469  1.00 24.89           N  
ATOM   1837  CA  ILE   224      45.565  13.598  62.158  1.00 24.93           C  
ATOM   1838  C   ILE   224      46.203  14.224  63.398  1.00 24.71           C  
ATOM   1839  O   ILE   224      45.780  15.324  63.837  1.00 24.37           O  
ATOM   1840  CB  ILE   224      45.690  14.545  60.947  1.00 24.68           C  
ATOM   1841  CG1 ILE   224      44.926  13.981  59.740  1.00 25.85           C  
ATOM   1842  CG2 ILE   224      47.177  14.741  60.567  1.00 25.43           C  
ATOM   1843  CD1 ILE   224      45.102  14.817  58.464  1.00 26.42           C  
ATOM   1844  N   GLY   225      47.193  13.531  63.976  1.00 24.29           N  
ATOM   1845  CA  GLY   225      47.828  13.965  65.243  1.00 24.00           C  
ATOM   1846  C   GLY   225      49.365  13.959  65.143  1.00 23.46           C  
ATOM   1847  O   GLY   225      49.934  13.514  64.134  1.00 23.07           O  
ATOM   1848  N   HIS   226      50.044  14.381  66.201  1.00 22.78           N  
ATOM   1849  CA  HIS   226      51.527  14.471  66.158  1.00 23.19           C  
ATOM   1850  C   HIS   226      52.239  14.197  67.489  1.00 23.03           C  
ATOM   1851  O   HIS   226      53.450  14.048  67.496  1.00 22.15           O  
ATOM   1852  CB  HIS   226      51.993  15.824  65.559  1.00 23.23           C  
ATOM   1853  CG  HIS   226      51.933  16.971  66.526  1.00 23.91           C  
ATOM   1854  ND1 HIS   226      50.743  17.456  67.032  1.00 25.13           N  
ATOM   1855  CD2 HIS   226      52.914  17.748  67.046  1.00 25.12           C  
ATOM   1856  CE1 HIS   226      50.996  18.472  67.844  1.00 25.61           C  
ATOM   1857  NE2 HIS   226      52.305  18.675  67.864  1.00 23.93           N  
ATOM   1858  N   GLN   227      51.500  14.155  68.608  1.00 22.83           N  
ATOM   1859  CA  GLN   227      52.134  13.879  69.923  1.00 23.45           C  
ATOM   1860  C   GLN   227      51.501  12.700  70.685  1.00 22.59           C  
ATOM   1861  O   GLN   227      50.537  12.093  70.215  1.00 22.33           O  
ATOM   1862  CB  GLN   227      52.113  15.133  70.801  1.00 22.88           C  
ATOM   1863  CG  GLN   227      52.760  16.301  70.143  1.00 25.56           C  
ATOM   1864  CD  GLN   227      52.962  17.441  71.109  1.00 28.03           C  
ATOM   1865  OE1 GLN   227      52.022  18.141  71.458  1.00 29.31           O  
ATOM   1866  NE2 GLN   227      54.190  17.623  71.539  1.00 25.63           N  
ATOM   1867  N   TYR   228      52.045  12.386  71.858  1.00 22.47           N  
ATOM   1868  CA  TYR   228      51.575  11.199  72.618  1.00 22.82           C  
ATOM   1869  C   TYR   228      50.096  11.257  72.947  1.00 23.18           C  
ATOM   1870  O   TYR   228      49.387  10.227  72.910  1.00 23.61           O  
ATOM   1871  CB  TYR   228      52.399  10.986  73.899  1.00 23.04           C  
ATOM   1872  CG  TYR   228      53.850  10.655  73.611  1.00 24.87           C  
ATOM   1873  CD1 TYR   228      54.202   9.458  72.991  1.00 28.27           C  
ATOM   1874  CD2 TYR   228      54.865  11.517  73.980  1.00 28.89           C  
ATOM   1875  CE1 TYR   228      55.549   9.121  72.725  1.00 28.17           C  
ATOM   1876  CE2 TYR   228      56.233  11.195  73.722  1.00 28.28           C  
ATOM   1877  CZ  TYR   228      56.546   9.999  73.091  1.00 28.51           C  
ATOM   1878  OH  TYR   228      57.875   9.681  72.846  1.00 27.14           O  
ATOM   1879  N   ASP   229      49.609  12.460  73.215  1.00 22.58           N  
ATOM   1880  CA  ASP   229      48.221  12.594  73.618  1.00 23.33           C  
ATOM   1881  C   ASP   229      47.262  12.372  72.454  1.00 23.38           C  
ATOM   1882  O   ASP   229      46.058  12.244  72.666  1.00 24.04           O  
ATOM   1883  CB  ASP   229      47.959  13.940  74.312  1.00 23.91           C  
ATOM   1884  CG  ASP   229      48.228  15.132  73.408  1.00 24.90           C  
ATOM   1885  OD1 ASP   229      49.172  15.064  72.593  1.00 27.32           O  
ATOM   1886  OD2 ASP   229      47.499  16.154  73.523  1.00 27.38           O  
ATOM   1887  N   ASP   230      47.799  12.378  71.231  1.00 23.48           N  
ATOM   1888  CA  ASP   230      47.022  12.092  70.011  1.00 24.70           C  
ATOM   1889  C   ASP   230      46.957  10.601  69.704  1.00 25.26           C  
ATOM   1890  O   ASP   230      46.155  10.143  68.863  1.00 25.79           O  
ATOM   1891  CB  ASP   230      47.652  12.817  68.831  1.00 23.62           C  
ATOM   1892  CG  ASP   230      47.716  14.333  69.056  1.00 25.09           C  
ATOM   1893  OD1 ASP   230      46.675  14.930  69.417  1.00 25.87           O  
ATOM   1894  OD2 ASP   230      48.804  14.916  68.925  1.00 25.09           O  
ATOM   1895  N   LEU   231      47.773   9.810  70.387  1.00 26.29           N  
ATOM   1896  CA  LEU   231      47.804   8.372  70.052  1.00 26.35           C  
ATOM   1897  C   LEU   231      46.455   7.652  70.147  1.00 27.21           C  
ATOM   1898  O   LEU   231      46.104   6.861  69.251  1.00 27.17           O  
ATOM   1899  CB  LEU   231      48.858   7.647  70.892  1.00 27.34           C  
ATOM   1900  CG  LEU   231      50.265   7.741  70.328  1.00 29.56           C  
ATOM   1901  CD1 LEU   231      51.271   7.174  71.343  1.00 30.37           C  
ATOM   1902  CD2 LEU   231      50.346   6.987  68.964  1.00 30.69           C  
ATOM   1903  N   PRO   232      45.690   7.874  71.236  1.00 27.17           N  
ATOM   1904  CA  PRO   232      44.395   7.182  71.317  1.00 27.16           C  
ATOM   1905  C   PRO   232      43.461   7.491  70.154  1.00 27.46           C  
ATOM   1906  O   PRO   232      42.847   6.575  69.619  1.00 27.80           O  
ATOM   1907  CB  PRO   232      43.804   7.699  72.642  1.00 27.75           C  
ATOM   1908  CG  PRO   232      45.047   8.054  73.455  1.00 27.55           C  
ATOM   1909  CD  PRO   232      45.981   8.650  72.458  1.00 26.76           C  
ATOM   1910  N   MET   233      43.371   8.751  69.722  1.00 27.42           N  
ATOM   1911  CA  MET   233      42.440   9.030  68.639  1.00 28.57           C  
ATOM   1912  C   MET   233      42.994   8.478  67.317  1.00 28.53           C  
ATOM   1913  O   MET   233      42.218   8.092  66.450  1.00 29.36           O  
ATOM   1914  CB  MET   233      42.101  10.519  68.529  1.00 29.13           C  
ATOM   1915  CG  MET   233      43.183  11.353  67.938  1.00 27.81           C  
ATOM   1916  SD  MET   233      42.680  13.240  67.696  0.50 30.15          SE  
ATOM   1917  CE  MET   233      44.251  13.669  66.592  1.00 32.01           C  
ATOM   1918  N   ILE   234      44.318   8.447  67.176  1.00 27.31           N  
ATOM   1919  CA  ILE   234      44.958   7.823  66.013  1.00 28.21           C  
ATOM   1920  C   ILE   234      44.637   6.325  65.959  1.00 28.21           C  
ATOM   1921  O   ILE   234      44.330   5.807  64.873  1.00 29.17           O  
ATOM   1922  CB  ILE   234      46.508   8.081  65.966  1.00 26.73           C  
ATOM   1923  CG1 ILE   234      46.783   9.530  65.567  1.00 28.11           C  
ATOM   1924  CG2 ILE   234      47.215   7.093  64.970  1.00 28.48           C  
ATOM   1925  CD1 ILE   234      48.201  10.011  65.865  1.00 28.72           C  
ATOM   1926  N   GLU   235      44.686   5.643  67.111  1.00 28.54           N  
ATOM   1927  CA  GLU   235      44.384   4.220  67.177  0.50 29.19           C  
ATOM   1929  C   GLU   235      42.883   3.938  66.985  1.00 29.62           C  
ATOM   1930  O   GLU   235      42.500   2.945  66.343  1.00 28.04           O  
ATOM   1931  CB  GLU   235      44.873   3.645  68.509  0.50 29.29           C  
ATOM   1933  CG  GLU   235      46.276   3.029  68.460  0.50 30.56           C  
ATOM   1935  CD  GLU   235      47.359   3.906  69.051  0.50 31.08           C  
ATOM   1937  OE1 GLU   235      47.777   3.650  70.211  0.50 30.84           O  
ATOM   1939  OE2 GLU   235      47.796   4.847  68.359  0.50 28.87           O  
ATOM   1941  N   LEU   236      42.044   4.813  67.537  1.00 28.58           N  
ATOM   1942  CA  LEU   236      40.593   4.605  67.535  1.00 29.29           C  
ATOM   1943  C   LEU   236      39.868   5.059  66.250  1.00 29.42           C  
ATOM   1944  O   LEU   236      38.822   4.498  65.889  1.00 28.58           O  
ATOM   1945  CB  LEU   236      39.966   5.252  68.792  1.00 30.15           C  
ATOM   1946  CG  LEU   236      40.315   4.638  70.158  1.00 31.75           C  
ATOM   1947  CD1 LEU   236      40.036   5.637  71.300  1.00 36.79           C  
ATOM   1948  CD2 LEU   236      39.595   3.318  70.423  1.00 37.77           C  
ATOM   1949  N   ALA   237      40.418   6.062  65.554  1.00 29.65           N  
ATOM   1950  CA  ALA   237      39.818   6.548  64.293  1.00 29.89           C  
ATOM   1951  C   ALA   237      39.876   5.488  63.196  1.00 29.89           C  
ATOM   1952  O   ALA   237      40.800   4.661  63.183  1.00 30.68           O  
ATOM   1953  CB  ALA   237      40.540   7.804  63.821  1.00 29.61           C  
ATOM   1954  N   GLY   238      38.918   5.519  62.265  1.00 28.95           N  
ATOM   1955  CA  GLY   238      38.940   4.646  61.085  1.00 29.07           C  
ATOM   1956  C   GLY   238      40.256   4.754  60.333  1.00 28.70           C  
ATOM   1957  O   GLY   238      40.816   3.742  59.864  1.00 28.91           O  
ATOM   1958  N   LEU   239      40.755   5.980  60.205  1.00 27.16           N  
ATOM   1959  CA  LEU   239      42.070   6.225  59.612  1.00 27.11           C  
ATOM   1960  C   LEU   239      42.861   7.191  60.525  1.00 26.00           C  
ATOM   1961  O   LEU   239      42.470   8.349  60.699  1.00 25.76           O  
ATOM   1962  CB  LEU   239      41.906   6.807  58.212  1.00 26.94           C  
ATOM   1963  CG  LEU   239      43.143   7.089  57.372  1.00 30.13           C  
ATOM   1964  CD1 LEU   239      44.072   5.828  57.356  1.00 31.29           C  
ATOM   1965  CD2 LEU   239      42.612   7.377  55.973  1.00 34.74           C  
ATOM   1966  N   GLY   240      43.945   6.698  61.120  1.00 24.72           N  
ATOM   1967  CA  GLY   240      44.729   7.483  62.057  1.00 24.42           C  
ATOM   1968  C   GLY   240      46.042   7.840  61.374  1.00 24.09           C  
ATOM   1969  O   GLY   240      46.785   6.949  60.937  1.00 23.99           O  
ATOM   1970  N   VAL   241      46.332   9.142  61.299  1.00 24.04           N  
ATOM   1971  CA  VAL   241      47.449   9.639  60.515  1.00 24.33           C  
ATOM   1972  C   VAL   241      48.455  10.346  61.447  1.00 23.63           C  
ATOM   1973  O   VAL   241      48.043  11.158  62.283  1.00 23.79           O  
ATOM   1974  CB  VAL   241      46.928  10.651  59.474  1.00 24.63           C  
ATOM   1975  CG1 VAL   241      48.129  11.281  58.676  1.00 25.61           C  
ATOM   1976  CG2 VAL   241      45.830   9.988  58.557  1.00 25.98           C  
ATOM   1977  N   ALA   242      49.743  10.018  61.317  1.00 22.72           N  
ATOM   1978  CA  ALA   242      50.804  10.750  62.022  1.00 23.21           C  
ATOM   1979  C   ALA   242      51.487  11.737  61.068  1.00 22.60           C  
ATOM   1980  O   ALA   242      51.840  11.384  59.944  1.00 22.15           O  
ATOM   1981  CB  ALA   242      51.846   9.767  62.625  1.00 23.54           C  
ATOM   1982  N   MET   243      51.630  12.988  61.524  1.00 22.05           N  
ATOM   1983  CA  MET   243      52.361  14.012  60.813  1.00 22.04           C  
ATOM   1984  C   MET   243      53.819  13.591  60.787  1.00 22.56           C  
ATOM   1985  O   MET   243      54.292  12.919  61.700  1.00 22.91           O  
ATOM   1986  CB  MET   243      52.199  15.376  61.527  1.00 20.21           C  
ATOM   1987  CG  MET   243      50.726  15.848  61.559  1.00 22.79           C  
ATOM   1988  SD  MET   243      50.166  16.341  59.759  0.70 26.56          SE  
ATOM   1989  CE  MET   243      51.564  17.566  59.227  1.00 24.96           C  
ATOM   1990  N   GLY   244      54.527  14.004  59.743  1.00 22.35           N  
ATOM   1991  CA  GLY   244      55.936  13.689  59.578  1.00 23.44           C  
ATOM   1992  C   GLY   244      56.833  14.174  60.708  1.00 24.47           C  
ATOM   1993  O   GLY   244      57.893  13.588  60.958  1.00 24.84           O  
ATOM   1994  N   ASN   245      56.422  15.250  61.373  1.00 24.06           N  
ATOM   1995  CA  ASN   245      57.198  15.842  62.460  1.00 22.95           C  
ATOM   1996  C   ASN   245      56.949  15.141  63.812  1.00 23.19           C  
ATOM   1997  O   ASN   245      57.580  15.509  64.827  1.00 23.42           O  
ATOM   1998  CB  ASN   245      56.876  17.341  62.571  1.00 21.83           C  
ATOM   1999  CG  ASN   245      55.377  17.622  62.450  1.00 22.80           C  
ATOM   2000  OD1 ASN   245      54.792  17.493  61.360  1.00 21.47           O  
ATOM   2001  ND2 ASN   245      54.739  17.947  63.576  1.00 21.39           N  
ATOM   2002  N   ALA   246      56.072  14.130  63.836  1.00 22.82           N  
ATOM   2003  CA  ALA   246      55.839  13.332  65.050  1.00 22.79           C  
ATOM   2004  C   ALA   246      57.073  12.480  65.367  1.00 23.93           C  
ATOM   2005  O   ALA   246      57.844  12.153  64.467  1.00 23.59           O  
ATOM   2006  CB  ALA   246      54.623  12.428  64.894  1.00 22.71           C  
ATOM   2007  N   VAL   247      57.269  12.103  66.638  1.00 24.77           N  
ATOM   2008  CA  VAL   247      58.391  11.192  66.956  1.00 25.24           C  
ATOM   2009  C   VAL   247      58.183   9.791  66.325  1.00 26.43           C  
ATOM   2010  O   VAL   247      57.052   9.408  66.064  1.00 26.31           O  
ATOM   2011  CB  VAL   247      58.661  11.093  68.485  1.00 25.73           C  
ATOM   2012  CG1 VAL   247      59.047  12.472  69.049  1.00 26.91           C  
ATOM   2013  CG2 VAL   247      57.456  10.490  69.236  1.00 25.18           C  
ATOM   2014  N   PRO   248      59.274   9.053  66.041  1.00 26.84           N  
ATOM   2015  CA  PRO   248      59.184   7.721  65.401  1.00 28.05           C  
ATOM   2016  C   PRO   248      58.164   6.752  66.010  1.00 28.51           C  
ATOM   2017  O   PRO   248      57.472   6.056  65.262  1.00 28.43           O  
ATOM   2018  CB  PRO   248      60.611   7.178  65.543  1.00 28.55           C  
ATOM   2019  CG  PRO   248      61.437   8.402  65.432  1.00 28.21           C  
ATOM   2020  CD  PRO   248      60.688   9.441  66.243  1.00 27.65           C  
ATOM   2021  N   GLU   249      58.045   6.714  67.336  1.00 29.47           N  
ATOM   2022  CA  GLU   249      57.081   5.809  67.977  1.00 31.60           C  
ATOM   2023  C   GLU   249      55.653   6.076  67.531  1.00 30.30           C  
ATOM   2024  O   GLU   249      54.891   5.145  67.255  1.00 30.56           O  
ATOM   2025  CB  GLU   249      57.137   5.920  69.496  1.00 32.47           C  
ATOM   2026  CG  GLU   249      56.068   5.031  70.201  1.00 36.08           C  
ATOM   2027  CD  GLU   249      56.011   5.273  71.694  1.00 36.27           C  
ATOM   2028  OE1 GLU   249      57.098   5.515  72.270  1.00 41.61           O  
ATOM   2029  OE2 GLU   249      54.892   5.224  72.281  1.00 40.09           O  
ATOM   2030  N   ILE   250      55.291   7.358  67.480  1.00 27.91           N  
ATOM   2031  CA  ILE   250      53.971   7.750  67.007  1.00 26.50           C  
ATOM   2032  C   ILE   250      53.788   7.397  65.539  1.00 26.00           C  
ATOM   2033  O   ILE   250      52.730   6.896  65.129  1.00 25.28           O  
ATOM   2034  CB  ILE   250      53.729   9.236  67.272  1.00 26.28           C  
ATOM   2035  CG1 ILE   250      53.754   9.446  68.802  1.00 27.05           C  
ATOM   2036  CG2 ILE   250      52.427   9.698  66.596  1.00 26.15           C  
ATOM   2037  CD1 ILE   250      53.726  10.881  69.239  1.00 30.28           C  
ATOM   2038  N   LYS   251      54.833   7.635  64.750  1.00 25.02           N  
ATOM   2039  CA  LYS   251      54.780   7.291  63.324  1.00 25.90           C  
ATOM   2040  C   LYS   251      54.607   5.792  63.105  1.00 26.34           C  
ATOM   2041  O   LYS   251      53.857   5.373  62.218  1.00 27.33           O  
ATOM   2042  CB  LYS   251      56.008   7.853  62.597  1.00 25.13           C  
ATOM   2043  CG  LYS   251      55.946   9.402  62.603  1.00 27.20           C  
ATOM   2044  CD  LYS   251      56.880  10.070  61.611  1.00 27.44           C  
ATOM   2045  CE  LYS   251      58.301  10.034  62.110  1.00 30.65           C  
ATOM   2046  NZ  LYS   251      59.127  11.048  61.390  1.00 27.07           N  
ATOM   2047  N   ARG   252      55.258   4.982  63.931  1.00 26.48           N  
ATOM   2048  CA  ARG   252      55.081   3.521  63.830  1.00 26.17           C  
ATOM   2049  C   ARG   252      53.658   3.088  64.172  1.00 27.38           C  
ATOM   2050  O   ARG   252      53.122   2.138  63.558  1.00 27.56           O  
ATOM   2051  CB  ARG   252      56.067   2.788  64.726  1.00 25.93           C  
ATOM   2052  CG  ARG   252      57.483   2.791  64.223  1.00 24.21           C  
ATOM   2053  CD  ARG   252      58.314   1.746  64.989  1.00 27.39           C  
ATOM   2054  NE  ARG   252      58.402   2.104  66.409  1.00 28.96           N  
ATOM   2055  CZ  ARG   252      59.325   2.912  66.926  1.00 29.93           C  
ATOM   2056  NH1 ARG   252      60.255   3.464  66.150  1.00 30.96           N  
ATOM   2057  NH2 ARG   252      59.301   3.185  68.223  1.00 31.28           N  
ATOM   2058  N   LYS   253      53.029   3.806  65.104  1.00 26.16           N  
ATOM   2059  CA  LYS   253      51.714   3.395  65.603  1.00 26.68           C  
ATOM   2060  C   LYS   253      50.532   3.801  64.737  1.00 25.93           C  
ATOM   2061  O   LYS   253      49.469   3.203  64.830  1.00 25.23           O  
ATOM   2062  CB  LYS   253      51.530   3.854  67.034  1.00 26.72           C  
ATOM   2063  CG  LYS   253      52.386   3.029  67.945  1.00 30.39           C  
ATOM   2064  CD  LYS   253      52.209   3.410  69.383  1.00 31.63           C  
ATOM   2065  CE  LYS   253      52.644   2.234  70.273  1.00 33.52           C  
ATOM   2066  NZ  LYS   253      52.440   2.596  71.683  1.00 36.24           N  
ATOM   2067  N   ALA   254      50.729   4.814  63.907  1.00 24.33           N  
ATOM   2068  CA  ALA   254      49.709   5.294  62.990  1.00 24.70           C  
ATOM   2069  C   ALA   254      49.421   4.318  61.839  1.00 26.07           C  
ATOM   2070  O   ALA   254      50.261   3.451  61.495  1.00 25.87           O  
ATOM   2071  CB  ALA   254      50.128   6.638  62.423  1.00 24.51           C  
ATOM   2072  N   ASP   255      48.266   4.483  61.207  1.00 25.57           N  
ATOM   2073  CA  ASP   255      47.956   3.693  60.015  1.00 27.11           C  
ATOM   2074  C   ASP   255      48.709   4.236  58.813  1.00 27.57           C  
ATOM   2075  O   ASP   255      49.010   3.523  57.870  1.00 26.36           O  
ATOM   2076  CB  ASP   255      46.465   3.750  59.727  1.00 27.08           C  
ATOM   2077  CG  ASP   255      45.630   3.348  60.935  1.00 28.43           C  
ATOM   2078  OD1 ASP   255      46.098   2.472  61.708  1.00 30.86           O  
ATOM   2079  OD2 ASP   255      44.525   3.911  61.114  1.00 27.78           O  
ATOM   2080  N   TRP   256      49.014   5.524  58.873  1.00 28.09           N  
ATOM   2081  CA  TRP   256      49.508   6.246  57.732  1.00 28.91           C  
ATOM   2082  C   TRP   256      50.416   7.359  58.225  1.00 27.48           C  
ATOM   2083  O   TRP   256      50.028   8.072  59.143  1.00 26.12           O  
ATOM   2084  CB  TRP   256      48.280   6.865  57.103  1.00 31.66           C  
ATOM   2085  CG  TRP   256      48.473   7.553  55.835  1.00 35.83           C  
ATOM   2086  CD1 TRP   256      49.530   8.360  55.467  1.00 39.27           C  
ATOM   2087  CD2 TRP   256      47.555   7.570  54.750  1.00 37.87           C  
ATOM   2088  NE1 TRP   256      49.330   8.846  54.196  1.00 40.18           N  
ATOM   2089  CE2 TRP   256      48.114   8.392  53.741  1.00 40.29           C  
ATOM   2090  CE3 TRP   256      46.304   6.976  54.529  1.00 39.44           C  
ATOM   2091  CZ2 TRP   256      47.465   8.627  52.523  1.00 39.24           C  
ATOM   2092  CZ3 TRP   256      45.653   7.213  53.317  1.00 38.57           C  
ATOM   2093  CH2 TRP   256      46.237   8.034  52.330  1.00 38.71           C  
ATOM   2094  N   VAL   257      51.592   7.522  57.616  1.00 25.70           N  
ATOM   2095  CA  VAL   257      52.486   8.651  57.971  1.00 26.11           C  
ATOM   2096  C   VAL   257      52.534   9.629  56.808  1.00 26.15           C  
ATOM   2097  O   VAL   257      52.800   9.222  55.658  1.00 25.71           O  
ATOM   2098  CB  VAL   257      53.926   8.165  58.276  1.00 25.53           C  
ATOM   2099  CG1 VAL   257      54.822   9.328  58.596  1.00 25.30           C  
ATOM   2100  CG2 VAL   257      53.931   7.181  59.453  1.00 27.38           C  
ATOM   2101  N   THR   258      52.256  10.903  57.078  1.00 24.62           N  
ATOM   2102  CA  THR   258      52.303  11.903  56.008  1.00 24.30           C  
ATOM   2103  C   THR   258      53.565  12.763  56.156  1.00 23.94           C  
ATOM   2104  O   THR   258      54.437  12.497  57.010  1.00 23.29           O  
ATOM   2105  CB  THR   258      50.963  12.710  55.940  1.00 24.99           C  
ATOM   2106  OG1 THR   258      50.926  13.539  54.768  1.00 24.74           O  
ATOM   2107  CG2 THR   258      50.718  13.567  57.201  1.00 23.24           C  
ATOM   2108  N   ARG   259      53.689  13.775  55.312  1.00 22.47           N  
ATOM   2109  CA  ARG   259      54.808  14.695  55.401  1.00 22.99           C  
ATOM   2110  C   ARG   259      54.673  15.618  56.633  1.00 22.86           C  
ATOM   2111  O   ARG   259      53.647  15.593  57.317  1.00 23.01           O  
ATOM   2112  CB  ARG   259      54.849  15.529  54.139  1.00 21.55           C  
ATOM   2113  CG  ARG   259      55.174  14.668  52.937  1.00 24.21           C  
ATOM   2114  CD  ARG   259      55.297  15.488  51.699  1.00 24.26           C  
ATOM   2115  NE  ARG   259      55.839  14.667  50.598  1.00 24.24           N  
ATOM   2116  CZ  ARG   259      56.083  15.144  49.382  1.00 27.53           C  
ATOM   2117  NH1 ARG   259      55.805  16.426  49.121  1.00 22.20           N  
ATOM   2118  NH2 ARG   259      56.564  14.331  48.426  1.00 25.32           N  
ATOM   2119  N   SER   260      55.706  16.405  56.917  1.00 23.28           N  
ATOM   2120  CA  SER   260      55.705  17.229  58.138  1.00 23.33           C  
ATOM   2121  C   SER   260      54.753  18.428  57.995  1.00 22.50           C  
ATOM   2122  O   SER   260      54.306  18.746  56.884  1.00 22.18           O  
ATOM   2123  CB  SER   260      57.131  17.734  58.409  1.00 25.09           C  
ATOM   2124  OG  SER   260      57.382  18.926  57.677  1.00 27.19           O  
ATOM   2125  N   ASN   261      54.516  19.142  59.105  1.00 22.48           N  
ATOM   2126  CA  ASN   261      53.738  20.376  59.074  1.00 22.26           C  
ATOM   2127  C   ASN   261      54.443  21.519  58.344  1.00 22.43           C  
ATOM   2128  O   ASN   261      53.813  22.519  58.003  1.00 22.77           O  
ATOM   2129  CB  ASN   261      53.318  20.802  60.502  1.00 21.69           C  
ATOM   2130  CG  ASN   261      54.498  21.144  61.391  1.00 22.89           C  
ATOM   2131  OD1 ASN   261      55.555  20.481  61.364  1.00 22.86           O  
ATOM   2132  ND2 ASN   261      54.307  22.171  62.227  1.00 22.44           N  
ATOM   2133  N   ASP   262      55.749  21.385  58.121  1.00 22.12           N  
ATOM   2134  CA  ASP   262      56.460  22.377  57.308  1.00 22.60           C  
ATOM   2135  C   ASP   262      56.566  21.958  55.830  1.00 21.47           C  
ATOM   2136  O   ASP   262      57.220  22.631  55.028  1.00 21.76           O  
ATOM   2137  CB  ASP   262      57.827  22.702  57.914  1.00 23.23           C  
ATOM   2138  CG  ASP   262      57.701  23.550  59.204  1.00 28.19           C  
ATOM   2139  OD1 ASP   262      56.796  24.403  59.290  1.00 27.66           O  
ATOM   2140  OD2 ASP   262      58.485  23.332  60.143  1.00 33.51           O  
ATOM   2141  N   GLU   263      55.935  20.842  55.488  1.00 20.80           N  
ATOM   2142  CA  GLU   263      55.899  20.352  54.103  1.00 20.78           C  
ATOM   2143  C   GLU   263      54.452  19.989  53.758  1.00 21.17           C  
ATOM   2144  O   GLU   263      54.193  19.045  53.025  1.00 22.36           O  
ATOM   2145  CB  GLU   263      56.830  19.147  53.922  1.00 21.19           C  
ATOM   2146  CG  GLU   263      57.305  18.969  52.469  1.00 23.89           C  
ATOM   2147  CD  GLU   263      58.305  20.051  52.082  1.00 26.49           C  
ATOM   2148  OE1 GLU   263      57.984  20.868  51.161  1.00 26.66           O  
ATOM   2149  OE2 GLU   263      59.402  20.108  52.732  1.00 27.13           O  
ATOM   2150  N   GLN   264      53.509  20.729  54.332  1.00 20.75           N  
ATOM   2151  CA  GLN   264      52.091  20.622  53.972  1.00 21.64           C  
ATOM   2152  C   GLN   264      51.573  19.180  54.046  1.00 21.50           C  
ATOM   2153  O   GLN   264      50.905  18.699  53.141  1.00 21.41           O  
ATOM   2154  CB  GLN   264      51.838  21.292  52.588  1.00 20.91           C  
ATOM   2155  CG  GLN   264      51.810  22.840  52.717  1.00 23.81           C  
ATOM   2156  CD  GLN   264      53.155  23.394  53.217  1.00 25.44           C  
ATOM   2157  OE1 GLN   264      53.308  23.782  54.413  1.00 22.26           O  
ATOM   2158  NE2 GLN   264      54.162  23.374  52.313  1.00 22.74           N  
ATOM   2159  N   GLY   265      51.851  18.519  55.166  1.00 20.55           N  
ATOM   2160  CA  GLY   265      51.471  17.127  55.333  1.00 21.09           C  
ATOM   2161  C   GLY   265      49.973  16.875  55.378  1.00 22.40           C  
ATOM   2162  O   GLY   265      49.515  15.828  54.922  1.00 21.89           O  
ATOM   2163  N   VAL   266      49.211  17.835  55.908  1.00 21.97           N  
ATOM   2164  CA  VAL   266      47.721  17.726  55.884  1.00 22.34           C  
ATOM   2165  C   VAL   266      47.177  17.692  54.434  1.00 22.44           C  
ATOM   2166  O   VAL   266      46.434  16.773  54.065  1.00 22.33           O  
ATOM   2167  CB  VAL   266      47.061  18.869  56.706  1.00 21.95           C  
ATOM   2168  CG1 VAL   266      45.535  18.928  56.427  1.00 23.91           C  
ATOM   2169  CG2 VAL   266      47.319  18.618  58.180  1.00 23.66           C  
ATOM   2170  N   ALA   267      47.548  18.697  53.632  1.00 21.52           N  
ATOM   2171  CA  ALA   267      47.176  18.747  52.217  1.00 22.29           C  
ATOM   2172  C   ALA   267      47.645  17.503  51.447  1.00 22.60           C  
ATOM   2173  O   ALA   267      46.916  16.959  50.594  1.00 22.47           O  
ATOM   2174  CB  ALA   267      47.726  20.014  51.562  1.00 22.47           C  
ATOM   2175  N   TYR   268      48.857  17.052  51.748  1.00 21.54           N  
ATOM   2176  CA  TYR   268      49.449  15.932  51.026  1.00 23.44           C  
ATOM   2177  C   TYR   268      48.621  14.669  51.301  1.00 24.29           C  
ATOM   2178  O   TYR   268      48.274  13.905  50.367  1.00 24.69           O  
ATOM   2179  CB  TYR   268      50.894  15.731  51.491  1.00 23.22           C  
ATOM   2180  CG  TYR   268      51.715  14.768  50.652  1.00 23.53           C  
ATOM   2181  CD1 TYR   268      52.211  15.146  49.413  1.00 23.71           C  
ATOM   2182  CD2 TYR   268      52.037  13.505  51.133  1.00 25.80           C  
ATOM   2183  CE1 TYR   268      53.010  14.275  48.643  1.00 24.92           C  
ATOM   2184  CE2 TYR   268      52.818  12.595  50.355  1.00 22.95           C  
ATOM   2185  CZ  TYR   268      53.302  13.009  49.117  1.00 23.37           C  
ATOM   2186  OH  TYR   268      54.091  12.152  48.347  1.00 27.35           O  
ATOM   2187  N   MET   269      48.306  14.468  52.581  1.00 25.17           N  
ATOM   2188  CA  MET   269      47.506  13.307  52.969  0.50 25.64           C  
ATOM   2190  C   MET   269      46.100  13.379  52.366  1.00 25.96           C  
ATOM   2191  O   MET   269      45.602  12.371  51.838  1.00 26.32           O  
ATOM   2192  CB  MET   269      47.481  13.137  54.495  0.50 26.22           C  
ATOM   2194  CG  MET   269      46.753  11.904  54.997  0.50 26.59           C  
ATOM   2196  SD  MET   269      44.912  12.282  55.331  0.40 30.28          SE  
ATOM   2198  CE  MET   269      44.208  10.481  55.334  0.50 26.85           C  
ATOM   2200  N   MET   270      45.450  14.538  52.412  1.00 25.78           N  
ATOM   2201  CA  MET   270      44.070  14.568  51.896  1.00 25.69           C  
ATOM   2202  C   MET   270      43.972  14.413  50.375  1.00 24.64           C  
ATOM   2203  O   MET   270      43.013  13.825  49.877  1.00 23.32           O  
ATOM   2204  CB  MET   270      43.268  15.755  52.440  1.00 26.63           C  
ATOM   2205  CG  MET   270      42.825  15.545  53.961  1.00 27.90           C  
ATOM   2206  SD  MET   270      41.981  13.811  54.467  0.50 33.51          SE  
ATOM   2207  CE  MET   270      40.197  14.101  53.788  1.00 31.19           C  
ATOM   2208  N   LYS   271      44.983  14.896  49.653  1.00 23.82           N  
ATOM   2209  CA  LYS   271      45.079  14.665  48.209  1.00 24.03           C  
ATOM   2210  C   LYS   271      45.081  13.154  47.917  1.00 24.38           C  
ATOM   2211  O   LYS   271      44.362  12.670  47.021  1.00 22.62           O  
ATOM   2212  CB  LYS   271      46.335  15.337  47.654  1.00 24.47           C  
ATOM   2213  CG  LYS   271      46.520  15.228  46.144  1.00 28.95           C  
ATOM   2214  CD  LYS   271      45.551  16.114  45.384  1.00 33.45           C  
ATOM   2215  CE  LYS   271      45.691  15.935  43.886  1.00 37.61           C  
ATOM   2216  NZ  LYS   271      44.779  16.886  43.204  1.00 39.47           N  
ATOM   2217  N   GLU   272      45.877  12.411  48.677  1.00 23.92           N  
ATOM   2218  CA  GLU   272      45.906  10.938  48.549  1.00 26.36           C  
ATOM   2219  C   GLU   272      44.581  10.270  48.930  1.00 26.60           C  
ATOM   2220  O   GLU   272      44.140   9.337  48.218  1.00 27.95           O  
ATOM   2221  CB  GLU   272      47.062  10.326  49.346  1.00 26.62           C  
ATOM   2222  CG  GLU   272      47.214   8.811  49.151  1.00 29.70           C  
ATOM   2223  CD  GLU   272      47.293   8.396  47.695  1.00 32.19           C  
ATOM   2224  OE1 GLU   272      47.910   9.137  46.883  1.00 34.53           O  
ATOM   2225  OE2 GLU   272      46.727   7.327  47.342  1.00 31.05           O  
ATOM   2226  N   TYR   273      43.962  10.730  50.018  1.00 27.42           N  
ATOM   2227  CA  TYR   273      42.645  10.244  50.417  1.00 29.11           C  
ATOM   2228  C   TYR   273      41.693  10.315  49.235  1.00 28.66           C  
ATOM   2229  O   TYR   273      40.979   9.347  48.960  1.00 28.96           O  
ATOM   2230  CB  TYR   273      42.071  10.981  51.636  1.00 30.66           C  
ATOM   2231  CG  TYR   273      40.606  10.658  51.859  1.00 33.11           C  
ATOM   2232  CD1 TYR   273      39.612  11.556  51.477  1.00 35.41           C  
ATOM   2233  CD2 TYR   273      40.211   9.410  52.383  1.00 37.23           C  
ATOM   2234  CE1 TYR   273      38.252  11.254  51.638  1.00 36.08           C  
ATOM   2235  CE2 TYR   273      38.848   9.091  52.547  1.00 35.87           C  
ATOM   2236  CZ  TYR   273      37.884  10.029  52.179  1.00 36.29           C  
ATOM   2237  OH  TYR   273      36.545   9.741  52.329  1.00 36.82           O  
ATOM   2238  N   PHE   274      41.701  11.436  48.511  1.00 27.89           N  
ATOM   2239  CA  PHE   274      40.801  11.576  47.361  1.00 27.82           C  
ATOM   2240  C   PHE   274      41.198  10.776  46.122  1.00 28.80           C  
ATOM   2241  O   PHE   274      40.331  10.270  45.398  1.00 27.67           O  
ATOM   2242  CB  PHE   274      40.536  13.035  47.045  1.00 28.07           C  
ATOM   2243  CG  PHE   274      39.715  13.705  48.098  1.00 29.10           C  
ATOM   2244  CD1 PHE   274      38.391  13.303  48.324  1.00 31.46           C  
ATOM   2245  CD2 PHE   274      40.262  14.696  48.889  1.00 29.57           C  
ATOM   2246  CE1 PHE   274      37.625  13.911  49.319  1.00 32.39           C  
ATOM   2247  CE2 PHE   274      39.508  15.316  49.883  1.00 30.78           C  
ATOM   2248  CZ  PHE   274      38.198  14.925  50.098  1.00 29.96           C  
ATOM   2249  N   ARG   275      42.492  10.670  45.869  1.00 29.47           N  
ATOM   2250  CA  ARG   275      42.956   9.764  44.817  1.00 32.37           C  
ATOM   2251  C   ARG   275      42.481   8.333  45.105  1.00 33.10           C  
ATOM   2252  O   ARG   275      42.013   7.642  44.205  1.00 33.20           O  
ATOM   2253  CB  ARG   275      44.478   9.860  44.643  1.00 31.99           C  
ATOM   2254  CG  ARG   275      44.897  11.083  43.793  1.00 34.08           C  
ATOM   2255  CD  ARG   275      46.361  11.045  43.328  1.00 34.50           C  
ATOM   2256  NE  ARG   275      47.193  11.008  44.498  1.00 36.44           N  
ATOM   2257  CZ  ARG   275      47.923  12.011  44.982  1.00 37.79           C  
ATOM   2258  NH1 ARG   275      48.059  13.173  44.338  1.00 39.78           N  
ATOM   2259  NH2 ARG   275      48.571  11.808  46.104  1.00 27.71           N  
ATOM   2260  N   MET   276      42.568   7.917  46.363  1.00 35.02           N  
ATOM   2261  CA  MET   276      42.074   6.605  46.816  1.00 38.13           C  
ATOM   2262  C   MET   276      40.580   6.439  46.522  1.00 38.01           C  
ATOM   2263  O   MET   276      40.161   5.423  45.963  1.00 38.25           O  
ATOM   2264  CB  MET   276      42.323   6.465  48.319  1.00 38.20           C  
ATOM   2265  CG  MET   276      43.023   5.196  48.773  1.00 40.53           C  
ATOM   2266  SD  MET   276      44.223   5.555  50.270  0.50 41.91          SE  
ATOM   2267  CE  MET   276      43.199   6.978  51.120  1.00 42.05           C  
ATOM   2268  N   GLN   277      39.793   7.443  46.899  1.00 38.41           N  
ATOM   2269  CA  GLN   277      38.355   7.535  46.572  1.00 39.20           C  
ATOM   2270  C   GLN   277      38.045   7.405  45.086  1.00 39.22           C  
ATOM   2271  O   GLN   277      37.153   6.650  44.691  1.00 38.94           O  
ATOM   2272  CB  GLN   277      37.792   8.870  47.074  1.00 39.68           C  
ATOM   2273  CG  GLN   277      37.736   8.976  48.580  1.00 42.29           C  
ATOM   2274  CD  GLN   277      36.893   7.873  49.186  1.00 46.38           C  
ATOM   2275  OE1 GLN   277      37.383   7.072  49.988  1.00 49.96           O  
ATOM   2276  NE2 GLN   277      35.626   7.810  48.790  1.00 46.50           N  
ATOM   2277  N   GLN   278      38.777   8.151  44.267  1.00 39.48           N  
ATOM   2278  CA  GLN   278      38.612   8.118  42.821  1.00 40.80           C  
ATOM   2279  C   GLN   278      38.903   6.717  42.258  1.00 40.52           C  
ATOM   2280  O   GLN   278      38.180   6.228  41.383  1.00 40.34           O  
ATOM   2281  CB  GLN   278      39.540   9.151  42.190  1.00 40.71           C  
ATOM   2282  CG  GLN   278      39.202   9.545  40.770  1.00 42.69           C  
ATOM   2283  CD  GLN   278      40.159  10.602  40.240  1.00 43.19           C  
ATOM   2284  OE1 GLN   278      40.382  11.636  40.889  1.00 46.36           O  
ATOM   2285  NE2 GLN   278      40.743  10.342  39.064  1.00 44.93           N  
ATOM   2286  N   ARG   279      39.954   6.074  42.772  1.00 40.61           N  
ATOM   2287  CA  ARG   279      40.327   4.713  42.359  1.00 40.81           C  
ATOM   2288  C   ARG   279      39.246   3.698  42.730  1.00 40.76           C  
ATOM   2289  O   ARG   279      38.869   2.854  41.910  1.00 40.29           O  
ATOM   2290  CB  ARG   279      41.671   4.317  42.969  1.00 41.24           C  
ATOM   2291  CG  ARG   279      42.856   5.053  42.346  1.00 41.88           C  
ATOM   2292  CD  ARG   279      44.163   4.348  42.653  1.00 42.99           C  
ATOM   2293  NE  ARG   279      44.582   4.612  44.016  1.00 43.79           N  
ATOM   2294  CZ  ARG   279      45.338   5.647  44.376  1.00 43.13           C  
ATOM   2295  NH1 ARG   279      45.777   6.518  43.463  1.00 42.82           N  
ATOM   2296  NH2 ARG   279      45.652   5.802  45.650  1.00 41.15           N  
ATOM   2297  N   LYS   280      38.754   3.792  43.965  1.00 40.64           N  
ATOM   2298  CA  LYS   280      37.587   3.026  44.395  1.00 40.87           C  
ATOM   2299  C   LYS   280      36.318   3.585  43.743  1.00 40.93           C  
ATOM   2300  O   LYS   280      35.798   3.009  42.779  1.00 41.19           O  
ATOM   2301  CB  LYS   280      37.465   3.046  45.922  1.00 40.47           C  
END
