
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  143 ( 1138),  selected  143 , name 2ig6_A
# Molecule2: number of CA atoms  143 ( 1091),  selected  143 , name T0506_25_173.pdb
# PARAMETERS: 2ig6_A.T0506_25_173.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -11_A      E      25           -
LGA    H   -10_A      A      26           -
LGA    H    -9_A      -       -           -
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      V      27           #
LGA    X     1_A      R      28           -
LGA    -       -      V      29           -
LGA    -       -      A      30           -
LGA    K     2_A      R      31          5.325
LGA    R     3_A      D      32          4.869
LGA    A     4_A      V      33          5.676
LGA    L     5_A      L      34          3.068
LGA    E     6_A      H      35          1.191
LGA    F     7_A      T      36          4.680
LGA    L     8_A      S      37          2.837
LGA    K     9_A      R      38          3.569
LGA    E    10_A      -       -           -
LGA    C    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    V    13_A      T      39          2.186
LGA    F    14_A      A      40          1.893
LGA    Y    15_A      A      41          0.852
LGA    L    16_A      L      42          0.460
LGA    A    17_A      A      43          0.639
LGA    T    18_A      T      44          0.734
LGA    N    19_A      L      45          0.711
LGA    E    20_A      D      46          0.495
LGA    G    21_A      P      47          2.879
LGA    -       -      V      48           -
LGA    -       -      S      49           -
LGA    D    22_A      G      50          0.950
LGA    Q    23_A      Y      51          1.718
LGA    P    24_A      P      52          1.143
LGA    R    25_A      Y      53          0.449
LGA    V    26_A      T      54          0.586
LGA    R    27_A      T      55          1.120
LGA    P    28_A      A      56          1.013
LGA    F    29_A      T      57          1.110
LGA    G    30_A      N      58          1.895
LGA    A    31_A      I      59          2.973
LGA    V    32_A      -       -           -
LGA    F    33_A      G      60          1.839
LGA    E    34_A      I      61          2.794
LGA    Y    35_A      E      62          3.236
LGA    E    36_A      P      63          5.899
LGA    G    37_A      D      64          2.818
LGA    -       -      G      65           -
LGA    K    38_A      T      66          2.954
LGA    L    39_A      P      67          2.073
LGA    Y    40_A      F      68          0.854
LGA    I    41_A      F      69          1.270
LGA    V    42_A      F      70          1.074
LGA    S    43_A      A      71          0.891
LGA    N    44_A      A      72          1.574
LGA    N    45_A      G      73          1.792
LGA    T    46_A      L      74          1.910
LGA    K    47_A      T      75          1.463
LGA    K    48_A      L      76          1.479
LGA    C    49_A      H      77          0.645
LGA    F    50_A      A      78          0.895
LGA    K    51_A      R      79          1.461
LGA    Q    52_A      N      80          0.705
LGA    X    53_A      M      81          1.048
LGA    I    54_A      E      82          1.844
LGA    Q    55_A      T      83          1.122
LGA    N    56_A      D      84          0.927
LGA    P    57_A      A      85          0.905
LGA    K    58_A      R      86          0.732
LGA    V    59_A      I      87          0.781
LGA    E    60_A      S      88          0.974
LGA    I    61_A      V      89          1.244
LGA    S    62_A      T      90          1.899
LGA    G    63_A      L      91          3.921
LGA    X    64_A      A      92          3.240
LGA    N    65_A      P      93          2.453
LGA    -       -      F      94           -
LGA    -       -      G      95           -
LGA    K    66_A      K      96          2.397
LGA    -       -      G      97           -
LGA    -       -      D      98           -
LGA    -       -      A      99           -
LGA    -       -      L     100           -
LGA    K    67_A      T     101          4.945
LGA    G    68_A      L     102          1.683
LGA    Q    69_A      P     103          1.489
LGA    W    70_A      R     104          1.276
LGA    I    71_A      L     105          1.698
LGA    R    72_A      T     106          1.413
LGA    L    73_A      L     107          1.248
LGA    T    74_A      V     108          0.896
LGA    G    75_A      G     109          0.916
LGA    E    76_A      R     110          0.932
LGA    V    77_A      A     111          1.215
LGA    A    78_A      D     112          0.811
LGA    N    79_A      R     113          0.785
LGA    D    80_A      I     114          1.253
LGA    D    81_A      G     115          2.724
LGA    R    82_A      P     116          1.899
LGA    R    83_A      D     117          3.979
LGA    E    84_A      E     118          3.144
LGA    V    85_A      -       -           -
LGA    K    86_A      V     119          2.449
LGA    E    87_A      P     120          2.017
LGA    L    88_A      L     121          2.377
LGA    A    89_A      A     122          2.966
LGA    L    90_A      I     123          2.798
LGA    E    91_A      A     124          1.961
LGA    A    92_A      R     125          2.046
LGA    V    93_A      Y     126          2.748
LGA    P    94_A      I     127          1.974
LGA    -       -      A     128           -
LGA    -       -      R     129           -
LGA    -       -      Y     130           -
LGA    -       -      P     131           -
LGA    S    95_A      K     132          2.574
LGA    L    96_A      A     133          1.140
LGA    K    97_A      K     134          1.041
LGA    N    98_A      L     135          1.946
LGA    X    99_A      Y     136          0.637
LGA    Y   100_A      L     137          1.101
LGA    S   101_A      S     138          2.814
LGA    V   102_A      -       -           -
LGA    D   103_A      -       -           -
LGA    D   104_A      L     139          5.185
LGA    G   105_A      P     140          4.697
LGA    I   106_A      D     141          1.061
LGA    F   107_A      T     142          1.300
LGA    A   108_A      R     143          1.280
LGA    V   109_A      L     144          1.076
LGA    L   110_A      Y     145          0.428
LGA    Y   111_A      R     146          0.835
LGA    F   112_A      L     147          1.698
LGA    T   113_A      R     148          2.334
LGA    K   114_A      T     149          3.058
LGA    G   115_A      E     150          2.352
LGA    E   116_A      G     151          1.847
LGA    G   117_A      V     152          1.421
LGA    T   118_A      Q     153          1.775
LGA    I   119_A      I     154          1.631
LGA    C   120_A      N     155          1.047
LGA    S   121_A      G     156          1.817
LGA    F   122_A      -       -           -
LGA    K   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    N   126_A      S     163          3.160
LGA    E   127_A      N     164           #
LGA    T   128_A      I     165          2.314
LGA    F   129_A      T     166          3.409
LGA    S   130_A      P     167          0.675
LGA    L   131_A      A     168          4.907
LGA    -       -      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  143  143    5.0    118    2.31    11.86     65.593     4.890

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.114939 * X  +   0.135625 * Y  +  -0.984071 * Z  +  24.341255
  Y_new =   0.468563 * X  +   0.866106 * Y  +   0.174095 * Z  + -20.800913
  Z_new =   0.875921 * X  +  -0.481109 * Y  +   0.036000 * Z  +  10.181364 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.496108    1.645484  [ DEG:   -85.7207     94.2793 ]
  Theta =  -1.067342   -2.074251  [ DEG:   -61.1542   -118.8458 ]
  Phi   =   1.330246   -1.811347  [ DEG:    76.2175   -103.7825 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ig6_A                                        
REMARK     2: T0506_25_173.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ig6_A.T0506_25_173.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  143  143   5.0  118   2.31   11.86  65.593
REMARK  ---------------------------------------------------------- 
MOLECULE 2ig6_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   22-SEP-06   2IG6              
TITLE     CRYSTAL STRUCTURE OF NIMC/NIMA FAMILY PROTEIN (NP_349178.1)           
TITLE    2 FROM CLOSTRIDIUM ACETOBUTYLICUM AT 1.80 A RESOLUTION                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NIMC/NIMA FAMILY PROTEIN;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CLOSTRIDIUM ACETOBUTYLICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_349178.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_349178.1, NIMC/NIMA FAMILY PROTEIN, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, JOINT CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, JCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-OCT-06 2IG6    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF NIMC/NIMA FAMILY PROTEIN                
JRNL        TITL 2 (NP_349178.1) FROM CLOSTRIDIUM ACETOBUTYLICUM AT             
JRNL        TITL 3 1.80 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2IG6 A    1   131  UNP    Q97G05   Q97G05_CLOAB     1    131             
DBREF  2IG6 B    1   131  UNP    Q97G05   Q97G05_CLOAB     1    131             
SEQRES   1 A  150  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  150  ASN LEU TYR PHE GLN GLY MSE LYS ARG ALA LEU GLU PHE          
SEQRES   3 A  150  LEU LYS GLU CYS GLY VAL PHE TYR LEU ALA THR ASN GLU          
SEQRES   4 A  150  GLY ASP GLN PRO ARG VAL ARG PRO PHE GLY ALA VAL PHE          
SEQRES   5 A  150  GLU TYR GLU GLY LYS LEU TYR ILE VAL SER ASN ASN THR          
SEQRES   6 A  150  LYS LYS CYS PHE LYS GLN MSE ILE GLN ASN PRO LYS VAL          
SEQRES   7 A  150  GLU ILE SER GLY MSE ASN LYS LYS GLY GLN TRP ILE ARG          
SEQRES   8 A  150  LEU THR GLY GLU VAL ALA ASN ASP ASP ARG ARG GLU VAL          
SEQRES   9 A  150  LYS GLU LEU ALA LEU GLU ALA VAL PRO SER LEU LYS ASN          
SEQRES  10 A  150  MSE TYR SER VAL ASP ASP GLY ILE PHE ALA VAL LEU TYR          
SEQRES  11 A  150  PHE THR LYS GLY GLU GLY THR ILE CYS SER PHE LYS GLY          
SEQRES  12 A  150  GLU ASN GLU THR PHE SER LEU                                  
SEQRES   1 B  150  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  150  ASN LEU TYR PHE GLN GLY MSE LYS ARG ALA LEU GLU PHE          
SEQRES   3 B  150  LEU LYS GLU CYS GLY VAL PHE TYR LEU ALA THR ASN GLU          
SEQRES   4 B  150  GLY ASP GLN PRO ARG VAL ARG PRO PHE GLY ALA VAL PHE          
SEQRES   5 B  150  GLU TYR GLU GLY LYS LEU TYR ILE VAL SER ASN ASN THR          
SEQRES   6 B  150  LYS LYS CYS PHE LYS GLN MSE ILE GLN ASN PRO LYS VAL          
SEQRES   7 B  150  GLU ILE SER GLY MSE ASN LYS LYS GLY GLN TRP ILE ARG          
SEQRES   8 B  150  LEU THR GLY GLU VAL ALA ASN ASP ASP ARG ARG GLU VAL          
SEQRES   9 B  150  LYS GLU LEU ALA LEU GLU ALA VAL PRO SER LEU LYS ASN          
SEQRES  10 B  150  MSE TYR SER VAL ASP ASP GLY ILE PHE ALA VAL LEU TYR          
SEQRES  11 B  150  PHE THR LYS GLY GLU GLY THR ILE CYS SER PHE LYS GLY          
SEQRES  12 B  150  GLU ASN GLU THR PHE SER LEU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  64       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  64       8                                                       
HET    MSE  B  99       8                                                       
HET    SO4      2       5                                                       
HET    SO4      3       5                                                       
HET    SO4      4       5                                                       
HET    FMN  A 339      31                                                       
HET    UNL  A 340       9                                                       
HET    EDO      1       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     UNL UNKNOWN LIGAND                                                   
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6  FMN    C17 H21 N4 O9 P                                              
FORMUL   8  EDO    C2 H6 O2                                                     
FORMUL   9  HOH   *275(H2 O)                                                    
CRYST1   52.431   65.305  108.788  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   HIS A -11      11.239  65.802   3.693  1.00 64.96           N  
ATOM      2  CA  HIS A -11      10.156  64.992   3.049  1.00 63.97           C  
ATOM      3  C   HIS A -11       9.065  65.904   2.466  1.00 61.87           C  
ATOM      4  O   HIS A -11       8.592  66.815   3.140  1.00 62.75           O  
ATOM      5  CB  HIS A -11       9.555  64.016   4.058  1.00 64.03           C  
ATOM      6  CG  HIS A -11       8.709  62.941   3.447  1.00 67.24           C  
ATOM      7  ND1 HIS A -11       9.095  61.616   3.417  1.00 65.54           N  
ATOM      8  CD2 HIS A -11       7.479  62.989   2.875  1.00 68.35           C  
ATOM      9  CE1 HIS A -11       8.146  60.899   2.842  1.00 67.62           C  
ATOM     10  NE2 HIS A -11       7.155  61.709   2.500  1.00 68.16           N  
ATOM     11  N   HIS A -10       8.695  65.654   1.210  1.00 59.13           N  
ATOM     12  CA  HIS A -10       7.657  66.400   0.507  1.00 55.85           C  
ATOM     13  C   HIS A -10       6.648  65.452  -0.126  1.00 53.63           C  
ATOM     14  O   HIS A -10       7.033  64.581  -0.906  1.00 47.93           O  
ATOM     15  CB  HIS A -10       8.270  67.235  -0.604  1.00 57.28           C  
ATOM     16  CG  HIS A -10       9.384  68.119  -0.152  1.00 58.94           C  
ATOM     17  ND1 HIS A -10      10.695  67.700  -0.116  1.00 60.61           N  
ATOM     18  CD2 HIS A -10       9.385  69.405   0.269  1.00 61.92           C  
ATOM     19  CE1 HIS A -10      11.457  68.688   0.312  1.00 62.89           C  
ATOM     20  NE2 HIS A -10      10.687  69.734   0.554  1.00 61.44           N  
ATOM     21  N   HIS A  -9       5.357  65.666   0.160  1.00 52.51           N  
ATOM     22  CA  HIS A  -9       4.280  64.763  -0.305  1.00 52.04           C  
ATOM     23  C   HIS A  -9       4.272  64.509  -1.817  1.00 49.09           C  
ATOM     24  O   HIS A  -9       3.926  63.416  -2.255  1.00 48.91           O  
ATOM     25  CB  HIS A  -9       2.889  65.278   0.122  1.00 53.30           C  
ATOM     26  CG  HIS A  -9       2.562  65.010   1.559  1.00 57.00           C  
ATOM     27  ND1 HIS A  -9       2.528  66.005   2.513  1.00 60.59           N  
ATOM     28  CD2 HIS A  -9       2.262  63.859   2.205  1.00 58.58           C  
ATOM     29  CE1 HIS A  -9       2.221  65.475   3.685  1.00 60.82           C  
ATOM     30  NE2 HIS A  -9       2.053  64.176   3.525  1.00 59.90           N  
ATOM     31  N   HIS A  -8       4.647  65.516  -2.601  1.00 46.82           N  
ATOM     32  CA  HIS A  -8       4.618  65.419  -4.072  1.00 45.08           C  
ATOM     33  C   HIS A  -8       5.804  64.635  -4.667  1.00 43.82           C  
ATOM     34  O   HIS A  -8       5.824  64.370  -5.887  1.00 42.92           O  
ATOM     35  CB  HIS A  -8       4.572  66.816  -4.688  1.00 46.48           C  
ATOM     36  CG  HIS A  -8       5.851  67.584  -4.545  1.00 50.05           C  
ATOM     37  ND1 HIS A  -8       6.163  68.314  -3.416  1.00 49.99           N  
ATOM     38  CD2 HIS A  -8       6.892  67.744  -5.399  1.00 50.90           C  
ATOM     39  CE1 HIS A  -8       7.343  68.885  -3.580  1.00 56.84           C  
ATOM     40  NE2 HIS A  -8       7.808  68.553  -4.772  1.00 54.29           N  
ATOM     41  N   HIS A  -7       6.794  64.305  -3.820  1.00 40.54           N  
ATOM     42  CA  HIS A  -7       7.861  63.369  -4.185  1.00 39.73           C  
ATOM     43  C   HIS A  -7       7.550  61.959  -3.707  1.00 39.50           C  
ATOM     44  O   HIS A  -7       8.429  61.108  -3.686  1.00 37.50           O  
ATOM     45  CB  HIS A  -7       9.223  63.825  -3.635  1.00 39.04           C  
ATOM     46  CG  HIS A  -7       9.727  65.082  -4.273  1.00 38.72           C  
ATOM     47  ND1 HIS A  -7      10.493  66.005  -3.598  1.00 38.31           N  
ATOM     48  CD2 HIS A  -7       9.539  65.585  -5.515  1.00 39.54           C  
ATOM     49  CE1 HIS A  -7      10.760  67.020  -4.401  1.00 36.55           C  
ATOM     50  NE2 HIS A  -7      10.189  66.794  -5.570  1.00 41.11           N  
ATOM     51  N   GLU A  -6       6.283  61.697  -3.371  1.00 42.08           N  
ATOM     52  CA  GLU A  -6       5.891  60.388  -2.845  1.00 43.48           C  
ATOM     53  C   GLU A  -6       6.173  59.247  -3.847  1.00 41.88           C  
ATOM     54  O   GLU A  -6       6.458  58.119  -3.434  1.00 40.85           O  
ATOM     55  CB  GLU A  -6       4.411  60.404  -2.409  1.00 45.53           C  
ATOM     56  CG  GLU A  -6       4.006  59.289  -1.443  1.00 51.35           C  
ATOM     57  CD  GLU A  -6       4.644  59.406  -0.053  1.00 53.62           C  
ATOM     58  OE1 GLU A  -6       4.711  60.529   0.502  1.00 56.84           O  
ATOM     59  OE2 GLU A  -6       5.049  58.357   0.495  1.00 57.67           O  
ATOM     60  N   ASN A  -5       6.111  59.534  -5.148  1.00 41.17           N  
ATOM     61  CA  ASN A  -5       6.466  58.531  -6.169  1.00 43.54           C  
ATOM     62  C   ASN A  -5       7.912  58.042  -6.050  1.00 43.98           C  
ATOM     63  O   ASN A  -5       8.201  56.845  -6.221  1.00 46.63           O  
ATOM     64  CB  ASN A  -5       6.192  59.028  -7.596  1.00 46.44           C  
ATOM     65  CG  ASN A  -5       6.773  60.417  -7.895  1.00 51.08           C  
ATOM     66  OD1 ASN A  -5       7.075  61.205  -6.994  1.00 52.29           O  
ATOM     67  ND2 ASN A  -5       6.900  60.722  -9.184  1.00 52.90           N  
ATOM     68  N   LEU A  -4       8.813  58.980  -5.774  1.00 42.14           N  
ATOM     69  CA  LEU A  -4      10.226  58.661  -5.516  1.00 41.73           C  
ATOM     70  C   LEU A  -4      10.408  57.926  -4.195  1.00 41.85           C  
ATOM     71  O   LEU A  -4      11.056  56.868  -4.132  1.00 41.59           O  
ATOM     72  CB  LEU A  -4      11.056  59.948  -5.531  1.00 39.89           C  
ATOM     73  CG  LEU A  -4      11.224  60.587  -6.905  1.00 41.23           C  
ATOM     74  CD1 LEU A  -4      11.716  62.019  -6.795  1.00 39.89           C  
ATOM     75  CD2 LEU A  -4      12.182  59.757  -7.767  1.00 41.42           C  
ATOM     76  N   TYR A  -3       9.827  58.480  -3.134  1.00 41.43           N  
ATOM     77  CA  TYR A  -3       9.916  57.854  -1.825  1.00 40.53           C  
ATOM     78  C   TYR A  -3       9.379  56.427  -1.849  1.00 41.21           C  
ATOM     79  O   TYR A  -3       9.878  55.584  -1.123  1.00 39.78           O  
ATOM     80  CB  TYR A  -3       9.150  58.643  -0.769  1.00 38.93           C  
ATOM     81  CG  TYR A  -3       9.635  60.051  -0.543  1.00 38.94           C  
ATOM     82  CD1 TYR A  -3      10.996  60.351  -0.473  1.00 37.29           C  
ATOM     83  CD2 TYR A  -3       8.723  61.083  -0.343  1.00 39.97           C  
ATOM     84  CE1 TYR A  -3      11.423  61.644  -0.245  1.00 40.86           C  
ATOM     85  CE2 TYR A  -3       9.141  62.364  -0.121  1.00 41.76           C  
ATOM     86  CZ  TYR A  -3      10.482  62.648  -0.085  1.00 40.92           C  
ATOM     87  OH  TYR A  -3      10.878  63.938   0.137  1.00 44.55           O  
ATOM     88  N   PHE A  -2       8.362  56.156  -2.673  1.00 37.88           N  
ATOM     89  CA  PHE A  -2       7.776  54.825  -2.681  1.00 39.61           C  
ATOM     90  C   PHE A  -2       8.812  53.793  -3.112  1.00 37.67           C  
ATOM     91  O   PHE A  -2       8.850  52.713  -2.560  1.00 38.01           O  
ATOM     92  CB  PHE A  -2       6.537  54.762  -3.592  1.00 40.76           C  
ATOM     93  CG  PHE A  -2       5.962  53.377  -3.743  1.00 44.47           C  
ATOM     94  CD1 PHE A  -2       5.078  52.869  -2.794  1.00 51.00           C  
ATOM     95  CD2 PHE A  -2       6.302  52.582  -4.828  1.00 46.12           C  
ATOM     96  CE1 PHE A  -2       4.536  51.590  -2.926  1.00 49.42           C  
ATOM     97  CE2 PHE A  -2       5.763  51.309  -4.973  1.00 48.53           C  
ATOM     98  CZ  PHE A  -2       4.879  50.812  -4.013  1.00 50.13           C  
ATOM     99  N   GLN A  -1       9.635  54.135  -4.102  1.00 36.61           N  
ATOM    100  CA  GLN A  -1      10.658  53.221  -4.589  1.00 39.85           C  
ATOM    101  C   GLN A  -1      11.719  52.935  -3.516  1.00 38.20           C  
ATOM    102  O   GLN A  -1      12.170  51.803  -3.364  1.00 38.78           O  
ATOM    103  CB  GLN A  -1      11.321  53.786  -5.840  1.00 38.88           C  
ATOM    104  CG  GLN A  -1      10.354  54.001  -6.999  1.00 43.63           C  
ATOM    105  CD  GLN A  -1      11.041  54.575  -8.196  1.00 45.43           C  
ATOM    106  OE1 GLN A  -1      12.103  54.101  -8.606  1.00 59.12           O  
ATOM    107  NE2 GLN A  -1      10.435  55.606  -8.788  1.00 60.82           N  
ATOM    108  N   GLY A   0      12.098  53.962  -2.767  1.00 37.47           N  
ATOM    109  CA  GLY A   0      13.017  53.785  -1.626  1.00 37.55           C  
ATOM    110  C   GLY A   0      12.406  52.984  -0.492  1.00 37.78           C  
ATOM    111  O   GLY A   0      13.078  52.138   0.127  1.00 38.01           O  
HETATM  112  N   MSE A   1      11.130  53.235  -0.208  1.00 37.61           N  
HETATM  113  CA  MSE A   1      10.420  52.436   0.789  1.00 36.52           C  
HETATM  114  C   MSE A   1      10.437  50.957   0.377  1.00 35.63           C  
HETATM  115  O   MSE A   1      10.780  50.101   1.186  1.00 35.13           O  
HETATM  116  CB  MSE A   1       8.981  52.934   0.960  1.00 37.34           C  
HETATM  117  CG  MSE A   1       8.157  52.238   2.066  1.00 39.32           C  
HETATM  118 SE   MSE A   1       7.438  50.493   1.584  0.70 42.25          SE  
HETATM  119  CE  MSE A   1       6.289  51.048   0.395  1.00 43.75           C  
ATOM    120  N   LYS A   2      10.101  50.653  -0.879  1.00 35.60           N  
ATOM    121  CA  LYS A   2      10.016  49.253  -1.294  1.00 36.93           C  
ATOM    122  C   LYS A   2      11.368  48.559  -1.182  1.00 36.34           C  
ATOM    123  O   LYS A   2      11.438  47.385  -0.820  1.00 36.24           O  
ATOM    124  CB  LYS A   2       9.426  49.119  -2.701  1.00 38.44           C  
ATOM    125  CG  LYS A   2       7.911  49.434  -2.749  1.00 44.05           C  
ATOM    126  CD  LYS A   2       7.033  48.383  -2.008  1.00 49.14           C  
ATOM    127  CE  LYS A   2       6.731  47.148  -2.867  1.00 51.02           C  
ATOM    128  NZ  LYS A   2       6.727  45.877  -2.078  1.00 48.40           N  
ATOM    129  N   ARG A   3      12.438  49.290  -1.472  1.00 38.21           N  
ATOM    130  CA  ARG A   3      13.788  48.749  -1.372  1.00 37.51           C  
ATOM    131  C   ARG A   3      14.164  48.460   0.073  1.00 35.75           C  
ATOM    132  O   ARG A   3      14.705  47.400   0.382  1.00 36.25           O  
ATOM    133  CB  ARG A   3      14.806  49.702  -2.022  1.00 39.18           C  
ATOM    134  CG  ARG A   3      16.257  49.195  -2.004  1.00 40.19           C  
ATOM    135  CD  ARG A   3      16.381  47.744  -2.527  1.00 43.44           C  
ATOM    136  NE  ARG A   3      17.769  47.288  -2.528  1.00 45.28           N  
ATOM    137  CZ  ARG A   3      18.172  46.043  -2.279  1.00 45.98           C  
ATOM    138  NH1 ARG A   3      17.307  45.076  -1.982  1.00 50.76           N  
ATOM    139  NH2 ARG A   3      19.476  45.769  -2.296  1.00 49.27           N  
ATOM    140  N   ALA A   4      13.851  49.394   0.958  1.00 35.98           N  
ATOM    141  CA  ALA A   4      14.074  49.207   2.388  1.00 36.63           C  
ATOM    142  C   ALA A   4      13.270  48.005   2.935  1.00 36.62           C  
ATOM    143  O   ALA A   4      13.805  47.181   3.660  1.00 37.64           O  
ATOM    144  CB  ALA A   4      13.743  50.473   3.148  1.00 37.43           C  
ATOM    145  N   LEU A   5      12.006  47.895   2.540  1.00 37.12           N  
ATOM    146  CA  LEU A   5      11.152  46.804   2.982  1.00 36.24           C  
ATOM    147  C   LEU A   5      11.744  45.476   2.527  1.00 34.89           C  
ATOM    148  O   LEU A   5      11.893  44.549   3.325  1.00 37.54           O  
ATOM    149  CB  LEU A   5       9.742  46.981   2.412  1.00 36.86           C  
ATOM    150  CG  LEU A   5       8.712  45.903   2.760  1.00 35.94           C  
ATOM    151  CD1 LEU A   5       8.381  45.931   4.253  1.00 40.74           C  
ATOM    152  CD2 LEU A   5       7.482  46.092   1.910  1.00 36.28           C  
ATOM    153  N   GLU A   6      12.085  45.404   1.243  1.00 34.64           N  
ATOM    154  CA  GLU A   6      12.677  44.208   0.634  1.00 38.06           C  
ATOM    155  C   GLU A   6      13.946  43.818   1.365  1.00 35.73           C  
ATOM    156  O   GLU A   6      14.124  42.657   1.713  1.00 32.43           O  
ATOM    157  CB  GLU A   6      13.001  44.473  -0.834  1.00 37.91           C  
ATOM    158  CG  GLU A   6      13.653  43.322  -1.582  1.00 42.05           C  
ATOM    159  CD  GLU A   6      14.037  43.721  -3.000  1.00 44.24           C  
ATOM    160  OE1 GLU A   6      14.789  44.703  -3.165  1.00 47.63           O  
ATOM    161  OE2 GLU A   6      13.561  43.067  -3.951  1.00 55.81           O  
ATOM    162  N   PHE A   7      14.830  44.796   1.565  1.00 34.88           N  
ATOM    163  CA  PHE A   7      16.105  44.508   2.190  1.00 36.60           C  
ATOM    164  C   PHE A   7      15.934  44.061   3.649  1.00 36.94           C  
ATOM    165  O   PHE A   7      16.574  43.092   4.086  1.00 37.01           O  
ATOM    166  CB  PHE A   7      17.094  45.680   2.070  1.00 37.79           C  
ATOM    167  CG  PHE A   7      18.496  45.279   2.463  1.00 35.11           C  
ATOM    168  CD1 PHE A   7      19.342  44.708   1.535  1.00 36.43           C  
ATOM    169  CD2 PHE A   7      18.904  45.365   3.777  1.00 37.27           C  
ATOM    170  CE1 PHE A   7      20.612  44.273   1.905  1.00 38.55           C  
ATOM    171  CE2 PHE A   7      20.177  44.937   4.157  1.00 37.19           C  
ATOM    172  CZ  PHE A   7      21.016  44.397   3.229  1.00 37.02           C  
ATOM    173  N   LEU A   8      15.072  44.744   4.400  1.00 37.23           N  
ATOM    174  CA  LEU A   8      14.815  44.363   5.793  1.00 37.19           C  
ATOM    175  C   LEU A   8      14.214  42.967   5.907  1.00 39.53           C  
ATOM    176  O   LEU A   8      14.549  42.230   6.830  1.00 40.88           O  
ATOM    177  CB  LEU A   8      13.929  45.396   6.501  1.00 37.43           C  
ATOM    178  CG  LEU A   8      14.664  46.720   6.801  1.00 38.73           C  
ATOM    179  CD1 LEU A   8      13.724  47.788   7.348  1.00 37.95           C  
ATOM    180  CD2 LEU A   8      15.832  46.510   7.760  1.00 36.55           C  
ATOM    181  N   LYS A   9      13.337  42.602   4.959  1.00 39.08           N  
ATOM    182  CA  LYS A   9      12.878  41.219   4.841  1.00 39.53           C  
ATOM    183  C   LYS A   9      14.011  40.220   4.598  1.00 41.27           C  
ATOM    184  O   LYS A   9      14.004  39.150   5.182  1.00 44.12           O  
ATOM    185  CB  LYS A   9      11.771  41.111   3.776  1.00 37.92           C  
ATOM    186  CG  LYS A   9      10.488  41.727   4.248  1.00 41.54           C  
ATOM    187  CD  LYS A   9       9.373  41.534   3.248  1.00 43.96           C  
ATOM    188  CE  LYS A   9       8.068  42.020   3.807  1.00 53.98           C  
ATOM    189  NZ  LYS A   9       6.960  41.370   3.083  1.00 54.84           N  
ATOM    190  N   GLU A  10      15.003  40.577   3.786  1.00 40.52           N  
ATOM    191  CA  GLU A  10      16.171  39.731   3.569  1.00 41.80           C  
ATOM    192  C   GLU A  10      16.977  39.560   4.850  1.00 40.76           C  
ATOM    193  O   GLU A  10      17.539  38.486   5.086  1.00 41.56           O  
ATOM    194  CB  GLU A  10      17.108  40.307   2.495  1.00 42.37           C  
ATOM    195  CG  GLU A  10      16.563  40.331   1.086  1.00 44.74           C  
ATOM    196  CD  GLU A  10      17.480  41.069   0.095  1.00 48.14           C  
ATOM    197  OE1 GLU A  10      18.708  41.149   0.348  1.00 45.31           O  
ATOM    198  OE2 GLU A  10      16.976  41.572  -0.943  1.00 54.82           O  
ATOM    199  N   CYS A  11      17.069  40.627   5.646  1.00 39.60           N  
ATOM    200  CA  CYS A  11      17.828  40.598   6.900  1.00 37.27           C  
ATOM    201  C   CYS A  11      17.124  39.682   7.896  1.00 39.57           C  
ATOM    202  O   CYS A  11      17.780  38.945   8.615  1.00 41.57           O  
ATOM    203  CB  CYS A  11      17.968  42.002   7.487  1.00 37.79           C  
ATOM    204  SG  CYS A  11      19.005  43.047   6.513  1.00 41.48           S  
ATOM    205  N   GLY A  12      15.800  39.752   7.932  1.00 40.21           N  
ATOM    206  CA  GLY A  12      14.988  39.051   8.906  1.00 41.30           C  
ATOM    207  C   GLY A  12      14.991  39.827  10.195  1.00 40.64           C  
ATOM    208  O   GLY A  12      14.106  40.648  10.439  1.00 43.29           O  
ATOM    209  N   VAL A  13      15.979  39.571  11.030  1.00 38.59           N  
ATOM    210  CA  VAL A  13      16.131  40.362  12.235  0.50 36.95           C  
ATOM    212  C   VAL A  13      16.914  41.619  11.876  1.00 37.63           C  
ATOM    213  O   VAL A  13      17.839  41.587  11.041  1.00 37.37           O  
ATOM    214  CB  VAL A  13      16.794  39.568  13.401  0.50 38.38           C  
ATOM    216  CG1 VAL A  13      18.245  39.202  13.099  0.50 38.41           C  
ATOM    218  CG2 VAL A  13      16.702  40.360  14.681  0.50 37.81           C  
ATOM    220  N   PHE A  14      16.515  42.735  12.467  1.00 35.08           N  
ATOM    221  CA  PHE A  14      17.247  43.956  12.312  1.00 36.47           C  
ATOM    222  C   PHE A  14      17.279  44.651  13.674  1.00 36.86           C  
ATOM    223  O   PHE A  14      16.651  44.199  14.641  1.00 39.09           O  
ATOM    224  CB  PHE A  14      16.688  44.835  11.187  1.00 37.65           C  
ATOM    225  CG  PHE A  14      15.232  45.159  11.341  1.00 35.23           C  
ATOM    226  CD1 PHE A  14      14.270  44.350  10.764  1.00 38.30           C  
ATOM    227  CD2 PHE A  14      14.832  46.293  12.052  1.00 36.88           C  
ATOM    228  CE1 PHE A  14      12.901  44.657  10.903  1.00 39.97           C  
ATOM    229  CE2 PHE A  14      13.477  46.611  12.187  1.00 37.75           C  
ATOM    230  CZ  PHE A  14      12.517  45.802  11.608  1.00 38.09           C  
ATOM    231  N   TYR A  15      18.087  45.695  13.770  1.00 35.19           N  
ATOM    232  CA  TYR A  15      18.354  46.342  15.047  1.00 35.32           C  
ATOM    233  C   TYR A  15      17.889  47.792  15.030  1.00 36.10           C  
ATOM    234  O   TYR A  15      18.296  48.573  14.177  1.00 35.89           O  
ATOM    235  CB  TYR A  15      19.829  46.195  15.409  1.00 33.67           C  
ATOM    236  CG  TYR A  15      20.120  44.733  15.665  1.00 33.99           C  
ATOM    237  CD1 TYR A  15      20.334  43.842  14.621  1.00 34.67           C  
ATOM    238  CD2 TYR A  15      20.111  44.232  16.960  1.00 36.40           C  
ATOM    239  CE1 TYR A  15      20.558  42.500  14.869  1.00 37.13           C  
ATOM    240  CE2 TYR A  15      20.337  42.916  17.214  1.00 36.45           C  
ATOM    241  CZ  TYR A  15      20.565  42.043  16.168  1.00 36.46           C  
ATOM    242  OH  TYR A  15      20.766  40.705  16.458  1.00 39.43           O  
ATOM    243  N   LEU A  16      17.040  48.123  16.001  1.00 34.52           N  
ATOM    244  CA  LEU A  16      16.421  49.439  16.105  1.00 35.24           C  
ATOM    245  C   LEU A  16      17.093  50.230  17.218  1.00 34.00           C  
ATOM    246  O   LEU A  16      17.109  49.789  18.391  1.00 33.51           O  
ATOM    247  CB  LEU A  16      14.948  49.296  16.442  1.00 35.28           C  
ATOM    248  CG  LEU A  16      14.220  50.613  16.738  1.00 37.69           C  
ATOM    249  CD1 LEU A  16      14.170  51.457  15.512  1.00 37.99           C  
ATOM    250  CD2 LEU A  16      12.822  50.329  17.286  1.00 41.57           C  
ATOM    251  N   ALA A  17      17.712  51.342  16.842  1.00 32.42           N  
ATOM    252  CA  ALA A  17      18.359  52.211  17.813  1.00 33.28           C  
ATOM    253  C   ALA A  17      17.506  53.447  18.095  1.00 34.79           C  
ATOM    254  O   ALA A  17      17.016  54.112  17.177  1.00 35.52           O  
ATOM    255  CB  ALA A  17      19.746  52.626  17.340  1.00 33.66           C  
ATOM    256  N   THR A  18      17.330  53.715  19.389  1.00 33.78           N  
ATOM    257  CA  THR A  18      16.669  54.896  19.914  1.00 35.03           C  
ATOM    258  C   THR A  18      17.612  55.561  20.923  1.00 34.97           C  
ATOM    259  O   THR A  18      18.715  55.086  21.162  1.00 36.22           O  
ATOM    260  CB  THR A  18      15.371  54.514  20.671  1.00 35.55           C  
ATOM    261  OG1 THR A  18      15.704  53.538  21.667  1.00 34.89           O  
ATOM    262  CG2 THR A  18      14.386  53.881  19.741  1.00 35.19           C  
ATOM    263  N   ASN A  19      17.150  56.671  21.487  1.00 36.21           N  
ATOM    264  CA  ASN A  19      17.787  57.377  22.599  1.00 38.04           C  
ATOM    265  C   ASN A  19      16.872  57.319  23.808  1.00 36.47           C  
ATOM    266  O   ASN A  19      15.638  57.385  23.662  1.00 34.92           O  
ATOM    267  CB  ASN A  19      17.912  58.892  22.265  1.00 42.89           C  
ATOM    268  CG  ASN A  19      19.200  59.229  21.606  1.00 47.84           C  
ATOM    269  OD1 ASN A  19      19.343  60.278  20.997  1.00 50.37           O  
ATOM    270  ND2 ASN A  19      20.166  58.350  21.740  1.00 53.08           N  
ATOM    271  N   GLU A  20      17.483  57.269  24.984  1.00 34.57           N  
ATOM    272  CA  GLU A  20      16.839  57.553  26.260  1.00 38.36           C  
ATOM    273  C   GLU A  20      17.684  58.658  26.868  1.00 39.48           C  
ATOM    274  O   GLU A  20      18.687  58.409  27.567  1.00 35.22           O  
ATOM    275  CB  GLU A  20      16.805  56.307  27.140  1.00 38.53           C  
ATOM    276  CG  GLU A  20      15.922  56.429  28.339  1.00 39.28           C  
ATOM    277  CD  GLU A  20      15.907  55.178  29.203  1.00 42.36           C  
ATOM    278  OE1 GLU A  20      16.602  54.192  28.893  1.00 44.32           O  
ATOM    279  OE2 GLU A  20      15.198  55.179  30.220  1.00 51.82           O  
ATOM    280  N   GLY A  21      17.326  59.893  26.533  1.00 39.11           N  
ATOM    281  CA  GLY A  21      18.198  61.027  26.793  1.00 40.01           C  
ATOM    282  C   GLY A  21      19.533  60.847  26.100  1.00 40.82           C  
ATOM    283  O   GLY A  21      19.581  60.599  24.898  1.00 42.89           O  
ATOM    284  N   ASP A  22      20.622  60.931  26.864  1.00 38.22           N  
ATOM    285  CA  ASP A  22      21.966  60.784  26.300  1.00 37.92           C  
ATOM    286  C   ASP A  22      22.427  59.329  26.209  1.00 36.81           C  
ATOM    287  O   ASP A  22      23.545  59.091  25.835  1.00 36.18           O  
ATOM    288  CB  ASP A  22      22.990  61.647  27.050  1.00 39.08           C  
ATOM    289  CG  ASP A  22      23.260  61.183  28.464  1.00 39.29           C  
ATOM    290  OD1 ASP A  22      22.573  60.276  28.960  1.00 40.91           O  
ATOM    291  OD2 ASP A  22      24.203  61.716  29.081  1.00 51.71           O  
ATOM    292  N   GLN A  23      21.554  58.376  26.541  1.00 35.12           N  
ATOM    293  CA  GLN A  23      21.873  56.949  26.469  1.00 33.36           C  
ATOM    294  C   GLN A  23      21.297  56.300  25.213  1.00 32.43           C  
ATOM    295  O   GLN A  23      20.083  56.157  25.078  1.00 33.77           O  
ATOM    296  CB  GLN A  23      21.347  56.228  27.720  1.00 34.47           C  
ATOM    297  CG  GLN A  23      21.529  54.720  27.708  1.00 33.56           C  
ATOM    298  CD  GLN A  23      22.974  54.305  27.779  1.00 33.30           C  
ATOM    299  OE1 GLN A  23      23.657  54.571  28.787  1.00 32.11           O  
ATOM    300  NE2 GLN A  23      23.459  53.630  26.719  1.00 32.44           N  
ATOM    301  N   PRO A  24      22.164  55.901  24.271  1.00 34.78           N  
ATOM    302  CA  PRO A  24      21.676  55.091  23.156  1.00 34.56           C  
ATOM    303  C   PRO A  24      21.144  53.766  23.644  1.00 33.93           C  
ATOM    304  O   PRO A  24      21.659  53.199  24.599  1.00 33.19           O  
ATOM    305  CB  PRO A  24      22.907  54.873  22.283  1.00 38.00           C  
ATOM    306  CG  PRO A  24      23.955  55.758  22.811  1.00 38.09           C  
ATOM    307  CD  PRO A  24      23.600  56.197  24.174  1.00 34.96           C  
ATOM    308  N   ARG A  25      20.115  53.293  22.962  1.00 33.43           N  
ATOM    309  CA  ARG A  25      19.514  51.991  23.187  1.00 33.32           C  
ATOM    310  C   ARG A  25      19.360  51.274  21.850  1.00 35.13           C  
ATOM    311  O   ARG A  25      19.056  51.904  20.839  1.00 37.13           O  
ATOM    312  CB  ARG A  25      18.135  52.173  23.802  1.00 33.29           C  
ATOM    313  CG  ARG A  25      18.095  52.824  25.167  1.00 33.54           C  
ATOM    314  CD  ARG A  25      18.788  51.992  26.220  1.00 33.11           C  
ATOM    315  NE  ARG A  25      18.549  52.512  27.552  1.00 34.93           N  
ATOM    316  CZ  ARG A  25      19.127  52.040  28.647  1.00 34.65           C  
ATOM    317  NH1 ARG A  25      19.950  51.010  28.575  1.00 37.32           N  
ATOM    318  NH2 ARG A  25      18.855  52.570  29.836  1.00 39.43           N  
ATOM    319  N   VAL A  26      19.568  49.958  21.860  1.00 35.16           N  
ATOM    320  CA  VAL A  26      19.397  49.126  20.675  1.00 34.46           C  
ATOM    321  C   VAL A  26      18.920  47.744  21.054  1.00 34.06           C  
ATOM    322  O   VAL A  26      19.316  47.188  22.089  1.00 34.14           O  
ATOM    323  CB  VAL A  26      20.700  49.075  19.814  1.00 33.80           C  
ATOM    324  CG1 VAL A  26      21.881  48.509  20.574  1.00 35.08           C  
ATOM    325  CG2 VAL A  26      20.494  48.307  18.510  1.00 37.60           C  
ATOM    326  N   ARG A  27      18.061  47.194  20.208  1.00 33.21           N  
ATOM    327  CA  ARG A  27      17.478  45.872  20.439  1.00 33.16           C  
ATOM    328  C   ARG A  27      17.049  45.282  19.107  1.00 35.69           C  
ATOM    329  O   ARG A  27      16.826  46.032  18.162  1.00 35.42           O  
ATOM    330  CB  ARG A  27      16.286  45.954  21.403  1.00 33.31           C  
ATOM    331  CG  ARG A  27      14.973  46.417  20.786  1.00 33.99           C  
ATOM    332  CD  ARG A  27      14.989  47.907  20.540  1.00 35.07           C  
ATOM    333  NE  ARG A  27      14.963  48.661  21.785  1.00 34.28           N  
ATOM    334  CZ  ARG A  27      15.272  49.950  21.936  1.00 34.33           C  
ATOM    335  NH1 ARG A  27      15.701  50.686  20.926  1.00 35.16           N  
ATOM    336  NH2 ARG A  27      15.115  50.513  23.111  1.00 35.45           N  
ATOM    337  N   PRO A  28      16.942  43.946  19.030  1.00 34.60           N  
ATOM    338  CA  PRO A  28      16.462  43.324  17.798  1.00 35.44           C  
ATOM    339  C   PRO A  28      14.965  43.559  17.577  1.00 35.41           C  
ATOM    340  O   PRO A  28      14.164  43.534  18.526  1.00 37.47           O  
ATOM    341  CB  PRO A  28      16.756  41.837  18.014  1.00 35.24           C  
ATOM    342  CG  PRO A  28      16.831  41.642  19.458  1.00 37.39           C  
ATOM    343  CD  PRO A  28      17.289  42.938  20.053  1.00 34.86           C  
ATOM    344  N   PHE A  29      14.617  43.853  16.327  1.00 36.81           N  
ATOM    345  CA  PHE A  29      13.237  43.939  15.845  1.00 37.07           C  
ATOM    346  C   PHE A  29      13.120  42.979  14.655  1.00 39.32           C  
ATOM    347  O   PHE A  29      14.117  42.577  14.059  1.00 37.13           O  
ATOM    348  CB  PHE A  29      12.898  45.377  15.398  1.00 37.75           C  
ATOM    349  CG  PHE A  29      12.122  46.190  16.415  1.00 38.36           C  
ATOM    350  CD1 PHE A  29      12.410  46.145  17.766  1.00 39.18           C  
ATOM    351  CD2 PHE A  29      11.098  47.030  15.997  1.00 37.49           C  
ATOM    352  CE1 PHE A  29      11.679  46.905  18.682  1.00 42.43           C  
ATOM    353  CE2 PHE A  29      10.410  47.810  16.890  1.00 35.74           C  
ATOM    354  CZ  PHE A  29      10.666  47.730  18.240  1.00 39.74           C  
ATOM    355  N   GLY A  30      11.916  42.597  14.277  1.00 40.11           N  
ATOM    356  CA  GLY A  30      11.817  41.586  13.230  1.00 40.42           C  
ATOM    357  C   GLY A  30      10.564  41.556  12.387  1.00 41.03           C  
ATOM    358  O   GLY A  30      10.355  40.602  11.673  1.00 43.77           O  
ATOM    359  N   ALA A  31       9.748  42.586  12.463  1.00 38.31           N  
ATOM    360  CA  ALA A  31       8.479  42.588  11.726  1.00 40.22           C  
ATOM    361  C   ALA A  31       8.470  43.899  10.990  1.00 40.71           C  
ATOM    362  O   ALA A  31       8.786  44.939  11.570  1.00 44.73           O  
ATOM    363  CB  ALA A  31       7.299  42.483  12.670  1.00 39.52           C  
ATOM    364  N   VAL A  32       8.217  43.834   9.698  1.00 39.44           N  
ATOM    365  CA  VAL A  32       8.002  45.023   8.897  1.00 37.97           C  
ATOM    366  C   VAL A  32       6.905  44.723   7.926  1.00 36.83           C  
ATOM    367  O   VAL A  32       6.725  43.577   7.485  1.00 36.28           O  
ATOM    368  CB  VAL A  32       9.273  45.499   8.093  1.00 39.34           C  
ATOM    369  CG1 VAL A  32      10.292  46.073   9.017  1.00 45.25           C  
ATOM    370  CG2 VAL A  32       9.872  44.356   7.266  1.00 38.18           C  
ATOM    371  N   PHE A  33       6.150  45.757   7.585  1.00 35.48           N  
ATOM    372  CA  PHE A  33       5.129  45.639   6.557  1.00 34.10           C  
ATOM    373  C   PHE A  33       4.921  47.020   5.946  1.00 34.89           C  
ATOM    374  O   PHE A  33       5.422  48.024   6.482  1.00 35.17           O  
ATOM    375  CB  PHE A  33       3.812  45.073   7.122  1.00 35.67           C  
ATOM    376  CG  PHE A  33       3.121  45.978   8.093  1.00 32.30           C  
ATOM    377  CD1 PHE A  33       3.476  45.991   9.430  1.00 37.40           C  
ATOM    378  CD2 PHE A  33       2.100  46.824   7.670  1.00 35.77           C  
ATOM    379  CE1 PHE A  33       2.847  46.827  10.327  1.00 36.79           C  
ATOM    380  CE2 PHE A  33       1.457  47.665   8.575  1.00 37.03           C  
ATOM    381  CZ  PHE A  33       1.838  47.660   9.899  1.00 33.84           C  
ATOM    382  N   GLU A  34       4.232  47.054   4.812  1.00 36.45           N  
ATOM    383  CA  GLU A  34       3.894  48.307   4.158  1.00 36.61           C  
ATOM    384  C   GLU A  34       2.394  48.564   4.207  1.00 37.17           C  
ATOM    385  O   GLU A  34       1.569  47.629   4.133  1.00 36.99           O  
ATOM    386  CB  GLU A  34       4.375  48.313   2.707  1.00 38.61           C  
ATOM    387  CG  GLU A  34       3.551  47.472   1.759  1.00 45.39           C  
ATOM    388  CD  GLU A  34       4.019  47.576   0.317  1.00 42.37           C  
ATOM    389  OE1 GLU A  34       3.804  48.643  -0.304  1.00 46.14           O  
ATOM    390  OE2 GLU A  34       4.581  46.575  -0.182  1.00 42.04           O  
ATOM    391  N   TYR A  35       2.040  49.845   4.286  1.00 35.66           N  
ATOM    392  CA  TYR A  35       0.672  50.259   4.175  1.00 36.35           C  
ATOM    393  C   TYR A  35       0.618  51.688   3.641  1.00 36.78           C  
ATOM    394  O   TYR A  35       1.312  52.556   4.153  1.00 34.79           O  
ATOM    395  CB  TYR A  35      -0.030  50.169   5.525  1.00 36.53           C  
ATOM    396  CG  TYR A  35      -1.505  50.494   5.451  1.00 38.27           C  
ATOM    397  CD1 TYR A  35      -2.048  51.468   6.257  1.00 41.29           C  
ATOM    398  CD2 TYR A  35      -2.355  49.817   4.583  1.00 42.43           C  
ATOM    399  CE1 TYR A  35      -3.392  51.783   6.193  1.00 42.55           C  
ATOM    400  CE2 TYR A  35      -3.700  50.117   4.523  1.00 36.94           C  
ATOM    401  CZ  TYR A  35      -4.210  51.104   5.324  1.00 39.88           C  
ATOM    402  OH  TYR A  35      -5.550  51.435   5.291  1.00 42.69           O  
ATOM    403  N   GLU A  36      -0.222  51.916   2.629  1.00 38.26           N  
ATOM    404  CA  GLU A  36      -0.345  53.229   1.969  1.00 38.39           C  
ATOM    405  C   GLU A  36       1.006  53.852   1.610  1.00 37.69           C  
ATOM    406  O   GLU A  36       1.209  55.059   1.787  1.00 35.77           O  
ATOM    407  CB  GLU A  36      -1.118  54.204   2.854  1.00 38.99           C  
ATOM    408  CG  GLU A  36      -2.533  53.792   3.146  1.00 40.69           C  
ATOM    409  CD  GLU A  36      -3.138  54.600   4.298  1.00 43.44           C  
ATOM    410  OE1 GLU A  36      -2.366  55.151   5.131  1.00 44.28           O  
ATOM    411  OE2 GLU A  36      -4.377  54.654   4.366  1.00 46.01           O  
ATOM    412  N   GLY A  37       1.943  53.025   1.144  1.00 36.79           N  
ATOM    413  CA  GLY A  37       3.243  53.508   0.702  1.00 36.67           C  
ATOM    414  C   GLY A  37       4.248  53.810   1.800  1.00 37.66           C  
ATOM    415  O   GLY A  37       5.321  54.336   1.511  1.00 37.57           O  
ATOM    416  N   LYS A  38       3.903  53.477   3.047  1.00 37.19           N  
ATOM    417  CA  LYS A  38       4.751  53.732   4.213  1.00 35.95           C  
ATOM    418  C   LYS A  38       5.306  52.430   4.791  1.00 35.52           C  
ATOM    419  O   LYS A  38       4.666  51.374   4.739  1.00 34.74           O  
ATOM    420  CB  LYS A  38       3.967  54.468   5.307  1.00 36.85           C  
ATOM    421  CG  LYS A  38       3.326  55.782   4.881  1.00 35.74           C  
ATOM    422  CD  LYS A  38       4.360  56.833   4.512  1.00 40.77           C  
ATOM    423  CE  LYS A  38       3.717  58.170   4.223  1.00 44.80           C  
ATOM    424  NZ  LYS A  38       4.546  59.041   3.339  1.00 49.80           N  
ATOM    425  N   LEU A  39       6.499  52.537   5.354  1.00 35.06           N  
ATOM    426  CA  LEU A  39       7.171  51.430   6.005  1.00 34.35           C  
ATOM    427  C   LEU A  39       6.849  51.426   7.495  1.00 34.80           C  
ATOM    428  O   LEU A  39       7.147  52.399   8.218  1.00 34.10           O  
ATOM    429  CB  LEU A  39       8.683  51.543   5.793  1.00 35.97           C  
ATOM    430  CG  LEU A  39       9.523  50.464   6.486  1.00 33.78           C  
ATOM    431  CD1 LEU A  39       9.283  49.095   5.867  1.00 39.79           C  
ATOM    432  CD2 LEU A  39      10.996  50.826   6.474  1.00 37.16           C  
ATOM    433  N   TYR A  40       6.259  50.323   7.951  1.00 33.44           N  
ATOM    434  CA  TYR A  40       5.853  50.163   9.346  1.00 33.42           C  
ATOM    435  C   TYR A  40       6.698  49.133  10.091  1.00 34.93           C  
ATOM    436  O   TYR A  40       7.135  48.138   9.507  1.00 33.96           O  
ATOM    437  CB  TYR A  40       4.399  49.687   9.432  1.00 35.50           C  
ATOM    438  CG  TYR A  40       3.371  50.776   9.202  1.00 35.23           C  
ATOM    439  CD1 TYR A  40       3.045  51.172   7.917  1.00 36.04           C  
ATOM    440  CD2 TYR A  40       2.720  51.391  10.280  1.00 33.94           C  
ATOM    441  CE1 TYR A  40       2.094  52.159   7.695  1.00 33.97           C  
ATOM    442  CE2 TYR A  40       1.790  52.379  10.069  1.00 38.02           C  
ATOM    443  CZ  TYR A  40       1.481  52.757   8.774  1.00 36.15           C  
ATOM    444  OH  TYR A  40       0.520  53.718   8.548  1.00 35.92           O  
ATOM    445  N   ILE A  41       6.897  49.414  11.380  1.00 34.42           N  
ATOM    446  CA  ILE A  41       7.419  48.493  12.378  1.00 36.17           C  
ATOM    447  C   ILE A  41       6.347  48.344  13.449  1.00 35.72           C  
ATOM    448  O   ILE A  41       5.375  49.101  13.462  1.00 35.53           O  
ATOM    449  CB  ILE A  41       8.747  48.993  12.978  1.00 36.04           C  
ATOM    450  CG1 ILE A  41       8.605  50.377  13.640  1.00 35.99           C  
ATOM    451  CG2 ILE A  41       9.794  49.032  11.870  1.00 37.27           C  
ATOM    452  CD1 ILE A  41       9.802  50.871  14.410  1.00 41.60           C  
ATOM    453  N   VAL A  42       6.494  47.354  14.319  1.00 34.47           N  
ATOM    454  CA  VAL A  42       5.503  47.126  15.346  1.00 35.12           C  
ATOM    455  C   VAL A  42       6.173  47.113  16.701  1.00 35.10           C  
ATOM    456  O   VAL A  42       7.370  46.814  16.831  1.00 35.14           O  
ATOM    457  CB  VAL A  42       4.673  45.808  15.102  1.00 36.72           C  
ATOM    458  CG1 VAL A  42       4.140  45.753  13.681  1.00 40.65           C  
ATOM    459  CG2 VAL A  42       5.484  44.572  15.403  1.00 40.75           C  
ATOM    460  N   SER A  43       5.400  47.451  17.718  1.00 33.34           N  
ATOM    461  CA  SER A  43       5.848  47.329  19.087  1.00 35.23           C  
ATOM    462  C   SER A  43       4.634  47.248  20.017  1.00 35.84           C  
ATOM    463  O   SER A  43       3.561  46.845  19.617  1.00 36.90           O  
ATOM    464  CB  SER A  43       6.805  48.482  19.483  1.00 38.57           C  
ATOM    465  OG  SER A  43       7.646  48.087  20.557  1.00 40.97           O  
ATOM    466  N   ASN A  44       4.876  47.579  21.269  1.00 36.67           N  
ATOM    467  CA  ASN A  44       3.951  47.395  22.389  1.00 39.22           C  
ATOM    468  C   ASN A  44       4.047  48.695  23.199  1.00 37.65           C  
ATOM    469  O   ASN A  44       5.154  49.102  23.562  1.00 35.98           O  
ATOM    470  CB  ASN A  44       4.544  46.187  23.123  1.00 45.63           C  
ATOM    471  CG  ASN A  44       3.984  45.927  24.460  1.00 40.15           C  
ATOM    472  OD1 ASN A  44       3.562  46.812  25.174  1.00 39.77           O  
ATOM    473  ND2 ASN A  44       4.061  44.670  24.851  1.00 45.59           N  
ATOM    474  N   ASN A  45       2.914  49.336  23.473  1.00 36.46           N  
ATOM    475  CA  ASN A  45       2.926  50.668  24.085  1.00 38.43           C  
ATOM    476  C   ASN A  45       3.321  50.700  25.558  1.00 37.00           C  
ATOM    477  O   ASN A  45       3.406  51.773  26.154  1.00 37.06           O  
ATOM    478  CB  ASN A  45       1.608  51.406  23.852  1.00 39.84           C  
ATOM    479  CG  ASN A  45       0.417  50.712  24.495  1.00 39.01           C  
ATOM    480  OD1 ASN A  45       0.550  50.018  25.508  1.00 35.77           O  
ATOM    481  ND2 ASN A  45      -0.753  50.889  23.893  1.00 39.20           N  
ATOM    482  N   THR A  46       3.588  49.528  26.133  1.00 35.21           N  
ATOM    483  CA  THR A  46       4.093  49.431  27.491  1.00 37.32           C  
ATOM    484  C   THR A  46       5.616  49.361  27.546  1.00 36.86           C  
ATOM    485  O   THR A  46       6.184  49.452  28.622  1.00 38.82           O  
ATOM    486  CB  THR A  46       3.517  48.189  28.232  1.00 38.83           C  
ATOM    487  OG1 THR A  46       4.055  46.979  27.678  1.00 40.89           O  
ATOM    488  CG2 THR A  46       1.998  48.170  28.154  1.00 40.62           C  
ATOM    489  N   LYS A  47       6.276  49.181  26.404  1.00 38.12           N  
ATOM    490  CA  LYS A  47       7.728  48.962  26.373  1.00 39.91           C  
ATOM    491  C   LYS A  47       8.530  50.255  26.381  1.00 38.16           C  
ATOM    492  O   LYS A  47       8.091  51.279  25.847  1.00 36.97           O  
ATOM    493  CB  LYS A  47       8.131  48.189  25.120  1.00 41.56           C  
ATOM    494  CG  LYS A  47       7.662  46.748  25.073  1.00 42.94           C  
ATOM    495  CD  LYS A  47       8.225  46.132  23.791  1.00 44.29           C  
ATOM    496  CE  LYS A  47       7.823  44.690  23.562  1.00 48.70           C  
ATOM    497  NZ  LYS A  47       8.584  44.131  22.395  1.00 44.42           N  
ATOM    498  N   LYS A  48       9.732  50.191  26.956  1.00 35.81           N  
ATOM    499  CA  LYS A  48      10.646  51.324  26.963  1.00 36.62           C  
ATOM    500  C   LYS A  48      10.965  51.806  25.540  1.00 35.06           C  
ATOM    501  O   LYS A  48      11.032  53.009  25.287  1.00 34.96           O  
ATOM    502  CB  LYS A  48      11.961  50.975  27.715  1.00 37.48           C  
ATOM    503  CG  LYS A  48      11.778  50.793  29.216  1.00 37.66           C  
ATOM    504  CD  LYS A  48      13.088  50.410  29.942  1.00 40.10           C  
ATOM    505  N   CYS A  49      11.153  50.878  24.613  1.00 34.89           N  
ATOM    506  CA  CYS A  49      11.495  51.251  23.246  0.70 34.58           C  
ATOM    508  C   CYS A  49      10.399  52.121  22.618  1.00 35.73           C  
ATOM    509  O   CYS A  49      10.706  53.101  21.948  1.00 34.59           O  
ATOM    510  CB  CYS A  49      11.815  50.029  22.371  0.70 36.21           C  
ATOM    512  SG  CYS A  49      10.483  48.824  22.120  0.70 36.06           S  
ATOM    514  N   PHE A  50       9.140  51.775  22.859  1.00 33.07           N  
ATOM    515  CA  PHE A  50       8.020  52.563  22.351  1.00 33.84           C  
ATOM    516  C   PHE A  50       8.026  53.959  22.969  1.00 35.21           C  
ATOM    517  O   PHE A  50       7.925  54.972  22.278  1.00 35.49           O  
ATOM    518  CB  PHE A  50       6.693  51.885  22.686  1.00 34.38           C  
ATOM    519  CG  PHE A  50       5.500  52.665  22.228  1.00 34.10           C  
ATOM    520  CD1 PHE A  50       5.060  52.561  20.924  1.00 36.20           C  
ATOM    521  CD2 PHE A  50       4.831  53.508  23.083  1.00 35.65           C  
ATOM    522  CE1 PHE A  50       3.981  53.288  20.494  1.00 34.73           C  
ATOM    523  CE2 PHE A  50       3.740  54.255  22.647  1.00 35.87           C  
ATOM    524  CZ  PHE A  50       3.318  54.138  21.353  1.00 35.03           C  
ATOM    525  N   LYS A  51       8.164  54.017  24.289  1.00 35.60           N  
ATOM    526  CA  LYS A  51       8.137  55.295  24.993  1.00 36.27           C  
ATOM    527  C   LYS A  51       9.290  56.185  24.496  1.00 35.99           C  
ATOM    528  O   LYS A  51       9.137  57.404  24.340  1.00 35.45           O  
ATOM    529  CB  LYS A  51       8.222  55.066  26.501  1.00 37.31           C  
ATOM    530  CG  LYS A  51       6.984  54.366  27.056  1.00 41.52           C  
ATOM    531  CD  LYS A  51       7.184  53.759  28.442  1.00 43.03           C  
ATOM    532  CE  LYS A  51       5.857  53.174  28.943  1.00 47.57           C  
ATOM    533  NZ  LYS A  51       5.967  52.502  30.271  1.00 54.06           N  
ATOM    534  N   GLN A  52      10.428  55.568  24.225  1.00 34.83           N  
ATOM    535  CA  GLN A  52      11.587  56.301  23.680  1.00 34.72           C  
ATOM    536  C   GLN A  52      11.276  56.896  22.316  1.00 34.69           C  
ATOM    537  O   GLN A  52      11.678  58.021  22.026  1.00 36.42           O  
ATOM    538  CB  GLN A  52      12.817  55.394  23.621  1.00 36.90           C  
ATOM    539  CG  GLN A  52      13.360  55.086  25.023  1.00 33.65           C  
ATOM    540  CD  GLN A  52      14.212  53.854  25.095  1.00 34.58           C  
ATOM    541  OE1 GLN A  52      14.702  53.348  24.083  1.00 35.19           O  
ATOM    542  NE2 GLN A  52      14.403  53.348  26.317  1.00 34.46           N  
HETATM  543  N   MSE A  53      10.538  56.152  21.483  1.00 34.18           N  
HETATM  544  CA  MSE A  53      10.227  56.616  20.111  1.00 34.47           C  
HETATM  545  C   MSE A  53       9.208  57.744  20.123  1.00 36.42           C  
HETATM  546  O   MSE A  53       9.197  58.586  19.218  1.00 36.41           O  
HETATM  547  CB  MSE A  53       9.730  55.469  19.247  1.00 37.45           C  
HETATM  548  CG  MSE A  53      10.851  54.499  18.858  1.00 34.72           C  
HETATM  549 SE   MSE A  53      10.230  53.140  17.629  0.70 35.79          SE  
HETATM  550  CE  MSE A  53       9.255  52.098  18.711  1.00 38.56           C  
ATOM    551  N   ILE A  54       8.350  57.748  21.145  1.00 36.47           N  
ATOM    552  CA  ILE A  54       7.391  58.848  21.351  1.00 36.30           C  
ATOM    553  C   ILE A  54       8.129  60.089  21.832  1.00 37.56           C  
ATOM    554  O   ILE A  54       7.893  61.184  21.321  1.00 36.39           O  
ATOM    555  CB  ILE A  54       6.287  58.455  22.344  1.00 36.81           C  
ATOM    556  CG1 ILE A  54       5.495  57.245  21.828  1.00 35.46           C  
ATOM    557  CG2 ILE A  54       5.352  59.637  22.622  1.00 37.83           C  
ATOM    558  CD1 ILE A  54       4.972  57.389  20.397  1.00 41.51           C  
ATOM    559  N   GLN A  55       9.048  59.913  22.776  1.00 35.31           N  
ATOM    560  CA  GLN A  55       9.775  61.026  23.364  1.00 35.65           C  
ATOM    561  C   GLN A  55      10.771  61.644  22.369  1.00 37.11           C  
ATOM    562  O   GLN A  55      10.970  62.856  22.367  1.00 38.87           O  
ATOM    563  CB  GLN A  55      10.448  60.572  24.679  1.00 36.33           C  
ATOM    564  CG  GLN A  55      11.412  61.545  25.329  1.00 41.39           C  
ATOM    565  CD  GLN A  55      10.750  62.824  25.762  1.00 52.55           C  
ATOM    566  OE1 GLN A  55       9.519  62.889  25.931  1.00 54.15           O  
ATOM    567  NE2 GLN A  55      11.565  63.859  25.969  1.00 56.43           N  
ATOM    568  N   ASN A  56      11.365  60.810  21.520  1.00 34.69           N  
ATOM    569  CA  ASN A  56      12.315  61.253  20.481  1.00 34.56           C  
ATOM    570  C   ASN A  56      12.103  60.399  19.250  1.00 34.14           C  
ATOM    571  O   ASN A  56      12.482  59.229  19.244  1.00 34.31           O  
ATOM    572  CB  ASN A  56      13.755  61.137  20.964  1.00 36.20           C  
ATOM    573  CG  ASN A  56      14.773  61.607  19.917  1.00 37.11           C  
ATOM    574  OD1 ASN A  56      14.415  62.002  18.804  1.00 39.08           O  
ATOM    575  ND2 ASN A  56      16.051  61.580  20.293  1.00 36.08           N  
ATOM    576  N   PRO A  57      11.449  60.957  18.221  1.00 34.92           N  
ATOM    577  CA  PRO A  57      11.096  60.187  17.036  1.00 36.41           C  
ATOM    578  C   PRO A  57      12.277  59.797  16.157  1.00 35.27           C  
ATOM    579  O   PRO A  57      12.109  58.990  15.255  1.00 34.41           O  
ATOM    580  CB  PRO A  57      10.160  61.130  16.277  1.00 35.92           C  
ATOM    581  CG  PRO A  57      10.555  62.447  16.689  1.00 40.85           C  
ATOM    582  CD  PRO A  57      10.952  62.341  18.125  1.00 38.39           C  
ATOM    583  N   LYS A  58      13.457  60.345  16.409  1.00 35.40           N  
ATOM    584  CA  LYS A  58      14.616  60.008  15.609  1.00 33.63           C  
ATOM    585  C   LYS A  58      15.125  58.634  15.985  1.00 34.66           C  
ATOM    586  O   LYS A  58      15.426  58.354  17.163  1.00 35.20           O  
ATOM    587  CB  LYS A  58      15.736  61.010  15.820  1.00 34.51           C  
ATOM    588  CG  LYS A  58      15.450  62.362  15.278  1.00 33.35           C  
ATOM    589  CD  LYS A  58      16.636  63.279  15.484  1.00 36.52           C  
ATOM    590  CE  LYS A  58      16.343  64.661  14.956  1.00 39.73           C  
ATOM    591  NZ  LYS A  58      17.576  65.491  14.953  1.00 40.27           N  
ATOM    592  N   VAL A  59      15.266  57.794  14.964  1.00 34.87           N  
ATOM    593  CA  VAL A  59      15.784  56.453  15.124  1.00 33.92           C  
ATOM    594  C   VAL A  59      16.806  56.117  14.043  1.00 34.32           C  
ATOM    595  O   VAL A  59      16.937  56.832  13.050  1.00 34.65           O  
ATOM    596  CB  VAL A  59      14.629  55.416  15.076  1.00 32.50           C  
ATOM    597  CG1 VAL A  59      13.567  55.765  16.088  1.00 36.78           C  
ATOM    598  CG2 VAL A  59      14.022  55.321  13.650  1.00 33.42           C  
ATOM    599  N   GLU A  60      17.537  55.022  14.242  1.00 35.23           N  
ATOM    600  CA  GLU A  60      18.295  54.414  13.151  1.00 34.37           C  
ATOM    601  C   GLU A  60      18.132  52.897  13.210  1.00 34.41           C  
ATOM    602  O   GLU A  60      18.064  52.318  14.293  1.00 33.89           O  
ATOM    603  CB  GLU A  60      19.760  54.878  13.163  1.00 34.25           C  
ATOM    604  CG  GLU A  60      20.583  54.423  11.940  1.00 35.59           C  
ATOM    605  CD  GLU A  60      21.872  55.220  11.752  1.00 36.53           C  
ATOM    606  OE1 GLU A  60      21.829  56.297  11.101  1.00 39.94           O  
ATOM    607  OE2 GLU A  60      22.933  54.787  12.260  1.00 39.45           O  
ATOM    608  N   ILE A  61      18.048  52.269  12.035  1.00 35.27           N  
ATOM    609  CA  ILE A  61      17.992  50.821  11.910  1.00 35.83           C  
ATOM    610  C   ILE A  61      19.222  50.305  11.171  1.00 33.85           C  
ATOM    611  O   ILE A  61      19.662  50.902  10.183  1.00 34.97           O  
ATOM    612  CB  ILE A  61      16.704  50.402  11.164  1.00 36.58           C  
ATOM    613  CG1 ILE A  61      15.486  50.600  12.102  1.00 37.61           C  
ATOM    614  CG2 ILE A  61      16.809  48.972  10.661  1.00 37.72           C  
ATOM    615  CD1 ILE A  61      14.152  50.308  11.484  1.00 38.77           C  
ATOM    616  N   SER A  62      19.783  49.187  11.634  1.00 34.06           N  
ATOM    617  CA  SER A  62      20.788  48.487  10.866  1.00 34.86           C  
ATOM    618  C   SER A  62      20.543  46.985  10.904  1.00 34.52           C  
ATOM    619  O   SER A  62      19.887  46.457  11.812  1.00 35.80           O  
ATOM    620  CB  SER A  62      22.193  48.854  11.354  1.00 34.40           C  
ATOM    621  OG  SER A  62      23.179  48.245  10.539  1.00 36.63           O  
ATOM    622  N   GLY A  63      20.984  46.310   9.846  1.00 35.07           N  
ATOM    623  CA  GLY A  63      20.847  44.885   9.743  1.00 35.75           C  
ATOM    624  C   GLY A  63      21.677  44.355   8.587  1.00 35.60           C  
ATOM    625  O   GLY A  63      22.176  45.142   7.783  1.00 35.21           O  
HETATM  626  N   MSE A  64      21.848  43.034   8.544  1.00 36.25           N  
HETATM  627  CA  MSE A  64      22.709  42.369   7.564  1.00 36.72           C  
HETATM  628  C   MSE A  64      22.003  41.136   6.990  1.00 36.48           C  
HETATM  629  O   MSE A  64      21.305  40.425   7.698  1.00 37.48           O  
HETATM  630  CB  MSE A  64      24.027  41.952   8.219  1.00 36.07           C  
HETATM  631  CG  MSE A  64      25.028  41.325   7.285  1.00 36.67           C  
HETATM  632 SE   MSE A  64      26.634  40.761   8.217  0.70 37.65          SE  
HETATM  633  CE  MSE A  64      27.152  42.504   8.584  1.00 41.71           C  
ATOM    634  N   ASN A  65      22.235  40.857   5.714  1.00 35.79           N  
ATOM    635  CA  ASN A  65      21.631  39.685   5.082  1.00 35.43           C  
ATOM    636  C   ASN A  65      22.668  38.564   4.970  1.00 37.48           C  
ATOM    637  O   ASN A  65      23.773  38.719   5.444  1.00 35.22           O  
ATOM    638  CB  ASN A  65      20.978  40.043   3.754  1.00 35.61           C  
ATOM    639  CG  ASN A  65      21.961  40.424   2.666  1.00 39.14           C  
ATOM    640  OD1 ASN A  65      23.168  40.219   2.777  1.00 37.11           O  
ATOM    641  ND2 ASN A  65      21.419  40.973   1.572  1.00 40.60           N  
ATOM    642  N   LYS A  66      22.302  37.441   4.356  1.00 38.88           N  
ATOM    643  CA  LYS A  66      23.165  36.248   4.353  1.00 41.55           C  
ATOM    644  C   LYS A  66      24.436  36.419   3.531  1.00 42.99           C  
ATOM    645  O   LYS A  66      25.448  35.759   3.798  1.00 42.75           O  
ATOM    646  CB  LYS A  66      22.365  35.024   3.890  1.00 42.60           C  
ATOM    647  CG  LYS A  66      21.295  34.638   4.888  1.00 47.10           C  
ATOM    648  N   LYS A  67      24.401  37.340   2.575  1.00 42.64           N  
ATOM    649  CA  LYS A  67      25.559  37.668   1.759  1.00 43.63           C  
ATOM    650  C   LYS A  67      26.498  38.670   2.428  1.00 41.12           C  
ATOM    651  O   LYS A  67      27.489  39.086   1.827  1.00 41.27           O  
ATOM    652  CB  LYS A  67      25.095  38.254   0.410  1.00 46.13           C  
ATOM    653  CG  LYS A  67      24.115  37.388  -0.370  1.00 50.60           C  
ATOM    654  N   GLY A  68      26.181  39.125   3.637  1.00 39.61           N  
ATOM    655  CA  GLY A  68      27.020  40.128   4.300  1.00 39.75           C  
ATOM    656  C   GLY A  68      26.762  41.579   3.875  1.00 38.96           C  
ATOM    657  O   GLY A  68      27.502  42.481   4.250  1.00 40.82           O  
ATOM    658  N   GLN A  69      25.727  41.823   3.089  1.00 38.13           N  
ATOM    659  CA  GLN A  69      25.344  43.193   2.767  1.00 35.87           C  
ATOM    660  C   GLN A  69      24.618  43.751   3.974  1.00 35.76           C  
ATOM    661  O   GLN A  69      23.944  43.013   4.706  1.00 35.15           O  
ATOM    662  CB  GLN A  69      24.397  43.250   1.584  1.00 36.63           C  
ATOM    663  CG  GLN A  69      24.872  42.643   0.292  1.00 38.89           C  
ATOM    664  CD  GLN A  69      23.806  42.806  -0.778  1.00 41.70           C  
ATOM    665  OE1 GLN A  69      22.680  42.309  -0.632  1.00 45.01           O  
ATOM    666  NE2 GLN A  69      24.131  43.541  -1.836  1.00 53.85           N  
ATOM    667  N   TRP A  70      24.750  45.050   4.204  1.00 35.13           N  
ATOM    668  CA  TRP A  70      24.086  45.640   5.353  1.00 33.79           C  
ATOM    669  C   TRP A  70      23.435  46.982   5.041  1.00 33.20           C  
ATOM    670  O   TRP A  70      23.782  47.653   4.071  1.00 34.47           O  
ATOM    671  CB  TRP A  70      25.042  45.725   6.535  1.00 36.73           C  
ATOM    672  CG  TRP A  70      26.100  46.750   6.453  1.00 40.15           C  
ATOM    673  CD1 TRP A  70      26.077  47.993   7.011  1.00 44.74           C  
ATOM    674  CD2 TRP A  70      27.370  46.605   5.844  1.00 43.15           C  
ATOM    675  NE1 TRP A  70      27.250  48.640   6.764  1.00 47.14           N  
ATOM    676  CE2 TRP A  70      28.067  47.813   6.045  1.00 46.11           C  
ATOM    677  CE3 TRP A  70      27.988  45.571   5.137  1.00 42.95           C  
ATOM    678  CZ2 TRP A  70      29.349  48.021   5.567  1.00 45.82           C  
ATOM    679  CZ3 TRP A  70      29.276  45.773   4.655  1.00 47.52           C  
ATOM    680  CH2 TRP A  70      29.940  46.994   4.875  1.00 47.99           C  
ATOM    681  N   ILE A  71      22.457  47.331   5.855  1.00 33.29           N  
ATOM    682  CA  ILE A  71      21.713  48.567   5.680  1.00 33.19           C  
ATOM    683  C   ILE A  71      21.922  49.494   6.870  1.00 35.67           C  
ATOM    684  O   ILE A  71      22.134  49.050   8.011  1.00 34.18           O  
ATOM    685  CB  ILE A  71      20.201  48.283   5.488  1.00 34.01           C  
ATOM    686  CG1 ILE A  71      19.424  49.560   5.127  1.00 34.19           C  
ATOM    687  CG2 ILE A  71      19.586  47.608   6.730  1.00 33.04           C  
ATOM    688  CD1 ILE A  71      18.072  49.276   4.568  1.00 35.06           C  
ATOM    689  N   ARG A  72      21.868  50.793   6.603  1.00 35.41           N  
ATOM    690  CA  ARG A  72      21.664  51.752   7.664  1.00 36.27           C  
ATOM    691  C   ARG A  72      20.544  52.675   7.238  1.00 33.97           C  
ATOM    692  O   ARG A  72      20.603  53.284   6.194  1.00 35.94           O  
ATOM    693  CB  ARG A  72      22.941  52.497   7.984  1.00 37.01           C  
ATOM    694  CG  ARG A  72      23.918  51.547   8.726  1.00 43.00           C  
ATOM    695  CD  ARG A  72      25.136  52.255   9.171  1.00 45.36           C  
ATOM    696  NE  ARG A  72      24.910  53.207  10.247  1.00 40.47           N  
ATOM    697  CZ  ARG A  72      25.804  54.136  10.572  1.00 42.90           C  
ATOM    698  NH1 ARG A  72      26.923  54.225   9.871  1.00 44.43           N  
ATOM    699  NH2 ARG A  72      25.592  54.980  11.559  1.00 42.63           N  
ATOM    700  N   LEU A  73      19.502  52.735   8.044  1.00 32.71           N  
ATOM    701  CA  LEU A  73      18.314  53.504   7.685  1.00 33.27           C  
ATOM    702  C   LEU A  73      18.086  54.483   8.825  1.00 34.62           C  
ATOM    703  O   LEU A  73      17.779  54.088   9.940  1.00 35.30           O  
ATOM    704  CB  LEU A  73      17.121  52.566   7.491  1.00 33.27           C  
ATOM    705  CG  LEU A  73      15.735  53.165   7.314  1.00 37.98           C  
ATOM    706  CD1 LEU A  73      15.722  54.076   6.114  1.00 42.98           C  
ATOM    707  CD2 LEU A  73      14.678  52.068   7.163  1.00 43.17           C  
ATOM    708  N   THR A  74      18.260  55.762   8.528  1.00 35.32           N  
ATOM    709  CA  THR A  74      18.075  56.837   9.484  1.00 34.69           C  
ATOM    710  C   THR A  74      16.720  57.489   9.222  1.00 36.37           C  
ATOM    711  O   THR A  74      16.381  57.728   8.074  1.00 36.48           O  
ATOM    712  CB  THR A  74      19.181  57.893   9.281  1.00 33.11           C  
ATOM    713  OG1 THR A  74      20.463  57.247   9.232  1.00 37.47           O  
ATOM    714  CG2 THR A  74      19.168  58.924  10.397  1.00 37.05           C  
ATOM    715  N   GLY A  75      15.948  57.791  10.264  1.00 33.57           N  
ATOM    716  CA  GLY A  75      14.693  58.493  10.026  1.00 35.11           C  
ATOM    717  C   GLY A  75      13.919  58.843  11.272  1.00 33.39           C  
ATOM    718  O   GLY A  75      14.449  58.790  12.382  1.00 34.28           O  
ATOM    719  N   GLU A  76      12.654  59.183  11.070  1.00 34.43           N  
ATOM    720  CA  GLU A  76      11.737  59.489  12.160  1.00 34.66           C  
ATOM    721  C   GLU A  76      10.498  58.617  12.068  1.00 35.44           C  
ATOM    722  O   GLU A  76      10.016  58.314  10.978  1.00 34.72           O  
ATOM    723  CB  GLU A  76      11.347  60.955  12.119  1.00 35.69           C  
ATOM    724  CG  GLU A  76      12.478  61.859  12.541  1.00 38.00           C  
ATOM    725  CD  GLU A  76      12.086  63.319  12.765  1.00 41.76           C  
ATOM    726  OE1 GLU A  76      10.876  63.663  12.792  1.00 44.16           O  
ATOM    727  OE2 GLU A  76      13.019  64.128  12.927  1.00 43.97           O  
ATOM    728  N   VAL A  77       9.974  58.230  13.219  1.00 33.35           N  
ATOM    729  CA  VAL A  77       8.786  57.379  13.258  1.00 34.02           C  
ATOM    730  C   VAL A  77       7.640  58.106  13.930  1.00 34.73           C  
ATOM    731  O   VAL A  77       7.857  58.991  14.763  1.00 32.68           O  
ATOM    732  CB  VAL A  77       9.078  56.016  13.935  1.00 36.85           C  
ATOM    733  CG1 VAL A  77      10.122  55.242  13.133  1.00 38.15           C  
ATOM    734  CG2 VAL A  77       9.571  56.210  15.352  1.00 36.97           C  
ATOM    735  N   ALA A  78       6.419  57.730  13.536  1.00 34.18           N  
ATOM    736  CA  ALA A  78       5.195  58.228  14.139  1.00 34.43           C  
ATOM    737  C   ALA A  78       4.321  57.029  14.473  1.00 34.41           C  
ATOM    738  O   ALA A  78       4.199  56.107  13.684  1.00 36.74           O  
ATOM    739  CB  ALA A  78       4.486  59.144  13.187  1.00 35.29           C  
ATOM    740  N   ASN A  79       3.742  57.038  15.662  1.00 33.90           N  
ATOM    741  CA  ASN A  79       2.739  56.069  16.038  1.00 34.00           C  
ATOM    742  C   ASN A  79       1.434  56.285  15.246  1.00 34.79           C  
ATOM    743  O   ASN A  79       0.960  57.388  15.158  1.00 35.17           O  
ATOM    744  CB  ASN A  79       2.454  56.201  17.534  1.00 35.45           C  
ATOM    745  CG  ASN A  79       1.481  55.176  18.017  1.00 35.24           C  
ATOM    746  OD1 ASN A  79       1.687  53.990  17.794  1.00 38.86           O  
ATOM    747  ND2 ASN A  79       0.364  55.628  18.584  1.00 44.87           N  
ATOM    748  N   ASP A  80       0.868  55.220  14.685  1.00 34.16           N  
ATOM    749  CA  ASP A  80      -0.384  55.312  13.895  1.00 34.20           C  
ATOM    750  C   ASP A  80      -1.467  54.594  14.703  1.00 34.14           C  
ATOM    751  O   ASP A  80      -1.432  53.380  14.854  1.00 34.74           O  
ATOM    752  CB  ASP A  80      -0.162  54.657  12.522  1.00 33.68           C  
ATOM    753  CG  ASP A  80      -1.324  54.850  11.569  1.00 34.29           C  
ATOM    754  OD1 ASP A  80      -2.424  55.179  12.017  1.00 32.83           O  
ATOM    755  OD2 ASP A  80      -1.136  54.660  10.352  1.00 35.86           O  
ATOM    756  N   ASP A  81      -2.414  55.354  15.234  1.00 31.70           N  
ATOM    757  CA  ASP A  81      -3.450  54.818  16.130  1.00 34.06           C  
ATOM    758  C   ASP A  81      -4.675  54.236  15.425  1.00 35.73           C  
ATOM    759  O   ASP A  81      -5.631  53.889  16.093  1.00 38.46           O  
ATOM    760  CB  ASP A  81      -3.939  55.924  17.074  1.00 37.88           C  
ATOM    761  CG  ASP A  81      -3.115  56.045  18.339  1.00 45.47           C  
ATOM    762  OD1 ASP A  81      -2.458  55.062  18.751  1.00 48.27           O  
ATOM    763  OD2 ASP A  81      -3.173  57.139  18.957  1.00 56.30           O  
ATOM    764  N   ARG A  82      -4.684  54.202  14.095  1.00 34.74           N  
ATOM    765  CA  ARG A  82      -5.823  53.683  13.345  1.00 35.91           C  
ATOM    766  C   ARG A  82      -5.988  52.185  13.511  1.00 35.59           C  
ATOM    767  O   ARG A  82      -5.069  51.412  13.260  1.00 34.68           O  
ATOM    768  CB  ARG A  82      -5.670  53.978  11.863  1.00 35.95           C  
ATOM    769  CG  ARG A  82      -5.753  55.434  11.511  1.00 37.87           C  
ATOM    770  CD  ARG A  82      -5.645  55.596  10.012  1.00 38.62           C  
ATOM    771  NE  ARG A  82      -4.324  55.233   9.532  1.00 36.75           N  
ATOM    772  CZ  ARG A  82      -3.972  55.172   8.254  1.00 37.77           C  
ATOM    773  NH1 ARG A  82      -4.864  55.437   7.304  1.00 39.39           N  
ATOM    774  NH2 ARG A  82      -2.739  54.850   7.927  1.00 36.79           N  
ATOM    775  N   ARG A  83      -7.195  51.777  13.880  1.00 36.89           N  
ATOM    776  CA  ARG A  83      -7.503  50.375  14.093  1.00 38.03           C  
ATOM    777  C   ARG A  83      -7.236  49.538  12.845  1.00 37.34           C  
ATOM    778  O   ARG A  83      -6.739  48.406  12.950  1.00 37.09           O  
ATOM    779  CB  ARG A  83      -8.959  50.229  14.530  1.00 37.57           C  
ATOM    780  CG  ARG A  83      -9.319  48.886  15.093  1.00 39.38           C  
ATOM    781  CD  ARG A  83     -10.763  48.919  15.621  1.00 44.40           C  
ATOM    782  NE  ARG A  83     -11.141  47.693  16.314  1.00 47.39           N  
ATOM    783  CZ  ARG A  83     -11.478  46.560  15.701  1.00 53.99           C  
ATOM    784  NH1 ARG A  83     -11.486  46.474  14.372  1.00 55.93           N  
ATOM    785  NH2 ARG A  83     -11.817  45.500  16.420  1.00 54.73           N  
ATOM    786  N   GLU A  84      -7.546  50.101  11.674  1.00 37.26           N  
ATOM    787  CA  GLU A  84      -7.389  49.400  10.390  1.00 40.26           C  
ATOM    788  C   GLU A  84      -5.929  49.001  10.118  1.00 38.11           C  
ATOM    789  O   GLU A  84      -5.658  47.983   9.482  1.00 38.23           O  
ATOM    790  CB  GLU A  84      -7.923  50.253   9.212  1.00 39.46           C  
ATOM    791  CG  GLU A  84      -6.912  51.324   8.722  1.00 43.24           C  
ATOM    792  CD  GLU A  84      -7.565  52.499   8.007  1.00 45.77           C  
ATOM    793  OE1 GLU A  84      -8.391  53.171   8.663  1.00 48.73           O  
ATOM    794  OE2 GLU A  84      -7.250  52.760   6.807  1.00 46.91           O  
ATOM    795  N   VAL A  85      -4.986  49.800  10.598  1.00 38.14           N  
ATOM    796  CA  VAL A  85      -3.575  49.486  10.377  1.00 38.88           C  
ATOM    797  C   VAL A  85      -3.149  48.310  11.249  1.00 38.71           C  
ATOM    798  O   VAL A  85      -2.392  47.448  10.799  1.00 35.72           O  
ATOM    799  CB  VAL A  85      -2.635  50.692  10.610  1.00 40.27           C  
ATOM    800  CG1 VAL A  85      -1.260  50.361  10.124  1.00 39.96           C  
ATOM    801  CG2 VAL A  85      -3.139  51.908   9.875  1.00 45.89           C  
ATOM    802  N   LYS A  86      -3.653  48.271  12.483  1.00 37.03           N  
ATOM    803  CA  LYS A  86      -3.405  47.144  13.369  1.00 37.97           C  
ATOM    804  C   LYS A  86      -3.953  45.853  12.790  1.00 37.87           C  
ATOM    805  O   LYS A  86      -3.277  44.819  12.844  1.00 37.47           O  
ATOM    806  CB  LYS A  86      -3.998  47.399  14.755  1.00 38.30           C  
ATOM    807  CG  LYS A  86      -3.302  48.518  15.492  1.00 39.93           C  
ATOM    808  CD  LYS A  86      -4.106  48.968  16.701  1.00 43.25           C  
ATOM    809  CE  LYS A  86      -3.524  50.259  17.257  1.00 48.00           C  
ATOM    810  NZ  LYS A  86      -4.386  50.842  18.292  1.00 44.56           N  
ATOM    811  N   GLU A  87      -5.168  45.909  12.235  1.00 37.50           N  
ATOM    812  CA  GLU A  87      -5.751  44.750  11.564  1.00 39.50           C  
ATOM    813  C   GLU A  87      -4.881  44.260  10.415  1.00 38.74           C  
ATOM    814  O   GLU A  87      -4.655  43.060  10.269  1.00 38.61           O  
ATOM    815  CB  GLU A  87      -7.159  45.068  11.040  1.00 41.05           C  
ATOM    816  CG  GLU A  87      -8.147  45.276  12.160  1.00 41.14           C  
ATOM    817  CD  GLU A  87      -9.542  45.568  11.687  1.00 46.74           C  
ATOM    818  OE1 GLU A  87      -9.709  46.503  10.870  1.00 57.44           O  
ATOM    819  OE2 GLU A  87     -10.469  44.859  12.141  1.00 51.84           O  
ATOM    820  N   LEU A  88      -4.417  45.197   9.597  1.00 38.33           N  
ATOM    821  CA  LEU A  88      -3.583  44.868   8.455  1.00 41.93           C  
ATOM    822  C   LEU A  88      -2.253  44.263   8.894  1.00 39.12           C  
ATOM    823  O   LEU A  88      -1.754  43.335   8.256  1.00 41.80           O  
ATOM    824  CB  LEU A  88      -3.327  46.101   7.587  1.00 41.90           C  
ATOM    825  CG  LEU A  88      -2.329  45.833   6.451  1.00 50.30           C  
ATOM    826  CD1 LEU A  88      -2.924  44.906   5.395  1.00 51.28           C  
ATOM    827  CD2 LEU A  88      -1.890  47.124   5.835  1.00 49.33           C  
ATOM    828  N   ALA A  89      -1.669  44.796   9.960  1.00 36.92           N  
ATOM    829  CA  ALA A  89      -0.402  44.279  10.473  1.00 36.70           C  
ATOM    830  C   ALA A  89      -0.516  42.801  10.810  1.00 36.25           C  
ATOM    831  O   ALA A  89       0.388  42.016  10.510  1.00 36.84           O  
ATOM    832  CB  ALA A  89       0.041  45.048  11.696  1.00 37.07           C  
ATOM    833  N   LEU A  90      -1.625  42.436  11.458  1.00 36.52           N  
ATOM    834  CA  LEU A  90      -1.827  41.066  11.919  1.00 38.84           C  
ATOM    835  C   LEU A  90      -2.101  40.106  10.757  1.00 39.63           C  
ATOM    836  O   LEU A  90      -1.781  38.927  10.851  1.00 42.39           O  
ATOM    837  CB  LEU A  90      -2.935  41.012  12.985  1.00 39.58           C  
ATOM    838  CG  LEU A  90      -2.607  41.837  14.237  1.00 38.43           C  
ATOM    839  CD1 LEU A  90      -3.804  41.981  15.142  1.00 43.12           C  
ATOM    840  CD2 LEU A  90      -1.420  41.244  15.022  1.00 40.52           C  
ATOM    841  N   GLU A  91      -2.669  40.616   9.669  1.00 39.78           N  
ATOM    842  CA  GLU A  91      -2.792  39.853   8.433  1.00 41.59           C  
ATOM    843  C   GLU A  91      -1.483  39.781   7.645  1.00 40.58           C  
ATOM    844  O   GLU A  91      -1.175  38.738   7.084  1.00 42.88           O  
ATOM    845  CB  GLU A  91      -3.919  40.416   7.564  1.00 43.65           C  
ATOM    846  CG  GLU A  91      -5.271  40.345   8.248  1.00 50.53           C  
ATOM    847  CD  GLU A  91      -5.594  38.949   8.825  1.00 58.95           C  
ATOM    848  OE1 GLU A  91      -5.636  37.972   8.037  1.00 59.92           O  
ATOM    849  OE2 GLU A  91      -5.814  38.837  10.060  1.00 60.39           O  
ATOM    850  N   ALA A  92      -0.723  40.869   7.597  1.00 39.52           N  
ATOM    851  CA  ALA A  92       0.548  40.892   6.864  1.00 40.37           C  
ATOM    852  C   ALA A  92       1.620  40.029   7.531  1.00 39.58           C  
ATOM    853  O   ALA A  92       2.398  39.379   6.842  1.00 41.47           O  
ATOM    854  CB  ALA A  92       1.059  42.311   6.713  1.00 40.90           C  
ATOM    855  N   VAL A  93       1.669  40.055   8.862  1.00 39.12           N  
ATOM    856  CA  VAL A  93       2.636  39.293   9.666  1.00 37.75           C  
ATOM    857  C   VAL A  93       1.845  38.472  10.704  1.00 37.88           C  
ATOM    858  O   VAL A  93       1.795  38.824  11.889  1.00 37.75           O  
ATOM    859  CB  VAL A  93       3.648  40.236  10.380  1.00 38.40           C  
ATOM    860  CG1 VAL A  93       4.800  39.452  10.990  1.00 40.62           C  
ATOM    861  CG2 VAL A  93       4.212  41.272   9.418  1.00 38.95           C  
ATOM    862  N   PRO A  94       1.196  37.380  10.259  1.00 37.82           N  
ATOM    863  CA  PRO A  94       0.258  36.674  11.133  1.00 37.96           C  
ATOM    864  C   PRO A  94       0.906  36.051  12.364  1.00 37.95           C  
ATOM    865  O   PRO A  94       0.237  35.868  13.362  1.00 40.46           O  
ATOM    866  CB  PRO A  94      -0.400  35.631  10.210  1.00 39.26           C  
ATOM    867  CG  PRO A  94       0.463  35.512   9.029  1.00 39.54           C  
ATOM    868  CD  PRO A  94       1.258  36.791   8.911  1.00 39.03           C  
ATOM    869  N   SER A  95       2.212  35.819  12.338  1.00 36.54           N  
ATOM    870  CA  SER A  95       2.913  35.386  13.545  1.00 36.19           C  
ATOM    871  C   SER A  95       2.733  36.371  14.728  1.00 36.58           C  
ATOM    872  O   SER A  95       2.828  35.985  15.892  1.00 37.12           O  
ATOM    873  CB  SER A  95       4.389  35.120  13.242  1.00 37.11           C  
ATOM    874  OG  SER A  95       5.052  36.244  12.712  1.00 43.63           O  
ATOM    875  N   LEU A  96       2.451  37.634  14.431  1.00 34.10           N  
ATOM    876  CA  LEU A  96       2.175  38.634  15.477  1.00 35.96           C  
ATOM    877  C   LEU A  96       0.977  38.267  16.335  1.00 34.15           C  
ATOM    878  O   LEU A  96       0.884  38.680  17.486  1.00 33.82           O  
ATOM    879  CB  LEU A  96       1.928  40.010  14.852  1.00 37.93           C  
ATOM    880  CG  LEU A  96       3.200  40.676  14.287  1.00 38.85           C  
ATOM    881  CD1 LEU A  96       2.809  41.974  13.589  1.00 38.42           C  
ATOM    882  CD2 LEU A  96       4.256  40.926  15.339  1.00 41.16           C  
ATOM    883  N   LYS A  97       0.049  37.506  15.768  1.00 34.08           N  
ATOM    884  CA  LYS A  97      -1.137  37.098  16.509  1.00 36.39           C  
ATOM    885  C   LYS A  97      -0.789  36.234  17.708  1.00 34.73           C  
ATOM    886  O   LYS A  97      -1.608  36.107  18.613  1.00 34.36           O  
ATOM    887  CB  LYS A  97      -2.121  36.374  15.605  1.00 37.63           C  
ATOM    888  CG  LYS A  97      -2.728  37.285  14.534  1.00 40.90           C  
ATOM    889  CD  LYS A  97      -3.927  36.637  13.868  1.00 40.40           C  
ATOM    890  CE  LYS A  97      -4.319  37.348  12.573  1.00 43.68           C  
ATOM    891  NZ  LYS A  97      -4.992  36.414  11.622  1.00 50.46           N  
ATOM    892  N   ASN A  98       0.417  35.652  17.727  1.00 34.74           N  
ATOM    893  CA  ASN A  98       0.871  34.886  18.890  1.00 35.65           C  
ATOM    894  C   ASN A  98       1.043  35.756  20.123  1.00 38.82           C  
ATOM    895  O   ASN A  98       0.991  35.239  21.238  1.00 40.60           O  
ATOM    896  CB  ASN A  98       2.157  34.120  18.602  1.00 35.28           C  
ATOM    897  CG  ASN A  98       1.968  33.015  17.564  1.00 38.02           C  
ATOM    898  OD1 ASN A  98       0.967  32.332  17.561  1.00 42.93           O  
ATOM    899  ND2 ASN A  98       2.928  32.862  16.680  1.00 42.94           N  
HETATM  900  N   MSE A  99       1.244  37.065  19.935  1.00 38.48           N  
HETATM  901  CA  MSE A  99       1.371  38.006  21.063  1.00 39.31           C  
HETATM  902  C   MSE A  99       0.327  39.126  21.124  1.00 38.21           C  
HETATM  903  O   MSE A  99       0.034  39.638  22.207  1.00 40.28           O  
HETATM  904  CB  MSE A  99       2.750  38.654  21.021  1.00 39.78           C  
HETATM  905  CG  MSE A  99       3.851  37.742  21.472  1.00 46.06           C  
HETATM  906 SE   MSE A  99       5.541  38.657  21.308  0.70 50.63          SE  
HETATM  907  CE  MSE A  99       5.029  40.281  21.857  1.00 51.66           C  
ATOM    908  N   TYR A 100      -0.228  39.517  19.974  1.00 35.23           N  
ATOM    909  CA  TYR A 100      -1.034  40.720  19.881  1.00 36.08           C  
ATOM    910  C   TYR A 100      -2.392  40.435  19.280  1.00 36.01           C  
ATOM    911  O   TYR A 100      -2.551  39.468  18.553  1.00 33.86           O  
ATOM    912  CB  TYR A 100      -0.317  41.764  19.030  1.00 37.58           C  
ATOM    913  CG  TYR A 100       0.989  42.207  19.660  1.00 34.01           C  
ATOM    914  CD1 TYR A 100       0.992  42.842  20.894  1.00 35.60           C  
ATOM    915  CD2 TYR A 100       2.210  41.951  19.043  1.00 37.82           C  
ATOM    916  CE1 TYR A 100       2.167  43.232  21.497  1.00 36.36           C  
ATOM    917  CE2 TYR A 100       3.393  42.342  19.633  1.00 39.30           C  
ATOM    918  CZ  TYR A 100       3.366  42.987  20.861  1.00 38.79           C  
ATOM    919  OH  TYR A 100       4.528  43.362  21.476  1.00 42.38           O  
ATOM    920  N   SER A 101      -3.361  41.287  19.596  1.00 36.22           N  
ATOM    921  CA  SER A 101      -4.658  41.274  18.951  1.00 37.98           C  
ATOM    922  C   SER A 101      -5.142  42.716  18.834  1.00 37.27           C  
ATOM    923  O   SER A 101      -4.697  43.578  19.577  1.00 34.07           O  
ATOM    924  CB  SER A 101      -5.656  40.399  19.727  1.00 39.75           C  
ATOM    925  OG  SER A 101      -5.820  40.844  21.057  1.00 41.13           O  
ATOM    926  N   VAL A 102      -6.055  42.972  17.907  1.00 38.02           N  
ATOM    927  CA  VAL A 102      -6.460  44.348  17.551  0.50 38.48           C  
ATOM    929  C   VAL A 102      -6.898  45.181  18.754  1.00 39.18           C  
ATOM    930  O   VAL A 102      -6.630  46.376  18.815  1.00 42.11           O  
ATOM    931  CB  VAL A 102      -7.650  44.414  16.539  0.50 38.01           C  
ATOM    933  CG1 VAL A 102      -7.735  45.813  15.912  0.50 33.79           C  
ATOM    935  CG2 VAL A 102      -7.546  43.353  15.443  0.50 41.29           C  
ATOM    937  N   ASP A 103      -7.605  44.559  19.690  1.00 40.13           N  
ATOM    938  CA  ASP A 103      -8.199  45.309  20.796  1.00 40.84           C  
ATOM    939  C   ASP A 103      -7.525  45.005  22.114  1.00 40.64           C  
ATOM    940  O   ASP A 103      -8.142  45.143  23.178  1.00 41.09           O  
ATOM    941  CB  ASP A 103      -9.692  44.999  20.905  1.00 42.04           C  
ATOM    942  CG  ASP A 103     -10.484  45.545  19.742  1.00 46.71           C  
ATOM    943  OD1 ASP A 103     -10.232  46.696  19.321  1.00 54.70           O  
ATOM    944  OD2 ASP A 103     -11.372  44.822  19.249  1.00 49.14           O  
ATOM    945  N   ASP A 104      -6.260  44.621  22.062  1.00 38.03           N  
ATOM    946  CA  ASP A 104      -5.565  44.258  23.288  1.00 37.81           C  
ATOM    947  C   ASP A 104      -5.085  45.456  24.102  1.00 37.15           C  
ATOM    948  O   ASP A 104      -4.620  45.275  25.218  1.00 36.85           O  
ATOM    949  CB  ASP A 104      -4.429  43.266  23.026  1.00 37.53           C  
ATOM    950  CG  ASP A 104      -3.267  43.859  22.233  1.00 38.26           C  
ATOM    951  OD1 ASP A 104      -3.221  45.094  21.998  1.00 32.86           O  
ATOM    952  OD2 ASP A 104      -2.402  43.052  21.844  1.00 36.36           O  
ATOM    953  N   GLY A 105      -5.204  46.665  23.558  1.00 36.77           N  
ATOM    954  CA  GLY A 105      -4.816  47.875  24.279  1.00 37.92           C  
ATOM    955  C   GLY A 105      -3.308  48.114  24.396  1.00 37.11           C  
ATOM    956  O   GLY A 105      -2.875  49.125  24.951  1.00 37.93           O  
ATOM    957  N   ILE A 106      -2.492  47.200  23.888  1.00 37.56           N  
ATOM    958  CA  ILE A 106      -1.026  47.377  23.944  1.00 36.98           C  
ATOM    959  C   ILE A 106      -0.335  47.421  22.580  1.00 37.29           C  
ATOM    960  O   ILE A 106       0.711  48.062  22.440  1.00 37.63           O  
ATOM    961  CB  ILE A 106      -0.347  46.325  24.856  1.00 36.83           C  
ATOM    962  CG1 ILE A 106      -0.581  44.896  24.359  1.00 39.19           C  
ATOM    963  CG2 ILE A 106      -0.864  46.465  26.301  1.00 39.18           C  
ATOM    964  CD1 ILE A 106       0.286  43.887  25.050  1.00 40.03           C  
ATOM    965  N   PHE A 107      -0.914  46.746  21.589  1.00 35.75           N  
ATOM    966  CA  PHE A 107      -0.294  46.619  20.247  1.00 34.00           C  
ATOM    967  C   PHE A 107      -0.128  48.000  19.601  1.00 33.13           C  
ATOM    968  O   PHE A 107      -1.065  48.791  19.597  1.00 33.55           O  
ATOM    969  CB  PHE A 107      -1.194  45.714  19.372  1.00 33.44           C  
ATOM    970  CG  PHE A 107      -0.612  45.362  18.019  1.00 35.11           C  
ATOM    971  CD1 PHE A 107       0.715  44.963  17.890  1.00 35.41           C  
ATOM    972  CD2 PHE A 107      -1.420  45.363  16.877  1.00 39.39           C  
ATOM    973  CE1 PHE A 107       1.247  44.615  16.642  1.00 33.93           C  
ATOM    974  CE2 PHE A 107      -0.891  45.027  15.630  1.00 37.13           C  
ATOM    975  CZ  PHE A 107       0.446  44.651  15.518  1.00 38.08           C  
ATOM    976  N   ALA A 108       1.053  48.273  19.051  1.00 34.33           N  
ATOM    977  CA  ALA A 108       1.358  49.556  18.430  1.00 33.88           C  
ATOM    978  C   ALA A 108       2.006  49.302  17.078  1.00 34.42           C  
ATOM    979  O   ALA A 108       2.850  48.387  16.910  1.00 32.79           O  
ATOM    980  CB  ALA A 108       2.299  50.402  19.330  1.00 35.61           C  
ATOM    981  N   VAL A 109       1.622  50.117  16.106  1.00 34.57           N  
ATOM    982  CA  VAL A 109       2.275  50.110  14.802  1.00 36.54           C  
ATOM    983  C   VAL A 109       2.775  51.528  14.536  1.00 35.34           C  
ATOM    984  O   VAL A 109       2.055  52.504  14.783  1.00 36.54           O  
ATOM    985  CB  VAL A 109       1.363  49.589  13.673  1.00 36.81           C  
ATOM    986  CG1 VAL A 109       0.994  48.141  13.922  1.00 39.54           C  
ATOM    987  CG2 VAL A 109       0.111  50.436  13.528  1.00 40.05           C  
ATOM    988  N   LEU A 110       4.018  51.634  14.077  1.00 35.22           N  
ATOM    989  CA  LEU A 110       4.643  52.926  13.816  1.00 33.79           C  
ATOM    990  C   LEU A 110       5.239  52.958  12.424  1.00 34.03           C  
ATOM    991  O   LEU A 110       5.741  51.947  11.944  1.00 37.16           O  
ATOM    992  CB  LEU A 110       5.750  53.197  14.824  1.00 32.97           C  
ATOM    993  CG  LEU A 110       5.365  53.051  16.294  1.00 35.58           C  
ATOM    994  CD1 LEU A 110       5.762  51.663  16.801  1.00 35.43           C  
ATOM    995  CD2 LEU A 110       6.053  54.137  17.077  1.00 39.12           C  
ATOM    996  N   TYR A 111       5.198  54.113  11.769  1.00 33.20           N  
ATOM    997  CA  TYR A 111       5.752  54.206  10.416  1.00 33.31           C  
ATOM    998  C   TYR A 111       6.804  55.291  10.302  1.00 33.19           C  
ATOM    999  O   TYR A 111       6.841  56.236  11.090  1.00 33.07           O  
ATOM   1000  CB  TYR A 111       4.665  54.421   9.354  1.00 35.24           C  
ATOM   1001  CG  TYR A 111       4.043  55.787   9.404  1.00 33.64           C  
ATOM   1002  CD1 TYR A 111       3.091  56.092  10.348  1.00 31.16           C  
ATOM   1003  CD2 TYR A 111       4.453  56.796   8.536  1.00 36.28           C  
ATOM   1004  CE1 TYR A 111       2.519  57.364  10.421  1.00 33.61           C  
ATOM   1005  CE2 TYR A 111       3.906  58.063   8.600  1.00 30.81           C  
ATOM   1006  CZ  TYR A 111       2.938  58.343   9.555  1.00 32.12           C  
ATOM   1007  OH  TYR A 111       2.374  59.587   9.641  1.00 36.59           O  
ATOM   1008  N   PHE A 112       7.641  55.152   9.280  1.00 34.26           N  
ATOM   1009  CA  PHE A 112       8.665  56.152   8.997  1.00 34.55           C  
ATOM   1010  C   PHE A 112       8.038  57.317   8.263  1.00 34.25           C  
ATOM   1011  O   PHE A 112       7.525  57.154   7.141  1.00 33.40           O  
ATOM   1012  CB  PHE A 112       9.790  55.555   8.159  1.00 34.77           C  
ATOM   1013  CG  PHE A 112      10.814  54.845   8.973  1.00 32.90           C  
ATOM   1014  CD1 PHE A 112      10.643  53.519   9.326  1.00 37.10           C  
ATOM   1015  CD2 PHE A 112      11.936  55.517   9.411  1.00 35.07           C  
ATOM   1016  CE1 PHE A 112      11.595  52.862  10.133  1.00 36.92           C  
ATOM   1017  CE2 PHE A 112      12.878  54.883  10.193  1.00 36.26           C  
ATOM   1018  CZ  PHE A 112      12.722  53.548  10.544  1.00 38.35           C  
ATOM   1019  N   THR A 113       8.060  58.484   8.900  1.00 34.28           N  
ATOM   1020  CA  THR A 113       7.507  59.698   8.281  1.00 36.27           C  
ATOM   1021  C   THR A 113       8.474  60.244   7.239  1.00 36.49           C  
ATOM   1022  O   THR A 113       8.074  60.932   6.278  1.00 34.88           O  
ATOM   1023  CB  THR A 113       7.274  60.797   9.323  1.00 35.71           C  
ATOM   1024  OG1 THR A 113       8.518  61.127   9.956  1.00 35.98           O  
ATOM   1025  CG2 THR A 113       6.253  60.343  10.354  1.00 37.07           C  
ATOM   1026  N   LYS A 114       9.747  59.976   7.491  1.00 35.35           N  
ATOM   1027  CA  LYS A 114      10.826  60.264   6.566  1.00 36.65           C  
ATOM   1028  C   LYS A 114      12.054  59.431   6.917  1.00 35.77           C  
ATOM   1029  O   LYS A 114      12.184  58.927   8.022  1.00 35.44           O  
ATOM   1030  CB  LYS A 114      11.200  61.738   6.603  1.00 36.34           C  
ATOM   1031  CG  LYS A 114      11.608  62.249   7.964  1.00 39.47           C  
ATOM   1032  CD  LYS A 114      11.669  63.772   7.947  1.00 43.75           C  
ATOM   1033  CE  LYS A 114      12.200  64.319   9.262  1.00 53.11           C  
ATOM   1034  NZ  LYS A 114      12.281  65.812   9.273  1.00 51.56           N  
ATOM   1035  N   GLY A 115      12.977  59.320   5.980  1.00 34.12           N  
ATOM   1036  CA  GLY A 115      14.184  58.578   6.256  1.00 35.63           C  
ATOM   1037  C   GLY A 115      15.099  58.555   5.063  1.00 36.33           C  
ATOM   1038  O   GLY A 115      14.674  58.867   3.942  1.00 37.07           O  
ATOM   1039  N   GLU A 116      16.361  58.239   5.335  1.00 37.58           N  
ATOM   1040  CA  GLU A 116      17.379  58.069   4.299  1.00 38.57           C  
ATOM   1041  C   GLU A 116      18.207  56.862   4.655  1.00 39.06           C  
ATOM   1042  O   GLU A 116      18.554  56.649   5.824  1.00 35.30           O  
ATOM   1043  CB  GLU A 116      18.260  59.303   4.164  1.00 43.35           C  
ATOM   1044  CG  GLU A 116      19.070  59.649   5.379  1.00 49.46           C  
ATOM   1045  N   GLY A 117      18.512  56.076   3.633  1.00 38.10           N  
ATOM   1046  CA  GLY A 117      19.198  54.825   3.835  1.00 38.51           C  
ATOM   1047  C   GLY A 117      20.348  54.608   2.880  1.00 36.58           C  
ATOM   1048  O   GLY A 117      20.448  55.237   1.823  1.00 35.92           O  
ATOM   1049  N   THR A 118      21.201  53.686   3.282  1.00 35.89           N  
ATOM   1050  CA  THR A 118      22.307  53.217   2.476  1.00 35.44           C  
ATOM   1051  C   THR A 118      22.373  51.723   2.642  1.00 34.56           C  
ATOM   1052  O   THR A 118      22.259  51.230   3.774  1.00 34.35           O  
ATOM   1053  CB  THR A 118      23.630  53.843   2.939  1.00 39.78           C  
ATOM   1054  OG1 THR A 118      23.508  55.266   2.907  1.00 45.14           O  
ATOM   1055  CG2 THR A 118      24.752  53.451   2.028  1.00 45.15           C  
ATOM   1056  N   ILE A 119      22.517  51.008   1.530  1.00 33.10           N  
ATOM   1057  CA  ILE A 119      22.804  49.578   1.550  1.00 36.09           C  
ATOM   1058  C   ILE A 119      24.225  49.403   1.063  1.00 38.11           C  
ATOM   1059  O   ILE A 119      24.592  49.872  -0.034  1.00 39.49           O  
ATOM   1060  CB  ILE A 119      21.838  48.778   0.701  1.00 36.58           C  
ATOM   1061  CG1 ILE A 119      20.443  48.864   1.311  1.00 36.62           C  
ATOM   1062  CG2 ILE A 119      22.308  47.325   0.582  1.00 37.33           C  
ATOM   1063  CD1 ILE A 119      19.324  48.422   0.342  1.00 39.74           C  
ATOM   1064  N   CYS A 120      25.019  48.716   1.882  1.00 38.99           N  
ATOM   1065  CA  CYS A 120      26.448  48.590   1.643  1.00 40.16           C  
ATOM   1066  C   CYS A 120      26.772  47.154   1.326  1.00 42.18           C  
ATOM   1067  O   CYS A 120      26.206  46.227   1.903  1.00 39.01           O  
ATOM   1068  CB  CYS A 120      27.258  49.013   2.869  1.00 42.50           C  
ATOM   1069  SG  CYS A 120      26.986  50.733   3.376  1.00 52.18           S  
ATOM   1070  N   SER A 121      27.678  46.989   0.389  1.00 44.17           N  
ATOM   1071  CA  SER A 121      28.117  45.672  -0.042  1.00 49.57           C  
ATOM   1072  C   SER A 121      29.617  45.649   0.122  1.00 52.80           C  
ATOM   1073  O   SER A 121      30.290  46.689   0.089  1.00 50.94           O  
ATOM   1074  CB  SER A 121      27.742  45.426  -1.513  1.00 50.94           C  
ATOM   1075  OG  SER A 121      26.368  45.707  -1.786  1.00 58.32           O  
ATOM   1076  N   PHE A 122      30.151  44.453   0.298  1.00 54.96           N  
ATOM   1077  CA  PHE A 122      31.579  44.294   0.328  1.00 54.11           C  
ATOM   1078  C   PHE A 122      32.171  44.842  -0.981  1.00 54.01           C  
ATOM   1079  O   PHE A 122      33.049  45.702  -0.964  1.00 51.10           O  
ATOM   1080  CB  PHE A 122      31.952  42.820   0.477  1.00 53.95           C  
ATOM   1081  CG  PHE A 122      33.384  42.562   0.207  1.00 52.50           C  
ATOM   1082  CD1 PHE A 122      34.336  43.037   1.084  1.00 56.86           C  
ATOM   1083  CD2 PHE A 122      33.794  41.885  -0.936  1.00 52.62           C  
ATOM   1084  CE1 PHE A 122      35.653  42.827   0.851  1.00 55.41           C  
ATOM   1085  CE2 PHE A 122      35.108  41.676  -1.172  1.00 47.85           C  
ATOM   1086  CZ  PHE A 122      36.050  42.147  -0.282  1.00 52.61           C  
ATOM   1087  N   LYS A 123      31.687  44.321  -2.104  1.00 56.25           N  
ATOM   1088  CA  LYS A 123      32.125  44.774  -3.419  1.00 59.58           C  
ATOM   1089  C   LYS A 123      30.997  45.591  -4.034  1.00 63.10           C  
ATOM   1090  O   LYS A 123      29.847  45.134  -4.072  1.00 65.78           O  
ATOM   1091  N   GLY A 124      31.319  46.802  -4.488  1.00 63.29           N  
ATOM   1092  CA  GLY A 124      30.355  47.652  -5.207  1.00 61.79           C  
ATOM   1093  C   GLY A 124      30.010  48.940  -4.478  1.00 59.06           C  
ATOM   1094  O   GLY A 124      30.229  49.058  -3.269  1.00 58.97           O  
ATOM   1095  N   GLU A 125      29.465  49.902  -5.226  1.00 56.26           N  
ATOM   1096  CA  GLU A 125      29.103  51.213  -4.681  1.00 52.91           C  
ATOM   1097  C   GLU A 125      27.918  51.080  -3.737  1.00 48.87           C  
ATOM   1098  O   GLU A 125      27.072  50.205  -3.901  1.00 48.30           O  
ATOM   1099  CB  GLU A 125      28.753  52.205  -5.796  1.00 53.02           C  
ATOM   1100  N   ASN A 126      27.876  51.953  -2.743  1.00 46.87           N  
ATOM   1101  CA  ASN A 126      26.735  52.034  -1.858  1.00 45.86           C  
ATOM   1102  C   ASN A 126      25.499  52.351  -2.663  1.00 43.61           C  
ATOM   1103  O   ASN A 126      25.561  53.082  -3.643  1.00 43.03           O  
ATOM   1104  CB  ASN A 126      26.923  53.145  -0.838  1.00 46.74           C  
ATOM   1105  CG  ASN A 126      27.982  52.829   0.179  1.00 52.35           C  
ATOM   1106  OD1 ASN A 126      28.513  51.713   0.232  1.00 53.40           O  
ATOM   1107  ND2 ASN A 126      28.298  53.817   1.010  1.00 57.10           N  
ATOM   1108  N   GLU A 127      24.383  51.785  -2.242  1.00 41.55           N  
ATOM   1109  CA  GLU A 127      23.082  52.110  -2.776  1.00 42.29           C  
ATOM   1110  C   GLU A 127      22.412  53.037  -1.788  1.00 41.02           C  
ATOM   1111  O   GLU A 127      22.285  52.683  -0.627  1.00 40.88           O  
ATOM   1112  CB  GLU A 127      22.287  50.825  -2.892  1.00 43.21           C  
ATOM   1113  CG  GLU A 127      20.911  50.982  -3.431  1.00 46.78           C  
ATOM   1114  CD  GLU A 127      20.149  49.680  -3.433  1.00 48.50           C  
ATOM   1115  OE1 GLU A 127      20.761  48.612  -3.173  1.00 53.54           O  
ATOM   1116  OE2 GLU A 127      18.928  49.742  -3.695  1.00 55.66           O  
ATOM   1117  N   THR A 128      22.005  54.224  -2.215  1.00 38.68           N  
ATOM   1118  CA  THR A 128      21.350  55.149  -1.301  1.00 40.40           C  
ATOM   1119  C   THR A 128      19.920  55.351  -1.726  1.00 41.03           C  
ATOM   1120  O   THR A 128      19.598  55.262  -2.907  1.00 41.39           O  
ATOM   1121  CB  THR A 128      22.076  56.497  -1.179  1.00 42.70           C  
ATOM   1122  OG1 THR A 128      22.200  57.098  -2.460  1.00 50.65           O  
ATOM   1123  CG2 THR A 128      23.469  56.296  -0.590  1.00 47.41           C  
ATOM   1124  N   PHE A 129      19.062  55.625  -0.754  1.00 38.89           N  
ATOM   1125  CA  PHE A 129      17.667  55.815  -1.032  1.00 39.68           C  
ATOM   1126  C   PHE A 129      17.050  56.704   0.050  1.00 38.87           C  
ATOM   1127  O   PHE A 129      17.636  56.904   1.112  1.00 35.53           O  
ATOM   1128  CB  PHE A 129      16.967  54.453  -1.107  1.00 43.26           C  
ATOM   1129  CG  PHE A 129      16.983  53.702   0.182  1.00 43.72           C  
ATOM   1130  CD1 PHE A 129      17.914  52.694   0.401  1.00 49.82           C  
ATOM   1131  CD2 PHE A 129      16.036  53.967   1.167  1.00 53.21           C  
ATOM   1132  CE1 PHE A 129      17.922  51.976   1.574  1.00 49.68           C  
ATOM   1133  CE2 PHE A 129      16.044  53.264   2.335  1.00 50.83           C  
ATOM   1134  CZ  PHE A 129      16.989  52.262   2.545  1.00 54.22           C  
ATOM   1135  N   SER A 130      15.865  57.218  -0.248  1.00 37.80           N  
ATOM   1136  CA  SER A 130      15.096  58.084   0.640  1.00 40.76           C  
ATOM   1137  C   SER A 130      13.724  57.470   0.779  1.00 41.63           C  
ATOM   1138  O   SER A 130      13.201  56.914  -0.190  1.00 40.10           O  
ATOM   1139  CB  SER A 130      14.864  59.455  -0.027  1.00 41.18           C  
ATOM   1140  OG  SER A 130      16.076  60.091  -0.334  1.00 55.62           O  
ATOM   1141  N   LEU A 131      13.087  57.664   1.924  1.00 42.92           N  
ATOM   1142  CA  LEU A 131      11.668  57.401   2.017  1.00 47.18           C  
ATOM   1143  C   LEU A 131      10.891  58.517   2.739  1.00 50.20           C  
ATOM   1144  O   LEU A 131      11.456  59.564   3.129  1.00 50.55           O  
ATOM   1145  CB  LEU A 131      11.416  56.022   2.627  1.00 49.47           C  
ATOM   1146  CG  LEU A 131      12.214  55.574   3.846  1.00 48.51           C  
ATOM   1147  CD1 LEU A 131      11.647  56.200   5.094  1.00 56.60           C  
ATOM   1148  CD2 LEU A 131      12.144  54.079   3.955  1.00 48.73           C  
ATOM   1149  OXT LEU A 131       9.663  58.390   2.900  1.00 51.39           O  
TER    1150      LEU A 131                                                      
END
MOLECULE T0506_25_173.pdb
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
END
