
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 (  852),  selected  110 , name 1f37_B
# Molecule2: number of CA atoms   81 (  610),  selected   81 , name T0506_174_254.pdb
# PARAMETERS: 1f37_B.T0506_174_254.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_B      -       -           -
LGA    E     2_B      -       -           -
LGA    F     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    H     5_B      -       -           -
LGA    V     6_B      -       -           -
LGA    F     7_B      -       -           -
LGA    V     8_B      -       -           -
LGA    C     9_B      L     174          4.080
LGA    V    10_B      -       -           -
LGA    Q    11_B      -       -           -
LGA    D    12_B      -       -           -
LGA    R    13_B      -       -           -
LGA    P    14_B      -       -           -
LGA    P    15_B      -       -           -
LGA    G    16_B      -       -           -
LGA    H    17_B      -       -           -
LGA    P    18_B      -       -           -
LGA    Q    19_B      -       -           -
LGA    G    20_B      S     175          4.894
LGA    S    21_B      G     176          5.074
LGA    C    22_B      A     177          3.015
LGA    A    23_B      E     178          2.861
LGA    Q    24_B      -       -           -
LGA    R    25_B      -       -           -
LGA    G    26_B      E     179          1.780
LGA    S    27_B      L     180          2.890
LGA    R    28_B      M     181          2.013
LGA    E    29_B      A     182          2.661
LGA    V    30_B      A     183          3.476
LGA    F    31_B      A     184          1.143
LGA    Q    32_B      E     185          2.623
LGA    A    33_B      S     186          4.483
LGA    F    34_B      E     187          2.748
LGA    M    35_B      A     188          0.628
LGA    E    36_B      T     189          2.874
LGA    K    37_B      R     190          3.105
LGA    I    38_B      L     191          1.236
LGA    Q    39_B      N     192          1.629
LGA    T    40_B      A     193          2.710
LGA    D    41_B      I     194          1.344
LGA    P    42_B      K     195          0.728
LGA    Q    43_B      G     196          1.674
LGA    L    44_B      E     197          0.665
LGA    F    45_B      A     198          2.921
LGA    M    46_B      S     199          2.908
LGA    T    47_B      R     200          3.650
LGA    T    48_B      L     201          3.598
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    V    49_B      I     214          2.752
LGA    I    50_B      T     215          4.249
LGA    T    51_B      S     216          1.777
LGA    P    52_B      I     217          5.107
LGA    T    53_B      D     218           #
LGA    G    54_B      -       -           -
LGA    C    55_B      -       -           -
LGA    M    56_B      -       -           -
LGA    N    57_B      -       -           -
LGA    A    58_B      -       -           -
LGA    C    59_B      -       -           -
LGA    M    60_B      -       -           -
LGA    M    61_B      -       -           -
LGA    G    62_B      -       -           -
LGA    P    63_B      -       -           -
LGA    V    64_B      P     219          2.492
LGA    V    65_B      D     220          2.920
LGA    V    66_B      G     221          2.856
LGA    V    67_B      I     222          5.549
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    Y    68_B      L     233          2.652
LGA    P    69_B      W     234          5.273
LGA    D    70_B      -       -           -
LGA    G    71_B      F     235          5.699
LGA    V    72_B      A     236          2.285
LGA    W    73_B      E     237          2.915
LGA    Y    74_B      R     238          1.937
LGA    G    75_B      V     239          3.385
LGA    Q    76_B      E     240          3.100
LGA    V    77_B      -       -           -
LGA    K    78_B      T     241          1.717
LGA    P    79_B      L     242          1.851
LGA    E    80_B      K     243          3.210
LGA    D    81_B      Q     244          3.508
LGA    V    82_B      F     245          3.188
LGA    D    83_B      E     246          2.924
LGA    E    84_B      K     247          3.022
LGA    I    85_B      A     248          2.654
LGA    V    86_B      L     249          2.385
LGA    E    87_B      A     250          2.605
LGA    K    88_B      Q     251          2.498
LGA    H    89_B      L     252          1.404
LGA    L    90_B      -       -           -
LGA    K    91_B      L     253          1.374
LGA    G    92_B      K     254          1.019
LGA    G    93_B      -       -           -
LGA    E    94_B      -       -           -
LGA    P    95_B      -       -           -
LGA    V    96_B      -       -           -
LGA    E    97_B      -       -           -
LGA    R    98_B      -       -           -
LGA    L    99_B      -       -           -
LGA    V   100_B      -       -           -
LGA    I   101_B      -       -           -
LGA    S   102_B      -       -           -
LGA    K   103_B      -       -           -
LGA    G   104_B      -       -           -
LGA    K   105_B      -       -           -
LGA    P   106_B      -       -           -
LGA    P   107_B      -       -           -
LGA    G   108_B      -       -           -
LGA    M   109_B      -       -           -
LGA    F   110_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   81    5.0     58    3.04     0.00     44.137     1.849

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.591647 * X  +   0.762676 * Y  +  -0.261304 * Z  + -30.280968
  Y_new =  -0.009913 * X  +   0.330976 * Y  +   0.943587 * Z  +  34.673668
  Z_new =   0.806136 * X  +  -0.555680 * Y  +   0.203381 * Z  + -42.380997 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.219936    1.921657  [ DEG:   -69.8972    110.1028 ]
  Theta =  -0.937593   -2.204000  [ DEG:   -53.7201   -126.2799 ]
  Phi   =  -0.016753    3.124840  [ DEG:    -0.9599    179.0401 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1f37_B                                        
REMARK     2: T0506_174_254.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1f37_B.T0506_174_254.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   81   5.0   58   3.04    0.00  44.137
REMARK  ---------------------------------------------------------- 
MOLECULE 1f37_B
HEADER    ELECTRON TRANSPORT                      31-MAY-00   1F37              
TITLE     STRUCTURE OF A THIOREDOXIN-LIKE [2FE-2S] FERREDOXIN FROM              
TITLE    2 AQUIFEX AEOLICUS                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERREDOXIN [2FE-2S];                                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    FERREDOXIN, [2FE-2S] CLUSTER, THIOREDOXIN FOLD                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.YEH,C.CHATELET,S.M.SOLTIS,P.KUHN,J.MEYER,D.C.REES                 
REVDAT   1   26-JUL-00 1F37    0                                                
JRNL        AUTH   A.P.YEH,C.CHATELET,S.M.SOLTIS,P.KUHN,J.MEYER,                
JRNL        AUTH 2 D.C.REES                                                     
JRNL        TITL   STRUCTURE OF A THIOREDOXIN-LIKE [2FE-2S]                     
JRNL        TITL 2 FERREDOXIN FROM AQUIFEX AEOLICUS.                            
JRNL        REF    J.MOL.BIOL.                   V. 300   587 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1F37 A    1   110  UNP    O66511   FER2_AQUAE       2    111             
DBREF  1F37 B    1   110  UNP    O66511   FER2_AQUAE       2    111             
SEQRES   1 A  110  ALA GLU PHE LYS HIS VAL PHE VAL CYS VAL GLN ASP ARG          
SEQRES   2 A  110  PRO PRO GLY HIS PRO GLN GLY SER CYS ALA GLN ARG GLY          
SEQRES   3 A  110  SER ARG GLU VAL PHE GLN ALA PHE MET GLU LYS ILE GLN          
SEQRES   4 A  110  THR ASP PRO GLN LEU PHE MET THR THR VAL ILE THR PRO          
SEQRES   5 A  110  THR GLY CYS MET ASN ALA CYS MET MET GLY PRO VAL VAL          
SEQRES   6 A  110  VAL VAL TYR PRO ASP GLY VAL TRP TYR GLY GLN VAL LYS          
SEQRES   7 A  110  PRO GLU ASP VAL ASP GLU ILE VAL GLU LYS HIS LEU LYS          
SEQRES   8 A  110  GLY GLY GLU PRO VAL GLU ARG LEU VAL ILE SER LYS GLY          
SEQRES   9 A  110  LYS PRO PRO GLY MET PHE                                      
SEQRES   1 B  110  ALA GLU PHE LYS HIS VAL PHE VAL CYS VAL GLN ASP ARG          
SEQRES   2 B  110  PRO PRO GLY HIS PRO GLN GLY SER CYS ALA GLN ARG GLY          
SEQRES   3 B  110  SER ARG GLU VAL PHE GLN ALA PHE MET GLU LYS ILE GLN          
SEQRES   4 B  110  THR ASP PRO GLN LEU PHE MET THR THR VAL ILE THR PRO          
SEQRES   5 B  110  THR GLY CYS MET ASN ALA CYS MET MET GLY PRO VAL VAL          
SEQRES   6 B  110  VAL VAL TYR PRO ASP GLY VAL TRP TYR GLY GLN VAL LYS          
SEQRES   7 B  110  PRO GLU ASP VAL ASP GLU ILE VAL GLU LYS HIS LEU LYS          
SEQRES   8 B  110  GLY GLY GLU PRO VAL GLU ARG LEU VAL ILE SER LYS GLY          
SEQRES   9 B  110  LYS PRO PRO GLY MET PHE                                      
HET    FES   1001       4                                                       
HET    FES   1002       4                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HETNAM     FES FE2/S2 (INORGANIC) CLUSTER                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   3  FES    2(FE2 S2)                                                    
FORMUL   5  GOL    2(C3 H8 O3)                                                  
FORMUL   7  HOH   *70(H2 O)                                                     
CRYST1   68.079   68.079  102.519  90.00  90.00  90.00 P 41 21 2    16          
ATOM    842  N   ALA B   1       9.171  26.342  -9.347  1.00 79.10           N  
ATOM    843  CA  ALA B   1      10.601  26.398  -9.777  1.00 80.13           C  
ATOM    844  C   ALA B   1      11.383  27.458  -8.991  1.00 80.15           C  
ATOM    845  O   ALA B   1      12.318  27.131  -8.242  1.00 82.21           O  
ATOM    846  CB  ALA B   1      10.686  26.693 -11.282  1.00 77.59           C  
ATOM    847  N   GLU B   2      10.996  28.724  -9.161  1.00 74.93           N  
ATOM    848  CA  GLU B   2      11.672  29.818  -8.476  1.00 71.17           C  
ATOM    849  C   GLU B   2      10.741  30.854  -7.841  1.00 65.27           C  
ATOM    850  O   GLU B   2       9.632  31.105  -8.314  1.00 63.90           O  
ATOM    851  CB  GLU B   2      12.632  30.516  -9.440  1.00 73.69           C  
ATOM    852  CG  GLU B   2      13.895  29.717  -9.751  1.00 78.11           C  
ATOM    853  CD  GLU B   2      14.765  29.491  -8.522  1.00 80.82           C  
ATOM    854  OE1 GLU B   2      15.898  28.984  -8.702  1.00 81.63           O  
ATOM    855  OE2 GLU B   2      14.316  29.812  -7.386  1.00 81.86           O  
ATOM    856  N   PHE B   3      11.217  31.446  -6.757  1.00 58.52           N  
ATOM    857  CA  PHE B   3      10.464  32.444  -6.023  1.00 55.80           C  
ATOM    858  C   PHE B   3      10.421  33.764  -6.778  1.00 52.21           C  
ATOM    859  O   PHE B   3      11.436  34.214  -7.317  1.00 53.27           O  
ATOM    860  CB  PHE B   3      11.109  32.641  -4.645  1.00 54.33           C  
ATOM    861  CG  PHE B   3      10.516  33.766  -3.848  1.00 53.16           C  
ATOM    862  CD1 PHE B   3       9.170  33.748  -3.486  1.00 54.08           C  
ATOM    863  CD2 PHE B   3      11.277  34.892  -3.534  1.00 52.92           C  
ATOM    864  CE1 PHE B   3       8.589  34.841  -2.833  1.00 50.44           C  
ATOM    865  CE2 PHE B   3      10.698  35.989  -2.879  1.00 51.56           C  
ATOM    866  CZ  PHE B   3       9.358  35.958  -2.536  1.00 48.46           C  
ATOM    867  N   LYS B   4       9.236  34.358  -6.854  1.00 52.13           N  
ATOM    868  CA  LYS B   4       9.060  35.659  -7.514  1.00 47.97           C  
ATOM    869  C   LYS B   4       8.348  36.555  -6.516  1.00 46.70           C  
ATOM    870  O   LYS B   4       7.420  36.102  -5.845  1.00 39.75           O  
ATOM    871  CB  LYS B   4       8.242  35.528  -8.797  1.00 47.97           C  
ATOM    872  CG  LYS B   4       9.108  35.458 -10.035  1.00 55.22           C  
ATOM    873  CD  LYS B   4       8.785  34.229 -10.869  1.00 64.00           C  
ATOM    874  CE  LYS B   4       9.780  34.045 -12.016  1.00 66.15           C  
ATOM    875  NZ  LYS B   4       9.768  35.203 -12.936  1.00 71.75           N  
ATOM    876  N   HIS B   5       8.815  37.805  -6.392  1.00 40.66           N  
ATOM    877  CA  HIS B   5       8.226  38.770  -5.455  1.00 38.36           C  
ATOM    878  C   HIS B   5       7.621  39.957  -6.271  1.00 39.16           C  
ATOM    879  O   HIS B   5       8.327  40.648  -7.005  1.00 38.53           O  
ATOM    880  CB  HIS B   5       9.324  39.235  -4.468  1.00 30.98           C  
ATOM    881  CG  HIS B   5       8.790  39.755  -3.173  1.00 32.86           C  
ATOM    882  ND1 HIS B   5       9.580  39.903  -2.051  1.00 37.11           N  
ATOM    883  CD2 HIS B   5       7.555  40.194  -2.827  1.00 32.65           C  
ATOM    884  CE1 HIS B   5       8.850  40.411  -1.060  1.00 31.66           C  
ATOM    885  NE2 HIS B   5       7.615  40.595  -1.514  1.00 34.21           N  
ATOM    886  N   VAL B   6       6.314  40.175  -6.164  1.00 37.12           N  
ATOM    887  CA  VAL B   6       5.638  41.228  -6.931  1.00 40.05           C  
ATOM    888  C   VAL B   6       5.273  42.396  -6.011  1.00 39.70           C  
ATOM    889  O   VAL B   6       4.631  42.181  -4.988  1.00 36.27           O  
ATOM    890  CB  VAL B   6       4.356  40.668  -7.565  1.00 41.55           C  
ATOM    891  CG1 VAL B   6       3.603  41.760  -8.341  1.00 33.01           C  
ATOM    892  CG2 VAL B   6       4.715  39.506  -8.521  1.00 34.48           C  
ATOM    893  N   PHE B   7       5.717  43.611  -6.358  1.00 41.90           N  
ATOM    894  CA  PHE B   7       5.439  44.805  -5.552  1.00 38.88           C  
ATOM    895  C   PHE B   7       4.534  45.725  -6.345  1.00 39.22           C  
ATOM    896  O   PHE B   7       4.880  46.134  -7.430  1.00 41.46           O  
ATOM    897  CB  PHE B   7       6.739  45.544  -5.173  1.00 33.37           C  
ATOM    898  CG  PHE B   7       7.623  44.778  -4.183  1.00 35.03           C  
ATOM    899  CD1 PHE B   7       8.578  43.868  -4.643  1.00 36.09           C  
ATOM    900  CD2 PHE B   7       7.531  45.004  -2.818  1.00 23.87           C  
ATOM    901  CE1 PHE B   7       9.426  43.205  -3.774  1.00 30.68           C  
ATOM    902  CE2 PHE B   7       8.369  44.350  -1.926  1.00 36.90           C  
ATOM    903  CZ  PHE B   7       9.337  43.434  -2.409  1.00 36.54           C  
ATOM    904  N   VAL B   8       3.382  46.057  -5.774  1.00 40.16           N  
ATOM    905  CA  VAL B   8       2.384  46.908  -6.428  1.00 37.95           C  
ATOM    906  C   VAL B   8       2.243  48.202  -5.626  1.00 37.77           C  
ATOM    907  O   VAL B   8       1.913  48.138  -4.441  1.00 35.51           O  
ATOM    908  CB  VAL B   8       1.009  46.241  -6.423  1.00 41.05           C  
ATOM    909  CG1 VAL B   8      -0.022  47.200  -7.056  1.00 34.71           C  
ATOM    910  CG2 VAL B   8       1.059  44.875  -7.181  1.00 31.52           C  
ATOM    911  N   CYS B   9       2.527  49.346  -6.249  1.00 36.02           N  
ATOM    912  CA  CYS B   9       2.416  50.639  -5.552  1.00 40.23           C  
ATOM    913  C   CYS B   9       0.944  50.908  -5.340  1.00 33.13           C  
ATOM    914  O   CYS B   9       0.161  50.775  -6.294  1.00 34.20           O  
ATOM    915  CB  CYS B   9       2.992  51.795  -6.389  1.00 42.04           C  
ATOM    916  SG  CYS B   9       2.626  53.465  -5.688  1.00 57.91           S  
ATOM    917  N   VAL B  10       0.567  51.254  -4.113  1.00 38.56           N  
ATOM    918  CA  VAL B  10      -0.845  51.555  -3.789  1.00 43.69           C  
ATOM    919  C   VAL B  10      -0.919  52.929  -3.104  1.00 44.44           C  
ATOM    920  O   VAL B  10      -1.841  53.232  -2.357  1.00 43.17           O  
ATOM    921  CB  VAL B  10      -1.484  50.470  -2.873  1.00 39.78           C  
ATOM    922  CG1 VAL B  10      -1.582  49.178  -3.623  1.00 41.35           C  
ATOM    923  CG2 VAL B  10      -0.682  50.298  -1.617  1.00 37.65           C  
ATOM    924  N   GLN B  11       0.077  53.750  -3.389  1.00 48.46           N  
ATOM    925  CA  GLN B  11       0.178  55.089  -2.849  1.00 50.98           C  
ATOM    926  C   GLN B  11      -1.008  55.904  -3.320  1.00 53.48           C  
ATOM    927  O   GLN B  11      -1.362  55.924  -4.513  1.00 50.27           O  
ATOM    928  CB  GLN B  11       1.457  55.736  -3.346  1.00 56.49           C  
ATOM    929  CG  GLN B  11       1.786  57.053  -2.686  1.00 62.05           C  
ATOM    930  CD  GLN B  11       1.996  56.898  -1.206  1.00 65.24           C  
ATOM    931  OE1 GLN B  11       1.024  56.753  -0.439  1.00 71.81           O  
ATOM    932  NE2 GLN B  11       3.271  56.907  -0.788  1.00 64.93           N  
ATOM    933  N   ASP B  12      -1.654  56.558  -2.374  1.00 55.49           N  
ATOM    934  CA  ASP B  12      -2.793  57.380  -2.731  1.00 59.38           C  
ATOM    935  C   ASP B  12      -2.464  58.877  -2.514  1.00 59.37           C  
ATOM    936  O   ASP B  12      -1.675  59.236  -1.634  1.00 59.85           O  
ATOM    937  CB  ASP B  12      -4.037  56.959  -1.930  1.00 57.68           C  
ATOM    938  CG  ASP B  12      -5.341  57.382  -2.606  1.00 59.54           C  
ATOM    939  OD1 ASP B  12      -6.434  56.964  -2.127  1.00 60.87           O  
ATOM    940  OD2 ASP B  12      -5.235  58.127  -3.611  1.00 59.00           O  
ATOM    941  N   ARG B  13      -3.030  59.733  -3.345  1.00 59.14           N  
ATOM    942  CA  ARG B  13      -2.806  61.178  -3.212  1.00 60.61           C  
ATOM    943  C   ARG B  13      -4.090  61.929  -3.533  1.00 60.40           C  
ATOM    944  O   ARG B  13      -4.960  61.417  -4.231  1.00 59.77           O  
ATOM    945  CB  ARG B  13      -1.667  61.634  -4.130  1.00 56.84           C  
ATOM    946  CG  ARG B  13      -0.285  61.249  -3.591  1.00 55.45           C  
ATOM    947  CD  ARG B  13       0.830  61.684  -4.522  1.00 53.50           C  
ATOM    948  NE  ARG B  13       2.154  61.266  -4.050  1.00 52.36           N  
ATOM    949  CZ  ARG B  13       3.055  60.612  -4.802  1.00 57.12           C  
ATOM    950  NH1 ARG B  13       2.772  60.285  -6.066  1.00 48.58           N  
ATOM    951  NH2 ARG B  13       4.256  60.317  -4.295  1.00 54.21           N  
ATOM    952  N   PRO B  14      -4.249  63.144  -2.995  1.00 63.47           N  
ATOM    953  CA  PRO B  14      -5.471  63.901  -3.276  1.00 63.73           C  
ATOM    954  C   PRO B  14      -5.727  64.097  -4.777  1.00 63.75           C  
ATOM    955  O   PRO B  14      -4.796  64.337  -5.550  1.00 60.75           O  
ATOM    956  CB  PRO B  14      -5.227  65.227  -2.554  1.00 62.75           C  
ATOM    957  CG  PRO B  14      -4.417  64.804  -1.382  1.00 63.47           C  
ATOM    958  CD  PRO B  14      -3.416  63.851  -2.003  1.00 63.63           C  
ATOM    959  N   PRO B  15      -7.010  64.018  -5.192  1.00 65.13           N  
ATOM    960  CA  PRO B  15      -7.556  64.163  -6.544  1.00 65.80           C  
ATOM    961  C   PRO B  15      -6.848  65.132  -7.480  1.00 67.24           C  
ATOM    962  O   PRO B  15      -6.496  64.777  -8.609  1.00 72.33           O  
ATOM    963  CB  PRO B  15      -8.993  64.597  -6.278  1.00 67.18           C  
ATOM    964  CG  PRO B  15      -9.356  63.763  -5.095  1.00 68.12           C  
ATOM    965  CD  PRO B  15      -8.101  63.843  -4.209  1.00 65.84           C  
ATOM    966  N   GLY B  16      -6.635  66.364  -7.043  1.00 65.14           N  
ATOM    967  CA  GLY B  16      -5.991  67.301  -7.943  1.00 66.10           C  
ATOM    968  C   GLY B  16      -4.482  67.350  -7.832  1.00 66.46           C  
ATOM    969  O   GLY B  16      -3.849  68.297  -8.310  1.00 63.26           O  
ATOM    970  N   HIS B  17      -3.893  66.327  -7.215  1.00 67.83           N  
ATOM    971  CA  HIS B  17      -2.446  66.317  -7.026  1.00 68.02           C  
ATOM    972  C   HIS B  17      -1.661  66.389  -8.328  1.00 66.97           C  
ATOM    973  O   HIS B  17      -2.020  65.759  -9.321  1.00 67.59           O  
ATOM    974  CB  HIS B  17      -1.994  65.090  -6.229  1.00 66.44           C  
ATOM    975  CG  HIS B  17      -0.581  65.195  -5.749  1.00 62.70           C  
ATOM    976  ND1 HIS B  17      -0.251  65.749  -4.528  1.00 62.20           N  
ATOM    977  CD2 HIS B  17       0.592  64.944  -6.376  1.00 60.19           C  
ATOM    978  CE1 HIS B  17       1.065  65.845  -4.432  1.00 59.16           C  
ATOM    979  NE2 HIS B  17       1.600  65.367  -5.542  1.00 59.06           N  
ATOM    980  N   PRO B  18      -0.579  67.181  -8.328  1.00 67.05           N  
ATOM    981  CA  PRO B  18       0.323  67.404  -9.465  1.00 68.40           C  
ATOM    982  C   PRO B  18       0.882  66.125 -10.073  1.00 69.19           C  
ATOM    983  O   PRO B  18       1.045  66.014 -11.289  1.00 69.45           O  
ATOM    984  CB  PRO B  18       1.413  68.276  -8.862  1.00 67.81           C  
ATOM    985  CG  PRO B  18       0.643  69.104  -7.877  1.00 67.49           C  
ATOM    986  CD  PRO B  18      -0.232  68.072  -7.205  1.00 67.21           C  
ATOM    987  N   GLN B  19       1.168  65.147  -9.224  1.00 68.89           N  
ATOM    988  CA  GLN B  19       1.711  63.882  -9.701  1.00 69.76           C  
ATOM    989  C   GLN B  19       0.675  62.767  -9.791  1.00 67.51           C  
ATOM    990  O   GLN B  19       0.912  61.754 -10.452  1.00 67.27           O  
ATOM    991  CB  GLN B  19       2.865  63.424  -8.807  1.00 71.40           C  
ATOM    992  CG  GLN B  19       4.193  64.087  -9.109  1.00 74.01           C  
ATOM    993  CD  GLN B  19       4.733  63.712 -10.495  1.00 78.08           C  
ATOM    994  OE1 GLN B  19       5.909  63.954 -10.810  1.00 77.92           O  
ATOM    995  NE2 GLN B  19       3.874  63.119 -11.327  1.00 78.70           N  
ATOM    996  N   GLY B  20      -0.470  62.960  -9.155  1.00 65.00           N  
ATOM    997  CA  GLY B  20      -1.491  61.931  -9.177  1.00 60.54           C  
ATOM    998  C   GLY B  20      -0.967  60.785  -8.338  1.00 57.33           C  
ATOM    999  O   GLY B  20       0.064  60.918  -7.673  1.00 60.74           O  
ATOM   1000  N   SER B  21      -1.653  59.663  -8.360  1.00 55.00           N  
ATOM   1001  CA  SER B  21      -1.194  58.516  -7.583  1.00 56.46           C  
ATOM   1002  C   SER B  21      -1.613  57.217  -8.272  1.00 53.75           C  
ATOM   1003  O   SER B  21      -2.535  57.194  -9.082  1.00 52.51           O  
ATOM   1004  CB  SER B  21      -1.774  58.569  -6.165  1.00 54.12           C  
ATOM   1005  OG  SER B  21      -3.180  58.366  -6.210  1.00 58.94           O  
ATOM   1006  N   CYS B  22      -0.930  56.131  -7.945  1.00 52.67           N  
ATOM   1007  CA  CYS B  22      -1.262  54.859  -8.551  1.00 48.35           C  
ATOM   1008  C   CYS B  22      -2.629  54.431  -8.068  1.00 47.57           C  
ATOM   1009  O   CYS B  22      -3.423  53.878  -8.840  1.00 47.59           O  
ATOM   1010  CB  CYS B  22      -0.196  53.802  -8.190  1.00 51.79           C  
ATOM   1011  SG  CYS B  22       1.465  54.088  -8.920  1.00 54.17           S  
ATOM   1012  N   ALA B  23      -2.923  54.690  -6.794  1.00 47.09           N  
ATOM   1013  CA  ALA B  23      -4.222  54.291  -6.259  1.00 50.82           C  
ATOM   1014  C   ALA B  23      -5.322  54.926  -7.112  1.00 54.22           C  
ATOM   1015  O   ALA B  23      -6.236  54.237  -7.605  1.00 52.17           O  
ATOM   1016  CB  ALA B  23      -4.364  54.732  -4.798  1.00 50.28           C  
ATOM   1017  N   GLN B  24      -5.227  56.242  -7.291  1.00 52.23           N  
ATOM   1018  CA  GLN B  24      -6.225  56.970  -8.085  1.00 54.62           C  
ATOM   1019  C   GLN B  24      -6.366  56.365  -9.478  1.00 54.37           C  
ATOM   1020  O   GLN B  24      -7.438  56.398 -10.098  1.00 49.60           O  
ATOM   1021  CB  GLN B  24      -5.830  58.459  -8.195  1.00 54.21           C  
ATOM   1022  CG  GLN B  24      -5.800  59.178  -6.817  1.00 56.85           C  
ATOM   1023  CD  GLN B  24      -5.248  60.595  -6.889  1.00 57.56           C  
ATOM   1024  OE1 GLN B  24      -4.072  60.796  -7.197  0.10 54.32           O  
ATOM   1025  NE2 GLN B  24      -6.103  61.574  -6.610  0.10 54.97           N  
ATOM   1026  N   ARG B  25      -5.264  55.804  -9.976  1.00 53.86           N  
ATOM   1027  CA  ARG B  25      -5.267  55.214 -11.300  1.00 52.26           C  
ATOM   1028  C   ARG B  25      -5.670  53.767 -11.245  1.00 50.27           C  
ATOM   1029  O   ARG B  25      -5.484  53.026 -12.196  1.00 55.65           O  
ATOM   1030  CB  ARG B  25      -3.894  55.377 -11.951  1.00 52.83           C  
ATOM   1031  CG  ARG B  25      -3.418  56.843 -11.975  1.00 55.50           C  
ATOM   1032  CD  ARG B  25      -2.287  57.050 -12.966  1.00 60.60           C  
ATOM   1033  NE  ARG B  25      -2.011  58.471 -13.181  1.00 63.18           N  
ATOM   1034  CZ  ARG B  25      -1.450  59.285 -12.291  0.10 59.14           C  
ATOM   1035  NH1 ARG B  25      -1.086  58.828 -11.101  0.10 57.43           N  
ATOM   1036  NH2 ARG B  25      -1.252  60.564 -12.592  0.10 58.78           N  
ATOM   1037  N   GLY B  26      -6.247  53.374 -10.124  1.00 51.56           N  
ATOM   1038  CA  GLY B  26      -6.721  52.009  -9.948  1.00 56.16           C  
ATOM   1039  C   GLY B  26      -5.737  50.944  -9.445  1.00 52.43           C  
ATOM   1040  O   GLY B  26      -6.002  49.735  -9.585  1.00 49.56           O  
ATOM   1041  N   SER B  27      -4.645  51.363  -8.825  1.00 47.14           N  
ATOM   1042  CA  SER B  27      -3.670  50.365  -8.407  1.00 47.71           C  
ATOM   1043  C   SER B  27      -4.160  49.388  -7.345  1.00 47.27           C  
ATOM   1044  O   SER B  27      -3.591  48.291  -7.199  1.00 45.52           O  
ATOM   1045  CB  SER B  27      -2.400  51.033  -7.911  1.00 38.54           C  
ATOM   1046  OG  SER B  27      -2.678  51.647  -6.676  1.00 42.73           O  
ATOM   1047  N   ARG B  28      -5.176  49.767  -6.577  1.00 45.66           N  
ATOM   1048  CA  ARG B  28      -5.659  48.866  -5.543  1.00 45.63           C  
ATOM   1049  C   ARG B  28      -6.348  47.648  -6.116  1.00 48.66           C  
ATOM   1050  O   ARG B  28      -6.233  46.548  -5.555  1.00 46.26           O  
ATOM   1051  CB  ARG B  28      -6.564  49.583  -4.577  1.00 49.15           C  
ATOM   1052  CG  ARG B  28      -5.809  50.585  -3.745  1.00 53.71           C  
ATOM   1053  CD  ARG B  28      -6.504  50.873  -2.427  1.00 56.87           C  
ATOM   1054  NE  ARG B  28      -5.790  51.920  -1.692  1.00 61.82           N  
ATOM   1055  CZ  ARG B  28      -6.183  52.427  -0.528  0.10 57.19           C  
ATOM   1056  NH1 ARG B  28      -7.286  51.980   0.052  0.10 56.94           N  
ATOM   1057  NH2 ARG B  28      -5.485  53.403   0.040  0.10 55.85           N  
ATOM   1058  N   GLU B  29      -7.032  47.830  -7.240  1.00 45.26           N  
ATOM   1059  CA  GLU B  29      -7.703  46.716  -7.891  1.00 45.81           C  
ATOM   1060  C   GLU B  29      -6.659  45.833  -8.536  1.00 46.97           C  
ATOM   1061  O   GLU B  29      -6.902  44.637  -8.731  1.00 47.20           O  
ATOM   1062  CB  GLU B  29      -8.677  47.169  -8.983  1.00 51.01           C  
ATOM   1063  CG  GLU B  29      -9.908  47.938  -8.489  1.00 60.43           C  
ATOM   1064  CD  GLU B  29      -9.686  49.445  -8.396  1.00 62.63           C  
ATOM   1065  OE1 GLU B  29      -8.842  49.871  -7.564  1.00 65.80           O  
ATOM   1066  OE2 GLU B  29     -10.367  50.180  -9.164  1.00 66.16           O  
ATOM   1067  N   VAL B  30      -5.515  46.421  -8.907  1.00 45.25           N  
ATOM   1068  CA  VAL B  30      -4.439  45.651  -9.522  1.00 41.69           C  
ATOM   1069  C   VAL B  30      -3.851  44.765  -8.419  1.00 41.98           C  
ATOM   1070  O   VAL B  30      -3.664  43.572  -8.613  1.00 42.99           O  
ATOM   1071  CB  VAL B  30      -3.309  46.562 -10.075  1.00 44.29           C  
ATOM   1072  CG1 VAL B  30      -2.099  45.724 -10.471  1.00 38.33           C  
ATOM   1073  CG2 VAL B  30      -3.805  47.356 -11.275  1.00 32.88           C  
ATOM   1074  N   PHE B  31      -3.578  45.342  -7.259  1.00 36.77           N  
ATOM   1075  CA  PHE B  31      -3.022  44.582  -6.137  1.00 39.83           C  
ATOM   1076  C   PHE B  31      -3.954  43.376  -5.822  1.00 47.36           C  
ATOM   1077  O   PHE B  31      -3.504  42.209  -5.786  1.00 42.55           O  
ATOM   1078  CB  PHE B  31      -2.868  45.513  -4.910  1.00 30.87           C  
ATOM   1079  CG  PHE B  31      -2.424  44.820  -3.663  1.00 37.65           C  
ATOM   1080  CD1 PHE B  31      -1.202  44.129  -3.615  1.00 30.60           C  
ATOM   1081  CD2 PHE B  31      -3.257  44.786  -2.537  1.00 39.89           C  
ATOM   1082  CE1 PHE B  31      -0.821  43.400  -2.469  1.00 33.93           C  
ATOM   1083  CE2 PHE B  31      -2.887  44.053  -1.377  1.00 40.97           C  
ATOM   1084  CZ  PHE B  31      -1.655  43.352  -1.358  1.00 40.05           C  
ATOM   1085  N   GLN B  32      -5.251  43.659  -5.636  1.00 46.67           N  
ATOM   1086  CA  GLN B  32      -6.228  42.621  -5.313  1.00 46.77           C  
ATOM   1087  C   GLN B  32      -6.340  41.602  -6.444  1.00 45.96           C  
ATOM   1088  O   GLN B  32      -6.515  40.415  -6.188  1.00 45.93           O  
ATOM   1089  CB  GLN B  32      -7.602  43.258  -4.994  1.00 44.21           C  
ATOM   1090  CG  GLN B  32      -7.499  44.304  -3.859  1.00 52.14           C  
ATOM   1091  CD  GLN B  32      -8.741  45.239  -3.678  1.00 53.69           C  
ATOM   1092  OE1 GLN B  32      -9.450  45.589  -4.644  1.00 57.32           O  
ATOM   1093  NE2 GLN B  32      -8.961  45.655  -2.434  1.00 54.70           N  
ATOM   1094  N   ALA B  33      -6.234  42.046  -7.695  1.00 42.27           N  
ATOM   1095  CA  ALA B  33      -6.322  41.115  -8.817  1.00 44.21           C  
ATOM   1096  C   ALA B  33      -5.151  40.143  -8.787  1.00 46.95           C  
ATOM   1097  O   ALA B  33      -5.266  39.006  -9.239  1.00 43.48           O  
ATOM   1098  CB  ALA B  33      -6.319  41.855 -10.137  1.00 42.95           C  
ATOM   1099  N   PHE B  34      -4.004  40.607  -8.301  1.00 46.41           N  
ATOM   1100  CA  PHE B  34      -2.838  39.734  -8.203  1.00 48.25           C  
ATOM   1101  C   PHE B  34      -3.074  38.719  -7.087  1.00 46.88           C  
ATOM   1102  O   PHE B  34      -2.890  37.516  -7.302  1.00 47.14           O  
ATOM   1103  CB  PHE B  34      -1.546  40.520  -7.894  1.00 42.12           C  
ATOM   1104  CG  PHE B  34      -0.785  40.952  -9.121  1.00 45.05           C  
ATOM   1105  CD1 PHE B  34      -0.742  42.306  -9.499  1.00 38.54           C  
ATOM   1106  CD2 PHE B  34      -0.135  40.003  -9.917  1.00 39.03           C  
ATOM   1107  CE1 PHE B  34      -0.053  42.713 -10.666  1.00 38.82           C  
ATOM   1108  CE2 PHE B  34       0.555  40.384 -11.074  1.00 40.72           C  
ATOM   1109  CZ  PHE B  34       0.594  41.764 -11.454  1.00 40.51           C  
ATOM   1110  N   MET B  35      -3.425  39.207  -5.899  1.00 45.66           N  
ATOM   1111  CA  MET B  35      -3.690  38.334  -4.745  1.00 53.97           C  
ATOM   1112  C   MET B  35      -4.594  37.134  -5.125  1.00 54.46           C  
ATOM   1113  O   MET B  35      -4.172  35.971  -5.068  1.00 57.08           O  
ATOM   1114  CB  MET B  35      -4.364  39.112  -3.605  1.00 53.35           C  
ATOM   1115  CG  MET B  35      -3.474  40.043  -2.806  1.00 56.15           C  
ATOM   1116  SD  MET B  35      -2.010  39.222  -2.166  1.00 65.91           S  
ATOM   1117  CE  MET B  35      -2.576  38.641  -0.594  1.00 62.65           C  
ATOM   1118  N   GLU B  36      -5.827  37.409  -5.528  1.00 52.31           N  
ATOM   1119  CA  GLU B  36      -6.736  36.333  -5.893  1.00 56.31           C  
ATOM   1120  C   GLU B  36      -6.284  35.436  -7.060  1.00 59.99           C  
ATOM   1121  O   GLU B  36      -6.759  34.306  -7.205  1.00 60.49           O  
ATOM   1122  CB  GLU B  36      -8.111  36.916  -6.193  1.00 55.24           C  
ATOM   1123  CG  GLU B  36      -9.059  36.927  -4.990  0.10 53.81           C  
ATOM   1124  CD  GLU B  36      -8.334  36.917  -3.652  0.10 52.85           C  
ATOM   1125  OE1 GLU B  36      -7.868  35.835  -3.238  0.10 53.32           O  
ATOM   1126  OE2 GLU B  36      -8.225  37.989  -3.018  0.10 52.28           O  
ATOM   1127  N   LYS B  37      -5.372  35.924  -7.894  1.00 58.23           N  
ATOM   1128  CA  LYS B  37      -4.910  35.142  -9.029  1.00 59.94           C  
ATOM   1129  C   LYS B  37      -3.796  34.183  -8.611  1.00 62.72           C  
ATOM   1130  O   LYS B  37      -3.543  33.158  -9.274  1.00 61.51           O  
ATOM   1131  CB  LYS B  37      -4.400  36.068 -10.126  1.00 61.16           C  
ATOM   1132  CG  LYS B  37      -4.825  35.638 -11.527  1.00 66.25           C  
ATOM   1133  CD  LYS B  37      -4.032  34.426 -12.031  1.00 65.20           C  
ATOM   1134  CE  LYS B  37      -4.535  33.969 -13.408  1.00 68.27           C  
ATOM   1135  NZ  LYS B  37      -3.626  32.982 -14.065  1.00 68.09           N  
ATOM   1136  N   ILE B  38      -3.134  34.520  -7.507  1.00 61.05           N  
ATOM   1137  CA  ILE B  38      -2.047  33.691  -7.001  1.00 64.77           C  
ATOM   1138  C   ILE B  38      -2.597  32.652  -6.028  1.00 66.08           C  
ATOM   1139  O   ILE B  38      -2.149  31.501  -6.030  1.00 67.02           O  
ATOM   1140  CB  ILE B  38      -0.930  34.578  -6.334  1.00 60.30           C  
ATOM   1141  CG1 ILE B  38       0.285  34.639  -7.259  1.00 61.18           C  
ATOM   1142  CG2 ILE B  38      -0.497  34.015  -4.994  1.00 59.34           C  
ATOM   1143  CD1 ILE B  38      -0.040  35.058  -8.695  1.00 56.38           C  
ATOM   1144  N   GLN B  39      -3.564  33.059  -5.204  1.00 66.05           N  
ATOM   1145  CA  GLN B  39      -4.182  32.150  -4.242  1.00 66.60           C  
ATOM   1146  C   GLN B  39      -5.070  31.172  -4.998  1.00 67.16           C  
ATOM   1147  O   GLN B  39      -5.735  30.340  -4.403  1.00 72.68           O  
ATOM   1148  CB  GLN B  39      -5.023  32.925  -3.219  1.00 66.01           C  
ATOM   1149  CG  GLN B  39      -4.289  33.412  -1.960  0.10 62.16           C  
ATOM   1150  CD  GLN B  39      -3.270  34.515  -2.211  0.10 60.79           C  
ATOM   1151  OE1 GLN B  39      -2.826  35.184  -1.276  0.10 59.93           O  
ATOM   1152  NE2 GLN B  39      -2.888  34.703  -3.467  0.10 59.31           N  
ATOM   1153  N   THR B  40      -5.041  31.259  -6.321  1.00 68.61           N  
ATOM   1154  CA  THR B  40      -5.847  30.408  -7.189  1.00 67.14           C  
ATOM   1155  C   THR B  40      -5.013  29.368  -7.968  1.00 68.26           C  
ATOM   1156  O   THR B  40      -5.543  28.609  -8.792  1.00 67.64           O  
ATOM   1157  CB  THR B  40      -6.637  31.320  -8.164  1.00 67.73           C  
ATOM   1158  OG1 THR B  40      -7.692  31.962  -7.434  1.00 67.55           O  
ATOM   1159  CG2 THR B  40      -7.206  30.540  -9.361  1.00 64.45           C  
ATOM   1160  N   ASP B  41      -3.713  29.326  -7.704  1.00 69.16           N  
ATOM   1161  CA  ASP B  41      -2.832  28.376  -8.385  1.00 69.55           C  
ATOM   1162  C   ASP B  41      -1.844  27.777  -7.383  1.00 67.76           C  
ATOM   1163  O   ASP B  41      -0.855  28.416  -7.015  1.00 68.03           O  
ATOM   1164  CB  ASP B  41      -2.064  29.080  -9.499  1.00 72.59           C  
ATOM   1165  CG  ASP B  41      -1.112  28.157 -10.224  1.00 76.86           C  
ATOM   1166  OD1 ASP B  41      -1.557  27.424 -11.130  1.00 79.09           O  
ATOM   1167  OD2 ASP B  41       0.090  28.154  -9.883  1.00 80.47           O  
ATOM   1168  N   PRO B  42      -2.097  26.540  -6.932  1.00 67.42           N  
ATOM   1169  CA  PRO B  42      -1.230  25.862  -5.967  1.00 65.11           C  
ATOM   1170  C   PRO B  42       0.255  26.076  -6.208  1.00 63.53           C  
ATOM   1171  O   PRO B  42       1.023  26.218  -5.266  1.00 63.06           O  
ATOM   1172  CB  PRO B  42      -1.641  24.399  -6.114  1.00 63.70           C  
ATOM   1173  CG  PRO B  42      -3.101  24.523  -6.379  1.00 64.18           C  
ATOM   1174  CD  PRO B  42      -3.156  25.628  -7.406  1.00 63.68           C  
ATOM   1175  N   GLN B  43       0.668  26.113  -7.472  1.00 62.30           N  
ATOM   1176  CA  GLN B  43       2.075  26.308  -7.763  1.00 61.52           C  
ATOM   1177  C   GLN B  43       2.537  27.749  -7.597  1.00 64.74           C  
ATOM   1178  O   GLN B  43       3.686  27.987  -7.221  1.00 69.04           O  
ATOM   1179  CB  GLN B  43       2.408  25.833  -9.180  1.00 62.39           C  
ATOM   1180  CG  GLN B  43       3.912  25.756  -9.442  0.10 58.31           C  
ATOM   1181  CD  GLN B  43       4.282  24.793 -10.553  0.10 56.63           C  
ATOM   1182  OE1 GLN B  43       5.461  24.530 -10.786  0.10 54.94           O  
ATOM   1183  NE2 GLN B  43       3.281  24.263 -11.245  0.10 55.93           N  
ATOM   1184  N   LEU B  44       1.660  28.717  -7.878  1.00 63.78           N  
ATOM   1185  CA  LEU B  44       2.039  30.120  -7.747  1.00 60.23           C  
ATOM   1186  C   LEU B  44       1.990  30.531  -6.289  1.00 60.28           C  
ATOM   1187  O   LEU B  44       2.866  31.239  -5.793  1.00 55.09           O  
ATOM   1188  CB  LEU B  44       1.092  31.029  -8.543  1.00 58.24           C  
ATOM   1189  CG  LEU B  44       1.164  31.100 -10.076  1.00 58.43           C  
ATOM   1190  CD1 LEU B  44       0.145  32.109 -10.555  1.00 53.48           C  
ATOM   1191  CD2 LEU B  44       2.578  31.498 -10.554  1.00 54.04           C  
ATOM   1192  N   PHE B  45       0.956  30.073  -5.601  1.00 62.28           N  
ATOM   1193  CA  PHE B  45       0.771  30.428  -4.205  1.00 62.69           C  
ATOM   1194  C   PHE B  45       1.964  30.069  -3.353  1.00 62.76           C  
ATOM   1195  O   PHE B  45       2.219  30.720  -2.338  1.00 62.02           O  
ATOM   1196  CB  PHE B  45      -0.482  29.747  -3.663  1.00 66.82           C  
ATOM   1197  CG  PHE B  45      -0.796  30.097  -2.241  1.00 74.14           C  
ATOM   1198  CD1 PHE B  45      -1.006  31.424  -1.866  1.00 76.43           C  
ATOM   1199  CD2 PHE B  45      -0.916  29.098  -1.274  1.00 77.57           C  
ATOM   1200  CE1 PHE B  45      -1.334  31.754  -0.553  1.00 76.94           C  
ATOM   1201  CE2 PHE B  45      -1.241  29.416   0.046  1.00 78.08           C  
ATOM   1202  CZ  PHE B  45      -1.452  30.754   0.403  1.00 78.80           C  
ATOM   1203  N   MET B  46       2.710  29.046  -3.772  1.00 62.60           N  
ATOM   1204  CA  MET B  46       3.869  28.601  -2.999  1.00 64.57           C  
ATOM   1205  C   MET B  46       5.202  29.134  -3.507  1.00 62.58           C  
ATOM   1206  O   MET B  46       6.252  28.820  -2.943  1.00 64.50           O  
ATOM   1207  CB  MET B  46       3.935  27.060  -2.947  1.00 70.28           C  
ATOM   1208  CG  MET B  46       2.858  26.362  -2.086  1.00 71.98           C  
ATOM   1209  SD  MET B  46       2.808  26.896  -0.355  1.00 81.55           S  
ATOM   1210  CE  MET B  46       4.495  26.430   0.148  1.00 80.96           C  
ATOM   1211  N   THR B  47       5.169  29.942  -4.560  1.00 60.82           N  
ATOM   1212  CA  THR B  47       6.397  30.502  -5.124  1.00 57.62           C  
ATOM   1213  C   THR B  47       6.238  31.973  -5.520  1.00 55.99           C  
ATOM   1214  O   THR B  47       7.026  32.501  -6.300  1.00 50.55           O  
ATOM   1215  CB  THR B  47       6.803  29.728  -6.388  1.00 56.05           C  
ATOM   1216  OG1 THR B  47       5.750  29.849  -7.354  1.00 53.03           O  
ATOM   1217  CG2 THR B  47       7.020  28.241  -6.063  1.00 58.88           C  
ATOM   1218  N   THR B  48       5.233  32.649  -4.972  1.00 53.18           N  
ATOM   1219  CA  THR B  48       5.010  34.027  -5.362  1.00 50.95           C  
ATOM   1220  C   THR B  48       4.388  34.839  -4.244  1.00 51.18           C  
ATOM   1221  O   THR B  48       3.358  34.458  -3.702  1.00 53.38           O  
ATOM   1222  CB  THR B  48       4.052  34.093  -6.585  1.00 53.77           C  
ATOM   1223  OG1 THR B  48       4.502  33.190  -7.610  1.00 54.08           O  
ATOM   1224  CG2 THR B  48       4.004  35.526  -7.154  1.00 57.47           C  
ATOM   1225  N   VAL B  49       5.013  35.956  -3.898  1.00 49.75           N  
ATOM   1226  CA  VAL B  49       4.480  36.859  -2.879  1.00 48.86           C  
ATOM   1227  C   VAL B  49       4.054  38.204  -3.538  1.00 45.90           C  
ATOM   1228  O   VAL B  49       4.700  38.653  -4.465  1.00 43.05           O  
ATOM   1229  CB  VAL B  49       5.525  37.097  -1.823  1.00 49.44           C  
ATOM   1230  CG1 VAL B  49       5.058  38.161  -0.828  1.00 46.55           C  
ATOM   1231  CG2 VAL B  49       5.789  35.781  -1.114  1.00 51.68           C  
ATOM   1232  N   ILE B  50       2.948  38.807  -3.090  1.00 45.00           N  
ATOM   1233  CA  ILE B  50       2.439  40.091  -3.640  1.00 42.69           C  
ATOM   1234  C   ILE B  50       2.403  41.089  -2.471  1.00 42.01           C  
ATOM   1235  O   ILE B  50       1.657  40.902  -1.496  1.00 37.18           O  
ATOM   1236  CB  ILE B  50       0.983  39.974  -4.201  1.00 44.06           C  
ATOM   1237  CG1 ILE B  50       0.801  38.675  -5.022  1.00 39.87           C  
ATOM   1238  CG2 ILE B  50       0.674  41.207  -5.115  1.00 41.02           C  
ATOM   1239  CD1 ILE B  50       1.592  38.583  -6.356  1.00 35.62           C  
ATOM   1240  N   THR B  51       3.234  42.127  -2.543  1.00 39.03           N  
ATOM   1241  CA  THR B  51       3.304  43.101  -1.464  1.00 31.95           C  
ATOM   1242  C   THR B  51       2.893  44.524  -1.891  1.00 40.67           C  
ATOM   1243  O   THR B  51       3.297  45.016  -2.945  1.00 39.72           O  
ATOM   1244  CB  THR B  51       4.726  43.148  -0.942  1.00 33.01           C  
ATOM   1245  OG1 THR B  51       5.115  41.835  -0.495  1.00 33.87           O  
ATOM   1246  CG2 THR B  51       4.844  44.101   0.202  1.00 28.23           C  
ATOM   1247  N   PRO B  52       2.066  45.203  -1.071  1.00 42.14           N  
ATOM   1248  CA  PRO B  52       1.585  46.565  -1.326  1.00 37.92           C  
ATOM   1249  C   PRO B  52       2.628  47.528  -0.822  1.00 37.47           C  
ATOM   1250  O   PRO B  52       3.128  47.381   0.302  1.00 37.67           O  
ATOM   1251  CB  PRO B  52       0.323  46.660  -0.484  1.00 40.88           C  
ATOM   1252  CG  PRO B  52       0.697  45.837   0.755  1.00 35.41           C  
ATOM   1253  CD  PRO B  52       1.461  44.640   0.150  1.00 39.59           C  
ATOM   1254  N   THR B  53       2.951  48.520  -1.640  1.00 35.12           N  
ATOM   1255  CA  THR B  53       3.949  49.485  -1.232  1.00 35.77           C  
ATOM   1256  C   THR B  53       3.476  50.927  -1.389  1.00 37.74           C  
ATOM   1257  O   THR B  53       2.392  51.212  -1.972  1.00 30.76           O  
ATOM   1258  CB  THR B  53       5.202  49.356  -2.096  1.00 33.64           C  
ATOM   1259  OG1 THR B  53       4.922  49.884  -3.390  1.00 33.37           O  
ATOM   1260  CG2 THR B  53       5.564  47.881  -2.308  1.00 38.13           C  
ATOM   1261  N   GLY B  54       4.318  51.813  -0.870  1.00 37.97           N  
ATOM   1262  CA  GLY B  54       4.103  53.246  -0.991  1.00 40.08           C  
ATOM   1263  C   GLY B  54       4.871  53.651  -2.256  1.00 41.24           C  
ATOM   1264  O   GLY B  54       5.634  52.842  -2.819  1.00 35.84           O  
ATOM   1265  N   CYS B  55       4.691  54.900  -2.688  1.00 47.13           N  
ATOM   1266  CA  CYS B  55       5.309  55.443  -3.916  1.00 42.19           C  
ATOM   1267  C   CYS B  55       6.727  54.973  -4.197  1.00 37.86           C  
ATOM   1268  O   CYS B  55       7.595  54.990  -3.317  1.00 35.31           O  
ATOM   1269  CB  CYS B  55       5.289  57.001  -3.918  1.00 44.02           C  
ATOM   1270  SG  CYS B  55       5.720  57.720  -5.536  1.00 52.56           S  
ATOM   1271  N   MET B  56       6.952  54.556  -5.434  1.00 40.39           N  
ATOM   1272  CA  MET B  56       8.272  54.107  -5.876  1.00 49.21           C  
ATOM   1273  C   MET B  56       8.882  55.080  -6.931  1.00 51.42           C  
ATOM   1274  O   MET B  56       9.805  54.723  -7.672  1.00 51.46           O  
ATOM   1275  CB  MET B  56       8.199  52.656  -6.406  1.00 44.19           C  
ATOM   1276  CG  MET B  56       7.941  51.601  -5.292  1.00 44.56           C  
ATOM   1277  SD  MET B  56       8.157  49.846  -5.780  1.00 43.72           S  
ATOM   1278  CE  MET B  56       6.485  49.438  -6.466  1.00 25.46           C  
ATOM   1279  N   ASN B  57       8.333  56.294  -7.018  1.00 51.81           N  
ATOM   1280  CA  ASN B  57       8.876  57.334  -7.899  1.00 53.75           C  
ATOM   1281  C   ASN B  57       8.734  57.209  -9.422  1.00 52.30           C  
ATOM   1282  O   ASN B  57       9.687  57.457 -10.166  1.00 54.31           O  
ATOM   1283  CB  ASN B  57      10.357  57.525  -7.549  1.00 56.48           C  
ATOM   1284  CG  ASN B  57      10.602  57.517  -6.053  1.00 57.62           C  
ATOM   1285  OD1 ASN B  57      10.052  58.331  -5.301  1.00 63.45           O  
ATOM   1286  ND2 ASN B  57      11.434  56.587  -5.612  1.00 60.41           N  
ATOM   1287  N   ALA B  58       7.554  56.846  -9.892  1.00 54.42           N  
ATOM   1288  CA  ALA B  58       7.315  56.712 -11.327  1.00 52.74           C  
ATOM   1289  C   ALA B  58       5.810  56.908 -11.553  1.00 54.35           C  
ATOM   1290  O   ALA B  58       5.205  56.363 -12.479  1.00 53.95           O  
ATOM   1291  CB  ALA B  58       7.759  55.342 -11.790  1.00 52.68           C  
ATOM   1292  N   CYS B  59       5.233  57.743 -10.690  1.00 57.97           N  
ATOM   1293  CA  CYS B  59       3.809  58.062 -10.667  1.00 58.82           C  
ATOM   1294  C   CYS B  59       3.138  58.396 -11.996  1.00 60.98           C  
ATOM   1295  O   CYS B  59       2.000  57.965 -12.261  1.00 61.80           O  
ATOM   1296  CB  CYS B  59       3.606  59.206  -9.695  1.00 61.42           C  
ATOM   1297  SG  CYS B  59       4.761  59.040  -8.331  1.00 67.01           S  
ATOM   1298  N   MET B  60       3.818  59.165 -12.840  1.00 59.93           N  
ATOM   1299  CA  MET B  60       3.222  59.501 -14.122  1.00 58.91           C  
ATOM   1300  C   MET B  60       3.012  58.208 -14.925  1.00 60.20           C  
ATOM   1301  O   MET B  60       2.248  58.175 -15.919  1.00 57.08           O  
ATOM   1302  CB  MET B  60       4.128  60.466 -14.891  0.10 57.87           C  
ATOM   1303  CG  MET B  60       3.480  61.074 -16.122  0.10 56.47           C  
ATOM   1304  SD  MET B  60       4.550  62.256 -16.966  0.10 57.45           S  
ATOM   1305  CE  MET B  60       4.333  63.709 -15.932  0.10 53.89           C  
ATOM   1306  N   MET B  61       3.671  57.129 -14.480  1.00 55.29           N  
ATOM   1307  CA  MET B  61       3.550  55.861 -15.186  1.00 53.92           C  
ATOM   1308  C   MET B  61       2.730  54.793 -14.463  1.00 51.95           C  
ATOM   1309  O   MET B  61       2.677  53.626 -14.878  1.00 51.84           O  
ATOM   1310  CB  MET B  61       4.946  55.346 -15.533  1.00 53.86           C  
ATOM   1311  CG  MET B  61       5.754  56.379 -16.300  1.00 56.53           C  
ATOM   1312  SD  MET B  61       7.331  55.802 -16.871  1.00 56.85           S  
ATOM   1313  CE  MET B  61       8.399  56.442 -15.583  1.00 54.65           C  
ATOM   1314  N   GLY B  62       2.040  55.212 -13.412  1.00 49.26           N  
ATOM   1315  CA  GLY B  62       1.238  54.286 -12.641  1.00 43.35           C  
ATOM   1316  C   GLY B  62       0.066  53.693 -13.385  1.00 43.55           C  
ATOM   1317  O   GLY B  62      -0.320  54.183 -14.447  1.00 42.10           O  
ATOM   1318  N   PRO B  63      -0.491  52.585 -12.888  1.00 43.15           N  
ATOM   1319  CA  PRO B  63      -0.057  51.874 -11.671  1.00 45.49           C  
ATOM   1320  C   PRO B  63       1.309  51.195 -11.884  1.00 40.49           C  
ATOM   1321  O   PRO B  63       1.516  50.516 -12.873  1.00 39.97           O  
ATOM   1322  CB  PRO B  63      -1.177  50.857 -11.456  1.00 45.54           C  
ATOM   1323  CG  PRO B  63      -2.400  51.556 -12.076  1.00 41.61           C  
ATOM   1324  CD  PRO B  63      -1.811  52.108 -13.340  1.00 42.89           C  
ATOM   1325  N   VAL B  64       2.232  51.392 -10.959  1.00 41.88           N  
ATOM   1326  CA  VAL B  64       3.564  50.790 -11.058  1.00 42.42           C  
ATOM   1327  C   VAL B  64       3.689  49.393 -10.359  1.00 41.39           C  
ATOM   1328  O   VAL B  64       3.254  49.173  -9.212  1.00 38.30           O  
ATOM   1329  CB  VAL B  64       4.588  51.768 -10.450  1.00 45.67           C  
ATOM   1330  CG1 VAL B  64       5.967  51.117 -10.353  1.00 46.32           C  
ATOM   1331  CG2 VAL B  64       4.667  53.039 -11.323  1.00 42.48           C  
ATOM   1332  N   VAL B  65       4.298  48.448 -11.049  1.00 43.78           N  
ATOM   1333  CA  VAL B  65       4.474  47.110 -10.497  1.00 39.05           C  
ATOM   1334  C   VAL B  65       5.902  46.696 -10.829  1.00 41.76           C  
ATOM   1335  O   VAL B  65       6.344  46.871 -11.973  1.00 38.00           O  
ATOM   1336  CB  VAL B  65       3.499  46.118 -11.161  1.00 42.29           C  
ATOM   1337  CG1 VAL B  65       3.679  44.702 -10.580  1.00 42.97           C  
ATOM   1338  CG2 VAL B  65       2.091  46.533 -10.901  1.00 43.21           C  
ATOM   1339  N   VAL B  66       6.653  46.207  -9.840  1.00 40.76           N  
ATOM   1340  CA  VAL B  66       8.008  45.744 -10.121  1.00 44.24           C  
ATOM   1341  C   VAL B  66       8.155  44.303  -9.629  1.00 44.22           C  
ATOM   1342  O   VAL B  66       7.800  43.982  -8.494  1.00 41.06           O  
ATOM   1343  CB  VAL B  66       9.118  46.642  -9.485  1.00 46.23           C  
ATOM   1344  CG1 VAL B  66       8.862  46.878  -8.012  1.00 49.94           C  
ATOM   1345  CG2 VAL B  66      10.471  45.956  -9.640  1.00 42.57           C  
ATOM   1346  N   VAL B  67       8.665  43.440 -10.509  1.00 42.83           N  
ATOM   1347  CA  VAL B  67       8.853  42.025 -10.203  1.00 39.45           C  
ATOM   1348  C   VAL B  67      10.303  41.685  -9.922  1.00 38.57           C  
ATOM   1349  O   VAL B  67      11.156  41.838 -10.791  1.00 40.23           O  
ATOM   1350  CB  VAL B  67       8.416  41.154 -11.369  1.00 37.88           C  
ATOM   1351  CG1 VAL B  67       8.607  39.665 -10.996  1.00 38.06           C  
ATOM   1352  CG2 VAL B  67       6.972  41.450 -11.706  1.00 36.85           C  
ATOM   1353  N   TYR B  68      10.590  41.227  -8.714  1.00 37.75           N  
ATOM   1354  CA  TYR B  68      11.953  40.866  -8.346  1.00 38.79           C  
ATOM   1355  C   TYR B  68      11.979  39.341  -8.209  1.00 42.26           C  
ATOM   1356  O   TYR B  68      10.931  38.727  -8.058  1.00 39.94           O  
ATOM   1357  CB  TYR B  68      12.313  41.506  -7.014  1.00 38.03           C  
ATOM   1358  CG  TYR B  68      12.819  42.920  -7.135  1.00 39.29           C  
ATOM   1359  CD1 TYR B  68      12.133  43.975  -6.551  1.00 40.79           C  
ATOM   1360  CD2 TYR B  68      13.982  43.203  -7.868  1.00 40.07           C  
ATOM   1361  CE1 TYR B  68      12.582  45.303  -6.692  1.00 42.33           C  
ATOM   1362  CE2 TYR B  68      14.449  44.517  -8.026  1.00 45.83           C  
ATOM   1363  CZ  TYR B  68      13.737  45.567  -7.438  1.00 48.44           C  
ATOM   1364  OH  TYR B  68      14.145  46.864  -7.647  1.00 43.70           O  
ATOM   1365  N   PRO B  69      13.169  38.709  -8.275  1.00 47.09           N  
ATOM   1366  CA  PRO B  69      14.499  39.324  -8.462  1.00 44.20           C  
ATOM   1367  C   PRO B  69      14.747  39.833  -9.890  1.00 46.18           C  
ATOM   1368  O   PRO B  69      15.776  40.455 -10.159  1.00 46.82           O  
ATOM   1369  CB  PRO B  69      15.476  38.193  -8.092  1.00 43.23           C  
ATOM   1370  CG  PRO B  69      14.653  37.110  -7.516  1.00 45.44           C  
ATOM   1371  CD  PRO B  69      13.295  37.246  -8.142  1.00 44.65           C  
ATOM   1372  N   ASP B  70      13.821  39.561 -10.799  1.00 47.30           N  
ATOM   1373  CA  ASP B  70      13.938  39.994 -12.190  1.00 51.51           C  
ATOM   1374  C   ASP B  70      14.338  41.465 -12.318  1.00 50.48           C  
ATOM   1375  O   ASP B  70      15.178  41.809 -13.141  1.00 54.64           O  
ATOM   1376  CB  ASP B  70      12.597  39.830 -12.929  1.00 53.56           C  
ATOM   1377  CG  ASP B  70      12.078  38.414 -12.895  1.00 56.12           C  
ATOM   1378  OD1 ASP B  70      11.839  37.939 -11.767  1.00 65.69           O  
ATOM   1379  OD2 ASP B  70      11.906  37.796 -13.983  1.00 60.05           O  
ATOM   1380  N   GLY B  71      13.703  42.329 -11.534  1.00 46.41           N  
ATOM   1381  CA  GLY B  71      13.996  43.748 -11.620  1.00 43.44           C  
ATOM   1382  C   GLY B  71      13.234  44.323 -12.799  1.00 41.14           C  
ATOM   1383  O   GLY B  71      13.674  45.269 -13.437  1.00 42.84           O  
ATOM   1384  N   VAL B  72      12.070  43.760 -13.099  1.00 37.61           N  
ATOM   1385  CA  VAL B  72      11.292  44.245 -14.222  1.00 40.28           C  
ATOM   1386  C   VAL B  72      10.260  45.254 -13.705  1.00 43.24           C  
ATOM   1387  O   VAL B  72       9.588  44.990 -12.697  1.00 43.66           O  
ATOM   1388  CB  VAL B  72      10.568  43.071 -14.954  1.00 42.75           C  
ATOM   1389  CG1 VAL B  72       9.743  43.623 -16.119  1.00 43.71           C  
ATOM   1390  CG2 VAL B  72      11.597  42.048 -15.512  1.00 42.83           C  
ATOM   1391  N   TRP B  73      10.148  46.411 -14.369  1.00 38.83           N  
ATOM   1392  CA  TRP B  73       9.192  47.439 -13.932  1.00 40.53           C  
ATOM   1393  C   TRP B  73       8.046  47.594 -14.926  1.00 38.06           C  
ATOM   1394  O   TRP B  73       8.276  47.833 -16.107  1.00 36.59           O  
ATOM   1395  CB  TRP B  73       9.887  48.794 -13.739  1.00 36.05           C  
ATOM   1396  CG  TRP B  73      10.915  48.789 -12.668  1.00 32.98           C  
ATOM   1397  CD1 TRP B  73      12.063  48.034 -12.633  1.00 32.52           C  
ATOM   1398  CD2 TRP B  73      10.894  49.556 -11.457  1.00 33.04           C  
ATOM   1399  NE1 TRP B  73      12.754  48.284 -11.464  1.00 38.98           N  
ATOM   1400  CE2 TRP B  73      12.059  49.213 -10.726  1.00 31.37           C  
ATOM   1401  CE3 TRP B  73      10.000  50.494 -10.916  1.00 40.18           C  
ATOM   1402  CZ2 TRP B  73      12.362  49.774  -9.472  1.00 38.97           C  
ATOM   1403  CZ3 TRP B  73      10.295  51.061  -9.650  1.00 41.10           C  
ATOM   1404  CH2 TRP B  73      11.471  50.693  -8.949  1.00 42.11           C  
ATOM   1405  N   TYR B  74       6.810  47.427 -14.464  1.00 39.51           N  
ATOM   1406  CA  TYR B  74       5.655  47.561 -15.359  1.00 37.99           C  
ATOM   1407  C   TYR B  74       4.983  48.880 -15.046  1.00 37.73           C  
ATOM   1408  O   TYR B  74       5.078  49.361 -13.927  1.00 35.10           O  
ATOM   1409  CB  TYR B  74       4.662  46.442 -15.113  1.00 41.39           C  
ATOM   1410  CG  TYR B  74       5.118  45.088 -15.613  1.00 44.58           C  
ATOM   1411  CD1 TYR B  74       5.364  44.037 -14.722  1.00 40.85           C  
ATOM   1412  CD2 TYR B  74       5.217  44.831 -16.970  1.00 38.43           C  
ATOM   1413  CE1 TYR B  74       5.680  42.770 -15.169  1.00 39.30           C  
ATOM   1414  CE2 TYR B  74       5.530  43.550 -17.430  1.00 43.37           C  
ATOM   1415  CZ  TYR B  74       5.751  42.520 -16.521  1.00 41.20           C  
ATOM   1416  OH  TYR B  74       5.975  41.227 -16.970  1.00 41.59           O  
ATOM   1417  N   GLY B  75       4.301  49.473 -16.018  1.00 40.19           N  
ATOM   1418  CA  GLY B  75       3.644  50.739 -15.741  1.00 42.47           C  
ATOM   1419  C   GLY B  75       2.307  50.789 -16.453  1.00 44.32           C  
ATOM   1420  O   GLY B  75       2.097  50.062 -17.424  1.00 42.31           O  
ATOM   1421  N   GLN B  76       1.401  51.623 -15.949  1.00 43.53           N  
ATOM   1422  CA  GLN B  76       0.076  51.778 -16.541  1.00 49.52           C  
ATOM   1423  C   GLN B  76      -0.665  50.436 -16.548  1.00 51.07           C  
ATOM   1424  O   GLN B  76      -1.434  50.124 -17.461  1.00 52.67           O  
ATOM   1425  CB  GLN B  76       0.226  52.356 -17.945  1.00 46.53           C  
ATOM   1426  CG  GLN B  76       0.837  53.754 -17.901  1.00 54.77           C  
ATOM   1427  CD  GLN B  76       1.074  54.359 -19.273  1.00 60.51           C  
ATOM   1428  OE1 GLN B  76       1.153  55.585 -19.418  1.00 62.41           O  
ATOM   1429  NE2 GLN B  76       1.196  53.502 -20.284  1.00 59.59           N  
ATOM   1430  N   VAL B  77      -0.453  49.658 -15.495  1.00 51.87           N  
ATOM   1431  CA  VAL B  77      -1.068  48.342 -15.393  1.00 46.64           C  
ATOM   1432  C   VAL B  77      -2.521  48.456 -15.013  1.00 45.00           C  
ATOM   1433  O   VAL B  77      -2.873  49.247 -14.140  1.00 45.07           O  
ATOM   1434  CB  VAL B  77      -0.371  47.477 -14.338  1.00 43.27           C  
ATOM   1435  CG1 VAL B  77      -1.020  46.088 -14.284  1.00 36.09           C  
ATOM   1436  CG2 VAL B  77       1.106  47.369 -14.685  1.00 40.49           C  
ATOM   1437  N   LYS B  78      -3.342  47.661 -15.688  1.00 44.17           N  
ATOM   1438  CA  LYS B  78      -4.772  47.586 -15.448  1.00 49.76           C  
ATOM   1439  C   LYS B  78      -5.169  46.189 -14.909  1.00 50.72           C  
ATOM   1440  O   LYS B  78      -4.539  45.157 -15.226  1.00 48.23           O  
ATOM   1441  CB  LYS B  78      -5.537  47.827 -16.746  1.00 53.53           C  
ATOM   1442  CG  LYS B  78      -5.597  49.239 -17.252  1.00 57.54           C  
ATOM   1443  CD  LYS B  78      -6.411  49.245 -18.517  1.00 61.82           C  
ATOM   1444  CE  LYS B  78      -7.355  50.442 -18.538  1.00 68.02           C  
ATOM   1445  NZ  LYS B  78      -8.409  50.270 -19.603  1.00 74.62           N  
ATOM   1446  N   PRO B  79      -6.249  46.130 -14.125  1.00 47.94           N  
ATOM   1447  CA  PRO B  79      -6.623  44.808 -13.613  1.00 47.14           C  
ATOM   1448  C   PRO B  79      -6.666  43.752 -14.726  1.00 50.56           C  
ATOM   1449  O   PRO B  79      -6.162  42.624 -14.588  1.00 52.24           O  
ATOM   1450  CB  PRO B  79      -7.980  45.074 -12.974  1.00 48.78           C  
ATOM   1451  CG  PRO B  79      -7.790  46.507 -12.402  1.00 40.66           C  
ATOM   1452  CD  PRO B  79      -7.099  47.203 -13.564  1.00 43.24           C  
ATOM   1453  N   GLU B  80      -7.239  44.116 -15.858  1.00 52.71           N  
ATOM   1454  CA  GLU B  80      -7.307  43.154 -16.941  1.00 55.86           C  
ATOM   1455  C   GLU B  80      -5.949  42.725 -17.473  1.00 56.89           C  
ATOM   1456  O   GLU B  80      -5.892  41.867 -18.357  1.00 55.22           O  
ATOM   1457  CB  GLU B  80      -8.134  43.690 -18.112  1.00 59.07           C  
ATOM   1458  CG  GLU B  80      -8.008  45.172 -18.350  1.00 64.44           C  
ATOM   1459  CD  GLU B  80      -8.749  46.006 -17.293  1.00 70.44           C  
ATOM   1460  OE1 GLU B  80      -9.895  45.644 -16.920  1.00 72.40           O  
ATOM   1461  OE2 GLU B  80      -8.189  47.032 -16.850  1.00 73.23           O  
ATOM   1462  N   ASP B  81      -4.861  43.307 -16.956  1.00 56.39           N  
ATOM   1463  CA  ASP B  81      -3.526  42.952 -17.453  1.00 53.00           C  
ATOM   1464  C   ASP B  81      -2.890  41.865 -16.599  1.00 52.07           C  
ATOM   1465  O   ASP B  81      -2.019  41.119 -17.068  1.00 49.78           O  
ATOM   1466  CB  ASP B  81      -2.589  44.166 -17.438  1.00 51.17           C  
ATOM   1467  CG  ASP B  81      -3.005  45.248 -18.413  1.00 57.42           C  
ATOM   1468  OD1 ASP B  81      -3.081  44.948 -19.625  1.00 58.82           O  
ATOM   1469  OD2 ASP B  81      -3.248  46.399 -17.962  1.00 52.69           O  
ATOM   1470  N   VAL B  82      -3.341  41.797 -15.353  1.00 51.20           N  
ATOM   1471  CA  VAL B  82      -2.809  40.866 -14.371  1.00 52.73           C  
ATOM   1472  C   VAL B  82      -2.689  39.432 -14.860  1.00 56.37           C  
ATOM   1473  O   VAL B  82      -1.658  38.779 -14.656  1.00 53.98           O  
ATOM   1474  CB  VAL B  82      -3.679  40.906 -13.091  1.00 53.34           C  
ATOM   1475  CG1 VAL B  82      -3.147  39.937 -12.039  1.00 49.83           C  
ATOM   1476  CG2 VAL B  82      -3.692  42.333 -12.538  1.00 49.36           C  
ATOM   1477  N   ASP B  83      -3.736  38.949 -15.523  1.00 59.65           N  
ATOM   1478  CA  ASP B  83      -3.768  37.572 -15.998  1.00 58.48           C  
ATOM   1479  C   ASP B  83      -2.620  37.227 -16.903  1.00 57.94           C  
ATOM   1480  O   ASP B  83      -1.911  36.242 -16.672  1.00 60.03           O  
ATOM   1481  CB  ASP B  83      -5.072  37.283 -16.715  1.00 64.07           C  
ATOM   1482  CG  ASP B  83      -5.349  35.800 -16.823  1.00 71.82           C  
ATOM   1483  OD1 ASP B  83      -4.713  35.117 -17.667  1.00 71.74           O  
ATOM   1484  OD2 ASP B  83      -6.199  35.320 -16.037  1.00 77.29           O  
ATOM   1485  N   GLU B  84      -2.424  38.042 -17.937  1.00 57.41           N  
ATOM   1486  CA  GLU B  84      -1.341  37.814 -18.882  1.00 50.79           C  
ATOM   1487  C   GLU B  84       0.018  37.875 -18.184  1.00 51.48           C  
ATOM   1488  O   GLU B  84       0.896  37.054 -18.457  1.00 51.27           O  
ATOM   1489  CB  GLU B  84      -1.387  38.844 -20.001  1.00 50.70           C  
ATOM   1490  CG  GLU B  84      -0.187  38.785 -20.911  1.00 49.96           C  
ATOM   1491  CD  GLU B  84      -0.270  39.791 -22.030  1.00 57.17           C  
ATOM   1492  OE1 GLU B  84      -0.963  40.820 -21.836  1.00 56.00           O  
ATOM   1493  OE2 GLU B  84       0.365  39.557 -23.094  1.00 58.94           O  
ATOM   1494  N   ILE B  85       0.203  38.856 -17.304  1.00 45.79           N  
ATOM   1495  CA  ILE B  85       1.465  38.982 -16.581  1.00 45.61           C  
ATOM   1496  C   ILE B  85       1.738  37.720 -15.750  1.00 46.60           C  
ATOM   1497  O   ILE B  85       2.861  37.201 -15.727  1.00 41.67           O  
ATOM   1498  CB  ILE B  85       1.450  40.199 -15.619  1.00 42.12           C  
ATOM   1499  CG1 ILE B  85       1.517  41.515 -16.415  1.00 45.30           C  
ATOM   1500  CG2 ILE B  85       2.610  40.082 -14.622  1.00 38.72           C  
ATOM   1501  CD1 ILE B  85       1.434  42.757 -15.543  1.00 46.94           C  
ATOM   1502  N   VAL B  86       0.707  37.239 -15.059  1.00 48.79           N  
ATOM   1503  CA  VAL B  86       0.836  36.059 -14.211  1.00 52.63           C  
ATOM   1504  C   VAL B  86       1.154  34.796 -15.007  1.00 54.40           C  
ATOM   1505  O   VAL B  86       2.007  33.992 -14.610  1.00 55.64           O  
ATOM   1506  CB  VAL B  86      -0.445  35.845 -13.365  1.00 51.41           C  
ATOM   1507  CG1 VAL B  86      -0.376  34.508 -12.600  1.00 48.09           C  
ATOM   1508  CG2 VAL B  86      -0.557  36.977 -12.332  1.00 48.22           C  
ATOM   1509  N   GLU B  87       0.485  34.640 -16.144  1.00 56.26           N  
ATOM   1510  CA  GLU B  87       0.705  33.470 -16.984  1.00 58.44           C  
ATOM   1511  C   GLU B  87       1.998  33.572 -17.773  1.00 57.63           C  
ATOM   1512  O   GLU B  87       2.901  32.739 -17.634  1.00 56.60           O  
ATOM   1513  CB  GLU B  87      -0.478  33.286 -17.941  1.00 61.48           C  
ATOM   1514  CG  GLU B  87      -1.788  32.866 -17.257  1.00 65.27           C  
ATOM   1515  CD  GLU B  87      -1.697  31.479 -16.604  1.00 71.06           C  
ATOM   1516  OE1 GLU B  87      -1.350  30.509 -17.323  1.00 72.21           O  
ATOM   1517  OE2 GLU B  87      -1.971  31.358 -15.381  1.00 72.07           O  
ATOM   1518  N   LYS B  88       2.084  34.605 -18.612  1.00 58.05           N  
ATOM   1519  CA  LYS B  88       3.253  34.820 -19.449  1.00 55.51           C  
ATOM   1520  C   LYS B  88       4.524  35.094 -18.670  1.00 54.67           C  
ATOM   1521  O   LYS B  88       5.589  34.586 -19.018  1.00 55.10           O  
ATOM   1522  CB  LYS B  88       3.019  35.995 -20.399  1.00 58.34           C  
ATOM   1523  CG  LYS B  88       1.999  35.736 -21.495  1.00 62.01           C  
ATOM   1524  CD  LYS B  88       2.468  34.611 -22.400  1.00 68.65           C  
ATOM   1525  CE  LYS B  88       1.694  34.579 -23.708  1.00 70.64           C  
ATOM   1526  NZ  LYS B  88       2.032  35.732 -24.596  1.00 75.17           N  
ATOM   1527  N   HIS B  89       4.432  35.896 -17.618  1.00 53.77           N  
ATOM   1528  CA  HIS B  89       5.645  36.239 -16.874  1.00 53.52           C  
ATOM   1529  C   HIS B  89       5.885  35.427 -15.605  1.00 51.37           C  
ATOM   1530  O   HIS B  89       6.836  34.654 -15.553  1.00 56.99           O  
ATOM   1531  CB  HIS B  89       5.660  37.754 -16.563  1.00 46.85           C  
ATOM   1532  CG  HIS B  89       6.916  38.240 -15.885  1.00 51.11           C  
ATOM   1533  ND1 HIS B  89       7.077  39.551 -15.496  1.00 51.24           N  
ATOM   1534  CD2 HIS B  89       8.047  37.592 -15.518  1.00 51.34           C  
ATOM   1535  CE1 HIS B  89       8.261  39.695 -14.909  1.00 50.93           C  
ATOM   1536  NE2 HIS B  89       8.870  38.516 -14.913  1.00 51.72           N  
ATOM   1537  N   LEU B  90       5.055  35.593 -14.578  1.00 50.91           N  
ATOM   1538  CA  LEU B  90       5.281  34.859 -13.334  1.00 53.14           C  
ATOM   1539  C   LEU B  90       5.447  33.353 -13.565  1.00 56.62           C  
ATOM   1540  O   LEU B  90       6.274  32.725 -12.912  1.00 59.02           O  
ATOM   1541  CB  LEU B  90       4.162  35.142 -12.338  1.00 52.07           C  
ATOM   1542  CG  LEU B  90       3.942  36.646 -12.092  1.00 48.67           C  
ATOM   1543  CD1 LEU B  90       2.895  36.854 -11.008  1.00 43.39           C  
ATOM   1544  CD2 LEU B  90       5.258  37.288 -11.665  1.00 42.85           C  
ATOM   1545  N   LYS B  91       4.683  32.771 -14.490  1.00 56.69           N  
ATOM   1546  CA  LYS B  91       4.837  31.344 -14.802  1.00 59.14           C  
ATOM   1547  C   LYS B  91       5.785  31.097 -15.979  1.00 57.71           C  
ATOM   1548  O   LYS B  91       6.796  30.412 -15.828  1.00 58.31           O  
ATOM   1549  CB  LYS B  91       3.491  30.696 -15.108  1.00 57.69           C  
ATOM   1550  CG  LYS B  91       2.701  30.357 -13.872  1.00 59.85           C  
ATOM   1551  CD  LYS B  91       1.683  29.262 -14.141  1.00 63.26           C  
ATOM   1552  CE  LYS B  91       0.295  29.822 -14.367  1.00 67.13           C  
ATOM   1553  NZ  LYS B  91      -0.714  28.735 -14.474  1.00 70.09           N  
ATOM   1554  N   GLY B  92       5.473  31.668 -17.135  1.00 58.07           N  
ATOM   1555  CA  GLY B  92       6.320  31.485 -18.307  1.00 57.44           C  
ATOM   1556  C   GLY B  92       7.689  32.159 -18.285  1.00 59.67           C  
ATOM   1557  O   GLY B  92       8.499  31.942 -19.198  1.00 59.33           O  
ATOM   1558  N   GLY B  93       7.948  32.990 -17.276  1.00 60.06           N  
ATOM   1559  CA  GLY B  93       9.242  33.661 -17.165  1.00 57.79           C  
ATOM   1560  C   GLY B  93       9.566  34.618 -18.298  1.00 58.71           C  
ATOM   1561  O   GLY B  93      10.728  34.951 -18.560  1.00 60.24           O  
ATOM   1562  N   GLU B  94       8.526  35.099 -18.957  1.00 57.85           N  
ATOM   1563  CA  GLU B  94       8.679  36.008 -20.083  1.00 55.77           C  
ATOM   1564  C   GLU B  94       7.885  37.318 -19.880  1.00 54.68           C  
ATOM   1565  O   GLU B  94       6.656  37.341 -20.000  1.00 50.95           O  
ATOM   1566  CB  GLU B  94       8.204  35.265 -21.323  1.00 57.14           C  
ATOM   1567  CG  GLU B  94       7.992  36.093 -22.559  1.00 58.31           C  
ATOM   1568  CD  GLU B  94       7.020  35.411 -23.530  0.10 55.83           C  
ATOM   1569  OE1 GLU B  94       5.847  35.200 -23.129  0.10 55.03           O  
ATOM   1570  OE2 GLU B  94       7.446  35.091 -24.667  0.10 54.78           O  
ATOM   1571  N   PRO B  95       8.581  38.429 -19.587  1.00 52.32           N  
ATOM   1572  CA  PRO B  95       7.940  39.738 -19.368  1.00 52.02           C  
ATOM   1573  C   PRO B  95       6.996  40.231 -20.471  1.00 50.40           C  
ATOM   1574  O   PRO B  95       7.246  40.056 -21.659  1.00 52.22           O  
ATOM   1575  CB  PRO B  95       9.128  40.676 -19.168  1.00 49.50           C  
ATOM   1576  CG  PRO B  95      10.177  39.759 -18.541  1.00 48.94           C  
ATOM   1577  CD  PRO B  95      10.043  38.518 -19.409  1.00 47.93           C  
ATOM   1578  N   VAL B  96       5.895  40.838 -20.066  1.00 50.55           N  
ATOM   1579  CA  VAL B  96       4.916  41.356 -21.010  1.00 49.08           C  
ATOM   1580  C   VAL B  96       5.502  42.690 -21.438  1.00 54.40           C  
ATOM   1581  O   VAL B  96       5.274  43.735 -20.784  1.00 53.23           O  
ATOM   1582  CB  VAL B  96       3.575  41.604 -20.307  1.00 47.61           C  
ATOM   1583  CG1 VAL B  96       2.534  42.011 -21.320  1.00 49.48           C  
ATOM   1584  CG2 VAL B  96       3.141  40.357 -19.560  1.00 45.93           C  
ATOM   1585  N   GLU B  97       6.263  42.656 -22.540  1.00 53.86           N  
ATOM   1586  CA  GLU B  97       6.925  43.856 -23.024  1.00 53.46           C  
ATOM   1587  C   GLU B  97       6.053  45.086 -23.269  1.00 52.21           C  
ATOM   1588  O   GLU B  97       6.531  46.210 -23.107  1.00 52.73           O  
ATOM   1589  CB  GLU B  97       7.721  43.544 -24.287  1.00 55.00           C  
ATOM   1590  CG  GLU B  97       8.957  42.683 -24.045  1.00 59.31           C  
ATOM   1591  CD  GLU B  97       9.993  43.341 -23.090  1.00 65.57           C  
ATOM   1592  OE1 GLU B  97      10.287  44.563 -23.260  1.00 66.08           O  
ATOM   1593  OE2 GLU B  97      10.501  42.613 -22.189  1.00 64.32           O  
ATOM   1594  N   ARG B  98       4.790  44.914 -23.633  1.00 51.10           N  
ATOM   1595  CA  ARG B  98       3.978  46.105 -23.889  1.00 51.99           C  
ATOM   1596  C   ARG B  98       3.755  46.975 -22.659  1.00 49.29           C  
ATOM   1597  O   ARG B  98       3.373  48.134 -22.794  1.00 50.92           O  
ATOM   1598  CB  ARG B  98       2.620  45.746 -24.510  1.00 52.85           C  
ATOM   1599  CG  ARG B  98       1.589  45.270 -23.525  1.00 57.60           C  
ATOM   1600  CD  ARG B  98       0.325  44.783 -24.216  1.00 57.08           C  
ATOM   1601  NE  ARG B  98      -0.504  44.038 -23.276  1.00 59.53           N  
ATOM   1602  CZ  ARG B  98      -1.208  44.598 -22.294  1.00 59.52           C  
ATOM   1603  NH1 ARG B  98      -1.195  45.917 -22.133  1.00 59.60           N  
ATOM   1604  NH2 ARG B  98      -1.901  43.838 -21.461  1.00 55.67           N  
ATOM   1605  N   LEU B  99       4.002  46.436 -21.463  1.00 48.39           N  
ATOM   1606  CA  LEU B  99       3.802  47.205 -20.239  1.00 42.87           C  
ATOM   1607  C   LEU B  99       5.089  47.562 -19.516  1.00 41.42           C  
ATOM   1608  O   LEU B  99       5.069  48.355 -18.574  1.00 43.15           O  
ATOM   1609  CB  LEU B  99       2.889  46.452 -19.266  1.00 42.98           C  
ATOM   1610  CG  LEU B  99       1.444  46.266 -19.725  1.00 46.55           C  
ATOM   1611  CD1 LEU B  99       0.653  45.442 -18.685  1.00 42.04           C  
ATOM   1612  CD2 LEU B  99       0.805  47.659 -19.918  1.00 48.96           C  
ATOM   1613  N   VAL B 100       6.207  46.999 -19.951  1.00 40.69           N  
ATOM   1614  CA  VAL B 100       7.492  47.272 -19.308  1.00 42.70           C  
ATOM   1615  C   VAL B 100       7.937  48.751 -19.439  1.00 45.83           C  
ATOM   1616  O   VAL B 100       7.954  49.328 -20.529  1.00 45.84           O  
ATOM   1617  CB  VAL B 100       8.614  46.378 -19.911  1.00 40.00           C  
ATOM   1618  CG1 VAL B 100       9.912  46.725 -19.284  1.00 37.33           C  
ATOM   1619  CG2 VAL B 100       8.315  44.885 -19.684  1.00 41.44           C  
ATOM   1620  N   ILE B 101       8.313  49.361 -18.329  1.00 42.76           N  
ATOM   1621  CA  ILE B 101       8.761  50.732 -18.375  1.00 47.82           C  
ATOM   1622  C   ILE B 101      10.256  50.847 -18.011  1.00 49.67           C  
ATOM   1623  O   ILE B 101      10.856  51.913 -18.133  1.00 47.60           O  
ATOM   1624  CB  ILE B 101       7.950  51.618 -17.394  1.00 46.52           C  
ATOM   1625  CG1 ILE B 101       8.104  51.091 -15.970  1.00 41.34           C  
ATOM   1626  CG2 ILE B 101       6.479  51.651 -17.789  1.00 50.05           C  
ATOM   1627  CD1 ILE B 101       7.331  51.945 -14.937  1.00 38.54           C  
ATOM   1628  N   SER B 102      10.853  49.755 -17.564  1.00 45.47           N  
ATOM   1629  CA  SER B 102      12.259  49.812 -17.188  1.00 48.65           C  
ATOM   1630  C   SER B 102      12.672  48.443 -16.704  1.00 46.86           C  
ATOM   1631  O   SER B 102      11.817  47.665 -16.266  1.00 47.04           O  
ATOM   1632  CB  SER B 102      12.470  50.837 -16.064  1.00 48.06           C  
ATOM   1633  OG  SER B 102      13.856  51.002 -15.759  1.00 52.87           O  
ATOM   1634  N   LYS B 103      13.968  48.161 -16.791  1.00 46.74           N  
ATOM   1635  CA  LYS B 103      14.526  46.877 -16.356  1.00 48.70           C  
ATOM   1636  C   LYS B 103      15.821  47.059 -15.590  1.00 47.91           C  
ATOM   1637  O   LYS B 103      16.627  47.912 -15.925  1.00 48.17           O  
ATOM   1638  CB  LYS B 103      14.783  45.964 -17.558  1.00 49.48           C  
ATOM   1639  CG  LYS B 103      13.501  45.509 -18.238  1.00 55.57           C  
ATOM   1640  CD  LYS B 103      13.736  44.438 -19.309  1.00 55.49           C  
ATOM   1641  CE  LYS B 103      12.407  44.040 -19.914  1.00 57.75           C  
ATOM   1642  NZ  LYS B 103      12.580  43.174 -21.106  1.00 63.77           N  
ATOM   1643  N   GLY B 104      16.017  46.250 -14.550  1.00 48.65           N  
ATOM   1644  CA  GLY B 104      17.234  46.338 -13.772  1.00 48.62           C  
ATOM   1645  C   GLY B 104      17.282  47.550 -12.881  1.00 48.68           C  
ATOM   1646  O   GLY B 104      17.970  47.555 -11.870  1.00 54.14           O  
ATOM   1647  N   LYS B 105      16.554  48.600 -13.226  1.00 47.89           N  
ATOM   1648  CA  LYS B 105      16.579  49.784 -12.382  1.00 46.95           C  
ATOM   1649  C   LYS B 105      15.295  50.582 -12.575  1.00 47.17           C  
ATOM   1650  O   LYS B 105      14.575  50.402 -13.562  1.00 47.31           O  
ATOM   1651  CB  LYS B 105      17.789  50.672 -12.740  1.00 48.02           C  
ATOM   1652  CG  LYS B 105      19.169  50.061 -12.484  0.10 44.84           C  
ATOM   1653  CD  LYS B 105      20.284  51.042 -12.850  0.10 44.19           C  
ATOM   1654  CE  LYS B 105      21.659  50.466 -12.547  0.10 43.69           C  
ATOM   1655  NZ  LYS B 105      22.756  51.420 -12.865  0.10 42.84           N  
ATOM   1656  N   PRO B 106      14.990  51.493 -11.648  1.00 46.08           N  
ATOM   1657  CA  PRO B 106      13.766  52.289 -11.789  1.00 52.03           C  
ATOM   1658  C   PRO B 106      13.807  53.173 -13.040  1.00 53.14           C  
ATOM   1659  O   PRO B 106      14.876  53.401 -13.622  1.00 55.77           O  
ATOM   1660  CB  PRO B 106      13.748  53.155 -10.520  1.00 49.20           C  
ATOM   1661  CG  PRO B 106      14.536  52.366  -9.536  1.00 46.50           C  
ATOM   1662  CD  PRO B 106      15.679  51.805 -10.388  1.00 49.51           C  
ATOM   1663  N   PRO B 107      12.639  53.676 -13.465  1.00 53.86           N  
ATOM   1664  CA  PRO B 107      12.541  54.549 -14.643  1.00 53.40           C  
ATOM   1665  C   PRO B 107      13.134  55.912 -14.261  1.00 55.35           C  
ATOM   1666  O   PRO B 107      12.707  56.526 -13.279  1.00 53.39           O  
ATOM   1667  CB  PRO B 107      11.028  54.669 -14.882  1.00 53.16           C  
ATOM   1668  CG  PRO B 107      10.406  53.514 -14.085  1.00 46.04           C  
ATOM   1669  CD  PRO B 107      11.305  53.351 -12.914  1.00 48.25           C  
ATOM   1670  N   GLY B 108      14.115  56.388 -15.025  1.00 59.26           N  
ATOM   1671  CA  GLY B 108      14.708  57.683 -14.721  1.00 61.04           C  
ATOM   1672  C   GLY B 108      16.042  57.616 -13.987  1.00 62.60           C  
ATOM   1673  O   GLY B 108      16.822  58.575 -13.983  1.00 61.69           O  
ATOM   1674  N   MET B 109      16.317  56.489 -13.348  1.00 63.79           N  
ATOM   1675  CA  MET B 109      17.575  56.361 -12.630  1.00 64.25           C  
ATOM   1676  C   MET B 109      18.674  55.986 -13.611  1.00 62.03           C  
ATOM   1677  O   MET B 109      18.441  55.282 -14.582  1.00 59.69           O  
ATOM   1678  CB  MET B 109      17.480  55.299 -11.531  1.00 65.56           C  
ATOM   1679  CG  MET B 109      18.770  55.152 -10.719  1.00 68.88           C  
ATOM   1680  SD  MET B 109      18.738  53.873  -9.428  1.00 71.77           S  
ATOM   1681  CE  MET B 109      18.049  54.774  -8.067  1.00 69.96           C  
ATOM   1682  N   PHE B 110      19.873  56.478 -13.356  1.00 64.67           N  
ATOM   1683  CA  PHE B 110      20.996  56.175 -14.224  1.00 67.58           C  
ATOM   1684  C   PHE B 110      21.634  54.853 -13.792  1.00 66.65           C  
ATOM   1685  O   PHE B 110      21.758  53.956 -14.655  1.00 67.82           O  
ATOM   1686  CB  PHE B 110      22.028  57.301 -14.151  1.00 65.69           C  
ATOM   1687  CG  PHE B 110      23.115  57.181 -15.171  1.00 66.54           C  
ATOM   1688  CD1 PHE B 110      22.834  57.384 -16.516  1.00 63.78           C  
ATOM   1689  CD2 PHE B 110      24.420  56.844 -14.794  1.00 63.34           C  
ATOM   1690  CE1 PHE B 110      23.833  57.253 -17.472  1.00 63.92           C  
ATOM   1691  CE2 PHE B 110      25.418  56.715 -15.754  1.00 62.29           C  
ATOM   1692  CZ  PHE B 110      25.120  56.919 -17.089  1.00 60.34           C  
ATOM   1693  OXT PHE B 110      22.003  54.744 -12.598  1.00 68.40           O  
TER    1694      PHE B 110                                                      
END
MOLECULE T0506_174_254.pdb
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
