
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  943),  selected  126 , name 2hti_A
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 2hti_A.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    10_A      V       4           -
LGA    -       -      A       5           -
LGA    -       -      P       6           -
LGA    -       -      P       7           -
LGA    -       -      V       8           -
LGA    -       -      I       9           -
LGA    -       -      T      10           -
LGA    -       -      P      11           -
LGA    -       -      R      12           -
LGA    -       -      F      24           -
LGA    C    11_A      E      25          5.049
LGA    K    12_A      A      26          1.671
LGA    D    13_A      V      27          2.576
LGA    E    14_A      R      28          3.254
LGA    K    15_A      -       -           -
LGA    K    16_A      V      29          3.357
LGA    I    17_A      A      30          2.470
LGA    T    18_A      R      31          2.475
LGA    E    19_A      D      32          2.690
LGA    F    20_A      V      33          2.153
LGA    L    21_A      L      34          2.062
LGA    N    22_A      H      35          2.175
LGA    K    23_A      T      36          1.948
LGA    A    24_A      S      37          1.403
LGA    R    25_A      R      38          1.709
LGA    T    26_A      T      39          0.647
LGA    G    27_A      A      40          0.359
LGA    F    28_A      A      41          0.747
LGA    L    29_A      L      42          0.492
LGA    G    30_A      A      43          0.409
LGA    L    31_A      T      44          0.929
LGA    S    32_A      L      45          1.315
LGA    T    33_A      D      46          2.250
LGA    -       -      P      47           -
LGA    -       -      V      48           -
LGA    N    34_A      S      49          3.489
LGA    D    35_A      G      50          2.414
LGA    Q    36_A      Y      51          1.141
LGA    P    37_A      P      52          1.297
LGA    Y    38_A      Y      53          0.749
LGA    V    39_A      T      54          0.509
LGA    I    40_A      T      55          0.200
LGA    P    41_A      A      56          0.209
LGA    L    42_A      T      57          0.198
LGA    N    43_A      N      58          0.734
LGA    F    44_A      I      59          1.307
LGA    V    45_A      G      60          1.227
LGA    W    46_A      I      61          2.472
LGA    H    47_A      E      62          2.157
LGA    -       -      P      63           -
LGA    N    48_A      D      64          3.206
LGA    H    49_A      G      65          4.417
LGA    A    50_A      T      66          2.469
LGA    I    51_A      P      67          1.922
LGA    Y    52_A      F      68          0.894
LGA    F    53_A      F      69          1.050
LGA    H    54_A      F      70          1.834
LGA    G    55_A      A      71          1.929
LGA    A    56_A      A      72          1.350
LGA    S    57_A      G      73          1.815
LGA    E    58_A      L      74          2.171
LGA    G    59_A      T      75          2.059
LGA    R    60_A      L      76          1.139
LGA    K    61_A      H      77          1.253
LGA    I    62_A      A      78          2.038
LGA    K    63_A      R      79          1.880
LGA    X    64_A      N      80          1.030
LGA    I    65_A      M      81          1.053
LGA    E    66_A      E      82          1.637
LGA    A    67_A      T      83          1.546
LGA    N    68_A      D      84          1.310
LGA    P    69_A      A      85          0.785
LGA    E    70_A      R      86          0.482
LGA    V    71_A      I      87          0.579
LGA    C    72_A      S      88          0.406
LGA    F    73_A      V      89          0.560
LGA    T    74_A      T      90          0.763
LGA    I    75_A      L      91          1.419
LGA    C    76_A      A      92          2.049
LGA    E    77_A      P      93          2.418
LGA    -       -      F      94           -
LGA    -       -      G      95           -
LGA    D    78_A      K      96          3.770
LGA    L    79_A      G      97           -
LGA    -       -      D      98           -
LGA    -       -      A      99           -
LGA    -       -      L     100           -
LGA    A    93_A      T     101          4.455
LGA    Y    94_A      L     102          1.260
LGA    X    95_A      P     103          0.770
LGA    S    96_A      R     104          0.263
LGA    V    97_A      L     105          0.365
LGA    I    98_A      T     106          0.294
LGA    I    99_A      L     107          0.456
LGA    F   100_A      V     108          0.446
LGA    G   101_A      G     109          0.504
LGA    T   102_A      R     110          0.425
LGA    I   103_A      A     111          0.538
LGA    E   104_A      D     112          2.263
LGA    P   105_A      R     113          1.584
LGA    V   106_A      I     114          0.986
LGA    S   107_A      G     115          0.970
LGA    A   108_A      P     116          4.644
LGA    I   109_A      D     117          1.640
LGA    E   110_A      E     118          3.025
LGA    E   111_A      -       -           -
LGA    G   112_A      V     119          2.860
LGA    T   113_A      P     120          3.021
LGA    E   114_A      L     121          2.957
LGA    A   115_A      A     122          2.624
LGA    X   116_A      I     123          2.232
LGA    Q   117_A      A     124          2.068
LGA    Q   118_A      R     125          2.025
LGA    X   119_A      Y     126          1.749
LGA    L   120_A      I     127          1.885
LGA    D   121_A      A     128          1.863
LGA    K   122_A      R     129          1.947
LGA    Y   123_A      Y     130          2.706
LGA    V   124_A      P     131          3.470
LGA    P   125_A      K     132           -
LGA    -       -      A     133           -
LGA    -       -      K     134           -
LGA    -       -      L     135           -
LGA    S   143_A      Y     136          2.914
LGA    L   144_A      L     137           #
LGA    -       -      S     138           -
LGA    G   145_A      L     139          2.167
LGA    S   146_A      P     140          1.489
LGA    R   147_A      D     141          1.273
LGA    T   148_A      T     142          1.010
LGA    A   149_A      R     143          1.898
LGA    I   150_A      L     144          1.018
LGA    Y   151_A      Y     145          1.212
LGA    K   152_A      R     146          1.402
LGA    I   153_A      L     147          1.433
LGA    S   154_A      R     148          0.850
LGA    C   155_A      T     149          1.113
LGA    R   156_A      E     150          1.400
LGA    E   157_A      G     151          1.475
LGA    R   158_A      V     152          1.592
LGA    T   159_A      Q     153          1.613
LGA    A   160_A      I     154          1.063
LGA    K   161_A      N     155          1.428
LGA    V   162_A      G     156          2.054
LGA    N   163_A      S     163           -
LGA    E   164_A      N     164           -
LGA    P   165_A      I     165           -
LGA    -       -      T     166           -
LGA    -       -      P     167           -
LGA    -       -      A     168           -
LGA    -       -      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -
LGA    -       -      S     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      E     179           -
LGA    -       -      L     180           -
LGA    -       -      M     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      A     184           -
LGA    -       -      E     185           -
LGA    -       -      S     186           -
LGA    -       -      E     187           -
LGA    -       -      A     188           -
LGA    -       -      T     189           -
LGA    -       -      R     190           -
LGA    -       -      L     191           -
LGA    -       -      N     192           -
LGA    -       -      A     193           -
LGA    -       -      I     194           -
LGA    -       -      K     195           -
LGA    -       -      G     196           -
LGA    -       -      E     197           -
LGA    -       -      A     198           -
LGA    -       -      S     199           -
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    -       -      I     214           -
LGA    -       -      T     215           -
LGA    -       -      S     216           -
LGA    -       -      I     217           -
LGA    -       -      D     218           -
LGA    -       -      P     219           -
LGA    -       -      D     220           -
LGA    -       -      G     221           -
LGA    -       -      I     222           -
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      W     234           -
LGA    -       -      F     235           -
LGA    -       -      A     236           -
LGA    -       -      E     237           -
LGA    -       -      R     238           -
LGA    -       -      V     239           -
LGA    -       -      E     240           -
LGA    -       -      T     241           -
LGA    -       -      L     242           -
LGA    -       -      K     243           -
LGA    -       -      Q     244           -
LGA    -       -      F     245           -
LGA    -       -      E     246           -
LGA    -       -      K     247           -
LGA    -       -      A     248           -
LGA    -       -      L     249           -
LGA    -       -      A     250           -
LGA    -       -      Q     251           -
LGA    -       -      L     252           -
LGA    -       -      L     253           -
LGA    -       -      K     254           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  234    5.0    117    1.96    14.53     44.396     5.691

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.497302 * X  +   0.805252 * Y  +  -0.322893 * Z  +   3.894389
  Y_new =   0.840317 * X  +  -0.354509 * Y  +   0.410111 * Z  +   5.914092
  Z_new =   0.215775 * X  +  -0.475281 * Y  +  -0.852965 * Z  +  66.063492 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.633230    0.508362  [ DEG:  -150.8730     29.1270 ]
  Theta =  -0.217486   -2.924107  [ DEG:   -12.4610   -167.5390 ]
  Phi   =   1.036426   -2.105166  [ DEG:    59.3828   -120.6172 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hti_A                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hti_A.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  234   5.0  117   1.96   14.53  44.396
REMARK  ---------------------------------------------------------- 
MOLECULE 2hti_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUL-06   2HTI              
TITLE     CRYSTAL STRUCTURE OF BH0577 (10173191) FROM BACILLUS                  
TITLE    2 HALODURANS AT 2.50 A RESOLUTION                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH0577 PROTEIN;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: 10173191;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    10173191, BH0577, STRUCTURAL GENOMICS, JOINT CENTER FOR               
KEYWDS   2 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   3 PSI-2                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   01-AUG-06 2HTI    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF BH0577 (10173191) FROM                  
JRNL        TITL 2 BACILLUS HALODURANS AT 2.50 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2HTI A    1   184  UNP    Q9KFA8   Q9KFA8_BACHD     1    184             
SEQRES   1 A  185  GLY MSE ASN ALA ILE ARG TYR THR LYS ARG GLU CYS LYS          
SEQRES   2 A  185  ASP GLU LYS LYS ILE THR GLU PHE LEU ASN LYS ALA ARG          
SEQRES   3 A  185  THR GLY PHE LEU GLY LEU SER THR ASN ASP GLN PRO TYR          
SEQRES   4 A  185  VAL ILE PRO LEU ASN PHE VAL TRP HIS ASN HIS ALA ILE          
SEQRES   5 A  185  TYR PHE HIS GLY ALA SER GLU GLY ARG LYS ILE LYS MSE          
SEQRES   6 A  185  ILE GLU ALA ASN PRO GLU VAL CYS PHE THR ILE CYS GLU          
SEQRES   7 A  185  ASP LEU GLY THR ILE VAL SER PRO VAL PRO ALA HIS THR          
SEQRES   8 A  185  ASP THR ALA TYR MSE SER VAL ILE ILE PHE GLY THR ILE          
SEQRES   9 A  185  GLU PRO VAL SER ALA ILE GLU GLU GLY THR GLU ALA MSE          
SEQRES  10 A  185  GLN GLN MSE LEU ASP LYS TYR VAL PRO GLY TYR TYR HIS          
SEQRES  11 A  185  SER PRO LEU ALA ALA SER HIS VAL GLU LYS TYR ARG SER          
SEQRES  12 A  185  SER LEU GLY SER ARG THR ALA ILE TYR LYS ILE SER CYS          
SEQRES  13 A  185  ARG GLU ARG THR ALA LYS VAL ASN GLU PRO ILE GLU SER          
SEQRES  14 A  185  LEU LYS PHE TYR PRO GLY ARG ASN VAL SER VAL ASP LYS          
SEQRES  15 A  185  ASP SER ARG                                                  
HET    MSE  A  64       8                                                       
HET    MSE  A  95       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 119       8                                                       
HET     NA      1       1                                                       
HET    FAD  A 200      53                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2   NA    NA 1+                                                        
FORMUL   3  FAD    C27 H33 N9 O15 P2                                            
FORMUL   4  HOH   *20(H2 O)                                                     
CRYST1   72.170   72.170  129.981  90.00  90.00 120.00 P 61 2 2     12          
ATOM      1  N   GLU A  10      28.477  50.477  -1.546  1.00106.20           N  
ATOM      2  CA  GLU A  10      27.768  51.794  -1.450  1.00106.19           C  
ATOM      3  C   GLU A  10      26.554  51.815  -2.387  1.00106.34           C  
ATOM      4  O   GLU A  10      26.272  52.823  -3.039  1.00106.69           O  
ATOM      5  CB  GLU A  10      28.730  52.942  -1.772  1.00105.97           C  
ATOM      6  N   CYS A  11      25.830  50.696  -2.394  1.00106.15           N  
ATOM      7  CA  CYS A  11      24.784  50.369  -3.376  1.00106.08           C  
ATOM      8  C   CYS A  11      23.646  51.397  -3.582  1.00105.37           C  
ATOM      9  O   CYS A  11      23.371  52.236  -2.721  1.00105.45           O  
ATOM     10  CB  CYS A  11      24.184  49.008  -2.999  1.00105.85           C  
ATOM     11  SG  CYS A  11      22.621  48.627  -3.793  1.00110.64           S  
ATOM     12  N   LYS A  12      22.986  51.306  -4.742  1.00104.39           N  
ATOM     13  CA  LYS A  12      21.912  52.225  -5.115  1.00102.74           C  
ATOM     14  C   LYS A  12      20.984  51.662  -6.198  1.00101.36           C  
ATOM     15  O   LYS A  12      20.639  52.367  -7.147  1.00102.19           O  
ATOM     16  N   ASP A  13      20.578  50.399  -6.038  1.00 99.58           N  
ATOM     17  CA  ASP A  13      19.627  49.732  -6.947  1.00 97.59           C  
ATOM     18  C   ASP A  13      18.269  49.523  -6.251  1.00 94.36           C  
ATOM     19  O   ASP A  13      18.038  48.495  -5.603  1.00 92.79           O  
ATOM     20  CB  ASP A  13      20.201  48.387  -7.414  1.00 98.54           C  
ATOM     21  CG  ASP A  13      19.442  47.793  -8.596  1.00102.27           C  
ATOM     22  OD1 ASP A  13      18.256  47.424  -8.437  1.00105.84           O  
ATOM     23  OD2 ASP A  13      20.049  47.681  -9.686  1.00110.00           O  
ATOM     24  N   GLU A  14      17.374  50.497  -6.416  1.00 91.08           N  
ATOM     25  CA  GLU A  14      16.113  50.564  -5.670  1.00 88.59           C  
ATOM     26  C   GLU A  14      15.304  49.256  -5.641  1.00 86.48           C  
ATOM     27  O   GLU A  14      14.570  49.015  -4.686  1.00 86.53           O  
ATOM     28  CB  GLU A  14      15.242  51.714  -6.210  1.00 88.64           C  
ATOM     29  CG  GLU A  14      14.107  52.167  -5.283  1.00 88.28           C  
ATOM     30  N   LYS A  15      15.422  48.419  -6.668  1.00 84.16           N  
ATOM     31  CA  LYS A  15      14.642  47.171  -6.713  1.00 82.48           C  
ATOM     32  C   LYS A  15      15.275  46.077  -5.852  1.00 80.13           C  
ATOM     33  O   LYS A  15      14.579  45.328  -5.166  1.00 78.31           O  
ATOM     34  CB  LYS A  15      14.486  46.670  -8.153  1.00 82.71           C  
ATOM     35  N   LYS A  16      16.600  45.987  -5.903  1.00 78.28           N  
ATOM     36  CA  LYS A  16      17.344  45.026  -5.086  1.00 76.50           C  
ATOM     37  C   LYS A  16      17.092  45.277  -3.581  1.00 73.78           C  
ATOM     38  O   LYS A  16      16.827  44.338  -2.810  1.00 70.67           O  
ATOM     39  CB  LYS A  16      18.846  45.119  -5.418  1.00 76.85           C  
ATOM     40  CG  LYS A  16      19.670  43.884  -5.046  1.00 75.75           C  
ATOM     41  N   ILE A  17      17.158  46.553  -3.189  1.00 71.84           N  
ATOM     42  CA  ILE A  17      16.959  46.979  -1.802  1.00 70.21           C  
ATOM     43  C   ILE A  17      15.562  46.639  -1.320  1.00 69.75           C  
ATOM     44  O   ILE A  17      15.371  46.105  -0.224  1.00 68.93           O  
ATOM     45  CB  ILE A  17      17.121  48.479  -1.650  1.00 69.07           C  
ATOM     46  CG1 ILE A  17      18.524  48.912  -2.061  1.00 73.08           C  
ATOM     47  CG2 ILE A  17      16.880  48.879  -0.208  1.00 71.60           C  
ATOM     48  CD1 ILE A  17      18.668  50.418  -2.260  1.00 77.33           C  
ATOM     49  N   THR A  18      14.584  46.957  -2.151  1.00 69.14           N  
ATOM     50  CA  THR A  18      13.200  46.687  -1.827  1.00 69.04           C  
ATOM     51  C   THR A  18      12.984  45.201  -1.645  1.00 66.96           C  
ATOM     52  O   THR A  18      12.311  44.769  -0.705  1.00 69.13           O  
ATOM     53  CB  THR A  18      12.272  47.181  -2.947  1.00 70.06           C  
ATOM     54  OG1 THR A  18      12.568  48.553  -3.239  1.00 73.59           O  
ATOM     55  CG2 THR A  18      10.805  47.038  -2.535  1.00 73.88           C  
ATOM     56  N   GLU A  19      13.539  44.412  -2.551  1.00 64.81           N  
ATOM     57  CA  GLU A  19      13.403  42.965  -2.444  1.00 64.20           C  
ATOM     58  C   GLU A  19      13.988  42.529  -1.103  1.00 62.86           C  
ATOM     59  O   GLU A  19      13.380  41.749  -0.365  1.00 63.50           O  
ATOM     60  CB  GLU A  19      14.097  42.250  -3.614  1.00 64.20           C  
ATOM     61  CG  GLU A  19      13.882  40.727  -3.628  1.00 67.11           C  
ATOM     62  N   PHE A  20      15.164  43.064  -0.785  1.00 61.31           N  
ATOM     63  CA  PHE A  20      15.827  42.763   0.477  1.00 60.13           C  
ATOM     64  C   PHE A  20      14.948  43.158   1.672  1.00 58.24           C  
ATOM     65  O   PHE A  20      14.725  42.353   2.574  1.00 57.21           O  
ATOM     66  CB  PHE A  20      17.182  43.482   0.529  1.00 60.99           C  
ATOM     67  CG  PHE A  20      17.901  43.324   1.833  1.00 61.98           C  
ATOM     68  CD1 PHE A  20      18.486  42.111   2.168  1.00 62.54           C  
ATOM     69  CD2 PHE A  20      18.000  44.393   2.725  1.00 64.56           C  
ATOM     70  CE1 PHE A  20      19.152  41.956   3.371  1.00 63.79           C  
ATOM     71  CE2 PHE A  20      18.668  44.251   3.929  1.00 61.90           C  
ATOM     72  CZ  PHE A  20      19.244  43.033   4.256  1.00 64.38           C  
ATOM     73  N   LEU A  21      14.429  44.385   1.661  1.00 56.90           N  
ATOM     74  CA  LEU A  21      13.579  44.869   2.762  1.00 57.36           C  
ATOM     75  C   LEU A  21      12.293  44.074   2.920  1.00 57.68           C  
ATOM     76  O   LEU A  21      11.722  44.024   4.009  1.00 57.28           O  
ATOM     77  CB  LEU A  21      13.238  46.338   2.575  1.00 57.17           C  
ATOM     78  CG  LEU A  21      14.446  47.268   2.703  1.00 58.07           C  
ATOM     79  CD1 LEU A  21      14.116  48.653   2.191  1.00 58.30           C  
ATOM     80  CD2 LEU A  21      14.926  47.328   4.143  1.00 60.25           C  
ATOM     81  N   ASN A  22      11.837  43.446   1.840  1.00 58.37           N  
ATOM     82  CA  ASN A  22      10.635  42.646   1.908  1.00 59.25           C  
ATOM     83  C   ASN A  22      10.923  41.298   2.514  1.00 59.04           C  
ATOM     84  O   ASN A  22      10.071  40.722   3.173  1.00 59.87           O  
ATOM     85  CB  ASN A  22      10.016  42.479   0.515  1.00 61.97           C  
ATOM     86  CG  ASN A  22       9.411  43.788  -0.031  1.00 67.69           C  
ATOM     87  OD1 ASN A  22       8.955  44.652   0.727  1.00 70.67           O  
ATOM     88  ND2 ASN A  22       9.402  43.923  -1.355  1.00 69.75           N  
ATOM     89  N   LYS A  23      12.135  40.791   2.306  1.00 59.53           N  
ATOM     90  CA  LYS A  23      12.458  39.432   2.740  1.00 58.91           C  
ATOM     91  C   LYS A  23      13.092  39.356   4.127  1.00 55.85           C  
ATOM     92  O   LYS A  23      12.791  38.434   4.886  1.00 55.91           O  
ATOM     93  CB  LYS A  23      13.350  38.747   1.700  1.00 61.10           C  
ATOM     94  CG  LYS A  23      12.638  38.512   0.351  1.00 66.81           C  
ATOM     95  N   ALA A  24      13.951  40.318   4.460  1.00 52.58           N  
ATOM     96  CA  ALA A  24      14.625  40.330   5.767  1.00 52.33           C  
ATOM     97  C   ALA A  24      13.645  40.164   6.936  1.00 53.15           C  
ATOM     98  O   ALA A  24      12.613  40.819   6.984  1.00 53.47           O  
ATOM     99  CB  ALA A  24      15.427  41.599   5.932  1.00 52.04           C  
ATOM    100  N   ARG A  25      13.993  39.278   7.870  1.00 53.96           N  
ATOM    101  CA  ARG A  25      13.119  38.873   8.977  1.00 54.03           C  
ATOM    102  C   ARG A  25      13.176  39.778  10.190  1.00 51.80           C  
ATOM    103  O   ARG A  25      12.200  39.916  10.914  1.00 49.86           O  
ATOM    104  CB  ARG A  25      13.584  37.524   9.492  1.00 56.04           C  
ATOM    105  CG  ARG A  25      13.662  36.430   8.456  1.00 65.71           C  
ATOM    106  CD  ARG A  25      12.535  35.448   8.649  1.00 72.59           C  
ATOM    107  NE  ARG A  25      11.394  35.776   7.815  1.00 76.81           N  
ATOM    108  CZ  ARG A  25      10.188  35.251   7.979  1.00 78.62           C  
ATOM    109  NH1 ARG A  25       9.956  34.386   8.967  1.00 73.33           N  
ATOM    110  NH2 ARG A  25       9.213  35.608   7.164  1.00 82.31           N  
ATOM    111  N   THR A  26      14.354  40.327  10.458  1.00 51.44           N  
ATOM    112  CA  THR A  26      14.595  41.016  11.706  1.00 50.53           C  
ATOM    113  C   THR A  26      15.317  42.311  11.459  1.00 49.25           C  
ATOM    114  O   THR A  26      16.268  42.365  10.681  1.00 49.23           O  
ATOM    115  CB  THR A  26      15.466  40.187  12.626  1.00 50.04           C  
ATOM    116  OG1 THR A  26      14.809  38.962  12.924  1.00 51.20           O  
ATOM    117  CG2 THR A  26      15.718  40.923  13.936  1.00 56.88           C  
ATOM    118  N   GLY A  27      14.865  43.352  12.143  1.00 46.47           N  
ATOM    119  CA  GLY A  27      15.514  44.639  12.060  1.00 44.87           C  
ATOM    120  C   GLY A  27      15.897  45.116  13.440  1.00 43.00           C  
ATOM    121  O   GLY A  27      15.411  44.602  14.456  1.00 42.80           O  
ATOM    122  N   PHE A  28      16.765  46.113  13.476  1.00 41.56           N  
ATOM    123  CA  PHE A  28      17.303  46.592  14.725  1.00 41.69           C  
ATOM    124  C   PHE A  28      17.035  48.061  14.898  1.00 40.25           C  
ATOM    125  O   PHE A  28      17.512  48.892  14.136  1.00 40.01           O  
ATOM    126  CB  PHE A  28      18.785  46.261  14.800  1.00 41.80           C  
ATOM    127  CG  PHE A  28      19.032  44.799  14.985  1.00 43.52           C  
ATOM    128  CD1 PHE A  28      19.006  43.945  13.901  1.00 46.59           C  
ATOM    129  CD2 PHE A  28      19.210  44.273  16.237  1.00 46.70           C  
ATOM    130  CE1 PHE A  28      19.195  42.600  14.062  1.00 44.25           C  
ATOM    131  CE2 PHE A  28      19.405  42.930  16.409  1.00 53.05           C  
ATOM    132  CZ  PHE A  28      19.394  42.086  15.317  1.00 49.61           C  
ATOM    133  N   LEU A  29      16.248  48.363  15.917  1.00 41.22           N  
ATOM    134  CA  LEU A  29      15.754  49.697  16.131  1.00 40.74           C  
ATOM    135  C   LEU A  29      16.634  50.368  17.130  1.00 40.11           C  
ATOM    136  O   LEU A  29      16.766  49.885  18.242  1.00 39.04           O  
ATOM    137  CB  LEU A  29      14.345  49.651  16.682  1.00 41.27           C  
ATOM    138  CG  LEU A  29      13.816  51.036  17.070  1.00 39.12           C  
ATOM    139  CD1 LEU A  29      13.647  51.895  15.833  1.00 36.34           C  
ATOM    140  CD2 LEU A  29      12.484  50.922  17.800  1.00 42.45           C  
ATOM    141  N   GLY A  30      17.234  51.487  16.733  1.00 43.12           N  
ATOM    142  CA  GLY A  30      18.147  52.247  17.606  1.00 42.66           C  
ATOM    143  C   GLY A  30      17.475  53.517  18.076  1.00 43.72           C  
ATOM    144  O   GLY A  30      16.957  54.277  17.265  1.00 46.00           O  
ATOM    145  N   LEU A  31      17.477  53.722  19.390  1.00 45.35           N  
ATOM    146  CA  LEU A  31      16.861  54.877  20.056  1.00 46.57           C  
ATOM    147  C   LEU A  31      17.884  55.493  20.984  1.00 49.61           C  
ATOM    148  O   LEU A  31      18.841  54.828  21.379  1.00 49.74           O  
ATOM    149  CB  LEU A  31      15.692  54.411  20.930  1.00 46.66           C  
ATOM    150  CG  LEU A  31      14.675  53.453  20.316  1.00 47.56           C  
ATOM    151  CD1 LEU A  31      13.651  52.982  21.319  1.00 50.53           C  
ATOM    152  CD2 LEU A  31      13.992  54.156  19.163  1.00 53.75           C  
ATOM    153  N   SER A  32      17.686  56.748  21.362  1.00 53.29           N  
ATOM    154  CA  SER A  32      18.494  57.343  22.421  1.00 56.95           C  
ATOM    155  C   SER A  32      17.719  58.404  23.166  1.00 59.33           C  
ATOM    156  O   SER A  32      16.967  59.177  22.569  1.00 59.67           O  
ATOM    157  CB  SER A  32      19.779  57.969  21.874  1.00 57.45           C  
ATOM    158  OG  SER A  32      19.476  59.113  21.093  1.00 63.51           O  
ATOM    159  N   THR A  33      17.901  58.419  24.482  1.00 62.02           N  
ATOM    160  CA  THR A  33      17.560  59.578  25.297  1.00 64.60           C  
ATOM    161  C   THR A  33      18.793  59.906  26.108  1.00 66.21           C  
ATOM    162  O   THR A  33      19.516  59.010  26.559  1.00 64.71           O  
ATOM    163  CB  THR A  33      16.352  59.355  26.209  1.00 63.83           C  
ATOM    164  OG1 THR A  33      16.548  58.185  27.008  1.00 66.05           O  
ATOM    165  CG2 THR A  33      15.107  59.186  25.374  1.00 66.11           C  
ATOM    166  N   ASN A  34      19.039  61.199  26.265  1.00 69.73           N  
ATOM    167  CA  ASN A  34      20.351  61.667  26.651  1.00 72.43           C  
ATOM    168  C   ASN A  34      21.319  61.156  25.583  1.00 74.54           C  
ATOM    169  O   ASN A  34      20.949  60.999  24.385  1.00 76.17           O  
ATOM    170  CB  ASN A  34      20.730  61.151  28.044  1.00 72.63           C  
ATOM    171  CG  ASN A  34      19.621  61.374  29.081  1.00 77.43           C  
ATOM    172  OD1 ASN A  34      18.860  62.344  29.001  1.00 80.82           O  
ATOM    173  ND2 ASN A  34      19.530  60.473  30.057  1.00 84.37           N  
ATOM    174  N   ASP A  35      22.546  60.879  26.006  1.00 73.93           N  
ATOM    175  CA  ASP A  35      23.516  60.267  25.109  1.00 74.57           C  
ATOM    176  C   ASP A  35      23.573  58.743  25.377  1.00 72.24           C  
ATOM    177  O   ASP A  35      24.656  58.137  25.359  1.00 71.23           O  
ATOM    178  CB  ASP A  35      24.893  60.940  25.290  1.00 74.52           C  
ATOM    179  N   GLN A  36      22.410  58.134  25.631  1.00 68.70           N  
ATOM    180  CA  GLN A  36      22.360  56.708  25.962  1.00 66.82           C  
ATOM    181  C   GLN A  36      21.570  55.913  24.922  1.00 62.19           C  
ATOM    182  O   GLN A  36      20.340  55.947  24.879  1.00 62.63           O  
ATOM    183  CB  GLN A  36      21.797  56.478  27.367  1.00 68.73           C  
ATOM    184  CG  GLN A  36      21.723  54.983  27.779  1.00 77.51           C  
ATOM    185  CD  GLN A  36      23.078  54.272  27.778  1.00 84.88           C  
ATOM    186  OE1 GLN A  36      24.067  54.805  28.295  1.00 97.40           O  
ATOM    187  NE2 GLN A  36      23.125  53.062  27.210  1.00 76.84           N  
ATOM    188  N   PRO A  37      22.291  55.207  24.056  1.00 57.53           N  
ATOM    189  CA  PRO A  37      21.673  54.407  23.012  1.00 54.51           C  
ATOM    190  C   PRO A  37      20.996  53.138  23.521  1.00 51.11           C  
ATOM    191  O   PRO A  37      21.393  52.579  24.541  1.00 50.19           O  
ATOM    192  CB  PRO A  37      22.859  54.037  22.120  1.00 54.94           C  
ATOM    193  CG  PRO A  37      23.983  54.952  22.552  1.00 56.94           C  
ATOM    194  CD  PRO A  37      23.758  55.163  23.984  1.00 55.30           C  
ATOM    195  N   TYR A  38      19.974  52.690  22.794  1.00 49.46           N  
ATOM    196  CA  TYR A  38      19.254  51.449  23.102  1.00 46.18           C  
ATOM    197  C   TYR A  38      18.845  50.837  21.769  1.00 45.31           C  
ATOM    198  O   TYR A  38      18.226  51.511  20.952  1.00 45.57           O  
ATOM    199  CB  TYR A  38      18.027  51.772  23.946  1.00 46.02           C  
ATOM    200  CG  TYR A  38      17.151  50.601  24.367  1.00 43.40           C  
ATOM    201  CD1 TYR A  38      17.689  49.458  24.922  1.00 44.73           C  
ATOM    202  CD2 TYR A  38      15.777  50.685  24.275  1.00 49.71           C  
ATOM    203  CE1 TYR A  38      16.882  48.421  25.343  1.00 48.42           C  
ATOM    204  CE2 TYR A  38      14.955  49.652  24.704  1.00 48.93           C  
ATOM    205  CZ  TYR A  38      15.512  48.531  25.235  1.00 47.25           C  
ATOM    206  OH  TYR A  38      14.699  47.510  25.640  1.00 49.02           O  
ATOM    207  N   VAL A  39      19.221  49.579  21.543  1.00 44.80           N  
ATOM    208  CA  VAL A  39      18.984  48.874  20.269  1.00 44.61           C  
ATOM    209  C   VAL A  39      18.240  47.558  20.536  1.00 45.14           C  
ATOM    210  O   VAL A  39      18.746  46.698  21.273  1.00 45.05           O  
ATOM    211  CB  VAL A  39      20.316  48.518  19.559  1.00 44.11           C  
ATOM    212  CG1 VAL A  39      20.069  47.704  18.305  1.00 45.90           C  
ATOM    213  CG2 VAL A  39      21.100  49.767  19.213  1.00 46.55           C  
ATOM    214  N   ILE A  40      17.069  47.379  19.923  1.00 42.16           N  
ATOM    215  CA  ILE A  40      16.326  46.134  20.082  1.00 42.18           C  
ATOM    216  C   ILE A  40      15.926  45.542  18.758  1.00 40.37           C  
ATOM    217  O   ILE A  40      15.609  46.276  17.821  1.00 42.97           O  
ATOM    218  CB  ILE A  40      15.053  46.338  20.925  1.00 42.25           C  
ATOM    219  CG1 ILE A  40      14.215  47.486  20.381  1.00 43.00           C  
ATOM    220  CG2 ILE A  40      15.430  46.656  22.366  1.00 45.25           C  
ATOM    221  CD1 ILE A  40      12.865  47.581  21.027  1.00 54.31           C  
ATOM    222  N   PRO A  41      15.935  44.209  18.666  1.00 39.20           N  
ATOM    223  CA  PRO A  41      15.464  43.544  17.457  1.00 39.23           C  
ATOM    224  C   PRO A  41      13.955  43.524  17.365  1.00 40.21           C  
ATOM    225  O   PRO A  41      13.264  43.358  18.394  1.00 38.77           O  
ATOM    226  CB  PRO A  41      15.973  42.114  17.627  1.00 38.77           C  
ATOM    227  CG  PRO A  41      16.040  41.908  19.058  1.00 37.96           C  
ATOM    228  CD  PRO A  41      16.405  43.243  19.667  1.00 38.73           C  
ATOM    229  N   LEU A  42      13.448  43.650  16.143  1.00 41.88           N  
ATOM    230  CA  LEU A  42      12.006  43.656  15.910  1.00 42.09           C  
ATOM    231  C   LEU A  42      11.662  42.991  14.601  1.00 42.17           C  
ATOM    232  O   LEU A  42      12.435  43.082  13.651  1.00 43.82           O  
ATOM    233  CB  LEU A  42      11.493  45.088  15.837  1.00 41.95           C  
ATOM    234  CG  LEU A  42      11.646  45.965  17.069  1.00 40.45           C  
ATOM    235  CD1 LEU A  42      11.359  47.424  16.682  1.00 38.48           C  
ATOM    236  CD2 LEU A  42      10.685  45.487  18.143  1.00 47.95           C  
ATOM    237  N   ASN A  43      10.505  42.325  14.573  1.00 43.48           N  
ATOM    238  CA  ASN A  43       9.830  41.922  13.332  1.00 46.39           C  
ATOM    239  C   ASN A  43       9.209  43.154  12.715  1.00 47.56           C  
ATOM    240  O   ASN A  43       8.788  44.057  13.422  1.00 48.56           O  
ATOM    241  CB  ASN A  43       8.726  40.897  13.617  1.00 46.49           C  
ATOM    242  CG  ASN A  43       9.291  39.548  14.065  1.00 51.73           C  
ATOM    243  OD1 ASN A  43      10.246  39.045  13.479  1.00 56.62           O  
ATOM    244  ND2 ASN A  43       8.727  38.982  15.117  1.00 51.53           N  
ATOM    245  N   PHE A  44       9.145  43.211  11.399  1.00 47.21           N  
ATOM    246  CA  PHE A  44       8.747  44.435  10.767  1.00 48.58           C  
ATOM    247  C   PHE A  44       8.283  44.130   9.369  1.00 50.35           C  
ATOM    248  O   PHE A  44       8.541  43.040   8.859  1.00 52.29           O  
ATOM    249  CB  PHE A  44       9.943  45.379  10.678  1.00 49.57           C  
ATOM    250  CG  PHE A  44      10.932  44.966   9.645  1.00 48.65           C  
ATOM    251  CD1 PHE A  44      11.885  44.004   9.929  1.00 52.38           C  
ATOM    252  CD2 PHE A  44      10.893  45.507   8.379  1.00 48.15           C  
ATOM    253  CE1 PHE A  44      12.801  43.605   8.966  1.00 52.83           C  
ATOM    254  CE2 PHE A  44      11.807  45.122   7.410  1.00 53.64           C  
ATOM    255  CZ  PHE A  44      12.761  44.158   7.700  1.00 51.00           C  
ATOM    256  N   VAL A  45       7.583  45.095   8.768  1.00 50.65           N  
ATOM    257  CA  VAL A  45       7.375  45.118   7.325  1.00 51.53           C  
ATOM    258  C   VAL A  45       7.733  46.467   6.773  1.00 52.02           C  
ATOM    259  O   VAL A  45       7.627  47.481   7.451  1.00 48.95           O  
ATOM    260  CB  VAL A  45       5.931  44.807   6.895  1.00 51.01           C  
ATOM    261  CG1 VAL A  45       5.582  43.424   7.320  1.00 56.26           C  
ATOM    262  CG2 VAL A  45       4.944  45.827   7.474  1.00 49.78           C  
ATOM    263  N   TRP A  46       8.178  46.443   5.527  1.00 56.55           N  
ATOM    264  CA  TRP A  46       8.479  47.637   4.766  1.00 60.75           C  
ATOM    265  C   TRP A  46       7.272  47.862   3.853  1.00 64.98           C  
ATOM    266  O   TRP A  46       6.863  46.962   3.116  1.00 65.00           O  
ATOM    267  CB  TRP A  46       9.751  47.386   3.984  1.00 60.19           C  
ATOM    268  CG  TRP A  46      10.096  48.383   2.950  1.00 58.38           C  
ATOM    269  CD1 TRP A  46      10.089  48.187   1.601  1.00 53.65           C  
ATOM    270  CD2 TRP A  46      10.559  49.719   3.165  1.00 53.47           C  
ATOM    271  NE1 TRP A  46      10.511  49.326   0.965  1.00 52.96           N  
ATOM    272  CE2 TRP A  46      10.797  50.283   1.901  1.00 50.57           C  
ATOM    273  CE3 TRP A  46      10.796  50.490   4.303  1.00 50.95           C  
ATOM    274  CZ2 TRP A  46      11.261  51.586   1.740  1.00 56.22           C  
ATOM    275  CZ3 TRP A  46      11.271  51.772   4.148  1.00 51.88           C  
ATOM    276  CH2 TRP A  46      11.491  52.316   2.875  1.00 56.21           C  
ATOM    277  N   HIS A  47       6.672  49.042   3.948  1.00 69.49           N  
ATOM    278  CA  HIS A  47       5.391  49.317   3.299  1.00 72.87           C  
ATOM    279  C   HIS A  47       5.349  50.821   3.116  1.00 74.28           C  
ATOM    280  O   HIS A  47       6.035  51.550   3.857  1.00 74.48           O  
ATOM    281  CB  HIS A  47       4.268  48.839   4.200  1.00 74.86           C  
ATOM    282  CG  HIS A  47       2.948  48.686   3.515  1.00 85.34           C  
ATOM    283  ND1 HIS A  47       2.388  47.452   3.253  1.00 92.52           N  
ATOM    284  CD2 HIS A  47       2.061  49.608   3.068  1.00 89.86           C  
ATOM    285  CE1 HIS A  47       1.220  47.621   2.661  1.00 92.90           C  
ATOM    286  NE2 HIS A  47       0.998  48.919   2.538  1.00 94.85           N  
ATOM    287  N   ASN A  48       4.593  51.317   2.137  1.00 74.88           N  
ATOM    288  CA  ASN A  48       4.745  52.720   1.789  1.00 74.43           C  
ATOM    289  C   ASN A  48       6.253  52.944   1.691  1.00 73.04           C  
ATOM    290  O   ASN A  48       6.995  52.080   1.227  1.00 75.51           O  
ATOM    291  CB  ASN A  48       4.148  53.632   2.871  1.00 76.58           C  
ATOM    292  CG  ASN A  48       2.758  54.146   2.522  1.00 82.81           C  
ATOM    293  OD1 ASN A  48       2.536  54.714   1.449  1.00 86.37           O  
ATOM    294  ND2 ASN A  48       1.823  53.984   3.454  1.00 89.16           N  
ATOM    295  N   HIS A  49       6.726  54.090   2.146  1.00 69.93           N  
ATOM    296  CA  HIS A  49       8.154  54.356   2.150  1.00 66.50           C  
ATOM    297  C   HIS A  49       8.493  54.298   3.630  1.00 63.15           C  
ATOM    298  O   HIS A  49       9.031  55.257   4.211  1.00 61.39           O  
ATOM    299  CB  HIS A  49       8.416  55.742   1.529  1.00 66.30           C  
ATOM    300  CG  HIS A  49       9.846  56.001   1.168  1.00 69.41           C  
ATOM    301  ND1 HIS A  49      10.553  55.201   0.295  1.00 75.11           N  
ATOM    302  CD2 HIS A  49      10.697  56.985   1.553  1.00 75.57           C  
ATOM    303  CE1 HIS A  49      11.784  55.672   0.169  1.00 79.71           C  
ATOM    304  NE2 HIS A  49      11.899  56.752   0.925  1.00 76.78           N  
ATOM    305  N   ALA A  50       8.123  53.182   4.267  1.00 59.63           N  
ATOM    306  CA  ALA A  50       8.177  53.134   5.730  1.00 57.29           C  
ATOM    307  C   ALA A  50       8.285  51.745   6.352  1.00 54.37           C  
ATOM    308  O   ALA A  50       7.917  50.736   5.751  1.00 54.72           O  
ATOM    309  CB  ALA A  50       6.958  53.881   6.322  1.00 57.81           C  
ATOM    310  N   ILE A  51       8.764  51.742   7.596  1.00 51.64           N  
ATOM    311  CA  ILE A  51       8.880  50.552   8.422  1.00 48.08           C  
ATOM    312  C   ILE A  51       7.752  50.578   9.457  1.00 47.96           C  
ATOM    313  O   ILE A  51       7.556  51.580  10.168  1.00 45.07           O  
ATOM    314  CB  ILE A  51      10.254  50.543   9.171  1.00 48.25           C  
ATOM    315  CG1 ILE A  51      11.443  50.466   8.188  1.00 47.82           C  
ATOM    316  CG2 ILE A  51      10.316  49.413  10.167  1.00 47.91           C  
ATOM    317  CD1 ILE A  51      11.582  49.128   7.447  1.00 49.88           C  
ATOM    318  N   TYR A  52       7.010  49.481   9.539  1.00 47.57           N  
ATOM    319  CA  TYR A  52       5.983  49.327  10.540  1.00 48.84           C  
ATOM    320  C   TYR A  52       6.313  48.144  11.423  1.00 49.01           C  
ATOM    321  O   TYR A  52       6.826  47.140  10.951  1.00 50.80           O  
ATOM    322  CB  TYR A  52       4.636  49.021   9.896  1.00 50.05           C  
ATOM    323  CG  TYR A  52       4.062  50.098   9.023  1.00 52.51           C  
ATOM    324  CD1 TYR A  52       4.416  50.193   7.683  1.00 52.92           C  
ATOM    325  CD2 TYR A  52       3.129  50.995   9.522  1.00 53.63           C  
ATOM    326  CE1 TYR A  52       3.882  51.171   6.877  1.00 55.36           C  
ATOM    327  CE2 TYR A  52       2.587  51.972   8.720  1.00 55.12           C  
ATOM    328  CZ  TYR A  52       2.965  52.055   7.400  1.00 57.02           C  
ATOM    329  OH  TYR A  52       2.433  53.026   6.593  1.00 52.90           O  
ATOM    330  N   PHE A  53       5.972  48.228  12.697  1.00 47.71           N  
ATOM    331  CA  PHE A  53       6.022  47.050  13.533  1.00 47.23           C  
ATOM    332  C   PHE A  53       4.913  47.114  14.581  1.00 48.75           C  
ATOM    333  O   PHE A  53       4.378  48.176  14.856  1.00 49.81           O  
ATOM    334  CB  PHE A  53       7.408  46.897  14.166  1.00 47.40           C  
ATOM    335  CG  PHE A  53       7.777  47.993  15.139  1.00 45.51           C  
ATOM    336  CD1 PHE A  53       7.443  47.890  16.481  1.00 54.07           C  
ATOM    337  CD2 PHE A  53       8.492  49.096  14.721  1.00 46.03           C  
ATOM    338  CE1 PHE A  53       7.790  48.900  17.396  1.00 47.79           C  
ATOM    339  CE2 PHE A  53       8.849  50.113  15.621  1.00 43.99           C  
ATOM    340  CZ  PHE A  53       8.494  50.007  16.964  1.00 42.67           C  
ATOM    341  N   HIS A  54       4.551  45.957  15.119  1.00 49.87           N  
ATOM    342  CA  HIS A  54       3.557  45.848  16.158  1.00 51.72           C  
ATOM    343  C   HIS A  54       4.319  45.680  17.458  1.00 53.03           C  
ATOM    344  O   HIS A  54       5.248  44.889  17.528  1.00 54.62           O  
ATOM    345  CB  HIS A  54       2.670  44.637  15.892  1.00 51.60           C  
ATOM    346  CG  HIS A  54       1.535  44.482  16.858  1.00 57.18           C  
ATOM    347  ND1 HIS A  54       1.007  43.254  17.192  1.00 63.26           N  
ATOM    348  CD2 HIS A  54       0.824  45.395  17.558  1.00 66.75           C  
ATOM    349  CE1 HIS A  54       0.019  43.415  18.052  1.00 63.92           C  
ATOM    350  NE2 HIS A  54      -0.116  44.706  18.289  1.00 67.74           N  
ATOM    351  N   GLY A  55       3.938  46.434  18.482  1.00 53.88           N  
ATOM    352  CA  GLY A  55       4.674  46.445  19.737  1.00 54.45           C  
ATOM    353  C   GLY A  55       3.802  46.800  20.923  1.00 55.15           C  
ATOM    354  O   GLY A  55       2.773  47.454  20.776  1.00 54.48           O  
ATOM    355  N   ALA A  56       4.207  46.350  22.102  1.00 55.89           N  
ATOM    356  CA  ALA A  56       3.523  46.734  23.321  1.00 56.38           C  
ATOM    357  C   ALA A  56       3.675  48.239  23.448  1.00 58.19           C  
ATOM    358  O   ALA A  56       4.754  48.776  23.169  1.00 61.19           O  
ATOM    359  CB  ALA A  56       4.121  46.023  24.522  1.00 53.69           C  
ATOM    360  N   SER A  57       2.605  48.925  23.846  1.00 59.04           N  
ATOM    361  CA  SER A  57       2.668  50.378  24.009  1.00 60.67           C  
ATOM    362  C   SER A  57       3.145  50.763  25.406  1.00 59.57           C  
ATOM    363  O   SER A  57       2.883  51.853  25.882  1.00 61.61           O  
ATOM    364  CB  SER A  57       1.321  51.025  23.694  1.00 60.27           C  
ATOM    365  OG  SER A  57       0.265  50.325  24.316  1.00 65.82           O  
ATOM    366  N   GLU A  58       3.866  49.861  26.053  1.00 59.43           N  
ATOM    367  CA  GLU A  58       4.526  50.161  27.312  1.00 59.77           C  
ATOM    368  C   GLU A  58       5.957  49.639  27.225  1.00 59.01           C  
ATOM    369  O   GLU A  58       6.261  48.789  26.381  1.00 60.38           O  
ATOM    370  CB  GLU A  58       3.782  49.482  28.474  1.00 60.79           C  
ATOM    371  N   GLY A  59       6.838  50.141  28.083  1.00 57.65           N  
ATOM    372  CA  GLY A  59       8.222  49.652  28.129  1.00 55.93           C  
ATOM    373  C   GLY A  59       9.261  50.743  27.886  1.00 54.94           C  
ATOM    374  O   GLY A  59       8.922  51.888  27.573  1.00 53.62           O  
ATOM    375  N   ARG A  60      10.532  50.381  28.032  1.00 53.14           N  
ATOM    376  CA  ARG A  60      11.623  51.325  27.836  1.00 53.92           C  
ATOM    377  C   ARG A  60      11.565  51.943  26.454  1.00 55.37           C  
ATOM    378  O   ARG A  60      11.706  53.167  26.286  1.00 54.48           O  
ATOM    379  CB  ARG A  60      12.959  50.625  28.008  1.00 53.35           C  
ATOM    380  CG  ARG A  60      14.127  51.531  27.781  1.00 53.52           C  
ATOM    381  CD  ARG A  60      15.424  50.899  28.259  1.00 52.26           C  
ATOM    382  NE  ARG A  60      16.545  51.807  28.025  1.00 60.20           N  
ATOM    383  CZ  ARG A  60      17.792  51.598  28.439  1.00 63.42           C  
ATOM    384  NH1 ARG A  60      18.095  50.497  29.114  1.00 66.66           N  
ATOM    385  NH2 ARG A  60      18.740  52.494  28.170  1.00 65.99           N  
ATOM    386  N   LYS A  61      11.337  51.093  25.458  1.00 55.38           N  
ATOM    387  CA  LYS A  61      11.265  51.584  24.089  1.00 57.00           C  
ATOM    388  C   LYS A  61      10.285  52.752  23.946  1.00 56.33           C  
ATOM    389  O   LYS A  61      10.561  53.704  23.222  1.00 56.03           O  
ATOM    390  CB  LYS A  61      10.932  50.453  23.100  1.00 56.86           C  
ATOM    391  CG  LYS A  61       9.511  49.912  23.158  1.00 55.91           C  
ATOM    392  CD  LYS A  61       9.407  48.582  22.389  1.00 55.43           C  
ATOM    393  CE  LYS A  61       8.020  47.973  22.464  1.00 56.28           C  
ATOM    394  NZ  LYS A  61       7.642  47.611  23.869  1.00 47.47           N  
ATOM    395  N   ILE A  62       9.156  52.690  24.644  1.00 56.53           N  
ATOM    396  CA  ILE A  62       8.106  53.701  24.481  1.00 55.51           C  
ATOM    397  C   ILE A  62       8.372  54.949  25.307  1.00 55.92           C  
ATOM    398  O   ILE A  62       8.050  56.054  24.887  1.00 56.51           O  
ATOM    399  CB  ILE A  62       6.717  53.134  24.820  1.00 55.17           C  
ATOM    400  CG1 ILE A  62       6.367  51.989  23.861  1.00 54.23           C  
ATOM    401  CG2 ILE A  62       5.655  54.209  24.709  1.00 51.71           C  
ATOM    402  CD1 ILE A  62       6.264  52.404  22.398  1.00 56.74           C  
ATOM    403  N   LYS A  63       8.973  54.800  26.475  1.00 57.48           N  
ATOM    404  CA  LYS A  63       9.437  55.985  27.191  1.00 57.97           C  
ATOM    405  C   LYS A  63      10.416  56.777  26.313  1.00 59.31           C  
ATOM    406  O   LYS A  63      10.273  57.996  26.127  1.00 59.51           O  
ATOM    407  CB  LYS A  63      10.097  55.604  28.514  1.00 57.88           C  
ATOM    408  CG  LYS A  63       9.126  55.162  29.587  1.00 60.57           C  
HETATM  409  N   MSE A  64      11.403  56.092  25.743  1.00 60.11           N  
HETATM  410  CA  MSE A  64      12.422  56.796  24.948  1.00 60.25           C  
HETATM  411  C   MSE A  64      11.842  57.497  23.718  1.00 61.17           C  
HETATM  412  O   MSE A  64      12.233  58.624  23.374  1.00 59.60           O  
HETATM  413  CB  MSE A  64      13.519  55.828  24.544  1.00 59.42           C  
HETATM  414  CG  MSE A  64      14.265  55.310  25.736  1.00 57.52           C  
HETATM  415 SE   MSE A  64      15.662  54.114  25.251  0.70 55.94          SE  
HETATM  416  CE  MSE A  64      16.755  55.356  24.361  1.00 52.01           C  
ATOM    417  N   ILE A  65      10.890  56.830  23.074  1.00 61.20           N  
ATOM    418  CA  ILE A  65      10.255  57.351  21.875  1.00 61.93           C  
ATOM    419  C   ILE A  65       9.467  58.623  22.177  1.00 63.33           C  
ATOM    420  O   ILE A  65       9.491  59.592  21.417  1.00 63.41           O  
ATOM    421  CB  ILE A  65       9.336  56.279  21.273  1.00 61.16           C  
ATOM    422  CG1 ILE A  65      10.154  55.378  20.362  1.00 67.32           C  
ATOM    423  CG2 ILE A  65       8.183  56.892  20.505  1.00 62.10           C  
ATOM    424  CD1 ILE A  65       9.405  54.126  19.923  1.00 73.81           C  
ATOM    425  N   GLU A  66       8.752  58.614  23.288  1.00 65.33           N  
ATOM    426  CA  GLU A  66       7.970  59.770  23.667  1.00 67.02           C  
ATOM    427  C   GLU A  66       8.921  60.917  23.961  1.00 65.72           C  
ATOM    428  O   GLU A  66       8.637  62.072  23.645  1.00 68.19           O  
ATOM    429  CB  GLU A  66       7.056  59.438  24.849  1.00 67.91           C  
ATOM    430  CG  GLU A  66       5.817  58.651  24.391  1.00 76.65           C  
ATOM    431  CD  GLU A  66       5.091  57.903  25.513  1.00 86.13           C  
ATOM    432  OE1 GLU A  66       5.503  58.012  26.694  1.00 89.85           O  
ATOM    433  OE2 GLU A  66       4.099  57.199  25.199  1.00 86.60           O  
ATOM    434  N   ALA A  67      10.075  60.594  24.523  1.00 63.94           N  
ATOM    435  CA  ALA A  67      11.101  61.603  24.760  1.00 62.46           C  
ATOM    436  C   ALA A  67      11.800  62.029  23.460  1.00 62.80           C  
ATOM    437  O   ALA A  67      12.017  63.211  23.241  1.00 65.12           O  
ATOM    438  CB  ALA A  67      12.119  61.095  25.780  1.00 60.36           C  
ATOM    439  N   ASN A  68      12.139  61.078  22.590  1.00 61.61           N  
ATOM    440  CA  ASN A  68      12.946  61.389  21.403  1.00 58.85           C  
ATOM    441  C   ASN A  68      12.593  60.472  20.249  1.00 56.79           C  
ATOM    442  O   ASN A  68      13.097  59.364  20.185  1.00 56.45           O  
ATOM    443  CB  ASN A  68      14.428  61.209  21.741  1.00 59.26           C  
ATOM    444  CG  ASN A  68      15.316  61.324  20.532  1.00 57.81           C  
ATOM    445  OD1 ASN A  68      14.952  61.954  19.541  1.00 57.25           O  
ATOM    446  ND2 ASN A  68      16.486  60.720  20.604  1.00 59.64           N  
ATOM    447  N   PRO A  69      11.713  60.923  19.345  1.00 55.93           N  
ATOM    448  CA  PRO A  69      11.193  60.125  18.230  1.00 53.76           C  
ATOM    449  C   PRO A  69      12.118  60.037  17.035  1.00 52.36           C  
ATOM    450  O   PRO A  69      11.733  59.487  16.003  1.00 51.65           O  
ATOM    451  CB  PRO A  69       9.919  60.887  17.820  1.00 54.70           C  
ATOM    452  CG  PRO A  69      10.182  62.290  18.189  1.00 53.73           C  
ATOM    453  CD  PRO A  69      11.121  62.274  19.375  1.00 57.72           C  
ATOM    454  N   GLU A  70      13.313  60.598  17.150  1.00 51.59           N  
ATOM    455  CA  GLU A  70      14.307  60.421  16.115  1.00 51.77           C  
ATOM    456  C   GLU A  70      14.966  59.057  16.288  1.00 50.51           C  
ATOM    457  O   GLU A  70      15.573  58.765  17.339  1.00 49.42           O  
ATOM    458  CB  GLU A  70      15.351  61.531  16.186  1.00 54.65           C  
ATOM    459  CG  GLU A  70      14.905  62.816  15.488  1.00 64.32           C  
ATOM    460  CD  GLU A  70      14.903  62.677  13.978  1.00 75.97           C  
ATOM    461  OE1 GLU A  70      15.894  62.119  13.442  1.00 84.07           O  
ATOM    462  OE2 GLU A  70      13.918  63.118  13.334  1.00 83.39           O  
ATOM    463  N   VAL A  71      14.844  58.211  15.273  1.00 48.46           N  
ATOM    464  CA  VAL A  71      15.324  56.841  15.421  1.00 49.06           C  
ATOM    465  C   VAL A  71      16.141  56.375  14.243  1.00 48.51           C  
ATOM    466  O   VAL A  71      16.246  57.036  13.225  1.00 50.20           O  
ATOM    467  CB  VAL A  71      14.166  55.836  15.626  1.00 47.19           C  
ATOM    468  CG1 VAL A  71      13.303  56.257  16.794  1.00 50.43           C  
ATOM    469  CG2 VAL A  71      13.338  55.723  14.368  1.00 44.54           C  
ATOM    470  N   CYS A  72      16.697  55.190  14.411  1.00 49.65           N  
ATOM    471  CA  CYS A  72      17.467  54.520  13.379  1.00 48.94           C  
ATOM    472  C   CYS A  72      16.945  53.090  13.225  1.00 46.06           C  
ATOM    473  O   CYS A  72      16.650  52.435  14.213  1.00 47.10           O  
ATOM    474  CB  CYS A  72      18.921  54.498  13.833  1.00 49.16           C  
ATOM    475  SG  CYS A  72      19.967  53.801  12.662  1.00 58.51           S  
ATOM    476  N   PHE A  73      16.821  52.594  12.005  1.00 44.85           N  
ATOM    477  CA  PHE A  73      16.436  51.193  11.816  1.00 44.32           C  
ATOM    478  C   PHE A  73      17.387  50.505  10.824  1.00 45.50           C  
ATOM    479  O   PHE A  73      17.498  50.910   9.673  1.00 43.22           O  
ATOM    480  CB  PHE A  73      14.985  51.082  11.339  1.00 44.84           C  
ATOM    481  CG  PHE A  73      14.399  49.714  11.494  1.00 41.22           C  
ATOM    482  CD1 PHE A  73      13.944  49.282  12.709  1.00 38.78           C  
ATOM    483  CD2 PHE A  73      14.322  48.855  10.423  1.00 44.74           C  
ATOM    484  CE1 PHE A  73      13.425  48.013  12.864  1.00 43.74           C  
ATOM    485  CE2 PHE A  73      13.790  47.598  10.575  1.00 46.07           C  
ATOM    486  CZ  PHE A  73      13.340  47.179  11.801  1.00 44.38           C  
ATOM    487  N   THR A  74      18.062  49.454  11.294  1.00 46.20           N  
ATOM    488  CA  THR A  74      19.134  48.808  10.550  1.00 45.21           C  
ATOM    489  C   THR A  74      18.806  47.357  10.300  1.00 44.75           C  
ATOM    490  O   THR A  74      18.414  46.632  11.195  1.00 43.32           O  
ATOM    491  CB  THR A  74      20.454  48.862  11.318  1.00 45.51           C  
ATOM    492  OG1 THR A  74      20.844  50.220  11.474  1.00 41.72           O  
ATOM    493  CG2 THR A  74      21.554  48.114  10.592  1.00 47.86           C  
ATOM    494  N   ILE A  75      18.983  46.951   9.056  1.00 47.30           N  
ATOM    495  CA  ILE A  75      18.672  45.613   8.620  1.00 50.41           C  
ATOM    496  C   ILE A  75      19.852  45.070   7.849  1.00 52.67           C  
ATOM    497  O   ILE A  75      20.479  45.757   7.023  1.00 48.21           O  
ATOM    498  CB  ILE A  75      17.477  45.612   7.692  1.00 50.75           C  
ATOM    499  CG1 ILE A  75      16.304  46.306   8.378  1.00 52.64           C  
ATOM    500  CG2 ILE A  75      17.094  44.171   7.324  1.00 52.90           C  
ATOM    501  CD1 ILE A  75      15.556  47.214   7.472  1.00 53.95           C  
ATOM    502  N   CYS A  76      20.150  43.815   8.103  1.00 56.67           N  
ATOM    503  CA  CYS A  76      21.365  43.266   7.573  1.00 61.39           C  
ATOM    504  C   CYS A  76      21.240  41.766   7.450  1.00 63.36           C  
ATOM    505  O   CYS A  76      20.820  41.094   8.379  1.00 62.83           O  
ATOM    506  CB  CYS A  76      22.507  43.687   8.494  1.00 62.51           C  
ATOM    507  SG  CYS A  76      23.957  42.704   8.397  1.00 65.59           S  
ATOM    508  N   GLU A  77      21.597  41.248   6.288  1.00 68.78           N  
ATOM    509  CA  GLU A  77      21.352  39.845   5.990  1.00 75.11           C  
ATOM    510  C   GLU A  77      22.076  39.415   4.717  1.00 78.91           C  
ATOM    511  O   GLU A  77      22.917  40.140   4.183  1.00 77.33           O  
ATOM    512  CB  GLU A  77      19.832  39.583   5.857  1.00 76.09           C  
ATOM    513  CG  GLU A  77      19.160  38.968   7.093  1.00 79.15           C  
ATOM    514  CD  GLU A  77      17.744  38.436   6.825  1.00 82.75           C  
ATOM    515  OE1 GLU A  77      17.410  38.149   5.654  1.00 86.10           O  
ATOM    516  OE2 GLU A  77      16.965  38.292   7.795  1.00 82.40           O  
ATOM    517  N   ASP A  78      21.696  38.240   4.222  1.00 85.47           N  
ATOM    518  CA  ASP A  78      22.453  37.523   3.204  1.00 89.98           C  
ATOM    519  C   ASP A  78      22.242  37.988   1.745  1.00 92.38           C  
ATOM    520  O   ASP A  78      23.068  38.722   1.203  1.00 93.01           O  
ATOM    521  CB  ASP A  78      22.156  36.026   3.339  1.00 91.24           C  
ATOM    522  CG  ASP A  78      23.259  35.167   2.768  1.00 96.28           C  
ATOM    523  OD1 ASP A  78      24.393  35.215   3.301  1.00 99.37           O  
ATOM    524  OD2 ASP A  78      22.988  34.444   1.783  1.00106.90           O  
ATOM    525  N   LEU A  79      21.149  37.559   1.112  1.00 95.34           N  
ATOM    526  CA  LEU A  79      20.986  37.702  -0.352  1.00 96.52           C  
ATOM    527  C   LEU A  79      20.777  39.163  -0.773  1.00 96.90           C  
ATOM    528  O   LEU A  79      21.728  39.948  -0.862  1.00 97.42           O  
ATOM    529  CB  LEU A  79      19.811  36.834  -0.858  1.00 97.02           C  
ATOM    530  CG  LEU A  79      19.854  35.323  -0.576  1.00 97.23           C  
ATOM    531  CD1 LEU A  79      18.510  34.679  -0.862  1.00 96.96           C  
ATOM    532  CD2 LEU A  79      20.947  34.645  -1.392  1.00 99.30           C  
ATOM    533  N   ALA A  93      28.039  37.218   0.083  1.00 83.89           N  
ATOM    534  CA  ALA A  93      28.084  38.667   0.329  1.00 83.16           C  
ATOM    535  C   ALA A  93      26.885  39.141   1.163  1.00 81.82           C  
ATOM    536  O   ALA A  93      25.788  38.586   1.064  1.00 80.24           O  
ATOM    537  CB  ALA A  93      28.148  39.432  -0.991  1.00 82.95           C  
ATOM    538  N   TYR A  94      27.107  40.173   1.982  1.00 80.66           N  
ATOM    539  CA  TYR A  94      26.066  40.693   2.878  1.00 77.96           C  
ATOM    540  C   TYR A  94      25.573  42.079   2.474  1.00 73.05           C  
ATOM    541  O   TYR A  94      26.370  42.967   2.195  1.00 72.84           O  
ATOM    542  CB  TYR A  94      26.580  40.740   4.316  1.00 79.07           C  
ATOM    543  CG  TYR A  94      26.557  39.397   5.010  1.00 84.17           C  
ATOM    544  CD1 TYR A  94      27.599  38.485   4.833  1.00 89.07           C  
ATOM    545  CD2 TYR A  94      25.497  39.039   5.851  1.00 84.40           C  
ATOM    546  CE1 TYR A  94      27.582  37.254   5.465  1.00 89.89           C  
ATOM    547  CE2 TYR A  94      25.473  37.817   6.492  1.00 85.68           C  
ATOM    548  CZ  TYR A  94      26.516  36.925   6.289  1.00 92.08           C  
ATOM    549  OH  TYR A  94      26.503  35.699   6.918  1.00 93.98           O  
HETATM  550  N   MSE A  95      24.255  42.256   2.446  1.00 67.81           N  
HETATM  551  CA  MSE A  95      23.678  43.590   2.315  1.00 63.57           C  
HETATM  552  C   MSE A  95      23.176  44.133   3.658  1.00 57.04           C  
HETATM  553  O   MSE A  95      22.630  43.393   4.470  1.00 51.26           O  
HETATM  554  CB  MSE A  95      22.519  43.594   1.329  1.00 64.94           C  
HETATM  555  CG  MSE A  95      22.207  45.009   0.841  1.00 69.71           C  
HETATM  556 SE   MSE A  95      20.601  45.099  -0.231  0.70 78.88          SE  
HETATM  557  CE  MSE A  95      20.677  43.222  -0.985  1.00 76.98           C  
ATOM    558  N   SER A  96      23.353  45.436   3.857  1.00 52.82           N  
ATOM    559  CA  SER A  96      22.867  46.102   5.040  1.00 52.16           C  
ATOM    560  C   SER A  96      22.199  47.406   4.665  1.00 50.04           C  
ATOM    561  O   SER A  96      22.693  48.164   3.852  1.00 48.56           O  
ATOM    562  CB  SER A  96      24.002  46.364   6.025  1.00 53.26           C  
ATOM    563  OG  SER A  96      24.914  47.295   5.490  1.00 58.87           O  
ATOM    564  N   VAL A  97      21.044  47.656   5.251  1.00 50.73           N  
ATOM    565  CA  VAL A  97      20.317  48.900   5.001  1.00 50.78           C  
ATOM    566  C   VAL A  97      20.147  49.647   6.315  1.00 48.12           C  
ATOM    567  O   VAL A  97      19.854  49.037   7.342  1.00 44.84           O  
ATOM    568  CB  VAL A  97      18.914  48.618   4.416  1.00 50.16           C  
ATOM    569  CG1 VAL A  97      18.234  49.900   4.034  1.00 52.68           C  
ATOM    570  CG2 VAL A  97      19.010  47.712   3.203  1.00 55.66           C  
ATOM    571  N   ILE A  98      20.344  50.957   6.289  1.00 48.50           N  
ATOM    572  CA  ILE A  98      20.090  51.788   7.460  1.00 49.19           C  
ATOM    573  C   ILE A  98      19.072  52.824   7.075  1.00 50.50           C  
ATOM    574  O   ILE A  98      19.169  53.437   6.014  1.00 50.33           O  
ATOM    575  CB  ILE A  98      21.340  52.499   7.975  1.00 49.90           C  
ATOM    576  CG1 ILE A  98      22.362  51.481   8.478  1.00 48.21           C  
ATOM    577  CG2 ILE A  98      20.965  53.485   9.079  1.00 52.99           C  
ATOM    578  CD1 ILE A  98      23.644  52.100   8.935  1.00 53.76           C  
ATOM    579  N   ILE A  99      18.082  52.998   7.938  1.00 51.87           N  
ATOM    580  CA  ILE A  99      16.969  53.890   7.684  1.00 52.39           C  
ATOM    581  C   ILE A  99      16.908  54.871   8.824  1.00 53.02           C  
ATOM    582  O   ILE A  99      16.840  54.468   9.985  1.00 53.74           O  
ATOM    583  CB  ILE A  99      15.647  53.122   7.613  1.00 52.05           C  
ATOM    584  CG1 ILE A  99      15.628  52.244   6.362  1.00 55.32           C  
ATOM    585  CG2 ILE A  99      14.469  54.086   7.579  1.00 55.01           C  
ATOM    586  CD1 ILE A  99      14.449  51.311   6.272  1.00 55.33           C  
ATOM    587  N   PHE A 100      16.978  56.156   8.495  1.00 54.27           N  
ATOM    588  CA  PHE A 100      16.821  57.212   9.487  1.00 54.10           C  
ATOM    589  C   PHE A 100      15.452  57.856   9.289  1.00 53.13           C  
ATOM    590  O   PHE A 100      14.932  57.927   8.176  1.00 51.09           O  
ATOM    591  CB  PHE A 100      17.913  58.260   9.342  1.00 54.50           C  
ATOM    592  CG  PHE A 100      19.313  57.708   9.418  1.00 55.73           C  
ATOM    593  CD1 PHE A 100      19.978  57.295   8.273  1.00 56.18           C  
ATOM    594  CD2 PHE A 100      19.978  57.642  10.624  1.00 57.61           C  
ATOM    595  CE1 PHE A 100      21.263  56.823   8.334  1.00 55.90           C  
ATOM    596  CE2 PHE A 100      21.264  57.159  10.686  1.00 57.14           C  
ATOM    597  CZ  PHE A 100      21.905  56.748   9.536  1.00 55.16           C  
ATOM    598  N   GLY A 101      14.855  58.304  10.382  1.00 53.92           N  
ATOM    599  CA  GLY A 101      13.526  58.899  10.314  1.00 52.74           C  
ATOM    600  C   GLY A 101      12.943  59.103  11.694  1.00 51.77           C  
ATOM    601  O   GLY A 101      13.657  59.073  12.698  1.00 51.15           O  
ATOM    602  N   THR A 102      11.639  59.326  11.739  1.00 52.37           N  
ATOM    603  CA  THR A 102      10.956  59.573  12.994  1.00 53.50           C  
ATOM    604  C   THR A 102       9.851  58.553  13.119  1.00 52.98           C  
ATOM    605  O   THR A 102       9.228  58.154  12.141  1.00 51.38           O  
ATOM    606  CB  THR A 102      10.361  61.010  13.091  1.00 53.22           C  
ATOM    607  OG1 THR A 102       9.725  61.342  11.862  1.00 59.38           O  
ATOM    608  CG2 THR A 102      11.434  62.026  13.333  1.00 55.35           C  
ATOM    609  N   ILE A 103       9.621  58.134  14.348  1.00 53.97           N  
ATOM    610  CA  ILE A 103       8.692  57.082  14.615  1.00 54.67           C  
ATOM    611  C   ILE A 103       7.451  57.706  15.224  1.00 54.17           C  
ATOM    612  O   ILE A 103       7.529  58.748  15.853  1.00 53.68           O  
ATOM    613  CB  ILE A 103       9.315  56.092  15.586  1.00 54.52           C  
ATOM    614  CG1 ILE A 103       8.435  54.851  15.739  1.00 54.39           C  
ATOM    615  CG2 ILE A 103       9.532  56.741  16.923  1.00 57.36           C  
ATOM    616  CD1 ILE A 103       9.166  53.695  16.410  1.00 53.65           C  
ATOM    617  N   GLU A 104       6.307  57.069  15.024  1.00 54.78           N  
ATOM    618  CA  GLU A 104       5.075  57.511  15.641  1.00 56.68           C  
ATOM    619  C   GLU A 104       4.072  56.376  15.593  1.00 54.85           C  
ATOM    620  O   GLU A 104       4.094  55.576  14.663  1.00 52.51           O  
ATOM    621  CB  GLU A 104       4.501  58.706  14.890  1.00 58.67           C  
ATOM    622  CG  GLU A 104       3.569  58.301  13.752  1.00 70.20           C  
ATOM    623  CD  GLU A 104       3.616  59.251  12.560  1.00 84.52           C  
ATOM    624  OE1 GLU A 104       3.683  60.486  12.781  1.00 93.31           O  
ATOM    625  OE2 GLU A 104       3.583  58.752  11.405  1.00 82.26           O  
ATOM    626  N   PRO A 105       3.157  56.327  16.575  1.00 55.04           N  
ATOM    627  CA  PRO A 105       2.151  55.287  16.581  1.00 53.93           C  
ATOM    628  C   PRO A 105       1.117  55.592  15.528  1.00 53.59           C  
ATOM    629  O   PRO A 105       0.865  56.744  15.235  1.00 54.91           O  
ATOM    630  CB  PRO A 105       1.565  55.362  17.988  1.00 54.32           C  
ATOM    631  CG  PRO A 105       1.766  56.748  18.410  1.00 54.43           C  
ATOM    632  CD  PRO A 105       2.988  57.264  17.698  1.00 55.40           C  
ATOM    633  N   VAL A 106       0.570  54.548  14.932  1.00 54.35           N  
ATOM    634  CA  VAL A 106      -0.400  54.671  13.876  1.00 54.58           C  
ATOM    635  C   VAL A 106      -1.813  54.689  14.480  1.00 55.94           C  
ATOM    636  O   VAL A 106      -2.166  53.818  15.278  1.00 54.72           O  
ATOM    637  CB  VAL A 106      -0.248  53.500  12.907  1.00 53.85           C  
ATOM    638  CG1 VAL A 106      -1.395  53.452  11.902  1.00 56.44           C  
ATOM    639  CG2 VAL A 106       1.075  53.614  12.191  1.00 57.16           C  
ATOM    640  N   SER A 107      -2.602  55.696  14.101  1.00 57.27           N  
ATOM    641  CA  SER A 107      -4.011  55.803  14.517  1.00 57.32           C  
ATOM    642  C   SER A 107      -4.962  55.568  13.349  1.00 57.92           C  
ATOM    643  O   SER A 107      -6.112  55.217  13.547  1.00 60.17           O  
ATOM    644  CB  SER A 107      -4.278  57.174  15.101  1.00 56.80           C  
ATOM    645  OG  SER A 107      -3.905  58.163  14.166  1.00 57.68           O  
ATOM    646  N   ALA A 108      -4.469  55.755  12.132  1.00 58.83           N  
ATOM    647  CA  ALA A 108      -5.226  55.451  10.919  1.00 59.92           C  
ATOM    648  C   ALA A 108      -5.610  53.976  10.837  1.00 60.90           C  
ATOM    649  O   ALA A 108      -4.758  53.104  10.687  1.00 60.23           O  
ATOM    650  CB  ALA A 108      -4.413  55.842   9.706  1.00 60.48           C  
ATOM    651  N   ILE A 109      -6.905  53.704  10.916  1.00 62.04           N  
ATOM    652  CA  ILE A 109      -7.370  52.340  11.100  1.00 62.60           C  
ATOM    653  C   ILE A 109      -6.970  51.430   9.949  1.00 63.79           C  
ATOM    654  O   ILE A 109      -6.612  50.266  10.149  1.00 63.61           O  
ATOM    655  CB  ILE A 109      -8.890  52.307  11.280  1.00 62.87           C  
ATOM    656  CG1 ILE A 109      -9.250  52.788  12.693  1.00 62.64           C  
ATOM    657  CG2 ILE A 109      -9.429  50.900  11.052  1.00 60.71           C  
ATOM    658  CD1 ILE A 109     -10.603  53.486  12.784  1.00 64.69           C  
ATOM    659  N   GLU A 110      -7.020  51.967   8.743  1.00 64.63           N  
ATOM    660  CA  GLU A 110      -6.841  51.156   7.553  1.00 65.33           C  
ATOM    661  C   GLU A 110      -5.356  50.969   7.218  1.00 64.24           C  
ATOM    662  O   GLU A 110      -4.926  49.871   6.878  1.00 63.53           O  
ATOM    663  CB  GLU A 110      -7.605  51.792   6.388  1.00 66.26           C  
ATOM    664  CG  GLU A 110      -9.133  51.920   6.654  1.00 69.01           C  
ATOM    665  CD  GLU A 110      -9.537  53.247   7.303  1.00 67.87           C  
ATOM    666  OE1 GLU A 110      -8.670  54.141   7.427  1.00 61.19           O  
ATOM    667  OE2 GLU A 110     -10.722  53.391   7.685  1.00 66.44           O  
ATOM    668  N   GLU A 111      -4.583  52.045   7.318  1.00 63.74           N  
ATOM    669  CA  GLU A 111      -3.129  51.950   7.263  1.00 63.90           C  
ATOM    670  C   GLU A 111      -2.675  50.914   8.306  1.00 64.66           C  
ATOM    671  O   GLU A 111      -1.941  49.976   7.992  1.00 65.82           O  
ATOM    672  CB  GLU A 111      -2.507  53.317   7.533  1.00 63.18           C  
ATOM    673  CG  GLU A 111      -1.020  53.422   7.227  1.00 65.69           C  
ATOM    674  CD  GLU A 111      -0.456  54.811   7.510  1.00 69.52           C  
ATOM    675  OE1 GLU A 111      -1.250  55.752   7.732  1.00 80.69           O  
ATOM    676  OE2 GLU A 111       0.783  54.969   7.519  1.00 72.22           O  
ATOM    677  N   GLY A 112      -3.148  51.071   9.536  1.00 64.06           N  
ATOM    678  CA  GLY A 112      -2.848  50.133  10.605  1.00 64.35           C  
ATOM    679  C   GLY A 112      -3.221  48.701  10.275  1.00 65.68           C  
ATOM    680  O   GLY A 112      -2.485  47.766  10.605  1.00 67.36           O  
ATOM    681  N   THR A 113      -4.360  48.518   9.614  1.00 65.79           N  
ATOM    682  CA  THR A 113      -4.852  47.173   9.296  1.00 64.82           C  
ATOM    683  C   THR A 113      -4.119  46.563   8.089  1.00 62.54           C  
ATOM    684  O   THR A 113      -3.849  45.360   8.059  1.00 59.27           O  
ATOM    685  CB  THR A 113      -6.399  47.166   9.068  1.00 65.78           C  
ATOM    686  OG1 THR A 113      -7.068  47.552  10.278  1.00 68.82           O  
ATOM    687  CG2 THR A 113      -6.907  45.767   8.673  1.00 67.50           C  
ATOM    688  N   GLU A 114      -3.808  47.385   7.092  1.00 62.21           N  
ATOM    689  CA  GLU A 114      -3.013  46.918   5.968  1.00 61.36           C  
ATOM    690  C   GLU A 114      -1.694  46.375   6.521  1.00 62.24           C  
ATOM    691  O   GLU A 114      -1.373  45.199   6.345  1.00 61.15           O  
ATOM    692  CB  GLU A 114      -2.758  48.051   4.975  1.00 60.81           C  
ATOM    693  N   ALA A 115      -0.965  47.234   7.231  1.00 63.66           N  
ATOM    694  CA  ALA A 115       0.345  46.899   7.793  1.00 64.49           C  
ATOM    695  C   ALA A 115       0.315  45.602   8.610  1.00 65.52           C  
ATOM    696  O   ALA A 115       1.249  44.804   8.542  1.00 65.02           O  
ATOM    697  CB  ALA A 115       0.871  48.063   8.646  1.00 63.61           C  
HETATM  698  N   MSE A 116      -0.759  45.378   9.360  1.00 66.62           N  
HETATM  699  CA  MSE A 116      -0.874  44.155  10.144  1.00 68.98           C  
HETATM  700  C   MSE A 116      -1.046  42.911   9.257  1.00 69.94           C  
HETATM  701  O   MSE A 116      -0.469  41.863   9.524  1.00 68.74           O  
HETATM  702  CB  MSE A 116      -2.057  44.255  11.094  1.00 70.08           C  
HETATM  703  CG  MSE A 116      -2.191  43.061  12.033  1.00 79.95           C  
HETATM  704 SE   MSE A 116      -0.797  43.003  13.443  0.70 99.71          SE  
HETATM  705  CE  MSE A 116      -1.608  44.260  14.725  1.00 98.40           C  
ATOM    706  N   GLN A 117      -1.864  43.027   8.216  1.00 71.32           N  
ATOM    707  CA  GLN A 117      -2.093  41.919   7.298  1.00 71.60           C  
ATOM    708  C   GLN A 117      -0.786  41.649   6.559  1.00 71.46           C  
ATOM    709  O   GLN A 117      -0.415  40.497   6.336  1.00 71.19           O  
ATOM    710  CB  GLN A 117      -3.235  42.246   6.307  1.00 71.72           C  
ATOM    711  CG  GLN A 117      -3.574  41.123   5.302  1.00 71.39           C  
ATOM    712  N   GLN A 118      -0.093  42.722   6.192  1.00 70.61           N  
ATOM    713  CA  GLN A 118       1.166  42.608   5.479  1.00 71.12           C  
ATOM    714  C   GLN A 118       2.148  41.784   6.322  1.00 71.56           C  
ATOM    715  O   GLN A 118       2.965  41.040   5.781  1.00 72.10           O  
ATOM    716  CB  GLN A 118       1.732  44.000   5.153  1.00 71.12           C  
ATOM    717  CG  GLN A 118       2.598  44.051   3.899  1.00 74.71           C  
HETATM  718  N   MSE A 119       2.038  41.881   7.644  1.00 71.21           N  
HETATM  719  CA  MSE A 119       2.960  41.180   8.530  1.00 70.71           C  
HETATM  720  C   MSE A 119       2.654  39.715   8.648  1.00 70.02           C  
HETATM  721  O   MSE A 119       3.563  38.876   8.653  1.00 68.56           O  
HETATM  722  CB  MSE A 119       2.972  41.796   9.921  1.00 69.86           C  
HETATM  723  CG  MSE A 119       4.171  42.681  10.067  1.00 77.85           C  
HETATM  724 SE   MSE A 119       4.520  43.360  11.817  0.70 83.47          SE  
HETATM  725  CE  MSE A 119       2.846  44.589  12.014  1.00 58.72           C  
ATOM    726  N   LEU A 120       1.376  39.405   8.772  1.00 68.90           N  
ATOM    727  CA  LEU A 120       0.974  38.018   8.859  1.00 69.36           C  
ATOM    728  C   LEU A 120       1.386  37.322   7.566  1.00 67.82           C  
ATOM    729  O   LEU A 120       1.991  36.261   7.601  1.00 65.12           O  
ATOM    730  CB  LEU A 120      -0.526  37.904   9.094  1.00 69.65           C  
ATOM    731  CG  LEU A 120      -1.006  38.661  10.331  1.00 70.35           C  
ATOM    732  CD1 LEU A 120      -2.526  38.725  10.330  1.00 72.30           C  
ATOM    733  CD2 LEU A 120      -0.478  38.029  11.603  1.00 67.91           C  
ATOM    734  N   ASP A 121       1.099  37.949   6.431  1.00 67.77           N  
ATOM    735  CA  ASP A 121       1.512  37.393   5.152  1.00 69.91           C  
ATOM    736  C   ASP A 121       3.027  37.140   5.116  1.00 70.12           C  
ATOM    737  O   ASP A 121       3.481  36.148   4.546  1.00 70.31           O  
ATOM    738  CB  ASP A 121       1.106  38.311   3.996  1.00 70.49           C  
ATOM    739  CG  ASP A 121      -0.384  38.241   3.688  1.00 74.67           C  
ATOM    740  OD2 ASP A 121      -0.962  39.283   3.286  1.00 81.76           O  
ATOM    741  N   LYS A 122       3.807  38.033   5.721  1.00 68.98           N  
ATOM    742  CA  LYS A 122       5.259  37.897   5.696  1.00 66.05           C  
ATOM    743  C   LYS A 122       5.740  36.819   6.665  1.00 65.68           C  
ATOM    744  O   LYS A 122       6.602  36.037   6.316  1.00 65.01           O  
ATOM    745  CB  LYS A 122       5.957  39.243   5.968  1.00 64.55           C  
ATOM    746  CG  LYS A 122       7.482  39.148   6.219  1.00 59.73           C  
ATOM    747  CD  LYS A 122       8.184  40.491   6.031  1.00 53.83           C  
ATOM    748  CE  LYS A 122       9.612  40.492   6.576  1.00 52.57           C  
ATOM    749  NZ  LYS A 122      10.094  41.857   6.930  1.00 47.64           N  
ATOM    750  N   TYR A 123       5.185  36.765   7.865  1.00 66.86           N  
ATOM    751  CA  TYR A 123       5.725  35.871   8.887  1.00 68.77           C  
ATOM    752  C   TYR A 123       4.947  34.561   9.032  1.00 72.54           C  
ATOM    753  O   TYR A 123       5.496  33.555   9.476  1.00 74.18           O  
ATOM    754  CB  TYR A 123       5.872  36.604  10.243  1.00 66.90           C  
ATOM    755  CG  TYR A 123       6.952  37.666  10.201  1.00 64.95           C  
ATOM    756  CD1 TYR A 123       8.291  37.330  10.349  1.00 67.33           C  
ATOM    757  CD2 TYR A 123       6.640  39.000   9.968  1.00 65.11           C  
ATOM    758  CE1 TYR A 123       9.298  38.303  10.283  1.00 62.65           C  
ATOM    759  CE2 TYR A 123       7.634  39.973   9.893  1.00 64.06           C  
ATOM    760  CZ  TYR A 123       8.958  39.616  10.060  1.00 57.68           C  
ATOM    761  OH  TYR A 123       9.938  40.566   9.980  1.00 56.66           O  
ATOM    762  N   VAL A 124       3.678  34.554   8.646  1.00 76.36           N  
ATOM    763  CA  VAL A 124       2.865  33.346   8.782  1.00 78.94           C  
ATOM    764  C   VAL A 124       2.026  33.030   7.533  1.00 81.10           C  
ATOM    765  O   VAL A 124       0.803  33.006   7.613  1.00 81.41           O  
ATOM    766  CB  VAL A 124       1.935  33.453  10.012  1.00 78.65           C  
ATOM    767  CG1 VAL A 124       2.717  33.270  11.273  1.00 80.07           C  
ATOM    768  CG2 VAL A 124       1.256  34.798  10.057  1.00 82.13           C  
ATOM    769  N   PRO A 125       2.680  32.787   6.377  1.00 84.11           N  
ATOM    770  CA  PRO A 125       1.932  32.428   5.170  1.00 86.20           C  
ATOM    771  C   PRO A 125       1.806  30.911   4.994  1.00 88.09           C  
ATOM    772  O   PRO A 125       0.692  30.379   4.989  1.00 89.65           O  
ATOM    773  CB  PRO A 125       2.787  33.021   4.047  1.00 85.79           C  
ATOM    774  CG  PRO A 125       4.215  32.964   4.584  1.00 85.48           C  
ATOM    775  CD  PRO A 125       4.130  32.840   6.108  1.00 84.77           C  
ATOM    776  N   SER A 143      -0.144  38.772  23.517  1.00 87.70           N  
ATOM    777  CA  SER A 143       1.113  38.089  23.843  1.00 88.69           C  
ATOM    778  C   SER A 143       2.322  39.029  24.055  1.00 87.86           C  
ATOM    779  O   SER A 143       3.278  38.650  24.738  1.00 87.82           O  
ATOM    780  CB  SER A 143       1.450  37.064  22.762  1.00 89.61           C  
ATOM    781  OG  SER A 143       2.693  36.446  23.056  1.00 92.43           O  
ATOM    782  N   LEU A 144       2.296  40.210  23.416  1.00 86.55           N  
ATOM    783  CA  LEU A 144       3.093  41.385  23.823  1.00 84.55           C  
ATOM    784  C   LEU A 144       2.197  42.085  24.840  1.00 83.56           C  
ATOM    785  O   LEU A 144       2.321  43.275  25.117  1.00 82.19           O  
ATOM    786  CB  LEU A 144       3.352  42.299  22.619  1.00 85.03           C  
ATOM    787  CG  LEU A 144       4.054  41.714  21.381  1.00 85.84           C  
ATOM    788  CD1 LEU A 144       3.949  42.652  20.200  1.00 87.66           C  
ATOM    789  CD2 LEU A 144       5.526  41.416  21.673  1.00 91.62           C  
ATOM    790  N   GLY A 145       1.438  41.219  25.506  1.00 83.63           N  
ATOM    791  CA  GLY A 145      -0.013  41.272  25.754  1.00 82.68           C  
ATOM    792  C   GLY A 145      -1.062  42.349  25.945  1.00 81.04           C  
ATOM    793  O   GLY A 145      -2.052  42.406  25.201  1.00 83.45           O  
ATOM    794  N   SER A 146      -0.883  43.156  26.980  1.00 78.66           N  
ATOM    795  CA  SER A 146      -2.060  43.866  27.499  1.00 76.76           C  
ATOM    796  C   SER A 146      -2.591  44.918  26.521  1.00 73.82           C  
ATOM    797  O   SER A 146      -3.746  44.877  26.106  1.00 74.15           O  
ATOM    798  CB  SER A 146      -1.704  44.501  28.857  1.00 77.11           C  
ATOM    799  OG  SER A 146      -2.822  45.119  29.462  1.00 77.09           O  
ATOM    800  N   ARG A 147      -1.516  45.929  26.219  1.00 69.97           N  
ATOM    801  CA  ARG A 147      -1.748  47.165  25.508  1.00 67.32           C  
ATOM    802  C   ARG A 147      -0.703  47.347  24.393  1.00 64.55           C  
ATOM    803  O   ARG A 147       0.480  47.572  24.648  1.00 63.73           O  
ATOM    804  CB  ARG A 147      -1.685  48.335  26.494  1.00 67.86           C  
ATOM    805  CG  ARG A 147      -2.491  48.125  27.791  1.00 70.55           C  
ATOM    806  N   THR A 148      -1.151  47.256  23.151  1.00 61.30           N  
ATOM    807  CA  THR A 148      -0.252  47.307  22.027  1.00 59.45           C  
ATOM    808  C   THR A 148      -0.662  48.383  21.029  1.00 56.97           C  
ATOM    809  O   THR A 148      -1.743  48.953  21.130  1.00 58.18           O  
ATOM    810  CB  THR A 148      -0.184  45.932  21.306  1.00 58.93           C  
ATOM    811  OG1 THR A 148      -1.332  45.759  20.474  1.00 62.05           O  
ATOM    812  CG2 THR A 148      -0.117  44.805  22.314  1.00 61.81           C  
ATOM    813  N   ALA A 149       0.230  48.647  20.074  1.00 54.91           N  
ATOM    814  CA  ALA A 149      -0.019  49.575  18.987  1.00 52.64           C  
ATOM    815  C   ALA A 149       0.827  49.207  17.781  1.00 52.05           C  
ATOM    816  O   ALA A 149       1.765  48.421  17.887  1.00 54.58           O  
ATOM    817  CB  ALA A 149       0.300  50.967  19.417  1.00 51.75           C  
ATOM    818  N   ILE A 150       0.485  49.779  16.634  1.00 49.35           N  
ATOM    819  CA  ILE A 150       1.317  49.694  15.452  1.00 48.73           C  
ATOM    820  C   ILE A 150       2.188  50.935  15.404  1.00 49.33           C  
ATOM    821  O   ILE A 150       1.673  52.040  15.572  1.00 48.48           O  
ATOM    822  CB  ILE A 150       0.478  49.680  14.174  1.00 47.75           C  
ATOM    823  CG1 ILE A 150      -0.481  48.494  14.149  1.00 49.57           C  
ATOM    824  CG2 ILE A 150       1.355  49.645  12.969  1.00 50.65           C  
ATOM    825  CD1 ILE A 150       0.193  47.175  14.196  1.00 60.15           C  
ATOM    826  N   TYR A 151       3.493  50.769  15.155  1.00 47.97           N  
ATOM    827  CA  TYR A 151       4.391  51.919  15.067  1.00 46.78           C  
ATOM    828  C   TYR A 151       4.934  52.097  13.655  1.00 47.05           C  
ATOM    829  O   TYR A 151       5.075  51.140  12.907  1.00 45.16           O  
ATOM    830  CB  TYR A 151       5.519  51.798  16.080  1.00 47.42           C  
ATOM    831  CG  TYR A 151       5.004  51.864  17.484  1.00 47.25           C  
ATOM    832  CD1 TYR A 151       4.616  50.715  18.142  1.00 49.76           C  
ATOM    833  CD2 TYR A 151       4.856  53.076  18.137  1.00 50.16           C  
ATOM    834  CE1 TYR A 151       4.124  50.756  19.416  1.00 47.52           C  
ATOM    835  CE2 TYR A 151       4.346  53.130  19.413  1.00 50.15           C  
ATOM    836  CZ  TYR A 151       3.981  51.962  20.049  1.00 51.08           C  
ATOM    837  OH  TYR A 151       3.468  51.978  21.331  1.00 56.21           O  
ATOM    838  N   LYS A 152       5.207  53.344  13.291  1.00 48.46           N  
ATOM    839  CA  LYS A 152       5.613  53.674  11.939  1.00 49.53           C  
ATOM    840  C   LYS A 152       6.816  54.596  11.937  1.00 49.92           C  
ATOM    841  O   LYS A 152       6.795  55.669  12.539  1.00 47.73           O  
ATOM    842  CB  LYS A 152       4.472  54.319  11.168  1.00 51.85           C  
ATOM    843  CG  LYS A 152       4.920  54.938   9.852  1.00 55.35           C  
ATOM    844  CD  LYS A 152       3.739  55.361   9.016  1.00 61.57           C  
ATOM    845  CE  LYS A 152       4.182  56.145   7.783  1.00 64.74           C  
ATOM    846  NZ  LYS A 152       3.007  56.771   7.092  1.00 63.70           N  
ATOM    847  N   ILE A 153       7.881  54.137  11.281  1.00 51.45           N  
ATOM    848  CA  ILE A 153       9.083  54.936  11.079  1.00 52.98           C  
ATOM    849  C   ILE A 153       9.018  55.443   9.654  1.00 55.46           C  
ATOM    850  O   ILE A 153       9.038  54.666   8.694  1.00 55.26           O  
ATOM    851  CB  ILE A 153      10.383  54.113  11.281  1.00 53.02           C  
ATOM    852  CG1 ILE A 153      10.411  53.471  12.668  1.00 51.58           C  
ATOM    853  CG2 ILE A 153      11.623  54.987  11.100  1.00 50.94           C  
ATOM    854  CD1 ILE A 153      11.316  52.264  12.739  1.00 53.23           C  
ATOM    855  N   SER A 154       8.893  56.751   9.519  1.00 60.26           N  
ATOM    856  CA  SER A 154       8.838  57.368   8.207  1.00 64.54           C  
ATOM    857  C   SER A 154      10.274  57.482   7.704  1.00 65.17           C  
ATOM    858  O   SER A 154      11.117  58.095   8.362  1.00 64.83           O  
ATOM    859  CB  SER A 154       8.233  58.758   8.318  1.00 65.42           C  
ATOM    860  OG  SER A 154       9.230  59.657   8.812  1.00 72.79           O  
ATOM    861  N   CYS A 155      10.550  56.895   6.546  1.00 67.48           N  
ATOM    862  CA  CYS A 155      11.901  56.897   5.992  1.00 68.80           C  
ATOM    863  C   CYS A 155      12.315  58.254   5.441  1.00 67.97           C  
ATOM    864  O   CYS A 155      12.090  58.538   4.268  1.00 68.17           O  
ATOM    865  CB  CYS A 155      12.018  55.868   4.878  1.00 69.30           C  
ATOM    866  SG  CYS A 155      13.662  55.853   4.131  1.00 78.78           S  
ATOM    867  N   ARG A 156      12.927  59.084   6.279  1.00 67.96           N  
ATOM    868  CA  ARG A 156      13.487  60.338   5.806  1.00 68.96           C  
ATOM    869  C   ARG A 156      14.706  60.076   4.918  1.00 68.60           C  
ATOM    870  O   ARG A 156      14.794  60.574   3.796  1.00 68.08           O  
ATOM    871  CB  ARG A 156      13.903  61.242   6.966  1.00 69.49           C  
ATOM    872  CG  ARG A 156      14.890  62.329   6.518  1.00 74.73           C  
ATOM    873  CD  ARG A 156      15.187  63.352   7.602  1.00 78.79           C  
ATOM    874  NE  ARG A 156      15.876  62.736   8.731  1.00 85.56           N  
ATOM    875  CZ  ARG A 156      15.278  62.343   9.853  1.00 90.59           C  
ATOM    876  NH1 ARG A 156      13.963  62.508  10.022  1.00 93.32           N  
ATOM    877  NH2 ARG A 156      16.004  61.789  10.812  1.00 90.45           N  
ATOM    878  N   GLU A 157      15.647  59.300   5.440  1.00 67.53           N  
ATOM    879  CA  GLU A 157      16.852  58.951   4.699  1.00 67.54           C  
ATOM    880  C   GLU A 157      17.189  57.475   4.820  1.00 64.63           C  
ATOM    881  O   GLU A 157      17.012  56.866   5.863  1.00 63.71           O  
ATOM    882  CB  GLU A 157      18.032  59.773   5.188  1.00 69.24           C  
ATOM    883  CG  GLU A 157      19.364  59.272   4.664  1.00 77.32           C  
ATOM    884  CD  GLU A 157      20.537  60.027   5.259  1.00 90.19           C  
ATOM    885  OE1 GLU A 157      20.302  61.096   5.866  1.00 97.17           O  
ATOM    886  OE2 GLU A 157      21.689  59.547   5.121  1.00 98.11           O  
ATOM    887  N   ARG A 158      17.701  56.916   3.739  1.00 62.64           N  
ATOM    888  CA  ARG A 158      18.012  55.515   3.673  1.00 61.31           C  
ATOM    889  C   ARG A 158      19.359  55.293   2.986  1.00 62.52           C  
ATOM    890  O   ARG A 158      19.666  55.934   1.992  1.00 64.47           O  
ATOM    891  CB  ARG A 158      16.932  54.812   2.884  1.00 59.44           C  
ATOM    892  CG  ARG A 158      17.174  53.339   2.747  1.00 65.29           C  
ATOM    893  CD  ARG A 158      16.007  52.668   2.083  1.00 69.62           C  
ATOM    894  NE  ARG A 158      16.098  52.703   0.626  1.00 72.82           N  
ATOM    895  CZ  ARG A 158      15.070  52.489  -0.184  1.00 74.50           C  
ATOM    896  NH1 ARG A 158      13.875  52.249   0.327  1.00 75.18           N  
ATOM    897  NH2 ARG A 158      15.233  52.525  -1.500  1.00 79.27           N  
ATOM    898  N   THR A 159      20.159  54.374   3.502  1.00 62.17           N  
ATOM    899  CA  THR A 159      21.424  54.057   2.875  1.00 61.89           C  
ATOM    900  C   THR A 159      21.617  52.547   2.865  1.00 60.99           C  
ATOM    901  O   THR A 159      21.216  51.865   3.801  1.00 60.64           O  
ATOM    902  CB  THR A 159      22.581  54.758   3.587  1.00 62.06           C  
ATOM    903  OG1 THR A 159      22.758  54.200   4.887  1.00 66.78           O  
ATOM    904  CG2 THR A 159      22.294  56.243   3.726  1.00 66.37           C  
ATOM    905  N   ALA A 160      22.191  52.033   1.781  1.00 60.88           N  
ATOM    906  CA  ALA A 160      22.414  50.609   1.618  1.00 63.16           C  
ATOM    907  C   ALA A 160      23.878  50.355   1.339  1.00 66.17           C  
ATOM    908  O   ALA A 160      24.599  51.253   0.902  1.00 68.03           O  
ATOM    909  CB  ALA A 160      21.593  50.083   0.493  1.00 63.33           C  
ATOM    910  N   LYS A 161      24.321  49.130   1.590  1.00 67.55           N  
ATOM    911  CA  LYS A 161      25.704  48.754   1.347  1.00 68.66           C  
ATOM    912  C   LYS A 161      25.773  47.263   1.148  1.00 70.79           C  
ATOM    913  O   LYS A 161      24.993  46.518   1.731  1.00 69.47           O  
ATOM    914  CB  LYS A 161      26.604  49.151   2.516  1.00 68.83           C  
ATOM    915  CG  LYS A 161      27.263  50.516   2.368  1.00 73.09           C  
ATOM    916  CD  LYS A 161      28.269  50.833   3.496  1.00 76.50           C  
ATOM    917  CE  LYS A 161      29.230  49.668   3.817  1.00 79.48           C  
ATOM    918  NZ  LYS A 161      30.331  50.046   4.776  1.00 73.18           N  
ATOM    919  N   VAL A 162      26.693  46.834   0.292  1.00 75.35           N  
ATOM    920  CA  VAL A 162      27.010  45.421   0.148  1.00 78.88           C  
ATOM    921  C   VAL A 162      28.416  45.227   0.680  1.00 81.76           C  
ATOM    922  O   VAL A 162      29.295  46.050   0.426  1.00 82.29           O  
ATOM    923  CB  VAL A 162      26.957  44.963  -1.299  1.00 79.11           C  
ATOM    924  CG1 VAL A 162      27.053  43.444  -1.366  1.00 81.97           C  
ATOM    925  CG2 VAL A 162      25.681  45.448  -1.948  1.00 78.22           C  
ATOM    926  N   ASN A 163      28.621  44.150   1.431  1.00 85.95           N  
ATOM    927  CA  ASN A 163      29.847  43.984   2.223  1.00 88.67           C  
ATOM    928  C   ASN A 163      30.528  42.633   1.971  1.00 91.27           C  
ATOM    929  O   ASN A 163      29.858  41.611   1.728  1.00 91.12           O  
ATOM    930  CB  ASN A 163      29.559  44.203   3.730  1.00 88.18           C  
ATOM    931  CG  ASN A 163      29.329  45.692   4.084  1.00 87.66           C  
ATOM    932  OD1 ASN A 163      28.189  46.158   4.170  1.00 85.67           O  
ATOM    933  ND2 ASN A 163      30.417  46.433   4.278  1.00 81.54           N  
ATOM    934  N   GLU A 164      31.867  42.662   2.022  1.00 93.61           N  
ATOM    935  CA  GLU A 164      32.721  41.493   1.773  1.00 94.62           C  
ATOM    936  C   GLU A 164      32.554  40.332   2.762  1.00 94.90           C  
ATOM    937  O   GLU A 164      32.013  39.275   2.399  1.00 94.46           O  
ATOM    938  CB  GLU A 164      34.200  41.914   1.789  1.00 94.73           C  
ATOM    939  N   PRO A 165      33.010  40.533   4.016  1.00 95.20           N  
ATOM    940  CA  PRO A 165      32.955  39.562   5.116  1.00 95.38           C  
ATOM    941  C   PRO A 165      32.445  40.211   6.411  1.00 95.22           C  
ATOM    942  O   PRO A 165      31.241  40.429   6.565  1.00 94.25           O  
ATOM    943  CB  PRO A 165      34.402  39.069   5.288  1.00 94.87           C  
TER     944      PRO A 165                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
