
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1087),  selected  138 , name 2hq9_B
# Molecule2: number of CA atoms  234 ( 1778),  selected  234 , name T0506.pdb
# PARAMETERS: 2hq9_B.T0506.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      V       4           -
LGA    L     2_B      A       5           -
LGA    V     3_B      P       6           -
LGA    R     4_B      P       7           -
LGA    T     5_B      V       8           -
LGA    -       -      I       9           -
LGA    -       -      T      10           -
LGA    -       -      P      11           -
LGA    -       -      R      12           -
LGA    -       -      F      24           -
LGA    L     6_B      E      25           #
LGA    S     7_B      A      26          0.729
LGA    A     8_B      V      27          2.371
LGA    L     9_B      R      28          2.679
LGA    E    10_B      V      29          1.477
LGA    C    11_B      A      30          1.058
LGA    T    12_B      R      31          1.654
LGA    K    13_B      D      32          0.938
LGA    V    14_B      V      33          0.436
LGA    L    15_B      L      34          1.519
LGA    T    16_B      H      35          0.600
LGA    A    17_B      T      36          0.599
LGA    N    18_B      S      37          1.453
LGA    R    19_B      R      38          1.575
LGA    V    20_B      T      39          1.319
LGA    G    21_B      A      40          0.630
LGA    R    22_B      A      41          1.280
LGA    L    23_B      L      42          0.652
LGA    A    24_B      A      43          0.649
LGA    C    25_B      T      44          0.151
LGA    A    26_B      L      45          0.605
LGA    K    27_B      D      46          1.904
LGA    -       -      P      47           -
LGA    -       -      V      48           -
LGA    D    28_B      S      49          3.684
LGA    G    29_B      G      50          1.552
LGA    Q    30_B      Y      51          1.346
LGA    P    31_B      P      52          1.287
LGA    Y    32_B      Y      53          1.053
LGA    V    33_B      T      54          0.734
LGA    V    34_B      T      55          0.839
LGA    P    35_B      A      56          0.962
LGA    L    36_B      T      57          0.720
LGA    Y    37_B      N      58          0.863
LGA    Y    38_B      I      59          1.459
LGA    A    39_B      G      60          0.654
LGA    Y    40_B      I      61          1.657
LGA    S    41_B      E      62          2.321
LGA    -       -      P      63           -
LGA    D    42_B      D      64          2.474
LGA    A    43_B      G      65          4.281
LGA    H    44_B      T      66          2.278
LGA    L    45_B      P      67          1.416
LGA    Y    46_B      F      68          1.129
LGA    A    47_B      F      69          1.495
LGA    F    48_B      F      70          1.888
LGA    S    49_B      A      71          2.072
LGA    X    50_B      A      72          1.896
LGA    P    51_B      G      73          0.783
LGA    G    52_B      L      74          2.222
LGA    K    53_B      T      75          3.336
LGA    -       -      L      76           -
LGA    K    54_B      H      77          1.217
LGA    I    55_B      A      78          1.374
LGA    E    56_B      R      79          1.503
LGA    W    57_B      N      80          0.760
LGA    X    58_B      M      81          0.681
LGA    R    59_B      E      82          1.522
LGA    A    60_B      T      83          1.281
LGA    N    61_B      D      84          0.831
LGA    P    62_B      A      85          0.741
LGA    R    63_B      R      86          0.718
LGA    V    64_B      I      87          0.570
LGA    S    65_B      S      88          0.720
LGA    V    66_B      V      89          0.535
LGA    Q    67_B      T      90          1.104
LGA    V    68_B      L      91          1.489
LGA    D    69_B      A      92          1.177
LGA    E    70_B      P      93          1.316
LGA    -       -      F      94           -
LGA    H    71_B      G      95          5.369
LGA    G    72_B      K      96          5.134
LGA    Q    73_B      -       -           -
LGA    G    74_B      -       -           -
LGA    R    75_B      G      97          5.915
LGA    G    76_B      D      98           #
LGA    -       -      A      99           -
LGA    -       -      L     100           -
LGA    W    77_B      T     101          3.565
LGA    K    78_B      L     102          2.645
LGA    -       -      P     103           -
LGA    S    79_B      R     104          1.353
LGA    V    80_B      L     105          1.139
LGA    V    81_B      T     106          1.041
LGA    V    82_B      L     107          1.080
LGA    D    83_B      V     108          0.663
LGA    G    84_B      G     109          1.813
LGA    R    85_B      R     110          0.741
LGA    Y    86_B      A     111          0.515
LGA    E    87_B      D     112          0.256
LGA    E    88_B      R     113          0.694
LGA    L    89_B      I     114          1.572
LGA    P    90_B      G     115          2.907
LGA    D    91_B      P     116          1.385
LGA    L    92_B      D     117          3.697
LGA    I    93_B      -       -           -
LGA    G    94_B      -       -           -
LGA    H    95_B      -       -           -
LGA    K    96_B      E     118          2.438
LGA    L    97_B      -       -           -
LGA    Q    98_B      -       -           -
LGA    R    99_B      V     119          2.310
LGA    D   100_B      P     120          2.568
LGA    H   101_B      L     121          2.818
LGA    A   102_B      A     122          2.192
LGA    W   103_B      I     123          0.971
LGA    S   104_B      A     124          1.405
LGA    V   105_B      R     125          2.899
LGA    L   106_B      Y     126          2.049
LGA    S   107_B      I     127          2.626
LGA    -       -      A     128           -
LGA    -       -      R     129           -
LGA    -       -      Y     130           -
LGA    K   108_B      P     131          1.496
LGA    H   109_B      K     132          3.891
LGA    T   110_B      A     133          1.780
LGA    -       -      K     134           -
LGA    D   111_B      L     135          3.569
LGA    W   112_B      -       -           -
LGA    W   113_B      -       -           -
LGA    E   114_B      Y     136          2.505
LGA    P   115_B      -       -           -
LGA    G   116_B      -       -           -
LGA    A   117_B      -       -           -
LGA    L   118_B      -       -           -
LGA    S   128_B      L     137           #
LGA    A   129_B      S     138           #
LGA    -       -      L     139           -
LGA    P   130_B      P     140          4.364
LGA    H   131_B      D     141          4.257
LGA    -       -      T     142           -
LGA    V   132_B      R     143          1.264
LGA    F   133_B      L     144          1.377
LGA    F   134_B      Y     145          1.169
LGA    R   135_B      R     146          0.862
LGA    I   136_B      L     147          1.244
LGA    L   137_B      R     148          1.474
LGA    I   138_B      T     149          1.801
LGA    E   139_B      E     150          1.695
LGA    Q   140_B      G     151          1.313
LGA    V   141_B      V     152          1.565
LGA    S   142_B      Q     153          1.387
LGA    G   143_B      I     154          1.563
LGA    R   144_B      N     155          1.621
LGA    E   145_B      G     156          2.186
LGA    A   146_B      S     163           -
LGA    S   147_B      N     164           -
LGA    -       -      I     165           -
LGA    -       -      T     166           -
LGA    -       -      P     167           -
LGA    -       -      A     168           -
LGA    -       -      D     169           -
LGA    -       -      L     170           -
LGA    -       -      R     171           -
LGA    -       -      T     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -
LGA    -       -      S     175           -
LGA    -       -      G     176           -
LGA    -       -      A     177           -
LGA    -       -      E     178           -
LGA    -       -      E     179           -
LGA    -       -      L     180           -
LGA    -       -      M     181           -
LGA    -       -      A     182           -
LGA    -       -      A     183           -
LGA    -       -      A     184           -
LGA    -       -      E     185           -
LGA    -       -      S     186           -
LGA    -       -      E     187           -
LGA    -       -      A     188           -
LGA    -       -      T     189           -
LGA    -       -      R     190           -
LGA    -       -      L     191           -
LGA    -       -      N     192           -
LGA    -       -      A     193           -
LGA    -       -      I     194           -
LGA    -       -      K     195           -
LGA    -       -      G     196           -
LGA    -       -      E     197           -
LGA    -       -      A     198           -
LGA    -       -      S     199           -
LGA    -       -      R     200           -
LGA    -       -      L     201           -
LGA    -       -      A     202           -
LGA    -       -      V     203           -
LGA    -       -      L     204           -
LGA    -       -      A     205           -
LGA    -       -      G     206           -
LGA    -       -      A     207           -
LGA    -       -      K     208           -
LGA    -       -      T     209           -
LGA    -       -      G     210           -
LGA    -       -      R     211           -
LGA    -       -      W     212           -
LGA    -       -      K     213           -
LGA    -       -      I     214           -
LGA    -       -      T     215           -
LGA    -       -      S     216           -
LGA    -       -      I     217           -
LGA    -       -      D     218           -
LGA    -       -      P     219           -
LGA    -       -      D     220           -
LGA    -       -      G     221           -
LGA    -       -      I     222           -
LGA    -       -      D     223           -
LGA    -       -      L     224           -
LGA    -       -      A     225           -
LGA    -       -      S     226           -
LGA    -       -      A     227           -
LGA    -       -      S     228           -
LGA    -       -      D     229           -
LGA    -       -      L     230           -
LGA    -       -      A     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      W     234           -
LGA    -       -      F     235           -
LGA    -       -      A     236           -
LGA    -       -      E     237           -
LGA    -       -      R     238           -
LGA    -       -      V     239           -
LGA    -       -      E     240           -
LGA    -       -      T     241           -
LGA    -       -      L     242           -
LGA    -       -      K     243           -
LGA    -       -      Q     244           -
LGA    -       -      F     245           -
LGA    -       -      E     246           -
LGA    -       -      K     247           -
LGA    -       -      A     248           -
LGA    -       -      L     249           -
LGA    -       -      A     250           -
LGA    -       -      Q     251           -
LGA    -       -      L     252           -
LGA    -       -      L     253           -
LGA    -       -      K     254           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  234    5.0    114    2.01    17.54     38.559     5.391

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.772094 * X  +  -0.298238 * Y  +  -0.561182 * Z  +  19.682348
  Y_new =   0.595536 * X  +   0.031312 * Y  +   0.802718 * Z  +   7.240923
  Z_new =  -0.221829 * X  +  -0.953978 * Y  +   0.201787 * Z  +  62.784958 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.362347    1.779245  [ DEG:   -78.0568    101.9432 ]
  Theta =   0.223690    2.917903  [ DEG:    12.8165    167.1835 ]
  Phi   =   0.657010   -2.484582  [ DEG:    37.6439   -142.3561 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hq9_B                                        
REMARK     2: T0506.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hq9_B.T0506.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  234   5.0  114   2.01   17.54  38.559
REMARK  ---------------------------------------------------------- 
MOLECULE 2hq9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-JUL-06   2HQ9              
TITLE     CRYSTAL STRUCTURE OF A FAD-BINDING PROTEIN (NP_107146.1)              
TITLE    2 FROM MESORHIZOBIUM LOTI AT 1.95 A RESOLUTION                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MLL6688 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHIZOBIUM LOTI;                                 
SOURCE   3 ORGANISM_COMMON: MESORHIZOBIUM LOTI;                                 
SOURCE   4 GENE: NP_107146.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_107146.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2HQ9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_107146.1) FROM MESORHIZOBIUM LOTI AT 1.95 A              
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2HQ9 A    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
DBREF  2HQ9 B    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
SEQRES   1 A  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 A  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 A  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 A  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 A  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 A  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 A  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 A  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 A  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 A  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 A  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 A  149  GLY ARG GLU ALA SER GLU                                      
SEQRES   1 B  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 B  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 B  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 B  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 B  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 B  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 B  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 B  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 B  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 B  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 B  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 B  149  GLY ARG GLU ALA SER GLU                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  58       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  58       8                                                       
HET     CL      1       1                                                       
HET    FAD  A 200      53                                                       
HET    FAD  B 200      53                                                       
HET    EDO      2       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   6  EDO    C2 H6 O2                                                     
FORMUL   7  HOH   *178(H2 O)                                                    
CRYST1   47.852   74.895   84.626  90.00  90.00  90.00 P 21 21 21    8          
HETATM 1091  N   MSE B   1      37.078  39.786   1.465  1.00 46.39           N  
HETATM 1092  CA  MSE B   1      35.695  40.175   1.047  1.00 46.28           C  
HETATM 1093  C   MSE B   1      35.682  41.480   0.256  1.00 44.25           C  
HETATM 1094  O   MSE B   1      36.048  42.546   0.796  1.00 44.80           O  
HETATM 1095  CB  MSE B   1      34.780  40.338   2.279  1.00 47.65           C  
HETATM 1096  CG  MSE B   1      34.652  39.069   3.128  1.00 50.54           C  
HETATM 1097 SE   MSE B   1      33.518  37.706   2.338  0.75 56.80          SE  
HETATM 1098  CE  MSE B   1      34.276  36.040   3.209  1.00 54.20           C  
ATOM   1099  N   LEU B   2      35.256  41.403  -1.006  1.00 41.23           N  
ATOM   1100  CA  LEU B   2      34.793  42.596  -1.702  1.00 39.08           C  
ATOM   1101  C   LEU B   2      33.676  43.144  -0.824  1.00 37.07           C  
ATOM   1102  O   LEU B   2      32.693  42.461  -0.632  1.00 36.38           O  
ATOM   1103  CB  LEU B   2      34.239  42.274  -3.093  1.00 38.77           C  
ATOM   1104  N   VAL B   3      33.864  44.331  -0.255  1.00 34.89           N  
ATOM   1105  CA  VAL B   3      32.766  45.085   0.358  1.00 33.94           C  
ATOM   1106  C   VAL B   3      32.464  46.333  -0.472  1.00 32.88           C  
ATOM   1107  O   VAL B   3      33.361  47.073  -0.869  1.00 32.69           O  
ATOM   1108  CB  VAL B   3      33.093  45.483   1.818  1.00 34.20           C  
ATOM   1109  CG1 VAL B   3      31.966  46.272   2.448  1.00 32.37           C  
ATOM   1110  CG2 VAL B   3      33.423  44.225   2.656  1.00 34.67           C  
ATOM   1111  N   ARG B   4      31.191  46.574  -0.732  1.00 31.81           N  
ATOM   1112  CA  ARG B   4      30.781  47.704  -1.555  1.00 31.24           C  
ATOM   1113  C   ARG B   4      29.469  48.252  -1.031  1.00 29.75           C  
ATOM   1114  O   ARG B   4      28.730  47.541  -0.353  1.00 26.62           O  
ATOM   1115  CB  ARG B   4      30.591  47.253  -2.991  1.00 32.33           C  
ATOM   1116  CG  ARG B   4      30.109  45.820  -3.095  1.00 36.25           C  
ATOM   1117  CD  ARG B   4      29.860  45.410  -4.541  1.00 40.75           C  
ATOM   1118  NE  ARG B   4      28.595  45.942  -5.063  1.00 42.12           N  
ATOM   1119  CZ  ARG B   4      27.383  45.526  -4.688  1.00 43.89           C  
ATOM   1120  NH1 ARG B   4      27.247  44.577  -3.759  1.00 44.50           N  
ATOM   1121  NH2 ARG B   4      26.291  46.070  -5.234  1.00 41.40           N  
ATOM   1122  N   THR B   5      29.186  49.499  -1.382  1.00 28.02           N  
ATOM   1123  CA  THR B   5      27.958  50.115  -0.982  1.00 28.34           C  
ATOM   1124  C   THR B   5      26.859  49.749  -1.971  1.00 27.71           C  
ATOM   1125  O   THR B   5      27.127  49.515  -3.127  1.00 26.56           O  
ATOM   1126  CB  THR B   5      28.061  51.644  -0.910  1.00 28.16           C  
ATOM   1127  OG1 THR B   5      28.124  52.169  -2.232  1.00 30.93           O  
ATOM   1128  CG2 THR B   5      29.278  52.079  -0.111  1.00 28.73           C  
ATOM   1129  N   LEU B   6      25.609  49.771  -1.507  1.00 26.54           N  
ATOM   1130  CA  LEU B   6      24.511  49.304  -2.298  1.00 26.65           C  
ATOM   1131  C   LEU B   6      23.833  50.524  -2.885  1.00 27.22           C  
ATOM   1132  O   LEU B   6      23.851  51.591  -2.304  1.00 28.41           O  
ATOM   1133  CB  LEU B   6      23.488  48.529  -1.446  1.00 26.12           C  
ATOM   1134  CG  LEU B   6      23.857  47.165  -0.877  1.00 25.83           C  
ATOM   1135  CD1 LEU B   6      22.721  46.592  -0.029  1.00 25.14           C  
ATOM   1136  CD2 LEU B   6      24.230  46.192  -1.956  1.00 25.72           C  
ATOM   1137  N   SER B   7      23.189  50.347  -4.010  1.00 27.89           N  
ATOM   1138  CA  SER B   7      22.455  51.447  -4.645  1.00 28.49           C  
ATOM   1139  C   SER B   7      21.200  51.675  -3.834  1.00 28.98           C  
ATOM   1140  O   SER B   7      20.802  50.810  -3.040  1.00 29.04           O  
ATOM   1141  CB  SER B   7      22.082  51.038  -6.055  1.00 28.35           C  
ATOM   1142  OG  SER B   7      21.233  49.913  -5.997  1.00 28.20           O  
ATOM   1143  N   ALA B   8      20.538  52.809  -4.037  1.00 29.28           N  
ATOM   1144  CA  ALA B   8      19.260  53.030  -3.379  1.00 29.28           C  
ATOM   1145  C   ALA B   8      18.256  51.897  -3.668  1.00 29.42           C  
ATOM   1146  O   ALA B   8      17.557  51.433  -2.781  1.00 29.91           O  
ATOM   1147  CB  ALA B   8      18.679  54.373  -3.793  1.00 30.11           C  
ATOM   1148  N   LEU B   9      18.204  51.428  -4.902  1.00 29.51           N  
ATOM   1149  CA  LEU B   9      17.252  50.375  -5.273  1.00 29.19           C  
ATOM   1150  C   LEU B   9      17.624  49.007  -4.628  1.00 29.36           C  
ATOM   1151  O   LEU B   9      16.754  48.221  -4.232  1.00 28.40           O  
ATOM   1152  CB  LEU B   9      17.173  50.311  -6.803  1.00 30.49           C  
ATOM   1153  CG  LEU B   9      16.797  51.651  -7.516  1.00 32.24           C  
ATOM   1154  CD1 LEU B   9      16.879  51.528  -9.012  1.00 33.09           C  
ATOM   1155  CD2 LEU B   9      15.415  52.171  -7.120  1.00 33.74           C  
ATOM   1156  N   GLU B  10      18.924  48.742  -4.470  1.00 28.95           N  
ATOM   1157  CA  GLU B  10      19.362  47.511  -3.792  1.00 29.37           C  
ATOM   1158  C   GLU B  10      18.936  47.538  -2.308  1.00 27.75           C  
ATOM   1159  O   GLU B  10      18.574  46.519  -1.739  1.00 27.20           O  
ATOM   1160  CB  GLU B  10      20.879  47.324  -3.911  1.00 29.03           C  
ATOM   1161  CG  GLU B  10      21.358  46.992  -5.338  1.00 31.79           C  
ATOM   1162  CD  GLU B  10      22.869  46.780  -5.434  1.00 32.67           C  
ATOM   1163  OE1 GLU B  10      23.631  47.754  -5.198  1.00 36.93           O  
ATOM   1164  OE2 GLU B  10      23.290  45.645  -5.770  1.00 38.87           O  
ATOM   1165  N   CYS B  11      18.985  48.712  -1.696  1.00 27.75           N  
ATOM   1166  CA  CYS B  11      18.605  48.861  -0.297  1.00 27.32           C  
ATOM   1167  C   CYS B  11      17.132  48.527  -0.099  1.00 27.17           C  
ATOM   1168  O   CYS B  11      16.765  47.708   0.743  1.00 26.87           O  
ATOM   1169  CB  CYS B  11      18.924  50.260   0.223  1.00 27.52           C  
ATOM   1170  SG  CYS B  11      20.641  50.670   0.332  1.00 27.17           S  
ATOM   1171  N   THR B  12      16.296  49.110  -0.935  1.00 26.62           N  
ATOM   1172  CA  THR B  12      14.884  48.760  -0.973  1.00 27.12           C  
ATOM   1173  C   THR B  12      14.612  47.260  -1.086  1.00 25.75           C  
ATOM   1174  O   THR B  12      13.751  46.754  -0.373  1.00 24.52           O  
ATOM   1175  CB  THR B  12      14.146  49.556  -2.064  1.00 27.68           C  
ATOM   1176  OG1 THR B  12      14.382  50.953  -1.820  1.00 30.86           O  
ATOM   1177  CG2 THR B  12      12.647  49.288  -2.013  1.00 29.66           C  
ATOM   1178  N   LYS B  13      15.361  46.543  -1.914  1.00 24.87           N  
ATOM   1179  CA  LYS B  13      15.167  45.084  -2.081  1.00 24.99           C  
ATOM   1180  C   LYS B  13      15.453  44.294  -0.825  1.00 24.66           C  
ATOM   1181  O   LYS B  13      14.796  43.306  -0.540  1.00 24.48           O  
ATOM   1182  CB  LYS B  13      16.085  44.499  -3.182  1.00 24.41           C  
ATOM   1183  CG  LYS B  13      15.536  44.591  -4.574  1.00 25.95           C  
ATOM   1184  N   VAL B  14      16.480  44.706  -0.094  1.00 25.13           N  
ATOM   1185  CA  VAL B  14      16.808  44.069   1.167  1.00 25.06           C  
ATOM   1186  C   VAL B  14      15.666  44.339   2.163  1.00 24.49           C  
ATOM   1187  O   VAL B  14      15.183  43.426   2.766  1.00 25.12           O  
ATOM   1188  CB  VAL B  14      18.200  44.561   1.705  1.00 24.88           C  
ATOM   1189  CG1 VAL B  14      18.426  44.113   3.115  1.00 26.19           C  
ATOM   1190  CG2 VAL B  14      19.325  44.076   0.814  1.00 23.62           C  
ATOM   1191  N   LEU B  15      15.226  45.581   2.303  1.00 26.01           N  
ATOM   1192  CA  LEU B  15      14.151  45.912   3.250  1.00 26.97           C  
ATOM   1193  C   LEU B  15      12.849  45.189   2.933  1.00 28.75           C  
ATOM   1194  O   LEU B  15      12.164  44.686   3.815  1.00 29.26           O  
ATOM   1195  CB  LEU B  15      13.870  47.403   3.258  1.00 25.97           C  
ATOM   1196  CG  LEU B  15      14.959  48.289   3.792  1.00 25.29           C  
ATOM   1197  CD1 LEU B  15      14.544  49.700   3.566  1.00 28.02           C  
ATOM   1198  CD2 LEU B  15      15.170  48.052   5.269  1.00 24.05           C  
ATOM   1199  N   THR B  16      12.537  45.124   1.648  1.00 30.46           N  
ATOM   1200  CA  THR B  16      11.305  44.530   1.181  1.00 32.35           C  
ATOM   1201  C   THR B  16      11.288  43.046   1.503  1.00 33.21           C  
ATOM   1202  O   THR B  16      10.276  42.513   1.970  1.00 34.22           O  
ATOM   1203  CB  THR B  16      11.178  44.756  -0.340  1.00 32.75           C  
ATOM   1204  OG1 THR B  16      11.003  46.167  -0.613  1.00 33.36           O  
ATOM   1205  CG2 THR B  16      10.034  43.974  -0.912  1.00 34.11           C  
ATOM   1206  N   ALA B  17      12.429  42.396   1.283  1.00 32.90           N  
ATOM   1207  CA  ALA B  17      12.569  40.955   1.405  1.00 32.15           C  
ATOM   1208  C   ALA B  17      12.628  40.430   2.824  1.00 31.49           C  
ATOM   1209  O   ALA B  17      12.384  39.250   3.048  1.00 31.46           O  
ATOM   1210  CB  ALA B  17      13.832  40.474   0.646  1.00 32.69           C  
ATOM   1211  N   ASN B  18      12.979  41.275   3.788  1.00 30.36           N  
ATOM   1212  CA  ASN B  18      13.160  40.808   5.136  1.00 29.25           C  
ATOM   1213  C   ASN B  18      12.038  41.279   6.058  1.00 28.07           C  
ATOM   1214  O   ASN B  18      11.223  42.128   5.697  1.00 27.52           O  
ATOM   1215  CB  ASN B  18      14.552  41.228   5.616  1.00 29.49           C  
ATOM   1216  CG  ASN B  18      15.637  40.448   4.941  1.00 30.04           C  
ATOM   1217  OD1 ASN B  18      15.859  39.285   5.269  1.00 30.15           O  
ATOM   1218  ND2 ASN B  18      16.272  41.044   3.932  1.00 28.20           N  
ATOM   1219  N   ARG B  19      11.992  40.673   7.225  1.00 28.41           N  
ATOM   1220  CA  ARG B  19      10.906  40.858   8.220  1.00 28.87           C  
ATOM   1221  C   ARG B  19      11.368  41.206   9.627  1.00 27.98           C  
ATOM   1222  O   ARG B  19      10.574  41.441  10.474  1.00 26.27           O  
ATOM   1223  CB  ARG B  19      10.075  39.575   8.336  1.00 30.01           C  
ATOM   1224  CG  ARG B  19      10.830  38.338   8.840  1.00 31.49           C  
ATOM   1225  N   VAL B  20      12.656  41.139   9.878  1.00 27.14           N  
ATOM   1226  CA  VAL B  20      13.177  41.427  11.179  1.00 28.37           C  
ATOM   1227  C   VAL B  20      14.307  42.427  11.045  1.00 27.21           C  
ATOM   1228  O   VAL B  20      15.105  42.392  10.104  1.00 27.47           O  
ATOM   1229  CB  VAL B  20      13.611  40.146  11.946  1.00 29.41           C  
ATOM   1230  CG1 VAL B  20      14.804  39.517  11.331  1.00 31.08           C  
ATOM   1231  CG2 VAL B  20      13.911  40.481  13.432  1.00 33.49           C  
ATOM   1232  N   GLY B  21      14.316  43.366  11.968  1.00 25.37           N  
ATOM   1233  CA  GLY B  21      15.364  44.327  12.038  1.00 25.95           C  
ATOM   1234  C   GLY B  21      15.698  44.570  13.501  1.00 24.94           C  
ATOM   1235  O   GLY B  21      15.050  43.993  14.382  1.00 25.82           O  
ATOM   1236  N   ARG B  22      16.710  45.401  13.734  1.00 23.41           N  
ATOM   1237  CA  ARG B  22      17.003  45.936  15.043  1.00 23.42           C  
ATOM   1238  C   ARG B  22      16.690  47.420  15.024  1.00 23.27           C  
ATOM   1239  O   ARG B  22      17.136  48.166  14.153  1.00 25.73           O  
ATOM   1240  CB  ARG B  22      18.446  45.665  15.479  1.00 22.99           C  
ATOM   1241  CG  ARG B  22      18.617  44.343  16.187  1.00 25.30           C  
ATOM   1242  CD  ARG B  22      18.502  43.246  15.219  1.00 27.71           C  
ATOM   1243  NE  ARG B  22      18.729  41.925  15.815  1.00 28.39           N  
ATOM   1244  CZ  ARG B  22      18.731  40.801  15.105  1.00 31.60           C  
ATOM   1245  NH1 ARG B  22      18.507  40.830  13.798  1.00 30.08           N  
ATOM   1246  NH2 ARG B  22      18.959  39.638  15.704  1.00 34.30           N  
ATOM   1247  N   LEU B  23      15.899  47.846  15.979  1.00 23.05           N  
ATOM   1248  CA  LEU B  23      15.460  49.216  16.089  1.00 23.63           C  
ATOM   1249  C   LEU B  23      16.161  49.884  17.253  1.00 23.87           C  
ATOM   1250  O   LEU B  23      16.099  49.387  18.376  1.00 24.54           O  
ATOM   1251  CB  LEU B  23      13.970  49.211  16.377  1.00 24.81           C  
ATOM   1252  CG  LEU B  23      13.350  50.564  16.764  1.00 27.36           C  
ATOM   1253  CD1 LEU B  23      13.287  51.454  15.600  1.00 26.05           C  
ATOM   1254  CD2 LEU B  23      11.961  50.232  17.282  1.00 32.63           C  
ATOM   1255  N   ALA B  24      16.777  51.028  16.985  1.00 22.96           N  
ATOM   1256  CA  ALA B  24      17.416  51.803  17.997  1.00 23.23           C  
ATOM   1257  C   ALA B  24      16.741  53.145  18.194  1.00 23.75           C  
ATOM   1258  O   ALA B  24      16.436  53.834  17.233  1.00 23.89           O  
ATOM   1259  CB  ALA B  24      18.845  52.029  17.619  1.00 23.07           C  
ATOM   1260  N   CYS B  25      16.573  53.518  19.461  1.00 24.60           N  
ATOM   1261  CA  CYS B  25      16.064  54.800  19.868  1.00 23.41           C  
ATOM   1262  C   CYS B  25      17.039  55.343  20.919  1.00 23.30           C  
ATOM   1263  O   CYS B  25      18.040  54.675  21.274  1.00 22.67           O  
ATOM   1264  CB  CYS B  25      14.664  54.685  20.424  1.00 23.94           C  
ATOM   1265  SG  CYS B  25      14.414  53.557  21.834  1.00 27.21           S  
ATOM   1266  N   ALA B  26      16.780  56.553  21.387  1.00 21.97           N  
ATOM   1267  CA  ALA B  26      17.676  57.166  22.379  1.00 22.60           C  
ATOM   1268  C   ALA B  26      16.962  58.124  23.307  1.00 22.65           C  
ATOM   1269  O   ALA B  26      15.929  58.712  22.946  1.00 23.80           O  
ATOM   1270  CB  ALA B  26      18.830  57.907  21.658  1.00 22.42           C  
ATOM   1271  N   LYS B  27      17.536  58.288  24.494  1.00 23.45           N  
ATOM   1272  CA  LYS B  27      17.096  59.286  25.463  1.00 22.99           C  
ATOM   1273  C   LYS B  27      18.300  59.802  26.206  1.00 23.66           C  
ATOM   1274  O   LYS B  27      19.057  59.016  26.803  1.00 22.40           O  
ATOM   1275  CB  LYS B  27      16.159  58.685  26.487  1.00 23.32           C  
ATOM   1276  CG  LYS B  27      15.603  59.686  27.493  1.00 26.59           C  
ATOM   1277  CD  LYS B  27      14.916  58.942  28.629  1.00 33.83           C  
ATOM   1278  CE  LYS B  27      13.566  59.498  28.933  1.00 39.78           C  
ATOM   1279  NZ  LYS B  27      12.667  59.257  27.761  1.00 41.00           N  
ATOM   1280  N   ASP B  28      18.432  61.124  26.211  1.00 24.65           N  
ATOM   1281  CA  ASP B  28      19.539  61.830  26.879  1.00 26.63           C  
ATOM   1282  C   ASP B  28      20.902  61.215  26.505  1.00 26.68           C  
ATOM   1283  O   ASP B  28      21.754  60.996  27.363  1.00 28.90           O  
ATOM   1284  CB  ASP B  28      19.319  61.864  28.396  1.00 27.98           C  
ATOM   1285  CG  ASP B  28      18.003  62.575  28.769  1.00 31.49           C  
ATOM   1286  OD1 ASP B  28      17.592  63.470  27.995  1.00 36.26           O  
ATOM   1287  OD2 ASP B  28      17.365  62.225  29.793  1.00 35.87           O  
ATOM   1288  N   GLY B  29      21.090  60.910  25.224  1.00 25.71           N  
ATOM   1289  CA  GLY B  29      22.389  60.411  24.751  1.00 25.14           C  
ATOM   1290  C   GLY B  29      22.581  58.913  24.899  1.00 24.38           C  
ATOM   1291  O   GLY B  29      23.577  58.374  24.408  1.00 24.21           O  
ATOM   1292  N   GLN B  30      21.636  58.234  25.569  1.00 23.01           N  
ATOM   1293  CA  GLN B  30      21.724  56.793  25.796  1.00 22.43           C  
ATOM   1294  C   GLN B  30      20.914  56.111  24.733  1.00 22.50           C  
ATOM   1295  O   GLN B  30      19.701  56.359  24.649  1.00 21.99           O  
ATOM   1296  CB  GLN B  30      21.144  56.402  27.146  1.00 22.67           C  
ATOM   1297  CG  GLN B  30      21.110  54.922  27.424  1.00 21.13           C  
ATOM   1298  CD  GLN B  30      22.477  54.306  27.401  1.00 22.57           C  
ATOM   1299  OE1 GLN B  30      23.390  54.773  28.083  1.00 23.79           O  
ATOM   1300  NE2 GLN B  30      22.649  53.300  26.588  1.00 19.52           N  
ATOM   1301  N   PRO B  31      21.561  55.269  23.908  1.00 21.78           N  
ATOM   1302  CA  PRO B  31      20.796  54.419  23.003  1.00 20.94           C  
ATOM   1303  C   PRO B  31      20.145  53.193  23.649  1.00 21.60           C  
ATOM   1304  O   PRO B  31      20.537  52.732  24.746  1.00 20.20           O  
ATOM   1305  CB  PRO B  31      21.855  53.992  21.958  1.00 21.39           C  
ATOM   1306  CG  PRO B  31      23.071  54.874  22.229  1.00 22.02           C  
ATOM   1307  CD  PRO B  31      23.001  55.086  23.695  1.00 21.94           C  
ATOM   1308  N   TYR B  32      19.165  52.660  22.925  1.00 22.08           N  
ATOM   1309  CA  TYR B  32      18.484  51.458  23.302  1.00 23.10           C  
ATOM   1310  C   TYR B  32      18.083  50.723  22.041  1.00 22.42           C  
ATOM   1311  O   TYR B  32      17.522  51.323  21.154  1.00 23.31           O  
ATOM   1312  CB  TYR B  32      17.297  51.847  24.166  1.00 22.59           C  
ATOM   1313  CG  TYR B  32      16.395  50.741  24.560  1.00 22.96           C  
ATOM   1314  CD1 TYR B  32      16.881  49.594  25.175  1.00 23.68           C  
ATOM   1315  CD2 TYR B  32      15.052  50.811  24.315  1.00 22.31           C  
ATOM   1316  CE1 TYR B  32      16.001  48.562  25.535  1.00 24.18           C  
ATOM   1317  CE2 TYR B  32      14.167  49.772  24.686  1.00 22.64           C  
ATOM   1318  CZ  TYR B  32      14.634  48.685  25.289  1.00 24.27           C  
ATOM   1319  OH  TYR B  32      13.735  47.721  25.697  1.00 24.77           O  
ATOM   1320  N   VAL B  33      18.518  49.471  21.904  1.00 23.11           N  
ATOM   1321  CA  VAL B  33      18.279  48.720  20.688  1.00 23.23           C  
ATOM   1322  C   VAL B  33      17.639  47.370  20.974  1.00 22.86           C  
ATOM   1323  O   VAL B  33      18.085  46.659  21.841  1.00 22.66           O  
ATOM   1324  CB  VAL B  33      19.572  48.609  19.829  1.00 24.20           C  
ATOM   1325  CG1 VAL B  33      20.710  48.013  20.578  1.00 24.19           C  
ATOM   1326  CG2 VAL B  33      19.301  47.865  18.536  1.00 24.50           C  
ATOM   1327  N   VAL B  34      16.563  47.045  20.246  1.00 22.23           N  
ATOM   1328  CA  VAL B  34      15.872  45.766  20.402  1.00 23.14           C  
ATOM   1329  C   VAL B  34      15.453  45.206  19.042  1.00 22.81           C  
ATOM   1330  O   VAL B  34      15.315  45.955  18.097  1.00 22.17           O  
ATOM   1331  CB  VAL B  34      14.599  45.903  21.277  1.00 24.24           C  
ATOM   1332  CG1 VAL B  34      14.977  46.271  22.687  1.00 25.68           C  
ATOM   1333  CG2 VAL B  34      13.645  46.941  20.676  1.00 26.23           C  
ATOM   1334  N   PRO B  35      15.246  43.894  18.960  1.00 23.35           N  
ATOM   1335  CA  PRO B  35      14.759  43.342  17.715  1.00 25.11           C  
ATOM   1336  C   PRO B  35      13.258  43.627  17.507  1.00 25.86           C  
ATOM   1337  O   PRO B  35      12.474  43.655  18.473  1.00 27.41           O  
ATOM   1338  CB  PRO B  35      15.036  41.855  17.860  1.00 25.28           C  
ATOM   1339  CG  PRO B  35      15.113  41.581  19.335  1.00 25.07           C  
ATOM   1340  CD  PRO B  35      15.483  42.861  20.000  1.00 24.72           C  
ATOM   1341  N   LEU B  36      12.863  43.723  16.247  1.00 26.13           N  
ATOM   1342  CA  LEU B  36      11.497  44.052  15.896  1.00 26.68           C  
ATOM   1343  C   LEU B  36      11.112  43.431  14.571  1.00 25.57           C  
ATOM   1344  O   LEU B  36      11.904  43.447  13.636  1.00 24.47           O  
ATOM   1345  CB  LEU B  36      11.380  45.551  15.783  1.00 27.35           C  
ATOM   1346  CG  LEU B  36       9.981  46.144  15.627  1.00 31.66           C  
ATOM   1347  CD1 LEU B  36       9.425  46.550  16.997  1.00 33.59           C  
ATOM   1348  CD2 LEU B  36      10.078  47.326  14.695  1.00 34.07           C  
ATOM   1349  N   TYR B  37       9.896  42.890  14.495  1.00 24.92           N  
ATOM   1350  CA  TYR B  37       9.363  42.417  13.226  1.00 24.34           C  
ATOM   1351  C   TYR B  37       8.735  43.598  12.532  1.00 24.32           C  
ATOM   1352  O   TYR B  37       8.028  44.399  13.183  1.00 24.01           O  
ATOM   1353  CB  TYR B  37       8.314  41.360  13.459  1.00 26.36           C  
ATOM   1354  CG  TYR B  37       8.835  40.025  13.835  1.00 27.45           C  
ATOM   1355  CD1 TYR B  37       9.795  39.389  13.061  1.00 30.76           C  
ATOM   1356  CD2 TYR B  37       8.310  39.346  14.920  1.00 31.27           C  
ATOM   1357  CE1 TYR B  37      10.277  38.127  13.399  1.00 33.05           C  
ATOM   1358  CE2 TYR B  37       8.757  38.078  15.259  1.00 30.79           C  
ATOM   1359  CZ  TYR B  37       9.732  37.474  14.493  1.00 31.10           C  
ATOM   1360  OH  TYR B  37      10.195  36.238  14.835  1.00 33.11           O  
ATOM   1361  N   TYR B  38       8.955  43.741  11.225  1.00 22.39           N  
ATOM   1362  CA  TYR B  38       8.337  44.854  10.494  1.00 22.49           C  
ATOM   1363  C   TYR B  38       7.769  44.377   9.167  1.00 23.10           C  
ATOM   1364  O   TYR B  38       8.110  43.278   8.680  1.00 23.46           O  
ATOM   1365  CB  TYR B  38       9.366  45.995  10.264  1.00 22.84           C  
ATOM   1366  CG  TYR B  38      10.386  45.593   9.244  1.00 20.71           C  
ATOM   1367  CD1 TYR B  38      11.545  44.903   9.612  1.00 23.53           C  
ATOM   1368  CD2 TYR B  38      10.174  45.834   7.894  1.00 25.09           C  
ATOM   1369  CE1 TYR B  38      12.459  44.486   8.663  1.00 22.80           C  
ATOM   1370  CE2 TYR B  38      11.103  45.378   6.917  1.00 22.22           C  
ATOM   1371  CZ  TYR B  38      12.215  44.723   7.315  1.00 23.35           C  
ATOM   1372  OH  TYR B  38      13.072  44.311   6.336  1.00 23.75           O  
ATOM   1373  N   ALA B  39       6.927  45.202   8.573  1.00 23.15           N  
ATOM   1374  CA  ALA B  39       6.463  44.963   7.188  1.00 24.46           C  
ATOM   1375  C   ALA B  39       6.755  46.236   6.396  1.00 24.59           C  
ATOM   1376  O   ALA B  39       6.384  47.293   6.833  1.00 24.59           O  
ATOM   1377  CB  ALA B  39       4.940  44.664   7.165  1.00 24.03           C  
ATOM   1378  N   TYR B  40       7.462  46.123   5.275  1.00 25.00           N  
ATOM   1379  CA  TYR B  40       7.769  47.269   4.424  1.00 25.65           C  
ATOM   1380  C   TYR B  40       6.587  47.659   3.507  1.00 26.10           C  
ATOM   1381  O   TYR B  40       5.999  46.806   2.833  1.00 24.55           O  
ATOM   1382  CB  TYR B  40       8.995  46.954   3.539  1.00 26.69           C  
ATOM   1383  CG  TYR B  40       9.265  48.041   2.554  1.00 27.10           C  
ATOM   1384  CD1 TYR B  40      10.042  49.138   2.914  1.00 31.74           C  
ATOM   1385  CD2 TYR B  40       8.706  48.016   1.296  1.00 28.64           C  
ATOM   1386  CE1 TYR B  40      10.231  50.182   2.042  1.00 31.25           C  
ATOM   1387  CE2 TYR B  40       8.885  49.054   0.403  1.00 28.69           C  
ATOM   1388  CZ  TYR B  40       9.647  50.129   0.783  1.00 30.32           C  
ATOM   1389  OH  TYR B  40       9.831  51.160  -0.091  1.00 31.27           O  
ATOM   1390  N   SER B  41       6.291  48.956   3.436  1.00 25.52           N  
ATOM   1391  CA  SER B  41       5.432  49.495   2.367  1.00 27.13           C  
ATOM   1392  C   SER B  41       5.621  50.991   2.247  1.00 27.03           C  
ATOM   1393  O   SER B  41       5.695  51.680   3.255  1.00 26.15           O  
ATOM   1394  CB  SER B  41       3.946  49.231   2.622  1.00 26.84           C  
ATOM   1395  OG  SER B  41       3.187  49.637   1.498  1.00 28.52           O  
ATOM   1396  N   ASP B  42       5.696  51.472   1.024  1.00 27.80           N  
ATOM   1397  CA  ASP B  42       5.580  52.906   0.732  1.00 30.11           C  
ATOM   1398  C   ASP B  42       6.644  53.727   1.514  1.00 30.16           C  
ATOM   1399  O   ASP B  42       6.316  54.757   2.057  1.00 31.29           O  
ATOM   1400  CB  ASP B  42       4.100  53.461   0.927  1.00 30.85           C  
ATOM   1401  CG  ASP B  42       3.437  53.198   2.389  1.00 36.94           C  
ATOM   1402  OD1 ASP B  42       3.734  53.921   3.389  1.00 43.15           O  
ATOM   1403  OD2 ASP B  42       2.530  52.308   2.524  1.00 41.40           O  
ATOM   1404  N   ALA B  43       7.887  53.230   1.578  1.00 29.51           N  
ATOM   1405  CA  ALA B  43       9.022  53.893   2.284  1.00 29.20           C  
ATOM   1406  C   ALA B  43       8.783  54.064   3.775  1.00 28.73           C  
ATOM   1407  O   ALA B  43       9.290  55.003   4.411  1.00 29.33           O  
ATOM   1408  CB  ALA B  43       9.356  55.219   1.657  1.00 30.46           C  
ATOM   1409  N   HIS B  44       8.017  53.126   4.318  1.00 26.16           N  
ATOM   1410  CA  HIS B  44       7.823  52.996   5.723  1.00 25.98           C  
ATOM   1411  C   HIS B  44       8.032  51.557   6.134  1.00 23.85           C  
ATOM   1412  O   HIS B  44       7.713  50.615   5.382  1.00 22.28           O  
ATOM   1413  CB  HIS B  44       6.411  53.378   6.102  1.00 26.69           C  
ATOM   1414  CG  HIS B  44       6.049  54.796   5.794  1.00 29.32           C  
ATOM   1415  ND1 HIS B  44       5.384  55.152   4.646  1.00 33.69           N  
ATOM   1416  CD2 HIS B  44       6.180  55.932   6.526  1.00 33.61           C  
ATOM   1417  CE1 HIS B  44       5.159  56.457   4.655  1.00 35.54           C  
ATOM   1418  NE2 HIS B  44       5.613  56.949   5.796  1.00 35.82           N  
ATOM   1419  N   LEU B  45       8.473  51.400   7.361  1.00 22.36           N  
ATOM   1420  CA  LEU B  45       8.462  50.120   8.052  1.00 22.99           C  
ATOM   1421  C   LEU B  45       7.370  50.089   9.114  1.00 23.69           C  
ATOM   1422  O   LEU B  45       7.417  50.853  10.065  1.00 24.47           O  
ATOM   1423  CB  LEU B  45       9.809  49.895   8.723  1.00 21.08           C  
ATOM   1424  CG  LEU B  45      11.020  50.158   7.862  1.00 24.26           C  
ATOM   1425  CD1 LEU B  45      12.298  49.908   8.625  1.00 24.82           C  
ATOM   1426  CD2 LEU B  45      11.039  49.321   6.609  1.00 21.67           C  
ATOM   1427  N   TYR B  46       6.395  49.199   8.962  1.00 24.62           N  
ATOM   1428  CA  TYR B  46       5.252  49.101   9.878  1.00 23.88           C  
ATOM   1429  C   TYR B  46       5.479  48.010  10.895  1.00 23.68           C  
ATOM   1430  O   TYR B  46       6.078  46.952  10.608  1.00 24.96           O  
ATOM   1431  CB  TYR B  46       3.933  48.814   9.092  1.00 24.25           C  
ATOM   1432  CG  TYR B  46       3.457  49.947   8.210  1.00 24.65           C  
ATOM   1433  CD1 TYR B  46       3.981  50.155   6.935  1.00 24.71           C  
ATOM   1434  CD2 TYR B  46       2.480  50.831   8.656  1.00 25.90           C  
ATOM   1435  CE1 TYR B  46       3.543  51.204   6.164  1.00 26.96           C  
ATOM   1436  CE2 TYR B  46       2.052  51.880   7.867  1.00 25.52           C  
ATOM   1437  CZ  TYR B  46       2.556  52.055   6.658  1.00 24.80           C  
ATOM   1438  OH  TYR B  46       2.075  53.145   5.923  1.00 27.16           O  
ATOM   1439  N   ALA B  47       5.006  48.254  12.109  1.00 23.60           N  
ATOM   1440  CA  ALA B  47       5.204  47.331  13.186  1.00 23.10           C  
ATOM   1441  C   ALA B  47       4.177  47.568  14.292  1.00 23.63           C  
ATOM   1442  O   ALA B  47       3.465  48.590  14.310  1.00 23.80           O  
ATOM   1443  CB  ALA B  47       6.688  47.391  13.716  1.00 22.40           C  
ATOM   1444  N   PHE B  48       4.069  46.576  15.166  1.00 23.57           N  
ATOM   1445  CA  PHE B  48       3.206  46.613  16.343  1.00 24.18           C  
ATOM   1446  C   PHE B  48       4.084  46.449  17.553  1.00 25.56           C  
ATOM   1447  O   PHE B  48       5.125  45.786  17.470  1.00 24.37           O  
ATOM   1448  CB  PHE B  48       2.145  45.494  16.305  1.00 23.98           C  
ATOM   1449  CG  PHE B  48       1.051  45.751  15.328  1.00 24.43           C  
ATOM   1450  CD1 PHE B  48       1.182  45.357  14.006  1.00 25.13           C  
ATOM   1451  CD2 PHE B  48      -0.100  46.425  15.714  1.00 27.13           C  
ATOM   1452  CE1 PHE B  48       0.204  45.666  13.081  1.00 26.41           C  
ATOM   1453  CE2 PHE B  48      -1.063  46.719  14.789  1.00 27.50           C  
ATOM   1454  CZ  PHE B  48      -0.918  46.320  13.479  1.00 23.62           C  
ATOM   1455  N   SER B  49       3.678  47.054  18.664  1.00 25.73           N  
ATOM   1456  CA  SER B  49       4.349  46.862  19.945  1.00 27.00           C  
ATOM   1457  C   SER B  49       3.318  46.864  21.083  1.00 27.37           C  
ATOM   1458  O   SER B  49       2.248  47.455  20.966  1.00 28.52           O  
ATOM   1459  CB  SER B  49       5.389  47.983  20.173  1.00 26.98           C  
ATOM   1460  OG  SER B  49       6.039  47.840  21.431  1.00 28.66           O  
HETATM 1461  N   MSE B  50       3.639  46.213  22.184  1.00 27.66           N  
HETATM 1462  CA  MSE B  50       2.916  46.479  23.429  1.00 28.40           C  
HETATM 1463  C   MSE B  50       3.526  47.742  24.050  1.00 27.82           C  
HETATM 1464  O   MSE B  50       4.644  48.153  23.681  1.00 27.40           O  
HETATM 1465  CB  MSE B  50       2.998  45.270  24.363  1.00 29.11           C  
HETATM 1466  CG  MSE B  50       2.273  44.012  23.826  1.00 33.06           C  
HETATM 1467 SE   MSE B  50       0.371  44.355  23.555  0.75 41.83          SE  
HETATM 1468  CE  MSE B  50      -0.146  44.424  25.371  1.00 40.95           C  
ATOM   1469  N   PRO B  51       2.800  48.393  24.965  1.00 28.22           N  
ATOM   1470  CA  PRO B  51       3.388  49.521  25.683  1.00 28.18           C  
ATOM   1471  C   PRO B  51       4.695  49.155  26.331  1.00 27.90           C  
ATOM   1472  O   PRO B  51       4.872  48.008  26.750  1.00 28.26           O  
ATOM   1473  CB  PRO B  51       2.376  49.802  26.784  1.00 28.66           C  
ATOM   1474  CG  PRO B  51       1.095  49.295  26.238  1.00 30.26           C  
ATOM   1475  CD  PRO B  51       1.425  48.111  25.406  1.00 28.43           C  
ATOM   1476  N   GLY B  52       5.594  50.123  26.478  1.00 27.52           N  
ATOM   1477  CA  GLY B  52       6.900  49.842  27.095  1.00 25.83           C  
ATOM   1478  C   GLY B  52       7.972  50.854  26.783  1.00 25.63           C  
ATOM   1479  O   GLY B  52       7.704  51.870  26.157  1.00 25.15           O  
ATOM   1480  N   LYS B  53       9.197  50.555  27.206  1.00 24.44           N  
ATOM   1481  CA  LYS B  53      10.339  51.472  27.062  1.00 24.50           C  
ATOM   1482  C   LYS B  53      10.532  52.023  25.678  1.00 23.85           C  
ATOM   1483  O   LYS B  53      10.572  53.241  25.505  1.00 23.54           O  
ATOM   1484  CB  LYS B  53      11.637  50.770  27.537  1.00 24.44           C  
ATOM   1485  CG  LYS B  53      12.812  51.667  27.781  1.00 24.89           C  
ATOM   1486  CD  LYS B  53      14.042  50.923  28.301  1.00 24.32           C  
ATOM   1487  CE  LYS B  53      15.306  51.722  28.117  1.00 27.61           C  
ATOM   1488  NZ  LYS B  53      16.437  51.118  28.876  1.00 26.61           N  
ATOM   1489  N   LYS B  54      10.655  51.175  24.677  1.00 22.01           N  
ATOM   1490  CA  LYS B  54      10.929  51.714  23.339  1.00 22.11           C  
ATOM   1491  C   LYS B  54       9.823  52.655  22.841  1.00 22.20           C  
ATOM   1492  O   LYS B  54      10.119  53.666  22.239  1.00 20.99           O  
ATOM   1493  CB  LYS B  54      11.169  50.648  22.311  1.00 22.40           C  
ATOM   1494  CG  LYS B  54      10.042  49.730  22.060  1.00 24.70           C  
ATOM   1495  CD  LYS B  54      10.438  48.624  21.089  1.00 27.53           C  
ATOM   1496  CE  LYS B  54       9.276  47.797  20.685  1.00 27.99           C  
ATOM   1497  NZ  LYS B  54       8.453  47.301  21.889  1.00 29.75           N  
ATOM   1498  N   ILE B  55       8.579  52.329  23.101  1.00 22.20           N  
ATOM   1499  CA  ILE B  55       7.488  53.232  22.747  1.00 23.45           C  
ATOM   1500  C   ILE B  55       7.597  54.537  23.538  1.00 23.86           C  
ATOM   1501  O   ILE B  55       7.435  55.628  22.971  1.00 25.45           O  
ATOM   1502  CB  ILE B  55       6.131  52.555  22.954  1.00 23.59           C  
ATOM   1503  CG1 ILE B  55       5.988  51.361  21.998  1.00 23.69           C  
ATOM   1504  CG2 ILE B  55       4.991  53.518  22.716  1.00 22.77           C  
ATOM   1505  CD1 ILE B  55       6.140  51.729  20.499  1.00 24.56           C  
ATOM   1506  N   GLU B  56       7.830  54.462  24.842  1.00 23.95           N  
ATOM   1507  CA  GLU B  56       7.977  55.700  25.605  1.00 24.79           C  
ATOM   1508  C   GLU B  56       9.121  56.599  25.076  1.00 24.28           C  
ATOM   1509  O   GLU B  56       8.967  57.824  24.926  1.00 24.60           O  
ATOM   1510  CB  GLU B  56       8.179  55.416  27.082  1.00 25.30           C  
ATOM   1511  CG  GLU B  56       6.975  54.846  27.781  1.00 26.13           C  
ATOM   1512  CD  GLU B  56       5.733  55.714  27.583  1.00 28.97           C  
ATOM   1513  OE1 GLU B  56       5.608  56.712  28.315  1.00 28.71           O  
ATOM   1514  OE2 GLU B  56       4.909  55.387  26.695  1.00 30.98           O  
ATOM   1515  N   TRP B  57      10.262  55.994  24.791  1.00 24.42           N  
ATOM   1516  CA  TRP B  57      11.423  56.732  24.299  1.00 24.41           C  
ATOM   1517  C   TRP B  57      11.212  57.321  22.907  1.00 25.21           C  
ATOM   1518  O   TRP B  57      11.680  58.443  22.624  1.00 26.32           O  
ATOM   1519  CB  TRP B  57      12.656  55.830  24.339  1.00 24.18           C  
ATOM   1520  CG  TRP B  57      13.248  55.668  25.702  1.00 24.75           C  
ATOM   1521  CD1 TRP B  57      12.620  55.772  26.911  1.00 22.93           C  
ATOM   1522  CD2 TRP B  57      14.614  55.387  25.976  1.00 22.33           C  
ATOM   1523  NE1 TRP B  57      13.525  55.575  27.924  1.00 24.57           N  
ATOM   1524  CE2 TRP B  57      14.762  55.351  27.367  1.00 24.68           C  
ATOM   1525  CE3 TRP B  57      15.746  55.214  25.160  1.00 22.03           C  
ATOM   1526  CZ2 TRP B  57      15.981  55.107  27.966  1.00 24.04           C  
ATOM   1527  CZ3 TRP B  57      16.932  54.966  25.744  1.00 23.40           C  
ATOM   1528  CH2 TRP B  57      17.056  54.896  27.127  1.00 23.16           C  
HETATM 1529  N   MSE B  58      10.507  56.609  22.036  1.00 24.31           N  
HETATM 1530  CA  MSE B  58      10.244  57.137  20.686  1.00 23.63           C  
HETATM 1531  C   MSE B  58       9.152  58.206  20.649  1.00 23.64           C  
HETATM 1532  O   MSE B  58       9.188  59.104  19.819  1.00 21.50           O  
HETATM 1533  CB  MSE B  58       9.901  55.979  19.729  1.00 24.12           C  
HETATM 1534  CG  MSE B  58      11.073  55.071  19.532  1.00 23.83           C  
HETATM 1535 SE   MSE B  58      10.826  53.719  18.160  0.75 21.77          SE  
HETATM 1536  CE  MSE B  58       9.406  52.708  19.064  1.00 28.17           C  
ATOM   1537  N   ARG B  59       8.206  58.124  21.589  1.00 23.42           N  
ATOM   1538  CA  ARG B  59       7.204  59.144  21.776  1.00 23.54           C  
ATOM   1539  C   ARG B  59       7.899  60.426  22.156  1.00 23.69           C  
ATOM   1540  O   ARG B  59       7.527  61.489  21.664  1.00 25.18           O  
ATOM   1541  CB  ARG B  59       6.161  58.745  22.847  1.00 23.01           C  
ATOM   1542  CG  ARG B  59       5.013  57.818  22.333  1.00 22.17           C  
ATOM   1543  CD  ARG B  59       4.228  57.260  23.497  1.00 23.09           C  
ATOM   1544  NE  ARG B  59       3.165  56.433  22.963  1.00 23.33           N  
ATOM   1545  CZ  ARG B  59       2.428  55.586  23.652  1.00 23.10           C  
ATOM   1546  NH1 ARG B  59       2.606  55.438  24.961  1.00 21.39           N  
ATOM   1547  NH2 ARG B  59       1.480  54.880  22.996  1.00 22.06           N  
ATOM   1548  N   ALA B  60       8.885  60.358  23.030  1.00 23.31           N  
ATOM   1549  CA  ALA B  60       9.625  61.573  23.416  1.00 23.81           C  
ATOM   1550  C   ALA B  60      10.702  62.072  22.394  1.00 23.89           C  
ATOM   1551  O   ALA B  60      10.950  63.289  22.278  1.00 22.59           O  
ATOM   1552  CB  ALA B  60      10.241  61.392  24.797  1.00 24.68           C  
ATOM   1553  N   ASN B  61      11.349  61.153  21.700  1.00 23.96           N  
ATOM   1554  CA  ASN B  61      12.375  61.434  20.697  1.00 24.75           C  
ATOM   1555  C   ASN B  61      12.118  60.540  19.490  1.00 23.76           C  
ATOM   1556  O   ASN B  61      12.486  59.392  19.505  1.00 23.92           O  
ATOM   1557  CB  ASN B  61      13.803  61.123  21.218  1.00 25.13           C  
ATOM   1558  CG  ASN B  61      14.884  61.297  20.123  1.00 27.45           C  
ATOM   1559  OD1 ASN B  61      14.608  61.913  19.061  1.00 24.65           O  
ATOM   1560  ND2 ASN B  61      16.130  60.784  20.390  1.00 23.16           N  
ATOM   1561  N   PRO B  62      11.491  61.062  18.439  1.00 23.12           N  
ATOM   1562  CA  PRO B  62      11.186  60.159  17.355  1.00 24.13           C  
ATOM   1563  C   PRO B  62      12.338  59.832  16.397  1.00 22.77           C  
ATOM   1564  O   PRO B  62      12.099  59.128  15.453  1.00 21.89           O  
ATOM   1565  CB  PRO B  62      10.012  60.842  16.646  1.00 23.36           C  
ATOM   1566  CG  PRO B  62      10.258  62.248  16.868  1.00 25.85           C  
ATOM   1567  CD  PRO B  62      11.002  62.419  18.168  1.00 25.44           C  
ATOM   1568  N   ARG B  63      13.587  60.265  16.654  1.00 21.90           N  
ATOM   1569  CA  ARG B  63      14.717  59.849  15.817  0.50 21.69           C  
ATOM   1571  C   ARG B  63      15.097  58.395  16.104  1.00 21.53           C  
ATOM   1572  O   ARG B  63      15.334  58.028  17.255  1.00 22.53           O  
ATOM   1573  CB  ARG B  63      15.939  60.763  16.052  0.50 22.00           C  
ATOM   1575  CG  ARG B  63      15.678  62.244  15.901  0.50 21.76           C  
ATOM   1577  CD  ARG B  63      16.889  63.034  16.381  0.50 22.19           C  
ATOM   1579  NE  ARG B  63      16.785  64.483  16.252  0.50 22.59           N  
ATOM   1581  CZ  ARG B  63      16.007  65.269  17.003  0.50 23.49           C  
ATOM   1583  NH1 ARG B  63      15.187  64.743  17.914  0.50 24.91           N  
ATOM   1585  NH2 ARG B  63      16.013  66.577  16.802  0.50 22.97           N  
ATOM   1587  N   VAL B  64      15.166  57.564  15.053  1.00 20.55           N  
ATOM   1588  CA  VAL B  64      15.559  56.205  15.208  1.00 23.05           C  
ATOM   1589  C   VAL B  64      16.536  55.774  14.114  1.00 21.68           C  
ATOM   1590  O   VAL B  64      16.704  56.434  13.106  1.00 22.37           O  
ATOM   1591  CB  VAL B  64      14.326  55.219  15.168  1.00 23.09           C  
ATOM   1592  CG1 VAL B  64      13.318  55.617  16.244  1.00 24.13           C  
ATOM   1593  CG2 VAL B  64      13.686  55.172  13.793  1.00 25.15           C  
ATOM   1594  N   SER B  65      17.108  54.609  14.325  1.00 23.10           N  
ATOM   1595  CA  SER B  65      17.868  53.912  13.286  1.00 23.90           C  
ATOM   1596  C   SER B  65      17.401  52.463  13.293  1.00 24.28           C  
ATOM   1597  O   SER B  65      17.076  51.899  14.369  1.00 24.90           O  
ATOM   1598  CB  SER B  65      19.368  54.040  13.559  1.00 24.06           C  
ATOM   1599  OG  SER B  65      20.150  53.289  12.647  1.00 25.21           O  
ATOM   1600  N   VAL B  66      17.323  51.861  12.098  1.00 23.68           N  
ATOM   1601  CA  VAL B  66      16.956  50.443  11.948  1.00 23.15           C  
ATOM   1602  C   VAL B  66      17.964  49.737  11.065  1.00 22.69           C  
ATOM   1603  O   VAL B  66      18.323  50.241  10.023  1.00 21.72           O  
ATOM   1604  CB  VAL B  66      15.539  50.286  11.308  1.00 23.26           C  
ATOM   1605  CG1 VAL B  66      15.126  48.842  11.259  1.00 25.14           C  
ATOM   1606  CG2 VAL B  66      14.499  51.026  12.092  1.00 24.57           C  
ATOM   1607  N   GLN B  67      18.409  48.568  11.489  1.00 22.12           N  
ATOM   1608  CA  GLN B  67      19.349  47.775  10.749  1.00 22.60           C  
ATOM   1609  C   GLN B  67      18.758  46.418  10.363  1.00 21.78           C  
ATOM   1610  O   GLN B  67      18.152  45.719  11.196  1.00 20.00           O  
ATOM   1611  CB  GLN B  67      20.636  47.584  11.568  1.00 23.38           C  
ATOM   1612  CG  GLN B  67      21.744  46.952  10.756  1.00 23.82           C  
ATOM   1613  CD  GLN B  67      21.746  45.414  10.878  1.00 23.88           C  
ATOM   1614  OE1 GLN B  67      21.273  44.845  11.885  1.00 21.87           O  
ATOM   1615  NE2 GLN B  67      22.289  44.743   9.860  1.00 21.61           N  
ATOM   1616  N   VAL B  68      18.930  46.048   9.090  1.00 22.49           N  
ATOM   1617  CA  VAL B  68      18.320  44.856   8.534  1.00 21.21           C  
ATOM   1618  C   VAL B  68      19.390  44.184   7.729  1.00 21.73           C  
ATOM   1619  O   VAL B  68      20.122  44.841   7.019  1.00 21.53           O  
ATOM   1620  CB  VAL B  68      17.123  45.226   7.627  1.00 21.16           C  
ATOM   1621  CG1 VAL B  68      16.519  44.004   6.932  1.00 21.77           C  
ATOM   1622  CG2 VAL B  68      16.051  45.982   8.442  1.00 20.42           C  
ATOM   1623  N   ASP B  69      19.509  42.869   7.833  1.00 22.49           N  
ATOM   1624  CA  ASP B  69      20.456  42.175   6.981  1.00 24.55           C  
ATOM   1625  C   ASP B  69      20.019  40.796   6.565  1.00 25.87           C  
ATOM   1626  O   ASP B  69      19.069  40.253   7.095  1.00 25.04           O  
ATOM   1627  CB  ASP B  69      21.858  42.127   7.613  1.00 24.99           C  
ATOM   1628  CG  ASP B  69      21.861  41.474   8.976  1.00 29.53           C  
ATOM   1629  OD1 ASP B  69      21.391  40.321   9.079  1.00 32.48           O  
ATOM   1630  OD2 ASP B  69      22.327  42.131   9.942  1.00 35.29           O  
ATOM   1631  N   GLU B  70      20.747  40.219   5.613  1.00 27.22           N  
ATOM   1632  CA  GLU B  70      20.441  38.904   5.146  1.00 30.39           C  
ATOM   1633  C   GLU B  70      21.736  38.235   4.732  1.00 32.51           C  
ATOM   1634  O   GLU B  70      22.724  38.893   4.440  1.00 30.69           O  
ATOM   1635  CB  GLU B  70      19.450  38.967   3.968  1.00 30.08           C  
ATOM   1636  CG  GLU B  70      20.007  39.735   2.758  1.00 30.63           C  
ATOM   1637  CD  GLU B  70      19.054  39.813   1.565  1.00 31.59           C  
ATOM   1638  OE1 GLU B  70      17.801  39.920   1.736  1.00 30.40           O  
ATOM   1639  OE2 GLU B  70      19.583  39.814   0.424  1.00 32.76           O  
ATOM   1640  N   HIS B  71      21.723  36.910   4.743  1.00 36.88           N  
ATOM   1641  CA  HIS B  71      22.804  36.138   4.129  1.00 39.91           C  
ATOM   1642  C   HIS B  71      22.752  36.176   2.611  1.00 41.30           C  
ATOM   1643  O   HIS B  71      21.691  36.321   1.992  1.00 40.92           O  
ATOM   1644  CB  HIS B  71      22.749  34.673   4.560  1.00 41.44           C  
ATOM   1645  CG  HIS B  71      23.136  34.468   5.985  1.00 45.16           C  
ATOM   1646  ND1 HIS B  71      22.277  33.931   6.922  1.00 49.35           N  
ATOM   1647  CD2 HIS B  71      24.278  34.771   6.649  1.00 49.49           C  
ATOM   1648  CE1 HIS B  71      22.878  33.897   8.099  1.00 50.23           C  
ATOM   1649  NE2 HIS B  71      24.095  34.399   7.960  1.00 50.73           N  
ATOM   1650  N   GLY B  72      23.931  36.032   2.024  1.00 42.98           N  
ATOM   1651  CA  GLY B  72      24.033  35.668   0.643  1.00 44.16           C  
ATOM   1652  C   GLY B  72      24.743  34.334   0.600  1.00 45.33           C  
ATOM   1653  O   GLY B  72      24.455  33.414   1.387  1.00 46.16           O  
ATOM   1654  N   GLN B  73      25.735  34.284  -0.281  1.00 46.14           N  
ATOM   1655  CA  GLN B  73      26.401  33.073  -0.719  1.00 46.21           C  
ATOM   1656  C   GLN B  73      27.631  32.917   0.150  1.00 45.42           C  
ATOM   1657  O   GLN B  73      28.272  33.911   0.490  1.00 45.57           O  
ATOM   1658  CB  GLN B  73      26.812  33.217  -2.198  1.00 46.88           C  
ATOM   1659  CG  GLN B  73      27.545  34.568  -2.536  1.00 49.54           C  
ATOM   1660  CD  GLN B  73      26.628  35.799  -2.450  1.00 51.62           C  
ATOM   1661  OE1 GLN B  73      25.561  35.826  -3.067  1.00 54.74           O  
ATOM   1662  NE2 GLN B  73      27.029  36.804  -1.658  1.00 53.62           N  
ATOM   1663  N   GLY B  74      27.968  31.680   0.501  1.00 44.46           N  
ATOM   1664  CA  GLY B  74      29.069  31.418   1.418  1.00 43.59           C  
ATOM   1665  C   GLY B  74      28.958  32.288   2.663  1.00 42.90           C  
ATOM   1666  O   GLY B  74      27.930  32.283   3.335  1.00 42.68           O  
ATOM   1667  N   ARG B  75      30.016  33.043   2.957  1.00 41.82           N  
ATOM   1668  CA  ARG B  75      30.030  33.967   4.087  1.00 40.99           C  
ATOM   1669  C   ARG B  75      29.490  35.361   3.705  1.00 39.44           C  
ATOM   1670  O   ARG B  75      29.584  36.305   4.504  1.00 40.05           O  
ATOM   1671  CB  ARG B  75      31.470  34.074   4.651  1.00 41.59           C  
ATOM   1672  N   GLY B  76      28.936  35.487   2.495  1.00 37.39           N  
ATOM   1673  CA  GLY B  76      28.349  36.743   2.010  1.00 36.22           C  
ATOM   1674  C   GLY B  76      27.191  37.274   2.854  1.00 34.57           C  
ATOM   1675  O   GLY B  76      26.568  36.525   3.625  1.00 34.33           O  
ATOM   1676  N   TRP B  77      26.918  38.576   2.710  1.00 32.70           N  
ATOM   1677  CA  TRP B  77      25.788  39.222   3.361  1.00 30.66           C  
ATOM   1678  C   TRP B  77      25.483  40.599   2.750  1.00 28.89           C  
ATOM   1679  O   TRP B  77      26.303  41.176   2.013  1.00 27.59           O  
ATOM   1680  CB  TRP B  77      26.024  39.384   4.859  1.00 31.50           C  
ATOM   1681  CG  TRP B  77      27.290  40.059   5.220  1.00 31.56           C  
ATOM   1682  CD1 TRP B  77      28.456  39.441   5.589  1.00 33.25           C  
ATOM   1683  CD2 TRP B  77      27.551  41.482   5.291  1.00 32.62           C  
ATOM   1684  NE1 TRP B  77      29.434  40.388   5.862  1.00 33.54           N  
ATOM   1685  CE2 TRP B  77      28.902  41.644   5.689  1.00 33.31           C  
ATOM   1686  CE3 TRP B  77      26.787  42.638   5.031  1.00 31.41           C  
ATOM   1687  CZ2 TRP B  77      29.497  42.909   5.834  1.00 32.59           C  
ATOM   1688  CZ3 TRP B  77      27.380  43.885   5.185  1.00 31.69           C  
ATOM   1689  CH2 TRP B  77      28.725  44.013   5.572  1.00 31.54           C  
ATOM   1690  N   LYS B  78      24.281  41.077   3.034  1.00 25.99           N  
ATOM   1691  CA  LYS B  78      23.831  42.391   2.630  1.00 25.33           C  
ATOM   1692  C   LYS B  78      23.211  42.995   3.867  1.00 24.47           C  
ATOM   1693  O   LYS B  78      22.490  42.297   4.612  1.00 22.86           O  
ATOM   1694  CB  LYS B  78      22.777  42.332   1.542  1.00 25.48           C  
ATOM   1695  CG  LYS B  78      23.284  41.897   0.210  1.00 27.96           C  
ATOM   1696  CD  LYS B  78      22.230  42.139  -0.870  1.00 30.07           C  
ATOM   1697  CE  LYS B  78      22.406  41.234  -2.028  1.00 31.90           C  
ATOM   1698  NZ  LYS B  78      23.533  41.680  -2.866  1.00 34.49           N  
ATOM   1699  N   SER B  79      23.519  44.260   4.128  1.00 24.47           N  
ATOM   1700  CA  SER B  79      22.976  44.950   5.311  1.00 24.02           C  
ATOM   1701  C   SER B  79      22.512  46.330   4.883  1.00 25.25           C  
ATOM   1702  O   SER B  79      23.209  46.974   4.069  1.00 25.50           O  
ATOM   1703  CB  SER B  79      24.092  45.117   6.346  1.00 24.34           C  
ATOM   1704  OG  SER B  79      23.683  45.924   7.454  1.00 23.11           O  
ATOM   1705  N   VAL B  80      21.412  46.793   5.489  1.00 24.77           N  
ATOM   1706  CA  VAL B  80      20.858  48.128   5.271  1.00 24.22           C  
ATOM   1707  C   VAL B  80      20.750  48.848   6.612  1.00 23.92           C  
ATOM   1708  O   VAL B  80      20.367  48.234   7.635  1.00 23.19           O  
ATOM   1709  CB  VAL B  80      19.471  48.011   4.545  1.00 24.92           C  
ATOM   1710  CG1 VAL B  80      18.698  49.320   4.558  1.00 25.80           C  
ATOM   1711  CG2 VAL B  80      19.719  47.597   3.113  1.00 24.62           C  
ATOM   1712  N   VAL B  81      21.094  50.135   6.620  1.00 22.37           N  
ATOM   1713  CA  VAL B  81      20.817  50.981   7.766  1.00 23.14           C  
ATOM   1714  C   VAL B  81      19.878  52.088   7.356  1.00 23.14           C  
ATOM   1715  O   VAL B  81      20.118  52.792   6.357  1.00 23.11           O  
ATOM   1716  CB  VAL B  81      22.086  51.497   8.480  1.00 23.59           C  
ATOM   1717  CG1 VAL B  81      21.710  52.433   9.624  1.00 23.62           C  
ATOM   1718  CG2 VAL B  81      22.890  50.317   9.001  1.00 27.07           C  
ATOM   1719  N   VAL B  82      18.786  52.201   8.111  1.00 25.61           N  
ATOM   1720  CA  VAL B  82      17.755  53.227   7.865  1.00 26.69           C  
ATOM   1721  C   VAL B  82      17.830  54.262   8.964  1.00 27.09           C  
ATOM   1722  O   VAL B  82      17.836  53.920  10.144  1.00 26.42           O  
ATOM   1723  CB  VAL B  82      16.356  52.633   7.897  1.00 27.63           C  
ATOM   1724  CG1 VAL B  82      15.278  53.725   8.227  1.00 29.91           C  
ATOM   1725  CG2 VAL B  82      16.055  51.934   6.579  1.00 27.65           C  
ATOM   1726  N   ASP B  83      17.836  55.532   8.579  1.00 26.77           N  
ATOM   1727  CA  ASP B  83      17.681  56.568   9.548  1.00 27.20           C  
ATOM   1728  C   ASP B  83      16.318  57.136   9.377  1.00 26.17           C  
ATOM   1729  O   ASP B  83      15.879  57.531   8.289  1.00 25.30           O  
ATOM   1730  CB  ASP B  83      18.833  57.536   9.490  1.00 28.63           C  
ATOM   1731  CG  ASP B  83      20.193  56.812   9.792  1.00 34.25           C  
ATOM   1732  OD1 ASP B  83      20.303  55.940  10.750  1.00 40.10           O  
ATOM   1733  OD2 ASP B  83      21.146  57.090   9.045  1.00 40.71           O  
ATOM   1734  N   GLY B  84      15.598  57.087  10.468  1.00 26.44           N  
ATOM   1735  CA  GLY B  84      14.163  57.191  10.411  1.00 26.02           C  
ATOM   1736  C   GLY B  84      13.527  58.091  11.446  1.00 25.33           C  
ATOM   1737  O   GLY B  84      14.186  58.611  12.382  1.00 22.06           O  
ATOM   1738  N   ARG B  85      12.223  58.207  11.268  1.00 24.23           N  
ATOM   1739  CA  ARG B  85      11.379  58.899  12.198  1.00 25.97           C  
ATOM   1740  C   ARG B  85      10.217  57.994  12.629  1.00 25.59           C  
ATOM   1741  O   ARG B  85       9.495  57.430  11.786  1.00 25.01           O  
ATOM   1742  CB  ARG B  85      10.879  60.180  11.526  1.00 26.89           C  
ATOM   1743  CG  ARG B  85       9.641  60.693  12.152  1.00 28.81           C  
ATOM   1744  CD  ARG B  85       8.980  61.925  11.458  1.00 29.81           C  
ATOM   1745  NE  ARG B  85       9.711  62.561  10.354  1.00 32.24           N  
ATOM   1746  CZ  ARG B  85       9.322  63.734   9.845  1.00 31.41           C  
ATOM   1747  NH1 ARG B  85       8.265  64.336  10.370  1.00 34.01           N  
ATOM   1748  NH2 ARG B  85       9.972  64.314   8.854  1.00 30.74           N  
ATOM   1749  N   TYR B  86      10.075  57.791  13.935  1.00 25.47           N  
ATOM   1750  CA  TYR B  86       8.878  57.117  14.501  1.00 24.65           C  
ATOM   1751  C   TYR B  86       7.584  57.914  14.270  1.00 26.02           C  
ATOM   1752  O   TYR B  86       7.549  59.108  14.589  1.00 25.23           O  
ATOM   1753  CB  TYR B  86       9.077  57.006  15.986  1.00 24.87           C  
ATOM   1754  CG  TYR B  86       7.885  56.456  16.801  1.00 24.21           C  
ATOM   1755  CD1 TYR B  86       7.615  55.101  16.849  1.00 25.90           C  
ATOM   1756  CD2 TYR B  86       7.094  57.304  17.569  1.00 24.59           C  
ATOM   1757  CE1 TYR B  86       6.557  54.596  17.620  1.00 25.31           C  
ATOM   1758  CE2 TYR B  86       6.036  56.802  18.365  1.00 23.62           C  
ATOM   1759  CZ  TYR B  86       5.780  55.452  18.373  1.00 25.37           C  
ATOM   1760  OH  TYR B  86       4.754  54.925  19.124  1.00 25.13           O  
ATOM   1761  N   GLU B  87       6.535  57.276  13.735  1.00 25.57           N  
ATOM   1762  CA  GLU B  87       5.202  57.905  13.662  1.00 27.84           C  
ATOM   1763  C   GLU B  87       4.205  56.950  14.219  1.00 26.83           C  
ATOM   1764  O   GLU B  87       3.990  55.890  13.650  1.00 26.44           O  
ATOM   1765  CB  GLU B  87       4.806  58.198  12.232  1.00 29.41           C  
ATOM   1766  CG  GLU B  87       5.858  59.026  11.490  1.00 35.08           C  
ATOM   1767  CD  GLU B  87       5.738  58.960   9.975  1.00 44.19           C  
ATOM   1768  OE1 GLU B  87       4.635  58.642   9.480  1.00 47.92           O  
ATOM   1769  OE2 GLU B  87       6.753  59.245   9.286  1.00 51.77           O  
ATOM   1770  N   GLU B  88       3.626  57.283  15.365  1.00 26.91           N  
ATOM   1771  CA  GLU B  88       2.584  56.413  15.956  1.00 25.83           C  
ATOM   1772  C   GLU B  88       1.344  56.501  15.091  1.00 26.25           C  
ATOM   1773  O   GLU B  88       1.079  57.549  14.508  1.00 26.57           O  
ATOM   1774  CB  GLU B  88       2.262  56.848  17.370  1.00 27.20           C  
ATOM   1775  CG  GLU B  88       1.401  55.832  18.129  1.00 26.61           C  
ATOM   1776  CD  GLU B  88       1.551  55.896  19.619  1.00 29.02           C  
ATOM   1777  OE1 GLU B  88       2.639  56.265  20.110  1.00 26.98           O  
ATOM   1778  OE2 GLU B  88       0.578  55.528  20.311  1.00 27.71           O  
ATOM   1779  N   LEU B  89       0.614  55.405  14.962  1.00 25.87           N  
ATOM   1780  CA  LEU B  89      -0.590  55.401  14.165  1.00 26.57           C  
ATOM   1781  C   LEU B  89      -1.782  55.124  15.080  1.00 25.83           C  
ATOM   1782  O   LEU B  89      -2.166  53.973  15.236  1.00 26.78           O  
ATOM   1783  CB  LEU B  89      -0.467  54.370  13.058  1.00 26.21           C  
ATOM   1784  CG  LEU B  89       0.716  54.602  12.097  1.00 27.06           C  
ATOM   1785  CD1 LEU B  89       1.018  53.292  11.321  1.00 29.68           C  
ATOM   1786  CD2 LEU B  89       0.555  55.776  11.174  1.00 28.47           C  
ATOM   1787  N   PRO B  90      -2.402  56.181  15.650  1.00 24.94           N  
ATOM   1788  CA  PRO B  90      -3.467  55.947  16.596  1.00 25.09           C  
ATOM   1789  C   PRO B  90      -4.606  55.162  16.012  1.00 23.43           C  
ATOM   1790  O   PRO B  90      -4.813  55.220  14.787  1.00 21.46           O  
ATOM   1791  CB  PRO B  90      -3.960  57.357  16.942  1.00 25.65           C  
ATOM   1792  CG  PRO B  90      -2.884  58.210  16.626  1.00 26.97           C  
ATOM   1793  CD  PRO B  90      -2.220  57.619  15.424  1.00 26.72           C  
ATOM   1794  N   ASP B  91      -5.355  54.473  16.882  1.00 22.44           N  
ATOM   1795  CA  ASP B  91      -6.438  53.621  16.466  1.00 23.18           C  
ATOM   1796  C   ASP B  91      -7.689  54.427  16.089  1.00 22.88           C  
ATOM   1797  O   ASP B  91      -8.728  54.354  16.738  1.00 21.27           O  
ATOM   1798  CB  ASP B  91      -6.787  52.573  17.526  1.00 22.85           C  
ATOM   1799  CG  ASP B  91      -7.660  51.459  16.974  1.00 27.26           C  
ATOM   1800  OD1 ASP B  91      -7.969  51.414  15.751  1.00 28.92           O  
ATOM   1801  OD2 ASP B  91      -8.031  50.601  17.775  1.00 28.34           O  
ATOM   1802  N   LEU B  92      -7.562  55.153  14.988  1.00 23.30           N  
ATOM   1803  CA  LEU B  92      -8.617  56.004  14.453  1.00 23.98           C  
ATOM   1804  C   LEU B  92      -8.906  55.490  13.059  1.00 23.61           C  
ATOM   1805  O   LEU B  92      -8.077  54.822  12.446  1.00 23.13           O  
ATOM   1806  CB  LEU B  92      -8.161  57.465  14.371  1.00 23.94           C  
ATOM   1807  CG  LEU B  92      -7.639  58.074  15.676  1.00 27.81           C  
ATOM   1808  CD1 LEU B  92      -6.908  59.356  15.329  1.00 31.01           C  
ATOM   1809  CD2 LEU B  92      -8.764  58.313  16.663  1.00 29.49           C  
ATOM   1810  N   ILE B  93     -10.066  55.831  12.551  1.00 24.49           N  
ATOM   1811  CA  ILE B  93     -10.555  55.248  11.297  1.00 26.12           C  
ATOM   1812  C   ILE B  93      -9.644  55.531  10.103  1.00 26.66           C  
ATOM   1813  O   ILE B  93      -9.522  54.690   9.195  1.00 26.16           O  
ATOM   1814  CB  ILE B  93     -12.044  55.646  11.024  1.00 27.03           C  
ATOM   1815  CG1 ILE B  93     -12.659  54.838   9.863  1.00 28.27           C  
ATOM   1816  CG2 ILE B  93     -12.160  57.155  10.792  1.00 30.09           C  
ATOM   1817  CD1 ILE B  93     -12.708  53.301  10.092  1.00 30.15           C  
ATOM   1818  N   GLY B  94      -8.944  56.663  10.143  1.00 28.28           N  
ATOM   1819  CA  GLY B  94      -8.025  57.033   9.072  1.00 29.18           C  
ATOM   1820  C   GLY B  94      -6.829  56.100   8.948  1.00 30.07           C  
ATOM   1821  O   GLY B  94      -6.156  56.098   7.898  1.00 30.98           O  
ATOM   1822  N   HIS B  95      -6.532  55.341  10.012  1.00 28.19           N  
ATOM   1823  CA  HIS B  95      -5.426  54.365  10.017  1.00 26.77           C  
ATOM   1824  C   HIS B  95      -5.897  52.913  10.078  1.00 25.63           C  
ATOM   1825  O   HIS B  95      -5.084  52.000  10.128  1.00 25.54           O  
ATOM   1826  CB  HIS B  95      -4.466  54.636  11.194  1.00 26.82           C  
ATOM   1827  CG  HIS B  95      -3.841  55.989  11.163  1.00 29.35           C  
ATOM   1828  ND1 HIS B  95      -3.089  56.436  10.096  1.00 31.07           N  
ATOM   1829  CD2 HIS B  95      -3.862  57.005  12.064  1.00 31.36           C  
ATOM   1830  CE1 HIS B  95      -2.647  57.658  10.359  1.00 32.91           C  
ATOM   1831  NE2 HIS B  95      -3.100  58.022  11.547  1.00 32.15           N  
ATOM   1832  N   LYS B  96      -7.206  52.680   9.971  1.00 26.33           N  
ATOM   1833  CA  LYS B  96      -7.762  51.362  10.182  1.00 26.30           C  
ATOM   1834  C   LYS B  96      -7.331  50.386   9.081  1.00 26.54           C  
ATOM   1835  O   LYS B  96      -6.924  49.257   9.366  1.00 25.56           O  
ATOM   1836  CB  LYS B  96      -9.274  51.434  10.273  1.00 27.19           C  
ATOM   1837  CG  LYS B  96      -9.941  50.078  10.441  1.00 29.25           C  
ATOM   1838  CD  LYS B  96      -9.358  49.283  11.583  1.00 33.24           C  
ATOM   1839  CE  LYS B  96     -10.319  48.188  12.072  1.00 35.05           C  
ATOM   1840  NZ  LYS B  96      -9.670  47.404  13.181  1.00 37.61           N  
ATOM   1841  N   LEU B  97      -7.341  50.854   7.839  1.00 26.11           N  
ATOM   1842  CA  LEU B  97      -6.988  49.988   6.735  1.00 26.76           C  
ATOM   1843  C   LEU B  97      -5.492  49.640   6.830  1.00 25.80           C  
ATOM   1844  O   LEU B  97      -5.129  48.488   6.667  1.00 25.13           O  
ATOM   1845  CB  LEU B  97      -7.386  50.636   5.411  1.00 26.73           C  
ATOM   1846  CG  LEU B  97      -6.984  49.868   4.152  1.00 30.08           C  
ATOM   1847  CD1 LEU B  97      -7.787  48.564   4.065  1.00 30.70           C  
ATOM   1848  CD2 LEU B  97      -7.173  50.772   2.939  1.00 29.18           C  
ATOM   1849  N   GLN B  98      -4.649  50.630   7.135  1.00 25.90           N  
ATOM   1850  CA  GLN B  98      -3.209  50.404   7.381  1.00 26.26           C  
ATOM   1851  C   GLN B  98      -3.039  49.393   8.481  1.00 24.89           C  
ATOM   1852  O   GLN B  98      -2.263  48.443   8.371  1.00 25.09           O  
ATOM   1853  CB  GLN B  98      -2.511  51.687   7.834  1.00 26.72           C  
ATOM   1854  CG  GLN B  98      -2.418  52.741   6.748  1.00 31.69           C  
ATOM   1855  CD  GLN B  98      -2.011  54.078   7.278  1.00 36.32           C  
ATOM   1856  OE1 GLN B  98      -2.495  54.525   8.311  1.00 40.42           O  
ATOM   1857  NE2 GLN B  98      -1.134  54.753   6.549  1.00 40.14           N  
ATOM   1858  N   ARG B  99      -3.803  49.576   9.552  1.00 24.47           N  
ATOM   1859  CA  ARG B  99      -3.736  48.674  10.710  1.00 23.50           C  
ATOM   1860  C   ARG B  99      -4.143  47.257  10.341  1.00 23.81           C  
ATOM   1861  O   ARG B  99      -3.439  46.287  10.664  1.00 22.19           O  
ATOM   1862  CB  ARG B  99      -4.620  49.182  11.849  1.00 23.54           C  
ATOM   1863  CG  ARG B  99      -4.330  48.503  13.178  1.00 24.05           C  
ATOM   1864  CD  ARG B  99      -5.259  48.970  14.237  1.00 26.12           C  
ATOM   1865  NE  ARG B  99      -4.804  48.548  15.555  1.00 27.80           N  
ATOM   1866  CZ  ARG B  99      -4.175  49.320  16.450  1.00 28.58           C  
ATOM   1867  NH1 ARG B  99      -3.935  50.597  16.239  1.00 27.13           N  
ATOM   1868  NH2 ARG B  99      -3.807  48.790  17.611  1.00 32.10           N  
ATOM   1869  N   ASP B 100      -5.288  47.133   9.679  1.00 23.93           N  
ATOM   1870  CA  ASP B 100      -5.767  45.810   9.267  1.00 24.51           C  
ATOM   1871  C   ASP B 100      -4.782  45.098   8.347  1.00 24.26           C  
ATOM   1872  O   ASP B 100      -4.439  43.931   8.569  1.00 23.36           O  
ATOM   1873  CB  ASP B 100      -7.136  45.917   8.605  1.00 25.09           C  
ATOM   1874  CG  ASP B 100      -8.251  46.287   9.588  1.00 28.04           C  
ATOM   1875  OD1 ASP B 100      -8.060  46.221  10.851  1.00 31.70           O  
ATOM   1876  OD2 ASP B 100      -9.305  46.688   9.065  1.00 29.09           O  
ATOM   1877  N   HIS B 101      -4.297  45.817   7.337  1.00 24.61           N  
ATOM   1878  CA  HIS B 101      -3.287  45.264   6.423  1.00 25.03           C  
ATOM   1879  C   HIS B 101      -2.039  44.805   7.134  1.00 24.69           C  
ATOM   1880  O   HIS B 101      -1.610  43.669   6.955  1.00 24.61           O  
ATOM   1881  CB  HIS B 101      -2.846  46.308   5.398  1.00 25.40           C  
ATOM   1882  CG  HIS B 101      -3.882  46.621   4.372  1.00 26.45           C  
ATOM   1883  ND1 HIS B 101      -3.828  47.752   3.593  1.00 27.61           N  
ATOM   1884  CD2 HIS B 101      -4.974  45.929   3.963  1.00 27.79           C  
ATOM   1885  CE1 HIS B 101      -4.858  47.755   2.760  1.00 28.85           C  
ATOM   1886  NE2 HIS B 101      -5.566  46.659   2.966  1.00 26.72           N  
ATOM   1887  N   ALA B 102      -1.464  45.688   7.934  1.00 24.65           N  
ATOM   1888  CA  ALA B 102      -0.232  45.365   8.696  1.00 25.14           C  
ATOM   1889  C   ALA B 102      -0.438  44.179   9.627  1.00 24.99           C  
ATOM   1890  O   ALA B 102       0.436  43.321   9.744  1.00 23.88           O  
ATOM   1891  CB  ALA B 102       0.273  46.558   9.499  1.00 25.77           C  
ATOM   1892  N   TRP B 103      -1.585  44.152  10.306  1.00 25.09           N  
ATOM   1893  CA  TRP B 103      -1.837  43.127  11.315  1.00 25.35           C  
ATOM   1894  C   TRP B 103      -1.944  41.753  10.653  1.00 25.71           C  
ATOM   1895  O   TRP B 103      -1.489  40.742  11.213  1.00 25.59           O  
ATOM   1896  CB  TRP B 103      -3.117  43.431  12.080  1.00 25.61           C  
ATOM   1897  CG  TRP B 103      -3.419  42.401  13.078  1.00 25.44           C  
ATOM   1898  CD1 TRP B 103      -4.423  41.448  13.027  1.00 27.85           C  
ATOM   1899  CD2 TRP B 103      -2.678  42.137  14.250  1.00 25.23           C  
ATOM   1900  NE1 TRP B 103      -4.354  40.649  14.123  1.00 26.17           N  
ATOM   1901  CE2 TRP B 103      -3.295  41.048  14.897  1.00 26.24           C  
ATOM   1902  CE3 TRP B 103      -1.557  42.745  14.848  1.00 27.08           C  
ATOM   1903  CZ2 TRP B 103      -2.830  40.547  16.128  1.00 27.97           C  
ATOM   1904  CZ3 TRP B 103      -1.094  42.252  16.073  1.00 28.00           C  
ATOM   1905  CH2 TRP B 103      -1.717  41.150  16.685  1.00 26.12           C  
ATOM   1906  N   SER B 104      -2.547  41.715   9.475  1.00 25.62           N  
ATOM   1907  CA  SER B 104      -2.728  40.442   8.778  0.50 26.52           C  
ATOM   1909  C   SER B 104      -1.375  39.859   8.383  1.00 26.85           C  
ATOM   1910  O   SER B 104      -1.190  38.657   8.451  1.00 27.73           O  
ATOM   1911  CB  SER B 104      -3.690  40.561   7.580  0.50 26.32           C  
ATOM   1913  OG  SER B 104      -3.162  41.311   6.504  0.50 27.03           O  
ATOM   1915  N   VAL B 105      -0.414  40.722   8.026  1.00 28.73           N  
ATOM   1916  CA  VAL B 105       0.941  40.271   7.663  1.00 29.59           C  
ATOM   1917  C   VAL B 105       1.767  39.925   8.903  1.00 29.54           C  
ATOM   1918  O   VAL B 105       2.515  38.948   8.908  1.00 29.18           O  
ATOM   1919  CB  VAL B 105       1.658  41.323   6.818  1.00 29.82           C  
ATOM   1920  CG1 VAL B 105       3.144  41.039   6.741  1.00 32.46           C  
ATOM   1921  CG2 VAL B 105       1.032  41.382   5.450  1.00 30.23           C  
ATOM   1922  N   LEU B 106       1.607  40.701   9.958  1.00 29.88           N  
ATOM   1923  CA  LEU B 106       2.422  40.545  11.154  1.00 31.15           C  
ATOM   1924  C   LEU B 106       1.786  39.702  12.254  1.00 33.12           C  
ATOM   1925  O   LEU B 106       2.427  39.417  13.269  1.00 33.88           O  
ATOM   1926  CB  LEU B 106       2.777  41.925  11.708  1.00 30.91           C  
ATOM   1927  CG  LEU B 106       3.757  42.737  10.858  1.00 29.44           C  
ATOM   1928  CD1 LEU B 106       3.734  44.177  11.323  1.00 28.44           C  
ATOM   1929  CD2 LEU B 106       5.185  42.166  10.895  1.00 30.82           C  
ATOM   1930  N   SER B 107       0.521  39.324  12.065  1.00 34.62           N  
ATOM   1931  CA  SER B 107      -0.260  38.654  13.109  1.00 36.41           C  
ATOM   1932  C   SER B 107       0.402  37.377  13.561  1.00 37.57           C  
ATOM   1933  O   SER B 107       0.524  37.149  14.764  1.00 38.48           O  
ATOM   1934  CB  SER B 107      -1.653  38.327  12.595  1.00 35.67           C  
ATOM   1935  OG  SER B 107      -2.222  37.288  13.350  1.00 39.86           O  
ATOM   1936  N   LYS B 108       0.800  36.549  12.595  1.00 38.68           N  
ATOM   1937  CA  LYS B 108       1.555  35.321  12.846  1.00 40.68           C  
ATOM   1938  C   LYS B 108       2.851  35.575  13.646  1.00 41.16           C  
ATOM   1939  O   LYS B 108       3.115  34.912  14.664  1.00 40.70           O  
ATOM   1940  CB  LYS B 108       1.909  34.662  11.497  1.00 41.20           C  
ATOM   1941  CG  LYS B 108       2.429  33.210  11.595  1.00 43.48           C  
ATOM   1942  CD  LYS B 108       3.640  32.952  10.653  1.00 44.45           C  
ATOM   1943  CE  LYS B 108       3.930  31.444  10.449  1.00 44.83           C  
ATOM   1944  NZ  LYS B 108       5.319  31.192   9.911  1.00 45.30           N  
ATOM   1945  N   HIS B 109       3.638  36.540  13.161  1.00 41.95           N  
ATOM   1946  CA  HIS B 109       4.942  36.897  13.751  1.00 42.49           C  
ATOM   1947  C   HIS B 109       4.757  37.423  15.149  1.00 41.62           C  
ATOM   1948  O   HIS B 109       5.553  37.113  16.033  1.00 41.57           O  
ATOM   1949  CB  HIS B 109       5.687  37.927  12.875  1.00 43.15           C  
ATOM   1950  CG  HIS B 109       6.097  37.377  11.548  1.00 46.82           C  
ATOM   1951  ND1 HIS B 109       7.278  36.687  11.364  1.00 51.88           N  
ATOM   1952  CD2 HIS B 109       5.450  37.340  10.358  1.00 49.36           C  
ATOM   1953  CE1 HIS B 109       7.349  36.264  10.113  1.00 51.37           C  
ATOM   1954  NE2 HIS B 109       6.254  36.650   9.479  1.00 50.44           N  
ATOM   1955  N   THR B 110       3.694  38.205  15.338  1.00 41.30           N  
ATOM   1956  CA  THR B 110       3.341  38.781  16.642  1.00 41.28           C  
ATOM   1957  C   THR B 110       3.114  37.682  17.672  1.00 41.40           C  
ATOM   1958  O   THR B 110       3.390  37.862  18.854  1.00 41.05           O  
ATOM   1959  CB  THR B 110       2.085  39.702  16.557  1.00 41.21           C  
ATOM   1960  OG1 THR B 110       2.347  40.795  15.662  1.00 40.04           O  
ATOM   1961  CG2 THR B 110       1.700  40.238  17.939  1.00 41.28           C  
ATOM   1962  N   ASP B 111       2.664  36.522  17.215  1.00 41.58           N  
ATOM   1963  CA  ASP B 111       2.508  35.402  18.133  1.00 42.31           C  
ATOM   1964  C   ASP B 111       3.836  34.899  18.652  1.00 42.03           C  
ATOM   1965  O   ASP B 111       3.838  34.132  19.605  1.00 41.71           O  
ATOM   1966  CB  ASP B 111       1.726  34.247  17.489  1.00 42.51           C  
ATOM   1967  CG  ASP B 111       0.270  34.585  17.300  1.00 44.23           C  
ATOM   1968  OD1 ASP B 111      -0.280  35.334  18.152  1.00 45.73           O  
ATOM   1969  OD2 ASP B 111      -0.322  34.118  16.307  1.00 45.73           O  
ATOM   1970  N   TRP B 112       4.949  35.320  18.038  1.00 41.87           N  
ATOM   1971  CA  TRP B 112       6.280  34.867  18.452  1.00 41.63           C  
ATOM   1972  C   TRP B 112       7.014  35.788  19.448  1.00 40.92           C  
ATOM   1973  O   TRP B 112       8.092  35.418  19.915  1.00 40.68           O  
ATOM   1974  CB  TRP B 112       7.173  34.573  17.241  1.00 42.21           C  
ATOM   1975  CG  TRP B 112       6.538  33.666  16.228  1.00 43.02           C  
ATOM   1976  CD1 TRP B 112       5.529  32.757  16.431  1.00 43.70           C  
ATOM   1977  CD2 TRP B 112       6.872  33.584  14.843  1.00 44.52           C  
ATOM   1978  NE1 TRP B 112       5.208  32.131  15.254  1.00 43.63           N  
ATOM   1979  CE2 TRP B 112       6.020  32.618  14.262  1.00 44.09           C  
ATOM   1980  CE3 TRP B 112       7.795  34.255  14.025  1.00 44.33           C  
ATOM   1981  CZ2 TRP B 112       6.087  32.282  12.903  1.00 44.33           C  
ATOM   1982  CZ3 TRP B 112       7.858  33.930  12.674  1.00 43.35           C  
ATOM   1983  CH2 TRP B 112       7.006  32.955  12.126  1.00 44.07           C  
ATOM   1984  N   TRP B 113       6.435  36.942  19.801  1.00 39.34           N  
ATOM   1985  CA  TRP B 113       6.998  37.781  20.883  1.00 38.50           C  
ATOM   1986  C   TRP B 113       5.980  38.264  21.908  1.00 38.02           C  
ATOM   1987  O   TRP B 113       6.355  38.560  23.038  1.00 36.71           O  
ATOM   1988  CB  TRP B 113       7.737  39.016  20.310  1.00 37.50           C  
ATOM   1989  CG  TRP B 113       6.880  39.867  19.418  1.00 37.36           C  
ATOM   1990  CD1 TRP B 113       6.808  39.809  18.058  1.00 36.72           C  
ATOM   1991  CD2 TRP B 113       5.981  40.918  19.820  1.00 36.12           C  
ATOM   1992  NE1 TRP B 113       5.928  40.745  17.585  1.00 36.44           N  
ATOM   1993  CE2 TRP B 113       5.395  41.435  18.643  1.00 37.10           C  
ATOM   1994  CE3 TRP B 113       5.627  41.479  21.059  1.00 36.76           C  
ATOM   1995  CZ2 TRP B 113       4.467  42.481  18.665  1.00 36.24           C  
ATOM   1996  CZ3 TRP B 113       4.703  42.512  21.084  1.00 37.02           C  
ATOM   1997  CH2 TRP B 113       4.116  42.988  19.896  1.00 36.95           C  
ATOM   1998  N   GLU B 114       4.717  38.405  21.493  1.00 38.35           N  
ATOM   1999  CA  GLU B 114       3.663  38.960  22.360  1.00 39.07           C  
ATOM   2000  C   GLU B 114       3.456  38.111  23.635  1.00 39.21           C  
ATOM   2001  O   GLU B 114       3.077  36.941  23.539  1.00 38.57           O  
ATOM   2002  CB  GLU B 114       2.352  39.053  21.570  1.00 39.48           C  
ATOM   2003  CG  GLU B 114       1.185  39.701  22.296  1.00 41.57           C  
ATOM   2004  CD  GLU B 114      -0.130  39.361  21.600  1.00 46.27           C  
ATOM   2005  OE1 GLU B 114      -0.494  40.046  20.609  1.00 47.00           O  
ATOM   2006  OE2 GLU B 114      -0.772  38.366  22.022  1.00 49.40           O  
ATOM   2007  N   PRO B 115       3.681  38.702  24.827  1.00 39.27           N  
ATOM   2008  CA  PRO B 115       3.474  37.910  26.042  1.00 40.06           C  
ATOM   2009  C   PRO B 115       1.990  37.606  26.276  1.00 40.59           C  
ATOM   2010  O   PRO B 115       1.131  38.502  26.195  1.00 39.93           O  
ATOM   2011  CB  PRO B 115       4.044  38.795  27.162  1.00 39.84           C  
ATOM   2012  CG  PRO B 115       4.755  39.934  26.457  1.00 40.13           C  
ATOM   2013  CD  PRO B 115       4.110  40.079  25.137  1.00 39.95           C  
ATOM   2014  N   GLY B 116       1.695  36.342  26.538  1.00 41.81           N  
ATOM   2015  CA  GLY B 116       0.326  35.935  26.878  1.00 42.86           C  
ATOM   2016  C   GLY B 116      -0.081  36.454  28.242  1.00 43.55           C  
ATOM   2017  O   GLY B 116       0.782  36.834  29.040  1.00 43.78           O  
ATOM   2018  N   ALA B 117      -1.394  36.483  28.497  1.00 44.40           N  
ATOM   2019  CA  ALA B 117      -1.929  36.763  29.839  1.00 44.85           C  
ATOM   2020  C   ALA B 117      -1.530  35.625  30.788  1.00 45.28           C  
ATOM   2021  O   ALA B 117      -1.607  34.460  30.413  1.00 45.06           O  
ATOM   2022  CB  ALA B 117      -3.458  36.956  29.801  1.00 44.74           C  
ATOM   2023  N   LEU B 118      -1.080  35.990  31.994  1.00 46.07           N  
ATOM   2024  CA  LEU B 118      -0.481  35.066  32.983  1.00 46.30           C  
ATOM   2025  C   LEU B 118       0.423  33.968  32.376  1.00 46.48           C  
ATOM   2026  O   LEU B 118       1.266  34.226  31.506  1.00 47.05           O  
ATOM   2027  CB  LEU B 118      -1.566  34.420  33.857  1.00 46.35           C  
ATOM   2028  CG  LEU B 118      -2.289  35.203  34.956  1.00 46.46           C  
ATOM   2029  CD1 LEU B 118      -3.330  36.161  34.359  1.00 47.32           C  
ATOM   2030  CD2 LEU B 118      -2.954  34.242  35.959  1.00 46.32           C  
ATOM   2031  N   SER B 128      -5.077  43.324  17.835  1.00 60.42           N  
ATOM   2032  CA  SER B 128      -4.397  44.619  17.727  1.00 58.84           C  
ATOM   2033  C   SER B 128      -5.198  45.749  18.433  1.00 60.98           C  
ATOM   2034  O   SER B 128      -5.333  46.843  17.905  1.00 64.55           O  
ATOM   2035  CB  SER B 128      -4.123  44.949  16.250  1.00 57.75           C  
ATOM   2036  OG  SER B 128      -5.325  45.086  15.495  1.00 48.80           O  
ATOM   2037  N   ALA B 129      -5.758  45.481  19.608  1.00 59.48           N  
ATOM   2038  CA  ALA B 129      -6.445  46.525  20.351  1.00 58.51           C  
ATOM   2039  C   ALA B 129      -5.499  47.223  21.347  1.00 58.40           C  
ATOM   2040  O   ALA B 129      -5.272  48.419  21.198  1.00 61.09           O  
ATOM   2041  CB  ALA B 129      -7.714  45.993  21.037  1.00 58.73           C  
ATOM   2042  N   PRO B 130      -4.896  46.490  22.331  1.00 55.36           N  
ATOM   2043  CA  PRO B 130      -4.011  47.211  23.287  1.00 50.87           C  
ATOM   2044  C   PRO B 130      -2.619  47.424  22.685  1.00 45.59           C  
ATOM   2045  O   PRO B 130      -1.703  47.881  23.373  1.00 45.54           O  
ATOM   2046  CB  PRO B 130      -3.914  46.257  24.472  1.00 50.94           C  
ATOM   2047  CG  PRO B 130      -4.005  44.871  23.829  1.00 55.12           C  
ATOM   2048  CD  PRO B 130      -4.896  45.032  22.582  1.00 56.34           C  
ATOM   2049  N   HIS B 131      -2.496  47.062  21.418  1.00 39.87           N  
ATOM   2050  CA  HIS B 131      -1.264  47.222  20.703  1.00 37.52           C  
ATOM   2051  C   HIS B 131      -1.080  48.649  20.282  1.00 34.37           C  
ATOM   2052  O   HIS B 131      -2.026  49.340  19.903  1.00 32.09           O  
ATOM   2053  CB  HIS B 131      -1.249  46.355  19.461  1.00 38.32           C  
ATOM   2054  CG  HIS B 131      -1.103  44.910  19.761  1.00 40.49           C  
ATOM   2055  ND1 HIS B 131       0.132  44.310  19.880  1.00 43.40           N  
ATOM   2056  CD2 HIS B 131      -2.023  43.957  20.025  1.00 41.64           C  
ATOM   2057  CE1 HIS B 131      -0.037  43.034  20.183  1.00 45.61           C  
ATOM   2058  NE2 HIS B 131      -1.337  42.796  20.272  1.00 43.65           N  
ATOM   2059  N   VAL B 132       0.177  49.056  20.304  1.00 31.17           N  
ATOM   2060  CA  VAL B 132       0.569  50.285  19.670  1.00 29.68           C  
ATOM   2061  C   VAL B 132       1.004  49.922  18.253  1.00 28.05           C  
ATOM   2062  O   VAL B 132       1.908  49.103  18.052  1.00 27.12           O  
ATOM   2063  CB  VAL B 132       1.733  50.952  20.415  1.00 28.37           C  
ATOM   2064  CG1 VAL B 132       2.150  52.203  19.671  1.00 29.42           C  
ATOM   2065  CG2 VAL B 132       1.353  51.236  21.823  1.00 29.73           C  
ATOM   2066  N   PHE B 133       0.337  50.516  17.274  1.00 26.32           N  
ATOM   2067  CA  PHE B 133       0.703  50.373  15.866  1.00 24.97           C  
ATOM   2068  C   PHE B 133       1.511  51.607  15.482  1.00 24.68           C  
ATOM   2069  O   PHE B 133       1.175  52.726  15.887  1.00 23.08           O  
ATOM   2070  CB  PHE B 133      -0.593  50.329  15.049  1.00 24.57           C  
ATOM   2071  CG  PHE B 133      -0.408  50.218  13.570  1.00 24.44           C  
ATOM   2072  CD1 PHE B 133       0.564  49.425  13.021  1.00 21.72           C  
ATOM   2073  CD2 PHE B 133      -1.285  50.882  12.721  1.00 24.91           C  
ATOM   2074  CE1 PHE B 133       0.683  49.331  11.680  1.00 24.50           C  
ATOM   2075  CE2 PHE B 133      -1.172  50.787  11.380  1.00 23.53           C  
ATOM   2076  CZ  PHE B 133      -0.202  50.001  10.851  1.00 24.82           C  
ATOM   2077  N   PHE B 134       2.578  51.418  14.715  1.00 23.20           N  
ATOM   2078  CA  PHE B 134       3.422  52.544  14.345  1.00 23.97           C  
ATOM   2079  C   PHE B 134       4.163  52.240  13.077  1.00 23.50           C  
ATOM   2080  O   PHE B 134       4.243  51.066  12.638  1.00 24.28           O  
ATOM   2081  CB  PHE B 134       4.393  52.928  15.478  1.00 23.31           C  
ATOM   2082  CG  PHE B 134       5.504  51.925  15.738  1.00 23.33           C  
ATOM   2083  CD1 PHE B 134       5.309  50.875  16.610  1.00 23.93           C  
ATOM   2084  CD2 PHE B 134       6.743  52.024  15.116  1.00 25.15           C  
ATOM   2085  CE1 PHE B 134       6.329  49.945  16.843  1.00 24.28           C  
ATOM   2086  CE2 PHE B 134       7.776  51.105  15.389  1.00 26.21           C  
ATOM   2087  CZ  PHE B 134       7.567  50.072  16.224  1.00 23.57           C  
ATOM   2088  N   ARG B 135       4.723  53.298  12.509  1.00 25.28           N  
ATOM   2089  CA  ARG B 135       5.655  53.155  11.399  1.00 26.04           C  
ATOM   2090  C   ARG B 135       6.921  53.974  11.598  1.00 25.81           C  
ATOM   2091  O   ARG B 135       6.928  55.028  12.239  1.00 25.97           O  
ATOM   2092  CB  ARG B 135       5.014  53.483  10.055  1.00 25.78           C  
ATOM   2093  CG  ARG B 135       4.460  54.861   9.894  1.00 25.38           C  
ATOM   2094  CD  ARG B 135       3.611  54.990   8.620  1.00 26.99           C  
ATOM   2095  NE  ARG B 135       3.282  56.396   8.432  1.00 27.42           N  
ATOM   2096  CZ  ARG B 135       2.458  56.893   7.507  1.00 32.13           C  
ATOM   2097  NH1 ARG B 135       1.822  56.126   6.648  1.00 31.52           N  
ATOM   2098  NH2 ARG B 135       2.241  58.195   7.458  1.00 31.29           N  
ATOM   2099  N   ILE B 136       7.993  53.471  11.008  1.00 25.29           N  
ATOM   2100  CA  ILE B 136       9.213  54.198  10.820  1.00 24.25           C  
ATOM   2101  C   ILE B 136       9.278  54.726   9.389  1.00 25.03           C  
ATOM   2102  O   ILE B 136       9.342  53.949   8.421  1.00 23.91           O  
ATOM   2103  CB  ILE B 136      10.435  53.294  11.087  1.00 24.42           C  
ATOM   2104  CG1 ILE B 136      10.385  52.669  12.481  1.00 24.93           C  
ATOM   2105  CG2 ILE B 136      11.689  54.063  10.911  1.00 23.41           C  
ATOM   2106  CD1 ILE B 136      10.140  53.590  13.670  1.00 24.59           C  
ATOM   2107  N   LEU B 137       9.227  56.045   9.247  1.00 25.20           N  
ATOM   2108  CA  LEU B 137       9.465  56.684   7.953  1.00 26.69           C  
ATOM   2109  C   LEU B 137      10.934  56.662   7.632  1.00 24.45           C  
ATOM   2110  O   LEU B 137      11.763  57.049   8.465  1.00 24.62           O  
ATOM   2111  CB  LEU B 137       8.970  58.106   7.985  1.00 27.01           C  
ATOM   2112  CG  LEU B 137       9.307  58.961   6.780  1.00 32.06           C  
ATOM   2113  CD1 LEU B 137       8.941  58.350   5.387  1.00 33.93           C  
ATOM   2114  CD2 LEU B 137       8.558  60.270   6.981  1.00 36.32           C  
ATOM   2115  N   ILE B 138      11.264  56.126   6.461  1.00 24.55           N  
ATOM   2116  CA  ILE B 138      12.642  55.971   6.028  1.00 24.96           C  
ATOM   2117  C   ILE B 138      13.076  57.311   5.444  1.00 25.87           C  
ATOM   2118  O   ILE B 138      12.605  57.713   4.396  1.00 26.25           O  
ATOM   2119  CB  ILE B 138      12.766  54.831   4.965  1.00 23.88           C  
ATOM   2120  CG1 ILE B 138      12.338  53.506   5.582  1.00 25.66           C  
ATOM   2121  CG2 ILE B 138      14.213  54.735   4.407  1.00 25.99           C  
ATOM   2122  CD1 ILE B 138      12.108  52.368   4.607  1.00 25.36           C  
ATOM   2123  N   GLU B 139      13.967  58.026   6.131  1.00 26.08           N  
ATOM   2124  CA  GLU B 139      14.421  59.309   5.633  1.00 26.49           C  
ATOM   2125  C   GLU B 139      15.756  59.197   4.911  1.00 27.01           C  
ATOM   2126  O   GLU B 139      15.935  59.772   3.843  1.00 27.70           O  
ATOM   2127  CB  GLU B 139      14.473  60.324   6.771  1.00 26.32           C  
ATOM   2128  CG  GLU B 139      13.087  60.491   7.394  1.00 27.49           C  
ATOM   2129  CD  GLU B 139      12.916  61.707   8.242  1.00 29.13           C  
ATOM   2130  OE1 GLU B 139      13.928  62.336   8.609  1.00 27.63           O  
ATOM   2131  OE2 GLU B 139      11.748  62.020   8.534  1.00 28.86           O  
ATOM   2132  N   GLN B 140      16.705  58.497   5.503  1.00 27.07           N  
ATOM   2133  CA  GLN B 140      17.994  58.214   4.842  1.00 26.84           C  
ATOM   2134  C   GLN B 140      18.175  56.701   4.895  1.00 26.51           C  
ATOM   2135  O   GLN B 140      17.688  56.023   5.821  1.00 25.97           O  
ATOM   2136  CB  GLN B 140      19.185  58.874   5.566  1.00 27.13           C  
ATOM   2137  CG  GLN B 140      18.917  60.296   6.081  1.00 30.96           C  
ATOM   2138  CD  GLN B 140      18.737  61.310   4.949  1.00 35.12           C  
ATOM   2139  OE1 GLN B 140      19.231  61.076   3.839  1.00 36.73           O  
ATOM   2140  NE2 GLN B 140      18.050  62.451   5.227  1.00 30.93           N  
ATOM   2141  N   VAL B 141      18.823  56.152   3.887  1.00 26.56           N  
ATOM   2142  CA  VAL B 141      19.081  54.702   3.845  1.00 27.08           C  
ATOM   2143  C   VAL B 141      20.415  54.477   3.162  1.00 26.48           C  
ATOM   2144  O   VAL B 141      20.743  55.164   2.197  1.00 25.69           O  
ATOM   2145  CB  VAL B 141      17.929  53.902   3.157  1.00 27.89           C  
ATOM   2146  CG1 VAL B 141      17.763  54.267   1.764  1.00 29.67           C  
ATOM   2147  CG2 VAL B 141      18.180  52.360   3.230  1.00 27.50           C  
ATOM   2148  N   SER B 142      21.202  53.563   3.717  1.00 26.47           N  
ATOM   2149  CA  SER B 142      22.466  53.136   3.163  1.00 27.07           C  
ATOM   2150  C   SER B 142      22.530  51.618   3.232  1.00 26.56           C  
ATOM   2151  O   SER B 142      21.817  50.994   4.019  1.00 25.30           O  
ATOM   2152  CB  SER B 142      23.644  53.716   3.943  1.00 27.75           C  
ATOM   2153  OG  SER B 142      23.615  53.184   5.272  1.00 31.92           O  
ATOM   2154  N   GLY B 143      23.376  51.043   2.386  1.00 25.29           N  
ATOM   2155  CA  GLY B 143      23.503  49.591   2.270  1.00 25.86           C  
ATOM   2156  C   GLY B 143      24.952  49.196   2.034  1.00 25.69           C  
ATOM   2157  O   GLY B 143      25.729  49.962   1.464  1.00 26.02           O  
ATOM   2158  N   ARG B 144      25.305  47.996   2.488  1.00 25.77           N  
ATOM   2159  CA  ARG B 144      26.605  47.400   2.270  1.00 26.62           C  
ATOM   2160  C   ARG B 144      26.438  45.948   1.875  1.00 26.63           C  
ATOM   2161  O   ARG B 144      25.557  45.278   2.373  1.00 24.57           O  
ATOM   2162  CB  ARG B 144      27.454  47.376   3.546  1.00 27.65           C  
ATOM   2163  CG  ARG B 144      27.883  48.713   4.096  1.00 31.23           C  
ATOM   2164  CD  ARG B 144      29.013  49.267   3.292  1.00 34.16           C  
ATOM   2165  NE  ARG B 144      29.399  50.623   3.699  1.00 36.40           N  
ATOM   2166  CZ  ARG B 144      30.373  50.916   4.556  1.00 38.33           C  
ATOM   2167  NH1 ARG B 144      31.107  49.968   5.132  1.00 40.51           N  
ATOM   2168  NH2 ARG B 144      30.645  52.184   4.811  1.00 39.30           N  
ATOM   2169  N   GLU B 145      27.323  45.444   1.025  1.00 25.72           N  
ATOM   2170  CA  GLU B 145      27.371  44.015   0.757  1.00 27.21           C  
ATOM   2171  C   GLU B 145      28.812  43.525   0.842  1.00 27.50           C  
ATOM   2172  O   GLU B 145      29.690  44.176   0.333  1.00 26.96           O  
ATOM   2173  CB  GLU B 145      26.843  43.690  -0.635  1.00 27.92           C  
ATOM   2174  CG  GLU B 145      26.946  42.195  -0.956  1.00 32.23           C  
ATOM   2175  CD  GLU B 145      26.767  41.876  -2.395  1.00 37.60           C  
ATOM   2176  OE1 GLU B 145      25.650  42.090  -2.893  1.00 40.58           O  
ATOM   2177  OE2 GLU B 145      27.751  41.413  -3.045  1.00 44.09           O  
ATOM   2178  N   ALA B 146      29.021  42.401   1.515  1.00 28.31           N  
ATOM   2179  CA  ALA B 146      30.259  41.633   1.478  1.00 29.73           C  
ATOM   2180  C   ALA B 146      30.086  40.451   0.536  1.00 30.62           C  
ATOM   2181  O   ALA B 146      29.142  39.670   0.692  1.00 30.95           O  
ATOM   2182  CB  ALA B 146      30.600  41.104   2.871  1.00 29.89           C  
ATOM   2183  N   SER B 147      30.978  40.331  -0.435  1.00 31.84           N  
ATOM   2184  CA  SER B 147      31.116  39.115  -1.270  1.00 32.99           C  
ATOM   2185  C   SER B 147      32.334  38.310  -0.814  1.00 33.33           C  
ATOM   2186  O   SER B 147      32.751  37.361  -1.482  1.00 34.32           O  
ATOM   2187  CB  SER B 147      31.309  39.481  -2.745  1.00 33.33           C  
ATOM   2188  OG  SER B 147      30.378  40.469  -3.149  1.00 35.46           O  
TER    2189      SER B 147                                                      
END
MOLECULE T0506.pdb
ATOM      1  N   VAL     4      16.223  74.529   6.413  1.00 43.65           N  
ATOM      2  CA  VAL     4      17.370  74.880   7.304  1.00 43.82           C  
ATOM      3  C   VAL     4      17.963  73.638   8.008  1.00 43.97           C  
ATOM      4  O   VAL     4      19.114  73.665   8.459  1.00 44.37           O  
ATOM      5  CB  VAL     4      16.969  76.004   8.316  1.00 43.84           C  
ATOM      6  CG1 VAL     4      18.109  76.346   9.267  1.00 44.06           C  
ATOM      7  CG2 VAL     4      16.529  77.270   7.571  1.00 43.89           C  
ATOM      8  N   ALA     5      17.192  72.548   8.063  1.00 43.79           N  
ATOM      9  CA  ALA     5      17.573  71.332   8.805  1.00 43.55           C  
ATOM     10  C   ALA     5      18.661  70.477   8.131  1.00 43.26           C  
ATOM     11  O   ALA     5      18.524  70.078   6.973  1.00 42.98           O  
ATOM     12  CB  ALA     5      16.339  70.479   9.111  1.00 43.90           C  
ATOM     13  N   PRO     6      19.740  70.170   8.871  1.00 43.22           N  
ATOM     14  CA  PRO     6      20.844  69.368   8.331  1.00 42.95           C  
ATOM     15  C   PRO     6      20.447  67.919   7.950  1.00 42.45           C  
ATOM     16  O   PRO     6      19.464  67.374   8.487  1.00 41.77           O  
ATOM     17  CB  PRO     6      21.854  69.359   9.484  1.00 43.23           C  
ATOM     18  CG  PRO     6      21.006  69.553  10.707  1.00 43.87           C  
ATOM     19  CD  PRO     6      19.985  70.552  10.274  1.00 43.24           C  
ATOM     20  N   PRO     7      21.198  67.301   7.015  1.00 41.83           N  
ATOM     21  CA  PRO     7      20.961  65.893   6.726  1.00 41.46           C  
ATOM     22  C   PRO     7      20.933  65.068   8.016  1.00 40.74           C  
ATOM     23  O   PRO     7      21.728  65.315   8.930  1.00 40.20           O  
ATOM     24  CB  PRO     7      22.164  65.498   5.854  1.00 42.16           C  
ATOM     25  CG  PRO     7      23.099  66.664   5.880  1.00 41.75           C  
ATOM     26  CD  PRO     7      22.276  67.858   6.180  1.00 41.68           C  
ATOM     27  N   VAL     8      19.999  64.129   8.112  1.00 40.33           N  
ATOM     28  CA  VAL     8      19.881  63.318   9.347  1.00 39.91           C  
ATOM     29  C   VAL     8      21.138  62.431   9.570  1.00 40.27           C  
ATOM     30  O   VAL     8      21.506  62.089  10.707  1.00 40.37           O  
ATOM     31  CB  VAL     8      18.516  62.556   9.435  1.00 39.67           C  
ATOM     32  CG1 VAL     8      17.329  63.555   9.348  1.00 36.98           C  
ATOM     33  CG2 VAL     8      18.390  61.517   8.365  1.00 38.22           C  
ATOM     34  N   ILE     9      21.801  62.086   8.475  1.00 40.55           N  
ATOM     35  CA  ILE     9      23.080  61.402   8.548  1.00 40.74           C  
ATOM     36  C   ILE     9      24.104  62.396   8.056  1.00 40.78           C  
ATOM     37  O   ILE     9      24.011  62.841   6.917  1.00 41.63           O  
ATOM     38  CB  ILE     9      23.118  60.143   7.647  1.00 40.61           C  
ATOM     39  CG1 ILE     9      21.953  59.189   7.985  1.00 41.00           C  
ATOM     40  CG2 ILE     9      24.517  59.462   7.731  1.00 39.79           C  
ATOM     41  CD1 ILE     9      21.690  58.061   6.971  1.00 40.63           C  
ATOM     42  N   THR    10      25.056  62.771   8.909  1.00 40.43           N  
ATOM     43  CA  THR    10      26.176  63.599   8.483  1.00 40.73           C  
ATOM     44  C   THR    10      27.078  62.807   7.534  1.00 40.81           C  
ATOM     45  O   THR    10      27.550  61.725   7.907  1.00 41.55           O  
ATOM     46  CB  THR    10      26.948  64.128   9.696  1.00 40.40           C  
ATOM     47  OG1 THR    10      26.031  64.861  10.516  1.00 39.93           O  
ATOM     48  CG2 THR    10      28.134  65.030   9.289  1.00 40.89           C  
ATOM     49  N   PRO    11      27.264  63.306   6.290  1.00 40.27           N  
ATOM     50  CA  PRO    11      28.106  62.635   5.300  1.00 40.30           C  
ATOM     51  C   PRO    11      29.531  62.424   5.796  1.00 40.59           C  
ATOM     52  O   PRO    11      30.089  63.270   6.519  1.00 40.09           O  
ATOM     53  CB  PRO    11      28.124  63.627   4.123  1.00 39.98           C  
ATOM     54  CG  PRO    11      26.898  64.368   4.249  1.00 39.70           C  
ATOM     55  CD  PRO    11      26.687  64.541   5.731  1.00 40.75           C  
ATOM     56  N   ARG    12      30.113  61.303   5.387  1.00 41.07           N  
ATOM     57  CA  ARG    12      31.472  60.953   5.767  1.00 41.14           C  
ATOM     58  C   ARG    12      32.453  61.993   5.258  1.00 41.53           C  
ATOM     59  O   ARG    12      33.228  62.542   6.035  1.00 41.73           O  
ATOM     60  CB  ARG    12      31.835  59.577   5.213  1.00 41.12           C  
ATOM     61  CG  ARG    12      32.473  58.648   6.214  1.00 39.82           C  
ATOM     62  CD  ARG    12      33.423  59.386   7.103  1.00 37.35           C  
ATOM     63  NE  ARG    12      34.538  58.566   7.537  1.00 35.24           N  
ATOM     64  CZ  ARG    12      35.491  59.009   8.340  1.00 36.29           C  
ATOM     65  NH1 ARG    12      35.452  60.263   8.767  1.00 35.93           N  
ATOM     66  NH2 ARG    12      36.488  58.210   8.710  1.00 36.57           N  
ATOM     67  N   PHE    24      26.609  45.777  -8.751  1.00 49.65           N  
ATOM     68  CA  PHE    24      26.051  46.396  -7.541  1.00 49.63           C  
ATOM     69  C   PHE    24      25.420  47.733  -7.925  1.00 48.93           C  
ATOM     70  O   PHE    24      26.123  48.667  -8.335  1.00 49.03           O  
ATOM     71  CB  PHE    24      27.132  46.601  -6.452  1.00 49.78           C  
ATOM     72  CG  PHE    24      26.616  47.272  -5.196  1.00 50.83           C  
ATOM     73  CD1 PHE    24      26.081  46.515  -4.146  1.00 50.02           C  
ATOM     74  CD2 PHE    24      26.659  48.674  -5.061  1.00 51.88           C  
ATOM     75  CE1 PHE    24      25.585  47.152  -2.977  1.00 50.73           C  
ATOM     76  CE2 PHE    24      26.163  49.313  -3.901  1.00 50.87           C  
ATOM     77  CZ  PHE    24      25.627  48.551  -2.863  1.00 49.25           C  
ATOM     78  N   GLU    25      24.099  47.813  -7.832  1.00 47.53           N  
ATOM     79  CA  GLU    25      23.428  49.088  -8.068  1.00 46.43           C  
ATOM     80  C   GLU    25      22.710  49.488  -6.817  1.00 44.86           C  
ATOM     81  O   GLU    25      21.685  48.901  -6.451  1.00 45.13           O  
ATOM     82  CB  GLU    25      22.471  49.047  -9.256  1.00 47.06           C  
ATOM     83  CG  GLU    25      22.225  50.443  -9.881  1.00 47.24           C  
ATOM     84  CD  GLU    25      21.172  51.248  -9.119  1.00 46.10           C  
ATOM     85  OE1 GLU    25      21.561  52.100  -8.295  1.00 45.74           O  
ATOM     86  OE2 GLU    25      19.958  51.022  -9.342  1.00 44.94           O  
ATOM     87  N   ALA    26      23.264  50.509  -6.181  1.00 43.10           N  
ATOM     88  CA  ALA    26      22.889  50.896  -4.846  1.00 42.10           C  
ATOM     89  C   ALA    26      21.383  50.862  -4.620  1.00 41.22           C  
ATOM     90  O   ALA    26      20.938  50.241  -3.667  1.00 41.52           O  
ATOM     91  CB  ALA    26      23.459  52.259  -4.514  1.00 42.27           C  
ATOM     92  N   VAL    27      20.618  51.503  -5.507  1.00 39.82           N  
ATOM     93  CA  VAL    27      19.170  51.685  -5.330  1.00 38.62           C  
ATOM     94  C   VAL    27      18.441  50.333  -5.389  1.00 38.25           C  
ATOM     95  O   VAL    27      17.627  50.011  -4.527  1.00 38.38           O  
ATOM     96  CB  VAL    27      18.586  52.704  -6.353  1.00 37.58           C  
ATOM     97  CG1 VAL    27      17.069  52.638  -6.404  1.00 37.20           C  
ATOM     98  CG2 VAL    27      19.050  54.113  -6.001  1.00 37.77           C  
ATOM     99  N   ARG    28      18.794  49.533  -6.374  1.00 38.45           N  
ATOM    100  CA  ARG    28      18.189  48.223  -6.565  1.00 39.15           C  
ATOM    101  C   ARG    28      18.541  47.242  -5.432  1.00 38.81           C  
ATOM    102  O   ARG    28      17.647  46.634  -4.831  1.00 39.72           O  
ATOM    103  CB  ARG    28      18.559  47.687  -7.963  1.00 38.85           C  
ATOM    104  CG  ARG    28      18.278  46.216  -8.142  1.00 41.94           C  
ATOM    105  CD  ARG    28      16.816  45.790  -7.837  1.00 45.21           C  
ATOM    106  NE  ARG    28      16.439  44.831  -8.874  1.00 51.01           N  
ATOM    107  CZ  ARG    28      16.676  43.525  -8.835  1.00 49.95           C  
ATOM    108  NH1 ARG    28      17.225  42.961  -7.766  1.00 50.06           N  
ATOM    109  NH2 ARG    28      16.313  42.783  -9.854  1.00 49.70           N  
ATOM    110  N   VAL    29      19.822  47.129  -5.087  1.00 38.22           N  
ATOM    111  CA  VAL    29      20.219  46.316  -3.927  1.00 37.36           C  
ATOM    112  C   VAL    29      19.496  46.775  -2.649  1.00 36.79           C  
ATOM    113  O   VAL    29      19.018  45.955  -1.848  1.00 36.89           O  
ATOM    114  CB  VAL    29      21.772  46.348  -3.708  1.00 37.56           C  
ATOM    115  CG1 VAL    29      22.144  45.746  -2.370  1.00 37.50           C  
ATOM    116  CG2 VAL    29      22.494  45.612  -4.819  1.00 37.85           C  
ATOM    117  N   ALA    30      19.421  48.097  -2.454  1.00 35.35           N  
ATOM    118  CA  ALA    30      18.687  48.682  -1.336  1.00 34.46           C  
ATOM    119  C   ALA    30      17.203  48.317  -1.292  1.00 33.63           C  
ATOM    120  O   ALA    30      16.700  47.953  -0.243  1.00 33.01           O  
ATOM    121  CB  ALA    30      18.851  50.228  -1.333  1.00 33.58           C  
ATOM    122  N   ARG    31      16.515  48.424  -2.422  1.00 32.99           N  
ATOM    123  CA  ARG    31      15.084  48.146  -2.496  1.00 34.07           C  
ATOM    124  C   ARG    31      14.826  46.663  -2.284  1.00 33.95           C  
ATOM    125  O   ARG    31      13.803  46.281  -1.725  1.00 35.51           O  
ATOM    126  CB  ARG    31      14.481  48.670  -3.812  1.00 33.27           C  
ATOM    127  CG  ARG    31      14.226  50.179  -3.744  1.00 34.01           C  
ATOM    128  CD  ARG    31      13.577  50.726  -5.019  1.00 35.99           C  
ATOM    129  NE  ARG    31      12.143  50.433  -5.017  1.00 33.98           N  
ATOM    130  CZ  ARG    31      11.416  50.411  -6.115  1.00 38.90           C  
ATOM    131  NH1 ARG    31      12.005  50.704  -7.262  1.00 31.97           N  
ATOM    132  NH2 ARG    31      10.110  50.128  -6.060  1.00 42.34           N  
ATOM    133  N   ASP    32      15.778  45.838  -2.686  1.00 34.58           N  
ATOM    134  CA  ASP    32      15.679  44.398  -2.466  0.50 35.02           C  
ATOM    136  C   ASP    32      15.826  44.056  -1.006  1.00 34.99           C  
ATOM    137  O   ASP    32      15.045  43.274  -0.480  1.00 35.71           O  
ATOM    138  CB  ASP    32      16.723  43.631  -3.275  0.50 34.91           C  
ATOM    140  CG  ASP    32      16.252  42.240  -3.643  0.50 37.60           C  
ATOM    142  OD1 ASP    32      15.113  42.109  -4.168  0.50 37.96           O  
ATOM    144  OD2 ASP    32      17.027  41.278  -3.431  0.50 39.94           O  
ATOM    146  N   VAL    33      16.799  44.665  -0.335  1.00 35.69           N  
ATOM    147  CA  VAL    33      16.952  44.479   1.129  1.00 35.38           C  
ATOM    148  C   VAL    33      15.725  44.991   1.852  1.00 36.91           C  
ATOM    149  O   VAL    33      15.266  44.403   2.861  1.00 37.01           O  
ATOM    150  CB  VAL    33      18.200  45.234   1.681  1.00 35.08           C  
ATOM    151  CG1 VAL    33      18.291  45.100   3.203  1.00 35.22           C  
ATOM    152  CG2 VAL    33      19.474  44.688   1.037  1.00 33.53           C  
ATOM    153  N   LEU    34      15.223  46.132   1.383  1.00 36.92           N  
ATOM    154  CA  LEU    34      14.044  46.713   1.963  1.00 37.55           C  
ATOM    155  C   LEU    34      12.872  45.725   1.973  1.00 37.09           C  
ATOM    156  O   LEU    34      12.183  45.569   3.011  1.00 37.29           O  
ATOM    157  CB  LEU    34      13.635  47.981   1.239  1.00 37.10           C  
ATOM    158  CG  LEU    34      12.325  48.656   1.652  1.00 36.56           C  
ATOM    159  CD1 LEU    34      12.382  49.294   3.019  1.00 35.33           C  
ATOM    160  CD2 LEU    34      12.021  49.705   0.548  1.00 33.63           C  
ATOM    161  N   HIS    35      12.674  45.055   0.852  1.00 36.94           N  
ATOM    162  CA  HIS    35      11.488  44.235   0.692  1.00 37.17           C  
ATOM    163  C   HIS    35      11.613  42.812   1.221  1.00 37.43           C  
ATOM    164  O   HIS    35      10.598  42.106   1.372  1.00 36.36           O  
ATOM    165  CB  HIS    35      11.031  44.238  -0.765  1.00 36.90           C  
ATOM    166  CG  HIS    35      10.298  45.502  -1.165  1.00 37.86           C  
ATOM    167  ND1 HIS    35       8.920  45.593  -1.165  1.00 38.07           N  
ATOM    168  CD2 HIS    35      10.751  46.717  -1.569  1.00 36.41           C  
ATOM    169  CE1 HIS    35       8.553  46.819  -1.526  1.00 36.43           C  
ATOM    170  NE2 HIS    35       9.647  47.517  -1.784  1.00 36.29           N  
ATOM    171  N   THR    36      12.843  42.372   1.438  1.00 36.97           N  
ATOM    172  CA  THR    36      13.079  40.969   1.718  1.00 37.62           C  
ATOM    173  C   THR    36      13.741  40.752   3.075  1.00 38.16           C  
ATOM    174  O   THR    36      14.194  39.635   3.373  1.00 38.65           O  
ATOM    175  CB  THR    36      13.897  40.253   0.588  1.00 39.04           C  
ATOM    176  OG1 THR    36      15.189  40.884   0.435  1.00 37.71           O  
ATOM    177  CG2 THR    36      13.146  40.274  -0.759  1.00 37.27           C  
ATOM    178  N   SER    37      13.811  41.788   3.890  1.00 37.79           N  
ATOM    179  CA  SER    37      14.363  41.613   5.263  1.00 39.48           C  
ATOM    180  C   SER    37      13.260  41.475   6.314  1.00 38.86           C  
ATOM    181  O   SER    37      12.412  42.358   6.422  1.00 38.51           O  
ATOM    182  CB  SER    37      15.345  42.762   5.618  1.00 38.38           C  
ATOM    183  OG  SER    37      16.371  42.838   4.608  1.00 41.05           O  
ATOM    184  N   ARG    38      13.268  40.369   7.076  1.00 39.77           N  
ATOM    185  CA  ARG    38      12.327  40.179   8.211  1.00 41.34           C  
ATOM    186  C   ARG    38      12.758  40.914   9.477  1.00 42.43           C  
ATOM    187  O   ARG    38      11.968  41.608  10.100  1.00 42.17           O  
ATOM    188  CB  ARG    38      12.100  38.691   8.578  1.00 41.21           C  
ATOM    189  CG  ARG    38      10.919  38.002   7.837  1.00 42.35           C  
ATOM    190  CD  ARG    38      10.623  36.515   8.413  1.00 44.16           C  
ATOM    191  NE  ARG    38       9.250  36.088   8.125  1.00 48.27           N  
ATOM    192  CZ  ARG    38       8.909  35.290   7.123  1.00 48.91           C  
ATOM    193  NH1 ARG    38       7.635  34.955   6.942  1.00 48.62           N  
ATOM    194  NH2 ARG    38       9.846  34.775   6.322  1.00 51.54           N  
ATOM    195  N   THR    39      14.015  40.742   9.867  1.00 43.04           N  
ATOM    196  CA  THR    39      14.487  41.282  11.126  1.00 43.56           C  
ATOM    197  C   THR    39      15.269  42.567  10.903  1.00 43.75           C  
ATOM    198  O   THR    39      16.001  42.696   9.921  1.00 43.67           O  
ATOM    199  CB  THR    39      15.318  40.257  11.910  1.00 43.91           C  
ATOM    200  OG1 THR    39      14.552  39.053  12.056  1.00 45.50           O  
ATOM    201  CG2 THR    39      15.640  40.777  13.315  1.00 44.70           C  
ATOM    202  N   ALA    40      15.033  43.524  11.799  1.00 41.52           N  
ATOM    203  CA  ALA    40      15.651  44.828  11.787  1.00 40.98           C  
ATOM    204  C   ALA    40      16.237  45.164  13.169  1.00 40.63           C  
ATOM    205  O   ALA    40      15.643  44.853  14.180  1.00 40.12           O  
ATOM    206  CB  ALA    40      14.604  45.873  11.432  1.00 41.19           C  
ATOM    207  N   ALA    41      17.418  45.765  13.177  1.00 39.80           N  
ATOM    208  CA  ALA    41      17.920  46.465  14.324  1.00 38.78           C  
ATOM    209  C   ALA    41      17.158  47.790  14.407  1.00 39.25           C  
ATOM    210  O   ALA    41      16.861  48.426  13.397  1.00 38.98           O  
ATOM    211  CB  ALA    41      19.416  46.708  14.140  1.00 39.12           C  
ATOM    212  N   LEU    42      16.797  48.193  15.623  1.00 38.68           N  
ATOM    213  CA  LEU    42      16.037  49.406  15.853  1.00 39.79           C  
ATOM    214  C   LEU    42      16.785  50.125  16.957  1.00 39.98           C  
ATOM    215  O   LEU    42      17.011  49.536  18.044  1.00 38.61           O  
ATOM    216  CB  LEU    42      14.655  49.049  16.433  1.00 40.02           C  
ATOM    217  CG  LEU    42      13.458  50.015  16.368  1.00 43.63           C  
ATOM    218  CD1 LEU    42      12.539  49.898  17.612  1.00 42.40           C  
ATOM    219  CD2 LEU    42      13.771  51.474  16.022  1.00 39.93           C  
ATOM    220  N   ALA    43      17.123  51.378  16.688  1.00 38.14           N  
ATOM    221  CA  ALA    43      17.741  52.250  17.656  1.00 38.67           C  
ATOM    222  C   ALA    43      16.827  53.423  17.999  1.00 39.37           C  
ATOM    223  O   ALA    43      16.177  54.035  17.134  1.00 40.23           O  
ATOM    224  CB  ALA    43      19.111  52.747  17.153  1.00 38.06           C  
ATOM    225  N   THR    44      16.877  53.783  19.273  1.00 39.46           N  
ATOM    226  CA  THR    44      15.964  54.691  19.898  1.00 38.96           C  
ATOM    227  C   THR    44      16.884  55.530  20.822  1.00 38.63           C  
ATOM    228  O   THR    44      18.054  55.168  21.043  1.00 38.06           O  
ATOM    229  CB  THR    44      14.985  53.702  20.568  1.00 40.23           C  
ATOM    230  OG1 THR    44      13.679  53.682  19.961  1.00 45.89           O  
ATOM    231  CG2 THR    44      15.079  53.504  22.014  1.00 33.78           C  
ATOM    232  N   LEU    45      16.389  56.659  21.328  1.00 38.88           N  
ATOM    233  CA  LEU    45      17.207  57.508  22.210  1.00 38.18           C  
ATOM    234  C   LEU    45      16.689  57.522  23.642  1.00 38.60           C  
ATOM    235  O   LEU    45      15.488  57.696  23.887  1.00 39.08           O  
ATOM    236  CB  LEU    45      17.306  58.953  21.676  1.00 38.20           C  
ATOM    237  CG  LEU    45      17.965  59.257  20.311  1.00 38.94           C  
ATOM    238  CD1 LEU    45      17.732  60.739  19.933  1.00 35.37           C  
ATOM    239  CD2 LEU    45      19.475  58.944  20.302  1.00 34.51           C  
ATOM    240  N   ASP    46      17.602  57.365  24.594  1.00 38.81           N  
ATOM    241  CA  ASP    46      17.234  57.458  25.978  1.00 38.11           C  
ATOM    242  C   ASP    46      16.965  58.919  26.355  1.00 38.82           C  
ATOM    243  O   ASP    46      17.782  59.804  26.077  1.00 39.17           O  
ATOM    244  CB  ASP    46      18.269  56.823  26.873  1.00 37.52           C  
ATOM    245  CG  ASP    46      17.782  56.687  28.297  1.00 38.27           C  
ATOM    246  OD1 ASP    46      17.801  57.702  29.037  1.00 39.29           O  
ATOM    247  OD2 ASP    46      17.353  55.572  28.670  1.00 39.12           O  
ATOM    248  N   PRO    47      15.793  59.181  26.968  1.00 39.51           N  
ATOM    249  CA  PRO    47      15.406  60.562  27.316  1.00 39.59           C  
ATOM    250  C   PRO    47      16.261  61.296  28.350  1.00 39.85           C  
ATOM    251  O   PRO    47      16.218  62.528  28.393  1.00 41.11           O  
ATOM    252  CB  PRO    47      13.972  60.421  27.810  1.00 39.48           C  
ATOM    253  CG  PRO    47      13.786  59.014  28.136  1.00 39.84           C  
ATOM    254  CD  PRO    47      14.738  58.210  27.302  1.00 39.29           C  
ATOM    255  N   VAL    48      16.978  60.575  29.215  1.00 39.58           N  
ATOM    256  CA  VAL    48      17.764  61.207  30.288  1.00 38.34           C  
ATOM    257  C   VAL    48      19.253  61.154  29.955  1.00 37.75           C  
ATOM    258  O   VAL    48      19.960  62.160  30.031  1.00 36.21           O  
ATOM    259  CB  VAL    48      17.522  60.535  31.703  1.00 38.53           C  
ATOM    260  CG1 VAL    48      18.371  61.189  32.800  1.00 38.22           C  
ATOM    261  CG2 VAL    48      16.045  60.571  32.106  1.00 38.99           C  
ATOM    262  N   SER    49      19.719  59.969  29.570  1.00 37.22           N  
ATOM    263  CA  SER    49      21.152  59.725  29.436  1.00 37.08           C  
ATOM    264  C   SER    49      21.684  60.192  28.093  1.00 37.18           C  
ATOM    265  O   SER    49      22.841  60.545  27.976  1.00 37.79           O  
ATOM    266  CB  SER    49      21.474  58.250  29.669  1.00 37.19           C  
ATOM    267  OG  SER    49      20.872  57.441  28.663  1.00 35.06           O  
ATOM    268  N   GLY    50      20.835  60.174  27.079  1.00 38.39           N  
ATOM    269  CA  GLY    50      21.214  60.622  25.742  1.00 38.15           C  
ATOM    270  C   GLY    50      21.913  59.521  24.969  1.00 36.98           C  
ATOM    271  O   GLY    50      22.166  59.670  23.775  1.00 37.41           O  
ATOM    272  N   TYR    51      22.211  58.412  25.651  1.00 35.98           N  
ATOM    273  CA  TYR    51      22.733  57.203  25.004  1.00 34.74           C  
ATOM    274  C   TYR    51      21.698  56.630  24.013  1.00 34.55           C  
ATOM    275  O   TYR    51      20.453  56.775  24.230  1.00 35.08           O  
ATOM    276  CB  TYR    51      23.047  56.109  26.039  1.00 33.87           C  
ATOM    277  CG  TYR    51      24.321  56.276  26.852  1.00 33.36           C  
ATOM    278  CD1 TYR    51      25.393  55.409  26.676  1.00 32.99           C  
ATOM    279  CD2 TYR    51      24.442  57.298  27.780  1.00 33.00           C  
ATOM    280  CE1 TYR    51      26.558  55.551  27.429  1.00 34.11           C  
ATOM    281  CE2 TYR    51      25.600  57.456  28.550  1.00 35.12           C  
ATOM    282  CZ  TYR    51      26.653  56.575  28.352  1.00 34.84           C  
ATOM    283  OH  TYR    51      27.786  56.715  29.074  1.00 32.74           O  
ATOM    284  N   PRO    52      22.191  55.951  22.950  1.00 34.99           N  
ATOM    285  CA  PRO    52      21.241  55.231  22.109  1.00 34.67           C  
ATOM    286  C   PRO    52      20.776  53.982  22.843  1.00 35.35           C  
ATOM    287  O   PRO    52      21.419  53.563  23.835  1.00 34.36           O  
ATOM    288  CB  PRO    52      22.052  54.874  20.842  1.00 35.16           C  
ATOM    289  CG  PRO    52      23.495  54.940  21.259  1.00 34.77           C  
ATOM    290  CD  PRO    52      23.602  55.799  22.497  1.00 34.82           C  
ATOM    291  N   TYR    53      19.673  53.403  22.378  1.00 35.86           N  
ATOM    292  CA  TYR    53      19.173  52.180  22.965  1.00 36.96           C  
ATOM    293  C   TYR    53      18.667  51.328  21.811  1.00 36.80           C  
ATOM    294  O   TYR    53      17.880  51.791  21.003  1.00 37.91           O  
ATOM    295  CB  TYR    53      18.040  52.462  24.003  1.00 36.72           C  
ATOM    296  CG  TYR    53      17.422  51.187  24.528  1.00 38.05           C  
ATOM    297  CD1 TYR    53      17.975  50.523  25.627  1.00 38.59           C  
ATOM    298  CD2 TYR    53      16.305  50.606  23.893  1.00 37.83           C  
ATOM    299  CE1 TYR    53      17.424  49.341  26.105  1.00 39.91           C  
ATOM    300  CE2 TYR    53      15.747  49.416  24.370  1.00 39.19           C  
ATOM    301  CZ  TYR    53      16.310  48.792  25.458  1.00 38.48           C  
ATOM    302  OH  TYR    53      15.774  47.610  25.907  1.00 40.55           O  
ATOM    303  N   THR    54      19.131  50.080  21.734  1.00 37.35           N  
ATOM    304  CA  THR    54      18.820  49.210  20.616  1.00 36.80           C  
ATOM    305  C   THR    54      17.924  48.044  20.993  1.00 37.74           C  
ATOM    306  O   THR    54      17.930  47.569  22.152  1.00 37.88           O  
ATOM    307  CB  THR    54      20.095  48.663  19.947  1.00 37.33           C  
ATOM    308  OG1 THR    54      20.944  48.083  20.945  1.00 36.66           O  
ATOM    309  CG2 THR    54      20.831  49.750  19.249  1.00 37.47           C  
ATOM    310  N   THR    55      17.168  47.563  20.005  1.00 37.99           N  
ATOM    311  CA  THR    55      16.482  46.258  20.101  1.00 38.74           C  
ATOM    312  C   THR    55      16.468  45.581  18.733  1.00 38.58           C  
ATOM    313  O   THR    55      16.991  46.145  17.767  1.00 38.75           O  
ATOM    314  CB  THR    55      15.031  46.362  20.760  1.00 39.15           C  
ATOM    315  OG1 THR    55      14.547  45.043  21.053  1.00 42.34           O  
ATOM    316  CG2 THR    55      14.021  47.094  19.861  1.00 37.54           C  
ATOM    317  N   ALA    56      15.919  44.370  18.666  1.00 37.63           N  
ATOM    318  CA  ALA    56      15.601  43.697  17.415  1.00 38.20           C  
ATOM    319  C   ALA    56      14.083  43.590  17.259  1.00 38.64           C  
ATOM    320  O   ALA    56      13.374  43.290  18.226  1.00 38.50           O  
ATOM    321  CB  ALA    56      16.243  42.301  17.344  1.00 37.34           C  
ATOM    322  N   THR    57      13.593  43.808  16.043  1.00 38.00           N  
ATOM    323  CA  THR    57      12.144  43.750  15.804  1.00 39.69           C  
ATOM    324  C   THR    57      11.844  43.200  14.405  1.00 40.17           C  
ATOM    325  O   THR    57      12.767  43.030  13.611  1.00 39.47           O  
ATOM    326  CB  THR    57      11.479  45.144  16.054  1.00 39.51           C  
ATOM    327  OG1 THR    57      10.075  44.982  16.284  1.00 42.44           O  
ATOM    328  CG2 THR    57      11.769  46.175  14.922  1.00 37.64           C  
ATOM    329  N   ASN    58      10.569  42.905  14.141  1.00 39.45           N  
ATOM    330  CA  ASN    58      10.140  42.384  12.852  1.00 40.47           C  
ATOM    331  C   ASN    58       9.653  43.550  11.984  1.00 39.86           C  
ATOM    332  O   ASN    58       8.995  44.471  12.473  1.00 39.32           O  
ATOM    333  CB  ASN    58       8.964  41.419  13.043  1.00 39.87           C  
ATOM    334  CG  ASN    58       9.261  40.264  13.997  1.00 42.71           C  
ATOM    335  OD1 ASN    58      10.325  39.625  13.945  1.00 43.20           O  
ATOM    336  ND2 ASN    58       8.253  39.910  14.811  1.00 41.63           N  
ATOM    337  N   ILE    59       9.872  43.453  10.689  1.00 40.97           N  
ATOM    338  CA  ILE    59       9.529  44.518   9.723  1.00 41.64           C  
ATOM    339  C   ILE    59       8.358  44.133   8.821  1.00 42.78           C  
ATOM    340  O   ILE    59       8.394  43.067   8.117  1.00 41.24           O  
ATOM    341  CB  ILE    59      10.792  44.815   8.837  1.00 41.35           C  
ATOM    342  CG1 ILE    59      11.835  45.573   9.675  1.00 42.44           C  
ATOM    343  CG2 ILE    59      10.454  45.666   7.603  1.00 44.65           C  
ATOM    344  CD1 ILE    59      11.346  46.945  10.221  1.00 39.10           C  
ATOM    345  N   GLY    60       7.314  44.975   8.847  1.00 43.54           N  
ATOM    346  CA  GLY    60       6.265  44.917   7.809  1.00 43.52           C  
ATOM    347  C   GLY    60       6.563  45.946   6.702  1.00 43.16           C  
ATOM    348  O   GLY    60       7.319  46.877   6.917  1.00 41.80           O  
ATOM    349  N   ILE    61       6.013  45.756   5.504  1.00 42.96           N  
ATOM    350  CA  ILE    61       6.196  46.748   4.436  1.00 44.08           C  
ATOM    351  C   ILE    61       4.826  47.088   3.847  1.00 43.86           C  
ATOM    352  O   ILE    61       4.039  46.184   3.546  1.00 45.44           O  
ATOM    353  CB  ILE    61       7.164  46.288   3.289  1.00 45.00           C  
ATOM    354  CG1 ILE    61       8.525  45.853   3.795  1.00 47.28           C  
ATOM    355  CG2 ILE    61       7.534  47.453   2.427  1.00 44.58           C  
ATOM    356  CD1 ILE    61       9.499  47.050   4.107  1.00 51.63           C  
ATOM    357  N   GLU    62       4.548  48.376   3.660  1.00 41.87           N  
ATOM    358  CA  GLU    62       3.316  48.797   3.016  1.00 41.07           C  
ATOM    359  C   GLU    62       3.499  48.862   1.468  1.00 41.15           C  
ATOM    360  O   GLU    62       4.639  48.887   0.990  1.00 41.34           O  
ATOM    361  CB  GLU    62       2.863  50.132   3.623  1.00 39.56           C  
ATOM    362  CG  GLU    62       2.863  50.081   5.181  1.00 39.44           C  
ATOM    363  CD  GLU    62       2.347  51.371   5.819  1.00 42.98           C  
ATOM    364  OE1 GLU    62       1.600  51.268   6.823  1.00 43.58           O  
ATOM    365  OE2 GLU    62       2.685  52.470   5.299  1.00 39.51           O  
ATOM    366  N   PRO    63       2.390  48.847   0.695  1.00 40.53           N  
ATOM    367  CA  PRO    63       2.460  48.832  -0.787  1.00 40.41           C  
ATOM    368  C   PRO    63       3.454  49.832  -1.394  1.00 39.89           C  
ATOM    369  O   PRO    63       4.140  49.476  -2.317  1.00 40.56           O  
ATOM    370  CB  PRO    63       1.033  49.157  -1.198  1.00 39.57           C  
ATOM    371  CG  PRO    63       0.213  48.552  -0.087  1.00 40.59           C  
ATOM    372  CD  PRO    63       0.995  48.773   1.160  1.00 40.41           C  
ATOM    373  N   ASP    64       3.560  51.048  -0.853  1.00 40.36           N  
ATOM    374  CA  ASP    64       4.530  52.054  -1.340  1.00 40.96           C  
ATOM    375  C   ASP    64       5.987  51.837  -0.852  1.00 41.65           C  
ATOM    376  O   ASP    64       6.844  52.696  -1.079  1.00 43.12           O  
ATOM    377  CB  ASP    64       4.066  53.493  -1.017  1.00 39.69           C  
ATOM    378  CG  ASP    64       4.138  53.809   0.465  1.00 40.09           C  
ATOM    379  OD1 ASP    64       3.820  54.926   0.865  1.00 40.33           O  
ATOM    380  OD2 ASP    64       4.498  52.913   1.241  1.00 36.40           O  
ATOM    381  N   GLY    65       6.228  50.735  -0.150  1.00 42.72           N  
ATOM    382  CA  GLY    65       7.554  50.370   0.345  1.00 44.04           C  
ATOM    383  C   GLY    65       7.891  50.838   1.747  1.00 44.29           C  
ATOM    384  O   GLY    65       8.999  50.566   2.222  1.00 45.96           O  
ATOM    385  N   THR    66       6.937  51.499   2.422  1.00 42.92           N  
ATOM    386  CA  THR    66       7.145  52.061   3.760  1.00 40.94           C  
ATOM    387  C   THR    66       7.233  50.965   4.834  1.00 40.64           C  
ATOM    388  O   THR    66       6.277  50.188   4.993  1.00 39.14           O  
ATOM    389  CB  THR    66       6.021  53.044   4.171  1.00 40.87           C  
ATOM    390  OG1 THR    66       5.955  54.140   3.252  1.00 40.45           O  
ATOM    391  CG2 THR    66       6.306  53.607   5.551  1.00 39.21           C  
ATOM    392  N   PRO    67       8.368  50.910   5.573  1.00 40.41           N  
ATOM    393  CA  PRO    67       8.465  49.942   6.647  1.00 41.38           C  
ATOM    394  C   PRO    67       7.598  50.307   7.843  1.00 41.41           C  
ATOM    395  O   PRO    67       7.431  51.490   8.173  1.00 40.86           O  
ATOM    396  CB  PRO    67       9.946  49.979   7.045  1.00 41.94           C  
ATOM    397  CG  PRO    67      10.638  50.775   6.040  1.00 41.43           C  
ATOM    398  CD  PRO    67       9.595  51.719   5.491  1.00 40.36           C  
ATOM    399  N   PHE    68       7.052  49.277   8.506  1.00 40.81           N  
ATOM    400  CA  PHE    68       6.285  49.530   9.723  1.00 39.59           C  
ATOM    401  C   PHE    68       6.606  48.413  10.691  1.00 39.37           C  
ATOM    402  O   PHE    68       7.122  47.356  10.315  1.00 38.92           O  
ATOM    403  CB  PHE    68       4.757  49.696   9.440  1.00 38.61           C  
ATOM    404  CG  PHE    68       4.008  48.388   9.182  1.00 38.40           C  
ATOM    405  CD1 PHE    68       3.373  47.706  10.228  1.00 39.53           C  
ATOM    406  CD2 PHE    68       3.910  47.857   7.890  1.00 37.81           C  
ATOM    407  CE1 PHE    68       2.642  46.505   9.975  1.00 40.30           C  
ATOM    408  CE2 PHE    68       3.216  46.680   7.637  1.00 39.43           C  
ATOM    409  CZ  PHE    68       2.582  45.996   8.692  1.00 40.88           C  
ATOM    410  N   PHE    69       6.294  48.640  11.947  1.00 39.54           N  
ATOM    411  CA  PHE    69       6.642  47.671  12.957  1.00 39.34           C  
ATOM    412  C   PHE    69       5.764  47.887  14.204  1.00 38.68           C  
ATOM    413  O   PHE    69       5.059  48.905  14.332  1.00 38.42           O  
ATOM    414  CB  PHE    69       8.148  47.734  13.285  1.00 39.39           C  
ATOM    415  CG  PHE    69       8.605  49.071  13.808  1.00 40.13           C  
ATOM    416  CD1 PHE    69       8.609  49.334  15.181  1.00 37.66           C  
ATOM    417  CD2 PHE    69       9.055  50.060  12.934  1.00 40.27           C  
ATOM    418  CE1 PHE    69       9.039  50.590  15.678  1.00 40.43           C  
ATOM    419  CE2 PHE    69       9.487  51.301  13.407  1.00 39.29           C  
ATOM    420  CZ  PHE    69       9.483  51.566  14.796  1.00 42.12           C  
ATOM    421  N   PHE    70       5.835  46.889  15.076  1.00 38.05           N  
ATOM    422  CA  PHE    70       5.076  46.866  16.296  0.50 38.37           C  
ATOM    424  C   PHE    70       6.038  46.859  17.464  1.00 38.87           C  
ATOM    425  O   PHE    70       7.149  46.304  17.360  1.00 38.01           O  
ATOM    426  CB  PHE    70       4.186  45.615  16.328  0.50 38.34           C  
ATOM    428  CG  PHE    70       4.063  44.995  17.679  0.50 37.72           C  
ATOM    430  CD1 PHE    70       3.134  45.471  18.599  0.50 36.50           C  
ATOM    432  CD2 PHE    70       4.879  43.917  18.036  0.50 38.31           C  
ATOM    434  CE1 PHE    70       3.023  44.878  19.863  0.50 37.53           C  
ATOM    436  CE2 PHE    70       4.773  43.321  19.307  0.50 36.98           C  
ATOM    438  CZ  PHE    70       3.851  43.807  20.216  0.50 36.69           C  
ATOM    440  N   ALA    71       5.596  47.458  18.571  1.00 38.29           N  
ATOM    441  CA  ALA    71       6.344  47.406  19.823  1.00 38.96           C  
ATOM    442  C   ALA    71       5.331  47.251  20.949  1.00 39.61           C  
ATOM    443  O   ALA    71       4.312  47.936  20.937  1.00 40.47           O  
ATOM    444  CB  ALA    71       7.151  48.660  20.043  1.00 38.39           C  
ATOM    445  N   ALA    72       5.592  46.345  21.892  1.00 39.98           N  
ATOM    446  CA  ALA    72       4.775  46.269  23.119  1.00 41.01           C  
ATOM    447  C   ALA    72       4.906  47.607  23.852  1.00 41.50           C  
ATOM    448  O   ALA    72       6.005  48.142  23.924  1.00 42.57           O  
ATOM    449  CB  ALA    72       5.262  45.138  23.991  1.00 40.44           C  
ATOM    450  N   GLY    73       3.808  48.150  24.386  1.00 41.80           N  
ATOM    451  CA  GLY    73       3.846  49.469  25.049  1.00 41.25           C  
ATOM    452  C   GLY    73       4.707  49.578  26.305  1.00 41.94           C  
ATOM    453  O   GLY    73       5.268  50.647  26.616  1.00 41.43           O  
ATOM    454  N   LEU    74       4.819  48.486  27.054  1.00 41.99           N  
ATOM    455  CA  LEU    74       5.571  48.544  28.315  1.00 43.68           C  
ATOM    456  C   LEU    74       7.093  48.305  28.146  1.00 43.63           C  
ATOM    457  O   LEU    74       7.759  47.837  29.053  1.00 44.67           O  
ATOM    458  CB  LEU    74       4.930  47.605  29.352  1.00 44.01           C  
ATOM    459  CG  LEU    74       3.413  47.749  29.578  1.00 46.05           C  
ATOM    460  CD1 LEU    74       2.965  46.988  30.851  1.00 49.35           C  
ATOM    461  CD2 LEU    74       2.939  49.230  29.653  1.00 48.89           C  
ATOM    462  N   THR    75       7.626  48.623  26.970  1.00 43.11           N  
ATOM    463  CA  THR    75       9.046  48.418  26.701  1.00 42.65           C  
ATOM    464  C   THR    75       9.824  49.744  26.683  1.00 42.24           C  
ATOM    465  O   THR    75       9.263  50.835  26.438  1.00 41.76           O  
ATOM    466  CB  THR    75       9.306  47.632  25.409  1.00 42.39           C  
ATOM    467  OG1 THR    75       8.924  48.421  24.270  1.00 44.12           O  
ATOM    468  CG2 THR    75       8.570  46.277  25.420  1.00 41.79           C  
ATOM    469  N   LEU    76      11.114  49.633  26.971  1.00 40.77           N  
ATOM    470  CA  LEU    76      12.015  50.766  26.924  1.00 41.14           C  
ATOM    471  C   LEU    76      12.007  51.489  25.574  1.00 40.66           C  
ATOM    472  O   LEU    76      11.944  52.711  25.542  1.00 39.81           O  
ATOM    473  CB  LEU    76      13.425  50.295  27.255  1.00 41.59           C  
ATOM    474  CG  LEU    76      14.009  50.414  28.673  1.00 43.88           C  
ATOM    475  CD1 LEU    76      13.137  51.171  29.678  1.00 45.72           C  
ATOM    476  CD2 LEU    76      14.462  49.068  29.235  1.00 45.24           C  
ATOM    477  N   HIS    77      12.082  50.753  24.458  1.00 39.75           N  
ATOM    478  CA  HIS    77      12.104  51.447  23.167  1.00 39.95           C  
ATOM    479  C   HIS    77      10.777  52.175  22.905  1.00 39.38           C  
ATOM    480  O   HIS    77      10.792  53.307  22.464  1.00 40.18           O  
ATOM    481  CB  HIS    77      12.509  50.543  21.992  1.00 39.44           C  
ATOM    482  CG  HIS    77      11.775  49.241  21.944  1.00 39.43           C  
ATOM    483  ND1 HIS    77      11.884  48.284  22.934  1.00 40.59           N  
ATOM    484  CD2 HIS    77      10.954  48.718  21.004  1.00 41.59           C  
ATOM    485  CE1 HIS    77      11.144  47.235  22.614  1.00 38.83           C  
ATOM    486  NE2 HIS    77      10.565  47.473  21.448  1.00 39.75           N  
ATOM    487  N   ALA    78       9.640  51.531  23.189  1.00 39.56           N  
ATOM    488  CA  ALA    78       8.326  52.206  23.113  1.00 38.93           C  
ATOM    489  C   ALA    78       8.338  53.516  23.887  1.00 38.55           C  
ATOM    490  O   ALA    78       7.962  54.567  23.330  1.00 39.14           O  
ATOM    491  CB  ALA    78       7.207  51.312  23.617  1.00 38.80           C  
ATOM    492  N   ARG    79       8.770  53.448  25.163  1.00 37.66           N  
ATOM    493  CA  ARG    79       8.928  54.611  26.013  1.00 37.31           C  
ATOM    494  C   ARG    79       9.798  55.654  25.329  1.00 37.34           C  
ATOM    495  O   ARG    79       9.412  56.836  25.268  1.00 36.32           O  
ATOM    496  CB  ARG    79       9.554  54.227  27.373  1.00 36.74           C  
ATOM    497  CG  ARG    79       9.456  55.287  28.537  1.00 37.11           C  
ATOM    498  CD  ARG    79      10.594  56.342  28.549  1.00 38.08           C  
ATOM    499  NE  ARG    79      11.916  55.725  28.313  1.00 40.43           N  
ATOM    500  CZ  ARG    79      12.646  55.127  29.241  1.00 38.21           C  
ATOM    501  NH1 ARG    79      12.214  55.069  30.506  1.00 37.01           N  
ATOM    502  NH2 ARG    79      13.817  54.592  28.914  1.00 38.84           N  
ATOM    503  N   ASN    80      10.978  55.233  24.861  1.00 37.06           N  
ATOM    504  CA  ASN    80      11.944  56.179  24.276  1.00 38.46           C  
ATOM    505  C   ASN    80      11.301  56.927  23.122  1.00 39.46           C  
ATOM    506  O   ASN    80      11.364  58.170  23.060  1.00 39.42           O  
ATOM    507  CB  ASN    80      13.239  55.484  23.823  1.00 38.83           C  
ATOM    508  CG  ASN    80      14.083  54.995  24.983  1.00 37.97           C  
ATOM    509  OD1 ASN    80      13.876  55.410  26.113  1.00 38.02           O  
ATOM    510  ND2 ASN    80      15.026  54.079  24.712  1.00 33.92           N  
ATOM    511  N   MET    81      10.639  56.167  22.250  1.00 40.14           N  
ATOM    512  CA  MET    81       9.919  56.713  21.108  1.00 42.73           C  
ATOM    513  C   MET    81       8.765  57.675  21.467  1.00 43.11           C  
ATOM    514  O   MET    81       8.520  58.618  20.730  1.00 42.53           O  
ATOM    515  CB  MET    81       9.432  55.580  20.198  1.00 42.61           C  
ATOM    516  CG  MET    81      10.568  54.902  19.431  1.00 43.80           C  
ATOM    517  SD  MET    81       9.974  53.560  18.134  0.90 48.49          SE  
ATOM    518  CE  MET    81       9.395  52.112  19.373  1.00 41.87           C  
ATOM    519  N   GLU    82       8.087  57.458  22.601  1.00 44.27           N  
ATOM    520  CA  GLU    82       7.135  58.466  23.137  1.00 45.85           C  
ATOM    521  C   GLU    82       7.860  59.782  23.394  1.00 45.91           C  
ATOM    522  O   GLU    82       7.403  60.843  22.989  1.00 46.79           O  
ATOM    523  CB  GLU    82       6.489  58.039  24.470  1.00 45.53           C  
ATOM    524  CG  GLU    82       5.217  57.205  24.406  1.00 48.85           C  
ATOM    525  CD  GLU    82       4.247  57.594  23.266  1.00 54.63           C  
ATOM    526  OE1 GLU    82       3.253  58.314  23.531  1.00 55.24           O  
ATOM    527  OE2 GLU    82       4.470  57.147  22.101  1.00 57.39           O  
ATOM    528  N   THR    83       8.992  59.693  24.080  1.00 46.45           N  
ATOM    529  CA  THR    83       9.771  60.867  24.475  1.00 45.76           C  
ATOM    530  C   THR    83      10.447  61.603  23.288  1.00 45.32           C  
ATOM    531  O   THR    83      10.521  62.828  23.305  1.00 45.43           O  
ATOM    532  CB  THR    83      10.795  60.516  25.590  1.00 46.00           C  
ATOM    533  OG1 THR    83      11.720  59.527  25.129  1.00 46.47           O  
ATOM    534  CG2 THR    83      10.084  59.971  26.841  1.00 46.29           C  
ATOM    535  N   ASP    84      10.895  60.857  22.263  1.00 43.62           N  
ATOM    536  CA  ASP    84      11.665  61.391  21.128  1.00 41.98           C  
ATOM    537  C   ASP    84      11.534  60.402  19.962  1.00 41.59           C  
ATOM    538  O   ASP    84      11.974  59.236  20.064  1.00 40.45           O  
ATOM    539  CB  ASP    84      13.139  61.539  21.541  1.00 42.13           C  
ATOM    540  CG  ASP    84      14.009  62.236  20.488  1.00 42.54           C  
ATOM    541  OD1 ASP    84      13.770  62.126  19.266  1.00 43.26           O  
ATOM    542  OD2 ASP    84      14.984  62.892  20.912  1.00 44.27           O  
ATOM    543  N   ALA    85      10.941  60.861  18.856  1.00 39.53           N  
ATOM    544  CA  ALA    85      10.596  59.949  17.752  1.00 38.78           C  
ATOM    545  C   ALA    85      11.753  59.634  16.791  1.00 38.06           C  
ATOM    546  O   ALA    85      11.574  58.840  15.886  1.00 38.40           O  
ATOM    547  CB  ALA    85       9.356  60.477  16.964  1.00 38.66           C  
ATOM    548  N   ARG    86      12.921  60.255  16.968  1.00 37.49           N  
ATOM    549  CA  ARG    86      14.075  59.998  16.101  1.00 37.80           C  
ATOM    550  C   ARG    86      14.598  58.573  16.313  1.00 37.79           C  
ATOM    551  O   ARG    86      14.936  58.172  17.447  1.00 38.77           O  
ATOM    552  CB  ARG    86      15.191  61.015  16.337  1.00 37.29           C  
ATOM    553  CG  ARG    86      14.782  62.423  15.962  1.00 37.81           C  
ATOM    554  CD  ARG    86      15.909  63.377  16.220  1.00 40.31           C  
ATOM    555  NE  ARG    86      16.150  63.542  17.639  1.00 40.47           N  
ATOM    556  CZ  ARG    86      17.144  64.262  18.153  1.00 42.65           C  
ATOM    557  NH1 ARG    86      17.257  64.358  19.461  1.00 40.10           N  
ATOM    558  NH2 ARG    86      18.022  64.881  17.368  1.00 43.73           N  
ATOM    559  N   ILE    87      14.606  57.800  15.230  1.00 38.06           N  
ATOM    560  CA  ILE    87      15.018  56.378  15.256  1.00 36.98           C  
ATOM    561  C   ILE    87      15.927  56.047  14.083  1.00 38.03           C  
ATOM    562  O   ILE    87      16.014  56.818  13.113  1.00 37.74           O  
ATOM    563  CB  ILE    87      13.797  55.385  15.235  1.00 36.88           C  
ATOM    564  CG1 ILE    87      12.957  55.462  13.944  1.00 36.90           C  
ATOM    565  CG2 ILE    87      12.886  55.630  16.470  1.00 36.77           C  
ATOM    566  CD1 ILE    87      12.027  54.186  13.735  1.00 34.81           C  
ATOM    567  N   SER    88      16.604  54.893  14.173  1.00 38.43           N  
ATOM    568  CA  SER    88      17.331  54.328  13.048  1.00 37.90           C  
ATOM    569  C   SER    88      17.026  52.830  12.974  1.00 38.40           C  
ATOM    570  O   SER    88      16.896  52.180  14.008  1.00 38.37           O  
ATOM    571  CB  SER    88      18.842  54.556  13.197  1.00 36.88           C  
ATOM    572  OG  SER    88      19.560  54.036  12.078  1.00 36.15           O  
ATOM    573  N   VAL    89      16.930  52.277  11.760  1.00 38.48           N  
ATOM    574  CA  VAL    89      16.787  50.813  11.601  1.00 38.88           C  
ATOM    575  C   VAL    89      17.830  50.302  10.631  1.00 38.06           C  
ATOM    576  O   VAL    89      18.230  51.035   9.725  1.00 36.88           O  
ATOM    577  CB  VAL    89      15.369  50.373  11.097  1.00 40.20           C  
ATOM    578  CG1 VAL    89      14.302  50.819  12.041  1.00 38.37           C  
ATOM    579  CG2 VAL    89      15.078  50.950   9.696  1.00 40.61           C  
ATOM    580  N   THR    90      18.312  49.087  10.863  1.00 37.53           N  
ATOM    581  CA  THR    90      19.163  48.436   9.884  1.00 37.70           C  
ATOM    582  C   THR    90      18.491  47.149   9.499  1.00 37.66           C  
ATOM    583  O   THR    90      18.180  46.320  10.339  1.00 38.80           O  
ATOM    584  CB  THR    90      20.601  48.220  10.352  1.00 35.79           C  
ATOM    585  OG1 THR    90      21.173  49.505  10.639  1.00 36.06           O  
ATOM    586  CG2 THR    90      21.482  47.492   9.246  1.00 37.44           C  
ATOM    587  N   LEU    91      18.250  47.032   8.200  1.00 38.53           N  
ATOM    588  CA  LEU    91      17.699  45.849   7.614  1.00 39.28           C  
ATOM    589  C   LEU    91      18.794  45.059   6.917  1.00 40.62           C  
ATOM    590  O   LEU    91      19.650  45.631   6.225  1.00 40.09           O  
ATOM    591  CB  LEU    91      16.605  46.249   6.647  1.00 40.01           C  
ATOM    592  CG  LEU    91      15.246  46.573   7.263  1.00 38.97           C  
ATOM    593  CD1 LEU    91      15.310  47.813   8.152  1.00 43.01           C  
ATOM    594  CD2 LEU    91      14.252  46.840   6.101  1.00 40.75           C  
ATOM    595  N   ALA    92      18.781  43.736   7.095  1.00 41.61           N  
ATOM    596  CA  ALA    92      19.736  42.893   6.387  1.00 43.96           C  
ATOM    597  C   ALA    92      19.142  41.498   6.171  1.00 46.03           C  
ATOM    598  O   ALA    92      18.278  41.098   6.966  1.00 47.72           O  
ATOM    599  CB  ALA    92      21.036  42.818   7.155  1.00 42.95           C  
ATOM    600  N   PRO    93      19.572  40.763   5.108  1.00 47.15           N  
ATOM    601  CA  PRO    93      19.204  39.332   5.006  1.00 47.61           C  
ATOM    602  C   PRO    93      19.973  38.543   6.092  1.00 47.80           C  
ATOM    603  O   PRO    93      20.882  37.772   5.765  1.00 47.05           O  
ATOM    604  CB  PRO    93      19.687  38.934   3.596  1.00 47.22           C  
ATOM    605  CG  PRO    93      20.845  39.877   3.317  1.00 47.42           C  
ATOM    606  CD  PRO    93      20.406  41.189   3.950  1.00 47.69           C  
ATOM    607  N   PHE    94      19.635  38.785   7.367  1.00 47.53           N  
ATOM    608  CA  PHE    94      20.393  38.209   8.489  1.00 48.62           C  
ATOM    609  C   PHE    94      20.432  36.678   8.505  1.00 50.08           C  
ATOM    610  O   PHE    94      21.419  36.076   8.964  1.00 51.13           O  
ATOM    611  CB  PHE    94      19.810  38.662   9.811  1.00 48.35           C  
ATOM    612  CG  PHE    94      20.107  40.061  10.144  1.00 48.23           C  
ATOM    613  CD1 PHE    94      21.394  40.456  10.421  1.00 47.44           C  
ATOM    614  CD2 PHE    94      19.080  41.006  10.192  1.00 46.55           C  
ATOM    615  CE1 PHE    94      21.655  41.793  10.741  1.00 49.24           C  
ATOM    616  CE2 PHE    94      19.329  42.325  10.524  1.00 47.35           C  
ATOM    617  CZ  PHE    94      20.607  42.724  10.797  1.00 48.46           C  
ATOM    618  N   GLY    95      19.369  36.036   8.025  1.00 50.07           N  
ATOM    619  CA  GLY    95      19.398  34.572   7.973  1.00 52.05           C  
ATOM    620  C   GLY    95      20.520  34.009   7.112  1.00 52.20           C  
ATOM    621  O   GLY    95      20.907  32.844   7.284  1.00 52.90           O  
ATOM    622  N   LYS    96      21.045  34.824   6.187  1.00 52.00           N  
ATOM    623  CA  LYS    96      21.969  34.329   5.148  1.00 51.83           C  
ATOM    624  C   LYS    96      23.437  34.283   5.579  1.00 51.44           C  
ATOM    625  O   LYS    96      24.319  34.006   4.770  1.00 51.70           O  
ATOM    626  CB  LYS    96      21.802  35.142   3.824  1.00 51.81           C  
ATOM    627  N   GLY    97      23.713  34.551   6.847  1.00 50.94           N  
ATOM    628  CA  GLY    97      25.090  34.414   7.308  1.00 50.33           C  
ATOM    629  C   GLY    97      25.611  35.687   7.922  1.00 49.54           C  
ATOM    630  O   GLY    97      24.831  36.573   8.261  1.00 50.33           O  
ATOM    631  N   ASP    98      26.932  35.782   8.047  1.00 49.05           N  
ATOM    632  CA  ASP    98      27.539  36.781   8.924  1.00 48.11           C  
ATOM    633  C   ASP    98      27.244  38.226   8.526  1.00 47.99           C  
ATOM    634  O   ASP    98      27.201  38.544   7.338  1.00 47.68           O  
ATOM    635  CB  ASP    98      29.033  36.507   9.105  1.00 47.96           C  
ATOM    636  CG  ASP    98      29.289  35.466  10.185  1.00 47.86           C  
ATOM    637  OD1 ASP    98      28.397  35.330  11.066  1.00 49.44           O  
ATOM    638  OD2 ASP    98      30.344  34.796  10.165  1.00 42.64           O  
ATOM    639  N   ALA    99      27.013  39.085   9.526  1.00 47.12           N  
ATOM    640  CA  ALA    99      26.613  40.475   9.280  1.00 47.62           C  
ATOM    641  C   ALA    99      27.544  41.255   8.332  1.00 47.81           C  
ATOM    642  O   ALA    99      27.066  41.994   7.462  1.00 49.11           O  
ATOM    643  CB  ALA    99      26.414  41.247  10.612  1.00 46.67           C  
ATOM    644  N   LEU   100      28.854  41.108   8.500  1.00 47.20           N  
ATOM    645  CA  LEU   100      29.784  41.843   7.668  1.00 47.26           C  
ATOM    646  C   LEU   100      29.881  41.320   6.208  1.00 47.34           C  
ATOM    647  O   LEU   100      30.537  41.933   5.366  1.00 47.80           O  
ATOM    648  CB  LEU   100      31.156  41.957   8.363  1.00 47.63           C  
ATOM    649  CG  LEU   100      31.246  42.793   9.655  1.00 47.37           C  
ATOM    650  CD1 LEU   100      32.698  42.945  10.097  1.00 44.40           C  
ATOM    651  CD2 LEU   100      30.603  44.166   9.523  1.00 47.96           C  
ATOM    652  N   THR   101      29.225  40.196   5.918  1.00 47.25           N  
ATOM    653  CA  THR   101      29.122  39.670   4.543  1.00 47.24           C  
ATOM    654  C   THR   101      27.868  40.174   3.822  1.00 47.24           C  
ATOM    655  O   THR   101      27.753  40.062   2.608  1.00 48.04           O  
ATOM    656  CB  THR   101      29.068  38.093   4.506  1.00 47.64           C  
ATOM    657  OG1 THR   101      27.862  37.639   5.158  1.00 47.49           O  
ATOM    658  CG2 THR   101      30.274  37.470   5.169  1.00 44.40           C  
ATOM    659  N   LEU   102      26.921  40.710   4.562  1.00 47.23           N  
ATOM    660  CA  LEU   102      25.623  41.022   4.011  1.00 47.59           C  
ATOM    661  C   LEU   102      25.497  42.449   3.542  1.00 46.58           C  
ATOM    662  O   LEU   102      26.127  43.302   4.092  1.00 46.32           O  
ATOM    663  CB  LEU   102      24.556  40.797   5.080  1.00 48.18           C  
ATOM    664  CG  LEU   102      24.513  39.508   5.876  1.00 49.29           C  
ATOM    665  CD1 LEU   102      23.450  39.497   6.890  1.00 47.88           C  
ATOM    666  CD2 LEU   102      24.375  38.361   4.974  1.00 48.28           C  
ATOM    667  N   PRO   103      24.634  42.711   2.567  1.00 45.68           N  
ATOM    668  CA  PRO   103      24.248  44.107   2.342  1.00 44.98           C  
ATOM    669  C   PRO   103      23.440  44.570   3.544  1.00 44.51           C  
ATOM    670  O   PRO   103      22.679  43.789   4.116  1.00 45.61           O  
ATOM    671  CB  PRO   103      23.360  44.042   1.099  1.00 45.24           C  
ATOM    672  CG  PRO   103      22.818  42.660   1.098  1.00 46.09           C  
ATOM    673  CD  PRO   103      23.959  41.807   1.626  1.00 45.51           C  
ATOM    674  N   ARG   104      23.642  45.803   3.964  1.00 42.27           N  
ATOM    675  CA  ARG   104      23.009  46.293   5.151  1.00 42.38           C  
ATOM    676  C   ARG   104      22.432  47.658   4.826  1.00 40.76           C  
ATOM    677  O   ARG   104      23.163  48.568   4.419  1.00 40.88           O  
ATOM    678  CB  ARG   104      24.002  46.412   6.307  1.00 42.35           C  
ATOM    679  CG  ARG   104      24.269  45.116   7.027  1.00 45.67           C  
ATOM    680  CD  ARG   104      25.616  44.582   6.761  1.00 47.32           C  
ATOM    681  NE  ARG   104      26.661  45.481   7.210  1.00 49.89           N  
ATOM    682  CZ  ARG   104      27.859  45.565   6.657  1.00 50.47           C  
ATOM    683  NH1 ARG   104      28.731  46.415   7.158  1.00 52.92           N  
ATOM    684  NH2 ARG   104      28.191  44.799   5.609  1.00 54.70           N  
ATOM    685  N   LEU   105      21.116  47.757   4.962  1.00 38.88           N  
ATOM    686  CA  LEU   105      20.420  48.984   4.661  1.00 37.14           C  
ATOM    687  C   LEU   105      20.077  49.715   5.945  1.00 37.01           C  
ATOM    688  O   LEU   105      19.348  49.180   6.791  1.00 36.52           O  
ATOM    689  CB  LEU   105      19.189  48.688   3.787  1.00 37.18           C  
ATOM    690  CG  LEU   105      18.183  49.809   3.601  1.00 37.12           C  
ATOM    691  CD1 LEU   105      18.777  50.834   2.609  1.00 38.71           C  
ATOM    692  CD2 LEU   105      16.883  49.254   3.095  1.00 39.88           C  
ATOM    693  N   THR   106      20.646  50.912   6.115  1.00 36.12           N  
ATOM    694  CA  THR   106      20.308  51.740   7.269  1.00 36.15           C  
ATOM    695  C   THR   106      19.352  52.861   6.858  1.00 36.02           C  
ATOM    696  O   THR   106      19.630  53.603   5.923  1.00 34.58           O  
ATOM    697  CB  THR   106      21.576  52.300   7.981  1.00 36.43           C  
ATOM    698  OG1 THR   106      22.362  51.202   8.439  1.00 37.67           O  
ATOM    699  CG2 THR   106      21.183  53.136   9.188  1.00 35.63           C  
ATOM    700  N   LEU   107      18.220  52.959   7.562  1.00 36.38           N  
ATOM    701  CA  LEU   107      17.226  53.997   7.322  1.00 37.39           C  
ATOM    702  C   LEU   107      17.071  54.808   8.598  1.00 37.59           C  
ATOM    703  O   LEU   107      16.786  54.255   9.658  1.00 38.36           O  
ATOM    704  CB  LEU   107      15.883  53.386   6.890  1.00 37.42           C  
ATOM    705  CG  LEU   107      15.888  52.335   5.754  1.00 38.96           C  
ATOM    706  CD1 LEU   107      14.515  51.683   5.658  1.00 38.73           C  
ATOM    707  CD2 LEU   107      16.225  52.995   4.407  1.00 37.32           C  
ATOM    708  N   VAL   108      17.306  56.117   8.486  1.00 37.38           N  
ATOM    709  CA  VAL   108      17.208  57.028   9.609  1.00 36.50           C  
ATOM    710  C   VAL   108      15.982  57.912   9.428  1.00 36.44           C  
ATOM    711  O   VAL   108      15.771  58.434   8.349  1.00 36.83           O  
ATOM    712  CB  VAL   108      18.506  57.843   9.752  1.00 35.47           C  
ATOM    713  CG1 VAL   108      18.391  58.875  10.868  1.00 35.13           C  
ATOM    714  CG2 VAL   108      19.692  56.899   9.952  1.00 33.05           C  
ATOM    715  N   GLY   109      15.178  58.090  10.478  1.00 37.67           N  
ATOM    716  CA  GLY   109      14.016  58.998  10.380  1.00 37.60           C  
ATOM    717  C   GLY   109      13.194  59.088  11.645  1.00 38.67           C  
ATOM    718  O   GLY   109      13.748  59.065  12.745  1.00 38.44           O  
ATOM    719  N   ARG   110      11.873  59.219  11.496  1.00 39.40           N  
ATOM    720  CA  ARG   110      10.971  59.310  12.660  1.00 39.19           C  
ATOM    721  C   ARG   110       9.996  58.148  12.742  1.00 39.98           C  
ATOM    722  O   ARG   110       9.556  57.623  11.725  1.00 40.59           O  
ATOM    723  CB  ARG   110      10.250  60.665  12.723  1.00 38.94           C  
ATOM    724  CG  ARG   110      11.188  61.811  13.077  1.00 37.80           C  
ATOM    725  CD  ARG   110      10.575  63.184  12.887  1.00 38.81           C  
ATOM    726  NE  ARG   110      11.606  64.173  13.201  1.00 40.29           N  
ATOM    727  CZ  ARG   110      11.942  64.569  14.432  1.00 41.25           C  
ATOM    728  NH1 ARG   110      12.941  65.434  14.584  1.00 40.86           N  
ATOM    729  NH2 ARG   110      11.291  64.117  15.507  1.00 40.51           N  
ATOM    730  N   ALA   111       9.739  57.698  13.974  1.00 39.87           N  
ATOM    731  CA  ALA   111       8.742  56.686  14.255  1.00 39.24           C  
ATOM    732  C   ALA   111       7.410  57.388  14.427  1.00 39.28           C  
ATOM    733  O   ALA   111       7.158  58.004  15.488  1.00 39.27           O  
ATOM    734  CB  ALA   111       9.101  55.963  15.524  1.00 40.42           C  
ATOM    735  N   ASP   112       6.564  57.297  13.400  1.00 37.97           N  
ATOM    736  CA  ASP   112       5.245  57.869  13.413  1.00 37.66           C  
ATOM    737  C   ASP   112       4.263  56.791  13.859  1.00 39.07           C  
ATOM    738  O   ASP   112       4.145  55.730  13.241  1.00 37.57           O  
ATOM    739  CB  ASP   112       4.845  58.330  12.005  1.00 37.47           C  
ATOM    740  CG  ASP   112       5.527  59.613  11.572  1.00 38.12           C  
ATOM    741  OD1 ASP   112       5.787  60.485  12.423  1.00 34.00           O  
ATOM    742  OD2 ASP   112       5.797  59.778  10.356  1.00 37.81           O  
ATOM    743  N   ARG   113       3.500  57.090  14.888  1.00 39.45           N  
ATOM    744  CA  ARG   113       2.459  56.184  15.313  1.00 40.59           C  
ATOM    745  C   ARG   113       1.341  56.051  14.258  1.00 40.91           C  
ATOM    746  O   ARG   113       0.798  57.048  13.762  1.00 40.36           O  
ATOM    747  CB  ARG   113       1.932  56.668  16.654  1.00 42.56           C  
ATOM    748  CG  ARG   113       1.322  55.580  17.451  1.00 46.63           C  
ATOM    749  CD  ARG   113       2.301  54.882  18.378  1.00 48.90           C  
ATOM    750  NE  ARG   113       1.434  54.340  19.405  1.00 53.60           N  
ATOM    751  CZ  ARG   113       1.151  54.953  20.547  1.00 53.42           C  
ATOM    752  NH1 ARG   113       1.738  56.096  20.858  1.00 55.23           N  
ATOM    753  NH2 ARG   113       0.299  54.401  21.390  1.00 54.54           N  
ATOM    754  N   ILE   114       1.048  54.812  13.868  1.00 40.30           N  
ATOM    755  CA  ILE   114      -0.049  54.545  12.963  1.00 40.96           C  
ATOM    756  C   ILE   114      -1.386  54.812  13.695  1.00 41.58           C  
ATOM    757  O   ILE   114      -1.612  54.259  14.774  1.00 42.47           O  
ATOM    758  CB  ILE   114       0.042  53.108  12.411  1.00 40.38           C  
ATOM    759  CG1 ILE   114       1.260  52.984  11.459  1.00 41.25           C  
ATOM    760  CG2 ILE   114      -1.249  52.703  11.686  1.00 39.00           C  
ATOM    761  CD1 ILE   114       1.469  51.610  10.872  1.00 40.00           C  
ATOM    762  N   GLY   115      -2.227  55.688  13.131  1.00 41.83           N  
ATOM    763  CA  GLY   115      -3.554  56.030  13.692  1.00 41.15           C  
ATOM    764  C   GLY   115      -4.538  54.858  13.797  1.00 41.00           C  
ATOM    765  O   GLY   115      -4.438  53.905  13.029  1.00 40.08           O  
ATOM    766  N   PRO   116      -5.480  54.923  14.770  1.00 41.33           N  
ATOM    767  CA  PRO   116      -6.488  53.900  15.110  1.00 41.12           C  
ATOM    768  C   PRO   116      -7.162  53.226  13.897  1.00 41.75           C  
ATOM    769  O   PRO   116      -7.274  51.988  13.861  1.00 40.88           O  
ATOM    770  CB  PRO   116      -7.537  54.687  15.910  1.00 41.97           C  
ATOM    771  CG  PRO   116      -6.830  55.877  16.457  1.00 41.54           C  
ATOM    772  CD  PRO   116      -5.555  56.093  15.673  1.00 41.00           C  
ATOM    773  N   ASP   117      -7.599  54.026  12.918  1.00 41.48           N  
ATOM    774  CA  ASP   117      -8.340  53.487  11.759  1.00 42.14           C  
ATOM    775  C   ASP   117      -7.572  52.469  10.922  1.00 41.56           C  
ATOM    776  O   ASP   117      -8.163  51.581  10.314  1.00 40.67           O  
ATOM    777  CB  ASP   117      -8.893  54.602  10.847  1.00 42.62           C  
ATOM    778  CG  ASP   117      -9.916  55.509  11.548  1.00 44.68           C  
ATOM    779  OD1 ASP   117     -10.339  56.488  10.904  1.00 47.01           O  
ATOM    780  OD2 ASP   117     -10.294  55.273  12.721  1.00 46.41           O  
ATOM    781  N   GLU   118      -6.247  52.616  10.907  1.00 42.25           N  
ATOM    782  CA  GLU   118      -5.363  51.789  10.115  1.00 42.48           C  
ATOM    783  C   GLU   118      -4.801  50.593  10.880  1.00 41.49           C  
ATOM    784  O   GLU   118      -4.125  49.758  10.287  1.00 40.69           O  
ATOM    785  CB  GLU   118      -4.195  52.638   9.616  1.00 43.11           C  
ATOM    786  CG  GLU   118      -4.617  53.969   8.963  1.00 45.99           C  
ATOM    787  CD  GLU   118      -3.407  54.741   8.501  1.00 51.55           C  
ATOM    788  OE1 GLU   118      -2.791  54.297   7.508  1.00 53.87           O  
ATOM    789  OE2 GLU   118      -3.024  55.742   9.151  1.00 51.97           O  
ATOM    790  N   VAL   119      -5.055  50.470  12.180  1.00 40.47           N  
ATOM    791  CA  VAL   119      -4.452  49.289  12.818  1.00 39.77           C  
ATOM    792  C   VAL   119      -4.970  47.927  12.305  1.00 38.62           C  
ATOM    793  O   VAL   119      -4.153  47.050  12.063  1.00 37.65           O  
ATOM    794  CB  VAL   119      -4.130  49.368  14.343  1.00 39.16           C  
ATOM    795  CG1 VAL   119      -3.759  50.786  14.742  1.00 39.45           C  
ATOM    796  CG2 VAL   119      -5.185  48.829  15.167  1.00 41.43           C  
ATOM    797  N   PRO   120      -6.304  47.757  12.134  1.00 38.16           N  
ATOM    798  CA  PRO   120      -6.766  46.493  11.532  1.00 37.43           C  
ATOM    799  C   PRO   120      -6.020  46.047  10.227  1.00 37.74           C  
ATOM    800  O   PRO   120      -5.633  44.876  10.099  1.00 36.09           O  
ATOM    801  CB  PRO   120      -8.245  46.752  11.284  1.00 37.07           C  
ATOM    802  CG  PRO   120      -8.634  47.730  12.397  1.00 38.18           C  
ATOM    803  CD  PRO   120      -7.440  48.628  12.532  1.00 37.57           C  
ATOM    804  N   LEU   121      -5.823  46.977   9.301  1.00 37.13           N  
ATOM    805  CA  LEU   121      -5.069  46.685   8.080  1.00 38.71           C  
ATOM    806  C   LEU   121      -3.622  46.312   8.376  1.00 37.67           C  
ATOM    807  O   LEU   121      -3.110  45.342   7.819  1.00 37.67           O  
ATOM    808  CB  LEU   121      -5.126  47.883   7.139  1.00 38.61           C  
ATOM    809  CG  LEU   121      -4.512  47.752   5.759  1.00 39.30           C  
ATOM    810  CD1 LEU   121      -5.110  46.579   4.936  1.00 35.77           C  
ATOM    811  CD2 LEU   121      -4.764  49.121   5.140  1.00 41.31           C  
ATOM    812  N   ALA   122      -2.980  47.061   9.274  1.00 36.98           N  
ATOM    813  CA  ALA   122      -1.574  46.854   9.582  1.00 36.59           C  
ATOM    814  C   ALA   122      -1.386  45.497  10.265  1.00 37.61           C  
ATOM    815  O   ALA   122      -0.397  44.789  10.033  1.00 36.60           O  
ATOM    816  CB  ALA   122      -1.034  48.017  10.459  1.00 37.41           C  
ATOM    817  N   ILE   123      -2.358  45.125  11.089  1.00 37.52           N  
ATOM    818  CA  ILE   123      -2.385  43.802  11.748  1.00 38.61           C  
ATOM    819  C   ILE   123      -2.406  42.675  10.741  1.00 37.17           C  
ATOM    820  O   ILE   123      -1.649  41.710  10.838  1.00 37.42           O  
ATOM    821  CB  ILE   123      -3.657  43.639  12.672  1.00 39.07           C  
ATOM    822  CG1 ILE   123      -3.511  44.499  13.927  1.00 41.23           C  
ATOM    823  CG2 ILE   123      -3.890  42.180  13.098  1.00 40.52           C  
ATOM    824  CD1 ILE   123      -2.270  44.198  14.646  1.00 45.57           C  
ATOM    825  N   ALA   124      -3.313  42.752   9.795  1.00 36.81           N  
ATOM    826  CA  ALA   124      -3.427  41.659   8.857  1.00 37.23           C  
ATOM    827  C   ALA   124      -2.128  41.553   8.001  1.00 37.64           C  
ATOM    828  O   ALA   124      -1.590  40.452   7.800  1.00 36.63           O  
ATOM    829  CB  ALA   124      -4.654  41.830   7.999  1.00 37.00           C  
ATOM    830  N   ARG   125      -1.607  42.702   7.579  1.00 37.64           N  
ATOM    831  CA  ARG   125      -0.338  42.736   6.830  1.00 38.74           C  
ATOM    832  C   ARG   125       0.839  42.139   7.607  1.00 39.32           C  
ATOM    833  O   ARG   125       1.660  41.394   7.056  1.00 39.10           O  
ATOM    834  CB  ARG   125       0.003  44.157   6.428  1.00 39.12           C  
ATOM    835  CG  ARG   125      -0.760  44.677   5.279  1.00 39.31           C  
ATOM    836  CD  ARG   125      -0.540  46.186   5.178  1.00 42.21           C  
ATOM    837  NE  ARG   125      -1.251  46.747   4.033  1.00 42.02           N  
ATOM    838  CZ  ARG   125      -1.330  48.041   3.735  1.00 44.09           C  
ATOM    839  NH1 ARG   125      -0.787  48.966   4.539  1.00 42.23           N  
ATOM    840  NH2 ARG   125      -1.989  48.402   2.627  1.00 43.74           N  
ATOM    841  N   TYR   126       0.913  42.455   8.901  1.00 38.91           N  
ATOM    842  CA  TYR   126       1.965  41.957   9.741  1.00 38.50           C  
ATOM    843  C   TYR   126       1.883  40.445  10.004  1.00 38.28           C  
ATOM    844  O   TYR   126       2.888  39.738   9.921  1.00 37.03           O  
ATOM    845  CB  TYR   126       1.882  42.701  11.070  1.00 38.18           C  
ATOM    846  CG  TYR   126       3.073  42.563  11.972  1.00 38.12           C  
ATOM    847  CD1 TYR   126       4.130  43.481  11.909  1.00 38.79           C  
ATOM    848  CD2 TYR   126       3.099  41.592  12.959  1.00 38.98           C  
ATOM    849  CE1 TYR   126       5.217  43.383  12.779  1.00 38.36           C  
ATOM    850  CE2 TYR   126       4.154  41.486  13.840  1.00 39.29           C  
ATOM    851  CZ  TYR   126       5.211  42.397  13.757  1.00 39.80           C  
ATOM    852  OH  TYR   126       6.241  42.303  14.671  1.00 40.32           O  
ATOM    853  N   ILE   127       0.680  39.970  10.361  1.00 38.68           N  
ATOM    854  CA  ILE   127       0.370  38.560  10.561  1.00 38.24           C  
ATOM    855  C   ILE   127       0.751  37.693   9.356  1.00 38.71           C  
ATOM    856  O   ILE   127       1.212  36.567   9.513  1.00 37.24           O  
ATOM    857  CB  ILE   127      -1.169  38.356  10.836  1.00 39.14           C  
ATOM    858  CG1 ILE   127      -1.566  38.755  12.282  1.00 39.78           C  
ATOM    859  CG2 ILE   127      -1.614  36.931  10.590  1.00 38.81           C  
ATOM    860  CD1 ILE   127      -0.651  38.299  13.287  1.00 41.39           C  
ATOM    861  N   ALA   128       0.536  38.247   8.170  1.00 38.28           N  
ATOM    862  CA  ALA   128       0.881  37.603   6.892  1.00 39.64           C  
ATOM    863  C   ALA   128       2.362  37.196   6.864  1.00 39.77           C  
ATOM    864  O   ALA   128       2.692  36.160   6.326  1.00 40.73           O  
ATOM    865  CB  ALA   128       0.538  38.544   5.716  1.00 37.72           C  
ATOM    866  N   ARG   129       3.239  37.977   7.501  1.00 39.93           N  
ATOM    867  CA  ARG   129       4.663  37.665   7.535  1.00 40.44           C  
ATOM    868  C   ARG   129       5.092  36.935   8.789  1.00 41.02           C  
ATOM    869  O   ARG   129       6.078  36.186   8.762  1.00 41.36           O  
ATOM    870  CB  ARG   129       5.504  38.953   7.385  1.00 40.36           C  
ATOM    871  CG  ARG   129       5.631  39.460   6.006  1.00 40.68           C  
ATOM    872  CD  ARG   129       6.516  40.731   6.028  1.00 42.98           C  
ATOM    873  NE  ARG   129       7.005  41.042   4.703  1.00 42.54           N  
ATOM    874  CZ  ARG   129       8.005  41.881   4.428  1.00 40.53           C  
ATOM    875  NH1 ARG   129       8.668  42.496   5.400  1.00 35.92           N  
ATOM    876  NH2 ARG   129       8.369  42.072   3.162  1.00 40.85           N  
ATOM    877  N   TYR   130       4.355  37.171   9.879  1.00 40.43           N  
ATOM    878  CA  TYR   130       4.744  36.787  11.237  1.00 40.69           C  
ATOM    879  C   TYR   130       3.545  36.101  11.899  1.00 40.82           C  
ATOM    880  O   TYR   130       2.832  36.721  12.718  1.00 39.21           O  
ATOM    881  CB  TYR   130       5.205  38.026  12.053  1.00 40.55           C  
ATOM    882  CG  TYR   130       6.263  38.783  11.311  1.00 40.43           C  
ATOM    883  CD1 TYR   130       7.511  38.180  11.078  1.00 41.13           C  
ATOM    884  CD2 TYR   130       6.016  40.050  10.782  1.00 36.37           C  
ATOM    885  CE1 TYR   130       8.468  38.794  10.335  1.00 42.15           C  
ATOM    886  CE2 TYR   130       6.996  40.693  10.025  1.00 37.26           C  
ATOM    887  CZ  TYR   130       8.215  40.051   9.809  1.00 39.60           C  
ATOM    888  OH  TYR   130       9.191  40.643   9.072  1.00 41.60           O  
ATOM    889  N   PRO   131       3.306  34.817  11.540  1.00 42.16           N  
ATOM    890  CA  PRO   131       2.096  34.165  12.065  1.00 42.41           C  
ATOM    891  C   PRO   131       2.062  34.024  13.586  1.00 43.43           C  
ATOM    892  O   PRO   131       0.988  33.896  14.156  1.00 43.70           O  
ATOM    893  CB  PRO   131       2.077  32.794  11.349  1.00 42.87           C  
ATOM    894  CG  PRO   131       3.453  32.545  10.957  1.00 42.32           C  
ATOM    895  CD  PRO   131       4.065  33.913  10.654  1.00 41.32           C  
ATOM    896  N   LYS   132       3.210  34.079  14.254  1.00 44.16           N  
ATOM    897  CA  LYS   132       3.206  34.014  15.703  1.00 45.24           C  
ATOM    898  C   LYS   132       2.663  35.298  16.324  1.00 44.82           C  
ATOM    899  O   LYS   132       2.263  35.304  17.487  1.00 43.69           O  
ATOM    900  CB  LYS   132       4.595  33.704  16.260  1.00 45.12           C  
ATOM    901  CG  LYS   132       4.842  32.232  16.432  1.00 47.27           C  
ATOM    902  CD  LYS   132       6.196  31.909  17.119  1.00 48.39           C  
ATOM    903  CE  LYS   132       7.430  32.170  16.226  1.00 52.49           C  
ATOM    904  NZ  LYS   132       7.137  32.521  14.768  1.00 53.17           N  
ATOM    905  N   ALA   133       2.641  36.376  15.540  1.00 44.82           N  
ATOM    906  CA  ALA   133       2.119  37.640  16.033  1.00 45.86           C  
ATOM    907  C   ALA   133       0.639  37.487  16.421  1.00 46.28           C  
ATOM    908  O   ALA   133       0.119  38.284  17.187  1.00 46.88           O  
ATOM    909  CB  ALA   133       2.317  38.750  15.011  1.00 44.40           C  
ATOM    910  N   LYS   134      -0.011  36.451  15.885  1.00 46.67           N  
ATOM    911  CA  LYS   134      -1.416  36.157  16.164  1.00 47.61           C  
ATOM    912  C   LYS   134      -1.651  36.137  17.651  1.00 47.75           C  
ATOM    913  O   LYS   134      -2.757  36.404  18.112  1.00 47.97           O  
ATOM    914  CB  LYS   134      -1.842  34.813  15.552  1.00 47.52           C  
ATOM    915  CG  LYS   134      -1.859  34.804  14.020  1.00 47.47           C  
ATOM    916  CD  LYS   134      -2.287  33.432  13.483  1.00 49.07           C  
ATOM    917  CE  LYS   134      -1.445  32.992  12.281  1.00 51.18           C  
ATOM    918  NZ  LYS   134      -1.843  33.616  10.967  1.00 49.86           N  
ATOM    919  N   LEU   135      -0.579  35.853  18.390  1.00 48.06           N  
ATOM    920  CA  LEU   135      -0.617  35.721  19.826  1.00 47.97           C  
ATOM    921  C   LEU   135      -0.192  37.001  20.519  1.00 47.15           C  
ATOM    922  O   LEU   135      -0.969  37.551  21.300  1.00 46.82           O  
ATOM    923  CB  LEU   135       0.261  34.537  20.278  1.00 48.70           C  
ATOM    924  CG  LEU   135       0.035  33.874  21.647  1.00 50.11           C  
ATOM    925  CD1 LEU   135       0.774  34.634  22.791  1.00 50.84           C  
ATOM    926  CD2 LEU   135      -1.474  33.663  21.956  1.00 50.85           C  
ATOM    927  N   TYR   136       1.031  37.462  20.260  1.00 46.11           N  
ATOM    928  CA  TYR   136       1.581  38.606  21.013  1.00 45.99           C  
ATOM    929  C   TYR   136       1.034  39.993  20.657  1.00 46.23           C  
ATOM    930  O   TYR   136       1.253  40.941  21.400  1.00 47.04           O  
ATOM    931  CB  TYR   136       3.109  38.615  21.041  1.00 45.39           C  
ATOM    932  CG  TYR   136       3.790  38.700  19.693  1.00 46.29           C  
ATOM    933  CD1 TYR   136       3.885  39.920  19.003  1.00 46.59           C  
ATOM    934  CD2 TYR   136       4.382  37.560  19.114  1.00 47.90           C  
ATOM    935  CE1 TYR   136       4.510  40.011  17.768  1.00 45.30           C  
ATOM    936  CE2 TYR   136       5.021  37.640  17.878  1.00 45.08           C  
ATOM    937  CZ  TYR   136       5.087  38.863  17.214  1.00 45.87           C  
ATOM    938  OH  TYR   136       5.715  38.938  15.992  1.00 41.33           O  
ATOM    939  N   LEU   137       0.359  40.122  19.511  1.00 46.65           N  
ATOM    940  CA  LEU   137      -0.418  41.332  19.204  1.00 46.13           C  
ATOM    941  C   LEU   137      -1.735  41.311  20.000  1.00 46.60           C  
ATOM    942  O   LEU   137      -2.290  42.359  20.306  1.00 46.98           O  
ATOM    943  CB  LEU   137      -0.713  41.459  17.704  1.00 45.65           C  
ATOM    944  CG  LEU   137       0.437  41.531  16.695  1.00 44.77           C  
ATOM    945  CD1 LEU   137      -0.089  41.595  15.239  1.00 43.62           C  
ATOM    946  CD2 LEU   137       1.283  42.731  17.005  1.00 44.94           C  
ATOM    947  N   SER   138      -2.232  40.115  20.331  1.00 46.62           N  
ATOM    948  CA  SER   138      -3.452  39.978  21.138  1.00 46.51           C  
ATOM    949  C   SER   138      -3.169  40.269  22.616  1.00 46.44           C  
ATOM    950  O   SER   138      -4.035  40.077  23.474  1.00 45.70           O  
ATOM    951  CB  SER   138      -4.083  38.578  20.979  1.00 46.73           C  
ATOM    952  OG  SER   138      -4.835  38.461  19.779  1.00 45.66           O  
ATOM    953  N   LEU   139      -1.955  40.729  22.906  1.00 46.67           N  
ATOM    954  CA  LEU   139      -1.587  41.082  24.277  1.00 47.11           C  
ATOM    955  C   LEU   139      -1.803  42.577  24.520  1.00 47.01           C  
ATOM    956  O   LEU   139      -1.718  43.355  23.579  1.00 47.26           O  
ATOM    957  CB  LEU   139      -0.132  40.673  24.561  1.00 47.38           C  
ATOM    958  CG  LEU   139       0.075  39.157  24.775  1.00 48.22           C  
ATOM    959  CD1 LEU   139       1.557  38.734  24.649  1.00 48.29           C  
ATOM    960  CD2 LEU   139      -0.538  38.697  26.101  1.00 46.80           C  
ATOM    961  N   PRO   140      -2.098  42.982  25.772  1.00 46.85           N  
ATOM    962  CA  PRO   140      -2.243  44.405  26.123  1.00 47.11           C  
ATOM    963  C   PRO   140      -1.185  45.383  25.554  1.00 46.98           C  
ATOM    964  O   PRO   140      -0.054  44.997  25.304  1.00 46.95           O  
ATOM    965  CB  PRO   140      -2.208  44.384  27.670  1.00 47.08           C  
ATOM    966  CG  PRO   140      -2.900  43.086  27.999  1.00 46.63           C  
ATOM    967  CD  PRO   140      -2.367  42.116  26.942  1.00 47.39           C  
ATOM    968  N   ASP   141      -1.623  46.629  25.332  1.00 47.12           N  
ATOM    969  CA  ASP   141      -0.824  47.794  24.899  1.00 46.88           C  
ATOM    970  C   ASP   141       0.037  47.641  23.642  1.00 45.67           C  
ATOM    971  O   ASP   141       1.088  48.244  23.545  1.00 45.12           O  
ATOM    972  CB  ASP   141      -0.028  48.431  26.058  1.00 47.97           C  
ATOM    973  CG  ASP   141       0.312  49.933  25.794  1.00 51.71           C  
ATOM    974  OD1 ASP   141       0.123  50.416  24.640  1.00 56.09           O  
ATOM    975  OD2 ASP   141       0.765  50.642  26.726  1.00 53.23           O  
ATOM    976  N   THR   142      -0.433  46.872  22.665  1.00 45.38           N  
ATOM    977  CA  THR   142       0.298  46.738  21.399  1.00 44.64           C  
ATOM    978  C   THR   142       0.354  48.133  20.750  1.00 43.67           C  
ATOM    979  O   THR   142      -0.661  48.835  20.706  1.00 42.32           O  
ATOM    980  CB  THR   142      -0.322  45.645  20.432  1.00 45.28           C  
ATOM    981  OG1 THR   142      -1.500  46.129  19.764  1.00 50.55           O  
ATOM    982  CG2 THR   142      -0.691  44.384  21.154  1.00 43.67           C  
ATOM    983  N   ARG   143       1.543  48.544  20.302  1.00 42.84           N  
ATOM    984  CA  ARG   143       1.752  49.844  19.613  1.00 41.55           C  
ATOM    985  C   ARG   143       2.296  49.644  18.197  1.00 41.15           C  
ATOM    986  O   ARG   143       3.172  48.825  17.972  1.00 39.56           O  
ATOM    987  CB  ARG   143       2.693  50.754  20.397  1.00 41.33           C  
ATOM    988  CG  ARG   143       2.105  51.238  21.716  1.00 42.76           C  
ATOM    989  CD  ARG   143       2.837  52.418  22.285  1.00 41.74           C  
ATOM    990  NE  ARG   143       2.324  52.678  23.626  1.00 43.71           N  
ATOM    991  CZ  ARG   143       2.963  53.384  24.552  1.00 44.78           C  
ATOM    992  NH1 ARG   143       4.143  53.932  24.282  1.00 44.95           N  
ATOM    993  NH2 ARG   143       2.417  53.540  25.749  1.00 44.32           N  
ATOM    994  N   LEU   144       1.784  50.424  17.263  1.00 40.42           N  
ATOM    995  CA  LEU   144       2.074  50.247  15.850  1.00 40.95           C  
ATOM    996  C   LEU   144       2.702  51.530  15.277  1.00 40.06           C  
ATOM    997  O   LEU   144       2.163  52.615  15.462  1.00 38.91           O  
ATOM    998  CB  LEU   144       0.751  49.987  15.181  1.00 42.20           C  
ATOM    999  CG  LEU   144       0.619  49.097  13.969  1.00 46.50           C  
ATOM   1000  CD1 LEU   144       1.875  48.287  13.671  1.00 49.12           C  
ATOM   1001  CD2 LEU   144      -0.608  48.216  14.255  1.00 48.62           C  
ATOM   1002  N   TYR   145       3.817  51.406  14.564  1.00 39.79           N  
ATOM   1003  CA  TYR   145       4.558  52.599  14.078  1.00 40.16           C  
ATOM   1004  C   TYR   145       4.959  52.432  12.632  1.00 40.01           C  
ATOM   1005  O   TYR   145       5.267  51.349  12.243  1.00 39.76           O  
ATOM   1006  CB  TYR   145       5.867  52.724  14.824  1.00 39.53           C  
ATOM   1007  CG  TYR   145       5.781  52.715  16.319  1.00 40.63           C  
ATOM   1008  CD1 TYR   145       5.830  53.908  17.048  1.00 39.84           C  
ATOM   1009  CD2 TYR   145       5.749  51.505  17.013  1.00 40.60           C  
ATOM   1010  CE1 TYR   145       5.801  53.895  18.451  1.00 40.06           C  
ATOM   1011  CE2 TYR   145       5.697  51.480  18.355  1.00 39.43           C  
ATOM   1012  CZ  TYR   145       5.730  52.671  19.081  1.00 39.67           C  
ATOM   1013  OH  TYR   145       5.702  52.587  20.428  1.00 42.40           O  
ATOM   1014  N   ARG   146       5.015  53.506  11.843  1.00 39.59           N  
ATOM   1015  CA  ARG   146       5.738  53.386  10.573  1.00 39.78           C  
ATOM   1016  C   ARG   146       6.938  54.325  10.546  1.00 39.11           C  
ATOM   1017  O   ARG   146       6.964  55.378  11.224  1.00 39.10           O  
ATOM   1018  CB  ARG   146       4.811  53.511   9.324  1.00 40.31           C  
ATOM   1019  CG  ARG   146       4.060  54.788   9.265  1.00 39.82           C  
ATOM   1020  CD  ARG   146       3.345  55.018   7.916  1.00 38.92           C  
ATOM   1021  NE  ARG   146       2.211  54.139   7.701  1.00 37.29           N  
ATOM   1022  CZ  ARG   146       0.949  54.414   8.052  1.00 39.59           C  
ATOM   1023  NH1 ARG   146       0.620  55.547   8.670  1.00 36.29           N  
ATOM   1024  NH2 ARG   146       0.002  53.529   7.806  1.00 38.02           N  
ATOM   1025  N   LEU   147       7.953  53.898   9.812  1.00 38.46           N  
ATOM   1026  CA  LEU   147       9.159  54.674   9.672  1.00 39.22           C  
ATOM   1027  C   LEU   147       8.892  55.779   8.668  1.00 39.28           C  
ATOM   1028  O   LEU   147       8.458  55.507   7.541  1.00 40.23           O  
ATOM   1029  CB  LEU   147      10.337  53.786   9.223  1.00 38.32           C  
ATOM   1030  CG  LEU   147      11.633  54.552   8.934  1.00 40.43           C  
ATOM   1031  CD1 LEU   147      12.162  55.301  10.146  1.00 40.13           C  
ATOM   1032  CD2 LEU   147      12.676  53.585   8.383  1.00 39.88           C  
ATOM   1033  N   ARG   148       9.128  57.019   9.093  1.00 38.60           N  
ATOM   1034  CA  ARG   148       9.226  58.123   8.164  1.00 38.77           C  
ATOM   1035  C   ARG   148      10.701  58.279   7.820  1.00 38.33           C  
ATOM   1036  O   ARG   148      11.459  58.805   8.619  1.00 38.32           O  
ATOM   1037  CB  ARG   148       8.725  59.410   8.813  1.00 38.13           C  
ATOM   1038  CG  ARG   148       8.409  60.481   7.803  1.00 37.78           C  
ATOM   1039  CD  ARG   148       8.179  61.861   8.399  1.00 38.22           C  
ATOM   1040  NE  ARG   148       7.600  61.872   9.745  1.00 37.75           N  
ATOM   1041  CZ  ARG   148       7.628  62.927  10.557  1.00 37.04           C  
ATOM   1042  NH1 ARG   148       8.198  64.048  10.163  1.00 39.09           N  
ATOM   1043  NH2 ARG   148       7.088  62.877  11.769  1.00 37.72           N  
ATOM   1044  N   THR   149      11.112  57.813   6.646  1.00 38.59           N  
ATOM   1045  CA  THR   149      12.545  57.748   6.309  1.00 37.96           C  
ATOM   1046  C   THR   149      13.029  59.141   5.922  1.00 38.33           C  
ATOM   1047  O   THR   149      12.405  59.803   5.065  1.00 36.50           O  
ATOM   1048  CB  THR   149      12.806  56.757   5.154  1.00 38.31           C  
ATOM   1049  OG1 THR   149      12.509  55.419   5.604  1.00 41.10           O  
ATOM   1050  CG2 THR   149      14.270  56.801   4.713  1.00 35.97           C  
ATOM   1051  N   GLU   150      14.136  59.582   6.538  1.00 37.61           N  
ATOM   1052  CA  GLU   150      14.712  60.870   6.226  1.00 37.27           C  
ATOM   1053  C   GLU   150      16.117  60.754   5.641  1.00 36.61           C  
ATOM   1054  O   GLU   150      16.620  61.694   5.038  1.00 35.99           O  
ATOM   1055  CB  GLU   150      14.728  61.781   7.469  1.00 37.85           C  
ATOM   1056  CG  GLU   150      13.363  62.026   8.039  1.00 40.67           C  
ATOM   1057  CD  GLU   150      13.392  62.918   9.236  1.00 43.99           C  
ATOM   1058  OE1 GLU   150      13.697  62.446  10.343  1.00 45.92           O  
ATOM   1059  OE2 GLU   150      13.083  64.103   9.075  1.00 47.26           O  
ATOM   1060  N   GLY   151      16.754  59.605   5.811  1.00 36.37           N  
ATOM   1061  CA  GLY   151      18.106  59.438   5.304  1.00 35.42           C  
ATOM   1062  C   GLY   151      18.391  57.979   5.175  1.00 36.25           C  
ATOM   1063  O   GLY   151      17.818  57.157   5.916  1.00 36.80           O  
ATOM   1064  N   VAL   152      19.238  57.639   4.215  1.00 36.10           N  
ATOM   1065  CA  VAL   152      19.430  56.227   3.805  1.00 35.33           C  
ATOM   1066  C   VAL   152      20.918  55.988   3.648  1.00 35.97           C  
ATOM   1067  O   VAL   152      21.619  56.816   3.048  1.00 35.63           O  
ATOM   1068  CB  VAL   152      18.795  55.952   2.411  1.00 34.93           C  
ATOM   1069  CG1 VAL   152      19.039  54.483   1.920  1.00 32.95           C  
ATOM   1070  CG2 VAL   152      17.350  56.272   2.423  1.00 35.09           C  
ATOM   1071  N   GLN   153      21.393  54.850   4.145  1.00 36.44           N  
ATOM   1072  CA  GLN   153      22.734  54.355   3.769  1.00 37.39           C  
ATOM   1073  C   GLN   153      22.655  52.879   3.356  1.00 36.80           C  
ATOM   1074  O   GLN   153      22.052  52.100   4.058  1.00 36.40           O  
ATOM   1075  CB  GLN   153      23.665  54.515   4.963  1.00 37.50           C  
ATOM   1076  CG  GLN   153      25.127  54.524   4.640  1.00 41.65           C  
ATOM   1077  CD  GLN   153      25.556  55.736   3.810  1.00 41.98           C  
ATOM   1078  OE1 GLN   153      24.964  56.831   3.864  1.00 45.79           O  
ATOM   1079  NE2 GLN   153      26.583  55.533   3.041  1.00 42.54           N  
ATOM   1080  N   ILE   154      23.241  52.503   2.226  1.00 37.17           N  
ATOM   1081  CA  ILE   154      23.331  51.090   1.860  1.00 39.21           C  
ATOM   1082  C   ILE   154      24.785  50.640   1.815  1.00 41.79           C  
ATOM   1083  O   ILE   154      25.679  51.367   1.372  1.00 41.41           O  
ATOM   1084  CB  ILE   154      22.601  50.741   0.538  1.00 38.42           C  
ATOM   1085  CG1 ILE   154      22.646  49.226   0.255  1.00 38.22           C  
ATOM   1086  CG2 ILE   154      23.205  51.475  -0.643  1.00 38.65           C  
ATOM   1087  CD1 ILE   154      21.854  48.347   1.229  1.00 39.83           C  
ATOM   1088  N   ASN   155      25.004  49.399   2.225  1.00 44.68           N  
ATOM   1089  CA  ASN   155      26.328  48.960   2.615  1.00 46.88           C  
ATOM   1090  C   ASN   155      26.582  47.483   2.353  1.00 47.70           C  
ATOM   1091  O   ASN   155      25.686  46.663   2.509  1.00 46.80           O  
ATOM   1092  CB  ASN   155      26.426  49.207   4.104  1.00 47.14           C  
ATOM   1093  CG  ASN   155      27.647  49.882   4.462  1.00 50.04           C  
ATOM   1094  OD1 ASN   155      28.705  49.253   4.585  1.00 55.54           O  
ATOM   1095  ND2 ASN   155      27.558  51.195   4.622  1.00 52.46           N  
ATOM   1096  N   GLY   156      27.811  47.151   1.959  1.00 49.84           N  
ATOM   1097  CA  GLY   156      28.226  45.753   1.770  1.00 51.52           C  
ATOM   1098  C   GLY   156      27.617  45.115   0.522  1.00 52.58           C  
ATOM   1099  O   GLY   156      27.855  43.933   0.213  1.00 53.20           O  
ATOM   1100  N   SER   163      26.464  54.270  -1.177  1.00 60.56           N  
ATOM   1101  CA  SER   163      26.432  55.140  -2.358  1.00 60.69           C  
ATOM   1102  C   SER   163      25.807  56.505  -2.030  1.00 60.30           C  
ATOM   1103  O   SER   163      25.996  57.018  -0.913  1.00 60.50           O  
ATOM   1104  CB  SER   163      25.691  54.453  -3.512  1.00 60.82           C  
ATOM   1105  N   ASN   164      25.077  57.098  -2.983  1.00 59.18           N  
ATOM   1106  CA  ASN   164      24.316  58.305  -2.663  1.00 57.87           C  
ATOM   1107  C   ASN   164      22.811  58.245  -2.973  1.00 56.64           C  
ATOM   1108  O   ASN   164      22.310  58.927  -3.882  1.00 56.74           O  
ATOM   1109  CB  ASN   164      24.991  59.557  -3.217  1.00 58.18           C  
ATOM   1110  CG  ASN   164      25.093  60.662  -2.170  1.00 59.61           C  
ATOM   1111  OD1 ASN   164      24.452  60.581  -1.102  1.00 61.55           O  
ATOM   1112  ND2 ASN   164      25.898  61.696  -2.459  1.00 58.37           N  
ATOM   1113  N   ILE   165      22.119  57.431  -2.171  1.00 54.60           N  
ATOM   1114  CA  ILE   165      20.681  57.144  -2.264  1.00 52.78           C  
ATOM   1115  C   ILE   165      19.834  58.029  -1.349  1.00 51.56           C  
ATOM   1116  O   ILE   165      20.213  58.327  -0.218  1.00 51.45           O  
ATOM   1117  CB  ILE   165      20.383  55.679  -1.835  1.00 52.71           C  
ATOM   1118  CG1 ILE   165      21.223  54.685  -2.617  1.00 52.48           C  
ATOM   1119  CG2 ILE   165      18.870  55.346  -1.944  1.00 52.17           C  
ATOM   1120  CD1 ILE   165      21.075  53.276  -2.069  1.00 53.76           C  
ATOM   1121  N   THR   166      18.659  58.387  -1.850  1.00 49.82           N  
ATOM   1122  CA  THR   166      17.685  59.221  -1.167  1.00 47.99           C  
ATOM   1123  C   THR   166      16.460  58.402  -0.707  1.00 46.53           C  
ATOM   1124  O   THR   166      16.163  57.365  -1.305  1.00 45.87           O  
ATOM   1125  CB  THR   166      17.195  60.292  -2.160  1.00 48.47           C  
ATOM   1126  OG1 THR   166      16.247  61.157  -1.526  1.00 50.18           O  
ATOM   1127  CG2 THR   166      16.526  59.641  -3.353  1.00 47.03           C  
ATOM   1128  N   PRO   167      15.736  58.879   0.335  1.00 44.87           N  
ATOM   1129  CA  PRO   167      14.458  58.290   0.720  1.00 43.50           C  
ATOM   1130  C   PRO   167      13.494  58.042  -0.451  1.00 42.73           C  
ATOM   1131  O   PRO   167      12.872  56.980  -0.511  1.00 41.20           O  
ATOM   1132  CB  PRO   167      13.899  59.320   1.701  1.00 43.49           C  
ATOM   1133  CG  PRO   167      15.121  59.813   2.394  1.00 43.85           C  
ATOM   1134  CD  PRO   167      16.106  59.979   1.255  1.00 44.61           C  
ATOM   1135  N   ALA   168      13.394  59.003  -1.376  1.00 41.20           N  
ATOM   1136  CA  ALA   168      12.558  58.884  -2.575  1.00 40.36           C  
ATOM   1137  C   ALA   168      12.945  57.702  -3.447  1.00 40.15           C  
ATOM   1138  O   ALA   168      12.078  57.091  -4.074  1.00 39.71           O  
ATOM   1139  CB  ALA   168      12.623  60.191  -3.420  1.00 39.95           C  
ATOM   1140  N   ASP   169      14.248  57.401  -3.501  1.00 40.01           N  
ATOM   1141  CA  ASP   169      14.760  56.285  -4.307  1.00 40.40           C  
ATOM   1142  C   ASP   169      14.215  54.952  -3.813  1.00 39.36           C  
ATOM   1143  O   ASP   169      14.077  54.007  -4.570  1.00 38.74           O  
ATOM   1144  CB  ASP   169      16.286  56.201  -4.240  1.00 40.55           C  
ATOM   1145  CG  ASP   169      16.984  57.170  -5.175  1.00 44.16           C  
ATOM   1146  OD1 ASP   169      16.370  57.686  -6.141  1.00 46.62           O  
ATOM   1147  OD2 ASP   169      18.177  57.426  -4.917  1.00 46.46           O  
ATOM   1148  N   LEU   170      13.938  54.869  -2.520  1.00 39.88           N  
ATOM   1149  CA  LEU   170      13.470  53.617  -1.971  1.00 40.30           C  
ATOM   1150  C   LEU   170      11.977  53.420  -2.130  1.00 41.43           C  
ATOM   1151  O   LEU   170      11.506  52.272  -2.117  1.00 43.10           O  
ATOM   1152  CB  LEU   170      13.843  53.477  -0.496  1.00 39.86           C  
ATOM   1153  CG  LEU   170      15.310  53.540  -0.134  1.00 41.26           C  
ATOM   1154  CD1 LEU   170      15.403  53.049   1.308  1.00 38.50           C  
ATOM   1155  CD2 LEU   170      16.132  52.668  -1.055  1.00 41.75           C  
ATOM   1156  N   ARG   171      11.220  54.508  -2.225  1.00 41.64           N  
ATOM   1157  CA  ARG   171       9.757  54.400  -2.276  1.00 42.86           C  
ATOM   1158  C   ARG   171       9.224  53.862  -3.570  1.00 41.94           C  
ATOM   1159  O   ARG   171       9.793  54.126  -4.624  1.00 42.66           O  
ATOM   1160  CB  ARG   171       9.090  55.745  -2.037  1.00 44.35           C  
ATOM   1161  CG  ARG   171       8.629  55.926  -0.589  1.00 48.08           C  
ATOM   1162  CD  ARG   171       7.734  57.174  -0.489  1.00 55.26           C  
ATOM   1163  NE  ARG   171       8.159  58.232  -1.413  1.00 59.23           N  
ATOM   1164  CZ  ARG   171       9.087  59.155  -1.153  1.00 60.97           C  
ATOM   1165  NH1 ARG   171       9.718  59.190   0.027  1.00 59.89           N  
ATOM   1166  NH2 ARG   171       9.385  60.056  -2.088  1.00 61.23           N  
ATOM   1167  N   THR   172       8.104  53.136  -3.502  1.00 39.89           N  
ATOM   1168  CA  THR   172       7.400  52.778  -4.733  1.00 37.54           C  
ATOM   1169  C   THR   172       6.310  53.770  -5.091  1.00 36.45           C  
ATOM   1170  O   THR   172       5.388  53.982  -4.324  1.00 35.85           O  
ATOM   1171  CB  THR   172       6.777  51.374  -4.624  1.00 37.27           C  
ATOM   1172  OG1 THR   172       7.811  50.456  -4.280  1.00 36.73           O  
ATOM   1173  CG2 THR   172       6.129  50.979  -5.942  1.00 37.43           C  
ATOM   1174  N   ASP   173       6.386  54.342  -6.290  1.00 35.89           N  
ATOM   1175  CA  ASP   173       5.430  55.349  -6.699  1.00 35.73           C  
ATOM   1176  C   ASP   173       4.100  54.712  -7.127  1.00 35.45           C  
ATOM   1177  O   ASP   173       4.050  53.928  -8.081  1.00 34.18           O  
ATOM   1178  CB  ASP   173       6.040  56.182  -7.820  1.00 36.16           C  
ATOM   1179  CG  ASP   173       5.205  57.399  -8.183  1.00 37.67           C  
ATOM   1180  OD1 ASP   173       4.108  57.608  -7.606  1.00 38.56           O  
ATOM   1181  OD2 ASP   173       5.674  58.164  -9.053  1.00 40.65           O  
ATOM   1182  N   LEU   174       3.020  55.082  -6.432  1.00 35.60           N  
ATOM   1183  CA  LEU   174       1.699  54.491  -6.690  1.00 36.94           C  
ATOM   1184  C   LEU   174       0.820  55.341  -7.622  1.00 37.73           C  
ATOM   1185  O   LEU   174      -0.223  54.871  -8.064  1.00 38.70           O  
ATOM   1186  CB  LEU   174       0.955  54.137  -5.392  1.00 35.87           C  
ATOM   1187  CG  LEU   174       1.652  53.225  -4.335  1.00 37.10           C  
ATOM   1188  CD1 LEU   174       0.739  52.947  -3.138  1.00 42.05           C  
ATOM   1189  CD2 LEU   174       2.199  51.941  -4.887  1.00 34.58           C  
ATOM   1190  N   SER   175       1.250  56.578  -7.903  1.00 39.29           N  
ATOM   1191  CA  SER   175       0.577  57.509  -8.835  1.00 39.41           C  
ATOM   1192  C   SER   175       0.497  56.903 -10.201  1.00 38.81           C  
ATOM   1193  O   SER   175       1.480  56.338 -10.665  1.00 39.39           O  
ATOM   1194  CB  SER   175       1.393  58.781  -8.985  1.00 40.30           C  
ATOM   1195  OG  SER   175       1.749  59.250  -7.720  1.00 44.26           O  
ATOM   1196  N   GLY   176      -0.657  57.005 -10.851  1.00 38.00           N  
ATOM   1197  CA  GLY   176      -0.818  56.431 -12.193  1.00 36.90           C  
ATOM   1198  C   GLY   176      -1.274  54.983 -12.166  1.00 36.94           C  
ATOM   1199  O   GLY   176      -1.785  54.486 -13.161  1.00 36.75           O  
ATOM   1200  N   ALA   177      -1.121  54.326 -11.017  1.00 35.74           N  
ATOM   1201  CA  ALA   177      -1.447  52.891 -10.828  1.00 36.90           C  
ATOM   1202  C   ALA   177      -2.671  52.600  -9.946  1.00 37.11           C  
ATOM   1203  O   ALA   177      -2.825  51.471  -9.488  1.00 35.89           O  
ATOM   1204  CB  ALA   177      -0.241  52.139 -10.254  1.00 34.41           C  
ATOM   1205  N   GLU   178      -3.561  53.581  -9.759  1.00 38.00           N  
ATOM   1206  CA  GLU   178      -4.748  53.361  -8.912  1.00 39.26           C  
ATOM   1207  C   GLU   178      -5.582  52.148  -9.317  1.00 39.46           C  
ATOM   1208  O   GLU   178      -6.096  51.457  -8.448  1.00 39.25           O  
ATOM   1209  CB  GLU   178      -5.639  54.605  -8.793  1.00 40.40           C  
ATOM   1210  CG  GLU   178      -5.522  55.617  -9.915  1.00 43.04           C  
ATOM   1211  CD  GLU   178      -4.197  56.362  -9.892  1.00 44.81           C  
ATOM   1212  OE1 GLU   178      -3.412  56.160 -10.831  1.00 45.64           O  
ATOM   1213  OE2 GLU   178      -3.929  57.129  -8.943  1.00 47.96           O  
ATOM   1214  N   GLU   179      -5.709  51.882 -10.626  1.00 39.61           N  
ATOM   1215  CA  GLU   179      -6.423  50.683 -11.098  1.00 40.08           C  
ATOM   1216  C   GLU   179      -5.830  49.369 -10.565  1.00 39.89           C  
ATOM   1217  O   GLU   179      -6.570  48.512 -10.047  1.00 40.80           O  
ATOM   1218  CB  GLU   179      -6.540  50.655 -12.636  1.00 40.11           C  
ATOM   1219  CG  GLU   179      -6.507  49.214 -13.179  1.00 43.47           C  
ATOM   1220  CD  GLU   179      -7.351  48.973 -14.415  1.00 46.41           C  
ATOM   1221  OE1 GLU   179      -7.880  49.960 -14.980  1.00 50.62           O  
ATOM   1222  OE2 GLU   179      -7.486  47.788 -14.810  1.00 46.82           O  
ATOM   1223  N   LEU   180      -4.510  49.194 -10.691  1.00 39.48           N  
ATOM   1224  CA  LEU   180      -3.811  48.025 -10.098  1.00 39.31           C  
ATOM   1225  C   LEU   180      -4.002  47.941  -8.583  1.00 39.44           C  
ATOM   1226  O   LEU   180      -4.246  46.872  -8.015  1.00 38.38           O  
ATOM   1227  CB  LEU   180      -2.304  48.141 -10.358  1.00 39.30           C  
ATOM   1228  CG  LEU   180      -1.441  47.036  -9.750  1.00 38.15           C  
ATOM   1229  CD1 LEU   180      -1.658  45.717 -10.486  1.00 33.34           C  
ATOM   1230  CD2 LEU   180       0.046  47.422  -9.780  1.00 40.22           C  
ATOM   1231  N   MET   181      -3.847  49.086  -7.932  1.00 38.84           N  
ATOM   1232  CA  MET   181      -3.893  49.139  -6.471  1.00 39.22           C  
ATOM   1233  C   MET   181      -5.316  48.856  -5.978  1.00 39.12           C  
ATOM   1234  O   MET   181      -5.490  48.219  -4.945  1.00 38.93           O  
ATOM   1235  CB  MET   181      -3.352  50.496  -5.973  1.00 39.28           C  
ATOM   1236  CG  MET   181      -1.848  50.761  -6.347  1.00 39.80           C  
ATOM   1237  SD  MET   181      -0.644  49.150  -6.207  0.80 50.03          SE  
ATOM   1238  CE  MET   181      -0.749  48.741  -4.304  1.00 43.54           C  
ATOM   1239  N   ALA   182      -6.324  49.314  -6.730  1.00 38.66           N  
ATOM   1240  CA  ALA   182      -7.714  48.950  -6.445  1.00 38.95           C  
ATOM   1241  C   ALA   182      -7.947  47.426  -6.575  1.00 39.20           C  
ATOM   1242  O   ALA   182      -8.852  46.885  -5.948  1.00 39.76           O  
ATOM   1243  CB  ALA   182      -8.685  49.737  -7.336  1.00 38.72           C  
ATOM   1244  N   ALA   183      -7.113  46.736  -7.337  1.00 39.12           N  
ATOM   1245  CA  ALA   183      -7.270  45.262  -7.542  1.00 39.14           C  
ATOM   1246  C   ALA   183      -6.224  44.408  -6.838  1.00 39.39           C  
ATOM   1247  O   ALA   183      -6.325  43.165  -6.826  1.00 38.95           O  
ATOM   1248  CB  ALA   183      -7.291  44.929  -9.019  1.00 38.99           C  
ATOM   1249  N   ALA   184      -5.240  45.051  -6.210  1.00 39.22           N  
ATOM   1250  CA  ALA   184      -4.066  44.328  -5.747  1.00 38.88           C  
ATOM   1251  C   ALA   184      -4.423  43.297  -4.675  1.00 40.07           C  
ATOM   1252  O   ALA   184      -3.806  42.227  -4.618  1.00 38.32           O  
ATOM   1253  CB  ALA   184      -3.035  45.275  -5.244  1.00 39.29           C  
ATOM   1254  N   GLU   185      -5.384  43.627  -3.809  1.00 40.14           N  
ATOM   1255  CA  GLU   185      -5.765  42.693  -2.732  1.00 42.11           C  
ATOM   1256  C   GLU   185      -6.500  41.436  -3.275  1.00 41.53           C  
ATOM   1257  O   GLU   185      -6.199  40.301  -2.894  1.00 39.45           O  
ATOM   1258  CB  GLU   185      -6.582  43.433  -1.678  1.00 43.22           C  
ATOM   1259  CG  GLU   185      -6.269  43.043  -0.223  1.00 50.16           C  
ATOM   1260  CD  GLU   185      -4.758  43.002   0.076  1.00 57.11           C  
ATOM   1261  OE1 GLU   185      -4.074  44.003  -0.245  1.00 60.08           O  
ATOM   1262  OE2 GLU   185      -4.260  41.967   0.605  1.00 60.58           O  
ATOM   1263  N   SER   186      -7.432  41.647  -4.199  1.00 41.32           N  
ATOM   1264  CA  SER   186      -8.175  40.535  -4.777  1.00 42.46           C  
ATOM   1265  C   SER   186      -7.328  39.745  -5.782  1.00 42.08           C  
ATOM   1266  O   SER   186      -7.512  38.536  -5.919  1.00 41.71           O  
ATOM   1267  CB  SER   186      -9.474  41.018  -5.415  1.00 42.62           C  
ATOM   1268  OG  SER   186      -9.174  41.911  -6.461  1.00 44.62           O  
ATOM   1269  N   GLU   187      -6.398  40.404  -6.467  1.00 41.08           N  
ATOM   1270  CA  GLU   187      -5.419  39.646  -7.263  1.00 40.35           C  
ATOM   1271  C   GLU   187      -4.514  38.748  -6.418  1.00 39.77           C  
ATOM   1272  O   GLU   187      -4.302  37.599  -6.783  1.00 38.95           O  
ATOM   1273  CB  GLU   187      -4.589  40.552  -8.164  1.00 41.17           C  
ATOM   1274  CG  GLU   187      -5.388  41.079  -9.337  1.00 42.00           C  
ATOM   1275  CD  GLU   187      -5.830  39.962 -10.258  1.00 47.88           C  
ATOM   1276  OE1 GLU   187      -5.005  39.505 -11.069  1.00 47.76           O  
ATOM   1277  OE2 GLU   187      -6.990  39.526 -10.166  1.00 47.91           O  
ATOM   1278  N   ALA   188      -4.021  39.248  -5.275  1.00 39.62           N  
ATOM   1279  CA  ALA   188      -3.208  38.428  -4.354  1.00 39.36           C  
ATOM   1280  C   ALA   188      -3.986  37.181  -3.925  1.00 39.81           C  
ATOM   1281  O   ALA   188      -3.456  36.069  -3.961  1.00 39.51           O  
ATOM   1282  CB  ALA   188      -2.779  39.257  -3.093  1.00 38.66           C  
ATOM   1283  N   THR   189      -5.235  37.384  -3.502  1.00 38.54           N  
ATOM   1284  CA  THR   189      -6.118  36.310  -3.087  1.00 39.26           C  
ATOM   1285  C   THR   189      -6.334  35.303  -4.210  1.00 39.11           C  
ATOM   1286  O   THR   189      -6.262  34.090  -3.988  1.00 37.88           O  
ATOM   1287  CB  THR   189      -7.494  36.855  -2.631  1.00 39.24           C  
ATOM   1288  OG1 THR   189      -7.288  37.830  -1.619  1.00 40.65           O  
ATOM   1289  CG2 THR   189      -8.378  35.765  -2.068  1.00 40.14           C  
ATOM   1290  N   ARG   190      -6.581  35.820  -5.393  1.00 39.23           N  
ATOM   1291  CA  ARG   190      -6.801  35.025  -6.570  1.00 40.56           C  
ATOM   1292  C   ARG   190      -5.633  34.123  -6.835  1.00 40.07           C  
ATOM   1293  O   ARG   190      -5.788  32.956  -6.975  1.00 40.14           O  
ATOM   1294  CB  ARG   190      -6.993  35.918  -7.779  1.00 41.29           C  
ATOM   1295  CG  ARG   190      -8.079  35.488  -8.702  1.00 44.05           C  
ATOM   1296  CD  ARG   190      -7.768  35.575 -10.156  1.00 46.79           C  
ATOM   1297  NE  ARG   190      -6.739  36.506 -10.516  1.00 51.37           N  
ATOM   1298  CZ  ARG   190      -5.737  36.223 -11.314  1.00 47.62           C  
ATOM   1299  NH1 ARG   190      -5.642  35.058 -11.853  1.00 49.34           N  
ATOM   1300  NH2 ARG   190      -4.843  37.121 -11.564  1.00 47.10           N  
ATOM   1301  N   LEU   191      -4.467  34.720  -6.926  1.00 38.98           N  
ATOM   1302  CA  LEU   191      -3.217  34.037  -7.202  1.00 38.93           C  
ATOM   1303  C   LEU   191      -2.794  33.073  -6.116  1.00 39.02           C  
ATOM   1304  O   LEU   191      -2.290  31.994  -6.440  1.00 38.62           O  
ATOM   1305  CB  LEU   191      -2.075  35.040  -7.476  1.00 39.93           C  
ATOM   1306  CG  LEU   191      -2.305  35.806  -8.793  1.00 40.44           C  
ATOM   1307  CD1 LEU   191      -1.294  36.936  -8.975  1.00 43.47           C  
ATOM   1308  CD2 LEU   191      -2.281  34.785  -9.946  1.00 44.54           C  
ATOM   1309  N   ASN   192      -2.993  33.452  -4.850  1.00 37.70           N  
ATOM   1310  CA  ASN   192      -2.697  32.567  -3.715  1.00 36.83           C  
ATOM   1311  C   ASN   192      -3.572  31.343  -3.723  1.00 37.14           C  
ATOM   1312  O   ASN   192      -3.220  30.335  -3.109  1.00 38.40           O  
ATOM   1313  CB  ASN   192      -2.803  33.285  -2.328  1.00 36.57           C  
ATOM   1314  CG  ASN   192      -1.633  34.215  -2.047  1.00 36.66           C  
ATOM   1315  OD1 ASN   192      -0.523  33.959  -2.494  1.00 38.01           O  
ATOM   1316  ND2 ASN   192      -1.882  35.340  -1.331  1.00 36.35           N  
ATOM   1317  N   ALA   193      -4.720  31.401  -4.391  1.00 37.30           N  
ATOM   1318  CA  ALA   193      -5.619  30.241  -4.494  1.00 36.33           C  
ATOM   1319  C   ALA   193      -5.196  29.261  -5.595  1.00 35.42           C  
ATOM   1320  O   ALA   193      -5.751  28.146  -5.717  1.00 34.15           O  
ATOM   1321  CB  ALA   193      -7.096  30.722  -4.711  1.00 37.39           C  
ATOM   1322  N   ILE   194      -4.213  29.656  -6.408  1.00 34.06           N  
ATOM   1323  CA  ILE   194      -3.711  28.735  -7.433  1.00 34.61           C  
ATOM   1324  C   ILE   194      -2.594  27.985  -6.706  1.00 33.90           C  
ATOM   1325  O   ILE   194      -1.568  28.560  -6.394  1.00 33.32           O  
ATOM   1326  CB  ILE   194      -3.222  29.454  -8.746  1.00 34.05           C  
ATOM   1327  CG1 ILE   194      -4.363  30.303  -9.345  1.00 35.03           C  
ATOM   1328  CG2 ILE   194      -2.699  28.418  -9.802  1.00 33.21           C  
ATOM   1329  CD1 ILE   194      -3.961  31.173 -10.615  1.00 33.84           C  
ATOM   1330  N   LYS   195      -2.847  26.728  -6.374  1.00 35.20           N  
ATOM   1331  CA  LYS   195      -1.876  25.930  -5.637  1.00 35.60           C  
ATOM   1332  C   LYS   195      -0.505  25.965  -6.346  1.00 36.08           C  
ATOM   1333  O   LYS   195      -0.411  25.714  -7.565  1.00 35.81           O  
ATOM   1334  CB  LYS   195      -2.387  24.514  -5.446  1.00 35.34           C  
ATOM   1335  CG  LYS   195      -1.460  23.600  -4.645  1.00 36.94           C  
ATOM   1336  CD  LYS   195      -2.201  22.407  -4.192  1.00 34.56           C  
ATOM   1337  CE  LYS   195      -1.351  21.448  -3.450  1.00 34.63           C  
ATOM   1338  NZ  LYS   195      -2.210  20.321  -3.050  1.00 30.40           N  
ATOM   1339  N   GLY   196       0.531  26.345  -5.599  1.00 36.12           N  
ATOM   1340  CA  GLY   196       1.898  26.289  -6.099  1.00 35.91           C  
ATOM   1341  C   GLY   196       2.305  27.551  -6.816  1.00 36.65           C  
ATOM   1342  O   GLY   196       3.507  27.740  -7.088  1.00 36.86           O  
ATOM   1343  N   GLU   197       1.344  28.426  -7.125  1.00 36.33           N  
ATOM   1344  CA  GLU   197       1.667  29.605  -7.943  1.00 37.55           C  
ATOM   1345  C   GLU   197       2.560  30.629  -7.204  1.00 38.59           C  
ATOM   1346  O   GLU   197       3.497  31.163  -7.798  1.00 38.33           O  
ATOM   1347  CB  GLU   197       0.419  30.300  -8.468  1.00 37.82           C  
ATOM   1348  CG  GLU   197       0.668  31.114  -9.722  1.00 43.40           C  
ATOM   1349  CD  GLU   197       0.559  30.264 -11.018  1.00 49.01           C  
ATOM   1350  OE1 GLU   197      -0.187  30.686 -11.921  1.00 51.75           O  
ATOM   1351  OE2 GLU   197       1.177  29.164 -11.156  1.00 52.34           O  
ATOM   1352  N   ALA   198       2.291  30.892  -5.920  1.00 38.82           N  
ATOM   1353  CA  ALA   198       3.132  31.857  -5.162  1.00 39.20           C  
ATOM   1354  C   ALA   198       4.581  31.318  -5.068  1.00 40.28           C  
ATOM   1355  O   ALA   198       5.559  32.067  -5.197  1.00 39.92           O  
ATOM   1356  CB  ALA   198       2.568  32.073  -3.828  1.00 39.55           C  
ATOM   1357  N   SER   199       4.705  30.011  -4.877  1.00 39.80           N  
ATOM   1358  CA  SER   199       6.017  29.356  -4.808  1.00 41.18           C  
ATOM   1359  C   SER   199       6.752  29.410  -6.164  1.00 40.92           C  
ATOM   1360  O   SER   199       7.961  29.702  -6.200  1.00 41.81           O  
ATOM   1361  CB  SER   199       5.854  27.933  -4.303  1.00 40.29           C  
ATOM   1362  OG  SER   199       7.118  27.325  -4.118  1.00 44.86           O  
ATOM   1363  N   ARG   200       6.030  29.226  -7.276  1.00 40.52           N  
ATOM   1364  CA  ARG   200       6.615  29.459  -8.615  1.00 40.24           C  
ATOM   1365  C   ARG   200       7.175  30.877  -8.784  1.00 39.77           C  
ATOM   1366  O   ARG   200       8.250  31.065  -9.381  1.00 39.36           O  
ATOM   1367  CB  ARG   200       5.632  29.137  -9.745  1.00 40.01           C  
ATOM   1368  CG  ARG   200       5.495  27.640  -9.987  1.00 41.00           C  
ATOM   1369  CD  ARG   200       4.264  27.239 -10.825  1.00 42.99           C  
ATOM   1370  NE  ARG   200       4.142  28.008 -12.068  1.00 49.55           N  
ATOM   1371  CZ  ARG   200       3.651  27.538 -13.224  1.00 52.36           C  
ATOM   1372  NH1 ARG   200       3.581  28.348 -14.283  1.00 52.08           N  
ATOM   1373  NH2 ARG   200       3.251  26.265 -13.339  1.00 51.69           N  
ATOM   1374  N   LEU   201       6.440  31.860  -8.295  1.00 37.63           N  
ATOM   1375  CA  LEU   201       6.869  33.279  -8.351  1.00 39.30           C  
ATOM   1376  C   LEU   201       8.065  33.524  -7.449  1.00 39.33           C  
ATOM   1377  O   LEU   201       8.985  34.253  -7.837  1.00 38.96           O  
ATOM   1378  CB  LEU   201       5.730  34.241  -7.952  1.00 37.79           C  
ATOM   1379  CG  LEU   201       4.440  34.162  -8.770  1.00 40.78           C  
ATOM   1380  CD1 LEU   201       3.361  35.029  -8.131  1.00 38.26           C  
ATOM   1381  CD2 LEU   201       4.702  34.616 -10.232  1.00 39.91           C  
ATOM   1382  N   ALA   202       8.062  32.902  -6.263  1.00 39.34           N  
ATOM   1383  CA  ALA   202       9.182  33.054  -5.347  1.00 40.13           C  
ATOM   1384  C   ALA   202      10.467  32.448  -5.938  1.00 41.27           C  
ATOM   1385  O   ALA   202      11.551  33.034  -5.818  1.00 41.45           O  
ATOM   1386  CB  ALA   202       8.861  32.465  -4.019  1.00 39.97           C  
ATOM   1387  N   VAL   203      10.339  31.298  -6.600  1.00 41.74           N  
ATOM   1388  CA  VAL   203      11.497  30.685  -7.267  1.00 42.08           C  
ATOM   1389  C   VAL   203      12.026  31.580  -8.399  1.00 41.70           C  
ATOM   1390  O   VAL   203      13.220  31.783  -8.475  1.00 41.07           O  
ATOM   1391  CB  VAL   203      11.276  29.184  -7.667  1.00 42.31           C  
ATOM   1392  CG1 VAL   203      10.766  28.360  -6.474  1.00 41.59           C  
ATOM   1393  CG2 VAL   203      10.334  29.057  -8.821  1.00 44.04           C  
ATOM   1394  N   LEU   204      11.135  32.148  -9.229  1.00 42.28           N  
ATOM   1395  CA  LEU   204      11.501  33.205 -10.217  1.00 42.77           C  
ATOM   1396  C   LEU   204      12.250  34.379  -9.590  1.00 42.88           C  
ATOM   1397  O   LEU   204      13.131  34.975 -10.208  1.00 42.99           O  
ATOM   1398  CB  LEU   204      10.258  33.789 -10.906  1.00 43.24           C  
ATOM   1399  CG  LEU   204       9.650  33.355 -12.246  1.00 46.48           C  
ATOM   1400  CD1 LEU   204       8.426  32.557 -12.066  1.00 47.32           C  
ATOM   1401  CD2 LEU   204       9.289  34.637 -13.021  1.00 48.31           C  
ATOM   1402  N   ALA   205      11.845  34.737  -8.373  1.00 41.99           N  
ATOM   1403  CA  ALA   205      12.465  35.806  -7.612  1.00 42.75           C  
ATOM   1404  C   ALA   205      13.871  35.462  -7.077  1.00 42.85           C  
ATOM   1405  O   ALA   205      14.571  36.350  -6.561  1.00 44.20           O  
ATOM   1406  CB  ALA   205      11.544  36.181  -6.480  1.00 41.31           C  
ATOM   1407  N   GLY   206      14.252  34.186  -7.176  1.00 42.19           N  
ATOM   1408  CA  GLY   206      15.535  33.667  -6.718  1.00 42.09           C  
ATOM   1409  C   GLY   206      15.461  32.901  -5.405  1.00 42.11           C  
ATOM   1410  O   GLY   206      16.487  32.569  -4.842  1.00 41.96           O  
ATOM   1411  N   ALA   207      14.258  32.640  -4.900  1.00 42.14           N  
ATOM   1412  CA  ALA   207      14.086  31.971  -3.599  1.00 43.13           C  
ATOM   1413  C   ALA   207      13.941  30.435  -3.687  1.00 44.04           C  
ATOM   1414  O   ALA   207      13.926  29.858  -4.771  1.00 43.67           O  
ATOM   1415  CB  ALA   207      12.901  32.560  -2.844  1.00 43.20           C  
ATOM   1416  N   LYS   208      13.858  29.784  -2.528  1.00 45.85           N  
ATOM   1417  CA  LYS   208      13.705  28.329  -2.474  1.00 47.85           C  
ATOM   1418  C   LYS   208      12.243  27.932  -2.333  1.00 48.78           C  
ATOM   1419  O   LYS   208      11.493  28.568  -1.602  1.00 48.17           O  
ATOM   1420  CB  LYS   208      14.510  27.734  -1.313  1.00 48.57           C  
ATOM   1421  CG  LYS   208      15.886  27.145  -1.690  1.00 50.53           C  
ATOM   1422  CD  LYS   208      17.062  28.075  -1.389  1.00 55.23           C  
ATOM   1423  CE  LYS   208      17.400  28.165   0.123  1.00 57.03           C  
ATOM   1424  NZ  LYS   208      16.408  29.004   0.917  1.00 54.74           N  
ATOM   1425  N   THR   209      11.856  26.854  -3.017  1.00 50.43           N  
ATOM   1426  CA  THR   209      10.494  26.310  -2.927  1.00 51.48           C  
ATOM   1427  C   THR   209      10.035  26.159  -1.464  1.00 51.51           C  
ATOM   1428  O   THR   209      10.851  26.107  -0.522  1.00 51.65           O  
ATOM   1429  CB  THR   209      10.333  24.991  -3.735  1.00 52.21           C  
ATOM   1430  OG1 THR   209       8.940  24.634  -3.819  1.00 53.28           O  
ATOM   1431  CG2 THR   209      11.159  23.850  -3.116  1.00 52.02           C  
ATOM   1432  N   GLY   210       8.723  26.145  -1.276  1.00 50.99           N  
ATOM   1433  CA  GLY   210       8.183  26.203   0.072  1.00 50.54           C  
ATOM   1434  C   GLY   210       6.723  26.562   0.048  1.00 49.29           C  
ATOM   1435  O   GLY   210       6.091  26.552  -1.014  1.00 48.86           O  
ATOM   1436  N   ARG   211       6.181  26.857   1.225  1.00 48.70           N  
ATOM   1437  CA  ARG   211       4.782  27.252   1.299  1.00 48.23           C  
ATOM   1438  C   ARG   211       4.771  28.768   1.288  1.00 45.98           C  
ATOM   1439  O   ARG   211       4.824  29.430   2.335  1.00 47.07           O  
ATOM   1440  CB  ARG   211       4.040  26.622   2.493  1.00 48.33           C  
ATOM   1441  CG  ARG   211       4.079  25.034   2.560  1.00 52.97           C  
ATOM   1442  CD  ARG   211       4.151  24.292   1.176  1.00 61.21           C  
ATOM   1443  NE  ARG   211       2.925  24.332   0.342  1.00 66.10           N  
ATOM   1444  CZ  ARG   211       2.842  24.786  -0.919  1.00 69.04           C  
ATOM   1445  NH1 ARG   211       3.911  25.278  -1.544  1.00 70.03           N  
ATOM   1446  NH2 ARG   211       1.671  24.742  -1.576  1.00 70.00           N  
ATOM   1447  N   TRP   212       4.775  29.298   0.067  1.00 43.67           N  
ATOM   1448  CA  TRP   212       4.775  30.749  -0.205  1.00 41.76           C  
ATOM   1449  C   TRP   212       3.382  31.352  -0.350  1.00 40.77           C  
ATOM   1450  O   TRP   212       2.448  30.677  -0.800  1.00 40.44           O  
ATOM   1451  CB  TRP   212       5.553  31.004  -1.494  1.00 41.37           C  
ATOM   1452  CG  TRP   212       7.006  30.766  -1.310  1.00 39.46           C  
ATOM   1453  CD1 TRP   212       7.678  29.606  -1.529  1.00 38.11           C  
ATOM   1454  CD2 TRP   212       7.962  31.698  -0.787  1.00 39.28           C  
ATOM   1455  NE1 TRP   212       9.008  29.772  -1.236  1.00 37.62           N  
ATOM   1456  CE2 TRP   212       9.212  31.037  -0.758  1.00 40.47           C  
ATOM   1457  CE3 TRP   212       7.893  33.032  -0.374  1.00 36.46           C  
ATOM   1458  CZ2 TRP   212      10.390  31.671  -0.314  1.00 39.98           C  
ATOM   1459  CZ3 TRP   212       9.054  33.663   0.048  1.00 38.84           C  
ATOM   1460  CH2 TRP   212      10.290  32.983   0.070  1.00 39.28           C  
ATOM   1461  N   LYS   213       3.249  32.622   0.017  1.00 40.58           N  
ATOM   1462  CA  LYS   213       2.059  33.422  -0.275  1.00 40.25           C  
ATOM   1463  C   LYS   213       2.484  34.787  -0.791  1.00 39.48           C  
ATOM   1464  O   LYS   213       3.498  35.318  -0.343  1.00 39.04           O  
ATOM   1465  CB  LYS   213       1.194  33.602   0.979  1.00 40.47           C  
ATOM   1466  CG  LYS   213       0.446  32.298   1.467  1.00 43.77           C  
ATOM   1467  CD  LYS   213      -0.666  31.854   0.470  1.00 48.68           C  
ATOM   1468  CE  LYS   213      -1.257  30.458   0.783  1.00 45.97           C  
ATOM   1469  NZ  LYS   213      -2.195  29.896  -0.272  1.00 44.84           N  
ATOM   1470  N   ILE   214       1.723  35.334  -1.746  1.00 38.84           N  
ATOM   1471  CA  ILE   214       1.833  36.736  -2.134  1.00 38.25           C  
ATOM   1472  C   ILE   214       1.308  37.565  -1.016  1.00 39.46           C  
ATOM   1473  O   ILE   214       0.191  37.315  -0.538  1.00 39.34           O  
ATOM   1474  CB  ILE   214       1.020  37.045  -3.356  1.00 38.32           C  
ATOM   1475  CG1 ILE   214       1.577  36.244  -4.537  1.00 41.05           C  
ATOM   1476  CG2 ILE   214       0.995  38.591  -3.651  1.00 36.16           C  
ATOM   1477  CD1 ILE   214       0.735  36.298  -5.751  1.00 42.99           C  
ATOM   1478  N   THR   215       2.118  38.522  -0.572  1.00 40.09           N  
ATOM   1479  CA  THR   215       1.717  39.429   0.495  1.00 39.19           C  
ATOM   1480  C   THR   215       1.306  40.776  -0.058  1.00 40.01           C  
ATOM   1481  O   THR   215       0.474  41.460   0.565  1.00 40.47           O  
ATOM   1482  CB  THR   215       2.810  39.584   1.605  1.00 38.67           C  
ATOM   1483  OG1 THR   215       4.030  40.065   1.019  1.00 36.42           O  
ATOM   1484  CG2 THR   215       3.081  38.205   2.256  1.00 39.25           C  
ATOM   1485  N   SER   216       1.859  41.163  -1.219  1.00 40.46           N  
ATOM   1486  CA  SER   216       1.661  42.478  -1.733  1.00 40.62           C  
ATOM   1487  C   SER   216       2.031  42.554  -3.192  1.00 41.47           C  
ATOM   1488  O   SER   216       3.074  42.032  -3.593  1.00 41.94           O  
ATOM   1489  CB  SER   216       2.497  43.491  -0.907  1.00 39.86           C  
ATOM   1490  OG  SER   216       2.128  44.823  -1.153  1.00 41.34           O  
ATOM   1491  N   ILE   217       1.172  43.215  -3.992  1.00 41.47           N  
ATOM   1492  CA  ILE   217       1.457  43.510  -5.417  1.00 40.32           C  
ATOM   1493  C   ILE   217       1.534  45.018  -5.557  1.00 40.31           C  
ATOM   1494  O   ILE   217       0.694  45.723  -5.002  1.00 39.84           O  
ATOM   1495  CB  ILE   217       0.343  42.980  -6.348  1.00 40.39           C  
ATOM   1496  CG1 ILE   217       0.187  41.443  -6.165  1.00 39.41           C  
ATOM   1497  CG2 ILE   217       0.598  43.426  -7.811  1.00 39.89           C  
ATOM   1498  CD1 ILE   217      -1.090  40.855  -6.724  1.00 41.51           C  
ATOM   1499  N   ASP   218       2.548  45.504  -6.273  1.00 39.30           N  
ATOM   1500  CA  ASP   218       2.705  46.956  -6.484  1.00 38.73           C  
ATOM   1501  C   ASP   218       3.151  47.210  -7.933  1.00 37.93           C  
ATOM   1502  O   ASP   218       3.416  46.255  -8.685  1.00 37.25           O  
ATOM   1503  CB  ASP   218       3.623  47.588  -5.385  1.00 37.51           C  
ATOM   1504  CG  ASP   218       5.058  47.024  -5.398  1.00 40.93           C  
ATOM   1505  OD1 ASP   218       5.778  47.238  -6.414  1.00 42.23           O  
ATOM   1506  OD2 ASP   218       5.485  46.367  -4.407  1.00 40.91           O  
ATOM   1507  N   PRO   219       3.198  48.476  -8.359  1.00 37.21           N  
ATOM   1508  CA  PRO   219       3.591  48.663  -9.760  1.00 37.75           C  
ATOM   1509  C   PRO   219       4.951  48.083 -10.199  1.00 37.92           C  
ATOM   1510  O   PRO   219       5.164  47.847 -11.405  1.00 38.51           O  
ATOM   1511  CB  PRO   219       3.597  50.203  -9.907  1.00 38.18           C  
ATOM   1512  CG  PRO   219       2.574  50.651  -8.926  1.00 36.94           C  
ATOM   1513  CD  PRO   219       2.808  49.758  -7.722  1.00 36.21           C  
ATOM   1514  N   ASP   220       5.859  47.883  -9.259  1.00 37.98           N  
ATOM   1515  CA  ASP   220       7.228  47.454  -9.589  1.00 39.01           C  
ATOM   1516  C   ASP   220       7.467  45.947  -9.367  1.00 38.51           C  
ATOM   1517  O   ASP   220       8.460  45.362  -9.868  1.00 37.46           O  
ATOM   1518  CB  ASP   220       8.245  48.271  -8.767  1.00 38.35           C  
ATOM   1519  CG  ASP   220       8.330  49.724  -9.217  1.00 39.07           C  
ATOM   1520  OD1 ASP   220       7.923  50.038 -10.360  1.00 39.95           O  
ATOM   1521  OD2 ASP   220       8.803  50.553  -8.411  1.00 42.67           O  
ATOM   1522  N   GLY   221       6.533  45.310  -8.679  1.00 37.64           N  
ATOM   1523  CA  GLY   221       6.634  43.860  -8.472  1.00 38.70           C  
ATOM   1524  C   GLY   221       5.776  43.311  -7.351  1.00 39.35           C  
ATOM   1525  O   GLY   221       4.787  43.925  -6.960  1.00 39.63           O  
ATOM   1526  N   ILE   222       6.190  42.163  -6.812  1.00 39.81           N  
ATOM   1527  CA  ILE   222       5.341  41.364  -5.958  1.00 40.03           C  
ATOM   1528  C   ILE   222       6.174  40.894  -4.775  1.00 40.65           C  
ATOM   1529  O   ILE   222       7.272  40.320  -4.965  1.00 41.65           O  
ATOM   1530  CB  ILE   222       4.790  40.075  -6.716  1.00 39.93           C  
ATOM   1531  CG1 ILE   222       4.009  40.441  -7.999  1.00 38.13           C  
ATOM   1532  CG2 ILE   222       3.929  39.192  -5.700  1.00 38.68           C  
ATOM   1533  CD1 ILE   222       3.752  39.227  -8.997  1.00 40.00           C  
ATOM   1534  N   ASP   223       5.645  41.080  -3.567  1.00 39.32           N  
ATOM   1535  CA  ASP   223       6.358  40.638  -2.403  1.00 39.52           C  
ATOM   1536  C   ASP   223       5.741  39.337  -2.046  1.00 38.95           C  
ATOM   1537  O   ASP   223       4.511  39.211  -2.116  1.00 38.85           O  
ATOM   1538  CB  ASP   223       6.196  41.623  -1.251  1.00 39.17           C  
ATOM   1539  CG  ASP   223       7.141  42.848  -1.375  1.00 42.76           C  
ATOM   1540  OD1 ASP   223       8.022  42.907  -2.249  1.00 47.48           O  
ATOM   1541  OD2 ASP   223       6.998  43.742  -0.557  1.00 44.98           O  
ATOM   1542  N   LEU   224       6.580  38.377  -1.633  1.00 39.80           N  
ATOM   1543  CA  LEU   224       6.111  37.053  -1.146  1.00 38.74           C  
ATOM   1544  C   LEU   224       6.722  36.680   0.186  1.00 39.35           C  
ATOM   1545  O   LEU   224       7.821  37.137   0.512  1.00 38.40           O  
ATOM   1546  CB  LEU   224       6.378  35.942  -2.182  1.00 39.02           C  
ATOM   1547  CG  LEU   224       5.897  36.304  -3.590  1.00 37.93           C  
ATOM   1548  CD1 LEU   224       7.068  36.608  -4.460  1.00 39.11           C  
ATOM   1549  CD2 LEU   224       5.071  35.150  -4.101  1.00 40.89           C  
ATOM   1550  N   ALA   225       5.995  35.870   0.966  1.00 37.56           N  
ATOM   1551  CA  ALA   225       6.510  35.322   2.200  1.00 38.71           C  
ATOM   1552  C   ALA   225       6.232  33.820   2.347  1.00 40.11           C  
ATOM   1553  O   ALA   225       5.213  33.284   1.854  1.00 39.61           O  
ATOM   1554  CB  ALA   225       5.984  36.121   3.449  1.00 38.10           C  
ATOM   1555  N   SER   226       7.187  33.150   2.992  1.00 41.63           N  
ATOM   1556  CA  SER   226       7.013  31.793   3.510  1.00 41.51           C  
ATOM   1557  C   SER   226       7.324  31.904   4.982  1.00 42.46           C  
ATOM   1558  O   SER   226       7.537  33.010   5.479  1.00 43.34           O  
ATOM   1559  CB  SER   226       7.970  30.828   2.842  1.00 41.83           C  
ATOM   1560  OG  SER   226       9.300  31.081   3.257  1.00 42.39           O  
ATOM   1561  N   ALA   227       7.342  30.774   5.689  1.00 42.16           N  
ATOM   1562  CA  ALA   227       7.669  30.767   7.106  1.00 42.59           C  
ATOM   1563  C   ALA   227       9.110  31.220   7.433  1.00 42.71           C  
ATOM   1564  O   ALA   227       9.305  32.007   8.356  1.00 42.36           O  
ATOM   1565  CB  ALA   227       7.402  29.404   7.699  1.00 43.21           C  
ATOM   1566  N   SER   228      10.105  30.715   6.694  1.00 42.72           N  
ATOM   1567  CA  SER   228      11.510  31.070   6.946  1.00 42.93           C  
ATOM   1568  C   SER   228      12.085  32.193   6.075  1.00 42.11           C  
ATOM   1569  O   SER   228      13.103  32.779   6.454  1.00 42.02           O  
ATOM   1570  CB  SER   228      12.418  29.834   6.879  1.00 43.93           C  
ATOM   1571  OG  SER   228      12.426  29.254   5.581  1.00 46.22           O  
ATOM   1572  N   ASP   229      11.432  32.518   4.949  1.00 41.72           N  
ATOM   1573  CA  ASP   229      11.994  33.464   3.977  1.00 39.90           C  
ATOM   1574  C   ASP   229      11.038  34.518   3.395  1.00 38.59           C  
ATOM   1575  O   ASP   229       9.824  34.418   3.499  1.00 37.75           O  
ATOM   1576  CB  ASP   229      12.660  32.689   2.838  1.00 40.44           C  
ATOM   1577  CG  ASP   229      13.926  33.373   2.310  1.00 44.68           C  
ATOM   1578  OD1 ASP   229      14.608  32.727   1.477  1.00 49.71           O  
ATOM   1579  OD2 ASP   229      14.260  34.531   2.722  1.00 43.59           O  
ATOM   1580  N   LEU   230      11.617  35.547   2.781  1.00 36.54           N  
ATOM   1581  CA  LEU   230      10.867  36.577   2.051  1.00 36.28           C  
ATOM   1582  C   LEU   230      11.476  36.665   0.654  1.00 36.24           C  
ATOM   1583  O   LEU   230      12.709  36.487   0.502  1.00 36.39           O  
ATOM   1584  CB  LEU   230      10.960  37.968   2.743  1.00 34.87           C  
ATOM   1585  CG  LEU   230      10.459  38.126   4.187  1.00 34.46           C  
ATOM   1586  CD1 LEU   230      10.799  39.517   4.729  1.00 32.33           C  
ATOM   1587  CD2 LEU   230       8.953  37.824   4.324  1.00 35.09           C  
ATOM   1588  N   ALA   231      10.630  36.971  -0.330  1.00 36.69           N  
ATOM   1589  CA  ALA   231      11.059  37.169  -1.718  1.00 37.63           C  
ATOM   1590  C   ALA   231      10.385  38.400  -2.322  1.00 37.88           C  
ATOM   1591  O   ALA   231       9.292  38.845  -1.850  1.00 36.74           O  
ATOM   1592  CB  ALA   231      10.745  35.917  -2.578  1.00 38.16           C  
ATOM   1593  N   ARG   232      11.063  38.987  -3.312  1.00 37.21           N  
ATOM   1594  CA  ARG   232      10.468  40.025  -4.146  1.00 37.53           C  
ATOM   1595  C   ARG   232      10.745  39.728  -5.616  1.00 37.39           C  
ATOM   1596  O   ARG   232      11.906  39.647  -6.036  1.00 38.13           O  
ATOM   1597  CB  ARG   232      10.957  41.450  -3.789  1.00 38.48           C  
ATOM   1598  CG  ARG   232      10.221  42.472  -4.667  1.00 41.60           C  
ATOM   1599  CD  ARG   232      10.480  43.857  -4.294  1.00 44.96           C  
ATOM   1600  NE  ARG   232       9.842  44.856  -5.158  1.00 45.46           N  
ATOM   1601  CZ  ARG   232       8.545  45.201  -5.198  1.00 44.81           C  
ATOM   1602  NH1 ARG   232       7.613  44.591  -4.445  1.00 40.67           N  
ATOM   1603  NH2 ARG   232       8.185  46.204  -6.021  1.00 40.08           N  
ATOM   1604  N   LEU   233       9.680  39.585  -6.392  1.00 37.74           N  
ATOM   1605  CA  LEU   233       9.800  39.394  -7.866  1.00 37.36           C  
ATOM   1606  C   LEU   233       9.638  40.752  -8.532  1.00 38.69           C  
ATOM   1607  O   LEU   233       8.593  41.362  -8.387  1.00 39.15           O  
ATOM   1608  CB  LEU   233       8.739  38.415  -8.393  1.00 38.10           C  
ATOM   1609  CG  LEU   233       8.736  38.007  -9.900  1.00 37.23           C  
ATOM   1610  CD1 LEU   233      10.041  37.435 -10.324  1.00 36.14           C  
ATOM   1611  CD2 LEU   233       7.602  36.987 -10.196  1.00 36.27           C  
ATOM   1612  N   TRP   234      10.659  41.219  -9.269  1.00 38.24           N  
ATOM   1613  CA  TRP   234      10.559  42.485  -9.974  1.00 39.13           C  
ATOM   1614  C   TRP   234       9.999  42.342 -11.361  1.00 39.09           C  
ATOM   1615  O   TRP   234      10.421  41.458 -12.124  1.00 40.17           O  
ATOM   1616  CB  TRP   234      11.916  43.181 -10.045  1.00 39.39           C  
ATOM   1617  CG  TRP   234      12.446  43.508  -8.659  1.00 39.51           C  
ATOM   1618  CD1 TRP   234      13.161  42.667  -7.823  1.00 40.36           C  
ATOM   1619  CD2 TRP   234      12.292  44.740  -7.949  1.00 40.13           C  
ATOM   1620  NE1 TRP   234      13.498  43.317  -6.657  1.00 35.87           N  
ATOM   1621  CE2 TRP   234      12.967  44.585  -6.692  1.00 41.06           C  
ATOM   1622  CE3 TRP   234      11.668  45.966  -8.244  1.00 39.24           C  
ATOM   1623  CZ2 TRP   234      13.023  45.616  -5.731  1.00 42.27           C  
ATOM   1624  CZ3 TRP   234      11.732  47.019  -7.270  1.00 42.22           C  
ATOM   1625  CH2 TRP   234      12.398  46.825  -6.044  1.00 40.34           C  
ATOM   1626  N   PHE   235       9.043  43.203 -11.706  1.00 38.84           N  
ATOM   1627  CA  PHE   235       8.515  43.208 -13.084  1.00 38.96           C  
ATOM   1628  C   PHE   235       9.582  43.700 -14.033  1.00 38.59           C  
ATOM   1629  O   PHE   235      10.443  44.516 -13.632  1.00 38.93           O  
ATOM   1630  CB  PHE   235       7.276  44.094 -13.183  1.00 38.97           C  
ATOM   1631  CG  PHE   235       6.112  43.615 -12.341  1.00 40.90           C  
ATOM   1632  CD1 PHE   235       5.797  42.235 -12.271  1.00 40.09           C  
ATOM   1633  CD2 PHE   235       5.322  44.534 -11.636  1.00 39.05           C  
ATOM   1634  CE1 PHE   235       4.745  41.781 -11.549  1.00 39.69           C  
ATOM   1635  CE2 PHE   235       4.223  44.079 -10.871  1.00 37.48           C  
ATOM   1636  CZ  PHE   235       3.940  42.720 -10.819  1.00 40.48           C  
ATOM   1637  N   ALA   236       9.543  43.231 -15.280  1.00 38.45           N  
ATOM   1638  CA  ALA   236      10.436  43.786 -16.290  1.00 37.70           C  
ATOM   1639  C   ALA   236      10.100  45.249 -16.627  1.00 37.64           C  
ATOM   1640  O   ALA   236      10.982  46.013 -16.965  1.00 37.01           O  
ATOM   1641  CB  ALA   236      10.483  42.913 -17.582  1.00 38.00           C  
ATOM   1642  N   GLU   237       8.824  45.611 -16.580  1.00 37.50           N  
ATOM   1643  CA  GLU   237       8.438  47.005 -16.714  1.00 38.69           C  
ATOM   1644  C   GLU   237       7.311  47.345 -15.745  1.00 38.00           C  
ATOM   1645  O   GLU   237       6.660  46.443 -15.220  1.00 38.35           O  
ATOM   1646  CB  GLU   237       8.133  47.404 -18.174  1.00 38.07           C  
ATOM   1647  CG  GLU   237       7.000  46.656 -18.820  1.00 38.95           C  
ATOM   1648  CD  GLU   237       6.900  46.949 -20.306  1.00 40.50           C  
ATOM   1649  OE1 GLU   237       6.063  46.300 -20.980  1.00 44.17           O  
ATOM   1650  OE2 GLU   237       7.648  47.820 -20.803  1.00 39.99           O  
ATOM   1651  N   ARG   238       7.144  48.649 -15.473  1.00 38.50           N  
ATOM   1652  CA  ARG   238       6.249  49.148 -14.421  1.00 38.23           C  
ATOM   1653  C   ARG   238       4.837  48.801 -14.832  1.00 38.36           C  
ATOM   1654  O   ARG   238       4.489  48.922 -15.997  1.00 36.49           O  
ATOM   1655  CB  ARG   238       6.398  50.684 -14.283  1.00 39.03           C  
ATOM   1656  CG  ARG   238       5.456  51.361 -13.290  1.00 38.45           C  
ATOM   1657  CD  ARG   238       5.582  52.918 -13.308  1.00 40.35           C  
ATOM   1658  NE  ARG   238       4.427  53.521 -12.639  1.00 40.39           N  
ATOM   1659  CZ  ARG   238       4.292  53.621 -11.319  1.00 38.31           C  
ATOM   1660  NH1 ARG   238       5.236  53.158 -10.511  1.00 40.01           N  
ATOM   1661  NH2 ARG   238       3.199  54.153 -10.810  1.00 35.26           N  
ATOM   1662  N   VAL   239       4.014  48.410 -13.876  1.00 39.17           N  
ATOM   1663  CA  VAL   239       2.653  47.913 -14.163  1.00 40.40           C  
ATOM   1664  C   VAL   239       1.617  48.878 -13.543  1.00 40.56           C  
ATOM   1665  O   VAL   239       1.759  49.304 -12.403  1.00 38.13           O  
ATOM   1666  CB  VAL   239       2.495  46.455 -13.636  1.00 40.92           C  
ATOM   1667  CG1 VAL   239       1.032  46.075 -13.500  1.00 41.13           C  
ATOM   1668  CG2 VAL   239       3.219  45.489 -14.602  1.00 41.64           C  
ATOM   1669  N   GLU   240       0.599  49.262 -14.314  1.00 39.99           N  
ATOM   1670  CA  GLU   240      -0.309  50.325 -13.830  1.00 40.55           C  
ATOM   1671  C   GLU   240      -1.774  49.914 -13.806  1.00 40.06           C  
ATOM   1672  O   GLU   240      -2.584  50.452 -13.040  1.00 38.77           O  
ATOM   1673  CB  GLU   240      -0.098  51.614 -14.631  1.00 41.11           C  
ATOM   1674  CG  GLU   240       1.092  52.415 -14.105  1.00 40.98           C  
ATOM   1675  CD  GLU   240       1.240  53.750 -14.788  1.00 42.99           C  
ATOM   1676  OE1 GLU   240       0.678  53.947 -15.907  1.00 43.11           O  
ATOM   1677  OE2 GLU   240       1.937  54.609 -14.198  1.00 45.89           O  
ATOM   1678  N   THR   241      -2.069  48.888 -14.592  1.00 40.56           N  
ATOM   1679  CA  THR   241      -3.427  48.407 -14.767  1.00 40.97           C  
ATOM   1680  C   THR   241      -3.498  46.920 -14.591  1.00 41.14           C  
ATOM   1681  O   THR   241      -2.471  46.206 -14.586  1.00 40.51           O  
ATOM   1682  CB  THR   241      -3.978  48.755 -16.176  1.00 41.31           C  
ATOM   1683  OG1 THR   241      -3.235  48.037 -17.173  1.00 41.19           O  
ATOM   1684  CG2 THR   241      -3.896  50.254 -16.443  1.00 40.83           C  
ATOM   1685  N   LEU   242      -4.724  46.430 -14.464  1.00 41.44           N  
ATOM   1686  CA  LEU   242      -4.923  44.999 -14.321  1.00 41.37           C  
ATOM   1687  C   LEU   242      -4.507  44.277 -15.604  1.00 40.45           C  
ATOM   1688  O   LEU   242      -3.842  43.239 -15.543  1.00 39.76           O  
ATOM   1689  CB  LEU   242      -6.383  44.686 -13.982  1.00 42.24           C  
ATOM   1690  CG  LEU   242      -6.693  43.207 -13.740  1.00 43.34           C  
ATOM   1691  CD1 LEU   242      -6.140  42.777 -12.389  1.00 47.07           C  
ATOM   1692  CD2 LEU   242      -8.186  43.008 -13.766  1.00 45.50           C  
ATOM   1693  N   LYS   243      -4.917  44.817 -16.755  1.00 39.92           N  
ATOM   1694  CA  LYS   243      -4.502  44.262 -18.042  1.00 39.83           C  
ATOM   1695  C   LYS   243      -2.986  44.123 -18.089  1.00 39.07           C  
ATOM   1696  O   LYS   243      -2.484  43.076 -18.483  1.00 38.24           O  
ATOM   1697  CB  LYS   243      -4.976  45.110 -19.240  1.00 40.23           C  
ATOM   1698  CG  LYS   243      -4.818  44.352 -20.557  1.00 43.46           C  
ATOM   1699  CD  LYS   243      -5.697  44.891 -21.694  1.00 46.25           C  
ATOM   1700  CE  LYS   243      -6.112  43.753 -22.612  1.00 49.30           C  
ATOM   1701  NZ  LYS   243      -6.790  42.665 -21.842  1.00 50.82           N  
ATOM   1702  N   GLN   244      -2.270  45.172 -17.665  1.00 38.67           N  
ATOM   1703  CA  GLN   244      -0.815  45.166 -17.687  1.00 38.68           C  
ATOM   1704  C   GLN   244      -0.265  44.151 -16.698  1.00 39.31           C  
ATOM   1705  O   GLN   244       0.726  43.487 -16.981  1.00 39.04           O  
ATOM   1706  CB  GLN   244      -0.226  46.558 -17.442  1.00 37.90           C  
ATOM   1707  CG  GLN   244      -0.509  47.574 -18.567  1.00 37.97           C  
ATOM   1708  CD  GLN   244      -0.042  48.971 -18.208  1.00 38.18           C  
ATOM   1709  OE1 GLN   244       0.280  49.264 -17.055  1.00 37.40           O  
ATOM   1710  NE2 GLN   244      -0.004  49.850 -19.201  1.00 38.82           N  
ATOM   1711  N   PHE   245      -0.904  44.014 -15.532  1.00 40.67           N  
ATOM   1712  CA  PHE   245      -0.460  43.012 -14.562  1.00 41.10           C  
ATOM   1713  C   PHE   245      -0.560  41.581 -15.123  1.00 41.63           C  
ATOM   1714  O   PHE   245       0.404  40.810 -15.086  1.00 40.20           O  
ATOM   1715  CB  PHE   245      -1.295  43.096 -13.303  1.00 40.94           C  
ATOM   1716  CG  PHE   245      -0.929  42.085 -12.296  1.00 42.35           C  
ATOM   1717  CD1 PHE   245       0.328  42.120 -11.694  1.00 45.23           C  
ATOM   1718  CD2 PHE   245      -1.842  41.116 -11.891  1.00 43.67           C  
ATOM   1719  CE1 PHE   245       0.700  41.173 -10.739  1.00 42.02           C  
ATOM   1720  CE2 PHE   245      -1.473  40.171 -10.906  1.00 44.61           C  
ATOM   1721  CZ  PHE   245      -0.206  40.220 -10.336  1.00 39.90           C  
ATOM   1722  N   GLU   246      -1.760  41.234 -15.585  1.00 43.00           N  
ATOM   1723  CA  GLU   246      -2.042  39.927 -16.170  1.00 44.84           C  
ATOM   1724  C   GLU   246      -1.063  39.602 -17.321  1.00 44.90           C  
ATOM   1725  O   GLU   246      -0.621  38.454 -17.459  1.00 44.81           O  
ATOM   1726  CB  GLU   246      -3.526  39.860 -16.591  1.00 44.32           C  
ATOM   1727  CG  GLU   246      -3.954  38.674 -17.517  1.00 47.80           C  
ATOM   1728  CD  GLU   246      -5.251  38.946 -18.302  1.00 48.21           C  
ATOM   1729  OE1 GLU   246      -5.773  40.089 -18.210  1.00 54.42           O  
ATOM   1730  OE2 GLU   246      -5.737  38.036 -19.037  1.00 53.58           O  
ATOM   1731  N   LYS   247      -0.709  40.599 -18.135  1.00 45.50           N  
ATOM   1732  CA  LYS   247       0.238  40.365 -19.245  1.00 45.47           C  
ATOM   1733  C   LYS   247       1.616  40.052 -18.693  1.00 45.44           C  
ATOM   1734  O   LYS   247       2.220  39.049 -19.049  1.00 44.50           O  
ATOM   1735  CB  LYS   247       0.365  41.573 -20.175  1.00 45.46           C  
ATOM   1736  CG  LYS   247      -0.918  42.053 -20.865  1.00 48.64           C  
ATOM   1737  CD  LYS   247      -1.542  41.049 -21.852  1.00 50.26           C  
ATOM   1738  CE  LYS   247      -2.612  40.175 -21.151  1.00 52.86           C  
ATOM   1739  NZ  LYS   247      -3.531  40.995 -20.265  1.00 51.97           N  
ATOM   1740  N   ALA   248       2.113  40.961 -17.860  1.00 45.18           N  
ATOM   1741  CA  ALA   248       3.347  40.778 -17.103  1.00 47.11           C  
ATOM   1742  C   ALA   248       3.417  39.420 -16.390  1.00 47.71           C  
ATOM   1743  O   ALA   248       4.455  38.767 -16.415  1.00 48.59           O  
ATOM   1744  CB  ALA   248       3.510  41.906 -16.065  1.00 46.51           C  
ATOM   1745  N   LEU   249       2.324  38.999 -15.752  1.00 48.09           N  
ATOM   1746  CA  LEU   249       2.333  37.731 -15.017  1.00 49.29           C  
ATOM   1747  C   LEU   249       2.472  36.559 -15.978  1.00 48.63           C  
ATOM   1748  O   LEU   249       3.212  35.595 -15.702  1.00 48.78           O  
ATOM   1749  CB  LEU   249       1.068  37.553 -14.151  1.00 49.60           C  
ATOM   1750  CG  LEU   249       1.090  37.485 -12.610  1.00 54.43           C  
ATOM   1751  CD1 LEU   249       0.097  36.412 -12.168  1.00 55.08           C  
ATOM   1752  CD2 LEU   249       2.454  37.183 -11.983  1.00 55.79           C  
ATOM   1753  N   ALA   250       1.760  36.656 -17.101  1.00 48.14           N  
ATOM   1754  CA  ALA   250       1.699  35.597 -18.113  1.00 47.71           C  
ATOM   1755  C   ALA   250       3.049  35.394 -18.810  1.00 47.83           C  
ATOM   1756  O   ALA   250       3.456  34.250 -19.061  1.00 47.90           O  
ATOM   1757  CB  ALA   250       0.585  35.891 -19.145  1.00 47.10           C  
ATOM   1758  N   GLN   251       3.714  36.499 -19.150  1.00 47.40           N  
ATOM   1759  CA  GLN   251       5.108  36.485 -19.619  1.00 47.72           C  
ATOM   1760  C   GLN   251       5.992  35.752 -18.607  1.00 47.15           C  
ATOM   1761  O   GLN   251       6.709  34.823 -18.961  1.00 47.30           O  
ATOM   1762  CB  GLN   251       5.616  37.924 -19.883  1.00 47.82           C  
ATOM   1763  CG  GLN   251       7.139  38.186 -19.666  1.00 50.16           C  
ATOM   1764  CD  GLN   251       7.488  39.108 -18.448  1.00 55.43           C  
ATOM   1765  OE1 GLN   251       8.672  39.397 -18.198  1.00 57.79           O  
ATOM   1766  NE2 GLN   251       6.471  39.574 -17.717  1.00 51.70           N  
ATOM   1767  N   LEU   252       5.888  36.124 -17.345  1.00 46.40           N  
ATOM   1768  CA  LEU   252       6.785  35.611 -16.347  1.00 45.83           C  
ATOM   1769  C   LEU   252       6.648  34.127 -16.155  1.00 45.15           C  
ATOM   1770  O   LEU   252       7.614  33.437 -15.989  1.00 45.08           O  
ATOM   1771  CB  LEU   252       6.532  36.290 -15.001  1.00 45.21           C  
ATOM   1772  CG  LEU   252       7.059  37.678 -14.736  1.00 47.10           C  
ATOM   1773  CD1 LEU   252       6.263  38.387 -13.704  1.00 50.45           C  
ATOM   1774  CD2 LEU   252       8.474  37.620 -14.342  1.00 46.31           C  
ATOM   1775  N   LEU   253       5.428  33.655 -16.131  1.00 44.83           N  
ATOM   1776  CA  LEU   253       5.173  32.277 -15.753  1.00 45.50           C  
ATOM   1777  C   LEU   253       5.338  31.295 -16.921  1.00 47.33           C  
ATOM   1778  O   LEU   253       4.850  30.149 -16.882  1.00 47.87           O  
ATOM   1779  CB  LEU   253       3.790  32.160 -15.118  1.00 45.04           C  
ATOM   1780  CG  LEU   253       3.754  32.686 -13.679  1.00 44.08           C  
ATOM   1781  CD1 LEU   253       2.335  32.971 -13.207  1.00 41.18           C  
ATOM   1782  CD2 LEU   253       4.480  31.688 -12.774  1.00 44.27           C  
ATOM   1783  N   LYS   254       6.051  31.725 -17.954  1.00 48.81           N  
ATOM   1784  CA  LYS   254       6.266  30.875 -19.122  1.00 49.32           C  
ATOM   1785  C   LYS   254       7.219  29.706 -18.901  1.00 49.52           C  
ATOM   1786  O   LYS   254       7.221  28.754 -19.695  1.00 49.50           O  
ATOM   1787  CB  LYS   254       6.687  31.703 -20.338  1.00 49.85           C  
ATOM   1788  CG  LYS   254       5.620  31.769 -21.438  1.00 51.80           C  
ATOM   1789  CD  LYS   254       4.301  32.361 -20.926  1.00 53.96           C  
ATOM   1790  CE  LYS   254       3.413  31.331 -20.190  1.00 54.77           C  
ATOM   1791  NZ  LYS   254       2.785  31.953 -18.947  1.00 53.07           N  
END
