
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  115 (  982),  selected  115 , name 2b7l_A
# Molecule2: number of CA atoms  135 ( 1088),  selected  135 , name T0507.pdb
# PARAMETERS: 2b7l_A.T0507.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    K     2_A      M       1          6.087
LGA    R     3_A      K       2          1.652
LGA    V     4_A      V       3          0.839
LGA    I     5_A      A       4          1.099
LGA    T     6_A      L       5          0.972
LGA    Y     7_A      G       6          1.173
LGA    G     8_A      G       7          0.787
LGA    T     9_A      T       8          0.369
LGA    Y    10_A      F       9          0.118
LGA    D    11_A      E      10          1.104
LGA    L    12_A      P      11          1.307
LGA    L    13_A      L      12          1.330
LGA    H    14_A      H      13          2.310
LGA    Y    15_A      E      14          2.856
LGA    G    16_A      G      15          2.880
LGA    H    17_A      H      16          1.651
LGA    I    18_A      K      17          1.434
LGA    E    19_A      K      18          2.007
LGA    L    20_A      L      19          1.753
LGA    L    21_A      I      20          0.676
LGA    R    22_A      D      21          0.809
LGA    R    23_A      V      22          1.377
LGA    A    24_A      A      23          1.738
LGA    R    25_A      I      24          1.451
LGA    E    26_A      K      25          1.201
LGA    M    27_A      L      26          1.408
LGA    G    28_A      G      27          1.747
LGA    D    29_A      G      28          2.331
LGA    Y    30_A      R      29          2.827
LGA    -       -      D      30           -
LGA    L    31_A      I      31          2.128
LGA    I    32_A      T      32          1.369
LGA    V    33_A      I      33          1.056
LGA    A    34_A      G      34          0.611
LGA    L    35_A      V      35          0.245
LGA    S    36_A      T      36          0.440
LGA    T    37_A      S      37          0.615
LGA    D    38_A      D      38          0.310
LGA    E    39_A      R      39          1.117
LGA    F    40_A      M      40          1.316
LGA    N    41_A      A      41          1.276
LGA    Q    42_A      R      42          2.109
LGA    I    43_A      A      43          3.122
LGA    K    44_A      R      44          3.032
LGA    H    45_A      -       -           -
LGA    K    46_A      I      45          2.254
LGA    K    47_A      R      46          2.835
LGA    S    48_A      S      47          1.412
LGA    Y    49_A      V      48          2.240
LGA    Y    50_A      L      49          1.391
LGA    D    51_A      P      50          0.963
LGA    Y    52_A      F      51          0.522
LGA    E    53_A      A      52          0.366
LGA    Q    54_A      I      53          0.499
LGA    R    55_A      R      54          0.534
LGA    K    56_A      A      55          0.625
LGA    M    57_A      E      56          0.696
LGA    M    58_A      N      57          1.069
LGA    L    59_A      V      58          0.795
LGA    E    60_A      K      59          1.124
LGA    S    61_A      R      60          1.464
LGA    I    62_A      Y      61          2.563
LGA    R    63_A      V      62          2.645
LGA    -       -      M      63           -
LGA    -       -      R      64           -
LGA    -       -      K      65           -
LGA    Y    64_A      Y      66          4.781
LGA    -       -      G      67           -
LGA    -       -      F      68           -
LGA    V    65_A      E      69           #
LGA    D    66_A      P      70          1.771
LGA    L    67_A      E      71          1.031
LGA    V    68_A      I      72          0.864
LGA    I    69_A      V      73          0.470
LGA    P    70_A      K      74          0.339
LGA    E    71_A      I      75          0.616
LGA    K    72_A      T      76          0.777
LGA    G    73_A      N      77          1.381
LGA    W    74_A      P      78          1.295
LGA    G    75_A      Y      79          3.805
LGA    Q    76_A      G      80          3.323
LGA    K    77_A      K      81          4.024
LGA    E    78_A      T      82          3.150
LGA    D    79_A      L      83          3.242
LGA    D    80_A      D      84          4.796
LGA    V    81_A      V      85          2.842
LGA    E    82_A      D      86          3.829
LGA    K    83_A      -       -           -
LGA    F    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    V    86_A      F      87          2.294
LGA    D    87_A      E      88          1.868
LGA    V    88_A      Y      89          1.194
LGA    F    89_A      L      90          0.808
LGA    V    90_A      V      91          0.893
LGA    M    91_A      V      92          0.561
LGA    G    92_A      S      93          0.504
LGA    H    93_A      P      94          2.469
LGA    D    94_A      E      95          3.162
LGA    W    95_A      T      96          3.073
LGA    E    96_A      Y      97          3.023
LGA    G    97_A      E      98          3.816
LGA    E    98_A      M      99          3.227
LGA    F    99_A      A     100          1.787
LGA    D   100_A      L     101          1.922
LGA    -       -      K     102           -
LGA    -       -      I     103           -
LGA    -       -      N     104           -
LGA    F   101_A      Q     105          2.371
LGA    L   102_A      K     106           #
LGA    K   103_A      R     107           #
LGA    D   104_A      E     108          5.089
LGA    -       -      E     109           -
LGA    -       -      L     110           -
LGA    -       -      G     111           -
LGA    -       -      K     112           -
LGA    -       -      R     113           -
LGA    K   105_A      K     114          3.061
LGA    C   106_A      I     115          1.804
LGA    E   107_A      T     116          1.571
LGA    V   108_A      I     117          1.639
LGA    I   109_A      V     118          1.532
LGA    Y   110_A      K     119          1.154
LGA    L   111_A      V     120          1.152
LGA    K   112_A      D     121          2.172
LGA    R   113_A      W     122          3.072
LGA    T   114_A      -       -           -
LGA    E   115_A      M     123          2.604
LGA    -       -      M     124           -
LGA    -       -      S     132           -
LGA    -       -      S     133           -
LGA    -       -      T     134           -
LGA    -       -      R     135           -
LGA    -       -      I     136           -
LGA    -       -      K     137           -
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      E     140           -
LGA    -       -      I     141           -
LGA    -       -      D     142           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  115  135    5.0    106    2.14    17.92     62.458     4.730

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.964271 * X  +   0.221257 * Y  +   0.145694 * Z  +  58.404701
  Y_new =  -0.169185 * X  +  -0.937524 * Y  +   0.304014 * Z  +  36.356075
  Z_new =   0.203857 * X  +   0.268502 * Y  +   0.941461 * Z  + -18.612057 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.277822   -2.863771  [ DEG:    15.9180   -164.0820 ]
  Theta =  -0.205296   -2.936297  [ DEG:   -11.7626   -168.2374 ]
  Phi   =  -2.967906    0.173686  [ DEG:  -170.0485      9.9515 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2b7l_A                                        
REMARK     2: T0507.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2b7l_A.T0507.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  115  135   5.0  106   2.14   17.92  62.458
REMARK  ---------------------------------------------------------- 
MOLECULE 2b7l_A
HEADER    TRANSFERASE                             04-OCT-05   2B7L              
TITLE     CRYSTAL STRUCTURE OF CTP:GLYCEROL-3-PHOSPHATE                         
TITLE    2 CYTIDYLYLTRANSFERASE FROM STAPHYLOCOCCUS AUREUS                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLYCEROL-3-PHOSPHATE CYTIDYLYLTRANSFERASE;                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: GCT, CDP-GLYCEROL PYROPHOSPHORYLASE, TEICHOIC               
COMPND   5 ACID BIOSYNTHESIS PROTEIN D;                                         
COMPND   6 EC: 2.7.7.39;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: W3110;                                     
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PKK223                                    
KEYWDS    CYTIDYLYLTRANSFERASE, ROSSMANN FOLD                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.H.FONG,V.C.-N.YIM,M.A.D'ELIA,E.D.BROWN,A.M.BERGHUIS                 
REVDAT   1   27-JUN-06 2B7L    0                                                
JRNL        AUTH   D.H.FONG,V.C.-N.YIM,M.A.D'ELIA,E.D.BROWN,                    
JRNL        AUTH 2 A.M.BERGHUIS                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF CTP:GLYCEROL-3-PHOSPHATE                
JRNL        TITL 2 CYTIDYLYLTRANSFERASE FROM STAPHYLOCOCCUS AUREUS:             
JRNL        TITL 3 EXAMINATION OF STRUCTURAL BASIS FOR KINETIC                  
JRNL        TITL 4 MECHANISM.                                                   
JRNL        REF    BIOCHIM.BIOPHYS.ACTA          V.1764    63 2006              
JRNL        REFN   ASTM BBACAQ  NE ISSN 0006-3002                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  2B7L A    1   132  UNP    O05155   O05155_STAAU     1    132             
DBREF  2B7L B  501   632  UNP    O05155   O05155_STAAU     1    132             
DBREF  2B7L C 1001  1132  UNP    O05155   O05155_STAAU     1    132             
DBREF  2B7L D 1501  1632  UNP    O05155   O05155_STAAU     1    132             
SEQRES   1 A  132  MET LYS ARG VAL ILE THR TYR GLY THR TYR ASP LEU LEU          
SEQRES   2 A  132  HIS TYR GLY HIS ILE GLU LEU LEU ARG ARG ALA ARG GLU          
SEQRES   3 A  132  MET GLY ASP TYR LEU ILE VAL ALA LEU SER THR ASP GLU          
SEQRES   4 A  132  PHE ASN GLN ILE LYS HIS LYS LYS SER TYR TYR ASP TYR          
SEQRES   5 A  132  GLU GLN ARG LYS MET MET LEU GLU SER ILE ARG TYR VAL          
SEQRES   6 A  132  ASP LEU VAL ILE PRO GLU LYS GLY TRP GLY GLN LYS GLU          
SEQRES   7 A  132  ASP ASP VAL GLU LYS PHE ASP VAL ASP VAL PHE VAL MET          
SEQRES   8 A  132  GLY HIS ASP TRP GLU GLY GLU PHE ASP PHE LEU LYS ASP          
SEQRES   9 A  132  LYS CYS GLU VAL ILE TYR LEU LYS ARG THR GLU GLY ILE          
SEQRES  10 A  132  SER THR THR LYS ILE LYS GLN GLU LEU TYR GLY LYS ASP          
SEQRES  11 A  132  ALA LYS                                                      
SEQRES   1 B  132  MET LYS ARG VAL ILE THR TYR GLY THR TYR ASP LEU LEU          
SEQRES   2 B  132  HIS TYR GLY HIS ILE GLU LEU LEU ARG ARG ALA ARG GLU          
SEQRES   3 B  132  MET GLY ASP TYR LEU ILE VAL ALA LEU SER THR ASP GLU          
SEQRES   4 B  132  PHE ASN GLN ILE LYS HIS LYS LYS SER TYR TYR ASP TYR          
SEQRES   5 B  132  GLU GLN ARG LYS MET MET LEU GLU SER ILE ARG TYR VAL          
SEQRES   6 B  132  ASP LEU VAL ILE PRO GLU LYS GLY TRP GLY GLN LYS GLU          
SEQRES   7 B  132  ASP ASP VAL GLU LYS PHE ASP VAL ASP VAL PHE VAL MET          
SEQRES   8 B  132  GLY HIS ASP TRP GLU GLY GLU PHE ASP PHE LEU LYS ASP          
SEQRES   9 B  132  LYS CYS GLU VAL ILE TYR LEU LYS ARG THR GLU GLY ILE          
SEQRES  10 B  132  SER THR THR LYS ILE LYS GLN GLU LEU TYR GLY LYS ASP          
SEQRES  11 B  132  ALA LYS                                                      
SEQRES   1 C  132  MET LYS ARG VAL ILE THR TYR GLY THR TYR ASP LEU LEU          
SEQRES   2 C  132  HIS TYR GLY HIS ILE GLU LEU LEU ARG ARG ALA ARG GLU          
SEQRES   3 C  132  MET GLY ASP TYR LEU ILE VAL ALA LEU SER THR ASP GLU          
SEQRES   4 C  132  PHE ASN GLN ILE LYS HIS LYS LYS SER TYR TYR ASP TYR          
SEQRES   5 C  132  GLU GLN ARG LYS MET MET LEU GLU SER ILE ARG TYR VAL          
SEQRES   6 C  132  ASP LEU VAL ILE PRO GLU LYS GLY TRP GLY GLN LYS GLU          
SEQRES   7 C  132  ASP ASP VAL GLU LYS PHE ASP VAL ASP VAL PHE VAL MET          
SEQRES   8 C  132  GLY HIS ASP TRP GLU GLY GLU PHE ASP PHE LEU LYS ASP          
SEQRES   9 C  132  LYS CYS GLU VAL ILE TYR LEU LYS ARG THR GLU GLY ILE          
SEQRES  10 C  132  SER THR THR LYS ILE LYS GLN GLU LEU TYR GLY LYS ASP          
SEQRES  11 C  132  ALA LYS                                                      
SEQRES   1 D  132  MET LYS ARG VAL ILE THR TYR GLY THR TYR ASP LEU LEU          
SEQRES   2 D  132  HIS TYR GLY HIS ILE GLU LEU LEU ARG ARG ALA ARG GLU          
SEQRES   3 D  132  MET GLY ASP TYR LEU ILE VAL ALA LEU SER THR ASP GLU          
SEQRES   4 D  132  PHE ASN GLN ILE LYS HIS LYS LYS SER TYR TYR ASP TYR          
SEQRES   5 D  132  GLU GLN ARG LYS MET MET LEU GLU SER ILE ARG TYR VAL          
SEQRES   6 D  132  ASP LEU VAL ILE PRO GLU LYS GLY TRP GLY GLN LYS GLU          
SEQRES   7 D  132  ASP ASP VAL GLU LYS PHE ASP VAL ASP VAL PHE VAL MET          
SEQRES   8 D  132  GLY HIS ASP TRP GLU GLY GLU PHE ASP PHE LEU LYS ASP          
SEQRES   9 D  132  LYS CYS GLU VAL ILE TYR LEU LYS ARG THR GLU GLY ILE          
SEQRES  10 D  132  SER THR THR LYS ILE LYS GLN GLU LEU TYR GLY LYS ASP          
SEQRES  11 D  132  ALA LYS                                                      
CRYST1   92.150   92.150  156.120  90.00  90.00 120.00 P 31 2 1     24          
ATOM      1  N   MET A   1       6.313  12.915  15.604  1.00 31.43           N  
ATOM      2  CA  MET A   1       7.538  12.597  16.402  1.00 29.60           C  
ATOM      3  C   MET A   1       7.561  13.437  17.656  1.00 28.44           C  
ATOM      4  O   MET A   1       7.700  14.653  17.591  1.00 29.39           O  
ATOM      5  CB  MET A   1       8.815  12.871  15.598  1.00 29.47           C  
ATOM      6  CG  MET A   1      10.124  12.588  16.362  1.00 30.19           C  
ATOM      7  SD  MET A   1      11.182  11.282  15.615  1.00 31.61           S  
ATOM      8  CE  MET A   1      12.248  12.258  14.511  1.00 33.41           C  
ATOM      9  N   LYS A   2       7.421  12.780  18.800  1.00 27.07           N  
ATOM     10  CA  LYS A   2       7.423  13.464  20.090  1.00 25.61           C  
ATOM     11  C   LYS A   2       8.877  13.753  20.467  1.00 25.02           C  
ATOM     12  O   LYS A   2       9.605  12.845  20.875  1.00 24.43           O  
ATOM     13  CB  LYS A   2       6.770  12.567  21.143  1.00 23.42           C  
ATOM     14  CG  LYS A   2       6.170  13.312  22.302  1.00 23.42           C  
ATOM     15  CD  LYS A   2       5.468  12.362  23.249  1.00 24.07           C  
ATOM     16  CE  LYS A   2       4.735  13.123  24.339  1.00 26.19           C  
ATOM     17  NZ  LYS A   2       4.024  12.227  25.301  1.00 28.49           N  
ATOM     18  N   ARG A   3       9.298  15.010  20.319  1.00 23.39           N  
ATOM     19  CA  ARG A   3      10.677  15.402  20.622  1.00 21.96           C  
ATOM     20  C   ARG A   3      10.844  15.912  22.033  1.00 20.91           C  
ATOM     21  O   ARG A   3      10.143  16.821  22.459  1.00 21.87           O  
ATOM     22  CB  ARG A   3      11.167  16.480  19.654  1.00 20.93           C  
ATOM     23  CG  ARG A   3      11.377  15.996  18.249  1.00 18.87           C  
ATOM     24  CD  ARG A   3      11.741  17.136  17.348  1.00 19.46           C  
ATOM     25  NE  ARG A   3      11.651  16.761  15.943  1.00 21.46           N  
ATOM     26  CZ  ARG A   3      12.216  15.677  15.426  1.00 22.58           C  
ATOM     27  NH1 ARG A   3      12.910  14.856  16.203  1.00 24.77           N  
ATOM     28  NH2 ARG A   3      12.098  15.417  14.132  1.00 22.68           N  
ATOM     29  N   VAL A   4      11.800  15.335  22.748  1.00 19.83           N  
ATOM     30  CA  VAL A   4      12.063  15.721  24.124  1.00 19.87           C  
ATOM     31  C   VAL A   4      13.382  16.471  24.236  1.00 19.18           C  
ATOM     32  O   VAL A   4      14.301  16.246  23.457  1.00 19.81           O  
ATOM     33  CB  VAL A   4      12.127  14.473  25.043  1.00 20.90           C  
ATOM     34  CG1 VAL A   4      12.128  14.897  26.502  1.00 22.71           C  
ATOM     35  CG2 VAL A   4      10.949  13.549  24.757  1.00 20.43           C  
ATOM     36  N   ILE A   5      13.470  17.370  25.206  1.00 18.42           N  
ATOM     37  CA  ILE A   5      14.691  18.122  25.413  1.00 18.18           C  
ATOM     38  C   ILE A   5      14.989  18.239  26.912  1.00 19.05           C  
ATOM     39  O   ILE A   5      14.082  18.132  27.747  1.00 18.52           O  
ATOM     40  CB  ILE A   5      14.581  19.524  24.810  1.00 17.70           C  
ATOM     41  CG1 ILE A   5      15.966  20.183  24.792  1.00 17.70           C  
ATOM     42  CG2 ILE A   5      13.585  20.352  25.625  1.00 16.73           C  
ATOM     43  CD1 ILE A   5      16.015  21.522  24.095  1.00 17.83           C  
ATOM     44  N   THR A   6      16.266  18.435  27.240  1.00 19.36           N  
ATOM     45  CA  THR A   6      16.725  18.594  28.626  1.00 19.07           C  
ATOM     46  C   THR A   6      18.036  19.369  28.598  1.00 18.89           C  
ATOM     47  O   THR A   6      18.844  19.213  27.679  1.00 19.75           O  
ATOM     48  CB  THR A   6      17.011  17.238  29.340  1.00 18.56           C  
ATOM     49  OG1 THR A   6      17.151  17.458  30.755  1.00 16.01           O  
ATOM     50  CG2 THR A   6      18.321  16.619  28.813  1.00 17.24           C  
ATOM     51  N   TYR A   7      18.255  20.189  29.616  1.00 18.35           N  
ATOM     52  CA  TYR A   7      19.464  20.989  29.690  1.00 17.60           C  
ATOM     53  C   TYR A   7      20.358  20.483  30.828  1.00 18.03           C  
ATOM     54  O   TYR A   7      19.909  19.721  31.696  1.00 17.37           O  
ATOM     55  CB  TYR A   7      19.091  22.473  29.903  1.00 17.26           C  
ATOM     56  CG  TYR A   7      18.307  23.109  28.759  1.00 18.50           C  
ATOM     57  CD1 TYR A   7      17.041  22.626  28.387  1.00 20.25           C  
ATOM     58  CD2 TYR A   7      18.841  24.173  28.025  1.00 18.14           C  
ATOM     59  CE1 TYR A   7      16.333  23.178  27.311  1.00 18.68           C  
ATOM     60  CE2 TYR A   7      18.142  24.735  26.947  1.00 18.54           C  
ATOM     61  CZ  TYR A   7      16.893  24.227  26.594  1.00 19.43           C  
ATOM     62  OH  TYR A   7      16.236  24.733  25.494  1.00 17.93           O  
ATOM     63  N   GLY A   8      21.624  20.900  30.811  1.00 17.73           N  
ATOM     64  CA  GLY A   8      22.551  20.491  31.846  1.00 17.76           C  
ATOM     65  C   GLY A   8      24.006  20.606  31.439  1.00 19.21           C  
ATOM     66  O   GLY A   8      24.314  20.868  30.275  1.00 18.97           O  
ATOM     67  N   THR A   9      24.898  20.408  32.409  1.00 20.71           N  
ATOM     68  CA  THR A   9      26.342  20.475  32.187  1.00 22.23           C  
ATOM     69  C   THR A   9      26.890  19.110  31.807  1.00 23.01           C  
ATOM     70  O   THR A   9      27.725  18.991  30.911  1.00 23.57           O  
ATOM     71  CB  THR A   9      27.081  20.931  33.467  1.00 22.22           C  
ATOM     72  OG1 THR A   9      26.890  22.335  33.658  1.00 23.45           O  
ATOM     73  CG2 THR A   9      28.572  20.634  33.368  1.00 23.29           C  
ATOM     74  N   TYR A  10      26.420  18.086  32.512  1.00 23.98           N  
ATOM     75  CA  TYR A  10      26.861  16.710  32.274  1.00 24.79           C  
ATOM     76  C   TYR A  10      28.382  16.619  32.197  1.00 24.79           C  
ATOM     77  O   TYR A  10      28.939  16.274  31.157  1.00 24.96           O  
ATOM     78  CB  TYR A  10      26.230  16.167  30.983  1.00 24.07           C  
ATOM     79  CG  TYR A  10      24.741  15.949  31.113  1.00 24.33           C  
ATOM     80  CD1 TYR A  10      24.232  14.772  31.681  1.00 24.10           C  
ATOM     81  CD2 TYR A  10      23.842  16.954  30.755  1.00 22.69           C  
ATOM     82  CE1 TYR A  10      22.856  14.608  31.891  1.00 24.39           C  
ATOM     83  CE2 TYR A  10      22.472  16.803  30.963  1.00 23.65           C  
ATOM     84  CZ  TYR A  10      21.979  15.633  31.531  1.00 24.13           C  
ATOM     85  OH  TYR A  10      20.619  15.504  31.748  1.00 23.15           O  
ATOM     86  N   ASP A  11      29.055  16.916  33.301  1.00 24.98           N  
ATOM     87  CA  ASP A  11      30.500  16.862  33.293  1.00 25.44           C  
ATOM     88  C   ASP A  11      31.050  15.454  33.557  1.00 25.48           C  
ATOM     89  O   ASP A  11      31.330  14.722  32.606  1.00 26.16           O  
ATOM     90  CB  ASP A  11      31.060  17.888  34.278  1.00 26.28           C  
ATOM     91  CG  ASP A  11      32.540  18.151  34.065  1.00 26.49           C  
ATOM     92  OD1 ASP A  11      33.010  18.123  32.906  1.00 26.77           O  
ATOM     93  OD2 ASP A  11      33.235  18.398  35.063  1.00 27.64           O  
ATOM     94  N   LEU A  12      31.213  15.067  34.819  1.00 25.09           N  
ATOM     95  CA  LEU A  12      31.723  13.729  35.119  1.00 25.45           C  
ATOM     96  C   LEU A  12      30.532  12.769  35.184  1.00 25.71           C  
ATOM     97  O   LEU A  12      30.118  12.392  36.264  1.00 24.74           O  
ATOM     98  CB  LEU A  12      32.432  13.695  36.483  1.00 26.19           C  
ATOM     99  CG  LEU A  12      33.682  14.513  36.845  1.00 28.11           C  
ATOM    100  CD1 LEU A  12      33.363  16.003  36.917  1.00 28.15           C  
ATOM    101  CD2 LEU A  12      34.199  14.038  38.206  1.00 27.80           C  
ATOM    102  N   LEU A  13      29.954  12.349  34.072  1.00 26.33           N  
ATOM    103  CA  LEU A  13      28.802  11.453  34.195  1.00 25.88           C  
ATOM    104  C   LEU A  13      28.948  10.276  35.186  1.00 25.91           C  
ATOM    105  O   LEU A  13      29.982   9.619  35.249  1.00 25.68           O  
ATOM    106  CB  LEU A  13      28.438  10.896  32.818  1.00 25.08           C  
ATOM    107  CG  LEU A  13      28.122  11.926  31.738  1.00 24.18           C  
ATOM    108  CD1 LEU A  13      27.729  11.198  30.453  1.00 22.99           C  
ATOM    109  CD2 LEU A  13      27.008  12.854  32.221  1.00 23.22           C  
ATOM    110  N   HIS A  14      27.916  10.042  35.988  1.00 27.02           N  
ATOM    111  CA  HIS A  14      27.889   8.889  36.894  1.00 29.50           C  
ATOM    112  C   HIS A  14      26.543   8.305  36.498  1.00 29.19           C  
ATOM    113  O   HIS A  14      25.665   9.070  36.134  1.00 29.38           O  
ATOM    114  CB  HIS A  14      27.932   9.295  38.369  1.00 31.88           C  
ATOM    115  CG  HIS A  14      26.823  10.200  38.790  1.00 35.15           C  
ATOM    116  ND1 HIS A  14      25.495   9.919  38.549  1.00 35.86           N  
ATOM    117  CD2 HIS A  14      26.845  11.367  39.477  1.00 36.46           C  
ATOM    118  CE1 HIS A  14      24.747  10.876  39.067  1.00 37.25           C  
ATOM    119  NE2 HIS A  14      25.541  11.768  39.636  1.00 36.72           N  
ATOM    120  N   TYR A  15      26.368   6.985  36.545  1.00 29.94           N  
ATOM    121  CA  TYR A  15      25.116   6.384  36.061  1.00 30.55           C  
ATOM    122  C   TYR A  15      23.849   7.168  36.360  1.00 28.30           C  
ATOM    123  O   TYR A  15      22.797   6.977  35.725  1.00 26.26           O  
ATOM    124  CB  TYR A  15      24.927   4.936  36.542  1.00 35.30           C  
ATOM    125  CG  TYR A  15      23.848   4.245  35.713  1.00 38.75           C  
ATOM    126  CD1 TYR A  15      24.044   4.013  34.343  1.00 38.15           C  
ATOM    127  CD2 TYR A  15      22.589   3.965  36.252  1.00 38.85           C  
ATOM    128  CE1 TYR A  15      23.021   3.542  33.538  1.00 37.96           C  
ATOM    129  CE2 TYR A  15      21.557   3.489  35.445  1.00 39.18           C  
ATOM    130  CZ  TYR A  15      21.781   3.286  34.090  1.00 38.83           C  
ATOM    131  OH  TYR A  15      20.754   2.862  33.277  1.00 39.77           O  
ATOM    132  N   GLY A  16      23.962   8.060  37.328  1.00 25.68           N  
ATOM    133  CA  GLY A  16      22.833   8.883  37.685  1.00 21.42           C  
ATOM    134  C   GLY A  16      22.339   9.676  36.491  1.00 20.71           C  
ATOM    135  O   GLY A  16      21.143   9.757  36.248  1.00 19.22           O  
ATOM    136  N   HIS A  17      23.256  10.262  35.732  1.00 21.25           N  
ATOM    137  CA  HIS A  17      22.862  11.046  34.573  1.00 21.00           C  
ATOM    138  C   HIS A  17      22.223  10.160  33.514  1.00 20.84           C  
ATOM    139  O   HIS A  17      21.215  10.530  32.917  1.00 19.77           O  
ATOM    140  CB  HIS A  17      24.069  11.786  34.010  1.00 21.80           C  
ATOM    141  CG  HIS A  17      24.862  12.505  35.052  1.00 21.48           C  
ATOM    142  ND1 HIS A  17      25.569  11.844  36.035  1.00 21.87           N  
ATOM    143  CD2 HIS A  17      25.046  13.825  35.280  1.00 22.70           C  
ATOM    144  CE1 HIS A  17      26.153  12.728  36.822  1.00 21.44           C  
ATOM    145  NE2 HIS A  17      25.852  13.936  36.387  1.00 23.06           N  
ATOM    146  N   ILE A  18      22.813   8.991  33.294  1.00 20.86           N  
ATOM    147  CA  ILE A  18      22.302   8.050  32.317  1.00 22.04           C  
ATOM    148  C   ILE A  18      20.846   7.725  32.666  1.00 22.29           C  
ATOM    149  O   ILE A  18      19.986   7.651  31.779  1.00 22.09           O  
ATOM    150  CB  ILE A  18      23.177   6.745  32.299  1.00 23.30           C  
ATOM    151  CG1 ILE A  18      24.645   7.080  31.984  1.00 21.18           C  
ATOM    152  CG2 ILE A  18      22.660   5.777  31.237  1.00 24.24           C  
ATOM    153  CD1 ILE A  18      24.907   7.425  30.536  1.00 16.87           C  
ATOM    154  N   GLU A  19      20.554   7.554  33.950  1.00 21.39           N  
ATOM    155  CA  GLU A  19      19.188   7.237  34.300  1.00 22.60           C  
ATOM    156  C   GLU A  19      18.236   8.380  33.936  1.00 22.55           C  
ATOM    157  O   GLU A  19      17.170   8.147  33.378  1.00 21.46           O  
ATOM    158  CB  GLU A  19      19.081   6.845  35.769  1.00 24.57           C  
ATOM    159  CG  GLU A  19      17.804   6.068  36.097  1.00 26.71           C  
ATOM    160  CD  GLU A  19      17.328   5.163  34.951  1.00 27.91           C  
ATOM    161  OE1 GLU A  19      18.158   4.429  34.358  1.00 27.68           O  
ATOM    162  OE2 GLU A  19      16.109   5.189  34.659  1.00 26.49           O  
ATOM    163  N   LEU A  20      18.635   9.614  34.218  1.00 24.32           N  
ATOM    164  CA  LEU A  20      17.820  10.777  33.884  1.00 25.54           C  
ATOM    165  C   LEU A  20      17.557  10.821  32.364  1.00 25.90           C  
ATOM    166  O   LEU A  20      16.411  10.919  31.912  1.00 25.60           O  
ATOM    167  CB  LEU A  20      18.555  12.038  34.336  1.00 26.18           C  
ATOM    168  CG  LEU A  20      17.675  13.249  34.618  1.00 27.91           C  
ATOM    169  CD1 LEU A  20      18.463  14.262  35.445  1.00 28.21           C  
ATOM    170  CD2 LEU A  20      17.179  13.840  33.301  1.00 29.11           C  
ATOM    171  N   LEU A  21      18.633  10.737  31.585  1.00 26.06           N  
ATOM    172  CA  LEU A  21      18.541  10.764  30.133  1.00 25.35           C  
ATOM    173  C   LEU A  21      17.630   9.680  29.585  1.00 25.40           C  
ATOM    174  O   LEU A  21      16.780   9.953  28.735  1.00 25.42           O  
ATOM    175  CB  LEU A  21      19.930  10.620  29.508  1.00 25.00           C  
ATOM    176  CG  LEU A  21      20.921  11.739  29.826  1.00 25.61           C  
ATOM    177  CD1 LEU A  21      22.256  11.452  29.156  1.00 25.72           C  
ATOM    178  CD2 LEU A  21      20.356  13.068  29.346  1.00 25.68           C  
ATOM    179  N   ARG A  22      17.802   8.451  30.060  1.00 25.38           N  
ATOM    180  CA  ARG A  22      16.976   7.355  29.568  1.00 25.10           C  
ATOM    181  C   ARG A  22      15.499   7.645  29.850  1.00 25.70           C  
ATOM    182  O   ARG A  22      14.658   7.524  28.963  1.00 24.49           O  
ATOM    183  CB  ARG A  22      17.409   6.048  30.215  1.00 24.37           C  
ATOM    184  CG  ARG A  22      16.802   4.808  29.604  1.00 23.72           C  
ATOM    185  CD  ARG A  22      17.079   3.601  30.506  1.00 25.29           C  
ATOM    186  NE  ARG A  22      16.493   3.753  31.837  1.00 22.25           N  
ATOM    187  CZ  ARG A  22      15.197   3.609  32.094  1.00 23.68           C  
ATOM    188  NH1 ARG A  22      14.352   3.304  31.115  1.00 23.41           N  
ATOM    189  NH2 ARG A  22      14.739   3.779  33.325  1.00 24.82           N  
ATOM    190  N   ARG A  23      15.189   8.041  31.081  1.00 26.42           N  
ATOM    191  CA  ARG A  23      13.819   8.360  31.441  1.00 28.40           C  
ATOM    192  C   ARG A  23      13.292   9.479  30.542  1.00 27.91           C  
ATOM    193  O   ARG A  23      12.155   9.426  30.071  1.00 28.39           O  
ATOM    194  CB  ARG A  23      13.743   8.774  32.916  1.00 31.59           C  
ATOM    195  CG  ARG A  23      13.727   7.594  33.887  1.00 36.51           C  
ATOM    196  CD  ARG A  23      13.604   8.038  35.350  1.00 40.87           C  
ATOM    197  NE  ARG A  23      14.898   8.375  35.942  1.00 45.42           N  
ATOM    198  CZ  ARG A  23      15.063   8.911  37.152  1.00 47.43           C  
ATOM    199  NH1 ARG A  23      14.003   9.180  37.909  1.00 46.78           N  
ATOM    200  NH2 ARG A  23      16.291   9.170  37.607  1.00 47.57           N  
ATOM    201  N   ALA A  24      14.124  10.489  30.301  1.00 26.38           N  
ATOM    202  CA  ALA A  24      13.729  11.601  29.448  1.00 25.06           C  
ATOM    203  C   ALA A  24      13.411  11.100  28.048  1.00 24.72           C  
ATOM    204  O   ALA A  24      12.317  11.329  27.542  1.00 25.04           O  
ATOM    205  CB  ALA A  24      14.830  12.628  29.387  1.00 25.25           C  
ATOM    206  N   ARG A  25      14.365  10.409  27.425  1.00 24.24           N  
ATOM    207  CA  ARG A  25      14.152   9.886  26.081  1.00 23.06           C  
ATOM    208  C   ARG A  25      12.929   8.989  26.020  1.00 23.93           C  
ATOM    209  O   ARG A  25      12.263   8.880  24.992  1.00 23.68           O  
ATOM    210  CB  ARG A  25      15.346   9.083  25.595  1.00 20.40           C  
ATOM    211  CG  ARG A  25      15.464   9.183  24.100  1.00 18.41           C  
ATOM    212  CD  ARG A  25      16.038   7.967  23.459  1.00 16.20           C  
ATOM    213  NE  ARG A  25      15.001   7.087  22.932  1.00 16.42           N  
ATOM    214  CZ  ARG A  25      13.992   7.476  22.159  1.00 14.79           C  
ATOM    215  NH1 ARG A  25      13.866   8.752  21.820  1.00 14.76           N  
ATOM    216  NH2 ARG A  25      13.120   6.578  21.710  1.00 13.48           N  
ATOM    217  N   GLU A  26      12.646   8.344  27.140  1.00 25.50           N  
ATOM    218  CA  GLU A  26      11.519   7.440  27.258  1.00 26.89           C  
ATOM    219  C   GLU A  26      10.182   8.135  27.045  1.00 26.87           C  
ATOM    220  O   GLU A  26       9.195   7.495  26.710  1.00 28.42           O  
ATOM    221  CB  GLU A  26      11.528   6.804  28.646  1.00 28.17           C  
ATOM    222  CG  GLU A  26      11.534   5.294  28.658  1.00 30.62           C  
ATOM    223  CD  GLU A  26      11.031   4.744  29.974  1.00 32.60           C  
ATOM    224  OE1 GLU A  26      11.568   5.147  31.029  1.00 33.00           O  
ATOM    225  OE2 GLU A  26      10.096   3.911  29.950  1.00 33.70           O  
ATOM    226  N   MET A  27      10.146   9.443  27.244  1.00 26.62           N  
ATOM    227  CA  MET A  27       8.909  10.190  27.099  1.00 27.64           C  
ATOM    228  C   MET A  27       8.598  10.656  25.685  1.00 27.35           C  
ATOM    229  O   MET A  27       7.608  11.347  25.460  1.00 27.99           O  
ATOM    230  CB  MET A  27       8.944  11.382  28.034  1.00 27.69           C  
ATOM    231  CG  MET A  27       9.268  10.957  29.426  1.00 31.12           C  
ATOM    232  SD  MET A  27       8.974  12.265  30.574  1.00 38.37           S  
ATOM    233  CE  MET A  27       7.163  12.377  30.484  1.00 38.38           C  
ATOM    234  N   GLY A  28       9.442  10.279  24.734  1.00 26.63           N  
ATOM    235  CA  GLY A  28       9.221  10.682  23.359  1.00 25.89           C  
ATOM    236  C   GLY A  28       9.876   9.715  22.399  1.00 25.55           C  
ATOM    237  O   GLY A  28      10.089   8.559  22.734  1.00 25.88           O  
ATOM    238  N   ASP A  29      10.203  10.181  21.202  1.00 26.19           N  
ATOM    239  CA  ASP A  29      10.847   9.316  20.216  1.00 26.37           C  
ATOM    240  C   ASP A  29      12.205   9.877  19.835  1.00 25.43           C  
ATOM    241  O   ASP A  29      12.939   9.269  19.055  1.00 25.30           O  
ATOM    242  CB  ASP A  29      10.005   9.226  18.948  1.00 28.14           C  
ATOM    243  CG  ASP A  29       8.572   8.874  19.229  1.00 31.29           C  
ATOM    244  OD1 ASP A  29       8.344   7.779  19.803  1.00 32.64           O  
ATOM    245  OD2 ASP A  29       7.684   9.695  18.874  1.00 31.28           O  
ATOM    246  N   TYR A  30      12.549  11.022  20.412  1.00 23.82           N  
ATOM    247  CA  TYR A  30      13.780  11.702  20.061  1.00 21.53           C  
ATOM    248  C   TYR A  30      14.208  12.599  21.227  1.00 21.38           C  
ATOM    249  O   TYR A  30      13.415  13.411  21.703  1.00 22.86           O  
ATOM    250  CB  TYR A  30      13.450  12.507  18.798  1.00 20.22           C  
ATOM    251  CG  TYR A  30      14.538  13.330  18.185  1.00 18.96           C  
ATOM    252  CD1 TYR A  30      14.873  14.580  18.702  1.00 18.86           C  
ATOM    253  CD2 TYR A  30      15.208  12.882  17.055  1.00 17.75           C  
ATOM    254  CE1 TYR A  30      15.851  15.361  18.099  1.00 18.13           C  
ATOM    255  CE2 TYR A  30      16.184  13.653  16.450  1.00 17.50           C  
ATOM    256  CZ  TYR A  30      16.497  14.887  16.975  1.00 17.02           C  
ATOM    257  OH  TYR A  30      17.454  15.643  16.365  1.00 18.07           O  
ATOM    258  N   LEU A  31      15.448  12.459  21.691  1.00 19.56           N  
ATOM    259  CA  LEU A  31      15.909  13.283  22.804  1.00 18.57           C  
ATOM    260  C   LEU A  31      17.038  14.237  22.478  1.00 18.95           C  
ATOM    261  O   LEU A  31      18.076  13.843  21.955  1.00 18.81           O  
ATOM    262  CB  LEU A  31      16.342  12.419  23.987  1.00 17.69           C  
ATOM    263  CG  LEU A  31      16.971  13.181  25.167  1.00 17.86           C  
ATOM    264  CD1 LEU A  31      16.012  14.239  25.708  1.00 16.52           C  
ATOM    265  CD2 LEU A  31      17.332  12.192  26.262  1.00 18.23           C  
ATOM    266  N   ILE A  32      16.825  15.505  22.808  1.00 19.60           N  
ATOM    267  CA  ILE A  32      17.827  16.530  22.586  1.00 18.81           C  
ATOM    268  C   ILE A  32      18.393  16.934  23.939  1.00 19.26           C  
ATOM    269  O   ILE A  32      17.667  17.059  24.924  1.00 19.02           O  
ATOM    270  CB  ILE A  32      17.240  17.792  21.935  1.00 17.55           C  
ATOM    271  CG1 ILE A  32      16.541  17.440  20.626  1.00 15.43           C  
ATOM    272  CG2 ILE A  32      18.355  18.803  21.702  1.00 15.53           C  
ATOM    273  CD1 ILE A  32      15.872  18.626  19.978  1.00 14.87           C  
ATOM    274  N   VAL A  33      19.701  17.124  23.987  1.00 19.78           N  
ATOM    275  CA  VAL A  33      20.335  17.553  25.218  1.00 19.68           C  
ATOM    276  C   VAL A  33      21.026  18.871  24.914  1.00 20.38           C  
ATOM    277  O   VAL A  33      21.854  18.968  24.001  1.00 21.01           O  
ATOM    278  CB  VAL A  33      21.389  16.541  25.723  1.00 19.64           C  
ATOM    279  CG1 VAL A  33      21.896  16.978  27.081  1.00 19.33           C  
ATOM    280  CG2 VAL A  33      20.803  15.150  25.792  1.00 18.09           C  
ATOM    281  N   ALA A  34      20.655  19.898  25.660  1.00 20.65           N  
ATOM    282  CA  ALA A  34      21.257  21.204  25.477  1.00 21.52           C  
ATOM    283  C   ALA A  34      22.431  21.271  26.453  1.00 21.47           C  
ATOM    284  O   ALA A  34      22.263  21.576  27.635  1.00 20.25           O  
ATOM    285  CB  ALA A  34      20.241  22.292  25.772  1.00 21.46           C  
ATOM    286  N   LEU A  35      23.616  20.963  25.936  1.00 21.31           N  
ATOM    287  CA  LEU A  35      24.834  20.945  26.723  1.00 21.93           C  
ATOM    288  C   LEU A  35      25.368  22.341  27.002  1.00 24.14           C  
ATOM    289  O   LEU A  35      25.603  23.132  26.086  1.00 24.15           O  
ATOM    290  CB  LEU A  35      25.889  20.121  25.994  1.00 20.01           C  
ATOM    291  CG  LEU A  35      27.226  19.869  26.684  1.00 19.27           C  
ATOM    292  CD1 LEU A  35      27.032  18.977  27.915  1.00 17.42           C  
ATOM    293  CD2 LEU A  35      28.170  19.219  25.679  1.00 16.20           C  
ATOM    294  N   SER A  36      25.561  22.632  28.283  1.00 26.04           N  
ATOM    295  CA  SER A  36      26.065  23.924  28.716  1.00 27.54           C  
ATOM    296  C   SER A  36      27.462  24.125  28.159  1.00 29.05           C  
ATOM    297  O   SER A  36      28.333  23.278  28.338  1.00 29.61           O  
ATOM    298  CB  SER A  36      26.111  23.970  30.243  1.00 27.25           C  
ATOM    299  OG  SER A  36      24.850  23.609  30.791  1.00 29.20           O  
ATOM    300  N   THR A  37      27.671  25.242  27.474  1.00 30.55           N  
ATOM    301  CA  THR A  37      28.974  25.563  26.909  1.00 31.07           C  
ATOM    302  C   THR A  37      29.892  25.854  28.078  1.00 31.96           C  
ATOM    303  O   THR A  37      29.429  26.032  29.205  1.00 30.91           O  
ATOM    304  CB  THR A  37      28.900  26.827  26.055  1.00 31.75           C  
ATOM    305  OG1 THR A  37      28.752  27.972  26.912  1.00 31.39           O  
ATOM    306  CG2 THR A  37      27.701  26.755  25.121  1.00 31.19           C  
ATOM    307  N   ASP A  38      31.191  25.922  27.824  1.00 33.91           N  
ATOM    308  CA  ASP A  38      32.098  26.209  28.922  1.00 35.47           C  
ATOM    309  C   ASP A  38      31.943  27.657  29.396  1.00 36.22           C  
ATOM    310  O   ASP A  38      32.089  27.940  30.581  1.00 35.91           O  
ATOM    311  CB  ASP A  38      33.537  25.844  28.540  1.00 34.61           C  
ATOM    312  CG  ASP A  38      33.756  24.327  28.523  1.00 34.14           C  
ATOM    313  OD1 ASP A  38      33.437  23.660  29.537  1.00 32.95           O  
ATOM    314  OD2 ASP A  38      34.238  23.798  27.501  1.00 34.04           O  
ATOM    315  N   GLU A  39      31.600  28.561  28.485  1.00 37.59           N  
ATOM    316  CA  GLU A  39      31.382  29.950  28.864  1.00 39.64           C  
ATOM    317  C   GLU A  39      30.174  30.040  29.805  1.00 40.14           C  
ATOM    318  O   GLU A  39      30.269  30.629  30.882  1.00 39.73           O  
ATOM    319  CB  GLU A  39      31.124  30.809  27.630  1.00 41.89           C  
ATOM    320  CG  GLU A  39      32.330  30.970  26.733  1.00 45.94           C  
ATOM    321  CD  GLU A  39      32.984  29.646  26.400  1.00 47.33           C  
ATOM    322  OE1 GLU A  39      32.275  28.725  25.937  1.00 48.38           O  
ATOM    323  OE2 GLU A  39      34.209  29.532  26.604  1.00 49.27           O  
ATOM    324  N   PHE A  40      29.038  29.456  29.415  1.00 40.73           N  
ATOM    325  CA  PHE A  40      27.830  29.490  30.255  1.00 40.73           C  
ATOM    326  C   PHE A  40      28.042  28.654  31.503  1.00 41.49           C  
ATOM    327  O   PHE A  40      27.506  28.941  32.575  1.00 39.95           O  
ATOM    328  CB  PHE A  40      26.607  28.945  29.501  1.00 39.61           C  
ATOM    329  CG  PHE A  40      25.374  28.776  30.372  1.00 38.00           C  
ATOM    330  CD1 PHE A  40      24.818  29.862  31.049  1.00 37.94           C  
ATOM    331  CD2 PHE A  40      24.772  27.535  30.518  1.00 35.96           C  
ATOM    332  CE1 PHE A  40      23.683  29.709  31.855  1.00 34.88           C  
ATOM    333  CE2 PHE A  40      23.640  27.380  31.321  1.00 34.19           C  
ATOM    334  CZ  PHE A  40      23.099  28.468  31.987  1.00 32.93           C  
ATOM    335  N   ASN A  41      28.819  27.595  31.341  1.00 43.66           N  
ATOM    336  CA  ASN A  41      29.118  26.710  32.445  1.00 45.20           C  
ATOM    337  C   ASN A  41      29.724  27.608  33.514  1.00 45.22           C  
ATOM    338  O   ASN A  41      29.428  27.477  34.707  1.00 44.23           O  
ATOM    339  CB  ASN A  41      30.115  25.648  31.984  1.00 46.31           C  
ATOM    340  CG  ASN A  41      29.926  24.329  32.693  1.00 48.15           C  
ATOM    341  OD1 ASN A  41      30.442  23.303  32.248  1.00 50.08           O  
ATOM    342  ND2 ASN A  41      29.191  24.343  33.806  1.00 47.24           N  
ATOM    343  N   GLN A  42      30.557  28.542  33.058  1.00 45.47           N  
ATOM    344  CA  GLN A  42      31.209  29.488  33.947  1.00 45.74           C  
ATOM    345  C   GLN A  42      30.126  30.372  34.544  1.00 44.88           C  
ATOM    346  O   GLN A  42      30.076  30.568  35.761  1.00 45.34           O  
ATOM    347  CB  GLN A  42      32.218  30.338  33.175  1.00 47.88           C  
ATOM    348  CG  GLN A  42      33.224  31.076  34.064  1.00 51.00           C  
ATOM    349  CD  GLN A  42      33.988  30.135  34.992  1.00 52.53           C  
ATOM    350  OE1 GLN A  42      34.512  29.106  34.557  1.00 54.50           O  
ATOM    351  NE2 GLN A  42      34.060  30.489  36.274  1.00 51.96           N  
ATOM    352  N   ILE A  43      29.256  30.897  33.686  1.00 43.09           N  
ATOM    353  CA  ILE A  43      28.157  31.741  34.140  1.00 41.49           C  
ATOM    354  C   ILE A  43      27.428  31.041  35.284  1.00 41.38           C  
ATOM    355  O   ILE A  43      27.053  31.668  36.270  1.00 40.82           O  
ATOM    356  CB  ILE A  43      27.139  31.997  33.017  1.00 40.81           C  
ATOM    357  CG1 ILE A  43      27.819  32.696  31.834  1.00 40.36           C  
ATOM    358  CG2 ILE A  43      25.976  32.810  33.551  1.00 40.20           C  
ATOM    359  CD1 ILE A  43      28.388  34.062  32.144  1.00 39.15           C  
ATOM    360  N   LYS A  44      27.230  29.736  35.145  1.00 41.92           N  
ATOM    361  CA  LYS A  44      26.552  28.966  36.176  1.00 42.04           C  
ATOM    362  C   LYS A  44      27.435  28.761  37.393  1.00 43.13           C  
ATOM    363  O   LYS A  44      27.071  28.037  38.317  1.00 43.00           O  
ATOM    364  CB  LYS A  44      26.122  27.607  35.637  1.00 41.35           C  
ATOM    365  CG  LYS A  44      24.808  27.613  34.894  1.00 39.62           C  
ATOM    366  CD  LYS A  44      24.275  26.196  34.744  1.00 40.01           C  
ATOM    367  CE  LYS A  44      25.024  25.403  33.687  1.00 40.23           C  
ATOM    368  NZ  LYS A  44      26.482  25.279  33.954  1.00 42.23           N  
ATOM    369  N   HIS A  45      28.598  29.398  37.389  1.00 44.84           N  
ATOM    370  CA  HIS A  45      29.534  29.282  38.502  1.00 46.88           C  
ATOM    371  C   HIS A  45      30.068  27.868  38.676  1.00 46.94           C  
ATOM    372  O   HIS A  45      29.994  27.270  39.756  1.00 44.95           O  
ATOM    373  CB  HIS A  45      28.880  29.788  39.788  1.00 48.30           C  
ATOM    374  CG  HIS A  45      28.845  31.281  39.875  1.00 50.71           C  
ATOM    375  ND1 HIS A  45      28.635  32.081  38.771  1.00 51.27           N  
ATOM    376  CD2 HIS A  45      29.026  32.121  40.921  1.00 51.68           C  
ATOM    377  CE1 HIS A  45      28.692  33.349  39.131  1.00 51.51           C  
ATOM    378  NE2 HIS A  45      28.928  33.401  40.430  1.00 52.93           N  
ATOM    379  N   LYS A  46      30.610  27.355  37.576  1.00 47.89           N  
ATOM    380  CA  LYS A  46      31.203  26.028  37.511  1.00 48.30           C  
ATOM    381  C   LYS A  46      32.372  26.084  36.540  1.00 47.08           C  
ATOM    382  O   LYS A  46      32.435  26.947  35.663  1.00 47.12           O  
ATOM    383  CB  LYS A  46      30.191  24.994  37.009  1.00 50.22           C  
ATOM    384  CG  LYS A  46      29.002  24.777  37.923  1.00 53.25           C  
ATOM    385  CD  LYS A  46      29.439  24.360  39.324  1.00 54.94           C  
ATOM    386  CE  LYS A  46      28.223  24.110  40.217  1.00 57.20           C  
ATOM    387  NZ  LYS A  46      27.307  25.293  40.291  1.00 56.79           N  
ATOM    388  N   LYS A  47      33.296  25.153  36.708  1.00 45.48           N  
ATOM    389  CA  LYS A  47      34.461  25.066  35.847  1.00 43.22           C  
ATOM    390  C   LYS A  47      34.611  23.574  35.559  1.00 40.89           C  
ATOM    391  O   LYS A  47      35.425  22.882  36.172  1.00 41.64           O  
ATOM    392  CB  LYS A  47      35.680  25.637  36.581  1.00 43.64           C  
ATOM    393  CG  LYS A  47      36.934  25.765  35.741  1.00 45.27           C  
ATOM    394  CD  LYS A  47      37.842  26.884  36.270  1.00 47.09           C  
ATOM    395  CE  LYS A  47      38.161  26.720  37.760  1.00 47.31           C  
ATOM    396  NZ  LYS A  47      39.046  27.798  38.291  1.00 45.47           N  
ATOM    397  N   SER A  48      33.793  23.087  34.628  1.00 37.01           N  
ATOM    398  CA  SER A  48      33.783  21.680  34.261  1.00 34.01           C  
ATOM    399  C   SER A  48      35.174  21.073  34.140  1.00 31.54           C  
ATOM    400  O   SER A  48      36.122  21.740  33.729  1.00 30.88           O  
ATOM    401  CB  SER A  48      33.050  21.510  32.928  1.00 34.26           C  
ATOM    402  OG  SER A  48      33.691  22.241  31.897  0.00 34.16           O  
ATOM    403  N   TYR A  49      35.273  19.800  34.502  1.00 29.09           N  
ATOM    404  CA  TYR A  49      36.505  19.032  34.424  1.00 26.67           C  
ATOM    405  C   TYR A  49      36.745  18.743  32.941  1.00 25.36           C  
ATOM    406  O   TYR A  49      37.859  18.860  32.429  1.00 25.11           O  
ATOM    407  CB  TYR A  49      36.312  17.720  35.186  1.00 25.31           C  
ATOM    408  CG  TYR A  49      37.503  16.814  35.165  1.00 24.57           C  
ATOM    409  CD1 TYR A  49      38.593  17.049  35.996  1.00 23.96           C  
ATOM    410  CD2 TYR A  49      37.555  15.729  34.294  1.00 25.18           C  
ATOM    411  CE1 TYR A  49      39.710  16.224  35.957  1.00 25.35           C  
ATOM    412  CE2 TYR A  49      38.669  14.896  34.246  1.00 25.16           C  
ATOM    413  CZ  TYR A  49      39.743  15.151  35.080  1.00 25.21           C  
ATOM    414  OH  TYR A  49      40.852  14.339  35.030  1.00 25.18           O  
ATOM    415  N   TYR A  50      35.673  18.361  32.261  1.00 23.75           N  
ATOM    416  CA  TYR A  50      35.725  18.062  30.842  1.00 23.60           C  
ATOM    417  C   TYR A  50      35.217  19.263  30.048  1.00 23.52           C  
ATOM    418  O   TYR A  50      34.218  19.886  30.422  1.00 22.59           O  
ATOM    419  CB  TYR A  50      34.846  16.852  30.534  1.00 24.43           C  
ATOM    420  CG  TYR A  50      35.358  15.555  31.096  1.00 24.30           C  
ATOM    421  CD1 TYR A  50      36.558  15.010  30.646  1.00 23.61           C  
ATOM    422  CD2 TYR A  50      34.636  14.860  32.071  1.00 25.12           C  
ATOM    423  CE1 TYR A  50      37.033  13.802  31.147  1.00 23.80           C  
ATOM    424  CE2 TYR A  50      35.105  13.643  32.581  1.00 24.65           C  
ATOM    425  CZ  TYR A  50      36.304  13.125  32.110  1.00 24.19           C  
ATOM    426  OH  TYR A  50      36.774  11.927  32.579  1.00 24.90           O  
ATOM    427  N   ASP A  51      35.891  19.585  28.947  1.00 22.93           N  
ATOM    428  CA  ASP A  51      35.473  20.720  28.136  1.00 22.64           C  
ATOM    429  C   ASP A  51      34.239  20.362  27.320  1.00 22.69           C  
ATOM    430  O   ASP A  51      33.945  19.178  27.106  1.00 22.36           O  
ATOM    431  CB  ASP A  51      36.610  21.169  27.210  1.00 22.49           C  
ATOM    432  CG  ASP A  51      36.750  20.304  25.978  1.00 24.93           C  
ATOM    433  OD1 ASP A  51      37.789  20.412  25.299  1.00 26.91           O  
ATOM    434  OD2 ASP A  51      35.829  19.522  25.664  1.00 27.93           O  
ATOM    435  N   TYR A  52      33.527  21.390  26.865  1.00 21.61           N  
ATOM    436  CA  TYR A  52      32.320  21.223  26.060  1.00 21.27           C  
ATOM    437  C   TYR A  52      32.401  20.098  25.029  1.00 22.51           C  
ATOM    438  O   TYR A  52      31.553  19.200  24.986  1.00 22.44           O  
ATOM    439  CB  TYR A  52      32.010  22.511  25.311  1.00 18.35           C  
ATOM    440  CG  TYR A  52      30.788  22.387  24.449  1.00 16.87           C  
ATOM    441  CD1 TYR A  52      29.515  22.543  24.998  1.00 18.15           C  
ATOM    442  CD2 TYR A  52      30.893  22.076  23.094  1.00 15.18           C  
ATOM    443  CE1 TYR A  52      28.369  22.393  24.219  1.00 18.64           C  
ATOM    444  CE2 TYR A  52      29.758  21.920  22.305  1.00 16.13           C  
ATOM    445  CZ  TYR A  52      28.495  22.082  22.873  1.00 17.67           C  
ATOM    446  OH  TYR A  52      27.355  21.949  22.105  1.00 18.16           O  
ATOM    447  N   GLU A  53      33.411  20.167  24.176  1.00 23.62           N  
ATOM    448  CA  GLU A  53      33.578  19.167  23.145  1.00 26.20           C  
ATOM    449  C   GLU A  53      33.582  17.746  23.686  1.00 25.99           C  
ATOM    450  O   GLU A  53      32.837  16.884  23.205  1.00 25.04           O  
ATOM    451  CB  GLU A  53      34.859  19.442  22.371  1.00 30.88           C  
ATOM    452  CG  GLU A  53      34.691  20.532  21.332  1.00 36.31           C  
ATOM    453  CD  GLU A  53      33.546  20.232  20.375  1.00 38.87           C  
ATOM    454  OE1 GLU A  53      33.575  19.154  19.736  1.00 40.47           O  
ATOM    455  OE2 GLU A  53      32.623  21.071  20.266  1.00 40.29           O  
ATOM    456  N   GLN A  54      34.421  17.508  24.689  1.00 25.18           N  
ATOM    457  CA  GLN A  54      34.524  16.192  25.303  1.00 25.01           C  
ATOM    458  C   GLN A  54      33.209  15.767  25.934  1.00 25.07           C  
ATOM    459  O   GLN A  54      32.803  14.613  25.817  1.00 25.27           O  
ATOM    460  CB  GLN A  54      35.607  16.223  26.361  1.00 24.47           C  
ATOM    461  CG  GLN A  54      36.852  16.868  25.844  1.00 24.30           C  
ATOM    462  CD  GLN A  54      37.858  17.123  26.922  1.00 23.46           C  
ATOM    463  OE1 GLN A  54      37.528  17.627  28.006  1.00 22.09           O  
ATOM    464  NE2 GLN A  54      39.106  16.797  26.630  1.00 22.27           N  
ATOM    465  N   ARG A  55      32.546  16.700  26.610  1.00 25.37           N  
ATOM    466  CA  ARG A  55      31.270  16.395  27.243  1.00 25.39           C  
ATOM    467  C   ARG A  55      30.245  16.066  26.166  1.00 25.25           C  
ATOM    468  O   ARG A  55      29.408  15.170  26.332  1.00 23.09           O  
ATOM    469  CB  ARG A  55      30.816  17.578  28.106  1.00 24.90           C  
ATOM    470  CG  ARG A  55      31.731  17.773  29.295  1.00 26.02           C  
ATOM    471  CD  ARG A  55      31.245  18.809  30.269  1.00 28.37           C  
ATOM    472  NE  ARG A  55      31.434  20.166  29.772  1.00 31.33           N  
ATOM    473  CZ  ARG A  55      30.462  20.931  29.282  1.00 32.49           C  
ATOM    474  NH1 ARG A  55      29.217  20.475  29.215  1.00 33.44           N  
ATOM    475  NH2 ARG A  55      30.734  22.163  28.878  1.00 33.44           N  
ATOM    476  N   LYS A  56      30.338  16.780  25.049  1.00 26.12           N  
ATOM    477  CA  LYS A  56      29.422  16.563  23.938  1.00 27.37           C  
ATOM    478  C   LYS A  56      29.626  15.174  23.347  1.00 27.29           C  
ATOM    479  O   LYS A  56      28.667  14.433  23.131  1.00 27.92           O  
ATOM    480  CB  LYS A  56      29.623  17.615  22.844  1.00 27.02           C  
ATOM    481  CG  LYS A  56      28.759  17.369  21.620  1.00 26.34           C  
ATOM    482  CD  LYS A  56      28.788  18.552  20.683  1.00 28.22           C  
ATOM    483  CE  LYS A  56      27.976  18.292  19.427  1.00 28.64           C  
ATOM    484  NZ  LYS A  56      28.655  17.299  18.552  1.00 29.58           N  
ATOM    485  N   MET A  57      30.883  14.828  23.095  1.00 25.94           N  
ATOM    486  CA  MET A  57      31.220  13.536  22.525  1.00 24.95           C  
ATOM    487  C   MET A  57      30.683  12.376  23.362  1.00 23.90           C  
ATOM    488  O   MET A  57      30.169  11.382  22.826  1.00 23.17           O  
ATOM    489  CB  MET A  57      32.732  13.415  22.418  1.00 25.65           C  
ATOM    490  CG  MET A  57      33.170  12.237  21.584  1.00 27.96           C  
ATOM    491  SD  MET A  57      34.933  11.996  21.639  1.00 28.22           S  
ATOM    492  CE  MET A  57      35.024  10.355  22.374  1.00 27.79           C  
ATOM    493  N   MET A  58      30.816  12.503  24.678  1.00 21.68           N  
ATOM    494  CA  MET A  58      30.347  11.467  25.579  1.00 20.57           C  
ATOM    495  C   MET A  58      28.833  11.356  25.505  1.00 20.86           C  
ATOM    496  O   MET A  58      28.293  10.262  25.375  1.00 20.22           O  
ATOM    497  CB  MET A  58      30.776  11.768  27.014  1.00 19.94           C  
ATOM    498  CG  MET A  58      30.230  10.802  28.051  1.00 17.79           C  
ATOM    499  SD  MET A  58      30.875   9.146  27.858  1.00 16.18           S  
ATOM    500  CE  MET A  58      30.933   8.614  29.530  1.00 15.09           C  
ATOM    501  N   LEU A  59      28.142  12.485  25.585  1.00 21.45           N  
ATOM    502  CA  LEU A  59      26.691  12.455  25.520  1.00 21.67           C  
ATOM    503  C   LEU A  59      26.244  11.772  24.241  1.00 21.49           C  
ATOM    504  O   LEU A  59      25.419  10.857  24.267  1.00 22.87           O  
ATOM    505  CB  LEU A  59      26.113  13.873  25.562  1.00 22.30           C  
ATOM    506  CG  LEU A  59      26.111  14.584  26.921  1.00 24.50           C  
ATOM    507  CD1 LEU A  59      25.560  16.000  26.780  1.00 24.49           C  
ATOM    508  CD2 LEU A  59      25.271  13.785  27.910  1.00 24.21           C  
ATOM    509  N   GLU A  60      26.802  12.208  23.120  1.00 21.03           N  
ATOM    510  CA  GLU A  60      26.424  11.657  21.818  1.00 22.01           C  
ATOM    511  C   GLU A  60      26.602  10.149  21.733  1.00 21.53           C  
ATOM    512  O   GLU A  60      25.905   9.478  20.976  1.00 22.22           O  
ATOM    513  CB  GLU A  60      27.221  12.321  20.687  1.00 22.47           C  
ATOM    514  CG  GLU A  60      27.279  13.848  20.781  1.00 24.95           C  
ATOM    515  CD  GLU A  60      27.693  14.525  19.482  1.00 25.31           C  
ATOM    516  OE1 GLU A  60      28.709  14.106  18.885  1.00 26.49           O  
ATOM    517  OE2 GLU A  60      26.995  15.484  19.069  1.00 23.89           O  
ATOM    518  N   SER A  61      27.531   9.617  22.513  1.00 20.65           N  
ATOM    519  CA  SER A  61      27.783   8.185  22.498  1.00 20.23           C  
ATOM    520  C   SER A  61      26.721   7.412  23.282  1.00 21.02           C  
ATOM    521  O   SER A  61      26.689   6.175  23.249  1.00 20.96           O  
ATOM    522  CB  SER A  61      29.153   7.896  23.101  1.00 20.38           C  
ATOM    523  OG  SER A  61      29.123   8.072  24.508  1.00 19.68           O  
ATOM    524  N   ILE A  62      25.860   8.138  23.991  1.00 20.86           N  
ATOM    525  CA  ILE A  62      24.816   7.510  24.786  1.00 21.28           C  
ATOM    526  C   ILE A  62      23.579   7.168  23.949  1.00 21.94           C  
ATOM    527  O   ILE A  62      22.982   8.044  23.313  1.00 21.37           O  
ATOM    528  CB  ILE A  62      24.391   8.419  25.957  1.00 22.15           C  
ATOM    529  CG1 ILE A  62      25.604   8.758  26.822  1.00 22.79           C  
ATOM    530  CG2 ILE A  62      23.351   7.719  26.814  1.00 22.30           C  
ATOM    531  CD1 ILE A  62      26.291   7.546  27.371  1.00 23.48           C  
ATOM    532  N   ARG A  63      23.215   5.885  23.963  1.00 21.53           N  
ATOM    533  CA  ARG A  63      22.058   5.353  23.244  1.00 21.19           C  
ATOM    534  C   ARG A  63      20.812   6.224  23.279  1.00 20.91           C  
ATOM    535  O   ARG A  63      20.067   6.298  22.310  1.00 21.19           O  
ATOM    536  CB  ARG A  63      21.626   4.004  23.835  1.00 23.97           C  
ATOM    537  CG  ARG A  63      22.584   2.873  23.655  1.00 27.68           C  
ATOM    538  CD  ARG A  63      21.977   1.522  24.031  1.00 26.66           C  
ATOM    539  NE  ARG A  63      22.948   0.481  23.718  1.00 26.87           N  
ATOM    540  CZ  ARG A  63      23.440   0.293  22.499  1.00 27.64           C  
ATOM    541  NH1 ARG A  63      23.033   1.065  21.507  1.00 27.47           N  
ATOM    542  NH2 ARG A  63      24.364  -0.631  22.273  1.00 29.36           N  
ATOM    543  N   TYR A  64      20.562   6.859  24.411  1.00 20.32           N  
ATOM    544  CA  TYR A  64      19.354   7.642  24.549  1.00 20.00           C  
ATOM    545  C   TYR A  64      19.438   9.058  24.016  1.00 20.31           C  
ATOM    546  O   TYR A  64      18.424   9.714  23.820  1.00 21.23           O  
ATOM    547  CB  TYR A  64      18.927   7.610  26.010  1.00 20.13           C  
ATOM    548  CG  TYR A  64      19.082   6.220  26.584  1.00 21.12           C  
ATOM    549  CD1 TYR A  64      18.540   5.118  25.924  1.00 21.96           C  
ATOM    550  CD2 TYR A  64      19.804   5.997  27.757  1.00 21.60           C  
ATOM    551  CE1 TYR A  64      18.714   3.833  26.413  1.00 22.57           C  
ATOM    552  CE2 TYR A  64      19.980   4.715  28.255  1.00 21.74           C  
ATOM    553  CZ  TYR A  64      19.431   3.637  27.577  1.00 23.12           C  
ATOM    554  OH  TYR A  64      19.579   2.356  28.060  1.00 25.14           O  
ATOM    555  N   VAL A  65      20.646   9.518  23.742  1.00 20.57           N  
ATOM    556  CA  VAL A  65      20.843  10.869  23.229  1.00 20.46           C  
ATOM    557  C   VAL A  65      20.803  10.913  21.696  1.00 20.63           C  
ATOM    558  O   VAL A  65      21.644  10.301  21.041  1.00 20.89           O  
ATOM    559  CB  VAL A  65      22.202  11.420  23.716  1.00 19.67           C  
ATOM    560  CG1 VAL A  65      22.543  12.725  22.992  1.00 18.38           C  
ATOM    561  CG2 VAL A  65      22.156  11.615  25.223  1.00 18.66           C  
ATOM    562  N   ASP A  66      19.835  11.644  21.141  1.00 19.98           N  
ATOM    563  CA  ASP A  66      19.671  11.791  19.687  1.00 20.05           C  
ATOM    564  C   ASP A  66      20.361  13.021  19.112  1.00 18.98           C  
ATOM    565  O   ASP A  66      20.690  13.060  17.928  1.00 19.27           O  
ATOM    566  CB  ASP A  66      18.194  11.915  19.323  1.00 22.41           C  
ATOM    567  CG  ASP A  66      17.425  10.646  19.551  1.00 26.59           C  
ATOM    568  OD1 ASP A  66      17.373   9.802  18.623  1.00 28.31           O  
ATOM    569  OD2 ASP A  66      16.875  10.494  20.663  1.00 28.70           O  
ATOM    570  N   LEU A  67      20.546  14.039  19.940  1.00 17.59           N  
ATOM    571  CA  LEU A  67      21.160  15.265  19.473  1.00 16.57           C  
ATOM    572  C   LEU A  67      21.612  16.117  20.640  1.00 18.38           C  
ATOM    573  O   LEU A  67      20.925  16.211  21.661  1.00 19.01           O  
ATOM    574  CB  LEU A  67      20.154  16.040  18.642  1.00 13.99           C  
ATOM    575  CG  LEU A  67      20.666  17.194  17.799  1.00 11.93           C  
ATOM    576  CD1 LEU A  67      21.155  16.664  16.456  1.00 11.59           C  
ATOM    577  CD2 LEU A  67      19.537  18.184  17.597  1.00 12.04           C  
ATOM    578  N   VAL A  68      22.777  16.735  20.493  1.00 19.65           N  
ATOM    579  CA  VAL A  68      23.298  17.592  21.544  1.00 20.94           C  
ATOM    580  C   VAL A  68      23.472  18.982  20.947  1.00 22.38           C  
ATOM    581  O   VAL A  68      24.100  19.144  19.901  1.00 24.27           O  
ATOM    582  CB  VAL A  68      24.660  17.080  22.079  1.00 20.27           C  
ATOM    583  CG1 VAL A  68      25.074  17.879  23.300  1.00 20.11           C  
ATOM    584  CG2 VAL A  68      24.561  15.615  22.440  1.00 20.96           C  
ATOM    585  N   ILE A  69      22.884  19.980  21.594  1.00 22.32           N  
ATOM    586  CA  ILE A  69      23.007  21.348  21.120  1.00 21.23           C  
ATOM    587  C   ILE A  69      23.620  22.167  22.244  1.00 21.73           C  
ATOM    588  O   ILE A  69      23.515  21.811  23.418  1.00 21.57           O  
ATOM    589  CB  ILE A  69      21.635  21.948  20.730  1.00 20.12           C  
ATOM    590  CG1 ILE A  69      20.747  22.090  21.972  1.00 18.48           C  
ATOM    591  CG2 ILE A  69      20.981  21.080  19.660  1.00 18.93           C  
ATOM    592  CD1 ILE A  69      19.438  22.789  21.707  1.00 15.12           C  
ATOM    593  N   PRO A  70      24.273  23.278  21.901  1.00 22.03           N  
ATOM    594  CA  PRO A  70      24.885  24.102  22.937  1.00 23.35           C  
ATOM    595  C   PRO A  70      23.904  25.005  23.704  1.00 24.71           C  
ATOM    596  O   PRO A  70      23.069  25.693  23.106  1.00 23.59           O  
ATOM    597  CB  PRO A  70      25.906  24.908  22.148  1.00 22.17           C  
ATOM    598  CG  PRO A  70      25.161  25.186  20.897  1.00 21.29           C  
ATOM    599  CD  PRO A  70      24.548  23.833  20.565  1.00 21.54           C  
ATOM    600  N   GLU A  71      24.007  24.976  25.032  1.00 25.60           N  
ATOM    601  CA  GLU A  71      23.200  25.826  25.897  1.00 26.38           C  
ATOM    602  C   GLU A  71      24.149  26.982  26.232  1.00 27.83           C  
ATOM    603  O   GLU A  71      25.049  26.835  27.063  1.00 27.47           O  
ATOM    604  CB  GLU A  71      22.795  25.081  27.176  1.00 24.46           C  
ATOM    605  CG  GLU A  71      22.231  26.018  28.238  1.00 25.63           C  
ATOM    606  CD  GLU A  71      21.701  25.316  29.478  1.00 25.46           C  
ATOM    607  OE1 GLU A  71      22.421  24.476  30.063  1.00 25.05           O  
ATOM    608  OE2 GLU A  71      20.558  25.627  29.882  1.00 26.14           O  
ATOM    609  N   LYS A  72      23.953  28.125  25.581  1.00 28.58           N  
ATOM    610  CA  LYS A  72      24.832  29.261  25.791  1.00 29.59           C  
ATOM    611  C   LYS A  72      24.355  30.272  26.836  1.00 31.02           C  
ATOM    612  O   LYS A  72      25.128  31.118  27.287  1.00 31.36           O  
ATOM    613  CB  LYS A  72      25.082  29.929  24.440  1.00 29.73           C  
ATOM    614  CG  LYS A  72      25.406  28.909  23.344  1.00 31.12           C  
ATOM    615  CD  LYS A  72      25.601  29.540  21.973  1.00 33.25           C  
ATOM    616  CE  LYS A  72      26.851  30.416  21.922  1.00 35.40           C  
ATOM    617  NZ  LYS A  72      26.986  31.128  20.607  1.00 37.30           N  
ATOM    618  N   GLY A  73      23.096  30.173  27.245  1.00 32.21           N  
ATOM    619  CA  GLY A  73      22.586  31.112  28.230  1.00 33.68           C  
ATOM    620  C   GLY A  73      21.246  30.726  28.823  1.00 35.81           C  
ATOM    621  O   GLY A  73      20.611  29.753  28.387  1.00 37.91           O  
ATOM    622  N   TRP A  74      20.803  31.501  29.811  1.00 35.52           N  
ATOM    623  CA  TRP A  74      19.541  31.232  30.492  1.00 35.71           C  
ATOM    624  C   TRP A  74      18.270  31.462  29.677  1.00 35.94           C  
ATOM    625  O   TRP A  74      17.282  30.747  29.849  1.00 36.01           O  
ATOM    626  CB  TRP A  74      19.451  32.059  31.773  1.00 35.30           C  
ATOM    627  CG  TRP A  74      20.387  31.627  32.838  1.00 35.11           C  
ATOM    628  CD1 TRP A  74      21.511  32.277  33.258  1.00 35.70           C  
ATOM    629  CD2 TRP A  74      20.294  30.433  33.624  1.00 35.21           C  
ATOM    630  NE1 TRP A  74      22.128  31.562  34.260  1.00 36.08           N  
ATOM    631  CE2 TRP A  74      21.403  30.424  34.504  1.00 35.54           C  
ATOM    632  CE3 TRP A  74      19.383  29.366  33.670  1.00 34.15           C  
ATOM    633  CZ2 TRP A  74      21.628  29.389  35.421  1.00 34.26           C  
ATOM    634  CZ3 TRP A  74      19.608  28.333  34.584  1.00 33.72           C  
ATOM    635  CH2 TRP A  74      20.723  28.355  35.445  1.00 33.53           C  
ATOM    636  N   GLY A  75      18.287  32.450  28.791  1.00 36.06           N  
ATOM    637  CA  GLY A  75      17.088  32.739  28.029  1.00 36.55           C  
ATOM    638  C   GLY A  75      17.011  32.234  26.604  1.00 37.33           C  
ATOM    639  O   GLY A  75      16.648  32.996  25.706  1.00 38.94           O  
ATOM    640  N   GLN A  76      17.334  30.966  26.377  1.00 36.44           N  
ATOM    641  CA  GLN A  76      17.270  30.429  25.025  1.00 34.59           C  
ATOM    642  C   GLN A  76      16.243  29.306  24.938  1.00 34.07           C  
ATOM    643  O   GLN A  76      15.846  28.902  23.846  1.00 33.89           O  
ATOM    644  CB  GLN A  76      18.644  29.909  24.599  1.00 34.80           C  
ATOM    645  CG  GLN A  76      19.128  28.695  25.383  1.00 36.21           C  
ATOM    646  CD  GLN A  76      20.350  28.038  24.754  1.00 36.19           C  
ATOM    647  OE1 GLN A  76      21.458  28.570  24.816  1.00 35.35           O  
ATOM    648  NE2 GLN A  76      20.144  26.877  24.133  1.00 35.24           N  
ATOM    649  N   LYS A  77      15.810  28.816  26.096  1.00 33.63           N  
ATOM    650  CA  LYS A  77      14.838  27.728  26.165  1.00 33.22           C  
ATOM    651  C   LYS A  77      13.618  27.941  25.284  1.00 33.92           C  
ATOM    652  O   LYS A  77      13.384  27.186  24.341  1.00 34.30           O  
ATOM    653  CB  LYS A  77      14.376  27.512  27.605  1.00 32.23           C  
ATOM    654  CG  LYS A  77      15.409  26.855  28.497  1.00 32.19           C  
ATOM    655  CD  LYS A  77      14.808  26.471  29.836  1.00 32.31           C  
ATOM    656  CE  LYS A  77      15.790  25.668  30.672  1.00 31.83           C  
ATOM    657  NZ  LYS A  77      17.032  26.438  30.939  1.00 32.03           N  
ATOM    658  N   GLU A  78      12.833  28.961  25.601  1.00 34.83           N  
ATOM    659  CA  GLU A  78      11.640  29.257  24.826  1.00 36.10           C  
ATOM    660  C   GLU A  78      11.977  29.168  23.339  1.00 36.49           C  
ATOM    661  O   GLU A  78      11.281  28.511  22.557  1.00 36.39           O  
ATOM    662  CB  GLU A  78      11.135  30.660  25.171  1.00 36.39           C  
ATOM    663  CG  GLU A  78      10.758  30.844  26.630  0.00 36.48           C  
ATOM    664  CD  GLU A  78      10.264  32.246  26.933  0.00 36.59           C  
ATOM    665  OE1 GLU A  78      11.032  33.207  26.719  0.00 36.65           O  
ATOM    666  OE2 GLU A  78       9.108  32.384  27.382  0.00 36.65           O  
ATOM    667  N   ASP A  79      13.069  29.813  22.956  1.00 36.83           N  
ATOM    668  CA  ASP A  79      13.463  29.797  21.566  1.00 37.64           C  
ATOM    669  C   ASP A  79      13.809  28.400  21.082  1.00 37.61           C  
ATOM    670  O   ASP A  79      13.350  27.985  20.015  1.00 37.19           O  
ATOM    671  CB  ASP A  79      14.628  30.738  21.333  1.00 39.42           C  
ATOM    672  CG  ASP A  79      14.392  31.626  20.152  1.00 41.27           C  
ATOM    673  OD1 ASP A  79      14.244  31.083  19.032  1.00 42.41           O  
ATOM    674  OD2 ASP A  79      14.331  32.859  20.345  1.00 43.13           O  
ATOM    675  N   ASP A  80      14.614  27.678  21.861  1.00 36.60           N  
ATOM    676  CA  ASP A  80      14.992  26.318  21.497  1.00 34.92           C  
ATOM    677  C   ASP A  80      13.741  25.487  21.228  1.00 33.71           C  
ATOM    678  O   ASP A  80      13.602  24.890  20.161  1.00 33.75           O  
ATOM    679  CB  ASP A  80      15.800  25.665  22.618  1.00 35.43           C  
ATOM    680  CG  ASP A  80      17.181  26.275  22.777  1.00 37.55           C  
ATOM    681  OD1 ASP A  80      17.755  26.702  21.748  1.00 38.44           O  
ATOM    682  OD2 ASP A  80      17.696  26.307  23.922  1.00 36.50           O  
ATOM    683  N   VAL A  81      12.832  25.465  22.198  1.00 31.60           N  
ATOM    684  CA  VAL A  81      11.594  24.706  22.082  1.00 30.01           C  
ATOM    685  C   VAL A  81      10.928  24.903  20.726  1.00 30.31           C  
ATOM    686  O   VAL A  81      10.487  23.945  20.096  1.00 29.07           O  
ATOM    687  CB  VAL A  81      10.593  25.103  23.187  1.00 28.78           C  
ATOM    688  CG1 VAL A  81       9.275  24.409  22.966  1.00 28.08           C  
ATOM    689  CG2 VAL A  81      11.143  24.732  24.547  1.00 28.32           C  
ATOM    690  N   GLU A  82      10.848  26.149  20.274  1.00 31.07           N  
ATOM    691  CA  GLU A  82      10.228  26.418  18.982  1.00 31.61           C  
ATOM    692  C   GLU A  82      11.156  26.016  17.843  1.00 31.52           C  
ATOM    693  O   GLU A  82      10.752  25.282  16.950  1.00 32.17           O  
ATOM    694  CB  GLU A  82       9.848  27.898  18.846  1.00 30.96           C  
ATOM    695  CG  GLU A  82       9.158  28.245  17.536  0.00 31.28           C  
ATOM    696  CD  GLU A  82       7.856  27.493  17.347  0.00 31.26           C  
ATOM    697  OE1 GLU A  82       6.947  27.656  18.189  0.00 31.32           O  
ATOM    698  OE2 GLU A  82       7.739  26.740  16.358  0.00 31.32           O  
ATOM    699  N   LYS A  83      12.402  26.478  17.893  1.00 31.33           N  
ATOM    700  CA  LYS A  83      13.386  26.186  16.855  1.00 30.03           C  
ATOM    701  C   LYS A  83      13.605  24.706  16.580  1.00 29.88           C  
ATOM    702  O   LYS A  83      13.863  24.320  15.445  1.00 29.87           O  
ATOM    703  CB  LYS A  83      14.731  26.828  17.203  1.00 28.87           C  
ATOM    704  CG  LYS A  83      15.740  26.707  16.079  1.00 29.59           C  
ATOM    705  CD  LYS A  83      17.062  27.407  16.366  1.00 32.13           C  
ATOM    706  CE  LYS A  83      17.967  27.385  15.116  1.00 35.11           C  
ATOM    707  NZ  LYS A  83      19.323  28.010  15.271  1.00 35.29           N  
ATOM    708  N   PHE A  84      13.521  23.875  17.613  1.00 29.86           N  
ATOM    709  CA  PHE A  84      13.728  22.444  17.426  1.00 29.34           C  
ATOM    710  C   PHE A  84      12.463  21.617  17.534  1.00 30.59           C  
ATOM    711  O   PHE A  84      12.521  20.397  17.656  1.00 31.05           O  
ATOM    712  CB  PHE A  84      14.766  21.915  18.404  1.00 26.45           C  
ATOM    713  CG  PHE A  84      16.123  22.469  18.173  1.00 25.06           C  
ATOM    714  CD1 PHE A  84      16.571  23.563  18.897  1.00 25.39           C  
ATOM    715  CD2 PHE A  84      16.946  21.927  17.201  1.00 24.84           C  
ATOM    716  CE1 PHE A  84      17.819  24.106  18.657  1.00 24.03           C  
ATOM    717  CE2 PHE A  84      18.196  22.463  16.953  1.00 23.97           C  
ATOM    718  CZ  PHE A  84      18.632  23.555  17.683  1.00 24.07           C  
ATOM    719  N   ASP A  85      11.318  22.284  17.488  1.00 31.63           N  
ATOM    720  CA  ASP A  85      10.042  21.591  17.555  1.00 32.55           C  
ATOM    721  C   ASP A  85       9.988  20.625  18.745  1.00 32.16           C  
ATOM    722  O   ASP A  85       9.647  19.454  18.599  1.00 31.45           O  
ATOM    723  CB  ASP A  85       9.824  20.833  16.241  1.00 34.34           C  
ATOM    724  CG  ASP A  85       8.402  20.314  16.083  1.00 37.65           C  
ATOM    725  OD1 ASP A  85       7.462  21.140  16.066  1.00 38.13           O  
ATOM    726  OD2 ASP A  85       8.223  19.077  15.965  1.00 40.67           O  
ATOM    727  N   VAL A  86      10.329  21.131  19.925  1.00 32.08           N  
ATOM    728  CA  VAL A  86      10.319  20.331  21.140  1.00 31.13           C  
ATOM    729  C   VAL A  86       8.908  20.148  21.675  1.00 31.07           C  
ATOM    730  O   VAL A  86       8.169  21.114  21.839  1.00 31.16           O  
ATOM    731  CB  VAL A  86      11.153  20.991  22.238  1.00 30.61           C  
ATOM    732  CG1 VAL A  86      10.801  20.386  23.583  1.00 30.82           C  
ATOM    733  CG2 VAL A  86      12.622  20.808  21.942  1.00 30.35           C  
ATOM    734  N   ASP A  87       8.541  18.907  21.958  1.00 31.60           N  
ATOM    735  CA  ASP A  87       7.214  18.618  22.495  1.00 32.07           C  
ATOM    736  C   ASP A  87       7.240  18.520  24.013  1.00 30.65           C  
ATOM    737  O   ASP A  87       6.327  18.980  24.694  1.00 29.95           O  
ATOM    738  CB  ASP A  87       6.669  17.289  21.965  1.00 35.22           C  
ATOM    739  CG  ASP A  87       6.401  17.312  20.484  1.00 39.10           C  
ATOM    740  OD1 ASP A  87       5.670  18.219  20.023  1.00 41.86           O  
ATOM    741  OD2 ASP A  87       6.913  16.415  19.780  1.00 40.73           O  
ATOM    742  N   VAL A  88       8.289  17.906  24.541  1.00 28.99           N  
ATOM    743  CA  VAL A  88       8.406  17.711  25.975  1.00 28.09           C  
ATOM    744  C   VAL A  88       9.704  18.278  26.523  1.00 26.96           C  
ATOM    745  O   VAL A  88      10.774  18.056  25.959  1.00 28.03           O  
ATOM    746  CB  VAL A  88       8.348  16.207  26.309  1.00 29.14           C  
ATOM    747  CG1 VAL A  88       8.483  15.990  27.804  1.00 29.57           C  
ATOM    748  CG2 VAL A  88       7.047  15.616  25.791  1.00 29.00           C  
ATOM    749  N   PHE A  89       9.595  19.005  27.630  1.00 24.74           N  
ATOM    750  CA  PHE A  89      10.738  19.618  28.293  1.00 23.57           C  
ATOM    751  C   PHE A  89      10.965  18.882  29.611  1.00 23.91           C  
ATOM    752  O   PHE A  89      10.109  18.903  30.486  1.00 23.62           O  
ATOM    753  CB  PHE A  89      10.427  21.096  28.548  1.00 22.05           C  
ATOM    754  CG  PHE A  89      11.500  21.829  29.302  1.00 21.81           C  
ATOM    755  CD1 PHE A  89      11.575  21.751  30.682  1.00 20.32           C  
ATOM    756  CD2 PHE A  89      12.457  22.583  28.622  1.00 22.66           C  
ATOM    757  CE1 PHE A  89      12.581  22.406  31.370  1.00 20.44           C  
ATOM    758  CE2 PHE A  89      13.473  23.244  29.310  1.00 20.84           C  
ATOM    759  CZ  PHE A  89      13.533  23.153  30.683  1.00 20.27           C  
ATOM    760  N   VAL A  90      12.111  18.228  29.757  1.00 25.01           N  
ATOM    761  CA  VAL A  90      12.388  17.482  30.979  1.00 26.04           C  
ATOM    762  C   VAL A  90      13.612  17.980  31.739  1.00 27.61           C  
ATOM    763  O   VAL A  90      14.628  18.339  31.145  1.00 27.91           O  
ATOM    764  CB  VAL A  90      12.606  15.984  30.685  1.00 25.56           C  
ATOM    765  CG1 VAL A  90      12.839  15.238  31.987  1.00 24.59           C  
ATOM    766  CG2 VAL A  90      11.416  15.410  29.929  1.00 25.03           C  
ATOM    767  N   MET A  91      13.496  17.986  33.063  1.00 28.96           N  
ATOM    768  CA  MET A  91      14.570  18.405  33.950  1.00 31.02           C  
ATOM    769  C   MET A  91      14.487  17.606  35.241  1.00 33.24           C  
ATOM    770  O   MET A  91      13.455  16.996  35.535  1.00 33.25           O  
ATOM    771  CB  MET A  91      14.457  19.889  34.262  1.00 30.45           C  
ATOM    772  CG  MET A  91      14.870  20.779  33.111  1.00 33.46           C  
ATOM    773  SD  MET A  91      16.647  20.761  32.722  1.00 34.50           S  
ATOM    774  CE  MET A  91      17.253  21.854  34.034  1.00 35.53           C  
ATOM    775  N   GLY A  92      15.574  17.608  36.006  1.00 35.34           N  
ATOM    776  CA  GLY A  92      15.590  16.876  37.258  1.00 38.90           C  
ATOM    777  C   GLY A  92      14.624  17.469  38.267  1.00 41.22           C  
ATOM    778  O   GLY A  92      14.152  18.600  38.095  1.00 40.55           O  
ATOM    779  N   HIS A  93      14.333  16.716  39.325  1.00 43.65           N  
ATOM    780  CA  HIS A  93      13.403  17.195  40.345  1.00 46.08           C  
ATOM    781  C   HIS A  93      13.861  18.488  41.001  1.00 46.19           C  
ATOM    782  O   HIS A  93      13.039  19.322  41.377  1.00 45.26           O  
ATOM    783  CB  HIS A  93      13.168  16.148  41.440  1.00 48.42           C  
ATOM    784  CG  HIS A  93      12.113  16.543  42.428  1.00 50.29           C  
ATOM    785  ND1 HIS A  93      10.843  16.928  42.047  1.00 51.35           N  
ATOM    786  CD2 HIS A  93      12.138  16.624  43.779  1.00 51.90           C  
ATOM    787  CE1 HIS A  93      10.133  17.229  43.121  1.00 51.46           C  
ATOM    788  NE2 HIS A  93      10.895  17.053  44.185  1.00 52.68           N  
ATOM    789  N   ASP A  94      15.169  18.666  41.132  1.00 46.77           N  
ATOM    790  CA  ASP A  94      15.677  19.865  41.768  1.00 46.67           C  
ATOM    791  C   ASP A  94      15.473  21.147  40.989  1.00 45.18           C  
ATOM    792  O   ASP A  94      16.000  22.190  41.350  1.00 45.82           O  
ATOM    793  CB  ASP A  94      17.135  19.669  42.137  1.00 50.50           C  
ATOM    794  CG  ASP A  94      17.292  18.693  43.283  1.00 54.99           C  
ATOM    795  OD1 ASP A  94      17.011  17.486  43.079  1.00 55.95           O  
ATOM    796  OD2 ASP A  94      17.669  19.141  44.392  1.00 57.71           O  
ATOM    797  N   TRP A  95      14.688  21.078  39.924  1.00 43.64           N  
ATOM    798  CA  TRP A  95      14.402  22.263  39.127  1.00 41.95           C  
ATOM    799  C   TRP A  95      12.910  22.533  39.141  1.00 42.15           C  
ATOM    800  O   TRP A  95      12.431  23.492  38.537  1.00 40.15           O  
ATOM    801  CB  TRP A  95      14.862  22.070  37.688  1.00 40.96           C  
ATOM    802  CG  TRP A  95      16.310  22.070  37.561  1.00 37.69           C  
ATOM    803  CD1 TRP A  95      17.133  21.009  37.685  1.00 37.47           C  
ATOM    804  CD2 TRP A  95      17.139  23.210  37.361  1.00 36.79           C  
ATOM    805  NE1 TRP A  95      18.439  21.411  37.579  1.00 37.94           N  
ATOM    806  CE2 TRP A  95      18.468  22.764  37.378  1.00 36.79           C  
ATOM    807  CE3 TRP A  95      16.886  24.570  37.169  1.00 36.35           C  
ATOM    808  CZ2 TRP A  95      19.551  23.630  37.212  1.00 36.74           C  
ATOM    809  CZ3 TRP A  95      17.957  25.431  37.003  1.00 36.03           C  
ATOM    810  CH2 TRP A  95      19.274  24.958  37.026  1.00 35.69           C  
ATOM    811  N   GLU A  96      12.184  21.667  39.837  1.00 43.50           N  
ATOM    812  CA  GLU A  96      10.738  21.773  39.941  1.00 44.61           C  
ATOM    813  C   GLU A  96      10.296  23.221  40.045  1.00 44.65           C  
ATOM    814  O   GLU A  96      10.807  23.973  40.870  1.00 44.04           O  
ATOM    815  CB  GLU A  96      10.254  20.998  41.160  1.00 45.81           C  
ATOM    816  CG  GLU A  96       8.758  20.944  41.319  1.00 48.96           C  
ATOM    817  CD  GLU A  96       8.329  19.742  42.138  1.00 53.20           C  
ATOM    818  OE1 GLU A  96       8.706  19.652  43.332  1.00 55.35           O  
ATOM    819  OE2 GLU A  96       7.623  18.872  41.582  1.00 55.22           O  
ATOM    820  N   GLY A  97       9.357  23.606  39.185  1.00 44.97           N  
ATOM    821  CA  GLY A  97       8.834  24.958  39.198  1.00 43.69           C  
ATOM    822  C   GLY A  97       9.677  26.005  38.502  1.00 43.56           C  
ATOM    823  O   GLY A  97       9.148  26.986  37.986  1.00 43.62           O  
ATOM    824  N   GLU A  98      10.985  25.795  38.477  1.00 44.13           N  
ATOM    825  CA  GLU A  98      11.916  26.742  37.865  1.00 45.04           C  
ATOM    826  C   GLU A  98      11.707  27.058  36.373  1.00 44.37           C  
ATOM    827  O   GLU A  98      12.205  28.075  35.887  1.00 43.59           O  
ATOM    828  CB  GLU A  98      13.340  26.223  38.073  1.00 47.44           C  
ATOM    829  CG  GLU A  98      14.446  27.195  37.714  1.00 50.26           C  
ATOM    830  CD  GLU A  98      14.719  28.191  38.819  1.00 52.22           C  
ATOM    831  OE1 GLU A  98      15.699  28.961  38.696  1.00 53.29           O  
ATOM    832  OE2 GLU A  98      13.951  28.198  39.809  1.00 53.76           O  
ATOM    833  N   PHE A  99      10.984  26.202  35.647  1.00 43.78           N  
ATOM    834  CA  PHE A  99      10.774  26.430  34.217  1.00 42.68           C  
ATOM    835  C   PHE A  99       9.338  26.324  33.733  1.00 42.59           C  
ATOM    836  O   PHE A  99       9.088  26.126  32.542  1.00 42.29           O  
ATOM    837  CB  PHE A  99      11.668  25.485  33.423  1.00 41.59           C  
ATOM    838  CG  PHE A  99      13.118  25.676  33.712  1.00 41.05           C  
ATOM    839  CD1 PHE A  99      13.740  26.886  33.416  1.00 41.01           C  
ATOM    840  CD2 PHE A  99      13.850  24.681  34.334  1.00 40.85           C  
ATOM    841  CE1 PHE A  99      15.067  27.102  33.738  1.00 40.86           C  
ATOM    842  CE2 PHE A  99      15.178  24.885  34.662  1.00 41.50           C  
ATOM    843  CZ  PHE A  99      15.790  26.101  34.365  1.00 41.45           C  
ATOM    844  N   ASP A 100       8.400  26.481  34.659  1.00 42.77           N  
ATOM    845  CA  ASP A 100       6.978  26.412  34.347  1.00 43.16           C  
ATOM    846  C   ASP A 100       6.547  27.359  33.235  1.00 42.22           C  
ATOM    847  O   ASP A 100       5.535  27.134  32.569  1.00 41.52           O  
ATOM    848  CB  ASP A 100       6.170  26.744  35.593  1.00 44.88           C  
ATOM    849  CG  ASP A 100       6.195  25.640  36.597  1.00 46.65           C  
ATOM    850  OD1 ASP A 100       7.303  25.163  36.910  1.00 48.40           O  
ATOM    851  OD2 ASP A 100       5.109  25.251  37.071  1.00 47.98           O  
ATOM    852  N   PHE A 101       7.304  28.430  33.042  1.00 40.88           N  
ATOM    853  CA  PHE A 101       6.950  29.397  32.019  1.00 40.22           C  
ATOM    854  C   PHE A 101       6.913  28.793  30.637  1.00 41.27           C  
ATOM    855  O   PHE A 101       6.393  29.399  29.703  1.00 42.20           O  
ATOM    856  CB  PHE A 101       7.922  30.569  32.009  1.00 38.50           C  
ATOM    857  CG  PHE A 101       9.329  30.202  31.628  1.00 37.11           C  
ATOM    858  CD1 PHE A 101      10.252  29.821  32.603  1.00 35.94           C  
ATOM    859  CD2 PHE A 101       9.760  30.331  30.308  1.00 35.58           C  
ATOM    860  CE1 PHE A 101      11.584  29.591  32.270  1.00 34.35           C  
ATOM    861  CE2 PHE A 101      11.090  30.102  29.964  1.00 33.63           C  
ATOM    862  CZ  PHE A 101      12.002  29.736  30.945  1.00 34.09           C  
ATOM    863  N   LEU A 102       7.483  27.605  30.498  1.00 41.59           N  
ATOM    864  CA  LEU A 102       7.502  26.934  29.211  1.00 42.43           C  
ATOM    865  C   LEU A 102       6.232  26.114  29.002  1.00 43.76           C  
ATOM    866  O   LEU A 102       5.929  25.692  27.884  1.00 43.35           O  
ATOM    867  CB  LEU A 102       8.735  26.034  29.120  1.00 39.89           C  
ATOM    868  CG  LEU A 102      10.066  26.759  28.904  1.00 39.48           C  
ATOM    869  CD1 LEU A 102      11.208  25.790  29.121  1.00 40.34           C  
ATOM    870  CD2 LEU A 102      10.129  27.349  27.494  1.00 38.59           C  
ATOM    871  N   LYS A 103       5.489  25.907  30.087  1.00 45.20           N  
ATOM    872  CA  LYS A 103       4.263  25.112  30.054  1.00 46.06           C  
ATOM    873  C   LYS A 103       3.302  25.486  28.931  1.00 45.98           C  
ATOM    874  O   LYS A 103       2.581  24.632  28.415  1.00 45.23           O  
ATOM    875  CB  LYS A 103       3.535  25.215  31.401  1.00 47.15           C  
ATOM    876  CG  LYS A 103       4.357  24.732  32.598  1.00 49.39           C  
ATOM    877  CD  LYS A 103       3.673  25.044  33.941  1.00 50.03           C  
ATOM    878  CE  LYS A 103       2.671  23.962  34.352  1.00 50.39           C  
ATOM    879  NZ  LYS A 103       3.337  22.655  34.661  1.00 49.22           N  
ATOM    880  N   ASP A 104       3.296  26.755  28.546  1.00 46.65           N  
ATOM    881  CA  ASP A 104       2.398  27.216  27.495  1.00 47.62           C  
ATOM    882  C   ASP A 104       2.954  26.935  26.101  1.00 46.89           C  
ATOM    883  O   ASP A 104       2.255  27.111  25.106  1.00 46.58           O  
ATOM    884  CB  ASP A 104       2.154  28.713  27.655  1.00 50.43           C  
ATOM    885  CG  ASP A 104       3.420  29.518  27.466  1.00 53.78           C  
ATOM    886  OD1 ASP A 104       4.461  29.126  28.048  1.00 55.30           O  
ATOM    887  OD2 ASP A 104       3.377  30.534  26.737  1.00 54.89           O  
ATOM    888  N   LYS A 105       4.211  26.502  26.027  1.00 46.29           N  
ATOM    889  CA  LYS A 105       4.836  26.206  24.738  1.00 45.19           C  
ATOM    890  C   LYS A 105       5.037  24.710  24.534  1.00 43.65           C  
ATOM    891  O   LYS A 105       5.080  24.237  23.403  1.00 43.28           O  
ATOM    892  CB  LYS A 105       6.192  26.910  24.627  1.00 47.62           C  
ATOM    893  CG  LYS A 105       6.165  28.401  24.954  1.00 50.87           C  
ATOM    894  CD  LYS A 105       5.355  29.196  23.944  1.00 52.10           C  
ATOM    895  CE  LYS A 105       5.422  30.687  24.242  1.00 53.28           C  
ATOM    896  NZ  LYS A 105       4.706  31.497  23.211  1.00 54.79           N  
ATOM    897  N   CYS A 106       5.174  23.970  25.630  1.00 42.44           N  
ATOM    898  CA  CYS A 106       5.362  22.524  25.552  1.00 41.06           C  
ATOM    899  C   CYS A 106       5.086  21.862  26.898  1.00 40.45           C  
ATOM    900  O   CYS A 106       4.806  22.532  27.890  1.00 40.48           O  
ATOM    901  CB  CYS A 106       6.786  22.176  25.097  1.00 40.55           C  
ATOM    902  SG  CYS A 106       8.082  22.502  26.324  1.00 38.91           S  
ATOM    903  N   GLU A 107       5.162  20.538  26.918  1.00 39.42           N  
ATOM    904  CA  GLU A 107       4.935  19.773  28.132  1.00 37.94           C  
ATOM    905  C   GLU A 107       6.171  19.882  29.008  1.00 37.07           C  
ATOM    906  O   GLU A 107       7.259  19.494  28.596  1.00 37.39           O  
ATOM    907  CB  GLU A 107       4.676  18.314  27.771  1.00 38.56           C  
ATOM    908  CG  GLU A 107       4.430  17.399  28.948  1.00 41.15           C  
ATOM    909  CD  GLU A 107       3.852  16.050  28.523  1.00 44.01           C  
ATOM    910  OE1 GLU A 107       3.764  15.151  29.387  1.00 44.92           O  
ATOM    911  OE2 GLU A 107       3.479  15.888  27.333  1.00 44.31           O  
ATOM    912  N   VAL A 108       6.011  20.433  30.206  1.00 36.21           N  
ATOM    913  CA  VAL A 108       7.132  20.567  31.128  1.00 34.53           C  
ATOM    914  C   VAL A 108       7.042  19.447  32.143  1.00 33.98           C  
ATOM    915  O   VAL A 108       6.013  19.272  32.785  1.00 34.40           O  
ATOM    916  CB  VAL A 108       7.106  21.910  31.892  1.00 33.91           C  
ATOM    917  CG1 VAL A 108       8.292  21.973  32.846  1.00 33.19           C  
ATOM    918  CG2 VAL A 108       7.138  23.079  30.919  1.00 32.45           C  
ATOM    919  N   ILE A 109       8.121  18.690  32.290  1.00 34.10           N  
ATOM    920  CA  ILE A 109       8.132  17.581  33.236  1.00 33.95           C  
ATOM    921  C   ILE A 109       9.371  17.556  34.112  1.00 34.05           C  
ATOM    922  O   ILE A 109      10.494  17.606  33.620  1.00 34.25           O  
ATOM    923  CB  ILE A 109       8.021  16.230  32.504  1.00 33.30           C  
ATOM    924  CG1 ILE A 109       6.666  16.146  31.801  1.00 33.71           C  
ATOM    925  CG2 ILE A 109       8.220  15.077  33.480  1.00 31.62           C  
ATOM    926  CD1 ILE A 109       5.478  16.425  32.720  1.00 34.75           C  
ATOM    927  N   TYR A 110       9.153  17.481  35.416  1.00 34.93           N  
ATOM    928  CA  TYR A 110      10.248  17.427  36.371  1.00 37.02           C  
ATOM    929  C   TYR A 110      10.323  16.004  36.912  1.00 38.77           C  
ATOM    930  O   TYR A 110       9.400  15.546  37.591  1.00 39.30           O  
ATOM    931  CB  TYR A 110      10.002  18.415  37.511  1.00 37.69           C  
ATOM    932  CG  TYR A 110       9.945  19.868  37.070  1.00 39.51           C  
ATOM    933  CD1 TYR A 110      11.110  20.567  36.741  1.00 40.51           C  
ATOM    934  CD2 TYR A 110       8.725  20.547  36.989  1.00 40.09           C  
ATOM    935  CE1 TYR A 110      11.064  21.916  36.344  1.00 40.85           C  
ATOM    936  CE2 TYR A 110       8.665  21.892  36.594  1.00 40.50           C  
ATOM    937  CZ  TYR A 110       9.838  22.571  36.274  1.00 41.23           C  
ATOM    938  OH  TYR A 110       9.785  23.893  35.885  1.00 39.83           O  
ATOM    939  N   LEU A 111      11.413  15.302  36.604  1.00 40.61           N  
ATOM    940  CA  LEU A 111      11.572  13.923  37.053  1.00 43.13           C  
ATOM    941  C   LEU A 111      11.687  13.813  38.563  1.00 45.45           C  
ATOM    942  O   LEU A 111      11.967  14.793  39.250  1.00 45.62           O  
ATOM    943  CB  LEU A 111      12.791  13.270  36.395  1.00 42.33           C  
ATOM    944  CG  LEU A 111      12.779  13.129  34.870  1.00 42.35           C  
ATOM    945  CD1 LEU A 111      13.922  12.220  34.431  1.00 42.63           C  
ATOM    946  CD2 LEU A 111      11.452  12.550  34.412  1.00 41.80           C  
ATOM    947  N   LYS A 112      11.517  12.589  39.050  1.00 48.19           N  
ATOM    948  CA  LYS A 112      11.548  12.270  40.468  1.00 50.69           C  
ATOM    949  C   LYS A 112      12.909  11.878  41.024  1.00 52.12           C  
ATOM    950  O   LYS A 112      13.622  12.716  41.549  1.00 53.05           O  
ATOM    951  CB  LYS A 112      10.538  11.155  40.748  1.00 52.30           C  
ATOM    952  CG  LYS A 112      10.715   9.900  39.880  1.00 53.51           C  
ATOM    953  CD  LYS A 112      10.512  10.193  38.399  1.00 54.05           C  
ATOM    954  CE  LYS A 112      11.126   9.124  37.520  1.00 53.94           C  
ATOM    955  NZ  LYS A 112      11.072   9.484  36.078  1.00 52.96           N  
ATOM    956  N   ARG A 113      13.254  10.598  40.920  1.00 54.55           N  
ATOM    957  CA  ARG A 113      14.519  10.072  41.432  1.00 56.90           C  
ATOM    958  C   ARG A 113      15.772  10.652  40.765  1.00 58.97           C  
ATOM    959  O   ARG A 113      16.712   9.915  40.437  1.00 58.99           O  
ATOM    960  CB  ARG A 113      14.533   8.549  41.288  1.00 56.98           C  
ATOM    961  CG  ARG A 113      13.493   7.833  42.132  1.00 57.91           C  
ATOM    962  CD  ARG A 113      13.423   6.343  41.782  1.00 58.80           C  
ATOM    963  NE  ARG A 113      14.686   5.620  41.987  1.00 58.80           N  
ATOM    964  CZ  ARG A 113      15.212   5.302  43.171  1.00 57.32           C  
ATOM    965  NH1 ARG A 113      14.593   5.640  44.298  1.00 55.68           N  
ATOM    966  NH2 ARG A 113      16.360   4.633  43.224  1.00 56.37           N  
ATOM    967  N   THR A 114      15.780  11.971  40.577  1.00 60.71           N  
ATOM    968  CA  THR A 114      16.904  12.671  39.958  1.00 61.42           C  
ATOM    969  C   THR A 114      17.657  13.504  40.990  1.00 62.74           C  
ATOM    970  O   THR A 114      17.684  14.735  40.904  1.00 63.33           O  
ATOM    971  CB  THR A 114      16.423  13.606  38.821  1.00 60.69           C  
ATOM    972  OG1 THR A 114      15.301  14.377  39.269  1.00 59.03           O  
ATOM    973  CG2 THR A 114      16.028  12.796  37.599  1.00 60.43           C  
ATOM    974  N   GLU A 115      18.266  12.821  41.959  1.00 64.07           N  
ATOM    975  CA  GLU A 115      19.025  13.465  43.033  1.00 65.26           C  
ATOM    976  C   GLU A 115      19.675  14.783  42.612  1.00 65.86           C  
ATOM    977  O   GLU A 115      19.538  15.774  43.366  1.00 65.62           O  
ATOM    978  CB  GLU A 115      20.090  12.500  43.573  1.00 65.29           C  
ATOM    979  CG  GLU A 115      19.519  11.343  44.402  1.00 66.13           C  
ATOM    980  CD  GLU A 115      19.155  11.738  45.839  1.00 66.25           C  
ATOM    981  OE1 GLU A 115      20.080  11.938  46.657  1.00 65.54           O  
ATOM    982  OE2 GLU A 115      17.947  11.847  46.150  1.00 65.84           O  
TER     983      GLU A 115                                                      
END
MOLECULE T0507.pdb
ATOM      1  N   MET     1       9.471  19.383  17.859  1.00 28.75           N  
ATOM      2  CA  MET     1      10.467  18.472  18.443  1.00 28.28           C  
ATOM      3  C   MET     1       9.863  17.832  19.708  1.00 25.85           C  
ATOM      4  O   MET     1       9.220  18.505  20.472  1.00 26.57           O  
ATOM      5  CB  MET     1      11.682  19.345  18.718  1.00 30.12           C  
ATOM      6  CG  MET     1      12.926  18.747  18.287  1.00 32.38           C  
ATOM      7  SD  MET     1      13.141  17.583  19.609  1.00 34.54           S  
ATOM      8  CE  MET     1      14.154  16.363  18.798  1.00 34.68           C  
ATOM      9  N   LYS     2      10.005  16.529  19.935  1.00 23.67           N  
ATOM     10  CA  LYS     2       9.130  15.928  20.868  1.00 21.04           C  
ATOM     11  C   LYS     2       9.632  16.314  22.285  1.00 18.36           C  
ATOM     12  O   LYS     2       8.829  16.790  23.089  1.00 17.95           O  
ATOM     13  CB  LYS     2       8.952  14.397  20.695  1.00 20.99           C  
ATOM     14  CG  LYS     2       7.689  13.889  21.336  1.00 25.93           C  
ATOM     15  CD  LYS     2       7.379  12.460  20.935  1.00 25.23           C  
ATOM     16  CE  LYS     2       6.225  11.894  21.721  1.00 28.95           C  
ATOM     17  NZ  LYS     2       4.952  12.062  20.997  1.00 30.26           N  
ATOM     18  N   VAL     3      10.932  16.116  22.588  1.00 14.40           N  
ATOM     19  CA  VAL     3      11.392  16.209  23.996  1.00 14.06           C  
ATOM     20  C   VAL     3      12.682  17.038  24.127  1.00 12.89           C  
ATOM     21  O   VAL     3      13.653  16.793  23.395  1.00 14.14           O  
ATOM     22  CB  VAL     3      11.667  14.816  24.604  1.00 13.71           C  
ATOM     23  CG1 VAL     3      12.079  14.962  26.073  1.00 15.31           C  
ATOM     24  CG2 VAL     3      10.474  13.891  24.441  1.00 16.19           C  
ATOM     25  N   ALA     4      12.676  17.999  25.057  1.00 12.21           N  
ATOM     26  CA  ALA     4      13.827  18.798  25.476  1.00 12.13           C  
ATOM     27  C   ALA     4      14.427  18.297  26.783  1.00 11.99           C  
ATOM     28  O   ALA     4      13.701  17.956  27.685  1.00 12.37           O  
ATOM     29  CB  ALA     4      13.425  20.213  25.670  1.00 12.90           C  
ATOM     30  N   LEU     5      15.751  18.232  26.822  1.00 13.40           N  
ATOM     31  CA  LEU     5      16.530  17.887  27.989  1.00 12.60           C  
ATOM     32  C   LEU     5      17.799  18.716  27.901  1.00 12.39           C  
ATOM     33  O   LEU     5      18.362  18.838  26.851  1.00 13.27           O  
ATOM     34  CB  LEU     5      16.940  16.393  27.940  1.00 13.90           C  
ATOM     35  CG  LEU     5      17.961  15.886  28.931  1.00 16.06           C  
ATOM     36  CD1 LEU     5      17.473  16.062  30.368  1.00 16.87           C  
ATOM     37  CD2 LEU     5      18.254  14.463  28.636  1.00 14.54           C  
ATOM     38  N   GLY     6      18.267  19.240  29.016  1.00 12.20           N  
ATOM     39  CA  GLY     6      19.496  20.016  29.036  1.00 13.19           C  
ATOM     40  C   GLY     6      20.337  19.768  30.258  1.00 13.49           C  
ATOM     41  O   GLY     6      19.846  19.263  31.259  1.00 15.10           O  
ATOM     42  N   GLY     7      21.616  20.105  30.157  1.00 12.80           N  
ATOM     43  CA  GLY     7      22.516  19.947  31.279  1.00 14.21           C  
ATOM     44  C   GLY     7      23.944  20.314  30.945  1.00 13.50           C  
ATOM     45  O   GLY     7      24.270  20.652  29.816  1.00 13.18           O  
ATOM     46  N   THR     8      24.777  20.264  31.978  1.00 14.15           N  
ATOM     47  CA  THR     8      26.216  20.411  31.846  1.00 14.26           C  
ATOM     48  C   THR     8      26.868  19.026  31.710  1.00 14.59           C  
ATOM     49  O   THR     8      27.789  18.873  30.955  1.00 14.76           O  
ATOM     50  CB  THR     8      26.793  21.177  33.055  1.00 15.05           C  
ATOM     51  OG1 THR     8      26.310  22.511  33.028  1.00 15.52           O  
ATOM     52  CG2 THR     8      28.296  21.183  33.016  1.00 15.72           C  
ATOM     53  N   PHE     9      26.361  18.037  32.439  1.00 14.99           N  
ATOM     54  CA  PHE     9      26.787  16.626  32.312  1.00 15.71           C  
ATOM     55  C   PHE     9      28.238  16.446  32.693  1.00 16.39           C  
ATOM     56  O   PHE     9      28.979  15.688  32.027  1.00 17.49           O  
ATOM     57  CB  PHE     9      26.516  16.061  30.900  1.00 15.53           C  
ATOM     58  CG  PHE     9      25.068  16.132  30.484  1.00 15.67           C  
ATOM     59  CD1 PHE     9      24.133  15.228  30.982  1.00 15.89           C  
ATOM     60  CD2 PHE     9      24.627  17.115  29.605  1.00 13.72           C  
ATOM     61  CE1 PHE     9      22.778  15.297  30.589  1.00 14.96           C  
ATOM     62  CE2 PHE     9      23.308  17.216  29.252  1.00 14.05           C  
ATOM     63  CZ  PHE     9      22.370  16.310  29.724  1.00 14.38           C  
ATOM     64  N   GLU    10      28.654  17.083  33.785  1.00 16.74           N  
ATOM     65  CA  GLU    10      30.018  16.900  34.286  1.00 17.49           C  
ATOM     66  C   GLU    10      30.013  16.604  35.768  1.00 18.37           C  
ATOM     67  O   GLU    10      29.660  17.486  36.554  1.00 19.65           O  
ATOM     68  CB  GLU    10      30.907  18.116  34.014  1.00 17.97           C  
ATOM     69  CG  GLU    10      32.345  17.926  34.536  1.00 18.05           C  
ATOM     70  CD  GLU    10      33.225  19.113  34.340  1.00 18.80           C  
ATOM     71  OE1 GLU    10      33.029  19.855  33.355  1.00 20.13           O  
ATOM     72  OE2 GLU    10      34.130  19.331  35.199  1.00 20.91           O  
ATOM     73  N   PRO    11      30.372  15.374  36.155  1.00 17.40           N  
ATOM     74  CA  PRO    11      30.526  14.230  35.271  1.00 17.68           C  
ATOM     75  C   PRO    11      29.125  13.733  34.888  1.00 17.09           C  
ATOM     76  O   PRO    11      28.112  14.261  35.367  1.00 17.46           O  
ATOM     77  CB  PRO    11      31.211  13.195  36.146  1.00 18.11           C  
ATOM     78  CG  PRO    11      30.719  13.480  37.453  1.00 19.56           C  
ATOM     79  CD  PRO    11      30.512  14.970  37.556  1.00 18.87           C  
ATOM     80  N   LEU    12      29.090  12.757  33.995  1.00 17.04           N  
ATOM     81  CA  LEU    12      27.846  12.138  33.573  1.00 16.16           C  
ATOM     82  C   LEU    12      27.485  11.059  34.586  1.00 15.29           C  
ATOM     83  O   LEU    12      28.085   9.967  34.578  1.00 16.60           O  
ATOM     84  CB  LEU    12      28.011  11.558  32.175  1.00 16.49           C  
ATOM     85  CG  LEU    12      26.753  11.002  31.491  1.00 18.74           C  
ATOM     86  CD1 LEU    12      26.056   9.867  32.230  1.00 25.35           C  
ATOM     87  CD2 LEU    12      25.771  12.045  31.269  1.00 20.51           C  
ATOM     88  N   HIS    13      26.546  11.364  35.482  1.00 14.14           N  
ATOM     89  CA  HIS    13      26.262  10.510  36.644  1.00 15.00           C  
ATOM     90  C   HIS    13      24.923   9.821  36.533  1.00 13.50           C  
ATOM     91  O   HIS    13      24.206   9.983  35.525  1.00 13.42           O  
ATOM     92  CB  HIS    13      26.385  11.302  37.951  1.00 15.48           C  
ATOM     93  CG  HIS    13      25.492  12.499  38.057  1.00 15.70           C  
ATOM     94  ND1 HIS    13      24.118  12.442  37.912  1.00 17.16           N  
ATOM     95  CD2 HIS    13      25.788  13.801  38.302  1.00 17.76           C  
ATOM     96  CE1 HIS    13      23.614  13.651  38.092  1.00 18.91           C  
ATOM     97  NE2 HIS    13      24.606  14.494  38.326  1.00 18.16           N  
ATOM     98  N   GLU    14      24.583   9.033  37.540  1.00 14.72           N  
ATOM     99  CA  GLU    14      23.409   8.172  37.492  1.00 14.66           C  
ATOM    100  C   GLU    14      22.125   8.999  37.368  1.00 13.85           C  
ATOM    101  O   GLU    14      21.181   8.597  36.687  1.00 14.59           O  
ATOM    102  CB  GLU    14      23.363   7.236  38.715  1.00 15.83           C  
ATOM    103  CG  GLU    14      22.078   6.395  38.788  1.00 19.31           C  
ATOM    104  CD  GLU    14      21.791   5.604  37.498  1.00 27.14           C  
ATOM    105  OE1 GLU    14      22.767   5.087  36.878  1.00 35.57           O  
ATOM    106  OE2 GLU    14      20.596   5.476  37.105  1.00 31.01           O  
ATOM    107  N   GLY    15      22.119  10.179  37.976  1.00 13.70           N  
ATOM    108  CA  GLY    15      21.008  11.107  37.818  1.00 13.84           C  
ATOM    109  C   GLY    15      20.783  11.491  36.365  1.00 13.31           C  
ATOM    110  O   GLY    15      19.653  11.437  35.840  1.00 13.77           O  
ATOM    111  N   HIS    16      21.863  11.900  35.691  1.00 12.59           N  
ATOM    112  CA  HIS    16      21.774  12.253  34.280  1.00 13.43           C  
ATOM    113  C   HIS    16      21.246  11.064  33.480  1.00 13.14           C  
ATOM    114  O   HIS    16      20.460  11.217  32.541  1.00 13.69           O  
ATOM    115  CB  HIS    16      23.104  12.650  33.660  1.00 13.25           C  
ATOM    116  CG  HIS    16      23.758  13.845  34.273  1.00 14.67           C  
ATOM    117  ND1 HIS    16      23.184  15.101  34.310  1.00 16.09           N  
ATOM    118  CD2 HIS    16      24.989  13.974  34.818  1.00 13.92           C  
ATOM    119  CE1 HIS    16      24.036  15.942  34.882  1.00 14.34           C  
ATOM    120  NE2 HIS    16      25.124  15.276  35.216  1.00 18.20           N  
ATOM    121  N   LYS    17      21.728   9.871  33.794  1.00 12.70           N  
ATOM    122  CA  LYS    17      21.279   8.685  33.095  1.00 13.29           C  
ATOM    123  C   LYS    17      19.782   8.429  33.269  1.00 12.95           C  
ATOM    124  O   LYS    17      19.103   7.992  32.317  1.00 13.58           O  
ATOM    125  CB  LYS    17      22.145   7.499  33.449  1.00 13.51           C  
ATOM    126  CG  LYS    17      23.607   7.759  33.065  1.00 14.06           C  
ATOM    127  CD  LYS    17      24.525   6.618  33.488  1.00 15.90           C  
ATOM    128  CE  LYS    17      25.976   6.918  33.192  1.00 17.87           C  
ATOM    129  NZ  LYS    17      26.924   5.828  33.630  1.00 18.53           N  
ATOM    130  N   LYS    18      19.235   8.761  34.440  1.00 12.91           N  
ATOM    131  CA  LYS    18      17.788   8.639  34.619  1.00 13.91           C  
ATOM    132  C   LYS    18      17.054   9.637  33.738  1.00 13.08           C  
ATOM    133  O   LYS    18      16.049   9.302  33.103  1.00 13.01           O  
ATOM    134  CB  LYS    18      17.391   8.814  36.069  1.00 14.14           C  
ATOM    135  CG  LYS    18      17.885   7.705  36.985  1.00 16.78           C  
ATOM    136  CD  LYS    18      17.640   7.995  38.461  1.00 19.10           C  
ATOM    137  CE  LYS    18      17.835   6.722  39.301  1.00 22.60           C  
ATOM    138  NZ  LYS    18      17.548   7.034  40.723  1.00 27.88           N  
ATOM    139  N   LEU    19      17.544  10.867  33.706  1.00 12.55           N  
ATOM    140  CA  LEU    19      16.926  11.891  32.868  1.00 12.88           C  
ATOM    141  C   LEU    19      16.922  11.447  31.399  1.00 12.80           C  
ATOM    142  O   LEU    19      15.931  11.608  30.677  1.00 12.07           O  
ATOM    143  CB  LEU    19      17.689  13.206  32.974  1.00 14.18           C  
ATOM    144  CG  LEU    19      17.718  13.965  34.287  1.00 17.04           C  
ATOM    145  CD1 LEU    19      18.262  15.407  34.070  1.00 18.47           C  
ATOM    146  CD2 LEU    19      16.344  13.966  34.919  1.00 19.93           C  
ATOM    147  N   ILE    20      18.070  10.956  30.954  1.00 12.27           N  
ATOM    148  CA  ILE    20      18.235  10.539  29.573  1.00 12.20           C  
ATOM    149  C   ILE    20      17.285   9.380  29.261  1.00 11.45           C  
ATOM    150  O   ILE    20      16.659   9.345  28.172  1.00 12.52           O  
ATOM    151  CB  ILE    20      19.722  10.157  29.272  1.00 11.20           C  
ATOM    152  CG1 ILE    20      20.578  11.420  29.228  1.00 12.10           C  
ATOM    153  CG2 ILE    20      19.867   9.382  27.962  1.00 12.79           C  
ATOM    154  CD1 ILE    20      22.083  11.206  29.352  1.00 12.89           C  
ATOM    155  N   ASP    21      17.155   8.428  30.197  1.00 11.22           N  
ATOM    156  CA  ASP    21      16.278   7.264  29.966  1.00 10.93           C  
ATOM    157  C   ASP    21      14.840   7.747  29.786  1.00 10.42           C  
ATOM    158  O   ASP    21      14.126   7.308  28.906  1.00 11.06           O  
ATOM    159  CB  ASP    21      16.325   6.293  31.145  1.00 11.64           C  
ATOM    160  CG  ASP    21      15.650   4.968  30.834  1.00 12.80           C  
ATOM    161  OD1 ASP    21      16.098   4.298  29.871  1.00 15.25           O  
ATOM    162  OD2 ASP    21      14.673   4.598  31.565  1.00 14.13           O  
ATOM    163  N   VAL    22      14.401   8.615  30.679  1.00 10.55           N  
ATOM    164  CA  VAL    22      13.020   9.119  30.616  1.00 11.13           C  
ATOM    165  C   VAL    22      12.833   9.877  29.283  1.00 10.90           C  
ATOM    166  O   VAL    22      11.865   9.666  28.577  1.00 11.79           O  
ATOM    167  CB  VAL    22      12.657  10.003  31.860  1.00 11.06           C  
ATOM    168  CG1 VAL    22      11.361  10.773  31.631  1.00 12.23           C  
ATOM    169  CG2 VAL    22      12.627   9.157  33.134  1.00 11.82           C  
ATOM    170  N   ALA    23      13.775  10.739  28.929  1.00 11.24           N  
ATOM    171  CA  ALA    23      13.644  11.541  27.713  1.00 11.85           C  
ATOM    172  C   ALA    23      13.551  10.647  26.477  1.00 11.80           C  
ATOM    173  O   ALA    23      12.741  10.900  25.594  1.00 12.41           O  
ATOM    174  CB  ALA    23      14.792  12.530  27.571  1.00 12.84           C  
ATOM    175  N   ILE    24      14.387   9.605  26.399  1.00 12.42           N  
ATOM    176  CA  ILE    24      14.387   8.721  25.248  1.00 12.68           C  
ATOM    177  C   ILE    24      13.144   7.848  25.179  1.00 12.17           C  
ATOM    178  O   ILE    24      12.615   7.594  24.090  1.00 13.55           O  
ATOM    179  CB  ILE    24      15.690   7.887  25.165  1.00 13.00           C  
ATOM    180  CG1 ILE    24      16.865   8.845  24.909  1.00 13.51           C  
ATOM    181  CG2 ILE    24      15.573   6.843  24.091  1.00 13.87           C  
ATOM    182  CD1 ILE    24      18.274   8.223  24.900  1.00 12.90           C  
ATOM    183  N   LYS    25      12.670   7.386  26.325  1.00 12.40           N  
ATOM    184  CA  LYS    25      11.431   6.646  26.361  1.00 13.51           C  
ATOM    185  C   LYS    25      10.273   7.527  25.891  1.00 13.03           C  
ATOM    186  O   LYS    25       9.383   7.055  25.166  1.00 15.22           O  
ATOM    187  CB  LYS    25      11.211   6.009  27.742  1.00 13.95           C  
ATOM    188  CG  LYS    25      12.140   4.801  27.947  1.00 14.39           C  
ATOM    189  CD  LYS    25      12.160   4.232  29.338  1.00 15.16           C  
ATOM    190  CE  LYS    25      12.990   2.939  29.347  1.00 17.97           C  
ATOM    191  NZ  LYS    25      13.339   2.490  30.713  1.00 19.33           N  
ATOM    192  N   LEU    26      10.292   8.812  26.235  1.00 13.14           N  
ATOM    193  CA  LEU    26       9.227   9.714  25.813  1.00 13.62           C  
ATOM    194  C   LEU    26       9.317  10.078  24.349  1.00 14.05           C  
ATOM    195  O   LEU    26       8.277  10.198  23.693  1.00 16.58           O  
ATOM    196  CB  LEU    26       9.226  11.021  26.634  1.00 12.95           C  
ATOM    197  CG  LEU    26       8.786  10.894  28.085  1.00 13.32           C  
ATOM    198  CD1 LEU    26       8.978  12.246  28.826  1.00 15.92           C  
ATOM    199  CD2 LEU    26       7.344  10.390  28.204  1.00 18.05           C  
ATOM    200  N   GLY    27      10.537  10.327  23.856  1.00 15.19           N  
ATOM    201  CA  GLY    27      10.745  10.968  22.553  1.00 15.35           C  
ATOM    202  C   GLY    27      11.401  10.144  21.470  1.00 16.01           C  
ATOM    203  O   GLY    27      11.377  10.531  20.299  1.00 15.93           O  
ATOM    204  N   GLY    28      12.018   9.029  21.850  1.00 15.76           N  
ATOM    205  CA  GLY    28      12.791   8.229  20.905  1.00 16.84           C  
ATOM    206  C   GLY    28      13.929   9.057  20.354  1.00 16.82           C  
ATOM    207  O   GLY    28      14.622   9.718  21.086  1.00 18.04           O  
ATOM    208  N   ARG    29      14.087   9.057  19.028  1.00 17.64           N  
ATOM    209  CA  ARG    29      15.088   9.871  18.351  1.00 19.03           C  
ATOM    210  C   ARG    29      14.685  11.351  18.236  1.00 19.02           C  
ATOM    211  O   ARG    29      15.500  12.184  17.796  1.00 20.44           O  
ATOM    212  CB  ARG    29      15.288   9.360  16.951  1.00 20.25           C  
ATOM    213  CG  ARG    29      15.520   7.842  16.811  1.00 24.86           C  
ATOM    214  CD  ARG    29      16.913   7.453  17.006  1.00 27.48           C  
ATOM    215  NE  ARG    29      17.833   8.195  16.128  1.00 29.06           N  
ATOM    216  CZ  ARG    29      18.392   7.754  15.001  1.00 29.08           C  
ATOM    217  NH1 ARG    29      19.223   8.563  14.350  1.00 29.21           N  
ATOM    218  NH2 ARG    29      18.164   6.525  14.537  1.00 26.69           N  
ATOM    219  N   ASP    30      13.457  11.683  18.640  1.00 18.63           N  
ATOM    220  CA  ASP    30      12.897  13.029  18.471  1.00 19.92           C  
ATOM    221  C   ASP    30      13.160  13.790  19.754  1.00 20.38           C  
ATOM    222  O   ASP    30      12.260  14.372  20.349  1.00 21.75           O  
ATOM    223  CB  ASP    30      11.382  12.919  18.204  1.00 20.66           C  
ATOM    224  CG  ASP    30      10.770  14.161  17.535  1.00 22.83           C  
ATOM    225  OD1 ASP    30      11.468  15.180  17.351  1.00 27.63           O  
ATOM    226  OD2 ASP    30       9.543  14.095  17.201  1.00 28.91           O  
ATOM    227  N   ILE    31      14.391  13.746  20.194  1.00 20.35           N  
ATOM    228  CA  ILE    31      14.835  14.459  21.393  1.00 19.54           C  
ATOM    229  C   ILE    31      15.976  15.364  20.970  1.00 18.50           C  
ATOM    230  O   ILE    31      16.686  15.090  19.998  1.00 16.83           O  
ATOM    231  CB  ILE    31      15.317  13.524  22.499  1.00 20.15           C  
ATOM    232  CG1 ILE    31      16.598  12.757  22.116  1.00 20.47           C  
ATOM    233  CG2 ILE    31      14.218  12.514  22.866  1.00 22.69           C  
ATOM    234  CD1 ILE    31      17.156  12.008  23.299  1.00 23.46           C  
ATOM    235  N   THR    32      16.120  16.435  21.725  1.00 16.49           N  
ATOM    236  CA  THR    32      17.258  17.324  21.627  1.00 16.34           C  
ATOM    237  C   THR    32      17.855  17.426  22.987  1.00 14.94           C  
ATOM    238  O   THR    32      17.136  17.750  23.954  1.00 15.40           O  
ATOM    239  CB  THR    32      16.845  18.713  21.123  1.00 16.82           C  
ATOM    240  OG1 THR    32      16.188  18.568  19.858  1.00 21.43           O  
ATOM    241  CG2 THR    32      18.015  19.583  20.935  1.00 19.14           C  
ATOM    242  N   ILE    33      19.155  17.107  23.083  1.00 14.18           N  
ATOM    243  CA  ILE    33      19.886  17.237  24.315  1.00 13.20           C  
ATOM    244  C   ILE    33      20.753  18.497  24.237  1.00 13.18           C  
ATOM    245  O   ILE    33      21.657  18.578  23.400  1.00 13.87           O  
ATOM    246  CB  ILE    33      20.797  16.007  24.617  1.00 12.09           C  
ATOM    247  CG1 ILE    33      19.972  14.705  24.610  1.00 12.71           C  
ATOM    248  CG2 ILE    33      21.490  16.221  25.951  1.00 14.20           C  
ATOM    249  CD1 ILE    33      20.795  13.467  24.973  1.00 15.21           C  
ATOM    250  N   GLY    34      20.462  19.463  25.096  1.00 12.18           N  
ATOM    251  CA  GLY    34      21.263  20.657  25.205  1.00 12.70           C  
ATOM    252  C   GLY    34      22.406  20.389  26.154  1.00 13.13           C  
ATOM    253  O   GLY    34      22.198  19.822  27.245  1.00 12.92           O  
ATOM    254  N   VAL    35      23.606  20.801  25.746  1.00 12.36           N  
ATOM    255  CA  VAL    35      24.775  20.735  26.613  1.00 13.23           C  
ATOM    256  C   VAL    35      25.301  22.172  26.781  1.00 13.64           C  
ATOM    257  O   VAL    35      25.510  22.896  25.792  1.00 13.78           O  
ATOM    258  CB  VAL    35      25.818  19.779  26.007  1.00 12.50           C  
ATOM    259  CG1 VAL    35      27.133  19.843  26.810  1.00 13.44           C  
ATOM    260  CG2 VAL    35      25.219  18.351  25.932  1.00 12.66           C  
ATOM    261  N   THR    36      25.515  22.585  28.028  1.00 13.52           N  
ATOM    262  CA  THR    36      25.899  23.965  28.310  1.00 14.83           C  
ATOM    263  C   THR    36      27.250  24.311  27.679  1.00 15.63           C  
ATOM    264  O   THR    36      28.190  23.509  27.683  1.00 15.00           O  
ATOM    265  CB  THR    36      25.976  24.216  29.824  1.00 15.02           C  
ATOM    266  OG1 THR    36      26.807  23.225  30.420  1.00 15.22           O  
ATOM    267  CG2 THR    36      24.593  24.178  30.476  1.00 15.83           C  
ATOM    268  N   SER    37      27.359  25.526  27.161  1.00 16.83           N  
ATOM    269  CA  SER    37      28.653  26.063  26.750  1.00 17.62           C  
ATOM    270  C   SER    37      29.622  26.117  27.949  1.00 18.72           C  
ATOM    271  O   SER    37      29.196  26.083  29.118  1.00 17.64           O  
ATOM    272  CB  SER    37      28.435  27.477  26.194  1.00 17.99           C  
ATOM    273  OG  SER    37      28.134  28.333  27.273  1.00 17.35           O  
ATOM    274  N   ASP    38      30.917  26.236  27.673  1.00 20.81           N  
ATOM    275  CA  ASP    38      31.910  26.387  28.752  1.00 23.11           C  
ATOM    276  C   ASP    38      31.576  27.575  29.665  1.00 24.66           C  
ATOM    277  O   ASP    38      31.659  27.478  30.886  1.00 24.12           O  
ATOM    278  CB  ASP    38      33.306  26.577  28.162  1.00 23.55           C  
ATOM    279  CG  ASP    38      33.832  25.336  27.487  1.00 25.05           C  
ATOM    280  OD1 ASP    38      33.213  24.272  27.650  1.00 23.99           O  
ATOM    281  OD2 ASP    38      34.852  25.429  26.775  1.00 29.86           O  
ATOM    282  N   ARG    39      31.162  28.680  29.065  1.00 26.98           N  
ATOM    283  CA  ARG    39      30.840  29.891  29.838  1.00 29.48           C  
ATOM    284  C   ARG    39      29.791  29.597  30.890  1.00 29.96           C  
ATOM    285  O   ARG    39      29.948  29.890  32.074  1.00 29.97           O  
ATOM    286  CB  ARG    39      30.301  30.974  28.924  1.00 30.19           C  
ATOM    287  CG  ARG    39      31.332  31.904  28.373  1.00 33.88           C  
ATOM    288  CD  ARG    39      30.702  33.272  28.049  1.00 35.35           C  
ATOM    289  NE  ARG    39      31.282  33.864  26.839  1.00 41.19           N  
ATOM    290  CZ  ARG    39      32.560  34.234  26.696  1.00 43.21           C  
ATOM    291  NH1 ARG    39      33.449  34.074  27.685  1.00 45.26           N  
ATOM    292  NH2 ARG    39      32.960  34.759  25.537  1.00 42.87           N  
ATOM    293  N   MET    40      28.732  28.953  30.422  1.00 30.37           N  
ATOM    294  CA  MET    40      27.575  28.630  31.218  1.00 31.30           C  
ATOM    295  C   MET    40      27.853  27.561  32.274  1.00 32.15           C  
ATOM    296  O   MET    40      27.332  27.616  33.398  1.00 31.89           O  
ATOM    297  CB  MET    40      26.522  28.142  30.235  1.00 31.25           C  
ATOM    298  CG  MET    40      25.135  28.065  30.731  1.00 32.22           C  
ATOM    299  SD  MET    40      24.037  28.593  29.385  1.00 29.64           S  
ATOM    300  CE  MET    40      24.332  30.375  29.744  1.00 14.80           C  
ATOM    301  N   ALA    41      28.653  26.563  31.907  1.00 32.56           N  
ATOM    302  CA  ALA    41      29.001  25.498  32.827  1.00 34.18           C  
ATOM    303  C   ALA    41      29.751  26.059  34.045  1.00 35.19           C  
ATOM    304  O   ALA    41      29.487  25.666  35.180  1.00 35.38           O  
ATOM    305  CB  ALA    41      29.849  24.466  32.111  1.00 32.62           C  
ATOM    306  N   ARG    42      30.665  26.988  33.783  1.00 37.06           N  
ATOM    307  CA  ARG    42      31.529  27.591  34.812  1.00 38.62           C  
ATOM    308  C   ARG    42      30.791  28.428  35.869  1.00 39.64           C  
ATOM    309  O   ARG    42      31.287  28.584  37.001  1.00 39.95           O  
ATOM    310  CB  ARG    42      32.572  28.485  34.152  1.00 38.65           C  
ATOM    311  CG  ARG    42      33.751  27.754  33.556  1.00 39.99           C  
ATOM    312  CD  ARG    42      34.908  28.731  33.286  1.00 41.19           C  
ATOM    313  NE  ARG    42      34.645  29.613  32.138  1.00 43.78           N  
ATOM    314  CZ  ARG    42      34.921  29.314  30.863  1.00 44.28           C  
ATOM    315  NH1 ARG    42      35.480  28.148  30.541  1.00 44.54           N  
ATOM    316  NH2 ARG    42      34.638  30.187  29.898  1.00 44.28           N  
ATOM    317  N   ALA    43      29.637  28.986  35.503  1.00 40.08           N  
ATOM    318  CA  ALA    43      28.816  29.749  36.451  1.00 40.56           C  
ATOM    319  C   ALA    43      28.117  28.841  37.461  1.00 41.25           C  
ATOM    320  O   ALA    43      27.709  29.288  38.530  1.00 41.86           O  
ATOM    321  CB  ALA    43      27.786  30.595  35.710  1.00 40.30           C  
ATOM    322  N   ARG    44      27.961  27.568  37.124  1.00 41.72           N  
ATOM    323  CA  ARG    44      27.250  26.641  37.991  1.00 42.08           C  
ATOM    324  C   ARG    44      28.242  25.825  38.817  1.00 41.58           C  
ATOM    325  O   ARG    44      28.100  25.732  40.039  1.00 41.95           O  
ATOM    326  CB  ARG    44      26.340  25.723  37.164  1.00 43.09           C  
ATOM    327  CG  ARG    44      25.335  26.462  36.245  1.00 44.40           C  
ATOM    328  CD  ARG    44      24.118  25.581  35.871  1.00 45.76           C  
ATOM    329  NE  ARG    44      22.872  26.349  35.625  1.00 48.01           N  
ATOM    330  CZ  ARG    44      22.026  26.793  36.573  1.00 49.56           C  
ATOM    331  NH1 ARG    44      22.262  26.593  37.873  1.00 49.60           N  
ATOM    332  NH2 ARG    44      20.928  27.462  36.221  1.00 51.13           N  
ATOM    333  N   ILE    45      29.240  25.244  38.138  1.00 40.39           N  
ATOM    334  CA  ILE    45      30.274  24.410  38.776  1.00 39.11           C  
ATOM    335  C   ILE    45      31.687  24.850  38.379  1.00 38.08           C  
ATOM    336  O   ILE    45      31.865  25.683  37.491  1.00 38.36           O  
ATOM    337  CB  ILE    45      30.119  22.918  38.390  1.00 38.99           C  
ATOM    338  CG1 ILE    45      30.099  22.748  36.860  1.00 39.09           C  
ATOM    339  CG2 ILE    45      28.864  22.341  39.018  1.00 39.15           C  
ATOM    340  CD1 ILE    45      30.683  21.438  36.372  1.00 38.25           C  
ATOM    341  N   ARG    46      32.693  24.287  39.041  1.00 37.31           N  
ATOM    342  CA  ARG    46      34.071  24.437  38.583  1.00 36.07           C  
ATOM    343  C   ARG    46      34.280  23.353  37.530  1.00 34.15           C  
ATOM    344  O   ARG    46      34.767  22.268  37.832  1.00 34.04           O  
ATOM    345  CB  ARG    46      35.078  24.291  39.727  1.00 37.07           C  
ATOM    346  CG  ARG    46      36.557  24.488  39.298  1.00 38.01           C  
ATOM    347  CD  ARG    46      37.533  23.937  40.331  1.00 39.96           C  
ATOM    348  NE  ARG    46      38.902  23.815  39.802  1.00 42.24           N  
ATOM    349  CZ  ARG    46      39.565  22.672  39.610  1.00 44.17           C  
ATOM    350  NH1 ARG    46      39.016  21.496  39.903  1.00 44.92           N  
ATOM    351  NH2 ARG    46      40.812  22.707  39.136  1.00 46.21           N  
ATOM    352  N   SER    47      33.907  23.681  36.300  1.00 31.63           N  
ATOM    353  CA  SER    47      33.938  22.741  35.180  1.00 29.04           C  
ATOM    354  C   SER    47      35.338  22.625  34.620  1.00 27.09           C  
ATOM    355  O   SER    47      35.970  23.633  34.285  1.00 27.12           O  
ATOM    356  CB  SER    47      32.997  23.211  34.066  1.00 29.26           C  
ATOM    357  OG  SER    47      33.096  22.391  32.907  1.00 27.78           O  
ATOM    358  N   VAL    48      35.807  21.393  34.496  1.00 23.46           N  
ATOM    359  CA  VAL    48      37.115  21.127  33.918  1.00 22.51           C  
ATOM    360  C   VAL    48      37.078  20.419  32.563  1.00 20.54           C  
ATOM    361  O   VAL    48      38.143  20.221  31.966  1.00 21.74           O  
ATOM    362  CB  VAL    48      37.995  20.342  34.897  1.00 20.94           C  
ATOM    363  CG1 VAL    48      38.195  21.199  36.190  1.00 22.29           C  
ATOM    364  CG2 VAL    48      37.409  18.967  35.206  1.00 20.58           C  
ATOM    365  N   LEU    49      35.883  20.089  32.047  1.00 18.18           N  
ATOM    366  CA  LEU    49      35.761  19.448  30.736  1.00 17.39           C  
ATOM    367  C   LEU    49      35.203  20.429  29.717  1.00 16.50           C  
ATOM    368  O   LEU    49      34.129  21.020  29.973  1.00 15.92           O  
ATOM    369  CB  LEU    49      34.819  18.236  30.791  1.00 15.84           C  
ATOM    370  CG  LEU    49      35.151  17.123  31.790  1.00 16.96           C  
ATOM    371  CD1 LEU    49      34.098  16.007  31.674  1.00 14.35           C  
ATOM    372  CD2 LEU    49      36.594  16.607  31.611  1.00 16.62           C  
ATOM    373  N   PRO    50      35.896  20.603  28.579  1.00 16.79           N  
ATOM    374  CA  PRO    50      35.350  21.431  27.498  1.00 16.48           C  
ATOM    375  C   PRO    50      34.006  20.916  26.994  1.00 15.58           C  
ATOM    376  O   PRO    50      33.717  19.718  27.099  1.00 14.54           O  
ATOM    377  CB  PRO    50      36.381  21.295  26.394  1.00 16.78           C  
ATOM    378  CG  PRO    50      37.671  21.021  27.119  1.00 18.81           C  
ATOM    379  CD  PRO    50      37.237  20.089  28.220  1.00 17.39           C  
ATOM    380  N   PHE    51      33.207  21.836  26.445  1.00 15.67           N  
ATOM    381  CA  PHE    51      31.951  21.486  25.801  1.00 15.66           C  
ATOM    382  C   PHE    51      32.093  20.272  24.886  1.00 15.09           C  
ATOM    383  O   PHE    51      31.305  19.340  24.980  1.00 13.72           O  
ATOM    384  CB  PHE    51      31.409  22.692  25.019  1.00 15.91           C  
ATOM    385  CG  PHE    51      30.303  22.335  24.073  1.00 15.44           C  
ATOM    386  CD1 PHE    51      29.004  22.246  24.535  1.00 14.85           C  
ATOM    387  CD2 PHE    51      30.566  22.058  22.734  1.00 15.25           C  
ATOM    388  CE1 PHE    51      27.982  21.903  23.678  1.00 14.77           C  
ATOM    389  CE2 PHE    51      29.544  21.669  21.876  1.00 15.34           C  
ATOM    390  CZ  PHE    51      28.254  21.595  22.357  1.00 15.95           C  
ATOM    391  N   ALA    52      33.074  20.278  23.986  1.00 14.56           N  
ATOM    392  CA  ALA    52      33.231  19.191  23.033  1.00 14.97           C  
ATOM    393  C   ALA    52      33.367  17.829  23.722  1.00 14.32           C  
ATOM    394  O   ALA    52      32.832  16.826  23.240  1.00 15.48           O  
ATOM    395  CB  ALA    52      34.431  19.461  22.079  1.00 16.41           C  
ATOM    396  N   ILE    53      34.070  17.799  24.858  1.00 13.52           N  
ATOM    397  CA  ILE    53      34.293  16.541  25.575  1.00 13.10           C  
ATOM    398  C   ILE    53      32.998  16.098  26.271  1.00 12.98           C  
ATOM    399  O   ILE    53      32.618  14.930  26.206  1.00 12.86           O  
ATOM    400  CB  ILE    53      35.439  16.689  26.600  1.00 14.32           C  
ATOM    401  CG1 ILE    53      36.765  16.928  25.877  1.00 13.09           C  
ATOM    402  CG2 ILE    53      35.510  15.491  27.543  1.00 13.71           C  
ATOM    403  CD1 ILE    53      37.232  15.819  24.997  1.00 16.75           C  
ATOM    404  N   ARG    54      32.309  17.035  26.918  1.00 11.96           N  
ATOM    405  CA  ARG    54      31.023  16.739  27.569  1.00 13.00           C  
ATOM    406  C   ARG    54      29.969  16.253  26.553  1.00 12.32           C  
ATOM    407  O   ARG    54      29.275  15.261  26.784  1.00 13.11           O  
ATOM    408  CB  ARG    54      30.535  17.944  28.385  1.00 12.76           C  
ATOM    409  CG  ARG    54      31.468  18.239  29.556  1.00 14.19           C  
ATOM    410  CD  ARG    54      31.037  19.427  30.396  1.00 14.34           C  
ATOM    411  NE  ARG    54      31.269  20.704  29.747  1.00 14.76           N  
ATOM    412  CZ  ARG    54      30.337  21.519  29.277  1.00 15.21           C  
ATOM    413  NH1 ARG    54      29.048  21.208  29.324  1.00 15.32           N  
ATOM    414  NH2 ARG    54      30.732  22.668  28.736  1.00 14.70           N  
ATOM    415  N   ALA    55      29.867  16.944  25.431  1.00 12.64           N  
ATOM    416  CA  ALA    55      28.956  16.531  24.353  1.00 12.66           C  
ATOM    417  C   ALA    55      29.296  15.126  23.856  1.00 13.07           C  
ATOM    418  O   ALA    55      28.404  14.301  23.694  1.00 12.99           O  
ATOM    419  CB  ALA    55      28.965  17.548  23.195  1.00 12.53           C  
ATOM    420  N   GLU    56      30.579  14.839  23.633  1.00 13.42           N  
ATOM    421  CA  GLU    56      30.973  13.494  23.174  1.00 14.14           C  
ATOM    422  C   GLU    56      30.703  12.426  24.218  1.00 13.71           C  
ATOM    423  O   GLU    56      30.287  11.312  23.895  1.00 13.72           O  
ATOM    424  CB  GLU    56      32.448  13.464  22.728  1.00 16.10           C  
ATOM    425  CG  GLU    56      32.710  14.116  21.386  1.00 22.93           C  
ATOM    426  CD  GLU    56      31.888  13.493  20.234  1.00 26.82           C  
ATOM    427  OE1 GLU    56      31.798  12.232  20.137  1.00 30.93           O  
ATOM    428  OE2 GLU    56      31.331  14.272  19.434  1.00 33.09           O  
ATOM    429  N   ASN    57      30.898  12.771  25.487  1.00 12.65           N  
ATOM    430  CA  ASN    57      30.575  11.832  26.558  1.00 12.31           C  
ATOM    431  C   ASN    57      29.107  11.444  26.536  1.00 11.13           C  
ATOM    432  O   ASN    57      28.754  10.269  26.685  1.00 12.57           O  
ATOM    433  CB  ASN    57      30.971  12.375  27.925  1.00 12.47           C  
ATOM    434  CG  ASN    57      32.492  12.434  28.113  1.00 13.75           C  
ATOM    435  OD1 ASN    57      33.256  11.797  27.353  1.00 15.72           O  
ATOM    436  ND2 ASN    57      32.949  13.216  29.124  1.00 13.88           N  
ATOM    437  N   VAL    58      28.240  12.433  26.322  1.00 11.74           N  
ATOM    438  CA  VAL    58      26.794  12.165  26.253  1.00 11.83           C  
ATOM    439  C   VAL    58      26.484  11.325  25.009  1.00 12.12           C  
ATOM    440  O   VAL    58      25.775  10.324  25.079  1.00 11.96           O  
ATOM    441  CB  VAL    58      25.977  13.447  26.227  1.00 11.58           C  
ATOM    442  CG1 VAL    58      24.468  13.142  25.954  1.00 12.05           C  
ATOM    443  CG2 VAL    58      26.146  14.209  27.560  1.00 11.65           C  
ATOM    444  N   LYS    59      27.055  11.715  23.888  1.00 13.04           N  
ATOM    445  CA  LYS    59      26.827  10.994  22.631  1.00 14.82           C  
ATOM    446  C   LYS    59      27.242   9.532  22.730  1.00 13.71           C  
ATOM    447  O   LYS    59      26.483   8.644  22.303  1.00 13.83           O  
ATOM    448  CB  LYS    59      27.534  11.682  21.467  1.00 15.36           C  
ATOM    449  CG  LYS    59      26.817  12.936  21.013  1.00 18.62           C  
ATOM    450  CD  LYS    59      27.364  13.425  19.668  1.00 21.46           C  
ATOM    451  CE  LYS    59      28.705  13.980  19.800  1.00 26.55           C  
ATOM    452  NZ  LYS    59      29.234  14.414  18.433  1.00 28.78           N  
ATOM    453  N   ARG    60      28.412   9.267  23.326  1.00 13.45           N  
ATOM    454  CA  ARG    60      28.898   7.893  23.402  1.00 14.28           C  
ATOM    455  C   ARG    60      28.053   7.041  24.312  1.00 13.44           C  
ATOM    456  O   ARG    60      27.846   5.842  24.073  1.00 14.12           O  
ATOM    457  CB  ARG    60      30.337   7.839  23.869  1.00 14.99           C  
ATOM    458  CG  ARG    60      31.298   8.336  22.863  1.00 16.69           C  
ATOM    459  CD  ARG    60      32.716   7.892  23.243  1.00 20.50           C  
ATOM    460  NE  ARG    60      33.703   8.633  22.463  1.00 27.44           N  
ATOM    461  CZ  ARG    60      34.350   9.712  22.895  1.00 29.25           C  
ATOM    462  NH1 ARG    60      34.112  10.197  24.117  1.00 26.46           N  
ATOM    463  NH2 ARG    60      35.210  10.315  22.087  1.00 32.48           N  
ATOM    464  N   TYR    61      27.605   7.659  25.401  1.00 11.76           N  
ATOM    465  CA  TYR    61      26.743   6.966  26.386  1.00 12.36           C  
ATOM    466  C   TYR    61      25.424   6.559  25.724  1.00 11.63           C  
ATOM    467  O   TYR    61      24.978   5.403  25.808  1.00 12.36           O  
ATOM    468  CB  TYR    61      26.496   7.836  27.631  1.00 13.47           C  
ATOM    469  CG  TYR    61      25.439   7.212  28.496  1.00 11.48           C  
ATOM    470  CD1 TYR    61      25.740   6.132  29.305  1.00 12.93           C  
ATOM    471  CD2 TYR    61      24.113   7.653  28.455  1.00 11.47           C  
ATOM    472  CE1 TYR    61      24.790   5.512  30.036  1.00 15.21           C  
ATOM    473  CE2 TYR    61      23.122   7.040  29.213  1.00 11.88           C  
ATOM    474  CZ  TYR    61      23.478   5.954  30.014  1.00 13.60           C  
ATOM    475  OH  TYR    61      22.578   5.264  30.773  1.00 15.02           O  
ATOM    476  N   VAL    62      24.778   7.521  25.071  1.00 11.58           N  
ATOM    477  CA  VAL    62      23.527   7.245  24.365  1.00 11.94           C  
ATOM    478  C   VAL    62      23.693   6.190  23.250  1.00 12.08           C  
ATOM    479  O   VAL    62      22.854   5.298  23.104  1.00 13.31           O  
ATOM    480  CB  VAL    62      22.869   8.537  23.866  1.00 11.30           C  
ATOM    481  CG1 VAL    62      21.642   8.212  22.993  1.00 11.56           C  
ATOM    482  CG2 VAL    62      22.508   9.428  25.105  1.00 11.07           C  
ATOM    483  N   MET    63      24.763   6.286  22.469  1.00 12.42           N  
ATOM    484  CA  MET    63      25.029   5.263  21.453  1.00 13.34           C  
ATOM    485  C   MET    63      25.147   3.884  22.090  1.00 13.30           C  
ATOM    486  O   MET    63      24.519   2.928  21.631  1.00 13.71           O  
ATOM    487  CB  MET    63      26.291   5.595  20.653  1.00 12.85           C  
ATOM    488  CG  MET    63      26.621   4.559  19.570  1.00 14.82           C  
ATOM    489  SD  MET    63      25.317   4.258  18.278  1.00 17.76           S  
ATOM    490  CE  MET    63      25.709   5.680  17.656  1.00  8.33           C  
ATOM    491  N   ARG    64      25.964   3.799  23.141  0.50 13.72           N  
ATOM    493  CA  ARG    64      26.241   2.533  23.838  0.50 14.56           C  
ATOM    495  C   ARG    64      24.987   1.859  24.408  0.50 14.42           C  
ATOM    497  O   ARG    64      24.824   0.644  24.263  0.50 14.42           O  
ATOM    499  CB  ARG    64      27.265   2.801  24.940  0.50 15.09           C  
ATOM    501  CG  ARG    64      27.853   1.605  25.618  0.50 15.34           C  
ATOM    503  CD  ARG    64      29.210   1.947  26.276  0.50 17.30           C  
ATOM    505  NE  ARG    64      29.169   3.050  27.259  0.50 16.86           N  
ATOM    507  CZ  ARG    64      29.507   4.331  27.022  0.50 17.38           C  
ATOM    509  NH1 ARG    64      29.899   4.716  25.812  0.50 13.17           N  
ATOM    511  NH2 ARG    64      29.448   5.247  28.014  0.50 20.95           N  
ATOM    513  N   LYS    65      24.094   2.649  25.020  1.00 13.80           N  
ATOM    514  CA  LYS    65      22.887   2.146  25.716  1.00 14.41           C  
ATOM    515  C   LYS    65      21.624   2.121  24.874  1.00 14.43           C  
ATOM    516  O   LYS    65      20.746   1.303  25.112  1.00 16.33           O  
ATOM    517  CB  LYS    65      22.623   2.939  26.999  1.00 15.92           C  
ATOM    518  CG  LYS    65      23.678   2.760  28.045  1.00 19.23           C  
ATOM    519  CD  LYS    65      23.737   1.341  28.574  1.00 21.94           C  
ATOM    520  CE  LYS    65      24.663   1.222  29.780  1.00 23.96           C  
ATOM    521  NZ  LYS    65      24.661  -0.194  30.289  1.00 25.58           N  
ATOM    522  N   TYR    66      21.528   3.011  23.896  1.00 13.32           N  
ATOM    523  CA  TYR    66      20.300   3.181  23.111  1.00 13.30           C  
ATOM    524  C   TYR    66      20.442   3.008  21.616  1.00 13.49           C  
ATOM    525  O   TYR    66      19.426   2.968  20.911  1.00 13.88           O  
ATOM    526  CB  TYR    66      19.638   4.540  23.378  1.00 13.48           C  
ATOM    527  CG  TYR    66      19.282   4.697  24.838  1.00 11.89           C  
ATOM    528  CD1 TYR    66      18.062   4.231  25.336  1.00 11.09           C  
ATOM    529  CD2 TYR    66      20.170   5.276  25.758  1.00 11.93           C  
ATOM    530  CE1 TYR    66      17.734   4.359  26.701  1.00 11.94           C  
ATOM    531  CE2 TYR    66      19.839   5.385  27.100  1.00 13.26           C  
ATOM    532  CZ  TYR    66      18.645   4.893  27.579  1.00 11.02           C  
ATOM    533  OH  TYR    66      18.347   5.055  28.942  1.00 11.73           O  
ATOM    534  N   GLY    67      21.674   2.903  21.136  1.00 13.02           N  
ATOM    535  CA  GLY    67      21.922   2.550  19.739  1.00 13.78           C  
ATOM    536  C   GLY    67      21.686   3.655  18.734  1.00 14.04           C  
ATOM    537  O   GLY    67      21.559   3.372  17.530  1.00 15.18           O  
ATOM    538  N   PHE    68      21.678   4.924  19.181  1.00 13.26           N  
ATOM    539  CA  PHE    68      21.738   6.047  18.237  1.00 13.90           C  
ATOM    540  C   PHE    68      22.568   7.203  18.773  1.00 14.46           C  
ATOM    541  O   PHE    68      22.832   7.286  19.974  1.00 13.19           O  
ATOM    542  CB  PHE    68      20.337   6.507  17.850  1.00 14.20           C  
ATOM    543  CG  PHE    68      19.596   7.193  18.936  1.00 13.61           C  
ATOM    544  CD1 PHE    68      19.516   8.576  18.964  1.00 14.78           C  
ATOM    545  CD2 PHE    68      18.916   6.483  19.917  1.00 13.82           C  
ATOM    546  CE1 PHE    68      18.793   9.232  19.964  1.00 13.23           C  
ATOM    547  CE2 PHE    68      18.205   7.159  20.922  1.00 13.92           C  
ATOM    548  CZ  PHE    68      18.125   8.533  20.898  1.00 14.22           C  
ATOM    549  N   GLU    69      23.016   8.045  17.853  1.00 15.92           N  
ATOM    550  CA  GLU    69      23.665   9.293  18.209  1.00 17.21           C  
ATOM    551  C   GLU    69      22.617  10.410  18.348  1.00 16.92           C  
ATOM    552  O   GLU    69      21.981  10.808  17.346  1.00 17.49           O  
ATOM    553  CB  GLU    69      24.628   9.713  17.103  1.00 18.08           C  
ATOM    554  CG  GLU    69      25.473  10.934  17.498  1.00 20.54           C  
ATOM    555  CD  GLU    69      26.255  11.510  16.317  1.00 23.59           C  
ATOM    556  OE1 GLU    69      26.780  10.698  15.531  1.00 31.39           O  
ATOM    557  OE2 GLU    69      26.327  12.755  16.176  1.00 31.71           O  
ATOM    558  N   PRO    70      22.444  10.965  19.563  1.00 16.76           N  
ATOM    559  CA  PRO    70      21.428  11.994  19.781  1.00 16.70           C  
ATOM    560  C   PRO    70      21.843  13.338  19.195  1.00 17.28           C  
ATOM    561  O   PRO    70      23.032  13.625  19.113  1.00 17.29           O  
ATOM    562  CB  PRO    70      21.370  12.117  21.316  1.00 16.88           C  
ATOM    563  CG  PRO    70      22.738  11.763  21.745  1.00 16.50           C  
ATOM    564  CD  PRO    70      23.243  10.708  20.774  1.00 17.16           C  
ATOM    565  N   GLU    71      20.852  14.149  18.838  1.00 17.75           N  
ATOM    566  CA  GLU    71      21.089  15.538  18.481  1.00 18.43           C  
ATOM    567  C   GLU    71      21.540  16.292  19.741  1.00 17.06           C  
ATOM    568  O   GLU    71      20.790  16.345  20.733  1.00 17.40           O  
ATOM    569  CB  GLU    71      19.815  16.218  17.918  1.00 18.79           C  
ATOM    570  CG  GLU    71      20.024  17.725  17.587  1.00 20.45           C  
ATOM    571  CD  GLU    71      18.779  18.509  17.176  1.00 23.94           C  
ATOM    572  OE1 GLU    71      17.629  18.145  17.560  1.00 30.68           O  
ATOM    573  OE2 GLU    71      18.987  19.547  16.475  1.00 30.11           O  
ATOM    574  N   ILE    72      22.717  16.915  19.662  1.00 17.07           N  
ATOM    575  CA  ILE    72      23.248  17.793  20.705  1.00 16.89           C  
ATOM    576  C   ILE    72      23.207  19.233  20.216  1.00 17.09           C  
ATOM    577  O   ILE    72      23.688  19.549  19.113  1.00 17.97           O  
ATOM    578  CB  ILE    72      24.764  17.518  21.065  1.00 17.10           C  
ATOM    579  CG1 ILE    72      24.980  16.083  21.537  1.00 18.57           C  
ATOM    580  CG2 ILE    72      25.287  18.504  22.133  1.00 17.34           C  
ATOM    581  CD1 ILE    72      24.184  15.707  22.628  1.00 18.29           C  
ATOM    582  N   VAL    73      22.716  20.107  21.058  1.00 16.13           N  
ATOM    583  CA  VAL    73      22.765  21.537  20.763  1.00 17.66           C  
ATOM    584  C   VAL    73      23.485  22.241  21.915  1.00 16.58           C  
ATOM    585  O   VAL    73      23.312  21.877  23.084  1.00 16.35           O  
ATOM    586  CB  VAL    73      21.345  22.092  20.523  1.00 18.63           C  
ATOM    587  CG1 VAL    73      20.644  21.332  19.375  1.00 22.38           C  
ATOM    588  CG2 VAL    73      20.534  21.982  21.742  1.00 19.90           C  
ATOM    589  N   LYS    74      24.365  23.187  21.602  1.00 16.47           N  
ATOM    590  CA  LYS    74      24.999  23.974  22.645  1.00 16.56           C  
ATOM    591  C   LYS    74      23.994  24.952  23.226  1.00 16.03           C  
ATOM    592  O   LYS    74      23.319  25.703  22.477  1.00 16.09           O  
ATOM    593  CB  LYS    74      26.206  24.748  22.098  1.00 16.48           C  
ATOM    594  CG  LYS    74      26.997  25.464  23.135  1.00 16.70           C  
ATOM    595  CD  LYS    74      28.140  26.283  22.521  1.00 18.90           C  
ATOM    596  CE  LYS    74      29.236  25.419  21.913  1.00 19.91           C  
ATOM    597  NZ  LYS    74      30.425  26.220  21.394  1.00 21.89           N  
ATOM    598  N   ILE    75      23.901  24.945  24.549  1.00 15.14           N  
ATOM    599  CA  ILE    75      23.079  25.906  25.298  1.00 15.73           C  
ATOM    600  C   ILE    75      23.963  27.119  25.607  1.00 15.81           C  
ATOM    601  O   ILE    75      24.993  26.990  26.257  1.00 15.11           O  
ATOM    602  CB  ILE    75      22.539  25.284  26.610  1.00 15.47           C  
ATOM    603  CG1 ILE    75      21.617  24.098  26.342  1.00 16.98           C  
ATOM    604  CG2 ILE    75      21.769  26.311  27.426  1.00 16.63           C  
ATOM    605  CD1 ILE    75      21.311  23.242  27.597  1.00 17.89           C  
ATOM    606  N   THR    76      23.574  28.284  25.088  1.00 15.68           N  
ATOM    607  CA  THR    76      24.336  29.527  25.255  1.00 16.59           C  
ATOM    608  C   THR    76      23.535  30.635  25.969  1.00 17.47           C  
ATOM    609  O   THR    76      24.002  31.765  26.127  1.00 18.88           O  
ATOM    610  CB  THR    76      24.801  30.007  23.877  1.00 16.61           C  
ATOM    611  OG1 THR    76      23.646  30.271  23.070  1.00 17.91           O  
ATOM    612  CG2 THR    76      25.679  28.903  23.215  1.00 18.43           C  
ATOM    613  N   ASN    77      22.335  30.302  26.422  1.00 16.68           N  
ATOM    614  CA  ASN    77      21.570  31.172  27.297  1.00 16.46           C  
ATOM    615  C   ASN    77      20.719  30.263  28.177  1.00 17.27           C  
ATOM    616  O   ASN    77      20.585  29.063  27.885  1.00 15.70           O  
ATOM    617  CB  ASN    77      20.742  32.152  26.443  1.00 15.99           C  
ATOM    618  CG  ASN    77      19.507  31.502  25.847  1.00 15.62           C  
ATOM    619  OD1 ASN    77      18.517  31.327  26.536  1.00 16.24           O  
ATOM    620  ND2 ASN    77      19.549  31.165  24.556  1.00 17.12           N  
ATOM    621  N   PRO    78      20.145  30.812  29.264  1.00 18.76           N  
ATOM    622  CA  PRO    78      19.420  29.969  30.232  1.00 19.15           C  
ATOM    623  C   PRO    78      18.264  29.140  29.657  1.00 18.58           C  
ATOM    624  O   PRO    78      17.904  28.090  30.199  1.00 20.15           O  
ATOM    625  CB  PRO    78      18.861  30.980  31.226  1.00 19.82           C  
ATOM    626  CG  PRO    78      19.736  32.142  31.133  1.00 21.04           C  
ATOM    627  CD  PRO    78      20.206  32.223  29.690  1.00 19.89           C  
ATOM    628  N   TYR    79      17.661  29.628  28.588  1.00 17.34           N  
ATOM    629  CA  TYR    79      16.519  28.976  27.991  1.00 16.20           C  
ATOM    630  C   TYR    79      16.861  28.000  26.901  1.00 15.47           C  
ATOM    631  O   TYR    79      15.985  27.238  26.466  1.00 15.10           O  
ATOM    632  CB  TYR    79      15.597  30.010  27.352  1.00 15.90           C  
ATOM    633  CG  TYR    79      15.011  30.950  28.345  1.00 15.48           C  
ATOM    634  CD1 TYR    79      13.769  30.704  28.911  1.00 17.45           C  
ATOM    635  CD2 TYR    79      15.698  32.086  28.743  1.00 14.04           C  
ATOM    636  CE1 TYR    79      13.247  31.569  29.830  1.00 16.85           C  
ATOM    637  CE2 TYR    79      15.180  32.944  29.667  1.00 16.91           C  
ATOM    638  CZ  TYR    79      13.951  32.687  30.215  1.00 15.93           C  
ATOM    639  OH  TYR    79      13.422  33.585  31.115  1.00 18.91           O  
ATOM    640  N   GLY    80      18.092  28.053  26.408  1.00 15.25           N  
ATOM    641  CA  GLY    80      18.435  27.321  25.183  1.00 15.81           C  
ATOM    642  C   GLY    80      17.470  27.711  24.100  1.00 15.93           C  
ATOM    643  O   GLY    80      17.229  28.904  23.883  1.00 15.35           O  
ATOM    644  N   LYS    81      16.896  26.705  23.444  1.00 15.81           N  
ATOM    645  CA  LYS    81      15.927  26.917  22.377  1.00 17.49           C  
ATOM    646  C   LYS    81      14.467  26.838  22.838  1.00 15.60           C  
ATOM    647  O   LYS    81      13.548  26.860  22.027  1.00 15.50           O  
ATOM    648  CB  LYS    81      16.108  25.871  21.272  1.00 18.87           C  
ATOM    649  CG  LYS    81      17.442  25.873  20.529  1.00 23.70           C  
ATOM    650  CD  LYS    81      17.345  24.877  19.355  1.00 24.41           C  
ATOM    651  CE  LYS    81      17.208  23.371  19.816  1.00 29.76           C  
ATOM    652  NZ  LYS    81      16.368  22.506  18.879  1.00 31.50           N  
ATOM    653  N   THR    82      14.247  26.741  24.138  1.00 14.47           N  
ATOM    654  CA  THR    82      12.922  26.387  24.622  1.00 14.90           C  
ATOM    655  C   THR    82      11.891  27.506  24.569  1.00 14.91           C  
ATOM    656  O   THR    82      10.742  27.263  24.840  1.00 15.20           O  
ATOM    657  CB  THR    82      12.971  25.865  26.071  1.00 14.78           C  
ATOM    658  OG1 THR    82      13.427  26.918  26.913  1.00 13.78           O  
ATOM    659  CG2 THR    82      13.856  24.607  26.195  1.00 14.24           C  
ATOM    660  N   LEU    83      12.277  28.739  24.191  1.00 14.68           N  
ATOM    661  CA  LEU    83      11.285  29.788  23.967  1.00 16.16           C  
ATOM    662  C   LEU    83      10.883  29.888  22.509  1.00 17.95           C  
ATOM    663  O   LEU    83      10.008  30.664  22.167  1.00 19.26           O  
ATOM    664  CB  LEU    83      11.822  31.145  24.427  1.00 15.28           C  
ATOM    665  CG  LEU    83      12.125  31.268  25.910  1.00 13.89           C  
ATOM    666  CD1 LEU    83      12.576  32.666  26.258  1.00 14.46           C  
ATOM    667  CD2 LEU    83      10.934  30.832  26.753  1.00 15.10           C  
ATOM    668  N   ASP    84      11.548  29.121  21.654  1.00 18.26           N  
ATOM    669  CA  ASP    84      11.417  29.242  20.207  1.00 19.93           C  
ATOM    670  C   ASP    84      10.801  27.950  19.651  1.00 20.58           C  
ATOM    671  O   ASP    84       9.717  27.960  19.040  1.00 23.22           O  
ATOM    672  CB  ASP    84      12.823  29.503  19.631  1.00 20.41           C  
ATOM    673  CG  ASP    84      12.804  30.124  18.266  1.00 23.44           C  
ATOM    674  OD1 ASP    84      11.772  30.721  17.880  1.00 24.14           O  
ATOM    675  OD2 ASP    84      13.849  30.020  17.590  1.00 28.03           O  
ATOM    676  N   VAL    85      11.448  26.835  19.926  1.00 19.96           N  
ATOM    677  CA  VAL    85      11.002  25.535  19.429  1.00 20.01           C  
ATOM    678  C   VAL    85       9.839  25.044  20.248  1.00 19.61           C  
ATOM    679  O   VAL    85       9.802  25.242  21.486  1.00 20.17           O  
ATOM    680  CB  VAL    85      12.156  24.504  19.500  1.00 20.71           C  
ATOM    681  CG1 VAL    85      11.684  23.068  19.069  1.00 20.75           C  
ATOM    682  CG2 VAL    85      13.355  24.973  18.702  1.00 21.26           C  
ATOM    683  N   ASP    86       8.904  24.360  19.591  1.00 18.57           N  
ATOM    684  CA  ASP    86       7.778  23.773  20.272  1.00 18.03           C  
ATOM    685  C   ASP    86       8.215  22.357  20.629  1.00 18.31           C  
ATOM    686  O   ASP    86       8.616  21.555  19.737  1.00 23.07           O  
ATOM    687  CB  ASP    86       6.488  23.770  19.447  1.00 18.24           C  
ATOM    688  CG  ASP    86       5.892  25.171  19.250  1.00 19.60           C  
ATOM    689  OD1 ASP    86       6.122  26.073  20.083  1.00 20.00           O  
ATOM    690  OD2 ASP    86       5.164  25.373  18.247  1.00 26.95           O  
ATOM    691  N   PHE    87       8.274  22.110  21.921  1.00 15.77           N  
ATOM    692  CA  PHE    87       8.522  20.796  22.489  1.00 14.97           C  
ATOM    693  C   PHE    87       7.238  20.306  23.139  1.00 14.36           C  
ATOM    694  O   PHE    87       6.475  21.101  23.715  1.00 16.07           O  
ATOM    695  CB  PHE    87       9.616  20.868  23.578  1.00 15.50           C  
ATOM    696  CG  PHE    87      10.971  21.209  23.058  1.00 13.43           C  
ATOM    697  CD1 PHE    87      11.752  20.245  22.439  1.00 13.21           C  
ATOM    698  CD2 PHE    87      11.496  22.490  23.219  1.00 15.72           C  
ATOM    699  CE1 PHE    87      13.005  20.557  21.948  1.00 14.34           C  
ATOM    700  CE2 PHE    87      12.758  22.807  22.744  1.00 17.48           C  
ATOM    701  CZ  PHE    87      13.516  21.837  22.100  1.00 17.13           C  
ATOM    702  N   GLU    88       7.011  19.003  23.075  1.00 13.81           N  
ATOM    703  CA  GLU    88       5.893  18.411  23.800  1.00 14.23           C  
ATOM    704  C   GLU    88       6.193  18.236  25.306  1.00 12.95           C  
ATOM    705  O   GLU    88       5.342  18.519  26.146  1.00 13.84           O  
ATOM    706  CB  GLU    88       5.515  17.067  23.187  1.00 15.08           C  
ATOM    707  CG  GLU    88       4.282  16.458  23.785  1.00 17.83           C  
ATOM    708  CD  GLU    88       3.724  15.289  22.946  1.00 20.60           C  
ATOM    709  OE1 GLU    88       4.189  15.082  21.791  1.00 27.86           O  
ATOM    710  OE2 GLU    88       2.828  14.573  23.439  1.00 28.57           O  
ATOM    711  N   TYR    89       7.396  17.755  25.620  1.00 11.81           N  
ATOM    712  CA  TYR    89       7.822  17.477  26.990  1.00 11.27           C  
ATOM    713  C   TYR    89       9.185  18.150  27.213  1.00 11.40           C  
ATOM    714  O   TYR    89      10.022  18.186  26.305  1.00 10.90           O  
ATOM    715  CB  TYR    89       8.001  15.959  27.202  1.00 11.70           C  
ATOM    716  CG  TYR    89       6.701  15.179  27.204  1.00 12.19           C  
ATOM    717  CD1 TYR    89       5.759  15.378  28.197  1.00 12.35           C  
ATOM    718  CD2 TYR    89       6.420  14.245  26.208  1.00 13.35           C  
ATOM    719  CE1 TYR    89       4.590  14.667  28.227  1.00 13.25           C  
ATOM    720  CE2 TYR    89       5.223  13.539  26.212  1.00 15.02           C  
ATOM    721  CZ  TYR    89       4.314  13.757  27.240  1.00 13.79           C  
ATOM    722  OH  TYR    89       3.100  13.075  27.329  1.00 15.53           O  
ATOM    723  N   LEU    90       9.390  18.599  28.444  1.00 10.72           N  
ATOM    724  CA  LEU    90      10.661  19.111  28.917  1.00 11.33           C  
ATOM    725  C   LEU    90      10.997  18.313  30.166  1.00 10.59           C  
ATOM    726  O   LEU    90      10.265  18.374  31.171  1.00 10.36           O  
ATOM    727  CB  LEU    90      10.537  20.595  29.263  1.00 11.48           C  
ATOM    728  CG  LEU    90      11.730  21.327  29.933  1.00 13.14           C  
ATOM    729  CD1 LEU    90      13.088  21.124  29.246  1.00 16.06           C  
ATOM    730  CD2 LEU    90      11.381  22.844  30.128  1.00 14.77           C  
ATOM    731  N   VAL    91      12.056  17.523  30.073  1.00 11.25           N  
ATOM    732  CA  VAL    91      12.467  16.603  31.118  1.00 11.78           C  
ATOM    733  C   VAL    91      13.546  17.294  31.947  1.00 12.13           C  
ATOM    734  O   VAL    91      14.563  17.728  31.398  1.00 13.11           O  
ATOM    735  CB  VAL    91      13.013  15.263  30.558  1.00 11.91           C  
ATOM    736  CG1 VAL    91      13.604  14.415  31.728  1.00 14.39           C  
ATOM    737  CG2 VAL    91      11.892  14.530  29.836  1.00 13.13           C  
ATOM    738  N   VAL    92      13.292  17.388  33.255  1.00 11.12           N  
ATOM    739  CA  VAL    92      14.135  18.135  34.179  1.00 11.34           C  
ATOM    740  C   VAL    92      14.345  17.380  35.487  1.00 12.37           C  
ATOM    741  O   VAL    92      13.673  16.429  35.767  1.00 12.98           O  
ATOM    742  CB  VAL    92      13.537  19.547  34.477  1.00 11.68           C  
ATOM    743  CG1 VAL    92      13.545  20.355  33.200  1.00 13.42           C  
ATOM    744  CG2 VAL    92      12.166  19.458  35.073  1.00 12.28           C  
ATOM    745  N   SER    93      15.339  17.818  36.244  1.00 14.03           N  
ATOM    746  CA  SER    93      15.642  17.281  37.555  1.00 14.54           C  
ATOM    747  C   SER    93      15.206  18.301  38.588  1.00 15.11           C  
ATOM    748  O   SER    93      14.753  19.388  38.238  1.00 15.71           O  
ATOM    749  CB  SER    93      17.135  17.060  37.674  1.00 16.06           C  
ATOM    750  OG  SER    93      17.804  18.285  37.808  1.00 18.04           O  
ATOM    751  N   PRO    94      15.332  17.972  39.877  1.00 15.47           N  
ATOM    752  CA  PRO    94      15.004  18.996  40.883  1.00 16.58           C  
ATOM    753  C   PRO    94      15.843  20.256  40.761  1.00 17.77           C  
ATOM    754  O   PRO    94      15.346  21.342  41.078  1.00 20.38           O  
ATOM    755  CB  PRO    94      15.260  18.267  42.217  1.00 17.45           C  
ATOM    756  CG  PRO    94      15.055  16.804  41.873  1.00 17.30           C  
ATOM    757  CD  PRO    94      15.645  16.658  40.487  1.00 16.19           C  
ATOM    758  N   GLU    95      17.050  20.129  40.222  1.00 18.27           N  
ATOM    759  CA  GLU    95      17.962  21.254  40.080  1.00 20.11           C  
ATOM    760  C   GLU    95      17.563  22.185  38.942  1.00 19.08           C  
ATOM    761  O   GLU    95      17.938  23.379  38.936  1.00 20.74           O  
ATOM    762  CB  GLU    95      19.392  20.766  39.820  1.00 21.60           C  
ATOM    763  CG  GLU    95      20.026  20.044  40.999  1.00 25.73           C  
ATOM    764  CD  GLU    95      21.471  19.634  40.725  1.00 27.29           C  
ATOM    765  OE1 GLU    95      22.036  20.018  39.662  1.00 35.14           O  
ATOM    766  OE2 GLU    95      22.058  18.923  41.578  1.00 35.97           O  
ATOM    767  N   THR    96      16.789  21.659  37.997  1.00 16.64           N  
ATOM    768  CA  THR    96      16.410  22.448  36.808  1.00 16.79           C  
ATOM    769  C   THR    96      14.883  22.697  36.720  1.00 15.67           C  
ATOM    770  O   THR    96      14.382  23.320  35.776  1.00 15.11           O  
ATOM    771  CB  THR    96      16.957  21.794  35.520  1.00 18.25           C  
ATOM    772  OG1 THR    96      16.578  20.416  35.468  1.00 19.93           O  
ATOM    773  CG2 THR    96      18.488  21.879  35.488  1.00 19.96           C  
ATOM    774  N   TYR    97      14.149  22.267  37.736  1.00 13.50           N  
ATOM    775  CA  TYR    97      12.688  22.405  37.718  1.00 14.27           C  
ATOM    776  C   TYR    97      12.217  23.869  37.810  1.00 13.74           C  
ATOM    777  O   TYR    97      11.298  24.282  37.100  1.00 12.80           O  
ATOM    778  CB  TYR    97      12.083  21.556  38.829  1.00 14.67           C  
ATOM    779  CG  TYR    97      10.585  21.625  38.948  1.00 14.02           C  
ATOM    780  CD1 TYR    97       9.744  21.153  37.955  1.00 14.72           C  
ATOM    781  CD2 TYR    97       9.998  22.157  40.065  1.00 15.94           C  
ATOM    782  CE1 TYR    97       8.372  21.226  38.070  1.00 14.52           C  
ATOM    783  CE2 TYR    97       8.630  22.227  40.192  1.00 17.94           C  
ATOM    784  CZ  TYR    97       7.814  21.752  39.195  1.00 17.04           C  
ATOM    785  OH  TYR    97       6.452  21.827  39.333  1.00 17.72           O  
ATOM    786  N   GLU    98      12.856  24.672  38.666  1.00 14.09           N  
ATOM    787  CA  GLU    98      12.456  26.072  38.750  1.00 14.94           C  
ATOM    788  C   GLU    98      12.639  26.753  37.394  1.00 13.33           C  
ATOM    789  O   GLU    98      11.807  27.588  36.991  1.00 14.13           O  
ATOM    790  CB  GLU    98      13.238  26.792  39.848  1.00 15.29           C  
ATOM    791  CG  GLU    98      12.734  26.400  41.225  1.00 18.61           C  
ATOM    792  CD  GLU    98      13.658  26.851  42.363  1.00 19.35           C  
ATOM    793  OE1 GLU    98      14.796  26.347  42.441  1.00 27.21           O  
ATOM    794  OE2 GLU    98      13.235  27.698  43.164  1.00 25.66           O  
ATOM    795  N   MET    99      13.703  26.403  36.675  1.00 14.45           N  
ATOM    796  CA  MET    99      13.956  27.028  35.381  1.00 13.61           C  
ATOM    797  C   MET    99      12.881  26.572  34.387  1.00 13.41           C  
ATOM    798  O   MET    99      12.441  27.364  33.539  1.00 12.92           O  
ATOM    799  CB  MET    99      15.348  26.744  34.847  1.00 13.90           C  
ATOM    800  CG  MET    99      15.663  27.451  33.512  1.00 15.51           C  
ATOM    801  SD  MET    99      15.889  29.262  33.666  1.00 13.60           S  
ATOM    802  CE  MET    99      15.240  29.846  32.084  1.00 19.76           C  
ATOM    803  N   ALA   100      12.452  25.316  34.480  1.00 11.89           N  
ATOM    804  CA  ALA   100      11.332  24.834  33.639  1.00 12.65           C  
ATOM    805  C   ALA   100      10.066  25.663  33.854  1.00 12.02           C  
ATOM    806  O   ALA   100       9.364  26.011  32.916  1.00 11.38           O  
ATOM    807  CB  ALA   100      11.025  23.393  33.950  1.00 13.36           C  
ATOM    808  N   LEU   101       9.740  25.944  35.107  1.00 12.49           N  
ATOM    809  CA  LEU   101       8.566  26.776  35.367  1.00 12.91           C  
ATOM    810  C   LEU   101       8.731  28.160  34.734  1.00 12.58           C  
ATOM    811  O   LEU   101       7.790  28.699  34.160  1.00 13.21           O  
ATOM    812  CB  LEU   101       8.307  26.920  36.854  1.00 13.70           C  
ATOM    813  CG  LEU   101       7.965  25.594  37.567  1.00 14.39           C  
ATOM    814  CD1 LEU   101       7.941  25.869  39.084  1.00 17.21           C  
ATOM    815  CD2 LEU   101       6.666  24.971  37.060  1.00 15.43           C  
ATOM    816  N   LYS   102       9.936  28.697  34.821  1.00 12.71           N  
ATOM    817  CA  LYS   102      10.269  30.007  34.210  1.00 13.30           C  
ATOM    818  C   LYS   102      10.116  29.974  32.672  1.00 12.90           C  
ATOM    819  O   LYS   102       9.587  30.925  32.047  1.00 12.75           O  
ATOM    820  CB  LYS   102      11.676  30.467  34.625  1.00 14.96           C  
ATOM    821  CG  LYS   102      12.126  31.790  34.060  1.00 16.12           C  
ATOM    822  CD  LYS   102      11.341  32.917  34.623  1.00 20.18           C  
ATOM    823  CE  LYS   102      12.098  34.236  34.497  1.00 20.75           C  
ATOM    824  NZ  LYS   102      11.340  35.316  35.172  1.00 23.62           N  
ATOM    825  N   ILE   103      10.605  28.895  32.084  1.00 11.64           N  
ATOM    826  CA  ILE   103      10.440  28.652  30.646  1.00 11.86           C  
ATOM    827  C   ILE   103       8.949  28.760  30.240  1.00 11.89           C  
ATOM    828  O   ILE   103       8.607  29.472  29.300  1.00 11.81           O  
ATOM    829  CB  ILE   103      11.081  27.329  30.208  1.00 11.04           C  
ATOM    830  CG1 ILE   103      12.632  27.440  30.216  1.00 11.84           C  
ATOM    831  CG2 ILE   103      10.561  26.907  28.838  1.00 12.00           C  
ATOM    832  CD1 ILE   103      13.414  26.109  30.239  1.00 11.87           C  
ATOM    833  N   ASN   104       8.059  28.078  30.966  1.00 11.29           N  
ATOM    834  CA  ASN   104       6.640  28.127  30.617  1.00 12.57           C  
ATOM    835  C   ASN   104       6.045  29.514  30.861  1.00 12.86           C  
ATOM    836  O   ASN   104       5.206  29.965  30.091  1.00 13.08           O  
ATOM    837  CB  ASN   104       5.828  27.054  31.347  1.00 13.28           C  
ATOM    838  CG  ASN   104       5.804  25.750  30.587  1.00 11.78           C  
ATOM    839  OD1 ASN   104       6.081  25.739  29.355  1.00 13.35           O  
ATOM    840  ND2 ASN   104       5.440  24.664  31.259  1.00 12.46           N  
ATOM    841  N   GLN   105       6.527  30.212  31.895  1.00 13.24           N  
ATOM    842  CA  GLN   105       6.027  31.575  32.183  1.00 14.94           C  
ATOM    843  C   GLN   105       6.349  32.487  31.015  1.00 14.48           C  
ATOM    844  O   GLN   105       5.466  33.220  30.507  1.00 14.27           O  
ATOM    845  CB  GLN   105       6.623  32.126  33.470  1.00 15.54           C  
ATOM    846  CG  GLN   105       6.048  31.483  34.684  1.00 19.27           C  
ATOM    847  CD  GLN   105       6.812  31.779  35.953  1.00 21.05           C  
ATOM    848  OE1 GLN   105       7.813  32.507  35.950  1.00 27.77           O  
ATOM    849  NE2 GLN   105       6.340  31.210  37.060  1.00 31.26           N  
ATOM    850  N   LYS   106       7.597  32.386  30.539  1.00 14.13           N  
ATOM    851  CA  LYS   106       8.028  33.210  29.404  1.00 13.78           C  
ATOM    852  C   LYS   106       7.352  32.801  28.102  1.00 13.10           C  
ATOM    853  O   LYS   106       7.029  33.652  27.273  1.00 11.97           O  
ATOM    854  CB  LYS   106       9.543  33.208  29.228  1.00 14.19           C  
ATOM    855  CG  LYS   106      10.259  33.941  30.303  1.00 18.32           C  
ATOM    856  CD  LYS   106      10.060  35.427  30.112  1.00 21.04           C  
ATOM    857  CE  LYS   106      10.546  36.193  31.255  1.00 24.98           C  
ATOM    858  NZ  LYS   106      10.128  37.610  31.050  1.00 26.40           N  
ATOM    859  N   ARG   107       7.190  31.505  27.886  1.00 12.79           N  
ATOM    860  CA  ARG   107       6.443  31.067  26.714  1.00 13.42           C  
ATOM    861  C   ARG   107       5.045  31.685  26.736  1.00 14.01           C  
ATOM    862  O   ARG   107       4.575  32.194  25.714  1.00 13.64           O  
ATOM    863  CB  ARG   107       6.385  29.547  26.629  1.00 12.63           C  
ATOM    864  CG  ARG   107       7.713  28.952  26.186  1.00 12.41           C  
ATOM    865  CD  ARG   107       7.684  27.448  26.118  1.00 13.49           C  
ATOM    866  NE  ARG   107       6.808  26.931  25.059  1.00 13.18           N  
ATOM    867  CZ  ARG   107       7.163  26.635  23.808  1.00 13.92           C  
ATOM    868  NH1 ARG   107       8.401  26.810  23.385  1.00 13.78           N  
ATOM    869  NH2 ARG   107       6.260  26.127  22.963  1.00 14.25           N  
ATOM    870  N   GLU   108       4.392  31.657  27.887  1.00 15.11           N  
ATOM    871  CA  GLU   108       3.042  32.245  27.939  1.00 16.75           C  
ATOM    872  C   GLU   108       3.090  33.736  27.614  1.00 16.81           C  
ATOM    873  O   GLU   108       2.224  34.249  26.894  1.00 17.86           O  
ATOM    874  CB  GLU   108       2.356  31.985  29.274  1.00 17.37           C  
ATOM    875  CG  GLU   108       0.890  32.480  29.273  1.00 19.28           C  
ATOM    876  CD  GLU   108       0.089  31.985  30.476  1.00 23.61           C  
ATOM    877  OE1 GLU   108       0.678  31.472  31.428  1.00 31.69           O  
ATOM    878  OE2 GLU   108      -1.163  32.139  30.460  1.00 35.89           O  
ATOM    879  N   GLU   109       4.083  34.437  28.133  1.00 16.41           N  
ATOM    880  CA  GLU   109       4.211  35.871  27.856  1.00 17.00           C  
ATOM    881  C   GLU   109       4.443  36.162  26.370  1.00 16.36           C  
ATOM    882  O   GLU   109       3.997  37.203  25.854  1.00 15.75           O  
ATOM    883  CB  GLU   109       5.353  36.488  28.667  1.00 17.44           C  
ATOM    884  CG  GLU   109       5.110  36.502  30.157  1.00 20.52           C  
ATOM    885  CD  GLU   109       6.262  37.091  30.937  1.00 21.92           C  
ATOM    886  OE1 GLU   109       7.149  37.757  30.345  1.00 25.86           O  
ATOM    887  OE2 GLU   109       6.264  36.909  32.183  1.00 31.37           O  
ATOM    888  N   LEU   110       5.183  35.284  25.701  1.00 14.42           N  
ATOM    889  CA  LEU   110       5.557  35.468  24.307  1.00 15.12           C  
ATOM    890  C   LEU   110       4.475  35.023  23.320  1.00 14.70           C  
ATOM    891  O   LEU   110       4.491  35.440  22.147  1.00 16.14           O  
ATOM    892  CB  LEU   110       6.833  34.694  24.000  1.00 15.98           C  
ATOM    893  CG  LEU   110       8.086  35.231  24.705  1.00 16.10           C  
ATOM    894  CD1 LEU   110       9.207  34.213  24.475  1.00 18.76           C  
ATOM    895  CD2 LEU   110       8.442  36.645  24.222  1.00 15.74           C  
ATOM    896  N   GLY   111       3.535  34.215  23.790  1.00 13.69           N  
ATOM    897  CA  GLY   111       2.463  33.680  22.955  1.00 14.39           C  
ATOM    898  C   GLY   111       2.781  32.328  22.364  1.00 14.54           C  
ATOM    899  O   GLY   111       2.374  32.015  21.233  1.00 14.85           O  
ATOM    900  N   LYS   112       3.517  31.527  23.144  1.00 14.09           N  
ATOM    901  CA  LYS   112       3.825  30.140  22.785  1.00 16.27           C  
ATOM    902  C   LYS   112       3.070  29.189  23.697  1.00 16.18           C  
ATOM    903  O   LYS   112       2.888  29.466  24.894  1.00 17.12           O  
ATOM    904  CB  LYS   112       5.314  29.895  22.963  1.00 16.35           C  
ATOM    905  CG  LYS   112       6.211  30.796  22.207  1.00 18.82           C  
ATOM    906  CD  LYS   112       6.196  30.503  20.751  1.00 21.02           C  
ATOM    907  CE  LYS   112       6.995  29.250  20.414  1.00 22.96           C  
ATOM    908  NZ  LYS   112       6.780  28.819  19.010  1.00 22.04           N  
ATOM    909  N   ARG   113       2.670  28.043  23.169  1.00 16.05           N  
ATOM    910  CA  ARG   113       1.990  27.063  24.020  1.00 18.05           C  
ATOM    911  C   ARG   113       2.943  26.507  25.064  1.00 15.90           C  
ATOM    912  O   ARG   113       4.093  26.301  24.796  1.00 14.60           O  
ATOM    913  CB  ARG   113       1.438  25.912  23.228  1.00 18.52           C  
ATOM    914  CG  ARG   113       2.433  25.132  22.454  1.00 24.08           C  
ATOM    915  CD  ARG   113       1.831  23.772  22.103  1.00 27.52           C  
ATOM    916  NE  ARG   113       2.536  23.126  20.998  1.00 31.99           N  
ATOM    917  CZ  ARG   113       2.442  23.504  19.721  1.00 34.87           C  
ATOM    918  NH1 ARG   113       1.714  24.554  19.373  1.00 35.19           N  
ATOM    919  NH2 ARG   113       3.112  22.843  18.789  1.00 36.68           N  
ATOM    920  N   LYS   114       2.419  26.217  26.229  1.00 15.91           N  
ATOM    921  CA  LYS   114       3.230  25.669  27.288  1.00 16.73           C  
ATOM    922  C   LYS   114       3.722  24.263  26.894  1.00 15.85           C  
ATOM    923  O   LYS   114       3.129  23.561  26.056  1.00 16.72           O  
ATOM    924  CB  LYS   114       2.468  25.702  28.616  1.00 18.98           C  
ATOM    925  CG  LYS   114       2.443  27.127  29.242  1.00 20.81           C  
ATOM    926  CD  LYS   114       1.656  27.170  30.548  1.00 22.74           C  
ATOM    927  CE  LYS   114       1.697  28.497  31.205  1.00 27.34           C  
ATOM    928  NZ  LYS   114       3.104  29.026  31.381  1.00 35.08           N  
ATOM    929  N   ILE   115       4.853  23.899  27.469  1.00 13.60           N  
ATOM    930  CA  ILE   115       5.431  22.549  27.355  1.00 12.90           C  
ATOM    931  C   ILE   115       5.060  21.752  28.611  1.00 12.54           C  
ATOM    932  O   ILE   115       5.055  22.298  29.711  1.00 13.46           O  
ATOM    933  CB  ILE   115       6.989  22.638  27.258  1.00 12.66           C  
ATOM    934  CG1 ILE   115       7.465  23.593  26.126  1.00 13.12           C  
ATOM    935  CG2 ILE   115       7.615  21.243  27.106  1.00 14.45           C  
ATOM    936  CD1 ILE   115       8.906  23.931  26.217  1.00 14.24           C  
ATOM    937  N   THR   116       4.769  20.464  28.457  1.00 11.56           N  
ATOM    938  CA  THR   116       4.528  19.618  29.641  1.00 11.56           C  
ATOM    939  C   THR   116       5.857  19.319  30.348  1.00 11.81           C  
ATOM    940  O   THR   116       6.731  18.695  29.761  1.00 11.11           O  
ATOM    941  CB  THR   116       3.796  18.319  29.281  1.00 11.18           C  
ATOM    942  OG1 THR   116       2.512  18.661  28.748  1.00 13.86           O  
ATOM    943  CG2 THR   116       3.584  17.463  30.528  1.00 13.88           C  
ATOM    944  N   ILE   117       5.970  19.745  31.602  1.00 11.30           N  
ATOM    945  CA  ILE   117       7.169  19.518  32.386  1.00 11.61           C  
ATOM    946  C   ILE   117       7.092  18.153  33.041  1.00 11.11           C  
ATOM    947  O   ILE   117       6.079  17.797  33.721  1.00 11.60           O  
ATOM    948  CB  ILE   117       7.388  20.612  33.451  1.00 10.94           C  
ATOM    949  CG1 ILE   117       7.501  21.997  32.775  1.00 12.97           C  
ATOM    950  CG2 ILE   117       8.618  20.329  34.312  1.00 12.41           C  
ATOM    951  CD1 ILE   117       7.480  23.183  33.732  1.00 14.48           C  
ATOM    952  N   VAL   118       8.187  17.416  32.859  1.00 10.62           N  
ATOM    953  CA  VAL   118       8.361  16.078  33.426  1.00 10.94           C  
ATOM    954  C   VAL   118       9.561  16.135  34.370  1.00 11.43           C  
ATOM    955  O   VAL   118      10.700  16.224  33.931  1.00 10.90           O  
ATOM    956  CB  VAL   118       8.543  15.003  32.311  1.00 10.92           C  
ATOM    957  CG1 VAL   118       8.762  13.606  32.953  1.00 13.15           C  
ATOM    958  CG2 VAL   118       7.363  15.080  31.324  1.00 11.48           C  
ATOM    959  N   LYS   119       9.287  16.165  35.678  1.00 12.44           N  
ATOM    960  CA  LYS   119      10.324  16.315  36.670  1.00 13.48           C  
ATOM    961  C   LYS   119      10.714  14.948  37.164  1.00 13.19           C  
ATOM    962  O   LYS   119       9.896  14.205  37.702  1.00 14.25           O  
ATOM    963  CB  LYS   119       9.820  17.125  37.855  1.00 13.74           C  
ATOM    964  CG  LYS   119      10.874  17.417  38.891  1.00 15.58           C  
ATOM    965  CD  LYS   119      10.211  18.017  40.107  1.00 18.31           C  
ATOM    966  CE  LYS   119      11.208  18.356  41.190  1.00 20.31           C  
ATOM    967  NZ  LYS   119      10.758  17.806  42.523  1.00 23.66           N  
ATOM    968  N   VAL   120      11.968  14.612  36.979  1.00 12.63           N  
ATOM    969  CA  VAL   120      12.475  13.308  37.419  1.00 12.70           C  
ATOM    970  C   VAL   120      13.243  13.555  38.713  1.00 13.51           C  
ATOM    971  O   VAL   120      14.254  14.272  38.718  1.00 13.69           O  
ATOM    972  CB  VAL   120      13.381  12.724  36.361  1.00 13.24           C  
ATOM    973  CG1 VAL   120      14.002  11.370  36.790  1.00 14.26           C  
ATOM    974  CG2 VAL   120      12.617  12.652  35.001  1.00 12.67           C  
ATOM    975  N   ASP   121      12.754  12.987  39.813  1.00 14.37           N  
ATOM    976  CA  ASP   121      13.442  13.113  41.118  1.00 15.32           C  
ATOM    977  C   ASP   121      14.594  12.118  41.113  1.00 17.32           C  
ATOM    978  O   ASP   121      14.467  10.949  41.457  1.00 17.19           O  
ATOM    979  CB  ASP   121      12.483  12.872  42.272  1.00 16.09           C  
ATOM    980  CG  ASP   121      11.665  14.116  42.666  1.00 18.26           C  
ATOM    981  OD1 ASP   121      11.726  15.184  42.015  1.00 21.24           O  
ATOM    982  OD2 ASP   121      10.964  14.012  43.684  1.00 20.26           O  
ATOM    983  N   TRP   122      15.723  12.608  40.673  1.00 18.89           N  
ATOM    984  CA  TRP   122      16.839  11.748  40.315  1.00 21.45           C  
ATOM    985  C   TRP   122      17.708  11.290  41.481  1.00 23.46           C  
ATOM    986  O   TRP   122      18.703  10.588  41.244  1.00 26.08           O  
ATOM    987  CB  TRP   122      17.674  12.455  39.231  1.00 21.27           C  
ATOM    988  CG  TRP   122      18.435  13.670  39.685  1.00 20.91           C  
ATOM    989  CD1 TRP   122      18.413  14.263  40.926  1.00 21.94           C  
ATOM    990  CD2 TRP   122      19.314  14.461  38.884  1.00 18.43           C  
ATOM    991  NE1 TRP   122      19.242  15.366  40.942  1.00 21.32           N  
ATOM    992  CE2 TRP   122      19.822  15.495  39.708  1.00 19.46           C  
ATOM    993  CE3 TRP   122      19.724  14.398  37.556  1.00 20.93           C  
ATOM    994  CZ2 TRP   122      20.712  16.453  39.238  1.00 20.59           C  
ATOM    995  CZ3 TRP   122      20.624  15.336  37.097  1.00 21.26           C  
ATOM    996  CH2 TRP   122      21.104  16.353  37.928  1.00 21.96           C  
ATOM    997  N   MET   123      17.358  11.725  42.693  1.00 24.68           N  
ATOM    998  CA  MET   123      17.989  11.261  43.955  1.00 26.89           C  
ATOM    999  C   MET   123      19.515  11.269  43.954  1.00 28.23           C  
ATOM   1000  O   MET   123      20.186  10.245  44.212  1.00 29.78           O  
ATOM   1001  CB  MET   123      17.435   9.895  44.310  1.00 27.02           C  
ATOM   1002  CG  MET   123      15.929   9.962  44.589  1.00 27.90           C  
ATOM   1003  SD  MET   123      15.170   8.373  44.882  1.00 26.88           S  
ATOM   1004  CE  MET   123      15.568   7.452  43.417  1.00 29.23           C  
ATOM   1005  N   MET   124      20.047  12.453  43.691  1.00 29.64           N  
ATOM   1006  CA  MET   124      21.477  12.711  43.813  1.00 29.16           C  
ATOM   1007  C   MET   124      21.761  13.504  45.087  1.00 31.10           C  
ATOM   1008  O   MET   124      20.827  13.962  45.749  1.00 33.47           O  
ATOM   1009  CB  MET   124      21.960  13.487  42.589  1.00 29.35           C  
ATOM   1010  CG  MET   124      21.953  12.669  41.304  1.00 26.66           C  
ATOM   1011  SD  MET   124      23.042  11.220  41.329  1.00 22.40           S  
ATOM   1012  CE  MET   124      24.641  12.015  41.477  1.00 25.10           C  
ATOM   1013  N   SER   132      20.403   5.281  47.254  1.00 41.27           N  
ATOM   1014  CA  SER   132      19.763   4.126  46.622  1.00 40.97           C  
ATOM   1015  C   SER   132      18.908   4.544  45.458  1.00 40.68           C  
ATOM   1016  O   SER   132      18.484   5.714  45.357  1.00 41.99           O  
ATOM   1017  CB  SER   132      18.767   3.453  47.568  1.00 41.61           C  
ATOM   1018  OG  SER   132      17.445   3.986  47.312  1.00 37.11           O  
ATOM   1019  N   SER   133      18.618   3.567  44.606  1.00 39.36           N  
ATOM   1020  CA  SER   133      17.362   3.562  43.850  1.00 37.48           C  
ATOM   1021  C   SER   133      17.184   2.210  43.174  1.00 36.63           C  
ATOM   1022  O   SER   133      18.170   1.502  42.898  1.00 35.35           O  
ATOM   1023  CB  SER   133      17.279   4.704  42.830  1.00 38.16           C  
ATOM   1024  OG  SER   133      18.396   4.712  41.964  1.00 39.15           O  
ATOM   1025  N   THR   134      15.922   1.838  42.965  1.00 35.08           N  
ATOM   1026  CA  THR   134      15.572   0.596  42.289  1.00 34.89           C  
ATOM   1027  C   THR   134      16.225   0.613  40.905  1.00 34.89           C  
ATOM   1028  O   THR   134      16.419   1.687  40.304  1.00 33.50           O  
ATOM   1029  CB  THR   134      14.042   0.447  42.098  1.00 34.27           C  
ATOM   1030  OG1 THR   134      13.534   1.650  41.521  1.00 31.71           O  
ATOM   1031  CG2 THR   134      13.321   0.186  43.411  1.00 32.67           C  
ATOM   1032  N   ARG   135      16.542  -0.579  40.405  1.00 35.42           N  
ATOM   1033  CA  ARG   135      17.177  -0.713  39.109  1.00 35.80           C  
ATOM   1034  C   ARG   135      16.184  -0.279  38.039  1.00 35.19           C  
ATOM   1035  O   ARG   135      14.969  -0.516  38.168  1.00 33.59           O  
ATOM   1036  CB  ARG   135      17.624  -2.153  38.860  1.00 36.40           C  
ATOM   1037  CG  ARG   135      18.366  -2.330  37.535  1.00 37.17           C  
ATOM   1038  CD  ARG   135      19.167  -3.644  37.484  1.00 40.02           C  
ATOM   1039  NE  ARG   135      20.228  -3.599  36.466  1.00 42.01           N  
ATOM   1040  CZ  ARG   135      21.482  -3.172  36.657  1.00 44.41           C  
ATOM   1041  NH1 ARG   135      21.901  -2.745  37.850  1.00 45.28           N  
ATOM   1042  NH2 ARG   135      22.338  -3.181  35.634  1.00 45.26           N  
ATOM   1043  N   ILE   136      16.702   0.409  37.020  1.00 34.68           N  
ATOM   1044  CA  ILE   136      15.930   0.736  35.833  1.00 35.32           C  
ATOM   1045  C   ILE   136      16.605   0.082  34.630  1.00 35.33           C  
ATOM   1046  O   ILE   136      17.804   0.282  34.391  1.00 34.30           O  
ATOM   1047  CB  ILE   136      15.859   2.245  35.568  1.00 34.95           C  
ATOM   1048  CG1 ILE   136      15.115   2.975  36.696  1.00 35.36           C  
ATOM   1049  CG2 ILE   136      15.171   2.496  34.238  1.00 33.98           C  
ATOM   1050  CD1 ILE   136      15.539   4.427  36.861  1.00 35.48           C  
ATOM   1051  N   LYS   137      15.836  -0.698  33.880  1.00 36.12           N  
ATOM   1052  CA  LYS   137      16.334  -1.292  32.653  1.00 37.00           C  
ATOM   1053  C   LYS   137      16.368  -0.225  31.550  1.00 37.12           C  
ATOM   1054  O   LYS   137      15.318   0.193  31.043  1.00 35.06           O  
ATOM   1055  CB  LYS   137      15.460  -2.480  32.261  1.00 37.28           C  
ATOM   1056  CG  LYS   137      15.483  -3.600  33.312  1.00 40.05           C  
ATOM   1057  CD  LYS   137      16.604  -4.606  33.077  1.00 42.12           C  
ATOM   1058  CE  LYS   137      16.258  -5.571  31.948  1.00 43.64           C  
ATOM   1059  NZ  LYS   137      17.054  -6.835  32.012  1.00 44.11           N  
ATOM   1060  N   ARG   138      17.580   0.228  31.212  1.00 37.98           N  
ATOM   1061  CA  ARG   138      17.776   1.234  30.156  1.00 39.66           C  
ATOM   1062  C   ARG   138      17.485   0.664  28.790  1.00 40.40           C  
ATOM   1063  O   ARG   138      17.824  -0.479  28.495  1.00 40.43           O  
ATOM   1064  CB  ARG   138      19.217   1.753  30.121  1.00 39.88           C  
ATOM   1065  CG  ARG   138      19.727   2.312  31.416  1.00 42.38           C  
ATOM   1066  CD  ARG   138      18.686   3.135  32.109  1.00 46.21           C  
ATOM   1067  NE  ARG   138      19.280   3.952  33.164  1.00 48.49           N  
ATOM   1068  CZ  ARG   138      18.596   4.742  33.988  1.00 49.41           C  
ATOM   1069  NH1 ARG   138      17.266   4.834  33.920  1.00 50.16           N  
ATOM   1070  NH2 ARG   138      19.251   5.435  34.895  1.00 49.38           N  
ATOM   1071  N   GLY   139      16.872   1.487  27.953  1.00 41.34           N  
ATOM   1072  CA  GLY   139      16.580   1.125  26.576  1.00 41.93           C  
ATOM   1073  C   GLY   139      15.272   1.760  26.164  1.00 42.65           C  
ATOM   1074  O   GLY   139      14.637   2.461  26.945  1.00 43.33           O  
ATOM   1075  N   GLU   140      14.890   1.552  24.914  1.00 43.46           N  
ATOM   1076  CA  GLU   140      13.549   1.871  24.476  1.00 44.10           C  
ATOM   1077  C   GLU   140      12.734   0.613  24.774  1.00 44.44           C  
ATOM   1078  O   GLU   140      13.300  -0.481  24.843  1.00 43.94           O  
ATOM   1079  CB  GLU   140      13.570   2.260  22.998  1.00 44.30           C  
ATOM   1080  CG  GLU   140      14.430   3.505  22.784  1.00 44.82           C  
ATOM   1081  CD  GLU   140      14.630   3.902  21.330  1.00 45.48           C  
ATOM   1082  OE1 GLU   140      15.622   3.424  20.719  1.00 49.01           O  
ATOM   1083  OE2 GLU   140      13.829   4.734  20.828  1.00 45.76           O  
ATOM   1084  N   ILE   141      11.434   0.770  25.008  1.00 45.06           N  
ATOM   1085  CA  ILE   141      10.588  -0.357  25.417  1.00 45.61           C  
ATOM   1086  C   ILE   141       9.930  -1.091  24.219  1.00 46.00           C  
ATOM   1087  O   ILE   141       9.712  -2.303  24.283  1.00 45.98           O  
ATOM   1088  CB  ILE   141       9.490   0.091  26.452  1.00 45.80           C  
ATOM   1089  CG1 ILE   141       8.421   0.955  25.788  1.00 45.56           C  
ATOM   1090  CG2 ILE   141      10.109   0.847  27.647  1.00 45.98           C  
ATOM   1091  CD1 ILE   141       7.340   1.365  26.726  1.00 46.03           C  
ATOM   1092  N   ASP   142       9.635  -0.345  23.149  1.00 46.35           N  
ATOM   1093  CA  ASP   142       8.785  -0.785  21.997  1.00 46.69           C  
ATOM   1094  C   ASP   142       8.351  -2.260  21.929  1.00 47.17           C  
ATOM   1095  O   ASP   142       7.674  -2.685  20.959  1.00 47.33           O  
ATOM   1096  CB  ASP   142       9.434  -0.372  20.656  1.00 46.94           C  
ATOM   1097  CG  ASP   142      10.843  -0.891  20.500  1.00 47.31           C  
ATOM   1098  OD1 ASP   142      11.423  -1.249  21.533  1.00 51.17           O  
ATOM   1099  OD2 ASP   142      11.380  -0.945  19.365  1.00 47.19           O  
END
