
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  180 ( 1389),  selected  180 , name 1eiz_A
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 1eiz_A.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    30_A      Q      17           #
LGA    L    31_A      L      18          5.560
LGA    R    32_A      R      19          0.735
LGA    S    33_A      S      20          0.556
LGA    R    34_A      R      21          0.807
LGA    A    35_A      A      22          0.735
LGA    W    36_A      A      23          0.629
LGA    F    37_A      F      24          0.762
LGA    K    38_A      K      25          0.791
LGA    L    39_A      L      26          0.797
LGA    D    40_A      E      27          0.709
LGA    E    41_A      F      28          0.817
LGA    I    42_A      L      29          0.888
LGA    Q    43_A      L      30          0.753
LGA    Q    44_A      D      31          0.685
LGA    S    45_A      R      32          0.938
LGA    D    46_A      Y      33          1.200
LGA    K    47_A      R      34          1.336
LGA    L    48_A      V      35          2.434
LGA    F    49_A      V      36          2.443
LGA    K    50_A      R      37          2.641
LGA    P    51_A      K      38          2.967
LGA    G    52_A      G      39          2.397
LGA    M    53_A      D      40          1.664
LGA    T    54_A      A      41          0.988
LGA    V    55_A      V      42          0.421
LGA    V    56_A      I      43          0.274
LGA    D    57_A      E      44          0.260
LGA    L    58_A      I      45          0.124
LGA    G    59_A      G      46          0.343
LGA    A    60_A      S      47          0.414
LGA    A    61_A      S      48          0.492
LGA    P    62_A      P      49          0.623
LGA    G    63_A      G      50          0.570
LGA    G    64_A      G      51          0.881
LGA    W    65_A      W      52          0.899
LGA    S    66_A      T      53          1.135
LGA    Q    67_A      Q      54          0.633
LGA    Y    68_A      V      55          0.489
LGA    V    69_A      L      56          0.815
LGA    V    70_A      N      57          1.045
LGA    T    71_A      S      58          0.618
LGA    Q    72_A      L      59          1.257
LGA    I    73_A      A      60          2.239
LGA    G    74_A      -       -           -
LGA    G    75_A      -       -           -
LGA    K    76_A      -       -           -
LGA    G    77_A      R      61          0.888
LGA    R    78_A      K      62          0.614
LGA    I    79_A      I      63          0.520
LGA    I    80_A      I      64          0.572
LGA    A    81_A      S      65          0.640
LGA    C    82_A      I      66          0.547
LGA    D    83_A      D      67          0.694
LGA    L    84_A      L      68          0.811
LGA    L    85_A      Q      69          0.855
LGA    P    86_A      E      70          0.486
LGA    M    87_A      M      71          0.247
LGA    D    88_A      E      72          0.580
LGA    P    89_A      E      73          0.587
LGA    I    90_A      I      74          0.779
LGA    V    91_A      A      75          1.218
LGA    G    92_A      G      76          1.959
LGA    V    93_A      V      77          0.957
LGA    D    94_A      R      78          0.481
LGA    F    95_A      F      79          0.482
LGA    L    96_A      I      80          0.947
LGA    Q    97_A      R      81          1.308
LGA    G    98_A      C      82          1.944
LGA    D    99_A      D      83          1.087
LGA    F   100_A      I      84          1.218
LGA    R   101_A      F      85          0.909
LGA    D   102_A      K      86          0.756
LGA    E   103_A      E      87          2.023
LGA    L   104_A      T      88          1.180
LGA    V   105_A      -       -           -
LGA    M   106_A      I      89          0.770
LGA    K   107_A      F      90          2.832
LGA    -       -      D      91           -
LGA    A   108_A      D      92          1.095
LGA    L   109_A      I      93          2.244
LGA    L   110_A      D      94          2.276
LGA    E   111_A      R      95          1.203
LGA    R   112_A      A      96          0.597
LGA    V   113_A      L      97          1.791
LGA    G   114_A      R      98          2.277
LGA    -       -      E      99           -
LGA    -       -      E     100           -
LGA    D   115_A      G     101          4.988
LGA    S   116_A      I     102          0.683
LGA    K   117_A      E     103          3.944
LGA    -       -      K     104           -
LGA    V   118_A      V     105          0.166
LGA    Q   119_A      D     106          0.163
LGA    V   120_A      D     107          0.500
LGA    V   121_A      V     108          0.316
LGA    M   122_A      V     109          0.294
LGA    S   123_A      S     110          0.381
LGA    D   124_A      D     111          0.436
LGA    M   125_A      A     112          0.706
LGA    A   126_A      M     113          0.992
LGA    P   127_A      A     114          1.489
LGA    N   128_A      K     115          0.875
LGA    M   129_A      V     116          1.803
LGA    S   130_A      S     117          2.446
LGA    G   131_A      G     118          2.882
LGA    T   132_A      I     119          3.187
LGA    P   133_A      P     120          3.417
LGA    A   134_A      S     121          3.517
LGA    V   135_A      R     122          2.889
LGA    D   136_A      D     123          2.629
LGA    I   137_A      H     124          1.956
LGA    P   138_A      A     125          1.664
LGA    R   139_A      V     126          1.527
LGA    A   140_A      S     127          1.367
LGA    M   141_A      Y     128          0.773
LGA    Y   142_A      Q     129          0.621
LGA    L   143_A      I     130          0.520
LGA    V   144_A      G     131          0.580
LGA    E   145_A      Q     132          0.291
LGA    L   146_A      R     133          0.125
LGA    A   147_A      V     134          0.189
LGA    L   148_A      M     135          0.400
LGA    E   149_A      E     136          0.524
LGA    M   150_A      I     137          0.559
LGA    C   151_A      A     138          0.820
LGA    R   152_A      V     139          0.913
LGA    D   153_A      R     140          0.368
LGA    V   154_A      Y     141          0.399
LGA    L   155_A      L     142          0.761
LGA    A   156_A      R     143          0.777
LGA    P   157_A      N     144          0.696
LGA    G   158_A      G     145          0.295
LGA    G   159_A      G     146          0.256
LGA    S   160_A      N     147          0.337
LGA    F   161_A      V     148          0.248
LGA    V   162_A      L     149          0.330
LGA    V   163_A      L     150          0.411
LGA    K   164_A      K     151          0.373
LGA    V   165_A      Q     152          0.987
LGA    F   166_A      F     153          1.261
LGA    Q   167_A      Q     154          1.246
LGA    G   168_A      G     155          1.072
LGA    E   169_A      D     156          1.816
LGA    G   170_A      M     157          0.745
LGA    F   171_A      T     158          0.498
LGA    D   172_A      N     159          0.832
LGA    E   173_A      D     160          1.126
LGA    Y   174_A      F     161          0.959
LGA    L   175_A      I     162          0.897
LGA    R   176_A      A     163          0.939
LGA    E   177_A      I     164          1.977
LGA    I   178_A      W     165          2.365
LGA    R   179_A      R     166          1.199
LGA    S   180_A      K     167          0.823
LGA    L   181_A      N     168          1.190
LGA    F   182_A      F     169          0.804
LGA    T   183_A      S     170          0.440
LGA    K   184_A      S     171          1.203
LGA    V   185_A      Y     172          0.367
LGA    K   186_A      K     173          0.554
LGA    V   187_A      I     174          0.436
LGA    R   188_A      S     175          0.997
LGA    K   189_A      K     176          1.191
LGA    P   190_A      P     177          1.658
LGA    D   191_A      -       -           -
LGA    S   192_A      -       -           -
LGA    S   193_A      -       -           -
LGA    R   194_A      -       -           -
LGA    A   195_A      -       -           -
LGA    R   196_A      -       -           -
LGA    S   197_A      S     184          2.095
LGA    R   198_A      S     185          0.829
LGA    E   199_A      E     186          0.720
LGA    V   200_A      I     187          0.834
LGA    Y   201_A      Y     188          0.596
LGA    I   202_A      I     189          0.801
LGA    V   203_A      M     190          1.380
LGA    A   204_A      F     191          1.242
LGA    T   205_A      F     192          0.869
LGA    G   206_A      G     193          0.499
LGA    R   207_A      F     194          0.437
LGA    K   208_A      K     195          1.175
LGA    P   209_A      A     196          3.076

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  180  174    5.0    169    1.42    31.95     91.969    11.122

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.792756 * X  +   0.272201 * Y  +  -0.545384 * Z  +  13.717067
  Y_new =  -0.431742 * X  +   0.380850 * Y  +   0.817651 * Z  +  -7.852362
  Z_new =   0.430275 * X  +   0.883663 * Y  +  -0.184400 * Z  + -19.037622 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.776521   -1.365071  [ DEG:   101.7872    -78.2128 ]
  Theta =  -0.444797   -2.696795  [ DEG:   -25.4850   -154.5150 ]
  Phi   =  -2.642898    0.498694  [ DEG:  -151.4269     28.5731 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1eiz_A                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1eiz_A.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  180  174   5.0  169   1.42   31.95  91.969
REMARK  ---------------------------------------------------------- 
MOLECULE 1eiz_A
HEADER    TRANSFERASE                             29-FEB-00   1EIZ              
TITLE     FTSJ RNA METHYLTRANSFERASE COMPLEXED WITH S-                          
TITLE    2 ADENOSYLMETHIONINE                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FTSJ;                                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: FTSJ METHYLTRANSFERASE;                                     
COMPND   5 EC: 2.1.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    FTSJ, METHYLTRANSFERASE, ADOMET, ADENOSYL METHIONINE, HEAT            
KEYWDS   2 SHOCK PROTEINS, 23S RIBOSOMAL RNA                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.BUGL,E.B.FAUMAN,B.L.STAKER,F.ZHENG,S.R.KUSHNER,M.A.SAPER,           
AUTHOR   2 J.C.A.BARDWELL,U.JAKOB                                               
REVDAT   2   01-APR-03 1EIZ    1       JRNL                                     
REVDAT   1   30-AUG-00 1EIZ    0                                                
JRNL        AUTH   H.BUGL,E.B.FAUMAN,B.L.STAKER,F.ZHENG,S.R.KUSHNER,            
JRNL        AUTH 2 M.A.SAPER,J.C.BARDWELL,U.JAKOB                               
JRNL        TITL   RNA METHYLATION UNDER HEAT SHOCK CONTROL.                    
JRNL        REF    MOL.CELL                      V.   6   349 2000              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1EIZ A   30   209  UNP    P28692   RRMJ_ECOLI      30    209             
SEQRES   1 A  180  GLY LEU ARG SER ARG ALA TRP PHE LYS LEU ASP GLU ILE          
SEQRES   2 A  180  GLN GLN SER ASP LYS LEU PHE LYS PRO GLY MET THR VAL          
SEQRES   3 A  180  VAL ASP LEU GLY ALA ALA PRO GLY GLY TRP SER GLN TYR          
SEQRES   4 A  180  VAL VAL THR GLN ILE GLY GLY LYS GLY ARG ILE ILE ALA          
SEQRES   5 A  180  CYS ASP LEU LEU PRO MET ASP PRO ILE VAL GLY VAL ASP          
SEQRES   6 A  180  PHE LEU GLN GLY ASP PHE ARG ASP GLU LEU VAL MET LYS          
SEQRES   7 A  180  ALA LEU LEU GLU ARG VAL GLY ASP SER LYS VAL GLN VAL          
SEQRES   8 A  180  VAL MET SER ASP MET ALA PRO ASN MET SER GLY THR PRO          
SEQRES   9 A  180  ALA VAL ASP ILE PRO ARG ALA MET TYR LEU VAL GLU LEU          
SEQRES  10 A  180  ALA LEU GLU MET CYS ARG ASP VAL LEU ALA PRO GLY GLY          
SEQRES  11 A  180  SER PHE VAL VAL LYS VAL PHE GLN GLY GLU GLY PHE ASP          
SEQRES  12 A  180  GLU TYR LEU ARG GLU ILE ARG SER LEU PHE THR LYS VAL          
SEQRES  13 A  180  LYS VAL ARG LYS PRO ASP SER SER ARG ALA ARG SER ARG          
SEQRES  14 A  180  GLU VAL TYR ILE VAL ALA THR GLY ARG LYS PRO                  
HET    SAM    301      27                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   2  SAM    C15 H22 N6 O5 S                                              
FORMUL   3  HOH   *183(H2 O)                                                    
CRYST1   36.457   65.867   72.877  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   GLY A  30      28.685  27.951  20.452  1.00 28.20           N  
ATOM      2  CA  GLY A  30      27.977  27.663  21.736  1.00 26.94           C  
ATOM      3  C   GLY A  30      28.133  26.207  22.132  1.00 25.14           C  
ATOM      4  O   GLY A  30      28.569  25.383  21.318  1.00 25.70           O  
ATOM      5  N   LEU A  31      27.768  25.869  23.367  1.00 23.37           N  
ATOM      6  CA  LEU A  31      27.911  24.484  23.817  1.00 19.36           C  
ATOM      7  C   LEU A  31      26.954  23.537  23.111  1.00 18.95           C  
ATOM      8  O   LEU A  31      27.256  22.352  22.957  1.00 18.18           O  
ATOM      9  CB  LEU A  31      27.698  24.379  25.328  1.00 18.93           C  
ATOM     10  CG  LEU A  31      28.753  25.028  26.245  1.00 20.21           C  
ATOM     11  CD1 LEU A  31      28.416  24.749  27.719  1.00 18.01           C  
ATOM     12  CD2 LEU A  31      30.139  24.430  25.929  1.00 18.93           C  
ATOM     13  N   ARG A  32      25.793  24.048  22.704  1.00 16.73           N  
ATOM     14  CA  ARG A  32      24.785  23.221  22.038  1.00 15.52           C  
ATOM     15  C   ARG A  32      24.224  23.973  20.829  1.00 16.78           C  
ATOM     16  O   ARG A  32      24.321  25.205  20.742  1.00 14.89           O  
ATOM     17  CB  ARG A  32      23.637  22.902  22.999  1.00 15.23           C  
ATOM     18  CG  ARG A  32      24.078  22.164  24.286  1.00 14.12           C  
ATOM     19  CD  ARG A  32      24.361  20.674  24.029  1.00 14.75           C  
ATOM     20  NE  ARG A  32      24.599  19.989  25.311  1.00 13.66           N  
ATOM     21  CZ  ARG A  32      25.756  20.021  25.978  1.00 12.76           C  
ATOM     22  NH1 ARG A  32      26.806  20.677  25.488  1.00 14.44           N  
ATOM     23  NH2 ARG A  32      25.847  19.458  27.179  1.00 11.70           N  
ATOM     24  N   SER A  33      23.624  23.213  19.919  1.00 14.34           N  
ATOM     25  CA  SER A  33      23.051  23.766  18.692  1.00 14.27           C  
ATOM     26  C   SER A  33      21.710  24.434  18.902  1.00 11.83           C  
ATOM     27  O   SER A  33      21.030  24.204  19.896  1.00 13.46           O  
ATOM     28  CB  SER A  33      22.867  22.655  17.646  1.00 13.22           C  
ATOM     29  OG  SER A  33      21.804  21.808  18.053  1.00 14.04           O  
ATOM     30  N   ARG A  34      21.321  25.273  17.943  1.00 11.75           N  
ATOM     31  CA  ARG A  34      20.019  25.919  18.015  1.00 12.77           C  
ATOM     32  C   ARG A  34      18.923  24.840  18.110  1.00 13.12           C  
ATOM     33  O   ARG A  34      17.988  24.952  18.889  1.00 12.54           O  
ATOM     34  CB  ARG A  34      19.810  26.802  16.770  1.00 13.42           C  
ATOM     35  CG  ARG A  34      18.468  27.533  16.759  1.00 16.85           C  
ATOM     36  CD  ARG A  34      18.201  28.186  15.398  1.00 20.66           C  
ATOM     37  NE  ARG A  34      19.118  29.297  15.123  1.00 23.57           N  
ATOM     38  CZ  ARG A  34      19.013  30.515  15.667  1.00 26.42           C  
ATOM     39  NH1 ARG A  34      18.035  30.802  16.516  1.00 26.13           N  
ATOM     40  NH2 ARG A  34      19.900  31.454  15.368  1.00 30.06           N  
ATOM     41  N   ALA A  35      19.066  23.773  17.335  1.00 11.86           N  
ATOM     42  CA  ALA A  35      18.091  22.684  17.339  1.00 11.00           C  
ATOM     43  C   ALA A  35      17.958  22.078  18.750  1.00 11.13           C  
ATOM     44  O   ALA A  35      16.860  21.816  19.207  1.00  9.05           O  
ATOM     45  CB  ALA A  35      18.514  21.610  16.346  1.00  8.04           C  
ATOM     46  N   TRP A  36      19.082  21.863  19.426  1.00 10.01           N  
ATOM     47  CA  TRP A  36      19.059  21.334  20.788  1.00 12.21           C  
ATOM     48  C   TRP A  36      18.224  22.295  21.663  1.00 12.64           C  
ATOM     49  O   TRP A  36      17.347  21.870  22.429  1.00 12.31           O  
ATOM     50  CB  TRP A  36      20.514  21.243  21.304  1.00 11.57           C  
ATOM     51  CG  TRP A  36      20.696  20.688  22.672  1.00 12.27           C  
ATOM     52  CD1 TRP A  36      21.074  19.406  22.991  1.00 13.08           C  
ATOM     53  CD2 TRP A  36      20.570  21.393  23.919  1.00 11.78           C  
ATOM     54  NE1 TRP A  36      21.195  19.279  24.349  1.00 12.89           N  
ATOM     55  CE2 TRP A  36      20.890  20.479  24.948  1.00 13.15           C  
ATOM     56  CE3 TRP A  36      20.215  22.706  24.267  1.00 13.39           C  
ATOM     57  CZ2 TRP A  36      20.868  20.832  26.308  1.00 12.92           C  
ATOM     58  CZ3 TRP A  36      20.190  23.068  25.629  1.00 11.35           C  
ATOM     59  CH2 TRP A  36      20.517  22.132  26.634  1.00 11.97           C  
ATOM     60  N   PHE A  37      18.483  23.598  21.550  1.00  9.53           N  
ATOM     61  CA  PHE A  37      17.709  24.541  22.358  1.00 10.62           C  
ATOM     62  C   PHE A  37      16.203  24.536  22.037  1.00 10.96           C  
ATOM     63  O   PHE A  37      15.371  24.768  22.928  1.00 12.64           O  
ATOM     64  CB  PHE A  37      18.284  25.984  22.207  1.00 11.25           C  
ATOM     65  CG  PHE A  37      19.473  26.258  23.102  1.00 13.38           C  
ATOM     66  CD1 PHE A  37      20.781  26.137  22.626  1.00 16.13           C  
ATOM     67  CD2 PHE A  37      19.273  26.597  24.434  1.00 17.80           C  
ATOM     68  CE1 PHE A  37      21.881  26.352  23.480  1.00 18.23           C  
ATOM     69  CE2 PHE A  37      20.360  26.815  25.299  1.00 18.42           C  
ATOM     70  CZ  PHE A  37      21.664  26.690  24.817  1.00 19.27           C  
ATOM     71  N   LYS A  38      15.846  24.277  20.781  1.00 11.19           N  
ATOM     72  CA  LYS A  38      14.433  24.276  20.418  1.00 11.78           C  
ATOM     73  C   LYS A  38      13.736  23.128  21.117  1.00 13.09           C  
ATOM     74  O   LYS A  38      12.623  23.278  21.629  1.00 12.20           O  
ATOM     75  CB  LYS A  38      14.238  24.123  18.902  1.00 12.50           C  
ATOM     76  CG  LYS A  38      14.809  25.241  18.056  1.00 16.34           C  
ATOM     77  CD  LYS A  38      14.445  24.972  16.612  1.00 16.43           C  
ATOM     78  CE  LYS A  38      15.513  25.405  15.633  1.00 18.99           C  
ATOM     79  NZ  LYS A  38      15.024  25.112  14.236  1.00 18.23           N  
ATOM     80  N   LEU A  39      14.402  21.971  21.155  1.00 11.47           N  
ATOM     81  CA  LEU A  39      13.763  20.828  21.784  1.00  9.26           C  
ATOM     82  C   LEU A  39      13.707  20.996  23.307  1.00 12.25           C  
ATOM     83  O   LEU A  39      12.725  20.587  23.960  1.00 11.36           O  
ATOM     84  CB  LEU A  39      14.468  19.529  21.344  1.00 10.43           C  
ATOM     85  CG  LEU A  39      13.677  18.278  21.752  1.00 10.37           C  
ATOM     86  CD1 LEU A  39      12.294  18.260  21.016  1.00  9.49           C  
ATOM     87  CD2 LEU A  39      14.480  17.026  21.334  1.00  9.62           C  
ATOM     88  N   ASP A  40      14.744  21.627  23.868  1.00 12.16           N  
ATOM     89  CA  ASP A  40      14.749  21.890  25.306  1.00 13.39           C  
ATOM     90  C   ASP A  40      13.543  22.774  25.621  1.00 13.37           C  
ATOM     91  O   ASP A  40      12.828  22.532  26.595  1.00 12.01           O  
ATOM     92  CB  ASP A  40      16.049  22.579  25.724  1.00 14.51           C  
ATOM     93  CG  ASP A  40      16.067  22.952  27.213  1.00 12.41           C  
ATOM     94  OD1 ASP A  40      15.666  22.125  28.055  1.00 14.40           O  
ATOM     95  OD2 ASP A  40      16.489  24.074  27.531  1.00 16.69           O  
ATOM     96  N   GLU A  41      13.301  23.792  24.796  1.00 11.99           N  
ATOM     97  CA  GLU A  41      12.138  24.657  25.045  1.00 12.86           C  
ATOM     98  C   GLU A  41      10.826  23.877  24.957  1.00 12.12           C  
ATOM     99  O   GLU A  41       9.903  24.117  25.733  1.00 12.78           O  
ATOM    100  CB  GLU A  41      12.150  25.856  24.081  1.00 16.27           C  
ATOM    101  CG  GLU A  41      13.413  26.691  24.326  1.00 20.16           C  
ATOM    102  CD  GLU A  41      13.703  27.724  23.277  1.00 26.71           C  
ATOM    103  OE1 GLU A  41      13.060  27.700  22.215  1.00 28.08           O  
ATOM    104  OE2 GLU A  41      14.607  28.562  23.526  1.00 29.21           O  
ATOM    105  N   ILE A  42      10.745  22.916  24.044  1.00 11.58           N  
ATOM    106  CA  ILE A  42       9.533  22.126  23.910  1.00 10.96           C  
ATOM    107  C   ILE A  42       9.397  21.160  25.089  1.00 11.08           C  
ATOM    108  O   ILE A  42       8.297  20.916  25.566  1.00 12.08           O  
ATOM    109  CB  ILE A  42       9.541  21.366  22.574  1.00 11.73           C  
ATOM    110  CG1 ILE A  42       9.353  22.382  21.430  1.00 12.90           C  
ATOM    111  CG2 ILE A  42       8.436  20.291  22.543  1.00 13.01           C  
ATOM    112  CD1 ILE A  42       9.635  21.779  20.028  1.00 13.45           C  
ATOM    113  N   GLN A  43      10.512  20.634  25.574  1.00 10.24           N  
ATOM    114  CA  GLN A  43      10.438  19.731  26.721  1.00 11.09           C  
ATOM    115  C   GLN A  43       9.915  20.561  27.921  1.00 11.04           C  
ATOM    116  O   GLN A  43       9.142  20.070  28.738  1.00 13.01           O  
ATOM    117  CB  GLN A  43      11.829  19.155  27.039  1.00 11.08           C  
ATOM    118  CG  GLN A  43      11.939  18.423  28.394  1.00 11.17           C  
ATOM    119  CD  GLN A  43      11.275  17.029  28.414  1.00 12.15           C  
ATOM    120  OE1 GLN A  43      10.327  16.746  27.662  1.00 12.75           O  
ATOM    121  NE2 GLN A  43      11.756  16.162  29.312  1.00 12.29           N  
ATOM    122  N   GLN A  44      10.344  21.815  28.015  1.00 11.11           N  
ATOM    123  CA  GLN A  44       9.897  22.654  29.131  1.00 14.01           C  
ATOM    124  C   GLN A  44       8.423  22.980  29.035  1.00 14.10           C  
ATOM    125  O   GLN A  44       7.742  23.035  30.056  1.00 15.55           O  
ATOM    126  CB  GLN A  44      10.677  23.972  29.211  1.00 14.09           C  
ATOM    127  CG  GLN A  44      12.155  23.799  29.515  1.00 16.69           C  
ATOM    128  CD  GLN A  44      12.895  25.119  29.612  1.00 19.44           C  
ATOM    129  OE1 GLN A  44      12.666  25.903  30.539  1.00 21.95           O  
ATOM    130  NE2 GLN A  44      13.784  25.373  28.659  1.00 18.60           N  
ATOM    131  N   SER A  45       7.928  23.209  27.826  1.00 13.31           N  
ATOM    132  CA  SER A  45       6.520  23.556  27.694  1.00 15.11           C  
ATOM    133  C   SER A  45       5.589  22.359  27.650  1.00 17.23           C  
ATOM    134  O   SER A  45       4.447  22.452  28.088  1.00 17.14           O  
ATOM    135  CB  SER A  45       6.287  24.400  26.428  1.00 14.53           C  
ATOM    136  OG  SER A  45       6.674  23.688  25.253  1.00 15.23           O  
ATOM    137  N   ASP A  46       6.087  21.226  27.166  1.00 15.17           N  
ATOM    138  CA  ASP A  46       5.230  20.066  26.984  1.00 15.59           C  
ATOM    139  C   ASP A  46       5.543  18.756  27.681  1.00 16.23           C  
ATOM    140  O   ASP A  46       4.760  17.805  27.596  1.00 17.00           O  
ATOM    141  CB  ASP A  46       5.050  19.868  25.484  1.00 13.28           C  
ATOM    142  CG  ASP A  46       4.323  21.055  24.848  1.00 18.63           C  
ATOM    143  OD1 ASP A  46       3.087  21.139  25.050  1.00 14.91           O  
ATOM    144  OD2 ASP A  46       4.986  21.907  24.197  1.00 14.62           O  
ATOM    145  N   LYS A  47       6.685  18.699  28.355  1.00 16.33           N  
ATOM    146  CA  LYS A  47       7.058  17.517  29.135  1.00 15.87           C  
ATOM    147  C   LYS A  47       6.834  16.210  28.386  1.00 15.08           C  
ATOM    148  O   LYS A  47       6.083  15.353  28.848  1.00 15.61           O  
ATOM    149  CB  LYS A  47       6.254  17.494  30.435  1.00 19.72           C  
ATOM    150  CG  LYS A  47       6.353  18.786  31.267  1.00 25.58           C  
ATOM    151  CD  LYS A  47       7.714  18.945  31.961  1.00 32.47           C  
ATOM    152  CE  LYS A  47       7.773  20.254  32.774  1.00 37.61           C  
ATOM    153  NZ  LYS A  47       8.978  20.369  33.676  1.00 38.71           N  
ATOM    154  N   LEU A  48       7.535  16.052  27.272  1.00 13.75           N  
ATOM    155  CA  LEU A  48       7.380  14.880  26.424  1.00 11.95           C  
ATOM    156  C   LEU A  48       8.232  13.704  26.786  1.00 11.16           C  
ATOM    157  O   LEU A  48       7.796  12.559  26.620  1.00 12.68           O  
ATOM    158  CB  LEU A  48       7.728  15.226  24.979  1.00 11.48           C  
ATOM    159  CG  LEU A  48       6.910  16.343  24.345  1.00 11.65           C  
ATOM    160  CD1 LEU A  48       7.388  16.499  22.901  1.00 13.21           C  
ATOM    161  CD2 LEU A  48       5.416  16.002  24.405  1.00 10.64           C  
ATOM    162  N   PHE A  49       9.435  13.983  27.278  1.00  9.20           N  
ATOM    163  CA  PHE A  49      10.381  12.916  27.529  1.00 11.13           C  
ATOM    164  C   PHE A  49      10.535  12.538  28.989  1.00 11.86           C  
ATOM    165  O   PHE A  49      10.779  13.405  29.839  1.00 12.34           O  
ATOM    166  CB  PHE A  49      11.725  13.319  26.921  1.00  9.70           C  
ATOM    167  CG  PHE A  49      11.633  13.732  25.461  1.00 11.16           C  
ATOM    168  CD1 PHE A  49      11.656  15.073  25.099  1.00 11.73           C  
ATOM    169  CD2 PHE A  49      11.498  12.775  24.456  1.00 11.36           C  
ATOM    170  CE1 PHE A  49      11.545  15.446  23.754  1.00 12.78           C  
ATOM    171  CE2 PHE A  49      11.384  13.145  23.105  1.00 13.74           C  
ATOM    172  CZ  PHE A  49      11.409  14.484  22.759  1.00 11.92           C  
ATOM    173  N   LYS A  50      10.391  11.234  29.268  1.00 10.71           N  
ATOM    174  CA  LYS A  50      10.504  10.712  30.638  1.00 14.03           C  
ATOM    175  C   LYS A  50      11.550   9.601  30.697  1.00 13.65           C  
ATOM    176  O   LYS A  50      11.860   8.970  29.681  1.00 10.89           O  
ATOM    177  CB  LYS A  50       9.170  10.128  31.110  1.00 17.19           C  
ATOM    178  CG  LYS A  50       7.954  11.047  30.941  1.00 24.00           C  
ATOM    179  CD  LYS A  50       7.951  12.225  31.888  1.00 26.70           C  
ATOM    180  CE  LYS A  50       6.587  12.952  31.827  1.00 28.86           C  
ATOM    181  NZ  LYS A  50       6.678  14.299  32.459  1.00 29.96           N  
ATOM    182  N   PRO A  51      12.095   9.334  31.901  1.00 11.78           N  
ATOM    183  CA  PRO A  51      13.106   8.283  32.034  1.00 12.73           C  
ATOM    184  C   PRO A  51      12.685   6.944  31.446  1.00 11.66           C  
ATOM    185  O   PRO A  51      11.557   6.484  31.638  1.00 11.20           O  
ATOM    186  CB  PRO A  51      13.306   8.163  33.553  1.00 13.52           C  
ATOM    187  CG  PRO A  51      13.074   9.586  34.047  1.00 11.98           C  
ATOM    188  CD  PRO A  51      11.874  10.038  33.177  1.00 12.65           C  
ATOM    189  N   GLY A  52      13.607   6.341  30.703  1.00 10.97           N  
ATOM    190  CA  GLY A  52      13.389   5.009  30.159  1.00 10.85           C  
ATOM    191  C   GLY A  52      12.580   4.852  28.880  1.00 12.01           C  
ATOM    192  O   GLY A  52      12.401   3.740  28.420  1.00 11.25           O  
ATOM    193  N   MET A  53      12.102   5.940  28.295  1.00 12.72           N  
ATOM    194  CA  MET A  53      11.302   5.814  27.078  1.00 10.52           C  
ATOM    195  C   MET A  53      12.135   5.380  25.871  1.00 10.71           C  
ATOM    196  O   MET A  53      13.349   5.536  25.858  1.00 10.75           O  
ATOM    197  CB  MET A  53      10.666   7.157  26.701  1.00 10.00           C  
ATOM    198  CG  MET A  53       9.669   7.698  27.664  1.00 13.00           C  
ATOM    199  SD  MET A  53       9.048   9.277  26.966  1.00 12.01           S  
ATOM    200  CE  MET A  53       7.460   9.297  27.634  1.00 12.55           C  
ATOM    201  N   THR A  54      11.442   4.868  24.857  1.00 11.29           N  
ATOM    202  CA  THR A  54      12.058   4.490  23.574  1.00  9.46           C  
ATOM    203  C   THR A  54      11.511   5.542  22.628  1.00  8.10           C  
ATOM    204  O   THR A  54      10.301   5.745  22.556  1.00  9.47           O  
ATOM    205  CB  THR A  54      11.633   3.096  23.139  1.00 10.59           C  
ATOM    206  OG1 THR A  54      12.188   2.158  24.075  1.00 12.08           O  
ATOM    207  CG2 THR A  54      12.166   2.762  21.771  1.00 12.28           C  
ATOM    208  N   VAL A  55      12.423   6.235  21.963  1.00  9.60           N  
ATOM    209  CA  VAL A  55      12.124   7.342  21.060  1.00 10.04           C  
ATOM    210  C   VAL A  55      12.659   7.126  19.633  1.00 11.65           C  
ATOM    211  O   VAL A  55      13.746   6.541  19.431  1.00 11.06           O  
ATOM    212  CB  VAL A  55      12.763   8.641  21.660  1.00  8.42           C  
ATOM    213  CG1 VAL A  55      12.550   9.874  20.711  1.00  8.83           C  
ATOM    214  CG2 VAL A  55      12.176   8.884  23.089  1.00 10.53           C  
ATOM    215  N   VAL A  56      11.884   7.582  18.633  1.00  9.77           N  
ATOM    216  CA  VAL A  56      12.299   7.509  17.227  1.00 10.80           C  
ATOM    217  C   VAL A  56      12.645   8.951  16.868  1.00 11.31           C  
ATOM    218  O   VAL A  56      11.852   9.862  17.136  1.00 11.03           O  
ATOM    219  CB  VAL A  56      11.181   6.992  16.296  1.00 11.81           C  
ATOM    220  CG1 VAL A  56      11.577   7.224  14.812  1.00 11.62           C  
ATOM    221  CG2 VAL A  56      10.985   5.462  16.523  1.00  9.29           C  
ATOM    222  N   ASP A  57      13.834   9.145  16.294  1.00  7.79           N  
ATOM    223  CA  ASP A  57      14.315  10.505  15.926  1.00 10.69           C  
ATOM    224  C   ASP A  57      14.541  10.551  14.417  1.00 11.11           C  
ATOM    225  O   ASP A  57      15.488   9.945  13.898  1.00 10.69           O  
ATOM    226  CB  ASP A  57      15.616  10.803  16.688  1.00  9.33           C  
ATOM    227  CG  ASP A  57      16.148  12.241  16.444  1.00 11.51           C  
ATOM    228  OD1 ASP A  57      15.438  13.031  15.771  1.00 11.59           O  
ATOM    229  OD2 ASP A  57      17.266  12.578  16.926  1.00 11.02           O  
ATOM    230  N   LEU A  58      13.672  11.281  13.705  1.00 11.35           N  
ATOM    231  CA  LEU A  58      13.762  11.355  12.235  1.00 10.76           C  
ATOM    232  C   LEU A  58      14.444  12.655  11.821  1.00  9.83           C  
ATOM    233  O   LEU A  58      14.098  13.725  12.337  1.00 11.39           O  
ATOM    234  CB  LEU A  58      12.349  11.267  11.634  1.00  7.61           C  
ATOM    235  CG  LEU A  58      11.553  10.014  12.010  1.00 10.57           C  
ATOM    236  CD1 LEU A  58      10.112  10.101  11.401  1.00 10.17           C  
ATOM    237  CD2 LEU A  58      12.271   8.776  11.515  1.00 10.05           C  
ATOM    238  N   GLY A  59      15.435  12.562  10.931  1.00 11.58           N  
ATOM    239  CA  GLY A  59      16.194  13.753  10.517  1.00 10.71           C  
ATOM    240  C   GLY A  59      17.099  14.144  11.690  1.00 11.93           C  
ATOM    241  O   GLY A  59      17.196  15.308  12.105  1.00  9.92           O  
ATOM    242  N   ALA A  60      17.792  13.146  12.218  1.00 10.31           N  
ATOM    243  CA  ALA A  60      18.624  13.329  13.397  1.00 10.20           C  
ATOM    244  C   ALA A  60      19.943  14.043  13.334  1.00 11.57           C  
ATOM    245  O   ALA A  60      20.392  14.551  14.372  1.00 12.49           O  
ATOM    246  CB  ALA A  60      18.840  11.969  14.062  1.00 10.49           C  
ATOM    247  N   ALA A  61      20.581  14.085  12.159  1.00 10.63           N  
ATOM    248  CA  ALA A  61      21.916  14.694  12.063  1.00 12.22           C  
ATOM    249  C   ALA A  61      21.911  16.195  12.268  1.00 12.43           C  
ATOM    250  O   ALA A  61      21.023  16.883  11.758  1.00 12.92           O  
ATOM    251  CB  ALA A  61      22.575  14.327  10.703  1.00 14.62           C  
ATOM    252  N   PRO A  62      22.936  16.741  12.935  1.00 13.05           N  
ATOM    253  CA  PRO A  62      24.128  16.109  13.523  1.00 12.39           C  
ATOM    254  C   PRO A  62      23.974  15.446  14.889  1.00 14.20           C  
ATOM    255  O   PRO A  62      24.957  14.895  15.401  1.00 14.65           O  
ATOM    256  CB  PRO A  62      25.144  17.249  13.549  1.00 13.77           C  
ATOM    257  CG  PRO A  62      24.288  18.444  13.825  1.00 14.84           C  
ATOM    258  CD  PRO A  62      23.095  18.216  12.914  1.00 13.38           C  
ATOM    259  N   GLY A  63      22.786  15.527  15.493  1.00 13.45           N  
ATOM    260  CA  GLY A  63      22.577  14.823  16.755  1.00 12.15           C  
ATOM    261  C   GLY A  63      22.089  15.615  17.959  1.00 12.36           C  
ATOM    262  O   GLY A  63      22.040  15.077  19.067  1.00 11.25           O  
ATOM    263  N   GLY A  64      21.717  16.880  17.757  1.00 10.67           N  
ATOM    264  CA  GLY A  64      21.255  17.694  18.879  1.00 12.98           C  
ATOM    265  C   GLY A  64      20.044  17.161  19.636  1.00 11.67           C  
ATOM    266  O   GLY A  64      20.026  17.113  20.879  1.00 12.43           O  
ATOM    267  N   TRP A  65      19.007  16.772  18.896  1.00 11.43           N  
ATOM    268  CA  TRP A  65      17.797  16.258  19.511  1.00 11.20           C  
ATOM    269  C   TRP A  65      18.076  14.942  20.240  1.00 10.13           C  
ATOM    270  O   TRP A  65      17.664  14.770  21.366  1.00 10.87           O  
ATOM    271  CB  TRP A  65      16.717  16.070  18.448  1.00 10.14           C  
ATOM    272  CG  TRP A  65      16.027  17.341  18.125  1.00  9.20           C  
ATOM    273  CD1 TRP A  65      16.510  18.596  18.287  1.00 10.90           C  
ATOM    274  CD2 TRP A  65      14.706  17.484  17.568  1.00  9.23           C  
ATOM    275  NE1 TRP A  65      15.581  19.521  17.869  1.00 10.55           N  
ATOM    276  CE2 TRP A  65      14.462  18.864  17.429  1.00 10.77           C  
ATOM    277  CE3 TRP A  65      13.709  16.572  17.185  1.00  8.79           C  
ATOM    278  CZ2 TRP A  65      13.253  19.368  16.927  1.00 11.54           C  
ATOM    279  CZ3 TRP A  65      12.491  17.067  16.679  1.00  8.88           C  
ATOM    280  CH2 TRP A  65      12.280  18.458  16.558  1.00  9.10           C  
ATOM    281  N   SER A  66      18.791  14.019  19.604  1.00 12.99           N  
ATOM    282  CA  SER A  66      19.099  12.757  20.287  1.00 12.80           C  
ATOM    283  C   SER A  66      19.980  13.033  21.518  1.00 12.12           C  
ATOM    284  O   SER A  66      19.814  12.396  22.570  1.00 11.53           O  
ATOM    285  CB  SER A  66      19.806  11.771  19.336  1.00 12.09           C  
ATOM    286  OG  SER A  66      18.893  11.151  18.422  1.00 11.98           O  
ATOM    287  N   GLN A  67      20.915  13.972  21.402  1.00 12.34           N  
ATOM    288  CA  GLN A  67      21.782  14.312  22.544  1.00 12.10           C  
ATOM    289  C   GLN A  67      20.887  14.817  23.690  1.00 11.70           C  
ATOM    290  O   GLN A  67      21.013  14.386  24.869  1.00 11.58           O  
ATOM    291  CB  GLN A  67      22.777  15.401  22.133  1.00 13.80           C  
ATOM    292  CG  GLN A  67      23.602  16.020  23.258  1.00 15.10           C  
ATOM    293  CD  GLN A  67      24.395  17.191  22.697  1.00 15.96           C  
ATOM    294  OE1 GLN A  67      23.904  17.874  21.784  1.00 13.67           O  
ATOM    295  NE2 GLN A  67      25.619  17.417  23.208  1.00 14.22           N  
ATOM    296  N   TYR A  68      19.979  15.726  23.340  1.00 10.59           N  
ATOM    297  CA  TYR A  68      19.071  16.269  24.330  1.00 12.13           C  
ATOM    298  C   TYR A  68      18.197  15.173  24.949  1.00 12.51           C  
ATOM    299  O   TYR A  68      18.066  15.066  26.170  1.00 11.04           O  
ATOM    300  CB  TYR A  68      18.144  17.311  23.710  1.00 12.50           C  
ATOM    301  CG  TYR A  68      17.297  17.946  24.767  1.00 12.87           C  
ATOM    302  CD1 TYR A  68      17.834  18.940  25.594  1.00 11.75           C  
ATOM    303  CD2 TYR A  68      15.988  17.504  25.010  1.00 11.99           C  
ATOM    304  CE1 TYR A  68      17.093  19.479  26.644  1.00 12.08           C  
ATOM    305  CE2 TYR A  68      15.236  18.046  26.068  1.00  9.36           C  
ATOM    306  CZ  TYR A  68      15.805  19.033  26.869  1.00 12.91           C  
ATOM    307  OH  TYR A  68      15.075  19.624  27.870  1.00 11.63           O  
ATOM    308  N   VAL A  69      17.573  14.357  24.108  1.00  9.88           N  
ATOM    309  CA  VAL A  69      16.696  13.328  24.661  1.00 10.29           C  
ATOM    310  C   VAL A  69      17.409  12.319  25.569  1.00  9.87           C  
ATOM    311  O   VAL A  69      16.825  11.884  26.550  1.00 10.31           O  
ATOM    312  CB  VAL A  69      15.891  12.633  23.533  1.00 10.72           C  
ATOM    313  CG1 VAL A  69      15.110  11.450  24.071  1.00 10.93           C  
ATOM    314  CG2 VAL A  69      14.919  13.652  22.914  1.00  9.73           C  
ATOM    315  N   VAL A  70      18.662  11.978  25.277  1.00 10.46           N  
ATOM    316  CA  VAL A  70      19.373  11.042  26.155  1.00  9.95           C  
ATOM    317  C   VAL A  70      19.485  11.627  27.570  1.00 11.23           C  
ATOM    318  O   VAL A  70      19.410  10.884  28.568  1.00 11.99           O  
ATOM    319  CB  VAL A  70      20.779  10.704  25.562  1.00 11.71           C  
ATOM    320  CG1 VAL A  70      21.658   9.977  26.591  1.00 14.01           C  
ATOM    321  CG2 VAL A  70      20.595   9.794  24.370  1.00 11.50           C  
ATOM    322  N   THR A  71      19.608  12.946  27.691  1.00  9.42           N  
ATOM    323  CA  THR A  71      19.699  13.514  29.027  1.00 13.03           C  
ATOM    324  C   THR A  71      18.385  13.379  29.782  1.00 13.35           C  
ATOM    325  O   THR A  71      18.366  13.449  31.015  1.00 14.19           O  
ATOM    326  CB  THR A  71      20.081  15.040  29.032  1.00 13.80           C  
ATOM    327  OG1 THR A  71      18.965  15.827  28.594  1.00 15.24           O  
ATOM    328  CG2 THR A  71      21.279  15.307  28.156  1.00 10.89           C  
ATOM    329  N   GLN A  72      17.287  13.194  29.055  1.00 10.44           N  
ATOM    330  CA  GLN A  72      15.980  13.085  29.694  1.00 10.09           C  
ATOM    331  C   GLN A  72      15.535  11.660  29.925  1.00 10.37           C  
ATOM    332  O   GLN A  72      14.976  11.344  30.991  1.00 13.94           O  
ATOM    333  CB  GLN A  72      14.912  13.806  28.862  1.00 10.11           C  
ATOM    334  CG  GLN A  72      15.283  15.254  28.537  1.00 10.77           C  
ATOM    335  CD  GLN A  72      15.366  16.116  29.810  1.00 12.18           C  
ATOM    336  OE1 GLN A  72      14.354  16.347  30.495  1.00 13.01           O  
ATOM    337  NE2 GLN A  72      16.574  16.571  30.138  1.00 11.88           N  
ATOM    338  N   ILE A  73      15.773  10.795  28.936  1.00 11.03           N  
ATOM    339  CA  ILE A  73      15.331   9.407  29.075  1.00 10.74           C  
ATOM    340  C   ILE A  73      16.347   8.609  29.831  1.00 11.28           C  
ATOM    341  O   ILE A  73      16.035   7.534  30.339  1.00 11.21           O  
ATOM    342  CB  ILE A  73      15.007   8.726  27.700  1.00 11.30           C  
ATOM    343  CG1 ILE A  73      16.283   8.522  26.873  1.00 11.67           C  
ATOM    344  CG2 ILE A  73      13.972   9.593  26.926  1.00  9.81           C  
ATOM    345  CD1 ILE A  73      16.030   7.901  25.494  1.00 12.16           C  
ATOM    346  N   GLY A  74      17.562   9.126  29.923  1.00 12.15           N  
ATOM    347  CA  GLY A  74      18.594   8.433  30.686  1.00 13.95           C  
ATOM    348  C   GLY A  74      19.220   7.229  30.004  1.00 13.69           C  
ATOM    349  O   GLY A  74      18.829   6.844  28.924  1.00 13.47           O  
ATOM    350  N   GLY A  75      20.193   6.614  30.671  1.00 13.55           N  
ATOM    351  CA  GLY A  75      20.880   5.475  30.087  1.00 13.98           C  
ATOM    352  C   GLY A  75      20.046   4.234  29.853  1.00 14.33           C  
ATOM    353  O   GLY A  75      20.477   3.352  29.097  1.00 13.97           O  
ATOM    354  N   LYS A  76      18.870   4.139  30.480  1.00 11.14           N  
ATOM    355  CA  LYS A  76      18.034   2.968  30.270  1.00 12.90           C  
ATOM    356  C   LYS A  76      16.963   3.175  29.183  1.00 14.79           C  
ATOM    357  O   LYS A  76      16.212   2.253  28.850  1.00 15.57           O  
ATOM    358  CB  LYS A  76      17.404   2.518  31.589  1.00 14.00           C  
ATOM    359  CG  LYS A  76      18.474   2.133  32.620  1.00 15.13           C  
ATOM    360  CD  LYS A  76      17.846   1.683  33.938  1.00 17.61           C  
ATOM    361  CE  LYS A  76      18.919   1.190  34.906  1.00 17.42           C  
ATOM    362  NZ  LYS A  76      19.871   2.277  35.269  1.00 18.72           N  
ATOM    363  N   GLY A  77      16.899   4.374  28.623  1.00 13.75           N  
ATOM    364  CA  GLY A  77      15.963   4.575  27.520  1.00 13.51           C  
ATOM    365  C   GLY A  77      16.796   4.399  26.251  1.00 13.25           C  
ATOM    366  O   GLY A  77      18.008   4.135  26.321  1.00 11.76           O  
ATOM    367  N   ARG A  78      16.181   4.508  25.081  1.00 11.42           N  
ATOM    368  CA  ARG A  78      16.992   4.418  23.876  1.00 11.39           C  
ATOM    369  C   ARG A  78      16.316   5.122  22.717  1.00 11.31           C  
ATOM    370  O   ARG A  78      15.116   5.411  22.764  1.00 11.56           O  
ATOM    371  CB  ARG A  78      17.323   2.978  23.499  1.00 14.65           C  
ATOM    372  CG  ARG A  78      16.183   2.133  23.054  1.00 15.35           C  
ATOM    373  CD  ARG A  78      16.760   0.767  22.557  1.00 16.92           C  
ATOM    374  NE  ARG A  78      15.656  -0.028  22.070  1.00 16.35           N  
ATOM    375  CZ  ARG A  78      15.492  -0.411  20.812  1.00 12.79           C  
ATOM    376  NH1 ARG A  78      16.384  -0.107  19.864  1.00 12.67           N  
ATOM    377  NH2 ARG A  78      14.376  -1.040  20.497  1.00 12.17           N  
ATOM    378  N   ILE A  79      17.106   5.425  21.700  1.00 10.22           N  
ATOM    379  CA  ILE A  79      16.582   6.135  20.533  1.00  9.64           C  
ATOM    380  C   ILE A  79      16.925   5.389  19.244  1.00  9.50           C  
ATOM    381  O   ILE A  79      18.024   4.857  19.122  1.00 10.90           O  
ATOM    382  CB  ILE A  79      17.222   7.554  20.465  1.00 10.09           C  
ATOM    383  CG1 ILE A  79      17.003   8.270  21.793  1.00 10.20           C  
ATOM    384  CG2 ILE A  79      16.607   8.401  19.303  1.00  9.54           C  
ATOM    385  CD1 ILE A  79      17.520   9.723  21.811  1.00 12.27           C  
ATOM    386  N   ILE A  80      15.987   5.353  18.297  1.00  9.59           N  
ATOM    387  CA  ILE A  80      16.250   4.763  16.984  1.00  9.78           C  
ATOM    388  C   ILE A  80      16.226   6.030  16.117  1.00 10.65           C  
ATOM    389  O   ILE A  80      15.205   6.697  16.039  1.00 10.59           O  
ATOM    390  CB  ILE A  80      15.164   3.768  16.534  1.00 11.68           C  
ATOM    391  CG1 ILE A  80      15.115   2.549  17.503  1.00 11.03           C  
ATOM    392  CG2 ILE A  80      15.502   3.263  15.125  1.00 12.32           C  
ATOM    393  CD1 ILE A  80      14.331   2.755  18.805  1.00  9.55           C  
ATOM    394  N   ALA A  81      17.367   6.379  15.538  1.00 10.99           N  
ATOM    395  CA  ALA A  81      17.483   7.623  14.771  1.00 10.22           C  
ATOM    396  C   ALA A  81      17.779   7.374  13.298  1.00 11.37           C  
ATOM    397  O   ALA A  81      18.321   6.322  12.923  1.00 11.76           O  
ATOM    398  CB  ALA A  81      18.595   8.498  15.384  1.00  9.02           C  
ATOM    399  N   CYS A  82      17.465   8.368  12.463  1.00 10.93           N  
ATOM    400  CA  CYS A  82      17.674   8.234  11.030  1.00  9.94           C  
ATOM    401  C   CYS A  82      17.948   9.584  10.373  1.00 11.16           C  
ATOM    402  O   CYS A  82      17.382  10.610  10.760  1.00 11.23           O  
ATOM    403  CB  CYS A  82      16.429   7.615  10.362  1.00 13.07           C  
ATOM    404  SG  CYS A  82      16.486   7.517   8.530  1.00 17.25           S  
ATOM    405  N   ASP A  83      18.860   9.578   9.412  1.00 12.18           N  
ATOM    406  CA  ASP A  83      19.170  10.791   8.629  1.00 11.65           C  
ATOM    407  C   ASP A  83      19.871  10.373   7.333  1.00 13.99           C  
ATOM    408  O   ASP A  83      20.481   9.307   7.257  1.00 14.12           O  
ATOM    409  CB  ASP A  83      20.095  11.743   9.386  1.00 11.30           C  
ATOM    410  CG  ASP A  83      20.053  13.183   8.837  1.00 12.31           C  
ATOM    411  OD1 ASP A  83      20.549  13.444   7.724  1.00 13.12           O  
ATOM    412  OD2 ASP A  83      19.514  14.071   9.538  1.00 11.53           O  
ATOM    413  N   LEU A  84      19.750  11.198   6.299  1.00 11.30           N  
ATOM    414  CA  LEU A  84      20.433  10.928   5.046  1.00 13.05           C  
ATOM    415  C   LEU A  84      21.939  11.050   5.254  1.00 13.19           C  
ATOM    416  O   LEU A  84      22.711  10.388   4.555  1.00 15.58           O  
ATOM    417  CB  LEU A  84      20.054  11.962   3.993  1.00 14.46           C  
ATOM    418  CG  LEU A  84      18.699  11.834   3.318  1.00 16.23           C  
ATOM    419  CD1 LEU A  84      18.284  13.213   2.767  1.00 15.25           C  
ATOM    420  CD2 LEU A  84      18.802  10.769   2.199  1.00 15.97           C  
ATOM    421  N   LEU A  85      22.334  11.919   6.179  1.00 14.22           N  
ATOM    422  CA  LEU A  85      23.732  12.199   6.495  1.00 16.05           C  
ATOM    423  C   LEU A  85      24.265  11.332   7.624  1.00 16.83           C  
ATOM    424  O   LEU A  85      23.508  10.852   8.460  1.00 18.10           O  
ATOM    425  CB  LEU A  85      23.888  13.662   6.944  1.00 15.62           C  
ATOM    426  CG  LEU A  85      23.396  14.727   5.955  1.00 17.39           C  
ATOM    427  CD1 LEU A  85      23.450  16.105   6.593  1.00 16.41           C  
ATOM    428  CD2 LEU A  85      24.236  14.644   4.702  1.00 15.89           C  
ATOM    429  N   PRO A  86      25.592  11.121   7.662  1.00 17.58           N  
ATOM    430  CA  PRO A  86      26.143  10.309   8.754  1.00 17.80           C  
ATOM    431  C   PRO A  86      26.233  11.229   9.972  1.00 18.32           C  
ATOM    432  O   PRO A  86      26.159  12.456   9.833  1.00 19.82           O  
ATOM    433  CB  PRO A  86      27.532   9.939   8.228  1.00 18.83           C  
ATOM    434  CG  PRO A  86      27.934  11.207   7.485  1.00 19.56           C  
ATOM    435  CD  PRO A  86      26.641  11.523   6.708  1.00 19.91           C  
ATOM    436  N   MET A  87      26.340  10.672  11.179  1.00 18.89           N  
ATOM    437  CA  MET A  87      26.525  11.528  12.340  1.00 16.36           C  
ATOM    438  C   MET A  87      27.299  10.801  13.422  1.00 16.33           C  
ATOM    439  O   MET A  87      27.367   9.577  13.411  1.00 15.74           O  
ATOM    440  CB  MET A  87      25.200  12.031  12.926  1.00 19.00           C  
ATOM    441  CG  MET A  87      24.341  10.999  13.635  1.00 17.80           C  
ATOM    442  SD  MET A  87      22.959  11.808  14.530  1.00 17.10           S  
ATOM    443  CE  MET A  87      22.534  10.487  15.679  1.00 15.91           C  
ATOM    444  N   ASP A  88      27.874  11.572  14.336  1.00 17.64           N  
ATOM    445  CA  ASP A  88      28.642  11.009  15.450  1.00 18.79           C  
ATOM    446  C   ASP A  88      27.824  10.001  16.252  1.00 17.83           C  
ATOM    447  O   ASP A  88      26.631  10.211  16.536  1.00 15.67           O  
ATOM    448  CB  ASP A  88      29.091  12.129  16.396  1.00 23.97           C  
ATOM    449  CG  ASP A  88      30.391  12.794  15.955  1.00 30.85           C  
ATOM    450  OD1 ASP A  88      30.920  12.420  14.879  1.00 30.72           O  
ATOM    451  OD2 ASP A  88      30.882  13.689  16.703  1.00 32.82           O  
ATOM    452  N   PRO A  89      28.446   8.883  16.641  1.00 15.07           N  
ATOM    453  CA  PRO A  89      27.630   7.950  17.417  1.00 15.42           C  
ATOM    454  C   PRO A  89      27.330   8.508  18.811  1.00 14.26           C  
ATOM    455  O   PRO A  89      28.079   9.345  19.349  1.00 14.25           O  
ATOM    456  CB  PRO A  89      28.482   6.665  17.458  1.00 17.70           C  
ATOM    457  CG  PRO A  89      29.872   7.152  17.289  1.00 18.37           C  
ATOM    458  CD  PRO A  89      29.760   8.309  16.295  1.00 16.46           C  
ATOM    459  N   ILE A  90      26.207   8.061  19.367  1.00 12.43           N  
ATOM    460  CA  ILE A  90      25.784   8.449  20.707  1.00 12.29           C  
ATOM    461  C   ILE A  90      25.362   7.161  21.414  1.00 11.14           C  
ATOM    462  O   ILE A  90      24.591   6.366  20.859  1.00 13.47           O  
ATOM    463  CB  ILE A  90      24.571   9.406  20.666  1.00 12.67           C  
ATOM    464  CG1 ILE A  90      24.944  10.679  19.898  1.00 12.40           C  
ATOM    465  CG2 ILE A  90      24.096   9.717  22.092  1.00 11.52           C  
ATOM    466  CD1 ILE A  90      23.786  11.671  19.786  1.00 15.96           C  
ATOM    467  N   VAL A  91      25.879   6.945  22.622  1.00 10.60           N  
ATOM    468  CA  VAL A  91      25.519   5.754  23.367  1.00 11.34           C  
ATOM    469  C   VAL A  91      24.028   5.811  23.675  1.00 11.22           C  
ATOM    470  O   VAL A  91      23.538   6.813  24.188  1.00 14.50           O  
ATOM    471  CB  VAL A  91      26.338   5.644  24.687  1.00 12.78           C  
ATOM    472  CG1 VAL A  91      25.773   4.523  25.596  1.00 12.84           C  
ATOM    473  CG2 VAL A  91      27.806   5.348  24.335  1.00 12.45           C  
ATOM    474  N   GLY A  92      23.314   4.738  23.339  1.00 10.67           N  
ATOM    475  CA  GLY A  92      21.881   4.700  23.578  1.00 10.37           C  
ATOM    476  C   GLY A  92      21.080   5.057  22.339  1.00 11.32           C  
ATOM    477  O   GLY A  92      19.830   5.019  22.353  1.00 10.96           O  
ATOM    478  N   VAL A  93      21.784   5.405  21.271  1.00  9.81           N  
ATOM    479  CA  VAL A  93      21.123   5.783  20.006  1.00  8.69           C  
ATOM    480  C   VAL A  93      21.535   4.818  18.912  1.00 11.08           C  
ATOM    481  O   VAL A  93      22.716   4.703  18.615  1.00 10.26           O  
ATOM    482  CB  VAL A  93      21.546   7.189  19.564  1.00  8.31           C  
ATOM    483  CG1 VAL A  93      20.863   7.589  18.223  1.00 10.10           C  
ATOM    484  CG2 VAL A  93      21.204   8.154  20.664  1.00 12.26           C  
ATOM    485  N   ASP A  94      20.554   4.138  18.335  1.00 10.61           N  
ATOM    486  CA  ASP A  94      20.770   3.199  17.235  1.00 11.10           C  
ATOM    487  C   ASP A  94      20.516   4.030  15.978  1.00 11.53           C  
ATOM    488  O   ASP A  94      19.369   4.264  15.597  1.00 13.31           O  
ATOM    489  CB  ASP A  94      19.766   2.074  17.295  1.00 11.93           C  
ATOM    490  CG  ASP A  94      20.016   1.155  18.468  1.00 12.31           C  
ATOM    491  OD1 ASP A  94      21.167   1.112  18.944  1.00 13.74           O  
ATOM    492  OD2 ASP A  94      19.062   0.481  18.895  1.00 14.10           O  
ATOM    493  N   PHE A  95      21.596   4.470  15.361  1.00 10.77           N  
ATOM    494  CA  PHE A  95      21.489   5.355  14.210  1.00 12.49           C  
ATOM    495  C   PHE A  95      21.645   4.654  12.883  1.00 13.22           C  
ATOM    496  O   PHE A  95      22.584   3.895  12.677  1.00 14.74           O  
ATOM    497  CB  PHE A  95      22.535   6.472  14.334  1.00 13.43           C  
ATOM    498  CG  PHE A  95      22.559   7.381  13.162  1.00 13.79           C  
ATOM    499  CD1 PHE A  95      21.575   8.362  13.020  1.00 14.35           C  
ATOM    500  CD2 PHE A  95      23.517   7.230  12.169  1.00 15.06           C  
ATOM    501  CE1 PHE A  95      21.546   9.189  11.884  1.00 15.48           C  
ATOM    502  CE2 PHE A  95      23.507   8.042  11.038  1.00 16.15           C  
ATOM    503  CZ  PHE A  95      22.514   9.029  10.889  1.00 17.63           C  
ATOM    504  N   LEU A  96      20.730   4.945  11.968  1.00 12.92           N  
ATOM    505  CA  LEU A  96      20.751   4.342  10.645  1.00 15.07           C  
ATOM    506  C   LEU A  96      20.808   5.427   9.589  1.00 16.01           C  
ATOM    507  O   LEU A  96      19.877   6.222   9.467  1.00 12.75           O  
ATOM    508  CB  LEU A  96      19.503   3.507  10.410  1.00 17.70           C  
ATOM    509  CG  LEU A  96      19.340   2.950   8.983  1.00 20.47           C  
ATOM    510  CD1 LEU A  96      20.367   1.837   8.754  1.00 20.18           C  
ATOM    511  CD2 LEU A  96      17.942   2.374   8.804  1.00 23.62           C  
ATOM    512  N   GLN A  97      21.910   5.475   8.844  1.00 13.65           N  
ATOM    513  CA  GLN A  97      22.031   6.469   7.788  1.00 16.04           C  
ATOM    514  C   GLN A  97      21.244   5.950   6.598  1.00 15.90           C  
ATOM    515  O   GLN A  97      21.449   4.808   6.157  1.00 16.01           O  
ATOM    516  CB  GLN A  97      23.494   6.677   7.380  1.00 16.77           C  
ATOM    517  CG  GLN A  97      23.663   7.898   6.494  1.00 17.02           C  
ATOM    518  CD  GLN A  97      25.043   8.011   5.899  1.00 20.95           C  
ATOM    519  OE1 GLN A  97      26.000   7.385   6.384  1.00 19.99           O  
ATOM    520  NE2 GLN A  97      25.168   8.825   4.844  1.00 20.29           N  
ATOM    521  N   GLY A  98      20.344   6.781   6.076  1.00 15.71           N  
ATOM    522  CA  GLY A  98      19.523   6.357   4.950  1.00 16.16           C  
ATOM    523  C   GLY A  98      18.414   7.357   4.649  1.00 15.61           C  
ATOM    524  O   GLY A  98      18.133   8.262   5.459  1.00 16.58           O  
ATOM    525  N   ASP A  99      17.802   7.194   3.482  1.00 15.34           N  
ATOM    526  CA  ASP A  99      16.713   8.044   3.019  1.00 14.60           C  
ATOM    527  C   ASP A  99      15.409   7.523   3.610  1.00 13.92           C  
ATOM    528  O   ASP A  99      14.930   6.425   3.270  1.00 14.96           O  
ATOM    529  CB  ASP A  99      16.646   7.998   1.480  1.00 17.28           C  
ATOM    530  CG  ASP A  99      15.773   9.073   0.908  1.00 19.78           C  
ATOM    531  OD1 ASP A  99      14.745   9.398   1.539  1.00 17.08           O  
ATOM    532  OD2 ASP A  99      16.106   9.591  -0.180  1.00 21.92           O  
ATOM    533  N   PHE A 100      14.817   8.310   4.500  1.00 13.16           N  
ATOM    534  CA  PHE A 100      13.583   7.904   5.131  1.00 13.74           C  
ATOM    535  C   PHE A 100      12.440   7.668   4.123  1.00 14.16           C  
ATOM    536  O   PHE A 100      11.439   7.008   4.445  1.00 14.51           O  
ATOM    537  CB  PHE A 100      13.184   8.956   6.185  1.00 12.81           C  
ATOM    538  CG  PHE A 100      12.004   8.555   7.017  1.00 15.40           C  
ATOM    539  CD1 PHE A 100      12.072   7.434   7.855  1.00 15.53           C  
ATOM    540  CD2 PHE A 100      10.810   9.271   6.935  1.00 14.39           C  
ATOM    541  CE1 PHE A 100      10.961   7.033   8.594  1.00 17.12           C  
ATOM    542  CE2 PHE A 100       9.691   8.882   7.671  1.00 17.95           C  
ATOM    543  CZ  PHE A 100       9.763   7.760   8.504  1.00 15.90           C  
ATOM    544  N   ARG A 101      12.571   8.187   2.902  1.00 16.37           N  
ATOM    545  CA  ARG A 101      11.508   7.965   1.930  1.00 17.14           C  
ATOM    546  C   ARG A 101      11.565   6.561   1.324  1.00 19.11           C  
ATOM    547  O   ARG A 101      10.611   6.119   0.684  1.00 19.58           O  
ATOM    548  CB  ARG A 101      11.580   8.990   0.795  1.00 17.60           C  
ATOM    549  CG  ARG A 101      11.409  10.437   1.253  1.00 15.82           C  
ATOM    550  CD  ARG A 101      11.796  11.426   0.151  1.00 19.94           C  
ATOM    551  NE  ARG A 101      13.219  11.337  -0.180  1.00 24.33           N  
ATOM    552  CZ  ARG A 101      13.841  12.151  -1.032  1.00 29.70           C  
ATOM    553  NH1 ARG A 101      13.163  13.125  -1.650  1.00 28.64           N  
ATOM    554  NH2 ARG A 101      15.143  12.001  -1.264  1.00 28.46           N  
ATOM    555  N   ASP A 102      12.687   5.874   1.511  1.00 18.99           N  
ATOM    556  CA  ASP A 102      12.873   4.531   0.954  1.00 22.29           C  
ATOM    557  C   ASP A 102      12.271   3.497   1.898  1.00 22.65           C  
ATOM    558  O   ASP A 102      12.640   3.436   3.066  1.00 21.27           O  
ATOM    559  CB  ASP A 102      14.374   4.287   0.761  1.00 23.53           C  
ATOM    560  CG  ASP A 102      14.685   2.944   0.140  1.00 28.94           C  
ATOM    561  OD1 ASP A 102      13.825   2.036   0.186  1.00 29.83           O  
ATOM    562  OD2 ASP A 102      15.817   2.796  -0.378  1.00 32.66           O  
ATOM    563  N   GLU A 103      11.340   2.688   1.403  1.00 24.46           N  
ATOM    564  CA  GLU A 103      10.709   1.685   2.268  1.00 27.51           C  
ATOM    565  C   GLU A 103      11.725   0.710   2.858  1.00 26.24           C  
ATOM    566  O   GLU A 103      11.477   0.123   3.907  1.00 27.74           O  
ATOM    567  CB  GLU A 103       9.649   0.888   1.511  1.00 30.01           C  
ATOM    568  CG  GLU A 103      10.225  -0.276   0.943  1.00 34.54           C  
ATOM    569  N   LEU A 104      12.858   0.523   2.191  1.00 25.68           N  
ATOM    570  CA  LEU A 104      13.869  -0.390   2.708  1.00 26.39           C  
ATOM    571  C   LEU A 104      14.494   0.174   3.978  1.00 24.29           C  
ATOM    572  O   LEU A 104      14.881  -0.569   4.886  1.00 23.41           O  
ATOM    573  CB  LEU A 104      14.962  -0.639   1.667  1.00 28.69           C  
ATOM    574  CG  LEU A 104      14.527  -1.561   0.527  1.00 31.95           C  
ATOM    575  CD1 LEU A 104      15.705  -1.809  -0.431  1.00 31.80           C  
ATOM    576  CD2 LEU A 104      14.020  -2.869   1.130  1.00 32.15           C  
ATOM    577  N   VAL A 105      14.592   1.496   4.024  1.00 22.13           N  
ATOM    578  CA  VAL A 105      15.154   2.183   5.172  1.00 21.48           C  
ATOM    579  C   VAL A 105      14.136   2.089   6.312  1.00 20.92           C  
ATOM    580  O   VAL A 105      14.506   1.883   7.472  1.00 18.51           O  
ATOM    581  CB  VAL A 105      15.480   3.650   4.791  1.00 17.91           C  
ATOM    582  CG1 VAL A 105      15.828   4.460   6.021  1.00 17.61           C  
ATOM    583  CG2 VAL A 105      16.649   3.671   3.825  1.00 18.91           C  
ATOM    584  N   MET A 106      12.851   2.219   5.976  1.00 21.08           N  
ATOM    585  CA  MET A 106      11.800   2.108   6.976  1.00 23.29           C  
ATOM    586  C   MET A 106      11.874   0.724   7.579  1.00 24.17           C  
ATOM    587  O   MET A 106      11.792   0.572   8.796  1.00 26.59           O  
ATOM    588  CB  MET A 106      10.402   2.295   6.367  1.00 24.07           C  
ATOM    589  CG  MET A 106       9.265   1.844   7.308  1.00 25.93           C  
ATOM    590  SD  MET A 106       9.301   2.845   8.798  1.00 32.49           S  
ATOM    591  CE  MET A 106       8.943   4.428   8.059  1.00 28.28           C  
ATOM    592  N   LYS A 107      12.029  -0.287   6.733  1.00 23.83           N  
ATOM    593  CA  LYS A 107      12.104  -1.657   7.237  1.00 24.40           C  
ATOM    594  C   LYS A 107      13.268  -1.832   8.203  1.00 22.47           C  
ATOM    595  O   LYS A 107      13.126  -2.494   9.228  1.00 22.64           O  
ATOM    596  CB  LYS A 107      12.239  -2.660   6.079  1.00 24.70           C  
ATOM    597  N   ALA A 108      14.412  -1.232   7.900  1.00 19.33           N  
ATOM    598  CA  ALA A 108      15.564  -1.386   8.770  1.00 18.57           C  
ATOM    599  C   ALA A 108      15.340  -0.620  10.076  1.00 17.49           C  
ATOM    600  O   ALA A 108      15.837  -1.015  11.136  1.00 15.49           O  
ATOM    601  CB  ALA A 108      16.825  -0.907   8.067  1.00 19.07           C  
ATOM    602  N   LEU A 109      14.606   0.485  10.014  1.00 15.88           N  
ATOM    603  CA  LEU A 109      14.342   1.214  11.257  1.00 19.00           C  
ATOM    604  C   LEU A 109      13.437   0.344  12.139  1.00 18.90           C  
ATOM    605  O   LEU A 109      13.645   0.233  13.356  1.00 17.64           O  
ATOM    606  CB  LEU A 109      13.668   2.580  10.977  1.00 19.00           C  
ATOM    607  CG  LEU A 109      14.540   3.736  10.445  1.00 20.78           C  
ATOM    608  CD1 LEU A 109      13.627   4.953  10.212  1.00 19.98           C  
ATOM    609  CD2 LEU A 109      15.660   4.099  11.447  1.00 17.37           C  
ATOM    610  N   LEU A 110      12.429  -0.277  11.534  1.00 18.88           N  
ATOM    611  CA  LEU A 110      11.533  -1.136  12.304  1.00 21.00           C  
ATOM    612  C   LEU A 110      12.277  -2.328  12.906  1.00 18.91           C  
ATOM    613  O   LEU A 110      11.896  -2.814  13.964  1.00 17.39           O  
ATOM    614  CB  LEU A 110      10.347  -1.606  11.448  1.00 20.77           C  
ATOM    615  CG  LEU A 110       9.369  -0.502  11.012  1.00 25.72           C  
ATOM    616  CD1 LEU A 110       8.289  -1.079  10.080  1.00 26.24           C  
ATOM    617  CD2 LEU A 110       8.725   0.124  12.231  1.00 25.70           C  
ATOM    618  N   GLU A 111      13.338  -2.787  12.253  1.00 17.67           N  
ATOM    619  CA  GLU A 111      14.110  -3.900  12.813  1.00 17.62           C  
ATOM    620  C   GLU A 111      14.855  -3.448  14.061  1.00 17.09           C  
ATOM    621  O   GLU A 111      15.182  -4.269  14.940  1.00 16.68           O  
ATOM    622  CB  GLU A 111      15.102  -4.458  11.778  1.00 20.40           C  
ATOM    623  CG  GLU A 111      14.383  -5.159  10.620  1.00 24.84           C  
ATOM    624  CD  GLU A 111      15.322  -5.698   9.557  1.00 28.06           C  
ATOM    625  OE1 GLU A 111      16.475  -5.230   9.471  1.00 27.37           O  
ATOM    626  OE2 GLU A 111      14.882  -6.586   8.789  1.00 29.40           O  
ATOM    627  N   ARG A 112      15.143  -2.145  14.157  1.00 13.54           N  
ATOM    628  CA  ARG A 112      15.824  -1.655  15.355  1.00 13.02           C  
ATOM    629  C   ARG A 112      14.802  -1.383  16.456  1.00 11.65           C  
ATOM    630  O   ARG A 112      15.089  -1.525  17.638  1.00 10.97           O  
ATOM    631  CB  ARG A 112      16.640  -0.410  15.018  1.00 11.62           C  
ATOM    632  CG  ARG A 112      17.881  -0.807  14.178  1.00 12.38           C  
ATOM    633  CD  ARG A 112      18.457   0.332  13.341  1.00 14.70           C  
ATOM    634  NE  ARG A 112      19.687  -0.108  12.684  1.00 16.65           N  
ATOM    635  CZ  ARG A 112      19.739  -0.946  11.650  1.00 18.30           C  
ATOM    636  NH1 ARG A 112      18.620  -1.443  11.113  1.00 13.63           N  
ATOM    637  NH2 ARG A 112      20.923  -1.316  11.175  1.00 16.33           N  
ATOM    638  N   VAL A 113      13.590  -1.007  16.078  1.00 10.63           N  
ATOM    639  CA  VAL A 113      12.580  -0.772  17.101  1.00 10.24           C  
ATOM    640  C   VAL A 113      12.178  -2.144  17.679  1.00 12.15           C  
ATOM    641  O   VAL A 113      12.091  -2.311  18.904  1.00 12.35           O  
ATOM    642  CB  VAL A 113      11.340  -0.080  16.499  1.00 11.71           C  
ATOM    643  CG1 VAL A 113      10.146  -0.090  17.516  1.00 13.44           C  
ATOM    644  CG2 VAL A 113      11.713   1.341  16.114  1.00 13.25           C  
ATOM    645  N   GLY A 114      11.970  -3.134  16.797  1.00 12.27           N  
ATOM    646  CA  GLY A 114      11.572  -4.458  17.266  1.00 10.61           C  
ATOM    647  C   GLY A 114      10.260  -4.401  18.036  1.00 12.21           C  
ATOM    648  O   GLY A 114       9.358  -3.674  17.632  1.00 11.60           O  
ATOM    649  N   ASP A 115      10.139  -5.134  19.150  1.00 12.67           N  
ATOM    650  CA  ASP A 115       8.893  -5.098  19.938  1.00 14.76           C  
ATOM    651  C   ASP A 115       8.917  -4.024  21.031  1.00 16.99           C  
ATOM    652  O   ASP A 115       8.009  -3.962  21.864  1.00 17.00           O  
ATOM    653  CB  ASP A 115       8.603  -6.437  20.628  1.00 17.87           C  
ATOM    654  CG  ASP A 115       8.213  -7.522  19.656  1.00 21.55           C  
ATOM    655  OD1 ASP A 115       7.518  -7.220  18.652  1.00 21.78           O  
ATOM    656  OD2 ASP A 115       8.588  -8.684  19.913  1.00 21.24           O  
ATOM    657  N   SER A 116       9.950  -3.192  21.056  1.00 14.72           N  
ATOM    658  CA  SER A 116       9.972  -2.135  22.067  1.00 15.50           C  
ATOM    659  C   SER A 116       8.815  -1.172  21.804  1.00 15.54           C  
ATOM    660  O   SER A 116       8.577  -0.781  20.652  1.00 14.56           O  
ATOM    661  CB  SER A 116      11.289  -1.346  22.015  1.00 15.47           C  
ATOM    662  OG  SER A 116      12.388  -2.103  22.501  1.00 16.51           O  
ATOM    663  N   LYS A 117       8.093  -0.794  22.859  1.00 16.13           N  
ATOM    664  CA  LYS A 117       7.019   0.181  22.702  1.00 16.93           C  
ATOM    665  C   LYS A 117       7.681   1.546  22.537  1.00 14.76           C  
ATOM    666  O   LYS A 117       8.574   1.915  23.312  1.00 15.50           O  
ATOM    667  CB  LYS A 117       6.120   0.196  23.939  1.00 18.32           C  
ATOM    668  CG  LYS A 117       5.272  -1.075  24.096  1.00 26.17           C  
ATOM    669  CD  LYS A 117       4.593  -1.100  25.458  1.00 32.10           C  
ATOM    670  CE  LYS A 117       3.817  -2.395  25.705  1.00 35.82           C  
ATOM    671  NZ  LYS A 117       3.484  -2.534  27.168  1.00 38.74           N  
ATOM    672  N   VAL A 118       7.221   2.305  21.540  1.00 14.26           N  
ATOM    673  CA  VAL A 118       7.768   3.639  21.253  1.00 11.26           C  
ATOM    674  C   VAL A 118       6.837   4.677  21.894  1.00 11.59           C  
ATOM    675  O   VAL A 118       5.641   4.703  21.579  1.00 12.52           O  
ATOM    676  CB  VAL A 118       7.819   3.874  19.739  1.00 11.50           C  
ATOM    677  CG1 VAL A 118       8.310   5.314  19.438  1.00 10.32           C  
ATOM    678  CG2 VAL A 118       8.742   2.837  19.081  1.00 12.01           C  
ATOM    679  N   GLN A 119       7.369   5.522  22.778  1.00 10.70           N  
ATOM    680  CA  GLN A 119       6.520   6.520  23.451  1.00  9.75           C  
ATOM    681  C   GLN A 119       6.534   7.885  22.759  1.00 10.58           C  
ATOM    682  O   GLN A 119       5.626   8.672  22.949  1.00 12.03           O  
ATOM    683  CB  GLN A 119       6.939   6.739  24.919  1.00 13.77           C  
ATOM    684  CG  GLN A 119       6.571   5.591  25.896  1.00 15.56           C  
ATOM    685  CD  GLN A 119       7.491   4.394  25.744  1.00 19.86           C  
ATOM    686  OE1 GLN A 119       8.703   4.550  25.621  1.00 17.60           O  
ATOM    687  NE2 GLN A 119       6.920   3.194  25.755  1.00 22.90           N  
ATOM    688  N   VAL A 120       7.571   8.169  21.993  1.00 11.21           N  
ATOM    689  CA  VAL A 120       7.638   9.468  21.303  1.00 10.00           C  
ATOM    690  C   VAL A 120       8.307   9.310  19.950  1.00  9.86           C  
ATOM    691  O   VAL A 120       9.311   8.600  19.840  1.00  9.99           O  
ATOM    692  CB  VAL A 120       8.494  10.521  22.088  1.00 11.22           C  
ATOM    693  CG1 VAL A 120       8.475  11.869  21.326  1.00 11.43           C  
ATOM    694  CG2 VAL A 120       7.988  10.711  23.546  1.00  8.81           C  
ATOM    695  N   VAL A 121       7.723   9.940  18.923  1.00  8.43           N  
ATOM    696  CA  VAL A 121       8.352  10.012  17.607  1.00  9.10           C  
ATOM    697  C   VAL A 121       8.652  11.511  17.474  1.00  9.83           C  
ATOM    698  O   VAL A 121       7.772  12.341  17.686  1.00  9.43           O  
ATOM    699  CB  VAL A 121       7.425   9.593  16.453  1.00  8.88           C  
ATOM    700  CG1 VAL A 121       8.077   9.981  15.083  1.00 10.40           C  
ATOM    701  CG2 VAL A 121       7.209   8.065  16.514  1.00  7.18           C  
ATOM    702  N   MET A 122       9.897  11.851  17.168  1.00 10.51           N  
ATOM    703  CA  MET A 122      10.267  13.262  17.006  1.00 10.11           C  
ATOM    704  C   MET A 122      10.877  13.431  15.630  1.00 13.59           C  
ATOM    705  O   MET A 122      11.707  12.623  15.196  1.00 12.00           O  
ATOM    706  CB  MET A 122      11.215  13.723  18.120  1.00 12.00           C  
ATOM    707  CG  MET A 122      12.606  13.095  18.171  1.00 12.53           C  
ATOM    708  SD  MET A 122      13.398  13.659  19.688  1.00 11.87           S  
ATOM    709  CE  MET A 122      15.024  12.827  19.549  1.00 11.72           C  
ATOM    710  N   SER A 123      10.408  14.448  14.901  1.00 13.04           N  
ATOM    711  CA  SER A 123      10.902  14.673  13.552  1.00 11.42           C  
ATOM    712  C   SER A 123      11.295  16.123  13.373  1.00 10.04           C  
ATOM    713  O   SER A 123      10.495  17.018  13.635  1.00 10.53           O  
ATOM    714  CB  SER A 123       9.822  14.345  12.500  1.00 11.45           C  
ATOM    715  OG  SER A 123      10.280  14.732  11.206  1.00 10.95           O  
ATOM    716  N   ASP A 124      12.530  16.320  12.930  1.00  9.98           N  
ATOM    717  CA  ASP A 124      13.067  17.639  12.614  1.00 10.06           C  
ATOM    718  C   ASP A 124      13.494  17.596  11.135  1.00 11.38           C  
ATOM    719  O   ASP A 124      14.319  18.405  10.692  1.00 11.84           O  
ATOM    720  CB  ASP A 124      14.260  17.956  13.505  1.00  9.15           C  
ATOM    721  CG  ASP A 124      14.551  19.468  13.608  1.00 12.02           C  
ATOM    722  OD1 ASP A 124      13.609  20.286  13.446  1.00 11.44           O  
ATOM    723  OD2 ASP A 124      15.714  19.832  13.864  1.00 11.84           O  
ATOM    724  N   MET A 125      12.931  16.647  10.377  1.00 11.05           N  
ATOM    725  CA  MET A 125      13.250  16.542   8.953  1.00 13.70           C  
ATOM    726  C   MET A 125      12.795  17.781   8.172  1.00 12.74           C  
ATOM    727  O   MET A 125      11.697  18.306   8.392  1.00 13.64           O  
ATOM    728  CB  MET A 125      12.593  15.315   8.306  1.00 14.16           C  
ATOM    729  CG  MET A 125      13.141  13.979   8.747  1.00 14.46           C  
ATOM    730  SD  MET A 125      12.412  12.592   7.793  1.00 12.58           S  
ATOM    731  CE  MET A 125      10.702  12.708   8.397  1.00 10.89           C  
ATOM    732  N   ALA A 126      13.652  18.230   7.271  1.00 11.08           N  
ATOM    733  CA  ALA A 126      13.374  19.371   6.396  1.00 13.13           C  
ATOM    734  C   ALA A 126      14.140  19.037   5.125  1.00 13.83           C  
ATOM    735  O   ALA A 126      15.258  18.507   5.188  1.00 15.96           O  
ATOM    736  CB  ALA A 126      13.898  20.678   6.995  1.00 11.69           C  
ATOM    737  N   PRO A 127      13.558  19.343   3.957  1.00 14.31           N  
ATOM    738  CA  PRO A 127      14.213  19.058   2.675  1.00 15.46           C  
ATOM    739  C   PRO A 127      15.233  20.125   2.380  1.00 17.72           C  
ATOM    740  O   PRO A 127      15.313  21.120   3.095  1.00 15.00           O  
ATOM    741  CB  PRO A 127      13.062  19.151   1.672  1.00 16.86           C  
ATOM    742  CG  PRO A 127      12.265  20.318   2.247  1.00 15.53           C  
ATOM    743  CD  PRO A 127      12.244  19.977   3.753  1.00 15.77           C  
ATOM    744  N   ASN A 128      16.013  19.903   1.324  1.00 20.19           N  
ATOM    745  CA  ASN A 128      16.955  20.908   0.891  1.00 23.91           C  
ATOM    746  C   ASN A 128      15.988  21.945   0.346  1.00 23.15           C  
ATOM    747  O   ASN A 128      14.991  21.588  -0.272  1.00 22.74           O  
ATOM    748  CB  ASN A 128      17.860  20.357  -0.215  1.00 29.15           C  
ATOM    749  CG  ASN A 128      17.152  19.353  -1.106  1.00 34.35           C  
ATOM    750  OD1 ASN A 128      16.564  18.368  -0.628  1.00 39.51           O  
ATOM    751  ND2 ASN A 128      17.211  19.587  -2.410  1.00 37.16           N  
ATOM    752  N   MET A 129      16.256  23.218   0.596  1.00 22.58           N  
ATOM    753  CA  MET A 129      15.359  24.274   0.155  1.00 23.36           C  
ATOM    754  C   MET A 129      15.813  24.965  -1.137  1.00 23.89           C  
ATOM    755  O   MET A 129      16.981  25.334  -1.264  1.00 23.20           O  
ATOM    756  CB  MET A 129      15.250  25.324   1.253  1.00 23.53           C  
ATOM    757  CG  MET A 129      14.771  24.773   2.574  1.00 25.10           C  
ATOM    758  SD  MET A 129      13.077  24.170   2.434  1.00 24.51           S  
ATOM    759  CE  MET A 129      12.716  23.754   4.118  1.00 24.63           C  
ATOM    760  N   SER A 130      14.882  25.149  -2.074  1.00 22.44           N  
ATOM    761  CA  SER A 130      15.181  25.809  -3.335  1.00 21.93           C  
ATOM    762  C   SER A 130      15.009  27.308  -3.156  1.00 23.03           C  
ATOM    763  O   SER A 130      15.628  28.102  -3.884  1.00 24.38           O  
ATOM    764  CB  SER A 130      14.234  25.336  -4.439  1.00 21.94           C  
ATOM    765  OG  SER A 130      12.902  25.767  -4.182  1.00 19.05           O  
ATOM    766  N   GLY A 131      14.181  27.690  -2.186  1.00 20.62           N  
ATOM    767  CA  GLY A 131      13.909  29.090  -1.932  1.00 20.90           C  
ATOM    768  C   GLY A 131      12.540  29.472  -2.474  1.00 21.31           C  
ATOM    769  O   GLY A 131      12.052  30.576  -2.238  1.00 23.30           O  
ATOM    770  N   THR A 132      11.918  28.554  -3.207  1.00 18.60           N  
ATOM    771  CA  THR A 132      10.592  28.797  -3.785  1.00 17.25           C  
ATOM    772  C   THR A 132       9.513  28.019  -3.022  1.00 16.89           C  
ATOM    773  O   THR A 132       9.423  26.803  -3.117  1.00 14.75           O  
ATOM    774  CB  THR A 132      10.588  28.395  -5.258  1.00 18.09           C  
ATOM    775  OG1 THR A 132      11.498  29.239  -5.960  1.00 17.98           O  
ATOM    776  CG2 THR A 132       9.171  28.529  -5.870  1.00 16.54           C  
ATOM    777  N   PRO A 133       8.666  28.726  -2.263  1.00 15.84           N  
ATOM    778  CA  PRO A 133       7.601  28.098  -1.478  1.00 16.41           C  
ATOM    779  C   PRO A 133       6.773  27.023  -2.177  1.00 15.67           C  
ATOM    780  O   PRO A 133       6.581  25.928  -1.628  1.00 14.30           O  
ATOM    781  CB  PRO A 133       6.762  29.298  -1.025  1.00 17.67           C  
ATOM    782  CG  PRO A 133       7.839  30.371  -0.841  1.00 18.51           C  
ATOM    783  CD  PRO A 133       8.648  30.196  -2.117  1.00 15.89           C  
ATOM    784  N   ALA A 134       6.288  27.320  -3.389  1.00 14.04           N  
ATOM    785  CA  ALA A 134       5.463  26.364  -4.120  1.00 13.91           C  
ATOM    786  C   ALA A 134       6.205  25.069  -4.475  1.00 12.48           C  
ATOM    787  O   ALA A 134       5.581  24.107  -4.973  1.00 13.20           O  
ATOM    788  CB  ALA A 134       4.878  27.030  -5.403  1.00 16.01           C  
ATOM    789  N   VAL A 135       7.517  25.043  -4.238  1.00 11.14           N  
ATOM    790  CA  VAL A 135       8.305  23.830  -4.484  1.00 11.76           C  
ATOM    791  C   VAL A 135       8.743  23.243  -3.129  1.00 11.12           C  
ATOM    792  O   VAL A 135       8.560  22.050  -2.874  1.00 10.61           O  
ATOM    793  CB  VAL A 135       9.575  24.106  -5.345  1.00 11.82           C  
ATOM    794  CG1 VAL A 135      10.528  22.924  -5.270  1.00 13.22           C  
ATOM    795  CG2 VAL A 135       9.169  24.325  -6.840  1.00 11.90           C  
ATOM    796  N   ASP A 136       9.258  24.102  -2.256  1.00 10.65           N  
ATOM    797  CA  ASP A 136       9.754  23.656  -0.943  1.00 13.46           C  
ATOM    798  C   ASP A 136       8.678  23.118   0.003  1.00 11.41           C  
ATOM    799  O   ASP A 136       8.899  22.138   0.748  1.00 11.68           O  
ATOM    800  CB  ASP A 136      10.500  24.807  -0.268  1.00 14.61           C  
ATOM    801  CG  ASP A 136      11.767  25.231  -1.034  1.00 15.63           C  
ATOM    802  OD1 ASP A 136      12.235  24.487  -1.934  1.00 16.77           O  
ATOM    803  OD2 ASP A 136      12.301  26.307  -0.712  1.00 18.25           O  
ATOM    804  N   ILE A 137       7.505  23.741   0.004  1.00 11.53           N  
ATOM    805  CA  ILE A 137       6.456  23.276   0.892  1.00 12.37           C  
ATOM    806  C   ILE A 137       6.033  21.841   0.547  1.00 10.88           C  
ATOM    807  O   ILE A 137       5.901  20.994   1.442  1.00 12.22           O  
ATOM    808  CB  ILE A 137       5.294  24.301   0.869  1.00 13.76           C  
ATOM    809  CG1 ILE A 137       5.790  25.608   1.499  1.00 16.35           C  
ATOM    810  CG2 ILE A 137       4.078  23.794   1.589  1.00 15.15           C  
ATOM    811  CD1 ILE A 137       6.082  25.517   3.009  1.00 15.68           C  
ATOM    812  N   PRO A 138       5.809  21.533  -0.742  1.00 10.99           N  
ATOM    813  CA  PRO A 138       5.422  20.154  -1.062  1.00 10.15           C  
ATOM    814  C   PRO A 138       6.527  19.164  -0.668  1.00 12.03           C  
ATOM    815  O   PRO A 138       6.249  18.082  -0.130  1.00 12.61           O  
ATOM    816  CB  PRO A 138       5.208  20.185  -2.573  1.00 11.76           C  
ATOM    817  CG  PRO A 138       4.635  21.553  -2.790  1.00  8.48           C  
ATOM    818  CD  PRO A 138       5.493  22.441  -1.864  1.00 10.03           C  
ATOM    819  N   ARG A 139       7.770  19.525  -0.946  1.00 11.52           N  
ATOM    820  CA  ARG A 139       8.894  18.647  -0.583  1.00 13.15           C  
ATOM    821  C   ARG A 139       8.856  18.378   0.926  1.00 12.30           C  
ATOM    822  O   ARG A 139       8.971  17.225   1.366  1.00 13.33           O  
ATOM    823  CB  ARG A 139      10.250  19.304  -0.906  1.00 12.87           C  
ATOM    824  CG  ARG A 139      10.654  19.436  -2.367  1.00 14.13           C  
ATOM    825  CD  ARG A 139      12.037  20.133  -2.454  1.00 14.36           C  
ATOM    826  NE  ARG A 139      12.449  20.350  -3.845  1.00 11.93           N  
ATOM    827  CZ  ARG A 139      13.509  21.080  -4.196  1.00 12.02           C  
ATOM    828  NH1 ARG A 139      14.256  21.651  -3.255  1.00 13.81           N  
ATOM    829  NH2 ARG A 139      13.803  21.273  -5.479  1.00 13.25           N  
ATOM    830  N   ALA A 140       8.685  19.438   1.722  1.00 11.53           N  
ATOM    831  CA  ALA A 140       8.657  19.294   3.185  1.00 13.77           C  
ATOM    832  C   ALA A 140       7.434  18.529   3.662  1.00 14.10           C  
ATOM    833  O   ALA A 140       7.523  17.684   4.569  1.00 13.22           O  
ATOM    834  CB  ALA A 140       8.689  20.684   3.863  1.00 12.12           C  
ATOM    835  N   MET A 141       6.279  18.830   3.061  1.00 12.16           N  
ATOM    836  CA  MET A 141       5.058  18.168   3.462  1.00 12.96           C  
ATOM    837  C   MET A 141       5.094  16.667   3.227  1.00 11.76           C  
ATOM    838  O   MET A 141       4.538  15.917   4.012  1.00 13.52           O  
ATOM    839  CB  MET A 141       3.850  18.812   2.765  1.00 15.12           C  
ATOM    840  CG  MET A 141       3.422  20.148   3.416  1.00 18.87           C  
ATOM    841  SD  MET A 141       2.805  19.971   5.169  1.00 25.63           S  
ATOM    842  CE  MET A 141       2.093  18.219   5.018  1.00  6.61           C  
ATOM    843  N   TYR A 142       5.784  16.217   2.174  1.00 10.81           N  
ATOM    844  CA  TYR A 142       5.875  14.799   1.929  1.00 11.79           C  
ATOM    845  C   TYR A 142       6.612  14.136   3.106  1.00 12.57           C  
ATOM    846  O   TYR A 142       6.224  13.064   3.559  1.00 13.12           O  
ATOM    847  CB  TYR A 142       6.655  14.515   0.655  1.00 13.94           C  
ATOM    848  CG  TYR A 142       6.719  13.045   0.362  1.00 19.51           C  
ATOM    849  CD1 TYR A 142       5.542  12.308   0.208  1.00 23.26           C  
ATOM    850  CD2 TYR A 142       7.935  12.388   0.209  1.00 19.01           C  
ATOM    851  CE1 TYR A 142       5.576  10.951  -0.102  1.00 25.17           C  
ATOM    852  CE2 TYR A 142       7.979  11.022  -0.103  1.00 21.39           C  
ATOM    853  CZ  TYR A 142       6.791  10.318  -0.258  1.00 24.33           C  
ATOM    854  OH  TYR A 142       6.810   8.983  -0.581  1.00 26.03           O  
ATOM    855  N   LEU A 143       7.688  14.761   3.579  1.00 12.95           N  
ATOM    856  CA  LEU A 143       8.443  14.167   4.691  1.00 13.27           C  
ATOM    857  C   LEU A 143       7.616  14.111   5.965  1.00 13.27           C  
ATOM    858  O   LEU A 143       7.645  13.099   6.687  1.00 13.54           O  
ATOM    859  CB  LEU A 143       9.742  14.947   4.966  1.00 14.03           C  
ATOM    860  CG  LEU A 143      10.707  15.033   3.761  1.00 16.22           C  
ATOM    861  CD1 LEU A 143      11.863  15.990   4.083  1.00 16.05           C  
ATOM    862  CD2 LEU A 143      11.235  13.641   3.418  1.00 16.17           C  
ATOM    863  N   VAL A 144       6.852  15.155   6.263  1.00 12.35           N  
ATOM    864  CA  VAL A 144       6.092  15.057   7.500  1.00 13.47           C  
ATOM    865  C   VAL A 144       4.926  14.095   7.415  1.00 11.75           C  
ATOM    866  O   VAL A 144       4.526  13.537   8.436  1.00  9.46           O  
ATOM    867  CB  VAL A 144       5.650  16.407   8.025  1.00 14.93           C  
ATOM    868  CG1 VAL A 144       6.893  17.246   8.292  1.00 17.91           C  
ATOM    869  CG2 VAL A 144       4.711  17.079   7.061  1.00 16.04           C  
ATOM    870  N   GLU A 145       4.400  13.887   6.205  1.00 12.41           N  
ATOM    871  CA  GLU A 145       3.332  12.911   6.023  1.00 14.10           C  
ATOM    872  C   GLU A 145       3.945  11.530   6.258  1.00 12.99           C  
ATOM    873  O   GLU A 145       3.309  10.677   6.857  1.00 11.05           O  
ATOM    874  CB  GLU A 145       2.731  12.985   4.618  1.00 17.79           C  
ATOM    875  CG  GLU A 145       1.884  14.226   4.390  1.00 21.07           C  
ATOM    876  CD  GLU A 145       0.537  14.176   5.121  1.00 25.65           C  
ATOM    877  OE1 GLU A 145       0.279  13.190   5.856  1.00 26.23           O  
ATOM    878  OE2 GLU A 145      -0.262  15.128   4.965  1.00 24.34           O  
ATOM    879  N   LEU A 146       5.171  11.299   5.782  1.00 12.82           N  
ATOM    880  CA  LEU A 146       5.815  10.015   6.056  1.00 15.68           C  
ATOM    881  C   LEU A 146       6.055   9.842   7.575  1.00 14.37           C  
ATOM    882  O   LEU A 146       5.925   8.740   8.114  1.00 14.70           O  
ATOM    883  CB  LEU A 146       7.155   9.912   5.308  1.00 17.34           C  
ATOM    884  CG  LEU A 146       7.072   9.709   3.788  1.00 20.85           C  
ATOM    885  CD1 LEU A 146       8.489   9.711   3.200  1.00 21.15           C  
ATOM    886  CD2 LEU A 146       6.371   8.386   3.486  1.00 20.13           C  
ATOM    887  N   ALA A 147       6.412  10.914   8.274  1.00 11.82           N  
ATOM    888  CA  ALA A 147       6.625  10.818   9.736  1.00 12.30           C  
ATOM    889  C   ALA A 147       5.312  10.452  10.446  1.00 13.63           C  
ATOM    890  O   ALA A 147       5.289   9.643  11.398  1.00 13.75           O  
ATOM    891  CB  ALA A 147       7.126  12.137  10.260  1.00 10.21           C  
ATOM    892  N   LEU A 148       4.213  11.051   9.990  1.00 12.68           N  
ATOM    893  CA  LEU A 148       2.932  10.783  10.612  1.00 13.14           C  
ATOM    894  C   LEU A 148       2.528   9.334  10.329  1.00 13.08           C  
ATOM    895  O   LEU A 148       1.969   8.665  11.189  1.00 15.31           O  
ATOM    896  CB  LEU A 148       1.841  11.732  10.079  1.00 13.32           C  
ATOM    897  CG  LEU A 148       0.447  11.602  10.708  1.00 11.99           C  
ATOM    898  CD1 LEU A 148       0.523  11.725  12.258  1.00 15.55           C  
ATOM    899  CD2 LEU A 148      -0.462  12.669  10.110  1.00 14.05           C  
ATOM    900  N   GLU A 149       2.835   8.842   9.140  1.00 16.16           N  
ATOM    901  CA  GLU A 149       2.457   7.476   8.829  1.00 17.03           C  
ATOM    902  C   GLU A 149       3.228   6.547   9.752  1.00 18.38           C  
ATOM    903  O   GLU A 149       2.695   5.527  10.213  1.00 18.78           O  
ATOM    904  CB  GLU A 149       2.743   7.170   7.360  1.00 20.51           C  
ATOM    905  CG  GLU A 149       2.363   5.763   6.953  1.00 25.02           C  
ATOM    906  CD  GLU A 149       0.871   5.464   7.074  1.00 28.57           C  
ATOM    907  OE1 GLU A 149       0.526   4.265   6.995  1.00 31.85           O  
ATOM    908  OE2 GLU A 149       0.045   6.394   7.239  1.00 26.98           O  
ATOM    909  N   MET A 150       4.480   6.890  10.030  1.00 17.50           N  
ATOM    910  CA  MET A 150       5.258   6.060  10.925  1.00 17.61           C  
ATOM    911  C   MET A 150       4.640   6.084  12.323  1.00 19.77           C  
ATOM    912  O   MET A 150       4.666   5.079  13.043  1.00 18.40           O  
ATOM    913  CB  MET A 150       6.712   6.512  10.984  1.00 20.12           C  
ATOM    914  CG  MET A 150       7.510   5.637  11.940  1.00 21.40           C  
ATOM    915  SD  MET A 150       9.249   5.870  11.734  1.00 25.01           S  
ATOM    916  CE  MET A 150       9.866   4.340  12.413  1.00 22.95           C  
ATOM    917  N   CYS A 151       4.084   7.227  12.722  1.00 16.29           N  
ATOM    918  CA  CYS A 151       3.425   7.295  14.021  1.00 16.92           C  
ATOM    919  C   CYS A 151       2.282   6.278  14.046  1.00 17.01           C  
ATOM    920  O   CYS A 151       2.124   5.531  15.020  1.00 15.56           O  
ATOM    921  CB  CYS A 151       2.846   8.689  14.273  1.00 17.11           C  
ATOM    922  SG  CYS A 151       4.080   9.861  14.858  1.00 15.41           S  
ATOM    923  N   ARG A 152       1.474   6.252  12.976  1.00 15.81           N  
ATOM    924  CA  ARG A 152       0.359   5.311  12.905  1.00 18.50           C  
ATOM    925  C   ARG A 152       0.821   3.888  13.105  1.00 19.58           C  
ATOM    926  O   ARG A 152       0.152   3.109  13.776  1.00 21.71           O  
ATOM    927  CB  ARG A 152      -0.358   5.361  11.544  1.00 17.80           C  
ATOM    928  CG  ARG A 152      -1.074   6.646  11.263  1.00 21.47           C  
ATOM    929  CD  ARG A 152      -1.863   6.600   9.945  1.00 22.58           C  
ATOM    930  NE  ARG A 152      -2.511   7.890   9.750  1.00 23.90           N  
ATOM    931  CZ  ARG A 152      -2.059   8.849   8.947  1.00 25.23           C  
ATOM    932  NH1 ARG A 152      -0.952   8.668   8.225  1.00 22.92           N  
ATOM    933  NH2 ARG A 152      -2.694  10.013   8.910  1.00 25.44           N  
ATOM    934  N   ASP A 153       1.955   3.545  12.515  1.00 20.92           N  
ATOM    935  CA  ASP A 153       2.457   2.176  12.609  1.00 23.36           C  
ATOM    936  C   ASP A 153       3.235   1.813  13.867  1.00 23.23           C  
ATOM    937  O   ASP A 153       3.112   0.683  14.353  1.00 23.12           O  
ATOM    938  CB  ASP A 153       3.363   1.846  11.431  1.00 26.71           C  
ATOM    939  CG  ASP A 153       2.663   1.959  10.100  1.00 30.35           C  
ATOM    940  OD1 ASP A 153       1.418   1.803  10.074  1.00 31.81           O  
ATOM    941  OD2 ASP A 153       3.375   2.188   9.086  1.00 32.66           O  
ATOM    942  N   VAL A 154       4.044   2.736  14.388  1.00 19.45           N  
ATOM    943  CA  VAL A 154       4.852   2.376  15.551  1.00 18.23           C  
ATOM    944  C   VAL A 154       4.630   3.118  16.861  1.00 16.19           C  
ATOM    945  O   VAL A 154       5.041   2.624  17.907  1.00 14.76           O  
ATOM    946  CB  VAL A 154       6.383   2.424  15.225  1.00 20.66           C  
ATOM    947  CG1 VAL A 154       6.627   1.944  13.790  1.00 24.18           C  
ATOM    948  CG2 VAL A 154       6.952   3.805  15.433  1.00 22.11           C  
ATOM    949  N   LEU A 155       3.999   4.289  16.836  1.00 13.63           N  
ATOM    950  CA  LEU A 155       3.819   5.012  18.092  1.00 12.31           C  
ATOM    951  C   LEU A 155       2.780   4.310  18.972  1.00 12.42           C  
ATOM    952  O   LEU A 155       1.648   4.038  18.561  1.00 13.44           O  
ATOM    953  CB  LEU A 155       3.402   6.462  17.827  1.00 13.51           C  
ATOM    954  CG  LEU A 155       3.327   7.362  19.067  1.00 11.30           C  
ATOM    955  CD1 LEU A 155       4.713   7.462  19.745  1.00 10.57           C  
ATOM    956  CD2 LEU A 155       2.837   8.739  18.656  1.00 13.70           C  
ATOM    957  N   ALA A 156       3.158   4.022  20.207  1.00 13.25           N  
ATOM    958  CA  ALA A 156       2.225   3.348  21.100  1.00 12.80           C  
ATOM    959  C   ALA A 156       1.054   4.254  21.489  1.00 13.95           C  
ATOM    960  O   ALA A 156       1.156   5.496  21.450  1.00 13.17           O  
ATOM    961  CB  ALA A 156       2.967   2.902  22.390  1.00 14.49           C  
ATOM    962  N   PRO A 157      -0.078   3.643  21.855  1.00 15.96           N  
ATOM    963  CA  PRO A 157      -1.252   4.413  22.282  1.00 15.00           C  
ATOM    964  C   PRO A 157      -0.806   5.233  23.467  1.00 14.96           C  
ATOM    965  O   PRO A 157      -0.048   4.740  24.321  1.00 14.55           O  
ATOM    966  CB  PRO A 157      -2.241   3.329  22.705  1.00 16.00           C  
ATOM    967  CG  PRO A 157      -1.895   2.198  21.787  1.00 17.80           C  
ATOM    968  CD  PRO A 157      -0.382   2.197  21.801  1.00 15.78           C  
ATOM    969  N   GLY A 158      -1.267   6.475  23.532  1.00 15.03           N  
ATOM    970  CA  GLY A 158      -0.908   7.357  24.624  1.00 14.81           C  
ATOM    971  C   GLY A 158       0.406   8.099  24.398  1.00 14.04           C  
ATOM    972  O   GLY A 158       0.774   8.963  25.195  1.00 13.57           O  
ATOM    973  N   GLY A 159       1.115   7.755  23.317  1.00 12.15           N  
ATOM    974  CA  GLY A 159       2.393   8.389  22.996  1.00 13.49           C  
ATOM    975  C   GLY A 159       2.327   9.784  22.382  1.00 11.89           C  
ATOM    976  O   GLY A 159       1.240  10.310  22.126  1.00 11.53           O  
ATOM    977  N   SER A 160       3.495  10.365  22.117  1.00 12.21           N  
ATOM    978  CA  SER A 160       3.587  11.719  21.584  1.00 10.39           C  
ATOM    979  C   SER A 160       4.332  11.838  20.264  1.00 12.15           C  
ATOM    980  O   SER A 160       5.120  10.967  19.891  1.00 10.49           O  
ATOM    981  CB  SER A 160       4.283  12.631  22.621  1.00 10.63           C  
ATOM    982  OG  SER A 160       3.694  12.563  23.906  1.00 11.74           O  
ATOM    983  N   PHE A 161       4.102  12.958  19.577  1.00 10.61           N  
ATOM    984  CA  PHE A 161       4.730  13.235  18.294  1.00  9.57           C  
ATOM    985  C   PHE A 161       5.112  14.702  18.292  1.00  8.55           C  
ATOM    986  O   PHE A 161       4.282  15.539  18.634  1.00 10.85           O  
ATOM    987  CB  PHE A 161       3.707  12.958  17.186  1.00 11.22           C  
ATOM    988  CG  PHE A 161       4.189  13.230  15.772  1.00 12.03           C  
ATOM    989  CD1 PHE A 161       5.474  12.858  15.333  1.00 10.45           C  
ATOM    990  CD2 PHE A 161       3.278  13.734  14.832  1.00 11.27           C  
ATOM    991  CE1 PHE A 161       5.840  12.971  13.967  1.00 13.19           C  
ATOM    992  CE2 PHE A 161       3.618  13.855  13.484  1.00 12.24           C  
ATOM    993  CZ  PHE A 161       4.897  13.473  13.034  1.00 11.27           C  
ATOM    994  N   VAL A 162       6.353  15.010  17.935  1.00  8.89           N  
ATOM    995  CA  VAL A 162       6.785  16.429  17.825  1.00 11.21           C  
ATOM    996  C   VAL A 162       7.271  16.496  16.397  1.00 11.72           C  
ATOM    997  O   VAL A 162       8.091  15.670  16.003  1.00 11.64           O  
ATOM    998  CB  VAL A 162       8.028  16.785  18.624  1.00 15.80           C  
ATOM    999  CG1 VAL A 162       8.100  18.287  18.782  1.00 15.54           C  
ATOM   1000  CG2 VAL A 162       8.096  16.000  19.870  1.00 22.72           C  
ATOM   1001  N   VAL A 163       6.811  17.473  15.622  1.00 10.96           N  
ATOM   1002  CA  VAL A 163       7.249  17.528  14.242  1.00 11.93           C  
ATOM   1003  C   VAL A 163       7.427  18.962  13.729  1.00 10.85           C  
ATOM   1004  O   VAL A 163       6.624  19.854  14.011  1.00 10.98           O  
ATOM   1005  CB  VAL A 163       6.253  16.720  13.346  1.00 11.31           C  
ATOM   1006  CG1 VAL A 163       4.839  17.277  13.530  1.00 10.58           C  
ATOM   1007  CG2 VAL A 163       6.679  16.745  11.858  1.00 11.37           C  
ATOM   1008  N   LYS A 164       8.511  19.171  12.996  1.00  9.48           N  
ATOM   1009  CA  LYS A 164       8.803  20.479  12.401  1.00  9.70           C  
ATOM   1010  C   LYS A 164       7.923  20.582  11.156  1.00 10.83           C  
ATOM   1011  O   LYS A 164       8.007  19.718  10.273  1.00 10.55           O  
ATOM   1012  CB  LYS A 164      10.276  20.561  11.964  1.00 10.56           C  
ATOM   1013  CG  LYS A 164      10.654  21.956  11.415  1.00 10.84           C  
ATOM   1014  CD  LYS A 164      11.715  21.866  10.284  1.00 18.32           C  
ATOM   1015  CE  LYS A 164      13.157  21.620  10.748  1.00 19.60           C  
ATOM   1016  NZ  LYS A 164      13.771  22.761  11.480  1.00 16.00           N  
ATOM   1017  N   VAL A 165       7.097  21.627  11.077  1.00 11.01           N  
ATOM   1018  CA  VAL A 165       6.219  21.832   9.915  1.00 12.16           C  
ATOM   1019  C   VAL A 165       6.346  23.297   9.478  1.00 13.36           C  
ATOM   1020  O   VAL A 165       6.593  24.164  10.308  1.00 16.08           O  
ATOM   1021  CB  VAL A 165       4.731  21.564  10.297  1.00 13.14           C  
ATOM   1022  CG1 VAL A 165       3.843  21.612   9.057  1.00 14.30           C  
ATOM   1023  CG2 VAL A 165       4.601  20.189  10.961  1.00 13.02           C  
ATOM   1024  N   PHE A 166       6.175  23.586   8.195  1.00 14.19           N  
ATOM   1025  CA  PHE A 166       6.269  24.978   7.785  1.00 13.84           C  
ATOM   1026  C   PHE A 166       4.888  25.567   7.564  1.00 13.91           C  
ATOM   1027  O   PHE A 166       3.957  24.866   7.175  1.00 13.91           O  
ATOM   1028  CB  PHE A 166       7.084  25.120   6.512  1.00 16.91           C  
ATOM   1029  CG  PHE A 166       8.532  24.833   6.707  1.00 19.04           C  
ATOM   1030  CD1 PHE A 166       9.040  23.562   6.471  1.00 21.56           C  
ATOM   1031  CD2 PHE A 166       9.385  25.832   7.178  1.00 20.92           C  
ATOM   1032  CE1 PHE A 166      10.396  23.288   6.708  1.00 20.59           C  
ATOM   1033  CE2 PHE A 166      10.719  25.574   7.412  1.00 21.27           C  
ATOM   1034  CZ  PHE A 166      11.224  24.290   7.175  1.00 21.22           C  
ATOM   1035  N   GLN A 167       4.758  26.853   7.861  1.00 12.48           N  
ATOM   1036  CA  GLN A 167       3.498  27.569   7.651  1.00 12.54           C  
ATOM   1037  C   GLN A 167       3.203  27.600   6.170  1.00 14.22           C  
ATOM   1038  O   GLN A 167       4.123  27.607   5.353  1.00 15.27           O  
ATOM   1039  CB  GLN A 167       3.639  29.018   8.111  1.00 13.95           C  
ATOM   1040  CG  GLN A 167       3.764  29.221   9.613  1.00 16.10           C  
ATOM   1041  CD  GLN A 167       4.063  30.672   9.914  1.00 22.13           C  
ATOM   1042  OE1 GLN A 167       3.448  31.567   9.338  1.00 25.41           O  
ATOM   1043  NE2 GLN A 167       5.013  30.919  10.806  1.00 24.60           N  
ATOM   1044  N   GLY A 168       1.918  27.648   5.826  1.00 11.54           N  
ATOM   1045  CA  GLY A 168       1.544  27.743   4.433  1.00 11.22           C  
ATOM   1046  C   GLY A 168       0.740  26.579   3.909  1.00 11.42           C  
ATOM   1047  O   GLY A 168       0.030  25.906   4.663  1.00 11.87           O  
ATOM   1048  N   GLU A 169       0.867  26.320   2.613  1.00 10.60           N  
ATOM   1049  CA  GLU A 169       0.094  25.248   1.986  1.00 12.58           C  
ATOM   1050  C   GLU A 169       0.258  23.912   2.717  1.00 13.62           C  
ATOM   1051  O   GLU A 169       1.364  23.544   3.130  1.00 13.68           O  
ATOM   1052  CB  GLU A 169       0.495  25.140   0.502  1.00 13.63           C  
ATOM   1053  CG  GLU A 169      -0.188  24.038  -0.272  1.00 13.91           C  
ATOM   1054  CD  GLU A 169       0.307  23.952  -1.716  1.00 16.29           C  
ATOM   1055  OE1 GLU A 169       1.385  24.533  -2.054  1.00 13.79           O  
ATOM   1056  OE2 GLU A 169      -0.398  23.285  -2.499  1.00 17.29           O  
ATOM   1057  N   GLY A 170      -0.850  23.199   2.893  1.00 12.75           N  
ATOM   1058  CA  GLY A 170      -0.797  21.910   3.566  1.00 14.06           C  
ATOM   1059  C   GLY A 170      -0.785  21.905   5.085  1.00 11.95           C  
ATOM   1060  O   GLY A 170      -1.055  20.866   5.696  1.00 14.01           O  
ATOM   1061  N   PHE A 171      -0.502  23.046   5.709  1.00 11.17           N  
ATOM   1062  CA  PHE A 171      -0.456  23.135   7.187  1.00 13.14           C  
ATOM   1063  C   PHE A 171      -1.821  22.789   7.821  1.00 12.23           C  
ATOM   1064  O   PHE A 171      -1.925  21.955   8.720  1.00 11.11           O  
ATOM   1065  CB  PHE A 171      -0.032  24.565   7.620  1.00 13.12           C  
ATOM   1066  CG  PHE A 171       0.004  24.782   9.117  1.00 15.35           C  
ATOM   1067  CD1 PHE A 171       1.053  24.285   9.892  1.00 17.79           C  
ATOM   1068  CD2 PHE A 171      -1.014  25.483   9.758  1.00 16.13           C  
ATOM   1069  CE1 PHE A 171       1.088  24.486  11.279  1.00 16.81           C  
ATOM   1070  CE2 PHE A 171      -0.994  25.691  11.153  1.00 18.78           C  
ATOM   1071  CZ  PHE A 171       0.055  25.197  11.912  1.00 18.03           C  
ATOM   1072  N   ASP A 172      -2.879  23.424   7.345  1.00 12.20           N  
ATOM   1073  CA  ASP A 172      -4.197  23.168   7.886  1.00 13.98           C  
ATOM   1074  C   ASP A 172      -4.594  21.684   7.827  1.00 13.07           C  
ATOM   1075  O   ASP A 172      -5.091  21.123   8.809  1.00 13.93           O  
ATOM   1076  CB  ASP A 172      -5.238  24.001   7.113  1.00 14.03           C  
ATOM   1077  CG  ASP A 172      -6.648  23.855   7.688  1.00 15.30           C  
ATOM   1078  OD1 ASP A 172      -7.366  22.897   7.348  1.00 16.28           O  
ATOM   1079  OD2 ASP A 172      -7.017  24.704   8.511  1.00 19.03           O  
ATOM   1080  N   GLU A 173      -4.394  21.068   6.670  1.00 11.51           N  
ATOM   1081  CA  GLU A 173      -4.779  19.678   6.489  1.00 15.13           C  
ATOM   1082  C   GLU A 173      -3.933  18.764   7.365  1.00 13.15           C  
ATOM   1083  O   GLU A 173      -4.429  17.812   7.968  1.00 13.02           O  
ATOM   1084  CB  GLU A 173      -4.635  19.289   5.019  1.00 20.43           C  
ATOM   1085  CG  GLU A 173      -5.343  17.990   4.664  1.00 29.84           C  
ATOM   1086  CD  GLU A 173      -5.255  17.666   3.177  1.00 35.99           C  
ATOM   1087  OE1 GLU A 173      -4.123  17.476   2.659  1.00 39.52           O  
ATOM   1088  OE2 GLU A 173      -6.322  17.607   2.530  1.00 40.38           O  
ATOM   1089  N   TYR A 174      -2.650  19.059   7.451  1.00 11.51           N  
ATOM   1090  CA  TYR A 174      -1.777  18.214   8.273  1.00 12.70           C  
ATOM   1091  C   TYR A 174      -2.141  18.337   9.760  1.00 13.52           C  
ATOM   1092  O   TYR A 174      -2.155  17.339  10.484  1.00 13.32           O  
ATOM   1093  CB  TYR A 174      -0.329  18.603   8.019  1.00 13.14           C  
ATOM   1094  CG  TYR A 174       0.666  17.682   8.646  1.00 13.60           C  
ATOM   1095  CD1 TYR A 174       0.765  16.353   8.221  1.00 13.79           C  
ATOM   1096  CD2 TYR A 174       1.527  18.137   9.630  1.00 14.68           C  
ATOM   1097  CE1 TYR A 174       1.720  15.496   8.774  1.00 14.69           C  
ATOM   1098  CE2 TYR A 174       2.486  17.294  10.194  1.00 16.61           C  
ATOM   1099  CZ  TYR A 174       2.567  15.970   9.756  1.00 15.35           C  
ATOM   1100  OH  TYR A 174       3.484  15.117  10.340  1.00 14.52           O  
ATOM   1101  N   LEU A 175      -2.443  19.553  10.226  1.00 12.43           N  
ATOM   1102  CA  LEU A 175      -2.821  19.712  11.633  1.00 13.55           C  
ATOM   1103  C   LEU A 175      -4.112  18.912  11.872  1.00 14.97           C  
ATOM   1104  O   LEU A 175      -4.251  18.209  12.897  1.00 13.52           O  
ATOM   1105  CB  LEU A 175      -3.025  21.200  11.953  1.00 15.74           C  
ATOM   1106  CG  LEU A 175      -3.401  21.624  13.382  1.00 16.93           C  
ATOM   1107  CD1 LEU A 175      -2.331  21.159  14.369  1.00 14.34           C  
ATOM   1108  CD2 LEU A 175      -3.530  23.166  13.454  1.00 18.30           C  
ATOM   1109  N   ARG A 176      -5.047  18.976  10.916  1.00 15.24           N  
ATOM   1110  CA  ARG A 176      -6.287  18.216  11.055  1.00 17.03           C  
ATOM   1111  C   ARG A 176      -6.024  16.721  11.163  1.00 16.60           C  
ATOM   1112  O   ARG A 176      -6.628  16.050  12.008  1.00 16.23           O  
ATOM   1113  CB  ARG A 176      -7.251  18.499   9.884  1.00 19.73           C  
ATOM   1114  CG  ARG A 176      -7.927  19.864  10.023  1.00 25.05           C  
ATOM   1115  CD  ARG A 176      -9.030  20.126   8.988  1.00 30.87           C  
ATOM   1116  NE  ARG A 176      -8.521  20.252   7.623  1.00 34.45           N  
ATOM   1117  CZ  ARG A 176      -8.608  19.291   6.709  1.00 38.53           C  
ATOM   1118  NH1 ARG A 176      -9.188  18.130   7.019  1.00 40.24           N  
ATOM   1119  NH2 ARG A 176      -8.120  19.485   5.487  1.00 38.83           N  
ATOM   1120  N   GLU A 177      -5.096  16.213  10.348  1.00 15.84           N  
ATOM   1121  CA  GLU A 177      -4.776  14.782  10.364  1.00 16.85           C  
ATOM   1122  C   GLU A 177      -4.194  14.425  11.730  1.00 17.46           C  
ATOM   1123  O   GLU A 177      -4.567  13.393  12.336  1.00 16.93           O  
ATOM   1124  CB  GLU A 177      -3.790  14.429   9.227  1.00 19.77           C  
ATOM   1125  CG  GLU A 177      -4.400  14.682   7.813  1.00 26.15           C  
ATOM   1126  CD  GLU A 177      -3.406  14.610   6.645  1.00 31.02           C  
ATOM   1127  OE1 GLU A 177      -2.194  14.818   6.872  1.00 31.46           O  
ATOM   1128  OE2 GLU A 177      -3.852  14.369   5.486  1.00 32.13           O  
ATOM   1129  N   ILE A 178      -3.288  15.265  12.218  1.00 14.81           N  
ATOM   1130  CA  ILE A 178      -2.700  15.025  13.546  1.00 14.58           C  
ATOM   1131  C   ILE A 178      -3.783  15.106  14.633  1.00 15.98           C  
ATOM   1132  O   ILE A 178      -3.836  14.251  15.521  1.00 16.83           O  
ATOM   1133  CB  ILE A 178      -1.577  16.032  13.840  1.00 13.40           C  
ATOM   1134  CG1 ILE A 178      -0.402  15.737  12.894  1.00 13.13           C  
ATOM   1135  CG2 ILE A 178      -1.156  15.952  15.334  1.00 13.43           C  
ATOM   1136  CD1 ILE A 178       0.705  16.747  12.988  1.00 14.64           C  
ATOM   1137  N   ARG A 179      -4.676  16.089  14.568  1.00 16.57           N  
ATOM   1138  CA  ARG A 179      -5.721  16.164  15.597  1.00 20.54           C  
ATOM   1139  C   ARG A 179      -6.632  14.929  15.589  1.00 22.41           C  
ATOM   1140  O   ARG A 179      -7.197  14.562  16.622  1.00 22.63           O  
ATOM   1141  CB  ARG A 179      -6.581  17.425  15.449  1.00 21.81           C  
ATOM   1142  CG  ARG A 179      -5.892  18.731  15.868  1.00 24.29           C  
ATOM   1143  CD  ARG A 179      -6.906  19.866  15.836  1.00 27.98           C  
ATOM   1144  NE  ARG A 179      -6.315  21.203  15.876  1.00 32.32           N  
ATOM   1145  CZ  ARG A 179      -5.832  21.793  16.969  1.00 34.72           C  
ATOM   1146  NH1 ARG A 179      -5.850  21.179  18.157  1.00 33.19           N  
ATOM   1147  NH2 ARG A 179      -5.338  23.018  16.871  1.00 37.07           N  
ATOM   1148  N   SER A 180      -6.783  14.276  14.445  1.00 21.71           N  
ATOM   1149  CA  SER A 180      -7.634  13.095  14.431  1.00 24.52           C  
ATOM   1150  C   SER A 180      -6.934  11.876  15.044  1.00 24.45           C  
ATOM   1151  O   SER A 180      -7.591  10.914  15.434  1.00 26.13           O  
ATOM   1152  CB  SER A 180      -8.091  12.773  13.008  1.00 25.58           C  
ATOM   1153  OG  SER A 180      -7.061  12.136  12.290  1.00 30.85           O  
ATOM   1154  N   LEU A 181      -5.606  11.910  15.142  1.00 22.78           N  
ATOM   1155  CA  LEU A 181      -4.862  10.781  15.706  1.00 20.91           C  
ATOM   1156  C   LEU A 181      -4.412  10.976  17.158  1.00 20.30           C  
ATOM   1157  O   LEU A 181      -3.993  10.015  17.812  1.00 20.72           O  
ATOM   1158  CB  LEU A 181      -3.647  10.479  14.818  1.00 21.80           C  
ATOM   1159  CG  LEU A 181      -2.690   9.358  15.238  1.00 25.25           C  
ATOM   1160  CD1 LEU A 181      -3.437   8.013  15.359  1.00 26.68           C  
ATOM   1161  CD2 LEU A 181      -1.575   9.233  14.199  1.00 26.57           C  
ATOM   1162  N   PHE A 182      -4.510  12.202  17.673  1.00 17.52           N  
ATOM   1163  CA  PHE A 182      -4.077  12.500  19.042  1.00 16.76           C  
ATOM   1164  C   PHE A 182      -5.108  13.257  19.873  1.00 18.20           C  
ATOM   1165  O   PHE A 182      -5.967  13.961  19.346  1.00 21.50           O  
ATOM   1166  CB  PHE A 182      -2.781  13.329  19.035  1.00 14.07           C  
ATOM   1167  CG  PHE A 182      -1.603  12.621  18.413  1.00 15.06           C  
ATOM   1168  CD1 PHE A 182      -1.483  12.513  17.033  1.00 15.57           C  
ATOM   1169  CD2 PHE A 182      -0.608  12.068  19.223  1.00 13.65           C  
ATOM   1170  CE1 PHE A 182      -0.383  11.855  16.450  1.00 15.12           C  
ATOM   1171  CE2 PHE A 182       0.495  11.405  18.646  1.00 12.21           C  
ATOM   1172  CZ  PHE A 182       0.600  11.302  17.260  1.00 15.24           C  
ATOM   1173  N   THR A 183      -4.978  13.140  21.181  1.00 15.70           N  
ATOM   1174  CA  THR A 183      -5.895  13.794  22.119  1.00 17.80           C  
ATOM   1175  C   THR A 183      -5.693  15.308  22.259  1.00 18.33           C  
ATOM   1176  O   THR A 183      -6.659  16.079  22.266  1.00 18.07           O  
ATOM   1177  CB  THR A 183      -5.770  13.121  23.495  1.00 18.83           C  
ATOM   1178  OG1 THR A 183      -6.113  11.736  23.340  1.00 22.04           O  
ATOM   1179  CG2 THR A 183      -6.713  13.772  24.528  1.00 21.27           C  
ATOM   1180  N   LYS A 184      -4.445  15.728  22.382  1.00 16.42           N  
ATOM   1181  CA  LYS A 184      -4.132  17.146  22.539  1.00 17.39           C  
ATOM   1182  C   LYS A 184      -3.091  17.566  21.509  1.00 17.83           C  
ATOM   1183  O   LYS A 184      -2.107  16.862  21.300  1.00 16.37           O  
ATOM   1184  CB  LYS A 184      -3.591  17.400  23.946  1.00 18.47           C  
ATOM   1185  CG  LYS A 184      -3.242  18.868  24.217  1.00 24.17           C  
ATOM   1186  CD  LYS A 184      -2.475  19.049  25.543  1.00 27.80           C  
ATOM   1187  CE  LYS A 184      -1.909  20.472  25.645  1.00 31.05           C  
ATOM   1188  NZ  LYS A 184      -0.891  20.646  26.742  1.00 34.66           N  
ATOM   1189  N   VAL A 185      -3.304  18.700  20.851  1.00 16.71           N  
ATOM   1190  CA  VAL A 185      -2.336  19.149  19.866  1.00 15.63           C  
ATOM   1191  C   VAL A 185      -2.059  20.642  20.045  1.00 16.74           C  
ATOM   1192  O   VAL A 185      -2.988  21.452  20.093  1.00 17.81           O  
ATOM   1193  CB  VAL A 185      -2.846  18.892  18.418  1.00 15.56           C  
ATOM   1194  CG1 VAL A 185      -1.791  19.303  17.425  1.00 15.12           C  
ATOM   1195  CG2 VAL A 185      -3.192  17.405  18.219  1.00 16.81           C  
ATOM   1196  N   LYS A 186      -0.786  20.996  20.153  1.00 13.12           N  
ATOM   1197  CA  LYS A 186      -0.384  22.394  20.307  1.00 15.36           C  
ATOM   1198  C   LYS A 186       0.587  22.772  19.208  1.00 15.28           C  
ATOM   1199  O   LYS A 186       1.357  21.931  18.729  1.00 14.16           O  
ATOM   1200  CB  LYS A 186       0.314  22.615  21.657  1.00 17.99           C  
ATOM   1201  CG  LYS A 186      -0.563  22.496  22.884  1.00 22.74           C  
ATOM   1202  CD  LYS A 186      -1.655  23.555  22.834  1.00 29.87           C  
ATOM   1203  CE  LYS A 186      -2.360  23.730  24.181  1.00 33.95           C  
ATOM   1204  NZ  LYS A 186      -3.406  24.813  24.090  1.00 35.26           N  
ATOM   1205  N   VAL A 187       0.562  24.039  18.799  1.00 13.95           N  
ATOM   1206  CA  VAL A 187       1.494  24.518  17.786  1.00 15.70           C  
ATOM   1207  C   VAL A 187       2.468  25.434  18.522  1.00 16.21           C  
ATOM   1208  O   VAL A 187       2.082  26.476  19.043  1.00 13.74           O  
ATOM   1209  CB  VAL A 187       0.759  25.302  16.680  1.00 16.74           C  
ATOM   1210  CG1 VAL A 187       1.768  25.835  15.683  1.00 18.62           C  
ATOM   1211  CG2 VAL A 187      -0.265  24.381  15.982  1.00 17.09           C  
ATOM   1212  N   ARG A 188       3.734  25.042  18.549  1.00 15.49           N  
ATOM   1213  CA  ARG A 188       4.749  25.791  19.252  1.00 15.68           C  
ATOM   1214  C   ARG A 188       5.715  26.508  18.343  1.00 15.21           C  
ATOM   1215  O   ARG A 188       6.075  26.007  17.285  1.00 14.61           O  
ATOM   1216  CB  ARG A 188       5.567  24.857  20.142  1.00 13.54           C  
ATOM   1217  CG  ARG A 188       4.772  24.025  21.120  1.00 12.96           C  
ATOM   1218  CD  ARG A 188       3.953  24.904  22.057  1.00 15.58           C  
ATOM   1219  NE  ARG A 188       3.482  24.160  23.225  1.00 16.41           N  
ATOM   1220  CZ  ARG A 188       2.579  24.630  24.077  1.00 19.22           C  
ATOM   1221  NH1 ARG A 188       2.055  25.833  23.882  1.00 19.17           N  
ATOM   1222  NH2 ARG A 188       2.195  23.900  25.119  1.00 17.52           N  
ATOM   1223  N   LYS A 189       6.149  27.684  18.784  1.00 15.00           N  
ATOM   1224  CA  LYS A 189       7.153  28.465  18.067  1.00 17.74           C  
ATOM   1225  C   LYS A 189       8.232  28.736  19.130  1.00 18.76           C  
ATOM   1226  O   LYS A 189       8.177  29.729  19.878  1.00 19.28           O  
ATOM   1227  CB  LYS A 189       6.549  29.780  17.536  1.00 21.08           C  
ATOM   1228  CG  LYS A 189       7.560  30.712  16.886  1.00 23.18           C  
ATOM   1229  CD  LYS A 189       8.306  30.016  15.749  1.00 24.45           C  
ATOM   1230  CE  LYS A 189       9.165  30.995  14.951  1.00 23.80           C  
ATOM   1231  NZ  LYS A 189       9.781  30.307  13.748  1.00 23.79           N  
ATOM   1232  N   PRO A 190       9.200  27.821  19.254  1.00 17.66           N  
ATOM   1233  CA  PRO A 190      10.268  27.995  20.246  1.00 20.35           C  
ATOM   1234  C   PRO A 190      10.956  29.346  20.154  1.00 19.99           C  
ATOM   1235  O   PRO A 190      11.184  29.842  19.054  1.00 19.18           O  
ATOM   1236  CB  PRO A 190      11.229  26.858  19.921  1.00 18.42           C  
ATOM   1237  CG  PRO A 190      10.329  25.764  19.461  1.00 18.41           C  
ATOM   1238  CD  PRO A 190       9.306  26.512  18.577  1.00 17.75           C  
ATOM   1239  N   ASP A 191      11.289  29.941  21.302  1.00 23.31           N  
ATOM   1240  CA  ASP A 191      11.991  31.222  21.282  1.00 24.73           C  
ATOM   1241  C   ASP A 191      13.290  31.069  20.484  1.00 24.48           C  
ATOM   1242  O   ASP A 191      13.726  32.001  19.813  1.00 24.72           O  
ATOM   1243  CB  ASP A 191      12.344  31.699  22.702  1.00 28.18           C  
ATOM   1244  CG  ASP A 191      11.122  31.917  23.577  1.00 31.94           C  
ATOM   1245  OD1 ASP A 191      10.074  32.335  23.035  1.00 34.45           O  
ATOM   1246  OD2 ASP A 191      11.220  31.676  24.805  1.00 34.13           O  
ATOM   1247  N   SER A 192      13.900  29.883  20.544  1.00 23.32           N  
ATOM   1248  CA  SER A 192      15.151  29.640  19.837  1.00 23.41           C  
ATOM   1249  C   SER A 192      14.964  29.445  18.345  1.00 24.24           C  
ATOM   1250  O   SER A 192      15.936  29.355  17.593  1.00 23.73           O  
ATOM   1251  CB  SER A 192      15.869  28.422  20.423  1.00 24.77           C  
ATOM   1252  OG  SER A 192      16.291  28.703  21.750  1.00 26.56           O  
ATOM   1253  N   SER A 193      13.706  29.372  17.927  1.00 23.92           N  
ATOM   1254  CA  SER A 193      13.376  29.219  16.524  1.00 26.33           C  
ATOM   1255  C   SER A 193      13.411  30.648  15.947  1.00 29.30           C  
ATOM   1256  O   SER A 193      12.758  31.543  16.477  1.00 29.08           O  
ATOM   1257  CB  SER A 193      11.972  28.601  16.419  1.00 27.41           C  
ATOM   1258  OG  SER A 193      11.602  28.340  15.090  1.00 27.58           O  
ATOM   1259  N   ARG A 194      14.191  30.869  14.889  1.00 30.04           N  
ATOM   1260  CA  ARG A 194      14.286  32.198  14.280  1.00 32.30           C  
ATOM   1261  C   ARG A 194      12.916  32.743  13.896  1.00 32.86           C  
ATOM   1262  O   ARG A 194      12.156  32.099  13.163  1.00 32.84           O  
ATOM   1263  CB  ARG A 194      15.178  32.147  13.041  1.00 33.16           C  
ATOM   1264  CG  ARG A 194      16.593  31.699  13.329  1.00 35.75           C  
ATOM   1265  CD  ARG A 194      17.440  31.649  12.063  1.00 37.36           C  
ATOM   1266  NE  ARG A 194      17.013  30.602  11.137  1.00 39.94           N  
ATOM   1267  CZ  ARG A 194      16.191  30.784  10.104  1.00 41.53           C  
ATOM   1268  NH1 ARG A 194      15.690  31.991   9.839  1.00 40.90           N  
ATOM   1269  NH2 ARG A 194      15.869  29.751   9.330  1.00 41.69           N  
ATOM   1270  N   ALA A 195      12.597  33.931  14.405  1.00 34.50           N  
ATOM   1271  CA  ALA A 195      11.312  34.560  14.105  1.00 35.42           C  
ATOM   1272  C   ALA A 195      11.140  34.682  12.586  1.00 35.28           C  
ATOM   1273  O   ALA A 195      10.019  34.644  12.074  1.00 35.44           O  
ATOM   1274  CB  ALA A 195      11.233  35.937  14.770  1.00 36.13           C  
ATOM   1275  N   ARG A 196      12.259  34.805  11.875  1.00 35.08           N  
ATOM   1276  CA  ARG A 196      12.252  34.907  10.416  1.00 35.62           C  
ATOM   1277  C   ARG A 196      11.882  33.584   9.734  1.00 34.22           C  
ATOM   1278  O   ARG A 196      11.401  33.577   8.595  1.00 33.72           O  
ATOM   1279  CB  ARG A 196      13.624  35.374   9.918  1.00 39.93           C  
ATOM   1280  CG  ARG A 196      13.821  35.295   8.403  1.00 44.17           C  
ATOM   1281  CD  ARG A 196      14.217  33.885   7.955  1.00 48.06           C  
ATOM   1282  NE  ARG A 196      13.599  33.511   6.679  1.00 50.40           N  
ATOM   1283  CZ  ARG A 196      13.575  32.272   6.191  1.00 51.41           C  
ATOM   1284  NH1 ARG A 196      14.136  31.274   6.871  1.00 50.81           N  
ATOM   1285  NH2 ARG A 196      12.983  32.028   5.024  1.00 52.04           N  
ATOM   1286  N   SER A 197      12.113  32.463  10.414  1.00 29.89           N  
ATOM   1287  CA  SER A 197      11.786  31.172   9.821  1.00 26.12           C  
ATOM   1288  C   SER A 197      10.294  30.892   9.916  1.00 24.28           C  
ATOM   1289  O   SER A 197       9.647  31.265  10.892  1.00 23.76           O  
ATOM   1290  CB  SER A 197      12.548  30.050  10.516  1.00 27.92           C  
ATOM   1291  OG  SER A 197      11.936  28.809  10.235  1.00 25.28           O  
ATOM   1292  N   ARG A 198       9.762  30.253   8.882  1.00 21.33           N  
ATOM   1293  CA  ARG A 198       8.347  29.901   8.814  1.00 21.38           C  
ATOM   1294  C   ARG A 198       8.043  28.581   9.529  1.00 18.82           C  
ATOM   1295  O   ARG A 198       6.926  28.070   9.478  1.00 16.61           O  
ATOM   1296  CB  ARG A 198       7.911  29.791   7.354  1.00 25.23           C  
ATOM   1297  CG  ARG A 198       7.800  31.120   6.626  1.00 27.62           C  
ATOM   1298  CD  ARG A 198       6.572  31.886   7.091  1.00 31.36           C  
ATOM   1299  NE  ARG A 198       6.347  33.086   6.285  1.00 35.47           N  
ATOM   1300  CZ  ARG A 198       5.321  33.914   6.447  1.00 36.45           C  
ATOM   1301  NH1 ARG A 198       4.416  33.674   7.393  1.00 37.64           N  
ATOM   1302  NH2 ARG A 198       5.196  34.978   5.656  1.00 36.56           N  
ATOM   1303  N   GLU A 199       9.036  28.027  10.203  1.00 17.69           N  
ATOM   1304  CA  GLU A 199       8.796  26.771  10.901  1.00 15.41           C  
ATOM   1305  C   GLU A 199       7.993  26.925  12.189  1.00 15.22           C  
ATOM   1306  O   GLU A 199       8.002  27.966  12.846  1.00 17.35           O  
ATOM   1307  CB  GLU A 199      10.138  26.103  11.258  1.00 17.30           C  
ATOM   1308  CG  GLU A 199      10.768  26.629  12.559  1.00 18.87           C  
ATOM   1309  CD  GLU A 199      12.149  26.063  12.828  1.00 19.06           C  
ATOM   1310  OE1 GLU A 199      12.777  26.494  13.819  1.00 16.25           O  
ATOM   1311  OE2 GLU A 199      12.611  25.188  12.046  1.00 20.25           O  
ATOM   1312  N   VAL A 200       7.281  25.866  12.544  1.00 13.64           N  
ATOM   1313  CA  VAL A 200       6.611  25.797  13.837  1.00 12.14           C  
ATOM   1314  C   VAL A 200       6.790  24.334  14.189  1.00 11.02           C  
ATOM   1315  O   VAL A 200       7.210  23.527  13.331  1.00 11.30           O  
ATOM   1316  CB  VAL A 200       5.096  26.076  13.802  1.00 12.50           C  
ATOM   1317  CG1 VAL A 200       4.840  27.498  13.356  1.00 15.21           C  
ATOM   1318  CG2 VAL A 200       4.399  25.084  12.898  1.00 12.39           C  
ATOM   1319  N   TYR A 201       6.513  24.000  15.440  1.00 12.60           N  
ATOM   1320  CA  TYR A 201       6.596  22.611  15.862  1.00 12.19           C  
ATOM   1321  C   TYR A 201       5.251  22.165  16.372  1.00 12.60           C  
ATOM   1322  O   TYR A 201       4.729  22.719  17.344  1.00 12.19           O  
ATOM   1323  CB  TYR A 201       7.654  22.427  16.949  1.00 11.89           C  
ATOM   1324  CG  TYR A 201       9.046  22.499  16.363  1.00 11.60           C  
ATOM   1325  CD1 TYR A 201       9.695  23.731  16.177  1.00 11.56           C  
ATOM   1326  CD2 TYR A 201       9.681  21.335  15.909  1.00  9.78           C  
ATOM   1327  CE1 TYR A 201      10.951  23.795  15.549  1.00 11.52           C  
ATOM   1328  CE2 TYR A 201      10.913  21.380  15.297  1.00 12.02           C  
ATOM   1329  CZ  TYR A 201      11.554  22.607  15.110  1.00 13.14           C  
ATOM   1330  OH  TYR A 201      12.789  22.613  14.502  1.00 14.65           O  
ATOM   1331  N   ILE A 202       4.681  21.159  15.714  1.00 12.68           N  
ATOM   1332  CA  ILE A 202       3.397  20.646  16.168  1.00 11.33           C  
ATOM   1333  C   ILE A 202       3.731  19.613  17.238  1.00 12.34           C  
ATOM   1334  O   ILE A 202       4.554  18.733  17.023  1.00 11.89           O  
ATOM   1335  CB  ILE A 202       2.602  20.032  15.016  1.00 12.48           C  
ATOM   1336  CG1 ILE A 202       2.253  21.131  14.016  1.00 14.43           C  
ATOM   1337  CG2 ILE A 202       1.340  19.398  15.548  1.00 11.47           C  
ATOM   1338  CD1 ILE A 202       1.564  20.637  12.776  1.00 14.12           C  
ATOM   1339  N   VAL A 203       3.140  19.788  18.404  1.00 11.11           N  
ATOM   1340  CA  VAL A 203       3.381  18.910  19.543  1.00 11.30           C  
ATOM   1341  C   VAL A 203       2.064  18.217  19.875  1.00 11.76           C  
ATOM   1342  O   VAL A 203       1.125  18.826  20.403  1.00 10.79           O  
ATOM   1343  CB  VAL A 203       3.896  19.718  20.739  1.00 11.67           C  
ATOM   1344  CG1 VAL A 203       4.066  18.783  21.951  1.00 11.70           C  
ATOM   1345  CG2 VAL A 203       5.238  20.384  20.387  1.00 11.21           C  
ATOM   1346  N   ALA A 204       2.001  16.929  19.557  1.00 11.42           N  
ATOM   1347  CA  ALA A 204       0.787  16.148  19.759  1.00 12.03           C  
ATOM   1348  C   ALA A 204       0.983  15.090  20.848  1.00 11.43           C  
ATOM   1349  O   ALA A 204       2.000  14.385  20.850  1.00 13.10           O  
ATOM   1350  CB  ALA A 204       0.388  15.475  18.441  1.00 12.68           C  
ATOM   1351  N   THR A 205       0.033  15.004  21.771  1.00 12.82           N  
ATOM   1352  CA  THR A 205       0.126  14.028  22.865  1.00 12.60           C  
ATOM   1353  C   THR A 205      -1.118  13.155  22.950  1.00 14.76           C  
ATOM   1354  O   THR A 205      -2.169  13.496  22.412  1.00 13.94           O  
ATOM   1355  CB  THR A 205       0.329  14.732  24.220  1.00 14.57           C  
ATOM   1356  OG1 THR A 205      -0.732  15.680  24.407  1.00 15.19           O  
ATOM   1357  CG2 THR A 205       1.700  15.479  24.266  1.00 12.31           C  
ATOM   1358  N   GLY A 206      -1.006  12.026  23.646  1.00 12.19           N  
ATOM   1359  CA  GLY A 206      -2.142  11.124  23.764  1.00 15.10           C  
ATOM   1360  C   GLY A 206      -2.574  10.431  22.476  1.00 14.09           C  
ATOM   1361  O   GLY A 206      -3.737  10.524  22.082  1.00 16.45           O  
ATOM   1362  N   ARG A 207      -1.652   9.731  21.817  1.00 11.74           N  
ATOM   1363  CA  ARG A 207      -1.996   9.040  20.584  1.00 14.68           C  
ATOM   1364  C   ARG A 207      -3.234   8.195  20.873  1.00 14.90           C  
ATOM   1365  O   ARG A 207      -3.264   7.421  21.833  1.00 13.67           O  
ATOM   1366  CB  ARG A 207      -0.844   8.147  20.122  1.00 14.07           C  
ATOM   1367  CG  ARG A 207      -1.062   7.543  18.739  1.00 19.49           C  
ATOM   1368  CD  ARG A 207      -1.502   6.071  18.841  1.00 24.14           C  
ATOM   1369  NE  ARG A 207      -2.158   5.587  17.631  1.00 29.96           N  
ATOM   1370  CZ  ARG A 207      -1.554   4.983  16.609  1.00 31.69           C  
ATOM   1371  NH1 ARG A 207      -0.244   4.760  16.622  1.00 31.34           N  
ATOM   1372  NH2 ARG A 207      -2.273   4.609  15.556  1.00 32.95           N  
ATOM   1373  N   LYS A 208      -4.250   8.341  20.042  1.00 14.57           N  
ATOM   1374  CA  LYS A 208      -5.501   7.629  20.274  1.00 17.85           C  
ATOM   1375  C   LYS A 208      -5.428   6.137  20.033  1.00 20.40           C  
ATOM   1376  O   LYS A 208      -4.589   5.657  19.252  1.00 20.63           O  
ATOM   1377  CB  LYS A 208      -6.607   8.258  19.421  1.00 18.62           C  
ATOM   1378  CG  LYS A 208      -6.917   9.691  19.861  1.00 19.26           C  
ATOM   1379  CD  LYS A 208      -7.861  10.366  18.879  1.00 22.36           C  
ATOM   1380  CE  LYS A 208      -8.172  11.786  19.309  1.00 25.30           C  
ATOM   1381  NZ  LYS A 208      -8.830  12.549  18.189  1.00 27.28           N  
ATOM   1382  N   PRO A 209      -6.316   5.380  20.701  1.00 21.58           N  
ATOM   1383  CA  PRO A 209      -6.338   3.924  20.545  1.00 23.76           C  
ATOM   1384  C   PRO A 209      -6.620   3.500  19.112  1.00 24.78           C  
ATOM   1385  O   PRO A 209      -7.291   4.242  18.346  1.00 22.82           O  
ATOM   1386  CB  PRO A 209      -7.447   3.478  21.510  1.00 22.95           C  
ATOM   1387  CG  PRO A 209      -7.527   4.604  22.526  1.00 26.13           C  
ATOM   1388  CD  PRO A 209      -7.330   5.830  21.673  1.00 21.78           C  
ATOM   1389  OXT PRO A 209      -6.196   2.383  18.782  1.00 28.09           O  
TER    1390      PRO A 209                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
