
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  182 ( 1472),  selected  182 , name 2plw_A
# Molecule2: number of CA atoms  174 ( 1400),  selected  174 , name T0508.pdb
# PARAMETERS: 2plw_A.T0508.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     2_A      Q      17          2.659
LGA    R     3_A      L      18          5.144
LGA    S     4_A      R      19          5.504
LGA    R     5_A      S      20          1.165
LGA    -       -      R      21           -
LGA    A     6_A      A      22          1.017
LGA    A     7_A      A      23          0.743
LGA    Y     8_A      F      24          0.601
LGA    K     9_A      K      25          0.754
LGA    L    10_A      L      26          0.837
LGA    I    11_A      E      27          0.503
LGA    E    12_A      F      28          0.404
LGA    L    13_A      L      29          0.568
LGA    D    14_A      L      30          0.488
LGA    N    15_A      D      31          0.157
LGA    K    16_A      R      32          0.480
LGA    Y    17_A      Y      33          0.767
LGA    L    18_A      R      34          1.406
LGA    F    19_A      V      35          3.255
LGA    L    20_A      V      36          3.124
LGA    K    21_A      R      37          2.532
LGA    K    22_A      K      38          3.425
LGA    N    23_A      G      39          3.285
LGA    K    24_A      D      40          1.924
LGA    I    25_A      A      41          1.064
LGA    I    26_A      V      42          1.461
LGA    L    27_A      I      43          1.783
LGA    D    28_A      E      44          1.474
LGA    I    29_A      I      45          1.192
LGA    G    30_A      G      46          0.697
LGA    C    31_A      S      47          0.799
LGA    Y    32_A      S      48          0.665
LGA    P    33_A      P      49          0.883
LGA    G    34_A      G      50          0.936
LGA    S    35_A      G      51          1.463
LGA    W    36_A      W      52          1.133
LGA    C    37_A      T      53          1.407
LGA    Q    38_A      Q      54          1.054
LGA    V    39_A      V      55          0.868
LGA    I    40_A      L      56          1.423
LGA    L    41_A      N      57          2.062
LGA    E    42_A      S      58          2.199
LGA    R    43_A      L      59          3.432
LGA    T    44_A      A      60          5.005
LGA    K    45_A      -       -           -
LGA    N    46_A      -       -           -
LGA    Y    47_A      -       -           -
LGA    K    48_A      -       -           -
LGA    N    49_A      R      61          1.275
LGA    K    50_A      K      62          1.428
LGA    I    51_A      I      63          1.891
LGA    I    52_A      I      64          1.803
LGA    G    53_A      S      65          1.148
LGA    I    54_A      I      66          1.154
LGA    D    55_A      D      67          1.021
LGA    K    56_A      L      68          1.224
LGA    K    57_A      Q      69          0.947
LGA    I    58_A      E      70          1.272
LGA    M    59_A      M      71          1.369
LGA    D    60_A      E      72          0.871
LGA    P    61_A      E      73          0.487
LGA    I    62_A      I      74          0.410
LGA    P    63_A      A      75          0.926
LGA    N    64_A      G      76          1.811
LGA    V    65_A      V      77          1.335
LGA    Y    66_A      R      78          1.354
LGA    F    67_A      F      79          1.083
LGA    I    68_A      I      80          1.247
LGA    Q    69_A      R      81          1.239
LGA    G    70_A      C      82          1.072
LGA    E    71_A      D      83          1.647
LGA    I    72_A      I      84          1.420
LGA    G    73_A      F      85          2.056
LGA    K    74_A      K      86          1.556
LGA    D    75_A      E      87          4.520
LGA    N    76_A      T      88          3.960
LGA    M    77_A      I      89          4.913
LGA    N    78_A      F      90           #
LGA    N    79_A      -       -           -
LGA    I    80_A      -       -           -
LGA    N    92_A      D      91          3.144
LGA    S    93_A      D      92          3.396
LGA    V    94_A      I      93          3.990
LGA    D    95_A      D      94          3.445
LGA    Y    96_A      R      95          2.750
LGA    K    97_A      A      96          3.335
LGA    L    98_A      L      97          3.641
LGA    K    99_A      R      98          3.146
LGA    E   100_A      E      99          2.652
LGA    I   101_A      E     100          2.832
LGA    L   102_A      G     101          4.073
LGA    Q   103_A      -       -           -
LGA    D   104_A      I     102           #
LGA    K   105_A      E     103          1.125
LGA    K   106_A      K     104          0.668
LGA    I   107_A      V     105          0.623
LGA    D   108_A      D     106          0.223
LGA    I   109_A      D     107          1.140
LGA    I   110_A      V     108          1.044
LGA    L   111_A      V     109          0.761
LGA    S   112_A      S     110          0.541
LGA    D   113_A      D     111          0.748
LGA    A   114_A      A     112          0.696
LGA    A   115_A      M     113          0.848
LGA    V   116_A      A     114          1.805
LGA    P   117_A      K     115          1.181
LGA    C   118_A      V     116          1.966
LGA    I   119_A      S     117          3.054
LGA    G   120_A      G     118          4.031
LGA    N   121_A      I     119          3.526
LGA    K   122_A      P     120          2.670
LGA    I   123_A      S     121          1.290
LGA    D   124_A      R     122          2.217
LGA    D   125_A      D     123          2.046
LGA    H   126_A      H     124          1.039
LGA    L   127_A      A     125          1.275
LGA    N   128_A      V     126          1.500
LGA    S   129_A      S     127          1.095
LGA    C   130_A      Y     128          0.752
LGA    E   131_A      Q     129          0.836
LGA    L   132_A      I     130          0.893
LGA    T   133_A      G     131          0.573
LGA    L   134_A      Q     132          0.385
LGA    S   135_A      R     133          0.961
LGA    I   136_A      V     134          1.001
LGA    T   137_A      M     135          0.779
LGA    H   138_A      E     136          0.755
LGA    F   139_A      I     137          1.223
LGA    M   140_A      A     138          1.140
LGA    E   141_A      V     139          0.898
LGA    Q   142_A      R     140          0.454
LGA    Y   143_A      Y     141          0.717
LGA    I   144_A      L     142          0.811
LGA    N   145_A      R     143          0.813
LGA    I   146_A      N     144          0.663
LGA    G   147_A      G     145          0.321
LGA    G   148_A      G     146          0.094
LGA    T   149_A      N     147          0.692
LGA    Y   150_A      V     148          0.447
LGA    I   151_A      L     149          0.457
LGA    V   152_A      L     150          0.487
LGA    K   153_A      K     151          0.413
LGA    M   154_A      Q     152          0.603
LGA    Y   155_A      F     153          0.293
LGA    L   156_A      Q     154          0.959
LGA    G   157_A      G     155          1.257
LGA    S   158_A      D     156          1.433
LGA    Q   159_A      M     157          1.191
LGA    T   160_A      T     158          0.914
LGA    N   161_A      N     159          0.841
LGA    N   162_A      D     160          0.837
LGA    L   163_A      F     161          0.926
LGA    K   164_A      I     162          0.920
LGA    T   165_A      A     163          0.759
LGA    Y   166_A      I     164          1.279
LGA    L   167_A      W     165          1.682
LGA    K   168_A      R     166          1.127
LGA    G   169_A      K     167          0.867
LGA    M   170_A      N     168          0.482
LGA    F   171_A      F     169          0.557
LGA    Q   172_A      S     170          0.562
LGA    L   173_A      S     171          0.292
LGA    V   174_A      Y     172          0.886
LGA    H   175_A      K     173          0.913
LGA    T   176_A      I     174          0.952
LGA    T   177_A      S     175          0.792
LGA    K   178_A      K     176          2.418
LGA    P   179_A      P     177          6.393
LGA    K   180_A      -       -           -
LGA    S   186_A      S     184          5.214
LGA    R   187_A      S     185          1.508
LGA    E   188_A      E     186          0.534
LGA    I   189_A      I     187          0.522
LGA    Y   190_A      Y     188          0.692
LGA    L   191_A      I     189          0.639
LGA    V   192_A      M     190          0.787
LGA    C   193_A      F     191          0.729
LGA    K   194_A      F     192          0.454
LGA    N   195_A      G     193          0.204
LGA    F   196_A      F     194          0.199
LGA    L   197_A      K     195          0.763
LGA    G   198_A      A     196          2.248
LGA    R   199_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  182  174    5.0    171    1.90    30.99     90.089     8.536

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.189156 * X  +   0.570754 * Y  +   0.799037 * Z  + -10.147624
  Y_new =  -0.608886 * X  +   0.706576 * Y  +  -0.360567 * Z  +  -2.182199
  Z_new =  -0.770375 * X  +  -0.418319 * Y  +   0.481177 * Z  +  29.066822 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.715630    2.425962  [ DEG:   -41.0026    138.9974 ]
  Theta =   0.879430    2.262163  [ DEG:    50.3876    129.6124 ]
  Phi   =  -1.269590    1.872003  [ DEG:   -72.7422    107.2578 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2plw_A                                        
REMARK     2: T0508.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2plw_A.T0508.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  182  174   5.0  171   1.90   30.99  90.089
REMARK  ---------------------------------------------------------- 
MOLECULE 2plw_A
HEADER    TRANSFERASE                             20-APR-07   2PLW              
TITLE     CRYSTAL STRUCTURE OF A RIBOSOMAL RNA METHYLTRANSFERASE,               
TITLE    2 PUTATIVE, FROM PLASMODIUM FALCIPARUM (PF13_0052).                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBOSOMAL RNA METHYLTRANSFERASE, PUTATIVE;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 70-270;                                           
COMPND   5 EC: 2.1.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM FALCIPARUM 3D7;                      
SOURCE   3 ORGANISM_COMMON: MALARIA PARASITE;                                   
SOURCE   4 STRAIN: 3D7;                                                         
SOURCE   5 GENE: PF13_0052;                                                     
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: DH5A;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: P15_MHL                                   
KEYWDS    METHYLTRANSFERASE, MALARIA, PLASMODIUM FALCIPARUM, RNA, SAM,          
KEYWDS   2 STRUCTURAL GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.K.WERNIMONT,A.HASSANALI,L.LIN,J.LEW,Y.ZHAO,M.RAVICHANDRAN,          
AUTHOR   2 G.WASNEY,M.VEDADI,I.KOZIERADZKI,M.SCHAPIRA,A.BOCHKAREV,              
AUTHOR   3 A.M.EDWARDS,C.H.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,R.HUI,              
AUTHOR   4 W.QIU,STRUCTURAL GENOMICS CONSORTIUM (SGC)                           
REVDAT   1   08-MAY-07 2PLW    0                                                
JRNL        AUTH   A.K.WERNIMONT,A.HASSANALI,L.LIN,J.LEW,Y.ZHAO,                
JRNL        AUTH 2 M.RAVICHANDRAN,G.WASNEY,M.VEDADI,I.KOZIERADZKI,              
JRNL        AUTH 3 M.SCHAPIRA,A.BOCHKAREV,A.M.EDWARDS,C.H.ARROWSMITH,           
JRNL        AUTH 4 J.WEIGELT,M.SUNDSTROM,R.HUI,W.QIU                            
JRNL        TITL   CRYSTAL STRUCTURE OF A RIBOSOMAL RNA                         
JRNL        TITL 2 METHYLTRANSFERASE, PUTATIVE, FROM PLASMODIUM                 
JRNL        TITL 3 FALCIPARUM (PF13_0052).                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2PLW A    1   201  UNP    Q8IEL9   Q8IEL9_PLAF7    70    270             
SEQRES   1 A  201  ASN TYR ARG SER ARG ALA ALA TYR LYS LEU ILE GLU LEU          
SEQRES   2 A  201  ASP ASN LYS TYR LEU PHE LEU LYS LYS ASN LYS ILE ILE          
SEQRES   3 A  201  LEU ASP ILE GLY CYS TYR PRO GLY SER TRP CYS GLN VAL          
SEQRES   4 A  201  ILE LEU GLU ARG THR LYS ASN TYR LYS ASN LYS ILE ILE          
SEQRES   5 A  201  GLY ILE ASP LYS LYS ILE MET ASP PRO ILE PRO ASN VAL          
SEQRES   6 A  201  TYR PHE ILE GLN GLY GLU ILE GLY LYS ASP ASN MET ASN          
SEQRES   7 A  201  ASN ILE LYS ASN ILE ASN TYR ILE ASP ASN MET ASN ASN          
SEQRES   8 A  201  ASN SER VAL ASP TYR LYS LEU LYS GLU ILE LEU GLN ASP          
SEQRES   9 A  201  LYS LYS ILE ASP ILE ILE LEU SER ASP ALA ALA VAL PRO          
SEQRES  10 A  201  CYS ILE GLY ASN LYS ILE ASP ASP HIS LEU ASN SER CYS          
SEQRES  11 A  201  GLU LEU THR LEU SER ILE THR HIS PHE MET GLU GLN TYR          
SEQRES  12 A  201  ILE ASN ILE GLY GLY THR TYR ILE VAL LYS MET TYR LEU          
SEQRES  13 A  201  GLY SER GLN THR ASN ASN LEU LYS THR TYR LEU LYS GLY          
SEQRES  14 A  201  MET PHE GLN LEU VAL HIS THR THR LYS PRO LYS ALA SER          
SEQRES  15 A  201  ARG ASN GLU SER ARG GLU ILE TYR LEU VAL CYS LYS ASN          
SEQRES  16 A  201  PHE LEU GLY ARG LYS LYS                                      
HET    SO4      2       5                                                       
HET    SAM      1      27                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  SAM    C15 H22 N6 O5 S                                              
FORMUL   4  HOH   *155(H2 O)                                                    
CRYST1   42.595   59.798   71.295  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   TYR A   2      26.991  20.597  23.182  1.00 20.87           N  
ATOM      2  CA  TYR A   2      26.035  20.107  22.126  1.00 20.40           C  
ATOM      3  C   TYR A   2      26.665  20.134  20.733  1.00 19.64           C  
ATOM      4  O   TYR A   2      27.361  21.074  20.385  1.00 20.12           O  
ATOM      5  CB  TYR A   2      24.788  20.983  22.136  1.00 20.37           C  
ATOM      6  CG  TYR A   2      23.989  20.908  23.404  1.00 21.71           C  
ATOM      7  CD1 TYR A   2      23.556  19.679  23.915  1.00 20.86           C  
ATOM      8  CD2 TYR A   2      23.612  22.070  24.077  1.00 21.28           C  
ATOM      9  CE1 TYR A   2      22.809  19.611  25.076  1.00 22.40           C  
ATOM     10  CE2 TYR A   2      22.860  22.009  25.239  1.00 24.27           C  
ATOM     11  CZ  TYR A   2      22.467  20.783  25.732  1.00 23.01           C  
ATOM     12  OH  TYR A   2      21.707  20.749  26.877  1.00 25.60           O  
ATOM     13  N   ARG A   3      26.384  19.117  19.921  1.00 19.43           N  
ATOM     14  CA  ARG A   3      26.888  19.042  18.549  1.00 18.31           C  
ATOM     15  C   ARG A   3      26.263  20.060  17.577  1.00 18.18           C  
ATOM     16  O   ARG A   3      26.771  20.268  16.467  1.00 18.65           O  
ATOM     17  CB  ARG A   3      26.679  17.625  17.992  1.00 18.29           C  
ATOM     18  CG  ARG A   3      27.470  16.555  18.739  1.00 17.49           C  
ATOM     19  CD  ARG A   3      27.034  15.180  18.277  1.00 17.31           C  
ATOM     20  NE  ARG A   3      27.906  14.147  18.816  1.00 19.53           N  
ATOM     21  CZ  ARG A   3      27.943  12.898  18.377  1.00 19.30           C  
ATOM     22  NH1 ARG A   3      27.151  12.505  17.384  1.00 16.44           N  
ATOM     23  NH2 ARG A   3      28.765  12.040  18.949  1.00 19.50           N  
ATOM     24  N   SER A   4      25.147  20.650  17.981  1.00 18.01           N  
ATOM     25  CA  SER A   4      24.433  21.641  17.177  1.00 17.85           C  
ATOM     26  C   SER A   4      23.671  22.538  18.114  1.00 17.48           C  
ATOM     27  O   SER A   4      23.290  22.137  19.207  1.00 17.74           O  
ATOM     28  CB  SER A   4      23.423  20.965  16.213  1.00 17.99           C  
ATOM     29  OG  SER A   4      22.515  21.925  15.665  1.00 18.70           O  
ATOM     30  N   ARG A   5      23.423  23.767  17.668  1.00 18.14           N  
ATOM     31  CA  ARG A   5      22.607  24.690  18.443  1.00 17.57           C  
ATOM     32  C   ARG A   5      21.110  24.315  18.364  1.00 17.16           C  
ATOM     33  O   ARG A   5      20.292  24.851  19.108  1.00 16.25           O  
ATOM     34  CB  ARG A   5      22.878  26.133  18.012  1.00 18.17           C  
ATOM     35  CG  ARG A   5      24.298  26.572  18.389  1.00 19.08           C  
ATOM     36  CD  ARG A   5      24.547  28.060  18.167  1.00 22.41           C  
ATOM     37  NE  ARG A   5      25.960  28.357  18.406  1.00 23.23           N  
ATOM     38  CZ  ARG A   5      26.901  28.266  17.469  1.00 23.65           C  
ATOM     39  NH1 ARG A   5      26.562  27.928  16.227  1.00 23.60           N  
ATOM     40  NH2 ARG A   5      28.174  28.519  17.762  1.00 23.84           N  
ATOM     41  N   ALA A   6      20.775  23.384  17.467  1.00 17.60           N  
ATOM     42  CA  ALA A   6      19.401  22.807  17.425  1.00 17.20           C  
ATOM     43  C   ALA A   6      18.942  22.232  18.793  1.00 16.79           C  
ATOM     44  O   ALA A   6      17.733  22.221  19.095  1.00 16.55           O  
ATOM     45  CB  ALA A   6      19.292  21.737  16.334  1.00 16.46           C  
ATOM     46  N   ALA A   7      19.897  21.776  19.617  1.00 16.77           N  
ATOM     47  CA  ALA A   7      19.600  21.312  20.982  1.00 16.47           C  
ATOM     48  C   ALA A   7      18.671  22.262  21.722  1.00 15.96           C  
ATOM     49  O   ALA A   7      17.784  21.824  22.428  1.00 14.80           O  
ATOM     50  CB  ALA A   7      20.903  21.116  21.804  1.00 16.44           C  
ATOM     51  N   TYR A   8      18.863  23.568  21.549  1.00 17.00           N  
ATOM     52  CA  TYR A   8      18.063  24.533  22.305  1.00 17.67           C  
ATOM     53  C   TYR A   8      16.592  24.567  21.901  1.00 17.47           C  
ATOM     54  O   TYR A   8      15.756  24.940  22.712  1.00 17.97           O  
ATOM     55  CB  TYR A   8      18.711  25.923  22.266  1.00 18.52           C  
ATOM     56  CG  TYR A   8      20.033  25.869  23.011  1.00 18.84           C  
ATOM     57  CD1 TYR A   8      20.058  25.836  24.398  1.00 20.81           C  
ATOM     58  CD2 TYR A   8      21.248  25.801  22.318  1.00 20.17           C  
ATOM     59  CE1 TYR A   8      21.259  25.759  25.106  1.00 21.15           C  
ATOM     60  CE2 TYR A   8      22.454  25.700  23.002  1.00 19.35           C  
ATOM     61  CZ  TYR A   8      22.451  25.684  24.399  1.00 20.95           C  
ATOM     62  OH  TYR A   8      23.634  25.613  25.109  1.00 22.63           O  
ATOM     63  N   LYS A   9      16.289  24.161  20.665  1.00 17.41           N  
ATOM     64  CA  LYS A   9      14.891  23.990  20.238  1.00 17.68           C  
ATOM     65  C   LYS A   9      14.228  22.837  20.983  1.00 16.81           C  
ATOM     66  O   LYS A   9      13.073  22.922  21.331  1.00 16.76           O  
ATOM     67  CB  LYS A   9      14.816  23.748  18.725  1.00 17.88           C  
ATOM     68  CG  LYS A   9      15.250  24.983  17.940  1.00 22.05           C  
ATOM     69  CD  LYS A   9      14.945  24.896  16.446  1.00 25.99           C  
ATOM     70  CE  LYS A   9      15.912  23.981  15.745  1.00 28.20           C  
ATOM     71  NZ  LYS A   9      16.188  24.384  14.328  1.00 27.69           N  
ATOM     72  N   LEU A  10      14.948  21.732  21.187  1.00 16.40           N  
ATOM     73  CA  LEU A  10      14.349  20.617  21.934  1.00 16.21           C  
ATOM     74  C   LEU A  10      14.195  20.957  23.409  1.00 16.02           C  
ATOM     75  O   LEU A  10      13.175  20.652  24.031  1.00 15.18           O  
ATOM     76  CB  LEU A  10      15.113  19.309  21.722  1.00 16.07           C  
ATOM     77  CG  LEU A  10      14.418  18.102  22.388  1.00 14.65           C  
ATOM     78  CD1 LEU A  10      12.976  17.869  21.857  1.00 17.57           C  
ATOM     79  CD2 LEU A  10      15.251  16.868  22.151  1.00 16.55           C  
ATOM     80  N   ILE A  11      15.208  21.623  23.966  1.00 17.04           N  
ATOM     81  CA  ILE A  11      15.111  22.114  25.353  1.00 17.57           C  
ATOM     82  C   ILE A  11      13.852  22.997  25.545  1.00 18.46           C  
ATOM     83  O   ILE A  11      13.111  22.837  26.507  1.00 18.71           O  
ATOM     84  CB  ILE A  11      16.414  22.854  25.751  1.00 17.66           C  
ATOM     85  CG1 ILE A  11      17.568  21.858  25.846  1.00 17.31           C  
ATOM     86  CG2 ILE A  11      16.231  23.622  27.069  1.00 17.36           C  
ATOM     87  CD1 ILE A  11      18.954  22.479  25.691  1.00 19.49           C  
ATOM     88  N   GLU A  12      13.602  23.913  24.611  1.00 18.67           N  
ATOM     89  CA  GLU A  12      12.427  24.769  24.650  1.00 20.53           C  
ATOM     90  C   GLU A  12      11.143  23.931  24.579  1.00 19.58           C  
ATOM     91  O   GLU A  12      10.217  24.132  25.357  1.00 19.31           O  
ATOM     92  CB  GLU A  12      12.499  25.776  23.495  1.00 20.33           C  
ATOM     93  CG  GLU A  12      11.275  26.642  23.302  1.00 23.88           C  
ATOM     94  CD  GLU A  12      11.369  27.554  22.076  1.00 26.08           C  
ATOM     95  OE1 GLU A  12      12.469  27.660  21.466  1.00 29.17           O  
ATOM     96  OE2 GLU A  12      10.315  28.164  21.731  1.00 31.99           O  
ATOM     97  N   LEU A  13      11.112  22.982  23.637  1.00 18.51           N  
ATOM     98  CA  LEU A  13       9.951  22.124  23.458  1.00 17.97           C  
ATOM     99  C   LEU A  13       9.633  21.331  24.725  1.00 17.87           C  
ATOM    100  O   LEU A  13       8.480  21.286  25.158  1.00 18.45           O  
ATOM    101  CB  LEU A  13      10.164  21.171  22.282  1.00 17.59           C  
ATOM    102  CG  LEU A  13       9.969  21.786  20.891  1.00 14.69           C  
ATOM    103  CD1 LEU A  13      10.546  20.831  19.852  1.00 16.06           C  
ATOM    104  CD2 LEU A  13       8.492  22.063  20.633  1.00 16.73           C  
ATOM    105  N   ASP A  14      10.652  20.700  25.302  1.00 18.17           N  
ATOM    106  CA  ASP A  14      10.444  19.862  26.478  1.00 18.93           C  
ATOM    107  C   ASP A  14      10.118  20.714  27.700  1.00 20.13           C  
ATOM    108  O   ASP A  14       9.327  20.317  28.538  1.00 19.95           O  
ATOM    109  CB  ASP A  14      11.622  18.943  26.764  1.00 18.85           C  
ATOM    110  CG  ASP A  14      11.299  17.916  27.856  1.00 21.81           C  
ATOM    111  OD1 ASP A  14      10.308  17.173  27.702  1.00 21.34           O  
ATOM    112  OD2 ASP A  14      11.981  17.901  28.905  1.00 22.05           O  
ATOM    113  N   ASN A  15      10.724  21.891  27.783  1.00 20.81           N  
ATOM    114  CA  ASN A  15      10.361  22.838  28.854  1.00 22.55           C  
ATOM    115  C   ASN A  15       8.881  23.233  28.862  1.00 23.33           C  
ATOM    116  O   ASN A  15       8.270  23.403  29.929  1.00 23.81           O  
ATOM    117  CB  ASN A  15      11.250  24.082  28.755  1.00 22.47           C  
ATOM    118  CG  ASN A  15      12.624  23.862  29.335  1.00 23.07           C  
ATOM    119  OD1 ASN A  15      12.903  22.844  29.995  1.00 23.08           O  
ATOM    120  ND2 ASN A  15      13.505  24.831  29.108  1.00 27.30           N  
ATOM    121  N   LYS A  16       8.301  23.370  27.671  1.00 23.91           N  
ATOM    122  CA  LYS A  16       6.922  23.798  27.513  1.00 25.32           C  
ATOM    123  C   LYS A  16       5.962  22.610  27.571  1.00 24.95           C  
ATOM    124  O   LYS A  16       4.901  22.673  28.218  1.00 24.64           O  
ATOM    125  CB  LYS A  16       6.763  24.575  26.192  1.00 25.22           C  
ATOM    126  CG  LYS A  16       5.339  25.140  25.935  1.00 27.59           C  
ATOM    127  CD  LYS A  16       5.273  25.941  24.640  1.00 27.94           C  
ATOM    128  CE  LYS A  16       4.005  26.798  24.534  1.00 30.72           C  
ATOM    129  NZ  LYS A  16       4.234  28.232  24.959  1.00 34.52           N  
ATOM    130  N   TYR A  17       6.330  21.523  26.892  1.00 24.49           N  
ATOM    131  CA  TYR A  17       5.403  20.408  26.722  1.00 24.99           C  
ATOM    132  C   TYR A  17       5.673  19.186  27.588  1.00 24.83           C  
ATOM    133  O   TYR A  17       4.830  18.284  27.624  1.00 25.10           O  
ATOM    134  CB  TYR A  17       5.283  20.039  25.237  1.00 24.73           C  
ATOM    135  CG  TYR A  17       4.785  21.191  24.399  1.00 26.20           C  
ATOM    136  CD1 TYR A  17       3.415  21.511  24.337  1.00 25.96           C  
ATOM    137  CD2 TYR A  17       5.677  21.973  23.675  1.00 25.05           C  
ATOM    138  CE1 TYR A  17       2.963  22.568  23.557  1.00 27.71           C  
ATOM    139  CE2 TYR A  17       5.243  23.036  22.905  1.00 26.40           C  
ATOM    140  CZ  TYR A  17       3.889  23.333  22.852  1.00 26.64           C  
ATOM    141  OH  TYR A  17       3.487  24.397  22.084  1.00 30.60           O  
ATOM    142  N   LEU A  18       6.820  19.165  28.280  1.00 24.36           N  
ATOM    143  CA  LEU A  18       7.199  18.141  29.277  1.00 25.18           C  
ATOM    144  C   LEU A  18       6.857  16.703  28.911  1.00 24.79           C  
ATOM    145  O   LEU A  18       5.943  16.096  29.497  1.00 25.45           O  
ATOM    146  CB  LEU A  18       6.606  18.453  30.669  1.00 26.25           C  
ATOM    147  CG  LEU A  18       7.320  19.310  31.733  1.00 28.99           C  
ATOM    148  CD1 LEU A  18       8.705  18.747  32.158  1.00 30.52           C  
ATOM    149  CD2 LEU A  18       7.399  20.760  31.303  1.00 31.27           C  
ATOM    150  N   PHE A  19       7.603  16.164  27.953  1.00 22.74           N  
ATOM    151  CA  PHE A  19       7.321  14.846  27.404  1.00 21.84           C  
ATOM    152  C   PHE A  19       8.460  13.876  27.673  1.00 21.54           C  
ATOM    153  O   PHE A  19       8.251  12.669  27.628  1.00 20.75           O  
ATOM    154  CB  PHE A  19       6.999  14.935  25.895  1.00 20.04           C  
ATOM    155  CG  PHE A  19       7.958  15.796  25.114  1.00 18.64           C  
ATOM    156  CD1 PHE A  19       9.161  15.257  24.646  1.00 17.72           C  
ATOM    157  CD2 PHE A  19       7.665  17.141  24.845  1.00 18.56           C  
ATOM    158  CE1 PHE A  19      10.055  16.038  23.915  1.00 17.44           C  
ATOM    159  CE2 PHE A  19       8.567  17.936  24.126  1.00 17.74           C  
ATOM    160  CZ  PHE A  19       9.758  17.372  23.651  1.00 16.25           C  
ATOM    161  N   LEU A  20       9.661  14.390  27.963  1.00 21.68           N  
ATOM    162  CA  LEU A  20      10.802  13.516  28.220  1.00 22.36           C  
ATOM    163  C   LEU A  20      10.766  12.995  29.646  1.00 24.30           C  
ATOM    164  O   LEU A  20      11.065  13.720  30.597  1.00 25.50           O  
ATOM    165  CB  LEU A  20      12.133  14.204  27.935  1.00 22.27           C  
ATOM    166  CG  LEU A  20      12.374  14.611  26.473  1.00 19.64           C  
ATOM    167  CD1 LEU A  20      13.603  15.539  26.363  1.00 18.22           C  
ATOM    168  CD2 LEU A  20      12.559  13.376  25.562  1.00 20.93           C  
ATOM    169  N   LYS A  21      10.402  11.724  29.768  1.00 24.69           N  
ATOM    170  CA  LYS A  21      10.056  11.123  31.054  1.00 25.70           C  
ATOM    171  C   LYS A  21      10.734   9.766  31.172  1.00 24.16           C  
ATOM    172  O   LYS A  21      11.195   9.205  30.171  1.00 23.62           O  
ATOM    173  CB  LYS A  21       8.536  10.958  31.145  1.00 25.48           C  
ATOM    174  CG  LYS A  21       7.772  12.266  31.379  1.00 28.18           C  
ATOM    175  CD  LYS A  21       6.246  12.123  31.315  1.00 28.60           C  
ATOM    176  CE  LYS A  21       5.747  11.985  29.863  1.00 31.36           C  
ATOM    177  NZ  LYS A  21       4.305  12.336  29.576  1.00 32.05           N  
ATOM    178  N   LYS A  22      10.772   9.237  32.392  1.00 22.96           N  
ATOM    179  CA  LYS A  22      11.386   7.942  32.657  1.00 22.98           C  
ATOM    180  C   LYS A  22      10.637   6.789  31.980  1.00 21.18           C  
ATOM    181  O   LYS A  22       9.441   6.880  31.741  1.00 22.14           O  
ATOM    182  CB  LYS A  22      11.482   7.700  34.174  1.00 22.79           C  
ATOM    183  CG  LYS A  22      10.148   7.533  34.870  1.00 24.65           C  
ATOM    184  CD  LYS A  22      10.350   7.157  36.343  1.00 25.62           C  
ATOM    185  CE  LYS A  22       9.031   6.820  37.031  1.00 29.74           C  
ATOM    186  NZ  LYS A  22       8.051   7.963  37.149  1.00 34.86           N  
ATOM    187  N   ASN A  23      11.361   5.713  31.689  1.00 20.13           N  
ATOM    188  CA  ASN A  23      10.785   4.467  31.169  1.00 19.50           C  
ATOM    189  C   ASN A  23      10.030   4.671  29.855  1.00 18.03           C  
ATOM    190  O   ASN A  23       8.951   4.105  29.644  1.00 17.76           O  
ATOM    191  CB  ASN A  23       9.883   3.773  32.219  1.00 19.57           C  
ATOM    192  CG  ASN A  23       9.626   2.303  31.887  1.00 21.22           C  
ATOM    193  OD1 ASN A  23      10.347   1.705  31.092  1.00 20.13           O  
ATOM    194  ND2 ASN A  23       8.589   1.726  32.488  1.00 21.03           N  
ATOM    195  N   LYS A  24      10.605   5.494  28.987  1.00 17.49           N  
ATOM    196  CA  LYS A  24      10.038   5.698  27.651  1.00 15.94           C  
ATOM    197  C   LYS A  24      11.026   5.284  26.585  1.00 15.49           C  
ATOM    198  O   LYS A  24      12.246   5.468  26.748  1.00 14.60           O  
ATOM    199  CB  LYS A  24       9.675   7.164  27.410  1.00 17.63           C  
ATOM    200  CG  LYS A  24       8.673   7.768  28.435  1.00 18.32           C  
ATOM    201  CD  LYS A  24       7.281   7.191  28.250  1.00 22.31           C  
ATOM    202  CE  LYS A  24       6.332   7.620  29.369  1.00 22.15           C  
ATOM    203  NZ  LYS A  24       5.020   6.923  29.224  1.00 25.04           N  
ATOM    204  N   ILE A  25      10.482   4.756  25.492  1.00 13.91           N  
ATOM    205  CA  ILE A  25      11.298   4.527  24.302  1.00 13.65           C  
ATOM    206  C   ILE A  25      11.117   5.784  23.436  1.00 12.35           C  
ATOM    207  O   ILE A  25       9.998   6.185  23.133  1.00 12.79           O  
ATOM    208  CB  ILE A  25      10.866   3.263  23.559  1.00 13.48           C  
ATOM    209  CG1 ILE A  25      11.095   2.027  24.449  1.00 14.63           C  
ATOM    210  CG2 ILE A  25      11.639   3.134  22.255  1.00 13.90           C  
ATOM    211  CD1 ILE A  25      10.728   0.682  23.754  1.00 16.04           C  
ATOM    212  N   ILE A  26      12.229   6.365  23.017  1.00 11.97           N  
ATOM    213  CA  ILE A  26      12.240   7.664  22.319  1.00 12.22           C  
ATOM    214  C   ILE A  26      12.978   7.560  20.983  1.00 12.27           C  
ATOM    215  O   ILE A  26      14.114   7.086  20.910  1.00 11.91           O  
ATOM    216  CB  ILE A  26      12.907   8.741  23.194  1.00 12.52           C  
ATOM    217  CG1 ILE A  26      12.208   8.818  24.554  1.00 13.84           C  
ATOM    218  CG2 ILE A  26      12.817  10.127  22.535  1.00 14.31           C  
ATOM    219  CD1 ILE A  26      13.123   9.350  25.637  1.00 16.17           C  
ATOM    220  N   LEU A  27      12.312   8.012  19.924  1.00 11.96           N  
ATOM    221  CA  LEU A  27      12.900   8.031  18.584  1.00 12.62           C  
ATOM    222  C   LEU A  27      13.060   9.460  18.101  1.00 12.42           C  
ATOM    223  O   LEU A  27      12.129  10.247  18.151  1.00 12.57           O  
ATOM    224  CB  LEU A  27      12.005   7.266  17.609  1.00 11.72           C  
ATOM    225  CG  LEU A  27      12.423   7.299  16.130  1.00 12.48           C  
ATOM    226  CD1 LEU A  27      13.767   6.655  15.923  1.00 13.45           C  
ATOM    227  CD2 LEU A  27      11.379   6.605  15.271  1.00 13.99           C  
ATOM    228  N   ASP A  28      14.241   9.756  17.570  1.00 13.04           N  
ATOM    229  CA  ASP A  28      14.614  11.089  17.147  1.00 13.38           C  
ATOM    230  C   ASP A  28      14.892  11.000  15.658  1.00 13.05           C  
ATOM    231  O   ASP A  28      15.920  10.439  15.261  1.00 11.98           O  
ATOM    232  CB  ASP A  28      15.874  11.496  17.912  1.00 14.10           C  
ATOM    233  CG  ASP A  28      16.411  12.846  17.499  1.00 17.22           C  
ATOM    234  OD1 ASP A  28      15.630  13.703  17.059  1.00 21.01           O  
ATOM    235  OD2 ASP A  28      17.652  13.039  17.600  1.00 20.89           O  
ATOM    236  N   ILE A  29      13.959  11.499  14.851  1.00 12.23           N  
ATOM    237  CA  ILE A  29      14.069  11.392  13.399  1.00 13.02           C  
ATOM    238  C   ILE A  29      14.764  12.634  12.865  1.00 13.61           C  
ATOM    239  O   ILE A  29      14.477  13.748  13.327  1.00 14.54           O  
ATOM    240  CB  ILE A  29      12.685  11.245  12.743  1.00 13.22           C  
ATOM    241  CG1 ILE A  29      11.987   9.990  13.287  1.00 12.72           C  
ATOM    242  CG2 ILE A  29      12.833  11.200  11.182  1.00 13.54           C  
ATOM    243  CD1 ILE A  29      10.597   9.790  12.722  1.00 14.88           C  
ATOM    244  N   GLY A  30      15.678  12.432  11.916  1.00 13.82           N  
ATOM    245  CA  GLY A  30      16.521  13.522  11.420  1.00 13.92           C  
ATOM    246  C   GLY A  30      17.541  13.891  12.487  1.00 14.81           C  
ATOM    247  O   GLY A  30      17.669  15.053  12.823  1.00 15.22           O  
ATOM    248  N   CYS A  31      18.253  12.905  13.033  1.00 14.87           N  
ATOM    249  CA  CYS A  31      19.020  13.124  14.269  1.00 15.38           C  
ATOM    250  C   CYS A  31      20.396  13.750  14.049  1.00 16.19           C  
ATOM    251  O   CYS A  31      21.012  14.185  15.027  1.00 16.38           O  
ATOM    252  CB  CYS A  31      19.203  11.822  15.078  1.00 14.91           C  
ATOM    253  SG  CYS A  31      20.040  10.513  14.181  1.00 15.84           S  
ATOM    254  N   TYR A  32      20.895  13.751  12.806  1.00 16.06           N  
ATOM    255  CA  TYR A  32      22.273  14.229  12.537  1.00 16.79           C  
ATOM    256  C   TYR A  32      22.393  15.728  12.800  1.00 17.38           C  
ATOM    257  O   TYR A  32      21.548  16.496  12.345  1.00 17.45           O  
ATOM    258  CB  TYR A  32      22.674  13.951  11.091  1.00 17.32           C  
ATOM    259  CG  TYR A  32      24.081  14.397  10.778  1.00 17.77           C  
ATOM    260  CD1 TYR A  32      25.114  13.492  10.781  1.00 18.68           C  
ATOM    261  CD2 TYR A  32      24.358  15.741  10.499  1.00 19.64           C  
ATOM    262  CE1 TYR A  32      26.427  13.905  10.535  1.00 21.46           C  
ATOM    263  CE2 TYR A  32      25.651  16.177  10.253  1.00 21.76           C  
ATOM    264  CZ  TYR A  32      26.679  15.253  10.266  1.00 21.38           C  
ATOM    265  OH  TYR A  32      27.970  15.654  10.009  1.00 22.15           O  
ATOM    266  N   PRO A  33      23.479  16.163  13.465  1.00 17.71           N  
ATOM    267  CA  PRO A  33      24.659  15.430  13.976  1.00 17.18           C  
ATOM    268  C   PRO A  33      24.485  14.806  15.338  1.00 16.66           C  
ATOM    269  O   PRO A  33      25.376  14.098  15.773  1.00 17.32           O  
ATOM    270  CB  PRO A  33      25.728  16.533  14.080  1.00 17.53           C  
ATOM    271  CG  PRO A  33      24.964  17.723  14.389  1.00 17.90           C  
ATOM    272  CD  PRO A  33      23.642  17.614  13.655  1.00 17.55           C  
ATOM    273  N   GLY A  34      23.401  15.136  16.033  1.00 16.32           N  
ATOM    274  CA  GLY A  34      23.031  14.394  17.241  1.00 15.45           C  
ATOM    275  C   GLY A  34      22.687  15.155  18.490  1.00 15.60           C  
ATOM    276  O   GLY A  34      22.573  14.539  19.539  1.00 16.29           O  
ATOM    277  N   SER A  35      22.459  16.470  18.396  1.00 15.56           N  
ATOM    278  CA  SER A  35      22.224  17.243  19.618  1.00 16.12           C  
ATOM    279  C   SER A  35      20.896  16.978  20.313  1.00 15.34           C  
ATOM    280  O   SER A  35      20.817  17.101  21.531  1.00 14.95           O  
ATOM    281  CB  SER A  35      22.467  18.753  19.410  1.00 16.40           C  
ATOM    282  OG  SER A  35      21.372  19.367  18.756  1.00 17.91           O  
ATOM    283  N   TRP A  36      19.844  16.614  19.572  1.00 14.74           N  
ATOM    284  CA  TRP A  36      18.582  16.236  20.223  1.00 14.52           C  
ATOM    285  C   TRP A  36      18.802  14.963  21.012  1.00 14.85           C  
ATOM    286  O   TRP A  36      18.268  14.798  22.104  1.00 14.17           O  
ATOM    287  CB  TRP A  36      17.443  16.071  19.187  1.00 14.50           C  
ATOM    288  CG  TRP A  36      16.813  17.399  18.810  1.00 14.48           C  
ATOM    289  CD1 TRP A  36      17.404  18.659  18.865  1.00 14.95           C  
ATOM    290  CD2 TRP A  36      15.458  17.623  18.362  1.00 15.53           C  
ATOM    291  NE1 TRP A  36      16.497  19.628  18.485  1.00 14.32           N  
ATOM    292  CE2 TRP A  36      15.299  19.027  18.178  1.00 14.41           C  
ATOM    293  CE3 TRP A  36      14.359  16.779  18.117  1.00 15.41           C  
ATOM    294  CZ2 TRP A  36      14.105  19.599  17.730  1.00 13.16           C  
ATOM    295  CZ3 TRP A  36      13.157  17.353  17.704  1.00 13.99           C  
ATOM    296  CH2 TRP A  36      13.040  18.750  17.505  1.00 15.37           C  
ATOM    297  N   CYS A  37      19.586  14.055  20.441  1.00 15.13           N  
ATOM    298  CA  CYS A  37      19.935  12.820  21.136  1.00 15.66           C  
ATOM    299  C   CYS A  37      20.681  13.166  22.441  1.00 15.77           C  
ATOM    300  O   CYS A  37      20.419  12.572  23.479  1.00 15.07           O  
ATOM    301  CB  CYS A  37      20.771  11.907  20.258  1.00 16.30           C  
ATOM    302  SG  CYS A  37      19.740  10.966  19.074  1.00 20.12           S  
ATOM    303  N   GLN A  38      21.592  14.127  22.366  1.00 16.08           N  
ATOM    304  CA  GLN A  38      22.299  14.584  23.570  1.00 16.73           C  
ATOM    305  C   GLN A  38      21.369  15.187  24.601  1.00 16.70           C  
ATOM    306  O   GLN A  38      21.514  14.910  25.787  1.00 17.78           O  
ATOM    307  CB  GLN A  38      23.356  15.622  23.211  1.00 16.55           C  
ATOM    308  CG  GLN A  38      24.452  15.060  22.377  1.00 16.65           C  
ATOM    309  CD  GLN A  38      25.407  16.133  21.991  1.00 16.20           C  
ATOM    310  OE1 GLN A  38      25.087  16.983  21.166  1.00 16.86           O  
ATOM    311  NE2 GLN A  38      26.604  16.100  22.572  1.00 19.73           N  
ATOM    312  N   VAL A  39      20.410  16.009  24.165  1.00 17.23           N  
ATOM    313  CA  VAL A  39      19.440  16.620  25.091  1.00 16.96           C  
ATOM    314  C   VAL A  39      18.585  15.534  25.750  1.00 16.87           C  
ATOM    315  O   VAL A  39      18.334  15.557  26.959  1.00 17.38           O  
ATOM    316  CB  VAL A  39      18.508  17.628  24.353  1.00 16.97           C  
ATOM    317  CG1 VAL A  39      17.309  17.996  25.211  1.00 16.97           C  
ATOM    318  CG2 VAL A  39      19.291  18.876  23.936  1.00 16.61           C  
ATOM    319  N   ILE A  40      18.142  14.572  24.940  1.00 15.59           N  
ATOM    320  CA  ILE A  40      17.352  13.459  25.448  1.00 15.77           C  
ATOM    321  C   ILE A  40      18.121  12.679  26.512  1.00 17.15           C  
ATOM    322  O   ILE A  40      17.551  12.325  27.553  1.00 18.30           O  
ATOM    323  CB  ILE A  40      16.851  12.521  24.302  1.00 15.20           C  
ATOM    324  CG1 ILE A  40      15.908  13.286  23.357  1.00 14.62           C  
ATOM    325  CG2 ILE A  40      16.113  11.303  24.902  1.00 15.66           C  
ATOM    326  CD1 ILE A  40      15.745  12.580  21.960  1.00 14.02           C  
ATOM    327  N   LEU A  41      19.406  12.443  26.262  1.00 18.43           N  
ATOM    328  CA  LEU A  41      20.279  11.812  27.267  1.00 19.67           C  
ATOM    329  C   LEU A  41      20.341  12.610  28.573  1.00 20.84           C  
ATOM    330  O   LEU A  41      20.161  12.038  29.637  1.00 19.66           O  
ATOM    331  CB  LEU A  41      21.679  11.558  26.711  1.00 20.03           C  
ATOM    332  CG  LEU A  41      21.907  10.391  25.766  1.00 20.71           C  
ATOM    333  CD1 LEU A  41      23.271  10.542  25.121  1.00 21.94           C  
ATOM    334  CD2 LEU A  41      21.835   9.031  26.490  1.00 22.59           C  
ATOM    335  N   GLU A  42      20.561  13.919  28.480  1.00 22.12           N  
ATOM    336  CA  GLU A  42      20.625  14.796  29.662  1.00 24.19           C  
ATOM    337  C   GLU A  42      19.367  14.781  30.505  1.00 24.71           C  
ATOM    338  O   GLU A  42      19.425  14.727  31.741  1.00 25.55           O  
ATOM    339  CB  GLU A  42      20.842  16.241  29.231  1.00 25.20           C  
ATOM    340  CG  GLU A  42      22.214  16.535  28.753  1.00 28.29           C  
ATOM    341  CD  GLU A  42      22.324  17.933  28.188  1.00 30.91           C  
ATOM    342  OE1 GLU A  42      21.271  18.587  27.928  1.00 32.47           O  
ATOM    343  OE2 GLU A  42      23.472  18.370  27.985  1.00 35.22           O  
ATOM    344  N   ARG A  43      18.229  14.878  29.828  1.00 24.11           N  
ATOM    345  CA  ARG A  43      16.958  15.017  30.497  1.00 24.74           C  
ATOM    346  C   ARG A  43      16.456  13.688  31.040  1.00 24.91           C  
ATOM    347  O   ARG A  43      15.557  13.659  31.873  1.00 26.00           O  
ATOM    348  CB  ARG A  43      15.954  15.673  29.572  1.00 24.52           C  
ATOM    349  CG  ARG A  43      16.425  17.046  29.169  1.00 25.28           C  
ATOM    350  CD  ARG A  43      15.300  17.980  28.975  1.00 27.75           C  
ATOM    351  NE  ARG A  43      15.739  19.340  29.239  1.00 28.51           N  
ATOM    352  CZ  ARG A  43      14.932  20.334  29.577  1.00 25.16           C  
ATOM    353  NH1 ARG A  43      13.626  20.143  29.659  1.00 23.12           N  
ATOM    354  NH2 ARG A  43      15.443  21.534  29.794  1.00 27.25           N  
ATOM    355  N   THR A  44      17.049  12.592  30.581  1.00 24.51           N  
ATOM    356  CA  THR A  44      16.652  11.282  31.088  1.00 24.83           C  
ATOM    357  C   THR A  44      17.822  10.630  31.846  1.00 26.10           C  
ATOM    358  O   THR A  44      17.876   9.424  31.960  1.00 27.04           O  
ATOM    359  CB  THR A  44      16.122  10.359  29.946  1.00 24.12           C  
ATOM    360  OG1 THR A  44      17.148  10.161  28.978  1.00 20.53           O  
ATOM    361  CG2 THR A  44      14.900  10.952  29.243  1.00 23.05           C  
ATOM    362  N   LYS A  45      18.736  11.440  32.386  1.00 28.07           N  
ATOM    363  CA  LYS A  45      20.056  10.948  32.869  1.00 29.97           C  
ATOM    364  C   LYS A  45      20.041   9.750  33.839  1.00 31.24           C  
ATOM    365  O   LYS A  45      20.815   8.796  33.682  1.00 32.21           O  
ATOM    366  CB  LYS A  45      20.894  12.105  33.452  1.00 30.64           C  
ATOM    367  N   ASN A  46      19.159   9.788  34.830  1.00 32.31           N  
ATOM    368  CA  ASN A  46      19.100   8.698  35.811  1.00 33.04           C  
ATOM    369  C   ASN A  46      17.813   7.917  35.639  1.00 31.96           C  
ATOM    370  O   ASN A  46      17.245   7.416  36.610  1.00 32.40           O  
ATOM    371  CB  ASN A  46      19.171   9.238  37.237  1.00 34.20           C  
ATOM    372  CG  ASN A  46      20.104  10.407  37.368  1.00 36.27           C  
ATOM    373  OD1 ASN A  46      19.669  11.530  37.627  1.00 37.86           O  
ATOM    374  ND2 ASN A  46      21.404  10.157  37.170  1.00 39.28           N  
ATOM    375  N   TYR A  47      17.329   7.872  34.400  1.00 30.20           N  
ATOM    376  CA  TYR A  47      16.125   7.133  34.061  1.00 28.77           C  
ATOM    377  C   TYR A  47      16.459   5.962  33.154  1.00 26.94           C  
ATOM    378  O   TYR A  47      17.481   5.950  32.453  1.00 25.81           O  
ATOM    379  CB  TYR A  47      15.133   8.026  33.305  1.00 30.60           C  
ATOM    380  CG  TYR A  47      14.604   9.237  34.041  1.00 31.89           C  
ATOM    381  CD1 TYR A  47      14.029  10.287  33.337  1.00 33.06           C  
ATOM    382  CD2 TYR A  47      14.656   9.321  35.432  1.00 33.27           C  
ATOM    383  CE1 TYR A  47      13.524  11.410  33.999  1.00 34.83           C  
ATOM    384  CE2 TYR A  47      14.159  10.433  36.104  1.00 35.03           C  
ATOM    385  CZ  TYR A  47      13.592  11.468  35.382  1.00 34.38           C  
ATOM    386  OH  TYR A  47      13.097  12.566  36.048  1.00 35.87           O  
ATOM    387  N   LYS A  48      15.576   4.980  33.154  1.00 24.60           N  
ATOM    388  CA  LYS A  48      15.694   3.892  32.201  1.00 22.80           C  
ATOM    389  C   LYS A  48      14.960   4.370  30.943  1.00 22.02           C  
ATOM    390  O   LYS A  48      13.797   4.784  31.033  1.00 21.23           O  
ATOM    391  CB  LYS A  48      15.033   2.651  32.787  1.00 22.82           C  
ATOM    392  CG  LYS A  48      14.795   1.561  31.788  1.00 21.08           C  
ATOM    393  CD  LYS A  48      14.162   0.347  32.435  1.00 19.75           C  
ATOM    394  CE  LYS A  48      13.843  -0.701  31.361  1.00 17.09           C  
ATOM    395  NZ  LYS A  48      12.650  -0.239  30.565  1.00 19.83           N  
ATOM    396  N   ASN A  49      15.639   4.321  29.791  1.00 20.52           N  
ATOM    397  CA  ASN A  49      15.031   4.694  28.507  1.00 19.87           C  
ATOM    398  C   ASN A  49      15.729   3.929  27.405  1.00 19.15           C  
ATOM    399  O   ASN A  49      16.792   3.370  27.642  1.00 19.48           O  
ATOM    400  CB  ASN A  49      15.238   6.198  28.233  1.00 19.62           C  
ATOM    401  CG  ASN A  49      14.462   7.100  29.189  1.00 20.95           C  
ATOM    402  OD1 ASN A  49      15.021   7.568  30.189  1.00 24.24           O  
ATOM    403  ND2 ASN A  49      13.182   7.369  28.883  1.00 17.25           N  
ATOM    404  N   LYS A  50      15.130   3.890  26.211  1.00 18.01           N  
ATOM    405  CA  LYS A  50      15.849   3.547  24.983  1.00 17.42           C  
ATOM    406  C   LYS A  50      15.761   4.783  24.107  1.00 16.44           C  
ATOM    407  O   LYS A  50      14.671   5.312  23.893  1.00 18.00           O  
ATOM    408  CB  LYS A  50      15.189   2.401  24.234  1.00 17.87           C  
ATOM    409  CG  LYS A  50      15.639   1.035  24.631  1.00 19.99           C  
ATOM    410  CD  LYS A  50      14.866  -0.032  23.852  1.00 21.95           C  
ATOM    411  CE  LYS A  50      15.431  -1.427  24.146  1.00 22.98           C  
ATOM    412  NZ  LYS A  50      15.623  -1.748  25.597  1.00 23.94           N  
ATOM    413  N   ILE A  51      16.910   5.253  23.649  1.00 15.16           N  
ATOM    414  CA  ILE A  51      16.987   6.414  22.765  1.00 14.23           C  
ATOM    415  C   ILE A  51      17.484   5.944  21.391  1.00 13.17           C  
ATOM    416  O   ILE A  51      18.551   5.344  21.290  1.00 13.65           O  
ATOM    417  CB  ILE A  51      17.906   7.496  23.363  1.00 14.45           C  
ATOM    418  CG1 ILE A  51      17.425   7.866  24.772  1.00 17.21           C  
ATOM    419  CG2 ILE A  51      17.913   8.742  22.492  1.00 12.69           C  
ATOM    420  CD1 ILE A  51      18.517   8.481  25.607  1.00 17.27           C  
ATOM    421  N   ILE A  52      16.689   6.202  20.354  1.00 12.72           N  
ATOM    422  CA  ILE A  52      17.006   5.782  18.980  1.00 11.91           C  
ATOM    423  C   ILE A  52      17.036   7.021  18.082  1.00 11.28           C  
ATOM    424  O   ILE A  52      16.152   7.863  18.147  1.00 12.77           O  
ATOM    425  CB  ILE A  52      15.975   4.749  18.422  1.00 11.64           C  
ATOM    426  CG1 ILE A  52      15.783   3.577  19.399  1.00 11.85           C  
ATOM    427  CG2 ILE A  52      16.418   4.250  17.037  1.00 13.74           C  
ATOM    428  CD1 ILE A  52      14.473   2.864  19.234  1.00 15.07           C  
ATOM    429  N   GLY A  53      18.054   7.101  17.233  1.00 11.69           N  
ATOM    430  CA  GLY A  53      18.181   8.198  16.273  1.00 11.88           C  
ATOM    431  C   GLY A  53      18.126   7.640  14.877  1.00 12.31           C  
ATOM    432  O   GLY A  53      18.762   6.608  14.597  1.00 12.91           O  
ATOM    433  N   ILE A  54      17.431   8.345  13.986  1.00 11.61           N  
ATOM    434  CA  ILE A  54      17.406   7.938  12.579  1.00 12.41           C  
ATOM    435  C   ILE A  54      17.805   9.135  11.744  1.00 12.38           C  
ATOM    436  O   ILE A  54      17.269  10.212  11.946  1.00 11.39           O  
ATOM    437  CB  ILE A  54      16.013   7.451  12.130  1.00 12.18           C  
ATOM    438  CG1 ILE A  54      15.713   6.077  12.744  1.00 15.06           C  
ATOM    439  CG2 ILE A  54      16.010   7.249  10.565  1.00 12.77           C  
ATOM    440  CD1 ILE A  54      14.301   5.579  12.455  1.00 13.45           C  
ATOM    441  N   ASP A  55      18.727   8.960  10.803  1.00 13.02           N  
ATOM    442  CA  ASP A  55      18.968  10.016   9.799  1.00 13.94           C  
ATOM    443  C   ASP A  55      19.481   9.375   8.534  1.00 14.10           C  
ATOM    444  O   ASP A  55      20.084   8.315   8.591  1.00 14.83           O  
ATOM    445  CB  ASP A  55      20.013  11.017  10.310  1.00 12.76           C  
ATOM    446  CG  ASP A  55      19.977  12.334   9.595  1.00 13.15           C  
ATOM    447  OD1 ASP A  55      20.316  12.407   8.394  1.00 16.72           O  
ATOM    448  OD2 ASP A  55      19.632  13.331  10.245  1.00 14.94           O  
ATOM    449  N   LYS A  56      19.250  10.026   7.395  1.00 15.66           N  
ATOM    450  CA  LYS A  56      19.840   9.527   6.139  1.00 18.06           C  
ATOM    451  C   LYS A  56      21.369   9.713   6.144  1.00 18.20           C  
ATOM    452  O   LYS A  56      22.072   8.973   5.478  1.00 19.98           O  
ATOM    453  CB  LYS A  56      19.174  10.156   4.907  1.00 18.13           C  
ATOM    454  CG  LYS A  56      19.296  11.653   4.821  1.00 19.95           C  
ATOM    455  CD  LYS A  56      18.235  12.301   3.892  1.00 22.35           C  
ATOM    456  CE  LYS A  56      18.446  11.916   2.436  1.00 28.07           C  
ATOM    457  NZ  LYS A  56      17.588  12.760   1.551  1.00 33.17           N  
ATOM    458  N   LYS A  57      21.853  10.681   6.918  1.00 18.63           N  
ATOM    459  CA  LYS A  57      23.293  10.916   7.113  1.00 20.01           C  
ATOM    460  C   LYS A  57      23.832  10.153   8.331  1.00 20.21           C  
ATOM    461  O   LYS A  57      23.194  10.107   9.390  1.00 20.01           O  
ATOM    462  CB  LYS A  57      23.575  12.401   7.314  1.00 20.57           C  
ATOM    463  CG  LYS A  57      23.356  13.287   6.095  1.00 23.47           C  
ATOM    464  CD  LYS A  57      23.881  14.715   6.380  1.00 23.77           C  
ATOM    465  CE  LYS A  57      22.716  15.630   6.819  1.00 30.71           C  
ATOM    466  NZ  LYS A  57      23.072  16.823   7.673  1.00 32.16           N  
ATOM    467  N   ILE A  58      25.029   9.604   8.189  1.00 20.33           N  
ATOM    468  CA  ILE A  58      25.631   8.816   9.256  1.00 20.26           C  
ATOM    469  C   ILE A  58      26.091   9.721  10.384  1.00 20.93           C  
ATOM    470  O   ILE A  58      26.856  10.668  10.165  1.00 21.38           O  
ATOM    471  CB  ILE A  58      26.791   7.916   8.744  1.00 21.23           C  
ATOM    472  CG1 ILE A  58      26.230   6.827   7.828  1.00 21.85           C  
ATOM    473  CG2 ILE A  58      27.450   7.182   9.920  1.00 21.70           C  
ATOM    474  CD1 ILE A  58      27.221   6.265   6.854  1.00 25.64           C  
ATOM    475  N   MET A  59      25.603   9.437  11.591  1.00 20.52           N  
ATOM    476  CA  MET A  59      25.919  10.254  12.740  1.00 20.09           C  
ATOM    477  C   MET A  59      27.096   9.593  13.452  1.00 19.39           C  
ATOM    478  O   MET A  59      27.192   8.368  13.486  1.00 20.29           O  
ATOM    479  CB  MET A  59      24.684  10.307  13.641  1.00 20.03           C  
ATOM    480  CG  MET A  59      24.902  10.901  14.994  1.00 21.93           C  
ATOM    481  SD  MET A  59      23.386  10.950  15.960  1.00 20.61           S  
ATOM    482  CE  MET A  59      23.405   9.324  16.723  1.00 21.08           C  
ATOM    483  N   ASP A  60      27.993  10.397  14.026  1.00 18.65           N  
ATOM    484  CA  ASP A  60      29.021   9.827  14.891  1.00 19.40           C  
ATOM    485  C   ASP A  60      28.350   9.162  16.095  1.00 17.95           C  
ATOM    486  O   ASP A  60      27.397   9.712  16.636  1.00 17.96           O  
ATOM    487  CB  ASP A  60      29.963  10.915  15.391  1.00 19.96           C  
ATOM    488  CG  ASP A  60      30.941  11.362  14.338  1.00 24.39           C  
ATOM    489  OD1 ASP A  60      31.089  10.664  13.297  1.00 26.94           O  
ATOM    490  OD2 ASP A  60      31.558  12.409  14.596  1.00 28.74           O  
ATOM    491  N   PRO A  61      28.828   7.975  16.500  1.00 17.48           N  
ATOM    492  CA  PRO A  61      28.155   7.309  17.620  1.00 16.05           C  
ATOM    493  C   PRO A  61      28.074   8.175  18.892  1.00 15.73           C  
ATOM    494  O   PRO A  61      28.952   9.001  19.144  1.00 15.88           O  
ATOM    495  CB  PRO A  61      29.030   6.072  17.887  1.00 16.50           C  
ATOM    496  CG  PRO A  61      29.751   5.823  16.628  1.00 16.62           C  
ATOM    497  CD  PRO A  61      29.934   7.165  15.958  1.00 17.53           C  
ATOM    498  N   ILE A  62      27.025   7.950  19.671  1.00 15.01           N  
ATOM    499  CA  ILE A  62      26.859   8.573  20.997  1.00 14.75           C  
ATOM    500  C   ILE A  62      26.666   7.408  21.928  1.00 15.14           C  
ATOM    501  O   ILE A  62      25.859   6.524  21.630  1.00 15.40           O  
ATOM    502  CB  ILE A  62      25.618   9.482  21.052  1.00 15.10           C  
ATOM    503  CG1 ILE A  62      25.738  10.619  20.037  1.00 14.57           C  
ATOM    504  CG2 ILE A  62      25.423  10.040  22.490  1.00 14.79           C  
ATOM    505  CD1 ILE A  62      24.445  11.345  19.770  1.00 15.56           C  
ATOM    506  N   PRO A  63      27.445   7.344  23.028  1.00 16.02           N  
ATOM    507  CA  PRO A  63      27.237   6.234  23.948  1.00 16.37           C  
ATOM    508  C   PRO A  63      25.780   6.182  24.431  1.00 15.98           C  
ATOM    509  O   PRO A  63      25.184   7.223  24.740  1.00 16.62           O  
ATOM    510  CB  PRO A  63      28.186   6.545  25.114  1.00 16.94           C  
ATOM    511  CG  PRO A  63      29.287   7.406  24.516  1.00 16.42           C  
ATOM    512  CD  PRO A  63      28.572   8.212  23.424  1.00 17.23           C  
ATOM    513  N   ASN A  64      25.232   4.968  24.452  1.00 15.97           N  
ATOM    514  CA  ASN A  64      23.870   4.693  24.928  1.00 16.81           C  
ATOM    515  C   ASN A  64      22.749   5.227  24.050  1.00 15.89           C  
ATOM    516  O   ASN A  64      21.623   5.409  24.515  1.00 16.09           O  
ATOM    517  CB  ASN A  64      23.717   5.160  26.383  1.00 18.58           C  
ATOM    518  CG  ASN A  64      24.786   4.552  27.293  1.00 22.32           C  
ATOM    519  OD1 ASN A  64      25.492   5.274  28.005  1.00 28.14           O  
ATOM    520  ND2 ASN A  64      24.947   3.224  27.228  1.00 26.68           N  
ATOM    521  N   VAL A  65      23.076   5.479  22.788  1.00 14.22           N  
ATOM    522  CA  VAL A  65      22.085   5.822  21.784  1.00 13.92           C  
ATOM    523  C   VAL A  65      22.197   4.839  20.635  1.00 13.69           C  
ATOM    524  O   VAL A  65      23.319   4.557  20.167  1.00 13.50           O  
ATOM    525  CB  VAL A  65      22.316   7.245  21.261  1.00 13.62           C  
ATOM    526  CG1 VAL A  65      21.318   7.567  20.095  1.00 15.01           C  
ATOM    527  CG2 VAL A  65      22.186   8.266  22.436  1.00 15.84           C  
ATOM    528  N   TYR A  66      21.053   4.331  20.175  1.00 12.71           N  
ATOM    529  CA  TYR A  66      21.031   3.434  19.015  1.00 13.59           C  
ATOM    530  C   TYR A  66      20.869   4.318  17.797  1.00 13.30           C  
ATOM    531  O   TYR A  66      19.979   5.171  17.773  1.00 15.78           O  
ATOM    532  CB  TYR A  66      19.840   2.493  19.063  1.00 14.53           C  
ATOM    533  CG  TYR A  66      19.785   1.574  20.251  1.00 14.78           C  
ATOM    534  CD1 TYR A  66      20.371   0.318  20.204  1.00 16.99           C  
ATOM    535  CD2 TYR A  66      19.112   1.949  21.417  1.00 14.16           C  
ATOM    536  CE1 TYR A  66      20.297  -0.545  21.295  1.00 18.78           C  
ATOM    537  CE2 TYR A  66      19.058   1.089  22.521  1.00 16.54           C  
ATOM    538  CZ  TYR A  66      19.648  -0.153  22.446  1.00 18.90           C  
ATOM    539  OH  TYR A  66      19.608  -1.018  23.526  1.00 18.87           O  
ATOM    540  N   PHE A  67      21.712   4.139  16.789  1.00 13.37           N  
ATOM    541  CA  PHE A  67      21.540   4.906  15.573  1.00 12.36           C  
ATOM    542  C   PHE A  67      21.133   3.977  14.426  1.00 13.32           C  
ATOM    543  O   PHE A  67      21.597   2.825  14.337  1.00 13.63           O  
ATOM    544  CB  PHE A  67      22.819   5.685  15.215  1.00 13.34           C  
ATOM    545  CG  PHE A  67      22.756   6.336  13.859  1.00 13.51           C  
ATOM    546  CD1 PHE A  67      21.927   7.428  13.648  1.00 13.73           C  
ATOM    547  CD2 PHE A  67      23.523   5.852  12.808  1.00 15.46           C  
ATOM    548  CE1 PHE A  67      21.874   8.035  12.400  1.00 15.42           C  
ATOM    549  CE2 PHE A  67      23.475   6.449  11.542  1.00 17.05           C  
ATOM    550  CZ  PHE A  67      22.635   7.521  11.337  1.00 16.04           C  
ATOM    551  N   ILE A  68      20.264   4.489  13.560  1.00 12.35           N  
ATOM    552  CA  ILE A  68      19.842   3.760  12.361  1.00 13.65           C  
ATOM    553  C   ILE A  68      19.989   4.699  11.185  1.00 14.13           C  
ATOM    554  O   ILE A  68      19.358   5.753  11.144  1.00 13.74           O  
ATOM    555  CB  ILE A  68      18.379   3.247  12.471  1.00 13.11           C  
ATOM    556  CG1 ILE A  68      18.273   2.195  13.588  1.00 13.64           C  
ATOM    557  CG2 ILE A  68      17.894   2.734  11.095  1.00 14.06           C  
ATOM    558  CD1 ILE A  68      16.813   1.817  13.958  1.00 15.88           C  
ATOM    559  N   GLN A  69      20.833   4.326  10.224  1.00 15.54           N  
ATOM    560  CA  GLN A  69      20.886   5.129   9.024  1.00 15.70           C  
ATOM    561  C   GLN A  69      19.709   4.760   8.116  1.00 15.86           C  
ATOM    562  O   GLN A  69      19.472   3.583   7.808  1.00 17.27           O  
ATOM    563  CB  GLN A  69      22.212   4.992   8.271  1.00 17.21           C  
ATOM    564  CG  GLN A  69      22.278   5.992   7.141  1.00 18.09           C  
ATOM    565  CD  GLN A  69      23.486   5.803   6.230  1.00 24.42           C  
ATOM    566  OE1 GLN A  69      24.084   4.736   6.199  1.00 25.79           O  
ATOM    567  NE2 GLN A  69      23.840   6.853   5.483  1.00 24.74           N  
ATOM    568  N   GLY A  70      18.965   5.765   7.699  1.00 15.12           N  
ATOM    569  CA  GLY A  70      17.830   5.535   6.806  1.00 15.74           C  
ATOM    570  C   GLY A  70      17.030   6.772   6.501  1.00 16.86           C  
ATOM    571  O   GLY A  70      16.976   7.701   7.294  1.00 16.27           O  
ATOM    572  N   GLU A  71      16.425   6.801   5.321  1.00 17.49           N  
ATOM    573  CA  GLU A  71      15.586   7.915   4.963  1.00 18.20           C  
ATOM    574  C   GLU A  71      14.121   7.511   5.175  1.00 17.96           C  
ATOM    575  O   GLU A  71      13.608   6.625   4.489  1.00 18.64           O  
ATOM    576  CB  GLU A  71      15.845   8.320   3.504  1.00 18.05           C  
ATOM    577  CG  GLU A  71      14.909   9.415   3.007  1.00 20.10           C  
ATOM    578  CD  GLU A  71      15.248   9.873   1.594  1.00 21.09           C  
ATOM    579  OE1 GLU A  71      16.083   9.223   0.932  1.00 27.98           O  
ATOM    580  OE2 GLU A  71      14.670  10.876   1.154  1.00 28.22           O  
ATOM    581  N   ILE A  72      13.452   8.134   6.145  1.00 17.13           N  
ATOM    582  CA  ILE A  72      12.047   7.811   6.358  1.00 16.96           C  
ATOM    583  C   ILE A  72      11.250   8.195   5.105  1.00 18.01           C  
ATOM    584  O   ILE A  72      11.484   9.245   4.515  1.00 17.80           O  
ATOM    585  CB  ILE A  72      11.495   8.480   7.647  1.00 16.40           C  
ATOM    586  CG1 ILE A  72      12.272   7.954   8.851  1.00 13.86           C  
ATOM    587  CG2 ILE A  72       9.994   8.251   7.760  1.00 15.72           C  
ATOM    588  CD1 ILE A  72      12.105   6.448   9.149  1.00 16.28           C  
ATOM    589  N   GLY A  73      10.360   7.316   4.672  1.00 19.56           N  
ATOM    590  CA  GLY A  73       9.669   7.518   3.401  1.00 21.21           C  
ATOM    591  C   GLY A  73      10.323   6.744   2.270  1.00 21.68           C  
ATOM    592  O   GLY A  73       9.785   6.695   1.167  1.00 23.16           O  
ATOM    593  N   LYS A  74      11.481   6.144   2.538  1.00 22.71           N  
ATOM    594  CA  LYS A  74      12.214   5.351   1.539  1.00 22.83           C  
ATOM    595  C   LYS A  74      12.751   4.017   2.082  1.00 22.51           C  
ATOM    596  O   LYS A  74      12.442   2.936   1.560  1.00 22.03           O  
ATOM    597  CB  LYS A  74      13.363   6.187   0.956  1.00 23.35           C  
ATOM    598  CG  LYS A  74      14.278   5.449  -0.014  1.00 28.08           C  
ATOM    599  CD  LYS A  74      15.579   6.187  -0.227  1.00 32.06           C  
ATOM    600  CE  LYS A  74      16.478   5.471  -1.230  1.00 36.94           C  
ATOM    601  NZ  LYS A  74      16.729   4.031  -0.876  1.00 38.59           N  
ATOM    602  N   ASP A  75      13.572   4.108   3.129  1.00 20.76           N  
ATOM    603  CA  ASP A  75      14.214   2.948   3.762  1.00 20.32           C  
ATOM    604  C   ASP A  75      13.378   2.239   4.828  1.00 19.29           C  
ATOM    605  O   ASP A  75      13.807   1.250   5.402  1.00 20.20           O  
ATOM    606  CB  ASP A  75      15.558   3.374   4.350  1.00 20.42           C  
ATOM    607  CG  ASP A  75      16.486   3.943   3.299  1.00 23.74           C  
ATOM    608  OD1 ASP A  75      16.643   3.279   2.237  1.00 25.50           O  
ATOM    609  OD2 ASP A  75      17.055   5.033   3.527  1.00 23.54           O  
ATOM    610  N   ASN A  76      12.209   2.770   5.146  1.00 18.83           N  
ATOM    611  CA  ASN A  76      11.222   1.944   5.834  1.00 18.22           C  
ATOM    612  C   ASN A  76      10.285   1.419   4.755  1.00 18.45           C  
ATOM    613  O   ASN A  76      10.102   2.062   3.723  1.00 17.34           O  
ATOM    614  CB  ASN A  76      10.450   2.692   6.928  1.00 17.51           C  
ATOM    615  CG  ASN A  76       9.706   3.908   6.402  1.00 18.35           C  
ATOM    616  OD1 ASN A  76      10.306   4.885   5.965  1.00 19.28           O  
ATOM    617  ND2 ASN A  76       8.388   3.836   6.404  1.00 15.00           N  
ATOM    618  N   MET A  77       9.710   0.251   4.997  1.00 18.93           N  
ATOM    619  CA  MET A  77       9.030  -0.481   3.906  1.00 20.17           C  
ATOM    620  C   MET A  77       7.620   0.024   3.585  1.00 19.75           C  
ATOM    621  O   MET A  77       7.187   0.041   2.410  1.00 19.91           O  
ATOM    622  CB  MET A  77       9.035  -1.977   4.210  1.00 20.70           C  
ATOM    623  CG  MET A  77       8.414  -2.801   3.100  1.00 25.11           C  
ATOM    624  SD  MET A  77       9.363  -2.620   1.577  1.00 33.61           S  
ATOM    625  CE  MET A  77      10.173  -4.220   1.510  1.00 32.64           C  
ATOM    626  N   ASN A  78       6.894   0.440   4.624  1.00 17.33           N  
ATOM    627  CA  ASN A  78       5.516   0.832   4.456  1.00 16.73           C  
ATOM    628  C   ASN A  78       5.422   2.354   4.400  1.00 18.38           C  
ATOM    629  O   ASN A  78       5.501   3.052   5.426  1.00 17.25           O  
ATOM    630  CB  ASN A  78       4.645   0.199   5.553  1.00 16.35           C  
ATOM    631  CG  ASN A  78       3.192   0.672   5.528  1.00 13.04           C  
ATOM    632  OD1 ASN A  78       2.768   1.478   4.674  1.00 16.37           O  
ATOM    633  ND2 ASN A  78       2.413   0.133   6.433  1.00 15.84           N  
ATOM    634  N   ASN A  79       5.255   2.850   3.180  1.00 20.56           N  
ATOM    635  CA  ASN A  79       5.123   4.287   2.914  1.00 24.21           C  
ATOM    636  C   ASN A  79       3.761   4.607   2.286  1.00 26.56           C  
ATOM    637  O   ASN A  79       2.971   3.690   2.040  1.00 27.92           O  
ATOM    638  CB  ASN A  79       6.249   4.714   1.995  1.00 24.65           C  
ATOM    639  CG  ASN A  79       7.599   4.409   2.576  1.00 25.75           C  
ATOM    640  OD1 ASN A  79       7.906   4.832   3.703  1.00 29.64           O  
ATOM    641  ND2 ASN A  79       8.429   3.675   1.820  1.00 26.71           N  
ATOM    642  N   ILE A  80       3.475   5.882   2.038  1.00 28.37           N  
ATOM    643  CA  ILE A  80       2.227   6.265   1.360  1.00 30.01           C  
ATOM    644  C   ILE A  80       2.060   5.520   0.047  1.00 31.10           C  
ATOM    645  O   ILE A  80       3.002   5.443  -0.745  1.00 32.19           O  
ATOM    646  CB  ILE A  80       2.209   7.749   1.016  1.00 30.60           C  
ATOM    647  N   ASN A  92      12.525  -2.597   3.760  1.00 25.29           N  
ATOM    648  CA  ASN A  92      12.747  -3.335   5.035  1.00 25.49           C  
ATOM    649  C   ASN A  92      13.763  -2.798   6.070  1.00 23.59           C  
ATOM    650  O   ASN A  92      13.643  -3.136   7.238  1.00 22.17           O  
ATOM    651  CB  ASN A  92      13.128  -4.831   4.779  1.00 25.53           C  
ATOM    652  CG  ASN A  92      11.921  -5.734   4.630  1.00 29.08           C  
ATOM    653  OD1 ASN A  92      10.897  -5.332   4.103  1.00 36.65           O  
ATOM    654  ND2 ASN A  92      12.052  -6.970   5.066  1.00 32.81           N  
ATOM    655  N   SER A  93      14.757  -2.010   5.650  1.00 21.91           N  
ATOM    656  CA  SER A  93      15.977  -1.902   6.450  1.00 21.13           C  
ATOM    657  C   SER A  93      15.738  -1.190   7.781  1.00 19.38           C  
ATOM    658  O   SER A  93      16.125  -1.723   8.801  1.00 19.19           O  
ATOM    659  CB  SER A  93      17.150  -1.279   5.696  1.00 22.05           C  
ATOM    660  OG  SER A  93      16.851   0.058   5.318  1.00 23.75           O  
ATOM    661  N   VAL A  94      15.098  -0.020   7.754  1.00 17.94           N  
ATOM    662  CA  VAL A  94      14.743   0.703   9.001  1.00 16.37           C  
ATOM    663  C   VAL A  94      13.868  -0.188   9.891  1.00 15.92           C  
ATOM    664  O   VAL A  94      14.105  -0.338  11.097  1.00 15.20           O  
ATOM    665  CB  VAL A  94      14.088   2.082   8.717  1.00 16.48           C  
ATOM    666  CG1 VAL A  94      13.429   2.678   9.978  1.00 15.12           C  
ATOM    667  CG2 VAL A  94      15.129   3.075   8.176  1.00 17.58           C  
ATOM    668  N   ASP A  95      12.880  -0.841   9.291  1.00 15.61           N  
ATOM    669  CA  ASP A  95      11.968  -1.677  10.082  1.00 15.66           C  
ATOM    670  C   ASP A  95      12.666  -2.827  10.803  1.00 16.01           C  
ATOM    671  O   ASP A  95      12.380  -3.108  11.958  1.00 15.64           O  
ATOM    672  CB  ASP A  95      10.866  -2.205   9.198  1.00 15.37           C  
ATOM    673  CG  ASP A  95      10.171  -1.098   8.450  1.00 17.65           C  
ATOM    674  OD1 ASP A  95       9.253  -0.462   9.009  1.00 17.18           O  
ATOM    675  OD2 ASP A  95      10.571  -0.864   7.290  1.00 17.60           O  
ATOM    676  N   TYR A  96      13.558  -3.511  10.096  1.00 17.68           N  
ATOM    677  CA  TYR A  96      14.252  -4.641  10.700  1.00 18.78           C  
ATOM    678  C   TYR A  96      15.279  -4.218  11.752  1.00 17.47           C  
ATOM    679  O   TYR A  96      15.430  -4.877  12.794  1.00 17.57           O  
ATOM    680  CB  TYR A  96      14.763  -5.602   9.620  1.00 20.61           C  
ATOM    681  CG  TYR A  96      13.597  -6.509   9.245  1.00 23.61           C  
ATOM    682  CD1 TYR A  96      12.839  -6.276   8.088  1.00 24.46           C  
ATOM    683  CD2 TYR A  96      13.189  -7.536  10.102  1.00 25.19           C  
ATOM    684  CE1 TYR A  96      11.755  -7.058   7.782  1.00 24.88           C  
ATOM    685  CE2 TYR A  96      12.089  -8.347   9.781  1.00 28.78           C  
ATOM    686  CZ  TYR A  96      11.384  -8.089   8.620  1.00 25.93           C  
ATOM    687  OH  TYR A  96      10.306  -8.864   8.300  1.00 28.02           O  
ATOM    688  N   LYS A  97      15.884  -3.055  11.539  1.00 17.50           N  
ATOM    689  CA  LYS A  97      16.734  -2.467  12.574  1.00 16.58           C  
ATOM    690  C   LYS A  97      15.926  -2.058  13.809  1.00 17.09           C  
ATOM    691  O   LYS A  97      16.352  -2.294  14.931  1.00 16.84           O  
ATOM    692  CB  LYS A  97      17.511  -1.283  12.012  1.00 17.27           C  
ATOM    693  CG  LYS A  97      18.564  -1.718  10.997  1.00 19.49           C  
ATOM    694  CD  LYS A  97      19.352  -0.533  10.522  1.00 25.32           C  
ATOM    695  CE  LYS A  97      19.929  -0.732   9.113  1.00 29.55           C  
ATOM    696  NZ  LYS A  97      20.342   0.594   8.507  1.00 29.77           N  
ATOM    697  N   LEU A  98      14.759  -1.447  13.606  1.00 16.02           N  
ATOM    698  CA  LEU A  98      13.835  -1.198  14.728  1.00 17.05           C  
ATOM    699  C   LEU A  98      13.402  -2.465  15.439  1.00 17.83           C  
ATOM    700  O   LEU A  98      13.334  -2.493  16.659  1.00 17.73           O  
ATOM    701  CB  LEU A  98      12.604  -0.380  14.303  1.00 16.80           C  
ATOM    702  CG  LEU A  98      12.913   1.079  14.017  1.00 16.52           C  
ATOM    703  CD1 LEU A  98      11.719   1.746  13.297  1.00 18.29           C  
ATOM    704  CD2 LEU A  98      13.314   1.863  15.309  1.00 15.81           C  
ATOM    705  N   LYS A  99      13.112  -3.513  14.672  1.00 18.30           N  
ATOM    706  CA  LYS A  99      12.696  -4.806  15.245  1.00 21.24           C  
ATOM    707  C   LYS A  99      13.767  -5.377  16.191  1.00 20.64           C  
ATOM    708  O   LYS A  99      13.447  -5.853  17.272  1.00 21.12           O  
ATOM    709  CB  LYS A  99      12.410  -5.796  14.107  1.00 20.80           C  
ATOM    710  CG  LYS A  99      11.754  -7.111  14.532  1.00 24.37           C  
ATOM    711  CD  LYS A  99      11.431  -7.990  13.314  1.00 23.85           C  
ATOM    712  CE  LYS A  99      10.129  -7.558  12.633  1.00 27.67           C  
ATOM    713  NZ  LYS A  99       8.931  -8.125  13.348  1.00 28.87           N  
ATOM    714  N   GLU A 100      15.030  -5.327  15.761  1.00 21.04           N  
ATOM    715  CA  GLU A 100      16.180  -5.745  16.562  1.00 22.76           C  
ATOM    716  C   GLU A 100      16.170  -5.060  17.922  1.00 21.70           C  
ATOM    717  O   GLU A 100      16.472  -5.677  18.929  1.00 22.83           O  
ATOM    718  CB  GLU A 100      17.491  -5.378  15.860  1.00 23.59           C  
ATOM    719  CG  GLU A 100      18.016  -6.366  14.844  1.00 27.06           C  
ATOM    720  CD  GLU A 100      19.449  -6.017  14.421  1.00 27.67           C  
ATOM    721  OE1 GLU A 100      20.380  -6.781  14.777  1.00 34.02           O  
ATOM    722  OE2 GLU A 100      19.641  -4.967  13.746  1.00 31.98           O  
ATOM    723  N   ILE A 101      15.811  -3.784  17.931  1.00 20.32           N  
ATOM    724  CA  ILE A 101      15.886  -2.939  19.130  1.00 19.60           C  
ATOM    725  C   ILE A 101      14.623  -3.057  20.007  1.00 20.12           C  
ATOM    726  O   ILE A 101      14.714  -3.235  21.231  1.00 20.70           O  
ATOM    727  CB  ILE A 101      16.178  -1.441  18.747  1.00 19.20           C  
ATOM    728  CG1 ILE A 101      17.512  -1.270  18.021  1.00 18.74           C  
ATOM    729  CG2 ILE A 101      16.207  -0.543  19.983  1.00 18.76           C  
ATOM    730  CD1 ILE A 101      17.598   0.035  17.212  1.00 19.11           C  
ATOM    731  N   LEU A 102      13.458  -2.974  19.370  1.00 19.94           N  
ATOM    732  CA  LEU A 102      12.163  -2.936  20.050  1.00 20.55           C  
ATOM    733  C   LEU A 102      11.560  -4.297  20.387  1.00 21.65           C  
ATOM    734  O   LEU A 102      10.742  -4.386  21.311  1.00 21.22           O  
ATOM    735  CB  LEU A 102      11.130  -2.184  19.190  1.00 20.74           C  
ATOM    736  CG  LEU A 102      11.391  -0.715  18.843  1.00 20.21           C  
ATOM    737  CD1 LEU A 102      10.388  -0.264  17.821  1.00 21.29           C  
ATOM    738  CD2 LEU A 102      11.341   0.136  20.113  1.00 21.89           C  
ATOM    739  N   GLN A 103      11.905  -5.320  19.597  1.00 23.77           N  
ATOM    740  CA  GLN A 103      11.203  -6.610  19.623  1.00 26.08           C  
ATOM    741  C   GLN A 103       9.699  -6.413  19.399  1.00 26.47           C  
ATOM    742  O   GLN A 103       9.272  -6.150  18.280  1.00 27.11           O  
ATOM    743  CB  GLN A 103      11.490  -7.388  20.915  1.00 26.37           C  
ATOM    744  CG  GLN A 103      12.962  -7.709  21.152  1.00 31.14           C  
ATOM    745  CD  GLN A 103      13.598  -8.391  19.960  1.00 37.38           C  
ATOM    746  OE1 GLN A 103      13.066  -9.385  19.433  1.00 41.17           O  
ATOM    747  NE2 GLN A 103      14.742  -7.867  19.519  1.00 38.61           N  
ATOM    748  N   ASP A 104       8.910  -6.529  20.458  1.00 26.26           N  
ATOM    749  CA  ASP A 104       7.455  -6.428  20.351  1.00 26.71           C  
ATOM    750  C   ASP A 104       6.897  -5.085  20.846  1.00 25.28           C  
ATOM    751  O   ASP A 104       5.667  -4.909  20.973  1.00 26.61           O  
ATOM    752  CB  ASP A 104       6.809  -7.603  21.087  1.00 27.13           C  
ATOM    753  CG  ASP A 104       6.983  -8.922  20.339  1.00 30.52           C  
ATOM    754  OD1 ASP A 104       7.163  -8.879  19.103  1.00 33.60           O  
ATOM    755  OD2 ASP A 104       6.938  -9.994  20.984  1.00 35.37           O  
ATOM    756  N   LYS A 105       7.791  -4.135  21.102  1.00 22.75           N  
ATOM    757  CA  LYS A 105       7.393  -2.875  21.709  1.00 20.76           C  
ATOM    758  C   LYS A 105       7.169  -1.781  20.678  1.00 19.39           C  
ATOM    759  O   LYS A 105       7.760  -1.785  19.609  1.00 19.03           O  
ATOM    760  CB  LYS A 105       8.431  -2.422  22.730  1.00 20.71           C  
ATOM    761  CG  LYS A 105       8.478  -3.284  23.990  1.00 21.38           C  
ATOM    762  CD  LYS A 105       9.538  -2.782  24.971  1.00 20.76           C  
ATOM    763  CE  LYS A 105      10.947  -3.106  24.452  1.00 19.99           C  
ATOM    764  NZ  LYS A 105      11.244  -4.578  24.525  1.00 22.95           N  
ATOM    765  N   LYS A 106       6.295  -0.851  21.014  1.00 17.55           N  
ATOM    766  CA  LYS A 106       6.158   0.365  20.231  1.00 16.65           C  
ATOM    767  C   LYS A 106       6.881   1.528  20.937  1.00 15.67           C  
ATOM    768  O   LYS A 106       7.504   1.342  21.977  1.00 16.45           O  
ATOM    769  CB  LYS A 106       4.690   0.651  19.897  1.00 17.23           C  
ATOM    770  CG  LYS A 106       4.138  -0.341  18.849  1.00 18.44           C  
ATOM    771  CD  LYS A 106       2.854   0.148  18.260  1.00 20.51           C  
ATOM    772  CE  LYS A 106       2.247  -0.858  17.325  1.00 21.05           C  
ATOM    773  NZ  LYS A 106       1.028  -0.338  16.725  1.00 24.22           N  
ATOM    774  N   ILE A 107       6.864   2.690  20.306  1.00 14.02           N  
ATOM    775  CA  ILE A 107       7.737   3.782  20.650  1.00 13.46           C  
ATOM    776  C   ILE A 107       6.891   4.850  21.346  1.00 12.41           C  
ATOM    777  O   ILE A 107       5.890   5.256  20.817  1.00 12.58           O  
ATOM    778  CB  ILE A 107       8.372   4.378  19.350  1.00 12.09           C  
ATOM    779  CG1 ILE A 107       9.165   3.289  18.608  1.00 12.96           C  
ATOM    780  CG2 ILE A 107       9.290   5.559  19.670  1.00 12.46           C  
ATOM    781  CD1 ILE A 107       9.861   3.790  17.398  1.00 12.08           C  
ATOM    782  N   ASP A 108       7.300   5.301  22.522  1.00 12.99           N  
ATOM    783  CA  ASP A 108       6.493   6.249  23.284  1.00 12.41           C  
ATOM    784  C   ASP A 108       6.533   7.706  22.842  1.00 12.84           C  
ATOM    785  O   ASP A 108       5.546   8.439  23.011  1.00 13.19           O  
ATOM    786  CB  ASP A 108       6.879   6.160  24.755  1.00 13.65           C  
ATOM    787  CG  ASP A 108       6.707   4.773  25.295  1.00 15.06           C  
ATOM    788  OD1 ASP A 108       5.552   4.355  25.439  1.00 20.57           O  
ATOM    789  OD2 ASP A 108       7.721   4.072  25.509  1.00 15.08           O  
ATOM    790  N   ILE A 109       7.685   8.129  22.332  1.00 11.65           N  
ATOM    791  CA  ILE A 109       7.893   9.498  21.924  1.00 12.65           C  
ATOM    792  C   ILE A 109       8.608   9.481  20.596  1.00 11.91           C  
ATOM    793  O   ILE A 109       9.698   8.890  20.471  1.00 12.61           O  
ATOM    794  CB  ILE A 109       8.740  10.292  22.960  1.00 12.68           C  
ATOM    795  CG1 ILE A 109       8.108  10.211  24.348  1.00 13.18           C  
ATOM    796  CG2 ILE A 109       8.911  11.724  22.499  1.00 13.97           C  
ATOM    797  CD1 ILE A 109       9.075  10.628  25.501  1.00 14.96           C  
ATOM    798  N   ILE A 110       7.964  10.064  19.596  1.00 11.21           N  
ATOM    799  CA  ILE A 110       8.589  10.158  18.286  1.00 11.50           C  
ATOM    800  C   ILE A 110       8.741  11.634  17.956  1.00 11.45           C  
ATOM    801  O   ILE A 110       7.763  12.365  17.899  1.00 11.72           O  
ATOM    802  CB  ILE A 110       7.783   9.405  17.213  1.00 12.16           C  
ATOM    803  CG1 ILE A 110       7.792   7.898  17.503  1.00 12.70           C  
ATOM    804  CG2 ILE A 110       8.386   9.657  15.813  1.00 12.44           C  
ATOM    805  CD1 ILE A 110       6.851   7.104  16.539  1.00 12.13           C  
ATOM    806  N   LEU A 111       9.986  12.035  17.759  1.00 11.43           N  
ATOM    807  CA  LEU A 111      10.346  13.419  17.460  1.00 12.61           C  
ATOM    808  C   LEU A 111      10.928  13.483  16.051  1.00 12.43           C  
ATOM    809  O   LEU A 111      11.673  12.596  15.635  1.00 13.60           O  
ATOM    810  CB  LEU A 111      11.409  13.929  18.442  1.00 13.28           C  
ATOM    811  CG  LEU A 111      11.134  13.718  19.942  1.00 13.06           C  
ATOM    812  CD1 LEU A 111      12.338  14.067  20.826  1.00 14.28           C  
ATOM    813  CD2 LEU A 111       9.907  14.513  20.398  1.00 12.41           C  
ATOM    814  N   SER A 112      10.599  14.542  15.331  1.00 12.74           N  
ATOM    815  CA  SER A 112      11.243  14.785  14.058  1.00 12.94           C  
ATOM    816  C   SER A 112      11.666  16.236  13.918  1.00 13.61           C  
ATOM    817  O   SER A 112      10.838  17.150  13.957  1.00 13.60           O  
ATOM    818  CB  SER A 112      10.340  14.389  12.890  1.00 14.19           C  
ATOM    819  OG  SER A 112      10.905  14.850  11.691  1.00 14.95           O  
ATOM    820  N   ASP A 113      12.969  16.413  13.748  1.00 13.87           N  
ATOM    821  CA  ASP A 113      13.551  17.698  13.373  1.00 15.33           C  
ATOM    822  C   ASP A 113      14.006  17.646  11.908  1.00 15.58           C  
ATOM    823  O   ASP A 113      14.814  18.481  11.475  1.00 15.91           O  
ATOM    824  CB  ASP A 113      14.748  18.007  14.288  1.00 15.61           C  
ATOM    825  CG  ASP A 113      15.176  19.468  14.232  1.00 16.72           C  
ATOM    826  OD1 ASP A 113      14.280  20.338  14.101  1.00 18.73           O  
ATOM    827  OD2 ASP A 113      16.405  19.727  14.341  1.00 20.39           O  
ATOM    828  N   ALA A 114      13.484  16.692  11.127  1.00 16.31           N  
ATOM    829  CA  ALA A 114      13.886  16.553   9.716  1.00 17.64           C  
ATOM    830  C   ALA A 114      13.347  17.709   8.865  1.00 18.07           C  
ATOM    831  O   ALA A 114      12.319  18.297   9.181  1.00 17.65           O  
ATOM    832  CB  ALA A 114      13.390  15.216   9.132  1.00 17.02           C  
ATOM    833  N   ALA A 115      14.062  18.019   7.787  1.00 20.43           N  
ATOM    834  CA  ALA A 115      13.608  19.019   6.821  1.00 22.17           C  
ATOM    835  C   ALA A 115      14.146  18.663   5.436  1.00 24.67           C  
ATOM    836  O   ALA A 115      15.153  17.975   5.318  1.00 25.17           O  
ATOM    837  CB  ALA A 115      14.050  20.430   7.246  1.00 22.57           C  
ATOM    838  N   VAL A 116      13.432  19.084   4.400  1.00 26.54           N  
ATOM    839  CA  VAL A 116      13.871  18.864   3.024  1.00 29.20           C  
ATOM    840  C   VAL A 116      14.616  20.116   2.564  1.00 29.66           C  
ATOM    841  O   VAL A 116      14.225  21.215   2.936  1.00 29.70           O  
ATOM    842  CB  VAL A 116      12.683  18.511   2.090  1.00 29.09           C  
ATOM    843  CG1 VAL A 116      12.494  17.003   2.033  1.00 31.34           C  
ATOM    844  CG2 VAL A 116      11.385  19.164   2.556  1.00 31.25           C  
ATOM    845  N   PRO A 117      15.707  19.955   1.777  1.00 31.05           N  
ATOM    846  CA  PRO A 117      16.437  21.124   1.238  1.00 31.76           C  
ATOM    847  C   PRO A 117      15.517  22.107   0.520  1.00 31.08           C  
ATOM    848  O   PRO A 117      14.648  21.685  -0.245  1.00 31.98           O  
ATOM    849  CB  PRO A 117      17.407  20.500   0.225  1.00 31.83           C  
ATOM    850  CG  PRO A 117      17.628  19.098   0.744  1.00 32.54           C  
ATOM    851  CD  PRO A 117      16.319  18.677   1.354  1.00 31.49           C  
ATOM    852  N   CYS A 118      15.702  23.400   0.778  1.00 31.76           N  
ATOM    853  CA  CYS A 118      14.916  24.445   0.117  1.00 32.40           C  
ATOM    854  C   CYS A 118      15.376  24.762  -1.298  1.00 32.55           C  
ATOM    855  O   CYS A 118      16.570  24.965  -1.530  1.00 32.97           O  
ATOM    856  CB  CYS A 118      14.919  25.722   0.949  1.00 32.53           C  
ATOM    857  SG  CYS A 118      13.665  25.678   2.238  1.00 35.62           S  
ATOM    858  N   ILE A 119      14.426  24.821  -2.233  1.00 32.41           N  
ATOM    859  CA  ILE A 119      14.743  25.178  -3.631  1.00 32.22           C  
ATOM    860  C   ILE A 119      14.631  26.684  -3.908  1.00 31.91           C  
ATOM    861  O   ILE A 119      14.944  27.163  -5.011  1.00 32.91           O  
ATOM    862  CB  ILE A 119      13.903  24.364  -4.646  1.00 32.31           C  
ATOM    863  CG1 ILE A 119      12.455  24.887  -4.712  1.00 32.12           C  
ATOM    864  CG2 ILE A 119      13.969  22.881  -4.320  1.00 31.43           C  
ATOM    865  CD1 ILE A 119      11.581  24.175  -5.756  1.00 31.97           C  
ATOM    866  N   GLY A 120      14.208  27.438  -2.901  1.00 31.51           N  
ATOM    867  CA  GLY A 120      13.979  28.863  -3.079  1.00 30.46           C  
ATOM    868  C   GLY A 120      12.817  29.089  -4.028  1.00 29.39           C  
ATOM    869  O   GLY A 120      12.956  29.758  -5.056  1.00 29.81           O  
ATOM    870  N   ASN A 121      11.699  28.440  -3.730  1.00 27.32           N  
ATOM    871  CA  ASN A 121      10.383  28.863  -4.176  1.00 25.64           C  
ATOM    872  C   ASN A 121       9.476  28.482  -3.031  1.00 25.26           C  
ATOM    873  O   ASN A 121       9.200  27.294  -2.830  1.00 24.53           O  
ATOM    874  CB  ASN A 121       9.907  28.156  -5.437  1.00 25.35           C  
ATOM    875  CG  ASN A 121       8.575  28.716  -5.937  1.00 25.85           C  
ATOM    876  OD1 ASN A 121       8.329  29.932  -5.867  1.00 26.61           O  
ATOM    877  ND2 ASN A 121       7.712  27.840  -6.431  1.00 24.68           N  
ATOM    878  N   LYS A 122       9.049  29.487  -2.271  1.00 24.14           N  
ATOM    879  CA  LYS A 122       8.385  29.264  -0.982  1.00 23.86           C  
ATOM    880  C   LYS A 122       7.273  28.210  -1.050  1.00 22.25           C  
ATOM    881  O   LYS A 122       7.268  27.260  -0.260  1.00 20.27           O  
ATOM    882  CB  LYS A 122       7.837  30.585  -0.426  1.00 23.89           C  
ATOM    883  CG  LYS A 122       7.057  30.442   0.883  1.00 25.68           C  
ATOM    884  CD  LYS A 122       6.669  31.766   1.519  1.00 26.81           C  
ATOM    885  CE  LYS A 122       5.828  31.494   2.769  1.00 29.14           C  
ATOM    886  NZ  LYS A 122       6.314  32.224   3.976  1.00 31.73           N  
ATOM    887  N   ILE A 123       6.352  28.364  -2.000  1.00 21.13           N  
ATOM    888  CA  ILE A 123       5.196  27.459  -2.048  1.00 21.44           C  
ATOM    889  C   ILE A 123       5.620  26.026  -2.338  1.00 20.50           C  
ATOM    890  O   ILE A 123       5.094  25.101  -1.728  1.00 20.34           O  
ATOM    891  CB  ILE A 123       4.079  27.918  -3.043  1.00 21.37           C  
ATOM    892  CG1 ILE A 123       2.781  27.127  -2.821  1.00 21.16           C  
ATOM    893  CG2 ILE A 123       4.500  27.788  -4.500  1.00 23.72           C  
ATOM    894  CD1 ILE A 123       2.102  27.424  -1.492  1.00 22.15           C  
ATOM    895  N   ASP A 124       6.552  25.836  -3.267  1.00 20.17           N  
ATOM    896  CA  ASP A 124       7.056  24.489  -3.566  1.00 20.96           C  
ATOM    897  C   ASP A 124       7.734  23.882  -2.336  1.00 20.41           C  
ATOM    898  O   ASP A 124       7.557  22.704  -2.038  1.00 21.26           O  
ATOM    899  CB  ASP A 124       8.073  24.539  -4.707  1.00 21.11           C  
ATOM    900  CG  ASP A 124       7.445  24.411  -6.077  1.00 24.21           C  
ATOM    901  OD1 ASP A 124       6.509  23.599  -6.253  1.00 29.57           O  
ATOM    902  OD2 ASP A 124       7.922  25.104  -6.991  1.00 23.27           O  
ATOM    903  N   ASP A 125       8.523  24.695  -1.636  1.00 20.19           N  
ATOM    904  CA  ASP A 125       9.231  24.230  -0.450  1.00 20.12           C  
ATOM    905  C   ASP A 125       8.235  23.822   0.643  1.00 19.39           C  
ATOM    906  O   ASP A 125       8.462  22.849   1.358  1.00 20.00           O  
ATOM    907  CB  ASP A 125      10.188  25.311   0.076  1.00 20.43           C  
ATOM    908  CG  ASP A 125      11.408  25.490  -0.826  1.00 22.30           C  
ATOM    909  OD1 ASP A 125      11.754  24.551  -1.562  1.00 24.52           O  
ATOM    910  OD2 ASP A 125      12.005  26.583  -0.788  1.00 25.31           O  
ATOM    911  N   HIS A 126       7.134  24.561   0.746  1.00 17.52           N  
ATOM    912  CA  HIS A 126       6.078  24.196   1.698  1.00 17.53           C  
ATOM    913  C   HIS A 126       5.453  22.862   1.302  1.00 17.03           C  
ATOM    914  O   HIS A 126       5.294  21.978   2.152  1.00 16.34           O  
ATOM    915  CB  HIS A 126       5.015  25.287   1.791  1.00 17.72           C  
ATOM    916  CG  HIS A 126       3.829  24.898   2.621  1.00 18.51           C  
ATOM    917  ND1 HIS A 126       3.923  24.676   3.981  1.00 16.98           N  
ATOM    918  CD2 HIS A 126       2.550  24.625   2.277  1.00 18.69           C  
ATOM    919  CE1 HIS A 126       2.738  24.311   4.442  1.00 18.13           C  
ATOM    920  NE2 HIS A 126       1.885  24.282   3.433  1.00 19.69           N  
ATOM    921  N   LEU A 127       5.082  22.707   0.032  1.00 16.19           N  
ATOM    922  CA  LEU A 127       4.499  21.437  -0.438  1.00 16.30           C  
ATOM    923  C   LEU A 127       5.446  20.256  -0.217  1.00 16.56           C  
ATOM    924  O   LEU A 127       5.016  19.153   0.203  1.00 16.05           O  
ATOM    925  CB  LEU A 127       4.089  21.507  -1.918  1.00 16.61           C  
ATOM    926  CG  LEU A 127       3.214  20.349  -2.428  1.00 17.76           C  
ATOM    927  CD1 LEU A 127       1.880  20.399  -1.683  1.00 17.61           C  
ATOM    928  CD2 LEU A 127       3.038  20.444  -3.953  1.00 17.12           C  
ATOM    929  N   ASN A 128       6.734  20.469  -0.499  1.00 16.60           N  
ATOM    930  CA  ASN A 128       7.737  19.424  -0.242  1.00 16.49           C  
ATOM    931  C   ASN A 128       7.803  19.082   1.231  1.00 16.19           C  
ATOM    932  O   ASN A 128       7.977  17.920   1.590  1.00 15.52           O  
ATOM    933  CB  ASN A 128       9.135  19.852  -0.692  1.00 16.88           C  
ATOM    934  CG  ASN A 128       9.249  20.013  -2.185  1.00 19.15           C  
ATOM    935  OD1 ASN A 128       8.365  19.607  -2.933  1.00 23.01           O  
ATOM    936  ND2 ASN A 128      10.365  20.606  -2.630  1.00 22.04           N  
ATOM    937  N   SER A 129       7.737  20.113   2.068  1.00 15.76           N  
ATOM    938  CA  SER A 129       7.707  19.937   3.519  1.00 16.06           C  
ATOM    939  C   SER A 129       6.478  19.147   3.936  1.00 15.64           C  
ATOM    940  O   SER A 129       6.555  18.310   4.849  1.00 15.66           O  
ATOM    941  CB  SER A 129       7.728  21.299   4.226  1.00 15.80           C  
ATOM    942  OG  SER A 129       7.681  21.184   5.650  1.00 19.31           O  
ATOM    943  N   CYS A 130       5.339  19.451   3.324  1.00 14.65           N  
ATOM    944  CA  CYS A 130       4.103  18.692   3.590  1.00 15.23           C  
ATOM    945  C   CYS A 130       4.305  17.219   3.260  1.00 15.32           C  
ATOM    946  O   CYS A 130       3.906  16.326   4.016  1.00 14.74           O  
ATOM    947  CB  CYS A 130       2.962  19.272   2.756  1.00 15.50           C  
ATOM    948  SG  CYS A 130       2.416  20.849   3.421  1.00 18.69           S  
ATOM    949  N   GLU A 131       4.954  16.974   2.123  1.00 15.39           N  
ATOM    950  CA  GLU A 131       5.167  15.609   1.642  1.00 16.48           C  
ATOM    951  C   GLU A 131       6.021  14.833   2.646  1.00 15.01           C  
ATOM    952  O   GLU A 131       5.682  13.710   3.000  1.00 15.79           O  
ATOM    953  CB  GLU A 131       5.821  15.587   0.251  1.00 17.29           C  
ATOM    954  CG  GLU A 131       6.072  14.141  -0.223  1.00 20.08           C  
ATOM    955  CD  GLU A 131       6.700  14.033  -1.625  1.00 21.37           C  
ATOM    956  OE1 GLU A 131       7.649  14.794  -1.928  1.00 25.57           O  
ATOM    957  OE2 GLU A 131       6.251  13.147  -2.395  1.00 29.81           O  
ATOM    958  N   LEU A 132       7.092  15.466   3.131  1.00 14.82           N  
ATOM    959  CA  LEU A 132       7.972  14.853   4.120  1.00 13.51           C  
ATOM    960  C   LEU A 132       7.205  14.614   5.414  1.00 13.35           C  
ATOM    961  O   LEU A 132       7.339  13.554   6.034  1.00 12.90           O  
ATOM    962  CB  LEU A 132       9.199  15.731   4.382  1.00 13.14           C  
ATOM    963  CG  LEU A 132      10.159  15.211   5.470  1.00 14.64           C  
ATOM    964  CD1 LEU A 132      10.604  13.776   5.168  1.00 16.43           C  
ATOM    965  CD2 LEU A 132      11.347  16.122   5.563  1.00 13.88           C  
ATOM    966  N   THR A 133       6.412  15.600   5.818  1.00 13.05           N  
ATOM    967  CA  THR A 133       5.626  15.485   7.043  1.00 12.59           C  
ATOM    968  C   THR A 133       4.635  14.309   6.957  1.00 13.07           C  
ATOM    969  O   THR A 133       4.448  13.556   7.904  1.00 12.77           O  
ATOM    970  CB  THR A 133       4.904  16.808   7.339  1.00 14.04           C  
ATOM    971  OG1 THR A 133       5.902  17.812   7.582  1.00 16.45           O  
ATOM    972  CG2 THR A 133       4.040  16.658   8.584  1.00 15.74           C  
ATOM    973  N   LEU A 134       4.015  14.161   5.795  1.00 11.73           N  
ATOM    974  CA  LEU A 134       3.108  13.045   5.575  1.00 11.90           C  
ATOM    975  C   LEU A 134       3.869  11.710   5.637  1.00 12.19           C  
ATOM    976  O   LEU A 134       3.364  10.782   6.246  1.00 12.41           O  
ATOM    977  CB  LEU A 134       2.341  13.214   4.252  1.00 12.09           C  
ATOM    978  CG  LEU A 134       1.263  14.299   4.312  1.00 13.07           C  
ATOM    979  CD1 LEU A 134       0.752  14.630   2.902  1.00 15.79           C  
ATOM    980  CD2 LEU A 134       0.113  13.843   5.224  1.00 15.26           C  
ATOM    981  N   SER A 135       5.066  11.622   5.037  1.00 12.78           N  
ATOM    982  CA  SER A 135       5.875  10.394   5.065  1.00 14.37           C  
ATOM    983  C   SER A 135       6.233  10.012   6.493  1.00 13.89           C  
ATOM    984  O   SER A 135       6.063   8.856   6.899  1.00 13.54           O  
ATOM    985  CB  SER A 135       7.161  10.517   4.218  1.00 14.56           C  
ATOM    986  OG  SER A 135       6.808  10.606   2.846  1.00 16.94           O  
ATOM    987  N   ILE A 136       6.686  11.004   7.260  1.00 13.79           N  
ATOM    988  CA  ILE A 136       7.077  10.756   8.637  1.00 14.15           C  
ATOM    989  C   ILE A 136       5.847  10.383   9.459  1.00 13.41           C  
ATOM    990  O   ILE A 136       5.910   9.472  10.274  1.00 13.69           O  
ATOM    991  CB  ILE A 136       7.798  11.977   9.251  1.00 13.54           C  
ATOM    992  CG1 ILE A 136       9.159  12.178   8.572  1.00 15.60           C  
ATOM    993  CG2 ILE A 136       8.047  11.732  10.743  1.00 12.60           C  
ATOM    994  CD1 ILE A 136       9.756  13.553   8.841  1.00 17.96           C  
ATOM    995  N   THR A 137       4.719  11.062   9.231  1.00 12.90           N  
ATOM    996  CA  THR A 137       3.456  10.733   9.928  1.00 13.02           C  
ATOM    997  C   THR A 137       2.961   9.290   9.650  1.00 13.17           C  
ATOM    998  O   THR A 137       2.576   8.567  10.556  1.00 12.92           O  
ATOM    999  CB  THR A 137       2.386  11.784   9.587  1.00 13.71           C  
ATOM   1000  OG1 THR A 137       2.885  13.076   9.981  1.00 13.58           O  
ATOM   1001  CG2 THR A 137       1.018  11.475  10.271  1.00 13.22           C  
ATOM   1002  N   HIS A 138       3.057   8.873   8.388  1.00 12.16           N  
ATOM   1003  CA  HIS A 138       2.694   7.514   8.003  1.00 13.43           C  
ATOM   1004  C   HIS A 138       3.554   6.478   8.719  1.00 13.21           C  
ATOM   1005  O   HIS A 138       3.049   5.454   9.165  1.00 13.44           O  
ATOM   1006  CB  HIS A 138       2.838   7.372   6.492  1.00 13.41           C  
ATOM   1007  CG  HIS A 138       2.398   6.042   5.982  1.00 16.45           C  
ATOM   1008  ND1 HIS A 138       1.071   5.719   5.788  1.00 21.47           N  
ATOM   1009  CD2 HIS A 138       3.111   4.940   5.651  1.00 16.20           C  
ATOM   1010  CE1 HIS A 138       0.986   4.474   5.352  1.00 20.72           C  
ATOM   1011  NE2 HIS A 138       2.208   3.980   5.262  1.00 19.05           N  
ATOM   1012  N   PHE A 139       4.858   6.748   8.806  1.00 12.50           N  
ATOM   1013  CA  PHE A 139       5.785   5.878   9.503  1.00 12.53           C  
ATOM   1014  C   PHE A 139       5.466   5.890  11.021  1.00 12.90           C  
ATOM   1015  O   PHE A 139       5.387   4.837  11.686  1.00 12.12           O  
ATOM   1016  CB  PHE A 139       7.211   6.335   9.196  1.00 14.04           C  
ATOM   1017  CG  PHE A 139       8.231   5.796  10.139  1.00 13.10           C  
ATOM   1018  CD1 PHE A 139       8.750   4.531   9.958  1.00 15.19           C  
ATOM   1019  CD2 PHE A 139       8.622   6.538  11.252  1.00 15.96           C  
ATOM   1020  CE1 PHE A 139       9.688   4.019  10.828  1.00 15.79           C  
ATOM   1021  CE2 PHE A 139       9.569   6.033  12.150  1.00 20.21           C  
ATOM   1022  CZ  PHE A 139      10.100   4.775  11.933  1.00 17.87           C  
ATOM   1023  N   MET A 140       5.235   7.086  11.557  1.00 13.66           N  
ATOM   1024  CA  MET A 140       4.897   7.269  12.990  1.00 14.01           C  
ATOM   1025  C   MET A 140       3.703   6.404  13.416  1.00 14.69           C  
ATOM   1026  O   MET A 140       3.736   5.711  14.451  1.00 13.79           O  
ATOM   1027  CB  MET A 140       4.643   8.777  13.276  1.00 14.48           C  
ATOM   1028  CG  MET A 140       4.017   9.064  14.704  1.00 15.10           C  
ATOM   1029  SD  MET A 140       2.318   8.767  14.872  1.00 18.77           S  
ATOM   1030  CE  MET A 140       1.613   9.965  13.747  1.00 17.67           C  
ATOM   1031  N   GLU A 141       2.649   6.427  12.607  1.00 14.87           N  
ATOM   1032  CA  GLU A 141       1.448   5.670  12.905  1.00 16.03           C  
ATOM   1033  C   GLU A 141       1.705   4.189  13.126  1.00 15.41           C  
ATOM   1034  O   GLU A 141       0.976   3.534  13.884  1.00 16.14           O  
ATOM   1035  CB  GLU A 141       0.473   5.789  11.750  1.00 16.63           C  
ATOM   1036  CG  GLU A 141      -0.472   6.951  11.784  1.00 23.65           C  
ATOM   1037  CD  GLU A 141      -1.705   6.606  10.980  1.00 29.17           C  
ATOM   1038  OE1 GLU A 141      -1.550   6.402   9.761  1.00 29.46           O  
ATOM   1039  OE2 GLU A 141      -2.808   6.468  11.574  1.00 32.60           O  
ATOM   1040  N   GLN A 142       2.711   3.652  12.431  1.00 13.21           N  
ATOM   1041  CA  GLN A 142       3.051   2.231  12.555  1.00 13.14           C  
ATOM   1042  C   GLN A 142       3.729   1.925  13.861  1.00 13.37           C  
ATOM   1043  O   GLN A 142       3.514   0.849  14.412  1.00 14.43           O  
ATOM   1044  CB  GLN A 142       3.965   1.802  11.396  1.00 12.54           C  
ATOM   1045  CG  GLN A 142       3.314   1.994  10.005  1.00 12.52           C  
ATOM   1046  CD  GLN A 142       4.328   1.856   8.874  1.00 12.16           C  
ATOM   1047  OE1 GLN A 142       5.093   0.899   8.826  1.00 13.29           O  
ATOM   1048  NE2 GLN A 142       4.366   2.847   7.995  1.00 12.93           N  
ATOM   1049  N   TYR A 143       4.517   2.882  14.364  1.00 11.79           N  
ATOM   1050  CA  TYR A 143       5.455   2.608  15.478  1.00 12.11           C  
ATOM   1051  C   TYR A 143       5.102   3.261  16.807  1.00 12.42           C  
ATOM   1052  O   TYR A 143       5.658   2.881  17.822  1.00 13.50           O  
ATOM   1053  CB  TYR A 143       6.908   2.948  15.081  1.00 12.48           C  
ATOM   1054  CG  TYR A 143       7.428   1.917  14.094  1.00 12.09           C  
ATOM   1055  CD1 TYR A 143       7.900   0.698  14.551  1.00 13.70           C  
ATOM   1056  CD2 TYR A 143       7.396   2.167  12.723  1.00 11.44           C  
ATOM   1057  CE1 TYR A 143       8.341  -0.293  13.653  1.00 14.38           C  
ATOM   1058  CE2 TYR A 143       7.838   1.169  11.794  1.00 13.18           C  
ATOM   1059  CZ  TYR A 143       8.305  -0.037  12.287  1.00 13.68           C  
ATOM   1060  OH  TYR A 143       8.747  -1.051  11.436  1.00 16.17           O  
ATOM   1061  N   ILE A 144       4.170   4.201  16.792  1.00 12.82           N  
ATOM   1062  CA  ILE A 144       3.846   4.948  18.001  1.00 13.13           C  
ATOM   1063  C   ILE A 144       2.995   4.084  18.944  1.00 13.02           C  
ATOM   1064  O   ILE A 144       2.079   3.382  18.503  1.00 13.05           O  
ATOM   1065  CB  ILE A 144       3.128   6.292  17.697  1.00 13.23           C  
ATOM   1066  CG1 ILE A 144       3.118   7.190  18.943  1.00 16.39           C  
ATOM   1067  CG2 ILE A 144       1.722   6.089  17.163  1.00 14.42           C  
ATOM   1068  CD1 ILE A 144       4.360   7.884  19.157  1.00 20.78           C  
ATOM   1069  N   ASN A 145       3.325   4.153  20.229  1.00 13.24           N  
ATOM   1070  CA  ASN A 145       2.560   3.496  21.283  1.00 13.94           C  
ATOM   1071  C   ASN A 145       1.285   4.271  21.581  1.00 13.19           C  
ATOM   1072  O   ASN A 145       1.243   5.490  21.433  1.00 13.36           O  
ATOM   1073  CB  ASN A 145       3.385   3.469  22.555  1.00 14.63           C  
ATOM   1074  CG  ASN A 145       3.115   2.266  23.403  1.00 18.96           C  
ATOM   1075  OD1 ASN A 145       2.245   1.440  23.116  1.00 22.56           O  
ATOM   1076  ND2 ASN A 145       3.860   2.163  24.496  1.00 24.68           N  
ATOM   1077  N   ILE A 146       0.238   3.560  21.969  1.00 14.46           N  
ATOM   1078  CA  ILE A 146      -0.980   4.207  22.453  1.00 14.61           C  
ATOM   1079  C   ILE A 146      -0.566   5.094  23.602  1.00 14.05           C  
ATOM   1080  O   ILE A 146       0.252   4.709  24.446  1.00 14.68           O  
ATOM   1081  CB  ILE A 146      -2.005   3.166  22.931  1.00 16.11           C  
ATOM   1082  CG1 ILE A 146      -2.526   2.330  21.751  1.00 17.02           C  
ATOM   1083  CG2 ILE A 146      -3.154   3.842  23.707  1.00 17.64           C  
ATOM   1084  CD1 ILE A 146      -3.250   3.111  20.704  1.00 20.74           C  
ATOM   1085  N   GLY A 147      -1.048   6.327  23.570  1.00 13.14           N  
ATOM   1086  CA  GLY A 147      -0.699   7.278  24.633  1.00 13.05           C  
ATOM   1087  C   GLY A 147       0.556   8.062  24.306  1.00 12.64           C  
ATOM   1088  O   GLY A 147       0.955   8.953  25.055  1.00 11.90           O  
ATOM   1089  N   GLY A 148       1.185   7.736  23.164  1.00 11.94           N  
ATOM   1090  CA  GLY A 148       2.457   8.314  22.804  1.00 11.15           C  
ATOM   1091  C   GLY A 148       2.372   9.774  22.320  1.00 11.94           C  
ATOM   1092  O   GLY A 148       1.278  10.270  21.972  1.00 11.70           O  
ATOM   1093  N   THR A 149       3.537  10.422  22.343  1.00 13.06           N  
ATOM   1094  CA  THR A 149       3.740  11.823  21.898  1.00 12.69           C  
ATOM   1095  C   THR A 149       4.478  11.863  20.566  1.00 12.46           C  
ATOM   1096  O   THR A 149       5.429  11.129  20.341  1.00 12.09           O  
ATOM   1097  CB  THR A 149       4.551  12.630  22.967  1.00 13.69           C  
ATOM   1098  OG1 THR A 149       3.800  12.682  24.183  1.00 16.14           O  
ATOM   1099  CG2 THR A 149       4.867  14.063  22.520  1.00 14.59           C  
ATOM   1100  N   TYR A 150       4.044  12.753  19.691  1.00 12.24           N  
ATOM   1101  CA  TYR A 150       4.672  12.893  18.380  1.00 11.57           C  
ATOM   1102  C   TYR A 150       4.863  14.361  18.135  1.00 12.09           C  
ATOM   1103  O   TYR A 150       3.888  15.116  18.226  1.00 12.78           O  
ATOM   1104  CB  TYR A 150       3.725  12.321  17.340  1.00 11.75           C  
ATOM   1105  CG  TYR A 150       4.091  12.592  15.892  1.00 10.86           C  
ATOM   1106  CD1 TYR A 150       5.391  12.333  15.422  1.00 10.83           C  
ATOM   1107  CD2 TYR A 150       3.109  12.970  14.975  1.00 11.76           C  
ATOM   1108  CE1 TYR A 150       5.733  12.520  14.052  1.00 12.74           C  
ATOM   1109  CE2 TYR A 150       3.432  13.159  13.606  1.00 12.69           C  
ATOM   1110  CZ  TYR A 150       4.734  12.924  13.162  1.00 12.15           C  
ATOM   1111  OH  TYR A 150       5.071  13.107  11.831  1.00 13.15           O  
ATOM   1112  N   ILE A 151       6.098  14.762  17.844  1.00 12.45           N  
ATOM   1113  CA  ILE A 151       6.407  16.163  17.512  1.00 13.47           C  
ATOM   1114  C   ILE A 151       7.130  16.215  16.182  1.00 13.47           C  
ATOM   1115  O   ILE A 151       8.116  15.523  15.965  1.00 14.93           O  
ATOM   1116  CB  ILE A 151       7.233  16.848  18.627  1.00 13.28           C  
ATOM   1117  CG1 ILE A 151       6.468  16.718  19.940  1.00 14.83           C  
ATOM   1118  CG2 ILE A 151       7.438  18.311  18.244  1.00 16.28           C  
ATOM   1119  CD1 ILE A 151       7.170  17.353  21.125  1.00 19.22           C  
ATOM   1120  N   VAL A 152       6.607  17.001  15.246  1.00 12.95           N  
ATOM   1121  CA  VAL A 152       7.200  17.009  13.909  1.00 13.30           C  
ATOM   1122  C   VAL A 152       7.335  18.437  13.398  1.00 13.72           C  
ATOM   1123  O   VAL A 152       6.397  19.239  13.497  1.00 14.53           O  
ATOM   1124  CB  VAL A 152       6.392  16.119  12.925  1.00 13.05           C  
ATOM   1125  CG1 VAL A 152       4.920  16.552  12.838  1.00 13.25           C  
ATOM   1126  CG2 VAL A 152       7.055  16.064  11.537  1.00 13.70           C  
ATOM   1127  N   LYS A 153       8.512  18.736  12.863  1.00 14.40           N  
ATOM   1128  CA  LYS A 153       8.751  20.056  12.265  1.00 15.07           C  
ATOM   1129  C   LYS A 153       8.221  20.146  10.830  1.00 16.45           C  
ATOM   1130  O   LYS A 153       8.236  19.168  10.087  1.00 16.04           O  
ATOM   1131  CB  LYS A 153      10.249  20.386  12.308  1.00 15.87           C  
ATOM   1132  CG  LYS A 153      10.583  21.833  11.940  1.00 13.26           C  
ATOM   1133  CD  LYS A 153      12.078  22.115  12.104  1.00 14.40           C  
ATOM   1134  CE  LYS A 153      13.000  21.344  11.204  1.00 12.78           C  
ATOM   1135  NZ  LYS A 153      14.430  21.626  11.558  1.00 15.98           N  
ATOM   1136  N   MET A 154       7.762  21.334  10.442  1.00 17.67           N  
ATOM   1137  CA  MET A 154       7.482  21.574   9.022  1.00 19.33           C  
ATOM   1138  C   MET A 154       7.593  23.058   8.728  1.00 20.05           C  
ATOM   1139  O   MET A 154       7.553  23.883   9.671  1.00 20.89           O  
ATOM   1140  CB  MET A 154       6.093  21.077   8.632  1.00 18.88           C  
ATOM   1141  CG  MET A 154       4.939  21.924   9.179  1.00 18.51           C  
ATOM   1142  SD  MET A 154       3.328  21.437   8.501  1.00 20.89           S  
ATOM   1143  CE  MET A 154       3.637  21.533   6.731  1.00 23.05           C  
ATOM   1144  N   TYR A 155       7.733  23.389   7.440  1.00 20.93           N  
ATOM   1145  CA  TYR A 155       7.600  24.795   7.010  1.00 22.34           C  
ATOM   1146  C   TYR A 155       6.148  25.196   7.085  1.00 22.01           C  
ATOM   1147  O   TYR A 155       5.297  24.571   6.450  1.00 21.57           O  
ATOM   1148  CB  TYR A 155       8.141  25.033   5.589  1.00 24.20           C  
ATOM   1149  CG  TYR A 155       9.644  24.972   5.525  1.00 27.56           C  
ATOM   1150  CD1 TYR A 155      10.431  25.872   6.248  1.00 29.06           C  
ATOM   1151  CD2 TYR A 155      10.285  23.995   4.762  1.00 28.66           C  
ATOM   1152  CE1 TYR A 155      11.824  25.797   6.205  1.00 29.55           C  
ATOM   1153  CE2 TYR A 155      11.672  23.914   4.718  1.00 31.08           C  
ATOM   1154  CZ  TYR A 155      12.429  24.821   5.439  1.00 29.52           C  
ATOM   1155  OH  TYR A 155      13.801  24.750   5.396  1.00 30.25           O  
ATOM   1156  N   LEU A 156       5.861  26.239   7.865  1.00 21.55           N  
ATOM   1157  CA  LEU A 156       4.507  26.746   7.997  1.00 21.63           C  
ATOM   1158  C   LEU A 156       4.003  27.252   6.655  1.00 21.18           C  
ATOM   1159  O   LEU A 156       4.744  27.892   5.888  1.00 21.90           O  
ATOM   1160  CB  LEU A 156       4.438  27.877   9.025  1.00 21.31           C  
ATOM   1161  CG  LEU A 156       3.092  28.599   9.238  1.00 23.27           C  
ATOM   1162  CD1 LEU A 156       2.079  27.760   9.984  1.00 22.07           C  
ATOM   1163  CD2 LEU A 156       3.287  29.903  10.008  1.00 23.14           C  
ATOM   1164  N   GLY A 157       2.740  26.974   6.385  1.00 19.52           N  
ATOM   1165  CA  GLY A 157       2.136  27.457   5.148  1.00 19.40           C  
ATOM   1166  C   GLY A 157       0.726  26.996   4.947  1.00 19.62           C  
ATOM   1167  O   GLY A 157       0.040  26.600   5.885  1.00 19.10           O  
ATOM   1168  N   SER A 158       0.294  27.060   3.698  1.00 19.28           N  
ATOM   1169  CA  SER A 158      -1.115  26.898   3.377  1.00 20.56           C  
ATOM   1170  C   SER A 158      -1.740  25.586   3.858  1.00 18.51           C  
ATOM   1171  O   SER A 158      -2.932  25.546   4.162  1.00 19.34           O  
ATOM   1172  CB  SER A 158      -1.337  27.121   1.874  1.00 21.42           C  
ATOM   1173  OG  SER A 158      -1.389  25.936   1.114  1.00 22.00           O  
ATOM   1174  N   GLN A 159      -0.928  24.526   3.936  1.00 17.17           N  
ATOM   1175  CA  GLN A 159      -1.419  23.193   4.285  1.00 16.36           C  
ATOM   1176  C   GLN A 159      -1.224  22.811   5.747  1.00 15.63           C  
ATOM   1177  O   GLN A 159      -1.649  21.748   6.179  1.00 15.10           O  
ATOM   1178  CB  GLN A 159      -0.709  22.124   3.441  1.00 15.36           C  
ATOM   1179  CG  GLN A 159      -0.884  22.357   1.936  1.00 15.12           C  
ATOM   1180  CD  GLN A 159      -2.337  22.238   1.537  1.00 13.60           C  
ATOM   1181  OE1 GLN A 159      -2.911  21.163   1.605  1.00 15.70           O  
ATOM   1182  NE2 GLN A 159      -2.941  23.349   1.140  1.00 16.24           N  
ATOM   1183  N   THR A 160      -0.557  23.659   6.506  1.00 15.39           N  
ATOM   1184  CA  THR A 160      -0.283  23.335   7.893  1.00 16.42           C  
ATOM   1185  C   THR A 160      -1.550  22.962   8.653  1.00 16.87           C  
ATOM   1186  O   THR A 160      -1.594  21.941   9.355  1.00 15.71           O  
ATOM   1187  CB  THR A 160       0.501  24.483   8.573  1.00 16.18           C  
ATOM   1188  OG1 THR A 160       1.738  24.639   7.885  1.00 15.82           O  
ATOM   1189  CG2 THR A 160       0.803  24.166  10.038  1.00 17.93           C  
ATOM   1190  N   ASN A 161      -2.597  23.767   8.519  1.00 18.08           N  
ATOM   1191  CA  ASN A 161      -3.774  23.468   9.294  1.00 19.41           C  
ATOM   1192  C   ASN A 161      -4.490  22.191   8.856  1.00 18.60           C  
ATOM   1193  O   ASN A 161      -5.029  21.456   9.692  1.00 18.22           O  
ATOM   1194  CB  ASN A 161      -4.710  24.666   9.393  1.00 20.46           C  
ATOM   1195  CG  ASN A 161      -5.069  24.959  10.826  1.00 25.88           C  
ATOM   1196  OD1 ASN A 161      -6.183  24.670  11.273  1.00 31.12           O  
ATOM   1197  ND2 ASN A 161      -4.092  25.456  11.588  1.00 29.72           N  
ATOM   1198  N   ASN A 162      -4.451  21.897   7.558  1.00 17.77           N  
ATOM   1199  CA  ASN A 162      -4.934  20.603   7.084  1.00 18.13           C  
ATOM   1200  C   ASN A 162      -4.228  19.446   7.805  1.00 16.54           C  
ATOM   1201  O   ASN A 162      -4.866  18.469   8.227  1.00 15.85           O  
ATOM   1202  CB  ASN A 162      -4.723  20.453   5.582  1.00 18.43           C  
ATOM   1203  CG  ASN A 162      -5.581  21.388   4.753  1.00 20.77           C  
ATOM   1204  OD1 ASN A 162      -6.652  21.879   5.185  1.00 24.24           O  
ATOM   1205  ND2 ASN A 162      -5.112  21.649   3.537  1.00 22.01           N  
ATOM   1206  N   LEU A 163      -2.911  19.564   7.934  1.00 15.44           N  
ATOM   1207  CA  LEU A 163      -2.115  18.514   8.571  1.00 15.29           C  
ATOM   1208  C   LEU A 163      -2.438  18.444  10.047  1.00 15.30           C  
ATOM   1209  O   LEU A 163      -2.558  17.356  10.634  1.00 14.88           O  
ATOM   1210  CB  LEU A 163      -0.622  18.777   8.355  1.00 15.11           C  
ATOM   1211  CG  LEU A 163      -0.183  18.535   6.902  1.00 18.90           C  
ATOM   1212  CD1 LEU A 163       1.319  18.605   6.786  1.00 19.62           C  
ATOM   1213  CD2 LEU A 163      -0.655  17.203   6.412  1.00 21.87           C  
ATOM   1214  N   LYS A 164      -2.603  19.603  10.646  1.00 15.33           N  
ATOM   1215  CA  LYS A 164      -2.973  19.639  12.069  1.00 16.64           C  
ATOM   1216  C   LYS A 164      -4.295  18.896  12.291  1.00 16.39           C  
ATOM   1217  O   LYS A 164      -4.402  18.037  13.173  1.00 15.60           O  
ATOM   1218  CB  LYS A 164      -3.057  21.077  12.537  1.00 17.69           C  
ATOM   1219  CG  LYS A 164      -3.293  21.214  14.016  1.00 20.47           C  
ATOM   1220  CD  LYS A 164      -3.382  22.690  14.354  1.00 25.97           C  
ATOM   1221  CE  LYS A 164      -3.594  22.894  15.811  1.00 28.85           C  
ATOM   1222  NZ  LYS A 164      -3.497  24.366  16.110  1.00 30.73           N  
ATOM   1223  N   THR A 165      -5.281  19.161  11.429  1.00 15.95           N  
ATOM   1224  CA  THR A 165      -6.595  18.523  11.538  1.00 16.22           C  
ATOM   1225  C   THR A 165      -6.502  17.023  11.319  1.00 15.13           C  
ATOM   1226  O   THR A 165      -7.146  16.217  12.005  1.00 15.39           O  
ATOM   1227  CB  THR A 165      -7.578  19.168  10.577  1.00 17.26           C  
ATOM   1228  OG1 THR A 165      -7.786  20.514  11.014  1.00 17.78           O  
ATOM   1229  CG2 THR A 165      -8.901  18.414  10.559  1.00 19.14           C  
ATOM   1230  N   TYR A 166      -5.652  16.641  10.381  1.00 15.04           N  
ATOM   1231  CA  TYR A 166      -5.446  15.236  10.138  1.00 15.65           C  
ATOM   1232  C   TYR A 166      -4.901  14.552  11.403  1.00 14.74           C  
ATOM   1233  O   TYR A 166      -5.363  13.478  11.803  1.00 14.95           O  
ATOM   1234  CB  TYR A 166      -4.482  15.072   8.961  1.00 16.28           C  
ATOM   1235  CG  TYR A 166      -4.224  13.641   8.603  1.00 18.13           C  
ATOM   1236  CD1 TYR A 166      -5.261  12.786   8.244  1.00 19.98           C  
ATOM   1237  CD2 TYR A 166      -2.924  13.138   8.614  1.00 19.79           C  
ATOM   1238  CE1 TYR A 166      -5.009  11.447   7.903  1.00 21.21           C  
ATOM   1239  CE2 TYR A 166      -2.668  11.821   8.273  1.00 22.89           C  
ATOM   1240  CZ  TYR A 166      -3.709  10.983   7.928  1.00 22.14           C  
ATOM   1241  OH  TYR A 166      -3.406   9.678   7.595  1.00 24.60           O  
ATOM   1242  N   LEU A 167      -3.939  15.194  12.054  1.00 15.20           N  
ATOM   1243  CA  LEU A 167      -3.333  14.621  13.264  1.00 13.76           C  
ATOM   1244  C   LEU A 167      -4.318  14.549  14.437  1.00 14.94           C  
ATOM   1245  O   LEU A 167      -4.258  13.621  15.232  1.00 13.97           O  
ATOM   1246  CB  LEU A 167      -2.075  15.405  13.649  1.00 14.61           C  
ATOM   1247  CG  LEU A 167      -0.907  15.150  12.683  1.00 12.65           C  
ATOM   1248  CD1 LEU A 167       0.134  16.240  12.783  1.00 14.41           C  
ATOM   1249  CD2 LEU A 167      -0.246  13.783  12.895  1.00 12.12           C  
ATOM   1250  N   LYS A 168      -5.232  15.516  14.500  1.00 15.74           N  
ATOM   1251  CA  LYS A 168      -6.289  15.549  15.515  1.00 17.56           C  
ATOM   1252  C   LYS A 168      -7.209  14.356  15.370  1.00 18.38           C  
ATOM   1253  O   LYS A 168      -7.968  14.024  16.280  1.00 19.22           O  
ATOM   1254  CB  LYS A 168      -7.092  16.837  15.405  1.00 17.76           C  
ATOM   1255  CG  LYS A 168      -6.378  18.053  15.948  1.00 19.72           C  
ATOM   1256  CD  LYS A 168      -7.233  19.287  15.847  1.00 20.89           C  
ATOM   1257  CE  LYS A 168      -6.545  20.463  16.497  1.00 25.99           C  
ATOM   1258  NZ  LYS A 168      -7.472  21.639  16.478  1.00 27.63           N  
ATOM   1259  N   GLY A 169      -7.138  13.688  14.221  1.00 18.96           N  
ATOM   1260  CA  GLY A 169      -7.864  12.457  14.026  1.00 20.27           C  
ATOM   1261  C   GLY A 169      -7.208  11.245  14.657  1.00 21.75           C  
ATOM   1262  O   GLY A 169      -7.802  10.172  14.685  1.00 23.59           O  
ATOM   1263  N   MET A 170      -5.991  11.387  15.175  1.00 20.27           N  
ATOM   1264  CA  MET A 170      -5.366  10.244  15.807  1.00 20.83           C  
ATOM   1265  C   MET A 170      -4.764  10.493  17.193  1.00 18.31           C  
ATOM   1266  O   MET A 170      -4.336   9.547  17.850  1.00 17.97           O  
ATOM   1267  CB  MET A 170      -4.403   9.532  14.852  1.00 20.65           C  
ATOM   1268  CG  MET A 170      -3.225  10.301  14.400  1.00 23.79           C  
ATOM   1269  SD  MET A 170      -2.558   9.498  12.898  1.00 27.97           S  
ATOM   1270  CE  MET A 170      -2.910  10.727  11.670  1.00 28.61           C  
ATOM   1271  N   PHE A 171      -4.720  11.758  17.599  1.00 16.11           N  
ATOM   1272  CA  PHE A 171      -4.228  12.156  18.915  1.00 15.50           C  
ATOM   1273  C   PHE A 171      -5.304  12.899  19.689  1.00 15.78           C  
ATOM   1274  O   PHE A 171      -6.121  13.623  19.112  1.00 16.76           O  
ATOM   1275  CB  PHE A 171      -3.020  13.085  18.791  1.00 14.20           C  
ATOM   1276  CG  PHE A 171      -1.789  12.410  18.305  1.00 14.16           C  
ATOM   1277  CD1 PHE A 171      -0.863  11.882  19.202  1.00 11.15           C  
ATOM   1278  CD2 PHE A 171      -1.557  12.277  16.925  1.00 13.48           C  
ATOM   1279  CE1 PHE A 171       0.277  11.253  18.750  1.00 13.08           C  
ATOM   1280  CE2 PHE A 171      -0.408  11.644  16.448  1.00 14.36           C  
ATOM   1281  CZ  PHE A 171       0.527  11.123  17.367  1.00 11.95           C  
ATOM   1282  N   GLN A 172      -5.256  12.775  21.009  1.00 15.88           N  
ATOM   1283  CA  GLN A 172      -6.191  13.536  21.815  1.00 16.71           C  
ATOM   1284  C   GLN A 172      -6.070  15.031  21.563  1.00 17.19           C  
ATOM   1285  O   GLN A 172      -7.098  15.701  21.407  1.00 18.07           O  
ATOM   1286  CB  GLN A 172      -5.992  13.239  23.284  1.00 15.44           C  
ATOM   1287  CG  GLN A 172      -7.046  13.930  24.146  1.00 16.78           C  
ATOM   1288  CD  GLN A 172      -6.645  13.910  25.582  1.00 16.12           C  
ATOM   1289  OE1 GLN A 172      -5.737  13.186  25.953  1.00 16.68           O  
ATOM   1290  NE2 GLN A 172      -7.284  14.751  26.410  1.00 16.53           N  
ATOM   1291  N   LEU A 173      -4.837  15.552  21.542  1.00 17.58           N  
ATOM   1292  CA  LEU A 173      -4.611  16.993  21.339  1.00 19.40           C  
ATOM   1293  C   LEU A 173      -3.459  17.246  20.387  1.00 18.30           C  
ATOM   1294  O   LEU A 173      -2.459  16.536  20.416  1.00 18.09           O  
ATOM   1295  CB  LEU A 173      -4.309  17.754  22.639  1.00 19.31           C  
ATOM   1296  CG  LEU A 173      -4.692  17.477  24.098  1.00 24.46           C  
ATOM   1297  CD1 LEU A 173      -3.586  16.712  24.793  1.00 25.97           C  
ATOM   1298  CD2 LEU A 173      -4.892  18.823  24.811  1.00 23.16           C  
ATOM   1299  N   VAL A 174      -3.575  18.310  19.600  1.00 17.04           N  
ATOM   1300  CA  VAL A 174      -2.507  18.725  18.706  1.00 18.33           C  
ATOM   1301  C   VAL A 174      -2.348  20.233  18.767  1.00 19.41           C  
ATOM   1302  O   VAL A 174      -3.333  20.964  18.597  1.00 19.96           O  
ATOM   1303  CB  VAL A 174      -2.785  18.310  17.231  1.00 17.74           C  
ATOM   1304  CG1 VAL A 174      -1.631  18.750  16.338  1.00 19.74           C  
ATOM   1305  CG2 VAL A 174      -2.973  16.788  17.125  1.00 18.14           C  
ATOM   1306  N   HIS A 175      -1.115  20.672  19.002  1.00 20.69           N  
ATOM   1307  CA  HIS A 175      -0.779  22.097  19.180  1.00 22.85           C  
ATOM   1308  C   HIS A 175       0.197  22.526  18.102  1.00 23.06           C  
ATOM   1309  O   HIS A 175       1.073  21.759  17.711  1.00 22.98           O  
ATOM   1310  CB  HIS A 175      -0.152  22.353  20.560  1.00 23.71           C  
ATOM   1311  CG  HIS A 175      -0.915  21.753  21.700  1.00 29.47           C  
ATOM   1312  ND1 HIS A 175      -0.731  20.451  22.123  1.00 34.88           N  
ATOM   1313  CD2 HIS A 175      -1.872  22.276  22.505  1.00 34.00           C  
ATOM   1314  CE1 HIS A 175      -1.539  20.201  23.140  1.00 37.17           C  
ATOM   1315  NE2 HIS A 175      -2.243  21.292  23.391  1.00 37.08           N  
ATOM   1316  N   THR A 176       0.039  23.743  17.592  1.00 23.34           N  
ATOM   1317  CA  THR A 176       1.067  24.326  16.751  1.00 24.70           C  
ATOM   1318  C   THR A 176       1.899  25.283  17.615  1.00 25.39           C  
ATOM   1319  O   THR A 176       1.343  26.119  18.354  1.00 24.44           O  
ATOM   1320  CB  THR A 176       0.462  25.077  15.550  1.00 25.75           C  
ATOM   1321  OG1 THR A 176      -0.519  24.253  14.916  1.00 27.55           O  
ATOM   1322  CG2 THR A 176       1.541  25.386  14.538  1.00 27.11           C  
ATOM   1323  N   THR A 177       3.221  25.148  17.546  1.00 24.95           N  
ATOM   1324  CA  THR A 177       4.107  26.046  18.282  1.00 26.25           C  
ATOM   1325  C   THR A 177       4.237  27.369  17.516  1.00 27.20           C  
ATOM   1326  O   THR A 177       3.803  27.467  16.377  1.00 27.13           O  
ATOM   1327  CB  THR A 177       5.499  25.423  18.462  1.00 25.95           C  
ATOM   1328  OG1 THR A 177       6.152  25.353  17.190  1.00 23.02           O  
ATOM   1329  CG2 THR A 177       5.377  24.027  19.032  1.00 25.18           C  
ATOM   1330  N   LYS A 178       4.858  28.364  18.145  1.00 29.15           N  
ATOM   1331  CA  LYS A 178       5.123  29.665  17.518  1.00 31.35           C  
ATOM   1332  C   LYS A 178       6.148  29.588  16.374  1.00 32.04           C  
ATOM   1333  O   LYS A 178       7.212  28.995  16.548  1.00 32.16           O  
ATOM   1334  CB  LYS A 178       5.594  30.664  18.584  1.00 31.87           C  
ATOM   1335  CG  LYS A 178       5.608  32.114  18.116  1.00 34.08           C  
ATOM   1336  CD  LYS A 178       4.185  32.663  17.942  1.00 37.99           C  
ATOM   1337  CE  LYS A 178       4.175  34.165  17.620  1.00 39.56           C  
ATOM   1338  NZ  LYS A 178       4.277  34.449  16.150  1.00 40.71           N  
ATOM   1339  N   PRO A 179       5.817  30.166  15.193  1.00 33.20           N  
ATOM   1340  CA  PRO A 179       6.720  30.164  14.028  1.00 34.00           C  
ATOM   1341  C   PRO A 179       8.124  30.730  14.316  1.00 35.09           C  
ATOM   1342  O   PRO A 179       8.268  31.648  15.134  1.00 35.27           O  
ATOM   1343  CB  PRO A 179       5.997  31.059  13.013  1.00 33.73           C  
ATOM   1344  CG  PRO A 179       4.586  31.043  13.415  1.00 33.59           C  
ATOM   1345  CD  PRO A 179       4.535  30.829  14.891  1.00 33.10           C  
ATOM   1346  N   LYS A 180       9.134  30.188  13.638  1.00 36.02           N  
ATOM   1347  CA  LYS A 180      10.524  30.638  13.803  1.00 37.33           C  
ATOM   1348  C   LYS A 180      11.199  30.900  12.456  1.00 37.57           C  
ATOM   1349  O   LYS A 180      11.100  30.085  11.537  1.00 37.74           O  
ATOM   1350  CB  LYS A 180      11.340  29.625  14.629  1.00 37.56           C  
ATOM   1351  CG  LYS A 180      11.081  29.685  16.144  1.00 38.27           C  
ATOM   1352  CD  LYS A 180      11.600  28.447  16.880  1.00 38.00           C  
ATOM   1353  CE  LYS A 180      11.948  28.766  18.351  1.00 38.90           C  
ATOM   1354  NZ  LYS A 180      10.838  29.394  19.151  1.00 39.42           N  
ATOM   1355  N   SER A 186      10.594  31.370   4.684  1.00 36.93           N  
ATOM   1356  CA  SER A 186      10.187  30.020   5.055  1.00 36.51           C  
ATOM   1357  C   SER A 186      10.316  29.843   6.581  1.00 35.49           C  
ATOM   1358  O   SER A 186      11.368  29.442   7.089  1.00 35.76           O  
ATOM   1359  CB  SER A 186      11.040  28.997   4.292  1.00 37.21           C  
ATOM   1360  OG  SER A 186      10.244  28.129   3.493  1.00 38.84           O  
ATOM   1361  N   ARG A 187       9.242  30.185   7.296  1.00 34.20           N  
ATOM   1362  CA  ARG A 187       9.124  29.987   8.757  1.00 32.15           C  
ATOM   1363  C   ARG A 187       8.806  28.523   9.103  1.00 30.91           C  
ATOM   1364  O   ARG A 187       8.101  27.846   8.357  1.00 31.33           O  
ATOM   1365  CB  ARG A 187       8.008  30.867   9.319  1.00 32.89           C  
ATOM   1366  CG  ARG A 187       8.349  32.340   9.513  1.00 32.82           C  
ATOM   1367  CD  ARG A 187       7.186  33.183   9.059  1.00 35.97           C  
ATOM   1368  NE  ARG A 187       6.167  33.401  10.083  1.00 37.59           N  
ATOM   1369  CZ  ARG A 187       4.866  33.545   9.826  1.00 38.81           C  
ATOM   1370  NH1 ARG A 187       4.013  33.762  10.819  1.00 39.62           N  
ATOM   1371  NH2 ARG A 187       4.407  33.462   8.576  1.00 39.52           N  
ATOM   1372  N   GLU A 188       9.313  28.054  10.243  1.00 28.73           N  
ATOM   1373  CA  GLU A 188       9.105  26.673  10.693  1.00 26.33           C  
ATOM   1374  C   GLU A 188       8.327  26.596  11.993  1.00 24.27           C  
ATOM   1375  O   GLU A 188       8.439  27.468  12.854  1.00 23.46           O  
ATOM   1376  CB  GLU A 188      10.435  25.966  10.878  1.00 27.08           C  
ATOM   1377  CG  GLU A 188      11.044  25.462   9.582  1.00 29.55           C  
ATOM   1378  CD  GLU A 188      12.450  24.950   9.779  1.00 33.74           C  
ATOM   1379  OE1 GLU A 188      13.089  25.339  10.782  1.00 34.94           O  
ATOM   1380  OE2 GLU A 188      12.913  24.152   8.923  1.00 37.14           O  
ATOM   1381  N   ILE A 189       7.523  25.544  12.128  1.00 20.94           N  
ATOM   1382  CA  ILE A 189       6.750  25.319  13.342  1.00 18.92           C  
ATOM   1383  C   ILE A 189       6.918  23.857  13.679  1.00 17.60           C  
ATOM   1384  O   ILE A 189       7.415  23.093  12.845  1.00 16.21           O  
ATOM   1385  CB  ILE A 189       5.229  25.629  13.175  1.00 19.35           C  
ATOM   1386  CG1 ILE A 189       4.613  24.875  11.975  1.00 19.88           C  
ATOM   1387  CG2 ILE A 189       4.962  27.148  13.041  1.00 19.86           C  
ATOM   1388  CD1 ILE A 189       3.852  23.618  12.377  1.00 24.49           C  
ATOM   1389  N   TYR A 190       6.532  23.493  14.894  1.00 17.00           N  
ATOM   1390  CA  TYR A 190       6.380  22.088  15.252  1.00 17.56           C  
ATOM   1391  C   TYR A 190       4.914  21.803  15.515  1.00 16.51           C  
ATOM   1392  O   TYR A 190       4.229  22.616  16.129  1.00 17.19           O  
ATOM   1393  CB  TYR A 190       7.221  21.732  16.482  1.00 18.23           C  
ATOM   1394  CG  TYR A 190       8.709  21.823  16.259  1.00 18.57           C  
ATOM   1395  CD1 TYR A 190       9.436  20.726  15.764  1.00 18.31           C  
ATOM   1396  CD2 TYR A 190       9.403  23.006  16.545  1.00 19.75           C  
ATOM   1397  CE1 TYR A 190      10.805  20.791  15.575  1.00 19.16           C  
ATOM   1398  CE2 TYR A 190      10.787  23.086  16.350  1.00 19.29           C  
ATOM   1399  CZ  TYR A 190      11.475  21.982  15.857  1.00 20.20           C  
ATOM   1400  OH  TYR A 190      12.840  22.098  15.672  1.00 21.74           O  
ATOM   1401  N   LEU A 191       4.437  20.643  15.046  1.00 15.41           N  
ATOM   1402  CA  LEU A 191       3.129  20.138  15.435  1.00 15.17           C  
ATOM   1403  C   LEU A 191       3.378  19.190  16.612  1.00 14.91           C  
ATOM   1404  O   LEU A 191       4.111  18.223  16.476  1.00 15.06           O  
ATOM   1405  CB  LEU A 191       2.441  19.416  14.282  1.00 16.09           C  
ATOM   1406  CG  LEU A 191       2.173  20.288  13.040  1.00 16.95           C  
ATOM   1407  CD1 LEU A 191       1.987  19.417  11.765  1.00 19.46           C  
ATOM   1408  CD2 LEU A 191       0.975  21.198  13.261  1.00 21.61           C  
ATOM   1409  N   VAL A 192       2.838  19.550  17.766  1.00 14.06           N  
ATOM   1410  CA  VAL A 192       3.001  18.791  19.008  1.00 13.85           C  
ATOM   1411  C   VAL A 192       1.746  17.985  19.275  1.00 14.23           C  
ATOM   1412  O   VAL A 192       0.663  18.547  19.505  1.00 14.27           O  
ATOM   1413  CB  VAL A 192       3.294  19.752  20.201  1.00 14.77           C  
ATOM   1414  CG1 VAL A 192       3.485  18.942  21.479  1.00 14.74           C  
ATOM   1415  CG2 VAL A 192       4.520  20.548  19.908  1.00 14.31           C  
ATOM   1416  N   CYS A 193       1.874  16.652  19.261  1.00 13.29           N  
ATOM   1417  CA  CYS A 193       0.719  15.797  19.320  1.00 13.08           C  
ATOM   1418  C   CYS A 193       0.815  14.925  20.553  1.00 13.17           C  
ATOM   1419  O   CYS A 193       1.792  14.198  20.730  1.00 13.55           O  
ATOM   1420  CB  CYS A 193       0.689  14.881  18.082  1.00 13.42           C  
ATOM   1421  SG  CYS A 193       0.846  15.790  16.519  1.00 13.60           S  
ATOM   1422  N   LYS A 194      -0.225  14.998  21.381  1.00 13.81           N  
ATOM   1423  CA  LYS A 194      -0.262  14.308  22.648  1.00 13.84           C  
ATOM   1424  C   LYS A 194      -1.367  13.287  22.740  1.00 12.59           C  
ATOM   1425  O   LYS A 194      -2.521  13.542  22.368  1.00 12.41           O  
ATOM   1426  CB  LYS A 194      -0.376  15.343  23.776  1.00 15.47           C  
ATOM   1427  CG  LYS A 194       0.686  16.450  23.689  1.00 20.18           C  
ATOM   1428  CD  LYS A 194       2.009  16.084  24.375  1.00 27.64           C  
ATOM   1429  CE  LYS A 194       1.962  16.251  25.897  1.00 31.35           C  
ATOM   1430  NZ  LYS A 194       2.178  17.657  26.398  1.00 33.59           N  
ATOM   1431  N   ASN A 195      -0.981  12.110  23.243  1.00 11.03           N  
ATOM   1432  CA  ASN A 195      -1.856  11.013  23.587  1.00 11.21           C  
ATOM   1433  C   ASN A 195      -2.434  10.362  22.328  1.00 11.36           C  
ATOM   1434  O   ASN A 195      -3.595  10.531  21.972  1.00 11.66           O  
ATOM   1435  CB  ASN A 195      -2.918  11.443  24.644  1.00 11.63           C  
ATOM   1436  CG  ASN A 195      -3.681  10.269  25.214  1.00 13.55           C  
ATOM   1437  OD1 ASN A 195      -3.221   9.134  25.174  1.00 14.79           O  
ATOM   1438  ND2 ASN A 195      -4.862  10.549  25.775  1.00 12.81           N  
ATOM   1439  N   PHE A 196      -1.565   9.570  21.680  1.00 11.34           N  
ATOM   1440  CA  PHE A 196      -2.007   8.804  20.525  1.00 11.80           C  
ATOM   1441  C   PHE A 196      -3.156   7.881  20.903  1.00 12.10           C  
ATOM   1442  O   PHE A 196      -3.022   7.047  21.804  1.00 11.22           O  
ATOM   1443  CB  PHE A 196      -0.853   7.961  19.987  1.00 11.98           C  
ATOM   1444  CG  PHE A 196      -1.215   7.195  18.712  1.00 12.29           C  
ATOM   1445  CD1 PHE A 196      -1.422   7.894  17.525  1.00 13.36           C  
ATOM   1446  CD2 PHE A 196      -1.355   5.802  18.712  1.00 12.83           C  
ATOM   1447  CE1 PHE A 196      -1.749   7.204  16.329  1.00 14.85           C  
ATOM   1448  CE2 PHE A 196      -1.693   5.107  17.549  1.00 16.87           C  
ATOM   1449  CZ  PHE A 196      -1.887   5.810  16.352  1.00 14.33           C  
ATOM   1450  N   LEU A 197      -4.257   8.007  20.166  1.00 13.72           N  
ATOM   1451  CA  LEU A 197      -5.436   7.171  20.384  1.00 16.37           C  
ATOM   1452  C   LEU A 197      -5.743   6.225  19.228  1.00 18.32           C  
ATOM   1453  O   LEU A 197      -6.680   5.437  19.320  1.00 19.25           O  
ATOM   1454  CB  LEU A 197      -6.680   8.049  20.643  1.00 16.21           C  
ATOM   1455  CG  LEU A 197      -6.576   9.003  21.835  1.00 18.29           C  
ATOM   1456  CD1 LEU A 197      -7.729  10.000  21.831  1.00 22.73           C  
ATOM   1457  CD2 LEU A 197      -6.474   8.251  23.128  1.00 19.75           C  
ATOM   1458  N   GLY A 198      -4.987   6.321  18.138  1.00 19.54           N  
ATOM   1459  CA  GLY A 198      -5.347   5.599  16.896  1.00 22.21           C  
ATOM   1460  C   GLY A 198      -6.478   6.318  16.179  1.00 25.04           C  
ATOM   1461  O   GLY A 198      -6.980   7.355  16.650  1.00 25.19           O  
ATOM   1462  N   ARG A 199      -6.915   5.761  15.052  1.00 27.42           N  
ATOM   1463  CA  ARG A 199      -7.995   6.398  14.271  1.00 28.73           C  
ATOM   1464  C   ARG A 199      -9.383   5.973  14.753  1.00 29.23           C  
ATOM   1465  O   ARG A 199      -9.530   4.943  15.419  1.00 29.23           O  
ATOM   1466  CB  ARG A 199      -7.863   6.116  12.783  1.00 29.71           C  
ATOM   1467  CG  ARG A 199      -6.462   5.740  12.308  1.00 32.81           C  
ATOM   1468  CD  ARG A 199      -6.230   6.266  10.913  1.00 38.21           C  
ATOM   1469  NE  ARG A 199      -5.996   7.702  10.958  1.00 43.02           N  
ATOM   1470  CZ  ARG A 199      -5.999   8.511   9.905  1.00 44.61           C  
ATOM   1471  NH1 ARG A 199      -6.226   8.045   8.677  1.00 45.40           N  
ATOM   1472  NH2 ARG A 199      -5.778   9.801  10.093  1.00 47.29           N  
TER    1473      ARG A 199                                                      
END
MOLECULE T0508.pdb
ATOM      1  N   GLN    17      27.341  18.956  20.266  1.00 28.55           N  
ATOM      2  CA  GLN    17      26.133  19.476  19.544  1.00 26.35           C  
ATOM      3  C   GLN    17      25.067  19.993  20.513  1.00 30.77           C  
ATOM      4  O   GLN    17      24.034  20.543  20.088  1.00 24.08           O  
ATOM      5  CB  GLN    17      25.542  18.382  18.646  1.00 27.54           C  
ATOM      6  CG  GLN    17      26.434  17.946  17.479  1.00 28.33           C  
ATOM      7  CD  GLN    17      26.586  19.019  16.411  1.00 35.79           C  
ATOM      8  OE1 GLN    17      25.718  19.891  16.241  1.00 34.30           O  
ATOM      9  NE2 GLN    17      27.692  18.953  15.672  1.00 38.09           N  
ATOM     10  N   LEU    18      25.329  19.819  21.814  1.00 31.52           N  
ATOM     11  CA  LEU    18      24.433  20.242  22.907  1.00 36.19           C  
ATOM     12  C   LEU    18      24.053  21.718  22.876  1.00 37.06           C  
ATOM     13  O   LEU    18      23.038  22.126  23.448  1.00 36.28           O  
ATOM     14  CB  LEU    18      25.085  19.950  24.263  1.00 40.29           C  
ATOM     15  CG  LEU    18      25.116  18.500  24.733  1.00 40.46           C  
ATOM     16  CD1 LEU    18      25.963  18.381  25.991  1.00 45.09           C  
ATOM     17  CD2 LEU    18      23.700  18.005  24.965  1.00 39.67           C  
ATOM     18  N   ARG    19      24.888  22.495  22.199  1.00 35.74           N  
ATOM     19  CA  ARG    19      24.812  23.945  22.161  1.00 37.88           C  
ATOM     20  C   ARG    19      24.334  24.487  20.806  1.00 29.39           C  
ATOM     21  O   ARG    19      24.321  25.705  20.601  1.00 29.87           O  
ATOM     22  CB  ARG    19      26.205  24.493  22.466  1.00 42.33           C  
ATOM     23  CG  ARG    19      27.341  23.712  21.765  1.00 53.58           C  
ATOM     24  CD  ARG    19      27.752  24.332  20.429  1.00 61.77           C  
ATOM     25  NE  ARG    19      28.576  23.428  19.629  1.00 75.01           N  
ATOM     26  CZ  ARG    19      28.165  22.800  18.529  1.00 80.38           C  
ATOM     27  NH1 ARG    19      26.931  22.978  18.067  1.00 80.36           N  
ATOM     28  NH2 ARG    19      28.996  21.994  17.880  1.00 82.30           N  
ATOM     29  N   SER    20      23.992  23.591  19.877  1.00 22.34           N  
ATOM     30  CA  SER    20      23.537  23.996  18.549  1.00 20.35           C  
ATOM     31  C   SER    20      22.175  24.689  18.593  1.00 18.47           C  
ATOM     32  O   SER    20      21.426  24.558  19.561  1.00 18.01           O  
ATOM     33  CB  SER    20      23.472  22.799  17.611  1.00 22.60           C  
ATOM     34  OG  SER    20      22.316  22.019  17.885  1.00 20.95           O  
ATOM     35  N   ARG    21      21.846  25.410  17.528  1.00 18.65           N  
ATOM     36  CA  ARG    21      20.566  26.116  17.455  1.00 19.51           C  
ATOM     37  C   ARG    21      19.421  25.111  17.556  1.00 17.07           C  
ATOM     38  O   ARG    21      18.440  25.343  18.268  1.00 19.73           O  
ATOM     39  CB  ARG    21      20.473  26.874  16.130  1.00 23.77           C  
ATOM     40  CG  ARG    21      19.192  27.666  15.945  1.00 31.80           C  
ATOM     41  CD  ARG    21      19.340  28.620  14.778  1.00 45.60           C  
ATOM     42  NE  ARG    21      18.350  29.692  14.818  1.00 57.03           N  
ATOM     43  CZ  ARG    21      18.418  30.803  14.089  1.00 65.61           C  
ATOM     44  NH1 ARG    21      19.437  30.999  13.257  1.00 66.62           N  
ATOM     45  NH2 ARG    21      17.468  31.723  14.194  1.00 68.54           N  
ATOM     46  N   ALA    22      19.578  23.995  16.850  1.00 17.83           N  
ATOM     47  CA  ALA    22      18.573  22.948  16.851  1.00 15.55           C  
ATOM     48  C   ALA    22      18.381  22.371  18.258  1.00 16.33           C  
ATOM     49  O   ALA    22      17.249  22.202  18.720  1.00 17.50           O  
ATOM     50  CB  ALA    22      18.933  21.869  15.862  1.00 19.42           C  
ATOM     51  N   ALA    23      19.481  22.100  18.964  1.00 16.59           N  
ATOM     52  CA  ALA    23      19.386  21.661  20.362  1.00 15.10           C  
ATOM     53  C   ALA    23      18.604  22.656  21.238  1.00 16.51           C  
ATOM     54  O   ALA    23      17.775  22.244  22.038  1.00 15.64           O  
ATOM     55  CB  ALA    23      20.787  21.427  20.948  1.00 15.49           C  
ATOM     56  N   PHE    24      18.867  23.967  21.093  1.00 15.01           N  
ATOM     57  CA  PHE    24      18.139  24.958  21.887  1.00 20.00           C  
ATOM     58  C   PHE    24      16.644  24.967  21.591  1.00 14.73           C  
ATOM     59  O   PHE    24      15.815  25.130  22.508  1.00 18.39           O  
ATOM     60  CB  PHE    24      18.733  26.367  21.714  1.00 25.77           C  
ATOM     61  CG  PHE    24      19.868  26.656  22.659  1.00 37.19           C  
ATOM     62  CD1 PHE    24      19.615  27.052  23.971  1.00 47.97           C  
ATOM     63  CD2 PHE    24      21.193  26.508  22.245  1.00 46.26           C  
ATOM     64  CE1 PHE    24      20.666  27.309  24.857  1.00 54.49           C  
ATOM     65  CE2 PHE    24      22.251  26.764  23.120  1.00 49.16           C  
ATOM     66  CZ  PHE    24      21.989  27.165  24.428  1.00 48.58           C  
ATOM     67  N   LYS    25      16.301  24.766  20.314  1.00 15.96           N  
ATOM     68  CA  LYS    25      14.893  24.667  19.907  1.00 15.07           C  
ATOM     69  C   LYS    25      14.239  23.492  20.622  1.00 14.67           C  
ATOM     70  O   LYS    25      13.147  23.626  21.185  1.00 14.53           O  
ATOM     71  CB  LYS    25      14.751  24.520  18.391  1.00 16.88           C  
ATOM     72  CG  LYS    25      15.042  25.803  17.590  1.00 24.44           C  
ATOM     73  CD  LYS    25      14.706  25.620  16.105  1.00 27.14           C  
ATOM     74  CE  LYS    25      15.959  25.479  15.249  1.00 35.96           C  
ATOM     75  NZ  LYS    25      15.649  25.049  13.851  1.00 38.22           N  
ATOM     76  N   LEU    26      14.912  22.340  20.648  1.00 13.44           N  
ATOM     77  CA  LEU    26      14.307  21.207  21.341  1.00 12.47           C  
ATOM     78  C   LEU    26      14.186  21.435  22.842  1.00 12.58           C  
ATOM     79  O   LEU    26      13.165  21.067  23.427  1.00 13.35           O  
ATOM     80  CB  LEU    26      15.051  19.889  21.058  1.00 14.07           C  
ATOM     81  CG  LEU    26      14.419  18.650  21.686  1.00 12.73           C  
ATOM     82  CD1 LEU    26      13.020  18.452  21.173  1.00 13.01           C  
ATOM     83  CD2 LEU    26      15.264  17.428  21.366  1.00 13.66           C  
ATOM     84  N   GLU    27      15.197  22.047  23.463  1.00 14.16           N  
ATOM     85  CA  GLU    27      15.124  22.335  24.902  1.00 15.27           C  
ATOM     86  C   GLU    27      13.907  23.219  25.231  1.00 12.64           C  
ATOM     87  O   GLU    27      13.205  22.990  26.204  1.00 14.02           O  
ATOM     88  CB  GLU    27      16.428  22.989  25.382  1.00 16.28           C  
ATOM     89  CG  GLU    27      17.600  21.998  25.485  1.00 27.56           C  
ATOM     90  CD  GLU    27      18.915  22.632  25.940  1.00 38.21           C  
ATOM     91  OE1 GLU    27      19.405  23.577  25.272  1.00 49.67           O  
ATOM     92  OE2 GLU    27      19.469  22.163  26.960  1.00 51.34           O  
ATOM     93  N   PHE    28      13.670  24.214  24.380  1.00 14.06           N  
ATOM     94  CA  PHE    28      12.541  25.133  24.517  1.00 12.72           C  
ATOM     95  C   PHE    28      11.221  24.373  24.460  1.00 13.27           C  
ATOM     96  O   PHE    28      10.360  24.568  25.306  1.00 13.48           O  
ATOM     97  CB  PHE    28      12.682  26.168  23.405  1.00 13.96           C  
ATOM     98  CG  PHE    28      11.502  27.087  23.215  1.00 14.57           C  
ATOM     99  CD1 PHE    28      11.408  28.290  23.917  1.00 19.84           C  
ATOM    100  CD2 PHE    28      10.536  26.793  22.258  1.00 17.11           C  
ATOM    101  CE1 PHE    28      10.346  29.167  23.677  1.00 17.75           C  
ATOM    102  CE2 PHE    28       9.457  27.663  22.024  1.00 16.94           C  
ATOM    103  CZ  PHE    28       9.381  28.850  22.735  1.00 20.66           C  
ATOM    104  N   LEU    29      11.108  23.480  23.476  1.00 13.95           N  
ATOM    105  CA  LEU    29       9.905  22.672  23.317  1.00 11.98           C  
ATOM    106  C   LEU    29       9.685  21.692  24.466  1.00 12.60           C  
ATOM    107  O   LEU    29       8.537  21.496  24.882  1.00 13.48           O  
ATOM    108  CB  LEU    29       9.940  21.899  21.982  1.00 13.29           C  
ATOM    109  CG  LEU    29       9.955  22.790  20.727  1.00 13.34           C  
ATOM    110  CD1 LEU    29      10.381  21.990  19.476  1.00 14.82           C  
ATOM    111  CD2 LEU    29       8.600  23.481  20.463  1.00 14.32           C  
ATOM    112  N   LEU    30      10.753  21.064  24.967  1.00 10.58           N  
ATOM    113  CA  LEU    30      10.602  20.155  26.121  1.00 12.83           C  
ATOM    114  C   LEU    30      10.172  20.920  27.372  1.00 12.29           C  
ATOM    115  O   LEU    30       9.300  20.465  28.111  1.00 14.05           O  
ATOM    116  CB  LEU    30      11.895  19.370  26.400  1.00 15.66           C  
ATOM    117  CG  LEU    30      12.359  18.479  25.258  1.00 16.16           C  
ATOM    118  CD1 LEU    30      13.759  17.903  25.567  1.00 17.08           C  
ATOM    119  CD2 LEU    30      11.320  17.389  24.963  1.00 19.76           C  
ATOM    120  N   ASP    31      10.738  22.115  27.577  1.00 13.31           N  
ATOM    121  CA  ASP    31      10.380  22.953  28.748  1.00 12.70           C  
ATOM    122  C   ASP    31       8.916  23.346  28.710  1.00 13.57           C  
ATOM    123  O   ASP    31       8.207  23.347  29.728  1.00 13.47           O  
ATOM    124  CB  ASP    31      11.213  24.239  28.773  1.00 16.51           C  
ATOM    125  CG  ASP    31      12.593  24.044  29.368  1.00 23.03           C  
ATOM    126  OD1 ASP    31      12.832  23.035  30.067  1.00 27.41           O  
ATOM    127  OD2 ASP    31      13.448  24.930  29.141  1.00 27.84           O  
ATOM    128  N   ARG    32       8.452  23.717  27.535  1.00 12.67           N  
ATOM    129  CA  ARG    32       7.103  24.226  27.393  1.00 12.84           C  
ATOM    130  C   ARG    32       6.040  23.146  27.326  1.00 13.39           C  
ATOM    131  O   ARG    32       4.932  23.349  27.808  1.00 13.37           O  
ATOM    132  CB  ARG    32       7.000  25.023  26.116  1.00 12.72           C  
ATOM    133  CG  ARG    32       7.559  26.433  26.139  1.00 14.78           C  
ATOM    134  CD  ARG    32       7.075  27.174  24.878  1.00 14.18           C  
ATOM    135  NE  ARG    32       7.107  28.621  25.069  1.00 18.87           N  
ATOM    136  CZ  ARG    32       6.487  29.493  24.283  1.00 19.83           C  
ATOM    137  NH1 ARG    32       6.604  30.782  24.540  1.00 27.51           N  
ATOM    138  NH2 ARG    32       5.760  29.077  23.246  1.00 19.18           N  
ATOM    139  N   TYR    33       6.361  22.031  26.665  1.00 10.84           N  
ATOM    140  CA  TYR    33       5.349  21.039  26.290  1.00 11.98           C  
ATOM    141  C   TYR    33       5.577  19.599  26.760  1.00 12.64           C  
ATOM    142  O   TYR    33       4.688  18.759  26.572  1.00 13.17           O  
ATOM    143  CB  TYR    33       5.177  21.027  24.770  1.00 11.87           C  
ATOM    144  CG  TYR    33       4.950  22.401  24.210  1.00 12.45           C  
ATOM    145  CD1 TYR    33       3.748  23.065  24.432  1.00 12.73           C  
ATOM    146  CD2 TYR    33       5.941  23.052  23.490  1.00 11.65           C  
ATOM    147  CE1 TYR    33       3.525  24.350  23.915  1.00 13.75           C  
ATOM    148  CE2 TYR    33       5.720  24.343  22.958  1.00 13.97           C  
ATOM    149  CZ  TYR    33       4.524  24.980  23.189  1.00 14.82           C  
ATOM    150  OH  TYR    33       4.331  26.250  22.673  1.00 17.07           O  
ATOM    151  N   ARG    34       6.737  19.329  27.320  1.00 11.94           N  
ATOM    152  CA  ARG    34       7.075  17.987  27.885  0.50 12.60           C  
ATOM    154  C   ARG    34       6.752  16.863  26.836  1.00 15.29           C  
ATOM    155  O   ARG    34       6.265  15.838  27.180  1.00 16.34           O  
ATOM    156  CB  ARG    34       6.341  17.730  29.206  0.50 15.27           C  
ATOM    158  CG  ARG    34       6.715  18.721  30.308  0.50 18.80           C  
ATOM    160  CD  ARG    34       6.251  18.251  31.685  0.50 24.09           C  
ATOM    162  NE  ARG    34       7.080  17.171  32.217  0.50 29.99           N  
ATOM    164  CZ  ARG    34       6.723  15.887  32.260  0.50 35.77           C  
ATOM    166  NH1 ARG    34       7.554  14.986  32.768  0.50 30.23           N  
ATOM    168  NH2 ARG    34       5.538  15.495  31.800  0.50 39.31           N  
ATOM    170  N   VAL    35       7.093  17.136  25.601  1.00 14.33           N  
ATOM    171  CA  VAL    35       6.681  16.252  24.539  1.00 16.23           C  
ATOM    172  C   VAL    35       7.397  14.907  24.563  1.00 15.87           C  
ATOM    173  O   VAL    35       6.842  13.935  24.164  1.00 18.60           O  
ATOM    174  CB  VAL    35       6.614  16.981  23.155  1.00 20.79           C  
ATOM    175  CG1 VAL    35       7.901  17.453  22.753  1.00 19.27           C  
ATOM    176  CG2 VAL    35       5.962  16.095  22.079  1.00 22.03           C  
ATOM    177  N   VAL    36       8.620  14.904  25.063  1.00 14.69           N  
ATOM    178  CA  VAL    36       9.323  13.708  25.475  1.00 14.45           C  
ATOM    179  C   VAL    36       9.549  13.719  27.008  1.00 14.37           C  
ATOM    180  O   VAL    36       9.873  14.725  27.537  1.00 16.00           O  
ATOM    181  CB  VAL    36      10.688  13.600  24.695  1.00 15.76           C  
ATOM    182  CG1 VAL    36      11.501  12.407  25.134  1.00 14.06           C  
ATOM    183  CG2 VAL    36      10.462  13.571  23.222  1.00 13.18           C  
ATOM    184  N   ARG    37       9.328  12.593  27.672  1.00 13.64           N  
ATOM    185  CA  ARG    37       9.333  12.429  29.008  0.50 18.53           C  
ATOM    187  C   ARG    37      10.496  11.527  29.402  1.00 15.77           C  
ATOM    188  O   ARG    37      10.863  10.667  28.672  1.00 14.89           O  
ATOM    189  CB  ARG    37       7.994  11.913  29.555  0.50 20.65           C  
ATOM    191  CG  ARG    37       6.819  12.854  29.252  0.50 30.27           C  
ATOM    193  CD  ARG    37       5.434  12.185  29.360  0.50 33.11           C  
ATOM    195  NE  ARG    37       5.097  11.095  28.417  0.50 42.98           N  
ATOM    197  CZ  ARG    37       5.375  11.018  27.107  0.50 40.65           C  
ATOM    199  NH1 ARG    37       6.040  11.964  26.456  0.50 28.66           N  
ATOM    201  NH2 ARG    37       4.975   9.949  26.427  0.50 44.72           N  
ATOM    203  N   LYS    38      11.067  11.751  30.563  1.00 15.15           N  
ATOM    204  CA  LYS    38      12.094  10.917  31.115  1.00 13.26           C  
ATOM    205  C   LYS    38      11.741   9.422  31.039  1.00 14.54           C  
ATOM    206  O   LYS    38      10.728   9.042  31.504  1.00 15.92           O  
ATOM    207  CB  LYS    38      12.289  11.304  32.594  1.00 16.09           C  
ATOM    208  CG  LYS    38      13.380  10.611  33.234  1.00 22.87           C  
ATOM    209  CD  LYS    38      14.598  11.183  32.785  1.00 36.52           C  
ATOM    210  CE  LYS    38      15.770  10.611  33.427  1.00 45.52           C  
ATOM    211  NZ  LYS    38      16.989  11.533  33.326  1.00 52.07           N  
ATOM    212  N   GLY    39      12.616   8.645  30.434  1.00 14.73           N  
ATOM    213  CA  GLY    39      12.416   7.193  30.331  1.00 13.34           C  
ATOM    214  C   GLY    39      11.741   6.729  29.047  1.00 14.96           C  
ATOM    215  O   GLY    39      11.562   5.538  28.824  1.00 12.59           O  
ATOM    216  N   ASP    40      11.334   7.670  28.208  1.00 11.88           N  
ATOM    217  CA  ASP    40      10.695   7.357  26.933  1.00  9.89           C  
ATOM    218  C   ASP    40      11.656   6.706  25.958  1.00 10.44           C  
ATOM    219  O   ASP    40      12.871   6.965  25.986  1.00 11.68           O  
ATOM    220  CB  ASP    40      10.168   8.642  26.291  1.00  9.60           C  
ATOM    221  CG  ASP    40       8.825   9.075  26.855  1.00 15.15           C  
ATOM    222  OD1 ASP    40       8.300   8.390  27.768  1.00 15.94           O  
ATOM    223  OD2 ASP    40       8.287  10.116  26.398  1.00 13.89           O  
ATOM    224  N   ALA    41      11.087   5.869  25.081  1.00  9.23           N  
ATOM    225  CA  ALA    41      11.803   5.381  23.917  1.00 10.66           C  
ATOM    226  C   ALA    41      11.312   6.214  22.746  1.00 10.39           C  
ATOM    227  O   ALA    41      10.097   6.409  22.593  1.00 10.52           O  
ATOM    228  CB  ALA    41      11.509   3.893  23.655  1.00 11.78           C  
ATOM    229  N   VAL    42      12.251   6.703  21.934  1.00  9.29           N  
ATOM    230  CA  VAL    42      11.966   7.691  20.884  1.00  9.19           C  
ATOM    231  C   VAL    42      12.535   7.249  19.544  1.00  9.09           C  
ATOM    232  O   VAL    42      13.680   6.824  19.477  1.00 10.43           O  
ATOM    233  CB  VAL    42      12.634   9.041  21.259  1.00 10.87           C  
ATOM    234  CG1 VAL    42      12.350  10.120  20.216  1.00 10.02           C  
ATOM    235  CG2 VAL    42      12.159   9.507  22.641  1.00  9.93           C  
ATOM    236  N   ILE    43      11.714   7.336  18.489  1.00  9.23           N  
ATOM    237  CA  ILE    43      12.233   7.267  17.117  1.00  8.55           C  
ATOM    238  C   ILE    43      12.455   8.724  16.690  1.00  9.88           C  
ATOM    239  O   ILE    43      11.523   9.538  16.716  1.00 10.54           O  
ATOM    240  CB  ILE    43      11.247   6.608  16.168  1.00  9.68           C  
ATOM    241  CG1 ILE    43      11.134   5.117  16.514  1.00 11.32           C  
ATOM    242  CG2 ILE    43      11.709   6.781  14.705  1.00 13.11           C  
ATOM    243  CD1 ILE    43       9.953   4.437  15.835  1.00 12.08           C  
ATOM    244  N   GLU    44      13.695   9.056  16.345  1.00 10.06           N  
ATOM    245  CA  GLU    44      14.079  10.401  15.958  1.00 10.36           C  
ATOM    246  C   GLU    44      14.415  10.427  14.478  1.00 11.21           C  
ATOM    247  O   GLU    44      15.330   9.729  14.050  1.00 12.60           O  
ATOM    248  CB  GLU    44      15.301  10.844  16.764  1.00 11.21           C  
ATOM    249  CG  GLU    44      15.747  12.224  16.301  1.00 11.70           C  
ATOM    250  CD  GLU    44      17.120  12.636  16.766  1.00 13.48           C  
ATOM    251  OE1 GLU    44      17.897  11.771  17.255  1.00 15.29           O  
ATOM    252  OE2 GLU    44      17.420  13.836  16.601  1.00 17.75           O  
ATOM    253  N   ILE    45      13.664  11.191  13.701  1.00  9.39           N  
ATOM    254  CA  ILE    45      13.837  11.257  12.237  1.00  9.26           C  
ATOM    255  C   ILE    45      14.554  12.550  11.852  1.00 10.33           C  
ATOM    256  O   ILE    45      14.161  13.633  12.285  1.00 12.16           O  
ATOM    257  CB  ILE    45      12.486  11.132  11.523  1.00 10.48           C  
ATOM    258  CG1 ILE    45      11.919   9.730  11.811  1.00 14.98           C  
ATOM    259  CG2 ILE    45      12.642  11.353  10.015  1.00 13.76           C  
ATOM    260  CD1 ILE    45      10.461   9.557  11.499  1.00 20.21           C  
ATOM    261  N   GLY    46      15.643  12.439  11.084  1.00 11.67           N  
ATOM    262  CA  GLY    46      16.424  13.628  10.739  1.00 10.89           C  
ATOM    263  C   GLY    46      17.394  14.013  11.850  1.00 11.86           C  
ATOM    264  O   GLY    46      17.433  15.156  12.283  1.00 14.16           O  
ATOM    265  N   SER    47      18.192  13.047  12.287  1.00 14.11           N  
ATOM    266  CA  SER    47      19.016  13.223  13.476  1.00 13.31           C  
ATOM    267  C   SER    47      20.367  13.896  13.288  1.00 12.81           C  
ATOM    268  O   SER    47      20.932  14.398  14.248  1.00 14.54           O  
ATOM    269  CB  SER    47      19.277  11.857  14.108  1.00 11.08           C  
ATOM    270  OG  SER    47      19.928  10.995  13.176  1.00 14.23           O  
ATOM    271  N   SER    48      20.890  13.926  12.065  1.00 12.35           N  
ATOM    272  CA  SER    48      22.264  14.391  11.892  0.50 12.78           C  
ATOM    274  C   SER    48      22.363  15.908  11.904  1.00 12.43           C  
ATOM    275  O   SER    48      21.495  16.587  11.361  1.00 16.33           O  
ATOM    276  CB  SER    48      22.855  13.821  10.613  0.50 13.15           C  
ATOM    278  OG  SER    48      22.792  12.407  10.651  0.50 12.11           O  
ATOM    280  N   PRO    49      23.431  16.454  12.534  1.00 13.69           N  
ATOM    281  CA  PRO    49      24.584  15.838  13.196  1.00 14.45           C  
ATOM    282  C   PRO    49      24.402  15.350  14.622  1.00 15.17           C  
ATOM    283  O   PRO    49      25.297  14.696  15.125  1.00 18.41           O  
ATOM    284  CB  PRO    49      25.646  16.960  13.158  1.00 13.96           C  
ATOM    285  CG  PRO    49      24.828  18.216  13.270  1.00 16.02           C  
ATOM    286  CD  PRO    49      23.555  17.932  12.489  1.00 16.62           C  
ATOM    287  N   GLY    50      23.286  15.668  15.282  1.00 14.24           N  
ATOM    288  CA  GLY    50      23.063  15.082  16.608  1.00 11.34           C  
ATOM    289  C   GLY    50      22.701  16.000  17.754  1.00 13.31           C  
ATOM    290  O   GLY    50      22.751  15.585  18.900  1.00 13.91           O  
ATOM    291  N   GLY    51      22.342  17.254  17.466  1.00 12.78           N  
ATOM    292  CA  GLY    51      21.909  18.171  18.531  1.00 12.63           C  
ATOM    293  C   GLY    51      20.682  17.708  19.307  1.00 13.36           C  
ATOM    294  O   GLY    51      20.701  17.634  20.539  1.00 13.73           O  
ATOM    295  N   TRP    52      19.601  17.405  18.587  1.00 11.89           N  
ATOM    296  CA  TRP    52      18.441  16.839  19.275  1.00 11.79           C  
ATOM    297  C   TRP    52      18.798  15.531  19.953  1.00 11.80           C  
ATOM    298  O   TRP    52      18.345  15.262  21.057  1.00 13.79           O  
ATOM    299  CB  TRP    52      17.276  16.596  18.323  1.00 12.99           C  
ATOM    300  CG  TRP    52      16.480  17.814  17.965  1.00 13.11           C  
ATOM    301  CD1 TRP    52      16.894  19.126  17.985  1.00 11.58           C  
ATOM    302  CD2 TRP    52      15.125  17.829  17.523  1.00 12.99           C  
ATOM    303  NE1 TRP    52      15.878  19.948  17.579  1.00 13.19           N  
ATOM    304  CE2 TRP    52      14.777  19.177  17.287  1.00 13.10           C  
ATOM    305  CE3 TRP    52      14.164  16.825  17.299  1.00 13.89           C  
ATOM    306  CZ2 TRP    52      13.496  19.554  16.851  1.00 12.31           C  
ATOM    307  CZ3 TRP    52      12.906  17.193  16.854  1.00 14.51           C  
ATOM    308  CH2 TRP    52      12.586  18.547  16.632  1.00 12.23           C  
ATOM    309  N   THR    53      19.602  14.703  19.281  1.00 11.88           N  
ATOM    310  CA  THR    53      19.935  13.386  19.848  1.00 13.53           C  
ATOM    311  C   THR    53      20.637  13.514  21.192  1.00 11.78           C  
ATOM    312  O   THR    53      20.307  12.798  22.142  1.00 15.17           O  
ATOM    313  CB  THR    53      20.836  12.558  18.891  1.00 13.39           C  
ATOM    314  OG1 THR    53      20.362  12.667  17.548  1.00 15.73           O  
ATOM    315  CG2 THR    53      20.864  11.092  19.305  1.00 15.16           C  
ATOM    316  N   GLN    54      21.570  14.460  21.279  1.00 13.11           N  
ATOM    317  CA  GLN    54      22.293  14.685  22.521  1.00 14.80           C  
ATOM    318  C   GLN    54      21.366  15.235  23.616  1.00 14.98           C  
ATOM    319  O   GLN    54      21.513  14.867  24.783  1.00 17.30           O  
ATOM    320  CB  GLN    54      23.494  15.605  22.274  1.00 15.90           C  
ATOM    321  CG  GLN    54      24.615  14.902  21.537  1.00 17.43           C  
ATOM    322  CD  GLN    54      25.871  15.739  21.359  1.00 23.10           C  
ATOM    323  OE1 GLN    54      26.032  16.792  21.966  1.00 27.50           O  
ATOM    324  NE2 GLN    54      26.777  15.252  20.521  1.00 36.12           N  
ATOM    325  N   VAL    55      20.407  16.085  23.253  1.00 13.38           N  
ATOM    326  CA  VAL    55      19.436  16.577  24.224  1.00 13.23           C  
ATOM    327  C   VAL    55      18.549  15.413  24.682  1.00 16.58           C  
ATOM    328  O   VAL    55      18.325  15.241  25.881  1.00 19.21           O  
ATOM    329  CB  VAL    55      18.568  17.734  23.646  1.00 14.91           C  
ATOM    330  CG1 VAL    55      17.342  18.049  24.540  1.00 15.77           C  
ATOM    331  CG2 VAL    55      19.428  18.996  23.464  1.00 18.22           C  
ATOM    332  N   LEU    56      18.064  14.627  23.718  1.00 13.47           N  
ATOM    333  CA  LEU    56      17.193  13.485  24.034  1.00 16.57           C  
ATOM    334  C   LEU    56      17.903  12.413  24.853  1.00 14.44           C  
ATOM    335  O   LEU    56      17.277  11.761  25.667  1.00 13.36           O  
ATOM    336  CB  LEU    56      16.608  12.859  22.769  1.00 14.57           C  
ATOM    337  CG  LEU    56      15.627  13.647  21.890  1.00 16.91           C  
ATOM    338  CD1 LEU    56      15.467  12.948  20.538  1.00 18.51           C  
ATOM    339  CD2 LEU    56      14.279  13.842  22.594  1.00 24.21           C  
ATOM    340  N   ASN    57      19.208  12.243  24.651  1.00 16.18           N  
ATOM    341  CA  ASN    57      19.983  11.196  25.321  1.00 15.31           C  
ATOM    342  C   ASN    57      20.077  11.415  26.823  1.00 21.90           C  
ATOM    343  O   ASN    57      20.399  10.493  27.563  1.00 25.60           O  
ATOM    344  CB  ASN    57      21.370  11.128  24.689  1.00 17.13           C  
ATOM    345  CG  ASN    57      22.121   9.851  25.011  1.00 20.72           C  
ATOM    346  OD1 ASN    57      23.343   9.875  25.184  1.00 24.28           O  
ATOM    347  ND2 ASN    57      21.411   8.736  25.084  1.00 17.68           N  
ATOM    348  N   SER    58      19.746  12.635  27.241  1.00 20.84           N  
ATOM    349  CA  SER    58      19.785  13.036  28.646  0.50 22.94           C  
ATOM    351  C   SER    58      18.504  12.628  29.365  1.00 23.93           C  
ATOM    352  O   SER    58      18.425  12.706  30.598  1.00 27.24           O  
ATOM    353  CB  SER    58      20.006  14.557  28.772  0.50 25.02           C  
ATOM    355  OG  SER    58      18.881  15.303  28.321  0.50 21.84           O  
ATOM    357  N   LEU    59      17.512  12.169  28.595  1.00 15.23           N  
ATOM    358  CA  LEU    59      16.141  12.000  29.080  1.00 14.65           C  
ATOM    359  C   LEU    59      15.541  10.635  28.673  1.00 14.87           C  
ATOM    360  O   LEU    59      14.897   9.940  29.474  1.00 15.65           O  
ATOM    361  CB  LEU    59      15.324  13.132  28.429  1.00 25.84           C  
ATOM    362  CG  LEU    59      13.879  13.493  28.741  1.00 25.18           C  
ATOM    363  CD1 LEU    59      13.803  14.181  30.089  1.00 29.94           C  
ATOM    364  CD2 LEU    59      13.301  14.413  27.667  1.00 26.06           C  
ATOM    365  N   ALA    60      15.735  10.265  27.407  1.00 13.09           N  
ATOM    366  CA  ALA    60      15.152   9.037  26.874  1.00 13.19           C  
ATOM    367  C   ALA    60      15.880   7.798  27.391  1.00 12.67           C  
ATOM    368  O   ALA    60      17.097   7.835  27.650  1.00 12.83           O  
ATOM    369  CB  ALA    60      15.211   9.067  25.359  1.00 11.38           C  
ATOM    370  N   ARG    61      15.153   6.674  27.513  1.00 12.32           N  
ATOM    371  CA  ARG    61      15.834   5.402  27.814  1.00 11.46           C  
ATOM    372  C   ARG    61      16.487   4.775  26.579  1.00 10.52           C  
ATOM    373  O   ARG    61      17.451   4.018  26.691  1.00 13.25           O  
ATOM    374  CB  ARG    61      14.887   4.389  28.488  1.00 10.24           C  
ATOM    375  CG  ARG    61      13.912   3.659  27.577  1.00 13.10           C  
ATOM    376  CD  ARG    61      13.040   2.670  28.379  1.00 13.71           C  
ATOM    377  NE  ARG    61      12.274   1.828  27.468  1.00 12.52           N  
ATOM    378  CZ  ARG    61      11.148   2.200  26.863  1.00 10.75           C  
ATOM    379  NH1 ARG    61      10.592   3.392  27.102  1.00 11.33           N  
ATOM    380  NH2 ARG    61      10.528   1.359  26.026  1.00 12.41           N  
ATOM    381  N   LYS    62      15.955   5.090  25.394  1.00 10.76           N  
ATOM    382  CA  LYS    62      16.456   4.537  24.153  1.00 10.80           C  
ATOM    383  C   LYS    62      16.015   5.435  23.008  1.00 10.46           C  
ATOM    384  O   LYS    62      14.887   5.903  22.985  1.00 11.00           O  
ATOM    385  CB  LYS    62      15.908   3.128  23.926  1.00 11.68           C  
ATOM    386  CG  LYS    62      16.537   2.368  22.731  1.00 14.08           C  
ATOM    387  CD  LYS    62      18.069   2.338  22.718  1.00 15.23           C  
ATOM    388  CE  LYS    62      18.694   1.776  24.000  1.00 16.71           C  
ATOM    389  NZ  LYS    62      20.167   1.507  23.839  1.00 19.21           N  
ATOM    390  N   ILE    63      16.956   5.708  22.103  1.00 10.53           N  
ATOM    391  CA  ILE    63      16.669   6.490  20.903  1.00 10.94           C  
ATOM    392  C   ILE    63      17.062   5.657  19.694  1.00 10.88           C  
ATOM    393  O   ILE    63      18.155   5.100  19.632  1.00 11.23           O  
ATOM    394  CB  ILE    63      17.478   7.812  20.873  1.00 11.95           C  
ATOM    395  CG1 ILE    63      17.197   8.628  22.130  1.00 12.48           C  
ATOM    396  CG2 ILE    63      17.111   8.626  19.607  1.00 11.36           C  
ATOM    397  CD1 ILE    63      18.239   9.693  22.421  1.00 14.22           C  
ATOM    398  N   ILE    64      16.164   5.593  18.725  1.00 10.48           N  
ATOM    399  CA  ILE    64      16.486   5.060  17.412  1.00 10.88           C  
ATOM    400  C   ILE    64      16.486   6.269  16.504  1.00 10.93           C  
ATOM    401  O   ILE    64      15.419   6.864  16.260  1.00 11.03           O  
ATOM    402  CB  ILE    64      15.416   4.042  16.960  1.00 11.86           C  
ATOM    403  CG1 ILE    64      15.450   2.832  17.899  1.00 15.49           C  
ATOM    404  CG2 ILE    64      15.662   3.608  15.514  1.00 16.09           C  
ATOM    405  CD1 ILE    64      14.287   1.900  17.713  1.00 19.46           C  
ATOM    406  N   SER    65      17.668   6.635  16.021  1.00 10.83           N  
ATOM    407  CA  SER    65      17.876   7.846  15.224  1.00 10.05           C  
ATOM    408  C   SER    65      18.068   7.492  13.751  1.00 10.66           C  
ATOM    409  O   SER    65      18.777   6.522  13.452  1.00 12.61           O  
ATOM    410  CB  SER    65      19.134   8.568  15.720  1.00 10.73           C  
ATOM    411  OG  SER    65      18.920   9.202  16.979  1.00 13.77           O  
ATOM    412  N   ILE    66      17.450   8.258  12.851  1.00  9.40           N  
ATOM    413  CA  ILE    66      17.439   7.937  11.425  1.00 10.04           C  
ATOM    414  C   ILE    66      17.853   9.169  10.617  1.00 11.20           C  
ATOM    415  O   ILE    66      17.303  10.259  10.835  1.00 11.03           O  
ATOM    416  CB  ILE    66      16.023   7.511  10.961  1.00 10.72           C  
ATOM    417  CG1 ILE    66      15.571   6.266  11.760  1.00 13.63           C  
ATOM    418  CG2 ILE    66      16.044   7.193   9.456  1.00 15.71           C  
ATOM    419  CD1 ILE    66      14.091   5.931  11.698  1.00 16.82           C  
ATOM    420  N   ASP    67      18.776   9.007   9.672  1.00 11.18           N  
ATOM    421  CA  ASP    67      19.114  10.119   8.794  1.00 11.30           C  
ATOM    422  C   ASP    67      19.697   9.605   7.495  1.00 11.71           C  
ATOM    423  O   ASP    67      20.207   8.493   7.440  1.00 12.81           O  
ATOM    424  CB  ASP    67      20.142  11.041   9.475  1.00 13.14           C  
ATOM    425  CG  ASP    67      20.150  12.447   8.900  1.00 12.63           C  
ATOM    426  OD1 ASP    67      20.680  12.687   7.798  1.00 14.91           O  
ATOM    427  OD2 ASP    67      19.609  13.342   9.554  1.00 12.57           O  
ATOM    428  N   LEU    68      19.618  10.433   6.454  1.00 11.57           N  
ATOM    429  CA  LEU    68      20.321  10.139   5.195  1.00 12.52           C  
ATOM    430  C   LEU    68      21.838  10.180   5.347  1.00 15.17           C  
ATOM    431  O   LEU    68      22.553   9.453   4.634  1.00 16.52           O  
ATOM    432  CB  LEU    68      19.948  11.168   4.126  1.00 12.94           C  
ATOM    433  CG  LEU    68      18.525  11.192   3.601  1.00 13.40           C  
ATOM    434  CD1 LEU    68      18.271  12.492   2.840  1.00 16.72           C  
ATOM    435  CD2 LEU    68      18.308  10.018   2.701  1.00 16.24           C  
ATOM    436  N   GLN    69      22.310  11.046   6.234  1.00 14.15           N  
ATOM    437  CA  GLN    69      23.728  11.351   6.393  0.50 15.08           C  
ATOM    439  C   GLN    69      24.290  10.685   7.630  1.00 16.76           C  
ATOM    440  O   GLN    69      23.584  10.523   8.611  1.00 16.67           O  
ATOM    441  CB  GLN    69      23.913  12.867   6.539  0.50 14.48           C  
ATOM    443  CG  GLN    69      23.303  13.684   5.409  0.50 17.02           C  
ATOM    445  CD  GLN    69      23.454  15.188   5.597  0.50 21.02           C  
ATOM    447  OE1 GLN    69      24.102  15.855   4.791  0.50 26.25           O  
ATOM    449  NE2 GLN    69      22.855  15.728   6.661  0.50 23.75           N  
ATOM    451  N   GLU    70      25.572  10.325   7.596  1.00 18.94           N  
ATOM    452  CA  GLU    70      26.232   9.832   8.782  1.00 22.18           C  
ATOM    453  C   GLU    70      26.240  10.901   9.868  1.00 20.61           C  
ATOM    454  O   GLU    70      26.174  12.106   9.592  1.00 22.85           O  
ATOM    455  CB  GLU    70      27.677   9.422   8.457  1.00 28.88           C  
ATOM    456  CG  GLU    70      27.852   7.941   8.115  1.00 41.08           C  
ATOM    457  CD  GLU    70      27.435   7.003   9.249  1.00 47.85           C  
ATOM    458  OE1 GLU    70      26.837   5.947   8.953  1.00 44.50           O  
ATOM    459  OE2 GLU    70      27.701   7.316  10.433  1.00 53.10           O  
ATOM    460  N   MET    71      26.268  10.446  11.111  1.00 22.46           N  
ATOM    461  CA  MET    71      26.587  11.326  12.213  1.00 25.42           C  
ATOM    462  C   MET    71      27.448  10.554  13.197  1.00 23.59           C  
ATOM    463  O   MET    71      27.522   9.316  13.134  1.00 26.19           O  
ATOM    464  CB  MET    71      25.322  11.862  12.878  1.00 23.96           C  
ATOM    465  CG  MET    71      24.476  10.818  13.500  1.00 17.30           C  
ATOM    466  SD  MET    71      23.049  11.579  14.604  0.70 26.40          SE  
ATOM    467  CE  MET    71      22.642   9.910  15.033  1.00 10.60           C  
ATOM    468  N   GLU    72      28.096  11.285  14.094  1.00 26.79           N  
ATOM    469  CA  GLU    72      28.953  10.671  15.095  1.00 33.65           C  
ATOM    470  C   GLU    72      28.145   9.796  16.045  1.00 30.46           C  
ATOM    471  O   GLU    72      26.991  10.116  16.373  1.00 25.47           O  
ATOM    472  CB  GLU    72      29.745  11.727  15.868  1.00 37.99           C  
ATOM    473  CG  GLU    72      31.107  12.025  15.258  1.00 50.28           C  
ATOM    474  CD  GLU    72      32.059  12.668  16.247  1.00 59.79           C  
ATOM    475  OE1 GLU    72      32.889  11.938  16.833  1.00 58.00           O  
ATOM    476  OE2 GLU    72      31.968  13.900  16.446  1.00 64.90           O  
ATOM    477  N   GLU    73      28.759   8.679  16.436  1.00 31.06           N  
ATOM    478  CA  GLU    73      28.176   7.737  17.389  1.00 33.36           C  
ATOM    479  C   GLU    73      27.967   8.371  18.761  1.00 28.63           C  
ATOM    480  O   GLU    73      28.727   9.226  19.207  1.00 23.68           O  
ATOM    481  CB  GLU    73      29.018   6.449  17.491  1.00 36.66           C  
ATOM    482  CG  GLU    73      30.441   6.610  18.065  1.00 54.51           C  
ATOM    483  CD  GLU    73      31.506   7.002  17.029  1.00 65.94           C  
ATOM    484  OE1 GLU    73      31.163   7.273  15.854  1.00 68.44           O  
ATOM    485  OE2 GLU    73      32.701   7.039  17.403  1.00 69.26           O  
ATOM    486  N   ILE    74      26.872   7.991  19.401  1.00 22.88           N  
ATOM    487  CA  ILE    74      26.562   8.449  20.743  1.00 19.83           C  
ATOM    488  C   ILE    74      26.268   7.153  21.468  1.00 21.56           C  
ATOM    489  O   ILE    74      25.559   6.292  20.937  1.00 20.26           O  
ATOM    490  CB  ILE    74      25.373   9.459  20.768  1.00 18.50           C  
ATOM    491  CG1 ILE    74      25.750  10.731  20.004  1.00 19.31           C  
ATOM    492  CG2 ILE    74      25.007   9.835  22.203  1.00 19.70           C  
ATOM    493  CD1 ILE    74      24.565  11.626  19.648  1.00 16.30           C  
ATOM    494  N   ALA    75      26.864   6.985  22.648  1.00 20.90           N  
ATOM    495  CA  ALA    75      26.737   5.721  23.362  1.00 24.22           C  
ATOM    496  C   ALA    75      25.269   5.387  23.594  1.00 16.89           C  
ATOM    497  O   ALA    75      24.505   6.211  24.078  1.00 19.33           O  
ATOM    498  CB  ALA    75      27.493   5.779  24.688  1.00 24.81           C  
ATOM    499  N   GLY    76      24.889   4.172  23.202  1.00 19.08           N  
ATOM    500  CA  GLY    76      23.548   3.677  23.464  1.00 17.20           C  
ATOM    501  C   GLY    76      22.463   4.103  22.491  1.00 15.30           C  
ATOM    502  O   GLY    76      21.329   3.646  22.609  1.00 15.69           O  
ATOM    503  N   VAL    77      22.806   4.973  21.542  1.00 14.31           N  
ATOM    504  CA  VAL    77      21.842   5.431  20.531  1.00 13.17           C  
ATOM    505  C   VAL    77      21.950   4.492  19.341  1.00 13.37           C  
ATOM    506  O   VAL    77      23.080   4.158  18.899  1.00 15.18           O  
ATOM    507  CB  VAL    77      22.116   6.883  20.066  1.00 12.43           C  
ATOM    508  CG1 VAL    77      21.270   7.236  18.841  1.00 12.61           C  
ATOM    509  CG2 VAL    77      21.880   7.889  21.205  1.00 14.75           C  
ATOM    510  N   ARG    78      20.800   4.033  18.840  1.00 11.93           N  
ATOM    511  CA  ARG    78      20.811   3.143  17.711  1.00 12.60           C  
ATOM    512  C   ARG    78      20.600   3.982  16.467  1.00 14.57           C  
ATOM    513  O   ARG    78      19.518   4.500  16.242  1.00 15.17           O  
ATOM    514  CB  ARG    78      19.687   2.130  17.870  1.00 13.99           C  
ATOM    515  CG  ARG    78      19.597   1.139  16.749  1.00 22.12           C  
ATOM    516  CD  ARG    78      18.604   0.066  17.103  1.00 33.92           C  
ATOM    517  NE  ARG    78      19.095  -0.893  18.091  1.00 36.42           N  
ATOM    518  CZ  ARG    78      19.566  -2.102  17.801  1.00 40.20           C  
ATOM    519  NH1 ARG    78      19.627  -2.522  16.538  1.00 33.04           N  
ATOM    520  NH2 ARG    78      19.979  -2.893  18.783  1.00 34.30           N  
ATOM    521  N   PHE    79      21.639   4.139  15.673  1.00 12.80           N  
ATOM    522  CA  PHE    79      21.557   4.970  14.492  1.00 12.11           C  
ATOM    523  C   PHE    79      21.322   4.109  13.255  1.00 15.59           C  
ATOM    524  O   PHE    79      21.970   3.080  13.073  1.00 18.23           O  
ATOM    525  CB  PHE    79      22.824   5.823  14.349  1.00 13.66           C  
ATOM    526  CG  PHE    79      22.852   6.660  13.095  1.00 13.92           C  
ATOM    527  CD1 PHE    79      21.877   7.611  12.857  1.00 14.07           C  
ATOM    528  CD2 PHE    79      23.848   6.472  12.138  1.00 16.12           C  
ATOM    529  CE1 PHE    79      21.892   8.377  11.684  1.00 14.81           C  
ATOM    530  CE2 PHE    79      23.858   7.213  10.961  1.00 19.04           C  
ATOM    531  CZ  PHE    79      22.879   8.168  10.732  1.00 18.26           C  
ATOM    532  N   ILE    80      20.403   4.548  12.398  1.00 13.67           N  
ATOM    533  CA  ILE    80      20.103   3.867  11.146  1.00 14.45           C  
ATOM    534  C   ILE    80      20.258   4.895  10.030  1.00 14.03           C  
ATOM    535  O   ILE    80      19.560   5.907  10.008  1.00 13.61           O  
ATOM    536  CB  ILE    80      18.662   3.349  11.105  1.00 13.42           C  
ATOM    537  CG1 ILE    80      18.360   2.431  12.311  1.00 16.58           C  
ATOM    538  CG2 ILE    80      18.406   2.615   9.777  1.00 18.22           C  
ATOM    539  CD1 ILE    80      16.914   2.000  12.421  1.00 19.95           C  
ATOM    540  N   ARG    81      21.150   4.631   9.083  1.00 13.88           N  
ATOM    541  CA  ARG    81      21.227   5.441   7.874  1.00 13.30           C  
ATOM    542  C   ARG    81      20.158   4.928   6.915  1.00 15.06           C  
ATOM    543  O   ARG    81      20.173   3.759   6.520  1.00 13.56           O  
ATOM    544  CB  ARG    81      22.615   5.338   7.223  1.00 16.75           C  
ATOM    545  CG  ARG    81      23.450   6.594   7.390  1.00 33.80           C  
ATOM    546  CD  ARG    81      24.652   6.576   6.480  1.00 32.17           C  
ATOM    547  NE  ARG    81      24.561   7.513   5.368  1.00 23.99           N  
ATOM    548  CZ  ARG    81      25.551   7.722   4.507  1.00 24.73           C  
ATOM    549  NH1 ARG    81      26.692   7.059   4.649  1.00 32.42           N  
ATOM    550  NH2 ARG    81      25.417   8.590   3.517  1.00 33.32           N  
ATOM    551  N   CYS    82      19.225   5.793   6.535  1.00 12.53           N  
ATOM    552  CA  CYS    82      18.074   5.359   5.777  1.00 13.00           C  
ATOM    553  C   CYS    82      17.358   6.563   5.184  1.00 13.41           C  
ATOM    554  O   CYS    82      17.306   7.620   5.834  1.00 14.05           O  
ATOM    555  CB  CYS    82      17.112   4.609   6.690  1.00 14.25           C  
ATOM    556  SG  CYS    82      15.720   3.923   5.762  1.00 19.53           S  
ATOM    557  N   ASP    83      16.812   6.411   3.971  1.00 11.70           N  
ATOM    558  CA  ASP    83      15.918   7.424   3.426  1.00 13.14           C  
ATOM    559  C   ASP    83      14.520   6.983   3.823  1.00 12.87           C  
ATOM    560  O   ASP    83      14.055   5.923   3.397  1.00 13.51           O  
ATOM    561  CB  ASP    83      16.049   7.465   1.892  1.00 11.45           C  
ATOM    562  CG  ASP    83      15.148   8.506   1.230  1.00 15.18           C  
ATOM    563  OD1 ASP    83      14.130   8.930   1.810  1.00 14.62           O  
ATOM    564  OD2 ASP    83      15.471   8.904   0.089  1.00 18.70           O  
ATOM    565  N   ILE    84      13.815   7.793   4.614  1.00 12.08           N  
ATOM    566  CA  ILE    84      12.487   7.374   5.080  1.00 10.97           C  
ATOM    567  C   ILE    84      11.473   7.126   3.959  1.00 13.47           C  
ATOM    568  O   ILE    84      10.482   6.462   4.189  1.00 13.31           O  
ATOM    569  CB  ILE    84      11.885   8.365   6.121  1.00 13.38           C  
ATOM    570  CG1 ILE    84      11.602   9.759   5.495  1.00 12.86           C  
ATOM    571  CG2 ILE    84      12.798   8.462   7.361  1.00 13.54           C  
ATOM    572  CD1 ILE    84      10.751  10.702   6.380  1.00 14.69           C  
ATOM    573  N   PHE    85      11.714   7.676   2.777  1.00 13.02           N  
ATOM    574  CA  PHE    85      10.765   7.515   1.662  1.00 12.85           C  
ATOM    575  C   PHE    85      10.973   6.201   0.908  1.00 15.25           C  
ATOM    576  O   PHE    85      10.124   5.806   0.095  1.00 17.25           O  
ATOM    577  CB  PHE    85      10.912   8.669   0.671  1.00 12.29           C  
ATOM    578  CG  PHE    85      10.433   9.989   1.201  1.00 11.32           C  
ATOM    579  CD1 PHE    85       9.089  10.185   1.493  1.00 12.76           C  
ATOM    580  CD2 PHE    85      11.325  11.028   1.391  1.00 11.72           C  
ATOM    581  CE1 PHE    85       8.653  11.410   1.982  1.00 15.78           C  
ATOM    582  CE2 PHE    85      10.888  12.257   1.881  1.00 14.28           C  
ATOM    583  CZ  PHE    85       9.542  12.440   2.161  1.00 16.43           C  
ATOM    584  N   LYS    86      12.090   5.521   1.161  1.00 15.12           N  
ATOM    585  CA  LYS    86      12.431   4.349   0.368  1.00 15.16           C  
ATOM    586  C   LYS    86      11.876   3.069   1.009  1.00 15.80           C  
ATOM    587  O   LYS    86      11.010   3.133   1.883  1.00 17.52           O  
ATOM    588  CB  LYS    86      13.945   4.285   0.104  1.00 15.21           C  
ATOM    589  CG  LYS    86      14.498   5.434  -0.749  1.00 18.74           C  
ATOM    590  CD  LYS    86      13.847   5.550  -2.129  1.00 25.60           C  
ATOM    591  CE  LYS    86      14.376   6.798  -2.845  1.00 30.31           C  
ATOM    592  NZ  LYS    86      13.560   7.154  -4.039  1.00 39.14           N  
ATOM    593  N   GLU    87      12.352   1.907   0.555  1.00 14.35           N  
ATOM    594  CA  GLU    87      11.668   0.641   0.825  1.00 18.83           C  
ATOM    595  C   GLU    87      12.058  -0.083   2.092  1.00 16.10           C  
ATOM    596  O   GLU    87      11.344  -1.014   2.497  1.00 18.86           O  
ATOM    597  CB  GLU    87      11.829  -0.343  -0.352  1.00 16.40           C  
ATOM    598  CG  GLU    87      11.473   0.263  -1.727  1.00 24.26           C  
ATOM    599  CD  GLU    87      11.768  -0.673  -2.915  1.00 32.24           C  
ATOM    600  OE1 GLU    87      12.880  -1.247  -3.018  1.00 22.27           O  
ATOM    601  OE2 GLU    87      10.871  -0.822  -3.769  1.00 38.54           O  
ATOM    602  N   THR    88      13.181   0.284   2.702  1.00 14.31           N  
ATOM    603  CA  THR    88      13.659  -0.478   3.865  1.00 12.35           C  
ATOM    604  C   THR    88      13.197   0.081   5.223  1.00 14.22           C  
ATOM    605  O   THR    88      13.419  -0.547   6.228  1.00 14.68           O  
ATOM    606  CB  THR    88      15.204  -0.564   3.925  1.00 13.50           C  
ATOM    607  OG1 THR    88      15.751   0.750   4.057  1.00 14.98           O  
ATOM    608  CG2 THR    88      15.779  -1.252   2.680  1.00 16.24           C  
ATOM    609  N   ILE    89      12.594   1.267   5.235  1.00 12.41           N  
ATOM    610  CA  ILE    89      12.386   2.013   6.486  1.00 11.93           C  
ATOM    611  C   ILE    89      11.652   1.215   7.561  1.00 13.83           C  
ATOM    612  O   ILE    89      12.071   1.204   8.727  1.00 13.99           O  
ATOM    613  CB  ILE    89      11.719   3.394   6.209  1.00 14.69           C  
ATOM    614  CG1 ILE    89      11.573   4.220   7.504  1.00 12.66           C  
ATOM    615  CG2 ILE    89      10.379   3.264   5.465  1.00 15.13           C  
ATOM    616  CD1 ILE    89      12.869   4.423   8.248  1.00 14.32           C  
ATOM    617  N   PHE    90      10.607   0.498   7.154  1.00 14.71           N  
ATOM    618  CA  PHE    90       9.821  -0.247   8.141  1.00 14.60           C  
ATOM    619  C   PHE    90      10.538  -1.480   8.612  1.00 16.51           C  
ATOM    620  O   PHE    90      10.508  -1.789   9.792  1.00 16.36           O  
ATOM    621  CB  PHE    90       8.431  -0.572   7.621  1.00 14.85           C  
ATOM    622  CG  PHE    90       7.667   0.634   7.185  1.00 15.88           C  
ATOM    623  CD1 PHE    90       7.239   1.592   8.107  1.00 17.54           C  
ATOM    624  CD2 PHE    90       7.402   0.845   5.835  1.00 19.99           C  
ATOM    625  CE1 PHE    90       6.530   2.729   7.673  1.00 20.12           C  
ATOM    626  CE2 PHE    90       6.701   1.964   5.402  1.00 24.98           C  
ATOM    627  CZ  PHE    90       6.264   2.908   6.314  1.00 18.82           C  
ATOM    628  N   ASP    91      11.219  -2.166   7.698  1.00 13.68           N  
ATOM    629  CA  ASP    91      12.028  -3.312   8.096  1.00 13.68           C  
ATOM    630  C   ASP    91      13.162  -2.919   9.047  1.00 14.80           C  
ATOM    631  O   ASP    91      13.516  -3.670   9.977  1.00 16.34           O  
ATOM    632  CB  ASP    91      12.633  -3.997   6.862  1.00 17.52           C  
ATOM    633  CG  ASP    91      11.588  -4.694   5.996  1.00 24.50           C  
ATOM    634  OD1 ASP    91      10.492  -5.018   6.497  1.00 21.30           O  
ATOM    635  OD2 ASP    91      11.869  -4.923   4.799  1.00 25.94           O  
ATOM    636  N   ASP    92      13.744  -1.741   8.792  1.00 13.74           N  
ATOM    637  CA  ASP    92      14.841  -1.220   9.576  1.00 12.72           C  
ATOM    638  C   ASP    92      14.374  -0.880  10.980  1.00 13.13           C  
ATOM    639  O   ASP    92      15.044  -1.216  11.962  1.00 14.01           O  
ATOM    640  CB  ASP    92      15.394   0.057   8.928  1.00 13.56           C  
ATOM    641  CG  ASP    92      16.180  -0.193   7.654  1.00 17.23           C  
ATOM    642  OD1 ASP    92      16.647  -1.335   7.426  1.00 16.56           O  
ATOM    643  OD2 ASP    92      16.330   0.788   6.886  1.00 16.08           O  
ATOM    644  N   ILE    93      13.230  -0.204  11.067  1.00 12.18           N  
ATOM    645  CA  ILE    93      12.724   0.159  12.399  1.00 14.15           C  
ATOM    646  C   ILE    93      12.235  -1.093  13.129  1.00 17.32           C  
ATOM    647  O   ILE    93      12.549  -1.268  14.324  1.00 15.16           O  
ATOM    648  CB  ILE    93      11.617   1.219  12.327  1.00 13.03           C  
ATOM    649  CG1 ILE    93      12.191   2.564  11.848  1.00 12.61           C  
ATOM    650  CG2 ILE    93      11.000   1.412  13.719  1.00 14.05           C  
ATOM    651  CD1 ILE    93      11.121   3.600  11.455  1.00 12.35           C  
ATOM    652  N   ASP    94      11.502  -1.963  12.419  1.00 14.05           N  
ATOM    653  CA  ASP    94      11.083  -3.250  13.017  1.00 16.18           C  
ATOM    654  C   ASP    94      12.256  -3.979  13.665  1.00 15.42           C  
ATOM    655  O   ASP    94      12.155  -4.422  14.814  1.00 17.28           O  
ATOM    656  CB  ASP    94      10.513  -4.217  11.974  1.00 17.07           C  
ATOM    657  CG  ASP    94       9.121  -3.855  11.489  1.00 17.35           C  
ATOM    658  OD1 ASP    94       8.505  -2.885  11.987  1.00 18.27           O  
ATOM    659  OD2 ASP    94       8.633  -4.548  10.555  1.00 21.85           O  
ATOM    660  N   ARG    95      13.367  -4.122  12.932  1.00 15.58           N  
ATOM    661  CA  ARG    95      14.535  -4.842  13.428  1.00 16.07           C  
ATOM    662  C   ARG    95      15.118  -4.171  14.663  1.00 19.11           C  
ATOM    663  O   ARG    95      15.440  -4.833  15.641  1.00 18.91           O  
ATOM    664  CB  ARG    95      15.615  -4.981  12.348  1.00 20.99           C  
ATOM    665  CG  ARG    95      16.734  -5.950  12.716  1.00 29.41           C  
ATOM    666  CD  ARG    95      17.846  -6.022  11.666  1.00 35.92           C  
ATOM    667  NE  ARG    95      19.041  -5.272  12.063  1.00 53.69           N  
ATOM    668  CZ  ARG    95      20.279  -5.526  11.631  1.00 57.40           C  
ATOM    669  NH1 ARG    95      20.511  -6.528  10.781  1.00 50.29           N  
ATOM    670  NH2 ARG    95      21.295  -4.777  12.056  1.00 50.88           N  
ATOM    671  N   ALA    96      15.224  -2.839  14.627  1.00 15.34           N  
ATOM    672  CA  ALA    96      15.780  -2.102  15.748  1.00 15.93           C  
ATOM    673  C   ALA    96      14.919  -2.271  17.000  1.00 16.84           C  
ATOM    674  O   ALA    96      15.439  -2.511  18.081  1.00 17.65           O  
ATOM    675  CB  ALA    96      15.873  -0.633  15.370  1.00 16.45           C  
ATOM    676  N   LEU    97      13.605  -2.139  16.847  1.00 15.40           N  
ATOM    677  CA  LEU    97      12.680  -2.321  17.994  1.00 13.08           C  
ATOM    678  C   LEU    97      12.750  -3.730  18.579  1.00 16.91           C  
ATOM    679  O   LEU    97      12.794  -3.905  19.802  1.00 16.10           O  
ATOM    680  CB  LEU    97      11.253  -1.987  17.596  1.00 13.95           C  
ATOM    681  CG  LEU    97      11.014  -0.503  17.284  1.00 15.23           C  
ATOM    682  CD1 LEU    97       9.596  -0.311  16.828  1.00 17.81           C  
ATOM    683  CD2 LEU    97      11.298   0.351  18.487  1.00 16.90           C  
ATOM    684  N   ARG    98      12.784  -4.716  17.691  1.00 19.05           N  
ATOM    685  CA  ARG    98      12.877  -6.131  18.092  1.00 20.68           C  
ATOM    686  C   ARG    98      14.131  -6.358  18.933  1.00 20.56           C  
ATOM    687  O   ARG    98      14.065  -6.934  20.021  1.00 20.37           O  
ATOM    688  CB  ARG    98      12.881  -7.022  16.843  1.00 19.15           C  
ATOM    689  CG  ARG    98      12.874  -8.519  17.105  1.00 36.63           C  
ATOM    690  CD  ARG    98      12.535  -9.327  15.828  1.00 35.92           C  
ATOM    691  NE  ARG    98      13.244  -8.889  14.616  1.00 42.00           N  
ATOM    692  CZ  ARG    98      12.657  -8.384  13.527  1.00 49.87           C  
ATOM    693  NH1 ARG    98      11.336  -8.239  13.470  1.00 49.31           N  
ATOM    694  NH2 ARG    98      13.394  -8.022  12.482  1.00 44.13           N  
ATOM    695  N   GLU    99      15.250  -5.823  18.468  1.00 16.76           N  
ATOM    696  CA  GLU    99      16.506  -5.965  19.184  1.00 18.98           C  
ATOM    697  C   GLU    99      16.523  -5.234  20.527  1.00 21.82           C  
ATOM    698  O   GLU    99      17.222  -5.656  21.456  1.00 22.66           O  
ATOM    699  CB  GLU    99      17.666  -5.544  18.293  1.00 20.90           C  
ATOM    700  CG  GLU    99      17.841  -6.543  17.134  1.00 26.92           C  
ATOM    701  CD  GLU    99      18.967  -6.203  16.182  1.00 37.81           C  
ATOM    702  OE1 GLU    99      19.767  -5.310  16.503  1.00 37.69           O  
ATOM    703  OE2 GLU    99      19.052  -6.841  15.109  1.00 39.69           O  
ATOM    704  N   GLU   100      15.730  -4.167  20.641  1.00 17.11           N  
ATOM    705  CA  GLU   100      15.619  -3.454  21.902  1.00 17.75           C  
ATOM    706  C   GLU   100      14.556  -4.001  22.837  1.00 16.86           C  
ATOM    707  O   GLU   100      14.469  -3.550  23.983  1.00 20.47           O  
ATOM    708  CB  GLU   100      15.371  -1.964  21.640  1.00 18.83           C  
ATOM    709  CG  GLU   100      16.493  -1.253  20.883  1.00 18.10           C  
ATOM    710  CD  GLU   100      17.824  -1.244  21.638  1.00 31.26           C  
ATOM    711  OE1 GLU   100      17.809  -1.279  22.895  1.00 24.65           O  
ATOM    712  OE2 GLU   100      18.883  -1.200  20.968  1.00 30.33           O  
ATOM    713  N   GLY   101      13.760  -4.962  22.366  1.00 15.44           N  
ATOM    714  CA  GLY   101      12.667  -5.499  23.175  1.00 15.63           C  
ATOM    715  C   GLY   101      11.522  -4.517  23.332  1.00 15.58           C  
ATOM    716  O   GLY   101      10.802  -4.537  24.330  1.00 18.18           O  
ATOM    717  N   ILE   102      11.326  -3.662  22.335  1.00 14.55           N  
ATOM    718  CA  ILE   102      10.278  -2.661  22.376  1.00 12.71           C  
ATOM    719  C   ILE   102       9.208  -3.041  21.358  1.00 15.93           C  
ATOM    720  O   ILE   102       9.564  -3.350  20.214  1.00 16.82           O  
ATOM    721  CB  ILE   102      10.837  -1.270  22.004  1.00 13.71           C  
ATOM    722  CG1 ILE   102      11.898  -0.824  23.021  1.00 15.46           C  
ATOM    723  CG2 ILE   102       9.698  -0.240  21.874  1.00 13.97           C  
ATOM    724  CD1 ILE   102      12.686   0.444  22.609  1.00 13.84           C  
ATOM    725  N   GLU   103       7.930  -3.051  21.762  1.00 14.80           N  
ATOM    726  CA  GLU   103       6.819  -3.287  20.834  1.00 14.37           C  
ATOM    727  C   GLU   103       6.346  -1.975  20.207  1.00 16.25           C  
ATOM    728  O   GLU   103       6.170  -1.894  18.980  1.00 16.50           O  
ATOM    729  CB  GLU   103       5.666  -4.007  21.536  1.00 14.59           C  
ATOM    730  CG  GLU   103       4.478  -4.362  20.618  1.00 23.31           C  
ATOM    731  CD  GLU   103       4.731  -5.541  19.690  1.00 38.88           C  
ATOM    732  OE1 GLU   103       5.747  -6.263  19.848  1.00 40.58           O  
ATOM    733  OE2 GLU   103       3.890  -5.744  18.787  1.00 44.02           O  
ATOM    734  N   LYS   104       6.144  -0.967  21.058  1.00 11.97           N  
ATOM    735  CA  LYS   104       5.641   0.354  20.654  1.00 12.65           C  
ATOM    736  C   LYS   104       6.441   1.416  21.368  1.00 12.46           C  
ATOM    737  O   LYS   104       6.720   1.289  22.552  1.00 12.40           O  
ATOM    738  CB  LYS   104       4.160   0.551  20.980  1.00 14.66           C  
ATOM    739  CG  LYS   104       3.184  -0.415  20.278  1.00 15.66           C  
ATOM    740  CD  LYS   104       3.093  -0.147  18.783  1.00 17.92           C  
ATOM    741  CE  LYS   104       1.964  -0.991  18.176  1.00 18.93           C  
ATOM    742  NZ  LYS   104       1.927  -0.784  16.721  1.00 22.15           N  
ATOM    743  N   VAL   105       6.847   2.455  20.631  1.00 12.16           N  
ATOM    744  CA  VAL   105       7.670   3.513  21.208  1.00 10.51           C  
ATOM    745  C   VAL   105       6.772   4.544  21.856  1.00  9.96           C  
ATOM    746  O   VAL   105       5.568   4.609  21.587  1.00 12.50           O  
ATOM    747  CB  VAL   105       8.559   4.211  20.136  1.00 11.01           C  
ATOM    748  CG1 VAL   105       9.606   3.235  19.613  1.00 13.10           C  
ATOM    749  CG2 VAL   105       7.688   4.808  19.026  1.00 12.29           C  
ATOM    750  N   ASP   106       7.380   5.387  22.687  1.00 11.09           N  
ATOM    751  CA  ASP   106       6.613   6.395  23.402  1.00  9.99           C  
ATOM    752  C   ASP   106       6.445   7.655  22.573  1.00 12.17           C  
ATOM    753  O   ASP   106       5.420   8.311  22.669  1.00 12.24           O  
ATOM    754  CB  ASP   106       7.297   6.743  24.721  1.00 11.76           C  
ATOM    755  CG  ASP   106       7.472   5.526  25.608  1.00 10.29           C  
ATOM    756  OD1 ASP   106       6.536   5.239  26.395  1.00 14.19           O  
ATOM    757  OD2 ASP   106       8.523   4.866  25.562  1.00 10.87           O  
ATOM    758  N   ASP   107       7.462   8.022  21.776  1.00 10.50           N  
ATOM    759  CA  ASP   107       7.385   9.240  20.937  1.00 11.36           C  
ATOM    760  C   ASP   107       8.046   9.027  19.596  1.00  9.58           C  
ATOM    761  O   ASP   107       8.985   8.248  19.481  1.00 10.07           O  
ATOM    762  CB  ASP   107       8.101  10.413  21.595  1.00 11.91           C  
ATOM    763  CG  ASP   107       7.779  10.538  23.051  1.00 11.98           C  
ATOM    764  OD1 ASP   107       6.625  10.852  23.399  1.00 15.21           O  
ATOM    765  OD2 ASP   107       8.690  10.276  23.851  1.00 13.81           O  
ATOM    766  N   VAL   108       7.560   9.755  18.589  1.00  9.74           N  
ATOM    767  CA  VAL   108       8.268   9.888  17.329  1.00  8.61           C  
ATOM    768  C   VAL   108       8.518  11.387  17.167  1.00 11.05           C  
ATOM    769  O   VAL   108       7.583  12.208  17.282  1.00 11.94           O  
ATOM    770  CB  VAL   108       7.426   9.325  16.155  1.00 11.46           C  
ATOM    771  CG1 VAL   108       8.110   9.616  14.804  1.00 14.09           C  
ATOM    772  CG2 VAL   108       7.177   7.803  16.292  1.00 14.03           C  
ATOM    773  N   VAL   109       9.778  11.775  16.978  1.00  9.92           N  
ATOM    774  CA  VAL   109      10.097  13.186  16.779  1.00 11.54           C  
ATOM    775  C   VAL   109      10.829  13.345  15.470  1.00 10.98           C  
ATOM    776  O   VAL   109      11.574  12.456  15.072  1.00 12.56           O  
ATOM    777  CB  VAL   109      10.912  13.788  17.938  1.00 11.55           C  
ATOM    778  CG1 VAL   109      10.234  13.524  19.285  1.00 14.62           C  
ATOM    779  CG2 VAL   109      12.324  13.234  17.963  1.00 13.66           C  
ATOM    780  N   SER   110      10.605  14.469  14.782  1.00  9.10           N  
ATOM    781  CA  SER   110      11.280  14.712  13.524  1.00  9.63           C  
ATOM    782  C   SER   110      11.697  16.168  13.394  1.00  9.21           C  
ATOM    783  O   SER   110      10.871  17.076  13.572  1.00 10.64           O  
ATOM    784  CB  SER   110      10.339  14.386  12.377  1.00 11.38           C  
ATOM    785  OG  SER   110      10.906  14.752  11.108  1.00 12.49           O  
ATOM    786  N   ASP   111      12.975  16.367  13.054  1.00  9.78           N  
ATOM    787  CA  ASP   111      13.502  17.661  12.628  1.00 10.30           C  
ATOM    788  C   ASP   111      13.948  17.541  11.174  1.00 12.59           C  
ATOM    789  O   ASP   111      14.731  18.370  10.700  1.00 14.21           O  
ATOM    790  CB  ASP   111      14.678  18.042  13.517  1.00 12.34           C  
ATOM    791  CG  ASP   111      14.999  19.521  13.476  1.00 17.14           C  
ATOM    792  OD1 ASP   111      14.082  20.342  13.247  1.00 16.72           O  
ATOM    793  OD2 ASP   111      16.181  19.859  13.708  1.00 19.06           O  
ATOM    794  N   ALA   112      13.454  16.527  10.465  1.00 11.25           N  
ATOM    795  CA  ALA   112      13.892  16.275   9.078  1.00 11.10           C  
ATOM    796  C   ALA   112      13.422  17.377   8.141  1.00 13.86           C  
ATOM    797  O   ALA   112      12.283  17.843   8.214  1.00 13.37           O  
ATOM    798  CB  ALA   112      13.363  14.945   8.591  1.00 11.26           C  
ATOM    799  N   MET   113      14.327  17.730   7.238  1.00 13.40           N  
ATOM    800  CA  MET   113      14.080  18.704   6.191  1.00 13.40           C  
ATOM    801  C   MET   113      15.114  18.498   5.091  1.00 13.11           C  
ATOM    802  O   MET   113      16.267  18.145   5.370  1.00 13.85           O  
ATOM    803  CB  MET   113      14.123  20.131   6.730  1.00 14.46           C  
ATOM    804  CG  MET   113      13.833  21.222   5.677  1.00 13.23           C  
ATOM    805  SD  MET   113      12.116  20.916   4.727  0.70 15.43          SE  
ATOM    806  CE  MET   113      12.287  22.453   3.505  1.00 17.59           C  
ATOM    807  N   ALA   114      14.695  18.720   3.846  1.00 13.67           N  
ATOM    808  CA  ALA   114      15.638  18.631   2.739  1.00 16.40           C  
ATOM    809  C   ALA   114      16.282  19.987   2.529  1.00 15.41           C  
ATOM    810  O   ALA   114      16.163  20.856   3.367  1.00 14.70           O  
ATOM    811  CB  ALA   114      14.941  18.156   1.487  1.00 21.46           C  
ATOM    812  N   LYS   115      16.985  20.170   1.419  1.00 15.14           N  
ATOM    813  CA  LYS   115      17.557  21.487   1.150  1.00 15.78           C  
ATOM    814  C   LYS   115      16.471  22.577   1.046  1.00 13.07           C  
ATOM    815  O   LYS   115      15.398  22.359   0.466  1.00 14.83           O  
ATOM    816  CB  LYS   115      18.384  21.466  -0.133  1.00 17.66           C  
ATOM    817  CG  LYS   115      19.659  20.652  -0.013  1.00 20.06           C  
ATOM    818  CD  LYS   115      20.393  20.629  -1.344  1.00 19.58           C  
ATOM    819  CE  LYS   115      21.714  19.898  -1.250  1.00 29.22           C  
ATOM    820  NZ  LYS   115      22.368  19.836  -2.592  1.00 33.84           N  
ATOM    821  N   VAL   116      16.777  23.723   1.653  1.00 13.59           N  
ATOM    822  CA  VAL   116      15.891  24.882   1.767  0.50 13.96           C  
ATOM    824  C   VAL   116      16.070  25.782   0.530  1.00 15.19           C  
ATOM    825  O   VAL   116      17.210  26.085   0.148  1.00 14.70           O  
ATOM    826  CB  VAL   116      16.231  25.658   3.074  0.50 14.92           C  
ATOM    828  CG1 VAL   116      15.448  26.948   3.196  0.50 15.69           C  
ATOM    830  CG2 VAL   116      15.990  24.771   4.328  0.50 17.33           C  
ATOM    832  N   SER   117      14.963  26.201  -0.072  1.00 13.54           N  
ATOM    833  CA  SER   117      15.001  27.069  -1.247  1.00 11.53           C  
ATOM    834  C   SER   117      14.856  28.544  -0.888  1.00 13.31           C  
ATOM    835  O   SER   117      15.171  29.404  -1.713  1.00 15.65           O  
ATOM    836  CB  SER   117      13.865  26.696  -2.189  1.00 13.27           C  
ATOM    837  OG  SER   117      12.606  27.050  -1.610  1.00 13.68           O  
ATOM    838  N   GLY   118      14.357  28.833   0.316  1.00 13.72           N  
ATOM    839  CA  GLY   118      14.073  30.198   0.724  1.00 17.52           C  
ATOM    840  C   GLY   118      12.734  30.709   0.218  1.00 15.20           C  
ATOM    841  O   GLY   118      12.437  31.912   0.363  1.00 18.36           O  
ATOM    842  N   ILE   119      11.923  29.814  -0.356  1.00 13.99           N  
ATOM    843  CA  ILE   119      10.619  30.178  -0.913  1.00 14.12           C  
ATOM    844  C   ILE   119       9.579  29.446  -0.056  1.00 13.80           C  
ATOM    845  O   ILE   119       9.548  28.229  -0.039  1.00 13.42           O  
ATOM    846  CB  ILE   119      10.467  29.693  -2.378  1.00 11.69           C  
ATOM    847  CG1 ILE   119      11.576  30.223  -3.304  1.00 14.24           C  
ATOM    848  CG2 ILE   119       9.084  30.029  -2.926  1.00 13.99           C  
ATOM    849  CD1 ILE   119      11.731  31.748  -3.313  1.00 16.18           C  
ATOM    850  N   PRO   120       8.764  30.194   0.701  1.00 14.28           N  
ATOM    851  CA  PRO   120       7.815  29.543   1.612  1.00 14.71           C  
ATOM    852  C   PRO   120       6.972  28.435   0.981  1.00 13.91           C  
ATOM    853  O   PRO   120       6.846  27.379   1.580  1.00 13.07           O  
ATOM    854  CB  PRO   120       6.942  30.713   2.088  1.00 16.54           C  
ATOM    855  CG  PRO   120       7.921  31.876   2.108  1.00 20.48           C  
ATOM    856  CD  PRO   120       8.742  31.667   0.847  1.00 16.71           C  
ATOM    857  N   SER   121       6.428  28.623  -0.221  1.00 12.41           N  
ATOM    858  CA  SER   121       5.595  27.600  -0.829  1.00 13.18           C  
ATOM    859  C   SER   121       6.374  26.329  -1.122  1.00 13.95           C  
ATOM    860  O   SER   121       5.860  25.244  -0.874  1.00 13.03           O  
ATOM    861  CB  SER   121       4.922  28.091  -2.125  1.00 18.33           C  
ATOM    862  OG  SER   121       5.883  28.515  -3.077  1.00 19.51           O  
ATOM    863  N   ARG   122       7.592  26.473  -1.666  1.00 12.92           N  
ATOM    864  CA  ARG   122       8.398  25.294  -1.995  1.00 13.33           C  
ATOM    865  C   ARG   122       8.831  24.590  -0.738  1.00 12.54           C  
ATOM    866  O   ARG   122       8.801  23.361  -0.669  1.00 13.01           O  
ATOM    867  CB  ARG   122       9.651  25.680  -2.775  1.00 15.70           C  
ATOM    868  CG  ARG   122       9.384  26.107  -4.191  1.00 15.72           C  
ATOM    869  CD  ARG   122      10.687  26.421  -4.930  1.00 14.92           C  
ATOM    870  NE  ARG   122      11.477  25.204  -5.093  1.00 17.78           N  
ATOM    871  CZ  ARG   122      12.717  25.156  -5.578  1.00 17.08           C  
ATOM    872  NH1 ARG   122      13.334  26.269  -5.966  1.00 14.73           N  
ATOM    873  NH2 ARG   122      13.349  23.986  -5.663  1.00 17.62           N  
ATOM    874  N   ASP   123       9.271  25.360   0.249  1.00 10.85           N  
ATOM    875  CA  ASP   123       9.774  24.725   1.459  1.00 10.72           C  
ATOM    876  C   ASP   123       8.636  24.052   2.227  1.00 12.40           C  
ATOM    877  O   ASP   123       8.812  22.953   2.789  1.00 11.60           O  
ATOM    878  CB  ASP   123      10.555  25.712   2.309  1.00 12.96           C  
ATOM    879  CG  ASP   123      11.841  26.184   1.616  1.00 13.68           C  
ATOM    880  OD1 ASP   123      12.315  25.471   0.695  1.00 13.31           O  
ATOM    881  OD2 ASP   123      12.333  27.262   2.001  1.00 15.24           O  
ATOM    882  N   HIS   124       7.440  24.643   2.168  1.00 12.54           N  
ATOM    883  CA  HIS   124       6.249  23.987   2.702  1.00 11.00           C  
ATOM    884  C   HIS   124       6.013  22.648   2.010  1.00 10.83           C  
ATOM    885  O   HIS   124       5.754  21.621   2.647  1.00 11.93           O  
ATOM    886  CB  HIS   124       5.015  24.864   2.495  1.00 11.21           C  
ATOM    887  CG  HIS   124       3.734  24.178   2.840  1.00 10.23           C  
ATOM    888  ND1 HIS   124       3.462  23.724   4.115  1.00 11.30           N  
ATOM    889  CD2 HIS   124       2.654  23.865   2.088  1.00 11.04           C  
ATOM    890  CE1 HIS   124       2.268  23.155   4.129  1.00  9.49           C  
ATOM    891  NE2 HIS   124       1.770  23.205   2.906  1.00 10.84           N  
ATOM    892  N   ALA   125       6.081  22.645   0.677  1.00 11.36           N  
ATOM    893  CA  ALA   125       5.718  21.453  -0.065  1.00 12.11           C  
ATOM    894  C   ALA   125       6.604  20.251   0.294  1.00 11.47           C  
ATOM    895  O   ALA   125       6.107  19.136   0.534  1.00 13.45           O  
ATOM    896  CB  ALA   125       5.759  21.738  -1.578  1.00 13.21           C  
ATOM    897  N   VAL   126       7.910  20.508   0.352  1.00 11.41           N  
ATOM    898  CA  VAL   126       8.910  19.489   0.690  0.50 11.13           C  
ATOM    900  C   VAL   126       8.685  19.016   2.122  1.00 13.15           C  
ATOM    901  O   VAL   126       8.677  17.830   2.410  1.00 13.62           O  
ATOM    902  CB  VAL   126      10.345  20.061   0.529  0.50 10.09           C  
ATOM    904  CG1 VAL   126      11.411  19.100   1.079  0.50 11.60           C  
ATOM    906  CG2 VAL   126      10.613  20.356  -0.940  0.50 10.13           C  
ATOM    908  N   SER   127       8.487  19.987   3.015  1.00 11.21           N  
ATOM    909  CA  SER   127       8.267  19.704   4.430  0.50 10.89           C  
ATOM    911  C   SER   127       6.994  18.889   4.674  1.00 11.26           C  
ATOM    912  O   SER   127       6.967  18.010   5.536  1.00 11.71           O  
ATOM    913  CB  SER   127       8.213  21.012   5.205  0.50 13.85           C  
ATOM    915  OG  SER   127       8.144  20.775   6.582  0.50 12.04           O  
ATOM    917  N   TYR   128       5.929  19.213   3.931  1.00 10.99           N  
ATOM    918  CA  TYR   128       4.664  18.487   4.046  1.00 10.36           C  
ATOM    919  C   TYR   128       4.840  17.017   3.689  1.00 12.02           C  
ATOM    920  O   TYR   128       4.337  16.137   4.415  1.00 12.45           O  
ATOM    921  CB  TYR   128       3.616  19.131   3.143  1.00  9.90           C  
ATOM    922  CG  TYR   128       2.374  18.311   2.989  1.00 10.64           C  
ATOM    923  CD1 TYR   128       1.401  18.313   3.990  1.00 12.75           C  
ATOM    924  CD2 TYR   128       2.149  17.576   1.838  1.00 10.69           C  
ATOM    925  CE1 TYR   128       0.231  17.571   3.847  1.00 12.99           C  
ATOM    926  CE2 TYR   128       1.000  16.796   1.690  1.00 14.34           C  
ATOM    927  CZ  TYR   128       0.037  16.811   2.701  1.00 14.74           C  
ATOM    928  OH  TYR   128      -1.130  16.062   2.554  1.00 19.35           O  
ATOM    929  N   GLN   129       5.561  16.745   2.587  1.00 12.30           N  
ATOM    930  CA  GLN   129       5.778  15.368   2.159  0.50 11.89           C  
ATOM    932  C   GLN   129       6.551  14.579   3.213  1.00 11.90           C  
ATOM    933  O   GLN   129       6.223  13.433   3.494  1.00 13.97           O  
ATOM    934  CB  GLN   129       6.463  15.319   0.790  0.50 17.43           C  
ATOM    936  CG  GLN   129       5.564  15.766  -0.373  0.50 21.28           C  
ATOM    938  CD  GLN   129       4.328  14.888  -0.571  0.50 27.50           C  
ATOM    940  OE1 GLN   129       3.227  15.395  -0.790  0.50 37.10           O  
ATOM    942  NE2 GLN   129       4.507  13.573  -0.502  0.50 39.43           N  
ATOM    944  N   ILE   130       7.546  15.214   3.816  1.00 10.99           N  
ATOM    945  CA  ILE   130       8.265  14.597   4.924  1.00 11.28           C  
ATOM    946  C   ILE   130       7.298  14.331   6.093  1.00 10.32           C  
ATOM    947  O   ILE   130       7.309  13.247   6.687  1.00 11.94           O  
ATOM    948  CB  ILE   130       9.456  15.480   5.369  1.00 10.79           C  
ATOM    949  CG1 ILE   130      10.539  15.476   4.263  1.00 12.69           C  
ATOM    950  CG2 ILE   130       9.987  15.048   6.769  1.00 11.24           C  
ATOM    951  CD1 ILE   130      11.663  16.488   4.451  1.00 13.94           C  
ATOM    952  N   GLY   131       6.468  15.325   6.412  1.00 10.56           N  
ATOM    953  CA  GLY   131       5.536  15.217   7.541  1.00 10.56           C  
ATOM    954  C   GLY   131       4.578  14.052   7.347  1.00 12.07           C  
ATOM    955  O   GLY   131       4.317  13.291   8.292  1.00 12.17           O  
ATOM    956  N   GLN   132       4.050  13.892   6.134  1.00 12.52           N  
ATOM    957  CA  GLN   132       3.177  12.763   5.827  1.00 13.85           C  
ATOM    958  C   GLN   132       3.827  11.420   6.131  1.00 11.58           C  
ATOM    959  O   GLN   132       3.199  10.536   6.740  1.00 13.19           O  
ATOM    960  CB  GLN   132       2.736  12.814   4.359  1.00 13.17           C  
ATOM    961  CG  GLN   132       1.733  13.902   4.071  1.00 16.82           C  
ATOM    962  CD  GLN   132       0.401  13.611   4.732  1.00 20.54           C  
ATOM    963  OE1 GLN   132       0.089  14.171   5.780  1.00 22.06           O  
ATOM    964  NE2 GLN   132      -0.378  12.700   4.144  1.00 24.13           N  
ATOM    965  N   ARG   133       5.088  11.261   5.723  1.00 11.88           N  
ATOM    966  CA  ARG   133       5.782   9.999   5.936  1.00 11.18           C  
ATOM    967  C   ARG   133       6.121   9.800   7.426  1.00 10.84           C  
ATOM    968  O   ARG   133       6.039   8.693   7.944  1.00 12.01           O  
ATOM    969  CB  ARG   133       7.005   9.914   5.020  1.00 12.43           C  
ATOM    970  CG  ARG   133       7.758   8.586   5.061  1.00 13.14           C  
ATOM    971  CD  ARG   133       6.902   7.426   4.535  1.00 14.39           C  
ATOM    972  NE  ARG   133       7.781   6.378   4.031  1.00 18.04           N  
ATOM    973  CZ  ARG   133       7.380   5.306   3.371  1.00 15.95           C  
ATOM    974  NH1 ARG   133       6.083   5.109   3.148  1.00 18.22           N  
ATOM    975  NH2 ARG   133       8.277   4.420   2.952  1.00 17.71           N  
ATOM    976  N   VAL   134       6.483  10.879   8.117  1.00 11.86           N  
ATOM    977  CA  VAL   134       6.704  10.813   9.564  1.00 11.94           C  
ATOM    978  C   VAL   134       5.443  10.329  10.269  1.00 10.69           C  
ATOM    979  O   VAL   134       5.500   9.471  11.160  1.00 12.44           O  
ATOM    980  CB  VAL   134       7.171  12.173  10.137  1.00 11.36           C  
ATOM    981  CG1 VAL   134       7.164  12.156  11.665  1.00 11.92           C  
ATOM    982  CG2 VAL   134       8.567  12.493   9.608  1.00 13.37           C  
ATOM    983  N   MET   135       4.291  10.852   9.860  1.00 11.80           N  
ATOM    984  CA  MET   135       3.045  10.414  10.507  1.00 12.72           C  
ATOM    985  C   MET   135       2.715   8.968  10.190  1.00 12.07           C  
ATOM    986  O   MET   135       2.195   8.258  11.064  1.00 12.57           O  
ATOM    987  CB  MET   135       1.880  11.317  10.131  1.00 13.33           C  
ATOM    988  CG  MET   135       2.034  12.771  10.541  1.00 14.97           C  
ATOM    989  SD  MET   135       2.476  12.977  12.442  0.70 14.74          SE  
ATOM    990  CE  MET   135       0.918  12.078  13.211  1.00 17.71           C  
ATOM    991  N   GLU   136       3.011   8.522   8.968  1.00 13.34           N  
ATOM    992  CA  GLU   136       2.786   7.116   8.638  1.00 14.66           C  
ATOM    993  C   GLU   136       3.637   6.218   9.539  1.00 13.86           C  
ATOM    994  O   GLU   136       3.169   5.190  10.048  1.00 14.68           O  
ATOM    995  CB  GLU   136       3.073   6.851   7.158  1.00 14.11           C  
ATOM    996  CG  GLU   136       2.850   5.419   6.721  1.00 19.12           C  
ATOM    997  CD  GLU   136       3.271   5.132   5.281  1.00 25.99           C  
ATOM    998  OE1 GLU   136       3.825   6.028   4.592  1.00 22.32           O  
ATOM    999  OE2 GLU   136       3.039   3.978   4.856  1.00 26.05           O  
ATOM   1000  N   ILE   137       4.866   6.651   9.806  1.00 11.87           N  
ATOM   1001  CA  ILE   137       5.759   5.917  10.725  1.00 12.27           C  
ATOM   1002  C   ILE   137       5.200   5.972  12.152  1.00 14.18           C  
ATOM   1003  O   ILE   137       5.159   4.958  12.879  1.00 14.08           O  
ATOM   1004  CB  ILE   137       7.197   6.523  10.671  1.00 14.79           C  
ATOM   1005  CG1 ILE   137       7.818   6.226   9.301  1.00 14.66           C  
ATOM   1006  CG2 ILE   137       8.092   6.057  11.823  1.00 17.41           C  
ATOM   1007  CD1 ILE   137       9.049   7.054   8.968  1.00 14.56           C  
ATOM   1008  N   ALA   138       4.756   7.155  12.564  1.00 13.36           N  
ATOM   1009  CA  ALA   138       4.239   7.308  13.920  1.00 15.50           C  
ATOM   1010  C   ALA   138       3.055   6.392  14.183  1.00 17.10           C  
ATOM   1011  O   ALA   138       3.029   5.691  15.197  1.00 17.07           O  
ATOM   1012  CB  ALA   138       3.863   8.740  14.187  1.00 14.77           C  
ATOM   1013  N   VAL   139       2.076   6.364  13.290  1.00 14.22           N  
ATOM   1014  CA  VAL   139       0.893   5.559  13.602  1.00 17.81           C  
ATOM   1015  C   VAL   139       1.211   4.051  13.593  1.00 16.57           C  
ATOM   1016  O   VAL   139       0.520   3.268  14.255  1.00 18.88           O  
ATOM   1017  CB  VAL   139      -0.350   5.940  12.747  1.00 25.03           C  
ATOM   1018  CG1 VAL   139      -0.700   7.418  12.942  1.00 23.47           C  
ATOM   1019  CG2 VAL   139      -0.116   5.632  11.315  1.00 23.85           C  
ATOM   1020  N   ARG   140       2.260   3.651  12.881  1.00 14.60           N  
ATOM   1021  CA  ARG   140       2.713   2.272  12.855  1.00 14.63           C  
ATOM   1022  C   ARG   140       3.375   1.842  14.176  1.00 14.50           C  
ATOM   1023  O   ARG   140       3.273   0.670  14.584  1.00 16.94           O  
ATOM   1024  CB  ARG   140       3.722   2.106  11.729  1.00 17.48           C  
ATOM   1025  CG  ARG   140       4.114   0.710  11.407  1.00 23.55           C  
ATOM   1026  CD  ARG   140       4.253   0.612   9.922  1.00 28.61           C  
ATOM   1027  NE  ARG   140       4.768  -0.681   9.510  1.00 35.75           N  
ATOM   1028  CZ  ARG   140       4.692  -1.131   8.267  1.00 23.47           C  
ATOM   1029  NH1 ARG   140       4.095  -0.390   7.329  1.00 25.25           N  
ATOM   1030  NH2 ARG   140       5.191  -2.319   7.969  1.00 33.07           N  
ATOM   1031  N   TYR   141       4.078   2.770  14.845  1.00 12.86           N  
ATOM   1032  CA  TYR   141       4.960   2.361  15.935  1.00 12.52           C  
ATOM   1033  C   TYR   141       4.629   2.955  17.296  1.00 10.49           C  
ATOM   1034  O   TYR   141       5.192   2.517  18.288  1.00 11.91           O  
ATOM   1035  CB  TYR   141       6.417   2.676  15.606  1.00 11.72           C  
ATOM   1036  CG  TYR   141       6.939   1.896  14.435  1.00 15.03           C  
ATOM   1037  CD1 TYR   141       7.106   0.514  14.520  1.00 15.39           C  
ATOM   1038  CD2 TYR   141       7.242   2.533  13.239  1.00 15.09           C  
ATOM   1039  CE1 TYR   141       7.577  -0.210  13.439  1.00 16.45           C  
ATOM   1040  CE2 TYR   141       7.712   1.832  12.159  1.00 17.80           C  
ATOM   1041  CZ  TYR   141       7.872   0.467  12.249  1.00 17.33           C  
ATOM   1042  OH  TYR   141       8.350  -0.169  11.125  1.00 18.29           O  
ATOM   1043  N   LEU   142       3.742   3.950  17.349  1.00 10.86           N  
ATOM   1044  CA  LEU   142       3.441   4.618  18.622  0.50 11.36           C  
ATOM   1046  C   LEU   142       2.571   3.806  19.548  1.00 13.48           C  
ATOM   1047  O   LEU   142       1.594   3.191  19.112  1.00 14.78           O  
ATOM   1048  CB  LEU   142       2.723   5.941  18.416  0.50 11.66           C  
ATOM   1050  CG  LEU   142       3.563   7.179  18.176  0.50  9.60           C  
ATOM   1052  CD1 LEU   142       2.600   8.224  17.674  0.50 14.73           C  
ATOM   1054  CD2 LEU   142       4.278   7.649  19.457  0.50 11.81           C  
ATOM   1056  N   ARG   143       2.901   3.846  20.837  1.00 12.69           N  
ATOM   1057  CA  ARG   143       2.033   3.237  21.845  1.00 13.33           C  
ATOM   1058  C   ARG   143       0.826   4.130  22.018  1.00 14.30           C  
ATOM   1059  O   ARG   143       0.884   5.351  21.765  1.00 14.62           O  
ATOM   1060  CB  ARG   143       2.752   3.055  23.194  1.00 15.19           C  
ATOM   1061  CG  ARG   143       3.082   4.318  23.972  1.00 13.79           C  
ATOM   1062  CD  ARG   143       3.539   3.944  25.394  1.00 16.54           C  
ATOM   1063  NE  ARG   143       3.892   5.104  26.190  1.00 18.51           N  
ATOM   1064  CZ  ARG   143       3.032   5.816  26.914  1.00 20.32           C  
ATOM   1065  NH1 ARG   143       1.738   5.491  26.943  1.00 23.94           N  
ATOM   1066  NH2 ARG   143       3.464   6.847  27.622  1.00 24.25           N  
ATOM   1067  N   ASN   144      -0.271   3.530  22.476  1.00 15.98           N  
ATOM   1068  CA  ASN   144      -1.406   4.304  22.952  0.50 16.67           C  
ATOM   1070  C   ASN   144      -0.921   5.238  24.030  1.00 14.32           C  
ATOM   1071  O   ASN   144      -0.252   4.786  24.965  1.00 16.71           O  
ATOM   1072  CB  ASN   144      -2.467   3.388  23.551  0.50 15.10           C  
ATOM   1074  CG  ASN   144      -3.203   2.613  22.509  0.50 27.23           C  
ATOM   1076  OD1 ASN   144      -3.474   3.128  21.432  0.50 29.27           O  
ATOM   1078  ND2 ASN   144      -3.542   1.362  22.818  0.50 20.43           N  
ATOM   1080  N   GLY   145      -1.245   6.519  23.892  1.00 13.95           N  
ATOM   1081  CA  GLY   145      -0.760   7.549  24.793  1.00 13.60           C  
ATOM   1082  C   GLY   145       0.538   8.244  24.347  1.00 15.52           C  
ATOM   1083  O   GLY   145       1.003   9.170  25.010  1.00 19.43           O  
ATOM   1084  N   GLY   146       1.119   7.788  23.235  1.00 14.32           N  
ATOM   1085  CA  GLY   146       2.390   8.342  22.745  1.00 14.96           C  
ATOM   1086  C   GLY   146       2.242   9.696  22.063  1.00 12.11           C  
ATOM   1087  O   GLY   146       1.129  10.096  21.713  1.00 12.15           O  
ATOM   1088  N   ASN   147       3.368  10.378  21.882  1.00 12.02           N  
ATOM   1089  CA  ASN   147       3.384  11.718  21.315  1.00 10.79           C  
ATOM   1090  C   ASN   147       4.188  11.817  20.029  1.00 11.00           C  
ATOM   1091  O   ASN   147       5.095  11.005  19.790  1.00 10.12           O  
ATOM   1092  CB  ASN   147       4.028  12.711  22.298  1.00 13.03           C  
ATOM   1093  CG  ASN   147       3.254  12.859  23.595  1.00 14.49           C  
ATOM   1094  OD1 ASN   147       2.062  12.540  23.674  1.00 14.43           O  
ATOM   1095  ND2 ASN   147       3.935  13.349  24.618  1.00 15.04           N  
ATOM   1096  N   VAL   148       3.875  12.836  19.229  1.00 10.08           N  
ATOM   1097  CA  VAL   148       4.678  13.200  18.054  1.00 10.32           C  
ATOM   1098  C   VAL   148       5.112  14.659  18.127  1.00 10.96           C  
ATOM   1099  O   VAL   148       4.328  15.526  18.524  1.00 12.33           O  
ATOM   1100  CB  VAL   148       3.911  12.970  16.729  1.00 11.82           C  
ATOM   1101  CG1 VAL   148       4.750  13.388  15.517  1.00 13.57           C  
ATOM   1102  CG2 VAL   148       3.550  11.547  16.594  1.00 13.33           C  
ATOM   1103  N   LEU   149       6.360  14.917  17.737  1.00  9.54           N  
ATOM   1104  CA  LEU   149       6.847  16.284  17.535  1.00 10.13           C  
ATOM   1105  C   LEU   149       7.401  16.330  16.129  1.00  9.76           C  
ATOM   1106  O   LEU   149       8.202  15.491  15.769  1.00 10.76           O  
ATOM   1107  CB  LEU   149       7.977  16.622  18.518  1.00 12.13           C  
ATOM   1108  CG  LEU   149       8.880  17.829  18.198  1.00 11.89           C  
ATOM   1109  CD1 LEU   149       8.058  19.099  18.208  1.00 13.01           C  
ATOM   1110  CD2 LEU   149      10.021  17.909  19.210  1.00 14.70           C  
ATOM   1111  N   LEU   150       6.970  17.296  15.313  1.00  8.99           N  
ATOM   1112  CA  LEU   150       7.511  17.380  13.962  0.50 11.44           C  
ATOM   1114  C   LEU   150       7.656  18.800  13.473  1.00 12.24           C  
ATOM   1115  O   LEU   150       6.793  19.675  13.686  1.00 12.49           O  
ATOM   1116  CB  LEU   150       6.712  16.536  12.949  0.50 20.07           C  
ATOM   1118  CG  LEU   150       5.352  17.056  12.470  0.50 21.76           C  
ATOM   1120  CD1 LEU   150       5.133  16.793  10.984  0.50 23.31           C  
ATOM   1122  CD2 LEU   150       4.213  16.474  13.281  0.50 26.23           C  
ATOM   1124  N   LYS   151       8.809  19.031  12.839  1.00 11.05           N  
ATOM   1125  CA  LYS   151       9.069  20.312  12.200  1.00 12.47           C  
ATOM   1126  C   LYS   151       8.279  20.375  10.888  1.00 12.07           C  
ATOM   1127  O   LYS   151       8.258  19.406  10.103  1.00 11.40           O  
ATOM   1128  CB  LYS   151      10.563  20.476  11.890  1.00 15.74           C  
ATOM   1129  CG  LYS   151      10.857  21.850  11.284  1.00 15.82           C  
ATOM   1130  CD  LYS   151      12.303  22.226  11.298  1.00 23.41           C  
ATOM   1131  CE  LYS   151      13.066  21.415  10.296  1.00 23.56           C  
ATOM   1132  NZ  LYS   151      14.517  21.541  10.640  1.00 28.21           N  
ATOM   1133  N   GLN   152       7.663  21.529  10.632  1.00 11.33           N  
ATOM   1134  CA  GLN   152       7.024  21.794   9.346  1.00  9.32           C  
ATOM   1135  C   GLN   152       7.236  23.254   8.961  1.00 13.53           C  
ATOM   1136  O   GLN   152       7.270  24.131   9.811  1.00 16.85           O  
ATOM   1137  CB  GLN   152       5.521  21.478   9.397  1.00 11.40           C  
ATOM   1138  CG  GLN   152       4.805  21.567   8.029  1.00 12.88           C  
ATOM   1139  CD  GLN   152       3.428  20.909   7.999  1.00 15.18           C  
ATOM   1140  OE1 GLN   152       2.407  21.585   7.807  1.00 16.33           O  
ATOM   1141  NE2 GLN   152       3.394  19.588   8.162  1.00 13.42           N  
ATOM   1142  N   PHE   153       7.390  23.505   7.673  1.00 11.92           N  
ATOM   1143  CA  PHE   153       7.368  24.860   7.177  1.00 13.28           C  
ATOM   1144  C   PHE   153       5.909  25.142   6.823  1.00 12.52           C  
ATOM   1145  O   PHE   153       5.315  24.398   6.033  1.00 14.65           O  
ATOM   1146  CB  PHE   153       8.313  24.968   5.976  1.00 16.75           C  
ATOM   1147  CG  PHE   153       9.772  25.034   6.367  1.00 15.41           C  
ATOM   1148  CD1 PHE   153      10.418  26.266   6.415  1.00 23.92           C  
ATOM   1149  CD2 PHE   153      10.488  23.902   6.733  1.00 18.53           C  
ATOM   1150  CE1 PHE   153      11.767  26.364   6.787  1.00 25.02           C  
ATOM   1151  CE2 PHE   153      11.851  24.006   7.130  1.00 18.44           C  
ATOM   1152  CZ  PHE   153      12.476  25.232   7.132  1.00 23.62           C  
ATOM   1153  N   GLN   154       5.336  26.191   7.414  1.00 12.75           N  
ATOM   1154  CA  GLN   154       3.898  26.435   7.325  1.00 14.37           C  
ATOM   1155  C   GLN   154       3.474  26.798   5.902  1.00 14.38           C  
ATOM   1156  O   GLN   154       4.179  27.504   5.181  1.00 13.34           O  
ATOM   1157  CB  GLN   154       3.497  27.565   8.284  1.00 18.17           C  
ATOM   1158  CG  GLN   154       1.971  27.723   8.437  1.00 23.89           C  
ATOM   1159  CD  GLN   154       1.567  28.266   9.789  1.00 37.14           C  
ATOM   1160  OE1 GLN   154       2.246  29.124  10.356  1.00 41.97           O  
ATOM   1161  NE2 GLN   154       0.451  27.766  10.318  1.00 46.60           N  
ATOM   1162  N   GLY   155       2.301  26.314   5.515  1.00 11.64           N  
ATOM   1163  CA  GLY   155       1.732  26.708   4.223  1.00 11.82           C  
ATOM   1164  C   GLY   155       0.327  26.182   4.073  1.00 11.40           C  
ATOM   1165  O   GLY   155      -0.336  25.849   5.060  1.00 12.08           O  
ATOM   1166  N   ASP   156      -0.138  26.104   2.830  1.00 11.38           N  
ATOM   1167  CA  ASP   156      -1.538  25.804   2.554  1.00 12.44           C  
ATOM   1168  C   ASP   156      -1.982  24.534   3.272  1.00 13.47           C  
ATOM   1169  O   ASP   156      -3.104  24.452   3.772  1.00 14.62           O  
ATOM   1170  CB  ASP   156      -1.768  25.664   1.048  1.00 11.62           C  
ATOM   1171  CG  ASP   156      -1.751  26.999   0.330  1.00 14.84           C  
ATOM   1172  OD1 ASP   156      -1.882  28.041   1.006  1.00 13.69           O  
ATOM   1173  OD2 ASP   156      -1.606  27.007  -0.911  1.00 14.10           O  
ATOM   1174  N   MET   157      -1.095  23.545   3.319  1.00 11.53           N  
ATOM   1175  CA  MET   157      -1.484  22.182   3.659  1.00 12.40           C  
ATOM   1176  C   MET   157      -1.526  21.982   5.170  1.00 10.48           C  
ATOM   1177  O   MET   157      -1.946  20.932   5.656  1.00 12.88           O  
ATOM   1178  CB  MET   157      -0.524  21.176   3.022  1.00 13.36           C  
ATOM   1179  CG  MET   157      -0.571  21.150   1.503  1.00 11.62           C  
ATOM   1180  SD  MET   157      -2.370  20.854   0.810  0.70 16.42          SE  
ATOM   1181  CE  MET   157      -2.754  19.154   1.684  1.00 16.01           C  
ATOM   1182  N   THR   158      -1.087  22.996   5.909  1.00 11.91           N  
ATOM   1183  CA  THR   158      -0.832  22.849   7.346  1.00 11.22           C  
ATOM   1184  C   THR   158      -2.101  22.627   8.154  1.00 13.90           C  
ATOM   1185  O   THR   158      -2.183  21.670   8.935  1.00 11.92           O  
ATOM   1186  CB  THR   158      -0.027  24.021   7.916  1.00 12.96           C  
ATOM   1187  OG1 THR   158       1.250  24.065   7.252  1.00 12.46           O  
ATOM   1188  CG2 THR   158       0.188  23.831   9.441  1.00 15.05           C  
ATOM   1189  N   ASN   159      -3.103  23.472   7.928  1.00 13.35           N  
ATOM   1190  CA  ASN   159      -4.340  23.307   8.693  1.00 14.30           C  
ATOM   1191  C   ASN   159      -5.052  22.013   8.390  1.00 12.35           C  
ATOM   1192  O   ASN   159      -5.561  21.352   9.306  1.00 15.82           O  
ATOM   1193  CB  ASN   159      -5.285  24.484   8.480  1.00 16.47           C  
ATOM   1194  CG  ASN   159      -4.833  25.709   9.213  1.00 21.05           C  
ATOM   1195  OD1 ASN   159      -3.877  25.658   9.986  1.00 22.39           O  
ATOM   1196  ND2 ASN   159      -5.512  26.828   8.978  1.00 24.55           N  
ATOM   1197  N   ASP   160      -5.045  21.608   7.117  1.00 13.38           N  
ATOM   1198  CA  ASP   160      -5.652  20.343   6.741  0.50 12.59           C  
ATOM   1200  C   ASP   160      -4.886  19.124   7.297  1.00 14.86           C  
ATOM   1201  O   ASP   160      -5.504  18.139   7.723  1.00 17.44           O  
ATOM   1202  CB  ASP   160      -5.838  20.269   5.214  0.50 16.57           C  
ATOM   1204  CG  ASP   160      -7.056  21.076   4.719  0.50 22.87           C  
ATOM   1206  OD1 ASP   160      -7.115  22.314   4.906  0.50 15.88           O  
ATOM   1208  OD2 ASP   160      -7.956  20.470   4.094  0.50 19.25           O  
ATOM   1210  N   PHE   161      -3.549  19.211   7.316  1.00 14.31           N  
ATOM   1211  CA  PHE   161      -2.656  18.197   7.890  1.00 14.03           C  
ATOM   1212  C   PHE   161      -3.006  17.995   9.378  1.00 11.91           C  
ATOM   1213  O   PHE   161      -3.197  16.851   9.829  1.00 14.86           O  
ATOM   1214  CB  PHE   161      -1.192  18.665   7.692  1.00 12.85           C  
ATOM   1215  CG  PHE   161      -0.150  17.778   8.326  1.00 12.52           C  
ATOM   1216  CD1 PHE   161       0.404  16.743   7.591  1.00 15.17           C  
ATOM   1217  CD2 PHE   161       0.321  18.003   9.640  1.00 12.26           C  
ATOM   1218  CE1 PHE   161       1.376  15.926   8.139  1.00 15.39           C  
ATOM   1219  CE2 PHE   161       1.292  17.175  10.192  1.00 14.73           C  
ATOM   1220  CZ  PHE   161       1.819  16.153   9.435  1.00 14.16           C  
ATOM   1221  N   ILE   162      -3.104  19.107  10.108  1.00 12.59           N  
ATOM   1222  CA  ILE   162      -3.429  19.063  11.516  1.00 13.26           C  
ATOM   1223  C   ILE   162      -4.823  18.505  11.726  1.00 14.67           C  
ATOM   1224  O   ILE   162      -4.990  17.642  12.585  1.00 17.12           O  
ATOM   1225  CB  ILE   162      -3.250  20.441  12.162  1.00 13.98           C  
ATOM   1226  CG1 ILE   162      -1.761  20.787  12.181  1.00 15.65           C  
ATOM   1227  CG2 ILE   162      -3.835  20.489  13.604  1.00 16.81           C  
ATOM   1228  CD1 ILE   162      -1.495  22.170  12.613  1.00 16.81           C  
ATOM   1229  N   ALA   163      -5.789  18.953  10.912  1.00 13.67           N  
ATOM   1230  CA  ALA   163      -7.183  18.497  11.059  1.00 15.76           C  
ATOM   1231  C   ALA   163      -7.291  16.988  10.871  1.00 17.54           C  
ATOM   1232  O   ALA   163      -8.055  16.321  11.584  1.00 20.78           O  
ATOM   1233  CB  ALA   163      -8.095  19.224  10.095  1.00 17.98           C  
ATOM   1234  N   ILE   164      -6.536  16.441   9.913  1.00 15.90           N  
ATOM   1235  CA  ILE   164      -6.589  15.011   9.610  1.00 16.22           C  
ATOM   1236  C   ILE   164      -5.888  14.208  10.704  1.00 19.24           C  
ATOM   1237  O   ILE   164      -6.469  13.282  11.287  1.00 20.94           O  
ATOM   1238  CB  ILE   164      -6.008  14.690   8.200  1.00 19.88           C  
ATOM   1239  CG1 ILE   164      -6.947  15.210   7.097  1.00 22.44           C  
ATOM   1240  CG2 ILE   164      -5.752  13.191   8.028  1.00 22.35           C  
ATOM   1241  CD1 ILE   164      -6.292  15.382   5.739  1.00 28.45           C  
ATOM   1242  N   TRP   165      -4.650  14.577  11.016  1.00 15.75           N  
ATOM   1243  CA  TRP   165      -3.852  13.749  11.922  1.00 19.10           C  
ATOM   1244  C   TRP   165      -4.288  13.829  13.376  1.00 15.64           C  
ATOM   1245  O   TRP   165      -4.101  12.864  14.129  1.00 18.93           O  
ATOM   1246  CB  TRP   165      -2.349  14.030  11.765  1.00 16.07           C  
ATOM   1247  CG  TRP   165      -1.815  13.501  10.472  1.00 15.98           C  
ATOM   1248  CD1 TRP   165      -1.403  14.233   9.384  1.00 17.48           C  
ATOM   1249  CD2 TRP   165      -1.671  12.121  10.097  1.00 14.31           C  
ATOM   1250  NE1 TRP   165      -0.997  13.397   8.376  1.00 16.98           N  
ATOM   1251  CE2 TRP   165      -1.163  12.098   8.779  1.00 17.19           C  
ATOM   1252  CE3 TRP   165      -1.905  10.903  10.753  1.00 18.10           C  
ATOM   1253  CZ2 TRP   165      -0.875  10.903   8.105  1.00 17.54           C  
ATOM   1254  CZ3 TRP   165      -1.634   9.719  10.074  1.00 17.05           C  
ATOM   1255  CH2 TRP   165      -1.119   9.728   8.771  1.00 19.78           C  
ATOM   1256  N   ARG   166      -4.891  14.955  13.767  1.00 14.46           N  
ATOM   1257  CA  ARG   166      -5.303  15.123  15.173  1.00 17.91           C  
ATOM   1258  C   ARG   166      -6.444  14.205  15.583  1.00 18.87           C  
ATOM   1259  O   ARG   166      -6.679  14.029  16.777  1.00 22.29           O  
ATOM   1260  CB  ARG   166      -5.641  16.572  15.522  1.00 22.23           C  
ATOM   1261  CG  ARG   166      -6.984  17.076  15.044  1.00 22.75           C  
ATOM   1262  CD  ARG   166      -7.045  18.555  15.325  1.00 33.12           C  
ATOM   1263  NE  ARG   166      -8.271  19.178  14.863  1.00 34.39           N  
ATOM   1264  CZ  ARG   166      -9.360  19.321  15.608  1.00 42.29           C  
ATOM   1265  NH1 ARG   166     -10.426  19.909  15.088  1.00 44.12           N  
ATOM   1266  NH2 ARG   166      -9.383  18.880  16.860  1.00 38.24           N  
ATOM   1267  N   LYS   167      -7.109  13.605  14.595  1.00 20.24           N  
ATOM   1268  CA  LYS   167      -8.148  12.593  14.833  1.00 22.36           C  
ATOM   1269  C   LYS   167      -7.604  11.337  15.528  1.00 23.24           C  
ATOM   1270  O   LYS   167      -8.370  10.587  16.133  1.00 23.92           O  
ATOM   1271  CB  LYS   167      -8.811  12.209  13.513  1.00 21.65           C  
ATOM   1272  CG  LYS   167      -9.668  13.306  12.912  1.00 25.38           C  
ATOM   1273  CD  LYS   167     -10.216  12.866  11.556  1.00 37.24           C  
ATOM   1274  CE  LYS   167     -11.133  13.921  10.960  1.00 47.22           C  
ATOM   1275  NZ  LYS   167     -11.554  13.576   9.571  1.00 57.19           N  
ATOM   1276  N   ASN   168      -6.291  11.106  15.434  1.00 20.02           N  
ATOM   1277  CA  ASN   168      -5.632   9.961  16.092  1.00 21.18           C  
ATOM   1278  C   ASN   168      -5.032  10.308  17.460  1.00 17.20           C  
ATOM   1279  O   ASN   168      -4.284   9.511  18.038  1.00 18.97           O  
ATOM   1280  CB  ASN   168      -4.524   9.384  15.204  1.00 24.01           C  
ATOM   1281  CG  ASN   168      -4.997   9.070  13.807  1.00 29.97           C  
ATOM   1282  OD1 ASN   168      -5.571   8.016  13.556  1.00 38.36           O  
ATOM   1283  ND2 ASN   168      -4.750   9.988  12.884  1.00 35.11           N  
ATOM   1284  N   PHE   169      -5.329  11.504  17.958  1.00 17.50           N  
ATOM   1285  CA  PHE   169      -4.700  12.009  19.172  1.00 19.00           C  
ATOM   1286  C   PHE   169      -5.681  12.734  20.095  1.00 19.40           C  
ATOM   1287  O   PHE   169      -6.741  13.197  19.659  1.00 22.92           O  
ATOM   1288  CB  PHE   169      -3.525  12.940  18.830  1.00 15.77           C  
ATOM   1289  CG  PHE   169      -2.365  12.233  18.154  1.00 13.65           C  
ATOM   1290  CD1 PHE   169      -1.297  11.733  18.900  1.00 12.61           C  
ATOM   1291  CD2 PHE   169      -2.314  12.125  16.767  1.00 12.39           C  
ATOM   1292  CE1 PHE   169      -0.211  11.096  18.262  1.00 12.66           C  
ATOM   1293  CE2 PHE   169      -1.247  11.496  16.134  1.00 12.84           C  
ATOM   1294  CZ  PHE   169      -0.203  10.980  16.878  1.00 13.03           C  
ATOM   1295  N   SER   170      -5.303  12.819  21.366  1.00 17.70           N  
ATOM   1296  CA  SER   170      -6.109  13.503  22.370  0.50 20.33           C  
ATOM   1298  C   SER   170      -6.104  15.017  22.173  1.00 23.24           C  
ATOM   1299  O   SER   170      -7.136  15.682  22.371  1.00 22.67           O  
ATOM   1300  CB  SER   170      -5.616  13.134  23.771  0.50 21.72           C  
ATOM   1302  OG  SER   170      -5.662  11.732  23.953  0.50 23.48           O  
ATOM   1304  N   SER   171      -4.957  15.564  21.759  1.00 17.62           N  
ATOM   1305  CA  SER   171      -4.808  16.999  21.555  1.00 17.90           C  
ATOM   1306  C   SER   171      -3.626  17.327  20.640  1.00 17.62           C  
ATOM   1307  O   SER   171      -2.849  16.447  20.276  1.00 16.20           O  
ATOM   1308  CB  SER   171      -4.610  17.718  22.896  1.00 18.97           C  
ATOM   1309  OG  SER   171      -3.388  17.332  23.527  1.00 20.91           O  
ATOM   1310  N   TYR   172      -3.493  18.594  20.270  1.00 15.71           N  
ATOM   1311  CA  TYR   172      -2.332  19.040  19.515  1.00 14.60           C  
ATOM   1312  C   TYR   172      -1.932  20.430  19.958  1.00 17.02           C  
ATOM   1313  O   TYR   172      -2.754  21.163  20.549  1.00 16.90           O  
ATOM   1314  CB  TYR   172      -2.604  19.043  17.992  1.00 15.60           C  
ATOM   1315  CG  TYR   172      -3.399  20.235  17.502  1.00 19.02           C  
ATOM   1316  CD1 TYR   172      -2.763  21.389  17.030  1.00 20.38           C  
ATOM   1317  CD2 TYR   172      -4.788  20.208  17.515  1.00 25.26           C  
ATOM   1318  CE1 TYR   172      -3.497  22.490  16.604  1.00 18.75           C  
ATOM   1319  CE2 TYR   172      -5.525  21.289  17.071  1.00 25.40           C  
ATOM   1320  CZ  TYR   172      -4.884  22.419  16.629  1.00 23.67           C  
ATOM   1321  OH  TYR   172      -5.637  23.489  16.188  1.00 26.51           O  
ATOM   1322  N   LYS   173      -0.678  20.787  19.672  1.00 16.10           N  
ATOM   1323  CA  LYS   173      -0.171  22.147  19.859  0.50 15.36           C  
ATOM   1325  C   LYS   173       0.734  22.529  18.698  1.00 16.51           C  
ATOM   1326  O   LYS   173       1.356  21.658  18.076  1.00 15.47           O  
ATOM   1327  CB  LYS   173       0.607  22.279  21.172  0.50 17.13           C  
ATOM   1329  CG  LYS   173      -0.230  22.012  22.410  0.50 21.46           C  
ATOM   1331  CD  LYS   173       0.334  22.672  23.637  0.50 30.27           C  
ATOM   1333  CE  LYS   173      -0.307  22.140  24.905  0.50 31.83           C  
ATOM   1335  NZ  LYS   173      -1.758  22.461  24.978  0.50 23.82           N  
ATOM   1337  N   ILE   174       0.794  23.824  18.398  1.00 13.68           N  
ATOM   1338  CA  ILE   174       1.722  24.383  17.440  1.00 14.31           C  
ATOM   1339  C   ILE   174       2.597  25.396  18.178  1.00 15.81           C  
ATOM   1340  O   ILE   174       2.093  26.174  19.012  1.00 17.33           O  
ATOM   1341  CB  ILE   174       1.006  25.076  16.237  1.00 18.32           C  
ATOM   1342  CG1 ILE   174       0.082  24.091  15.519  1.00 22.53           C  
ATOM   1343  CG2 ILE   174       2.014  25.674  15.248  1.00 22.62           C  
ATOM   1344  CD1 ILE   174      -1.106  24.804  14.872  1.00 36.94           C  
ATOM   1345  N   SER   175       3.893  25.376  17.889  1.00 16.05           N  
ATOM   1346  CA  SER   175       4.820  26.356  18.433  1.00 16.42           C  
ATOM   1347  C   SER   175       5.801  26.935  17.420  1.00 24.16           C  
ATOM   1348  O   SER   175       6.188  26.265  16.461  1.00 19.16           O  
ATOM   1349  CB  SER   175       5.643  25.705  19.546  1.00 19.60           C  
ATOM   1350  OG  SER   175       6.513  26.650  20.151  1.00 23.47           O  
ATOM   1351  N   LYS   176       6.232  28.170  17.687  1.00 30.96           N  
ATOM   1352  CA  LYS   176       7.315  28.823  16.943  0.50 37.46           C  
ATOM   1354  C   LYS   176       8.448  29.228  17.907  1.00 40.47           C  
ATOM   1355  O   LYS   176       8.335  30.246  18.600  1.00 45.07           O  
ATOM   1356  CB  LYS   176       6.798  30.064  16.190  0.50 38.18           C  
ATOM   1358  CG  LYS   176       5.703  29.805  15.147  0.50 39.96           C  
ATOM   1360  CD  LYS   176       4.298  30.018  15.707  0.50 42.89           C  
ATOM   1362  CE  LYS   176       3.237  29.878  14.626  0.50 42.91           C  
ATOM   1364  NZ  LYS   176       1.858  30.045  15.160  0.50 44.53           N  
ATOM   1366  N   PRO   177       9.544  28.429  17.976  1.00 44.39           N  
ATOM   1367  CA  PRO   177      10.685  28.789  18.851  1.00 46.09           C  
ATOM   1368  C   PRO   177      11.475  30.021  18.408  1.00 45.73           C  
ATOM   1369  O   PRO   177      11.329  30.472  17.274  1.00 44.57           O  
ATOM   1370  CB  PRO   177      11.591  27.550  18.789  1.00 46.13           C  
ATOM   1371  CG  PRO   177      10.723  26.457  18.270  1.00 45.78           C  
ATOM   1372  CD  PRO   177       9.781  27.134  17.319  1.00 47.03           C  
ATOM   1373  N   SER   184      11.206  32.146   8.615  1.00 47.14           N  
ATOM   1374  CA  SER   184      10.221  32.550   9.614  1.00 43.59           C  
ATOM   1375  C   SER   184       8.890  31.810   9.444  1.00 36.29           C  
ATOM   1376  O   SER   184       7.917  32.105  10.148  1.00 37.97           O  
ATOM   1377  CB  SER   184      10.008  34.074   9.592  1.00 48.80           C  
ATOM   1378  OG  SER   184       9.332  34.502   8.416  1.00 50.96           O  
ATOM   1379  N   SER   185       8.850  30.856   8.508  1.00 30.41           N  
ATOM   1380  CA  SER   185       7.675  29.994   8.338  1.00 26.29           C  
ATOM   1381  C   SER   185       7.817  28.621   9.031  1.00 21.47           C  
ATOM   1382  O   SER   185       6.892  27.818   8.996  1.00 18.11           O  
ATOM   1383  CB  SER   185       7.316  29.817   6.853  1.00 28.47           C  
ATOM   1384  OG  SER   185       8.319  29.111   6.138  1.00 27.82           O  
ATOM   1385  N   GLU   186       8.963  28.371   9.663  1.00 18.19           N  
ATOM   1386  CA  GLU   186       9.182  27.112  10.398  1.00 18.84           C  
ATOM   1387  C   GLU   186       8.323  27.056  11.661  1.00 17.96           C  
ATOM   1388  O   GLU   186       8.293  28.003  12.456  1.00 19.32           O  
ATOM   1389  CB  GLU   186      10.659  27.004  10.755  1.00 23.73           C  
ATOM   1390  CG  GLU   186      11.044  25.796  11.583  1.00 28.26           C  
ATOM   1391  CD  GLU   186      12.518  25.820  11.930  1.00 36.25           C  
ATOM   1392  OE1 GLU   186      13.340  25.634  11.009  1.00 41.09           O  
ATOM   1393  OE2 GLU   186      12.845  26.037  13.116  1.00 27.26           O  
ATOM   1394  N   ILE   187       7.595  25.952  11.832  1.00 12.61           N  
ATOM   1395  CA  ILE   187       6.822  25.734  13.033  1.00 14.48           C  
ATOM   1396  C   ILE   187       7.046  24.310  13.512  1.00 11.25           C  
ATOM   1397  O   ILE   187       7.566  23.463  12.777  1.00 12.69           O  
ATOM   1398  CB  ILE   187       5.292  25.927  12.794  1.00 13.62           C  
ATOM   1399  CG1 ILE   187       4.748  24.936  11.756  1.00 16.83           C  
ATOM   1400  CG2 ILE   187       4.981  27.380  12.355  1.00 16.35           C  
ATOM   1401  CD1 ILE   187       3.219  24.939  11.638  1.00 16.25           C  
ATOM   1402  N   TYR   188       6.645  24.058  14.740  1.00 12.52           N  
ATOM   1403  CA  TYR   188       6.685  22.709  15.280  1.00 11.12           C  
ATOM   1404  C   TYR   188       5.284  22.293  15.669  1.00 13.07           C  
ATOM   1405  O   TYR   188       4.590  23.002  16.389  1.00 15.22           O  
ATOM   1406  CB  TYR   188       7.650  22.636  16.469  1.00 12.16           C  
ATOM   1407  CG  TYR   188       9.091  22.682  15.995  1.00 14.96           C  
ATOM   1408  CD1 TYR   188       9.742  21.518  15.624  1.00 14.22           C  
ATOM   1409  CD2 TYR   188       9.788  23.895  15.877  1.00 24.10           C  
ATOM   1410  CE1 TYR   188      11.058  21.533  15.162  1.00 20.23           C  
ATOM   1411  CE2 TYR   188      11.132  23.920  15.405  1.00 17.23           C  
ATOM   1412  CZ  TYR   188      11.740  22.728  15.060  1.00 20.20           C  
ATOM   1413  OH  TYR   188      13.040  22.688  14.585  1.00 22.77           O  
ATOM   1414  N   ILE   189       4.848  21.170  15.112  1.00 10.86           N  
ATOM   1415  CA  ILE   189       3.551  20.614  15.382  1.00 11.58           C  
ATOM   1416  C   ILE   189       3.700  19.439  16.344  1.00 12.48           C  
ATOM   1417  O   ILE   189       4.542  18.576  16.131  1.00 10.76           O  
ATOM   1418  CB  ILE   189       2.904  20.096  14.062  1.00 12.23           C  
ATOM   1419  CG1 ILE   189       2.816  21.238  13.017  1.00 13.52           C  
ATOM   1420  CG2 ILE   189       1.567  19.495  14.350  1.00 13.92           C  
ATOM   1421  CD1 ILE   189       2.330  20.833  11.608  1.00 13.20           C  
ATOM   1422  N   MET   190       2.902  19.413  17.410  1.00 10.89           N  
ATOM   1423  CA  MET   190       2.932  18.331  18.373  1.00 10.73           C  
ATOM   1424  C   MET   190       1.579  17.719  18.511  1.00 11.66           C  
ATOM   1425  O   MET   190       0.586  18.426  18.642  1.00 14.15           O  
ATOM   1426  CB  MET   190       3.391  18.873  19.717  1.00 14.40           C  
ATOM   1427  CG  MET   190       4.825  19.361  19.671  1.00 11.28           C  
ATOM   1428  SD  MET   190       5.290  20.609  21.075  0.70 15.68          SE  
ATOM   1429  CE  MET   190       4.616  22.239  20.199  1.00 15.83           C  
ATOM   1430  N   PHE   191       1.553  16.402  18.473  1.00 10.91           N  
ATOM   1431  CA  PHE   191       0.346  15.645  18.712  1.00 11.71           C  
ATOM   1432  C   PHE   191       0.498  14.847  19.997  1.00 13.28           C  
ATOM   1433  O   PHE   191       1.502  14.154  20.182  1.00 12.81           O  
ATOM   1434  CB  PHE   191       0.085  14.710  17.541  1.00 13.21           C  
ATOM   1435  CG  PHE   191      -0.197  15.410  16.236  1.00 12.64           C  
ATOM   1436  CD1 PHE   191      -1.429  16.065  15.992  1.00 14.49           C  
ATOM   1437  CD2 PHE   191       0.749  15.408  15.237  1.00 14.78           C  
ATOM   1438  CE1 PHE   191      -1.683  16.692  14.767  1.00 15.89           C  
ATOM   1439  CE2 PHE   191       0.502  16.023  14.015  1.00 13.87           C  
ATOM   1440  CZ  PHE   191      -0.714  16.678  13.776  1.00 14.54           C  
ATOM   1441  N   PHE   192      -0.491  14.916  20.882  1.00 12.86           N  
ATOM   1442  CA  PHE   192      -0.370  14.302  22.207  1.00 14.39           C  
ATOM   1443  C   PHE   192      -1.384  13.187  22.416  1.00 12.55           C  
ATOM   1444  O   PHE   192      -2.570  13.360  22.102  1.00 16.09           O  
ATOM   1445  CB  PHE   192      -0.564  15.354  23.309  1.00 12.50           C  
ATOM   1446  CG  PHE   192       0.479  16.433  23.302  1.00 11.60           C  
ATOM   1447  CD1 PHE   192       1.676  16.297  24.024  1.00 11.91           C  
ATOM   1448  CD2 PHE   192       0.284  17.586  22.557  1.00 13.16           C  
ATOM   1449  CE1 PHE   192       2.655  17.302  23.997  1.00 13.78           C  
ATOM   1450  CE2 PHE   192       1.245  18.597  22.520  1.00 12.61           C  
ATOM   1451  CZ  PHE   192       2.436  18.460  23.242  1.00 15.38           C  
ATOM   1452  N   GLY   193      -0.922  12.057  22.946  1.00 13.98           N  
ATOM   1453  CA  GLY   193      -1.843  11.007  23.383  1.00 15.36           C  
ATOM   1454  C   GLY   193      -2.468  10.213  22.256  1.00 13.95           C  
ATOM   1455  O   GLY   193      -3.678  10.295  21.999  1.00 16.05           O  
ATOM   1456  N   PHE   194      -1.636   9.445  21.562  1.00 13.46           N  
ATOM   1457  CA  PHE   194      -2.059   8.635  20.433  1.00 11.69           C  
ATOM   1458  C   PHE   194      -3.164   7.669  20.824  1.00 13.52           C  
ATOM   1459  O   PHE   194      -3.112   7.089  21.889  1.00 16.71           O  
ATOM   1460  CB  PHE   194      -0.862   7.833  19.914  1.00 13.82           C  
ATOM   1461  CG  PHE   194      -1.163   6.995  18.710  1.00 16.03           C  
ATOM   1462  CD1 PHE   194      -1.590   7.578  17.524  1.00 14.81           C  
ATOM   1463  CD2 PHE   194      -1.003   5.620  18.770  1.00 16.98           C  
ATOM   1464  CE1 PHE   194      -1.858   6.788  16.397  1.00 18.56           C  
ATOM   1465  CE2 PHE   194      -1.271   4.813  17.657  1.00 23.43           C  
ATOM   1466  CZ  PHE   194      -1.702   5.406  16.461  1.00 18.74           C  
ATOM   1467  N   LYS   195      -4.139   7.516  19.967  1.00 18.76           N  
ATOM   1468  CA  LYS   195      -5.181   6.511  20.100  1.00 24.68           C  
ATOM   1469  C   LYS   195      -5.265   5.710  18.826  1.00 26.91           C  
ATOM   1470  O   LYS   195      -5.695   6.190  17.864  1.00 28.15           O  
ATOM   1471  CB  LYS   195      -6.557   7.140  20.275  1.00 28.13           C  
ATOM   1472  CG  LYS   195      -6.727   8.370  21.094  1.00 36.83           C  
ATOM   1473  CD  LYS   195      -8.202   8.847  21.108  1.00 38.91           C  
ATOM   1474  CE  LYS   195      -8.420  10.211  20.514  1.00 50.63           C  
ATOM   1475  NZ  LYS   195      -9.752  10.881  20.750  1.00 53.49           N  
ATOM   1476  N   ALA   196      -4.888   4.461  18.873  1.00 33.64           N  
ATOM   1477  CA  ALA   196      -5.097   3.537  17.757  1.00 41.41           C  
ATOM   1478  C   ALA   196      -6.586   3.396  17.404  1.00 43.93           C  
ATOM   1479  O   ALA   196      -6.926   3.095  16.260  1.00 48.00           O  
ATOM   1480  CB  ALA   196      -4.494   2.188  18.068  1.00 40.11           C  
END
