
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  219 ( 1705),  selected  219 , name 2avd_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 2avd_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q    44_A      N       3           -
LGA    C    45_A      A       4           -
LGA    L    46_A      -       -           -
LGA    L    47_A      -       -           -
LGA    P    48_A      F       5          4.462
LGA    P    49_A      -       -           -
LGA    E    50_A      -       -           -
LGA    D    51_A      -       -           -
LGA    S    52_A      E       6          4.098
LGA    R    53_A      Y       7          3.604
LGA    L    54_A      L       8          3.306
LGA    W    55_A      R       9          1.845
LGA    Q    56_A      T      10          1.246
LGA    Y    57_A      Y      11          0.895
LGA    L    58_A      V      12          2.439
LGA    L    59_A      E      13          2.689
LGA    S    60_A      S      14          3.889
LGA    R    61_A      T      15          4.444
LGA    S    62_A      -       -           -
LGA    M    63_A      T      16          3.333
LGA    R    64_A      E      17          5.072
LGA    E    65_A      T      18           #
LGA    H    66_A      D      19          4.079
LGA    P    67_A      A      20          2.659
LGA    A    68_A      A      21          1.053
LGA    L    69_A      V      22          1.832
LGA    R    70_A      A      23          2.284
LGA    S    71_A      R      24          1.719
LGA    L    72_A      A      25          0.986
LGA    R    73_A      R      26          1.021
LGA    L    74_A      E      27          2.322
LGA    L    75_A      D      28          2.718
LGA    T    76_A      A      29          2.117
LGA    L    77_A      A      30          2.199
LGA    E    78_A      E      31          3.005
LGA    Q    79_A      F      32          3.171
LGA    P    80_A      -       -           -
LGA    Q    81_A      G      33          1.878
LGA    G    82_A      L      34          3.912
LGA    D    83_A      -       -           -
LGA    S    84_A      P      35          1.509
LGA    M    85_A      A      36          0.950
LGA    M    86_A      P      37          1.255
LGA    T    87_A      D      38          1.210
LGA    C    88_A      E      39          1.879
LGA    E    89_A      M      40          1.485
LGA    Q    90_A      T      41          0.734
LGA    A    91_A      G      42          1.671
LGA    Q    92_A      Q      43          1.667
LGA    L    93_A      L      44          0.536
LGA    L    94_A      L      45          1.254
LGA    A    95_A      T      46          1.597
LGA    N    96_A      T      47          1.415
LGA    L    97_A      L      48          1.399
LGA    A    98_A      A      49          1.146
LGA    R    99_A      A      50          0.797
LGA    L   100_A      T      51          1.623
LGA    I   101_A      T      52          2.310
LGA    Q   102_A      N      53          3.875
LGA    A   103_A      G      54          3.234
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    K   104_A      S      57          4.760
LGA    K   105_A      T      58          3.376
LGA    -       -      G      59           -
LGA    A   106_A      A      60          0.664
LGA    L   107_A      I      61          1.249
LGA    D   108_A      A      62          1.162
LGA    L   109_A      I      63          1.259
LGA    G   110_A      T      64          1.501
LGA    T   111_A      P      65          3.582
LGA    F   112_A      A      66          2.484
LGA    T   113_A      A      67          5.014
LGA    G   114_A      G      68          2.063
LGA    Y   115_A      L      69          1.322
LGA    S   116_A      V      70          1.047
LGA    A   117_A      G      71          2.120
LGA    L   118_A      L      72          2.509
LGA    A   119_A      Y      73          1.848
LGA    L   120_A      I      74          1.430
LGA    A   121_A      L      75          2.376
LGA    L   122_A      N      76          2.817
LGA    A   123_A      G      77          2.014
LGA    L   124_A      L      78          2.060
LGA    P   125_A      A      79          3.034
LGA    A   126_A      D      80          3.020
LGA    D   127_A      N      81          2.989
LGA    G   128_A      T      82          1.569
LGA    R   129_A      T      83          0.978
LGA    V   130_A      L      84          1.393
LGA    V   131_A      T      85          1.454
LGA    T   132_A      C      86          1.249
LGA    C   133_A      I      87          1.093
LGA    E   134_A      D      88          0.823
LGA    V   135_A      P      89          1.990
LGA    D   136_A      E      90          2.097
LGA    A   137_A      S      91          1.965
LGA    Q   138_A      E      92          2.084
LGA    P   139_A      H      93          2.941
LGA    P   140_A      Q      94          3.360
LGA    E   141_A      R      95          2.138
LGA    L   142_A      Q      96          2.555
LGA    G   143_A      A      97          3.352
LGA    R   144_A      K      98          2.550
LGA    P   145_A      A      99          1.929
LGA    L   146_A      L     100          1.584
LGA    W   147_A      F     101          0.633
LGA    R   148_A      R     102          0.378
LGA    Q   149_A      E     103          1.809
LGA    A   150_A      A     104          2.044
LGA    -       -      G     105           -
LGA    E   151_A      Y     106          0.953
LGA    A   152_A      S     107          4.500
LGA    E   153_A      P     108          3.181
LGA    H   154_A      S     109          2.397
LGA    K   155_A      R     110          1.728
LGA    I   156_A      V     111          1.856
LGA    D   157_A      R     112          1.142
LGA    L   158_A      F     113          1.060
LGA    R   159_A      L     114          1.026
LGA    L   160_A      L     115          1.187
LGA    K   161_A      S     116          1.278
LGA    P   162_A      R     117          0.924
LGA    A   163_A      P     118          0.422
LGA    L   164_A      L     119          0.789
LGA    E   165_A      D     120          1.224
LGA    T   166_A      V     121          1.223
LGA    L   167_A      M     122          0.750
LGA    D   168_A      S     123          0.480
LGA    E   169_A      R     124          0.730
LGA    L   170_A      L     125          0.802
LGA    L   171_A      -       -           -
LGA    A   172_A      -       -           -
LGA    A   173_A      -       -           -
LGA    G   174_A      -       -           -
LGA    E   175_A      A     126          1.653
LGA    A   176_A      N     127          1.141
LGA    G   177_A      D     128          1.157
LGA    T   178_A      S     129          1.320
LGA    F   179_A      Y     130          0.520
LGA    D   180_A      Q     131          0.333
LGA    V   181_A      L     132          0.406
LGA    A   182_A      V     133          0.860
LGA    V   183_A      F     134          0.944
LGA    V   184_A      G     135          1.712
LGA    D   185_A      Q     136          1.144
LGA    A   186_A      V     137          2.003
LGA    D   187_A      S     138          2.666
LGA    K   188_A      P     139          2.466
LGA    E   189_A      M     140          2.132
LGA    N   190_A      D     141          2.002
LGA    C   191_A      L     142          1.390
LGA    S   192_A      K     143          0.683
LGA    A   193_A      A     144          1.383
LGA    Y   194_A      L     145          0.924
LGA    Y   195_A      V     146          0.569
LGA    E   196_A      D     147          1.596
LGA    R   197_A      A     148          1.865
LGA    C   198_A      A     149          1.091
LGA    L   199_A      W     150          1.261
LGA    Q   200_A      P     151          0.915
LGA    L   201_A      L     152          0.550
LGA    L   202_A      L     153          0.711
LGA    R   203_A      R     154          0.810
LGA    P   204_A      R     155          0.888
LGA    G   205_A      G     156          0.746
LGA    G   206_A      G     157          0.616
LGA    I   207_A      A     158          0.959
LGA    L   208_A      L     159          1.136
LGA    A   209_A      V     160          0.933
LGA    V   210_A      L     161          1.131
LGA    L   211_A      A     162          1.043
LGA    R   212_A      D     163          0.642
LGA    V   213_A      A     164          1.613
LGA    L   214_A      L     165          1.662
LGA    W   215_A      L     166          1.427
LGA    R   216_A      D     167          3.543
LGA    G   217_A      G     168          3.581
LGA    K   218_A      T     169          2.947
LGA    V   219_A      I     170          1.499
LGA    L   220_A      A     171          2.592
LGA    Q   221_A      D     172          2.893
LGA    -       -      Q     173           -
LGA    P   222_A      T     174           #
LGA    P   223_A      R     175          3.942
LGA    K   224_A      K     176          3.813
LGA    G   225_A      D     177          4.607
LGA    D   226_A      -       -           -
LGA    V   227_A      R     178          2.183
LGA    A   228_A      D     179          2.265
LGA    A   229_A      T     180          1.911
LGA    E   230_A      Q     181          1.556
LGA    C   231_A      A     182          1.480
LGA    V   232_A      A     183          0.970
LGA    R   233_A      R     184          0.807
LGA    N   234_A      D     185          0.545
LGA    L   235_A      A     186          0.872
LGA    N   236_A      D     187          0.484
LGA    E   237_A      E     188          0.578
LGA    R   238_A      Y     189          1.407
LGA    I   239_A      I     190          1.680
LGA    R   240_A      R     191          1.851
LGA    R   241_A      S     192          2.448
LGA    D   242_A      I     193          2.230
LGA    V   243_A      E     194          2.047
LGA    R   244_A      G     195          1.974
LGA    V   245_A      A     196          0.534
LGA    Y   246_A      H     197          1.237
LGA    I   247_A      V     198          1.663
LGA    S   248_A      A     199          1.187
LGA    L   249_A      R     200          0.724
LGA    L   250_A      L     201          0.597
LGA    P   251_A      P     202          0.333
LGA    L   252_A      L     203          0.643
LGA    G   253_A      G     204          0.602
LGA    D   254_A      A     205          0.516
LGA    G   255_A      G     206          0.554
LGA    L   256_A      L     207          0.763
LGA    T   257_A      T     208          1.242
LGA    L   258_A      V     209          1.617
LGA    A   259_A      V     210          1.178
LGA    F   260_A      T     211          1.628
LGA    K   261_A      K     212          0.468
LGA    I   262_A      A     213          1.424

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  219  211    5.0    202    2.06    21.29     81.321     9.348

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.407624 * X  +   0.888464 * Y  +   0.210891 * Z  +   0.262838
  Y_new =  -0.912542 * X  +  -0.387912 * Y  +  -0.129582 * Z  +  38.245716
  Z_new =  -0.033322 * X  +  -0.245268 * Y  +   0.968883 * Z  + 137.575516 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.247937    2.893656  [ DEG:   -14.2057    165.7943 ]
  Theta =   0.033328    3.108265  [ DEG:     1.9096    178.0904 ]
  Phi   =  -1.990894    1.150698  [ DEG:  -114.0698     65.9302 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2avd_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2avd_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  219  211   5.0  202   2.06   21.29  81.321
REMARK  ---------------------------------------------------------- 
MOLECULE 2avd_A
HEADER    TRANSFERASE                             29-AUG-05   2AVD              
TITLE     CRYSTAL STRUCTURE OF HUMAN CATECHOL-O-METHYLTRANSFERASE               
TITLE    2 DOMAIN CONTAINING 1                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CATECHOL-O-METHYLTRANSFERASE;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_CELL_LINE: BD FUSION-BLUE;                         
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A-LIC                                
KEYWDS    METHYLTRANSFERASE, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS           
KEYWDS   2 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.MIN,H.WU,H.ZENG,P.LOPPNAU,M.SUNDSTROM,C.H.ARROWSMITH,             
AUTHOR   2 A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV,STRUCTURAL GENOMICS            
AUTHOR   3 CONSORTIUM (SGC)                                                     
REVDAT   4   10-JUL-07 2AVD    1       DBREF  REMARK SEQRES SEQADV              
REVDAT   3   21-MAR-06 2AVD    1       JRNL                                     
REVDAT   2   20-SEP-05 2AVD    1       AUTHOR JRNL                              
REVDAT   1   13-SEP-05 2AVD    0                                                
JRNL        AUTH   J.R.MIN,H.WU,H.ZENG,P.LOPPNAU,M.SUNDSTROM,                   
JRNL        AUTH 2 C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,                      
JRNL        AUTH 3 A.N.PLOTNIKOV                                                
JRNL        TITL   THE CRYSTAL STRUCTURE OF HUMAN                               
JRNL        TITL 2 CATECHOL-O-METHYLTRANSFERASE DOMAIN CONTAINING 1             
JRNL        TITL 3 IN COMPLEX WITH S-ADENOSYL-L-METHIONINE                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2AVD A   36   262  UNP    Q86VU5   Q86VU5_HUMAN    36    262             
DBREF  2AVD B   36   262  UNP    Q86VU5   Q86VU5_HUMAN    36    262             
SEQRES   1 A  229  GLY SER PRO PRO TRP ARG GLY ARG ARG GLU GLN CYS LEU          
SEQRES   2 A  229  LEU PRO PRO GLU ASP SER ARG LEU TRP GLN TYR LEU LEU          
SEQRES   3 A  229  SER ARG SER MET ARG GLU HIS PRO ALA LEU ARG SER LEU          
SEQRES   4 A  229  ARG LEU LEU THR LEU GLU GLN PRO GLN GLY ASP SER MET          
SEQRES   5 A  229  MET THR CYS GLU GLN ALA GLN LEU LEU ALA ASN LEU ALA          
SEQRES   6 A  229  ARG LEU ILE GLN ALA LYS LYS ALA LEU ASP LEU GLY THR          
SEQRES   7 A  229  PHE THR GLY TYR SER ALA LEU ALA LEU ALA LEU ALA LEU          
SEQRES   8 A  229  PRO ALA ASP GLY ARG VAL VAL THR CYS GLU VAL ASP ALA          
SEQRES   9 A  229  GLN PRO PRO GLU LEU GLY ARG PRO LEU TRP ARG GLN ALA          
SEQRES  10 A  229  GLU ALA GLU HIS LYS ILE ASP LEU ARG LEU LYS PRO ALA          
SEQRES  11 A  229  LEU GLU THR LEU ASP GLU LEU LEU ALA ALA GLY GLU ALA          
SEQRES  12 A  229  GLY THR PHE ASP VAL ALA VAL VAL ASP ALA ASP LYS GLU          
SEQRES  13 A  229  ASN CYS SER ALA TYR TYR GLU ARG CYS LEU GLN LEU LEU          
SEQRES  14 A  229  ARG PRO GLY GLY ILE LEU ALA VAL LEU ARG VAL LEU TRP          
SEQRES  15 A  229  ARG GLY LYS VAL LEU GLN PRO PRO LYS GLY ASP VAL ALA          
SEQRES  16 A  229  ALA GLU CYS VAL ARG ASN LEU ASN GLU ARG ILE ARG ARG          
SEQRES  17 A  229  ASP VAL ARG VAL TYR ILE SER LEU LEU PRO LEU GLY ASP          
SEQRES  18 A  229  GLY LEU THR LEU ALA PHE LYS ILE                              
SEQRES   1 B  229  GLY SER PRO PRO TRP ARG GLY ARG ARG GLU GLN CYS LEU          
SEQRES   2 B  229  LEU PRO PRO GLU ASP SER ARG LEU TRP GLN TYR LEU LEU          
SEQRES   3 B  229  SER ARG SER MET ARG GLU HIS PRO ALA LEU ARG SER LEU          
SEQRES   4 B  229  ARG LEU LEU THR LEU GLU GLN PRO GLN GLY ASP SER MET          
SEQRES   5 B  229  MET THR CYS GLU GLN ALA GLN LEU LEU ALA ASN LEU ALA          
SEQRES   6 B  229  ARG LEU ILE GLN ALA LYS LYS ALA LEU ASP LEU GLY THR          
SEQRES   7 B  229  PHE THR GLY TYR SER ALA LEU ALA LEU ALA LEU ALA LEU          
SEQRES   8 B  229  PRO ALA ASP GLY ARG VAL VAL THR CYS GLU VAL ASP ALA          
SEQRES   9 B  229  GLN PRO PRO GLU LEU GLY ARG PRO LEU TRP ARG GLN ALA          
SEQRES  10 B  229  GLU ALA GLU HIS LYS ILE ASP LEU ARG LEU LYS PRO ALA          
SEQRES  11 B  229  LEU GLU THR LEU ASP GLU LEU LEU ALA ALA GLY GLU ALA          
SEQRES  12 B  229  GLY THR PHE ASP VAL ALA VAL VAL ASP ALA ASP LYS GLU          
SEQRES  13 B  229  ASN CYS SER ALA TYR TYR GLU ARG CYS LEU GLN LEU LEU          
SEQRES  14 B  229  ARG PRO GLY GLY ILE LEU ALA VAL LEU ARG VAL LEU TRP          
SEQRES  15 B  229  ARG GLY LYS VAL LEU GLN PRO PRO LYS GLY ASP VAL ALA          
SEQRES  16 B  229  ALA GLU CYS VAL ARG ASN LEU ASN GLU ARG ILE ARG ARG          
SEQRES  17 B  229  ASP VAL ARG VAL TYR ILE SER LEU LEU PRO LEU GLY ASP          
SEQRES  18 B  229  GLY LEU THR LEU ALA PHE LYS ILE                              
HET    SAM    501      27                                                       
HET    SAM    601      27                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  HOH   *471(H2 O)                                                    
CRYST1   51.882   65.222   61.799  90.00 102.66  90.00 P 1 21 1      4          
ATOM      1  N   GLN A  44      18.179  45.835 168.972  1.00 20.70           N  
ATOM      2  CA  GLN A  44      17.748  44.783 168.014  1.00 21.23           C  
ATOM      3  C   GLN A  44      17.150  43.522 168.650  1.00 21.03           C  
ATOM      4  O   GLN A  44      16.261  42.912 168.058  1.00 21.07           O  
ATOM      5  CB  GLN A  44      18.912  44.343 167.135  1.00 21.36           C  
ATOM      6  CG  GLN A  44      19.397  45.405 166.186  1.00 21.62           C  
ATOM      7  CD  GLN A  44      20.728  45.017 165.569  1.00 24.21           C  
ATOM      8  OE1 GLN A  44      21.714  44.779 166.278  1.00 25.25           O  
ATOM      9  NE2 GLN A  44      20.763  44.945 164.251  1.00 23.83           N  
ATOM     10  N   CYS A  45      17.686  43.128 169.806  1.00 22.07           N  
ATOM     11  CA  CYS A  45      17.353  41.863 170.491  1.00 24.13           C  
ATOM     12  C   CYS A  45      17.170  42.098 171.962  1.00 23.28           C  
ATOM     13  O   CYS A  45      17.972  42.795 172.594  1.00 24.06           O  
ATOM     14  CB  CYS A  45      18.510  40.858 170.407  1.00 24.44           C  
ATOM     15  SG  CYS A  45      18.989  40.462 168.802  1.00 33.05           S  
ATOM     16  N   LEU A  46      16.156  41.464 172.529  1.00 21.89           N  
ATOM     17  CA  LEU A  46      15.978  41.495 173.961  1.00 21.51           C  
ATOM     18  C   LEU A  46      16.824  40.439 174.663  1.00 21.17           C  
ATOM     19  O   LEU A  46      17.054  40.538 175.866  1.00 21.89           O  
ATOM     20  CB  LEU A  46      14.495  41.292 174.304  1.00 20.89           C  
ATOM     21  CG  LEU A  46      13.607  42.482 173.905  1.00 21.46           C  
ATOM     22  CD1 LEU A  46      12.142  42.208 174.213  1.00 20.23           C  
ATOM     23  CD2 LEU A  46      14.079  43.804 174.575  1.00 19.29           C  
ATOM     24  N   LEU A  47      17.259  39.425 173.916  1.00 19.99           N  
ATOM     25  CA  LEU A  47      17.934  38.273 174.511  1.00 19.88           C  
ATOM     26  C   LEU A  47      19.415  38.169 174.115  1.00 19.71           C  
ATOM     27  O   LEU A  47      19.815  38.684 173.065  1.00 19.43           O  
ATOM     28  CB  LEU A  47      17.200  36.974 174.143  1.00 19.65           C  
ATOM     29  CG  LEU A  47      15.813  36.785 174.771  1.00 19.57           C  
ATOM     30  CD1 LEU A  47      15.164  35.527 174.193  1.00 20.01           C  
ATOM     31  CD2 LEU A  47      15.883  36.722 176.307  1.00 20.02           C  
ATOM     32  N   PRO A  48      20.228  37.509 174.962  1.00 19.99           N  
ATOM     33  CA  PRO A  48      21.626  37.270 174.583  1.00 19.79           C  
ATOM     34  C   PRO A  48      21.677  36.184 173.498  1.00 19.53           C  
ATOM     35  O   PRO A  48      20.624  35.618 173.151  1.00 19.47           O  
ATOM     36  CB  PRO A  48      22.251  36.755 175.879  1.00 20.03           C  
ATOM     37  CG  PRO A  48      21.109  36.106 176.598  1.00 20.85           C  
ATOM     38  CD  PRO A  48      19.914  36.948 176.292  1.00 20.67           C  
ATOM     39  N   PRO A  49      22.876  35.905 172.943  1.00 19.77           N  
ATOM     40  CA  PRO A  49      23.020  34.814 171.974  1.00 18.97           C  
ATOM     41  C   PRO A  49      22.550  33.458 172.527  1.00 18.54           C  
ATOM     42  O   PRO A  49      22.627  33.214 173.743  1.00 18.36           O  
ATOM     43  CB  PRO A  49      24.530  34.766 171.719  1.00 19.50           C  
ATOM     44  CG  PRO A  49      25.017  36.139 172.026  1.00 19.77           C  
ATOM     45  CD  PRO A  49      24.150  36.617 173.165  1.00 19.99           C  
ATOM     46  N   GLU A  50      22.100  32.583 171.628  1.00 17.74           N  
ATOM     47  CA  GLU A  50      21.605  31.266 172.005  1.00 17.96           C  
ATOM     48  C   GLU A  50      22.633  30.431 172.757  1.00 18.24           C  
ATOM     49  O   GLU A  50      22.266  29.582 173.560  1.00 18.38           O  
ATOM     50  CB  GLU A  50      21.175  30.473 170.774  1.00 18.17           C  
ATOM     51  CG  GLU A  50      19.883  30.936 170.142  1.00 19.07           C  
ATOM     52  CD  GLU A  50      19.566  30.159 168.877  1.00 20.50           C  
ATOM     53  OE1 GLU A  50      19.955  28.965 168.794  1.00 18.86           O  
ATOM     54  OE2 GLU A  50      18.952  30.755 167.962  1.00 23.22           O  
ATOM     55  N   ASP A  51      23.916  30.635 172.461  1.00 18.50           N  
ATOM     56  CA  ASP A  51      24.969  29.808 173.072  1.00 19.47           C  
ATOM     57  C   ASP A  51      25.496  30.366 174.409  1.00 19.63           C  
ATOM     58  O   ASP A  51      26.426  29.802 175.006  1.00 20.50           O  
ATOM     59  CB  ASP A  51      26.108  29.542 172.068  1.00 19.82           C  
ATOM     60  CG  ASP A  51      26.884  30.798 171.702  1.00 21.85           C  
ATOM     61  OD1 ASP A  51      26.269  31.769 171.235  1.00 25.73           O  
ATOM     62  OD2 ASP A  51      28.122  30.799 171.843  1.00 23.31           O  
ATOM     63  N   SER A  52      24.888  31.445 174.905  1.00 19.99           N  
ATOM     64  CA  SER A  52      25.315  32.009 176.179  1.00 20.47           C  
ATOM     65  C   SER A  52      24.926  31.080 177.356  1.00 20.16           C  
ATOM     66  O   SER A  52      23.930  30.340 177.276  1.00 19.50           O  
ATOM     67  CB  SER A  52      24.809  33.442 176.346  1.00 20.83           C  
ATOM     68  OG  SER A  52      23.399  33.491 176.496  1.00 24.01           O  
ATOM     69  N   ARG A  53      25.744  31.091 178.410  1.00 19.72           N  
ATOM     70  CA  ARG A  53      25.618  30.156 179.536  1.00 20.17           C  
ATOM     71  C   ARG A  53      24.220  30.086 180.199  1.00 18.69           C  
ATOM     72  O   ARG A  53      23.656  28.990 180.376  1.00 18.14           O  
ATOM     73  CB  ARG A  53      26.687  30.469 180.604  1.00 21.31           C  
ATOM     74  CG  ARG A  53      28.031  29.780 180.344  1.00 26.19           C  
ATOM     75  CD  ARG A  53      28.841  29.659 181.651  1.00 32.56           C  
ATOM     76  NE  ARG A  53      28.292  28.667 182.590  1.00 36.13           N  
ATOM     77  CZ  ARG A  53      28.507  28.664 183.908  1.00 38.70           C  
ATOM     78  NH1 ARG A  53      29.249  29.613 184.485  1.00 38.02           N  
ATOM     79  NH2 ARG A  53      27.970  27.708 184.662  1.00 40.04           N  
ATOM     80  N   LEU A  54      23.690  31.251 180.566  1.00 17.90           N  
ATOM     81  CA  LEU A  54      22.384  31.320 181.231  1.00 17.48           C  
ATOM     82  C   LEU A  54      21.242  30.881 180.291  1.00 16.90           C  
ATOM     83  O   LEU A  54      20.288  30.197 180.725  1.00 15.51           O  
ATOM     84  CB  LEU A  54      22.138  32.713 181.828  1.00 18.12           C  
ATOM     85  CG  LEU A  54      20.989  32.802 182.849  1.00 18.09           C  
ATOM     86  CD1 LEU A  54      21.128  31.770 183.977  1.00 19.20           C  
ATOM     87  CD2 LEU A  54      20.854  34.236 183.410  1.00 18.19           C  
ATOM     88  N   TRP A  55      21.337  31.258 179.012  1.00 15.77           N  
ATOM     89  CA  TRP A  55      20.351  30.764 178.041  1.00 15.52           C  
ATOM     90  C   TRP A  55      20.432  29.238 177.878  1.00 15.56           C  
ATOM     91  O   TRP A  55      19.401  28.551 177.844  1.00 14.97           O  
ATOM     92  CB  TRP A  55      20.488  31.440 176.676  1.00 15.47           C  
ATOM     93  CG  TRP A  55      19.323  31.091 175.809  1.00 15.81           C  
ATOM     94  CD1 TRP A  55      19.297  30.202 174.774  1.00 17.51           C  
ATOM     95  CD2 TRP A  55      17.983  31.569 175.964  1.00 16.83           C  
ATOM     96  NE1 TRP A  55      18.020  30.131 174.237  1.00 15.44           N  
ATOM     97  CE2 TRP A  55      17.198  30.958 174.955  1.00 16.84           C  
ATOM     98  CE3 TRP A  55      17.372  32.483 176.843  1.00 17.07           C  
ATOM     99  CZ2 TRP A  55      15.823  31.215 174.808  1.00 16.28           C  
ATOM    100  CZ3 TRP A  55      16.004  32.755 176.682  1.00 17.09           C  
ATOM    101  CH2 TRP A  55      15.251  32.117 175.673  1.00 16.13           C  
ATOM    102  N   GLN A  56      21.652  28.699 177.784  1.00 14.88           N  
ATOM    103  CA  GLN A  56      21.822  27.245 177.677  1.00 15.53           C  
ATOM    104  C   GLN A  56      21.216  26.527 178.888  1.00 14.86           C  
ATOM    105  O   GLN A  56      20.657  25.434 178.750  1.00 14.73           O  
ATOM    106  CB  GLN A  56      23.291  26.871 177.480  1.00 16.01           C  
ATOM    107  CG  GLN A  56      23.766  27.122 176.043  1.00 17.10           C  
ATOM    108  CD  GLN A  56      23.104  26.203 175.044  1.00 18.69           C  
ATOM    109  OE1 GLN A  56      23.100  24.978 175.219  1.00 21.75           O  
ATOM    110  NE2 GLN A  56      22.526  26.778 173.995  1.00 20.19           N  
ATOM    111  N   TYR A  57      21.300  27.176 180.047  1.00 14.95           N  
ATOM    112  CA  TYR A  57      20.693  26.641 181.271  1.00 14.98           C  
ATOM    113  C   TYR A  57      19.169  26.599 181.103  1.00 14.37           C  
ATOM    114  O   TYR A  57      18.532  25.552 181.306  1.00 14.80           O  
ATOM    115  CB  TYR A  57      21.093  27.460 182.495  1.00 14.69           C  
ATOM    116  CG  TYR A  57      20.489  26.956 183.787  1.00 14.52           C  
ATOM    117  CD1 TYR A  57      21.177  26.035 184.592  1.00 14.89           C  
ATOM    118  CD2 TYR A  57      19.216  27.385 184.200  1.00 13.61           C  
ATOM    119  CE1 TYR A  57      20.617  25.564 185.791  1.00 15.39           C  
ATOM    120  CE2 TYR A  57      18.655  26.923 185.391  1.00 14.08           C  
ATOM    121  CZ  TYR A  57      19.353  26.020 186.173  1.00 15.01           C  
ATOM    122  OH  TYR A  57      18.789  25.582 187.340  1.00 14.55           O  
ATOM    123  N   LEU A  58      18.586  27.730 180.715  1.00 14.22           N  
ATOM    124  CA  LEU A  58      17.151  27.777 180.494  1.00 13.37           C  
ATOM    125  C   LEU A  58      16.694  26.660 179.547  1.00 12.40           C  
ATOM    126  O   LEU A  58      15.712  25.986 179.811  1.00 12.04           O  
ATOM    127  CB  LEU A  58      16.738  29.163 179.981  1.00 12.96           C  
ATOM    128  CG  LEU A  58      15.272  29.372 179.607  1.00 14.10           C  
ATOM    129  CD1 LEU A  58      14.922  30.829 179.808  1.00 12.45           C  
ATOM    130  CD2 LEU A  58      14.983  28.921 178.180  1.00 13.71           C  
ATOM    131  N   LEU A  59      17.422  26.445 178.450  1.00 12.06           N  
ATOM    132  CA  LEU A  59      17.048  25.383 177.497  1.00 11.90           C  
ATOM    133  C   LEU A  59      17.176  23.999 178.100  1.00 12.56           C  
ATOM    134  O   LEU A  59      16.233  23.206 178.026  1.00 10.88           O  
ATOM    135  CB  LEU A  59      17.895  25.438 176.217  1.00 12.53           C  
ATOM    136  CG  LEU A  59      17.738  26.677 175.328  1.00 12.01           C  
ATOM    137  CD1 LEU A  59      18.692  26.623 174.145  1.00 12.62           C  
ATOM    138  CD2 LEU A  59      16.249  26.818 174.856  1.00 14.75           C  
ATOM    139  N   SER A  60      18.347  23.707 178.674  1.00 12.96           N  
ATOM    140  CA  SER A  60      18.607  22.369 179.222  1.00 13.95           C  
ATOM    141  C   SER A  60      17.647  21.973 180.353  1.00 13.63           C  
ATOM    142  O   SER A  60      17.322  20.791 180.501  1.00 14.32           O  
ATOM    143  CB  SER A  60      20.073  22.230 179.662  1.00 14.62           C  
ATOM    144  OG  SER A  60      20.384  23.066 180.766  1.00 14.86           O  
ATOM    145  N   ARG A  61      17.180  22.969 181.107  1.00 13.55           N  
ATOM    146  CA  ARG A  61      16.284  22.735 182.242  1.00 14.27           C  
ATOM    147  C   ARG A  61      14.801  22.690 181.844  1.00 14.65           C  
ATOM    148  O   ARG A  61      13.930  22.385 182.665  1.00 13.95           O  
ATOM    149  CB  ARG A  61      16.579  23.744 183.358  1.00 14.50           C  
ATOM    150  CG  ARG A  61      17.650  23.210 184.337  1.00 15.83           C  
ATOM    151  CD  ARG A  61      18.930  22.752 183.608  1.00 17.96           C  
ATOM    152  NE  ARG A  61      19.920  22.202 184.520  1.00 21.62           N  
ATOM    153  CZ  ARG A  61      21.182  21.919 184.187  1.00 24.83           C  
ATOM    154  NH1 ARG A  61      21.625  22.112 182.944  1.00 24.74           N  
ATOM    155  NH2 ARG A  61      22.004  21.422 185.103  1.00 23.88           N  
ATOM    156  N   SER A  62      14.530  22.922 180.557  1.00 13.66           N  
ATOM    157  CA  SER A  62      13.139  22.946 180.089  1.00 13.55           C  
ATOM    158  C   SER A  62      12.856  22.048 178.872  1.00 12.89           C  
ATOM    159  O   SER A  62      11.740  21.530 178.736  1.00 12.96           O  
ATOM    160  CB  SER A  62      12.687  24.385 179.797  1.00 12.93           C  
ATOM    161  OG  SER A  62      13.405  24.967 178.714  1.00 13.05           O  
ATOM    162  N   MET A  63      13.826  21.917 177.957  1.00 12.40           N  
ATOM    163  CA  MET A  63      13.529  21.323 176.642  1.00 13.38           C  
ATOM    164  C   MET A  63      13.262  19.822 176.695  1.00 13.37           C  
ATOM    165  O   MET A  63      14.028  19.081 177.340  1.00 14.44           O  
ATOM    166  CB  MET A  63      14.634  21.656 175.614  1.00 12.66           C  
ATOM    167  CG  MET A  63      14.611  23.110 175.121  1.00 14.47           C  
ATOM    168  SD  MET A  63      13.040  23.606 174.384  1.00 12.41           S  
ATOM    169  CE  MET A  63      12.746  22.308 173.175  1.00  9.64           C  
ATOM    170  N   ARG A  64      12.194  19.395 176.019  1.00 13.48           N  
ATOM    171  CA  ARG A  64      11.807  17.984 175.908  1.00 13.46           C  
ATOM    172  C   ARG A  64      11.315  17.627 174.496  1.00 14.29           C  
ATOM    173  O   ARG A  64      10.180  17.152 174.294  1.00 14.85           O  
ATOM    174  CB  ARG A  64      10.768  17.613 176.983  1.00 13.12           C  
ATOM    175  CG  ARG A  64      11.172  17.884 178.418  1.00 13.54           C  
ATOM    176  CD  ARG A  64      10.149  17.210 179.364  1.00 13.16           C  
ATOM    177  NE  ARG A  64      10.265  17.644 180.758  1.00 13.66           N  
ATOM    178  CZ  ARG A  64       9.353  17.352 181.690  1.00 14.35           C  
ATOM    179  NH1 ARG A  64       8.269  16.632 181.368  1.00 12.09           N  
ATOM    180  NH2 ARG A  64       9.522  17.775 182.940  1.00 13.59           N  
ATOM    181  N   GLU A  65      12.171  17.881 173.498  1.00 14.46           N  
ATOM    182  CA  GLU A  65      11.809  17.592 172.134  1.00 14.18           C  
ATOM    183  C   GLU A  65      11.720  16.090 171.971  1.00 12.80           C  
ATOM    184  O   GLU A  65      12.618  15.367 172.435  1.00 13.78           O  
ATOM    185  CB  GLU A  65      12.900  18.077 171.177  1.00 13.94           C  
ATOM    186  CG  GLU A  65      12.893  19.553 170.842  1.00 15.22           C  
ATOM    187  CD  GLU A  65      14.167  19.935 170.102  1.00 15.65           C  
ATOM    188  OE1 GLU A  65      15.262  19.601 170.614  1.00 13.88           O  
ATOM    189  OE2 GLU A  65      14.060  20.522 168.995  1.00 14.58           O  
ATOM    190  N   HIS A  66      10.660  15.637 171.319  1.00 13.16           N  
ATOM    191  CA  HIS A  66      10.612  14.263 170.795  1.00 13.12           C  
ATOM    192  C   HIS A  66      11.855  14.058 169.924  1.00 12.87           C  
ATOM    193  O   HIS A  66      12.269  14.992 169.235  1.00 12.22           O  
ATOM    194  CB  HIS A  66       9.371  14.119 169.938  1.00 13.36           C  
ATOM    195  CG  HIS A  66       9.146  12.745 169.389  1.00 13.97           C  
ATOM    196  ND1 HIS A  66       9.848  12.244 168.311  1.00 12.90           N  
ATOM    197  CD2 HIS A  66       8.245  11.789 169.729  1.00 15.88           C  
ATOM    198  CE1 HIS A  66       9.397  11.037 168.020  1.00 16.40           C  
ATOM    199  NE2 HIS A  66       8.432  10.733 168.873  1.00 16.31           N  
ATOM    200  N   PRO A  67      12.490  12.853 169.971  1.00 13.20           N  
ATOM    201  CA  PRO A  67      13.705  12.619 169.148  1.00 12.87           C  
ATOM    202  C   PRO A  67      13.572  13.047 167.671  1.00 12.69           C  
ATOM    203  O   PRO A  67      14.514  13.629 167.123  1.00 13.24           O  
ATOM    204  CB  PRO A  67      13.949  11.106 169.301  1.00 13.10           C  
ATOM    205  CG  PRO A  67      13.455  10.828 170.715  1.00 14.02           C  
ATOM    206  CD  PRO A  67      12.178  11.681 170.819  1.00 14.40           C  
ATOM    207  N   ALA A  68      12.438  12.769 167.029  1.00 12.59           N  
ATOM    208  CA  ALA A  68      12.219  13.183 165.636  1.00 12.21           C  
ATOM    209  C   ALA A  68      12.216  14.706 165.489  1.00 12.85           C  
ATOM    210  O   ALA A  68      12.731  15.246 164.499  1.00 12.56           O  
ATOM    211  CB  ALA A  68      10.926  12.611 165.116  1.00 12.68           C  
ATOM    212  N   LEU A  69      11.627  15.391 166.472  1.00 12.07           N  
ATOM    213  CA  LEU A  69      11.565  16.862 166.443  1.00 11.90           C  
ATOM    214  C   LEU A  69      12.976  17.449 166.599  1.00 12.11           C  
ATOM    215  O   LEU A  69      13.366  18.360 165.856  1.00 11.98           O  
ATOM    216  CB  LEU A  69      10.629  17.385 167.525  1.00 12.41           C  
ATOM    217  CG  LEU A  69      10.247  18.866 167.473  1.00 13.06           C  
ATOM    218  CD1 LEU A  69       9.523  19.232 166.173  1.00 11.37           C  
ATOM    219  CD2 LEU A  69       9.380  19.196 168.686  1.00 11.70           C  
ATOM    220  N   ARG A  70      13.753  16.874 167.517  1.00 11.93           N  
ATOM    221  CA  ARG A  70      15.153  17.234 167.686  1.00 12.45           C  
ATOM    222  C   ARG A  70      15.948  17.021 166.380  1.00 12.31           C  
ATOM    223  O   ARG A  70      16.684  17.899 165.936  1.00 11.56           O  
ATOM    224  CB  ARG A  70      15.777  16.392 168.792  1.00 12.54           C  
ATOM    225  CG  ARG A  70      17.213  16.767 169.070  1.00 14.58           C  
ATOM    226  CD  ARG A  70      17.813  15.894 170.149  1.00 19.22           C  
ATOM    227  NE  ARG A  70      19.255  16.100 170.241  1.00 21.70           N  
ATOM    228  CZ  ARG A  70      20.171  15.464 169.508  1.00 23.92           C  
ATOM    229  NH1 ARG A  70      19.813  14.560 168.603  1.00 24.12           N  
ATOM    230  NH2 ARG A  70      21.460  15.733 169.682  1.00 25.35           N  
ATOM    231  N   SER A  71      15.781  15.846 165.783  1.00 12.39           N  
ATOM    232  CA  SER A  71      16.435  15.530 164.515  1.00 12.41           C  
ATOM    233  C   SER A  71      16.038  16.467 163.387  1.00 11.98           C  
ATOM    234  O   SER A  71      16.906  16.904 162.603  1.00 11.85           O  
ATOM    235  CB  SER A  71      16.221  14.067 164.142  1.00 12.53           C  
ATOM    236  OG  SER A  71      16.865  13.260 165.115  1.00 14.10           O  
ATOM    237  N   LEU A  72      14.751  16.817 163.318  1.00 11.21           N  
ATOM    238  CA  LEU A  72      14.301  17.838 162.365  1.00 11.44           C  
ATOM    239  C   LEU A  72      15.025  19.189 162.568  1.00 11.01           C  
ATOM    240  O   LEU A  72      15.470  19.806 161.598  1.00 10.62           O  
ATOM    241  CB  LEU A  72      12.768  18.007 162.377  1.00 10.92           C  
ATOM    242  CG  LEU A  72      12.219  19.000 161.334  1.00 11.38           C  
ATOM    243  CD1 LEU A  72      12.799  18.772 159.925  1.00 13.75           C  
ATOM    244  CD2 LEU A  72      10.663  18.985 161.283  1.00 12.10           C  
ATOM    245  N   ARG A  73      15.159  19.631 163.822  1.00 11.58           N  
ATOM    246  CA  ARG A  73      15.869  20.887 164.119  1.00 12.07           C  
ATOM    247  C   ARG A  73      17.311  20.797 163.633  1.00 12.91           C  
ATOM    248  O   ARG A  73      17.777  21.664 162.889  1.00 13.28           O  
ATOM    249  CB  ARG A  73      15.825  21.218 165.612  1.00 12.09           C  
ATOM    250  CG  ARG A  73      16.696  22.432 166.028  1.00 11.20           C  
ATOM    251  CD  ARG A  73      16.431  22.842 167.496  1.00 12.56           C  
ATOM    252  NE  ARG A  73      16.616  21.726 168.433  1.00 13.83           N  
ATOM    253  CZ  ARG A  73      17.795  21.344 168.911  1.00 15.36           C  
ATOM    254  NH1 ARG A  73      18.895  22.000 168.550  1.00 14.49           N  
ATOM    255  NH2 ARG A  73      17.886  20.322 169.768  1.00 15.34           N  
ATOM    256  N   LEU A  74      18.003  19.734 164.029  1.00 13.11           N  
ATOM    257  CA  LEU A  74      19.419  19.595 163.690  1.00 13.29           C  
ATOM    258  C   LEU A  74      19.620  19.545 162.173  1.00 13.43           C  
ATOM    259  O   LEU A  74      20.515  20.220 161.629  1.00 13.31           O  
ATOM    260  CB  LEU A  74      20.024  18.380 164.392  1.00 14.12           C  
ATOM    261  CG  LEU A  74      20.079  18.488 165.919  1.00 12.81           C  
ATOM    262  CD1 LEU A  74      20.713  17.251 166.528  1.00 17.92           C  
ATOM    263  CD2 LEU A  74      20.835  19.756 166.374  1.00 14.99           C  
ATOM    264  N   LEU A  75      18.779  18.784 161.483  1.00 13.27           N  
ATOM    265  CA  LEU A  75      18.825  18.708 160.020  1.00 14.17           C  
ATOM    266  C   LEU A  75      18.583  20.071 159.349  1.00 14.10           C  
ATOM    267  O   LEU A  75      19.282  20.443 158.407  1.00 13.84           O  
ATOM    268  CB  LEU A  75      17.784  17.706 159.512  1.00 14.42           C  
ATOM    269  CG  LEU A  75      17.621  17.549 157.996  1.00 16.40           C  
ATOM    270  CD1 LEU A  75      18.915  17.051 157.376  1.00 19.56           C  
ATOM    271  CD2 LEU A  75      16.450  16.607 157.670  1.00 16.16           C  
ATOM    272  N   THR A  76      17.578  20.791 159.837  1.00 12.69           N  
ATOM    273  CA  THR A  76      17.232  22.109 159.309  1.00 12.47           C  
ATOM    274  C   THR A  76      18.421  23.058 159.468  1.00 12.09           C  
ATOM    275  O   THR A  76      18.728  23.807 158.538  1.00 12.12           O  
ATOM    276  CB  THR A  76      15.960  22.650 159.971  1.00 12.43           C  
ATOM    277  OG1 THR A  76      14.910  21.718 159.696  1.00 11.86           O  
ATOM    278  CG2 THR A  76      15.545  24.004 159.354  1.00 13.03           C  
ATOM    279  N   LEU A  77      19.115  22.958 160.603  1.00 12.87           N  
ATOM    280  CA  LEU A  77      20.255  23.842 160.893  1.00 12.71           C  
ATOM    281  C   LEU A  77      21.496  23.554 160.043  1.00 13.72           C  
ATOM    282  O   LEU A  77      22.418  24.380 160.001  1.00 13.55           O  
ATOM    283  CB  LEU A  77      20.589  23.854 162.401  1.00 12.74           C  
ATOM    284  CG  LEU A  77      19.445  24.507 163.200  1.00 12.25           C  
ATOM    285  CD1 LEU A  77      19.663  24.287 164.719  1.00 14.29           C  
ATOM    286  CD2 LEU A  77      19.280  25.984 162.854  1.00 12.04           C  
ATOM    287  N   GLU A  78      21.507  22.406 159.368  1.00 13.64           N  
ATOM    288  CA  GLU A  78      22.544  22.114 158.348  1.00 14.23           C  
ATOM    289  C   GLU A  78      22.278  22.771 156.968  1.00 15.12           C  
ATOM    290  O   GLU A  78      23.129  22.693 156.050  1.00 15.81           O  
ATOM    291  CB  GLU A  78      22.768  20.594 158.225  1.00 14.08           C  
ATOM    292  CG  GLU A  78      23.390  19.972 159.500  1.00 14.32           C  
ATOM    293  CD  GLU A  78      24.674  20.689 159.953  1.00 16.32           C  
ATOM    294  OE1 GLU A  78      25.543  20.951 159.105  1.00 14.70           O  
ATOM    295  OE2 GLU A  78      24.801  21.013 161.140  1.00 18.58           O  
ATOM    296  N   GLN A  79      21.142  23.468 156.846  1.00 14.46           N  
ATOM    297  CA  GLN A  79      20.723  24.072 155.579  1.00 14.91           C  
ATOM    298  C   GLN A  79      20.969  25.595 155.551  1.00 14.20           C  
ATOM    299  O   GLN A  79      20.888  26.250 156.598  1.00 13.06           O  
ATOM    300  CB  GLN A  79      19.240  23.785 155.310  1.00 15.71           C  
ATOM    301  CG  GLN A  79      18.805  22.355 155.611  1.00 16.78           C  
ATOM    302  CD  GLN A  79      19.612  21.307 154.837  1.00 21.08           C  
ATOM    303  OE1 GLN A  79      19.943  21.512 153.660  1.00 22.21           O  
ATOM    304  NE2 GLN A  79      19.937  20.175 155.505  1.00 19.82           N  
ATOM    305  N   PRO A  80      21.253  26.171 154.349  1.00 14.45           N  
ATOM    306  CA  PRO A  80      21.225  27.633 154.231  1.00 14.13           C  
ATOM    307  C   PRO A  80      19.897  28.191 154.777  1.00 14.14           C  
ATOM    308  O   PRO A  80      18.837  27.624 154.524  1.00 14.26           O  
ATOM    309  CB  PRO A  80      21.331  27.866 152.711  1.00 14.29           C  
ATOM    310  CG  PRO A  80      22.150  26.699 152.223  1.00 14.72           C  
ATOM    311  CD  PRO A  80      21.609  25.529 153.065  1.00 15.05           C  
ATOM    312  N   GLN A  81      19.983  29.269 155.547  1.00 14.11           N  
ATOM    313  CA  GLN A  81      18.805  29.915 156.186  1.00 14.67           C  
ATOM    314  C   GLN A  81      18.076  29.010 157.181  1.00 14.27           C  
ATOM    315  O   GLN A  81      16.946  29.314 157.582  1.00 14.20           O  
ATOM    316  CB  GLN A  81      17.806  30.497 155.165  1.00 15.28           C  
ATOM    317  CG  GLN A  81      18.361  31.689 154.362  1.00 19.08           C  
ATOM    318  CD  GLN A  81      19.157  31.249 153.158  1.00 22.53           C  
ATOM    319  OE1 GLN A  81      18.777  30.294 152.449  1.00 24.20           O  
ATOM    320  NE2 GLN A  81      20.262  31.933 152.907  1.00 20.40           N  
ATOM    321  N   GLY A  82      18.744  27.939 157.611  1.00 14.17           N  
ATOM    322  CA  GLY A  82      18.136  26.958 158.538  1.00 13.84           C  
ATOM    323  C   GLY A  82      17.665  27.610 159.835  1.00 14.27           C  
ATOM    324  O   GLY A  82      16.685  27.171 160.445  1.00 13.40           O  
ATOM    325  N   ASP A  83      18.351  28.668 160.252  1.00 13.88           N  
ATOM    326  CA  ASP A  83      18.002  29.381 161.486  1.00 15.32           C  
ATOM    327  C   ASP A  83      16.772  30.277 161.342  1.00 15.58           C  
ATOM    328  O   ASP A  83      16.376  30.945 162.314  1.00 16.47           O  
ATOM    329  CB  ASP A  83      19.204  30.162 162.026  1.00 14.86           C  
ATOM    330  CG  ASP A  83      19.560  31.376 161.181  1.00 16.79           C  
ATOM    331  OD1 ASP A  83      19.355  31.348 159.942  1.00 15.69           O  
ATOM    332  OD2 ASP A  83      20.043  32.359 161.795  1.00 18.35           O  
ATOM    333  N   SER A  84      16.162  30.288 160.150  1.00 15.21           N  
ATOM    334  CA  SER A  84      14.808  30.856 159.973  1.00 16.73           C  
ATOM    335  C   SER A  84      13.745  30.055 160.735  1.00 15.50           C  
ATOM    336  O   SER A  84      12.636  30.538 160.961  1.00 16.30           O  
ATOM    337  CB  SER A  84      14.421  30.900 158.502  1.00 16.57           C  
ATOM    338  OG  SER A  84      15.105  31.984 157.894  1.00 22.44           O  
ATOM    339  N   MET A  85      14.071  28.819 161.097  1.00 15.07           N  
ATOM    340  CA  MET A  85      13.155  27.991 161.887  1.00 15.90           C  
ATOM    341  C   MET A  85      12.883  28.710 163.218  1.00 13.91           C  
ATOM    342  O   MET A  85      13.755  29.405 163.738  1.00 13.23           O  
ATOM    343  CB  MET A  85      13.834  26.635 162.107  1.00 15.37           C  
ATOM    344  CG  MET A  85      13.137  25.634 162.983  1.00 17.92           C  
ATOM    345  SD  MET A  85      14.183  24.149 162.930  1.00 20.84           S  
ATOM    346  CE  MET A  85      15.748  24.842 163.413  1.00 10.32           C  
ATOM    347  N   MET A  86      11.674  28.590 163.774  1.00 14.19           N  
ATOM    348  CA  MET A  86      11.498  29.159 165.102  1.00 13.58           C  
ATOM    349  C   MET A  86      12.332  28.367 166.128  1.00 13.46           C  
ATOM    350  O   MET A  86      12.536  27.151 165.998  1.00 12.04           O  
ATOM    351  CB  MET A  86      10.029  29.301 165.543  1.00 15.41           C  
ATOM    352  CG  MET A  86       9.416  28.030 166.096  1.00 14.48           C  
ATOM    353  SD  MET A  86       7.704  28.103 166.728  1.00 13.13           S  
ATOM    354  CE  MET A  86       7.713  29.484 167.851  1.00 25.19           C  
ATOM    355  N   THR A  87      12.832  29.079 167.126  1.00 13.12           N  
ATOM    356  CA  THR A  87      13.637  28.455 168.173  1.00 12.99           C  
ATOM    357  C   THR A  87      12.873  27.327 168.888  1.00 12.41           C  
ATOM    358  O   THR A  87      11.630  27.331 168.979  1.00 11.44           O  
ATOM    359  CB  THR A  87      14.129  29.495 169.190  1.00 13.78           C  
ATOM    360  OG1 THR A  87      12.996  30.199 169.708  1.00 14.21           O  
ATOM    361  CG2 THR A  87      15.080  30.497 168.507  1.00 16.32           C  
ATOM    362  N   CYS A  88      13.625  26.351 169.387  1.00 11.82           N  
ATOM    363  CA  CYS A  88      13.018  25.168 170.007  1.00 11.81           C  
ATOM    364  C   CYS A  88      12.094  25.510 171.193  1.00 10.98           C  
ATOM    365  O   CYS A  88      11.035  24.880 171.362  1.00 11.42           O  
ATOM    366  CB  CYS A  88      14.098  24.153 170.420  1.00 12.01           C  
ATOM    367  SG  CYS A  88      15.320  24.798 171.546  1.00 12.95           S  
ATOM    368  N   GLU A  89      12.460  26.500 172.010  1.00  9.50           N  
ATOM    369  CA  GLU A  89      11.605  26.808 173.189  1.00  9.62           C  
ATOM    370  C   GLU A  89      10.317  27.537 172.807  1.00  9.83           C  
ATOM    371  O   GLU A  89       9.301  27.452 173.518  1.00  9.77           O  
ATOM    372  CB  GLU A  89      12.388  27.563 174.269  1.00  8.67           C  
ATOM    373  CG  GLU A  89      12.534  29.088 174.067  1.00 10.51           C  
ATOM    374  CD  GLU A  89      13.330  29.476 172.846  1.00 11.47           C  
ATOM    375  OE1 GLU A  89      14.179  28.672 172.394  1.00 13.70           O  
ATOM    376  OE2 GLU A  89      13.095  30.607 172.341  1.00 13.12           O  
ATOM    377  N   GLN A  90      10.345  28.260 171.685  1.00  9.86           N  
ATOM    378  CA  GLN A  90       9.109  28.867 171.200  1.00  9.88           C  
ATOM    379  C   GLN A  90       8.175  27.773 170.721  1.00 10.49           C  
ATOM    380  O   GLN A  90       7.015  27.746 171.121  1.00  9.65           O  
ATOM    381  CB  GLN A  90       9.395  29.852 170.065  1.00 10.16           C  
ATOM    382  CG  GLN A  90       9.928  31.195 170.511  1.00 10.58           C  
ATOM    383  CD  GLN A  90      10.159  32.074 169.322  1.00 13.46           C  
ATOM    384  OE1 GLN A  90      11.121  31.867 168.548  1.00 16.80           O  
ATOM    385  NE2 GLN A  90       9.248  33.028 169.111  1.00 10.44           N  
ATOM    386  N   ALA A  91       8.679  26.861 169.871  1.00 10.39           N  
ATOM    387  CA  ALA A  91       7.857  25.732 169.414  1.00 10.25           C  
ATOM    388  C   ALA A  91       7.306  24.936 170.607  1.00 10.14           C  
ATOM    389  O   ALA A  91       6.150  24.507 170.594  1.00  9.68           O  
ATOM    390  CB  ALA A  91       8.670  24.797 168.472  1.00 11.54           C  
ATOM    391  N   GLN A  92       8.150  24.713 171.612  1.00 10.24           N  
ATOM    392  CA  GLN A  92       7.738  23.962 172.789  1.00  9.81           C  
ATOM    393  C   GLN A  92       6.681  24.695 173.594  1.00  8.95           C  
ATOM    394  O   GLN A  92       5.726  24.060 174.073  1.00  7.93           O  
ATOM    395  CB  GLN A  92       8.911  23.603 173.699  1.00 10.05           C  
ATOM    396  CG  GLN A  92       8.455  22.744 174.891  1.00 10.47           C  
ATOM    397  CD  GLN A  92       9.604  21.997 175.572  1.00 11.58           C  
ATOM    398  OE1 GLN A  92      10.297  21.181 174.944  1.00 12.72           O  
ATOM    399  NE2 GLN A  92       9.816  22.290 176.850  1.00 10.52           N  
ATOM    400  N   LEU A  93       6.833  26.010 173.764  1.00  8.61           N  
ATOM    401  CA  LEU A  93       5.769  26.768 174.448  1.00  9.20           C  
ATOM    402  C   LEU A  93       4.420  26.594 173.729  1.00  9.53           C  
ATOM    403  O   LEU A  93       3.389  26.301 174.360  1.00  8.49           O  
ATOM    404  CB  LEU A  93       6.121  28.235 174.566  1.00  8.82           C  
ATOM    405  CG  LEU A  93       5.064  29.142 175.196  1.00  9.11           C  
ATOM    406  CD1 LEU A  93       4.721  28.691 176.643  1.00  9.38           C  
ATOM    407  CD2 LEU A  93       5.506  30.608 175.111  1.00 10.23           C  
ATOM    408  N   LEU A  94       4.437  26.794 172.405  1.00  8.98           N  
ATOM    409  CA  LEU A  94       3.229  26.684 171.591  1.00 10.45           C  
ATOM    410  C   LEU A  94       2.599  25.282 171.684  1.00  9.34           C  
ATOM    411  O   LEU A  94       1.387  25.162 171.893  1.00  9.56           O  
ATOM    412  CB  LEU A  94       3.515  27.113 170.136  1.00  9.59           C  
ATOM    413  CG  LEU A  94       3.973  28.578 170.015  1.00 11.19           C  
ATOM    414  CD1 LEU A  94       4.232  28.944 168.545  1.00 11.85           C  
ATOM    415  CD2 LEU A  94       2.940  29.514 170.628  1.00 11.10           C  
ATOM    416  N   ALA A  95       3.443  24.234 171.598  1.00  9.36           N  
ATOM    417  CA  ALA A  95       2.997  22.842 171.705  1.00 10.03           C  
ATOM    418  C   ALA A  95       2.403  22.608 173.099  1.00 10.35           C  
ATOM    419  O   ALA A  95       1.343  21.988 173.223  1.00 10.68           O  
ATOM    420  CB  ALA A  95       4.153  21.896 171.475  1.00 10.11           C  
ATOM    421  N   ASN A  96       3.062  23.148 174.120  1.00  9.68           N  
ATOM    422  CA  ASN A  96       2.582  23.004 175.495  1.00 10.34           C  
ATOM    423  C   ASN A  96       1.211  23.660 175.680  1.00  9.76           C  
ATOM    424  O   ASN A  96       0.320  23.089 176.322  1.00 10.97           O  
ATOM    425  CB  ASN A  96       3.576  23.606 176.491  1.00  9.84           C  
ATOM    426  CG  ASN A  96       4.826  22.715 176.711  1.00  8.24           C  
ATOM    427  OD1 ASN A  96       4.857  21.529 176.356  1.00 10.78           O  
ATOM    428  ND2 ASN A  96       5.819  23.289 177.397  1.00 10.69           N  
ATOM    429  N   LEU A  97       1.049  24.870 175.153  1.00 10.18           N  
ATOM    430  CA  LEU A  97      -0.238  25.553 175.290  1.00  9.94           C  
ATOM    431  C   LEU A  97      -1.338  24.799 174.504  1.00 10.09           C  
ATOM    432  O   LEU A  97      -2.472  24.688 174.982  1.00 10.44           O  
ATOM    433  CB  LEU A  97      -0.134  27.019 174.884  1.00 10.59           C  
ATOM    434  CG  LEU A  97       0.765  27.911 175.750  1.00 10.37           C  
ATOM    435  CD1 LEU A  97       0.892  29.280 175.077  1.00 11.78           C  
ATOM    436  CD2 LEU A  97       0.232  28.034 177.216  1.00 12.14           C  
ATOM    437  N   ALA A  98      -0.997  24.260 173.329  1.00  9.94           N  
ATOM    438  CA  ALA A  98      -1.932  23.414 172.562  1.00 10.41           C  
ATOM    439  C   ALA A  98      -2.396  22.226 173.409  1.00 10.92           C  
ATOM    440  O   ALA A  98      -3.603  21.957 173.515  1.00 10.79           O  
ATOM    441  CB  ALA A  98      -1.303  22.940 171.238  1.00 10.92           C  
ATOM    442  N   ARG A  99      -1.442  21.537 174.043  1.00 10.67           N  
ATOM    443  CA  ARG A  99      -1.781  20.424 174.918  1.00 11.56           C  
ATOM    444  C   ARG A  99      -2.624  20.890 176.104  1.00 11.15           C  
ATOM    445  O   ARG A  99      -3.619  20.250 176.473  1.00 10.53           O  
ATOM    446  CB  ARG A  99      -0.539  19.686 175.396  1.00 12.41           C  
ATOM    447  CG  ARG A  99      -0.882  18.412 176.134  1.00 14.15           C  
ATOM    448  CD  ARG A  99       0.392  17.677 176.560  1.00 17.81           C  
ATOM    449  NE  ARG A  99       0.027  16.410 177.203  1.00 19.56           N  
ATOM    450  CZ  ARG A  99       0.901  15.485 177.602  1.00 21.03           C  
ATOM    451  NH1 ARG A  99       2.204  15.670 177.436  1.00 19.88           N  
ATOM    452  NH2 ARG A  99       0.457  14.371 178.171  1.00 20.89           N  
ATOM    453  N   LEU A 100      -2.220  22.007 176.699  1.00 10.75           N  
ATOM    454  CA  LEU A 100      -2.946  22.553 177.855  1.00 11.11           C  
ATOM    455  C   LEU A 100      -4.453  22.683 177.556  1.00 11.13           C  
ATOM    456  O   LEU A 100      -5.292  22.275 178.375  1.00 11.23           O  
ATOM    457  CB  LEU A 100      -2.377  23.911 178.222  1.00 11.58           C  
ATOM    458  CG  LEU A 100      -3.044  24.705 179.361  1.00 10.13           C  
ATOM    459  CD1 LEU A 100      -3.072  23.902 180.689  1.00 11.51           C  
ATOM    460  CD2 LEU A 100      -2.403  26.081 179.494  1.00 12.00           C  
ATOM    461  N   ILE A 101      -4.775  23.230 176.382  1.00 10.83           N  
ATOM    462  CA  ILE A 101      -6.190  23.492 175.996  1.00 11.53           C  
ATOM    463  C   ILE A 101      -6.858  22.306 175.254  1.00 12.10           C  
ATOM    464  O   ILE A 101      -7.997  22.422 174.745  1.00 11.97           O  
ATOM    465  CB  ILE A 101      -6.330  24.827 175.203  1.00 11.22           C  
ATOM    466  CG1 ILE A 101      -5.694  24.713 173.810  1.00 10.80           C  
ATOM    467  CG2 ILE A 101      -5.694  25.995 175.978  1.00  9.70           C  
ATOM    468  CD1 ILE A 101      -6.086  25.875 172.853  1.00 11.29           C  
ATOM    469  N   GLN A 102      -6.171  21.159 175.245  1.00 12.52           N  
ATOM    470  CA  GLN A 102      -6.649  19.936 174.581  1.00 14.33           C  
ATOM    471  C   GLN A 102      -6.993  20.204 173.105  1.00 12.74           C  
ATOM    472  O   GLN A 102      -8.032  19.759 172.593  1.00 12.65           O  
ATOM    473  CB  GLN A 102      -7.853  19.318 175.336  1.00 14.82           C  
ATOM    474  CG  GLN A 102      -7.549  18.922 176.796  1.00 19.12           C  
ATOM    475  CD  GLN A 102      -8.775  18.358 177.538  1.00 20.41           C  
ATOM    476  OE1 GLN A 102      -9.214  17.232 177.283  1.00 29.11           O  
ATOM    477  NE2 GLN A 102      -9.323  19.143 178.457  1.00 27.81           N  
ATOM    478  N   ALA A 103      -6.122  20.971 172.440  1.00 11.33           N  
ATOM    479  CA  ALA A 103      -6.242  21.252 171.016  1.00 12.27           C  
ATOM    480  C   ALA A 103      -6.416  19.964 170.193  1.00 12.45           C  
ATOM    481  O   ALA A 103      -5.774  18.937 170.469  1.00 11.98           O  
ATOM    482  CB  ALA A 103      -4.995  22.029 170.529  1.00 12.50           C  
ATOM    483  N   LYS A 104      -7.291  20.053 169.194  1.00 13.13           N  
ATOM    484  CA  LYS A 104      -7.548  19.016 168.187  1.00 13.64           C  
ATOM    485  C   LYS A 104      -7.256  19.517 166.759  1.00 13.60           C  
ATOM    486  O   LYS A 104      -7.025  18.714 165.859  1.00 12.48           O  
ATOM    487  CB  LYS A 104      -9.034  18.610 168.238  1.00 15.25           C  
ATOM    488  CG  LYS A 104      -9.474  17.997 169.564  1.00 21.17           C  
ATOM    489  CD  LYS A 104      -9.489  16.470 169.532  1.00 28.88           C  
ATOM    490  CE  LYS A 104     -10.493  15.919 168.515  1.00 31.87           C  
ATOM    491  NZ  LYS A 104     -11.130  14.667 169.006  1.00 33.59           N  
ATOM    492  N   LYS A 105      -7.338  20.837 166.536  1.00 12.44           N  
ATOM    493  CA  LYS A 105      -7.098  21.413 165.210  1.00 13.18           C  
ATOM    494  C   LYS A 105      -6.208  22.619 165.360  1.00 12.70           C  
ATOM    495  O   LYS A 105      -6.509  23.506 166.158  1.00 12.54           O  
ATOM    496  CB  LYS A 105      -8.401  21.887 164.541  1.00 13.41           C  
ATOM    497  CG  LYS A 105      -9.341  20.788 164.068  1.00 15.05           C  
ATOM    498  CD  LYS A 105     -10.644  21.395 163.482  1.00 14.03           C  
ATOM    499  CE  LYS A 105     -10.429  22.121 162.157  1.00 14.75           C  
ATOM    500  NZ  LYS A 105     -11.754  22.528 161.574  1.00 13.28           N  
ATOM    501  N   ALA A 106      -5.146  22.655 164.553  1.00 12.32           N  
ATOM    502  CA  ALA A 106      -4.189  23.752 164.567  1.00 11.55           C  
ATOM    503  C   ALA A 106      -3.924  24.234 163.140  1.00 11.81           C  
ATOM    504  O   ALA A 106      -4.051  23.474 162.170  1.00 11.71           O  
ATOM    505  CB  ALA A 106      -2.883  23.323 165.218  1.00 12.75           C  
ATOM    506  N   LEU A 107      -3.561  25.499 163.040  1.00 10.98           N  
ATOM    507  CA  LEU A 107      -3.164  26.093 161.776  1.00 11.50           C  
ATOM    508  C   LEU A 107      -1.720  26.547 161.954  1.00 11.56           C  
ATOM    509  O   LEU A 107      -1.377  27.170 162.975  1.00 12.14           O  
ATOM    510  CB  LEU A 107      -4.044  27.312 161.515  1.00 11.99           C  
ATOM    511  CG  LEU A 107      -5.322  27.209 160.717  1.00 15.66           C  
ATOM    512  CD1 LEU A 107      -6.107  28.512 160.914  1.00 17.23           C  
ATOM    513  CD2 LEU A 107      -4.995  26.984 159.246  1.00 17.99           C  
ATOM    514  N   ASP A 108      -0.876  26.236 160.975  1.00 11.61           N  
ATOM    515  CA  ASP A 108       0.532  26.565 161.023  1.00 11.82           C  
ATOM    516  C   ASP A 108       0.903  27.246 159.697  1.00 11.96           C  
ATOM    517  O   ASP A 108       1.011  26.579 158.651  1.00 11.69           O  
ATOM    518  CB  ASP A 108       1.342  25.279 161.255  1.00 13.09           C  
ATOM    519  CG  ASP A 108       2.843  25.497 161.164  1.00 12.30           C  
ATOM    520  OD1 ASP A 108       3.406  26.208 162.021  1.00 13.74           O  
ATOM    521  OD2 ASP A 108       3.468  24.953 160.241  1.00 12.15           O  
ATOM    522  N   LEU A 109       1.083  28.564 159.750  1.00 11.06           N  
ATOM    523  CA  LEU A 109       1.335  29.346 158.527  1.00 10.48           C  
ATOM    524  C   LEU A 109       2.837  29.555 158.416  1.00 10.47           C  
ATOM    525  O   LEU A 109       3.452  30.138 159.301  1.00 10.35           O  
ATOM    526  CB  LEU A 109       0.588  30.688 158.528  1.00 10.51           C  
ATOM    527  CG  LEU A 109      -0.913  30.720 158.883  1.00  9.97           C  
ATOM    528  CD1 LEU A 109      -1.473  32.130 158.683  1.00 11.09           C  
ATOM    529  CD2 LEU A 109      -1.685  29.715 158.059  1.00 11.34           C  
ATOM    530  N   GLY A 110       3.404  29.052 157.323  1.00 10.72           N  
ATOM    531  CA  GLY A 110       4.839  29.117 157.071  1.00 10.21           C  
ATOM    532  C   GLY A 110       5.501  27.831 157.489  1.00  9.90           C  
ATOM    533  O   GLY A 110       6.225  27.794 158.467  1.00  9.73           O  
ATOM    534  N   THR A 111       5.211  26.757 156.766  1.00 10.66           N  
ATOM    535  CA  THR A 111       5.699  25.414 157.122  1.00 11.74           C  
ATOM    536  C   THR A 111       7.237  25.355 157.260  1.00 11.67           C  
ATOM    537  O   THR A 111       7.773  24.802 158.238  1.00 12.18           O  
ATOM    538  CB  THR A 111       5.284  24.355 156.059  1.00 12.43           C  
ATOM    539  OG1 THR A 111       3.855  24.392 155.835  1.00 12.46           O  
ATOM    540  CG2 THR A 111       5.728  22.966 156.521  1.00 13.63           C  
ATOM    541  N   PHE A 112       7.924  25.943 156.277  1.00 12.21           N  
ATOM    542  CA  PHE A 112       9.372  25.799 156.128  1.00 12.68           C  
ATOM    543  C   PHE A 112       9.665  24.293 156.095  1.00 12.85           C  
ATOM    544  O   PHE A 112       9.042  23.574 155.286  1.00 13.53           O  
ATOM    545  CB  PHE A 112      10.157  26.549 157.232  1.00 12.59           C  
ATOM    546  CG  PHE A 112      11.630  26.708 156.945  1.00 12.82           C  
ATOM    547  CD1 PHE A 112      12.087  26.970 155.648  1.00 13.42           C  
ATOM    548  CD2 PHE A 112      12.566  26.579 157.968  1.00 12.17           C  
ATOM    549  CE1 PHE A 112      13.474  27.102 155.394  1.00 16.03           C  
ATOM    550  CE2 PHE A 112      13.937  26.739 157.731  1.00 13.77           C  
ATOM    551  CZ  PHE A 112      14.391  26.986 156.445  1.00 14.42           C  
ATOM    552  N   THR A 113      10.569  23.805 156.944  1.00 12.26           N  
ATOM    553  CA  THR A 113      10.877  22.368 156.974  1.00 13.46           C  
ATOM    554  C   THR A 113       9.881  21.545 157.813  1.00 13.40           C  
ATOM    555  O   THR A 113      10.042  20.322 157.953  1.00 14.81           O  
ATOM    556  CB  THR A 113      12.310  22.047 157.507  1.00 13.40           C  
ATOM    557  OG1 THR A 113      12.470  22.569 158.835  1.00 13.53           O  
ATOM    558  CG2 THR A 113      13.406  22.592 156.593  1.00 15.18           C  
ATOM    559  N   GLY A 114       8.873  22.195 158.384  1.00 12.51           N  
ATOM    560  CA  GLY A 114       7.846  21.505 159.179  1.00 12.30           C  
ATOM    561  C   GLY A 114       8.085  21.406 160.674  1.00 13.01           C  
ATOM    562  O   GLY A 114       7.408  20.623 161.387  1.00 12.85           O  
ATOM    563  N   TYR A 115       9.027  22.206 161.186  1.00 12.40           N  
ATOM    564  CA  TYR A 115       9.353  22.158 162.613  1.00 11.58           C  
ATOM    565  C   TYR A 115       8.183  22.553 163.536  1.00 11.71           C  
ATOM    566  O   TYR A 115       7.817  21.788 164.431  1.00 10.92           O  
ATOM    567  CB  TYR A 115      10.628  22.944 162.941  1.00 11.65           C  
ATOM    568  CG  TYR A 115      11.077  22.779 164.374  1.00 11.81           C  
ATOM    569  CD1 TYR A 115      11.794  21.640 164.775  1.00 13.03           C  
ATOM    570  CD2 TYR A 115      10.786  23.767 165.335  1.00 11.79           C  
ATOM    571  CE1 TYR A 115      12.237  21.487 166.097  1.00 10.52           C  
ATOM    572  CE2 TYR A 115      11.196  23.623 166.654  1.00 12.86           C  
ATOM    573  CZ  TYR A 115      11.922  22.488 167.037  1.00 12.55           C  
ATOM    574  OH  TYR A 115      12.319  22.355 168.335  1.00 11.45           O  
ATOM    575  N   SER A 116       7.592  23.732 163.324  1.00 12.13           N  
ATOM    576  CA  SER A 116       6.445  24.123 164.157  1.00 11.91           C  
ATOM    577  C   SER A 116       5.225  23.197 163.903  1.00 11.73           C  
ATOM    578  O   SER A 116       4.477  22.840 164.841  1.00 10.91           O  
ATOM    579  CB  SER A 116       6.082  25.605 163.971  1.00 12.50           C  
ATOM    580  OG  SER A 116       5.924  25.948 162.616  1.00 12.51           O  
ATOM    581  N   ALA A 117       5.061  22.765 162.654  1.00 11.28           N  
ATOM    582  CA  ALA A 117       3.956  21.839 162.297  1.00 11.71           C  
ATOM    583  C   ALA A 117       4.087  20.543 163.121  1.00 11.90           C  
ATOM    584  O   ALA A 117       3.099  20.042 163.692  1.00 11.07           O  
ATOM    585  CB  ALA A 117       3.956  21.540 160.793  1.00 12.33           C  
ATOM    586  N   LEU A 118       5.302  19.995 163.164  1.00 11.10           N  
ATOM    587  CA  LEU A 118       5.545  18.757 163.907  1.00 11.26           C  
ATOM    588  C   LEU A 118       5.413  18.971 165.411  1.00 10.79           C  
ATOM    589  O   LEU A 118       4.815  18.147 166.101  1.00 10.05           O  
ATOM    590  CB  LEU A 118       6.924  18.198 163.595  1.00 11.26           C  
ATOM    591  CG  LEU A 118       7.261  16.848 164.250  1.00 12.63           C  
ATOM    592  CD1 LEU A 118       6.226  15.762 163.938  1.00 14.67           C  
ATOM    593  CD2 LEU A 118       8.665  16.448 163.762  1.00 13.38           C  
ATOM    594  N   ALA A 119       5.972  20.076 165.914  1.00 10.62           N  
ATOM    595  CA  ALA A 119       5.825  20.416 167.329  1.00 10.41           C  
ATOM    596  C   ALA A 119       4.335  20.428 167.723  1.00  9.95           C  
ATOM    597  O   ALA A 119       3.948  19.837 168.723  1.00 10.61           O  
ATOM    598  CB  ALA A 119       6.489  21.745 167.632  1.00 10.88           C  
ATOM    599  N   LEU A 120       3.511  21.083 166.914  1.00 10.56           N  
ATOM    600  CA  LEU A 120       2.069  21.138 167.170  1.00 10.49           C  
ATOM    601  C   LEU A 120       1.411  19.745 167.088  1.00 11.03           C  
ATOM    602  O   LEU A 120       0.711  19.350 168.028  1.00 10.77           O  
ATOM    603  CB  LEU A 120       1.376  22.108 166.222  1.00 10.94           C  
ATOM    604  CG  LEU A 120       1.759  23.593 166.399  1.00 11.25           C  
ATOM    605  CD1 LEU A 120       1.310  24.363 165.180  1.00 12.02           C  
ATOM    606  CD2 LEU A 120       1.114  24.186 167.661  1.00 14.02           C  
ATOM    607  N   ALA A 121       1.670  19.028 165.990  1.00 12.13           N  
ATOM    608  CA  ALA A 121       1.126  17.674 165.777  1.00 11.72           C  
ATOM    609  C   ALA A 121       1.366  16.752 166.985  1.00 12.31           C  
ATOM    610  O   ALA A 121       0.453  16.026 167.429  1.00 12.32           O  
ATOM    611  CB  ALA A 121       1.677  17.058 164.485  1.00 11.28           C  
ATOM    612  N   LEU A 122       2.564  16.832 167.565  1.00 11.64           N  
ATOM    613  CA  LEU A 122       2.919  15.992 168.715  1.00 12.90           C  
ATOM    614  C   LEU A 122       2.152  16.348 170.002  1.00 12.52           C  
ATOM    615  O   LEU A 122       2.108  15.554 170.933  1.00 13.96           O  
ATOM    616  CB  LEU A 122       4.434  16.030 168.941  1.00 12.77           C  
ATOM    617  CG  LEU A 122       5.290  15.290 167.892  1.00 13.23           C  
ATOM    618  CD1 LEU A 122       6.755  15.711 168.045  1.00 15.03           C  
ATOM    619  CD2 LEU A 122       5.157  13.769 168.031  1.00 15.17           C  
ATOM    620  N   ALA A 123       1.530  17.522 170.029  1.00 12.44           N  
ATOM    621  CA  ALA A 123       0.753  17.967 171.199  1.00 12.74           C  
ATOM    622  C   ALA A 123      -0.729  17.593 171.060  1.00 13.30           C  
ATOM    623  O   ALA A 123      -1.516  17.788 172.012  1.00 14.24           O  
ATOM    624  CB  ALA A 123       0.909  19.489 171.389  1.00 12.82           C  
ATOM    625  N   LEU A 124      -1.097  17.047 169.889  1.00 12.89           N  
ATOM    626  CA  LEU A 124      -2.504  16.714 169.558  1.00 13.53           C  
ATOM    627  C   LEU A 124      -2.792  15.203 169.696  1.00 14.70           C  
ATOM    628  O   LEU A 124      -1.882  14.383 169.534  1.00 15.13           O  
ATOM    629  CB  LEU A 124      -2.881  17.152 168.124  1.00 12.91           C  
ATOM    630  CG  LEU A 124      -2.525  18.545 167.589  1.00 13.95           C  
ATOM    631  CD1 LEU A 124      -3.199  18.783 166.206  1.00 14.67           C  
ATOM    632  CD2 LEU A 124      -2.909  19.610 168.620  1.00 13.10           C  
ATOM    633  N   PRO A 125      -4.073  14.844 169.943  1.00 16.00           N  
ATOM    634  CA  PRO A 125      -4.450  13.424 169.991  1.00 16.86           C  
ATOM    635  C   PRO A 125      -4.357  12.795 168.614  1.00 17.59           C  
ATOM    636  O   PRO A 125      -4.093  13.489 167.622  1.00 15.49           O  
ATOM    637  CB  PRO A 125      -5.915  13.453 170.465  1.00 17.45           C  
ATOM    638  CG  PRO A 125      -6.419  14.799 170.091  1.00 16.85           C  
ATOM    639  CD  PRO A 125      -5.238  15.741 170.128  1.00 16.43           C  
ATOM    640  N   ALA A 126      -4.585  11.479 168.568  1.00 18.57           N  
ATOM    641  CA  ALA A 126      -4.452  10.685 167.359  1.00 19.40           C  
ATOM    642  C   ALA A 126      -5.204  11.255 166.167  1.00 19.60           C  
ATOM    643  O   ALA A 126      -4.725  11.179 165.030  1.00 20.73           O  
ATOM    644  CB  ALA A 126      -4.915   9.244 167.628  1.00 19.53           C  
ATOM    645  N   ASP A 127      -6.372  11.827 166.433  1.00 20.10           N  
ATOM    646  CA  ASP A 127      -7.256  12.306 165.384  1.00 21.39           C  
ATOM    647  C   ASP A 127      -7.086  13.810 165.183  1.00 20.57           C  
ATOM    648  O   ASP A 127      -7.892  14.456 164.495  1.00 20.92           O  
ATOM    649  CB  ASP A 127      -8.726  11.947 165.707  1.00 22.37           C  
ATOM    650  CG  ASP A 127      -9.193  12.481 167.063  1.00 25.43           C  
ATOM    651  OD1 ASP A 127      -8.407  12.500 168.040  1.00 26.66           O  
ATOM    652  OD2 ASP A 127     -10.379  12.887 167.161  1.00 31.25           O  
ATOM    653  N   GLY A 128      -6.040  14.360 165.800  1.00 19.16           N  
ATOM    654  CA  GLY A 128      -5.742  15.791 165.661  1.00 18.39           C  
ATOM    655  C   GLY A 128      -5.268  16.097 164.256  1.00 17.28           C  
ATOM    656  O   GLY A 128      -4.792  15.206 163.531  1.00 16.19           O  
ATOM    657  N   ARG A 129      -5.355  17.368 163.870  1.00 16.32           N  
ATOM    658  CA  ARG A 129      -4.910  17.773 162.543  1.00 16.50           C  
ATOM    659  C   ARG A 129      -4.210  19.131 162.610  1.00 15.20           C  
ATOM    660  O   ARG A 129      -4.690  20.044 163.287  1.00 14.59           O  
ATOM    661  CB  ARG A 129      -6.089  17.815 161.562  1.00 17.59           C  
ATOM    662  CG  ARG A 129      -6.665  16.418 161.190  1.00 20.77           C  
ATOM    663  CD  ARG A 129      -5.651  15.502 160.473  1.00 25.25           C  
ATOM    664  NE  ARG A 129      -6.197  14.174 160.143  1.00 26.21           N  
ATOM    665  CZ  ARG A 129      -6.177  13.104 160.950  1.00 30.64           C  
ATOM    666  NH1 ARG A 129      -5.654  13.158 162.175  1.00 30.23           N  
ATOM    667  NH2 ARG A 129      -6.694  11.952 160.524  1.00 33.63           N  
ATOM    668  N   VAL A 130      -3.076  19.252 161.918  1.00 13.58           N  
ATOM    669  CA  VAL A 130      -2.424  20.538 161.742  1.00 13.02           C  
ATOM    670  C   VAL A 130      -2.469  20.880 160.253  1.00 12.46           C  
ATOM    671  O   VAL A 130      -1.931  20.133 159.430  1.00 13.54           O  
ATOM    672  CB  VAL A 130      -0.916  20.525 162.192  1.00 12.74           C  
ATOM    673  CG1 VAL A 130      -0.261  21.911 161.912  1.00 14.62           C  
ATOM    674  CG2 VAL A 130      -0.776  20.113 163.661  1.00 13.32           C  
ATOM    675  N   VAL A 131      -3.149  21.971 159.914  1.00 11.85           N  
ATOM    676  CA  VAL A 131      -3.140  22.444 158.519  1.00 11.53           C  
ATOM    677  C   VAL A 131      -1.934  23.371 158.416  1.00 12.27           C  
ATOM    678  O   VAL A 131      -1.900  24.437 159.067  1.00 11.75           O  
ATOM    679  CB  VAL A 131      -4.471  23.149 158.113  1.00 11.85           C  
ATOM    680  CG1 VAL A 131      -4.357  23.696 156.713  1.00 12.80           C  
ATOM    681  CG2 VAL A 131      -5.678  22.205 158.251  1.00 11.43           C  
ATOM    682  N   THR A 132      -0.916  22.937 157.665  1.00 11.37           N  
ATOM    683  CA  THR A 132       0.314  23.720 157.551  1.00 12.00           C  
ATOM    684  C   THR A 132       0.439  24.252 156.116  1.00 12.20           C  
ATOM    685  O   THR A 132       0.187  23.502 155.161  1.00 13.34           O  
ATOM    686  CB  THR A 132       1.583  22.948 158.039  1.00 11.97           C  
ATOM    687  OG1 THR A 132       2.710  23.834 158.050  1.00 12.52           O  
ATOM    688  CG2 THR A 132       1.897  21.688 157.186  1.00 11.99           C  
ATOM    689  N   CYS A 133       0.805  25.531 155.992  1.00 11.67           N  
ATOM    690  CA  CYS A 133       0.696  26.288 154.722  1.00 12.70           C  
ATOM    691  C   CYS A 133       2.068  26.786 154.283  1.00 13.29           C  
ATOM    692  O   CYS A 133       2.819  27.369 155.071  1.00 12.57           O  
ATOM    693  CB  CYS A 133      -0.241  27.491 154.876  1.00 13.46           C  
ATOM    694  SG  CYS A 133      -1.922  27.055 155.362  1.00 14.63           S  
ATOM    695  N   GLU A 134       2.385  26.595 153.006  1.00 13.05           N  
ATOM    696  CA  GLU A 134       3.733  26.908 152.518  1.00 14.10           C  
ATOM    697  C   GLU A 134       3.654  27.123 151.005  1.00 14.56           C  
ATOM    698  O   GLU A 134       2.837  26.473 150.337  1.00 15.24           O  
ATOM    699  CB  GLU A 134       4.685  25.725 152.839  1.00 13.13           C  
ATOM    700  CG  GLU A 134       6.162  25.868 152.371  1.00 13.85           C  
ATOM    701  CD  GLU A 134       6.826  27.175 152.810  1.00 12.88           C  
ATOM    702  OE1 GLU A 134       7.142  27.356 154.006  1.00 12.28           O  
ATOM    703  OE2 GLU A 134       7.040  28.045 151.940  1.00 15.69           O  
ATOM    704  N   VAL A 135       4.492  28.013 150.473  1.00 16.35           N  
ATOM    705  CA  VAL A 135       4.577  28.242 149.006  1.00 18.31           C  
ATOM    706  C   VAL A 135       5.754  27.507 148.341  1.00 19.59           C  
ATOM    707  O   VAL A 135       5.695  27.193 147.153  1.00 21.59           O  
ATOM    708  CB  VAL A 135       4.623  29.761 148.636  1.00 17.85           C  
ATOM    709  CG1 VAL A 135       3.268  30.430 148.906  1.00 18.58           C  
ATOM    710  CG2 VAL A 135       5.754  30.479 149.364  1.00 18.01           C  
ATOM    711  N   ASP A 136       6.798  27.242 149.124  1.00 20.12           N  
ATOM    712  CA  ASP A 136       8.056  26.628 148.688  1.00 21.13           C  
ATOM    713  C   ASP A 136       8.009  25.110 148.936  1.00 20.72           C  
ATOM    714  O   ASP A 136       8.067  24.665 150.078  1.00 19.87           O  
ATOM    715  CB  ASP A 136       9.210  27.284 149.478  1.00 21.36           C  
ATOM    716  CG  ASP A 136      10.592  26.925 148.955  1.00 25.28           C  
ATOM    717  OD1 ASP A 136      10.735  26.034 148.082  1.00 27.98           O  
ATOM    718  OD2 ASP A 136      11.560  27.543 149.460  1.00 28.44           O  
ATOM    719  N   ALA A 137       7.889  24.326 147.860  1.00 21.44           N  
ATOM    720  CA  ALA A 137       7.758  22.856 147.952  1.00 21.21           C  
ATOM    721  C   ALA A 137       8.960  22.131 148.569  1.00 21.64           C  
ATOM    722  O   ALA A 137       8.806  21.042 149.142  1.00 21.42           O  
ATOM    723  CB  ALA A 137       7.462  22.281 146.581  1.00 21.62           C  
ATOM    724  N   GLN A 138      10.154  22.710 148.430  1.00 21.19           N  
ATOM    725  CA  GLN A 138      11.401  22.041 148.827  1.00 22.36           C  
ATOM    726  C   GLN A 138      11.571  21.817 150.336  1.00 20.05           C  
ATOM    727  O   GLN A 138      11.830  20.679 150.757  1.00 20.22           O  
ATOM    728  CB  GLN A 138      12.643  22.781 148.291  1.00 22.60           C  
ATOM    729  CG  GLN A 138      12.941  22.601 146.809  1.00 26.09           C  
ATOM    730  CD  GLN A 138      14.158  23.420 146.321  1.00 26.79           C  
ATOM    731  OE1 GLN A 138      14.807  24.151 147.099  1.00 31.50           O  
ATOM    732  NE2 GLN A 138      14.472  23.289 145.021  1.00 29.85           N  
ATOM    733  N   PRO A 139      11.497  22.899 151.150  1.00 19.02           N  
ATOM    734  CA  PRO A 139      11.765  22.685 152.581  1.00 18.02           C  
ATOM    735  C   PRO A 139      10.859  21.622 153.256  1.00 16.93           C  
ATOM    736  O   PRO A 139      11.381  20.800 154.023  1.00 16.60           O  
ATOM    737  CB  PRO A 139      11.622  24.094 153.193  1.00 17.79           C  
ATOM    738  CG  PRO A 139      11.935  25.025 152.009  1.00 19.11           C  
ATOM    739  CD  PRO A 139      11.283  24.331 150.845  1.00 18.44           C  
ATOM    740  N   PRO A 140       9.530  21.612 152.972  1.00 16.86           N  
ATOM    741  CA  PRO A 140       8.728  20.519 153.565  1.00 16.83           C  
ATOM    742  C   PRO A 140       9.199  19.101 153.219  1.00 17.40           C  
ATOM    743  O   PRO A 140       9.071  18.205 154.042  1.00 16.70           O  
ATOM    744  CB  PRO A 140       7.318  20.775 153.030  1.00 16.62           C  
ATOM    745  CG  PRO A 140       7.303  22.255 152.771  1.00 16.96           C  
ATOM    746  CD  PRO A 140       8.662  22.546 152.223  1.00 16.09           C  
ATOM    747  N   GLU A 141       9.762  18.916 152.020  1.00 18.46           N  
ATOM    748  CA  GLU A 141      10.358  17.629 151.628  1.00 20.09           C  
ATOM    749  C   GLU A 141      11.492  17.196 152.566  1.00 20.40           C  
ATOM    750  O   GLU A 141      11.675  15.996 152.856  1.00 19.84           O  
ATOM    751  CB  GLU A 141      10.831  17.684 150.170  1.00 21.15           C  
ATOM    752  CG  GLU A 141       9.680  17.667 149.204  1.00 24.84           C  
ATOM    753  CD  GLU A 141       8.708  16.528 149.494  1.00 30.86           C  
ATOM    754  OE1 GLU A 141       9.162  15.352 149.532  1.00 33.53           O  
ATOM    755  OE2 GLU A 141       7.499  16.809 149.683  1.00 33.28           O  
ATOM    756  N   LEU A 142      12.239  18.182 153.054  1.00 21.09           N  
ATOM    757  CA  LEU A 142      13.280  17.953 154.044  1.00 22.26           C  
ATOM    758  C   LEU A 142      12.726  17.380 155.331  1.00 21.84           C  
ATOM    759  O   LEU A 142      13.266  16.415 155.855  1.00 22.49           O  
ATOM    760  CB  LEU A 142      14.040  19.251 154.358  1.00 23.19           C  
ATOM    761  CG  LEU A 142      15.457  19.447 153.829  1.00 25.26           C  
ATOM    762  CD1 LEU A 142      15.458  20.189 152.493  1.00 29.89           C  
ATOM    763  CD2 LEU A 142      16.228  20.236 154.862  1.00 28.19           C  
ATOM    764  N   GLY A 143      11.656  17.988 155.851  1.00 20.83           N  
ATOM    765  CA  GLY A 143      11.093  17.588 157.133  1.00 20.63           C  
ATOM    766  C   GLY A 143      10.231  16.337 157.125  1.00 20.42           C  
ATOM    767  O   GLY A 143      10.149  15.637 158.136  1.00 20.18           O  
ATOM    768  N   ARG A 144       9.582  16.040 155.998  1.00 19.82           N  
ATOM    769  CA  ARG A 144       8.628  14.926 155.949  1.00 20.23           C  
ATOM    770  C   ARG A 144       9.127  13.579 156.572  1.00 18.35           C  
ATOM    771  O   ARG A 144       8.356  12.904 157.288  1.00 17.30           O  
ATOM    772  CB  ARG A 144       8.049  14.751 154.537  1.00 20.50           C  
ATOM    773  CG  ARG A 144       7.219  13.489 154.357  1.00 23.51           C  
ATOM    774  CD  ARG A 144       6.288  13.542 153.132  1.00 24.28           C  
ATOM    775  NE  ARG A 144       6.459  14.745 152.310  1.00 30.46           N  
ATOM    776  CZ  ARG A 144       5.521  15.676 152.118  1.00 32.56           C  
ATOM    777  NH1 ARG A 144       4.312  15.556 152.671  1.00 31.15           N  
ATOM    778  NH2 ARG A 144       5.791  16.732 151.354  1.00 33.78           N  
ATOM    779  N   PRO A 145      10.386  13.171 156.294  1.00 17.96           N  
ATOM    780  CA  PRO A 145      10.866  11.934 156.938  1.00 17.23           C  
ATOM    781  C   PRO A 145      10.793  11.967 158.469  1.00 16.88           C  
ATOM    782  O   PRO A 145      10.509  10.944 159.115  1.00 16.28           O  
ATOM    783  CB  PRO A 145      12.319  11.848 156.464  1.00 16.95           C  
ATOM    784  CG  PRO A 145      12.275  12.480 155.112  1.00 18.10           C  
ATOM    785  CD  PRO A 145      11.407  13.693 155.353  1.00 17.77           C  
ATOM    786  N   LEU A 146      11.014  13.144 159.042  1.00 15.71           N  
ATOM    787  CA  LEU A 146      10.877  13.306 160.495  1.00 16.19           C  
ATOM    788  C   LEU A 146       9.426  13.305 160.949  1.00 15.08           C  
ATOM    789  O   LEU A 146       9.134  12.759 162.035  1.00 15.12           O  
ATOM    790  CB  LEU A 146      11.684  14.500 160.996  1.00 16.04           C  
ATOM    791  CG  LEU A 146      13.117  14.074 160.618  1.00 19.28           C  
ATOM    792  CD1 LEU A 146      13.930  15.107 159.873  1.00 20.55           C  
ATOM    793  CD2 LEU A 146      13.890  13.290 161.708  1.00 20.21           C  
ATOM    794  N   TRP A 147       8.521  13.872 160.135  1.00 14.60           N  
ATOM    795  CA  TRP A 147       7.075  13.726 160.379  1.00 15.76           C  
ATOM    796  C   TRP A 147       6.722  12.236 160.456  1.00 14.99           C  
ATOM    797  O   TRP A 147       6.023  11.804 161.374  1.00 13.85           O  
ATOM    798  CB  TRP A 147       6.214  14.404 159.300  1.00 16.06           C  
ATOM    799  CG  TRP A 147       6.525  15.839 159.016  1.00 16.50           C  
ATOM    800  CD1 TRP A 147       7.411  16.648 159.668  1.00 19.44           C  
ATOM    801  CD2 TRP A 147       5.922  16.639 157.998  1.00 15.28           C  
ATOM    802  NE1 TRP A 147       7.415  17.913 159.096  1.00 21.86           N  
ATOM    803  CE2 TRP A 147       6.497  17.930 158.075  1.00 19.56           C  
ATOM    804  CE3 TRP A 147       4.960  16.385 157.018  1.00 15.03           C  
ATOM    805  CZ2 TRP A 147       6.131  18.968 157.204  1.00 19.99           C  
ATOM    806  CZ3 TRP A 147       4.585  17.421 156.162  1.00 16.93           C  
ATOM    807  CH2 TRP A 147       5.172  18.692 156.263  1.00 18.64           C  
ATOM    808  N   ARG A 148       7.258  11.454 159.510  1.00 14.20           N  
ATOM    809  CA  ARG A 148       6.996  10.010 159.470  1.00 14.57           C  
ATOM    810  C   ARG A 148       7.564   9.306 160.701  1.00 13.90           C  
ATOM    811  O   ARG A 148       6.860   8.499 161.345  1.00 13.92           O  
ATOM    812  CB  ARG A 148       7.589   9.383 158.198  1.00 14.40           C  
ATOM    813  CG  ARG A 148       7.435   7.873 158.137  1.00 14.84           C  
ATOM    814  CD  ARG A 148       8.216   7.332 156.947  1.00 16.15           C  
ATOM    815  NE  ARG A 148       7.747   6.007 156.548  1.00 15.17           N  
ATOM    816  CZ  ARG A 148       8.264   5.341 155.519  1.00 15.53           C  
ATOM    817  NH1 ARG A 148       9.252   5.882 154.826  1.00 13.94           N  
ATOM    818  NH2 ARG A 148       7.802   4.148 155.190  1.00 15.69           N  
ATOM    819  N   GLN A 149       8.817   9.627 161.042  1.00 13.49           N  
ATOM    820  CA  GLN A 149       9.474   9.054 162.228  1.00 14.02           C  
ATOM    821  C   GLN A 149       8.639   9.283 163.512  1.00 14.98           C  
ATOM    822  O   GLN A 149       8.547   8.401 164.387  1.00 14.95           O  
ATOM    823  CB  GLN A 149      10.878   9.620 162.397  1.00 13.95           C  
ATOM    824  CG  GLN A 149      11.623   9.075 163.627  1.00 14.24           C  
ATOM    825  CD  GLN A 149      13.072   9.530 163.688  1.00 14.54           C  
ATOM    826  OE1 GLN A 149      13.757   9.605 162.662  1.00 17.06           O  
ATOM    827  NE2 GLN A 149      13.548   9.834 164.883  1.00 15.98           N  
ATOM    828  N   ALA A 150       8.004  10.454 163.576  1.00 15.88           N  
ATOM    829  CA  ALA A 150       7.193  10.849 164.722  1.00 17.06           C  
ATOM    830  C   ALA A 150       5.763  10.279 164.717  1.00 18.35           C  
ATOM    831  O   ALA A 150       4.962  10.571 165.634  1.00 18.44           O  
ATOM    832  CB  ALA A 150       7.172  12.387 164.819  1.00 16.79           C  
ATOM    833  N   GLU A 151       5.422   9.494 163.692  1.00 18.65           N  
ATOM    834  CA  GLU A 151       4.046   8.977 163.502  1.00 20.88           C  
ATOM    835  C   GLU A 151       3.017  10.102 163.349  1.00 20.71           C  
ATOM    836  O   GLU A 151       1.853   9.957 163.749  1.00 20.72           O  
ATOM    837  CB  GLU A 151       3.633   8.030 164.647  1.00 20.41           C  
ATOM    838  CG  GLU A 151       4.573   6.857 164.896  1.00 23.72           C  
ATOM    839  CD  GLU A 151       3.929   5.790 165.790  1.00 24.41           C  
ATOM    840  OE1 GLU A 151       4.191   5.780 167.008  1.00 28.70           O  
ATOM    841  OE2 GLU A 151       3.143   4.970 165.266  1.00 31.80           O  
ATOM    842  N   ALA A 152       3.458  11.216 162.765  1.00 20.38           N  
ATOM    843  CA  ALA A 152       2.636  12.420 162.669  1.00 21.70           C  
ATOM    844  C   ALA A 152       2.187  12.797 161.258  1.00 22.32           C  
ATOM    845  O   ALA A 152       1.478  13.779 161.081  1.00 21.57           O  
ATOM    846  CB  ALA A 152       3.340  13.602 163.352  1.00 20.94           C  
ATOM    847  N   GLU A 153       2.567  12.010 160.250  1.00 23.43           N  
ATOM    848  CA  GLU A 153       2.162  12.314 158.864  1.00 24.75           C  
ATOM    849  C   GLU A 153       0.663  12.400 158.642  1.00 25.34           C  
ATOM    850  O   GLU A 153       0.195  13.257 157.883  1.00 25.99           O  
ATOM    851  CB  GLU A 153       2.750  11.306 157.881  1.00 25.09           C  
ATOM    852  CG  GLU A 153       4.063  11.738 157.336  1.00 25.53           C  
ATOM    853  CD  GLU A 153       4.565  10.796 156.271  1.00 27.34           C  
ATOM    854  OE1 GLU A 153       4.619   9.585 156.551  1.00 24.66           O  
ATOM    855  OE2 GLU A 153       4.886  11.272 155.159  1.00 29.65           O  
ATOM    856  N   HIS A 154      -0.100  11.524 159.293  1.00 25.46           N  
ATOM    857  CA  HIS A 154      -1.546  11.554 159.143  1.00 26.35           C  
ATOM    858  C   HIS A 154      -2.167  12.790 159.807  1.00 24.62           C  
ATOM    859  O   HIS A 154      -3.271  13.205 159.451  1.00 24.93           O  
ATOM    860  CB  HIS A 154      -2.180  10.257 159.658  1.00 27.81           C  
ATOM    861  CG  HIS A 154      -2.143   9.131 158.663  1.00 32.40           C  
ATOM    862  ND1 HIS A 154      -2.648   9.249 157.382  1.00 36.39           N  
ATOM    863  CD2 HIS A 154      -1.678   7.861 158.767  1.00 35.84           C  
ATOM    864  CE1 HIS A 154      -2.493   8.103 156.741  1.00 36.88           C  
ATOM    865  NE2 HIS A 154      -1.905   7.245 157.558  1.00 37.10           N  
ATOM    866  N   LYS A 155      -1.435  13.372 160.754  1.00 22.44           N  
ATOM    867  CA  LYS A 155      -1.885  14.557 161.481  1.00 21.03           C  
ATOM    868  C   LYS A 155      -1.536  15.839 160.734  1.00 20.21           C  
ATOM    869  O   LYS A 155      -2.202  16.860 160.906  1.00 20.82           O  
ATOM    870  CB  LYS A 155      -1.227  14.626 162.860  1.00 20.45           C  
ATOM    871  CG  LYS A 155      -1.731  13.645 163.890  1.00 21.73           C  
ATOM    872  CD  LYS A 155      -1.058  14.003 165.208  1.00 21.12           C  
ATOM    873  CE  LYS A 155      -1.224  12.962 166.253  1.00 21.20           C  
ATOM    874  NZ  LYS A 155      -0.333  13.219 167.405  1.00 20.20           N  
ATOM    875  N   ILE A 156      -0.490  15.796 159.911  1.00 18.52           N  
ATOM    876  CA  ILE A 156      -0.019  17.016 159.241  1.00 17.20           C  
ATOM    877  C   ILE A 156      -0.581  17.105 157.829  1.00 17.97           C  
ATOM    878  O   ILE A 156      -0.333  16.225 156.994  1.00 17.92           O  
ATOM    879  CB  ILE A 156       1.517  17.159 159.287  1.00 17.22           C  
ATOM    880  CG1 ILE A 156       1.970  17.202 160.750  1.00 15.95           C  
ATOM    881  CG2 ILE A 156       1.964  18.438 158.566  1.00 15.50           C  
ATOM    882  CD1 ILE A 156       3.465  16.958 160.976  1.00 14.61           C  
ATOM    883  N   ASP A 157      -1.354  18.165 157.598  1.00 16.61           N  
ATOM    884  CA  ASP A 157      -2.079  18.385 156.357  1.00 16.88           C  
ATOM    885  C   ASP A 157      -1.386  19.539 155.612  1.00 16.55           C  
ATOM    886  O   ASP A 157      -1.654  20.723 155.858  1.00 16.36           O  
ATOM    887  CB  ASP A 157      -3.558  18.692 156.693  1.00 16.89           C  
ATOM    888  CG  ASP A 157      -4.427  18.939 155.459  1.00 19.36           C  
ATOM    889  OD1 ASP A 157      -3.893  18.967 154.329  1.00 21.16           O  
ATOM    890  OD2 ASP A 157      -5.663  19.115 155.643  1.00 20.59           O  
ATOM    891  N   LEU A 158      -0.469  19.184 154.717  1.00 15.75           N  
ATOM    892  CA  LEU A 158       0.338  20.200 154.027  1.00 15.91           C  
ATOM    893  C   LEU A 158      -0.435  20.823 152.855  1.00 16.07           C  
ATOM    894  O   LEU A 158      -0.912  20.110 151.974  1.00 16.27           O  
ATOM    895  CB  LEU A 158       1.668  19.594 153.553  1.00 15.50           C  
ATOM    896  CG  LEU A 158       2.597  20.455 152.684  1.00 15.37           C  
ATOM    897  CD1 LEU A 158       3.106  21.720 153.442  1.00 15.72           C  
ATOM    898  CD2 LEU A 158       3.760  19.620 152.163  1.00 16.44           C  
ATOM    899  N   ARG A 159      -0.548  22.149 152.851  1.00 15.66           N  
ATOM    900  CA  ARG A 159      -1.219  22.874 151.755  1.00 16.15           C  
ATOM    901  C   ARG A 159      -0.192  23.734 151.060  1.00 15.97           C  
ATOM    902  O   ARG A 159       0.206  24.773 151.571  1.00 14.36           O  
ATOM    903  CB  ARG A 159      -2.360  23.751 152.271  1.00 16.23           C  
ATOM    904  CG  ARG A 159      -3.438  23.012 153.088  1.00 17.79           C  
ATOM    905  CD  ARG A 159      -4.173  21.939 152.272  1.00 18.19           C  
ATOM    906  NE  ARG A 159      -5.124  21.261 153.157  1.00 19.84           N  
ATOM    907  CZ  ARG A 159      -6.366  21.683 153.406  1.00 19.41           C  
ATOM    908  NH1 ARG A 159      -6.863  22.759 152.787  1.00 19.76           N  
ATOM    909  NH2 ARG A 159      -7.130  21.000 154.252  1.00 20.54           N  
ATOM    910  N   LEU A 160       0.261  23.260 149.905  1.00 16.30           N  
ATOM    911  CA  LEU A 160       1.301  23.917 149.130  1.00 17.59           C  
ATOM    912  C   LEU A 160       0.680  24.968 148.183  1.00 17.74           C  
ATOM    913  O   LEU A 160       0.328  24.680 147.029  1.00 18.67           O  
ATOM    914  CB  LEU A 160       2.095  22.841 148.373  1.00 17.77           C  
ATOM    915  CG  LEU A 160       3.626  22.823 148.379  1.00 20.71           C  
ATOM    916  CD1 LEU A 160       4.264  23.397 149.655  1.00 19.46           C  
ATOM    917  CD2 LEU A 160       4.120  21.381 148.132  1.00 19.95           C  
ATOM    918  N   LYS A 161       0.512  26.179 148.712  1.00 17.05           N  
ATOM    919  CA  LYS A 161      -0.032  27.327 147.990  1.00 17.07           C  
ATOM    920  C   LYS A 161      -0.012  28.508 148.971  1.00 16.63           C  
ATOM    921  O   LYS A 161       0.218  28.299 150.165  1.00 16.21           O  
ATOM    922  CB  LYS A 161      -1.474  27.052 147.521  1.00 17.19           C  
ATOM    923  CG  LYS A 161      -2.519  27.058 148.636  1.00 19.92           C  
ATOM    924  CD  LYS A 161      -3.848  26.413 148.209  1.00 18.63           C  
ATOM    925  CE  LYS A 161      -3.743  24.878 148.329  1.00 23.53           C  
ATOM    926  NZ  LYS A 161      -5.020  24.125 148.004  1.00 25.81           N  
ATOM    927  N   PRO A 162      -0.255  29.741 148.486  1.00 15.88           N  
ATOM    928  CA  PRO A 162      -0.254  30.881 149.423  1.00 15.58           C  
ATOM    929  C   PRO A 162      -1.245  30.659 150.575  1.00 14.89           C  
ATOM    930  O   PRO A 162      -2.368  30.184 150.369  1.00 15.01           O  
ATOM    931  CB  PRO A 162      -0.662  32.059 148.537  1.00 15.71           C  
ATOM    932  CG  PRO A 162      -0.058  31.657 147.182  1.00 15.22           C  
ATOM    933  CD  PRO A 162      -0.479  30.199 147.102  1.00 17.00           C  
ATOM    934  N   ALA A 163      -0.783  30.955 151.785  1.00 14.42           N  
ATOM    935  CA  ALA A 163      -1.607  30.776 152.991  1.00 14.26           C  
ATOM    936  C   ALA A 163      -2.943  31.478 152.895  1.00 13.96           C  
ATOM    937  O   ALA A 163      -3.937  30.962 153.379  1.00 13.32           O  
ATOM    938  CB  ALA A 163      -0.843  31.228 154.234  1.00 14.64           C  
ATOM    939  N   LEU A 164      -2.984  32.658 152.276  1.00 14.05           N  
ATOM    940  CA  LEU A 164      -4.236  33.422 152.193  1.00 14.76           C  
ATOM    941  C   LEU A 164      -5.328  32.618 151.488  1.00 14.71           C  
ATOM    942  O   LEU A 164      -6.508  32.657 151.882  1.00 14.43           O  
ATOM    943  CB  LEU A 164      -4.009  34.757 151.477  1.00 15.96           C  
ATOM    944  CG  LEU A 164      -5.176  35.743 151.556  1.00 17.23           C  
ATOM    945  CD1 LEU A 164      -5.514  36.082 153.015  1.00 18.81           C  
ATOM    946  CD2 LEU A 164      -4.850  36.991 150.769  1.00 20.84           C  
ATOM    947  N   GLU A 165      -4.925  31.918 150.428  1.00 14.75           N  
ATOM    948  CA  GLU A 165      -5.834  31.074 149.662  1.00 14.74           C  
ATOM    949  C   GLU A 165      -6.374  29.946 150.539  1.00 13.72           C  
ATOM    950  O   GLU A 165      -7.584  29.680 150.552  1.00 13.94           O  
ATOM    951  CB  GLU A 165      -5.119  30.521 148.418  1.00 15.18           C  
ATOM    952  CG  GLU A 165      -4.910  31.615 147.364  1.00 18.99           C  
ATOM    953  CD  GLU A 165      -3.879  31.258 146.309  1.00 23.04           C  
ATOM    954  OE1 GLU A 165      -3.719  30.053 146.008  1.00 23.71           O  
ATOM    955  OE2 GLU A 165      -3.235  32.198 145.782  1.00 23.62           O  
ATOM    956  N   THR A 166      -5.495  29.303 151.286  1.00 12.66           N  
ATOM    957  CA  THR A 166      -5.939  28.199 152.160  1.00 12.54           C  
ATOM    958  C   THR A 166      -6.899  28.714 153.229  1.00 12.88           C  
ATOM    959  O   THR A 166      -7.959  28.113 153.490  1.00 13.13           O  
ATOM    960  CB  THR A 166      -4.745  27.446 152.731  1.00 13.16           C  
ATOM    961  OG1 THR A 166      -4.065  26.806 151.637  1.00 13.83           O  
ATOM    962  CG2 THR A 166      -5.184  26.383 153.770  1.00 14.04           C  
ATOM    963  N   LEU A 167      -6.554  29.850 153.819  1.00 12.84           N  
ATOM    964  CA  LEU A 167      -7.402  30.439 154.867  1.00 12.96           C  
ATOM    965  C   LEU A 167      -8.820  30.728 154.333  1.00 13.35           C  
ATOM    966  O   LEU A 167      -9.827  30.417 154.992  1.00 12.64           O  
ATOM    967  CB  LEU A 167      -6.757  31.694 155.436  1.00 12.50           C  
ATOM    968  CG  LEU A 167      -5.450  31.478 156.216  1.00 12.82           C  
ATOM    969  CD1 LEU A 167      -4.743  32.828 156.412  1.00 14.09           C  
ATOM    970  CD2 LEU A 167      -5.704  30.749 157.551  1.00 15.11           C  
ATOM    971  N   ASP A 168      -8.900  31.280 153.122  1.00 13.43           N  
ATOM    972  CA  ASP A 168     -10.197  31.572 152.525  1.00 14.62           C  
ATOM    973  C   ASP A 168     -10.985  30.302 152.255  1.00 14.39           C  
ATOM    974  O   ASP A 168     -12.196  30.275 152.473  1.00 14.58           O  
ATOM    975  CB  ASP A 168     -10.047  32.418 151.250  1.00 15.32           C  
ATOM    976  CG  ASP A 168      -9.697  33.871 151.543  1.00 18.16           C  
ATOM    977  OD1 ASP A 168      -9.847  34.341 152.703  1.00 19.58           O  
ATOM    978  OD2 ASP A 168      -9.257  34.552 150.586  1.00 21.04           O  
ATOM    979  N   GLU A 169     -10.292  29.255 151.802  1.00 14.01           N  
ATOM    980  CA  GLU A 169     -10.922  27.959 151.555  1.00 15.09           C  
ATOM    981  C   GLU A 169     -11.528  27.372 152.829  1.00 14.18           C  
ATOM    982  O   GLU A 169     -12.686  26.910 152.816  1.00 13.55           O  
ATOM    983  CB  GLU A 169      -9.929  26.967 150.970  1.00 15.51           C  
ATOM    984  CG  GLU A 169      -9.574  27.246 149.535  1.00 20.19           C  
ATOM    985  CD  GLU A 169      -8.723  26.137 148.946  1.00 25.10           C  
ATOM    986  OE1 GLU A 169      -8.097  25.393 149.740  1.00 25.43           O  
ATOM    987  OE2 GLU A 169      -8.693  26.012 147.697  1.00 29.60           O  
ATOM    988  N   LEU A 170     -10.763  27.406 153.925  1.00 13.63           N  
ATOM    989  CA  LEU A 170     -11.257  26.854 155.206  1.00 13.21           C  
ATOM    990  C   LEU A 170     -12.498  27.624 155.669  1.00 12.81           C  
ATOM    991  O   LEU A 170     -13.463  27.022 156.125  1.00 13.48           O  
ATOM    992  CB  LEU A 170     -10.184  26.901 156.301  1.00 13.69           C  
ATOM    993  CG  LEU A 170      -8.931  26.065 156.086  1.00 12.28           C  
ATOM    994  CD1 LEU A 170      -7.815  26.517 157.095  1.00 11.65           C  
ATOM    995  CD2 LEU A 170      -9.288  24.593 156.214  1.00 14.39           C  
ATOM    996  N   LEU A 171     -12.469  28.950 155.536  1.00 12.50           N  
ATOM    997  CA  LEU A 171     -13.618  29.769 155.931  1.00 12.85           C  
ATOM    998  C   LEU A 171     -14.835  29.492 155.027  1.00 13.56           C  
ATOM    999  O   LEU A 171     -15.959  29.370 155.519  1.00 12.71           O  
ATOM   1000  CB  LEU A 171     -13.270  31.260 155.956  1.00 13.25           C  
ATOM   1001  CG  LEU A 171     -12.364  31.758 157.091  1.00 13.26           C  
ATOM   1002  CD1 LEU A 171     -11.753  33.129 156.743  1.00 14.45           C  
ATOM   1003  CD2 LEU A 171     -13.167  31.783 158.402  1.00 12.99           C  
ATOM   1004  N   ALA A 172     -14.600  29.384 153.716  1.00 14.14           N  
ATOM   1005  CA  ALA A 172     -15.671  29.006 152.765  1.00 14.91           C  
ATOM   1006  C   ALA A 172     -16.273  27.642 153.093  1.00 15.20           C  
ATOM   1007  O   ALA A 172     -17.472  27.413 152.879  1.00 17.34           O  
ATOM   1008  CB  ALA A 172     -15.143  29.015 151.322  1.00 15.26           C  
ATOM   1009  N   ALA A 173     -15.436  26.726 153.576  1.00 14.50           N  
ATOM   1010  CA  ALA A 173     -15.842  25.378 153.963  1.00 14.71           C  
ATOM   1011  C   ALA A 173     -16.598  25.307 155.298  1.00 14.76           C  
ATOM   1012  O   ALA A 173     -16.974  24.225 155.732  1.00 16.12           O  
ATOM   1013  CB  ALA A 173     -14.639  24.449 153.986  1.00 14.40           C  
ATOM   1014  N   GLY A 174     -16.801  26.442 155.952  1.00 14.68           N  
ATOM   1015  CA  GLY A 174     -17.588  26.481 157.183  1.00 14.43           C  
ATOM   1016  C   GLY A 174     -16.795  26.155 158.439  1.00 13.73           C  
ATOM   1017  O   GLY A 174     -17.376  25.809 159.473  1.00 14.08           O  
ATOM   1018  N   GLU A 175     -15.477  26.314 158.366  1.00 11.90           N  
ATOM   1019  CA  GLU A 175     -14.607  26.043 159.509  1.00 12.21           C  
ATOM   1020  C   GLU A 175     -14.367  27.199 160.497  1.00 11.76           C  
ATOM   1021  O   GLU A 175     -13.635  27.019 161.486  1.00 11.75           O  
ATOM   1022  CB  GLU A 175     -13.296  25.391 159.033  1.00 11.36           C  
ATOM   1023  CG  GLU A 175     -13.570  24.049 158.388  1.00 12.90           C  
ATOM   1024  CD  GLU A 175     -12.342  23.215 158.088  1.00 15.59           C  
ATOM   1025  OE1 GLU A 175     -11.376  23.220 158.888  1.00 13.34           O  
ATOM   1026  OE2 GLU A 175     -12.378  22.503 157.055  1.00 18.13           O  
ATOM   1027  N   ALA A 176     -15.036  28.353 160.305  1.00 11.19           N  
ATOM   1028  CA  ALA A 176     -14.923  29.424 161.309  1.00 11.22           C  
ATOM   1029  C   ALA A 176     -15.257  28.915 162.718  1.00 11.66           C  
ATOM   1030  O   ALA A 176     -16.191  28.117 162.901  1.00 11.58           O  
ATOM   1031  CB  ALA A 176     -15.804  30.656 160.983  1.00 11.55           C  
ATOM   1032  N   GLY A 177     -14.469  29.369 163.696  1.00 10.97           N  
ATOM   1033  CA  GLY A 177     -14.731  29.053 165.107  1.00 12.42           C  
ATOM   1034  C   GLY A 177     -14.425  27.619 165.510  1.00 12.17           C  
ATOM   1035  O   GLY A 177     -14.866  27.186 166.581  1.00 12.68           O  
ATOM   1036  N   THR A 178     -13.691  26.875 164.666  1.00 11.35           N  
ATOM   1037  CA  THR A 178     -13.363  25.466 164.949  1.00 11.36           C  
ATOM   1038  C   THR A 178     -11.884  25.114 165.204  1.00 11.07           C  
ATOM   1039  O   THR A 178     -11.596  23.983 165.622  1.00 11.34           O  
ATOM   1040  CB  THR A 178     -13.860  24.488 163.842  1.00 11.62           C  
ATOM   1041  OG1 THR A 178     -13.023  24.595 162.682  1.00 12.17           O  
ATOM   1042  CG2 THR A 178     -15.357  24.709 163.479  1.00 13.44           C  
ATOM   1043  N   PHE A 179     -10.955  26.036 164.936  1.00  9.45           N  
ATOM   1044  CA  PHE A 179      -9.540  25.801 165.246  1.00 10.07           C  
ATOM   1045  C   PHE A 179      -9.203  26.189 166.684  1.00 10.20           C  
ATOM   1046  O   PHE A 179      -9.805  27.116 167.236  1.00 10.31           O  
ATOM   1047  CB  PHE A 179      -8.649  26.543 164.248  1.00  9.78           C  
ATOM   1048  CG  PHE A 179      -8.609  25.886 162.912  1.00 10.63           C  
ATOM   1049  CD1 PHE A 179      -7.583  25.017 162.591  1.00 11.29           C  
ATOM   1050  CD2 PHE A 179      -9.634  26.082 161.991  1.00 10.88           C  
ATOM   1051  CE1 PHE A 179      -7.547  24.362 161.350  1.00 11.30           C  
ATOM   1052  CE2 PHE A 179      -9.633  25.416 160.754  1.00  8.91           C  
ATOM   1053  CZ  PHE A 179      -8.573  24.561 160.432  1.00 10.42           C  
ATOM   1054  N   ASP A 180      -8.223  25.496 167.255  1.00 10.07           N  
ATOM   1055  CA  ASP A 180      -7.817  25.684 168.643  1.00 11.36           C  
ATOM   1056  C   ASP A 180      -6.566  26.527 168.784  1.00 11.45           C  
ATOM   1057  O   ASP A 180      -6.440  27.260 169.760  1.00 11.36           O  
ATOM   1058  CB  ASP A 180      -7.606  24.312 169.314  1.00 11.44           C  
ATOM   1059  CG  ASP A 180      -8.845  23.420 169.187  1.00 13.66           C  
ATOM   1060  OD1 ASP A 180      -9.903  23.833 169.690  1.00 16.40           O  
ATOM   1061  OD2 ASP A 180      -8.782  22.351 168.527  1.00 13.40           O  
ATOM   1062  N   VAL A 181      -5.657  26.413 167.806  1.00 11.06           N  
ATOM   1063  CA  VAL A 181      -4.366  27.141 167.820  1.00 10.79           C  
ATOM   1064  C   VAL A 181      -4.002  27.542 166.389  1.00 10.64           C  
ATOM   1065  O   VAL A 181      -4.175  26.756 165.458  1.00 10.52           O  
ATOM   1066  CB  VAL A 181      -3.207  26.276 168.430  1.00 11.03           C  
ATOM   1067  CG1 VAL A 181      -1.864  27.010 168.373  1.00 13.65           C  
ATOM   1068  CG2 VAL A 181      -3.533  25.828 169.882  1.00 10.89           C  
ATOM   1069  N   ALA A 182      -3.500  28.766 166.219  1.00  9.44           N  
ATOM   1070  CA  ALA A 182      -3.090  29.263 164.903  1.00  9.24           C  
ATOM   1071  C   ALA A 182      -1.730  29.928 165.097  1.00 10.08           C  
ATOM   1072  O   ALA A 182      -1.579  30.781 165.982  1.00 10.87           O  
ATOM   1073  CB  ALA A 182      -4.106  30.274 164.323  1.00  9.42           C  
ATOM   1074  N   VAL A 183      -0.749  29.541 164.271  1.00  9.56           N  
ATOM   1075  CA  VAL A 183       0.624  30.063 164.365  1.00  9.41           C  
ATOM   1076  C   VAL A 183       0.937  30.837 163.081  1.00 10.25           C  
ATOM   1077  O   VAL A 183       0.900  30.269 161.979  1.00 10.45           O  
ATOM   1078  CB  VAL A 183       1.635  28.924 164.579  1.00  9.66           C  
ATOM   1079  CG1 VAL A 183       3.094  29.441 164.487  1.00 10.07           C  
ATOM   1080  CG2 VAL A 183       1.323  28.188 165.905  1.00  9.70           C  
ATOM   1081  N   VAL A 184       1.220  32.134 163.226  1.00  9.88           N  
ATOM   1082  CA  VAL A 184       1.361  33.032 162.066  1.00 10.01           C  
ATOM   1083  C   VAL A 184       2.852  33.315 161.924  1.00 10.44           C  
ATOM   1084  O   VAL A 184       3.394  34.171 162.619  1.00 10.61           O  
ATOM   1085  CB  VAL A 184       0.526  34.320 162.213  1.00 10.30           C  
ATOM   1086  CG1 VAL A 184       0.792  35.275 161.031  1.00  9.89           C  
ATOM   1087  CG2 VAL A 184      -0.988  33.959 162.323  1.00  8.53           C  
ATOM   1088  N   ASP A 185       3.504  32.552 161.054  1.00 11.25           N  
ATOM   1089  CA  ASP A 185       4.957  32.625 160.876  1.00 10.67           C  
ATOM   1090  C   ASP A 185       5.310  32.500 159.394  1.00 11.41           C  
ATOM   1091  O   ASP A 185       6.220  31.768 159.037  1.00 12.26           O  
ATOM   1092  CB  ASP A 185       5.673  31.531 161.691  1.00 11.01           C  
ATOM   1093  CG  ASP A 185       7.198  31.734 161.763  1.00 11.90           C  
ATOM   1094  OD1 ASP A 185       7.673  32.882 161.548  1.00 12.39           O  
ATOM   1095  OD2 ASP A 185       7.921  30.744 162.067  1.00 12.18           O  
ATOM   1096  N   ALA A 186       4.543  33.175 158.532  1.00 11.87           N  
ATOM   1097  CA  ALA A 186       4.878  33.190 157.116  1.00 12.49           C  
ATOM   1098  C   ALA A 186       5.478  34.542 156.716  1.00 12.39           C  
ATOM   1099  O   ALA A 186       6.300  35.090 157.440  1.00 13.52           O  
ATOM   1100  CB  ALA A 186       3.671  32.831 156.271  1.00 12.88           C  
ATOM   1101  N   ASP A 187       5.050  35.087 155.584  1.00 12.14           N  
ATOM   1102  CA  ASP A 187       5.538  36.384 155.119  1.00 12.86           C  
ATOM   1103  C   ASP A 187       4.912  37.498 155.943  1.00 12.88           C  
ATOM   1104  O   ASP A 187       3.780  37.370 156.420  1.00 13.30           O  
ATOM   1105  CB  ASP A 187       5.153  36.589 153.650  1.00 12.68           C  
ATOM   1106  CG  ASP A 187       3.650  36.495 153.439  1.00 14.06           C  
ATOM   1107  OD1 ASP A 187       3.110  35.382 153.616  1.00 15.17           O  
ATOM   1108  OD2 ASP A 187       2.998  37.539 153.157  1.00 16.77           O  
ATOM   1109  N   LYS A 188       5.629  38.605 156.092  1.00 13.21           N  
ATOM   1110  CA  LYS A 188       5.048  39.769 156.772  1.00 13.46           C  
ATOM   1111  C   LYS A 188       4.082  40.617 155.914  1.00 14.10           C  
ATOM   1112  O   LYS A 188       3.206  41.295 156.470  1.00 14.37           O  
ATOM   1113  CB  LYS A 188       6.141  40.639 157.400  1.00 13.94           C  
ATOM   1114  CG  LYS A 188       6.915  39.928 158.514  1.00 13.02           C  
ATOM   1115  CD  LYS A 188       5.971  39.452 159.616  1.00 12.10           C  
ATOM   1116  CE  LYS A 188       6.717  38.980 160.839  1.00 11.82           C  
ATOM   1117  NZ  LYS A 188       5.761  38.688 161.947  1.00 11.48           N  
ATOM   1118  N   GLU A 189       4.216  40.563 154.579  1.00 14.34           N  
ATOM   1119  CA  GLU A 189       3.365  41.353 153.693  1.00 15.09           C  
ATOM   1120  C   GLU A 189       1.884  41.139 153.971  1.00 14.51           C  
ATOM   1121  O   GLU A 189       1.100  42.100 153.960  1.00 14.67           O  
ATOM   1122  CB  GLU A 189       3.683  41.109 152.208  1.00 15.68           C  
ATOM   1123  CG  GLU A 189       5.029  41.723 151.754  1.00 18.16           C  
ATOM   1124  CD  GLU A 189       6.281  41.000 152.283  1.00 21.38           C  
ATOM   1125  OE1 GLU A 189       6.202  39.836 152.747  1.00 18.13           O  
ATOM   1126  OE2 GLU A 189       7.374  41.611 152.206  1.00 23.52           O  
ATOM   1127  N   ASN A 190       1.507  39.882 154.215  1.00 13.63           N  
ATOM   1128  CA  ASN A 190       0.106  39.539 154.421  1.00 13.78           C  
ATOM   1129  C   ASN A 190      -0.277  39.259 155.883  1.00 13.64           C  
ATOM   1130  O   ASN A 190      -1.336  38.666 156.132  1.00 12.76           O  
ATOM   1131  CB  ASN A 190      -0.259  38.323 153.575  1.00 14.41           C  
ATOM   1132  CG  ASN A 190      -0.193  38.624 152.089  1.00 15.00           C  
ATOM   1133  OD1 ASN A 190      -1.078  39.275 151.553  1.00 16.96           O  
ATOM   1134  ND2 ASN A 190       0.878  38.185 151.434  1.00 16.57           N  
ATOM   1135  N   CYS A 191       0.557  39.683 156.836  1.00 13.64           N  
ATOM   1136  CA  CYS A 191       0.381  39.220 158.236  1.00 13.53           C  
ATOM   1137  C   CYS A 191      -0.926  39.757 158.849  1.00 13.33           C  
ATOM   1138  O   CYS A 191      -1.575  39.078 159.661  1.00 13.46           O  
ATOM   1139  CB  CYS A 191       1.605  39.526 159.114  1.00 14.29           C  
ATOM   1140  SG  CYS A 191       1.864  41.270 159.446  1.00 14.67           S  
ATOM   1141  N   SER A 192      -1.363  40.933 158.399  1.00 12.60           N  
ATOM   1142  CA  SER A 192      -2.631  41.495 158.919  1.00 13.40           C  
ATOM   1143  C   SER A 192      -3.839  40.684 158.447  1.00 13.20           C  
ATOM   1144  O   SER A 192      -4.713  40.320 159.245  1.00 12.23           O  
ATOM   1145  CB  SER A 192      -2.757  42.978 158.606  1.00 13.16           C  
ATOM   1146  OG  SER A 192      -1.929  43.686 159.525  1.00 16.42           O  
ATOM   1147  N   ALA A 193      -3.853  40.355 157.163  1.00 12.96           N  
ATOM   1148  CA  ALA A 193      -4.842  39.431 156.612  1.00 13.37           C  
ATOM   1149  C   ALA A 193      -4.822  38.060 157.315  1.00 13.01           C  
ATOM   1150  O   ALA A 193      -5.888  37.497 157.572  1.00 13.23           O  
ATOM   1151  CB  ALA A 193      -4.618  39.264 155.105  1.00 13.92           C  
ATOM   1152  N   TYR A 194      -3.626  37.544 157.617  1.00 12.64           N  
ATOM   1153  CA  TYR A 194      -3.487  36.242 158.318  1.00 11.76           C  
ATOM   1154  C   TYR A 194      -4.110  36.326 159.701  1.00 12.14           C  
ATOM   1155  O   TYR A 194      -4.871  35.434 160.094  1.00 12.54           O  
ATOM   1156  CB  TYR A 194      -2.035  35.783 158.455  1.00 12.59           C  
ATOM   1157  CG  TYR A 194      -1.319  35.564 157.134  1.00 11.91           C  
ATOM   1158  CD1 TYR A 194      -2.039  35.250 155.956  1.00 12.05           C  
ATOM   1159  CD2 TYR A 194       0.062  35.647 157.060  1.00 13.64           C  
ATOM   1160  CE1 TYR A 194      -1.379  35.050 154.737  1.00 14.75           C  
ATOM   1161  CE2 TYR A 194       0.745  35.439 155.834  1.00 14.13           C  
ATOM   1162  CZ  TYR A 194       0.010  35.140 154.687  1.00 14.08           C  
ATOM   1163  OH  TYR A 194       0.651  34.940 153.496  1.00 14.30           O  
ATOM   1164  N   TYR A 195      -3.777  37.398 160.417  1.00 11.81           N  
ATOM   1165  CA  TYR A 195      -4.324  37.636 161.764  1.00 11.27           C  
ATOM   1166  C   TYR A 195      -5.844  37.587 161.738  1.00 12.15           C  
ATOM   1167  O   TYR A 195      -6.452  36.828 162.499  1.00 11.00           O  
ATOM   1168  CB  TYR A 195      -3.827  38.970 162.332  1.00 11.45           C  
ATOM   1169  CG  TYR A 195      -4.366  39.272 163.713  1.00 10.58           C  
ATOM   1170  CD1 TYR A 195      -3.803  38.674 164.847  1.00 11.16           C  
ATOM   1171  CD2 TYR A 195      -5.421  40.187 163.881  1.00 10.03           C  
ATOM   1172  CE1 TYR A 195      -4.288  38.947 166.119  1.00 10.84           C  
ATOM   1173  CE2 TYR A 195      -5.933  40.483 165.157  1.00 11.25           C  
ATOM   1174  CZ  TYR A 195      -5.367  39.849 166.266  1.00 11.32           C  
ATOM   1175  OH  TYR A 195      -5.846  40.125 167.499  1.00 12.53           O  
ATOM   1176  N   GLU A 196      -6.457  38.367 160.839  1.00 11.19           N  
ATOM   1177  CA  GLU A 196      -7.922  38.421 160.789  1.00 12.55           C  
ATOM   1178  C   GLU A 196      -8.550  37.061 160.456  1.00 12.64           C  
ATOM   1179  O   GLU A 196      -9.496  36.614 161.131  1.00 13.10           O  
ATOM   1180  CB  GLU A 196      -8.404  39.508 159.824  1.00 12.12           C  
ATOM   1181  CG  GLU A 196      -8.052  40.948 160.263  1.00 13.40           C  
ATOM   1182  CD  GLU A 196      -8.738  41.380 161.585  1.00 15.81           C  
ATOM   1183  OE1 GLU A 196      -9.893  40.977 161.852  1.00 15.25           O  
ATOM   1184  OE2 GLU A 196      -8.119  42.147 162.352  1.00 17.86           O  
ATOM   1185  N   ARG A 197      -8.021  36.395 159.429  1.00 12.24           N  
ATOM   1186  CA  ARG A 197      -8.586  35.097 159.022  1.00 12.79           C  
ATOM   1187  C   ARG A 197      -8.399  34.054 160.131  1.00 12.52           C  
ATOM   1188  O   ARG A 197      -9.324  33.287 160.446  1.00 11.06           O  
ATOM   1189  CB  ARG A 197      -7.952  34.573 157.730  1.00 13.09           C  
ATOM   1190  CG  ARG A 197      -7.990  35.545 156.536  1.00 17.76           C  
ATOM   1191  CD  ARG A 197      -9.325  35.677 155.865  1.00 22.79           C  
ATOM   1192  NE  ARG A 197      -9.201  36.406 154.580  1.00 24.95           N  
ATOM   1193  CZ  ARG A 197      -8.786  37.673 154.455  1.00 27.01           C  
ATOM   1194  NH1 ARG A 197      -8.400  38.380 155.519  1.00 28.78           N  
ATOM   1195  NH2 ARG A 197      -8.741  38.239 153.260  1.00 26.66           N  
ATOM   1196  N   CYS A 198      -7.193  34.014 160.718  1.00 12.38           N  
ATOM   1197  CA  CYS A 198      -6.941  33.085 161.820  1.00 12.12           C  
ATOM   1198  C   CYS A 198      -7.882  33.340 162.993  1.00 12.25           C  
ATOM   1199  O   CYS A 198      -8.401  32.391 163.578  1.00 11.28           O  
ATOM   1200  CB  CYS A 198      -5.478  33.104 162.307  1.00 13.44           C  
ATOM   1201  SG  CYS A 198      -4.390  32.377 161.119  1.00 13.03           S  
ATOM   1202  N   LEU A 199      -8.078  34.613 163.348  1.00 11.96           N  
ATOM   1203  CA  LEU A 199      -8.985  34.946 164.456  1.00 12.54           C  
ATOM   1204  C   LEU A 199     -10.373  34.430 164.184  1.00 12.09           C  
ATOM   1205  O   LEU A 199     -11.020  33.918 165.090  1.00 12.69           O  
ATOM   1206  CB  LEU A 199      -9.015  36.454 164.740  1.00 12.70           C  
ATOM   1207  CG  LEU A 199      -9.614  36.925 166.078  1.00 12.90           C  
ATOM   1208  CD1 LEU A 199      -8.847  36.329 167.266  1.00 14.89           C  
ATOM   1209  CD2 LEU A 199      -9.576  38.446 166.167  1.00 14.18           C  
ATOM   1210  N   GLN A 200     -10.834  34.548 162.937  1.00 11.63           N  
ATOM   1211  CA  GLN A 200     -12.144  34.035 162.572  1.00 12.85           C  
ATOM   1212  C   GLN A 200     -12.205  32.500 162.638  1.00 12.18           C  
ATOM   1213  O   GLN A 200     -13.223  31.918 163.031  1.00 12.69           O  
ATOM   1214  CB  GLN A 200     -12.525  34.495 161.177  1.00 12.85           C  
ATOM   1215  CG  GLN A 200     -14.019  34.453 160.963  1.00 18.86           C  
ATOM   1216  CD  GLN A 200     -14.455  34.879 159.566  1.00 22.87           C  
ATOM   1217  OE1 GLN A 200     -13.742  35.585 158.849  1.00 23.51           O  
ATOM   1218  NE2 GLN A 200     -15.640  34.430 159.176  1.00 25.69           N  
ATOM   1219  N   LEU A 201     -11.114  31.850 162.236  1.00 10.97           N  
ATOM   1220  CA  LEU A 201     -11.050  30.405 162.256  1.00 11.36           C  
ATOM   1221  C   LEU A 201     -10.935  29.813 163.680  1.00 11.17           C  
ATOM   1222  O   LEU A 201     -11.306  28.650 163.903  1.00 12.18           O  
ATOM   1223  CB  LEU A 201      -9.899  29.921 161.386  1.00 11.59           C  
ATOM   1224  CG  LEU A 201     -10.202  30.020 159.877  1.00 11.09           C  
ATOM   1225  CD1 LEU A 201      -8.891  30.008 159.103  1.00 11.56           C  
ATOM   1226  CD2 LEU A 201     -11.125  28.849 159.451  1.00 13.69           C  
ATOM   1227  N   LEU A 202     -10.436  30.610 164.628  1.00 10.44           N  
ATOM   1228  CA  LEU A 202     -10.296  30.129 166.002  1.00 10.49           C  
ATOM   1229  C   LEU A 202     -11.625  30.149 166.739  1.00 10.80           C  
ATOM   1230  O   LEU A 202     -12.466  31.023 166.521  1.00 11.83           O  
ATOM   1231  CB  LEU A 202      -9.280  30.983 166.780  1.00 10.94           C  
ATOM   1232  CG  LEU A 202      -7.809  30.779 166.384  1.00 10.49           C  
ATOM   1233  CD1 LEU A 202      -7.057  31.964 166.924  1.00 13.05           C  
ATOM   1234  CD2 LEU A 202      -7.230  29.445 166.913  1.00 12.46           C  
ATOM   1235  N   ARG A 203     -11.787  29.178 167.628  1.00 11.52           N  
ATOM   1236  CA  ARG A 203     -12.896  29.147 168.575  1.00 11.32           C  
ATOM   1237  C   ARG A 203     -12.627  30.136 169.702  1.00 11.60           C  
ATOM   1238  O   ARG A 203     -11.462  30.512 169.915  1.00 12.85           O  
ATOM   1239  CB  ARG A 203     -13.013  27.733 169.166  1.00 10.93           C  
ATOM   1240  CG  ARG A 203     -11.764  27.213 169.888  1.00  9.99           C  
ATOM   1241  CD  ARG A 203     -12.149  26.070 170.871  1.00 10.74           C  
ATOM   1242  NE  ARG A 203     -11.019  25.464 171.572  1.00 12.08           N  
ATOM   1243  CZ  ARG A 203     -10.563  25.822 172.783  1.00 12.85           C  
ATOM   1244  NH1 ARG A 203     -11.083  26.857 173.448  1.00 10.89           N  
ATOM   1245  NH2 ARG A 203      -9.553  25.129 173.328  1.00 11.78           N  
ATOM   1246  N   PRO A 204     -13.689  30.541 170.443  1.00 12.90           N  
ATOM   1247  CA  PRO A 204     -13.463  31.203 171.729  1.00 12.80           C  
ATOM   1248  C   PRO A 204     -12.498  30.342 172.550  1.00 12.39           C  
ATOM   1249  O   PRO A 204     -12.645  29.115 172.592  1.00 13.12           O  
ATOM   1250  CB  PRO A 204     -14.856  31.231 172.386  1.00 13.43           C  
ATOM   1251  CG  PRO A 204     -15.808  31.182 171.242  1.00 13.76           C  
ATOM   1252  CD  PRO A 204     -15.127  30.380 170.141  1.00 12.76           C  
ATOM   1253  N   GLY A 205     -11.534  30.990 173.189  1.00 12.09           N  
ATOM   1254  CA  GLY A 205     -10.514  30.304 173.997  1.00 11.67           C  
ATOM   1255  C   GLY A 205      -9.340  29.776 173.167  1.00 11.21           C  
ATOM   1256  O   GLY A 205      -8.414  29.171 173.709  1.00 12.16           O  
ATOM   1257  N   GLY A 206      -9.393  29.969 171.846  1.00  9.95           N  
ATOM   1258  CA  GLY A 206      -8.293  29.581 170.981  1.00  9.59           C  
ATOM   1259  C   GLY A 206      -7.093  30.509 171.140  1.00  9.76           C  
ATOM   1260  O   GLY A 206      -7.202  31.639 171.654  1.00  9.40           O  
ATOM   1261  N   ILE A 207      -5.953  30.035 170.660  1.00  9.44           N  
ATOM   1262  CA  ILE A 207      -4.692  30.782 170.805  1.00  9.19           C  
ATOM   1263  C   ILE A 207      -4.159  31.200 169.428  1.00  9.65           C  
ATOM   1264  O   ILE A 207      -3.987  30.359 168.554  1.00  9.83           O  
ATOM   1265  CB  ILE A 207      -3.617  29.904 171.500  1.00  9.80           C  
ATOM   1266  CG1 ILE A 207      -4.102  29.474 172.892  1.00  9.13           C  
ATOM   1267  CG2 ILE A 207      -2.254  30.644 171.565  1.00 10.57           C  
ATOM   1268  CD1 ILE A 207      -3.135  28.545 173.604  1.00 11.28           C  
ATOM   1269  N   LEU A 208      -3.888  32.493 169.249  1.00  9.60           N  
ATOM   1270  CA  LEU A 208      -3.333  32.974 167.975  1.00  9.54           C  
ATOM   1271  C   LEU A 208      -1.936  33.488 168.296  1.00  9.79           C  
ATOM   1272  O   LEU A 208      -1.790  34.467 169.036  1.00  9.41           O  
ATOM   1273  CB  LEU A 208      -4.201  34.095 167.386  1.00  9.98           C  
ATOM   1274  CG  LEU A 208      -4.109  34.386 165.878  1.00 10.07           C  
ATOM   1275  CD1 LEU A 208      -5.262  35.326 165.497  1.00 11.93           C  
ATOM   1276  CD2 LEU A 208      -2.775  35.059 165.557  1.00 11.12           C  
ATOM   1277  N   ALA A 209      -0.935  32.800 167.776  1.00  9.89           N  
ATOM   1278  CA  ALA A 209       0.465  33.157 168.030  1.00  9.93           C  
ATOM   1279  C   ALA A 209       1.023  33.877 166.802  1.00  9.23           C  
ATOM   1280  O   ALA A 209       0.863  33.386 165.666  1.00 10.93           O  
ATOM   1281  CB  ALA A 209       1.290  31.922 168.340  1.00 10.02           C  
ATOM   1282  N   VAL A 210       1.658  35.033 167.014  1.00 10.18           N  
ATOM   1283  CA  VAL A 210       2.335  35.717 165.913  1.00 10.27           C  
ATOM   1284  C   VAL A 210       3.829  35.756 166.221  1.00 10.41           C  
ATOM   1285  O   VAL A 210       4.252  36.258 167.267  1.00 10.37           O  
ATOM   1286  CB  VAL A 210       1.807  37.160 165.639  1.00 10.56           C  
ATOM   1287  CG1 VAL A 210       2.405  37.697 164.335  1.00 11.81           C  
ATOM   1288  CG2 VAL A 210       0.298  37.185 165.596  1.00 10.86           C  
ATOM   1289  N   LEU A 211       4.622  35.221 165.301  1.00 11.14           N  
ATOM   1290  CA  LEU A 211       6.062  35.157 165.502  1.00 11.82           C  
ATOM   1291  C   LEU A 211       6.738  36.410 164.962  1.00 12.00           C  
ATOM   1292  O   LEU A 211       6.178  37.075 164.081  1.00 11.73           O  
ATOM   1293  CB  LEU A 211       6.599  33.933 164.769  1.00 12.27           C  
ATOM   1294  CG  LEU A 211       6.388  32.882 165.861  1.00 15.96           C  
ATOM   1295  CD1 LEU A 211       5.281  31.866 165.590  1.00 14.80           C  
ATOM   1296  CD2 LEU A 211       7.651  32.366 166.419  1.00 13.70           C  
ATOM   1297  N   ARG A 212       7.940  36.705 165.477  1.00 11.33           N  
ATOM   1298  CA  ARG A 212       8.812  37.738 164.888  1.00 12.88           C  
ATOM   1299  C   ARG A 212       8.099  39.092 164.834  1.00 12.26           C  
ATOM   1300  O   ARG A 212       8.082  39.759 163.793  1.00 11.62           O  
ATOM   1301  CB  ARG A 212       9.264  37.305 163.473  1.00 12.86           C  
ATOM   1302  CG  ARG A 212       9.984  35.952 163.457  1.00 14.39           C  
ATOM   1303  CD  ARG A 212      10.041  35.294 162.070  1.00 16.52           C  
ATOM   1304  NE  ARG A 212      10.575  33.912 162.076  1.00 22.30           N  
ATOM   1305  CZ  ARG A 212      10.136  32.913 162.848  1.00 24.04           C  
ATOM   1306  NH1 ARG A 212       9.159  33.121 163.728  1.00 28.28           N  
ATOM   1307  NH2 ARG A 212      10.661  31.697 162.764  1.00 15.22           N  
ATOM   1308  N   VAL A 213       7.532  39.501 165.970  1.00 11.14           N  
ATOM   1309  CA  VAL A 213       6.774  40.755 166.021  1.00 11.60           C  
ATOM   1310  C   VAL A 213       7.635  41.993 166.336  1.00 11.88           C  
ATOM   1311  O   VAL A 213       7.126  43.129 166.310  1.00 11.96           O  
ATOM   1312  CB  VAL A 213       5.555  40.677 167.015  1.00 10.87           C  
ATOM   1313  CG1 VAL A 213       4.547  39.572 166.587  1.00 11.93           C  
ATOM   1314  CG2 VAL A 213       6.047  40.462 168.477  1.00 12.18           C  
ATOM   1315  N   LEU A 214       8.904  41.789 166.694  1.00 12.86           N  
ATOM   1316  CA  LEU A 214       9.794  42.933 166.948  1.00 13.76           C  
ATOM   1317  C   LEU A 214      10.633  43.300 165.703  1.00 14.39           C  
ATOM   1318  O   LEU A 214      11.177  44.396 165.617  1.00 14.15           O  
ATOM   1319  CB  LEU A 214      10.678  42.690 168.170  1.00 13.62           C  
ATOM   1320  CG  LEU A 214       9.919  42.543 169.508  1.00 13.80           C  
ATOM   1321  CD1 LEU A 214      10.858  42.173 170.662  1.00 15.30           C  
ATOM   1322  CD2 LEU A 214       9.042  43.776 169.855  1.00 15.25           C  
ATOM   1323  N   TRP A 215      10.744  42.361 164.768  1.00 14.65           N  
ATOM   1324  CA  TRP A 215      11.431  42.553 163.477  1.00 15.25           C  
ATOM   1325  C   TRP A 215      12.834  43.156 163.639  1.00 15.79           C  
ATOM   1326  O   TRP A 215      13.180  44.188 162.998  1.00 15.39           O  
ATOM   1327  CB  TRP A 215      10.562  43.369 162.497  1.00 15.81           C  
ATOM   1328  CG  TRP A 215      10.796  43.041 161.073  1.00 16.98           C  
ATOM   1329  CD1 TRP A 215      11.230  43.895 160.089  1.00 19.19           C  
ATOM   1330  CD2 TRP A 215      10.623  41.757 160.445  1.00 17.99           C  
ATOM   1331  NE1 TRP A 215      11.326  43.219 158.889  1.00 19.47           N  
ATOM   1332  CE2 TRP A 215      10.970  41.906 159.084  1.00 18.93           C  
ATOM   1333  CE3 TRP A 215      10.215  40.491 160.910  1.00 16.54           C  
ATOM   1334  CZ2 TRP A 215      10.918  40.830 158.166  1.00 19.19           C  
ATOM   1335  CZ3 TRP A 215      10.184  39.411 159.998  1.00 17.24           C  
ATOM   1336  CH2 TRP A 215      10.514  39.600 158.641  1.00 18.11           C  
ATOM   1337  N   ARG A 216      13.619  42.508 164.501  1.00 16.36           N  
ATOM   1338  CA  ARG A 216      14.991  42.914 164.836  1.00 18.32           C  
ATOM   1339  C   ARG A 216      15.087  44.377 165.276  1.00 18.13           C  
ATOM   1340  O   ARG A 216      16.083  45.065 164.992  1.00 18.39           O  
ATOM   1341  CB  ARG A 216      15.936  42.654 163.662  1.00 19.18           C  
ATOM   1342  CG  ARG A 216      16.129  41.198 163.267  1.00 24.49           C  
ATOM   1343  CD  ARG A 216      17.226  41.175 162.177  1.00 32.11           C  
ATOM   1344  NE  ARG A 216      17.274  39.932 161.407  1.00 38.40           N  
ATOM   1345  CZ  ARG A 216      18.374  39.450 160.820  1.00 41.03           C  
ATOM   1346  NH1 ARG A 216      19.540  40.088 160.915  1.00 41.92           N  
ATOM   1347  NH2 ARG A 216      18.312  38.308 160.149  1.00 41.85           N  
ATOM   1348  N   GLY A 217      14.044  44.858 165.946  1.00 17.71           N  
ATOM   1349  CA  GLY A 217      14.006  46.243 166.424  1.00 17.76           C  
ATOM   1350  C   GLY A 217      13.529  47.287 165.429  1.00 18.28           C  
ATOM   1351  O   GLY A 217      13.345  48.454 165.788  1.00 17.88           O  
ATOM   1352  N   LYS A 218      13.304  46.883 164.182  1.00 18.07           N  
ATOM   1353  CA  LYS A 218      12.850  47.831 163.154  1.00 18.94           C  
ATOM   1354  C   LYS A 218      11.429  48.371 163.404  1.00 18.33           C  
ATOM   1355  O   LYS A 218      11.025  49.391 162.819  1.00 18.59           O  
ATOM   1356  CB  LYS A 218      12.951  47.217 161.760  1.00 18.92           C  
ATOM   1357  CG  LYS A 218      14.376  46.893 161.327  1.00 21.87           C  
ATOM   1358  CD  LYS A 218      14.334  46.428 159.883  1.00 25.36           C  
ATOM   1359  CE  LYS A 218      15.685  45.944 159.391  1.00 28.12           C  
ATOM   1360  NZ  LYS A 218      15.609  45.717 157.910  1.00 28.41           N  
ATOM   1361  N   VAL A 219      10.669  47.703 164.279  1.00 18.69           N  
ATOM   1362  CA  VAL A 219       9.341  48.213 164.650  1.00 19.21           C  
ATOM   1363  C   VAL A 219       9.436  49.588 165.323  1.00 19.95           C  
ATOM   1364  O   VAL A 219       8.485  50.365 165.279  1.00 20.12           O  
ATOM   1365  CB  VAL A 219       8.550  47.233 165.566  1.00 19.45           C  
ATOM   1366  CG1 VAL A 219       8.196  45.976 164.800  1.00 19.44           C  
ATOM   1367  CG2 VAL A 219       9.343  46.903 166.831  1.00 18.85           C  
ATOM   1368  N   LEU A 220      10.581  49.868 165.940  1.00 21.24           N  
ATOM   1369  CA  LEU A 220      10.799  51.137 166.655  1.00 23.10           C  
ATOM   1370  C   LEU A 220      10.715  52.354 165.734  1.00 24.91           C  
ATOM   1371  O   LEU A 220      10.134  53.379 166.102  1.00 25.40           O  
ATOM   1372  CB  LEU A 220      12.130  51.113 167.421  1.00 22.86           C  
ATOM   1373  CG  LEU A 220      12.098  50.163 168.629  1.00 22.75           C  
ATOM   1374  CD1 LEU A 220      13.470  50.002 169.328  1.00 22.85           C  
ATOM   1375  CD2 LEU A 220      11.033  50.580 169.630  1.00 23.26           C  
ATOM   1376  N   GLN A 221      11.290  52.215 164.541  1.00 25.89           N  
ATOM   1377  CA  GLN A 221      11.289  53.243 163.503  1.00 28.53           C  
ATOM   1378  C   GLN A 221      11.568  52.518 162.182  1.00 27.78           C  
ATOM   1379  O   GLN A 221      12.731  52.367 161.804  1.00 27.94           O  
ATOM   1380  CB  GLN A 221      12.381  54.296 163.773  1.00 28.13           C  
ATOM   1381  CG  GLN A 221      11.952  55.444 164.689  1.00 31.39           C  
ATOM   1382  CD  GLN A 221      13.098  56.390 165.035  1.00 31.95           C  
ATOM   1383  OE1 GLN A 221      13.488  57.237 164.223  1.00 37.04           O  
ATOM   1384  NE2 GLN A 221      13.642  56.248 166.252  1.00 35.98           N  
ATOM   1385  N   PRO A 222      10.511  52.023 161.503  1.00 28.16           N  
ATOM   1386  CA  PRO A 222      10.716  51.271 160.255  1.00 28.37           C  
ATOM   1387  C   PRO A 222      11.437  52.130 159.205  1.00 28.70           C  
ATOM   1388  O   PRO A 222      11.011  53.266 158.950  1.00 28.74           O  
ATOM   1389  CB  PRO A 222       9.288  50.932 159.806  1.00 28.31           C  
ATOM   1390  CG  PRO A 222       8.465  51.016 161.057  1.00 28.99           C  
ATOM   1391  CD  PRO A 222       9.080  52.118 161.856  1.00 28.32           C  
ATOM   1392  N   PRO A 223      12.556  51.626 158.638  1.00 28.92           N  
ATOM   1393  CA  PRO A 223      13.246  52.442 157.616  1.00 29.00           C  
ATOM   1394  C   PRO A 223      12.348  52.742 156.417  1.00 28.84           C  
ATOM   1395  O   PRO A 223      11.394  52.004 156.157  1.00 28.35           O  
ATOM   1396  CB  PRO A 223      14.435  51.566 157.195  1.00 28.98           C  
ATOM   1397  CG  PRO A 223      14.654  50.625 158.379  1.00 29.42           C  
ATOM   1398  CD  PRO A 223      13.259  50.351 158.894  1.00 28.95           C  
ATOM   1399  N   LYS A 224      12.657  53.819 155.693  1.00 28.94           N  
ATOM   1400  CA  LYS A 224      11.894  54.186 154.494  1.00 29.23           C  
ATOM   1401  C   LYS A 224      11.942  53.059 153.472  1.00 28.31           C  
ATOM   1402  O   LYS A 224      13.006  52.487 153.221  1.00 28.30           O  
ATOM   1403  CB  LYS A 224      12.411  55.500 153.878  1.00 29.21           C  
ATOM   1404  CG  LYS A 224      11.625  55.946 152.639  1.00 29.90           C  
ATOM   1405  CD  LYS A 224      12.180  57.240 152.032  1.00 31.59           C  
ATOM   1406  CE  LYS A 224      11.539  58.489 152.669  1.00 34.99           C  
ATOM   1407  NZ  LYS A 224      12.235  59.764 152.249  1.00 36.60           N  
ATOM   1408  N   GLY A 225      10.782  52.738 152.905  1.00 27.97           N  
ATOM   1409  CA  GLY A 225      10.662  51.685 151.905  1.00 27.21           C  
ATOM   1410  C   GLY A 225      10.724  50.277 152.470  1.00 26.92           C  
ATOM   1411  O   GLY A 225      10.680  49.306 151.711  1.00 26.64           O  
ATOM   1412  N   ASP A 226      10.818  50.160 153.798  1.00 26.66           N  
ATOM   1413  CA  ASP A 226      10.842  48.854 154.460  1.00 25.81           C  
ATOM   1414  C   ASP A 226       9.399  48.405 154.718  1.00 25.68           C  
ATOM   1415  O   ASP A 226       8.844  48.611 155.808  1.00 25.14           O  
ATOM   1416  CB  ASP A 226      11.685  48.898 155.746  1.00 25.64           C  
ATOM   1417  CG  ASP A 226      12.031  47.510 156.275  1.00 25.86           C  
ATOM   1418  OD1 ASP A 226      11.296  46.540 155.969  1.00 24.08           O  
ATOM   1419  OD2 ASP A 226      13.054  47.396 156.993  1.00 25.09           O  
ATOM   1420  N   VAL A 227       8.810  47.794 153.690  1.00 24.79           N  
ATOM   1421  CA  VAL A 227       7.408  47.381 153.693  1.00 24.38           C  
ATOM   1422  C   VAL A 227       7.108  46.319 154.763  1.00 23.69           C  
ATOM   1423  O   VAL A 227       6.074  46.402 155.438  1.00 24.26           O  
ATOM   1424  CB  VAL A 227       6.942  46.937 152.267  1.00 24.69           C  
ATOM   1425  CG1 VAL A 227       5.541  46.316 152.288  1.00 24.94           C  
ATOM   1426  CG2 VAL A 227       6.967  48.138 151.331  1.00 24.20           C  
ATOM   1427  N   ALA A 228       8.006  45.347 154.935  1.00 23.07           N  
ATOM   1428  CA  ALA A 228       7.792  44.295 155.942  1.00 22.28           C  
ATOM   1429  C   ALA A 228       7.775  44.880 157.356  1.00 21.67           C  
ATOM   1430  O   ALA A 228       6.849  44.606 158.141  1.00 21.29           O  
ATOM   1431  CB  ALA A 228       8.836  43.168 155.819  1.00 22.18           C  
ATOM   1432  N   ALA A 229       8.773  45.704 157.671  1.00 21.39           N  
ATOM   1433  CA  ALA A 229       8.837  46.396 158.974  1.00 21.10           C  
ATOM   1434  C   ALA A 229       7.579  47.226 159.288  1.00 20.85           C  
ATOM   1435  O   ALA A 229       7.071  47.201 160.414  1.00 19.61           O  
ATOM   1436  CB  ALA A 229      10.094  47.254 159.064  1.00 21.60           C  
ATOM   1437  N   GLU A 230       7.077  47.945 158.283  1.00 20.83           N  
ATOM   1438  CA  GLU A 230       5.812  48.674 158.386  1.00 20.89           C  
ATOM   1439  C   GLU A 230       4.612  47.738 158.621  1.00 19.19           C  
ATOM   1440  O   GLU A 230       3.736  48.018 159.438  1.00 17.55           O  
ATOM   1441  CB  GLU A 230       5.598  49.541 157.132  1.00 21.54           C  
ATOM   1442  CG  GLU A 230       6.645  50.649 156.999  1.00 23.67           C  
ATOM   1443  CD  GLU A 230       6.612  51.377 155.662  1.00 24.93           C  
ATOM   1444  OE1 GLU A 230       6.068  50.826 154.671  1.00 28.93           O  
ATOM   1445  OE2 GLU A 230       7.167  52.504 155.612  1.00 30.79           O  
ATOM   1446  N   CYS A 231       4.588  46.611 157.912  1.00 17.66           N  
ATOM   1447  CA  CYS A 231       3.552  45.604 158.156  1.00 16.92           C  
ATOM   1448  C   CYS A 231       3.564  45.072 159.608  1.00 15.08           C  
ATOM   1449  O   CYS A 231       2.507  44.974 160.251  1.00 14.78           O  
ATOM   1450  CB  CYS A 231       3.682  44.474 157.152  1.00 16.85           C  
ATOM   1451  SG  CYS A 231       3.122  44.967 155.498  1.00 19.93           S  
ATOM   1452  N   VAL A 232       4.753  44.761 160.121  1.00 14.42           N  
ATOM   1453  CA  VAL A 232       4.890  44.269 161.502  1.00 15.06           C  
ATOM   1454  C   VAL A 232       4.401  45.338 162.492  1.00 15.07           C  
ATOM   1455  O   VAL A 232       3.563  45.074 163.369  1.00 15.06           O  
ATOM   1456  CB  VAL A 232       6.342  43.839 161.794  1.00 14.39           C  
ATOM   1457  CG1 VAL A 232       6.499  43.392 163.258  1.00 12.95           C  
ATOM   1458  CG2 VAL A 232       6.761  42.736 160.809  1.00 15.15           C  
ATOM   1459  N   ARG A 233       4.908  46.559 162.318  1.00 15.67           N  
ATOM   1460  CA  ARG A 233       4.514  47.676 163.165  1.00 16.84           C  
ATOM   1461  C   ARG A 233       2.974  47.878 163.172  1.00 16.22           C  
ATOM   1462  O   ARG A 233       2.336  48.001 164.236  1.00 16.09           O  
ATOM   1463  CB  ARG A 233       5.266  48.958 162.728  1.00 16.61           C  
ATOM   1464  CG  ARG A 233       4.929  50.176 163.599  1.00 21.53           C  
ATOM   1465  CD  ARG A 233       4.955  51.480 162.797  1.00 29.37           C  
ATOM   1466  NE  ARG A 233       4.276  51.376 161.498  1.00 32.58           N  
ATOM   1467  CZ  ARG A 233       4.708  51.976 160.389  1.00 34.96           C  
ATOM   1468  NH1 ARG A 233       5.806  52.719 160.436  1.00 36.49           N  
ATOM   1469  NH2 ARG A 233       4.060  51.836 159.237  1.00 33.00           N  
ATOM   1470  N   ASN A 234       2.375  47.898 161.982  1.00 16.48           N  
ATOM   1471  CA  ASN A 234       0.935  48.099 161.866  1.00 16.13           C  
ATOM   1472  C   ASN A 234       0.115  47.024 162.595  1.00 14.64           C  
ATOM   1473  O   ASN A 234      -0.808  47.329 163.336  1.00 14.16           O  
ATOM   1474  CB  ASN A 234       0.523  48.191 160.389  1.00 16.74           C  
ATOM   1475  CG  ASN A 234       1.111  49.424 159.683  1.00 20.05           C  
ATOM   1476  OD1 ASN A 234       1.677  50.325 160.318  1.00 21.35           O  
ATOM   1477  ND2 ASN A 234       1.001  49.448 158.358  1.00 22.98           N  
ATOM   1478  N   LEU A 235       0.495  45.767 162.408  1.00 13.17           N  
ATOM   1479  CA  LEU A 235      -0.220  44.690 163.095  1.00 12.46           C  
ATOM   1480  C   LEU A 235      -0.128  44.809 164.619  1.00 11.05           C  
ATOM   1481  O   LEU A 235      -1.107  44.568 165.318  1.00 11.05           O  
ATOM   1482  CB  LEU A 235       0.218  43.321 162.580  1.00 11.83           C  
ATOM   1483  CG  LEU A 235      -0.509  42.094 163.186  1.00 13.14           C  
ATOM   1484  CD1 LEU A 235      -2.052  42.218 163.137  1.00 12.48           C  
ATOM   1485  CD2 LEU A 235      -0.042  40.754 162.573  1.00 12.03           C  
ATOM   1486  N   ASN A 236       1.054  45.135 165.131  1.00 11.61           N  
ATOM   1487  CA  ASN A 236       1.227  45.335 166.570  1.00 11.82           C  
ATOM   1488  C   ASN A 236       0.269  46.380 167.157  1.00 11.99           C  
ATOM   1489  O   ASN A 236      -0.315  46.164 168.210  1.00 11.37           O  
ATOM   1490  CB  ASN A 236       2.678  45.677 166.895  1.00 11.93           C  
ATOM   1491  CG  ASN A 236       3.610  44.472 166.753  1.00 11.52           C  
ATOM   1492  OD1 ASN A 236       3.163  43.308 166.702  1.00 10.33           O  
ATOM   1493  ND2 ASN A 236       4.901  44.744 166.677  1.00 11.78           N  
ATOM   1494  N   GLU A 237       0.077  47.487 166.436  1.00 11.70           N  
ATOM   1495  CA  GLU A 237      -0.876  48.510 166.865  1.00 12.05           C  
ATOM   1496  C   GLU A 237      -2.325  47.997 166.859  1.00 12.46           C  
ATOM   1497  O   GLU A 237      -3.095  48.324 167.759  1.00 12.30           O  
ATOM   1498  CB  GLU A 237      -0.700  49.798 166.032  1.00 12.26           C  
ATOM   1499  CG  GLU A 237       0.684  50.461 166.249  1.00 13.36           C  
ATOM   1500  CD  GLU A 237       1.071  50.588 167.716  1.00 16.19           C  
ATOM   1501  OE1 GLU A 237       0.267  51.100 168.531  1.00 14.08           O  
ATOM   1502  OE2 GLU A 237       2.201  50.163 168.066  1.00 16.47           O  
ATOM   1503  N   ARG A 238      -2.686  47.187 165.858  1.00 12.57           N  
ATOM   1504  CA  ARG A 238      -4.024  46.615 165.798  1.00 12.32           C  
ATOM   1505  C   ARG A 238      -4.252  45.631 166.947  1.00 11.87           C  
ATOM   1506  O   ARG A 238      -5.252  45.724 167.645  1.00 10.83           O  
ATOM   1507  CB  ARG A 238      -4.288  45.912 164.475  1.00 12.28           C  
ATOM   1508  CG  ARG A 238      -5.668  45.213 164.461  1.00 13.87           C  
ATOM   1509  CD  ARG A 238      -5.944  44.537 163.137  1.00 18.62           C  
ATOM   1510  NE  ARG A 238      -5.998  45.520 162.069  1.00 24.34           N  
ATOM   1511  CZ  ARG A 238      -6.576  45.314 160.892  1.00 28.09           C  
ATOM   1512  NH1 ARG A 238      -7.159  44.144 160.632  1.00 29.65           N  
ATOM   1513  NH2 ARG A 238      -6.569  46.275 159.973  1.00 28.05           N  
ATOM   1514  N   ILE A 239      -3.314  44.696 167.135  1.00 10.30           N  
ATOM   1515  CA  ILE A 239      -3.444  43.727 168.233  1.00 11.47           C  
ATOM   1516  C   ILE A 239      -3.522  44.419 169.614  1.00 11.87           C  
ATOM   1517  O   ILE A 239      -4.376  44.095 170.444  1.00 11.88           O  
ATOM   1518  CB  ILE A 239      -2.307  42.692 168.172  1.00 11.27           C  
ATOM   1519  CG1 ILE A 239      -2.422  41.833 166.893  1.00 12.88           C  
ATOM   1520  CG2 ILE A 239      -2.256  41.857 169.469  1.00 11.69           C  
ATOM   1521  CD1 ILE A 239      -1.215  40.850 166.679  1.00 12.03           C  
ATOM   1522  N   ARG A 240      -2.633  45.382 169.833  1.00 11.53           N  
ATOM   1523  CA  ARG A 240      -2.596  46.189 171.063  1.00 11.62           C  
ATOM   1524  C   ARG A 240      -4.004  46.698 171.421  1.00 11.09           C  
ATOM   1525  O   ARG A 240      -4.434  46.593 172.569  1.00 10.20           O  
ATOM   1526  CB  ARG A 240      -1.629  47.364 170.864  1.00 11.15           C  
ATOM   1527  CG  ARG A 240      -1.618  48.395 171.975  1.00 11.32           C  
ATOM   1528  CD  ARG A 240      -0.901  49.648 171.501  1.00 10.83           C  
ATOM   1529  NE  ARG A 240      -0.637  50.555 172.609  1.00 10.62           N  
ATOM   1530  CZ  ARG A 240       0.176  51.609 172.541  1.00  9.22           C  
ATOM   1531  NH1 ARG A 240       0.778  51.923 171.391  1.00 10.24           N  
ATOM   1532  NH2 ARG A 240       0.352  52.362 173.618  1.00 11.15           N  
ATOM   1533  N   ARG A 241      -4.721  47.185 170.405  1.00 11.72           N  
ATOM   1534  CA  ARG A 241      -6.052  47.795 170.583  1.00 13.01           C  
ATOM   1535  C   ARG A 241      -7.231  46.819 170.521  1.00 13.74           C  
ATOM   1536  O   ARG A 241      -8.400  47.211 170.754  1.00 13.84           O  
ATOM   1537  CB  ARG A 241      -6.243  48.848 169.504  1.00 12.76           C  
ATOM   1538  CG  ARG A 241      -5.429  50.101 169.744  1.00 14.24           C  
ATOM   1539  CD  ARG A 241      -5.404  50.956 168.492  1.00 13.74           C  
ATOM   1540  NE  ARG A 241      -4.669  52.210 168.689  1.00 15.37           N  
ATOM   1541  CZ  ARG A 241      -3.336  52.327 168.697  1.00 16.02           C  
ATOM   1542  NH1 ARG A 241      -2.551  51.248 168.508  1.00 16.18           N  
ATOM   1543  NH2 ARG A 241      -2.789  53.535 168.870  1.00 15.10           N  
ATOM   1544  N   ASP A 242      -6.926  45.559 170.197  1.00 12.76           N  
ATOM   1545  CA  ASP A 242      -7.940  44.610 169.773  1.00 12.83           C  
ATOM   1546  C   ASP A 242      -8.737  44.095 170.974  1.00 13.03           C  
ATOM   1547  O   ASP A 242      -8.215  43.331 171.795  1.00 13.04           O  
ATOM   1548  CB  ASP A 242      -7.320  43.446 168.968  1.00 12.25           C  
ATOM   1549  CG  ASP A 242      -8.373  42.614 168.220  1.00 13.18           C  
ATOM   1550  OD1 ASP A 242      -9.593  42.882 168.404  1.00 13.78           O  
ATOM   1551  OD2 ASP A 242      -7.983  41.705 167.427  1.00 11.93           O  
ATOM   1552  N   VAL A 243     -10.016  44.484 171.044  1.00 13.09           N  
ATOM   1553  CA  VAL A 243     -10.891  44.013 172.148  1.00 14.09           C  
ATOM   1554  C   VAL A 243     -11.336  42.543 172.027  1.00 13.75           C  
ATOM   1555  O   VAL A 243     -11.867  41.979 172.983  1.00 12.92           O  
ATOM   1556  CB  VAL A 243     -12.134  44.932 172.367  1.00 15.68           C  
ATOM   1557  CG1 VAL A 243     -11.681  46.372 172.672  1.00 16.50           C  
ATOM   1558  CG2 VAL A 243     -13.059  44.885 171.151  1.00 17.39           C  
ATOM   1559  N   ARG A 244     -11.144  41.943 170.857  1.00 12.48           N  
ATOM   1560  CA  ARG A 244     -11.562  40.548 170.637  1.00 12.70           C  
ATOM   1561  C   ARG A 244     -10.649  39.524 171.317  1.00 12.54           C  
ATOM   1562  O   ARG A 244     -10.975  38.328 171.356  1.00 12.46           O  
ATOM   1563  CB  ARG A 244     -11.608  40.234 169.148  1.00 12.62           C  
ATOM   1564  CG  ARG A 244     -12.650  41.044 168.379  1.00 14.03           C  
ATOM   1565  CD  ARG A 244     -12.430  40.918 166.874  1.00 13.54           C  
ATOM   1566  NE  ARG A 244     -11.142  41.464 166.445  1.00 14.62           N  
ATOM   1567  CZ  ARG A 244     -10.721  41.505 165.181  1.00 16.97           C  
ATOM   1568  NH1 ARG A 244     -11.511  41.080 164.188  1.00 15.48           N  
ATOM   1569  NH2 ARG A 244      -9.519  42.016 164.906  1.00 16.04           N  
ATOM   1570  N   VAL A 245      -9.512  39.994 171.825  1.00 11.93           N  
ATOM   1571  CA  VAL A 245      -8.497  39.108 172.390  1.00 12.14           C  
ATOM   1572  C   VAL A 245      -7.932  39.695 173.691  1.00 11.93           C  
ATOM   1573  O   VAL A 245      -8.092  40.890 173.966  1.00 12.19           O  
ATOM   1574  CB  VAL A 245      -7.296  38.903 171.414  1.00 12.40           C  
ATOM   1575  CG1 VAL A 245      -7.705  38.050 170.208  1.00 12.44           C  
ATOM   1576  CG2 VAL A 245      -6.696  40.268 170.970  1.00 12.73           C  
ATOM   1577  N   TYR A 246      -7.264  38.853 174.475  1.00 11.55           N  
ATOM   1578  CA  TYR A 246      -6.402  39.342 175.564  1.00 11.69           C  
ATOM   1579  C   TYR A 246      -5.017  38.811 175.202  1.00 11.55           C  
ATOM   1580  O   TYR A 246      -4.912  37.733 174.608  1.00 11.83           O  
ATOM   1581  CB  TYR A 246      -6.855  38.910 176.965  1.00 12.45           C  
ATOM   1582  CG  TYR A 246      -7.358  37.484 177.102  1.00 13.46           C  
ATOM   1583  CD1 TYR A 246      -6.621  36.521 177.806  1.00 16.02           C  
ATOM   1584  CD2 TYR A 246      -8.602  37.114 176.575  1.00 13.92           C  
ATOM   1585  CE1 TYR A 246      -7.091  35.214 177.951  1.00 13.97           C  
ATOM   1586  CE2 TYR A 246      -9.087  35.804 176.695  1.00 14.57           C  
ATOM   1587  CZ  TYR A 246      -8.317  34.855 177.391  1.00 14.40           C  
ATOM   1588  OH  TYR A 246      -8.786  33.568 177.510  1.00 15.52           O  
ATOM   1589  N   ILE A 247      -3.977  39.562 175.544  1.00 10.66           N  
ATOM   1590  CA  ILE A 247      -2.690  39.400 174.854  1.00 11.19           C  
ATOM   1591  C   ILE A 247      -1.490  39.433 175.803  1.00 10.51           C  
ATOM   1592  O   ILE A 247      -1.523  40.080 176.860  1.00  9.62           O  
ATOM   1593  CB  ILE A 247      -2.483  40.496 173.725  1.00 10.95           C  
ATOM   1594  CG1 ILE A 247      -2.253  41.903 174.324  1.00 11.25           C  
ATOM   1595  CG2 ILE A 247      -3.647  40.503 172.700  1.00  9.73           C  
ATOM   1596  CD1 ILE A 247      -1.871  42.993 173.279  1.00 13.37           C  
ATOM   1597  N   SER A 248      -0.451  38.714 175.397  1.00 10.18           N  
ATOM   1598  CA  SER A 248       0.895  38.799 175.974  1.00 10.90           C  
ATOM   1599  C   SER A 248       1.900  38.858 174.820  1.00 11.24           C  
ATOM   1600  O   SER A 248       1.746  38.146 173.807  1.00 12.53           O  
ATOM   1601  CB  SER A 248       1.191  37.581 176.865  1.00 10.42           C  
ATOM   1602  OG  SER A 248       0.463  37.643 178.098  1.00 13.45           O  
ATOM   1603  N   LEU A 249       2.899  39.710 174.985  1.00 10.50           N  
ATOM   1604  CA  LEU A 249       4.025  39.774 174.092  1.00 10.81           C  
ATOM   1605  C   LEU A 249       5.239  39.357 174.922  1.00 11.45           C  
ATOM   1606  O   LEU A 249       5.551  39.961 175.957  1.00 10.47           O  
ATOM   1607  CB  LEU A 249       4.172  41.192 173.508  1.00 11.22           C  
ATOM   1608  CG  LEU A 249       4.897  41.355 172.165  1.00 14.85           C  
ATOM   1609  CD1 LEU A 249       4.566  42.749 171.543  1.00 16.35           C  
ATOM   1610  CD2 LEU A 249       6.423  41.133 172.246  1.00 15.97           C  
ATOM   1611  N   LEU A 250       5.940  38.346 174.425  1.00 11.31           N  
ATOM   1612  CA  LEU A 250       7.016  37.686 175.149  1.00 11.48           C  
ATOM   1613  C   LEU A 250       8.348  37.878 174.432  1.00 12.07           C  
ATOM   1614  O   LEU A 250       8.384  37.892 173.195  1.00 12.95           O  
ATOM   1615  CB  LEU A 250       6.738  36.181 175.291  1.00 11.76           C  
ATOM   1616  CG  LEU A 250       5.429  35.765 175.971  1.00 12.69           C  
ATOM   1617  CD1 LEU A 250       5.322  34.256 176.075  1.00 12.97           C  
ATOM   1618  CD2 LEU A 250       5.292  36.441 177.333  1.00 12.89           C  
ATOM   1619  N   PRO A 251       9.433  38.052 175.215  1.00 12.50           N  
ATOM   1620  CA  PRO A 251      10.780  38.282 174.667  1.00 13.28           C  
ATOM   1621  C   PRO A 251      11.450  36.947 174.310  1.00 14.35           C  
ATOM   1622  O   PRO A 251      12.487  36.580 174.895  1.00 17.94           O  
ATOM   1623  CB  PRO A 251      11.510  38.943 175.842  1.00 12.66           C  
ATOM   1624  CG  PRO A 251      10.866  38.286 177.083  1.00 12.95           C  
ATOM   1625  CD  PRO A 251       9.416  38.097 176.693  1.00 12.38           C  
ATOM   1626  N   LEU A 252      10.808  36.179 173.449  1.00 13.41           N  
ATOM   1627  CA  LEU A 252      11.405  34.971 172.885  1.00 13.55           C  
ATOM   1628  C   LEU A 252      11.678  35.226 171.420  1.00 13.98           C  
ATOM   1629  O   LEU A 252      10.931  35.952 170.764  1.00 13.27           O  
ATOM   1630  CB  LEU A 252      10.444  33.782 173.010  1.00 12.20           C  
ATOM   1631  CG  LEU A 252      10.162  33.247 174.413  1.00 12.82           C  
ATOM   1632  CD1 LEU A 252       9.123  32.120 174.300  1.00 12.48           C  
ATOM   1633  CD2 LEU A 252      11.475  32.699 175.007  1.00 13.26           C  
ATOM   1634  N   GLY A 253      12.745  34.611 170.904  1.00 14.76           N  
ATOM   1635  CA  GLY A 253      13.118  34.749 169.495  1.00 15.35           C  
ATOM   1636  C   GLY A 253      13.221  36.211 169.093  1.00 15.06           C  
ATOM   1637  O   GLY A 253      13.974  36.979 169.714  1.00 16.19           O  
ATOM   1638  N   ASP A 254      12.435  36.586 168.089  1.00 14.10           N  
ATOM   1639  CA  ASP A 254      12.348  37.979 167.604  1.00 14.01           C  
ATOM   1640  C   ASP A 254      11.018  38.596 168.064  1.00 13.25           C  
ATOM   1641  O   ASP A 254      10.393  39.407 167.344  1.00 13.48           O  
ATOM   1642  CB  ASP A 254      12.469  38.022 166.076  1.00 14.43           C  
ATOM   1643  CG  ASP A 254      12.484  39.450 165.522  1.00 15.81           C  
ATOM   1644  OD1 ASP A 254      13.014  40.365 166.201  1.00 17.71           O  
ATOM   1645  OD2 ASP A 254      11.937  39.651 164.419  1.00 17.65           O  
ATOM   1646  N   GLY A 255      10.612  38.209 169.272  1.00 11.52           N  
ATOM   1647  CA  GLY A 255       9.325  38.649 169.880  1.00 10.54           C  
ATOM   1648  C   GLY A 255       8.193  37.711 169.485  1.00 10.83           C  
ATOM   1649  O   GLY A 255       8.027  37.363 168.302  1.00  9.66           O  
ATOM   1650  N   LEU A 256       7.393  37.322 170.478  1.00 10.71           N  
ATOM   1651  CA  LEU A 256       6.277  36.398 170.248  1.00 10.39           C  
ATOM   1652  C   LEU A 256       5.023  36.967 170.882  1.00 10.86           C  
ATOM   1653  O   LEU A 256       5.010  37.177 172.093  1.00 10.78           O  
ATOM   1654  CB  LEU A 256       6.599  35.040 170.903  1.00 10.70           C  
ATOM   1655  CG  LEU A 256       5.477  33.976 170.913  1.00 10.29           C  
ATOM   1656  CD1 LEU A 256       5.137  33.534 169.477  1.00 11.00           C  
ATOM   1657  CD2 LEU A 256       5.873  32.745 171.782  1.00 11.79           C  
ATOM   1658  N   THR A 257       3.985  37.193 170.076  1.00 10.52           N  
ATOM   1659  CA  THR A 257       2.678  37.627 170.589  1.00  9.99           C  
ATOM   1660  C   THR A 257       1.758  36.425 170.728  1.00  9.63           C  
ATOM   1661  O   THR A 257       1.647  35.622 169.798  1.00  9.56           O  
ATOM   1662  CB  THR A 257       2.053  38.716 169.671  1.00 10.65           C  
ATOM   1663  OG1 THR A 257       2.863  39.891 169.793  1.00 10.55           O  
ATOM   1664  CG2 THR A 257       0.608  39.037 170.084  1.00 11.17           C  
ATOM   1665  N   LEU A 258       1.132  36.311 171.896  1.00 10.04           N  
ATOM   1666  CA  LEU A 258       0.106  35.325 172.128  1.00  9.99           C  
ATOM   1667  C   LEU A 258      -1.187  36.116 172.302  1.00 10.00           C  
ATOM   1668  O   LEU A 258      -1.288  36.962 173.202  1.00 10.77           O  
ATOM   1669  CB  LEU A 258       0.396  34.501 173.394  1.00 10.58           C  
ATOM   1670  CG  LEU A 258       1.694  33.649 173.351  1.00 11.20           C  
ATOM   1671  CD1 LEU A 258       1.913  33.010 174.713  1.00 13.46           C  
ATOM   1672  CD2 LEU A 258       1.632  32.589 172.244  1.00 11.73           C  
ATOM   1673  N   ALA A 259      -2.148  35.850 171.439  1.00  9.59           N  
ATOM   1674  CA  ALA A 259      -3.446  36.508 171.527  1.00  9.68           C  
ATOM   1675  C   ALA A 259      -4.481  35.417 171.816  1.00 10.07           C  
ATOM   1676  O   ALA A 259      -4.620  34.481 171.038  1.00 10.68           O  
ATOM   1677  CB  ALA A 259      -3.762  37.247 170.222  1.00 10.18           C  
ATOM   1678  N   PHE A 260      -5.166  35.540 172.951  1.00 10.71           N  
ATOM   1679  CA  PHE A 260      -6.179  34.569 173.390  1.00 10.48           C  
ATOM   1680  C   PHE A 260      -7.574  35.085 172.975  1.00 10.75           C  
ATOM   1681  O   PHE A 260      -7.960  36.193 173.326  1.00 11.05           O  
ATOM   1682  CB  PHE A 260      -6.062  34.381 174.901  1.00 10.86           C  
ATOM   1683  CG  PHE A 260      -4.654  34.020 175.340  1.00 11.70           C  
ATOM   1684  CD1 PHE A 260      -4.168  32.750 175.122  1.00 13.14           C  
ATOM   1685  CD2 PHE A 260      -3.815  34.977 175.905  1.00 11.22           C  
ATOM   1686  CE1 PHE A 260      -2.854  32.393 175.492  1.00 11.62           C  
ATOM   1687  CE2 PHE A 260      -2.496  34.648 176.266  1.00 12.69           C  
ATOM   1688  CZ  PHE A 260      -2.027  33.350 176.066  1.00 11.52           C  
ATOM   1689  N   LYS A 261      -8.304  34.278 172.218  1.00 11.14           N  
ATOM   1690  CA  LYS A 261      -9.581  34.741 171.671  1.00 10.57           C  
ATOM   1691  C   LYS A 261     -10.671  34.699 172.726  1.00 11.18           C  
ATOM   1692  O   LYS A 261     -10.860  33.690 173.424  1.00 11.41           O  
ATOM   1693  CB  LYS A 261     -10.000  33.917 170.439  1.00 10.52           C  
ATOM   1694  CG  LYS A 261     -11.246  34.484 169.753  1.00 11.87           C  
ATOM   1695  CD  LYS A 261     -11.635  33.674 168.510  1.00 10.84           C  
ATOM   1696  CE  LYS A 261     -13.007  34.163 167.997  1.00 12.52           C  
ATOM   1697  NZ  LYS A 261     -13.339  33.620 166.662  1.00 10.06           N  
ATOM   1698  N   ILE A 262     -11.405  35.803 172.813  1.00 12.52           N  
ATOM   1699  CA  ILE A 262     -12.544  35.878 173.729  1.00 14.17           C  
ATOM   1700  C   ILE A 262     -13.769  35.174 173.109  1.00 14.67           C  
ATOM   1701  O   ILE A 262     -14.440  34.412 173.846  1.00 16.69           O  
ATOM   1702  CB  ILE A 262     -12.841  37.336 174.119  1.00 13.49           C  
ATOM   1703  CG1 ILE A 262     -11.665  37.897 174.942  1.00 14.76           C  
ATOM   1704  CG2 ILE A 262     -14.123  37.448 174.940  1.00 16.03           C  
ATOM   1705  CD1 ILE A 262     -11.673  39.422 175.102  1.00 17.09           C  
TER    1706      ILE A 262                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
