
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  206 ( 1603),  selected  206 , name 3dul_B
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 3dul_B.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     6_B      N       3          2.415
LGA    W     7_B      A       4          1.956
LGA    T     8_B      F       5          3.614
LGA    A     9_B      E       6          2.694
LGA    V    10_B      Y       7          0.294
LGA    D    11_B      L       8          2.225
LGA    Q    12_B      R       9          2.103
LGA    Y    13_B      T      10          1.472
LGA    V    14_B      Y      11          2.548
LGA    S    15_B      V      12          2.197
LGA    D    16_B      E      13          1.804
LGA    V    17_B      S      14          4.408
LGA    L    18_B      T      15          4.714
LGA    I    19_B      T      16          2.167
LGA    P    20_B      E      17          1.351
LGA    K    21_B      T      18          1.197
LGA    D    22_B      D      19          1.211
LGA    S    23_B      A      20          1.557
LGA    T    24_B      A      21          1.489
LGA    L    25_B      V      22          1.175
LGA    E    26_B      A      23          1.347
LGA    E    27_B      R      24          1.619
LGA    V    28_B      A      25          1.793
LGA    L    29_B      R      26          2.239
LGA    Q    30_B      E      27          2.460
LGA    V    31_B      D      28          2.565
LGA    N    32_B      A      29          2.777
LGA    A    33_B      A      30          3.449
LGA    A    34_B      E      31          3.275
LGA    A    35_B      F      32          3.152
LGA    N    36_B      -       -           -
LGA    L    37_B      G      33          3.949
LGA    P    38_B      L      34          3.958
LGA    A    39_B      -       -           -
LGA    H    40_B      P      35          2.059
LGA    D    41_B      A      36          4.085
LGA    V    42_B      P      37          3.528
LGA    S    43_B      D      38          0.681
LGA    P    44_B      E      39          0.728
LGA    T    45_B      M      40          0.736
LGA    Q    46_B      T      41          0.731
LGA    G    47_B      G      42          0.538
LGA    K    48_B      Q      43          0.639
LGA    F    49_B      L      44          0.567
LGA    L    50_B      L      45          0.723
LGA    Q    51_B      T      46          0.467
LGA    L    52_B      T      47          1.287
LGA    L    53_B      L      48          1.703
LGA    V    54_B      A      49          1.482
LGA    Q    55_B      A      50          0.989
LGA    I    56_B      T      51          1.759
LGA    Q    57_B      T      52          2.183
LGA    G    58_B      N      53          3.553
LGA    A    59_B      G      54          3.477
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    R    60_B      S      57          4.698
LGA    N    61_B      T      58          2.973
LGA    -       -      G      59           -
LGA    I    62_B      A      60          0.963
LGA    L    63_B      I      61          1.495
LGA    E    64_B      A      62          1.754
LGA    I    65_B      I      63          1.643
LGA    G    66_B      T      64          1.642
LGA    T    67_B      P      65          4.289
LGA    L    68_B      A      66          2.123
LGA    G    69_B      A      67          4.635
LGA    G    70_B      G      68          1.486
LGA    Y    71_B      L      69          0.646
LGA    S    72_B      V      70          0.654
LGA    T    73_B      G      71          1.039
LGA    I    74_B      L      72          0.925
LGA    W    75_B      Y      73          0.458
LGA    L    76_B      I      74          0.617
LGA    A    77_B      L      75          1.233
LGA    R    78_B      N      76          1.268
LGA    G    79_B      G      77          0.977
LGA    L    80_B      L      78          1.353
LGA    S    81_B      A      79          2.221
LGA    S    82_B      D      80          2.607
LGA    G    83_B      N      81          1.299
LGA    G    84_B      T      82          1.289
LGA    R    85_B      T      83          0.875
LGA    V    86_B      L      84          1.076
LGA    V    87_B      T      85          0.824
LGA    T    88_B      C      86          1.415
LGA    L    89_B      I      87          0.648
LGA    E    90_B      D      88          0.684
LGA    A    91_B      P      89          1.518
LGA    S    92_B      E      90          1.237
LGA    E    93_B      S      91          1.511
LGA    K    94_B      E      92          1.783
LGA    H    95_B      H      93          1.750
LGA    A    96_B      Q      94          2.072
LGA    D    97_B      R      95          1.604
LGA    I    98_B      Q      96          1.041
LGA    A    99_B      A      97          1.550
LGA    R   100_B      K      98          1.518
LGA    S   101_B      A      99          1.110
LGA    N   102_B      L     100          1.397
LGA    I   103_B      F     101          1.899
LGA    E   104_B      R     102          1.627
LGA    R   105_B      E     103          1.217
LGA    A   106_B      A     104          1.516
LGA    N   107_B      G     105          2.401
LGA    L   108_B      Y     106          2.612
LGA    -       -      S     107           -
LGA    N   109_B      P     108          3.501
LGA    D   110_B      S     109          3.081
LGA    R   111_B      R     110          1.092
LGA    V   112_B      V     111          1.217
LGA    E   113_B      R     112          0.766
LGA    V   114_B      F     113          1.271
LGA    R   115_B      L     114          0.722
LGA    T   116_B      L     115          0.674
LGA    G   117_B      S     116          1.353
LGA    L   118_B      R     117          1.466
LGA    A   119_B      P     118          1.336
LGA    L   120_B      L     119          1.748
LGA    D   121_B      D     120          1.857
LGA    S   122_B      V     121          1.271
LGA    L   123_B      M     122          0.805
LGA    Q   124_B      S     123          1.360
LGA    Q   125_B      R     124          1.852
LGA    I   126_B      L     125          1.668
LGA    E   127_B      -       -           -
LGA    N   128_B      -       -           -
LGA    E   129_B      -       -           -
LGA    K   130_B      -       -           -
LGA    Y   131_B      A     126          4.167
LGA    E   132_B      N     127          4.769
LGA    -       -      D     128           -
LGA    P   133_B      S     129          1.529
LGA    F   134_B      Y     130          0.668
LGA    D   135_B      Q     131          1.228
LGA    F   136_B      L     132          1.307
LGA    I   137_B      V     133          1.288
LGA    F   138_B      F     134          1.201
LGA    I   139_B      G     135          1.329
LGA    D   140_B      Q     136          1.487
LGA    A   141_B      V     137          1.454
LGA    D   142_B      S     138          1.703
LGA    K   143_B      P     139          1.774
LGA    Q   144_B      M     140          0.556
LGA    N   145_B      D     141          0.713
LGA    N   146_B      L     142          0.858
LGA    P   147_B      K     143          0.652
LGA    A   148_B      A     144          0.488
LGA    Y   149_B      L     145          0.605
LGA    F   150_B      V     146          0.848
LGA    E   151_B      D     147          0.912
LGA    W   152_B      A     148          0.805
LGA    A   153_B      A     149          0.888
LGA    L   154_B      W     150          0.511
LGA    K   155_B      P     151          1.585
LGA    L   156_B      L     152          1.105
LGA    S   157_B      L     153          1.901
LGA    R   158_B      R     154          2.730
LGA    P   159_B      R     155          2.252
LGA    G   160_B      G     156          2.109
LGA    T   161_B      G     157          1.637
LGA    V   162_B      A     158          1.573
LGA    I   163_B      L     159          1.539
LGA    I   164_B      V     160          1.387
LGA    G   165_B      L     161          1.286
LGA    D   166_B      A     162          1.440
LGA    N   167_B      D     163          2.854
LGA    -       -      A     164           -
LGA    V   168_B      L     165          4.395
LGA    V   169_B      L     166          5.352
LGA    R   170_B      D     167          3.507
LGA    E   171_B      -       -           -
LGA    G   172_B      -       -           -
LGA    E   173_B      -       -           -
LGA    V   174_B      G     168           #
LGA    I   175_B      T     169           #
LGA    -       -      I     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      Q     173           -
LGA    -       -      T     174           -
LGA    -       -      R     175           -
LGA    -       -      K     176           -
LGA    -       -      D     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    -       -      Q     181           -
LGA    -       -      A     182           -
LGA    I   187_B      A     183          2.567
LGA    R   188_B      R     184          2.250
LGA    R   189_B      D     185          1.645
LGA    F   190_B      A     186          1.257
LGA    Y   191_B      D     187          1.185
LGA    E   192_B      E     188          0.521
LGA    L   193_B      Y     189          0.432
LGA    I   194_B      I     190          0.845
LGA    A   195_B      R     191          1.659
LGA    A   196_B      S     192          1.855
LGA    E   197_B      I     193          1.218
LGA    P   198_B      E     194          1.349
LGA    R   199_B      G     195          3.603
LGA    V   200_B      A     196          1.522
LGA    S   201_B      H     197          2.122
LGA    A   202_B      V     198          0.892
LGA    T   203_B      A     199          1.737
LGA    A   204_B      R     200          0.606
LGA    L   205_B      L     201          0.676
LGA    Q   206_B      P     202          1.737
LGA    T   207_B      L     203          2.372
LGA    V   208_B      -       -           -
LGA    G   209_B      -       -           -
LGA    S   210_B      -       -           -
LGA    K   211_B      -       -           -
LGA    G   212_B      -       -           -
LGA    Y   213_B      G     204          3.364
LGA    D   214_B      A     205          3.468
LGA    G   215_B      G     206          0.983
LGA    F   216_B      L     207          0.830
LGA    I   217_B      T     208          1.182
LGA    X   218_B      V     209          1.770
LGA    A   219_B      V     210          1.516
LGA    V   220_B      T     211          1.655
LGA    V   221_B      K     212          1.134
LGA    K   222_B      A     213          2.867

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  206  211    5.0    190    2.03    14.21     74.251     8.905

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.634305 * X  +  -0.563030 * Y  +   0.529768 * Z  +  46.872673
  Y_new =  -0.442754 * X  +   0.826322 * Y  +   0.348081 * Z  +  20.661343
  Z_new =  -0.633739 * X  +  -0.013768 * Y  +  -0.773424 * Z  + 219.789429 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.123794    0.017799  [ DEG:  -178.9802      1.0198 ]
  Theta =   0.686377    2.455215  [ DEG:    39.3265    140.6735 ]
  Phi   =  -2.532200    0.609392  [ DEG:  -145.0844     34.9156 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3dul_B                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3dul_B.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  206  211   5.0  190   2.03   14.21  74.251
REMARK  ---------------------------------------------------------- 
MOLECULE 3dul_B
HEADER    TRANSFERASE                             17-JUL-08   3DUL              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF THE O-METHYLTRANSFERASE FROM            
TITLE    2 BACILLUS CEREUS                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: O-METHYLTRANSFERASE, PUTATIVE;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: OMT;                                                        
COMPND   5 EC: 2.1.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CEREUS;                                
SOURCE   3 STRAIN: ATCC 10987;                                                  
SOURCE   4 GENE: BCE_2045;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A_TEV                                
KEYWDS    ALTERNATING OF ALPHA AND BETA, METHYLTRANSFERASE,                     
KEYWDS   2 TRANSFERASE                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.-H.CHO,S.RHEE                                                       
REVDAT   1   05-AUG-08 3DUL    0                                                
JRNL        AUTH   J.-H.CHO,Y.PARK,J.-H.AHN,Y.LIM,S.RHEE                        
JRNL        TITL   STRUCTURAL AND FUNCTIONAL INSIGHTS INTO                      
JRNL        TITL 2 O-METHYLTRANSFERASE FROM BACILLUS CEREUS                     
JRNL        REF    J.MOL.BIOL.                                2008              
JRNL        REFN   ASTM JMOBAK  UK ESSN 1089-8638                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  3DUL A    1   223  UNP    Q739U3   Q739U3_BACC1     1    223             
DBREF  3DUL B    1   223  UNP    Q739U3   Q739U3_BACC1     1    223             
SEQRES   1 A  223  MSE SER MSE ILE GLU THR TRP THR ALA VAL ASP GLN TYR          
SEQRES   2 A  223  VAL SER ASP VAL LEU ILE PRO LYS ASP SER THR LEU GLU          
SEQRES   3 A  223  GLU VAL LEU GLN VAL ASN ALA ALA ALA ASN LEU PRO ALA          
SEQRES   4 A  223  HIS ASP VAL SER PRO THR GLN GLY LYS PHE LEU GLN LEU          
SEQRES   5 A  223  LEU VAL GLN ILE GLN GLY ALA ARG ASN ILE LEU GLU ILE          
SEQRES   6 A  223  GLY THR LEU GLY GLY TYR SER THR ILE TRP LEU ALA ARG          
SEQRES   7 A  223  GLY LEU SER SER GLY GLY ARG VAL VAL THR LEU GLU ALA          
SEQRES   8 A  223  SER GLU LYS HIS ALA ASP ILE ALA ARG SER ASN ILE GLU          
SEQRES   9 A  223  ARG ALA ASN LEU ASN ASP ARG VAL GLU VAL ARG THR GLY          
SEQRES  10 A  223  LEU ALA LEU ASP SER LEU GLN GLN ILE GLU ASN GLU LYS          
SEQRES  11 A  223  TYR GLU PRO PHE ASP PHE ILE PHE ILE ASP ALA ASP LYS          
SEQRES  12 A  223  GLN ASN ASN PRO ALA TYR PHE GLU TRP ALA LEU LYS LEU          
SEQRES  13 A  223  SER ARG PRO GLY THR VAL ILE ILE GLY ASP ASN VAL VAL          
SEQRES  14 A  223  ARG GLU GLY GLU VAL ILE ASP ASN THR SER ASN ASP PRO          
SEQRES  15 A  223  ARG VAL GLN GLY ILE ARG ARG PHE TYR GLU LEU ILE ALA          
SEQRES  16 A  223  ALA GLU PRO ARG VAL SER ALA THR ALA LEU GLN THR VAL          
SEQRES  17 A  223  GLY SER LYS GLY TYR ASP GLY PHE ILE MSE ALA VAL VAL          
SEQRES  18 A  223  LYS GLU                                                      
SEQRES   1 B  223  MSE SER MSE ILE GLU THR TRP THR ALA VAL ASP GLN TYR          
SEQRES   2 B  223  VAL SER ASP VAL LEU ILE PRO LYS ASP SER THR LEU GLU          
SEQRES   3 B  223  GLU VAL LEU GLN VAL ASN ALA ALA ALA ASN LEU PRO ALA          
SEQRES   4 B  223  HIS ASP VAL SER PRO THR GLN GLY LYS PHE LEU GLN LEU          
SEQRES   5 B  223  LEU VAL GLN ILE GLN GLY ALA ARG ASN ILE LEU GLU ILE          
SEQRES   6 B  223  GLY THR LEU GLY GLY TYR SER THR ILE TRP LEU ALA ARG          
SEQRES   7 B  223  GLY LEU SER SER GLY GLY ARG VAL VAL THR LEU GLU ALA          
SEQRES   8 B  223  SER GLU LYS HIS ALA ASP ILE ALA ARG SER ASN ILE GLU          
SEQRES   9 B  223  ARG ALA ASN LEU ASN ASP ARG VAL GLU VAL ARG THR GLY          
SEQRES  10 B  223  LEU ALA LEU ASP SER LEU GLN GLN ILE GLU ASN GLU LYS          
SEQRES  11 B  223  TYR GLU PRO PHE ASP PHE ILE PHE ILE ASP ALA ASP LYS          
SEQRES  12 B  223  GLN ASN ASN PRO ALA TYR PHE GLU TRP ALA LEU LYS LEU          
SEQRES  13 B  223  SER ARG PRO GLY THR VAL ILE ILE GLY ASP ASN VAL VAL          
SEQRES  14 B  223  ARG GLU GLY GLU VAL ILE ASP ASN THR SER ASN ASP PRO          
SEQRES  15 B  223  ARG VAL GLN GLY ILE ARG ARG PHE TYR GLU LEU ILE ALA          
SEQRES  16 B  223  ALA GLU PRO ARG VAL SER ALA THR ALA LEU GLN THR VAL          
SEQRES  17 B  223  GLY SER LYS GLY TYR ASP GLY PHE ILE MSE ALA VAL VAL          
SEQRES  18 B  223  LYS GLU                                                      
HET    MSE  A 218       8                                                       
HET    MSE  B 218       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *229(H2 O)                                                    
CRYST1  124.900   64.400   86.300  90.00 133.70  90.00 C 1 2 1       8          
ATOM   1568  N   THR B   6      25.584  39.320 178.871  1.00 37.81           N  
ATOM   1569  CA  THR B   6      25.694  37.912 178.393  1.00 36.64           C  
ATOM   1570  C   THR B   6      24.389  37.181 178.706  1.00 36.21           C  
ATOM   1571  O   THR B   6      24.401  35.994 179.038  1.00 35.40           O  
ATOM   1572  CB  THR B   6      26.846  37.166 179.110  1.00 37.29           C  
ATOM   1573  OG1 THR B   6      27.942  38.062 179.328  1.00 38.40           O  
ATOM   1574  CG2 THR B   6      27.335  36.003 178.265  1.00 38.56           C  
ATOM   1575  N   TRP B   7      23.267  37.890 178.608  1.00 34.53           N  
ATOM   1576  CA  TRP B   7      21.968  37.292 178.899  1.00 33.95           C  
ATOM   1577  C   TRP B   7      21.536  36.277 177.860  1.00 32.81           C  
ATOM   1578  O   TRP B   7      20.861  35.297 178.184  1.00 31.99           O  
ATOM   1579  CB  TRP B   7      20.896  38.371 179.044  1.00 34.36           C  
ATOM   1580  CG  TRP B   7      20.819  38.922 180.436  1.00 34.63           C  
ATOM   1581  CD1 TRP B   7      21.081  40.202 180.829  1.00 35.22           C  
ATOM   1582  CD2 TRP B   7      20.476  38.197 181.623  1.00 34.54           C  
ATOM   1583  NE1 TRP B   7      20.924  40.320 182.193  1.00 34.95           N  
ATOM   1584  CE2 TRP B   7      20.552  39.105 182.704  1.00 35.13           C  
ATOM   1585  CE3 TRP B   7      20.111  36.869 181.880  1.00 33.91           C  
ATOM   1586  CZ2 TRP B   7      20.276  38.725 184.022  1.00 34.44           C  
ATOM   1587  CZ3 TRP B   7      19.836  36.492 183.191  1.00 34.89           C  
ATOM   1588  CH2 TRP B   7      19.921  37.421 184.244  1.00 33.48           C  
ATOM   1589  N   THR B   8      21.918  36.504 176.609  1.00 30.76           N  
ATOM   1590  CA  THR B   8      21.557  35.568 175.563  1.00 29.79           C  
ATOM   1591  C   THR B   8      22.244  34.242 175.882  1.00 28.35           C  
ATOM   1592  O   THR B   8      21.635  33.177 175.798  1.00 27.88           O  
ATOM   1593  CB  THR B   8      22.013  36.072 174.184  1.00 31.32           C  
ATOM   1594  OG1 THR B   8      21.419  37.354 173.924  1.00 32.28           O  
ATOM   1595  CG2 THR B   8      21.592  35.097 173.099  1.00 29.66           C  
ATOM   1596  N   ALA B   9      23.512  34.321 176.275  1.00 28.42           N  
ATOM   1597  CA  ALA B   9      24.287  33.131 176.605  1.00 28.13           C  
ATOM   1598  C   ALA B   9      23.642  32.396 177.766  1.00 28.00           C  
ATOM   1599  O   ALA B   9      23.520  31.172 177.754  1.00 27.79           O  
ATOM   1600  CB  ALA B   9      25.716  33.520 176.960  1.00 28.63           C  
ATOM   1601  N   VAL B  10      23.232  33.154 178.774  1.00 27.21           N  
ATOM   1602  CA  VAL B  10      22.592  32.562 179.938  1.00 26.85           C  
ATOM   1603  C   VAL B  10      21.280  31.876 179.566  1.00 26.30           C  
ATOM   1604  O   VAL B  10      21.012  30.761 180.005  1.00 26.54           O  
ATOM   1605  CB  VAL B  10      22.308  33.620 181.016  1.00 26.43           C  
ATOM   1606  CG1 VAL B  10      21.521  32.989 182.164  1.00 26.32           C  
ATOM   1607  CG2 VAL B  10      23.617  34.209 181.528  1.00 27.90           C  
ATOM   1608  N   ASP B  11      20.466  32.529 178.743  1.00 26.67           N  
ATOM   1609  CA  ASP B  11      19.190  31.944 178.360  1.00 27.30           C  
ATOM   1610  C   ASP B  11      19.305  30.753 177.425  1.00 28.40           C  
ATOM   1611  O   ASP B  11      18.437  29.885 177.413  1.00 27.17           O  
ATOM   1612  CB  ASP B  11      18.279  33.005 177.756  1.00 27.64           C  
ATOM   1613  CG  ASP B  11      17.896  34.063 178.764  1.00 27.95           C  
ATOM   1614  OD1 ASP B  11      17.839  33.724 179.968  1.00 28.72           O  
ATOM   1615  OD2 ASP B  11      17.649  35.218 178.363  1.00 27.08           O  
ATOM   1616  N   GLN B  12      20.370  30.702 176.635  1.00 29.32           N  
ATOM   1617  CA  GLN B  12      20.539  29.572 175.740  1.00 29.47           C  
ATOM   1618  C   GLN B  12      20.992  28.385 176.572  1.00 28.71           C  
ATOM   1619  O   GLN B  12      20.667  27.240 176.261  1.00 28.90           O  
ATOM   1620  CB  GLN B  12      21.543  29.915 174.640  1.00 30.89           C  
ATOM   1621  CG  GLN B  12      20.977  30.941 173.673  1.00 32.95           C  
ATOM   1622  CD  GLN B  12      22.005  31.470 172.707  1.00 34.56           C  
ATOM   1623  OE1 GLN B  12      23.103  31.863 173.107  1.00 36.82           O  
ATOM   1624  NE2 GLN B  12      21.653  31.501 171.427  1.00 33.95           N  
ATOM   1625  N   TYR B  13      21.728  28.664 177.644  1.00 28.81           N  
ATOM   1626  CA  TYR B  13      22.179  27.609 178.542  1.00 28.20           C  
ATOM   1627  C   TYR B  13      20.929  27.034 179.213  1.00 27.75           C  
ATOM   1628  O   TYR B  13      20.764  25.818 179.330  1.00 27.60           O  
ATOM   1629  CB  TYR B  13      23.116  28.175 179.611  1.00 29.70           C  
ATOM   1630  CG  TYR B  13      23.384  27.208 180.745  1.00 31.71           C  
ATOM   1631  CD1 TYR B  13      24.210  26.099 180.562  1.00 33.06           C  
ATOM   1632  CD2 TYR B  13      22.755  27.365 181.983  1.00 32.57           C  
ATOM   1633  CE1 TYR B  13      24.401  25.163 181.583  1.00 32.72           C  
ATOM   1634  CE2 TYR B  13      22.938  26.433 183.010  1.00 33.33           C  
ATOM   1635  CZ  TYR B  13      23.759  25.336 182.802  1.00 33.94           C  
ATOM   1636  OH  TYR B  13      23.915  24.399 183.802  1.00 33.55           O  
ATOM   1637  N   VAL B  14      20.051  27.932 179.652  1.00 27.16           N  
ATOM   1638  CA  VAL B  14      18.801  27.550 180.307  1.00 25.68           C  
ATOM   1639  C   VAL B  14      17.966  26.690 179.370  1.00 24.76           C  
ATOM   1640  O   VAL B  14      17.379  25.690 179.786  1.00 24.56           O  
ATOM   1641  CB  VAL B  14      17.986  28.803 180.709  1.00 25.20           C  
ATOM   1642  CG1 VAL B  14      16.578  28.402 181.155  1.00 24.87           C  
ATOM   1643  CG2 VAL B  14      18.705  29.540 181.822  1.00 25.25           C  
ATOM   1644  N   SER B  15      17.912  27.084 178.101  1.00 23.48           N  
ATOM   1645  CA  SER B  15      17.152  26.328 177.117  1.00 22.84           C  
ATOM   1646  C   SER B  15      17.726  24.922 177.023  1.00 22.76           C  
ATOM   1647  O   SER B  15      16.992  23.945 176.872  1.00 22.09           O  
ATOM   1648  CB  SER B  15      17.228  26.992 175.746  1.00 19.64           C  
ATOM   1649  OG  SER B  15      16.551  26.201 174.785  1.00 19.57           O  
ATOM   1650  N   ASP B  16      19.046  24.833 177.128  1.00 25.83           N  
ATOM   1651  CA  ASP B  16      19.739  23.553 177.047  1.00 27.81           C  
ATOM   1652  C   ASP B  16      19.461  22.622 178.219  1.00 29.13           C  
ATOM   1653  O   ASP B  16      19.385  21.408 178.038  1.00 31.01           O  
ATOM   1654  CB  ASP B  16      21.249  23.774 176.929  1.00 29.72           C  
ATOM   1655  CG  ASP B  16      21.674  24.166 175.527  1.00 32.28           C  
ATOM   1656  OD1 ASP B  16      20.795  24.271 174.643  1.00 32.46           O  
ATOM   1657  OD2 ASP B  16      22.889  24.365 175.309  1.00 33.62           O  
ATOM   1658  N   VAL B  17      19.311  23.174 179.418  1.00 29.72           N  
ATOM   1659  CA  VAL B  17      19.057  22.327 180.581  1.00 29.61           C  
ATOM   1660  C   VAL B  17      17.578  22.003 180.762  1.00 29.17           C  
ATOM   1661  O   VAL B  17      17.222  20.868 181.084  1.00 27.22           O  
ATOM   1662  CB  VAL B  17      19.605  22.966 181.881  1.00 30.48           C  
ATOM   1663  CG1 VAL B  17      21.021  23.448 181.654  1.00 32.26           C  
ATOM   1664  CG2 VAL B  17      18.715  24.098 182.337  1.00 31.53           C  
ATOM   1665  N   LEU B  18      16.717  22.993 180.539  1.00 28.36           N  
ATOM   1666  CA  LEU B  18      15.276  22.804 180.690  1.00 27.77           C  
ATOM   1667  C   LEU B  18      14.662  21.900 179.631  1.00 28.26           C  
ATOM   1668  O   LEU B  18      13.762  21.111 179.920  1.00 28.26           O  
ATOM   1669  CB  LEU B  18      14.550  24.151 180.652  1.00 27.74           C  
ATOM   1670  CG  LEU B  18      14.636  25.073 181.861  1.00 28.24           C  
ATOM   1671  CD1 LEU B  18      13.742  26.288 181.601  1.00 26.98           C  
ATOM   1672  CD2 LEU B  18      14.194  24.332 183.128  1.00 27.73           C  
ATOM   1673  N   ILE B  19      15.140  22.026 178.401  1.00 27.51           N  
ATOM   1674  CA  ILE B  19      14.619  21.230 177.310  1.00 28.33           C  
ATOM   1675  C   ILE B  19      15.594  20.119 176.916  1.00 30.53           C  
ATOM   1676  O   ILE B  19      16.691  20.383 176.429  1.00 31.37           O  
ATOM   1677  CB  ILE B  19      14.317  22.118 176.090  1.00 27.52           C  
ATOM   1678  CG1 ILE B  19      13.309  23.200 176.489  1.00 28.04           C  
ATOM   1679  CG2 ILE B  19      13.768  21.272 174.956  1.00 25.38           C  
ATOM   1680  CD1 ILE B  19      12.929  24.126 175.362  1.00 27.34           C  
ATOM   1681  N   PRO B  20      15.188  18.860 177.126  1.00 31.73           N  
ATOM   1682  CA  PRO B  20      15.937  17.632 176.838  1.00 33.88           C  
ATOM   1683  C   PRO B  20      16.309  17.475 175.366  1.00 34.37           C  
ATOM   1684  O   PRO B  20      15.469  17.647 174.488  1.00 32.67           O  
ATOM   1685  CB  PRO B  20      14.976  16.529 177.282  1.00 34.63           C  
ATOM   1686  CG  PRO B  20      14.120  17.197 178.312  1.00 35.11           C  
ATOM   1687  CD  PRO B  20      13.863  18.532 177.679  1.00 33.20           C  
ATOM   1688  N   LYS B  21      17.569  17.141 175.106  1.00 35.80           N  
ATOM   1689  CA  LYS B  21      18.018  16.928 173.736  1.00 36.73           C  
ATOM   1690  C   LYS B  21      17.150  15.825 173.137  1.00 35.44           C  
ATOM   1691  O   LYS B  21      16.972  14.767 173.741  1.00 35.76           O  
ATOM   1692  CB  LYS B  21      19.489  16.506 173.722  1.00 38.39           C  
ATOM   1693  CG  LYS B  21      20.443  17.586 174.205  1.00 41.02           C  
ATOM   1694  CD  LYS B  21      21.873  17.063 174.276  1.00 42.49           C  
ATOM   1695  CE  LYS B  21      22.858  18.183 174.592  1.00 43.62           C  
ATOM   1696  NZ  LYS B  21      22.866  19.232 173.525  1.00 44.79           N  
ATOM   1697  N   ASP B  22      16.588  16.087 171.964  1.00 35.15           N  
ATOM   1698  CA  ASP B  22      15.736  15.116 171.295  1.00 33.87           C  
ATOM   1699  C   ASP B  22      16.386  14.715 169.972  1.00 32.92           C  
ATOM   1700  O   ASP B  22      16.537  15.538 169.064  1.00 30.77           O  
ATOM   1701  CB  ASP B  22      14.347  15.716 171.050  1.00 35.96           C  
ATOM   1702  CG  ASP B  22      13.376  14.723 170.437  1.00 38.03           C  
ATOM   1703  OD1 ASP B  22      13.197  13.617 170.998  1.00 40.24           O  
ATOM   1704  OD2 ASP B  22      12.780  15.048 169.393  1.00 39.04           O  
ATOM   1705  N   SER B  23      16.780  13.449 169.873  1.00 32.04           N  
ATOM   1706  CA  SER B  23      17.423  12.948 168.663  1.00 31.21           C  
ATOM   1707  C   SER B  23      16.579  13.230 167.421  1.00 30.39           C  
ATOM   1708  O   SER B  23      17.111  13.586 166.369  1.00 30.07           O  
ATOM   1709  CB  SER B  23      17.678  11.444 168.787  1.00 31.15           C  
ATOM   1710  OG  SER B  23      16.462  10.722 168.887  1.00 33.16           O  
ATOM   1711  N   THR B  24      15.263  13.070 167.548  1.00 28.93           N  
ATOM   1712  CA  THR B  24      14.347  13.310 166.438  1.00 28.04           C  
ATOM   1713  C   THR B  24      14.468  14.753 165.940  1.00 27.72           C  
ATOM   1714  O   THR B  24      14.734  14.992 164.761  1.00 25.95           O  
ATOM   1715  CB  THR B  24      12.886  13.046 166.862  1.00 28.15           C  
ATOM   1716  OG1 THR B  24      12.772  11.710 167.370  1.00 30.17           O  
ATOM   1717  CG2 THR B  24      11.942  13.208 165.670  1.00 29.12           C  
ATOM   1718  N   LEU B  25      14.267  15.717 166.834  1.00 26.51           N  
ATOM   1719  CA  LEU B  25      14.376  17.118 166.444  1.00 25.84           C  
ATOM   1720  C   LEU B  25      15.809  17.439 166.043  1.00 26.38           C  
ATOM   1721  O   LEU B  25      16.064  18.366 165.271  1.00 25.10           O  
ATOM   1722  CB  LEU B  25      13.930  18.036 167.585  1.00 25.33           C  
ATOM   1723  CG  LEU B  25      12.421  18.030 167.833  1.00 25.91           C  
ATOM   1724  CD1 LEU B  25      12.071  19.073 168.882  1.00 24.39           C  
ATOM   1725  CD2 LEU B  25      11.690  18.329 166.533  1.00 25.70           C  
ATOM   1726  N   GLU B  26      16.742  16.662 166.579  1.00 26.26           N  
ATOM   1727  CA  GLU B  26      18.152  16.836 166.262  1.00 28.20           C  
ATOM   1728  C   GLU B  26      18.354  16.629 164.759  1.00 27.29           C  
ATOM   1729  O   GLU B  26      18.894  17.493 164.068  1.00 24.29           O  
ATOM   1730  CB  GLU B  26      18.991  15.821 167.041  1.00 31.92           C  
ATOM   1731  CG  GLU B  26      20.478  15.856 166.735  1.00 37.41           C  
ATOM   1732  CD  GLU B  26      21.281  14.932 167.638  1.00 39.54           C  
ATOM   1733  OE1 GLU B  26      21.003  13.710 167.648  1.00 42.37           O  
ATOM   1734  OE2 GLU B  26      22.190  15.430 168.339  1.00 40.90           O  
ATOM   1735  N   GLU B  27      17.912  15.483 164.253  1.00 27.55           N  
ATOM   1736  CA  GLU B  27      18.080  15.205 162.834  1.00 27.84           C  
ATOM   1737  C   GLU B  27      17.174  16.054 161.950  1.00 27.02           C  
ATOM   1738  O   GLU B  27      17.535  16.362 160.815  1.00 25.27           O  
ATOM   1739  CB  GLU B  27      17.901  13.708 162.547  1.00 30.68           C  
ATOM   1740  CG  GLU B  27      16.810  13.011 163.321  1.00 33.26           C  
ATOM   1741  CD  GLU B  27      17.054  11.510 163.420  1.00 34.54           C  
ATOM   1742  OE1 GLU B  27      18.070  11.109 164.029  1.00 38.61           O  
ATOM   1743  OE2 GLU B  27      16.236  10.731 162.890  1.00 33.16           O  
ATOM   1744  N   VAL B  28      16.005  16.443 162.461  1.00 24.00           N  
ATOM   1745  CA  VAL B  28      15.110  17.294 161.682  1.00 23.04           C  
ATOM   1746  C   VAL B  28      15.875  18.562 161.314  1.00 21.08           C  
ATOM   1747  O   VAL B  28      15.770  19.066 160.193  1.00 21.06           O  
ATOM   1748  CB  VAL B  28      13.852  17.693 162.478  1.00 22.51           C  
ATOM   1749  CG1 VAL B  28      13.166  18.881 161.804  1.00 21.39           C  
ATOM   1750  CG2 VAL B  28      12.894  16.526 162.553  1.00 22.42           C  
ATOM   1751  N   LEU B  29      16.649  19.077 162.265  1.00 20.70           N  
ATOM   1752  CA  LEU B  29      17.439  20.277 162.028  1.00 21.22           C  
ATOM   1753  C   LEU B  29      18.597  19.976 161.070  1.00 22.25           C  
ATOM   1754  O   LEU B  29      18.968  20.817 160.256  1.00 20.41           O  
ATOM   1755  CB  LEU B  29      17.968  20.836 163.350  1.00 21.83           C  
ATOM   1756  CG  LEU B  29      16.872  21.432 164.250  1.00 20.54           C  
ATOM   1757  CD1 LEU B  29      17.442  21.793 165.606  1.00 22.55           C  
ATOM   1758  CD2 LEU B  29      16.273  22.664 163.571  1.00 20.67           C  
ATOM   1759  N   GLN B  30      19.158  18.773 161.164  1.00 21.93           N  
ATOM   1760  CA  GLN B  30      20.254  18.389 160.272  1.00 22.71           C  
ATOM   1761  C   GLN B  30      19.724  18.347 158.842  1.00 22.89           C  
ATOM   1762  O   GLN B  30      20.398  18.767 157.904  1.00 24.72           O  
ATOM   1763  CB  GLN B  30      20.816  17.020 160.671  1.00 22.93           C  
ATOM   1764  CG  GLN B  30      21.606  17.043 161.971  1.00 24.03           C  
ATOM   1765  CD  GLN B  30      22.116  15.671 162.368  1.00 23.78           C  
ATOM   1766  OE1 GLN B  30      21.338  14.733 162.546  1.00 24.36           O  
ATOM   1767  NE2 GLN B  30      23.428  15.549 162.507  1.00 24.23           N  
ATOM   1768  N   VAL B  31      18.507  17.843 158.687  1.00 23.37           N  
ATOM   1769  CA  VAL B  31      17.868  17.758 157.378  1.00 25.02           C  
ATOM   1770  C   VAL B  31      17.579  19.160 156.854  1.00 25.57           C  
ATOM   1771  O   VAL B  31      17.853  19.466 155.697  1.00 25.50           O  
ATOM   1772  CB  VAL B  31      16.550  16.962 157.462  1.00 24.57           C  
ATOM   1773  CG1 VAL B  31      15.800  17.039 156.142  1.00 24.11           C  
ATOM   1774  CG2 VAL B  31      16.848  15.510 157.820  1.00 26.59           C  
ATOM   1775  N   ASN B  32      17.021  20.018 157.704  1.00 25.21           N  
ATOM   1776  CA  ASN B  32      16.728  21.380 157.273  1.00 24.19           C  
ATOM   1777  C   ASN B  32      18.008  22.102 156.883  1.00 24.29           C  
ATOM   1778  O   ASN B  32      17.989  22.993 156.040  1.00 23.17           O  
ATOM   1779  CB  ASN B  32      15.998  22.168 158.373  1.00 24.78           C  
ATOM   1780  CG  ASN B  32      14.551  21.732 158.543  1.00 24.93           C  
ATOM   1781  OD1 ASN B  32      13.982  21.071 157.675  1.00 24.09           O  
ATOM   1782  ND2 ASN B  32      13.942  22.118 159.665  1.00 22.99           N  
ATOM   1783  N   ALA B  33      19.129  21.709 157.485  1.00 24.00           N  
ATOM   1784  CA  ALA B  33      20.402  22.347 157.169  1.00 24.83           C  
ATOM   1785  C   ALA B  33      20.720  22.239 155.669  1.00 24.31           C  
ATOM   1786  O   ALA B  33      21.510  23.014 155.136  1.00 23.95           O  
ATOM   1787  CB  ALA B  33      21.517  21.720 157.984  1.00 26.33           C  
ATOM   1788  N   ALA B  34      20.096  21.284 154.991  1.00 24.76           N  
ATOM   1789  CA  ALA B  34      20.334  21.113 153.558  1.00 27.06           C  
ATOM   1790  C   ALA B  34      19.077  21.423 152.736  1.00 28.69           C  
ATOM   1791  O   ALA B  34      19.070  21.272 151.511  1.00 28.96           O  
ATOM   1792  CB  ALA B  34      20.806  19.688 153.285  1.00 25.35           C  
ATOM   1793  N   ALA B  35      18.023  21.874 153.412  1.00 29.54           N  
ATOM   1794  CA  ALA B  35      16.751  22.180 152.755  1.00 30.21           C  
ATOM   1795  C   ALA B  35      16.661  23.577 152.136  1.00 31.00           C  
ATOM   1796  O   ALA B  35      15.675  23.894 151.472  1.00 30.87           O  
ATOM   1797  CB  ALA B  35      15.600  21.979 153.751  1.00 30.50           C  
ATOM   1798  N   ASN B  36      17.685  24.397 152.355  1.00 33.19           N  
ATOM   1799  CA  ASN B  36      17.732  25.768 151.837  1.00 33.83           C  
ATOM   1800  C   ASN B  36      16.452  26.509 152.181  1.00 34.86           C  
ATOM   1801  O   ASN B  36      15.792  27.088 151.310  1.00 34.91           O  
ATOM   1802  CB  ASN B  36      17.930  25.769 150.321  1.00 34.76           C  
ATOM   1803  CG  ASN B  36      18.954  24.760 149.873  1.00 33.73           C  
ATOM   1804  OD1 ASN B  36      18.618  23.612 149.585  1.00 33.91           O  
ATOM   1805  ND2 ASN B  36      20.217  25.173 149.829  1.00 35.87           N  
ATOM   1806  N   LEU B  37      16.103  26.478 153.461  1.00 34.99           N  
ATOM   1807  CA  LEU B  37      14.905  27.141 153.943  1.00 34.86           C  
ATOM   1808  C   LEU B  37      15.146  28.636 154.106  1.00 34.59           C  
ATOM   1809  O   LEU B  37      16.281  29.077 154.279  1.00 33.15           O  
ATOM   1810  CB  LEU B  37      14.484  26.549 155.295  1.00 33.85           C  
ATOM   1811  CG  LEU B  37      14.026  25.089 155.315  1.00 32.85           C  
ATOM   1812  CD1 LEU B  37      14.029  24.581 156.745  1.00 33.36           C  
ATOM   1813  CD2 LEU B  37      12.639  24.961 154.707  1.00 31.28           C  
ATOM   1814  N   PRO B  38      14.071  29.435 154.040  1.00 36.20           N  
ATOM   1815  CA  PRO B  38      14.185  30.887 154.194  1.00 37.06           C  
ATOM   1816  C   PRO B  38      14.804  31.184 155.561  1.00 38.55           C  
ATOM   1817  O   PRO B  38      14.629  30.414 156.508  1.00 38.88           O  
ATOM   1818  CB  PRO B  38      12.735  31.354 154.107  1.00 37.69           C  
ATOM   1819  CG  PRO B  38      12.115  30.347 153.189  1.00 37.54           C  
ATOM   1820  CD  PRO B  38      12.694  29.048 153.684  1.00 35.52           C  
ATOM   1821  N   ALA B  39      15.527  32.293 155.660  1.00 38.89           N  
ATOM   1822  CA  ALA B  39      16.170  32.677 156.908  1.00 39.42           C  
ATOM   1823  C   ALA B  39      15.197  32.657 158.087  1.00 39.48           C  
ATOM   1824  O   ALA B  39      14.148  33.303 158.048  1.00 40.52           O  
ATOM   1825  CB  ALA B  39      16.782  34.064 156.763  1.00 39.82           C  
ATOM   1826  N   HIS B  40      15.540  31.907 159.129  1.00 39.11           N  
ATOM   1827  CA  HIS B  40      14.690  31.833 160.314  1.00 38.54           C  
ATOM   1828  C   HIS B  40      15.482  31.389 161.536  1.00 37.37           C  
ATOM   1829  O   HIS B  40      16.586  30.860 161.424  1.00 37.07           O  
ATOM   1830  CB  HIS B  40      13.518  30.874 160.086  1.00 39.52           C  
ATOM   1831  CG  HIS B  40      13.915  29.432 160.035  1.00 40.57           C  
ATOM   1832  ND1 HIS B  40      14.638  28.892 158.992  1.00 39.93           N  
ATOM   1833  CD2 HIS B  40      13.692  28.416 160.903  1.00 41.09           C  
ATOM   1834  CE1 HIS B  40      14.844  27.606 159.219  1.00 41.04           C  
ATOM   1835  NE2 HIS B  40      14.279  27.292 160.372  1.00 41.43           N  
ATOM   1836  N   ASP B  41      14.908  31.603 162.710  1.00 36.05           N  
ATOM   1837  CA  ASP B  41      15.575  31.228 163.943  1.00 34.13           C  
ATOM   1838  C   ASP B  41      15.004  29.922 164.488  1.00 31.93           C  
ATOM   1839  O   ASP B  41      13.895  29.531 164.140  1.00 32.60           O  
ATOM   1840  CB  ASP B  41      15.422  32.356 164.960  1.00 36.75           C  
ATOM   1841  CG  ASP B  41      16.139  32.070 166.251  1.00 38.62           C  
ATOM   1842  OD1 ASP B  41      17.299  31.617 166.201  1.00 41.78           O  
ATOM   1843  OD2 ASP B  41      15.548  32.303 167.317  1.00 40.94           O  
ATOM   1844  N   VAL B  42      15.773  29.247 165.332  1.00 28.79           N  
ATOM   1845  CA  VAL B  42      15.341  27.982 165.919  1.00 27.30           C  
ATOM   1846  C   VAL B  42      15.269  28.162 167.425  1.00 25.35           C  
ATOM   1847  O   VAL B  42      16.269  28.497 168.063  1.00 25.25           O  
ATOM   1848  CB  VAL B  42      16.335  26.848 165.596  1.00 25.98           C  
ATOM   1849  CG1 VAL B  42      15.790  25.521 166.094  1.00 26.60           C  
ATOM   1850  CG2 VAL B  42      16.589  26.793 164.096  1.00 26.42           C  
ATOM   1851  N   SER B  43      14.088  27.934 167.991  1.00 25.51           N  
ATOM   1852  CA  SER B  43      13.896  28.118 169.425  1.00 23.70           C  
ATOM   1853  C   SER B  43      13.207  26.957 170.132  1.00 22.27           C  
ATOM   1854  O   SER B  43      11.979  26.826 170.086  1.00 20.73           O  
ATOM   1855  CB  SER B  43      13.101  29.405 169.671  1.00 23.75           C  
ATOM   1856  OG  SER B  43      12.884  29.618 171.056  1.00 23.15           O  
ATOM   1857  N   PRO B  44      13.993  26.088 170.785  1.00 20.89           N  
ATOM   1858  CA  PRO B  44      13.428  24.948 171.507  1.00 20.43           C  
ATOM   1859  C   PRO B  44      12.477  25.438 172.607  1.00 19.26           C  
ATOM   1860  O   PRO B  44      11.452  24.807 172.873  1.00 18.61           O  
ATOM   1861  CB  PRO B  44      14.661  24.261 172.087  1.00 19.72           C  
ATOM   1862  CG  PRO B  44      15.705  24.527 171.055  1.00 22.34           C  
ATOM   1863  CD  PRO B  44      15.463  25.977 170.693  1.00 21.89           C  
ATOM   1864  N   THR B  45      12.825  26.554 173.251  1.00 18.89           N  
ATOM   1865  CA  THR B  45      11.970  27.100 174.309  1.00 17.63           C  
ATOM   1866  C   THR B  45      10.626  27.559 173.743  1.00 18.24           C  
ATOM   1867  O   THR B  45       9.598  27.436 174.411  1.00 17.45           O  
ATOM   1868  CB  THR B  45      12.650  28.272 175.085  1.00 17.76           C  
ATOM   1869  OG1 THR B  45      13.236  29.206 174.167  1.00 17.62           O  
ATOM   1870  CG2 THR B  45      13.719  27.735 176.040  1.00 16.91           C  
ATOM   1871  N   GLN B  46      10.615  28.085 172.519  1.00 16.95           N  
ATOM   1872  CA  GLN B  46       9.345  28.490 171.921  1.00 16.31           C  
ATOM   1873  C   GLN B  46       8.565  27.240 171.511  1.00 14.67           C  
ATOM   1874  O   GLN B  46       7.343  27.181 171.632  1.00 13.64           O  
ATOM   1875  CB  GLN B  46       9.541  29.383 170.691  1.00 16.66           C  
ATOM   1876  CG  GLN B  46       8.205  29.954 170.217  1.00 19.84           C  
ATOM   1877  CD  GLN B  46       8.271  30.612 168.859  1.00 22.53           C  
ATOM   1878  OE1 GLN B  46       8.596  29.971 167.857  1.00 24.18           O  
ATOM   1879  NE2 GLN B  46       7.949  31.898 168.815  1.00 22.00           N  
ATOM   1880  N   GLY B  47       9.276  26.236 171.008  1.00 14.80           N  
ATOM   1881  CA  GLY B  47       8.617  25.005 170.620  1.00 14.49           C  
ATOM   1882  C   GLY B  47       7.937  24.398 171.838  1.00 14.39           C  
ATOM   1883  O   GLY B  47       6.788  23.967 171.778  1.00 14.07           O  
ATOM   1884  N   LYS B  48       8.658  24.377 172.951  1.00 13.02           N  
ATOM   1885  CA  LYS B  48       8.128  23.832 174.194  1.00 15.84           C  
ATOM   1886  C   LYS B  48       6.887  24.636 174.604  1.00 14.32           C  
ATOM   1887  O   LYS B  48       5.865  24.077 175.011  1.00 13.97           O  
ATOM   1888  CB  LYS B  48       9.189  23.939 175.284  1.00 18.91           C  
ATOM   1889  CG  LYS B  48       9.641  22.623 175.847  1.00 26.96           C  
ATOM   1890  CD  LYS B  48       8.535  21.949 176.632  1.00 28.73           C  
ATOM   1891  CE  LYS B  48       9.070  20.704 177.306  1.00 32.31           C  
ATOM   1892  NZ  LYS B  48      10.271  21.011 178.138  1.00 32.52           N  
ATOM   1893  N   PHE B  49       7.005  25.953 174.509  1.00 15.09           N  
ATOM   1894  CA  PHE B  49       5.907  26.856 174.848  1.00 15.31           C  
ATOM   1895  C   PHE B  49       4.678  26.474 174.040  1.00 14.66           C  
ATOM   1896  O   PHE B  49       3.561  26.400 174.556  1.00 14.31           O  
ATOM   1897  CB  PHE B  49       6.297  28.299 174.524  1.00 15.70           C  
ATOM   1898  CG  PHE B  49       5.167  29.277 174.666  1.00 18.53           C  
ATOM   1899  CD1 PHE B  49       4.835  29.807 175.907  1.00 19.66           C  
ATOM   1900  CD2 PHE B  49       4.427  29.663 173.553  1.00 17.40           C  
ATOM   1901  CE1 PHE B  49       3.780  30.713 176.039  1.00 20.73           C  
ATOM   1902  CE2 PHE B  49       3.370  30.565 173.675  1.00 19.66           C  
ATOM   1903  CZ  PHE B  49       3.049  31.091 174.924  1.00 20.71           C  
ATOM   1904  N   LEU B  50       4.881  26.239 172.750  1.00 13.76           N  
ATOM   1905  CA  LEU B  50       3.768  25.861 171.903  1.00 13.67           C  
ATOM   1906  C   LEU B  50       3.158  24.532 172.344  1.00 12.76           C  
ATOM   1907  O   LEU B  50       1.939  24.416 172.468  1.00 12.83           O  
ATOM   1908  CB  LEU B  50       4.222  25.774 170.442  1.00 14.02           C  
ATOM   1909  CG  LEU B  50       4.633  27.109 169.802  1.00 16.54           C  
ATOM   1910  CD1 LEU B  50       5.210  26.844 168.417  1.00 18.25           C  
ATOM   1911  CD2 LEU B  50       3.432  28.046 169.714  1.00 16.63           C  
ATOM   1912  N   GLN B  51       3.993  23.523 172.573  1.00 13.26           N  
ATOM   1913  CA  GLN B  51       3.460  22.226 172.985  1.00 12.01           C  
ATOM   1914  C   GLN B  51       2.676  22.355 174.303  1.00 10.20           C  
ATOM   1915  O   GLN B  51       1.530  21.915 174.392  1.00 11.79           O  
ATOM   1916  CB  GLN B  51       4.579  21.196 173.151  1.00 11.55           C  
ATOM   1917  CG  GLN B  51       4.037  19.794 173.400  1.00 16.19           C  
ATOM   1918  CD  GLN B  51       5.098  18.808 173.858  1.00 20.51           C  
ATOM   1919  OE1 GLN B  51       4.814  17.623 174.057  1.00 24.38           O  
ATOM   1920  NE2 GLN B  51       6.316  19.288 174.038  1.00 21.44           N  
ATOM   1921  N   LEU B  52       3.292  22.977 175.303  1.00 12.64           N  
ATOM   1922  CA  LEU B  52       2.652  23.163 176.609  1.00 13.94           C  
ATOM   1923  C   LEU B  52       1.337  23.935 176.498  1.00 14.00           C  
ATOM   1924  O   LEU B  52       0.328  23.534 177.078  1.00 14.76           O  
ATOM   1925  CB  LEU B  52       3.594  23.901 177.564  1.00 13.83           C  
ATOM   1926  CG  LEU B  52       4.884  23.178 177.978  1.00 13.63           C  
ATOM   1927  CD1 LEU B  52       5.741  24.096 178.832  1.00 16.38           C  
ATOM   1928  CD2 LEU B  52       4.542  21.904 178.737  1.00 14.91           C  
ATOM   1929  N   LEU B  53       1.337  25.036 175.749  1.00 11.88           N  
ATOM   1930  CA  LEU B  53       0.117  25.826 175.611  1.00 12.62           C  
ATOM   1931  C   LEU B  53      -0.982  25.021 174.934  1.00 11.51           C  
ATOM   1932  O   LEU B  53      -2.154  25.126 175.298  1.00 11.21           O  
ATOM   1933  CB  LEU B  53       0.382  27.117 174.831  1.00 10.87           C  
ATOM   1934  CG  LEU B  53      -0.730  28.161 174.990  1.00 12.35           C  
ATOM   1935  CD1 LEU B  53      -0.966  28.417 176.477  1.00 13.02           C  
ATOM   1936  CD2 LEU B  53      -0.343  29.464 174.284  1.00 12.63           C  
ATOM   1937  N   VAL B  54      -0.614  24.208 173.946  1.00 10.91           N  
ATOM   1938  CA  VAL B  54      -1.594  23.374 173.264  1.00 10.89           C  
ATOM   1939  C   VAL B  54      -2.179  22.406 174.303  1.00 10.56           C  
ATOM   1940  O   VAL B  54      -3.383  22.150 174.330  1.00 11.20           O  
ATOM   1941  CB  VAL B  54      -0.942  22.560 172.107  1.00 10.80           C  
ATOM   1942  CG1 VAL B  54      -1.823  21.391 171.711  1.00 14.34           C  
ATOM   1943  CG2 VAL B  54      -0.726  23.470 170.892  1.00 12.68           C  
ATOM   1944  N   GLN B  55      -1.315  21.893 175.170  1.00 12.30           N  
ATOM   1945  CA  GLN B  55      -1.743  20.948 176.197  1.00 13.76           C  
ATOM   1946  C   GLN B  55      -2.624  21.624 177.246  1.00 12.40           C  
ATOM   1947  O   GLN B  55      -3.643  21.073 177.659  1.00 15.98           O  
ATOM   1948  CB  GLN B  55      -0.514  20.308 176.860  1.00 16.48           C  
ATOM   1949  CG  GLN B  55       0.399  19.616 175.851  1.00 22.04           C  
ATOM   1950  CD  GLN B  55       1.492  18.769 176.480  1.00 24.24           C  
ATOM   1951  OE1 GLN B  55       2.122  19.168 177.458  1.00 25.76           O  
ATOM   1952  NE2 GLN B  55       1.734  17.596 175.902  1.00 23.98           N  
ATOM   1953  N   ILE B  56      -2.239  22.821 177.660  1.00 13.52           N  
ATOM   1954  CA  ILE B  56      -3.016  23.555 178.660  1.00 14.35           C  
ATOM   1955  C   ILE B  56      -4.402  23.838 178.113  1.00 15.00           C  
ATOM   1956  O   ILE B  56      -5.405  23.602 178.788  1.00 14.30           O  
ATOM   1957  CB  ILE B  56      -2.316  24.862 179.045  1.00 11.88           C  
ATOM   1958  CG1 ILE B  56      -1.023  24.536 179.782  1.00 12.27           C  
ATOM   1959  CG2 ILE B  56      -3.236  25.728 179.930  1.00 14.06           C  
ATOM   1960  CD1 ILE B  56      -0.160  25.721 180.048  1.00 11.88           C  
ATOM   1961  N   GLN B  57      -4.474  24.325 176.877  1.00 13.56           N  
ATOM   1962  CA  GLN B  57      -5.776  24.589 176.289  1.00 15.77           C  
ATOM   1963  C   GLN B  57      -6.531  23.309 175.950  1.00 16.09           C  
ATOM   1964  O   GLN B  57      -7.759  23.289 175.965  1.00 19.14           O  
ATOM   1965  CB  GLN B  57      -5.661  25.427 175.008  1.00 16.57           C  
ATOM   1966  CG  GLN B  57      -7.034  25.676 174.384  1.00 21.93           C  
ATOM   1967  CD  GLN B  57      -6.969  26.287 173.012  1.00 22.27           C  
ATOM   1968  OE1 GLN B  57      -6.062  25.985 172.233  1.00 24.21           O  
ATOM   1969  NE2 GLN B  57      -7.943  27.135 172.692  1.00 18.96           N  
ATOM   1970  N   GLY B  58      -5.803  22.235 175.657  1.00 14.64           N  
ATOM   1971  CA  GLY B  58      -6.454  20.994 175.277  1.00 13.45           C  
ATOM   1972  C   GLY B  58      -6.897  21.102 173.823  1.00 13.68           C  
ATOM   1973  O   GLY B  58      -7.932  20.568 173.425  1.00 12.79           O  
ATOM   1974  N   ALA B  59      -6.105  21.813 173.026  1.00 14.28           N  
ATOM   1975  CA  ALA B  59      -6.410  22.012 171.607  1.00 15.15           C  
ATOM   1976  C   ALA B  59      -6.509  20.694 170.840  1.00 16.51           C  
ATOM   1977  O   ALA B  59      -5.733  19.775 171.084  1.00 17.35           O  
ATOM   1978  CB  ALA B  59      -5.337  22.902 170.985  1.00 13.09           C  
ATOM   1979  N   ARG B  60      -7.456  20.619 169.906  1.00 15.85           N  
ATOM   1980  CA  ARG B  60      -7.670  19.414 169.098  1.00 18.40           C  
ATOM   1981  C   ARG B  60      -7.639  19.697 167.593  1.00 17.84           C  
ATOM   1982  O   ARG B  60      -7.448  18.790 166.785  1.00 17.21           O  
ATOM   1983  CB  ARG B  60      -9.022  18.792 169.433  1.00 21.78           C  
ATOM   1984  CG  ARG B  60      -9.215  17.387 168.903  1.00 28.33           C  
ATOM   1985  CD  ARG B  60      -9.280  16.403 170.063  1.00 32.84           C  
ATOM   1986  NE  ARG B  60     -10.223  16.870 171.076  1.00 34.90           N  
ATOM   1987  CZ  ARG B  60     -10.297  16.393 172.314  1.00 34.15           C  
ATOM   1988  NH1 ARG B  60      -9.484  15.423 172.706  1.00 34.80           N  
ATOM   1989  NH2 ARG B  60     -11.180  16.899 173.163  1.00 35.51           N  
ATOM   1990  N   ASN B  61      -7.854  20.950 167.222  1.00 17.89           N  
ATOM   1991  CA  ASN B  61      -7.868  21.329 165.811  1.00 17.12           C  
ATOM   1992  C   ASN B  61      -6.937  22.529 165.674  1.00 15.38           C  
ATOM   1993  O   ASN B  61      -7.305  23.658 165.992  1.00 15.70           O  
ATOM   1994  CB  ASN B  61      -9.304  21.664 165.407  1.00 18.04           C  
ATOM   1995  CG  ASN B  61      -9.449  21.939 163.927  1.00 21.48           C  
ATOM   1996  OD1 ASN B  61      -8.816  21.286 163.098  1.00 23.36           O  
ATOM   1997  ND2 ASN B  61     -10.303  22.900 163.584  1.00 22.84           N  
ATOM   1998  N   ILE B  62      -5.719  22.276 165.193  1.00 13.74           N  
ATOM   1999  CA  ILE B  62      -4.714  23.319 165.074  1.00 10.63           C  
ATOM   2000  C   ILE B  62      -4.400  23.738 163.639  1.00 13.49           C  
ATOM   2001  O   ILE B  62      -4.373  22.906 162.741  1.00 13.88           O  
ATOM   2002  CB  ILE B  62      -3.381  22.863 165.722  1.00 12.81           C  
ATOM   2003  CG1 ILE B  62      -3.602  22.549 167.212  1.00 14.49           C  
ATOM   2004  CG2 ILE B  62      -2.326  23.924 165.552  1.00 12.88           C  
ATOM   2005  CD1 ILE B  62      -2.339  22.075 167.942  1.00 14.99           C  
ATOM   2006  N   LEU B  63      -4.160  25.029 163.455  1.00 13.04           N  
ATOM   2007  CA  LEU B  63      -3.792  25.572 162.148  1.00 14.57           C  
ATOM   2008  C   LEU B  63      -2.437  26.256 162.276  1.00 13.52           C  
ATOM   2009  O   LEU B  63      -2.227  27.068 163.178  1.00 11.55           O  
ATOM   2010  CB  LEU B  63      -4.827  26.599 161.664  1.00 14.36           C  
ATOM   2011  CG  LEU B  63      -4.481  27.348 160.365  1.00 17.30           C  
ATOM   2012  CD1 LEU B  63      -4.439  26.356 159.211  1.00 17.26           C  
ATOM   2013  CD2 LEU B  63      -5.517  28.430 160.078  1.00 16.37           C  
ATOM   2014  N   GLU B  64      -1.509  25.937 161.369  1.00 12.52           N  
ATOM   2015  CA  GLU B  64      -0.206  26.578 161.372  1.00 12.52           C  
ATOM   2016  C   GLU B  64      -0.002  27.214 159.992  1.00 13.53           C  
ATOM   2017  O   GLU B  64      -0.238  26.570 158.965  1.00 13.17           O  
ATOM   2018  CB  GLU B  64       0.947  25.587 161.633  1.00 15.48           C  
ATOM   2019  CG  GLU B  64       2.315  26.261 161.525  1.00 15.09           C  
ATOM   2020  CD  GLU B  64       3.500  25.296 161.579  1.00 16.36           C  
ATOM   2021  OE1 GLU B  64       3.378  24.157 161.083  1.00 18.50           O  
ATOM   2022  OE2 GLU B  64       4.560  25.697 162.099  1.00 18.21           O  
ATOM   2023  N   ILE B  65       0.426  28.469 159.988  1.00 14.22           N  
ATOM   2024  CA  ILE B  65       0.665  29.198 158.747  1.00 17.40           C  
ATOM   2025  C   ILE B  65       2.168  29.443 158.648  1.00 16.69           C  
ATOM   2026  O   ILE B  65       2.734  30.247 159.388  1.00 16.30           O  
ATOM   2027  CB  ILE B  65      -0.115  30.549 158.734  1.00 17.48           C  
ATOM   2028  CG1 ILE B  65      -1.615  30.281 158.925  1.00 19.55           C  
ATOM   2029  CG2 ILE B  65       0.128  31.289 157.413  1.00 18.48           C  
ATOM   2030  CD1 ILE B  65      -2.469  31.541 159.135  1.00 20.13           C  
ATOM   2031  N   GLY B  66       2.818  28.723 157.735  1.00 18.46           N  
ATOM   2032  CA  GLY B  66       4.252  28.860 157.570  1.00 18.38           C  
ATOM   2033  C   GLY B  66       4.999  27.623 158.052  1.00 20.05           C  
ATOM   2034  O   GLY B  66       5.830  27.702 158.951  1.00 23.20           O  
ATOM   2035  N   THR B  67       4.713  26.484 157.434  1.00 20.42           N  
ATOM   2036  CA  THR B  67       5.328  25.208 157.802  1.00 20.58           C  
ATOM   2037  C   THR B  67       6.850  25.175 157.808  1.00 21.02           C  
ATOM   2038  O   THR B  67       7.462  24.622 158.723  1.00 21.94           O  
ATOM   2039  CB  THR B  67       4.869  24.082 156.865  1.00 17.91           C  
ATOM   2040  OG1 THR B  67       3.454  24.148 156.688  1.00 17.18           O  
ATOM   2041  CG2 THR B  67       5.242  22.723 157.446  1.00 20.03           C  
ATOM   2042  N   LEU B  68       7.467  25.761 156.784  1.00 21.38           N  
ATOM   2043  CA  LEU B  68       8.919  25.747 156.671  1.00 22.89           C  
ATOM   2044  C   LEU B  68       9.380  24.290 156.669  1.00 21.65           C  
ATOM   2045  O   LEU B  68       8.894  23.492 155.873  1.00 22.26           O  
ATOM   2046  CB  LEU B  68       9.577  26.505 157.830  1.00 23.01           C  
ATOM   2047  CG  LEU B  68       9.502  28.035 157.814  1.00 25.15           C  
ATOM   2048  CD1 LEU B  68      10.234  28.602 159.033  1.00 27.12           C  
ATOM   2049  CD2 LEU B  68      10.126  28.562 156.527  1.00 26.18           C  
ATOM   2050  N   GLY B  69      10.288  23.946 157.579  1.00 22.15           N  
ATOM   2051  CA  GLY B  69      10.795  22.584 157.651  1.00 21.88           C  
ATOM   2052  C   GLY B  69      10.025  21.647 158.567  1.00 22.20           C  
ATOM   2053  O   GLY B  69      10.381  20.474 158.698  1.00 21.86           O  
ATOM   2054  N   GLY B  70       8.981  22.164 159.214  1.00 19.22           N  
ATOM   2055  CA  GLY B  70       8.170  21.338 160.090  1.00 18.73           C  
ATOM   2056  C   GLY B  70       8.601  21.280 161.546  1.00 15.78           C  
ATOM   2057  O   GLY B  70       7.992  20.544 162.339  1.00 18.05           O  
ATOM   2058  N   TYR B  71       9.630  22.038 161.908  1.00 17.03           N  
ATOM   2059  CA  TYR B  71      10.124  22.050 163.285  1.00 17.40           C  
ATOM   2060  C   TYR B  71       9.005  22.428 164.265  1.00 17.99           C  
ATOM   2061  O   TYR B  71       8.704  21.691 165.208  1.00 15.33           O  
ATOM   2062  CB  TYR B  71      11.273  23.044 163.432  1.00 17.62           C  
ATOM   2063  CG  TYR B  71      11.897  23.072 164.811  1.00 18.79           C  
ATOM   2064  CD1 TYR B  71      12.844  22.120 165.191  1.00 18.71           C  
ATOM   2065  CD2 TYR B  71      11.555  24.063 165.731  1.00 17.39           C  
ATOM   2066  CE1 TYR B  71      13.445  22.162 166.460  1.00 20.57           C  
ATOM   2067  CE2 TYR B  71      12.141  24.111 166.998  1.00 20.25           C  
ATOM   2068  CZ  TYR B  71      13.086  23.163 167.357  1.00 19.98           C  
ATOM   2069  OH  TYR B  71      13.676  23.230 168.605  1.00 19.79           O  
ATOM   2070  N   SER B  72       8.384  23.580 164.041  1.00 16.84           N  
ATOM   2071  CA  SER B  72       7.308  24.005 164.927  1.00 15.02           C  
ATOM   2072  C   SER B  72       6.089  23.105 164.801  1.00 14.64           C  
ATOM   2073  O   SER B  72       5.352  22.915 165.772  1.00 16.02           O  
ATOM   2074  CB  SER B  72       6.953  25.472 164.661  1.00 13.31           C  
ATOM   2075  OG  SER B  72       7.959  26.311 165.196  1.00 15.83           O  
ATOM   2076  N   THR B  73       5.874  22.527 163.618  1.00 13.85           N  
ATOM   2077  CA  THR B  73       4.745  21.630 163.404  1.00 14.21           C  
ATOM   2078  C   THR B  73       4.868  20.446 164.363  1.00 14.39           C  
ATOM   2079  O   THR B  73       3.880  19.988 164.939  1.00 13.38           O  
ATOM   2080  CB  THR B  73       4.725  21.060 161.963  1.00 14.33           C  
ATOM   2081  OG1 THR B  73       5.032  22.102 161.032  1.00 15.95           O  
ATOM   2082  CG2 THR B  73       3.357  20.476 161.634  1.00 15.69           C  
ATOM   2083  N   ILE B  74       6.093  19.954 164.521  1.00 14.85           N  
ATOM   2084  CA  ILE B  74       6.356  18.816 165.395  1.00 15.96           C  
ATOM   2085  C   ILE B  74       5.972  19.143 166.835  1.00 15.70           C  
ATOM   2086  O   ILE B  74       5.237  18.380 167.468  1.00 13.81           O  
ATOM   2087  CB  ILE B  74       7.840  18.412 165.331  1.00 17.16           C  
ATOM   2088  CG1 ILE B  74       8.188  17.987 163.903  1.00 21.15           C  
ATOM   2089  CG2 ILE B  74       8.124  17.264 166.293  1.00 18.39           C  
ATOM   2090  CD1 ILE B  74       7.276  16.923 163.351  1.00 21.25           C  
ATOM   2091  N   TRP B  75       6.465  20.272 167.335  1.00 14.50           N  
ATOM   2092  CA  TRP B  75       6.149  20.704 168.702  1.00 15.12           C  
ATOM   2093  C   TRP B  75       4.636  20.838 168.915  1.00 15.08           C  
ATOM   2094  O   TRP B  75       4.102  20.415 169.941  1.00 15.20           O  
ATOM   2095  CB  TRP B  75       6.831  22.034 169.021  1.00 13.26           C  
ATOM   2096  CG  TRP B  75       8.282  21.923 169.342  1.00 15.36           C  
ATOM   2097  CD1 TRP B  75       9.336  22.316 168.558  1.00 12.01           C  
ATOM   2098  CD2 TRP B  75       8.848  21.440 170.562  1.00 16.00           C  
ATOM   2099  NE1 TRP B  75      10.522  22.115 169.227  1.00 14.40           N  
ATOM   2100  CE2 TRP B  75      10.251  21.577 170.459  1.00 16.07           C  
ATOM   2101  CE3 TRP B  75       8.304  20.904 171.741  1.00 18.20           C  
ATOM   2102  CZ2 TRP B  75      11.118  21.199 171.486  1.00 17.10           C  
ATOM   2103  CZ3 TRP B  75       9.166  20.529 172.759  1.00 17.04           C  
ATOM   2104  CH2 TRP B  75      10.560  20.678 172.626  1.00 17.72           C  
ATOM   2105  N   LEU B  76       3.940  21.425 167.946  1.00 15.05           N  
ATOM   2106  CA  LEU B  76       2.491  21.569 168.055  1.00 14.39           C  
ATOM   2107  C   LEU B  76       1.787  20.210 168.082  1.00 16.87           C  
ATOM   2108  O   LEU B  76       0.961  19.946 168.968  1.00 14.81           O  
ATOM   2109  CB  LEU B  76       1.947  22.397 166.881  1.00 16.46           C  
ATOM   2110  CG  LEU B  76       2.301  23.882 166.837  1.00 13.45           C  
ATOM   2111  CD1 LEU B  76       2.010  24.429 165.448  1.00 13.65           C  
ATOM   2112  CD2 LEU B  76       1.485  24.644 167.889  1.00 13.57           C  
ATOM   2113  N   ALA B  77       2.119  19.339 167.127  1.00 12.03           N  
ATOM   2114  CA  ALA B  77       1.487  18.028 167.046  1.00 15.17           C  
ATOM   2115  C   ALA B  77       1.748  17.181 168.287  1.00 15.55           C  
ATOM   2116  O   ALA B  77       0.917  16.349 168.658  1.00 15.95           O  
ATOM   2117  CB  ALA B  77       1.958  17.283 165.789  1.00 14.29           C  
ATOM   2118  N   ARG B  78       2.899  17.397 168.910  1.00 16.91           N  
ATOM   2119  CA  ARG B  78       3.278  16.675 170.124  1.00 19.22           C  
ATOM   2120  C   ARG B  78       2.351  17.067 171.274  1.00 19.64           C  
ATOM   2121  O   ARG B  78       2.260  16.356 172.276  1.00 18.63           O  
ATOM   2122  CB  ARG B  78       4.713  17.023 170.516  1.00 22.11           C  
ATOM   2123  CG  ARG B  78       5.823  16.236 169.827  1.00 25.02           C  
ATOM   2124  CD  ARG B  78       7.072  17.100 169.799  1.00 28.77           C  
ATOM   2125  NE  ARG B  78       8.351  16.401 169.928  1.00 32.10           N  
ATOM   2126  CZ  ARG B  78       8.678  15.267 169.317  1.00 33.26           C  
ATOM   2127  NH1 ARG B  78       7.814  14.650 168.520  1.00 34.31           N  
ATOM   2128  NH2 ARG B  78       9.897  14.770 169.476  1.00 32.48           N  
ATOM   2129  N   GLY B  79       1.676  18.206 171.126  1.00 18.06           N  
ATOM   2130  CA  GLY B  79       0.772  18.674 172.161  1.00 20.54           C  
ATOM   2131  C   GLY B  79      -0.642  18.126 172.066  1.00 20.28           C  
ATOM   2132  O   GLY B  79      -1.421  18.259 173.006  1.00 18.00           O  
ATOM   2133  N   LEU B  80      -0.981  17.526 170.930  1.00 22.57           N  
ATOM   2134  CA  LEU B  80      -2.306  16.957 170.734  1.00 26.74           C  
ATOM   2135  C   LEU B  80      -2.431  15.708 171.604  1.00 29.82           C  
ATOM   2136  O   LEU B  80      -1.444  15.218 172.143  1.00 32.14           O  
ATOM   2137  CB  LEU B  80      -2.507  16.576 169.262  1.00 25.06           C  
ATOM   2138  CG  LEU B  80      -2.457  17.715 168.237  1.00 24.54           C  
ATOM   2139  CD1 LEU B  80      -2.375  17.136 166.825  1.00 23.22           C  
ATOM   2140  CD2 LEU B  80      -3.691  18.591 168.381  1.00 23.03           C  
ATOM   2141  N   SER B  81      -3.645  15.190 171.722  1.00 34.19           N  
ATOM   2142  CA  SER B  81      -3.885  13.999 172.530  1.00 38.33           C  
ATOM   2143  C   SER B  81      -4.626  12.916 171.743  1.00 39.94           C  
ATOM   2144  O   SER B  81      -4.010  12.063 171.104  1.00 41.39           O  
ATOM   2145  CB  SER B  81      -4.698  14.374 173.769  1.00 39.15           C  
ATOM   2146  OG  SER B  81      -5.936  14.952 173.388  1.00 41.20           O  
ATOM   2147  N   SER B  82      -5.954  12.965 171.804  1.00 41.18           N  
ATOM   2148  CA  SER B  82      -6.834  12.011 171.125  1.00 40.72           C  
ATOM   2149  C   SER B  82      -6.614  11.964 169.622  1.00 39.49           C  
ATOM   2150  O   SER B  82      -5.523  11.657 169.142  1.00 40.51           O  
ATOM   2151  CB  SER B  82      -8.290  12.396 171.374  1.00 41.92           C  
ATOM   2152  OG  SER B  82      -8.597  13.594 170.668  1.00 41.95           O  
ATOM   2153  N   GLY B  83      -7.687  12.252 168.891  1.00 37.48           N  
ATOM   2154  CA  GLY B  83      -7.637  12.277 167.444  1.00 34.11           C  
ATOM   2155  C   GLY B  83      -7.561  13.720 166.984  1.00 32.29           C  
ATOM   2156  O   GLY B  83      -8.352  14.166 166.146  1.00 31.69           O  
ATOM   2157  N   GLY B  84      -6.610  14.457 167.550  1.00 29.57           N  
ATOM   2158  CA  GLY B  84      -6.431  15.848 167.184  1.00 26.50           C  
ATOM   2159  C   GLY B  84      -5.741  15.950 165.838  1.00 25.06           C  
ATOM   2160  O   GLY B  84      -5.269  14.946 165.299  1.00 23.40           O  
ATOM   2161  N   ARG B  85      -5.687  17.157 165.290  1.00 22.54           N  
ATOM   2162  CA  ARG B  85      -5.043  17.357 163.998  1.00 23.53           C  
ATOM   2163  C   ARG B  85      -4.394  18.728 163.892  1.00 20.61           C  
ATOM   2164  O   ARG B  85      -4.792  19.682 164.563  1.00 18.34           O  
ATOM   2165  CB  ARG B  85      -6.063  17.215 162.861  1.00 24.58           C  
ATOM   2166  CG  ARG B  85      -6.956  18.438 162.698  1.00 29.75           C  
ATOM   2167  CD  ARG B  85      -7.715  18.442 161.375  1.00 33.74           C  
ATOM   2168  NE  ARG B  85      -8.796  17.464 161.369  1.00 38.35           N  
ATOM   2169  CZ  ARG B  85      -9.675  17.321 160.381  1.00 39.75           C  
ATOM   2170  NH1 ARG B  85      -9.604  18.096 159.306  1.00 41.55           N  
ATOM   2171  NH2 ARG B  85     -10.634  16.409 160.476  1.00 40.63           N  
ATOM   2172  N   VAL B  86      -3.373  18.807 163.048  1.00 18.75           N  
ATOM   2173  CA  VAL B  86      -2.676  20.051 162.772  1.00 17.69           C  
ATOM   2174  C   VAL B  86      -2.735  20.189 161.242  1.00 17.97           C  
ATOM   2175  O   VAL B  86      -2.414  19.248 160.526  1.00 17.57           O  
ATOM   2176  CB  VAL B  86      -1.185  20.000 163.192  1.00 17.97           C  
ATOM   2177  CG1 VAL B  86      -0.474  21.245 162.702  1.00 17.62           C  
ATOM   2178  CG2 VAL B  86      -1.050  19.874 164.720  1.00 18.38           C  
ATOM   2179  N   VAL B  87      -3.199  21.333 160.758  1.00 17.17           N  
ATOM   2180  CA  VAL B  87      -3.237  21.590 159.316  1.00 17.47           C  
ATOM   2181  C   VAL B  87      -2.198  22.679 159.178  1.00 16.98           C  
ATOM   2182  O   VAL B  87      -2.307  23.727 159.807  1.00 16.48           O  
ATOM   2183  CB  VAL B  87      -4.608  22.120 158.847  1.00 18.81           C  
ATOM   2184  CG1 VAL B  87      -4.555  22.443 157.352  1.00 20.27           C  
ATOM   2185  CG2 VAL B  87      -5.687  21.089 159.132  1.00 19.32           C  
ATOM   2186  N   THR B  88      -1.169  22.440 158.371  1.00 15.71           N  
ATOM   2187  CA  THR B  88      -0.115  23.426 158.243  1.00 16.15           C  
ATOM   2188  C   THR B  88       0.057  23.806 156.779  1.00 16.30           C  
ATOM   2189  O   THR B  88      -0.005  22.953 155.904  1.00 17.25           O  
ATOM   2190  CB  THR B  88       1.189  22.880 158.851  1.00 15.42           C  
ATOM   2191  OG1 THR B  88       2.171  23.916 158.895  1.00 18.21           O  
ATOM   2192  CG2 THR B  88       1.704  21.696 158.059  1.00 18.46           C  
ATOM   2193  N   LEU B  89       0.239  25.099 156.541  1.00 16.88           N  
ATOM   2194  CA  LEU B  89       0.367  25.631 155.186  1.00 19.45           C  
ATOM   2195  C   LEU B  89       1.768  26.087 154.809  1.00 18.50           C  
ATOM   2196  O   LEU B  89       2.450  26.758 155.574  1.00 18.90           O  
ATOM   2197  CB  LEU B  89      -0.597  26.811 155.014  1.00 19.12           C  
ATOM   2198  CG  LEU B  89      -1.973  26.746 155.687  1.00 19.81           C  
ATOM   2199  CD1 LEU B  89      -2.694  28.075 155.436  1.00 20.55           C  
ATOM   2200  CD2 LEU B  89      -2.785  25.588 155.165  1.00 20.31           C  
ATOM   2201  N   GLU B  90       2.186  25.724 153.600  1.00 22.19           N  
ATOM   2202  CA  GLU B  90       3.486  26.123 153.084  1.00 23.45           C  
ATOM   2203  C   GLU B  90       3.377  26.260 151.573  1.00 22.99           C  
ATOM   2204  O   GLU B  90       2.862  25.368 150.908  1.00 22.19           O  
ATOM   2205  CB  GLU B  90       4.555  25.092 153.433  1.00 25.94           C  
ATOM   2206  CG  GLU B  90       5.908  25.434 152.830  1.00 29.93           C  
ATOM   2207  CD  GLU B  90       7.053  24.932 153.669  1.00 31.92           C  
ATOM   2208  OE1 GLU B  90       7.065  23.725 153.991  1.00 34.25           O  
ATOM   2209  OE2 GLU B  90       7.939  25.746 154.006  1.00 33.49           O  
ATOM   2210  N   ALA B  91       3.853  27.383 151.038  1.00 24.68           N  
ATOM   2211  CA  ALA B  91       3.776  27.638 149.600  1.00 26.56           C  
ATOM   2212  C   ALA B  91       4.752  26.795 148.776  1.00 27.08           C  
ATOM   2213  O   ALA B  91       4.357  26.148 147.803  1.00 27.85           O  
ATOM   2214  CB  ALA B  91       4.013  29.129 149.325  1.00 26.45           C  
ATOM   2215  N   SER B  92       6.018  26.805 149.177  1.00 28.33           N  
ATOM   2216  CA  SER B  92       7.069  26.061 148.481  1.00 28.54           C  
ATOM   2217  C   SER B  92       6.829  24.557 148.439  1.00 29.50           C  
ATOM   2218  O   SER B  92       6.749  23.908 149.481  1.00 27.52           O  
ATOM   2219  CB  SER B  92       8.425  26.334 149.139  1.00 29.48           C  
ATOM   2220  OG  SER B  92       9.454  25.533 148.573  1.00 25.21           O  
ATOM   2221  N   GLU B  93       6.717  24.006 147.233  1.00 28.63           N  
ATOM   2222  CA  GLU B  93       6.511  22.570 147.066  1.00 30.52           C  
ATOM   2223  C   GLU B  93       7.699  21.837 147.670  1.00 30.23           C  
ATOM   2224  O   GLU B  93       7.534  20.870 148.413  1.00 30.05           O  
ATOM   2225  CB  GLU B  93       6.418  22.198 145.587  1.00 33.50           C  
ATOM   2226  CG  GLU B  93       5.246  22.801 144.842  1.00 38.33           C  
ATOM   2227  CD  GLU B  93       5.280  22.454 143.366  1.00 41.37           C  
ATOM   2228  OE1 GLU B  93       5.392  21.249 143.049  1.00 43.28           O  
ATOM   2229  OE2 GLU B  93       5.200  23.380 142.527  1.00 43.22           O  
ATOM   2230  N   LYS B  94       8.898  22.307 147.337  1.00 29.15           N  
ATOM   2231  CA  LYS B  94      10.127  21.703 147.835  1.00 28.78           C  
ATOM   2232  C   LYS B  94      10.189  21.672 149.356  1.00 28.60           C  
ATOM   2233  O   LYS B  94      10.343  20.615 149.967  1.00 28.14           O  
ATOM   2234  CB  LYS B  94      11.343  22.465 147.313  1.00 28.32           C  
ATOM   2235  CG  LYS B  94      12.653  22.027 147.951  1.00 28.57           C  
ATOM   2236  CD  LYS B  94      13.824  22.864 147.465  1.00 28.95           C  
ATOM   2237  CE  LYS B  94      15.109  22.453 148.168  1.00 29.34           C  
ATOM   2238  NZ  LYS B  94      16.257  23.299 147.772  1.00 28.29           N  
ATOM   2239  N   HIS B  95      10.076  22.844 149.960  1.00 27.63           N  
ATOM   2240  CA  HIS B  95      10.145  22.957 151.408  1.00 29.11           C  
ATOM   2241  C   HIS B  95       9.056  22.163 152.128  1.00 29.48           C  
ATOM   2242  O   HIS B  95       9.289  21.630 153.216  1.00 29.62           O  
ATOM   2243  CB  HIS B  95      10.132  24.438 151.783  1.00 29.96           C  
ATOM   2244  CG  HIS B  95      11.343  25.174 151.302  1.00 30.21           C  
ATOM   2245  ND1 HIS B  95      11.448  26.548 151.332  1.00 30.52           N  
ATOM   2246  CD2 HIS B  95      12.514  24.719 150.795  1.00 31.26           C  
ATOM   2247  CE1 HIS B  95      12.631  26.907 150.866  1.00 31.35           C  
ATOM   2248  NE2 HIS B  95      13.298  25.815 150.534  1.00 32.10           N  
ATOM   2249  N   ALA B  96       7.882  22.056 151.513  1.00 29.82           N  
ATOM   2250  CA  ALA B  96       6.787  21.296 152.110  1.00 29.44           C  
ATOM   2251  C   ALA B  96       7.074  19.794 152.023  1.00 29.72           C  
ATOM   2252  O   ALA B  96       6.653  19.023 152.891  1.00 29.52           O  
ATOM   2253  CB  ALA B  96       5.462  21.629 151.407  1.00 30.48           C  
ATOM   2254  N   ASP B  97       7.789  19.374 150.978  1.00 29.01           N  
ATOM   2255  CA  ASP B  97       8.125  17.955 150.810  1.00 27.99           C  
ATOM   2256  C   ASP B  97       9.121  17.517 151.881  1.00 25.07           C  
ATOM   2257  O   ASP B  97       9.045  16.401 152.408  1.00 25.25           O  
ATOM   2258  CB  ASP B  97       8.719  17.692 149.422  1.00 31.14           C  
ATOM   2259  CG  ASP B  97       7.688  17.794 148.314  1.00 34.77           C  
ATOM   2260  OD1 ASP B  97       6.551  17.307 148.511  1.00 36.88           O  
ATOM   2261  OD2 ASP B  97       8.018  18.343 147.239  1.00 35.95           O  
ATOM   2262  N   ILE B  98      10.058  18.401 152.185  1.00 22.16           N  
ATOM   2263  CA  ILE B  98      11.065  18.145 153.200  1.00 21.27           C  
ATOM   2264  C   ILE B  98      10.377  18.154 154.563  1.00 22.28           C  
ATOM   2265  O   ILE B  98      10.729  17.388 155.461  1.00 20.84           O  
ATOM   2266  CB  ILE B  98      12.136  19.233 153.167  1.00 21.38           C  
ATOM   2267  CG1 ILE B  98      12.907  19.136 151.846  1.00 19.55           C  
ATOM   2268  CG2 ILE B  98      13.054  19.114 154.369  1.00 16.64           C  
ATOM   2269  CD1 ILE B  98      13.868  20.255 151.624  1.00 23.90           C  
ATOM   2270  N   ALA B  99       9.388  19.029 154.708  1.00 21.51           N  
ATOM   2271  CA  ALA B  99       8.652  19.130 155.960  1.00 22.77           C  
ATOM   2272  C   ALA B  99       7.863  17.856 156.234  1.00 22.58           C  
ATOM   2273  O   ALA B  99       7.898  17.336 157.353  1.00 21.73           O  
ATOM   2274  CB  ALA B  99       7.709  20.337 155.925  1.00 21.98           C  
ATOM   2275  N   ARG B 100       7.153  17.344 155.232  1.00 22.32           N  
ATOM   2276  CA  ARG B 100       6.380  16.131 155.448  1.00 24.27           C  
ATOM   2277  C   ARG B 100       7.295  14.956 155.772  1.00 24.36           C  
ATOM   2278  O   ARG B 100       6.882  14.000 156.429  1.00 24.28           O  
ATOM   2279  CB  ARG B 100       5.488  15.807 154.242  1.00 27.60           C  
ATOM   2280  CG  ARG B 100       6.187  15.645 152.914  1.00 32.05           C  
ATOM   2281  CD  ARG B 100       5.250  14.963 151.921  1.00 35.51           C  
ATOM   2282  NE  ARG B 100       3.890  15.503 151.961  1.00 37.31           N  
ATOM   2283  CZ  ARG B 100       3.522  16.674 151.450  1.00 39.26           C  
ATOM   2284  NH1 ARG B 100       4.412  17.452 150.843  1.00 40.66           N  
ATOM   2285  NH2 ARG B 100       2.261  17.071 151.552  1.00 38.68           N  
ATOM   2286  N   SER B 101       8.542  15.038 155.321  1.00 24.23           N  
ATOM   2287  CA  SER B 101       9.523  13.992 155.589  1.00 24.30           C  
ATOM   2288  C   SER B 101       9.983  14.091 157.045  1.00 24.22           C  
ATOM   2289  O   SER B 101      10.139  13.076 157.729  1.00 24.17           O  
ATOM   2290  CB  SER B 101      10.729  14.145 154.664  1.00 25.50           C  
ATOM   2291  OG  SER B 101      11.742  13.223 155.011  1.00 26.66           O  
ATOM   2292  N   ASN B 102      10.206  15.318 157.511  1.00 23.22           N  
ATOM   2293  CA  ASN B 102      10.634  15.541 158.891  1.00 23.23           C  
ATOM   2294  C   ASN B 102       9.517  15.150 159.852  1.00 23.51           C  
ATOM   2295  O   ASN B 102       9.766  14.554 160.902  1.00 23.53           O  
ATOM   2296  CB  ASN B 102      11.018  17.008 159.113  1.00 22.18           C  
ATOM   2297  CG  ASN B 102      12.357  17.366 158.491  1.00 23.85           C  
ATOM   2298  OD1 ASN B 102      13.260  16.532 158.409  1.00 22.51           O  
ATOM   2299  ND2 ASN B 102      12.497  18.616 158.072  1.00 20.51           N  
ATOM   2300  N   ILE B 103       8.286  15.491 159.485  1.00 24.14           N  
ATOM   2301  CA  ILE B 103       7.114  15.164 160.295  1.00 24.73           C  
ATOM   2302  C   ILE B 103       7.003  13.647 160.376  1.00 26.34           C  
ATOM   2303  O   ILE B 103       6.669  13.078 161.419  1.00 24.58           O  
ATOM   2304  CB  ILE B 103       5.823  15.715 159.643  1.00 24.14           C  
ATOM   2305  CG1 ILE B 103       5.840  17.244 159.656  1.00 24.33           C  
ATOM   2306  CG2 ILE B 103       4.594  15.194 160.379  1.00 24.29           C  
ATOM   2307  CD1 ILE B 103       4.624  17.865 158.980  1.00 24.97           C  
ATOM   2308  N   GLU B 104       7.295  12.998 159.255  1.00 26.41           N  
ATOM   2309  CA  GLU B 104       7.222  11.550 159.166  1.00 28.59           C  
ATOM   2310  C   GLU B 104       8.226  10.871 160.089  1.00 28.40           C  
ATOM   2311  O   GLU B 104       7.891   9.901 160.768  1.00 27.78           O  
ATOM   2312  CB  GLU B 104       7.463  11.114 157.724  1.00 30.15           C  
ATOM   2313  CG  GLU B 104       6.835   9.787 157.367  1.00 35.42           C  
ATOM   2314  CD  GLU B 104       6.746   9.597 155.868  1.00 39.16           C  
ATOM   2315  OE1 GLU B 104       7.794   9.334 155.237  1.00 39.87           O  
ATOM   2316  OE2 GLU B 104       5.627   9.735 155.322  1.00 40.34           O  
ATOM   2317  N   ARG B 105       9.456  11.371 160.124  1.00 29.04           N  
ATOM   2318  CA  ARG B 105      10.447  10.751 160.992  1.00 31.38           C  
ATOM   2319  C   ARG B 105      10.139  10.985 162.472  1.00 31.71           C  
ATOM   2320  O   ARG B 105      10.744  10.364 163.343  1.00 30.86           O  
ATOM   2321  CB  ARG B 105      11.859  11.231 160.640  1.00 32.36           C  
ATOM   2322  CG  ARG B 105      12.149  12.688 160.875  1.00 34.93           C  
ATOM   2323  CD  ARG B 105      13.458  13.061 160.198  1.00 36.59           C  
ATOM   2324  NE  ARG B 105      14.532  12.150 160.571  1.00 37.06           N  
ATOM   2325  CZ  ARG B 105      15.405  11.628 159.713  1.00 37.25           C  
ATOM   2326  NH1 ARG B 105      15.339  11.927 158.421  1.00 36.48           N  
ATOM   2327  NH2 ARG B 105      16.341  10.797 160.149  1.00 35.60           N  
ATOM   2328  N   ALA B 106       9.191  11.878 162.756  1.00 31.12           N  
ATOM   2329  CA  ALA B 106       8.796  12.136 164.135  1.00 31.49           C  
ATOM   2330  C   ALA B 106       7.529  11.321 164.404  1.00 31.15           C  
ATOM   2331  O   ALA B 106       6.916  11.435 165.461  1.00 31.51           O  
ATOM   2332  CB  ALA B 106       8.532  13.636 164.353  1.00 30.40           C  
ATOM   2333  N   ASN B 107       7.156  10.496 163.429  1.00 31.25           N  
ATOM   2334  CA  ASN B 107       5.971   9.640 163.506  1.00 31.95           C  
ATOM   2335  C   ASN B 107       4.698  10.402 163.859  1.00 32.02           C  
ATOM   2336  O   ASN B 107       3.855   9.904 164.609  1.00 31.14           O  
ATOM   2337  CB  ASN B 107       6.187   8.506 164.521  1.00 33.97           C  
ATOM   2338  CG  ASN B 107       7.398   7.655 164.193  1.00 36.08           C  
ATOM   2339  OD1 ASN B 107       8.495   7.890 164.704  1.00 38.39           O  
ATOM   2340  ND2 ASN B 107       7.211   6.669 163.319  1.00 36.34           N  
ATOM   2341  N   LEU B 108       4.559  11.605 163.307  1.00 31.74           N  
ATOM   2342  CA  LEU B 108       3.386  12.440 163.560  1.00 30.86           C  
ATOM   2343  C   LEU B 108       2.635  12.723 162.262  1.00 31.62           C  
ATOM   2344  O   LEU B 108       1.775  13.605 162.204  1.00 31.45           O  
ATOM   2345  CB  LEU B 108       3.814  13.751 164.229  1.00 29.27           C  
ATOM   2346  CG  LEU B 108       4.386  13.561 165.637  1.00 28.84           C  
ATOM   2347  CD1 LEU B 108       5.138  14.798 166.094  1.00 27.75           C  
ATOM   2348  CD2 LEU B 108       3.242  13.225 166.584  1.00 28.70           C  
ATOM   2349  N   ASN B 109       2.956  11.964 161.220  1.00 31.51           N  
ATOM   2350  CA  ASN B 109       2.306  12.142 159.932  1.00 31.94           C  
ATOM   2351  C   ASN B 109       0.831  11.749 159.996  1.00 31.99           C  
ATOM   2352  O   ASN B 109       0.024  12.219 159.194  1.00 31.22           O  
ATOM   2353  CB  ASN B 109       3.045  11.330 158.858  1.00 33.16           C  
ATOM   2354  CG  ASN B 109       3.274   9.894 159.273  1.00 33.22           C  
ATOM   2355  OD1 ASN B 109       2.490   9.005 158.939  1.00 36.69           O  
ATOM   2356  ND2 ASN B 109       4.346   9.660 160.019  1.00 34.34           N  
ATOM   2357  N   ASP B 110       0.469  10.907 160.961  1.00 31.69           N  
ATOM   2358  CA  ASP B 110      -0.925  10.485 161.096  1.00 32.21           C  
ATOM   2359  C   ASP B 110      -1.778  11.544 161.809  1.00 31.50           C  
ATOM   2360  O   ASP B 110      -2.988  11.369 161.974  1.00 31.72           O  
ATOM   2361  CB  ASP B 110      -1.009   9.146 161.846  1.00 34.77           C  
ATOM   2362  CG  ASP B 110      -0.589   9.253 163.304  1.00 36.96           C  
ATOM   2363  OD1 ASP B 110       0.407   9.946 163.597  1.00 37.69           O  
ATOM   2364  OD2 ASP B 110      -1.248   8.624 164.162  1.00 39.26           O  
ATOM   2365  N   ARG B 111      -1.148  12.646 162.207  1.00 29.26           N  
ATOM   2366  CA  ARG B 111      -1.849  13.723 162.908  1.00 28.88           C  
ATOM   2367  C   ARG B 111      -1.657  15.082 162.228  1.00 26.64           C  
ATOM   2368  O   ARG B 111      -2.221  16.091 162.664  1.00 24.29           O  
ATOM   2369  CB  ARG B 111      -1.339  13.819 164.351  1.00 31.03           C  
ATOM   2370  CG  ARG B 111      -2.389  13.568 165.416  1.00 35.02           C  
ATOM   2371  CD  ARG B 111      -1.790  13.722 166.813  1.00 37.34           C  
ATOM   2372  NE  ARG B 111      -0.841  12.656 167.124  1.00 39.43           N  
ATOM   2373  CZ  ARG B 111      -0.111  12.594 168.235  1.00 39.86           C  
ATOM   2374  NH1 ARG B 111      -0.208  13.543 169.161  1.00 38.01           N  
ATOM   2375  NH2 ARG B 111       0.713  11.571 168.426  1.00 41.26           N  
ATOM   2376  N   VAL B 112      -0.866  15.105 161.160  1.00 24.58           N  
ATOM   2377  CA  VAL B 112      -0.582  16.345 160.451  1.00 22.94           C  
ATOM   2378  C   VAL B 112      -0.909  16.304 158.957  1.00 24.72           C  
ATOM   2379  O   VAL B 112      -0.686  15.291 158.282  1.00 23.99           O  
ATOM   2380  CB  VAL B 112       0.913  16.720 160.610  1.00 21.61           C  
ATOM   2381  CG1 VAL B 112       1.221  17.994 159.848  1.00 19.35           C  
ATOM   2382  CG2 VAL B 112       1.258  16.874 162.087  1.00 20.59           C  
ATOM   2383  N   GLU B 113      -1.459  17.405 158.457  1.00 24.93           N  
ATOM   2384  CA  GLU B 113      -1.779  17.538 157.041  1.00 25.69           C  
ATOM   2385  C   GLU B 113      -1.026  18.767 156.554  1.00 25.35           C  
ATOM   2386  O   GLU B 113      -1.245  19.872 157.054  1.00 24.16           O  
ATOM   2387  CB  GLU B 113      -3.280  17.752 156.811  1.00 28.63           C  
ATOM   2388  CG  GLU B 113      -3.694  17.564 155.342  1.00 33.90           C  
ATOM   2389  CD  GLU B 113      -5.002  18.249 154.971  1.00 36.57           C  
ATOM   2390  OE1 GLU B 113      -5.931  18.292 155.807  1.00 37.20           O  
ATOM   2391  OE2 GLU B 113      -5.108  18.736 153.823  1.00 39.20           O  
ATOM   2392  N   VAL B 114      -0.126  18.577 155.592  1.00 23.75           N  
ATOM   2393  CA  VAL B 114       0.633  19.688 155.041  1.00 23.59           C  
ATOM   2394  C   VAL B 114      -0.019  20.083 153.717  1.00 23.94           C  
ATOM   2395  O   VAL B 114      -0.038  19.291 152.777  1.00 24.50           O  
ATOM   2396  CB  VAL B 114       2.112  19.299 154.781  1.00 23.22           C  
ATOM   2397  CG1 VAL B 114       2.875  20.496 154.243  1.00 22.27           C  
ATOM   2398  CG2 VAL B 114       2.765  18.813 156.068  1.00 24.39           C  
ATOM   2399  N   ARG B 115      -0.580  21.287 153.662  1.00 23.81           N  
ATOM   2400  CA  ARG B 115      -1.239  21.775 152.452  1.00 24.98           C  
ATOM   2401  C   ARG B 115      -0.239  22.656 151.723  1.00 24.17           C  
ATOM   2402  O   ARG B 115       0.256  23.638 152.274  1.00 21.12           O  
ATOM   2403  CB  ARG B 115      -2.484  22.611 152.793  1.00 28.03           C  
ATOM   2404  CG  ARG B 115      -3.496  21.941 153.711  1.00 31.19           C  
ATOM   2405  CD  ARG B 115      -4.741  21.444 152.988  1.00 33.81           C  
ATOM   2406  NE  ARG B 115      -5.383  22.467 152.162  1.00 35.59           N  
ATOM   2407  CZ  ARG B 115      -6.671  22.462 151.828  1.00 35.49           C  
ATOM   2408  NH1 ARG B 115      -7.470  21.493 152.255  1.00 37.34           N  
ATOM   2409  NH2 ARG B 115      -7.161  23.417 151.054  1.00 36.69           N  
ATOM   2410  N   THR B 116       0.057  22.302 150.479  1.00 23.60           N  
ATOM   2411  CA  THR B 116       1.007  23.052 149.679  1.00 24.75           C  
ATOM   2412  C   THR B 116       0.291  24.061 148.780  1.00 23.82           C  
ATOM   2413  O   THR B 116      -0.776  23.772 148.249  1.00 24.91           O  
ATOM   2414  CB  THR B 116       1.840  22.093 148.798  1.00 24.76           C  
ATOM   2415  OG1 THR B 116       2.538  21.163 149.639  1.00 25.98           O  
ATOM   2416  CG2 THR B 116       2.836  22.868 147.963  1.00 26.83           C  
ATOM   2417  N   GLY B 117       0.890  25.235 148.607  1.00 24.91           N  
ATOM   2418  CA  GLY B 117       0.284  26.258 147.768  1.00 24.13           C  
ATOM   2419  C   GLY B 117       0.263  27.622 148.427  1.00 22.70           C  
ATOM   2420  O   GLY B 117       0.525  27.747 149.623  1.00 22.08           O  
ATOM   2421  N   LEU B 118      -0.039  28.658 147.648  1.00 21.70           N  
ATOM   2422  CA  LEU B 118      -0.096  30.020 148.183  1.00 20.83           C  
ATOM   2423  C   LEU B 118      -0.984  29.999 149.430  1.00 17.40           C  
ATOM   2424  O   LEU B 118      -2.115  29.530 149.369  1.00 17.89           O  
ATOM   2425  CB  LEU B 118      -0.697  30.968 147.138  1.00 22.69           C  
ATOM   2426  CG  LEU B 118       0.088  31.034 145.819  1.00 25.13           C  
ATOM   2427  CD1 LEU B 118      -0.658  31.884 144.798  1.00 26.12           C  
ATOM   2428  CD2 LEU B 118       1.464  31.607 146.096  1.00 24.47           C  
ATOM   2429  N   ALA B 119      -0.464  30.511 150.540  1.00 19.82           N  
ATOM   2430  CA  ALA B 119      -1.191  30.523 151.814  1.00 18.64           C  
ATOM   2431  C   ALA B 119      -2.604  31.096 151.695  1.00 19.65           C  
ATOM   2432  O   ALA B 119      -3.560  30.535 152.226  1.00 18.02           O  
ATOM   2433  CB  ALA B 119      -0.393  31.299 152.847  1.00 18.87           C  
ATOM   2434  N   LEU B 120      -2.734  32.215 150.986  1.00 19.52           N  
ATOM   2435  CA  LEU B 120      -4.034  32.843 150.805  1.00 19.43           C  
ATOM   2436  C   LEU B 120      -5.033  31.952 150.089  1.00 19.06           C  
ATOM   2437  O   LEU B 120      -6.216  31.953 150.423  1.00 19.89           O  
ATOM   2438  CB  LEU B 120      -3.877  34.173 150.056  1.00 20.60           C  
ATOM   2439  CG  LEU B 120      -3.215  35.259 150.904  1.00 19.74           C  
ATOM   2440  CD1 LEU B 120      -2.960  36.501 150.057  1.00 24.54           C  
ATOM   2441  CD2 LEU B 120      -4.116  35.594 152.100  1.00 20.71           C  
ATOM   2442  N   ASP B 121      -4.584  31.197 149.086  1.00 19.59           N  
ATOM   2443  CA  ASP B 121      -5.504  30.307 148.382  1.00 19.32           C  
ATOM   2444  C   ASP B 121      -5.969  29.200 149.321  1.00 18.64           C  
ATOM   2445  O   ASP B 121      -7.156  28.873 149.377  1.00 18.19           O  
ATOM   2446  CB  ASP B 121      -4.834  29.672 147.159  1.00 21.85           C  
ATOM   2447  CG  ASP B 121      -4.567  30.676 146.055  1.00 25.78           C  
ATOM   2448  OD1 ASP B 121      -5.180  31.768 146.073  1.00 26.25           O  
ATOM   2449  OD2 ASP B 121      -3.749  30.362 145.164  1.00 28.42           O  
ATOM   2450  N   SER B 122      -5.024  28.628 150.059  1.00 18.82           N  
ATOM   2451  CA  SER B 122      -5.341  27.548 150.985  1.00 18.89           C  
ATOM   2452  C   SER B 122      -6.267  28.017 152.101  1.00 17.35           C  
ATOM   2453  O   SER B 122      -7.165  27.284 152.513  1.00 18.83           O  
ATOM   2454  CB  SER B 122      -4.056  26.968 151.576  1.00 18.05           C  
ATOM   2455  OG  SER B 122      -3.256  26.390 150.554  1.00 20.83           O  
ATOM   2456  N   LEU B 123      -6.044  29.233 152.590  1.00 20.04           N  
ATOM   2457  CA  LEU B 123      -6.889  29.783 153.650  1.00 21.02           C  
ATOM   2458  C   LEU B 123      -8.325  29.889 153.134  1.00 22.20           C  
ATOM   2459  O   LEU B 123      -9.273  29.549 153.842  1.00 22.52           O  
ATOM   2460  CB  LEU B 123      -6.354  31.148 154.103  1.00 19.59           C  
ATOM   2461  CG  LEU B 123      -5.082  31.072 154.958  1.00 18.99           C  
ATOM   2462  CD1 LEU B 123      -4.422  32.431 155.109  1.00 19.35           C  
ATOM   2463  CD2 LEU B 123      -5.457  30.498 156.328  1.00 18.22           C  
ATOM   2464  N   GLN B 124      -8.486  30.336 151.887  1.00 24.45           N  
ATOM   2465  CA  GLN B 124      -9.814  30.454 151.294  1.00 25.58           C  
ATOM   2466  C   GLN B 124     -10.433  29.081 151.077  1.00 25.84           C  
ATOM   2467  O   GLN B 124     -11.638  28.907 151.232  1.00 26.48           O  
ATOM   2468  CB  GLN B 124      -9.762  31.194 149.951  1.00 27.33           C  
ATOM   2469  CG  GLN B 124      -9.440  32.671 150.060  1.00 30.92           C  
ATOM   2470  CD  GLN B 124      -9.953  33.475 148.873  1.00 33.69           C  
ATOM   2471  OE1 GLN B 124      -9.680  33.144 147.714  1.00 34.47           O  
ATOM   2472  NE2 GLN B 124     -10.698  34.540 149.159  1.00 32.72           N  
ATOM   2473  N   GLN B 125      -9.602  28.108 150.716  1.00 26.30           N  
ATOM   2474  CA  GLN B 125     -10.073  26.748 150.480  1.00 27.04           C  
ATOM   2475  C   GLN B 125     -10.572  26.136 151.781  1.00 25.80           C  
ATOM   2476  O   GLN B 125     -11.613  25.478 151.809  1.00 26.06           O  
ATOM   2477  CB  GLN B 125      -8.947  25.893 149.900  1.00 28.78           C  
ATOM   2478  CG  GLN B 125      -8.611  26.218 148.449  1.00 33.08           C  
ATOM   2479  CD  GLN B 125      -7.317  25.571 147.995  1.00 35.49           C  
ATOM   2480  OE1 GLN B 125      -7.051  24.410 148.310  1.00 37.83           O  
ATOM   2481  NE2 GLN B 125      -6.508  26.317 147.243  1.00 35.95           N  
ATOM   2482  N   ILE B 126      -9.811  26.353 152.851  1.00 26.00           N  
ATOM   2483  CA  ILE B 126     -10.172  25.847 154.173  1.00 25.90           C  
ATOM   2484  C   ILE B 126     -11.504  26.456 154.597  1.00 25.79           C  
ATOM   2485  O   ILE B 126     -12.341  25.780 155.192  1.00 25.72           O  
ATOM   2486  CB  ILE B 126      -9.092  26.206 155.220  1.00 25.52           C  
ATOM   2487  CG1 ILE B 126      -7.812  25.426 154.930  1.00 25.47           C  
ATOM   2488  CG2 ILE B 126      -9.606  25.913 156.632  1.00 26.94           C  
ATOM   2489  CD1 ILE B 126      -6.687  25.709 155.901  1.00 22.70           C  
ATOM   2490  N   GLU B 127     -11.703  27.736 154.290  1.00 27.65           N  
ATOM   2491  CA  GLU B 127     -12.956  28.399 154.641  1.00 30.89           C  
ATOM   2492  C   GLU B 127     -14.116  27.811 153.844  1.00 32.13           C  
ATOM   2493  O   GLU B 127     -15.229  27.706 154.353  1.00 32.45           O  
ATOM   2494  CB  GLU B 127     -12.877  29.908 154.379  1.00 32.61           C  
ATOM   2495  CG  GLU B 127     -14.230  30.618 154.486  1.00 35.36           C  
ATOM   2496  CD  GLU B 127     -14.146  32.112 154.219  1.00 37.72           C  
ATOM   2497  OE1 GLU B 127     -13.536  32.831 155.041  1.00 38.61           O  
ATOM   2498  OE2 GLU B 127     -14.690  32.569 153.188  1.00 37.51           O  
ATOM   2499  N   ASN B 128     -13.860  27.432 152.594  1.00 34.28           N  
ATOM   2500  CA  ASN B 128     -14.913  26.864 151.756  1.00 36.20           C  
ATOM   2501  C   ASN B 128     -15.098  25.371 152.014  1.00 37.39           C  
ATOM   2502  O   ASN B 128     -15.870  24.704 151.321  1.00 38.61           O  
ATOM   2503  CB  ASN B 128     -14.603  27.089 150.271  1.00 37.91           C  
ATOM   2504  CG  ASN B 128     -14.313  28.543 149.946  1.00 39.51           C  
ATOM   2505  OD1 ASN B 128     -14.967  29.451 150.462  1.00 40.69           O  
ATOM   2506  ND2 ASN B 128     -13.333  28.772 149.077  1.00 39.54           N  
ATOM   2507  N   GLU B 129     -14.385  24.852 153.009  1.00 36.87           N  
ATOM   2508  CA  GLU B 129     -14.467  23.441 153.370  1.00 36.78           C  
ATOM   2509  C   GLU B 129     -15.023  23.260 154.784  1.00 38.24           C  
ATOM   2510  O   GLU B 129     -15.518  24.221 155.380  1.00 37.52           O  
ATOM   2511  CB  GLU B 129     -13.091  22.788 153.237  1.00 37.12           C  
ATOM   2512  CG  GLU B 129     -12.774  22.351 151.810  1.00 38.41           C  
ATOM   2513  CD  GLU B 129     -11.297  22.428 151.468  1.00 39.91           C  
ATOM   2514  OE1 GLU B 129     -10.461  21.998 152.292  1.00 40.54           O  
ATOM   2515  OE2 GLU B 129     -10.974  22.916 150.362  1.00 40.20           O  
ATOM   2516  N   LYS B 130     -14.896  22.046 155.329  1.00 39.23           N  
ATOM   2517  CA  LYS B 130     -15.474  21.732 156.623  1.00 40.28           C  
ATOM   2518  C   LYS B 130     -14.572  21.787 157.798  1.00 40.27           C  
ATOM   2519  O   LYS B 130     -15.022  21.595 158.931  1.00 41.32           O  
ATOM   2520  CB  LYS B 130     -16.098  20.355 156.593  1.00 40.95           C  
ATOM   2521  CG  LYS B 130     -17.558  20.361 156.185  1.00 42.39           C  
ATOM   2522  CD  LYS B 130     -17.741  20.758 154.731  1.00 44.20           C  
ATOM   2523  CE  LYS B 130     -19.192  20.620 154.323  1.00 44.71           C  
ATOM   2524  NZ  LYS B 130     -19.376  20.749 152.853  1.00 46.73           N  
ATOM   2525  N   TYR B 131     -13.303  21.956 157.576  1.00 40.57           N  
ATOM   2526  CA  TYR B 131     -12.568  22.136 158.767  1.00 40.76           C  
ATOM   2527  C   TYR B 131     -13.410  23.125 159.452  1.00 41.31           C  
ATOM   2528  O   TYR B 131     -13.636  24.174 158.870  1.00 40.65           O  
ATOM   2529  CB  TYR B 131     -11.343  22.949 158.541  1.00 41.20           C  
ATOM   2530  CG  TYR B 131     -10.550  22.294 157.511  1.00 41.42           C  
ATOM   2531  CD1 TYR B 131      -9.497  21.531 157.923  1.00 41.56           C  
ATOM   2532  CD2 TYR B 131     -10.822  22.430 156.151  1.00 40.92           C  
ATOM   2533  CE1 TYR B 131      -8.689  20.898 157.045  1.00 42.12           C  
ATOM   2534  CE2 TYR B 131     -10.008  21.810 155.241  1.00 41.42           C  
ATOM   2535  CZ  TYR B 131      -8.943  21.043 155.689  1.00 41.26           C  
ATOM   2536  OH  TYR B 131      -8.142  20.426 154.771  1.00 42.10           O  
ATOM   2537  N   GLU B 132     -13.975  22.970 160.612  1.00 41.03           N  
ATOM   2538  CA  GLU B 132     -14.518  24.287 160.861  1.00 39.25           C  
ATOM   2539  C   GLU B 132     -13.441  24.970 161.689  1.00 37.46           C  
ATOM   2540  O   GLU B 132     -12.229  24.747 161.520  1.00 39.29           O  
ATOM   2541  CB  GLU B 132     -15.999  24.255 161.372  1.00 41.49           C  
ATOM   2542  CG  GLU B 132     -17.003  25.500 161.325  1.00 42.82           C  
ATOM   2543  CD  GLU B 132     -17.239  26.412 160.089  1.00 42.94           C  
ATOM   2544  OE1 GLU B 132     -17.252  27.644 160.310  1.00 42.38           O  
ATOM   2545  OE2 GLU B 132     -17.442  25.911 158.967  1.00 45.52           O  
ATOM   2546  N   PRO B 133     -13.892  25.780 162.625  1.00 33.75           N  
ATOM   2547  CA  PRO B 133     -13.037  26.582 163.496  1.00 28.08           C  
ATOM   2548  C   PRO B 133     -11.953  25.856 164.260  1.00 23.55           C  
ATOM   2549  O   PRO B 133     -12.143  24.769 164.821  1.00 23.16           O  
ATOM   2550  CB  PRO B 133     -14.021  27.280 164.444  1.00 30.85           C  
ATOM   2551  CG  PRO B 133     -15.306  26.533 164.296  1.00 31.34           C  
ATOM   2552  CD  PRO B 133     -15.002  25.317 163.475  1.00 32.99           C  
ATOM   2553  N   PHE B 134     -10.807  26.518 164.253  1.00 19.42           N  
ATOM   2554  CA  PHE B 134      -9.588  26.036 164.854  1.00 18.19           C  
ATOM   2555  C   PHE B 134      -9.489  26.496 166.306  1.00 18.03           C  
ATOM   2556  O   PHE B 134      -9.872  27.619 166.642  1.00 18.10           O  
ATOM   2557  CB  PHE B 134      -8.379  26.537 164.051  1.00 17.68           C  
ATOM   2558  CG  PHE B 134      -8.261  25.928 162.677  1.00 17.67           C  
ATOM   2559  CD1 PHE B 134      -7.720  24.658 162.514  1.00 16.73           C  
ATOM   2560  CD2 PHE B 134      -8.738  26.603 161.557  1.00 18.50           C  
ATOM   2561  CE1 PHE B 134      -7.660  24.057 161.258  1.00 19.73           C  
ATOM   2562  CE2 PHE B 134      -8.685  26.012 160.290  1.00 18.30           C  
ATOM   2563  CZ  PHE B 134      -8.146  24.737 160.140  1.00 19.04           C  
ATOM   2564  N   ASP B 135      -8.985  25.616 167.165  1.00 17.55           N  
ATOM   2565  CA  ASP B 135      -8.828  25.950 168.589  1.00 17.59           C  
ATOM   2566  C   ASP B 135      -7.519  26.682 168.878  1.00 16.30           C  
ATOM   2567  O   ASP B 135      -7.416  27.430 169.855  1.00 17.43           O  
ATOM   2568  CB  ASP B 135      -8.796  24.694 169.477  1.00 20.67           C  
ATOM   2569  CG  ASP B 135      -9.938  23.741 169.227  1.00 24.14           C  
ATOM   2570  OD1 ASP B 135     -11.108  24.185 169.189  1.00 26.14           O  
ATOM   2571  OD2 ASP B 135      -9.652  22.529 169.094  1.00 23.82           O  
ATOM   2572  N   PHE B 136      -6.507  26.450 168.042  1.00 14.87           N  
ATOM   2573  CA  PHE B 136      -5.191  27.037 168.260  1.00 11.59           C  
ATOM   2574  C   PHE B 136      -4.582  27.347 166.891  1.00 11.31           C  
ATOM   2575  O   PHE B 136      -4.681  26.529 165.977  1.00 12.48           O  
ATOM   2576  CB  PHE B 136      -4.330  26.007 169.008  1.00 14.14           C  
ATOM   2577  CG  PHE B 136      -3.067  26.556 169.604  1.00 15.21           C  
ATOM   2578  CD1 PHE B 136      -1.970  26.853 168.809  1.00 13.35           C  
ATOM   2579  CD2 PHE B 136      -2.961  26.732 170.985  1.00 13.06           C  
ATOM   2580  CE1 PHE B 136      -0.791  27.312 169.366  1.00 12.82           C  
ATOM   2581  CE2 PHE B 136      -1.783  27.191 171.556  1.00 13.20           C  
ATOM   2582  CZ  PHE B 136      -0.691  27.483 170.746  1.00 15.94           C  
ATOM   2583  N   ILE B 137      -3.968  28.514 166.770  1.00 10.42           N  
ATOM   2584  CA  ILE B 137      -3.362  28.927 165.503  1.00 12.46           C  
ATOM   2585  C   ILE B 137      -1.983  29.527 165.695  1.00 11.18           C  
ATOM   2586  O   ILE B 137      -1.780  30.425 166.524  1.00 12.16           O  
ATOM   2587  CB  ILE B 137      -4.267  29.936 164.769  1.00 13.02           C  
ATOM   2588  CG1 ILE B 137      -5.610  29.286 164.470  1.00 14.31           C  
ATOM   2589  CG2 ILE B 137      -3.610  30.380 163.447  1.00 14.01           C  
ATOM   2590  CD1 ILE B 137      -6.647  30.252 163.935  1.00 16.77           C  
ATOM   2591  N   PHE B 138      -1.017  29.016 164.932  1.00 10.97           N  
ATOM   2592  CA  PHE B 138       0.344  29.506 165.024  1.00 11.47           C  
ATOM   2593  C   PHE B 138       0.712  30.139 163.701  1.00 12.59           C  
ATOM   2594  O   PHE B 138       0.585  29.499 162.665  1.00 12.86           O  
ATOM   2595  CB  PHE B 138       1.330  28.363 165.309  1.00 12.52           C  
ATOM   2596  CG  PHE B 138       2.767  28.805 165.383  1.00 11.96           C  
ATOM   2597  CD1 PHE B 138       3.156  29.822 166.242  1.00 14.61           C  
ATOM   2598  CD2 PHE B 138       3.741  28.194 164.595  1.00 15.56           C  
ATOM   2599  CE1 PHE B 138       4.490  30.231 166.321  1.00 16.23           C  
ATOM   2600  CE2 PHE B 138       5.071  28.594 164.667  1.00 10.72           C  
ATOM   2601  CZ  PHE B 138       5.448  29.614 165.532  1.00 14.32           C  
ATOM   2602  N   ILE B 139       1.157  31.388 163.752  1.00 14.77           N  
ATOM   2603  CA  ILE B 139       1.563  32.099 162.544  1.00 17.29           C  
ATOM   2604  C   ILE B 139       3.062  32.357 162.566  1.00 17.39           C  
ATOM   2605  O   ILE B 139       3.581  33.061 163.430  1.00 16.33           O  
ATOM   2606  CB  ILE B 139       0.838  33.456 162.407  1.00 15.66           C  
ATOM   2607  CG1 ILE B 139      -0.672  33.262 162.557  1.00 15.94           C  
ATOM   2608  CG2 ILE B 139       1.171  34.086 161.041  1.00 15.61           C  
ATOM   2609  CD1 ILE B 139      -1.478  34.560 162.519  1.00 14.95           C  
ATOM   2610  N   ASP B 140       3.759  31.778 161.599  1.00 21.39           N  
ATOM   2611  CA  ASP B 140       5.196  31.948 161.487  1.00 26.56           C  
ATOM   2612  C   ASP B 140       5.461  32.181 160.011  1.00 30.27           C  
ATOM   2613  O   ASP B 140       5.919  31.289 159.299  1.00 32.06           O  
ATOM   2614  CB  ASP B 140       5.921  30.690 161.971  1.00 27.98           C  
ATOM   2615  CG  ASP B 140       7.422  30.881 162.077  1.00 31.37           C  
ATOM   2616  OD1 ASP B 140       7.878  32.029 162.287  1.00 33.51           O  
ATOM   2617  OD2 ASP B 140       8.150  29.875 161.969  1.00 33.63           O  
ATOM   2618  N   ALA B 141       5.146  33.388 159.561  1.00 33.36           N  
ATOM   2619  CA  ALA B 141       5.319  33.741 158.166  1.00 37.21           C  
ATOM   2620  C   ALA B 141       6.123  35.016 157.981  1.00 39.28           C  
ATOM   2621  O   ALA B 141       6.600  35.628 158.941  1.00 39.91           O  
ATOM   2622  CB  ALA B 141       3.958  33.885 157.504  1.00 36.96           C  
ATOM   2623  N   ASP B 142       6.250  35.412 156.721  1.00 42.23           N  
ATOM   2624  CA  ASP B 142       6.986  36.605 156.344  1.00 44.37           C  
ATOM   2625  C   ASP B 142       6.293  37.880 156.805  1.00 45.05           C  
ATOM   2626  O   ASP B 142       5.158  37.852 157.277  1.00 45.31           O  
ATOM   2627  CB  ASP B 142       7.145  36.628 154.821  1.00 45.60           C  
ATOM   2628  CG  ASP B 142       7.891  37.848 154.330  1.00 47.10           C  
ATOM   2629  OD1 ASP B 142       9.084  38.001 154.672  1.00 48.02           O  
ATOM   2630  OD2 ASP B 142       7.282  38.661 153.603  1.00 49.09           O  
ATOM   2631  N   LYS B 143       6.997  39.000 156.663  1.00 46.04           N  
ATOM   2632  CA  LYS B 143       6.471  40.314 157.017  1.00 45.30           C  
ATOM   2633  C   LYS B 143       5.549  40.714 155.870  1.00 44.57           C  
ATOM   2634  O   LYS B 143       5.573  40.099 154.804  1.00 46.81           O  
ATOM   2635  CB  LYS B 143       7.617  41.324 157.156  1.00 46.21           C  
ATOM   2636  CG  LYS B 143       7.177  42.760 157.424  1.00 46.95           C  
ATOM   2637  CD  LYS B 143       8.373  43.703 157.461  1.00 47.75           C  
ATOM   2638  CE  LYS B 143       7.931  45.140 157.691  1.00 48.82           C  
ATOM   2639  NZ  LYS B 143       9.095  46.044 157.915  1.00 49.30           N  
ATOM   2640  N   GLN B 144       4.741  41.742 156.083  1.00 43.04           N  
ATOM   2641  CA  GLN B 144       3.791  42.190 155.073  1.00 40.03           C  
ATOM   2642  C   GLN B 144       2.668  41.170 154.982  1.00 37.39           C  
ATOM   2643  O   GLN B 144       1.590  41.480 154.478  1.00 37.91           O  
ATOM   2644  CB  GLN B 144       4.452  42.341 153.698  1.00 41.82           C  
ATOM   2645  CG  GLN B 144       3.544  43.029 152.666  1.00 43.53           C  
ATOM   2646  CD  GLN B 144       4.153  43.063 151.272  1.00 43.86           C  
ATOM   2647  OE1 GLN B 144       4.135  42.065 150.550  1.00 43.73           O  
ATOM   2648  NE2 GLN B 144       4.699  44.215 150.891  1.00 43.76           N  
ATOM   2649  N   ASN B 145       2.923  39.950 155.456  1.00 33.00           N  
ATOM   2650  CA  ASN B 145       1.901  38.907 155.439  1.00 30.03           C  
ATOM   2651  C   ASN B 145       1.218  38.790 156.809  1.00 27.12           C  
ATOM   2652  O   ASN B 145       0.062  38.377 156.892  1.00 25.06           O  
ATOM   2653  CB  ASN B 145       2.497  37.540 155.052  1.00 31.01           C  
ATOM   2654  CG  ASN B 145       2.714  37.378 153.546  1.00 33.62           C  
ATOM   2655  OD1 ASN B 145       1.818  37.646 152.735  1.00 32.57           O  
ATOM   2656  ND2 ASN B 145       3.906  36.916 153.169  1.00 33.77           N  
ATOM   2657  N   ASN B 146       1.915  39.169 157.879  1.00 25.39           N  
ATOM   2658  CA  ASN B 146       1.331  39.061 159.220  1.00 24.46           C  
ATOM   2659  C   ASN B 146      -0.066  39.665 159.374  1.00 23.67           C  
ATOM   2660  O   ASN B 146      -0.967  39.016 159.902  1.00 21.93           O  
ATOM   2661  CB  ASN B 146       2.266  39.649 160.278  1.00 24.14           C  
ATOM   2662  CG  ASN B 146       3.343  38.668 160.713  1.00 24.79           C  
ATOM   2663  OD1 ASN B 146       3.165  37.450 160.616  1.00 24.28           O  
ATOM   2664  ND2 ASN B 146       4.453  39.192 161.211  1.00 26.74           N  
ATOM   2665  N   PRO B 147      -0.267  40.912 158.914  1.00 23.09           N  
ATOM   2666  CA  PRO B 147      -1.597  41.516 159.043  1.00 22.33           C  
ATOM   2667  C   PRO B 147      -2.669  40.645 158.391  1.00 20.30           C  
ATOM   2668  O   PRO B 147      -3.723  40.397 158.981  1.00 20.23           O  
ATOM   2669  CB  PRO B 147      -1.432  42.866 158.341  1.00 23.21           C  
ATOM   2670  CG  PRO B 147       0.005  43.203 158.628  1.00 23.10           C  
ATOM   2671  CD  PRO B 147       0.693  41.879 158.352  1.00 22.30           C  
ATOM   2672  N   ALA B 148      -2.399  40.167 157.182  1.00 19.30           N  
ATOM   2673  CA  ALA B 148      -3.357  39.326 156.480  1.00 18.66           C  
ATOM   2674  C   ALA B 148      -3.615  37.998 157.183  1.00 17.58           C  
ATOM   2675  O   ALA B 148      -4.763  37.591 157.354  1.00 16.30           O  
ATOM   2676  CB  ALA B 148      -2.881  39.057 155.058  1.00 19.20           C  
ATOM   2677  N   TYR B 149      -2.545  37.314 157.571  1.00 17.97           N  
ATOM   2678  CA  TYR B 149      -2.689  36.019 158.226  1.00 17.75           C  
ATOM   2679  C   TYR B 149      -3.392  36.139 159.573  1.00 17.31           C  
ATOM   2680  O   TYR B 149      -4.108  35.231 159.990  1.00 17.23           O  
ATOM   2681  CB  TYR B 149      -1.321  35.348 158.373  1.00 19.44           C  
ATOM   2682  CG  TYR B 149      -0.698  34.994 157.030  1.00 21.51           C  
ATOM   2683  CD1 TYR B 149      -1.454  35.039 155.856  1.00 23.32           C  
ATOM   2684  CD2 TYR B 149       0.646  34.636 156.933  1.00 24.29           C  
ATOM   2685  CE1 TYR B 149      -0.887  34.745 154.613  1.00 25.12           C  
ATOM   2686  CE2 TYR B 149       1.225  34.336 155.689  1.00 25.07           C  
ATOM   2687  CZ  TYR B 149       0.454  34.395 154.540  1.00 25.04           C  
ATOM   2688  OH  TYR B 149       1.017  34.117 153.313  1.00 26.76           O  
ATOM   2689  N   PHE B 150      -3.193  37.263 160.247  1.00 17.72           N  
ATOM   2690  CA  PHE B 150      -3.855  37.467 161.530  1.00 18.75           C  
ATOM   2691  C   PHE B 150      -5.359  37.564 161.299  1.00 18.15           C  
ATOM   2692  O   PHE B 150      -6.139  36.896 161.978  1.00 16.48           O  
ATOM   2693  CB  PHE B 150      -3.367  38.739 162.213  1.00 20.78           C  
ATOM   2694  CG  PHE B 150      -4.207  39.135 163.396  1.00 26.01           C  
ATOM   2695  CD1 PHE B 150      -4.178  38.384 164.562  1.00 25.39           C  
ATOM   2696  CD2 PHE B 150      -5.066  40.230 163.321  1.00 26.48           C  
ATOM   2697  CE1 PHE B 150      -4.997  38.712 165.642  1.00 28.77           C  
ATOM   2698  CE2 PHE B 150      -5.887  40.568 164.393  1.00 29.63           C  
ATOM   2699  CZ  PHE B 150      -5.852  39.805 165.557  1.00 29.49           C  
ATOM   2700  N   GLU B 151      -5.768  38.400 160.345  1.00 17.16           N  
ATOM   2701  CA  GLU B 151      -7.192  38.554 160.048  1.00 18.06           C  
ATOM   2702  C   GLU B 151      -7.797  37.233 159.600  1.00 16.42           C  
ATOM   2703  O   GLU B 151      -8.935  36.909 159.953  1.00 14.65           O  
ATOM   2704  CB  GLU B 151      -7.414  39.631 158.970  1.00 19.54           C  
ATOM   2705  CG  GLU B 151      -7.195  41.065 159.447  1.00 22.75           C  
ATOM   2706  CD  GLU B 151      -8.097  41.453 160.607  1.00 23.61           C  
ATOM   2707  OE1 GLU B 151      -9.316  41.184 160.539  1.00 25.73           O  
ATOM   2708  OE2 GLU B 151      -7.590  42.033 161.591  1.00 29.87           O  
ATOM   2709  N   TRP B 152      -7.044  36.454 158.822  1.00 14.77           N  
ATOM   2710  CA  TRP B 152      -7.557  35.164 158.390  1.00 13.13           C  
ATOM   2711  C   TRP B 152      -7.621  34.183 159.566  1.00 11.33           C  
ATOM   2712  O   TRP B 152      -8.512  33.345 159.619  1.00 13.67           O  
ATOM   2713  CB  TRP B 152      -6.712  34.578 157.245  1.00 14.37           C  
ATOM   2714  CG  TRP B 152      -7.330  34.879 155.902  1.00 15.62           C  
ATOM   2715  CD1 TRP B 152      -7.003  35.904 155.050  1.00 18.36           C  
ATOM   2716  CD2 TRP B 152      -8.467  34.226 155.321  1.00 17.75           C  
ATOM   2717  NE1 TRP B 152      -7.873  35.927 153.981  1.00 19.19           N  
ATOM   2718  CE2 TRP B 152      -8.778  34.908 154.122  1.00 19.98           C  
ATOM   2719  CE3 TRP B 152      -9.256  33.129 155.700  1.00 18.07           C  
ATOM   2720  CZ2 TRP B 152      -9.848  34.529 153.299  1.00 19.87           C  
ATOM   2721  CZ3 TRP B 152     -10.319  32.753 154.880  1.00 18.96           C  
ATOM   2722  CH2 TRP B 152     -10.603  33.455 153.691  1.00 21.21           C  
ATOM   2723  N   ALA B 153      -6.679  34.295 160.497  1.00 13.56           N  
ATOM   2724  CA  ALA B 153      -6.672  33.420 161.685  1.00 13.23           C  
ATOM   2725  C   ALA B 153      -7.986  33.646 162.435  1.00 14.17           C  
ATOM   2726  O   ALA B 153      -8.695  32.694 162.793  1.00 12.68           O  
ATOM   2727  CB  ALA B 153      -5.496  33.773 162.584  1.00 11.94           C  
ATOM   2728  N   LEU B 154      -8.295  34.922 162.656  1.00 16.32           N  
ATOM   2729  CA  LEU B 154      -9.521  35.328 163.349  1.00 17.23           C  
ATOM   2730  C   LEU B 154     -10.738  34.780 162.624  1.00 16.61           C  
ATOM   2731  O   LEU B 154     -11.661  34.243 163.230  1.00 14.93           O  
ATOM   2732  CB  LEU B 154      -9.630  36.855 163.380  1.00 17.69           C  
ATOM   2733  CG  LEU B 154      -9.590  37.599 164.712  1.00 21.53           C  
ATOM   2734  CD1 LEU B 154     -10.042  39.028 164.467  1.00 20.86           C  
ATOM   2735  CD2 LEU B 154     -10.514  36.932 165.735  1.00 18.22           C  
ATOM   2736  N   LYS B 155     -10.738  34.942 161.305  1.00 15.34           N  
ATOM   2737  CA  LYS B 155     -11.826  34.476 160.469  1.00 16.06           C  
ATOM   2738  C   LYS B 155     -12.124  32.985 160.638  1.00 13.74           C  
ATOM   2739  O   LYS B 155     -13.276  32.564 160.552  1.00 14.19           O  
ATOM   2740  CB  LYS B 155     -11.488  34.761 158.999  1.00 19.36           C  
ATOM   2741  CG  LYS B 155     -12.542  35.523 158.245  1.00 27.35           C  
ATOM   2742  CD  LYS B 155     -13.820  34.736 158.099  1.00 30.33           C  
ATOM   2743  CE  LYS B 155     -14.814  35.491 157.222  1.00 32.79           C  
ATOM   2744  NZ  LYS B 155     -14.268  35.716 155.849  1.00 33.96           N  
ATOM   2745  N   LEU B 156     -11.086  32.190 160.880  1.00 11.76           N  
ATOM   2746  CA  LEU B 156     -11.241  30.751 161.017  1.00 12.16           C  
ATOM   2747  C   LEU B 156     -11.219  30.323 162.483  1.00 12.92           C  
ATOM   2748  O   LEU B 156     -10.923  29.172 162.795  1.00 13.07           O  
ATOM   2749  CB  LEU B 156     -10.118  30.034 160.265  1.00 14.03           C  
ATOM   2750  CG  LEU B 156     -10.013  30.463 158.793  1.00 13.90           C  
ATOM   2751  CD1 LEU B 156      -8.711  29.954 158.184  1.00 17.26           C  
ATOM   2752  CD2 LEU B 156     -11.214  29.947 158.028  1.00 16.09           C  
ATOM   2753  N   SER B 157     -11.532  31.261 163.367  1.00 14.36           N  
ATOM   2754  CA  SER B 157     -11.535  30.977 164.802  1.00 15.64           C  
ATOM   2755  C   SER B 157     -12.933  30.948 165.407  1.00 15.66           C  
ATOM   2756  O   SER B 157     -13.934  31.035 164.717  1.00 17.03           O  
ATOM   2757  CB  SER B 157     -10.723  32.034 165.540  1.00 14.34           C  
ATOM   2758  OG  SER B 157      -9.347  31.941 165.237  1.00 22.07           O  
ATOM   2759  N   ARG B 158     -12.966  30.794 166.723  1.00 16.31           N  
ATOM   2760  CA  ARG B 158     -14.200  30.808 167.501  1.00 15.73           C  
ATOM   2761  C   ARG B 158     -13.801  31.370 168.860  1.00 15.78           C  
ATOM   2762  O   ARG B 158     -12.615  31.479 169.165  1.00 12.85           O  
ATOM   2763  CB  ARG B 158     -14.809  29.405 167.623  1.00 15.94           C  
ATOM   2764  CG  ARG B 158     -13.869  28.277 168.034  1.00 18.61           C  
ATOM   2765  CD  ARG B 158     -13.560  28.261 169.522  1.00 19.78           C  
ATOM   2766  NE  ARG B 158     -12.963  26.987 169.913  1.00 20.34           N  
ATOM   2767  CZ  ARG B 158     -12.439  26.737 171.110  1.00 22.02           C  
ATOM   2768  NH1 ARG B 158     -12.433  27.674 172.049  1.00 19.54           N  
ATOM   2769  NH2 ARG B 158     -11.917  25.549 171.369  1.00 21.81           N  
ATOM   2770  N   PRO B 159     -14.778  31.787 169.673  1.00 16.91           N  
ATOM   2771  CA  PRO B 159     -14.411  32.331 170.985  1.00 17.51           C  
ATOM   2772  C   PRO B 159     -13.573  31.338 171.794  1.00 14.77           C  
ATOM   2773  O   PRO B 159     -13.955  30.178 171.943  1.00 16.91           O  
ATOM   2774  CB  PRO B 159     -15.771  32.623 171.620  1.00 18.47           C  
ATOM   2775  CG  PRO B 159     -16.588  33.054 170.409  1.00 21.05           C  
ATOM   2776  CD  PRO B 159     -16.208  31.998 169.385  1.00 18.52           C  
ATOM   2777  N   GLY B 160     -12.439  31.808 172.307  1.00 14.70           N  
ATOM   2778  CA  GLY B 160     -11.548  30.969 173.090  1.00 13.56           C  
ATOM   2779  C   GLY B 160     -10.321  30.528 172.307  1.00 13.59           C  
ATOM   2780  O   GLY B 160      -9.341  30.065 172.881  1.00 11.47           O  
ATOM   2781  N   THR B 161     -10.372  30.668 170.983  1.00 14.12           N  
ATOM   2782  CA  THR B 161      -9.229  30.274 170.158  1.00 12.77           C  
ATOM   2783  C   THR B 161      -7.977  31.026 170.572  1.00 10.93           C  
ATOM   2784  O   THR B 161      -8.018  32.226 170.837  1.00 15.14           O  
ATOM   2785  CB  THR B 161      -9.491  30.546 168.656  1.00 10.01           C  
ATOM   2786  OG1 THR B 161     -10.465  29.626 168.174  1.00 13.81           O  
ATOM   2787  CG2 THR B 161      -8.193  30.405 167.847  1.00 13.10           C  
ATOM   2788  N   VAL B 162      -6.857  30.313 170.633  1.00 10.80           N  
ATOM   2789  CA  VAL B 162      -5.593  30.925 170.995  1.00 10.10           C  
ATOM   2790  C   VAL B 162      -4.853  31.142 169.686  1.00 11.43           C  
ATOM   2791  O   VAL B 162      -4.846  30.256 168.832  1.00 12.99           O  
ATOM   2792  CB  VAL B 162      -4.751  29.992 171.893  1.00 11.09           C  
ATOM   2793  CG1 VAL B 162      -3.376  30.587 172.143  1.00 11.04           C  
ATOM   2794  CG2 VAL B 162      -5.478  29.774 173.232  1.00 13.10           C  
ATOM   2795  N   ILE B 163      -4.268  32.323 169.541  1.00 11.67           N  
ATOM   2796  CA  ILE B 163      -3.490  32.663 168.352  1.00 14.40           C  
ATOM   2797  C   ILE B 163      -2.105  33.135 168.749  1.00 13.22           C  
ATOM   2798  O   ILE B 163      -1.942  34.119 169.486  1.00 13.54           O  
ATOM   2799  CB  ILE B 163      -4.150  33.788 167.518  1.00 14.81           C  
ATOM   2800  CG1 ILE B 163      -5.545  33.364 167.065  1.00 16.35           C  
ATOM   2801  CG2 ILE B 163      -3.261  34.111 166.312  1.00 16.52           C  
ATOM   2802  CD1 ILE B 163      -6.315  34.459 166.347  1.00 18.43           C  
ATOM   2803  N   ILE B 164      -1.088  32.426 168.276  1.00 13.69           N  
ATOM   2804  CA  ILE B 164       0.274  32.824 168.566  1.00 13.98           C  
ATOM   2805  C   ILE B 164       0.861  33.243 167.237  1.00 15.54           C  
ATOM   2806  O   ILE B 164       0.744  32.519 166.254  1.00 15.31           O  
ATOM   2807  CB  ILE B 164       1.124  31.675 169.105  1.00 14.18           C  
ATOM   2808  CG1 ILE B 164       0.454  31.058 170.332  1.00 14.96           C  
ATOM   2809  CG2 ILE B 164       2.501  32.204 169.462  1.00 15.37           C  
ATOM   2810  CD1 ILE B 164       0.192  32.072 171.438  1.00 15.73           C  
ATOM   2811  N   GLY B 165       1.476  34.417 167.214  1.00 18.51           N  
ATOM   2812  CA  GLY B 165       2.063  34.897 165.982  1.00 20.62           C  
ATOM   2813  C   GLY B 165       3.444  35.464 166.202  1.00 21.12           C  
ATOM   2814  O   GLY B 165       3.632  36.361 167.020  1.00 18.59           O  
ATOM   2815  N   ASP B 166       4.422  34.940 165.469  1.00 23.20           N  
ATOM   2816  CA  ASP B 166       5.782  35.425 165.599  1.00 26.57           C  
ATOM   2817  C   ASP B 166       5.944  36.715 164.832  1.00 28.86           C  
ATOM   2818  O   ASP B 166       5.385  36.875 163.749  1.00 27.15           O  
ATOM   2819  CB  ASP B 166       6.781  34.393 165.072  1.00 30.55           C  
ATOM   2820  CG  ASP B 166       7.077  33.312 166.081  1.00 33.08           C  
ATOM   2821  OD1 ASP B 166       6.132  32.601 166.473  1.00 37.89           O  
ATOM   2822  OD2 ASP B 166       8.248  33.174 166.488  1.00 36.86           O  
ATOM   2823  N   ASN B 167       6.695  37.645 165.404  1.00 31.00           N  
ATOM   2824  CA  ASN B 167       6.934  38.898 164.717  1.00 34.96           C  
ATOM   2825  C   ASN B 167       8.393  38.942 164.278  1.00 35.74           C  
ATOM   2826  O   ASN B 167       8.724  38.453 163.199  1.00 36.51           O  
ATOM   2827  CB  ASN B 167       6.614  40.097 165.611  1.00 36.81           C  
ATOM   2828  CG  ASN B 167       6.364  41.366 164.806  1.00 39.44           C  
ATOM   2829  OD1 ASN B 167       6.205  42.452 165.365  1.00 41.45           O  
ATOM   2830  ND2 ASN B 167       6.321  41.230 163.485  1.00 39.46           N  
ATOM   2831  N   VAL B 168       9.273  39.481 165.118  1.00 36.89           N  
ATOM   2832  CA  VAL B 168      10.679  39.594 164.741  1.00 37.66           C  
ATOM   2833  C   VAL B 168      11.693  38.964 165.693  1.00 37.94           C  
ATOM   2834  O   VAL B 168      11.448  38.823 166.896  1.00 37.46           O  
ATOM   2835  CB  VAL B 168      11.070  41.083 164.549  1.00 37.72           C  
ATOM   2836  CG1 VAL B 168      12.436  41.185 163.897  1.00 38.58           C  
ATOM   2837  CG2 VAL B 168      10.024  41.794 163.711  1.00 38.19           C  
ATOM   2838  N   VAL B 169      12.841  38.591 165.131  1.00 37.82           N  
ATOM   2839  CA  VAL B 169      13.939  38.002 165.889  1.00 38.77           C  
ATOM   2840  C   VAL B 169      14.846  39.143 166.352  1.00 39.07           C  
ATOM   2841  O   VAL B 169      15.218  40.005 165.558  1.00 39.43           O  
ATOM   2842  CB  VAL B 169      14.765  37.028 165.011  1.00 38.66           C  
ATOM   2843  CG1 VAL B 169      15.956  36.498 165.790  1.00 37.78           C  
ATOM   2844  CG2 VAL B 169      13.889  35.880 164.548  1.00 38.92           C  
ATOM   2845  N   ARG B 170      15.187  39.150 167.638  1.00 40.16           N  
ATOM   2846  CA  ARG B 170      16.042  40.189 168.208  1.00 41.41           C  
ATOM   2847  C   ARG B 170      17.454  39.676 168.451  1.00 42.59           C  
ATOM   2848  O   ARG B 170      17.803  39.319 169.578  1.00 42.42           O  
ATOM   2849  CB  ARG B 170      15.481  40.681 169.547  1.00 40.32           C  
ATOM   2850  CG  ARG B 170      14.130  41.367 169.490  1.00 39.00           C  
ATOM   2851  CD  ARG B 170      13.591  41.611 170.909  1.00 37.11           C  
ATOM   2852  NE  ARG B 170      12.258  42.214 170.905  1.00 32.84           N  
ATOM   2853  CZ  ARG B 170      11.244  41.765 170.174  1.00 30.13           C  
ATOM   2854  NH1 ARG B 170      11.418  40.708 169.393  1.00 28.23           N  
ATOM   2855  NH2 ARG B 170      10.064  42.369 170.216  1.00 27.75           N  
ATOM   2856  N   GLU B 171      18.269  39.642 167.403  1.00 44.53           N  
ATOM   2857  CA  GLU B 171      19.644  39.180 167.548  1.00 46.03           C  
ATOM   2858  C   GLU B 171      20.550  40.351 167.898  1.00 46.39           C  
ATOM   2859  O   GLU B 171      21.623  40.516 167.321  1.00 46.99           O  
ATOM   2860  CB  GLU B 171      20.108  38.500 166.256  1.00 46.84           C  
ATOM   2861  CG  GLU B 171      19.651  39.199 164.985  1.00 48.36           C  
ATOM   2862  CD  GLU B 171      19.593  38.257 163.799  1.00 48.44           C  
ATOM   2863  OE1 GLU B 171      18.877  37.239 163.886  1.00 49.61           O  
ATOM   2864  OE2 GLU B 171      20.258  38.531 162.779  1.00 50.26           O  
ATOM   2865  N   GLY B 172      20.103  41.161 168.853  1.00 46.53           N  
ATOM   2866  CA  GLY B 172      20.873  42.315 169.274  1.00 46.89           C  
ATOM   2867  C   GLY B 172      20.061  43.266 170.135  1.00 47.53           C  
ATOM   2868  O   GLY B 172      18.856  43.419 169.932  1.00 47.55           O  
ATOM   2869  N   GLU B 173      20.726  43.908 171.095  1.00 47.66           N  
ATOM   2870  CA  GLU B 173      20.081  44.850 172.006  1.00 47.31           C  
ATOM   2871  C   GLU B 173      19.535  46.050 171.239  1.00 47.62           C  
ATOM   2872  O   GLU B 173      18.325  46.260 171.169  1.00 48.40           O  
ATOM   2873  CB  GLU B 173      21.083  45.348 173.051  1.00 47.75           C  
ATOM   2874  CG  GLU B 173      20.464  45.705 174.399  1.00 47.71           C  
ATOM   2875  CD  GLU B 173      19.033  46.192 174.277  1.00 48.04           C  
ATOM   2876  OE1 GLU B 173      18.805  47.220 173.601  1.00 47.06           O  
ATOM   2877  OE2 GLU B 173      18.133  45.539 174.855  1.00 48.33           O  
ATOM   2878  N   VAL B 174      20.438  46.847 170.679  1.00 47.49           N  
ATOM   2879  CA  VAL B 174      20.043  48.028 169.916  1.00 46.79           C  
ATOM   2880  C   VAL B 174      19.545  47.586 168.540  1.00 46.19           C  
ATOM   2881  O   VAL B 174      19.392  46.390 168.286  1.00 46.55           O  
ATOM   2882  CB  VAL B 174      21.236  49.003 169.738  1.00 46.54           C  
ATOM   2883  CG1 VAL B 174      20.739  50.357 169.263  1.00 45.76           C  
ATOM   2884  CG2 VAL B 174      21.990  49.152 171.052  1.00 46.72           C  
ATOM   2885  N   ILE B 175      19.293  48.549 167.660  1.00 45.86           N  
ATOM   2886  CA  ILE B 175      18.809  48.265 166.310  1.00 45.26           C  
ATOM   2887  C   ILE B 175      17.334  47.899 166.349  1.00 45.08           C  
ATOM   2888  O   ILE B 175      16.485  48.680 165.927  1.00 45.58           O  
ATOM   2889  CB  ILE B 175      19.593  47.097 165.650  1.00 44.53           C  
ATOM   2890  CG1 ILE B 175      21.068  47.480 165.496  1.00 44.58           C  
ATOM   2891  CG2 ILE B 175      18.980  46.750 164.296  1.00 44.87           C  
ATOM   2892  CD1 ILE B 175      21.923  46.400 164.852  1.00 43.66           C  
ATOM   2893  N   ILE B 187       5.280  45.672 162.496  1.00 40.02           N  
ATOM   2894  CA  ILE B 187       5.824  45.818 163.842  1.00 39.53           C  
ATOM   2895  C   ILE B 187       4.909  46.753 164.628  1.00 39.26           C  
ATOM   2896  O   ILE B 187       3.838  46.360 165.089  1.00 39.00           O  
ATOM   2897  CB  ILE B 187       7.232  46.443 163.819  1.00 40.33           C  
ATOM   2898  CG1 ILE B 187       8.041  45.901 162.638  1.00 40.08           C  
ATOM   2899  CG2 ILE B 187       7.957  46.123 165.122  1.00 39.34           C  
ATOM   2900  CD1 ILE B 187       9.377  46.592 162.460  1.00 39.38           C  
ATOM   2901  N   ARG B 188       5.345  47.999 164.770  1.00 38.64           N  
ATOM   2902  CA  ARG B 188       4.574  49.016 165.473  1.00 37.98           C  
ATOM   2903  C   ARG B 188       3.137  49.036 164.940  1.00 37.11           C  
ATOM   2904  O   ARG B 188       2.175  49.018 165.710  1.00 36.24           O  
ATOM   2905  CB  ARG B 188       5.230  50.379 165.255  1.00 40.06           C  
ATOM   2906  CG  ARG B 188       5.426  50.693 163.779  1.00 42.47           C  
ATOM   2907  CD  ARG B 188       6.148  52.003 163.537  1.00 44.47           C  
ATOM   2908  NE  ARG B 188       6.246  52.286 162.105  1.00 45.48           N  
ATOM   2909  CZ  ARG B 188       6.808  53.374 161.588  1.00 45.92           C  
ATOM   2910  NH1 ARG B 188       7.333  54.294 162.386  1.00 45.65           N  
ATOM   2911  NH2 ARG B 188       6.834  53.548 160.273  1.00 46.27           N  
ATOM   2912  N   ARG B 189       2.998  49.064 163.614  1.00 35.92           N  
ATOM   2913  CA  ARG B 189       1.681  49.099 162.984  1.00 35.08           C  
ATOM   2914  C   ARG B 189       0.910  47.789 163.162  1.00 33.81           C  
ATOM   2915  O   ARG B 189      -0.315  47.800 163.294  1.00 33.20           O  
ATOM   2916  CB  ARG B 189       1.818  49.424 161.487  1.00 36.42           C  
ATOM   2917  CG  ARG B 189       2.634  50.683 161.200  1.00 38.31           C  
ATOM   2918  CD  ARG B 189       2.019  51.937 161.831  1.00 40.64           C  
ATOM   2919  NE  ARG B 189       3.036  52.966 162.067  1.00 42.44           N  
ATOM   2920  CZ  ARG B 189       2.791  54.189 162.533  1.00 42.75           C  
ATOM   2921  NH1 ARG B 189       1.552  54.569 162.821  1.00 41.93           N  
ATOM   2922  NH2 ARG B 189       3.798  55.033 162.723  1.00 43.67           N  
ATOM   2923  N   PHE B 190       1.627  46.666 163.161  1.00 32.78           N  
ATOM   2924  CA  PHE B 190       0.997  45.358 163.327  1.00 33.09           C  
ATOM   2925  C   PHE B 190       0.339  45.216 164.705  1.00 32.71           C  
ATOM   2926  O   PHE B 190      -0.794  44.746 164.813  1.00 32.99           O  
ATOM   2927  CB  PHE B 190       2.033  44.247 163.117  1.00 32.00           C  
ATOM   2928  CG  PHE B 190       1.482  42.857 163.278  1.00 31.94           C  
ATOM   2929  CD1 PHE B 190       0.228  42.521 162.773  1.00 31.29           C  
ATOM   2930  CD2 PHE B 190       2.229  41.875 163.922  1.00 32.42           C  
ATOM   2931  CE1 PHE B 190      -0.274  41.227 162.908  1.00 31.65           C  
ATOM   2932  CE2 PHE B 190       1.739  40.577 164.064  1.00 31.23           C  
ATOM   2933  CZ  PHE B 190       0.482  40.254 163.556  1.00 31.36           C  
ATOM   2934  N   TYR B 191       1.046  45.613 165.758  1.00 32.52           N  
ATOM   2935  CA  TYR B 191       0.488  45.526 167.103  1.00 31.65           C  
ATOM   2936  C   TYR B 191      -0.618  46.564 167.242  1.00 31.53           C  
ATOM   2937  O   TYR B 191      -1.518  46.423 168.070  1.00 29.63           O  
ATOM   2938  CB  TYR B 191       1.575  45.757 168.149  1.00 32.83           C  
ATOM   2939  CG  TYR B 191       2.526  44.587 168.296  1.00 34.33           C  
ATOM   2940  CD1 TYR B 191       2.084  43.367 168.804  1.00 36.46           C  
ATOM   2941  CD2 TYR B 191       3.863  44.698 167.924  1.00 35.66           C  
ATOM   2942  CE1 TYR B 191       2.952  42.285 168.940  1.00 37.32           C  
ATOM   2943  CE2 TYR B 191       4.742  43.622 168.057  1.00 38.07           C  
ATOM   2944  CZ  TYR B 191       4.277  42.421 168.566  1.00 37.97           C  
ATOM   2945  OH  TYR B 191       5.140  41.358 168.692  1.00 40.44           O  
ATOM   2946  N   GLU B 192      -0.542  47.613 166.425  1.00 30.30           N  
ATOM   2947  CA  GLU B 192      -1.560  48.652 166.440  1.00 31.04           C  
ATOM   2948  C   GLU B 192      -2.796  48.052 165.790  1.00 29.12           C  
ATOM   2949  O   GLU B 192      -3.928  48.361 166.165  1.00 29.65           O  
ATOM   2950  CB  GLU B 192      -1.076  49.879 165.664  1.00 33.02           C  
ATOM   2951  CG  GLU B 192      -0.146  50.768 166.469  1.00 36.00           C  
ATOM   2952  CD  GLU B 192       0.611  51.755 165.610  1.00 37.48           C  
ATOM   2953  OE1 GLU B 192       0.025  52.261 164.631  1.00 40.00           O  
ATOM   2954  OE2 GLU B 192       1.789  52.034 165.919  1.00 37.69           O  
ATOM   2955  N   LEU B 193      -2.556  47.175 164.821  1.00 26.90           N  
ATOM   2956  CA  LEU B 193      -3.617  46.476 164.111  1.00 26.71           C  
ATOM   2957  C   LEU B 193      -4.355  45.643 165.155  1.00 26.23           C  
ATOM   2958  O   LEU B 193      -5.580  45.705 165.265  1.00 25.69           O  
ATOM   2959  CB  LEU B 193      -3.012  45.541 163.061  1.00 26.27           C  
ATOM   2960  CG  LEU B 193      -3.876  44.881 161.982  1.00 26.90           C  
ATOM   2961  CD1 LEU B 193      -3.210  43.593 161.568  1.00 26.22           C  
ATOM   2962  CD2 LEU B 193      -5.277  44.599 162.474  1.00 27.98           C  
ATOM   2963  N   ILE B 194      -3.588  44.866 165.918  1.00 26.06           N  
ATOM   2964  CA  ILE B 194      -4.145  44.010 166.967  1.00 25.90           C  
ATOM   2965  C   ILE B 194      -4.908  44.853 167.981  1.00 26.03           C  
ATOM   2966  O   ILE B 194      -6.025  44.515 168.368  1.00 24.03           O  
ATOM   2967  CB  ILE B 194      -3.040  43.247 167.733  1.00 26.97           C  
ATOM   2968  CG1 ILE B 194      -2.130  42.503 166.756  1.00 27.72           C  
ATOM   2969  CG2 ILE B 194      -3.675  42.263 168.706  1.00 25.63           C  
ATOM   2970  CD1 ILE B 194      -2.831  41.439 165.959  1.00 28.26           C  
ATOM   2971  N   ALA B 195      -4.288  45.945 168.416  1.00 27.28           N  
ATOM   2972  CA  ALA B 195      -4.917  46.846 169.373  1.00 30.32           C  
ATOM   2973  C   ALA B 195      -6.217  47.372 168.776  1.00 31.37           C  
ATOM   2974  O   ALA B 195      -7.180  47.645 169.492  1.00 32.75           O  
ATOM   2975  CB  ALA B 195      -3.983  48.003 169.691  1.00 31.78           C  
ATOM   2976  N   ALA B 196      -6.241  47.497 167.454  1.00 31.24           N  
ATOM   2977  CA  ALA B 196      -7.419  47.993 166.752  1.00 30.87           C  
ATOM   2978  C   ALA B 196      -8.419  46.883 166.456  1.00 30.34           C  
ATOM   2979  O   ALA B 196      -9.405  47.106 165.751  1.00 29.39           O  
ATOM   2980  CB  ALA B 196      -7.001  48.679 165.453  1.00 31.74           C  
ATOM   2981  N   GLU B 197      -8.160  45.689 166.989  1.00 28.34           N  
ATOM   2982  CA  GLU B 197      -9.048  44.550 166.784  1.00 27.48           C  
ATOM   2983  C   GLU B 197      -9.750  44.151 168.084  1.00 27.14           C  
ATOM   2984  O   GLU B 197      -9.198  43.415 168.904  1.00 27.66           O  
ATOM   2985  CB  GLU B 197      -8.267  43.356 166.230  1.00 26.41           C  
ATOM   2986  CG  GLU B 197      -9.120  42.121 166.020  1.00 26.38           C  
ATOM   2987  CD  GLU B 197     -10.347  42.386 165.167  1.00 28.04           C  
ATOM   2988  OE1 GLU B 197     -10.208  42.517 163.929  1.00 28.17           O  
ATOM   2989  OE2 GLU B 197     -11.452  42.470 165.738  1.00 25.17           O  
ATOM   2990  N   PRO B 198     -10.991  44.624 168.276  1.00 27.42           N  
ATOM   2991  CA  PRO B 198     -11.814  44.352 169.458  1.00 26.06           C  
ATOM   2992  C   PRO B 198     -12.122  42.880 169.731  1.00 24.68           C  
ATOM   2993  O   PRO B 198     -12.376  42.510 170.873  1.00 23.71           O  
ATOM   2994  CB  PRO B 198     -13.090  45.152 169.185  1.00 26.88           C  
ATOM   2995  CG  PRO B 198     -12.597  46.287 168.324  1.00 28.70           C  
ATOM   2996  CD  PRO B 198     -11.672  45.576 167.379  1.00 27.29           C  
ATOM   2997  N   ARG B 199     -12.109  42.053 168.690  1.00 23.63           N  
ATOM   2998  CA  ARG B 199     -12.406  40.629 168.838  1.00 23.85           C  
ATOM   2999  C   ARG B 199     -11.331  39.799 169.527  1.00 21.89           C  
ATOM   3000  O   ARG B 199     -11.514  38.594 169.725  1.00 23.33           O  
ATOM   3001  CB  ARG B 199     -12.713  39.998 167.477  1.00 27.04           C  
ATOM   3002  CG  ARG B 199     -14.092  40.327 166.931  1.00 30.99           C  
ATOM   3003  CD  ARG B 199     -14.332  39.619 165.609  1.00 34.13           C  
ATOM   3004  NE  ARG B 199     -13.306  39.964 164.631  1.00 38.21           N  
ATOM   3005  CZ  ARG B 199     -13.268  39.497 163.389  1.00 38.96           C  
ATOM   3006  NH1 ARG B 199     -14.202  38.657 162.962  1.00 38.95           N  
ATOM   3007  NH2 ARG B 199     -12.299  39.882 162.570  1.00 40.18           N  
ATOM   3008  N   VAL B 200     -10.212  40.419 169.883  1.00 19.85           N  
ATOM   3009  CA  VAL B 200      -9.142  39.687 170.553  1.00 18.77           C  
ATOM   3010  C   VAL B 200      -8.530  40.456 171.714  1.00 17.82           C  
ATOM   3011  O   VAL B 200      -8.601  41.683 171.780  1.00 19.52           O  
ATOM   3012  CB  VAL B 200      -7.993  39.329 169.576  1.00 18.45           C  
ATOM   3013  CG1 VAL B 200      -8.545  38.641 168.345  1.00 15.94           C  
ATOM   3014  CG2 VAL B 200      -7.223  40.578 169.199  1.00 20.12           C  
ATOM   3015  N   SER B 201      -7.928  39.714 172.633  1.00 17.17           N  
ATOM   3016  CA  SER B 201      -7.245  40.278 173.788  1.00 18.02           C  
ATOM   3017  C   SER B 201      -5.850  39.670 173.660  1.00 17.67           C  
ATOM   3018  O   SER B 201      -5.734  38.463 173.486  1.00 18.00           O  
ATOM   3019  CB  SER B 201      -7.914  39.800 175.080  1.00 17.29           C  
ATOM   3020  OG  SER B 201      -7.293  40.382 176.206  1.00 21.45           O  
ATOM   3021  N   ALA B 202      -4.801  40.478 173.743  1.00 16.68           N  
ATOM   3022  CA  ALA B 202      -3.464  39.929 173.567  1.00 17.92           C  
ATOM   3023  C   ALA B 202      -2.357  40.548 174.389  1.00 17.08           C  
ATOM   3024  O   ALA B 202      -2.515  41.609 174.981  1.00 17.68           O  
ATOM   3025  CB  ALA B 202      -3.082  40.007 172.087  1.00 19.64           C  
ATOM   3026  N   THR B 203      -1.221  39.854 174.411  1.00 15.57           N  
ATOM   3027  CA  THR B 203      -0.027  40.324 175.085  1.00 14.93           C  
ATOM   3028  C   THR B 203       1.151  39.950 174.186  1.00 15.65           C  
ATOM   3029  O   THR B 203       0.981  39.239 173.185  1.00 15.97           O  
ATOM   3030  CB  THR B 203       0.153  39.691 176.496  1.00 17.24           C  
ATOM   3031  OG1 THR B 203       1.248  40.330 177.158  1.00 16.60           O  
ATOM   3032  CG2 THR B 203       0.436  38.198 176.399  1.00 15.07           C  
ATOM   3033  N   ALA B 204       2.332  40.450 174.518  1.00 16.30           N  
ATOM   3034  CA  ALA B 204       3.524  40.154 173.734  1.00 18.86           C  
ATOM   3035  C   ALA B 204       4.588  39.545 174.628  1.00 18.78           C  
ATOM   3036  O   ALA B 204       4.802  39.999 175.752  1.00 19.33           O  
ATOM   3037  CB  ALA B 204       4.050  41.420 173.075  1.00 19.07           C  
ATOM   3038  N   LEU B 205       5.262  38.521 174.112  1.00 19.37           N  
ATOM   3039  CA  LEU B 205       6.298  37.814 174.851  1.00 21.48           C  
ATOM   3040  C   LEU B 205       7.515  37.583 173.962  1.00 21.46           C  
ATOM   3041  O   LEU B 205       7.485  37.865 172.770  1.00 21.19           O  
ATOM   3042  CB  LEU B 205       5.776  36.444 175.286  1.00 21.78           C  
ATOM   3043  CG  LEU B 205       4.330  36.426 175.765  1.00 23.70           C  
ATOM   3044  CD1 LEU B 205       3.726  35.048 175.548  1.00 24.36           C  
ATOM   3045  CD2 LEU B 205       4.296  36.843 177.224  1.00 24.66           C  
ATOM   3046  N   GLN B 206       8.577  37.059 174.556  1.00 21.25           N  
ATOM   3047  CA  GLN B 206       9.786  36.740 173.810  1.00 23.28           C  
ATOM   3048  C   GLN B 206      10.388  35.496 174.451  1.00 24.32           C  
ATOM   3049  O   GLN B 206      10.121  35.189 175.617  1.00 23.46           O  
ATOM   3050  CB  GLN B 206      10.792  37.893 173.865  1.00 24.30           C  
ATOM   3051  CG  GLN B 206      11.579  37.981 175.163  1.00 29.55           C  
ATOM   3052  CD  GLN B 206      12.617  39.098 175.158  1.00 31.79           C  
ATOM   3053  OE1 GLN B 206      13.439  39.206 176.069  1.00 33.09           O  
ATOM   3054  NE2 GLN B 206      12.576  39.938 174.130  1.00 33.77           N  
ATOM   3055  N   THR B 207      11.187  34.777 173.677  1.00 23.87           N  
ATOM   3056  CA  THR B 207      11.853  33.579 174.155  1.00 24.45           C  
ATOM   3057  C   THR B 207      13.185  33.558 173.407  1.00 24.65           C  
ATOM   3058  O   THR B 207      13.265  34.081 172.294  1.00 23.12           O  
ATOM   3059  CB  THR B 207      11.018  32.321 173.828  1.00 25.84           C  
ATOM   3060  OG1 THR B 207      11.546  31.197 174.539  1.00 28.95           O  
ATOM   3061  CG2 THR B 207      11.041  32.031 172.335  1.00 24.47           C  
ATOM   3062  N   VAL B 208      14.228  32.988 174.003  1.00 24.31           N  
ATOM   3063  CA  VAL B 208      15.523  32.967 173.327  1.00 25.64           C  
ATOM   3064  C   VAL B 208      15.548  31.945 172.205  1.00 25.71           C  
ATOM   3065  O   VAL B 208      14.815  30.961 172.235  1.00 24.42           O  
ATOM   3066  CB  VAL B 208      16.688  32.653 174.297  1.00 25.65           C  
ATOM   3067  CG1 VAL B 208      16.685  31.180 174.679  1.00 25.71           C  
ATOM   3068  CG2 VAL B 208      18.011  33.037 173.650  1.00 27.01           C  
ATOM   3069  N   GLY B 209      16.398  32.193 171.212  1.00 26.68           N  
ATOM   3070  CA  GLY B 209      16.525  31.284 170.089  1.00 29.39           C  
ATOM   3071  C   GLY B 209      17.983  31.162 169.688  1.00 31.89           C  
ATOM   3072  O   GLY B 209      18.853  31.767 170.315  1.00 32.56           O  
ATOM   3073  N   SER B 210      18.256  30.394 168.638  1.00 34.18           N  
ATOM   3074  CA  SER B 210      19.624  30.205 168.173  1.00 35.83           C  
ATOM   3075  C   SER B 210      20.275  31.510 167.731  1.00 37.48           C  
ATOM   3076  O   SER B 210      21.429  31.777 168.071  1.00 38.54           O  
ATOM   3077  CB  SER B 210      19.656  29.197 167.024  1.00 35.32           C  
ATOM   3078  OG  SER B 210      18.822  29.604 165.956  1.00 35.43           O  
ATOM   3079  N   LYS B 211      19.537  32.320 166.977  1.00 39.18           N  
ATOM   3080  CA  LYS B 211      20.054  33.596 166.490  1.00 40.31           C  
ATOM   3081  C   LYS B 211      19.309  34.795 167.071  1.00 40.41           C  
ATOM   3082  O   LYS B 211      18.787  35.627 166.332  1.00 42.18           O  
ATOM   3083  CB  LYS B 211      19.992  33.633 164.957  1.00 41.83           C  
ATOM   3084  CG  LYS B 211      20.940  32.632 164.303  1.00 42.66           C  
ATOM   3085  CD  LYS B 211      20.871  32.650 162.782  1.00 43.37           C  
ATOM   3086  CE  LYS B 211      19.532  32.144 162.274  1.00 44.35           C  
ATOM   3087  NZ  LYS B 211      19.499  32.059 160.790  1.00 43.95           N  
ATOM   3088  N   GLY B 212      19.268  34.881 168.399  1.00 39.24           N  
ATOM   3089  CA  GLY B 212      18.592  35.988 169.058  1.00 37.25           C  
ATOM   3090  C   GLY B 212      17.299  35.593 169.748  1.00 35.98           C  
ATOM   3091  O   GLY B 212      17.006  34.412 169.918  1.00 36.89           O  
ATOM   3092  N   TYR B 213      16.520  36.588 170.151  1.00 34.52           N  
ATOM   3093  CA  TYR B 213      15.253  36.332 170.818  1.00 32.20           C  
ATOM   3094  C   TYR B 213      14.078  36.403 169.850  1.00 31.91           C  
ATOM   3095  O   TYR B 213      14.023  37.278 168.987  1.00 32.17           O  
ATOM   3096  CB  TYR B 213      15.038  37.332 171.956  1.00 29.74           C  
ATOM   3097  CG  TYR B 213      15.980  37.147 173.116  1.00 28.25           C  
ATOM   3098  CD1 TYR B 213      17.305  37.582 173.042  1.00 28.44           C  
ATOM   3099  CD2 TYR B 213      15.561  36.503 174.279  1.00 28.11           C  
ATOM   3100  CE1 TYR B 213      18.185  37.375 174.097  1.00 29.10           C  
ATOM   3101  CE2 TYR B 213      16.435  36.290 175.341  1.00 28.71           C  
ATOM   3102  CZ  TYR B 213      17.745  36.725 175.243  1.00 29.44           C  
ATOM   3103  OH  TYR B 213      18.623  36.493 176.279  1.00 30.27           O  
ATOM   3104  N   ASP B 214      13.143  35.467 169.999  1.00 30.85           N  
ATOM   3105  CA  ASP B 214      11.951  35.411 169.161  1.00 30.55           C  
ATOM   3106  C   ASP B 214      10.853  36.243 169.804  1.00 29.26           C  
ATOM   3107  O   ASP B 214      10.432  35.955 170.918  1.00 27.28           O  
ATOM   3108  CB  ASP B 214      11.441  33.976 169.037  1.00 33.45           C  
ATOM   3109  CG  ASP B 214      12.313  33.113 168.156  1.00 36.53           C  
ATOM   3110  OD1 ASP B 214      13.528  33.006 168.429  1.00 39.14           O  
ATOM   3111  OD2 ASP B 214      11.771  32.529 167.193  1.00 38.17           O  
ATOM   3112  N   GLY B 215      10.397  37.278 169.109  1.00 28.05           N  
ATOM   3113  CA  GLY B 215       9.326  38.096 169.646  1.00 26.56           C  
ATOM   3114  C   GLY B 215       8.007  37.580 169.109  1.00 25.64           C  
ATOM   3115  O   GLY B 215       7.909  37.264 167.923  1.00 26.11           O  
ATOM   3116  N   PHE B 216       6.989  37.459 169.959  1.00 22.40           N  
ATOM   3117  CA  PHE B 216       5.699  36.986 169.472  1.00 20.22           C  
ATOM   3118  C   PHE B 216       4.500  37.469 170.272  1.00 18.86           C  
ATOM   3119  O   PHE B 216       4.620  37.866 171.426  1.00 19.57           O  
ATOM   3120  CB  PHE B 216       5.670  35.452 169.383  1.00 18.62           C  
ATOM   3121  CG  PHE B 216       5.890  34.750 170.697  1.00 18.60           C  
ATOM   3122  CD1 PHE B 216       7.173  34.545 171.190  1.00 18.53           C  
ATOM   3123  CD2 PHE B 216       4.812  34.277 171.430  1.00 18.90           C  
ATOM   3124  CE1 PHE B 216       7.384  33.873 172.399  1.00 20.46           C  
ATOM   3125  CE2 PHE B 216       5.008  33.603 172.644  1.00 20.90           C  
ATOM   3126  CZ  PHE B 216       6.295  33.401 173.127  1.00 18.22           C  
ATOM   3127  N   ILE B 217       3.342  37.447 169.629  1.00 18.63           N  
ATOM   3128  CA  ILE B 217       2.102  37.868 170.269  1.00 18.79           C  
ATOM   3129  C   ILE B 217       1.309  36.629 170.670  1.00 16.47           C  
ATOM   3130  O   ILE B 217       1.343  35.608 169.992  1.00 15.19           O  
ATOM   3131  CB  ILE B 217       1.215  38.700 169.314  1.00 19.45           C  
ATOM   3132  CG1 ILE B 217      -0.059  39.147 170.036  1.00 23.30           C  
ATOM   3133  CG2 ILE B 217       0.837  37.871 168.100  1.00 21.50           C  
ATOM   3134  CD1 ILE B 217      -1.112  39.751 169.131  1.00 24.95           C  
HETATM 3135  N   MSE B 218       0.622  36.715 171.801  1.00 15.52           N  
HETATM 3136  CA  MSE B 218      -0.221  35.627 172.243  1.00 13.64           C  
HETATM 3137  C   MSE B 218      -1.581  36.294 172.391  1.00 14.17           C  
HETATM 3138  O   MSE B 218      -1.715  37.251 173.151  1.00 14.94           O  
HETATM 3139  CB  MSE B 218       0.226  35.072 173.599  1.00 14.92           C  
HETATM 3140  CG  MSE B 218      -0.708  34.002 174.115  1.00 20.47           C  
HETATM 3141 SE   MSE B 218      -0.198  33.283 175.838  1.00 30.02          SE  
HETATM 3142  CE  MSE B 218      -1.302  34.412 176.981  1.00 27.07           C  
ATOM   3143  N   ALA B 219      -2.575  35.810 171.660  1.00 12.92           N  
ATOM   3144  CA  ALA B 219      -3.903  36.399 171.739  1.00 14.46           C  
ATOM   3145  C   ALA B 219      -4.999  35.361 171.924  1.00 15.00           C  
ATOM   3146  O   ALA B 219      -4.845  34.197 171.547  1.00 15.71           O  
ATOM   3147  CB  ALA B 219      -4.177  37.214 170.482  1.00 14.53           C  
ATOM   3148  N   VAL B 220      -6.112  35.789 172.514  1.00 12.94           N  
ATOM   3149  CA  VAL B 220      -7.252  34.904 172.704  1.00 13.07           C  
ATOM   3150  C   VAL B 220      -8.482  35.589 172.117  1.00 11.74           C  
ATOM   3151  O   VAL B 220      -8.747  36.757 172.410  1.00 15.17           O  
ATOM   3152  CB  VAL B 220      -7.514  34.605 174.196  1.00 13.27           C  
ATOM   3153  CG1 VAL B 220      -8.671  33.628 174.319  1.00 13.76           C  
ATOM   3154  CG2 VAL B 220      -6.262  34.025 174.839  1.00 15.73           C  
ATOM   3155  N   VAL B 221      -9.216  34.874 171.278  1.00 13.38           N  
ATOM   3156  CA  VAL B 221     -10.401  35.437 170.651  1.00 14.82           C  
ATOM   3157  C   VAL B 221     -11.509  35.578 171.686  1.00 16.14           C  
ATOM   3158  O   VAL B 221     -11.805  34.628 172.410  1.00 15.14           O  
ATOM   3159  CB  VAL B 221     -10.877  34.551 169.493  1.00 16.08           C  
ATOM   3160  CG1 VAL B 221     -12.088  35.173 168.825  1.00 16.92           C  
ATOM   3161  CG2 VAL B 221      -9.743  34.373 168.486  1.00 16.28           C  
ATOM   3162  N   LYS B 222     -12.103  36.767 171.749  1.00 19.03           N  
ATOM   3163  CA  LYS B 222     -13.168  37.051 172.712  1.00 23.17           C  
ATOM   3164  C   LYS B 222     -14.496  36.424 172.322  1.00 25.00           C  
ATOM   3165  O   LYS B 222     -14.667  36.082 171.131  1.00 26.83           O  
ATOM   3166  CB  LYS B 222     -13.364  38.563 172.865  1.00 23.80           C  
ATOM   3167  CG  LYS B 222     -12.201  39.313 173.478  1.00 26.15           C  
ATOM   3168  CD  LYS B 222     -12.483  40.811 173.469  1.00 30.10           C  
ATOM   3169  CE  LYS B 222     -11.325  41.617 174.021  1.00 33.14           C  
ATOM   3170  NZ  LYS B 222     -11.142  41.400 175.488  1.00 36.69           N  
TER    3171      LYS B 222                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
