
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  225 ( 1775),  selected  225 , name 3c3y_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 3c3y_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    L    15_A      -       -           -
LGA    Q    16_A      -       -           -
LGA    S    17_A      N       3          2.625
LGA    E    18_A      -       -           -
LGA    E    19_A      -       -           -
LGA    L    20_A      A       4          3.128
LGA    C    21_A      F       5          3.669
LGA    Q    22_A      E       6          3.503
LGA    Y    23_A      Y       7          2.288
LGA    I    24_A      L       8          2.254
LGA    L    25_A      R       9          2.797
LGA    R    26_A      T      10          3.284
LGA    T    27_A      Y      11          2.183
LGA    S    28_A      V      12          2.407
LGA    V    29_A      E      13          4.004
LGA    Y    30_A      S      14          4.909
LGA    P    31_A      T      15          3.220
LGA    R    32_A      T      16          3.076
LGA    E    33_A      E      17           #
LGA    A    34_A      T      18          5.093
LGA    G    35_A      D      19          0.999
LGA    F    36_A      A      20          3.372
LGA    -       -      A      21           -
LGA    L    37_A      V      22          1.180
LGA    K    38_A      A      23          1.512
LGA    E    39_A      R      24          1.694
LGA    L    40_A      A      25          1.114
LGA    R    41_A      R      26          0.776
LGA    E    42_A      E      27          1.449
LGA    A    43_A      D      28          2.008
LGA    N    44_A      A      29          1.826
LGA    E    45_A      A      30          1.850
LGA    S    46_A      E      31          1.243
LGA    H    47_A      F      32          1.188
LGA    P    48_A      G      33          3.325
LGA    D    49_A      -       -           -
LGA    S    50_A      -       -           -
LGA    Y    51_A      L      34          5.413
LGA    M    52_A      P      35          1.027
LGA    S    53_A      A      36          1.092
LGA    T    54_A      P      37          1.593
LGA    S    55_A      D      38          2.314
LGA    P    56_A      E      39          1.891
LGA    L    57_A      M      40          1.532
LGA    A    58_A      T      41          1.468
LGA    G    59_A      G      42          1.440
LGA    Q    60_A      Q      43          1.383
LGA    L    61_A      L      44          1.292
LGA    M    62_A      L      45          1.645
LGA    S    63_A      T      46          1.284
LGA    F    64_A      T      47          1.476
LGA    V    65_A      L      48          2.038
LGA    L    66_A      A      49          1.881
LGA    K    67_A      A      50          1.312
LGA    L    68_A      T      51          2.023
LGA    V    69_A      T      52          2.480
LGA    N    70_A      N      53          4.233
LGA    A    71_A      G      54          4.067
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    K    72_A      S      57           #
LGA    K    73_A      T      58          3.355
LGA    T    74_A      G      59          3.190
LGA    I    75_A      A      60          3.635
LGA    E    76_A      I      61          2.811
LGA    V    77_A      A      62          4.708
LGA    G    78_A      I      63          2.571
LGA    V    79_A      T      64          2.380
LGA    F    80_A      P      65          1.236
LGA    T    81_A      A      66          2.513
LGA    G    82_A      A      67          2.625
LGA    -       -      G      68           -
LGA    Y    83_A      L      69          1.601
LGA    S    84_A      V      70          1.174
LGA    L    85_A      G      71          1.736
LGA    L    86_A      L      72          1.834
LGA    L    87_A      Y      73          1.180
LGA    T    88_A      I      74          0.923
LGA    A    89_A      L      75          1.615
LGA    L    90_A      N      76          2.027
LGA    S    91_A      G      77          1.966
LGA    I    92_A      L      78          1.068
LGA    P    93_A      A      79          2.424
LGA    D    94_A      D      80          2.555
LGA    D    95_A      N      81          2.494
LGA    G    96_A      T      82          2.328
LGA    K    97_A      T      83          0.525
LGA    I    98_A      L      84          1.417
LGA    T    99_A      T      85          1.568
LGA    A   100_A      C      86          1.250
LGA    I   101_A      I      87          0.935
LGA    D   102_A      D      88          0.919
LGA    F   103_A      P      89          1.104
LGA    D   104_A      E      90          1.609
LGA    R   105_A      S      91          2.312
LGA    E   106_A      E      92          1.579
LGA    A   107_A      H      93          2.776
LGA    Y   108_A      Q      94          3.791
LGA    E   109_A      R      95          2.711
LGA    I   110_A      Q      96          3.000
LGA    G   111_A      A      97          4.020
LGA    L   112_A      K      98          3.470
LGA    P   113_A      A      99          2.712
LGA    F   114_A      L     100          2.347
LGA    I   115_A      F     101          1.644
LGA    R   116_A      R     102          1.304
LGA    K   117_A      E     103          1.643
LGA    A   118_A      A     104          1.290
LGA    G   119_A      G     105          1.951
LGA    V   120_A      Y     106          2.314
LGA    -       -      S     107           -
LGA    E   121_A      P     108          3.953
LGA    H   122_A      S     109          2.924
LGA    K   123_A      R     110          1.386
LGA    I   124_A      V     111          1.168
LGA    N   125_A      R     112          0.589
LGA    F   126_A      F     113          0.443
LGA    I   127_A      L     114          0.265
LGA    E   128_A      L     115          0.537
LGA    S   129_A      S     116          0.581
LGA    D   130_A      R     117          1.387
LGA    A   131_A      P     118          1.126
LGA    M   132_A      L     119          1.419
LGA    L   133_A      D     120          1.452
LGA    A   134_A      V     121          0.644
LGA    L   135_A      M     122          0.501
LGA    D   136_A      S     123          0.594
LGA    N   137_A      R     124          1.565
LGA    L   138_A      L     125          1.597
LGA    L   139_A      -       -           -
LGA    Q   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    Q   142_A      -       -           -
LGA    E   143_A      -       -           -
LGA    S   144_A      A     126          1.760
LGA    E   145_A      N     127          1.736
LGA    G   146_A      D     128          1.065
LGA    S   147_A      S     129          1.136
LGA    Y   148_A      Y     130          0.853
LGA    D   149_A      Q     131          0.927
LGA    F   150_A      L     132          1.018
LGA    G   151_A      V     133          1.105
LGA    F   152_A      F     134          1.230
LGA    V   153_A      G     135          1.908
LGA    D   154_A      Q     136          1.652
LGA    A   155_A      V     137          2.324
LGA    D   156_A      S     138          3.178
LGA    K   157_A      P     139          2.644
LGA    P   158_A      M     140          1.351
LGA    N   159_A      D     141          1.984
LGA    Y   160_A      L     142          1.720
LGA    I   161_A      K     143          1.161
LGA    K   162_A      A     144          1.731
LGA    Y   163_A      L     145          1.833
LGA    H   164_A      V     146          1.294
LGA    E   165_A      D     147          1.631
LGA    R   166_A      A     148          2.226
LGA    L   167_A      A     149          1.499
LGA    M   168_A      W     150          1.435
LGA    K   169_A      P     151          0.939
LGA    L   170_A      L     152          0.735
LGA    V   171_A      L     153          0.882
LGA    K   172_A      R     154          0.903
LGA    V   173_A      R     155          1.614
LGA    G   174_A      G     156          1.946
LGA    G   175_A      G     157          1.383
LGA    I   176_A      A     158          1.298
LGA    V   177_A      L     159          1.246
LGA    A   178_A      V     160          1.315
LGA    Y   179_A      L     161          1.143
LGA    D   180_A      A     162          1.199
LGA    N   181_A      D     163          1.159
LGA    T   182_A      A     164          1.491
LGA    L   183_A      L     165          1.403
LGA    W   184_A      L     166          1.512
LGA    G   185_A      D     167          3.768
LGA    G   186_A      G     168          3.348
LGA    T   187_A      T     169          1.976
LGA    V   188_A      I     170          1.448
LGA    A   189_A      A     171          3.858
LGA    Q   190_A      D     172          3.141
LGA    P   191_A      Q     173          2.793
LGA    E   192_A      T     174          3.720
LGA    -       -      R     175           -
LGA    S   193_A      K     176          5.267
LGA    E   194_A      -       -           -
LGA    V   195_A      -       -           -
LGA    P   196_A      -       -           -
LGA    D   197_A      -       -           -
LGA    F   198_A      -       -           -
LGA    M   199_A      -       -           -
LGA    K   200_A      D     177          2.367
LGA    E   201_A      R     178          2.230
LGA    N   202_A      D     179          2.106
LGA    R   203_A      T     180          1.420
LGA    E   204_A      Q     181          1.450
LGA    A   205_A      A     182          1.404
LGA    V   206_A      A     183          1.023
LGA    I   207_A      R     184          0.723
LGA    E   208_A      D     185          0.727
LGA    L   209_A      A     186          0.711
LGA    N   210_A      D     187          0.514
LGA    K   211_A      E     188          0.414
LGA    L   212_A      Y     189          0.872
LGA    L   213_A      I     190          1.125
LGA    A   214_A      R     191          1.051
LGA    A   215_A      S     192          1.510
LGA    D   216_A      I     193          1.162
LGA    P   217_A      E     194          1.337
LGA    R   218_A      G     195          2.401
LGA    I   219_A      A     196          0.334
LGA    E   220_A      H     197          1.033
LGA    I   221_A      V     198          0.923
LGA    V   222_A      A     199          0.508
LGA    H   223_A      R     200          0.630
LGA    L   224_A      L     201          0.759
LGA    P   225_A      P     202          1.540
LGA    L   226_A      L     203          0.554
LGA    G   227_A      G     204          0.718
LGA    D   228_A      A     205          1.161
LGA    G   229_A      G     206          0.960
LGA    I   230_A      L     207          0.873
LGA    T   231_A      T     208          1.145
LGA    F   232_A      V     209          1.299
LGA    C   233_A      V     210          1.281
LGA    R   234_A      T     211          1.599
LGA    R   235_A      K     212          0.824
LGA    L   236_A      A     213          2.167
LGA    Y   237_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  225  211    5.0    203    2.10    17.73     80.166     9.233

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.886944 * X  +   0.461555 * Y  +  -0.017234 * Z  +   7.905353
  Y_new =   0.461545 * X  +  -0.887104 * Y  +  -0.004808 * Z  +  36.368412
  Z_new =  -0.017508 * X  +  -0.003690 * Y  +  -0.999840 * Z  + 185.721466 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.137902    0.003690  [ DEG:  -179.7886      0.2114 ]
  Theta =   0.017509    3.124084  [ DEG:     1.0032    178.9968 ]
  Phi   =   0.479816   -2.661777  [ DEG:    27.4914   -152.5086 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c3y_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c3y_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  225  211   5.0  203   2.10   17.73  80.166
REMARK  ---------------------------------------------------------- 
MOLECULE 3c3y_A
HEADER    TRANSFERASE                             29-JAN-08   3C3Y              
TITLE     CRYSTAL STRUCTURE OF PFOMT, PHENYLPROPANOID AND FLAVONOID O-          
TITLE    2 METHYLTRANSFERASE FROM M. CRYSTALLINUM                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: O-METHYLTRANSFERASE;                                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PFOMT;                                                      
COMPND   5 EC: 2.1.1.104;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MESEMBRYANTHEMUM CRYSTALLINUM;                  
SOURCE   3 ORGANISM_COMMON: COMMON ICE PLANT;                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: M15 PREP4;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PQE30                                     
KEYWDS    PLANT SECONDARY METABOLISM, O-METHYLTRANSFERASE                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.G.KOPYCKI,D.RAUH,P.NEUMANN,M.T.STUBBS                               
REVDAT   2   08-APR-08 3C3Y    1       JRNL                                     
REVDAT   1   01-APR-08 3C3Y    0                                                
JRNL        AUTH   J.G.KOPYCKI,D.RAUH,A.A.CHUMANEVICH,P.NEUMANN,                
JRNL        AUTH 2 T.VOGT,M.T.STUBBS                                            
JRNL        TITL   BIOCHEMICAL AND STRUCTURAL ANALYSIS OF SUBSTRATE             
JRNL        TITL 2 PROMISCUITY IN PLANT MG(2+)-DEPENDENT                        
JRNL        TITL 3 O-METHYLTRANSFERASES                                         
JRNL        REF    J.MOL.BIOL.                   V. 378   154 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.37 ANGSTROMS.                                          
DBREF  3C3Y A    1   237  UNP    Q6YI95   Q6YI95_MESCR     1    237             
DBREF  3C3Y B    1   237  UNP    Q6YI95   Q6YI95_MESCR     1    237             
SEQRES   1 A  237  MET ASP PHE ALA VAL MET LYS GLN VAL LYS ASN THR GLY          
SEQRES   2 A  237  LEU LEU GLN SER GLU GLU LEU CYS GLN TYR ILE LEU ARG          
SEQRES   3 A  237  THR SER VAL TYR PRO ARG GLU ALA GLY PHE LEU LYS GLU          
SEQRES   4 A  237  LEU ARG GLU ALA ASN GLU SER HIS PRO ASP SER TYR MET          
SEQRES   5 A  237  SER THR SER PRO LEU ALA GLY GLN LEU MET SER PHE VAL          
SEQRES   6 A  237  LEU LYS LEU VAL ASN ALA LYS LYS THR ILE GLU VAL GLY          
SEQRES   7 A  237  VAL PHE THR GLY TYR SER LEU LEU LEU THR ALA LEU SER          
SEQRES   8 A  237  ILE PRO ASP ASP GLY LYS ILE THR ALA ILE ASP PHE ASP          
SEQRES   9 A  237  ARG GLU ALA TYR GLU ILE GLY LEU PRO PHE ILE ARG LYS          
SEQRES  10 A  237  ALA GLY VAL GLU HIS LYS ILE ASN PHE ILE GLU SER ASP          
SEQRES  11 A  237  ALA MET LEU ALA LEU ASP ASN LEU LEU GLN GLY GLN GLU          
SEQRES  12 A  237  SER GLU GLY SER TYR ASP PHE GLY PHE VAL ASP ALA ASP          
SEQRES  13 A  237  LYS PRO ASN TYR ILE LYS TYR HIS GLU ARG LEU MET LYS          
SEQRES  14 A  237  LEU VAL LYS VAL GLY GLY ILE VAL ALA TYR ASP ASN THR          
SEQRES  15 A  237  LEU TRP GLY GLY THR VAL ALA GLN PRO GLU SER GLU VAL          
SEQRES  16 A  237  PRO ASP PHE MET LYS GLU ASN ARG GLU ALA VAL ILE GLU          
SEQRES  17 A  237  LEU ASN LYS LEU LEU ALA ALA ASP PRO ARG ILE GLU ILE          
SEQRES  18 A  237  VAL HIS LEU PRO LEU GLY ASP GLY ILE THR PHE CYS ARG          
SEQRES  19 A  237  ARG LEU TYR                                                  
SEQRES   1 B  237  MET ASP PHE ALA VAL MET LYS GLN VAL LYS ASN THR GLY          
SEQRES   2 B  237  LEU LEU GLN SER GLU GLU LEU CYS GLN TYR ILE LEU ARG          
SEQRES   3 B  237  THR SER VAL TYR PRO ARG GLU ALA GLY PHE LEU LYS GLU          
SEQRES   4 B  237  LEU ARG GLU ALA ASN GLU SER HIS PRO ASP SER TYR MET          
SEQRES   5 B  237  SER THR SER PRO LEU ALA GLY GLN LEU MET SER PHE VAL          
SEQRES   6 B  237  LEU LYS LEU VAL ASN ALA LYS LYS THR ILE GLU VAL GLY          
SEQRES   7 B  237  VAL PHE THR GLY TYR SER LEU LEU LEU THR ALA LEU SER          
SEQRES   8 B  237  ILE PRO ASP ASP GLY LYS ILE THR ALA ILE ASP PHE ASP          
SEQRES   9 B  237  ARG GLU ALA TYR GLU ILE GLY LEU PRO PHE ILE ARG LYS          
SEQRES  10 B  237  ALA GLY VAL GLU HIS LYS ILE ASN PHE ILE GLU SER ASP          
SEQRES  11 B  237  ALA MET LEU ALA LEU ASP ASN LEU LEU GLN GLY GLN GLU          
SEQRES  12 B  237  SER GLU GLY SER TYR ASP PHE GLY PHE VAL ASP ALA ASP          
SEQRES  13 B  237  LYS PRO ASN TYR ILE LYS TYR HIS GLU ARG LEU MET LYS          
SEQRES  14 B  237  LEU VAL LYS VAL GLY GLY ILE VAL ALA TYR ASP ASN THR          
SEQRES  15 B  237  LEU TRP GLY GLY THR VAL ALA GLN PRO GLU SER GLU VAL          
SEQRES  16 B  237  PRO ASP PHE MET LYS GLU ASN ARG GLU ALA VAL ILE GLU          
SEQRES  17 B  237  LEU ASN LYS LEU LEU ALA ALA ASP PRO ARG ILE GLU ILE          
SEQRES  18 B  237  VAL HIS LEU PRO LEU GLY ASP GLY ILE THR PHE CYS ARG          
SEQRES  19 B  237  ARG LEU TYR                                                  
HET     CA  A 238       1                                                       
HET     CA  A 239       1                                                       
HET     CA  B 238       1                                                       
HET    SAH  A 464      26                                                       
HET    SAH  B 465      26                                                       
HETNAM      CA CALCIUM ION                                                      
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   3   CA    3(CA 2+)                                                     
FORMUL   6  SAH    2(C14 H20 N6 O5 S)                                           
FORMUL   8  HOH   *480(H2 O)                                                    
CRYST1   48.890   71.830  128.120  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   GLY A  13      14.038  40.747 167.710  1.00 33.16           N  
ATOM      2  CA  GLY A  13      14.239  41.453 169.006  1.00 32.14           C  
ATOM      3  C   GLY A  13      14.768  40.518 170.065  1.00 31.10           C  
ATOM      4  O   GLY A  13      14.072  39.587 170.481  1.00 32.06           O  
ATOM      5  N   LEU A  14      15.997  40.761 170.514  1.00 28.96           N  
ATOM      6  CA  LEU A  14      16.631  39.837 171.443  1.00 25.93           C  
ATOM      7  C   LEU A  14      17.156  40.419 172.761  1.00 22.32           C  
ATOM      8  O   LEU A  14      16.735  41.490 173.207  1.00 20.96           O  
ATOM      9  CB  LEU A  14      17.650  38.923 170.742  1.00 27.35           C  
ATOM     10  CG  LEU A  14      17.133  37.582 170.207  1.00 28.77           C  
ATOM     11  CD1 LEU A  14      18.273  36.596 169.934  1.00 28.99           C  
ATOM     12  CD2 LEU A  14      16.141  36.967 171.189  1.00 28.59           C  
ATOM     13  N   LEU A  15      18.024  39.659 173.414  1.00 19.30           N  
ATOM     14  CA  LEU A  15      18.355  39.922 174.808  1.00 19.65           C  
ATOM     15  C   LEU A  15      19.622  40.747 174.933  1.00 20.79           C  
ATOM     16  O   LEU A  15      20.272  41.031 173.934  1.00 20.56           O  
ATOM     17  CB  LEU A  15      18.456  38.611 175.603  1.00 18.80           C  
ATOM     18  CG  LEU A  15      17.241  37.680 175.489  1.00 18.97           C  
ATOM     19  CD1 LEU A  15      17.416  36.415 176.335  1.00 19.36           C  
ATOM     20  CD2 LEU A  15      15.957  38.418 175.857  1.00 18.48           C  
ATOM     21  N   GLN A  16      19.953  41.126 176.165  1.00 21.94           N  
ATOM     22  CA  GLN A  16      21.095  41.998 176.439  1.00 23.33           C  
ATOM     23  C   GLN A  16      22.420  41.368 176.022  1.00 23.12           C  
ATOM     24  O   GLN A  16      23.373  42.076 175.661  1.00 24.07           O  
ATOM     25  CB  GLN A  16      21.131  42.388 177.918  1.00 25.09           C  
ATOM     26  CG  GLN A  16      21.096  41.203 178.890  1.00 27.13           C  
ATOM     27  CD  GLN A  16      21.389  41.613 180.323  1.00 28.28           C  
ATOM     28  OE1 GLN A  16      21.126  42.752 180.721  1.00 29.18           O  
ATOM     29  NE2 GLN A  16      21.935  40.683 181.107  1.00 28.16           N  
ATOM     30  N   SER A  17      22.483  40.042 176.061  1.00 22.00           N  
ATOM     31  CA  SER A  17      23.681  39.326 175.666  1.00 22.34           C  
ATOM     32  C   SER A  17      23.387  37.928 175.130  1.00 22.46           C  
ATOM     33  O   SER A  17      22.406  37.300 175.519  1.00 22.09           O  
ATOM     34  CB  SER A  17      24.659  39.246 176.836  1.00 22.76           C  
ATOM     35  OG  SER A  17      24.249  38.286 177.795  1.00 22.24           O  
ATOM     36  N   GLU A  18      24.241  37.453 174.230  1.00 22.92           N  
ATOM     37  CA  GLU A  18      24.185  36.083 173.754  1.00 23.38           C  
ATOM     38  C   GLU A  18      24.366  35.130 174.931  1.00 22.33           C  
ATOM     39  O   GLU A  18      23.738  34.073 174.999  1.00 21.53           O  
ATOM     40  CB  GLU A  18      25.271  35.847 172.705  1.00 25.68           C  
ATOM     41  CG  GLU A  18      25.141  34.521 171.982  1.00 29.05           C  
ATOM     42  CD  GLU A  18      25.998  34.459 170.737  1.00 31.20           C  
ATOM     43  OE1 GLU A  18      25.488  34.006 169.688  1.00 33.16           O  
ATOM     44  OE2 GLU A  18      27.176  34.875 170.803  1.00 32.72           O  
ATOM     45  N   GLU A  19      25.215  35.517 175.870  1.00 20.36           N  
ATOM     46  CA  GLU A  19      25.474  34.730 177.072  1.00 19.86           C  
ATOM     47  C   GLU A  19      24.160  34.431 177.815  1.00 17.27           C  
ATOM     48  O   GLU A  19      23.942  33.313 178.275  1.00 15.77           O  
ATOM     49  CB  GLU A  19      26.433  35.526 177.972  1.00 22.67           C  
ATOM     50  CG  GLU A  19      26.847  34.881 179.276  1.00 25.72           C  
ATOM     51  CD  GLU A  19      27.918  35.683 180.019  1.00 27.16           C  
ATOM     52  OE1 GLU A  19      27.758  36.919 180.162  1.00 28.70           O  
ATOM     53  OE2 GLU A  19      28.917  35.070 180.464  1.00 28.19           O  
ATOM     54  N   LEU A  20      23.299  35.434 177.942  1.00 15.98           N  
ATOM     55  CA  LEU A  20      22.027  35.265 178.652  1.00 15.45           C  
ATOM     56  C   LEU A  20      21.107  34.307 177.902  1.00 14.71           C  
ATOM     57  O   LEU A  20      20.492  33.410 178.489  1.00 13.52           O  
ATOM     58  CB  LEU A  20      21.325  36.609 178.802  1.00 16.27           C  
ATOM     59  CG  LEU A  20      20.084  36.565 179.706  1.00 17.50           C  
ATOM     60  CD1 LEU A  20      20.377  35.872 181.032  1.00 17.14           C  
ATOM     61  CD2 LEU A  20      19.608  37.988 179.950  1.00 18.41           C  
ATOM     62  N   CYS A  21      21.021  34.501 176.596  1.00 14.87           N  
ATOM     63  CA  CYS A  21      20.229  33.632 175.743  1.00 17.09           C  
ATOM     64  C   CYS A  21      20.694  32.176 175.849  1.00 16.93           C  
ATOM     65  O   CYS A  21      19.887  31.268 176.050  1.00 15.57           O  
ATOM     66  CB  CYS A  21      20.311  34.132 174.305  1.00 20.13           C  
ATOM     67  SG  CYS A  21      19.365  33.200 173.151  1.00 25.32           S  
ATOM     68  N   GLN A  22      21.999  31.956 175.713  1.00 16.16           N  
ATOM     69  CA  GLN A  22      22.554  30.597 175.757  1.00 15.06           C  
ATOM     70  C   GLN A  22      22.353  29.947 177.131  1.00 14.37           C  
ATOM     71  O   GLN A  22      22.109  28.730 177.235  1.00 13.37           O  
ATOM     72  CB  GLN A  22      24.034  30.596 175.331  1.00 17.80           C  
ATOM     73  CG  GLN A  22      24.223  31.041 173.866  1.00 20.94           C  
ATOM     74  CD  GLN A  22      23.489  30.139 172.878  1.00 23.52           C  
ATOM     75  OE1 GLN A  22      22.711  30.607 172.038  1.00 26.16           O  
ATOM     76  NE2 GLN A  22      23.715  28.841 172.991  1.00 24.29           N  
ATOM     77  N   TYR A  23      22.406  30.763 178.182  1.00 13.31           N  
ATOM     78  CA  TYR A  23      22.107  30.279 179.531  1.00 12.01           C  
ATOM     79  C   TYR A  23      20.680  29.716 179.603  1.00 11.56           C  
ATOM     80  O   TYR A  23      20.479  28.622 180.128  1.00 11.83           O  
ATOM     81  CB  TYR A  23      22.230  31.407 180.562  1.00 11.60           C  
ATOM     82  CG  TYR A  23      21.719  31.003 181.932  1.00 10.71           C  
ATOM     83  CD1 TYR A  23      22.531  30.275 182.808  1.00 11.38           C  
ATOM     84  CD2 TYR A  23      20.389  31.293 182.334  1.00 10.65           C  
ATOM     85  CE1 TYR A  23      22.068  29.887 184.065  1.00 11.51           C  
ATOM     86  CE2 TYR A  23      19.943  30.924 183.568  1.00 10.08           C  
ATOM     87  CZ  TYR A  23      20.753  30.207 184.427  1.00 10.44           C  
ATOM     88  OH  TYR A  23      20.247  29.850 185.652  1.00 12.38           O  
ATOM     89  N   ILE A  24      19.696  30.471 179.108  1.00 11.44           N  
ATOM     90  CA  ILE A  24      18.304  30.013 179.133  1.00 10.91           C  
ATOM     91  C   ILE A  24      18.170  28.761 178.289  1.00 10.44           C  
ATOM     92  O   ILE A  24      17.551  27.786 178.722  1.00 11.49           O  
ATOM     93  CB  ILE A  24      17.349  31.092 178.585  1.00 12.27           C  
ATOM     94  CG1 ILE A  24      17.397  32.344 179.453  1.00 13.10           C  
ATOM     95  CG2 ILE A  24      15.911  30.537 178.508  1.00 14.01           C  
ATOM     96  CD1 ILE A  24      16.749  33.541 178.800  1.00 14.04           C  
ATOM     97  N   LEU A  25      18.745  28.764 177.087  1.00 10.41           N  
ATOM     98  CA  LEU A  25      18.598  27.603 176.204  1.00 11.33           C  
ATOM     99  C   LEU A  25      19.218  26.360 176.823  1.00 11.19           C  
ATOM    100  O   LEU A  25      18.610  25.285 176.844  1.00 10.80           O  
ATOM    101  CB  LEU A  25      19.203  27.874 174.832  1.00 12.01           C  
ATOM    102  CG  LEU A  25      18.496  28.905 173.936  1.00 12.42           C  
ATOM    103  CD1 LEU A  25      19.399  29.243 172.775  1.00 14.40           C  
ATOM    104  CD2 LEU A  25      17.169  28.370 173.422  1.00 13.64           C  
ATOM    105  N   ARG A  26      20.451  26.482 177.302  1.00 10.44           N  
ATOM    106  CA  ARG A  26      21.122  25.315 177.849  1.00 11.52           C  
ATOM    107  C   ARG A  26      20.559  24.850 179.184  1.00 10.78           C  
ATOM    108  O   ARG A  26      20.590  23.662 179.494  1.00 12.12           O  
ATOM    109  CB  ARG A  26      22.625  25.570 177.977  1.00 12.30           C  
ATOM    110  CG  ARG A  26      23.331  25.524 176.627  1.00 14.03           C  
ATOM    111  CD  ARG A  26      24.803  25.979 176.678  1.00 15.78           C  
ATOM    112  NE  ARG A  26      25.674  25.095 177.456  1.00 18.14           N  
ATOM    113  CZ  ARG A  26      26.716  24.418 176.966  1.00 21.01           C  
ATOM    114  NH1 ARG A  26      27.028  24.486 175.673  1.00 22.48           N  
ATOM    115  NH2 ARG A  26      27.468  23.681 177.774  1.00 20.96           N  
ATOM    116  N   THR A  27      20.096  25.782 179.996  1.00 11.34           N  
ATOM    117  CA  THR A  27      19.577  25.426 181.310  1.00 11.87           C  
ATOM    118  C   THR A  27      18.156  24.862 181.230  1.00 12.07           C  
ATOM    119  O   THR A  27      17.862  23.866 181.865  1.00 11.28           O  
ATOM    120  CB  THR A  27      19.586  26.616 182.289  1.00 12.97           C  
ATOM    121  OG1 THR A  27      20.946  27.051 182.505  1.00 13.28           O  
ATOM    122  CG2 THR A  27      18.957  26.217 183.627  1.00 15.05           C  
ATOM    123  N   SER A  28      17.286  25.499 180.443  1.00 11.51           N  
ATOM    124  CA  SER A  28      15.845  25.226 180.554  1.00 11.48           C  
ATOM    125  C   SER A  28      15.161  24.714 179.284  1.00 12.08           C  
ATOM    126  O   SER A  28      14.054  24.164 179.356  1.00 14.06           O  
ATOM    127  CB  SER A  28      15.119  26.489 181.025  1.00 11.44           C  
ATOM    128  OG  SER A  28      15.629  26.933 182.289  1.00 13.53           O  
ATOM    129  N   VAL A  29      15.780  24.930 178.124  1.00 12.22           N  
ATOM    130  CA  VAL A  29      15.129  24.575 176.857  1.00 12.34           C  
ATOM    131  C   VAL A  29      15.668  23.283 176.266  1.00 11.63           C  
ATOM    132  O   VAL A  29      14.927  22.304 176.103  1.00 12.60           O  
ATOM    133  CB  VAL A  29      15.214  25.715 175.807  1.00 12.08           C  
ATOM    134  CG1 VAL A  29      14.474  25.303 174.520  1.00 12.98           C  
ATOM    135  CG2 VAL A  29      14.632  27.018 176.358  1.00 13.09           C  
ATOM    136  N   TYR A  30      16.958  23.262 175.948  1.00 11.93           N  
ATOM    137  CA  TYR A  30      17.534  22.109 175.268  1.00 12.45           C  
ATOM    138  C   TYR A  30      17.370  20.783 176.030  1.00 12.85           C  
ATOM    139  O   TYR A  30      17.101  19.757 175.406  1.00 13.28           O  
ATOM    140  CB  TYR A  30      18.999  22.354 174.970  1.00 12.84           C  
ATOM    141  CG  TYR A  30      19.299  23.399 173.926  1.00 12.63           C  
ATOM    142  CD1 TYR A  30      20.550  24.038 173.921  1.00 13.06           C  
ATOM    143  CD2 TYR A  30      18.388  23.755 172.938  1.00 13.16           C  
ATOM    144  CE1 TYR A  30      20.877  24.970 172.970  1.00 13.54           C  
ATOM    145  CE2 TYR A  30      18.723  24.717 171.965  1.00 14.02           C  
ATOM    146  CZ  TYR A  30      19.975  25.311 171.994  1.00 14.53           C  
ATOM    147  OH  TYR A  30      20.328  26.252 171.050  1.00 17.22           O  
ATOM    148  N   PRO A  31      17.512  20.787 177.369  1.00 13.34           N  
ATOM    149  CA  PRO A  31      17.352  19.481 178.041  1.00 13.84           C  
ATOM    150  C   PRO A  31      15.930  18.874 177.945  1.00 14.86           C  
ATOM    151  O   PRO A  31      15.755  17.676 178.160  1.00 17.30           O  
ATOM    152  CB  PRO A  31      17.669  19.801 179.509  1.00 13.72           C  
ATOM    153  CG  PRO A  31      18.600  20.978 179.426  1.00 13.70           C  
ATOM    154  CD  PRO A  31      18.006  21.812 178.305  1.00 14.03           C  
ATOM    155  N   ARG A  32      14.943  19.719 177.673  1.00 14.38           N  
ATOM    156  CA  ARG A  32      13.534  19.314 177.625  1.00 14.49           C  
ATOM    157  C   ARG A  32      13.009  19.232 176.194  1.00 15.71           C  
ATOM    158  O   ARG A  32      11.867  18.785 175.965  1.00 17.22           O  
ATOM    159  CB  ARG A  32      12.706  20.304 178.437  1.00 14.52           C  
ATOM    160  CG  ARG A  32      12.753  19.995 179.934  1.00 15.37           C  
ATOM    161  CD  ARG A  32      12.199  21.114 180.765  1.00 15.87           C  
ATOM    162  NE  ARG A  32      12.185  20.808 182.196  1.00 15.48           N  
ATOM    163  CZ  ARG A  32      11.162  20.251 182.835  1.00 14.30           C  
ATOM    164  NH1 ARG A  32      10.064  19.917 182.170  1.00 15.21           N  
ATOM    165  NH2 ARG A  32      11.237  20.044 184.141  1.00 13.98           N  
ATOM    166  N   GLU A  33      13.834  19.644 175.232  1.00 13.76           N  
ATOM    167  CA  GLU A  33      13.456  19.607 173.816  1.00 14.01           C  
ATOM    168  C   GLU A  33      13.511  18.175 173.252  1.00 14.58           C  
ATOM    169  O   GLU A  33      14.495  17.452 173.448  1.00 16.47           O  
ATOM    170  CB  GLU A  33      14.387  20.521 173.012  1.00 13.82           C  
ATOM    171  CG  GLU A  33      14.078  20.602 171.530  1.00 13.32           C  
ATOM    172  CD  GLU A  33      15.184  21.326 170.780  1.00 13.48           C  
ATOM    173  OE1 GLU A  33      16.352  21.222 171.204  1.00 15.46           O  
ATOM    174  OE2 GLU A  33      14.899  21.991 169.771  1.00 13.79           O  
ATOM    175  N   ALA A  34      12.491  17.790 172.491  1.00 14.82           N  
ATOM    176  CA  ALA A  34      12.434  16.460 171.904  1.00 15.05           C  
ATOM    177  C   ALA A  34      13.601  16.178 170.982  1.00 15.13           C  
ATOM    178  O   ALA A  34      13.982  17.021 170.179  1.00 15.40           O  
ATOM    179  CB  ALA A  34      11.135  16.271 171.148  1.00 14.38           C  
ATOM    180  N   GLY A  35      14.143  14.967 171.088  1.00 16.40           N  
ATOM    181  CA  GLY A  35      15.215  14.514 170.208  1.00 16.62           C  
ATOM    182  C   GLY A  35      14.942  14.768 168.735  1.00 16.60           C  
ATOM    183  O   GLY A  35      15.808  15.278 168.020  1.00 16.97           O  
ATOM    184  N   PHE A  36      13.732  14.446 168.280  1.00 17.13           N  
ATOM    185  CA  PHE A  36      13.402  14.655 166.863  1.00 17.58           C  
ATOM    186  C   PHE A  36      13.367  16.126 166.451  1.00 16.45           C  
ATOM    187  O   PHE A  36      13.631  16.451 165.289  1.00 16.96           O  
ATOM    188  CB  PHE A  36      12.109  13.936 166.472  1.00 18.70           C  
ATOM    189  CG  PHE A  36      12.192  12.441 166.593  1.00 20.09           C  
ATOM    190  CD1 PHE A  36      11.229  11.740 167.289  1.00 20.96           C  
ATOM    191  CD2 PHE A  36      13.243  11.747 166.018  1.00 20.57           C  
ATOM    192  CE1 PHE A  36      11.307  10.353 167.407  1.00 20.83           C  
ATOM    193  CE2 PHE A  36      13.333  10.363 166.134  1.00 21.15           C  
ATOM    194  CZ  PHE A  36      12.353   9.671 166.830  1.00 20.84           C  
ATOM    195  N   LEU A  37      13.056  17.015 167.393  1.00 16.18           N  
ATOM    196  CA  LEU A  37      13.168  18.459 167.128  1.00 15.58           C  
ATOM    197  C   LEU A  37      14.622  18.893 166.922  1.00 16.07           C  
ATOM    198  O   LEU A  37      14.910  19.664 166.016  1.00 15.39           O  
ATOM    199  CB  LEU A  37      12.494  19.280 168.228  1.00 15.20           C  
ATOM    200  CG  LEU A  37      10.959  19.345 168.182  1.00 15.77           C  
ATOM    201  CD1 LEU A  37      10.454  20.018 169.451  1.00 16.18           C  
ATOM    202  CD2 LEU A  37      10.479  20.101 166.949  1.00 15.03           C  
ATOM    203  N   LYS A  38      15.528  18.382 167.758  1.00 16.50           N  
ATOM    204  CA  LYS A  38      16.957  18.646 167.588  1.00 18.34           C  
ATOM    205  C   LYS A  38      17.439  18.173 166.225  1.00 18.22           C  
ATOM    206  O   LYS A  38      18.208  18.872 165.550  1.00 18.45           O  
ATOM    207  CB  LYS A  38      17.774  17.947 168.675  1.00 19.34           C  
ATOM    208  CG  LYS A  38      17.315  18.243 170.078  1.00 19.89           C  
ATOM    209  CD  LYS A  38      18.228  17.592 171.116  1.00 20.19           C  
ATOM    210  CE  LYS A  38      17.783  17.957 172.534  1.00 20.85           C  
ATOM    211  NZ  LYS A  38      17.859  19.439 172.740  1.00 18.68           N  
ATOM    212  N   GLU A  39      16.996  16.972 165.839  1.00 18.18           N  
ATOM    213  CA  GLU A  39      17.364  16.382 164.554  1.00 18.78           C  
ATOM    214  C   GLU A  39      16.925  17.302 163.421  1.00 18.23           C  
ATOM    215  O   GLU A  39      17.686  17.594 162.492  1.00 18.72           O  
ATOM    216  CB  GLU A  39      16.708  15.011 164.377  1.00 19.95           C  
ATOM    217  CG  GLU A  39      17.213  13.931 165.320  1.00 22.53           C  
ATOM    218  CD  GLU A  39      16.887  12.540 164.817  1.00 23.96           C  
ATOM    219  OE1 GLU A  39      17.248  12.222 163.658  1.00 24.53           O  
ATOM    220  OE2 GLU A  39      16.267  11.767 165.577  1.00 26.11           O  
ATOM    221  N   LEU A  40      15.690  17.787 163.513  1.00 18.06           N  
ATOM    222  CA  LEU A  40      15.150  18.648 162.469  1.00 17.31           C  
ATOM    223  C   LEU A  40      15.925  19.966 162.409  1.00 17.38           C  
ATOM    224  O   LEU A  40      16.262  20.439 161.326  1.00 17.10           O  
ATOM    225  CB  LEU A  40      13.651  18.878 162.694  1.00 16.21           C  
ATOM    226  CG  LEU A  40      12.903  19.656 161.615  1.00 15.12           C  
ATOM    227  CD1 LEU A  40      11.432  19.236 161.605  1.00 14.75           C  
ATOM    228  CD2 LEU A  40      13.012  21.150 161.822  1.00 15.82           C  
ATOM    229  N   ARG A  41      16.225  20.530 163.581  1.00 18.01           N  
ATOM    230  CA  ARG A  41      17.014  21.749 163.707  1.00 20.94           C  
ATOM    231  C   ARG A  41      18.366  21.599 163.009  1.00 21.92           C  
ATOM    232  O   ARG A  41      18.815  22.513 162.314  1.00 22.80           O  
ATOM    233  CB  ARG A  41      17.192  22.073 165.202  1.00 21.87           C  
ATOM    234  CG  ARG A  41      17.444  23.514 165.556  1.00 22.39           C  
ATOM    235  CD  ARG A  41      16.731  23.908 166.866  1.00 19.73           C  
ATOM    236  NE  ARG A  41      17.048  23.072 168.033  1.00 17.41           N  
ATOM    237  CZ  ARG A  41      18.263  22.920 168.543  1.00 17.79           C  
ATOM    238  NH1 ARG A  41      19.290  23.528 167.969  1.00 17.95           N  
ATOM    239  NH2 ARG A  41      18.455  22.161 169.611  1.00 16.64           N  
ATOM    240  N   GLU A  42      19.013  20.449 163.176  1.00 22.43           N  
ATOM    241  CA  GLU A  42      20.306  20.214 162.527  1.00 24.14           C  
ATOM    242  C   GLU A  42      20.181  20.144 161.006  1.00 23.30           C  
ATOM    243  O   GLU A  42      20.995  20.705 160.265  1.00 23.26           O  
ATOM    244  CB  GLU A  42      20.954  18.935 163.056  1.00 25.97           C  
ATOM    245  CG  GLU A  42      22.359  18.684 162.508  1.00 28.49           C  
ATOM    246  CD  GLU A  42      23.015  17.466 163.129  1.00 30.03           C  
ATOM    247  OE1 GLU A  42      22.664  16.334 162.729  1.00 31.37           O  
ATOM    248  OE2 GLU A  42      23.881  17.644 164.018  1.00 30.90           O  
ATOM    249  N   ALA A  43      19.152  19.457 160.533  1.00 22.45           N  
ATOM    250  CA  ALA A  43      18.912  19.374 159.102  1.00 21.33           C  
ATOM    251  C   ALA A  43      18.658  20.764 158.534  1.00 21.20           C  
ATOM    252  O   ALA A  43      19.123  21.105 157.450  1.00 21.25           O  
ATOM    253  CB  ALA A  43      17.741  18.470 158.824  1.00 20.92           C  
ATOM    254  N   ASN A  44      17.897  21.558 159.280  1.00 20.15           N  
ATOM    255  CA  ASN A  44      17.558  22.918 158.885  1.00 20.42           C  
ATOM    256  C   ASN A  44      18.797  23.797 158.611  1.00 22.20           C  
ATOM    257  O   ASN A  44      18.766  24.696 157.760  1.00 21.32           O  
ATOM    258  CB  ASN A  44      16.649  23.539 159.963  1.00 18.35           C  
ATOM    259  CG  ASN A  44      16.393  25.008 159.734  1.00 17.04           C  
ATOM    260  OD1 ASN A  44      16.958  25.870 160.420  1.00 17.68           O  
ATOM    261  ND2 ASN A  44      15.553  25.312 158.758  1.00 13.51           N  
ATOM    262  N   GLU A  45      19.880  23.524 159.331  1.00 24.25           N  
ATOM    263  CA  GLU A  45      21.128  24.293 159.203  1.00 26.86           C  
ATOM    264  C   GLU A  45      21.638  24.375 157.763  1.00 27.21           C  
ATOM    265  O   GLU A  45      22.324  25.329 157.398  1.00 28.26           O  
ATOM    266  CB  GLU A  45      22.221  23.700 160.104  1.00 28.56           C  
ATOM    267  CG  GLU A  45      21.981  23.878 161.599  1.00 30.98           C  
ATOM    268  CD  GLU A  45      22.828  22.941 162.462  1.00 32.65           C  
ATOM    269  OE1 GLU A  45      22.935  23.193 163.682  1.00 33.86           O  
ATOM    270  OE2 GLU A  45      23.379  21.949 161.931  1.00 33.94           O  
ATOM    271  N   SER A  46      21.298  23.381 156.949  1.00 27.54           N  
ATOM    272  CA  SER A  46      21.782  23.319 155.569  1.00 27.81           C  
ATOM    273  C   SER A  46      20.984  24.181 154.594  1.00 27.28           C  
ATOM    274  O   SER A  46      21.428  24.436 153.475  1.00 27.53           O  
ATOM    275  CB  SER A  46      21.818  21.868 155.082  1.00 28.27           C  
ATOM    276  OG  SER A  46      22.867  21.154 155.712  1.00 29.75           O  
ATOM    277  N   HIS A  47      19.803  24.627 155.007  1.00 25.92           N  
ATOM    278  CA  HIS A  47      18.996  25.489 154.160  1.00 24.41           C  
ATOM    279  C   HIS A  47      19.564  26.905 154.181  1.00 24.04           C  
ATOM    280  O   HIS A  47      19.948  27.399 155.232  1.00 23.28           O  
ATOM    281  CB  HIS A  47      17.531  25.496 154.621  1.00 23.61           C  
ATOM    282  CG  HIS A  47      16.592  26.065 153.606  1.00 22.73           C  
ATOM    283  ND1 HIS A  47      16.526  27.413 153.326  1.00 22.57           N  
ATOM    284  CD2 HIS A  47      15.697  25.464 152.790  1.00 22.69           C  
ATOM    285  CE1 HIS A  47      15.614  27.618 152.389  1.00 22.18           C  
ATOM    286  NE2 HIS A  47      15.103  26.451 152.044  1.00 22.49           N  
ATOM    287  N   PRO A  48      19.640  27.561 153.011  1.00 24.40           N  
ATOM    288  CA  PRO A  48      20.207  28.909 152.980  1.00 24.78           C  
ATOM    289  C   PRO A  48      19.479  29.905 153.893  1.00 24.78           C  
ATOM    290  O   PRO A  48      20.087  30.867 154.379  1.00 25.34           O  
ATOM    291  CB  PRO A  48      20.055  29.332 151.509  1.00 25.51           C  
ATOM    292  CG  PRO A  48      19.170  28.284 150.862  1.00 25.85           C  
ATOM    293  CD  PRO A  48      19.339  27.044 151.665  1.00 24.75           C  
ATOM    294  N   ASP A  49      18.188  29.677 154.114  1.00 23.85           N  
ATOM    295  CA  ASP A  49      17.385  30.575 154.933  1.00 23.98           C  
ATOM    296  C   ASP A  49      17.064  29.952 156.304  1.00 22.39           C  
ATOM    297  O   ASP A  49      16.053  30.285 156.928  1.00 22.11           O  
ATOM    298  CB  ASP A  49      16.101  30.967 154.191  1.00 25.13           C  
ATOM    299  CG  ASP A  49      16.375  31.637 152.853  1.00 26.77           C  
ATOM    300  OD1 ASP A  49      17.166  32.599 152.811  1.00 27.91           O  
ATOM    301  OD2 ASP A  49      15.795  31.205 151.841  1.00 28.33           O  
ATOM    302  N   SER A  50      17.966  29.095 156.775  1.00 21.17           N  
ATOM    303  CA  SER A  50      17.827  28.381 158.053  1.00 20.48           C  
ATOM    304  C   SER A  50      17.383  29.255 159.214  1.00 20.04           C  
ATOM    305  O   SER A  50      16.732  28.758 160.140  1.00 18.93           O  
ATOM    306  CB  SER A  50      19.152  27.716 158.439  1.00 20.66           C  
ATOM    307  OG  SER A  50      20.156  28.701 158.632  1.00 21.41           O  
ATOM    308  N   TYR A  51      17.751  30.537 159.181  1.00 20.42           N  
ATOM    309  CA  TYR A  51      17.388  31.470 160.245  1.00 21.10           C  
ATOM    310  C   TYR A  51      15.869  31.606 160.444  1.00 20.09           C  
ATOM    311  O   TYR A  51      15.417  32.109 161.472  1.00 18.90           O  
ATOM    312  CB  TYR A  51      18.022  32.844 159.994  1.00 23.54           C  
ATOM    313  CG  TYR A  51      17.422  33.580 158.815  1.00 25.43           C  
ATOM    314  CD1 TYR A  51      17.925  33.416 157.527  1.00 26.67           C  
ATOM    315  CD2 TYR A  51      16.342  34.435 158.991  1.00 26.68           C  
ATOM    316  CE1 TYR A  51      17.358  34.088 156.448  1.00 27.69           C  
ATOM    317  CE2 TYR A  51      15.774  35.102 157.931  1.00 27.99           C  
ATOM    318  CZ  TYR A  51      16.281  34.933 156.664  1.00 28.29           C  
ATOM    319  OH  TYR A  51      15.698  35.617 155.616  1.00 29.87           O  
ATOM    320  N   MET A  52      15.084  31.158 159.468  1.00 18.42           N  
ATOM    321  CA  MET A  52      13.636  31.284 159.557  1.00 17.56           C  
ATOM    322  C   MET A  52      13.031  30.237 160.479  1.00 15.95           C  
ATOM    323  O   MET A  52      11.854  30.321 160.784  1.00 15.89           O  
ATOM    324  CB  MET A  52      12.975  31.181 158.184  1.00 19.16           C  
ATOM    325  CG  MET A  52      13.375  32.300 157.226  1.00 21.84           C  
ATOM    326  SD  MET A  52      12.202  32.480 155.862  1.00 25.09           S  
ATOM    327  CE  MET A  52      12.250  30.854 155.138  1.00 25.75           C  
ATOM    328  N   SER A  53      13.805  29.231 160.880  1.00 14.23           N  
ATOM    329  CA  SER A  53      13.270  28.172 161.743  1.00 13.05           C  
ATOM    330  C   SER A  53      12.890  28.734 163.114  1.00 12.16           C  
ATOM    331  O   SER A  53      13.575  29.597 163.659  1.00 13.45           O  
ATOM    332  CB  SER A  53      14.270  27.006 161.851  1.00 13.14           C  
ATOM    333  OG  SER A  53      13.746  25.913 162.593  1.00 13.77           O  
ATOM    334  N   THR A  54      11.760  28.274 163.649  1.00 10.63           N  
ATOM    335  CA  THR A  54      11.209  28.858 164.875  1.00 10.55           C  
ATOM    336  C   THR A  54      12.149  28.722 166.092  1.00 11.53           C  
ATOM    337  O   THR A  54      12.730  27.664 166.345  1.00 12.47           O  
ATOM    338  CB  THR A  54       9.789  28.287 165.182  1.00 11.29           C  
ATOM    339  OG1 THR A  54       8.870  28.676 164.144  1.00 11.02           O  
ATOM    340  CG2 THR A  54       9.271  28.793 166.516  1.00 10.98           C  
ATOM    341  N   SER A  55      12.302  29.812 166.836  1.00 11.09           N  
ATOM    342  CA  SER A  55      13.067  29.809 168.091  1.00 10.96           C  
ATOM    343  C   SER A  55      12.624  28.653 169.012  1.00 11.10           C  
ATOM    344  O   SER A  55      11.445  28.524 169.313  1.00 11.25           O  
ATOM    345  CB  SER A  55      12.797  31.142 168.794  1.00 12.91           C  
ATOM    346  OG  SER A  55      12.948  31.087 170.194  1.00 14.47           O  
ATOM    347  N   PRO A  56      13.566  27.829 169.489  1.00 10.78           N  
ATOM    348  CA  PRO A  56      13.213  26.771 170.447  1.00 11.27           C  
ATOM    349  C   PRO A  56      12.581  27.303 171.727  1.00 11.79           C  
ATOM    350  O   PRO A  56      11.734  26.637 172.315  1.00 12.30           O  
ATOM    351  CB  PRO A  56      14.558  26.085 170.698  1.00 11.31           C  
ATOM    352  CG  PRO A  56      15.198  26.162 169.362  1.00 13.09           C  
ATOM    353  CD  PRO A  56      14.915  27.603 168.932  1.00 12.35           C  
ATOM    354  N   LEU A  57      12.951  28.500 172.151  1.00 11.61           N  
ATOM    355  CA  LEU A  57      12.318  29.068 173.332  1.00 11.80           C  
ATOM    356  C   LEU A  57      10.856  29.447 173.058  1.00 11.84           C  
ATOM    357  O   LEU A  57       9.964  29.082 173.837  1.00 11.49           O  
ATOM    358  CB  LEU A  57      13.108  30.278 173.833  1.00 12.42           C  
ATOM    359  CG  LEU A  57      12.512  31.016 175.041  1.00 13.48           C  
ATOM    360  CD1 LEU A  57      12.369  30.049 176.220  1.00 15.27           C  
ATOM    361  CD2 LEU A  57      13.361  32.253 175.416  1.00 15.05           C  
ATOM    362  N   ALA A  58      10.596  30.150 171.954  1.00 11.07           N  
ATOM    363  CA  ALA A  58       9.200  30.423 171.579  1.00 11.42           C  
ATOM    364  C   ALA A  58       8.442  29.108 171.449  1.00 11.08           C  
ATOM    365  O   ALA A  58       7.282  29.005 171.867  1.00 11.56           O  
ATOM    366  CB  ALA A  58       9.156  31.208 170.257  1.00 12.87           C  
ATOM    367  N   GLY A  59       9.092  28.098 170.867  1.00 11.48           N  
ATOM    368  CA  GLY A  59       8.499  26.771 170.738  1.00 11.71           C  
ATOM    369  C   GLY A  59       8.106  26.155 172.079  1.00 12.35           C  
ATOM    370  O   GLY A  59       7.043  25.516 172.208  1.00 12.86           O  
ATOM    371  N   GLN A  60       8.960  26.313 173.078  1.00 11.73           N  
ATOM    372  CA  GLN A  60       8.691  25.762 174.395  1.00 12.57           C  
ATOM    373  C   GLN A  60       7.450  26.413 175.000  1.00 11.19           C  
ATOM    374  O   GLN A  60       6.649  25.740 175.643  1.00 11.85           O  
ATOM    375  CB  GLN A  60       9.887  25.939 175.319  1.00 14.53           C  
ATOM    376  CG  GLN A  60       9.702  25.238 176.653  1.00 16.03           C  
ATOM    377  CD  GLN A  60      10.804  25.572 177.634  1.00 18.35           C  
ATOM    378  OE1 GLN A  60      11.085  26.751 177.906  1.00 21.23           O  
ATOM    379  NE2 GLN A  60      11.424  24.543 178.188  1.00 17.51           N  
ATOM    380  N   LEU A  61       7.275  27.710 174.797  1.00 10.56           N  
ATOM    381  CA  LEU A  61       6.029  28.347 175.230  1.00 10.60           C  
ATOM    382  C   LEU A  61       4.852  27.896 174.392  1.00 10.60           C  
ATOM    383  O   LEU A  61       3.763  27.661 174.938  1.00 10.24           O  
ATOM    384  CB  LEU A  61       6.133  29.872 175.186  1.00 11.73           C  
ATOM    385  CG  LEU A  61       4.862  30.621 175.622  1.00 11.50           C  
ATOM    386  CD1 LEU A  61       4.432  30.210 177.028  1.00 13.19           C  
ATOM    387  CD2 LEU A  61       5.113  32.119 175.565  1.00 12.96           C  
ATOM    388  N   MET A  62       5.030  27.749 173.079  1.00  9.61           N  
ATOM    389  CA  MET A  62       3.934  27.225 172.268  1.00 10.26           C  
ATOM    390  C   MET A  62       3.449  25.873 172.788  1.00 10.70           C  
ATOM    391  O   MET A  62       2.247  25.632 172.899  1.00 11.89           O  
ATOM    392  CB  MET A  62       4.358  27.085 170.810  1.00 11.42           C  
ATOM    393  CG  MET A  62       4.674  28.402 170.123  1.00 14.04           C  
ATOM    394  SD  MET A  62       5.234  28.169 168.424  1.00 15.51           S  
ATOM    395  CE  MET A  62       3.816  27.234 167.829  1.00 15.65           C  
ATOM    396  N   SER A  63       4.378  24.979 173.086  1.00 10.95           N  
ATOM    397  CA  SER A  63       4.027  23.650 173.591  1.00 12.51           C  
ATOM    398  C   SER A  63       3.282  23.754 174.911  1.00 11.98           C  
ATOM    399  O   SER A  63       2.288  23.074 175.119  1.00 13.08           O  
ATOM    400  CB  SER A  63       5.302  22.829 173.784  1.00 14.02           C  
ATOM    401  OG  SER A  63       4.966  21.522 174.213  1.00 18.60           O  
ATOM    402  N   PHE A  64       3.762  24.595 175.804  1.00 11.38           N  
ATOM    403  CA  PHE A  64       3.153  24.837 177.103  1.00 12.17           C  
ATOM    404  C   PHE A  64       1.699  25.285 176.931  1.00 12.74           C  
ATOM    405  O   PHE A  64       0.798  24.739 177.568  1.00 14.08           O  
ATOM    406  CB  PHE A  64       3.977  25.907 177.852  1.00 12.15           C  
ATOM    407  CG  PHE A  64       3.656  26.024 179.330  1.00 11.29           C  
ATOM    408  CD1 PHE A  64       4.315  25.221 180.255  1.00 11.99           C  
ATOM    409  CD2 PHE A  64       2.737  26.956 179.800  1.00 12.32           C  
ATOM    410  CE1 PHE A  64       4.040  25.328 181.614  1.00 12.21           C  
ATOM    411  CE2 PHE A  64       2.476  27.077 181.160  1.00 12.01           C  
ATOM    412  CZ  PHE A  64       3.107  26.251 182.059  1.00 12.39           C  
ATOM    413  N   VAL A  65       1.466  26.274 176.069  1.00 13.23           N  
ATOM    414  CA  VAL A  65       0.118  26.800 175.831  1.00 14.03           C  
ATOM    415  C   VAL A  65      -0.783  25.742 175.179  1.00 14.26           C  
ATOM    416  O   VAL A  65      -1.937  25.539 175.613  1.00 15.60           O  
ATOM    417  CB  VAL A  65       0.170  28.074 174.969  1.00 13.88           C  
ATOM    418  CG1 VAL A  65      -1.237  28.490 174.529  1.00 14.37           C  
ATOM    419  CG2 VAL A  65       0.865  29.197 175.742  1.00 14.64           C  
ATOM    420  N   LEU A  66      -0.261  25.054 174.170  1.00 14.11           N  
ATOM    421  CA  LEU A  66      -1.022  23.984 173.507  1.00 15.30           C  
ATOM    422  C   LEU A  66      -1.508  22.938 174.506  1.00 17.28           C  
ATOM    423  O   LEU A  66      -2.683  22.549 174.488  1.00 18.30           O  
ATOM    424  CB  LEU A  66      -0.175  23.305 172.430  1.00 14.47           C  
ATOM    425  CG  LEU A  66       0.036  24.080 171.129  1.00 13.73           C  
ATOM    426  CD1 LEU A  66       1.192  23.510 170.354  1.00 14.22           C  
ATOM    427  CD2 LEU A  66      -1.237  23.988 170.295  1.00 13.55           C  
ATOM    428  N   LYS A  67      -0.611  22.471 175.365  1.00 18.34           N  
ATOM    429  CA  LYS A  67      -0.976  21.473 176.377  1.00 20.93           C  
ATOM    430  C   LYS A  67      -1.947  22.038 177.408  1.00 21.63           C  
ATOM    431  O   LYS A  67      -2.874  21.343 177.843  1.00 22.62           O  
ATOM    432  CB  LYS A  67       0.275  20.911 177.043  1.00 22.76           C  
ATOM    433  CG  LYS A  67       1.034  19.919 176.174  1.00 25.11           C  
ATOM    434  CD  LYS A  67       2.438  19.696 176.708  1.00 27.14           C  
ATOM    435  CE  LYS A  67       3.207  18.715 175.848  1.00 28.85           C  
ATOM    436  NZ  LYS A  67       4.671  18.872 176.062  1.00 30.55           N  
ATOM    437  N   LEU A  68      -1.755  23.300 177.785  1.00 22.66           N  
ATOM    438  CA  LEU A  68      -2.601  23.955 178.773  1.00 24.53           C  
ATOM    439  C   LEU A  68      -4.064  24.008 178.355  1.00 24.66           C  
ATOM    440  O   LEU A  68      -4.970  23.896 179.198  1.00 26.04           O  
ATOM    441  CB  LEU A  68      -2.110  25.376 179.046  1.00 24.63           C  
ATOM    442  CG  LEU A  68      -1.524  25.619 180.427  1.00 24.65           C  
ATOM    443  CD1 LEU A  68      -1.541  27.118 180.711  1.00 24.35           C  
ATOM    444  CD2 LEU A  68      -2.312  24.850 181.476  1.00 24.61           C  
ATOM    445  N   VAL A  69      -4.294  24.186 177.059  1.00 24.52           N  
ATOM    446  CA  VAL A  69      -5.648  24.351 176.546  1.00 23.43           C  
ATOM    447  C   VAL A  69      -6.200  23.077 175.901  1.00 22.80           C  
ATOM    448  O   VAL A  69      -7.309  23.075 175.357  1.00 23.28           O  
ATOM    449  CB  VAL A  69      -5.733  25.535 175.569  1.00 23.48           C  
ATOM    450  CG1 VAL A  69      -5.214  26.790 176.251  1.00 24.38           C  
ATOM    451  CG2 VAL A  69      -4.939  25.245 174.295  1.00 22.40           C  
ATOM    452  N   ASN A  70      -5.427  22.000 175.981  1.00 21.88           N  
ATOM    453  CA  ASN A  70      -5.792  20.721 175.366  1.00 21.82           C  
ATOM    454  C   ASN A  70      -6.173  20.889 173.905  1.00 20.20           C  
ATOM    455  O   ASN A  70      -7.181  20.348 173.442  1.00 20.24           O  
ATOM    456  CB  ASN A  70      -6.929  20.034 176.133  1.00 24.08           C  
ATOM    457  CG  ASN A  70      -6.936  18.530 175.930  1.00 26.24           C  
ATOM    458  OD1 ASN A  70      -5.972  17.953 175.418  1.00 27.68           O  
ATOM    459  ND2 ASN A  70      -8.019  17.880 176.345  1.00 27.60           N  
ATOM    460  N   ALA A  71      -5.364  21.655 173.174  1.00 17.54           N  
ATOM    461  CA  ALA A  71      -5.608  21.869 171.757  1.00 16.70           C  
ATOM    462  C   ALA A  71      -5.571  20.544 171.023  1.00 16.68           C  
ATOM    463  O   ALA A  71      -4.715  19.704 171.299  1.00 16.94           O  
ATOM    464  CB  ALA A  71      -4.561  22.807 171.171  1.00 15.67           C  
ATOM    465  N   LYS A  72      -6.500  20.370 170.084  1.00 15.66           N  
ATOM    466  CA  LYS A  72      -6.562  19.155 169.280  1.00 18.60           C  
ATOM    467  C   LYS A  72      -6.536  19.469 167.789  1.00 17.51           C  
ATOM    468  O   LYS A  72      -5.859  18.776 167.020  1.00 19.78           O  
ATOM    469  CB  LYS A  72      -7.807  18.335 169.628  1.00 20.60           C  
ATOM    470  CG  LYS A  72      -7.949  17.992 171.103  1.00 23.78           C  
ATOM    471  CD  LYS A  72      -9.132  17.047 171.332  1.00 25.66           C  
ATOM    472  CE  LYS A  72      -8.763  15.591 171.048  1.00 27.37           C  
ATOM    473  NZ  LYS A  72      -9.934  14.661 171.280  1.00 28.72           N  
ATOM    474  N   LYS A  73      -7.264  20.508 167.381  1.00 16.33           N  
ATOM    475  CA  LYS A  73      -7.348  20.878 165.974  1.00 15.27           C  
ATOM    476  C   LYS A  73      -6.627  22.201 165.781  1.00 13.78           C  
ATOM    477  O   LYS A  73      -7.003  23.226 166.361  1.00 13.29           O  
ATOM    478  CB  LYS A  73      -8.801  20.980 165.485  1.00 16.65           C  
ATOM    479  CG  LYS A  73      -8.912  21.135 163.967  1.00 17.06           C  
ATOM    480  CD  LYS A  73     -10.378  21.208 163.496  1.00 19.22           C  
ATOM    481  CE  LYS A  73     -10.415  21.445 162.002  1.00 20.54           C  
ATOM    482  NZ  LYS A  73     -11.801  21.703 161.497  1.00 21.86           N  
ATOM    483  N   THR A  74      -5.567  22.183 164.986  1.00 12.61           N  
ATOM    484  CA  THR A  74      -4.776  23.395 164.843  1.00 11.90           C  
ATOM    485  C   THR A  74      -4.490  23.703 163.388  1.00 12.53           C  
ATOM    486  O   THR A  74      -4.668  22.863 162.492  1.00 11.40           O  
ATOM    487  CB  THR A  74      -3.408  23.339 165.628  1.00 11.91           C  
ATOM    488  OG1 THR A  74      -2.373  22.730 164.832  1.00 13.05           O  
ATOM    489  CG2 THR A  74      -3.555  22.630 166.970  1.00 12.58           C  
ATOM    490  N   ILE A  75      -4.034  24.927 163.174  1.00 11.27           N  
ATOM    491  CA  ILE A  75      -3.682  25.395 161.843  1.00 11.38           C  
ATOM    492  C   ILE A  75      -2.365  26.149 161.907  1.00 10.48           C  
ATOM    493  O   ILE A  75      -2.140  26.913 162.845  1.00 10.27           O  
ATOM    494  CB  ILE A  75      -4.817  26.241 161.205  1.00 11.38           C  
ATOM    495  CG1 ILE A  75      -4.476  26.652 159.778  1.00 13.20           C  
ATOM    496  CG2 ILE A  75      -5.229  27.417 162.089  1.00 11.87           C  
ATOM    497  CD1 ILE A  75      -5.710  27.108 159.004  1.00 13.43           C  
ATOM    498  N   GLU A  76      -1.505  25.893 160.934  1.00 10.24           N  
ATOM    499  CA  GLU A  76      -0.256  26.604 160.849  1.00 10.12           C  
ATOM    500  C   GLU A  76      -0.126  27.207 159.466  1.00 10.58           C  
ATOM    501  O   GLU A  76      -0.307  26.516 158.467  1.00 12.01           O  
ATOM    502  CB  GLU A  76       0.951  25.693 161.155  1.00 10.67           C  
ATOM    503  CG  GLU A  76       2.293  26.388 160.885  1.00 11.78           C  
ATOM    504  CD  GLU A  76       3.493  25.669 161.471  1.00 12.66           C  
ATOM    505  OE1 GLU A  76       3.616  25.608 162.713  1.00 12.99           O  
ATOM    506  OE2 GLU A  76       4.344  25.202 160.676  1.00 14.23           O  
ATOM    507  N   VAL A  77       0.190  28.507 159.414  1.00 10.08           N  
ATOM    508  CA  VAL A  77       0.365  29.216 158.152  1.00 11.12           C  
ATOM    509  C   VAL A  77       1.834  29.635 158.089  1.00 10.22           C  
ATOM    510  O   VAL A  77       2.250  30.526 158.819  1.00 12.39           O  
ATOM    511  CB  VAL A  77      -0.570  30.442 158.055  1.00 12.39           C  
ATOM    512  CG1 VAL A  77      -0.382  31.165 156.732  1.00 14.02           C  
ATOM    513  CG2 VAL A  77      -2.024  30.024 158.244  1.00 14.37           C  
ATOM    514  N   GLY A  78       2.636  28.953 157.266  1.00 10.92           N  
ATOM    515  CA  GLY A  78       4.088  29.201 157.269  1.00 10.69           C  
ATOM    516  C   GLY A  78       4.829  28.060 157.957  1.00 10.70           C  
ATOM    517  O   GLY A  78       5.024  28.076 159.181  1.00 11.81           O  
ATOM    518  N   VAL A  79       5.230  27.067 157.168  1.00 10.76           N  
ATOM    519  CA  VAL A  79       5.759  25.805 157.676  1.00 10.57           C  
ATOM    520  C   VAL A  79       7.279  25.739 157.535  1.00 10.48           C  
ATOM    521  O   VAL A  79       7.980  25.236 158.431  1.00  9.75           O  
ATOM    522  CB  VAL A  79       5.105  24.604 156.950  1.00 10.64           C  
ATOM    523  CG1 VAL A  79       5.775  23.287 157.348  1.00 11.94           C  
ATOM    524  CG2 VAL A  79       3.604  24.580 157.233  1.00 11.92           C  
ATOM    525  N   PHE A  80       7.785  26.211 156.396  1.00 10.73           N  
ATOM    526  CA  PHE A  80       9.211  26.138 156.109  1.00 11.58           C  
ATOM    527  C   PHE A  80       9.688  24.700 156.299  1.00 11.09           C  
ATOM    528  O   PHE A  80       9.049  23.765 155.812  1.00 12.47           O  
ATOM    529  CB  PHE A  80       9.966  27.140 156.995  1.00 11.12           C  
ATOM    530  CG  PHE A  80      11.406  27.349 156.600  1.00 11.91           C  
ATOM    531  CD1 PHE A  80      11.775  27.518 155.275  1.00 14.11           C  
ATOM    532  CD2 PHE A  80      12.385  27.363 157.574  1.00 12.79           C  
ATOM    533  CE1 PHE A  80      13.124  27.692 154.923  1.00 14.47           C  
ATOM    534  CE2 PHE A  80      13.736  27.555 157.231  1.00 13.98           C  
ATOM    535  CZ  PHE A  80      14.085  27.723 155.909  1.00 13.20           C  
ATOM    536  N   THR A  81      10.787  24.518 157.026  1.00 11.53           N  
ATOM    537  CA  THR A  81      11.368  23.177 157.197  1.00 11.54           C  
ATOM    538  C   THR A  81      10.779  22.393 158.370  1.00 11.69           C  
ATOM    539  O   THR A  81      11.215  21.274 158.642  1.00 13.02           O  
ATOM    540  CB  THR A  81      12.889  23.266 157.378  1.00 12.02           C  
ATOM    541  OG1 THR A  81      13.152  24.130 158.496  1.00 12.64           O  
ATOM    542  CG2 THR A  81      13.542  23.853 156.112  1.00 12.68           C  
ATOM    543  N   GLY A  82       9.800  22.975 159.067  1.00 11.59           N  
ATOM    544  CA  GLY A  82       8.921  22.199 159.925  1.00 11.10           C  
ATOM    545  C   GLY A  82       9.091  22.213 161.435  1.00 11.36           C  
ATOM    546  O   GLY A  82       8.408  21.464 162.109  1.00 12.02           O  
ATOM    547  N   TYR A  83       9.980  23.035 161.990  1.00 10.90           N  
ATOM    548  CA  TYR A  83      10.180  23.004 163.430  1.00 10.20           C  
ATOM    549  C   TYR A  83       8.899  23.251 164.230  1.00 10.25           C  
ATOM    550  O   TYR A  83       8.504  22.435 165.073  1.00  9.58           O  
ATOM    551  CB  TYR A  83      11.261  24.001 163.867  1.00 10.20           C  
ATOM    552  CG  TYR A  83      11.663  23.835 165.307  1.00  9.75           C  
ATOM    553  CD1 TYR A  83      10.969  24.480 166.325  1.00 11.21           C  
ATOM    554  CD2 TYR A  83      12.738  23.011 165.662  1.00 10.64           C  
ATOM    555  CE1 TYR A  83      11.327  24.329 167.652  1.00 10.73           C  
ATOM    556  CE2 TYR A  83      13.094  22.839 166.985  1.00 10.85           C  
ATOM    557  CZ  TYR A  83      12.388  23.513 167.986  1.00 10.83           C  
ATOM    558  OH  TYR A  83      12.715  23.381 169.322  1.00 11.23           O  
ATOM    559  N   SER A  84       8.230  24.374 163.983  1.00 10.48           N  
ATOM    560  CA  SER A  84       7.002  24.654 164.763  1.00 10.14           C  
ATOM    561  C   SER A  84       5.922  23.635 164.456  1.00 10.66           C  
ATOM    562  O   SER A  84       5.115  23.303 165.328  1.00 10.93           O  
ATOM    563  CB  SER A  84       6.486  26.099 164.555  1.00 10.42           C  
ATOM    564  OG  SER A  84       6.149  26.362 163.206  1.00 11.37           O  
ATOM    565  N   LEU A  85       5.910  23.121 163.233  1.00 10.21           N  
ATOM    566  CA  LEU A  85       4.885  22.127 162.885  1.00 10.30           C  
ATOM    567  C   LEU A  85       5.096  20.830 163.675  1.00 11.08           C  
ATOM    568  O   LEU A  85       4.173  20.274 164.257  1.00 11.65           O  
ATOM    569  CB  LEU A  85       4.908  21.857 161.373  1.00 10.58           C  
ATOM    570  CG  LEU A  85       3.940  20.769 160.876  1.00 10.46           C  
ATOM    571  CD1 LEU A  85       2.495  21.092 161.202  1.00 11.74           C  
ATOM    572  CD2 LEU A  85       4.124  20.580 159.386  1.00 12.48           C  
ATOM    573  N   LEU A  86       6.333  20.351 163.697  1.00 10.28           N  
ATOM    574  CA  LEU A  86       6.644  19.151 164.452  1.00 11.56           C  
ATOM    575  C   LEU A  86       6.448  19.364 165.949  1.00 12.23           C  
ATOM    576  O   LEU A  86       5.896  18.527 166.630  1.00 12.84           O  
ATOM    577  CB  LEU A  86       8.056  18.658 164.123  1.00 12.37           C  
ATOM    578  CG  LEU A  86       8.556  17.444 164.910  1.00 12.03           C  
ATOM    579  CD1 LEU A  86       7.611  16.226 164.813  1.00 12.71           C  
ATOM    580  CD2 LEU A  86       9.944  17.079 164.460  1.00 12.83           C  
ATOM    581  N   LEU A  87       6.878  20.503 166.467  1.00 11.31           N  
ATOM    582  CA  LEU A  87       6.635  20.812 167.879  1.00 11.85           C  
ATOM    583  C   LEU A  87       5.136  20.764 168.202  1.00 11.19           C  
ATOM    584  O   LEU A  87       4.717  20.192 169.221  1.00 12.13           O  
ATOM    585  CB  LEU A  87       7.224  22.192 168.205  1.00 12.79           C  
ATOM    586  CG  LEU A  87       7.036  22.832 169.583  1.00 14.97           C  
ATOM    587  CD1 LEU A  87       5.657  23.507 169.727  1.00 14.44           C  
ATOM    588  CD2 LEU A  87       7.306  21.826 170.682  1.00 17.93           C  
ATOM    589  N   THR A  88       4.322  21.345 167.328  1.00 11.06           N  
ATOM    590  CA  THR A  88       2.877  21.321 167.534  1.00 10.46           C  
ATOM    591  C   THR A  88       2.321  19.901 167.505  1.00 11.23           C  
ATOM    592  O   THR A  88       1.544  19.498 168.368  1.00 12.64           O  
ATOM    593  CB  THR A  88       2.185  22.227 166.489  1.00 10.95           C  
ATOM    594  OG1 THR A  88       2.683  23.561 166.635  1.00 10.66           O  
ATOM    595  CG2 THR A  88       0.670  22.260 166.659  1.00 11.22           C  
ATOM    596  N   ALA A  89       2.757  19.142 166.520  1.00 10.19           N  
ATOM    597  CA  ALA A  89       2.300  17.763 166.382  1.00 11.91           C  
ATOM    598  C   ALA A  89       2.662  16.933 167.619  1.00 13.51           C  
ATOM    599  O   ALA A  89       1.890  16.065 168.035  1.00 15.61           O  
ATOM    600  CB  ALA A  89       2.908  17.158 165.141  1.00 13.26           C  
ATOM    601  N   LEU A  90       3.825  17.179 168.205  1.00 14.20           N  
ATOM    602  CA  LEU A  90       4.244  16.413 169.384  1.00 15.54           C  
ATOM    603  C   LEU A  90       3.521  16.875 170.644  1.00 16.09           C  
ATOM    604  O   LEU A  90       3.514  16.184 171.670  1.00 17.25           O  
ATOM    605  CB  LEU A  90       5.756  16.529 169.584  1.00 15.10           C  
ATOM    606  CG  LEU A  90       6.666  15.838 168.560  1.00 15.23           C  
ATOM    607  CD1 LEU A  90       8.119  16.270 168.751  1.00 15.20           C  
ATOM    608  CD2 LEU A  90       6.546  14.316 168.655  1.00 16.91           C  
ATOM    609  N   SER A  91       2.909  18.049 170.574  1.00 16.10           N  
ATOM    610  CA  SER A  91       2.293  18.644 171.753  1.00 17.16           C  
ATOM    611  C   SER A  91       0.835  18.236 171.907  1.00 18.81           C  
ATOM    612  O   SER A  91       0.344  18.108 173.033  1.00 22.13           O  
ATOM    613  CB  SER A  91       2.472  20.171 171.739  1.00 17.63           C  
ATOM    614  OG  SER A  91       3.853  20.490 171.763  1.00 18.04           O  
ATOM    615  N   ILE A  92       0.170  17.989 170.786  1.00 16.90           N  
ATOM    616  CA  ILE A  92      -1.253  17.673 170.766  1.00 17.47           C  
ATOM    617  C   ILE A  92      -1.517  16.159 170.839  1.00 18.99           C  
ATOM    618  O   ILE A  92      -0.616  15.359 170.600  1.00 18.59           O  
ATOM    619  CB  ILE A  92      -1.958  18.310 169.532  1.00 16.86           C  
ATOM    620  CG1 ILE A  92      -1.467  17.682 168.228  1.00 16.14           C  
ATOM    621  CG2 ILE A  92      -1.746  19.845 169.518  1.00 16.42           C  
ATOM    622  CD1 ILE A  92      -2.123  18.259 166.991  1.00 15.34           C  
ATOM    623  N   PRO A  93      -2.752  15.764 171.195  1.00 20.09           N  
ATOM    624  CA  PRO A  93      -3.038  14.332 171.349  1.00 20.89           C  
ATOM    625  C   PRO A  93      -2.852  13.547 170.056  1.00 21.49           C  
ATOM    626  O   PRO A  93      -2.725  14.133 168.976  1.00 20.95           O  
ATOM    627  CB  PRO A  93      -4.517  14.308 171.775  1.00 21.64           C  
ATOM    628  CG  PRO A  93      -4.781  15.635 172.380  1.00 21.17           C  
ATOM    629  CD  PRO A  93      -3.858  16.617 171.662  1.00 20.43           C  
ATOM    630  N   ASP A  94      -2.846  12.222 170.166  1.00 23.00           N  
ATOM    631  CA  ASP A  94      -2.707  11.341 169.000  1.00 24.54           C  
ATOM    632  C   ASP A  94      -3.762  11.590 167.920  1.00 24.04           C  
ATOM    633  O   ASP A  94      -3.496  11.409 166.730  1.00 23.90           O  
ATOM    634  CB  ASP A  94      -2.755   9.870 169.431  1.00 26.45           C  
ATOM    635  CG  ASP A  94      -2.476   8.923 168.283  1.00 28.15           C  
ATOM    636  OD1 ASP A  94      -3.447   8.351 167.749  1.00 29.05           O  
ATOM    637  OD2 ASP A  94      -1.296   8.765 167.901  1.00 29.40           O  
ATOM    638  N   ASP A  95      -4.961  11.991 168.330  1.00 23.42           N  
ATOM    639  CA  ASP A  95      -6.040  12.236 167.374  1.00 23.67           C  
ATOM    640  C   ASP A  95      -6.068  13.699 166.942  1.00 22.10           C  
ATOM    641  O   ASP A  95      -7.020  14.150 166.301  1.00 21.79           O  
ATOM    642  CB  ASP A  95      -7.398  11.835 167.958  1.00 26.23           C  
ATOM    643  CG  ASP A  95      -7.717  12.552 169.264  1.00 28.15           C  
ATOM    644  OD1 ASP A  95      -6.783  12.972 169.982  1.00 29.36           O  
ATOM    645  OD2 ASP A  95      -8.914  12.683 169.592  1.00 29.90           O  
ATOM    646  N   GLY A  96      -5.032  14.444 167.325  1.00 20.45           N  
ATOM    647  CA  GLY A  96      -4.925  15.834 166.918  1.00 19.27           C  
ATOM    648  C   GLY A  96      -4.788  15.936 165.407  1.00 17.35           C  
ATOM    649  O   GLY A  96      -4.247  15.040 164.755  1.00 17.61           O  
ATOM    650  N   LYS A  97      -5.304  17.020 164.850  1.00 15.32           N  
ATOM    651  CA  LYS A  97      -5.282  17.235 163.408  1.00 16.22           C  
ATOM    652  C   LYS A  97      -4.809  18.656 163.108  1.00 14.85           C  
ATOM    653  O   LYS A  97      -5.415  19.625 163.569  1.00 15.26           O  
ATOM    654  CB  LYS A  97      -6.679  17.017 162.809  1.00 17.63           C  
ATOM    655  CG  LYS A  97      -7.234  15.578 162.953  1.00 19.85           C  
ATOM    656  CD  LYS A  97      -6.399  14.541 162.208  1.00 21.94           C  
ATOM    657  CE  LYS A  97      -7.060  13.154 162.274  1.00 23.33           C  
ATOM    658  NZ  LYS A  97      -6.152  12.065 161.798  1.00 25.58           N  
ATOM    659  N   ILE A  98      -3.745  18.753 162.322  1.00 14.11           N  
ATOM    660  CA  ILE A  98      -3.150  20.030 161.959  1.00 12.06           C  
ATOM    661  C   ILE A  98      -3.354  20.301 160.475  1.00 12.23           C  
ATOM    662  O   ILE A  98      -3.059  19.440 159.634  1.00 12.69           O  
ATOM    663  CB  ILE A  98      -1.635  20.047 162.260  1.00 12.07           C  
ATOM    664  CG1 ILE A  98      -1.374  19.702 163.734  1.00 12.35           C  
ATOM    665  CG2 ILE A  98      -1.036  21.390 161.912  1.00 12.06           C  
ATOM    666  CD1 ILE A  98       0.076  19.446 164.067  1.00 13.52           C  
ATOM    667  N   THR A  99      -3.839  21.497 160.161  1.00 10.81           N  
ATOM    668  CA  THR A  99      -3.860  22.007 158.808  1.00 12.60           C  
ATOM    669  C   THR A  99      -2.609  22.844 158.613  1.00 12.39           C  
ATOM    670  O   THR A  99      -2.414  23.862 159.278  1.00 12.10           O  
ATOM    671  CB  THR A  99      -5.116  22.871 158.580  1.00 12.89           C  
ATOM    672  OG1 THR A  99      -6.305  22.113 158.894  1.00 14.07           O  
ATOM    673  CG2 THR A  99      -5.175  23.394 157.139  1.00 14.13           C  
ATOM    674  N   ALA A 100      -1.727  22.394 157.729  1.00 11.39           N  
ATOM    675  CA  ALA A 100      -0.425  23.048 157.599  1.00 11.31           C  
ATOM    676  C   ALA A 100      -0.266  23.612 156.187  1.00 11.73           C  
ATOM    677  O   ALA A 100      -0.297  22.866 155.219  1.00 12.76           O  
ATOM    678  CB  ALA A 100       0.677  22.058 157.913  1.00 12.20           C  
ATOM    679  N   ILE A 101      -0.104  24.924 156.075  1.00 11.42           N  
ATOM    680  CA  ILE A 101      -0.160  25.605 154.778  1.00 11.84           C  
ATOM    681  C   ILE A 101       1.166  26.295 154.465  1.00 11.06           C  
ATOM    682  O   ILE A 101       1.665  27.096 155.260  1.00 11.88           O  
ATOM    683  CB  ILE A 101      -1.313  26.664 154.774  1.00 12.34           C  
ATOM    684  CG1 ILE A 101      -2.676  26.004 154.997  1.00 13.36           C  
ATOM    685  CG2 ILE A 101      -1.296  27.473 153.495  1.00 13.42           C  
ATOM    686  CD1 ILE A 101      -3.699  26.959 155.555  1.00 13.16           C  
ATOM    687  N   ASP A 102       1.722  26.012 153.294  1.00 11.69           N  
ATOM    688  CA  ASP A 102       2.932  26.728 152.860  1.00 11.50           C  
ATOM    689  C   ASP A 102       3.022  26.609 151.340  1.00 12.76           C  
ATOM    690  O   ASP A 102       2.635  25.575 150.804  1.00 14.80           O  
ATOM    691  CB  ASP A 102       4.202  26.123 153.487  1.00 11.35           C  
ATOM    692  CG  ASP A 102       5.397  27.101 153.482  1.00 11.75           C  
ATOM    693  OD1 ASP A 102       5.910  27.440 152.388  1.00 12.64           O  
ATOM    694  OD2 ASP A 102       5.815  27.550 154.576  1.00 12.75           O  
ATOM    695  N   PHE A 103       3.523  27.625 150.637  1.00 14.29           N  
ATOM    696  CA  PHE A 103       3.646  27.447 149.187  1.00 15.81           C  
ATOM    697  C   PHE A 103       4.922  26.750 148.763  1.00 16.23           C  
ATOM    698  O   PHE A 103       5.090  26.423 147.582  1.00 17.92           O  
ATOM    699  CB  PHE A 103       3.346  28.718 148.359  1.00 19.06           C  
ATOM    700  CG  PHE A 103       4.257  29.902 148.613  1.00 20.62           C  
ATOM    701  CD1 PHE A 103       5.491  29.782 149.235  1.00 21.69           C  
ATOM    702  CD2 PHE A 103       3.879  31.158 148.140  1.00 21.78           C  
ATOM    703  CE1 PHE A 103       6.304  30.910 149.420  1.00 22.55           C  
ATOM    704  CE2 PHE A 103       4.680  32.277 148.326  1.00 23.07           C  
ATOM    705  CZ  PHE A 103       5.899  32.148 148.962  1.00 23.05           C  
ATOM    706  N   ASP A 104       5.797  26.469 149.732  1.00 15.00           N  
ATOM    707  CA  ASP A 104       7.097  25.828 149.452  1.00 14.66           C  
ATOM    708  C   ASP A 104       7.151  24.396 149.982  1.00 14.17           C  
ATOM    709  O   ASP A 104       7.497  24.165 151.142  1.00 14.18           O  
ATOM    710  CB  ASP A 104       8.220  26.666 150.070  1.00 15.13           C  
ATOM    711  CG  ASP A 104       9.608  26.132 149.759  1.00 15.85           C  
ATOM    712  OD1 ASP A 104       9.714  25.080 149.098  1.00 16.99           O  
ATOM    713  OD2 ASP A 104      10.592  26.786 150.179  1.00 17.69           O  
ATOM    714  N   ARG A 105       6.822  23.433 149.121  1.00 15.35           N  
ATOM    715  CA  ARG A 105       6.918  22.024 149.490  1.00 15.84           C  
ATOM    716  C   ARG A 105       8.369  21.553 149.673  1.00 15.76           C  
ATOM    717  O   ARG A 105       8.632  20.657 150.473  1.00 14.50           O  
ATOM    718  CB  ARG A 105       6.206  21.136 148.459  1.00 16.97           C  
ATOM    719  CG  ARG A 105       6.095  19.667 148.883  1.00 18.00           C  
ATOM    720  CD  ARG A 105       5.329  18.822 147.869  1.00 19.69           C  
ATOM    721  NE  ARG A 105       3.917  19.203 147.716  1.00 21.22           N  
ATOM    722  CZ  ARG A 105       2.920  18.719 148.450  1.00 20.95           C  
ATOM    723  NH1 ARG A 105       3.158  17.835 149.403  1.00 21.76           N  
ATOM    724  NH2 ARG A 105       1.676  19.112 148.220  1.00 22.56           N  
ATOM    725  N   GLU A 106       9.304  22.161 148.947  1.00 15.99           N  
ATOM    726  CA  GLU A 106      10.717  21.773 149.047  1.00 16.29           C  
ATOM    727  C   GLU A 106      11.227  21.915 150.479  1.00 16.25           C  
ATOM    728  O   GLU A 106      11.885  21.017 151.016  1.00 16.55           O  
ATOM    729  CB  GLU A 106      11.605  22.551 148.064  1.00 17.02           C  
ATOM    730  CG  GLU A 106      11.270  22.330 146.586  1.00 18.62           C  
ATOM    731  CD  GLU A 106      11.281  20.863 146.175  1.00 19.87           C  
ATOM    732  OE1 GLU A 106      10.418  20.466 145.354  1.00 21.13           O  
ATOM    733  OE2 GLU A 106      12.149  20.106 146.668  1.00 20.61           O  
ATOM    734  N   ALA A 107      10.914  23.037 151.115  1.00 15.65           N  
ATOM    735  CA  ALA A 107      11.349  23.244 152.492  1.00 14.91           C  
ATOM    736  C   ALA A 107      10.696  22.227 153.435  1.00 14.27           C  
ATOM    737  O   ALA A 107      11.338  21.718 154.333  1.00 13.43           O  
ATOM    738  CB  ALA A 107      11.042  24.666 152.938  1.00 15.58           C  
ATOM    739  N   TYR A 108       9.400  21.975 153.255  1.00 12.73           N  
ATOM    740  CA  TYR A 108       8.664  21.006 154.091  1.00 12.86           C  
ATOM    741  C   TYR A 108       9.356  19.647 154.051  1.00 13.70           C  
ATOM    742  O   TYR A 108       9.476  18.969 155.061  1.00 14.46           O  
ATOM    743  CB  TYR A 108       7.192  20.896 153.647  1.00 12.64           C  
ATOM    744  CG  TYR A 108       6.367  19.831 154.348  1.00 12.58           C  
ATOM    745  CD1 TYR A 108       6.160  19.875 155.724  1.00 13.16           C  
ATOM    746  CD2 TYR A 108       5.775  18.799 153.635  1.00 12.33           C  
ATOM    747  CE1 TYR A 108       5.377  18.938 156.363  1.00 13.15           C  
ATOM    748  CE2 TYR A 108       5.011  17.835 154.278  1.00 12.71           C  
ATOM    749  CZ  TYR A 108       4.817  17.912 155.642  1.00 13.82           C  
ATOM    750  OH  TYR A 108       4.048  16.971 156.298  1.00 15.32           O  
ATOM    751  N   GLU A 109       9.818  19.271 152.863  1.00 14.57           N  
ATOM    752  CA  GLU A 109      10.447  17.954 152.666  1.00 15.23           C  
ATOM    753  C   GLU A 109      11.750  17.778 153.455  1.00 16.09           C  
ATOM    754  O   GLU A 109      12.207  16.648 153.669  1.00 15.44           O  
ATOM    755  CB  GLU A 109      10.682  17.720 151.174  1.00 16.44           C  
ATOM    756  CG  GLU A 109       9.396  17.475 150.435  1.00 16.99           C  
ATOM    757  CD  GLU A 109       9.519  17.572 148.930  1.00 17.80           C  
ATOM    758  OE1 GLU A 109      10.547  18.068 148.432  1.00 18.48           O  
ATOM    759  OE2 GLU A 109       8.551  17.169 148.251  1.00 19.38           O  
ATOM    760  N   ILE A 110      12.344  18.888 153.884  1.00 15.68           N  
ATOM    761  CA  ILE A 110      13.535  18.821 154.725  1.00 16.71           C  
ATOM    762  C   ILE A 110      13.145  18.328 156.130  1.00 15.78           C  
ATOM    763  O   ILE A 110      13.867  17.564 156.740  1.00 15.91           O  
ATOM    764  CB  ILE A 110      14.269  20.178 154.771  1.00 17.49           C  
ATOM    765  CG1 ILE A 110      14.872  20.498 153.388  1.00 18.55           C  
ATOM    766  CG2 ILE A 110      15.332  20.193 155.860  1.00 18.42           C  
ATOM    767  CD1 ILE A 110      15.538  21.872 153.288  1.00 20.19           C  
ATOM    768  N   GLY A 111      11.996  18.755 156.648  1.00 14.97           N  
ATOM    769  CA  GLY A 111      11.577  18.323 157.981  1.00 15.35           C  
ATOM    770  C   GLY A 111      10.797  17.024 157.986  1.00 15.62           C  
ATOM    771  O   GLY A 111      10.697  16.338 159.010  1.00 14.56           O  
ATOM    772  N   LEU A 112      10.233  16.686 156.833  1.00 15.78           N  
ATOM    773  CA  LEU A 112       9.330  15.544 156.739  1.00 16.25           C  
ATOM    774  C   LEU A 112       9.934  14.215 157.253  1.00 16.37           C  
ATOM    775  O   LEU A 112       9.239  13.474 157.938  1.00 15.46           O  
ATOM    776  CB  LEU A 112       8.786  15.434 155.314  1.00 17.48           C  
ATOM    777  CG  LEU A 112       7.708  14.420 154.957  1.00 18.42           C  
ATOM    778  CD1 LEU A 112       6.503  14.542 155.880  1.00 17.11           C  
ATOM    779  CD2 LEU A 112       7.289  14.622 153.501  1.00 18.53           C  
ATOM    780  N   PRO A 113      11.233  13.938 156.993  1.00 16.72           N  
ATOM    781  CA  PRO A 113      11.762  12.673 157.556  1.00 16.73           C  
ATOM    782  C   PRO A 113      11.717  12.612 159.087  1.00 16.83           C  
ATOM    783  O   PRO A 113      11.622  11.527 159.667  1.00 16.63           O  
ATOM    784  CB  PRO A 113      13.221  12.658 157.084  1.00 17.28           C  
ATOM    785  CG  PRO A 113      13.239  13.547 155.888  1.00 18.57           C  
ATOM    786  CD  PRO A 113      12.242  14.618 156.159  1.00 17.31           C  
ATOM    787  N   PHE A 114      11.814  13.762 159.740  1.00 16.65           N  
ATOM    788  CA  PHE A 114      11.790  13.802 161.199  1.00 16.50           C  
ATOM    789  C   PHE A 114      10.370  13.733 161.731  1.00 16.50           C  
ATOM    790  O   PHE A 114      10.099  13.121 162.764  1.00 16.48           O  
ATOM    791  CB  PHE A 114      12.569  15.024 161.685  1.00 17.07           C  
ATOM    792  CG  PHE A 114      13.940  15.091 161.088  1.00 17.83           C  
ATOM    793  CD1 PHE A 114      14.228  15.972 160.052  1.00 18.60           C  
ATOM    794  CD2 PHE A 114      14.915  14.207 161.501  1.00 19.15           C  
ATOM    795  CE1 PHE A 114      15.480  15.998 159.475  1.00 19.33           C  
ATOM    796  CE2 PHE A 114      16.159  14.220 160.931  1.00 20.17           C  
ATOM    797  CZ  PHE A 114      16.452  15.117 159.921  1.00 19.97           C  
ATOM    798  N   ILE A 115       9.458  14.345 160.994  1.00 16.66           N  
ATOM    799  CA  ILE A 115       8.053  14.188 161.277  1.00 15.98           C  
ATOM    800  C   ILE A 115       7.685  12.706 161.208  1.00 15.65           C  
ATOM    801  O   ILE A 115       6.961  12.202 162.059  1.00 15.63           O  
ATOM    802  CB  ILE A 115       7.218  15.011 160.293  1.00 15.57           C  
ATOM    803  CG1 ILE A 115       7.274  16.490 160.679  1.00 16.21           C  
ATOM    804  CG2 ILE A 115       5.796  14.537 160.255  1.00 15.73           C  
ATOM    805  CD1 ILE A 115       6.799  17.439 159.575  1.00 17.24           C  
ATOM    806  N   ARG A 116       8.220  12.014 160.211  1.00 15.55           N  
ATOM    807  CA  ARG A 116       7.966  10.579 160.060  1.00 16.66           C  
ATOM    808  C   ARG A 116       8.629   9.747 161.148  1.00 17.25           C  
ATOM    809  O   ARG A 116       7.992   8.851 161.710  1.00 18.15           O  
ATOM    810  CB  ARG A 116       8.349  10.115 158.652  1.00 17.20           C  
ATOM    811  CG  ARG A 116       7.340  10.597 157.619  1.00 17.56           C  
ATOM    812  CD  ARG A 116       7.854  10.490 156.194  1.00 18.15           C  
ATOM    813  NE  ARG A 116       6.787  10.782 155.242  1.00 18.77           N  
ATOM    814  CZ  ARG A 116       6.967  11.057 153.955  1.00 19.06           C  
ATOM    815  NH1 ARG A 116       8.191  11.094 153.443  1.00 19.28           N  
ATOM    816  NH2 ARG A 116       5.914  11.302 153.179  1.00 19.53           N  
ATOM    817  N   LYS A 117       9.885  10.040 161.467  1.00 17.65           N  
ATOM    818  CA  LYS A 117      10.556   9.331 162.569  1.00 19.50           C  
ATOM    819  C   LYS A 117       9.763   9.463 163.858  1.00 18.63           C  
ATOM    820  O   LYS A 117       9.733   8.542 164.672  1.00 19.62           O  
ATOM    821  CB  LYS A 117      11.948   9.886 162.823  1.00 21.30           C  
ATOM    822  CG  LYS A 117      13.032   9.401 161.890  1.00 23.41           C  
ATOM    823  CD  LYS A 117      14.337  10.079 162.289  1.00 24.85           C  
ATOM    824  CE  LYS A 117      15.513   9.664 161.413  1.00 26.05           C  
ATOM    825  NZ  LYS A 117      16.786  10.306 161.851  1.00 27.35           N  
ATOM    826  N   ALA A 118       9.132  10.624 164.045  1.00 18.09           N  
ATOM    827  CA  ALA A 118       8.392  10.918 165.259  1.00 18.02           C  
ATOM    828  C   ALA A 118       7.018  10.256 165.285  1.00 18.63           C  
ATOM    829  O   ALA A 118       6.339  10.254 166.315  1.00 19.57           O  
ATOM    830  CB  ALA A 118       8.244  12.441 165.424  1.00 18.07           C  
ATOM    831  N   GLY A 119       6.604   9.712 164.144  1.00 18.19           N  
ATOM    832  CA  GLY A 119       5.331   9.003 164.057  1.00 18.45           C  
ATOM    833  C   GLY A 119       4.108   9.907 164.089  1.00 17.75           C  
ATOM    834  O   GLY A 119       3.021   9.512 164.539  1.00 18.05           O  
ATOM    835  N   VAL A 120       4.268  11.132 163.599  1.00 17.10           N  
ATOM    836  CA  VAL A 120       3.181  12.105 163.659  1.00 16.80           C  
ATOM    837  C   VAL A 120       2.669  12.612 162.304  1.00 15.82           C  
ATOM    838  O   VAL A 120       1.829  13.512 162.262  1.00 14.68           O  
ATOM    839  CB  VAL A 120       3.498  13.305 164.615  1.00 17.08           C  
ATOM    840  CG1 VAL A 120       3.726  12.811 166.041  1.00 17.44           C  
ATOM    841  CG2 VAL A 120       4.702  14.114 164.123  1.00 17.35           C  
ATOM    842  N   GLU A 121       3.140  12.035 161.198  1.00 16.30           N  
ATOM    843  CA  GLU A 121       2.680  12.499 159.888  1.00 16.81           C  
ATOM    844  C   GLU A 121       1.168  12.387 159.751  1.00 16.98           C  
ATOM    845  O   GLU A 121       0.548  13.196 159.070  1.00 17.36           O  
ATOM    846  CB  GLU A 121       3.355  11.762 158.713  1.00 17.58           C  
ATOM    847  CG  GLU A 121       3.189  12.518 157.383  1.00 18.50           C  
ATOM    848  CD  GLU A 121       3.697  11.770 156.157  1.00 18.39           C  
ATOM    849  OE1 GLU A 121       4.177  10.627 156.290  1.00 19.30           O  
ATOM    850  OE2 GLU A 121       3.608  12.344 155.050  1.00 19.25           O  
ATOM    851  N   HIS A 122       0.577  11.369 160.379  1.00 18.22           N  
ATOM    852  CA  HIS A 122      -0.855  11.147 160.261  1.00 18.10           C  
ATOM    853  C   HIS A 122      -1.688  12.323 160.793  1.00 17.09           C  
ATOM    854  O   HIS A 122      -2.866  12.466 160.428  1.00 18.26           O  
ATOM    855  CB  HIS A 122      -1.247   9.864 160.991  1.00 18.80           C  
ATOM    856  CG  HIS A 122      -1.137   9.965 162.481  1.00 19.05           C  
ATOM    857  ND1 HIS A 122       0.055   9.799 163.156  1.00 19.48           N  
ATOM    858  CD2 HIS A 122      -2.073  10.217 163.427  1.00 18.95           C  
ATOM    859  CE1 HIS A 122      -0.154   9.946 164.453  1.00 18.73           C  
ATOM    860  NE2 HIS A 122      -1.437  10.203 164.642  1.00 19.69           N  
ATOM    861  N   LYS A 123      -1.082  13.168 161.636  1.00 16.24           N  
ATOM    862  CA  LYS A 123      -1.798  14.333 162.185  1.00 15.85           C  
ATOM    863  C   LYS A 123      -1.843  15.500 161.218  1.00 15.14           C  
ATOM    864  O   LYS A 123      -2.603  16.456 161.424  1.00 17.08           O  
ATOM    865  CB  LYS A 123      -1.135  14.840 163.472  1.00 16.42           C  
ATOM    866  CG  LYS A 123      -0.934  13.801 164.527  1.00 16.89           C  
ATOM    867  CD  LYS A 123      -0.460  14.443 165.829  1.00 16.68           C  
ATOM    868  CE  LYS A 123      -0.142  13.392 166.870  1.00 17.10           C  
ATOM    869  NZ  LYS A 123       0.003  13.976 168.239  1.00 18.23           N  
ATOM    870  N   ILE A 124      -1.020  15.441 160.178  1.00 14.18           N  
ATOM    871  CA  ILE A 124      -0.735  16.619 159.390  1.00 14.34           C  
ATOM    872  C   ILE A 124      -1.338  16.530 158.002  1.00 14.67           C  
ATOM    873  O   ILE A 124      -1.131  15.542 157.272  1.00 14.91           O  
ATOM    874  CB  ILE A 124       0.803  16.840 159.275  1.00 14.71           C  
ATOM    875  CG1 ILE A 124       1.438  17.098 160.664  1.00 14.93           C  
ATOM    876  CG2 ILE A 124       1.112  17.975 158.277  1.00 13.85           C  
ATOM    877  CD1 ILE A 124       2.960  17.048 160.697  1.00 15.94           C  
ATOM    878  N   ASN A 125      -2.088  17.571 157.656  1.00 13.90           N  
ATOM    879  CA  ASN A 125      -2.572  17.770 156.313  1.00 15.24           C  
ATOM    880  C   ASN A 125      -1.813  18.936 155.706  1.00 14.25           C  
ATOM    881  O   ASN A 125      -2.124  20.096 155.982  1.00 13.60           O  
ATOM    882  CB  ASN A 125      -4.070  18.073 156.295  1.00 16.82           C  
ATOM    883  CG  ASN A 125      -4.568  18.332 154.898  1.00 17.10           C  
ATOM    884  OD1 ASN A 125      -4.088  17.698 153.958  1.00 18.24           O  
ATOM    885  ND2 ASN A 125      -5.477  19.285 154.742  1.00 17.84           N  
ATOM    886  N   PHE A 126      -0.799  18.624 154.908  1.00 14.12           N  
ATOM    887  CA  PHE A 126       0.010  19.665 154.301  1.00 13.38           C  
ATOM    888  C   PHE A 126      -0.624  20.149 152.995  1.00 14.16           C  
ATOM    889  O   PHE A 126      -0.867  19.361 152.077  1.00 15.93           O  
ATOM    890  CB  PHE A 126       1.449  19.197 154.051  1.00 13.90           C  
ATOM    891  CG  PHE A 126       2.336  20.275 153.468  1.00 13.50           C  
ATOM    892  CD1 PHE A 126       2.918  21.241 154.288  1.00 13.41           C  
ATOM    893  CD2 PHE A 126       2.590  20.331 152.102  1.00 14.43           C  
ATOM    894  CE1 PHE A 126       3.711  22.239 153.746  1.00 13.93           C  
ATOM    895  CE2 PHE A 126       3.402  21.326 151.563  1.00 13.74           C  
ATOM    896  CZ  PHE A 126       3.959  22.280 152.381  1.00 13.17           C  
ATOM    897  N   ILE A 127      -0.924  21.437 152.943  1.00 13.39           N  
ATOM    898  CA  ILE A 127      -1.512  22.076 151.781  1.00 14.53           C  
ATOM    899  C   ILE A 127      -0.492  22.996 151.111  1.00 14.60           C  
ATOM    900  O   ILE A 127      -0.054  24.005 151.685  1.00 16.01           O  
ATOM    901  CB  ILE A 127      -2.748  22.911 152.172  1.00 14.49           C  
ATOM    902  CG1 ILE A 127      -3.802  22.016 152.840  1.00 14.80           C  
ATOM    903  CG2 ILE A 127      -3.305  23.637 150.954  1.00 15.76           C  
ATOM    904  CD1 ILE A 127      -5.033  22.750 153.396  1.00 15.83           C  
ATOM    905  N   GLU A 128      -0.097  22.629 149.897  1.00 14.85           N  
ATOM    906  CA  GLU A 128       0.881  23.398 149.160  1.00 14.60           C  
ATOM    907  C   GLU A 128       0.124  24.443 148.376  1.00 14.69           C  
ATOM    908  O   GLU A 128      -0.413  24.174 147.303  1.00 15.20           O  
ATOM    909  CB  GLU A 128       1.678  22.498 148.207  1.00 15.99           C  
ATOM    910  CG  GLU A 128       2.849  23.238 147.554  1.00 17.27           C  
ATOM    911  CD  GLU A 128       3.459  22.491 146.376  1.00 19.00           C  
ATOM    912  OE1 GLU A 128       3.258  21.276 146.272  1.00 21.24           O  
ATOM    913  OE2 GLU A 128       4.125  23.136 145.548  1.00 22.08           O  
ATOM    914  N   SER A 129       0.067  25.647 148.917  1.00 14.34           N  
ATOM    915  CA  SER A 129      -0.765  26.691 148.333  1.00 15.50           C  
ATOM    916  C   SER A 129      -0.339  28.046 148.842  1.00 14.47           C  
ATOM    917  O   SER A 129       0.230  28.157 149.925  1.00 14.23           O  
ATOM    918  CB  SER A 129      -2.225  26.440 148.743  1.00 17.55           C  
ATOM    919  OG  SER A 129      -3.090  27.512 148.408  1.00 19.76           O  
ATOM    920  N   ASP A 130      -0.668  29.080 148.082  1.00 14.20           N  
ATOM    921  CA  ASP A 130      -0.735  30.404 148.644  1.00 14.90           C  
ATOM    922  C   ASP A 130      -1.607  30.341 149.897  1.00 14.54           C  
ATOM    923  O   ASP A 130      -2.662  29.700 149.901  1.00 13.92           O  
ATOM    924  CB  ASP A 130      -1.378  31.369 147.652  1.00 15.96           C  
ATOM    925  CG  ASP A 130      -1.560  32.735 148.247  1.00 17.98           C  
ATOM    926  OD1 ASP A 130      -0.551  33.457 148.362  1.00 19.52           O  
ATOM    927  OD2 ASP A 130      -2.696  33.070 148.635  1.00 17.91           O  
ATOM    928  N   ALA A 131      -1.164  31.005 150.956  1.00 14.70           N  
ATOM    929  CA  ALA A 131      -1.839  30.938 152.232  1.00 14.13           C  
ATOM    930  C   ALA A 131      -3.246  31.528 152.222  1.00 14.10           C  
ATOM    931  O   ALA A 131      -4.172  30.924 152.753  1.00 13.93           O  
ATOM    932  CB  ALA A 131      -1.008  31.620 153.312  1.00 13.43           C  
ATOM    933  N   MET A 132      -3.392  32.712 151.639  1.00 14.21           N  
ATOM    934  CA  MET A 132      -4.694  33.355 151.601  1.00 14.89           C  
ATOM    935  C   MET A 132      -5.673  32.478 150.830  1.00 14.85           C  
ATOM    936  O   MET A 132      -6.822  32.280 151.265  1.00 15.24           O  
ATOM    937  CB  MET A 132      -4.603  34.751 150.997  1.00 15.66           C  
ATOM    938  CG  MET A 132      -5.665  35.695 151.557  1.00 16.34           C  
ATOM    939  SD  MET A 132      -5.247  36.161 153.261  1.00 17.97           S  
ATOM    940  CE  MET A 132      -3.812  37.174 152.966  1.00 18.35           C  
ATOM    941  N   LEU A 133      -5.237  31.930 149.697  1.00 14.53           N  
ATOM    942  CA  LEU A 133      -6.107  31.029 148.933  1.00 15.04           C  
ATOM    943  C   LEU A 133      -6.579  29.828 149.762  1.00 14.38           C  
ATOM    944  O   LEU A 133      -7.767  29.470 149.756  1.00 16.58           O  
ATOM    945  CB  LEU A 133      -5.409  30.557 147.654  1.00 14.95           C  
ATOM    946  CG  LEU A 133      -6.226  29.686 146.707  1.00 14.83           C  
ATOM    947  CD1 LEU A 133      -7.492  30.444 146.299  1.00 14.60           C  
ATOM    948  CD2 LEU A 133      -5.376  29.295 145.490  1.00 15.38           C  
ATOM    949  N   ALA A 134      -5.654  29.189 150.482  1.00 14.93           N  
ATOM    950  CA  ALA A 134      -6.005  28.025 151.280  1.00 14.45           C  
ATOM    951  C   ALA A 134      -7.002  28.402 152.383  1.00 14.07           C  
ATOM    952  O   ALA A 134      -7.976  27.676 152.635  1.00 14.52           O  
ATOM    953  CB  ALA A 134      -4.744  27.385 151.881  1.00 14.62           C  
ATOM    954  N   LEU A 135      -6.750  29.526 153.042  1.00 14.42           N  
ATOM    955  CA  LEU A 135      -7.592  29.970 154.139  1.00 14.33           C  
ATOM    956  C   LEU A 135      -8.983  30.300 153.618  1.00 14.75           C  
ATOM    957  O   LEU A 135      -9.977  29.936 154.237  1.00 15.18           O  
ATOM    958  CB  LEU A 135      -6.976  31.179 154.834  1.00 14.29           C  
ATOM    959  CG  LEU A 135      -5.709  30.878 155.641  1.00 14.60           C  
ATOM    960  CD1 LEU A 135      -5.063  32.202 156.024  1.00 15.55           C  
ATOM    961  CD2 LEU A 135      -5.996  30.001 156.865  1.00 14.58           C  
ATOM    962  N   ASP A 136      -9.047  30.964 152.465  1.00 13.89           N  
ATOM    963  CA  ASP A 136     -10.344  31.328 151.902  1.00 14.37           C  
ATOM    964  C   ASP A 136     -11.121  30.114 151.390  1.00 14.48           C  
ATOM    965  O   ASP A 136     -12.343  30.062 151.542  1.00 16.96           O  
ATOM    966  CB  ASP A 136     -10.186  32.427 150.847  1.00 14.42           C  
ATOM    967  CG  ASP A 136      -9.784  33.771 151.462  1.00 15.08           C  
ATOM    968  OD1 ASP A 136      -9.970  33.940 152.687  1.00 16.75           O  
ATOM    969  OD2 ASP A 136      -9.273  34.647 150.737  1.00 16.29           O  
ATOM    970  N   ASN A 137     -10.429  29.107 150.851  1.00 15.18           N  
ATOM    971  CA  ASN A 137     -11.085  27.851 150.509  1.00 16.53           C  
ATOM    972  C   ASN A 137     -11.617  27.140 151.760  1.00 17.44           C  
ATOM    973  O   ASN A 137     -12.761  26.678 151.779  1.00 18.10           O  
ATOM    974  CB  ASN A 137     -10.164  26.939 149.687  1.00 16.65           C  
ATOM    975  CG  ASN A 137     -10.222  27.249 148.202  1.00 16.84           C  
ATOM    976  OD1 ASN A 137     -11.167  26.852 147.515  1.00 16.36           O  
ATOM    977  ND2 ASN A 137      -9.230  27.963 147.702  1.00 15.81           N  
ATOM    978  N   LEU A 138     -10.792  27.048 152.801  0.50 17.71           N  
ATOM    980  CA  LEU A 138     -11.240  26.485 154.072  0.50 18.86           C  
ATOM    982  C   LEU A 138     -12.531  27.154 154.535  0.50 19.24           C  
ATOM    984  O   LEU A 138     -13.496  26.482 154.898  0.50 20.10           O  
ATOM    986  CB  LEU A 138     -10.158  26.650 155.146  0.50 19.12           C  
ATOM    988  CG  LEU A 138      -8.950  25.724 155.036  0.50 19.77           C  
ATOM    990  CD1 LEU A 138      -7.929  26.070 156.105  0.50 19.86           C  
ATOM    992  CD2 LEU A 138      -9.382  24.262 155.143  0.50 19.86           C  
ATOM    994  N   LEU A 139     -12.546  28.479 154.514  1.00 19.07           N  
ATOM    995  CA  LEU A 139     -13.703  29.242 154.999  1.00 20.75           C  
ATOM    996  C   LEU A 139     -14.978  29.124 154.164  1.00 22.67           C  
ATOM    997  O   LEU A 139     -16.049  29.548 154.606  1.00 22.46           O  
ATOM    998  CB  LEU A 139     -13.331  30.705 155.169  1.00 20.09           C  
ATOM    999  CG  LEU A 139     -12.529  30.973 156.444  1.00 19.60           C  
ATOM   1000  CD1 LEU A 139     -11.898  32.359 156.353  1.00 20.44           C  
ATOM   1001  CD2 LEU A 139     -13.422  30.841 157.663  1.00 20.04           C  
ATOM   1002  N   GLN A 140     -14.876  28.578 152.957  1.00 24.76           N  
ATOM   1003  CA  GLN A 140     -16.078  28.348 152.173  1.00 27.76           C  
ATOM   1004  C   GLN A 140     -16.800  27.155 152.770  1.00 29.91           C  
ATOM   1005  O   GLN A 140     -18.013  26.989 152.582  1.00 30.46           O  
ATOM   1006  CB  GLN A 140     -15.756  28.140 150.695  1.00 28.93           C  
ATOM   1007  CG  GLN A 140     -15.554  29.450 149.947  1.00 29.81           C  
ATOM   1008  CD  GLN A 140     -15.824  29.330 148.459  1.00 30.68           C  
ATOM   1009  OE1 GLN A 140     -16.277  30.282 147.820  1.00 31.70           O  
ATOM   1010  NE2 GLN A 140     -15.546  28.158 147.900  1.00 30.84           N  
ATOM   1011  N   GLY A 141     -16.046  26.340 153.508  1.00 31.28           N  
ATOM   1012  CA  GLY A 141     -16.608  25.237 154.282  1.00 33.58           C  
ATOM   1013  C   GLY A 141     -17.647  25.732 155.269  1.00 35.00           C  
ATOM   1014  O   GLY A 141     -17.399  26.653 156.052  1.00 35.75           O  
ATOM   1015  N   GLN A 142     -18.816  25.108 155.237  1.00 36.21           N  
ATOM   1016  CA  GLN A 142     -19.949  25.568 156.024  1.00 36.72           C  
ATOM   1017  C   GLN A 142     -19.730  25.420 157.532  1.00 36.59           C  
ATOM   1018  O   GLN A 142     -20.397  26.085 158.328  1.00 37.60           O  
ATOM   1019  CB  GLN A 142     -21.219  24.830 155.593  1.00 37.17           C  
ATOM   1020  CG  GLN A 142     -21.623  25.081 154.144  1.00 37.38           C  
ATOM   1021  CD  GLN A 142     -21.978  26.530 153.879  1.00 37.71           C  
ATOM   1022  OE1 GLN A 142     -21.607  27.091 152.847  1.00 38.54           O  
ATOM   1023  NE2 GLN A 142     -22.693  27.147 154.811  1.00 37.63           N  
ATOM   1024  N   GLU A 143     -18.791  24.562 157.918  1.00 35.42           N  
ATOM   1025  CA  GLU A 143     -18.564  24.259 159.328  1.00 34.01           C  
ATOM   1026  C   GLU A 143     -17.130  24.556 159.782  1.00 32.28           C  
ATOM   1027  O   GLU A 143     -16.711  24.125 160.853  1.00 31.34           O  
ATOM   1028  CB  GLU A 143     -18.930  22.801 159.614  1.00 34.95           C  
ATOM   1029  CG  GLU A 143     -20.400  22.475 159.357  1.00 36.20           C  
ATOM   1030  CD  GLU A 143     -20.723  20.999 159.552  1.00 37.16           C  
ATOM   1031  OE1 GLU A 143     -21.656  20.694 160.329  1.00 37.60           O  
ATOM   1032  OE2 GLU A 143     -20.046  20.148 158.931  1.00 37.67           O  
ATOM   1033  N   SER A 144     -16.387  25.299 158.968  1.00 30.93           N  
ATOM   1034  CA  SER A 144     -14.989  25.617 159.277  1.00 29.56           C  
ATOM   1035  C   SER A 144     -14.859  26.668 160.373  1.00 28.14           C  
ATOM   1036  O   SER A 144     -13.888  26.661 161.148  1.00 27.34           O  
ATOM   1037  CB  SER A 144     -14.284  26.130 158.025  1.00 29.54           C  
ATOM   1038  OG  SER A 144     -14.956  27.266 157.514  1.00 29.39           O  
ATOM   1039  N   GLU A 145     -15.819  27.584 160.417  1.00 27.15           N  
ATOM   1040  CA  GLU A 145     -15.798  28.674 161.375  1.00 26.21           C  
ATOM   1041  C   GLU A 145     -15.841  28.167 162.810  1.00 24.11           C  
ATOM   1042  O   GLU A 145     -16.642  27.304 163.180  1.00 23.88           O  
ATOM   1043  CB  GLU A 145     -16.927  29.678 161.105  1.00 28.36           C  
ATOM   1044  CG  GLU A 145     -16.838  30.317 159.726  1.00 30.75           C  
ATOM   1045  CD  GLU A 145     -17.604  31.630 159.612  1.00 32.37           C  
ATOM   1046  OE1 GLU A 145     -17.490  32.488 160.520  1.00 33.59           O  
ATOM   1047  OE2 GLU A 145     -18.306  31.814 158.597  1.00 33.33           O  
ATOM   1048  N   GLY A 146     -14.936  28.690 163.621  1.00 20.87           N  
ATOM   1049  CA  GLY A 146     -14.908  28.366 165.026  1.00 21.01           C  
ATOM   1050  C   GLY A 146     -14.526  26.930 165.317  1.00 20.25           C  
ATOM   1051  O   GLY A 146     -14.781  26.440 166.413  1.00 21.69           O  
ATOM   1052  N   SER A 147     -13.897  26.259 164.357  1.00 20.17           N  
ATOM   1053  CA  SER A 147     -13.517  24.847 164.536  1.00 19.55           C  
ATOM   1054  C   SER A 147     -12.090  24.611 165.046  1.00 19.05           C  
ATOM   1055  O   SER A 147     -11.772  23.518 165.512  1.00 18.79           O  
ATOM   1056  CB  SER A 147     -13.751  24.046 163.246  1.00 20.64           C  
ATOM   1057  OG  SER A 147     -12.804  24.407 162.253  1.00 22.26           O  
ATOM   1058  N   TYR A 148     -11.244  25.630 164.982  1.00 18.08           N  
ATOM   1059  CA  TYR A 148      -9.839  25.435 165.356  1.00 16.38           C  
ATOM   1060  C   TYR A 148      -9.552  25.869 166.780  1.00 15.52           C  
ATOM   1061  O   TYR A 148     -10.053  26.895 167.238  1.00 16.36           O  
ATOM   1062  CB  TYR A 148      -8.909  26.160 164.384  1.00 15.06           C  
ATOM   1063  CG  TYR A 148      -8.776  25.461 163.046  1.00 14.72           C  
ATOM   1064  CD1 TYR A 148      -9.645  25.756 161.998  1.00 14.15           C  
ATOM   1065  CD2 TYR A 148      -7.793  24.508 162.828  1.00 15.23           C  
ATOM   1066  CE1 TYR A 148      -9.530  25.130 160.784  1.00 14.64           C  
ATOM   1067  CE2 TYR A 148      -7.671  23.872 161.607  1.00 14.63           C  
ATOM   1068  CZ  TYR A 148      -8.554  24.182 160.591  1.00 14.59           C  
ATOM   1069  OH  TYR A 148      -8.449  23.581 159.368  1.00 16.14           O  
ATOM   1070  N   ASP A 149      -8.714  25.094 167.464  1.00 14.15           N  
ATOM   1071  CA  ASP A 149      -8.326  25.411 168.827  1.00 14.06           C  
ATOM   1072  C   ASP A 149      -7.178  26.405 168.889  1.00 12.82           C  
ATOM   1073  O   ASP A 149      -7.064  27.154 169.852  1.00 14.20           O  
ATOM   1074  CB  ASP A 149      -7.932  24.154 169.592  1.00 15.15           C  
ATOM   1075  CG  ASP A 149      -9.064  23.158 169.697  1.00 16.22           C  
ATOM   1076  OD1 ASP A 149     -10.196  23.604 169.958  1.00 18.83           O  
ATOM   1077  OD2 ASP A 149      -8.804  21.959 169.522  1.00 15.94           O  
ATOM   1078  N   PHE A 150      -6.318  26.382 167.868  1.00 13.08           N  
ATOM   1079  CA  PHE A 150      -5.047  27.086 167.913  1.00 11.79           C  
ATOM   1080  C   PHE A 150      -4.609  27.351 166.492  1.00 11.19           C  
ATOM   1081  O   PHE A 150      -4.719  26.472 165.633  1.00 10.86           O  
ATOM   1082  CB  PHE A 150      -4.001  26.255 168.651  1.00 12.70           C  
ATOM   1083  CG  PHE A 150      -2.621  26.887 168.700  1.00 13.47           C  
ATOM   1084  CD1 PHE A 150      -2.260  27.714 169.744  1.00 15.00           C  
ATOM   1085  CD2 PHE A 150      -1.676  26.601 167.719  1.00 13.40           C  
ATOM   1086  CE1 PHE A 150      -0.976  28.288 169.792  1.00 15.56           C  
ATOM   1087  CE2 PHE A 150      -0.415  27.164 167.753  1.00 13.91           C  
ATOM   1088  CZ  PHE A 150      -0.074  28.007 168.794  1.00 15.26           C  
ATOM   1089  N   GLY A 151      -4.113  28.563 166.255  1.00  9.95           N  
ATOM   1090  CA  GLY A 151      -3.513  28.932 164.959  1.00 10.70           C  
ATOM   1091  C   GLY A 151      -2.137  29.553 165.147  1.00 10.91           C  
ATOM   1092  O   GLY A 151      -1.919  30.304 166.095  1.00 11.54           O  
ATOM   1093  N   PHE A 152      -1.201  29.205 164.274  1.00 10.95           N  
ATOM   1094  CA  PHE A 152       0.106  29.843 164.294  1.00  9.85           C  
ATOM   1095  C   PHE A 152       0.334  30.506 162.942  1.00  9.89           C  
ATOM   1096  O   PHE A 152       0.326  29.842 161.914  1.00 10.76           O  
ATOM   1097  CB  PHE A 152       1.186  28.806 164.590  1.00 10.47           C  
ATOM   1098  CG  PHE A 152       2.583  29.391 164.766  1.00 10.02           C  
ATOM   1099  CD1 PHE A 152       2.822  30.527 165.547  1.00 10.11           C  
ATOM   1100  CD2 PHE A 152       3.679  28.779 164.168  1.00 11.27           C  
ATOM   1101  CE1 PHE A 152       4.116  31.053 165.718  1.00 10.76           C  
ATOM   1102  CE2 PHE A 152       4.961  29.285 164.359  1.00 11.01           C  
ATOM   1103  CZ  PHE A 152       5.172  30.434 165.129  1.00 10.47           C  
ATOM   1104  N   VAL A 153       0.499  31.827 162.949  1.00 10.51           N  
ATOM   1105  CA  VAL A 153       0.656  32.562 161.724  1.00 10.91           C  
ATOM   1106  C   VAL A 153       2.121  32.965 161.675  1.00 10.71           C  
ATOM   1107  O   VAL A 153       2.598  33.734 162.529  1.00 11.16           O  
ATOM   1108  CB  VAL A 153      -0.258  33.809 161.720  1.00 10.75           C  
ATOM   1109  CG1 VAL A 153       0.011  34.643 160.483  1.00 13.14           C  
ATOM   1110  CG2 VAL A 153      -1.762  33.382 161.789  1.00 13.34           C  
ATOM   1111  N   ASP A 154       2.836  32.434 160.678  1.00 11.78           N  
ATOM   1112  CA  ASP A 154       4.279  32.653 160.567  1.00 10.92           C  
ATOM   1113  C   ASP A 154       4.696  32.666 159.097  1.00 12.30           C  
ATOM   1114  O   ASP A 154       5.728  32.144 158.734  1.00 12.91           O  
ATOM   1115  CB  ASP A 154       5.049  31.565 161.309  1.00 11.43           C  
ATOM   1116  CG  ASP A 154       6.511  31.913 161.488  1.00 11.08           C  
ATOM   1117  OD1 ASP A 154       6.864  33.115 161.426  1.00 12.44           O  
ATOM   1118  OD2 ASP A 154       7.346  30.992 161.700  1.00 11.48           O  
ATOM   1119  N   ALA A 155       3.847  33.223 158.235  1.00 12.21           N  
ATOM   1120  CA  ALA A 155       4.153  33.273 156.806  1.00 12.66           C  
ATOM   1121  C   ALA A 155       4.729  34.647 156.431  1.00 13.17           C  
ATOM   1122  O   ALA A 155       5.562  35.181 157.149  1.00 14.18           O  
ATOM   1123  CB  ALA A 155       2.922  32.906 155.963  1.00 13.51           C  
ATOM   1124  N   ASP A 156       4.271  35.217 155.320  1.00 13.30           N  
ATOM   1125  CA  ASP A 156       4.749  36.523 154.866  1.00 14.25           C  
ATOM   1126  C   ASP A 156       4.163  37.669 155.701  1.00 14.22           C  
ATOM   1127  O   ASP A 156       2.958  37.824 155.831  1.00 14.87           O  
ATOM   1128  CB  ASP A 156       4.463  36.707 153.367  1.00 15.66           C  
ATOM   1129  CG  ASP A 156       3.026  36.402 152.999  1.00 17.12           C  
ATOM   1130  OD1 ASP A 156       2.433  35.440 153.547  1.00 16.97           O  
ATOM   1131  OD2 ASP A 156       2.496  37.127 152.125  1.00 19.47           O  
ATOM   1132  N   LYS A 157       5.048  38.465 156.295  1.00 13.21           N  
ATOM   1133  CA  LYS A 157       4.636  39.416 157.321  1.00 14.48           C  
ATOM   1134  C   LYS A 157       3.677  40.520 156.820  1.00 14.72           C  
ATOM   1135  O   LYS A 157       2.756  40.909 157.551  1.00 14.07           O  
ATOM   1136  CB  LYS A 157       5.855  40.013 158.041  1.00 14.89           C  
ATOM   1137  CG  LYS A 157       6.973  39.001 158.376  1.00 15.55           C  
ATOM   1138  CD  LYS A 157       6.484  37.703 159.021  1.00 14.36           C  
ATOM   1139  CE  LYS A 157       7.614  36.639 159.125  1.00 15.65           C  
ATOM   1140  NZ  LYS A 157       7.080  35.280 159.501  1.00 14.56           N  
ATOM   1141  N   PRO A 158       3.865  41.007 155.567  1.00 14.83           N  
ATOM   1142  CA  PRO A 158       2.903  41.993 155.055  1.00 14.88           C  
ATOM   1143  C   PRO A 158       1.460  41.497 155.008  1.00 15.11           C  
ATOM   1144  O   PRO A 158       0.549  42.320 154.962  1.00 16.49           O  
ATOM   1145  CB  PRO A 158       3.389  42.247 153.629  1.00 15.80           C  
ATOM   1146  CG  PRO A 158       4.866  41.980 153.704  1.00 15.50           C  
ATOM   1147  CD  PRO A 158       4.964  40.782 154.611  1.00 15.24           C  
ATOM   1148  N   ASN A 159       1.242  40.183 155.009  1.00 15.25           N  
ATOM   1149  CA  ASN A 159      -0.127  39.657 154.977  1.00 15.94           C  
ATOM   1150  C   ASN A 159      -0.704  39.300 156.347  1.00 14.36           C  
ATOM   1151  O   ASN A 159      -1.831  38.823 156.447  1.00 15.39           O  
ATOM   1152  CB  ASN A 159      -0.226  38.450 154.039  1.00 16.51           C  
ATOM   1153  CG  ASN A 159      -0.524  38.846 152.611  1.00 18.15           C  
ATOM   1154  OD1 ASN A 159      -1.234  39.821 152.359  1.00 19.80           O  
ATOM   1155  ND2 ASN A 159       0.017  38.088 151.665  1.00 19.08           N  
ATOM   1156  N   TYR A 160       0.054  39.527 157.417  1.00 14.33           N  
ATOM   1157  CA  TYR A 160      -0.418  39.148 158.755  1.00 13.34           C  
ATOM   1158  C   TYR A 160      -1.781  39.746 159.098  1.00 13.75           C  
ATOM   1159  O   TYR A 160      -2.610  39.083 159.710  1.00 14.21           O  
ATOM   1160  CB  TYR A 160       0.585  39.564 159.827  1.00 13.65           C  
ATOM   1161  CG  TYR A 160       1.689  38.566 160.154  1.00 13.32           C  
ATOM   1162  CD1 TYR A 160       2.079  37.566 159.264  1.00 13.23           C  
ATOM   1163  CD2 TYR A 160       2.363  38.662 161.356  1.00 14.48           C  
ATOM   1164  CE1 TYR A 160       3.126  36.672 159.595  1.00 12.75           C  
ATOM   1165  CE2 TYR A 160       3.372  37.782 161.692  1.00 14.03           C  
ATOM   1166  CZ  TYR A 160       3.749  36.802 160.818  1.00 12.84           C  
ATOM   1167  OH  TYR A 160       4.766  35.968 161.182  1.00 13.09           O  
ATOM   1168  N   ILE A 161      -1.987  41.011 158.741  1.00 14.51           N  
ATOM   1169  CA  ILE A 161      -3.251  41.662 159.050  1.00 15.82           C  
ATOM   1170  C   ILE A 161      -4.407  40.969 158.344  1.00 15.97           C  
ATOM   1171  O   ILE A 161      -5.430  40.697 158.961  1.00 16.32           O  
ATOM   1172  CB  ILE A 161      -3.204  43.182 158.792  1.00 15.96           C  
ATOM   1173  CG1 ILE A 161      -2.336  43.855 159.869  1.00 16.32           C  
ATOM   1174  CG2 ILE A 161      -4.636  43.760 158.738  1.00 16.23           C  
ATOM   1175  CD1 ILE A 161      -2.133  45.349 159.667  1.00 18.05           C  
ATOM   1176  N   LYS A 162      -4.229  40.632 157.071  1.00 15.58           N  
ATOM   1177  CA  LYS A 162      -5.256  39.873 156.360  1.00 15.92           C  
ATOM   1178  C   LYS A 162      -5.434  38.470 156.929  1.00 14.56           C  
ATOM   1179  O   LYS A 162      -6.548  37.962 157.002  1.00 15.69           O  
ATOM   1180  CB  LYS A 162      -4.934  39.777 154.873  1.00 17.40           C  
ATOM   1181  CG  LYS A 162      -5.151  41.055 154.093  1.00 20.11           C  
ATOM   1182  CD  LYS A 162      -5.038  40.760 152.609  1.00 21.59           C  
ATOM   1183  CE  LYS A 162      -5.362  41.976 151.759  1.00 23.22           C  
ATOM   1184  NZ  LYS A 162      -4.197  42.908 151.640  1.00 25.34           N  
ATOM   1185  N   TYR A 163      -4.334  37.820 157.311  1.00 13.62           N  
ATOM   1186  CA  TYR A 163      -4.437  36.488 157.898  1.00 13.00           C  
ATOM   1187  C   TYR A 163      -5.257  36.532 159.195  1.00 12.20           C  
ATOM   1188  O   TYR A 163      -6.046  35.635 159.468  1.00 14.62           O  
ATOM   1189  CB  TYR A 163      -3.060  35.857 158.182  1.00 13.53           C  
ATOM   1190  CG  TYR A 163      -2.250  35.570 156.939  1.00 13.96           C  
ATOM   1191  CD1 TYR A 163      -2.851  35.084 155.785  1.00 14.36           C  
ATOM   1192  CD2 TYR A 163      -0.881  35.801 156.909  1.00 13.32           C  
ATOM   1193  CE1 TYR A 163      -2.112  34.825 154.649  1.00 14.82           C  
ATOM   1194  CE2 TYR A 163      -0.129  35.538 155.774  1.00 14.03           C  
ATOM   1195  CZ  TYR A 163      -0.746  35.069 154.644  1.00 14.58           C  
ATOM   1196  OH  TYR A 163      -0.026  34.805 153.505  1.00 16.25           O  
ATOM   1197  N   HIS A 164      -5.062  37.578 159.987  1.00 12.68           N  
ATOM   1198  CA  HIS A 164      -5.792  37.732 161.243  1.00 13.21           C  
ATOM   1199  C   HIS A 164      -7.317  37.740 161.033  1.00 13.68           C  
ATOM   1200  O   HIS A 164      -8.057  37.149 161.808  1.00 14.10           O  
ATOM   1201  CB  HIS A 164      -5.333  39.006 161.937  1.00 13.60           C  
ATOM   1202  CG  HIS A 164      -5.928  39.213 163.297  1.00 13.82           C  
ATOM   1203  ND1 HIS A 164      -5.686  38.364 164.358  1.00 13.36           N  
ATOM   1204  CD2 HIS A 164      -6.743  40.186 163.773  1.00 14.98           C  
ATOM   1205  CE1 HIS A 164      -6.329  38.805 165.426  1.00 14.72           C  
ATOM   1206  NE2 HIS A 164      -6.986  39.902 165.095  1.00 14.04           N  
ATOM   1207  N   GLU A 165      -7.758  38.382 159.958  1.00 15.74           N  
ATOM   1208  CA  GLU A 165      -9.170  38.439 159.596  1.00 17.87           C  
ATOM   1209  C   GLU A 165      -9.695  37.018 159.457  1.00 16.47           C  
ATOM   1210  O   GLU A 165     -10.764  36.684 159.949  1.00 17.57           O  
ATOM   1211  CB  GLU A 165      -9.284  39.212 158.281  1.00 20.30           C  
ATOM   1212  CG  GLU A 165     -10.659  39.447 157.700  1.00 23.56           C  
ATOM   1213  CD  GLU A 165     -10.568  39.867 156.239  1.00 25.25           C  
ATOM   1214  OE1 GLU A 165      -9.646  40.649 155.876  1.00 25.81           O  
ATOM   1215  OE2 GLU A 165     -11.398  39.388 155.443  1.00 25.57           O  
ATOM   1216  N   ARG A 166      -8.914  36.164 158.800  1.00 15.12           N  
ATOM   1217  CA  ARG A 166      -9.313  34.785 158.569  1.00 14.81           C  
ATOM   1218  C   ARG A 166      -9.219  33.927 159.832  1.00 14.35           C  
ATOM   1219  O   ARG A 166     -10.123  33.147 160.151  1.00 14.04           O  
ATOM   1220  CB  ARG A 166      -8.450  34.173 157.452  1.00 15.72           C  
ATOM   1221  CG  ARG A 166      -8.935  34.497 156.063  1.00 16.65           C  
ATOM   1222  CD  ARG A 166      -8.339  35.769 155.553  1.00 17.15           C  
ATOM   1223  NE  ARG A 166      -8.685  35.992 154.151  1.00 16.87           N  
ATOM   1224  CZ  ARG A 166      -8.588  37.172 153.555  1.00 17.96           C  
ATOM   1225  NH1 ARG A 166      -8.148  38.215 154.245  1.00 17.30           N  
ATOM   1226  NH2 ARG A 166      -8.935  37.310 152.275  1.00 18.15           N  
ATOM   1227  N   LEU A 167      -8.110  34.056 160.545  1.00 13.88           N  
ATOM   1228  CA  LEU A 167      -7.869  33.261 161.724  1.00 13.34           C  
ATOM   1229  C   LEU A 167      -8.894  33.571 162.806  1.00 13.13           C  
ATOM   1230  O   LEU A 167      -9.305  32.686 163.556  1.00 12.83           O  
ATOM   1231  CB  LEU A 167      -6.457  33.519 162.265  1.00 13.43           C  
ATOM   1232  CG  LEU A 167      -5.343  32.606 161.747  1.00 13.52           C  
ATOM   1233  CD1 LEU A 167      -5.502  31.220 162.319  1.00 14.15           C  
ATOM   1234  CD2 LEU A 167      -5.315  32.567 160.235  1.00 14.02           C  
ATOM   1235  N   MET A 168      -9.343  34.824 162.859  1.00 13.60           N  
ATOM   1236  CA  MET A 168     -10.371  35.196 163.837  1.00 13.91           C  
ATOM   1237  C   MET A 168     -11.720  34.517 163.576  1.00 14.37           C  
ATOM   1238  O   MET A 168     -12.543  34.401 164.494  1.00 15.54           O  
ATOM   1239  CB  MET A 168     -10.501  36.713 163.930  1.00 14.72           C  
ATOM   1240  CG  MET A 168      -9.374  37.391 164.700  1.00 15.36           C  
ATOM   1241  SD  MET A 168      -9.252  36.838 166.430  1.00 16.15           S  
ATOM   1242  CE  MET A 168     -10.829  37.449 167.059  1.00 14.79           C  
ATOM   1243  N   LYS A 169     -11.935  34.064 162.336  1.00 14.72           N  
ATOM   1244  CA  LYS A 169     -13.133  33.308 161.979  1.00 15.38           C  
ATOM   1245  C   LYS A 169     -12.950  31.806 162.195  1.00 14.96           C  
ATOM   1246  O   LYS A 169     -13.864  31.110 162.609  1.00 15.41           O  
ATOM   1247  CB  LYS A 169     -13.516  33.568 160.524  1.00 16.44           C  
ATOM   1248  CG  LYS A 169     -13.948  34.992 160.246  1.00 18.19           C  
ATOM   1249  CD  LYS A 169     -14.246  35.191 158.763  1.00 20.42           C  
ATOM   1250  CE  LYS A 169     -14.384  36.679 158.427  1.00 22.16           C  
ATOM   1251  NZ  LYS A 169     -14.489  36.910 156.951  1.00 22.95           N  
ATOM   1252  N   LEU A 170     -11.754  31.297 161.906  1.00 13.97           N  
ATOM   1253  CA  LEU A 170     -11.459  29.872 162.008  1.00 14.75           C  
ATOM   1254  C   LEU A 170     -11.265  29.366 163.430  1.00 14.39           C  
ATOM   1255  O   LEU A 170     -11.650  28.249 163.751  1.00 14.66           O  
ATOM   1256  CB  LEU A 170     -10.219  29.532 161.177  1.00 14.01           C  
ATOM   1257  CG  LEU A 170     -10.370  29.677 159.661  1.00 15.06           C  
ATOM   1258  CD1 LEU A 170      -8.975  29.802 159.035  1.00 15.31           C  
ATOM   1259  CD2 LEU A 170     -11.149  28.496 159.077  1.00 16.04           C  
ATOM   1260  N   VAL A 171     -10.668  30.184 164.289  1.00 15.58           N  
ATOM   1261  CA  VAL A 171     -10.425  29.745 165.649  1.00 15.59           C  
ATOM   1262  C   VAL A 171     -11.650  29.964 166.539  1.00 16.15           C  
ATOM   1263  O   VAL A 171     -12.355  30.968 166.417  1.00 16.68           O  
ATOM   1264  CB  VAL A 171      -9.166  30.438 166.215  1.00 16.55           C  
ATOM   1265  CG1 VAL A 171      -8.945  30.087 167.651  1.00 17.47           C  
ATOM   1266  CG2 VAL A 171      -7.952  30.012 165.409  1.00 17.39           C  
ATOM   1267  N   LYS A 172     -11.903  29.000 167.412  1.00 15.43           N  
ATOM   1268  CA  LYS A 172     -13.057  29.057 168.310  1.00 17.05           C  
ATOM   1269  C   LYS A 172     -12.942  30.192 169.315  1.00 17.15           C  
ATOM   1270  O   LYS A 172     -11.852  30.687 169.613  1.00 17.41           O  
ATOM   1271  CB  LYS A 172     -13.215  27.738 169.066  1.00 18.63           C  
ATOM   1272  CG  LYS A 172     -12.098  27.463 170.047  1.00 20.72           C  
ATOM   1273  CD  LYS A 172     -12.253  26.127 170.743  1.00 22.09           C  
ATOM   1274  CE  LYS A 172     -11.081  25.881 171.694  1.00 23.32           C  
ATOM   1275  NZ  LYS A 172     -11.277  24.662 172.514  1.00 24.75           N  
ATOM   1276  N   VAL A 173     -14.084  30.583 169.868  1.00 17.22           N  
ATOM   1277  CA  VAL A 173     -14.087  31.481 170.997  1.00 17.30           C  
ATOM   1278  C   VAL A 173     -13.311  30.814 172.116  1.00 16.72           C  
ATOM   1279  O   VAL A 173     -13.521  29.636 172.423  1.00 17.08           O  
ATOM   1280  CB  VAL A 173     -15.529  31.806 171.449  1.00 17.75           C  
ATOM   1281  CG1 VAL A 173     -15.507  32.501 172.801  1.00 19.29           C  
ATOM   1282  CG2 VAL A 173     -16.184  32.676 170.403  1.00 18.16           C  
ATOM   1283  N   GLY A 174     -12.388  31.563 172.713  1.00 15.88           N  
ATOM   1284  CA  GLY A 174     -11.505  31.017 173.738  1.00 16.70           C  
ATOM   1285  C   GLY A 174     -10.275  30.349 173.153  1.00 16.17           C  
ATOM   1286  O   GLY A 174      -9.370  29.959 173.895  1.00 16.57           O  
ATOM   1287  N   GLY A 175     -10.241  30.227 171.828  1.00 14.91           N  
ATOM   1288  CA  GLY A 175      -9.080  29.658 171.131  1.00 14.29           C  
ATOM   1289  C   GLY A 175      -7.938  30.665 171.042  1.00 12.57           C  
ATOM   1290  O   GLY A 175      -8.078  31.855 171.366  1.00 13.28           O  
ATOM   1291  N   ILE A 176      -6.796  30.187 170.556  1.00 12.06           N  
ATOM   1292  CA  ILE A 176      -5.555  30.977 170.549  1.00 12.22           C  
ATOM   1293  C   ILE A 176      -5.015  31.169 169.132  1.00 12.52           C  
ATOM   1294  O   ILE A 176      -5.029  30.243 168.323  1.00 12.31           O  
ATOM   1295  CB  ILE A 176      -4.493  30.259 171.382  1.00 13.19           C  
ATOM   1296  CG1 ILE A 176      -4.932  30.178 172.849  1.00 16.79           C  
ATOM   1297  CG2 ILE A 176      -3.149  30.998 171.299  1.00 13.09           C  
ATOM   1298  CD1 ILE A 176      -6.249  29.532 173.083  1.00 19.95           C  
ATOM   1299  N   VAL A 177      -4.563  32.381 168.831  1.00 12.15           N  
ATOM   1300  CA  VAL A 177      -3.837  32.642 167.590  1.00 11.38           C  
ATOM   1301  C   VAL A 177      -2.522  33.272 167.989  1.00 10.70           C  
ATOM   1302  O   VAL A 177      -2.511  34.246 168.761  1.00 10.27           O  
ATOM   1303  CB  VAL A 177      -4.582  33.606 166.628  1.00 13.63           C  
ATOM   1304  CG1 VAL A 177      -3.857  33.660 165.280  1.00 13.61           C  
ATOM   1305  CG2 VAL A 177      -6.040  33.181 166.455  1.00 14.94           C  
ATOM   1306  N   ALA A 178      -1.421  32.711 167.492  1.00 11.14           N  
ATOM   1307  CA  ALA A 178      -0.101  33.280 167.768  1.00  9.95           C  
ATOM   1308  C   ALA A 178       0.526  33.757 166.466  1.00 10.58           C  
ATOM   1309  O   ALA A 178       0.317  33.127 165.420  1.00 10.82           O  
ATOM   1310  CB  ALA A 178       0.790  32.270 168.463  1.00 11.49           C  
ATOM   1311  N   TYR A 179       1.303  34.848 166.551  1.00  9.64           N  
ATOM   1312  CA  TYR A 179       1.993  35.470 165.417  1.00 10.72           C  
ATOM   1313  C   TYR A 179       3.468  35.529 165.765  1.00 10.39           C  
ATOM   1314  O   TYR A 179       3.826  36.033 166.822  1.00 10.89           O  
ATOM   1315  CB  TYR A 179       1.485  36.903 165.183  1.00 11.32           C  
ATOM   1316  CG  TYR A 179       0.049  36.905 164.738  1.00 10.31           C  
ATOM   1317  CD1 TYR A 179      -0.266  36.871 163.384  1.00 12.34           C  
ATOM   1318  CD2 TYR A 179      -0.997  36.889 165.658  1.00 11.97           C  
ATOM   1319  CE1 TYR A 179      -1.588  36.832 162.948  1.00 13.48           C  
ATOM   1320  CE2 TYR A 179      -2.328  36.849 165.225  1.00 12.53           C  
ATOM   1321  CZ  TYR A 179      -2.610  36.807 163.858  1.00 12.34           C  
ATOM   1322  OH  TYR A 179      -3.922  36.720 163.383  1.00 13.97           O  
ATOM   1323  N   ASP A 180       4.313  35.037 164.861  1.00  9.50           N  
ATOM   1324  CA  ASP A 180       5.761  35.072 165.086  1.00  9.72           C  
ATOM   1325  C   ASP A 180       6.419  36.285 164.415  1.00 10.35           C  
ATOM   1326  O   ASP A 180       5.873  36.861 163.481  1.00 11.30           O  
ATOM   1327  CB  ASP A 180       6.409  33.789 164.562  1.00 10.48           C  
ATOM   1328  CG  ASP A 180       7.776  33.549 165.152  1.00 11.07           C  
ATOM   1329  OD1 ASP A 180       7.987  33.964 166.321  1.00 11.62           O  
ATOM   1330  OD2 ASP A 180       8.603  32.929 164.440  1.00 11.67           O  
ATOM   1331  N   ASN A 181       7.613  36.637 164.898  1.00 10.30           N  
ATOM   1332  CA  ASN A 181       8.433  37.750 164.373  1.00 11.38           C  
ATOM   1333  C   ASN A 181       7.806  39.104 164.658  1.00 11.82           C  
ATOM   1334  O   ASN A 181       8.039  40.068 163.935  1.00 11.93           O  
ATOM   1335  CB  ASN A 181       8.673  37.571 162.877  1.00 12.20           C  
ATOM   1336  CG  ASN A 181       9.367  36.264 162.560  1.00 12.72           C  
ATOM   1337  OD1 ASN A 181       8.723  35.264 162.220  1.00 13.05           O  
ATOM   1338  ND2 ASN A 181      10.690  36.250 162.705  1.00 13.33           N  
ATOM   1339  N   THR A 182       7.037  39.191 165.736  1.00 11.82           N  
ATOM   1340  CA  THR A 182       6.363  40.458 166.058  1.00 11.57           C  
ATOM   1341  C   THR A 182       7.299  41.517 166.661  1.00 12.30           C  
ATOM   1342  O   THR A 182       6.829  42.586 167.048  1.00 12.85           O  
ATOM   1343  CB  THR A 182       5.150  40.245 166.943  1.00 12.32           C  
ATOM   1344  OG1 THR A 182       5.556  39.548 168.123  1.00 12.37           O  
ATOM   1345  CG2 THR A 182       4.060  39.443 166.210  1.00 13.29           C  
ATOM   1346  N   LEU A 183       8.604  41.253 166.702  1.00 12.59           N  
ATOM   1347  CA  LEU A 183       9.544  42.334 167.001  1.00 12.86           C  
ATOM   1348  C   LEU A 183      10.536  42.625 165.853  1.00 12.81           C  
ATOM   1349  O   LEU A 183      11.377  43.530 165.954  1.00 13.10           O  
ATOM   1350  CB  LEU A 183      10.280  42.103 168.327  1.00 13.50           C  
ATOM   1351  CG  LEU A 183       9.368  42.132 169.551  1.00 13.50           C  
ATOM   1352  CD1 LEU A 183      10.105  41.615 170.763  1.00 13.56           C  
ATOM   1353  CD2 LEU A 183       8.754  43.508 169.823  1.00 14.72           C  
ATOM   1354  N   TRP A 184      10.402  41.884 164.758  1.00 13.71           N  
ATOM   1355  CA  TRP A 184      11.217  42.035 163.544  1.00 14.15           C  
ATOM   1356  C   TRP A 184      12.656  42.520 163.788  1.00 14.35           C  
ATOM   1357  O   TRP A 184      13.047  43.626 163.395  1.00 15.83           O  
ATOM   1358  CB  TRP A 184      10.492  42.867 162.461  1.00 15.00           C  
ATOM   1359  CG  TRP A 184      11.081  42.639 161.116  1.00 16.04           C  
ATOM   1360  CD1 TRP A 184      11.723  43.557 160.324  1.00 17.89           C  
ATOM   1361  CD2 TRP A 184      11.159  41.391 160.425  1.00 16.99           C  
ATOM   1362  NE1 TRP A 184      12.179  42.953 159.174  1.00 18.18           N  
ATOM   1363  CE2 TRP A 184      11.862  41.620 159.219  1.00 18.24           C  
ATOM   1364  CE3 TRP A 184      10.708  40.097 160.707  1.00 17.43           C  
ATOM   1365  CZ2 TRP A 184      12.085  40.610 158.285  1.00 18.96           C  
ATOM   1366  CZ3 TRP A 184      10.952  39.094 159.787  1.00 18.49           C  
ATOM   1367  CH2 TRP A 184      11.645  39.353 158.595  1.00 19.00           C  
ATOM   1368  N   GLY A 185      13.444  41.673 164.450  1.00 14.86           N  
ATOM   1369  CA  GLY A 185      14.870  41.951 164.611  1.00 15.02           C  
ATOM   1370  C   GLY A 185      15.137  43.108 165.555  1.00 15.92           C  
ATOM   1371  O   GLY A 185      16.266  43.603 165.634  1.00 16.85           O  
ATOM   1372  N   GLY A 186      14.110  43.538 166.281  1.00 14.55           N  
ATOM   1373  CA  GLY A 186      14.194  44.719 167.154  1.00 15.24           C  
ATOM   1374  C   GLY A 186      13.927  46.020 166.408  1.00 15.80           C  
ATOM   1375  O   GLY A 186      13.848  47.086 167.025  1.00 16.88           O  
ATOM   1376  N   THR A 187      13.772  45.931 165.088  1.00 16.11           N  
ATOM   1377  CA  THR A 187      13.705  47.136 164.250  1.00 15.99           C  
ATOM   1378  C   THR A 187      12.428  47.937 164.462  1.00 16.35           C  
ATOM   1379  O   THR A 187      12.385  49.140 164.198  1.00 16.56           O  
ATOM   1380  CB  THR A 187      13.869  46.815 162.752  1.00 16.02           C  
ATOM   1381  OG1 THR A 187      12.755  46.040 162.295  1.00 15.95           O  
ATOM   1382  CG2 THR A 187      15.160  46.052 162.488  1.00 16.63           C  
ATOM   1383  N   VAL A 188      11.384  47.270 164.937  1.00 15.95           N  
ATOM   1384  CA  VAL A 188      10.119  47.935 165.175  1.00 16.06           C  
ATOM   1385  C   VAL A 188      10.264  49.063 166.197  1.00 15.70           C  
ATOM   1386  O   VAL A 188       9.441  49.965 166.242  1.00 15.79           O  
ATOM   1387  CB  VAL A 188       9.013  46.930 165.607  1.00 14.98           C  
ATOM   1388  CG1 VAL A 188       8.709  45.941 164.483  1.00 15.05           C  
ATOM   1389  CG2 VAL A 188       9.399  46.191 166.882  1.00 15.20           C  
ATOM   1390  N   ALA A 189      11.316  49.010 167.009  1.00 17.72           N  
ATOM   1391  CA  ALA A 189      11.491  49.981 168.080  1.00 18.74           C  
ATOM   1392  C   ALA A 189      12.551  51.007 167.721  1.00 20.41           C  
ATOM   1393  O   ALA A 189      12.864  51.875 168.533  1.00 22.10           O  
ATOM   1394  CB  ALA A 189      11.842  49.280 169.381  1.00 18.51           C  
ATOM   1395  N   GLN A 190      13.108  50.894 166.516  1.00 20.94           N  
ATOM   1396  CA  GLN A 190      14.179  51.794 166.067  1.00 22.67           C  
ATOM   1397  C   GLN A 190      13.601  52.802 165.095  1.00 24.22           C  
ATOM   1398  O   GLN A 190      12.672  52.480 164.352  1.00 23.89           O  
ATOM   1399  CB  GLN A 190      15.285  51.012 165.362  1.00 23.45           C  
ATOM   1400  CG  GLN A 190      16.157  50.187 166.281  1.00 24.07           C  
ATOM   1401  CD  GLN A 190      17.206  49.405 165.525  1.00 24.94           C  
ATOM   1402  OE1 GLN A 190      16.920  48.380 164.916  1.00 25.04           O  
ATOM   1403  NE2 GLN A 190      18.445  49.888 165.570  1.00 26.06           N  
ATOM   1404  N   PRO A 191      14.169  54.019 165.070  1.00 25.71           N  
ATOM   1405  CA  PRO A 191      13.802  54.976 164.045  1.00 26.63           C  
ATOM   1406  C   PRO A 191      14.206  54.413 162.691  1.00 27.00           C  
ATOM   1407  O   PRO A 191      15.244  53.774 162.573  1.00 27.29           O  
ATOM   1408  CB  PRO A 191      14.646  56.206 164.392  1.00 26.40           C  
ATOM   1409  CG  PRO A 191      15.794  55.684 165.157  1.00 26.67           C  
ATOM   1410  CD  PRO A 191      15.280  54.496 165.912  1.00 26.04           C  
ATOM   1411  N   GLU A 192      13.376  54.629 161.681  1.00 28.95           N  
ATOM   1412  CA  GLU A 192      13.598  54.004 160.384  1.00 29.41           C  
ATOM   1413  C   GLU A 192      14.989  54.276 159.801  1.00 30.23           C  
ATOM   1414  O   GLU A 192      15.528  53.456 159.062  1.00 30.35           O  
ATOM   1415  CB  GLU A 192      12.496  54.404 159.393  1.00 29.52           C  
ATOM   1416  CG  GLU A 192      12.280  53.383 158.292  1.00 28.61           C  
ATOM   1417  CD  GLU A 192      11.292  53.838 157.237  1.00 27.95           C  
ATOM   1418  OE1 GLU A 192      10.584  52.977 156.670  1.00 26.71           O  
ATOM   1419  OE2 GLU A 192      11.228  55.056 156.963  1.00 27.97           O  
ATOM   1420  N   SER A 193      15.579  55.418 160.149  1.00 30.95           N  
ATOM   1421  CA  SER A 193      16.897  55.784 159.626  1.00 31.42           C  
ATOM   1422  C   SER A 193      18.028  54.891 160.137  1.00 31.52           C  
ATOM   1423  O   SER A 193      19.104  54.844 159.543  1.00 32.42           O  
ATOM   1424  CB  SER A 193      17.206  57.255 159.928  1.00 31.87           C  
ATOM   1425  OG  SER A 193      16.958  57.567 161.286  1.00 32.16           O  
ATOM   1426  N   GLU A 194      17.776  54.170 161.227  1.00 30.56           N  
ATOM   1427  CA  GLU A 194      18.782  53.285 161.818  1.00 29.83           C  
ATOM   1428  C   GLU A 194      18.624  51.838 161.354  1.00 28.37           C  
ATOM   1429  O   GLU A 194      19.267  50.926 161.882  1.00 28.43           O  
ATOM   1430  CB  GLU A 194      18.690  53.340 163.346  1.00 30.25           C  
ATOM   1431  CG  GLU A 194      18.799  54.739 163.929  1.00 31.18           C  
ATOM   1432  CD  GLU A 194      18.977  54.715 165.341  0.00 36.87           C  
ATOM   1433  OE1 GLU A 194      19.532  53.758 165.927  0.00 37.75           O  
ATOM   1434  OE2 GLU A 194      18.462  55.682 165.942  0.00 37.95           O  
ATOM   1435  N   VAL A 195      17.772  51.627 160.358  1.00 27.40           N  
ATOM   1436  CA  VAL A 195      17.393  50.277 159.955  1.00 25.98           C  
ATOM   1437  C   VAL A 195      17.838  50.009 158.525  1.00 25.03           C  
ATOM   1438  O   VAL A 195      17.688  50.873 157.663  1.00 25.01           O  
ATOM   1439  CB  VAL A 195      15.854  50.093 160.073  1.00 25.73           C  
ATOM   1440  CG1 VAL A 195      15.397  48.778 159.432  1.00 25.25           C  
ATOM   1441  CG2 VAL A 195      15.412  50.186 161.538  1.00 25.43           C  
ATOM   1442  N   PRO A 196      18.403  48.820 158.265  1.00 23.88           N  
ATOM   1443  CA  PRO A 196      18.774  48.451 156.895  1.00 23.54           C  
ATOM   1444  C   PRO A 196      17.591  48.492 155.926  1.00 22.78           C  
ATOM   1445  O   PRO A 196      16.464  48.112 156.289  1.00 21.01           O  
ATOM   1446  CB  PRO A 196      19.273  47.011 157.035  1.00 23.98           C  
ATOM   1447  CG  PRO A 196      19.632  46.848 158.461  1.00 24.16           C  
ATOM   1448  CD  PRO A 196      18.770  47.781 159.247  1.00 24.47           C  
ATOM   1449  N   ASP A 197      17.851  48.915 154.694  1.00 23.89           N  
ATOM   1450  CA  ASP A 197      16.819  49.006 153.665  1.00 24.15           C  
ATOM   1451  C   ASP A 197      16.008  47.724 153.522  1.00 23.86           C  
ATOM   1452  O   ASP A 197      14.782  47.773 153.421  1.00 23.21           O  
ATOM   1453  CB  ASP A 197      17.431  49.387 152.316  1.00 25.91           C  
ATOM   1454  CG  ASP A 197      17.699  50.869 152.203  1.00 27.18           C  
ATOM   1455  OD1 ASP A 197      17.705  51.540 153.254  1.00 27.31           O  
ATOM   1456  OD2 ASP A 197      17.900  51.363 151.064  1.00 28.00           O  
ATOM   1457  N   PHE A 198      16.684  46.580 153.503  1.00 23.17           N  
ATOM   1458  CA  PHE A 198      15.989  45.315 153.259  1.00 23.95           C  
ATOM   1459  C   PHE A 198      15.054  44.933 154.404  1.00 23.06           C  
ATOM   1460  O   PHE A 198      14.195  44.073 154.224  1.00 23.09           O  
ATOM   1461  CB  PHE A 198      16.969  44.175 152.932  1.00 25.52           C  
ATOM   1462  CG  PHE A 198      17.892  43.821 154.058  1.00 26.74           C  
ATOM   1463  CD1 PHE A 198      17.500  42.930 155.046  1.00 27.59           C  
ATOM   1464  CD2 PHE A 198      19.164  44.370 154.126  1.00 28.07           C  
ATOM   1465  CE1 PHE A 198      18.354  42.593 156.085  1.00 28.10           C  
ATOM   1466  CE2 PHE A 198      20.023  44.046 155.165  1.00 28.39           C  
ATOM   1467  CZ  PHE A 198      19.614  43.158 156.145  1.00 28.19           C  
ATOM   1468  N   MET A 199      15.202  45.598 155.554  1.00 20.69           N  
ATOM   1469  CA  MET A 199      14.384  45.302 156.730  1.00 19.93           C  
ATOM   1470  C   MET A 199      13.153  46.210 156.838  1.00 18.89           C  
ATOM   1471  O   MET A 199      12.257  45.950 157.644  1.00 18.75           O  
ATOM   1472  CB  MET A 199      15.208  45.418 158.022  1.00 19.86           C  
ATOM   1473  CG  MET A 199      16.232  44.310 158.246  1.00 21.93           C  
ATOM   1474  SD  MET A 199      15.511  42.704 158.627  1.00 23.49           S  
ATOM   1475  CE  MET A 199      15.078  42.923 160.350  1.00 22.45           C  
ATOM   1476  N   LYS A 200      13.101  47.266 156.026  1.00 18.67           N  
ATOM   1477  CA  LYS A 200      12.092  48.310 156.224  1.00 18.40           C  
ATOM   1478  C   LYS A 200      10.639  47.921 155.922  1.00 18.43           C  
ATOM   1479  O   LYS A 200       9.742  48.394 156.602  1.00 18.09           O  
ATOM   1480  CB  LYS A 200      12.476  49.598 155.476  1.00 19.59           C  
ATOM   1481  CG  LYS A 200      13.655  50.325 156.104  1.00 20.18           C  
ATOM   1482  CD  LYS A 200      14.063  51.554 155.287  1.00 21.58           C  
ATOM   1483  CE  LYS A 200      15.327  52.176 155.874  1.00 22.59           C  
ATOM   1484  NZ  LYS A 200      15.903  53.249 154.998  1.00 24.12           N  
ATOM   1485  N   GLU A 201      10.412  47.078 154.919  1.00 18.42           N  
ATOM   1486  CA  GLU A 201       9.044  46.707 154.547  1.00 19.24           C  
ATOM   1487  C   GLU A 201       8.386  45.914 155.669  1.00 18.63           C  
ATOM   1488  O   GLU A 201       7.280  46.234 156.088  1.00 18.31           O  
ATOM   1489  CB  GLU A 201       9.000  45.895 153.249  1.00 20.75           C  
ATOM   1490  CG  GLU A 201       7.556  45.530 152.832  1.00 23.96           C  
ATOM   1491  CD  GLU A 201       7.479  44.710 151.549  1.00 25.83           C  
ATOM   1492  OE1 GLU A 201       8.451  44.736 150.770  1.00 26.96           O  
ATOM   1493  OE2 GLU A 201       6.440  44.035 151.326  1.00 27.67           O  
ATOM   1494  N   ASN A 202       9.082  44.888 156.162  1.00 18.05           N  
ATOM   1495  CA  ASN A 202       8.540  44.047 157.229  1.00 18.32           C  
ATOM   1496  C   ASN A 202       8.544  44.750 158.580  1.00 17.48           C  
ATOM   1497  O   ASN A 202       7.710  44.460 159.436  1.00 16.00           O  
ATOM   1498  CB  ASN A 202       9.284  42.718 157.312  1.00 19.27           C  
ATOM   1499  CG  ASN A 202       8.813  41.720 156.267  1.00 19.42           C  
ATOM   1500  OD1 ASN A 202       7.873  41.987 155.517  1.00 19.13           O  
ATOM   1501  ND2 ASN A 202       9.457  40.562 156.226  1.00 20.43           N  
ATOM   1502  N   ARG A 203       9.476  45.678 158.777  1.00 17.51           N  
ATOM   1503  CA  ARG A 203       9.436  46.496 159.990  1.00 17.03           C  
ATOM   1504  C   ARG A 203       8.088  47.208 160.066  1.00 16.22           C  
ATOM   1505  O   ARG A 203       7.411  47.185 161.099  1.00 15.59           O  
ATOM   1506  CB  ARG A 203      10.558  47.539 159.995  1.00 17.68           C  
ATOM   1507  CG  ARG A 203      10.419  48.565 161.103  1.00 17.69           C  
ATOM   1508  CD  ARG A 203      11.487  49.656 160.957  1.00 17.87           C  
ATOM   1509  NE  ARG A 203      11.335  50.724 161.945  1.00 19.27           N  
ATOM   1510  CZ  ARG A 203      10.474  51.733 161.827  1.00 19.13           C  
ATOM   1511  NH1 ARG A 203       9.679  51.812 160.770  1.00 19.40           N  
ATOM   1512  NH2 ARG A 203      10.396  52.651 162.780  1.00 19.98           N  
ATOM   1513  N   GLU A 204       7.703  47.862 158.965  1.00 16.60           N  
ATOM   1514  CA  GLU A 204       6.436  48.591 158.934  1.00 16.53           C  
ATOM   1515  C   GLU A 204       5.235  47.650 159.035  1.00 16.20           C  
ATOM   1516  O   GLU A 204       4.262  47.937 159.736  1.00 16.20           O  
ATOM   1517  CB  GLU A 204       6.338  49.435 157.657  1.00 17.60           C  
ATOM   1518  CG  GLU A 204       4.986  50.111 157.423  1.00 19.13           C  
ATOM   1519  CD  GLU A 204       4.637  51.156 158.472  1.00 20.25           C  
ATOM   1520  OE1 GLU A 204       5.477  51.460 159.347  1.00 20.71           O  
ATOM   1521  OE2 GLU A 204       3.501  51.672 158.430  1.00 21.14           O  
ATOM   1522  N   ALA A 205       5.311  46.520 158.338  1.00 15.50           N  
ATOM   1523  CA  ALA A 205       4.215  45.552 158.356  1.00 15.65           C  
ATOM   1524  C   ALA A 205       3.990  45.064 159.779  1.00 14.93           C  
ATOM   1525  O   ALA A 205       2.848  44.910 160.220  1.00 15.17           O  
ATOM   1526  CB  ALA A 205       4.509  44.395 157.444  1.00 15.60           C  
ATOM   1527  N   VAL A 206       5.075  44.819 160.506  1.00 14.43           N  
ATOM   1528  CA  VAL A 206       4.936  44.297 161.867  1.00 13.89           C  
ATOM   1529  C   VAL A 206       4.492  45.399 162.837  1.00 14.05           C  
ATOM   1530  O   VAL A 206       3.690  45.174 163.734  1.00 13.16           O  
ATOM   1531  CB  VAL A 206       6.240  43.608 162.342  1.00 14.02           C  
ATOM   1532  CG1 VAL A 206       6.183  43.305 163.835  1.00 14.21           C  
ATOM   1533  CG2 VAL A 206       6.480  42.320 161.554  1.00 15.38           C  
ATOM   1534  N   ILE A 207       4.975  46.616 162.624  1.00 13.73           N  
ATOM   1535  CA  ILE A 207       4.494  47.749 163.420  1.00 13.96           C  
ATOM   1536  C   ILE A 207       2.981  47.873 163.299  1.00 14.16           C  
ATOM   1537  O   ILE A 207       2.287  48.019 164.292  1.00 13.46           O  
ATOM   1538  CB  ILE A 207       5.182  49.077 163.018  1.00 14.54           C  
ATOM   1539  CG1 ILE A 207       6.610  49.100 163.566  1.00 14.99           C  
ATOM   1540  CG2 ILE A 207       4.355  50.283 163.480  1.00 15.13           C  
ATOM   1541  CD1 ILE A 207       7.443  50.288 163.048  1.00 15.74           C  
ATOM   1542  N   GLU A 208       2.472  47.819 162.073  1.00 14.70           N  
ATOM   1543  CA  GLU A 208       1.036  47.929 161.874  1.00 15.07           C  
ATOM   1544  C   GLU A 208       0.268  46.722 162.431  1.00 15.01           C  
ATOM   1545  O   GLU A 208      -0.809  46.873 162.992  1.00 15.66           O  
ATOM   1546  CB  GLU A 208       0.725  48.150 160.393  1.00 17.30           C  
ATOM   1547  CG  GLU A 208       1.194  49.510 159.892  1.00 18.84           C  
ATOM   1548  CD  GLU A 208       0.499  50.654 160.602  1.00 20.27           C  
ATOM   1549  OE1 GLU A 208       1.099  51.736 160.722  1.00 21.35           O  
ATOM   1550  OE2 GLU A 208      -0.652  50.475 161.054  1.00 20.86           O  
ATOM   1551  N   LEU A 209       0.831  45.529 162.290  1.00 15.28           N  
ATOM   1552  CA  LEU A 209       0.176  44.361 162.851  1.00 13.72           C  
ATOM   1553  C   LEU A 209       0.086  44.503 164.375  1.00 13.21           C  
ATOM   1554  O   LEU A 209      -0.949  44.233 164.983  1.00 13.29           O  
ATOM   1555  CB  LEU A 209       0.964  43.095 162.469  1.00 14.58           C  
ATOM   1556  CG  LEU A 209       0.452  41.726 162.950  1.00 13.05           C  
ATOM   1557  CD1 LEU A 209       0.982  41.361 164.352  1.00 14.30           C  
ATOM   1558  CD2 LEU A 209      -1.087  41.548 162.834  1.00 12.88           C  
ATOM   1559  N   ASN A 210       1.177  44.911 165.004  1.00 12.17           N  
ATOM   1560  CA  ASN A 210       1.170  45.047 166.455  1.00 11.63           C  
ATOM   1561  C   ASN A 210       0.134  46.071 166.928  1.00 12.88           C  
ATOM   1562  O   ASN A 210      -0.549  45.861 167.931  1.00 13.76           O  
ATOM   1563  CB  ASN A 210       2.565  45.434 166.941  1.00 11.53           C  
ATOM   1564  CG  ASN A 210       3.586  44.315 166.752  1.00 12.58           C  
ATOM   1565  OD1 ASN A 210       3.232  43.161 166.513  1.00 13.66           O  
ATOM   1566  ND2 ASN A 210       4.868  44.661 166.868  1.00 12.64           N  
ATOM   1567  N   LYS A 211       0.018  47.189 166.202  1.00 14.42           N  
ATOM   1568  CA  LYS A 211      -0.995  48.193 166.527  1.00 14.72           C  
ATOM   1569  C   LYS A 211      -2.394  47.633 166.405  1.00 15.22           C  
ATOM   1570  O   LYS A 211      -3.251  47.886 167.259  1.00 14.57           O  
ATOM   1571  CB  LYS A 211      -0.840  49.416 165.615  1.00 16.83           C  
ATOM   1572  CG  LYS A 211       0.375  50.272 165.974  1.00 18.40           C  
ATOM   1573  CD  LYS A 211       0.355  51.628 165.286  1.00 21.18           C  
ATOM   1574  CE  LYS A 211       0.671  51.509 163.836  1.00 21.70           C  
ATOM   1575  NZ  LYS A 211       0.516  52.859 163.155  1.00 22.85           N  
ATOM   1576  N   LEU A 212      -2.617  46.844 165.357  1.00 14.95           N  
ATOM   1577  CA  LEU A 212      -3.935  46.265 165.150  1.00 16.14           C  
ATOM   1578  C   LEU A 212      -4.297  45.295 166.280  1.00 15.42           C  
ATOM   1579  O   LEU A 212      -5.357  45.396 166.871  1.00 15.96           O  
ATOM   1580  CB  LEU A 212      -4.047  45.593 163.777  1.00 17.43           C  
ATOM   1581  CG  LEU A 212      -5.467  45.166 163.422  1.00 18.81           C  
ATOM   1582  CD1 LEU A 212      -5.724  45.348 161.938  1.00 19.49           C  
ATOM   1583  CD2 LEU A 212      -5.669  43.743 163.877  1.00 19.96           C  
ATOM   1584  N   LEU A 213      -3.411  44.354 166.584  1.00 14.45           N  
ATOM   1585  CA  LEU A 213      -3.659  43.426 167.669  1.00 14.40           C  
ATOM   1586  C   LEU A 213      -3.862  44.122 169.010  1.00 14.78           C  
ATOM   1587  O   LEU A 213      -4.753  43.756 169.764  1.00 14.74           O  
ATOM   1588  CB  LEU A 213      -2.534  42.399 167.775  1.00 13.79           C  
ATOM   1589  CG  LEU A 213      -2.293  41.505 166.561  1.00 12.28           C  
ATOM   1590  CD1 LEU A 213      -1.160  40.540 166.916  1.00 12.23           C  
ATOM   1591  CD2 LEU A 213      -3.581  40.752 166.180  1.00 13.18           C  
ATOM   1592  N   ALA A 214      -3.039  45.127 169.304  1.00 14.31           N  
ATOM   1593  CA  ALA A 214      -3.176  45.872 170.573  1.00 14.66           C  
ATOM   1594  C   ALA A 214      -4.531  46.540 170.744  1.00 15.93           C  
ATOM   1595  O   ALA A 214      -5.021  46.679 171.874  1.00 17.04           O  
ATOM   1596  CB  ALA A 214      -2.092  46.897 170.716  1.00 14.62           C  
ATOM   1597  N   ALA A 215      -5.134  46.949 169.630  1.00 16.45           N  
ATOM   1598  CA  ALA A 215      -6.374  47.727 169.681  1.00 17.09           C  
ATOM   1599  C   ALA A 215      -7.619  46.887 169.420  1.00 17.54           C  
ATOM   1600  O   ALA A 215      -8.723  47.400 169.495  1.00 17.95           O  
ATOM   1601  CB  ALA A 215      -6.319  48.890 168.703  1.00 18.49           C  
ATOM   1602  N   ASP A 216      -7.435  45.598 169.126  1.00 16.40           N  
ATOM   1603  CA  ASP A 216      -8.528  44.727 168.731  1.00 16.15           C  
ATOM   1604  C   ASP A 216      -9.335  44.281 169.950  1.00 16.22           C  
ATOM   1605  O   ASP A 216      -8.858  43.494 170.763  1.00 16.67           O  
ATOM   1606  CB  ASP A 216      -7.955  43.515 167.968  1.00 15.96           C  
ATOM   1607  CG  ASP A 216      -9.031  42.621 167.368  1.00 16.44           C  
ATOM   1608  OD1 ASP A 216     -10.236  42.778 167.675  1.00 17.59           O  
ATOM   1609  OD2 ASP A 216      -8.653  41.735 166.578  1.00 17.31           O  
ATOM   1610  N   PRO A 217     -10.592  44.752 170.072  1.00 17.05           N  
ATOM   1611  CA  PRO A 217     -11.398  44.381 171.237  1.00 17.34           C  
ATOM   1612  C   PRO A 217     -11.807  42.899 171.288  1.00 16.67           C  
ATOM   1613  O   PRO A 217     -12.242  42.418 172.340  1.00 17.33           O  
ATOM   1614  CB  PRO A 217     -12.635  45.291 171.117  1.00 18.59           C  
ATOM   1615  CG  PRO A 217     -12.744  45.599 169.661  1.00 18.92           C  
ATOM   1616  CD  PRO A 217     -11.322  45.632 169.142  1.00 17.68           C  
ATOM   1617  N   ARG A 218     -11.645  42.181 170.174  1.00 16.30           N  
ATOM   1618  CA  ARG A 218     -12.070  40.787 170.097  1.00 16.17           C  
ATOM   1619  C   ARG A 218     -11.081  39.826 170.754  1.00 16.05           C  
ATOM   1620  O   ARG A 218     -11.383  38.646 170.880  1.00 14.86           O  
ATOM   1621  CB  ARG A 218     -12.251  40.339 168.642  1.00 17.16           C  
ATOM   1622  CG  ARG A 218     -13.311  41.099 167.848  1.00 18.11           C  
ATOM   1623  CD  ARG A 218     -13.203  40.780 166.353  1.00 18.92           C  
ATOM   1624  NE  ARG A 218     -11.885  41.152 165.832  1.00 19.13           N  
ATOM   1625  CZ  ARG A 218     -11.453  40.867 164.607  1.00 19.47           C  
ATOM   1626  NH1 ARG A 218     -12.245  40.218 163.759  1.00 19.98           N  
ATOM   1627  NH2 ARG A 218     -10.232  41.234 164.230  1.00 19.00           N  
ATOM   1628  N   ILE A 219      -9.919  40.323 171.168  1.00 14.98           N  
ATOM   1629  CA  ILE A 219      -8.885  39.457 171.723  1.00 15.88           C  
ATOM   1630  C   ILE A 219      -8.230  40.033 172.970  1.00 15.61           C  
ATOM   1631  O   ILE A 219      -8.258  41.244 173.197  1.00 16.33           O  
ATOM   1632  CB  ILE A 219      -7.749  39.189 170.698  1.00 15.15           C  
ATOM   1633  CG1 ILE A 219      -7.018  40.495 170.336  1.00 14.45           C  
ATOM   1634  CG2 ILE A 219      -8.261  38.434 169.472  1.00 14.97           C  
ATOM   1635  CD1 ILE A 219      -6.045  40.418 169.158  1.00 14.84           C  
ATOM   1636  N   GLU A 220      -7.647  39.132 173.752  1.00 15.24           N  
ATOM   1637  CA  GLU A 220      -6.680  39.479 174.796  1.00 15.50           C  
ATOM   1638  C   GLU A 220      -5.316  39.040 174.258  1.00 15.05           C  
ATOM   1639  O   GLU A 220      -5.219  38.029 173.588  1.00 15.39           O  
ATOM   1640  CB  GLU A 220      -7.005  38.722 176.093  1.00 17.98           C  
ATOM   1641  CG  GLU A 220      -8.351  39.135 176.722  1.00 21.43           C  
ATOM   1642  CD  GLU A 220      -8.810  38.262 177.898  1.00 24.34           C  
ATOM   1643  OE1 GLU A 220      -8.617  37.025 177.883  1.00 26.14           O  
ATOM   1644  OE2 GLU A 220      -9.409  38.826 178.838  1.00 25.81           O  
ATOM   1645  N   ILE A 221      -4.263  39.783 174.552  1.00 14.72           N  
ATOM   1646  CA  ILE A 221      -2.953  39.484 173.981  1.00 14.24           C  
ATOM   1647  C   ILE A 221      -1.835  39.429 175.001  1.00 13.51           C  
ATOM   1648  O   ILE A 221      -1.971  39.940 176.122  1.00 14.04           O  
ATOM   1649  CB  ILE A 221      -2.549  40.497 172.885  1.00 14.43           C  
ATOM   1650  CG1 ILE A 221      -2.234  41.870 173.485  1.00 15.45           C  
ATOM   1651  CG2 ILE A 221      -3.607  40.583 171.799  1.00 13.78           C  
ATOM   1652  CD1 ILE A 221      -1.761  42.865 172.485  1.00 16.96           C  
ATOM   1653  N   VAL A 222      -0.733  38.798 174.593  1.00 12.86           N  
ATOM   1654  CA  VAL A 222       0.539  38.944 175.275  1.00 12.66           C  
ATOM   1655  C   VAL A 222       1.655  38.965 174.222  1.00 11.77           C  
ATOM   1656  O   VAL A 222       1.724  38.095 173.371  1.00 11.37           O  
ATOM   1657  CB  VAL A 222       0.787  37.872 176.376  1.00 13.72           C  
ATOM   1658  CG1 VAL A 222       0.887  36.476 175.792  1.00 14.74           C  
ATOM   1659  CG2 VAL A 222       2.045  38.213 177.130  1.00 14.89           C  
ATOM   1660  N   HIS A 223       2.479  40.007 174.271  1.00 12.54           N  
ATOM   1661  CA  HIS A 223       3.501  40.330 173.266  1.00 12.84           C  
ATOM   1662  C   HIS A 223       4.857  40.081 173.906  1.00 13.53           C  
ATOM   1663  O   HIS A 223       5.288  40.845 174.768  1.00 13.78           O  
ATOM   1664  CB  HIS A 223       3.332  41.807 172.913  1.00 14.33           C  
ATOM   1665  CG  HIS A 223       4.095  42.280 171.709  1.00 16.21           C  
ATOM   1666  ND1 HIS A 223       4.944  41.486 170.972  1.00 17.64           N  
ATOM   1667  CD2 HIS A 223       4.130  43.505 171.131  1.00 15.84           C  
ATOM   1668  CE1 HIS A 223       5.447  42.196 169.975  1.00 17.28           C  
ATOM   1669  NE2 HIS A 223       4.965  43.422 170.048  1.00 18.49           N  
ATOM   1670  N   LEU A 224       5.532  39.024 173.477  1.00 12.98           N  
ATOM   1671  CA  LEU A 224       6.708  38.523 174.202  1.00 12.64           C  
ATOM   1672  C   LEU A 224       8.014  38.537 173.428  1.00 12.63           C  
ATOM   1673  O   LEU A 224       8.069  38.126 172.273  1.00 11.78           O  
ATOM   1674  CB  LEU A 224       6.451  37.094 174.645  1.00 13.94           C  
ATOM   1675  CG  LEU A 224       5.191  36.945 175.486  1.00 14.58           C  
ATOM   1676  CD1 LEU A 224       4.788  35.492 175.647  1.00 17.20           C  
ATOM   1677  CD2 LEU A 224       5.333  37.670 176.833  1.00 15.75           C  
ATOM   1678  N   PRO A 225       9.092  38.974 174.085  1.00 11.96           N  
ATOM   1679  CA  PRO A 225      10.402  38.980 173.421  1.00 12.38           C  
ATOM   1680  C   PRO A 225      11.101  37.620 173.470  1.00 12.55           C  
ATOM   1681  O   PRO A 225      12.161  37.473 174.090  1.00 14.06           O  
ATOM   1682  CB  PRO A 225      11.180  40.049 174.200  1.00 12.43           C  
ATOM   1683  CG  PRO A 225      10.623  39.912 175.600  1.00 11.57           C  
ATOM   1684  CD  PRO A 225       9.141  39.588 175.424  1.00 11.63           C  
ATOM   1685  N   LEU A 226      10.476  36.631 172.825  1.00 12.77           N  
ATOM   1686  CA  LEU A 226      11.063  35.300 172.674  1.00 11.99           C  
ATOM   1687  C   LEU A 226      11.432  35.143 171.216  1.00 11.96           C  
ATOM   1688  O   LEU A 226      10.592  35.343 170.336  1.00 11.88           O  
ATOM   1689  CB  LEU A 226      10.039  34.217 173.045  1.00 11.16           C  
ATOM   1690  CG  LEU A 226       9.265  34.378 174.348  1.00 11.64           C  
ATOM   1691  CD1 LEU A 226       8.396  33.153 174.562  1.00 12.81           C  
ATOM   1692  CD2 LEU A 226      10.253  34.567 175.498  1.00 13.25           C  
ATOM   1693  N   GLY A 227      12.676  34.756 170.957  1.00 12.78           N  
ATOM   1694  CA  GLY A 227      13.134  34.616 169.581  1.00 13.16           C  
ATOM   1695  C   GLY A 227      13.146  35.960 168.878  1.00 13.87           C  
ATOM   1696  O   GLY A 227      13.902  36.845 169.251  1.00 16.30           O  
ATOM   1697  N   ASP A 228      12.296  36.114 167.874  1.00 13.59           N  
ATOM   1698  CA  ASP A 228      12.166  37.373 167.168  1.00 13.42           C  
ATOM   1699  C   ASP A 228      10.880  38.114 167.558  1.00 11.68           C  
ATOM   1700  O   ASP A 228      10.403  38.955 166.821  1.00 12.46           O  
ATOM   1701  CB  ASP A 228      12.217  37.137 165.661  1.00 14.73           C  
ATOM   1702  CG  ASP A 228      12.462  38.410 164.882  1.00 14.70           C  
ATOM   1703  OD1 ASP A 228      13.297  39.229 165.347  1.00 15.08           O  
ATOM   1704  OD2 ASP A 228      11.871  38.582 163.792  1.00 14.70           O  
ATOM   1705  N   GLY A 229      10.345  37.791 168.728  1.00 11.57           N  
ATOM   1706  CA  GLY A 229       9.061  38.321 169.179  1.00 11.26           C  
ATOM   1707  C   GLY A 229       7.934  37.367 168.788  1.00 10.23           C  
ATOM   1708  O   GLY A 229       7.855  36.937 167.634  1.00 10.68           O  
ATOM   1709  N   ILE A 230       7.063  37.019 169.737  1.00 10.01           N  
ATOM   1710  CA  ILE A 230       5.871  36.221 169.433  1.00 10.34           C  
ATOM   1711  C   ILE A 230       4.708  36.780 170.239  1.00 10.06           C  
ATOM   1712  O   ILE A 230       4.874  37.133 171.417  1.00 10.52           O  
ATOM   1713  CB  ILE A 230       6.122  34.707 169.704  1.00 10.64           C  
ATOM   1714  CG1 ILE A 230       4.906  33.853 169.318  1.00 10.69           C  
ATOM   1715  CG2 ILE A 230       6.527  34.445 171.161  1.00 11.24           C  
ATOM   1716  CD1 ILE A 230       5.237  32.360 169.206  1.00 10.75           C  
ATOM   1717  N   THR A 231       3.556  36.910 169.583  1.00  9.92           N  
ATOM   1718  CA  THR A 231       2.366  37.430 170.241  1.00  9.75           C  
ATOM   1719  C   THR A 231       1.276  36.365 170.259  1.00  9.35           C  
ATOM   1720  O   THR A 231       0.917  35.815 169.213  1.00 10.36           O  
ATOM   1721  CB  THR A 231       1.844  38.668 169.518  1.00  9.64           C  
ATOM   1722  OG1 THR A 231       2.904  39.631 169.477  1.00 10.87           O  
ATOM   1723  CG2 THR A 231       0.615  39.249 170.229  1.00 11.66           C  
ATOM   1724  N   PHE A 232       0.787  36.045 171.454  1.00  9.40           N  
ATOM   1725  CA  PHE A 232      -0.327  35.120 171.598  1.00  9.21           C  
ATOM   1726  C   PHE A 232      -1.605  35.910 171.842  1.00  9.72           C  
ATOM   1727  O   PHE A 232      -1.613  36.852 172.639  1.00 11.16           O  
ATOM   1728  CB  PHE A 232      -0.101  34.192 172.782  1.00  9.67           C  
ATOM   1729  CG  PHE A 232       0.960  33.145 172.545  1.00 10.35           C  
ATOM   1730  CD1 PHE A 232       2.306  33.467 172.587  1.00 11.04           C  
ATOM   1731  CD2 PHE A 232       0.601  31.830 172.321  1.00 11.79           C  
ATOM   1732  CE1 PHE A 232       3.270  32.498 172.388  1.00 11.91           C  
ATOM   1733  CE2 PHE A 232       1.560  30.864 172.112  1.00 11.00           C  
ATOM   1734  CZ  PHE A 232       2.898  31.187 172.162  1.00 10.96           C  
ATOM   1735  N   CYS A 233      -2.687  35.496 171.184  1.00 11.62           N  
ATOM   1736  CA  CYS A 233      -3.993  36.132 171.301  1.00 12.19           C  
ATOM   1737  C   CYS A 233      -5.020  35.097 171.704  1.00 12.69           C  
ATOM   1738  O   CYS A 233      -4.974  33.946 171.230  1.00 12.63           O  
ATOM   1739  CB  CYS A 233      -4.429  36.674 169.937  1.00 12.40           C  
ATOM   1740  SG  CYS A 233      -3.180  37.715 169.098  1.00 13.59           S  
ATOM   1741  N   ARG A 234      -5.966  35.490 172.559  0.50 12.54           N  
ATOM   1743  CA  ARG A 234      -7.099  34.621 172.885  0.50 14.11           C  
ATOM   1745  C   ARG A 234      -8.387  35.295 172.437  0.50 13.84           C  
ATOM   1747  O   ARG A 234      -8.657  36.426 172.823  0.50 13.60           O  
ATOM   1749  CB  ARG A 234      -7.153  34.325 174.387  0.50 15.86           C  
ATOM   1751  CG  ARG A 234      -8.034  33.123 174.759  0.50 18.17           C  
ATOM   1753  CD  ARG A 234      -7.964  32.845 176.244  0.50 20.33           C  
ATOM   1755  NE  ARG A 234      -8.484  33.970 177.014  0.50 21.58           N  
ATOM   1757  CZ  ARG A 234      -9.708  34.030 177.526  0.50 22.94           C  
ATOM   1759  NH1 ARG A 234     -10.553  33.021 177.362  0.50 23.47           N  
ATOM   1761  NH2 ARG A 234     -10.088  35.104 178.205  0.50 23.55           N  
ATOM   1763  N   ARG A 235      -9.166  34.595 171.614  1.00 13.49           N  
ATOM   1764  CA  ARG A 235     -10.410  35.136 171.078  1.00 14.54           C  
ATOM   1765  C   ARG A 235     -11.467  35.217 172.172  1.00 15.51           C  
ATOM   1766  O   ARG A 235     -11.789  34.209 172.794  1.00 15.10           O  
ATOM   1767  CB  ARG A 235     -10.912  34.265 169.911  1.00 14.34           C  
ATOM   1768  CG  ARG A 235     -12.236  34.776 169.373  1.00 15.61           C  
ATOM   1769  CD  ARG A 235     -12.722  34.042 168.135  1.00 15.90           C  
ATOM   1770  NE  ARG A 235     -14.104  34.442 167.857  1.00 17.52           N  
ATOM   1771  CZ  ARG A 235     -14.978  33.745 167.141  1.00 18.39           C  
ATOM   1772  NH1 ARG A 235     -14.649  32.572 166.594  1.00 17.60           N  
ATOM   1773  NH2 ARG A 235     -16.198  34.247 166.978  1.00 18.63           N  
ATOM   1774  N   LEU A 236     -12.036  36.409 172.359  1.00 17.52           N  
ATOM   1775  CA  LEU A 236     -12.994  36.671 173.448  1.00 19.19           C  
ATOM   1776  C   LEU A 236     -14.448  36.398 173.077  1.00 20.07           C  
ATOM   1777  O   LEU A 236     -15.240  35.962 173.917  1.00 20.62           O  
ATOM   1778  CB  LEU A 236     -12.856  38.120 173.928  1.00 20.22           C  
ATOM   1779  CG  LEU A 236     -11.501  38.513 174.517  1.00 20.83           C  
ATOM   1780  CD1 LEU A 236     -11.501  39.965 174.938  1.00 21.59           C  
ATOM   1781  CD2 LEU A 236     -11.171  37.608 175.696  1.00 21.65           C  
ATOM   1782  N   TYR A 237     -14.797  36.712 171.838  1.00 19.86           N  
ATOM   1783  CA  TYR A 237     -16.135  36.452 171.318  1.00 20.40           C  
ATOM   1784  C   TYR A 237     -16.049  36.431 169.805  1.00 21.12           C  
ATOM   1785  O   TYR A 237     -14.981  36.732 169.238  1.00 20.52           O  
ATOM   1786  CB  TYR A 237     -17.105  37.546 171.772  1.00 21.00           C  
ATOM   1787  CG  TYR A 237     -16.661  38.927 171.373  1.00 21.11           C  
ATOM   1788  CD1 TYR A 237     -17.062  39.488 170.164  1.00 21.91           C  
ATOM   1789  CD2 TYR A 237     -15.844  39.677 172.205  1.00 21.02           C  
ATOM   1790  CE1 TYR A 237     -16.652  40.752 169.795  1.00 22.08           C  
ATOM   1791  CE2 TYR A 237     -15.426  40.943 171.840  1.00 21.15           C  
ATOM   1792  CZ  TYR A 237     -15.837  41.473 170.637  1.00 22.56           C  
ATOM   1793  OH  TYR A 237     -15.428  42.732 170.279  1.00 24.42           O  
ATOM   1794  OXT TYR A 237     -17.037  36.118 169.131  1.00 21.22           O  
TER    1795      TYR A 237                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
