
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 ( 1459),  selected   95 , name 1ozo_A
# Molecule2: number of CA atoms   69 (  546),  selected   69 , name T0510_166_234.pdb
# PARAMETERS: 1ozo_A.T0510_166_234.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      Q     166           -
LGA    T     2_A      H     167           -
LGA    E     3_A      K     168           -
LGA    L     4_A      I     169           -
LGA    E     5_A      N     170           -
LGA    A     6_A      P     171           -
LGA    -       -      Y     172           -
LGA    -       -      D     173           -
LGA    A     7_A      I     174           #
LGA    M     8_A      -       -           -
LGA    G     9_A      -       -           -
LGA    M    10_A      T     175          5.410
LGA    I    11_A      G     176          3.260
LGA    I    12_A      A     177          1.940
LGA    D    13_A      E     178          2.782
LGA    V    14_A      V     179          2.359
LGA    F    15_A      L     180          1.211
LGA    S    16_A      K     181          1.729
LGA    R    17_A      Y     182          2.590
LGA    Y    18_A      -       -           -
LGA    S    19_A      I     183          1.108
LGA    G    20_A      -       -           -
LGA    S    21_A      -       -           -
LGA    E    22_A      -       -           -
LGA    G    23_A      D     184          2.214
LGA    S    24_A      F     185          3.924
LGA    T    25_A      N     186          1.454
LGA    Q    26_A      A     187           -
LGA    T    27_A      G     188           #
LGA    L    28_A      N     189           #
LGA    T    29_A      I     190          1.729
LGA    K    30_A      A     191          1.922
LGA    G    31_A      K     192          1.813
LGA    E    32_A      Q     193          1.138
LGA    L    33_A      L     194          1.613
LGA    K    34_A      L     195          0.960
LGA    V    35_A      N     196          1.584
LGA    L    36_A      Q     197          2.601
LGA    M    37_A      F     198          2.562
LGA    E    38_A      E     199          1.418
LGA    K    39_A      -       -           -
LGA    E    40_A      -       -           -
LGA    L    41_A      -       -           -
LGA    P    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    F    44_A      -       -           -
LGA    L    45_A      G     200          4.069
LGA    Q    46_A      -       -           -
LGA    S    47_A      -       -           -
LGA    G    48_A      F     201          4.084
LGA    K    49_A      S     202          2.163
LGA    D    50_A      P     203          3.911
LGA    K    51_A      -       -           -
LGA    D    52_A      L     204          3.153
LGA    A    53_A      I     205          2.790
LGA    V    54_A      T     206          1.818
LGA    D    55_A      N     207          1.037
LGA    K    56_A      E     208          0.939
LGA    L    57_A      I     209          2.086
LGA    L    58_A      V     210          1.487
LGA    K    59_A      S     211          1.137
LGA    D    60_A      R     212          1.826
LGA    L    61_A      R     213          3.393
LGA    D    62_A      -       -           -
LGA    A    63_A      Q     214          1.804
LGA    N    64_A      -       -           -
LGA    G    65_A      F     215          1.046
LGA    D    66_A      -       -           -
LGA    A    67_A      -       -           -
LGA    Q    68_A      -       -           -
LGA    V    69_A      M     216          1.973
LGA    D    70_A      T     217          1.292
LGA    F    71_A      S     218          2.001
LGA    S    72_A      S     219          1.507
LGA    E    73_A      T     220          1.541
LGA    F    74_A      L     221          1.697
LGA    I    75_A      P     222          1.777
LGA    V    76_A      E     223          1.407
LGA    F    77_A      A     224          2.057
LGA    V    78_A      F     225          3.401
LGA    A    79_A      D     226          3.401
LGA    A    80_A      E     227          0.992
LGA    I    81_A      V     228          2.544
LGA    T    82_A      M     229          4.244
LGA    S    83_A      A     230          2.983
LGA    A    84_A      E     231          0.569
LGA    S    85_A      T     232          1.940
LGA    H    86_A      K     233          2.312
LGA    K    87_A      L     234          1.206
LGA    Y    88_A      -       -           -
LGA    F    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    T    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    L    94_A      -       -           -
LGA    K    95_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   69    5.0     57    2.38     7.02     59.723     2.300

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.804497 * X  +   0.419517 * Y  +  -0.420464 * Z  +  87.429237
  Y_new =   0.494015 * X  +   0.865619 * Y  +  -0.081558 * Z  + -17.083561
  Z_new =   0.329747 * X  +  -0.273329 * Y  +  -0.903636 * Z  +  92.100273 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.847865    0.293727  [ DEG:  -163.1707     16.8293 ]
  Theta =  -0.336036   -2.805557  [ DEG:   -19.2534   -160.7466 ]
  Phi   =   2.590894   -0.550699  [ DEG:   148.4473    -31.5527 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ozo_A                                        
REMARK     2: T0510_166_234.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ozo_A.T0510_166_234.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   69   5.0   57   2.38    7.02  59.723
REMARK  ---------------------------------------------------------- 
MOLECULE 1ozo_A
HEADER    METAL BINDING PROTEIN                   09-APR-03   1OZO              
TITLE     THREE-DIMENSIONAL SOLUTION STRUCTURE OF APO-S100P PROTEIN             
TITLE    2 DETERMINED BY NMR SPECTROSCOPY                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: S-100P PROTEIN;                                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: S100P OR S100E;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    EF-HAND, S100 PROTEIN                                                 
EXPDTA    NMR, 16 STRUCTURES                                                    
AUTHOR    Y.-C.LEE,D.E.VOLK,V.THIVIYANATHAN,Q.KLEEREKOPER,                      
AUTHOR   2 A.V.GRIBENKO,S.ZHANG,D.G.GORENSTEIN,G.I.MAKHATADZE,B.A.LUXON         
REVDAT   2   10-AUG-04 1OZO    1       JRNL                                     
REVDAT   1   20-APR-04 1OZO    0                                                
JRNL        AUTH   Y.-C.LEE,D.E.VOLK,V.THIVIYANATHAN,Q.KLEEREKOPER,             
JRNL        AUTH 2 A.V.GRIBENKO,S.ZHANG,D.G.GORENSTEIN,G.I.MAKHATADZE,          
JRNL        AUTH 3 B.A.LUXON                                                    
JRNL        TITL   NMR STRUCTURE OF THE APO-S100P PROTEIN.                      
JRNL        REF    J.BIOMOL.NMR                  V.  29   399 2004              
JRNL        REFN   ASTM JBNME9  NE ISSN 0925-2738                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1OZO A    1    95  UNP    P25815   S100P_HUMAN      1     95             
DBREF  1OZO B    1    95  UNP    P25815   S100P_HUMAN      1     95             
SEQRES   1 A   95  MET THR GLU LEU GLU ALA ALA MET GLY MET ILE ILE ASP          
SEQRES   2 A   95  VAL PHE SER ARG TYR SER GLY SER GLU GLY SER THR GLN          
SEQRES   3 A   95  THR LEU THR LYS GLY GLU LEU LYS VAL LEU MET GLU LYS          
SEQRES   4 A   95  GLU LEU PRO GLY PHE LEU GLN SER GLY LYS ASP LYS ASP          
SEQRES   5 A   95  ALA VAL ASP LYS LEU LEU LYS ASP LEU ASP ALA ASN GLY          
SEQRES   6 A   95  ASP ALA GLN VAL ASP PHE SER GLU PHE ILE VAL PHE VAL          
SEQRES   7 A   95  ALA ALA ILE THR SER ALA SER HIS LYS TYR PHE GLU LYS          
SEQRES   8 A   95  THR GLY LEU LYS                                              
SEQRES   1 B   95  MET THR GLU LEU GLU ALA ALA MET GLY MET ILE ILE ASP          
SEQRES   2 B   95  VAL PHE SER ARG TYR SER GLY SER GLU GLY SER THR GLN          
SEQRES   3 B   95  THR LEU THR LYS GLY GLU LEU LYS VAL LEU MET GLU LYS          
SEQRES   4 B   95  GLU LEU PRO GLY PHE LEU GLN SER GLY LYS ASP LYS ASP          
SEQRES   5 B   95  ALA VAL ASP LYS LEU LEU LYS ASP LEU ASP ALA ASN GLY          
SEQRES   6 B   95  ASP ALA GLN VAL ASP PHE SER GLU PHE ILE VAL PHE VAL          
SEQRES   7 B   95  ALA ALA ILE THR SER ALA SER HIS LYS TYR PHE GLU LYS          
SEQRES   8 B   95  THR GLY LEU LYS                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      61.763  58.339  63.453  0.00  0.00           N  
ATOM      2  CA  MET A   1      61.560  57.242  64.420  0.00  0.00           C  
ATOM      3  C   MET A   1      61.047  57.747  65.790  0.00  0.00           C  
ATOM      4  O   MET A   1      61.783  57.716  66.770  0.00  0.00           O  
ATOM      5  CB  MET A   1      62.811  56.345  64.506  0.00  0.00           C  
ATOM      6  CG  MET A   1      62.417  54.973  65.052  0.00  0.00           C  
ATOM      7  SD  MET A   1      63.746  53.757  65.263  0.00  0.00           S  
ATOM      8  CE  MET A   1      64.522  54.375  66.779  0.00  0.00           C  
ATOM      9  HA  MET A   1      60.776  56.617  64.006  0.00  0.00           H  
ATOM     10  HB2 MET A   1      63.229  56.199  63.509  0.00  0.00           H  
ATOM     11  HB3 MET A   1      63.574  56.804  65.136  0.00  0.00           H  
ATOM     12  HG2 MET A   1      61.928  55.113  66.011  0.00  0.00           H  
ATOM     13  HG3 MET A   1      61.691  54.541  64.365  0.00  0.00           H  
ATOM     14  HE1 MET A   1      65.369  53.739  67.035  0.00  0.00           H  
ATOM     15  HE2 MET A   1      63.797  54.356  67.594  0.00  0.00           H  
ATOM     16  HE3 MET A   1      64.872  55.396  66.627  0.00  0.00           H  
ATOM     17  H1  MET A   1      62.405  59.028  63.815  0.00  0.00           H  
ATOM     18  H2  MET A   1      62.111  57.958  62.578  0.00  0.00           H  
ATOM     19  H3  MET A   1      60.857  58.767  63.261  0.00  0.00           H  
ATOM     20  N   THR A   2      59.788  58.209  65.860  0.00  0.00           N  
ATOM     21  CA  THR A   2      58.981  58.393  67.096  0.00  0.00           C  
ATOM     22  C   THR A   2      58.573  57.057  67.762  0.00  0.00           C  
ATOM     23  O   THR A   2      59.065  56.015  67.354  0.00  0.00           O  
ATOM     24  CB  THR A   2      57.730  59.260  66.846  0.00  0.00           C  
ATOM     25  OG1 THR A   2      56.600  58.478  66.528  0.00  0.00           O  
ATOM     26  CG2 THR A   2      57.876  60.325  65.763  0.00  0.00           C  
ATOM     27  H   THR A   2      59.284  58.306  64.974  0.00  0.00           H  
ATOM     28  HA  THR A   2      59.604  58.928  67.813  0.00  0.00           H  
ATOM     29  HB  THR A   2      57.517  59.779  67.779  0.00  0.00           H  
ATOM     30  HG1 THR A   2      55.984  58.561  67.344  0.00  0.00           H  
ATOM     31 HG21 THR A   2      57.655  59.899  64.784  0.00  0.00           H  
ATOM     32 HG22 THR A   2      57.158  61.108  65.974  0.00  0.00           H  
ATOM     33 HG23 THR A   2      58.876  60.756  65.771  0.00  0.00           H  
ATOM     34  N   GLU A   3      57.679  57.042  68.769  0.00  0.00           N  
ATOM     35  CA  GLU A   3      57.188  55.820  69.429  0.00  0.00           C  
ATOM     36  C   GLU A   3      56.589  54.800  68.443  0.00  0.00           C  
ATOM     37  O   GLU A   3      57.084  53.671  68.369  0.00  0.00           O  
ATOM     38  CB  GLU A   3      56.177  56.198  70.526  0.00  0.00           C  
ATOM     39  CG  GLU A   3      55.802  55.012  71.424  0.00  0.00           C  
ATOM     40  CD  GLU A   3      54.872  55.484  72.543  0.00  0.00           C  
ATOM     41  OE1 GLU A   3      53.643  55.549  72.298  0.00  0.00           O  
ATOM     42  OE2 GLU A   3      55.397  55.869  73.608  0.00  0.00           O  
ATOM     43  H   GLU A   3      57.172  57.895  68.994  0.00  0.00           H  
ATOM     44  HA  GLU A   3      58.037  55.335  69.912  0.00  0.00           H  
ATOM     45  HB2 GLU A   3      56.614  56.981  71.148  0.00  0.00           H  
ATOM     46  HB3 GLU A   3      55.270  56.591  70.068  0.00  0.00           H  
ATOM     47  HG2 GLU A   3      55.307  54.241  70.831  0.00  0.00           H  
ATOM     48  HG3 GLU A   3      56.712  54.584  71.852  0.00  0.00           H  
ATOM     49  N   LEU A   4      55.563  55.185  67.661  0.00  0.00           N  
ATOM     50  CA  LEU A   4      54.986  54.295  66.642  0.00  0.00           C  
ATOM     51  C   LEU A   4      56.064  53.855  65.637  0.00  0.00           C  
ATOM     52  O   LEU A   4      56.258  52.671  65.352  0.00  0.00           O  
ATOM     53  CB  LEU A   4      53.703  54.899  65.999  0.00  0.00           C  
ATOM     54  CG  LEU A   4      53.780  56.188  65.149  0.00  0.00           C  
ATOM     55  CD1 LEU A   4      54.121  55.974  63.667  0.00  0.00           C  
ATOM     56  CD2 LEU A   4      52.394  56.842  65.109  0.00  0.00           C  
ATOM     57  H   LEU A   4      55.215  56.129  67.774  0.00  0.00           H  
ATOM     58  HA  LEU A   4      54.676  53.391  67.169  0.00  0.00           H  
ATOM     59  HB2 LEU A   4      53.214  54.152  65.382  0.00  0.00           H  
ATOM     60  HB3 LEU A   4      53.017  55.077  66.824  0.00  0.00           H  
ATOM     61  HG  LEU A   4      54.495  56.874  65.596  0.00  0.00           H  
ATOM     62 HD11 LEU A   4      54.374  56.938  63.225  0.00  0.00           H  
ATOM     63 HD12 LEU A   4      54.957  55.301  63.539  0.00  0.00           H  
ATOM     64 HD13 LEU A   4      53.266  55.572  63.129  0.00  0.00           H  
ATOM     65 HD21 LEU A   4      51.656  56.153  64.705  0.00  0.00           H  
ATOM     66 HD22 LEU A   4      52.090  57.114  66.110  0.00  0.00           H  
ATOM     67 HD23 LEU A   4      52.431  57.743  64.498  0.00  0.00           H  
ATOM     68  N   GLU A   5      56.833  54.819  65.146  0.00  0.00           N  
ATOM     69  CA  GLU A   5      57.861  54.592  64.143  0.00  0.00           C  
ATOM     70  C   GLU A   5      59.009  53.692  64.642  0.00  0.00           C  
ATOM     71  O   GLU A   5      59.610  52.992  63.822  0.00  0.00           O  
ATOM     72  CB  GLU A   5      58.405  55.951  63.736  0.00  0.00           C  
ATOM     73  CG  GLU A   5      57.423  56.910  63.055  0.00  0.00           C  
ATOM     74  CD  GLU A   5      58.162  58.139  62.509  0.00  0.00           C  
ATOM     75  OE1 GLU A   5      59.130  58.576  63.182  0.00  0.00           O  
ATOM     76  OE2 GLU A   5      57.818  58.591  61.397  0.00  0.00           O  
ATOM     77  H   GLU A   5      56.660  55.766  65.463  0.00  0.00           H  
ATOM     78  HA  GLU A   5      57.421  54.114  63.268  0.00  0.00           H  
ATOM     79  HB2 GLU A   5      58.768  56.408  64.640  0.00  0.00           H  
ATOM     80  HB3 GLU A   5      59.242  55.812  63.072  0.00  0.00           H  
ATOM     81  HG2 GLU A   5      56.929  56.378  62.242  0.00  0.00           H  
ATOM     82  HG3 GLU A   5      56.676  57.234  63.780  0.00  0.00           H  
ATOM     83  N   ALA A   6      59.306  53.706  65.951  0.00  0.00           N  
ATOM     84  CA  ALA A   6      60.291  52.877  66.649  0.00  0.00           C  
ATOM     85  C   ALA A   6      59.789  51.458  66.881  0.00  0.00           C  
ATOM     86  O   ALA A   6      60.554  50.523  66.666  0.00  0.00           O  
ATOM     87  CB  ALA A   6      60.655  53.504  68.002  0.00  0.00           C  
ATOM     88  H   ALA A   6      58.826  54.396  66.526  0.00  0.00           H  
ATOM     89  HA  ALA A   6      61.190  52.804  66.041  0.00  0.00           H  
ATOM     90  HB1 ALA A   6      59.768  53.576  68.635  0.00  0.00           H  
ATOM     91  HB2 ALA A   6      61.397  52.882  68.505  0.00  0.00           H  
ATOM     92  HB3 ALA A   6      61.071  54.500  67.869  0.00  0.00           H  
ATOM     93  N   ALA A   7      58.520  51.280  67.266  0.00  0.00           N  
ATOM     94  CA  ALA A   7      57.889  49.965  67.287  0.00  0.00           C  
ATOM     95  C   ALA A   7      57.981  49.284  65.916  0.00  0.00           C  
ATOM     96  O   ALA A   7      58.477  48.162  65.816  0.00  0.00           O  
ATOM     97  CB  ALA A   7      56.447  50.095  67.760  0.00  0.00           C  
ATOM     98  H   ALA A   7      57.956  52.101  67.486  0.00  0.00           H  
ATOM     99  HA  ALA A   7      58.410  49.330  68.000  0.00  0.00           H  
ATOM    100  HB1 ALA A   7      56.045  51.088  67.554  0.00  0.00           H  
ATOM    101  HB2 ALA A   7      56.427  49.904  68.828  0.00  0.00           H  
ATOM    102  HB3 ALA A   7      55.838  49.349  67.258  0.00  0.00           H  
ATOM    103  N   MET A   8      57.585  49.980  64.845  0.00  0.00           N  
ATOM    104  CA  MET A   8      57.834  49.501  63.479  0.00  0.00           C  
ATOM    105  C   MET A   8      59.311  49.320  63.184  0.00  0.00           C  
ATOM    106  O   MET A   8      59.675  48.320  62.577  0.00  0.00           O  
ATOM    107  CB  MET A   8      57.219  50.445  62.467  0.00  0.00           C  
ATOM    108  CG  MET A   8      55.740  50.091  62.405  0.00  0.00           C  
ATOM    109  SD  MET A   8      54.709  51.208  61.458  0.00  0.00           S  
ATOM    110  CE  MET A   8      55.321  52.839  61.962  0.00  0.00           C  
ATOM    111  H   MET A   8      57.166  50.897  64.997  0.00  0.00           H  
ATOM    112  HA  MET A   8      57.380  48.518  63.362  0.00  0.00           H  
ATOM    113  HB2 MET A   8      57.380  51.469  62.799  0.00  0.00           H  
ATOM    114  HB3 MET A   8      57.666  50.302  61.485  0.00  0.00           H  
ATOM    115  HG2 MET A   8      55.625  49.096  61.978  0.00  0.00           H  
ATOM    116  HG3 MET A   8      55.374  50.041  63.421  0.00  0.00           H  
ATOM    117  HE1 MET A   8      54.713  53.620  61.505  0.00  0.00           H  
ATOM    118  HE2 MET A   8      55.266  52.927  63.045  0.00  0.00           H  
ATOM    119  HE3 MET A   8      56.346  52.973  61.623  0.00  0.00           H  
ATOM    120  N   GLY A   9      60.158  50.220  63.683  0.00  0.00           N  
ATOM    121  CA  GLY A   9      61.596  50.026  63.752  0.00  0.00           C  
ATOM    122  C   GLY A   9      61.999  48.644  64.275  0.00  0.00           C  
ATOM    123  O   GLY A   9      62.833  48.004  63.642  0.00  0.00           O  
ATOM    124  H   GLY A   9      59.781  51.082  64.064  0.00  0.00           H  
ATOM    125  HA2 GLY A   9      61.997  50.142  62.748  0.00  0.00           H  
ATOM    126  HA3 GLY A   9      62.026  50.787  64.402  0.00  0.00           H  
ATOM    127  N   MET A  10      61.398  48.158  65.374  0.00  0.00           N  
ATOM    128  CA  MET A  10      61.642  46.808  65.911  0.00  0.00           C  
ATOM    129  C   MET A  10      60.949  45.685  65.126  0.00  0.00           C  
ATOM    130  O   MET A  10      61.361  44.540  65.241  0.00  0.00           O  
ATOM    131  CB  MET A  10      61.277  46.632  67.400  0.00  0.00           C  
ATOM    132  CG  MET A  10      61.155  47.909  68.220  0.00  0.00           C  
ATOM    133  SD  MET A  10      60.891  47.634  69.987  0.00  0.00           S  
ATOM    134  CE  MET A  10      60.623  49.353  70.485  0.00  0.00           C  
ATOM    135  H   MET A  10      60.753  48.779  65.858  0.00  0.00           H  
ATOM    136  HA  MET A  10      62.712  46.646  65.846  0.00  0.00           H  
ATOM    137  HB2 MET A  10      60.330  46.098  67.484  0.00  0.00           H  
ATOM    138  HB3 MET A  10      62.045  46.003  67.855  0.00  0.00           H  
ATOM    139  HG2 MET A  10      62.049  48.519  68.083  0.00  0.00           H  
ATOM    140  HG3 MET A  10      60.295  48.449  67.843  0.00  0.00           H  
ATOM    141  HE1 MET A  10      61.480  49.958  70.185  0.00  0.00           H  
ATOM    142  HE2 MET A  10      60.505  49.401  71.567  0.00  0.00           H  
ATOM    143  HE3 MET A  10      59.723  49.735  70.003  0.00  0.00           H  
ATOM    144  N   ILE A  11      59.914  45.967  64.330  0.00  0.00           N  
ATOM    145  CA  ILE A  11      59.260  44.967  63.469  0.00  0.00           C  
ATOM    146  C   ILE A  11      60.070  44.770  62.182  0.00  0.00           C  
ATOM    147  O   ILE A  11      60.342  43.638  61.781  0.00  0.00           O  
ATOM    148  CB  ILE A  11      57.808  45.387  63.183  0.00  0.00           C  
ATOM    149  CG1 ILE A  11      56.968  45.323  64.477  0.00  0.00           C  
ATOM    150  CG2 ILE A  11      57.176  44.465  62.132  0.00  0.00           C  
ATOM    151  CD1 ILE A  11      55.739  46.236  64.453  0.00  0.00           C  
ATOM    152  H   ILE A  11      59.581  46.925  64.325  0.00  0.00           H  
ATOM    153  HA  ILE A  11      59.234  44.007  63.988  0.00  0.00           H  
ATOM    154  HB  ILE A  11      57.811  46.406  62.803  0.00  0.00           H  
ATOM    155 HG12 ILE A  11      56.652  44.296  64.662  0.00  0.00           H  
ATOM    156 HG13 ILE A  11      57.579  45.623  65.326  0.00  0.00           H  
ATOM    157 HG21 ILE A  11      57.721  44.481  61.190  0.00  0.00           H  
ATOM    158 HG22 ILE A  11      56.160  44.787  61.931  0.00  0.00           H  
ATOM    159 HG23 ILE A  11      57.165  43.447  62.500  0.00  0.00           H  
ATOM    160 HD11 ILE A  11      55.090  45.984  65.291  0.00  0.00           H  
ATOM    161 HD12 ILE A  11      56.048  47.273  64.554  0.00  0.00           H  
ATOM    162 HD13 ILE A  11      55.182  46.123  63.524  0.00  0.00           H  
ATOM    163  N   ILE A  12      60.500  45.876  61.571  0.00  0.00           N  
ATOM    164  CA  ILE A  12      61.562  45.927  60.569  0.00  0.00           C  
ATOM    165  C   ILE A  12      62.847  45.293  61.133  0.00  0.00           C  
ATOM    166  O   ILE A  12      63.514  44.545  60.417  0.00  0.00           O  
ATOM    167  CB  ILE A  12      61.753  47.395  60.121  0.00  0.00           C  
ATOM    168  CG1 ILE A  12      60.547  47.973  59.340  0.00  0.00           C  
ATOM    169  CG2 ILE A  12      63.039  47.586  59.317  0.00  0.00           C  
ATOM    170  CD1 ILE A  12      60.282  47.361  57.958  0.00  0.00           C  
ATOM    171  H   ILE A  12      60.180  46.763  61.951  0.00  0.00           H  
ATOM    172  HA  ILE A  12      61.263  45.333  59.706  0.00  0.00           H  
ATOM    173  HB  ILE A  12      61.864  48.002  61.021  0.00  0.00           H  
ATOM    174 HG12 ILE A  12      59.645  47.863  59.938  0.00  0.00           H  
ATOM    175 HG13 ILE A  12      60.706  49.044  59.206  0.00  0.00           H  
ATOM    176 HG21 ILE A  12      63.896  47.384  59.954  0.00  0.00           H  
ATOM    177 HG22 ILE A  12      63.099  48.619  58.979  0.00  0.00           H  
ATOM    178 HG23 ILE A  12      63.068  46.918  58.455  0.00  0.00           H  
ATOM    179 HD11 ILE A  12      59.415  47.847  57.513  0.00  0.00           H  
ATOM    180 HD12 ILE A  12      60.081  46.293  58.041  0.00  0.00           H  
ATOM    181 HD13 ILE A  12      61.136  47.524  57.301  0.00  0.00           H  
ATOM    182  N   ASP A  13      63.188  45.525  62.412  0.00  0.00           N  
ATOM    183  CA  ASP A  13      64.273  44.807  63.092  0.00  0.00           C  
ATOM    184  C   ASP A  13      64.002  43.303  63.156  0.00  0.00           C  
ATOM    185  O   ASP A  13      64.821  42.572  62.627  0.00  0.00           O  
ATOM    186  CB  ASP A  13      64.577  45.355  64.487  0.00  0.00           C  
ATOM    187  CG  ASP A  13      65.961  44.920  64.957  0.00  0.00           C  
ATOM    188  OD1 ASP A  13      66.052  43.844  65.591  0.00  0.00           O  
ATOM    189  OD2 ASP A  13      66.900  45.702  64.675  0.00  0.00           O  
ATOM    190  H   ASP A  13      62.722  46.278  62.911  0.00  0.00           H  
ATOM    191  HA  ASP A  13      65.170  44.950  62.490  0.00  0.00           H  
ATOM    192  HB2 ASP A  13      64.556  46.442  64.470  0.00  0.00           H  
ATOM    193  HB3 ASP A  13      63.841  44.992  65.199  0.00  0.00           H  
ATOM    194  N   VAL A  14      62.868  42.834  63.711  0.00  0.00           N  
ATOM    195  CA  VAL A  14      62.437  41.420  63.711  0.00  0.00           C  
ATOM    196  C   VAL A  14      62.614  40.811  62.321  0.00  0.00           C  
ATOM    197  O   VAL A  14      63.305  39.803  62.169  0.00  0.00           O  
ATOM    198  CB  VAL A  14      60.992  41.251  64.241  0.00  0.00           C  
ATOM    199  CG1 VAL A  14      60.397  39.889  63.864  0.00  0.00           C  
ATOM    200  CG2 VAL A  14      60.945  41.328  65.773  0.00  0.00           C  
ATOM    201  H   VAL A  14      62.264  43.510  64.172  0.00  0.00           H  
ATOM    202  HA  VAL A  14      63.077  40.859  64.385  0.00  0.00           H  
ATOM    203  HB  VAL A  14      60.353  42.029  63.829  0.00  0.00           H  
ATOM    204 HG11 VAL A  14      60.151  39.857  62.802  0.00  0.00           H  
ATOM    205 HG12 VAL A  14      59.493  39.704  64.435  0.00  0.00           H  
ATOM    206 HG13 VAL A  14      61.104  39.100  64.105  0.00  0.00           H  
ATOM    207 HG21 VAL A  14      61.492  42.199  66.133  0.00  0.00           H  
ATOM    208 HG22 VAL A  14      59.911  41.405  66.107  0.00  0.00           H  
ATOM    209 HG23 VAL A  14      61.389  40.433  66.205  0.00  0.00           H  
ATOM    210  N   PHE A  15      62.065  41.452  61.288  0.00  0.00           N  
ATOM    211  CA  PHE A  15      62.271  41.035  59.908  0.00  0.00           C  
ATOM    212  C   PHE A  15      63.759  40.949  59.538  0.00  0.00           C  
ATOM    213  O   PHE A  15      64.183  39.973  58.923  0.00  0.00           O  
ATOM    214  CB  PHE A  15      61.530  41.994  58.984  0.00  0.00           C  
ATOM    215  CG  PHE A  15      61.483  41.465  57.575  0.00  0.00           C  
ATOM    216  CD1 PHE A  15      60.490  40.539  57.217  0.00  0.00           C  
ATOM    217  CD2 PHE A  15      62.463  41.851  56.643  0.00  0.00           C  
ATOM    218  CE1 PHE A  15      60.425  40.061  55.904  0.00  0.00           C  
ATOM    219  CE2 PHE A  15      62.430  41.326  55.343  0.00  0.00           C  
ATOM    220  CZ  PHE A  15      61.399  40.453  54.976  0.00  0.00           C  
ATOM    221  H   PHE A  15      61.509  42.287  61.475  0.00  0.00           H  
ATOM    222  HA  PHE A  15      61.843  40.039  59.787  0.00  0.00           H  
ATOM    223  HB2 PHE A  15      60.512  42.126  59.344  0.00  0.00           H  
ATOM    224  HB3 PHE A  15      62.012  42.970  58.989  0.00  0.00           H  
ATOM    225  HD1 PHE A  15      59.777  40.194  57.950  0.00  0.00           H  
ATOM    226  HD2 PHE A  15      63.246  42.541  56.920  0.00  0.00           H  
ATOM    227  HE1 PHE A  15      59.642  39.384  55.601  0.00  0.00           H  
ATOM    228  HE2 PHE A  15      63.176  41.612  54.612  0.00  0.00           H  
ATOM    229  HZ  PHE A  15      61.336  40.119  53.962  0.00  0.00           H  
ATOM    230  N   SER A  16      64.564  41.925  59.955  0.00  0.00           N  
ATOM    231  CA  SER A  16      66.027  41.968  59.830  0.00  0.00           C  
ATOM    232  C   SER A  16      66.774  40.985  60.757  0.00  0.00           C  
ATOM    233  O   SER A  16      67.983  40.845  60.597  0.00  0.00           O  
ATOM    234  CB  SER A  16      66.539  43.398  60.075  0.00  0.00           C  
ATOM    235  OG  SER A  16      65.802  44.340  59.315  0.00  0.00           O  
ATOM    236  H   SER A  16      64.133  42.676  60.489  0.00  0.00           H  
ATOM    237  HA  SER A  16      66.287  41.707  58.805  0.00  0.00           H  
ATOM    238  HB2 SER A  16      66.463  43.652  61.131  0.00  0.00           H  
ATOM    239  HB3 SER A  16      67.589  43.455  59.787  0.00  0.00           H  
ATOM    240  HG  SER A  16      64.903  44.430  59.714  0.00  0.00           H  
ATOM    241  N   ARG A  17      66.099  40.268  61.675  0.00  0.00           N  
ATOM    242  CA  ARG A  17      66.647  39.132  62.448  0.00  0.00           C  
ATOM    243  C   ARG A  17      66.395  37.807  61.732  0.00  0.00           C  
ATOM    244  O   ARG A  17      67.282  36.962  61.700  0.00  0.00           O  
ATOM    245  CB  ARG A  17      66.083  39.040  63.887  0.00  0.00           C  
ATOM    246  CG  ARG A  17      65.996  40.389  64.608  0.00  0.00           C  
ATOM    247  CD  ARG A  17      65.809  40.350  66.128  0.00  0.00           C  
ATOM    248  NE  ARG A  17      64.604  39.620  66.593  0.00  0.00           N  
ATOM    249  CZ  ARG A  17      63.818  39.996  67.601  0.00  0.00           C  
ATOM    250  NH1 ARG A  17      63.888  41.209  68.097  0.00  0.00           N  
ATOM    251  NH2 ARG A  17      62.941  39.187  68.147  0.00  0.00           N  
ATOM    252  H   ARG A  17      65.133  40.545  61.838  0.00  0.00           H  
ATOM    253  HA  ARG A  17      67.730  39.252  62.519  0.00  0.00           H  
ATOM    254  HB2 ARG A  17      65.085  38.600  63.866  0.00  0.00           H  
ATOM    255  HB3 ARG A  17      66.729  38.376  64.463  0.00  0.00           H  
ATOM    256  HG2 ARG A  17      66.890  40.974  64.391  0.00  0.00           H  
ATOM    257  HG3 ARG A  17      65.145  40.912  64.212  0.00  0.00           H  
ATOM    258  HD2 ARG A  17      66.695  39.909  66.583  0.00  0.00           H  
ATOM    259  HD3 ARG A  17      65.764  41.393  66.448  0.00  0.00           H  
ATOM    260  HE  ARG A  17      64.452  38.686  66.250  0.00  0.00           H  
ATOM    261 HH11 ARG A  17      64.486  41.892  67.672  0.00  0.00           H  
ATOM    262 HH12 ARG A  17      63.205  41.527  68.810  0.00  0.00           H  
ATOM    263 HH21 ARG A  17      62.681  38.229  67.874  0.00  0.00           H  
ATOM    264 HH22 ARG A  17      62.482  39.539  69.006  0.00  0.00           H  
ATOM    265  N   TYR A  18      65.199  37.640  61.155  0.00  0.00           N  
ATOM    266  CA  TYR A  18      64.742  36.369  60.578  0.00  0.00           C  
ATOM    267  C   TYR A  18      64.943  36.287  59.058  0.00  0.00           C  
ATOM    268  O   TYR A  18      65.560  35.336  58.590  0.00  0.00           O  
ATOM    269  CB  TYR A  18      63.311  36.100  61.049  0.00  0.00           C  
ATOM    270  CG  TYR A  18      63.246  35.821  62.545  0.00  0.00           C  
ATOM    271  CD1 TYR A  18      63.594  34.555  63.055  0.00  0.00           C  
ATOM    272  CD2 TYR A  18      62.825  36.827  63.428  0.00  0.00           C  
ATOM    273  CE1 TYR A  18      63.491  34.296  64.440  0.00  0.00           C  
ATOM    274  CE2 TYR A  18      62.726  36.582  64.806  0.00  0.00           C  
ATOM    275  CZ  TYR A  18      63.045  35.309  65.320  0.00  0.00           C  
ATOM    276  OH  TYR A  18      62.891  35.061  66.652  0.00  0.00           O  
ATOM    277  H   TYR A  18      64.525  38.384  61.307  0.00  0.00           H  
ATOM    278  HA  TYR A  18      65.352  35.561  60.990  0.00  0.00           H  
ATOM    279  HB2 TYR A  18      62.677  36.954  60.804  0.00  0.00           H  
ATOM    280  HB3 TYR A  18      62.908  35.240  60.519  0.00  0.00           H  
ATOM    281  HD1 TYR A  18      63.922  33.787  62.363  0.00  0.00           H  
ATOM    282  HD2 TYR A  18      62.545  37.786  63.040  0.00  0.00           H  
ATOM    283  HE1 TYR A  18      63.733  33.323  64.840  0.00  0.00           H  
ATOM    284  HE2 TYR A  18      62.381  37.364  65.461  0.00  0.00           H  
ATOM    285  HH  TYR A  18      62.390  35.807  67.123  0.00  0.00           H  
ATOM    286  N   SER A  19      64.591  37.321  58.275  0.00  0.00           N  
ATOM    287  CA  SER A  19      65.247  37.503  56.963  0.00  0.00           C  
ATOM    288  C   SER A  19      66.735  37.839  57.144  0.00  0.00           C  
ATOM    289  O   SER A  19      67.521  37.646  56.225  0.00  0.00           O  
ATOM    290  CB  SER A  19      64.574  38.572  56.094  0.00  0.00           C  
ATOM    291  OG  SER A  19      64.934  39.866  56.525  0.00  0.00           O  
ATOM    292  H   SER A  19      64.124  38.122  58.688  0.00  0.00           H  
ATOM    293  HA  SER A  19      65.185  36.560  56.418  0.00  0.00           H  
ATOM    294  HB2 SER A  19      64.901  38.447  55.060  0.00  0.00           H  
ATOM    295  HB3 SER A  19      63.493  38.463  56.127  0.00  0.00           H  
ATOM    296  HG  SER A  19      64.608  39.970  57.453  0.00  0.00           H  
ATOM    297  N   GLY A  20      67.129  38.328  58.331  0.00  0.00           N  
ATOM    298  CA  GLY A  20      68.498  38.339  58.863  0.00  0.00           C  
ATOM    299  C   GLY A  20      69.470  39.340  58.231  0.00  0.00           C  
ATOM    300  O   GLY A  20      70.556  39.552  58.769  0.00  0.00           O  
ATOM    301  H   GLY A  20      66.383  38.527  58.980  0.00  0.00           H  
ATOM    302  HA2 GLY A  20      68.461  38.537  59.933  0.00  0.00           H  
ATOM    303  HA3 GLY A  20      68.919  37.342  58.737  0.00  0.00           H  
ATOM    304  N   SER A  21      69.081  39.931  57.096  0.00  0.00           N  
ATOM    305  CA  SER A  21      69.819  40.679  56.063  0.00  0.00           C  
ATOM    306  C   SER A  21      69.402  40.101  54.712  0.00  0.00           C  
ATOM    307  O   SER A  21      68.709  40.775  53.961  0.00  0.00           O  
ATOM    308  CB  SER A  21      71.352  40.660  56.188  0.00  0.00           C  
ATOM    309  OG  SER A  21      71.758  41.278  57.385  0.00  0.00           O  
ATOM    310  H   SER A  21      68.160  39.623  56.804  0.00  0.00           H  
ATOM    311  HA  SER A  21      69.495  41.721  56.093  0.00  0.00           H  
ATOM    312  HB2 SER A  21      71.710  39.629  56.180  0.00  0.00           H  
ATOM    313  HB3 SER A  21      71.791  41.194  55.345  0.00  0.00           H  
ATOM    314  HG  SER A  21      71.363  40.707  58.093  0.00  0.00           H  
ATOM    315  N   GLU A  22      69.756  38.835  54.456  0.00  0.00           N  
ATOM    316  CA  GLU A  22      69.224  37.959  53.409  0.00  0.00           C  
ATOM    317  C   GLU A  22      69.087  36.535  53.980  0.00  0.00           C  
ATOM    318  O   GLU A  22      69.902  36.124  54.808  0.00  0.00           O  
ATOM    319  CB  GLU A  22      70.177  37.879  52.203  0.00  0.00           C  
ATOM    320  CG  GLU A  22      70.407  39.171  51.396  0.00  0.00           C  
ATOM    321  CD  GLU A  22      69.831  39.114  49.976  0.00  0.00           C  
ATOM    322  OE1 GLU A  22      70.054  38.092  49.293  0.00  0.00           O  
ATOM    323  OE2 GLU A  22      69.173  40.104  49.578  0.00  0.00           O  
ATOM    324  H   GLU A  22      70.234  38.325  55.187  0.00  0.00           H  
ATOM    325  HA  GLU A  22      68.247  38.315  53.086  0.00  0.00           H  
ATOM    326  HB2 GLU A  22      71.147  37.534  52.565  0.00  0.00           H  
ATOM    327  HB3 GLU A  22      69.796  37.098  51.543  0.00  0.00           H  
ATOM    328  HG2 GLU A  22      69.993  40.028  51.922  0.00  0.00           H  
ATOM    329  HG3 GLU A  22      71.483  39.338  51.318  0.00  0.00           H  
ATOM    330  N   GLY A  23      68.114  35.760  53.485  0.00  0.00           N  
ATOM    331  CA  GLY A  23      67.900  34.355  53.877  0.00  0.00           C  
ATOM    332  C   GLY A  23      67.209  33.520  52.793  0.00  0.00           C  
ATOM    333  O   GLY A  23      66.568  32.516  53.092  0.00  0.00           O  
ATOM    334  H   GLY A  23      67.455  36.193  52.841  0.00  0.00           H  
ATOM    335  HA2 GLY A  23      68.859  33.887  54.098  0.00  0.00           H  
ATOM    336  HA3 GLY A  23      67.291  34.326  54.781  0.00  0.00           H  
ATOM    337  N   SER A  24      67.276  34.005  51.549  0.00  0.00           N  
ATOM    338  CA  SER A  24      66.348  33.695  50.448  0.00  0.00           C  
ATOM    339  C   SER A  24      66.687  34.421  49.126  0.00  0.00           C  
ATOM    340  O   SER A  24      66.242  34.005  48.061  0.00  0.00           O  
ATOM    341  CB  SER A  24      64.944  34.165  50.875  0.00  0.00           C  
ATOM    342  OG  SER A  24      63.980  33.150  50.728  0.00  0.00           O  
ATOM    343  H   SER A  24      67.885  34.801  51.476  0.00  0.00           H  
ATOM    344  HA  SER A  24      66.332  32.619  50.272  0.00  0.00           H  
ATOM    345  HB2 SER A  24      64.948  34.483  51.917  0.00  0.00           H  
ATOM    346  HB3 SER A  24      64.657  35.029  50.281  0.00  0.00           H  
ATOM    347  HG  SER A  24      63.717  33.096  49.764  0.00  0.00           H  
ATOM    348  N   THR A  25      67.447  35.521  49.200  0.00  0.00           N  
ATOM    349  CA  THR A  25      67.032  36.911  48.909  0.00  0.00           C  
ATOM    350  C   THR A  25      66.629  37.582  50.242  0.00  0.00           C  
ATOM    351  O   THR A  25      66.590  36.910  51.280  0.00  0.00           O  
ATOM    352  CB  THR A  25      66.006  37.072  47.761  0.00  0.00           C  
ATOM    353  OG1 THR A  25      65.986  38.434  47.397  0.00  0.00           O  
ATOM    354  CG2 THR A  25      64.547  36.716  48.046  0.00  0.00           C  
ATOM    355  H   THR A  25      68.004  35.570  50.033  0.00  0.00           H  
ATOM    356  HA  THR A  25      67.922  37.431  48.559  0.00  0.00           H  
ATOM    357  HB  THR A  25      66.345  36.498  46.898  0.00  0.00           H  
ATOM    358  HG1 THR A  25      65.370  38.531  46.665  0.00  0.00           H  
ATOM    359 HG21 THR A  25      64.415  35.645  48.163  0.00  0.00           H  
ATOM    360 HG22 THR A  25      64.229  37.218  48.950  0.00  0.00           H  
ATOM    361 HG23 THR A  25      63.911  37.032  47.218  0.00  0.00           H  
ATOM    362  N   GLN A  26      66.348  38.889  50.273  0.00  0.00           N  
ATOM    363  CA  GLN A  26      65.980  39.606  51.508  0.00  0.00           C  
ATOM    364  C   GLN A  26      64.476  39.574  51.780  0.00  0.00           C  
ATOM    365  O   GLN A  26      63.776  40.583  51.784  0.00  0.00           O  
ATOM    366  CB  GLN A  26      66.668  40.970  51.624  0.00  0.00           C  
ATOM    367  CG  GLN A  26      66.511  41.987  50.487  0.00  0.00           C  
ATOM    368  CD  GLN A  26      67.614  43.038  50.598  0.00  0.00           C  
ATOM    369  OE1 GLN A  26      67.401  44.170  51.005  0.00  0.00           O  
ATOM    370  NE2 GLN A  26      68.840  42.681  50.263  0.00  0.00           N  
ATOM    371  H   GLN A  26      66.423  39.392  49.394  0.00  0.00           H  
ATOM    372  HA  GLN A  26      66.400  39.050  52.344  0.00  0.00           H  
ATOM    373  HB2 GLN A  26      66.362  41.440  52.560  0.00  0.00           H  
ATOM    374  HB3 GLN A  26      67.726  40.745  51.708  0.00  0.00           H  
ATOM    375  HG2 GLN A  26      66.603  41.491  49.521  0.00  0.00           H  
ATOM    376  HG3 GLN A  26      65.534  42.466  50.552  0.00  0.00           H  
ATOM    377 HE21 GLN A  26      69.010  41.702  49.963  0.00  0.00           H  
ATOM    378 HE22 GLN A  26      69.574  43.338  50.435  0.00  0.00           H  
ATOM    379  N   THR A  27      64.002  38.352  52.030  0.00  0.00           N  
ATOM    380  CA  THR A  27      62.606  38.003  52.288  0.00  0.00           C  
ATOM    381  C   THR A  27      62.513  36.900  53.341  0.00  0.00           C  
ATOM    382  O   THR A  27      63.425  36.077  53.437  0.00  0.00           O  
ATOM    383  CB  THR A  27      61.927  37.471  51.020  0.00  0.00           C  
ATOM    384  OG1 THR A  27      62.578  36.288  50.617  0.00  0.00           O  
ATOM    385  CG2 THR A  27      61.892  38.475  49.861  0.00  0.00           C  
ATOM    386  H   THR A  27      64.671  37.589  52.009  0.00  0.00           H  
ATOM    387  HA  THR A  27      62.066  38.881  52.612  0.00  0.00           H  
ATOM    388  HB  THR A  27      60.902  37.208  51.270  0.00  0.00           H  
ATOM    389  HG1 THR A  27      62.870  35.810  51.403  0.00  0.00           H  
ATOM    390 HG21 THR A  27      61.283  39.332  50.135  0.00  0.00           H  
ATOM    391 HG22 THR A  27      62.888  38.826  49.609  0.00  0.00           H  
ATOM    392 HG23 THR A  27      61.453  38.012  48.980  0.00  0.00           H  
ATOM    393  N   LEU A  28      61.359  36.752  53.992  0.00  0.00           N  
ATOM    394  CA  LEU A  28      60.942  35.464  54.543  0.00  0.00           C  
ATOM    395  C   LEU A  28      60.376  34.602  53.405  0.00  0.00           C  
ATOM    396  O   LEU A  28      59.266  34.843  52.931  0.00  0.00           O  
ATOM    397  CB  LEU A  28      59.851  35.650  55.612  0.00  0.00           C  
ATOM    398  CG  LEU A  28      60.249  36.058  57.046  0.00  0.00           C  
ATOM    399  CD1 LEU A  28      61.523  36.885  57.165  0.00  0.00           C  
ATOM    400  CD2 LEU A  28      59.086  36.843  57.662  0.00  0.00           C  
ATOM    401  H   LEU A  28      60.633  37.446  53.810  0.00  0.00           H  
ATOM    402  HA  LEU A  28      61.794  34.946  54.987  0.00  0.00           H  
ATOM    403  HB2 LEU A  28      59.111  36.344  55.214  0.00  0.00           H  
ATOM    404  HB3 LEU A  28      59.348  34.695  55.707  0.00  0.00           H  
ATOM    405  HG  LEU A  28      60.404  35.152  57.633  0.00  0.00           H  
ATOM    406 HD11 LEU A  28      61.438  37.780  56.559  0.00  0.00           H  
ATOM    407 HD12 LEU A  28      61.688  37.164  58.205  0.00  0.00           H  
ATOM    408 HD13 LEU A  28      62.375  36.295  56.826  0.00  0.00           H  
ATOM    409 HD21 LEU A  28      58.230  36.181  57.799  0.00  0.00           H  
ATOM    410 HD22 LEU A  28      59.377  37.263  58.622  0.00  0.00           H  
ATOM    411 HD23 LEU A  28      58.798  37.669  57.013  0.00  0.00           H  
ATOM    412  N   THR A  29      61.087  33.548  52.999  0.00  0.00           N  
ATOM    413  CA  THR A  29      60.378  32.376  52.469  0.00  0.00           C  
ATOM    414  C   THR A  29      59.543  31.729  53.584  0.00  0.00           C  
ATOM    415  O   THR A  29      59.871  31.826  54.771  0.00  0.00           O  
ATOM    416  CB  THR A  29      61.338  31.364  51.812  0.00  0.00           C  
ATOM    417  OG1 THR A  29      60.612  30.243  51.357  0.00  0.00           O  
ATOM    418  CG2 THR A  29      62.447  30.836  52.721  0.00  0.00           C  
ATOM    419  H   THR A  29      62.025  33.430  53.358  0.00  0.00           H  
ATOM    420  HA  THR A  29      59.687  32.709  51.692  0.00  0.00           H  
ATOM    421  HB  THR A  29      61.797  31.834  50.948  0.00  0.00           H  
ATOM    422  HG1 THR A  29      61.161  29.792  50.709  0.00  0.00           H  
ATOM    423 HG21 THR A  29      63.059  31.659  53.090  0.00  0.00           H  
ATOM    424 HG22 THR A  29      62.024  30.289  53.558  0.00  0.00           H  
ATOM    425 HG23 THR A  29      63.091  30.166  52.151  0.00  0.00           H  
ATOM    426  N   LYS A  30      58.504  30.986  53.191  0.00  0.00           N  
ATOM    427  CA  LYS A  30      57.677  30.102  54.026  0.00  0.00           C  
ATOM    428  C   LYS A  30      58.505  29.252  54.999  0.00  0.00           C  
ATOM    429  O   LYS A  30      58.132  29.085  56.160  0.00  0.00           O  
ATOM    430  CB  LYS A  30      56.874  29.228  53.048  0.00  0.00           C  
ATOM    431  CG  LYS A  30      55.738  28.431  53.697  0.00  0.00           C  
ATOM    432  CD  LYS A  30      54.918  27.712  52.616  0.00  0.00           C  
ATOM    433  CE  LYS A  30      53.932  26.743  53.268  0.00  0.00           C  
ATOM    434  NZ  LYS A  30      52.915  26.249  52.310  0.00  0.00           N  
ATOM    435  H   LYS A  30      58.339  30.983  52.192  0.00  0.00           H  
ATOM    436  HA  LYS A  30      56.992  30.706  54.623  0.00  0.00           H  
ATOM    437  HB2 LYS A  30      56.450  29.869  52.278  0.00  0.00           H  
ATOM    438  HB3 LYS A  30      57.554  28.534  52.551  0.00  0.00           H  
ATOM    439  HG2 LYS A  30      56.161  27.699  54.386  0.00  0.00           H  
ATOM    440  HG3 LYS A  30      55.086  29.111  54.246  0.00  0.00           H  
ATOM    441  HD2 LYS A  30      54.372  28.455  52.032  0.00  0.00           H  
ATOM    442  HD3 LYS A  30      55.582  27.154  51.954  0.00  0.00           H  
ATOM    443  HE2 LYS A  30      54.492  25.906  53.693  0.00  0.00           H  
ATOM    444  HE3 LYS A  30      53.434  27.272  54.084  0.00  0.00           H  
ATOM    445  HZ1 LYS A  30      53.327  25.750  51.537  0.00  0.00           H  
ATOM    446  HZ2 LYS A  30      52.222  25.668  52.788  0.00  0.00           H  
ATOM    447  HZ3 LYS A  30      52.384  27.049  51.933  0.00  0.00           H  
ATOM    448  N   GLY A  31      59.653  28.747  54.532  0.00  0.00           N  
ATOM    449  CA  GLY A  31      60.563  27.920  55.323  0.00  0.00           C  
ATOM    450  C   GLY A  31      61.424  28.688  56.334  0.00  0.00           C  
ATOM    451  O   GLY A  31      61.914  28.067  57.273  0.00  0.00           O  
ATOM    452  H   GLY A  31      59.883  28.967  53.571  0.00  0.00           H  
ATOM    453  HA2 GLY A  31      59.978  27.184  55.874  0.00  0.00           H  
ATOM    454  HA3 GLY A  31      61.231  27.384  54.649  0.00  0.00           H  
ATOM    455  N   GLU A  32      61.585  30.008  56.183  0.00  0.00           N  
ATOM    456  CA  GLU A  32      62.225  30.886  57.168  0.00  0.00           C  
ATOM    457  C   GLU A  32      61.180  31.346  58.188  0.00  0.00           C  
ATOM    458  O   GLU A  32      61.307  31.063  59.380  0.00  0.00           O  
ATOM    459  CB  GLU A  32      62.906  32.067  56.443  0.00  0.00           C  
ATOM    460  CG  GLU A  32      63.448  33.166  57.375  0.00  0.00           C  
ATOM    461  CD  GLU A  32      64.176  32.607  58.610  0.00  0.00           C  
ATOM    462  OE1 GLU A  32      64.992  31.676  58.430  0.00  0.00           O  
ATOM    463  OE2 GLU A  32      63.833  33.053  59.728  0.00  0.00           O  
ATOM    464  H   GLU A  32      61.100  30.470  55.421  0.00  0.00           H  
ATOM    465  HA  GLU A  32      62.995  30.332  57.709  0.00  0.00           H  
ATOM    466  HB2 GLU A  32      63.733  31.673  55.850  0.00  0.00           H  
ATOM    467  HB3 GLU A  32      62.202  32.532  55.752  0.00  0.00           H  
ATOM    468  HG2 GLU A  32      64.125  33.801  56.798  0.00  0.00           H  
ATOM    469  HG3 GLU A  32      62.611  33.789  57.694  0.00  0.00           H  
ATOM    470  N   LEU A  33      60.094  31.951  57.686  0.00  0.00           N  
ATOM    471  CA  LEU A  33      58.929  32.475  58.405  0.00  0.00           C  
ATOM    472  C   LEU A  33      58.515  31.641  59.629  0.00  0.00           C  
ATOM    473  O   LEU A  33      58.153  32.191  60.666  0.00  0.00           O  
ATOM    474  CB  LEU A  33      57.805  32.570  57.357  0.00  0.00           C  
ATOM    475  CG  LEU A  33      56.457  33.129  57.836  0.00  0.00           C  
ATOM    476  CD1 LEU A  33      55.633  33.498  56.615  0.00  0.00           C  
ATOM    477  CD2 LEU A  33      55.652  32.110  58.641  0.00  0.00           C  
ATOM    478  H   LEU A  33      60.081  32.063  56.674  0.00  0.00           H  
ATOM    479  HA  LEU A  33      59.162  33.480  58.759  0.00  0.00           H  
ATOM    480  HB2 LEU A  33      58.154  33.209  56.553  0.00  0.00           H  
ATOM    481  HB3 LEU A  33      57.640  31.587  56.916  0.00  0.00           H  
ATOM    482  HG  LEU A  33      56.614  34.028  58.433  0.00  0.00           H  
ATOM    483 HD11 LEU A  33      56.121  34.295  56.057  0.00  0.00           H  
ATOM    484 HD12 LEU A  33      55.480  32.620  55.987  0.00  0.00           H  
ATOM    485 HD13 LEU A  33      54.672  33.856  56.954  0.00  0.00           H  
ATOM    486 HD21 LEU A  33      56.043  31.111  58.483  0.00  0.00           H  
ATOM    487 HD22 LEU A  33      55.743  32.375  59.683  0.00  0.00           H  
ATOM    488 HD23 LEU A  33      54.595  32.124  58.380  0.00  0.00           H  
ATOM    489  N   LYS A  34      58.570  30.308  59.531  0.00  0.00           N  
ATOM    490  CA  LYS A  34      58.216  29.401  60.625  0.00  0.00           C  
ATOM    491  C   LYS A  34      59.037  29.593  61.911  0.00  0.00           C  
ATOM    492  O   LYS A  34      58.469  29.450  62.992  0.00  0.00           O  
ATOM    493  CB  LYS A  34      58.278  27.952  60.119  0.00  0.00           C  
ATOM    494  CG  LYS A  34      59.708  27.399  60.074  0.00  0.00           C  
ATOM    495  CD  LYS A  34      59.813  26.122  59.238  0.00  0.00           C  
ATOM    496  CE  LYS A  34      61.150  25.399  59.458  0.00  0.00           C  
ATOM    497  NZ  LYS A  34      62.323  26.285  59.252  0.00  0.00           N  
ATOM    498  H   LYS A  34      58.882  29.942  58.642  0.00  0.00           H  
ATOM    499  HA  LYS A  34      57.186  29.618  60.900  0.00  0.00           H  
ATOM    500  HB2 LYS A  34      57.683  27.323  60.784  0.00  0.00           H  
ATOM    501  HB3 LYS A  34      57.836  27.909  59.122  0.00  0.00           H  
ATOM    502  HG2 LYS A  34      60.371  28.151  59.642  0.00  0.00           H  
ATOM    503  HG3 LYS A  34      60.027  27.179  61.094  0.00  0.00           H  
ATOM    504  HD2 LYS A  34      59.004  25.444  59.512  0.00  0.00           H  
ATOM    505  HD3 LYS A  34      59.702  26.380  58.183  0.00  0.00           H  
ATOM    506  HE2 LYS A  34      61.170  24.999  60.476  0.00  0.00           H  
ATOM    507  HE3 LYS A  34      61.197  24.557  58.762  0.00  0.00           H  
ATOM    508  HZ1 LYS A  34      63.185  25.760  59.206  0.00  0.00           H  
ATOM    509  HZ2 LYS A  34      62.219  26.821  58.385  0.00  0.00           H  
ATOM    510  HZ3 LYS A  34      62.393  26.970  59.992  0.00  0.00           H  
ATOM    511  N   VAL A  35      60.347  29.882  61.829  0.00  0.00           N  
ATOM    512  CA  VAL A  35      61.227  29.863  63.019  0.00  0.00           C  
ATOM    513  C   VAL A  35      61.037  31.116  63.879  0.00  0.00           C  
ATOM    514  O   VAL A  35      61.180  31.053  65.097  0.00  0.00           O  
ATOM    515  CB  VAL A  35      62.718  29.633  62.677  0.00  0.00           C  
ATOM    516  CG1 VAL A  35      62.896  28.506  61.651  0.00  0.00           C  
ATOM    517  CG2 VAL A  35      63.449  30.881  62.180  0.00  0.00           C  
ATOM    518  H   VAL A  35      60.738  30.109  60.913  0.00  0.00           H  
ATOM    519  HA  VAL A  35      60.920  29.019  63.639  0.00  0.00           H  
ATOM    520  HB  VAL A  35      63.213  29.316  63.596  0.00  0.00           H  
ATOM    521 HG11 VAL A  35      63.954  28.248  61.586  0.00  0.00           H  
ATOM    522 HG12 VAL A  35      62.334  27.632  61.974  0.00  0.00           H  
ATOM    523 HG13 VAL A  35      62.561  28.849  60.672  0.00  0.00           H  
ATOM    524 HG21 VAL A  35      62.902  31.343  61.360  0.00  0.00           H  
ATOM    525 HG22 VAL A  35      63.556  31.596  62.993  0.00  0.00           H  
ATOM    526 HG23 VAL A  35      64.448  30.623  61.825  0.00  0.00           H  
ATOM    527  N   LEU A  36      60.643  32.206  63.217  0.00  0.00           N  
ATOM    528  CA  LEU A  36      60.102  33.471  63.702  0.00  0.00           C  
ATOM    529  C   LEU A  36      58.773  33.278  64.452  0.00  0.00           C  
ATOM    530  O   LEU A  36      58.556  33.898  65.494  0.00  0.00           O  
ATOM    531  CB  LEU A  36      59.970  34.335  62.425  0.00  0.00           C  
ATOM    532  CG  LEU A  36      58.962  35.495  62.380  0.00  0.00           C  
ATOM    533  CD1 LEU A  36      59.526  36.766  62.995  0.00  0.00           C  
ATOM    534  CD2 LEU A  36      58.654  35.801  60.914  0.00  0.00           C  
ATOM    535  H   LEU A  36      60.638  32.094  62.212  0.00  0.00           H  
ATOM    536  HA  LEU A  36      60.804  33.944  64.388  0.00  0.00           H  
ATOM    537  HB2 LEU A  36      60.952  34.720  62.169  0.00  0.00           H  
ATOM    538  HB3 LEU A  36      59.720  33.678  61.600  0.00  0.00           H  
ATOM    539  HG  LEU A  36      58.034  35.225  62.879  0.00  0.00           H  
ATOM    540 HD11 LEU A  36      60.301  37.181  62.351  0.00  0.00           H  
ATOM    541 HD12 LEU A  36      58.730  37.500  63.120  0.00  0.00           H  
ATOM    542 HD13 LEU A  36      59.960  36.532  63.961  0.00  0.00           H  
ATOM    543 HD21 LEU A  36      59.591  35.907  60.369  0.00  0.00           H  
ATOM    544 HD22 LEU A  36      58.075  34.986  60.479  0.00  0.00           H  
ATOM    545 HD23 LEU A  36      58.083  36.721  60.839  0.00  0.00           H  
ATOM    546  N   MET A  37      57.875  32.427  63.941  0.00  0.00           N  
ATOM    547  CA  MET A  37      56.483  32.383  64.403  0.00  0.00           C  
ATOM    548  C   MET A  37      56.336  31.994  65.867  0.00  0.00           C  
ATOM    549  O   MET A  37      55.622  32.653  66.612  0.00  0.00           O  
ATOM    550  CB  MET A  37      55.656  31.408  63.564  0.00  0.00           C  
ATOM    551  CG  MET A  37      55.399  31.956  62.169  0.00  0.00           C  
ATOM    552  SD  MET A  37      53.757  32.677  61.976  0.00  0.00           S  
ATOM    553  CE  MET A  37      52.735  31.181  61.929  0.00  0.00           C  
ATOM    554  H   MET A  37      58.127  31.919  63.104  0.00  0.00           H  
ATOM    555  HA  MET A  37      56.078  33.382  64.291  0.00  0.00           H  
ATOM    556  HB2 MET A  37      56.159  30.445  63.500  0.00  0.00           H  
ATOM    557  HB3 MET A  37      54.694  31.258  64.046  0.00  0.00           H  
ATOM    558  HG2 MET A  37      56.133  32.726  61.941  0.00  0.00           H  
ATOM    559  HG3 MET A  37      55.509  31.141  61.458  0.00  0.00           H  
ATOM    560  HE1 MET A  37      51.778  31.384  62.408  0.00  0.00           H  
ATOM    561  HE2 MET A  37      52.561  30.895  60.893  0.00  0.00           H  
ATOM    562  HE3 MET A  37      53.233  30.364  62.452  0.00  0.00           H  
ATOM    563  N   GLU A  38      57.024  30.933  66.281  0.00  0.00           N  
ATOM    564  CA  GLU A  38      56.975  30.370  67.637  0.00  0.00           C  
ATOM    565  C   GLU A  38      57.408  31.370  68.718  0.00  0.00           C  
ATOM    566  O   GLU A  38      57.173  31.152  69.904  0.00  0.00           O  
ATOM    567  CB  GLU A  38      57.913  29.163  67.693  0.00  0.00           C  
ATOM    568  CG  GLU A  38      57.630  28.103  66.615  0.00  0.00           C  
ATOM    569  CD  GLU A  38      58.779  27.106  66.451  0.00  0.00           C  
ATOM    570  OE1 GLU A  38      59.925  27.448  66.837  0.00  0.00           O  
ATOM    571  OE2 GLU A  38      58.493  26.038  65.862  0.00  0.00           O  
ATOM    572  H   GLU A  38      57.577  30.453  65.584  0.00  0.00           H  
ATOM    573  HA  GLU A  38      55.969  30.034  67.861  0.00  0.00           H  
ATOM    574  HB2 GLU A  38      58.920  29.553  67.568  0.00  0.00           H  
ATOM    575  HB3 GLU A  38      57.843  28.693  68.675  0.00  0.00           H  
ATOM    576  HG2 GLU A  38      56.708  27.577  66.871  0.00  0.00           H  
ATOM    577  HG3 GLU A  38      57.483  28.574  65.641  0.00  0.00           H  
ATOM    578  N   LYS A  39      58.075  32.444  68.285  0.00  0.00           N  
ATOM    579  CA  LYS A  39      58.770  33.442  69.085  0.00  0.00           C  
ATOM    580  C   LYS A  39      57.969  34.744  69.047  0.00  0.00           C  
ATOM    581  O   LYS A  39      57.500  35.218  70.080  0.00  0.00           O  
ATOM    582  CB  LYS A  39      60.210  33.616  68.544  0.00  0.00           C  
ATOM    583  CG  LYS A  39      60.914  32.337  68.047  0.00  0.00           C  
ATOM    584  CD  LYS A  39      61.076  31.215  69.085  0.00  0.00           C  
ATOM    585  CE  LYS A  39      62.015  30.097  68.592  0.00  0.00           C  
ATOM    586  NZ  LYS A  39      61.596  29.461  67.315  0.00  0.00           N  
ATOM    587  H   LYS A  39      58.155  32.526  67.280  0.00  0.00           H  
ATOM    588  HA  LYS A  39      58.815  33.111  70.124  0.00  0.00           H  
ATOM    589  HB2 LYS A  39      60.185  34.287  67.686  0.00  0.00           H  
ATOM    590  HB3 LYS A  39      60.822  34.097  69.308  0.00  0.00           H  
ATOM    591  HG2 LYS A  39      60.348  31.946  67.205  0.00  0.00           H  
ATOM    592  HG3 LYS A  39      61.902  32.618  67.681  0.00  0.00           H  
ATOM    593  HD2 LYS A  39      61.505  31.643  69.992  0.00  0.00           H  
ATOM    594  HD3 LYS A  39      60.104  30.792  69.340  0.00  0.00           H  
ATOM    595  HE2 LYS A  39      63.005  30.536  68.460  0.00  0.00           H  
ATOM    596  HE3 LYS A  39      62.088  29.335  69.373  0.00  0.00           H  
ATOM    597  HZ1 LYS A  39      60.785  28.830  67.401  0.00  0.00           H  
ATOM    598  HZ2 LYS A  39      61.384  30.159  66.598  0.00  0.00           H  
ATOM    599  HZ3 LYS A  39      62.325  28.865  66.955  0.00  0.00           H  
ATOM    600  N   GLU A  40      57.740  35.269  67.838  0.00  0.00           N  
ATOM    601  CA  GLU A  40      57.190  36.607  67.629  0.00  0.00           C  
ATOM    602  C   GLU A  40      55.723  36.596  67.145  0.00  0.00           C  
ATOM    603  O   GLU A  40      55.088  37.648  67.157  0.00  0.00           O  
ATOM    604  CB  GLU A  40      58.092  37.444  66.694  0.00  0.00           C  
ATOM    605  CG  GLU A  40      59.588  37.090  66.578  0.00  0.00           C  
ATOM    606  CD  GLU A  40      60.424  37.130  67.860  0.00  0.00           C  
ATOM    607  OE1 GLU A  40      59.861  37.425  68.932  0.00  0.00           O  
ATOM    608  OE2 GLU A  40      61.651  36.865  67.729  0.00  0.00           O  
ATOM    609  H   GLU A  40      58.145  34.792  67.034  0.00  0.00           H  
ATOM    610  HA  GLU A  40      57.196  37.124  68.590  0.00  0.00           H  
ATOM    611  HB2 GLU A  40      57.676  37.392  65.686  0.00  0.00           H  
ATOM    612  HB3 GLU A  40      58.032  38.481  67.020  0.00  0.00           H  
ATOM    613  HG2 GLU A  40      59.686  36.101  66.134  0.00  0.00           H  
ATOM    614  HG3 GLU A  40      60.030  37.803  65.882  0.00  0.00           H  
ATOM    615  N   LEU A  41      55.149  35.437  66.780  0.00  0.00           N  
ATOM    616  CA  LEU A  41      53.737  35.256  66.389  0.00  0.00           C  
ATOM    617  C   LEU A  41      52.998  34.097  67.131  0.00  0.00           C  
ATOM    618  O   LEU A  41      52.204  33.391  66.497  0.00  0.00           O  
ATOM    619  CB  LEU A  41      53.652  35.127  64.849  0.00  0.00           C  
ATOM    620  CG  LEU A  41      54.014  36.413  64.078  0.00  0.00           C  
ATOM    621  CD1 LEU A  41      54.754  36.118  62.770  0.00  0.00           C  
ATOM    622  CD2 LEU A  41      52.749  37.211  63.761  0.00  0.00           C  
ATOM    623  H   LEU A  41      55.705  34.587  66.829  0.00  0.00           H  
ATOM    624  HA  LEU A  41      53.185  36.158  66.658  0.00  0.00           H  
ATOM    625  HB2 LEU A  41      54.300  34.315  64.542  0.00  0.00           H  
ATOM    626  HB3 LEU A  41      52.647  34.832  64.555  0.00  0.00           H  
ATOM    627  HG  LEU A  41      54.673  37.033  64.675  0.00  0.00           H  
ATOM    628 HD11 LEU A  41      55.033  37.055  62.289  0.00  0.00           H  
ATOM    629 HD12 LEU A  41      55.661  35.553  62.984  0.00  0.00           H  
ATOM    630 HD13 LEU A  41      54.120  35.544  62.097  0.00  0.00           H  
ATOM    631 HD21 LEU A  41      53.000  38.084  63.161  0.00  0.00           H  
ATOM    632 HD22 LEU A  41      52.045  36.596  63.200  0.00  0.00           H  
ATOM    633 HD23 LEU A  41      52.276  37.534  64.689  0.00  0.00           H  
ATOM    634  N   PRO A  42      53.154  33.892  68.463  0.00  0.00           N  
ATOM    635  CA  PRO A  42      52.180  33.155  69.273  0.00  0.00           C  
ATOM    636  C   PRO A  42      50.706  33.438  68.930  0.00  0.00           C  
ATOM    637  O   PRO A  42      50.333  34.552  68.574  0.00  0.00           O  
ATOM    638  CB  PRO A  42      52.501  33.514  70.725  0.00  0.00           C  
ATOM    639  CG  PRO A  42      54.012  33.743  70.708  0.00  0.00           C  
ATOM    640  CD  PRO A  42      54.307  34.230  69.292  0.00  0.00           C  
ATOM    641  HA  PRO A  42      52.372  32.097  69.139  0.00  0.00           H  
ATOM    642  HB2 PRO A  42      51.992  34.437  71.001  0.00  0.00           H  
ATOM    643  HB3 PRO A  42      52.226  32.710  71.408  0.00  0.00           H  
ATOM    644  HG2 PRO A  42      54.308  34.485  71.451  0.00  0.00           H  
ATOM    645  HG3 PRO A  42      54.531  32.800  70.883  0.00  0.00           H  
ATOM    646  HD2 PRO A  42      54.485  35.300  69.304  0.00  0.00           H  
ATOM    647  HD3 PRO A  42      55.200  33.724  68.922  0.00  0.00           H  
ATOM    648  N   GLY A  43      49.859  32.405  69.029  0.00  0.00           N  
ATOM    649  CA  GLY A  43      48.428  32.460  68.699  0.00  0.00           C  
ATOM    650  C   GLY A  43      48.125  32.157  67.229  0.00  0.00           C  
ATOM    651  O   GLY A  43      47.181  31.425  66.937  0.00  0.00           O  
ATOM    652  H   GLY A  43      50.236  31.527  69.354  0.00  0.00           H  
ATOM    653  HA2 GLY A  43      47.900  31.724  69.308  0.00  0.00           H  
ATOM    654  HA3 GLY A  43      48.029  33.445  68.939  0.00  0.00           H  
ATOM    655  N   PHE A  44      48.973  32.603  66.297  0.00  0.00           N  
ATOM    656  CA  PHE A  44      48.968  32.129  64.900  0.00  0.00           C  
ATOM    657  C   PHE A  44      49.477  30.677  64.780  0.00  0.00           C  
ATOM    658  O   PHE A  44      49.378  30.040  63.734  0.00  0.00           O  
ATOM    659  CB  PHE A  44      49.775  33.110  64.041  0.00  0.00           C  
ATOM    660  CG  PHE A  44      49.231  34.524  64.143  0.00  0.00           C  
ATOM    661  CD1 PHE A  44      48.143  34.922  63.342  0.00  0.00           C  
ATOM    662  CD2 PHE A  44      49.727  35.404  65.124  0.00  0.00           C  
ATOM    663  CE1 PHE A  44      47.584  36.201  63.489  0.00  0.00           C  
ATOM    664  CE2 PHE A  44      49.133  36.662  65.307  0.00  0.00           C  
ATOM    665  CZ  PHE A  44      48.070  37.066  64.482  0.00  0.00           C  
ATOM    666  H   PHE A  44      49.713  33.236  66.584  0.00  0.00           H  
ATOM    667  HA  PHE A  44      47.942  32.138  64.530  0.00  0.00           H  
ATOM    668  HB2 PHE A  44      50.821  33.096  64.346  0.00  0.00           H  
ATOM    669  HB3 PHE A  44      49.736  32.784  63.003  0.00  0.00           H  
ATOM    670  HD1 PHE A  44      47.706  34.243  62.629  0.00  0.00           H  
ATOM    671  HD2 PHE A  44      50.530  35.109  65.780  0.00  0.00           H  
ATOM    672  HE1 PHE A  44      46.763  36.500  62.857  0.00  0.00           H  
ATOM    673  HE2 PHE A  44      49.487  37.316  66.093  0.00  0.00           H  
ATOM    674  HZ  PHE A  44      47.619  38.036  64.634  0.00  0.00           H  
ATOM    675  N   LEU A  45      49.966  30.136  65.900  0.00  0.00           N  
ATOM    676  CA  LEU A  45      50.439  28.776  66.132  0.00  0.00           C  
ATOM    677  C   LEU A  45      49.314  27.755  66.384  0.00  0.00           C  
ATOM    678  O   LEU A  45      49.614  26.623  66.747  0.00  0.00           O  
ATOM    679  CB  LEU A  45      51.410  28.785  67.327  0.00  0.00           C  
ATOM    680  CG  LEU A  45      52.505  29.861  67.267  0.00  0.00           C  
ATOM    681  CD1 LEU A  45      53.394  29.752  68.505  0.00  0.00           C  
ATOM    682  CD2 LEU A  45      53.369  29.744  66.014  0.00  0.00           C  
ATOM    683  H   LEU A  45      50.020  30.778  66.675  0.00  0.00           H  
ATOM    684  HA  LEU A  45      50.981  28.447  65.245  0.00  0.00           H  
ATOM    685  HB2 LEU A  45      50.830  28.936  68.238  0.00  0.00           H  
ATOM    686  HB3 LEU A  45      51.889  27.808  67.393  0.00  0.00           H  
ATOM    687  HG  LEU A  45      52.039  30.845  67.281  0.00  0.00           H  
ATOM    688 HD11 LEU A  45      53.991  28.841  68.460  0.00  0.00           H  
ATOM    689 HD12 LEU A  45      54.047  30.625  68.554  0.00  0.00           H  
ATOM    690 HD13 LEU A  45      52.782  29.734  69.406  0.00  0.00           H  
ATOM    691 HD21 LEU A  45      53.793  28.744  65.929  0.00  0.00           H  
ATOM    692 HD22 LEU A  45      52.775  29.971  65.126  0.00  0.00           H  
ATOM    693 HD23 LEU A  45      54.167  30.474  66.082  0.00  0.00           H  
ATOM    694  N   GLN A  46      48.039  28.113  66.180  0.00  0.00           N  
ATOM    695  CA  GLN A  46      46.903  27.179  66.261  0.00  0.00           C  
ATOM    696  C   GLN A  46      47.090  25.926  65.374  0.00  0.00           C  
ATOM    697  O   GLN A  46      46.681  24.841  65.777  0.00  0.00           O  
ATOM    698  CB  GLN A  46      45.604  27.930  65.926  0.00  0.00           C  
ATOM    699  CG  GLN A  46      45.105  28.759  67.121  0.00  0.00           C  
ATOM    700  CD  GLN A  46      44.074  29.799  66.694  0.00  0.00           C  
ATOM    701  OE1 GLN A  46      42.895  29.525  66.559  0.00  0.00           O  
ATOM    702  NE2 GLN A  46      44.494  31.028  66.462  0.00  0.00           N  
ATOM    703  H   GLN A  46      47.852  29.076  65.935  0.00  0.00           H  
ATOM    704  HA  GLN A  46      46.830  26.814  67.287  0.00  0.00           H  
ATOM    705  HB2 GLN A  46      45.775  28.582  65.068  0.00  0.00           H  
ATOM    706  HB3 GLN A  46      44.822  27.215  65.660  0.00  0.00           H  
ATOM    707  HG2 GLN A  46      44.650  28.093  67.856  0.00  0.00           H  
ATOM    708  HG3 GLN A  46      45.941  29.263  67.604  0.00  0.00           H  
ATOM    709 HE21 GLN A  46      45.479  31.270  66.589  0.00  0.00           H  
ATOM    710 HE22 GLN A  46      43.790  31.692  66.193  0.00  0.00           H  
ATOM    711  N   SER A  47      47.772  26.058  64.226  0.00  0.00           N  
ATOM    712  CA  SER A  47      48.330  24.934  63.449  0.00  0.00           C  
ATOM    713  C   SER A  47      49.813  24.648  63.748  0.00  0.00           C  
ATOM    714  O   SER A  47      50.294  23.538  63.536  0.00  0.00           O  
ATOM    715  CB  SER A  47      48.278  25.259  61.963  0.00  0.00           C  
ATOM    716  OG  SER A  47      46.987  25.150  61.412  0.00  0.00           O  
ATOM    717  H   SER A  47      47.955  27.002  63.921  0.00  0.00           H  
ATOM    718  HA  SER A  47      47.756  24.024  63.628  0.00  0.00           H  
ATOM    719  HB2 SER A  47      48.643  26.270  61.831  0.00  0.00           H  
ATOM    720  HB3 SER A  47      48.935  24.574  61.425  0.00  0.00           H  
ATOM    721  HG  SER A  47      47.138  24.840  60.438  0.00  0.00           H  
ATOM    722  N   GLY A  48      50.580  25.659  64.166  0.00  0.00           N  
ATOM    723  CA  GLY A  48      51.967  25.533  64.631  0.00  0.00           C  
ATOM    724  C   GLY A  48      53.026  25.594  63.529  0.00  0.00           C  
ATOM    725  O   GLY A  48      54.123  26.093  63.791  0.00  0.00           O  
ATOM    726  H   GLY A  48      50.116  26.540  64.307  0.00  0.00           H  
ATOM    727  HA2 GLY A  48      52.169  26.336  65.339  0.00  0.00           H  
ATOM    728  HA3 GLY A  48      52.080  24.588  65.163  0.00  0.00           H  
ATOM    729  N   LYS A  49      52.700  25.122  62.312  0.00  0.00           N  
ATOM    730  CA  LYS A  49      53.401  25.385  61.038  0.00  0.00           C  
ATOM    731  C   LYS A  49      52.769  24.685  59.829  0.00  0.00           C  
ATOM    732  O   LYS A  49      52.484  25.368  58.850  0.00  0.00           O  
ATOM    733  CB  LYS A  49      54.928  25.110  61.099  0.00  0.00           C  
ATOM    734  CG  LYS A  49      55.342  23.710  61.598  0.00  0.00           C  
ATOM    735  CD  LYS A  49      56.789  23.638  62.115  0.00  0.00           C  
ATOM    736  CE  LYS A  49      56.947  23.971  63.609  0.00  0.00           C  
ATOM    737  NZ  LYS A  49      56.816  25.413  63.917  0.00  0.00           N  
ATOM    738  H   LYS A  49      51.791  24.668  62.277  0.00  0.00           H  
ATOM    739  HA  LYS A  49      53.285  26.446  60.835  0.00  0.00           H  
ATOM    740  HB2 LYS A  49      55.348  25.252  60.102  0.00  0.00           H  
ATOM    741  HB3 LYS A  49      55.390  25.873  61.718  0.00  0.00           H  
ATOM    742  HG2 LYS A  49      54.674  23.365  62.387  0.00  0.00           H  
ATOM    743  HG3 LYS A  49      55.251  23.018  60.761  0.00  0.00           H  
ATOM    744  HD2 LYS A  49      57.125  22.608  61.987  0.00  0.00           H  
ATOM    745  HD3 LYS A  49      57.442  24.270  61.511  0.00  0.00           H  
ATOM    746  HE2 LYS A  49      56.214  23.401  64.186  0.00  0.00           H  
ATOM    747  HE3 LYS A  49      57.941  23.641  63.926  0.00  0.00           H  
ATOM    748  HZ1 LYS A  49      55.838  25.708  63.943  0.00  0.00           H  
ATOM    749  HZ2 LYS A  49      57.268  25.608  64.824  0.00  0.00           H  
ATOM    750  HZ3 LYS A  49      57.324  25.976  63.255  0.00  0.00           H  
ATOM    751  N   ASP A  50      52.670  23.352  59.904  0.00  0.00           N  
ATOM    752  CA  ASP A  50      52.509  22.289  58.888  0.00  0.00           C  
ATOM    753  C   ASP A  50      52.260  22.664  57.407  0.00  0.00           C  
ATOM    754  O   ASP A  50      51.474  22.033  56.697  0.00  0.00           O  
ATOM    755  CB  ASP A  50      51.528  21.218  59.406  0.00  0.00           C  
ATOM    756  CG  ASP A  50      51.678  19.897  58.636  0.00  0.00           C  
ATOM    757  OD1 ASP A  50      52.819  19.603  58.196  0.00  0.00           O  
ATOM    758  OD2 ASP A  50      50.658  19.216  58.414  0.00  0.00           O  
ATOM    759  H   ASP A  50      52.876  22.998  60.825  0.00  0.00           H  
ATOM    760  HA  ASP A  50      53.485  21.800  58.870  0.00  0.00           H  
ATOM    761  HB2 ASP A  50      51.729  21.025  60.461  0.00  0.00           H  
ATOM    762  HB3 ASP A  50      50.507  21.594  59.314  0.00  0.00           H  
ATOM    763  N   LYS A  51      53.008  23.638  56.880  0.00  0.00           N  
ATOM    764  CA  LYS A  51      52.855  24.206  55.535  0.00  0.00           C  
ATOM    765  C   LYS A  51      51.434  24.731  55.246  0.00  0.00           C  
ATOM    766  O   LYS A  51      51.124  24.954  54.075  0.00  0.00           O  
ATOM    767  CB  LYS A  51      53.337  23.217  54.446  0.00  0.00           C  
ATOM    768  CG  LYS A  51      54.741  22.616  54.641  0.00  0.00           C  
ATOM    769  CD  LYS A  51      54.826  21.298  55.439  0.00  0.00           C  
ATOM    770  CE  LYS A  51      54.002  20.151  54.829  0.00  0.00           C  
ATOM    771  NZ  LYS A  51      52.741  19.895  55.571  0.00  0.00           N  
ATOM    772  H   LYS A  51      53.524  24.180  57.561  0.00  0.00           H  
ATOM    773  HA  LYS A  51      53.504  25.079  55.494  0.00  0.00           H  
ATOM    774  HB2 LYS A  51      52.603  22.423  54.321  0.00  0.00           H  
ATOM    775  HB3 LYS A  51      53.361  23.759  53.502  0.00  0.00           H  
ATOM    776  HG2 LYS A  51      55.154  22.418  53.650  0.00  0.00           H  
ATOM    777  HG3 LYS A  51      55.386  23.360  55.110  0.00  0.00           H  
ATOM    778  HD2 LYS A  51      55.874  20.989  55.433  0.00  0.00           H  
ATOM    779  HD3 LYS A  51      54.553  21.457  56.481  0.00  0.00           H  
ATOM    780  HE2 LYS A  51      53.786  20.388  53.784  0.00  0.00           H  
ATOM    781  HE3 LYS A  51      54.613  19.245  54.847  0.00  0.00           H  
ATOM    782  HZ1 LYS A  51      52.180  19.171  55.152  0.00  0.00           H  
ATOM    783  HZ2 LYS A  51      52.931  19.611  56.545  0.00  0.00           H  
ATOM    784  HZ3 LYS A  51      52.176  20.738  55.690  0.00  0.00           H  
ATOM    785  N   ASP A  52      50.613  24.962  56.281  0.00  0.00           N  
ATOM    786  CA  ASP A  52      49.177  25.259  56.211  0.00  0.00           C  
ATOM    787  C   ASP A  52      48.823  26.658  56.745  0.00  0.00           C  
ATOM    788  O   ASP A  52      47.991  27.331  56.140  0.00  0.00           O  
ATOM    789  CB  ASP A  52      48.395  24.183  56.991  0.00  0.00           C  
ATOM    790  CG  ASP A  52      48.523  24.354  58.509  0.00  0.00           C  
ATOM    791  OD1 ASP A  52      49.671  24.552  58.973  0.00  0.00           O  
ATOM    792  OD2 ASP A  52      47.473  24.432  59.187  0.00  0.00           O  
ATOM    793  H   ASP A  52      50.953  24.734  57.214  0.00  0.00           H  
ATOM    794  HA  ASP A  52      48.857  25.212  55.169  0.00  0.00           H  
ATOM    795  HB2 ASP A  52      47.342  24.260  56.715  0.00  0.00           H  
ATOM    796  HB3 ASP A  52      48.745  23.191  56.703  0.00  0.00           H  
ATOM    797  N   ALA A  53      49.470  27.098  57.837  0.00  0.00           N  
ATOM    798  CA  ALA A  53      49.213  28.364  58.533  0.00  0.00           C  
ATOM    799  C   ALA A  53      50.451  29.265  58.602  0.00  0.00           C  
ATOM    800  O   ALA A  53      50.322  30.477  58.447  0.00  0.00           O  
ATOM    801  CB  ALA A  53      48.703  28.067  59.936  0.00  0.00           C  
ATOM    802  H   ALA A  53      49.955  26.354  58.342  0.00  0.00           H  
ATOM    803  HA  ALA A  53      48.433  28.914  58.005  0.00  0.00           H  
ATOM    804  HB1 ALA A  53      48.426  28.996  60.437  0.00  0.00           H  
ATOM    805  HB2 ALA A  53      47.831  27.413  59.883  0.00  0.00           H  
ATOM    806  HB3 ALA A  53      49.502  27.587  60.500  0.00  0.00           H  
ATOM    807  N   VAL A  54      51.657  28.683  58.674  0.00  0.00           N  
ATOM    808  CA  VAL A  54      52.884  29.356  58.206  0.00  0.00           C  
ATOM    809  C   VAL A  54      52.701  29.839  56.762  0.00  0.00           C  
ATOM    810  O   VAL A  54      53.146  30.922  56.406  0.00  0.00           O  
ATOM    811  CB  VAL A  54      54.088  28.404  58.379  0.00  0.00           C  
ATOM    812  CG1 VAL A  54      55.169  28.499  57.297  0.00  0.00           C  
ATOM    813  CG2 VAL A  54      54.692  28.604  59.771  0.00  0.00           C  
ATOM    814  H   VAL A  54      51.690  27.681  58.827  0.00  0.00           H  
ATOM    815  HA  VAL A  54      53.054  30.249  58.807  0.00  0.00           H  
ATOM    816  HB  VAL A  54      53.727  27.384  58.326  0.00  0.00           H  
ATOM    817 HG11 VAL A  54      55.480  29.527  57.134  0.00  0.00           H  
ATOM    818 HG12 VAL A  54      56.034  27.900  57.577  0.00  0.00           H  
ATOM    819 HG13 VAL A  54      54.774  28.097  56.366  0.00  0.00           H  
ATOM    820 HG21 VAL A  54      55.163  29.581  59.835  0.00  0.00           H  
ATOM    821 HG22 VAL A  54      53.913  28.548  60.531  0.00  0.00           H  
ATOM    822 HG23 VAL A  54      55.431  27.832  59.963  0.00  0.00           H  
ATOM    823  N   ASP A  55      51.955  29.069  55.967  0.00  0.00           N  
ATOM    824  CA  ASP A  55      51.467  29.422  54.638  0.00  0.00           C  
ATOM    825  C   ASP A  55      50.474  30.586  54.616  0.00  0.00           C  
ATOM    826  O   ASP A  55      50.383  31.245  53.591  0.00  0.00           O  
ATOM    827  CB  ASP A  55      50.754  28.189  54.099  0.00  0.00           C  
ATOM    828  CG  ASP A  55      50.353  28.280  52.629  0.00  0.00           C  
ATOM    829  OD1 ASP A  55      51.289  28.274  51.796  0.00  0.00           O  
ATOM    830  OD2 ASP A  55      49.129  28.238  52.368  0.00  0.00           O  
ATOM    831  H   ASP A  55      51.627  28.204  56.366  0.00  0.00           H  
ATOM    832  HA  ASP A  55      52.310  29.671  53.991  0.00  0.00           H  
ATOM    833  HB2 ASP A  55      51.412  27.343  54.234  0.00  0.00           H  
ATOM    834  HB3 ASP A  55      49.865  28.017  54.693  0.00  0.00           H  
ATOM    835  N   LYS A  56      49.721  30.850  55.691  0.00  0.00           N  
ATOM    836  CA  LYS A  56      48.725  31.936  55.727  0.00  0.00           C  
ATOM    837  C   LYS A  56      49.309  33.215  56.304  0.00  0.00           C  
ATOM    838  O   LYS A  56      49.041  34.288  55.777  0.00  0.00           O  
ATOM    839  CB  LYS A  56      47.428  31.504  56.429  0.00  0.00           C  
ATOM    840  CG  LYS A  56      46.610  30.407  55.713  0.00  0.00           C  
ATOM    841  CD  LYS A  56      46.839  30.254  54.194  0.00  0.00           C  
ATOM    842  CE  LYS A  56      46.066  29.077  53.596  0.00  0.00           C  
ATOM    843  NZ  LYS A  56      46.848  27.824  53.698  0.00  0.00           N  
ATOM    844  H   LYS A  56      49.892  30.324  56.540  0.00  0.00           H  
ATOM    845  HA  LYS A  56      48.459  32.218  54.712  0.00  0.00           H  
ATOM    846  HB2 LYS A  56      47.655  31.168  57.444  0.00  0.00           H  
ATOM    847  HB3 LYS A  56      46.790  32.386  56.519  0.00  0.00           H  
ATOM    848  HG2 LYS A  56      46.809  29.460  56.202  0.00  0.00           H  
ATOM    849  HG3 LYS A  56      45.551  30.625  55.870  0.00  0.00           H  
ATOM    850  HD2 LYS A  56      46.527  31.173  53.698  0.00  0.00           H  
ATOM    851  HD3 LYS A  56      47.892  30.094  53.978  0.00  0.00           H  
ATOM    852  HE2 LYS A  56      45.105  28.980  54.107  0.00  0.00           H  
ATOM    853  HE3 LYS A  56      45.883  29.292  52.542  0.00  0.00           H  
ATOM    854  HZ1 LYS A  56      46.333  27.031  53.351  0.00  0.00           H  
ATOM    855  HZ2 LYS A  56      47.710  27.922  53.139  0.00  0.00           H  
ATOM    856  HZ3 LYS A  56      47.146  27.653  54.661  0.00  0.00           H  
ATOM    857  N   LEU A  57      50.242  33.086  57.249  0.00  0.00           N  
ATOM    858  CA  LEU A  57      51.164  34.154  57.641  0.00  0.00           C  
ATOM    859  C   LEU A  57      52.165  34.477  56.516  0.00  0.00           C  
ATOM    860  O   LEU A  57      52.904  35.451  56.622  0.00  0.00           O  
ATOM    861  CB  LEU A  57      51.836  33.765  58.973  0.00  0.00           C  
ATOM    862  CG  LEU A  57      50.957  34.014  60.222  0.00  0.00           C  
ATOM    863  CD1 LEU A  57      51.011  35.481  60.648  0.00  0.00           C  
ATOM    864  CD2 LEU A  57      49.493  33.592  60.083  0.00  0.00           C  
ATOM    865  H   LEU A  57      50.383  32.161  57.646  0.00  0.00           H  
ATOM    866  HA  LEU A  57      50.594  35.071  57.797  0.00  0.00           H  
ATOM    867  HB2 LEU A  57      52.115  32.710  58.938  0.00  0.00           H  
ATOM    868  HB3 LEU A  57      52.762  34.333  59.090  0.00  0.00           H  
ATOM    869  HG  LEU A  57      51.361  33.433  61.043  0.00  0.00           H  
ATOM    870 HD11 LEU A  57      50.412  35.628  61.547  0.00  0.00           H  
ATOM    871 HD12 LEU A  57      52.040  35.763  60.863  0.00  0.00           H  
ATOM    872 HD13 LEU A  57      50.625  36.111  59.850  0.00  0.00           H  
ATOM    873 HD21 LEU A  57      48.974  34.228  59.365  0.00  0.00           H  
ATOM    874 HD22 LEU A  57      49.435  32.549  59.775  0.00  0.00           H  
ATOM    875 HD23 LEU A  57      48.997  33.684  61.039  0.00  0.00           H  
ATOM    876  N   LEU A  58      52.148  33.699  55.424  0.00  0.00           N  
ATOM    877  CA  LEU A  58      52.692  34.037  54.116  0.00  0.00           C  
ATOM    878  C   LEU A  58      51.588  34.646  53.230  0.00  0.00           C  
ATOM    879  O   LEU A  58      51.605  35.856  53.035  0.00  0.00           O  
ATOM    880  CB  LEU A  58      53.337  32.780  53.508  0.00  0.00           C  
ATOM    881  CG  LEU A  58      54.420  33.053  52.457  0.00  0.00           C  
ATOM    882  CD1 LEU A  58      55.752  33.382  53.138  0.00  0.00           C  
ATOM    883  CD2 LEU A  58      54.532  31.794  51.597  0.00  0.00           C  
ATOM    884  H   LEU A  58      51.592  32.861  55.487  0.00  0.00           H  
ATOM    885  HA  LEU A  58      53.464  34.797  54.251  0.00  0.00           H  
ATOM    886  HB2 LEU A  58      53.785  32.182  54.302  0.00  0.00           H  
ATOM    887  HB3 LEU A  58      52.566  32.164  53.054  0.00  0.00           H  
ATOM    888  HG  LEU A  58      54.137  33.889  51.823  0.00  0.00           H  
ATOM    889 HD11 LEU A  58      56.515  33.595  52.394  0.00  0.00           H  
ATOM    890 HD12 LEU A  58      55.640  34.266  53.762  0.00  0.00           H  
ATOM    891 HD13 LEU A  58      56.078  32.545  53.747  0.00  0.00           H  
ATOM    892 HD21 LEU A  58      54.498  30.908  52.226  0.00  0.00           H  
ATOM    893 HD22 LEU A  58      53.695  31.765  50.899  0.00  0.00           H  
ATOM    894 HD23 LEU A  58      55.457  31.800  51.028  0.00  0.00           H  
ATOM    895  N   LYS A  59      50.631  33.835  52.730  0.00  0.00           N  
ATOM    896  CA  LYS A  59      49.609  34.117  51.696  0.00  0.00           C  
ATOM    897  C   LYS A  59      48.867  35.445  51.841  0.00  0.00           C  
ATOM    898  O   LYS A  59      48.567  36.076  50.831  0.00  0.00           O  
ATOM    899  CB  LYS A  59      48.619  32.944  51.593  0.00  0.00           C  
ATOM    900  CG  LYS A  59      49.181  31.838  50.681  0.00  0.00           C  
ATOM    901  CD  LYS A  59      48.824  32.116  49.210  0.00  0.00           C  
ATOM    902  CE  LYS A  59      49.752  31.408  48.215  0.00  0.00           C  
ATOM    903  NZ  LYS A  59      50.910  32.253  47.820  0.00  0.00           N  
ATOM    904  H   LYS A  59      50.688  32.861  53.015  0.00  0.00           H  
ATOM    905  HA  LYS A  59      50.108  34.175  50.734  0.00  0.00           H  
ATOM    906  HB2 LYS A  59      48.417  32.547  52.584  0.00  0.00           H  
ATOM    907  HB3 LYS A  59      47.665  33.290  51.189  0.00  0.00           H  
ATOM    908  HG2 LYS A  59      50.263  31.769  50.805  0.00  0.00           H  
ATOM    909  HG3 LYS A  59      48.746  30.881  50.972  0.00  0.00           H  
ATOM    910  HD2 LYS A  59      47.805  31.761  49.046  0.00  0.00           H  
ATOM    911  HD3 LYS A  59      48.834  33.190  49.008  0.00  0.00           H  
ATOM    912  HE2 LYS A  59      50.096  30.467  48.654  0.00  0.00           H  
ATOM    913  HE3 LYS A  59      49.168  31.173  47.322  0.00  0.00           H  
ATOM    914  HZ1 LYS A  59      50.664  33.230  47.620  0.00  0.00           H  
ATOM    915  HZ2 LYS A  59      51.570  32.432  48.588  0.00  0.00           H  
ATOM    916  HZ3 LYS A  59      51.436  31.889  47.042  0.00  0.00           H  
ATOM    917  N   ASP A  60      48.614  35.877  53.073  0.00  0.00           N  
ATOM    918  CA  ASP A  60      48.094  37.200  53.397  0.00  0.00           C  
ATOM    919  C   ASP A  60      48.980  38.337  52.840  0.00  0.00           C  
ATOM    920  O   ASP A  60      48.490  39.223  52.143  0.00  0.00           O  
ATOM    921  CB  ASP A  60      47.982  37.273  54.927  0.00  0.00           C  
ATOM    922  CG  ASP A  60      46.652  36.768  55.492  0.00  0.00           C  
ATOM    923  OD1 ASP A  60      46.104  35.785  54.942  0.00  0.00           O  
ATOM    924  OD2 ASP A  60      46.193  37.388  56.476  0.00  0.00           O  
ATOM    925  H   ASP A  60      48.824  35.262  53.852  0.00  0.00           H  
ATOM    926  HA  ASP A  60      47.099  37.320  52.963  0.00  0.00           H  
ATOM    927  HB2 ASP A  60      48.798  36.726  55.389  0.00  0.00           H  
ATOM    928  HB3 ASP A  60      48.116  38.298  55.227  0.00  0.00           H  
ATOM    929  N   LEU A  61      50.285  38.299  53.138  0.00  0.00           N  
ATOM    930  CA  LEU A  61      51.285  39.322  52.824  0.00  0.00           C  
ATOM    931  C   LEU A  61      51.920  39.118  51.443  0.00  0.00           C  
ATOM    932  O   LEU A  61      52.003  40.067  50.673  0.00  0.00           O  
ATOM    933  CB  LEU A  61      52.348  39.456  53.940  0.00  0.00           C  
ATOM    934  CG  LEU A  61      52.624  38.326  54.963  0.00  0.00           C  
ATOM    935  CD1 LEU A  61      53.738  38.778  55.912  0.00  0.00           C  
ATOM    936  CD2 LEU A  61      51.427  37.926  55.838  0.00  0.00           C  
ATOM    937  H   LEU A  61      50.612  37.448  53.584  0.00  0.00           H  
ATOM    938  HA  LEU A  61      50.769  40.280  52.757  0.00  0.00           H  
ATOM    939  HB2 LEU A  61      53.298  39.686  53.463  0.00  0.00           H  
ATOM    940  HB3 LEU A  61      52.085  40.344  54.496  0.00  0.00           H  
ATOM    941  HG  LEU A  61      52.987  37.452  54.430  0.00  0.00           H  
ATOM    942 HD11 LEU A  61      53.359  39.515  56.616  0.00  0.00           H  
ATOM    943 HD12 LEU A  61      54.113  37.915  56.465  0.00  0.00           H  
ATOM    944 HD13 LEU A  61      54.550  39.218  55.341  0.00  0.00           H  
ATOM    945 HD21 LEU A  61      50.996  37.009  55.445  0.00  0.00           H  
ATOM    946 HD22 LEU A  61      51.735  37.723  56.864  0.00  0.00           H  
ATOM    947 HD23 LEU A  61      50.673  38.706  55.847  0.00  0.00           H  
ATOM    948  N   ASP A  62      52.267  37.867  51.135  0.00  0.00           N  
ATOM    949  CA  ASP A  62      52.672  37.236  49.864  0.00  0.00           C  
ATOM    950  C   ASP A  62      52.082  37.868  48.592  0.00  0.00           C  
ATOM    951  O   ASP A  62      52.776  37.977  47.584  0.00  0.00           O  
ATOM    952  CB  ASP A  62      52.213  35.793  50.096  0.00  0.00           C  
ATOM    953  CG  ASP A  62      52.102  34.756  48.988  0.00  0.00           C  
ATOM    954  OD1 ASP A  62      51.267  34.902  48.067  0.00  0.00           O  
ATOM    955  OD2 ASP A  62      52.592  33.632  49.248  0.00  0.00           O  
ATOM    956  H   ASP A  62      52.102  37.202  51.886  0.00  0.00           H  
ATOM    957  HA  ASP A  62      53.759  37.261  49.776  0.00  0.00           H  
ATOM    958  HB2 ASP A  62      52.856  35.381  50.871  0.00  0.00           H  
ATOM    959  HB3 ASP A  62      51.209  35.873  50.492  0.00  0.00           H  
ATOM    960  N   ALA A  63      50.847  38.379  48.663  0.00  0.00           N  
ATOM    961  CA  ALA A  63      50.204  39.215  47.649  0.00  0.00           C  
ATOM    962  C   ALA A  63      51.038  40.428  47.177  0.00  0.00           C  
ATOM    963  O   ALA A  63      50.867  40.888  46.048  0.00  0.00           O  
ATOM    964  CB  ALA A  63      48.876  39.692  48.248  0.00  0.00           C  
ATOM    965  H   ALA A  63      50.359  38.239  49.536  0.00  0.00           H  
ATOM    966  HA  ALA A  63      49.995  38.597  46.775  0.00  0.00           H  
ATOM    967  HB1 ALA A  63      49.068  40.311  49.128  0.00  0.00           H  
ATOM    968  HB2 ALA A  63      48.329  40.281  47.512  0.00  0.00           H  
ATOM    969  HB3 ALA A  63      48.270  38.836  48.547  0.00  0.00           H  
ATOM    970  N   ASN A  64      51.925  40.958  48.028  0.00  0.00           N  
ATOM    971  CA  ASN A  64      52.820  42.085  47.763  0.00  0.00           C  
ATOM    972  C   ASN A  64      54.151  41.620  47.109  0.00  0.00           C  
ATOM    973  O   ASN A  64      54.917  42.469  46.651  0.00  0.00           O  
ATOM    974  CB  ASN A  64      52.935  42.829  49.119  0.00  0.00           C  
ATOM    975  CG  ASN A  64      53.665  44.175  49.216  0.00  0.00           C  
ATOM    976  OD1 ASN A  64      53.368  44.974  50.089  0.00  0.00           O  
ATOM    977  ND2 ASN A  64      54.651  44.480  48.402  0.00  0.00           N  
ATOM    978  H   ASN A  64      51.994  40.527  48.951  0.00  0.00           H  
ATOM    979  HA  ASN A  64      52.339  42.756  47.051  0.00  0.00           H  
ATOM    980  HB2 ASN A  64      51.920  43.028  49.463  0.00  0.00           H  
ATOM    981  HB3 ASN A  64      53.362  42.152  49.849  0.00  0.00           H  
ATOM    982 HD21 ASN A  64      54.954  43.826  47.679  0.00  0.00           H  
ATOM    983 HD22 ASN A  64      55.111  45.354  48.576  0.00  0.00           H  
ATOM    984  N   GLY A  65      54.408  40.309  46.989  0.00  0.00           N  
ATOM    985  CA  GLY A  65      55.597  39.738  46.348  0.00  0.00           C  
ATOM    986  C   GLY A  65      55.259  38.528  45.476  0.00  0.00           C  
ATOM    987  O   GLY A  65      54.956  38.688  44.295  0.00  0.00           O  
ATOM    988  H   GLY A  65      53.758  39.646  47.406  0.00  0.00           H  
ATOM    989  HA2 GLY A  65      56.080  40.486  45.719  0.00  0.00           H  
ATOM    990  HA3 GLY A  65      56.309  39.434  47.115  0.00  0.00           H  
ATOM    991  N   ASP A  66      55.335  37.321  46.051  0.00  0.00           N  
ATOM    992  CA  ASP A  66      54.985  36.052  45.383  0.00  0.00           C  
ATOM    993  C   ASP A  66      54.678  34.890  46.355  0.00  0.00           C  
ATOM    994  O   ASP A  66      53.791  34.083  46.076  0.00  0.00           O  
ATOM    995  CB  ASP A  66      56.113  35.626  44.411  0.00  0.00           C  
ATOM    996  CG  ASP A  66      57.364  35.060  45.100  0.00  0.00           C  
ATOM    997  OD1 ASP A  66      57.790  35.656  46.116  0.00  0.00           O  
ATOM    998  OD2 ASP A  66      57.860  34.005  44.652  0.00  0.00           O  
ATOM    999  H   ASP A  66      55.548  37.331  47.037  0.00  0.00           H  
ATOM   1000  HA  ASP A  66      54.084  36.224  44.796  0.00  0.00           H  
ATOM   1001  HB2 ASP A  66      55.708  34.864  43.744  0.00  0.00           H  
ATOM   1002  HB3 ASP A  66      56.408  36.473  43.792  0.00  0.00           H  
ATOM   1003  N   ALA A  67      55.451  34.817  47.451  0.00  0.00           N  
ATOM   1004  CA  ALA A  67      55.656  33.737  48.438  0.00  0.00           C  
ATOM   1005  C   ALA A  67      57.037  33.815  49.126  0.00  0.00           C  
ATOM   1006  O   ALA A  67      57.289  33.126  50.114  0.00  0.00           O  
ATOM   1007  CB  ALA A  67      55.433  32.342  47.833  0.00  0.00           C  
ATOM   1008  H   ALA A  67      56.169  35.531  47.425  0.00  0.00           H  
ATOM   1009  HA  ALA A  67      54.931  33.876  49.238  0.00  0.00           H  
ATOM   1010  HB1 ALA A  67      56.048  32.221  46.941  0.00  0.00           H  
ATOM   1011  HB2 ALA A  67      55.698  31.575  48.561  0.00  0.00           H  
ATOM   1012  HB3 ALA A  67      54.382  32.210  47.578  0.00  0.00           H  
ATOM   1013  N   GLN A  68      57.923  34.691  48.656  0.00  0.00           N  
ATOM   1014  CA  GLN A  68      59.073  35.204  49.381  0.00  0.00           C  
ATOM   1015  C   GLN A  68      58.747  36.628  49.843  0.00  0.00           C  
ATOM   1016  O   GLN A  68      58.893  37.592  49.101  0.00  0.00           O  
ATOM   1017  CB  GLN A  68      60.306  35.062  48.481  0.00  0.00           C  
ATOM   1018  CG  GLN A  68      60.860  33.642  48.662  0.00  0.00           C  
ATOM   1019  CD  GLN A  68      62.111  33.377  47.846  0.00  0.00           C  
ATOM   1020  OE1 GLN A  68      63.154  33.032  48.387  0.00  0.00           O  
ATOM   1021  NE2 GLN A  68      62.053  33.490  46.535  0.00  0.00           N  
ATOM   1022  H   GLN A  68      57.797  35.097  47.726  0.00  0.00           H  
ATOM   1023  HA  GLN A  68      59.237  34.613  50.282  0.00  0.00           H  
ATOM   1024  HB2 GLN A  68      60.044  35.240  47.438  0.00  0.00           H  
ATOM   1025  HB3 GLN A  68      61.065  35.780  48.760  0.00  0.00           H  
ATOM   1026  HG2 GLN A  68      61.108  33.510  49.713  0.00  0.00           H  
ATOM   1027  HG3 GLN A  68      60.099  32.909  48.390  0.00  0.00           H  
ATOM   1028 HE21 GLN A  68      61.202  33.772  46.068  0.00  0.00           H  
ATOM   1029 HE22 GLN A  68      62.916  33.302  46.054  0.00  0.00           H  
ATOM   1030  N   VAL A  69      58.248  36.715  51.080  0.00  0.00           N  
ATOM   1031  CA  VAL A  69      57.715  37.900  51.761  0.00  0.00           C  
ATOM   1032  C   VAL A  69      58.825  38.918  52.074  0.00  0.00           C  
ATOM   1033  O   VAL A  69      59.629  38.689  52.977  0.00  0.00           O  
ATOM   1034  CB  VAL A  69      56.912  37.414  52.998  0.00  0.00           C  
ATOM   1035  CG1 VAL A  69      56.916  38.295  54.252  0.00  0.00           C  
ATOM   1036  CG2 VAL A  69      55.452  37.172  52.590  0.00  0.00           C  
ATOM   1037  H   VAL A  69      58.282  35.864  51.637  0.00  0.00           H  
ATOM   1038  HA  VAL A  69      57.017  38.384  51.082  0.00  0.00           H  
ATOM   1039  HB  VAL A  69      57.311  36.453  53.320  0.00  0.00           H  
ATOM   1040 HG11 VAL A  69      56.583  39.304  54.019  0.00  0.00           H  
ATOM   1041 HG12 VAL A  69      56.273  37.847  55.008  0.00  0.00           H  
ATOM   1042 HG13 VAL A  69      57.912  38.337  54.677  0.00  0.00           H  
ATOM   1043 HG21 VAL A  69      54.974  38.119  52.335  0.00  0.00           H  
ATOM   1044 HG22 VAL A  69      55.411  36.514  51.721  0.00  0.00           H  
ATOM   1045 HG23 VAL A  69      54.910  36.701  53.409  0.00  0.00           H  
ATOM   1046  N   ASP A  70      58.898  40.021  51.319  0.00  0.00           N  
ATOM   1047  CA  ASP A  70      59.725  41.208  51.595  0.00  0.00           C  
ATOM   1048  C   ASP A  70      59.332  41.924  52.912  0.00  0.00           C  
ATOM   1049  O   ASP A  70      58.255  41.702  53.481  0.00  0.00           O  
ATOM   1050  CB  ASP A  70      59.678  42.154  50.369  0.00  0.00           C  
ATOM   1051  CG  ASP A  70      60.315  43.517  50.645  0.00  0.00           C  
ATOM   1052  OD1 ASP A  70      61.518  43.511  50.975  0.00  0.00           O  
ATOM   1053  OD2 ASP A  70      59.566  44.523  50.722  0.00  0.00           O  
ATOM   1054  H   ASP A  70      58.276  40.069  50.502  0.00  0.00           H  
ATOM   1055  HA  ASP A  70      60.761  40.886  51.714  0.00  0.00           H  
ATOM   1056  HB2 ASP A  70      60.204  41.680  49.537  0.00  0.00           H  
ATOM   1057  HB3 ASP A  70      58.651  42.318  50.053  0.00  0.00           H  
ATOM   1058  N   PHE A  71      60.209  42.824  53.391  0.00  0.00           N  
ATOM   1059  CA  PHE A  71      59.982  43.630  54.590  0.00  0.00           C  
ATOM   1060  C   PHE A  71      58.717  44.480  54.474  0.00  0.00           C  
ATOM   1061  O   PHE A  71      58.049  44.675  55.484  0.00  0.00           O  
ATOM   1062  CB  PHE A  71      61.200  44.507  54.932  0.00  0.00           C  
ATOM   1063  CG  PHE A  71      61.446  45.718  54.050  0.00  0.00           C  
ATOM   1064  CD1 PHE A  71      60.767  46.928  54.294  0.00  0.00           C  
ATOM   1065  CD2 PHE A  71      62.384  45.647  53.003  0.00  0.00           C  
ATOM   1066  CE1 PHE A  71      61.013  48.052  53.487  0.00  0.00           C  
ATOM   1067  CE2 PHE A  71      62.630  46.770  52.195  0.00  0.00           C  
ATOM   1068  CZ  PHE A  71      61.943  47.974  52.437  0.00  0.00           C  
ATOM   1069  H   PHE A  71      61.019  43.035  52.805  0.00  0.00           H  
ATOM   1070  HA  PHE A  71      59.829  42.941  55.421  0.00  0.00           H  
ATOM   1071  HB2 PHE A  71      61.080  44.860  55.958  0.00  0.00           H  
ATOM   1072  HB3 PHE A  71      62.099  43.896  54.915  0.00  0.00           H  
ATOM   1073  HD1 PHE A  71      60.043  46.993  55.093  0.00  0.00           H  
ATOM   1074  HD2 PHE A  71      62.906  44.723  52.797  0.00  0.00           H  
ATOM   1075  HE1 PHE A  71      60.482  48.976  53.669  0.00  0.00           H  
ATOM   1076  HE2 PHE A  71      63.336  46.696  51.382  0.00  0.00           H  
ATOM   1077  HZ  PHE A  71      62.127  48.834  51.809  0.00  0.00           H  
ATOM   1078  N   SER A  72      58.373  44.944  53.263  0.00  0.00           N  
ATOM   1079  CA  SER A  72      57.154  45.704  52.960  0.00  0.00           C  
ATOM   1080  C   SER A  72      55.920  44.866  53.287  0.00  0.00           C  
ATOM   1081  O   SER A  72      55.073  45.267  54.080  0.00  0.00           O  
ATOM   1082  CB  SER A  72      57.092  46.121  51.481  0.00  0.00           C  
ATOM   1083  OG  SER A  72      58.344  46.562  50.997  0.00  0.00           O  
ATOM   1084  H   SER A  72      59.003  44.751  52.484  0.00  0.00           H  
ATOM   1085  HA  SER A  72      57.145  46.605  53.569  0.00  0.00           H  
ATOM   1086  HB2 SER A  72      56.776  45.278  50.868  0.00  0.00           H  
ATOM   1087  HB3 SER A  72      56.358  46.920  51.373  0.00  0.00           H  
ATOM   1088  HG  SER A  72      58.914  45.717  50.842  0.00  0.00           H  
ATOM   1089  N   GLU A  73      55.850  43.670  52.703  0.00  0.00           N  
ATOM   1090  CA  GLU A  73      54.762  42.713  52.886  0.00  0.00           C  
ATOM   1091  C   GLU A  73      54.606  42.388  54.372  0.00  0.00           C  
ATOM   1092  O   GLU A  73      53.510  42.485  54.927  0.00  0.00           O  
ATOM   1093  CB  GLU A  73      55.018  41.432  52.069  0.00  0.00           C  
ATOM   1094  CG  GLU A  73      55.849  41.637  50.796  0.00  0.00           C  
ATOM   1095  CD  GLU A  73      55.956  40.390  49.919  0.00  0.00           C  
ATOM   1096  OE1 GLU A  73      55.009  39.575  49.890  0.00  0.00           O  
ATOM   1097  OE2 GLU A  73      57.035  40.241  49.311  0.00  0.00           O  
ATOM   1098  H   GLU A  73      56.628  43.386  52.122  0.00  0.00           H  
ATOM   1099  HA  GLU A  73      53.834  43.171  52.535  0.00  0.00           H  
ATOM   1100  HB2 GLU A  73      55.545  40.705  52.682  0.00  0.00           H  
ATOM   1101  HB3 GLU A  73      54.051  41.014  51.811  0.00  0.00           H  
ATOM   1102  HG2 GLU A  73      55.460  42.463  50.209  0.00  0.00           H  
ATOM   1103  HG3 GLU A  73      56.847  41.925  51.113  0.00  0.00           H  
ATOM   1104  N   PHE A  74      55.732  42.070  55.026  0.00  0.00           N  
ATOM   1105  CA  PHE A  74      55.787  41.806  56.454  0.00  0.00           C  
ATOM   1106  C   PHE A  74      55.296  42.989  57.294  0.00  0.00           C  
ATOM   1107  O   PHE A  74      54.329  42.817  58.023  0.00  0.00           O  
ATOM   1108  CB  PHE A  74      57.187  41.345  56.854  0.00  0.00           C  
ATOM   1109  CG  PHE A  74      57.242  40.799  58.266  0.00  0.00           C  
ATOM   1110  CD1 PHE A  74      56.724  39.517  58.534  0.00  0.00           C  
ATOM   1111  CD2 PHE A  74      57.823  41.551  59.303  0.00  0.00           C  
ATOM   1112  CE1 PHE A  74      56.788  38.990  59.834  0.00  0.00           C  
ATOM   1113  CE2 PHE A  74      57.928  41.005  60.594  0.00  0.00           C  
ATOM   1114  CZ  PHE A  74      57.404  39.726  60.862  0.00  0.00           C  
ATOM   1115  H   PHE A  74      56.595  42.016  54.483  0.00  0.00           H  
ATOM   1116  HA  PHE A  74      55.104  40.987  56.663  0.00  0.00           H  
ATOM   1117  HB2 PHE A  74      57.499  40.552  56.173  0.00  0.00           H  
ATOM   1118  HB3 PHE A  74      57.894  42.169  56.744  0.00  0.00           H  
ATOM   1119  HD1 PHE A  74      56.276  38.936  57.743  0.00  0.00           H  
ATOM   1120  HD2 PHE A  74      58.210  42.540  59.107  0.00  0.00           H  
ATOM   1121  HE1 PHE A  74      56.371  38.015  60.035  0.00  0.00           H  
ATOM   1122  HE2 PHE A  74      58.410  41.572  61.377  0.00  0.00           H  
ATOM   1123  HZ  PHE A  74      57.471  39.309  61.856  0.00  0.00           H  
ATOM   1124  N   ILE A  75      55.916  44.175  57.213  0.00  0.00           N  
ATOM   1125  CA  ILE A  75      55.542  45.338  58.034  0.00  0.00           C  
ATOM   1126  C   ILE A  75      54.074  45.743  57.827  0.00  0.00           C  
ATOM   1127  O   ILE A  75      53.373  45.992  58.811  0.00  0.00           O  
ATOM   1128  CB  ILE A  75      56.533  46.505  57.811  0.00  0.00           C  
ATOM   1129  CG1 ILE A  75      56.465  47.599  58.885  0.00  0.00           C  
ATOM   1130  CG2 ILE A  75      56.368  47.218  56.462  0.00  0.00           C  
ATOM   1131  CD1 ILE A  75      56.867  47.148  60.280  0.00  0.00           C  
ATOM   1132  H   ILE A  75      56.685  44.278  56.552  0.00  0.00           H  
ATOM   1133  HA  ILE A  75      55.634  45.026  59.074  0.00  0.00           H  
ATOM   1134  HB  ILE A  75      57.540  46.084  57.839  0.00  0.00           H  
ATOM   1135 HG12 ILE A  75      57.182  48.361  58.603  0.00  0.00           H  
ATOM   1136 HG13 ILE A  75      55.470  48.044  58.923  0.00  0.00           H  
ATOM   1137 HG21 ILE A  75      57.189  47.918  56.306  0.00  0.00           H  
ATOM   1138 HG22 ILE A  75      56.397  46.493  55.664  0.00  0.00           H  
ATOM   1139 HG23 ILE A  75      55.423  47.761  56.417  0.00  0.00           H  
ATOM   1140 HD11 ILE A  75      57.717  46.474  60.214  0.00  0.00           H  
ATOM   1141 HD12 ILE A  75      57.169  48.015  60.862  0.00  0.00           H  
ATOM   1142 HD13 ILE A  75      56.018  46.668  60.764  0.00  0.00           H  
ATOM   1143  N   VAL A  76      53.591  45.722  56.576  0.00  0.00           N  
ATOM   1144  CA  VAL A  76      52.182  45.948  56.224  0.00  0.00           C  
ATOM   1145  C   VAL A  76      51.288  44.940  56.943  0.00  0.00           C  
ATOM   1146  O   VAL A  76      50.319  45.339  57.585  0.00  0.00           O  
ATOM   1147  CB  VAL A  76      51.984  45.915  54.693  0.00  0.00           C  
ATOM   1148  CG1 VAL A  76      50.505  45.930  54.279  0.00  0.00           C  
ATOM   1149  CG2 VAL A  76      52.641  47.140  54.037  0.00  0.00           C  
ATOM   1150  H   VAL A  76      54.231  45.489  55.817  0.00  0.00           H  
ATOM   1151  HA  VAL A  76      51.883  46.934  56.570  0.00  0.00           H  
ATOM   1152  HB  VAL A  76      52.434  45.005  54.295  0.00  0.00           H  
ATOM   1153 HG11 VAL A  76      50.430  45.954  53.191  0.00  0.00           H  
ATOM   1154 HG12 VAL A  76      49.998  45.032  54.631  0.00  0.00           H  
ATOM   1155 HG13 VAL A  76      50.011  46.809  54.693  0.00  0.00           H  
ATOM   1156 HG21 VAL A  76      53.659  47.276  54.398  0.00  0.00           H  
ATOM   1157 HG22 VAL A  76      52.680  46.995  52.956  0.00  0.00           H  
ATOM   1158 HG23 VAL A  76      52.080  48.045  54.266  0.00  0.00           H  
ATOM   1159  N   PHE A  77      51.614  43.643  56.887  0.00  0.00           N  
ATOM   1160  CA  PHE A  77      50.814  42.639  57.583  0.00  0.00           C  
ATOM   1161  C   PHE A  77      51.096  42.489  59.070  0.00  0.00           C  
ATOM   1162  O   PHE A  77      50.244  41.943  59.754  0.00  0.00           O  
ATOM   1163  CB  PHE A  77      50.845  41.302  56.860  0.00  0.00           C  
ATOM   1164  CG  PHE A  77      49.709  41.242  55.861  0.00  0.00           C  
ATOM   1165  CD1 PHE A  77      49.791  41.933  54.639  0.00  0.00           C  
ATOM   1166  CD2 PHE A  77      48.508  40.604  56.223  0.00  0.00           C  
ATOM   1167  CE1 PHE A  77      48.680  41.969  53.779  0.00  0.00           C  
ATOM   1168  CE2 PHE A  77      47.385  40.673  55.382  0.00  0.00           C  
ATOM   1169  CZ  PHE A  77      47.476  41.342  54.152  0.00  0.00           C  
ATOM   1170  H   PHE A  77      52.417  43.340  56.335  0.00  0.00           H  
ATOM   1171  HA  PHE A  77      49.777  42.976  57.542  0.00  0.00           H  
ATOM   1172  HB2 PHE A  77      51.811  41.177  56.387  0.00  0.00           H  
ATOM   1173  HB3 PHE A  77      50.723  40.489  57.578  0.00  0.00           H  
ATOM   1174  HD1 PHE A  77      50.707  42.432  54.361  0.00  0.00           H  
ATOM   1175  HD2 PHE A  77      48.438  40.055  57.152  0.00  0.00           H  
ATOM   1176  HE1 PHE A  77      48.752  42.465  52.822  0.00  0.00           H  
ATOM   1177  HE2 PHE A  77      46.476  40.159  55.664  0.00  0.00           H  
ATOM   1178  HZ  PHE A  77      46.631  41.346  53.479  0.00  0.00           H  
ATOM   1179  N   VAL A  78      52.160  43.047  59.643  0.00  0.00           N  
ATOM   1180  CA  VAL A  78      52.243  43.183  61.105  0.00  0.00           C  
ATOM   1181  C   VAL A  78      51.149  44.135  61.612  0.00  0.00           C  
ATOM   1182  O   VAL A  78      50.509  43.870  62.633  0.00  0.00           O  
ATOM   1183  CB  VAL A  78      53.650  43.593  61.553  0.00  0.00           C  
ATOM   1184  CG1 VAL A  78      53.679  43.697  63.084  0.00  0.00           C  
ATOM   1185  CG2 VAL A  78      54.687  42.558  61.073  0.00  0.00           C  
ATOM   1186  H   VAL A  78      52.918  43.368  59.041  0.00  0.00           H  
ATOM   1187  HA  VAL A  78      52.052  42.206  61.542  0.00  0.00           H  
ATOM   1188  HB  VAL A  78      53.901  44.566  61.131  0.00  0.00           H  
ATOM   1189 HG11 VAL A  78      53.120  44.574  63.412  0.00  0.00           H  
ATOM   1190 HG12 VAL A  78      53.243  42.804  63.531  0.00  0.00           H  
ATOM   1191 HG13 VAL A  78      54.701  43.799  63.432  0.00  0.00           H  
ATOM   1192 HG21 VAL A  78      54.215  41.690  60.611  0.00  0.00           H  
ATOM   1193 HG22 VAL A  78      55.351  43.019  60.344  0.00  0.00           H  
ATOM   1194 HG23 VAL A  78      55.295  42.206  61.895  0.00  0.00           H  
ATOM   1195  N   ALA A  79      50.843  45.177  60.831  0.00  0.00           N  
ATOM   1196  CA  ALA A  79      49.646  45.998  60.993  0.00  0.00           C  
ATOM   1197  C   ALA A  79      48.333  45.320  60.535  0.00  0.00           C  
ATOM   1198  O   ALA A  79      47.261  45.878  60.751  0.00  0.00           O  
ATOM   1199  CB  ALA A  79      49.878  47.328  60.295  0.00  0.00           C  
ATOM   1200  H   ALA A  79      51.420  45.343  60.012  0.00  0.00           H  
ATOM   1201  HA  ALA A  79      49.532  46.218  62.053  0.00  0.00           H  
ATOM   1202  HB1 ALA A  79      48.959  47.904  60.280  0.00  0.00           H  
ATOM   1203  HB2 ALA A  79      50.199  47.169  59.268  0.00  0.00           H  
ATOM   1204  HB3 ALA A  79      50.634  47.887  60.847  0.00  0.00           H  
ATOM   1205  N   ALA A  80      48.366  44.095  60.001  0.00  0.00           N  
ATOM   1206  CA  ALA A  80      47.177  43.250  59.866  0.00  0.00           C  
ATOM   1207  C   ALA A  80      47.063  42.234  61.015  0.00  0.00           C  
ATOM   1208  O   ALA A  80      45.961  42.002  61.497  0.00  0.00           O  
ATOM   1209  CB  ALA A  80      47.196  42.548  58.512  0.00  0.00           C  
ATOM   1210  H   ALA A  80      49.265  43.676  59.814  0.00  0.00           H  
ATOM   1211  HA  ALA A  80      46.284  43.877  59.885  0.00  0.00           H  
ATOM   1212  HB1 ALA A  80      46.246  42.037  58.350  0.00  0.00           H  
ATOM   1213  HB2 ALA A  80      47.350  43.275  57.713  0.00  0.00           H  
ATOM   1214  HB3 ALA A  80      47.995  41.815  58.504  0.00  0.00           H  
ATOM   1215  N   ILE A  81      48.184  41.682  61.495  0.00  0.00           N  
ATOM   1216  CA  ILE A  81      48.352  40.728  62.603  0.00  0.00           C  
ATOM   1217  C   ILE A  81      47.725  41.271  63.890  0.00  0.00           C  
ATOM   1218  O   ILE A  81      46.938  40.572  64.519  0.00  0.00           O  
ATOM   1219  CB  ILE A  81      49.866  40.404  62.732  0.00  0.00           C  
ATOM   1220  CG1 ILE A  81      50.420  39.397  61.681  0.00  0.00           C  
ATOM   1221  CG2 ILE A  81      50.318  39.962  64.133  0.00  0.00           C  
ATOM   1222  CD1 ILE A  81      49.481  38.876  60.579  0.00  0.00           C  
ATOM   1223  H   ILE A  81      49.026  41.889  60.966  0.00  0.00           H  
ATOM   1224  HA  ILE A  81      47.815  39.810  62.368  0.00  0.00           H  
ATOM   1225  HB  ILE A  81      50.389  41.341  62.569  0.00  0.00           H  
ATOM   1226 HG12 ILE A  81      51.279  39.859  61.194  0.00  0.00           H  
ATOM   1227 HG13 ILE A  81      50.797  38.514  62.192  0.00  0.00           H  
ATOM   1228 HG21 ILE A  81      51.402  39.847  64.144  0.00  0.00           H  
ATOM   1229 HG22 ILE A  81      50.060  40.700  64.891  0.00  0.00           H  
ATOM   1230 HG23 ILE A  81      49.863  39.013  64.390  0.00  0.00           H  
ATOM   1231 HD11 ILE A  81      48.707  38.246  61.016  0.00  0.00           H  
ATOM   1232 HD12 ILE A  81      49.024  39.691  60.024  0.00  0.00           H  
ATOM   1233 HD13 ILE A  81      50.060  38.284  59.873  0.00  0.00           H  
ATOM   1234  N   THR A  82      47.974  42.542  64.223  0.00  0.00           N  
ATOM   1235  CA  THR A  82      47.207  43.302  65.227  0.00  0.00           C  
ATOM   1236  C   THR A  82      45.686  43.138  65.055  0.00  0.00           C  
ATOM   1237  O   THR A  82      44.992  42.700  65.976  0.00  0.00           O  
ATOM   1238  CB  THR A  82      47.627  44.781  65.196  0.00  0.00           C  
ATOM   1239  OG1 THR A  82      46.832  45.545  66.066  0.00  0.00           O  
ATOM   1240  CG2 THR A  82      47.539  45.439  63.825  0.00  0.00           C  
ATOM   1241  H   THR A  82      48.681  43.021  63.673  0.00  0.00           H  
ATOM   1242  HA  THR A  82      47.455  42.911  66.215  0.00  0.00           H  
ATOM   1243  HB  THR A  82      48.666  44.842  65.512  0.00  0.00           H  
ATOM   1244  HG1 THR A  82      47.337  45.673  66.881  0.00  0.00           H  
ATOM   1245 HG21 THR A  82      48.094  46.370  63.845  0.00  0.00           H  
ATOM   1246 HG22 THR A  82      47.989  44.799  63.074  0.00  0.00           H  
ATOM   1247 HG23 THR A  82      46.507  45.652  63.555  0.00  0.00           H  
ATOM   1248  N   SER A  83      45.177  43.418  63.849  0.00  0.00           N  
ATOM   1249  CA  SER A  83      43.769  43.299  63.464  0.00  0.00           C  
ATOM   1250  C   SER A  83      43.276  41.849  63.290  0.00  0.00           C  
ATOM   1251  O   SER A  83      42.076  41.625  63.137  0.00  0.00           O  
ATOM   1252  CB  SER A  83      43.496  44.117  62.198  0.00  0.00           C  
ATOM   1253  OG  SER A  83      43.918  43.436  61.033  0.00  0.00           O  
ATOM   1254  H   SER A  83      45.829  43.725  63.140  0.00  0.00           H  
ATOM   1255  HA  SER A  83      43.192  43.761  64.261  0.00  0.00           H  
ATOM   1256  HB2 SER A  83      42.424  44.303  62.122  0.00  0.00           H  
ATOM   1257  HB3 SER A  83      44.006  45.079  62.270  0.00  0.00           H  
ATOM   1258  HG  SER A  83      44.703  42.869  61.234  0.00  0.00           H  
ATOM   1259  N   ALA A  84      44.168  40.857  63.346  0.00  0.00           N  
ATOM   1260  CA  ALA A  84      43.836  39.443  63.432  0.00  0.00           C  
ATOM   1261  C   ALA A  84      43.718  39.046  64.910  0.00  0.00           C  
ATOM   1262  O   ALA A  84      42.647  38.636  65.349  0.00  0.00           O  
ATOM   1263  CB  ALA A  84      44.886  38.629  62.665  0.00  0.00           C  
ATOM   1264  H   ALA A  84      45.149  41.112  63.387  0.00  0.00           H  
ATOM   1265  HA  ALA A  84      42.870  39.266  62.960  0.00  0.00           H  
ATOM   1266  HB1 ALA A  84      44.596  37.578  62.657  0.00  0.00           H  
ATOM   1267  HB2 ALA A  84      44.948  38.988  61.635  0.00  0.00           H  
ATOM   1268  HB3 ALA A  84      45.862  38.728  63.131  0.00  0.00           H  
ATOM   1269  N   SER A  85      44.771  39.252  65.710  0.00  0.00           N  
ATOM   1270  CA  SER A  85      44.769  38.977  67.150  0.00  0.00           C  
ATOM   1271  C   SER A  85      43.646  39.708  67.887  0.00  0.00           C  
ATOM   1272  O   SER A  85      43.015  39.114  68.758  0.00  0.00           O  
ATOM   1273  CB  SER A  85      46.126  39.328  67.762  0.00  0.00           C  
ATOM   1274  OG  SER A  85      47.090  38.431  67.270  0.00  0.00           O  
ATOM   1275  H   SER A  85      45.634  39.614  65.304  0.00  0.00           H  
ATOM   1276  HA  SER A  85      44.609  37.907  67.293  0.00  0.00           H  
ATOM   1277  HB2 SER A  85      46.401  40.351  67.501  0.00  0.00           H  
ATOM   1278  HB3 SER A  85      46.078  39.232  68.847  0.00  0.00           H  
ATOM   1279  HG  SER A  85      48.040  38.841  67.436  0.00  0.00           H  
ATOM   1280  N   HIS A  86      43.316  40.961  67.536  0.00  0.00           N  
ATOM   1281  CA  HIS A  86      42.192  41.633  68.197  0.00  0.00           C  
ATOM   1282  C   HIS A  86      40.805  41.030  67.890  0.00  0.00           C  
ATOM   1283  O   HIS A  86      39.861  41.381  68.592  0.00  0.00           O  
ATOM   1284  CB  HIS A  86      42.243  43.163  68.036  0.00  0.00           C  
ATOM   1285  CG  HIS A  86      41.484  43.756  66.876  0.00  0.00           C  
ATOM   1286  ND1 HIS A  86      40.866  44.985  66.852  0.00  0.00           N  
ATOM   1287  CD2 HIS A  86      41.241  43.166  65.672  0.00  0.00           C  
ATOM   1288  CE1 HIS A  86      40.289  45.143  65.653  0.00  0.00           C  
ATOM   1289  NE2 HIS A  86      40.492  44.054  64.892  0.00  0.00           N  
ATOM   1290  H   HIS A  86      43.889  41.470  66.863  0.00  0.00           H  
ATOM   1291  HA  HIS A  86      42.343  41.465  69.259  0.00  0.00           H  
ATOM   1292  HB2 HIS A  86      41.814  43.591  68.943  0.00  0.00           H  
ATOM   1293  HB3 HIS A  86      43.282  43.487  67.982  0.00  0.00           H  
ATOM   1294  HD1 HIS A  86      40.700  45.634  67.640  0.00  0.00           H  
ATOM   1295  HD2 HIS A  86      41.573  42.182  65.395  0.00  0.00           H  
ATOM   1296  HE1 HIS A  86      39.704  46.006  65.362  0.00  0.00           H  
ATOM   1297  N   LYS A  87      40.661  40.096  66.922  0.00  0.00           N  
ATOM   1298  CA  LYS A  87      39.414  39.330  66.707  0.00  0.00           C  
ATOM   1299  C   LYS A  87      39.077  38.448  67.915  0.00  0.00           C  
ATOM   1300  O   LYS A  87      37.904  38.284  68.229  0.00  0.00           O  
ATOM   1301  CB  LYS A  87      39.508  38.423  65.464  0.00  0.00           C  
ATOM   1302  CG  LYS A  87      39.733  39.113  64.105  0.00  0.00           C  
ATOM   1303  CD  LYS A  87      38.512  39.885  63.578  0.00  0.00           C  
ATOM   1304  CE  LYS A  87      38.524  41.365  63.978  0.00  0.00           C  
ATOM   1305  NZ  LYS A  87      39.430  42.162  63.120  0.00  0.00           N  
ATOM   1306  H   LYS A  87      41.484  39.796  66.401  0.00  0.00           H  
ATOM   1307  HA  LYS A  87      38.580  40.021  66.589  0.00  0.00           H  
ATOM   1308  HB2 LYS A  87      40.316  37.707  65.618  0.00  0.00           H  
ATOM   1309  HB3 LYS A  87      38.590  37.835  65.395  0.00  0.00           H  
ATOM   1310  HG2 LYS A  87      40.600  39.767  64.157  0.00  0.00           H  
ATOM   1311  HG3 LYS A  87      39.961  38.327  63.383  0.00  0.00           H  
ATOM   1312  HD2 LYS A  87      38.490  39.812  62.489  0.00  0.00           H  
ATOM   1313  HD3 LYS A  87      37.600  39.419  63.955  0.00  0.00           H  
ATOM   1314  HE2 LYS A  87      37.510  41.762  63.897  0.00  0.00           H  
ATOM   1315  HE3 LYS A  87      38.838  41.446  65.022  0.00  0.00           H  
ATOM   1316  HZ1 LYS A  87      39.594  43.075  63.545  0.00  0.00           H  
ATOM   1317  HZ2 LYS A  87      40.363  41.740  63.076  0.00  0.00           H  
ATOM   1318  HZ3 LYS A  87      39.075  42.273  62.181  0.00  0.00           H  
ATOM   1319  N   TYR A  88      40.112  37.913  68.575  0.00  0.00           N  
ATOM   1320  CA  TYR A  88      40.135  37.242  69.877  0.00  0.00           C  
ATOM   1321  C   TYR A  88      41.594  36.857  70.171  0.00  0.00           C  
ATOM   1322  O   TYR A  88      42.134  35.980  69.497  0.00  0.00           O  
ATOM   1323  CB  TYR A  88      39.225  36.002  69.936  0.00  0.00           C  
ATOM   1324  CG  TYR A  88      39.112  35.446  71.344  0.00  0.00           C  
ATOM   1325  CD1 TYR A  88      40.124  34.609  71.857  0.00  0.00           C  
ATOM   1326  CD2 TYR A  88      38.028  35.820  72.164  0.00  0.00           C  
ATOM   1327  CE1 TYR A  88      40.064  34.164  73.190  0.00  0.00           C  
ATOM   1328  CE2 TYR A  88      37.953  35.360  73.491  0.00  0.00           C  
ATOM   1329  CZ  TYR A  88      38.973  34.532  74.006  0.00  0.00           C  
ATOM   1330  OH  TYR A  88      38.966  34.190  75.319  0.00  0.00           O  
ATOM   1331  H   TYR A  88      41.022  38.113  68.176  0.00  0.00           H  
ATOM   1332  HA  TYR A  88      39.782  37.935  70.634  0.00  0.00           H  
ATOM   1333  HB2 TYR A  88      38.220  36.260  69.604  0.00  0.00           H  
ATOM   1334  HB3 TYR A  88      39.601  35.229  69.265  0.00  0.00           H  
ATOM   1335  HD1 TYR A  88      40.970  34.328  71.243  0.00  0.00           H  
ATOM   1336  HD2 TYR A  88      37.257  36.478  71.785  0.00  0.00           H  
ATOM   1337  HE1 TYR A  88      40.858  33.556  73.597  0.00  0.00           H  
ATOM   1338  HE2 TYR A  88      37.137  35.653  74.136  0.00  0.00           H  
ATOM   1339  HH  TYR A  88      39.631  34.775  75.756  0.00  0.00           H  
ATOM   1340  N   PHE A  89      42.238  37.517  71.144  0.00  0.00           N  
ATOM   1341  CA  PHE A  89      43.592  37.150  71.579  0.00  0.00           C  
ATOM   1342  C   PHE A  89      43.477  36.244  72.813  0.00  0.00           C  
ATOM   1343  O   PHE A  89      43.366  35.029  72.684  0.00  0.00           O  
ATOM   1344  CB  PHE A  89      44.490  38.389  71.785  0.00  0.00           C  
ATOM   1345  CG  PHE A  89      45.879  38.001  72.267  0.00  0.00           C  
ATOM   1346  CD1 PHE A  89      46.701  37.206  71.446  0.00  0.00           C  
ATOM   1347  CD2 PHE A  89      46.293  38.299  73.580  0.00  0.00           C  
ATOM   1348  CE1 PHE A  89      47.875  36.634  71.964  0.00  0.00           C  
ATOM   1349  CE2 PHE A  89      47.461  37.715  74.105  0.00  0.00           C  
ATOM   1350  CZ  PHE A  89      48.234  36.852  73.306  0.00  0.00           C  
ATOM   1351  H   PHE A  89      41.723  38.201  71.667  0.00  0.00           H  
ATOM   1352  HA  PHE A  89      44.060  36.548  70.799  0.00  0.00           H  
ATOM   1353  HB2 PHE A  89      44.586  38.930  70.845  0.00  0.00           H  
ATOM   1354  HB3 PHE A  89      44.026  39.062  72.503  0.00  0.00           H  
ATOM   1355  HD1 PHE A  89      46.404  36.988  70.429  0.00  0.00           H  
ATOM   1356  HD2 PHE A  89      45.691  38.932  74.214  0.00  0.00           H  
ATOM   1357  HE1 PHE A  89      48.478  35.992  71.333  0.00  0.00           H  
ATOM   1358  HE2 PHE A  89      47.735  37.901  75.134  0.00  0.00           H  
ATOM   1359  HZ  PHE A  89      49.111  36.369  73.717  0.00  0.00           H  
ATOM   1360  N   GLU A  90      43.405  36.847  74.000  0.00  0.00           N  
ATOM   1361  CA  GLU A  90      42.883  36.256  75.230  0.00  0.00           C  
ATOM   1362  C   GLU A  90      41.414  36.662  75.465  0.00  0.00           C  
ATOM   1363  O   GLU A  90      40.669  35.907  76.091  0.00  0.00           O  
ATOM   1364  CB  GLU A  90      43.784  36.655  76.418  0.00  0.00           C  
ATOM   1365  CG  GLU A  90      43.570  38.058  77.027  0.00  0.00           C  
ATOM   1366  CD  GLU A  90      43.861  39.244  76.092  0.00  0.00           C  
ATOM   1367  OE1 GLU A  90      43.273  39.324  74.987  0.00  0.00           O  
ATOM   1368  OE2 GLU A  90      44.611  40.158  76.498  0.00  0.00           O  
ATOM   1369  H   GLU A  90      43.569  37.854  74.049  0.00  0.00           H  
ATOM   1370  HA  GLU A  90      42.914  35.169  75.139  0.00  0.00           H  
ATOM   1371  HB2 GLU A  90      43.603  35.930  77.213  0.00  0.00           H  
ATOM   1372  HB3 GLU A  90      44.829  36.551  76.125  0.00  0.00           H  
ATOM   1373  HG2 GLU A  90      42.545  38.137  77.393  0.00  0.00           H  
ATOM   1374  HG3 GLU A  90      44.216  38.133  77.903  0.00  0.00           H  
ATOM   1375  N   LYS A  91      41.005  37.835  74.946  0.00  0.00           N  
ATOM   1376  CA  LYS A  91      39.652  38.407  75.036  0.00  0.00           C  
ATOM   1377  C   LYS A  91      39.092  38.965  73.718  0.00  0.00           C  
ATOM   1378  O   LYS A  91      37.878  38.951  73.529  0.00  0.00           O  
ATOM   1379  CB  LYS A  91      39.594  39.441  76.197  0.00  0.00           C  
ATOM   1380  CG  LYS A  91      39.588  40.957  75.875  0.00  0.00           C  
ATOM   1381  CD  LYS A  91      40.931  41.604  75.499  0.00  0.00           C  
ATOM   1382  CE  LYS A  91      41.779  41.937  76.732  0.00  0.00           C  
ATOM   1383  NZ  LYS A  91      43.147  42.373  76.364  0.00  0.00           N  
ATOM   1384  H   LYS A  91      41.791  38.431  74.678  0.00  0.00           H  
ATOM   1385  HA  LYS A  91      38.979  37.593  75.308  0.00  0.00           H  
ATOM   1386  HB2 LYS A  91      38.660  39.246  76.724  0.00  0.00           H  
ATOM   1387  HB3 LYS A  91      40.392  39.236  76.913  0.00  0.00           H  
ATOM   1388  HG2 LYS A  91      38.876  41.154  75.078  0.00  0.00           H  
ATOM   1389  HG3 LYS A  91      39.204  41.482  76.750  0.00  0.00           H  
ATOM   1390  HD2 LYS A  91      41.475  40.961  74.814  0.00  0.00           H  
ATOM   1391  HD3 LYS A  91      40.722  42.545  74.989  0.00  0.00           H  
ATOM   1392  HE2 LYS A  91      41.272  42.735  77.282  0.00  0.00           H  
ATOM   1393  HE3 LYS A  91      41.839  41.057  77.377  0.00  0.00           H  
ATOM   1394  HZ1 LYS A  91      43.734  41.544  76.190  0.00  0.00           H  
ATOM   1395  HZ2 LYS A  91      43.151  42.952  75.522  0.00  0.00           H  
ATOM   1396  HZ3 LYS A  91      43.589  42.868  77.121  0.00  0.00           H  
ATOM   1397  N   THR A  92      39.970  39.509  72.862  0.00  0.00           N  
ATOM   1398  CA  THR A  92      39.808  40.500  71.757  0.00  0.00           C  
ATOM   1399  C   THR A  92      40.856  41.587  72.008  0.00  0.00           C  
ATOM   1400  O   THR A  92      40.525  42.669  72.474  0.00  0.00           O  
ATOM   1401  CB  THR A  92      38.400  41.138  71.546  0.00  0.00           C  
ATOM   1402  OG1 THR A  92      37.702  41.369  72.743  0.00  0.00           O  
ATOM   1403  CG2 THR A  92      37.476  40.300  70.666  0.00  0.00           C  
ATOM   1404  H   THR A  92      40.902  39.447  73.240  0.00  0.00           H  
ATOM   1405  HA  THR A  92      40.077  40.032  70.812  0.00  0.00           H  
ATOM   1406  HB  THR A  92      38.521  42.098  71.042  0.00  0.00           H  
ATOM   1407  HG1 THR A  92      37.545  40.471  73.112  0.00  0.00           H  
ATOM   1408 HG21 THR A  92      37.809  40.369  69.634  0.00  0.00           H  
ATOM   1409 HG22 THR A  92      37.468  39.258  70.979  0.00  0.00           H  
ATOM   1410 HG23 THR A  92      36.462  40.700  70.709  0.00  0.00           H  
ATOM   1411  N   GLY A  93      42.141  41.258  71.791  0.00  0.00           N  
ATOM   1412  CA  GLY A  93      43.344  41.924  72.325  0.00  0.00           C  
ATOM   1413  C   GLY A  93      43.197  43.387  72.766  0.00  0.00           C  
ATOM   1414  O   GLY A  93      43.348  43.678  73.955  0.00  0.00           O  
ATOM   1415  H   GLY A  93      42.314  40.382  71.318  0.00  0.00           H  
ATOM   1416  HA2 GLY A  93      43.677  41.358  73.197  0.00  0.00           H  
ATOM   1417  HA3 GLY A  93      44.140  41.871  71.582  0.00  0.00           H  
ATOM   1418  N   LEU A  94      42.880  44.278  71.819  0.00  0.00           N  
ATOM   1419  CA  LEU A  94      42.583  45.701  72.046  0.00  0.00           C  
ATOM   1420  C   LEU A  94      41.118  46.091  71.753  0.00  0.00           C  
ATOM   1421  O   LEU A  94      40.742  47.240  71.984  0.00  0.00           O  
ATOM   1422  CB  LEU A  94      43.566  46.550  71.215  0.00  0.00           C  
ATOM   1423  CG  LEU A  94      43.388  46.400  69.682  0.00  0.00           C  
ATOM   1424  CD1 LEU A  94      43.019  47.727  69.018  0.00  0.00           C  
ATOM   1425  CD2 LEU A  94      44.658  45.840  69.033  0.00  0.00           C  
ATOM   1426  H   LEU A  94      42.786  43.932  70.877  0.00  0.00           H  
ATOM   1427  HA  LEU A  94      42.757  45.938  73.097  0.00  0.00           H  
ATOM   1428  HB2 LEU A  94      43.435  47.596  71.494  0.00  0.00           H  
ATOM   1429  HB3 LEU A  94      44.584  46.276  71.500  0.00  0.00           H  
ATOM   1430  HG  LEU A  94      42.583  45.698  69.475  0.00  0.00           H  
ATOM   1431 HD11 LEU A  94      43.798  48.468  69.178  0.00  0.00           H  
ATOM   1432 HD12 LEU A  94      42.872  47.572  67.949  0.00  0.00           H  
ATOM   1433 HD13 LEU A  94      42.079  48.091  69.437  0.00  0.00           H  
ATOM   1434 HD21 LEU A  94      45.497  46.505  69.221  0.00  0.00           H  
ATOM   1435 HD22 LEU A  94      44.881  44.856  69.445  0.00  0.00           H  
ATOM   1436 HD23 LEU A  94      44.512  45.746  67.956  0.00  0.00           H  
ATOM   1437  N   LYS A  95      40.306  45.138  71.263  0.00  0.00           N  
ATOM   1438  CA  LYS A  95      39.008  45.332  70.599  0.00  0.00           C  
ATOM   1439  C   LYS A  95      39.052  46.557  69.671  0.00  0.00           C  
ATOM   1440  O   LYS A  95      39.903  46.516  68.759  0.00  0.00           O  
ATOM   1441  CB  LYS A  95      37.918  45.320  71.691  0.00  0.00           C  
ATOM   1442  CG  LYS A  95      36.460  45.475  71.208  0.00  0.00           C  
ATOM   1443  CD  LYS A  95      35.615  46.334  72.167  0.00  0.00           C  
ATOM   1444  CE  LYS A  95      35.733  47.856  71.961  0.00  0.00           C  
ATOM   1445  NZ  LYS A  95      37.115  48.377  72.072  0.00  0.00           N  
ATOM   1446  OXT LYS A  95      38.251  47.492  69.872  0.00  0.00           O  
ATOM   1447  H   LYS A  95      40.626  44.185  71.380  0.00  0.00           H  
ATOM   1448  HA  LYS A  95      38.830  44.485  69.939  0.00  0.00           H  
ATOM   1449  HB2 LYS A  95      37.983  44.370  72.227  0.00  0.00           H  
ATOM   1450  HB3 LYS A  95      38.163  46.090  72.418  0.00  0.00           H  
ATOM   1451  HG2 LYS A  95      36.405  45.899  70.206  0.00  0.00           H  
ATOM   1452  HG3 LYS A  95      36.018  44.480  71.149  0.00  0.00           H  
ATOM   1453  HD2 LYS A  95      34.567  46.074  72.009  0.00  0.00           H  
ATOM   1454  HD3 LYS A  95      35.861  46.080  73.200  0.00  0.00           H  
ATOM   1455  HE2 LYS A  95      35.352  48.104  70.967  0.00  0.00           H  
ATOM   1456  HE3 LYS A  95      35.100  48.359  72.696  0.00  0.00           H  
ATOM   1457  HZ1 LYS A  95      37.665  48.043  71.268  0.00  0.00           H  
ATOM   1458  HZ2 LYS A  95      37.109  49.396  71.991  0.00  0.00           H  
ATOM   1459  HZ3 LYS A  95      37.577  48.099  72.921  0.00  0.00           H  
TER    1460      LYS A  95                                                      
END
MOLECULE T0510_166_234.pdb
ATOM   1246  N   GLN   166      63.833  26.217  70.711  1.00 82.23           N  
ATOM   1247  CA  GLN   166      64.911  26.599  69.853  1.00 82.71           C  
ATOM   1248  CB  GLN   166      64.584  26.346  68.391  1.00 83.43           C  
ATOM   1249  CG  GLN   166      65.557  27.031  67.420  1.00 84.04           C  
ATOM   1250  CD  GLN   166      66.187  26.085  66.393  1.00 85.23           C  
ATOM   1251  OE1 GLN   166      66.303  26.427  65.214  1.00 89.14           O  
ATOM   1252  NE2 GLN   166      66.606  24.903  66.842  1.00 86.32           N  
ATOM   1253  C   GLN   166      65.103  28.059  70.110  1.00 82.10           C  
ATOM   1254  O   GLN   166      65.514  28.802  69.254  1.00 82.11           O  
ATOM   1255  N   HIS   167      64.799  28.492  71.309  1.00 81.41           N  
ATOM   1256  CA  HIS   167      64.931  29.894  71.548  1.00 79.88           C  
ATOM   1257  CB  HIS   167      66.393  30.283  71.564  1.00 81.38           C  
ATOM   1258  C   HIS   167      64.271  30.536  70.371  1.00 75.02           C  
ATOM   1259  O   HIS   167      64.921  31.013  69.465  1.00 74.94           O  
ATOM   1260  N   LYS   168      62.956  30.528  70.391  1.00 69.80           N  
ATOM   1261  CA  LYS   168      62.182  31.163  69.375  1.00 65.51           C  
ATOM   1262  CB  LYS   168      60.985  30.305  69.049  1.00 65.08           C  
ATOM   1263  CG  LYS   168      61.320  29.019  68.389  1.00 63.18           C  
ATOM   1264  CD  LYS   168      60.253  28.638  67.420  1.00 61.15           C  
ATOM   1265  CE  LYS   168      60.114  27.171  67.291  1.00 59.96           C  
ATOM   1266  NZ  LYS   168      60.476  26.681  65.970  1.00 54.43           N  
ATOM   1267  C   LYS   168      61.736  32.456  69.982  1.00 64.26           C  
ATOM   1268  O   LYS   168      62.017  32.714  71.123  1.00 63.98           O  
ATOM   1269  N   ILE   169      61.045  33.277  69.213  1.00 61.69           N  
ATOM   1270  CA  ILE   169      60.585  34.551  69.694  1.00 60.60           C  
ATOM   1271  CB  ILE   169      61.019  35.662  68.791  1.00 60.03           C  
ATOM   1272  CG1 ILE   169      62.522  35.759  68.786  1.00 59.71           C  
ATOM   1273  CD1 ILE   169      63.129  35.486  67.475  1.00 60.27           C  
ATOM   1274  CG2 ILE   169      60.500  36.941  69.296  1.00 59.13           C  
ATOM   1275  C   ILE   169      59.089  34.560  69.755  1.00 59.72           C  
ATOM   1276  O   ILE   169      58.438  33.855  69.027  1.00 59.04           O  
ATOM   1277  N   ASN   170      58.549  35.351  70.660  1.00 58.73           N  
ATOM   1278  CA  ASN   170      57.110  35.466  70.808  1.00 58.04           C  
ATOM   1279  CB  ASN   170      56.689  35.815  72.249  1.00 57.08           C  
ATOM   1280  CG  ASN   170      55.149  35.728  72.485  1.00 58.65           C  
ATOM   1281  OD1 ASN   170      54.316  36.116  71.650  1.00 62.59           O  
ATOM   1282  ND2 ASN   170      54.776  35.201  73.630  1.00 60.85           N  
ATOM   1283  C   ASN   170      56.633  36.520  69.770  1.00 57.38           C  
ATOM   1284  O   ASN   170      56.973  37.717  69.840  1.00 56.01           O  
ATOM   1285  N   PRO   171      55.849  36.056  68.789  1.00 56.90           N  
ATOM   1286  CA  PRO   171      55.367  36.937  67.802  1.00 57.10           C  
ATOM   1287  CB  PRO   171      54.419  36.076  66.990  1.00 56.60           C  
ATOM   1288  CG  PRO   171      54.150  34.955  67.780  1.00 57.11           C  
ATOM   1289  CD  PRO   171      55.364  34.698  68.538  1.00 57.22           C  
ATOM   1290  C   PRO   171      54.626  38.081  68.399  1.00 57.21           C  
ATOM   1291  O   PRO   171      54.505  39.109  67.740  1.00 59.25           O  
ATOM   1292  N   TYR   172      54.119  37.963  69.612  1.00 56.42           N  
ATOM   1293  CA  TYR   172      53.460  39.126  70.161  1.00 55.94           C  
ATOM   1294  CB  TYR   172      52.469  38.742  71.225  1.00 55.58           C  
ATOM   1295  CG  TYR   172      51.335  38.012  70.645  1.00 54.93           C  
ATOM   1296  CD1 TYR   172      50.325  38.713  69.986  1.00 56.22           C  
ATOM   1297  CE1 TYR   172      49.269  38.079  69.383  1.00 55.35           C  
ATOM   1298  CZ  TYR   172      49.197  36.714  69.449  1.00 56.18           C  
ATOM   1299  OH  TYR   172      48.134  36.123  68.864  1.00 55.80           O  
ATOM   1300  CE2 TYR   172      50.177  35.961  70.112  1.00 56.67           C  
ATOM   1301  CD2 TYR   172      51.256  36.632  70.713  1.00 55.81           C  
ATOM   1302  C   TYR   172      54.440  40.143  70.678  1.00 56.09           C  
ATOM   1303  O   TYR   172      54.041  41.229  70.922  1.00 56.96           O  
ATOM   1304  N   ASP   173      55.722  39.824  70.827  1.00 56.70           N  
ATOM   1305  CA  ASP   173      56.677  40.762  71.464  1.00 56.94           C  
ATOM   1306  CB  ASP   173      57.619  39.987  72.378  1.00 57.07           C  
ATOM   1307  CG  ASP   173      56.891  39.343  73.584  1.00 59.70           C  
ATOM   1308  OD1 ASP   173      55.715  39.682  73.957  1.00 60.73           O  
ATOM   1309  OD2 ASP   173      57.534  38.458  74.189  1.00 64.57           O  
ATOM   1310  C   ASP   173      57.504  41.542  70.452  1.00 57.10           C  
ATOM   1311  O   ASP   173      58.517  42.160  70.764  1.00 56.92           O  
ATOM   1312  N   ILE   174      57.061  41.519  69.208  1.00 57.50           N  
ATOM   1313  CA  ILE   174      57.918  41.926  68.107  1.00 56.84           C  
ATOM   1314  CB  ILE   174      58.589  40.690  67.518  1.00 56.70           C  
ATOM   1315  CG1 ILE   174      59.599  41.092  66.467  1.00 57.77           C  
ATOM   1316  CD1 ILE   174      60.661  40.028  66.250  1.00 57.91           C  
ATOM   1317  CG2 ILE   174      57.544  39.699  66.969  1.00 55.22           C  
ATOM   1318  C   ILE   174      57.023  42.643  67.120  1.00 56.45           C  
ATOM   1319  O   ILE   174      55.813  42.344  67.064  1.00 56.87           O  
ATOM   1320  N   THR   175      57.575  43.650  66.447  1.00 55.75           N  
ATOM   1321  CA  THR   175      56.850  44.351  65.389  1.00 55.67           C  
ATOM   1322  CB  THR   175      57.084  45.848  65.362  1.00 55.12           C  
ATOM   1323  OG1 THR   175      58.475  46.140  65.204  1.00 51.68           O  
ATOM   1324  CG2 THR   175      56.585  46.411  66.591  1.00 53.75           C  
ATOM   1325  C   THR   175      57.308  43.811  64.061  1.00 56.37           C  
ATOM   1326  O   THR   175      58.357  43.136  63.971  1.00 56.76           O  
ATOM   1327  N   GLY   176      56.532  44.115  63.029  1.00 55.97           N  
ATOM   1328  CA  GLY   176      56.877  43.622  61.697  1.00 55.00           C  
ATOM   1329  C   GLY   176      58.209  44.171  61.236  1.00 54.36           C  
ATOM   1330  O   GLY   176      59.011  43.437  60.620  1.00 53.31           O  
ATOM   1331  N   ALA   177      58.447  45.467  61.523  1.00 53.85           N  
ATOM   1332  CA  ALA   177      59.708  46.112  61.110  1.00 53.00           C  
ATOM   1333  CB  ALA   177      59.786  47.477  61.598  1.00 51.26           C  
ATOM   1334  C   ALA   177      60.852  45.297  61.675  1.00 53.34           C  
ATOM   1335  O   ALA   177      61.852  45.152  61.021  1.00 53.45           O  
ATOM   1336  N   GLU   178      60.654  44.743  62.890  1.00 53.75           N  
ATOM   1337  CA  GLU   178      61.667  44.026  63.674  1.00 53.30           C  
ATOM   1338  CB  GLU   178      61.261  43.985  65.162  1.00 54.23           C  
ATOM   1339  CG  GLU   178      61.696  45.215  65.982  1.00 55.75           C  
ATOM   1340  CD  GLU   178      60.861  45.500  67.251  1.00 55.56           C  
ATOM   1341  OE1 GLU   178      59.978  44.704  67.638  1.00 59.89           O  
ATOM   1342  OE2 GLU   178      61.094  46.567  67.857  1.00 58.55           O  
ATOM   1343  C   GLU   178      61.886  42.594  63.224  1.00 52.73           C  
ATOM   1344  O   GLU   178      63.013  42.111  63.291  1.00 53.74           O  
ATOM   1345  N   VAL   179      60.813  41.916  62.800  1.00 51.25           N  
ATOM   1346  CA  VAL   179      60.897  40.591  62.128  1.00 49.92           C  
ATOM   1347  CB  VAL   179      59.570  40.200  61.494  1.00 49.14           C  
ATOM   1348  CG1 VAL   179      59.636  38.784  61.000  1.00 49.19           C  
ATOM   1349  CG2 VAL   179      58.408  40.363  62.472  1.00 48.28           C  
ATOM   1350  C   VAL   179      61.975  40.492  61.036  1.00 48.85           C  
ATOM   1351  O   VAL   179      62.642  39.467  60.876  1.00 47.13           O  
ATOM   1352  N   LEU   180      62.169  41.579  60.302  1.00 49.16           N  
ATOM   1353  CA  LEU   180      63.079  41.552  59.170  1.00 49.72           C  
ATOM   1354  CB  LEU   180      63.224  42.904  58.525  1.00 47.84           C  
ATOM   1355  CG  LEU   180      61.920  43.407  57.910  1.00 46.38           C  
ATOM   1356  CD1 LEU   180      62.200  44.695  57.167  1.00 39.97           C  
ATOM   1357  CD2 LEU   180      61.195  42.326  57.003  1.00 40.86           C  
ATOM   1358  C   LEU   180      64.403  41.027  59.583  1.00 50.70           C  
ATOM   1359  O   LEU   180      64.941  40.181  58.908  1.00 50.63           O  
ATOM   1360  N   LYS   181      64.910  41.478  60.719  1.00 52.87           N  
ATOM   1361  CA  LYS   181      66.191  40.964  61.229  1.00 54.42           C  
ATOM   1362  CB  LYS   181      66.333  41.296  62.706  1.00 54.78           C  
ATOM   1363  CG  LYS   181      66.629  42.753  62.979  1.00 56.92           C  
ATOM   1364  CD  LYS   181      66.939  43.007  64.479  1.00 57.59           C  
ATOM   1365  CE  LYS   181      65.723  42.667  65.413  1.00 60.72           C  
ATOM   1366  NZ  LYS   181      64.692  43.742  65.242  1.00 63.49           N  
ATOM   1367  C   LYS   181      66.395  39.454  61.091  1.00 54.56           C  
ATOM   1368  O   LYS   181      67.513  38.992  60.961  1.00 53.84           O  
ATOM   1369  N   TYR   182      65.318  38.689  61.150  1.00 56.05           N  
ATOM   1370  CA  TYR   182      65.417  37.223  61.204  1.00 57.04           C  
ATOM   1371  CB  TYR   182      64.478  36.678  62.328  1.00 59.52           C  
ATOM   1372  CG  TYR   182      64.688  37.390  63.652  1.00 60.32           C  
ATOM   1373  CD1 TYR   182      65.790  37.088  64.436  1.00 61.47           C  
ATOM   1374  CE1 TYR   182      66.044  37.769  65.650  1.00 63.73           C  
ATOM   1375  CZ  TYR   182      65.181  38.784  66.088  1.00 64.96           C  
ATOM   1376  OH  TYR   182      65.488  39.453  67.297  1.00 62.03           O  
ATOM   1377  CE2 TYR   182      64.043  39.109  65.279  1.00 64.00           C  
ATOM   1378  CD2 TYR   182      63.811  38.402  64.084  1.00 62.05           C  
ATOM   1379  C   TYR   182      65.094  36.516  59.878  1.00 57.36           C  
ATOM   1380  O   TYR   182      64.900  35.300  59.881  1.00 57.75           O  
ATOM   1381  N   ILE   183      64.992  37.277  58.773  1.00 56.78           N  
ATOM   1382  CA  ILE   183      64.573  36.766  57.444  1.00 55.82           C  
ATOM   1383  CB  ILE   183      63.312  37.439  56.967  1.00 55.21           C  
ATOM   1384  CG1 ILE   183      62.159  37.146  57.930  1.00 54.19           C  
ATOM   1385  CD1 ILE   183      61.775  35.692  58.042  1.00 51.90           C  
ATOM   1386  CG2 ILE   183      63.034  36.990  55.548  1.00 55.52           C  
ATOM   1387  C   ILE   183      65.604  37.086  56.379  1.00 55.41           C  
ATOM   1388  O   ILE   183      65.993  38.241  56.234  1.00 55.89           O  
ATOM   1389  N   ASP   184      66.055  36.064  55.660  1.00 54.86           N  
ATOM   1390  CA  ASP   184      66.911  36.236  54.501  1.00 54.65           C  
ATOM   1391  CB  ASP   184      68.000  35.172  54.504  1.00 54.51           C  
ATOM   1392  CG  ASP   184      68.901  35.213  53.276  1.00 56.25           C  
ATOM   1393  OD1 ASP   184      68.569  35.845  52.234  1.00 60.63           O  
ATOM   1394  OD2 ASP   184      69.958  34.561  53.341  1.00 59.14           O  
ATOM   1395  C   ASP   184      65.980  36.099  53.285  1.00 54.37           C  
ATOM   1396  O   ASP   184      65.494  35.021  52.990  1.00 54.47           O  
ATOM   1397  N   PHE   185      65.689  37.193  52.602  1.00 53.46           N  
ATOM   1398  CA  PHE   185      64.734  37.104  51.528  1.00 53.40           C  
ATOM   1399  CB  PHE   185      64.352  38.502  51.076  1.00 53.07           C  
ATOM   1400  CG  PHE   185      63.298  39.126  51.909  1.00 52.32           C  
ATOM   1401  CD1 PHE   185      63.622  39.974  52.937  1.00 53.28           C  
ATOM   1402  CE1 PHE   185      62.621  40.550  53.704  1.00 53.55           C  
ATOM   1403  CZ  PHE   185      61.290  40.261  53.454  1.00 52.75           C  
ATOM   1404  CE2 PHE   185      60.965  39.413  52.458  1.00 52.74           C  
ATOM   1405  CD2 PHE   185      61.965  38.848  51.677  1.00 52.79           C  
ATOM   1406  C   PHE   185      65.292  36.261  50.366  1.00 53.48           C  
ATOM   1407  O   PHE   185      64.534  35.574  49.655  1.00 52.94           O  
ATOM   1408  N   ASN   186      66.620  36.289  50.214  1.00 53.44           N  
ATOM   1409  CA  ASN   186      67.276  35.505  49.190  1.00 53.70           C  
ATOM   1410  CB  ASN   186      68.763  35.846  49.068  1.00 53.36           C  
ATOM   1411  CG  ASN   186      69.053  37.329  49.045  1.00 52.80           C  
ATOM   1412  OD1 ASN   186      68.879  38.015  48.037  1.00 53.85           O  
ATOM   1413  ND2 ASN   186      69.581  37.816  50.143  1.00 50.90           N  
ATOM   1414  C   ASN   186      67.196  33.990  49.427  1.00 54.10           C  
ATOM   1415  O   ASN   186      67.575  33.221  48.548  1.00 53.83           O  
ATOM   1416  N   ALA   187      66.732  33.553  50.595  1.00 54.69           N  
ATOM   1417  CA  ALA   187      66.945  32.167  50.996  1.00 55.09           C  
ATOM   1418  CB  ALA   187      66.912  32.010  52.473  1.00 54.22           C  
ATOM   1419  C   ALA   187      66.025  31.153  50.271  1.00 56.70           C  
ATOM   1420  O   ALA   187      66.495  30.044  49.982  1.00 57.59           O  
ATOM   1421  N   GLY   188      64.731  31.410  50.058  1.00 57.62           N  
ATOM   1422  CA  GLY   188      63.853  31.960  51.043  1.00 59.02           C  
ATOM   1423  C   GLY   188      62.511  31.219  50.981  1.00 59.74           C  
ATOM   1424  O   GLY   188      61.723  31.467  50.074  1.00 61.22           O  
ATOM   1425  N   ASN   189      62.211  30.293  51.881  1.00 59.50           N  
ATOM   1426  CA  ASN   189      60.813  29.870  51.972  1.00 59.43           C  
ATOM   1427  CB  ASN   189      60.668  28.385  52.248  1.00 60.14           C  
ATOM   1428  CG  ASN   189      61.261  27.525  51.126  1.00 63.26           C  
ATOM   1429  OD1 ASN   189      60.745  27.503  50.000  1.00 69.09           O  
ATOM   1430  ND2 ASN   189      62.350  26.821  51.426  1.00 64.80           N  
ATOM   1431  C   ASN   189      60.293  30.684  53.108  1.00 58.76           C  
ATOM   1432  O   ASN   189      60.330  30.263  54.271  1.00 58.80           O  
ATOM   1433  N   ILE   190      59.854  31.888  52.803  1.00 57.34           N  
ATOM   1434  CA  ILE   190      59.455  32.763  53.879  1.00 56.55           C  
ATOM   1435  CB  ILE   190      58.825  34.052  53.346  1.00 56.31           C  
ATOM   1436  CG1 ILE   190      59.806  34.830  52.424  1.00 54.63           C  
ATOM   1437  CD1 ILE   190      61.277  34.745  52.731  1.00 53.57           C  
ATOM   1438  CG2 ILE   190      58.330  34.938  54.487  1.00 56.75           C  
ATOM   1439  C   ILE   190      58.560  32.078  54.944  1.00 56.38           C  
ATOM   1440  O   ILE   190      58.859  32.153  56.122  1.00 57.24           O  
ATOM   1441  N   ALA   191      57.514  31.365  54.574  1.00 55.84           N  
ATOM   1442  CA  ALA   191      56.737  30.678  55.600  1.00 55.62           C  
ATOM   1443  CB  ALA   191      55.619  29.905  55.014  1.00 54.96           C  
ATOM   1444  C   ALA   191      57.597  29.783  56.478  1.00 55.39           C  
ATOM   1445  O   ALA   191      57.483  29.839  57.693  1.00 55.38           O  
ATOM   1446  N   LYS   192      58.472  28.983  55.886  1.00 55.73           N  
ATOM   1447  CA  LYS   192      59.364  28.075  56.674  1.00 55.84           C  
ATOM   1448  CB  LYS   192      60.210  27.239  55.726  1.00 55.97           C  
ATOM   1449  CG  LYS   192      60.980  26.090  56.341  1.00 57.41           C  
ATOM   1450  CD  LYS   192      62.020  25.514  55.282  1.00 59.41           C  
ATOM   1451  CE  LYS   192      62.867  24.265  55.819  1.00 61.74           C  
ATOM   1452  NZ  LYS   192      63.481  23.500  54.653  1.00 60.86           N  
ATOM   1453  C   LYS   192      60.297  28.797  57.679  1.00 55.26           C  
ATOM   1454  O   LYS   192      60.639  28.287  58.730  1.00 54.68           O  
ATOM   1455  N   GLN   193      60.724  29.987  57.301  1.00 55.35           N  
ATOM   1456  CA  GLN   193      61.585  30.832  58.108  1.00 54.38           C  
ATOM   1457  CB  GLN   193      62.115  31.993  57.244  1.00 53.90           C  
ATOM   1458  CG  GLN   193      63.087  31.554  56.147  1.00 52.93           C  
ATOM   1459  CD  GLN   193      63.962  32.694  55.621  1.00 53.47           C  
ATOM   1460  OE1 GLN   193      64.104  32.901  54.417  1.00 51.49           O  
ATOM   1461  NE2 GLN   193      64.528  33.451  56.529  1.00 55.09           N  
ATOM   1462  C   GLN   193      60.765  31.383  59.241  1.00 53.88           C  
ATOM   1463  O   GLN   193      61.235  31.505  60.358  1.00 54.19           O  
ATOM   1464  N   LEU   194      59.534  31.755  58.955  1.00 53.27           N  
ATOM   1465  CA  LEU   194      58.716  32.295  59.994  1.00 53.33           C  
ATOM   1466  CB  LEU   194      57.432  32.856  59.425  1.00 52.86           C  
ATOM   1467  CG  LEU   194      57.462  34.117  58.566  1.00 50.30           C  
ATOM   1468  CD1 LEU   194      56.064  34.352  58.050  1.00 46.63           C  
ATOM   1469  CD2 LEU   194      57.965  35.313  59.354  1.00 46.73           C  
ATOM   1470  C   LEU   194      58.410  31.164  60.968  1.00 54.40           C  
ATOM   1471  O   LEU   194      58.433  31.358  62.167  1.00 55.26           O  
ATOM   1472  N   LEU   195      58.145  29.964  60.459  1.00 54.97           N  
ATOM   1473  CA  LEU   195      57.936  28.819  61.335  1.00 54.73           C  
ATOM   1474  CB  LEU   195      57.570  27.579  60.531  1.00 54.24           C  
ATOM   1475  CG  LEU   195      56.787  26.499  61.269  1.00 54.25           C  
ATOM   1476  CD1 LEU   195      55.409  27.022  61.737  1.00 55.95           C  
ATOM   1477  CD2 LEU   195      56.593  25.278  60.379  1.00 53.17           C  
ATOM   1478  C   LEU   195      59.177  28.557  62.193  1.00 55.04           C  
ATOM   1479  O   LEU   195      59.069  28.261  63.341  1.00 55.82           O  
ATOM   1480  N   ASN   196      60.357  28.691  61.662  1.00 55.87           N  
ATOM   1481  CA  ASN   196      61.518  28.408  62.465  1.00 57.39           C  
ATOM   1482  CB  ASN   196      62.810  28.337  61.622  1.00 58.19           C  
ATOM   1483  CG  ASN   196      62.756  27.292  60.566  1.00 58.66           C  
ATOM   1484  OD1 ASN   196      62.148  26.244  60.766  1.00 57.74           O  
ATOM   1485  ND2 ASN   196      63.361  27.586  59.406  1.00 60.48           N  
ATOM   1486  C   ASN   196      61.823  29.422  63.529  1.00 58.16           C  
ATOM   1487  O   ASN   196      62.600  29.108  64.384  1.00 57.65           O  
ATOM   1488  N   GLN   197      61.323  30.652  63.463  1.00 59.58           N  
ATOM   1489  CA  GLN   197      61.821  31.655  64.416  1.00 60.35           C  
ATOM   1490  CB  GLN   197      62.306  32.921  63.714  1.00 61.18           C  
ATOM   1491  CG  GLN   197      63.833  33.053  63.720  1.00 63.47           C  
ATOM   1492  CD  GLN   197      64.418  32.727  62.347  1.00 65.44           C  
ATOM   1493  OE1 GLN   197      65.466  33.251  61.970  1.00 65.09           O  
ATOM   1494  NE2 GLN   197      63.710  31.894  61.575  1.00 66.60           N  
ATOM   1495  C   GLN   197      60.827  32.071  65.450  1.00 61.19           C  
ATOM   1496  O   GLN   197      61.199  32.727  66.444  1.00 61.90           O  
ATOM   1497  N   PHE   198      59.572  31.708  65.224  1.00 61.74           N  
ATOM   1498  CA  PHE   198      58.476  32.250  66.007  1.00 62.50           C  
ATOM   1499  CB  PHE   198      57.610  33.136  65.091  1.00 63.24           C  
ATOM   1500  CG  PHE   198      58.311  34.400  64.721  1.00 63.23           C  
ATOM   1501  CD1 PHE   198      58.289  35.494  65.576  1.00 64.85           C  
ATOM   1502  CE1 PHE   198      58.998  36.692  65.280  1.00 64.76           C  
ATOM   1503  CZ  PHE   198      59.769  36.766  64.135  1.00 65.71           C  
ATOM   1504  CE2 PHE   198      59.845  35.649  63.294  1.00 65.67           C  
ATOM   1505  CD2 PHE   198      59.121  34.457  63.610  1.00 64.94           C  
ATOM   1506  C   PHE   198      57.719  31.184  66.761  1.00 62.01           C  
ATOM   1507  O   PHE   198      57.315  30.164  66.204  1.00 60.95           O  
ATOM   1508  N   GLU   199      57.624  31.418  68.066  1.00 63.23           N  
ATOM   1509  CA  GLU   199      57.033  30.463  69.050  1.00 63.40           C  
ATOM   1510  CB  GLU   199      57.253  30.965  70.523  1.00 64.68           C  
ATOM   1511  CG  GLU   199      56.559  30.142  71.715  1.00 65.60           C  
ATOM   1512  CD  GLU   199      56.710  30.770  73.173  1.00 67.04           C  
ATOM   1513  OE1 GLU   199      56.751  32.040  73.366  1.00 68.38           O  
ATOM   1514  OE2 GLU   199      56.762  29.934  74.144  1.00 72.60           O  
ATOM   1515  C   GLU   199      55.568  30.284  68.756  1.00 61.53           C  
ATOM   1516  O   GLU   199      54.804  31.236  68.553  1.00 60.87           O  
ATOM   1517  N   GLY   200      55.162  29.049  68.711  1.00 60.14           N  
ATOM   1518  CA  GLY   200      53.757  28.785  68.487  1.00 59.79           C  
ATOM   1519  C   GLY   200      53.182  28.977  67.100  1.00 59.49           C  
ATOM   1520  O   GLY   200      51.968  28.862  66.927  1.00 60.69           O  
ATOM   1521  N   PHE   201      54.017  29.239  66.106  1.00 58.81           N  
ATOM   1522  CA  PHE   201      53.544  29.299  64.721  1.00 58.07           C  
ATOM   1523  CB  PHE   201      54.528  30.080  63.856  1.00 57.64           C  
ATOM   1524  CG  PHE   201      54.273  31.575  63.815  1.00 57.73           C  
ATOM   1525  CD1 PHE   201      53.175  32.160  64.476  1.00 56.03           C  
ATOM   1526  CE1 PHE   201      52.942  33.521  64.394  1.00 55.74           C  
ATOM   1527  CZ  PHE   201      53.781  34.298  63.648  1.00 56.16           C  
ATOM   1528  CE2 PHE   201      54.864  33.734  62.968  1.00 55.47           C  
ATOM   1529  CD2 PHE   201      55.099  32.387  63.041  1.00 56.26           C  
ATOM   1530  C   PHE   201      53.304  27.922  64.107  1.00 57.71           C  
ATOM   1531  O   PHE   201      53.800  26.916  64.607  1.00 58.91           O  
ATOM   1532  N   SER   202      52.493  27.903  63.056  1.00 57.12           N  
ATOM   1533  CA  SER   202      52.192  26.717  62.239  1.00 56.29           C  
ATOM   1534  CB  SER   202      50.774  26.233  62.487  1.00 55.27           C  
ATOM   1535  OG  SER   202      49.885  27.334  62.345  1.00 54.15           O  
ATOM   1536  C   SER   202      52.237  27.109  60.760  1.00 56.32           C  
ATOM   1537  O   SER   202      52.035  28.315  60.398  1.00 57.11           O  
ATOM   1538  N   PRO   203      52.417  26.096  59.899  1.00 55.17           N  
ATOM   1539  CA  PRO   203      52.217  26.169  58.489  1.00 54.93           C  
ATOM   1540  CB  PRO   203      51.982  24.718  58.157  1.00 54.79           C  
ATOM   1541  CG  PRO   203      52.900  24.041  58.998  1.00 54.00           C  
ATOM   1542  CD  PRO   203      52.830  24.741  60.271  1.00 55.35           C  
ATOM   1543  C   PRO   203      51.005  27.036  58.113  1.00 54.44           C  
ATOM   1544  O   PRO   203      51.143  28.012  57.362  1.00 54.15           O  
ATOM   1545  N   LEU   204      49.855  26.711  58.689  1.00 53.91           N  
ATOM   1546  CA  LEU   204      48.646  27.446  58.419  1.00 54.19           C  
ATOM   1547  CB  LEU   204      47.528  27.053  59.371  1.00 54.64           C  
ATOM   1548  CG  LEU   204      46.784  25.767  59.012  1.00 55.67           C  
ATOM   1549  CD1 LEU   204      46.040  25.053  60.208  1.00 56.69           C  
ATOM   1550  CD2 LEU   204      45.830  26.158  57.902  1.00 56.96           C  
ATOM   1551  C   LEU   204      48.868  28.919  58.524  1.00 54.22           C  
ATOM   1552  O   LEU   204      48.571  29.667  57.557  1.00 55.59           O  
ATOM   1553  N   ILE   205      49.395  29.365  59.659  1.00 53.53           N  
ATOM   1554  CA  ILE   205      49.485  30.804  59.859  1.00 53.25           C  
ATOM   1555  CB  ILE   205      49.535  31.177  61.363  1.00 54.03           C  
ATOM   1556  CG1 ILE   205      49.136  32.662  61.552  1.00 54.55           C  
ATOM   1557  CD1 ILE   205      47.640  32.939  61.303  1.00 53.78           C  
ATOM   1558  CG2 ILE   205      50.874  30.748  62.006  1.00 51.62           C  
ATOM   1559  C   ILE   205      50.659  31.416  59.062  1.00 53.04           C  
ATOM   1560  O   ILE   205      50.516  32.522  58.503  1.00 51.64           O  
ATOM   1561  N   THR   206      51.784  30.688  58.976  1.00 52.57           N  
ATOM   1562  CA  THR   206      52.908  31.174  58.176  1.00 52.67           C  
ATOM   1563  CB  THR   206      54.182  30.297  58.286  1.00 51.95           C  
ATOM   1564  OG1 THR   206      53.851  28.925  58.179  1.00 49.67           O  
ATOM   1565  CG2 THR   206      54.854  30.509  59.602  1.00 52.05           C  
ATOM   1566  C   THR   206      52.477  31.337  56.717  1.00 52.92           C  
ATOM   1567  O   THR   206      52.723  32.395  56.101  1.00 52.13           O  
ATOM   1568  N   ASN   207      51.790  30.327  56.183  1.00 53.15           N  
ATOM   1569  CA  ASN   207      51.316  30.435  54.801  1.00 54.24           C  
ATOM   1570  CB  ASN   207      50.835  29.093  54.231  1.00 54.50           C  
ATOM   1571  CG  ASN   207      52.028  28.074  54.013  1.00 56.95           C  
ATOM   1572  OD1 ASN   207      51.834  26.874  53.952  1.00 59.50           O  
ATOM   1573  ND2 ASN   207      53.247  28.582  53.926  1.00 60.44           N  
ATOM   1574  C   ASN   207      50.316  31.562  54.650  1.00 54.17           C  
ATOM   1575  O   ASN   207      50.413  32.390  53.761  1.00 53.25           O  
ATOM   1576  N   GLU   208      49.423  31.681  55.602  1.00 55.26           N  
ATOM   1577  CA  GLU   208      48.529  32.842  55.579  1.00 55.82           C  
ATOM   1578  CB  GLU   208      47.589  32.805  56.782  1.00 55.23           C  
ATOM   1579  CG  GLU   208      46.524  33.875  56.676  1.00 55.39           C  
ATOM   1580  CD  GLU   208      45.530  33.615  55.578  1.00 57.78           C  
ATOM   1581  OE1 GLU   208      45.527  32.488  55.000  1.00 61.34           O  
ATOM   1582  OE2 GLU   208      44.725  34.532  55.300  1.00 59.27           O  
ATOM   1583  C   GLU   208      49.214  34.244  55.495  1.00 56.13           C  
ATOM   1584  O   GLU   208      48.736  35.111  54.783  1.00 55.43           O  
ATOM   1585  N   ILE   209      50.293  34.454  56.248  1.00 56.45           N  
ATOM   1586  CA  ILE   209      50.921  35.764  56.337  1.00 56.97           C  
ATOM   1587  CB  ILE   209      52.077  35.796  57.413  1.00 57.50           C  
ATOM   1588  CG1 ILE   209      51.515  35.553  58.830  1.00 59.38           C  
ATOM   1589  CD1 ILE   209      52.487  34.822  59.808  1.00 57.46           C  
ATOM   1590  CG2 ILE   209      52.938  37.133  57.349  1.00 55.85           C  
ATOM   1591  C   ILE   209      51.542  36.104  54.991  1.00 57.60           C  
ATOM   1592  O   ILE   209      51.332  37.221  54.447  1.00 57.59           O  
ATOM   1593  N   VAL   210      52.368  35.149  54.521  1.00 57.62           N  
ATOM   1594  CA  VAL   210      53.020  35.153  53.191  1.00 56.83           C  
ATOM   1595  CB  VAL   210      53.685  33.793  52.955  1.00 56.83           C  
ATOM   1596  CG1 VAL   210      53.559  33.397  51.544  1.00 54.22           C  
ATOM   1597  CG2 VAL   210      55.141  33.802  53.465  1.00 55.48           C  
ATOM   1598  C   VAL   210      52.037  35.449  52.047  1.00 56.43           C  
ATOM   1599  O   VAL   210      52.369  36.222  51.138  1.00 56.38           O  
ATOM   1600  N   SER   211      50.825  34.896  52.176  1.00 56.10           N  
ATOM   1601  CA  SER   211      49.650  35.188  51.314  1.00 56.65           C  
ATOM   1602  CB  SER   211      48.488  34.159  51.563  1.00 57.20           C  
ATOM   1603  OG  SER   211      47.430  34.685  52.415  1.00 57.88           O  
ATOM   1604  C   SER   211      48.980  36.541  51.421  1.00 56.15           C  
ATOM   1605  O   SER   211      47.991  36.772  50.749  1.00 57.13           O  
ATOM   1606  N   ARG   212      49.418  37.423  52.280  1.00 56.20           N  
ATOM   1607  CA  ARG   212      48.653  38.654  52.443  1.00 56.74           C  
ATOM   1608  CB  ARG   212      48.574  39.061  53.890  1.00 57.22           C  
ATOM   1609  CG  ARG   212      47.779  38.125  54.691  1.00 58.39           C  
ATOM   1610  CD  ARG   212      46.342  38.213  54.418  1.00 57.78           C  
ATOM   1611  NE  ARG   212      45.687  37.309  55.350  1.00 59.16           N  
ATOM   1612  CZ  ARG   212      44.974  37.688  56.413  1.00 58.38           C  
ATOM   1613  NH1 ARG   212      44.770  38.973  56.728  1.00 59.29           N  
ATOM   1614  NH2 ARG   212      44.444  36.758  57.161  1.00 55.31           N  
ATOM   1615  C   ARG   212      49.176  39.842  51.691  1.00 56.89           C  
ATOM   1616  O   ARG   212      48.782  40.983  52.023  1.00 56.43           O  
ATOM   1617  N   ARG   213      50.040  39.600  50.732  1.00 56.80           N  
ATOM   1618  CA  ARG   213      50.444  40.585  49.789  1.00 55.88           C  
ATOM   1619  CB  ARG   213      51.626  41.359  50.283  1.00 55.66           C  
ATOM   1620  CG  ARG   213      51.444  41.958  51.590  1.00 53.64           C  
ATOM   1621  CD  ARG   213      50.824  43.276  51.511  1.00 49.04           C  
ATOM   1622  NE  ARG   213      49.670  43.276  52.368  1.00 49.77           N  
ATOM   1623  CZ  ARG   213      49.371  44.248  53.196  1.00 50.41           C  
ATOM   1624  NH1 ARG   213      50.138  45.302  53.259  1.00 49.62           N  
ATOM   1625  NH2 ARG   213      48.308  44.160  53.955  1.00 48.16           N  
ATOM   1626  C   ARG   213      50.868  39.756  48.640  1.00 56.67           C  
ATOM   1627  O   ARG   213      50.996  38.567  48.763  1.00 58.18           O  
ATOM   1628  N   GLN   214      51.092  40.377  47.507  1.00 56.00           N  
ATOM   1629  CA  GLN   214      51.368  39.615  46.330  1.00 55.49           C  
ATOM   1630  CB  GLN   214      51.215  40.484  45.119  1.00 54.93           C  
ATOM   1631  CG  GLN   214      50.206  40.006  44.178  1.00 55.12           C  
ATOM   1632  CD  GLN   214      50.193  40.836  42.972  1.00 55.17           C  
ATOM   1633  OE1 GLN   214      50.335  42.041  43.044  1.00 53.10           O  
ATOM   1634  NE2 GLN   214      50.030  40.209  41.841  1.00 54.73           N  
ATOM   1635  C   GLN   214      52.753  39.106  46.390  1.00 54.51           C  
ATOM   1636  O   GLN   214      53.058  38.083  45.829  1.00 54.95           O  
ATOM   1637  N   PHE   215      53.606  39.826  47.081  1.00 52.93           N  
ATOM   1638  CA  PHE   215      54.978  39.413  47.126  1.00 52.65           C  
ATOM   1639  CB  PHE   215      55.768  40.213  46.116  1.00 53.02           C  
ATOM   1640  CG  PHE   215      55.432  39.881  44.714  1.00 53.63           C  
ATOM   1641  CD1 PHE   215      55.779  38.669  44.192  1.00 52.64           C  
ATOM   1642  CE1 PHE   215      55.471  38.360  42.924  1.00 52.66           C  
ATOM   1643  CZ  PHE   215      54.799  39.252  42.163  1.00 52.76           C  
ATOM   1644  CE2 PHE   215      54.446  40.456  42.662  1.00 52.53           C  
ATOM   1645  CD2 PHE   215      54.755  40.771  43.925  1.00 52.47           C  
ATOM   1646  C   PHE   215      55.574  39.589  48.478  1.00 51.25           C  
ATOM   1647  O   PHE   215      55.247  40.508  49.181  1.00 52.04           O  
ATOM   1648  N   MET   216      56.475  38.708  48.843  1.00 49.64           N  
ATOM   1649  CA  MET   216      57.132  38.862  50.139  1.00 48.63           C  
ATOM   1650  CB  MET   216      57.340  37.499  50.863  1.00 48.38           C  
ATOM   1651  CG  MET   216      56.156  36.939  51.693  1.00 46.59           C  
ATOM   1652  SD  MET   216      55.469  38.048  52.940  1.00 45.50           S  
ATOM   1653  CE  MET   216      54.083  38.750  52.009  1.00 43.49           C  
ATOM   1654  C   MET   216      58.458  39.602  49.897  1.00 48.05           C  
ATOM   1655  O   MET   216      59.315  39.114  49.196  1.00 47.67           O  
ATOM   1656  N   THR   217      58.598  40.776  50.507  1.00 47.87           N  
ATOM   1657  CA  THR   217      59.778  41.664  50.388  1.00 47.34           C  
ATOM   1658  CB  THR   217      59.540  42.837  49.409  1.00 47.58           C  
ATOM   1659  OG1 THR   217      58.814  43.878  50.106  1.00 46.70           O  
ATOM   1660  CG2 THR   217      58.769  42.379  48.189  1.00 44.19           C  
ATOM   1661  C   THR   217      59.940  42.364  51.720  1.00 46.72           C  
ATOM   1662  O   THR   217      59.042  42.322  52.524  1.00 46.43           O  
ATOM   1663  N   SER   218      61.035  43.086  51.890  1.00 46.41           N  
ATOM   1664  CA  SER   218      61.265  43.907  53.080  1.00 46.19           C  
ATOM   1665  CB  SER   218      62.626  44.572  52.990  1.00 45.63           C  
ATOM   1666  OG  SER   218      62.489  45.834  52.334  1.00 47.58           O  
ATOM   1667  C   SER   218      60.199  45.006  53.327  1.00 45.74           C  
ATOM   1668  O   SER   218      59.975  45.369  54.466  1.00 44.88           O  
ATOM   1669  N   SER   219      59.553  45.542  52.290  1.00 46.35           N  
ATOM   1670  CA  SER   219      58.403  46.427  52.528  1.00 47.16           C  
ATOM   1671  CB  SER   219      58.060  47.266  51.333  1.00 46.58           C  
ATOM   1672  OG  SER   219      59.187  47.996  51.006  1.00 47.75           O  
ATOM   1673  C   SER   219      57.130  45.696  52.894  1.00 48.04           C  
ATOM   1674  O   SER   219      56.330  46.191  53.689  1.00 49.24           O  
ATOM   1675  N   THR   220      56.898  44.532  52.321  1.00 48.31           N  
ATOM   1676  CA  THR   220      55.568  43.957  52.465  1.00 48.16           C  
ATOM   1677  CB  THR   220      55.196  43.183  51.194  1.00 49.17           C  
ATOM   1678  OG1 THR   220      56.260  42.272  50.896  1.00 50.74           O  
ATOM   1679  CG2 THR   220      54.915  44.141  50.059  1.00 44.82           C  
ATOM   1680  C   THR   220      55.414  43.032  53.674  1.00 47.89           C  
ATOM   1681  O   THR   220      54.334  42.962  54.286  1.00 46.24           O  
ATOM   1682  N   LEU   221      56.504  42.311  53.989  1.00 48.20           N  
ATOM   1683  CA  LEU   221      56.461  41.256  54.996  1.00 47.61           C  
ATOM   1684  CB  LEU   221      57.782  40.557  55.155  1.00 46.48           C  
ATOM   1685  CG  LEU   221      57.800  39.426  56.203  1.00 48.75           C  
ATOM   1686  CD1 LEU   221      56.470  38.648  56.303  1.00 50.59           C  
ATOM   1687  CD2 LEU   221      58.988  38.410  56.019  1.00 48.11           C  
ATOM   1688  C   LEU   221      55.973  41.871  56.278  1.00 48.13           C  
ATOM   1689  O   LEU   221      54.985  41.394  56.819  1.00 49.36           O  
ATOM   1690  N   PRO   222      56.581  42.996  56.722  1.00 47.89           N  
ATOM   1691  CA  PRO   222      56.131  43.664  57.944  1.00 47.78           C  
ATOM   1692  CB  PRO   222      56.903  44.967  57.922  1.00 47.02           C  
ATOM   1693  CG  PRO   222      58.128  44.640  57.194  1.00 47.30           C  
ATOM   1694  CD  PRO   222      57.724  43.709  56.126  1.00 47.86           C  
ATOM   1695  C   PRO   222      54.652  43.944  57.978  1.00 47.90           C  
ATOM   1696  O   PRO   222      54.009  43.676  58.960  1.00 47.04           O  
ATOM   1697  N   GLU   223      54.132  44.468  56.881  1.00 49.09           N  
ATOM   1698  CA  GLU   223      52.702  44.741  56.726  1.00 49.82           C  
ATOM   1699  CB  GLU   223      52.448  45.250  55.307  1.00 49.45           C  
ATOM   1700  CG  GLU   223      52.447  46.710  55.118  1.00 50.59           C  
ATOM   1701  CD  GLU   223      53.025  47.136  53.768  1.00 53.79           C  
ATOM   1702  OE1 GLU   223      52.836  46.390  52.760  1.00 64.29           O  
ATOM   1703  OE2 GLU   223      53.670  48.225  53.695  1.00 58.16           O  
ATOM   1704  C   GLU   223      51.871  43.489  56.907  1.00 49.23           C  
ATOM   1705  O   GLU   223      50.849  43.520  57.560  1.00 48.47           O  
ATOM   1706  N   ALA   224      52.295  42.401  56.280  1.00 49.72           N  
ATOM   1707  CA  ALA   224      51.536  41.165  56.343  1.00 51.44           C  
ATOM   1708  CB  ALA   224      52.163  40.106  55.401  1.00 51.49           C  
ATOM   1709  C   ALA   224      51.489  40.670  57.809  1.00 52.85           C  
ATOM   1710  O   ALA   224      50.424  40.541  58.444  1.00 53.64           O  
ATOM   1711  N   PHE   225      52.678  40.456  58.361  1.00 53.76           N  
ATOM   1712  CA  PHE   225      52.831  40.121  59.747  1.00 53.65           C  
ATOM   1713  CB  PHE   225      54.281  40.295  60.124  1.00 54.17           C  
ATOM   1714  CG  PHE   225      54.598  39.801  61.504  1.00 56.69           C  
ATOM   1715  CD1 PHE   225      55.016  38.484  61.720  1.00 58.37           C  
ATOM   1716  CE1 PHE   225      55.309  38.017  63.041  1.00 55.01           C  
ATOM   1717  CZ  PHE   225      55.183  38.843  64.088  1.00 53.46           C  
ATOM   1718  CE2 PHE   225      54.802  40.145  63.889  1.00 56.52           C  
ATOM   1719  CD2 PHE   225      54.489  40.633  62.608  1.00 57.51           C  
ATOM   1720  C   PHE   225      51.904  40.951  60.679  1.00 54.04           C  
ATOM   1721  O   PHE   225      51.042  40.383  61.380  1.00 54.85           O  
ATOM   1722  N   ASP   226      52.057  42.271  60.675  1.00 53.01           N  
ATOM   1723  CA  ASP   226      51.294  43.080  61.578  1.00 53.07           C  
ATOM   1724  CB  ASP   226      51.699  44.548  61.467  1.00 52.40           C  
ATOM   1725  CG  ASP   226      53.113  44.847  62.093  1.00 53.38           C  
ATOM   1726  OD1 ASP   226      53.653  44.023  62.962  1.00 51.35           O  
ATOM   1727  OD2 ASP   226      53.669  45.934  61.699  1.00 48.55           O  
ATOM   1728  C   ASP   226      49.801  42.838  61.330  1.00 53.38           C  
ATOM   1729  O   ASP   226      49.046  42.480  62.252  1.00 53.49           O  
ATOM   1730  N   GLU   227      49.389  42.924  60.075  1.00 54.03           N  
ATOM   1731  CA  GLU   227      47.999  42.712  59.723  1.00 54.36           C  
ATOM   1732  CB  GLU   227      47.862  42.611  58.221  1.00 54.35           C  
ATOM   1733  CG  GLU   227      46.491  43.047  57.703  1.00 56.78           C  
ATOM   1734  CD  GLU   227      46.152  42.565  56.254  1.00 57.35           C  
ATOM   1735  OE1 GLU   227      45.951  43.469  55.357  1.00 59.61           O  
ATOM   1736  OE2 GLU   227      46.061  41.296  56.046  1.00 58.50           O  
ATOM   1737  C   GLU   227      47.490  41.430  60.369  1.00 54.28           C  
ATOM   1738  O   GLU   227      46.450  41.397  61.026  1.00 54.29           O  
ATOM   1739  N   VAL   228      48.235  40.356  60.215  1.00 54.34           N  
ATOM   1740  CA  VAL   228      47.744  39.093  60.752  1.00 54.56           C  
ATOM   1741  CB  VAL   228      48.543  37.901  60.244  1.00 54.76           C  
ATOM   1742  CG1 VAL   228      48.211  36.632  61.062  1.00 55.28           C  
ATOM   1743  CG2 VAL   228      48.207  37.690  58.807  1.00 54.18           C  
ATOM   1744  C   VAL   228      47.711  39.053  62.266  1.00 54.31           C  
ATOM   1745  O   VAL   228      46.734  38.589  62.825  1.00 53.90           O  
ATOM   1746  N   MET   229      48.775  39.526  62.914  1.00 54.01           N  
ATOM   1747  CA  MET   229      48.828  39.476  64.364  1.00 53.65           C  
ATOM   1748  CB  MET   229      50.200  39.810  64.905  1.00 52.89           C  
ATOM   1749  CG  MET   229      51.306  38.867  64.431  1.00 51.26           C  
ATOM   1750  SD  MET   229      51.304  37.233  65.155  1.00 46.88           S  
ATOM   1751  CE  MET   229      50.165  36.437  64.133  1.00 49.03           C  
ATOM   1752  C   MET   229      47.756  40.386  64.952  1.00 53.59           C  
ATOM   1753  O   MET   229      47.123  40.038  65.945  1.00 53.15           O  
ATOM   1754  N   ALA   230      47.464  41.500  64.303  1.00 53.86           N  
ATOM   1755  CA  ALA   230      46.270  42.282  64.731  1.00 54.04           C  
ATOM   1756  CB  ALA   230      46.140  43.542  63.948  1.00 51.66           C  
ATOM   1757  C   ALA   230      44.968  41.428  64.666  1.00 54.13           C  
ATOM   1758  O   ALA   230      44.189  41.376  65.603  1.00 53.64           O  
ATOM   1759  N   GLU   231      44.737  40.737  63.574  1.00 55.17           N  
ATOM   1760  CA  GLU   231      43.548  39.929  63.492  1.00 56.47           C  
ATOM   1761  CB  GLU   231      43.523  39.255  62.139  1.00 56.63           C  
ATOM   1762  CG  GLU   231      42.845  40.053  61.072  1.00 59.59           C  
ATOM   1763  CD  GLU   231      42.881  39.377  59.663  1.00 60.96           C  
ATOM   1764  OE1 GLU   231      42.597  38.132  59.620  1.00 61.26           O  
ATOM   1765  OE2 GLU   231      43.151  40.122  58.627  1.00 66.83           O  
ATOM   1766  C   GLU   231      43.473  38.853  64.619  1.00 56.60           C  
ATOM   1767  O   GLU   231      42.379  38.435  65.077  1.00 56.06           O  
ATOM   1768  N   THR   232      44.627  38.375  65.078  1.00 57.13           N  
ATOM   1769  CA  THR   232      44.588  37.338  66.127  1.00 56.91           C  
ATOM   1770  CB  THR   232      45.929  36.776  66.492  1.00 56.05           C  
ATOM   1771  OG1 THR   232      46.809  37.850  66.880  1.00 52.73           O  
ATOM   1772  CG2 THR   232      46.443  35.992  65.330  1.00 55.48           C  
ATOM   1773  C   THR   232      44.000  37.886  67.397  1.00 57.57           C  
ATOM   1774  O   THR   232      43.532  37.126  68.203  1.00 58.60           O  
ATOM   1775  N   LYS   233      44.049  39.199  67.570  1.00 57.71           N  
ATOM   1776  CA  LYS   233      43.540  39.844  68.767  1.00 57.50           C  
ATOM   1777  CB  LYS   233      44.251  41.167  68.975  1.00 56.79           C  
ATOM   1778  CG  LYS   233      45.682  40.926  69.191  1.00 56.33           C  
ATOM   1779  CD  LYS   233      46.407  42.182  69.201  1.00 58.05           C  
ATOM   1780  CE  LYS   233      47.861  41.950  69.602  1.00 60.79           C  
ATOM   1781  NZ  LYS   233      48.289  43.255  70.239  1.00 64.17           N  
ATOM   1782  C   LYS   233      42.067  40.103  68.675  1.00 58.38           C  
ATOM   1783  O   LYS   233      41.458  40.571  69.633  1.00 59.64           O  
ATOM   1784  N   LEU   234      41.471  39.856  67.518  1.00 58.35           N  
ATOM   1785  CA  LEU   234      40.047  40.055  67.434  1.00 57.46           C  
ATOM   1786  CB  LEU   234      39.677  40.528  66.037  1.00 57.94           C  
ATOM   1787  CG  LEU   234      39.756  42.057  65.894  1.00 58.27           C  
ATOM   1788  CD1 LEU   234      40.949  42.538  66.697  1.00 59.90           C  
ATOM   1789  CD2 LEU   234      39.837  42.465  64.449  1.00 56.72           C  
ATOM   1790  C   LEU   234      39.377  38.759  67.872  1.00 57.03           C  
ATOM   1791  O   LEU   234      40.007  37.719  67.898  1.00 56.48           O  
END
