
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   94 ( 1550),  selected   94 , name 1zg2_A
# Molecule2: number of CA atoms   44 (  374),  selected   44 , name T0510_235_279.pdb
# PARAMETERS: 1zg2_A.T0510_235_279.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      P     235           -
LGA    M     6_A      P     236          2.148
LGA    N     7_A      T     237          1.435
LGA    H     8_A      P     238          0.909
LGA    Y     9_A      I     239          0.932
LGA    V    10_A      F     240          0.327
LGA    Y    11_A      H     241          0.696
LGA    I    12_A      -       -           -
LGA    L    13_A      N     243          0.806
LGA    E    14_A      H     244          2.276
LGA    C    15_A      E     245          3.272
LGA    K    16_A      -       -           -
LGA    D    17_A      -       -           -
LGA    G    18_A      -       -           -
LGA    S    19_A      T     246          3.712
LGA    W    20_A      G     247          1.044
LGA    Y    21_A      K     248          0.875
LGA    T    22_A      E     249          0.399
LGA    G    23_A      D     250          0.676
LGA    Y    24_A      F     251          0.954
LGA    T    25_A      Y     252          1.846
LGA    T    26_A      F     253          1.344
LGA    D    27_A      I     254          3.488
LGA    V    28_A      -       -           -
LGA    D    29_A      K     255           #
LGA    R    30_A      L     256          5.035
LGA    R    31_A      -       -           -
LGA    I    32_A      -       -           -
LGA    K    33_A      N     257           #
LGA    K    34_A      -       -           -
LGA    H    35_A      -       -           -
LGA    A    36_A      -       -           -
LGA    S    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    K    39_A      -       -           -
LGA    G    40_A      -       -           -
LGA    A    41_A      -       -           -
LGA    K    42_A      -       -           -
LGA    Y    43_A      -       -           -
LGA    T    44_A      -       -           -
LGA    R    45_A      -       -           -
LGA    G    46_A      -       -           -
LGA    R    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    P    49_A      Q     258           #
LGA    F    50_A      F     259           #
LGA    R    51_A      -       -           -
LGA    L    52_A      N     260          4.432
LGA    V    53_A      D     261          4.925
LGA    A    54_A      D     262          2.180
LGA    T    55_A      T     263          0.795
LGA    W    56_A      V     264          0.551
LGA    A    57_A      T     265          0.320
LGA    F    58_A      Y     266          0.411
LGA    P    59_A      D     267          1.736
LGA    S    60_A      S     268          1.892
LGA    K    61_A      L     269          2.426
LGA    E    62_A      N     270          1.625
LGA    E    63_A      D     271          1.014
LGA    A    64_A      L     272          0.306
LGA    M    65_A      L     273          0.525
LGA    R    66_A      D     274          1.186
LGA    W    67_A      R     275          1.086
LGA    E    68_A      F     276          1.099
LGA    Y    69_A      Y     277          0.826
LGA    E    70_A      D     278          1.518
LGA    V    71_A      A     279          4.086
LGA    K    72_A      -       -           -
LGA    H    73_A      -       -           -
LGA    L    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    R    76_A      -       -           -
LGA    R    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    Q    81_A      -       -           -
LGA    L    82_A      -       -           -
LGA    V    83_A      -       -           -
LGA    S    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    K    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    P    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    N    92_A      -       -           -
LGA    T    93_A      -       -           -
LGA    T    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    S    97_A      -       -           -
LGA    T    98_A      -       -           -
LGA    T    99_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   94   44    5.0     39    2.12     7.69     67.416     1.757

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.879862 * X  +   0.047030 * Y  +  -0.472896 * Z  +  35.907249
  Y_new =   0.362622 * X  +  -0.576731 * Y  +  -0.732043 * Z  +  20.590605
  Z_new =  -0.307162 * X  +  -0.815579 * Y  +   0.490389 * Z  +  57.778946 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.029438    2.112154  [ DEG:   -58.9825    121.0175 ]
  Theta =   0.312209    2.829383  [ DEG:    17.8883    162.1117 ]
  Phi   =   2.750669   -0.390923  [ DEG:   157.6017    -22.3983 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zg2_A                                        
REMARK     2: T0510_235_279.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zg2_A.T0510_235_279.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   94   44   5.0   39   2.12    7.69  67.416
REMARK  ---------------------------------------------------------- 
MOLECULE 1zg2_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-APR-05   1ZG2              
TITLE     SOLUTION NMR STRUCTURE OF THE UPF0213 PROTEIN BH0048 FROM             
TITLE    2 BACILLUS HALODURANS. NORTHEAST STRUCTURAL GENOMICS TARGET            
TITLE    3 BHR2.                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL UPF0213 PROTEIN BH0048;                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21MGK;                                   
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PET21;                                
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: BHR2-21                                   
KEYWDS    BHR2, NMR STRUCTURE, AUTOSTRUCTURE, NORTHEAST STRUCTURAL              
KEYWDS   2 GENOMICS CONSORTIUM, PSI, PROTEIN STRUCTURE INITIATIVE, NESG         
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    J.M.ARAMINI,G.V.T.SWAPNA,R.XIAO,L.MA,R.SHASTRY,M.CIANO,               
AUTHOR   2 T.B.ACTON,J.LIU,B.ROST,J.R.CORT,M.A.KENNEDY,G.T.MONTELIONE,          
AUTHOR   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   21-JUN-05 1ZG2    0                                                
JRNL        AUTH   J.M.ARAMINI,G.V.T.SWAPNA,R.XIAO,L.MA,R.SHASTRY,              
JRNL        AUTH 2 M.CIANO,T.B.ACTON,J.LIU,B.ROST,J.R.CORT,                     
JRNL        AUTH 3 M.A.KENNEDY,G.T.MONTELIONE                                   
JRNL        TITL   SOLUTION NMR STRUCTURE OF THE UPF0213 PROTEIN                
JRNL        TITL 2 BH0048 FROM BACILLUS HALODURANS. NORTHEAST                   
JRNL        TITL 3 STRUCTURAL GENOMICS TARGET BHR2.                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1ZG2 A    6    99  UNP    Q9KGL3   Y048_BACHD       1     94             
SEQRES   1 A  107  MET ALA GLY ASP PRO MET ASN HIS TYR VAL TYR ILE LEU          
SEQRES   2 A  107  GLU CYS LYS ASP GLY SER TRP TYR THR GLY TYR THR THR          
SEQRES   3 A  107  ASP VAL ASP ARG ARG ILE LYS LYS HIS ALA SER GLY LYS          
SEQRES   4 A  107  GLY ALA LYS TYR THR ARG GLY ARG GLY PRO PHE ARG LEU          
SEQRES   5 A  107  VAL ALA THR TRP ALA PHE PRO SER LYS GLU GLU ALA MET          
SEQRES   6 A  107  ARG TRP GLU TYR GLU VAL LYS HIS LEU SER ARG ARG LYS          
SEQRES   7 A  107  LYS GLU GLN LEU VAL SER LEU LYS GLY GLY PRO TYR GLU          
SEQRES   8 A  107  ASN THR THR LYS LEU SER THR THR LEU GLU HIS HIS HIS          
SEQRES   9 A  107  HIS HIS HIS                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   6      37.175  33.692  69.334  1.00  0.00           N  
ATOM      2  CA  MET A   6      37.947  33.426  68.121  1.00  0.00           C  
ATOM      3  C   MET A   6      37.046  32.979  66.971  1.00  0.00           C  
ATOM      4  O   MET A   6      35.880  32.631  67.168  1.00  0.00           O  
ATOM      5  CB  MET A   6      39.055  32.401  68.388  1.00  0.00           C  
ATOM      6  CG  MET A   6      39.997  32.834  69.496  1.00  0.00           C  
ATOM      7  SD  MET A   6      40.743  34.443  69.175  1.00  0.00           S  
ATOM      8  CE  MET A   6      40.807  35.111  70.836  1.00  0.00           C  
ATOM      9  H   MET A   6      37.111  34.614  69.651  1.00  0.00           H  
ATOM     10  HA  MET A   6      38.411  34.357  67.833  1.00  0.00           H  
ATOM     11  HB2 MET A   6      38.604  31.460  68.671  1.00  0.00           H  
ATOM     12  HB3 MET A   6      39.630  32.259  67.484  1.00  0.00           H  
ATOM     13  HG2 MET A   6      39.443  32.890  70.419  1.00  0.00           H  
ATOM     14  HG3 MET A   6      40.783  32.099  69.591  1.00  0.00           H  
ATOM     15  HE1 MET A   6      41.383  34.450  71.465  1.00  0.00           H  
ATOM     16  HE2 MET A   6      39.802  35.200  71.224  1.00  0.00           H  
ATOM     17  HE3 MET A   6      41.271  36.087  70.814  1.00  0.00           H  
ATOM     18  N   ASN A   7      37.578  33.018  65.762  1.00  0.00           N  
ATOM     19  CA  ASN A   7      36.797  32.696  64.576  1.00  0.00           C  
ATOM     20  C   ASN A   7      37.079  31.271  64.123  1.00  0.00           C  
ATOM     21  O   ASN A   7      38.184  30.960  63.692  1.00  0.00           O  
ATOM     22  CB  ASN A   7      37.111  33.676  63.442  1.00  0.00           C  
ATOM     23  CG  ASN A   7      36.910  35.120  63.852  1.00  0.00           C  
ATOM     24  OD1 ASN A   7      37.846  35.792  64.288  1.00  0.00           O  
ATOM     25  ND2 ASN A   7      35.689  35.610  63.709  1.00  0.00           N  
ATOM     26  H   ASN A   7      38.522  33.265  65.660  1.00  0.00           H  
ATOM     27  HA  ASN A   7      35.751  32.779  64.834  1.00  0.00           H  
ATOM     28  HB2 ASN A   7      38.139  33.547  63.138  1.00  0.00           H  
ATOM     29  HB3 ASN A   7      36.466  33.465  62.604  1.00  0.00           H  
ATOM     30 HD21 ASN A   7      34.993  35.022  63.346  1.00  0.00           H  
ATOM     31 HD22 ASN A   7      35.525  36.537  63.990  1.00  0.00           H  
ATOM     32  N   HIS A   8      36.082  30.406  64.227  1.00  0.00           N  
ATOM     33  CA  HIS A   8      36.261  29.004  63.877  1.00  0.00           C  
ATOM     34  C   HIS A   8      35.602  28.700  62.539  1.00  0.00           C  
ATOM     35  O   HIS A   8      34.376  28.648  62.442  1.00  0.00           O  
ATOM     36  CB  HIS A   8      35.664  28.094  64.952  1.00  0.00           C  
ATOM     37  CG  HIS A   8      36.103  28.414  66.349  1.00  0.00           C  
ATOM     38  ND1 HIS A   8      35.215  28.737  67.353  1.00  0.00           N  
ATOM     39  CD2 HIS A   8      37.334  28.445  66.913  1.00  0.00           C  
ATOM     40  CE1 HIS A   8      35.882  28.955  68.472  1.00  0.00           C  
ATOM     41  NE2 HIS A   8      37.168  28.782  68.233  1.00  0.00           N  
ATOM     42  H   HIS A   8      35.205  30.718  64.535  1.00  0.00           H  
ATOM     43  HA  HIS A   8      37.320  28.810  63.801  1.00  0.00           H  
ATOM     44  HB2 HIS A   8      34.587  28.175  64.920  1.00  0.00           H  
ATOM     45  HB3 HIS A   8      35.945  27.072  64.739  1.00  0.00           H  
ATOM     46  HD1 HIS A   8      34.239  28.798  67.258  1.00  0.00           H  
ATOM     47  HD2 HIS A   8      38.272  28.241  66.416  1.00  0.00           H  
ATOM     48  HE1 HIS A   8      35.446  29.223  69.424  1.00  0.00           H  
ATOM     49  HE2 HIS A   8      37.900  29.012  68.863  1.00  0.00           H  
ATOM     50  N   TYR A   9      36.417  28.513  61.511  1.00  0.00           N  
ATOM     51  CA  TYR A   9      35.910  28.169  60.190  1.00  0.00           C  
ATOM     52  C   TYR A   9      36.431  26.807  59.764  1.00  0.00           C  
ATOM     53  O   TYR A   9      37.625  26.651  59.524  1.00  0.00           O  
ATOM     54  CB  TYR A   9      36.348  29.200  59.145  1.00  0.00           C  
ATOM     55  CG  TYR A   9      35.874  30.612  59.401  1.00  0.00           C  
ATOM     56  CD1 TYR A   9      34.637  31.046  58.944  1.00  0.00           C  
ATOM     57  CD2 TYR A   9      36.675  31.516  60.084  1.00  0.00           C  
ATOM     58  CE1 TYR A   9      34.213  32.343  59.161  1.00  0.00           C  
ATOM     59  CE2 TYR A   9      36.256  32.812  60.306  1.00  0.00           C  
ATOM     60  CZ  TYR A   9      35.026  33.221  59.844  1.00  0.00           C  
ATOM     61  OH  TYR A   9      34.613  34.514  60.061  1.00  0.00           O  
ATOM     62  H   TYR A   9      37.387  28.603  61.643  1.00  0.00           H  
ATOM     63  HA  TYR A   9      34.831  28.142  60.234  1.00  0.00           H  
ATOM     64  HB2 TYR A   9      37.425  29.219  59.109  1.00  0.00           H  
ATOM     65  HB3 TYR A   9      35.970  28.895  58.179  1.00  0.00           H  
ATOM     66  HD1 TYR A   9      34.001  30.353  58.412  1.00  0.00           H  
ATOM     67  HD2 TYR A   9      37.640  31.193  60.446  1.00  0.00           H  
ATOM     68  HE1 TYR A   9      33.248  32.664  58.796  1.00  0.00           H  
ATOM     69  HE2 TYR A   9      36.894  33.499  60.842  1.00  0.00           H  
ATOM     70  HH  TYR A   9      33.658  34.522  60.241  1.00  0.00           H  
ATOM     71  N   VAL A  10      35.548  25.827  59.670  1.00  0.00           N  
ATOM     72  CA  VAL A  10      35.944  24.515  59.184  1.00  0.00           C  
ATOM     73  C   VAL A  10      35.906  24.506  57.665  1.00  0.00           C  
ATOM     74  O   VAL A  10      34.836  24.630  57.063  1.00  0.00           O  
ATOM     75  CB  VAL A  10      35.034  23.372  59.693  1.00  0.00           C  
ATOM     76  CG1 VAL A  10      35.639  22.028  59.316  1.00  0.00           C  
ATOM     77  CG2 VAL A  10      34.803  23.448  61.196  1.00  0.00           C  
ATOM     78  H   VAL A  10      34.611  25.988  59.924  1.00  0.00           H  
ATOM     79  HA  VAL A  10      36.956  24.325  59.513  1.00  0.00           H  
ATOM     80  HB  VAL A  10      34.079  23.458  59.197  1.00  0.00           H  
ATOM     81 HG11 VAL A  10      35.690  21.944  58.240  1.00  0.00           H  
ATOM     82 HG12 VAL A  10      35.025  21.235  59.710  1.00  0.00           H  
ATOM     83 HG13 VAL A  10      36.634  21.952  59.729  1.00  0.00           H  
ATOM     84 HG21 VAL A  10      35.733  23.263  61.714  1.00  0.00           H  
ATOM     85 HG22 VAL A  10      34.075  22.700  61.486  1.00  0.00           H  
ATOM     86 HG23 VAL A  10      34.434  24.428  61.454  1.00  0.00           H  
ATOM     87  N   TYR A  11      37.066  24.379  57.050  1.00  0.00           N  
ATOM     88  CA  TYR A  11      37.144  24.321  55.604  1.00  0.00           C  
ATOM     89  C   TYR A  11      37.436  22.898  55.161  1.00  0.00           C  
ATOM     90  O   TYR A  11      38.251  22.200  55.769  1.00  0.00           O  
ATOM     91  CB  TYR A  11      38.208  25.295  55.063  1.00  0.00           C  
ATOM     92  CG  TYR A  11      39.601  25.104  55.633  1.00  0.00           C  
ATOM     93  CD1 TYR A  11      40.473  24.165  55.097  1.00  0.00           C  
ATOM     94  CD2 TYR A  11      40.043  25.866  56.706  1.00  0.00           C  
ATOM     95  CE1 TYR A  11      41.744  23.990  55.612  1.00  0.00           C  
ATOM     96  CE2 TYR A  11      41.314  25.697  57.228  1.00  0.00           C  
ATOM     97  CZ  TYR A  11      42.160  24.756  56.679  1.00  0.00           C  
ATOM     98  OH  TYR A  11      43.425  24.582  57.198  1.00  0.00           O  
ATOM     99  H   TYR A  11      37.890  24.301  57.579  1.00  0.00           H  
ATOM    100  HA  TYR A  11      36.178  24.608  55.215  1.00  0.00           H  
ATOM    101  HB2 TYR A  11      38.278  25.177  53.991  1.00  0.00           H  
ATOM    102  HB3 TYR A  11      37.898  26.307  55.283  1.00  0.00           H  
ATOM    103  HD1 TYR A  11      40.147  23.565  54.260  1.00  0.00           H  
ATOM    104  HD2 TYR A  11      39.380  26.602  57.137  1.00  0.00           H  
ATOM    105  HE1 TYR A  11      42.404  23.253  55.179  1.00  0.00           H  
ATOM    106  HE2 TYR A  11      41.638  26.301  58.063  1.00  0.00           H  
ATOM    107  HH  TYR A  11      44.053  24.462  56.474  1.00  0.00           H  
ATOM    108  N   ILE A  12      36.740  22.451  54.135  1.00  0.00           N  
ATOM    109  CA  ILE A  12      37.030  21.161  53.555  1.00  0.00           C  
ATOM    110  C   ILE A  12      37.387  21.339  52.081  1.00  0.00           C  
ATOM    111  O   ILE A  12      36.586  21.821  51.269  1.00  0.00           O  
ATOM    112  CB  ILE A  12      35.867  20.149  53.763  1.00  0.00           C  
ATOM    113  CG1 ILE A  12      36.337  18.723  53.467  1.00  0.00           C  
ATOM    114  CG2 ILE A  12      34.661  20.490  52.906  1.00  0.00           C  
ATOM    115  CD1 ILE A  12      35.288  17.666  53.748  1.00  0.00           C  
ATOM    116  H   ILE A  12      36.018  22.999  53.761  1.00  0.00           H  
ATOM    117  HA  ILE A  12      37.903  20.773  54.065  1.00  0.00           H  
ATOM    118  HB  ILE A  12      35.562  20.206  54.795  1.00  0.00           H  
ATOM    119 HG12 ILE A  12      36.609  18.650  52.427  1.00  0.00           H  
ATOM    120 HG13 ILE A  12      37.203  18.503  54.077  1.00  0.00           H  
ATOM    121 HG21 ILE A  12      34.320  21.487  53.139  1.00  0.00           H  
ATOM    122 HG22 ILE A  12      33.872  19.780  53.101  1.00  0.00           H  
ATOM    123 HG23 ILE A  12      34.942  20.436  51.864  1.00  0.00           H  
ATOM    124 HD11 ILE A  12      34.408  17.867  53.152  1.00  0.00           H  
ATOM    125 HD12 ILE A  12      35.026  17.684  54.795  1.00  0.00           H  
ATOM    126 HD13 ILE A  12      35.679  16.694  53.490  1.00  0.00           H  
ATOM    127  N   LEU A  13      38.621  21.013  51.758  1.00  0.00           N  
ATOM    128  CA  LEU A  13      39.139  21.243  50.424  1.00  0.00           C  
ATOM    129  C   LEU A  13      39.374  19.932  49.704  1.00  0.00           C  
ATOM    130  O   LEU A  13      40.045  19.041  50.218  1.00  0.00           O  
ATOM    131  CB  LEU A  13      40.447  22.033  50.496  1.00  0.00           C  
ATOM    132  CG  LEU A  13      40.336  23.432  51.102  1.00  0.00           C  
ATOM    133  CD1 LEU A  13      41.715  24.044  51.249  1.00  0.00           C  
ATOM    134  CD2 LEU A  13      39.457  24.320  50.239  1.00  0.00           C  
ATOM    135  H   LEU A  13      39.203  20.604  52.436  1.00  0.00           H  
ATOM    136  HA  LEU A  13      38.407  21.820  49.878  1.00  0.00           H  
ATOM    137  HB2 LEU A  13      41.152  21.466  51.084  1.00  0.00           H  
ATOM    138  HB3 LEU A  13      40.837  22.132  49.494  1.00  0.00           H  
ATOM    139  HG  LEU A  13      39.890  23.366  52.084  1.00  0.00           H  
ATOM    140 HD11 LEU A  13      42.316  23.426  51.898  1.00  0.00           H  
ATOM    141 HD12 LEU A  13      41.627  25.034  51.673  1.00  0.00           H  
ATOM    142 HD13 LEU A  13      42.182  24.107  50.279  1.00  0.00           H  
ATOM    143 HD21 LEU A  13      38.464  23.900  50.186  1.00  0.00           H  
ATOM    144 HD22 LEU A  13      39.876  24.382  49.245  1.00  0.00           H  
ATOM    145 HD23 LEU A  13      39.408  25.309  50.672  1.00  0.00           H  
ATOM    146  N   GLU A  14      38.817  19.810  48.520  1.00  0.00           N  
ATOM    147  CA  GLU A  14      39.041  18.640  47.701  1.00  0.00           C  
ATOM    148  C   GLU A  14      40.410  18.747  47.052  1.00  0.00           C  
ATOM    149  O   GLU A  14      40.678  19.683  46.296  1.00  0.00           O  
ATOM    150  CB  GLU A  14      37.953  18.508  46.641  1.00  0.00           C  
ATOM    151  CG  GLU A  14      38.034  17.215  45.850  1.00  0.00           C  
ATOM    152  CD  GLU A  14      36.861  17.031  44.915  1.00  0.00           C  
ATOM    153  OE1 GLU A  14      35.801  16.557  45.371  1.00  0.00           O  
ATOM    154  OE2 GLU A  14      36.996  17.367  43.716  1.00  0.00           O  
ATOM    155  H   GLU A  14      38.248  20.538  48.179  1.00  0.00           H  
ATOM    156  HA  GLU A  14      39.023  17.772  48.343  1.00  0.00           H  
ATOM    157  HB2 GLU A  14      36.988  18.553  47.124  1.00  0.00           H  
ATOM    158  HB3 GLU A  14      38.038  19.335  45.950  1.00  0.00           H  
ATOM    159  HG2 GLU A  14      38.942  17.221  45.267  1.00  0.00           H  
ATOM    160  HG3 GLU A  14      38.057  16.385  46.542  1.00  0.00           H  
ATOM    161  N   CYS A  15      41.279  17.807  47.378  1.00  0.00           N  
ATOM    162  CA  CYS A  15      42.645  17.833  46.891  1.00  0.00           C  
ATOM    163  C   CYS A  15      42.723  17.277  45.474  1.00  0.00           C  
ATOM    164  O   CYS A  15      41.736  16.773  44.937  1.00  0.00           O  
ATOM    165  CB  CYS A  15      43.545  17.025  47.830  1.00  0.00           C  
ATOM    166  SG  CYS A  15      43.521  17.602  49.544  1.00  0.00           S  
ATOM    167  H   CYS A  15      40.990  17.067  47.960  1.00  0.00           H  
ATOM    168  HA  CYS A  15      42.977  18.860  46.883  1.00  0.00           H  
ATOM    169  HB2 CYS A  15      43.225  15.994  47.827  1.00  0.00           H  
ATOM    170  HB3 CYS A  15      44.563  17.082  47.477  1.00  0.00           H  
ATOM    171  HG  CYS A  15      42.256  17.822  49.881  1.00  0.00           H  
ATOM    172  N   LYS A  16      43.913  17.365  44.886  1.00  0.00           N  
ATOM    173  CA  LYS A  16      44.171  16.877  43.531  1.00  0.00           C  
ATOM    174  C   LYS A  16      43.743  15.415  43.365  1.00  0.00           C  
ATOM    175  O   LYS A  16      43.307  15.002  42.292  1.00  0.00           O  
ATOM    176  CB  LYS A  16      45.668  17.008  43.229  1.00  0.00           C  
ATOM    177  CG  LYS A  16      46.538  16.144  44.133  1.00  0.00           C  
ATOM    178  CD  LYS A  16      48.021  16.384  43.925  1.00  0.00           C  
ATOM    179  CE  LYS A  16      48.854  15.361  44.689  1.00  0.00           C  
ATOM    180  NZ  LYS A  16      48.500  15.305  46.137  1.00  0.00           N  
ATOM    181  H   LYS A  16      44.649  17.785  45.377  1.00  0.00           H  
ATOM    182  HA  LYS A  16      43.616  17.490  42.839  1.00  0.00           H  
ATOM    183  HB2 LYS A  16      45.846  16.717  42.204  1.00  0.00           H  
ATOM    184  HB3 LYS A  16      45.962  18.039  43.359  1.00  0.00           H  
ATOM    185  HG2 LYS A  16      46.294  16.366  45.161  1.00  0.00           H  
ATOM    186  HG3 LYS A  16      46.321  15.104  43.932  1.00  0.00           H  
ATOM    187  HD2 LYS A  16      48.247  16.306  42.872  1.00  0.00           H  
ATOM    188  HD3 LYS A  16      48.269  17.375  44.278  1.00  0.00           H  
ATOM    189  HE2 LYS A  16      48.690  14.388  44.252  1.00  0.00           H  
ATOM    190  HE3 LYS A  16      49.898  15.624  44.591  1.00  0.00           H  
ATOM    191  HZ1 LYS A  16      47.505  15.006  46.254  1.00  0.00           H  
ATOM    192  HZ2 LYS A  16      48.626  16.240  46.579  1.00  0.00           H  
ATOM    193  HZ3 LYS A  16      49.111  14.621  46.628  1.00  0.00           H  
ATOM    194  N   ASP A  17      43.857  14.648  44.439  1.00  0.00           N  
ATOM    195  CA  ASP A  17      43.628  13.208  44.392  1.00  0.00           C  
ATOM    196  C   ASP A  17      42.145  12.875  44.494  1.00  0.00           C  
ATOM    197  O   ASP A  17      41.718  11.789  44.109  1.00  0.00           O  
ATOM    198  CB  ASP A  17      44.395  12.520  45.523  1.00  0.00           C  
ATOM    199  CG  ASP A  17      45.854  12.929  45.568  1.00  0.00           C  
ATOM    200  OD1 ASP A  17      46.683  12.294  44.885  1.00  0.00           O  
ATOM    201  OD2 ASP A  17      46.177  13.904  46.281  1.00  0.00           O  
ATOM    202  H   ASP A  17      44.119  15.059  45.288  1.00  0.00           H  
ATOM    203  HA  ASP A  17      44.000  12.844  43.446  1.00  0.00           H  
ATOM    204  HB2 ASP A  17      43.939  12.779  46.468  1.00  0.00           H  
ATOM    205  HB3 ASP A  17      44.344  11.451  45.385  1.00  0.00           H  
ATOM    206  N   GLY A  18      41.363  13.819  45.001  1.00  0.00           N  
ATOM    207  CA  GLY A  18      39.944  13.582  45.201  1.00  0.00           C  
ATOM    208  C   GLY A  18      39.601  13.385  46.665  1.00  0.00           C  
ATOM    209  O   GLY A  18      38.434  13.234  47.027  1.00  0.00           O  
ATOM    210  H   GLY A  18      41.746  14.692  45.226  1.00  0.00           H  
ATOM    211  HA2 GLY A  18      39.393  14.427  44.823  1.00  0.00           H  
ATOM    212  HA3 GLY A  18      39.655  12.699  44.652  1.00  0.00           H  
ATOM    213  N   SER A  19      40.625  13.368  47.505  1.00  0.00           N  
ATOM    214  CA  SER A  19      40.432  13.263  48.941  1.00  0.00           C  
ATOM    215  C   SER A  19      40.059  14.628  49.506  1.00  0.00           C  
ATOM    216  O   SER A  19      40.621  15.651  49.102  1.00  0.00           O  
ATOM    217  CB  SER A  19      41.711  12.740  49.607  1.00  0.00           C  
ATOM    218  OG  SER A  19      41.481  12.351  50.951  1.00  0.00           O  
ATOM    219  H   SER A  19      41.534  13.412  47.148  1.00  0.00           H  
ATOM    220  HA  SER A  19      39.625  12.571  49.123  1.00  0.00           H  
ATOM    221  HB2 SER A  19      42.074  11.886  49.055  1.00  0.00           H  
ATOM    222  HB3 SER A  19      42.461  13.517  49.594  1.00  0.00           H  
ATOM    223  HG  SER A  19      41.816  11.450  51.081  1.00  0.00           H  
ATOM    224  N   TRP A  20      39.101  14.651  50.419  1.00  0.00           N  
ATOM    225  CA  TRP A  20      38.668  15.899  51.021  1.00  0.00           C  
ATOM    226  C   TRP A  20      39.493  16.213  52.261  1.00  0.00           C  
ATOM    227  O   TRP A  20      39.558  15.420  53.199  1.00  0.00           O  
ATOM    228  CB  TRP A  20      37.181  15.850  51.368  1.00  0.00           C  
ATOM    229  CG  TRP A  20      36.300  15.729  50.165  1.00  0.00           C  
ATOM    230  CD1 TRP A  20      36.514  16.294  48.942  1.00  0.00           C  
ATOM    231  CD2 TRP A  20      35.064  15.016  50.071  1.00  0.00           C  
ATOM    232  NE1 TRP A  20      35.490  15.970  48.088  1.00  0.00           N  
ATOM    233  CE2 TRP A  20      34.587  15.188  48.757  1.00  0.00           C  
ATOM    234  CE3 TRP A  20      34.313  14.245  50.966  1.00  0.00           C  
ATOM    235  CZ2 TRP A  20      33.393  14.621  48.319  1.00  0.00           C  
ATOM    236  CZ3 TRP A  20      33.130  13.685  50.529  1.00  0.00           C  
ATOM    237  CH2 TRP A  20      32.681  13.874  49.218  1.00  0.00           C  
ATOM    238  H   TRP A  20      38.678  13.812  50.697  1.00  0.00           H  
ATOM    239  HA  TRP A  20      38.831  16.683  50.295  1.00  0.00           H  
ATOM    240  HB2 TRP A  20      36.992  15.003  52.007  1.00  0.00           H  
ATOM    241  HB3 TRP A  20      36.910  16.756  51.890  1.00  0.00           H  
ATOM    242  HD1 TRP A  20      37.374  16.900  48.694  1.00  0.00           H  
ATOM    243  HE1 TRP A  20      35.420  16.257  47.143  1.00  0.00           H  
ATOM    244  HE3 TRP A  20      34.644  14.087  51.983  1.00  0.00           H  
ATOM    245  HZ2 TRP A  20      33.032  14.755  47.311  1.00  0.00           H  
ATOM    246  HZ3 TRP A  20      32.534  13.089  51.205  1.00  0.00           H  
ATOM    247  HH2 TRP A  20      31.748  13.421  48.922  1.00  0.00           H  
ATOM    248  N   TYR A  21      40.095  17.386  52.262  1.00  0.00           N  
ATOM    249  CA  TYR A  21      40.979  17.806  53.331  1.00  0.00           C  
ATOM    250  C   TYR A  21      40.180  18.560  54.375  1.00  0.00           C  
ATOM    251  O   TYR A  21      39.610  19.613  54.090  1.00  0.00           O  
ATOM    252  CB  TYR A  21      42.089  18.693  52.757  1.00  0.00           C  
ATOM    253  CG  TYR A  21      43.130  19.138  53.760  1.00  0.00           C  
ATOM    254  CD1 TYR A  21      44.204  18.319  54.084  1.00  0.00           C  
ATOM    255  CD2 TYR A  21      43.045  20.383  54.371  1.00  0.00           C  
ATOM    256  CE1 TYR A  21      45.162  18.728  54.989  1.00  0.00           C  
ATOM    257  CE2 TYR A  21      43.999  20.796  55.278  1.00  0.00           C  
ATOM    258  CZ  TYR A  21      45.055  19.966  55.582  1.00  0.00           C  
ATOM    259  OH  TYR A  21      46.012  20.378  56.483  1.00  0.00           O  
ATOM    260  H   TYR A  21      39.928  18.006  51.513  1.00  0.00           H  
ATOM    261  HA  TYR A  21      41.414  16.927  53.781  1.00  0.00           H  
ATOM    262  HB2 TYR A  21      42.600  18.147  51.978  1.00  0.00           H  
ATOM    263  HB3 TYR A  21      41.641  19.577  52.331  1.00  0.00           H  
ATOM    264  HD1 TYR A  21      44.284  17.348  53.618  1.00  0.00           H  
ATOM    265  HD2 TYR A  21      42.217  21.031  54.126  1.00  0.00           H  
ATOM    266  HE1 TYR A  21      45.993  18.078  55.226  1.00  0.00           H  
ATOM    267  HE2 TYR A  21      43.915  21.765  55.743  1.00  0.00           H  
ATOM    268  HH  TYR A  21      46.891  20.163  56.138  1.00  0.00           H  
ATOM    269  N   THR A  22      40.118  18.006  55.571  1.00  0.00           N  
ATOM    270  CA  THR A  22      39.329  18.592  56.639  1.00  0.00           C  
ATOM    271  C   THR A  22      40.225  19.311  57.640  1.00  0.00           C  
ATOM    272  O   THR A  22      41.234  18.765  58.088  1.00  0.00           O  
ATOM    273  CB  THR A  22      38.504  17.506  57.357  1.00  0.00           C  
ATOM    274  OG1 THR A  22      37.782  16.736  56.380  1.00  0.00           O  
ATOM    275  CG2 THR A  22      37.527  18.121  58.350  1.00  0.00           C  
ATOM    276  H   THR A  22      40.627  17.189  55.747  1.00  0.00           H  
ATOM    277  HA  THR A  22      38.648  19.305  56.200  1.00  0.00           H  
ATOM    278  HB  THR A  22      39.181  16.853  57.890  1.00  0.00           H  
ATOM    279  HG1 THR A  22      37.670  17.272  55.584  1.00  0.00           H  
ATOM    280 HG21 THR A  22      36.883  18.824  57.837  1.00  0.00           H  
ATOM    281 HG22 THR A  22      38.077  18.635  59.126  1.00  0.00           H  
ATOM    282 HG23 THR A  22      36.925  17.342  58.792  1.00  0.00           H  
ATOM    283  N   GLY A  23      39.867  20.545  57.953  1.00  0.00           N  
ATOM    284  CA  GLY A  23      40.585  21.305  58.951  1.00  0.00           C  
ATOM    285  C   GLY A  23      39.923  22.639  59.202  1.00  0.00           C  
ATOM    286  O   GLY A  23      39.488  23.295  58.263  1.00  0.00           O  
ATOM    287  H   GLY A  23      39.104  20.956  57.490  1.00  0.00           H  
ATOM    288  HA2 GLY A  23      40.612  20.743  59.874  1.00  0.00           H  
ATOM    289  HA3 GLY A  23      41.596  21.472  58.610  1.00  0.00           H  
ATOM    290  N   TYR A  24      39.806  23.037  60.457  1.00  0.00           N  
ATOM    291  CA  TYR A  24      39.219  24.331  60.760  1.00  0.00           C  
ATOM    292  C   TYR A  24      40.296  25.356  61.094  1.00  0.00           C  
ATOM    293  O   TYR A  24      41.269  25.056  61.785  1.00  0.00           O  
ATOM    294  CB  TYR A  24      38.163  24.227  61.874  1.00  0.00           C  
ATOM    295  CG  TYR A  24      38.684  24.112  63.291  1.00  0.00           C  
ATOM    296  CD1 TYR A  24      39.422  23.011  63.709  1.00  0.00           C  
ATOM    297  CD2 TYR A  24      38.397  25.101  64.223  1.00  0.00           C  
ATOM    298  CE1 TYR A  24      39.860  22.902  65.017  1.00  0.00           C  
ATOM    299  CE2 TYR A  24      38.837  25.003  65.528  1.00  0.00           C  
ATOM    300  CZ  TYR A  24      39.566  23.901  65.923  1.00  0.00           C  
ATOM    301  OH  TYR A  24      39.995  23.797  67.227  1.00  0.00           O  
ATOM    302  H   TYR A  24      40.096  22.441  61.188  1.00  0.00           H  
ATOM    303  HA  TYR A  24      38.724  24.662  59.859  1.00  0.00           H  
ATOM    304  HB2 TYR A  24      37.537  25.104  61.837  1.00  0.00           H  
ATOM    305  HB3 TYR A  24      37.548  23.358  61.681  1.00  0.00           H  
ATOM    306  HD1 TYR A  24      39.655  22.234  62.996  1.00  0.00           H  
ATOM    307  HD2 TYR A  24      37.823  25.963  63.914  1.00  0.00           H  
ATOM    308  HE1 TYR A  24      40.432  22.038  65.321  1.00  0.00           H  
ATOM    309  HE2 TYR A  24      38.600  25.783  66.234  1.00  0.00           H  
ATOM    310  HH  TYR A  24      40.903  23.487  67.239  1.00  0.00           H  
ATOM    311  N   THR A  25      40.132  26.556  60.557  1.00  0.00           N  
ATOM    312  CA  THR A  25      41.089  27.629  60.755  1.00  0.00           C  
ATOM    313  C   THR A  25      40.582  28.591  61.825  1.00  0.00           C  
ATOM    314  O   THR A  25      39.372  28.691  62.060  1.00  0.00           O  
ATOM    315  CB  THR A  25      41.361  28.393  59.432  1.00  0.00           C  
ATOM    316  OG1 THR A  25      42.410  29.351  59.608  1.00  0.00           O  
ATOM    317  CG2 THR A  25      40.110  29.105  58.930  1.00  0.00           C  
ATOM    318  H   THR A  25      39.325  26.725  60.016  1.00  0.00           H  
ATOM    319  HA  THR A  25      42.016  27.188  61.092  1.00  0.00           H  
ATOM    320  HB  THR A  25      41.669  27.675  58.683  1.00  0.00           H  
ATOM    321  HG1 THR A  25      43.053  29.016  60.253  1.00  0.00           H  
ATOM    322 HG21 THR A  25      40.344  29.656  58.031  1.00  0.00           H  
ATOM    323 HG22 THR A  25      39.759  29.790  59.689  1.00  0.00           H  
ATOM    324 HG23 THR A  25      39.341  28.378  58.718  1.00  0.00           H  
ATOM    325  N   THR A  26      41.506  29.262  62.501  1.00  0.00           N  
ATOM    326  CA  THR A  26      41.153  30.214  63.540  1.00  0.00           C  
ATOM    327  C   THR A  26      42.223  31.303  63.673  1.00  0.00           C  
ATOM    328  O   THR A  26      43.062  31.263  64.574  1.00  0.00           O  
ATOM    329  CB  THR A  26      40.951  29.502  64.899  1.00  0.00           C  
ATOM    330  OG1 THR A  26      39.978  28.454  64.761  1.00  0.00           O  
ATOM    331  CG2 THR A  26      40.487  30.475  65.972  1.00  0.00           C  
ATOM    332  H   THR A  26      42.456  29.111  62.294  1.00  0.00           H  
ATOM    333  HA  THR A  26      40.219  30.680  63.260  1.00  0.00           H  
ATOM    334  HB  THR A  26      41.892  29.072  65.205  1.00  0.00           H  
ATOM    335  HG1 THR A  26      39.633  28.466  63.858  1.00  0.00           H  
ATOM    336 HG21 THR A  26      41.212  31.273  66.075  1.00  0.00           H  
ATOM    337 HG22 THR A  26      40.391  29.955  66.914  1.00  0.00           H  
ATOM    338 HG23 THR A  26      39.531  30.891  65.691  1.00  0.00           H  
ATOM    339  N   ASP A  27      42.240  32.225  62.719  1.00  0.00           N  
ATOM    340  CA  ASP A  27      43.094  33.402  62.810  1.00  0.00           C  
ATOM    341  C   ASP A  27      42.338  34.652  62.372  1.00  0.00           C  
ATOM    342  O   ASP A  27      41.715  34.677  61.309  1.00  0.00           O  
ATOM    343  CB  ASP A  27      44.392  33.236  62.002  1.00  0.00           C  
ATOM    344  CG  ASP A  27      44.172  33.020  60.517  1.00  0.00           C  
ATOM    345  OD1 ASP A  27      43.977  31.853  60.113  1.00  0.00           O  
ATOM    346  OD2 ASP A  27      44.226  34.009  59.752  1.00  0.00           O  
ATOM    347  H   ASP A  27      41.666  32.113  61.934  1.00  0.00           H  
ATOM    348  HA  ASP A  27      43.356  33.524  63.851  1.00  0.00           H  
ATOM    349  HB2 ASP A  27      44.998  34.120  62.123  1.00  0.00           H  
ATOM    350  HB3 ASP A  27      44.934  32.384  62.390  1.00  0.00           H  
ATOM    351  N   VAL A  28      42.353  35.664  63.228  1.00  0.00           N  
ATOM    352  CA  VAL A  28      41.740  36.956  62.923  1.00  0.00           C  
ATOM    353  C   VAL A  28      42.446  37.619  61.739  1.00  0.00           C  
ATOM    354  O   VAL A  28      41.858  38.434  61.020  1.00  0.00           O  
ATOM    355  CB  VAL A  28      41.784  37.901  64.147  1.00  0.00           C  
ATOM    356  CG1 VAL A  28      41.046  39.203  63.867  1.00  0.00           C  
ATOM    357  CG2 VAL A  28      41.203  37.220  65.381  1.00  0.00           C  
ATOM    358  H   VAL A  28      42.807  35.544  64.097  1.00  0.00           H  
ATOM    359  HA  VAL A  28      40.707  36.782  62.660  1.00  0.00           H  
ATOM    360  HB  VAL A  28      42.818  38.140  64.352  1.00  0.00           H  
ATOM    361 HG11 VAL A  28      41.479  39.684  63.001  1.00  0.00           H  
ATOM    362 HG12 VAL A  28      41.134  39.857  64.722  1.00  0.00           H  
ATOM    363 HG13 VAL A  28      40.003  38.996  63.680  1.00  0.00           H  
ATOM    364 HG21 VAL A  28      40.179  36.935  65.189  1.00  0.00           H  
ATOM    365 HG22 VAL A  28      41.233  37.905  66.218  1.00  0.00           H  
ATOM    366 HG23 VAL A  28      41.784  36.341  65.617  1.00  0.00           H  
ATOM    367  N   ASP A  29      43.705  37.242  61.545  1.00  0.00           N  
ATOM    368  CA  ASP A  29      44.571  37.846  60.536  1.00  0.00           C  
ATOM    369  C   ASP A  29      43.948  37.808  59.144  1.00  0.00           C  
ATOM    370  O   ASP A  29      43.939  38.815  58.439  1.00  0.00           O  
ATOM    371  CB  ASP A  29      45.917  37.126  60.521  1.00  0.00           C  
ATOM    372  CG  ASP A  29      46.859  37.666  59.465  1.00  0.00           C  
ATOM    373  OD1 ASP A  29      47.350  38.804  59.623  1.00  0.00           O  
ATOM    374  OD2 ASP A  29      47.141  36.943  58.488  1.00  0.00           O  
ATOM    375  H   ASP A  29      44.066  36.520  62.098  1.00  0.00           H  
ATOM    376  HA  ASP A  29      44.733  38.877  60.813  1.00  0.00           H  
ATOM    377  HB2 ASP A  29      46.387  37.240  61.485  1.00  0.00           H  
ATOM    378  HB3 ASP A  29      45.752  36.078  60.326  1.00  0.00           H  
ATOM    379  N   ARG A  30      43.425  36.653  58.760  1.00  0.00           N  
ATOM    380  CA  ARG A  30      42.824  36.480  57.441  1.00  0.00           C  
ATOM    381  C   ARG A  30      41.678  37.467  57.207  1.00  0.00           C  
ATOM    382  O   ARG A  30      41.515  37.991  56.102  1.00  0.00           O  
ATOM    383  CB  ARG A  30      42.320  35.048  57.290  1.00  0.00           C  
ATOM    384  CG  ARG A  30      41.659  34.763  55.955  1.00  0.00           C  
ATOM    385  CD  ARG A  30      41.330  33.290  55.811  1.00  0.00           C  
ATOM    386  NE  ARG A  30      42.539  32.464  55.828  1.00  0.00           N  
ATOM    387  CZ  ARG A  30      42.943  31.752  56.881  1.00  0.00           C  
ATOM    388  NH1 ARG A  30      42.230  31.746  58.000  1.00  0.00           N  
ATOM    389  NH2 ARG A  30      44.065  31.048  56.814  1.00  0.00           N  
ATOM    390  H   ARG A  30      43.457  35.882  59.376  1.00  0.00           H  
ATOM    391  HA  ARG A  30      43.590  36.659  56.704  1.00  0.00           H  
ATOM    392  HB2 ARG A  30      43.155  34.373  57.404  1.00  0.00           H  
ATOM    393  HB3 ARG A  30      41.601  34.849  58.071  1.00  0.00           H  
ATOM    394  HG2 ARG A  30      40.746  35.333  55.887  1.00  0.00           H  
ATOM    395  HG3 ARG A  30      42.331  35.052  55.162  1.00  0.00           H  
ATOM    396  HD2 ARG A  30      40.690  32.997  56.630  1.00  0.00           H  
ATOM    397  HD3 ARG A  30      40.813  33.140  54.876  1.00  0.00           H  
ATOM    398  HE  ARG A  30      43.092  32.454  55.009  1.00  0.00           H  
ATOM    399 HH11 ARG A  30      41.384  32.272  58.063  1.00  0.00           H  
ATOM    400 HH12 ARG A  30      42.560  31.232  58.806  1.00  0.00           H  
ATOM    401 HH21 ARG A  30      44.614  31.050  55.973  1.00  0.00           H  
ATOM    402 HH22 ARG A  30      44.372  30.518  57.608  1.00  0.00           H  
ATOM    403  N   ARG A  31      40.902  37.726  58.251  1.00  0.00           N  
ATOM    404  CA  ARG A  31      39.755  38.619  58.147  1.00  0.00           C  
ATOM    405  C   ARG A  31      40.206  40.050  57.861  1.00  0.00           C  
ATOM    406  O   ARG A  31      39.820  40.653  56.851  1.00  0.00           O  
ATOM    407  CB  ARG A  31      38.928  38.581  59.437  1.00  0.00           C  
ATOM    408  CG  ARG A  31      38.204  37.263  59.663  1.00  0.00           C  
ATOM    409  CD  ARG A  31      37.591  37.189  61.056  1.00  0.00           C  
ATOM    410  NE  ARG A  31      36.654  38.281  61.318  1.00  0.00           N  
ATOM    411  CZ  ARG A  31      36.559  38.911  62.490  1.00  0.00           C  
ATOM    412  NH1 ARG A  31      37.290  38.502  63.522  1.00  0.00           N  
ATOM    413  NH2 ARG A  31      35.711  39.923  62.637  1.00  0.00           N  
ATOM    414  H   ARG A  31      41.117  37.317  59.117  1.00  0.00           H  
ATOM    415  HA  ARG A  31      39.144  38.272  57.326  1.00  0.00           H  
ATOM    416  HB2 ARG A  31      39.587  38.754  60.278  1.00  0.00           H  
ATOM    417  HB3 ARG A  31      38.192  39.370  59.402  1.00  0.00           H  
ATOM    418  HG2 ARG A  31      37.417  37.167  58.929  1.00  0.00           H  
ATOM    419  HG3 ARG A  31      38.908  36.451  59.544  1.00  0.00           H  
ATOM    420  HD2 ARG A  31      37.066  36.249  61.151  1.00  0.00           H  
ATOM    421  HD3 ARG A  31      38.386  37.229  61.784  1.00  0.00           H  
ATOM    422  HE  ARG A  31      36.068  38.563  60.575  1.00  0.00           H  
ATOM    423 HH11 ARG A  31      37.912  37.720  63.423  1.00  0.00           H  
ATOM    424 HH12 ARG A  31      37.218  38.964  64.415  1.00  0.00           H  
ATOM    425 HH21 ARG A  31      35.131  40.220  61.867  1.00  0.00           H  
ATOM    426 HH22 ARG A  31      35.646  40.406  63.522  1.00  0.00           H  
ATOM    427  N   ILE A  32      41.024  40.591  58.756  1.00  0.00           N  
ATOM    428  CA  ILE A  32      41.529  41.951  58.609  1.00  0.00           C  
ATOM    429  C   ILE A  32      42.362  42.101  57.334  1.00  0.00           C  
ATOM    430  O   ILE A  32      42.308  43.137  56.672  1.00  0.00           O  
ATOM    431  CB  ILE A  32      42.345  42.399  59.847  1.00  0.00           C  
ATOM    432  CG1 ILE A  32      42.887  43.824  59.657  1.00  0.00           C  
ATOM    433  CG2 ILE A  32      43.474  41.423  60.140  1.00  0.00           C  
ATOM    434  CD1 ILE A  32      43.637  44.356  60.860  1.00  0.00           C  
ATOM    435  H   ILE A  32      41.301  40.056  59.534  1.00  0.00           H  
ATOM    436  HA  ILE A  32      40.670  42.603  58.527  1.00  0.00           H  
ATOM    437  HB  ILE A  32      41.681  42.394  60.698  1.00  0.00           H  
ATOM    438 HG12 ILE A  32      43.561  43.837  58.813  1.00  0.00           H  
ATOM    439 HG13 ILE A  32      42.061  44.491  59.460  1.00  0.00           H  
ATOM    440 HG21 ILE A  32      43.997  41.735  61.032  1.00  0.00           H  
ATOM    441 HG22 ILE A  32      44.162  41.407  59.308  1.00  0.00           H  
ATOM    442 HG23 ILE A  32      43.066  40.434  60.289  1.00  0.00           H  
ATOM    443 HD11 ILE A  32      43.994  45.355  60.651  1.00  0.00           H  
ATOM    444 HD12 ILE A  32      44.477  43.711  61.074  1.00  0.00           H  
ATOM    445 HD13 ILE A  32      42.977  44.382  61.714  1.00  0.00           H  
ATOM    446  N   LYS A  33      43.102  41.050  56.978  1.00  0.00           N  
ATOM    447  CA  LYS A  33      43.927  41.056  55.774  1.00  0.00           C  
ATOM    448  C   LYS A  33      43.072  41.312  54.543  1.00  0.00           C  
ATOM    449  O   LYS A  33      43.436  42.106  53.676  1.00  0.00           O  
ATOM    450  CB  LYS A  33      44.650  39.719  55.615  1.00  0.00           C  
ATOM    451  CG  LYS A  33      45.706  39.720  54.520  1.00  0.00           C  
ATOM    452  CD  LYS A  33      46.262  38.326  54.267  1.00  0.00           C  
ATOM    453  CE  LYS A  33      46.823  37.697  55.536  1.00  0.00           C  
ATOM    454  NZ  LYS A  33      47.907  38.518  56.141  1.00  0.00           N  
ATOM    455  H   LYS A  33      43.102  40.249  57.549  1.00  0.00           H  
ATOM    456  HA  LYS A  33      44.656  41.847  55.868  1.00  0.00           H  
ATOM    457  HB2 LYS A  33      45.131  39.471  56.550  1.00  0.00           H  
ATOM    458  HB3 LYS A  33      43.923  38.956  55.383  1.00  0.00           H  
ATOM    459  HG2 LYS A  33      45.261  40.087  53.608  1.00  0.00           H  
ATOM    460  HG3 LYS A  33      46.515  40.371  54.814  1.00  0.00           H  
ATOM    461  HD2 LYS A  33      45.470  37.697  53.888  1.00  0.00           H  
ATOM    462  HD3 LYS A  33      47.051  38.392  53.532  1.00  0.00           H  
ATOM    463  HE2 LYS A  33      46.024  37.593  56.253  1.00  0.00           H  
ATOM    464  HE3 LYS A  33      47.216  36.721  55.292  1.00  0.00           H  
ATOM    465  HZ1 LYS A  33      48.646  38.721  55.432  1.00  0.00           H  
ATOM    466  HZ2 LYS A  33      48.339  38.008  56.939  1.00  0.00           H  
ATOM    467  HZ3 LYS A  33      47.523  39.422  56.495  1.00  0.00           H  
ATOM    468  N   LYS A  34      41.935  40.631  54.470  1.00  0.00           N  
ATOM    469  CA  LYS A  34      41.016  40.795  53.350  1.00  0.00           C  
ATOM    470  C   LYS A  34      40.532  42.237  53.252  1.00  0.00           C  
ATOM    471  O   LYS A  34      40.460  42.805  52.163  1.00  0.00           O  
ATOM    472  CB  LYS A  34      39.819  39.853  53.492  1.00  0.00           C  
ATOM    473  CG  LYS A  34      38.773  40.029  52.400  1.00  0.00           C  
ATOM    474  CD  LYS A  34      37.606  39.071  52.575  1.00  0.00           C  
ATOM    475  CE  LYS A  34      38.030  37.625  52.370  1.00  0.00           C  
ATOM    476  NZ  LYS A  34      36.878  36.695  52.483  1.00  0.00           N  
ATOM    477  H   LYS A  34      41.711  39.997  55.187  1.00  0.00           H  
ATOM    478  HA  LYS A  34      41.554  40.549  52.447  1.00  0.00           H  
ATOM    479  HB2 LYS A  34      40.172  38.832  53.463  1.00  0.00           H  
ATOM    480  HB3 LYS A  34      39.345  40.034  54.444  1.00  0.00           H  
ATOM    481  HG2 LYS A  34      38.400  41.042  52.431  1.00  0.00           H  
ATOM    482  HG3 LYS A  34      39.234  39.844  51.440  1.00  0.00           H  
ATOM    483  HD2 LYS A  34      37.210  39.182  53.574  1.00  0.00           H  
ATOM    484  HD3 LYS A  34      36.840  39.319  51.853  1.00  0.00           H  
ATOM    485  HE2 LYS A  34      38.468  37.526  51.387  1.00  0.00           H  
ATOM    486  HE3 LYS A  34      38.765  37.368  53.120  1.00  0.00           H  
ATOM    487  HZ1 LYS A  34      36.121  36.983  51.826  1.00  0.00           H  
ATOM    488  HZ2 LYS A  34      36.504  36.700  53.457  1.00  0.00           H  
ATOM    489  HZ3 LYS A  34      37.176  35.723  52.244  1.00  0.00           H  
ATOM    490  N   HIS A  35      40.213  42.828  54.395  1.00  0.00           N  
ATOM    491  CA  HIS A  35      39.731  44.206  54.427  1.00  0.00           C  
ATOM    492  C   HIS A  35      40.840  45.172  54.020  1.00  0.00           C  
ATOM    493  O   HIS A  35      40.610  46.103  53.244  1.00  0.00           O  
ATOM    494  CB  HIS A  35      39.192  44.564  55.819  1.00  0.00           C  
ATOM    495  CG  HIS A  35      37.959  43.802  56.195  1.00  0.00           C  
ATOM    496  ND1 HIS A  35      37.702  43.364  57.477  1.00  0.00           N  
ATOM    497  CD2 HIS A  35      36.904  43.407  55.448  1.00  0.00           C  
ATOM    498  CE1 HIS A  35      36.544  42.733  57.498  1.00  0.00           C  
ATOM    499  NE2 HIS A  35      36.038  42.744  56.280  1.00  0.00           N  
ATOM    500  H   HIS A  35      40.310  42.328  55.239  1.00  0.00           H  
ATOM    501  HA  HIS A  35      38.925  44.286  53.711  1.00  0.00           H  
ATOM    502  HB2 HIS A  35      39.949  44.350  56.556  1.00  0.00           H  
ATOM    503  HB3 HIS A  35      38.955  45.617  55.845  1.00  0.00           H  
ATOM    504  HD1 HIS A  35      38.286  43.498  58.265  1.00  0.00           H  
ATOM    505  HD2 HIS A  35      36.772  43.577  54.389  1.00  0.00           H  
ATOM    506  HE1 HIS A  35      36.088  42.280  58.364  1.00  0.00           H  
ATOM    507  HE2 HIS A  35      35.100  42.522  56.057  1.00  0.00           H  
ATOM    508  N   ALA A  36      42.039  44.945  54.551  1.00  0.00           N  
ATOM    509  CA  ALA A  36      43.206  45.751  54.207  1.00  0.00           C  
ATOM    510  C   ALA A  36      43.538  45.643  52.718  1.00  0.00           C  
ATOM    511  O   ALA A  36      43.823  46.645  52.063  1.00  0.00           O  
ATOM    512  CB  ALA A  36      44.402  45.330  55.046  1.00  0.00           C  
ATOM    513  H   ALA A  36      42.141  44.213  55.202  1.00  0.00           H  
ATOM    514  HA  ALA A  36      42.978  46.781  54.439  1.00  0.00           H  
ATOM    515  HB1 ALA A  36      45.254  45.947  54.796  1.00  0.00           H  
ATOM    516  HB2 ALA A  36      44.636  44.296  54.846  1.00  0.00           H  
ATOM    517  HB3 ALA A  36      44.167  45.451  56.092  1.00  0.00           H  
ATOM    518  N   SER A  37      43.496  44.421  52.193  1.00  0.00           N  
ATOM    519  CA  SER A  37      43.833  44.172  50.796  1.00  0.00           C  
ATOM    520  C   SER A  37      42.778  44.742  49.861  1.00  0.00           C  
ATOM    521  O   SER A  37      43.095  45.191  48.761  1.00  0.00           O  
ATOM    522  CB  SER A  37      43.970  42.674  50.545  1.00  0.00           C  
ATOM    523  OG  SER A  37      44.932  42.096  51.412  1.00  0.00           O  
ATOM    524  H   SER A  37      43.236  43.663  52.764  1.00  0.00           H  
ATOM    525  HA  SER A  37      44.776  44.650  50.590  1.00  0.00           H  
ATOM    526  HB2 SER A  37      43.015  42.197  50.712  1.00  0.00           H  
ATOM    527  HB3 SER A  37      44.279  42.510  49.522  1.00  0.00           H  
ATOM    528  HG  SER A  37      44.576  42.070  52.313  1.00  0.00           H  
ATOM    529  N   GLY A  38      41.526  44.726  50.310  1.00  0.00           N  
ATOM    530  CA  GLY A  38      40.420  45.172  49.483  1.00  0.00           C  
ATOM    531  C   GLY A  38      40.574  46.605  49.007  1.00  0.00           C  
ATOM    532  O   GLY A  38      39.991  46.992  47.989  1.00  0.00           O  
ATOM    533  H   GLY A  38      41.349  44.397  51.217  1.00  0.00           H  
ATOM    534  HA2 GLY A  38      40.354  44.524  48.623  1.00  0.00           H  
ATOM    535  HA3 GLY A  38      39.507  45.089  50.053  1.00  0.00           H  
ATOM    536  N   LYS A  39      41.354  47.389  49.744  1.00  0.00           N  
ATOM    537  CA  LYS A  39      41.647  48.763  49.365  1.00  0.00           C  
ATOM    538  C   LYS A  39      42.481  48.793  48.085  1.00  0.00           C  
ATOM    539  O   LYS A  39      43.712  48.718  48.124  1.00  0.00           O  
ATOM    540  CB  LYS A  39      42.383  49.479  50.508  1.00  0.00           C  
ATOM    541  CG  LYS A  39      42.836  50.895  50.179  1.00  0.00           C  
ATOM    542  CD  LYS A  39      41.669  51.809  49.850  1.00  0.00           C  
ATOM    543  CE  LYS A  39      42.146  53.225  49.587  1.00  0.00           C  
ATOM    544  NZ  LYS A  39      41.016  54.151  49.324  1.00  0.00           N  
ATOM    545  H   LYS A  39      41.750  47.025  50.565  1.00  0.00           H  
ATOM    546  HA  LYS A  39      40.709  49.264  49.182  1.00  0.00           H  
ATOM    547  HB2 LYS A  39      41.729  49.529  51.364  1.00  0.00           H  
ATOM    548  HB3 LYS A  39      43.257  48.900  50.769  1.00  0.00           H  
ATOM    549  HG2 LYS A  39      43.362  51.300  51.030  1.00  0.00           H  
ATOM    550  HG3 LYS A  39      43.505  50.859  49.328  1.00  0.00           H  
ATOM    551  HD2 LYS A  39      41.167  51.437  48.968  1.00  0.00           H  
ATOM    552  HD3 LYS A  39      40.983  51.815  50.684  1.00  0.00           H  
ATOM    553  HE2 LYS A  39      42.692  53.575  50.451  1.00  0.00           H  
ATOM    554  HE3 LYS A  39      42.801  53.216  48.728  1.00  0.00           H  
ATOM    555  HZ1 LYS A  39      40.289  54.054  50.068  1.00  0.00           H  
ATOM    556  HZ2 LYS A  39      40.583  53.939  48.399  1.00  0.00           H  
ATOM    557  HZ3 LYS A  39      41.359  55.135  49.318  1.00  0.00           H  
ATOM    558  N   GLY A  40      41.799  48.879  46.952  1.00  0.00           N  
ATOM    559  CA  GLY A  40      42.475  48.925  45.674  1.00  0.00           C  
ATOM    560  C   GLY A  40      42.770  47.547  45.113  1.00  0.00           C  
ATOM    561  O   GLY A  40      43.782  47.352  44.440  1.00  0.00           O  
ATOM    562  H   GLY A  40      40.816  48.918  46.988  1.00  0.00           H  
ATOM    563  HA2 GLY A  40      41.853  49.459  44.971  1.00  0.00           H  
ATOM    564  HA3 GLY A  40      43.406  49.461  45.793  1.00  0.00           H  
ATOM    565  N   ALA A  41      41.902  46.581  45.396  1.00  0.00           N  
ATOM    566  CA  ALA A  41      42.066  45.229  44.863  1.00  0.00           C  
ATOM    567  C   ALA A  41      40.716  44.602  44.539  1.00  0.00           C  
ATOM    568  O   ALA A  41      39.669  45.116  44.945  1.00  0.00           O  
ATOM    569  CB  ALA A  41      42.836  44.356  45.843  1.00  0.00           C  
ATOM    570  H   ALA A  41      41.133  46.776  45.974  1.00  0.00           H  
ATOM    571  HA  ALA A  41      42.642  45.300  43.952  1.00  0.00           H  
ATOM    572  HB1 ALA A  41      42.264  44.243  46.752  1.00  0.00           H  
ATOM    573  HB2 ALA A  41      43.785  44.820  46.071  1.00  0.00           H  
ATOM    574  HB3 ALA A  41      43.007  43.386  45.404  1.00  0.00           H  
ATOM    575  N   LYS A  42      40.740  43.494  43.809  1.00  0.00           N  
ATOM    576  CA  LYS A  42      39.516  42.830  43.381  1.00  0.00           C  
ATOM    577  C   LYS A  42      39.360  41.472  44.077  1.00  0.00           C  
ATOM    578  O   LYS A  42      40.330  40.904  44.585  1.00  0.00           O  
ATOM    579  CB  LYS A  42      39.527  42.653  41.857  1.00  0.00           C  
ATOM    580  CG  LYS A  42      38.172  42.301  41.260  1.00  0.00           C  
ATOM    581  CD  LYS A  42      38.255  42.114  39.754  1.00  0.00           C  
ATOM    582  CE  LYS A  42      36.888  41.835  39.146  1.00  0.00           C  
ATOM    583  NZ  LYS A  42      35.970  43.000  39.262  1.00  0.00           N  
ATOM    584  H   LYS A  42      41.606  43.109  43.551  1.00  0.00           H  
ATOM    585  HA  LYS A  42      38.683  43.461  43.656  1.00  0.00           H  
ATOM    586  HB2 LYS A  42      39.866  43.572  41.403  1.00  0.00           H  
ATOM    587  HB3 LYS A  42      40.220  41.864  41.606  1.00  0.00           H  
ATOM    588  HG2 LYS A  42      37.820  41.383  41.709  1.00  0.00           H  
ATOM    589  HG3 LYS A  42      37.479  43.097  41.477  1.00  0.00           H  
ATOM    590  HD2 LYS A  42      38.657  43.014  39.311  1.00  0.00           H  
ATOM    591  HD3 LYS A  42      38.911  41.283  39.541  1.00  0.00           H  
ATOM    592  HE2 LYS A  42      37.016  41.591  38.100  1.00  0.00           H  
ATOM    593  HE3 LYS A  42      36.451  40.991  39.657  1.00  0.00           H  
ATOM    594  HZ1 LYS A  42      36.378  43.827  38.773  1.00  0.00           H  
ATOM    595  HZ2 LYS A  42      35.818  43.247  40.260  1.00  0.00           H  
ATOM    596  HZ3 LYS A  42      35.048  42.780  38.826  1.00  0.00           H  
ATOM    597  N   TYR A  43      38.126  40.975  44.089  1.00  0.00           N  
ATOM    598  CA  TYR A  43      37.762  39.707  44.727  1.00  0.00           C  
ATOM    599  C   TYR A  43      38.560  38.526  44.159  1.00  0.00           C  
ATOM    600  O   TYR A  43      38.892  37.587  44.882  1.00  0.00           O  
ATOM    601  CB  TYR A  43      36.260  39.473  44.512  1.00  0.00           C  
ATOM    602  CG  TYR A  43      35.636  38.392  45.373  1.00  0.00           C  
ATOM    603  CD1 TYR A  43      35.797  37.044  45.070  1.00  0.00           C  
ATOM    604  CD2 TYR A  43      34.870  38.728  46.479  1.00  0.00           C  
ATOM    605  CE1 TYR A  43      35.212  36.063  45.850  1.00  0.00           C  
ATOM    606  CE2 TYR A  43      34.279  37.752  47.261  1.00  0.00           C  
ATOM    607  CZ  TYR A  43      34.452  36.421  46.942  1.00  0.00           C  
ATOM    608  OH  TYR A  43      33.862  35.449  47.718  1.00  0.00           O  
ATOM    609  H   TYR A  43      37.409  41.504  43.671  1.00  0.00           H  
ATOM    610  HA  TYR A  43      37.959  39.793  45.786  1.00  0.00           H  
ATOM    611  HB2 TYR A  43      35.733  40.392  44.717  1.00  0.00           H  
ATOM    612  HB3 TYR A  43      36.099  39.203  43.477  1.00  0.00           H  
ATOM    613  HD1 TYR A  43      36.394  36.764  44.216  1.00  0.00           H  
ATOM    614  HD2 TYR A  43      34.737  39.771  46.729  1.00  0.00           H  
ATOM    615  HE1 TYR A  43      35.349  35.021  45.599  1.00  0.00           H  
ATOM    616  HE2 TYR A  43      33.688  38.036  48.119  1.00  0.00           H  
ATOM    617  HH  TYR A  43      32.902  35.592  47.735  1.00  0.00           H  
ATOM    618  N   THR A  44      38.868  38.584  42.868  1.00  0.00           N  
ATOM    619  CA  THR A  44      39.501  37.468  42.172  1.00  0.00           C  
ATOM    620  C   THR A  44      40.873  37.116  42.756  1.00  0.00           C  
ATOM    621  O   THR A  44      41.828  37.890  42.633  1.00  0.00           O  
ATOM    622  CB  THR A  44      39.669  37.789  40.677  1.00  0.00           C  
ATOM    623  OG1 THR A  44      38.434  38.289  40.144  1.00  0.00           O  
ATOM    624  CG2 THR A  44      40.093  36.549  39.902  1.00  0.00           C  
ATOM    625  H   THR A  44      38.668  39.401  42.367  1.00  0.00           H  
ATOM    626  HA  THR A  44      38.852  36.611  42.259  1.00  0.00           H  
ATOM    627  HB  THR A  44      40.435  38.546  40.568  1.00  0.00           H  
ATOM    628  HG1 THR A  44      37.696  38.001  40.709  1.00  0.00           H  
ATOM    629 HG21 THR A  44      41.031  36.183  40.294  1.00  0.00           H  
ATOM    630 HG22 THR A  44      40.212  36.799  38.858  1.00  0.00           H  
ATOM    631 HG23 THR A  44      39.338  35.785  40.007  1.00  0.00           H  
ATOM    632  N   ARG A  45      40.964  35.945  43.389  1.00  0.00           N  
ATOM    633  CA  ARG A  45      42.234  35.430  43.890  1.00  0.00           C  
ATOM    634  C   ARG A  45      42.144  33.926  44.134  1.00  0.00           C  
ATOM    635  O   ARG A  45      41.339  33.464  44.945  1.00  0.00           O  
ATOM    636  CB  ARG A  45      42.642  36.155  45.176  1.00  0.00           C  
ATOM    637  CG  ARG A  45      43.974  35.685  45.750  1.00  0.00           C  
ATOM    638  CD  ARG A  45      44.540  36.687  46.741  1.00  0.00           C  
ATOM    639  NE  ARG A  45      44.805  37.972  46.100  1.00  0.00           N  
ATOM    640  CZ  ARG A  45      45.397  39.003  46.697  1.00  0.00           C  
ATOM    641  NH1 ARG A  45      45.816  38.904  47.955  1.00  0.00           N  
ATOM    642  NH2 ARG A  45      45.575  40.134  46.027  1.00  0.00           N  
ATOM    643  H   ARG A  45      40.150  35.421  43.538  1.00  0.00           H  
ATOM    644  HA  ARG A  45      42.983  35.611  43.132  1.00  0.00           H  
ATOM    645  HB2 ARG A  45      42.718  37.213  44.969  1.00  0.00           H  
ATOM    646  HB3 ARG A  45      41.877  35.996  45.920  1.00  0.00           H  
ATOM    647  HG2 ARG A  45      43.824  34.741  46.254  1.00  0.00           H  
ATOM    648  HG3 ARG A  45      44.677  35.554  44.941  1.00  0.00           H  
ATOM    649  HD2 ARG A  45      43.826  36.832  47.540  1.00  0.00           H  
ATOM    650  HD3 ARG A  45      45.462  36.300  47.148  1.00  0.00           H  
ATOM    651  HE  ARG A  45      44.517  38.073  45.161  1.00  0.00           H  
ATOM    652 HH11 ARG A  45      45.691  38.046  48.470  1.00  0.00           H  
ATOM    653 HH12 ARG A  45      46.258  39.689  48.403  1.00  0.00           H  
ATOM    654 HH21 ARG A  45      45.260  40.209  45.079  1.00  0.00           H  
ATOM    655 HH22 ARG A  45      46.034  40.918  46.465  1.00  0.00           H  
ATOM    656  N   GLY A  46      42.959  33.171  43.413  1.00  0.00           N  
ATOM    657  CA  GLY A  46      42.966  31.727  43.557  1.00  0.00           C  
ATOM    658  C   GLY A  46      43.487  31.047  42.309  1.00  0.00           C  
ATOM    659  O   GLY A  46      43.674  31.702  41.285  1.00  0.00           O  
ATOM    660  H   GLY A  46      43.561  33.594  42.764  1.00  0.00           H  
ATOM    661  HA2 GLY A  46      43.597  31.461  44.395  1.00  0.00           H  
ATOM    662  HA3 GLY A  46      41.960  31.387  43.749  1.00  0.00           H  
ATOM    663  N   ARG A  47      43.732  29.744  42.391  1.00  0.00           N  
ATOM    664  CA  ARG A  47      44.215  28.983  41.242  1.00  0.00           C  
ATOM    665  C   ARG A  47      43.926  27.491  41.403  1.00  0.00           C  
ATOM    666  O   ARG A  47      43.410  26.843  40.491  1.00  0.00           O  
ATOM    667  CB  ARG A  47      45.721  29.210  41.021  1.00  0.00           C  
ATOM    668  CG  ARG A  47      46.604  28.826  42.203  1.00  0.00           C  
ATOM    669  CD  ARG A  47      48.075  28.822  41.817  1.00  0.00           C  
ATOM    670  NE  ARG A  47      48.943  28.397  42.914  1.00  0.00           N  
ATOM    671  CZ  ARG A  47      49.277  27.126  43.149  1.00  0.00           C  
ATOM    672  NH1 ARG A  47      48.768  26.157  42.402  1.00  0.00           N  
ATOM    673  NH2 ARG A  47      50.123  26.828  44.129  1.00  0.00           N  
ATOM    674  H   ARG A  47      43.575  29.282  43.239  1.00  0.00           H  
ATOM    675  HA  ARG A  47      43.682  29.342  40.372  1.00  0.00           H  
ATOM    676  HB2 ARG A  47      46.036  28.628  40.167  1.00  0.00           H  
ATOM    677  HB3 ARG A  47      45.886  30.256  40.805  1.00  0.00           H  
ATOM    678  HG2 ARG A  47      46.454  29.539  43.001  1.00  0.00           H  
ATOM    679  HG3 ARG A  47      46.326  27.838  42.542  1.00  0.00           H  
ATOM    680  HD2 ARG A  47      48.212  28.146  40.986  1.00  0.00           H  
ATOM    681  HD3 ARG A  47      48.355  29.821  41.516  1.00  0.00           H  
ATOM    682  HE  ARG A  47      49.319  29.105  43.491  1.00  0.00           H  
ATOM    683 HH11 ARG A  47      48.134  26.373  41.657  1.00  0.00           H  
ATOM    684 HH12 ARG A  47      49.010  25.195  42.585  1.00  0.00           H  
ATOM    685 HH21 ARG A  47      50.520  27.560  44.695  1.00  0.00           H  
ATOM    686 HH22 ARG A  47      50.373  25.872  44.306  1.00  0.00           H  
ATOM    687  N   GLY A  48      44.255  26.958  42.572  1.00  0.00           N  
ATOM    688  CA  GLY A  48      44.081  25.543  42.829  1.00  0.00           C  
ATOM    689  C   GLY A  48      45.252  24.984  43.605  1.00  0.00           C  
ATOM    690  O   GLY A  48      46.100  25.751  44.066  1.00  0.00           O  
ATOM    691  H   GLY A  48      44.645  27.526  43.264  1.00  0.00           H  
ATOM    692  HA2 GLY A  48      43.177  25.396  43.400  1.00  0.00           H  
ATOM    693  HA3 GLY A  48      43.996  25.019  41.888  1.00  0.00           H  
ATOM    694  N   PRO A  49      45.321  23.661  43.799  1.00  0.00           N  
ATOM    695  CA  PRO A  49      44.296  22.726  43.355  1.00  0.00           C  
ATOM    696  C   PRO A  49      43.270  22.449  44.449  1.00  0.00           C  
ATOM    697  O   PRO A  49      42.552  21.452  44.409  1.00  0.00           O  
ATOM    698  CB  PRO A  49      45.105  21.464  43.053  1.00  0.00           C  
ATOM    699  CG  PRO A  49      46.315  21.537  43.938  1.00  0.00           C  
ATOM    700  CD  PRO A  49      46.428  22.955  44.453  1.00  0.00           C  
ATOM    701  HA  PRO A  49      43.796  23.067  42.460  1.00  0.00           H  
ATOM    702  HB2 PRO A  49      44.507  20.593  43.277  1.00  0.00           H  
ATOM    703  HB3 PRO A  49      45.381  21.454  42.010  1.00  0.00           H  
ATOM    704  HG2 PRO A  49      46.198  20.854  44.765  1.00  0.00           H  
ATOM    705  HG3 PRO A  49      47.196  21.278  43.368  1.00  0.00           H  
ATOM    706  HD2 PRO A  49      46.311  22.976  45.526  1.00  0.00           H  
ATOM    707  HD3 PRO A  49      47.379  23.383  44.170  1.00  0.00           H  
ATOM    708  N   PHE A  50      43.215  23.342  45.427  1.00  0.00           N  
ATOM    709  CA  PHE A  50      42.312  23.192  46.555  1.00  0.00           C  
ATOM    710  C   PHE A  50      40.899  23.605  46.169  1.00  0.00           C  
ATOM    711  O   PHE A  50      40.611  24.791  45.996  1.00  0.00           O  
ATOM    712  CB  PHE A  50      42.789  24.039  47.735  1.00  0.00           C  
ATOM    713  CG  PHE A  50      44.203  23.755  48.157  1.00  0.00           C  
ATOM    714  CD1 PHE A  50      44.501  22.658  48.948  1.00  0.00           C  
ATOM    715  CD2 PHE A  50      45.234  24.595  47.764  1.00  0.00           C  
ATOM    716  CE1 PHE A  50      45.801  22.403  49.341  1.00  0.00           C  
ATOM    717  CE2 PHE A  50      46.538  24.342  48.153  1.00  0.00           C  
ATOM    718  CZ  PHE A  50      46.820  23.246  48.942  1.00  0.00           C  
ATOM    719  H   PHE A  50      43.799  24.125  45.387  1.00  0.00           H  
ATOM    720  HA  PHE A  50      42.306  22.152  46.843  1.00  0.00           H  
ATOM    721  HB2 PHE A  50      42.728  25.082  47.466  1.00  0.00           H  
ATOM    722  HB3 PHE A  50      42.146  23.853  48.584  1.00  0.00           H  
ATOM    723  HD1 PHE A  50      43.706  21.996  49.259  1.00  0.00           H  
ATOM    724  HD2 PHE A  50      45.013  25.454  47.148  1.00  0.00           H  
ATOM    725  HE1 PHE A  50      46.020  21.544  49.959  1.00  0.00           H  
ATOM    726  HE2 PHE A  50      47.332  25.004  47.841  1.00  0.00           H  
ATOM    727  HZ  PHE A  50      47.837  23.046  49.249  1.00  0.00           H  
ATOM    728  N   ARG A  51      40.026  22.625  46.021  1.00  0.00           N  
ATOM    729  CA  ARG A  51      38.640  22.892  45.682  1.00  0.00           C  
ATOM    730  C   ARG A  51      37.796  22.997  46.945  1.00  0.00           C  
ATOM    731  O   ARG A  51      37.629  22.022  47.673  1.00  0.00           O  
ATOM    732  CB  ARG A  51      38.082  21.789  44.779  1.00  0.00           C  
ATOM    733  CG  ARG A  51      36.592  21.926  44.511  1.00  0.00           C  
ATOM    734  CD  ARG A  51      36.042  20.725  43.764  1.00  0.00           C  
ATOM    735  NE  ARG A  51      34.581  20.740  43.737  1.00  0.00           N  
ATOM    736  CZ  ARG A  51      33.828  19.643  43.658  1.00  0.00           C  
ATOM    737  NH1 ARG A  51      34.396  18.449  43.565  1.00  0.00           N  
ATOM    738  NH2 ARG A  51      32.505  19.740  43.679  1.00  0.00           N  
ATOM    739  H   ARG A  51      40.324  21.693  46.140  1.00  0.00           H  
ATOM    740  HA  ARG A  51      38.601  23.832  45.154  1.00  0.00           H  
ATOM    741  HB2 ARG A  51      38.604  21.814  43.835  1.00  0.00           H  
ATOM    742  HB3 ARG A  51      38.254  20.833  45.251  1.00  0.00           H  
ATOM    743  HG2 ARG A  51      36.072  22.015  45.453  1.00  0.00           H  
ATOM    744  HG3 ARG A  51      36.421  22.814  43.921  1.00  0.00           H  
ATOM    745  HD2 ARG A  51      36.414  20.743  42.750  1.00  0.00           H  
ATOM    746  HD3 ARG A  51      36.376  19.824  44.256  1.00  0.00           H  
ATOM    747  HE  ARG A  51      34.138  21.621  43.803  1.00  0.00           H  
ATOM    748 HH11 ARG A  51      35.401  18.359  43.554  1.00  0.00           H  
ATOM    749 HH12 ARG A  51      33.829  17.620  43.522  1.00  0.00           H  
ATOM    750 HH21 ARG A  51      32.062  20.641  43.757  1.00  0.00           H  
ATOM    751 HH22 ARG A  51      31.936  18.907  43.628  1.00  0.00           H  
ATOM    752  N   LEU A  52      37.271  24.183  47.205  1.00  0.00           N  
ATOM    753  CA  LEU A  52      36.420  24.395  48.363  1.00  0.00           C  
ATOM    754  C   LEU A  52      35.064  23.732  48.148  1.00  0.00           C  
ATOM    755  O   LEU A  52      34.327  24.088  47.226  1.00  0.00           O  
ATOM    756  CB  LEU A  52      36.243  25.892  48.631  1.00  0.00           C  
ATOM    757  CG  LEU A  52      35.419  26.232  49.873  1.00  0.00           C  
ATOM    758  CD1 LEU A  52      36.112  25.723  51.128  1.00  0.00           C  
ATOM    759  CD2 LEU A  52      35.183  27.731  49.962  1.00  0.00           C  
ATOM    760  H   LEU A  52      37.453  24.930  46.599  1.00  0.00           H  
ATOM    761  HA  LEU A  52      36.899  23.938  49.218  1.00  0.00           H  
ATOM    762  HB2 LEU A  52      37.224  26.333  48.743  1.00  0.00           H  
ATOM    763  HB3 LEU A  52      35.762  26.338  47.773  1.00  0.00           H  
ATOM    764  HG  LEU A  52      34.460  25.745  49.802  1.00  0.00           H  
ATOM    765 HD11 LEU A  52      36.254  24.655  51.050  1.00  0.00           H  
ATOM    766 HD12 LEU A  52      35.500  25.945  51.989  1.00  0.00           H  
ATOM    767 HD13 LEU A  52      37.072  26.208  51.234  1.00  0.00           H  
ATOM    768 HD21 LEU A  52      34.555  27.944  50.815  1.00  0.00           H  
ATOM    769 HD22 LEU A  52      34.695  28.073  49.062  1.00  0.00           H  
ATOM    770 HD23 LEU A  52      36.129  28.238  50.076  1.00  0.00           H  
ATOM    771  N   VAL A  53      34.759  22.744  48.978  1.00  0.00           N  
ATOM    772  CA  VAL A  53      33.478  22.052  48.901  1.00  0.00           C  
ATOM    773  C   VAL A  53      32.433  22.799  49.722  1.00  0.00           C  
ATOM    774  O   VAL A  53      31.325  23.059  49.253  1.00  0.00           O  
ATOM    775  CB  VAL A  53      33.587  20.596  49.404  1.00  0.00           C  
ATOM    776  CG1 VAL A  53      32.277  19.844  49.191  1.00  0.00           C  
ATOM    777  CG2 VAL A  53      34.740  19.875  48.719  1.00  0.00           C  
ATOM    778  H   VAL A  53      35.414  22.468  49.657  1.00  0.00           H  
ATOM    779  HA  VAL A  53      33.165  22.035  47.867  1.00  0.00           H  
ATOM    780  HB  VAL A  53      33.791  20.621  50.465  1.00  0.00           H  
ATOM    781 HG11 VAL A  53      32.385  18.825  49.535  1.00  0.00           H  
ATOM    782 HG12 VAL A  53      32.029  19.843  48.139  1.00  0.00           H  
ATOM    783 HG13 VAL A  53      31.488  20.330  49.746  1.00  0.00           H  
ATOM    784 HG21 VAL A  53      34.590  19.892  47.650  1.00  0.00           H  
ATOM    785 HG22 VAL A  53      34.779  18.850  49.060  1.00  0.00           H  
ATOM    786 HG23 VAL A  53      35.670  20.370  48.961  1.00  0.00           H  
ATOM    787  N   ALA A  54      32.807  23.151  50.946  1.00  0.00           N  
ATOM    788  CA  ALA A  54      31.935  23.905  51.833  1.00  0.00           C  
ATOM    789  C   ALA A  54      32.732  24.499  52.986  1.00  0.00           C  
ATOM    790  O   ALA A  54      33.915  24.199  53.157  1.00  0.00           O  
ATOM    791  CB  ALA A  54      30.813  23.026  52.368  1.00  0.00           C  
ATOM    792  H   ALA A  54      33.698  22.895  51.264  1.00  0.00           H  
ATOM    793  HA  ALA A  54      31.493  24.707  51.263  1.00  0.00           H  
ATOM    794  HB1 ALA A  54      30.260  22.607  51.541  1.00  0.00           H  
ATOM    795  HB2 ALA A  54      30.153  23.622  52.982  1.00  0.00           H  
ATOM    796  HB3 ALA A  54      31.234  22.229  52.962  1.00  0.00           H  
ATOM    797  N   THR A  55      32.083  25.350  53.763  1.00  0.00           N  
ATOM    798  CA  THR A  55      32.714  25.980  54.907  1.00  0.00           C  
ATOM    799  C   THR A  55      31.727  26.053  56.068  1.00  0.00           C  
ATOM    800  O   THR A  55      30.603  26.524  55.905  1.00  0.00           O  
ATOM    801  CB  THR A  55      33.204  27.400  54.554  1.00  0.00           C  
ATOM    802  OG1 THR A  55      33.919  27.372  53.310  1.00  0.00           O  
ATOM    803  CG2 THR A  55      34.108  27.951  55.646  1.00  0.00           C  
ATOM    804  H   THR A  55      31.147  25.560  53.565  1.00  0.00           H  
ATOM    805  HA  THR A  55      33.563  25.381  55.200  1.00  0.00           H  
ATOM    806  HB  THR A  55      32.345  28.048  54.456  1.00  0.00           H  
ATOM    807  HG1 THR A  55      34.232  26.474  53.145  1.00  0.00           H  
ATOM    808 HG21 THR A  55      34.940  27.279  55.795  1.00  0.00           H  
ATOM    809 HG22 THR A  55      33.548  28.040  56.567  1.00  0.00           H  
ATOM    810 HG23 THR A  55      34.478  28.920  55.352  1.00  0.00           H  
ATOM    811  N   TRP A  56      32.143  25.570  57.227  1.00  0.00           N  
ATOM    812  CA  TRP A  56      31.285  25.572  58.401  1.00  0.00           C  
ATOM    813  C   TRP A  56      31.842  26.501  59.474  1.00  0.00           C  
ATOM    814  O   TRP A  56      32.922  26.263  60.012  1.00  0.00           O  
ATOM    815  CB  TRP A  56      31.132  24.156  58.956  1.00  0.00           C  
ATOM    816  CG  TRP A  56      30.291  23.259  58.096  1.00  0.00           C  
ATOM    817  CD1 TRP A  56      28.943  23.075  58.188  1.00  0.00           C  
ATOM    818  CD2 TRP A  56      30.739  22.422  57.024  1.00  0.00           C  
ATOM    819  NE1 TRP A  56      28.524  22.173  57.242  1.00  0.00           N  
ATOM    820  CE2 TRP A  56      29.609  21.753  56.518  1.00  0.00           C  
ATOM    821  CE3 TRP A  56      31.986  22.165  56.445  1.00  0.00           C  
ATOM    822  CZ2 TRP A  56      29.689  20.849  55.460  1.00  0.00           C  
ATOM    823  CZ3 TRP A  56      32.062  21.269  55.395  1.00  0.00           C  
ATOM    824  CH2 TRP A  56      30.922  20.619  54.914  1.00  0.00           C  
ATOM    825  H   TRP A  56      33.054  25.202  57.297  1.00  0.00           H  
ATOM    826  HA  TRP A  56      30.313  25.935  58.097  1.00  0.00           H  
ATOM    827  HB2 TRP A  56      32.110  23.706  59.051  1.00  0.00           H  
ATOM    828  HB3 TRP A  56      30.672  24.209  59.935  1.00  0.00           H  
ATOM    829  HD1 TRP A  56      28.309  23.575  58.905  1.00  0.00           H  
ATOM    830  HE1 TRP A  56      27.600  21.876  57.111  1.00  0.00           H  
ATOM    831  HE3 TRP A  56      32.878  22.657  56.800  1.00  0.00           H  
ATOM    832  HZ2 TRP A  56      28.817  20.337  55.078  1.00  0.00           H  
ATOM    833  HZ3 TRP A  56      33.017  21.060  54.936  1.00  0.00           H  
ATOM    834  HH2 TRP A  56      31.030  19.925  54.094  1.00  0.00           H  
ATOM    835  N   ALA A  57      31.106  27.561  59.773  1.00  0.00           N  
ATOM    836  CA  ALA A  57      31.533  28.531  60.773  1.00  0.00           C  
ATOM    837  C   ALA A  57      30.786  28.318  62.081  1.00  0.00           C  
ATOM    838  O   ALA A  57      29.552  28.284  62.104  1.00  0.00           O  
ATOM    839  CB  ALA A  57      31.315  29.948  60.262  1.00  0.00           C  
ATOM    840  H   ALA A  57      30.247  27.689  59.319  1.00  0.00           H  
ATOM    841  HA  ALA A  57      32.591  28.393  60.945  1.00  0.00           H  
ATOM    842  HB1 ALA A  57      31.681  30.654  60.993  1.00  0.00           H  
ATOM    843  HB2 ALA A  57      30.261  30.114  60.099  1.00  0.00           H  
ATOM    844  HB3 ALA A  57      31.850  30.083  59.333  1.00  0.00           H  
ATOM    845  N   PHE A  58      31.529  28.165  63.167  1.00  0.00           N  
ATOM    846  CA  PHE A  58      30.924  27.957  64.476  1.00  0.00           C  
ATOM    847  C   PHE A  58      31.431  28.986  65.475  1.00  0.00           C  
ATOM    848  O   PHE A  58      32.635  29.075  65.735  1.00  0.00           O  
ATOM    849  CB  PHE A  58      31.220  26.551  65.002  1.00  0.00           C  
ATOM    850  CG  PHE A  58      30.766  25.456  64.084  1.00  0.00           C  
ATOM    851  CD1 PHE A  58      29.426  25.118  64.003  1.00  0.00           C  
ATOM    852  CD2 PHE A  58      31.678  24.768  63.299  1.00  0.00           C  
ATOM    853  CE1 PHE A  58      29.003  24.111  63.159  1.00  0.00           C  
ATOM    854  CE2 PHE A  58      31.259  23.761  62.454  1.00  0.00           C  
ATOM    855  CZ  PHE A  58      29.920  23.434  62.383  1.00  0.00           C  
ATOM    856  H   PHE A  58      32.509  28.198  63.089  1.00  0.00           H  
ATOM    857  HA  PHE A  58      29.856  28.074  64.367  1.00  0.00           H  
ATOM    858  HB2 PHE A  58      32.282  26.447  65.153  1.00  0.00           H  
ATOM    859  HB3 PHE A  58      30.716  26.421  65.948  1.00  0.00           H  
ATOM    860  HD1 PHE A  58      28.708  25.650  64.610  1.00  0.00           H  
ATOM    861  HD2 PHE A  58      32.726  25.024  63.352  1.00  0.00           H  
ATOM    862  HE1 PHE A  58      27.955  23.855  63.105  1.00  0.00           H  
ATOM    863  HE2 PHE A  58      31.979  23.232  61.849  1.00  0.00           H  
ATOM    864  HZ  PHE A  58      29.589  22.645  61.721  1.00  0.00           H  
ATOM    865  N   PRO A  59      30.517  29.778  66.049  1.00  0.00           N  
ATOM    866  CA  PRO A  59      30.846  30.746  67.096  1.00  0.00           C  
ATOM    867  C   PRO A  59      31.152  30.055  68.423  1.00  0.00           C  
ATOM    868  O   PRO A  59      31.626  30.685  69.369  1.00  0.00           O  
ATOM    869  CB  PRO A  59      29.575  31.602  67.222  1.00  0.00           C  
ATOM    870  CG  PRO A  59      28.711  31.220  66.065  1.00  0.00           C  
ATOM    871  CD  PRO A  59      29.089  29.812  65.714  1.00  0.00           C  
ATOM    872  HA  PRO A  59      31.682  31.371  66.814  1.00  0.00           H  
ATOM    873  HB2 PRO A  59      29.088  31.387  68.161  1.00  0.00           H  
ATOM    874  HB3 PRO A  59      29.840  32.648  67.183  1.00  0.00           H  
ATOM    875  HG2 PRO A  59      27.672  31.270  66.352  1.00  0.00           H  
ATOM    876  HG3 PRO A  59      28.904  31.877  65.232  1.00  0.00           H  
ATOM    877  HD2 PRO A  59      28.530  29.107  66.315  1.00  0.00           H  
ATOM    878  HD3 PRO A  59      28.932  29.626  64.663  1.00  0.00           H  
ATOM    879  N   SER A  60      30.890  28.753  68.472  1.00  0.00           N  
ATOM    880  CA  SER A  60      31.083  27.977  69.685  1.00  0.00           C  
ATOM    881  C   SER A  60      32.425  27.247  69.659  1.00  0.00           C  
ATOM    882  O   SER A  60      32.820  26.681  68.634  1.00  0.00           O  
ATOM    883  CB  SER A  60      29.940  26.973  69.850  1.00  0.00           C  
ATOM    884  OG  SER A  60      28.686  27.631  69.904  1.00  0.00           O  
ATOM    885  H   SER A  60      30.563  28.300  67.666  1.00  0.00           H  
ATOM    886  HA  SER A  60      31.073  28.662  70.520  1.00  0.00           H  
ATOM    887  HB2 SER A  60      29.939  26.290  69.013  1.00  0.00           H  
ATOM    888  HB3 SER A  60      30.080  26.418  70.765  1.00  0.00           H  
ATOM    889  HG  SER A  60      28.550  27.973  70.799  1.00  0.00           H  
ATOM    890  N   LYS A  61      33.126  27.290  70.785  1.00  0.00           N  
ATOM    891  CA  LYS A  61      34.418  26.627  70.935  1.00  0.00           C  
ATOM    892  C   LYS A  61      34.299  25.115  70.750  1.00  0.00           C  
ATOM    893  O   LYS A  61      34.938  24.536  69.871  1.00  0.00           O  
ATOM    894  CB  LYS A  61      34.996  26.938  72.318  1.00  0.00           C  
ATOM    895  CG  LYS A  61      36.266  26.174  72.651  1.00  0.00           C  
ATOM    896  CD  LYS A  61      36.715  26.471  74.069  1.00  0.00           C  
ATOM    897  CE  LYS A  61      37.909  25.621  74.462  1.00  0.00           C  
ATOM    898  NZ  LYS A  61      38.355  25.906  75.851  1.00  0.00           N  
ATOM    899  H   LYS A  61      32.757  27.782  71.553  1.00  0.00           H  
ATOM    900  HA  LYS A  61      35.081  27.019  70.181  1.00  0.00           H  
ATOM    901  HB2 LYS A  61      35.218  27.993  72.370  1.00  0.00           H  
ATOM    902  HB3 LYS A  61      34.255  26.698  73.064  1.00  0.00           H  
ATOM    903  HG2 LYS A  61      36.077  25.116  72.555  1.00  0.00           H  
ATOM    904  HG3 LYS A  61      37.047  26.469  71.966  1.00  0.00           H  
ATOM    905  HD2 LYS A  61      36.988  27.513  74.141  1.00  0.00           H  
ATOM    906  HD3 LYS A  61      35.898  26.264  74.745  1.00  0.00           H  
ATOM    907  HE2 LYS A  61      37.634  24.579  74.385  1.00  0.00           H  
ATOM    908  HE3 LYS A  61      38.721  25.827  73.783  1.00  0.00           H  
ATOM    909  HZ1 LYS A  61      39.107  25.238  76.132  1.00  0.00           H  
ATOM    910  HZ2 LYS A  61      37.552  25.809  76.511  1.00  0.00           H  
ATOM    911  HZ3 LYS A  61      38.726  26.879  75.914  1.00  0.00           H  
ATOM    912  N   GLU A  62      33.460  24.490  71.570  1.00  0.00           N  
ATOM    913  CA  GLU A  62      33.363  23.043  71.608  1.00  0.00           C  
ATOM    914  C   GLU A  62      32.836  22.488  70.293  1.00  0.00           C  
ATOM    915  O   GLU A  62      33.302  21.452  69.830  1.00  0.00           O  
ATOM    916  CB  GLU A  62      32.477  22.575  72.772  1.00  0.00           C  
ATOM    917  CG  GLU A  62      31.046  23.097  72.738  1.00  0.00           C  
ATOM    918  CD  GLU A  62      30.921  24.515  73.248  1.00  0.00           C  
ATOM    919  OE1 GLU A  62      31.121  25.458  72.459  1.00  0.00           O  
ATOM    920  OE2 GLU A  62      30.624  24.693  74.445  1.00  0.00           O  
ATOM    921  H   GLU A  62      32.873  25.022  72.155  1.00  0.00           H  
ATOM    922  HA  GLU A  62      34.362  22.659  71.762  1.00  0.00           H  
ATOM    923  HB2 GLU A  62      32.439  21.501  72.760  1.00  0.00           H  
ATOM    924  HB3 GLU A  62      32.929  22.896  73.699  1.00  0.00           H  
ATOM    925  HG2 GLU A  62      30.689  23.067  71.719  1.00  0.00           H  
ATOM    926  HG3 GLU A  62      30.430  22.453  73.351  1.00  0.00           H  
ATOM    927  N   GLU A  63      31.884  23.189  69.687  1.00  0.00           N  
ATOM    928  CA  GLU A  63      31.289  22.741  68.434  1.00  0.00           C  
ATOM    929  C   GLU A  63      32.339  22.675  67.329  1.00  0.00           C  
ATOM    930  O   GLU A  63      32.329  21.760  66.511  1.00  0.00           O  
ATOM    931  CB  GLU A  63      30.138  23.654  68.021  1.00  0.00           C  
ATOM    932  CG  GLU A  63      28.934  23.578  68.948  1.00  0.00           C  
ATOM    933  CD  GLU A  63      28.383  22.170  69.083  1.00  0.00           C  
ATOM    934  OE1 GLU A  63      28.033  21.563  68.056  1.00  0.00           O  
ATOM    935  OE2 GLU A  63      28.279  21.672  70.225  1.00  0.00           O  
ATOM    936  H   GLU A  63      31.573  24.026  70.093  1.00  0.00           H  
ATOM    937  HA  GLU A  63      30.901  21.747  68.597  1.00  0.00           H  
ATOM    938  HB2 GLU A  63      30.493  24.674  68.010  1.00  0.00           H  
ATOM    939  HB3 GLU A  63      29.818  23.385  67.025  1.00  0.00           H  
ATOM    940  HG2 GLU A  63      29.228  23.927  69.927  1.00  0.00           H  
ATOM    941  HG3 GLU A  63      28.155  24.217  68.560  1.00  0.00           H  
ATOM    942  N   ALA A  64      33.259  23.632  67.330  1.00  0.00           N  
ATOM    943  CA  ALA A  64      34.338  23.652  66.351  1.00  0.00           C  
ATOM    944  C   ALA A  64      35.281  22.477  66.566  1.00  0.00           C  
ATOM    945  O   ALA A  64      35.660  21.787  65.621  1.00  0.00           O  
ATOM    946  CB  ALA A  64      35.098  24.961  66.439  1.00  0.00           C  
ATOM    947  H   ALA A  64      33.212  24.339  68.007  1.00  0.00           H  
ATOM    948  HA  ALA A  64      33.906  23.580  65.366  1.00  0.00           H  
ATOM    949  HB1 ALA A  64      35.844  24.998  65.659  1.00  0.00           H  
ATOM    950  HB2 ALA A  64      35.581  25.033  67.403  1.00  0.00           H  
ATOM    951  HB3 ALA A  64      34.411  25.785  66.320  1.00  0.00           H  
ATOM    952  N   MET A  65      35.632  22.243  67.823  1.00  0.00           N  
ATOM    953  CA  MET A  65      36.563  21.179  68.180  1.00  0.00           C  
ATOM    954  C   MET A  65      35.957  19.806  67.913  1.00  0.00           C  
ATOM    955  O   MET A  65      36.625  18.919  67.387  1.00  0.00           O  
ATOM    956  CB  MET A  65      36.963  21.290  69.655  1.00  0.00           C  
ATOM    957  CG  MET A  65      37.677  22.589  70.004  1.00  0.00           C  
ATOM    958  SD  MET A  65      38.030  22.738  71.767  1.00  0.00           S  
ATOM    959  CE  MET A  65      39.124  21.340  72.014  1.00  0.00           C  
ATOM    960  H   MET A  65      35.255  22.804  68.536  1.00  0.00           H  
ATOM    961  HA  MET A  65      37.446  21.294  67.569  1.00  0.00           H  
ATOM    962  HB2 MET A  65      36.072  21.221  70.264  1.00  0.00           H  
ATOM    963  HB3 MET A  65      37.618  20.467  69.900  1.00  0.00           H  
ATOM    964  HG2 MET A  65      38.608  22.627  69.461  1.00  0.00           H  
ATOM    965  HG3 MET A  65      37.052  23.419  69.704  1.00  0.00           H  
ATOM    966  HE1 MET A  65      38.620  20.431  71.719  1.00  0.00           H  
ATOM    967  HE2 MET A  65      39.399  21.276  73.059  1.00  0.00           H  
ATOM    968  HE3 MET A  65      40.011  21.469  71.415  1.00  0.00           H  
ATOM    969  N   ARG A  66      34.688  19.637  68.269  1.00  0.00           N  
ATOM    970  CA  ARG A  66      34.024  18.344  68.127  1.00  0.00           C  
ATOM    971  C   ARG A  66      33.711  18.039  66.665  1.00  0.00           C  
ATOM    972  O   ARG A  66      33.762  16.887  66.249  1.00  0.00           O  
ATOM    973  CB  ARG A  66      32.742  18.290  68.965  1.00  0.00           C  
ATOM    974  CG  ARG A  66      31.664  19.262  68.513  1.00  0.00           C  
ATOM    975  CD  ARG A  66      30.445  19.219  69.418  1.00  0.00           C  
ATOM    976  NE  ARG A  66      29.764  17.928  69.364  1.00  0.00           N  
ATOM    977  CZ  ARG A  66      28.452  17.770  69.534  1.00  0.00           C  
ATOM    978  NH1 ARG A  66      27.670  18.827  69.721  1.00  0.00           N  
ATOM    979  NH2 ARG A  66      27.925  16.553  69.496  1.00  0.00           N  
ATOM    980  H   ARG A  66      34.189  20.396  68.646  1.00  0.00           H  
ATOM    981  HA  ARG A  66      34.705  17.588  68.490  1.00  0.00           H  
ATOM    982  HB2 ARG A  66      32.335  17.291  68.912  1.00  0.00           H  
ATOM    983  HB3 ARG A  66      32.989  18.513  69.990  1.00  0.00           H  
ATOM    984  HG2 ARG A  66      32.068  20.264  68.526  1.00  0.00           H  
ATOM    985  HG3 ARG A  66      31.364  19.009  67.507  1.00  0.00           H  
ATOM    986  HD2 ARG A  66      30.759  19.407  70.432  1.00  0.00           H  
ATOM    987  HD3 ARG A  66      29.756  19.991  69.107  1.00  0.00           H  
ATOM    988  HE  ARG A  66      30.319  17.128  69.202  1.00  0.00           H  
ATOM    989 HH11 ARG A  66      28.062  19.754  69.734  1.00  0.00           H  
ATOM    990 HH12 ARG A  66      26.679  18.705  69.852  1.00  0.00           H  
ATOM    991 HH21 ARG A  66      28.520  15.756  69.339  1.00  0.00           H  
ATOM    992 HH22 ARG A  66      26.940  16.421  69.621  1.00  0.00           H  
ATOM    993  N   TRP A  67      33.396  19.072  65.891  1.00  0.00           N  
ATOM    994  CA  TRP A  67      33.075  18.896  64.478  1.00  0.00           C  
ATOM    995  C   TRP A  67      34.294  18.357  63.739  1.00  0.00           C  
ATOM    996  O   TRP A  67      34.222  17.328  63.068  1.00  0.00           O  
ATOM    997  CB  TRP A  67      32.629  20.225  63.870  1.00  0.00           C  
ATOM    998  CG  TRP A  67      31.731  20.070  62.685  1.00  0.00           C  
ATOM    999  CD1 TRP A  67      30.367  20.062  62.695  1.00  0.00           C  
ATOM   1000  CD2 TRP A  67      32.123  19.900  61.321  1.00  0.00           C  
ATOM   1001  NE1 TRP A  67      29.887  19.903  61.418  1.00  0.00           N  
ATOM   1002  CE2 TRP A  67      30.946  19.796  60.559  1.00  0.00           C  
ATOM   1003  CE3 TRP A  67      33.355  19.822  60.671  1.00  0.00           C  
ATOM   1004  CZ2 TRP A  67      30.967  19.625  59.180  1.00  0.00           C  
ATOM   1005  CZ3 TRP A  67      33.373  19.651  59.303  1.00  0.00           C  
ATOM   1006  CH2 TRP A  67      32.187  19.552  58.571  1.00  0.00           C  
ATOM   1007  H   TRP A  67      33.377  19.975  66.277  1.00  0.00           H  
ATOM   1008  HA  TRP A  67      32.271  18.179  64.402  1.00  0.00           H  
ATOM   1009  HB2 TRP A  67      32.097  20.793  64.619  1.00  0.00           H  
ATOM   1010  HB3 TRP A  67      33.501  20.779  63.558  1.00  0.00           H  
ATOM   1011  HD1 TRP A  67      29.767  20.172  63.582  1.00  0.00           H  
ATOM   1012  HE1 TRP A  67      28.936  19.871  61.163  1.00  0.00           H  
ATOM   1013  HE3 TRP A  67      34.281  19.897  61.220  1.00  0.00           H  
ATOM   1014  HZ2 TRP A  67      30.058  19.548  58.601  1.00  0.00           H  
ATOM   1015  HZ3 TRP A  67      34.317  19.588  58.783  1.00  0.00           H  
ATOM   1016  HH2 TRP A  67      32.252  19.421  57.503  1.00  0.00           H  
ATOM   1017  N   GLU A  68      35.409  19.061  63.894  1.00  0.00           N  
ATOM   1018  CA  GLU A  68      36.700  18.636  63.358  1.00  0.00           C  
ATOM   1019  C   GLU A  68      36.999  17.197  63.769  1.00  0.00           C  
ATOM   1020  O   GLU A  68      37.230  16.316  62.937  1.00  0.00           O  
ATOM   1021  CB  GLU A  68      37.782  19.564  63.914  1.00  0.00           C  
ATOM   1022  CG  GLU A  68      39.201  19.212  63.505  1.00  0.00           C  
ATOM   1023  CD  GLU A  68      39.509  19.539  62.065  1.00  0.00           C  
ATOM   1024  OE1 GLU A  68      39.280  18.679  61.192  1.00  0.00           O  
ATOM   1025  OE2 GLU A  68      40.027  20.648  61.809  1.00  0.00           O  
ATOM   1026  H   GLU A  68      35.364  19.906  64.393  1.00  0.00           H  
ATOM   1027  HA  GLU A  68      36.674  18.709  62.282  1.00  0.00           H  
ATOM   1028  HB2 GLU A  68      37.575  20.566  63.583  1.00  0.00           H  
ATOM   1029  HB3 GLU A  68      37.729  19.539  64.993  1.00  0.00           H  
ATOM   1030  HG2 GLU A  68      39.884  19.765  64.128  1.00  0.00           H  
ATOM   1031  HG3 GLU A  68      39.353  18.156  63.659  1.00  0.00           H  
ATOM   1032  N   TYR A  69      36.958  16.984  65.075  1.00  0.00           N  
ATOM   1033  CA  TYR A  69      37.260  15.696  65.687  1.00  0.00           C  
ATOM   1034  C   TYR A  69      36.376  14.572  65.134  1.00  0.00           C  
ATOM   1035  O   TYR A  69      36.847  13.452  64.915  1.00  0.00           O  
ATOM   1036  CB  TYR A  69      37.082  15.824  67.202  1.00  0.00           C  
ATOM   1037  CG  TYR A  69      37.419  14.583  67.989  1.00  0.00           C  
ATOM   1038  CD1 TYR A  69      38.724  14.121  68.078  1.00  0.00           C  
ATOM   1039  CD2 TYR A  69      36.429  13.892  68.669  1.00  0.00           C  
ATOM   1040  CE1 TYR A  69      39.031  12.999  68.824  1.00  0.00           C  
ATOM   1041  CE2 TYR A  69      36.725  12.771  69.411  1.00  0.00           C  
ATOM   1042  CZ  TYR A  69      38.026  12.327  69.489  1.00  0.00           C  
ATOM   1043  OH  TYR A  69      38.319  11.211  70.239  1.00  0.00           O  
ATOM   1044  H   TYR A  69      36.729  17.741  65.660  1.00  0.00           H  
ATOM   1045  HA  TYR A  69      38.292  15.462  65.475  1.00  0.00           H  
ATOM   1046  HB2 TYR A  69      37.719  16.617  67.562  1.00  0.00           H  
ATOM   1047  HB3 TYR A  69      36.054  16.079  67.411  1.00  0.00           H  
ATOM   1048  HD1 TYR A  69      39.505  14.649  67.551  1.00  0.00           H  
ATOM   1049  HD2 TYR A  69      35.409  14.241  68.607  1.00  0.00           H  
ATOM   1050  HE1 TYR A  69      40.053  12.655  68.885  1.00  0.00           H  
ATOM   1051  HE2 TYR A  69      35.938  12.244  69.927  1.00  0.00           H  
ATOM   1052  HH  TYR A  69      39.068  11.403  70.816  1.00  0.00           H  
ATOM   1053  N   GLU A  70      35.103  14.865  64.901  1.00  0.00           N  
ATOM   1054  CA  GLU A  70      34.165  13.855  64.422  1.00  0.00           C  
ATOM   1055  C   GLU A  70      34.353  13.548  62.944  1.00  0.00           C  
ATOM   1056  O   GLU A  70      34.199  12.401  62.529  1.00  0.00           O  
ATOM   1057  CB  GLU A  70      32.726  14.281  64.690  1.00  0.00           C  
ATOM   1058  CG  GLU A  70      32.270  13.963  66.103  1.00  0.00           C  
ATOM   1059  CD  GLU A  70      32.248  12.474  66.375  1.00  0.00           C  
ATOM   1060  OE1 GLU A  70      31.265  11.810  65.977  1.00  0.00           O  
ATOM   1061  OE2 GLU A  70      33.208  11.951  66.980  1.00  0.00           O  
ATOM   1062  H   GLU A  70      34.783  15.782  65.061  1.00  0.00           H  
ATOM   1063  HA  GLU A  70      34.358  12.950  64.978  1.00  0.00           H  
ATOM   1064  HB2 GLU A  70      32.642  15.348  64.533  1.00  0.00           H  
ATOM   1065  HB3 GLU A  70      32.075  13.769  63.997  1.00  0.00           H  
ATOM   1066  HG2 GLU A  70      32.948  14.434  66.801  1.00  0.00           H  
ATOM   1067  HG3 GLU A  70      31.275  14.358  66.246  1.00  0.00           H  
ATOM   1068  N   VAL A  71      34.681  14.553  62.147  1.00  0.00           N  
ATOM   1069  CA  VAL A  71      34.932  14.326  60.731  1.00  0.00           C  
ATOM   1070  C   VAL A  71      36.246  13.566  60.549  1.00  0.00           C  
ATOM   1071  O   VAL A  71      36.435  12.837  59.574  1.00  0.00           O  
ATOM   1072  CB  VAL A  71      34.948  15.647  59.936  1.00  0.00           C  
ATOM   1073  CG1 VAL A  71      35.181  15.395  58.454  1.00  0.00           C  
ATOM   1074  CG2 VAL A  71      33.642  16.392  60.139  1.00  0.00           C  
ATOM   1075  H   VAL A  71      34.753  15.463  62.515  1.00  0.00           H  
ATOM   1076  HA  VAL A  71      34.126  13.714  60.351  1.00  0.00           H  
ATOM   1077  HB  VAL A  71      35.753  16.263  60.308  1.00  0.00           H  
ATOM   1078 HG11 VAL A  71      35.187  16.335  57.924  1.00  0.00           H  
ATOM   1079 HG12 VAL A  71      34.390  14.768  58.068  1.00  0.00           H  
ATOM   1080 HG13 VAL A  71      36.131  14.899  58.318  1.00  0.00           H  
ATOM   1081 HG21 VAL A  71      32.818  15.767  59.828  1.00  0.00           H  
ATOM   1082 HG22 VAL A  71      33.646  17.297  59.551  1.00  0.00           H  
ATOM   1083 HG23 VAL A  71      33.528  16.644  61.184  1.00  0.00           H  
ATOM   1084  N   LYS A  72      37.150  13.750  61.499  1.00  0.00           N  
ATOM   1085  CA  LYS A  72      38.363  12.947  61.571  1.00  0.00           C  
ATOM   1086  C   LYS A  72      38.019  11.523  62.022  1.00  0.00           C  
ATOM   1087  O   LYS A  72      38.706  10.560  61.683  1.00  0.00           O  
ATOM   1088  CB  LYS A  72      39.351  13.597  62.541  1.00  0.00           C  
ATOM   1089  CG  LYS A  72      40.747  12.992  62.518  1.00  0.00           C  
ATOM   1090  CD  LYS A  72      41.651  13.675  63.531  1.00  0.00           C  
ATOM   1091  CE  LYS A  72      43.082  13.171  63.448  1.00  0.00           C  
ATOM   1092  NZ  LYS A  72      43.721  13.519  62.152  1.00  0.00           N  
ATOM   1093  H   LYS A  72      37.005  14.458  62.167  1.00  0.00           H  
ATOM   1094  HA  LYS A  72      38.800  12.909  60.585  1.00  0.00           H  
ATOM   1095  HB2 LYS A  72      39.437  14.644  62.295  1.00  0.00           H  
ATOM   1096  HB3 LYS A  72      38.960  13.506  63.544  1.00  0.00           H  
ATOM   1097  HG2 LYS A  72      40.679  11.943  62.760  1.00  0.00           H  
ATOM   1098  HG3 LYS A  72      41.168  13.112  61.530  1.00  0.00           H  
ATOM   1099  HD2 LYS A  72      41.647  14.738  63.340  1.00  0.00           H  
ATOM   1100  HD3 LYS A  72      41.267  13.484  64.522  1.00  0.00           H  
ATOM   1101  HE2 LYS A  72      43.653  13.610  64.251  1.00  0.00           H  
ATOM   1102  HE3 LYS A  72      43.077  12.096  63.559  1.00  0.00           H  
ATOM   1103  HZ1 LYS A  72      43.282  12.979  61.375  1.00  0.00           H  
ATOM   1104  HZ2 LYS A  72      44.740  13.293  62.182  1.00  0.00           H  
ATOM   1105  HZ3 LYS A  72      43.610  14.538  61.959  1.00  0.00           H  
ATOM   1106  N   HIS A  73      36.935  11.415  62.787  1.00  0.00           N  
ATOM   1107  CA  HIS A  73      36.479  10.141  63.345  1.00  0.00           C  
ATOM   1108  C   HIS A  73      35.763   9.278  62.305  1.00  0.00           C  
ATOM   1109  O   HIS A  73      36.020   8.076  62.205  1.00  0.00           O  
ATOM   1110  CB  HIS A  73      35.515  10.397  64.506  1.00  0.00           C  
ATOM   1111  CG  HIS A  73      36.044  10.026  65.855  1.00  0.00           C  
ATOM   1112  ND1 HIS A  73      35.382  10.333  67.022  1.00  0.00           N  
ATOM   1113  CD2 HIS A  73      37.154   9.342  66.222  1.00  0.00           C  
ATOM   1114  CE1 HIS A  73      36.058   9.855  68.047  1.00  0.00           C  
ATOM   1115  NE2 HIS A  73      37.138   9.249  67.590  1.00  0.00           N  
ATOM   1116  H   HIS A  73      36.423  12.227  62.990  1.00  0.00           H  
ATOM   1117  HA  HIS A  73      37.339   9.608  63.716  1.00  0.00           H  
ATOM   1118  HB2 HIS A  73      35.266  11.447  64.530  1.00  0.00           H  
ATOM   1119  HB3 HIS A  73      34.610   9.828  64.339  1.00  0.00           H  
ATOM   1120  HD1 HIS A  73      34.532  10.842  67.087  1.00  0.00           H  
ATOM   1121  HD2 HIS A  73      37.908   8.941  65.560  1.00  0.00           H  
ATOM   1122  HE1 HIS A  73      35.776   9.940  69.085  1.00  0.00           H  
ATOM   1123  HE2 HIS A  73      37.889   8.931  68.150  1.00  0.00           H  
ATOM   1124  N   LEU A  74      34.851   9.888  61.557  1.00  0.00           N  
ATOM   1125  CA  LEU A  74      33.985   9.146  60.646  1.00  0.00           C  
ATOM   1126  C   LEU A  74      34.739   8.617  59.430  1.00  0.00           C  
ATOM   1127  O   LEU A  74      35.743   9.189  58.999  1.00  0.00           O  
ATOM   1128  CB  LEU A  74      32.776  10.003  60.223  1.00  0.00           C  
ATOM   1129  CG  LEU A  74      33.058  11.465  59.853  1.00  0.00           C  
ATOM   1130  CD1 LEU A  74      33.735  11.575  58.498  1.00  0.00           C  
ATOM   1131  CD2 LEU A  74      31.764  12.261  59.862  1.00  0.00           C  
ATOM   1132  H   LEU A  74      34.762  10.866  61.611  1.00  0.00           H  
ATOM   1133  HA  LEU A  74      33.612   8.294  61.195  1.00  0.00           H  
ATOM   1134  HB2 LEU A  74      32.318   9.530  59.367  1.00  0.00           H  
ATOM   1135  HB3 LEU A  74      32.063   9.995  61.033  1.00  0.00           H  
ATOM   1136  HG  LEU A  74      33.718  11.894  60.590  1.00  0.00           H  
ATOM   1137 HD11 LEU A  74      33.964  12.612  58.294  1.00  0.00           H  
ATOM   1138 HD12 LEU A  74      33.076  11.196  57.732  1.00  0.00           H  
ATOM   1139 HD13 LEU A  74      34.649  11.000  58.503  1.00  0.00           H  
ATOM   1140 HD21 LEU A  74      31.968  13.284  59.582  1.00  0.00           H  
ATOM   1141 HD22 LEU A  74      31.334  12.237  60.853  1.00  0.00           H  
ATOM   1142 HD23 LEU A  74      31.070  11.827  59.157  1.00  0.00           H  
ATOM   1143  N   SER A  75      34.258   7.497  58.905  1.00  0.00           N  
ATOM   1144  CA  SER A  75      34.860   6.866  57.747  1.00  0.00           C  
ATOM   1145  C   SER A  75      34.484   7.608  56.463  1.00  0.00           C  
ATOM   1146  O   SER A  75      33.724   8.579  56.495  1.00  0.00           O  
ATOM   1147  CB  SER A  75      34.421   5.403  57.676  1.00  0.00           C  
ATOM   1148  OG  SER A  75      33.006   5.288  57.719  1.00  0.00           O  
ATOM   1149  H   SER A  75      33.464   7.089  59.305  1.00  0.00           H  
ATOM   1150  HA  SER A  75      35.932   6.903  57.869  1.00  0.00           H  
ATOM   1151  HB2 SER A  75      34.778   4.968  56.754  1.00  0.00           H  
ATOM   1152  HB3 SER A  75      34.839   4.864  58.514  1.00  0.00           H  
ATOM   1153  HG  SER A  75      32.760   4.554  58.303  1.00  0.00           H  
ATOM   1154  N   ARG A  76      35.004   7.133  55.334  1.00  0.00           N  
ATOM   1155  CA  ARG A  76      34.750   7.762  54.041  1.00  0.00           C  
ATOM   1156  C   ARG A  76      33.261   7.792  53.720  1.00  0.00           C  
ATOM   1157  O   ARG A  76      32.747   8.803  53.253  1.00  0.00           O  
ATOM   1158  CB  ARG A  76      35.503   7.036  52.919  1.00  0.00           C  
ATOM   1159  CG  ARG A  76      36.949   7.486  52.733  1.00  0.00           C  
ATOM   1160  CD  ARG A  76      37.775   7.342  54.004  1.00  0.00           C  
ATOM   1161  NE  ARG A  76      37.777   5.971  54.517  1.00  0.00           N  
ATOM   1162  CZ  ARG A  76      38.314   5.612  55.683  1.00  0.00           C  
ATOM   1163  NH1 ARG A  76      38.970   6.501  56.418  1.00  0.00           N  
ATOM   1164  NH2 ARG A  76      38.205   4.357  56.103  1.00  0.00           N  
ATOM   1165  H   ARG A  76      35.576   6.338  55.371  1.00  0.00           H  
ATOM   1166  HA  ARG A  76      35.109   8.778  54.097  1.00  0.00           H  
ATOM   1167  HB2 ARG A  76      35.506   5.977  53.134  1.00  0.00           H  
ATOM   1168  HB3 ARG A  76      34.973   7.204  51.990  1.00  0.00           H  
ATOM   1169  HG2 ARG A  76      37.403   6.886  51.959  1.00  0.00           H  
ATOM   1170  HG3 ARG A  76      36.953   8.522  52.429  1.00  0.00           H  
ATOM   1171  HD2 ARG A  76      38.794   7.636  53.793  1.00  0.00           H  
ATOM   1172  HD3 ARG A  76      37.363   7.998  54.760  1.00  0.00           H  
ATOM   1173  HE  ARG A  76      37.345   5.282  53.959  1.00  0.00           H  
ATOM   1174 HH11 ARG A  76      39.070   7.455  56.100  1.00  0.00           H  
ATOM   1175 HH12 ARG A  76      39.393   6.225  57.294  1.00  0.00           H  
ATOM   1176 HH21 ARG A  76      37.720   3.676  55.543  1.00  0.00           H  
ATOM   1177 HH22 ARG A  76      38.599   4.079  56.992  1.00  0.00           H  
ATOM   1178  N   ARG A  77      32.566   6.692  53.996  1.00  0.00           N  
ATOM   1179  CA  ARG A  77      31.147   6.587  53.672  1.00  0.00           C  
ATOM   1180  C   ARG A  77      30.342   7.689  54.359  1.00  0.00           C  
ATOM   1181  O   ARG A  77      29.464   8.302  53.748  1.00  0.00           O  
ATOM   1182  CB  ARG A  77      30.603   5.206  54.067  1.00  0.00           C  
ATOM   1183  CG  ARG A  77      29.118   5.036  53.785  1.00  0.00           C  
ATOM   1184  CD  ARG A  77      28.805   5.203  52.306  1.00  0.00           C  
ATOM   1185  NE  ARG A  77      28.970   3.965  51.548  1.00  0.00           N  
ATOM   1186  CZ  ARG A  77      29.321   3.922  50.263  1.00  0.00           C  
ATOM   1187  NH1 ARG A  77      29.732   5.020  49.643  1.00  0.00           N  
ATOM   1188  NH2 ARG A  77      29.303   2.771  49.605  1.00  0.00           N  
ATOM   1189  H   ARG A  77      33.019   5.931  54.428  1.00  0.00           H  
ATOM   1190  HA  ARG A  77      31.047   6.706  52.604  1.00  0.00           H  
ATOM   1191  HB2 ARG A  77      31.141   4.448  53.514  1.00  0.00           H  
ATOM   1192  HB3 ARG A  77      30.769   5.054  55.123  1.00  0.00           H  
ATOM   1193  HG2 ARG A  77      28.813   4.049  54.098  1.00  0.00           H  
ATOM   1194  HG3 ARG A  77      28.568   5.779  54.346  1.00  0.00           H  
ATOM   1195  HD2 ARG A  77      27.785   5.536  52.204  1.00  0.00           H  
ATOM   1196  HD3 ARG A  77      29.468   5.953  51.895  1.00  0.00           H  
ATOM   1197  HE  ARG A  77      28.744   3.123  52.008  1.00  0.00           H  
ATOM   1198 HH11 ARG A  77      29.795   5.894  50.137  1.00  0.00           H  
ATOM   1199 HH12 ARG A  77      29.965   4.986  48.661  1.00  0.00           H  
ATOM   1200 HH21 ARG A  77      29.021   1.921  50.072  1.00  0.00           H  
ATOM   1201 HH22 ARG A  77      29.572   2.739  48.637  1.00  0.00           H  
ATOM   1202  N   LYS A  78      30.655   7.954  55.623  1.00  0.00           N  
ATOM   1203  CA  LYS A  78      29.940   8.969  56.380  1.00  0.00           C  
ATOM   1204  C   LYS A  78      30.452  10.355  55.998  1.00  0.00           C  
ATOM   1205  O   LYS A  78      29.717  11.339  56.058  1.00  0.00           O  
ATOM   1206  CB  LYS A  78      30.094   8.737  57.884  1.00  0.00           C  
ATOM   1207  CG  LYS A  78      29.158   9.592  58.724  1.00  0.00           C  
ATOM   1208  CD  LYS A  78      29.367   9.353  60.210  1.00  0.00           C  
ATOM   1209  CE  LYS A  78      28.336  10.091  61.047  1.00  0.00           C  
ATOM   1210  NZ  LYS A  78      28.575   9.911  62.503  1.00  0.00           N  
ATOM   1211  H   LYS A  78      31.390   7.466  56.049  1.00  0.00           H  
ATOM   1212  HA  LYS A  78      28.893   8.902  56.116  1.00  0.00           H  
ATOM   1213  HB2 LYS A  78      29.891   7.698  58.101  1.00  0.00           H  
ATOM   1214  HB3 LYS A  78      31.109   8.964  58.171  1.00  0.00           H  
ATOM   1215  HG2 LYS A  78      29.347  10.632  58.507  1.00  0.00           H  
ATOM   1216  HG3 LYS A  78      28.136   9.348  58.470  1.00  0.00           H  
ATOM   1217  HD2 LYS A  78      29.287   8.297  60.411  1.00  0.00           H  
ATOM   1218  HD3 LYS A  78      30.352   9.701  60.483  1.00  0.00           H  
ATOM   1219  HE2 LYS A  78      28.385  11.143  60.812  1.00  0.00           H  
ATOM   1220  HE3 LYS A  78      27.354   9.714  60.802  1.00  0.00           H  
ATOM   1221  HZ1 LYS A  78      29.329  10.557  62.827  1.00  0.00           H  
ATOM   1222  HZ2 LYS A  78      28.874   8.929  62.696  1.00  0.00           H  
ATOM   1223  HZ3 LYS A  78      27.704  10.110  63.039  1.00  0.00           H  
ATOM   1224  N   LYS A  79      31.716  10.413  55.588  1.00  0.00           N  
ATOM   1225  CA  LYS A  79      32.316  11.655  55.114  1.00  0.00           C  
ATOM   1226  C   LYS A  79      31.587  12.130  53.860  1.00  0.00           C  
ATOM   1227  O   LYS A  79      31.336  13.322  53.683  1.00  0.00           O  
ATOM   1228  CB  LYS A  79      33.803  11.438  54.816  1.00  0.00           C  
ATOM   1229  CG  LYS A  79      34.623  12.718  54.753  1.00  0.00           C  
ATOM   1230  CD  LYS A  79      36.080  12.420  54.431  1.00  0.00           C  
ATOM   1231  CE  LYS A  79      36.962  13.643  54.631  1.00  0.00           C  
ATOM   1232  NZ  LYS A  79      37.036  14.039  56.066  1.00  0.00           N  
ATOM   1233  H   LYS A  79      32.263   9.596  55.608  1.00  0.00           H  
ATOM   1234  HA  LYS A  79      32.209  12.398  55.891  1.00  0.00           H  
ATOM   1235  HB2 LYS A  79      34.224  10.807  55.583  1.00  0.00           H  
ATOM   1236  HB3 LYS A  79      33.892  10.936  53.864  1.00  0.00           H  
ATOM   1237  HG2 LYS A  79      34.219  13.358  53.982  1.00  0.00           H  
ATOM   1238  HG3 LYS A  79      34.569  13.219  55.706  1.00  0.00           H  
ATOM   1239  HD2 LYS A  79      36.426  11.632  55.082  1.00  0.00           H  
ATOM   1240  HD3 LYS A  79      36.153  12.099  53.402  1.00  0.00           H  
ATOM   1241  HE2 LYS A  79      37.958  13.417  54.278  1.00  0.00           H  
ATOM   1242  HE3 LYS A  79      36.555  14.463  54.059  1.00  0.00           H  
ATOM   1243  HZ1 LYS A  79      37.528  13.305  56.615  1.00  0.00           H  
ATOM   1244  HZ2 LYS A  79      36.080  14.158  56.453  1.00  0.00           H  
ATOM   1245  HZ3 LYS A  79      37.553  14.941  56.167  1.00  0.00           H  
ATOM   1246  N   GLU A  80      31.242  11.176  52.999  1.00  0.00           N  
ATOM   1247  CA  GLU A  80      30.451  11.454  51.808  1.00  0.00           C  
ATOM   1248  C   GLU A  80      29.056  11.931  52.200  1.00  0.00           C  
ATOM   1249  O   GLU A  80      28.537  12.900  51.642  1.00  0.00           O  
ATOM   1250  CB  GLU A  80      30.323  10.195  50.952  1.00  0.00           C  
ATOM   1251  CG  GLU A  80      31.646   9.591  50.522  1.00  0.00           C  
ATOM   1252  CD  GLU A  80      31.460   8.263  49.817  1.00  0.00           C  
ATOM   1253  OE1 GLU A  80      30.793   7.370  50.388  1.00  0.00           O  
ATOM   1254  OE2 GLU A  80      31.963   8.110  48.685  1.00  0.00           O  
ATOM   1255  H   GLU A  80      31.545  10.253  53.166  1.00  0.00           H  
ATOM   1256  HA  GLU A  80      30.947  12.226  51.240  1.00  0.00           H  
ATOM   1257  HB2 GLU A  80      29.786   9.447  51.514  1.00  0.00           H  
ATOM   1258  HB3 GLU A  80      29.759  10.437  50.062  1.00  0.00           H  
ATOM   1259  HG2 GLU A  80      32.139  10.275  49.848  1.00  0.00           H  
ATOM   1260  HG3 GLU A  80      32.261   9.438  51.398  1.00  0.00           H  
ATOM   1261  N   GLN A  81      28.458  11.244  53.170  1.00  0.00           N  
ATOM   1262  CA  GLN A  81      27.115  11.576  53.639  1.00  0.00           C  
ATOM   1263  C   GLN A  81      27.070  12.985  54.204  1.00  0.00           C  
ATOM   1264  O   GLN A  81      26.084  13.698  54.031  1.00  0.00           O  
ATOM   1265  CB  GLN A  81      26.655  10.582  54.708  1.00  0.00           C  
ATOM   1266  CG  GLN A  81      26.332   9.204  54.154  1.00  0.00           C  
ATOM   1267  CD  GLN A  81      25.210   9.242  53.132  1.00  0.00           C  
ATOM   1268  OE1 GLN A  81      24.317  10.087  53.200  1.00  0.00           O  
ATOM   1269  NE2 GLN A  81      25.245   8.327  52.178  1.00  0.00           N  
ATOM   1270  H   GLN A  81      28.934  10.492  53.584  1.00  0.00           H  
ATOM   1271  HA  GLN A  81      26.446  11.517  52.796  1.00  0.00           H  
ATOM   1272  HB2 GLN A  81      27.437  10.479  55.447  1.00  0.00           H  
ATOM   1273  HB3 GLN A  81      25.769  10.973  55.187  1.00  0.00           H  
ATOM   1274  HG2 GLN A  81      27.217   8.800  53.683  1.00  0.00           H  
ATOM   1275  HG3 GLN A  81      26.034   8.562  54.971  1.00  0.00           H  
ATOM   1276 HE21 GLN A  81      25.979   7.675  52.184  1.00  0.00           H  
ATOM   1277 HE22 GLN A  81      24.536   8.343  51.492  1.00  0.00           H  
ATOM   1278  N   LEU A  82      28.146  13.376  54.867  1.00  0.00           N  
ATOM   1279  CA  LEU A  82      28.258  14.704  55.443  1.00  0.00           C  
ATOM   1280  C   LEU A  82      28.113  15.773  54.362  1.00  0.00           C  
ATOM   1281  O   LEU A  82      27.377  16.744  54.528  1.00  0.00           O  
ATOM   1282  CB  LEU A  82      29.605  14.838  56.159  1.00  0.00           C  
ATOM   1283  CG  LEU A  82      29.793  16.122  56.960  1.00  0.00           C  
ATOM   1284  CD1 LEU A  82      30.119  15.789  58.406  1.00  0.00           C  
ATOM   1285  CD2 LEU A  82      30.892  16.975  56.344  1.00  0.00           C  
ATOM   1286  H   LEU A  82      28.891  12.743  54.980  1.00  0.00           H  
ATOM   1287  HA  LEU A  82      27.462  14.822  56.164  1.00  0.00           H  
ATOM   1288  HB2 LEU A  82      29.715  13.998  56.832  1.00  0.00           H  
ATOM   1289  HB3 LEU A  82      30.387  14.784  55.418  1.00  0.00           H  
ATOM   1290  HG  LEU A  82      28.874  16.690  56.944  1.00  0.00           H  
ATOM   1291 HD11 LEU A  82      30.200  16.699  58.977  1.00  0.00           H  
ATOM   1292 HD12 LEU A  82      31.056  15.252  58.448  1.00  0.00           H  
ATOM   1293 HD13 LEU A  82      29.332  15.171  58.815  1.00  0.00           H  
ATOM   1294 HD21 LEU A  82      31.044  17.859  56.946  1.00  0.00           H  
ATOM   1295 HD22 LEU A  82      30.604  17.265  55.344  1.00  0.00           H  
ATOM   1296 HD23 LEU A  82      31.809  16.406  56.304  1.00  0.00           H  
ATOM   1297  N   VAL A  83      28.800  15.567  53.245  1.00  0.00           N  
ATOM   1298  CA  VAL A  83      28.728  16.491  52.118  1.00  0.00           C  
ATOM   1299  C   VAL A  83      27.385  16.353  51.398  1.00  0.00           C  
ATOM   1300  O   VAL A  83      26.878  17.306  50.807  1.00  0.00           O  
ATOM   1301  CB  VAL A  83      29.886  16.247  51.125  1.00  0.00           C  
ATOM   1302  CG1 VAL A  83      29.811  17.202  49.942  1.00  0.00           C  
ATOM   1303  CG2 VAL A  83      31.226  16.377  51.831  1.00  0.00           C  
ATOM   1304  H   VAL A  83      29.373  14.772  53.176  1.00  0.00           H  
ATOM   1305  HA  VAL A  83      28.814  17.496  52.506  1.00  0.00           H  
ATOM   1306  HB  VAL A  83      29.802  15.236  50.747  1.00  0.00           H  
ATOM   1307 HG11 VAL A  83      28.883  17.047  49.416  1.00  0.00           H  
ATOM   1308 HG12 VAL A  83      30.639  17.015  49.275  1.00  0.00           H  
ATOM   1309 HG13 VAL A  83      29.858  18.222  50.299  1.00  0.00           H  
ATOM   1310 HG21 VAL A  83      31.294  15.632  52.610  1.00  0.00           H  
ATOM   1311 HG22 VAL A  83      31.311  17.363  52.266  1.00  0.00           H  
ATOM   1312 HG23 VAL A  83      32.023  16.226  51.119  1.00  0.00           H  
ATOM   1313  N   SER A  84      26.799  15.166  51.478  1.00  0.00           N  
ATOM   1314  CA  SER A  84      25.497  14.916  50.875  1.00  0.00           C  
ATOM   1315  C   SER A  84      24.402  15.681  51.621  1.00  0.00           C  
ATOM   1316  O   SER A  84      23.335  15.959  51.067  1.00  0.00           O  
ATOM   1317  CB  SER A  84      25.198  13.417  50.876  1.00  0.00           C  
ATOM   1318  OG  SER A  84      26.234  12.693  50.227  1.00  0.00           O  
ATOM   1319  H   SER A  84      27.256  14.440  51.952  1.00  0.00           H  
ATOM   1320  HA  SER A  84      25.533  15.268  49.853  1.00  0.00           H  
ATOM   1321  HB2 SER A  84      25.114  13.066  51.896  1.00  0.00           H  
ATOM   1322  HB3 SER A  84      24.268  13.237  50.356  1.00  0.00           H  
ATOM   1323  HG  SER A  84      27.089  12.951  50.604  1.00  0.00           H  
ATOM   1324  N   LEU A  85      24.673  16.016  52.880  1.00  0.00           N  
ATOM   1325  CA  LEU A  85      23.752  16.815  53.680  1.00  0.00           C  
ATOM   1326  C   LEU A  85      23.838  18.280  53.275  1.00  0.00           C  
ATOM   1327  O   LEU A  85      22.825  18.976  53.194  1.00  0.00           O  
ATOM   1328  CB  LEU A  85      24.071  16.666  55.170  1.00  0.00           C  
ATOM   1329  CG  LEU A  85      23.950  15.245  55.724  1.00  0.00           C  
ATOM   1330  CD1 LEU A  85      24.442  15.189  57.160  1.00  0.00           C  
ATOM   1331  CD2 LEU A  85      22.511  14.764  55.643  1.00  0.00           C  
ATOM   1332  H   LEU A  85      25.516  15.712  53.282  1.00  0.00           H  
ATOM   1333  HA  LEU A  85      22.751  16.457  53.493  1.00  0.00           H  
ATOM   1334  HB2 LEU A  85      25.081  17.010  55.336  1.00  0.00           H  
ATOM   1335  HB3 LEU A  85      23.396  17.301  55.724  1.00  0.00           H  
ATOM   1336  HG  LEU A  85      24.562  14.579  55.134  1.00  0.00           H  
ATOM   1337 HD11 LEU A  85      24.351  14.180  57.531  1.00  0.00           H  
ATOM   1338 HD12 LEU A  85      23.844  15.852  57.771  1.00  0.00           H  
ATOM   1339 HD13 LEU A  85      25.477  15.498  57.198  1.00  0.00           H  
ATOM   1340 HD21 LEU A  85      22.446  13.757  56.029  1.00  0.00           H  
ATOM   1341 HD22 LEU A  85      22.183  14.778  54.614  1.00  0.00           H  
ATOM   1342 HD23 LEU A  85      21.880  15.415  56.231  1.00  0.00           H  
ATOM   1343  N   LYS A  86      25.055  18.734  53.000  1.00  0.00           N  
ATOM   1344  CA  LYS A  86      25.300  20.109  52.596  1.00  0.00           C  
ATOM   1345  C   LYS A  86      26.680  20.207  51.963  1.00  0.00           C  
ATOM   1346  O   LYS A  86      27.689  19.906  52.594  1.00  0.00           O  
ATOM   1347  CB  LYS A  86      25.187  21.053  53.807  1.00  0.00           C  
ATOM   1348  CG  LYS A  86      25.162  22.540  53.456  1.00  0.00           C  
ATOM   1349  CD  LYS A  86      26.554  23.102  53.197  1.00  0.00           C  
ATOM   1350  CE  LYS A  86      26.492  24.557  52.759  1.00  0.00           C  
ATOM   1351  NZ  LYS A  86      25.843  24.715  51.430  1.00  0.00           N  
ATOM   1352  H   LYS A  86      25.819  18.122  53.075  1.00  0.00           H  
ATOM   1353  HA  LYS A  86      24.554  20.379  51.862  1.00  0.00           H  
ATOM   1354  HB2 LYS A  86      24.278  20.821  54.340  1.00  0.00           H  
ATOM   1355  HB3 LYS A  86      26.029  20.877  54.459  1.00  0.00           H  
ATOM   1356  HG2 LYS A  86      24.564  22.678  52.568  1.00  0.00           H  
ATOM   1357  HG3 LYS A  86      24.714  23.081  54.277  1.00  0.00           H  
ATOM   1358  HD2 LYS A  86      27.134  23.033  54.105  1.00  0.00           H  
ATOM   1359  HD3 LYS A  86      27.028  22.519  52.419  1.00  0.00           H  
ATOM   1360  HE2 LYS A  86      25.929  25.115  53.492  1.00  0.00           H  
ATOM   1361  HE3 LYS A  86      27.499  24.944  52.707  1.00  0.00           H  
ATOM   1362  HZ1 LYS A  86      24.906  24.251  51.423  1.00  0.00           H  
ATOM   1363  HZ2 LYS A  86      26.429  24.289  50.690  1.00  0.00           H  
ATOM   1364  HZ3 LYS A  86      25.713  25.729  51.210  1.00  0.00           H  
ATOM   1365  N   GLY A  87      26.708  20.621  50.708  1.00  0.00           N  
ATOM   1366  CA  GLY A  87      27.950  20.686  49.967  1.00  0.00           C  
ATOM   1367  C   GLY A  87      27.763  20.194  48.548  1.00  0.00           C  
ATOM   1368  O   GLY A  87      28.644  20.375  47.705  1.00  0.00           O  
ATOM   1369  H   GLY A  87      25.862  20.887  50.271  1.00  0.00           H  
ATOM   1370  HA2 GLY A  87      28.293  21.713  49.945  1.00  0.00           H  
ATOM   1371  HA3 GLY A  87      28.690  20.075  50.460  1.00  0.00           H  
ATOM   1372  N   GLY A  88      26.635  19.500  48.337  1.00  0.00           N  
ATOM   1373  CA  GLY A  88      26.167  19.091  47.008  1.00  0.00           C  
ATOM   1374  C   GLY A  88      26.641  19.969  45.859  1.00  0.00           C  
ATOM   1375  O   GLY A  88      26.750  21.188  46.006  1.00  0.00           O  
ATOM   1376  H   GLY A  88      26.100  19.251  49.119  1.00  0.00           H  
ATOM   1377  HA2 GLY A  88      26.504  18.083  46.824  1.00  0.00           H  
ATOM   1378  HA3 GLY A  88      25.086  19.092  47.014  1.00  0.00           H  
ATOM   1379  N   PRO A  89      26.866  19.375  44.674  1.00  0.00           N  
ATOM   1380  CA  PRO A  89      27.389  20.091  43.503  1.00  0.00           C  
ATOM   1381  C   PRO A  89      26.553  21.315  43.122  1.00  0.00           C  
ATOM   1382  O   PRO A  89      27.074  22.279  42.560  1.00  0.00           O  
ATOM   1383  CB  PRO A  89      27.346  19.046  42.378  1.00  0.00           C  
ATOM   1384  CG  PRO A  89      26.477  17.943  42.888  1.00  0.00           C  
ATOM   1385  CD  PRO A  89      26.630  17.953  44.380  1.00  0.00           C  
ATOM   1386  HA  PRO A  89      28.412  20.401  43.661  1.00  0.00           H  
ATOM   1387  HB2 PRO A  89      26.932  19.494  41.487  1.00  0.00           H  
ATOM   1388  HB3 PRO A  89      28.346  18.693  42.174  1.00  0.00           H  
ATOM   1389  HG2 PRO A  89      25.450  18.130  42.616  1.00  0.00           H  
ATOM   1390  HG3 PRO A  89      26.808  16.998  42.482  1.00  0.00           H  
ATOM   1391  HD2 PRO A  89      25.726  17.603  44.853  1.00  0.00           H  
ATOM   1392  HD3 PRO A  89      27.476  17.350  44.681  1.00  0.00           H  
ATOM   1393  N   TYR A  90      25.264  21.283  43.440  1.00  0.00           N  
ATOM   1394  CA  TYR A  90      24.379  22.405  43.147  1.00  0.00           C  
ATOM   1395  C   TYR A  90      24.682  23.582  44.072  1.00  0.00           C  
ATOM   1396  O   TYR A  90      24.549  24.741  43.686  1.00  0.00           O  
ATOM   1397  CB  TYR A  90      22.913  21.985  43.286  1.00  0.00           C  
ATOM   1398  CG  TYR A  90      21.923  23.096  42.992  1.00  0.00           C  
ATOM   1399  CD1 TYR A  90      21.724  23.553  41.695  1.00  0.00           C  
ATOM   1400  CD2 TYR A  90      21.192  23.692  44.014  1.00  0.00           C  
ATOM   1401  CE1 TYR A  90      20.823  24.569  41.424  1.00  0.00           C  
ATOM   1402  CE2 TYR A  90      20.290  24.706  43.751  1.00  0.00           C  
ATOM   1403  CZ  TYR A  90      20.111  25.142  42.455  1.00  0.00           C  
ATOM   1404  OH  TYR A  90      19.214  26.154  42.191  1.00  0.00           O  
ATOM   1405  H   TYR A  90      24.902  20.489  43.887  1.00  0.00           H  
ATOM   1406  HA  TYR A  90      24.561  22.712  42.127  1.00  0.00           H  
ATOM   1407  HB2 TYR A  90      22.713  21.176  42.601  1.00  0.00           H  
ATOM   1408  HB3 TYR A  90      22.739  21.646  44.297  1.00  0.00           H  
ATOM   1409  HD1 TYR A  90      22.284  23.105  40.888  1.00  0.00           H  
ATOM   1410  HD2 TYR A  90      21.333  23.348  45.029  1.00  0.00           H  
ATOM   1411  HE1 TYR A  90      20.682  24.909  40.409  1.00  0.00           H  
ATOM   1412  HE2 TYR A  90      19.733  25.156  44.559  1.00  0.00           H  
ATOM   1413  HH  TYR A  90      19.299  26.836  42.864  1.00  0.00           H  
ATOM   1414  N   GLU A  91      25.118  23.269  45.287  1.00  0.00           N  
ATOM   1415  CA  GLU A  91      25.422  24.288  46.285  1.00  0.00           C  
ATOM   1416  C   GLU A  91      26.787  24.912  46.018  1.00  0.00           C  
ATOM   1417  O   GLU A  91      27.169  25.891  46.658  1.00  0.00           O  
ATOM   1418  CB  GLU A  91      25.395  23.688  47.693  1.00  0.00           C  
ATOM   1419  CG  GLU A  91      24.062  23.062  48.072  1.00  0.00           C  
ATOM   1420  CD  GLU A  91      24.063  22.528  49.488  1.00  0.00           C  
ATOM   1421  OE1 GLU A  91      23.833  23.321  50.425  1.00  0.00           O  
ATOM   1422  OE2 GLU A  91      24.311  21.318  49.672  1.00  0.00           O  
ATOM   1423  H   GLU A  91      25.253  22.323  45.517  1.00  0.00           H  
ATOM   1424  HA  GLU A  91      24.668  25.057  46.214  1.00  0.00           H  
ATOM   1425  HB2 GLU A  91      26.156  22.923  47.761  1.00  0.00           H  
ATOM   1426  HB3 GLU A  91      25.618  24.466  48.408  1.00  0.00           H  
ATOM   1427  HG2 GLU A  91      23.289  23.811  47.987  1.00  0.00           H  
ATOM   1428  HG3 GLU A  91      23.853  22.248  47.394  1.00  0.00           H  
ATOM   1429  N   ASN A  92      27.521  24.333  45.073  1.00  0.00           N  
ATOM   1430  CA  ASN A  92      28.829  24.858  44.695  1.00  0.00           C  
ATOM   1431  C   ASN A  92      28.662  26.183  43.967  1.00  0.00           C  
ATOM   1432  O   ASN A  92      29.418  27.127  44.199  1.00  0.00           O  
ATOM   1433  CB  ASN A  92      29.587  23.861  43.808  1.00  0.00           C  
ATOM   1434  CG  ASN A  92      30.146  22.669  44.576  1.00  0.00           C  
ATOM   1435  OD1 ASN A  92      31.157  22.086  44.184  1.00  0.00           O  
ATOM   1436  ND2 ASN A  92      29.500  22.297  45.668  1.00  0.00           N  
ATOM   1437  H   ASN A  92      27.169  23.543  44.612  1.00  0.00           H  
ATOM   1438  HA  ASN A  92      29.394  25.026  45.600  1.00  0.00           H  
ATOM   1439  HB2 ASN A  92      28.916  23.487  43.050  1.00  0.00           H  
ATOM   1440  HB3 ASN A  92      30.410  24.372  43.330  1.00  0.00           H  
ATOM   1441 HD21 ASN A  92      28.702  22.799  45.930  1.00  0.00           H  
ATOM   1442 HD22 ASN A  92      29.845  21.527  46.175  1.00  0.00           H  
ATOM   1443  N   THR A  93      27.642  26.243  43.104  1.00  0.00           N  
ATOM   1444  CA  THR A  93      27.305  27.450  42.334  1.00  0.00           C  
ATOM   1445  C   THR A  93      28.534  28.067  41.664  1.00  0.00           C  
ATOM   1446  O   THR A  93      28.642  29.287  41.548  1.00  0.00           O  
ATOM   1447  CB  THR A  93      26.597  28.508  43.218  1.00  0.00           C  
ATOM   1448  OG1 THR A  93      27.362  28.772  44.403  1.00  0.00           O  
ATOM   1449  CG2 THR A  93      25.202  28.040  43.611  1.00  0.00           C  
ATOM   1450  H   THR A  93      27.084  25.447  42.988  1.00  0.00           H  
ATOM   1451  HA  THR A  93      26.612  27.152  41.560  1.00  0.00           H  
ATOM   1452  HB  THR A  93      26.506  29.423  42.651  1.00  0.00           H  
ATOM   1453  HG1 THR A  93      28.190  28.270  44.362  1.00  0.00           H  
ATOM   1454 HG21 THR A  93      24.725  28.800  44.213  1.00  0.00           H  
ATOM   1455 HG22 THR A  93      25.276  27.124  44.180  1.00  0.00           H  
ATOM   1456 HG23 THR A  93      24.616  27.865  42.721  1.00  0.00           H  
ATOM   1457  N   THR A  94      29.442  27.209  41.209  1.00  0.00           N  
ATOM   1458  CA  THR A  94      30.687  27.657  40.604  1.00  0.00           C  
ATOM   1459  C   THR A  94      30.443  28.346  39.260  1.00  0.00           C  
ATOM   1460  O   THR A  94      30.627  29.555  39.133  1.00  0.00           O  
ATOM   1461  CB  THR A  94      31.644  26.468  40.407  1.00  0.00           C  
ATOM   1462  OG1 THR A  94      31.632  25.642  41.582  1.00  0.00           O  
ATOM   1463  CG2 THR A  94      33.061  26.949  40.140  1.00  0.00           C  
ATOM   1464  H   THR A  94      29.278  26.250  41.296  1.00  0.00           H  
ATOM   1465  HA  THR A  94      31.154  28.359  41.278  1.00  0.00           H  
ATOM   1466  HB  THR A  94      31.309  25.885  39.560  1.00  0.00           H  
ATOM   1467  HG1 THR A  94      32.256  25.992  42.225  1.00  0.00           H  
ATOM   1468 HG21 THR A  94      33.405  27.537  40.979  1.00  0.00           H  
ATOM   1469 HG22 THR A  94      33.072  27.556  39.248  1.00  0.00           H  
ATOM   1470 HG23 THR A  94      33.712  26.099  40.006  1.00  0.00           H  
ATOM   1471  N   LYS A  95      30.029  27.569  38.264  1.00  0.00           N  
ATOM   1472  CA  LYS A  95      29.771  28.098  36.928  1.00  0.00           C  
ATOM   1473  C   LYS A  95      29.099  27.042  36.067  1.00  0.00           C  
ATOM   1474  O   LYS A  95      27.936  27.182  35.686  1.00  0.00           O  
ATOM   1475  CB  LYS A  95      31.076  28.549  36.269  1.00  0.00           C  
ATOM   1476  CG  LYS A  95      30.887  29.154  34.886  1.00  0.00           C  
ATOM   1477  CD  LYS A  95      32.204  29.650  34.309  1.00  0.00           C  
ATOM   1478  CE  LYS A  95      33.165  28.501  34.041  1.00  0.00           C  
ATOM   1479  NZ  LYS A  95      34.528  28.985  33.704  1.00  0.00           N  
ATOM   1480  H   LYS A  95      29.883  26.618  38.432  1.00  0.00           H  
ATOM   1481  HA  LYS A  95      29.111  28.944  37.023  1.00  0.00           H  
ATOM   1482  HB2 LYS A  95      31.548  29.287  36.900  1.00  0.00           H  
ATOM   1483  HB3 LYS A  95      31.731  27.695  36.177  1.00  0.00           H  
ATOM   1484  HG2 LYS A  95      30.477  28.401  34.229  1.00  0.00           H  
ATOM   1485  HG3 LYS A  95      30.199  29.983  34.959  1.00  0.00           H  
ATOM   1486  HD2 LYS A  95      32.005  30.163  33.380  1.00  0.00           H  
ATOM   1487  HD3 LYS A  95      32.659  30.333  35.011  1.00  0.00           H  
ATOM   1488  HE2 LYS A  95      33.222  27.881  34.924  1.00  0.00           H  
ATOM   1489  HE3 LYS A  95      32.785  27.916  33.217  1.00  0.00           H  
ATOM   1490  HZ1 LYS A  95      34.981  29.400  34.548  1.00  0.00           H  
ATOM   1491  HZ2 LYS A  95      34.483  29.715  32.962  1.00  0.00           H  
ATOM   1492  HZ3 LYS A  95      35.116  28.195  33.362  1.00  0.00           H  
ATOM   1493  N   LEU A  96      29.849  25.977  35.788  1.00  0.00           N  
ATOM   1494  CA  LEU A  96      29.393  24.880  34.933  1.00  0.00           C  
ATOM   1495  C   LEU A  96      29.099  25.374  33.518  1.00  0.00           C  
ATOM   1496  O   LEU A  96      29.968  25.338  32.648  1.00  0.00           O  
ATOM   1497  CB  LEU A  96      28.165  24.161  35.522  1.00  0.00           C  
ATOM   1498  CG  LEU A  96      28.408  23.359  36.809  1.00  0.00           C  
ATOM   1499  CD1 LEU A  96      29.687  22.545  36.700  1.00  0.00           C  
ATOM   1500  CD2 LEU A  96      28.454  24.270  38.027  1.00  0.00           C  
ATOM   1501  H   LEU A  96      30.755  25.930  36.168  1.00  0.00           H  
ATOM   1502  HA  LEU A  96      30.206  24.169  34.872  1.00  0.00           H  
ATOM   1503  HB2 LEU A  96      27.411  24.906  35.729  1.00  0.00           H  
ATOM   1504  HB3 LEU A  96      27.778  23.484  34.773  1.00  0.00           H  
ATOM   1505  HG  LEU A  96      27.591  22.666  36.945  1.00  0.00           H  
ATOM   1506 HD11 LEU A  96      29.839  21.988  37.612  1.00  0.00           H  
ATOM   1507 HD12 LEU A  96      30.523  23.212  36.540  1.00  0.00           H  
ATOM   1508 HD13 LEU A  96      29.609  21.862  35.866  1.00  0.00           H  
ATOM   1509 HD21 LEU A  96      29.272  24.967  37.923  1.00  0.00           H  
ATOM   1510 HD22 LEU A  96      28.597  23.676  38.917  1.00  0.00           H  
ATOM   1511 HD23 LEU A  96      27.524  24.814  38.104  1.00  0.00           H  
ATOM   1512  N   SER A  97      27.886  25.848  33.301  1.00  0.00           N  
ATOM   1513  CA  SER A  97      27.486  26.360  32.001  1.00  0.00           C  
ATOM   1514  C   SER A  97      26.308  27.316  32.143  1.00  0.00           C  
ATOM   1515  O   SER A  97      25.678  27.705  31.157  1.00  0.00           O  
ATOM   1516  CB  SER A  97      27.129  25.195  31.068  1.00  0.00           C  
ATOM   1517  OG  SER A  97      26.224  24.297  31.693  1.00  0.00           O  
ATOM   1518  H   SER A  97      27.237  25.853  34.035  1.00  0.00           H  
ATOM   1519  HA  SER A  97      28.324  26.901  31.584  1.00  0.00           H  
ATOM   1520  HB2 SER A  97      26.666  25.581  30.173  1.00  0.00           H  
ATOM   1521  HB3 SER A  97      28.027  24.657  30.805  1.00  0.00           H  
ATOM   1522  HG  SER A  97      25.430  24.206  31.145  1.00  0.00           H  
ATOM   1523  N   THR A  98      26.032  27.711  33.374  1.00  0.00           N  
ATOM   1524  CA  THR A  98      24.888  28.550  33.667  1.00  0.00           C  
ATOM   1525  C   THR A  98      25.275  30.026  33.656  1.00  0.00           C  
ATOM   1526  O   THR A  98      26.291  30.415  34.231  1.00  0.00           O  
ATOM   1527  CB  THR A  98      24.295  28.182  35.039  1.00  0.00           C  
ATOM   1528  OG1 THR A  98      24.159  26.756  35.133  1.00  0.00           O  
ATOM   1529  CG2 THR A  98      22.939  28.841  35.240  1.00  0.00           C  
ATOM   1530  H   THR A  98      26.623  27.442  34.111  1.00  0.00           H  
ATOM   1531  HA  THR A  98      24.137  28.374  32.912  1.00  0.00           H  
ATOM   1532  HB  THR A  98      24.969  28.525  35.812  1.00  0.00           H  
ATOM   1533  HG1 THR A  98      23.267  26.498  34.855  1.00  0.00           H  
ATOM   1534 HG21 THR A  98      22.267  28.523  34.458  1.00  0.00           H  
ATOM   1535 HG22 THR A  98      23.051  29.914  35.204  1.00  0.00           H  
ATOM   1536 HG23 THR A  98      22.537  28.552  36.200  1.00  0.00           H  
ATOM   1537  N   THR A  99      24.478  30.845  32.982  1.00  0.00           N  
ATOM   1538  CA  THR A  99      24.720  32.272  32.954  1.00  0.00           C  
ATOM   1539  C   THR A  99      23.782  32.981  33.925  1.00  0.00           C  
ATOM   1540  O   THR A  99      22.899  32.352  34.517  1.00  0.00           O  
ATOM   1541  CB  THR A  99      24.551  32.852  31.537  1.00  0.00           C  
ATOM   1542  OG1 THR A  99      23.220  32.626  31.063  1.00  0.00           O  
ATOM   1543  CG2 THR A  99      25.543  32.229  30.571  1.00  0.00           C  
ATOM   1544  H   THR A  99      23.706  30.479  32.495  1.00  0.00           H  
ATOM   1545  HA  THR A  99      25.740  32.439  33.272  1.00  0.00           H  
ATOM   1546  HB  THR A  99      24.734  33.918  31.577  1.00  0.00           H  
ATOM   1547  HG1 THR A  99      22.740  33.474  31.070  1.00  0.00           H  
ATOM   1548 HG21 THR A  99      26.548  32.409  30.920  1.00  0.00           H  
ATOM   1549 HG22 THR A  99      25.416  32.671  29.593  1.00  0.00           H  
ATOM   1550 HG23 THR A  99      25.366  31.166  30.511  1.00  0.00           H  
TER    1551      THR A  99                                                      
END
MOLECULE T0510_235_279.pdb
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
