
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   72 ( 1167),  selected   72 , name 2gpf_A
# Molecule2: number of CA atoms   44 (  374),  selected   44 , name T0510_235_279.pdb
# PARAMETERS: 2gpf_A.T0510_235_279.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    F     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    D     9_A      P     235          3.951
LGA    I    10_A      P     236          2.234
LGA    Q    11_A      T     237          2.515
LGA    F    12_A      P     238          1.495
LGA    Q    13_A      I     239          0.571
LGA    V    14_A      F     240          0.259
LGA    V    15_A      H     241          0.384
LGA    V    16_A      N     243          3.804
LGA    N    17_A      H     244          4.843
LGA    H    18_A      E     245          2.334
LGA    E    19_A      T     246          1.739
LGA    E    20_A      G     247          1.995
LGA    Q    21_A      K     248          1.907
LGA    Y    22_A      E     249          1.542
LGA    S    23_A      D     250          0.681
LGA    I    24_A      F     251          0.660
LGA    W    25_A      Y     252          2.913
LGA    P    26_A      F     253          2.743
LGA    E    27_A      I     254          3.375
LGA    Y    28_A      -       -           -
LGA    K    29_A      K     255          3.219
LGA    E    30_A      L     256          3.690
LGA    I    31_A      N     257          3.219
LGA    P    32_A      Q     258          1.502
LGA    Q    33_A      F     259           #
LGA    G    34_A      N     260          4.796
LGA    W    35_A      D     261          3.314
LGA    R    36_A      D     262          2.072
LGA    A    37_A      T     263          0.652
LGA    A    38_A      V     264          3.104
LGA    G    39_A      -       -           -
LGA    K    40_A      T     265          4.015
LGA    S    41_A      Y     266          2.156
LGA    G    42_A      D     267          3.030
LGA    L    43_A      S     268          1.910
LGA    K    44_A      L     269          1.780
LGA    K    45_A      N     270          1.629
LGA    D    46_A      D     271          1.427
LGA    C    47_A      L     272          1.382
LGA    L    48_A      L     273          1.135
LGA    A    49_A      D     274          0.936
LGA    Y    50_A      R     275          0.674
LGA    I    51_A      F     276          0.931
LGA    E    52_A      Y     277          1.340
LGA    E    53_A      D     278          1.877
LGA    V    54_A      A     279          4.427
LGA    W    55_A      -       -           -
LGA    T    56_A      -       -           -
LGA    D    57_A      -       -           -
LGA    M    58_A      -       -           -
LGA    R    59_A      -       -           -
LGA    P    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    S    62_A      -       -           -
LGA    L    63_A      -       -           -
LGA    R    64_A      -       -           -
LGA    Q    65_A      -       -           -
LGA    H    66_A      -       -           -
LGA    M    67_A      -       -           -
LGA    D    68_A      -       -           -
LGA    K    69_A      -       -           -
LGA    A    70_A      -       -           -
LGA    A    71_A      -       -           -
LGA    G    72_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   72   44    5.0     43    2.51     6.98     67.206     1.647

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.959864 * X  +  -0.257050 * Y  +   0.112191 * Z  +  35.830528
  Y_new =  -0.121113 * X  +   0.019090 * Y  +  -0.992455 * Z  +  28.903917
  Z_new =   0.252969 * X  +  -0.966209 * Y  +  -0.049456 * Z  +  65.328598 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.621937    1.519655  [ DEG:   -92.9302     87.0698 ]
  Theta =  -0.255748   -2.885845  [ DEG:   -14.6533   -165.3467 ]
  Phi   =  -3.016079    0.125514  [ DEG:  -172.8086      7.1914 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gpf_A                                        
REMARK     2: T0510_235_279.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gpf_A.T0510_235_279.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   72   44   5.0   43   2.51    6.98  67.206
REMARK  ---------------------------------------------------------- 
MOLECULE 2gpf_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   17-APR-06   2GPF              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN PA22412 FROM PSEUDOMONAS            
TITLE    2 AERUGINOSA. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
TITLE    3 TARGET PAT86, ONTARIO CENTRE FOR STRUCTURAL PROTEOMICS               
TITLE    4 TARGET PA2412.                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN PA2412;                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PA2412;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 DE3(GOLD);                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: P11                                   
KEYWDS    BETA/ALPHA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.LEMAK,J.A.LUKIN,A.YEE,C.H.ARROWSMITH,NORTHEAST STRUCTURAL           
AUTHOR   2 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   02-JAN-07 2GPF    0                                                
JRNL        AUTH   A.LEMAK,J.A.LUKIN,A.YEE,C.H.ARROWSMITH                       
JRNL        TITL   SOLUTION STRUCTURE OF PA2412 PROTEIN DETERMINED              
JRNL        TITL 2 USING ABACUS PROTOCOL                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2GPF A    1    72  GB     9948456  AAG05800         1     72             
SEQRES   1 A   72  MET THR SER VAL PHE ASP ARG ASP ASP ILE GLN PHE GLN          
SEQRES   2 A   72  VAL VAL VAL ASN HIS GLU GLU GLN TYR SER ILE TRP PRO          
SEQRES   3 A   72  GLU TYR LYS GLU ILE PRO GLN GLY TRP ARG ALA ALA GLY          
SEQRES   4 A   72  LYS SER GLY LEU LYS LYS ASP CYS LEU ALA TYR ILE GLU          
SEQRES   5 A   72  GLU VAL TRP THR ASP MET ARG PRO LEU SER LEU ARG GLN          
SEQRES   6 A   72  HIS MET ASP LYS ALA ALA GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      32.654  53.979  84.309  1.00  0.00           N  
ATOM      2  CA  MET A   1      32.687  52.720  83.539  1.00  0.00           C  
ATOM      3  C   MET A   1      33.340  52.963  82.189  1.00  0.00           C  
ATOM      4  O   MET A   1      33.336  54.082  81.675  1.00  0.00           O  
ATOM      5  CB  MET A   1      31.271  52.172  83.330  1.00  0.00           C  
ATOM      6  CG  MET A   1      30.604  51.627  84.579  1.00  0.00           C  
ATOM      7  SD  MET A   1      28.985  50.903  84.238  1.00  0.00           S  
ATOM      8  CE  MET A   1      29.425  49.556  83.139  1.00  0.00           C  
ATOM      9  H2  MET A   1      33.624  54.338  84.450  1.00  0.00           H  
ATOM     10  HA  MET A   1      33.262  52.000  84.096  1.00  0.00           H  
ATOM     11  HB2 MET A   1      30.658  52.963  82.934  1.00  0.00           H  
ATOM     12  HB3 MET A   1      31.322  51.373  82.594  1.00  0.00           H  
ATOM     13  HG2 MET A   1      31.244  50.861  85.015  1.00  0.00           H  
ATOM     14  HG3 MET A   1      30.481  52.427  85.287  1.00  0.00           H  
ATOM     15  HE1 MET A   1      30.118  48.891  83.651  1.00  0.00           H  
ATOM     16  HE2 MET A   1      29.892  49.952  82.255  1.00  0.00           H  
ATOM     17  HE3 MET A   1      28.539  49.014  82.867  1.00  0.00           H  
ATOM     18  H1  MET A   1      32.095  54.709  83.801  1.00  0.00           H  
ATOM     19  H3  MET A   1      32.216  53.824  85.239  1.00  0.00           H  
ATOM     20  N   THR A   2      33.921  51.912  81.631  1.00  0.00           N  
ATOM     21  CA  THR A   2      34.534  51.985  80.313  1.00  0.00           C  
ATOM     22  C   THR A   2      33.568  51.439  79.258  1.00  0.00           C  
ATOM     23  O   THR A   2      32.701  50.612  79.568  1.00  0.00           O  
ATOM     24  CB  THR A   2      35.874  51.223  80.258  1.00  0.00           C  
ATOM     25  OG1 THR A   2      36.416  51.265  78.932  1.00  0.00           O  
ATOM     26  CG2 THR A   2      35.700  49.788  80.716  1.00  0.00           C  
ATOM     27  H   THR A   2      33.941  51.049  82.113  1.00  0.00           H  
ATOM     28  HA  THR A   2      34.725  53.028  80.106  1.00  0.00           H  
ATOM     29  HB  THR A   2      36.566  51.715  80.932  1.00  0.00           H  
ATOM     30  HG1 THR A   2      37.278  50.838  78.940  1.00  0.00           H  
ATOM     31 HG21 THR A   2      35.326  49.773  81.730  1.00  0.00           H  
ATOM     32 HG22 THR A   2      36.654  49.274  80.680  1.00  0.00           H  
ATOM     33 HG23 THR A   2      35.001  49.292  80.066  1.00  0.00           H  
ATOM     34  N   SER A   3      33.715  51.904  78.020  1.00  0.00           N  
ATOM     35  CA  SER A   3      32.818  51.517  76.937  1.00  0.00           C  
ATOM     36  C   SER A   3      33.497  50.566  75.951  1.00  0.00           C  
ATOM     37  O   SER A   3      33.023  50.380  74.830  1.00  0.00           O  
ATOM     38  CB  SER A   3      32.329  52.757  76.207  1.00  0.00           C  
ATOM     39  OG  SER A   3      31.624  53.619  77.083  1.00  0.00           O  
ATOM     40  H   SER A   3      34.449  52.522  77.831  1.00  0.00           H  
ATOM     41  HA  SER A   3      31.972  51.014  77.380  1.00  0.00           H  
ATOM     42  HB2 SER A   3      33.177  53.293  75.795  1.00  0.00           H  
ATOM     43  HB3 SER A   3      31.671  52.457  75.403  1.00  0.00           H  
ATOM     44  HG  SER A   3      32.209  53.902  77.794  1.00  0.00           H  
ATOM     45  N   VAL A   4      34.623  49.983  76.366  1.00  0.00           N  
ATOM     46  CA  VAL A   4      35.340  49.027  75.523  1.00  0.00           C  
ATOM     47  C   VAL A   4      34.475  47.792  75.274  1.00  0.00           C  
ATOM     48  O   VAL A   4      34.322  47.356  74.126  1.00  0.00           O  
ATOM     49  CB  VAL A   4      36.685  48.605  76.155  1.00  0.00           C  
ATOM     50  CG1 VAL A   4      37.324  47.469  75.367  1.00  0.00           C  
ATOM     51  CG2 VAL A   4      37.632  49.796  76.242  1.00  0.00           C  
ATOM     52  H   VAL A   4      34.978  50.197  77.254  1.00  0.00           H  
ATOM     53  HA  VAL A   4      35.534  49.514  74.587  1.00  0.00           H  
ATOM     54  HB  VAL A   4      36.485  48.244  77.157  1.00  0.00           H  
ATOM     55 HG11 VAL A   4      38.216  47.138  75.882  1.00  0.00           H  
ATOM     56 HG12 VAL A   4      37.591  47.812  74.379  1.00  0.00           H  
ATOM     57 HG13 VAL A   4      36.628  46.650  75.291  1.00  0.00           H  
ATOM     58 HG21 VAL A   4      38.563  49.477  76.669  1.00  0.00           H  
ATOM     59 HG22 VAL A   4      37.188  50.566  76.870  1.00  0.00           H  
ATOM     60 HG23 VAL A   4      37.805  50.185  75.253  1.00  0.00           H  
ATOM     61  N   PHE A   5      33.894  47.285  76.349  1.00  0.00           N  
ATOM     62  CA  PHE A   5      33.082  46.074  76.328  1.00  0.00           C  
ATOM     63  C   PHE A   5      33.945  44.853  75.982  1.00  0.00           C  
ATOM     64  O   PHE A   5      34.492  44.738  74.888  1.00  0.00           O  
ATOM     65  CB  PHE A   5      31.907  46.182  75.354  1.00  0.00           C  
ATOM     66  CG  PHE A   5      31.003  44.986  75.364  1.00  0.00           C  
ATOM     67  CD1 PHE A   5      30.188  44.717  76.449  1.00  0.00           C  
ATOM     68  CD2 PHE A   5      30.971  44.129  74.280  1.00  0.00           C  
ATOM     69  CE1 PHE A   5      29.357  43.611  76.462  1.00  0.00           C  
ATOM     70  CE2 PHE A   5      30.139  43.022  74.274  1.00  0.00           C  
ATOM     71  CZ  PHE A   5      29.333  42.763  75.365  1.00  0.00           C  
ATOM     72  H   PHE A   5      34.016  47.733  77.208  1.00  0.00           H  
ATOM     73  HA  PHE A   5      32.695  45.934  77.325  1.00  0.00           H  
ATOM     74  HB2 PHE A   5      31.317  47.058  75.600  1.00  0.00           H  
ATOM     75  HB3 PHE A   5      32.293  46.298  74.359  1.00  0.00           H  
ATOM     76  HD1 PHE A   5      30.208  45.389  77.306  1.00  0.00           H  
ATOM     77  HD2 PHE A   5      31.606  44.323  73.419  1.00  0.00           H  
ATOM     78  HE1 PHE A   5      28.732  43.415  77.322  1.00  0.00           H  
ATOM     79  HE2 PHE A   5      30.125  42.364  73.422  1.00  0.00           H  
ATOM     80  HZ  PHE A   5      28.691  41.893  75.364  1.00  0.00           H  
ATOM     81  N   ASP A   6      34.069  43.947  76.928  1.00  0.00           N  
ATOM     82  CA  ASP A   6      34.858  42.748  76.726  1.00  0.00           C  
ATOM     83  C   ASP A   6      34.062  41.707  75.952  1.00  0.00           C  
ATOM     84  O   ASP A   6      33.042  41.205  76.438  1.00  0.00           O  
ATOM     85  CB  ASP A   6      35.320  42.186  78.070  1.00  0.00           C  
ATOM     86  CG  ASP A   6      36.359  43.055  78.746  1.00  0.00           C  
ATOM     87  OD1 ASP A   6      35.982  44.034  79.410  1.00  0.00           O  
ATOM     88  OD2 ASP A   6      37.572  42.753  78.612  1.00  0.00           O  
ATOM     89  H   ASP A   6      33.613  44.077  77.779  1.00  0.00           H  
ATOM     90  HA  ASP A   6      35.726  43.007  76.144  1.00  0.00           H  
ATOM     91  HB2 ASP A   6      34.472  42.101  78.736  1.00  0.00           H  
ATOM     92  HB3 ASP A   6      35.752  41.198  77.913  1.00  0.00           H  
ATOM     93  N   ARG A   7      34.514  41.385  74.753  1.00  0.00           N  
ATOM     94  CA  ARG A   7      33.869  40.374  73.938  1.00  0.00           C  
ATOM     95  C   ARG A   7      34.927  39.535  73.210  1.00  0.00           C  
ATOM     96  O   ARG A   7      34.887  39.384  71.992  1.00  0.00           O  
ATOM     97  CB  ARG A   7      32.867  40.991  72.938  1.00  0.00           C  
ATOM     98  CG  ARG A   7      33.488  41.849  71.839  1.00  0.00           C  
ATOM     99  CD  ARG A   7      33.961  43.203  72.349  1.00  0.00           C  
ATOM    100  NE  ARG A   7      34.465  44.040  71.259  1.00  0.00           N  
ATOM    101  CZ  ARG A   7      35.397  44.985  71.406  1.00  0.00           C  
ATOM    102  NH1 ARG A   7      35.911  45.254  72.591  1.00  0.00           N  
ATOM    103  NH2 ARG A   7      35.794  45.688  70.336  1.00  0.00           N  
ATOM    104  H   ARG A   7      35.329  41.830  74.413  1.00  0.00           H  
ATOM    105  HA  ARG A   7      33.336  39.720  74.614  1.00  0.00           H  
ATOM    106  HB2 ARG A   7      32.313  40.193  72.474  1.00  0.00           H  
ATOM    107  HB3 ARG A   7      32.178  41.616  73.495  1.00  0.00           H  
ATOM    108  HG2 ARG A   7      34.325  41.325  71.425  1.00  0.00           H  
ATOM    109  HG3 ARG A   7      32.738  41.992  71.067  1.00  0.00           H  
ATOM    110  HD2 ARG A   7      33.128  43.701  72.821  1.00  0.00           H  
ATOM    111  HD3 ARG A   7      34.751  43.036  73.069  1.00  0.00           H  
ATOM    112  HE  ARG A   7      34.079  43.871  70.359  1.00  0.00           H  
ATOM    113 HH11 ARG A   7      35.598  44.755  73.404  1.00  0.00           H  
ATOM    114 HH12 ARG A   7      36.622  45.961  72.678  1.00  0.00           H  
ATOM    115 HH21 ARG A   7      35.387  45.504  69.425  1.00  0.00           H  
ATOM    116 HH22 ARG A   7      36.488  46.396  70.429  1.00  0.00           H  
ATOM    117  N   ASP A   8      35.861  38.988  73.971  1.00  0.00           N  
ATOM    118  CA  ASP A   8      36.989  38.278  73.398  1.00  0.00           C  
ATOM    119  C   ASP A   8      36.593  36.891  72.932  1.00  0.00           C  
ATOM    120  O   ASP A   8      37.047  35.881  73.486  1.00  0.00           O  
ATOM    121  CB  ASP A   8      38.132  38.176  74.396  1.00  0.00           C  
ATOM    122  CG  ASP A   8      38.837  39.505  74.604  1.00  0.00           C  
ATOM    123  OD1 ASP A   8      38.405  40.284  75.480  1.00  0.00           O  
ATOM    124  OD2 ASP A   8      39.806  39.793  73.866  1.00  0.00           O  
ATOM    125  H   ASP A   8      35.774  39.036  74.953  1.00  0.00           H  
ATOM    126  HA  ASP A   8      37.322  38.847  72.542  1.00  0.00           H  
ATOM    127  HB2 ASP A   8      37.744  37.845  75.352  1.00  0.00           H  
ATOM    128  HB3 ASP A   8      38.857  37.460  74.042  1.00  0.00           H  
ATOM    129  N   ASP A   9      35.740  36.843  71.929  1.00  0.00           N  
ATOM    130  CA  ASP A   9      35.364  35.591  71.303  1.00  0.00           C  
ATOM    131  C   ASP A   9      36.043  35.496  69.950  1.00  0.00           C  
ATOM    132  O   ASP A   9      35.710  36.242  69.029  1.00  0.00           O  
ATOM    133  CB  ASP A   9      33.852  35.501  71.116  1.00  0.00           C  
ATOM    134  CG  ASP A   9      33.097  35.325  72.420  1.00  0.00           C  
ATOM    135  OD1 ASP A   9      33.051  34.188  72.927  1.00  0.00           O  
ATOM    136  OD2 ASP A   9      32.532  36.324  72.927  1.00  0.00           O  
ATOM    137  H   ASP A   9      35.338  37.674  71.611  1.00  0.00           H  
ATOM    138  HA  ASP A   9      35.707  34.789  71.924  1.00  0.00           H  
ATOM    139  HB2 ASP A   9      33.500  36.387  70.640  1.00  0.00           H  
ATOM    140  HB3 ASP A   9      33.622  34.654  70.478  1.00  0.00           H  
ATOM    141  N   ILE A  10      37.009  34.595  69.830  1.00  0.00           N  
ATOM    142  CA  ILE A  10      37.686  34.400  68.563  1.00  0.00           C  
ATOM    143  C   ILE A  10      37.053  33.208  67.846  1.00  0.00           C  
ATOM    144  O   ILE A  10      37.102  32.064  68.315  1.00  0.00           O  
ATOM    145  CB  ILE A  10      39.219  34.215  68.711  1.00  0.00           C  
ATOM    146  CG1 ILE A  10      39.884  34.026  67.349  1.00  0.00           C  
ATOM    147  CG2 ILE A  10      39.566  33.044  69.640  1.00  0.00           C  
ATOM    148  CD1 ILE A  10      41.390  33.977  67.424  1.00  0.00           C  
ATOM    149  H   ILE A  10      37.245  34.033  70.604  1.00  0.00           H  
ATOM    150  HA  ILE A  10      37.520  35.279  67.975  1.00  0.00           H  
ATOM    151  HB  ILE A  10      39.616  35.110  69.173  1.00  0.00           H  
ATOM    152 HG12 ILE A  10      39.531  33.105  66.906  1.00  0.00           H  
ATOM    153 HG13 ILE A  10      39.612  34.863  66.717  1.00  0.00           H  
ATOM    154 HG21 ILE A  10      39.173  33.239  70.628  1.00  0.00           H  
ATOM    155 HG22 ILE A  10      40.642  32.924  69.695  1.00  0.00           H  
ATOM    156 HG23 ILE A  10      39.125  32.139  69.253  1.00  0.00           H  
ATOM    157 HD11 ILE A  10      41.697  33.095  67.968  1.00  0.00           H  
ATOM    158 HD12 ILE A  10      41.760  34.857  67.933  1.00  0.00           H  
ATOM    159 HD13 ILE A  10      41.793  33.943  66.423  1.00  0.00           H  
ATOM    160  N   GLN A  11      36.416  33.494  66.725  1.00  0.00           N  
ATOM    161  CA  GLN A  11      35.648  32.481  66.014  1.00  0.00           C  
ATOM    162  C   GLN A  11      36.461  31.848  64.899  1.00  0.00           C  
ATOM    163  O   GLN A  11      37.319  32.479  64.272  1.00  0.00           O  
ATOM    164  CB  GLN A  11      34.364  33.080  65.441  1.00  0.00           C  
ATOM    165  CG  GLN A  11      33.340  33.470  66.495  1.00  0.00           C  
ATOM    166  CD  GLN A  11      32.061  33.979  65.870  1.00  0.00           C  
ATOM    167  OE1 GLN A  11      32.077  34.542  64.768  1.00  0.00           O  
ATOM    168  NE2 GLN A  11      30.935  33.793  66.557  1.00  0.00           N  
ATOM    169  H   GLN A  11      36.467  34.398  66.349  1.00  0.00           H  
ATOM    170  HA  GLN A  11      35.385  31.725  66.728  1.00  0.00           H  
ATOM    171  HB2 GLN A  11      34.617  33.961  64.873  1.00  0.00           H  
ATOM    172  HB3 GLN A  11      33.906  32.356  64.789  1.00  0.00           H  
ATOM    173  HG2 GLN A  11      33.103  32.597  67.096  1.00  0.00           H  
ATOM    174  HG3 GLN A  11      33.762  34.253  67.119  1.00  0.00           H  
ATOM    175 HE21 GLN A  11      30.999  33.342  67.421  1.00  0.00           H  
ATOM    176 HE22 GLN A  11      30.086  34.107  66.150  1.00  0.00           H  
ATOM    177  N   PHE A  12      36.147  30.590  64.660  1.00  0.00           N  
ATOM    178  CA  PHE A  12      36.776  29.820  63.623  1.00  0.00           C  
ATOM    179  C   PHE A  12      35.690  29.149  62.789  1.00  0.00           C  
ATOM    180  O   PHE A  12      34.499  29.289  63.058  1.00  0.00           O  
ATOM    181  CB  PHE A  12      37.691  28.748  64.231  1.00  0.00           C  
ATOM    182  CG  PHE A  12      38.725  29.300  65.154  1.00  0.00           C  
ATOM    183  CD1 PHE A  12      39.953  29.729  64.647  1.00  0.00           C  
ATOM    184  CD2 PHE A  12      38.507  29.397  66.518  1.00  0.00           C  
ATOM    185  CE1 PHE A  12      40.926  30.244  65.487  1.00  0.00           C  
ATOM    186  CE2 PHE A  12      39.481  29.909  67.351  1.00  0.00           C  
ATOM    187  CZ  PHE A  12      40.689  30.333  66.835  1.00  0.00           C  
ATOM    188  H   PHE A  12      35.451  30.172  65.198  1.00  0.00           H  
ATOM    189  HA  PHE A  12      37.351  30.473  62.993  1.00  0.00           H  
ATOM    190  HB2 PHE A  12      37.089  28.042  64.809  1.00  0.00           H  
ATOM    191  HB3 PHE A  12      38.192  28.214  63.445  1.00  0.00           H  
ATOM    192  HD1 PHE A  12      40.132  29.675  63.578  1.00  0.00           H  
ATOM    193  HD2 PHE A  12      37.559  29.057  66.931  1.00  0.00           H  
ATOM    194  HE1 PHE A  12      41.869  30.571  65.085  1.00  0.00           H  
ATOM    195  HE2 PHE A  12      39.290  29.986  68.396  1.00  0.00           H  
ATOM    196  HZ  PHE A  12      41.441  30.749  67.494  1.00  0.00           H  
ATOM    197  N   GLN A  13      36.131  28.435  61.782  1.00  0.00           N  
ATOM    198  CA  GLN A  13      35.234  27.732  60.893  1.00  0.00           C  
ATOM    199  C   GLN A  13      35.893  26.428  60.450  1.00  0.00           C  
ATOM    200  O   GLN A  13      37.127  26.297  60.533  1.00  0.00           O  
ATOM    201  CB  GLN A  13      34.923  28.596  59.654  1.00  0.00           C  
ATOM    202  CG  GLN A  13      36.161  29.221  59.024  1.00  0.00           C  
ATOM    203  CD  GLN A  13      35.824  30.144  57.875  1.00  0.00           C  
ATOM    204  OE1 GLN A  13      34.763  30.773  57.861  1.00  0.00           O  
ATOM    205  NE2 GLN A  13      36.736  30.270  56.941  1.00  0.00           N  
ATOM    206  H   GLN A  13      37.095  28.361  61.647  1.00  0.00           H  
ATOM    207  HA  GLN A  13      34.320  27.507  61.418  1.00  0.00           H  
ATOM    208  HB2 GLN A  13      34.436  27.992  58.915  1.00  0.00           H  
ATOM    209  HB3 GLN A  13      34.259  29.399  59.950  1.00  0.00           H  
ATOM    210  HG2 GLN A  13      36.699  29.775  59.791  1.00  0.00           H  
ATOM    211  HG3 GLN A  13      36.791  28.442  58.624  1.00  0.00           H  
ATOM    212 HE21 GLN A  13      37.561  29.749  57.040  1.00  0.00           H  
ATOM    213 HE22 GLN A  13      36.551  30.869  56.187  1.00  0.00           H  
ATOM    214  N   VAL A  14      35.105  25.479  59.998  1.00  0.00           N  
ATOM    215  CA  VAL A  14      35.634  24.211  59.523  1.00  0.00           C  
ATOM    216  C   VAL A  14      35.771  24.275  58.026  1.00  0.00           C  
ATOM    217  O   VAL A  14      34.842  24.676  57.335  1.00  0.00           O  
ATOM    218  CB  VAL A  14      34.701  23.045  59.918  1.00  0.00           C  
ATOM    219  CG1 VAL A  14      35.251  21.731  59.398  1.00  0.00           C  
ATOM    220  CG2 VAL A  14      34.515  22.993  61.427  1.00  0.00           C  
ATOM    221  H   VAL A  14      34.128  25.629  59.938  1.00  0.00           H  
ATOM    222  HA  VAL A  14      36.607  24.063  59.964  1.00  0.00           H  
ATOM    223  HB  VAL A  14      33.739  23.211  59.462  1.00  0.00           H  
ATOM    224 HG11 VAL A  14      36.223  21.549  59.824  1.00  0.00           H  
ATOM    225 HG12 VAL A  14      35.326  21.766  58.315  1.00  0.00           H  
ATOM    226 HG13 VAL A  14      34.585  20.913  59.682  1.00  0.00           H  
ATOM    227 HG21 VAL A  14      34.078  23.919  61.782  1.00  0.00           H  
ATOM    228 HG22 VAL A  14      35.482  22.865  61.903  1.00  0.00           H  
ATOM    229 HG23 VAL A  14      33.873  22.169  61.687  1.00  0.00           H  
ATOM    230  N   VAL A  15      36.948  23.951  57.521  1.00  0.00           N  
ATOM    231  CA  VAL A  15      37.168  23.983  56.095  1.00  0.00           C  
ATOM    232  C   VAL A  15      37.474  22.592  55.554  1.00  0.00           C  
ATOM    233  O   VAL A  15      38.098  21.774  56.222  1.00  0.00           O  
ATOM    234  CB  VAL A  15      38.310  24.949  55.709  1.00  0.00           C  
ATOM    235  CG1 VAL A  15      37.912  26.390  55.988  1.00  0.00           C  
ATOM    236  CG2 VAL A  15      39.597  24.592  56.450  1.00  0.00           C  
ATOM    237  H   VAL A  15      37.688  23.688  58.102  1.00  0.00           H  
ATOM    238  HA  VAL A  15      36.263  24.336  55.637  1.00  0.00           H  
ATOM    239  HB  VAL A  15      38.492  24.847  54.641  1.00  0.00           H  
ATOM    240 HG11 VAL A  15      37.026  26.641  55.429  1.00  0.00           H  
ATOM    241 HG12 VAL A  15      38.720  27.045  55.699  1.00  0.00           H  
ATOM    242 HG13 VAL A  15      37.722  26.498  57.056  1.00  0.00           H  
ATOM    243 HG21 VAL A  15      39.416  24.640  57.508  1.00  0.00           H  
ATOM    244 HG22 VAL A  15      40.375  25.305  56.182  1.00  0.00           H  
ATOM    245 HG23 VAL A  15      39.904  23.591  56.162  1.00  0.00           H  
ATOM    246  N   VAL A  16      37.012  22.332  54.337  1.00  0.00           N  
ATOM    247  CA  VAL A  16      37.230  21.055  53.704  1.00  0.00           C  
ATOM    248  C   VAL A  16      38.002  21.231  52.393  1.00  0.00           C  
ATOM    249  O   VAL A  16      37.706  22.112  51.587  1.00  0.00           O  
ATOM    250  CB  VAL A  16      35.901  20.303  53.461  1.00  0.00           C  
ATOM    251  CG1 VAL A  16      34.968  21.107  52.572  1.00  0.00           C  
ATOM    252  CG2 VAL A  16      36.141  18.907  52.881  1.00  0.00           C  
ATOM    253  H   VAL A  16      36.519  23.043  53.863  1.00  0.00           H  
ATOM    254  HA  VAL A  16      37.831  20.467  54.378  1.00  0.00           H  
ATOM    255  HB  VAL A  16      35.404  20.179  54.420  1.00  0.00           H  
ATOM    256 HG11 VAL A  16      34.042  20.567  52.433  1.00  0.00           H  
ATOM    257 HG12 VAL A  16      35.442  21.260  51.616  1.00  0.00           H  
ATOM    258 HG13 VAL A  16      34.763  22.062  53.035  1.00  0.00           H  
ATOM    259 HG21 VAL A  16      36.701  18.328  53.591  1.00  0.00           H  
ATOM    260 HG22 VAL A  16      36.695  18.988  51.970  1.00  0.00           H  
ATOM    261 HG23 VAL A  16      35.191  18.425  52.692  1.00  0.00           H  
ATOM    262  N   ASN A  17      39.006  20.393  52.211  1.00  0.00           N  
ATOM    263  CA  ASN A  17      39.851  20.456  51.032  1.00  0.00           C  
ATOM    264  C   ASN A  17      39.248  19.572  49.946  1.00  0.00           C  
ATOM    265  O   ASN A  17      38.319  18.810  50.192  1.00  0.00           O  
ATOM    266  CB  ASN A  17      41.281  19.976  51.399  1.00  0.00           C  
ATOM    267  CG  ASN A  17      42.261  20.007  50.258  1.00  0.00           C  
ATOM    268  OD1 ASN A  17      42.151  20.818  49.345  1.00  0.00           O  
ATOM    269  ND2 ASN A  17      43.230  19.103  50.287  1.00  0.00           N  
ATOM    270  H   ASN A  17      39.183  19.704  52.893  1.00  0.00           H  
ATOM    271  HA  ASN A  17      39.900  21.480  50.698  1.00  0.00           H  
ATOM    272  HB2 ASN A  17      41.658  20.608  52.205  1.00  0.00           H  
ATOM    273  HB3 ASN A  17      41.221  18.946  51.778  1.00  0.00           H  
ATOM    274 HD21 ASN A  17      43.259  18.480  51.045  1.00  0.00           H  
ATOM    275 HD22 ASN A  17      43.881  19.090  49.556  1.00  0.00           H  
ATOM    276  N   HIS A  18      39.779  19.666  48.730  1.00  0.00           N  
ATOM    277  CA  HIS A  18      39.314  18.817  47.631  1.00  0.00           C  
ATOM    278  C   HIS A  18      39.712  17.338  47.848  1.00  0.00           C  
ATOM    279  O   HIS A  18      39.357  16.463  47.062  1.00  0.00           O  
ATOM    280  CB  HIS A  18      39.812  19.329  46.270  1.00  0.00           C  
ATOM    281  CG  HIS A  18      41.163  19.989  46.290  1.00  0.00           C  
ATOM    282  ND1 HIS A  18      42.346  19.297  46.359  1.00  0.00           N  
ATOM    283  CD2 HIS A  18      41.496  21.295  46.243  1.00  0.00           C  
ATOM    284  CE1 HIS A  18      43.360  20.148  46.351  1.00  0.00           C  
ATOM    285  NE2 HIS A  18      42.871  21.366  46.286  1.00  0.00           N  
ATOM    286  H   HIS A  18      40.516  20.306  48.580  1.00  0.00           H  
ATOM    287  HA  HIS A  18      38.236  18.868  47.636  1.00  0.00           H  
ATOM    288  HB2 HIS A  18      39.869  18.489  45.579  1.00  0.00           H  
ATOM    289  HB3 HIS A  18      39.093  20.049  45.895  1.00  0.00           H  
ATOM    290  HD1 HIS A  18      42.439  18.306  46.415  1.00  0.00           H  
ATOM    291  HD2 HIS A  18      40.815  22.134  46.193  1.00  0.00           H  
ATOM    292  HE1 HIS A  18      44.414  19.886  46.388  1.00  0.00           H  
ATOM    293  HE2 HIS A  18      43.403  22.202  46.443  1.00  0.00           H  
ATOM    294  N   GLU A  19      40.463  17.084  48.918  1.00  0.00           N  
ATOM    295  CA  GLU A  19      40.772  15.717  49.354  1.00  0.00           C  
ATOM    296  C   GLU A  19      39.807  15.313  50.463  1.00  0.00           C  
ATOM    297  O   GLU A  19      40.018  14.303  51.138  1.00  0.00           O  
ATOM    298  CB  GLU A  19      42.215  15.586  49.854  1.00  0.00           C  
ATOM    299  CG  GLU A  19      43.254  15.457  48.749  1.00  0.00           C  
ATOM    300  CD  GLU A  19      43.349  16.682  47.874  1.00  0.00           C  
ATOM    301  OE1 GLU A  19      42.617  16.764  46.874  1.00  0.00           O  
ATOM    302  OE2 GLU A  19      44.166  17.573  48.175  1.00  0.00           O  
ATOM    303  H   GLU A  19      40.840  17.844  49.417  1.00  0.00           H  
ATOM    304  HA  GLU A  19      40.628  15.066  48.506  1.00  0.00           H  
ATOM    305  HB2 GLU A  19      42.458  16.459  50.451  1.00  0.00           H  
ATOM    306  HB3 GLU A  19      42.288  14.699  50.489  1.00  0.00           H  
ATOM    307  HG2 GLU A  19      44.223  15.286  49.198  1.00  0.00           H  
ATOM    308  HG3 GLU A  19      43.000  14.609  48.134  1.00  0.00           H  
ATOM    309  N   GLU A  20      38.782  16.148  50.669  1.00  0.00           N  
ATOM    310  CA  GLU A  20      37.739  15.935  51.680  1.00  0.00           C  
ATOM    311  C   GLU A  20      38.315  15.711  53.069  1.00  0.00           C  
ATOM    312  O   GLU A  20      37.816  14.922  53.848  1.00  0.00           O  
ATOM    313  CB  GLU A  20      36.732  14.834  51.288  1.00  0.00           C  
ATOM    314  CG  GLU A  20      37.283  13.429  51.222  1.00  0.00           C  
ATOM    315  CD  GLU A  20      36.213  12.388  50.939  1.00  0.00           C  
ATOM    316  OE1 GLU A  20      35.794  12.277  49.765  1.00  0.00           O  
ATOM    317  OE2 GLU A  20      35.781  11.698  51.893  1.00  0.00           O  
ATOM    318  H   GLU A  20      38.744  16.974  50.149  1.00  0.00           H  
ATOM    319  HA  GLU A  20      37.185  16.860  51.737  1.00  0.00           H  
ATOM    320  HB2 GLU A  20      35.924  14.833  52.001  1.00  0.00           H  
ATOM    321  HB3 GLU A  20      36.316  15.079  50.305  1.00  0.00           H  
ATOM    322  HG2 GLU A  20      38.025  13.384  50.434  1.00  0.00           H  
ATOM    323  HG3 GLU A  20      37.753  13.192  52.173  1.00  0.00           H  
ATOM    324  N   GLN A  21      39.364  16.459  53.379  1.00  0.00           N  
ATOM    325  CA  GLN A  21      39.939  16.447  54.716  1.00  0.00           C  
ATOM    326  C   GLN A  21      39.385  17.620  55.505  1.00  0.00           C  
ATOM    327  O   GLN A  21      39.071  18.660  54.915  1.00  0.00           O  
ATOM    328  CB  GLN A  21      41.468  16.529  54.654  1.00  0.00           C  
ATOM    329  CG  GLN A  21      41.977  17.859  54.135  1.00  0.00           C  
ATOM    330  CD  GLN A  21      43.469  17.894  53.964  1.00  0.00           C  
ATOM    331  OE1 GLN A  21      43.971  17.595  52.877  1.00  0.00           O  
ATOM    332  NE2 GLN A  21      44.189  18.240  55.024  1.00  0.00           N  
ATOM    333  H   GLN A  21      39.730  17.069  52.714  1.00  0.00           H  
ATOM    334  HA  GLN A  21      39.655  15.536  55.196  1.00  0.00           H  
ATOM    335  HB2 GLN A  21      41.862  16.377  55.653  1.00  0.00           H  
ATOM    336  HB3 GLN A  21      41.839  15.743  54.008  1.00  0.00           H  
ATOM    337  HG2 GLN A  21      41.513  18.070  53.188  1.00  0.00           H  
ATOM    338  HG3 GLN A  21      41.693  18.629  54.840  1.00  0.00           H  
ATOM    339 HE21 GLN A  21      43.720  18.444  55.861  1.00  0.00           H  
ATOM    340 HE22 GLN A  21      45.175  18.273  54.935  1.00  0.00           H  
ATOM    341  N   TYR A  22      39.233  17.470  56.802  1.00  0.00           N  
ATOM    342  CA  TYR A  22      38.578  18.496  57.589  1.00  0.00           C  
ATOM    343  C   TYR A  22      39.587  19.221  58.464  1.00  0.00           C  
ATOM    344  O   TYR A  22      40.298  18.611  59.268  1.00  0.00           O  
ATOM    345  CB  TYR A  22      37.463  17.880  58.435  1.00  0.00           C  
ATOM    346  CG  TYR A  22      36.516  17.024  57.620  1.00  0.00           C  
ATOM    347  CD1 TYR A  22      35.572  17.615  56.785  1.00  0.00           C  
ATOM    348  CD2 TYR A  22      36.574  15.636  57.668  1.00  0.00           C  
ATOM    349  CE1 TYR A  22      34.723  16.851  56.029  1.00  0.00           C  
ATOM    350  CE2 TYR A  22      35.717  14.868  56.907  1.00  0.00           C  
ATOM    351  CZ  TYR A  22      34.797  15.472  56.091  1.00  0.00           C  
ATOM    352  OH  TYR A  22      33.940  14.705  55.329  1.00  0.00           O  
ATOM    353  H   TYR A  22      39.597  16.672  57.250  1.00  0.00           H  
ATOM    354  HA  TYR A  22      38.130  19.200  56.895  1.00  0.00           H  
ATOM    355  HB2 TYR A  22      37.901  17.251  59.185  1.00  0.00           H  
ATOM    356  HB3 TYR A  22      36.881  18.659  58.909  1.00  0.00           H  
ATOM    357  HD1 TYR A  22      35.519  18.694  56.740  1.00  0.00           H  
ATOM    358  HD2 TYR A  22      37.309  15.152  58.298  1.00  0.00           H  
ATOM    359  HE1 TYR A  22      33.986  17.331  55.378  1.00  0.00           H  
ATOM    360  HE2 TYR A  22      35.775  13.777  56.964  1.00  0.00           H  
ATOM    361  HH  TYR A  22      33.964  15.004  54.403  1.00  0.00           H  
ATOM    362  N   SER A  23      39.660  20.543  58.299  1.00  0.00           N  
ATOM    363  CA  SER A  23      40.612  21.364  59.027  1.00  0.00           C  
ATOM    364  C   SER A  23      39.892  22.565  59.618  1.00  0.00           C  
ATOM    365  O   SER A  23      38.710  22.780  59.345  1.00  0.00           O  
ATOM    366  CB  SER A  23      41.750  21.811  58.107  1.00  0.00           C  
ATOM    367  OG  SER A  23      42.428  20.682  57.546  1.00  0.00           O  
ATOM    368  H   SER A  23      39.039  20.967  57.668  1.00  0.00           H  
ATOM    369  HA  SER A  23      41.013  20.767  59.830  1.00  0.00           H  
ATOM    370  HB2 SER A  23      41.345  22.403  57.277  1.00  0.00           H  
ATOM    371  HB3 SER A  23      42.461  22.413  58.655  1.00  0.00           H  
ATOM    372  HG  SER A  23      43.326  20.644  57.911  1.00  0.00           H  
ATOM    373  N   ILE A  24      40.594  23.351  60.421  1.00  0.00           N  
ATOM    374  CA  ILE A  24      39.991  24.548  61.011  1.00  0.00           C  
ATOM    375  C   ILE A  24      40.652  25.804  60.450  1.00  0.00           C  
ATOM    376  O   ILE A  24      41.810  25.788  60.072  1.00  0.00           O  
ATOM    377  CB  ILE A  24      40.101  24.546  62.557  1.00  0.00           C  
ATOM    378  CG1 ILE A  24      41.573  24.556  62.998  1.00  0.00           C  
ATOM    379  CG2 ILE A  24      39.386  23.332  63.116  1.00  0.00           C  
ATOM    380  CD1 ILE A  24      41.766  24.593  64.500  1.00  0.00           C  
ATOM    381  H   ILE A  24      41.528  23.160  60.622  1.00  0.00           H  
ATOM    382  HA  ILE A  24      38.942  24.548  60.749  1.00  0.00           H  
ATOM    383  HB  ILE A  24      39.609  25.430  62.923  1.00  0.00           H  
ATOM    384 HG12 ILE A  24      42.047  23.663  62.633  1.00  0.00           H  
ATOM    385 HG13 ILE A  24      42.056  25.422  62.581  1.00  0.00           H  
ATOM    386 HG21 ILE A  24      39.816  22.434  62.690  1.00  0.00           H  
ATOM    387 HG22 ILE A  24      38.348  23.384  62.876  1.00  0.00           H  
ATOM    388 HG23 ILE A  24      39.501  23.297  64.201  1.00  0.00           H  
ATOM    389 HD11 ILE A  24      41.338  23.694  64.926  1.00  0.00           H  
ATOM    390 HD12 ILE A  24      41.272  25.463  64.896  1.00  0.00           H  
ATOM    391 HD13 ILE A  24      42.824  24.633  64.741  1.00  0.00           H  
ATOM    392  N   TRP A  25      39.888  26.886  60.408  1.00  0.00           N  
ATOM    393  CA  TRP A  25      40.387  28.141  59.891  1.00  0.00           C  
ATOM    394  C   TRP A  25      39.712  29.287  60.641  1.00  0.00           C  
ATOM    395  O   TRP A  25      38.516  29.211  60.921  1.00  0.00           O  
ATOM    396  CB  TRP A  25      40.113  28.211  58.390  1.00  0.00           C  
ATOM    397  CG  TRP A  25      40.807  29.325  57.685  1.00  0.00           C  
ATOM    398  CD1 TRP A  25      40.246  30.490  57.248  1.00  0.00           C  
ATOM    399  CD2 TRP A  25      42.202  29.396  57.325  1.00  0.00           C  
ATOM    400  NE1 TRP A  25      41.193  31.272  56.645  1.00  0.00           N  
ATOM    401  CE2 TRP A  25      42.394  30.619  56.674  1.00  0.00           C  
ATOM    402  CE3 TRP A  25      43.286  28.535  57.499  1.00  0.00           C  
ATOM    403  CZ2 TRP A  25      43.669  31.003  56.189  1.00  0.00           C  
ATOM    404  CZ3 TRP A  25      44.536  28.911  57.014  1.00  0.00           C  
ATOM    405  CH2 TRP A  25      44.711  30.147  56.369  1.00  0.00           C  
ATOM    406  H   TRP A  25      38.960  26.827  60.701  1.00  0.00           H  
ATOM    407  HA  TRP A  25      41.453  28.190  60.061  1.00  0.00           H  
ATOM    408  HB2 TRP A  25      40.435  27.289  57.945  1.00  0.00           H  
ATOM    409  HB3 TRP A  25      39.042  28.321  58.228  1.00  0.00           H  
ATOM    410  HD1 TRP A  25      39.199  30.737  57.373  1.00  0.00           H  
ATOM    411  HE1 TRP A  25      41.027  32.161  56.239  1.00  0.00           H  
ATOM    412  HE3 TRP A  25      43.173  27.580  57.996  1.00  0.00           H  
ATOM    413  HZ2 TRP A  25      43.810  31.953  55.689  1.00  0.00           H  
ATOM    414  HZ3 TRP A  25      45.378  28.249  57.141  1.00  0.00           H  
ATOM    415  HH2 TRP A  25      45.692  30.395  56.004  1.00  0.00           H  
ATOM    416  N   PRO A  26      40.467  30.324  61.041  1.00  0.00           N  
ATOM    417  CA  PRO A  26      39.891  31.496  61.736  1.00  0.00           C  
ATOM    418  C   PRO A  26      38.905  32.265  60.864  1.00  0.00           C  
ATOM    419  O   PRO A  26      39.113  32.447  59.662  1.00  0.00           O  
ATOM    420  CB  PRO A  26      41.108  32.351  62.060  1.00  0.00           C  
ATOM    421  CG  PRO A  26      42.284  31.412  61.963  1.00  0.00           C  
ATOM    422  CD  PRO A  26      41.919  30.446  60.870  1.00  0.00           C  
ATOM    423  HA  PRO A  26      39.405  31.195  62.658  1.00  0.00           H  
ATOM    424  HB2 PRO A  26      41.169  33.157  61.360  1.00  0.00           H  
ATOM    425  HB3 PRO A  26      41.013  32.746  63.060  1.00  0.00           H  
ATOM    426  HG2 PRO A  26      43.167  31.977  61.694  1.00  0.00           H  
ATOM    427  HG3 PRO A  26      42.435  30.892  62.891  1.00  0.00           H  
ATOM    428  HD2 PRO A  26      42.171  30.839  59.906  1.00  0.00           H  
ATOM    429  HD3 PRO A  26      42.408  29.494  61.038  1.00  0.00           H  
ATOM    430  N   GLU A  27      37.811  32.721  61.479  1.00  0.00           N  
ATOM    431  CA  GLU A  27      36.727  33.425  60.787  1.00  0.00           C  
ATOM    432  C   GLU A  27      37.212  34.728  60.145  1.00  0.00           C  
ATOM    433  O   GLU A  27      36.646  35.219  59.180  1.00  0.00           O  
ATOM    434  CB  GLU A  27      35.617  33.727  61.804  1.00  0.00           C  
ATOM    435  CG  GLU A  27      34.471  34.554  61.266  1.00  0.00           C  
ATOM    436  CD  GLU A  27      33.617  33.818  60.244  1.00  0.00           C  
ATOM    437  OE1 GLU A  27      32.966  32.822  60.614  1.00  0.00           O  
ATOM    438  OE2 GLU A  27      33.585  34.242  59.075  1.00  0.00           O  
ATOM    439  H   GLU A  27      37.714  32.579  62.444  1.00  0.00           H  
ATOM    440  HA  GLU A  27      36.334  32.778  60.028  1.00  0.00           H  
ATOM    441  HB2 GLU A  27      35.214  32.782  62.155  1.00  0.00           H  
ATOM    442  HB3 GLU A  27      36.064  34.252  62.646  1.00  0.00           H  
ATOM    443  HG2 GLU A  27      33.834  34.850  62.085  1.00  0.00           H  
ATOM    444  HG3 GLU A  27      34.871  35.436  60.786  1.00  0.00           H  
ATOM    445  N   TYR A  28      38.276  35.291  60.700  1.00  0.00           N  
ATOM    446  CA  TYR A  28      38.755  36.599  60.309  1.00  0.00           C  
ATOM    447  C   TYR A  28      39.734  36.505  59.137  1.00  0.00           C  
ATOM    448  O   TYR A  28      40.178  37.525  58.609  1.00  0.00           O  
ATOM    449  CB  TYR A  28      39.437  37.269  61.491  1.00  0.00           C  
ATOM    450  CG  TYR A  28      38.670  37.048  62.782  1.00  0.00           C  
ATOM    451  CD1 TYR A  28      37.660  37.923  63.180  1.00  0.00           C  
ATOM    452  CD2 TYR A  28      38.955  35.956  63.598  1.00  0.00           C  
ATOM    453  CE1 TYR A  28      36.958  37.710  64.332  1.00  0.00           C  
ATOM    454  CE2 TYR A  28      38.246  35.731  64.739  1.00  0.00           C  
ATOM    455  CZ  TYR A  28      37.239  36.600  65.122  1.00  0.00           C  
ATOM    456  OH  TYR A  28      36.538  36.383  66.271  1.00  0.00           O  
ATOM    457  H   TYR A  28      38.736  34.799  61.419  1.00  0.00           H  
ATOM    458  HA  TYR A  28      37.902  37.193  60.002  1.00  0.00           H  
ATOM    459  HB2 TYR A  28      40.432  36.862  61.620  1.00  0.00           H  
ATOM    460  HB3 TYR A  28      39.492  38.331  61.326  1.00  0.00           H  
ATOM    461  HD1 TYR A  28      37.440  38.780  62.563  1.00  0.00           H  
ATOM    462  HD2 TYR A  28      39.726  35.272  63.294  1.00  0.00           H  
ATOM    463  HE1 TYR A  28      36.173  38.386  64.622  1.00  0.00           H  
ATOM    464  HE2 TYR A  28      38.486  34.867  65.348  1.00  0.00           H  
ATOM    465  HH  TYR A  28      35.605  36.611  66.125  1.00  0.00           H  
ATOM    466  N   LYS A  29      40.057  35.285  58.726  1.00  0.00           N  
ATOM    467  CA  LYS A  29      41.032  35.107  57.656  1.00  0.00           C  
ATOM    468  C   LYS A  29      40.351  34.570  56.405  1.00  0.00           C  
ATOM    469  O   LYS A  29      39.397  33.792  56.476  1.00  0.00           O  
ATOM    470  CB  LYS A  29      42.132  34.131  58.088  1.00  0.00           C  
ATOM    471  CG  LYS A  29      42.893  34.604  59.320  1.00  0.00           C  
ATOM    472  CD  LYS A  29      43.979  33.623  59.725  1.00  0.00           C  
ATOM    473  CE  LYS A  29      44.589  33.989  61.070  1.00  0.00           C  
ATOM    474  NZ  LYS A  29      45.357  35.263  61.028  1.00  0.00           N  
ATOM    475  H   LYS A  29      39.631  34.496  59.130  1.00  0.00           H  
ATOM    476  HA  LYS A  29      41.476  36.061  57.440  1.00  0.00           H  
ATOM    477  HB2 LYS A  29      41.686  33.169  58.319  1.00  0.00           H  
ATOM    478  HB3 LYS A  29      42.838  34.008  57.276  1.00  0.00           H  
ATOM    479  HG2 LYS A  29      43.347  35.560  59.094  1.00  0.00           H  
ATOM    480  HG3 LYS A  29      42.186  34.719  60.133  1.00  0.00           H  
ATOM    481  HD2 LYS A  29      43.564  32.646  59.782  1.00  0.00           H  
ATOM    482  HD3 LYS A  29      44.756  33.645  58.974  1.00  0.00           H  
ATOM    483  HE2 LYS A  29      43.798  34.081  61.800  1.00  0.00           H  
ATOM    484  HE3 LYS A  29      45.258  33.185  61.378  1.00  0.00           H  
ATOM    485  HZ1 LYS A  29      46.110  35.223  60.297  1.00  0.00           H  
ATOM    486  HZ2 LYS A  29      45.807  35.436  61.943  1.00  0.00           H  
ATOM    487  HZ3 LYS A  29      44.720  36.061  60.811  1.00  0.00           H  
ATOM    488  N   GLU A  30      40.848  34.987  55.251  1.00  0.00           N  
ATOM    489  CA  GLU A  30      40.368  34.485  53.969  1.00  0.00           C  
ATOM    490  C   GLU A  30      40.861  33.066  53.751  1.00  0.00           C  
ATOM    491  O   GLU A  30      42.028  32.756  54.045  1.00  0.00           O  
ATOM    492  CB  GLU A  30      40.886  35.390  52.843  1.00  0.00           C  
ATOM    493  CG  GLU A  30      40.493  34.919  51.455  1.00  0.00           C  
ATOM    494  CD  GLU A  30      41.163  35.740  50.367  1.00  0.00           C  
ATOM    495  OE1 GLU A  30      42.373  35.532  50.126  1.00  0.00           O  
ATOM    496  OE2 GLU A  30      40.486  36.587  49.754  1.00  0.00           O  
ATOM    497  H   GLU A  30      41.549  35.678  55.256  1.00  0.00           H  
ATOM    498  HA  GLU A  30      39.289  34.484  53.980  1.00  0.00           H  
ATOM    499  HB2 GLU A  30      40.477  36.387  52.986  1.00  0.00           H  
ATOM    500  HB3 GLU A  30      41.967  35.438  52.899  1.00  0.00           H  
ATOM    501  HG2 GLU A  30      40.792  33.881  51.336  1.00  0.00           H  
ATOM    502  HG3 GLU A  30      39.422  34.996  51.339  1.00  0.00           H  
ATOM    503  N   ILE A  31      39.998  32.202  53.239  1.00  0.00           N  
ATOM    504  CA  ILE A  31      40.342  30.810  53.004  1.00  0.00           C  
ATOM    505  C   ILE A  31      41.213  30.683  51.758  1.00  0.00           C  
ATOM    506  O   ILE A  31      40.972  31.364  50.762  1.00  0.00           O  
ATOM    507  CB  ILE A  31      39.080  29.939  52.811  1.00  0.00           C  
ATOM    508  CG1 ILE A  31      38.093  30.162  53.948  1.00  0.00           C  
ATOM    509  CG2 ILE A  31      39.440  28.473  52.711  1.00  0.00           C  
ATOM    510  CD1 ILE A  31      36.784  29.411  53.778  1.00  0.00           C  
ATOM    511  H   ILE A  31      39.093  32.497  52.997  1.00  0.00           H  
ATOM    512  HA  ILE A  31      40.896  30.431  53.855  1.00  0.00           H  
ATOM    513  HB  ILE A  31      38.617  30.227  51.884  1.00  0.00           H  
ATOM    514 HG12 ILE A  31      38.539  29.833  54.872  1.00  0.00           H  
ATOM    515 HG13 ILE A  31      37.860  31.217  54.023  1.00  0.00           H  
ATOM    516 HG21 ILE A  31      39.959  28.168  53.607  1.00  0.00           H  
ATOM    517 HG22 ILE A  31      40.078  28.310  51.855  1.00  0.00           H  
ATOM    518 HG23 ILE A  31      38.544  27.890  52.614  1.00  0.00           H  
ATOM    519 HD11 ILE A  31      36.996  28.338  53.724  1.00  0.00           H  
ATOM    520 HD12 ILE A  31      36.298  29.718  52.872  1.00  0.00           H  
ATOM    521 HD13 ILE A  31      36.135  29.597  54.634  1.00  0.00           H  
ATOM    522  N   PRO A  32      42.270  29.872  51.833  1.00  0.00           N  
ATOM    523  CA  PRO A  32      43.107  29.581  50.668  1.00  0.00           C  
ATOM    524  C   PRO A  32      42.280  28.956  49.549  1.00  0.00           C  
ATOM    525  O   PRO A  32      41.397  28.143  49.813  1.00  0.00           O  
ATOM    526  CB  PRO A  32      44.129  28.556  51.204  1.00  0.00           C  
ATOM    527  CG  PRO A  32      44.132  28.763  52.675  1.00  0.00           C  
ATOM    528  CD  PRO A  32      42.751  29.178  53.045  1.00  0.00           C  
ATOM    529  HA  PRO A  32      43.613  30.462  50.306  1.00  0.00           H  
ATOM    530  HB2 PRO A  32      43.815  27.550  50.936  1.00  0.00           H  
ATOM    531  HB3 PRO A  32      45.092  28.757  50.771  1.00  0.00           H  
ATOM    532  HG2 PRO A  32      44.389  27.829  53.182  1.00  0.00           H  
ATOM    533  HG3 PRO A  32      44.848  29.534  52.933  1.00  0.00           H  
ATOM    534  HD2 PRO A  32      42.149  28.314  53.248  1.00  0.00           H  
ATOM    535  HD3 PRO A  32      42.760  29.843  53.886  1.00  0.00           H  
ATOM    536  N   GLN A  33      42.580  29.358  48.310  1.00  0.00           N  
ATOM    537  CA  GLN A  33      41.845  28.841  47.168  1.00  0.00           C  
ATOM    538  C   GLN A  33      42.057  27.338  47.023  1.00  0.00           C  
ATOM    539  O   GLN A  33      43.193  26.858  46.926  1.00  0.00           O  
ATOM    540  CB  GLN A  33      42.263  29.586  45.890  1.00  0.00           C  
ATOM    541  CG  GLN A  33      43.765  29.618  45.641  1.00  0.00           C  
ATOM    542  CD  GLN A  33      44.137  30.393  44.389  1.00  0.00           C  
ATOM    543  OE1 GLN A  33      43.390  30.421  43.407  1.00  0.00           O  
ATOM    544  NE2 GLN A  33      45.291  31.034  44.414  1.00  0.00           N  
ATOM    545  H   GLN A  33      43.318  29.965  48.158  1.00  0.00           H  
ATOM    546  HA  GLN A  33      40.806  29.033  47.363  1.00  0.00           H  
ATOM    547  HB2 GLN A  33      41.788  29.106  45.037  1.00  0.00           H  
ATOM    548  HB3 GLN A  33      41.905  30.600  45.964  1.00  0.00           H  
ATOM    549  HG2 GLN A  33      44.244  30.080  46.491  1.00  0.00           H  
ATOM    550  HG3 GLN A  33      44.125  28.610  45.546  1.00  0.00           H  
ATOM    551 HE21 GLN A  33      45.831  30.975  45.232  1.00  0.00           H  
ATOM    552 HE22 GLN A  33      45.550  31.550  43.616  1.00  0.00           H  
ATOM    553  N   GLY A  34      40.962  26.603  47.047  1.00  0.00           N  
ATOM    554  CA  GLY A  34      41.027  25.157  47.002  1.00  0.00           C  
ATOM    555  C   GLY A  34      40.285  24.533  48.161  1.00  0.00           C  
ATOM    556  O   GLY A  34      40.013  23.327  48.155  1.00  0.00           O  
ATOM    557  H   GLY A  34      40.081  27.039  47.074  1.00  0.00           H  
ATOM    558  HA2 GLY A  34      40.588  24.816  46.071  1.00  0.00           H  
ATOM    559  HA3 GLY A  34      42.063  24.853  47.041  1.00  0.00           H  
ATOM    560  N   TRP A  35      39.944  25.340  49.151  1.00  0.00           N  
ATOM    561  CA  TRP A  35      39.205  24.883  50.299  1.00  0.00           C  
ATOM    562  C   TRP A  35      37.872  25.612  50.345  1.00  0.00           C  
ATOM    563  O   TRP A  35      37.706  26.645  49.689  1.00  0.00           O  
ATOM    564  CB  TRP A  35      39.965  25.170  51.594  1.00  0.00           C  
ATOM    565  CG  TRP A  35      41.291  24.526  51.702  1.00  0.00           C  
ATOM    566  CD1 TRP A  35      42.403  24.762  50.956  1.00  0.00           C  
ATOM    567  CD2 TRP A  35      41.673  23.511  52.650  1.00  0.00           C  
ATOM    568  NE1 TRP A  35      43.444  23.981  51.360  1.00  0.00           N  
ATOM    569  CE2 TRP A  35      43.020  23.200  52.405  1.00  0.00           C  
ATOM    570  CE3 TRP A  35      40.997  22.869  53.687  1.00  0.00           C  
ATOM    571  CZ2 TRP A  35      43.692  22.251  53.165  1.00  0.00           C  
ATOM    572  CZ3 TRP A  35      41.680  21.930  54.442  1.00  0.00           C  
ATOM    573  CH2 TRP A  35      43.019  21.623  54.167  1.00  0.00           C  
ATOM    574  H   TRP A  35      40.198  26.287  49.126  1.00  0.00           H  
ATOM    575  HA  TRP A  35      39.033  23.823  50.203  1.00  0.00           H  
ATOM    576  HB2 TRP A  35      40.093  26.238  51.682  1.00  0.00           H  
ATOM    577  HB3 TRP A  35      39.341  24.839  52.430  1.00  0.00           H  
ATOM    578  HD1 TRP A  35      42.438  25.478  50.147  1.00  0.00           H  
ATOM    579  HE1 TRP A  35      44.342  23.964  50.970  1.00  0.00           H  
ATOM    580  HE3 TRP A  35      39.955  23.094  53.905  1.00  0.00           H  
ATOM    581  HZ2 TRP A  35      44.735  21.994  52.968  1.00  0.00           H  
ATOM    582  HZ3 TRP A  35      41.170  21.408  55.236  1.00  0.00           H  
ATOM    583  HH2 TRP A  35      43.512  20.876  54.777  1.00  0.00           H  
ATOM    584  N   ARG A  36      36.914  25.089  51.107  1.00  0.00           N  
ATOM    585  CA  ARG A  36      35.667  25.798  51.331  1.00  0.00           C  
ATOM    586  C   ARG A  36      35.224  25.579  52.773  1.00  0.00           C  
ATOM    587  O   ARG A  36      35.694  24.663  53.446  1.00  0.00           O  
ATOM    588  CB  ARG A  36      34.581  25.302  50.379  1.00  0.00           C  
ATOM    589  CG  ARG A  36      34.115  23.888  50.649  1.00  0.00           C  
ATOM    590  CD  ARG A  36      32.800  23.580  49.947  1.00  0.00           C  
ATOM    591  NE  ARG A  36      32.218  22.335  50.422  1.00  0.00           N  
ATOM    592  CZ  ARG A  36      31.097  22.258  51.142  1.00  0.00           C  
ATOM    593  NH1 ARG A  36      30.421  23.354  51.449  1.00  0.00           N  
ATOM    594  NH2 ARG A  36      30.646  21.076  51.564  1.00  0.00           N  
ATOM    595  H   ARG A  36      37.076  24.216  51.520  1.00  0.00           H  
ATOM    596  HA  ARG A  36      35.843  26.847  51.169  1.00  0.00           H  
ATOM    597  HB2 ARG A  36      33.725  25.967  50.467  1.00  0.00           H  
ATOM    598  HB3 ARG A  36      34.961  25.344  49.374  1.00  0.00           H  
ATOM    599  HG2 ARG A  36      34.869  23.194  50.300  1.00  0.00           H  
ATOM    600  HG3 ARG A  36      33.971  23.769  51.721  1.00  0.00           H  
ATOM    601  HD2 ARG A  36      32.107  24.398  50.147  1.00  0.00           H  
ATOM    602  HD3 ARG A  36      32.974  23.525  48.882  1.00  0.00           H  
ATOM    603  HE  ARG A  36      32.701  21.497  50.199  1.00  0.00           H  
ATOM    604 HH11 ARG A  36      30.749  24.264  51.145  1.00  0.00           H  
ATOM    605 HH12 ARG A  36      29.570  23.290  51.982  1.00  0.00           H  
ATOM    606 HH21 ARG A  36      31.150  20.240  51.349  1.00  0.00           H  
ATOM    607 HH22 ARG A  36      29.798  21.031  52.099  1.00  0.00           H  
ATOM    608  N   ALA A  37      34.341  26.431  53.232  1.00  0.00           N  
ATOM    609  CA  ALA A  37      33.813  26.327  54.589  1.00  0.00           C  
ATOM    610  C   ALA A  37      32.709  25.282  54.645  1.00  0.00           C  
ATOM    611  O   ALA A  37      31.907  25.152  53.719  1.00  0.00           O  
ATOM    612  CB  ALA A  37      33.293  27.679  55.082  1.00  0.00           C  
ATOM    613  H   ALA A  37      34.021  27.165  52.667  1.00  0.00           H  
ATOM    614  HA  ALA A  37      34.622  26.037  55.223  1.00  0.00           H  
ATOM    615  HB1 ALA A  37      32.483  28.013  54.448  1.00  0.00           H  
ATOM    616  HB2 ALA A  37      34.093  28.410  55.049  1.00  0.00           H  
ATOM    617  HB3 ALA A  37      32.941  27.575  56.098  1.00  0.00           H  
ATOM    618  N   ALA A  38      32.694  24.534  55.737  1.00  0.00           N  
ATOM    619  CA  ALA A  38      31.721  23.475  55.917  1.00  0.00           C  
ATOM    620  C   ALA A  38      31.407  23.284  57.399  1.00  0.00           C  
ATOM    621  O   ALA A  38      32.124  23.776  58.266  1.00  0.00           O  
ATOM    622  CB  ALA A  38      32.257  22.171  55.327  1.00  0.00           C  
ATOM    623  H   ALA A  38      33.349  24.702  56.462  1.00  0.00           H  
ATOM    624  HA  ALA A  38      30.821  23.742  55.389  1.00  0.00           H  
ATOM    625  HB1 ALA A  38      31.513  21.406  55.434  1.00  0.00           H  
ATOM    626  HB2 ALA A  38      33.161  21.887  55.837  1.00  0.00           H  
ATOM    627  HB3 ALA A  38      32.471  22.319  54.269  1.00  0.00           H  
ATOM    628  N   GLY A  39      30.307  22.579  57.677  1.00  0.00           N  
ATOM    629  CA  GLY A  39      29.953  22.297  59.050  1.00  0.00           C  
ATOM    630  C   GLY A  39      29.425  23.521  59.776  1.00  0.00           C  
ATOM    631  O   GLY A  39      28.498  24.183  59.310  1.00  0.00           O  
ATOM    632  H   GLY A  39      29.718  22.268  56.945  1.00  0.00           H  
ATOM    633  HA2 GLY A  39      29.204  21.529  59.067  1.00  0.00           H  
ATOM    634  HA3 GLY A  39      30.829  21.938  59.574  1.00  0.00           H  
ATOM    635  N   LYS A  40      30.049  23.831  60.897  1.00  0.00           N  
ATOM    636  CA  LYS A  40      29.619  24.956  61.717  1.00  0.00           C  
ATOM    637  C   LYS A  40      30.790  25.899  62.014  1.00  0.00           C  
ATOM    638  O   LYS A  40      31.944  25.458  62.123  1.00  0.00           O  
ATOM    639  CB  LYS A  40      29.018  24.459  63.045  1.00  0.00           C  
ATOM    640  CG  LYS A  40      28.461  25.582  63.909  1.00  0.00           C  
ATOM    641  CD  LYS A  40      28.100  25.096  65.302  1.00  0.00           C  
ATOM    642  CE  LYS A  40      27.405  26.193  66.101  1.00  0.00           C  
ATOM    643  NZ  LYS A  40      28.275  27.386  66.266  1.00  0.00           N  
ATOM    644  H   LYS A  40      30.829  23.292  61.186  1.00  0.00           H  
ATOM    645  HA  LYS A  40      28.859  25.503  61.174  1.00  0.00           H  
ATOM    646  HB2 LYS A  40      28.223  23.756  62.842  1.00  0.00           H  
ATOM    647  HB3 LYS A  40      29.801  23.959  63.611  1.00  0.00           H  
ATOM    648  HG2 LYS A  40      29.200  26.363  63.992  1.00  0.00           H  
ATOM    649  HG3 LYS A  40      27.570  25.967  63.426  1.00  0.00           H  
ATOM    650  HD2 LYS A  40      27.423  24.251  65.221  1.00  0.00           H  
ATOM    651  HD3 LYS A  40      28.991  24.792  65.827  1.00  0.00           H  
ATOM    652  HE2 LYS A  40      26.491  26.477  65.585  1.00  0.00           H  
ATOM    653  HE3 LYS A  40      27.164  25.802  67.074  1.00  0.00           H  
ATOM    654  HZ1 LYS A  40      28.667  27.676  65.335  1.00  0.00           H  
ATOM    655  HZ2 LYS A  40      29.064  27.188  66.917  1.00  0.00           H  
ATOM    656  HZ3 LYS A  40      27.724  28.191  66.641  1.00  0.00           H  
ATOM    657  N   SER A  41      30.492  27.182  62.092  1.00  0.00           N  
ATOM    658  CA  SER A  41      31.485  28.171  62.502  1.00  0.00           C  
ATOM    659  C   SER A  41      31.210  28.572  63.942  1.00  0.00           C  
ATOM    660  O   SER A  41      30.057  28.561  64.390  1.00  0.00           O  
ATOM    661  CB  SER A  41      31.411  29.384  61.578  1.00  0.00           C  
ATOM    662  OG  SER A  41      31.555  28.991  60.215  1.00  0.00           O  
ATOM    663  H   SER A  41      29.585  27.478  61.855  1.00  0.00           H  
ATOM    664  HA  SER A  41      32.472  27.721  62.437  1.00  0.00           H  
ATOM    665  HB2 SER A  41      30.458  29.871  61.698  1.00  0.00           H  
ATOM    666  HB3 SER A  41      32.222  30.071  61.827  1.00  0.00           H  
ATOM    667  HG  SER A  41      31.812  29.766  59.679  1.00  0.00           H  
ATOM    668  N   GLY A  42      32.264  28.883  64.682  1.00  0.00           N  
ATOM    669  CA  GLY A  42      32.108  29.206  66.085  1.00  0.00           C  
ATOM    670  C   GLY A  42      33.428  29.142  66.820  1.00  0.00           C  
ATOM    671  O   GLY A  42      34.461  29.445  66.254  1.00  0.00           O  
ATOM    672  H   GLY A  42      33.164  28.878  64.289  1.00  0.00           H  
ATOM    673  HA2 GLY A  42      31.704  30.203  66.176  1.00  0.00           H  
ATOM    674  HA3 GLY A  42      31.424  28.502  66.521  1.00  0.00           H  
ATOM    675  N   LEU A  43      33.401  28.717  68.068  1.00  0.00           N  
ATOM    676  CA  LEU A  43      34.619  28.640  68.876  1.00  0.00           C  
ATOM    677  C   LEU A  43      35.474  27.458  68.428  1.00  0.00           C  
ATOM    678  O   LEU A  43      35.013  26.587  67.678  1.00  0.00           O  
ATOM    679  CB  LEU A  43      34.286  28.510  70.364  1.00  0.00           C  
ATOM    680  CG  LEU A  43      33.679  29.744  71.039  1.00  0.00           C  
ATOM    681  CD1 LEU A  43      34.489  30.984  70.748  1.00  0.00           C  
ATOM    682  CD2 LEU A  43      32.225  29.925  70.603  1.00  0.00           C  
ATOM    683  H   LEU A  43      32.540  28.462  68.454  1.00  0.00           H  
ATOM    684  HA  LEU A  43      35.185  29.549  68.715  1.00  0.00           H  
ATOM    685  HB2 LEU A  43      33.589  27.694  70.483  1.00  0.00           H  
ATOM    686  HB3 LEU A  43      35.198  28.260  70.892  1.00  0.00           H  
ATOM    687  HG  LEU A  43      33.671  29.597  72.113  1.00  0.00           H  
ATOM    688 HD11 LEU A  43      35.497  30.846  71.108  1.00  0.00           H  
ATOM    689 HD12 LEU A  43      34.044  31.838  71.238  1.00  0.00           H  
ATOM    690 HD13 LEU A  43      34.510  31.158  69.682  1.00  0.00           H  
ATOM    691 HD21 LEU A  43      31.840  30.839  71.039  1.00  0.00           H  
ATOM    692 HD22 LEU A  43      31.639  29.083  70.937  1.00  0.00           H  
ATOM    693 HD23 LEU A  43      32.188  29.993  69.528  1.00  0.00           H  
ATOM    694  N   LYS A  44      36.702  27.419  68.919  1.00  0.00           N  
ATOM    695  CA  LYS A  44      37.627  26.343  68.585  1.00  0.00           C  
ATOM    696  C   LYS A  44      37.097  24.995  69.067  1.00  0.00           C  
ATOM    697  O   LYS A  44      37.201  23.997  68.351  1.00  0.00           O  
ATOM    698  CB  LYS A  44      39.012  26.616  69.170  1.00  0.00           C  
ATOM    699  CG  LYS A  44      40.020  25.494  68.941  1.00  0.00           C  
ATOM    700  CD  LYS A  44      41.432  25.896  69.331  1.00  0.00           C  
ATOM    701  CE  LYS A  44      41.547  26.208  70.805  1.00  0.00           C  
ATOM    702  NZ  LYS A  44      41.325  25.015  71.663  1.00  0.00           N  
ATOM    703  H   LYS A  44      37.014  28.125  69.509  1.00  0.00           H  
ATOM    704  HA  LYS A  44      37.701  26.309  67.521  1.00  0.00           H  
ATOM    705  HB2 LYS A  44      39.411  27.519  68.728  1.00  0.00           H  
ATOM    706  HB3 LYS A  44      38.910  26.764  70.231  1.00  0.00           H  
ATOM    707  HG2 LYS A  44      39.723  24.634  69.520  1.00  0.00           H  
ATOM    708  HG3 LYS A  44      40.005  25.241  67.889  1.00  0.00           H  
ATOM    709  HD2 LYS A  44      42.110  25.086  69.097  1.00  0.00           H  
ATOM    710  HD3 LYS A  44      41.703  26.769  68.761  1.00  0.00           H  
ATOM    711  HE2 LYS A  44      42.534  26.595  71.013  1.00  0.00           H  
ATOM    712  HE3 LYS A  44      40.813  26.958  71.055  1.00  0.00           H  
ATOM    713  HZ1 LYS A  44      41.874  24.214  71.297  1.00  0.00           H  
ATOM    714  HZ2 LYS A  44      40.309  24.753  71.651  1.00  0.00           H  
ATOM    715  HZ3 LYS A  44      41.602  25.207  72.641  1.00  0.00           H  
ATOM    716  N   LYS A  45      36.536  24.980  70.275  1.00  0.00           N  
ATOM    717  CA  LYS A  45      35.959  23.761  70.820  1.00  0.00           C  
ATOM    718  C   LYS A  45      34.829  23.229  69.953  1.00  0.00           C  
ATOM    719  O   LYS A  45      34.636  22.011  69.857  1.00  0.00           O  
ATOM    720  CB  LYS A  45      35.512  23.968  72.282  1.00  0.00           C  
ATOM    721  CG  LYS A  45      34.671  25.213  72.524  1.00  0.00           C  
ATOM    722  CD  LYS A  45      33.197  24.963  72.280  1.00  0.00           C  
ATOM    723  CE  LYS A  45      32.345  26.176  72.621  1.00  0.00           C  
ATOM    724  NZ  LYS A  45      32.511  26.594  74.037  1.00  0.00           N  
ATOM    725  H   LYS A  45      36.541  25.801  70.829  1.00  0.00           H  
ATOM    726  HA  LYS A  45      36.761  23.017  70.823  1.00  0.00           H  
ATOM    727  HB2 LYS A  45      34.941  23.114  72.573  1.00  0.00           H  
ATOM    728  HB3 LYS A  45      36.392  24.033  72.911  1.00  0.00           H  
ATOM    729  HG2 LYS A  45      34.791  25.541  73.561  1.00  0.00           H  
ATOM    730  HG3 LYS A  45      35.008  26.004  71.868  1.00  0.00           H  
ATOM    731  HD2 LYS A  45      33.058  24.707  71.237  1.00  0.00           H  
ATOM    732  HD3 LYS A  45      32.889  24.131  72.892  1.00  0.00           H  
ATOM    733  HE2 LYS A  45      32.629  26.991  71.976  1.00  0.00           H  
ATOM    734  HE3 LYS A  45      31.314  25.930  72.438  1.00  0.00           H  
ATOM    735  HZ1 LYS A  45      31.888  27.406  74.243  1.00  0.00           H  
ATOM    736  HZ2 LYS A  45      33.500  26.878  74.214  1.00  0.00           H  
ATOM    737  HZ3 LYS A  45      32.256  25.807  74.693  1.00  0.00           H  
ATOM    738  N   ASP A  46      34.097  24.137  69.297  1.00  0.00           N  
ATOM    739  CA  ASP A  46      33.037  23.748  68.386  1.00  0.00           C  
ATOM    740  C   ASP A  46      33.615  23.061  67.159  1.00  0.00           C  
ATOM    741  O   ASP A  46      33.057  22.088  66.643  1.00  0.00           O  
ATOM    742  CB  ASP A  46      32.208  24.953  67.938  1.00  0.00           C  
ATOM    743  CG  ASP A  46      31.374  25.547  69.042  1.00  0.00           C  
ATOM    744  OD1 ASP A  46      30.334  24.959  69.425  1.00  0.00           O  
ATOM    745  OD2 ASP A  46      31.736  26.631  69.557  1.00  0.00           O  
ATOM    746  H   ASP A  46      34.272  25.087  69.435  1.00  0.00           H  
ATOM    747  HA  ASP A  46      32.407  23.065  68.914  1.00  0.00           H  
ATOM    748  HB2 ASP A  46      32.868  25.719  67.550  1.00  0.00           H  
ATOM    749  HB3 ASP A  46      31.532  24.646  67.146  1.00  0.00           H  
ATOM    750  N   CYS A  47      34.759  23.575  66.721  1.00  0.00           N  
ATOM    751  CA  CYS A  47      35.436  23.050  65.572  1.00  0.00           C  
ATOM    752  C   CYS A  47      36.080  21.699  65.897  1.00  0.00           C  
ATOM    753  O   CYS A  47      36.010  20.767  65.100  1.00  0.00           O  
ATOM    754  CB  CYS A  47      36.505  24.049  65.138  1.00  0.00           C  
ATOM    755  SG  CYS A  47      35.866  25.701  64.779  1.00  0.00           S  
ATOM    756  H   CYS A  47      35.168  24.316  67.203  1.00  0.00           H  
ATOM    757  HA  CYS A  47      34.716  22.921  64.785  1.00  0.00           H  
ATOM    758  HB2 CYS A  47      37.240  24.152  65.928  1.00  0.00           H  
ATOM    759  HB3 CYS A  47      36.992  23.675  64.251  1.00  0.00           H  
ATOM    760  HG  CYS A  47      35.445  26.236  65.910  1.00  0.00           H  
ATOM    761  N   LEU A  48      36.681  21.601  67.075  1.00  0.00           N  
ATOM    762  CA  LEU A  48      37.295  20.364  67.528  1.00  0.00           C  
ATOM    763  C   LEU A  48      36.265  19.253  67.595  1.00  0.00           C  
ATOM    764  O   LEU A  48      36.481  18.156  67.069  1.00  0.00           O  
ATOM    765  CB  LEU A  48      37.924  20.553  68.911  1.00  0.00           C  
ATOM    766  CG  LEU A  48      38.982  21.660  68.993  1.00  0.00           C  
ATOM    767  CD1 LEU A  48      39.601  21.697  70.376  1.00  0.00           C  
ATOM    768  CD2 LEU A  48      40.057  21.457  67.945  1.00  0.00           C  
ATOM    769  H   LEU A  48      36.732  22.382  67.651  1.00  0.00           H  
ATOM    770  HA  LEU A  48      38.055  20.094  66.825  1.00  0.00           H  
ATOM    771  HB2 LEU A  48      37.140  20.799  69.594  1.00  0.00           H  
ATOM    772  HB3 LEU A  48      38.382  19.634  69.206  1.00  0.00           H  
ATOM    773  HG  LEU A  48      38.517  22.606  68.810  1.00  0.00           H  
ATOM    774 HD11 LEU A  48      38.833  21.927  71.101  1.00  0.00           H  
ATOM    775 HD12 LEU A  48      40.366  22.461  70.413  1.00  0.00           H  
ATOM    776 HD13 LEU A  48      40.021  20.746  70.624  1.00  0.00           H  
ATOM    777 HD21 LEU A  48      40.506  20.496  68.058  1.00  0.00           H  
ATOM    778 HD22 LEU A  48      40.808  22.223  68.046  1.00  0.00           H  
ATOM    779 HD23 LEU A  48      39.601  21.520  66.961  1.00  0.00           H  
ATOM    780  N   ALA A  49      35.157  19.540  68.267  1.00  0.00           N  
ATOM    781  CA  ALA A  49      34.061  18.592  68.422  1.00  0.00           C  
ATOM    782  C   ALA A  49      33.549  18.136  67.064  1.00  0.00           C  
ATOM    783  O   ALA A  49      33.336  16.943  66.850  1.00  0.00           O  
ATOM    784  CB  ALA A  49      32.935  19.206  69.238  1.00  0.00           C  
ATOM    785  H   ALA A  49      35.094  20.421  68.700  1.00  0.00           H  
ATOM    786  HA  ALA A  49      34.440  17.742  68.956  1.00  0.00           H  
ATOM    787  HB1 ALA A  49      33.324  19.526  70.187  1.00  0.00           H  
ATOM    788  HB2 ALA A  49      32.164  18.469  69.390  1.00  0.00           H  
ATOM    789  HB3 ALA A  49      32.522  20.065  68.720  1.00  0.00           H  
ATOM    790  N   TYR A  50      33.358  19.093  66.170  1.00  0.00           N  
ATOM    791  CA  TYR A  50      32.843  18.807  64.848  1.00  0.00           C  
ATOM    792  C   TYR A  50      33.715  17.809  64.086  1.00  0.00           C  
ATOM    793  O   TYR A  50      33.217  16.826  63.571  1.00  0.00           O  
ATOM    794  CB  TYR A  50      32.679  20.084  64.025  1.00  0.00           C  
ATOM    795  CG  TYR A  50      32.088  19.810  62.658  1.00  0.00           C  
ATOM    796  CD1 TYR A  50      30.733  19.551  62.508  1.00  0.00           C  
ATOM    797  CD2 TYR A  50      32.888  19.779  61.523  1.00  0.00           C  
ATOM    798  CE1 TYR A  50      30.186  19.272  61.259  1.00  0.00           C  
ATOM    799  CE2 TYR A  50      32.353  19.499  60.282  1.00  0.00           C  
ATOM    800  CZ  TYR A  50      31.008  19.247  60.148  1.00  0.00           C  
ATOM    801  OH  TYR A  50      30.478  18.962  58.920  1.00  0.00           O  
ATOM    802  H   TYR A  50      33.535  20.020  66.409  1.00  0.00           H  
ATOM    803  HA  TYR A  50      31.866  18.370  64.976  1.00  0.00           H  
ATOM    804  HB2 TYR A  50      32.015  20.772  64.554  1.00  0.00           H  
ATOM    805  HB3 TYR A  50      33.654  20.540  63.886  1.00  0.00           H  
ATOM    806  HD1 TYR A  50      30.093  19.578  63.389  1.00  0.00           H  
ATOM    807  HD2 TYR A  50      33.949  19.982  61.624  1.00  0.00           H  
ATOM    808  HE1 TYR A  50      29.130  19.073  61.168  1.00  0.00           H  
ATOM    809  HE2 TYR A  50      33.008  19.482  59.422  1.00  0.00           H  
ATOM    810  HH  TYR A  50      29.627  19.413  58.839  1.00  0.00           H  
ATOM    811  N   ILE A  51      35.006  18.084  64.023  1.00  0.00           N  
ATOM    812  CA  ILE A  51      35.926  17.232  63.256  1.00  0.00           C  
ATOM    813  C   ILE A  51      35.942  15.814  63.819  1.00  0.00           C  
ATOM    814  O   ILE A  51      36.094  14.833  63.075  1.00  0.00           O  
ATOM    815  CB  ILE A  51      37.357  17.821  63.219  1.00  0.00           C  
ATOM    816  CG1 ILE A  51      37.504  18.835  62.086  1.00  0.00           C  
ATOM    817  CG2 ILE A  51      38.426  16.734  63.096  1.00  0.00           C  
ATOM    818  CD1 ILE A  51      36.649  20.066  62.237  1.00  0.00           C  
ATOM    819  H   ILE A  51      35.372  18.840  64.523  1.00  0.00           H  
ATOM    820  HA  ILE A  51      35.559  17.192  62.245  1.00  0.00           H  
ATOM    821  HB  ILE A  51      37.531  18.333  64.153  1.00  0.00           H  
ATOM    822 HG12 ILE A  51      38.534  19.168  62.045  1.00  0.00           H  
ATOM    823 HG13 ILE A  51      37.243  18.365  61.148  1.00  0.00           H  
ATOM    824 HG21 ILE A  51      39.400  17.186  63.032  1.00  0.00           H  
ATOM    825 HG22 ILE A  51      38.235  16.146  62.205  1.00  0.00           H  
ATOM    826 HG23 ILE A  51      38.377  16.096  63.964  1.00  0.00           H  
ATOM    827 HD11 ILE A  51      35.616  19.786  62.294  1.00  0.00           H  
ATOM    828 HD12 ILE A  51      36.807  20.729  61.396  1.00  0.00           H  
ATOM    829 HD13 ILE A  51      36.935  20.567  63.149  1.00  0.00           H  
ATOM    830  N   GLU A  52      35.788  15.705  65.132  1.00  0.00           N  
ATOM    831  CA  GLU A  52      35.764  14.411  65.778  1.00  0.00           C  
ATOM    832  C   GLU A  52      34.620  13.542  65.239  1.00  0.00           C  
ATOM    833  O   GLU A  52      34.807  12.354  64.969  1.00  0.00           O  
ATOM    834  CB  GLU A  52      35.640  14.566  67.282  1.00  0.00           C  
ATOM    835  CG  GLU A  52      36.350  13.486  68.052  1.00  0.00           C  
ATOM    836  CD  GLU A  52      37.834  13.510  67.786  1.00  0.00           C  
ATOM    837  OE1 GLU A  52      38.524  14.398  68.323  1.00  0.00           O  
ATOM    838  OE2 GLU A  52      38.332  12.649  67.032  1.00  0.00           O  
ATOM    839  H   GLU A  52      35.721  16.522  65.676  1.00  0.00           H  
ATOM    840  HA  GLU A  52      36.710  13.927  65.558  1.00  0.00           H  
ATOM    841  HB2 GLU A  52      36.065  15.524  67.567  1.00  0.00           H  
ATOM    842  HB3 GLU A  52      34.593  14.555  67.556  1.00  0.00           H  
ATOM    843  HG2 GLU A  52      36.189  13.641  69.106  1.00  0.00           H  
ATOM    844  HG3 GLU A  52      35.952  12.526  67.752  1.00  0.00           H  
ATOM    845  N   GLU A  53      33.447  14.162  65.085  1.00  0.00           N  
ATOM    846  CA  GLU A  53      32.228  13.453  64.700  1.00  0.00           C  
ATOM    847  C   GLU A  53      32.421  12.532  63.476  1.00  0.00           C  
ATOM    848  O   GLU A  53      32.228  11.327  63.600  1.00  0.00           O  
ATOM    849  CB  GLU A  53      31.065  14.418  64.488  1.00  0.00           C  
ATOM    850  CG  GLU A  53      30.800  15.354  65.658  1.00  0.00           C  
ATOM    851  CD  GLU A  53      30.374  14.633  66.930  1.00  0.00           C  
ATOM    852  OE1 GLU A  53      31.138  13.799  67.442  1.00  0.00           O  
ATOM    853  OE2 GLU A  53      29.283  14.949  67.458  1.00  0.00           O  
ATOM    854  H   GLU A  53      33.396  15.113  65.328  1.00  0.00           H  
ATOM    855  HA  GLU A  53      31.977  12.808  65.537  1.00  0.00           H  
ATOM    856  HB2 GLU A  53      31.289  15.023  63.627  1.00  0.00           H  
ATOM    857  HB3 GLU A  53      30.159  13.846  64.296  1.00  0.00           H  
ATOM    858  HG2 GLU A  53      31.712  15.895  65.867  1.00  0.00           H  
ATOM    859  HG3 GLU A  53      30.031  16.048  65.380  1.00  0.00           H  
ATOM    860  N   VAL A  54      32.793  13.018  62.275  1.00  0.00           N  
ATOM    861  CA  VAL A  54      32.945  14.443  61.955  1.00  0.00           C  
ATOM    862  C   VAL A  54      31.584  14.983  61.521  1.00  0.00           C  
ATOM    863  O   VAL A  54      31.250  16.148  61.696  1.00  0.00           O  
ATOM    864  CB  VAL A  54      33.998  14.682  60.835  1.00  0.00           C  
ATOM    865  CG1 VAL A  54      33.728  13.796  59.641  1.00  0.00           C  
ATOM    866  CG2 VAL A  54      34.040  16.150  60.417  1.00  0.00           C  
ATOM    867  H   VAL A  54      32.931  12.360  61.588  1.00  0.00           H  
ATOM    868  HA  VAL A  54      33.241  14.973  62.848  1.00  0.00           H  
ATOM    869  HB  VAL A  54      34.976  14.424  61.218  1.00  0.00           H  
ATOM    870 HG11 VAL A  54      33.778  12.757  59.952  1.00  0.00           H  
ATOM    871 HG12 VAL A  54      34.464  13.980  58.877  1.00  0.00           H  
ATOM    872 HG13 VAL A  54      32.744  14.008  59.258  1.00  0.00           H  
ATOM    873 HG21 VAL A  54      34.158  16.769  61.292  1.00  0.00           H  
ATOM    874 HG22 VAL A  54      33.122  16.407  59.916  1.00  0.00           H  
ATOM    875 HG23 VAL A  54      34.876  16.323  59.751  1.00  0.00           H  
ATOM    876  N   TRP A  55      30.805  14.085  60.974  1.00  0.00           N  
ATOM    877  CA  TRP A  55      29.390  14.257  60.946  1.00  0.00           C  
ATOM    878  C   TRP A  55      28.838  13.179  61.845  1.00  0.00           C  
ATOM    879  O   TRP A  55      29.449  12.122  61.992  1.00  0.00           O  
ATOM    880  CB  TRP A  55      28.839  14.127  59.527  1.00  0.00           C  
ATOM    881  CG  TRP A  55      27.414  14.594  59.401  1.00  0.00           C  
ATOM    882  CD1 TRP A  55      26.319  13.839  59.134  1.00  0.00           C  
ATOM    883  CD2 TRP A  55      26.944  15.942  59.564  1.00  0.00           C  
ATOM    884  NE1 TRP A  55      25.191  14.627  59.116  1.00  0.00           N  
ATOM    885  CE2 TRP A  55      25.552  15.913  59.368  1.00  0.00           C  
ATOM    886  CE3 TRP A  55      27.567  17.154  59.849  1.00  0.00           C  
ATOM    887  CZ2 TRP A  55      24.772  17.067  59.462  1.00  0.00           C  
ATOM    888  CZ3 TRP A  55      26.791  18.301  59.933  1.00  0.00           C  
ATOM    889  CH2 TRP A  55      25.402  18.248  59.743  1.00  0.00           C  
ATOM    890  H   TRP A  55      31.188  13.282  60.589  1.00  0.00           H  
ATOM    891  HA  TRP A  55      29.153  15.223  61.354  1.00  0.00           H  
ATOM    892  HB2 TRP A  55      29.446  14.717  58.857  1.00  0.00           H  
ATOM    893  HB3 TRP A  55      28.873  13.092  59.222  1.00  0.00           H  
ATOM    894  HD1 TRP A  55      26.335  12.768  58.957  1.00  0.00           H  
ATOM    895  HE1 TRP A  55      24.281  14.318  58.935  1.00  0.00           H  
ATOM    896  HE3 TRP A  55      28.629  17.224  60.000  1.00  0.00           H  
ATOM    897  HZ2 TRP A  55      23.695  17.037  59.320  1.00  0.00           H  
ATOM    898  HZ3 TRP A  55      27.256  19.255  60.145  1.00  0.00           H  
ATOM    899  HH2 TRP A  55      24.848  19.160  59.814  1.00  0.00           H  
ATOM    900  N   THR A  56      27.699  13.414  62.446  1.00  0.00           N  
ATOM    901  CA  THR A  56      27.177  12.487  63.411  1.00  0.00           C  
ATOM    902  C   THR A  56      25.664  12.375  63.279  1.00  0.00           C  
ATOM    903  O   THR A  56      24.967  13.374  63.079  1.00  0.00           O  
ATOM    904  CB  THR A  56      27.566  12.878  64.856  1.00  0.00           C  
ATOM    905  OG1 THR A  56      27.062  11.911  65.787  1.00  0.00           O  
ATOM    906  CG2 THR A  56      27.022  14.255  65.212  1.00  0.00           C  
ATOM    907  H   THR A  56      27.141  14.148  62.158  1.00  0.00           H  
ATOM    908  HA  THR A  56      27.607  11.525  63.201  1.00  0.00           H  
ATOM    909  HB  THR A  56      28.635  12.907  64.923  1.00  0.00           H  
ATOM    910  HG1 THR A  56      27.760  11.287  65.990  1.00  0.00           H  
ATOM    911 HG21 THR A  56      27.390  14.986  64.506  1.00  0.00           H  
ATOM    912 HG22 THR A  56      27.363  14.524  66.207  1.00  0.00           H  
ATOM    913 HG23 THR A  56      25.947  14.243  65.188  1.00  0.00           H  
ATOM    914  N   ASP A  57      25.165  11.155  63.355  1.00  0.00           N  
ATOM    915  CA  ASP A  57      23.740  10.876  63.309  1.00  0.00           C  
ATOM    916  C   ASP A  57      23.378   9.778  64.282  1.00  0.00           C  
ATOM    917  O   ASP A  57      22.325   9.804  64.908  1.00  0.00           O  
ATOM    918  CB  ASP A  57      23.333  10.477  61.888  1.00  0.00           C  
ATOM    919  CG  ASP A  57      21.890  10.039  61.814  1.00  0.00           C  
ATOM    920  OD1 ASP A  57      20.990  10.907  61.880  1.00  0.00           O  
ATOM    921  OD2 ASP A  57      21.643   8.817  61.698  1.00  0.00           O  
ATOM    922  H   ASP A  57      25.791  10.396  63.445  1.00  0.00           H  
ATOM    923  HA  ASP A  57      23.207  11.791  63.587  1.00  0.00           H  
ATOM    924  HB2 ASP A  57      23.471  11.316  61.228  1.00  0.00           H  
ATOM    925  HB3 ASP A  57      23.961   9.660  61.558  1.00  0.00           H  
ATOM    926  N   MET A  58      24.264   8.786  64.395  1.00  0.00           N  
ATOM    927  CA  MET A  58      24.048   7.667  65.304  1.00  0.00           C  
ATOM    928  C   MET A  58      24.600   7.988  66.682  1.00  0.00           C  
ATOM    929  O   MET A  58      23.918   7.843  67.698  1.00  0.00           O  
ATOM    930  CB  MET A  58      24.700   6.389  64.798  1.00  0.00           C  
ATOM    931  CG  MET A  58      24.137   5.871  63.495  1.00  0.00           C  
ATOM    932  SD  MET A  58      24.858   4.288  63.008  1.00  0.00           S  
ATOM    933  CE  MET A  58      24.398   3.261  64.399  1.00  0.00           C  
ATOM    934  H   MET A  58      25.088   8.798  63.859  1.00  0.00           H  
ATOM    935  HA  MET A  58      22.973   7.505  65.398  1.00  0.00           H  
ATOM    936  HB2 MET A  58      25.757   6.583  64.654  1.00  0.00           H  
ATOM    937  HB3 MET A  58      24.585   5.627  65.552  1.00  0.00           H  
ATOM    938  HG2 MET A  58      23.070   5.741  63.602  1.00  0.00           H  
ATOM    939  HG3 MET A  58      24.330   6.587  62.717  1.00  0.00           H  
ATOM    940  HE1 MET A  58      24.790   3.684  65.305  1.00  0.00           H  
ATOM    941  HE2 MET A  58      24.801   2.278  64.256  1.00  0.00           H  
ATOM    942  HE3 MET A  58      23.323   3.200  64.469  1.00  0.00           H  
ATOM    943  N   ARG A  59      25.851   8.428  66.716  1.00  0.00           N  
ATOM    944  CA  ARG A  59      26.533   8.639  67.969  1.00  0.00           C  
ATOM    945  C   ARG A  59      27.631   9.682  67.811  1.00  0.00           C  
ATOM    946  O   ARG A  59      28.441   9.616  66.877  1.00  0.00           O  
ATOM    947  CB  ARG A  59      27.123   7.313  68.455  1.00  0.00           C  
ATOM    948  CG  ARG A  59      27.764   7.384  69.830  1.00  0.00           C  
ATOM    949  CD  ARG A  59      28.267   6.037  70.268  1.00  0.00           C  
ATOM    950  NE  ARG A  59      27.211   5.010  70.207  1.00  0.00           N  
ATOM    951  CZ  ARG A  59      27.436   3.711  70.176  1.00  0.00           C  
ATOM    952  NH1 ARG A  59      28.677   3.242  70.218  1.00  0.00           N  
ATOM    953  NH2 ARG A  59      26.407   2.866  70.086  1.00  0.00           N  
ATOM    954  H   ARG A  59      26.327   8.617  65.884  1.00  0.00           H  
ATOM    955  HA  ARG A  59      25.813   8.989  68.690  1.00  0.00           H  
ATOM    956  HB2 ARG A  59      26.328   6.567  68.497  1.00  0.00           H  
ATOM    957  HB3 ARG A  59      27.876   6.986  67.744  1.00  0.00           H  
ATOM    958  HG2 ARG A  59      28.584   8.081  69.796  1.00  0.00           H  
ATOM    959  HG3 ARG A  59      27.035   7.735  70.545  1.00  0.00           H  
ATOM    960  HD2 ARG A  59      29.072   5.735  69.617  1.00  0.00           H  
ATOM    961  HD3 ARG A  59      28.632   6.103  71.288  1.00  0.00           H  
ATOM    962  HE  ARG A  59      26.283   5.325  70.179  1.00  0.00           H  
ATOM    963 HH11 ARG A  59      29.442   3.882  70.287  1.00  0.00           H  
ATOM    964 HH12 ARG A  59      28.849   2.249  70.190  1.00  0.00           H  
ATOM    965 HH21 ARG A  59      25.468   3.219  70.047  1.00  0.00           H  
ATOM    966 HH22 ARG A  59      26.561   1.869  70.060  1.00  0.00           H  
ATOM    967  N   PRO A  60      27.679  10.671  68.710  1.00  0.00           N  
ATOM    968  CA  PRO A  60      28.764  11.633  68.742  1.00  0.00           C  
ATOM    969  C   PRO A  60      30.007  11.041  69.410  1.00  0.00           C  
ATOM    970  O   PRO A  60      30.127  11.024  70.626  1.00  0.00           O  
ATOM    971  CB  PRO A  60      28.194  12.788  69.582  1.00  0.00           C  
ATOM    972  CG  PRO A  60      27.188  12.154  70.461  1.00  0.00           C  
ATOM    973  CD  PRO A  60      26.651  10.945  69.728  1.00  0.00           C  
ATOM    974  HA  PRO A  60      29.027  11.977  67.760  1.00  0.00           H  
ATOM    975  HB2 PRO A  60      28.990  13.240  70.152  1.00  0.00           H  
ATOM    976  HB3 PRO A  60      27.739  13.514  68.921  1.00  0.00           H  
ATOM    977  HG2 PRO A  60      27.641  11.843  71.380  1.00  0.00           H  
ATOM    978  HG3 PRO A  60      26.379  12.840  70.659  1.00  0.00           H  
ATOM    979  HD2 PRO A  60      26.553  10.107  70.408  1.00  0.00           H  
ATOM    980  HD3 PRO A  60      25.702  11.174  69.269  1.00  0.00           H  
ATOM    981  N   LEU A  61      30.933  10.528  68.588  1.00  0.00           N  
ATOM    982  CA  LEU A  61      32.125   9.855  69.109  1.00  0.00           C  
ATOM    983  C   LEU A  61      33.101  10.856  69.715  1.00  0.00           C  
ATOM    984  O   LEU A  61      34.163  10.464  70.206  1.00  0.00           O  
ATOM    985  CB  LEU A  61      32.800   9.003  68.041  1.00  0.00           C  
ATOM    986  CG  LEU A  61      33.018   9.678  66.682  1.00  0.00           C  
ATOM    987  CD1 LEU A  61      34.341   9.237  66.084  1.00  0.00           C  
ATOM    988  CD2 LEU A  61      31.867   9.342  65.746  1.00  0.00           C  
ATOM    989  H   LEU A  61      30.807  10.594  67.629  1.00  0.00           H  
ATOM    990  HA  LEU A  61      31.799   9.200  69.895  1.00  0.00           H  
ATOM    991  HB2 LEU A  61      33.756   8.697  68.418  1.00  0.00           H  
ATOM    992  HB3 LEU A  61      32.191   8.118  67.885  1.00  0.00           H  
ATOM    993  HG  LEU A  61      33.041  10.749  66.819  1.00  0.00           H  
ATOM    994 HD11 LEU A  61      34.443   9.665  65.103  1.00  0.00           H  
ATOM    995 HD12 LEU A  61      34.351   8.162  66.013  1.00  0.00           H  
ATOM    996 HD13 LEU A  61      35.146   9.573  66.713  1.00  0.00           H  
ATOM    997 HD21 LEU A  61      32.002   9.869  64.812  1.00  0.00           H  
ATOM    998 HD22 LEU A  61      30.924   9.644  66.192  1.00  0.00           H  
ATOM    999 HD23 LEU A  61      31.848   8.277  65.556  1.00  0.00           H  
ATOM   1000  N   SER A  62      32.748  12.124  69.703  1.00  0.00           N  
ATOM   1001  CA  SER A  62      33.466  13.139  70.455  1.00  0.00           C  
ATOM   1002  C   SER A  62      33.382  12.834  71.958  1.00  0.00           C  
ATOM   1003  O   SER A  62      34.069  13.453  72.790  1.00  0.00           O  
ATOM   1004  CB  SER A  62      32.910  14.514  70.129  1.00  0.00           C  
ATOM   1005  OG  SER A  62      31.496  14.460  70.008  1.00  0.00           O  
ATOM   1006  H   SER A  62      31.980  12.408  69.157  1.00  0.00           H  
ATOM   1007  HA  SER A  62      34.504  13.090  70.153  1.00  0.00           H  
ATOM   1008  HB2 SER A  62      33.169  15.209  70.916  1.00  0.00           H  
ATOM   1009  HB3 SER A  62      33.329  14.866  69.190  1.00  0.00           H  
ATOM   1010  HG  SER A  62      31.265  14.297  69.076  1.00  0.00           H  
ATOM   1011  N   LEU A  63      32.540  11.856  72.311  1.00  0.00           N  
ATOM   1012  CA  LEU A  63      32.421  11.390  73.678  1.00  0.00           C  
ATOM   1013  C   LEU A  63      33.768  10.823  74.181  1.00  0.00           C  
ATOM   1014  O   LEU A  63      34.059  10.841  75.373  1.00  0.00           O  
ATOM   1015  CB  LEU A  63      31.301  10.334  73.793  1.00  0.00           C  
ATOM   1016  CG  LEU A  63      31.455   9.067  72.928  1.00  0.00           C  
ATOM   1017  CD1 LEU A  63      32.372   8.036  73.584  1.00  0.00           C  
ATOM   1018  CD2 LEU A  63      30.103   8.442  72.637  1.00  0.00           C  
ATOM   1019  H   LEU A  63      31.967  11.463  71.612  1.00  0.00           H  
ATOM   1020  HA  LEU A  63      32.163  12.234  74.291  1.00  0.00           H  
ATOM   1021  HB2 LEU A  63      31.243  10.034  74.829  1.00  0.00           H  
ATOM   1022  HB3 LEU A  63      30.366  10.805  73.527  1.00  0.00           H  
ATOM   1023  HG  LEU A  63      31.906   9.341  71.967  1.00  0.00           H  
ATOM   1024 HD11 LEU A  63      31.936   7.724  74.511  1.00  0.00           H  
ATOM   1025 HD12 LEU A  63      33.330   8.485  73.777  1.00  0.00           H  
ATOM   1026 HD13 LEU A  63      32.488   7.188  72.923  1.00  0.00           H  
ATOM   1027 HD21 LEU A  63      29.483   9.142  72.084  1.00  0.00           H  
ATOM   1028 HD22 LEU A  63      29.629   8.185  73.576  1.00  0.00           H  
ATOM   1029 HD23 LEU A  63      30.245   7.552  72.062  1.00  0.00           H  
ATOM   1030  N   ARG A  64      34.594  10.362  73.253  1.00  0.00           N  
ATOM   1031  CA  ARG A  64      35.890   9.813  73.612  1.00  0.00           C  
ATOM   1032  C   ARG A  64      36.834  10.925  74.059  1.00  0.00           C  
ATOM   1033  O   ARG A  64      37.838  10.674  74.717  1.00  0.00           O  
ATOM   1034  CB  ARG A  64      36.501   9.026  72.444  1.00  0.00           C  
ATOM   1035  CG  ARG A  64      36.927   9.881  71.250  1.00  0.00           C  
ATOM   1036  CD  ARG A  64      37.483   9.017  70.131  1.00  0.00           C  
ATOM   1037  NE  ARG A  64      37.816   9.792  68.928  1.00  0.00           N  
ATOM   1038  CZ  ARG A  64      38.187   9.245  67.767  1.00  0.00           C  
ATOM   1039  NH1 ARG A  64      38.268   7.929  67.644  1.00  0.00           N  
ATOM   1040  NH2 ARG A  64      38.468  10.026  66.726  1.00  0.00           N  
ATOM   1041  H   ARG A  64      34.331  10.395  72.312  1.00  0.00           H  
ATOM   1042  HA  ARG A  64      35.745   9.146  74.444  1.00  0.00           H  
ATOM   1043  HB2 ARG A  64      37.378   8.504  72.798  1.00  0.00           H  
ATOM   1044  HB3 ARG A  64      35.768   8.307  72.098  1.00  0.00           H  
ATOM   1045  HG2 ARG A  64      36.063  10.418  70.882  1.00  0.00           H  
ATOM   1046  HG3 ARG A  64      37.683  10.577  71.561  1.00  0.00           H  
ATOM   1047  HD2 ARG A  64      38.372   8.542  70.485  1.00  0.00           H  
ATOM   1048  HD3 ARG A  64      36.760   8.271  69.873  1.00  0.00           H  
ATOM   1049  HE  ARG A  64      37.759  10.758  68.996  1.00  0.00           H  
ATOM   1050 HH11 ARG A  64      38.064   7.340  68.425  1.00  0.00           H  
ATOM   1051 HH12 ARG A  64      38.533   7.497  66.763  1.00  0.00           H  
ATOM   1052 HH21 ARG A  64      38.409  11.024  66.830  1.00  0.00           H  
ATOM   1053 HH22 ARG A  64      38.748   9.624  65.846  1.00  0.00           H  
ATOM   1054  N   GLN A  65      36.486  12.165  73.711  1.00  0.00           N  
ATOM   1055  CA  GLN A  65      37.275  13.309  74.144  1.00  0.00           C  
ATOM   1056  C   GLN A  65      36.795  13.784  75.510  1.00  0.00           C  
ATOM   1057  O   GLN A  65      37.329  14.743  76.068  1.00  0.00           O  
ATOM   1058  CB  GLN A  65      37.197  14.431  73.104  1.00  0.00           C  
ATOM   1059  CG  GLN A  65      37.688  14.029  71.716  1.00  0.00           C  
ATOM   1060  CD  GLN A  65      39.143  13.594  71.692  1.00  0.00           C  
ATOM   1061  OE1 GLN A  65      39.698  13.111  72.686  1.00  0.00           O  
ATOM   1062  NE2 GLN A  65      39.791  13.784  70.551  1.00  0.00           N  
ATOM   1063  H   GLN A  65      35.692  12.303  73.139  1.00  0.00           H  
ATOM   1064  HA  GLN A  65      38.301  12.989  74.233  1.00  0.00           H  
ATOM   1065  HB2 GLN A  65      36.174  14.745  73.021  1.00  0.00           H  
ATOM   1066  HB3 GLN A  65      37.802  15.261  73.441  1.00  0.00           H  
ATOM   1067  HG2 GLN A  65      37.079  13.189  71.371  1.00  0.00           H  
ATOM   1068  HG3 GLN A  65      37.561  14.862  71.041  1.00  0.00           H  
ATOM   1069 HE21 GLN A  65      39.289  14.179  69.792  1.00  0.00           H  
ATOM   1070 HE22 GLN A  65      40.741  13.516  70.501  1.00  0.00           H  
ATOM   1071  N   HIS A  66      35.781  13.108  76.039  1.00  0.00           N  
ATOM   1072  CA  HIS A  66      35.338  13.357  77.404  1.00  0.00           C  
ATOM   1073  C   HIS A  66      36.245  12.603  78.360  1.00  0.00           C  
ATOM   1074  O   HIS A  66      36.320  12.902  79.557  1.00  0.00           O  
ATOM   1075  CB  HIS A  66      33.884  12.895  77.616  1.00  0.00           C  
ATOM   1076  CG  HIS A  66      32.870  13.642  76.802  1.00  0.00           C  
ATOM   1077  ND1 HIS A  66      31.605  13.160  76.553  1.00  0.00           N  
ATOM   1078  CD2 HIS A  66      32.922  14.854  76.196  1.00  0.00           C  
ATOM   1079  CE1 HIS A  66      30.936  14.029  75.843  1.00  0.00           C  
ATOM   1080  NE2 HIS A  66      31.711  15.070  75.618  1.00  0.00           N  
ATOM   1081  H   HIS A  66      35.332  12.425  75.508  1.00  0.00           H  
ATOM   1082  HA  HIS A  66      35.403  14.421  77.597  1.00  0.00           H  
ATOM   1083  HB2 HIS A  66      33.811  11.837  77.371  1.00  0.00           H  
ATOM   1084  HB3 HIS A  66      33.628  13.027  78.659  1.00  0.00           H  
ATOM   1085  HD1 HIS A  66      31.240  12.273  76.860  1.00  0.00           H  
ATOM   1086  HD2 HIS A  66      33.773  15.513  76.168  1.00  0.00           H  
ATOM   1087  HE1 HIS A  66      29.916  13.917  75.485  1.00  0.00           H  
ATOM   1088  HE2 HIS A  66      31.408  15.938  75.252  1.00  0.00           H  
ATOM   1089  N   MET A  67      36.958  11.604  77.799  1.00  0.00           N  
ATOM   1090  CA  MET A  67      37.966  10.883  78.541  1.00  0.00           C  
ATOM   1091  C   MET A  67      39.187  11.769  78.714  1.00  0.00           C  
ATOM   1092  O   MET A  67      39.845  11.750  79.748  1.00  0.00           O  
ATOM   1093  CB  MET A  67      38.360   9.590  77.815  1.00  0.00           C  
ATOM   1094  CG  MET A  67      37.198   8.656  77.567  1.00  0.00           C  
ATOM   1095  SD  MET A  67      36.403   8.087  79.085  1.00  0.00           S  
ATOM   1096  CE  MET A  67      35.173   6.976  78.406  1.00  0.00           C  
ATOM   1097  H   MET A  67      36.781  11.375  76.868  1.00  0.00           H  
ATOM   1098  HA  MET A  67      37.571  10.648  79.518  1.00  0.00           H  
ATOM   1099  HB2 MET A  67      38.795   9.855  76.874  1.00  0.00           H  
ATOM   1100  HB3 MET A  67      39.099   9.075  78.422  1.00  0.00           H  
ATOM   1101  HG2 MET A  67      36.475   9.173  76.956  1.00  0.00           H  
ATOM   1102  HG3 MET A  67      37.574   7.784  77.014  1.00  0.00           H  
ATOM   1103  HE1 MET A  67      35.653   6.176  77.857  1.00  0.00           H  
ATOM   1104  HE2 MET A  67      34.522   7.520  77.751  1.00  0.00           H  
ATOM   1105  HE3 MET A  67      34.587   6.552  79.214  1.00  0.00           H  
ATOM   1106  N   ASP A  68      39.463  12.557  77.689  1.00  0.00           N  
ATOM   1107  CA  ASP A  68      40.543  13.539  77.758  1.00  0.00           C  
ATOM   1108  C   ASP A  68      40.202  14.621  78.746  1.00  0.00           C  
ATOM   1109  O   ASP A  68      40.745  14.654  79.857  1.00  0.00           O  
ATOM   1110  CB  ASP A  68      40.792  14.137  76.361  1.00  0.00           C  
ATOM   1111  CG  ASP A  68      41.704  15.352  76.392  1.00  0.00           C  
ATOM   1112  OD1 ASP A  68      42.860  15.238  76.848  1.00  0.00           O  
ATOM   1113  OD2 ASP A  68      41.270  16.433  75.951  1.00  0.00           O  
ATOM   1114  H   ASP A  68      38.948  12.467  76.862  1.00  0.00           H  
ATOM   1115  HA  ASP A  68      41.432  13.030  78.072  1.00  0.00           H  
ATOM   1116  HB2 ASP A  68      41.249  13.390  75.741  1.00  0.00           H  
ATOM   1117  HB3 ASP A  68      39.845  14.431  75.929  1.00  0.00           H  
ATOM   1118  N   LYS A  69      39.261  15.494  78.382  1.00  0.00           N  
ATOM   1119  CA  LYS A  69      38.819  16.568  79.272  1.00  0.00           C  
ATOM   1120  C   LYS A  69      37.343  16.866  79.056  1.00  0.00           C  
ATOM   1121  O   LYS A  69      36.508  16.465  79.864  1.00  0.00           O  
ATOM   1122  CB  LYS A  69      39.665  17.843  79.091  1.00  0.00           C  
ATOM   1123  CG  LYS A  69      41.066  17.741  79.651  1.00  0.00           C  
ATOM   1124  CD  LYS A  69      41.039  17.615  81.163  1.00  0.00           C  
ATOM   1125  CE  LYS A  69      42.429  17.381  81.738  1.00  0.00           C  
ATOM   1126  NZ  LYS A  69      42.970  16.047  81.353  1.00  0.00           N  
ATOM   1127  H   LYS A  69      38.854  15.428  77.495  1.00  0.00           H  
ATOM   1128  HA  LYS A  69      38.957  16.212  80.278  1.00  0.00           H  
ATOM   1129  HB2 LYS A  69      39.733  18.057  78.030  1.00  0.00           H  
ATOM   1130  HB3 LYS A  69      39.160  18.674  79.579  1.00  0.00           H  
ATOM   1131  HG2 LYS A  69      41.549  16.864  79.246  1.00  0.00           H  
ATOM   1132  HG3 LYS A  69      41.619  18.638  79.375  1.00  0.00           H  
ATOM   1133  HD2 LYS A  69      40.646  18.519  81.579  1.00  0.00           H  
ATOM   1134  HD3 LYS A  69      40.405  16.785  81.446  1.00  0.00           H  
ATOM   1135  HE2 LYS A  69      43.085  18.142  81.350  1.00  0.00           H  
ATOM   1136  HE3 LYS A  69      42.394  17.444  82.811  1.00  0.00           H  
ATOM   1137  HZ1 LYS A  69      43.165  15.983  80.333  1.00  0.00           H  
ATOM   1138  HZ2 LYS A  69      42.293  15.292  81.621  1.00  0.00           H  
ATOM   1139  HZ3 LYS A  69      43.871  15.870  81.873  1.00  0.00           H  
ATOM   1140  N   ALA A  70      37.011  17.577  77.981  1.00  0.00           N  
ATOM   1141  CA  ALA A  70      35.635  18.012  77.760  1.00  0.00           C  
ATOM   1142  C   ALA A  70      35.285  18.117  76.274  1.00  0.00           C  
ATOM   1143  O   ALA A  70      34.397  18.878  75.901  1.00  0.00           O  
ATOM   1144  CB  ALA A  70      35.403  19.337  78.455  1.00  0.00           C  
ATOM   1145  H   ALA A  70      37.697  17.791  77.321  1.00  0.00           H  
ATOM   1146  HA  ALA A  70      34.962  17.287  78.210  1.00  0.00           H  
ATOM   1147  HB1 ALA A  70      35.675  19.262  79.499  1.00  0.00           H  
ATOM   1148  HB2 ALA A  70      34.367  19.612  78.360  1.00  0.00           H  
ATOM   1149  HB3 ALA A  70      36.024  20.089  77.988  1.00  0.00           H  
ATOM   1150  N   ALA A  71      35.980  17.326  75.441  1.00  0.00           N  
ATOM   1151  CA  ALA A  71      35.729  17.304  73.985  1.00  0.00           C  
ATOM   1152  C   ALA A  71      36.092  18.624  73.327  1.00  0.00           C  
ATOM   1153  O   ALA A  71      35.592  18.959  72.250  1.00  0.00           O  
ATOM   1154  CB  ALA A  71      34.280  16.934  73.694  1.00  0.00           C  
ATOM   1155  H   ALA A  71      36.698  16.747  75.810  1.00  0.00           H  
ATOM   1156  HA  ALA A  71      36.368  16.538  73.570  1.00  0.00           H  
ATOM   1157  HB1 ALA A  71      34.140  16.852  72.633  1.00  0.00           H  
ATOM   1158  HB2 ALA A  71      33.632  17.703  74.100  1.00  0.00           H  
ATOM   1159  HB3 ALA A  71      34.046  15.993  74.159  1.00  0.00           H  
ATOM   1160  N   GLY A  72      36.970  19.391  73.979  1.00  0.00           N  
ATOM   1161  CA  GLY A  72      37.388  20.656  73.444  1.00  0.00           C  
ATOM   1162  C   GLY A  72      38.753  21.065  73.945  1.00  0.00           C  
ATOM   1163  O   GLY A  72      39.557  20.152  74.280  1.00  0.00           O  
ATOM   1164  OXT GLY A  72      39.048  22.265  73.994  1.00  0.00           O  
ATOM   1165  H   GLY A  72      37.351  19.071  74.836  1.00  0.00           H  
ATOM   1166  HA2 GLY A  72      37.411  20.575  72.353  1.00  0.00           H  
ATOM   1167  HA3 GLY A  72      36.664  21.412  73.721  1.00  0.00           H  
TER    1168      GLY A  72                                                      
END
MOLECULE T0510_235_279.pdb
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
