
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   61 (  509),  selected   61 , name 2pst_X
# Molecule2: number of CA atoms   44 (  374),  selected   44 , name T0510_235_279.pdb
# PARAMETERS: 2pst_X.T0510_235_279.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     8_X      -       -           -
LGA    D     9_X      P     235          3.474
LGA    I    10_X      P     236          1.089
LGA    Q    11_X      T     237          1.443
LGA    F    12_X      P     238          2.069
LGA    Q    13_X      I     239          1.302
LGA    V    14_X      F     240          0.236
LGA    V    15_X      H     241          0.485
LGA    V    16_X      N     243          3.513
LGA    N    17_X      H     244          4.710
LGA    H    18_X      E     245          2.191
LGA    E    19_X      T     246          2.432
LGA    E    20_X      G     247          1.949
LGA    Q    21_X      K     248          1.737
LGA    Y    22_X      E     249          0.925
LGA    S    23_X      D     250          0.672
LGA    I    24_X      F     251          1.222
LGA    W    25_X      Y     252          3.393
LGA    -       -      F     253           -
LGA    P    26_X      I     254          0.907
LGA    E    27_X      K     255          3.097
LGA    Y    28_X      -       -           -
LGA    K    29_X      L     256          3.669
LGA    E    30_X      N     257          2.761
LGA    I    31_X      -       -           -
LGA    P    32_X      Q     258          1.349
LGA    Q    33_X      F     259           #
LGA    G    34_X      -       -           -
LGA    W    35_X      N     260          3.903
LGA    R    36_X      D     261          1.972
LGA    A    37_X      D     262          2.714
LGA    A    38_X      T     263          3.162
LGA    G    39_X      V     264          2.560
LGA    K    40_X      T     265          3.309
LGA    S    41_X      Y     266          3.011
LGA    G    42_X      D     267          3.538
LGA    L    43_X      S     268          2.234
LGA    K    44_X      L     269          1.889
LGA    K    45_X      N     270          1.849
LGA    D    46_X      D     271          1.311
LGA    C    47_X      L     272          1.059
LGA    L    48_X      L     273          1.316
LGA    A    49_X      D     274          1.193
LGA    Y    50_X      R     275          1.353
LGA    I    51_X      F     276          1.242
LGA    E    52_X      Y     277          1.714
LGA    E    53_X      D     278          2.805
LGA    V    54_X      -       -           -
LGA    W    55_X      -       -           -
LGA    T    56_X      A     279          2.207
LGA    D    57_X      -       -           -
LGA    M    58_X      -       -           -
LGA    R    59_X      -       -           -
LGA    P    60_X      -       -           -
LGA    L    61_X      -       -           -
LGA    S    62_X      -       -           -
LGA    L    63_X      -       -           -
LGA    R    64_X      -       -           -
LGA    Q    65_X      -       -           -
LGA    H    66_X      -       -           -
LGA    M    67_X      -       -           -
LGA    D    68_X      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   61   44    5.0     42    2.36     4.76     66.347     1.707

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.828291 * X  +  -0.496267 * Y  +  -0.260103 * Z  +  59.285809
  Y_new =   0.559324 * X  +   0.759723 * Y  +   0.331630 * Z  + -14.873072
  Z_new =   0.033030 * X  +  -0.420168 * Y  +   0.906845 * Z  +  54.005684 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.433883    2.707710  [ DEG:   -24.8597    155.1403 ]
  Theta =  -0.033036   -3.108557  [ DEG:    -1.8928   -178.1072 ]
  Phi   =   0.593938   -2.547654  [ DEG:    34.0302   -145.9698 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pst_X                                        
REMARK     2: T0510_235_279.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pst_X.T0510_235_279.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   61   44   5.0   42   2.36    4.76  66.347
REMARK  ---------------------------------------------------------- 
MOLECULE 2pst_X
HEADER    UNKNOWN FUNCTION                        07-MAY-07   2PST              
TITLE     1.8A CRYSTAL STRUCTURE OF THE PA2412 PROTEIN FROM                     
TITLE    2 PSEUDOMONAS AERUGINOSA                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN PA2412;                               
COMPND   3 CHAIN: X;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PA01;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15 MODIFIED                            
KEYWDS    PYOVERDINE SYNTHESIS, NON-RIBOSOMAL PEPTIDE SYNTHESIS                 
KEYWDS   2 CLUSTERS, MBTH-LIKE FAMILY, COG3251                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.M.GULICK,E.J.DRAKE,M.B.SHAH                                         
REVDAT   2   21-AUG-07 2PST    1       JRNL                                     
REVDAT   1   22-MAY-07 2PST    0                                                
JRNL        AUTH   E.J.DRAKE,J.CAO,J.QU,M.B.SHAH,R.M.STRAUBINGER,               
JRNL        AUTH 2 A.M.GULICK                                                   
JRNL        TITL   THE 1.8 A CRYSTAL STRUCTURE OF PA2412, AN                    
JRNL        TITL 2 MBTH-LIKE PROTEIN FROM THE PYOVERDINE CLUSTER OF             
JRNL        TITL 3 PSEUDOMONAS AERUGINOSA.                                      
JRNL        REF    J.BIOL.CHEM.                  V. 282 20425 2007              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2PST X    1    72  UNP    Q9I169   Q9I169_PSEAE     1     72             
SEQRES   1 X   74  GLY HIS MET THR SER VAL PHE ASP ARG ASP ASP ILE GLN          
SEQRES   2 X   74  PHE GLN VAL VAL VAL ASN HIS GLU GLU GLN TYR SER ILE          
SEQRES   3 X   74  TRP PRO GLU TYR LYS GLU ILE PRO GLN GLY TRP ARG ALA          
SEQRES   4 X   74  ALA GLY LYS SER GLY LEU LYS LYS ASP CYS LEU ALA TYR          
SEQRES   5 X   74  ILE GLU GLU VAL TRP THR ASP MET ARG PRO LEU SER LEU          
SEQRES   6 X   74  ARG GLN HIS MET ASP LYS ALA ALA GLY                          
FORMUL   2  HOH   *76(H2 O)                                                     
CRYST1   51.543   51.543   32.595  90.00  90.00  90.00 P 41          4          
ATOM      1  N   ASP X   8      39.316  31.122  73.120  1.00 38.16           N  
ATOM      2  CA  ASP X   8      38.255  31.543  72.159  1.00 37.82           C  
ATOM      3  C   ASP X   8      37.876  33.017  72.287  1.00 37.70           C  
ATOM      4  O   ASP X   8      37.635  33.541  73.385  1.00 38.32           O  
ATOM      5  CB  ASP X   8      37.031  30.677  72.305  1.00 37.67           C  
ATOM      6  N   ASP X   9      37.838  33.661  71.128  1.00 37.04           N  
ATOM      7  CA  ASP X   9      37.449  35.049  70.932  1.00 36.14           C  
ATOM      8  C   ASP X   9      37.394  35.219  69.418  1.00 34.50           C  
ATOM      9  O   ASP X   9      36.717  36.095  68.851  0.00 35.33           O  
ATOM     10  CB  ASP X   9      38.454  36.037  71.560  1.00 36.78           C  
ATOM     11  CG  ASP X   9      39.927  35.653  71.326  1.00 38.46           C  
ATOM     12  OD1 ASP X   9      40.239  34.464  71.082  1.00 40.34           O  
ATOM     13  OD2 ASP X   9      40.794  36.558  71.417  1.00 40.24           O  
ATOM     14  N   ILE X  10      38.007  34.245  68.750  1.00 31.91           N  
ATOM     15  CA  ILE X  10      38.100  34.240  67.300  1.00 29.98           C  
ATOM     16  C   ILE X  10      37.116  33.237  66.699  1.00 28.27           C  
ATOM     17  O   ILE X  10      37.072  32.068  67.096  1.00 27.63           O  
ATOM     18  CB  ILE X  10      39.557  33.943  66.822  1.00 30.29           C  
ATOM     19  CG1 ILE X  10      40.542  35.001  67.346  1.00 30.14           C  
ATOM     20  CG2 ILE X  10      39.634  33.787  65.289  1.00 30.46           C  
ATOM     21  CD1 ILE X  10      40.182  36.448  66.987  1.00 30.78           C  
ATOM     22  N   GLN X  11      36.325  33.717  65.747  1.00 26.64           N  
ATOM     23  CA  GLN X  11      35.474  32.855  64.945  1.00 25.13           C  
ATOM     24  C   GLN X  11      36.330  32.139  63.902  1.00 23.94           C  
ATOM     25  O   GLN X  11      37.071  32.778  63.148  1.00 23.07           O  
ATOM     26  CB  GLN X  11      34.375  33.669  64.267  1.00 25.78           C  
ATOM     27  CG  GLN X  11      33.305  34.179  65.231  1.00 28.55           C  
ATOM     28  CD  GLN X  11      32.380  33.066  65.724  1.00 30.57           C  
ATOM     29  OE1 GLN X  11      31.742  32.378  64.926  1.00 32.25           O  
ATOM     30  NE2 GLN X  11      32.304  32.896  67.039  1.00 30.43           N  
ATOM     31  N   PHE X  12      36.225  30.810  63.891  1.00 22.57           N  
ATOM     32  CA  PHE X  12      36.850  29.971  62.883  1.00 21.21           C  
ATOM     33  C   PHE X  12      35.820  29.426  61.920  1.00 20.27           C  
ATOM     34  O   PHE X  12      34.624  29.414  62.216  1.00 20.45           O  
ATOM     35  CB  PHE X  12      37.577  28.787  63.538  1.00 21.30           C  
ATOM     36  CG  PHE X  12      38.827  29.176  64.246  1.00 20.81           C  
ATOM     37  CD1 PHE X  12      40.051  29.163  63.580  1.00 21.54           C  
ATOM     38  CD2 PHE X  12      38.785  29.584  65.570  1.00 21.20           C  
ATOM     39  CE1 PHE X  12      41.227  29.543  64.238  1.00 23.62           C  
ATOM     40  CE2 PHE X  12      39.956  29.977  66.241  1.00 23.75           C  
ATOM     41  CZ  PHE X  12      41.176  29.949  65.570  1.00 22.68           C  
ATOM     42  N   GLN X  13      36.294  28.978  60.767  1.00 19.83           N  
ATOM     43  CA  GLN X  13      35.491  28.214  59.830  1.00 19.26           C  
ATOM     44  C   GLN X  13      36.154  26.863  59.700  1.00 18.61           C  
ATOM     45  O   GLN X  13      37.384  26.797  59.622  1.00 18.01           O  
ATOM     46  CB  GLN X  13      35.542  28.837  58.444  1.00 20.53           C  
ATOM     47  CG  GLN X  13      35.053  30.254  58.338  1.00 22.79           C  
ATOM     48  CD  GLN X  13      34.947  30.651  56.891  1.00 26.39           C  
ATOM     49  OE1 GLN X  13      35.899  31.182  56.305  1.00 28.24           O  
ATOM     50  NE2 GLN X  13      33.813  30.334  56.279  1.00 25.46           N  
ATOM     51  N   VAL X  14      35.355  25.799  59.666  1.00 17.49           N  
ATOM     52  CA  VAL X  14      35.882  24.480  59.275  1.00 16.95           C  
ATOM     53  C   VAL X  14      36.050  24.487  57.766  1.00 16.66           C  
ATOM     54  O   VAL X  14      35.136  24.894  57.045  1.00 16.80           O  
ATOM     55  CB  VAL X  14      34.957  23.314  59.702  1.00 16.90           C  
ATOM     56  CG1 VAL X  14      35.486  21.961  59.145  1.00 15.69           C  
ATOM     57  CG2 VAL X  14      34.836  23.273  61.253  1.00 17.10           C  
ATOM     58  N   VAL X  15      37.215  24.058  57.297  1.00 16.33           N  
ATOM     59  CA  VAL X  15      37.489  24.034  55.863  1.00 16.82           C  
ATOM     60  C   VAL X  15      37.859  22.617  55.450  1.00 16.96           C  
ATOM     61  O   VAL X  15      38.320  21.828  56.287  1.00 17.65           O  
ATOM     62  CB  VAL X  15      38.564  25.063  55.431  1.00 16.73           C  
ATOM     63  CG1 VAL X  15      38.054  26.512  55.680  1.00 17.46           C  
ATOM     64  CG2 VAL X  15      39.899  24.823  56.157  1.00 17.16           C  
ATOM     65  N   VAL X  16      37.616  22.299  54.182  1.00 16.23           N  
ATOM     66  CA  VAL X  16      37.827  20.945  53.643  1.00 17.21           C  
ATOM     67  C   VAL X  16      38.509  21.069  52.274  1.00 17.69           C  
ATOM     68  O   VAL X  16      38.221  22.017  51.516  1.00 16.74           O  
ATOM     69  CB  VAL X  16      36.477  20.166  53.562  1.00 16.71           C  
ATOM     70  CG1 VAL X  16      35.470  20.857  52.611  1.00 17.99           C  
ATOM     71  CG2 VAL X  16      36.672  18.686  53.167  1.00 18.13           C  
ATOM     72  N   ASN X  17      39.446  20.156  51.999  1.00 17.82           N  
ATOM     73  CA  ASN X  17      40.140  20.130  50.714  1.00 18.16           C  
ATOM     74  C   ASN X  17      39.555  19.064  49.775  1.00 18.46           C  
ATOM     75  O   ASN X  17      38.537  18.447  50.084  1.00 18.12           O  
ATOM     76  CB  ASN X  17      41.663  19.996  50.910  1.00 18.29           C  
ATOM     77  CG  ASN X  17      42.082  18.653  51.518  1.00 18.34           C  
ATOM     78  OD1 ASN X  17      41.289  17.721  51.636  1.00 19.18           O  
ATOM     79  ND2 ASN X  17      43.354  18.558  51.894  1.00 19.93           N  
ATOM     80  N   HIS X  18      40.192  18.840  48.630  1.00 19.03           N  
ATOM     81  CA  HIS X  18      39.659  17.899  47.648  1.00 19.81           C  
ATOM     82  C   HIS X  18      39.852  16.420  48.057  1.00 19.70           C  
ATOM     83  O   HIS X  18      39.238  15.518  47.482  1.00 20.23           O  
ATOM     84  CB  HIS X  18      40.230  18.216  46.257  1.00 19.99           C  
ATOM     85  CG  HIS X  18      39.684  19.485  45.665  1.00 24.40           C  
ATOM     86  ND1 HIS X  18      40.486  20.471  45.127  1.00 27.18           N  
ATOM     87  CD2 HIS X  18      38.413  19.938  45.559  1.00 26.89           C  
ATOM     88  CE1 HIS X  18      39.730  21.468  44.702  1.00 27.08           C  
ATOM     89  NE2 HIS X  18      38.467  21.169  44.951  1.00 27.78           N  
ATOM     90  N   GLU X  19      40.684  16.182  49.065  1.00 19.20           N  
ATOM     91  CA  GLU X  19      40.835  14.839  49.648  1.00 19.55           C  
ATOM     92  C   GLU X  19      39.904  14.583  50.845  1.00 19.03           C  
ATOM     93  O   GLU X  19      40.014  13.553  51.526  1.00 18.15           O  
ATOM     94  CB  GLU X  19      42.292  14.583  50.045  1.00 19.56           C  
ATOM     95  CG  GLU X  19      43.230  14.440  48.868  1.00 20.04           C  
ATOM     96  CD  GLU X  19      43.050  13.126  48.112  1.00 23.32           C  
ATOM     97  OE1 GLU X  19      42.092  12.380  48.379  1.00 24.14           O  
ATOM     98  OE2 GLU X  19      43.869  12.860  47.223  1.00 27.58           O  
ATOM     99  N   GLU X  20      38.967  15.501  51.062  1.00 18.76           N  
ATOM    100  CA  GLU X  20      38.024  15.409  52.163  1.00 20.76           C  
ATOM    101  C   GLU X  20      38.773  15.273  53.509  1.00 19.97           C  
ATOM    102  O   GLU X  20      38.438  14.457  54.371  1.00 20.47           O  
ATOM    103  CB  GLU X  20      36.975  14.315  51.892  1.00 19.91           C  
ATOM    104  CG  GLU X  20      35.589  14.656  52.399  1.00 23.39           C  
ATOM    105  CD  GLU X  20      34.563  13.579  52.098  1.00 23.79           C  
ATOM    106  OE1 GLU X  20      33.965  13.618  50.989  1.00 26.67           O  
ATOM    107  OE2 GLU X  20      34.326  12.733  52.998  1.00 28.70           O  
ATOM    108  N   GLN X  21      39.812  16.104  53.645  1.00 19.45           N  
ATOM    109  CA  GLN X  21      40.542  16.333  54.884  1.00 19.02           C  
ATOM    110  C   GLN X  21      40.130  17.700  55.425  1.00 19.09           C  
ATOM    111  O   GLN X  21      39.883  18.622  54.643  1.00 19.20           O  
ATOM    112  CB  GLN X  21      42.040  16.340  54.599  1.00 19.05           C  
ATOM    113  CG  GLN X  21      42.513  14.999  53.976  1.00 20.12           C  
ATOM    114  CD  GLN X  21      43.930  15.061  53.487  1.00 20.84           C  
ATOM    115  OE1 GLN X  21      44.354  16.056  52.884  1.00 20.35           O  
ATOM    116  NE2 GLN X  21      44.679  13.985  53.721  1.00 20.68           N  
ATOM    117  N   TYR X  22      40.087  17.831  56.749  1.00 18.75           N  
ATOM    118  CA  TYR X  22      39.499  19.013  57.390  1.00 18.40           C  
ATOM    119  C   TYR X  22      40.521  19.782  58.193  1.00 18.46           C  
ATOM    120  O   TYR X  22      41.449  19.205  58.779  1.00 17.24           O  
ATOM    121  CB  TYR X  22      38.307  18.630  58.296  1.00 18.92           C  
ATOM    122  CG  TYR X  22      37.225  17.908  57.539  1.00 20.37           C  
ATOM    123  CD1 TYR X  22      37.241  16.516  57.433  1.00 20.74           C  
ATOM    124  CD2 TYR X  22      36.207  18.617  56.883  1.00 19.94           C  
ATOM    125  CE1 TYR X  22      36.263  15.835  56.707  1.00 21.93           C  
ATOM    126  CE2 TYR X  22      35.222  17.941  56.139  1.00 19.82           C  
ATOM    127  CZ  TYR X  22      35.260  16.560  56.062  1.00 20.68           C  
ATOM    128  OH  TYR X  22      34.302  15.898  55.332  1.00 21.84           O  
ATOM    129  N   SER X  23      40.328  21.091  58.243  1.00 17.74           N  
ATOM    130  CA  SER X  23      41.111  21.928  59.133  1.00 18.48           C  
ATOM    131  C   SER X  23      40.224  23.062  59.658  1.00 18.20           C  
ATOM    132  O   SER X  23      39.041  23.160  59.302  1.00 16.98           O  
ATOM    133  CB  SER X  23      42.363  22.457  58.399  1.00 18.47           C  
ATOM    134  OG  SER X  23      43.294  23.030  59.313  1.00 22.15           O  
ATOM    135  N   ILE X  24      40.784  23.884  60.532  1.00 18.14           N  
ATOM    136  CA  ILE X  24      40.106  25.107  60.951  1.00 19.64           C  
ATOM    137  C   ILE X  24      40.878  26.300  60.398  1.00 19.71           C  
ATOM    138  O   ILE X  24      42.101  26.233  60.232  1.00 19.80           O  
ATOM    139  CB  ILE X  24      39.927  25.201  62.492  1.00 19.73           C  
ATOM    140  CG1 ILE X  24      41.279  25.156  63.210  1.00 20.82           C  
ATOM    141  CG2 ILE X  24      39.013  24.066  62.977  1.00 19.85           C  
ATOM    142  CD1 ILE X  24      41.225  25.477  64.716  1.00 21.28           C  
ATOM    143  N   TRP X  25      40.153  27.374  60.094  1.00 19.24           N  
ATOM    144  CA  TRP X  25      40.734  28.531  59.450  1.00 19.64           C  
ATOM    145  C   TRP X  25      40.045  29.777  60.020  1.00 19.53           C  
ATOM    146  O   TRP X  25      38.815  29.824  60.097  1.00 19.35           O  
ATOM    147  CB  TRP X  25      40.566  28.427  57.921  1.00 20.15           C  
ATOM    148  CG  TRP X  25      41.411  29.394  57.128  1.00 21.26           C  
ATOM    149  CD1 TRP X  25      40.966  30.454  56.377  1.00 21.77           C  
ATOM    150  CD2 TRP X  25      42.840  29.398  57.024  1.00 21.48           C  
ATOM    151  NE1 TRP X  25      42.037  31.105  55.801  1.00 22.06           N  
ATOM    152  CE2 TRP X  25      43.196  30.492  56.191  1.00 22.58           C  
ATOM    153  CE3 TRP X  25      43.859  28.603  57.567  1.00 22.26           C  
ATOM    154  CZ2 TRP X  25      44.531  30.789  55.866  1.00 22.56           C  
ATOM    155  CZ3 TRP X  25      45.193  28.906  57.246  1.00 22.11           C  
ATOM    156  CH2 TRP X  25      45.508  29.995  56.408  1.00 21.53           C  
ATOM    157  N   PRO X  26      40.835  30.794  60.410  1.00 19.76           N  
ATOM    158  CA  PRO X  26      40.210  31.969  61.002  1.00 19.98           C  
ATOM    159  C   PRO X  26      39.279  32.612  59.971  1.00 19.89           C  
ATOM    160  O   PRO X  26      39.673  32.783  58.816  1.00 18.95           O  
ATOM    161  CB  PRO X  26      41.397  32.891  61.313  1.00 20.14           C  
ATOM    162  CG  PRO X  26      42.620  32.010  61.257  1.00 20.78           C  
ATOM    163  CD  PRO X  26      42.299  30.936  60.279  1.00 20.14           C  
ATOM    164  N   GLU X  27      38.050  32.918  60.382  1.00 20.61           N  
ATOM    165  CA  GLU X  27      37.081  33.593  59.519  1.00 21.73           C  
ATOM    166  C   GLU X  27      37.613  34.893  58.905  1.00 20.77           C  
ATOM    167  O   GLU X  27      37.249  35.256  57.786  1.00 21.36           O  
ATOM    168  CB  GLU X  27      35.811  33.891  60.299  1.00 22.61           C  
ATOM    169  CG  GLU X  27      34.617  34.166  59.435  1.00 26.83           C  
ATOM    170  CD  GLU X  27      33.407  33.443  59.967  1.00 31.80           C  
ATOM    171  OE1 GLU X  27      32.818  33.935  60.954  1.00 32.74           O  
ATOM    172  OE2 GLU X  27      33.089  32.360  59.421  1.00 33.15           O  
ATOM    173  N   TYR X  28      38.493  35.579  59.631  1.00 20.04           N  
ATOM    174  CA  TYR X  28      39.047  36.837  59.157  1.00 19.41           C  
ATOM    175  C   TYR X  28      40.029  36.697  57.986  1.00 19.68           C  
ATOM    176  O   TYR X  28      40.333  37.678  57.314  1.00 18.65           O  
ATOM    177  CB  TYR X  28      39.664  37.630  60.317  1.00 19.22           C  
ATOM    178  CG  TYR X  28      40.879  37.011  60.979  1.00 18.67           C  
ATOM    179  CD1 TYR X  28      40.774  36.347  62.207  1.00 18.23           C  
ATOM    180  CD2 TYR X  28      42.153  37.146  60.412  1.00 19.90           C  
ATOM    181  CE1 TYR X  28      41.912  35.813  62.839  1.00 18.88           C  
ATOM    182  CE2 TYR X  28      43.282  36.612  61.028  1.00 18.80           C  
ATOM    183  CZ  TYR X  28      43.155  35.949  62.243  1.00 20.01           C  
ATOM    184  OH  TYR X  28      44.294  35.421  62.844  1.00 19.94           O  
ATOM    185  N   LYS X  29      40.501  35.473  57.729  1.00 20.18           N  
ATOM    186  CA  LYS X  29      41.394  35.223  56.612  1.00 21.40           C  
ATOM    187  C   LYS X  29      40.681  34.631  55.392  1.00 21.25           C  
ATOM    188  O   LYS X  29      39.762  33.813  55.519  1.00 20.60           O  
ATOM    189  CB  LYS X  29      42.565  34.321  57.038  1.00 21.93           C  
ATOM    190  CG  LYS X  29      43.434  34.948  58.130  1.00 22.76           C  
ATOM    191  CD  LYS X  29      44.721  34.195  58.371  1.00 23.87           C  
ATOM    192  CE  LYS X  29      45.841  34.740  57.505  1.00 27.66           C  
ATOM    193  NZ  LYS X  29      46.832  33.660  57.214  1.00 30.72           N  
ATOM    194  N   GLU X  30      41.118  35.056  54.210  1.00 21.04           N  
ATOM    195  CA  GLU X  30      40.701  34.425  52.961  1.00 21.40           C  
ATOM    196  C   GLU X  30      41.011  32.919  52.949  1.00 21.36           C  
ATOM    197  O   GLU X  30      42.101  32.492  53.350  1.00 21.83           O  
ATOM    198  CB  GLU X  30      41.386  35.113  51.777  1.00 21.52           C  
ATOM    199  CG  GLU X  30      40.907  36.532  51.572  1.00 23.33           C  
ATOM    200  CD  GLU X  30      39.429  36.580  51.265  1.00 24.98           C  
ATOM    201  OE1 GLU X  30      39.068  36.278  50.108  1.00 26.27           O  
ATOM    202  OE2 GLU X  30      38.639  36.915  52.182  1.00 26.20           O  
ATOM    203  N   ILE X  31      40.044  32.124  52.511  1.00 21.30           N  
ATOM    204  CA  ILE X  31      40.239  30.671  52.399  1.00 22.11           C  
ATOM    205  C   ILE X  31      41.277  30.373  51.301  1.00 22.88           C  
ATOM    206  O   ILE X  31      41.142  30.873  50.179  1.00 22.64           O  
ATOM    207  CB  ILE X  31      38.902  29.898  52.175  1.00 21.76           C  
ATOM    208  CG1 ILE X  31      37.971  30.075  53.388  1.00 22.63           C  
ATOM    209  CG2 ILE X  31      39.175  28.396  51.961  1.00 21.77           C  
ATOM    210  CD1 ILE X  31      36.557  29.473  53.242  1.00 22.48           C  
ATOM    211  N   PRO X  32      42.328  29.582  51.629  1.00 23.35           N  
ATOM    212  CA  PRO X  32      43.394  29.343  50.648  1.00 23.83           C  
ATOM    213  C   PRO X  32      42.893  28.518  49.463  1.00 23.58           C  
ATOM    214  O   PRO X  32      41.950  27.736  49.617  1.00 22.74           O  
ATOM    215  CB  PRO X  32      44.452  28.553  51.440  1.00 24.02           C  
ATOM    216  CG  PRO X  32      44.046  28.642  52.874  1.00 24.52           C  
ATOM    217  CD  PRO X  32      42.579  28.881  52.903  1.00 24.16           C  
ATOM    218  N   GLN X  33      43.496  28.716  48.288  1.00 23.67           N  
ATOM    219  CA  GLN X  33      43.191  27.887  47.116  1.00 24.67           C  
ATOM    220  C   GLN X  33      43.293  26.394  47.467  1.00 23.97           C  
ATOM    221  O   GLN X  33      44.221  25.971  48.151  1.00 23.98           O  
ATOM    222  CB  GLN X  33      44.129  28.238  45.951  1.00 25.18           C  
ATOM    223  CG  GLN X  33      44.105  27.249  44.774  1.00 29.29           C  
ATOM    224  CD  GLN X  33      42.915  27.425  43.829  1.00 33.25           C  
ATOM    225  OE1 GLN X  33      42.528  26.482  43.134  1.00 36.97           O  
ATOM    226  NE2 GLN X  33      42.345  28.625  43.788  1.00 34.87           N  
ATOM    227  N   GLY X  34      42.330  25.606  46.998  1.00 23.76           N  
ATOM    228  CA  GLY X  34      42.330  24.169  47.234  1.00 23.00           C  
ATOM    229  C   GLY X  34      41.426  23.785  48.398  1.00 22.77           C  
ATOM    230  O   GLY X  34      41.229  22.588  48.674  1.00 22.88           O  
ATOM    231  N   TRP X  35      40.897  24.802  49.083  1.00 22.18           N  
ATOM    232  CA  TRP X  35      40.031  24.615  50.258  1.00 22.04           C  
ATOM    233  C   TRP X  35      38.726  25.361  50.089  1.00 22.10           C  
ATOM    234  O   TRP X  35      38.646  26.353  49.336  1.00 21.06           O  
ATOM    235  CB  TRP X  35      40.725  25.088  51.544  1.00 21.70           C  
ATOM    236  CG  TRP X  35      41.967  24.294  51.878  1.00 22.16           C  
ATOM    237  CD1 TRP X  35      43.216  24.475  51.354  1.00 21.63           C  
ATOM    238  CD2 TRP X  35      42.076  23.200  52.813  1.00 22.13           C  
ATOM    239  NE1 TRP X  35      44.095  23.554  51.887  1.00 22.36           N  
ATOM    240  CE2 TRP X  35      43.422  22.769  52.792  1.00 21.72           C  
ATOM    241  CE3 TRP X  35      41.169  22.554  53.670  1.00 21.25           C  
ATOM    242  CZ2 TRP X  35      43.884  21.711  53.585  1.00 22.75           C  
ATOM    243  CZ3 TRP X  35      41.632  21.504  54.462  1.00 22.37           C  
ATOM    244  CH2 TRP X  35      42.984  21.091  54.407  1.00 21.10           C  
ATOM    245  N   ARG X  36      37.693  24.884  50.776  1.00 21.16           N  
ATOM    246  CA  ARG X  36      36.407  25.568  50.788  1.00 21.56           C  
ATOM    247  C   ARG X  36      35.755  25.391  52.157  1.00 21.45           C  
ATOM    248  O   ARG X  36      36.152  24.503  52.936  1.00 19.77           O  
ATOM    249  CB  ARG X  36      35.491  25.044  49.666  1.00 22.15           C  
ATOM    250  CG  ARG X  36      34.810  23.735  49.992  1.00 22.58           C  
ATOM    251  CD  ARG X  36      34.128  23.050  48.801  1.00 23.30           C  
ATOM    252  NE  ARG X  36      33.921  21.644  49.152  1.00 23.90           N  
ATOM    253  CZ  ARG X  36      32.940  21.194  49.935  1.00 24.27           C  
ATOM    254  NH1 ARG X  36      32.026  22.023  50.429  1.00 22.88           N  
ATOM    255  NH2 ARG X  36      32.873  19.900  50.216  1.00 23.02           N  
ATOM    256  N   ALA X  37      34.759  26.232  52.438  1.00 21.29           N  
ATOM    257  CA  ALA X  37      33.980  26.130  53.666  1.00 21.68           C  
ATOM    258  C   ALA X  37      33.244  24.792  53.722  1.00 22.00           C  
ATOM    259  O   ALA X  37      32.582  24.383  52.756  1.00 21.14           O  
ATOM    260  CB  ALA X  37      32.993  27.306  53.777  1.00 21.78           C  
ATOM    261  N   ALA X  38      33.377  24.108  54.852  1.00 21.94           N  
ATOM    262  CA  ALA X  38      32.754  22.807  55.034  1.00 22.78           C  
ATOM    263  C   ALA X  38      31.394  22.869  55.716  1.00 23.79           C  
ATOM    264  O   ALA X  38      30.797  21.824  55.973  1.00 24.55           O  
ATOM    265  CB  ALA X  38      33.685  21.856  55.805  1.00 22.08           C  
ATOM    266  N   GLY X  39      30.916  24.075  56.029  1.00 23.40           N  
ATOM    267  CA  GLY X  39      29.578  24.240  56.606  1.00 23.79           C  
ATOM    268  C   GLY X  39      29.513  24.363  58.120  1.00 23.64           C  
ATOM    269  O   GLY X  39      28.528  23.947  58.739  1.00 24.18           O  
ATOM    270  N   LYS X  40      30.549  24.942  58.720  1.00 22.69           N  
ATOM    271  CA  LYS X  40      30.545  25.223  60.152  1.00 22.17           C  
ATOM    272  C   LYS X  40      31.468  26.399  60.483  1.00 21.61           C  
ATOM    273  O   LYS X  40      32.646  26.372  60.128  1.00 21.14           O  
ATOM    274  CB  LYS X  40      30.955  23.971  60.954  1.00 21.79           C  
ATOM    275  CG  LYS X  40      31.089  24.165  62.465  1.00 23.01           C  
ATOM    276  CD  LYS X  40      29.727  24.364  63.133  1.00 24.17           C  
ATOM    277  CE  LYS X  40      29.858  24.375  64.644  1.00 26.32           C  
ATOM    278  NZ  LYS X  40      28.514  24.463  65.308  1.00 28.27           N  
ATOM    279  N   SER X  41      30.912  27.423  61.141  1.00 20.98           N  
ATOM    280  CA  SER X  41      31.687  28.530  61.713  1.00 21.28           C  
ATOM    281  C   SER X  41      31.444  28.565  63.210  1.00 20.97           C  
ATOM    282  O   SER X  41      30.394  28.137  63.683  1.00 20.43           O  
ATOM    283  CB  SER X  41      31.267  29.897  61.146  1.00 21.79           C  
ATOM    284  OG  SER X  41      31.634  30.062  59.789  1.00 25.49           O  
ATOM    285  N   GLY X  42      32.404  29.095  63.954  1.00 20.85           N  
ATOM    286  CA  GLY X  42      32.239  29.198  65.392  1.00 21.37           C  
ATOM    287  C   GLY X  42      33.548  29.316  66.124  1.00 21.18           C  
ATOM    288  O   GLY X  42      34.614  29.455  65.508  1.00 21.11           O  
ATOM    289  N   LEU X  43      33.463  29.271  67.450  1.00 21.16           N  
ATOM    290  CA  LEU X  43      34.651  29.238  68.271  1.00 21.40           C  
ATOM    291  C   LEU X  43      35.420  27.940  68.024  1.00 21.24           C  
ATOM    292  O   LEU X  43      34.863  26.959  67.527  1.00 21.08           O  
ATOM    293  CB  LEU X  43      34.287  29.399  69.748  1.00 22.20           C  
ATOM    294  CG  LEU X  43      33.565  30.700  70.103  1.00 22.97           C  
ATOM    295  CD1 LEU X  43      33.157  30.670  71.558  1.00 24.49           C  
ATOM    296  CD2 LEU X  43      34.422  31.936  69.805  1.00 24.33           C  
ATOM    297  N   LYS X  44      36.706  27.961  68.347  1.00 21.54           N  
ATOM    298  CA  LYS X  44      37.595  26.835  68.090  1.00 21.67           C  
ATOM    299  C   LYS X  44      37.024  25.498  68.581  1.00 21.79           C  
ATOM    300  O   LYS X  44      36.996  24.521  67.824  1.00 21.01           O  
ATOM    301  CB  LYS X  44      38.958  27.109  68.722  1.00 22.13           C  
ATOM    302  CG  LYS X  44      40.056  26.133  68.350  1.00 22.29           C  
ATOM    303  CD  LYS X  44      41.278  26.448  69.204  1.00 26.26           C  
ATOM    304  CE  LYS X  44      42.546  25.854  68.630  1.00 30.17           C  
ATOM    305  NZ  LYS X  44      43.742  26.452  69.314  1.00 31.31           N  
ATOM    306  N   LYS X  45      36.573  25.449  69.837  1.00 21.55           N  
ATOM    307  CA  LYS X  45      36.074  24.189  70.396  1.00 21.68           C  
ATOM    308  C   LYS X  45      34.879  23.624  69.598  1.00 21.04           C  
ATOM    309  O   LYS X  45      34.794  22.418  69.386  1.00 20.65           O  
ATOM    310  CB  LYS X  45      35.755  24.316  71.896  1.00 21.91           C  
ATOM    311  CG  LYS X  45      34.434  25.020  72.212  1.00 22.38           C  
ATOM    312  CD  LYS X  45      34.048  24.895  73.698  1.00 22.51           C  
ATOM    313  CE  LYS X  45      32.576  25.259  73.906  1.00 23.93           C  
ATOM    314  NZ  LYS X  45      32.052  24.725  75.199  1.00 25.09           N  
ATOM    315  N   ASP X  46      33.982  24.496  69.144  1.00 20.92           N  
ATOM    316  CA  ASP X  46      32.811  24.054  68.382  1.00 21.00           C  
ATOM    317  C   ASP X  46      33.203  23.571  66.995  1.00 20.22           C  
ATOM    318  O   ASP X  46      32.672  22.568  66.514  1.00 19.74           O  
ATOM    319  CB  ASP X  46      31.760  25.159  68.335  1.00 21.74           C  
ATOM    320  CG  ASP X  46      31.297  25.548  69.723  1.00 25.26           C  
ATOM    321  OD1 ASP X  46      31.020  24.618  70.525  1.00 28.27           O  
ATOM    322  OD2 ASP X  46      31.259  26.762  70.023  1.00 27.39           O  
ATOM    323  N   CYS X  47      34.160  24.251  66.377  1.00 19.27           N  
ATOM    324  CA  CYS X  47      34.696  23.781  65.096  1.00 19.16           C  
ATOM    325  C   CYS X  47      35.396  22.423  65.244  1.00 18.78           C  
ATOM    326  O   CYS X  47      35.207  21.538  64.415  1.00 18.26           O  
ATOM    327  CB  CYS X  47      35.623  24.821  64.479  1.00 19.16           C  
ATOM    328  SG  CYS X  47      34.731  26.288  63.882  1.00 20.07           S  
ATOM    329  N   LEU X  48      36.166  22.257  66.321  1.00 18.45           N  
ATOM    330  CA  LEU X  48      36.877  20.998  66.564  1.00 18.50           C  
ATOM    331  C   LEU X  48      35.907  19.863  66.850  1.00 18.44           C  
ATOM    332  O   LEU X  48      36.108  18.752  66.363  1.00 18.48           O  
ATOM    333  CB  LEU X  48      37.928  21.161  67.683  1.00 18.79           C  
ATOM    334  CG  LEU X  48      39.135  22.034  67.290  1.00 18.85           C  
ATOM    335  CD1 LEU X  48      40.167  22.054  68.403  1.00 19.80           C  
ATOM    336  CD2 LEU X  48      39.785  21.531  66.007  1.00 18.48           C  
ATOM    337  N   ALA X  49      34.841  20.157  67.601  1.00 18.62           N  
ATOM    338  CA  ALA X  49      33.780  19.185  67.875  1.00 18.72           C  
ATOM    339  C   ALA X  49      33.133  18.720  66.562  1.00 18.67           C  
ATOM    340  O   ALA X  49      32.933  17.529  66.345  1.00 18.35           O  
ATOM    341  CB  ALA X  49      32.734  19.779  68.820  1.00 19.04           C  
ATOM    342  N   TYR X  50      32.832  19.675  65.688  1.00 18.26           N  
ATOM    343  CA  TYR X  50      32.270  19.389  64.377  1.00 18.35           C  
ATOM    344  C   TYR X  50      33.156  18.458  63.532  1.00 17.65           C  
ATOM    345  O   TYR X  50      32.681  17.449  62.983  1.00 17.28           O  
ATOM    346  CB  TYR X  50      31.999  20.714  63.657  1.00 19.56           C  
ATOM    347  CG  TYR X  50      31.376  20.584  62.293  1.00 20.73           C  
ATOM    348  CD1 TYR X  50      30.000  20.437  62.149  1.00 22.40           C  
ATOM    349  CD2 TYR X  50      32.168  20.636  61.138  1.00 22.06           C  
ATOM    350  CE1 TYR X  50      29.421  20.325  60.883  1.00 22.71           C  
ATOM    351  CE2 TYR X  50      31.598  20.525  59.877  1.00 21.76           C  
ATOM    352  CZ  TYR X  50      30.238  20.372  59.762  1.00 21.45           C  
ATOM    353  OH  TYR X  50      29.697  20.272  58.511  1.00 23.75           O  
ATOM    354  N   ILE X  51      34.434  18.798  63.418  1.00 16.54           N  
ATOM    355  CA  ILE X  51      35.389  17.971  62.675  1.00 15.79           C  
ATOM    356  C   ILE X  51      35.400  16.544  63.255  1.00 15.84           C  
ATOM    357  O   ILE X  51      35.330  15.571  62.519  1.00 16.26           O  
ATOM    358  CB  ILE X  51      36.823  18.579  62.673  1.00 15.82           C  
ATOM    359  CG1 ILE X  51      36.845  19.880  61.855  1.00 16.23           C  
ATOM    360  CG2 ILE X  51      37.831  17.582  62.046  1.00 15.86           C  
ATOM    361  CD1 ILE X  51      38.083  20.738  62.006  1.00 15.91           C  
ATOM    362  N   GLU X  52      35.463  16.439  64.578  1.00 15.33           N  
ATOM    363  CA  GLU X  52      35.406  15.124  65.225  1.00 16.41           C  
ATOM    364  C   GLU X  52      34.121  14.343  64.868  1.00 16.97           C  
ATOM    365  O   GLU X  52      34.174  13.128  64.673  1.00 17.40           O  
ATOM    366  CB  GLU X  52      35.547  15.267  66.733  1.00 15.84           C  
ATOM    367  CG  GLU X  52      35.655  13.918  67.441  1.00 16.89           C  
ATOM    368  CD  GLU X  52      35.723  14.071  68.927  1.00 16.85           C  
ATOM    369  OE1 GLU X  52      35.968  15.213  69.397  1.00 17.11           O  
ATOM    370  OE2 GLU X  52      35.510  13.060  69.624  1.00 17.51           O  
ATOM    371  N   GLU X  53      32.995  15.050  64.776  1.00 18.16           N  
ATOM    372  CA  GLU X  53      31.697  14.451  64.421  1.00 20.00           C  
ATOM    373  C   GLU X  53      31.685  13.927  62.971  1.00 19.28           C  
ATOM    374  O   GLU X  53      31.242  12.802  62.713  1.00 19.31           O  
ATOM    375  CB  GLU X  53      30.566  15.473  64.660  1.00 19.79           C  
ATOM    376  CG  GLU X  53      29.149  14.948  64.453  1.00 22.62           C  
ATOM    377  CD  GLU X  53      28.084  16.051  64.271  1.00 24.25           C  
ATOM    378  OE1 GLU X  53      28.419  17.262  64.197  1.00 29.06           O  
ATOM    379  OE2 GLU X  53      26.886  15.690  64.186  1.00 29.85           O  
ATOM    380  N   VAL X  54      32.229  14.718  62.045  1.00 18.63           N  
ATOM    381  CA  VAL X  54      32.095  14.437  60.603  1.00 18.73           C  
ATOM    382  C   VAL X  54      33.267  13.651  59.968  1.00 18.46           C  
ATOM    383  O   VAL X  54      33.083  12.964  58.958  1.00 17.97           O  
ATOM    384  CB  VAL X  54      31.783  15.737  59.780  1.00 18.40           C  
ATOM    385  CG1 VAL X  54      30.600  16.491  60.393  1.00 20.03           C  
ATOM    386  CG2 VAL X  54      32.987  16.663  59.669  1.00 19.92           C  
ATOM    387  N   TRP X  55      34.460  13.771  60.541  1.00 18.33           N  
ATOM    388  CA  TRP X  55      35.639  13.113  59.975  1.00 19.41           C  
ATOM    389  C   TRP X  55      35.925  11.799  60.701  1.00 20.43           C  
ATOM    390  O   TRP X  55      36.774  11.726  61.590  1.00 21.90           O  
ATOM    391  CB  TRP X  55      36.844  14.059  59.993  1.00 18.94           C  
ATOM    392  CG  TRP X  55      37.966  13.663  59.067  1.00 18.37           C  
ATOM    393  CD1 TRP X  55      37.927  12.717  58.080  1.00 20.44           C  
ATOM    394  CD2 TRP X  55      39.272  14.251  59.005  1.00 18.17           C  
ATOM    395  NE1 TRP X  55      39.139  12.665  57.427  1.00 20.14           N  
ATOM    396  CE2 TRP X  55      39.979  13.598  57.977  1.00 19.79           C  
ATOM    397  CE3 TRP X  55      39.915  15.268  59.730  1.00 19.30           C  
ATOM    398  CZ2 TRP X  55      41.304  13.922  57.649  1.00 18.91           C  
ATOM    399  CZ3 TRP X  55      41.238  15.590  59.410  1.00 20.19           C  
ATOM    400  CH2 TRP X  55      41.917  14.909  58.372  1.00 19.17           C  
ATOM    401  N   THR X  56      35.198  10.758  60.328  1.00 20.89           N  
ATOM    402  CA  THR X  56      35.298   9.475  61.020  1.00 22.01           C  
ATOM    403  C   THR X  56      36.151   8.478  60.239  1.00 22.04           C  
ATOM    404  O   THR X  56      36.714   7.549  60.822  1.00 23.16           O  
ATOM    405  CB  THR X  56      33.911   8.871  61.274  1.00 21.91           C  
ATOM    406  OG1 THR X  56      33.239   8.719  60.022  1.00 22.52           O  
ATOM    407  CG2 THR X  56      33.081   9.794  62.201  1.00 22.51           C  
ATOM    408  N   ASP X  57      36.237   8.674  58.926  1.00 21.79           N  
ATOM    409  CA  ASP X  57      37.101   7.857  58.063  1.00 21.52           C  
ATOM    410  C   ASP X  57      38.220   8.778  57.624  1.00 21.11           C  
ATOM    411  O   ASP X  57      38.047   9.632  56.750  1.00 20.74           O  
ATOM    412  CB  ASP X  57      36.318   7.337  56.851  1.00 21.65           C  
ATOM    413  CG  ASP X  57      37.161   6.448  55.910  1.00 22.73           C  
ATOM    414  OD1 ASP X  57      38.402   6.345  56.071  1.00 21.37           O  
ATOM    415  OD2 ASP X  57      36.563   5.862  54.975  1.00 23.28           O  
ATOM    416  N   MET X  58      39.368   8.641  58.257  1.00 20.85           N  
ATOM    417  CA  MET X  58      40.420   9.616  57.995  1.00 22.17           C  
ATOM    418  C   MET X  58      41.374   9.294  56.851  1.00 21.48           C  
ATOM    419  O   MET X  58      42.362  10.014  56.635  1.00 21.73           O  
ATOM    420  CB  MET X  58      41.165   9.939  59.252  1.00 21.86           C  
ATOM    421  CG  MET X  58      40.277  10.739  60.228  1.00 23.75           C  
ATOM    422  SD  MET X  58      41.187  10.861  61.721  1.00 24.61           S  
ATOM    423  CE  MET X  58      40.904   9.222  62.335  1.00 30.83           C  
ATOM    424  N   ARG X  59      41.056   8.251  56.091  1.00 20.33           N  
ATOM    425  CA  ARG X  59      41.773   8.006  54.841  1.00 19.61           C  
ATOM    426  C   ARG X  59      41.455   9.155  53.877  1.00 18.84           C  
ATOM    427  O   ARG X  59      40.305   9.610  53.815  1.00 18.69           O  
ATOM    428  CB  ARG X  59      41.317   6.688  54.207  1.00 19.07           C  
ATOM    429  CG  ARG X  59      41.683   5.425  55.007  1.00 20.35           C  
ATOM    430  CD  ARG X  59      41.074   4.183  54.347  1.00 19.87           C  
ATOM    431  NE  ARG X  59      39.611   4.281  54.271  1.00 21.08           N  
ATOM    432  CZ  ARG X  59      38.839   3.461  53.562  1.00 22.97           C  
ATOM    433  NH1 ARG X  59      39.382   2.483  52.837  1.00 20.37           N  
ATOM    434  NH2 ARG X  59      37.523   3.633  53.557  1.00 22.59           N  
ATOM    435  N   PRO X  60      42.464   9.636  53.129  1.00 18.46           N  
ATOM    436  CA  PRO X  60      42.138  10.631  52.104  1.00 18.01           C  
ATOM    437  C   PRO X  60      41.126  10.032  51.144  1.00 17.10           C  
ATOM    438  O   PRO X  60      41.136   8.813  50.926  1.00 16.34           O  
ATOM    439  CB  PRO X  60      43.468  10.842  51.370  1.00 17.77           C  
ATOM    440  CG  PRO X  60      44.529  10.358  52.331  1.00 19.51           C  
ATOM    441  CD  PRO X  60      43.905   9.320  53.188  1.00 18.60           C  
ATOM    442  N   LEU X  61      40.283  10.881  50.568  1.00 17.10           N  
ATOM    443  CA  LEU X  61      39.265  10.417  49.602  1.00 16.78           C  
ATOM    444  C   LEU X  61      39.835   9.507  48.504  1.00 16.01           C  
ATOM    445  O   LEU X  61      39.214   8.488  48.162  1.00 15.54           O  
ATOM    446  CB  LEU X  61      38.548  11.620  48.975  1.00 16.31           C  
ATOM    447  CG  LEU X  61      37.440  11.339  47.945  1.00 18.14           C  
ATOM    448  CD1 LEU X  61      36.318  10.509  48.566  1.00 19.71           C  
ATOM    449  CD2 LEU X  61      36.899  12.680  47.423  1.00 18.08           C  
ATOM    450  N   SER X  62      40.985   9.877  47.920  1.00 15.24           N  
ATOM    451  CA  SER X  62      41.560   9.062  46.847  0.50 15.34           C  
ATOM    453  C   SER X  62      41.991   7.675  47.337  1.00 15.30           C  
ATOM    454  O   SER X  62      41.923   6.703  46.582  1.00 14.97           O  
ATOM    455  CB  SER X  62      42.722   9.787  46.168  0.50 15.53           C  
ATOM    457  OG  SER X  62      43.776   9.986  47.087  0.50 15.22           O  
ATOM    459  N   LEU X  63      42.411   7.584  48.596  1.00 15.14           N  
ATOM    460  CA  LEU X  63      42.729   6.281  49.198  1.00 15.82           C  
ATOM    461  C   LEU X  63      41.462   5.421  49.381  1.00 16.23           C  
ATOM    462  O   LEU X  63      41.455   4.242  49.025  1.00 15.24           O  
ATOM    463  CB  LEU X  63      43.499   6.456  50.514  1.00 15.79           C  
ATOM    464  CG  LEU X  63      43.906   5.168  51.244  1.00 15.64           C  
ATOM    465  CD1 LEU X  63      44.735   4.217  50.348  1.00 14.48           C  
ATOM    466  CD2 LEU X  63      44.676   5.546  52.501  1.00 15.69           C  
ATOM    467  N   ARG X  64      40.394   6.007  49.923  1.00 17.29           N  
ATOM    468  CA  ARG X  64      39.095   5.303  50.035  1.00 18.95           C  
ATOM    469  C   ARG X  64      38.659   4.756  48.686  1.00 19.18           C  
ATOM    470  O   ARG X  64      38.265   3.593  48.565  1.00 19.70           O  
ATOM    471  CB  ARG X  64      38.000   6.241  50.559  1.00 19.17           C  
ATOM    472  CG  ARG X  64      38.228   6.776  51.960  1.00 21.05           C  
ATOM    473  CD  ARG X  64      37.087   7.752  52.272  1.00 24.32           C  
ATOM    474  NE  ARG X  64      37.490   8.787  53.215  1.00 26.10           N  
ATOM    475  CZ  ARG X  64      36.893   9.973  53.327  1.00 27.16           C  
ATOM    476  NH1 ARG X  64      35.869  10.290  52.532  1.00 27.76           N  
ATOM    477  NH2 ARG X  64      37.326  10.850  54.233  1.00 29.82           N  
ATOM    478  N   GLN X  65      38.752   5.599  47.663  1.00 19.65           N  
ATOM    479  CA  GLN X  65      38.379   5.212  46.301  1.00 20.13           C  
ATOM    480  C   GLN X  65      39.205   4.042  45.779  1.00 20.16           C  
ATOM    481  O   GLN X  65      38.684   3.157  45.087  1.00 20.21           O  
ATOM    482  CB  GLN X  65      38.509   6.413  45.370  1.00 20.03           C  
ATOM    483  CG  GLN X  65      37.439   7.480  45.597  1.00 20.82           C  
ATOM    484  CD  GLN X  65      37.751   8.793  44.896  1.00 23.08           C  
ATOM    485  OE1 GLN X  65      38.889   9.044  44.476  1.00 22.26           O  
ATOM    486  NE2 GLN X  65      36.738   9.653  44.781  1.00 23.12           N  
ATOM    487  N   HIS X  66      40.485   4.024  46.125  1.00 19.85           N  
ATOM    488  CA  HIS X  66      41.355   2.924  45.726  1.00 20.77           C  
ATOM    489  C   HIS X  66      41.147   1.618  46.509  1.00 21.82           C  
ATOM    490  O   HIS X  66      41.309   0.514  45.959  1.00 22.92           O  
ATOM    491  CB  HIS X  66      42.810   3.384  45.710  1.00 20.09           C  
ATOM    492  CG  HIS X  66      43.176   4.116  44.450  1.00 18.33           C  
ATOM    493  ND1 HIS X  66      42.826   5.431  44.222  1.00 18.33           N  
ATOM    494  CD2 HIS X  66      43.809   3.692  43.327  1.00 16.83           C  
ATOM    495  CE1 HIS X  66      43.254   5.795  43.025  1.00 17.68           C  
ATOM    496  NE2 HIS X  66      43.851   4.759  42.461  1.00 16.04           N  
ATOM    497  N   MET X  67      40.755   1.737  47.773  1.00 21.74           N  
ATOM    498  CA  MET X  67      40.649   0.571  48.646  1.00 21.69           C  
ATOM    499  C   MET X  67      39.266  -0.059  48.597  1.00 23.20           C  
ATOM    500  O   MET X  67      39.126  -1.284  48.740  1.00 23.12           O  
ATOM    501  CB  MET X  67      40.979   0.959  50.088  1.00 21.73           C  
ATOM    502  CG  MET X  67      42.425   1.353  50.316  1.00 20.10           C  
ATOM    503  SD  MET X  67      42.768   1.611  52.073  1.00 19.47           S  
ATOM    504  CE  MET X  67      42.637  -0.062  52.691  1.00 17.05           C  
ATOM    505  N   ASP X  68      38.260   0.785  48.392  1.00 24.22           N  
ATOM    506  CA  ASP X  68      36.862   0.395  48.502  1.00 26.32           C  
ATOM    507  C   ASP X  68      36.257   0.159  47.115  1.00 27.22           C  
ATOM    508  O   ASP X  68      35.063   0.345  46.911  1.00 29.10           O  
ATOM    509  CB  ASP X  68      36.057   1.462  49.273  1.00 26.09           C  
ATOM    510  CG  ASP X  68      36.543   1.661  50.718  1.00 26.87           C  
ATOM    511  OD1 ASP X  68      37.446   0.929  51.186  1.00 28.90           O  
ATOM    512  OD2 ASP X  68      36.007   2.556  51.401  1.00 28.71           O  
TER     513      ASP X  68                                                      
END
MOLECULE T0510_235_279.pdb
ATOM   1792  N   PRO   235      38.119  38.837  68.304  1.00 56.78           N  
ATOM   1793  CA  PRO   235      37.403  37.612  68.588  1.00 57.06           C  
ATOM   1794  CB  PRO   235      36.009  38.107  68.951  1.00 56.13           C  
ATOM   1795  CG  PRO   235      35.933  39.448  68.479  1.00 55.48           C  
ATOM   1796  CD  PRO   235      37.275  40.015  68.523  1.00 56.19           C  
ATOM   1797  C   PRO   235      37.351  36.729  67.327  1.00 57.69           C  
ATOM   1798  O   PRO   235      37.213  37.235  66.219  1.00 57.92           O  
ATOM   1799  N   PRO   236      37.425  35.413  67.493  1.00 58.22           N  
ATOM   1800  CA  PRO   236      37.744  34.610  66.340  1.00 58.10           C  
ATOM   1801  CB  PRO   236      38.325  33.359  66.970  1.00 58.25           C  
ATOM   1802  CG  PRO   236      37.422  33.136  68.189  1.00 58.04           C  
ATOM   1803  CD  PRO   236      37.156  34.577  68.688  1.00 58.45           C  
ATOM   1804  C   PRO   236      36.514  34.194  65.560  1.00 58.39           C  
ATOM   1805  O   PRO   236      35.378  34.320  66.042  1.00 57.01           O  
ATOM   1806  N   THR   237      36.794  33.661  64.368  1.00 58.97           N  
ATOM   1807  CA  THR   237      35.827  32.949  63.549  1.00 58.76           C  
ATOM   1808  CB  THR   237      35.868  33.463  62.189  1.00 58.85           C  
ATOM   1809  OG1 THR   237      35.466  34.831  62.260  1.00 59.79           O  
ATOM   1810  CG2 THR   237      34.924  32.670  61.320  1.00 59.79           C  
ATOM   1811  C   THR   237      36.136  31.476  63.538  1.00 58.51           C  
ATOM   1812  O   THR   237      37.034  30.979  62.852  1.00 57.58           O  
ATOM   1813  N   PRO   238      35.417  30.770  64.370  1.00 59.11           N  
ATOM   1814  CA  PRO   238      35.594  29.334  64.399  1.00 60.04           C  
ATOM   1815  CB  PRO   238      34.640  28.872  65.530  1.00 59.91           C  
ATOM   1816  CG  PRO   238      34.272  30.092  66.278  1.00 59.22           C  
ATOM   1817  CD  PRO   238      34.415  31.250  65.333  1.00 59.02           C  
ATOM   1818  C   PRO   238      35.165  28.771  63.055  1.00 60.41           C  
ATOM   1819  O   PRO   238      34.010  28.951  62.685  1.00 60.91           O  
ATOM   1820  N   ILE   239      36.068  28.097  62.346  1.00 60.56           N  
ATOM   1821  CA  ILE   239      35.797  27.704  60.989  1.00 60.68           C  
ATOM   1822  CB  ILE   239      36.312  28.777  60.065  1.00 60.69           C  
ATOM   1823  CG1 ILE   239      35.801  28.552  58.648  1.00 60.81           C  
ATOM   1824  CD1 ILE   239      35.547  29.854  57.941  1.00 61.28           C  
ATOM   1825  CG2 ILE   239      37.839  28.864  60.130  1.00 60.77           C  
ATOM   1826  C   ILE   239      36.379  26.382  60.582  1.00 60.66           C  
ATOM   1827  O   ILE   239      37.537  26.094  60.818  1.00 59.60           O  
ATOM   1828  N   PHE   240      35.525  25.600  59.937  1.00 62.55           N  
ATOM   1829  CA  PHE   240      35.832  24.268  59.367  1.00 63.50           C  
ATOM   1830  CB  PHE   240      34.651  23.342  59.646  1.00 64.12           C  
ATOM   1831  CG  PHE   240      34.790  21.970  59.051  1.00 64.17           C  
ATOM   1832  CD1 PHE   240      35.617  21.019  59.641  1.00 65.39           C  
ATOM   1833  CE1 PHE   240      35.736  19.709  59.104  1.00 65.07           C  
ATOM   1834  CZ  PHE   240      35.031  19.366  57.986  1.00 64.69           C  
ATOM   1835  CE2 PHE   240      34.191  20.315  57.388  1.00 64.75           C  
ATOM   1836  CD2 PHE   240      34.064  21.603  57.926  1.00 65.49           C  
ATOM   1837  C   PHE   240      35.990  24.317  57.873  1.00 63.92           C  
ATOM   1838  O   PHE   240      35.179  24.925  57.207  1.00 63.86           O  
ATOM   1839  N   HIS   241      36.991  23.654  57.326  1.00 65.06           N  
ATOM   1840  CA  HIS   241      37.162  23.676  55.864  1.00 66.08           C  
ATOM   1841  CB  HIS   241      38.360  24.530  55.475  1.00 65.84           C  
ATOM   1842  CG  HIS   241      38.690  24.501  54.015  1.00 65.96           C  
ATOM   1843  ND1 HIS   241      39.422  23.487  53.441  1.00 67.40           N  
ATOM   1844  CE1 HIS   241      39.578  23.736  52.150  1.00 67.07           C  
ATOM   1845  NE2 HIS   241      38.995  24.887  51.873  1.00 66.00           N  
ATOM   1846  CD2 HIS   241      38.430  25.386  53.020  1.00 66.81           C  
ATOM   1847  C   HIS   241      37.340  22.270  55.334  1.00 67.20           C  
ATOM   1848  O   HIS   241      38.108  21.479  55.908  1.00 67.42           O  
ATOM   1849  N   ASN   243      38.456  20.577  51.720  1.00 70.21           N  
ATOM   1850  CA  ASN   243      38.872  20.490  50.320  1.00 71.02           C  
ATOM   1851  CB  ASN   243      40.393  20.391  50.203  1.00 70.84           C  
ATOM   1852  CG  ASN   243      40.867  20.603  48.780  1.00 71.08           C  
ATOM   1853  OD1 ASN   243      40.097  20.402  47.830  1.00 72.94           O  
ATOM   1854  ND2 ASN   243      42.115  21.034  48.615  1.00 70.41           N  
ATOM   1855  C   ASN   243      38.239  19.275  49.636  1.00 71.03           C  
ATOM   1856  O   ASN   243      38.421  18.144  50.084  1.00 70.81           O  
ATOM   1857  N   HIS   244      37.508  19.506  48.552  1.00 71.45           N  
ATOM   1858  CA  HIS   244      36.787  18.395  47.898  1.00 72.32           C  
ATOM   1859  CB  HIS   244      35.402  18.874  47.410  1.00 72.97           C  
ATOM   1860  CG  HIS   244      34.437  19.185  48.529  1.00 74.09           C  
ATOM   1861  ND1 HIS   244      33.738  18.205  49.213  1.00 74.28           N  
ATOM   1862  CE1 HIS   244      32.964  18.768  50.126  1.00 74.00           C  
ATOM   1863  NE2 HIS   244      33.141  20.077  50.069  1.00 75.08           N  
ATOM   1864  CD2 HIS   244      34.057  20.366  49.081  1.00 74.81           C  
ATOM   1865  C   HIS   244      37.635  17.685  46.796  1.00 72.19           C  
ATOM   1866  O   HIS   244      37.529  16.485  46.585  1.00 72.01           O  
ATOM   1867  N   GLU   245      38.460  18.474  46.123  1.00 72.31           N  
ATOM   1868  CA  GLU   245      39.709  18.048  45.463  1.00 72.01           C  
ATOM   1869  CB  GLU   245      40.497  19.361  45.129  1.00 72.78           C  
ATOM   1870  CG  GLU   245      41.727  19.257  44.268  1.00 73.32           C  
ATOM   1871  CD  GLU   245      41.544  18.244  43.188  1.00 76.23           C  
ATOM   1872  OE1 GLU   245      40.636  18.444  42.340  1.00 77.40           O  
ATOM   1873  OE2 GLU   245      42.278  17.226  43.215  1.00 78.17           O  
ATOM   1874  C   GLU   245      40.606  17.052  46.293  1.00 71.77           C  
ATOM   1875  O   GLU   245      40.915  15.970  45.819  1.00 71.98           O  
ATOM   1876  N   THR   246      41.012  17.429  47.513  1.00 70.83           N  
ATOM   1877  CA  THR   246      41.894  16.631  48.390  1.00 70.07           C  
ATOM   1878  CB  THR   246      42.591  17.557  49.490  1.00 70.62           C  
ATOM   1879  OG1 THR   246      43.300  18.623  48.856  1.00 72.35           O  
ATOM   1880  CG2 THR   246      43.565  16.796  50.431  1.00 70.20           C  
ATOM   1881  C   THR   246      41.156  15.559  49.177  1.00 69.07           C  
ATOM   1882  O   THR   246      41.751  14.554  49.507  1.00 68.80           O  
ATOM   1883  N   GLY   247      39.889  15.793  49.528  1.00 68.01           N  
ATOM   1884  CA  GLY   247      39.253  15.104  50.681  1.00 67.14           C  
ATOM   1885  C   GLY   247      39.628  15.674  52.076  1.00 66.27           C  
ATOM   1886  O   GLY   247      38.914  15.442  53.062  1.00 65.47           O  
ATOM   1887  N   LYS   248      40.735  16.425  52.163  1.00 65.09           N  
ATOM   1888  CA  LYS   248      41.247  16.980  53.435  1.00 64.76           C  
ATOM   1889  CB  LYS   248      42.490  17.837  53.175  1.00 64.40           C  
ATOM   1890  CG  LYS   248      43.265  18.218  54.419  1.00 63.97           C  
ATOM   1891  CD  LYS   248      44.549  18.932  54.018  1.00 65.03           C  
ATOM   1892  CE  LYS   248      45.393  19.478  55.199  1.00 64.61           C  
ATOM   1893  NZ  LYS   248      45.491  18.476  56.271  1.00 63.97           N  
ATOM   1894  C   LYS   248      40.235  17.812  54.281  1.00 64.50           C  
ATOM   1895  O   LYS   248      39.301  18.414  53.725  1.00 65.32           O  
ATOM   1896  N   GLU   249      40.437  17.820  55.613  1.00 63.10           N  
ATOM   1897  CA  GLU   249      39.711  18.671  56.557  1.00 61.95           C  
ATOM   1898  CB  GLU   249      38.701  17.865  57.368  1.00 61.30           C  
ATOM   1899  CG  GLU   249      37.888  16.895  56.496  1.00 62.51           C  
ATOM   1900  CD  GLU   249      36.815  16.060  57.232  1.00 62.38           C  
ATOM   1901  OE1 GLU   249      35.880  15.545  56.565  1.00 62.08           O  
ATOM   1902  OE2 GLU   249      36.908  15.881  58.462  1.00 64.07           O  
ATOM   1903  C   GLU   249      40.700  19.417  57.473  1.00 61.03           C  
ATOM   1904  O   GLU   249      41.782  18.955  57.811  1.00 59.65           O  
ATOM   1905  N   ASP   250      40.328  20.630  57.814  1.00 60.84           N  
ATOM   1906  CA  ASP   250      41.147  21.490  58.624  1.00 60.75           C  
ATOM   1907  CB  ASP   250      41.973  22.444  57.760  1.00 61.33           C  
ATOM   1908  CG  ASP   250      43.219  21.792  57.185  1.00 62.98           C  
ATOM   1909  OD1 ASP   250      44.233  21.684  57.907  1.00 66.92           O  
ATOM   1910  OD2 ASP   250      43.198  21.419  56.003  1.00 62.18           O  
ATOM   1911  C   ASP   250      40.177  22.293  59.427  1.00 60.32           C  
ATOM   1912  O   ASP   250      38.978  22.281  59.123  1.00 61.17           O  
ATOM   1913  N   PHE   251      40.696  22.980  60.442  1.00 59.37           N  
ATOM   1914  CA  PHE   251      39.938  23.933  61.245  1.00 58.83           C  
ATOM   1915  CB  PHE   251      39.381  23.259  62.514  1.00 59.11           C  
ATOM   1916  CG  PHE   251      40.481  22.660  63.451  1.00 59.95           C  
ATOM   1917  CD1 PHE   251      41.111  23.442  64.424  1.00 58.79           C  
ATOM   1918  CE1 PHE   251      42.096  22.927  65.237  1.00 57.67           C  
ATOM   1919  CZ  PHE   251      42.478  21.636  65.105  1.00 58.19           C  
ATOM   1920  CE2 PHE   251      41.853  20.812  64.175  1.00 59.69           C  
ATOM   1921  CD2 PHE   251      40.863  21.319  63.354  1.00 60.37           C  
ATOM   1922  C   PHE   251      40.875  25.040  61.655  1.00 57.73           C  
ATOM   1923  O   PHE   251      42.123  24.869  61.702  1.00 57.53           O  
ATOM   1924  N   TYR   252      40.300  26.173  61.996  1.00 56.75           N  
ATOM   1925  CA  TYR   252      41.122  27.216  62.554  1.00 56.78           C  
ATOM   1926  CB  TYR   252      42.047  27.786  61.469  1.00 55.88           C  
ATOM   1927  CG  TYR   252      43.392  28.272  61.964  1.00 56.06           C  
ATOM   1928  CD1 TYR   252      44.327  27.405  62.576  1.00 55.18           C  
ATOM   1929  CE1 TYR   252      45.577  27.879  63.027  1.00 52.73           C  
ATOM   1930  CZ  TYR   252      45.863  29.213  62.896  1.00 53.97           C  
ATOM   1931  OH  TYR   252      47.041  29.791  63.292  1.00 53.82           O  
ATOM   1932  CE2 TYR   252      44.947  30.071  62.321  1.00 55.93           C  
ATOM   1933  CD2 TYR   252      43.734  29.602  61.840  1.00 55.08           C  
ATOM   1934  C   TYR   252      40.230  28.259  63.202  1.00 57.82           C  
ATOM   1935  O   TYR   252      39.044  28.023  63.417  1.00 57.92           O  
ATOM   1936  N   PHE   253      40.793  29.398  63.553  1.00 59.19           N  
ATOM   1937  CA  PHE   253      40.019  30.386  64.241  1.00 61.04           C  
ATOM   1938  CB  PHE   253      40.659  30.678  65.563  1.00 60.09           C  
ATOM   1939  CG  PHE   253      41.924  31.395  65.476  1.00 58.42           C  
ATOM   1940  CD1 PHE   253      41.959  32.751  65.633  1.00 57.78           C  
ATOM   1941  CE1 PHE   253      43.145  33.426  65.578  1.00 57.95           C  
ATOM   1942  CZ  PHE   253      44.302  32.742  65.380  1.00 58.46           C  
ATOM   1943  CE2 PHE   253      44.282  31.375  65.240  1.00 58.52           C  
ATOM   1944  CD2 PHE   253      43.099  30.710  65.302  1.00 58.84           C  
ATOM   1945  C   PHE   253      39.808  31.674  63.489  1.00 63.18           C  
ATOM   1946  O   PHE   253      39.107  32.571  64.012  1.00 64.05           O  
ATOM   1947  N   ILE   254      40.335  31.748  62.277  1.00 64.65           N  
ATOM   1948  CA  ILE   254      39.995  32.785  61.334  1.00 65.00           C  
ATOM   1949  CB  ILE   254      41.010  33.882  61.326  1.00 64.83           C  
ATOM   1950  CG1 ILE   254      42.361  33.338  60.945  1.00 65.22           C  
ATOM   1951  CD1 ILE   254      43.428  34.282  61.254  1.00 64.94           C  
ATOM   1952  CG2 ILE   254      41.097  34.504  62.662  1.00 61.98           C  
ATOM   1953  C   ILE   254      39.884  32.175  59.951  1.00 66.83           C  
ATOM   1954  O   ILE   254      40.234  31.030  59.774  1.00 66.77           O  
ATOM   1955  N   LYS   255      39.373  32.931  58.981  1.00 68.08           N  
ATOM   1956  CA  LYS   255      39.230  32.440  57.610  1.00 68.59           C  
ATOM   1957  CB  LYS   255      38.024  33.070  56.938  1.00 69.48           C  
ATOM   1958  CG  LYS   255      37.638  34.426  57.482  1.00 71.38           C  
ATOM   1959  CD  LYS   255      36.128  34.665  57.382  1.00 70.14           C  
ATOM   1960  CE  LYS   255      35.715  35.360  56.084  1.00 71.36           C  
ATOM   1961  NZ  LYS   255      34.897  36.577  56.341  1.00 71.32           N  
ATOM   1962  C   LYS   255      40.453  32.720  56.772  1.00 68.61           C  
ATOM   1963  O   LYS   255      40.916  33.833  56.714  1.00 68.72           O  
ATOM   1964  N   LEU   256      41.019  31.691  56.188  1.00 68.87           N  
ATOM   1965  CA  LEU   256      42.319  31.817  55.609  1.00 69.01           C  
ATOM   1966  CB  LEU   256      43.188  30.659  56.037  1.00 69.13           C  
ATOM   1967  CG  LEU   256      43.293  30.245  57.482  1.00 67.71           C  
ATOM   1968  CD1 LEU   256      44.203  29.095  57.529  1.00 65.84           C  
ATOM   1969  CD2 LEU   256      43.861  31.357  58.254  1.00 67.86           C  
ATOM   1970  C   LEU   256      42.226  31.754  54.136  1.00 69.34           C  
ATOM   1971  O   LEU   256      41.699  30.814  53.605  1.00 69.38           O  
ATOM   1972  N   ASN   257      42.784  32.741  53.471  1.00 70.12           N  
ATOM   1973  CA  ASN   257      42.708  32.768  52.040  1.00 71.01           C  
ATOM   1974  CB  ASN   257      43.523  33.932  51.462  1.00 72.03           C  
ATOM   1975  CG  ASN   257      44.763  33.498  50.759  1.00 74.02           C  
ATOM   1976  OD1 ASN   257      44.710  32.872  49.711  1.00 76.53           O  
ATOM   1977  ND2 ASN   257      45.906  33.863  51.315  1.00 77.28           N  
ATOM   1978  C   ASN   257      43.065  31.406  51.490  1.00 71.28           C  
ATOM   1979  O   ASN   257      42.814  31.105  50.341  1.00 71.37           O  
ATOM   1980  N   GLN   258      43.592  30.552  52.336  1.00 71.17           N  
ATOM   1981  CA  GLN   258      43.892  29.218  51.896  1.00 70.93           C  
ATOM   1982  CB  GLN   258      45.044  28.654  52.682  1.00 71.38           C  
ATOM   1983  CG  GLN   258      44.932  27.183  52.845  1.00 72.34           C  
ATOM   1984  CD  GLN   258      46.170  26.577  53.443  1.00 73.53           C  
ATOM   1985  OE1 GLN   258      46.970  27.268  54.084  1.00 75.13           O  
ATOM   1986  NE2 GLN   258      46.344  25.278  53.242  1.00 74.55           N  
ATOM   1987  C   GLN   258      42.735  28.289  52.078  1.00 69.69           C  
ATOM   1988  O   GLN   258      42.861  27.112  51.851  1.00 69.54           O  
ATOM   1989  N   PHE   259      41.608  28.808  52.510  1.00 69.38           N  
ATOM   1990  CA  PHE   259      40.513  27.936  52.871  1.00 69.56           C  
ATOM   1991  CB  PHE   259      39.897  28.350  54.189  1.00 68.92           C  
ATOM   1992  CG  PHE   259      40.420  27.581  55.352  1.00 69.40           C  
ATOM   1993  CD1 PHE   259      41.237  26.512  55.166  1.00 68.68           C  
ATOM   1994  CE1 PHE   259      41.715  25.831  56.220  1.00 67.71           C  
ATOM   1995  CZ  PHE   259      41.389  26.198  57.462  1.00 66.14           C  
ATOM   1996  CE2 PHE   259      40.595  27.245  57.666  1.00 66.90           C  
ATOM   1997  CD2 PHE   259      40.108  27.937  56.626  1.00 68.50           C  
ATOM   1998  C   PHE   259      39.431  27.722  51.843  1.00 69.83           C  
ATOM   1999  O   PHE   259      38.728  26.731  51.923  1.00 70.64           O  
ATOM   2000  N   ASN   260      39.270  28.544  50.819  1.00 69.64           N  
ATOM   2001  CA  ASN   260      38.406  28.121  49.712  1.00 69.07           C  
ATOM   2002  CB  ASN   260      38.901  28.778  48.472  1.00 68.78           C  
ATOM   2003  CG  ASN   260      40.366  28.580  48.296  1.00 68.77           C  
ATOM   2004  OD1 ASN   260      40.820  27.539  47.844  1.00 69.84           O  
ATOM   2005  ND2 ASN   260      41.129  29.576  48.676  1.00 67.16           N  
ATOM   2006  C   ASN   260      38.730  26.673  49.505  1.00 68.60           C  
ATOM   2007  O   ASN   260      39.896  26.351  49.580  1.00 69.70           O  
ATOM   2008  N   ASP   261      37.787  25.763  49.265  1.00 20.00           N  
ATOM   2009  CA  ASP   261      36.432  25.993  48.862  1.00 20.00           C  
ATOM   2010  C   ASP   261      35.494  26.017  50.021  1.00 20.00           C  
ATOM   2011  CB  ASP   261      35.994  24.860  47.930  1.00 20.00           C  
ATOM   2012  CG  ASP   261      35.219  25.367  46.686  1.00 20.00           C  
ATOM   2013  OD1 ASP   261      33.980  25.508  46.770  1.00 20.00           O  
ATOM   2014  OD2 ASP   261      35.844  25.616  45.626  1.00 20.00           O  
ATOM   2015  O   ASP   261      35.187  27.065  50.529  1.00 20.00           O  
ATOM   2016  N   ASP   262      35.026  24.846  50.424  1.00 64.93           N  
ATOM   2017  CA  ASP   262      33.905  24.709  51.355  1.00 64.67           C  
ATOM   2018  CB  ASP   262      33.327  23.319  51.213  1.00 65.08           C  
ATOM   2019  CG  ASP   262      31.987  23.204  51.831  1.00 67.04           C  
ATOM   2020  OD1 ASP   262      31.422  24.248  52.171  1.00 68.85           O  
ATOM   2021  OD2 ASP   262      31.497  22.078  51.987  1.00 69.65           O  
ATOM   2022  C   ASP   262      34.200  24.962  52.830  1.00 64.13           C  
ATOM   2023  O   ASP   262      35.268  24.639  53.292  1.00 64.65           O  
ATOM   2024  N   THR   263      33.242  25.512  53.575  1.00 62.93           N  
ATOM   2025  CA  THR   263      33.502  25.877  54.943  1.00 61.69           C  
ATOM   2026  CB  THR   263      34.331  27.099  54.983  1.00 61.53           C  
ATOM   2027  OG1 THR   263      33.462  28.225  54.936  1.00 61.15           O  
ATOM   2028  CG2 THR   263      35.207  27.120  53.801  1.00 61.02           C  
ATOM   2029  C   THR   263      32.278  26.211  55.749  1.00 60.92           C  
ATOM   2030  O   THR   263      31.459  27.009  55.357  1.00 59.95           O  
ATOM   2031  N   VAL   264      32.211  25.600  56.916  1.00 60.39           N  
ATOM   2032  CA  VAL   264      31.149  25.784  57.911  1.00 59.43           C  
ATOM   2033  CB  VAL   264      30.644  24.420  58.399  1.00 58.90           C  
ATOM   2034  CG1 VAL   264      29.514  24.541  59.441  1.00 58.61           C  
ATOM   2035  CG2 VAL   264      30.189  23.636  57.242  1.00 57.44           C  
ATOM   2036  C   VAL   264      31.821  26.563  59.042  1.00 59.13           C  
ATOM   2037  O   VAL   264      32.979  26.284  59.347  1.00 59.17           O  
ATOM   2038  N   THR   265      31.154  27.571  59.614  1.00 58.67           N  
ATOM   2039  CA  THR   265      31.700  28.259  60.780  1.00 58.60           C  
ATOM   2040  CB  THR   265      31.787  29.778  60.663  1.00 57.71           C  
ATOM   2041  OG1 THR   265      30.473  30.247  60.584  1.00 56.69           O  
ATOM   2042  CG2 THR   265      32.579  30.257  59.458  1.00 57.28           C  
ATOM   2043  C   THR   265      30.764  27.969  61.932  1.00 59.00           C  
ATOM   2044  O   THR   265      29.634  27.555  61.684  1.00 58.78           O  
ATOM   2045  N   TYR   266      31.248  28.201  63.170  1.00 59.51           N  
ATOM   2046  CA  TYR   266      30.533  27.848  64.409  1.00 59.57           C  
ATOM   2047  CB  TYR   266      31.182  26.605  64.997  1.00 58.79           C  
ATOM   2048  CG  TYR   266      31.015  25.384  64.165  1.00 57.04           C  
ATOM   2049  CD1 TYR   266      30.015  24.488  64.446  1.00 55.62           C  
ATOM   2050  CE1 TYR   266      29.841  23.355  63.692  1.00 56.67           C  
ATOM   2051  CZ  TYR   266      30.673  23.108  62.641  1.00 57.43           C  
ATOM   2052  OH  TYR   266      30.462  21.968  61.908  1.00 58.62           O  
ATOM   2053  CE2 TYR   266      31.692  23.987  62.338  1.00 57.29           C  
ATOM   2054  CD2 TYR   266      31.863  25.119  63.110  1.00 56.27           C  
ATOM   2055  C   TYR   266      30.527  28.955  65.492  1.00 60.29           C  
ATOM   2056  O   TYR   266      31.313  29.917  65.409  1.00 60.46           O  
ATOM   2057  N   ASP   267      29.669  28.783  66.510  1.00 60.67           N  
ATOM   2058  CA  ASP   267      29.561  29.716  67.646  1.00 61.45           C  
ATOM   2059  CB  ASP   267      28.484  29.244  68.607  1.00 62.20           C  
ATOM   2060  CG  ASP   267      27.113  29.811  68.290  1.00 67.02           C  
ATOM   2061  OD1 ASP   267      26.922  30.488  67.228  1.00 71.32           O  
ATOM   2062  OD2 ASP   267      26.206  29.569  69.136  1.00 72.49           O  
ATOM   2063  C   ASP   267      30.818  29.884  68.492  1.00 61.90           C  
ATOM   2064  O   ASP   267      30.989  30.920  69.159  1.00 62.49           O  
ATOM   2065  N   SER   268      31.660  28.848  68.499  1.00 61.55           N  
ATOM   2066  CA  SER   268      32.785  28.751  69.398  1.00 60.75           C  
ATOM   2067  CB  SER   268      32.300  28.268  70.761  1.00 60.98           C  
ATOM   2068  OG  SER   268      31.995  26.868  70.763  1.00 60.36           O  
ATOM   2069  C   SER   268      33.799  27.735  68.884  1.00 60.46           C  
ATOM   2070  O   SER   268      33.516  26.858  68.029  1.00 59.60           O  
ATOM   2071  N   LEU   269      34.987  27.819  69.458  1.00 59.89           N  
ATOM   2072  CA  LEU   269      36.013  26.868  69.123  1.00 59.31           C  
ATOM   2073  CB  LEU   269      37.349  27.331  69.689  1.00 59.43           C  
ATOM   2074  CG  LEU   269      38.142  28.449  68.989  1.00 58.84           C  
ATOM   2075  CD1 LEU   269      38.880  29.276  70.043  1.00 56.68           C  
ATOM   2076  CD2 LEU   269      37.284  29.319  68.138  1.00 56.26           C  
ATOM   2077  C   LEU   269      35.630  25.476  69.655  1.00 59.20           C  
ATOM   2078  O   LEU   269      36.158  24.450  69.194  1.00 59.44           O  
ATOM   2079  N   ASN   270      34.711  25.430  70.613  1.00 58.48           N  
ATOM   2080  CA  ASN   270      34.468  24.196  71.311  1.00 58.22           C  
ATOM   2081  CB  ASN   270      33.903  24.493  72.667  1.00 57.82           C  
ATOM   2082  CG  ASN   270      34.924  25.148  73.559  1.00 58.43           C  
ATOM   2083  OD1 ASN   270      36.091  24.792  73.549  1.00 60.92           O  
ATOM   2084  ND2 ASN   270      34.503  26.121  74.316  1.00 59.72           N  
ATOM   2085  C   ASN   270      33.553  23.405  70.461  1.00 58.21           C  
ATOM   2086  O   ASN   270      33.760  22.224  70.232  1.00 59.01           O  
ATOM   2087  N   ASP   271      32.547  24.085  69.943  1.00 57.90           N  
ATOM   2088  CA  ASP   271      31.720  23.536  68.891  1.00 56.76           C  
ATOM   2089  CB  ASP   271      30.777  24.632  68.412  1.00 57.53           C  
ATOM   2090  CG  ASP   271      29.667  24.921  69.382  1.00 59.49           C  
ATOM   2091  OD1 ASP   271      29.498  24.136  70.305  1.00 64.52           O  
ATOM   2092  OD2 ASP   271      28.935  25.921  69.234  1.00 64.86           O  
ATOM   2093  C   ASP   271      32.576  23.059  67.706  1.00 56.10           C  
ATOM   2094  O   ASP   271      32.422  21.928  67.226  1.00 55.45           O  
ATOM   2095  N   LEU   272      33.462  23.937  67.222  1.00 55.06           N  
ATOM   2096  CA  LEU   272      34.274  23.623  66.054  1.00 54.61           C  
ATOM   2097  CB  LEU   272      35.281  24.747  65.804  1.00 54.69           C  
ATOM   2098  CG  LEU   272      36.399  24.538  64.769  1.00 54.29           C  
ATOM   2099  CD1 LEU   272      35.733  24.269  63.429  1.00 53.12           C  
ATOM   2100  CD2 LEU   272      37.393  25.732  64.722  1.00 52.33           C  
ATOM   2101  C   LEU   272      34.970  22.291  66.283  1.00 54.28           C  
ATOM   2102  O   LEU   272      34.852  21.378  65.496  1.00 52.39           O  
ATOM   2103  N   LEU   273      35.661  22.179  67.411  1.00 55.02           N  
ATOM   2104  CA  LEU   273      36.346  20.938  67.767  1.00 55.73           C  
ATOM   2105  CB  LEU   273      37.228  21.163  69.000  1.00 55.87           C  
ATOM   2106  CG  LEU   273      38.662  21.718  68.890  1.00 56.75           C  
ATOM   2107  CD1 LEU   273      38.880  22.843  69.933  1.00 55.95           C  
ATOM   2108  CD2 LEU   273      39.002  22.213  67.507  1.00 58.78           C  
ATOM   2109  C   LEU   273      35.375  19.749  67.972  1.00 55.55           C  
ATOM   2110  O   LEU   273      35.617  18.657  67.459  1.00 54.28           O  
ATOM   2111  N   ASP   274      34.287  19.951  68.708  1.00 56.51           N  
ATOM   2112  CA  ASP   274      33.324  18.865  68.930  1.00 58.38           C  
ATOM   2113  CB  ASP   274      31.990  19.395  69.530  1.00 59.03           C  
ATOM   2114  CG  ASP   274      31.881  19.227  71.078  1.00 61.08           C  
ATOM   2115  OD1 ASP   274      32.742  18.544  71.677  1.00 64.56           O  
ATOM   2116  OD2 ASP   274      30.905  19.753  71.697  1.00 60.37           O  
ATOM   2117  C   ASP   274      33.051  18.140  67.590  1.00 59.07           C  
ATOM   2118  O   ASP   274      33.085  16.910  67.500  1.00 59.81           O  
ATOM   2119  N   ARG   275      32.807  18.921  66.546  1.00 59.66           N  
ATOM   2120  CA  ARG   275      32.506  18.378  65.244  1.00 59.52           C  
ATOM   2121  CB  ARG   275      32.022  19.508  64.328  1.00 60.24           C  
ATOM   2122  CG  ARG   275      31.590  19.067  62.950  1.00 61.21           C  
ATOM   2123  CD  ARG   275      32.727  19.218  61.965  1.00 67.01           C  
ATOM   2124  NE  ARG   275      32.213  19.478  60.618  1.00 71.17           N  
ATOM   2125  CZ  ARG   275      31.944  18.547  59.694  1.00 72.56           C  
ATOM   2126  NH1 ARG   275      32.153  17.242  59.932  1.00 75.00           N  
ATOM   2127  NH2 ARG   275      31.457  18.925  58.515  1.00 70.89           N  
ATOM   2128  C   ARG   275      33.722  17.708  64.657  1.00 59.14           C  
ATOM   2129  O   ARG   275      33.740  16.511  64.406  1.00 59.80           O  
ATOM   2130  N   PHE   276      34.759  18.484  64.467  1.00 58.47           N  
ATOM   2131  CA  PHE   276      35.925  17.991  63.796  1.00 58.58           C  
ATOM   2132  CB  PHE   276      37.005  19.028  63.885  1.00 58.63           C  
ATOM   2133  CG  PHE   276      38.173  18.731  63.029  1.00 59.60           C  
ATOM   2134  CD1 PHE   276      38.282  19.290  61.767  1.00 60.31           C  
ATOM   2135  CE1 PHE   276      39.390  19.027  60.976  1.00 61.02           C  
ATOM   2136  CZ  PHE   276      40.385  18.190  61.445  1.00 59.55           C  
ATOM   2137  CE2 PHE   276      40.268  17.640  62.682  1.00 59.82           C  
ATOM   2138  CD2 PHE   276      39.177  17.906  63.471  1.00 59.93           C  
ATOM   2139  C   PHE   276      36.492  16.664  64.309  1.00 58.62           C  
ATOM   2140  O   PHE   276      37.138  15.959  63.559  1.00 58.14           O  
ATOM   2141  N   TYR   277      36.310  16.326  65.582  1.00 59.51           N  
ATOM   2142  CA  TYR   277      36.891  15.070  66.080  1.00 59.37           C  
ATOM   2143  CB  TYR   277      37.770  15.273  67.304  1.00 58.20           C  
ATOM   2144  CG  TYR   277      39.074  15.937  66.968  1.00 56.40           C  
ATOM   2145  CD1 TYR   277      40.121  15.229  66.373  1.00 54.78           C  
ATOM   2146  CE1 TYR   277      41.331  15.843  66.051  1.00 54.66           C  
ATOM   2147  CZ  TYR   277      41.492  17.189  66.334  1.00 56.64           C  
ATOM   2148  OH  TYR   277      42.636  17.887  66.033  1.00 56.35           O  
ATOM   2149  CE2 TYR   277      40.475  17.903  66.953  1.00 57.71           C  
ATOM   2150  CD2 TYR   277      39.268  17.270  67.257  1.00 56.92           C  
ATOM   2151  C   TYR   277      35.859  14.056  66.341  1.00 61.03           C  
ATOM   2152  O   TYR   277      36.050  13.190  67.133  1.00 60.14           O  
ATOM   2153  N   ASP   278      34.773  14.125  65.604  1.00 64.34           N  
ATOM   2154  CA  ASP   278      33.793  13.055  65.657  1.00 67.25           C  
ATOM   2155  CB  ASP   278      32.428  13.590  65.181  1.00 67.49           C  
ATOM   2156  CG  ASP   278      31.256  12.980  65.954  1.00 70.02           C  
ATOM   2157  OD1 ASP   278      31.431  12.654  67.171  1.00 68.92           O  
ATOM   2158  OD2 ASP   278      30.161  12.833  65.328  1.00 73.24           O  
ATOM   2159  C   ASP   278      34.232  11.755  64.872  1.00 68.21           C  
ATOM   2160  O   ASP   278      33.794  10.633  65.242  1.00 67.92           O  
ATOM   2161  N   ALA   279      35.105  11.901  63.835  1.00 69.48           N  
ATOM   2162  CA  ALA   279      35.341  10.812  62.775  1.00 69.71           C  
ATOM   2163  CB  ALA   279      35.793  11.443  61.349  1.00 69.27           C  
ATOM   2164  C   ALA   279      36.256   9.600  63.185  1.00 69.97           C  
ATOM   2165  O   ALA   279      37.255   9.750  63.917  1.00 69.96           O  
END
