
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  254 ( 1885),  selected  254 , name 1g0n_B
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1g0n_B.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y    13_B      -       -           -
LGA    D    14_B      -       -           -
LGA    A    15_B      -       -           -
LGA    I    16_B      -       -           -
LGA    P    17_B      -       -           -
LGA    G    18_B      -       -           -
LGA    P    19_B      -       -           -
LGA    L    20_B      -       -           -
LGA    G    21_B      -       -           -
LGA    P    22_B      -       -           -
LGA    Q    23_B      -       -           -
LGA    S    24_B      -       -           -
LGA    A    25_B      M       1          1.953
LGA    S    26_B      T       2          1.402
LGA    L    27_B      L       3          1.150
LGA    E    28_B      S       4          1.403
LGA    G    29_B      G       5          1.375
LGA    K    30_B      K       6          0.674
LGA    V    31_B      T       7          0.922
LGA    A    32_B      L       8          0.821
LGA    L    33_B      F       9          1.006
LGA    V    34_B      I      10          0.550
LGA    T    35_B      T      11          0.691
LGA    G    36_B      G      12          0.664
LGA    A    37_B      A      13          0.641
LGA    G    38_B      S      14          0.411
LGA    R    39_B      R      15          0.835
LGA    G    40_B      G      16          0.826
LGA    I    41_B      I      17          0.670
LGA    G    42_B      G      18          0.735
LGA    R    43_B      L      19          0.703
LGA    E    44_B      A      20          0.606
LGA    M    45_B      I      21          0.869
LGA    A    46_B      A      22          0.503
LGA    M    47_B      L      23          0.520
LGA    E    48_B      R      24          0.631
LGA    L    49_B      A      25          0.963
LGA    G    50_B      A      26          0.758
LGA    R    51_B      R      27          0.876
LGA    R    52_B      D      28          2.064
LGA    G    53_B      G      29          2.301
LGA    C    54_B      A      30          0.760
LGA    K    55_B      N      31          0.877
LGA    V    56_B      V      32          0.651
LGA    I    57_B      A      33          0.734
LGA    V    58_B      I      34          0.981
LGA    N    59_B      A      35          1.157
LGA    Y    60_B      A      36          1.176
LGA    A    61_B      K      37          0.735
LGA    N    62_B      S      38          1.947
LGA    S    63_B      A      39          4.419
LGA    T    64_B      V      40          3.892
LGA    E    65_B      A      41          4.802
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    S    66_B      T      48          2.237
LGA    A    67_B      I      49          1.866
LGA    E    68_B      H      50          1.213
LGA    E    69_B      S      51          1.282
LGA    V    70_B      A      52          1.541
LGA    V    71_B      A      53          1.216
LGA    A    72_B      A      54          1.261
LGA    A    73_B      A      55          1.606
LGA    I    74_B      V      56          1.440
LGA    K    75_B      N      57          1.043
LGA    K    76_B      A      58          1.492
LGA    N    77_B      A      59          1.971
LGA    G    78_B      G      60          1.837
LGA    S    79_B      G      61          1.529
LGA    D    80_B      Q      62          1.140
LGA    A    81_B      G      63          1.021
LGA    A    82_B      L      64          1.132
LGA    C    83_B      A      65          0.748
LGA    V    84_B      L      66          0.650
LGA    K    85_B      K      67          0.848
LGA    A    86_B      C      68          1.012
LGA    N    87_B      D      69          0.827
LGA    V    88_B      I      70          0.802
LGA    G    89_B      R      71          0.630
LGA    V    90_B      E      72          1.042
LGA    V    91_B      E      73          1.027
LGA    E    92_B      D      74          1.286
LGA    D    93_B      Q      75          1.170
LGA    I    94_B      V      76          1.020
LGA    V    95_B      R      77          1.092
LGA    R    96_B      A      78          1.126
LGA    M    97_B      A      79          1.078
LGA    F    98_B      V      80          0.624
LGA    E    99_B      A      81          0.716
LGA    E   100_B      A      82          1.047
LGA    A   101_B      T      83          1.113
LGA    V   102_B      V      84          0.578
LGA    K   103_B      D      85          0.585
LGA    I   104_B      T      86          1.117
LGA    F   105_B      F      87          0.969
LGA    G   106_B      G      88          1.279
LGA    K   107_B      G      89          1.147
LGA    L   108_B      I      90          0.981
LGA    D   109_B      D      91          0.593
LGA    I   110_B      I      92          0.743
LGA    V   111_B      L      93          0.874
LGA    C   112_B      V      94          0.655
LGA    S   113_B      N      95          1.217
LGA    N   114_B      N      96          0.779
LGA    S   115_B      A      97          2.681
LGA    G   116_B      S      98          2.610
LGA    V   117_B      A      99          1.206
LGA    V   118_B      I     100          1.393
LGA    S   119_B      W     101          1.281
LGA    F   120_B      L     102          2.385
LGA    G   121_B      R     103          1.381
LGA    H   122_B      G     104          1.634
LGA    V   123_B      T     105          1.913
LGA    K   124_B      L     106          2.192
LGA    D   125_B      D     107          1.738
LGA    V   126_B      T     108          2.029
LGA    T   127_B      P     109          2.554
LGA    P   128_B      M     110          2.289
LGA    E   129_B      K     111          2.302
LGA    E   130_B      R     112          1.895
LGA    F   131_B      F     113          1.144
LGA    D   132_B      D     114          1.299
LGA    R   133_B      L     115          1.605
LGA    V   134_B      M     116          0.920
LGA    F   135_B      Q     117          0.370
LGA    T   136_B      Q     118          1.017
LGA    I   137_B      V     119          1.031
LGA    N   138_B      N     120          0.724
LGA    T   139_B      A     121          0.937
LGA    R   140_B      R     122          0.845
LGA    G   141_B      G     123          1.216
LGA    Q   142_B      S     124          1.032
LGA    F   143_B      F     125          0.600
LGA    F   144_B      V     126          0.472
LGA    V   145_B      C     127          0.482
LGA    A   146_B      A     128          0.810
LGA    R   147_B      Q     129          0.624
LGA    E   148_B      A     130          0.774
LGA    A   149_B      C     131          1.329
LGA    Y   150_B      L     132          0.664
LGA    K   151_B      P     133          1.672
LGA    H   152_B      H     134          1.946
LGA    L   153_B      L     135          1.624
LGA    -       -      L     136           -
LGA    E   154_B      Q     137          3.079
LGA    I   155_B      A     138          3.415
LGA    G   156_B      P     139          3.973
LGA    -       -      N     140           -
LGA    G   157_B      P     141          0.896
LGA    R   158_B      H     142          0.855
LGA    L   159_B      I     143          0.712
LGA    I   160_B      L     144          0.785
LGA    L   161_B      T     145          1.108
LGA    M   162_B      L     146          1.881
LGA    G   163_B      A     147          0.948
LGA    S   164_B      P     148          3.841
LGA    I   165_B      P     149           #
LGA    T   166_B      -       -           -
LGA    G   167_B      P     150          5.600
LGA    Q   168_B      S     151          4.253
LGA    A   169_B      L     152           -
LGA    K   170_B      N     153           #
LGA    A   171_B      P     154           -
LGA    -       -      A     155           -
LGA    -       -      W     156           -
LGA    -       -      W     157           -
LGA    V   172_B      G     158           #
LGA    P   173_B      A     159          3.509
LGA    K   174_B      -       -           -
LGA    H   175_B      H     160          2.773
LGA    A   176_B      T     161          2.330
LGA    V   177_B      G     162          1.636
LGA    Y   178_B      Y     163          1.650
LGA    S   179_B      T     164          2.126
LGA    G   180_B      L     165          1.971
LGA    S   181_B      A     166          1.031
LGA    K   182_B      K     167          1.260
LGA    G   183_B      M     168          1.043
LGA    A   184_B      G     169          1.830
LGA    I   185_B      M     170          1.936
LGA    E   186_B      S     171          1.835
LGA    T   187_B      L     172          2.138
LGA    F   188_B      V     173          1.815
LGA    A   189_B      T     174          1.628
LGA    R   190_B      L     175          2.113
LGA    C   191_B      G     176          1.658
LGA    M   192_B      L     177          0.835
LGA    A   193_B      A     178          1.331
LGA    I   194_B      A     179          2.676
LGA    D   195_B      E     180          2.108
LGA    M   196_B      F     181          1.929
LGA    A   197_B      G     182          3.117
LGA    D   198_B      P     183           #
LGA    K   199_B      Q     184          4.170
LGA    K   200_B      G     185          1.997
LGA    I   201_B      V     186          1.237
LGA    T   202_B      A     187          1.090
LGA    V   203_B      I     188          0.476
LGA    N   204_B      N     189          0.671
LGA    V   205_B      A     190          1.024
LGA    V   206_B      L     191          1.262
LGA    A   207_B      W     192          1.760
LGA    P   208_B      P     193          2.675
LGA    -       -      R     194           -
LGA    G   209_B      T     195          3.873
LGA    G   210_B      V     196          1.215
LGA    I   211_B      I     197          0.629
LGA    K   212_B      A     198          0.616
LGA    T   213_B      T     199          0.775
LGA    D   214_B      D     200          0.679
LGA    M   215_B      A     201          0.823
LGA    Y   216_B      I     202          2.039
LGA    H   217_B      N     203          3.566
LGA    A   218_B      M     204          3.177
LGA    -       -      L     205           -
LGA    -       -      P     206           -
LGA    -       -      G     207           -
LGA    -       -      V     208           -
LGA    -       -      D     209           -
LGA    D   236_B      A     210          4.067
LGA    E   237_B      A     211          4.967
LGA    Y   238_B      A     212          4.733
LGA    A   239_B      -       -           -
LGA    A   240_B      -       -           -
LGA    V   241_B      -       -           -
LGA    Q   242_B      -       -           -
LGA    W   243_B      -       -           -
LGA    S   244_B      -       -           -
LGA    P   245_B      -       -           -
LGA    L   246_B      -       -           -
LGA    R   247_B      -       -           -
LGA    R   248_B      -       -           -
LGA    V   249_B      C     213          2.359
LGA    G   250_B      R     214          1.822
LGA    L   251_B      R     215          1.691
LGA    P   252_B      P     216          1.006
LGA    I   253_B      E     217          0.974
LGA    D   254_B      I     218          0.786
LGA    I   255_B      M     219          0.729
LGA    A   256_B      A     220          1.124
LGA    R   257_B      D     221          1.400
LGA    V   258_B      A     222          1.809
LGA    V   259_B      A     223          1.524
LGA    C   260_B      H     224          1.445
LGA    F   261_B      A     225          1.854
LGA    L   262_B      V     226          1.975
LGA    A   263_B      L     227          1.437
LGA    S   264_B      T     228          1.234
LGA    N   265_B      R     229          2.936
LGA    D   266_B      E     230          4.622
LGA    G   267_B      A     231          5.514
LGA    G   268_B      A     232          4.551
LGA    W   269_B      G     233          3.547
LGA    V   270_B      F     234          2.443
LGA    T   271_B      H     235          0.839
LGA    G   272_B      G     236          0.717
LGA    K   273_B      Q     237          0.907
LGA    V   274_B      F     238          0.849
LGA    I   275_B      L     239          0.977
LGA    G   276_B      I     240          2.396
LGA    I   277_B      D     241          3.075
LGA    D   278_B      -       -           -
LGA    G   279_B      D     242          5.397
LGA    G   280_B      E     243           #
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    -       -      L     264           -
LGA    -       -      L     265           -
LGA    A   281_B      P     266          3.279
LGA    C   282_B      D     267           #
LGA    M   283_B      L     268          4.868
LGA    -       -      F     269           -
LGA    -       -      L     270           -
LGA    -       -      E     271           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  254  271    5.0    221    1.94    20.81     70.615    10.818

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.274083 * X  +  -0.090131 * Y  +   0.957473 * Z  +  96.540367
  Y_new =   0.235464 * X  +  -0.971585 * Y  +  -0.024056 * Z  +  55.764072
  Z_new =   0.932435 * X  +   0.218857 * Y  +   0.287518 * Z  + -39.281715 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.650628   -2.490964  [ DEG:    37.2782   -142.7218 ]
  Theta =  -1.201094   -1.940499  [ DEG:   -68.8176   -111.1824 ]
  Phi   =   2.431840   -0.709753  [ DEG:   139.3342    -40.6658 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1g0n_B                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1g0n_B.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  254  271   5.0  221   1.94   20.81  70.615
REMARK  ---------------------------------------------------------- 
MOLECULE 1g0n_B
HEADER    OXIDOREDUCTASE                          06-OCT-00   1G0N              
TITLE     STRUCTURE OF TRIHYDROXYNAPHTHALENE REDUCTASE IN COMPLEX               
TITLE    2 WITH NADPH AND 4,5,6,7-TETRACHLORO-PHTHALIDE                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRIHYDROXYNAPHTHALENE REDUCTASE;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.1.1.252;                                                       
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MAGNAPORTHE GRISEA;                             
SOURCE   3 ORGANISM_COMMON: RICE BLAST FUNGUS;                                  
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PTHNR2                                    
KEYWDS    PROTEIN-NADPH-ACTIVE SITE INHIBITOR COMPLEX, DIUNCLEOTIDE             
KEYWDS   2 BINDING FOLD, OXIDOREDUCTASE, SHORT CHAIN DEHYDROGENASE              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.LIAO,G.S.BASARAB,A.A.GATENBY,B.VALENT,D.B.JORDAN                    
REVDAT   2   01-APR-03 1G0N    1       JRNL                                     
REVDAT   1   06-JUN-01 1G0N    0                                                
JRNL        AUTH   D.LIAO,G.S.BASARAB,A.A.GATENBY,B.VALENT,D.B.JORDAN           
JRNL        TITL   STRUCTURES OF TRIHYDROXYNAPHTHALENE                          
JRNL        TITL 2 REDUCTASE-FUNGICIDE COMPLEXES: IMPLICATIONS FOR              
JRNL        TITL 3 STRUCTURE-BASED DESIGN AND CATALYSIS.                        
JRNL        REF    STRUCTURE                     V.   9    19 2001              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1G0N A    1   283  UNP    Q12634   T4HR_MAGGR       1    283             
DBREF  1G0N B    1   283  UNP    Q12634   T4HR_MAGGR       1    283             
SEQRES   1 A  283  MET PRO ALA VAL THR GLN PRO ARG GLY GLU SER LYS TYR          
SEQRES   2 A  283  ASP ALA ILE PRO GLY PRO LEU GLY PRO GLN SER ALA SER          
SEQRES   3 A  283  LEU GLU GLY LYS VAL ALA LEU VAL THR GLY ALA GLY ARG          
SEQRES   4 A  283  GLY ILE GLY ARG GLU MET ALA MET GLU LEU GLY ARG ARG          
SEQRES   5 A  283  GLY CYS LYS VAL ILE VAL ASN TYR ALA ASN SER THR GLU          
SEQRES   6 A  283  SER ALA GLU GLU VAL VAL ALA ALA ILE LYS LYS ASN GLY          
SEQRES   7 A  283  SER ASP ALA ALA CYS VAL LYS ALA ASN VAL GLY VAL VAL          
SEQRES   8 A  283  GLU ASP ILE VAL ARG MET PHE GLU GLU ALA VAL LYS ILE          
SEQRES   9 A  283  PHE GLY LYS LEU ASP ILE VAL CYS SER ASN SER GLY VAL          
SEQRES  10 A  283  VAL SER PHE GLY HIS VAL LYS ASP VAL THR PRO GLU GLU          
SEQRES  11 A  283  PHE ASP ARG VAL PHE THR ILE ASN THR ARG GLY GLN PHE          
SEQRES  12 A  283  PHE VAL ALA ARG GLU ALA TYR LYS HIS LEU GLU ILE GLY          
SEQRES  13 A  283  GLY ARG LEU ILE LEU MET GLY SER ILE THR GLY GLN ALA          
SEQRES  14 A  283  LYS ALA VAL PRO LYS HIS ALA VAL TYR SER GLY SER LYS          
SEQRES  15 A  283  GLY ALA ILE GLU THR PHE ALA ARG CYS MET ALA ILE ASP          
SEQRES  16 A  283  MET ALA ASP LYS LYS ILE THR VAL ASN VAL VAL ALA PRO          
SEQRES  17 A  283  GLY GLY ILE LYS THR ASP MET TYR HIS ALA VAL CYS ARG          
SEQRES  18 A  283  GLU TYR ILE PRO ASN GLY GLU ASN LEU SER ASN GLU GLU          
SEQRES  19 A  283  VAL ASP GLU TYR ALA ALA VAL GLN TRP SER PRO LEU ARG          
SEQRES  20 A  283  ARG VAL GLY LEU PRO ILE ASP ILE ALA ARG VAL VAL CYS          
SEQRES  21 A  283  PHE LEU ALA SER ASN ASP GLY GLY TRP VAL THR GLY LYS          
SEQRES  22 A  283  VAL ILE GLY ILE ASP GLY GLY ALA CYS MET                      
SEQRES   1 B  283  MET PRO ALA VAL THR GLN PRO ARG GLY GLU SER LYS TYR          
SEQRES   2 B  283  ASP ALA ILE PRO GLY PRO LEU GLY PRO GLN SER ALA SER          
SEQRES   3 B  283  LEU GLU GLY LYS VAL ALA LEU VAL THR GLY ALA GLY ARG          
SEQRES   4 B  283  GLY ILE GLY ARG GLU MET ALA MET GLU LEU GLY ARG ARG          
SEQRES   5 B  283  GLY CYS LYS VAL ILE VAL ASN TYR ALA ASN SER THR GLU          
SEQRES   6 B  283  SER ALA GLU GLU VAL VAL ALA ALA ILE LYS LYS ASN GLY          
SEQRES   7 B  283  SER ASP ALA ALA CYS VAL LYS ALA ASN VAL GLY VAL VAL          
SEQRES   8 B  283  GLU ASP ILE VAL ARG MET PHE GLU GLU ALA VAL LYS ILE          
SEQRES   9 B  283  PHE GLY LYS LEU ASP ILE VAL CYS SER ASN SER GLY VAL          
SEQRES  10 B  283  VAL SER PHE GLY HIS VAL LYS ASP VAL THR PRO GLU GLU          
SEQRES  11 B  283  PHE ASP ARG VAL PHE THR ILE ASN THR ARG GLY GLN PHE          
SEQRES  12 B  283  PHE VAL ALA ARG GLU ALA TYR LYS HIS LEU GLU ILE GLY          
SEQRES  13 B  283  GLY ARG LEU ILE LEU MET GLY SER ILE THR GLY GLN ALA          
SEQRES  14 B  283  LYS ALA VAL PRO LYS HIS ALA VAL TYR SER GLY SER LYS          
SEQRES  15 B  283  GLY ALA ILE GLU THR PHE ALA ARG CYS MET ALA ILE ASP          
SEQRES  16 B  283  MET ALA ASP LYS LYS ILE THR VAL ASN VAL VAL ALA PRO          
SEQRES  17 B  283  GLY GLY ILE LYS THR ASP MET TYR HIS ALA VAL CYS ARG          
SEQRES  18 B  283  GLU TYR ILE PRO ASN GLY GLU ASN LEU SER ASN GLU GLU          
SEQRES  19 B  283  VAL ASP GLU TYR ALA ALA VAL GLN TRP SER PRO LEU ARG          
SEQRES  20 B  283  ARG VAL GLY LEU PRO ILE ASP ILE ALA ARG VAL VAL CYS          
SEQRES  21 B  283  PHE LEU ALA SER ASN ASP GLY GLY TRP VAL THR GLY LYS          
SEQRES  22 B  283  VAL ILE GLY ILE ASP GLY GLY ALA CYS MET                      
HET    NDP    400      48                                                       
HET    NDP    401      48                                                       
HET    PHH    402      14                                                       
HETNAM     NDP NADPH DIHYDRO-NICOTINAMIDE-ADENINE-DINUCLEOTIDE                  
HETNAM   2 NDP  PHOSPHATE                                                       
HETNAM     PHH 4,5,6,7-TETRACHLORO-PHTHALIDE                                    
HETSYN     PHH 4,5,6,7-TETRACHLORO-3H-ISOBENZOFURAN-1-ONE                       
FORMUL   3  NDP    2(C21 H30 N7 O17 P3)                                         
FORMUL   5  PHH    C8 H2 CL4 O2                                                 
FORMUL   6  HOH   *386(H2 O)                                                    
CRYST1  140.500  140.500   72.700  90.00  90.00 120.00 P 31 2 1     12          
ATOM   2038  N   TYR B  13      45.806  19.161  59.650  1.00 47.16           N  
ATOM   2039  CA  TYR B  13      47.215  19.195  60.040  1.00 45.68           C  
ATOM   2040  C   TYR B  13      48.089  18.553  58.980  1.00 43.81           C  
ATOM   2041  O   TYR B  13      49.298  18.424  59.148  1.00 43.77           O  
ATOM   2042  CB  TYR B  13      47.434  18.511  61.398  1.00 46.04           C  
ATOM   2043  CG  TYR B  13      46.895  19.298  62.582  1.00 46.10           C  
ATOM   2044  CD1 TYR B  13      45.986  18.723  63.475  1.00 46.46           C  
ATOM   2045  CD2 TYR B  13      47.292  20.618  62.808  1.00 46.27           C  
ATOM   2046  CE1 TYR B  13      45.487  19.439  64.561  1.00 45.52           C  
ATOM   2047  CE2 TYR B  13      46.797  21.344  63.890  1.00 44.83           C  
ATOM   2048  CZ  TYR B  13      45.898  20.746  64.761  1.00 45.64           C  
ATOM   2049  OH  TYR B  13      45.423  21.448  65.843  1.00 45.47           O  
ATOM   2050  N   ASP B  14      47.461  18.135  57.890  1.00 42.33           N  
ATOM   2051  CA  ASP B  14      48.188  17.534  56.793  1.00 41.59           C  
ATOM   2052  C   ASP B  14      48.524  18.584  55.743  1.00 38.94           C  
ATOM   2053  O   ASP B  14      49.333  18.325  54.848  1.00 38.41           O  
ATOM   2054  CB  ASP B  14      47.380  16.395  56.168  1.00 45.07           C  
ATOM   2055  CG  ASP B  14      47.429  15.120  56.995  1.00 48.87           C  
ATOM   2056  OD1 ASP B  14      46.583  14.231  56.759  1.00 52.94           O  
ATOM   2057  OD2 ASP B  14      48.316  14.992  57.869  1.00 51.23           O  
ATOM   2058  N   ALA B  15      47.913  19.768  55.875  1.00 35.48           N  
ATOM   2059  CA  ALA B  15      48.121  20.883  54.939  1.00 33.60           C  
ATOM   2060  C   ALA B  15      49.589  21.300  54.884  1.00 32.12           C  
ATOM   2061  O   ALA B  15      50.207  21.584  55.923  1.00 30.61           O  
ATOM   2062  CB  ALA B  15      47.246  22.070  55.332  1.00 30.90           C  
ATOM   2063  N   ILE B  16      50.152  21.311  53.676  1.00 30.05           N  
ATOM   2064  CA  ILE B  16      51.555  21.671  53.512  1.00 27.24           C  
ATOM   2065  C   ILE B  16      51.741  23.150  53.760  1.00 26.92           C  
ATOM   2066  O   ILE B  16      50.980  23.972  53.243  1.00 28.52           O  
ATOM   2067  CB  ILE B  16      52.079  21.345  52.089  1.00 27.65           C  
ATOM   2068  CG1 ILE B  16      51.937  19.849  51.801  1.00 29.79           C  
ATOM   2069  CG2 ILE B  16      53.531  21.773  51.939  1.00 25.80           C  
ATOM   2070  CD1 ILE B  16      52.540  18.946  52.865  1.00 31.37           C  
ATOM   2071  N   PRO B  17      52.696  23.507  54.637  1.00 25.13           N  
ATOM   2072  CA  PRO B  17      52.966  24.915  54.936  1.00 22.29           C  
ATOM   2073  C   PRO B  17      53.909  25.511  53.885  1.00 20.92           C  
ATOM   2074  O   PRO B  17      55.085  25.167  53.808  1.00 21.23           O  
ATOM   2075  CB  PRO B  17      53.598  24.843  56.324  1.00 22.60           C  
ATOM   2076  CG  PRO B  17      54.287  23.524  56.318  1.00 23.87           C  
ATOM   2077  CD  PRO B  17      53.351  22.614  55.610  1.00 23.88           C  
ATOM   2078  N   GLY B  18      53.361  26.355  53.022  1.00 20.88           N  
ATOM   2079  CA  GLY B  18      54.172  26.958  51.989  1.00 22.53           C  
ATOM   2080  C   GLY B  18      54.399  26.039  50.794  1.00 24.13           C  
ATOM   2081  O   GLY B  18      54.013  24.854  50.806  1.00 24.20           O  
ATOM   2082  N   PRO B  19      55.127  26.538  49.780  1.00 23.89           N  
ATOM   2083  CA  PRO B  19      55.445  25.824  48.540  1.00 22.78           C  
ATOM   2084  C   PRO B  19      56.434  24.673  48.609  1.00 23.11           C  
ATOM   2085  O   PRO B  19      57.455  24.758  49.288  1.00 22.19           O  
ATOM   2086  CB  PRO B  19      56.009  26.938  47.663  1.00 22.61           C  
ATOM   2087  CG  PRO B  19      56.787  27.747  48.658  1.00 20.43           C  
ATOM   2088  CD  PRO B  19      55.806  27.850  49.811  1.00 21.24           C  
ATOM   2089  N   LEU B  20      56.124  23.604  47.877  1.00 21.65           N  
ATOM   2090  CA  LEU B  20      57.030  22.466  47.770  1.00 21.93           C  
ATOM   2091  C   LEU B  20      58.087  22.929  46.755  1.00 22.90           C  
ATOM   2092  O   LEU B  20      57.807  23.796  45.918  1.00 22.22           O  
ATOM   2093  CB  LEU B  20      56.308  21.251  47.199  1.00 19.76           C  
ATOM   2094  CG  LEU B  20      55.210  20.638  48.044  1.00 20.45           C  
ATOM   2095  CD1 LEU B  20      54.501  19.572  47.251  1.00 19.82           C  
ATOM   2096  CD2 LEU B  20      55.809  20.068  49.301  1.00 19.09           C  
ATOM   2097  N   GLY B  21      59.294  22.378  46.833  1.00 23.07           N  
ATOM   2098  CA  GLY B  21      60.332  22.787  45.906  1.00 22.14           C  
ATOM   2099  C   GLY B  21      61.132  23.993  46.368  1.00 22.94           C  
ATOM   2100  O   GLY B  21      60.853  24.560  47.422  1.00 23.12           O  
ATOM   2101  N   PRO B  22      62.072  24.465  45.531  1.00 24.35           N  
ATOM   2102  CA  PRO B  22      63.013  25.593  45.683  1.00 24.30           C  
ATOM   2103  C   PRO B  22      62.442  26.952  46.071  1.00 25.20           C  
ATOM   2104  O   PRO B  22      63.168  27.786  46.611  1.00 26.46           O  
ATOM   2105  CB  PRO B  22      63.673  25.679  44.308  1.00 24.92           C  
ATOM   2106  CG  PRO B  22      63.505  24.313  43.747  1.00 26.33           C  
ATOM   2107  CD  PRO B  22      62.110  23.956  44.151  1.00 24.36           C  
ATOM   2108  N   GLN B  23      61.188  27.216  45.704  1.00 25.23           N  
ATOM   2109  CA  GLN B  23      60.545  28.478  46.048  1.00 26.61           C  
ATOM   2110  C   GLN B  23      60.423  28.651  47.564  1.00 25.14           C  
ATOM   2111  O   GLN B  23      60.287  29.766  48.060  1.00 22.13           O  
ATOM   2112  CB  GLN B  23      59.168  28.570  45.403  1.00 29.76           C  
ATOM   2113  CG  GLN B  23      59.208  28.967  43.943  1.00 39.17           C  
ATOM   2114  CD  GLN B  23      59.631  30.408  43.755  1.00 44.67           C  
ATOM   2115  OE1 GLN B  23      60.721  30.692  43.251  1.00 49.00           O  
ATOM   2116  NE2 GLN B  23      58.772  31.332  44.169  1.00 45.90           N  
ATOM   2117  N   SER B  24      60.480  27.536  48.289  1.00 23.98           N  
ATOM   2118  CA  SER B  24      60.397  27.558  49.739  1.00 23.56           C  
ATOM   2119  C   SER B  24      61.624  28.286  50.333  1.00 23.87           C  
ATOM   2120  O   SER B  24      61.596  28.735  51.475  1.00 22.90           O  
ATOM   2121  CB  SER B  24      60.280  26.134  50.276  1.00 23.51           C  
ATOM   2122  OG  SER B  24      60.065  26.130  51.676  1.00 26.88           O  
ATOM   2123  N   ALA B  25      62.677  28.446  49.533  1.00 21.23           N  
ATOM   2124  CA  ALA B  25      63.882  29.127  49.974  1.00 18.44           C  
ATOM   2125  C   ALA B  25      63.875  30.588  49.581  1.00 18.45           C  
ATOM   2126  O   ALA B  25      64.739  31.353  50.000  1.00 19.36           O  
ATOM   2127  CB  ALA B  25      65.096  28.455  49.391  1.00 17.10           C  
ATOM   2128  N   SER B  26      62.884  30.980  48.801  1.00 18.99           N  
ATOM   2129  CA  SER B  26      62.775  32.347  48.316  1.00 20.46           C  
ATOM   2130  C   SER B  26      62.451  33.425  49.349  1.00 21.28           C  
ATOM   2131  O   SER B  26      61.542  33.260  50.151  1.00 21.64           O  
ATOM   2132  CB  SER B  26      61.710  32.399  47.226  1.00 21.27           C  
ATOM   2133  OG  SER B  26      61.543  33.719  46.740  1.00 22.99           O  
ATOM   2134  N   LEU B  27      63.165  34.555  49.292  1.00 21.17           N  
ATOM   2135  CA  LEU B  27      62.888  35.671  50.193  1.00 20.34           C  
ATOM   2136  C   LEU B  27      62.349  36.851  49.390  1.00 22.86           C  
ATOM   2137  O   LEU B  27      62.358  37.990  49.840  1.00 22.92           O  
ATOM   2138  CB  LEU B  27      64.135  36.064  50.978  1.00 18.27           C  
ATOM   2139  CG  LEU B  27      64.654  34.955  51.894  1.00 18.90           C  
ATOM   2140  CD1 LEU B  27      65.907  35.424  52.586  1.00 16.03           C  
ATOM   2141  CD2 LEU B  27      63.590  34.599  52.916  1.00 17.73           C  
ATOM   2142  N   GLU B  28      61.827  36.544  48.208  1.00 26.35           N  
ATOM   2143  CA  GLU B  28      61.274  37.537  47.294  1.00 28.62           C  
ATOM   2144  C   GLU B  28      60.081  38.280  47.886  1.00 27.55           C  
ATOM   2145  O   GLU B  28      59.119  37.653  48.351  1.00 27.40           O  
ATOM   2146  CB  GLU B  28      60.851  36.844  45.997  1.00 33.12           C  
ATOM   2147  CG  GLU B  28      60.631  37.790  44.850  1.00 43.27           C  
ATOM   2148  CD  GLU B  28      61.906  38.514  44.475  1.00 49.61           C  
ATOM   2149  OE1 GLU B  28      62.947  37.824  44.328  1.00 53.28           O  
ATOM   2150  OE2 GLU B  28      61.869  39.764  44.347  1.00 53.77           O  
ATOM   2151  N   GLY B  29      60.146  39.614  47.874  1.00 26.91           N  
ATOM   2152  CA  GLY B  29      59.054  40.418  48.405  1.00 26.83           C  
ATOM   2153  C   GLY B  29      58.979  40.551  49.925  1.00 26.58           C  
ATOM   2154  O   GLY B  29      57.988  41.044  50.472  1.00 26.61           O  
ATOM   2155  N   LYS B  30      60.005  40.069  50.614  1.00 24.70           N  
ATOM   2156  CA  LYS B  30      60.048  40.160  52.062  1.00 23.01           C  
ATOM   2157  C   LYS B  30      60.725  41.472  52.432  1.00 22.36           C  
ATOM   2158  O   LYS B  30      61.454  42.054  51.627  1.00 24.32           O  
ATOM   2159  CB  LYS B  30      60.858  39.001  52.645  1.00 21.80           C  
ATOM   2160  CG  LYS B  30      60.268  37.636  52.398  1.00 21.39           C  
ATOM   2161  CD  LYS B  30      58.900  37.566  52.986  1.00 23.86           C  
ATOM   2162  CE  LYS B  30      58.299  36.194  52.813  1.00 27.87           C  
ATOM   2163  NZ  LYS B  30      56.883  36.192  53.294  1.00 30.40           N  
ATOM   2164  N   VAL B  31      60.451  41.949  53.637  1.00 19.76           N  
ATOM   2165  CA  VAL B  31      61.068  43.162  54.139  1.00 17.94           C  
ATOM   2166  C   VAL B  31      61.798  42.745  55.403  1.00 17.76           C  
ATOM   2167  O   VAL B  31      61.193  42.168  56.307  1.00 17.97           O  
ATOM   2168  CB  VAL B  31      60.033  44.252  54.468  1.00 18.09           C  
ATOM   2169  CG1 VAL B  31      60.734  45.478  55.037  1.00 13.63           C  
ATOM   2170  CG2 VAL B  31      59.241  44.611  53.216  1.00 16.55           C  
ATOM   2171  N   ALA B  32      63.099  43.029  55.445  1.00 17.84           N  
ATOM   2172  CA  ALA B  32      63.967  42.685  56.564  1.00 17.16           C  
ATOM   2173  C   ALA B  32      64.597  43.915  57.173  1.00 19.14           C  
ATOM   2174  O   ALA B  32      64.829  44.903  56.470  1.00 19.21           O  
ATOM   2175  CB  ALA B  32      65.074  41.759  56.094  1.00 14.65           C  
ATOM   2176  N   LEU B  33      64.826  43.864  58.489  1.00 18.39           N  
ATOM   2177  CA  LEU B  33      65.492  44.937  59.220  1.00 16.25           C  
ATOM   2178  C   LEU B  33      66.644  44.234  59.878  1.00 15.86           C  
ATOM   2179  O   LEU B  33      66.461  43.153  60.441  1.00 16.28           O  
ATOM   2180  CB  LEU B  33      64.585  45.567  60.287  1.00 16.83           C  
ATOM   2181  CG  LEU B  33      65.225  46.634  61.191  1.00 16.45           C  
ATOM   2182  CD1 LEU B  33      64.181  47.563  61.755  1.00 19.67           C  
ATOM   2183  CD2 LEU B  33      65.968  45.984  62.316  1.00 17.93           C  
ATOM   2184  N   VAL B  34      67.841  44.803  59.744  1.00 15.49           N  
ATOM   2185  CA  VAL B  34      69.055  44.244  60.331  1.00 13.14           C  
ATOM   2186  C   VAL B  34      69.721  45.321  61.175  1.00 16.00           C  
ATOM   2187  O   VAL B  34      69.972  46.423  60.680  1.00 16.14           O  
ATOM   2188  CB  VAL B  34      70.065  43.813  59.247  1.00 10.66           C  
ATOM   2189  CG1 VAL B  34      71.301  43.252  59.911  1.00  8.10           C  
ATOM   2190  CG2 VAL B  34      69.432  42.795  58.280  1.00  8.38           C  
ATOM   2191  N   THR B  35      70.000  45.025  62.444  1.00 15.93           N  
ATOM   2192  CA  THR B  35      70.643  46.012  63.312  1.00 14.63           C  
ATOM   2193  C   THR B  35      72.150  45.912  63.168  1.00 15.85           C  
ATOM   2194  O   THR B  35      72.690  44.818  63.045  1.00 18.50           O  
ATOM   2195  CB  THR B  35      70.239  45.851  64.803  1.00 15.80           C  
ATOM   2196  OG1 THR B  35      70.649  44.570  65.282  1.00 19.53           O  
ATOM   2197  CG2 THR B  35      68.751  45.993  64.985  1.00 12.78           C  
ATOM   2198  N   GLY B  36      72.828  47.059  63.148  1.00 15.98           N  
ATOM   2199  CA  GLY B  36      74.275  47.073  62.991  1.00 13.88           C  
ATOM   2200  C   GLY B  36      74.700  46.573  61.620  1.00 16.34           C  
ATOM   2201  O   GLY B  36      75.702  45.884  61.492  1.00 14.73           O  
ATOM   2202  N   ALA B  37      73.952  46.962  60.587  1.00 17.24           N  
ATOM   2203  CA  ALA B  37      74.218  46.530  59.210  1.00 19.78           C  
ATOM   2204  C   ALA B  37      75.152  47.401  58.350  1.00 21.55           C  
ATOM   2205  O   ALA B  37      75.252  47.187  57.140  1.00 21.40           O  
ATOM   2206  CB  ALA B  37      72.901  46.332  58.483  1.00 17.59           C  
ATOM   2207  N   GLY B  38      75.802  48.387  58.955  1.00 21.55           N  
ATOM   2208  CA  GLY B  38      76.698  49.233  58.192  1.00 22.36           C  
ATOM   2209  C   GLY B  38      78.050  48.585  57.972  1.00 24.37           C  
ATOM   2210  O   GLY B  38      78.788  48.959  57.042  1.00 24.19           O  
ATOM   2211  N   ARG B  39      78.379  47.609  58.820  1.00 22.44           N  
ATOM   2212  CA  ARG B  39      79.661  46.919  58.749  1.00 22.20           C  
ATOM   2213  C   ARG B  39      79.521  45.477  59.165  1.00 22.98           C  
ATOM   2214  O   ARG B  39      78.457  45.058  59.616  1.00 23.46           O  
ATOM   2215  CB  ARG B  39      80.663  47.540  59.715  1.00 25.44           C  
ATOM   2216  CG  ARG B  39      80.803  49.027  59.640  1.00 33.90           C  
ATOM   2217  CD  ARG B  39      81.789  49.519  60.675  1.00 36.90           C  
ATOM   2218  NE  ARG B  39      81.292  49.429  62.048  1.00 36.66           N  
ATOM   2219  CZ  ARG B  39      81.921  48.795  63.034  1.00 35.78           C  
ATOM   2220  NH1 ARG B  39      83.073  48.168  62.811  1.00 34.13           N  
ATOM   2221  NH2 ARG B  39      81.437  48.859  64.266  1.00 37.55           N  
ATOM   2222  N   GLY B  40      80.639  44.754  59.040  1.00 23.03           N  
ATOM   2223  CA  GLY B  40      80.759  43.349  59.405  1.00 21.07           C  
ATOM   2224  C   GLY B  40      79.679  42.366  58.998  1.00 20.67           C  
ATOM   2225  O   GLY B  40      79.118  42.424  57.900  1.00 20.86           O  
ATOM   2226  N   ILE B  41      79.393  41.443  59.907  1.00 20.80           N  
ATOM   2227  CA  ILE B  41      78.393  40.421  59.674  1.00 20.24           C  
ATOM   2228  C   ILE B  41      77.036  41.025  59.320  1.00 19.26           C  
ATOM   2229  O   ILE B  41      76.375  40.553  58.392  1.00 19.29           O  
ATOM   2230  CB  ILE B  41      78.288  39.457  60.881  1.00 20.30           C  
ATOM   2231  CG1 ILE B  41      79.672  38.889  61.219  1.00 20.72           C  
ATOM   2232  CG2 ILE B  41      77.369  38.308  60.546  1.00 21.00           C  
ATOM   2233  CD1 ILE B  41      79.685  37.951  62.418  1.00 20.69           C  
ATOM   2234  N   GLY B  42      76.640  42.083  60.026  1.00 17.16           N  
ATOM   2235  CA  GLY B  42      75.374  42.738  59.742  1.00 13.59           C  
ATOM   2236  C   GLY B  42      75.295  43.264  58.317  1.00 13.73           C  
ATOM   2237  O   GLY B  42      74.247  43.168  57.686  1.00 14.28           O  
ATOM   2238  N   ARG B  43      76.382  43.845  57.815  1.00 15.32           N  
ATOM   2239  CA  ARG B  43      76.392  44.345  56.444  1.00 17.56           C  
ATOM   2240  C   ARG B  43      76.135  43.198  55.443  1.00 16.57           C  
ATOM   2241  O   ARG B  43      75.303  43.322  54.547  1.00 16.91           O  
ATOM   2242  CB  ARG B  43      77.725  45.036  56.124  1.00 21.06           C  
ATOM   2243  CG  ARG B  43      77.833  45.471  54.666  1.00 29.18           C  
ATOM   2244  CD  ARG B  43      79.022  46.365  54.288  1.00 35.15           C  
ATOM   2245  NE  ARG B  43      78.927  46.676  52.850  1.00 47.70           N  
ATOM   2246  CZ  ARG B  43      79.080  47.882  52.279  1.00 51.96           C  
ATOM   2247  NH1 ARG B  43      79.365  48.969  52.998  1.00 52.55           N  
ATOM   2248  NH2 ARG B  43      78.866  48.014  50.971  1.00 51.98           N  
ATOM   2249  N   GLU B  44      76.810  42.065  55.636  1.00 15.38           N  
ATOM   2250  CA  GLU B  44      76.643  40.930  54.739  1.00 14.03           C  
ATOM   2251  C   GLU B  44      75.278  40.276  54.836  1.00 15.94           C  
ATOM   2252  O   GLU B  44      74.779  39.733  53.845  1.00 15.77           O  
ATOM   2253  CB  GLU B  44      77.750  39.910  54.935  1.00 15.83           C  
ATOM   2254  CG  GLU B  44      77.882  38.939  53.772  1.00 18.30           C  
ATOM   2255  CD  GLU B  44      78.165  39.632  52.450  1.00 18.87           C  
ATOM   2256  OE1 GLU B  44      77.737  39.125  51.406  1.00 23.02           O  
ATOM   2257  OE2 GLU B  44      78.828  40.682  52.449  1.00 24.91           O  
ATOM   2258  N   MET B  45      74.667  40.309  56.021  1.00 15.68           N  
ATOM   2259  CA  MET B  45      73.320  39.762  56.180  1.00 16.16           C  
ATOM   2260  C   MET B  45      72.405  40.589  55.296  1.00 16.36           C  
ATOM   2261  O   MET B  45      71.575  40.043  54.573  1.00 16.46           O  
ATOM   2262  CB  MET B  45      72.802  39.882  57.620  1.00 17.24           C  
ATOM   2263  CG  MET B  45      73.264  38.815  58.578  1.00 18.00           C  
ATOM   2264  SD  MET B  45      72.419  39.020  60.120  1.00 18.17           S  
ATOM   2265  CE  MET B  45      73.653  38.493  61.185  1.00 15.10           C  
ATOM   2266  N   ALA B  46      72.538  41.912  55.393  1.00 14.90           N  
ATOM   2267  CA  ALA B  46      71.733  42.836  54.592  1.00 14.27           C  
ATOM   2268  C   ALA B  46      71.948  42.630  53.077  1.00 14.83           C  
ATOM   2269  O   ALA B  46      70.978  42.593  52.313  1.00 16.37           O  
ATOM   2270  CB  ALA B  46      72.065  44.273  54.987  1.00 14.68           C  
ATOM   2271  N   MET B  47      73.209  42.534  52.648  1.00 14.98           N  
ATOM   2272  CA  MET B  47      73.544  42.325  51.228  1.00 16.33           C  
ATOM   2273  C   MET B  47      72.925  41.036  50.701  1.00 16.63           C  
ATOM   2274  O   MET B  47      72.274  41.025  49.656  1.00 16.92           O  
ATOM   2275  CB  MET B  47      75.055  42.196  51.020  1.00 15.49           C  
ATOM   2276  CG  MET B  47      75.892  43.417  51.365  1.00 22.65           C  
ATOM   2277  SD  MET B  47      75.536  44.833  50.345  1.00 23.04           S  
ATOM   2278  CE  MET B  47      75.357  44.120  48.753  1.00 23.60           C  
ATOM   2279  N   GLU B  48      73.164  39.940  51.425  1.00 16.14           N  
ATOM   2280  CA  GLU B  48      72.644  38.631  51.042  1.00 15.51           C  
ATOM   2281  C   GLU B  48      71.119  38.573  51.068  1.00 15.93           C  
ATOM   2282  O   GLU B  48      70.512  38.027  50.153  1.00 16.35           O  
ATOM   2283  CB  GLU B  48      73.287  37.526  51.897  1.00 16.04           C  
ATOM   2284  CG  GLU B  48      72.986  36.092  51.441  1.00 15.40           C  
ATOM   2285  CD  GLU B  48      73.439  35.785  49.998  1.00 20.20           C  
ATOM   2286  OE1 GLU B  48      74.308  36.491  49.446  1.00 16.31           O  
ATOM   2287  OE2 GLU B  48      72.931  34.800  49.420  1.00 19.91           O  
ATOM   2288  N   LEU B  49      70.484  39.144  52.092  1.00 16.04           N  
ATOM   2289  CA  LEU B  49      69.023  39.158  52.146  1.00 15.71           C  
ATOM   2290  C   LEU B  49      68.504  39.916  50.911  1.00 17.25           C  
ATOM   2291  O   LEU B  49      67.511  39.511  50.278  1.00 15.88           O  
ATOM   2292  CB  LEU B  49      68.531  39.852  53.428  1.00 15.20           C  
ATOM   2293  CG  LEU B  49      68.635  39.051  54.724  1.00 14.69           C  
ATOM   2294  CD1 LEU B  49      68.573  39.961  55.922  1.00 15.18           C  
ATOM   2295  CD2 LEU B  49      67.500  38.058  54.756  1.00 13.96           C  
ATOM   2296  N   GLY B  50      69.201  41.005  50.574  1.00 17.68           N  
ATOM   2297  CA  GLY B  50      68.837  41.818  49.427  1.00 15.76           C  
ATOM   2298  C   GLY B  50      68.950  41.036  48.140  1.00 13.09           C  
ATOM   2299  O   GLY B  50      68.043  41.057  47.314  1.00 16.22           O  
ATOM   2300  N   ARG B  51      70.057  40.323  47.985  1.00 15.67           N  
ATOM   2301  CA  ARG B  51      70.296  39.508  46.788  1.00 14.68           C  
ATOM   2302  C   ARG B  51      69.216  38.444  46.607  1.00 16.89           C  
ATOM   2303  O   ARG B  51      68.926  38.038  45.492  1.00 19.84           O  
ATOM   2304  CB  ARG B  51      71.658  38.827  46.864  1.00 12.35           C  
ATOM   2305  CG  ARG B  51      72.858  39.691  46.608  1.00 11.10           C  
ATOM   2306  CD  ARG B  51      74.085  38.876  46.931  1.00 13.44           C  
ATOM   2307  NE  ARG B  51      75.240  39.711  47.186  1.00 17.02           N  
ATOM   2308  CZ  ARG B  51      75.998  39.644  48.270  1.00 19.97           C  
ATOM   2309  NH1 ARG B  51      75.733  38.767  49.223  1.00 20.67           N  
ATOM   2310  NH2 ARG B  51      77.021  40.474  48.412  1.00 20.50           N  
ATOM   2311  N   ARG B  52      68.619  38.003  47.711  1.00 18.41           N  
ATOM   2312  CA  ARG B  52      67.569  36.993  47.671  1.00 14.16           C  
ATOM   2313  C   ARG B  52      66.189  37.591  47.543  1.00 14.02           C  
ATOM   2314  O   ARG B  52      65.205  36.892  47.733  1.00 15.99           O  
ATOM   2315  CB  ARG B  52      67.647  36.059  48.888  1.00 13.74           C  
ATOM   2316  CG  ARG B  52      68.990  35.379  49.000  1.00 12.94           C  
ATOM   2317  CD  ARG B  52      68.980  34.104  49.784  1.00 11.02           C  
ATOM   2318  NE  ARG B  52      70.329  33.563  49.838  1.00 13.46           N  
ATOM   2319  CZ  ARG B  52      70.658  32.313  50.154  1.00 13.40           C  
ATOM   2320  NH1 ARG B  52      69.743  31.420  50.469  1.00 15.17           N  
ATOM   2321  NH2 ARG B  52      71.916  31.938  50.103  1.00 12.95           N  
ATOM   2322  N   GLY B  53      66.119  38.886  47.234  1.00 14.19           N  
ATOM   2323  CA  GLY B  53      64.829  39.531  47.030  1.00 13.59           C  
ATOM   2324  C   GLY B  53      64.185  40.361  48.127  1.00 15.53           C  
ATOM   2325  O   GLY B  53      63.051  40.810  47.950  1.00 17.68           O  
ATOM   2326  N   CYS B  54      64.873  40.569  49.244  1.00 17.49           N  
ATOM   2327  CA  CYS B  54      64.330  41.361  50.346  1.00 17.98           C  
ATOM   2328  C   CYS B  54      64.618  42.839  50.225  1.00 17.34           C  
ATOM   2329  O   CYS B  54      65.683  43.221  49.737  1.00 16.13           O  
ATOM   2330  CB  CYS B  54      64.986  40.984  51.682  1.00 20.80           C  
ATOM   2331  SG  CYS B  54      64.556  39.431  52.457  1.00 29.15           S  
ATOM   2332  N   LYS B  55      63.689  43.650  50.723  1.00 16.51           N  
ATOM   2333  CA  LYS B  55      63.887  45.092  50.831  1.00 16.10           C  
ATOM   2334  C   LYS B  55      64.540  45.106  52.210  1.00 17.99           C  
ATOM   2335  O   LYS B  55      64.113  44.376  53.097  1.00 19.29           O  
ATOM   2336  CB  LYS B  55      62.560  45.827  50.847  1.00 14.73           C  
ATOM   2337  CG  LYS B  55      61.929  45.885  49.460  1.00 16.89           C  
ATOM   2338  CD  LYS B  55      60.630  46.674  49.451  1.00 17.28           C  
ATOM   2339  CE  LYS B  55      60.006  46.677  48.080  1.00 17.58           C  
ATOM   2340  NZ  LYS B  55      58.748  47.449  48.105  1.00 19.54           N  
ATOM   2341  N   VAL B  56      65.603  45.873  52.391  1.00 17.46           N  
ATOM   2342  CA  VAL B  56      66.303  45.847  53.661  1.00 15.65           C  
ATOM   2343  C   VAL B  56      66.437  47.190  54.368  1.00 17.73           C  
ATOM   2344  O   VAL B  56      66.843  48.174  53.750  1.00 17.27           O  
ATOM   2345  CB  VAL B  56      67.745  45.297  53.461  1.00 15.90           C  
ATOM   2346  CG1 VAL B  56      68.410  45.040  54.790  1.00 14.78           C  
ATOM   2347  CG2 VAL B  56      67.744  44.030  52.618  1.00 14.71           C  
ATOM   2348  N   ILE B  57      66.104  47.225  55.662  1.00 15.90           N  
ATOM   2349  CA  ILE B  57      66.278  48.432  56.455  1.00 15.42           C  
ATOM   2350  C   ILE B  57      67.588  48.212  57.171  1.00 15.60           C  
ATOM   2351  O   ILE B  57      67.721  47.289  57.969  1.00 18.01           O  
ATOM   2352  CB  ILE B  57      65.163  48.672  57.480  1.00 16.89           C  
ATOM   2353  CG1 ILE B  57      63.980  49.346  56.812  1.00 19.71           C  
ATOM   2354  CG2 ILE B  57      65.639  49.635  58.567  1.00 17.03           C  
ATOM   2355  CD1 ILE B  57      62.890  48.423  56.450  1.00 21.21           C  
ATOM   2356  N   VAL B  58      68.569  49.031  56.820  1.00 14.74           N  
ATOM   2357  CA  VAL B  58      69.919  48.991  57.352  1.00 14.05           C  
ATOM   2358  C   VAL B  58      70.071  49.915  58.567  1.00 19.29           C  
ATOM   2359  O   VAL B  58      70.203  51.132  58.420  1.00 19.18           O  
ATOM   2360  CB  VAL B  58      70.929  49.445  56.239  1.00 13.45           C  
ATOM   2361  CG1 VAL B  58      72.372  49.468  56.741  1.00 10.00           C  
ATOM   2362  CG2 VAL B  58      70.806  48.554  55.033  1.00 13.41           C  
ATOM   2363  N   ASN B  59      70.077  49.337  59.765  1.00 19.06           N  
ATOM   2364  CA  ASN B  59      70.253  50.124  60.972  1.00 18.80           C  
ATOM   2365  C   ASN B  59      71.729  50.338  61.257  1.00 19.13           C  
ATOM   2366  O   ASN B  59      72.564  49.498  60.935  1.00 19.74           O  
ATOM   2367  CB  ASN B  59      69.586  49.437  62.174  1.00 18.79           C  
ATOM   2368  CG  ASN B  59      70.163  49.897  63.510  1.00 19.38           C  
ATOM   2369  OD1 ASN B  59      71.113  49.301  64.029  1.00 17.14           O  
ATOM   2370  ND2 ASN B  59      69.614  50.973  64.054  1.00 17.22           N  
ATOM   2371  N   TYR B  60      72.042  51.472  61.870  1.00 19.22           N  
ATOM   2372  CA  TYR B  60      73.410  51.798  62.254  1.00 20.31           C  
ATOM   2373  C   TYR B  60      73.279  52.751  63.432  1.00 20.57           C  
ATOM   2374  O   TYR B  60      72.212  53.331  63.656  1.00 21.69           O  
ATOM   2375  CB  TYR B  60      74.180  52.473  61.096  1.00 21.20           C  
ATOM   2376  CG  TYR B  60      73.666  53.853  60.743  1.00 22.43           C  
ATOM   2377  CD1 TYR B  60      72.513  54.016  59.968  1.00 22.69           C  
ATOM   2378  CD2 TYR B  60      74.301  54.997  61.222  1.00 22.29           C  
ATOM   2379  CE1 TYR B  60      72.004  55.285  59.684  1.00 22.43           C  
ATOM   2380  CE2 TYR B  60      73.798  56.267  60.946  1.00 21.71           C  
ATOM   2381  CZ  TYR B  60      72.654  56.398  60.180  1.00 22.30           C  
ATOM   2382  OH  TYR B  60      72.145  57.645  59.924  1.00 24.79           O  
ATOM   2383  N   ALA B  61      74.343  52.870  64.213  1.00 22.74           N  
ATOM   2384  CA  ALA B  61      74.347  53.769  65.365  1.00 25.55           C  
ATOM   2385  C   ALA B  61      75.316  54.899  65.076  1.00 27.93           C  
ATOM   2386  O   ALA B  61      75.037  56.056  65.376  1.00 28.14           O  
ATOM   2387  CB  ALA B  61      74.780  53.032  66.636  1.00 19.37           C  
ATOM   2388  N   ASN B  62      76.437  54.555  64.451  1.00 30.88           N  
ATOM   2389  CA  ASN B  62      77.487  55.520  64.146  1.00 36.64           C  
ATOM   2390  C   ASN B  62      77.838  55.594  62.652  1.00 38.03           C  
ATOM   2391  O   ASN B  62      77.684  56.643  62.024  1.00 37.79           O  
ATOM   2392  CB  ASN B  62      78.747  55.186  64.967  1.00 38.06           C  
ATOM   2393  CG  ASN B  62      78.453  55.028  66.465  1.00 42.24           C  
ATOM   2394  OD1 ASN B  62      78.439  53.905  66.999  1.00 41.12           O  
ATOM   2395  ND2 ASN B  62      78.204  56.154  67.144  1.00 43.61           N  
ATOM   2396  N   SER B  63      78.277  54.462  62.100  1.00 38.58           N  
ATOM   2397  CA  SER B  63      78.693  54.339  60.699  1.00 39.82           C  
ATOM   2398  C   SER B  63      77.665  54.809  59.655  1.00 40.20           C  
ATOM   2399  O   SER B  63      77.139  54.003  58.885  1.00 41.94           O  
ATOM   2400  CB  SER B  63      79.101  52.883  60.434  1.00 38.43           C  
ATOM   2401  OG  SER B  63      80.192  52.506  61.260  1.00 33.91           O  
ATOM   2402  N   THR B  64      77.471  56.121  59.560  1.00 38.58           N  
ATOM   2403  CA  THR B  64      76.491  56.700  58.643  1.00 39.62           C  
ATOM   2404  C   THR B  64      76.830  56.580  57.169  1.00 40.27           C  
ATOM   2405  O   THR B  64      75.966  56.285  56.342  1.00 40.08           O  
ATOM   2406  CB  THR B  64      76.275  58.185  58.940  1.00 41.06           C  
ATOM   2407  OG1 THR B  64      76.178  58.368  60.360  1.00 46.41           O  
ATOM   2408  CG2 THR B  64      74.998  58.700  58.268  1.00 37.34           C  
ATOM   2409  N   GLU B  65      78.075  56.877  56.836  1.00 40.63           N  
ATOM   2410  CA  GLU B  65      78.529  56.812  55.462  1.00 41.08           C  
ATOM   2411  C   GLU B  65      78.523  55.355  55.017  1.00 38.32           C  
ATOM   2412  O   GLU B  65      78.160  55.049  53.883  1.00 35.81           O  
ATOM   2413  CB  GLU B  65      79.936  57.400  55.361  1.00 46.43           C  
ATOM   2414  CG  GLU B  65      80.115  58.412  54.235  1.00 55.86           C  
ATOM   2415  CD  GLU B  65      81.082  57.931  53.149  1.00 61.77           C  
ATOM   2416  OE1 GLU B  65      82.313  57.894  53.418  1.00 62.32           O  
ATOM   2417  OE2 GLU B  65      80.605  57.594  52.030  1.00 63.88           O  
ATOM   2418  N   SER B  66      78.903  54.464  55.936  1.00 36.62           N  
ATOM   2419  CA  SER B  66      78.951  53.028  55.672  1.00 33.58           C  
ATOM   2420  C   SER B  66      77.552  52.503  55.410  1.00 30.36           C  
ATOM   2421  O   SER B  66      77.341  51.707  54.500  1.00 29.01           O  
ATOM   2422  CB  SER B  66      79.536  52.275  56.872  1.00 35.88           C  
ATOM   2423  OG  SER B  66      80.851  52.689  57.173  1.00 39.68           O  
ATOM   2424  N   ALA B  67      76.602  52.980  56.210  1.00 27.26           N  
ATOM   2425  CA  ALA B  67      75.211  52.577  56.106  1.00 25.81           C  
ATOM   2426  C   ALA B  67      74.614  52.953  54.759  1.00 25.31           C  
ATOM   2427  O   ALA B  67      73.923  52.149  54.128  1.00 24.09           O  
ATOM   2428  CB  ALA B  67      74.397  53.197  57.239  1.00 23.83           C  
ATOM   2429  N   GLU B  68      74.851  54.189  54.330  1.00 26.20           N  
ATOM   2430  CA  GLU B  68      74.329  54.642  53.037  1.00 26.56           C  
ATOM   2431  C   GLU B  68      75.022  53.855  51.920  1.00 24.16           C  
ATOM   2432  O   GLU B  68      74.411  53.584  50.897  1.00 24.85           O  
ATOM   2433  CB  GLU B  68      74.486  56.167  52.853  1.00 29.43           C  
ATOM   2434  CG  GLU B  68      73.430  57.037  53.583  1.00 32.94           C  
ATOM   2435  CD  GLU B  68      72.010  56.959  52.983  1.00 38.03           C  
ATOM   2436  OE1 GLU B  68      71.701  56.027  52.214  1.00 38.74           O  
ATOM   2437  OE2 GLU B  68      71.179  57.840  53.293  1.00 39.14           O  
ATOM   2438  N   GLU B  69      76.273  53.446  52.151  1.00 22.12           N  
ATOM   2439  CA  GLU B  69      77.007  52.640  51.187  1.00 22.95           C  
ATOM   2440  C   GLU B  69      76.401  51.252  51.056  1.00 20.76           C  
ATOM   2441  O   GLU B  69      76.373  50.695  49.968  1.00 19.71           O  
ATOM   2442  CB  GLU B  69      78.470  52.521  51.573  1.00 27.82           C  
ATOM   2443  CG  GLU B  69      79.282  53.744  51.189  1.00 37.91           C  
ATOM   2444  CD  GLU B  69      80.686  53.719  51.748  1.00 45.46           C  
ATOM   2445  OE1 GLU B  69      81.430  54.696  51.504  1.00 48.06           O  
ATOM   2446  OE2 GLU B  69      81.042  52.734  52.438  1.00 50.15           O  
ATOM   2447  N   VAL B  70      75.896  50.698  52.156  1.00 19.46           N  
ATOM   2448  CA  VAL B  70      75.283  49.371  52.099  1.00 17.69           C  
ATOM   2449  C   VAL B  70      73.959  49.487  51.379  1.00 16.53           C  
ATOM   2450  O   VAL B  70      73.624  48.661  50.518  1.00 18.61           O  
ATOM   2451  CB  VAL B  70      75.044  48.779  53.507  1.00 16.83           C  
ATOM   2452  CG1 VAL B  70      74.325  47.454  53.401  1.00 13.10           C  
ATOM   2453  CG2 VAL B  70      76.348  48.579  54.201  1.00 12.64           C  
ATOM   2454  N   VAL B  71      73.213  50.532  51.724  1.00 16.03           N  
ATOM   2455  CA  VAL B  71      71.920  50.791  51.115  1.00 14.48           C  
ATOM   2456  C   VAL B  71      72.051  50.923  49.580  1.00 17.43           C  
ATOM   2457  O   VAL B  71      71.275  50.321  48.839  1.00 16.22           O  
ATOM   2458  CB  VAL B  71      71.276  52.052  51.734  1.00 13.24           C  
ATOM   2459  CG1 VAL B  71      70.095  52.506  50.908  1.00 12.21           C  
ATOM   2460  CG2 VAL B  71      70.823  51.755  53.158  1.00 13.23           C  
ATOM   2461  N   ALA B  72      73.068  51.670  49.130  1.00 18.98           N  
ATOM   2462  CA  ALA B  72      73.364  51.897  47.705  1.00 17.88           C  
ATOM   2463  C   ALA B  72      73.770  50.597  46.991  1.00 18.35           C  
ATOM   2464  O   ALA B  72      73.335  50.340  45.874  1.00 19.50           O  
ATOM   2465  CB  ALA B  72      74.456  52.932  47.566  1.00 14.51           C  
ATOM   2466  N   ALA B  73      74.598  49.787  47.646  1.00 17.79           N  
ATOM   2467  CA  ALA B  73      75.032  48.504  47.101  1.00 16.09           C  
ATOM   2468  C   ALA B  73      73.846  47.557  46.976  1.00 16.81           C  
ATOM   2469  O   ALA B  73      73.731  46.829  45.989  1.00 18.42           O  
ATOM   2470  CB  ALA B  73      76.084  47.891  47.979  1.00 13.89           C  
ATOM   2471  N   ILE B  74      72.967  47.545  47.974  1.00 16.52           N  
ATOM   2472  CA  ILE B  74      71.791  46.682  47.910  1.00 16.80           C  
ATOM   2473  C   ILE B  74      70.893  47.091  46.720  1.00 18.70           C  
ATOM   2474  O   ILE B  74      70.357  46.235  46.019  1.00 17.31           O  
ATOM   2475  CB  ILE B  74      70.979  46.719  49.222  1.00 15.90           C  
ATOM   2476  CG1 ILE B  74      71.787  46.074  50.352  1.00 15.80           C  
ATOM   2477  CG2 ILE B  74      69.654  45.997  49.040  1.00 13.43           C  
ATOM   2478  CD1 ILE B  74      71.213  46.309  51.759  1.00 18.15           C  
ATOM   2479  N   LYS B  75      70.723  48.398  46.506  1.00 18.42           N  
ATOM   2480  CA  LYS B  75      69.904  48.893  45.406  1.00 17.16           C  
ATOM   2481  C   LYS B  75      70.535  48.478  44.086  1.00 16.72           C  
ATOM   2482  O   LYS B  75      69.836  48.057  43.155  1.00 16.74           O  
ATOM   2483  CB  LYS B  75      69.781  50.419  45.473  1.00 17.82           C  
ATOM   2484  CG  LYS B  75      68.685  50.941  46.409  1.00 17.98           C  
ATOM   2485  CD  LYS B  75      68.857  52.450  46.668  1.00 17.56           C  
ATOM   2486  CE  LYS B  75      67.707  53.048  47.470  1.00 14.55           C  
ATOM   2487  NZ  LYS B  75      68.067  54.429  47.881  1.00 15.37           N  
ATOM   2488  N   LYS B  76      71.857  48.565  44.019  1.00 16.72           N  
ATOM   2489  CA  LYS B  76      72.581  48.201  42.814  1.00 20.85           C  
ATOM   2490  C   LYS B  76      72.363  46.727  42.445  1.00 24.37           C  
ATOM   2491  O   LYS B  76      72.404  46.373  41.263  1.00 23.99           O  
ATOM   2492  CB  LYS B  76      74.064  48.510  42.971  1.00 21.49           C  
ATOM   2493  CG  LYS B  76      74.850  48.281  41.713  1.00 26.98           C  
ATOM   2494  CD  LYS B  76      76.262  48.797  41.833  1.00 34.36           C  
ATOM   2495  CE  LYS B  76      77.048  48.618  40.517  1.00 37.82           C  
ATOM   2496  NZ  LYS B  76      78.450  49.175  40.573  1.00 38.93           N  
ATOM   2497  N   ASN B  77      72.078  45.888  43.449  1.00 22.79           N  
ATOM   2498  CA  ASN B  77      71.825  44.468  43.232  1.00 20.82           C  
ATOM   2499  C   ASN B  77      70.384  44.166  42.861  1.00 20.75           C  
ATOM   2500  O   ASN B  77      70.017  43.008  42.683  1.00 24.24           O  
ATOM   2501  CB  ASN B  77      72.222  43.655  44.457  1.00 22.19           C  
ATOM   2502  CG  ASN B  77      73.716  43.396  44.527  1.00 22.72           C  
ATOM   2503  OD1 ASN B  77      74.397  43.369  43.504  1.00 25.19           O  
ATOM   2504  ND2 ASN B  77      74.226  43.168  45.725  1.00 20.21           N  
ATOM   2505  N   GLY B  78      69.536  45.184  42.829  1.00 18.32           N  
ATOM   2506  CA  GLY B  78      68.168  44.942  42.428  1.00 17.32           C  
ATOM   2507  C   GLY B  78      67.084  44.945  43.473  1.00 17.00           C  
ATOM   2508  O   GLY B  78      65.947  44.600  43.167  1.00 16.63           O  
ATOM   2509  N   SER B  79      67.408  45.362  44.689  1.00 17.91           N  
ATOM   2510  CA  SER B  79      66.419  45.396  45.760  1.00 18.38           C  
ATOM   2511  C   SER B  79      66.420  46.740  46.465  1.00 15.96           C  
ATOM   2512  O   SER B  79      67.457  47.380  46.558  1.00 17.40           O  
ATOM   2513  CB  SER B  79      66.741  44.310  46.783  1.00 18.71           C  
ATOM   2514  OG  SER B  79      65.650  43.436  46.887  1.00 31.12           O  
ATOM   2515  N   ASP B  80      65.274  47.150  46.990  1.00 14.12           N  
ATOM   2516  CA  ASP B  80      65.212  48.418  47.689  1.00 15.55           C  
ATOM   2517  C   ASP B  80      65.808  48.283  49.088  1.00 18.12           C  
ATOM   2518  O   ASP B  80      65.791  47.200  49.687  1.00 17.49           O  
ATOM   2519  CB  ASP B  80      63.765  48.919  47.763  1.00 15.21           C  
ATOM   2520  CG  ASP B  80      63.666  50.440  47.896  1.00 15.43           C  
ATOM   2521  OD1 ASP B  80      64.708  51.118  47.930  1.00 14.65           O  
ATOM   2522  OD2 ASP B  80      62.538  50.958  47.967  1.00 14.62           O  
ATOM   2523  N   ALA B  81      66.410  49.369  49.569  1.00 18.98           N  
ATOM   2524  CA  ALA B  81      67.006  49.423  50.897  1.00 17.48           C  
ATOM   2525  C   ALA B  81      66.925  50.856  51.398  1.00 20.12           C  
ATOM   2526  O   ALA B  81      66.747  51.785  50.606  1.00 20.07           O  
ATOM   2527  CB  ALA B  81      68.450  48.967  50.858  1.00 14.18           C  
ATOM   2528  N   ALA B  82      67.025  51.018  52.716  1.00 20.40           N  
ATOM   2529  CA  ALA B  82      67.003  52.334  53.376  1.00 21.57           C  
ATOM   2530  C   ALA B  82      67.695  52.173  54.722  1.00 22.88           C  
ATOM   2531  O   ALA B  82      67.777  51.064  55.237  1.00 21.15           O  
ATOM   2532  CB  ALA B  82      65.569  52.834  53.575  1.00 17.84           C  
ATOM   2533  N   CYS B  83      68.225  53.260  55.280  1.00 23.10           N  
ATOM   2534  CA  CYS B  83      68.876  53.156  56.576  1.00 23.92           C  
ATOM   2535  C   CYS B  83      68.122  53.927  57.649  1.00 24.62           C  
ATOM   2536  O   CYS B  83      67.358  54.846  57.363  1.00 24.24           O  
ATOM   2537  CB  CYS B  83      70.344  53.576  56.509  1.00 23.70           C  
ATOM   2538  SG  CYS B  83      70.600  55.274  55.982  1.00 28.85           S  
ATOM   2539  N   VAL B  84      68.279  53.474  58.888  1.00 25.55           N  
ATOM   2540  CA  VAL B  84      67.637  54.088  60.044  1.00 23.54           C  
ATOM   2541  C   VAL B  84      68.675  54.124  61.161  1.00 23.43           C  
ATOM   2542  O   VAL B  84      69.304  53.104  61.453  1.00 21.90           O  
ATOM   2543  CB  VAL B  84      66.416  53.251  60.504  1.00 22.07           C  
ATOM   2544  CG1 VAL B  84      65.803  53.838  61.777  1.00 22.97           C  
ATOM   2545  CG2 VAL B  84      65.389  53.174  59.399  1.00 21.39           C  
ATOM   2546  N   LYS B  85      68.901  55.303  61.738  1.00 22.76           N  
ATOM   2547  CA  LYS B  85      69.852  55.428  62.830  1.00 22.97           C  
ATOM   2548  C   LYS B  85      69.173  55.127  64.160  1.00 21.86           C  
ATOM   2549  O   LYS B  85      68.063  55.577  64.417  1.00 21.86           O  
ATOM   2550  CB  LYS B  85      70.445  56.831  62.878  1.00 24.70           C  
ATOM   2551  CG  LYS B  85      71.486  57.012  63.961  1.00 25.53           C  
ATOM   2552  CD  LYS B  85      72.200  58.326  63.792  1.00 29.05           C  
ATOM   2553  CE  LYS B  85      73.408  58.387  64.684  1.00 32.86           C  
ATOM   2554  NZ  LYS B  85      74.413  59.358  64.170  1.00 38.92           N  
ATOM   2555  N   ALA B  86      69.845  54.343  64.993  1.00 22.22           N  
ATOM   2556  CA  ALA B  86      69.313  53.987  66.297  1.00 20.98           C  
ATOM   2557  C   ALA B  86      70.358  53.241  67.072  1.00 21.42           C  
ATOM   2558  O   ALA B  86      71.083  52.419  66.530  1.00 22.59           O  
ATOM   2559  CB  ALA B  86      68.055  53.143  66.157  1.00 20.35           C  
ATOM   2560  N   ASN B  87      70.478  53.612  68.335  1.00 22.32           N  
ATOM   2561  CA  ASN B  87      71.410  53.004  69.262  1.00 22.97           C  
ATOM   2562  C   ASN B  87      70.588  52.017  70.107  1.00 23.46           C  
ATOM   2563  O   ASN B  87      69.646  52.417  70.794  1.00 23.20           O  
ATOM   2564  CB  ASN B  87      72.015  54.114  70.115  1.00 24.66           C  
ATOM   2565  CG  ASN B  87      72.867  53.597  71.252  1.00 30.29           C  
ATOM   2566  OD1 ASN B  87      73.226  52.426  71.305  1.00 30.31           O  
ATOM   2567  ND2 ASN B  87      73.185  54.485  72.188  1.00 34.09           N  
ATOM   2568  N   VAL B  88      70.919  50.728  70.020  1.00 23.64           N  
ATOM   2569  CA  VAL B  88      70.182  49.700  70.760  1.00 22.73           C  
ATOM   2570  C   VAL B  88      70.327  49.780  72.273  1.00 23.92           C  
ATOM   2571  O   VAL B  88      69.575  49.135  73.011  1.00 24.09           O  
ATOM   2572  CB  VAL B  88      70.492  48.257  70.268  1.00 24.28           C  
ATOM   2573  CG1 VAL B  88      70.116  48.112  68.811  1.00 20.07           C  
ATOM   2574  CG2 VAL B  88      71.950  47.904  70.479  1.00 22.77           C  
ATOM   2575  N   GLY B  89      71.285  50.582  72.730  1.00 23.51           N  
ATOM   2576  CA  GLY B  89      71.480  50.776  74.152  1.00 22.36           C  
ATOM   2577  C   GLY B  89      70.420  51.709  74.725  1.00 22.63           C  
ATOM   2578  O   GLY B  89      70.327  51.891  75.932  1.00 25.39           O  
ATOM   2579  N   VAL B  90      69.613  52.307  73.855  1.00 21.90           N  
ATOM   2580  CA  VAL B  90      68.563  53.231  74.273  1.00 20.99           C  
ATOM   2581  C   VAL B  90      67.258  52.666  73.750  1.00 20.91           C  
ATOM   2582  O   VAL B  90      67.007  52.721  72.548  1.00 23.33           O  
ATOM   2583  CB  VAL B  90      68.783  54.634  73.647  1.00 20.78           C  
ATOM   2584  CG1 VAL B  90      67.697  55.597  74.081  1.00 21.34           C  
ATOM   2585  CG2 VAL B  90      70.157  55.167  74.012  1.00 19.61           C  
ATOM   2586  N   VAL B  91      66.419  52.151  74.650  1.00 20.07           N  
ATOM   2587  CA  VAL B  91      65.145  51.541  74.261  1.00 21.20           C  
ATOM   2588  C   VAL B  91      64.207  52.484  73.517  1.00 23.74           C  
ATOM   2589  O   VAL B  91      63.330  52.052  72.758  1.00 23.67           O  
ATOM   2590  CB  VAL B  91      64.421  50.914  75.469  1.00 19.64           C  
ATOM   2591  CG1 VAL B  91      63.134  50.261  75.025  1.00 18.88           C  
ATOM   2592  CG2 VAL B  91      65.307  49.876  76.116  1.00 19.62           C  
ATOM   2593  N   GLU B  92      64.380  53.780  73.744  1.00 27.17           N  
ATOM   2594  CA  GLU B  92      63.564  54.784  73.061  1.00 28.84           C  
ATOM   2595  C   GLU B  92      63.941  54.788  71.565  1.00 25.35           C  
ATOM   2596  O   GLU B  92      63.080  54.916  70.702  1.00 24.99           O  
ATOM   2597  CB  GLU B  92      63.789  56.161  73.706  1.00 35.26           C  
ATOM   2598  CG  GLU B  92      63.335  56.265  75.180  1.00 43.75           C  
ATOM   2599  CD  GLU B  92      64.107  55.339  76.141  1.00 47.41           C  
ATOM   2600  OE1 GLU B  92      65.345  55.478  76.263  1.00 46.47           O  
ATOM   2601  OE2 GLU B  92      63.464  54.473  76.785  1.00 52.62           O  
ATOM   2602  N   ASP B  93      65.228  54.588  71.269  1.00 24.36           N  
ATOM   2603  CA  ASP B  93      65.719  54.526  69.889  1.00 24.09           C  
ATOM   2604  C   ASP B  93      65.158  53.325  69.163  1.00 23.23           C  
ATOM   2605  O   ASP B  93      64.767  53.423  67.999  1.00 20.03           O  
ATOM   2606  CB  ASP B  93      67.237  54.442  69.861  1.00 25.56           C  
ATOM   2607  CG  ASP B  93      67.889  55.792  69.922  1.00 29.09           C  
ATOM   2608  OD1 ASP B  93      69.055  55.900  69.493  1.00 28.58           O  
ATOM   2609  OD2 ASP B  93      67.241  56.752  70.400  1.00 31.32           O  
ATOM   2610  N   ILE B  94      65.138  52.191  69.864  1.00 21.10           N  
ATOM   2611  CA  ILE B  94      64.620  50.954  69.301  1.00 18.50           C  
ATOM   2612  C   ILE B  94      63.144  51.113  68.956  1.00 19.39           C  
ATOM   2613  O   ILE B  94      62.724  50.728  67.868  1.00 20.86           O  
ATOM   2614  CB  ILE B  94      64.805  49.760  70.263  1.00 15.57           C  
ATOM   2615  CG1 ILE B  94      66.281  49.585  70.593  1.00 10.57           C  
ATOM   2616  CG2 ILE B  94      64.228  48.497  69.638  1.00 12.50           C  
ATOM   2617  CD1 ILE B  94      66.551  48.696  71.763  1.00 14.75           C  
ATOM   2618  N   VAL B  95      62.359  51.698  69.860  1.00 19.36           N  
ATOM   2619  CA  VAL B  95      60.938  51.895  69.591  1.00 19.36           C  
ATOM   2620  C   VAL B  95      60.757  52.780  68.364  1.00 23.22           C  
ATOM   2621  O   VAL B  95      59.967  52.454  67.467  1.00 23.17           O  
ATOM   2622  CB  VAL B  95      60.223  52.537  70.777  1.00 19.96           C  
ATOM   2623  CG1 VAL B  95      58.828  52.941  70.371  1.00 17.59           C  
ATOM   2624  CG2 VAL B  95      60.161  51.552  71.955  1.00 19.56           C  
ATOM   2625  N   ARG B  96      61.525  53.873  68.314  1.00 24.98           N  
ATOM   2626  CA  ARG B  96      61.468  54.815  67.191  1.00 27.78           C  
ATOM   2627  C   ARG B  96      61.855  54.145  65.878  1.00 27.00           C  
ATOM   2628  O   ARG B  96      61.161  54.294  64.858  1.00 28.58           O  
ATOM   2629  CB  ARG B  96      62.387  56.012  67.434  1.00 30.51           C  
ATOM   2630  CG  ARG B  96      62.512  56.940  66.213  1.00 36.51           C  
ATOM   2631  CD  ARG B  96      63.423  58.140  66.462  1.00 39.93           C  
ATOM   2632  NE  ARG B  96      64.769  57.783  66.924  1.00 44.86           N  
ATOM   2633  CZ  ARG B  96      65.727  57.252  66.162  1.00 45.49           C  
ATOM   2634  NH1 ARG B  96      65.511  56.991  64.872  1.00 44.70           N  
ATOM   2635  NH2 ARG B  96      66.922  57.009  66.690  1.00 44.86           N  
ATOM   2636  N   MET B  97      62.958  53.401  65.925  1.00 25.57           N  
ATOM   2637  CA  MET B  97      63.469  52.685  64.764  1.00 24.42           C  
ATOM   2638  C   MET B  97      62.426  51.793  64.108  1.00 25.26           C  
ATOM   2639  O   MET B  97      62.299  51.796  62.890  1.00 25.17           O  
ATOM   2640  CB  MET B  97      64.696  51.853  65.137  1.00 24.30           C  
ATOM   2641  CG  MET B  97      65.125  50.874  64.053  1.00 22.94           C  
ATOM   2642  SD  MET B  97      66.589  49.950  64.469  1.00 28.33           S  
ATOM   2643  CE  MET B  97      65.975  48.866  65.810  1.00 23.19           C  
ATOM   2644  N   PHE B  98      61.672  51.043  64.910  1.00 24.41           N  
ATOM   2645  CA  PHE B  98      60.659  50.149  64.365  1.00 22.99           C  
ATOM   2646  C   PHE B  98      59.468  50.875  63.800  1.00 23.03           C  
ATOM   2647  O   PHE B  98      58.845  50.415  62.844  1.00 22.30           O  
ATOM   2648  CB  PHE B  98      60.232  49.118  65.402  1.00 20.16           C  
ATOM   2649  CG  PHE B  98      61.109  47.910  65.427  1.00 16.68           C  
ATOM   2650  CD1 PHE B  98      60.800  46.800  64.660  1.00 17.57           C  
ATOM   2651  CD2 PHE B  98      62.269  47.903  66.185  1.00 17.16           C  
ATOM   2652  CE1 PHE B  98      61.634  45.708  64.645  1.00 17.19           C  
ATOM   2653  CE2 PHE B  98      63.118  46.817  66.184  1.00 17.55           C  
ATOM   2654  CZ  PHE B  98      62.800  45.716  65.409  1.00 18.60           C  
ATOM   2655  N   GLU B  99      59.132  52.002  64.409  1.00 26.28           N  
ATOM   2656  CA  GLU B  99      58.018  52.817  63.928  1.00 29.92           C  
ATOM   2657  C   GLU B  99      58.393  53.396  62.568  1.00 28.83           C  
ATOM   2658  O   GLU B  99      57.603  53.349  61.626  1.00 28.38           O  
ATOM   2659  CB  GLU B  99      57.710  53.920  64.933  1.00 31.98           C  
ATOM   2660  CG  GLU B  99      57.059  53.362  66.187  1.00 39.50           C  
ATOM   2661  CD  GLU B  99      57.084  54.315  67.361  1.00 45.03           C  
ATOM   2662  OE1 GLU B  99      57.834  55.319  67.318  1.00 46.63           O  
ATOM   2663  OE2 GLU B  99      56.353  54.045  68.345  1.00 48.70           O  
ATOM   2664  N   GLU B 100      59.630  53.881  62.471  1.00 28.54           N  
ATOM   2665  CA  GLU B 100      60.151  54.423  61.225  1.00 29.56           C  
ATOM   2666  C   GLU B 100      60.220  53.304  60.189  1.00 28.17           C  
ATOM   2667  O   GLU B 100      59.717  53.448  59.072  1.00 30.04           O  
ATOM   2668  CB  GLU B 100      61.554  54.997  61.426  1.00 28.93           C  
ATOM   2669  CG  GLU B 100      61.584  56.341  62.119  1.00 32.78           C  
ATOM   2670  CD  GLU B 100      62.978  56.943  62.165  1.00 34.57           C  
ATOM   2671  OE1 GLU B 100      63.758  56.730  61.209  1.00 36.47           O  
ATOM   2672  OE2 GLU B 100      63.289  57.638  63.154  1.00 35.72           O  
ATOM   2673  N   ALA B 101      60.792  52.171  60.591  1.00 25.79           N  
ATOM   2674  CA  ALA B 101      60.951  51.018  59.717  1.00 22.05           C  
ATOM   2675  C   ALA B 101      59.689  50.578  58.999  1.00 20.05           C  
ATOM   2676  O   ALA B 101      59.687  50.477  57.780  1.00 18.39           O  
ATOM   2677  CB  ALA B 101      61.544  49.863  60.486  1.00 22.05           C  
ATOM   2678  N   VAL B 102      58.608  50.351  59.742  1.00 19.90           N  
ATOM   2679  CA  VAL B 102      57.380  49.884  59.125  1.00 22.02           C  
ATOM   2680  C   VAL B 102      56.761  50.882  58.175  1.00 23.51           C  
ATOM   2681  O   VAL B 102      56.003  50.506  57.283  1.00 24.55           O  
ATOM   2682  CB  VAL B 102      56.347  49.436  60.160  1.00 23.00           C  
ATOM   2683  CG1 VAL B 102      56.877  48.255  60.926  1.00 23.02           C  
ATOM   2684  CG2 VAL B 102      56.046  50.566  61.119  1.00 26.56           C  
ATOM   2685  N   LYS B 103      57.098  52.155  58.348  1.00 24.38           N  
ATOM   2686  CA  LYS B 103      56.567  53.194  57.470  1.00 27.05           C  
ATOM   2687  C   LYS B 103      57.341  53.292  56.148  1.00 23.55           C  
ATOM   2688  O   LYS B 103      56.796  53.735  55.141  1.00 22.14           O  
ATOM   2689  CB  LYS B 103      56.507  54.548  58.209  1.00 31.56           C  
ATOM   2690  CG  LYS B 103      55.239  54.708  59.052  1.00 39.18           C  
ATOM   2691  CD  LYS B 103      55.401  55.651  60.238  1.00 44.17           C  
ATOM   2692  CE  LYS B 103      54.441  55.229  61.385  1.00 52.77           C  
ATOM   2693  NZ  LYS B 103      54.611  53.789  61.902  1.00 52.48           N  
ATOM   2694  N   ILE B 104      58.591  52.829  56.155  1.00 21.80           N  
ATOM   2695  CA  ILE B 104      59.452  52.842  54.971  1.00 19.09           C  
ATOM   2696  C   ILE B 104      58.918  51.892  53.909  1.00 20.60           C  
ATOM   2697  O   ILE B 104      58.607  52.321  52.797  1.00 19.71           O  
ATOM   2698  CB  ILE B 104      60.913  52.478  55.338  1.00 18.68           C  
ATOM   2699  CG1 ILE B 104      61.509  53.567  56.238  1.00 18.18           C  
ATOM   2700  CG2 ILE B 104      61.772  52.330  54.093  1.00 15.14           C  
ATOM   2701  CD1 ILE B 104      62.891  53.250  56.749  1.00 19.26           C  
ATOM   2702  N   PHE B 105      58.732  50.622  54.271  1.00 19.34           N  
ATOM   2703  CA  PHE B 105      58.235  49.636  53.318  1.00 19.69           C  
ATOM   2704  C   PHE B 105      56.832  49.075  53.605  1.00 20.97           C  
ATOM   2705  O   PHE B 105      56.359  48.175  52.898  1.00 20.58           O  
ATOM   2706  CB  PHE B 105      59.265  48.515  53.112  1.00 21.28           C  
ATOM   2707  CG  PHE B 105      60.591  48.998  52.588  1.00 19.10           C  
ATOM   2708  CD1 PHE B 105      60.661  49.741  51.420  1.00 20.50           C  
ATOM   2709  CD2 PHE B 105      61.767  48.724  53.272  1.00 20.63           C  
ATOM   2710  CE1 PHE B 105      61.887  50.204  50.947  1.00 18.22           C  
ATOM   2711  CE2 PHE B 105      63.000  49.180  52.808  1.00 20.07           C  
ATOM   2712  CZ  PHE B 105      63.056  49.918  51.647  1.00 19.66           C  
ATOM   2713  N   GLY B 106      56.169  49.614  54.630  1.00 19.51           N  
ATOM   2714  CA  GLY B 106      54.813  49.199  54.951  1.00 21.81           C  
ATOM   2715  C   GLY B 106      54.579  48.002  55.860  1.00 24.02           C  
ATOM   2716  O   GLY B 106      53.462  47.823  56.345  1.00 24.97           O  
ATOM   2717  N   LYS B 107      55.608  47.183  56.076  1.00 23.49           N  
ATOM   2718  CA  LYS B 107      55.508  45.990  56.915  1.00 22.38           C  
ATOM   2719  C   LYS B 107      56.908  45.503  57.240  1.00 22.00           C  
ATOM   2720  O   LYS B 107      57.891  45.993  56.681  1.00 21.60           O  
ATOM   2721  CB  LYS B 107      54.756  44.877  56.182  1.00 21.51           C  
ATOM   2722  CG  LYS B 107      55.490  44.378  54.968  1.00 24.50           C  
ATOM   2723  CD  LYS B 107      54.806  43.219  54.316  1.00 30.59           C  
ATOM   2724  CE  LYS B 107      55.547  42.867  53.037  1.00 34.35           C  
ATOM   2725  NZ  LYS B 107      55.081  41.595  52.431  1.00 41.53           N  
ATOM   2726  N   LEU B 108      56.979  44.487  58.094  1.00 21.03           N  
ATOM   2727  CA  LEU B 108      58.242  43.910  58.518  1.00 21.57           C  
ATOM   2728  C   LEU B 108      58.047  42.401  58.603  1.00 20.61           C  
ATOM   2729  O   LEU B 108      57.147  41.933  59.292  1.00 19.85           O  
ATOM   2730  CB  LEU B 108      58.589  44.475  59.880  1.00 23.28           C  
ATOM   2731  CG  LEU B 108      60.017  44.869  60.184  1.00 26.92           C  
ATOM   2732  CD1 LEU B 108      60.645  45.537  58.966  1.00 28.54           C  
ATOM   2733  CD2 LEU B 108      59.982  45.811  61.389  1.00 26.67           C  
ATOM   2734  N   ASP B 109      58.850  41.653  57.845  1.00 19.52           N  
ATOM   2735  CA  ASP B 109      58.757  40.196  57.818  1.00 18.07           C  
ATOM   2736  C   ASP B 109      59.889  39.501  58.566  1.00 17.67           C  
ATOM   2737  O   ASP B 109      59.686  38.455  59.169  1.00 18.83           O  
ATOM   2738  CB  ASP B 109      58.794  39.689  56.377  1.00 16.68           C  
ATOM   2739  CG  ASP B 109      57.645  40.180  55.555  1.00 17.20           C  
ATOM   2740  OD1 ASP B 109      56.498  39.780  55.825  1.00 18.33           O  
ATOM   2741  OD2 ASP B 109      57.894  40.944  54.605  1.00 18.79           O  
ATOM   2742  N   ILE B 110      61.076  40.091  58.533  1.00 16.03           N  
ATOM   2743  CA  ILE B 110      62.245  39.496  59.135  1.00 14.13           C  
ATOM   2744  C   ILE B 110      63.004  40.524  59.936  1.00 15.86           C  
ATOM   2745  O   ILE B 110      63.149  41.670  59.512  1.00 14.62           O  
ATOM   2746  CB  ILE B 110      63.185  38.974  58.023  1.00 13.64           C  
ATOM   2747  CG1 ILE B 110      62.456  37.934  57.148  1.00 15.33           C  
ATOM   2748  CG2 ILE B 110      64.479  38.449  58.622  1.00 10.10           C  
ATOM   2749  CD1 ILE B 110      62.937  37.881  55.700  1.00 10.59           C  
ATOM   2750  N   VAL B 111      63.469  40.116  61.112  1.00 15.30           N  
ATOM   2751  CA  VAL B 111      64.261  40.992  61.969  1.00 14.34           C  
ATOM   2752  C   VAL B 111      65.514  40.250  62.377  1.00 14.43           C  
ATOM   2753  O   VAL B 111      65.449  39.155  62.942  1.00 15.31           O  
ATOM   2754  CB  VAL B 111      63.506  41.460  63.251  1.00 12.20           C  
ATOM   2755  CG1 VAL B 111      64.449  42.237  64.159  1.00 10.73           C  
ATOM   2756  CG2 VAL B 111      62.292  42.320  62.889  1.00 12.24           C  
ATOM   2757  N   CYS B 112      66.657  40.828  62.037  1.00 14.16           N  
ATOM   2758  CA  CYS B 112      67.946  40.259  62.372  1.00 13.81           C  
ATOM   2759  C   CYS B 112      68.605  41.162  63.410  1.00 16.40           C  
ATOM   2760  O   CYS B 112      69.023  42.272  63.101  1.00 16.59           O  
ATOM   2761  CB  CYS B 112      68.840  40.135  61.129  1.00 13.19           C  
ATOM   2762  SG  CYS B 112      68.209  39.019  59.847  1.00 16.38           S  
ATOM   2763  N   SER B 113      68.646  40.690  64.656  1.00 16.76           N  
ATOM   2764  CA  SER B 113      69.261  41.421  65.757  1.00 16.97           C  
ATOM   2765  C   SER B 113      70.720  40.975  65.735  1.00 17.54           C  
ATOM   2766  O   SER B 113      71.043  39.855  66.103  1.00 16.64           O  
ATOM   2767  CB  SER B 113      68.554  41.065  67.063  1.00 14.46           C  
ATOM   2768  OG  SER B 113      69.273  41.571  68.158  1.00 15.64           O  
ATOM   2769  N   ASN B 114      71.588  41.869  65.256  1.00 18.66           N  
ATOM   2770  CA  ASN B 114      73.016  41.603  65.060  1.00 17.08           C  
ATOM   2771  C   ASN B 114      74.004  42.523  65.805  1.00 16.81           C  
ATOM   2772  O   ASN B 114      75.116  42.106  66.105  1.00 15.10           O  
ATOM   2773  CB  ASN B 114      73.284  41.589  63.530  1.00 15.82           C  
ATOM   2774  CG  ASN B 114      74.748  41.751  63.171  1.00 16.59           C  
ATOM   2775  OD1 ASN B 114      75.491  40.778  63.053  1.00 18.94           O  
ATOM   2776  ND2 ASN B 114      75.168  42.996  62.976  1.00 18.34           N  
ATOM   2777  N   SER B 115      73.600  43.753  66.126  1.00 16.58           N  
ATOM   2778  CA  SER B 115      74.480  44.690  66.836  1.00 17.27           C  
ATOM   2779  C   SER B 115      75.114  44.066  68.065  1.00 17.80           C  
ATOM   2780  O   SER B 115      74.451  43.363  68.835  1.00 19.14           O  
ATOM   2781  CB  SER B 115      73.714  45.940  67.258  1.00 17.28           C  
ATOM   2782  OG  SER B 115      73.191  46.619  66.122  1.00 19.49           O  
ATOM   2783  N   GLY B 116      76.414  44.280  68.216  1.00 19.28           N  
ATOM   2784  CA  GLY B 116      77.127  43.751  69.359  1.00 17.17           C  
ATOM   2785  C   GLY B 116      78.515  44.330  69.467  1.00 19.40           C  
ATOM   2786  O   GLY B 116      79.043  44.851  68.482  1.00 21.92           O  
ATOM   2787  N   VAL B 117      79.094  44.266  70.666  1.00 20.15           N  
ATOM   2788  CA  VAL B 117      80.451  44.756  70.927  1.00 19.12           C  
ATOM   2789  C   VAL B 117      81.268  43.649  71.578  1.00 19.41           C  
ATOM   2790  O   VAL B 117      80.707  42.755  72.208  1.00 19.24           O  
ATOM   2791  CB  VAL B 117      80.460  46.004  71.881  1.00 19.94           C  
ATOM   2792  CG1 VAL B 117      79.808  47.200  71.193  1.00 17.31           C  
ATOM   2793  CG2 VAL B 117      79.739  45.690  73.201  1.00 15.13           C  
ATOM   2794  N   VAL B 118      82.583  43.673  71.395  1.00 19.38           N  
ATOM   2795  CA  VAL B 118      83.425  42.668  72.017  1.00 21.94           C  
ATOM   2796  C   VAL B 118      84.081  43.228  73.304  1.00 23.12           C  
ATOM   2797  O   VAL B 118      84.097  44.443  73.527  1.00 22.87           O  
ATOM   2798  CB  VAL B 118      84.482  42.116  71.036  1.00 22.06           C  
ATOM   2799  CG1 VAL B 118      85.584  43.141  70.818  1.00 22.75           C  
ATOM   2800  CG2 VAL B 118      85.032  40.758  71.536  1.00 18.59           C  
ATOM   2801  N   SER B 119      84.585  42.335  74.154  1.00 22.39           N  
ATOM   2802  CA  SER B 119      85.210  42.726  75.400  1.00 21.64           C  
ATOM   2803  C   SER B 119      86.160  41.633  75.866  1.00 22.24           C  
ATOM   2804  O   SER B 119      85.913  40.456  75.656  1.00 23.12           O  
ATOM   2805  CB  SER B 119      84.128  42.987  76.454  1.00 22.76           C  
ATOM   2806  OG  SER B 119      84.689  43.341  77.705  1.00 23.63           O  
ATOM   2807  N   PHE B 120      87.250  42.048  76.497  1.00 24.31           N  
ATOM   2808  CA  PHE B 120      88.275  41.144  77.004  1.00 27.05           C  
ATOM   2809  C   PHE B 120      88.802  41.552  78.360  1.00 26.59           C  
ATOM   2810  O   PHE B 120      89.026  42.731  78.625  1.00 26.79           O  
ATOM   2811  CB  PHE B 120      89.461  41.070  76.051  1.00 31.84           C  
ATOM   2812  CG  PHE B 120      89.255  40.116  74.936  1.00 39.06           C  
ATOM   2813  CD1 PHE B 120      88.970  40.574  73.653  1.00 40.13           C  
ATOM   2814  CD2 PHE B 120      89.307  38.742  75.177  1.00 42.94           C  
ATOM   2815  CE1 PHE B 120      88.735  39.686  72.630  1.00 42.20           C  
ATOM   2816  CE2 PHE B 120      89.074  37.825  74.155  1.00 43.81           C  
ATOM   2817  CZ  PHE B 120      88.785  38.301  72.876  1.00 43.79           C  
ATOM   2818  N   GLY B 121      89.019  40.557  79.211  1.00 25.58           N  
ATOM   2819  CA  GLY B 121      89.544  40.827  80.530  1.00 23.60           C  
ATOM   2820  C   GLY B 121      89.336  39.715  81.531  1.00 21.49           C  
ATOM   2821  O   GLY B 121      88.276  39.087  81.567  1.00 22.48           O  
ATOM   2822  N   HIS B 122      90.371  39.450  82.321  1.00 20.04           N  
ATOM   2823  CA  HIS B 122      90.312  38.459  83.382  1.00 19.73           C  
ATOM   2824  C   HIS B 122      89.207  39.006  84.282  1.00 18.16           C  
ATOM   2825  O   HIS B 122      89.072  40.222  84.439  1.00 19.11           O  
ATOM   2826  CB  HIS B 122      91.653  38.431  84.129  1.00 19.25           C  
ATOM   2827  CG  HIS B 122      91.790  37.311  85.119  1.00 19.28           C  
ATOM   2828  ND1 HIS B 122      91.012  37.205  86.254  1.00 18.92           N  
ATOM   2829  CD2 HIS B 122      92.684  36.297  85.191  1.00 18.37           C  
ATOM   2830  CE1 HIS B 122      91.427  36.187  86.988  1.00 17.31           C  
ATOM   2831  NE2 HIS B 122      92.443  35.618  86.366  1.00 18.77           N  
ATOM   2832  N   VAL B 123      88.376  38.119  84.808  1.00 18.47           N  
ATOM   2833  CA  VAL B 123      87.267  38.515  85.670  1.00 19.70           C  
ATOM   2834  C   VAL B 123      87.672  39.525  86.760  1.00 18.58           C  
ATOM   2835  O   VAL B 123      86.954  40.485  87.023  1.00 19.17           O  
ATOM   2836  CB  VAL B 123      86.568  37.253  86.283  1.00 19.66           C  
ATOM   2837  CG1 VAL B 123      87.546  36.450  87.126  1.00 19.74           C  
ATOM   2838  CG2 VAL B 123      85.333  37.635  87.100  1.00 19.14           C  
ATOM   2839  N   LYS B 124      88.870  39.370  87.306  1.00 20.13           N  
ATOM   2840  CA  LYS B 124      89.344  40.241  88.376  1.00 22.75           C  
ATOM   2841  C   LYS B 124      89.442  41.703  87.997  1.00 24.56           C  
ATOM   2842  O   LYS B 124      89.298  42.583  88.852  1.00 24.84           O  
ATOM   2843  CB  LYS B 124      90.699  39.766  88.887  1.00 20.77           C  
ATOM   2844  CG  LYS B 124      91.831  39.977  87.919  1.00 24.29           C  
ATOM   2845  CD  LYS B 124      93.115  39.368  88.442  1.00 25.12           C  
ATOM   2846  CE  LYS B 124      94.295  39.647  87.511  1.00 28.36           C  
ATOM   2847  NZ  LYS B 124      94.514  41.113  87.350  1.00 32.23           N  
ATOM   2848  N   ASP B 125      89.622  41.950  86.704  1.00 24.86           N  
ATOM   2849  CA  ASP B 125      89.774  43.298  86.175  1.00 24.62           C  
ATOM   2850  C   ASP B 125      88.533  43.924  85.605  1.00 23.42           C  
ATOM   2851  O   ASP B 125      88.574  45.064  85.158  1.00 25.68           O  
ATOM   2852  CB  ASP B 125      90.854  43.303  85.101  1.00 26.54           C  
ATOM   2853  CG  ASP B 125      92.173  42.803  85.618  1.00 28.95           C  
ATOM   2854  OD1 ASP B 125      92.653  43.360  86.633  1.00 30.23           O  
ATOM   2855  OD2 ASP B 125      92.718  41.842  85.027  1.00 30.32           O  
ATOM   2856  N   VAL B 126      87.431  43.194  85.607  1.00 20.86           N  
ATOM   2857  CA  VAL B 126      86.209  43.735  85.054  1.00 19.56           C  
ATOM   2858  C   VAL B 126      85.558  44.773  85.971  1.00 21.75           C  
ATOM   2859  O   VAL B 126      85.380  44.547  87.175  1.00 21.53           O  
ATOM   2860  CB  VAL B 126      85.201  42.611  84.677  1.00 16.78           C  
ATOM   2861  CG1 VAL B 126      83.950  43.205  84.071  1.00 16.23           C  
ATOM   2862  CG2 VAL B 126      85.827  41.642  83.704  1.00 16.65           C  
ATOM   2863  N   THR B 127      85.245  45.927  85.383  1.00 21.82           N  
ATOM   2864  CA  THR B 127      84.601  47.034  86.082  1.00 20.48           C  
ATOM   2865  C   THR B 127      83.131  47.005  85.747  1.00 19.71           C  
ATOM   2866  O   THR B 127      82.734  46.408  84.760  1.00 19.77           O  
ATOM   2867  CB  THR B 127      85.148  48.400  85.618  1.00 18.04           C  
ATOM   2868  OG1 THR B 127      84.782  48.628  84.251  1.00 21.19           O  
ATOM   2869  CG2 THR B 127      86.632  48.427  85.723  1.00 18.77           C  
ATOM   2870  N   PRO B 128      82.292  47.605  86.602  1.00 20.62           N  
ATOM   2871  CA  PRO B 128      80.850  47.645  86.367  1.00 20.22           C  
ATOM   2872  C   PRO B 128      80.514  48.393  85.074  1.00 20.98           C  
ATOM   2873  O   PRO B 128      79.551  48.058  84.388  1.00 19.81           O  
ATOM   2874  CB  PRO B 128      80.338  48.396  87.595  1.00 19.53           C  
ATOM   2875  CG  PRO B 128      81.278  47.960  88.652  1.00 20.64           C  
ATOM   2876  CD  PRO B 128      82.611  48.059  87.972  1.00 20.69           C  
ATOM   2877  N   GLU B 129      81.299  49.419  84.754  1.00 22.26           N  
ATOM   2878  CA  GLU B 129      81.067  50.200  83.539  1.00 22.95           C  
ATOM   2879  C   GLU B 129      81.326  49.369  82.293  1.00 20.50           C  
ATOM   2880  O   GLU B 129      80.565  49.451  81.344  1.00 21.12           O  
ATOM   2881  CB  GLU B 129      81.881  51.501  83.513  1.00 26.68           C  
ATOM   2882  CG  GLU B 129      83.105  51.568  84.450  1.00 38.15           C  
ATOM   2883  CD  GLU B 129      82.763  51.743  85.949  1.00 41.04           C  
ATOM   2884  OE1 GLU B 129      83.527  51.200  86.784  1.00 40.83           O  
ATOM   2885  OE2 GLU B 129      81.756  52.424  86.292  1.00 44.01           O  
ATOM   2886  N   GLU B 130      82.362  48.537  82.311  1.00 20.16           N  
ATOM   2887  CA  GLU B 130      82.654  47.683  81.168  1.00 20.44           C  
ATOM   2888  C   GLU B 130      81.590  46.599  81.043  1.00 21.73           C  
ATOM   2889  O   GLU B 130      81.116  46.325  79.941  1.00 23.32           O  
ATOM   2890  CB  GLU B 130      84.045  47.058  81.277  1.00 20.32           C  
ATOM   2891  CG  GLU B 130      84.384  46.089  80.125  1.00 22.06           C  
ATOM   2892  CD  GLU B 130      84.387  46.735  78.730  1.00 23.80           C  
ATOM   2893  OE1 GLU B 130      84.660  46.041  77.745  1.00 24.19           O  
ATOM   2894  OE2 GLU B 130      84.117  47.932  78.579  1.00 25.00           O  
ATOM   2895  N   PHE B 131      81.201  45.997  82.172  1.00 20.26           N  
ATOM   2896  CA  PHE B 131      80.167  44.966  82.175  1.00 17.98           C  
ATOM   2897  C   PHE B 131      78.862  45.559  81.636  1.00 17.76           C  
ATOM   2898  O   PHE B 131      78.213  44.991  80.761  1.00 16.95           O  
ATOM   2899  CB  PHE B 131      79.970  44.425  83.599  1.00 19.10           C  
ATOM   2900  CG  PHE B 131      78.890  43.380  83.720  1.00 15.02           C  
ATOM   2901  CD1 PHE B 131      77.544  43.741  83.687  1.00 12.44           C  
ATOM   2902  CD2 PHE B 131      79.224  42.041  83.827  1.00 15.97           C  
ATOM   2903  CE1 PHE B 131      76.543  42.788  83.749  1.00 14.58           C  
ATOM   2904  CE2 PHE B 131      78.228  41.066  83.893  1.00 15.22           C  
ATOM   2905  CZ  PHE B 131      76.885  41.439  83.853  1.00 16.71           C  
ATOM   2906  N   ASP B 132      78.497  46.732  82.131  1.00 18.05           N  
ATOM   2907  CA  ASP B 132      77.272  47.383  81.685  1.00 18.54           C  
ATOM   2908  C   ASP B 132      77.310  47.772  80.217  1.00 18.15           C  
ATOM   2909  O   ASP B 132      76.313  47.633  79.520  1.00 21.44           O  
ATOM   2910  CB  ASP B 132      76.972  48.603  82.548  1.00 21.44           C  
ATOM   2911  CG  ASP B 132      76.627  48.229  83.973  1.00 24.40           C  
ATOM   2912  OD1 ASP B 132      76.089  47.124  84.177  1.00 24.42           O  
ATOM   2913  OD2 ASP B 132      76.897  49.031  84.886  1.00 26.78           O  
ATOM   2914  N   ARG B 133      78.459  48.244  79.745  1.00 19.64           N  
ATOM   2915  CA  ARG B 133      78.615  48.635  78.341  1.00 18.74           C  
ATOM   2916  C   ARG B 133      78.268  47.472  77.403  1.00 18.37           C  
ATOM   2917  O   ARG B 133      77.491  47.617  76.455  1.00 17.34           O  
ATOM   2918  CB  ARG B 133      80.054  49.065  78.087  1.00 17.48           C  
ATOM   2919  CG  ARG B 133      80.309  49.485  76.642  1.00 20.30           C  
ATOM   2920  CD  ARG B 133      81.771  49.770  76.379  1.00 19.79           C  
ATOM   2921  NE  ARG B 133      82.600  48.579  76.165  1.00 21.01           N  
ATOM   2922  CZ  ARG B 133      82.755  47.963  74.994  1.00 19.75           C  
ATOM   2923  NH1 ARG B 133      82.125  48.396  73.909  1.00 21.40           N  
ATOM   2924  NH2 ARG B 133      83.618  46.967  74.880  1.00 21.06           N  
ATOM   2925  N   VAL B 134      78.834  46.311  77.716  1.00 17.78           N  
ATOM   2926  CA  VAL B 134      78.642  45.103  76.940  1.00 17.26           C  
ATOM   2927  C   VAL B 134      77.244  44.516  77.051  1.00 17.28           C  
ATOM   2928  O   VAL B 134      76.623  44.224  76.026  1.00 19.26           O  
ATOM   2929  CB  VAL B 134      79.690  44.046  77.317  1.00 17.97           C  
ATOM   2930  CG1 VAL B 134      79.484  42.770  76.511  1.00 19.04           C  
ATOM   2931  CG2 VAL B 134      81.088  44.608  77.110  1.00 16.02           C  
ATOM   2932  N   PHE B 135      76.731  44.348  78.271  1.00 15.93           N  
ATOM   2933  CA  PHE B 135      75.380  43.780  78.431  1.00 15.46           C  
ATOM   2934  C   PHE B 135      74.261  44.680  77.904  1.00 14.01           C  
ATOM   2935  O   PHE B 135      73.235  44.206  77.446  1.00 14.50           O  
ATOM   2936  CB  PHE B 135      75.093  43.389  79.890  1.00 14.60           C  
ATOM   2937  CG  PHE B 135      75.510  41.983  80.234  1.00 13.20           C  
ATOM   2938  CD1 PHE B 135      76.863  41.630  80.304  1.00 12.25           C  
ATOM   2939  CD2 PHE B 135      74.545  41.001  80.447  1.00 14.55           C  
ATOM   2940  CE1 PHE B 135      77.250  40.309  80.575  1.00 12.07           C  
ATOM   2941  CE2 PHE B 135      74.919  39.689  80.717  1.00 11.29           C  
ATOM   2942  CZ  PHE B 135      76.277  39.345  80.778  1.00 13.02           C  
ATOM   2943  N   THR B 136      74.455  45.988  77.962  1.00 15.59           N  
ATOM   2944  CA  THR B 136      73.419  46.881  77.478  1.00 15.65           C  
ATOM   2945  C   THR B 136      73.214  46.728  75.985  1.00 12.91           C  
ATOM   2946  O   THR B 136      72.089  46.819  75.503  1.00 15.40           O  
ATOM   2947  CB  THR B 136      73.724  48.347  77.867  1.00 18.96           C  
ATOM   2948  OG1 THR B 136      73.648  48.457  79.292  1.00 22.43           O  
ATOM   2949  CG2 THR B 136      72.714  49.317  77.246  1.00 14.29           C  
ATOM   2950  N   ILE B 137      74.298  46.480  75.256  1.00 13.54           N  
ATOM   2951  CA  ILE B 137      74.204  46.299  73.808  1.00 15.88           C  
ATOM   2952  C   ILE B 137      73.942  44.841  73.388  1.00 15.79           C  
ATOM   2953  O   ILE B 137      72.947  44.555  72.713  1.00 16.72           O  
ATOM   2954  CB  ILE B 137      75.485  46.806  73.096  1.00 17.26           C  
ATOM   2955  CG1 ILE B 137      75.625  48.316  73.325  1.00 18.09           C  
ATOM   2956  CG2 ILE B 137      75.400  46.526  71.581  1.00 17.62           C  
ATOM   2957  CD1 ILE B 137      76.973  48.879  72.950  1.00 17.17           C  
ATOM   2958  N   ASN B 138      74.814  43.927  73.815  1.00 17.08           N  
ATOM   2959  CA  ASN B 138      74.712  42.502  73.448  1.00 16.79           C  
ATOM   2960  C   ASN B 138      73.541  41.719  73.979  1.00 16.39           C  
ATOM   2961  O   ASN B 138      73.083  40.796  73.329  1.00 17.06           O  
ATOM   2962  CB  ASN B 138      75.979  41.746  73.846  1.00 15.24           C  
ATOM   2963  CG  ASN B 138      77.212  42.264  73.151  1.00 17.09           C  
ATOM   2964  OD1 ASN B 138      77.146  43.222  72.386  1.00 16.07           O  
ATOM   2965  ND2 ASN B 138      78.353  41.645  73.426  1.00 16.29           N  
ATOM   2966  N   THR B 139      73.020  42.124  75.133  1.00 16.86           N  
ATOM   2967  CA  THR B 139      71.940  41.396  75.780  1.00 14.36           C  
ATOM   2968  C   THR B 139      70.648  42.187  75.897  1.00 14.70           C  
ATOM   2969  O   THR B 139      69.629  41.813  75.315  1.00 15.13           O  
ATOM   2970  CB  THR B 139      72.434  40.906  77.165  1.00 11.90           C  
ATOM   2971  OG1 THR B 139      73.726  40.313  77.007  1.00 11.78           O  
ATOM   2972  CG2 THR B 139      71.501  39.875  77.741  1.00 14.18           C  
ATOM   2973  N   ARG B 140      70.691  43.267  76.672  1.00 15.66           N  
ATOM   2974  CA  ARG B 140      69.547  44.153  76.870  1.00 15.64           C  
ATOM   2975  C   ARG B 140      69.055  44.703  75.528  1.00 15.85           C  
ATOM   2976  O   ARG B 140      67.853  44.693  75.242  1.00 16.95           O  
ATOM   2977  CB  ARG B 140      69.972  45.305  77.788  1.00 14.89           C  
ATOM   2978  CG  ARG B 140      68.884  46.296  78.147  1.00 14.57           C  
ATOM   2979  CD  ARG B 140      69.484  47.358  79.060  1.00 15.82           C  
ATOM   2980  NE  ARG B 140      68.487  48.189  79.725  1.00 17.82           N  
ATOM   2981  CZ  ARG B 140      68.006  49.321  79.231  1.00 21.41           C  
ATOM   2982  NH1 ARG B 140      68.420  49.756  78.045  1.00 19.75           N  
ATOM   2983  NH2 ARG B 140      67.167  50.049  79.955  1.00 19.41           N  
ATOM   2984  N   GLY B 141      69.993  45.173  74.703  1.00 16.31           N  
ATOM   2985  CA  GLY B 141      69.648  45.707  73.389  1.00 16.01           C  
ATOM   2986  C   GLY B 141      68.920  44.698  72.522  1.00 15.67           C  
ATOM   2987  O   GLY B 141      67.882  45.008  71.949  1.00 18.09           O  
ATOM   2988  N   GLN B 142      69.444  43.478  72.437  1.00 15.65           N  
ATOM   2989  CA  GLN B 142      68.797  42.432  71.646  1.00 14.23           C  
ATOM   2990  C   GLN B 142      67.426  42.072  72.213  1.00 14.14           C  
ATOM   2991  O   GLN B 142      66.488  41.800  71.470  1.00 15.75           O  
ATOM   2992  CB  GLN B 142      69.667  41.183  71.578  1.00 13.96           C  
ATOM   2993  CG  GLN B 142      71.078  41.400  71.019  1.00 15.26           C  
ATOM   2994  CD  GLN B 142      71.578  40.182  70.274  1.00 13.33           C  
ATOM   2995  OE1 GLN B 142      70.913  39.701  69.363  1.00 14.55           O  
ATOM   2996  NE2 GLN B 142      72.744  39.688  70.643  1.00 13.57           N  
ATOM   2997  N   PHE B 143      67.294  42.085  73.533  1.00 14.33           N  
ATOM   2998  CA  PHE B 143      66.009  41.764  74.134  1.00 13.81           C  
ATOM   2999  C   PHE B 143      64.949  42.753  73.682  1.00 13.20           C  
ATOM   3000  O   PHE B 143      63.832  42.371  73.327  1.00 13.38           O  
ATOM   3001  CB  PHE B 143      66.096  41.775  75.668  1.00 14.44           C  
ATOM   3002  CG  PHE B 143      64.812  41.363  76.342  1.00 15.44           C  
ATOM   3003  CD1 PHE B 143      63.752  42.260  76.459  1.00 13.19           C  
ATOM   3004  CD2 PHE B 143      64.631  40.052  76.773  1.00 14.59           C  
ATOM   3005  CE1 PHE B 143      62.537  41.866  76.976  1.00 14.38           C  
ATOM   3006  CE2 PHE B 143      63.415  39.649  77.295  1.00 13.28           C  
ATOM   3007  CZ  PHE B 143      62.361  40.554  77.395  1.00 15.46           C  
ATOM   3008  N   PHE B 144      65.297  44.034  73.707  1.00 16.21           N  
ATOM   3009  CA  PHE B 144      64.350  45.067  73.318  1.00 16.54           C  
ATOM   3010  C   PHE B 144      64.121  45.186  71.822  1.00 16.34           C  
ATOM   3011  O   PHE B 144      63.026  45.547  71.393  1.00 19.11           O  
ATOM   3012  CB  PHE B 144      64.652  46.371  74.050  1.00 15.79           C  
ATOM   3013  CG  PHE B 144      64.357  46.278  75.526  1.00 14.69           C  
ATOM   3014  CD1 PHE B 144      63.044  46.213  75.975  1.00 14.30           C  
ATOM   3015  CD2 PHE B 144      65.379  46.138  76.450  1.00 15.07           C  
ATOM   3016  CE1 PHE B 144      62.760  45.998  77.324  1.00 13.64           C  
ATOM   3017  CE2 PHE B 144      65.094  45.925  77.793  1.00 15.08           C  
ATOM   3018  CZ  PHE B 144      63.786  45.853  78.221  1.00 11.31           C  
ATOM   3019  N   VAL B 145      65.117  44.793  71.026  1.00 17.58           N  
ATOM   3020  CA  VAL B 145      64.944  44.769  69.573  1.00 16.11           C  
ATOM   3021  C   VAL B 145      63.944  43.631  69.339  1.00 15.17           C  
ATOM   3022  O   VAL B 145      63.042  43.757  68.528  1.00 16.05           O  
ATOM   3023  CB  VAL B 145      66.276  44.496  68.829  1.00 14.76           C  
ATOM   3024  CG1 VAL B 145      66.013  44.056  67.392  1.00 12.96           C  
ATOM   3025  CG2 VAL B 145      67.103  45.761  68.813  1.00 14.67           C  
ATOM   3026  N   ALA B 146      64.051  42.566  70.137  1.00 16.44           N  
ATOM   3027  CA  ALA B 146      63.146  41.415  70.041  1.00 15.52           C  
ATOM   3028  C   ALA B 146      61.719  41.790  70.445  1.00 14.63           C  
ATOM   3029  O   ALA B 146      60.750  41.384  69.799  1.00 16.45           O  
ATOM   3030  CB  ALA B 146      63.651  40.265  70.915  1.00 11.61           C  
ATOM   3031  N   ARG B 147      61.595  42.578  71.508  1.00 16.07           N  
ATOM   3032  CA  ARG B 147      60.283  43.008  71.985  1.00 16.22           C  
ATOM   3033  C   ARG B 147      59.561  43.817  70.914  1.00 17.32           C  
ATOM   3034  O   ARG B 147      58.372  43.604  70.656  1.00 17.67           O  
ATOM   3035  CB  ARG B 147      60.415  43.864  73.254  1.00 17.74           C  
ATOM   3036  CG  ARG B 147      59.075  44.194  73.917  1.00 18.06           C  
ATOM   3037  CD  ARG B 147      59.199  45.260  75.007  1.00 18.29           C  
ATOM   3038  NE  ARG B 147      59.366  46.590  74.431  1.00 22.14           N  
ATOM   3039  CZ  ARG B 147      59.436  47.718  75.132  1.00 23.40           C  
ATOM   3040  NH1 ARG B 147      59.353  47.696  76.455  1.00 20.22           N  
ATOM   3041  NH2 ARG B 147      59.612  48.873  74.504  1.00 24.81           N  
ATOM   3042  N   GLU B 148      60.265  44.779  70.321  1.00 17.50           N  
ATOM   3043  CA  GLU B 148      59.652  45.598  69.277  1.00 17.28           C  
ATOM   3044  C   GLU B 148      59.404  44.809  68.005  1.00 15.79           C  
ATOM   3045  O   GLU B 148      58.427  45.058  67.302  1.00 17.72           O  
ATOM   3046  CB  GLU B 148      60.479  46.842  68.999  1.00 16.46           C  
ATOM   3047  CG  GLU B 148      60.623  47.758  70.207  1.00 17.10           C  
ATOM   3048  CD  GLU B 148      59.288  48.156  70.817  1.00 20.99           C  
ATOM   3049  OE1 GLU B 148      58.427  48.679  70.087  1.00 21.93           O  
ATOM   3050  OE2 GLU B 148      59.091  47.947  72.034  1.00 22.48           O  
ATOM   3051  N   ALA B 149      60.270  43.841  67.718  1.00 16.59           N  
ATOM   3052  CA  ALA B 149      60.111  43.015  66.529  1.00 14.45           C  
ATOM   3053  C   ALA B 149      58.827  42.222  66.684  1.00 16.49           C  
ATOM   3054  O   ALA B 149      58.032  42.140  65.751  1.00 17.48           O  
ATOM   3055  CB  ALA B 149      61.299  42.077  66.365  1.00 12.84           C  
ATOM   3056  N   TYR B 150      58.588  41.686  67.883  1.00 16.82           N  
ATOM   3057  CA  TYR B 150      57.372  40.912  68.124  1.00 16.47           C  
ATOM   3058  C   TYR B 150      56.150  41.745  67.783  1.00 17.02           C  
ATOM   3059  O   TYR B 150      55.217  41.268  67.150  1.00 17.96           O  
ATOM   3060  CB  TYR B 150      57.269  40.459  69.594  1.00 16.19           C  
ATOM   3061  CG  TYR B 150      55.900  39.884  69.921  1.00 16.36           C  
ATOM   3062  CD1 TYR B 150      55.509  38.648  69.428  1.00 14.15           C  
ATOM   3063  CD2 TYR B 150      54.961  40.632  70.639  1.00 17.07           C  
ATOM   3064  CE1 TYR B 150      54.229  38.173  69.629  1.00 15.35           C  
ATOM   3065  CE2 TYR B 150      53.685  40.168  70.841  1.00 16.36           C  
ATOM   3066  CZ  TYR B 150      53.324  38.938  70.332  1.00 16.65           C  
ATOM   3067  OH  TYR B 150      52.038  38.483  70.512  1.00 18.15           O  
ATOM   3068  N   LYS B 151      56.171  43.003  68.212  1.00 18.72           N  
ATOM   3069  CA  LYS B 151      55.056  43.920  67.986  1.00 19.35           C  
ATOM   3070  C   LYS B 151      54.786  44.235  66.539  1.00 18.34           C  
ATOM   3071  O   LYS B 151      53.642  44.228  66.105  1.00 18.64           O  
ATOM   3072  CB  LYS B 151      55.285  45.241  68.723  1.00 21.35           C  
ATOM   3073  CG  LYS B 151      55.288  45.122  70.243  1.00 26.44           C  
ATOM   3074  CD  LYS B 151      55.505  46.472  70.892  1.00 26.95           C  
ATOM   3075  CE  LYS B 151      55.803  46.331  72.363  1.00 29.83           C  
ATOM   3076  NZ  LYS B 151      56.290  47.618  72.899  1.00 27.88           N  
ATOM   3077  N   HIS B 152      55.848  44.459  65.780  1.00 18.28           N  
ATOM   3078  CA  HIS B 152      55.703  44.845  64.391  1.00 18.76           C  
ATOM   3079  C   HIS B 152      55.778  43.792  63.318  1.00 20.77           C  
ATOM   3080  O   HIS B 152      55.384  44.056  62.189  1.00 21.98           O  
ATOM   3081  CB  HIS B 152      56.702  45.945  64.077  1.00 19.59           C  
ATOM   3082  CG  HIS B 152      56.512  47.169  64.907  1.00 20.09           C  
ATOM   3083  ND1 HIS B 152      57.249  47.420  66.039  1.00 20.58           N  
ATOM   3084  CD2 HIS B 152      55.671  48.216  64.766  1.00 18.96           C  
ATOM   3085  CE1 HIS B 152      56.879  48.572  66.561  1.00 19.43           C  
ATOM   3086  NE2 HIS B 152      55.921  49.075  65.807  1.00 22.93           N  
ATOM   3087  N   LEU B 153      56.247  42.598  63.657  1.00 20.42           N  
ATOM   3088  CA  LEU B 153      56.366  41.540  62.665  1.00 19.90           C  
ATOM   3089  C   LEU B 153      55.036  40.996  62.127  1.00 19.77           C  
ATOM   3090  O   LEU B 153      54.012  40.972  62.823  1.00 20.23           O  
ATOM   3091  CB  LEU B 153      57.209  40.382  63.222  1.00 18.29           C  
ATOM   3092  CG  LEU B 153      58.739  40.486  63.249  1.00 19.31           C  
ATOM   3093  CD1 LEU B 153      59.307  39.342  64.103  1.00 17.69           C  
ATOM   3094  CD2 LEU B 153      59.303  40.444  61.815  1.00 17.89           C  
ATOM   3095  N   GLU B 154      55.049  40.624  60.850  1.00 19.43           N  
ATOM   3096  CA  GLU B 154      53.899  40.014  60.210  1.00 17.03           C  
ATOM   3097  C   GLU B 154      53.651  38.662  60.882  1.00 17.60           C  
ATOM   3098  O   GLU B 154      54.566  38.064  61.437  1.00 17.06           O  
ATOM   3099  CB  GLU B 154      54.219  39.746  58.739  1.00 16.59           C  
ATOM   3100  CG  GLU B 154      54.244  40.982  57.885  1.00 15.90           C  
ATOM   3101  CD  GLU B 154      52.918  41.690  57.901  1.00 17.16           C  
ATOM   3102  OE1 GLU B 154      51.939  41.108  57.394  1.00 19.87           O  
ATOM   3103  OE2 GLU B 154      52.829  42.805  58.462  1.00 19.74           O  
ATOM   3104  N   ILE B 155      52.407  38.210  60.887  1.00 17.77           N  
ATOM   3105  CA  ILE B 155      52.090  36.897  61.442  1.00 19.67           C  
ATOM   3106  C   ILE B 155      52.896  35.992  60.521  1.00 20.13           C  
ATOM   3107  O   ILE B 155      52.907  36.209  59.311  1.00 21.74           O  
ATOM   3108  CB  ILE B 155      50.589  36.567  61.249  1.00 22.14           C  
ATOM   3109  CG1 ILE B 155      49.709  37.509  62.077  1.00 21.75           C  
ATOM   3110  CG2 ILE B 155      50.310  35.086  61.519  1.00 20.48           C  
ATOM   3111  CD1 ILE B 155      49.925  37.426  63.544  1.00 23.42           C  
ATOM   3112  N   GLY B 156      53.614  35.025  61.082  1.00 20.04           N  
ATOM   3113  CA  GLY B 156      54.429  34.137  60.268  1.00 18.13           C  
ATOM   3114  C   GLY B 156      55.835  34.681  60.071  1.00 17.49           C  
ATOM   3115  O   GLY B 156      56.626  34.104  59.330  1.00 20.59           O  
ATOM   3116  N   GLY B 157      56.153  35.752  60.801  1.00 17.73           N  
ATOM   3117  CA  GLY B 157      57.445  36.419  60.729  1.00 13.55           C  
ATOM   3118  C   GLY B 157      58.642  35.641  61.213  1.00 15.36           C  
ATOM   3119  O   GLY B 157      58.530  34.478  61.611  1.00 17.41           O  
ATOM   3120  N   ARG B 158      59.784  36.315  61.242  1.00 14.16           N  
ATOM   3121  CA  ARG B 158      61.041  35.699  61.614  1.00 14.42           C  
ATOM   3122  C   ARG B 158      61.873  36.638  62.457  1.00 15.88           C  
ATOM   3123  O   ARG B 158      61.980  37.831  62.150  1.00 15.68           O  
ATOM   3124  CB  ARG B 158      61.848  35.368  60.348  1.00 13.00           C  
ATOM   3125  CG  ARG B 158      61.216  34.347  59.418  1.00 15.52           C  
ATOM   3126  CD  ARG B 158      61.473  32.944  59.965  1.00 15.35           C  
ATOM   3127  NE  ARG B 158      61.020  31.855  59.114  1.00 15.47           N  
ATOM   3128  CZ  ARG B 158      59.766  31.431  59.036  1.00 17.67           C  
ATOM   3129  NH1 ARG B 158      58.825  32.015  59.752  1.00 17.67           N  
ATOM   3130  NH2 ARG B 158      59.459  30.388  58.283  1.00 16.86           N  
ATOM   3131  N   LEU B 159      62.475  36.089  63.509  1.00 14.45           N  
ATOM   3132  CA  LEU B 159      63.349  36.849  64.378  1.00 15.11           C  
ATOM   3133  C   LEU B 159      64.600  36.023  64.557  1.00 16.29           C  
ATOM   3134  O   LEU B 159      64.525  34.882  64.997  1.00 18.56           O  
ATOM   3135  CB  LEU B 159      62.690  37.137  65.727  1.00 13.47           C  
ATOM   3136  CG  LEU B 159      63.594  37.737  66.823  1.00 14.46           C  
ATOM   3137  CD1 LEU B 159      64.239  39.063  66.424  1.00 12.53           C  
ATOM   3138  CD2 LEU B 159      62.752  37.940  68.063  1.00 10.70           C  
ATOM   3139  N   ILE B 160      65.743  36.570  64.159  1.00 16.22           N  
ATOM   3140  CA  ILE B 160      67.006  35.866  64.297  1.00 14.50           C  
ATOM   3141  C   ILE B 160      67.908  36.698  65.175  1.00 16.15           C  
ATOM   3142  O   ILE B 160      68.228  37.834  64.844  1.00 16.38           O  
ATOM   3143  CB  ILE B 160      67.710  35.610  62.920  1.00 12.77           C  
ATOM   3144  CG1 ILE B 160      66.881  34.677  62.037  1.00 10.97           C  
ATOM   3145  CG2 ILE B 160      69.066  34.986  63.128  1.00  9.10           C  
ATOM   3146  CD1 ILE B 160      65.971  35.368  61.063  1.00 12.42           C  
ATOM   3147  N   LEU B 161      68.305  36.131  66.302  1.00 13.26           N  
ATOM   3148  CA  LEU B 161      69.179  36.808  67.233  1.00 13.32           C  
ATOM   3149  C   LEU B 161      70.623  36.361  67.007  1.00 12.82           C  
ATOM   3150  O   LEU B 161      70.883  35.285  66.467  1.00 11.02           O  
ATOM   3151  CB  LEU B 161      68.752  36.478  68.671  1.00 13.33           C  
ATOM   3152  CG  LEU B 161      67.284  36.708  69.030  1.00 14.46           C  
ATOM   3153  CD1 LEU B 161      67.045  36.260  70.460  1.00 13.20           C  
ATOM   3154  CD2 LEU B 161      66.927  38.168  68.892  1.00 11.33           C  
ATOM   3155  N   MET B 162      71.559  37.182  67.466  1.00 12.88           N  
ATOM   3156  CA  MET B 162      72.979  36.915  67.330  1.00 15.72           C  
ATOM   3157  C   MET B 162      73.640  36.401  68.611  1.00 16.85           C  
ATOM   3158  O   MET B 162      73.674  37.077  69.650  1.00 18.42           O  
ATOM   3159  CB  MET B 162      73.702  38.177  66.834  1.00 14.73           C  
ATOM   3160  CG  MET B 162      75.194  38.048  66.724  1.00 13.05           C  
ATOM   3161  SD  MET B 162      75.726  36.750  65.619  1.00 17.61           S  
ATOM   3162  CE  MET B 162      75.339  37.425  64.065  1.00 14.39           C  
ATOM   3163  N   GLY B 163      74.224  35.217  68.490  1.00 17.19           N  
ATOM   3164  CA  GLY B 163      74.904  34.592  69.602  1.00 16.49           C  
ATOM   3165  C   GLY B 163      76.379  34.477  69.311  1.00 15.93           C  
ATOM   3166  O   GLY B 163      76.980  35.356  68.691  1.00 13.42           O  
ATOM   3167  N   SER B 164      76.960  33.366  69.738  1.00 14.45           N  
ATOM   3168  CA  SER B 164      78.365  33.137  69.551  1.00 14.40           C  
ATOM   3169  C   SER B 164      78.755  31.782  70.086  1.00 16.23           C  
ATOM   3170  O   SER B 164      78.094  31.228  70.963  1.00 16.17           O  
ATOM   3171  CB  SER B 164      79.152  34.209  70.298  1.00 16.31           C  
ATOM   3172  OG  SER B 164      80.517  33.849  70.402  1.00 16.30           O  
ATOM   3173  N   ILE B 165      79.839  31.248  69.547  1.00 17.16           N  
ATOM   3174  CA  ILE B 165      80.374  29.966  69.990  1.00 17.97           C  
ATOM   3175  C   ILE B 165      80.773  30.072  71.472  1.00 18.91           C  
ATOM   3176  O   ILE B 165      80.786  29.077  72.189  1.00 19.60           O  
ATOM   3177  CB  ILE B 165      81.627  29.585  69.138  1.00 18.32           C  
ATOM   3178  CG1 ILE B 165      82.188  28.226  69.563  1.00 16.77           C  
ATOM   3179  CG2 ILE B 165      82.707  30.673  69.255  1.00 18.61           C  
ATOM   3180  CD1 ILE B 165      83.281  27.681  68.645  1.00 17.09           C  
ATOM   3181  N   THR B 166      81.115  31.283  71.915  1.00 20.57           N  
ATOM   3182  CA  THR B 166      81.526  31.525  73.296  1.00 19.61           C  
ATOM   3183  C   THR B 166      80.409  31.283  74.292  1.00 19.36           C  
ATOM   3184  O   THR B 166      80.678  31.115  75.478  1.00 21.47           O  
ATOM   3185  CB  THR B 166      82.077  32.944  73.515  1.00 19.06           C  
ATOM   3186  OG1 THR B 166      81.093  33.919  73.142  1.00 18.30           O  
ATOM   3187  CG2 THR B 166      83.348  33.148  72.726  1.00 19.40           C  
ATOM   3188  N   GLY B 167      79.161  31.305  73.827  1.00 18.69           N  
ATOM   3189  CA  GLY B 167      78.039  31.028  74.705  1.00 18.04           C  
ATOM   3190  C   GLY B 167      78.224  29.668  75.368  1.00 21.76           C  
ATOM   3191  O   GLY B 167      77.882  29.496  76.543  1.00 22.62           O  
ATOM   3192  N   GLN B 168      78.827  28.727  74.637  1.00 22.33           N  
ATOM   3193  CA  GLN B 168      79.096  27.369  75.134  1.00 24.62           C  
ATOM   3194  C   GLN B 168      80.593  27.018  75.190  1.00 24.55           C  
ATOM   3195  O   GLN B 168      80.950  25.959  75.698  1.00 23.78           O  
ATOM   3196  CB  GLN B 168      78.413  26.330  74.254  1.00 25.33           C  
ATOM   3197  CG  GLN B 168      76.920  26.438  74.162  1.00 31.63           C  
ATOM   3198  CD  GLN B 168      76.370  25.603  73.020  1.00 36.98           C  
ATOM   3199  OE1 GLN B 168      76.907  24.538  72.709  1.00 41.47           O  
ATOM   3200  NE2 GLN B 168      75.296  26.084  72.378  1.00 38.46           N  
ATOM   3201  N   ALA B 169      81.459  27.878  74.653  1.00 24.16           N  
ATOM   3202  CA  ALA B 169      82.903  27.628  74.647  1.00 23.85           C  
ATOM   3203  C   ALA B 169      83.434  27.214  76.035  1.00 24.01           C  
ATOM   3204  O   ALA B 169      82.883  27.600  77.060  1.00 23.36           O  
ATOM   3205  CB  ALA B 169      83.655  28.861  74.117  1.00 23.22           C  
ATOM   3206  N   LYS B 170      84.515  26.445  76.067  1.00 25.07           N  
ATOM   3207  CA  LYS B 170      85.063  25.971  77.329  1.00 27.03           C  
ATOM   3208  C   LYS B 170      86.503  26.340  77.585  1.00 27.69           C  
ATOM   3209  O   LYS B 170      87.023  26.085  78.667  1.00 30.85           O  
ATOM   3210  CB  LYS B 170      84.931  24.454  77.400  1.00 26.63           C  
ATOM   3211  CG  LYS B 170      83.506  23.963  77.406  1.00 28.51           C  
ATOM   3212  CD  LYS B 170      83.469  22.506  77.761  1.00 29.48           C  
ATOM   3213  CE  LYS B 170      82.068  22.088  78.148  1.00 33.50           C  
ATOM   3214  NZ  LYS B 170      82.094  20.919  79.080  1.00 34.84           N  
ATOM   3215  N   ALA B 171      87.153  26.949  76.603  1.00 29.61           N  
ATOM   3216  CA  ALA B 171      88.561  27.285  76.755  1.00 30.21           C  
ATOM   3217  C   ALA B 171      88.931  28.714  76.385  1.00 31.17           C  
ATOM   3218  O   ALA B 171      90.069  28.995  76.026  1.00 33.05           O  
ATOM   3219  CB  ALA B 171      89.411  26.292  75.975  1.00 29.58           C  
ATOM   3220  N   VAL B 172      87.975  29.625  76.459  1.00 31.85           N  
ATOM   3221  CA  VAL B 172      88.276  31.013  76.150  1.00 31.76           C  
ATOM   3222  C   VAL B 172      88.473  31.774  77.463  1.00 30.63           C  
ATOM   3223  O   VAL B 172      87.517  32.061  78.176  1.00 30.64           O  
ATOM   3224  CB  VAL B 172      87.155  31.686  75.320  1.00 31.97           C  
ATOM   3225  CG1 VAL B 172      87.589  33.086  74.935  1.00 31.69           C  
ATOM   3226  CG2 VAL B 172      86.858  30.863  74.056  1.00 30.23           C  
ATOM   3227  N   PRO B 173      89.732  32.045  77.824  1.00 29.60           N  
ATOM   3228  CA  PRO B 173      90.043  32.772  79.056  1.00 29.18           C  
ATOM   3229  C   PRO B 173      89.806  34.254  78.846  1.00 28.34           C  
ATOM   3230  O   PRO B 173      89.712  34.712  77.708  1.00 29.09           O  
ATOM   3231  CB  PRO B 173      91.528  32.474  79.259  1.00 30.03           C  
ATOM   3232  CG  PRO B 173      92.041  32.415  77.875  1.00 31.00           C  
ATOM   3233  CD  PRO B 173      90.967  31.638  77.126  1.00 30.40           C  
ATOM   3234  N   LYS B 174      89.639  34.983  79.942  1.00 27.62           N  
ATOM   3235  CA  LYS B 174      89.430  36.427  79.900  1.00 26.27           C  
ATOM   3236  C   LYS B 174      88.283  36.864  78.993  1.00 24.63           C  
ATOM   3237  O   LYS B 174      88.344  37.912  78.346  1.00 23.39           O  
ATOM   3238  CB  LYS B 174      90.740  37.107  79.488  1.00 26.40           C  
ATOM   3239  CG  LYS B 174      91.896  36.689  80.362  1.00 27.92           C  
ATOM   3240  CD  LYS B 174      93.201  37.325  79.935  1.00 32.62           C  
ATOM   3241  CE  LYS B 174      94.332  36.912  80.886  1.00 35.77           C  
ATOM   3242  NZ  LYS B 174      94.427  35.418  81.035  1.00 39.62           N  
ATOM   3243  N   HIS B 175      87.205  36.090  79.004  1.00 23.86           N  
ATOM   3244  CA  HIS B 175      86.070  36.398  78.165  1.00 23.85           C  
ATOM   3245  C   HIS B 175      84.716  36.141  78.820  1.00 22.18           C  
ATOM   3246  O   HIS B 175      83.726  35.934  78.108  1.00 20.67           O  
ATOM   3247  CB  HIS B 175      86.175  35.571  76.888  1.00 29.81           C  
ATOM   3248  CG  HIS B 175      85.885  36.346  75.644  1.00 36.27           C  
ATOM   3249  ND1 HIS B 175      85.113  35.854  74.616  1.00 40.07           N  
ATOM   3250  CD2 HIS B 175      86.288  37.573  75.249  1.00 38.34           C  
ATOM   3251  CE1 HIS B 175      85.058  36.741  73.638  1.00 40.01           C  
ATOM   3252  NE2 HIS B 175      85.763  37.794  73.998  1.00 42.99           N  
ATOM   3253  N   ALA B 176      84.647  36.208  80.151  1.00 19.92           N  
ATOM   3254  CA  ALA B 176      83.396  35.949  80.860  1.00 16.25           C  
ATOM   3255  C   ALA B 176      82.280  36.922  80.524  1.00 14.79           C  
ATOM   3256  O   ALA B 176      81.163  36.505  80.285  1.00 16.44           O  
ATOM   3257  CB  ALA B 176      83.628  35.890  82.369  1.00 15.40           C  
ATOM   3258  N   VAL B 177      82.589  38.215  80.464  1.00 15.70           N  
ATOM   3259  CA  VAL B 177      81.575  39.237  80.166  1.00 13.39           C  
ATOM   3260  C   VAL B 177      80.959  39.052  78.777  1.00 14.83           C  
ATOM   3261  O   VAL B 177      79.738  38.924  78.639  1.00 14.68           O  
ATOM   3262  CB  VAL B 177      82.154  40.678  80.287  1.00 15.22           C  
ATOM   3263  CG1 VAL B 177      81.079  41.693  79.962  1.00 14.84           C  
ATOM   3264  CG2 VAL B 177      82.687  40.921  81.680  1.00 10.84           C  
ATOM   3265  N   TYR B 178      81.804  39.035  77.752  1.00 15.44           N  
ATOM   3266  CA  TYR B 178      81.343  38.855  76.385  1.00 15.86           C  
ATOM   3267  C   TYR B 178      80.561  37.542  76.209  1.00 15.77           C  
ATOM   3268  O   TYR B 178      79.417  37.532  75.735  1.00 16.37           O  
ATOM   3269  CB  TYR B 178      82.536  38.852  75.431  1.00 16.81           C  
ATOM   3270  CG  TYR B 178      82.115  38.648  74.001  1.00 19.02           C  
ATOM   3271  CD1 TYR B 178      81.581  39.699  73.258  1.00 19.36           C  
ATOM   3272  CD2 TYR B 178      82.194  37.387  73.402  1.00 18.09           C  
ATOM   3273  CE1 TYR B 178      81.127  39.500  71.944  1.00 20.57           C  
ATOM   3274  CE2 TYR B 178      81.743  37.173  72.094  1.00 19.46           C  
ATOM   3275  CZ  TYR B 178      81.212  38.228  71.371  1.00 20.00           C  
ATOM   3276  OH  TYR B 178      80.745  38.024  70.094  1.00 19.96           O  
ATOM   3277  N   SER B 179      81.198  36.433  76.563  1.00 15.58           N  
ATOM   3278  CA  SER B 179      80.573  35.131  76.446  1.00 15.36           C  
ATOM   3279  C   SER B 179      79.239  35.067  77.166  1.00 14.31           C  
ATOM   3280  O   SER B 179      78.267  34.592  76.605  1.00 14.47           O  
ATOM   3281  CB  SER B 179      81.506  34.054  76.974  1.00 16.75           C  
ATOM   3282  OG  SER B 179      82.783  34.158  76.373  1.00 18.04           O  
ATOM   3283  N   GLY B 180      79.195  35.547  78.406  1.00 15.51           N  
ATOM   3284  CA  GLY B 180      77.959  35.531  79.175  1.00 12.68           C  
ATOM   3285  C   GLY B 180      76.858  36.340  78.539  1.00 13.05           C  
ATOM   3286  O   GLY B 180      75.688  35.951  78.598  1.00 14.84           O  
ATOM   3287  N   SER B 181      77.220  37.461  77.911  1.00 14.33           N  
ATOM   3288  CA  SER B 181      76.225  38.313  77.239  1.00 15.43           C  
ATOM   3289  C   SER B 181      75.611  37.593  76.039  1.00 14.80           C  
ATOM   3290  O   SER B 181      74.477  37.874  75.633  1.00 13.70           O  
ATOM   3291  CB  SER B 181      76.853  39.652  76.790  1.00 17.92           C  
ATOM   3292  OG  SER B 181      77.722  39.499  75.678  1.00 14.07           O  
ATOM   3293  N   LYS B 182      76.389  36.683  75.457  1.00 16.44           N  
ATOM   3294  CA  LYS B 182      75.931  35.906  74.311  1.00 16.68           C  
ATOM   3295  C   LYS B 182      75.185  34.648  74.752  1.00 15.55           C  
ATOM   3296  O   LYS B 182      74.196  34.269  74.131  1.00 18.40           O  
ATOM   3297  CB  LYS B 182      77.115  35.551  73.404  1.00 16.73           C  
ATOM   3298  CG  LYS B 182      77.800  36.750  72.756  1.00 16.89           C  
ATOM   3299  CD  LYS B 182      76.837  37.572  71.907  1.00 19.03           C  
ATOM   3300  CE  LYS B 182      77.626  38.648  71.132  1.00 22.46           C  
ATOM   3301  NZ  LYS B 182      76.734  39.493  70.345  1.00 24.76           N  
ATOM   3302  N   GLY B 183      75.640  34.018  75.835  1.00 16.21           N  
ATOM   3303  CA  GLY B 183      74.984  32.817  76.332  1.00 13.88           C  
ATOM   3304  C   GLY B 183      73.534  33.087  76.672  1.00 14.92           C  
ATOM   3305  O   GLY B 183      72.650  32.253  76.413  1.00 14.09           O  
ATOM   3306  N   ALA B 184      73.282  34.283  77.215  1.00 15.79           N  
ATOM   3307  CA  ALA B 184      71.948  34.717  77.604  1.00 13.85           C  
ATOM   3308  C   ALA B 184      71.008  34.705  76.421  1.00 14.00           C  
ATOM   3309  O   ALA B 184      69.826  34.413  76.572  1.00 13.18           O  
ATOM   3310  CB  ALA B 184      72.009  36.119  78.196  1.00 13.76           C  
ATOM   3311  N   ILE B 185      71.534  35.018  75.240  1.00 13.84           N  
ATOM   3312  CA  ILE B 185      70.722  35.071  74.025  1.00  9.20           C  
ATOM   3313  C   ILE B 185      70.145  33.716  73.670  1.00  9.78           C  
ATOM   3314  O   ILE B 185      69.037  33.634  73.137  1.00 10.26           O  
ATOM   3315  CB  ILE B 185      71.543  35.628  72.839  1.00 11.28           C  
ATOM   3316  CG1 ILE B 185      72.070  37.018  73.208  1.00  8.30           C  
ATOM   3317  CG2 ILE B 185      70.712  35.624  71.561  1.00  8.26           C  
ATOM   3318  CD1 ILE B 185      70.962  37.963  73.670  1.00  8.59           C  
ATOM   3319  N   GLU B 186      70.890  32.656  73.977  1.00 10.26           N  
ATOM   3320  CA  GLU B 186      70.440  31.293  73.702  1.00 12.25           C  
ATOM   3321  C   GLU B 186      69.169  30.937  74.481  1.00 10.35           C  
ATOM   3322  O   GLU B 186      68.247  30.343  73.936  1.00  9.89           O  
ATOM   3323  CB  GLU B 186      71.574  30.315  73.995  1.00 13.08           C  
ATOM   3324  CG  GLU B 186      72.831  30.628  73.167  1.00 16.02           C  
ATOM   3325  CD  GLU B 186      73.933  29.611  73.333  1.00 18.16           C  
ATOM   3326  OE1 GLU B 186      73.643  28.483  73.764  1.00 21.73           O  
ATOM   3327  OE2 GLU B 186      75.102  29.928  73.025  1.00 19.18           O  
ATOM   3328  N   THR B 187      69.106  31.363  75.742  1.00 12.93           N  
ATOM   3329  CA  THR B 187      67.932  31.124  76.586  1.00 11.06           C  
ATOM   3330  C   THR B 187      66.783  32.011  76.101  1.00 11.05           C  
ATOM   3331  O   THR B 187      65.629  31.571  76.058  1.00 11.74           O  
ATOM   3332  CB  THR B 187      68.236  31.426  78.067  1.00  9.88           C  
ATOM   3333  OG1 THR B 187      69.330  30.629  78.514  1.00 10.27           O  
ATOM   3334  CG2 THR B 187      67.067  31.117  78.912  1.00 12.33           C  
ATOM   3335  N   PHE B 188      67.093  33.257  75.719  1.00 12.12           N  
ATOM   3336  CA  PHE B 188      66.054  34.155  75.194  1.00 11.85           C  
ATOM   3337  C   PHE B 188      65.367  33.482  74.030  1.00  9.96           C  
ATOM   3338  O   PHE B 188      64.156  33.472  73.946  1.00 13.43           O  
ATOM   3339  CB  PHE B 188      66.631  35.483  74.667  1.00 14.28           C  
ATOM   3340  CG  PHE B 188      67.047  36.468  75.747  1.00 15.44           C  
ATOM   3341  CD1 PHE B 188      66.521  36.398  77.046  1.00 14.49           C  
ATOM   3342  CD2 PHE B 188      67.979  37.473  75.459  1.00 15.52           C  
ATOM   3343  CE1 PHE B 188      66.917  37.303  78.025  1.00 14.45           C  
ATOM   3344  CE2 PHE B 188      68.381  38.390  76.447  1.00 15.16           C  
ATOM   3345  CZ  PHE B 188      67.847  38.301  77.730  1.00 13.49           C  
ATOM   3346  N   ALA B 189      66.158  32.952  73.096  1.00 14.22           N  
ATOM   3347  CA  ALA B 189      65.606  32.284  71.910  1.00 14.00           C  
ATOM   3348  C   ALA B 189      64.620  31.188  72.307  1.00 14.04           C  
ATOM   3349  O   ALA B 189      63.509  31.147  71.780  1.00 15.09           O  
ATOM   3350  CB  ALA B 189      66.719  31.704  71.042  1.00 13.20           C  
ATOM   3351  N   ARG B 190      65.010  30.316  73.249  1.00 14.58           N  
ATOM   3352  CA  ARG B 190      64.100  29.253  73.711  1.00 12.46           C  
ATOM   3353  C   ARG B 190      62.823  29.805  74.290  1.00 11.83           C  
ATOM   3354  O   ARG B 190      61.741  29.341  73.957  1.00 13.44           O  
ATOM   3355  CB  ARG B 190      64.759  28.364  74.764  1.00 12.79           C  
ATOM   3356  CG  ARG B 190      65.632  27.305  74.157  1.00 14.01           C  
ATOM   3357  CD  ARG B 190      66.283  26.420  75.210  1.00 14.44           C  
ATOM   3358  NE  ARG B 190      67.334  27.049  76.007  1.00 15.97           N  
ATOM   3359  CZ  ARG B 190      68.599  27.163  75.635  1.00 16.67           C  
ATOM   3360  NH1 ARG B 190      68.977  26.716  74.458  1.00 18.70           N  
ATOM   3361  NH2 ARG B 190      69.512  27.609  76.483  1.00 18.03           N  
ATOM   3362  N   CYS B 191      62.945  30.823  75.136  1.00 13.17           N  
ATOM   3363  CA  CYS B 191      61.780  31.423  75.781  1.00 13.47           C  
ATOM   3364  C   CYS B 191      60.916  32.306  74.882  1.00 15.69           C  
ATOM   3365  O   CYS B 191      59.694  32.291  74.974  1.00 14.62           O  
ATOM   3366  CB  CYS B 191      62.212  32.205  77.012  1.00 16.05           C  
ATOM   3367  SG  CYS B 191      62.949  31.157  78.254  1.00 17.45           S  
ATOM   3368  N   MET B 192      61.545  33.084  74.013  1.00 14.03           N  
ATOM   3369  CA  MET B 192      60.803  33.948  73.101  1.00 14.44           C  
ATOM   3370  C   MET B 192      60.104  33.132  72.019  1.00 13.93           C  
ATOM   3371  O   MET B 192      59.062  33.545  71.515  1.00 17.20           O  
ATOM   3372  CB  MET B 192      61.721  35.010  72.483  1.00 14.85           C  
ATOM   3373  CG  MET B 192      62.331  35.909  73.527  1.00 16.63           C  
ATOM   3374  SD  MET B 192      63.466  37.157  72.915  1.00 19.86           S  
ATOM   3375  CE  MET B 192      63.917  36.496  71.487  1.00 24.48           C  
ATOM   3376  N   ALA B 193      60.644  31.963  71.680  1.00 14.36           N  
ATOM   3377  CA  ALA B 193      60.012  31.112  70.676  1.00 13.47           C  
ATOM   3378  C   ALA B 193      58.603  30.715  71.121  1.00 13.66           C  
ATOM   3379  O   ALA B 193      57.697  30.557  70.308  1.00 14.31           O  
ATOM   3380  CB  ALA B 193      60.864  29.879  70.436  1.00 13.70           C  
ATOM   3381  N   ILE B 194      58.427  30.561  72.431  1.00 14.83           N  
ATOM   3382  CA  ILE B 194      57.127  30.205  73.007  1.00 15.31           C  
ATOM   3383  C   ILE B 194      56.180  31.398  72.915  1.00 15.90           C  
ATOM   3384  O   ILE B 194      55.092  31.295  72.350  1.00 17.15           O  
ATOM   3385  CB  ILE B 194      57.256  29.809  74.501  1.00 16.49           C  
ATOM   3386  CG1 ILE B 194      58.244  28.656  74.650  1.00 17.20           C  
ATOM   3387  CG2 ILE B 194      55.911  29.397  75.064  1.00 14.25           C  
ATOM   3388  CD1 ILE B 194      58.611  28.366  76.071  1.00 20.08           C  
ATOM   3389  N   ASP B 195      56.606  32.535  73.464  1.00 16.20           N  
ATOM   3390  CA  ASP B 195      55.791  33.751  73.456  1.00 17.18           C  
ATOM   3391  C   ASP B 195      55.406  34.240  72.047  1.00 18.83           C  
ATOM   3392  O   ASP B 195      54.236  34.491  71.756  1.00 17.33           O  
ATOM   3393  CB  ASP B 195      56.527  34.885  74.184  1.00 16.50           C  
ATOM   3394  CG  ASP B 195      56.625  34.671  75.681  1.00 17.31           C  
ATOM   3395  OD1 ASP B 195      56.096  33.663  76.186  1.00 19.45           O  
ATOM   3396  OD2 ASP B 195      57.245  35.515  76.363  1.00 16.67           O  
ATOM   3397  N   MET B 196      56.405  34.368  71.181  1.00 19.62           N  
ATOM   3398  CA  MET B 196      56.199  34.871  69.833  1.00 17.52           C  
ATOM   3399  C   MET B 196      55.484  33.936  68.883  1.00 17.72           C  
ATOM   3400  O   MET B 196      54.984  34.370  67.841  1.00 18.06           O  
ATOM   3401  CB  MET B 196      57.525  35.360  69.272  1.00 17.65           C  
ATOM   3402  CG  MET B 196      58.199  36.358  70.222  1.00 17.94           C  
ATOM   3403  SD  MET B 196      59.573  37.342  69.593  1.00 19.12           S  
ATOM   3404  CE  MET B 196      58.945  37.857  68.338  1.00 19.87           C  
ATOM   3405  N   ALA B 197      55.355  32.668  69.278  1.00 18.73           N  
ATOM   3406  CA  ALA B 197      54.658  31.671  68.459  1.00 16.05           C  
ATOM   3407  C   ALA B 197      53.170  31.978  68.315  1.00 18.02           C  
ATOM   3408  O   ALA B 197      52.490  31.409  67.445  1.00 17.94           O  
ATOM   3409  CB  ALA B 197      54.860  30.289  69.028  1.00 15.70           C  
ATOM   3410  N   ASP B 198      52.655  32.876  69.160  1.00 18.68           N  
ATOM   3411  CA  ASP B 198      51.243  33.250  69.081  1.00 20.42           C  
ATOM   3412  C   ASP B 198      50.947  34.141  67.866  1.00 20.73           C  
ATOM   3413  O   ASP B 198      49.788  34.458  67.574  1.00 21.72           O  
ATOM   3414  CB  ASP B 198      50.727  33.868  70.392  1.00 21.73           C  
ATOM   3415  CG  ASP B 198      51.446  35.139  70.777  1.00 26.78           C  
ATOM   3416  OD1 ASP B 198      52.005  35.813  69.895  1.00 28.13           O  
ATOM   3417  OD2 ASP B 198      51.438  35.469  71.982  1.00 30.92           O  
ATOM   3418  N   LYS B 199      52.009  34.559  67.182  1.00 20.66           N  
ATOM   3419  CA  LYS B 199      51.899  35.324  65.947  1.00 19.82           C  
ATOM   3420  C   LYS B 199      52.611  34.513  64.841  1.00 20.76           C  
ATOM   3421  O   LYS B 199      52.899  35.028  63.751  1.00 19.44           O  
ATOM   3422  CB  LYS B 199      52.545  36.702  66.092  1.00 19.79           C  
ATOM   3423  CG  LYS B 199      51.677  37.709  66.833  1.00 20.66           C  
ATOM   3424  CD  LYS B 199      52.301  39.106  66.852  1.00 21.41           C  
ATOM   3425  CE  LYS B 199      52.423  39.701  65.454  1.00 21.73           C  
ATOM   3426  NZ  LYS B 199      52.878  41.116  65.504  1.00 22.45           N  
ATOM   3427  N   LYS B 200      52.877  33.237  65.135  1.00 20.02           N  
ATOM   3428  CA  LYS B 200      53.554  32.331  64.216  1.00 18.91           C  
ATOM   3429  C   LYS B 200      54.965  32.778  63.802  1.00 18.70           C  
ATOM   3430  O   LYS B 200      55.467  32.430  62.733  1.00 19.26           O  
ATOM   3431  CB  LYS B 200      52.690  32.049  62.992  1.00 21.30           C  
ATOM   3432  CG  LYS B 200      51.321  31.477  63.314  1.00 27.05           C  
ATOM   3433  CD  LYS B 200      51.377  30.466  64.450  1.00 33.33           C  
ATOM   3434  CE  LYS B 200      49.975  29.968  64.841  1.00 37.86           C  
ATOM   3435  NZ  LYS B 200      49.953  29.268  66.177  1.00 39.35           N  
ATOM   3436  N   ILE B 201      55.612  33.538  64.675  1.00 17.72           N  
ATOM   3437  CA  ILE B 201      56.967  34.003  64.439  1.00 16.65           C  
ATOM   3438  C   ILE B 201      57.962  32.985  65.023  1.00 18.27           C  
ATOM   3439  O   ILE B 201      57.797  32.526  66.166  1.00 18.21           O  
ATOM   3440  CB  ILE B 201      57.212  35.357  65.170  1.00 15.59           C  
ATOM   3441  CG1 ILE B 201      56.312  36.458  64.610  1.00 13.36           C  
ATOM   3442  CG2 ILE B 201      58.671  35.755  65.085  1.00 14.15           C  
ATOM   3443  CD1 ILE B 201      56.207  37.652  65.532  1.00 11.92           C  
ATOM   3444  N   THR B 202      58.973  32.605  64.242  1.00 17.65           N  
ATOM   3445  CA  THR B 202      59.991  31.711  64.769  1.00 15.42           C  
ATOM   3446  C   THR B 202      61.115  32.594  65.306  1.00 16.76           C  
ATOM   3447  O   THR B 202      61.331  33.697  64.802  1.00 15.84           O  
ATOM   3448  CB  THR B 202      60.553  30.724  63.723  1.00 15.77           C  
ATOM   3449  OG1 THR B 202      61.220  31.448  62.692  1.00 18.46           O  
ATOM   3450  CG2 THR B 202      59.436  29.853  63.129  1.00 11.07           C  
ATOM   3451  N   VAL B 203      61.764  32.140  66.377  1.00 15.00           N  
ATOM   3452  CA  VAL B 203      62.852  32.865  67.020  1.00 12.87           C  
ATOM   3453  C   VAL B 203      64.015  31.892  67.159  1.00 14.58           C  
ATOM   3454  O   VAL B 203      63.888  30.834  67.765  1.00 14.62           O  
ATOM   3455  CB  VAL B 203      62.428  33.361  68.419  1.00 12.09           C  
ATOM   3456  CG1 VAL B 203      63.476  34.286  68.982  1.00 11.43           C  
ATOM   3457  CG2 VAL B 203      61.072  34.036  68.338  1.00  9.90           C  
ATOM   3458  N   ASN B 204      65.152  32.251  66.591  1.00 16.25           N  
ATOM   3459  CA  ASN B 204      66.328  31.401  66.627  1.00 14.75           C  
ATOM   3460  C   ASN B 204      67.540  32.275  66.855  1.00 14.85           C  
ATOM   3461  O   ASN B 204      67.460  33.488  66.712  1.00 14.19           O  
ATOM   3462  CB  ASN B 204      66.478  30.663  65.280  1.00 14.10           C  
ATOM   3463  CG  ASN B 204      65.386  29.656  65.051  1.00 13.80           C  
ATOM   3464  OD1 ASN B 204      65.338  28.637  65.728  1.00 13.97           O  
ATOM   3465  ND2 ASN B 204      64.503  29.925  64.097  1.00 11.51           N  
ATOM   3466  N   VAL B 205      68.662  31.643  67.180  1.00 14.17           N  
ATOM   3467  CA  VAL B 205      69.927  32.320  67.415  1.00 14.86           C  
ATOM   3468  C   VAL B 205      70.963  31.706  66.501  1.00 14.93           C  
ATOM   3469  O   VAL B 205      70.984  30.479  66.330  1.00 14.26           O  
ATOM   3470  CB  VAL B 205      70.465  32.081  68.869  1.00 15.57           C  
ATOM   3471  CG1 VAL B 205      71.794  32.803  69.087  1.00 14.53           C  
ATOM   3472  CG2 VAL B 205      69.499  32.559  69.874  1.00 18.71           C  
ATOM   3473  N   VAL B 206      71.788  32.556  65.883  1.00 15.63           N  
ATOM   3474  CA  VAL B 206      72.895  32.074  65.050  1.00 14.60           C  
ATOM   3475  C   VAL B 206      74.131  32.289  65.929  1.00 15.67           C  
ATOM   3476  O   VAL B 206      74.282  33.337  66.565  1.00 14.22           O  
ATOM   3477  CB  VAL B 206      73.018  32.813  63.658  1.00 14.47           C  
ATOM   3478  CG1 VAL B 206      71.910  32.363  62.710  1.00 11.66           C  
ATOM   3479  CG2 VAL B 206      72.964  34.333  63.826  1.00 13.03           C  
ATOM   3480  N   ALA B 207      74.977  31.272  66.037  1.00 14.27           N  
ATOM   3481  CA  ALA B 207      76.163  31.377  66.873  1.00 13.93           C  
ATOM   3482  C   ALA B 207      77.446  31.167  66.068  1.00 15.22           C  
ATOM   3483  O   ALA B 207      77.977  30.056  65.962  1.00 16.73           O  
ATOM   3484  CB  ALA B 207      76.077  30.397  68.045  1.00 14.30           C  
ATOM   3485  N   PRO B 208      77.978  32.257  65.503  1.00 14.67           N  
ATOM   3486  CA  PRO B 208      79.195  32.204  64.701  1.00 13.42           C  
ATOM   3487  C   PRO B 208      80.409  31.868  65.514  1.00 14.65           C  
ATOM   3488  O   PRO B 208      80.461  32.148  66.718  1.00 15.75           O  
ATOM   3489  CB  PRO B 208      79.342  33.653  64.214  1.00 11.39           C  
ATOM   3490  CG  PRO B 208      77.972  34.189  64.249  1.00 11.06           C  
ATOM   3491  CD  PRO B 208      77.419  33.619  65.519  1.00 12.09           C  
ATOM   3492  N   GLY B 209      81.386  31.266  64.849  1.00 13.92           N  
ATOM   3493  CA  GLY B 209      82.663  31.016  65.482  1.00 13.91           C  
ATOM   3494  C   GLY B 209      83.391  32.279  65.034  1.00 15.02           C  
ATOM   3495  O   GLY B 209      82.738  33.303  64.810  1.00 14.33           O  
ATOM   3496  N   GLY B 210      84.713  32.243  64.918  1.00 16.66           N  
ATOM   3497  CA  GLY B 210      85.444  33.413  64.441  1.00 18.33           C  
ATOM   3498  C   GLY B 210      85.092  33.721  62.988  1.00 18.91           C  
ATOM   3499  O   GLY B 210      85.075  32.819  62.136  1.00 17.47           O  
ATOM   3500  N   ILE B 211      84.783  34.989  62.715  1.00 20.15           N  
ATOM   3501  CA  ILE B 211      84.402  35.462  61.375  1.00 19.18           C  
ATOM   3502  C   ILE B 211      85.209  36.715  61.034  1.00 21.01           C  
ATOM   3503  O   ILE B 211      85.270  37.619  61.851  1.00 20.88           O  
ATOM   3504  CB  ILE B 211      82.918  35.854  61.362  1.00 18.89           C  
ATOM   3505  CG1 ILE B 211      82.040  34.663  61.770  1.00 18.49           C  
ATOM   3506  CG2 ILE B 211      82.505  36.378  60.011  1.00 18.41           C  
ATOM   3507  CD1 ILE B 211      82.090  33.469  60.811  1.00 13.15           C  
ATOM   3508  N   LYS B 212      85.800  36.785  59.838  1.00 21.69           N  
ATOM   3509  CA  LYS B 212      86.594  37.960  59.435  1.00 24.53           C  
ATOM   3510  C   LYS B 212      85.806  39.240  59.294  1.00 24.01           C  
ATOM   3511  O   LYS B 212      85.061  39.409  58.345  1.00 25.24           O  
ATOM   3512  CB  LYS B 212      87.362  37.725  58.138  1.00 26.33           C  
ATOM   3513  CG  LYS B 212      88.667  37.023  58.347  1.00 29.18           C  
ATOM   3514  CD  LYS B 212      89.553  37.103  57.117  1.00 29.13           C  
ATOM   3515  CE  LYS B 212      90.193  38.464  56.956  1.00 29.10           C  
ATOM   3516  NZ  LYS B 212      91.362  38.356  56.034  1.00 24.19           N  
ATOM   3517  N   THR B 213      85.969  40.120  60.279  1.00 25.47           N  
ATOM   3518  CA  THR B 213      85.323  41.438  60.345  1.00 26.54           C  
ATOM   3519  C   THR B 213      86.293  42.291  61.165  1.00 27.44           C  
ATOM   3520  O   THR B 213      87.383  41.830  61.521  1.00 26.52           O  
ATOM   3521  CB  THR B 213      83.969  41.421  61.136  1.00 27.31           C  
ATOM   3522  OG1 THR B 213      84.215  41.065  62.505  1.00 27.54           O  
ATOM   3523  CG2 THR B 213      82.958  40.461  60.524  1.00 24.63           C  
ATOM   3524  N   ASP B 214      85.886  43.516  61.487  1.00 31.66           N  
ATOM   3525  CA  ASP B 214      86.709  44.418  62.292  1.00 33.89           C  
ATOM   3526  C   ASP B 214      86.844  43.833  63.688  1.00 34.41           C  
ATOM   3527  O   ASP B 214      87.917  43.880  64.293  1.00 34.37           O  
ATOM   3528  CB  ASP B 214      86.072  45.811  62.370  1.00 37.58           C  
ATOM   3529  CG  ASP B 214      86.084  46.539  61.024  1.00 42.55           C  
ATOM   3530  OD1 ASP B 214      87.116  46.460  60.315  1.00 44.21           O  
ATOM   3531  OD2 ASP B 214      85.062  47.189  60.677  1.00 44.21           O  
ATOM   3532  N   MET B 215      85.751  43.248  64.184  1.00 34.80           N  
ATOM   3533  CA  MET B 215      85.754  42.633  65.501  1.00 34.75           C  
ATOM   3534  C   MET B 215      86.789  41.531  65.488  1.00 36.67           C  
ATOM   3535  O   MET B 215      87.586  41.399  66.415  1.00 36.92           O  
ATOM   3536  CB  MET B 215      84.384  42.052  65.854  1.00 31.42           C  
ATOM   3537  CG  MET B 215      84.370  41.454  67.261  1.00 28.96           C  
ATOM   3538  SD  MET B 215      82.787  40.842  67.821  1.00 27.81           S  
ATOM   3539  CE  MET B 215      81.862  42.416  67.948  1.00 27.30           C  
ATOM   3540  N   TYR B 216      86.782  40.766  64.401  1.00 40.03           N  
ATOM   3541  CA  TYR B 216      87.720  39.667  64.198  1.00 42.69           C  
ATOM   3542  C   TYR B 216      89.161  40.118  64.326  1.00 44.16           C  
ATOM   3543  O   TYR B 216      89.961  39.489  65.015  1.00 45.63           O  
ATOM   3544  CB  TYR B 216      87.539  39.088  62.802  1.00 42.60           C  
ATOM   3545  CG  TYR B 216      88.613  38.112  62.360  1.00 41.62           C  
ATOM   3546  CD1 TYR B 216      88.484  36.748  62.630  1.00 41.46           C  
ATOM   3547  CD2 TYR B 216      89.718  38.543  61.622  1.00 40.58           C  
ATOM   3548  CE1 TYR B 216      89.409  35.836  62.176  1.00 41.32           C  
ATOM   3549  CE2 TYR B 216      90.658  37.640  61.162  1.00 40.72           C  
ATOM   3550  CZ  TYR B 216      90.491  36.285  61.440  1.00 41.60           C  
ATOM   3551  OH  TYR B 216      91.386  35.358  60.970  1.00 41.23           O  
ATOM   3552  N   HIS B 217      89.511  41.181  63.623  1.00 46.35           N  
ATOM   3553  CA  HIS B 217      90.874  41.659  63.688  1.00 50.21           C  
ATOM   3554  C   HIS B 217      91.336  41.918  65.120  1.00 52.31           C  
ATOM   3555  O   HIS B 217      92.532  41.851  65.420  1.00 53.80           O  
ATOM   3556  CB  HIS B 217      91.046  42.823  62.724  1.00 51.15           C  
ATOM   3557  CG  HIS B 217      90.964  42.388  61.296  1.00 52.48           C  
ATOM   3558  ND1 HIS B 217      90.047  42.894  60.399  1.00 52.55           N  
ATOM   3559  CD2 HIS B 217      91.634  41.416  60.631  1.00 52.54           C  
ATOM   3560  CE1 HIS B 217      90.154  42.251  59.250  1.00 52.60           C  
ATOM   3561  NE2 HIS B 217      91.110  41.350  59.365  1.00 53.09           N  
ATOM   3562  N   ALA B 218      90.355  42.061  66.014  1.00 54.09           N  
ATOM   3563  CA  ALA B 218      90.590  42.247  67.453  1.00 55.24           C  
ATOM   3564  C   ALA B 218      90.211  40.963  68.235  1.00 55.23           C  
ATOM   3565  O   ALA B 218      90.970  39.955  68.211  1.00 55.09           O  
ATOM   3566  CB  ALA B 218      89.754  43.421  67.963  1.00 56.72           C  
ATOM   3567  N   ASP B 236      95.138  34.492  60.432  1.00 36.54           N  
ATOM   3568  CA  ASP B 236      94.277  33.852  59.432  1.00 38.74           C  
ATOM   3569  C   ASP B 236      94.611  32.370  59.281  1.00 39.99           C  
ATOM   3570  O   ASP B 236      93.711  31.535  59.115  1.00 39.06           O  
ATOM   3571  CB  ASP B 236      94.414  34.533  58.064  1.00 39.52           C  
ATOM   3572  CG  ASP B 236      93.248  35.467  57.735  1.00 41.29           C  
ATOM   3573  OD1 ASP B 236      92.753  36.160  58.649  1.00 42.25           O  
ATOM   3574  OD2 ASP B 236      92.842  35.527  56.545  1.00 40.26           O  
ATOM   3575  N   GLU B 237      95.911  32.066  59.279  1.00 40.98           N  
ATOM   3576  CA  GLU B 237      96.403  30.697  59.157  1.00 42.27           C  
ATOM   3577  C   GLU B 237      96.134  29.956  60.458  1.00 42.26           C  
ATOM   3578  O   GLU B 237      95.807  28.766  60.433  1.00 43.52           O  
ATOM   3579  CB  GLU B 237      97.896  30.681  58.841  1.00 43.97           C  
ATOM   3580  CG  GLU B 237      98.444  29.307  58.421  1.00 47.31           C  
ATOM   3581  CD  GLU B 237      97.831  28.770  57.121  1.00 47.84           C  
ATOM   3582  OE1 GLU B 237      97.650  27.538  57.020  1.00 48.46           O  
ATOM   3583  OE2 GLU B 237      97.562  29.567  56.193  1.00 48.42           O  
ATOM   3584  N   TYR B 238      96.287  30.656  61.586  1.00 41.03           N  
ATOM   3585  CA  TYR B 238      96.014  30.072  62.897  1.00 40.28           C  
ATOM   3586  C   TYR B 238      94.508  29.783  63.003  1.00 37.46           C  
ATOM   3587  O   TYR B 238      94.118  28.696  63.395  1.00 37.01           O  
ATOM   3588  CB  TYR B 238      96.463  31.004  64.045  1.00 42.62           C  
ATOM   3589  CG  TYR B 238      96.120  30.471  65.437  1.00 45.85           C  
ATOM   3590  CD1 TYR B 238      94.832  30.630  65.974  1.00 46.22           C  
ATOM   3591  CD2 TYR B 238      97.057  29.749  66.183  1.00 45.47           C  
ATOM   3592  CE1 TYR B 238      94.483  30.073  67.208  1.00 47.74           C  
ATOM   3593  CE2 TYR B 238      96.721  29.191  67.427  1.00 47.44           C  
ATOM   3594  CZ  TYR B 238      95.430  29.353  67.931  1.00 49.34           C  
ATOM   3595  OH  TYR B 238      95.079  28.780  69.141  1.00 50.33           O  
ATOM   3596  N   ALA B 239      93.676  30.767  62.675  1.00 33.70           N  
ATOM   3597  CA  ALA B 239      92.234  30.593  62.721  1.00 31.81           C  
ATOM   3598  C   ALA B 239      91.813  29.474  61.770  1.00 32.15           C  
ATOM   3599  O   ALA B 239      90.916  28.694  62.081  1.00 31.36           O  
ATOM   3600  CB  ALA B 239      91.545  31.883  62.337  1.00 30.56           C  
ATOM   3601  N   ALA B 240      92.486  29.388  60.624  1.00 32.95           N  
ATOM   3602  CA  ALA B 240      92.193  28.375  59.611  1.00 33.14           C  
ATOM   3603  C   ALA B 240      92.457  26.954  60.104  1.00 33.96           C  
ATOM   3604  O   ALA B 240      91.561  26.102  60.109  1.00 32.96           O  
ATOM   3605  CB  ALA B 240      93.007  28.648  58.346  1.00 32.22           C  
ATOM   3606  N   VAL B 241      93.687  26.709  60.536  1.00 34.85           N  
ATOM   3607  CA  VAL B 241      94.084  25.395  61.010  1.00 38.58           C  
ATOM   3608  C   VAL B 241      93.600  25.072  62.425  1.00 40.46           C  
ATOM   3609  O   VAL B 241      93.210  23.935  62.716  1.00 41.50           O  
ATOM   3610  CB  VAL B 241      95.615  25.241  60.951  1.00 38.74           C  
ATOM   3611  CG1 VAL B 241      96.022  23.815  61.276  1.00 39.34           C  
ATOM   3612  CG2 VAL B 241      96.107  25.618  59.577  1.00 39.84           C  
ATOM   3613  N   GLN B 242      93.594  26.076  63.290  1.00 41.08           N  
ATOM   3614  CA  GLN B 242      93.189  25.884  64.680  1.00 43.06           C  
ATOM   3615  C   GLN B 242      91.722  25.738  65.001  1.00 40.76           C  
ATOM   3616  O   GLN B 242      91.361  24.899  65.820  1.00 43.68           O  
ATOM   3617  CB  GLN B 242      93.775  26.973  65.576  1.00 46.95           C  
ATOM   3618  CG  GLN B 242      94.933  26.493  66.429  1.00 56.50           C  
ATOM   3619  CD  GLN B 242      94.479  25.670  67.625  1.00 60.87           C  
ATOM   3620  OE1 GLN B 242      93.462  25.978  68.260  1.00 62.21           O  
ATOM   3621  NE2 GLN B 242      95.242  24.629  67.949  1.00 62.61           N  
ATOM   3622  N   TRP B 243      90.871  26.548  64.387  1.00 36.98           N  
ATOM   3623  CA  TRP B 243      89.455  26.476  64.712  1.00 34.11           C  
ATOM   3624  C   TRP B 243      88.571  25.772  63.701  1.00 31.63           C  
ATOM   3625  O   TRP B 243      87.348  25.795  63.839  1.00 31.86           O  
ATOM   3626  CB  TRP B 243      88.911  27.874  65.024  1.00 36.20           C  
ATOM   3627  CG  TRP B 243      89.733  28.604  66.029  1.00 39.33           C  
ATOM   3628  CD1 TRP B 243      90.436  28.057  67.065  1.00 40.53           C  
ATOM   3629  CD2 TRP B 243      90.029  30.004  66.038  1.00 41.57           C  
ATOM   3630  NE1 TRP B 243      91.171  29.023  67.701  1.00 42.61           N  
ATOM   3631  CE2 TRP B 243      90.941  30.229  67.094  1.00 42.96           C  
ATOM   3632  CE3 TRP B 243      89.615  31.093  65.253  1.00 42.98           C  
ATOM   3633  CZ2 TRP B 243      91.452  31.500  67.388  1.00 42.86           C  
ATOM   3634  CZ3 TRP B 243      90.125  32.362  65.546  1.00 44.58           C  
ATOM   3635  CH2 TRP B 243      91.035  32.549  66.606  1.00 43.58           C  
ATOM   3636  N   SER B 244      89.169  25.161  62.682  1.00 28.44           N  
ATOM   3637  CA  SER B 244      88.375  24.447  61.689  1.00 24.50           C  
ATOM   3638  C   SER B 244      89.056  23.310  60.963  1.00 23.76           C  
ATOM   3639  O   SER B 244      90.141  23.473  60.392  1.00 22.56           O  
ATOM   3640  CB  SER B 244      87.788  25.390  60.641  1.00 21.93           C  
ATOM   3641  OG  SER B 244      86.870  24.684  59.825  1.00 15.79           O  
ATOM   3642  N   PRO B 245      88.433  22.122  61.005  1.00 23.52           N  
ATOM   3643  CA  PRO B 245      88.951  20.932  60.333  1.00 21.53           C  
ATOM   3644  C   PRO B 245      88.848  21.182  58.826  1.00 19.96           C  
ATOM   3645  O   PRO B 245      89.540  20.543  58.051  1.00 18.93           O  
ATOM   3646  CB  PRO B 245      87.963  19.841  60.751  1.00 20.71           C  
ATOM   3647  CG  PRO B 245      87.470  20.287  62.070  1.00 23.78           C  
ATOM   3648  CD  PRO B 245      87.287  21.780  61.866  1.00 23.68           C  
ATOM   3649  N   LEU B 246      87.946  22.086  58.423  1.00 17.70           N  
ATOM   3650  CA  LEU B 246      87.757  22.423  57.007  1.00 16.15           C  
ATOM   3651  C   LEU B 246      88.905  23.296  56.524  1.00 18.38           C  
ATOM   3652  O   LEU B 246      89.006  23.619  55.343  1.00 19.38           O  
ATOM   3653  CB  LEU B 246      86.425  23.129  56.781  1.00 12.32           C  
ATOM   3654  CG  LEU B 246      85.197  22.256  57.050  1.00 11.76           C  
ATOM   3655  CD1 LEU B 246      83.954  23.103  57.110  1.00  9.74           C  
ATOM   3656  CD2 LEU B 246      85.062  21.165  55.984  1.00 11.85           C  
ATOM   3657  N   ARG B 247      89.724  23.734  57.469  1.00 20.15           N  
ATOM   3658  CA  ARG B 247      90.906  24.536  57.181  1.00 23.44           C  
ATOM   3659  C   ARG B 247      90.773  25.847  56.395  1.00 24.12           C  
ATOM   3660  O   ARG B 247      91.465  26.063  55.390  1.00 23.64           O  
ATOM   3661  CB  ARG B 247      91.972  23.648  56.544  1.00 28.10           C  
ATOM   3662  CG  ARG B 247      92.491  22.587  57.460  1.00 33.82           C  
ATOM   3663  CD  ARG B 247      93.445  21.695  56.718  1.00 44.16           C  
ATOM   3664  NE  ARG B 247      94.535  21.292  57.599  1.00 54.39           N  
ATOM   3665  CZ  ARG B 247      95.769  21.785  57.540  1.00 58.02           C  
ATOM   3666  NH1 ARG B 247      96.089  22.701  56.629  1.00 58.79           N  
ATOM   3667  NH2 ARG B 247      96.671  21.404  58.437  1.00 62.75           N  
ATOM   3668  N   ARG B 248      89.875  26.716  56.851  1.00 22.40           N  
ATOM   3669  CA  ARG B 248      89.701  28.033  56.259  1.00 20.22           C  
ATOM   3670  C   ARG B 248      89.148  28.942  57.341  1.00 20.76           C  
ATOM   3671  O   ARG B 248      88.865  28.493  58.451  1.00 19.90           O  
ATOM   3672  CB  ARG B 248      88.790  28.023  55.021  1.00 19.17           C  
ATOM   3673  CG  ARG B 248      87.310  27.777  55.247  1.00 16.73           C  
ATOM   3674  CD  ARG B 248      86.568  28.082  53.959  1.00 17.08           C  
ATOM   3675  NE  ARG B 248      85.141  27.761  53.976  1.00 14.98           N  
ATOM   3676  CZ  ARG B 248      84.194  28.585  54.403  1.00 13.13           C  
ATOM   3677  NH1 ARG B 248      84.524  29.786  54.874  1.00 13.17           N  
ATOM   3678  NH2 ARG B 248      82.917  28.241  54.272  1.00 10.84           N  
ATOM   3679  N   VAL B 249      89.040  30.224  57.018  1.00 19.64           N  
ATOM   3680  CA  VAL B 249      88.525  31.218  57.941  1.00 19.19           C  
ATOM   3681  C   VAL B 249      87.038  31.439  57.672  1.00 19.02           C  
ATOM   3682  O   VAL B 249      86.576  31.329  56.534  1.00 20.84           O  
ATOM   3683  CB  VAL B 249      89.300  32.553  57.789  1.00 20.02           C  
ATOM   3684  CG1 VAL B 249      88.791  33.590  58.753  1.00 19.31           C  
ATOM   3685  CG2 VAL B 249      90.771  32.316  58.045  1.00 23.05           C  
ATOM   3686  N   GLY B 250      86.288  31.697  58.738  1.00 17.18           N  
ATOM   3687  CA  GLY B 250      84.869  31.945  58.611  1.00 16.50           C  
ATOM   3688  C   GLY B 250      84.673  33.337  58.057  1.00 15.44           C  
ATOM   3689  O   GLY B 250      85.394  34.257  58.421  1.00 16.25           O  
ATOM   3690  N   LEU B 251      83.682  33.498  57.193  1.00 15.47           N  
ATOM   3691  CA  LEU B 251      83.423  34.784  56.575  1.00 15.52           C  
ATOM   3692  C   LEU B 251      81.994  35.241  56.822  1.00 15.42           C  
ATOM   3693  O   LEU B 251      81.109  34.436  57.088  1.00 17.33           O  
ATOM   3694  CB  LEU B 251      83.683  34.672  55.064  1.00 16.09           C  
ATOM   3695  CG  LEU B 251      85.105  34.255  54.662  1.00 16.56           C  
ATOM   3696  CD1 LEU B 251      85.206  34.027  53.150  1.00 17.22           C  
ATOM   3697  CD2 LEU B 251      86.086  35.333  55.111  1.00 16.36           C  
ATOM   3698  N   PRO B 252      81.747  36.555  56.751  1.00 15.44           N  
ATOM   3699  CA  PRO B 252      80.386  37.035  56.974  1.00 13.99           C  
ATOM   3700  C   PRO B 252      79.323  36.298  56.165  1.00 14.72           C  
ATOM   3701  O   PRO B 252      78.239  36.033  56.669  1.00 17.71           O  
ATOM   3702  CB  PRO B 252      80.490  38.508  56.582  1.00 13.19           C  
ATOM   3703  CG  PRO B 252      81.828  38.874  57.070  1.00 11.06           C  
ATOM   3704  CD  PRO B 252      82.695  37.685  56.663  1.00 12.94           C  
ATOM   3705  N   ILE B 253      79.633  35.956  54.913  1.00 14.67           N  
ATOM   3706  CA  ILE B 253      78.681  35.247  54.039  1.00 13.57           C  
ATOM   3707  C   ILE B 253      78.305  33.854  54.598  1.00 12.75           C  
ATOM   3708  O   ILE B 253      77.214  33.363  54.364  1.00 13.05           O  
ATOM   3709  CB  ILE B 253      79.234  35.134  52.570  1.00 10.14           C  
ATOM   3710  CG1 ILE B 253      78.189  34.564  51.622  1.00  7.28           C  
ATOM   3711  CG2 ILE B 253      80.480  34.313  52.530  1.00 10.62           C  
ATOM   3712  CD1 ILE B 253      76.963  35.410  51.440  1.00  8.06           C  
ATOM   3713  N   ASP B 254      79.216  33.231  55.341  1.00 12.89           N  
ATOM   3714  CA  ASP B 254      78.943  31.930  55.930  1.00 13.23           C  
ATOM   3715  C   ASP B 254      77.777  32.063  56.897  1.00 14.58           C  
ATOM   3716  O   ASP B 254      76.942  31.165  57.004  1.00 13.83           O  
ATOM   3717  CB  ASP B 254      80.179  31.413  56.649  1.00 12.78           C  
ATOM   3718  CG  ASP B 254      81.251  30.929  55.691  1.00 12.19           C  
ATOM   3719  OD1 ASP B 254      80.911  30.159  54.777  1.00 15.75           O  
ATOM   3720  OD2 ASP B 254      82.429  31.284  55.862  1.00 14.46           O  
ATOM   3721  N   ILE B 255      77.696  33.214  57.557  1.00 13.84           N  
ATOM   3722  CA  ILE B 255      76.618  33.482  58.504  1.00 14.48           C  
ATOM   3723  C   ILE B 255      75.366  33.963  57.789  1.00 13.77           C  
ATOM   3724  O   ILE B 255      74.256  33.497  58.063  1.00 14.06           O  
ATOM   3725  CB  ILE B 255      77.043  34.562  59.530  1.00 14.87           C  
ATOM   3726  CG1 ILE B 255      78.388  34.191  60.153  1.00 12.95           C  
ATOM   3727  CG2 ILE B 255      75.959  34.748  60.591  1.00 16.06           C  
ATOM   3728  CD1 ILE B 255      78.447  32.776  60.716  1.00 11.86           C  
ATOM   3729  N   ALA B 256      75.555  34.876  56.839  1.00 13.16           N  
ATOM   3730  CA  ALA B 256      74.452  35.434  56.095  1.00 12.38           C  
ATOM   3731  C   ALA B 256      73.596  34.374  55.452  1.00 13.08           C  
ATOM   3732  O   ALA B 256      72.381  34.503  55.414  1.00 13.25           O  
ATOM   3733  CB  ALA B 256      74.962  36.402  55.041  1.00 12.85           C  
ATOM   3734  N   ARG B 257      74.232  33.343  54.912  1.00 15.24           N  
ATOM   3735  CA  ARG B 257      73.507  32.250  54.264  1.00 13.17           C  
ATOM   3736  C   ARG B 257      72.565  31.499  55.221  1.00 12.52           C  
ATOM   3737  O   ARG B 257      71.429  31.198  54.862  1.00 13.51           O  
ATOM   3738  CB  ARG B 257      74.510  31.298  53.611  1.00 12.58           C  
ATOM   3739  CG  ARG B 257      75.182  31.892  52.396  1.00 13.18           C  
ATOM   3740  CD  ARG B 257      76.375  31.073  51.966  1.00 14.20           C  
ATOM   3741  NE  ARG B 257      76.896  31.506  50.667  1.00 13.18           N  
ATOM   3742  CZ  ARG B 257      78.155  31.336  50.265  1.00 13.72           C  
ATOM   3743  NH1 ARG B 257      79.042  30.742  51.063  1.00  9.98           N  
ATOM   3744  NH2 ARG B 257      78.526  31.761  49.061  1.00 12.22           N  
ATOM   3745  N   VAL B 258      73.020  31.228  56.443  1.00 13.25           N  
ATOM   3746  CA  VAL B 258      72.189  30.519  57.427  1.00 14.61           C  
ATOM   3747  C   VAL B 258      71.014  31.398  57.865  1.00 14.79           C  
ATOM   3748  O   VAL B 258      69.889  30.927  58.037  1.00 15.34           O  
ATOM   3749  CB  VAL B 258      73.016  30.068  58.666  1.00 14.41           C  
ATOM   3750  CG1 VAL B 258      72.096  29.351  59.679  1.00 12.12           C  
ATOM   3751  CG2 VAL B 258      74.178  29.141  58.225  1.00 10.79           C  
ATOM   3752  N   VAL B 259      71.282  32.692  57.996  1.00 16.61           N  
ATOM   3753  CA  VAL B 259      70.260  33.650  58.365  1.00 13.19           C  
ATOM   3754  C   VAL B 259      69.155  33.609  57.312  1.00 12.57           C  
ATOM   3755  O   VAL B 259      67.974  33.574  57.643  1.00 14.86           O  
ATOM   3756  CB  VAL B 259      70.878  35.080  58.511  1.00 14.11           C  
ATOM   3757  CG1 VAL B 259      69.791  36.129  58.662  1.00 11.93           C  
ATOM   3758  CG2 VAL B 259      71.819  35.123  59.712  1.00  9.59           C  
ATOM   3759  N   CYS B 260      69.531  33.588  56.041  1.00 13.22           N  
ATOM   3760  CA  CYS B 260      68.545  33.534  54.963  1.00 14.24           C  
ATOM   3761  C   CYS B 260      67.717  32.245  55.012  1.00 13.17           C  
ATOM   3762  O   CYS B 260      66.523  32.253  54.706  1.00 13.73           O  
ATOM   3763  CB  CYS B 260      69.233  33.687  53.597  1.00 14.54           C  
ATOM   3764  SG  CYS B 260      69.904  35.346  53.320  1.00 16.74           S  
ATOM   3765  N   PHE B 261      68.365  31.133  55.359  1.00 14.20           N  
ATOM   3766  CA  PHE B 261      67.662  29.847  55.487  1.00 14.48           C  
ATOM   3767  C   PHE B 261      66.574  29.968  56.568  1.00 13.14           C  
ATOM   3768  O   PHE B 261      65.403  29.675  56.324  1.00 14.28           O  
ATOM   3769  CB  PHE B 261      68.650  28.727  55.860  1.00 14.80           C  
ATOM   3770  CG  PHE B 261      68.034  27.622  56.688  1.00 15.37           C  
ATOM   3771  CD1 PHE B 261      67.013  26.823  56.178  1.00 14.82           C  
ATOM   3772  CD2 PHE B 261      68.464  27.401  57.997  1.00 15.09           C  
ATOM   3773  CE1 PHE B 261      66.424  25.816  56.964  1.00 13.99           C  
ATOM   3774  CE2 PHE B 261      67.883  26.401  58.783  1.00 13.01           C  
ATOM   3775  CZ  PHE B 261      66.865  25.613  58.266  1.00 10.73           C  
ATOM   3776  N   LEU B 262      66.976  30.404  57.762  1.00 13.23           N  
ATOM   3777  CA  LEU B 262      66.056  30.568  58.888  1.00 11.89           C  
ATOM   3778  C   LEU B 262      64.941  31.538  58.539  1.00 13.93           C  
ATOM   3779  O   LEU B 262      63.768  31.300  58.842  1.00 15.97           O  
ATOM   3780  CB  LEU B 262      66.819  31.086  60.106  1.00  8.90           C  
ATOM   3781  CG  LEU B 262      67.811  30.108  60.722  1.00 10.38           C  
ATOM   3782  CD1 LEU B 262      68.726  30.807  61.682  1.00  9.46           C  
ATOM   3783  CD2 LEU B 262      67.034  28.987  61.418  1.00  9.73           C  
ATOM   3784  N   ALA B 263      65.307  32.619  57.862  1.00 15.46           N  
ATOM   3785  CA  ALA B 263      64.357  33.647  57.457  1.00 14.84           C  
ATOM   3786  C   ALA B 263      63.384  33.172  56.383  1.00 16.91           C  
ATOM   3787  O   ALA B 263      62.331  33.784  56.204  1.00 17.39           O  
ATOM   3788  CB  ALA B 263      65.108  34.901  56.994  1.00 12.43           C  
ATOM   3789  N   SER B 264      63.694  32.053  55.720  1.00 15.69           N  
ATOM   3790  CA  SER B 264      62.829  31.516  54.669  1.00 15.49           C  
ATOM   3791  C   SER B 264      61.822  30.511  55.177  1.00 17.62           C  
ATOM   3792  O   SER B 264      61.834  30.143  56.360  1.00 19.25           O  
ATOM   3793  CB  SER B 264      63.657  30.869  53.547  1.00 14.56           C  
ATOM   3794  OG  SER B 264      64.302  29.679  53.965  1.00 15.31           O  
ATOM   3795  N   ASN B 265      60.946  30.067  54.274  1.00 16.91           N  
ATOM   3796  CA  ASN B 265      59.933  29.086  54.607  1.00 16.53           C  
ATOM   3797  C   ASN B 265      60.606  27.754  54.929  1.00 16.70           C  
ATOM   3798  O   ASN B 265      59.991  26.894  55.536  1.00 18.76           O  
ATOM   3799  CB  ASN B 265      58.931  28.932  53.465  1.00 17.12           C  
ATOM   3800  CG  ASN B 265      57.793  27.975  53.804  1.00 21.51           C  
ATOM   3801  OD1 ASN B 265      56.930  28.287  54.625  1.00 18.50           O  
ATOM   3802  ND2 ASN B 265      57.784  26.806  53.161  1.00 19.96           N  
ATOM   3803  N   ASP B 266      61.861  27.578  54.516  1.00 15.77           N  
ATOM   3804  CA  ASP B 266      62.608  26.355  54.804  1.00 15.47           C  
ATOM   3805  C   ASP B 266      62.863  26.230  56.298  1.00 15.87           C  
ATOM   3806  O   ASP B 266      63.097  25.122  56.804  1.00 16.14           O  
ATOM   3807  CB  ASP B 266      63.969  26.364  54.092  1.00 14.96           C  
ATOM   3808  CG  ASP B 266      63.872  26.045  52.599  1.00 14.97           C  
ATOM   3809  OD1 ASP B 266      64.876  26.239  51.889  1.00 15.76           O  
ATOM   3810  OD2 ASP B 266      62.812  25.590  52.135  1.00 19.68           O  
ATOM   3811  N   GLY B 267      62.876  27.379  56.981  1.00 15.49           N  
ATOM   3812  CA  GLY B 267      63.121  27.431  58.415  1.00 13.70           C  
ATOM   3813  C   GLY B 267      61.867  27.397  59.262  1.00 13.38           C  
ATOM   3814  O   GLY B 267      61.954  27.552  60.469  1.00 15.14           O  
ATOM   3815  N   GLY B 268      60.729  27.133  58.631  1.00 12.59           N  
ATOM   3816  CA  GLY B 268      59.441  27.100  59.302  1.00 14.92           C  
ATOM   3817  C   GLY B 268      59.265  26.203  60.514  1.00 16.02           C  
ATOM   3818  O   GLY B 268      58.495  26.551  61.412  1.00 15.95           O  
ATOM   3819  N   TRP B 269      59.930  25.050  60.541  1.00 15.30           N  
ATOM   3820  CA  TRP B 269      59.806  24.160  61.687  1.00 15.77           C  
ATOM   3821  C   TRP B 269      61.004  24.258  62.618  1.00 14.64           C  
ATOM   3822  O   TRP B 269      61.148  23.490  63.570  1.00 14.48           O  
ATOM   3823  CB  TRP B 269      59.528  22.719  61.264  1.00 15.70           C  
ATOM   3824  CG  TRP B 269      58.657  21.911  62.274  1.00 16.62           C  
ATOM   3825  CD1 TRP B 269      58.916  20.650  62.748  1.00 14.98           C  
ATOM   3826  CD2 TRP B 269      57.408  22.312  62.885  1.00 16.12           C  
ATOM   3827  NE1 TRP B 269      57.917  20.247  63.593  1.00 11.82           N  
ATOM   3828  CE2 TRP B 269      56.983  21.242  63.703  1.00 16.29           C  
ATOM   3829  CE3 TRP B 269      56.617  23.471  62.827  1.00 16.92           C  
ATOM   3830  CZ2 TRP B 269      55.801  21.295  64.460  1.00 14.79           C  
ATOM   3831  CZ3 TRP B 269      55.438  23.520  63.582  1.00 15.34           C  
ATOM   3832  CH2 TRP B 269      55.047  22.436  64.387  1.00 14.26           C  
ATOM   3833  N   VAL B 270      61.849  25.247  62.358  1.00 13.96           N  
ATOM   3834  CA  VAL B 270      63.005  25.513  63.202  1.00 12.96           C  
ATOM   3835  C   VAL B 270      62.685  26.769  64.056  1.00 15.51           C  
ATOM   3836  O   VAL B 270      62.529  27.887  63.528  1.00 12.68           O  
ATOM   3837  CB  VAL B 270      64.293  25.750  62.352  1.00 12.95           C  
ATOM   3838  CG1 VAL B 270      65.528  25.929  63.244  1.00 11.34           C  
ATOM   3839  CG2 VAL B 270      64.514  24.592  61.414  1.00 10.24           C  
ATOM   3840  N   THR B 271      62.456  26.552  65.354  1.00 15.94           N  
ATOM   3841  CA  THR B 271      62.189  27.647  66.289  1.00 15.95           C  
ATOM   3842  C   THR B 271      62.713  27.278  67.684  1.00 16.16           C  
ATOM   3843  O   THR B 271      62.721  26.112  68.065  1.00 15.26           O  
ATOM   3844  CB  THR B 271      60.709  28.068  66.293  1.00 15.67           C  
ATOM   3845  OG1 THR B 271      60.558  29.296  67.018  1.00 16.59           O  
ATOM   3846  CG2 THR B 271      59.828  26.994  66.889  1.00 13.88           C  
ATOM   3847  N   GLY B 272      63.234  28.271  68.397  1.00 15.13           N  
ATOM   3848  CA  GLY B 272      63.805  28.060  69.713  1.00 13.94           C  
ATOM   3849  C   GLY B 272      65.150  27.355  69.651  1.00 15.77           C  
ATOM   3850  O   GLY B 272      65.615  26.805  70.656  1.00 16.88           O  
ATOM   3851  N   LYS B 273      65.785  27.372  68.480  1.00 13.95           N  
ATOM   3852  CA  LYS B 273      67.057  26.694  68.294  1.00 13.96           C  
ATOM   3853  C   LYS B 273      68.270  27.606  68.224  1.00 14.45           C  
ATOM   3854  O   LYS B 273      68.153  28.800  67.954  1.00 14.27           O  
ATOM   3855  CB  LYS B 273      66.990  25.818  67.036  1.00 11.83           C  
ATOM   3856  CG  LYS B 273      65.878  24.779  67.061  1.00  9.92           C  
ATOM   3857  CD  LYS B 273      66.091  23.802  68.217  1.00 10.44           C  
ATOM   3858  CE  LYS B 273      64.946  22.799  68.370  1.00  6.64           C  
ATOM   3859  NZ  LYS B 273      63.628  23.360  68.798  1.00  8.80           N  
ATOM   3860  N   VAL B 274      69.433  27.037  68.509  1.00 13.74           N  
ATOM   3861  CA  VAL B 274      70.693  27.755  68.437  1.00 13.47           C  
ATOM   3862  C   VAL B 274      71.510  27.030  67.350  1.00 16.38           C  
ATOM   3863  O   VAL B 274      71.850  25.854  67.509  1.00 14.05           O  
ATOM   3864  CB  VAL B 274      71.435  27.703  69.788  1.00 14.10           C  
ATOM   3865  CG1 VAL B 274      72.818  28.378  69.683  1.00 10.10           C  
ATOM   3866  CG2 VAL B 274      70.575  28.370  70.877  1.00 14.16           C  
ATOM   3867  N   ILE B 275      71.764  27.709  66.226  1.00 17.68           N  
ATOM   3868  CA  ILE B 275      72.524  27.119  65.101  1.00 15.69           C  
ATOM   3869  C   ILE B 275      73.983  27.539  65.149  1.00 14.54           C  
ATOM   3870  O   ILE B 275      74.286  28.714  64.942  1.00 15.49           O  
ATOM   3871  CB  ILE B 275      71.946  27.563  63.722  1.00 16.57           C  
ATOM   3872  CG1 ILE B 275      70.421  27.499  63.717  1.00 17.72           C  
ATOM   3873  CG2 ILE B 275      72.496  26.684  62.597  1.00 16.21           C  
ATOM   3874  CD1 ILE B 275      69.836  26.179  64.098  1.00 15.73           C  
ATOM   3875  N   GLY B 276      74.883  26.597  65.426  1.00 12.02           N  
ATOM   3876  CA  GLY B 276      76.301  26.919  65.494  1.00 14.13           C  
ATOM   3877  C   GLY B 276      76.869  27.018  64.086  1.00 16.35           C  
ATOM   3878  O   GLY B 276      76.656  26.119  63.273  1.00 19.27           O  
ATOM   3879  N   ILE B 277      77.584  28.096  63.785  1.00 14.40           N  
ATOM   3880  CA  ILE B 277      78.156  28.304  62.450  1.00 13.76           C  
ATOM   3881  C   ILE B 277      79.596  28.667  62.644  1.00 13.72           C  
ATOM   3882  O   ILE B 277      79.952  29.840  62.626  1.00 14.88           O  
ATOM   3883  CB  ILE B 277      77.450  29.442  61.695  1.00 14.42           C  
ATOM   3884  CG1 ILE B 277      75.939  29.353  61.913  1.00 11.59           C  
ATOM   3885  CG2 ILE B 277      77.744  29.341  60.196  1.00 12.42           C  
ATOM   3886  CD1 ILE B 277      75.190  30.613  61.580  1.00 11.96           C  
ATOM   3887  N   ASP B 278      80.432  27.644  62.764  1.00 11.92           N  
ATOM   3888  CA  ASP B 278      81.831  27.841  63.039  1.00 13.33           C  
ATOM   3889  C   ASP B 278      82.760  26.872  62.327  1.00 12.58           C  
ATOM   3890  O   ASP B 278      83.915  26.739  62.720  1.00 13.09           O  
ATOM   3891  CB  ASP B 278      82.038  27.690  64.538  1.00 15.94           C  
ATOM   3892  CG  ASP B 278      81.396  26.407  65.084  1.00 21.03           C  
ATOM   3893  OD1 ASP B 278      81.437  25.371  64.393  1.00 17.14           O  
ATOM   3894  OD2 ASP B 278      80.810  26.441  66.185  1.00 24.66           O  
ATOM   3895  N   GLY B 279      82.255  26.176  61.314  1.00 15.32           N  
ATOM   3896  CA  GLY B 279      83.084  25.229  60.574  1.00 17.07           C  
ATOM   3897  C   GLY B 279      83.631  24.052  61.372  1.00 17.94           C  
ATOM   3898  O   GLY B 279      84.666  23.493  61.018  1.00 16.83           O  
ATOM   3899  N   GLY B 280      82.912  23.639  62.415  1.00 18.34           N  
ATOM   3900  CA  GLY B 280      83.376  22.530  63.237  1.00 19.21           C  
ATOM   3901  C   GLY B 280      84.438  22.882  64.272  1.00 20.66           C  
ATOM   3902  O   GLY B 280      85.228  22.037  64.662  1.00 22.70           O  
ATOM   3903  N   ALA B 281      84.445  24.132  64.726  1.00 23.52           N  
ATOM   3904  CA  ALA B 281      85.385  24.619  65.736  1.00 23.75           C  
ATOM   3905  C   ALA B 281      85.115  24.044  67.121  1.00 25.16           C  
ATOM   3906  O   ALA B 281      83.998  23.622  67.438  1.00 26.79           O  
ATOM   3907  CB  ALA B 281      85.324  26.144  65.816  1.00 22.03           C  
ATOM   3908  N   CYS B 282      86.152  24.074  67.947  1.00 25.89           N  
ATOM   3909  CA  CYS B 282      86.091  23.603  69.325  1.00 27.03           C  
ATOM   3910  C   CYS B 282      86.832  24.637  70.163  1.00 28.60           C  
ATOM   3911  O   CYS B 282      88.064  24.688  70.161  1.00 29.86           O  
ATOM   3912  CB  CYS B 282      86.769  22.249  69.481  1.00 26.57           C  
ATOM   3913  SG  CYS B 282      86.894  21.726  71.205  1.00 30.08           S  
ATOM   3914  N   MET B 283      86.079  25.490  70.848  1.00 30.23           N  
ATOM   3915  CA  MET B 283      86.667  26.539  71.670  1.00 29.84           C  
ATOM   3916  C   MET B 283      86.162  26.534  73.103  1.00 30.42           C  
ATOM   3917  O   MET B 283      86.720  27.308  73.912  1.00 30.03           O  
ATOM   3918  CB  MET B 283      86.425  27.900  71.026  1.00 30.36           C  
ATOM   3919  CG  MET B 283      87.397  28.200  69.893  1.00 33.74           C  
ATOM   3920  SD  MET B 283      86.901  29.596  68.864  1.00 34.18           S  
ATOM   3921  CE  MET B 283      86.249  28.733  67.659  1.00 37.59           C  
ATOM   3922  OXT MET B 283      85.241  25.743  73.396  1.00 26.91           O  
TER    3923      MET B 283                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
