
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  259 ( 1975),  selected  259 , name 1ipe_A
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1ipe_A.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      -       -           -
LGA    G     3_A      -       -           -
LGA    R     4_A      -       -           -
LGA    W     5_A      M       1          1.684
LGA    N     6_A      T       2          1.368
LGA    L     7_A      L       3          1.385
LGA    E     8_A      S       4          1.818
LGA    G     9_A      G       5          1.895
LGA    C    10_A      K       6          1.181
LGA    T    11_A      T       7          0.882
LGA    A    12_A      L       8          0.794
LGA    L    13_A      F       9          0.323
LGA    V    14_A      I      10          0.382
LGA    T    15_A      T      11          0.341
LGA    G    16_A      G      12          0.588
LGA    G    17_A      A      13          0.486
LGA    S    18_A      S      14          0.872
LGA    R    19_A      R      15          1.028
LGA    G    20_A      G      16          0.816
LGA    I    21_A      I      17          0.647
LGA    G    22_A      G      18          0.681
LGA    Y    23_A      L      19          0.881
LGA    G    24_A      A      20          0.598
LGA    I    25_A      I      21          0.610
LGA    V    26_A      A      22          0.309
LGA    E    27_A      L      23          0.882
LGA    E    28_A      R      24          1.136
LGA    L    29_A      A      25          1.273
LGA    A    30_A      A      26          1.343
LGA    S    31_A      R      27          1.424
LGA    L    32_A      D      28          2.547
LGA    G    33_A      G      29          2.913
LGA    A    34_A      A      30          1.587
LGA    S    35_A      N      31          1.051
LGA    V    36_A      V      32          0.811
LGA    Y    37_A      A      33          0.488
LGA    T    38_A      I      34          0.831
LGA    C    39_A      A      35          1.889
LGA    S    40_A      A      36          1.720
LGA    R    41_A      K      37          1.252
LGA    N    42_A      S      38          1.136
LGA    Q    43_A      A      39          0.899
LGA    K    44_A      V      40          2.464
LGA    -       -      A      41           -
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    E    45_A      T      48          2.048
LGA    L    46_A      I      49          2.199
LGA    N    47_A      H      50          2.041
LGA    D    48_A      S      51          2.254
LGA    C    49_A      A      52          2.469
LGA    L    50_A      A      53          2.583
LGA    T    51_A      A      54          2.672
LGA    Q    52_A      A      55          2.709
LGA    W    53_A      V      56          2.792
LGA    R    54_A      N      57          1.765
LGA    S    55_A      A      58          2.258
LGA    K    56_A      A      59          2.811
LGA    G    57_A      G      60          2.508
LGA    F    58_A      G      61          2.128
LGA    K    59_A      Q      62          1.455
LGA    V    60_A      G      63          1.197
LGA    E    61_A      L      64          1.055
LGA    A    62_A      A      65          1.293
LGA    S    63_A      L      66          1.207
LGA    V    64_A      K      67          0.989
LGA    C    65_A      C      68          1.079
LGA    D    66_A      D      69          0.887
LGA    L    67_A      I      70          0.907
LGA    S    68_A      R      71          0.990
LGA    S    69_A      E      72          1.138
LGA    R    70_A      E      73          1.713
LGA    S    71_A      D      74          1.572
LGA    E    72_A      Q      75          1.443
LGA    R    73_A      V      76          1.639
LGA    Q    74_A      R      77          1.545
LGA    E    75_A      A      78          1.539
LGA    L    76_A      A      79          1.386
LGA    M    77_A      V      80          1.594
LGA    N    78_A      A      81          1.657
LGA    T    79_A      A      82          1.347
LGA    V    80_A      T      83          1.706
LGA    A    81_A      V      84          2.076
LGA    N    82_A      D      85          1.574
LGA    H    83_A      T      86          1.758
LGA    F    84_A      F      87          2.308
LGA    H    85_A      G      88          1.976
LGA    G    86_A      G      89          3.540
LGA    K    87_A      -       -           -
LGA    L    88_A      I      90          1.252
LGA    N    89_A      D      91          0.922
LGA    I    90_A      I      92          0.358
LGA    L    91_A      L      93          0.193
LGA    V    92_A      V      94          0.241
LGA    N    93_A      N      95          0.487
LGA    N    94_A      N      96          0.321
LGA    A    95_A      A      97          2.139
LGA    G    96_A      S      98          2.440
LGA    I    97_A      A      99          1.053
LGA    V    98_A      I     100          1.497
LGA    I    99_A      W     101          2.685
LGA    Y   100_A      L     102          3.481
LGA    K   101_A      R     103          2.749
LGA    E   102_A      G     104          1.610
LGA    A   103_A      T     105          1.686
LGA    K   104_A      L     106          2.031
LGA    D   105_A      D     107          1.848
LGA    Y   106_A      T     108          1.681
LGA    T   107_A      P     109          2.032
LGA    V   108_A      M     110          2.052
LGA    E   109_A      K     111          2.102
LGA    D   110_A      R     112          2.074
LGA    Y   111_A      F     113          1.762
LGA    S   112_A      D     114          1.694
LGA    L   113_A      L     115          1.581
LGA    I   114_A      M     116          1.099
LGA    M   115_A      Q     117          0.559
LGA    S   116_A      Q     118          0.897
LGA    I   117_A      V     119          1.036
LGA    N   118_A      N     120          0.863
LGA    F   119_A      A     121          0.844
LGA    E   120_A      R     122          0.683
LGA    A   121_A      G     123          1.479
LGA    A   122_A      S     124          0.867
LGA    Y   123_A      F     125          0.403
LGA    H   124_A      V     126          1.016
LGA    L   125_A      C     127          0.908
LGA    S   126_A      A     128          0.095
LGA    V   127_A      Q     129          0.894
LGA    L   128_A      A     130          1.099
LGA    A   129_A      C     131          0.737
LGA    H   130_A      L     132          0.681
LGA    P   131_A      P     133          0.736
LGA    F   132_A      H     134          0.430
LGA    L   133_A      L     135          0.145
LGA    K   134_A      L     136          0.718
LGA    A   135_A      Q     137          1.360
LGA    S   136_A      A     138          1.161
LGA    E   137_A      P     139          3.151
LGA    R   138_A      N     140          2.011
LGA    G   139_A      P     141          0.894
LGA    N   140_A      H     142          0.451
LGA    V   141_A      I     143          0.259
LGA    V   142_A      L     144          0.440
LGA    F   143_A      T     145          0.472
LGA    I   144_A      L     146          0.595
LGA    S   145_A      A     147          0.887
LGA    S   146_A      P     148          3.906
LGA    V   147_A      P     149           #
LGA    S   148_A      -       -           -
LGA    G   149_A      P     150           #
LGA    A   150_A      S     151          3.988
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    L   151_A      W     156          3.777
LGA    -       -      W     157           -
LGA    A   152_A      G     158           #
LGA    V   153_A      A     159          5.477
LGA    P   154_A      -       -           -
LGA    Y   155_A      -       -           -
LGA    E   156_A      H     160          3.889
LGA    A   157_A      T     161          2.845
LGA    V   158_A      G     162          1.517
LGA    Y   159_A      Y     163          1.408
LGA    G   160_A      T     164          1.545
LGA    A   161_A      L     165          1.203
LGA    T   162_A      A     166          1.398
LGA    K   163_A      K     167          1.843
LGA    G   164_A      M     168          1.497
LGA    A   165_A      G     169          2.022
LGA    M   166_A      M     170          1.931
LGA    D   167_A      S     171          1.376
LGA    Q   168_A      L     172          2.123
LGA    L   169_A      V     173          2.186
LGA    T   170_A      T     174          1.500
LGA    R   171_A      L     175          2.191
LGA    C   172_A      G     176          2.508
LGA    L   173_A      L     177          1.807
LGA    A   174_A      A     178          1.714
LGA    F   175_A      A     179          2.358
LGA    E   176_A      E     180          1.330
LGA    W   177_A      F     181          0.946
LGA    A   178_A      G     182          2.508
LGA    K   179_A      P     183          3.626
LGA    D   180_A      Q     184          2.662
LGA    N   181_A      G     185          1.894
LGA    I   182_A      V     186          0.570
LGA    R   183_A      A     187          0.912
LGA    V   184_A      I     188          0.502
LGA    N   185_A      N     189          0.337
LGA    G   186_A      A     190          0.324
LGA    V   187_A      L     191          0.869
LGA    G   188_A      W     192          1.810
LGA    P   189_A      P     193          2.806
LGA    -       -      R     194           -
LGA    G   190_A      T     195          3.630
LGA    V   191_A      V     196          0.694
LGA    I   192_A      I     197          0.267
LGA    A   193_A      A     198          0.587
LGA    T   194_A      T     199          0.864
LGA    S   195_A      D     200          1.701
LGA    L   196_A      A     201          1.546
LGA    V   197_A      I     202          1.664
LGA    E   198_A      -       -           -
LGA    M   199_A      N     203          2.801
LGA    T   200_A      M     204          3.443
LGA    I   201_A      L     205          5.920
LGA    Q   202_A      -       -           -
LGA    D   203_A      -       -           -
LGA    P   204_A      -       -           -
LGA    E   205_A      -       -           -
LGA    Q   206_A      P     206          0.714
LGA    K   207_A      G     207          1.162
LGA    E   208_A      -       -           -
LGA    N   209_A      -       -           -
LGA    L   210_A      -       -           -
LGA    N   211_A      V     208          4.722
LGA    K   212_A      D     209           -
LGA    L   213_A      A     210           -
LGA    I   214_A      A     211           -
LGA    D   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    C   217_A      -       -           -
LGA    A   218_A      -       -           -
LGA    L   219_A      -       -           -
LGA    R   220_A      -       -           -
LGA    R   221_A      A     212          4.006
LGA    M   222_A      C     213          1.287
LGA    G   223_A      R     214          1.762
LGA    E   224_A      R     215          1.287
LGA    P   225_A      P     216          0.472
LGA    K   226_A      E     217          0.587
LGA    E   227_A      I     218          0.187
LGA    L   228_A      M     219          1.025
LGA    A   229_A      A     220          1.512
LGA    A   230_A      D     221          1.459
LGA    M   231_A      A     222          1.597
LGA    V   232_A      A     223          1.474
LGA    A   233_A      H     224          1.464
LGA    F   234_A      A     225          1.363
LGA    L   235_A      V     226          1.448
LGA    C   236_A      L     227          1.174
LGA    F   237_A      T     228          1.005
LGA    P   238_A      R     229          3.150
LGA    A   239_A      E     230          4.829
LGA    A   240_A      A     231           #
LGA    S   241_A      A     232          5.036
LGA    Y   242_A      G     233          4.170
LGA    V   243_A      F     234          2.947
LGA    T   244_A      H     235          1.641
LGA    G   245_A      G     236          0.649
LGA    Q   246_A      Q     237          0.820
LGA    I   247_A      F     238          0.873
LGA    I   248_A      L     239          1.471
LGA    Y   249_A      I     240          2.512
LGA    V   250_A      D     241          3.073
LGA    D   251_A      D     242           #
LGA    -       -      E     243           -
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    G   252_A      L     264           #
LGA    G   253_A      L     265           -
LGA    L   254_A      P     266          3.829
LGA    -       -      D     267           -
LGA    -       -      L     268           -
LGA    -       -      F     269           -
LGA    -       -      L     270           -
LGA    M   255_A      E     271          3.162
LGA    A   256_A      -       -           -
LGA    N   257_A      -       -           -
LGA    C   258_A      -       -           -
LGA    G   259_A      -       -           -
LGA    F   260_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  259  271    5.0    223    1.92    21.97     71.269    11.064

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.715269 * X  +   0.698845 * Y  +   0.002531 * Z  +  65.161369
  Y_new =  -0.484364 * X  +  -0.498350 * Y  +   0.719054 * Z  + -51.158428
  Z_new =   0.503768 * X  +   0.513091 * Y  +   0.694950 * Z  + -53.601242 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.635980   -2.505613  [ DEG:    36.4390   -143.5610 ]
  Theta =  -0.527956   -2.613637  [ DEG:   -30.2496   -149.7504 ]
  Phi   =  -2.546349    0.595244  [ DEG:  -145.8950     34.1050 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ipe_A                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ipe_A.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  259  271   5.0  223   1.92   21.97  71.269
REMARK  ---------------------------------------------------------- 
MOLECULE 1ipe_A
HEADER    OXIDOREDUCTASE                          09-MAY-01   1IPE              
TITLE     TROPINONE REDUCTASE-II COMPLEXED WITH NADPH                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TROPINONE REDUCTASE-II;                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.1.1.236;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DATURA STRAMONIUM;                              
SOURCE   3 ORGANISM_COMMON: JIMSONWEED;                                         
SOURCE   4 ORGAN: CULTURED ROOT;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PET21D;                                    
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PETTR2                                    
KEYWDS    OXIDOREDUCTASE, TROPANE ALKALOID BIOSYNTHESIS, REDUCTION OF           
KEYWDS   2 TROPINONE TO PSEUDOTROPINE, SHORT-CHAIN DEHYDROGENASE, LAUE          
KEYWDS   3 DIFFRACTION, RIKEN STRUCTURAL GENOMICS/PROTEOMICS                    
KEYWDS   4 INITIATIVE, RSGI, STRUCTURAL GENOMICS                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.YAMASHITA,M.ENDO,T.HIGASHI,T.NAKATSU,Y.YAMADA,J.ODA,                
AUTHOR   2 H.KATO,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE               
AUTHOR   3 (RSGI)                                                               
REVDAT   1   03-JUN-03 1IPE    0                                                
JRNL        AUTH   A.YAMASHITA,M.ENDO,T.HIGASHI,T.NAKATSU,Y.YAMADA,             
JRNL        AUTH 2 J.ODA,H.KATO                                                 
JRNL        TITL   CAPTURING ENZYME STRUCTURE PRIOR TO REACTION                 
JRNL        TITL 2 INITIATION: TROPINONE REDUCTASE-II-SUBSTRATE                 
JRNL        TITL 3 COMPLEXES                                                    
JRNL        REF    BIOCHEMISTRY                  V.  42  5566 2003              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1IPE A    2   260  UNP    P50163   TRN2_DATST       2    260             
DBREF  1IPE B    2   260  UNP    P50163   TRN2_DATST       2    260             
SEQRES   1 A  259  ALA GLY ARG TRP ASN LEU GLU GLY CYS THR ALA LEU VAL          
SEQRES   2 A  259  THR GLY GLY SER ARG GLY ILE GLY TYR GLY ILE VAL GLU          
SEQRES   3 A  259  GLU LEU ALA SER LEU GLY ALA SER VAL TYR THR CYS SER          
SEQRES   4 A  259  ARG ASN GLN LYS GLU LEU ASN ASP CYS LEU THR GLN TRP          
SEQRES   5 A  259  ARG SER LYS GLY PHE LYS VAL GLU ALA SER VAL CYS ASP          
SEQRES   6 A  259  LEU SER SER ARG SER GLU ARG GLN GLU LEU MET ASN THR          
SEQRES   7 A  259  VAL ALA ASN HIS PHE HIS GLY LYS LEU ASN ILE LEU VAL          
SEQRES   8 A  259  ASN ASN ALA GLY ILE VAL ILE TYR LYS GLU ALA LYS ASP          
SEQRES   9 A  259  TYR THR VAL GLU ASP TYR SER LEU ILE MET SER ILE ASN          
SEQRES  10 A  259  PHE GLU ALA ALA TYR HIS LEU SER VAL LEU ALA HIS PRO          
SEQRES  11 A  259  PHE LEU LYS ALA SER GLU ARG GLY ASN VAL VAL PHE ILE          
SEQRES  12 A  259  SER SER VAL SER GLY ALA LEU ALA VAL PRO TYR GLU ALA          
SEQRES  13 A  259  VAL TYR GLY ALA THR LYS GLY ALA MET ASP GLN LEU THR          
SEQRES  14 A  259  ARG CYS LEU ALA PHE GLU TRP ALA LYS ASP ASN ILE ARG          
SEQRES  15 A  259  VAL ASN GLY VAL GLY PRO GLY VAL ILE ALA THR SER LEU          
SEQRES  16 A  259  VAL GLU MET THR ILE GLN ASP PRO GLU GLN LYS GLU ASN          
SEQRES  17 A  259  LEU ASN LYS LEU ILE ASP ARG CYS ALA LEU ARG ARG MET          
SEQRES  18 A  259  GLY GLU PRO LYS GLU LEU ALA ALA MET VAL ALA PHE LEU          
SEQRES  19 A  259  CYS PHE PRO ALA ALA SER TYR VAL THR GLY GLN ILE ILE          
SEQRES  20 A  259  TYR VAL ASP GLY GLY LEU MET ALA ASN CYS GLY PHE              
SEQRES   1 B  259  ALA GLY ARG TRP ASN LEU GLU GLY CYS THR ALA LEU VAL          
SEQRES   2 B  259  THR GLY GLY SER ARG GLY ILE GLY TYR GLY ILE VAL GLU          
SEQRES   3 B  259  GLU LEU ALA SER LEU GLY ALA SER VAL TYR THR CYS SER          
SEQRES   4 B  259  ARG ASN GLN LYS GLU LEU ASN ASP CYS LEU THR GLN TRP          
SEQRES   5 B  259  ARG SER LYS GLY PHE LYS VAL GLU ALA SER VAL CYS ASP          
SEQRES   6 B  259  LEU SER SER ARG SER GLU ARG GLN GLU LEU MET ASN THR          
SEQRES   7 B  259  VAL ALA ASN HIS PHE HIS GLY LYS LEU ASN ILE LEU VAL          
SEQRES   8 B  259  ASN ASN ALA GLY ILE VAL ILE TYR LYS GLU ALA LYS ASP          
SEQRES   9 B  259  TYR THR VAL GLU ASP TYR SER LEU ILE MET SER ILE ASN          
SEQRES  10 B  259  PHE GLU ALA ALA TYR HIS LEU SER VAL LEU ALA HIS PRO          
SEQRES  11 B  259  PHE LEU LYS ALA SER GLU ARG GLY ASN VAL VAL PHE ILE          
SEQRES  12 B  259  SER SER VAL SER GLY ALA LEU ALA VAL PRO TYR GLU ALA          
SEQRES  13 B  259  VAL TYR GLY ALA THR LYS GLY ALA MET ASP GLN LEU THR          
SEQRES  14 B  259  ARG CYS LEU ALA PHE GLU TRP ALA LYS ASP ASN ILE ARG          
SEQRES  15 B  259  VAL ASN GLY VAL GLY PRO GLY VAL ILE ALA THR SER LEU          
SEQRES  16 B  259  VAL GLU MET THR ILE GLN ASP PRO GLU GLN LYS GLU ASN          
SEQRES  17 B  259  LEU ASN LYS LEU ILE ASP ARG CYS ALA LEU ARG ARG MET          
SEQRES  18 B  259  GLY GLU PRO LYS GLU LEU ALA ALA MET VAL ALA PHE LEU          
SEQRES  19 B  259  CYS PHE PRO ALA ALA SER TYR VAL THR GLY GLN ILE ILE          
SEQRES  20 B  259  TYR VAL ASP GLY GLY LEU MET ALA ASN CYS GLY PHE              
HET    NDP    261      48                                                       
HET    NDP    262      48                                                       
HETNAM     NDP NADPH DIHYDRO-NICOTINAMIDE-ADENINE-DINUCLEOTIDE                  
HETNAM   2 NDP  PHOSPHATE                                                       
FORMUL   3  NDP    2(C21 H30 N7 O17 P3)                                         
FORMUL   5  HOH   *61(H2 O)                                                     
CRYST1   88.600   88.600  338.900  90.00  90.00 120.00 P 61 2 2     24          
ATOM      1  N   ALA A   2      57.060  34.600  49.356  1.00 32.31           N  
ATOM      2  CA  ALA A   2      58.382  34.004  49.010  1.00 32.23           C  
ATOM      3  C   ALA A   2      58.249  32.537  48.600  1.00 32.08           C  
ATOM      4  O   ALA A   2      57.392  31.812  49.112  1.00 38.10           O  
ATOM      5  CB  ALA A   2      59.337  34.130  50.208  1.00 28.50           C  
ATOM      6  N   GLY A   3      59.086  32.109  47.660  1.00 30.68           N  
ATOM      7  CA  GLY A   3      59.064  30.721  47.240  1.00 22.44           C  
ATOM      8  C   GLY A   3      59.650  29.944  48.404  1.00 18.52           C  
ATOM      9  O   GLY A   3      60.041  30.543  49.410  1.00 17.01           O  
ATOM     10  N   ARG A   4      59.743  28.628  48.284  1.00 13.65           N  
ATOM     11  CA  ARG A   4      60.275  27.824  49.377  1.00 12.05           C  
ATOM     12  C   ARG A   4      61.742  28.079  49.700  1.00 14.91           C  
ATOM     13  O   ARG A   4      62.144  27.999  50.861  1.00 18.20           O  
ATOM     14  CB  ARG A   4      60.079  26.338  49.079  1.00 15.00           C  
ATOM     15  CG  ARG A   4      60.363  25.428  50.263  1.00 21.02           C  
ATOM     16  CD  ARG A   4      59.258  24.395  50.488  1.00 21.86           C  
ATOM     17  NE  ARG A   4      59.757  23.241  51.233  1.00 12.16           N  
ATOM     18  CZ  ARG A   4      60.777  22.488  50.838  1.00 13.39           C  
ATOM     19  NH1 ARG A   4      61.404  22.765  49.703  1.00 13.68           N  
ATOM     20  NH2 ARG A   4      61.184  21.471  51.585  1.00 14.53           N  
ATOM     21  N   TRP A   5      62.536  28.385  48.674  1.00 17.09           N  
ATOM     22  CA  TRP A   5      63.969  28.613  48.839  1.00  9.64           C  
ATOM     23  C   TRP A   5      64.421  30.043  48.547  1.00 10.83           C  
ATOM     24  O   TRP A   5      65.546  30.273  48.099  1.00 14.61           O  
ATOM     25  CB  TRP A   5      64.775  27.636  47.956  1.00 13.33           C  
ATOM     26  CG  TRP A   5      64.774  26.166  48.396  1.00 11.25           C  
ATOM     27  CD1 TRP A   5      64.037  25.149  47.850  1.00  5.26           C  
ATOM     28  CD2 TRP A   5      65.580  25.555  49.430  1.00 15.91           C  
ATOM     29  NE1 TRP A   5      64.334  23.953  48.472  1.00 12.14           N  
ATOM     30  CE2 TRP A   5      65.274  24.174  49.442  1.00  9.96           C  
ATOM     31  CE3 TRP A   5      66.527  26.042  50.337  1.00  9.35           C  
ATOM     32  CZ2 TRP A   5      65.881  23.278  50.330  1.00 12.89           C  
ATOM     33  CZ3 TRP A   5      67.131  25.145  51.219  1.00  9.93           C  
ATOM     34  CH2 TRP A   5      66.806  23.782  51.208  1.00 10.49           C  
ATOM     35  N   ASN A   6      63.547  31.008  48.789  1.00 12.25           N  
ATOM     36  CA  ASN A   6      63.919  32.406  48.593  1.00 15.49           C  
ATOM     37  C   ASN A   6      63.143  33.274  49.580  1.00 12.46           C  
ATOM     38  O   ASN A   6      62.238  32.785  50.254  1.00 11.68           O  
ATOM     39  CB  ASN A   6      63.671  32.847  47.134  1.00 22.60           C  
ATOM     40  CG  ASN A   6      62.197  33.012  46.801  1.00 21.90           C  
ATOM     41  OD1 ASN A   6      61.491  33.794  47.428  1.00 29.57           O  
ATOM     42  ND2 ASN A   6      61.730  32.275  45.800  1.00 16.28           N  
ATOM     43  N   LEU A   7      63.511  34.548  49.687  1.00 17.58           N  
ATOM     44  CA  LEU A   7      62.829  35.458  50.609  1.00 19.92           C  
ATOM     45  C   LEU A   7      62.109  36.548  49.846  1.00 20.49           C  
ATOM     46  O   LEU A   7      61.860  37.636  50.372  1.00 19.12           O  
ATOM     47  CB  LEU A   7      63.830  36.092  51.568  1.00 15.32           C  
ATOM     48  CG  LEU A   7      64.678  35.068  52.297  1.00 14.24           C  
ATOM     49  CD1 LEU A   7      65.858  35.745  52.950  1.00 10.22           C  
ATOM     50  CD2 LEU A   7      63.798  34.348  53.317  1.00 16.69           C  
ATOM     51  N   GLU A   8      61.797  36.240  48.594  1.00 22.09           N  
ATOM     52  CA  GLU A   8      61.099  37.151  47.702  1.00 25.63           C  
ATOM     53  C   GLU A   8      59.893  37.790  48.381  1.00 22.25           C  
ATOM     54  O   GLU A   8      58.961  37.100  48.798  1.00 14.52           O  
ATOM     55  CB  GLU A   8      60.635  36.390  46.463  1.00 36.42           C  
ATOM     56  CG  GLU A   8      60.404  37.258  45.254  1.00 56.85           C  
ATOM     57  CD  GLU A   8      61.680  37.524  44.492  1.00 66.83           C  
ATOM     58  OE1 GLU A   8      62.468  36.572  44.297  1.00 70.21           O  
ATOM     59  OE2 GLU A   8      61.895  38.689  44.089  1.00 76.35           O  
ATOM     60  N   GLY A   9      59.921  39.113  48.505  1.00 21.57           N  
ATOM     61  CA  GLY A   9      58.806  39.813  49.115  1.00 22.49           C  
ATOM     62  C   GLY A   9      58.843  40.045  50.618  1.00 21.34           C  
ATOM     63  O   GLY A   9      58.104  40.895  51.119  1.00 22.22           O  
ATOM     64  N   CYS A  10      59.682  39.307  51.342  1.00 18.38           N  
ATOM     65  CA  CYS A  10      59.758  39.468  52.789  1.00 15.64           C  
ATOM     66  C   CYS A  10      60.561  40.702  53.175  1.00 16.22           C  
ATOM     67  O   CYS A  10      61.502  41.079  52.479  1.00 17.34           O  
ATOM     68  CB  CYS A  10      60.368  38.224  53.428  1.00 11.95           C  
ATOM     69  SG  CYS A  10      59.625  36.712  52.837  1.00  2.00           S  
ATOM     70  N   THR A  11      60.164  41.329  54.282  1.00 13.72           N  
ATOM     71  CA  THR A  11      60.816  42.529  54.800  1.00 11.37           C  
ATOM     72  C   THR A  11      61.672  42.118  55.990  1.00 11.49           C  
ATOM     73  O   THR A  11      61.313  41.196  56.720  1.00 10.99           O  
ATOM     74  CB  THR A  11      59.773  43.560  55.265  1.00 13.51           C  
ATOM     75  OG1 THR A  11      58.825  42.926  56.140  1.00  2.62           O  
ATOM     76  CG2 THR A  11      59.030  44.132  54.065  1.00  9.15           C  
ATOM     77  N   ALA A  12      62.796  42.793  56.197  1.00 13.09           N  
ATOM     78  CA  ALA A  12      63.662  42.428  57.312  1.00 12.18           C  
ATOM     79  C   ALA A  12      64.405  43.603  57.905  1.00 12.94           C  
ATOM     80  O   ALA A  12      64.719  44.557  57.204  1.00 14.64           O  
ATOM     81  CB  ALA A  12      64.667  41.369  56.858  1.00  6.96           C  
ATOM     82  N   LEU A  13      64.665  43.535  59.208  1.00 16.78           N  
ATOM     83  CA  LEU A  13      65.429  44.567  59.902  1.00 14.64           C  
ATOM     84  C   LEU A  13      66.658  43.828  60.402  1.00 16.36           C  
ATOM     85  O   LEU A  13      66.529  42.755  60.991  1.00 19.46           O  
ATOM     86  CB  LEU A  13      64.660  45.138  61.099  1.00 12.16           C  
ATOM     87  CG  LEU A  13      65.453  45.929  62.159  1.00  9.37           C  
ATOM     88  CD1 LEU A  13      66.176  47.130  61.545  1.00  2.00           C  
ATOM     89  CD2 LEU A  13      64.500  46.391  63.226  1.00  5.92           C  
ATOM     90  N   VAL A  14      67.842  44.379  60.146  1.00 15.45           N  
ATOM     91  CA  VAL A  14      69.085  43.757  60.590  1.00 12.93           C  
ATOM     92  C   VAL A  14      69.937  44.780  61.337  1.00 14.99           C  
ATOM     93  O   VAL A  14      70.521  45.676  60.724  1.00 19.26           O  
ATOM     94  CB  VAL A  14      69.900  43.203  59.396  1.00  9.68           C  
ATOM     95  CG1 VAL A  14      71.275  42.743  59.880  1.00  2.00           C  
ATOM     96  CG2 VAL A  14      69.144  42.041  58.728  1.00  2.00           C  
ATOM     97  N   THR A  15      70.010  44.652  62.656  1.00  6.54           N  
ATOM     98  CA  THR A  15      70.793  45.590  63.450  1.00  5.25           C  
ATOM     99  C   THR A  15      72.291  45.445  63.210  1.00 11.92           C  
ATOM    100  O   THR A  15      72.840  44.342  63.237  1.00 15.09           O  
ATOM    101  CB  THR A  15      70.516  45.426  64.952  1.00  2.00           C  
ATOM    102  OG1 THR A  15      71.050  44.175  65.403  1.00  5.34           O  
ATOM    103  CG2 THR A  15      69.010  45.469  65.230  1.00  2.00           C  
ATOM    104  N   GLY A  16      72.945  46.572  62.959  1.00 16.16           N  
ATOM    105  CA  GLY A  16      74.374  46.564  62.721  1.00 15.41           C  
ATOM    106  C   GLY A  16      74.752  45.927  61.403  1.00 12.98           C  
ATOM    107  O   GLY A  16      75.440  44.912  61.387  1.00 11.62           O  
ATOM    108  N   GLY A  17      74.319  46.525  60.297  1.00  9.37           N  
ATOM    109  CA  GLY A  17      74.638  45.965  58.997  1.00  8.05           C  
ATOM    110  C   GLY A  17      75.702  46.698  58.195  1.00 10.22           C  
ATOM    111  O   GLY A  17      75.880  46.432  56.998  1.00  6.93           O  
ATOM    112  N   SER A  18      76.424  47.612  58.837  1.00 11.07           N  
ATOM    113  CA  SER A  18      77.451  48.367  58.135  1.00 14.16           C  
ATOM    114  C   SER A  18      78.781  47.615  58.021  1.00 16.55           C  
ATOM    115  O   SER A  18      79.591  47.901  57.132  1.00 19.14           O  
ATOM    116  CB  SER A  18      77.657  49.734  58.804  1.00  9.78           C  
ATOM    117  OG  SER A  18      78.172  49.607  60.114  1.00 21.67           O  
ATOM    118  N   ARG A  19      79.003  46.642  58.898  1.00 10.71           N  
ATOM    119  CA  ARG A  19      80.247  45.894  58.850  1.00  6.15           C  
ATOM    120  C   ARG A  19      80.136  44.440  59.264  1.00  7.67           C  
ATOM    121  O   ARG A  19      79.165  44.024  59.909  1.00 11.79           O  
ATOM    122  CB  ARG A  19      81.286  46.569  59.739  1.00  7.38           C  
ATOM    123  CG  ARG A  19      81.803  47.894  59.198  1.00  9.82           C  
ATOM    124  CD  ARG A  19      82.824  48.499  60.151  1.00  9.49           C  
ATOM    125  NE  ARG A  19      82.472  48.231  61.545  1.00 16.04           N  
ATOM    126  CZ  ARG A  19      82.056  49.161  62.397  1.00 14.55           C  
ATOM    127  NH1 ARG A  19      81.942  50.421  61.999  1.00 19.55           N  
ATOM    128  NH2 ARG A  19      81.740  48.833  63.639  1.00  6.01           N  
ATOM    129  N   GLY A  20      81.156  43.675  58.887  1.00  2.00           N  
ATOM    130  CA  GLY A  20      81.234  42.267  59.243  1.00  5.15           C  
ATOM    131  C   GLY A  20      80.093  41.335  58.875  1.00  6.17           C  
ATOM    132  O   GLY A  20      79.604  41.343  57.739  1.00  6.09           O  
ATOM    133  N   ILE A  21      79.701  40.504  59.841  1.00  5.27           N  
ATOM    134  CA  ILE A  21      78.622  39.541  59.664  1.00  5.61           C  
ATOM    135  C   ILE A  21      77.334  40.238  59.243  1.00 11.63           C  
ATOM    136  O   ILE A  21      76.621  39.766  58.359  1.00 19.45           O  
ATOM    137  CB  ILE A  21      78.334  38.768  60.966  1.00  6.62           C  
ATOM    138  CG1 ILE A  21      79.460  37.789  61.267  1.00  2.00           C  
ATOM    139  CG2 ILE A  21      77.014  38.005  60.843  1.00 12.95           C  
ATOM    140  CD1 ILE A  21      79.191  36.969  62.511  1.00  2.00           C  
ATOM    141  N   GLY A  22      77.031  41.357  59.894  1.00 17.86           N  
ATOM    142  CA  GLY A  22      75.818  42.090  59.573  1.00 17.65           C  
ATOM    143  C   GLY A  22      75.774  42.533  58.125  1.00 14.44           C  
ATOM    144  O   GLY A  22      74.788  42.325  57.414  1.00 13.62           O  
ATOM    145  N   TYR A  23      76.853  43.159  57.683  1.00 12.26           N  
ATOM    146  CA  TYR A  23      76.932  43.621  56.318  1.00  7.54           C  
ATOM    147  C   TYR A  23      76.661  42.450  55.377  1.00 11.03           C  
ATOM    148  O   TYR A  23      75.962  42.591  54.375  1.00  6.35           O  
ATOM    149  CB  TYR A  23      78.310  44.201  56.061  1.00  3.55           C  
ATOM    150  CG  TYR A  23      78.468  44.733  54.661  1.00  9.65           C  
ATOM    151  CD1 TYR A  23      78.853  43.888  53.618  1.00 13.59           C  
ATOM    152  CD2 TYR A  23      78.232  46.070  54.369  1.00  2.00           C  
ATOM    153  CE1 TYR A  23      79.001  44.362  52.327  1.00  2.33           C  
ATOM    154  CE2 TYR A  23      78.375  46.554  53.077  1.00  7.12           C  
ATOM    155  CZ  TYR A  23      78.760  45.691  52.061  1.00  6.68           C  
ATOM    156  OH  TYR A  23      78.901  46.147  50.772  1.00  8.20           O  
ATOM    157  N   GLY A  24      77.212  41.288  55.724  1.00 16.70           N  
ATOM    158  CA  GLY A  24      77.028  40.093  54.922  1.00  8.31           C  
ATOM    159  C   GLY A  24      75.599  39.590  54.947  1.00  8.14           C  
ATOM    160  O   GLY A  24      75.102  39.059  53.950  1.00 13.39           O  
ATOM    161  N   ILE A  25      74.923  39.747  56.077  1.00  5.32           N  
ATOM    162  CA  ILE A  25      73.550  39.283  56.147  1.00  5.46           C  
ATOM    163  C   ILE A  25      72.643  40.160  55.305  1.00  4.76           C  
ATOM    164  O   ILE A  25      71.719  39.653  54.679  1.00  8.93           O  
ATOM    165  CB  ILE A  25      73.036  39.228  57.586  1.00  3.06           C  
ATOM    166  CG1 ILE A  25      73.888  38.238  58.395  1.00  2.00           C  
ATOM    167  CG2 ILE A  25      71.572  38.820  57.587  1.00  2.00           C  
ATOM    168  CD1 ILE A  25      73.549  38.170  59.886  1.00  2.00           C  
ATOM    169  N   VAL A  26      72.919  41.463  55.258  1.00  7.46           N  
ATOM    170  CA  VAL A  26      72.099  42.370  54.449  1.00  6.85           C  
ATOM    171  C   VAL A  26      72.195  41.963  52.981  1.00  7.02           C  
ATOM    172  O   VAL A  26      71.211  41.985  52.244  1.00  2.94           O  
ATOM    173  CB  VAL A  26      72.568  43.840  54.574  1.00  6.90           C  
ATOM    174  CG1 VAL A  26      71.989  44.670  53.434  1.00  8.59           C  
ATOM    175  CG2 VAL A  26      72.128  44.423  55.916  1.00  8.78           C  
ATOM    176  N   GLU A  27      73.392  41.584  52.561  1.00 11.30           N  
ATOM    177  CA  GLU A  27      73.617  41.182  51.183  1.00 16.11           C  
ATOM    178  C   GLU A  27      72.916  39.881  50.812  1.00 18.94           C  
ATOM    179  O   GLU A  27      72.320  39.784  49.742  1.00 22.72           O  
ATOM    180  CB  GLU A  27      75.111  41.057  50.916  1.00 16.35           C  
ATOM    181  CG  GLU A  27      75.823  42.395  50.859  1.00 20.27           C  
ATOM    182  CD  GLU A  27      77.020  42.372  49.932  1.00 31.80           C  
ATOM    183  OE1 GLU A  27      77.775  41.374  49.964  1.00 38.71           O  
ATOM    184  OE2 GLU A  27      77.210  43.351  49.175  1.00 35.97           O  
ATOM    185  N   GLU A  28      72.972  38.888  51.693  1.00 19.31           N  
ATOM    186  CA  GLU A  28      72.339  37.603  51.407  1.00 16.54           C  
ATOM    187  C   GLU A  28      70.812  37.636  51.410  1.00 14.71           C  
ATOM    188  O   GLU A  28      70.165  36.905  50.652  1.00 17.02           O  
ATOM    189  CB  GLU A  28      72.825  36.539  52.388  1.00 17.90           C  
ATOM    190  CG  GLU A  28      72.328  35.141  52.060  1.00 16.54           C  
ATOM    191  CD  GLU A  28      73.098  34.497  50.918  1.00 16.60           C  
ATOM    192  OE1 GLU A  28      72.454  34.028  49.954  1.00 31.46           O  
ATOM    193  OE2 GLU A  28      74.344  34.463  50.984  1.00 11.60           O  
ATOM    194  N   LEU A  29      70.226  38.463  52.265  1.00 13.43           N  
ATOM    195  CA  LEU A  29      68.767  38.548  52.304  1.00 13.18           C  
ATOM    196  C   LEU A  29      68.283  39.343  51.085  1.00 13.66           C  
ATOM    197  O   LEU A  29      67.350  38.933  50.390  1.00 14.88           O  
ATOM    198  CB  LEU A  29      68.302  39.212  53.610  1.00  9.14           C  
ATOM    199  CG  LEU A  29      68.754  38.569  54.936  1.00 12.37           C  
ATOM    200  CD1 LEU A  29      68.269  39.406  56.111  1.00  4.67           C  
ATOM    201  CD2 LEU A  29      68.198  37.168  55.047  1.00  6.15           C  
ATOM    202  N   ALA A  30      68.935  40.472  50.818  1.00  9.95           N  
ATOM    203  CA  ALA A  30      68.574  41.306  49.683  1.00  8.59           C  
ATOM    204  C   ALA A  30      68.808  40.533  48.404  1.00  8.80           C  
ATOM    205  O   ALA A  30      67.987  40.562  47.490  1.00 16.48           O  
ATOM    206  CB  ALA A  30      69.407  42.584  49.677  1.00 12.47           C  
ATOM    207  N   SER A  31      69.933  39.837  48.345  1.00  6.73           N  
ATOM    208  CA  SER A  31      70.283  39.059  47.168  1.00  8.17           C  
ATOM    209  C   SER A  31      69.279  37.949  46.906  1.00 11.07           C  
ATOM    210  O   SER A  31      69.142  37.504  45.770  1.00 18.69           O  
ATOM    211  CB  SER A  31      71.680  38.456  47.324  1.00  6.78           C  
ATOM    212  OG  SER A  31      71.603  37.202  47.969  1.00 17.92           O  
ATOM    213  N   LEU A  32      68.579  37.513  47.953  1.00 12.89           N  
ATOM    214  CA  LEU A  32      67.583  36.444  47.847  1.00 10.01           C  
ATOM    215  C   LEU A  32      66.170  37.004  47.666  1.00 10.65           C  
ATOM    216  O   LEU A  32      65.177  36.273  47.809  1.00 13.04           O  
ATOM    217  CB  LEU A  32      67.617  35.542  49.099  1.00  8.82           C  
ATOM    218  CG  LEU A  32      68.662  34.423  49.231  1.00  5.63           C  
ATOM    219  CD1 LEU A  32      68.527  33.787  50.596  1.00  5.20           C  
ATOM    220  CD2 LEU A  32      68.489  33.380  48.143  1.00  2.00           C  
ATOM    221  N   GLY A  33      66.078  38.305  47.394  1.00  9.33           N  
ATOM    222  CA  GLY A  33      64.779  38.926  47.159  1.00  5.46           C  
ATOM    223  C   GLY A  33      64.052  39.683  48.255  1.00  8.46           C  
ATOM    224  O   GLY A  33      62.926  40.130  48.041  1.00 14.25           O  
ATOM    225  N   ALA A  34      64.667  39.856  49.417  1.00  8.42           N  
ATOM    226  CA  ALA A  34      63.994  40.561  50.507  1.00 10.58           C  
ATOM    227  C   ALA A  34      64.284  42.060  50.580  1.00 11.05           C  
ATOM    228  O   ALA A  34      65.244  42.555  49.993  1.00 14.34           O  
ATOM    229  CB  ALA A  34      64.341  39.905  51.846  1.00  2.00           C  
ATOM    230  N   SER A  35      63.427  42.774  51.304  1.00 13.22           N  
ATOM    231  CA  SER A  35      63.573  44.214  51.500  1.00 14.47           C  
ATOM    232  C   SER A  35      64.138  44.370  52.904  1.00 13.50           C  
ATOM    233  O   SER A  35      63.510  43.959  53.883  1.00 14.19           O  
ATOM    234  CB  SER A  35      62.218  44.920  51.399  1.00 12.85           C  
ATOM    235  OG  SER A  35      62.392  46.325  51.295  1.00 22.71           O  
ATOM    236  N   VAL A  36      65.327  44.954  52.991  1.00  5.77           N  
ATOM    237  CA  VAL A  36      65.997  45.125  54.261  1.00  6.81           C  
ATOM    238  C   VAL A  36      66.102  46.554  54.774  1.00  8.42           C  
ATOM    239  O   VAL A  36      66.059  47.514  54.008  1.00 14.74           O  
ATOM    240  CB  VAL A  36      67.405  44.529  54.194  1.00  4.98           C  
ATOM    241  CG1 VAL A  36      67.740  43.865  55.504  1.00  2.00           C  
ATOM    242  CG2 VAL A  36      67.484  43.512  53.048  1.00 10.54           C  
ATOM    243  N   TYR A  37      66.211  46.671  56.094  1.00 12.19           N  
ATOM    244  CA  TYR A  37      66.373  47.941  56.796  1.00 11.67           C  
ATOM    245  C   TYR A  37      67.477  47.665  57.819  1.00 11.43           C  
ATOM    246  O   TYR A  37      67.377  46.738  58.619  1.00  8.24           O  
ATOM    247  CB  TYR A  37      65.077  48.363  57.511  1.00 15.38           C  
ATOM    248  CG  TYR A  37      65.039  49.848  57.851  1.00 17.70           C  
ATOM    249  CD1 TYR A  37      65.871  50.378  58.842  1.00 18.53           C  
ATOM    250  CD2 TYR A  37      64.227  50.731  57.137  1.00 12.91           C  
ATOM    251  CE1 TYR A  37      65.906  51.750  59.104  1.00 19.01           C  
ATOM    252  CE2 TYR A  37      64.252  52.107  57.393  1.00  9.24           C  
ATOM    253  CZ  TYR A  37      65.097  52.608  58.369  1.00 15.27           C  
ATOM    254  OH  TYR A  37      65.177  53.961  58.574  1.00 14.45           O  
ATOM    255  N   THR A  38      68.544  48.450  57.776  1.00 11.18           N  
ATOM    256  CA  THR A  38      69.639  48.238  58.703  1.00  5.12           C  
ATOM    257  C   THR A  38      69.979  49.505  59.482  1.00 10.66           C  
ATOM    258  O   THR A  38      69.384  50.568  59.274  1.00  9.18           O  
ATOM    259  CB  THR A  38      70.880  47.704  57.944  1.00  8.85           C  
ATOM    260  OG1 THR A  38      71.750  47.035  58.863  1.00  9.88           O  
ATOM    261  CG2 THR A  38      71.635  48.832  57.243  1.00 13.53           C  
ATOM    262  N   CYS A  39      70.936  49.392  60.392  1.00 13.45           N  
ATOM    263  CA  CYS A  39      71.328  50.527  61.203  1.00 12.02           C  
ATOM    264  C   CYS A  39      72.722  50.334  61.739  1.00 10.80           C  
ATOM    265  O   CYS A  39      73.209  49.213  61.858  1.00 14.33           O  
ATOM    266  CB  CYS A  39      70.355  50.710  62.370  1.00 16.12           C  
ATOM    267  SG  CYS A  39      70.236  49.275  63.453  1.00 15.18           S  
ATOM    268  N   SER A  40      73.348  51.454  62.064  1.00 11.95           N  
ATOM    269  CA  SER A  40      74.697  51.492  62.592  1.00 10.64           C  
ATOM    270  C   SER A  40      74.776  52.835  63.319  1.00 12.23           C  
ATOM    271  O   SER A  40      73.822  53.615  63.294  1.00 10.74           O  
ATOM    272  CB  SER A  40      75.702  51.424  61.437  1.00 10.26           C  
ATOM    273  OG  SER A  40      76.925  52.071  61.757  1.00 22.22           O  
ATOM    274  N   ARG A  41      75.893  53.108  63.974  1.00 14.73           N  
ATOM    275  CA  ARG A  41      76.042  54.362  64.703  1.00 15.45           C  
ATOM    276  C   ARG A  41      76.768  55.428  63.887  1.00 14.37           C  
ATOM    277  O   ARG A  41      77.150  56.464  64.436  1.00 14.09           O  
ATOM    278  CB  ARG A  41      76.818  54.126  66.006  1.00 10.19           C  
ATOM    279  CG  ARG A  41      75.959  53.953  67.226  1.00 12.29           C  
ATOM    280  CD  ARG A  41      76.797  53.431  68.382  1.00 11.01           C  
ATOM    281  NE  ARG A  41      77.739  52.420  67.926  1.00 12.42           N  
ATOM    282  CZ  ARG A  41      78.613  51.810  68.712  1.00  2.00           C  
ATOM    283  NH1 ARG A  41      78.661  52.113  69.997  1.00  4.76           N  
ATOM    284  NH2 ARG A  41      79.439  50.908  68.211  1.00  7.44           N  
ATOM    285  N   ASN A  42      76.967  55.171  62.592  1.00 20.48           N  
ATOM    286  CA  ASN A  42      77.666  56.115  61.716  1.00 21.74           C  
ATOM    287  C   ASN A  42      76.970  56.370  60.389  1.00 22.16           C  
ATOM    288  O   ASN A  42      76.887  55.483  59.547  1.00 21.75           O  
ATOM    289  CB  ASN A  42      79.083  55.626  61.439  1.00 34.10           C  
ATOM    290  CG  ASN A  42      79.982  56.726  60.893  1.00 46.83           C  
ATOM    291  OD1 ASN A  42      79.506  57.796  60.501  1.00 50.24           O  
ATOM    292  ND2 ASN A  42      81.288  56.467  60.867  1.00 50.90           N  
ATOM    293  N   GLN A  43      76.492  57.597  60.199  1.00 25.84           N  
ATOM    294  CA  GLN A  43      75.801  57.980  58.971  1.00 25.47           C  
ATOM    295  C   GLN A  43      76.647  57.749  57.713  1.00 23.15           C  
ATOM    296  O   GLN A  43      76.237  57.035  56.794  1.00 23.55           O  
ATOM    297  CB  GLN A  43      75.386  59.452  59.052  1.00 27.95           C  
ATOM    298  CG  GLN A  43      74.286  59.867  58.071  1.00 39.88           C  
ATOM    299  CD  GLN A  43      73.021  59.019  58.175  1.00 43.87           C  
ATOM    300  OE1 GLN A  43      72.295  59.075  59.170  1.00 46.23           O  
ATOM    301  NE2 GLN A  43      72.751  58.234  57.137  1.00 47.72           N  
ATOM    302  N   LYS A  44      77.833  58.345  57.680  1.00 22.18           N  
ATOM    303  CA  LYS A  44      78.716  58.225  56.528  1.00 16.59           C  
ATOM    304  C   LYS A  44      78.906  56.784  56.090  1.00 15.19           C  
ATOM    305  O   LYS A  44      78.746  56.459  54.920  1.00 12.47           O  
ATOM    306  CB  LYS A  44      80.075  58.857  56.836  1.00 24.68           C  
ATOM    307  CG  LYS A  44      80.944  59.080  55.608  1.00 29.35           C  
ATOM    308  CD  LYS A  44      81.828  57.872  55.317  1.00 37.24           C  
ATOM    309  CE  LYS A  44      82.802  58.154  54.168  1.00 46.71           C  
ATOM    310  NZ  LYS A  44      84.186  57.659  54.459  1.00 47.28           N  
ATOM    311  N   GLU A  45      79.264  55.925  57.032  1.00 16.64           N  
ATOM    312  CA  GLU A  45      79.462  54.512  56.744  1.00 18.85           C  
ATOM    313  C   GLU A  45      78.212  53.948  56.087  1.00 20.27           C  
ATOM    314  O   GLU A  45      78.275  53.343  55.021  1.00 26.71           O  
ATOM    315  CB  GLU A  45      79.724  53.753  58.036  1.00 16.42           C  
ATOM    316  CG  GLU A  45      80.919  52.855  57.988  1.00 25.19           C  
ATOM    317  CD  GLU A  45      81.344  52.436  59.370  1.00 31.74           C  
ATOM    318  OE1 GLU A  45      82.554  52.523  59.659  1.00 36.98           O  
ATOM    319  OE2 GLU A  45      80.460  52.025  60.165  1.00 40.00           O  
ATOM    320  N   LEU A  46      77.076  54.153  56.743  1.00 19.52           N  
ATOM    321  CA  LEU A  46      75.799  53.676  56.241  1.00 19.51           C  
ATOM    322  C   LEU A  46      75.522  54.194  54.835  1.00 17.07           C  
ATOM    323  O   LEU A  46      74.930  53.499  54.019  1.00 18.35           O  
ATOM    324  CB  LEU A  46      74.668  54.124  57.170  1.00 13.28           C  
ATOM    325  CG  LEU A  46      74.287  53.219  58.336  1.00 11.71           C  
ATOM    326  CD1 LEU A  46      72.945  53.690  58.887  1.00 14.35           C  
ATOM    327  CD2 LEU A  46      74.203  51.767  57.887  1.00 11.02           C  
ATOM    328  N   ASN A  47      75.944  55.418  54.547  1.00 16.72           N  
ATOM    329  CA  ASN A  47      75.685  55.980  53.230  1.00 20.15           C  
ATOM    330  C   ASN A  47      76.495  55.357  52.100  1.00 20.10           C  
ATOM    331  O   ASN A  47      76.043  55.334  50.957  1.00 25.61           O  
ATOM    332  CB  ASN A  47      75.870  57.489  53.262  1.00 21.32           C  
ATOM    333  CG  ASN A  47      74.656  58.191  53.808  1.00 27.04           C  
ATOM    334  OD1 ASN A  47      73.545  57.655  53.763  1.00 31.51           O  
ATOM    335  ND2 ASN A  47      74.852  59.393  54.333  1.00 29.54           N  
ATOM    336  N   ASP A  48      77.683  54.848  52.407  1.00 14.33           N  
ATOM    337  CA  ASP A  48      78.484  54.201  51.387  1.00 20.57           C  
ATOM    338  C   ASP A  48      77.868  52.828  51.101  1.00 24.23           C  
ATOM    339  O   ASP A  48      77.867  52.363  49.959  1.00 27.40           O  
ATOM    340  CB  ASP A  48      79.933  54.031  51.854  1.00 21.02           C  
ATOM    341  CG  ASP A  48      80.644  55.358  52.068  1.00 27.86           C  
ATOM    342  OD1 ASP A  48      81.666  55.371  52.786  1.00 36.03           O  
ATOM    343  OD2 ASP A  48      80.188  56.389  51.530  1.00 36.21           O  
ATOM    344  N   CYS A  49      77.341  52.192  52.149  1.00 25.55           N  
ATOM    345  CA  CYS A  49      76.714  50.874  52.041  1.00 20.33           C  
ATOM    346  C   CYS A  49      75.499  50.925  51.141  1.00 20.50           C  
ATOM    347  O   CYS A  49      75.367  50.119  50.214  1.00 26.13           O  
ATOM    348  CB  CYS A  49      76.282  50.366  53.414  1.00 20.22           C  
ATOM    349  SG  CYS A  49      77.628  49.988  54.539  1.00 25.94           S  
ATOM    350  N   LEU A  50      74.606  51.872  51.427  1.00 20.11           N  
ATOM    351  CA  LEU A  50      73.388  52.052  50.640  1.00 16.17           C  
ATOM    352  C   LEU A  50      73.769  52.213  49.180  1.00 14.71           C  
ATOM    353  O   LEU A  50      73.096  51.714  48.290  1.00 22.63           O  
ATOM    354  CB  LEU A  50      72.639  53.290  51.109  1.00 13.30           C  
ATOM    355  CG  LEU A  50      72.031  53.181  52.497  1.00 12.41           C  
ATOM    356  CD1 LEU A  50      71.333  54.490  52.874  1.00 10.34           C  
ATOM    357  CD2 LEU A  50      71.066  52.026  52.510  1.00 10.72           C  
ATOM    358  N   THR A  51      74.865  52.912  48.939  1.00 17.45           N  
ATOM    359  CA  THR A  51      75.331  53.119  47.585  1.00 16.33           C  
ATOM    360  C   THR A  51      75.804  51.799  46.992  1.00 15.90           C  
ATOM    361  O   THR A  51      75.540  51.510  45.831  1.00 21.57           O  
ATOM    362  CB  THR A  51      76.485  54.120  47.561  1.00 14.26           C  
ATOM    363  OG1 THR A  51      75.960  55.451  47.659  1.00  9.01           O  
ATOM    364  CG2 THR A  51      77.292  53.975  46.277  1.00 16.07           C  
ATOM    365  N   GLN A  52      76.503  51.001  47.794  1.00 20.97           N  
ATOM    366  CA  GLN A  52      77.018  49.706  47.347  1.00 20.34           C  
ATOM    367  C   GLN A  52      75.888  48.722  47.073  1.00 20.96           C  
ATOM    368  O   GLN A  52      75.881  48.034  46.052  1.00 17.38           O  
ATOM    369  CB  GLN A  52      77.934  49.108  48.411  1.00 17.75           C  
ATOM    370  CG  GLN A  52      79.391  49.511  48.278  1.00 35.13           C  
ATOM    371  CD  GLN A  52      80.135  49.472  49.611  1.00 42.74           C  
ATOM    372  OE1 GLN A  52      81.182  50.107  49.773  1.00 46.20           O  
ATOM    373  NE2 GLN A  52      79.594  48.726  50.570  1.00 40.47           N  
ATOM    374  N   TRP A  53      74.934  48.666  47.999  1.00 17.80           N  
ATOM    375  CA  TRP A  53      73.797  47.764  47.902  1.00 16.88           C  
ATOM    376  C   TRP A  53      72.791  48.153  46.825  1.00 16.07           C  
ATOM    377  O   TRP A  53      72.329  47.308  46.048  1.00 10.86           O  
ATOM    378  CB  TRP A  53      73.105  47.677  49.262  1.00 12.79           C  
ATOM    379  CG  TRP A  53      73.978  47.077  50.332  1.00 17.98           C  
ATOM    380  CD1 TRP A  53      74.934  46.106  50.171  1.00 20.29           C  
ATOM    381  CD2 TRP A  53      73.934  47.362  51.732  1.00 14.52           C  
ATOM    382  NE1 TRP A  53      75.482  45.769  51.386  1.00 18.15           N  
ATOM    383  CE2 TRP A  53      74.886  46.525  52.363  1.00 14.69           C  
ATOM    384  CE3 TRP A  53      73.181  48.246  52.521  1.00 13.88           C  
ATOM    385  CZ2 TRP A  53      75.102  46.542  53.741  1.00 10.03           C  
ATOM    386  CZ3 TRP A  53      73.399  48.261  53.895  1.00  5.53           C  
ATOM    387  CH2 TRP A  53      74.353  47.413  54.488  1.00  7.92           C  
ATOM    388  N   ARG A  54      72.439  49.430  46.786  1.00 15.07           N  
ATOM    389  CA  ARG A  54      71.491  49.914  45.790  1.00 18.31           C  
ATOM    390  C   ARG A  54      72.058  49.798  44.383  1.00 14.49           C  
ATOM    391  O   ARG A  54      71.321  49.600  43.422  1.00 20.30           O  
ATOM    392  CB  ARG A  54      71.127  51.359  46.088  1.00 11.46           C  
ATOM    393  CG  ARG A  54      70.504  51.500  47.447  1.00  9.70           C  
ATOM    394  CD  ARG A  54      69.947  52.877  47.651  1.00 12.61           C  
ATOM    395  NE  ARG A  54      68.860  52.856  48.619  1.00 18.05           N  
ATOM    396  CZ  ARG A  54      68.654  53.818  49.505  1.00 20.06           C  
ATOM    397  NH1 ARG A  54      69.469  54.861  49.525  1.00 17.38           N  
ATOM    398  NH2 ARG A  54      67.646  53.734  50.366  1.00 26.72           N  
ATOM    399  N   SER A  55      73.374  49.903  44.275  1.00 10.61           N  
ATOM    400  CA  SER A  55      74.029  49.817  42.986  1.00 16.86           C  
ATOM    401  C   SER A  55      73.827  48.419  42.405  1.00 21.48           C  
ATOM    402  O   SER A  55      73.669  48.254  41.192  1.00 24.43           O  
ATOM    403  CB  SER A  55      75.518  50.156  43.151  1.00 19.26           C  
ATOM    404  OG  SER A  55      76.367  49.194  42.555  1.00 22.62           O  
ATOM    405  N   LYS A  56      73.795  47.423  43.286  1.00 24.25           N  
ATOM    406  CA  LYS A  56      73.617  46.027  42.894  1.00 19.36           C  
ATOM    407  C   LYS A  56      72.148  45.666  42.734  1.00 20.01           C  
ATOM    408  O   LYS A  56      71.811  44.508  42.490  1.00 20.87           O  
ATOM    409  CB  LYS A  56      74.224  45.096  43.943  1.00 23.46           C  
ATOM    410  CG  LYS A  56      75.729  45.086  44.012  1.00 25.12           C  
ATOM    411  CD  LYS A  56      76.186  44.209  45.164  1.00 29.54           C  
ATOM    412  CE  LYS A  56      77.701  44.179  45.282  1.00 34.73           C  
ATOM    413  NZ  LYS A  56      78.179  42.956  45.991  1.00 35.49           N  
ATOM    414  N   GLY A  57      71.273  46.647  42.911  1.00 18.14           N  
ATOM    415  CA  GLY A  57      69.852  46.387  42.755  1.00 18.77           C  
ATOM    416  C   GLY A  57      69.113  45.895  43.984  1.00 14.95           C  
ATOM    417  O   GLY A  57      67.958  45.495  43.885  1.00 18.95           O  
ATOM    418  N   PHE A  58      69.765  45.933  45.142  1.00 16.11           N  
ATOM    419  CA  PHE A  58      69.149  45.490  46.388  1.00 13.14           C  
ATOM    420  C   PHE A  58      68.230  46.574  46.935  1.00 17.06           C  
ATOM    421  O   PHE A  58      68.636  47.728  47.038  1.00 23.22           O  
ATOM    422  CB  PHE A  58      70.210  45.217  47.454  1.00  8.53           C  
ATOM    423  CG  PHE A  58      71.184  44.136  47.104  1.00  5.90           C  
ATOM    424  CD1 PHE A  58      72.379  44.029  47.803  1.00  7.28           C  
ATOM    425  CD2 PHE A  58      70.905  43.210  46.111  1.00  9.95           C  
ATOM    426  CE1 PHE A  58      73.281  43.008  47.517  1.00 17.55           C  
ATOM    427  CE2 PHE A  58      71.799  42.188  45.819  1.00 12.59           C  
ATOM    428  CZ  PHE A  58      72.986  42.084  46.520  1.00 11.09           C  
ATOM    429  N   LYS A  59      66.999  46.204  47.280  1.00 14.55           N  
ATOM    430  CA  LYS A  59      66.052  47.150  47.868  1.00 16.40           C  
ATOM    431  C   LYS A  59      66.532  47.316  49.300  1.00 17.72           C  
ATOM    432  O   LYS A  59      66.548  46.353  50.070  1.00 20.83           O  
ATOM    433  CB  LYS A  59      64.630  46.570  47.884  1.00 21.63           C  
ATOM    434  CG  LYS A  59      63.879  46.675  46.567  1.00 32.13           C  
ATOM    435  CD  LYS A  59      62.694  45.712  46.531  1.00 44.58           C  
ATOM    436  CE  LYS A  59      61.984  45.731  45.177  1.00 48.25           C  
ATOM    437  NZ  LYS A  59      60.561  46.165  45.294  1.00 49.69           N  
ATOM    438  N   VAL A  60      66.915  48.521  49.685  1.00 14.68           N  
ATOM    439  CA  VAL A  60      67.409  48.664  51.032  1.00 14.12           C  
ATOM    440  C   VAL A  60      67.422  50.086  51.562  1.00 17.50           C  
ATOM    441  O   VAL A  60      67.670  51.040  50.825  1.00  7.65           O  
ATOM    442  CB  VAL A  60      68.824  48.070  51.120  1.00 22.54           C  
ATOM    443  CG1 VAL A  60      69.854  49.110  50.679  1.00 24.98           C  
ATOM    444  CG2 VAL A  60      69.096  47.577  52.525  1.00 18.93           C  
ATOM    445  N   GLU A  61      67.147  50.200  52.860  1.00 16.63           N  
ATOM    446  CA  GLU A  61      67.126  51.467  53.568  1.00 14.76           C  
ATOM    447  C   GLU A  61      67.904  51.323  54.867  1.00 12.88           C  
ATOM    448  O   GLU A  61      68.111  50.216  55.367  1.00 16.25           O  
ATOM    449  CB  GLU A  61      65.689  51.897  53.879  1.00 19.76           C  
ATOM    450  CG  GLU A  61      65.579  53.344  54.359  1.00 20.66           C  
ATOM    451  CD  GLU A  61      66.377  54.304  53.488  1.00 25.82           C  
ATOM    452  OE1 GLU A  61      65.836  54.787  52.469  1.00 27.31           O  
ATOM    453  OE2 GLU A  61      67.550  54.570  53.819  1.00 29.76           O  
ATOM    454  N   ALA A  62      68.329  52.453  55.415  1.00 11.44           N  
ATOM    455  CA  ALA A  62      69.102  52.461  56.642  1.00  2.00           C  
ATOM    456  C   ALA A  62      68.970  53.785  57.359  1.00  4.66           C  
ATOM    457  O   ALA A  62      68.785  54.833  56.751  1.00  8.96           O  
ATOM    458  CB  ALA A  62      70.558  52.202  56.334  1.00  4.58           C  
ATOM    459  N   SER A  63      69.059  53.727  58.675  1.00  8.74           N  
ATOM    460  CA  SER A  63      68.983  54.925  59.470  1.00  7.81           C  
ATOM    461  C   SER A  63      69.970  54.697  60.602  1.00 11.67           C  
ATOM    462  O   SER A  63      70.322  53.553  60.893  1.00 14.28           O  
ATOM    463  CB  SER A  63      67.551  55.132  59.963  1.00 12.83           C  
ATOM    464  OG  SER A  63      67.427  54.915  61.350  1.00 23.56           O  
ATOM    465  N   VAL A  64      70.450  55.792  61.189  1.00 15.83           N  
ATOM    466  CA  VAL A  64      71.413  55.760  62.288  1.00  9.86           C  
ATOM    467  C   VAL A  64      70.692  55.483  63.607  1.00 11.33           C  
ATOM    468  O   VAL A  64      69.578  55.966  63.826  1.00 12.59           O  
ATOM    469  CB  VAL A  64      72.156  57.116  62.395  1.00  7.13           C  
ATOM    470  CG1 VAL A  64      72.664  57.334  63.807  1.00 13.21           C  
ATOM    471  CG2 VAL A  64      73.313  57.154  61.410  1.00 10.98           C  
ATOM    472  N   CYS A  65      71.317  54.709  64.489  1.00  8.09           N  
ATOM    473  CA  CYS A  65      70.683  54.415  65.767  1.00  7.96           C  
ATOM    474  C   CYS A  65      71.649  53.759  66.723  1.00 10.43           C  
ATOM    475  O   CYS A  65      72.370  52.846  66.341  1.00  8.26           O  
ATOM    476  CB  CYS A  65      69.465  53.510  65.558  1.00  8.17           C  
ATOM    477  SG  CYS A  65      68.941  52.571  67.014  1.00 11.71           S  
ATOM    478  N   ASP A  66      71.676  54.237  67.964  1.00 14.49           N  
ATOM    479  CA  ASP A  66      72.560  53.665  68.974  1.00 14.74           C  
ATOM    480  C   ASP A  66      71.729  52.678  69.779  1.00 14.44           C  
ATOM    481  O   ASP A  66      70.987  53.057  70.680  1.00 14.95           O  
ATOM    482  CB  ASP A  66      73.104  54.767  69.875  1.00 23.34           C  
ATOM    483  CG  ASP A  66      74.055  54.242  70.925  1.00 30.99           C  
ATOM    484  OD1 ASP A  66      74.739  53.232  70.663  1.00 42.75           O  
ATOM    485  OD2 ASP A  66      74.119  54.844  72.016  1.00 36.22           O  
ATOM    486  N   LEU A  67      71.851  51.403  69.444  1.00 10.51           N  
ATOM    487  CA  LEU A  67      71.072  50.370  70.106  1.00 11.27           C  
ATOM    488  C   LEU A  67      71.175  50.358  71.625  1.00 13.89           C  
ATOM    489  O   LEU A  67      70.377  49.710  72.303  1.00 13.55           O  
ATOM    490  CB  LEU A  67      71.464  49.011  69.550  1.00  8.44           C  
ATOM    491  CG  LEU A  67      71.030  48.849  68.098  1.00 14.65           C  
ATOM    492  CD1 LEU A  67      71.407  47.466  67.617  1.00  7.39           C  
ATOM    493  CD2 LEU A  67      69.522  49.082  67.981  1.00 10.42           C  
ATOM    494  N   SER A  68      72.152  51.067  72.167  1.00 16.24           N  
ATOM    495  CA  SER A  68      72.303  51.104  73.613  1.00 23.71           C  
ATOM    496  C   SER A  68      71.461  52.231  74.188  1.00 25.52           C  
ATOM    497  O   SER A  68      71.847  52.848  75.178  1.00 34.78           O  
ATOM    498  CB  SER A  68      73.770  51.316  73.992  1.00 20.08           C  
ATOM    499  OG  SER A  68      74.084  52.689  74.017  1.00 25.46           O  
ATOM    500  N   SER A  69      70.308  52.487  73.573  1.00 23.57           N  
ATOM    501  CA  SER A  69      69.417  53.561  74.010  1.00 18.32           C  
ATOM    502  C   SER A  69      67.931  53.230  73.788  1.00 19.59           C  
ATOM    503  O   SER A  69      67.442  53.208  72.657  1.00 17.85           O  
ATOM    504  CB  SER A  69      69.790  54.845  73.268  1.00 15.40           C  
ATOM    505  OG  SER A  69      68.940  55.916  73.618  1.00 17.13           O  
ATOM    506  N   ARG A  70      67.224  52.979  74.885  1.00 15.11           N  
ATOM    507  CA  ARG A  70      65.804  52.636  74.864  1.00 15.95           C  
ATOM    508  C   ARG A  70      64.987  53.489  73.895  1.00 16.75           C  
ATOM    509  O   ARG A  70      64.243  52.968  73.072  1.00 20.35           O  
ATOM    510  CB  ARG A  70      65.238  52.785  76.275  1.00 21.15           C  
ATOM    511  CG  ARG A  70      63.971  52.008  76.563  1.00 29.11           C  
ATOM    512  CD  ARG A  70      63.937  51.571  78.022  1.00 36.34           C  
ATOM    513  NE  ARG A  70      64.550  50.255  78.207  1.00 47.28           N  
ATOM    514  CZ  ARG A  70      63.906  49.103  78.025  1.00 52.63           C  
ATOM    515  NH1 ARG A  70      62.630  49.107  77.657  1.00 48.41           N  
ATOM    516  NH2 ARG A  70      64.538  47.946  78.201  1.00 51.35           N  
ATOM    517  N   SER A  71      65.136  54.805  74.002  1.00 18.51           N  
ATOM    518  CA  SER A  71      64.408  55.750  73.163  1.00 18.17           C  
ATOM    519  C   SER A  71      64.770  55.644  71.686  1.00 11.85           C  
ATOM    520  O   SER A  71      63.896  55.658  70.821  1.00 19.59           O  
ATOM    521  CB  SER A  71      64.648  57.176  73.675  1.00 23.18           C  
ATOM    522  OG  SER A  71      65.640  57.847  72.914  1.00 39.18           O  
ATOM    523  N   GLU A  72      66.060  55.548  71.396  1.00  9.04           N  
ATOM    524  CA  GLU A  72      66.521  55.419  70.021  1.00  7.41           C  
ATOM    525  C   GLU A  72      66.002  54.109  69.449  1.00 11.03           C  
ATOM    526  O   GLU A  72      65.722  54.016  68.258  1.00 17.00           O  
ATOM    527  CB  GLU A  72      68.045  55.406  69.964  1.00  2.99           C  
ATOM    528  CG  GLU A  72      68.688  56.743  70.198  1.00  2.00           C  
ATOM    529  CD  GLU A  72      69.704  57.079  69.129  1.00 11.89           C  
ATOM    530  OE1 GLU A  72      69.413  56.867  67.928  1.00 17.46           O  
ATOM    531  OE2 GLU A  72      70.797  57.552  69.491  1.00 16.27           O  
ATOM    532  N   ARG A  73      65.886  53.098  70.306  1.00 15.85           N  
ATOM    533  CA  ARG A  73      65.394  51.789  69.885  1.00 20.01           C  
ATOM    534  C   ARG A  73      63.925  51.857  69.480  1.00 19.50           C  
ATOM    535  O   ARG A  73      63.544  51.272  68.468  1.00 23.52           O  
ATOM    536  CB  ARG A  73      65.591  50.739  70.998  1.00 14.62           C  
ATOM    537  CG  ARG A  73      67.065  50.380  71.245  1.00 11.43           C  
ATOM    538  CD  ARG A  73      67.236  49.050  71.959  1.00  4.30           C  
ATOM    539  NE  ARG A  73      66.766  49.079  73.342  1.00  3.50           N  
ATOM    540  CZ  ARG A  73      67.561  49.098  74.410  1.00  7.31           C  
ATOM    541  NH1 ARG A  73      68.878  49.092  74.270  1.00  8.90           N  
ATOM    542  NH2 ARG A  73      67.038  49.116  75.628  1.00  9.23           N  
ATOM    543  N   GLN A  74      63.104  52.567  70.254  1.00 23.06           N  
ATOM    544  CA  GLN A  74      61.681  52.686  69.920  1.00 23.89           C  
ATOM    545  C   GLN A  74      61.561  53.532  68.674  1.00 28.38           C  
ATOM    546  O   GLN A  74      60.658  53.342  67.866  1.00 30.44           O  
ATOM    547  CB  GLN A  74      60.902  53.359  71.039  1.00 24.15           C  
ATOM    548  CG  GLN A  74      61.760  53.985  72.097  1.00 29.49           C  
ATOM    549  CD  GLN A  74      61.189  53.782  73.482  1.00 34.49           C  
ATOM    550  OE1 GLN A  74      61.189  54.700  74.302  1.00 38.09           O  
ATOM    551  NE2 GLN A  74      60.696  52.576  73.751  1.00 35.81           N  
ATOM    552  N   GLU A  75      62.486  54.476  68.544  1.00 31.74           N  
ATOM    553  CA  GLU A  75      62.535  55.374  67.405  1.00 29.01           C  
ATOM    554  C   GLU A  75      62.731  54.581  66.126  1.00 26.49           C  
ATOM    555  O   GLU A  75      62.047  54.812  65.129  1.00 26.48           O  
ATOM    556  CB  GLU A  75      63.696  56.357  67.566  1.00 36.45           C  
ATOM    557  CG  GLU A  75      63.322  57.802  67.311  1.00 50.41           C  
ATOM    558  CD  GLU A  75      61.953  58.154  67.880  1.00 61.50           C  
ATOM    559  OE1 GLU A  75      60.932  57.781  67.252  1.00 64.38           O  
ATOM    560  OE2 GLU A  75      61.903  58.801  68.955  1.00 62.76           O  
ATOM    561  N   LEU A  76      63.677  53.644  66.170  1.00 24.15           N  
ATOM    562  CA  LEU A  76      64.010  52.806  65.025  1.00 18.09           C  
ATOM    563  C   LEU A  76      62.900  51.834  64.650  1.00 18.78           C  
ATOM    564  O   LEU A  76      62.710  51.537  63.469  1.00 21.19           O  
ATOM    565  CB  LEU A  76      65.301  52.027  65.302  1.00 17.58           C  
ATOM    566  CG  LEU A  76      65.678  50.877  64.357  1.00 13.96           C  
ATOM    567  CD1 LEU A  76      66.365  51.426  63.107  1.00 13.41           C  
ATOM    568  CD2 LEU A  76      66.598  49.898  65.082  1.00  6.26           C  
ATOM    569  N   MET A  77      62.161  51.343  65.641  1.00 15.38           N  
ATOM    570  CA  MET A  77      61.091  50.395  65.360  1.00 17.28           C  
ATOM    571  C   MET A  77      59.885  51.126  64.798  1.00 20.59           C  
ATOM    572  O   MET A  77      59.101  50.577  64.013  1.00 21.74           O  
ATOM    573  CB  MET A  77      60.696  49.633  66.623  1.00 15.28           C  
ATOM    574  CG  MET A  77      59.810  48.432  66.347  1.00 14.31           C  
ATOM    575  SD  MET A  77      60.645  47.202  65.365  1.00 27.16           S  
ATOM    576  CE  MET A  77      59.788  47.345  63.833  1.00 25.74           C  
ATOM    577  N   ASN A  78      59.746  52.377  65.202  1.00 24.41           N  
ATOM    578  CA  ASN A  78      58.650  53.193  64.726  1.00 27.47           C  
ATOM    579  C   ASN A  78      58.859  53.473  63.242  1.00 26.64           C  
ATOM    580  O   ASN A  78      57.917  53.447  62.454  1.00 27.72           O  
ATOM    581  CB  ASN A  78      58.604  54.495  65.506  1.00 35.54           C  
ATOM    582  CG  ASN A  78      57.198  54.923  65.810  1.00 50.32           C  
ATOM    583  OD1 ASN A  78      56.789  56.036  65.474  1.00 63.18           O  
ATOM    584  ND2 ASN A  78      56.435  54.033  66.441  1.00 53.90           N  
ATOM    585  N   THR A  79      60.112  53.732  62.880  1.00 26.80           N  
ATOM    586  CA  THR A  79      60.513  54.018  61.503  1.00 24.68           C  
ATOM    587  C   THR A  79      60.439  52.760  60.630  1.00 23.43           C  
ATOM    588  O   THR A  79      59.942  52.808  59.503  1.00 22.15           O  
ATOM    589  CB  THR A  79      61.959  54.558  61.466  1.00 29.17           C  
ATOM    590  OG1 THR A  79      62.035  55.758  62.248  1.00 29.90           O  
ATOM    591  CG2 THR A  79      62.404  54.830  60.031  1.00 24.72           C  
ATOM    592  N   VAL A  80      60.956  51.646  61.152  1.00 18.42           N  
ATOM    593  CA  VAL A  80      60.931  50.381  60.434  1.00 11.23           C  
ATOM    594  C   VAL A  80      59.471  50.075  60.116  1.00 12.52           C  
ATOM    595  O   VAL A  80      59.095  49.938  58.956  1.00  2.84           O  
ATOM    596  CB  VAL A  80      61.514  49.229  61.297  1.00 11.72           C  
ATOM    597  CG1 VAL A  80      61.007  47.897  60.793  1.00  9.20           C  
ATOM    598  CG2 VAL A  80      63.030  49.248  61.252  1.00  9.71           C  
ATOM    599  N   ALA A  81      58.658  49.988  61.168  1.00 16.81           N  
ATOM    600  CA  ALA A  81      57.226  49.706  61.051  1.00 19.95           C  
ATOM    601  C   ALA A  81      56.504  50.595  60.028  1.00 24.07           C  
ATOM    602  O   ALA A  81      55.574  50.148  59.364  1.00 28.08           O  
ATOM    603  CB  ALA A  81      56.565  49.854  62.416  1.00 19.62           C  
ATOM    604  N   ASN A  82      56.914  51.852  59.912  1.00 19.48           N  
ATOM    605  CA  ASN A  82      56.277  52.750  58.966  1.00 21.98           C  
ATOM    606  C   ASN A  82      56.814  52.488  57.579  1.00 19.93           C  
ATOM    607  O   ASN A  82      56.089  52.538  56.598  1.00 19.41           O  
ATOM    608  CB  ASN A  82      56.530  54.203  59.354  1.00 25.88           C  
ATOM    609  CG  ASN A  82      55.556  54.692  60.404  1.00 36.70           C  
ATOM    610  OD1 ASN A  82      54.474  54.124  60.571  1.00 41.64           O  
ATOM    611  ND2 ASN A  82      55.931  55.748  61.126  1.00 42.27           N  
ATOM    612  N   HIS A  83      58.101  52.201  57.502  1.00 20.89           N  
ATOM    613  CA  HIS A  83      58.728  51.921  56.223  1.00 19.93           C  
ATOM    614  C   HIS A  83      58.125  50.657  55.598  1.00 19.66           C  
ATOM    615  O   HIS A  83      57.958  50.572  54.384  1.00 22.50           O  
ATOM    616  CB  HIS A  83      60.236  51.743  56.422  1.00 17.18           C  
ATOM    617  CG  HIS A  83      60.987  51.466  55.156  1.00 19.16           C  
ATOM    618  ND1 HIS A  83      61.312  52.454  54.252  1.00 23.37           N  
ATOM    619  CD2 HIS A  83      61.481  50.313  54.648  1.00 21.70           C  
ATOM    620  CE1 HIS A  83      61.974  51.920  53.240  1.00 26.12           C  
ATOM    621  NE2 HIS A  83      62.090  50.621  53.457  1.00 21.43           N  
ATOM    622  N   PHE A  84      57.778  49.687  56.438  1.00 15.97           N  
ATOM    623  CA  PHE A  84      57.236  48.421  55.964  1.00 16.09           C  
ATOM    624  C   PHE A  84      55.719  48.264  56.090  1.00 17.57           C  
ATOM    625  O   PHE A  84      55.179  47.187  55.825  1.00 12.15           O  
ATOM    626  CB  PHE A  84      57.939  47.277  56.694  1.00 11.20           C  
ATOM    627  CG  PHE A  84      59.362  47.081  56.275  1.00  5.79           C  
ATOM    628  CD1 PHE A  84      59.703  47.020  54.912  1.00  6.48           C  
ATOM    629  CD2 PHE A  84      60.370  46.957  57.226  1.00  2.00           C  
ATOM    630  CE1 PHE A  84      61.036  46.834  54.508  1.00  2.00           C  
ATOM    631  CE2 PHE A  84      61.702  46.773  56.835  1.00  2.00           C  
ATOM    632  CZ  PHE A  84      62.037  46.711  55.474  1.00  2.00           C  
ATOM    633  N   HIS A  85      55.045  49.341  56.486  1.00 23.42           N  
ATOM    634  CA  HIS A  85      53.591  49.355  56.648  1.00 26.42           C  
ATOM    635  C   HIS A  85      53.057  48.418  57.726  1.00 24.09           C  
ATOM    636  O   HIS A  85      51.996  47.826  57.567  1.00 28.35           O  
ATOM    637  CB  HIS A  85      52.906  49.047  55.313  1.00 34.97           C  
ATOM    638  CG  HIS A  85      53.292  49.989  54.215  1.00 44.58           C  
ATOM    639  ND1 HIS A  85      53.763  49.556  52.994  1.00 46.33           N  
ATOM    640  CD2 HIS A  85      53.320  51.343  54.172  1.00 46.18           C  
ATOM    641  CE1 HIS A  85      54.069  50.603  52.248  1.00 49.80           C  
ATOM    642  NE2 HIS A  85      53.810  51.698  52.939  1.00 48.09           N  
ATOM    643  N   GLY A  86      53.796  48.286  58.823  1.00 24.37           N  
ATOM    644  CA  GLY A  86      53.358  47.439  59.916  1.00 23.67           C  
ATOM    645  C   GLY A  86      53.492  45.940  59.723  1.00 22.80           C  
ATOM    646  O   GLY A  86      52.779  45.171  60.373  1.00 24.88           O  
ATOM    647  N   LYS A  87      54.396  45.521  58.842  1.00 19.80           N  
ATOM    648  CA  LYS A  87      54.616  44.101  58.581  1.00 17.47           C  
ATOM    649  C   LYS A  87      56.102  43.802  58.570  1.00 16.72           C  
ATOM    650  O   LYS A  87      56.864  44.386  57.798  1.00 14.85           O  
ATOM    651  CB  LYS A  87      54.020  43.706  57.237  1.00 20.96           C  
ATOM    652  CG  LYS A  87      52.554  44.008  57.121  1.00 26.53           C  
ATOM    653  CD  LYS A  87      51.732  42.915  57.766  1.00 35.38           C  
ATOM    654  CE  LYS A  87      50.888  42.196  56.724  1.00 42.39           C  
ATOM    655  NZ  LYS A  87      50.452  43.107  55.620  1.00 45.34           N  
ATOM    656  N   LEU A  88      56.521  42.893  59.434  1.00 12.71           N  
ATOM    657  CA  LEU A  88      57.921  42.551  59.496  1.00 11.99           C  
ATOM    658  C   LEU A  88      58.046  41.054  59.564  1.00 13.14           C  
ATOM    659  O   LEU A  88      57.527  40.422  60.476  1.00 10.28           O  
ATOM    660  CB  LEU A  88      58.574  43.188  60.712  1.00  5.05           C  
ATOM    661  CG  LEU A  88      60.097  43.097  60.673  1.00 15.56           C  
ATOM    662  CD1 LEU A  88      60.637  44.067  59.622  1.00 15.51           C  
ATOM    663  CD2 LEU A  88      60.672  43.408  62.050  1.00  8.71           C  
ATOM    664  N   ASN A  89      58.733  40.493  58.575  1.00 15.53           N  
ATOM    665  CA  ASN A  89      58.933  39.058  58.494  1.00 13.13           C  
ATOM    666  C   ASN A  89      60.166  38.613  59.260  1.00 11.61           C  
ATOM    667  O   ASN A  89      60.121  37.660  60.036  1.00  7.64           O  
ATOM    668  CB  ASN A  89      59.079  38.631  57.029  1.00  9.08           C  
ATOM    669  CG  ASN A  89      57.756  38.628  56.279  1.00 19.36           C  
ATOM    670  OD1 ASN A  89      57.479  39.522  55.481  1.00 19.03           O  
ATOM    671  ND2 ASN A  89      56.931  37.616  56.532  1.00 26.34           N  
ATOM    672  N   ILE A  90      61.264  39.330  59.050  1.00 11.96           N  
ATOM    673  CA  ILE A  90      62.536  38.969  59.655  1.00  8.81           C  
ATOM    674  C   ILE A  90      63.193  40.017  60.542  1.00 12.86           C  
ATOM    675  O   ILE A  90      63.229  41.203  60.202  1.00  9.02           O  
ATOM    676  CB  ILE A  90      63.532  38.600  58.539  1.00  2.00           C  
ATOM    677  CG1 ILE A  90      62.843  37.675  57.530  1.00  2.00           C  
ATOM    678  CG2 ILE A  90      64.781  37.970  59.118  1.00  2.00           C  
ATOM    679  CD1 ILE A  90      63.671  37.377  56.311  1.00  2.00           C  
ATOM    680  N   LEU A  91      63.698  39.564  61.691  1.00 12.74           N  
ATOM    681  CA  LEU A  91      64.443  40.428  62.617  1.00 11.65           C  
ATOM    682  C   LEU A  91      65.715  39.672  62.989  1.00  9.93           C  
ATOM    683  O   LEU A  91      65.652  38.613  63.606  1.00 10.71           O  
ATOM    684  CB  LEU A  91      63.655  40.762  63.897  1.00  6.94           C  
ATOM    685  CG  LEU A  91      64.474  41.508  64.974  1.00  4.62           C  
ATOM    686  CD1 LEU A  91      64.931  42.848  64.436  1.00  2.00           C  
ATOM    687  CD2 LEU A  91      63.656  41.702  66.246  1.00  2.78           C  
ATOM    688  N   VAL A  92      66.861  40.205  62.574  1.00  9.74           N  
ATOM    689  CA  VAL A  92      68.154  39.602  62.870  1.00  5.65           C  
ATOM    690  C   VAL A  92      68.864  40.540  63.848  1.00  8.23           C  
ATOM    691  O   VAL A  92      69.235  41.662  63.496  1.00 10.65           O  
ATOM    692  CB  VAL A  92      69.012  39.446  61.586  1.00  4.08           C  
ATOM    693  CG1 VAL A  92      70.304  38.728  61.895  1.00  2.00           C  
ATOM    694  CG2 VAL A  92      68.234  38.687  60.523  1.00  6.43           C  
ATOM    695  N   ASN A  93      69.017  40.089  65.087  1.00  6.52           N  
ATOM    696  CA  ASN A  93      69.690  40.872  66.118  1.00  7.26           C  
ATOM    697  C   ASN A  93      71.178  40.580  66.046  1.00  3.94           C  
ATOM    698  O   ASN A  93      71.704  39.769  66.792  1.00  2.00           O  
ATOM    699  CB  ASN A  93      69.132  40.513  67.490  1.00  7.80           C  
ATOM    700  CG  ASN A  93      67.794  41.165  67.745  1.00  9.60           C  
ATOM    701  OD1 ASN A  93      66.801  40.496  68.031  1.00  4.85           O  
ATOM    702  ND2 ASN A  93      67.759  42.487  67.623  1.00  6.74           N  
ATOM    703  N   ASN A  94      71.843  41.264  65.123  1.00  9.07           N  
ATOM    704  CA  ASN A  94      73.266  41.085  64.863  1.00 10.57           C  
ATOM    705  C   ASN A  94      74.235  41.996  65.622  1.00 11.27           C  
ATOM    706  O   ASN A  94      75.379  41.628  65.830  1.00 14.36           O  
ATOM    707  CB  ASN A  94      73.501  41.239  63.353  1.00 11.42           C  
ATOM    708  CG  ASN A  94      74.937  40.998  62.952  1.00 15.15           C  
ATOM    709  OD1 ASN A  94      75.352  39.859  62.749  1.00 17.13           O  
ATOM    710  ND2 ASN A  94      75.705  42.075  62.824  1.00  9.80           N  
ATOM    711  N   ALA A  95      73.795  43.174  66.046  1.00  6.71           N  
ATOM    712  CA  ALA A  95      74.708  44.088  66.723  1.00  9.25           C  
ATOM    713  C   ALA A  95      75.323  43.587  68.034  1.00 11.41           C  
ATOM    714  O   ALA A  95      74.667  42.925  68.848  1.00 14.62           O  
ATOM    715  CB  ALA A  95      74.020  45.442  66.952  1.00  3.07           C  
ATOM    716  N   GLY A  96      76.596  43.923  68.224  1.00  8.29           N  
ATOM    717  CA  GLY A  96      77.300  43.543  69.430  1.00  7.52           C  
ATOM    718  C   GLY A  96      78.685  44.144  69.527  1.00  5.12           C  
ATOM    719  O   GLY A  96      79.259  44.572  68.526  1.00  9.97           O  
ATOM    720  N   ILE A  97      79.212  44.178  70.748  1.00  6.19           N  
ATOM    721  CA  ILE A  97      80.549  44.685  71.036  1.00  2.00           C  
ATOM    722  C   ILE A  97      81.262  43.778  72.044  1.00  6.19           C  
ATOM    723  O   ILE A  97      80.648  42.905  72.677  1.00  7.05           O  
ATOM    724  CB  ILE A  97      80.513  46.125  71.625  1.00  8.18           C  
ATOM    725  CG1 ILE A  97      79.795  46.129  72.984  1.00 10.41           C  
ATOM    726  CG2 ILE A  97      79.832  47.070  70.654  1.00  9.06           C  
ATOM    727  CD1 ILE A  97      80.512  46.954  74.077  1.00  2.00           C  
ATOM    728  N   VAL A  98      82.563  43.997  72.198  1.00 10.45           N  
ATOM    729  CA  VAL A  98      83.375  43.223  73.127  1.00 12.21           C  
ATOM    730  C   VAL A  98      84.396  44.100  73.823  1.00 12.05           C  
ATOM    731  O   VAL A  98      84.993  44.983  73.194  1.00  8.39           O  
ATOM    732  CB  VAL A  98      84.183  42.121  72.421  1.00 16.21           C  
ATOM    733  CG1 VAL A  98      83.509  40.794  72.596  1.00 20.82           C  
ATOM    734  CG2 VAL A  98      84.364  42.468  70.954  1.00 20.32           C  
ATOM    735  N   ILE A  99      84.592  43.840  75.115  1.00  4.76           N  
ATOM    736  CA  ILE A  99      85.572  44.548  75.922  1.00  3.57           C  
ATOM    737  C   ILE A  99      86.392  43.416  76.535  1.00  4.95           C  
ATOM    738  O   ILE A  99      85.939  42.701  77.432  1.00  5.20           O  
ATOM    739  CB  ILE A  99      84.892  45.408  76.999  1.00  6.45           C  
ATOM    740  CG1 ILE A  99      84.273  46.640  76.341  1.00  7.67           C  
ATOM    741  CG2 ILE A  99      85.903  45.894  78.002  1.00  2.00           C  
ATOM    742  CD1 ILE A  99      83.102  47.212  77.107  1.00 16.84           C  
ATOM    743  N   TYR A 100      87.602  43.266  76.013  1.00  2.00           N  
ATOM    744  CA  TYR A 100      88.510  42.205  76.397  1.00  2.00           C  
ATOM    745  C   TYR A 100      89.204  42.324  77.732  1.00  2.00           C  
ATOM    746  O   TYR A 100      90.411  42.539  77.809  1.00  2.64           O  
ATOM    747  CB  TYR A 100      89.548  42.016  75.292  1.00  3.66           C  
ATOM    748  CG  TYR A 100      88.942  41.660  73.946  1.00  2.59           C  
ATOM    749  CD1 TYR A 100      88.279  40.440  73.751  1.00  2.78           C  
ATOM    750  CD2 TYR A 100      89.056  42.524  72.863  1.00  2.00           C  
ATOM    751  CE1 TYR A 100      87.752  40.092  72.510  1.00  4.30           C  
ATOM    752  CE2 TYR A 100      88.537  42.191  71.620  1.00 11.28           C  
ATOM    753  CZ  TYR A 100      87.887  40.975  71.442  1.00 15.02           C  
ATOM    754  OH  TYR A 100      87.400  40.648  70.188  1.00 12.78           O  
ATOM    755  N   LYS A 101      88.442  42.147  78.796  1.00  4.65           N  
ATOM    756  CA  LYS A 101      89.011  42.221  80.119  1.00  2.00           C  
ATOM    757  C   LYS A 101      88.619  40.988  80.885  1.00  7.05           C  
ATOM    758  O   LYS A 101      87.632  40.314  80.554  1.00  5.40           O  
ATOM    759  CB  LYS A 101      88.487  43.442  80.864  1.00  2.00           C  
ATOM    760  CG  LYS A 101      88.575  44.745  80.096  1.00  2.62           C  
ATOM    761  CD  LYS A 101      88.886  45.907  81.024  1.00  2.67           C  
ATOM    762  CE  LYS A 101      88.656  47.237  80.329  1.00  2.00           C  
ATOM    763  NZ  LYS A 101      88.263  48.316  81.277  1.00  4.85           N  
ATOM    764  N   GLU A 102      89.411  40.689  81.907  1.00 10.31           N  
ATOM    765  CA  GLU A 102      89.123  39.568  82.774  1.00 12.02           C  
ATOM    766  C   GLU A 102      87.878  40.048  83.509  1.00 14.47           C  
ATOM    767  O   GLU A 102      87.630  41.251  83.586  1.00  8.61           O  
ATOM    768  CB  GLU A 102      90.275  39.341  83.756  1.00 13.75           C  
ATOM    769  CG  GLU A 102      91.518  38.754  83.105  1.00 20.07           C  
ATOM    770  CD  GLU A 102      92.457  38.091  84.100  1.00 30.31           C  
ATOM    771  OE1 GLU A 102      92.023  37.804  85.244  1.00 34.01           O  
ATOM    772  OE2 GLU A 102      93.633  37.861  83.734  1.00 34.68           O  
ATOM    773  N   ALA A 103      87.100  39.115  84.043  1.00 16.16           N  
ATOM    774  CA  ALA A 103      85.879  39.466  84.748  1.00 13.11           C  
ATOM    775  C   ALA A 103      86.108  40.429  85.910  1.00 13.56           C  
ATOM    776  O   ALA A 103      85.343  41.366  86.105  1.00  5.14           O  
ATOM    777  CB  ALA A 103      85.199  38.202  85.255  1.00 10.93           C  
ATOM    778  N   LYS A 104      87.169  40.203  86.674  1.00 14.17           N  
ATOM    779  CA  LYS A 104      87.430  41.046  87.827  1.00 17.00           C  
ATOM    780  C   LYS A 104      87.915  42.439  87.483  1.00 17.48           C  
ATOM    781  O   LYS A 104      87.823  43.341  88.311  1.00 22.02           O  
ATOM    782  CB  LYS A 104      88.437  40.369  88.759  1.00 15.58           C  
ATOM    783  CG  LYS A 104      89.842  40.297  88.196  1.00 20.85           C  
ATOM    784  CD  LYS A 104      90.840  39.820  89.234  1.00 18.06           C  
ATOM    785  CE  LYS A 104      92.240  40.287  88.888  1.00 25.73           C  
ATOM    786  NZ  LYS A 104      92.297  41.768  88.682  1.00 33.08           N  
ATOM    787  N   ASP A 105      88.429  42.623  86.271  1.00 19.93           N  
ATOM    788  CA  ASP A 105      88.939  43.937  85.862  1.00 18.62           C  
ATOM    789  C   ASP A 105      87.886  44.831  85.215  1.00 17.22           C  
ATOM    790  O   ASP A 105      88.118  46.023  85.025  1.00 22.90           O  
ATOM    791  CB  ASP A 105      90.135  43.772  84.910  1.00 15.20           C  
ATOM    792  CG  ASP A 105      91.386  43.303  85.626  1.00  9.45           C  
ATOM    793  OD1 ASP A 105      92.229  42.648  84.981  1.00 22.46           O  
ATOM    794  OD2 ASP A 105      91.530  43.578  86.838  1.00 14.32           O  
ATOM    795  N   TYR A 106      86.732  44.258  84.881  1.00 15.60           N  
ATOM    796  CA  TYR A 106      85.645  45.008  84.262  1.00 11.91           C  
ATOM    797  C   TYR A 106      85.120  46.094  85.196  1.00 15.30           C  
ATOM    798  O   TYR A 106      84.833  45.827  86.369  1.00 17.16           O  
ATOM    799  CB  TYR A 106      84.481  44.079  83.930  1.00 16.45           C  
ATOM    800  CG  TYR A 106      84.322  43.728  82.473  1.00  9.45           C  
ATOM    801  CD1 TYR A 106      83.224  44.172  81.751  1.00  6.58           C  
ATOM    802  CD2 TYR A 106      85.237  42.890  81.836  1.00  5.68           C  
ATOM    803  CE1 TYR A 106      83.032  43.782  80.423  1.00  7.63           C  
ATOM    804  CE2 TYR A 106      85.058  42.497  80.519  1.00  3.19           C  
ATOM    805  CZ  TYR A 106      83.952  42.943  79.817  1.00  3.21           C  
ATOM    806  OH  TYR A 106      83.770  42.549  78.517  1.00  2.00           O  
ATOM    807  N   THR A 107      84.982  47.308  84.668  1.00 11.34           N  
ATOM    808  CA  THR A 107      84.452  48.425  85.441  1.00  8.10           C  
ATOM    809  C   THR A 107      82.941  48.370  85.282  1.00 11.08           C  
ATOM    810  O   THR A 107      82.423  47.715  84.377  1.00 16.03           O  
ATOM    811  CB  THR A 107      84.929  49.801  84.899  1.00  6.94           C  
ATOM    812  OG1 THR A 107      84.528  49.940  83.532  1.00 14.02           O  
ATOM    813  CG2 THR A 107      86.440  49.932  84.980  1.00  2.00           C  
ATOM    814  N   VAL A 108      82.228  49.066  86.152  1.00 14.81           N  
ATOM    815  CA  VAL A 108      80.775  49.095  86.075  1.00 12.83           C  
ATOM    816  C   VAL A 108      80.285  49.716  84.765  1.00 13.32           C  
ATOM    817  O   VAL A 108      79.280  49.287  84.194  1.00 17.94           O  
ATOM    818  CB  VAL A 108      80.203  49.869  87.267  1.00 12.07           C  
ATOM    819  CG1 VAL A 108      79.052  50.762  86.825  1.00 12.44           C  
ATOM    820  CG2 VAL A 108      79.751  48.881  88.327  1.00 12.08           C  
ATOM    821  N   GLU A 109      80.996  50.731  84.300  1.00 12.25           N  
ATOM    822  CA  GLU A 109      80.650  51.412  83.062  1.00 17.89           C  
ATOM    823  C   GLU A 109      80.792  50.404  81.923  1.00 15.55           C  
ATOM    824  O   GLU A 109      79.993  50.364  80.985  1.00 16.61           O  
ATOM    825  CB  GLU A 109      81.606  52.589  82.860  1.00 28.96           C  
ATOM    826  CG  GLU A 109      81.193  53.596  81.799  1.00 47.71           C  
ATOM    827  CD  GLU A 109      82.154  54.777  81.713  1.00 55.32           C  
ATOM    828  OE1 GLU A 109      83.301  54.588  81.244  1.00 53.14           O  
ATOM    829  OE2 GLU A 109      81.758  55.894  82.119  1.00 64.68           O  
ATOM    830  N   ASP A 110      81.831  49.586  82.027  1.00  8.59           N  
ATOM    831  CA  ASP A 110      82.109  48.564  81.040  1.00  7.83           C  
ATOM    832  C   ASP A 110      80.963  47.564  81.020  1.00  8.66           C  
ATOM    833  O   ASP A 110      80.423  47.235  79.967  1.00 13.52           O  
ATOM    834  CB  ASP A 110      83.403  47.849  81.404  1.00  6.55           C  
ATOM    835  CG  ASP A 110      84.619  48.536  80.836  1.00  8.72           C  
ATOM    836  OD1 ASP A 110      85.749  48.192  81.254  1.00 10.69           O  
ATOM    837  OD2 ASP A 110      84.441  49.419  79.970  1.00  6.16           O  
ATOM    838  N   TYR A 111      80.600  47.082  82.201  1.00  7.58           N  
ATOM    839  CA  TYR A 111      79.523  46.123  82.330  1.00  7.46           C  
ATOM    840  C   TYR A 111      78.224  46.670  81.764  1.00  9.14           C  
ATOM    841  O   TYR A 111      77.507  45.988  81.033  1.00 13.32           O  
ATOM    842  CB  TYR A 111      79.319  45.767  83.789  1.00  6.09           C  
ATOM    843  CG  TYR A 111      78.169  44.823  84.008  1.00  5.62           C  
ATOM    844  CD1 TYR A 111      76.945  45.287  84.471  1.00  4.70           C  
ATOM    845  CD2 TYR A 111      78.311  43.455  83.773  1.00 14.27           C  
ATOM    846  CE1 TYR A 111      75.886  44.418  84.704  1.00 12.76           C  
ATOM    847  CE2 TYR A 111      77.255  42.574  84.004  1.00 21.98           C  
ATOM    848  CZ  TYR A 111      76.051  43.066  84.471  1.00 15.51           C  
ATOM    849  OH  TYR A 111      75.013  42.207  84.723  1.00 31.38           O  
ATOM    850  N   SER A 112      77.913  47.906  82.116  1.00 12.65           N  
ATOM    851  CA  SER A 112      76.693  48.520  81.628  1.00 13.22           C  
ATOM    852  C   SER A 112      76.697  48.557  80.108  1.00  9.36           C  
ATOM    853  O   SER A 112      75.696  48.246  79.478  1.00 12.41           O  
ATOM    854  CB  SER A 112      76.558  49.938  82.185  1.00 12.12           C  
ATOM    855  OG  SER A 112      76.404  49.897  83.591  1.00 24.11           O  
ATOM    856  N   LEU A 113      77.825  48.928  79.517  1.00  8.72           N  
ATOM    857  CA  LEU A 113      77.902  49.009  78.067  1.00  9.79           C  
ATOM    858  C   LEU A 113      77.617  47.698  77.334  1.00 11.18           C  
ATOM    859  O   LEU A 113      76.703  47.636  76.511  1.00 11.73           O  
ATOM    860  CB  LEU A 113      79.264  49.554  77.631  1.00  4.37           C  
ATOM    861  CG  LEU A 113      79.317  49.922  76.146  1.00  3.05           C  
ATOM    862  CD1 LEU A 113      78.062  50.708  75.751  1.00  2.00           C  
ATOM    863  CD2 LEU A 113      80.565  50.721  75.867  1.00  2.00           C  
ATOM    864  N   ILE A 114      78.390  46.653  77.628  1.00 12.87           N  
ATOM    865  CA  ILE A 114      78.213  45.357  76.961  1.00 11.14           C  
ATOM    866  C   ILE A 114      76.834  44.717  77.169  1.00 11.59           C  
ATOM    867  O   ILE A 114      76.221  44.212  76.226  1.00 13.29           O  
ATOM    868  CB  ILE A 114      79.310  44.339  77.400  1.00  8.12           C  
ATOM    869  CG1 ILE A 114      79.393  43.202  76.387  1.00 13.29           C  
ATOM    870  CG2 ILE A 114      78.986  43.748  78.766  1.00 11.84           C  
ATOM    871  CD1 ILE A 114      80.764  42.600  76.235  1.00  6.49           C  
ATOM    872  N   MET A 115      76.336  44.747  78.396  1.00 13.29           N  
ATOM    873  CA  MET A 115      75.049  44.134  78.673  1.00 10.20           C  
ATOM    874  C   MET A 115      73.936  44.816  77.913  1.00  9.28           C  
ATOM    875  O   MET A 115      73.062  44.158  77.347  1.00 11.02           O  
ATOM    876  CB  MET A 115      74.752  44.181  80.166  1.00  7.22           C  
ATOM    877  CG  MET A 115      73.715  43.166  80.604  1.00 15.02           C  
ATOM    878  SD  MET A 115      74.416  41.520  80.731  1.00 31.33           S  
ATOM    879  CE  MET A 115      72.995  40.539  80.377  1.00 22.20           C  
ATOM    880  N   SER A 116      73.978  46.142  77.896  1.00 10.01           N  
ATOM    881  CA  SER A 116      72.963  46.943  77.229  1.00 10.36           C  
ATOM    882  C   SER A 116      72.895  46.730  75.716  1.00  9.53           C  
ATOM    883  O   SER A 116      71.816  46.588  75.147  1.00 14.37           O  
ATOM    884  CB  SER A 116      73.198  48.421  77.538  1.00  9.58           C  
ATOM    885  OG  SER A 116      73.646  49.113  76.388  1.00 23.52           O  
ATOM    886  N   ILE A 117      74.044  46.710  75.059  1.00  8.60           N  
ATOM    887  CA  ILE A 117      74.061  46.518  73.621  1.00  9.08           C  
ATOM    888  C   ILE A 117      73.891  45.047  73.246  1.00  8.13           C  
ATOM    889  O   ILE A 117      73.083  44.723  72.387  1.00 11.28           O  
ATOM    890  CB  ILE A 117      75.374  47.079  73.001  1.00 10.51           C  
ATOM    891  CG1 ILE A 117      75.273  48.599  72.863  1.00  2.00           C  
ATOM    892  CG2 ILE A 117      75.622  46.467  71.634  1.00  9.21           C  
ATOM    893  CD1 ILE A 117      76.582  49.278  72.763  1.00  5.97           C  
ATOM    894  N   ASN A 118      74.622  44.158  73.909  1.00  9.85           N  
ATOM    895  CA  ASN A 118      74.557  42.729  73.604  1.00  9.93           C  
ATOM    896  C   ASN A 118      73.283  41.955  73.948  1.00 10.91           C  
ATOM    897  O   ASN A 118      72.849  41.119  73.152  1.00 11.02           O  
ATOM    898  CB  ASN A 118      75.756  42.015  74.226  1.00  7.98           C  
ATOM    899  CG  ASN A 118      77.052  42.371  73.537  1.00 11.11           C  
ATOM    900  OD1 ASN A 118      77.130  43.378  72.834  1.00  2.00           O  
ATOM    901  ND2 ASN A 118      78.079  41.545  73.731  1.00 11.59           N  
ATOM    902  N   PHE A 119      72.689  42.206  75.113  1.00  9.60           N  
ATOM    903  CA  PHE A 119      71.473  41.487  75.500  1.00  9.57           C  
ATOM    904  C   PHE A 119      70.232  42.355  75.671  1.00 11.22           C  
ATOM    905  O   PHE A 119      69.116  41.908  75.418  1.00 17.08           O  
ATOM    906  CB  PHE A 119      71.698  40.695  76.796  1.00  5.43           C  
ATOM    907  CG  PHE A 119      70.466  39.982  77.295  1.00  8.87           C  
ATOM    908  CD1 PHE A 119      69.963  38.870  76.613  1.00 10.92           C  
ATOM    909  CD2 PHE A 119      69.787  40.435  78.426  1.00 11.52           C  
ATOM    910  CE1 PHE A 119      68.803  38.221  77.048  1.00  2.00           C  
ATOM    911  CE2 PHE A 119      68.620  39.788  78.869  1.00 14.86           C  
ATOM    912  CZ  PHE A 119      68.132  38.678  78.173  1.00  6.36           C  
ATOM    913  N   GLU A 120      70.406  43.593  76.101  1.00 14.33           N  
ATOM    914  CA  GLU A 120      69.244  44.437  76.305  1.00 13.36           C  
ATOM    915  C   GLU A 120      68.581  44.860  75.018  1.00 12.43           C  
ATOM    916  O   GLU A 120      67.394  44.607  74.818  1.00 18.39           O  
ATOM    917  CB  GLU A 120      69.613  45.668  77.110  1.00 20.55           C  
ATOM    918  CG  GLU A 120      68.447  46.591  77.322  1.00 35.66           C  
ATOM    919  CD  GLU A 120      68.466  47.222  78.686  1.00 38.73           C  
ATOM    920  OE1 GLU A 120      67.498  47.941  79.011  1.00 41.35           O  
ATOM    921  OE2 GLU A 120      69.449  46.992  79.426  1.00 39.90           O  
ATOM    922  N   ALA A 121      69.334  45.501  74.132  1.00  6.29           N  
ATOM    923  CA  ALA A 121      68.746  45.950  72.875  1.00  4.60           C  
ATOM    924  C   ALA A 121      68.165  44.801  72.034  1.00  7.29           C  
ATOM    925  O   ALA A 121      67.158  44.985  71.343  1.00 12.75           O  
ATOM    926  CB  ALA A 121      69.770  46.724  72.071  1.00  4.15           C  
ATOM    927  N   ALA A 122      68.786  43.625  72.098  1.00  2.00           N  
ATOM    928  CA  ALA A 122      68.315  42.464  71.338  1.00  7.87           C  
ATOM    929  C   ALA A 122      66.974  42.012  71.885  1.00  7.55           C  
ATOM    930  O   ALA A 122      66.020  41.763  71.132  1.00  4.57           O  
ATOM    931  CB  ALA A 122      69.329  41.316  71.424  1.00  3.43           C  
ATOM    932  N   TYR A 123      66.917  41.922  73.210  1.00  8.44           N  
ATOM    933  CA  TYR A 123      65.712  41.512  73.918  1.00  9.61           C  
ATOM    934  C   TYR A 123      64.587  42.526  73.682  1.00  9.87           C  
ATOM    935  O   TYR A 123      63.484  42.162  73.284  1.00 17.34           O  
ATOM    936  CB  TYR A 123      66.036  41.386  75.416  1.00 16.25           C  
ATOM    937  CG  TYR A 123      64.837  41.376  76.341  1.00 15.02           C  
ATOM    938  CD1 TYR A 123      63.746  40.543  76.094  1.00 11.52           C  
ATOM    939  CD2 TYR A 123      64.787  42.218  77.452  1.00 12.66           C  
ATOM    940  CE1 TYR A 123      62.637  40.546  76.918  1.00 11.30           C  
ATOM    941  CE2 TYR A 123      63.666  42.228  78.292  1.00 18.45           C  
ATOM    942  CZ  TYR A 123      62.598  41.389  78.012  1.00  9.37           C  
ATOM    943  OH  TYR A 123      61.479  41.404  78.807  1.00 12.86           O  
ATOM    944  N   HIS A 124      64.896  43.798  73.912  1.00 14.12           N  
ATOM    945  CA  HIS A 124      63.963  44.916  73.753  1.00  8.01           C  
ATOM    946  C   HIS A 124      63.450  45.084  72.320  1.00  9.86           C  
ATOM    947  O   HIS A 124      62.277  45.394  72.114  1.00  9.95           O  
ATOM    948  CB  HIS A 124      64.660  46.202  74.216  1.00 11.37           C  
ATOM    949  CG  HIS A 124      63.774  47.412  74.236  1.00 13.78           C  
ATOM    950  ND1 HIS A 124      64.246  48.680  73.974  1.00 13.44           N  
ATOM    951  CD2 HIS A 124      62.454  47.548  74.500  1.00  9.38           C  
ATOM    952  CE1 HIS A 124      63.255  49.546  74.075  1.00  9.90           C  
ATOM    953  NE2 HIS A 124      62.156  48.885  74.394  1.00 10.25           N  
ATOM    954  N   LEU A 125      64.327  44.890  71.334  1.00 11.38           N  
ATOM    955  CA  LEU A 125      63.939  45.020  69.931  1.00  9.48           C  
ATOM    956  C   LEU A 125      63.023  43.894  69.490  1.00  9.38           C  
ATOM    957  O   LEU A 125      62.102  44.100  68.707  1.00 13.53           O  
ATOM    958  CB  LEU A 125      65.171  45.031  69.030  1.00  9.19           C  
ATOM    959  CG  LEU A 125      65.769  46.413  68.750  1.00 19.47           C  
ATOM    960  CD1 LEU A 125      66.725  46.314  67.591  1.00 20.42           C  
ATOM    961  CD2 LEU A 125      64.678  47.428  68.447  1.00  8.50           C  
ATOM    962  N   SER A 126      63.279  42.691  69.980  1.00  9.02           N  
ATOM    963  CA  SER A 126      62.448  41.561  69.611  1.00  9.06           C  
ATOM    964  C   SER A 126      61.023  41.827  70.087  1.00 13.62           C  
ATOM    965  O   SER A 126      60.047  41.496  69.405  1.00 14.84           O  
ATOM    966  CB  SER A 126      63.000  40.296  70.250  1.00  2.00           C  
ATOM    967  OG  SER A 126      64.339  40.109  69.837  1.00  2.00           O  
ATOM    968  N   VAL A 127      60.908  42.443  71.257  1.00  9.82           N  
ATOM    969  CA  VAL A 127      59.601  42.742  71.817  1.00 13.59           C  
ATOM    970  C   VAL A 127      58.838  43.818  71.023  1.00 14.63           C  
ATOM    971  O   VAL A 127      57.679  43.621  70.648  1.00 15.65           O  
ATOM    972  CB  VAL A 127      59.744  43.160  73.287  1.00 15.26           C  
ATOM    973  CG1 VAL A 127      58.408  43.576  73.841  1.00 15.08           C  
ATOM    974  CG2 VAL A 127      60.318  41.997  74.089  1.00  9.05           C  
ATOM    975  N   LEU A 128      59.490  44.949  70.760  1.00  9.33           N  
ATOM    976  CA  LEU A 128      58.865  46.033  70.011  1.00  7.60           C  
ATOM    977  C   LEU A 128      58.482  45.551  68.614  1.00  8.00           C  
ATOM    978  O   LEU A 128      57.590  46.098  67.972  1.00 10.38           O  
ATOM    979  CB  LEU A 128      59.826  47.221  69.888  1.00  5.24           C  
ATOM    980  CG  LEU A 128      60.276  47.988  71.133  1.00  2.00           C  
ATOM    981  CD1 LEU A 128      61.508  48.845  70.799  1.00  2.00           C  
ATOM    982  CD2 LEU A 128      59.149  48.864  71.602  1.00  2.00           C  
ATOM    983  N   ALA A 129      59.168  44.525  68.143  1.00 10.49           N  
ATOM    984  CA  ALA A 129      58.914  43.989  66.822  1.00 11.32           C  
ATOM    985  C   ALA A 129      57.777  42.979  66.813  1.00 10.74           C  
ATOM    986  O   ALA A 129      57.104  42.821  65.800  1.00 12.12           O  
ATOM    987  CB  ALA A 129      60.185  43.347  66.277  1.00 13.66           C  
ATOM    988  N   HIS A 130      57.550  42.312  67.943  1.00 15.44           N  
ATOM    989  CA  HIS A 130      56.507  41.291  68.039  1.00 15.06           C  
ATOM    990  C   HIS A 130      55.226  41.532  67.231  1.00 18.31           C  
ATOM    991  O   HIS A 130      54.796  40.648  66.484  1.00 24.67           O  
ATOM    992  CB  HIS A 130      56.129  41.036  69.502  1.00  9.00           C  
ATOM    993  CG  HIS A 130      55.232  39.852  69.688  1.00  2.00           C  
ATOM    994  ND1 HIS A 130      53.942  39.961  70.161  1.00  6.40           N  
ATOM    995  CD2 HIS A 130      55.425  38.538  69.428  1.00  4.91           C  
ATOM    996  CE1 HIS A 130      53.379  38.766  70.185  1.00  5.76           C  
ATOM    997  NE2 HIS A 130      54.257  37.884  69.745  1.00 10.17           N  
ATOM    998  N   PRO A 131      54.596  42.719  67.370  1.00 17.25           N  
ATOM    999  CA  PRO A 131      53.356  43.019  66.631  1.00 10.03           C  
ATOM   1000  C   PRO A 131      53.486  43.048  65.101  1.00 11.58           C  
ATOM   1001  O   PRO A 131      52.557  42.686  64.383  1.00 14.86           O  
ATOM   1002  CB  PRO A 131      52.905  44.379  67.183  1.00  2.00           C  
ATOM   1003  CG  PRO A 131      53.776  44.672  68.349  1.00  6.00           C  
ATOM   1004  CD  PRO A 131      55.016  43.839  68.234  1.00 14.63           C  
ATOM   1005  N   PHE A 132      54.636  43.488  64.605  1.00 15.11           N  
ATOM   1006  CA  PHE A 132      54.881  43.562  63.168  1.00 11.94           C  
ATOM   1007  C   PHE A 132      55.262  42.203  62.606  1.00 10.58           C  
ATOM   1008  O   PHE A 132      55.022  41.911  61.430  1.00  9.66           O  
ATOM   1009  CB  PHE A 132      55.987  44.567  62.904  1.00 15.46           C  
ATOM   1010  CG  PHE A 132      55.833  45.821  63.691  1.00 18.61           C  
ATOM   1011  CD1 PHE A 132      54.771  46.674  63.441  1.00 19.60           C  
ATOM   1012  CD2 PHE A 132      56.721  46.131  64.712  1.00 24.42           C  
ATOM   1013  CE1 PHE A 132      54.589  47.820  64.199  1.00 24.32           C  
ATOM   1014  CE2 PHE A 132      56.547  47.279  65.478  1.00 25.06           C  
ATOM   1015  CZ  PHE A 132      55.476  48.123  65.219  1.00 23.43           C  
ATOM   1016  N   LEU A 133      55.878  41.383  63.451  1.00 11.57           N  
ATOM   1017  CA  LEU A 133      56.265  40.039  63.059  1.00 12.35           C  
ATOM   1018  C   LEU A 133      54.969  39.244  63.015  1.00 14.52           C  
ATOM   1019  O   LEU A 133      54.737  38.451  62.104  1.00 13.00           O  
ATOM   1020  CB  LEU A 133      57.209  39.435  64.091  1.00 10.37           C  
ATOM   1021  CG  LEU A 133      58.679  39.822  64.005  1.00  7.96           C  
ATOM   1022  CD1 LEU A 133      59.304  39.578  65.362  1.00 12.57           C  
ATOM   1023  CD2 LEU A 133      59.393  38.997  62.938  1.00  8.43           C  
ATOM   1024  N   LYS A 134      54.128  39.483  64.018  1.00 18.22           N  
ATOM   1025  CA  LYS A 134      52.834  38.828  64.134  1.00 20.68           C  
ATOM   1026  C   LYS A 134      51.918  39.275  62.993  1.00 18.13           C  
ATOM   1027  O   LYS A 134      51.265  38.457  62.346  1.00 21.84           O  
ATOM   1028  CB  LYS A 134      52.196  39.181  65.480  1.00 23.31           C  
ATOM   1029  CG  LYS A 134      50.954  38.376  65.815  1.00 33.65           C  
ATOM   1030  CD  LYS A 134      50.804  38.189  67.315  1.00 39.98           C  
ATOM   1031  CE  LYS A 134      49.376  37.807  67.691  1.00 43.91           C  
ATOM   1032  NZ  LYS A 134      48.412  38.921  67.482  1.00 44.32           N  
ATOM   1033  N   ALA A 135      51.875  40.578  62.747  1.00 19.32           N  
ATOM   1034  CA  ALA A 135      51.037  41.123  61.684  1.00 18.80           C  
ATOM   1035  C   ALA A 135      51.461  40.546  60.347  1.00 18.05           C  
ATOM   1036  O   ALA A 135      50.634  40.307  59.475  1.00 16.91           O  
ATOM   1037  CB  ALA A 135      51.159  42.626  61.653  1.00 13.66           C  
ATOM   1038  N   SER A 136      52.765  40.327  60.206  1.00 21.33           N  
ATOM   1039  CA  SER A 136      53.356  39.783  58.985  1.00 23.09           C  
ATOM   1040  C   SER A 136      52.839  38.389  58.638  1.00 24.60           C  
ATOM   1041  O   SER A 136      52.977  37.938  57.498  1.00 27.51           O  
ATOM   1042  CB  SER A 136      54.878  39.735  59.127  1.00 22.02           C  
ATOM   1043  OG  SER A 136      55.324  38.415  59.368  1.00 19.46           O  
ATOM   1044  N   GLU A 137      52.267  37.708  59.629  1.00 23.25           N  
ATOM   1045  CA  GLU A 137      51.716  36.369  59.450  1.00 27.10           C  
ATOM   1046  C   GLU A 137      52.743  35.241  59.335  1.00 28.07           C  
ATOM   1047  O   GLU A 137      52.389  34.075  59.479  1.00 30.94           O  
ATOM   1048  CB  GLU A 137      50.789  36.345  58.233  1.00 42.69           C  
ATOM   1049  CG  GLU A 137      49.434  36.990  58.471  1.00 58.45           C  
ATOM   1050  CD  GLU A 137      48.326  35.972  58.634  1.00 67.54           C  
ATOM   1051  OE1 GLU A 137      48.251  35.337  59.709  1.00 77.04           O  
ATOM   1052  OE2 GLU A 137      47.528  35.806  57.688  1.00 73.36           O  
ATOM   1053  N   ARG A 138      54.004  35.570  59.063  1.00 24.92           N  
ATOM   1054  CA  ARG A 138      55.051  34.550  58.961  1.00 20.06           C  
ATOM   1055  C   ARG A 138      56.356  35.093  59.516  1.00 19.46           C  
ATOM   1056  O   ARG A 138      57.264  35.435  58.762  1.00 15.79           O  
ATOM   1057  CB  ARG A 138      55.258  34.115  57.510  1.00 19.03           C  
ATOM   1058  CG  ARG A 138      55.849  32.709  57.371  1.00 20.52           C  
ATOM   1059  CD  ARG A 138      56.171  32.359  55.923  1.00 19.01           C  
ATOM   1060  NE  ARG A 138      57.399  33.007  55.463  1.00 20.57           N  
ATOM   1061  CZ  ARG A 138      58.611  32.718  55.923  1.00 22.23           C  
ATOM   1062  NH1 ARG A 138      58.756  31.789  56.858  1.00 25.81           N  
ATOM   1063  NH2 ARG A 138      59.679  33.354  55.446  1.00 20.54           N  
ATOM   1064  N   GLY A 139      56.435  35.156  60.844  1.00 22.80           N  
ATOM   1065  CA  GLY A 139      57.607  35.692  61.519  1.00 14.88           C  
ATOM   1066  C   GLY A 139      58.810  34.799  61.749  1.00 13.29           C  
ATOM   1067  O   GLY A 139      58.711  33.563  61.859  1.00  2.00           O  
ATOM   1068  N   ASN A 140      59.966  35.456  61.830  1.00  8.89           N  
ATOM   1069  CA  ASN A 140      61.227  34.773  62.054  1.00  7.80           C  
ATOM   1070  C   ASN A 140      62.240  35.697  62.707  1.00 13.15           C  
ATOM   1071  O   ASN A 140      62.670  36.691  62.115  1.00 18.33           O  
ATOM   1072  CB  ASN A 140      61.796  34.253  60.739  1.00  5.38           C  
ATOM   1073  CG  ASN A 140      61.664  32.745  60.595  1.00 13.20           C  
ATOM   1074  OD1 ASN A 140      62.032  31.984  61.497  1.00 15.69           O  
ATOM   1075  ND2 ASN A 140      61.147  32.303  59.448  1.00 11.11           N  
ATOM   1076  N   VAL A 141      62.614  35.358  63.938  1.00 14.62           N  
ATOM   1077  CA  VAL A 141      63.596  36.122  64.690  1.00  8.70           C  
ATOM   1078  C   VAL A 141      64.875  35.299  64.788  1.00  8.63           C  
ATOM   1079  O   VAL A 141      64.841  34.124  65.159  1.00  2.38           O  
ATOM   1080  CB  VAL A 141      63.083  36.453  66.122  1.00 10.03           C  
ATOM   1081  CG1 VAL A 141      64.192  37.105  66.953  1.00  5.15           C  
ATOM   1082  CG2 VAL A 141      61.893  37.389  66.040  1.00 12.57           C  
ATOM   1083  N   VAL A 142      66.004  35.906  64.443  1.00  8.27           N  
ATOM   1084  CA  VAL A 142      67.278  35.205  64.522  1.00  7.51           C  
ATOM   1085  C   VAL A 142      68.280  36.039  65.318  1.00 10.44           C  
ATOM   1086  O   VAL A 142      68.538  37.194  64.981  1.00 18.13           O  
ATOM   1087  CB  VAL A 142      67.846  34.900  63.107  1.00  9.36           C  
ATOM   1088  CG1 VAL A 142      69.178  34.187  63.226  1.00  9.60           C  
ATOM   1089  CG2 VAL A 142      66.873  34.021  62.329  1.00  2.00           C  
ATOM   1090  N   PHE A 143      68.820  35.443  66.383  1.00  7.44           N  
ATOM   1091  CA  PHE A 143      69.793  36.082  67.265  1.00  4.13           C  
ATOM   1092  C   PHE A 143      71.204  35.594  66.968  1.00  8.13           C  
ATOM   1093  O   PHE A 143      71.464  34.395  67.032  1.00 13.32           O  
ATOM   1094  CB  PHE A 143      69.520  35.728  68.727  1.00  3.06           C  
ATOM   1095  CG  PHE A 143      68.188  36.149  69.220  1.00  2.00           C  
ATOM   1096  CD1 PHE A 143      68.011  37.400  69.783  1.00  2.00           C  
ATOM   1097  CD2 PHE A 143      67.110  35.288  69.158  1.00  8.44           C  
ATOM   1098  CE1 PHE A 143      66.770  37.789  70.281  1.00  2.00           C  
ATOM   1099  CE2 PHE A 143      65.869  35.669  69.654  1.00  3.78           C  
ATOM   1100  CZ  PHE A 143      65.706  36.925  70.215  1.00  2.00           C  
ATOM   1101  N   ILE A 144      72.126  36.503  66.672  1.00  6.31           N  
ATOM   1102  CA  ILE A 144      73.501  36.096  66.415  1.00  7.38           C  
ATOM   1103  C   ILE A 144      74.182  35.973  67.785  1.00  8.42           C  
ATOM   1104  O   ILE A 144      74.472  36.971  68.433  1.00  5.24           O  
ATOM   1105  CB  ILE A 144      74.256  37.135  65.539  1.00  7.75           C  
ATOM   1106  CG1 ILE A 144      73.429  37.487  64.289  1.00  2.00           C  
ATOM   1107  CG2 ILE A 144      75.599  36.581  65.125  1.00  2.00           C  
ATOM   1108  CD1 ILE A 144      73.165  36.315  63.357  1.00  2.00           C  
ATOM   1109  N   SER A 145      74.392  34.736  68.228  1.00  8.35           N  
ATOM   1110  CA  SER A 145      75.023  34.464  69.507  1.00  2.00           C  
ATOM   1111  C   SER A 145      76.544  34.357  69.345  1.00  6.25           C  
ATOM   1112  O   SER A 145      77.178  35.237  68.762  1.00  2.00           O  
ATOM   1113  CB  SER A 145      74.464  33.165  70.087  1.00  2.00           C  
ATOM   1114  OG  SER A 145      75.082  32.852  71.319  1.00  2.00           O  
ATOM   1115  N   SER A 146      77.128  33.280  69.859  1.00  9.26           N  
ATOM   1116  CA  SER A 146      78.569  33.085  69.760  1.00  9.66           C  
ATOM   1117  C   SER A 146      78.999  31.800  70.453  1.00  6.96           C  
ATOM   1118  O   SER A 146      78.323  31.313  71.350  1.00  9.31           O  
ATOM   1119  CB  SER A 146      79.292  34.269  70.403  1.00 10.30           C  
ATOM   1120  OG  SER A 146      80.686  34.039  70.470  1.00 11.25           O  
ATOM   1121  N   VAL A 147      80.123  31.241  70.032  1.00  7.72           N  
ATOM   1122  CA  VAL A 147      80.609  30.027  70.670  1.00  8.24           C  
ATOM   1123  C   VAL A 147      80.991  30.348  72.104  1.00 12.56           C  
ATOM   1124  O   VAL A 147      80.825  29.513  72.987  1.00 13.87           O  
ATOM   1125  CB  VAL A 147      81.841  29.468  69.961  1.00 12.36           C  
ATOM   1126  CG1 VAL A 147      81.462  28.998  68.557  1.00  9.05           C  
ATOM   1127  CG2 VAL A 147      82.941  30.529  69.919  1.00 18.33           C  
ATOM   1128  N   SER A 148      81.498  31.565  72.326  1.00 14.68           N  
ATOM   1129  CA  SER A 148      81.908  32.025  73.661  1.00  7.44           C  
ATOM   1130  C   SER A 148      80.721  32.138  74.612  1.00  9.19           C  
ATOM   1131  O   SER A 148      80.875  32.466  75.793  1.00 13.18           O  
ATOM   1132  CB  SER A 148      82.615  33.376  73.578  1.00  5.00           C  
ATOM   1133  OG  SER A 148      82.146  34.140  72.486  1.00 23.13           O  
ATOM   1134  N   GLY A 149      79.532  31.874  74.090  1.00  9.98           N  
ATOM   1135  CA  GLY A 149      78.355  31.921  74.928  1.00 10.11           C  
ATOM   1136  C   GLY A 149      78.121  30.560  75.565  1.00  7.67           C  
ATOM   1137  O   GLY A 149      77.204  30.404  76.371  1.00 14.07           O  
ATOM   1138  N   ALA A 150      78.939  29.572  75.203  1.00  3.62           N  
ATOM   1139  CA  ALA A 150      78.794  28.225  75.750  1.00  4.68           C  
ATOM   1140  C   ALA A 150      80.098  27.655  76.260  1.00  3.38           C  
ATOM   1141  O   ALA A 150      80.099  26.704  77.041  1.00  9.73           O  
ATOM   1142  CB  ALA A 150      78.227  27.299  74.701  1.00  2.00           C  
ATOM   1143  N   LEU A 151      81.211  28.226  75.819  1.00  5.97           N  
ATOM   1144  CA  LEU A 151      82.524  27.747  76.234  1.00  7.01           C  
ATOM   1145  C   LEU A 151      83.477  28.873  76.623  1.00  7.62           C  
ATOM   1146  O   LEU A 151      83.490  29.937  76.015  1.00 10.92           O  
ATOM   1147  CB  LEU A 151      83.140  26.923  75.110  1.00  6.28           C  
ATOM   1148  CG  LEU A 151      82.304  25.737  74.631  1.00 10.31           C  
ATOM   1149  CD1 LEU A 151      83.002  25.045  73.473  1.00 15.59           C  
ATOM   1150  CD2 LEU A 151      82.095  24.765  75.788  1.00 15.43           C  
ATOM   1151  N   ALA A 152      84.299  28.618  77.628  1.00  5.74           N  
ATOM   1152  CA  ALA A 152      85.256  29.600  78.105  1.00  3.73           C  
ATOM   1153  C   ALA A 152      86.298  29.972  77.062  1.00  2.00           C  
ATOM   1154  O   ALA A 152      86.943  29.105  76.497  1.00  9.54           O  
ATOM   1155  CB  ALA A 152      85.940  29.068  79.357  1.00  2.00           C  
ATOM   1156  N   VAL A 153      86.441  31.271  76.806  1.00  7.51           N  
ATOM   1157  CA  VAL A 153      87.433  31.818  75.871  1.00  2.00           C  
ATOM   1158  C   VAL A 153      88.092  32.993  76.608  1.00  2.97           C  
ATOM   1159  O   VAL A 153      87.420  33.715  77.337  1.00  7.74           O  
ATOM   1160  CB  VAL A 153      86.780  32.371  74.588  1.00  2.00           C  
ATOM   1161  CG1 VAL A 153      87.824  32.493  73.476  1.00  2.86           C  
ATOM   1162  CG2 VAL A 153      85.653  31.469  74.141  1.00 11.78           C  
ATOM   1163  N   PRO A 154      89.407  33.202  76.439  1.00  5.04           N  
ATOM   1164  CA  PRO A 154      90.123  34.303  77.109  1.00  7.08           C  
ATOM   1165  C   PRO A 154      89.614  35.738  76.866  1.00 11.34           C  
ATOM   1166  O   PRO A 154      89.617  36.228  75.729  1.00 12.70           O  
ATOM   1167  CB  PRO A 154      91.564  34.138  76.634  1.00  4.30           C  
ATOM   1168  CG  PRO A 154      91.647  32.689  76.194  1.00 10.49           C  
ATOM   1169  CD  PRO A 154      90.311  32.394  75.603  1.00  9.79           C  
ATOM   1170  N   TYR A 155      89.198  36.401  77.950  1.00  9.61           N  
ATOM   1171  CA  TYR A 155      88.689  37.779  77.923  1.00  9.08           C  
ATOM   1172  C   TYR A 155      87.243  37.884  77.494  1.00 13.12           C  
ATOM   1173  O   TYR A 155      86.773  38.976  77.168  1.00 15.63           O  
ATOM   1174  CB  TYR A 155      89.523  38.661  76.987  1.00  8.82           C  
ATOM   1175  CG  TYR A 155      90.967  38.765  77.375  1.00  2.00           C  
ATOM   1176  CD1 TYR A 155      91.330  39.170  78.657  1.00  4.33           C  
ATOM   1177  CD2 TYR A 155      91.981  38.420  76.475  1.00  6.60           C  
ATOM   1178  CE1 TYR A 155      92.667  39.223  79.039  1.00 13.52           C  
ATOM   1179  CE2 TYR A 155      93.322  38.469  76.845  1.00  5.05           C  
ATOM   1180  CZ  TYR A 155      93.656  38.871  78.131  1.00 15.30           C  
ATOM   1181  OH  TYR A 155      94.975  38.913  78.533  1.00 21.00           O  
ATOM   1182  N   GLU A 156      86.533  36.760  77.487  1.00 12.24           N  
ATOM   1183  CA  GLU A 156      85.142  36.775  77.064  1.00  5.93           C  
ATOM   1184  C   GLU A 156      84.215  36.205  78.118  1.00  6.55           C  
ATOM   1185  O   GLU A 156      83.170  35.638  77.808  1.00  9.86           O  
ATOM   1186  CB  GLU A 156      84.991  36.018  75.735  1.00  9.34           C  
ATOM   1187  CG  GLU A 156      85.114  36.929  74.506  1.00 12.84           C  
ATOM   1188  CD  GLU A 156      85.637  36.223  73.260  1.00 11.81           C  
ATOM   1189  OE1 GLU A 156      84.938  35.334  72.717  1.00 21.14           O  
ATOM   1190  OE2 GLU A 156      86.750  36.568  72.814  1.00  8.62           O  
ATOM   1191  N   ALA A 157      84.605  36.368  79.377  1.00  9.68           N  
ATOM   1192  CA  ALA A 157      83.811  35.892  80.504  1.00  7.10           C  
ATOM   1193  C   ALA A 157      82.488  36.641  80.540  1.00 10.05           C  
ATOM   1194  O   ALA A 157      81.423  36.037  80.634  1.00 13.00           O  
ATOM   1195  CB  ALA A 157      84.571  36.117  81.807  1.00  2.00           C  
ATOM   1196  N   VAL A 158      82.556  37.969  80.456  1.00 12.69           N  
ATOM   1197  CA  VAL A 158      81.346  38.785  80.495  1.00 15.29           C  
ATOM   1198  C   VAL A 158      80.679  38.919  79.129  1.00 11.71           C  
ATOM   1199  O   VAL A 158      79.464  39.067  79.033  1.00 12.27           O  
ATOM   1200  CB  VAL A 158      81.641  40.181  81.064  1.00 11.48           C  
ATOM   1201  CG1 VAL A 158      80.348  40.954  81.220  1.00  3.46           C  
ATOM   1202  CG2 VAL A 158      82.351  40.051  82.412  1.00 13.46           C  
ATOM   1203  N   TYR A 159      81.477  38.883  78.073  1.00 10.04           N  
ATOM   1204  CA  TYR A 159      80.928  38.956  76.732  1.00  8.17           C  
ATOM   1205  C   TYR A 159      80.100  37.687  76.591  1.00  9.18           C  
ATOM   1206  O   TYR A 159      78.947  37.719  76.158  1.00 10.75           O  
ATOM   1207  CB  TYR A 159      82.057  38.949  75.710  1.00  5.37           C  
ATOM   1208  CG  TYR A 159      81.600  38.714  74.299  1.00  2.00           C  
ATOM   1209  CD1 TYR A 159      82.025  37.605  73.584  1.00  2.00           C  
ATOM   1210  CD2 TYR A 159      80.797  39.637  73.657  1.00  7.09           C  
ATOM   1211  CE1 TYR A 159      81.668  37.432  72.257  1.00  5.93           C  
ATOM   1212  CE2 TYR A 159      80.436  39.474  72.335  1.00 10.36           C  
ATOM   1213  CZ  TYR A 159      80.875  38.376  71.636  1.00  9.01           C  
ATOM   1214  OH  TYR A 159      80.539  38.251  70.308  1.00  6.64           O  
ATOM   1215  N   GLY A 160      80.709  36.575  76.994  1.00 11.14           N  
ATOM   1216  CA  GLY A 160      80.063  35.276  76.943  1.00 10.65           C  
ATOM   1217  C   GLY A 160      78.840  35.129  77.840  1.00 12.38           C  
ATOM   1218  O   GLY A 160      78.050  34.202  77.648  1.00 21.32           O  
ATOM   1219  N   ALA A 161      78.668  36.012  78.821  1.00  4.22           N  
ATOM   1220  CA  ALA A 161      77.492  35.923  79.681  1.00  5.84           C  
ATOM   1221  C   ALA A 161      76.300  36.531  78.943  1.00  6.90           C  
ATOM   1222  O   ALA A 161      75.188  36.009  79.005  1.00  8.95           O  
ATOM   1223  CB  ALA A 161      77.728  36.661  80.987  1.00  9.39           C  
ATOM   1224  N   THR A 162      76.533  37.639  78.251  1.00  3.07           N  
ATOM   1225  CA  THR A 162      75.470  38.294  77.492  1.00  7.86           C  
ATOM   1226  C   THR A 162      74.916  37.364  76.408  1.00  3.23           C  
ATOM   1227  O   THR A 162      73.744  37.424  76.065  1.00  7.58           O  
ATOM   1228  CB  THR A 162      75.985  39.555  76.788  1.00  6.01           C  
ATOM   1229  OG1 THR A 162      76.880  39.178  75.734  1.00  6.58           O  
ATOM   1230  CG2 THR A 162      76.716  40.442  77.762  1.00  7.38           C  
ATOM   1231  N   LYS A 163      75.776  36.513  75.865  1.00  7.43           N  
ATOM   1232  CA  LYS A 163      75.388  35.578  74.818  1.00  2.00           C  
ATOM   1233  C   LYS A 163      74.714  34.359  75.434  1.00  6.82           C  
ATOM   1234  O   LYS A 163      73.787  33.778  74.862  1.00  3.19           O  
ATOM   1235  CB  LYS A 163      76.623  35.174  74.016  1.00  7.19           C  
ATOM   1236  CG  LYS A 163      77.391  36.369  73.438  1.00  2.39           C  
ATOM   1237  CD  LYS A 163      76.533  37.154  72.448  1.00  2.00           C  
ATOM   1238  CE  LYS A 163      77.379  37.912  71.436  1.00  2.00           C  
ATOM   1239  NZ  LYS A 163      76.569  38.478  70.309  1.00 11.82           N  
ATOM   1240  N   GLY A 164      75.184  33.962  76.608  1.00  8.77           N  
ATOM   1241  CA  GLY A 164      74.556  32.841  77.276  1.00  8.48           C  
ATOM   1242  C   GLY A 164      73.120  33.209  77.611  1.00  2.00           C  
ATOM   1243  O   GLY A 164      72.219  32.381  77.509  1.00 12.30           O  
ATOM   1244  N   ALA A 165      72.907  34.461  78.012  1.00  8.19           N  
ATOM   1245  CA  ALA A 165      71.577  34.962  78.359  1.00  9.87           C  
ATOM   1246  C   ALA A 165      70.694  34.958  77.120  1.00 11.97           C  
ATOM   1247  O   ALA A 165      69.554  34.490  77.151  1.00 10.07           O  
ATOM   1248  CB  ALA A 165      71.681  36.373  78.923  1.00  8.02           C  
ATOM   1249  N   MET A 166      71.244  35.484  76.028  1.00 13.72           N  
ATOM   1250  CA  MET A 166      70.557  35.555  74.744  1.00  9.87           C  
ATOM   1251  C   MET A 166      70.090  34.182  74.232  1.00 11.40           C  
ATOM   1252  O   MET A 166      68.992  34.059  73.660  1.00  5.85           O  
ATOM   1253  CB  MET A 166      71.492  36.194  73.723  1.00  8.56           C  
ATOM   1254  CG  MET A 166      71.029  36.146  72.294  1.00  8.99           C  
ATOM   1255  SD  MET A 166      72.324  36.783  71.235  1.00 15.19           S  
ATOM   1256  CE  MET A 166      71.718  38.401  70.863  1.00 20.04           C  
ATOM   1257  N   ASP A 167      70.919  33.157  74.438  1.00  2.47           N  
ATOM   1258  CA  ASP A 167      70.596  31.808  73.979  1.00  4.82           C  
ATOM   1259  C   ASP A 167      69.369  31.234  74.668  1.00  6.76           C  
ATOM   1260  O   ASP A 167      68.556  30.556  74.042  1.00  5.48           O  
ATOM   1261  CB  ASP A 167      71.772  30.869  74.221  1.00  4.32           C  
ATOM   1262  CG  ASP A 167      72.928  31.149  73.316  1.00  2.00           C  
ATOM   1263  OD1 ASP A 167      74.005  30.575  73.562  1.00  8.15           O  
ATOM   1264  OD2 ASP A 167      72.770  31.937  72.363  1.00  2.56           O  
ATOM   1265  N   GLN A 168      69.259  31.502  75.967  1.00 11.91           N  
ATOM   1266  CA  GLN A 168      68.143  31.025  76.774  1.00  8.48           C  
ATOM   1267  C   GLN A 168      66.868  31.766  76.398  1.00 10.90           C  
ATOM   1268  O   GLN A 168      65.774  31.200  76.440  1.00 18.19           O  
ATOM   1269  CB  GLN A 168      68.450  31.217  78.262  1.00  5.88           C  
ATOM   1270  CG  GLN A 168      67.382  30.678  79.203  1.00 11.57           C  
ATOM   1271  CD  GLN A 168      66.806  29.358  78.734  1.00  9.86           C  
ATOM   1272  OE1 GLN A 168      67.492  28.559  78.099  1.00 12.14           O  
ATOM   1273  NE2 GLN A 168      65.540  29.122  79.044  1.00  8.76           N  
ATOM   1274  N   LEU A 169      67.008  33.031  76.028  1.00  7.85           N  
ATOM   1275  CA  LEU A 169      65.855  33.829  75.628  1.00  9.64           C  
ATOM   1276  C   LEU A 169      65.339  33.338  74.262  1.00 10.65           C  
ATOM   1277  O   LEU A 169      64.157  33.468  73.931  1.00 11.40           O  
ATOM   1278  CB  LEU A 169      66.261  35.306  75.550  1.00  4.01           C  
ATOM   1279  CG  LEU A 169      65.196  36.329  75.167  1.00  4.47           C  
ATOM   1280  CD1 LEU A 169      64.212  36.516  76.324  1.00  2.00           C  
ATOM   1281  CD2 LEU A 169      65.878  37.647  74.820  1.00  6.30           C  
ATOM   1282  N   THR A 170      66.237  32.760  73.472  1.00  9.81           N  
ATOM   1283  CA  THR A 170      65.878  32.259  72.159  1.00  4.95           C  
ATOM   1284  C   THR A 170      64.933  31.071  72.339  1.00 10.55           C  
ATOM   1285  O   THR A 170      63.879  31.017  71.718  1.00 11.49           O  
ATOM   1286  CB  THR A 170      67.150  31.835  71.391  1.00  5.07           C  
ATOM   1287  OG1 THR A 170      67.981  32.985  71.180  1.00 13.16           O  
ATOM   1288  CG2 THR A 170      66.809  31.243  70.064  1.00  8.76           C  
ATOM   1289  N   ARG A 171      65.306  30.140  73.216  1.00  7.56           N  
ATOM   1290  CA  ARG A 171      64.506  28.945  73.482  1.00  7.65           C  
ATOM   1291  C   ARG A 171      63.113  29.211  74.058  1.00 12.35           C  
ATOM   1292  O   ARG A 171      62.160  28.502  73.737  1.00 13.98           O  
ATOM   1293  CB  ARG A 171      65.257  28.016  74.437  1.00  7.05           C  
ATOM   1294  CG  ARG A 171      66.666  27.658  73.997  1.00  9.75           C  
ATOM   1295  CD  ARG A 171      67.374  26.788  75.043  1.00 13.14           C  
ATOM   1296  NE  ARG A 171      68.817  26.707  74.807  1.00 16.68           N  
ATOM   1297  CZ  ARG A 171      69.753  27.157  75.642  1.00 13.82           C  
ATOM   1298  NH1 ARG A 171      69.422  27.733  76.793  1.00 17.71           N  
ATOM   1299  NH2 ARG A 171      71.034  27.041  75.317  1.00 20.02           N  
ATOM   1300  N   CYS A 172      62.987  30.208  74.924  1.00 13.07           N  
ATOM   1301  CA  CYS A 172      61.686  30.507  75.508  1.00 14.18           C  
ATOM   1302  C   CYS A 172      60.781  31.244  74.523  1.00  9.31           C  
ATOM   1303  O   CYS A 172      59.596  30.942  74.429  1.00 15.13           O  
ATOM   1304  CB  CYS A 172      61.850  31.321  76.790  1.00  6.78           C  
ATOM   1305  SG  CYS A 172      62.982  30.567  77.967  1.00 25.00           S  
ATOM   1306  N   LEU A 173      61.332  32.208  73.793  1.00  9.54           N  
ATOM   1307  CA  LEU A 173      60.540  32.953  72.812  1.00 10.23           C  
ATOM   1308  C   LEU A 173      59.940  31.973  71.790  1.00  8.09           C  
ATOM   1309  O   LEU A 173      58.770  32.071  71.418  1.00 10.91           O  
ATOM   1310  CB  LEU A 173      61.413  33.997  72.089  1.00  4.19           C  
ATOM   1311  CG  LEU A 173      61.741  35.321  72.806  1.00  5.66           C  
ATOM   1312  CD1 LEU A 173      62.474  36.271  71.848  1.00  2.00           C  
ATOM   1313  CD2 LEU A 173      60.465  35.968  73.295  1.00  2.00           C  
ATOM   1314  N   ALA A 174      60.748  31.024  71.343  1.00  5.58           N  
ATOM   1315  CA  ALA A 174      60.295  30.033  70.384  1.00  8.58           C  
ATOM   1316  C   ALA A 174      59.051  29.318  70.917  1.00 12.63           C  
ATOM   1317  O   ALA A 174      58.288  28.722  70.154  1.00 12.60           O  
ATOM   1318  CB  ALA A 174      61.405  29.029  70.126  1.00  6.34           C  
ATOM   1319  N   PHE A 175      58.849  29.376  72.228  1.00 14.18           N  
ATOM   1320  CA  PHE A 175      57.697  28.723  72.835  1.00 15.66           C  
ATOM   1321  C   PHE A 175      56.578  29.711  73.120  1.00 16.30           C  
ATOM   1322  O   PHE A 175      55.401  29.397  72.955  1.00 17.77           O  
ATOM   1323  CB  PHE A 175      58.115  27.989  74.119  1.00 16.14           C  
ATOM   1324  CG  PHE A 175      58.606  26.591  73.868  1.00 12.57           C  
ATOM   1325  CD1 PHE A 175      57.713  25.523  73.813  1.00 10.77           C  
ATOM   1326  CD2 PHE A 175      59.946  26.354  73.583  1.00 10.65           C  
ATOM   1327  CE1 PHE A 175      58.150  24.236  73.463  1.00 15.43           C  
ATOM   1328  CE2 PHE A 175      60.390  25.075  73.233  1.00  8.22           C  
ATOM   1329  CZ  PHE A 175      59.489  24.016  73.170  1.00  3.30           C  
ATOM   1330  N   GLU A 176      56.954  30.909  73.543  1.00 12.02           N  
ATOM   1331  CA  GLU A 176      55.984  31.944  73.837  1.00 13.09           C  
ATOM   1332  C   GLU A 176      55.365  32.536  72.571  1.00 12.36           C  
ATOM   1333  O   GLU A 176      54.199  32.906  72.568  1.00 22.44           O  
ATOM   1334  CB  GLU A 176      56.646  33.072  74.629  1.00 13.10           C  
ATOM   1335  CG  GLU A 176      57.148  32.663  75.997  1.00 11.01           C  
ATOM   1336  CD  GLU A 176      57.151  33.806  77.006  1.00 11.29           C  
ATOM   1337  OE1 GLU A 176      57.192  34.981  76.591  1.00 23.67           O  
ATOM   1338  OE2 GLU A 176      57.109  33.524  78.223  1.00 15.35           O  
ATOM   1339  N   TRP A 177      56.138  32.616  71.495  1.00 11.21           N  
ATOM   1340  CA  TRP A 177      55.653  33.231  70.273  1.00  9.94           C  
ATOM   1341  C   TRP A 177      55.201  32.273  69.189  1.00 15.40           C  
ATOM   1342  O   TRP A 177      54.712  32.704  68.150  1.00 15.58           O  
ATOM   1343  CB  TRP A 177      56.727  34.185  69.728  1.00 10.53           C  
ATOM   1344  CG  TRP A 177      56.960  35.410  70.624  1.00 10.52           C  
ATOM   1345  CD1 TRP A 177      56.288  35.724  71.768  1.00  6.29           C  
ATOM   1346  CD2 TRP A 177      57.938  36.446  70.443  1.00 13.60           C  
ATOM   1347  NE1 TRP A 177      56.781  36.880  72.314  1.00 11.81           N  
ATOM   1348  CE2 TRP A 177      57.794  37.349  71.524  1.00 11.42           C  
ATOM   1349  CE3 TRP A 177      58.922  36.702  69.476  1.00 10.87           C  
ATOM   1350  CZ2 TRP A 177      58.596  38.490  71.666  1.00  8.69           C  
ATOM   1351  CZ3 TRP A 177      59.718  37.834  69.613  1.00 12.57           C  
ATOM   1352  CH2 TRP A 177      59.551  38.714  70.704  1.00 12.12           C  
ATOM   1353  N   ALA A 178      55.350  30.976  69.436  1.00 18.42           N  
ATOM   1354  CA  ALA A 178      54.952  29.955  68.469  1.00 16.03           C  
ATOM   1355  C   ALA A 178      53.529  30.153  67.942  1.00 17.38           C  
ATOM   1356  O   ALA A 178      53.294  30.045  66.743  1.00 16.82           O  
ATOM   1357  CB  ALA A 178      55.085  28.575  69.091  1.00  9.82           C  
ATOM   1358  N   LYS A 179      52.587  30.432  68.837  1.00 20.15           N  
ATOM   1359  CA  LYS A 179      51.194  30.641  68.453  1.00 28.45           C  
ATOM   1360  C   LYS A 179      50.995  31.862  67.560  1.00 26.78           C  
ATOM   1361  O   LYS A 179      50.014  31.933  66.818  1.00 25.80           O  
ATOM   1362  CB  LYS A 179      50.317  30.788  69.697  1.00 46.11           C  
ATOM   1363  CG  LYS A 179      49.596  29.505  70.114  1.00 67.95           C  
ATOM   1364  CD  LYS A 179      48.371  29.790  70.992  1.00 82.29           C  
ATOM   1365  CE  LYS A 179      48.760  30.391  72.348  1.00 91.90           C  
ATOM   1366  NZ  LYS A 179      47.592  30.593  73.264  1.00 94.88           N  
ATOM   1367  N   ASP A 180      51.918  32.823  67.643  1.00 28.16           N  
ATOM   1368  CA  ASP A 180      51.863  34.050  66.838  1.00 19.46           C  
ATOM   1369  C   ASP A 180      52.484  33.788  65.470  1.00 19.64           C  
ATOM   1370  O   ASP A 180      52.634  34.695  64.647  1.00 18.32           O  
ATOM   1371  CB  ASP A 180      52.613  35.180  67.543  1.00 15.75           C  
ATOM   1372  CG  ASP A 180      52.149  35.382  68.972  1.00 17.59           C  
ATOM   1373  OD1 ASP A 180      50.926  35.401  69.198  1.00 19.53           O  
ATOM   1374  OD2 ASP A 180      53.003  35.519  69.874  1.00 19.00           O  
ATOM   1375  N   ASN A 181      52.832  32.525  65.244  1.00 23.98           N  
ATOM   1376  CA  ASN A 181      53.439  32.070  64.000  1.00 22.98           C  
ATOM   1377  C   ASN A 181      54.824  32.660  63.756  1.00 20.45           C  
ATOM   1378  O   ASN A 181      55.181  32.976  62.620  1.00 19.91           O  
ATOM   1379  CB  ASN A 181      52.532  32.385  62.814  1.00 28.62           C  
ATOM   1380  CG  ASN A 181      52.811  31.485  61.622  1.00 42.67           C  
ATOM   1381  OD1 ASN A 181      53.487  30.455  61.746  1.00 44.63           O  
ATOM   1382  ND2 ASN A 181      52.299  31.868  60.459  1.00 47.17           N  
ATOM   1383  N   ILE A 182      55.596  32.799  64.832  1.00 16.04           N  
ATOM   1384  CA  ILE A 182      56.956  33.343  64.779  1.00 11.97           C  
ATOM   1385  C   ILE A 182      57.924  32.208  65.139  1.00 11.65           C  
ATOM   1386  O   ILE A 182      57.654  31.423  66.042  1.00 10.35           O  
ATOM   1387  CB  ILE A 182      57.111  34.534  65.785  1.00  6.15           C  
ATOM   1388  CG1 ILE A 182      56.106  35.625  65.418  1.00  3.08           C  
ATOM   1389  CG2 ILE A 182      58.528  35.123  65.750  1.00  2.00           C  
ATOM   1390  CD1 ILE A 182      56.005  36.723  66.425  1.00  7.58           C  
ATOM   1391  N   ARG A 183      59.026  32.096  64.405  1.00 12.08           N  
ATOM   1392  CA  ARG A 183      60.025  31.066  64.682  1.00 11.32           C  
ATOM   1393  C   ARG A 183      61.227  31.810  65.249  1.00 14.76           C  
ATOM   1394  O   ARG A 183      61.609  32.853  64.723  1.00 14.38           O  
ATOM   1395  CB  ARG A 183      60.402  30.317  63.400  1.00  6.20           C  
ATOM   1396  CG  ARG A 183      59.433  29.185  63.040  1.00  5.48           C  
ATOM   1397  CD  ARG A 183      60.040  28.247  62.005  1.00 13.72           C  
ATOM   1398  NE  ARG A 183      60.314  28.919  60.732  1.00  8.32           N  
ATOM   1399  CZ  ARG A 183      61.531  29.119  60.229  1.00 11.77           C  
ATOM   1400  NH1 ARG A 183      62.613  28.697  60.891  1.00  2.00           N  
ATOM   1401  NH2 ARG A 183      61.668  29.742  59.061  1.00  2.74           N  
ATOM   1402  N   VAL A 184      61.816  31.288  66.323  1.00 14.02           N  
ATOM   1403  CA  VAL A 184      62.947  31.951  66.959  1.00 11.96           C  
ATOM   1404  C   VAL A 184      64.189  31.070  67.056  1.00 12.70           C  
ATOM   1405  O   VAL A 184      64.169  30.029  67.697  1.00 21.02           O  
ATOM   1406  CB  VAL A 184      62.547  32.440  68.377  1.00 12.68           C  
ATOM   1407  CG1 VAL A 184      63.592  33.393  68.921  1.00  8.61           C  
ATOM   1408  CG2 VAL A 184      61.172  33.129  68.326  1.00 12.43           C  
ATOM   1409  N   ASN A 185      65.277  31.502  66.431  1.00  9.34           N  
ATOM   1410  CA  ASN A 185      66.514  30.734  66.457  1.00  6.63           C  
ATOM   1411  C   ASN A 185      67.745  31.589  66.680  1.00  4.65           C  
ATOM   1412  O   ASN A 185      67.693  32.819  66.645  1.00  2.00           O  
ATOM   1413  CB  ASN A 185      66.686  29.960  65.150  1.00  2.88           C  
ATOM   1414  CG  ASN A 185      65.514  29.044  64.862  1.00  2.89           C  
ATOM   1415  OD1 ASN A 185      65.422  27.938  65.405  1.00  3.64           O  
ATOM   1416  ND2 ASN A 185      64.612  29.497  64.010  1.00  2.00           N  
ATOM   1417  N   GLY A 186      68.861  30.909  66.899  1.00  7.61           N  
ATOM   1418  CA  GLY A 186      70.114  31.590  67.113  1.00  2.00           C  
ATOM   1419  C   GLY A 186      71.169  30.952  66.244  1.00  3.46           C  
ATOM   1420  O   GLY A 186      71.048  29.794  65.868  1.00  8.00           O  
ATOM   1421  N   VAL A 187      72.196  31.718  65.902  1.00  2.00           N  
ATOM   1422  CA  VAL A 187      73.291  31.217  65.092  1.00  2.00           C  
ATOM   1423  C   VAL A 187      74.546  31.682  65.813  1.00  6.65           C  
ATOM   1424  O   VAL A 187      74.814  32.881  65.917  1.00  6.96           O  
ATOM   1425  CB  VAL A 187      73.263  31.788  63.644  1.00  5.56           C  
ATOM   1426  CG1 VAL A 187      74.409  31.220  62.844  1.00  2.00           C  
ATOM   1427  CG2 VAL A 187      71.949  31.426  62.956  1.00  4.93           C  
ATOM   1428  N   GLY A 188      75.299  30.726  66.338  1.00  5.18           N  
ATOM   1429  CA  GLY A 188      76.500  31.075  67.055  1.00  5.89           C  
ATOM   1430  C   GLY A 188      77.728  31.051  66.181  1.00  8.87           C  
ATOM   1431  O   GLY A 188      78.210  29.982  65.821  1.00 20.07           O  
ATOM   1432  N   PRO A 189      78.251  32.217  65.796  1.00  5.53           N  
ATOM   1433  CA  PRO A 189      79.449  32.209  64.953  1.00  8.54           C  
ATOM   1434  C   PRO A 189      80.675  31.666  65.686  1.00  5.71           C  
ATOM   1435  O   PRO A 189      80.711  31.641  66.917  1.00 16.55           O  
ATOM   1436  CB  PRO A 189      79.628  33.680  64.572  1.00  8.36           C  
ATOM   1437  CG  PRO A 189      78.295  34.331  64.881  1.00 10.38           C  
ATOM   1438  CD  PRO A 189      77.780  33.581  66.063  1.00  9.35           C  
ATOM   1439  N   GLY A 190      81.668  31.217  64.930  1.00  4.49           N  
ATOM   1440  CA  GLY A 190      82.898  30.735  65.529  1.00  5.93           C  
ATOM   1441  C   GLY A 190      83.854  31.913  65.467  1.00 11.44           C  
ATOM   1442  O   GLY A 190      83.725  32.856  66.250  1.00 18.84           O  
ATOM   1443  N   VAL A 191      84.809  31.860  64.541  1.00 10.36           N  
ATOM   1444  CA  VAL A 191      85.761  32.943  64.332  1.00  4.74           C  
ATOM   1445  C   VAL A 191      85.510  33.378  62.885  1.00  7.95           C  
ATOM   1446  O   VAL A 191      85.828  32.644  61.952  1.00  8.54           O  
ATOM   1447  CB  VAL A 191      87.227  32.459  64.482  1.00  9.09           C  
ATOM   1448  CG1 VAL A 191      88.189  33.631  64.302  1.00 11.02           C  
ATOM   1449  CG2 VAL A 191      87.436  31.845  65.844  1.00 14.73           C  
ATOM   1450  N   ILE A 192      84.911  34.558  62.711  1.00  9.12           N  
ATOM   1451  CA  ILE A 192      84.578  35.086  61.385  1.00  5.28           C  
ATOM   1452  C   ILE A 192      85.436  36.288  61.043  1.00  8.42           C  
ATOM   1453  O   ILE A 192      85.617  37.184  61.865  1.00 15.70           O  
ATOM   1454  CB  ILE A 192      83.101  35.516  61.303  1.00  2.00           C  
ATOM   1455  CG1 ILE A 192      82.180  34.338  61.637  1.00  2.00           C  
ATOM   1456  CG2 ILE A 192      82.802  36.036  59.916  1.00 10.27           C  
ATOM   1457  CD1 ILE A 192      81.957  33.371  60.478  1.00  2.00           C  
ATOM   1458  N   ALA A 193      85.963  36.313  59.827  1.00  6.07           N  
ATOM   1459  CA  ALA A 193      86.825  37.408  59.415  1.00  3.25           C  
ATOM   1460  C   ALA A 193      86.051  38.714  59.231  1.00  6.43           C  
ATOM   1461  O   ALA A 193      85.570  39.024  58.138  1.00  6.51           O  
ATOM   1462  CB  ALA A 193      87.548  37.031  58.137  1.00  2.00           C  
ATOM   1463  N   THR A 194      85.937  39.478  60.316  1.00  8.85           N  
ATOM   1464  CA  THR A 194      85.222  40.750  60.305  1.00  7.94           C  
ATOM   1465  C   THR A 194      86.116  41.858  60.854  1.00 10.02           C  
ATOM   1466  O   THR A 194      87.233  41.596  61.299  1.00 11.62           O  
ATOM   1467  CB  THR A 194      83.923  40.679  61.151  1.00  4.97           C  
ATOM   1468  OG1 THR A 194      84.215  40.996  62.513  1.00  3.70           O  
ATOM   1469  CG2 THR A 194      83.339  39.301  61.102  1.00  2.52           C  
ATOM   1470  N   SER A 195      85.614  43.093  60.811  1.00 12.14           N  
ATOM   1471  CA  SER A 195      86.347  44.263  61.294  1.00 12.13           C  
ATOM   1472  C   SER A 195      86.598  44.160  62.793  1.00 13.81           C  
ATOM   1473  O   SER A 195      87.509  44.787  63.337  1.00 13.69           O  
ATOM   1474  CB  SER A 195      85.557  45.537  60.993  1.00 10.78           C  
ATOM   1475  OG  SER A 195      84.721  45.885  62.082  1.00  8.38           O  
ATOM   1476  N   LEU A 196      85.767  43.370  63.458  1.00 12.48           N  
ATOM   1477  CA  LEU A 196      85.898  43.151  64.880  1.00 11.01           C  
ATOM   1478  C   LEU A 196      87.156  42.307  65.099  1.00 12.32           C  
ATOM   1479  O   LEU A 196      87.867  42.470  66.090  1.00 17.35           O  
ATOM   1480  CB  LEU A 196      84.659  42.415  65.399  1.00  7.58           C  
ATOM   1481  CG  LEU A 196      84.593  42.107  66.894  1.00  6.64           C  
ATOM   1482  CD1 LEU A 196      83.168  42.302  67.378  1.00 24.72           C  
ATOM   1483  CD2 LEU A 196      85.037  40.686  67.149  1.00 13.87           C  
ATOM   1484  N   VAL A 197      87.436  41.416  64.155  1.00 11.81           N  
ATOM   1485  CA  VAL A 197      88.602  40.553  64.253  1.00 14.39           C  
ATOM   1486  C   VAL A 197      89.914  41.209  63.818  1.00 15.34           C  
ATOM   1487  O   VAL A 197      90.969  40.893  64.367  1.00 13.54           O  
ATOM   1488  CB  VAL A 197      88.412  39.268  63.434  1.00 14.09           C  
ATOM   1489  CG1 VAL A 197      89.593  38.349  63.660  1.00  6.44           C  
ATOM   1490  CG2 VAL A 197      87.115  38.586  63.828  1.00 10.01           C  
ATOM   1491  N   GLU A 198      89.858  42.102  62.832  1.00 19.17           N  
ATOM   1492  CA  GLU A 198      91.063  42.774  62.349  1.00 26.69           C  
ATOM   1493  C   GLU A 198      91.622  43.602  63.489  1.00 29.62           C  
ATOM   1494  O   GLU A 198      92.835  43.643  63.711  1.00 29.69           O  
ATOM   1495  CB  GLU A 198      90.742  43.705  61.173  1.00 35.59           C  
ATOM   1496  CG  GLU A 198      90.211  43.015  59.926  1.00 52.70           C  
ATOM   1497  CD  GLU A 198      91.169  41.971  59.379  1.00 61.96           C  
ATOM   1498  OE1 GLU A 198      90.709  40.851  59.049  1.00 65.93           O  
ATOM   1499  OE2 GLU A 198      92.378  42.271  59.278  1.00 67.08           O  
ATOM   1500  N   MET A 199      90.706  44.265  64.194  1.00 29.69           N  
ATOM   1501  CA  MET A 199      91.019  45.121  65.333  1.00 26.75           C  
ATOM   1502  C   MET A 199      91.706  44.290  66.403  1.00 25.34           C  
ATOM   1503  O   MET A 199      92.754  44.661  66.939  1.00 23.15           O  
ATOM   1504  CB  MET A 199      89.725  45.706  65.907  1.00 25.38           C  
ATOM   1505  CG  MET A 199      89.710  47.222  66.043  1.00 36.89           C  
ATOM   1506  SD  MET A 199      88.248  47.809  66.949  1.00 47.58           S  
ATOM   1507  CE  MET A 199      88.999  48.645  68.360  1.00 49.84           C  
ATOM   1508  N   THR A 200      91.100  43.153  66.706  1.00 22.28           N  
ATOM   1509  CA  THR A 200      91.626  42.261  67.719  1.00 18.40           C  
ATOM   1510  C   THR A 200      93.044  41.765  67.447  1.00 18.21           C  
ATOM   1511  O   THR A 200      93.936  41.951  68.265  1.00 19.76           O  
ATOM   1512  CB  THR A 200      90.699  41.054  67.882  1.00 18.39           C  
ATOM   1513  OG1 THR A 200      89.369  41.524  68.141  1.00 17.36           O  
ATOM   1514  CG2 THR A 200      91.180  40.153  69.026  1.00  4.80           C  
ATOM   1515  N   ILE A 201      93.252  41.141  66.296  1.00 16.88           N  
ATOM   1516  CA  ILE A 201      94.563  40.602  65.962  1.00 20.10           C  
ATOM   1517  C   ILE A 201      95.669  41.632  65.798  1.00 19.54           C  
ATOM   1518  O   ILE A 201      96.735  41.329  65.273  1.00 23.14           O  
ATOM   1519  CB  ILE A 201      94.493  39.761  64.695  1.00 17.76           C  
ATOM   1520  CG1 ILE A 201      94.123  40.648  63.514  1.00 13.39           C  
ATOM   1521  CG2 ILE A 201      93.481  38.659  64.876  1.00 20.70           C  
ATOM   1522  CD1 ILE A 201      94.679  40.155  62.220  1.00 14.26           C  
ATOM   1523  N   GLN A 202      95.418  42.856  66.227  1.00 22.34           N  
ATOM   1524  CA  GLN A 202      96.444  43.872  66.142  1.00 24.12           C  
ATOM   1525  C   GLN A 202      97.343  43.704  67.371  1.00 25.36           C  
ATOM   1526  O   GLN A 202      98.551  43.939  67.293  1.00 30.27           O  
ATOM   1527  CB  GLN A 202      95.814  45.259  66.103  1.00 22.94           C  
ATOM   1528  CG  GLN A 202      94.853  45.436  64.949  1.00 34.95           C  
ATOM   1529  CD  GLN A 202      94.406  46.880  64.757  1.00 41.01           C  
ATOM   1530  OE1 GLN A 202      93.999  47.561  65.709  1.00 36.04           O  
ATOM   1531  NE2 GLN A 202      94.474  47.355  63.513  1.00 44.38           N  
ATOM   1532  N   ASP A 203      96.759  43.290  68.499  1.00 19.37           N  
ATOM   1533  CA  ASP A 203      97.534  43.070  69.719  1.00 18.52           C  
ATOM   1534  C   ASP A 203      98.085  41.642  69.725  1.00 21.55           C  
ATOM   1535  O   ASP A 203      97.332  40.665  69.732  1.00 21.09           O  
ATOM   1536  CB  ASP A 203      96.695  43.304  70.982  1.00 17.74           C  
ATOM   1537  CG  ASP A 203      97.454  42.959  72.257  1.00 17.73           C  
ATOM   1538  OD1 ASP A 203      97.883  43.885  72.979  1.00 25.81           O  
ATOM   1539  OD2 ASP A 203      97.632  41.753  72.539  1.00 20.03           O  
ATOM   1540  N   PRO A 204      99.421  41.514  69.755  1.00 20.58           N  
ATOM   1541  CA  PRO A 204     100.189  40.265  69.756  1.00 16.36           C  
ATOM   1542  C   PRO A 204      99.647  39.115  70.585  1.00 11.30           C  
ATOM   1543  O   PRO A 204      99.662  37.978  70.131  1.00 15.48           O  
ATOM   1544  CB  PRO A 204     101.585  40.694  70.221  1.00 20.17           C  
ATOM   1545  CG  PRO A 204     101.442  42.136  70.660  1.00 21.91           C  
ATOM   1546  CD  PRO A 204     100.312  42.678  69.855  1.00 21.08           C  
ATOM   1547  N   GLU A 205      99.175  39.391  71.793  1.00  8.51           N  
ATOM   1548  CA  GLU A 205      98.658  38.314  72.636  1.00 16.17           C  
ATOM   1549  C   GLU A 205      97.302  37.852  72.129  1.00 12.22           C  
ATOM   1550  O   GLU A 205      97.004  36.661  72.135  1.00  4.82           O  
ATOM   1551  CB  GLU A 205      98.539  38.764  74.098  1.00 16.76           C  
ATOM   1552  CG  GLU A 205      97.838  37.756  74.992  1.00 22.25           C  
ATOM   1553  CD  GLU A 205      97.081  38.405  76.151  1.00 25.84           C  
ATOM   1554  OE1 GLU A 205      96.766  37.689  77.129  1.00 23.02           O  
ATOM   1555  OE2 GLU A 205      96.802  39.623  76.087  1.00 24.57           O  
ATOM   1556  N   GLN A 206      96.488  38.801  71.684  1.00 11.03           N  
ATOM   1557  CA  GLN A 206      95.171  38.468  71.168  1.00 15.20           C  
ATOM   1558  C   GLN A 206      95.315  37.764  69.820  1.00 15.63           C  
ATOM   1559  O   GLN A 206      94.509  36.895  69.471  1.00  9.57           O  
ATOM   1560  CB  GLN A 206      94.325  39.734  71.029  1.00 22.17           C  
ATOM   1561  CG  GLN A 206      93.725  40.220  72.350  1.00 27.39           C  
ATOM   1562  CD  GLN A 206      92.688  39.255  72.912  1.00 31.04           C  
ATOM   1563  OE1 GLN A 206      92.979  38.081  73.172  1.00 31.74           O  
ATOM   1564  NE2 GLN A 206      91.469  39.748  73.101  1.00 29.87           N  
ATOM   1565  N   LYS A 207      96.352  38.135  69.074  1.00 14.69           N  
ATOM   1566  CA  LYS A 207      96.616  37.532  67.778  1.00 15.24           C  
ATOM   1567  C   LYS A 207      96.975  36.076  68.014  1.00 19.17           C  
ATOM   1568  O   LYS A 207      96.660  35.204  67.206  1.00 16.31           O  
ATOM   1569  CB  LYS A 207      97.776  38.242  67.085  1.00 17.41           C  
ATOM   1570  CG  LYS A 207      97.705  38.182  65.570  1.00 20.96           C  
ATOM   1571  CD  LYS A 207      99.076  37.984  64.958  1.00 29.35           C  
ATOM   1572  CE  LYS A 207      98.985  37.231  63.631  1.00 34.97           C  
ATOM   1573  NZ  LYS A 207      99.134  38.122  62.437  1.00 33.91           N  
ATOM   1574  N   GLU A 208      97.632  35.831  69.141  1.00 23.02           N  
ATOM   1575  CA  GLU A 208      98.049  34.490  69.536  1.00 28.62           C  
ATOM   1576  C   GLU A 208      96.828  33.673  69.960  1.00 25.77           C  
ATOM   1577  O   GLU A 208      96.704  32.490  69.622  1.00 26.18           O  
ATOM   1578  CB  GLU A 208      99.056  34.584  70.686  1.00 35.65           C  
ATOM   1579  CG  GLU A 208      99.346  33.274  71.404  1.00 59.04           C  
ATOM   1580  CD  GLU A 208      99.906  33.490  72.801  1.00 70.25           C  
ATOM   1581  OE1 GLU A 208      99.588  32.685  73.706  1.00 77.96           O  
ATOM   1582  OE2 GLU A 208     100.665  34.468  72.995  1.00 78.85           O  
ATOM   1583  N   ASN A 209      95.916  34.307  70.688  1.00 22.80           N  
ATOM   1584  CA  ASN A 209      94.709  33.616  71.129  1.00 20.55           C  
ATOM   1585  C   ASN A 209      93.833  33.206  69.940  1.00 12.30           C  
ATOM   1586  O   ASN A 209      93.400  32.067  69.856  1.00 14.87           O  
ATOM   1587  CB  ASN A 209      93.922  34.494  72.101  1.00 18.01           C  
ATOM   1588  CG  ASN A 209      94.638  34.670  73.414  1.00 26.75           C  
ATOM   1589  OD1 ASN A 209      95.676  34.045  73.641  1.00 22.15           O  
ATOM   1590  ND2 ASN A 209      94.101  35.527  74.289  1.00 28.32           N  
ATOM   1591  N   LEU A 210      93.585  34.125  69.014  1.00 15.20           N  
ATOM   1592  CA  LEU A 210      92.770  33.803  67.852  1.00 14.37           C  
ATOM   1593  C   LEU A 210      93.359  32.616  67.105  1.00 20.72           C  
ATOM   1594  O   LEU A 210      92.636  31.704  66.703  1.00 22.65           O  
ATOM   1595  CB  LEU A 210      92.679  34.995  66.908  1.00 14.86           C  
ATOM   1596  CG  LEU A 210      91.378  34.983  66.103  1.00 21.74           C  
ATOM   1597  CD1 LEU A 210      90.224  35.441  66.990  1.00 10.73           C  
ATOM   1598  CD2 LEU A 210      91.528  35.871  64.875  1.00 25.92           C  
ATOM   1599  N   ASN A 211      94.676  32.629  66.922  1.00 20.18           N  
ATOM   1600  CA  ASN A 211      95.339  31.543  66.225  1.00 17.59           C  
ATOM   1601  C   ASN A 211      95.089  30.224  66.950  1.00 20.24           C  
ATOM   1602  O   ASN A 211      95.131  29.164  66.340  1.00 23.79           O  
ATOM   1603  CB  ASN A 211      96.841  31.800  66.133  1.00 18.04           C  
ATOM   1604  CG  ASN A 211      97.197  32.839  65.084  1.00 24.37           C  
ATOM   1605  OD1 ASN A 211      96.370  33.216  64.251  1.00 26.73           O  
ATOM   1606  ND2 ASN A 211      98.441  33.311  65.123  1.00 29.67           N  
ATOM   1607  N   LYS A 212      94.839  30.280  68.253  1.00 15.96           N  
ATOM   1608  CA  LYS A 212      94.571  29.058  69.000  1.00 16.49           C  
ATOM   1609  C   LYS A 212      93.213  28.540  68.562  1.00 15.55           C  
ATOM   1610  O   LYS A 212      93.033  27.354  68.292  1.00 14.65           O  
ATOM   1611  CB  LYS A 212      94.534  29.336  70.507  1.00 14.83           C  
ATOM   1612  CG  LYS A 212      95.906  29.356  71.173  1.00 18.84           C  
ATOM   1613  CD  LYS A 212      95.873  28.729  72.563  1.00 17.62           C  
ATOM   1614  CE  LYS A 212      96.962  29.307  73.458  1.00 26.40           C  
ATOM   1615  NZ  LYS A 212      96.443  30.431  74.304  1.00 41.26           N  
ATOM   1616  N   LEU A 213      92.255  29.454  68.496  1.00 13.49           N  
ATOM   1617  CA  LEU A 213      90.901  29.105  68.100  1.00 16.91           C  
ATOM   1618  C   LEU A 213      90.881  28.476  66.719  1.00 18.30           C  
ATOM   1619  O   LEU A 213      90.465  27.329  66.564  1.00 19.09           O  
ATOM   1620  CB  LEU A 213      90.011  30.346  68.105  1.00 19.18           C  
ATOM   1621  CG  LEU A 213      89.509  30.852  69.464  1.00 17.97           C  
ATOM   1622  CD1 LEU A 213      88.218  31.617  69.260  1.00 15.89           C  
ATOM   1623  CD2 LEU A 213      89.277  29.694  70.410  1.00 18.48           C  
ATOM   1624  N   ILE A 214      91.331  29.242  65.728  1.00 18.92           N  
ATOM   1625  CA  ILE A 214      91.380  28.796  64.336  1.00 15.35           C  
ATOM   1626  C   ILE A 214      92.080  27.454  64.219  1.00 17.42           C  
ATOM   1627  O   ILE A 214      91.709  26.608  63.401  1.00 20.13           O  
ATOM   1628  CB  ILE A 214      92.133  29.813  63.458  1.00 15.56           C  
ATOM   1629  CG1 ILE A 214      91.277  31.067  63.279  1.00 16.90           C  
ATOM   1630  CG2 ILE A 214      92.483  29.194  62.104  1.00  7.81           C  
ATOM   1631  CD1 ILE A 214      92.049  32.245  62.735  1.00 21.61           C  
ATOM   1632  N   ASP A 215      93.102  27.268  65.041  1.00 11.70           N  
ATOM   1633  CA  ASP A 215      93.855  26.032  65.035  1.00 13.24           C  
ATOM   1634  C   ASP A 215      93.041  24.897  65.621  1.00 11.03           C  
ATOM   1635  O   ASP A 215      93.394  23.735  65.475  1.00 17.04           O  
ATOM   1636  CB  ASP A 215      95.125  26.203  65.850  1.00 24.77           C  
ATOM   1637  CG  ASP A 215      96.312  25.590  65.184  1.00 32.52           C  
ATOM   1638  OD1 ASP A 215      96.812  26.183  64.205  1.00 37.72           O  
ATOM   1639  OD2 ASP A 215      96.739  24.511  65.640  1.00 42.71           O  
ATOM   1640  N   ARG A 216      91.945  25.241  66.276  1.00 16.38           N  
ATOM   1641  CA  ARG A 216      91.092  24.248  66.910  1.00 13.12           C  
ATOM   1642  C   ARG A 216      89.816  23.857  66.175  1.00 10.78           C  
ATOM   1643  O   ARG A 216      88.965  23.203  66.751  1.00 10.76           O  
ATOM   1644  CB  ARG A 216      90.723  24.712  68.309  1.00 13.22           C  
ATOM   1645  CG  ARG A 216      91.715  24.298  69.349  1.00  5.49           C  
ATOM   1646  CD  ARG A 216      91.945  25.415  70.324  1.00  5.05           C  
ATOM   1647  NE  ARG A 216      93.108  25.139  71.155  1.00  4.71           N  
ATOM   1648  CZ  ARG A 216      93.144  25.361  72.462  1.00  9.82           C  
ATOM   1649  NH1 ARG A 216      92.084  25.862  73.080  1.00 10.92           N  
ATOM   1650  NH2 ARG A 216      94.234  25.069  73.153  1.00 12.22           N  
ATOM   1651  N   CYS A 217      89.646  24.273  64.928  1.00 10.62           N  
ATOM   1652  CA  CYS A 217      88.451  23.848  64.210  1.00 15.87           C  
ATOM   1653  C   CYS A 217      88.911  22.915  63.110  1.00  9.68           C  
ATOM   1654  O   CYS A 217      90.032  23.019  62.631  1.00 13.88           O  
ATOM   1655  CB  CYS A 217      87.674  25.031  63.627  1.00 22.72           C  
ATOM   1656  SG  CYS A 217      88.660  26.300  62.883  1.00 35.68           S  
ATOM   1657  N   ALA A 218      88.051  21.982  62.741  1.00 11.43           N  
ATOM   1658  CA  ALA A 218      88.366  21.002  61.719  1.00  6.60           C  
ATOM   1659  C   ALA A 218      88.891  21.645  60.442  1.00  5.12           C  
ATOM   1660  O   ALA A 218      89.896  21.208  59.879  1.00  2.00           O  
ATOM   1661  CB  ALA A 218      87.125  20.176  61.415  1.00  2.00           C  
ATOM   1662  N   LEU A 219      88.203  22.689  59.989  1.00  6.87           N  
ATOM   1663  CA  LEU A 219      88.586  23.371  58.754  1.00 13.06           C  
ATOM   1664  C   LEU A 219      89.791  24.292  58.893  1.00  9.66           C  
ATOM   1665  O   LEU A 219      90.289  24.813  57.908  1.00 10.23           O  
ATOM   1666  CB  LEU A 219      87.380  24.133  58.182  1.00  2.21           C  
ATOM   1667  CG  LEU A 219      86.207  23.166  57.947  1.00  5.86           C  
ATOM   1668  CD1 LEU A 219      84.890  23.919  57.743  1.00  4.97           C  
ATOM   1669  CD2 LEU A 219      86.521  22.291  56.757  1.00  5.51           C  
ATOM   1670  N   ARG A 220      90.255  24.472  60.122  1.00 11.58           N  
ATOM   1671  CA  ARG A 220      91.418  25.305  60.412  1.00 16.14           C  
ATOM   1672  C   ARG A 220      91.525  26.589  59.584  1.00 14.99           C  
ATOM   1673  O   ARG A 220      92.527  26.827  58.909  1.00 17.03           O  
ATOM   1674  CB  ARG A 220      92.692  24.467  60.255  1.00 13.16           C  
ATOM   1675  CG  ARG A 220      92.828  23.386  61.317  1.00 23.24           C  
ATOM   1676  CD  ARG A 220      94.079  22.549  61.134  1.00 28.57           C  
ATOM   1677  NE  ARG A 220      95.280  23.247  61.583  1.00 43.59           N  
ATOM   1678  CZ  ARG A 220      96.114  22.789  62.512  1.00 51.13           C  
ATOM   1679  NH1 ARG A 220      95.887  21.626  63.105  1.00 54.73           N  
ATOM   1680  NH2 ARG A 220      97.188  23.494  62.839  1.00 59.75           N  
ATOM   1681  N   ARG A 221      90.494  27.423  59.660  1.00 12.04           N  
ATOM   1682  CA  ARG A 221      90.479  28.678  58.931  1.00  9.51           C  
ATOM   1683  C   ARG A 221      89.294  29.496  59.407  1.00  8.30           C  
ATOM   1684  O   ARG A 221      88.303  28.942  59.873  1.00 10.57           O  
ATOM   1685  CB  ARG A 221      90.364  28.423  57.421  1.00  4.26           C  
ATOM   1686  CG  ARG A 221      89.245  27.462  57.022  1.00 11.10           C  
ATOM   1687  CD  ARG A 221      88.742  27.710  55.601  1.00  5.95           C  
ATOM   1688  NE  ARG A 221      87.689  28.721  55.600  1.00 14.23           N  
ATOM   1689  CZ  ARG A 221      86.436  28.513  55.209  1.00  8.07           C  
ATOM   1690  NH1 ARG A 221      86.065  27.325  54.772  1.00  3.94           N  
ATOM   1691  NH2 ARG A 221      85.540  29.486  55.321  1.00 11.68           N  
ATOM   1692  N   MET A 222      89.407  30.814  59.303  1.00  4.72           N  
ATOM   1693  CA  MET A 222      88.323  31.696  59.706  1.00  3.94           C  
ATOM   1694  C   MET A 222      87.184  31.579  58.706  1.00  5.43           C  
ATOM   1695  O   MET A 222      87.407  31.389  57.510  1.00  8.43           O  
ATOM   1696  CB  MET A 222      88.784  33.141  59.717  1.00  3.85           C  
ATOM   1697  CG  MET A 222      89.763  33.498  60.799  1.00 12.37           C  
ATOM   1698  SD  MET A 222      90.177  35.248  60.637  1.00 14.72           S  
ATOM   1699  CE  MET A 222      89.076  35.949  61.827  1.00 31.60           C  
ATOM   1700  N   GLY A 223      85.959  31.694  59.196  1.00  2.00           N  
ATOM   1701  CA  GLY A 223      84.834  31.622  58.300  1.00  8.57           C  
ATOM   1702  C   GLY A 223      84.750  32.970  57.628  1.00 11.63           C  
ATOM   1703  O   GLY A 223      85.442  33.905  58.027  1.00 12.52           O  
ATOM   1704  N   GLU A 224      83.926  33.074  56.599  1.00 10.24           N  
ATOM   1705  CA  GLU A 224      83.761  34.339  55.920  1.00 14.35           C  
ATOM   1706  C   GLU A 224      82.371  34.855  56.255  1.00 11.53           C  
ATOM   1707  O   GLU A 224      81.464  34.070  56.562  1.00 15.06           O  
ATOM   1708  CB  GLU A 224      83.915  34.154  54.417  1.00 17.40           C  
ATOM   1709  CG  GLU A 224      85.343  33.929  53.995  1.00 33.96           C  
ATOM   1710  CD  GLU A 224      85.437  33.223  52.664  1.00 52.06           C  
ATOM   1711  OE1 GLU A 224      86.403  32.449  52.463  1.00 60.52           O  
ATOM   1712  OE2 GLU A 224      84.538  33.442  51.819  1.00 55.80           O  
ATOM   1713  N   PRO A 225      82.180  36.180  56.212  1.00  7.61           N  
ATOM   1714  CA  PRO A 225      80.859  36.743  56.525  1.00  7.66           C  
ATOM   1715  C   PRO A 225      79.728  36.101  55.725  1.00  4.60           C  
ATOM   1716  O   PRO A 225      78.629  35.894  56.242  1.00  6.95           O  
ATOM   1717  CB  PRO A 225      81.013  38.233  56.215  1.00  2.00           C  
ATOM   1718  CG  PRO A 225      82.501  38.481  56.367  1.00  8.30           C  
ATOM   1719  CD  PRO A 225      83.162  37.222  55.872  1.00  2.76           C  
ATOM   1720  N   LYS A 226      79.999  35.767  54.467  1.00  7.96           N  
ATOM   1721  CA  LYS A 226      78.972  35.167  53.625  1.00 10.06           C  
ATOM   1722  C   LYS A 226      78.715  33.725  54.011  1.00 10.35           C  
ATOM   1723  O   LYS A 226      77.773  33.112  53.528  1.00 10.72           O  
ATOM   1724  CB  LYS A 226      79.358  35.271  52.147  1.00  7.54           C  
ATOM   1725  CG  LYS A 226      80.300  34.201  51.662  1.00 13.92           C  
ATOM   1726  CD  LYS A 226      80.612  34.411  50.195  1.00 19.26           C  
ATOM   1727  CE  LYS A 226      82.031  34.910  49.996  1.00 29.27           C  
ATOM   1728  NZ  LYS A 226      82.833  33.923  49.205  1.00 37.49           N  
ATOM   1729  N   GLU A 227      79.550  33.189  54.898  1.00 14.19           N  
ATOM   1730  CA  GLU A 227      79.375  31.820  55.358  1.00 12.66           C  
ATOM   1731  C   GLU A 227      78.445  31.774  56.563  1.00 18.97           C  
ATOM   1732  O   GLU A 227      77.699  30.814  56.740  1.00 22.39           O  
ATOM   1733  CB  GLU A 227      80.719  31.194  55.697  1.00  2.00           C  
ATOM   1734  CG  GLU A 227      81.337  30.539  54.488  1.00  2.00           C  
ATOM   1735  CD  GLU A 227      82.761  30.124  54.699  1.00  2.00           C  
ATOM   1736  OE1 GLU A 227      83.220  29.228  53.961  1.00  6.00           O  
ATOM   1737  OE2 GLU A 227      83.424  30.687  55.595  1.00  8.08           O  
ATOM   1738  N   LEU A 228      78.480  32.823  57.378  1.00 16.43           N  
ATOM   1739  CA  LEU A 228      77.615  32.911  58.550  1.00 14.53           C  
ATOM   1740  C   LEU A 228      76.218  33.358  58.087  1.00 11.78           C  
ATOM   1741  O   LEU A 228      75.191  32.908  58.590  1.00 12.13           O  
ATOM   1742  CB  LEU A 228      78.192  33.938  59.541  1.00  7.04           C  
ATOM   1743  CG  LEU A 228      77.645  34.049  60.972  1.00 11.03           C  
ATOM   1744  CD1 LEU A 228      76.176  34.470  60.973  1.00  2.00           C  
ATOM   1745  CD2 LEU A 228      77.830  32.710  61.680  1.00 11.36           C  
ATOM   1746  N   ALA A 229      76.198  34.247  57.104  1.00 11.49           N  
ATOM   1747  CA  ALA A 229      74.958  34.787  56.580  1.00  3.63           C  
ATOM   1748  C   ALA A 229      74.073  33.750  55.913  1.00  6.43           C  
ATOM   1749  O   ALA A 229      72.840  33.828  56.009  1.00  6.01           O  
ATOM   1750  CB  ALA A 229      75.267  35.896  55.614  1.00  6.79           C  
ATOM   1751  N   ALA A 230      74.699  32.787  55.235  1.00  6.92           N  
ATOM   1752  CA  ALA A 230      73.982  31.715  54.531  1.00  5.29           C  
ATOM   1753  C   ALA A 230      73.121  30.867  55.459  1.00  4.08           C  
ATOM   1754  O   ALA A 230      72.146  30.265  55.033  1.00 12.11           O  
ATOM   1755  CB  ALA A 230      74.974  30.822  53.795  1.00  4.02           C  
ATOM   1756  N   MET A 231      73.482  30.801  56.730  1.00 10.74           N  
ATOM   1757  CA  MET A 231      72.696  30.005  57.660  1.00 11.64           C  
ATOM   1758  C   MET A 231      71.535  30.840  58.195  1.00  9.19           C  
ATOM   1759  O   MET A 231      70.473  30.305  58.490  1.00  8.94           O  
ATOM   1760  CB  MET A 231      73.575  29.496  58.807  1.00  6.79           C  
ATOM   1761  CG  MET A 231      72.792  28.801  59.919  1.00 15.83           C  
ATOM   1762  SD  MET A 231      72.259  27.128  59.506  1.00 16.78           S  
ATOM   1763  CE  MET A 231      73.821  26.327  59.460  1.00 19.77           C  
ATOM   1764  N   VAL A 232      71.738  32.152  58.304  1.00 10.32           N  
ATOM   1765  CA  VAL A 232      70.690  33.044  58.780  1.00  6.99           C  
ATOM   1766  C   VAL A 232      69.568  33.050  57.745  1.00 10.96           C  
ATOM   1767  O   VAL A 232      68.387  32.939  58.085  1.00 15.90           O  
ATOM   1768  CB  VAL A 232      71.191  34.507  58.939  1.00 10.60           C  
ATOM   1769  CG1 VAL A 232      70.047  35.390  59.459  1.00  2.00           C  
ATOM   1770  CG2 VAL A 232      72.412  34.568  59.870  1.00  2.89           C  
ATOM   1771  N   ALA A 233      69.945  33.185  56.478  1.00  8.75           N  
ATOM   1772  CA  ALA A 233      68.973  33.215  55.387  1.00  9.28           C  
ATOM   1773  C   ALA A 233      68.171  31.922  55.262  1.00 14.76           C  
ATOM   1774  O   ALA A 233      66.966  31.961  54.985  1.00 20.46           O  
ATOM   1775  CB  ALA A 233      69.671  33.517  54.060  1.00  6.63           C  
ATOM   1776  N   PHE A 234      68.820  30.778  55.460  1.00 12.15           N  
ATOM   1777  CA  PHE A 234      68.101  29.507  55.349  1.00 11.33           C  
ATOM   1778  C   PHE A 234      66.960  29.396  56.358  1.00 11.41           C  
ATOM   1779  O   PHE A 234      65.852  29.008  56.006  1.00 13.57           O  
ATOM   1780  CB  PHE A 234      69.039  28.318  55.543  1.00 10.99           C  
ATOM   1781  CG  PHE A 234      68.314  27.018  55.730  1.00 12.82           C  
ATOM   1782  CD1 PHE A 234      67.691  26.394  54.653  1.00 11.53           C  
ATOM   1783  CD2 PHE A 234      68.187  26.456  56.997  1.00 10.11           C  
ATOM   1784  CE1 PHE A 234      66.952  25.235  54.839  1.00  2.00           C  
ATOM   1785  CE2 PHE A 234      67.449  25.297  57.192  1.00  4.08           C  
ATOM   1786  CZ  PHE A 234      66.830  24.689  56.109  1.00  9.24           C  
ATOM   1787  N   LEU A 235      67.252  29.734  57.612  1.00 13.53           N  
ATOM   1788  CA  LEU A 235      66.283  29.681  58.705  1.00 10.31           C  
ATOM   1789  C   LEU A 235      65.103  30.610  58.479  1.00  9.18           C  
ATOM   1790  O   LEU A 235      64.077  30.492  59.152  1.00  8.62           O  
ATOM   1791  CB  LEU A 235      66.967  30.047  60.028  1.00 14.19           C  
ATOM   1792  CG  LEU A 235      67.851  28.964  60.652  1.00 15.77           C  
ATOM   1793  CD1 LEU A 235      68.774  29.582  61.704  1.00 15.75           C  
ATOM   1794  CD2 LEU A 235      66.959  27.882  61.263  1.00  7.50           C  
ATOM   1795  N   CYS A 236      65.252  31.550  57.548  1.00 11.50           N  
ATOM   1796  CA  CYS A 236      64.164  32.475  57.238  1.00 12.28           C  
ATOM   1797  C   CYS A 236      63.336  31.908  56.075  1.00 13.49           C  
ATOM   1798  O   CYS A 236      62.200  32.330  55.837  1.00 18.52           O  
ATOM   1799  CB  CYS A 236      64.711  33.867  56.894  1.00 16.00           C  
ATOM   1800  SG  CYS A 236      65.534  34.719  58.285  1.00 18.45           S  
ATOM   1801  N   PHE A 237      63.901  30.935  55.366  1.00 11.10           N  
ATOM   1802  CA  PHE A 237      63.200  30.308  54.256  1.00  8.27           C  
ATOM   1803  C   PHE A 237      61.971  29.564  54.760  1.00 13.37           C  
ATOM   1804  O   PHE A 237      61.951  29.044  55.887  1.00 16.31           O  
ATOM   1805  CB  PHE A 237      64.075  29.269  53.550  1.00  4.47           C  
ATOM   1806  CG  PHE A 237      65.132  29.850  52.678  1.00  6.28           C  
ATOM   1807  CD1 PHE A 237      65.004  31.130  52.161  1.00  9.18           C  
ATOM   1808  CD2 PHE A 237      66.296  29.130  52.421  1.00  7.73           C  
ATOM   1809  CE1 PHE A 237      66.031  31.691  51.402  1.00 13.47           C  
ATOM   1810  CE2 PHE A 237      67.322  29.682  51.670  1.00  4.77           C  
ATOM   1811  CZ  PHE A 237      67.196  30.958  51.162  1.00  8.63           C  
ATOM   1812  N   PRO A 238      60.917  29.519  53.937  1.00  9.71           N  
ATOM   1813  CA  PRO A 238      59.720  28.793  54.365  1.00 10.57           C  
ATOM   1814  C   PRO A 238      60.098  27.312  54.446  1.00  8.50           C  
ATOM   1815  O   PRO A 238      59.389  26.503  55.049  1.00 10.88           O  
ATOM   1816  CB  PRO A 238      58.708  29.075  53.248  1.00  8.80           C  
ATOM   1817  CG  PRO A 238      59.235  30.302  52.556  1.00  6.42           C  
ATOM   1818  CD  PRO A 238      60.725  30.169  52.631  1.00  8.17           C  
ATOM   1819  N   ALA A 239      61.233  26.971  53.835  1.00  8.31           N  
ATOM   1820  CA  ALA A 239      61.722  25.598  53.830  1.00  6.12           C  
ATOM   1821  C   ALA A 239      62.111  25.146  55.225  1.00  7.92           C  
ATOM   1822  O   ALA A 239      62.063  23.964  55.527  1.00 13.61           O  
ATOM   1823  CB  ALA A 239      62.912  25.469  52.905  1.00  2.00           C  
ATOM   1824  N   ALA A 240      62.510  26.080  56.078  1.00 12.11           N  
ATOM   1825  CA  ALA A 240      62.908  25.723  57.437  1.00 14.04           C  
ATOM   1826  C   ALA A 240      61.764  26.027  58.392  1.00 16.70           C  
ATOM   1827  O   ALA A 240      61.981  26.532  59.491  1.00 22.08           O  
ATOM   1828  CB  ALA A 240      64.154  26.497  57.843  1.00  4.22           C  
ATOM   1829  N   SER A 241      60.546  25.699  57.964  1.00 17.26           N  
ATOM   1830  CA  SER A 241      59.342  25.946  58.753  1.00 14.04           C  
ATOM   1831  C   SER A 241      59.198  25.088  60.016  1.00 15.16           C  
ATOM   1832  O   SER A 241      58.344  25.373  60.860  1.00  5.49           O  
ATOM   1833  CB  SER A 241      58.102  25.760  57.869  1.00  6.15           C  
ATOM   1834  OG  SER A 241      58.153  24.517  57.197  1.00  7.13           O  
ATOM   1835  N   TYR A 242      60.009  24.033  60.134  1.00 13.10           N  
ATOM   1836  CA  TYR A 242      59.954  23.159  61.307  1.00  8.47           C  
ATOM   1837  C   TYR A 242      61.102  23.416  62.279  1.00  7.80           C  
ATOM   1838  O   TYR A 242      61.191  22.764  63.315  1.00  8.28           O  
ATOM   1839  CB  TYR A 242      59.975  21.676  60.894  1.00  4.56           C  
ATOM   1840  CG  TYR A 242      59.242  20.787  61.880  1.00  2.00           C  
ATOM   1841  CD1 TYR A 242      57.966  21.126  62.330  1.00  2.00           C  
ATOM   1842  CD2 TYR A 242      59.842  19.643  62.405  1.00  3.74           C  
ATOM   1843  CE1 TYR A 242      57.304  20.359  63.276  1.00  3.67           C  
ATOM   1844  CE2 TYR A 242      59.189  18.863  63.357  1.00  2.94           C  
ATOM   1845  CZ  TYR A 242      57.919  19.230  63.786  1.00  2.60           C  
ATOM   1846  OH  TYR A 242      57.249  18.465  64.711  1.00  2.68           O  
ATOM   1847  N   VAL A 243      61.981  24.360  61.944  1.00  6.72           N  
ATOM   1848  CA  VAL A 243      63.114  24.675  62.805  1.00  8.87           C  
ATOM   1849  C   VAL A 243      62.821  25.886  63.689  1.00 11.61           C  
ATOM   1850  O   VAL A 243      62.705  27.018  63.208  1.00  5.73           O  
ATOM   1851  CB  VAL A 243      64.384  24.966  61.980  1.00 10.84           C  
ATOM   1852  CG1 VAL A 243      65.600  24.878  62.869  1.00  7.94           C  
ATOM   1853  CG2 VAL A 243      64.503  23.969  60.839  1.00  9.41           C  
ATOM   1854  N   THR A 244      62.697  25.631  64.988  1.00 10.05           N  
ATOM   1855  CA  THR A 244      62.421  26.681  65.960  1.00  8.88           C  
ATOM   1856  C   THR A 244      63.068  26.339  67.299  1.00  7.64           C  
ATOM   1857  O   THR A 244      63.108  25.169  67.700  1.00  9.73           O  
ATOM   1858  CB  THR A 244      60.888  26.860  66.170  1.00  6.63           C  
ATOM   1859  OG1 THR A 244      60.648  27.995  67.002  1.00  2.00           O  
ATOM   1860  CG2 THR A 244      60.290  25.645  66.842  1.00  8.47           C  
ATOM   1861  N   GLY A 245      63.579  27.366  67.975  1.00  7.94           N  
ATOM   1862  CA  GLY A 245      64.195  27.196  69.283  1.00  2.00           C  
ATOM   1863  C   GLY A 245      65.570  26.561  69.304  1.00  7.27           C  
ATOM   1864  O   GLY A 245      65.970  25.996  70.328  1.00  5.50           O  
ATOM   1865  N   GLN A 246      66.303  26.660  68.197  1.00  6.68           N  
ATOM   1866  CA  GLN A 246      67.642  26.063  68.099  1.00  5.33           C  
ATOM   1867  C   GLN A 246      68.802  27.070  68.091  1.00  5.07           C  
ATOM   1868  O   GLN A 246      68.655  28.217  67.656  1.00  5.98           O  
ATOM   1869  CB  GLN A 246      67.746  25.216  66.819  1.00  2.00           C  
ATOM   1870  CG  GLN A 246      67.081  23.870  66.890  1.00  2.34           C  
ATOM   1871  CD  GLN A 246      67.979  22.822  67.501  1.00  9.11           C  
ATOM   1872  OE1 GLN A 246      69.104  22.602  67.041  1.00  4.72           O  
ATOM   1873  NE2 GLN A 246      67.491  22.167  68.553  1.00  4.51           N  
ATOM   1874  N   ILE A 247      69.957  26.630  68.579  1.00  6.88           N  
ATOM   1875  CA  ILE A 247      71.159  27.457  68.569  1.00  8.90           C  
ATOM   1876  C   ILE A 247      72.076  26.639  67.681  1.00  6.38           C  
ATOM   1877  O   ILE A 247      72.511  25.565  68.077  1.00  5.00           O  
ATOM   1878  CB  ILE A 247      71.809  27.598  69.969  1.00 11.19           C  
ATOM   1879  CG1 ILE A 247      70.745  27.941  71.024  1.00  3.36           C  
ATOM   1880  CG2 ILE A 247      72.923  28.653  69.913  1.00  7.63           C  
ATOM   1881  CD1 ILE A 247      70.241  29.349  70.954  1.00  6.95           C  
ATOM   1882  N   ILE A 248      72.335  27.125  66.471  1.00  3.93           N  
ATOM   1883  CA  ILE A 248      73.170  26.395  65.532  1.00  3.60           C  
ATOM   1884  C   ILE A 248      74.496  27.091  65.352  1.00  3.24           C  
ATOM   1885  O   ILE A 248      74.543  28.292  65.097  1.00  5.02           O  
ATOM   1886  CB  ILE A 248      72.504  26.278  64.136  1.00  2.00           C  
ATOM   1887  CG1 ILE A 248      71.252  25.412  64.215  1.00  2.00           C  
ATOM   1888  CG2 ILE A 248      73.496  25.688  63.141  1.00  2.00           C  
ATOM   1889  CD1 ILE A 248      70.150  25.846  63.284  1.00  2.00           C  
ATOM   1890  N   TYR A 249      75.579  26.330  65.455  1.00  7.72           N  
ATOM   1891  CA  TYR A 249      76.905  26.911  65.312  1.00  9.42           C  
ATOM   1892  C   TYR A 249      77.533  26.738  63.938  1.00  7.79           C  
ATOM   1893  O   TYR A 249      77.564  25.647  63.387  1.00 13.21           O  
ATOM   1894  CB  TYR A 249      77.829  26.341  66.386  1.00 11.18           C  
ATOM   1895  CG  TYR A 249      77.346  26.628  67.784  1.00 13.42           C  
ATOM   1896  CD1 TYR A 249      76.525  25.726  68.455  1.00 17.26           C  
ATOM   1897  CD2 TYR A 249      77.676  27.822  68.426  1.00 15.94           C  
ATOM   1898  CE1 TYR A 249      76.036  26.010  69.735  1.00 13.52           C  
ATOM   1899  CE2 TYR A 249      77.193  28.114  69.702  1.00 13.91           C  
ATOM   1900  CZ  TYR A 249      76.376  27.206  70.347  1.00 15.29           C  
ATOM   1901  OH  TYR A 249      75.886  27.498  71.600  1.00 18.53           O  
ATOM   1902  N   VAL A 250      78.006  27.849  63.385  1.00 11.10           N  
ATOM   1903  CA  VAL A 250      78.685  27.872  62.096  1.00  5.66           C  
ATOM   1904  C   VAL A 250      80.117  28.193  62.525  1.00 10.39           C  
ATOM   1905  O   VAL A 250      80.531  29.348  62.506  1.00 12.54           O  
ATOM   1906  CB  VAL A 250      78.131  28.998  61.189  1.00  4.63           C  
ATOM   1907  CG1 VAL A 250      78.856  28.990  59.857  1.00  2.68           C  
ATOM   1908  CG2 VAL A 250      76.632  28.810  60.973  1.00  2.00           C  
ATOM   1909  N   ASP A 251      80.865  27.157  62.909  1.00  9.76           N  
ATOM   1910  CA  ASP A 251      82.218  27.318  63.438  1.00  2.00           C  
ATOM   1911  C   ASP A 251      83.321  26.382  62.914  1.00  5.32           C  
ATOM   1912  O   ASP A 251      84.300  26.150  63.621  1.00  7.10           O  
ATOM   1913  CB  ASP A 251      82.151  27.121  64.935  1.00  2.00           C  
ATOM   1914  CG  ASP A 251      81.757  25.694  65.302  1.00 12.37           C  
ATOM   1915  OD1 ASP A 251      81.650  24.858  64.367  1.00 10.48           O  
ATOM   1916  OD2 ASP A 251      81.543  25.402  66.504  1.00 12.60           O  
ATOM   1917  N   GLY A 252      83.183  25.836  61.713  1.00  2.56           N  
ATOM   1918  CA  GLY A 252      84.209  24.943  61.197  1.00  2.00           C  
ATOM   1919  C   GLY A 252      84.527  23.759  62.101  1.00  3.23           C  
ATOM   1920  O   GLY A 252      85.629  23.222  62.047  1.00  3.04           O  
ATOM   1921  N   GLY A 253      83.573  23.352  62.937  1.00  3.29           N  
ATOM   1922  CA  GLY A 253      83.784  22.222  63.825  1.00  3.76           C  
ATOM   1923  C   GLY A 253      84.313  22.547  65.211  1.00  6.58           C  
ATOM   1924  O   GLY A 253      84.552  21.648  66.012  1.00  8.88           O  
ATOM   1925  N   LEU A 254      84.477  23.833  65.499  1.00  9.20           N  
ATOM   1926  CA  LEU A 254      85.014  24.301  66.772  1.00  8.35           C  
ATOM   1927  C   LEU A 254      84.308  23.767  68.014  1.00 13.16           C  
ATOM   1928  O   LEU A 254      84.952  23.507  69.032  1.00 13.05           O  
ATOM   1929  CB  LEU A 254      85.003  25.837  66.791  1.00  5.71           C  
ATOM   1930  CG  LEU A 254      85.750  26.595  67.890  1.00  2.00           C  
ATOM   1931  CD1 LEU A 254      87.231  26.294  67.843  1.00  2.00           C  
ATOM   1932  CD2 LEU A 254      85.528  28.081  67.704  1.00  2.14           C  
ATOM   1933  N   MET A 255      82.989  23.606  67.937  1.00  9.85           N  
ATOM   1934  CA  MET A 255      82.211  23.127  69.075  1.00  7.08           C  
ATOM   1935  C   MET A 255      82.179  21.610  69.240  1.00 10.57           C  
ATOM   1936  O   MET A 255      81.542  21.107  70.167  1.00 19.98           O  
ATOM   1937  CB  MET A 255      80.769  23.651  68.995  1.00  9.72           C  
ATOM   1938  CG  MET A 255      80.597  25.105  69.413  1.00  9.68           C  
ATOM   1939  SD  MET A 255      80.297  25.305  71.189  1.00 14.09           S  
ATOM   1940  CE  MET A 255      78.655  24.567  71.337  1.00 23.51           C  
ATOM   1941  N   ALA A 256      82.848  20.875  68.355  1.00  8.11           N  
ATOM   1942  CA  ALA A 256      82.862  19.416  68.462  1.00  4.69           C  
ATOM   1943  C   ALA A 256      84.215  18.909  68.932  1.00  6.67           C  
ATOM   1944  O   ALA A 256      84.346  17.766  69.376  1.00 12.54           O  
ATOM   1945  CB  ALA A 256      82.508  18.785  67.130  1.00 10.33           C  
ATOM   1946  N   ASN A 257      85.212  19.784  68.862  1.00  8.44           N  
ATOM   1947  CA  ASN A 257      86.585  19.464  69.246  1.00  5.97           C  
ATOM   1948  C   ASN A 257      86.865  19.489  70.736  1.00 10.12           C  
ATOM   1949  O   ASN A 257      86.215  20.219  71.487  1.00 12.94           O  
ATOM   1950  CB  ASN A 257      87.543  20.447  68.569  1.00  7.38           C  
ATOM   1951  CG  ASN A 257      88.993  20.036  68.699  1.00  6.62           C  
ATOM   1952  OD1 ASN A 257      89.311  18.871  68.956  1.00  2.88           O  
ATOM   1953  ND2 ASN A 257      89.885  20.996  68.521  1.00  8.15           N  
ATOM   1954  N   CYS A 258      87.845  18.686  71.152  1.00 11.82           N  
ATOM   1955  CA  CYS A 258      88.284  18.635  72.539  1.00  6.42           C  
ATOM   1956  C   CYS A 258      89.800  18.474  72.516  1.00 10.49           C  
ATOM   1957  O   CYS A 258      90.528  19.306  73.053  1.00 17.47           O  
ATOM   1958  CB  CYS A 258      87.658  17.460  73.293  1.00 11.84           C  
ATOM   1959  SG  CYS A 258      88.487  17.063  74.891  1.00 19.78           S  
ATOM   1960  N   GLY A 259      90.274  17.413  71.873  1.00  8.20           N  
ATOM   1961  CA  GLY A 259      91.704  17.173  71.822  1.00  4.16           C  
ATOM   1962  C   GLY A 259      92.378  17.261  70.471  1.00  2.58           C  
ATOM   1963  O   GLY A 259      93.467  16.715  70.292  1.00  6.97           O  
ATOM   1964  N   PHE A 260      91.747  17.937  69.516  1.00  4.53           N  
ATOM   1965  CA  PHE A 260      92.326  18.096  68.179  1.00 10.00           C  
ATOM   1966  C   PHE A 260      92.922  19.497  68.045  1.00 11.36           C  
ATOM   1967  O   PHE A 260      93.962  19.663  67.371  1.00 12.52           O  
ATOM   1968  CB  PHE A 260      91.257  17.927  67.105  1.00  6.95           C  
ATOM   1969  CG  PHE A 260      91.077  16.521  66.627  1.00  9.46           C  
ATOM   1970  CD1 PHE A 260      91.785  16.055  65.524  1.00  2.49           C  
ATOM   1971  CD2 PHE A 260      90.134  15.682  67.226  1.00  9.06           C  
ATOM   1972  CE1 PHE A 260      91.553  14.777  65.013  1.00  9.28           C  
ATOM   1973  CE2 PHE A 260      89.894  14.401  66.724  1.00 14.09           C  
ATOM   1974  CZ  PHE A 260      90.604  13.945  65.610  1.00 10.44           C  
ATOM   1975  OXT PHE A 260      92.322  20.423  68.619  1.00 10.18           O  
TER    1976      PHE A 260                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
