
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  302 ( 2245),  selected  302 , name 1zbq_F
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1zbq_F.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_F      -       -           -
LGA    P     4_F      -       -           -
LGA    L     5_F      M       1          1.891
LGA    R     6_F      T       2          0.554
LGA    F     7_F      L       3          1.009
LGA    D     8_F      S       4          1.455
LGA    G     9_F      G       5          1.589
LGA    R    10_F      K       6          0.900
LGA    V    11_F      T       7          0.663
LGA    V    12_F      L       8          0.554
LGA    L    13_F      F       9          0.916
LGA    V    14_F      I      10          0.953
LGA    T    15_F      T      11          0.572
LGA    G    16_F      G      12          0.571
LGA    A    17_F      A      13          0.423
LGA    G    18_F      S      14          1.054
LGA    A    19_F      R      15          1.171
LGA    G    20_F      G      16          1.103
LGA    L    21_F      I      17          0.662
LGA    G    22_F      G      18          0.507
LGA    R    23_F      L      19          0.876
LGA    A    24_F      A      20          0.644
LGA    Y    25_F      I      21          0.320
LGA    A    26_F      A      22          0.312
LGA    L    27_F      L      23          0.303
LGA    A    28_F      R      24          0.446
LGA    F    29_F      A      25          0.689
LGA    A    30_F      A      26          0.762
LGA    E    31_F      R      27          0.590
LGA    R    32_F      D      28          1.064
LGA    G    33_F      G      29          1.545
LGA    A    34_F      A      30          0.926
LGA    L    35_F      N      31          0.583
LGA    V    36_F      V      32          0.536
LGA    V    37_F      A      33          0.550
LGA    V    38_F      I      34          1.202
LGA    N    39_F      A      35          1.665
LGA    D    40_F      A      36          1.474
LGA    L    41_F      K      37          1.000
LGA    G    42_F      S      38          2.154
LGA    G    43_F      -       -           -
LGA    D    44_F      -       -           -
LGA    F    45_F      -       -           -
LGA    K    46_F      -       -           -
LGA    G    47_F      -       -           -
LGA    V    48_F      -       -           -
LGA    G    49_F      -       -           -
LGA    K    50_F      -       -           -
LGA    G    51_F      A      39          3.276
LGA    S    52_F      V      40          3.899
LGA    L    53_F      A      41          4.179
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    A    54_F      T      48          1.282
LGA    A    55_F      I      49          1.359
LGA    D    56_F      H      50          1.064
LGA    K    57_F      S      51          1.054
LGA    V    58_F      A      52          1.303
LGA    V    59_F      A      53          1.167
LGA    E    60_F      A      54          1.171
LGA    E    61_F      A      55          1.433
LGA    I    62_F      V      56          1.730
LGA    R    63_F      N      57          1.392
LGA    R    64_F      A      58          1.839
LGA    R    65_F      A      59          2.431
LGA    G    66_F      G      60          2.699
LGA    G    67_F      G      61          1.805
LGA    K    68_F      Q      62          1.060
LGA    A    69_F      G      63          0.883
LGA    V    70_F      L      64          0.730
LGA    A    71_F      A      65          0.712
LGA    N    72_F      L      66          0.967
LGA    Y    73_F      K      67          1.237
LGA    D    74_F      C      68          0.867
LGA    S    75_F      D      69          0.785
LGA    V    76_F      I      70          1.206
LGA    E    77_F      R      71          2.074
LGA    E    78_F      E      72          3.009
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    -       -      Q      75           -
LGA    G    79_F      V      76          2.241
LGA    E    80_F      R      77          1.283
LGA    K    81_F      A      78          2.113
LGA    V    82_F      A      79          2.572
LGA    V    83_F      V      80          1.393
LGA    K    84_F      A      81          2.020
LGA    T    85_F      A      82          2.638
LGA    A    86_F      T      83          1.142
LGA    L    87_F      V      84          1.160
LGA    D    88_F      D      85          2.260
LGA    A    89_F      T      86          1.511
LGA    F    90_F      F      87          0.862
LGA    G    91_F      G      88          1.867
LGA    R    92_F      G      89          0.752
LGA    I    93_F      I      90          0.715
LGA    D    94_F      D      91          0.894
LGA    V    95_F      I      92          0.119
LGA    V    96_F      L      93          0.211
LGA    V    97_F      V      94          0.216
LGA    N    98_F      N      95          0.332
LGA    N    99_F      N      96          0.122
LGA    A   100_F      A      97          2.305
LGA    G   101_F      S      98          2.043
LGA    I   102_F      A      99          1.604
LGA    L   103_F      I     100          2.077
LGA    R   104_F      W     101          2.950
LGA    D   105_F      L     102          3.142
LGA    R   106_F      R     103          2.552
LGA    S   107_F      G     104          1.933
LGA    F   108_F      T     105          1.338
LGA    A   109_F      L     106          1.084
LGA    R   110_F      D     107          1.699
LGA    I   111_F      T     108          1.480
LGA    S   112_F      P     109          1.716
LGA    D   113_F      M     110          1.700
LGA    E   114_F      K     111          1.317
LGA    D   115_F      R     112          1.488
LGA    W   116_F      F     113          1.254
LGA    D   117_F      D     114          1.261
LGA    I   118_F      L     115          1.267
LGA    I   119_F      M     116          0.717
LGA    H   120_F      Q     117          0.483
LGA    R   121_F      Q     118          0.874
LGA    V   122_F      V     119          0.953
LGA    H   123_F      N     120          0.724
LGA    L   124_F      A     121          1.040
LGA    R   125_F      R     122          0.953
LGA    G   126_F      G     123          0.939
LGA    S   127_F      S     124          0.975
LGA    F   128_F      F     125          0.878
LGA    Q   129_F      V     126          0.850
LGA    V   130_F      C     127          0.807
LGA    T   131_F      A     128          0.847
LGA    R   132_F      Q     129          0.250
LGA    A   133_F      A     130          0.424
LGA    A   134_F      C     131          0.631
LGA    W   135_F      L     132          0.734
LGA    E   136_F      P     133          1.355
LGA    H   137_F      H     134          1.602
LGA    M   138_F      L     135          1.765
LGA    K   139_F      L     136          1.922
LGA    K   140_F      Q     137          3.512
LGA    Q   141_F      A     138          3.802
LGA    K   142_F      P     139           #
LGA    Y   143_F      N     140          4.106
LGA    G   144_F      P     141          1.611
LGA    R   145_F      H     142          0.064
LGA    I   146_F      I     143          0.401
LGA    I   147_F      L     144          0.987
LGA    M   148_F      T     145          1.317
LGA    T   149_F      L     146          1.808
LGA    S   150_F      A     147          1.663
LGA    S   151_F      P     148          3.994
LGA    A   152_F      P     149           #
LGA    S   153_F      -       -           -
LGA    G   154_F      P     150           #
LGA    I   155_F      S     151          4.025
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    Y   156_F      W     156          4.061
LGA    G   157_F      W     157          4.192
LGA    N   158_F      G     158          6.755
LGA    F   159_F      A     159          2.603
LGA    G   160_F      H     160          3.753
LGA    Q   161_F      -       -           -
LGA    A   162_F      T     161          1.773
LGA    N   163_F      G     162          1.156
LGA    Y   164_F      Y     163          1.461
LGA    S   165_F      T     164          0.869
LGA    A   166_F      L     165          0.481
LGA    A   167_F      A     166          1.226
LGA    K   168_F      K     167          1.226
LGA    L   169_F      M     168          1.140
LGA    G   170_F      G     169          1.539
LGA    L   171_F      M     170          1.572
LGA    L   172_F      S     171          1.539
LGA    G   173_F      L     172          1.411
LGA    L   174_F      V     173          1.260
LGA    A   175_F      T     174          1.156
LGA    N   176_F      L     175          1.372
LGA    S   177_F      G     176          1.866
LGA    L   178_F      L     177          1.550
LGA    A   179_F      A     178          1.376
LGA    I   180_F      A     179          2.194
LGA    E   181_F      E     180          2.165
LGA    G   182_F      F     181          1.987
LGA    R   183_F      G     182          2.661
LGA    K   184_F      P     183          3.420
LGA    S   185_F      Q     184          2.478
LGA    N   186_F      G     185          1.831
LGA    I   187_F      V     186          0.682
LGA    H   188_F      A     187          1.106
LGA    C   189_F      I     188          0.529
LGA    N   190_F      N     189          0.481
LGA    T   191_F      A     190          0.999
LGA    I   192_F      L     191          1.820
LGA    A   193_F      W     192          2.124
LGA    P   194_F      P     193          2.468
LGA    -       -      R     194           -
LGA    -       -      T     195           -
LGA    N   195_F      V     196          3.268
LGA    A   196_F      I     197          0.843
LGA    G   197_F      A     198          0.685
LGA    S   198_F      T     199          0.569
LGA    R   199_F      D     200          0.524
LGA    M   200_F      A     201          0.247
LGA    T   201_F      I     202          1.305
LGA    Q   202_F      N     203          3.826
LGA    T   203_F      M     204          4.482
LGA    -       -      L     205           -
LGA    -       -      P     206           -
LGA    V   204_F      G     207          3.965
LGA    M   205_F      V     208          1.306
LGA    P   206_F      D     209          1.651
LGA    E   207_F      A     210          3.643
LGA    D   208_F      A     211          1.573
LGA    L   209_F      A     212          1.761
LGA    V   210_F      C     213          4.099
LGA    E   211_F      -       -           -
LGA    A   212_F      -       -           -
LGA    L   213_F      R     214          0.693
LGA    K   214_F      R     215          0.702
LGA    P   215_F      P     216          0.857
LGA    E   216_F      E     217          0.609
LGA    Y   217_F      I     218          0.857
LGA    V   218_F      M     219          1.355
LGA    A   219_F      A     220          1.465
LGA    P   220_F      D     221          1.897
LGA    L   221_F      A     222          1.864
LGA    V   222_F      A     223          1.274
LGA    L   223_F      H     224          1.522
LGA    W   224_F      A     225          2.051
LGA    L   225_F      V     226          1.885
LGA    C   226_F      L     227          1.645
LGA    H   227_F      T     228          1.879
LGA    E   228_F      R     229          4.737
LGA    S   229_F      E     230          2.540
LGA    C   230_F      A     231          5.057
LGA    E   231_F      A     232          5.199
LGA    E   232_F      G     233           #
LGA    N   233_F      F     234          2.940
LGA    -       -      H     235           -
LGA    G   234_F      G     236          0.666
LGA    G   235_F      Q     237          0.505
LGA    L   236_F      F     238          0.692
LGA    F   237_F      L     239          1.929
LGA    E   238_F      I     240          2.874
LGA    V   239_F      D     241          2.904
LGA    G   240_F      -       -           -
LGA    A   241_F      -       -           -
LGA    G   242_F      -       -           -
LGA    W   243_F      D     242          2.054
LGA    I   244_F      E     243          2.479
LGA    G   245_F      V     244           #
LGA    K   246_F      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    -       -      L     264           -
LGA    -       -      L     265           -
LGA    -       -      P     266           -
LGA    -       -      D     267           -
LGA    -       -      L     268           -
LGA    -       -      F     269           -
LGA    L   247_F      L     270           #
LGA    R   248_F      E     271           -
LGA    W   249_F      -       -           -
LGA    E   250_F      -       -           -
LGA    R   251_F      -       -           -
LGA    T   252_F      -       -           -
LGA    L   253_F      -       -           -
LGA    G   254_F      -       -           -
LGA    A   255_F      -       -           -
LGA    I   256_F      -       -           -
LGA    V   257_F      -       -           -
LGA    R   258_F      -       -           -
LGA    Q   259_F      -       -           -
LGA    K   260_F      -       -           -
LGA    N   261_F      -       -           -
LGA    H   262_F      -       -           -
LGA    P   263_F      -       -           -
LGA    M   264_F      -       -           -
LGA    T   265_F      -       -           -
LGA    P   266_F      -       -           -
LGA    E   267_F      -       -           -
LGA    A   268_F      -       -           -
LGA    V   269_F      -       -           -
LGA    K   270_F      -       -           -
LGA    A   271_F      -       -           -
LGA    N   272_F      -       -           -
LGA    W   273_F      -       -           -
LGA    K   274_F      -       -           -
LGA    K   275_F      -       -           -
LGA    I   276_F      -       -           -
LGA    C   277_F      -       -           -
LGA    D   278_F      -       -           -
LGA    F   279_F      -       -           -
LGA    E   280_F      -       -           -
LGA    N   281_F      -       -           -
LGA    A   282_F      -       -           -
LGA    S   283_F      -       -           -
LGA    K   284_F      -       -           -
LGA    P   285_F      -       -           -
LGA    Q   286_F      -       -           -
LGA    S   287_F      -       -           -
LGA    I   288_F      -       -           -
LGA    Q   289_F      -       -           -
LGA    E   290_F      -       -           -
LGA    S   291_F      -       -           -
LGA    T   292_F      -       -           -
LGA    G   293_F      -       -           -
LGA    S   294_F      -       -           -
LGA    I   295_F      -       -           -
LGA    I   296_F      -       -           -
LGA    E   297_F      -       -           -
LGA    V   298_F      -       -           -
LGA    L   299_F      -       -           -
LGA    S   300_F      -       -           -
LGA    K   301_F      -       -           -
LGA    I   302_F      -       -           -
LGA    D   303_F      -       -           -
LGA    S   304_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  302  271    5.0    221    1.92    22.62     70.974    10.930

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.583872 * X  +  -0.681324 * Y  +   0.441465 * Z  +  43.265221
  Y_new =  -0.809638 * X  +  -0.528743 * Y  +   0.254788 * Z  +  46.966419
  Z_new =   0.059828 * X  +  -0.506190 * Y  +  -0.860344 * Z  +  98.927727 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.609778    0.531815  [ DEG:  -149.5293     30.4708 ]
  Theta =  -0.059864   -3.081728  [ DEG:    -3.4300   -176.5700 ]
  Phi   =  -0.946015    2.195577  [ DEG:   -54.2027    125.7973 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zbq_F                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zbq_F.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  302  271   5.0  221   1.92   22.62  70.974
REMARK  ---------------------------------------------------------- 
MOLECULE 1zbq_F
HEADER    OXIDOREDUCTASE                          08-APR-05   1ZBQ              
TITLE     CRYSTAL STRUCTURE OF HUMAN 17-BETA-HYDROXYSTEROID                     
TITLE    2 DEHYDROGENASE TYPE 4 IN COMPLEX WITH NAD                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 17-BETA-HYDROXYSTEROID DEHYDROGENASE 4;                    
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: N-TERMINAL SHORT CHAIN DEHYDROGENASE DOMAIN;               
COMPND   5 SYNONYM: D-BIFUNCTIONAL PROTEIN, DBP,  PEROXISOMAL                   
COMPND   6 MULTIFUNCTIONAL ENZYME TYPE 2, MFE-2, 17-BETA-HSD 4, 3-              
COMPND   7 HYDROXYACYL-COA DEHYDROGENASE;                                       
COMPND   8 EC: 1.1.1.35;                                                        
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: HSD17B4, EDH17B4;                                              
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P11 (TORONTO)                             
KEYWDS    SHORT-CHAIN DEHYDROGENASE, HYDROXYSTEROID DEHYDROGENASE,              
KEYWDS   2 PEROXISOMAL BETA-OXIDATION, HUMAN, STRUCTURAL GENOMICS,              
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, SGC                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.LUKACIK,N.SHAFQAT,K.KAVANAGH,J.BRAY,F.VON DELFT,A.EDWARDS,          
AUTHOR   2 C.ARROWSMITH,M.SUNDSTROM,U.OPPERMANN,STRUCTURAL GENOMICS             
AUTHOR   3 CONSORTIUM (SGC)                                                     
REVDAT   1   26-APR-05 1ZBQ    0                                                
JRNL        AUTH   P.LUKACIK,N.SHAFQAT,K.KAVANAGH,J.BRAY,F.VON DELFT,           
JRNL        AUTH 2 A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,U.OPPERMANN               
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN 17-BETA-HYDROXYSTEROID            
JRNL        TITL 2 DEHYDROGENASE TYPE 4 IN COMPLEX WITH NAD                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.71 ANGSTROMS                                           
DBREF  1ZBQ A    1   304  UNP    P51659   DHB4_HUMAN       1    304             
DBREF  1ZBQ B    1   304  UNP    P51659   DHB4_HUMAN       1    304             
DBREF  1ZBQ C    1   304  UNP    P51659   DHB4_HUMAN       1    304             
DBREF  1ZBQ D    1   304  UNP    P51659   DHB4_HUMAN       1    304             
DBREF  1ZBQ E    1   304  UNP    P51659   DHB4_HUMAN       1    304             
DBREF  1ZBQ F    1   304  UNP    P51659   DHB4_HUMAN       1    304             
SEQRES   1 A  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 A  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 A  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 A  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 A  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 A  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 A  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 A  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 A  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 A  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 A  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 A  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 A  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 A  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 A  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 A  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 A  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 A  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 A  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 A  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 A  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 A  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 A  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 A  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 A  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 A  327  GLY SER                                                      
SEQRES   1 B  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 B  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 B  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 B  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 B  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 B  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 B  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 B  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 B  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 B  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 B  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 B  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 B  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 B  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 B  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 B  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 B  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 B  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 B  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 B  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 B  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 B  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 B  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 B  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 B  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 B  327  GLY SER                                                      
SEQRES   1 C  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 C  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 C  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 C  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 C  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 C  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 C  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 C  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 C  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 C  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 C  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 C  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 C  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 C  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 C  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 C  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 C  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 C  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 C  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 C  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 C  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 C  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 C  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 C  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 C  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 C  327  GLY SER                                                      
SEQRES   1 D  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 D  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 D  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 D  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 D  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 D  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 D  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 D  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 D  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 D  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 D  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 D  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 D  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 D  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 D  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 D  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 D  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 D  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 D  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 D  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 D  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 D  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 D  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 D  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 D  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 D  327  GLY SER                                                      
SEQRES   1 E  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 E  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 E  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 E  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 E  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 E  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 E  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 E  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 E  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 E  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 E  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 E  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 E  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 E  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 E  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 E  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 E  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 E  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 E  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 E  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 E  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 E  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 E  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 E  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 E  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 E  327  GLY SER                                                      
SEQRES   1 F  327  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY ARG          
SEQRES   2 F  327  GLU ASN LEU TYR PHE GLN GLY HIS MET GLY SER PRO LEU          
SEQRES   3 F  327  ARG PHE ASP GLY ARG VAL VAL LEU VAL THR GLY ALA GLY          
SEQRES   4 F  327  ALA GLY LEU GLY ARG ALA TYR ALA LEU ALA PHE ALA GLU          
SEQRES   5 F  327  ARG GLY ALA LEU VAL VAL VAL ASN ASP LEU GLY GLY ASP          
SEQRES   6 F  327  PHE LYS GLY VAL GLY LYS GLY SER LEU ALA ALA ASP LYS          
SEQRES   7 F  327  VAL VAL GLU GLU ILE ARG ARG ARG GLY GLY LYS ALA VAL          
SEQRES   8 F  327  ALA ASN TYR ASP SER VAL GLU GLU GLY GLU LYS VAL VAL          
SEQRES   9 F  327  LYS THR ALA LEU ASP ALA PHE GLY ARG ILE ASP VAL VAL          
SEQRES  10 F  327  VAL ASN ASN ALA GLY ILE LEU ARG ASP ARG SER PHE ALA          
SEQRES  11 F  327  ARG ILE SER ASP GLU ASP TRP ASP ILE ILE HIS ARG VAL          
SEQRES  12 F  327  HIS LEU ARG GLY SER PHE GLN VAL THR ARG ALA ALA TRP          
SEQRES  13 F  327  GLU HIS MET LYS LYS GLN LYS TYR GLY ARG ILE ILE MET          
SEQRES  14 F  327  THR SER SER ALA SER GLY ILE TYR GLY ASN PHE GLY GLN          
SEQRES  15 F  327  ALA ASN TYR SER ALA ALA LYS LEU GLY LEU LEU GLY LEU          
SEQRES  16 F  327  ALA ASN SER LEU ALA ILE GLU GLY ARG LYS SER ASN ILE          
SEQRES  17 F  327  HIS CYS ASN THR ILE ALA PRO ASN ALA GLY SER ARG MET          
SEQRES  18 F  327  THR GLN THR VAL MET PRO GLU ASP LEU VAL GLU ALA LEU          
SEQRES  19 F  327  LYS PRO GLU TYR VAL ALA PRO LEU VAL LEU TRP LEU CYS          
SEQRES  20 F  327  HIS GLU SER CYS GLU GLU ASN GLY GLY LEU PHE GLU VAL          
SEQRES  21 F  327  GLY ALA GLY TRP ILE GLY LYS LEU ARG TRP GLU ARG THR          
SEQRES  22 F  327  LEU GLY ALA ILE VAL ARG GLN LYS ASN HIS PRO MET THR          
SEQRES  23 F  327  PRO GLU ALA VAL LYS ALA ASN TRP LYS LYS ILE CYS ASP          
SEQRES  24 F  327  PHE GLU ASN ALA SER LYS PRO GLN SER ILE GLN GLU SER          
SEQRES  25 F  327  THR GLY SER ILE ILE GLU VAL LEU SER LYS ILE ASP SER          
SEQRES  26 F  327  GLY SER                                                      
HET    NAD  A1001      44                                                       
HET    NAD  B1002      44                                                       
HET    NAD  C1003      44                                                       
HET    NAD  D1004      44                                                       
HET    NAD  E1005      44                                                       
HET    NAD  F1006      44                                                       
HETNAM     NAD NICOTINAMIDE-ADENINE-DINUCLEOTIDE                                
FORMUL   7  NAD    6(C21 H27 N7 O14 P2)                                         
FORMUL  13  HOH   *343(H2 O)                                                    
CRYST1   50.826   50.771  183.775  87.52  87.07  70.75 P 1           6          
ATOM  11329  N   SER F   3      63.406  24.699  44.093  1.00 49.28           N  
ATOM  11330  CA  SER F   3      63.002  26.109  43.828  1.00 49.31           C  
ATOM  11331  C   SER F   3      63.825  27.051  44.708  1.00 48.71           C  
ATOM  11332  O   SER F   3      64.013  26.766  45.888  1.00 49.03           O  
ATOM  11333  CB  SER F   3      61.501  26.297  44.088  1.00 49.72           C  
ATOM  11334  OG  SER F   3      60.698  25.518  43.200  1.00 49.82           O  
ATOM  11335  N   PRO F   4      64.328  28.171  44.139  1.00 47.95           N  
ATOM  11336  CA  PRO F   4      65.189  29.073  44.916  1.00 47.07           C  
ATOM  11337  C   PRO F   4      64.459  29.726  46.097  1.00 46.10           C  
ATOM  11338  O   PRO F   4      63.270  30.043  46.011  1.00 46.12           O  
ATOM  11339  CB  PRO F   4      65.616  30.131  43.889  1.00 47.20           C  
ATOM  11340  CG  PRO F   4      64.559  30.097  42.851  1.00 47.75           C  
ATOM  11341  CD  PRO F   4      64.121  28.663  42.763  1.00 48.00           C  
ATOM  11342  N   LEU F   5      65.178  29.917  47.193  1.00 44.90           N  
ATOM  11343  CA  LEU F   5      64.601  30.508  48.392  1.00 43.91           C  
ATOM  11344  C   LEU F   5      64.610  32.031  48.280  1.00 43.30           C  
ATOM  11345  O   LEU F   5      65.673  32.663  48.373  1.00 43.44           O  
ATOM  11346  CB  LEU F   5      65.346  30.029  49.647  1.00 43.62           C  
ATOM  11347  CG  LEU F   5      65.461  28.508  49.802  1.00 42.75           C  
ATOM  11348  CD1 LEU F   5      66.458  28.148  50.876  1.00 40.65           C  
ATOM  11349  CD2 LEU F   5      64.096  27.841  50.055  1.00 41.64           C  
ATOM  11350  N   ARG F   6      63.426  32.609  48.062  1.00 42.01           N  
ATOM  11351  CA  ARG F   6      63.312  34.052  47.846  1.00 41.01           C  
ATOM  11352  C   ARG F   6      62.774  34.785  49.082  1.00 40.13           C  
ATOM  11353  O   ARG F   6      62.230  34.170  49.998  1.00 39.47           O  
ATOM  11354  CB  ARG F   6      62.418  34.377  46.624  1.00 41.09           C  
ATOM  11355  CG  ARG F   6      62.843  33.796  45.248  1.00 41.24           C  
ATOM  11356  CD  ARG F   6      64.028  34.515  44.579  1.00 39.66           C  
ATOM  11357  NE  ARG F   6      63.819  35.955  44.398  1.00 38.20           N  
ATOM  11358  CZ  ARG F   6      64.780  36.829  44.093  1.00 37.59           C  
ATOM  11359  NH1 ARG F   6      64.484  38.111  43.965  1.00 37.69           N  
ATOM  11360  NH2 ARG F   6      66.039  36.438  43.915  1.00 36.21           N  
ATOM  11361  N   PHE F   7      62.923  36.109  49.080  1.00 39.41           N  
ATOM  11362  CA  PHE F   7      62.421  36.974  50.150  1.00 38.66           C  
ATOM  11363  C   PHE F   7      61.643  38.164  49.581  1.00 38.97           C  
ATOM  11364  O   PHE F   7      61.466  39.178  50.259  1.00 38.73           O  
ATOM  11365  CB  PHE F   7      63.586  37.487  50.999  1.00 38.86           C  
ATOM  11366  CG  PHE F   7      64.229  36.434  51.855  1.00 36.85           C  
ATOM  11367  CD1 PHE F   7      65.269  35.656  51.358  1.00 36.14           C  
ATOM  11368  CD2 PHE F   7      63.783  36.219  53.156  1.00 35.80           C  
ATOM  11369  CE1 PHE F   7      65.878  34.674  52.152  1.00 36.96           C  
ATOM  11370  CE2 PHE F   7      64.370  35.244  53.961  1.00 36.02           C  
ATOM  11371  CZ  PHE F   7      65.434  34.470  53.460  1.00 36.70           C  
ATOM  11372  N   ASP F   8      61.180  38.038  48.338  1.00 39.14           N  
ATOM  11373  CA  ASP F   8      60.444  39.121  47.680  1.00 39.83           C  
ATOM  11374  C   ASP F   8      59.276  39.589  48.560  1.00 39.92           C  
ATOM  11375  O   ASP F   8      58.479  38.774  49.032  1.00 40.21           O  
ATOM  11376  CB  ASP F   8      59.928  38.687  46.301  1.00 39.71           C  
ATOM  11377  CG  ASP F   8      61.049  38.391  45.320  1.00 40.47           C  
ATOM  11378  OD1 ASP F   8      61.373  39.272  44.490  1.00 41.89           O  
ATOM  11379  OD2 ASP F   8      61.607  37.279  45.374  1.00 41.43           O  
ATOM  11380  N   GLY F   9      59.209  40.896  48.810  1.00 39.71           N  
ATOM  11381  CA  GLY F   9      58.178  41.476  49.665  1.00 39.19           C  
ATOM  11382  C   GLY F   9      58.316  41.260  51.168  1.00 39.02           C  
ATOM  11383  O   GLY F   9      57.397  41.575  51.924  1.00 39.40           O  
ATOM  11384  N   ARG F  10      59.446  40.722  51.617  1.00 38.36           N  
ATOM  11385  CA  ARG F  10      59.670  40.512  53.059  1.00 37.80           C  
ATOM  11386  C   ARG F  10      60.563  41.610  53.636  1.00 37.23           C  
ATOM  11387  O   ARG F  10      61.650  41.850  53.137  1.00 37.53           O  
ATOM  11388  CB  ARG F  10      60.280  39.123  53.346  1.00 38.02           C  
ATOM  11389  CG  ARG F  10      59.388  37.893  53.030  1.00 37.44           C  
ATOM  11390  CD  ARG F  10      58.198  37.797  53.961  1.00 38.01           C  
ATOM  11391  NE  ARG F  10      57.399  36.572  53.754  1.00 38.44           N  
ATOM  11392  CZ  ARG F  10      56.030  36.468  54.040  1.00 39.63           C  
ATOM  11393  NH1 ARG F  10      55.366  35.327  53.812  1.00 40.12           N  
ATOM  11394  NH2 ARG F  10      55.312  37.503  54.537  1.00 38.32           N  
ATOM  11395  N   VAL F  11      60.094  42.275  54.684  1.00 36.58           N  
ATOM  11396  CA  VAL F  11      60.852  43.344  55.315  1.00 35.95           C  
ATOM  11397  C   VAL F  11      61.814  42.723  56.327  1.00 36.06           C  
ATOM  11398  O   VAL F  11      61.391  42.121  57.309  1.00 36.03           O  
ATOM  11399  CB  VAL F  11      59.936  44.360  56.023  1.00 35.94           C  
ATOM  11400  CG1 VAL F  11      60.746  45.543  56.518  1.00 35.41           C  
ATOM  11401  CG2 VAL F  11      58.791  44.821  55.093  1.00 35.66           C  
ATOM  11402  N   VAL F  12      63.107  42.880  56.077  1.00 35.69           N  
ATOM  11403  CA  VAL F  12      64.133  42.245  56.875  1.00 35.66           C  
ATOM  11404  C   VAL F  12      65.001  43.309  57.550  1.00 35.86           C  
ATOM  11405  O   VAL F  12      65.642  44.101  56.871  1.00 35.65           O  
ATOM  11406  CB  VAL F  12      65.038  41.347  55.989  1.00 35.35           C  
ATOM  11407  CG1 VAL F  12      66.238  40.850  56.772  1.00 35.98           C  
ATOM  11408  CG2 VAL F  12      64.258  40.181  55.408  1.00 34.61           C  
ATOM  11409  N   LEU F  13      65.008  43.340  58.879  1.00 36.03           N  
ATOM  11410  CA  LEU F  13      65.919  44.215  59.622  1.00 35.99           C  
ATOM  11411  C   LEU F  13      67.164  43.463  60.092  1.00 35.95           C  
ATOM  11412  O   LEU F  13      67.076  42.411  60.710  1.00 36.02           O  
ATOM  11413  CB  LEU F  13      65.211  44.862  60.819  1.00 35.85           C  
ATOM  11414  CG  LEU F  13      66.007  45.553  61.935  1.00 35.80           C  
ATOM  11415  CD1 LEU F  13      66.661  46.804  61.426  1.00 35.60           C  
ATOM  11416  CD2 LEU F  13      65.107  45.918  63.098  1.00 36.65           C  
ATOM  11417  N   VAL F  14      68.323  44.030  59.806  1.00 35.64           N  
ATOM  11418  CA  VAL F  14      69.596  43.485  60.262  1.00 35.09           C  
ATOM  11419  C   VAL F  14      70.268  44.559  61.101  1.00 35.04           C  
ATOM  11420  O   VAL F  14      70.598  45.617  60.588  1.00 34.99           O  
ATOM  11421  CB  VAL F  14      70.494  43.140  59.066  1.00 34.83           C  
ATOM  11422  CG1 VAL F  14      71.786  42.466  59.505  1.00 33.95           C  
ATOM  11423  CG2 VAL F  14      69.728  42.280  58.057  1.00 35.07           C  
ATOM  11424  N   THR F  15      70.449  44.308  62.390  1.00 35.01           N  
ATOM  11425  CA  THR F  15      71.120  45.276  63.251  1.00 35.01           C  
ATOM  11426  C   THR F  15      72.620  45.061  63.126  1.00 35.07           C  
ATOM  11427  O   THR F  15      73.058  43.949  62.873  1.00 34.74           O  
ATOM  11428  CB  THR F  15      70.649  45.190  64.720  1.00 35.21           C  
ATOM  11429  OG1 THR F  15      71.182  44.018  65.351  1.00 35.19           O  
ATOM  11430  CG2 THR F  15      69.110  45.172  64.802  1.00 33.68           C  
ATOM  11431  N   GLY F  16      73.395  46.132  63.268  1.00 35.18           N  
ATOM  11432  CA  GLY F  16      74.840  46.080  63.054  1.00 35.35           C  
ATOM  11433  C   GLY F  16      75.237  45.652  61.643  1.00 35.72           C  
ATOM  11434  O   GLY F  16      76.186  44.887  61.459  1.00 35.82           O  
ATOM  11435  N   ALA F  17      74.509  46.147  60.646  1.00 35.71           N  
ATOM  11436  CA  ALA F  17      74.675  45.686  59.267  1.00 35.67           C  
ATOM  11437  C   ALA F  17      75.726  46.460  58.451  1.00 35.72           C  
ATOM  11438  O   ALA F  17      75.876  46.237  57.244  1.00 36.00           O  
ATOM  11439  CB  ALA F  17      73.319  45.668  58.558  1.00 35.77           C  
ATOM  11440  N   GLY F  18      76.476  47.334  59.122  1.00 35.62           N  
ATOM  11441  CA  GLY F  18      77.522  48.120  58.483  1.00 35.33           C  
ATOM  11442  C   GLY F  18      78.822  47.392  58.195  1.00 35.38           C  
ATOM  11443  O   GLY F  18      79.627  47.851  57.396  1.00 35.42           O  
ATOM  11444  N   ALA F  19      79.060  46.267  58.858  1.00 35.47           N  
ATOM  11445  CA  ALA F  19      80.314  45.511  58.632  1.00 35.22           C  
ATOM  11446  C   ALA F  19      80.160  44.044  59.008  1.00 35.13           C  
ATOM  11447  O   ALA F  19      79.101  43.618  59.497  1.00 34.98           O  
ATOM  11448  CB  ALA F  19      81.494  46.140  59.379  1.00 35.02           C  
ATOM  11449  N   GLY F  20      81.209  43.271  58.738  1.00 35.01           N  
ATOM  11450  CA  GLY F  20      81.291  41.870  59.164  1.00 35.30           C  
ATOM  11451  C   GLY F  20      80.089  41.021  58.807  1.00 35.57           C  
ATOM  11452  O   GLY F  20      79.587  41.069  57.687  1.00 36.48           O  
ATOM  11453  N   LEU F  21      79.612  40.254  59.776  1.00 35.81           N  
ATOM  11454  CA  LEU F  21      78.488  39.367  59.569  1.00 35.38           C  
ATOM  11455  C   LEU F  21      77.190  40.078  59.150  1.00 35.35           C  
ATOM  11456  O   LEU F  21      76.496  39.622  58.242  1.00 35.36           O  
ATOM  11457  CB  LEU F  21      78.273  38.548  60.829  1.00 36.03           C  
ATOM  11458  CG  LEU F  21      79.330  37.495  61.143  1.00 35.55           C  
ATOM  11459  CD1 LEU F  21      79.214  37.122  62.618  1.00 34.28           C  
ATOM  11460  CD2 LEU F  21      79.091  36.271  60.250  1.00 34.14           C  
ATOM  11461  N   GLY F  22      76.849  41.180  59.808  1.00 35.29           N  
ATOM  11462  CA  GLY F  22      75.581  41.876  59.508  1.00 35.40           C  
ATOM  11463  C   GLY F  22      75.538  42.353  58.064  1.00 35.44           C  
ATOM  11464  O   GLY F  22      74.500  42.252  57.394  1.00 35.16           O  
ATOM  11465  N   ARG F  23      76.679  42.862  57.587  1.00 35.37           N  
ATOM  11466  CA  ARG F  23      76.824  43.326  56.198  0.50 35.65           C  
ATOM  11468  C   ARG F  23      76.546  42.177  55.228  1.00 35.99           C  
ATOM  11469  O   ARG F  23      75.801  42.336  54.254  1.00 36.46           O  
ATOM  11470  CB  ARG F  23      78.233  43.890  55.957  0.50 35.44           C  
ATOM  11472  CG  ARG F  23      78.546  44.320  54.512  0.50 35.37           C  
ATOM  11474  CD  ARG F  23      80.059  44.469  54.299  0.50 34.84           C  
ATOM  11476  NE  ARG F  23      80.416  45.065  53.012  0.50 33.77           N  
ATOM  11478  CZ  ARG F  23      80.668  44.385  51.891  0.50 32.89           C  
ATOM  11480  NH1 ARG F  23      80.587  43.062  51.872  0.50 32.36           N  
ATOM  11482  NH2 ARG F  23      80.986  45.035  50.775  0.50 30.46           N  
ATOM  11484  N   ALA F  24      77.179  41.032  55.495  1.00 35.57           N  
ATOM  11485  CA  ALA F  24      76.968  39.834  54.692  1.00 35.74           C  
ATOM  11486  C   ALA F  24      75.481  39.431  54.711  1.00 35.93           C  
ATOM  11487  O   ALA F  24      74.930  39.077  53.679  1.00 36.39           O  
ATOM  11488  CB  ALA F  24      77.842  38.685  55.181  1.00 34.99           C  
ATOM  11489  N   TYR F  25      74.818  39.492  55.863  1.00 36.22           N  
ATOM  11490  CA  TYR F  25      73.383  39.156  55.890  1.00 36.50           C  
ATOM  11491  C   TYR F  25      72.578  40.086  55.012  1.00 36.28           C  
ATOM  11492  O   TYR F  25      71.758  39.642  54.216  1.00 36.37           O  
ATOM  11493  CB  TYR F  25      72.772  39.168  57.305  1.00 36.86           C  
ATOM  11494  CG  TYR F  25      73.514  38.363  58.339  1.00 36.80           C  
ATOM  11495  CD1 TYR F  25      74.415  37.353  57.967  1.00 39.04           C  
ATOM  11496  CD2 TYR F  25      73.332  38.618  59.693  1.00 36.22           C  
ATOM  11497  CE1 TYR F  25      75.112  36.624  58.934  1.00 38.35           C  
ATOM  11498  CE2 TYR F  25      74.007  37.894  60.660  1.00 36.07           C  
ATOM  11499  CZ  TYR F  25      74.888  36.899  60.276  1.00 37.82           C  
ATOM  11500  OH  TYR F  25      75.552  36.174  61.224  1.00 37.86           O  
ATOM  11501  N   ALA F  26      72.831  41.381  55.169  1.00 36.14           N  
ATOM  11502  CA  ALA F  26      72.080  42.432  54.497  1.00 35.92           C  
ATOM  11503  C   ALA F  26      72.153  42.259  52.984  1.00 36.03           C  
ATOM  11504  O   ALA F  26      71.126  42.295  52.291  1.00 35.98           O  
ATOM  11505  CB  ALA F  26      72.629  43.798  54.903  1.00 35.62           C  
ATOM  11506  N   LEU F  27      73.376  42.057  52.489  1.00 35.90           N  
ATOM  11507  CA  LEU F  27      73.615  41.866  51.064  1.00 35.86           C  
ATOM  11508  C   LEU F  27      72.959  40.582  50.562  1.00 35.82           C  
ATOM  11509  O   LEU F  27      72.288  40.588  49.543  1.00 35.61           O  
ATOM  11510  CB  LEU F  27      75.121  41.900  50.774  1.00 35.88           C  
ATOM  11511  CG  LEU F  27      75.732  43.307  50.635  1.00 36.48           C  
ATOM  11512  CD1 LEU F  27      77.246  43.341  50.874  1.00 37.90           C  
ATOM  11513  CD2 LEU F  27      75.437  43.902  49.255  1.00 36.97           C  
ATOM  11514  N   ALA F  28      73.131  39.492  51.311  1.00 35.66           N  
ATOM  11515  CA  ALA F  28      72.531  38.205  50.961  1.00 35.78           C  
ATOM  11516  C   ALA F  28      70.983  38.250  50.878  1.00 35.71           C  
ATOM  11517  O   ALA F  28      70.411  37.772  49.893  1.00 35.79           O  
ATOM  11518  CB  ALA F  28      73.014  37.129  51.924  1.00 35.14           C  
ATOM  11519  N   PHE F  29      70.330  38.830  51.891  1.00 35.69           N  
ATOM  11520  CA  PHE F  29      68.871  39.082  51.876  1.00 35.78           C  
ATOM  11521  C   PHE F  29      68.395  39.901  50.678  1.00 35.55           C  
ATOM  11522  O   PHE F  29      67.431  39.508  50.011  1.00 35.74           O  
ATOM  11523  CB  PHE F  29      68.427  39.820  53.139  1.00 35.87           C  
ATOM  11524  CG  PHE F  29      68.294  38.948  54.338  1.00 36.72           C  
ATOM  11525  CD1 PHE F  29      69.199  39.051  55.387  1.00 35.83           C  
ATOM  11526  CD2 PHE F  29      67.254  38.026  54.432  1.00 36.43           C  
ATOM  11527  CE1 PHE F  29      69.070  38.237  56.522  1.00 35.60           C  
ATOM  11528  CE2 PHE F  29      67.128  37.205  55.554  1.00 36.24           C  
ATOM  11529  CZ  PHE F  29      68.042  37.310  56.595  1.00 35.61           C  
ATOM  11530  N   ALA F  30      69.053  41.040  50.435  1.00 35.32           N  
ATOM  11531  CA  ALA F  30      68.643  42.001  49.401  1.00 35.74           C  
ATOM  11532  C   ALA F  30      68.750  41.421  47.995  1.00 36.04           C  
ATOM  11533  O   ALA F  30      67.936  41.718  47.109  1.00 35.65           O  
ATOM  11534  CB  ALA F  30      69.465  43.266  49.512  1.00 35.24           C  
ATOM  11535  N   GLU F  31      69.774  40.592  47.806  1.00 36.69           N  
ATOM  11536  CA  GLU F  31      69.971  39.857  46.561  1.00 37.37           C  
ATOM  11537  C   GLU F  31      68.815  38.901  46.271  1.00 36.88           C  
ATOM  11538  O   GLU F  31      68.570  38.558  45.122  1.00 37.07           O  
ATOM  11539  CB  GLU F  31      71.266  39.057  46.642  1.00 37.65           C  
ATOM  11540  CG  GLU F  31      71.700  38.463  45.315  1.00 40.16           C  
ATOM  11541  CD  GLU F  31      72.995  37.700  45.449  1.00 42.15           C  
ATOM  11542  OE1 GLU F  31      74.059  38.305  45.209  1.00 44.09           O  
ATOM  11543  OE2 GLU F  31      72.950  36.510  45.827  1.00 44.03           O  
ATOM  11544  N   ARG F  32      68.116  38.450  47.306  1.00 36.77           N  
ATOM  11545  CA  ARG F  32      66.962  37.587  47.068  1.00 36.74           C  
ATOM  11546  C   ARG F  32      65.619  38.294  47.257  1.00 36.63           C  
ATOM  11547  O   ARG F  32      64.590  37.658  47.509  1.00 36.53           O  
ATOM  11548  CB  ARG F  32      67.091  36.262  47.824  1.00 37.18           C  
ATOM  11549  CG  ARG F  32      68.204  35.374  47.232  1.00 37.30           C  
ATOM  11550  CD  ARG F  32      68.626  34.341  48.203  1.00 38.09           C  
ATOM  11551  NE  ARG F  32      69.794  33.552  47.799  1.00 38.55           N  
ATOM  11552  CZ  ARG F  32      69.737  32.267  47.461  1.00 37.52           C  
ATOM  11553  NH1 ARG F  32      68.573  31.628  47.445  1.00 37.28           N  
ATOM  11554  NH2 ARG F  32      70.840  31.615  47.154  1.00 36.31           N  
ATOM  11555  N   GLY F  33      65.643  39.615  47.082  1.00 36.54           N  
ATOM  11556  CA  GLY F  33      64.430  40.417  46.935  1.00 36.49           C  
ATOM  11557  C   GLY F  33      63.865  41.003  48.212  1.00 36.44           C  
ATOM  11558  O   GLY F  33      62.787  41.565  48.203  1.00 36.78           O  
ATOM  11559  N   ALA F  34      64.598  40.876  49.311  1.00 36.47           N  
ATOM  11560  CA  ALA F  34      64.163  41.414  50.599  1.00 36.49           C  
ATOM  11561  C   ALA F  34      64.218  42.938  50.621  1.00 36.69           C  
ATOM  11562  O   ALA F  34      65.143  43.532  50.082  1.00 36.92           O  
ATOM  11563  CB  ALA F  34      65.032  40.855  51.714  1.00 36.20           C  
ATOM  11564  N   LEU F  35      63.220  43.555  51.250  1.00 36.77           N  
ATOM  11565  CA  LEU F  35      63.246  44.973  51.562  1.00 36.77           C  
ATOM  11566  C   LEU F  35      64.030  45.132  52.869  1.00 36.69           C  
ATOM  11567  O   LEU F  35      63.528  44.801  53.944  1.00 36.91           O  
ATOM  11568  CB  LEU F  35      61.804  45.475  51.691  1.00 36.78           C  
ATOM  11569  CG  LEU F  35      60.803  44.841  50.703  1.00 37.28           C  
ATOM  11570  CD1 LEU F  35      59.361  45.154  51.085  1.00 37.87           C  
ATOM  11571  CD2 LEU F  35      61.056  45.234  49.244  1.00 37.65           C  
ATOM  11572  N   VAL F  36      65.269  45.606  52.776  1.00 36.28           N  
ATOM  11573  CA  VAL F  36      66.214  45.518  53.899  1.00 35.87           C  
ATOM  11574  C   VAL F  36      66.327  46.824  54.685  1.00 35.78           C  
ATOM  11575  O   VAL F  36      66.501  47.892  54.095  1.00 36.01           O  
ATOM  11576  CB  VAL F  36      67.644  45.073  53.430  1.00 35.72           C  
ATOM  11577  CG1 VAL F  36      68.524  44.758  54.617  1.00 35.92           C  
ATOM  11578  CG2 VAL F  36      67.569  43.863  52.512  1.00 34.94           C  
ATOM  11579  N   VAL F  37      66.210  46.743  56.007  1.00 35.48           N  
ATOM  11580  CA  VAL F  37      66.599  47.862  56.856  1.00 35.49           C  
ATOM  11581  C   VAL F  37      68.020  47.617  57.368  1.00 35.42           C  
ATOM  11582  O   VAL F  37      68.266  46.679  58.123  1.00 35.27           O  
ATOM  11583  CB  VAL F  37      65.631  48.106  58.034  1.00 35.50           C  
ATOM  11584  CG1 VAL F  37      66.011  49.402  58.763  1.00 34.99           C  
ATOM  11585  CG2 VAL F  37      64.152  48.166  57.552  1.00 35.19           C  
ATOM  11586  N   VAL F  38      68.950  48.459  56.924  1.00 35.61           N  
ATOM  11587  CA  VAL F  38      70.356  48.366  57.317  1.00 35.62           C  
ATOM  11588  C   VAL F  38      70.597  49.282  58.528  1.00 35.65           C  
ATOM  11589  O   VAL F  38      70.682  50.521  58.405  1.00 35.49           O  
ATOM  11590  CB  VAL F  38      71.318  48.673  56.113  1.00 35.83           C  
ATOM  11591  CG1 VAL F  38      72.766  48.868  56.568  1.00 35.73           C  
ATOM  11592  CG2 VAL F  38      71.234  47.561  55.065  1.00 35.70           C  
ATOM  11593  N   ASN F  39      70.659  48.654  59.700  1.00 35.70           N  
ATOM  11594  CA  ASN F  39      70.902  49.368  60.939  1.00 35.76           C  
ATOM  11595  C   ASN F  39      72.375  49.348  61.302  1.00 35.94           C  
ATOM  11596  O   ASN F  39      73.033  48.315  61.213  1.00 35.91           O  
ATOM  11597  CB  ASN F  39      70.061  48.789  62.084  1.00 35.27           C  
ATOM  11598  CG  ASN F  39      70.497  49.310  63.442  1.00 34.90           C  
ATOM  11599  OD1 ASN F  39      71.178  48.614  64.185  1.00 36.41           O  
ATOM  11600  ND2 ASN F  39      70.154  50.552  63.748  1.00 34.04           N  
ATOM  11601  N   ASP F  40      72.889  50.512  61.683  1.00 36.19           N  
ATOM  11602  CA  ASP F  40      74.207  50.599  62.277  1.00 36.43           C  
ATOM  11603  C   ASP F  40      74.434  51.928  62.954  1.00 36.59           C  
ATOM  11604  O   ASP F  40      74.171  52.985  62.376  1.00 36.25           O  
ATOM  11605  CB  ASP F  40      75.300  50.350  61.250  1.00 36.49           C  
ATOM  11606  CG  ASP F  40      76.512  49.737  61.873  1.00 36.84           C  
ATOM  11607  OD1 ASP F  40      77.367  50.482  62.397  1.00 37.74           O  
ATOM  11608  OD2 ASP F  40      76.593  48.500  61.860  1.00 37.52           O  
ATOM  11609  N   LEU F  41      74.907  51.861  64.196  1.00 36.84           N  
ATOM  11610  CA  LEU F  41      75.269  53.051  64.955  1.00 36.77           C  
ATOM  11611  C   LEU F  41      76.489  53.745  64.357  1.00 36.84           C  
ATOM  11612  O   LEU F  41      76.634  54.958  64.479  1.00 36.91           O  
ATOM  11613  CB  LEU F  41      75.509  52.705  66.430  1.00 36.71           C  
ATOM  11614  CG  LEU F  41      75.931  53.851  67.361  1.00 36.78           C  
ATOM  11615  CD1 LEU F  41      74.737  54.721  67.772  1.00 36.32           C  
ATOM  11616  CD2 LEU F  41      76.662  53.321  68.582  1.00 36.42           C  
ATOM  11617  N   GLY F  42      77.365  52.969  63.720  1.00 36.96           N  
ATOM  11618  CA  GLY F  42      78.529  53.513  63.029  1.00 37.60           C  
ATOM  11619  C   GLY F  42      79.725  53.857  63.901  1.00 37.92           C  
ATOM  11620  O   GLY F  42      80.575  54.648  63.497  1.00 37.89           O  
ATOM  11621  N   GLY F  43      79.801  53.264  65.088  1.00 38.39           N  
ATOM  11622  CA  GLY F  43      80.941  53.451  65.991  1.00 38.98           C  
ATOM  11623  C   GLY F  43      81.966  52.335  65.887  1.00 39.53           C  
ATOM  11624  O   GLY F  43      81.859  51.464  65.012  1.00 39.63           O  
ATOM  11625  N   ASP F  44      82.962  52.343  66.772  1.00 39.88           N  
ATOM  11626  CA  ASP F  44      83.994  51.296  66.738  1.00 40.28           C  
ATOM  11627  C   ASP F  44      83.564  50.014  67.472  1.00 40.27           C  
ATOM  11628  O   ASP F  44      82.463  49.951  68.047  1.00 40.21           O  
ATOM  11629  CB  ASP F  44      85.363  51.819  67.209  1.00 40.20           C  
ATOM  11630  CG  ASP F  44      85.385  52.185  68.684  1.00 40.83           C  
ATOM  11631  OD1 ASP F  44      84.613  51.598  69.480  1.00 41.19           O  
ATOM  11632  OD2 ASP F  44      86.186  53.072  69.053  1.00 41.24           O  
ATOM  11633  N   PHE F  45      84.426  48.998  67.449  1.00 40.43           N  
ATOM  11634  CA  PHE F  45      84.062  47.688  67.980  1.00 40.79           C  
ATOM  11635  C   PHE F  45      84.090  47.596  69.499  1.00 40.54           C  
ATOM  11636  O   PHE F  45      83.751  46.559  70.060  1.00 40.49           O  
ATOM  11637  CB  PHE F  45      84.898  46.569  67.337  1.00 41.23           C  
ATOM  11638  CG  PHE F  45      86.262  46.374  67.956  1.00 42.61           C  
ATOM  11639  CD1 PHE F  45      86.439  45.499  69.035  1.00 44.04           C  
ATOM  11640  CD2 PHE F  45      87.374  47.019  67.429  1.00 43.41           C  
ATOM  11641  CE1 PHE F  45      87.710  45.298  69.598  1.00 44.70           C  
ATOM  11642  CE2 PHE F  45      88.651  46.828  67.983  1.00 44.76           C  
ATOM  11643  CZ  PHE F  45      88.817  45.969  69.069  1.00 43.96           C  
ATOM  11644  N   LYS F  46      84.501  48.676  70.156  1.00 40.53           N  
ATOM  11645  CA  LYS F  46      84.518  48.729  71.615  1.00 40.68           C  
ATOM  11646  C   LYS F  46      83.404  49.610  72.168  1.00 40.53           C  
ATOM  11647  O   LYS F  46      83.396  49.915  73.360  1.00 40.50           O  
ATOM  11648  CB  LYS F  46      85.879  49.196  72.120  1.00 40.60           C  
ATOM  11649  CG  LYS F  46      87.031  48.274  71.742  1.00 41.77           C  
ATOM  11650  N   GLY F  47      82.474  50.021  71.304  1.00 40.47           N  
ATOM  11651  CA  GLY F  47      81.324  50.844  71.712  1.00 40.56           C  
ATOM  11652  C   GLY F  47      81.579  52.342  71.842  1.00 40.73           C  
ATOM  11653  O   GLY F  47      80.893  53.028  72.603  1.00 40.86           O  
ATOM  11654  N   VAL F  48      82.555  52.853  71.095  1.00 40.84           N  
ATOM  11655  CA  VAL F  48      82.868  54.284  71.089  1.00 40.88           C  
ATOM  11656  C   VAL F  48      82.570  54.887  69.713  1.00 40.98           C  
ATOM  11657  O   VAL F  48      83.040  54.384  68.692  1.00 41.05           O  
ATOM  11658  CB  VAL F  48      84.346  54.555  71.499  1.00 40.76           C  
ATOM  11659  CG1 VAL F  48      84.672  56.065  71.472  1.00 41.27           C  
ATOM  11660  CG2 VAL F  48      84.639  53.978  72.880  1.00 40.51           C  
ATOM  11661  N   GLY F  49      81.771  55.951  69.692  1.00 41.10           N  
ATOM  11662  CA  GLY F  49      81.504  56.682  68.457  1.00 41.21           C  
ATOM  11663  C   GLY F  49      80.169  56.395  67.797  1.00 41.43           C  
ATOM  11664  O   GLY F  49      79.409  55.521  68.233  1.00 41.23           O  
ATOM  11665  N   LYS F  50      79.907  57.137  66.725  1.00 41.40           N  
ATOM  11666  CA  LYS F  50      78.640  57.116  66.000  1.00 41.66           C  
ATOM  11667  C   LYS F  50      78.846  57.802  64.652  1.00 41.62           C  
ATOM  11668  O   LYS F  50      79.627  58.740  64.551  1.00 41.49           O  
ATOM  11669  CB  LYS F  50      77.553  57.864  66.783  1.00 41.61           C  
ATOM  11670  N   GLY F  51      78.136  57.333  63.631  1.00 41.62           N  
ATOM  11671  CA  GLY F  51      78.237  57.884  62.282  1.00 41.66           C  
ATOM  11672  C   GLY F  51      77.242  57.267  61.313  1.00 41.79           C  
ATOM  11673  O   GLY F  51      76.811  56.123  61.491  1.00 42.17           O  
ATOM  11674  N   SER F  52      76.885  58.036  60.291  1.00 41.91           N  
ATOM  11675  CA  SER F  52      75.954  57.632  59.239  1.00 41.96           C  
ATOM  11676  C   SER F  52      76.620  56.793  58.164  1.00 41.83           C  
ATOM  11677  O   SER F  52      75.941  56.026  57.473  1.00 41.76           O  
ATOM  11678  CB  SER F  52      75.377  58.878  58.552  1.00 41.95           C  
ATOM  11679  OG  SER F  52      74.246  59.376  59.238  1.00 43.05           O  
ATOM  11680  N   LEU F  53      77.936  56.975  58.007  1.00 41.62           N  
ATOM  11681  CA  LEU F  53      78.698  56.383  56.910  1.00 41.44           C  
ATOM  11682  C   LEU F  53      78.570  54.861  56.844  1.00 41.17           C  
ATOM  11683  O   LEU F  53      78.331  54.306  55.772  1.00 41.34           O  
ATOM  11684  CB  LEU F  53      80.173  56.789  57.001  1.00 41.36           C  
ATOM  11685  N   ALA F  54      78.712  54.196  57.988  1.00 40.58           N  
ATOM  11686  CA  ALA F  54      78.691  52.735  58.033  1.00 40.08           C  
ATOM  11687  C   ALA F  54      77.418  52.120  57.421  1.00 39.87           C  
ATOM  11688  O   ALA F  54      77.508  51.245  56.554  1.00 39.52           O  
ATOM  11689  CB  ALA F  54      78.905  52.264  59.446  1.00 40.21           C  
ATOM  11690  N   ALA F  55      76.250  52.594  57.855  1.00 39.37           N  
ATOM  11691  CA  ALA F  55      74.971  52.148  57.291  1.00 39.27           C  
ATOM  11692  C   ALA F  55      74.765  52.584  55.836  1.00 39.13           C  
ATOM  11693  O   ALA F  55      74.302  51.792  55.007  1.00 38.88           O  
ATOM  11694  CB  ALA F  55      73.813  52.627  58.162  1.00 39.27           C  
ATOM  11695  N   ASP F  56      75.113  53.839  55.536  1.00 38.96           N  
ATOM  11696  CA  ASP F  56      74.964  54.403  54.187  1.00 38.90           C  
ATOM  11697  C   ASP F  56      75.749  53.666  53.097  1.00 38.76           C  
ATOM  11698  O   ASP F  56      75.219  53.442  52.011  1.00 38.90           O  
ATOM  11699  CB  ASP F  56      75.319  55.891  54.171  1.00 38.76           C  
ATOM  11700  CG  ASP F  56      74.104  56.786  54.326  1.00 39.06           C  
ATOM  11701  OD1 ASP F  56      73.029  56.295  54.747  1.00 37.76           O  
ATOM  11702  OD2 ASP F  56      74.237  57.996  54.018  1.00 39.32           O  
ATOM  11703  N   LYS F  57      76.999  53.298  53.379  1.00 38.34           N  
ATOM  11704  CA  LYS F  57      77.801  52.523  52.433  1.00 38.26           C  
ATOM  11705  C   LYS F  57      77.109  51.229  52.027  1.00 37.61           C  
ATOM  11706  O   LYS F  57      77.117  50.872  50.857  1.00 37.60           O  
ATOM  11707  CB  LYS F  57      79.184  52.186  53.003  1.00 38.25           C  
ATOM  11708  CG  LYS F  57      80.162  53.331  53.040  1.00 39.31           C  
ATOM  11709  CD  LYS F  57      81.523  52.834  53.511  1.00 40.49           C  
ATOM  11710  N   VAL F  58      76.517  50.531  52.995  1.00 37.17           N  
ATOM  11711  CA  VAL F  58      75.892  49.224  52.741  1.00 36.62           C  
ATOM  11712  C   VAL F  58      74.535  49.356  52.011  1.00 36.82           C  
ATOM  11713  O   VAL F  58      74.243  48.571  51.105  1.00 36.88           O  
ATOM  11714  CB  VAL F  58      75.808  48.372  54.037  1.00 36.61           C  
ATOM  11715  CG1 VAL F  58      75.197  47.002  53.765  1.00 35.86           C  
ATOM  11716  CG2 VAL F  58      77.182  48.196  54.620  1.00 36.12           C  
ATOM  11717  N   VAL F  59      73.726  50.350  52.377  1.00 36.86           N  
ATOM  11718  CA  VAL F  59      72.525  50.657  51.588  1.00 37.52           C  
ATOM  11719  C   VAL F  59      72.884  51.005  50.126  1.00 38.04           C  
ATOM  11720  O   VAL F  59      72.207  50.553  49.199  1.00 37.88           O  
ATOM  11721  CB  VAL F  59      71.625  51.757  52.231  1.00 37.54           C  
ATOM  11722  CG1 VAL F  59      70.499  52.172  51.282  1.00 37.34           C  
ATOM  11723  CG2 VAL F  59      71.028  51.270  53.535  1.00 37.17           C  
ATOM  11724  N   GLU F  60      73.951  51.773  49.923  1.00 38.72           N  
ATOM  11725  CA  GLU F  60      74.399  52.110  48.562  1.00 39.45           C  
ATOM  11726  C   GLU F  60      74.887  50.893  47.766  1.00 39.41           C  
ATOM  11727  O   GLU F  60      74.544  50.758  46.591  1.00 39.44           O  
ATOM  11728  CB  GLU F  60      75.422  53.240  48.587  1.00 39.49           C  
ATOM  11729  CG  GLU F  60      74.770  54.594  48.863  1.00 40.69           C  
ATOM  11730  CD  GLU F  60      75.758  55.689  49.235  1.00 42.07           C  
ATOM  11731  OE1 GLU F  60      76.976  55.408  49.354  1.00 42.49           O  
ATOM  11732  OE2 GLU F  60      75.301  56.840  49.410  1.00 43.23           O  
ATOM  11733  N   GLU F  61      75.643  50.000  48.409  1.00 39.53           N  
ATOM  11734  CA  GLU F  61      76.040  48.731  47.778  1.00 39.88           C  
ATOM  11735  C   GLU F  61      74.826  47.891  47.364  1.00 39.39           C  
ATOM  11736  O   GLU F  61      74.797  47.363  46.251  1.00 39.57           O  
ATOM  11737  CB  GLU F  61      76.960  47.912  48.686  1.00 39.66           C  
ATOM  11738  CG  GLU F  61      78.211  48.656  49.108  1.00 40.72           C  
ATOM  11739  CD  GLU F  61      79.189  47.803  49.894  1.00 41.10           C  
ATOM  11740  OE1 GLU F  61      78.797  47.208  50.938  1.00 39.85           O  
ATOM  11741  OE2 GLU F  61      80.370  47.757  49.462  1.00 42.61           O  
ATOM  11742  N   ILE F  62      73.833  47.773  48.251  1.00 38.68           N  
ATOM  11743  CA  ILE F  62      72.592  47.044  47.939  1.00 38.17           C  
ATOM  11744  C   ILE F  62      71.848  47.625  46.735  1.00 38.23           C  
ATOM  11745  O   ILE F  62      71.420  46.884  45.841  1.00 38.12           O  
ATOM  11746  CB  ILE F  62      71.630  46.953  49.163  1.00 38.18           C  
ATOM  11747  CG1 ILE F  62      72.143  45.893  50.158  1.00 37.57           C  
ATOM  11748  CG2 ILE F  62      70.187  46.636  48.723  1.00 36.81           C  
ATOM  11749  CD1 ILE F  62      71.622  46.059  51.569  1.00 36.66           C  
ATOM  11750  N   ARG F  63      71.699  48.949  46.721  1.00 38.20           N  
ATOM  11751  CA  ARG F  63      71.044  49.663  45.623  1.00 38.19           C  
ATOM  11752  C   ARG F  63      71.790  49.526  44.295  1.00 38.56           C  
ATOM  11753  O   ARG F  63      71.166  49.327  43.252  1.00 38.41           O  
ATOM  11754  CB  ARG F  63      70.853  51.140  45.980  1.00 38.16           C  
ATOM  11755  CG  ARG F  63      69.572  51.425  46.761  1.00 37.71           C  
ATOM  11756  CD  ARG F  63      69.631  52.778  47.502  1.00 36.25           C  
ATOM  11757  NE  ARG F  63      68.428  52.908  48.378  1.00 36.41           N  
ATOM  11758  CZ  ARG F  63      68.229  53.998  49.172  1.00 35.75           C  
ATOM  11759  NH1 ARG F  63      69.159  55.105  49.245  1.00 35.01           N  
ATOM  11760  NH2 ARG F  63      67.090  53.977  49.925  1.00 36.07           N  
ATOM  11761  N   ARG F  64      73.120  49.624  44.341  1.00 39.02           N  
ATOM  11762  CA  ARG F  64      73.954  49.414  43.157  1.00 39.76           C  
ATOM  11763  C   ARG F  64      73.787  48.011  42.572  1.00 39.73           C  
ATOM  11764  O   ARG F  64      73.843  47.841  41.349  1.00 39.63           O  
ATOM  11765  CB  ARG F  64      75.433  49.666  43.463  1.00 40.02           C  
ATOM  11766  CG  ARG F  64      75.940  51.047  43.084  1.00 41.69           C  
ATOM  11767  CD  ARG F  64      77.473  51.032  42.898  1.00 44.34           C  
ATOM  11768  NE  ARG F  64      78.134  50.253  43.943  1.00 46.10           N  
ATOM  11769  CZ  ARG F  64      78.415  50.707  45.163  1.00 47.21           C  
ATOM  11770  NH1 ARG F  64      78.111  51.955  45.512  1.00 47.02           N  
ATOM  11771  NH2 ARG F  64      78.999  49.902  46.042  1.00 47.61           N  
ATOM  11772  N   ARG F  65      73.590  47.019  43.443  1.00 39.81           N  
ATOM  11773  CA  ARG F  65      73.370  45.635  43.011  1.00 40.07           C  
ATOM  11774  C   ARG F  65      71.916  45.362  42.659  1.00 39.93           C  
ATOM  11775  O   ARG F  65      71.550  44.230  42.362  1.00 39.95           O  
ATOM  11776  CB  ARG F  65      73.879  44.644  44.052  1.00 40.41           C  
ATOM  11777  CG  ARG F  65      75.400  44.595  44.107  1.00 42.11           C  
ATOM  11778  CD  ARG F  65      75.894  43.666  45.178  1.00 44.46           C  
ATOM  11779  NE  ARG F  65      77.324  43.860  45.407  1.00 47.61           N  
ATOM  11780  CZ  ARG F  65      78.080  43.100  46.199  1.00 48.52           C  
ATOM  11781  NH1 ARG F  65      77.556  42.068  46.849  1.00 48.77           N  
ATOM  11782  NH2 ARG F  65      79.372  43.370  46.327  1.00 49.31           N  
ATOM  11783  N   GLY F  66      71.097  46.411  42.682  1.00 39.78           N  
ATOM  11784  CA  GLY F  66      69.709  46.322  42.237  1.00 39.76           C  
ATOM  11785  C   GLY F  66      68.718  45.847  43.285  1.00 39.72           C  
ATOM  11786  O   GLY F  66      67.607  45.437  42.947  1.00 39.94           O  
ATOM  11787  N   GLY F  67      69.105  45.909  44.556  1.00 39.43           N  
ATOM  11788  CA  GLY F  67      68.187  45.578  45.648  1.00 39.38           C  
ATOM  11789  C   GLY F  67      67.523  46.803  46.247  1.00 39.54           C  
ATOM  11790  O   GLY F  67      67.782  47.938  45.823  1.00 39.44           O  
ATOM  11791  N   LYS F  68      66.661  46.574  47.230  1.00 39.57           N  
ATOM  11792  CA  LYS F  68      65.971  47.656  47.931  1.00 39.80           C  
ATOM  11793  C   LYS F  68      66.398  47.689  49.393  1.00 39.69           C  
ATOM  11794  O   LYS F  68      66.399  46.654  50.070  1.00 39.32           O  
ATOM  11795  CB  LYS F  68      64.444  47.497  47.803  1.00 39.85           C  
ATOM  11796  CG  LYS F  68      63.793  48.392  46.760  1.00 39.97           C  
ATOM  11797  CD  LYS F  68      64.429  48.269  45.373  1.00 41.40           C  
ATOM  11798  N   ALA F  69      66.787  48.873  49.868  1.00 39.44           N  
ATOM  11799  CA  ALA F  69      67.237  49.044  51.253  1.00 39.35           C  
ATOM  11800  C   ALA F  69      67.071  50.479  51.748  1.00 39.25           C  
ATOM  11801  O   ALA F  69      67.029  51.425  50.950  1.00 39.20           O  
ATOM  11802  CB  ALA F  69      68.679  48.596  51.407  1.00 39.26           C  
ATOM  11803  N   VAL F  70      66.970  50.630  53.066  1.00 39.03           N  
ATOM  11804  CA  VAL F  70      66.941  51.942  53.709  1.00 38.78           C  
ATOM  11805  C   VAL F  70      67.843  51.862  54.937  1.00 38.48           C  
ATOM  11806  O   VAL F  70      68.011  50.787  55.504  1.00 38.49           O  
ATOM  11807  CB  VAL F  70      65.473  52.377  54.072  1.00 38.83           C  
ATOM  11808  CG1 VAL F  70      64.909  51.531  55.201  1.00 38.34           C  
ATOM  11809  CG2 VAL F  70      65.390  53.862  54.422  1.00 38.59           C  
ATOM  11810  N   ALA F  71      68.444  52.982  55.328  1.00 38.18           N  
ATOM  11811  CA  ALA F  71      69.356  52.997  56.473  1.00 37.99           C  
ATOM  11812  C   ALA F  71      68.675  53.414  57.772  1.00 37.89           C  
ATOM  11813  O   ALA F  71      67.724  54.196  57.766  1.00 38.05           O  
ATOM  11814  CB  ALA F  71      70.560  53.884  56.196  1.00 38.03           C  
ATOM  11815  N   ASN F  72      69.165  52.866  58.880  1.00 37.80           N  
ATOM  11816  CA  ASN F  72      68.809  53.331  60.217  1.00 37.74           C  
ATOM  11817  C   ASN F  72      70.083  53.567  61.020  1.00 37.75           C  
ATOM  11818  O   ASN F  72      71.003  52.750  60.980  1.00 37.98           O  
ATOM  11819  CB  ASN F  72      67.908  52.320  60.922  1.00 37.65           C  
ATOM  11820  CG  ASN F  72      67.663  52.671  62.367  1.00 37.38           C  
ATOM  11821  OD1 ASN F  72      68.232  52.050  63.264  1.00 37.86           O  
ATOM  11822  ND2 ASN F  72      66.824  53.675  62.609  1.00 36.43           N  
ATOM  11823  N   TYR F  73      70.139  54.681  61.741  1.00 37.87           N  
ATOM  11824  CA  TYR F  73      71.379  55.103  62.392  1.00 38.43           C  
ATOM  11825  C   TYR F  73      71.336  55.066  63.922  1.00 38.81           C  
ATOM  11826  O   TYR F  73      72.300  55.467  64.584  1.00 38.75           O  
ATOM  11827  CB  TYR F  73      71.773  56.499  61.909  1.00 38.46           C  
ATOM  11828  CG  TYR F  73      71.597  56.718  60.416  1.00 38.60           C  
ATOM  11829  CD1 TYR F  73      70.606  57.578  59.934  1.00 38.46           C  
ATOM  11830  CD2 TYR F  73      72.429  56.073  59.486  1.00 38.07           C  
ATOM  11831  CE1 TYR F  73      70.446  57.796  58.565  1.00 38.72           C  
ATOM  11832  CE2 TYR F  73      72.275  56.278  58.114  1.00 37.63           C  
ATOM  11833  CZ  TYR F  73      71.282  57.139  57.661  1.00 38.53           C  
ATOM  11834  OH  TYR F  73      71.113  57.354  56.308  1.00 38.43           O  
ATOM  11835  N   ASP F  74      70.227  54.570  64.470  1.00 39.32           N  
ATOM  11836  CA  ASP F  74      70.045  54.455  65.912  1.00 39.93           C  
ATOM  11837  C   ASP F  74      70.815  53.297  66.524  1.00 39.98           C  
ATOM  11838  O   ASP F  74      71.046  52.275  65.878  1.00 39.90           O  
ATOM  11839  CB  ASP F  74      68.562  54.269  66.237  1.00 40.04           C  
ATOM  11840  CG  ASP F  74      67.791  55.556  66.152  1.00 41.77           C  
ATOM  11841  OD1 ASP F  74      67.960  56.411  67.053  1.00 43.12           O  
ATOM  11842  OD2 ASP F  74      67.019  55.715  65.180  1.00 43.55           O  
ATOM  11843  N   SER F  75      71.186  53.463  67.789  1.00 40.14           N  
ATOM  11844  CA  SER F  75      71.666  52.358  68.591  1.00 40.20           C  
ATOM  11845  C   SER F  75      70.524  51.386  68.882  1.00 40.50           C  
ATOM  11846  O   SER F  75      69.377  51.803  69.124  1.00 40.42           O  
ATOM  11847  CB  SER F  75      72.248  52.859  69.906  1.00 40.04           C  
ATOM  11848  OG  SER F  75      72.695  51.757  70.685  1.00 40.68           O  
ATOM  11849  N   VAL F  76      70.845  50.091  68.872  1.00 40.54           N  
ATOM  11850  CA  VAL F  76      69.874  49.039  69.244  1.00 40.95           C  
ATOM  11851  C   VAL F  76      69.287  49.242  70.650  1.00 41.71           C  
ATOM  11852  O   VAL F  76      68.221  48.702  70.966  1.00 41.92           O  
ATOM  11853  CB  VAL F  76      70.454  47.596  69.090  1.00 40.44           C  
ATOM  11854  CG1 VAL F  76      70.628  47.256  67.634  1.00 39.70           C  
ATOM  11855  CG2 VAL F  76      71.765  47.434  69.840  1.00 39.33           C  
ATOM  11856  N   GLU F  77      69.983  50.037  71.471  1.00 42.56           N  
ATOM  11857  CA  GLU F  77      69.466  50.502  72.752  1.00 43.56           C  
ATOM  11858  C   GLU F  77      68.128  51.235  72.568  1.00 43.77           C  
ATOM  11859  O   GLU F  77      67.277  51.180  73.431  1.00 44.40           O  
ATOM  11860  CB  GLU F  77      70.457  51.435  73.435  1.00 43.24           C  
ATOM  11861  CG  GLU F  77      71.824  50.872  73.775  1.00 43.91           C  
ATOM  11862  CD  GLU F  77      72.763  51.971  74.274  1.00 44.89           C  
ATOM  11863  OE1 GLU F  77      72.426  52.629  75.285  1.00 46.71           O  
ATOM  11864  OE2 GLU F  77      73.819  52.215  73.643  1.00 46.71           O  
ATOM  11865  N   GLU F  78      67.959  51.930  71.445  1.00 43.99           N  
ATOM  11866  CA  GLU F  78      66.679  52.575  71.099  1.00 43.88           C  
ATOM  11867  C   GLU F  78      65.921  51.707  70.091  1.00 43.39           C  
ATOM  11868  O   GLU F  78      65.626  52.142  68.974  1.00 43.35           O  
ATOM  11869  CB  GLU F  78      66.900  53.979  70.513  1.00 44.06           C  
ATOM  11870  CG  GLU F  78      67.951  54.835  71.222  1.00 45.10           C  
ATOM  11871  CD  GLU F  78      67.512  55.289  72.604  1.00 46.50           C  
ATOM  11872  OE1 GLU F  78      68.036  54.738  73.599  1.00 46.83           O  
ATOM  11873  OE2 GLU F  78      66.645  56.187  72.694  1.00 46.66           O  
ATOM  11874  N   GLY F  79      65.617  50.475  70.499  1.00 42.88           N  
ATOM  11875  CA  GLY F  79      65.085  49.445  69.601  1.00 42.19           C  
ATOM  11876  C   GLY F  79      63.791  49.802  68.901  1.00 41.64           C  
ATOM  11877  O   GLY F  79      63.561  49.393  67.764  1.00 41.28           O  
ATOM  11878  N   GLU F  80      62.944  50.551  69.599  1.00 41.25           N  
ATOM  11879  CA  GLU F  80      61.706  51.079  69.051  1.00 41.50           C  
ATOM  11880  C   GLU F  80      61.944  51.990  67.831  1.00 41.20           C  
ATOM  11881  O   GLU F  80      61.246  51.879  66.816  1.00 41.32           O  
ATOM  11882  CB  GLU F  80      60.969  51.845  70.149  1.00 41.70           C  
ATOM  11883  CG  GLU F  80      59.574  52.266  69.786  1.00 42.68           C  
ATOM  11884  CD  GLU F  80      58.508  51.507  70.553  1.00 43.97           C  
ATOM  11885  OE1 GLU F  80      58.781  50.370  71.002  1.00 42.21           O  
ATOM  11886  OE2 GLU F  80      57.392  52.072  70.706  1.00 44.67           O  
ATOM  11887  N   LYS F  81      62.921  52.890  67.931  1.00 40.87           N  
ATOM  11888  CA  LYS F  81      63.272  53.761  66.802  1.00 40.55           C  
ATOM  11889  C   LYS F  81      63.869  52.982  65.615  1.00 40.18           C  
ATOM  11890  O   LYS F  81      63.628  53.358  64.462  1.00 40.01           O  
ATOM  11891  CB  LYS F  81      64.182  54.916  67.237  1.00 40.48           C  
ATOM  11892  N   VAL F  82      64.613  51.905  65.893  1.00 39.48           N  
ATOM  11893  CA  VAL F  82      65.184  51.069  64.827  1.00 39.23           C  
ATOM  11894  C   VAL F  82      64.062  50.401  64.020  1.00 39.12           C  
ATOM  11895  O   VAL F  82      64.081  50.379  62.795  1.00 39.02           O  
ATOM  11896  CB  VAL F  82      66.192  50.005  65.373  1.00 39.44           C  
ATOM  11897  CG1 VAL F  82      66.899  49.280  64.227  1.00 39.06           C  
ATOM  11898  CG2 VAL F  82      67.238  50.649  66.295  1.00 38.82           C  
ATOM  11899  N   VAL F  83      63.072  49.878  64.726  1.00 39.24           N  
ATOM  11900  CA  VAL F  83      61.965  49.168  64.101  1.00 39.08           C  
ATOM  11901  C   VAL F  83      61.039  50.154  63.392  1.00 38.98           C  
ATOM  11902  O   VAL F  83      60.454  49.818  62.365  1.00 39.05           O  
ATOM  11903  CB  VAL F  83      61.270  48.236  65.132  1.00 39.02           C  
ATOM  11904  CG1 VAL F  83      59.826  47.883  64.739  1.00 38.85           C  
ATOM  11905  CG2 VAL F  83      62.110  46.976  65.309  1.00 38.20           C  
ATOM  11906  N   LYS F  84      60.959  51.376  63.915  1.00 38.86           N  
ATOM  11907  CA  LYS F  84      60.160  52.448  63.293  1.00 39.01           C  
ATOM  11908  C   LYS F  84      60.555  52.745  61.844  1.00 38.91           C  
ATOM  11909  O   LYS F  84      59.684  53.019  61.023  1.00 38.78           O  
ATOM  11910  CB  LYS F  84      60.196  53.743  64.117  1.00 39.29           C  
ATOM  11911  N   THR F  85      61.856  52.682  61.541  1.00 38.83           N  
ATOM  11912  CA  THR F  85      62.353  52.824  60.165  1.00 38.89           C  
ATOM  11913  C   THR F  85      61.710  51.811  59.213  1.00 39.10           C  
ATOM  11914  O   THR F  85      61.320  52.166  58.109  1.00 39.44           O  
ATOM  11915  CB  THR F  85      63.909  52.688  60.060  1.00 38.87           C  
ATOM  11916  OG1 THR F  85      64.548  53.573  60.986  1.00 38.77           O  
ATOM  11917  CG2 THR F  85      64.393  53.024  58.657  1.00 38.59           C  
ATOM  11918  N   ALA F  86      61.617  50.554  59.639  1.00 39.30           N  
ATOM  11919  CA  ALA F  86      60.960  49.503  58.860  1.00 39.64           C  
ATOM  11920  C   ALA F  86      59.491  49.850  58.602  1.00 40.02           C  
ATOM  11921  O   ALA F  86      58.993  49.716  57.478  1.00 39.92           O  
ATOM  11922  CB  ALA F  86      61.076  48.150  59.586  1.00 39.25           C  
ATOM  11923  N   LEU F  87      58.809  50.307  59.651  1.00 40.59           N  
ATOM  11924  CA  LEU F  87      57.399  50.664  59.558  1.00 41.30           C  
ATOM  11925  C   LEU F  87      57.207  51.892  58.672  1.00 41.70           C  
ATOM  11926  O   LEU F  87      56.288  51.934  57.859  1.00 41.88           O  
ATOM  11927  CB  LEU F  87      56.807  50.884  60.952  1.00 41.31           C  
ATOM  11928  N   ASP F  88      58.095  52.877  58.805  1.00 42.25           N  
ATOM  11929  CA  ASP F  88      58.008  54.104  58.008  1.00 42.88           C  
ATOM  11930  C   ASP F  88      58.330  53.874  56.530  1.00 42.63           C  
ATOM  11931  O   ASP F  88      57.585  54.316  55.655  1.00 42.79           O  
ATOM  11932  CB  ASP F  88      58.923  55.193  58.591  1.00 43.39           C  
ATOM  11933  CG  ASP F  88      58.483  55.660  59.982  1.00 44.89           C  
ATOM  11934  OD1 ASP F  88      57.429  55.204  60.490  1.00 46.00           O  
ATOM  11935  OD2 ASP F  88      59.206  56.491  60.573  1.00 46.80           O  
ATOM  11936  N   ALA F  89      59.425  53.173  56.263  1.00 42.20           N  
ATOM  11937  CA  ALA F  89      59.870  52.920  54.895  1.00 41.84           C  
ATOM  11938  C   ALA F  89      59.007  51.896  54.152  1.00 41.61           C  
ATOM  11939  O   ALA F  89      58.646  52.121  52.994  1.00 41.78           O  
ATOM  11940  CB  ALA F  89      61.345  52.493  54.880  1.00 41.73           C  
ATOM  11941  N   PHE F  90      58.668  50.788  54.814  1.00 41.22           N  
ATOM  11942  CA  PHE F  90      58.026  49.657  54.132  1.00 40.75           C  
ATOM  11943  C   PHE F  90      56.652  49.250  54.663  1.00 40.50           C  
ATOM  11944  O   PHE F  90      55.951  48.458  54.026  1.00 40.40           O  
ATOM  11945  CB  PHE F  90      58.955  48.443  54.124  1.00 40.93           C  
ATOM  11946  CG  PHE F  90      60.302  48.711  53.515  1.00 40.81           C  
ATOM  11947  CD1 PHE F  90      61.452  48.615  54.286  1.00 40.98           C  
ATOM  11948  CD2 PHE F  90      60.418  49.063  52.174  1.00 41.35           C  
ATOM  11949  CE1 PHE F  90      62.705  48.852  53.734  1.00 41.41           C  
ATOM  11950  CE2 PHE F  90      61.657  49.311  51.611  1.00 41.34           C  
ATOM  11951  CZ  PHE F  90      62.807  49.205  52.394  1.00 41.95           C  
ATOM  11952  N   GLY F  91      56.274  49.771  55.826  1.00 40.14           N  
ATOM  11953  CA  GLY F  91      54.921  49.572  56.344  1.00 39.76           C  
ATOM  11954  C   GLY F  91      54.676  48.310  57.156  1.00 39.60           C  
ATOM  11955  O   GLY F  91      53.528  48.030  57.531  1.00 39.31           O  
ATOM  11956  N   ARG F  92      55.739  47.555  57.419  1.00 39.11           N  
ATOM  11957  CA  ARG F  92      55.684  46.330  58.223  1.00 39.00           C  
ATOM  11958  C   ARG F  92      57.119  45.846  58.562  1.00 38.98           C  
ATOM  11959  O   ARG F  92      58.103  46.419  58.070  1.00 38.88           O  
ATOM  11960  CB  ARG F  92      54.851  45.235  57.520  1.00 38.73           C  
ATOM  11961  CG  ARG F  92      55.505  44.654  56.265  1.00 39.93           C  
ATOM  11962  CD  ARG F  92      54.523  43.979  55.223  1.00 39.73           C  
ATOM  11963  NE  ARG F  92      55.345  43.577  54.061  1.00 41.09           N  
ATOM  11964  CZ  ARG F  92      55.447  44.241  52.858  1.00 41.47           C  
ATOM  11965  NH1 ARG F  92      56.278  43.757  51.885  1.00 41.03           N  
ATOM  11966  NH2 ARG F  92      54.721  45.382  52.611  1.00 40.83           N  
ATOM  11967  N   ILE F  93      57.211  44.826  59.424  1.00 38.65           N  
ATOM  11968  CA  ILE F  93      58.474  44.154  59.795  1.00 38.60           C  
ATOM  11969  C   ILE F  93      58.216  42.648  59.891  1.00 38.75           C  
ATOM  11970  O   ILE F  93      57.281  42.211  60.592  1.00 38.54           O  
ATOM  11971  CB  ILE F  93      59.060  44.663  61.154  1.00 38.50           C  
ATOM  11972  CG1 ILE F  93      60.332  43.902  61.540  1.00 38.77           C  
ATOM  11973  CG2 ILE F  93      58.018  44.534  62.299  1.00 38.23           C  
ATOM  11974  CD1 ILE F  93      61.546  44.070  60.587  1.00 37.69           C  
ATOM  11975  N   ASP F  94      59.026  41.868  59.181  1.00 38.49           N  
ATOM  11976  CA  ASP F  94      58.788  40.436  59.027  1.00 38.53           C  
ATOM  11977  C   ASP F  94      59.960  39.595  59.541  1.00 38.25           C  
ATOM  11978  O   ASP F  94      59.746  38.530  60.119  1.00 38.00           O  
ATOM  11979  CB  ASP F  94      58.406  40.096  57.565  1.00 38.53           C  
ATOM  11980  CG  ASP F  94      56.922  40.398  57.281  1.00 40.64           C  
ATOM  11981  OD1 ASP F  94      56.097  40.094  58.186  1.00 43.74           O  
ATOM  11982  OD2 ASP F  94      56.560  40.950  56.191  1.00 42.57           O  
ATOM  11983  N   VAL F  95      61.189  40.081  59.349  1.00 37.79           N  
ATOM  11984  CA  VAL F  95      62.392  39.379  59.822  1.00 37.35           C  
ATOM  11985  C   VAL F  95      63.325  40.314  60.609  1.00 37.61           C  
ATOM  11986  O   VAL F  95      63.673  41.416  60.141  1.00 37.45           O  
ATOM  11987  CB  VAL F  95      63.207  38.764  58.637  1.00 37.38           C  
ATOM  11988  CG1 VAL F  95      64.559  38.181  59.119  1.00 37.09           C  
ATOM  11989  CG2 VAL F  95      62.396  37.723  57.868  1.00 36.68           C  
ATOM  11990  N   VAL F  96      63.744  39.863  61.792  1.00 37.56           N  
ATOM  11991  CA  VAL F  96      64.692  40.611  62.618  1.00 37.14           C  
ATOM  11992  C   VAL F  96      65.916  39.770  62.901  1.00 37.32           C  
ATOM  11993  O   VAL F  96      65.816  38.708  63.512  1.00 37.96           O  
ATOM  11994  CB  VAL F  96      64.041  41.042  63.951  1.00 37.60           C  
ATOM  11995  CG1 VAL F  96      65.080  41.651  64.885  1.00 37.92           C  
ATOM  11996  CG2 VAL F  96      62.925  42.020  63.702  1.00 36.87           C  
ATOM  11997  N   VAL F  97      67.070  40.234  62.445  1.00 37.09           N  
ATOM  11998  CA  VAL F  97      68.319  39.578  62.721  1.00 36.38           C  
ATOM  11999  C   VAL F  97      69.092  40.437  63.717  1.00 36.67           C  
ATOM  12000  O   VAL F  97      69.718  41.431  63.347  1.00 36.55           O  
ATOM  12001  CB  VAL F  97      69.139  39.370  61.426  1.00 36.18           C  
ATOM  12002  CG1 VAL F  97      70.546  38.831  61.737  1.00 34.49           C  
ATOM  12003  CG2 VAL F  97      68.414  38.436  60.496  1.00 35.22           C  
ATOM  12004  N   ASN F  98      69.037  40.040  64.985  1.00 36.52           N  
ATOM  12005  CA  ASN F  98      69.766  40.736  66.045  1.00 36.66           C  
ATOM  12006  C   ASN F  98      71.274  40.375  65.980  1.00 37.09           C  
ATOM  12007  O   ASN F  98      71.667  39.273  66.383  1.00 37.55           O  
ATOM  12008  CB  ASN F  98      69.142  40.403  67.415  1.00 35.19           C  
ATOM  12009  CG  ASN F  98      67.706  40.952  67.570  1.00 34.56           C  
ATOM  12010  OD1 ASN F  98      67.485  42.152  67.500  1.00 32.39           O  
ATOM  12011  ND2 ASN F  98      66.744  40.065  67.785  1.00 31.71           N  
ATOM  12012  N   ASN F  99      72.086  41.296  65.454  1.00 36.78           N  
ATOM  12013  CA  ASN F  99      73.501  41.022  65.153  1.00 36.61           C  
ATOM  12014  C   ASN F  99      74.471  42.008  65.820  1.00 36.79           C  
ATOM  12015  O   ASN F  99      75.609  41.652  66.117  1.00 36.99           O  
ATOM  12016  CB  ASN F  99      73.709  40.979  63.634  1.00 35.90           C  
ATOM  12017  CG  ASN F  99      75.182  41.062  63.231  1.00 35.08           C  
ATOM  12018  OD1 ASN F  99      75.922  40.090  63.343  1.00 34.08           O  
ATOM  12019  ND2 ASN F  99      75.600  42.227  62.729  1.00 34.04           N  
ATOM  12020  N   ALA F 100      73.994  43.233  66.068  1.00 36.75           N  
ATOM  12021  CA  ALA F 100      74.795  44.323  66.651  1.00 36.74           C  
ATOM  12022  C   ALA F 100      75.548  43.851  67.879  1.00 36.96           C  
ATOM  12023  O   ALA F 100      74.980  43.198  68.765  1.00 36.01           O  
ATOM  12024  CB  ALA F 100      73.892  45.511  67.036  1.00 36.73           C  
ATOM  12025  N   GLY F 101      76.834  44.184  67.928  1.00 37.17           N  
ATOM  12026  CA  GLY F 101      77.653  43.785  69.063  1.00 37.43           C  
ATOM  12027  C   GLY F 101      78.984  44.481  69.115  1.00 37.58           C  
ATOM  12028  O   GLY F 101      79.434  45.016  68.117  1.00 37.52           O  
ATOM  12029  N   ILE F 102      79.594  44.453  70.297  1.00 37.94           N  
ATOM  12030  CA  ILE F 102      80.873  45.081  70.594  1.00 38.39           C  
ATOM  12031  C   ILE F 102      81.658  44.208  71.583  1.00 39.10           C  
ATOM  12032  O   ILE F 102      81.108  43.262  72.159  1.00 39.35           O  
ATOM  12033  CB  ILE F 102      80.692  46.521  71.162  1.00 38.46           C  
ATOM  12034  CG1 ILE F 102      79.548  46.574  72.196  1.00 37.82           C  
ATOM  12035  CG2 ILE F 102      80.455  47.521  70.029  1.00 37.69           C  
ATOM  12036  CD1 ILE F 102      79.740  47.645  73.262  1.00 35.95           C  
ATOM  12037  N   LEU F 103      82.935  44.517  71.772  1.00 40.00           N  
ATOM  12038  CA  LEU F 103      83.794  43.782  72.703  1.00 41.12           C  
ATOM  12039  C   LEU F 103      84.413  44.660  73.800  1.00 41.66           C  
ATOM  12040  O   LEU F 103      84.812  45.792  73.545  1.00 41.64           O  
ATOM  12041  CB  LEU F 103      84.930  43.097  71.952  1.00 41.10           C  
ATOM  12042  CG  LEU F 103      84.727  41.691  71.402  1.00 41.89           C  
ATOM  12043  CD1 LEU F 103      86.097  41.192  70.965  1.00 44.88           C  
ATOM  12044  CD2 LEU F 103      84.145  40.762  72.433  1.00 40.47           C  
ATOM  12045  N   ARG F 104      84.481  44.112  75.012  1.00 42.11           N  
ATOM  12046  CA  ARG F 104      85.179  44.730  76.139  1.00 42.24           C  
ATOM  12047  C   ARG F 104      85.928  43.631  76.913  1.00 42.45           C  
ATOM  12048  O   ARG F 104      85.615  43.344  78.070  1.00 42.19           O  
ATOM  12049  CB  ARG F 104      84.175  45.453  77.058  1.00 42.47           C  
ATOM  12050  CG  ARG F 104      83.555  46.741  76.495  1.00 41.62           C  
ATOM  12051  CD  ARG F 104      84.585  47.834  76.379  1.00 40.69           C  
ATOM  12052  NE  ARG F 104      84.034  49.110  75.943  1.00 39.54           N  
ATOM  12053  CZ  ARG F 104      83.759  50.132  76.750  1.00 39.54           C  
ATOM  12054  NH1 ARG F 104      83.953  50.026  78.057  1.00 40.09           N  
ATOM  12055  NH2 ARG F 104      83.274  51.263  76.246  1.00 38.61           N  
ATOM  12056  N   ASP F 105      86.908  43.004  76.261  1.00 42.75           N  
ATOM  12057  CA  ASP F 105      87.669  41.913  76.891  1.00 42.99           C  
ATOM  12058  C   ASP F 105      88.481  42.428  78.056  1.00 42.83           C  
ATOM  12059  O   ASP F 105      89.138  43.472  77.962  1.00 42.28           O  
ATOM  12060  CB  ASP F 105      88.639  41.236  75.924  1.00 43.88           C  
ATOM  12061  CG  ASP F 105      87.971  40.734  74.665  1.00 45.02           C  
ATOM  12062  OD1 ASP F 105      86.968  40.005  74.768  1.00 46.13           O  
ATOM  12063  OD2 ASP F 105      88.485  41.068  73.572  1.00 48.54           O  
ATOM  12064  N   ARG F 106      88.435  41.673  79.148  1.00 42.47           N  
ATOM  12065  CA  ARG F 106      89.106  42.032  80.388  1.00 42.50           C  
ATOM  12066  C   ARG F 106      89.060  40.835  81.315  1.00 41.89           C  
ATOM  12067  O   ARG F 106      88.058  40.120  81.354  1.00 41.61           O  
ATOM  12068  CB  ARG F 106      88.377  43.200  81.060  1.00 42.76           C  
ATOM  12069  CG  ARG F 106      89.289  44.210  81.727  1.00 45.11           C  
ATOM  12070  CD  ARG F 106      89.810  45.257  80.754  1.00 48.69           C  
ATOM  12071  NE  ARG F 106      88.729  45.984  80.073  1.00 51.14           N  
ATOM  12072  CZ  ARG F 106      88.935  46.956  79.183  1.00 51.66           C  
ATOM  12073  NH1 ARG F 106      90.179  47.314  78.865  1.00 50.30           N  
ATOM  12074  NH2 ARG F 106      87.899  47.569  78.609  1.00 50.80           N  
ATOM  12075  N   SER F 107      90.139  40.608  82.062  1.00 41.03           N  
ATOM  12076  CA  SER F 107      90.094  39.584  83.108  1.00 40.47           C  
ATOM  12077  C   SER F 107      89.089  40.014  84.194  1.00 39.65           C  
ATOM  12078  O   SER F 107      88.854  41.210  84.388  1.00 39.17           O  
ATOM  12079  CB  SER F 107      91.491  39.296  83.672  1.00 40.41           C  
ATOM  12080  OG  SER F 107      91.860  40.235  84.651  1.00 40.62           O  
ATOM  12081  N   PHE F 108      88.499  39.037  84.881  1.00 38.94           N  
ATOM  12082  CA  PHE F 108      87.285  39.267  85.681  1.00 38.43           C  
ATOM  12083  C   PHE F 108      87.330  40.447  86.673  1.00 38.33           C  
ATOM  12084  O   PHE F 108      86.473  41.328  86.632  1.00 38.11           O  
ATOM  12085  CB  PHE F 108      86.825  37.974  86.374  1.00 38.11           C  
ATOM  12086  CG  PHE F 108      85.477  38.090  87.042  1.00 36.57           C  
ATOM  12087  CD1 PHE F 108      84.333  38.284  86.286  1.00 36.30           C  
ATOM  12088  CD2 PHE F 108      85.361  38.015  88.433  1.00 35.63           C  
ATOM  12089  CE1 PHE F 108      83.055  38.378  86.899  1.00 36.22           C  
ATOM  12090  CE2 PHE F 108      84.106  38.121  89.058  1.00 36.59           C  
ATOM  12091  CZ  PHE F 108      82.947  38.310  88.287  1.00 35.63           C  
ATOM  12092  N   ALA F 109      88.339  40.469  87.538  1.00 38.59           N  
ATOM  12093  CA  ALA F 109      88.510  41.543  88.519  1.00 38.56           C  
ATOM  12094  C   ALA F 109      88.701  42.917  87.877  1.00 38.62           C  
ATOM  12095  O   ALA F 109      88.525  43.944  88.530  1.00 38.72           O  
ATOM  12096  CB  ALA F 109      89.657  41.226  89.448  1.00 38.60           C  
ATOM  12097  N   ARG F 110      89.038  42.924  86.591  1.00 38.75           N  
ATOM  12098  CA  ARG F 110      89.340  44.157  85.867  1.00 38.93           C  
ATOM  12099  C   ARG F 110      88.152  44.707  85.060  1.00 38.24           C  
ATOM  12100  O   ARG F 110      88.230  45.788  84.490  1.00 38.22           O  
ATOM  12101  CB  ARG F 110      90.582  43.945  84.990  1.00 38.97           C  
ATOM  12102  CG  ARG F 110      91.861  43.806  85.810  1.00 41.03           C  
ATOM  12103  CD  ARG F 110      93.017  43.198  85.004  1.00 44.17           C  
ATOM  12104  NE  ARG F 110      94.269  43.115  85.772  1.00 46.03           N  
ATOM  12105  CZ  ARG F 110      94.450  42.360  86.859  1.00 47.09           C  
ATOM  12106  NH1 ARG F 110      93.463  41.619  87.355  1.00 48.09           N  
ATOM  12107  NH2 ARG F 110      95.624  42.350  87.465  1.00 46.74           N  
ATOM  12108  N   ILE F 111      87.053  43.961  85.021  1.00 37.51           N  
ATOM  12109  CA  ILE F 111      85.833  44.434  84.373  1.00 36.64           C  
ATOM  12110  C   ILE F 111      85.224  45.580  85.181  1.00 36.36           C  
ATOM  12111  O   ILE F 111      84.835  45.396  86.328  1.00 36.21           O  
ATOM  12112  CB  ILE F 111      84.812  43.297  84.236  1.00 36.67           C  
ATOM  12113  CG1 ILE F 111      85.395  42.180  83.376  1.00 36.39           C  
ATOM  12114  CG2 ILE F 111      83.476  43.815  83.665  1.00 36.37           C  
ATOM  12115  CD1 ILE F 111      84.649  40.872  83.508  1.00 35.73           C  
ATOM  12116  N   SER F 112      85.155  46.758  84.577  1.00 36.00           N  
ATOM  12117  CA  SER F 112      84.525  47.913  85.212  1.00 35.86           C  
ATOM  12118  C   SER F 112      82.996  47.806  85.126  1.00 36.23           C  
ATOM  12119  O   SER F 112      82.467  46.976  84.394  1.00 35.67           O  
ATOM  12120  CB  SER F 112      85.001  49.205  84.540  1.00 35.50           C  
ATOM  12121  OG  SER F 112      84.483  49.311  83.220  1.00 34.00           O  
ATOM  12122  N   ASP F 113      82.300  48.659  85.875  1.00 36.92           N  
ATOM  12123  CA  ASP F 113      80.850  48.770  85.789  1.00 37.72           C  
ATOM  12124  C   ASP F 113      80.434  49.116  84.355  1.00 38.38           C  
ATOM  12125  O   ASP F 113      79.509  48.509  83.800  1.00 38.87           O  
ATOM  12126  CB  ASP F 113      80.332  49.823  86.781  1.00 37.27           C  
ATOM  12127  CG  ASP F 113      80.368  49.339  88.230  1.00 37.20           C  
ATOM  12128  OD1 ASP F 113      80.752  48.174  88.497  1.00 35.22           O  
ATOM  12129  OD2 ASP F 113      79.993  50.131  89.115  1.00 38.45           O  
ATOM  12130  N   GLU F 114      81.139  50.077  83.760  1.00 39.01           N  
ATOM  12131  CA  GLU F 114      80.880  50.504  82.386  1.00 39.89           C  
ATOM  12132  C   GLU F 114      81.126  49.373  81.379  1.00 39.72           C  
ATOM  12133  O   GLU F 114      80.324  49.189  80.462  1.00 40.14           O  
ATOM  12134  CB  GLU F 114      81.696  51.763  82.026  1.00 39.86           C  
ATOM  12135  CG  GLU F 114      81.379  52.361  80.639  1.00 40.91           C  
ATOM  12136  CD  GLU F 114      82.436  53.362  80.147  1.00 41.04           C  
ATOM  12137  OE1 GLU F 114      82.720  54.365  80.851  1.00 40.91           O  
ATOM  12138  OE2 GLU F 114      82.970  53.153  79.036  1.00 42.94           O  
ATOM  12139  N   ASP F 115      82.213  48.617  81.554  1.00 39.46           N  
ATOM  12140  CA  ASP F 115      82.470  47.440  80.704  1.00 39.18           C  
ATOM  12141  C   ASP F 115      81.280  46.494  80.692  1.00 38.95           C  
ATOM  12142  O   ASP F 115      80.892  45.989  79.648  1.00 39.22           O  
ATOM  12143  CB  ASP F 115      83.655  46.629  81.207  1.00 39.23           C  
ATOM  12144  CG  ASP F 115      84.991  47.236  80.849  1.00 40.37           C  
ATOM  12145  OD1 ASP F 115      85.101  47.986  79.844  1.00 40.98           O  
ATOM  12146  OD2 ASP F 115      85.943  46.927  81.589  1.00 41.02           O  
ATOM  12147  N   TRP F 116      80.728  46.228  81.869  1.00 38.41           N  
ATOM  12148  CA  TRP F 116      79.605  45.323  81.989  1.00 38.02           C  
ATOM  12149  C   TRP F 116      78.350  45.932  81.372  1.00 38.13           C  
ATOM  12150  O   TRP F 116      77.760  45.337  80.481  1.00 38.48           O  
ATOM  12151  CB  TRP F 116      79.366  44.965  83.453  1.00 37.63           C  
ATOM  12152  CG  TRP F 116      78.227  44.020  83.662  1.00 36.82           C  
ATOM  12153  CD1 TRP F 116      76.898  44.341  83.767  1.00 35.82           C  
ATOM  12154  CD2 TRP F 116      78.309  42.603  83.788  1.00 35.53           C  
ATOM  12155  NE1 TRP F 116      76.156  43.211  83.960  1.00 34.72           N  
ATOM  12156  CE2 TRP F 116      76.992  42.127  83.984  1.00 35.64           C  
ATOM  12157  CE3 TRP F 116      79.369  41.687  83.779  1.00 34.95           C  
ATOM  12158  CZ2 TRP F 116      76.697  40.760  84.153  1.00 36.07           C  
ATOM  12159  CZ3 TRP F 116      79.080  40.328  83.952  1.00 35.88           C  
ATOM  12160  CH2 TRP F 116      77.750  39.878  84.129  1.00 35.81           C  
ATOM  12161  N   ASP F 117      77.964  47.120  81.841  1.00 38.43           N  
ATOM  12162  CA  ASP F 117      76.753  47.801  81.379  1.00 38.76           C  
ATOM  12163  C   ASP F 117      76.680  47.953  79.860  1.00 38.54           C  
ATOM  12164  O   ASP F 117      75.657  47.662  79.262  1.00 38.73           O  
ATOM  12165  CB  ASP F 117      76.631  49.197  82.016  1.00 39.20           C  
ATOM  12166  CG  ASP F 117      76.215  49.155  83.473  1.00 40.52           C  
ATOM  12167  OD1 ASP F 117      76.258  48.075  84.102  1.00 41.29           O  
ATOM  12168  OD2 ASP F 117      75.848  50.230  84.001  1.00 43.13           O  
ATOM  12169  N   ILE F 118      77.760  48.430  79.245  1.00 38.13           N  
ATOM  12170  CA  ILE F 118      77.782  48.664  77.794  1.00 37.83           C  
ATOM  12171  C   ILE F 118      77.600  47.364  76.978  1.00 37.58           C  
ATOM  12172  O   ILE F 118      76.862  47.343  75.983  1.00 37.77           O  
ATOM  12173  CB  ILE F 118      79.062  49.435  77.354  1.00 37.79           C  
ATOM  12174  CG1 ILE F 118      78.875  50.072  75.975  1.00 38.47           C  
ATOM  12175  CG2 ILE F 118      80.308  48.548  77.362  1.00 37.80           C  
ATOM  12176  CD1 ILE F 118      79.762  51.292  75.741  1.00 37.76           C  
ATOM  12177  N   ILE F 119      78.265  46.291  77.413  1.00 37.00           N  
ATOM  12178  CA  ILE F 119      78.127  44.983  76.779  1.00 36.65           C  
ATOM  12179  C   ILE F 119      76.678  44.496  76.897  1.00 36.95           C  
ATOM  12180  O   ILE F 119      76.086  44.066  75.910  1.00 36.99           O  
ATOM  12181  CB  ILE F 119      79.094  43.954  77.403  1.00 36.38           C  
ATOM  12182  CG1 ILE F 119      80.564  44.265  77.032  1.00 36.27           C  
ATOM  12183  CG2 ILE F 119      78.699  42.541  77.033  1.00 35.77           C  
ATOM  12184  CD1 ILE F 119      80.998  43.991  75.565  1.00 36.01           C  
ATOM  12185  N   HIS F 120      76.109  44.602  78.100  1.00 37.18           N  
ATOM  12186  CA  HIS F 120      74.746  44.141  78.330  1.00 37.79           C  
ATOM  12187  C   HIS F 120      73.657  45.005  77.715  1.00 37.91           C  
ATOM  12188  O   HIS F 120      72.657  44.487  77.258  1.00 38.14           O  
ATOM  12189  CB  HIS F 120      74.478  43.828  79.816  1.00 37.82           C  
ATOM  12190  CG  HIS F 120      74.995  42.488  80.217  1.00 37.68           C  
ATOM  12191  ND1 HIS F 120      76.343  42.218  80.324  1.00 39.62           N  
ATOM  12192  CD2 HIS F 120      74.359  41.315  80.434  1.00 36.75           C  
ATOM  12193  CE1 HIS F 120      76.513  40.942  80.630  1.00 38.47           C  
ATOM  12194  NE2 HIS F 120      75.322  40.376  80.709  1.00 38.37           N  
ATOM  12195  N   ARG F 121      73.855  46.314  77.669  1.00 38.20           N  
ATOM  12196  CA  ARG F 121      72.849  47.147  77.008  1.00 38.93           C  
ATOM  12197  C   ARG F 121      72.852  46.998  75.471  1.00 38.23           C  
ATOM  12198  O   ARG F 121      71.793  47.041  74.850  1.00 38.36           O  
ATOM  12199  CB  ARG F 121      72.798  48.607  77.523  1.00 38.59           C  
ATOM  12200  CG  ARG F 121      74.070  49.426  77.376  1.00 40.49           C  
ATOM  12201  CD  ARG F 121      73.820  50.882  77.769  1.00 41.07           C  
ATOM  12202  NE  ARG F 121      74.898  51.406  78.604  1.00 44.66           N  
ATOM  12203  CZ  ARG F 121      75.964  52.066  78.158  1.00 46.08           C  
ATOM  12204  NH1 ARG F 121      76.879  52.479  79.024  1.00 47.02           N  
ATOM  12205  NH2 ARG F 121      76.127  52.312  76.860  1.00 45.68           N  
ATOM  12206  N   VAL F 122      74.013  46.754  74.870  1.00 37.84           N  
ATOM  12207  CA  VAL F 122      74.051  46.573  73.425  1.00 37.63           C  
ATOM  12208  C   VAL F 122      73.608  45.164  73.004  1.00 38.01           C  
ATOM  12209  O   VAL F 122      72.691  45.027  72.183  1.00 38.15           O  
ATOM  12210  CB  VAL F 122      75.421  46.994  72.805  1.00 37.67           C  
ATOM  12211  CG1 VAL F 122      75.549  46.552  71.349  1.00 36.98           C  
ATOM  12212  CG2 VAL F 122      75.601  48.497  72.905  1.00 37.87           C  
ATOM  12213  N   HIS F 123      74.226  44.126  73.575  1.00 38.01           N  
ATOM  12214  CA  HIS F 123      73.962  42.752  73.134  1.00 38.23           C  
ATOM  12215  C   HIS F 123      72.593  42.288  73.551  1.00 38.45           C  
ATOM  12216  O   HIS F 123      71.767  41.914  72.717  1.00 39.26           O  
ATOM  12217  CB  HIS F 123      74.996  41.781  73.677  1.00 38.15           C  
ATOM  12218  CG  HIS F 123      76.335  41.912  73.036  1.00 37.63           C  
ATOM  12219  ND1 HIS F 123      76.672  41.235  71.884  1.00 38.62           N  
ATOM  12220  CD2 HIS F 123      77.427  42.637  73.381  1.00 37.61           C  
ATOM  12221  CE1 HIS F 123      77.920  41.523  71.555  1.00 38.25           C  
ATOM  12222  NE2 HIS F 123      78.400  42.373  72.446  1.00 38.13           N  
ATOM  12223  N   LEU F 124      72.346  42.351  74.850  1.00 38.29           N  
ATOM  12224  CA  LEU F 124      71.236  41.657  75.442  1.00 38.08           C  
ATOM  12225  C   LEU F 124      70.003  42.538  75.544  1.00 38.24           C  
ATOM  12226  O   LEU F 124      68.954  42.184  75.006  1.00 38.01           O  
ATOM  12227  CB  LEU F 124      71.654  41.094  76.799  1.00 38.34           C  
ATOM  12228  CG  LEU F 124      70.699  40.301  77.679  1.00 38.53           C  
ATOM  12229  CD1 LEU F 124      69.781  39.377  76.862  1.00 39.23           C  
ATOM  12230  CD2 LEU F 124      71.517  39.518  78.688  1.00 38.44           C  
ATOM  12231  N   ARG F 125      70.140  43.690  76.205  1.00 37.98           N  
ATOM  12232  CA  ARG F 125      69.041  44.651  76.299  1.00 38.38           C  
ATOM  12233  C   ARG F 125      68.687  45.202  74.913  1.00 38.43           C  
ATOM  12234  O   ARG F 125      67.521  45.472  74.624  1.00 38.49           O  
ATOM  12235  CB  ARG F 125      69.385  45.765  77.292  1.00 38.26           C  
ATOM  12236  CG  ARG F 125      68.216  46.574  77.789  1.00 38.81           C  
ATOM  12237  CD  ARG F 125      68.662  47.600  78.815  1.00 41.64           C  
ATOM  12238  NE  ARG F 125      67.519  48.263  79.445  1.00 44.31           N  
ATOM  12239  CZ  ARG F 125      67.021  49.443  79.076  1.00 45.41           C  
ATOM  12240  NH1 ARG F 125      65.969  49.950  79.716  1.00 46.62           N  
ATOM  12241  NH2 ARG F 125      67.565  50.127  78.074  1.00 45.49           N  
ATOM  12242  N   GLY F 126      69.701  45.341  74.059  1.00 38.32           N  
ATOM  12243  CA  GLY F 126      69.499  45.806  72.688  1.00 38.05           C  
ATOM  12244  C   GLY F 126      68.611  44.860  71.898  1.00 37.77           C  
ATOM  12245  O   GLY F 126      67.575  45.274  71.357  1.00 38.08           O  
ATOM  12246  N   SER F 127      69.021  43.590  71.829  1.00 37.04           N  
ATOM  12247  CA  SER F 127      68.240  42.559  71.162  1.00 36.41           C  
ATOM  12248  C   SER F 127      66.809  42.499  71.702  1.00 35.97           C  
ATOM  12249  O   SER F 127      65.859  42.325  70.934  1.00 36.22           O  
ATOM  12250  CB  SER F 127      68.926  41.207  71.305  1.00 36.23           C  
ATOM  12251  OG  SER F 127      70.180  41.193  70.631  1.00 36.65           O  
ATOM  12252  N   PHE F 128      66.670  42.644  73.020  1.00 35.26           N  
ATOM  12253  CA  PHE F 128      65.373  42.684  73.683  1.00 34.71           C  
ATOM  12254  C   PHE F 128      64.525  43.838  73.174  1.00 34.90           C  
ATOM  12255  O   PHE F 128      63.374  43.640  72.788  1.00 34.86           O  
ATOM  12256  CB  PHE F 128      65.548  42.778  75.213  1.00 34.19           C  
ATOM  12257  CG  PHE F 128      64.308  43.271  75.954  1.00 32.54           C  
ATOM  12258  CD1 PHE F 128      63.131  42.517  75.970  1.00 31.97           C  
ATOM  12259  CD2 PHE F 128      64.327  44.486  76.639  1.00 31.14           C  
ATOM  12260  CE1 PHE F 128      61.992  42.979  76.657  1.00 30.64           C  
ATOM  12261  CE2 PHE F 128      63.172  44.962  77.315  1.00 30.52           C  
ATOM  12262  CZ  PHE F 128      62.022  44.208  77.320  1.00 31.03           C  
ATOM  12263  N   GLN F 129      65.105  45.037  73.175  1.00 35.39           N  
ATOM  12264  CA  GLN F 129      64.368  46.226  72.790  0.50 35.59           C  
ATOM  12266  C   GLN F 129      63.929  46.161  71.333  1.00 35.79           C  
ATOM  12267  O   GLN F 129      62.765  46.452  71.018  1.00 35.79           O  
ATOM  12268  CB  GLN F 129      65.193  47.478  73.067  0.50 35.81           C  
ATOM  12270  CG  GLN F 129      65.071  47.958  74.502  0.50 35.93           C  
ATOM  12272  CD  GLN F 129      65.643  49.343  74.695  0.50 35.25           C  
ATOM  12274  OE1 GLN F 129      66.803  49.493  75.082  0.50 34.07           O  
ATOM  12276  NE2 GLN F 129      64.839  50.366  74.412  0.50 34.35           N  
ATOM  12278  N   VAL F 130      64.841  45.749  70.458  1.00 35.51           N  
ATOM  12279  CA  VAL F 130      64.552  45.593  69.032  1.00 35.39           C  
ATOM  12280  C   VAL F 130      63.409  44.589  68.838  1.00 35.39           C  
ATOM  12281  O   VAL F 130      62.412  44.880  68.175  1.00 35.55           O  
ATOM  12282  CB  VAL F 130      65.834  45.137  68.259  1.00 35.30           C  
ATOM  12283  CG1 VAL F 130      65.496  44.693  66.859  1.00 35.73           C  
ATOM  12284  CG2 VAL F 130      66.879  46.252  68.220  1.00 34.46           C  
ATOM  12285  N   THR F 131      63.533  43.418  69.462  1.00 35.62           N  
ATOM  12286  CA  THR F 131      62.558  42.355  69.250  1.00 35.21           C  
ATOM  12287  C   THR F 131      61.196  42.699  69.868  1.00 35.45           C  
ATOM  12288  O   THR F 131      60.147  42.422  69.276  1.00 34.71           O  
ATOM  12289  CB  THR F 131      63.053  41.010  69.754  1.00 35.45           C  
ATOM  12290  OG1 THR F 131      64.421  40.807  69.341  1.00 34.33           O  
ATOM  12291  CG2 THR F 131      62.151  39.898  69.194  1.00 34.80           C  
ATOM  12292  N   ARG F 132      61.221  43.318  71.044  1.00 35.34           N  
ATOM  12293  CA  ARG F 132      59.985  43.708  71.695  1.00 35.79           C  
ATOM  12294  C   ARG F 132      59.220  44.653  70.782  1.00 35.76           C  
ATOM  12295  O   ARG F 132      58.019  44.503  70.625  1.00 35.57           O  
ATOM  12296  CB  ARG F 132      60.219  44.348  73.071  1.00 35.64           C  
ATOM  12297  CG  ARG F 132      58.923  44.584  73.839  1.00 35.96           C  
ATOM  12298  CD  ARG F 132      59.155  45.343  75.133  1.00 36.54           C  
ATOM  12299  NE  ARG F 132      59.787  46.643  74.908  1.00 36.82           N  
ATOM  12300  CZ  ARG F 132      60.237  47.447  75.872  1.00 36.90           C  
ATOM  12301  NH1 ARG F 132      60.135  47.091  77.147  1.00 35.78           N  
ATOM  12302  NH2 ARG F 132      60.803  48.610  75.563  1.00 37.18           N  
ATOM  12303  N   ALA F 133      59.932  45.594  70.157  1.00 35.89           N  
ATOM  12304  CA  ALA F 133      59.299  46.549  69.244  1.00 35.71           C  
ATOM  12305  C   ALA F 133      58.678  45.862  68.025  1.00 35.79           C  
ATOM  12306  O   ALA F 133      57.642  46.288  67.546  1.00 35.96           O  
ATOM  12307  CB  ALA F 133      60.283  47.629  68.818  1.00 35.57           C  
ATOM  12308  N   ALA F 134      59.311  44.802  67.527  1.00 35.88           N  
ATOM  12309  CA  ALA F 134      58.773  44.049  66.386  1.00 36.05           C  
ATOM  12310  C   ALA F 134      57.588  43.125  66.736  1.00 36.18           C  
ATOM  12311  O   ALA F 134      56.750  42.816  65.875  1.00 36.12           O  
ATOM  12312  CB  ALA F 134      59.864  43.230  65.767  1.00 35.85           C  
ATOM  12313  N   TRP F 135      57.544  42.683  67.991  1.00 36.12           N  
ATOM  12314  CA  TRP F 135      56.796  41.500  68.379  1.00 36.56           C  
ATOM  12315  C   TRP F 135      55.274  41.551  68.104  1.00 37.14           C  
ATOM  12316  O   TRP F 135      54.727  40.613  67.523  1.00 37.25           O  
ATOM  12317  CB  TRP F 135      57.089  41.169  69.849  1.00 36.47           C  
ATOM  12318  CG  TRP F 135      56.493  39.884  70.330  1.00 36.03           C  
ATOM  12319  CD1 TRP F 135      55.332  39.731  71.042  1.00 35.59           C  
ATOM  12320  CD2 TRP F 135      57.020  38.567  70.134  1.00 35.84           C  
ATOM  12321  NE1 TRP F 135      55.113  38.400  71.310  1.00 35.07           N  
ATOM  12322  CE2 TRP F 135      56.125  37.661  70.758  1.00 36.16           C  
ATOM  12323  CE3 TRP F 135      58.168  38.060  69.502  1.00 36.42           C  
ATOM  12324  CZ2 TRP F 135      56.338  36.276  70.762  1.00 36.66           C  
ATOM  12325  CZ3 TRP F 135      58.382  36.676  69.513  1.00 36.35           C  
ATOM  12326  CH2 TRP F 135      57.474  35.809  70.140  1.00 35.50           C  
ATOM  12327  N   GLU F 136      54.604  42.630  68.498  1.00 37.59           N  
ATOM  12328  CA  GLU F 136      53.133  42.710  68.321  1.00 38.77           C  
ATOM  12329  C   GLU F 136      52.758  42.857  66.840  1.00 38.82           C  
ATOM  12330  O   GLU F 136      51.678  42.449  66.418  1.00 38.71           O  
ATOM  12331  CB  GLU F 136      52.530  43.850  69.162  1.00 38.59           C  
ATOM  12332  CG  GLU F 136      51.049  43.667  69.558  1.00 40.76           C  
ATOM  12333  CD  GLU F 136      50.771  42.321  70.237  1.00 42.14           C  
ATOM  12334  OE1 GLU F 136      51.599  41.838  71.044  1.00 43.96           O  
ATOM  12335  OE2 GLU F 136      49.721  41.732  69.942  1.00 43.58           O  
ATOM  12336  N   HIS F 137      53.674  43.423  66.060  1.00 39.11           N  
ATOM  12337  CA  HIS F 137      53.498  43.490  64.623  1.00 39.40           C  
ATOM  12338  C   HIS F 137      53.569  42.087  64.018  1.00 39.07           C  
ATOM  12339  O   HIS F 137      52.751  41.722  63.179  1.00 39.22           O  
ATOM  12340  CB  HIS F 137      54.525  44.450  64.005  1.00 39.88           C  
ATOM  12341  CG  HIS F 137      54.273  45.889  64.345  1.00 40.84           C  
ATOM  12342  ND1 HIS F 137      55.076  46.604  65.208  1.00 41.71           N  
ATOM  12343  CD2 HIS F 137      53.289  46.736  63.955  1.00 41.13           C  
ATOM  12344  CE1 HIS F 137      54.613  47.836  65.320  1.00 41.74           C  
ATOM  12345  NE2 HIS F 137      53.526  47.941  64.573  1.00 41.72           N  
ATOM  12346  N   MET F 138      54.535  41.296  64.468  1.00 38.75           N  
ATOM  12347  CA  MET F 138      54.682  39.920  63.998  1.00 38.71           C  
ATOM  12348  C   MET F 138      53.448  39.081  64.370  1.00 38.89           C  
ATOM  12349  O   MET F 138      52.962  38.286  63.566  1.00 38.73           O  
ATOM  12350  CB  MET F 138      55.956  39.289  64.565  1.00 37.85           C  
ATOM  12351  CG  MET F 138      57.251  39.648  63.816  1.00 37.67           C  
ATOM  12352  SD  MET F 138      58.693  39.422  64.869  1.00 39.36           S  
ATOM  12353  CE  MET F 138      60.084  39.342  63.703  1.00 35.19           C  
ATOM  12354  N   LYS F 139      52.954  39.279  65.587  1.00 39.08           N  
ATOM  12355  CA  LYS F 139      51.834  38.518  66.095  1.00 39.74           C  
ATOM  12356  C   LYS F 139      50.514  38.830  65.364  1.00 39.72           C  
ATOM  12357  O   LYS F 139      49.741  37.911  65.087  1.00 39.79           O  
ATOM  12358  CB  LYS F 139      51.709  38.719  67.611  1.00 40.04           C  
ATOM  12359  N   LYS F 140      50.272  40.102  65.035  1.00 39.86           N  
ATOM  12360  CA  LYS F 140      49.026  40.468  64.322  1.00 39.84           C  
ATOM  12361  C   LYS F 140      49.054  40.014  62.857  1.00 39.82           C  
ATOM  12362  O   LYS F 140      48.015  39.613  62.324  1.00 39.92           O  
ATOM  12363  CB  LYS F 140      48.678  41.959  64.450  1.00 39.84           C  
ATOM  12364  N   GLN F 141      50.240  40.070  62.237  1.00 39.17           N  
ATOM  12365  CA  GLN F 141      50.500  39.540  60.891  1.00 39.08           C  
ATOM  12366  C   GLN F 141      50.451  38.008  60.865  1.00 38.92           C  
ATOM  12367  O   GLN F 141      50.241  37.407  59.805  1.00 38.81           O  
ATOM  12368  CB  GLN F 141      51.935  39.906  60.447  1.00 39.50           C  
ATOM  12369  CG  GLN F 141      52.266  41.398  60.271  1.00 39.97           C  
ATOM  12370  CD  GLN F 141      53.811  41.660  60.243  1.00 39.12           C  
ATOM  12371  OE1 GLN F 141      54.265  42.799  59.986  1.00 39.17           O  
ATOM  12372  NE2 GLN F 141      54.616  40.596  60.522  1.00 39.51           N  
ATOM  12373  N   LYS F 142      50.720  37.394  62.019  1.00 38.46           N  
ATOM  12374  CA  LYS F 142      50.951  35.945  62.133  1.00 38.37           C  
ATOM  12375  C   LYS F 142      52.159  35.468  61.297  1.00 38.08           C  
ATOM  12376  O   LYS F 142      52.090  34.461  60.588  1.00 38.38           O  
ATOM  12377  CB  LYS F 142      49.687  35.141  61.800  1.00 38.35           C  
ATOM  12378  N   TYR F 143      53.258  36.204  61.384  1.00 37.32           N  
ATOM  12379  CA  TYR F 143      54.513  35.811  60.744  1.00 36.62           C  
ATOM  12380  C   TYR F 143      55.642  36.584  61.366  1.00 36.17           C  
ATOM  12381  O   TYR F 143      55.525  37.799  61.583  1.00 35.63           O  
ATOM  12382  CB  TYR F 143      54.508  36.063  59.223  1.00 37.23           C  
ATOM  12383  CG  TYR F 143      55.758  35.555  58.532  1.00 37.43           C  
ATOM  12384  CD1 TYR F 143      55.824  34.260  58.026  1.00 37.45           C  
ATOM  12385  CD2 TYR F 143      56.893  36.359  58.417  1.00 39.01           C  
ATOM  12386  CE1 TYR F 143      56.966  33.794  57.398  1.00 37.67           C  
ATOM  12387  CE2 TYR F 143      58.056  35.900  57.797  1.00 37.19           C  
ATOM  12388  CZ  TYR F 143      58.080  34.621  57.289  1.00 37.31           C  
ATOM  12389  OH  TYR F 143      59.222  34.178  56.679  1.00 38.19           O  
ATOM  12390  N   GLY F 144      56.741  35.865  61.622  1.00 35.49           N  
ATOM  12391  CA  GLY F 144      57.949  36.430  62.155  1.00 34.70           C  
ATOM  12392  C   GLY F 144      59.090  35.422  62.081  1.00 34.78           C  
ATOM  12393  O   GLY F 144      58.887  34.211  62.220  1.00 34.32           O  
ATOM  12394  N   ARG F 145      60.290  35.925  61.813  1.00 34.57           N  
ATOM  12395  CA  ARG F 145      61.497  35.123  61.923  1.00 34.83           C  
ATOM  12396  C   ARG F 145      62.528  35.983  62.601  1.00 35.26           C  
ATOM  12397  O   ARG F 145      62.765  37.114  62.186  1.00 35.09           O  
ATOM  12398  CB  ARG F 145      62.016  34.635  60.568  1.00 34.29           C  
ATOM  12399  CG  ARG F 145      61.088  33.669  59.800  1.00 34.45           C  
ATOM  12400  CD  ARG F 145      60.938  32.266  60.417  1.00 33.75           C  
ATOM  12401  NE  ARG F 145      60.025  31.460  59.601  1.00 34.54           N  
ATOM  12402  CZ  ARG F 145      58.693  31.477  59.712  1.00 35.19           C  
ATOM  12403  NH1 ARG F 145      58.113  32.226  60.647  1.00 36.13           N  
ATOM  12404  NH2 ARG F 145      57.937  30.736  58.903  1.00 32.95           N  
ATOM  12405  N   ILE F 146      63.119  35.443  63.668  1.00 35.62           N  
ATOM  12406  CA  ILE F 146      64.060  36.183  64.517  1.00 35.73           C  
ATOM  12407  C   ILE F 146      65.328  35.374  64.674  1.00 36.03           C  
ATOM  12408  O   ILE F 146      65.264  34.160  64.811  1.00 36.16           O  
ATOM  12409  CB  ILE F 146      63.457  36.453  65.924  1.00 35.58           C  
ATOM  12410  CG1 ILE F 146      62.023  37.033  65.789  1.00 35.50           C  
ATOM  12411  CG2 ILE F 146      64.390  37.339  66.747  1.00 33.84           C  
ATOM  12412  CD1 ILE F 146      61.229  37.066  67.063  1.00 34.50           C  
ATOM  12413  N   ILE F 147      66.465  36.046  64.640  1.00 36.42           N  
ATOM  12414  CA  ILE F 147      67.767  35.410  64.930  1.00 36.93           C  
ATOM  12415  C   ILE F 147      68.414  36.142  66.090  1.00 37.04           C  
ATOM  12416  O   ILE F 147      68.477  37.371  66.089  1.00 37.17           O  
ATOM  12417  CB  ILE F 147      68.734  35.450  63.710  1.00 36.73           C  
ATOM  12418  CG1 ILE F 147      68.217  34.582  62.548  1.00 37.62           C  
ATOM  12419  CG2 ILE F 147      70.211  35.084  64.121  1.00 36.49           C  
ATOM  12420  CD1 ILE F 147      68.343  33.051  62.716  1.00 38.34           C  
ATOM  12421  N   MET F 148      68.882  35.383  67.077  1.00 36.93           N  
ATOM  12422  CA  MET F 148      69.771  35.904  68.108  1.00 37.30           C  
ATOM  12423  C   MET F 148      71.204  35.443  67.832  1.00 37.47           C  
ATOM  12424  O   MET F 148      71.437  34.341  67.314  1.00 37.28           O  
ATOM  12425  CB  MET F 148      69.312  35.412  69.472  1.00 37.90           C  
ATOM  12426  CG  MET F 148      67.864  35.786  69.763  1.00 38.66           C  
ATOM  12427  SD  MET F 148      67.757  37.564  69.993  1.00 41.41           S  
ATOM  12428  CE  MET F 148      65.996  37.725  70.179  1.00 37.24           C  
ATOM  12429  N   THR F 149      72.167  36.292  68.153  1.00 37.61           N  
ATOM  12430  CA  THR F 149      73.562  35.987  67.877  1.00 37.70           C  
ATOM  12431  C   THR F 149      74.271  35.744  69.205  1.00 38.01           C  
ATOM  12432  O   THR F 149      74.634  36.696  69.898  1.00 37.74           O  
ATOM  12433  CB  THR F 149      74.262  37.150  67.117  1.00 37.98           C  
ATOM  12434  OG1 THR F 149      73.507  37.517  65.940  1.00 36.22           O  
ATOM  12435  CG2 THR F 149      75.716  36.763  66.721  1.00 36.04           C  
ATOM  12436  N   SER F 150      74.452  34.476  69.571  1.00 37.89           N  
ATOM  12437  CA  SER F 150      75.228  34.138  70.758  1.00 37.96           C  
ATOM  12438  C   SER F 150      76.706  33.955  70.334  1.00 37.89           C  
ATOM  12439  O   SER F 150      77.118  34.496  69.314  1.00 37.96           O  
ATOM  12440  CB  SER F 150      74.647  32.903  71.447  1.00 38.25           C  
ATOM  12441  OG  SER F 150      75.264  32.680  72.704  1.00 39.76           O  
ATOM  12442  N   SER F 151      77.494  33.240  71.123  1.00 37.64           N  
ATOM  12443  CA  SER F 151      78.879  32.915  70.756  1.00 38.35           C  
ATOM  12444  C   SER F 151      79.354  31.663  71.474  1.00 38.03           C  
ATOM  12445  O   SER F 151      78.782  31.262  72.501  1.00 37.81           O  
ATOM  12446  CB  SER F 151      79.856  34.081  71.057  1.00 38.17           C  
ATOM  12447  OG  SER F 151      79.770  34.467  72.424  1.00 39.69           O  
ATOM  12448  N   ALA F 152      80.424  31.082  70.931  1.00 37.78           N  
ATOM  12449  CA  ALA F 152      81.093  29.949  71.555  1.00 37.76           C  
ATOM  12450  C   ALA F 152      81.588  30.314  72.944  1.00 38.01           C  
ATOM  12451  O   ALA F 152      81.557  29.498  73.853  1.00 38.30           O  
ATOM  12452  CB  ALA F 152      82.240  29.467  70.673  1.00 37.06           C  
ATOM  12453  N   SER F 153      82.019  31.555  73.131  1.00 38.45           N  
ATOM  12454  CA  SER F 153      82.463  31.972  74.453  1.00 39.45           C  
ATOM  12455  C   SER F 153      81.328  31.981  75.497  1.00 39.53           C  
ATOM  12456  O   SER F 153      81.564  31.657  76.654  1.00 40.10           O  
ATOM  12457  CB  SER F 153      83.239  33.287  74.389  1.00 39.75           C  
ATOM  12458  OG  SER F 153      82.400  34.379  74.090  1.00 42.12           O  
ATOM  12459  N   GLY F 154      80.095  32.282  75.080  1.00 39.74           N  
ATOM  12460  CA  GLY F 154      78.927  32.117  75.946  1.00 39.89           C  
ATOM  12461  C   GLY F 154      78.637  30.646  76.253  1.00 40.29           C  
ATOM  12462  O   GLY F 154      78.398  30.272  77.401  1.00 40.28           O  
ATOM  12463  N   ILE F 155      78.684  29.817  75.217  1.00 40.19           N  
ATOM  12464  CA  ILE F 155      78.365  28.384  75.310  1.00 39.93           C  
ATOM  12465  C   ILE F 155      79.386  27.615  76.152  1.00 40.12           C  
ATOM  12466  O   ILE F 155      79.012  26.716  76.903  1.00 40.40           O  
ATOM  12467  CB  ILE F 155      78.296  27.741  73.860  1.00 40.05           C  
ATOM  12468  CG1 ILE F 155      77.148  28.372  73.049  1.00 40.00           C  
ATOM  12469  CG2 ILE F 155      78.164  26.239  73.909  1.00 38.27           C  
ATOM  12470  CD1 ILE F 155      77.305  28.298  71.487  1.00 39.23           C  
ATOM  12471  N   TYR F 156      80.663  27.949  76.008  1.00 40.39           N  
ATOM  12472  CA  TYR F 156      81.758  27.165  76.608  1.00 40.70           C  
ATOM  12473  C   TYR F 156      82.511  27.934  77.675  1.00 41.04           C  
ATOM  12474  O   TYR F 156      83.177  27.339  78.517  1.00 41.08           O  
ATOM  12475  CB  TYR F 156      82.773  26.704  75.548  1.00 40.64           C  
ATOM  12476  CG  TYR F 156      82.138  25.892  74.474  1.00 41.24           C  
ATOM  12477  CD1 TYR F 156      81.994  26.409  73.182  1.00 40.74           C  
ATOM  12478  CD2 TYR F 156      81.609  24.619  74.748  1.00 40.34           C  
ATOM  12479  CE1 TYR F 156      81.360  25.669  72.176  1.00 39.32           C  
ATOM  12480  CE2 TYR F 156      80.983  23.877  73.747  1.00 39.57           C  
ATOM  12481  CZ  TYR F 156      80.874  24.401  72.460  1.00 40.18           C  
ATOM  12482  OH  TYR F 156      80.257  23.661  71.457  1.00 40.47           O  
ATOM  12483  N   GLY F 157      82.400  29.260  77.640  1.00 41.03           N  
ATOM  12484  CA  GLY F 157      83.227  30.091  78.489  1.00 40.93           C  
ATOM  12485  C   GLY F 157      84.519  30.410  77.792  1.00 41.26           C  
ATOM  12486  O   GLY F 157      85.010  29.630  76.953  1.00 41.58           O  
ATOM  12487  N   ASN F 158      85.088  31.557  78.135  1.00 40.93           N  
ATOM  12488  CA  ASN F 158      86.416  31.911  77.637  1.00 41.14           C  
ATOM  12489  C   ASN F 158      87.124  32.882  78.576  1.00 41.00           C  
ATOM  12490  O   ASN F 158      86.532  33.862  79.024  1.00 41.09           O  
ATOM  12491  CB  ASN F 158      86.357  32.505  76.220  1.00 40.41           C  
ATOM  12492  CG  ASN F 158      87.722  32.558  75.565  1.00 42.39           C  
ATOM  12493  OD1 ASN F 158      88.621  31.781  75.911  1.00 42.33           O  
ATOM  12494  ND2 ASN F 158      87.895  33.479  74.626  1.00 42.69           N  
ATOM  12495  N   PHE F 159      88.396  32.613  78.853  1.00 40.85           N  
ATOM  12496  CA  PHE F 159      89.219  33.510  79.663  1.00 40.67           C  
ATOM  12497  C   PHE F 159      89.091  34.930  79.144  1.00 40.48           C  
ATOM  12498  O   PHE F 159      89.152  35.155  77.941  1.00 40.12           O  
ATOM  12499  CB  PHE F 159      90.693  33.089  79.626  1.00 40.57           C  
ATOM  12500  CG  PHE F 159      91.531  33.687  80.734  1.00 41.10           C  
ATOM  12501  CD1 PHE F 159      91.910  32.911  81.829  1.00 41.49           C  
ATOM  12502  CD2 PHE F 159      91.948  35.016  80.681  1.00 41.61           C  
ATOM  12503  CE1 PHE F 159      92.686  33.448  82.858  1.00 41.58           C  
ATOM  12504  CE2 PHE F 159      92.729  35.572  81.716  1.00 42.13           C  
ATOM  12505  CZ  PHE F 159      93.097  34.785  82.801  1.00 41.66           C  
ATOM  12506  N   GLY F 160      88.904  35.879  80.061  1.00 40.59           N  
ATOM  12507  CA  GLY F 160      88.909  37.305  79.726  1.00 40.61           C  
ATOM  12508  C   GLY F 160      87.634  37.809  79.070  1.00 40.84           C  
ATOM  12509  O   GLY F 160      87.614  38.916  78.539  1.00 41.06           O  
ATOM  12510  N   GLN F 161      86.567  37.014  79.111  1.00 40.71           N  
ATOM  12511  CA  GLN F 161      85.340  37.373  78.404  1.00 41.24           C  
ATOM  12512  C   GLN F 161      84.077  37.125  79.207  1.00 40.60           C  
ATOM  12513  O   GLN F 161      83.009  36.887  78.623  1.00 40.41           O  
ATOM  12514  CB  GLN F 161      85.259  36.629  77.058  1.00 41.19           C  
ATOM  12515  CG  GLN F 161      86.328  37.045  76.034  1.00 42.73           C  
ATOM  12516  CD  GLN F 161      85.964  36.639  74.613  1.00 43.21           C  
ATOM  12517  OE1 GLN F 161      85.498  35.527  74.368  1.00 47.08           O  
ATOM  12518  NE2 GLN F 161      86.153  37.550  73.674  1.00 46.57           N  
ATOM  12519  N   ALA F 162      84.191  37.208  80.535  1.00 40.03           N  
ATOM  12520  CA  ALA F 162      83.070  36.944  81.439  1.00 39.66           C  
ATOM  12521  C   ALA F 162      81.829  37.805  81.177  1.00 39.59           C  
ATOM  12522  O   ALA F 162      80.692  37.301  81.223  1.00 39.20           O  
ATOM  12523  CB  ALA F 162      83.520  37.086  82.890  1.00 39.98           C  
ATOM  12524  N   ASN F 163      82.040  39.095  80.913  1.00 39.34           N  
ATOM  12525  CA  ASN F 163      80.911  40.003  80.627  1.00 40.13           C  
ATOM  12526  C   ASN F 163      80.180  39.632  79.343  1.00 39.22           C  
ATOM  12527  O   ASN F 163      78.962  39.495  79.321  1.00 39.59           O  
ATOM  12528  CB  ASN F 163      81.360  41.484  80.592  1.00 40.36           C  
ATOM  12529  CG  ASN F 163      82.594  41.723  79.713  1.00 41.96           C  
ATOM  12530  OD1 ASN F 163      83.191  40.787  79.159  1.00 45.06           O  
ATOM  12531  ND2 ASN F 163      82.979  42.993  79.579  1.00 43.17           N  
ATOM  12532  N   TYR F 164      80.961  39.449  78.291  1.00 38.84           N  
ATOM  12533  CA  TYR F 164      80.508  39.102  76.958  1.00 38.52           C  
ATOM  12534  C   TYR F 164      79.812  37.743  76.962  1.00 38.25           C  
ATOM  12535  O   TYR F 164      78.698  37.595  76.434  1.00 38.16           O  
ATOM  12536  CB  TYR F 164      81.754  39.088  76.059  1.00 38.85           C  
ATOM  12537  CG  TYR F 164      81.556  38.794  74.588  1.00 39.03           C  
ATOM  12538  CD1 TYR F 164      81.021  39.763  73.725  1.00 39.06           C  
ATOM  12539  CD2 TYR F 164      81.977  37.571  74.043  1.00 38.93           C  
ATOM  12540  CE1 TYR F 164      80.875  39.513  72.353  1.00 39.69           C  
ATOM  12541  CE2 TYR F 164      81.831  37.305  72.678  1.00 39.83           C  
ATOM  12542  CZ  TYR F 164      81.282  38.281  71.833  1.00 39.73           C  
ATOM  12543  OH  TYR F 164      81.133  38.025  70.482  1.00 39.53           O  
ATOM  12544  N   SER F 165      80.442  36.755  77.597  1.00 38.18           N  
ATOM  12545  CA  SER F 165      79.860  35.408  77.639  1.00 38.69           C  
ATOM  12546  C   SER F 165      78.547  35.365  78.422  1.00 38.14           C  
ATOM  12547  O   SER F 165      77.652  34.590  78.071  1.00 38.34           O  
ATOM  12548  CB  SER F 165      80.839  34.396  78.207  1.00 38.41           C  
ATOM  12549  OG  SER F 165      81.020  34.660  79.584  1.00 42.67           O  
ATOM  12550  N   ALA F 166      78.435  36.189  79.465  1.00 37.83           N  
ATOM  12551  CA  ALA F 166      77.183  36.368  80.189  1.00 38.01           C  
ATOM  12552  C   ALA F 166      76.103  36.898  79.270  1.00 37.76           C  
ATOM  12553  O   ALA F 166      75.060  36.313  79.166  1.00 38.00           O  
ATOM  12554  CB  ALA F 166      77.366  37.310  81.368  1.00 37.92           C  
ATOM  12555  N   ALA F 167      76.389  37.993  78.580  1.00 37.78           N  
ATOM  12556  CA  ALA F 167      75.446  38.604  77.649  1.00 37.72           C  
ATOM  12557  C   ALA F 167      75.035  37.657  76.520  1.00 37.82           C  
ATOM  12558  O   ALA F 167      73.849  37.511  76.226  1.00 38.54           O  
ATOM  12559  CB  ALA F 167      76.026  39.916  77.088  1.00 37.28           C  
ATOM  12560  N   LYS F 168      76.012  36.999  75.918  1.00 37.52           N  
ATOM  12561  CA  LYS F 168      75.771  36.081  74.803  1.00 37.36           C  
ATOM  12562  C   LYS F 168      74.937  34.859  75.170  1.00 37.67           C  
ATOM  12563  O   LYS F 168      74.090  34.420  74.365  1.00 37.96           O  
ATOM  12564  CB  LYS F 168      77.110  35.668  74.154  1.00 36.88           C  
ATOM  12565  CG  LYS F 168      77.813  36.810  73.391  1.00 36.19           C  
ATOM  12566  CD  LYS F 168      76.843  37.608  72.483  1.00 37.46           C  
ATOM  12567  CE  LYS F 168      77.487  38.029  71.158  1.00 39.05           C  
ATOM  12568  NZ  LYS F 168      76.507  38.767  70.328  1.00 36.43           N  
ATOM  12569  N   LEU F 169      75.152  34.302  76.367  1.00 37.53           N  
ATOM  12570  CA  LEU F 169      74.316  33.178  76.777  1.00 37.88           C  
ATOM  12571  C   LEU F 169      72.925  33.653  77.222  1.00 37.79           C  
ATOM  12572  O   LEU F 169      71.934  32.940  77.052  1.00 37.96           O  
ATOM  12573  CB  LEU F 169      75.010  32.273  77.795  1.00 37.36           C  
ATOM  12574  CG  LEU F 169      74.659  30.788  77.608  1.00 39.80           C  
ATOM  12575  CD1 LEU F 169      75.060  30.218  76.206  1.00 38.53           C  
ATOM  12576  CD2 LEU F 169      75.203  29.902  78.763  1.00 38.15           C  
ATOM  12577  N   GLY F 170      72.855  34.873  77.758  1.00 37.39           N  
ATOM  12578  CA  GLY F 170      71.575  35.477  78.103  1.00 37.40           C  
ATOM  12579  C   GLY F 170      70.690  35.561  76.874  1.00 37.56           C  
ATOM  12580  O   GLY F 170      69.493  35.373  76.957  1.00 37.24           O  
ATOM  12581  N   LEU F 171      71.296  35.828  75.721  1.00 37.77           N  
ATOM  12582  CA  LEU F 171      70.558  35.907  74.462  1.00 37.78           C  
ATOM  12583  C   LEU F 171      69.897  34.585  74.111  1.00 37.96           C  
ATOM  12584  O   LEU F 171      68.736  34.556  73.645  1.00 37.83           O  
ATOM  12585  CB  LEU F 171      71.485  36.346  73.329  1.00 37.95           C  
ATOM  12586  CG  LEU F 171      71.847  37.812  73.374  1.00 37.47           C  
ATOM  12587  CD1 LEU F 171      73.066  38.086  72.472  1.00 36.38           C  
ATOM  12588  CD2 LEU F 171      70.608  38.571  72.952  1.00 35.73           C  
ATOM  12589  N   LEU F 172      70.630  33.494  74.345  1.00 38.24           N  
ATOM  12590  CA  LEU F 172      70.062  32.153  74.171  1.00 38.17           C  
ATOM  12591  C   LEU F 172      68.885  31.970  75.101  1.00 38.07           C  
ATOM  12592  O   LEU F 172      67.851  31.416  74.704  1.00 38.92           O  
ATOM  12593  CB  LEU F 172      71.120  31.054  74.363  1.00 37.96           C  
ATOM  12594  CG  LEU F 172      70.631  29.588  74.319  1.00 38.87           C  
ATOM  12595  CD1 LEU F 172      69.872  29.250  73.016  1.00 36.85           C  
ATOM  12596  CD2 LEU F 172      71.801  28.585  74.548  1.00 37.61           C  
ATOM  12597  N   GLY F 173      69.030  32.452  76.334  1.00 38.27           N  
ATOM  12598  CA  GLY F 173      67.964  32.357  77.329  1.00 38.07           C  
ATOM  12599  C   GLY F 173      66.708  33.074  76.876  1.00 38.19           C  
ATOM  12600  O   GLY F 173      65.591  32.600  77.101  1.00 38.19           O  
ATOM  12601  N   LEU F 174      66.909  34.237  76.258  1.00 37.98           N  
ATOM  12602  CA  LEU F 174      65.837  35.042  75.669  1.00 37.94           C  
ATOM  12603  C   LEU F 174      65.162  34.300  74.510  1.00 38.17           C  
ATOM  12604  O   LEU F 174      63.939  34.242  74.440  1.00 37.70           O  
ATOM  12605  CB  LEU F 174      66.404  36.385  75.204  1.00 37.63           C  
ATOM  12606  CG  LEU F 174      65.535  37.346  74.393  1.00 37.53           C  
ATOM  12607  CD1 LEU F 174      64.245  37.671  75.141  1.00 35.65           C  
ATOM  12608  CD2 LEU F 174      66.293  38.625  74.038  1.00 36.78           C  
ATOM  12609  N   ALA F 175      65.982  33.718  73.634  1.00 38.31           N  
ATOM  12610  CA  ALA F 175      65.501  32.941  72.493  1.00 38.69           C  
ATOM  12611  C   ALA F 175      64.675  31.718  72.909  1.00 38.96           C  
ATOM  12612  O   ALA F 175      63.638  31.423  72.283  1.00 39.41           O  
ATOM  12613  CB  ALA F 175      66.667  32.535  71.602  1.00 38.61           C  
ATOM  12614  N   ASN F 176      65.098  31.030  73.975  1.00 38.93           N  
ATOM  12615  CA  ASN F 176      64.403  29.827  74.431  1.00 38.71           C  
ATOM  12616  C   ASN F 176      62.947  30.134  74.725  1.00 38.64           C  
ATOM  12617  O   ASN F 176      62.054  29.344  74.409  1.00 38.55           O  
ATOM  12618  CB  ASN F 176      65.075  29.258  75.688  1.00 39.03           C  
ATOM  12619  CG  ASN F 176      66.440  28.653  75.409  1.00 40.25           C  
ATOM  12620  OD1 ASN F 176      66.732  28.261  74.286  1.00 40.70           O  
ATOM  12621  ND2 ASN F 176      67.270  28.543  76.449  1.00 40.49           N  
ATOM  12622  N   SER F 177      62.702  31.298  75.320  1.00 38.39           N  
ATOM  12623  CA  SER F 177      61.336  31.685  75.669  1.00 38.54           C  
ATOM  12624  C   SER F 177      60.527  32.250  74.505  1.00 38.23           C  
ATOM  12625  O   SER F 177      59.327  31.981  74.390  1.00 38.52           O  
ATOM  12626  CB  SER F 177      61.336  32.644  76.859  1.00 38.79           C  
ATOM  12627  OG  SER F 177      61.783  31.957  78.015  1.00 40.79           O  
ATOM  12628  N   LEU F 178      61.177  33.030  73.643  1.00 38.18           N  
ATOM  12629  CA  LEU F 178      60.517  33.574  72.441  1.00 37.97           C  
ATOM  12630  C   LEU F 178      60.017  32.479  71.508  1.00 37.81           C  
ATOM  12631  O   LEU F 178      58.897  32.575  70.981  1.00 38.19           O  
ATOM  12632  CB  LEU F 178      61.427  34.548  71.675  1.00 37.42           C  
ATOM  12633  CG  LEU F 178      61.821  35.791  72.469  1.00 37.96           C  
ATOM  12634  CD1 LEU F 178      62.740  36.734  71.664  1.00 36.99           C  
ATOM  12635  CD2 LEU F 178      60.565  36.511  73.001  1.00 36.72           C  
ATOM  12636  N   ALA F 179      60.835  31.448  71.327  1.00 37.38           N  
ATOM  12637  CA  ALA F 179      60.463  30.254  70.577  1.00 37.67           C  
ATOM  12638  C   ALA F 179      59.111  29.709  71.036  1.00 38.04           C  
ATOM  12639  O   ALA F 179      58.248  29.408  70.210  1.00 38.16           O  
ATOM  12640  CB  ALA F 179      61.539  29.185  70.738  1.00 37.63           C  
ATOM  12641  N   ILE F 180      58.933  29.611  72.354  1.00 38.20           N  
ATOM  12642  CA  ILE F 180      57.695  29.124  72.937  1.00 38.24           C  
ATOM  12643  C   ILE F 180      56.530  30.100  72.726  1.00 38.40           C  
ATOM  12644  O   ILE F 180      55.466  29.686  72.304  1.00 37.92           O  
ATOM  12645  CB  ILE F 180      57.838  28.769  74.443  1.00 38.43           C  
ATOM  12646  CG1 ILE F 180      58.934  27.725  74.642  1.00 37.39           C  
ATOM  12647  CG2 ILE F 180      56.480  28.296  75.038  1.00 39.23           C  
ATOM  12648  CD1 ILE F 180      59.360  27.592  76.088  1.00 38.19           C  
ATOM  12649  N   GLU F 181      56.741  31.385  73.010  1.00 38.64           N  
ATOM  12650  CA  GLU F 181      55.665  32.380  72.893  1.00 39.00           C  
ATOM  12651  C   GLU F 181      55.258  32.684  71.440  1.00 38.93           C  
ATOM  12652  O   GLU F 181      54.103  33.022  71.181  1.00 38.80           O  
ATOM  12653  CB  GLU F 181      56.018  33.680  73.633  1.00 39.18           C  
ATOM  12654  CG  GLU F 181      55.833  33.617  75.165  1.00 40.00           C  
ATOM  12655  CD  GLU F 181      56.145  34.939  75.891  1.00 39.95           C  
ATOM  12656  OE1 GLU F 181      55.659  36.001  75.428  1.00 40.19           O  
ATOM  12657  OE2 GLU F 181      56.862  34.909  76.930  1.00 40.53           O  
ATOM  12658  N   GLY F 182      56.188  32.514  70.509  1.00 39.01           N  
ATOM  12659  CA  GLY F 182      55.955  32.819  69.110  1.00 39.39           C  
ATOM  12660  C   GLY F 182      55.289  31.725  68.291  1.00 39.74           C  
ATOM  12661  O   GLY F 182      54.567  32.024  67.334  1.00 39.80           O  
ATOM  12662  N   ARG F 183      55.508  30.470  68.682  1.00 39.81           N  
ATOM  12663  CA  ARG F 183      55.207  29.308  67.830  1.00 39.95           C  
ATOM  12664  C   ARG F 183      53.786  29.269  67.239  1.00 39.98           C  
ATOM  12665  O   ARG F 183      53.621  29.083  66.032  1.00 39.87           O  
ATOM  12666  CB  ARG F 183      55.506  28.001  68.570  1.00 39.95           C  
ATOM  12667  N   LYS F 184      52.767  29.447  68.077  1.00 39.82           N  
ATOM  12668  CA  LYS F 184      51.374  29.397  67.606  1.00 39.59           C  
ATOM  12669  C   LYS F 184      51.056  30.508  66.608  1.00 39.34           C  
ATOM  12670  O   LYS F 184      50.065  30.425  65.880  1.00 39.30           O  
ATOM  12671  CB  LYS F 184      50.376  29.465  68.775  1.00 39.63           C  
ATOM  12672  CG  LYS F 184      50.336  28.230  69.674  1.00 40.38           C  
ATOM  12673  CD  LYS F 184      48.956  28.094  70.318  1.00 40.65           C  
ATOM  12674  N   SER F 185      51.884  31.547  66.585  1.00 38.86           N  
ATOM  12675  CA  SER F 185      51.672  32.679  65.678  1.00 38.52           C  
ATOM  12676  C   SER F 185      52.615  32.677  64.475  1.00 38.17           C  
ATOM  12677  O   SER F 185      52.778  33.700  63.819  1.00 37.91           O  
ATOM  12678  CB  SER F 185      51.814  33.998  66.435  1.00 38.62           C  
ATOM  12679  OG  SER F 185      50.886  34.054  67.492  1.00 38.51           O  
ATOM  12680  N   ASN F 186      53.234  31.531  64.194  1.00 37.84           N  
ATOM  12681  CA  ASN F 186      54.195  31.398  63.082  1.00 37.35           C  
ATOM  12682  C   ASN F 186      55.342  32.400  63.192  1.00 37.06           C  
ATOM  12683  O   ASN F 186      55.823  32.949  62.188  1.00 36.88           O  
ATOM  12684  CB  ASN F 186      53.483  31.481  61.709  1.00 37.68           C  
ATOM  12685  CG  ASN F 186      54.390  31.056  60.541  1.00 38.60           C  
ATOM  12686  OD1 ASN F 186      55.443  30.429  60.741  1.00 39.33           O  
ATOM  12687  ND2 ASN F 186      53.984  31.399  59.321  1.00 36.66           N  
ATOM  12688  N   ILE F 187      55.775  32.634  64.427  1.00 36.73           N  
ATOM  12689  CA  ILE F 187      56.940  33.436  64.691  1.00 36.63           C  
ATOM  12690  C   ILE F 187      58.010  32.499  65.250  1.00 36.69           C  
ATOM  12691  O   ILE F 187      57.792  31.850  66.267  1.00 36.70           O  
ATOM  12692  CB  ILE F 187      56.655  34.594  65.681  1.00 36.47           C  
ATOM  12693  CG1 ILE F 187      55.452  35.412  65.240  1.00 36.32           C  
ATOM  12694  CG2 ILE F 187      57.912  35.487  65.830  1.00 37.31           C  
ATOM  12695  CD1 ILE F 187      54.958  36.381  66.277  1.00 36.11           C  
ATOM  12696  N   HIS F 188      59.151  32.419  64.568  1.00 36.53           N  
ATOM  12697  CA  HIS F 188      60.216  31.522  64.995  1.00 36.63           C  
ATOM  12698  C   HIS F 188      61.414  32.309  65.484  1.00 36.94           C  
ATOM  12699  O   HIS F 188      61.747  33.357  64.946  1.00 37.22           O  
ATOM  12700  CB  HIS F 188      60.636  30.530  63.894  1.00 36.50           C  
ATOM  12701  CG  HIS F 188      59.516  29.698  63.344  1.00 35.83           C  
ATOM  12702  ND1 HIS F 188      59.561  29.145  62.082  1.00 36.28           N  
ATOM  12703  CD2 HIS F 188      58.313  29.343  63.865  1.00 37.38           C  
ATOM  12704  CE1 HIS F 188      58.440  28.479  61.853  1.00 38.07           C  
ATOM  12705  NE2 HIS F 188      57.668  28.577  62.922  1.00 36.79           N  
ATOM  12706  N   CYS F 189      62.061  31.802  66.523  1.00 37.11           N  
ATOM  12707  CA  CYS F 189      63.302  32.397  66.995  1.00 37.33           C  
ATOM  12708  C   CYS F 189      64.376  31.329  67.090  1.00 37.10           C  
ATOM  12709  O   CYS F 189      64.136  30.276  67.663  1.00 37.82           O  
ATOM  12710  CB  CYS F 189      63.083  33.063  68.348  1.00 37.24           C  
ATOM  12711  SG  CYS F 189      64.507  34.018  68.938  1.00 37.72           S  
ATOM  12712  N   ASN F 190      65.545  31.612  66.531  1.00 37.03           N  
ATOM  12713  CA  ASN F 190      66.672  30.683  66.562  1.00 37.36           C  
ATOM  12714  C   ASN F 190      67.954  31.416  66.929  1.00 37.70           C  
ATOM  12715  O   ASN F 190      68.018  32.641  66.848  1.00 38.22           O  
ATOM  12716  CB  ASN F 190      66.819  29.920  65.230  1.00 36.90           C  
ATOM  12717  CG  ASN F 190      65.646  28.978  64.969  1.00 37.91           C  
ATOM  12718  OD1 ASN F 190      65.457  27.982  65.672  1.00 37.14           O  
ATOM  12719  ND2 ASN F 190      64.842  29.301  63.958  1.00 37.51           N  
ATOM  12720  N   THR F 191      68.968  30.668  67.344  1.00 37.78           N  
ATOM  12721  CA  THR F 191      70.190  31.261  67.826  1.00 38.00           C  
ATOM  12722  C   THR F 191      71.362  30.683  67.081  1.00 38.08           C  
ATOM  12723  O   THR F 191      71.427  29.482  66.823  1.00 38.22           O  
ATOM  12724  CB  THR F 191      70.382  31.025  69.343  1.00 38.06           C  
ATOM  12725  OG1 THR F 191      69.261  31.561  70.045  1.00 39.12           O  
ATOM  12726  CG2 THR F 191      71.661  31.702  69.874  1.00 37.62           C  
ATOM  12727  N   ILE F 192      72.306  31.544  66.742  1.00 37.89           N  
ATOM  12728  CA  ILE F 192      73.483  31.086  66.079  1.00 37.97           C  
ATOM  12729  C   ILE F 192      74.685  31.457  66.918  1.00 38.32           C  
ATOM  12730  O   ILE F 192      74.644  32.424  67.697  1.00 38.72           O  
ATOM  12731  CB  ILE F 192      73.562  31.673  64.652  1.00 38.26           C  
ATOM  12732  CG1 ILE F 192      73.591  33.207  64.685  1.00 37.98           C  
ATOM  12733  CG2 ILE F 192      72.345  31.182  63.804  1.00 37.59           C  
ATOM  12734  CD1 ILE F 192      74.219  33.831  63.455  1.00 37.33           C  
ATOM  12735  N   ALA F 193      75.753  30.678  66.765  1.00 38.08           N  
ATOM  12736  CA  ALA F 193      77.034  31.032  67.323  1.00 38.25           C  
ATOM  12737  C   ALA F 193      78.050  30.961  66.183  1.00 38.38           C  
ATOM  12738  O   ALA F 193      78.549  29.894  65.856  1.00 38.41           O  
ATOM  12739  CB  ALA F 193      77.399  30.115  68.467  1.00 37.83           C  
ATOM  12740  N   PRO F 194      78.351  32.116  65.573  1.00 38.51           N  
ATOM  12741  CA  PRO F 194      79.105  32.168  64.341  1.00 38.43           C  
ATOM  12742  C   PRO F 194      80.621  32.247  64.529  1.00 39.29           C  
ATOM  12743  O   PRO F 194      81.125  32.430  65.658  1.00 39.80           O  
ATOM  12744  CB  PRO F 194      78.567  33.433  63.682  1.00 38.01           C  
ATOM  12745  CG  PRO F 194      78.143  34.327  64.824  1.00 38.36           C  
ATOM  12746  CD  PRO F 194      77.950  33.464  66.037  1.00 38.79           C  
ATOM  12747  N   ASN F 195      81.335  32.056  63.429  1.00 38.86           N  
ATOM  12748  CA  ASN F 195      82.785  32.216  63.392  1.00 39.03           C  
ATOM  12749  C   ASN F 195      83.136  32.874  62.065  1.00 38.83           C  
ATOM  12750  O   ASN F 195      82.929  32.293  60.987  1.00 38.57           O  
ATOM  12751  CB  ASN F 195      83.540  30.893  63.563  1.00 38.68           C  
ATOM  12752  CG  ASN F 195      83.247  30.219  64.886  1.00 39.64           C  
ATOM  12753  OD1 ASN F 195      83.905  30.474  65.905  1.00 37.93           O  
ATOM  12754  ND2 ASN F 195      82.243  29.349  64.883  1.00 40.41           N  
ATOM  12755  N   ALA F 196      83.642  34.100  62.152  1.00 38.62           N  
ATOM  12756  CA  ALA F 196      83.953  34.877  60.951  1.00 39.07           C  
ATOM  12757  C   ALA F 196      85.086  35.874  61.184  1.00 39.31           C  
ATOM  12758  O   ALA F 196      85.205  36.444  62.271  1.00 39.69           O  
ATOM  12759  CB  ALA F 196      82.681  35.590  60.464  1.00 38.71           C  
ATOM  12760  N   GLY F 197      85.944  36.056  60.177  1.00 39.95           N  
ATOM  12761  CA  GLY F 197      86.931  37.148  60.176  1.00 40.03           C  
ATOM  12762  C   GLY F 197      86.242  38.508  60.087  1.00 40.47           C  
ATOM  12763  O   GLY F 197      85.423  38.735  59.193  1.00 40.72           O  
ATOM  12764  N   SER F 198      86.543  39.399  61.031  1.00 40.32           N  
ATOM  12765  CA  SER F 198      86.029  40.769  61.025  1.00 40.54           C  
ATOM  12766  C   SER F 198      86.906  41.636  61.917  1.00 40.83           C  
ATOM  12767  O   SER F 198      87.907  41.158  62.453  1.00 40.84           O  
ATOM  12768  CB  SER F 198      84.592  40.817  61.527  1.00 40.40           C  
ATOM  12769  OG  SER F 198      84.598  40.533  62.900  1.00 41.40           O  
ATOM  12770  N   ARG F 199      86.544  42.910  62.074  1.00 41.51           N  
ATOM  12771  CA  ARG F 199      87.312  43.824  62.932  1.00 42.43           C  
ATOM  12772  C   ARG F 199      87.303  43.341  64.384  1.00 43.64           C  
ATOM  12773  O   ARG F 199      88.239  43.606  65.136  1.00 43.95           O  
ATOM  12774  CB  ARG F 199      86.778  45.259  62.839  1.00 42.22           C  
ATOM  12775  CG  ARG F 199      85.427  45.465  63.536  1.00 40.97           C  
ATOM  12776  CD  ARG F 199      84.852  46.824  63.245  1.00 38.92           C  
ATOM  12777  NE  ARG F 199      83.691  47.127  64.076  1.00 37.15           N  
ATOM  12778  CZ  ARG F 199      82.982  48.254  63.979  1.00 37.02           C  
ATOM  12779  NH1 ARG F 199      83.306  49.178  63.079  1.00 35.48           N  
ATOM  12780  NH2 ARG F 199      81.949  48.461  64.771  1.00 35.22           N  
ATOM  12781  N   MET F 200      86.240  42.632  64.767  1.00 45.05           N  
ATOM  12782  CA  MET F 200      86.140  42.083  66.115  1.00 46.60           C  
ATOM  12783  C   MET F 200      87.163  40.970  66.365  1.00 47.06           C  
ATOM  12784  O   MET F 200      87.755  40.889  67.446  1.00 47.41           O  
ATOM  12785  CB  MET F 200      84.722  41.606  66.434  1.00 46.05           C  
ATOM  12786  CG  MET F 200      83.925  42.579  67.339  1.00 46.73           C  
ATOM  12787  SD  MET F 200      82.330  41.943  67.954  1.00 48.06           S  
ATOM  12788  CE  MET F 200      82.821  40.285  68.445  1.00 46.31           C  
ATOM  12789  N   THR F 201      87.386  40.133  65.360  1.00 47.61           N  
ATOM  12790  CA  THR F 201      88.196  38.940  65.550  1.00 48.06           C  
ATOM  12791  C   THR F 201      89.647  39.117  65.107  1.00 48.93           C  
ATOM  12792  O   THR F 201      90.468  38.236  65.337  1.00 48.33           O  
ATOM  12793  CB  THR F 201      87.594  37.722  64.837  1.00 48.03           C  
ATOM  12794  OG1 THR F 201      87.409  38.022  63.451  1.00 47.55           O  
ATOM  12795  CG2 THR F 201      86.228  37.328  65.449  1.00 47.95           C  
ATOM  12796  N   GLN F 202      89.950  40.251  64.479  1.00 50.09           N  
ATOM  12797  CA  GLN F 202      91.314  40.556  64.010  1.00 51.81           C  
ATOM  12798  C   GLN F 202      92.353  40.481  65.117  1.00 52.24           C  
ATOM  12799  O   GLN F 202      93.494  40.134  64.862  1.00 52.38           O  
ATOM  12800  CB  GLN F 202      91.386  41.930  63.344  1.00 51.54           C  
ATOM  12801  CG  GLN F 202      91.100  41.908  61.860  1.00 52.46           C  
ATOM  12802  CD  GLN F 202      90.945  43.301  61.250  1.00 53.14           C  
ATOM  12803  OE1 GLN F 202      90.879  44.312  61.964  1.00 54.54           O  
ATOM  12804  NE2 GLN F 202      90.872  43.355  59.917  1.00 53.62           N  
ATOM  12805  N   THR F 203      91.930  40.798  66.340  1.00 53.26           N  
ATOM  12806  CA  THR F 203      92.785  40.785  67.523  1.00 54.04           C  
ATOM  12807  C   THR F 203      93.260  39.383  67.914  1.00 54.13           C  
ATOM  12808  O   THR F 203      94.395  39.214  68.374  1.00 54.59           O  
ATOM  12809  CB  THR F 203      92.065  41.455  68.726  1.00 54.24           C  
ATOM  12810  OG1 THR F 203      90.654  41.161  68.693  1.00 55.06           O  
ATOM  12811  CG2 THR F 203      92.259  42.968  68.671  1.00 55.01           C  
ATOM  12812  N   VAL F 204      92.410  38.382  67.707  1.00 53.96           N  
ATOM  12813  CA  VAL F 204      92.724  37.019  68.137  1.00 53.77           C  
ATOM  12814  C   VAL F 204      93.092  36.069  67.002  1.00 53.48           C  
ATOM  12815  O   VAL F 204      93.585  34.973  67.258  1.00 53.88           O  
ATOM  12816  CB  VAL F 204      91.591  36.399  68.992  1.00 54.01           C  
ATOM  12817  CG1 VAL F 204      91.438  37.180  70.308  1.00 54.24           C  
ATOM  12818  CG2 VAL F 204      90.273  36.321  68.205  1.00 53.46           C  
ATOM  12819  N   MET F 205      92.867  36.494  65.761  1.00 52.73           N  
ATOM  12820  CA  MET F 205      93.097  35.645  64.587  1.00 52.34           C  
ATOM  12821  C   MET F 205      94.221  36.174  63.710  1.00 51.38           C  
ATOM  12822  O   MET F 205      94.292  37.379  63.475  1.00 51.28           O  
ATOM  12823  CB  MET F 205      91.837  35.591  63.736  1.00 52.13           C  
ATOM  12824  CG  MET F 205      90.730  34.775  64.310  1.00 52.27           C  
ATOM  12825  SD  MET F 205      89.721  34.192  62.933  1.00 53.91           S  
ATOM  12826  CE  MET F 205      88.274  35.215  63.034  1.00 52.03           C  
ATOM  12827  N   PRO F 206      95.074  35.280  63.183  1.00 50.66           N  
ATOM  12828  CA  PRO F 206      96.050  35.729  62.179  1.00 50.17           C  
ATOM  12829  C   PRO F 206      95.380  36.214  60.884  1.00 49.72           C  
ATOM  12830  O   PRO F 206      94.295  35.734  60.515  1.00 49.43           O  
ATOM  12831  CB  PRO F 206      96.913  34.482  61.925  1.00 50.23           C  
ATOM  12832  CG  PRO F 206      96.611  33.546  63.057  1.00 50.66           C  
ATOM  12833  CD  PRO F 206      95.193  33.838  63.456  1.00 50.36           C  
ATOM  12834  N   GLU F 207      96.034  37.153  60.207  1.00 49.10           N  
ATOM  12835  CA  GLU F 207      95.483  37.829  59.028  1.00 48.73           C  
ATOM  12836  C   GLU F 207      94.896  36.903  57.954  1.00 48.37           C  
ATOM  12837  O   GLU F 207      93.813  37.183  57.429  1.00 47.79           O  
ATOM  12838  CB  GLU F 207      96.515  38.768  58.398  1.00 48.37           C  
ATOM  12839  N   ASP F 208      95.615  35.822  57.634  1.00 47.79           N  
ATOM  12840  CA  ASP F 208      95.164  34.856  56.630  1.00 47.33           C  
ATOM  12841  C   ASP F 208      93.906  34.098  57.039  1.00 46.95           C  
ATOM  12842  O   ASP F 208      93.094  33.753  56.178  1.00 46.68           O  
ATOM  12843  CB  ASP F 208      96.269  33.874  56.247  1.00 47.59           C  
ATOM  12844  CG  ASP F 208      96.832  33.121  57.441  1.00 48.23           C  
ATOM  12845  OD1 ASP F 208      96.794  33.638  58.583  1.00 46.54           O  
ATOM  12846  OD2 ASP F 208      97.338  32.005  57.211  1.00 50.65           O  
ATOM  12847  N   LEU F 209      93.756  33.849  58.340  1.00 46.32           N  
ATOM  12848  CA  LEU F 209      92.557  33.229  58.879  1.00 46.22           C  
ATOM  12849  C   LEU F 209      91.352  34.192  58.808  1.00 45.57           C  
ATOM  12850  O   LEU F 209      90.296  33.800  58.325  1.00 45.91           O  
ATOM  12851  CB  LEU F 209      92.812  32.677  60.290  1.00 45.96           C  
ATOM  12852  CG  LEU F 209      91.685  31.831  60.911  1.00 47.59           C  
ATOM  12853  CD1 LEU F 209      91.465  30.537  60.112  1.00 48.05           C  
ATOM  12854  CD2 LEU F 209      91.952  31.532  62.392  1.00 46.41           C  
ATOM  12855  N   VAL F 210      91.528  35.441  59.250  1.00 44.80           N  
ATOM  12856  CA  VAL F 210      90.534  36.517  59.073  1.00 44.33           C  
ATOM  12857  C   VAL F 210      89.930  36.521  57.654  1.00 44.23           C  
ATOM  12858  O   VAL F 210      88.700  36.556  57.483  1.00 43.87           O  
ATOM  12859  CB  VAL F 210      91.151  37.932  59.354  1.00 44.18           C  
ATOM  12860  CG1 VAL F 210      90.177  39.049  58.972  1.00 43.92           C  
ATOM  12861  CG2 VAL F 210      91.578  38.080  60.806  1.00 43.88           C  
ATOM  12862  N   GLU F 211      90.823  36.491  56.657  1.00 43.73           N  
ATOM  12863  CA  GLU F 211      90.474  36.448  55.233  1.00 43.45           C  
ATOM  12864  C   GLU F 211      89.711  35.176  54.874  1.00 43.00           C  
ATOM  12865  O   GLU F 211      88.737  35.224  54.130  1.00 43.44           O  
ATOM  12866  CB  GLU F 211      91.758  36.483  54.358  1.00 43.10           C  
ATOM  12867  CG  GLU F 211      92.390  37.842  54.074  1.00 42.01           C  
ATOM  12868  CD  GLU F 211      93.867  37.728  53.550  1.00 43.20           C  
ATOM  12869  OE1 GLU F 211      94.621  36.847  54.025  1.00 40.03           O  
ATOM  12870  OE2 GLU F 211      94.276  38.532  52.674  1.00 41.96           O  
ATOM  12871  N   ALA F 212      90.170  34.036  55.383  1.00 42.38           N  
ATOM  12872  CA  ALA F 212      89.580  32.756  55.004  1.00 42.09           C  
ATOM  12873  C   ALA F 212      88.209  32.457  55.644  1.00 41.56           C  
ATOM  12874  O   ALA F 212      87.363  31.847  54.991  1.00 41.60           O  
ATOM  12875  CB  ALA F 212      90.543  31.611  55.241  1.00 42.10           C  
ATOM  12876  N   LEU F 213      88.003  32.873  56.897  1.00 40.89           N  
ATOM  12877  CA  LEU F 213      86.737  32.631  57.606  1.00 40.61           C  
ATOM  12878  C   LEU F 213      85.676  33.661  57.220  1.00 40.03           C  
ATOM  12879  O   LEU F 213      85.362  34.562  57.981  1.00 39.56           O  
ATOM  12880  CB  LEU F 213      86.929  32.650  59.128  1.00 40.71           C  
ATOM  12881  CG  LEU F 213      87.102  31.343  59.914  1.00 40.74           C  
ATOM  12882  CD1 LEU F 213      87.216  31.626  61.403  1.00 40.16           C  
ATOM  12883  CD2 LEU F 213      86.014  30.354  59.639  1.00 40.01           C  
ATOM  12884  N   LYS F 214      85.141  33.529  56.021  1.00 39.53           N  
ATOM  12885  CA  LYS F 214      84.278  34.561  55.484  1.00 39.49           C  
ATOM  12886  C   LYS F 214      82.891  34.571  56.152  1.00 39.03           C  
ATOM  12887  O   LYS F 214      82.348  33.527  56.420  1.00 38.89           O  
ATOM  12888  CB  LYS F 214      84.168  34.403  53.971  1.00 39.74           C  
ATOM  12889  CG  LYS F 214      85.535  34.272  53.304  1.00 39.89           C  
ATOM  12890  CD  LYS F 214      85.488  34.506  51.812  1.00 41.94           C  
ATOM  12891  CE  LYS F 214      86.923  34.531  51.241  1.00 44.11           C  
ATOM  12892  NZ  LYS F 214      86.947  34.446  49.764  1.00 46.50           N  
ATOM  12893  N   PRO F 215      82.366  35.765  56.460  1.00 38.78           N  
ATOM  12894  CA  PRO F 215      80.989  35.969  56.931  1.00 39.39           C  
ATOM  12895  C   PRO F 215      79.959  35.416  55.951  1.00 39.79           C  
ATOM  12896  O   PRO F 215      78.859  35.048  56.344  1.00 40.22           O  
ATOM  12897  CB  PRO F 215      80.860  37.493  57.018  1.00 39.07           C  
ATOM  12898  CG  PRO F 215      82.038  38.030  56.232  1.00 39.12           C  
ATOM  12899  CD  PRO F 215      83.111  37.033  56.387  1.00 38.52           C  
ATOM  12900  N   GLU F 216      80.332  35.341  54.680  1.00 40.38           N  
ATOM  12901  CA  GLU F 216      79.485  34.752  53.633  1.00 40.65           C  
ATOM  12902  C   GLU F 216      79.268  33.257  53.854  1.00 39.90           C  
ATOM  12903  O   GLU F 216      78.410  32.656  53.208  1.00 39.80           O  
ATOM  12904  CB  GLU F 216      80.137  34.941  52.254  1.00 40.95           C  
ATOM  12905  CG  GLU F 216      80.162  36.381  51.752  1.00 44.67           C  
ATOM  12906  CD  GLU F 216      81.204  37.266  52.459  1.00 48.71           C  
ATOM  12907  OE1 GLU F 216      82.278  36.763  52.872  1.00 49.04           O  
ATOM  12908  OE2 GLU F 216      80.937  38.485  52.585  1.00 51.08           O  
ATOM  12909  N   TYR F 217      80.069  32.644  54.730  1.00 38.75           N  
ATOM  12910  CA  TYR F 217      79.828  31.241  55.069  1.00 37.91           C  
ATOM  12911  C   TYR F 217      78.767  31.065  56.163  1.00 37.52           C  
ATOM  12912  O   TYR F 217      78.364  29.944  56.487  1.00 37.48           O  
ATOM  12913  CB  TYR F 217      81.123  30.497  55.425  1.00 36.96           C  
ATOM  12914  CG  TYR F 217      82.206  30.565  54.372  1.00 36.59           C  
ATOM  12915  CD1 TYR F 217      81.897  30.738  53.022  1.00 35.62           C  
ATOM  12916  CD2 TYR F 217      83.550  30.442  54.731  1.00 35.28           C  
ATOM  12917  CE1 TYR F 217      82.913  30.806  52.055  1.00 36.21           C  
ATOM  12918  CE2 TYR F 217      84.559  30.503  53.785  1.00 35.43           C  
ATOM  12919  CZ  TYR F 217      84.235  30.680  52.455  1.00 35.24           C  
ATOM  12920  OH  TYR F 217      85.227  30.745  51.536  1.00 36.56           O  
ATOM  12921  N   VAL F 218      78.309  32.179  56.721  1.00 37.33           N  
ATOM  12922  CA  VAL F 218      77.348  32.146  57.812  1.00 36.91           C  
ATOM  12923  C   VAL F 218      75.966  32.586  57.318  1.00 37.36           C  
ATOM  12924  O   VAL F 218      74.930  32.037  57.731  1.00 37.38           O  
ATOM  12925  CB  VAL F 218      77.854  32.991  59.012  1.00 36.69           C  
ATOM  12926  CG1 VAL F 218      76.805  33.060  60.150  1.00 34.38           C  
ATOM  12927  CG2 VAL F 218      79.188  32.428  59.532  1.00 35.04           C  
ATOM  12928  N   ALA F 219      75.977  33.562  56.417  1.00 37.42           N  
ATOM  12929  CA  ALA F 219      74.765  34.119  55.817  1.00 37.71           C  
ATOM  12930  C   ALA F 219      73.754  33.074  55.250  1.00 37.63           C  
ATOM  12931  O   ALA F 219      72.546  33.202  55.491  1.00 38.42           O  
ATOM  12932  CB  ALA F 219      75.141  35.190  54.779  1.00 37.47           C  
ATOM  12933  N   PRO F 220      74.233  32.025  54.534  1.00 37.52           N  
ATOM  12934  CA  PRO F 220      73.266  30.996  54.079  1.00 36.94           C  
ATOM  12935  C   PRO F 220      72.430  30.356  55.215  1.00 36.86           C  
ATOM  12936  O   PRO F 220      71.245  30.051  55.004  1.00 36.97           O  
ATOM  12937  CB  PRO F 220      74.149  29.936  53.387  1.00 36.85           C  
ATOM  12938  CG  PRO F 220      75.453  30.605  53.086  1.00 37.62           C  
ATOM  12939  CD  PRO F 220      75.620  31.714  54.111  1.00 37.42           C  
ATOM  12940  N   LEU F 221      73.022  30.152  56.397  1.00 36.15           N  
ATOM  12941  CA  LEU F 221      72.255  29.642  57.544  1.00 35.58           C  
ATOM  12942  C   LEU F 221      71.185  30.647  57.974  1.00 35.44           C  
ATOM  12943  O   LEU F 221      70.009  30.282  58.132  1.00 35.25           O  
ATOM  12944  CB  LEU F 221      73.152  29.289  58.738  1.00 35.55           C  
ATOM  12945  CG  LEU F 221      72.465  28.868  60.057  1.00 35.76           C  
ATOM  12946  CD1 LEU F 221      71.602  27.619  59.858  1.00 35.51           C  
ATOM  12947  CD2 LEU F 221      73.483  28.598  61.150  1.00 35.53           C  
ATOM  12948  N   VAL F 222      71.600  31.903  58.144  1.00 35.02           N  
ATOM  12949  CA  VAL F 222      70.696  32.971  58.565  1.00 35.14           C  
ATOM  12950  C   VAL F 222      69.509  33.080  57.597  1.00 35.62           C  
ATOM  12951  O   VAL F 222      68.365  33.188  58.024  1.00 35.68           O  
ATOM  12952  CB  VAL F 222      71.443  34.321  58.686  1.00 35.23           C  
ATOM  12953  CG1 VAL F 222      70.486  35.485  58.932  1.00 34.11           C  
ATOM  12954  CG2 VAL F 222      72.498  34.238  59.783  1.00 34.93           C  
ATOM  12955  N   LEU F 223      69.779  33.038  56.294  1.00 36.05           N  
ATOM  12956  CA  LEU F 223      68.687  33.149  55.322  1.00 36.31           C  
ATOM  12957  C   LEU F 223      67.736  31.970  55.392  1.00 36.85           C  
ATOM  12958  O   LEU F 223      66.511  32.171  55.378  1.00 37.55           O  
ATOM  12959  CB  LEU F 223      69.187  33.410  53.893  1.00 36.07           C  
ATOM  12960  CG  LEU F 223      69.271  34.873  53.424  1.00 35.23           C  
ATOM  12961  CD1 LEU F 223      70.299  35.707  54.196  1.00 35.56           C  
ATOM  12962  CD2 LEU F 223      69.593  34.906  51.951  1.00 35.60           C  
ATOM  12963  N   TRP F 224      68.283  30.755  55.509  1.00 36.94           N  
ATOM  12964  CA  TRP F 224      67.456  29.551  55.688  1.00 36.94           C  
ATOM  12965  C   TRP F 224      66.563  29.639  56.931  1.00 37.12           C  
ATOM  12966  O   TRP F 224      65.346  29.455  56.847  1.00 36.79           O  
ATOM  12967  CB  TRP F 224      68.310  28.276  55.727  1.00 37.03           C  
ATOM  12968  CG  TRP F 224      67.540  27.084  56.226  1.00 37.87           C  
ATOM  12969  CD1 TRP F 224      67.878  26.273  57.261  1.00 37.48           C  
ATOM  12970  CD2 TRP F 224      66.256  26.600  55.732  1.00 37.74           C  
ATOM  12971  NE1 TRP F 224      66.896  25.303  57.443  1.00 37.47           N  
ATOM  12972  CE2 TRP F 224      65.899  25.480  56.518  1.00 38.12           C  
ATOM  12973  CE3 TRP F 224      65.395  26.997  54.694  1.00 38.53           C  
ATOM  12974  CZ2 TRP F 224      64.705  24.746  56.302  1.00 37.42           C  
ATOM  12975  CZ3 TRP F 224      64.194  26.274  54.485  1.00 38.11           C  
ATOM  12976  CH2 TRP F 224      63.872  25.162  55.290  1.00 37.75           C  
ATOM  12977  N   LEU F 225      67.169  29.950  58.074  1.00 37.23           N  
ATOM  12978  CA  LEU F 225      66.420  30.075  59.332  1.00 37.55           C  
ATOM  12979  C   LEU F 225      65.339  31.168  59.310  1.00 37.99           C  
ATOM  12980  O   LEU F 225      64.376  31.137  60.094  1.00 38.77           O  
ATOM  12981  CB  LEU F 225      67.401  30.305  60.490  1.00 37.30           C  
ATOM  12982  CG  LEU F 225      68.247  29.099  60.918  1.00 37.22           C  
ATOM  12983  CD1 LEU F 225      69.349  29.535  61.869  1.00 36.50           C  
ATOM  12984  CD2 LEU F 225      67.376  28.008  61.596  1.00 35.88           C  
ATOM  12985  N   CYS F 226      65.503  32.126  58.395  1.00 38.00           N  
ATOM  12986  CA  CYS F 226      64.610  33.272  58.290  1.00 37.91           C  
ATOM  12987  C   CYS F 226      63.632  33.147  57.155  1.00 37.60           C  
ATOM  12988  O   CYS F 226      62.888  34.076  56.887  1.00 37.78           O  
ATOM  12989  CB  CYS F 226      65.414  34.552  58.124  1.00 37.42           C  
ATOM  12990  SG  CYS F 226      66.290  34.990  59.610  1.00 38.58           S  
ATOM  12991  N   HIS F 227      63.634  32.002  56.482  1.00 37.73           N  
ATOM  12992  CA  HIS F 227      62.739  31.784  55.337  1.00 37.48           C  
ATOM  12993  C   HIS F 227      61.339  31.316  55.771  1.00 37.76           C  
ATOM  12994  O   HIS F 227      61.167  30.623  56.790  1.00 37.69           O  
ATOM  12995  CB  HIS F 227      63.370  30.812  54.333  1.00 36.82           C  
ATOM  12996  CG  HIS F 227      62.739  30.856  52.980  1.00 36.44           C  
ATOM  12997  ND1 HIS F 227      61.727  29.996  52.602  1.00 36.21           N  
ATOM  12998  CD2 HIS F 227      62.941  31.687  51.927  1.00 35.07           C  
ATOM  12999  CE1 HIS F 227      61.349  30.284  51.368  1.00 34.75           C  
ATOM  13000  NE2 HIS F 227      62.070  31.303  50.936  1.00 33.32           N  
ATOM  13001  N   GLU F 228      60.334  31.700  54.993  1.00 38.24           N  
ATOM  13002  CA  GLU F 228      58.943  31.308  55.245  1.00 39.00           C  
ATOM  13003  C   GLU F 228      58.753  29.788  55.333  1.00 38.76           C  
ATOM  13004  O   GLU F 228      57.952  29.313  56.119  1.00 38.87           O  
ATOM  13005  CB  GLU F 228      57.990  31.946  54.205  1.00 39.05           C  
ATOM  13006  CG  GLU F 228      58.153  31.469  52.755  1.00 39.78           C  
ATOM  13007  CD  GLU F 228      56.936  31.776  51.863  1.00 41.46           C  
ATOM  13008  OE1 GLU F 228      56.007  32.512  52.292  1.00 44.93           O  
ATOM  13009  OE2 GLU F 228      56.896  31.274  50.710  1.00 43.92           O  
ATOM  13010  N   SER F 229      59.525  29.037  54.550  1.00 39.02           N  
ATOM  13011  CA  SER F 229      59.412  27.573  54.488  1.00 39.18           C  
ATOM  13012  C   SER F 229      60.148  26.847  55.626  1.00 39.37           C  
ATOM  13013  O   SER F 229      59.990  25.633  55.798  1.00 39.38           O  
ATOM  13014  CB  SER F 229      59.945  27.061  53.140  1.00 39.46           C  
ATOM  13015  OG  SER F 229      61.367  27.181  53.067  1.00 37.71           O  
ATOM  13016  N   CYS F 230      60.971  27.578  56.383  1.00 39.40           N  
ATOM  13017  CA  CYS F 230      61.694  26.979  57.507  1.00 39.57           C  
ATOM  13018  C   CYS F 230      60.753  26.715  58.677  1.00 39.54           C  
ATOM  13019  O   CYS F 230      59.952  27.568  59.050  1.00 39.41           O  
ATOM  13020  CB  CYS F 230      62.860  27.867  57.954  1.00 39.56           C  
ATOM  13021  SG  CYS F 230      63.866  27.195  59.311  1.00 39.16           S  
ATOM  13022  N   GLU F 231      60.857  25.518  59.245  1.00 39.79           N  
ATOM  13023  CA  GLU F 231      60.059  25.141  60.412  1.00 40.00           C  
ATOM  13024  C   GLU F 231      60.894  25.094  61.707  1.00 39.55           C  
ATOM  13025  O   GLU F 231      60.333  24.959  62.800  1.00 39.41           O  
ATOM  13026  CB  GLU F 231      59.354  23.813  60.174  1.00 40.14           C  
ATOM  13027  CG  GLU F 231      58.425  23.821  58.964  1.00 42.94           C  
ATOM  13028  CD  GLU F 231      57.558  22.592  58.901  1.00 46.42           C  
ATOM  13029  OE1 GLU F 231      57.957  21.548  59.476  1.00 48.68           O  
ATOM  13030  OE2 GLU F 231      56.474  22.675  58.287  1.00 48.88           O  
ATOM  13031  N   GLU F 232      62.217  25.214  61.594  1.00 38.71           N  
ATOM  13032  CA  GLU F 232      63.070  25.210  62.784  1.00 38.42           C  
ATOM  13033  C   GLU F 232      62.763  26.377  63.716  1.00 38.26           C  
ATOM  13034  O   GLU F 232      62.658  27.528  63.290  1.00 38.13           O  
ATOM  13035  CB  GLU F 232      64.561  25.226  62.425  1.00 38.47           C  
ATOM  13036  CG  GLU F 232      65.432  24.802  63.588  1.00 38.75           C  
ATOM  13037  CD  GLU F 232      65.488  23.286  63.773  1.00 41.38           C  
ATOM  13038  OE1 GLU F 232      64.971  22.552  62.897  1.00 40.77           O  
ATOM  13039  OE2 GLU F 232      66.062  22.826  64.799  1.00 43.45           O  
ATOM  13040  N   ASN F 233      62.643  26.070  64.998  1.00 38.03           N  
ATOM  13041  CA  ASN F 233      62.242  27.043  66.010  1.00 38.07           C  
ATOM  13042  C   ASN F 233      62.919  26.654  67.304  1.00 38.25           C  
ATOM  13043  O   ASN F 233      62.871  25.493  67.698  1.00 38.18           O  
ATOM  13044  CB  ASN F 233      60.699  27.052  66.187  1.00 37.46           C  
ATOM  13045  CG  ASN F 233      60.196  28.204  67.071  1.00 37.31           C  
ATOM  13046  OD1 ASN F 233      60.887  29.186  67.303  1.00 37.95           O  
ATOM  13047  ND2 ASN F 233      58.976  28.075  67.561  1.00 39.84           N  
ATOM  13048  N   GLY F 234      63.579  27.617  67.949  1.00 38.19           N  
ATOM  13049  CA  GLY F 234      64.225  27.378  69.234  1.00 37.83           C  
ATOM  13050  C   GLY F 234      65.517  26.598  69.157  1.00 38.20           C  
ATOM  13051  O   GLY F 234      65.947  25.999  70.169  1.00 38.35           O  
ATOM  13052  N   GLY F 235      66.152  26.608  67.985  1.00 37.68           N  
ATOM  13053  CA  GLY F 235      67.401  25.881  67.793  1.00 36.84           C  
ATOM  13054  C   GLY F 235      68.640  26.705  68.097  1.00 37.02           C  
ATOM  13055  O   GLY F 235      68.598  27.935  68.128  1.00 36.74           O  
ATOM  13056  N   LEU F 236      69.748  26.013  68.335  1.00 36.30           N  
ATOM  13057  CA  LEU F 236      71.032  26.652  68.572  1.00 36.10           C  
ATOM  13058  C   LEU F 236      72.042  26.009  67.637  1.00 36.27           C  
ATOM  13059  O   LEU F 236      72.216  24.777  67.636  1.00 36.02           O  
ATOM  13060  CB  LEU F 236      71.463  26.528  70.036  1.00 36.03           C  
ATOM  13061  CG  LEU F 236      72.940  26.888  70.333  1.00 36.35           C  
ATOM  13062  CD1 LEU F 236      73.262  28.362  70.076  1.00 35.43           C  
ATOM  13063  CD2 LEU F 236      73.340  26.481  71.780  1.00 34.70           C  
ATOM  13064  N   PHE F 237      72.667  26.844  66.812  1.00 36.12           N  
ATOM  13065  CA  PHE F 237      73.564  26.372  65.766  1.00 36.26           C  
ATOM  13066  C   PHE F 237      74.949  26.979  65.859  1.00 36.54           C  
ATOM  13067  O   PHE F 237      75.063  28.174  66.070  1.00 36.65           O  
ATOM  13068  CB  PHE F 237      72.948  26.655  64.400  1.00 35.17           C  
ATOM  13069  CG  PHE F 237      71.638  26.002  64.229  1.00 35.90           C  
ATOM  13070  CD1 PHE F 237      70.448  26.700  64.517  1.00 31.87           C  
ATOM  13071  CD2 PHE F 237      71.570  24.672  63.866  1.00 33.89           C  
ATOM  13072  CE1 PHE F 237      69.253  26.094  64.423  1.00 32.50           C  
ATOM  13073  CE2 PHE F 237      70.322  24.054  63.760  1.00 34.01           C  
ATOM  13074  CZ  PHE F 237      69.166  24.774  64.042  1.00 33.81           C  
ATOM  13075  N   GLU F 238      75.981  26.148  65.715  1.00 36.84           N  
ATOM  13076  CA  GLU F 238      77.346  26.634  65.515  1.00 37.89           C  
ATOM  13077  C   GLU F 238      77.663  26.561  64.013  1.00 38.09           C  
ATOM  13078  O   GLU F 238      77.257  25.618  63.319  1.00 37.93           O  
ATOM  13079  CB  GLU F 238      78.374  25.852  66.329  1.00 37.78           C  
ATOM  13080  CG  GLU F 238      78.341  26.135  67.828  1.00 40.65           C  
ATOM  13081  CD  GLU F 238      79.625  25.688  68.528  1.00 44.75           C  
ATOM  13082  OE1 GLU F 238      80.656  26.391  68.427  1.00 47.32           O  
ATOM  13083  OE2 GLU F 238      79.615  24.631  69.184  1.00 46.09           O  
ATOM  13084  N   VAL F 239      78.383  27.562  63.519  1.00 37.75           N  
ATOM  13085  CA  VAL F 239      78.454  27.819  62.089  1.00 37.32           C  
ATOM  13086  C   VAL F 239      79.713  28.591  61.735  1.00 37.55           C  
ATOM  13087  O   VAL F 239      80.043  29.617  62.368  1.00 37.58           O  
ATOM  13088  CB  VAL F 239      77.170  28.572  61.610  1.00 37.16           C  
ATOM  13089  CG1 VAL F 239      76.878  29.790  62.514  1.00 36.46           C  
ATOM  13090  CG2 VAL F 239      77.262  28.969  60.150  1.00 36.34           C  
ATOM  13091  N   GLY F 240      80.436  28.075  60.748  1.00 37.61           N  
ATOM  13092  CA  GLY F 240      81.652  28.715  60.262  1.00 37.58           C  
ATOM  13093  C   GLY F 240      82.309  27.864  59.197  1.00 37.97           C  
ATOM  13094  O   GLY F 240      82.140  26.637  59.199  1.00 37.94           O  
ATOM  13095  N   ALA F 241      83.038  28.529  58.296  1.00 37.82           N  
ATOM  13096  CA  ALA F 241      83.969  27.892  57.334  1.00 38.04           C  
ATOM  13097  C   ALA F 241      83.280  27.086  56.234  1.00 38.05           C  
ATOM  13098  O   ALA F 241      83.947  26.546  55.349  1.00 38.38           O  
ATOM  13099  CB  ALA F 241      84.999  27.026  58.049  1.00 37.83           C  
ATOM  13100  N   GLY F 242      81.951  26.996  56.300  1.00 37.83           N  
ATOM  13101  CA  GLY F 242      81.185  26.167  55.371  1.00 37.16           C  
ATOM  13102  C   GLY F 242      80.474  24.998  56.033  1.00 36.82           C  
ATOM  13103  O   GLY F 242      79.788  24.226  55.367  1.00 37.21           O  
ATOM  13104  N   TRP F 243      80.672  24.872  57.343  1.00 36.55           N  
ATOM  13105  CA  TRP F 243      80.072  23.836  58.195  1.00 36.14           C  
ATOM  13106  C   TRP F 243      78.957  24.421  59.059  1.00 36.00           C  
ATOM  13107  O   TRP F 243      79.002  25.601  59.417  1.00 36.04           O  
ATOM  13108  CB  TRP F 243      81.154  23.253  59.105  1.00 36.06           C  
ATOM  13109  CG  TRP F 243      80.695  22.220  60.103  1.00 35.27           C  
ATOM  13110  CD1 TRP F 243      80.585  20.873  59.897  1.00 35.12           C  
ATOM  13111  CD2 TRP F 243      80.318  22.450  61.467  1.00 35.06           C  
ATOM  13112  NE1 TRP F 243      80.167  20.250  61.047  1.00 34.68           N  
ATOM  13113  CE2 TRP F 243      79.994  21.195  62.028  1.00 35.37           C  
ATOM  13114  CE3 TRP F 243      80.207  23.597  62.266  1.00 36.00           C  
ATOM  13115  CZ2 TRP F 243      79.568  21.051  63.360  1.00 34.92           C  
ATOM  13116  CZ3 TRP F 243      79.797  23.450  63.613  1.00 35.67           C  
ATOM  13117  CH2 TRP F 243      79.471  22.187  64.128  1.00 35.69           C  
ATOM  13118  N   ILE F 244      77.955  23.601  59.366  1.00 36.12           N  
ATOM  13119  CA  ILE F 244      76.904  23.939  60.364  1.00 36.54           C  
ATOM  13120  C   ILE F 244      76.643  22.715  61.242  1.00 36.69           C  
ATOM  13121  O   ILE F 244      76.566  21.599  60.719  1.00 36.97           O  
ATOM  13122  CB  ILE F 244      75.557  24.328  59.700  1.00 36.44           C  
ATOM  13123  CG1 ILE F 244      75.755  25.403  58.628  1.00 37.75           C  
ATOM  13124  CG2 ILE F 244      74.519  24.781  60.739  1.00 35.59           C  
ATOM  13125  CD1 ILE F 244      74.731  25.342  57.509  1.00 36.95           C  
ATOM  13126  N   GLY F 245      76.537  22.928  62.558  1.00 36.83           N  
ATOM  13127  CA  GLY F 245      76.112  21.898  63.525  1.00 37.21           C  
ATOM  13128  C   GLY F 245      75.041  22.403  64.493  1.00 37.79           C  
ATOM  13129  O   GLY F 245      74.861  23.620  64.643  1.00 38.26           O  
ATOM  13130  N   LYS F 246      74.327  21.484  65.152  1.00 37.61           N  
ATOM  13131  CA  LYS F 246      73.258  21.835  66.101  1.00 37.34           C  
ATOM  13132  C   LYS F 246      73.634  21.383  67.508  1.00 37.56           C  
ATOM  13133  O   LYS F 246      74.279  20.351  67.681  1.00 37.47           O  
ATOM  13134  CB  LYS F 246      71.927  21.182  65.674  1.00 37.58           C  
ATOM  13135  CG  LYS F 246      70.693  21.655  66.425  1.00 36.44           C  
ATOM  13136  CD  LYS F 246      69.418  21.153  65.776  1.00 37.09           C  
ATOM  13137  CE  LYS F 246      68.202  21.335  66.695  1.00 35.99           C  
ATOM  13138  NZ  LYS F 246      66.996  20.680  66.100  1.00 38.19           N  
ATOM  13139  N   LEU F 247      73.220  22.164  68.507  1.00 38.07           N  
ATOM  13140  CA  LEU F 247      73.518  21.878  69.919  1.00 38.19           C  
ATOM  13141  C   LEU F 247      72.261  21.617  70.719  1.00 37.75           C  
ATOM  13142  O   LEU F 247      71.257  22.298  70.535  1.00 37.63           O  
ATOM  13143  CB  LEU F 247      74.274  23.047  70.567  1.00 38.59           C  
ATOM  13144  CG  LEU F 247      75.772  23.150  70.281  1.00 39.81           C  
ATOM  13145  CD1 LEU F 247      75.977  23.584  68.868  1.00 42.44           C  
ATOM  13146  CD2 LEU F 247      76.369  24.156  71.220  1.00 40.82           C  
ATOM  13147  N   ARG F 248      72.340  20.643  71.626  1.00 37.35           N  
ATOM  13148  CA  ARG F 248      71.273  20.416  72.585  1.00 37.16           C  
ATOM  13149  C   ARG F 248      71.818  19.999  73.941  1.00 37.34           C  
ATOM  13150  O   ARG F 248      72.966  19.518  74.058  1.00 37.23           O  
ATOM  13151  CB  ARG F 248      70.263  19.393  72.064  1.00 36.81           C  
ATOM  13152  CG  ARG F 248      70.778  17.977  72.067  1.00 36.49           C  
ATOM  13153  CD  ARG F 248      69.680  16.995  71.626  1.00 36.05           C  
ATOM  13154  NE  ARG F 248      70.222  15.644  71.476  1.00 34.77           N  
ATOM  13155  CZ  ARG F 248      69.513  14.596  71.077  1.00 35.63           C  
ATOM  13156  NH1 ARG F 248      70.088  13.410  70.954  1.00 35.62           N  
ATOM  13157  NH2 ARG F 248      68.220  14.727  70.809  1.00 37.17           N  
ATOM  13158  N   TRP F 249      70.977  20.187  74.954  1.00 36.93           N  
ATOM  13159  CA  TRP F 249      71.259  19.732  76.298  1.00 37.16           C  
ATOM  13160  C   TRP F 249      71.030  18.215  76.406  1.00 37.45           C  
ATOM  13161  O   TRP F 249      70.026  17.671  75.873  1.00 37.00           O  
ATOM  13162  CB  TRP F 249      70.347  20.453  77.294  1.00 37.51           C  
ATOM  13163  CG  TRP F 249      70.672  21.920  77.566  1.00 38.05           C  
ATOM  13164  CD1 TRP F 249      69.830  23.001  77.359  1.00 38.69           C  
ATOM  13165  CD2 TRP F 249      71.898  22.465  78.103  1.00 36.88           C  
ATOM  13166  NE1 TRP F 249      70.471  24.171  77.728  1.00 39.18           N  
ATOM  13167  CE2 TRP F 249      71.729  23.868  78.193  1.00 37.30           C  
ATOM  13168  CE3 TRP F 249      73.119  21.907  78.509  1.00 36.68           C  
ATOM  13169  CZ2 TRP F 249      72.729  24.711  78.679  1.00 37.01           C  
ATOM  13170  CZ3 TRP F 249      74.116  22.747  79.002  1.00 38.80           C  
ATOM  13171  CH2 TRP F 249      73.922  24.135  79.075  1.00 38.51           C  
ATOM  13172  N   GLU F 250      71.973  17.560  77.084  1.00 36.77           N  
ATOM  13173  CA  GLU F 250      71.885  16.164  77.497  1.00 37.22           C  
ATOM  13174  C   GLU F 250      71.834  16.192  79.032  1.00 37.15           C  
ATOM  13175  O   GLU F 250      72.453  17.058  79.634  1.00 36.45           O  
ATOM  13176  CB  GLU F 250      73.189  15.499  77.071  1.00 37.83           C  
ATOM  13177  CG  GLU F 250      73.021  14.191  76.470  1.00 37.80           C  
ATOM  13178  CD  GLU F 250      74.317  13.453  76.351  1.00 40.27           C  
ATOM  13179  OE1 GLU F 250      75.398  14.058  76.555  1.00 38.14           O  
ATOM  13180  OE2 GLU F 250      74.234  12.232  76.059  1.00 43.27           O  
ATOM  13181  N   ARG F 251      71.103  15.276  79.668  1.00 37.26           N  
ATOM  13182  CA  ARG F 251      70.928  15.329  81.119  1.00 37.67           C  
ATOM  13183  C   ARG F 251      71.098  13.952  81.700  1.00 36.85           C  
ATOM  13184  O   ARG F 251      70.480  13.007  81.212  1.00 36.75           O  
ATOM  13185  CB  ARG F 251      69.548  15.909  81.504  1.00 37.55           C  
ATOM  13186  CG  ARG F 251      69.460  16.297  82.982  1.00 38.72           C  
ATOM  13187  CD  ARG F 251      68.129  16.929  83.320  1.00 40.46           C  
ATOM  13188  NE  ARG F 251      67.175  15.874  83.579  1.00 45.85           N  
ATOM  13189  CZ  ARG F 251      66.033  15.999  84.225  1.00 44.94           C  
ATOM  13190  NH1 ARG F 251      65.295  14.918  84.394  1.00 45.39           N  
ATOM  13191  NH2 ARG F 251      65.638  17.167  84.713  1.00 45.74           N  
ATOM  13192  N   THR F 252      71.926  13.826  82.733  1.00 36.61           N  
ATOM  13193  CA  THR F 252      72.191  12.497  83.306  1.00 36.30           C  
ATOM  13194  C   THR F 252      70.933  11.962  83.948  1.00 36.41           C  
ATOM  13195  O   THR F 252      70.102  12.740  84.450  1.00 35.82           O  
ATOM  13196  CB  THR F 252      73.341  12.456  84.355  1.00 36.23           C  
ATOM  13197  OG1 THR F 252      72.968  13.183  85.527  1.00 35.21           O  
ATOM  13198  CG2 THR F 252      74.647  13.008  83.803  1.00 35.51           C  
ATOM  13199  N   LEU F 253      70.799  10.634  83.924  1.00 36.33           N  
ATOM  13200  CA  LEU F 253      69.763   9.953  84.691  1.00 36.25           C  
ATOM  13201  C   LEU F 253      69.838  10.368  86.166  1.00 36.20           C  
ATOM  13202  O   LEU F 253      68.810  10.484  86.846  1.00 35.57           O  
ATOM  13203  CB  LEU F 253      69.885   8.440  84.525  1.00 36.54           C  
ATOM  13204  CG  LEU F 253      69.596   7.972  83.098  1.00 36.63           C  
ATOM  13205  CD1 LEU F 253      69.778   6.475  83.041  1.00 37.17           C  
ATOM  13206  CD2 LEU F 253      68.183   8.359  82.666  1.00 36.76           C  
ATOM  13207  N   GLY F 254      71.062  10.598  86.642  1.00 35.91           N  
ATOM  13208  CA  GLY F 254      71.263  11.176  87.962  1.00 35.93           C  
ATOM  13209  C   GLY F 254      71.127  10.186  89.103  1.00 36.03           C  
ATOM  13210  O   GLY F 254      71.113   8.972  88.902  1.00 35.74           O  
ATOM  13211  N   ALA F 255      71.018  10.720  90.312  1.00 36.20           N  
ATOM  13212  CA  ALA F 255      70.823   9.895  91.498  1.00 36.58           C  
ATOM  13213  C   ALA F 255      69.738  10.453  92.402  1.00 36.83           C  
ATOM  13214  O   ALA F 255      69.645  11.654  92.618  1.00 36.47           O  
ATOM  13215  CB  ALA F 255      72.142   9.727  92.264  1.00 35.98           C  
ATOM  13216  N   ILE F 256      68.898   9.565  92.912  1.00 37.63           N  
ATOM  13217  CA  ILE F 256      68.019   9.911  94.015  1.00 38.60           C  
ATOM  13218  C   ILE F 256      68.832   9.612  95.264  1.00 39.08           C  
ATOM  13219  O   ILE F 256      69.104   8.457  95.567  1.00 39.23           O  
ATOM  13220  CB  ILE F 256      66.705   9.099  93.986  1.00 38.66           C  
ATOM  13221  CG1 ILE F 256      65.860   9.500  92.758  1.00 39.01           C  
ATOM  13222  CG2 ILE F 256      65.947   9.279  95.305  1.00 38.56           C  
ATOM  13223  CD1 ILE F 256      64.557   8.711  92.591  1.00 38.54           C  
ATOM  13224  N   VAL F 257      69.260  10.661  95.957  1.00 39.65           N  
ATOM  13225  CA  VAL F 257      70.184  10.501  97.078  1.00 40.35           C  
ATOM  13226  C   VAL F 257      69.468  10.500  98.432  1.00 40.61           C  
ATOM  13227  O   VAL F 257      69.981   9.961  99.403  1.00 41.16           O  
ATOM  13228  CB  VAL F 257      71.348  11.531  97.003  1.00 40.47           C  
ATOM  13229  CG1 VAL F 257      72.054  11.386  95.663  1.00 40.16           C  
ATOM  13230  CG2 VAL F 257      70.852  12.963  97.165  1.00 40.31           C  
ATOM  13231  N   ARG F 258      68.272  11.078  98.467  1.00 40.87           N  
ATOM  13232  CA  ARG F 258      67.445  11.118  99.657  1.00 41.01           C  
ATOM  13233  C   ARG F 258      66.703   9.801  99.850  1.00 41.58           C  
ATOM  13234  O   ARG F 258      66.128   9.257  98.901  1.00 41.63           O  
ATOM  13235  CB  ARG F 258      66.440  12.259  99.550  1.00 40.59           C  
ATOM  13236  CG  ARG F 258      65.481  12.356 100.719  1.00 40.84           C  
ATOM  13237  CD  ARG F 258      64.783  13.702 100.767  1.00 40.69           C  
ATOM  13238  NE  ARG F 258      63.676  13.813  99.819  1.00 39.73           N  
ATOM  13239  CZ  ARG F 258      62.440  13.401 100.075  1.00 37.93           C  
ATOM  13240  NH1 ARG F 258      61.482  13.545  99.170  1.00 37.03           N  
ATOM  13241  NH2 ARG F 258      62.164  12.839 101.238  1.00 36.28           N  
ATOM  13242  N   GLN F 259      66.725   9.308 101.085  1.00 42.00           N  
ATOM  13243  CA  GLN F 259      65.957   8.145 101.502  1.00 43.01           C  
ATOM  13244  C   GLN F 259      64.794   8.592 102.403  1.00 43.23           C  
ATOM  13245  O   GLN F 259      64.898   9.580 103.147  1.00 43.24           O  
ATOM  13246  CB  GLN F 259      66.853   7.164 102.265  1.00 42.97           C  
ATOM  13247  CG  GLN F 259      68.164   6.805 101.543  1.00 43.94           C  
ATOM  13248  N   LYS F 260      63.690   7.861 102.328  1.00 43.55           N  
ATOM  13249  CA  LYS F 260      62.544   8.091 103.191  1.00 44.10           C  
ATOM  13250  C   LYS F 260      62.977   8.004 104.652  1.00 44.37           C  
ATOM  13251  O   LYS F 260      63.710   7.081 105.049  1.00 44.44           O  
ATOM  13252  CB  LYS F 260      61.451   7.057 102.883  1.00 44.02           C  
ATOM  13253  CG  LYS F 260      60.121   7.281 103.596  1.00 44.45           C  
ATOM  13254  CD  LYS F 260      59.132   6.160 103.280  1.00 44.31           C  
ATOM  13255  CE  LYS F 260      57.741   6.475 103.820  1.00 45.08           C  
ATOM  13256  N   ASN F 261      62.532   8.999 105.418  1.00 44.72           N  
ATOM  13257  CA  ASN F 261      62.790   9.159 106.857  1.00 44.98           C  
ATOM  13258  C   ASN F 261      64.228   9.498 107.301  1.00 44.91           C  
ATOM  13259  O   ASN F 261      64.501   9.551 108.508  1.00 45.06           O  
ATOM  13260  CB  ASN F 261      62.288   7.934 107.660  1.00 45.20           C  
ATOM  13261  CG  ASN F 261      60.841   7.560 107.347  1.00 45.28           C  
ATOM  13262  OD1 ASN F 261      60.474   6.377 107.384  1.00 43.72           O  
ATOM  13263  ND2 ASN F 261      60.017   8.561 107.037  1.00 45.57           N  
ATOM  13264  N   HIS F 262      65.128   9.734 106.349  1.00 44.37           N  
ATOM  13265  CA  HIS F 262      66.518  10.033 106.658  1.00 43.94           C  
ATOM  13266  C   HIS F 262      66.839  11.402 106.093  1.00 43.23           C  
ATOM  13267  O   HIS F 262      66.466  11.694 104.956  1.00 43.28           O  
ATOM  13268  CB  HIS F 262      67.406   8.985 106.000  1.00 44.24           C  
ATOM  13269  CG  HIS F 262      68.727   8.791 106.672  1.00 45.59           C  
ATOM  13270  ND1 HIS F 262      69.846   9.531 106.346  1.00 46.55           N  
ATOM  13271  CD2 HIS F 262      69.117   7.923 107.637  1.00 45.80           C  
ATOM  13272  CE1 HIS F 262      70.861   9.139 107.097  1.00 45.79           C  
ATOM  13273  NE2 HIS F 262      70.447   8.162 107.882  1.00 45.42           N  
ATOM  13274  N   PRO F 263      67.535  12.251 106.873  1.00 42.64           N  
ATOM  13275  CA  PRO F 263      67.924  13.564 106.350  1.00 41.93           C  
ATOM  13276  C   PRO F 263      68.869  13.419 105.152  1.00 41.47           C  
ATOM  13277  O   PRO F 263      69.747  12.544 105.157  1.00 41.10           O  
ATOM  13278  CB  PRO F 263      68.657  14.213 107.521  1.00 41.77           C  
ATOM  13279  CG  PRO F 263      68.308  13.399 108.719  1.00 42.29           C  
ATOM  13280  CD  PRO F 263      68.027  12.030 108.242  1.00 42.20           C  
ATOM  13281  N   MET F 264      68.667  14.250 104.128  1.00 40.86           N  
ATOM  13282  CA  MET F 264      69.544  14.280 102.980  1.00 40.25           C  
ATOM  13283  C   MET F 264      70.811  15.030 103.373  1.00 39.40           C  
ATOM  13284  O   MET F 264      70.737  16.112 103.932  1.00 39.49           O  
ATOM  13285  CB  MET F 264      68.848  14.956 101.802  1.00 40.42           C  
ATOM  13286  CG  MET F 264      69.413  14.587 100.425  1.00 41.07           C  
ATOM  13287  SD  MET F 264      68.849  15.686  99.097  1.00 42.25           S  
ATOM  13288  CE  MET F 264      67.115  15.599  99.360  1.00 44.65           C  
ATOM  13289  N   THR F 265      71.970  14.448 103.088  1.00 38.37           N  
ATOM  13290  CA  THR F 265      73.236  15.007 103.554  1.00 37.49           C  
ATOM  13291  C   THR F 265      74.171  15.283 102.390  1.00 36.95           C  
ATOM  13292  O   THR F 265      74.083  14.620 101.362  1.00 36.66           O  
ATOM  13293  CB  THR F 265      73.961  14.041 104.505  1.00 37.62           C  
ATOM  13294  OG1 THR F 265      74.270  12.821 103.807  1.00 36.90           O  
ATOM  13295  CG2 THR F 265      73.123  13.760 105.742  1.00 37.10           C  
ATOM  13296  N   PRO F 266      75.061  16.278 102.537  1.00 36.39           N  
ATOM  13297  CA  PRO F 266      76.131  16.427 101.564  1.00 36.00           C  
ATOM  13298  C   PRO F 266      77.040  15.192 101.425  1.00 35.58           C  
ATOM  13299  O   PRO F 266      77.578  14.953 100.354  1.00 35.48           O  
ATOM  13300  CB  PRO F 266      76.903  17.652 102.066  1.00 36.02           C  
ATOM  13301  CG  PRO F 266      76.447  17.887 103.461  1.00 35.91           C  
ATOM  13302  CD  PRO F 266      75.069  17.352 103.547  1.00 36.29           C  
ATOM  13303  N   GLU F 267      77.180  14.402 102.479  1.00 35.49           N  
ATOM  13304  CA  GLU F 267      77.970  13.171 102.413  1.00 35.58           C  
ATOM  13305  C   GLU F 267      77.379  12.154 101.431  1.00 35.49           C  
ATOM  13306  O   GLU F 267      78.125  11.405 100.793  1.00 35.63           O  
ATOM  13307  CB  GLU F 267      78.112  12.527 103.799  1.00 35.87           C  
ATOM  13308  CG  GLU F 267      78.996  13.298 104.797  1.00 35.89           C  
ATOM  13309  CD  GLU F 267      78.285  14.485 105.436  1.00 36.00           C  
ATOM  13310  OE1 GLU F 267      77.040  14.595 105.351  1.00 36.05           O  
ATOM  13311  OE2 GLU F 267      78.985  15.319 106.027  1.00 36.40           O  
ATOM  13312  N   ALA F 268      76.049  12.119 101.333  1.00 35.30           N  
ATOM  13313  CA  ALA F 268      75.341  11.230 100.398  1.00 35.37           C  
ATOM  13314  C   ALA F 268      75.495  11.694  98.951  1.00 35.18           C  
ATOM  13315  O   ALA F 268      75.654  10.876  98.049  1.00 35.38           O  
ATOM  13316  CB  ALA F 268      73.854  11.123 100.766  1.00 35.16           C  
ATOM  13317  N   VAL F 269      75.441  13.007  98.739  1.00 34.86           N  
ATOM  13318  CA  VAL F 269      75.738  13.597  97.443  1.00 34.65           C  
ATOM  13319  C   VAL F 269      77.161  13.206  97.002  1.00 35.21           C  
ATOM  13320  O   VAL F 269      77.339  12.695  95.896  1.00 35.00           O  
ATOM  13321  CB  VAL F 269      75.559  15.136  97.463  1.00 34.73           C  
ATOM  13322  CG1 VAL F 269      75.930  15.742  96.130  1.00 33.19           C  
ATOM  13323  CG2 VAL F 269      74.116  15.527  97.868  1.00 34.51           C  
ATOM  13324  N   LYS F 270      78.150  13.425  97.866  1.00 35.57           N  
ATOM  13325  CA  LYS F 270      79.545  13.073  97.580  1.00 36.20           C  
ATOM  13326  C   LYS F 270      79.688  11.600  97.238  1.00 36.27           C  
ATOM  13327  O   LYS F 270      80.321  11.248  96.250  1.00 36.09           O  
ATOM  13328  CB  LYS F 270      80.440  13.411  98.774  1.00 36.24           C  
ATOM  13329  CG  LYS F 270      81.884  12.913  98.652  1.00 36.61           C  
ATOM  13330  CD  LYS F 270      82.622  13.024  99.992  1.00 36.79           C  
ATOM  13331  N   ALA F 271      79.088  10.745  98.060  1.00 36.50           N  
ATOM  13332  CA  ALA F 271      79.140   9.299  97.853  1.00 36.76           C  
ATOM  13333  C   ALA F 271      78.508   8.854  96.526  1.00 36.90           C  
ATOM  13334  O   ALA F 271      78.921   7.851  95.948  1.00 36.77           O  
ATOM  13335  CB  ALA F 271      78.505   8.565  99.040  1.00 36.62           C  
ATOM  13336  N   ASN F 272      77.522   9.614  96.049  1.00 37.08           N  
ATOM  13337  CA  ASN F 272      76.805   9.326  94.796  1.00 37.35           C  
ATOM  13338  C   ASN F 272      77.285  10.152  93.597  1.00 37.22           C  
ATOM  13339  O   ASN F 272      76.632  10.161  92.544  1.00 37.15           O  
ATOM  13340  CB  ASN F 272      75.296   9.582  94.986  1.00 37.75           C  
ATOM  13341  CG  ASN F 272      74.584   8.438  95.699  1.00 40.00           C  
ATOM  13342  OD1 ASN F 272      74.797   7.265  95.385  1.00 42.05           O  
ATOM  13343  ND2 ASN F 272      73.733   8.775  96.666  1.00 40.57           N  
ATOM  13344  N   TRP F 273      78.423  10.830  93.743  1.00 37.06           N  
ATOM  13345  CA  TRP F 273      78.857  11.814  92.750  1.00 37.04           C  
ATOM  13346  C   TRP F 273      79.135  11.243  91.357  1.00 37.27           C  
ATOM  13347  O   TRP F 273      78.741  11.853  90.360  1.00 37.09           O  
ATOM  13348  CB  TRP F 273      80.037  12.632  93.270  1.00 36.33           C  
ATOM  13349  CG  TRP F 273      80.176  13.948  92.555  1.00 36.66           C  
ATOM  13350  CD1 TRP F 273      81.262  14.379  91.838  1.00 36.00           C  
ATOM  13351  CD2 TRP F 273      79.194  14.992  92.460  1.00 35.48           C  
ATOM  13352  NE1 TRP F 273      81.020  15.629  91.321  1.00 35.87           N  
ATOM  13353  CE2 TRP F 273      79.760  16.028  91.679  1.00 34.81           C  
ATOM  13354  CE3 TRP F 273      77.891  15.156  92.960  1.00 34.75           C  
ATOM  13355  CZ2 TRP F 273      79.080  17.209  91.396  1.00 34.27           C  
ATOM  13356  CZ3 TRP F 273      77.219  16.329  92.682  1.00 35.03           C  
ATOM  13357  CH2 TRP F 273      77.815  17.346  91.915  1.00 35.30           C  
ATOM  13358  N   LYS F 274      79.777  10.075  91.288  1.00 37.54           N  
ATOM  13359  CA  LYS F 274      80.050   9.439  89.992  1.00 38.16           C  
ATOM  13360  C   LYS F 274      78.748   9.128  89.245  1.00 38.32           C  
ATOM  13361  O   LYS F 274      78.633   9.403  88.051  1.00 38.38           O  
ATOM  13362  CB  LYS F 274      80.909   8.182  90.127  1.00 37.98           C  
ATOM  13363  CG  LYS F 274      82.351   8.453  90.527  1.00 39.24           C  
ATOM  13364  N   LYS F 275      77.782   8.560  89.959  1.00 38.24           N  
ATOM  13365  CA  LYS F 275      76.464   8.277  89.415  1.00 38.71           C  
ATOM  13366  C   LYS F 275      75.752   9.562  88.962  1.00 38.40           C  
ATOM  13367  O   LYS F 275      75.223   9.616  87.852  1.00 38.87           O  
ATOM  13368  CB  LYS F 275      75.645   7.508  90.449  1.00 38.29           C  
ATOM  13369  CG  LYS F 275      74.251   7.065  90.015  1.00 39.59           C  
ATOM  13370  CD  LYS F 275      73.651   6.172  91.123  1.00 40.17           C  
ATOM  13371  CE  LYS F 275      72.314   5.590  90.717  1.00 43.94           C  
ATOM  13372  NZ  LYS F 275      71.175   6.472  91.129  1.00 46.36           N  
ATOM  13373  N   ILE F 276      75.748  10.598  89.805  1.00 37.98           N  
ATOM  13374  CA  ILE F 276      75.160  11.898  89.430  1.00 37.51           C  
ATOM  13375  C   ILE F 276      75.723  12.450  88.116  1.00 37.93           C  
ATOM  13376  O   ILE F 276      74.977  13.027  87.306  1.00 37.89           O  
ATOM  13377  CB  ILE F 276      75.305  12.968  90.551  1.00 37.45           C  
ATOM  13378  CG1 ILE F 276      74.248  12.750  91.631  1.00 36.57           C  
ATOM  13379  CG2 ILE F 276      75.141  14.390  90.014  1.00 36.14           C  
ATOM  13380  CD1 ILE F 276      74.711  13.163  93.027  1.00 36.29           C  
ATOM  13381  N   CYS F 277      77.025  12.243  87.909  1.00 38.29           N  
ATOM  13382  CA  CYS F 277      77.765  12.819  86.795  1.00 38.47           C  
ATOM  13383  C   CYS F 277      77.920  11.881  85.597  1.00 38.38           C  
ATOM  13384  O   CYS F 277      78.475  12.271  84.558  1.00 38.27           O  
ATOM  13385  CB  CYS F 277      79.144  13.296  87.278  1.00 38.99           C  
ATOM  13386  SG  CYS F 277      79.035  14.635  88.511  1.00 41.13           S  
ATOM  13387  N   ASP F 278      77.419  10.655  85.731  1.00 38.20           N  
ATOM  13388  CA  ASP F 278      77.470   9.655  84.650  1.00 38.24           C  
ATOM  13389  C   ASP F 278      76.460   9.925  83.526  1.00 38.30           C  
ATOM  13390  O   ASP F 278      75.249   9.844  83.749  1.00 38.49           O  
ATOM  13391  CB  ASP F 278      77.219   8.258  85.238  1.00 38.44           C  
ATOM  13392  CG  ASP F 278      77.496   7.119  84.247  1.00 38.96           C  
ATOM  13393  OD1 ASP F 278      77.684   7.345  83.027  1.00 38.91           O  
ATOM  13394  OD2 ASP F 278      77.508   5.964  84.714  1.00 40.77           O  
ATOM  13395  N   PHE F 279      76.970  10.195  82.320  1.00 38.44           N  
ATOM  13396  CA  PHE F 279      76.143  10.520  81.146  1.00 38.39           C  
ATOM  13397  C   PHE F 279      75.705   9.310  80.287  1.00 38.85           C  
ATOM  13398  O   PHE F 279      74.992   9.483  79.296  1.00 38.93           O  
ATOM  13399  CB  PHE F 279      76.843  11.590  80.278  1.00 37.70           C  
ATOM  13400  CG  PHE F 279      76.653  12.988  80.785  1.00 36.73           C  
ATOM  13401  CD1 PHE F 279      77.644  13.608  81.545  1.00 36.65           C  
ATOM  13402  CD2 PHE F 279      75.466  13.679  80.528  1.00 35.46           C  
ATOM  13403  CE1 PHE F 279      77.462  14.903  82.034  1.00 36.07           C  
ATOM  13404  CE2 PHE F 279      75.261  14.959  81.013  1.00 36.36           C  
ATOM  13405  CZ  PHE F 279      76.266  15.581  81.767  1.00 36.98           C  
ATOM  13406  N   GLU F 280      76.118   8.094  80.653  1.00 38.97           N  
ATOM  13407  CA  GLU F 280      75.626   6.927  79.926  1.00 39.54           C  
ATOM  13408  C   GLU F 280      74.094   6.876  80.012  1.00 38.97           C  
ATOM  13409  O   GLU F 280      73.529   6.988  81.098  1.00 38.61           O  
ATOM  13410  CB  GLU F 280      76.271   5.612  80.404  1.00 39.67           C  
ATOM  13411  CG  GLU F 280      75.553   4.359  79.869  1.00 41.72           C  
ATOM  13412  CD  GLU F 280      76.484   3.203  79.575  1.00 46.03           C  
ATOM  13413  OE1 GLU F 280      77.460   3.420  78.831  1.00 49.39           O  
ATOM  13414  OE2 GLU F 280      76.244   2.071  80.069  1.00 46.39           O  
ATOM  13415  N   ASN F 281      73.450   6.730  78.852  1.00 38.89           N  
ATOM  13416  CA  ASN F 281      71.984   6.707  78.716  1.00 38.78           C  
ATOM  13417  C   ASN F 281      71.292   7.994  79.159  1.00 38.70           C  
ATOM  13418  O   ASN F 281      70.114   7.968  79.554  1.00 38.78           O  
ATOM  13419  CB  ASN F 281      71.375   5.505  79.438  1.00 39.18           C  
ATOM  13420  CG  ASN F 281      71.935   4.180  78.949  1.00 40.04           C  
ATOM  13421  OD1 ASN F 281      71.971   3.899  77.745  1.00 40.63           O  
ATOM  13422  ND2 ASN F 281      72.362   3.349  79.889  1.00 40.96           N  
ATOM  13423  N   ALA F 282      72.027   9.107  79.078  1.00 38.12           N  
ATOM  13424  CA  ALA F 282      71.523  10.420  79.425  1.00 38.17           C  
ATOM  13425  C   ALA F 282      70.271  10.751  78.623  1.00 38.48           C  
ATOM  13426  O   ALA F 282      70.158  10.395  77.450  1.00 38.31           O  
ATOM  13427  CB  ALA F 282      72.577  11.450  79.157  1.00 37.81           C  
ATOM  13428  N   SER F 283      69.333  11.443  79.250  1.00 38.86           N  
ATOM  13429  CA  SER F 283      68.107  11.808  78.561  1.00 39.35           C  
ATOM  13430  C   SER F 283      68.324  13.096  77.769  1.00 39.98           C  
ATOM  13431  O   SER F 283      69.336  13.793  77.944  1.00 39.39           O  
ATOM  13432  CB  SER F 283      66.948  11.959  79.542  1.00 38.80           C  
ATOM  13433  OG  SER F 283      67.123  13.099  80.337  1.00 38.85           O  
ATOM  13434  N   LYS F 284      67.364  13.388  76.895  1.00 40.60           N  
ATOM  13435  CA  LYS F 284      67.444  14.537  76.010  1.00 41.60           C  
ATOM  13436  C   LYS F 284      66.200  15.430  76.210  1.00 42.22           C  
ATOM  13437  O   LYS F 284      65.248  15.394  75.420  1.00 42.02           O  
ATOM  13438  CB  LYS F 284      67.666  14.045  74.568  1.00 41.09           C  
ATOM  13439  CG  LYS F 284      69.191  13.806  74.229  1.00 42.12           C  
ATOM  13440  CD  LYS F 284      69.850  12.663  74.971  1.00 42.37           C  
ATOM  13441  CE  LYS F 284      70.829  11.871  74.123  1.00 42.71           C  
ATOM  13442  NZ  LYS F 284      72.210  12.382  74.197  1.00 40.36           N  
ATOM  13443  N   PRO F 285      66.216  16.241  77.287  1.00 42.95           N  
ATOM  13444  CA  PRO F 285      65.008  16.964  77.732  1.00 43.60           C  
ATOM  13445  C   PRO F 285      64.576  18.044  76.747  1.00 44.32           C  
ATOM  13446  O   PRO F 285      65.402  18.835  76.275  1.00 44.55           O  
ATOM  13447  CB  PRO F 285      65.429  17.566  79.081  1.00 43.37           C  
ATOM  13448  CG  PRO F 285      66.953  17.712  78.959  1.00 42.92           C  
ATOM  13449  CD  PRO F 285      67.390  16.538  78.131  1.00 42.36           C  
ATOM  13450  N   GLN F 286      63.281  18.049  76.423  1.00 45.40           N  
ATOM  13451  CA  GLN F 286      62.729  18.948  75.409  1.00 45.99           C  
ATOM  13452  C   GLN F 286      62.118  20.246  75.917  1.00 45.62           C  
ATOM  13453  O   GLN F 286      61.972  21.190  75.148  1.00 45.98           O  
ATOM  13454  CB  GLN F 286      61.650  18.233  74.602  1.00 46.41           C  
ATOM  13455  CG  GLN F 286      62.023  18.098  73.142  1.00 50.29           C  
ATOM  13456  CD  GLN F 286      62.961  16.946  72.926  1.00 52.89           C  
ATOM  13457  OE1 GLN F 286      62.516  15.797  72.808  1.00 54.34           O  
ATOM  13458  NE2 GLN F 286      64.265  17.229  72.895  1.00 52.13           N  
ATOM  13459  N   SER F 287      61.728  20.277  77.189  1.00 45.02           N  
ATOM  13460  CA  SER F 287      60.931  21.370  77.726  1.00 44.29           C  
ATOM  13461  C   SER F 287      61.025  21.424  79.241  1.00 44.10           C  
ATOM  13462  O   SER F 287      61.315  20.423  79.888  1.00 43.99           O  
ATOM  13463  CB  SER F 287      59.461  21.159  77.349  1.00 44.06           C  
ATOM  13464  OG  SER F 287      58.932  20.058  78.079  1.00 43.72           O  
ATOM  13465  N   ILE F 288      60.720  22.589  79.800  1.00 43.83           N  
ATOM  13466  CA  ILE F 288      60.645  22.761  81.242  1.00 43.62           C  
ATOM  13467  C   ILE F 288      59.653  21.775  81.903  1.00 44.63           C  
ATOM  13468  O   ILE F 288      59.964  21.205  82.947  1.00 44.94           O  
ATOM  13469  CB  ILE F 288      60.340  24.243  81.625  1.00 43.62           C  
ATOM  13470  CG1 ILE F 288      60.570  24.475  83.123  1.00 42.77           C  
ATOM  13471  CG2 ILE F 288      58.912  24.662  81.154  1.00 43.21           C  
ATOM  13472  CD1 ILE F 288      60.500  25.910  83.551  1.00 43.06           C  
ATOM  13473  N   GLN F 289      58.494  21.549  81.282  1.00 44.82           N  
ATOM  13474  CA  GLN F 289      57.499  20.628  81.838  1.00 45.91           C  
ATOM  13475  C   GLN F 289      58.055  19.220  82.005  1.00 46.14           C  
ATOM  13476  O   GLN F 289      57.769  18.550  83.005  1.00 46.01           O  
ATOM  13477  CB  GLN F 289      56.196  20.630  81.008  1.00 45.86           C  
ATOM  13478  CG  GLN F 289      55.413  21.934  81.108  1.00 46.77           C  
ATOM  13479  CD  GLN F 289      55.734  22.973  80.010  1.00 49.45           C  
ATOM  13480  OE1 GLN F 289      56.699  22.842  79.226  1.00 48.37           O  
ATOM  13481  NE2 GLN F 289      54.903  24.028  79.958  1.00 49.69           N  
ATOM  13482  N   GLU F 290      58.854  18.791  81.032  1.00 46.58           N  
ATOM  13483  CA  GLU F 290      59.519  17.485  81.077  1.00 47.54           C  
ATOM  13484  C   GLU F 290      60.483  17.336  82.256  1.00 46.63           C  
ATOM  13485  O   GLU F 290      60.424  16.340  82.963  1.00 46.63           O  
ATOM  13486  CB  GLU F 290      60.233  17.185  79.750  1.00 47.37           C  
ATOM  13487  CG  GLU F 290      60.614  15.723  79.582  1.00 48.97           C  
ATOM  13488  CD  GLU F 290      61.494  15.484  78.361  1.00 50.12           C  
ATOM  13489  OE1 GLU F 290      61.339  16.233  77.358  1.00 53.15           O  
ATOM  13490  OE2 GLU F 290      62.343  14.552  78.411  1.00 52.92           O  
ATOM  13491  N   SER F 291      61.355  18.316  82.469  1.00 46.31           N  
ATOM  13492  CA  SER F 291      62.321  18.268  83.587  1.00 45.91           C  
ATOM  13493  C   SER F 291      61.604  18.423  84.924  1.00 45.48           C  
ATOM  13494  O   SER F 291      61.707  17.568  85.812  1.00 45.34           O  
ATOM  13495  CB  SER F 291      63.395  19.354  83.428  1.00 46.11           C  
ATOM  13496  OG  SER F 291      64.001  19.682  84.673  1.00 46.06           O  
ATOM  13497  N   THR F 292      60.844  19.501  85.043  1.00 45.11           N  
ATOM  13498  CA  THR F 292      60.067  19.788  86.251  1.00 45.05           C  
ATOM  13499  C   THR F 292      59.132  18.645  86.635  1.00 44.14           C  
ATOM  13500  O   THR F 292      59.060  18.272  87.810  1.00 44.36           O  
ATOM  13501  CB  THR F 292      59.312  21.120  86.122  1.00 44.99           C  
ATOM  13502  OG1 THR F 292      60.263  22.193  86.159  1.00 47.86           O  
ATOM  13503  CG2 THR F 292      58.322  21.313  87.261  1.00 46.85           C  
ATOM  13504  N   GLY F 293      58.460  18.057  85.648  1.00 43.31           N  
ATOM  13505  CA  GLY F 293      57.517  16.965  85.908  1.00 42.30           C  
ATOM  13506  C   GLY F 293      58.191  15.732  86.468  1.00 41.95           C  
ATOM  13507  O   GLY F 293      57.672  15.106  87.371  1.00 41.34           O  
ATOM  13508  N   SER F 294      59.366  15.394  85.941  1.00 42.18           N  
ATOM  13509  CA  SER F 294      60.075  14.193  86.369  1.00 42.29           C  
ATOM  13510  C   SER F 294      60.669  14.367  87.771  1.00 42.38           C  
ATOM  13511  O   SER F 294      60.715  13.412  88.550  1.00 42.62           O  
ATOM  13512  CB  SER F 294      61.138  13.784  85.330  1.00 42.25           C  
ATOM  13513  OG  SER F 294      62.277  14.622  85.383  1.00 42.86           O  
ATOM  13514  N   ILE F 295      61.093  15.589  88.089  1.00 42.55           N  
ATOM  13515  CA  ILE F 295      61.591  15.923  89.434  1.00 42.67           C  
ATOM  13516  C   ILE F 295      60.494  15.823  90.496  1.00 42.71           C  
ATOM  13517  O   ILE F 295      60.683  15.222  91.553  1.00 42.74           O  
ATOM  13518  CB  ILE F 295      62.278  17.313  89.456  1.00 42.77           C  
ATOM  13519  CG1 ILE F 295      63.558  17.259  88.600  1.00 43.24           C  
ATOM  13520  CG2 ILE F 295      62.588  17.727  90.894  1.00 42.03           C  
ATOM  13521  CD1 ILE F 295      64.466  18.493  88.666  1.00 42.84           C  
ATOM  13522  N   ILE F 296      59.335  16.394  90.201  1.00 43.15           N  
ATOM  13523  CA  ILE F 296      58.165  16.291  91.079  1.00 43.25           C  
ATOM  13524  C   ILE F 296      57.768  14.829  91.317  1.00 43.19           C  
ATOM  13525  O   ILE F 296      57.450  14.431  92.447  1.00 43.55           O  
ATOM  13526  CB  ILE F 296      57.007  17.147  90.520  1.00 43.44           C  
ATOM  13527  CG1 ILE F 296      57.350  18.641  90.707  1.00 43.83           C  
ATOM  13528  CG2 ILE F 296      55.654  16.780  91.143  1.00 43.27           C  
ATOM  13529  CD1 ILE F 296      56.442  19.608  89.918  1.00 44.57           C  
ATOM  13530  N   GLU F 297      57.818  14.030  90.257  1.00 42.83           N  
ATOM  13531  CA  GLU F 297      57.570  12.595  90.329  1.00 42.46           C  
ATOM  13532  C   GLU F 297      58.539  11.857  91.297  1.00 42.24           C  
ATOM  13533  O   GLU F 297      58.204  10.791  91.816  1.00 42.28           O  
ATOM  13534  CB  GLU F 297      57.639  12.021  88.905  1.00 42.33           C  
ATOM  13535  CG  GLU F 297      57.049  10.635  88.705  1.00 43.16           C  
ATOM  13536  N   VAL F 298      59.723  12.426  91.543  1.00 41.74           N  
ATOM  13537  CA  VAL F 298      60.673  11.830  92.496  1.00 41.49           C  
ATOM  13538  C   VAL F 298      60.125  11.809  93.934  1.00 41.56           C  
ATOM  13539  O   VAL F 298      60.389  10.860  94.689  1.00 41.61           O  
ATOM  13540  CB  VAL F 298      62.098  12.475  92.419  1.00 41.49           C  
ATOM  13541  CG1 VAL F 298      62.902  12.212  93.693  1.00 41.52           C  
ATOM  13542  CG2 VAL F 298      62.853  11.950  91.229  1.00 40.95           C  
ATOM  13543  N   LEU F 299      59.352  12.834  94.299  1.00 41.65           N  
ATOM  13544  CA  LEU F 299      58.668  12.871  95.606  1.00 41.85           C  
ATOM  13545  C   LEU F 299      57.878  11.595  95.915  1.00 42.26           C  
ATOM  13546  O   LEU F 299      58.080  10.958  96.963  1.00 42.05           O  
ATOM  13547  CB  LEU F 299      57.734  14.087  95.698  1.00 41.97           C  
ATOM  13548  CG  LEU F 299      58.326  15.502  95.607  1.00 41.35           C  
ATOM  13549  CD1 LEU F 299      57.201  16.524  95.657  1.00 40.22           C  
ATOM  13550  CD2 LEU F 299      59.300  15.730  96.752  1.00 40.72           C  
ATOM  13551  N   SER F 300      56.979  11.220  95.004  1.00 42.60           N  
ATOM  13552  CA  SER F 300      56.162  10.033  95.221  1.00 43.37           C  
ATOM  13553  C   SER F 300      56.981   8.741  95.124  1.00 43.66           C  
ATOM  13554  O   SER F 300      56.652   7.753  95.781  1.00 43.81           O  
ATOM  13555  CB  SER F 300      54.916  10.004  94.318  1.00 43.42           C  
ATOM  13556  OG  SER F 300      55.248   9.920  92.942  1.00 44.19           O  
ATOM  13557  N   LYS F 301      58.050   8.753  94.330  1.00 44.31           N  
ATOM  13558  CA  LYS F 301      58.932   7.583  94.238  1.00 44.84           C  
ATOM  13559  C   LYS F 301      59.622   7.271  95.574  1.00 45.14           C  
ATOM  13560  O   LYS F 301      59.765   6.105  95.938  1.00 45.21           O  
ATOM  13561  CB  LYS F 301      59.947   7.744  93.099  1.00 45.25           C  
ATOM  13562  CG  LYS F 301      60.435   6.420  92.518  1.00 45.82           C  
ATOM  13563  CD  LYS F 301      61.933   6.200  92.737  1.00 46.93           C  
ATOM  13564  CE  LYS F 301      62.408   4.803  92.286  1.00 48.18           C  
ATOM  13565  NZ  LYS F 301      61.664   4.191  91.119  1.00 49.59           N  
ATOM  13566  N   ILE F 302      60.026   8.309  96.311  1.00 45.56           N  
ATOM  13567  CA  ILE F 302      60.658   8.120  97.628  1.00 45.69           C  
ATOM  13568  C   ILE F 302      59.642   7.658  98.685  1.00 46.37           C  
ATOM  13569  O   ILE F 302      59.946   6.789  99.509  1.00 46.32           O  
ATOM  13570  CB  ILE F 302      61.472   9.371  98.084  1.00 45.75           C  
ATOM  13571  CG1 ILE F 302      62.537   9.716  97.034  1.00 45.46           C  
ATOM  13572  CG2 ILE F 302      62.148   9.125  99.426  1.00 44.82           C  
ATOM  13573  CD1 ILE F 302      63.281  11.058  97.251  1.00 45.36           C  
ATOM  13574  N   ASP F 303      58.435   8.221  98.629  1.00 47.01           N  
ATOM  13575  CA  ASP F 303      57.297   7.805  99.448  1.00 47.98           C  
ATOM  13576  C   ASP F 303      56.792   6.367  99.223  1.00 48.04           C  
ATOM  13577  O   ASP F 303      56.169   5.793 100.116  1.00 48.25           O  
ATOM  13578  CB  ASP F 303      56.128   8.763  99.181  1.00 48.34           C  
ATOM  13579  CG  ASP F 303      56.018   9.872 100.221  1.00 50.19           C  
ATOM  13580  OD1 ASP F 303      55.932   9.553 101.433  1.00 51.89           O  
ATOM  13581  OD2 ASP F 303      55.989  11.059  99.824  1.00 50.77           O  
ATOM  13582  N   SER F 304      57.036   5.806  98.036  1.00 48.25           N  
ATOM  13583  CA  SER F 304      56.526   4.475  97.664  1.00 48.52           C  
ATOM  13584  C   SER F 304      57.276   3.351  98.374  1.00 48.54           C  
ATOM  13585  O   SER F 304      58.485   3.181  98.176  1.00 48.67           O  
ATOM  13586  CB  SER F 304      56.626   4.253  96.150  1.00 48.74           C  
ATOM  13587  OG  SER F 304      57.939   3.850  95.778  1.00 49.15           O  
TER   13588      SER F 304                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
