
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  258 ( 1965),  selected  258 , name 1ae1_B
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 1ae1_B.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R    16_B      -       -           -
LGA    W    17_B      M       1          1.467
LGA    S    18_B      T       2          1.247
LGA    L    19_B      L       3          1.425
LGA    K    20_B      S       4          1.721
LGA    G    21_B      G       5          1.836
LGA    T    22_B      K       6          0.967
LGA    T    23_B      T       7          0.996
LGA    A    24_B      L       8          0.781
LGA    L    25_B      F       9          0.324
LGA    V    26_B      I      10          0.567
LGA    T    27_B      T      11          0.636
LGA    G    28_B      G      12          0.657
LGA    G    29_B      A      13          0.605
LGA    S    30_B      S      14          0.922
LGA    K    31_B      R      15          0.846
LGA    G    32_B      G      16          0.806
LGA    I    33_B      I      17          0.523
LGA    G    34_B      G      18          0.823
LGA    Y    35_B      L      19          0.932
LGA    A    36_B      A      20          0.455
LGA    I    37_B      I      21          0.589
LGA    V    38_B      A      22          0.138
LGA    E    39_B      L      23          0.557
LGA    E    40_B      R      24          1.128
LGA    L    41_B      A      25          1.372
LGA    A    42_B      A      26          1.511
LGA    G    43_B      R      27          1.465
LGA    L    44_B      D      28          2.495
LGA    G    45_B      G      29          2.847
LGA    A    46_B      A      30          1.720
LGA    R    47_B      N      31          1.066
LGA    V    48_B      V      32          0.896
LGA    Y    49_B      A      33          0.641
LGA    T    50_B      I      34          0.844
LGA    C    51_B      A      35          1.981
LGA    S    52_B      A      36          1.630
LGA    R    53_B      K      37          1.438
LGA    N    54_B      S      38          1.423
LGA    E    55_B      A      39          0.889
LGA    K    56_B      V      40          2.325
LGA    -       -      A      41           -
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    E    57_B      T      48          2.160
LGA    L    58_B      I      49          2.138
LGA    D    59_B      H      50          1.941
LGA    E    60_B      S      51          2.281
LGA    C    61_B      A      52          2.499
LGA    L    62_B      A      53          2.514
LGA    E    63_B      A      54          2.539
LGA    I    64_B      A      55          3.068
LGA    W    65_B      V      56          3.130
LGA    R    66_B      N      57          2.503
LGA    E    67_B      A      58          2.642
LGA    K    68_B      A      59          3.001
LGA    G    69_B      G      60          2.573
LGA    L    70_B      G      61          2.506
LGA    N    71_B      Q      62          1.697
LGA    V    72_B      G      63          1.407
LGA    E    73_B      L      64          1.234
LGA    G    74_B      A      65          1.491
LGA    S    75_B      L      66          1.444
LGA    V    76_B      K      67          1.247
LGA    C    77_B      C      68          1.202
LGA    D    78_B      D      69          1.066
LGA    L    79_B      I      70          1.140
LGA    L    80_B      R      71          1.102
LGA    S    81_B      E      72          1.206
LGA    R    82_B      E      73          1.613
LGA    T    83_B      D      74          1.317
LGA    E    84_B      Q      75          1.081
LGA    R    85_B      V      76          1.303
LGA    D    86_B      R      77          1.751
LGA    K    87_B      A      78          1.154
LGA    L    88_B      A      79          1.124
LGA    M    89_B      V      80          1.427
LGA    Q    90_B      A      81          1.402
LGA    T    91_B      A      82          1.008
LGA    V    92_B      T      83          1.467
LGA    A    93_B      V      84          1.939
LGA    H    94_B      D      85          1.167
LGA    V    95_B      T      86          1.390
LGA    F    96_B      F      87          2.294
LGA    D    97_B      G      88          1.966
LGA    G    98_B      G      89          3.821
LGA    K    99_B      -       -           -
LGA    L   100_B      I      90          1.170
LGA    N   101_B      D      91          0.795
LGA    I   102_B      I      92          0.284
LGA    L   103_B      L      93          0.162
LGA    V   104_B      V      94          0.212
LGA    N   105_B      N      95          0.770
LGA    N   106_B      N      96          0.494
LGA    A   107_B      A      97          2.442
LGA    G   108_B      S      98          2.688
LGA    V   109_B      A      99          1.170
LGA    V   110_B      I     100          1.245
LGA    I   111_B      W     101          2.359
LGA    H   112_B      L     102          3.513
LGA    K   113_B      R     103          2.656
LGA    E   114_B      G     104          2.065
LGA    A   115_B      T     105          2.003
LGA    K   116_B      L     106          1.957
LGA    D   117_B      D     107          2.164
LGA    F   118_B      T     108          1.595
LGA    T   119_B      P     109          2.331
LGA    E   120_B      M     110          2.230
LGA    K   121_B      K     111          1.733
LGA    D   122_B      R     112          1.633
LGA    Y   123_B      F     113          1.972
LGA    N   124_B      D     114          1.440
LGA    I   125_B      L     115          0.661
LGA    I   126_B      M     116          0.532
LGA    M   127_B      Q     117          0.385
LGA    G   128_B      Q     118          0.567
LGA    T   129_B      V     119          0.727
LGA    N   130_B      N     120          0.408
LGA    F   131_B      A     121          0.849
LGA    E   132_B      R     122          0.727
LGA    A   133_B      G     123          1.522
LGA    A   134_B      S     124          1.087
LGA    Y   135_B      F     125          0.386
LGA    H   136_B      V     126          0.986
LGA    L   137_B      C     127          1.072
LGA    S   138_B      A     128          0.385
LGA    Q   139_B      Q     129          0.811
LGA    I   140_B      A     130          1.524
LGA    A   141_B      C     131          1.001
LGA    Y   142_B      L     132          0.912
LGA    P   143_B      P     133          0.741
LGA    L   144_B      H     134          0.381
LGA    L   145_B      L     135          0.235
LGA    K   146_B      L     136          0.629
LGA    A   147_B      Q     137          1.128
LGA    S   148_B      A     138          0.899
LGA    Q   149_B      P     139          3.378
LGA    N   150_B      N     140          1.727
LGA    G   151_B      P     141          0.714
LGA    N   152_B      H     142          0.265
LGA    V   153_B      I     143          0.346
LGA    I   154_B      L     144          0.655
LGA    F   155_B      T     145          0.711
LGA    L   156_B      L     146          0.997
LGA    S   157_B      A     147          0.926
LGA    S   158_B      P     148          4.020
LGA    I   159_B      P     149           -
LGA    A   160_B      -       -           -
LGA    G   161_B      P     150          5.778
LGA    F   162_B      S     151          4.658
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    S   163_B      W     156          3.762
LGA    A   164_B      W     157          5.075
LGA    -       -      G     158           -
LGA    L   165_B      A     159          5.159
LGA    P   166_B      -       -           -
LGA    S   167_B      -       -           -
LGA    V   168_B      H     160          3.972
LGA    S   169_B      T     161          2.939
LGA    L   170_B      G     162          1.269
LGA    Y   171_B      Y     163          1.476
LGA    S   172_B      T     164          1.254
LGA    A   173_B      L     165          1.105
LGA    S   174_B      A     166          1.471
LGA    K   175_B      K     167          1.862
LGA    G   176_B      M     168          1.698
LGA    A   177_B      G     169          1.859
LGA    I   178_B      M     170          1.814
LGA    N   179_B      S     171          1.578
LGA    Q   180_B      L     172          1.978
LGA    M   181_B      V     173          1.924
LGA    T   182_B      T     174          1.529
LGA    K   183_B      L     175          2.022
LGA    S   184_B      G     176          1.880
LGA    L   185_B      L     177          1.534
LGA    A   186_B      A     178          1.410
LGA    C   187_B      A     179          2.136
LGA    E   188_B      E     180          1.555
LGA    W   189_B      F     181          1.197
LGA    A   190_B      G     182          2.380
LGA    K   191_B      P     183          3.183
LGA    D   192_B      Q     184          2.140
LGA    N   193_B      G     185          1.889
LGA    I   194_B      V     186          0.609
LGA    R   195_B      A     187          0.932
LGA    V   196_B      I     188          0.468
LGA    N   197_B      N     189          0.436
LGA    S   198_B      A     190          0.510
LGA    V   199_B      L     191          0.750
LGA    A   200_B      W     192          1.663
LGA    P   201_B      P     193          2.413
LGA    -       -      R     194           -
LGA    G   202_B      T     195          3.322
LGA    V   203_B      V     196          0.936
LGA    I   204_B      I     197          0.562
LGA    L   205_B      A     198          0.727
LGA    T   206_B      T     199          0.213
LGA    P   207_B      D     200          0.972
LGA    L   208_B      A     201          1.308
LGA    V   209_B      I     202          1.232
LGA    E   210_B      N     203          3.484
LGA    T   211_B      -       -           -
LGA    A   212_B      M     204          2.891
LGA    I   213_B      -       -           -
LGA    K   214_B      -       -           -
LGA    K   215_B      -       -           -
LGA    N   216_B      -       -           -
LGA    P   217_B      -       -           -
LGA    H   218_B      -       -           -
LGA    Q   219_B      L     205          3.814
LGA    K   220_B      P     206          2.830
LGA    E   221_B      G     207          2.675
LGA    E   222_B      -       -           -
LGA    I   223_B      -       -           -
LGA    D   224_B      V     208          3.998
LGA    N   225_B      D     209           -
LGA    F   226_B      A     210           -
LGA    I   227_B      A     211           -
LGA    V   228_B      -       -           -
LGA    K   229_B      -       -           -
LGA    T   230_B      -       -           -
LGA    P   231_B      -       -           -
LGA    M   232_B      -       -           -
LGA    G   233_B      -       -           -
LGA    R   234_B      A     212          3.941
LGA    A   235_B      C     213          1.561
LGA    G   236_B      R     214          1.981
LGA    K   237_B      R     215          1.588
LGA    P   238_B      P     216          0.708
LGA    Q   239_B      E     217          1.016
LGA    E   240_B      I     218          0.610
LGA    V   241_B      M     219          0.947
LGA    S   242_B      A     220          1.551
LGA    A   243_B      D     221          1.459
LGA    L   244_B      A     222          1.618
LGA    I   245_B      A     223          1.344
LGA    A   246_B      H     224          1.242
LGA    F   247_B      A     225          1.319
LGA    L   248_B      V     226          1.367
LGA    C   249_B      L     227          1.350
LGA    F   250_B      T     228          1.238
LGA    P   251_B      R     229          3.116
LGA    A   252_B      E     230          4.836
LGA    A   253_B      A     231           #
LGA    S   254_B      A     232          4.924
LGA    Y   255_B      G     233          3.748
LGA    I   256_B      F     234          2.772
LGA    T   257_B      H     235          1.531
LGA    G   258_B      G     236          0.440
LGA    Q   259_B      Q     237          0.754
LGA    I   260_B      F     238          0.862
LGA    I   261_B      L     239          1.683
LGA    W   262_B      I     240          2.922
LGA    A   263_B      D     241          3.360
LGA    D   264_B      D     242           #
LGA    -       -      E     243           -
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    G   265_B      L     264           #
LGA    G   266_B      L     265           -
LGA    F   267_B      P     266          3.770
LGA    -       -      D     267           -
LGA    -       -      L     268           -
LGA    -       -      F     269           -
LGA    -       -      L     270           -
LGA    T   268_B      E     271          2.527
LGA    A   269_B      -       -           -
LGA    N   270_B      -       -           -
LGA    G   271_B      -       -           -
LGA    G   272_B      -       -           -
LGA    F   273_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  258  271    5.0    225    1.95    21.33     73.252    10.989

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.973726 * X  +  -0.107263 * Y  +   0.200880 * Z  + 108.208496
  Y_new =   0.059252 * X  +  -0.971074 * Y  +  -0.231310 * Z  + 145.373474
  Z_new =   0.219880 * X  +  -0.213330 * Y  +   0.951916 * Z  +  66.735115 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.220463    2.921129  [ DEG:   -12.6316    167.3684 ]
  Theta =  -0.221692   -2.919901  [ DEG:   -12.7020   -167.2980 ]
  Phi   =   3.080817   -0.060776  [ DEG:   176.5178     -3.4822 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ae1_B                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ae1_B.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  258  271   5.0  225   1.95   21.33  73.252
REMARK  ---------------------------------------------------------- 
MOLECULE 1ae1_B
HEADER    OXIDOREDUCTASE                          23-OCT-97   1AE1              
TITLE     TROPINONE REDUCTASE-I COMPLEX WITH NADP                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TROPINONE REDUCTASE-I;                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.1.1.236;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DATURA STRAMONIUM;                              
SOURCE   3 ORGANISM_COMMON: JIMSONWEED;                                         
SOURCE   4 CELL_LINE: BL21;                                                     
SOURCE   5 ORGAN: CULTURED ROOT;                                                
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PET21D;                                    
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PETTR1                                    
KEYWDS    OXIDOREDUCTASE, TROPANE ALKALOID BIOSYNTHESIS, REDUCTION OF           
KEYWDS   2 TROPINONE TO TROPINE, SHORT-CHAIN DEHYDROGENASE                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.NAKAJIMA,A.YAMASHITA,H.AKAMA,T.NAKATSU,H.KATO,T.HASHIMOTO,          
AUTHOR   2 J.ODA,Y.YAMADA                                                       
REVDAT   1   18-NOV-98 1AE1    0                                                
JRNL        AUTH   K.NAKAJIMA,A.YAMASHITA,H.AKAMA,T.NAKATSU,H.KATO,             
JRNL        AUTH 2 T.HASHIMOTO,J.ODA,Y.YAMADA                                   
JRNL        TITL   CRYSTAL STRUCTURES OF TWO TROPINONE REDUCTASES:              
JRNL        TITL 2 DIFFERENT REACTION STEREOSPECIFICITIES IN THE SAME           
JRNL        TITL 3 PROTEIN FOLD.                                                
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.  95  4876 1998              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  1AE1 A    1   273  UNP    P50162   TRN1_DATST       1    273             
DBREF  1AE1 B    1   273  UNP    P50162   TRN1_DATST       1    273             
SEQRES   1 A  273  MET GLU GLU SER LYS VAL SER MET MET ASN CYS ASN ASN          
SEQRES   2 A  273  GLU GLY ARG TRP SER LEU LYS GLY THR THR ALA LEU VAL          
SEQRES   3 A  273  THR GLY GLY SER LYS GLY ILE GLY TYR ALA ILE VAL GLU          
SEQRES   4 A  273  GLU LEU ALA GLY LEU GLY ALA ARG VAL TYR THR CYS SER          
SEQRES   5 A  273  ARG ASN GLU LYS GLU LEU ASP GLU CYS LEU GLU ILE TRP          
SEQRES   6 A  273  ARG GLU LYS GLY LEU ASN VAL GLU GLY SER VAL CYS ASP          
SEQRES   7 A  273  LEU LEU SER ARG THR GLU ARG ASP LYS LEU MET GLN THR          
SEQRES   8 A  273  VAL ALA HIS VAL PHE ASP GLY LYS LEU ASN ILE LEU VAL          
SEQRES   9 A  273  ASN ASN ALA GLY VAL VAL ILE HIS LYS GLU ALA LYS ASP          
SEQRES  10 A  273  PHE THR GLU LYS ASP TYR ASN ILE ILE MET GLY THR ASN          
SEQRES  11 A  273  PHE GLU ALA ALA TYR HIS LEU SER GLN ILE ALA TYR PRO          
SEQRES  12 A  273  LEU LEU LYS ALA SER GLN ASN GLY ASN VAL ILE PHE LEU          
SEQRES  13 A  273  SER SER ILE ALA GLY PHE SER ALA LEU PRO SER VAL SER          
SEQRES  14 A  273  LEU TYR SER ALA SER LYS GLY ALA ILE ASN GLN MET THR          
SEQRES  15 A  273  LYS SER LEU ALA CYS GLU TRP ALA LYS ASP ASN ILE ARG          
SEQRES  16 A  273  VAL ASN SER VAL ALA PRO GLY VAL ILE LEU THR PRO LEU          
SEQRES  17 A  273  VAL GLU THR ALA ILE LYS LYS ASN PRO HIS GLN LYS GLU          
SEQRES  18 A  273  GLU ILE ASP ASN PHE ILE VAL LYS THR PRO MET GLY ARG          
SEQRES  19 A  273  ALA GLY LYS PRO GLN GLU VAL SER ALA LEU ILE ALA PHE          
SEQRES  20 A  273  LEU CYS PHE PRO ALA ALA SER TYR ILE THR GLY GLN ILE          
SEQRES  21 A  273  ILE TRP ALA ASP GLY GLY PHE THR ALA ASN GLY GLY PHE          
SEQRES   1 B  273  MET GLU GLU SER LYS VAL SER MET MET ASN CYS ASN ASN          
SEQRES   2 B  273  GLU GLY ARG TRP SER LEU LYS GLY THR THR ALA LEU VAL          
SEQRES   3 B  273  THR GLY GLY SER LYS GLY ILE GLY TYR ALA ILE VAL GLU          
SEQRES   4 B  273  GLU LEU ALA GLY LEU GLY ALA ARG VAL TYR THR CYS SER          
SEQRES   5 B  273  ARG ASN GLU LYS GLU LEU ASP GLU CYS LEU GLU ILE TRP          
SEQRES   6 B  273  ARG GLU LYS GLY LEU ASN VAL GLU GLY SER VAL CYS ASP          
SEQRES   7 B  273  LEU LEU SER ARG THR GLU ARG ASP LYS LEU MET GLN THR          
SEQRES   8 B  273  VAL ALA HIS VAL PHE ASP GLY LYS LEU ASN ILE LEU VAL          
SEQRES   9 B  273  ASN ASN ALA GLY VAL VAL ILE HIS LYS GLU ALA LYS ASP          
SEQRES  10 B  273  PHE THR GLU LYS ASP TYR ASN ILE ILE MET GLY THR ASN          
SEQRES  11 B  273  PHE GLU ALA ALA TYR HIS LEU SER GLN ILE ALA TYR PRO          
SEQRES  12 B  273  LEU LEU LYS ALA SER GLN ASN GLY ASN VAL ILE PHE LEU          
SEQRES  13 B  273  SER SER ILE ALA GLY PHE SER ALA LEU PRO SER VAL SER          
SEQRES  14 B  273  LEU TYR SER ALA SER LYS GLY ALA ILE ASN GLN MET THR          
SEQRES  15 B  273  LYS SER LEU ALA CYS GLU TRP ALA LYS ASP ASN ILE ARG          
SEQRES  16 B  273  VAL ASN SER VAL ALA PRO GLY VAL ILE LEU THR PRO LEU          
SEQRES  17 B  273  VAL GLU THR ALA ILE LYS LYS ASN PRO HIS GLN LYS GLU          
SEQRES  18 B  273  GLU ILE ASP ASN PHE ILE VAL LYS THR PRO MET GLY ARG          
SEQRES  19 B  273  ALA GLY LYS PRO GLN GLU VAL SER ALA LEU ILE ALA PHE          
SEQRES  20 B  273  LEU CYS PHE PRO ALA ALA SER TYR ILE THR GLY GLN ILE          
SEQRES  21 B  273  ILE TRP ALA ASP GLY GLY PHE THR ALA ASN GLY GLY PHE          
HET    NAP  A 274      48                                                       
HET    NAP  B 274      48                                                       
HETNAM     NAP NADP NICOTINAMIDE-ADENINE-DINUCLEOTIDE PHOSPHATE                 
HETSYN     NAP 2'-MONOPHOSPHOADENOSINE 5'-DIPHOSPHORIBOSE                       
FORMUL   3  NAP    2(C21 H28 N7 O17 P3)                                         
FORMUL   5  HOH   *98(H2 O)                                                     
CRYST1   55.740  122.750   75.510  90.00  90.00  90.00 P 21 21 2     8          
ATOM   1866  N   ARG B  16      59.470  28.557  48.599  1.00 36.23           N  
ATOM   1867  CA  ARG B  16      60.029  27.597  49.601  1.00 37.81           C  
ATOM   1868  C   ARG B  16      61.508  27.864  49.870  1.00 26.20           C  
ATOM   1869  O   ARG B  16      61.972  27.708  50.996  1.00 34.20           O  
ATOM   1870  CB  ARG B  16      59.834  26.146  49.132  1.00 39.39           C  
ATOM   1871  CG  ARG B  16      60.180  25.097  50.197  1.00 47.10           C  
ATOM   1872  CD  ARG B  16      59.768  23.680  49.793  1.00 43.30           C  
ATOM   1873  NE  ARG B  16      59.982  22.711  50.872  1.00 37.73           N  
ATOM   1874  CZ  ARG B  16      60.885  21.733  50.843  1.00 34.63           C  
ATOM   1875  NH1 ARG B  16      61.660  21.566  49.781  1.00 34.24           N  
ATOM   1876  NH2 ARG B  16      61.026  20.927  51.887  1.00 29.33           N  
ATOM   1877  N   TRP B  17      62.237  28.271  48.835  1.00 23.22           N  
ATOM   1878  CA  TRP B  17      63.628  28.682  48.982  1.00 19.65           C  
ATOM   1879  C   TRP B  17      63.856  30.107  48.458  1.00 19.12           C  
ATOM   1880  O   TRP B  17      64.874  30.383  47.817  1.00 24.59           O  
ATOM   1881  CB  TRP B  17      64.563  27.705  48.251  1.00 25.91           C  
ATOM   1882  CG  TRP B  17      64.411  26.243  48.638  1.00 29.52           C  
ATOM   1883  CD1 TRP B  17      63.515  25.351  48.120  1.00 28.26           C  
ATOM   1884  CD2 TRP B  17      65.231  25.499  49.558  1.00 24.43           C  
ATOM   1885  NE1 TRP B  17      63.725  24.103  48.655  1.00 32.48           N  
ATOM   1886  CE2 TRP B  17      64.769  24.160  49.539  1.00 27.08           C  
ATOM   1887  CE3 TRP B  17      66.301  25.829  50.404  1.00 29.90           C  
ATOM   1888  CZ2 TRP B  17      65.345  23.154  50.327  1.00 22.73           C  
ATOM   1889  CZ3 TRP B  17      66.873  24.825  51.196  1.00 14.76           C  
ATOM   1890  CH2 TRP B  17      66.390  23.507  51.146  1.00 27.96           C  
ATOM   1891  N   SER B  18      62.891  30.995  48.701  1.00 21.18           N  
ATOM   1892  CA  SER B  18      63.045  32.418  48.376  1.00 27.36           C  
ATOM   1893  C   SER B  18      62.510  33.321  49.490  1.00 27.87           C  
ATOM   1894  O   SER B  18      61.543  32.976  50.173  1.00 20.83           O  
ATOM   1895  CB  SER B  18      62.319  32.759  47.070  1.00 24.45           C  
ATOM   1896  OG  SER B  18      60.939  33.006  47.298  1.00 29.53           O  
ATOM   1897  N   LEU B  19      63.062  34.528  49.574  1.00 25.70           N  
ATOM   1898  CA  LEU B  19      62.598  35.524  50.532  1.00 19.36           C  
ATOM   1899  C   LEU B  19      61.906  36.663  49.808  1.00 20.98           C  
ATOM   1900  O   LEU B  19      61.777  37.760  50.346  1.00 18.42           O  
ATOM   1901  CB  LEU B  19      63.778  36.062  51.336  1.00 15.70           C  
ATOM   1902  CG  LEU B  19      64.386  35.010  52.259  1.00 14.64           C  
ATOM   1903  CD1 LEU B  19      65.756  35.451  52.710  1.00  8.66           C  
ATOM   1904  CD2 LEU B  19      63.459  34.778  53.437  1.00 10.53           C  
ATOM   1905  N   LYS B  20      61.448  36.386  48.587  1.00 27.59           N  
ATOM   1906  CA  LYS B  20      60.858  37.406  47.723  1.00 25.33           C  
ATOM   1907  C   LYS B  20      59.605  38.015  48.320  1.00 28.02           C  
ATOM   1908  O   LYS B  20      58.639  37.307  48.613  1.00 24.34           O  
ATOM   1909  CB  LYS B  20      60.539  36.832  46.344  1.00 18.74           C  
ATOM   1910  CG  LYS B  20      61.689  36.960  45.368  1.00 27.49           C  
ATOM   1911  CD  LYS B  20      61.433  36.169  44.100  1.00 43.30           C  
ATOM   1912  CE  LYS B  20      62.108  36.809  42.889  1.00 49.22           C  
ATOM   1913  NZ  LYS B  20      61.394  38.032  42.410  1.00 41.56           N  
ATOM   1914  N   GLY B  21      59.671  39.321  48.571  1.00 36.21           N  
ATOM   1915  CA  GLY B  21      58.542  40.039  49.131  1.00 36.23           C  
ATOM   1916  C   GLY B  21      58.484  39.973  50.645  1.00 38.85           C  
ATOM   1917  O   GLY B  21      57.400  40.057  51.241  1.00 42.66           O  
ATOM   1918  N   THR B  22      59.640  39.772  51.272  1.00 32.15           N  
ATOM   1919  CA  THR B  22      59.714  39.777  52.726  1.00 20.20           C  
ATOM   1920  C   THR B  22      60.364  41.062  53.221  1.00 17.74           C  
ATOM   1921  O   THR B  22      61.126  41.705  52.506  1.00 13.86           O  
ATOM   1922  CB  THR B  22      60.496  38.546  53.279  1.00 19.67           C  
ATOM   1923  OG1 THR B  22      61.856  38.578  52.826  1.00 14.72           O  
ATOM   1924  CG2 THR B  22      59.821  37.240  52.842  1.00 12.68           C  
ATOM   1925  N   THR B  23      59.996  41.460  54.430  1.00 21.16           N  
ATOM   1926  CA  THR B  23      60.555  42.641  55.064  1.00 12.60           C  
ATOM   1927  C   THR B  23      61.495  42.205  56.173  1.00 10.69           C  
ATOM   1928  O   THR B  23      61.181  41.302  56.942  1.00 16.85           O  
ATOM   1929  CB  THR B  23      59.437  43.492  55.648  1.00  5.18           C  
ATOM   1930  OG1 THR B  23      58.562  42.656  56.408  1.00 19.80           O  
ATOM   1931  CG2 THR B  23      58.636  44.155  54.529  1.00  6.01           C  
ATOM   1932  N   ALA B  24      62.637  42.867  56.270  1.00 15.71           N  
ATOM   1933  CA  ALA B  24      63.663  42.477  57.224  1.00 17.99           C  
ATOM   1934  C   ALA B  24      64.299  43.691  57.901  1.00 21.40           C  
ATOM   1935  O   ALA B  24      64.542  44.721  57.262  1.00 21.27           O  
ATOM   1936  CB  ALA B  24      64.738  41.627  56.521  1.00  9.56           C  
ATOM   1937  N   LEU B  25      64.522  43.576  59.206  1.00 13.74           N  
ATOM   1938  CA  LEU B  25      65.365  44.517  59.928  1.00  8.32           C  
ATOM   1939  C   LEU B  25      66.632  43.815  60.424  1.00 11.67           C  
ATOM   1940  O   LEU B  25      66.560  42.871  61.211  1.00 14.71           O  
ATOM   1941  CB  LEU B  25      64.597  45.114  61.109  1.00  6.41           C  
ATOM   1942  CG  LEU B  25      65.421  46.023  62.028  1.00 18.77           C  
ATOM   1943  CD1 LEU B  25      65.901  47.248  61.261  1.00  8.85           C  
ATOM   1944  CD2 LEU B  25      64.590  46.425  63.233  1.00 20.89           C  
ATOM   1945  N   VAL B  26      67.782  44.232  59.903  1.00 18.10           N  
ATOM   1946  CA  VAL B  26      69.073  43.729  60.370  1.00 15.55           C  
ATOM   1947  C   VAL B  26      69.838  44.846  61.064  1.00 23.65           C  
ATOM   1948  O   VAL B  26      70.248  45.817  60.425  1.00 22.46           O  
ATOM   1949  CB  VAL B  26      69.937  43.213  59.209  1.00 14.14           C  
ATOM   1950  CG1 VAL B  26      71.256  42.645  59.741  1.00  7.09           C  
ATOM   1951  CG2 VAL B  26      69.174  42.168  58.422  1.00 11.37           C  
ATOM   1952  N   THR B  27      70.019  44.714  62.373  1.00 23.75           N  
ATOM   1953  CA  THR B  27      70.765  45.706  63.142  1.00 19.93           C  
ATOM   1954  C   THR B  27      72.262  45.567  62.906  1.00 19.88           C  
ATOM   1955  O   THR B  27      72.771  44.447  62.768  1.00 21.02           O  
ATOM   1956  CB  THR B  27      70.498  45.555  64.627  1.00 11.95           C  
ATOM   1957  OG1 THR B  27      70.828  44.221  65.023  1.00 10.74           O  
ATOM   1958  CG2 THR B  27      69.032  45.828  64.929  1.00  2.72           C  
ATOM   1959  N   GLY B  28      72.949  46.705  62.822  1.00 13.18           N  
ATOM   1960  CA  GLY B  28      74.394  46.698  62.645  1.00 13.86           C  
ATOM   1961  C   GLY B  28      74.858  46.088  61.335  1.00 15.60           C  
ATOM   1962  O   GLY B  28      75.603  45.103  61.335  1.00 16.00           O  
ATOM   1963  N   GLY B  29      74.452  46.704  60.224  1.00 10.83           N  
ATOM   1964  CA  GLY B  29      74.731  46.155  58.911  1.00  7.68           C  
ATOM   1965  C   GLY B  29      75.754  46.910  58.080  1.00 11.50           C  
ATOM   1966  O   GLY B  29      75.827  46.724  56.871  1.00 13.14           O  
ATOM   1967  N   SER B  30      76.568  47.743  58.717  1.00 10.20           N  
ATOM   1968  CA  SER B  30      77.545  48.532  57.972  1.00 16.08           C  
ATOM   1969  C   SER B  30      78.889  47.825  57.861  1.00 19.05           C  
ATOM   1970  O   SER B  30      79.750  48.238  57.077  1.00 25.09           O  
ATOM   1971  CB  SER B  30      77.724  49.921  58.600  1.00 12.91           C  
ATOM   1972  OG  SER B  30      77.933  49.836  59.997  1.00 15.44           O  
ATOM   1973  N   LYS B  31      79.082  46.779  58.663  1.00 15.30           N  
ATOM   1974  CA  LYS B  31      80.287  45.971  58.553  1.00 14.43           C  
ATOM   1975  C   LYS B  31      80.145  44.553  59.087  1.00 18.98           C  
ATOM   1976  O   LYS B  31      79.102  44.181  59.627  1.00 12.81           O  
ATOM   1977  CB  LYS B  31      81.470  46.663  59.234  1.00 11.96           C  
ATOM   1978  CG  LYS B  31      81.129  47.467  60.465  1.00 21.88           C  
ATOM   1979  CD  LYS B  31      82.175  48.542  60.673  1.00 28.23           C  
ATOM   1980  CE  LYS B  31      81.765  49.525  61.751  1.00 42.97           C  
ATOM   1981  NZ  LYS B  31      82.658  49.464  62.952  1.00 59.27           N  
ATOM   1982  N   GLY B  32      81.133  43.726  58.748  1.00 10.48           N  
ATOM   1983  CA  GLY B  32      81.252  42.407  59.333  1.00 18.51           C  
ATOM   1984  C   GLY B  32      80.194  41.434  58.866  1.00 19.48           C  
ATOM   1985  O   GLY B  32      79.822  41.399  57.691  1.00 27.91           O  
ATOM   1986  N   ILE B  33      79.715  40.629  59.802  1.00 16.91           N  
ATOM   1987  CA  ILE B  33      78.665  39.669  59.523  1.00 14.28           C  
ATOM   1988  C   ILE B  33      77.369  40.394  59.151  1.00 13.26           C  
ATOM   1989  O   ILE B  33      76.659  39.979  58.235  1.00 21.79           O  
ATOM   1990  CB  ILE B  33      78.448  38.747  60.742  1.00 14.18           C  
ATOM   1991  CG1 ILE B  33      79.765  38.040  61.087  1.00  8.83           C  
ATOM   1992  CG2 ILE B  33      77.348  37.726  60.449  1.00 14.01           C  
ATOM   1993  CD1 ILE B  33      79.831  37.496  62.503  1.00 10.03           C  
ATOM   1994  N   GLY B  34      77.160  41.561  59.750  1.00 17.57           N  
ATOM   1995  CA  GLY B  34      75.960  42.334  59.487  1.00  7.32           C  
ATOM   1996  C   GLY B  34      75.842  42.811  58.054  1.00 10.92           C  
ATOM   1997  O   GLY B  34      74.749  42.807  57.501  1.00 19.84           O  
ATOM   1998  N   TYR B  35      76.962  43.217  57.456  1.00 12.27           N  
ATOM   1999  CA  TYR B  35      77.012  43.616  56.045  1.00 15.61           C  
ATOM   2000  C   TYR B  35      76.675  42.425  55.133  1.00 17.56           C  
ATOM   2001  O   TYR B  35      75.924  42.554  54.155  1.00 16.56           O  
ATOM   2002  CB  TYR B  35      78.411  44.158  55.718  1.00  4.13           C  
ATOM   2003  CG  TYR B  35      78.562  44.737  54.331  1.00 21.71           C  
ATOM   2004  CD1 TYR B  35      78.937  43.932  53.259  1.00 19.53           C  
ATOM   2005  CD2 TYR B  35      78.355  46.098  54.089  1.00 29.72           C  
ATOM   2006  CE1 TYR B  35      79.102  44.458  51.985  1.00 28.46           C  
ATOM   2007  CE2 TYR B  35      78.509  46.636  52.807  1.00 29.31           C  
ATOM   2008  CZ  TYR B  35      78.880  45.805  51.763  1.00 32.63           C  
ATOM   2009  OH  TYR B  35      78.997  46.301  50.486  1.00 39.83           O  
ATOM   2010  N   ALA B  36      77.205  41.258  55.481  1.00 14.33           N  
ATOM   2011  CA  ALA B  36      76.977  40.059  54.696  1.00 10.81           C  
ATOM   2012  C   ALA B  36      75.510  39.633  54.757  1.00 12.32           C  
ATOM   2013  O   ALA B  36      74.950  39.191  53.757  1.00 19.02           O  
ATOM   2014  CB  ALA B  36      77.877  38.940  55.189  1.00 13.33           C  
ATOM   2015  N   ILE B  37      74.877  39.822  55.911  1.00 12.65           N  
ATOM   2016  CA  ILE B  37      73.483  39.419  56.087  1.00 14.90           C  
ATOM   2017  C   ILE B  37      72.507  40.249  55.262  1.00 19.58           C  
ATOM   2018  O   ILE B  37      71.565  39.692  54.690  1.00 24.32           O  
ATOM   2019  CB  ILE B  37      73.033  39.466  57.571  1.00 13.67           C  
ATOM   2020  CG1 ILE B  37      73.916  38.558  58.419  1.00 16.26           C  
ATOM   2021  CG2 ILE B  37      71.594  38.971  57.701  1.00 13.86           C  
ATOM   2022  CD1 ILE B  37      73.638  38.659  59.885  1.00 21.87           C  
ATOM   2023  N   VAL B  38      72.694  41.570  55.206  1.00 21.15           N  
ATOM   2024  CA  VAL B  38      71.753  42.385  54.429  1.00 22.09           C  
ATOM   2025  C   VAL B  38      71.931  42.118  52.935  1.00 13.78           C  
ATOM   2026  O   VAL B  38      70.948  41.935  52.221  1.00  7.25           O  
ATOM   2027  CB  VAL B  38      71.806  43.951  54.755  1.00 20.18           C  
ATOM   2028  CG1 VAL B  38      72.786  44.268  55.861  1.00 10.52           C  
ATOM   2029  CG2 VAL B  38      72.118  44.756  53.516  1.00 20.35           C  
ATOM   2030  N   GLU B  39      73.164  41.827  52.537  1.00 11.15           N  
ATOM   2031  CA  GLU B  39      73.451  41.503  51.147  1.00 14.81           C  
ATOM   2032  C   GLU B  39      72.906  40.123  50.776  1.00 20.95           C  
ATOM   2033  O   GLU B  39      72.444  39.916  49.654  1.00 22.47           O  
ATOM   2034  CB  GLU B  39      74.956  41.567  50.896  1.00 21.25           C  
ATOM   2035  CG  GLU B  39      75.309  42.037  49.505  1.00 24.26           C  
ATOM   2036  CD  GLU B  39      76.663  42.700  49.441  1.00 29.04           C  
ATOM   2037  OE1 GLU B  39      77.679  41.978  49.431  1.00 42.61           O  
ATOM   2038  OE2 GLU B  39      76.718  43.943  49.364  1.00 29.63           O  
ATOM   2039  N   GLU B  40      72.857  39.222  51.754  1.00 20.86           N  
ATOM   2040  CA  GLU B  40      72.317  37.882  51.548  1.00 11.55           C  
ATOM   2041  C   GLU B  40      70.780  37.889  51.426  1.00 14.88           C  
ATOM   2042  O   GLU B  40      70.230  37.358  50.460  1.00 19.85           O  
ATOM   2043  CB  GLU B  40      72.768  36.957  52.689  1.00  8.10           C  
ATOM   2044  CG  GLU B  40      72.506  35.450  52.474  1.00  9.44           C  
ATOM   2045  CD  GLU B  40      73.524  34.787  51.554  1.00  9.39           C  
ATOM   2046  OE1 GLU B  40      74.633  34.452  52.020  1.00 14.84           O  
ATOM   2047  OE2 GLU B  40      73.220  34.612  50.354  1.00 22.89           O  
ATOM   2048  N   LEU B  41      70.092  38.516  52.377  1.00 11.54           N  
ATOM   2049  CA  LEU B  41      68.629  38.520  52.378  1.00 10.63           C  
ATOM   2050  C   LEU B  41      68.107  39.338  51.203  1.00 15.05           C  
ATOM   2051  O   LEU B  41      67.067  39.021  50.618  1.00 15.92           O  
ATOM   2052  CB  LEU B  41      68.080  39.111  53.685  1.00 11.50           C  
ATOM   2053  CG  LEU B  41      68.524  38.550  55.038  1.00 16.03           C  
ATOM   2054  CD1 LEU B  41      67.731  39.218  56.149  1.00  6.76           C  
ATOM   2055  CD2 LEU B  41      68.305  37.056  55.080  1.00 12.45           C  
ATOM   2056  N   ALA B  42      68.793  40.440  50.918  1.00 21.36           N  
ATOM   2057  CA  ALA B  42      68.385  41.353  49.855  1.00 22.44           C  
ATOM   2058  C   ALA B  42      68.619  40.699  48.493  1.00 26.93           C  
ATOM   2059  O   ALA B  42      67.846  40.903  47.553  1.00 24.70           O  
ATOM   2060  CB  ALA B  42      69.163  42.673  49.959  1.00 14.68           C  
ATOM   2061  N   GLY B  43      69.669  39.886  48.408  1.00 24.89           N  
ATOM   2062  CA  GLY B  43      69.897  39.090  47.217  1.00 24.82           C  
ATOM   2063  C   GLY B  43      68.840  38.019  46.989  1.00 27.84           C  
ATOM   2064  O   GLY B  43      68.550  37.670  45.844  1.00 33.87           O  
ATOM   2065  N   LEU B  44      68.259  37.501  48.070  1.00 19.95           N  
ATOM   2066  CA  LEU B  44      67.207  36.494  47.976  1.00  7.05           C  
ATOM   2067  C   LEU B  44      65.838  37.123  47.747  1.00 11.13           C  
ATOM   2068  O   LEU B  44      64.845  36.415  47.569  1.00 19.60           O  
ATOM   2069  CB  LEU B  44      67.179  35.661  49.255  1.00 19.44           C  
ATOM   2070  CG  LEU B  44      68.019  34.381  49.352  1.00 26.50           C  
ATOM   2071  CD1 LEU B  44      68.760  34.096  48.051  1.00 25.45           C  
ATOM   2072  CD2 LEU B  44      68.985  34.512  50.513  1.00 16.86           C  
ATOM   2073  N   GLY B  45      65.764  38.440  47.936  1.00 19.34           N  
ATOM   2074  CA  GLY B  45      64.585  39.186  47.528  1.00 12.57           C  
ATOM   2075  C   GLY B  45      63.861  39.926  48.638  1.00 14.76           C  
ATOM   2076  O   GLY B  45      62.740  40.400  48.430  1.00 22.33           O  
ATOM   2077  N   ALA B  46      64.473  40.000  49.818  1.00 13.92           N  
ATOM   2078  CA  ALA B  46      63.875  40.711  50.946  1.00 12.98           C  
ATOM   2079  C   ALA B  46      64.049  42.227  50.821  1.00 16.01           C  
ATOM   2080  O   ALA B  46      65.020  42.703  50.226  1.00 19.51           O  
ATOM   2081  CB  ALA B  46      64.483  40.213  52.262  1.00 11.02           C  
ATOM   2082  N   ARG B  47      63.013  42.962  51.219  1.00 21.16           N  
ATOM   2083  CA  ARG B  47      63.122  44.386  51.536  1.00 18.88           C  
ATOM   2084  C   ARG B  47      63.867  44.494  52.860  1.00 21.69           C  
ATOM   2085  O   ARG B  47      63.377  44.007  53.876  1.00 25.49           O  
ATOM   2086  CB  ARG B  47      61.731  45.002  51.718  1.00 19.18           C  
ATOM   2087  CG  ARG B  47      60.969  45.277  50.443  1.00 27.45           C  
ATOM   2088  CD  ARG B  47      60.103  46.527  50.593  1.00 34.20           C  
ATOM   2089  NE  ARG B  47      58.846  46.268  51.297  1.00 42.05           N  
ATOM   2090  CZ  ARG B  47      58.035  47.217  51.762  1.00 33.45           C  
ATOM   2091  NH1 ARG B  47      58.371  48.500  51.658  1.00 38.59           N  
ATOM   2092  NH2 ARG B  47      56.895  46.883  52.355  1.00 32.77           N  
ATOM   2093  N   VAL B  48      65.063  45.079  52.847  1.00 20.25           N  
ATOM   2094  CA  VAL B  48      65.865  45.160  54.064  1.00 17.32           C  
ATOM   2095  C   VAL B  48      66.008  46.568  54.623  1.00 17.93           C  
ATOM   2096  O   VAL B  48      66.262  47.521  53.889  1.00 29.55           O  
ATOM   2097  CB  VAL B  48      67.277  44.591  53.856  1.00 13.33           C  
ATOM   2098  CG1 VAL B  48      68.007  44.548  55.187  1.00 13.97           C  
ATOM   2099  CG2 VAL B  48      67.208  43.200  53.246  1.00 19.81           C  
ATOM   2100  N   TYR B  49      65.932  46.665  55.943  1.00 21.15           N  
ATOM   2101  CA  TYR B  49      66.221  47.901  56.658  1.00 18.54           C  
ATOM   2102  C   TYR B  49      67.342  47.600  57.636  1.00 15.59           C  
ATOM   2103  O   TYR B  49      67.334  46.566  58.302  1.00 21.39           O  
ATOM   2104  CB  TYR B  49      64.988  48.376  57.425  1.00 19.07           C  
ATOM   2105  CG  TYR B  49      65.026  49.837  57.788  1.00 22.50           C  
ATOM   2106  CD1 TYR B  49      65.803  50.297  58.852  1.00 30.17           C  
ATOM   2107  CD2 TYR B  49      64.322  50.771  57.033  1.00 25.64           C  
ATOM   2108  CE1 TYR B  49      65.884  51.659  59.147  1.00 34.03           C  
ATOM   2109  CE2 TYR B  49      64.390  52.131  57.321  1.00 34.63           C  
ATOM   2110  CZ  TYR B  49      65.174  52.570  58.373  1.00 35.89           C  
ATOM   2111  OH  TYR B  49      65.258  53.916  58.626  1.00 27.52           O  
ATOM   2112  N   THR B  50      68.334  48.475  57.682  1.00 10.75           N  
ATOM   2113  CA  THR B  50      69.456  48.283  58.578  1.00 10.61           C  
ATOM   2114  C   THR B  50      69.822  49.592  59.291  1.00 15.28           C  
ATOM   2115  O   THR B  50      69.046  50.552  59.269  1.00 14.56           O  
ATOM   2116  CB  THR B  50      70.658  47.639  57.813  1.00  9.42           C  
ATOM   2117  OG1 THR B  50      71.702  47.322  58.742  1.00 14.82           O  
ATOM   2118  CG2 THR B  50      71.186  48.551  56.709  1.00  2.95           C  
ATOM   2119  N   CYS B  51      70.881  49.563  60.089  1.00 15.48           N  
ATOM   2120  CA  CYS B  51      71.220  50.692  60.946  1.00 14.77           C  
ATOM   2121  C   CYS B  51      72.613  50.524  61.535  1.00 16.35           C  
ATOM   2122  O   CYS B  51      73.100  49.405  61.669  1.00 30.78           O  
ATOM   2123  CB  CYS B  51      70.188  50.822  62.077  1.00 16.70           C  
ATOM   2124  SG  CYS B  51      70.362  49.653  63.459  1.00 19.64           S  
ATOM   2125  N   SER B  52      73.295  51.640  61.767  1.00 19.00           N  
ATOM   2126  CA  SER B  52      74.530  51.643  62.547  1.00 19.12           C  
ATOM   2127  C   SER B  52      74.703  53.015  63.201  1.00 16.33           C  
ATOM   2128  O   SER B  52      73.746  53.777  63.277  1.00 15.89           O  
ATOM   2129  CB  SER B  52      75.730  51.294  61.662  1.00 12.58           C  
ATOM   2130  OG  SER B  52      76.152  52.398  60.883  1.00 33.14           O  
ATOM   2131  N   ARG B  53      75.898  53.310  63.706  1.00 17.51           N  
ATOM   2132  CA  ARG B  53      76.119  54.543  64.471  1.00 29.20           C  
ATOM   2133  C   ARG B  53      76.924  55.620  63.712  1.00 26.81           C  
ATOM   2134  O   ARG B  53      77.184  56.702  64.237  1.00 35.29           O  
ATOM   2135  CB  ARG B  53      76.803  54.211  65.807  1.00 19.93           C  
ATOM   2136  CG  ARG B  53      75.884  53.545  66.826  1.00 26.29           C  
ATOM   2137  CD  ARG B  53      76.641  53.191  68.094  1.00 26.71           C  
ATOM   2138  NE  ARG B  53      77.678  52.197  67.841  1.00 31.51           N  
ATOM   2139  CZ  ARG B  53      78.709  51.952  68.645  1.00 27.49           C  
ATOM   2140  NH1 ARG B  53      78.713  52.404  69.891  1.00 26.45           N  
ATOM   2141  NH2 ARG B  53      79.693  51.164  68.232  1.00 31.94           N  
ATOM   2142  N   ASN B  54      77.277  55.330  62.467  1.00 24.73           N  
ATOM   2143  CA  ASN B  54      78.039  56.256  61.641  1.00 28.13           C  
ATOM   2144  C   ASN B  54      77.275  56.469  60.326  1.00 30.99           C  
ATOM   2145  O   ASN B  54      77.222  55.570  59.488  1.00 41.26           O  
ATOM   2146  CB  ASN B  54      79.420  55.648  61.385  1.00 24.03           C  
ATOM   2147  CG  ASN B  54      80.376  56.597  60.682  1.00 24.58           C  
ATOM   2148  OD1 ASN B  54      81.580  56.532  60.912  1.00 36.11           O  
ATOM   2149  ND2 ASN B  54      79.879  57.349  59.710  1.00 19.88           N  
ATOM   2150  N   GLU B  55      76.742  57.674  60.128  1.00 33.31           N  
ATOM   2151  CA  GLU B  55      75.932  57.972  58.943  1.00 34.59           C  
ATOM   2152  C   GLU B  55      76.756  57.890  57.675  1.00 32.87           C  
ATOM   2153  O   GLU B  55      76.277  57.416  56.652  1.00 32.56           O  
ATOM   2154  CB  GLU B  55      75.290  59.363  59.034  1.00 53.09           C  
ATOM   2155  CG  GLU B  55      74.195  59.593  57.976  1.00 74.69           C  
ATOM   2156  CD  GLU B  55      73.552  60.976  58.038  1.00 81.50           C  
ATOM   2157  OE1 GLU B  55      72.607  61.161  58.836  1.00 85.43           O  
ATOM   2158  OE2 GLU B  55      73.926  61.851  57.224  1.00 87.83           O  
ATOM   2159  N   LYS B  56      78.013  58.314  57.758  1.00 28.20           N  
ATOM   2160  CA  LYS B  56      78.892  58.297  56.598  1.00 31.88           C  
ATOM   2161  C   LYS B  56      79.121  56.870  56.118  1.00 26.50           C  
ATOM   2162  O   LYS B  56      79.015  56.595  54.926  1.00 29.15           O  
ATOM   2163  CB  LYS B  56      80.230  58.969  56.930  1.00 42.20           C  
ATOM   2164  CG  LYS B  56      81.298  58.766  55.867  1.00 58.81           C  
ATOM   2165  CD  LYS B  56      82.225  59.964  55.741  1.00 65.13           C  
ATOM   2166  CE  LYS B  56      83.117  59.813  54.516  1.00 71.28           C  
ATOM   2167  NZ  LYS B  56      83.692  58.434  54.411  1.00 70.90           N  
ATOM   2168  N   GLU B  57      79.359  55.965  57.064  1.00 28.14           N  
ATOM   2169  CA  GLU B  57      79.590  54.551  56.770  1.00 23.16           C  
ATOM   2170  C   GLU B  57      78.303  53.898  56.296  1.00 21.11           C  
ATOM   2171  O   GLU B  57      78.291  53.174  55.303  1.00 26.47           O  
ATOM   2172  CB  GLU B  57      80.103  53.821  58.014  1.00 20.56           C  
ATOM   2173  CG  GLU B  57      81.566  54.098  58.335  1.00 23.69           C  
ATOM   2174  CD  GLU B  57      82.002  53.585  59.708  1.00 26.94           C  
ATOM   2175  OE1 GLU B  57      81.145  53.279  60.564  1.00 35.20           O  
ATOM   2176  OE2 GLU B  57      83.222  53.544  59.953  1.00 35.86           O  
ATOM   2177  N   LEU B  58      77.207  54.219  56.971  1.00 15.88           N  
ATOM   2178  CA  LEU B  58      75.903  53.728  56.572  1.00 17.27           C  
ATOM   2179  C   LEU B  58      75.569  54.171  55.144  1.00 24.54           C  
ATOM   2180  O   LEU B  58      75.087  53.370  54.343  1.00 38.10           O  
ATOM   2181  CB  LEU B  58      74.838  54.212  57.557  1.00  2.00           C  
ATOM   2182  CG  LEU B  58      73.449  53.597  57.387  1.00 11.74           C  
ATOM   2183  CD1 LEU B  58      73.533  52.076  57.410  1.00  9.44           C  
ATOM   2184  CD2 LEU B  58      72.548  54.097  58.491  1.00 12.58           C  
ATOM   2185  N   ASP B  59      75.988  55.382  54.784  1.00 27.10           N  
ATOM   2186  CA  ASP B  59      75.696  55.951  53.465  1.00 32.21           C  
ATOM   2187  C   ASP B  59      76.456  55.277  52.328  1.00 27.21           C  
ATOM   2188  O   ASP B  59      75.916  55.107  51.235  1.00 23.92           O  
ATOM   2189  CB  ASP B  59      76.005  57.453  53.441  1.00 35.57           C  
ATOM   2190  CG  ASP B  59      74.964  58.283  54.174  1.00 37.90           C  
ATOM   2191  OD1 ASP B  59      73.892  57.756  54.545  1.00 46.15           O  
ATOM   2192  OD2 ASP B  59      75.228  59.483  54.388  1.00 61.18           O  
ATOM   2193  N   GLU B  60      77.735  54.989  52.552  1.00 27.83           N  
ATOM   2194  CA  GLU B  60      78.544  54.296  51.553  1.00 34.97           C  
ATOM   2195  C   GLU B  60      77.954  52.916  51.260  1.00 33.94           C  
ATOM   2196  O   GLU B  60      78.030  52.415  50.139  1.00 35.06           O  
ATOM   2197  CB  GLU B  60      79.986  54.133  52.043  1.00 42.54           C  
ATOM   2198  CG  GLU B  60      80.758  55.434  52.233  1.00 69.33           C  
ATOM   2199  CD  GLU B  60      82.188  55.210  52.722  1.00 77.43           C  
ATOM   2200  OE1 GLU B  60      82.374  54.538  53.763  1.00 78.91           O  
ATOM   2201  OE2 GLU B  60      83.127  55.720  52.071  1.00 86.02           O  
ATOM   2202  N   CYS B  61      77.365  52.305  52.283  1.00 29.99           N  
ATOM   2203  CA  CYS B  61      76.776  50.986  52.145  1.00 21.25           C  
ATOM   2204  C   CYS B  61      75.536  51.060  51.287  1.00 18.42           C  
ATOM   2205  O   CYS B  61      75.386  50.291  50.340  1.00 20.89           O  
ATOM   2206  CB  CYS B  61      76.421  50.425  53.514  1.00 26.38           C  
ATOM   2207  SG  CYS B  61      77.862  50.070  54.508  1.00 21.66           S  
ATOM   2208  N   LEU B  62      74.689  52.045  51.574  1.00 17.21           N  
ATOM   2209  CA  LEU B  62      73.415  52.186  50.884  1.00 19.38           C  
ATOM   2210  C   LEU B  62      73.626  52.456  49.407  1.00 19.81           C  
ATOM   2211  O   LEU B  62      72.910  51.921  48.566  1.00 24.82           O  
ATOM   2212  CB  LEU B  62      72.588  53.309  51.511  1.00 18.89           C  
ATOM   2213  CG  LEU B  62      72.151  53.085  52.963  1.00 25.18           C  
ATOM   2214  CD1 LEU B  62      71.548  54.362  53.547  1.00 24.07           C  
ATOM   2215  CD2 LEU B  62      71.151  51.944  53.015  1.00 24.58           C  
ATOM   2216  N   GLU B  63      74.708  53.154  49.090  1.00 26.12           N  
ATOM   2217  CA  GLU B  63      75.052  53.397  47.700  1.00 27.69           C  
ATOM   2218  C   GLU B  63      75.628  52.164  47.027  1.00 21.14           C  
ATOM   2219  O   GLU B  63      75.193  51.804  45.937  1.00 37.34           O  
ATOM   2220  CB  GLU B  63      76.019  54.575  47.580  1.00 38.00           C  
ATOM   2221  CG  GLU B  63      75.327  55.950  47.570  1.00 59.34           C  
ATOM   2222  CD  GLU B  63      74.231  56.076  46.509  1.00 67.15           C  
ATOM   2223  OE1 GLU B  63      74.498  55.766  45.324  1.00 70.49           O  
ATOM   2224  OE2 GLU B  63      73.104  56.493  46.866  1.00 65.82           O  
ATOM   2225  N   ILE B  64      76.524  51.460  47.716  1.00 20.94           N  
ATOM   2226  CA  ILE B  64      77.079  50.213  47.197  1.00 17.32           C  
ATOM   2227  C   ILE B  64      75.970  49.207  46.958  1.00 22.70           C  
ATOM   2228  O   ILE B  64      75.986  48.474  45.973  1.00 32.21           O  
ATOM   2229  CB  ILE B  64      78.090  49.587  48.176  1.00 24.08           C  
ATOM   2230  CG1 ILE B  64      79.413  50.343  48.116  1.00 25.16           C  
ATOM   2231  CG2 ILE B  64      78.319  48.117  47.835  1.00 13.38           C  
ATOM   2232  CD1 ILE B  64      80.487  49.767  49.030  1.00 37.47           C  
ATOM   2233  N   TRP B  65      75.006  49.171  47.868  1.00 21.98           N  
ATOM   2234  CA  TRP B  65      73.914  48.226  47.756  1.00 23.08           C  
ATOM   2235  C   TRP B  65      72.947  48.695  46.692  1.00 25.87           C  
ATOM   2236  O   TRP B  65      72.436  47.877  45.929  1.00 26.38           O  
ATOM   2237  CB  TRP B  65      73.185  48.074  49.092  1.00 25.23           C  
ATOM   2238  CG  TRP B  65      73.977  47.344  50.137  1.00 25.97           C  
ATOM   2239  CD1 TRP B  65      74.903  46.361  49.932  1.00 19.32           C  
ATOM   2240  CD2 TRP B  65      73.941  47.573  51.552  1.00 24.55           C  
ATOM   2241  NE1 TRP B  65      75.459  45.975  51.132  1.00 25.96           N  
ATOM   2242  CE2 TRP B  65      74.886  46.701  52.140  1.00 24.79           C  
ATOM   2243  CE3 TRP B  65      73.212  48.438  52.379  1.00 20.71           C  
ATOM   2244  CZ2 TRP B  65      75.120  46.674  53.517  1.00 22.33           C  
ATOM   2245  CZ3 TRP B  65      73.448  48.408  53.750  1.00 17.29           C  
ATOM   2246  CH2 TRP B  65      74.394  47.533  54.302  1.00 14.02           C  
ATOM   2247  N   ARG B  66      72.774  50.014  46.576  1.00 29.01           N  
ATOM   2248  CA  ARG B  66      71.860  50.578  45.583  1.00 30.97           C  
ATOM   2249  C   ARG B  66      72.363  50.312  44.168  1.00 27.92           C  
ATOM   2250  O   ARG B  66      71.585  49.905  43.306  1.00 39.43           O  
ATOM   2251  CB  ARG B  66      71.634  52.083  45.827  1.00 42.98           C  
ATOM   2252  CG  ARG B  66      72.226  53.057  44.790  1.00 62.82           C  
ATOM   2253  CD  ARG B  66      71.150  53.974  44.186  1.00 62.44           C  
ATOM   2254  NE  ARG B  66      71.641  55.312  43.830  1.00 71.64           N  
ATOM   2255  CZ  ARG B  66      72.257  55.625  42.691  1.00 70.57           C  
ATOM   2256  NH1 ARG B  66      72.628  54.677  41.839  1.00 68.08           N  
ATOM   2257  NH2 ARG B  66      72.576  56.888  42.439  1.00 73.64           N  
ATOM   2258  N   GLU B  67      73.683  50.291  44.013  1.00 28.36           N  
ATOM   2259  CA  GLU B  67      74.322  49.990  42.734  1.00 29.44           C  
ATOM   2260  C   GLU B  67      74.177  48.528  42.271  1.00 27.93           C  
ATOM   2261  O   GLU B  67      74.293  48.236  41.078  1.00 30.66           O  
ATOM   2262  CB  GLU B  67      75.804  50.368  42.800  1.00 28.58           C  
ATOM   2263  CG  GLU B  67      76.348  50.988  41.521  1.00 54.45           C  
ATOM   2264  CD  GLU B  67      75.739  52.351  41.222  1.00 74.04           C  
ATOM   2265  OE1 GLU B  67      75.998  53.298  41.999  1.00 79.58           O  
ATOM   2266  OE2 GLU B  67      75.005  52.476  40.211  1.00 80.33           O  
ATOM   2267  N   LYS B  68      73.928  47.614  43.205  1.00 30.95           N  
ATOM   2268  CA  LYS B  68      73.856  46.188  42.879  1.00 29.67           C  
ATOM   2269  C   LYS B  68      72.429  45.722  42.616  1.00 26.90           C  
ATOM   2270  O   LYS B  68      72.203  44.570  42.252  1.00 29.08           O  
ATOM   2271  CB  LYS B  68      74.456  45.350  44.005  1.00 31.37           C  
ATOM   2272  CG  LYS B  68      75.945  45.527  44.206  1.00 28.12           C  
ATOM   2273  CD  LYS B  68      76.359  44.958  45.547  1.00 21.65           C  
ATOM   2274  CE  LYS B  68      77.793  44.476  45.519  1.00 34.57           C  
ATOM   2275  NZ  LYS B  68      78.123  43.663  46.721  1.00 40.37           N  
ATOM   2276  N   GLY B  69      71.468  46.619  42.806  1.00 29.12           N  
ATOM   2277  CA  GLY B  69      70.078  46.261  42.587  1.00 33.68           C  
ATOM   2278  C   GLY B  69      69.411  45.706  43.830  1.00 26.84           C  
ATOM   2279  O   GLY B  69      68.326  45.126  43.752  1.00 37.56           O  
ATOM   2280  N   LEU B  70      70.056  45.899  44.979  1.00 22.65           N  
ATOM   2281  CA  LEU B  70      69.511  45.453  46.256  1.00 21.73           C  
ATOM   2282  C   LEU B  70      68.614  46.537  46.843  1.00 18.54           C  
ATOM   2283  O   LEU B  70      68.954  47.719  46.823  1.00 31.80           O  
ATOM   2284  CB  LEU B  70      70.643  45.107  47.237  1.00 11.81           C  
ATOM   2285  CG  LEU B  70      71.712  44.135  46.730  1.00  7.05           C  
ATOM   2286  CD1 LEU B  70      72.765  43.921  47.783  1.00  5.63           C  
ATOM   2287  CD2 LEU B  70      71.075  42.819  46.349  1.00 11.28           C  
ATOM   2288  N   ASN B  71      67.456  46.125  47.348  1.00 22.14           N  
ATOM   2289  CA  ASN B  71      66.463  47.050  47.877  1.00 26.69           C  
ATOM   2290  C   ASN B  71      66.647  47.258  49.384  1.00 25.99           C  
ATOM   2291  O   ASN B  71      65.941  46.657  50.193  1.00 26.37           O  
ATOM   2292  CB  ASN B  71      65.062  46.512  47.568  1.00 37.39           C  
ATOM   2293  CG  ASN B  71      63.959  47.496  47.909  1.00 53.27           C  
ATOM   2294  OD1 ASN B  71      62.778  47.174  47.773  1.00 66.03           O  
ATOM   2295  ND2 ASN B  71      64.328  48.691  48.361  1.00 70.24           N  
ATOM   2296  N   VAL B  72      67.571  48.143  49.751  1.00 24.22           N  
ATOM   2297  CA  VAL B  72      67.929  48.346  51.155  1.00 24.39           C  
ATOM   2298  C   VAL B  72      67.734  49.792  51.580  1.00 27.35           C  
ATOM   2299  O   VAL B  72      68.179  50.708  50.889  1.00 27.55           O  
ATOM   2300  CB  VAL B  72      69.405  47.970  51.434  1.00 14.16           C  
ATOM   2301  CG1 VAL B  72      69.714  48.141  52.912  1.00 13.33           C  
ATOM   2302  CG2 VAL B  72      69.682  46.534  50.999  1.00 15.38           C  
ATOM   2303  N   GLU B  73      67.107  49.979  52.741  1.00 28.27           N  
ATOM   2304  CA  GLU B  73      67.040  51.279  53.410  1.00 30.51           C  
ATOM   2305  C   GLU B  73      67.765  51.236  54.760  1.00 29.04           C  
ATOM   2306  O   GLU B  73      68.192  50.173  55.205  1.00 36.01           O  
ATOM   2307  CB  GLU B  73      65.581  51.688  53.622  1.00 33.23           C  
ATOM   2308  CG  GLU B  73      64.884  52.171  52.356  1.00 54.25           C  
ATOM   2309  CD  GLU B  73      64.451  53.627  52.440  1.00 68.13           C  
ATOM   2310  OE1 GLU B  73      65.313  54.506  52.672  1.00 75.68           O  
ATOM   2311  OE2 GLU B  73      63.241  53.888  52.285  1.00 78.42           O  
ATOM   2312  N   GLY B  74      67.915  52.395  55.397  1.00 26.62           N  
ATOM   2313  CA  GLY B  74      68.588  52.458  56.683  1.00 24.41           C  
ATOM   2314  C   GLY B  74      68.632  53.839  57.317  1.00 28.74           C  
ATOM   2315  O   GLY B  74      68.454  54.850  56.639  1.00 32.07           O  
ATOM   2316  N   SER B  75      68.830  53.876  58.632  1.00 31.02           N  
ATOM   2317  CA  SER B  75      69.062  55.126  59.351  1.00 19.85           C  
ATOM   2318  C   SER B  75      70.076  54.932  60.476  1.00 19.98           C  
ATOM   2319  O   SER B  75      70.451  53.809  60.796  1.00 27.01           O  
ATOM   2320  CB  SER B  75      67.746  55.689  59.910  1.00 21.72           C  
ATOM   2321  OG  SER B  75      66.956  54.697  60.548  1.00 19.59           O  
ATOM   2322  N   VAL B  76      70.635  56.036  60.957  1.00 23.97           N  
ATOM   2323  CA  VAL B  76      71.609  55.998  62.041  1.00 23.09           C  
ATOM   2324  C   VAL B  76      70.898  55.831  63.375  1.00 23.71           C  
ATOM   2325  O   VAL B  76      69.922  56.530  63.660  1.00 31.88           O  
ATOM   2326  CB  VAL B  76      72.454  57.288  62.074  1.00 21.61           C  
ATOM   2327  CG1 VAL B  76      73.372  57.288  63.281  1.00 28.29           C  
ATOM   2328  CG2 VAL B  76      73.266  57.386  60.824  1.00 23.31           C  
ATOM   2329  N   CYS B  77      71.367  54.870  64.167  1.00 27.89           N  
ATOM   2330  CA  CYS B  77      70.752  54.541  65.449  1.00 32.35           C  
ATOM   2331  C   CYS B  77      71.776  53.924  66.386  1.00 25.04           C  
ATOM   2332  O   CYS B  77      72.470  52.972  66.019  1.00 22.14           O  
ATOM   2333  CB  CYS B  77      69.584  53.562  65.253  1.00 29.24           C  
ATOM   2334  SG  CYS B  77      68.750  53.055  66.787  1.00 36.17           S  
ATOM   2335  N   ASP B  78      71.933  54.537  67.553  1.00 17.22           N  
ATOM   2336  CA  ASP B  78      72.651  53.901  68.642  1.00 17.88           C  
ATOM   2337  C   ASP B  78      71.670  53.047  69.421  1.00 18.91           C  
ATOM   2338  O   ASP B  78      70.687  53.552  69.964  1.00 18.57           O  
ATOM   2339  CB  ASP B  78      73.262  54.939  69.569  1.00 17.66           C  
ATOM   2340  CG  ASP B  78      74.032  54.312  70.713  1.00 31.91           C  
ATOM   2341  OD1 ASP B  78      74.615  53.223  70.524  1.00 50.05           O  
ATOM   2342  OD2 ASP B  78      74.042  54.895  71.814  1.00 48.61           O  
ATOM   2343  N   LEU B  79      71.923  51.746  69.456  1.00 15.96           N  
ATOM   2344  CA  LEU B  79      70.965  50.816  70.029  1.00 13.07           C  
ATOM   2345  C   LEU B  79      71.079  50.742  71.544  1.00 17.56           C  
ATOM   2346  O   LEU B  79      70.205  50.194  72.199  1.00 19.72           O  
ATOM   2347  CB  LEU B  79      71.140  49.425  69.411  1.00 22.91           C  
ATOM   2348  CG  LEU B  79      70.750  49.361  67.931  1.00 15.52           C  
ATOM   2349  CD1 LEU B  79      71.442  48.207  67.250  1.00 22.27           C  
ATOM   2350  CD2 LEU B  79      69.257  49.237  67.805  1.00 10.78           C  
ATOM   2351  N   LEU B  80      72.125  51.354  72.098  1.00 12.54           N  
ATOM   2352  CA  LEU B  80      72.249  51.522  73.545  1.00 13.75           C  
ATOM   2353  C   LEU B  80      71.215  52.460  74.178  1.00 14.93           C  
ATOM   2354  O   LEU B  80      71.079  52.503  75.395  1.00 21.04           O  
ATOM   2355  CB  LEU B  80      73.655  52.012  73.898  1.00  8.85           C  
ATOM   2356  CG  LEU B  80      74.598  50.906  74.375  1.00 12.20           C  
ATOM   2357  CD1 LEU B  80      76.043  51.342  74.230  1.00 18.33           C  
ATOM   2358  CD2 LEU B  80      74.281  50.573  75.816  1.00 16.32           C  
ATOM   2359  N   SER B  81      70.475  53.194  73.353  1.00 18.04           N  
ATOM   2360  CA  SER B  81      69.429  54.081  73.851  1.00 20.11           C  
ATOM   2361  C   SER B  81      68.029  53.526  73.605  1.00 13.37           C  
ATOM   2362  O   SER B  81      67.646  53.293  72.462  1.00 25.54           O  
ATOM   2363  CB  SER B  81      69.558  55.455  73.195  1.00 24.31           C  
ATOM   2364  OG  SER B  81      68.358  56.200  73.335  1.00 31.78           O  
ATOM   2365  N   ARG B  82      67.223  53.452  74.662  1.00 16.35           N  
ATOM   2366  CA  ARG B  82      65.876  52.904  74.554  1.00 14.54           C  
ATOM   2367  C   ARG B  82      64.972  53.719  73.634  1.00 22.57           C  
ATOM   2368  O   ARG B  82      64.201  53.146  72.860  1.00 29.55           O  
ATOM   2369  CB  ARG B  82      65.225  52.782  75.932  1.00 12.71           C  
ATOM   2370  CG  ARG B  82      63.842  52.134  75.903  1.00 18.15           C  
ATOM   2371  CD  ARG B  82      63.328  51.821  77.300  1.00 36.73           C  
ATOM   2372  NE  ARG B  82      62.996  50.404  77.471  1.00 54.50           N  
ATOM   2373  CZ  ARG B  82      63.874  49.459  77.814  1.00 69.18           C  
ATOM   2374  NH1 ARG B  82      65.153  49.764  78.010  1.00 76.26           N  
ATOM   2375  NH2 ARG B  82      63.475  48.199  77.956  1.00 77.37           N  
ATOM   2376  N   THR B  83      65.086  55.047  73.688  1.00 21.85           N  
ATOM   2377  CA  THR B  83      64.219  55.913  72.886  1.00 23.36           C  
ATOM   2378  C   THR B  83      64.578  55.848  71.404  1.00 20.65           C  
ATOM   2379  O   THR B  83      63.702  55.967  70.552  1.00 32.25           O  
ATOM   2380  CB  THR B  83      64.259  57.409  73.350  1.00 28.69           C  
ATOM   2381  OG1 THR B  83      65.549  57.972  73.083  1.00 37.09           O  
ATOM   2382  CG2 THR B  83      63.958  57.533  74.834  1.00 13.57           C  
ATOM   2383  N   GLU B  84      65.850  55.588  71.103  1.00 21.69           N  
ATOM   2384  CA  GLU B  84      66.300  55.384  69.720  1.00 22.57           C  
ATOM   2385  C   GLU B  84      65.817  54.053  69.137  1.00 25.05           C  
ATOM   2386  O   GLU B  84      65.526  53.964  67.940  1.00 24.14           O  
ATOM   2387  CB  GLU B  84      67.828  55.449  69.631  1.00 26.80           C  
ATOM   2388  CG  GLU B  84      68.410  56.845  69.802  1.00 35.17           C  
ATOM   2389  CD  GLU B  84      69.238  57.286  68.612  1.00 44.50           C  
ATOM   2390  OE1 GLU B  84      68.645  57.718  67.599  1.00 54.08           O  
ATOM   2391  OE2 GLU B  84      70.483  57.215  68.699  1.00 48.62           O  
ATOM   2392  N   ARG B  85      65.771  53.017  69.976  1.00 20.20           N  
ATOM   2393  CA  ARG B  85      65.193  51.731  69.595  1.00 17.88           C  
ATOM   2394  C   ARG B  85      63.715  51.895  69.333  1.00 23.74           C  
ATOM   2395  O   ARG B  85      63.130  51.125  68.574  1.00 36.70           O  
ATOM   2396  CB  ARG B  85      65.346  50.711  70.711  1.00  6.96           C  
ATOM   2397  CG  ARG B  85      66.726  50.191  70.892  1.00 14.95           C  
ATOM   2398  CD  ARG B  85      66.706  49.137  71.957  1.00 11.96           C  
ATOM   2399  NE  ARG B  85      67.691  49.457  72.972  1.00 24.26           N  
ATOM   2400  CZ  ARG B  85      67.452  49.488  74.276  1.00 15.26           C  
ATOM   2401  NH1 ARG B  85      66.307  49.033  74.758  1.00 24.80           N  
ATOM   2402  NH2 ARG B  85      68.413  49.859  75.106  1.00 23.30           N  
ATOM   2403  N   ASP B  86      63.082  52.721  70.158  1.00 21.70           N  
ATOM   2404  CA  ASP B  86      61.671  53.018  69.999  1.00 20.27           C  
ATOM   2405  C   ASP B  86      61.423  53.737  68.679  1.00 24.12           C  
ATOM   2406  O   ASP B  86      60.500  53.389  67.945  1.00 23.98           O  
ATOM   2407  CB  ASP B  86      61.185  53.868  71.169  1.00 25.72           C  
ATOM   2408  CG  ASP B  86      60.828  53.033  72.385  1.00 43.49           C  
ATOM   2409  OD1 ASP B  86      61.098  51.812  72.384  1.00 48.57           O  
ATOM   2410  OD2 ASP B  86      60.256  53.599  73.342  1.00 50.99           O  
ATOM   2411  N   LYS B  87      62.330  54.645  68.327  1.00 19.47           N  
ATOM   2412  CA  LYS B  87      62.198  55.440  67.111  1.00 24.15           C  
ATOM   2413  C   LYS B  87      62.443  54.592  65.866  1.00 26.63           C  
ATOM   2414  O   LYS B  87      61.683  54.675  64.896  1.00 26.88           O  
ATOM   2415  CB  LYS B  87      63.178  56.620  67.130  1.00 29.02           C  
ATOM   2416  CG  LYS B  87      62.771  57.771  68.044  1.00 56.42           C  
ATOM   2417  CD  LYS B  87      63.845  58.867  68.080  1.00 73.74           C  
ATOM   2418  CE  LYS B  87      63.500  59.978  69.077  1.00 78.46           C  
ATOM   2419  NZ  LYS B  87      64.542  61.049  69.137  1.00 81.45           N  
ATOM   2420  N   LEU B  88      63.520  53.806  65.888  1.00 18.98           N  
ATOM   2421  CA  LEU B  88      63.866  52.911  64.783  1.00 16.27           C  
ATOM   2422  C   LEU B  88      62.694  52.015  64.373  1.00 12.23           C  
ATOM   2423  O   LEU B  88      62.407  51.865  63.189  1.00 25.60           O  
ATOM   2424  CB  LEU B  88      65.063  52.041  65.176  1.00 15.70           C  
ATOM   2425  CG  LEU B  88      65.447  50.930  64.201  1.00 13.01           C  
ATOM   2426  CD1 LEU B  88      65.964  51.556  62.924  1.00 14.72           C  
ATOM   2427  CD2 LEU B  88      66.488  50.015  64.830  1.00  5.58           C  
ATOM   2428  N   MET B  89      61.969  51.504  65.363  1.00 13.08           N  
ATOM   2429  CA  MET B  89      60.852  50.595  65.129  1.00 14.64           C  
ATOM   2430  C   MET B  89      59.636  51.313  64.579  1.00 15.96           C  
ATOM   2431  O   MET B  89      58.825  50.713  63.887  1.00 21.57           O  
ATOM   2432  CB  MET B  89      60.471  49.877  66.422  1.00 19.32           C  
ATOM   2433  CG  MET B  89      59.463  48.752  66.248  1.00 22.51           C  
ATOM   2434  SD  MET B  89      60.061  47.434  65.161  1.00 33.88           S  
ATOM   2435  CE  MET B  89      61.825  47.374  65.528  1.00 13.83           C  
ATOM   2436  N   GLN B  90      59.463  52.571  64.968  1.00 22.32           N  
ATOM   2437  CA  GLN B  90      58.440  53.424  64.370  1.00 27.99           C  
ATOM   2438  C   GLN B  90      58.720  53.628  62.878  1.00 23.91           C  
ATOM   2439  O   GLN B  90      57.822  53.502  62.045  1.00 33.79           O  
ATOM   2440  CB  GLN B  90      58.397  54.784  65.076  1.00 31.05           C  
ATOM   2441  CG  GLN B  90      57.734  54.768  66.441  1.00 48.60           C  
ATOM   2442  CD  GLN B  90      57.588  56.161  67.030  1.00 60.58           C  
ATOM   2443  OE1 GLN B  90      58.446  56.622  67.784  1.00 67.03           O  
ATOM   2444  NE2 GLN B  90      56.493  56.835  66.693  1.00 64.46           N  
ATOM   2445  N   THR B  91      59.974  53.934  62.556  1.00 19.15           N  
ATOM   2446  CA  THR B  91      60.417  54.117  61.176  1.00 13.77           C  
ATOM   2447  C   THR B  91      60.145  52.870  60.373  1.00 16.79           C  
ATOM   2448  O   THR B  91      59.575  52.937  59.290  1.00 22.56           O  
ATOM   2449  CB  THR B  91      61.916  54.369  61.121  1.00 15.58           C  
ATOM   2450  OG1 THR B  91      62.219  55.519  61.904  1.00 16.94           O  
ATOM   2451  CG2 THR B  91      62.383  54.582  59.697  1.00 20.51           C  
ATOM   2452  N   VAL B  92      60.566  51.735  60.922  1.00 21.75           N  
ATOM   2453  CA  VAL B  92      60.482  50.450  60.241  1.00 14.32           C  
ATOM   2454  C   VAL B  92      59.035  50.007  60.082  1.00 14.34           C  
ATOM   2455  O   VAL B  92      58.673  49.434  59.062  1.00 20.01           O  
ATOM   2456  CB  VAL B  92      61.308  49.393  61.008  1.00 15.56           C  
ATOM   2457  CG1 VAL B  92      61.045  47.981  60.469  1.00  9.84           C  
ATOM   2458  CG2 VAL B  92      62.785  49.742  60.894  1.00 10.14           C  
ATOM   2459  N   ALA B  93      58.180  50.451  60.997  1.00 15.97           N  
ATOM   2460  CA  ALA B  93      56.755  50.156  60.927  1.00 15.07           C  
ATOM   2461  C   ALA B  93      56.077  50.996  59.854  1.00 27.23           C  
ATOM   2462  O   ALA B  93      55.100  50.564  59.237  1.00 26.68           O  
ATOM   2463  CB  ALA B  93      56.106  50.416  62.265  1.00 17.11           C  
ATOM   2464  N   HIS B  94      56.568  52.216  59.661  1.00 28.67           N  
ATOM   2465  CA  HIS B  94      55.997  53.102  58.657  1.00 26.79           C  
ATOM   2466  C   HIS B  94      56.420  52.665  57.258  1.00 22.74           C  
ATOM   2467  O   HIS B  94      55.604  52.631  56.342  1.00 30.46           O  
ATOM   2468  CB  HIS B  94      56.433  54.545  58.906  1.00 28.62           C  
ATOM   2469  CG  HIS B  94      55.673  55.552  58.099  1.00 47.42           C  
ATOM   2470  ND1 HIS B  94      54.374  55.914  58.394  1.00 52.33           N  
ATOM   2471  CD2 HIS B  94      56.003  56.221  56.967  1.00 40.57           C  
ATOM   2472  CE1 HIS B  94      53.935  56.756  57.477  1.00 50.54           C  
ATOM   2473  NE2 HIS B  94      54.902  56.958  56.599  1.00 44.08           N  
ATOM   2474  N   VAL B  95      57.678  52.257  57.126  1.00 23.27           N  
ATOM   2475  CA  VAL B  95      58.253  51.912  55.829  1.00 20.87           C  
ATOM   2476  C   VAL B  95      57.723  50.569  55.320  1.00 25.61           C  
ATOM   2477  O   VAL B  95      57.401  50.432  54.136  1.00 25.06           O  
ATOM   2478  CB  VAL B  95      59.803  51.869  55.913  1.00 19.91           C  
ATOM   2479  CG1 VAL B  95      60.394  51.246  54.656  1.00 38.19           C  
ATOM   2480  CG2 VAL B  95      60.351  53.269  56.091  1.00 26.36           C  
ATOM   2481  N   PHE B  96      57.589  49.601  56.228  1.00 24.87           N  
ATOM   2482  CA  PHE B  96      57.128  48.257  55.875  1.00 16.81           C  
ATOM   2483  C   PHE B  96      55.636  48.111  56.127  1.00 19.46           C  
ATOM   2484  O   PHE B  96      55.092  47.012  56.026  1.00 31.25           O  
ATOM   2485  CB  PHE B  96      57.891  47.187  56.673  1.00 16.60           C  
ATOM   2486  CG  PHE B  96      59.378  47.128  56.374  1.00 16.58           C  
ATOM   2487  CD1 PHE B  96      59.888  47.587  55.162  1.00 13.10           C  
ATOM   2488  CD2 PHE B  96      60.260  46.566  57.293  1.00 14.15           C  
ATOM   2489  CE1 PHE B  96      61.253  47.483  54.871  1.00 14.71           C  
ATOM   2490  CE2 PHE B  96      61.626  46.457  57.009  1.00  7.77           C  
ATOM   2491  CZ  PHE B  96      62.119  46.915  55.797  1.00 13.92           C  
ATOM   2492  N   ASP B  97      54.993  49.218  56.504  1.00 24.78           N  
ATOM   2493  CA  ASP B  97      53.540  49.297  56.657  1.00 29.31           C  
ATOM   2494  C   ASP B  97      53.005  48.344  57.722  1.00 30.18           C  
ATOM   2495  O   ASP B  97      52.037  47.616  57.497  1.00 30.31           O  
ATOM   2496  CB  ASP B  97      52.837  49.041  55.316  1.00 45.48           C  
ATOM   2497  CG  ASP B  97      53.318  49.971  54.215  1.00 58.23           C  
ATOM   2498  OD1 ASP B  97      52.901  51.149  54.213  1.00 67.49           O  
ATOM   2499  OD2 ASP B  97      54.113  49.525  53.354  1.00 71.59           O  
ATOM   2500  N   GLY B  98      53.651  48.350  58.881  1.00 30.55           N  
ATOM   2501  CA  GLY B  98      53.154  47.607  60.025  1.00 22.41           C  
ATOM   2502  C   GLY B  98      53.331  46.117  59.870  1.00 13.45           C  
ATOM   2503  O   GLY B  98      52.584  45.350  60.459  1.00 24.85           O  
ATOM   2504  N   LYS B  99      54.313  45.717  59.066  1.00 21.92           N  
ATOM   2505  CA  LYS B  99      54.571  44.304  58.772  1.00 26.97           C  
ATOM   2506  C   LYS B  99      56.065  44.031  58.721  1.00 20.87           C  
ATOM   2507  O   LYS B  99      56.774  44.611  57.898  1.00 26.57           O  
ATOM   2508  CB  LYS B  99      53.956  43.908  57.423  1.00 23.47           C  
ATOM   2509  CG  LYS B  99      52.515  43.439  57.496  1.00 33.68           C  
ATOM   2510  CD  LYS B  99      51.953  43.199  56.098  1.00 43.44           C  
ATOM   2511  CE  LYS B  99      50.466  42.870  56.134  1.00 57.05           C  
ATOM   2512  NZ  LYS B  99      49.914  42.671  54.761  1.00 68.88           N  
ATOM   2513  N   LEU B 100      56.528  43.139  59.594  1.00 18.11           N  
ATOM   2514  CA  LEU B 100      57.914  42.670  59.575  1.00 18.69           C  
ATOM   2515  C   LEU B 100      57.911  41.153  59.462  1.00 15.56           C  
ATOM   2516  O   LEU B 100      57.223  40.473  60.222  1.00 26.34           O  
ATOM   2517  CB  LEU B 100      58.642  43.067  60.865  1.00 17.71           C  
ATOM   2518  CG  LEU B 100      59.989  43.805  60.859  1.00 16.99           C  
ATOM   2519  CD1 LEU B 100      60.828  43.331  62.037  1.00 10.04           C  
ATOM   2520  CD2 LEU B 100      60.735  43.574  59.575  1.00  6.80           C  
ATOM   2521  N   ASN B 101      58.687  40.625  58.526  1.00 12.85           N  
ATOM   2522  CA  ASN B 101      58.876  39.185  58.441  1.00 11.45           C  
ATOM   2523  C   ASN B 101      60.082  38.702  59.239  1.00 12.46           C  
ATOM   2524  O   ASN B 101      59.977  37.751  60.003  1.00 23.97           O  
ATOM   2525  CB  ASN B 101      59.008  38.763  56.981  1.00  7.35           C  
ATOM   2526  CG  ASN B 101      57.674  38.734  56.276  1.00  9.90           C  
ATOM   2527  OD1 ASN B 101      56.875  37.819  56.476  1.00 14.59           O  
ATOM   2528  ND2 ASN B 101      57.392  39.775  55.498  1.00 15.91           N  
ATOM   2529  N   ILE B 102      61.184  39.442  59.155  1.00 12.24           N  
ATOM   2530  CA  ILE B 102      62.470  39.010  59.701  1.00 16.08           C  
ATOM   2531  C   ILE B 102      63.068  40.099  60.598  1.00 17.56           C  
ATOM   2532  O   ILE B 102      63.040  41.276  60.253  1.00 21.53           O  
ATOM   2533  CB  ILE B 102      63.470  38.711  58.554  1.00 16.35           C  
ATOM   2534  CG1 ILE B 102      62.868  37.681  57.592  1.00  8.59           C  
ATOM   2535  CG2 ILE B 102      64.814  38.238  59.110  1.00 15.39           C  
ATOM   2536  CD1 ILE B 102      63.447  37.750  56.184  1.00  5.05           C  
ATOM   2537  N   LEU B 103      63.609  39.697  61.742  1.00 10.22           N  
ATOM   2538  CA  LEU B 103      64.400  40.596  62.581  1.00  7.77           C  
ATOM   2539  C   LEU B 103      65.702  39.895  62.942  1.00 11.65           C  
ATOM   2540  O   LEU B 103      65.687  38.824  63.540  1.00 17.64           O  
ATOM   2541  CB  LEU B 103      63.630  40.962  63.861  1.00  4.44           C  
ATOM   2542  CG  LEU B 103      64.392  41.589  65.042  1.00  8.43           C  
ATOM   2543  CD1 LEU B 103      64.999  42.934  64.651  1.00  3.12           C  
ATOM   2544  CD2 LEU B 103      63.446  41.769  66.224  1.00  7.75           C  
ATOM   2545  N   VAL B 104      66.815  40.428  62.456  1.00 11.51           N  
ATOM   2546  CA  VAL B 104      68.122  39.912  62.832  1.00 12.16           C  
ATOM   2547  C   VAL B 104      68.808  40.864  63.809  1.00 14.35           C  
ATOM   2548  O   VAL B 104      69.188  41.986  63.452  1.00 17.54           O  
ATOM   2549  CB  VAL B 104      69.037  39.686  61.590  1.00  5.17           C  
ATOM   2550  CG1 VAL B 104      70.423  39.233  62.035  1.00  9.86           C  
ATOM   2551  CG2 VAL B 104      68.421  38.645  60.663  1.00  5.58           C  
ATOM   2552  N   ASN B 105      68.917  40.421  65.058  1.00 14.81           N  
ATOM   2553  CA  ASN B 105      69.638  41.158  66.081  1.00  8.22           C  
ATOM   2554  C   ASN B 105      71.124  40.847  65.980  1.00 11.58           C  
ATOM   2555  O   ASN B 105      71.637  39.995  66.705  1.00 18.08           O  
ATOM   2556  CB  ASN B 105      69.102  40.785  67.462  1.00  6.08           C  
ATOM   2557  CG  ASN B 105      67.726  41.363  67.717  1.00 15.39           C  
ATOM   2558  OD1 ASN B 105      66.775  40.636  68.026  1.00 14.63           O  
ATOM   2559  ND2 ASN B 105      67.589  42.665  67.499  1.00  9.72           N  
ATOM   2560  N   ASN B 106      71.778  41.451  64.989  1.00  7.66           N  
ATOM   2561  CA  ASN B 106      73.178  41.159  64.717  1.00  9.70           C  
ATOM   2562  C   ASN B 106      74.099  41.993  65.593  1.00 15.11           C  
ATOM   2563  O   ASN B 106      75.101  41.496  66.106  1.00 21.48           O  
ATOM   2564  CB  ASN B 106      73.512  41.413  63.242  1.00  4.84           C  
ATOM   2565  CG  ASN B 106      75.009  41.497  62.993  1.00 12.58           C  
ATOM   2566  OD1 ASN B 106      75.599  42.582  63.018  1.00 12.05           O  
ATOM   2567  ND2 ASN B 106      75.648  40.343  62.857  1.00  6.82           N  
ATOM   2568  N   ALA B 107      73.774  43.274  65.727  1.00 20.70           N  
ATOM   2569  CA  ALA B 107      74.676  44.235  66.348  1.00 12.25           C  
ATOM   2570  C   ALA B 107      75.118  43.753  67.721  1.00 13.33           C  
ATOM   2571  O   ALA B 107      74.375  43.042  68.406  1.00 15.05           O  
ATOM   2572  CB  ALA B 107      74.001  45.594  66.452  1.00  4.78           C  
ATOM   2573  N   GLY B 108      76.400  43.965  68.006  1.00 13.34           N  
ATOM   2574  CA  GLY B 108      76.975  43.566  69.276  1.00  7.37           C  
ATOM   2575  C   GLY B 108      78.405  44.068  69.391  1.00 12.13           C  
ATOM   2576  O   GLY B 108      78.979  44.514  68.398  1.00  6.99           O  
ATOM   2577  N   VAL B 109      78.987  43.968  70.586  1.00  8.41           N  
ATOM   2578  CA  VAL B 109      80.336  44.469  70.854  1.00 10.66           C  
ATOM   2579  C   VAL B 109      81.053  43.527  71.803  1.00  9.98           C  
ATOM   2580  O   VAL B 109      80.413  42.818  72.578  1.00 17.11           O  
ATOM   2581  CB  VAL B 109      80.308  45.878  71.515  1.00 15.54           C  
ATOM   2582  CG1 VAL B 109      79.710  46.891  70.561  1.00 13.74           C  
ATOM   2583  CG2 VAL B 109      79.512  45.844  72.823  1.00 12.09           C  
ATOM   2584  N   VAL B 110      82.373  43.642  71.851  1.00 16.28           N  
ATOM   2585  CA  VAL B 110      83.166  42.892  72.818  1.00 19.02           C  
ATOM   2586  C   VAL B 110      84.201  43.804  73.470  1.00 15.77           C  
ATOM   2587  O   VAL B 110      84.573  44.828  72.904  1.00 19.45           O  
ATOM   2588  CB  VAL B 110      83.883  41.681  72.149  1.00 18.02           C  
ATOM   2589  CG1 VAL B 110      85.015  42.164  71.263  1.00 27.82           C  
ATOM   2590  CG2 VAL B 110      84.405  40.721  73.209  1.00 10.40           C  
ATOM   2591  N   ILE B 111      84.524  43.505  74.727  1.00 20.82           N  
ATOM   2592  CA  ILE B 111      85.604  44.162  75.460  1.00  7.66           C  
ATOM   2593  C   ILE B 111      86.491  43.081  76.078  1.00 12.83           C  
ATOM   2594  O   ILE B 111      86.002  42.118  76.657  1.00 17.20           O  
ATOM   2595  CB  ILE B 111      85.042  45.059  76.581  1.00 15.50           C  
ATOM   2596  CG1 ILE B 111      84.197  46.180  75.972  1.00 22.92           C  
ATOM   2597  CG2 ILE B 111      86.168  45.637  77.413  1.00  7.50           C  
ATOM   2598  CD1 ILE B 111      83.407  46.987  76.989  1.00 30.21           C  
ATOM   2599  N   HIS B 112      87.796  43.208  75.886  1.00 13.42           N  
ATOM   2600  CA  HIS B 112      88.724  42.191  76.343  1.00 13.59           C  
ATOM   2601  C   HIS B 112      89.434  42.585  77.638  1.00 16.44           C  
ATOM   2602  O   HIS B 112      90.275  43.485  77.643  1.00 27.09           O  
ATOM   2603  CB  HIS B 112      89.746  41.899  75.243  1.00 15.99           C  
ATOM   2604  CG  HIS B 112      89.146  41.295  74.011  1.00 29.43           C  
ATOM   2605  ND1 HIS B 112      89.040  39.932  73.823  1.00 28.59           N  
ATOM   2606  CD2 HIS B 112      88.598  41.866  72.911  1.00 29.77           C  
ATOM   2607  CE1 HIS B 112      88.454  39.689  72.665  1.00 25.70           C  
ATOM   2608  NE2 HIS B 112      88.177  40.847  72.092  1.00 37.94           N  
ATOM   2609  N   LYS B 113      89.033  41.948  78.739  1.00 14.85           N  
ATOM   2610  CA  LYS B 113      89.673  42.118  80.050  1.00 18.51           C  
ATOM   2611  C   LYS B 113      89.560  40.829  80.855  1.00 20.10           C  
ATOM   2612  O   LYS B 113      88.755  39.955  80.526  1.00 19.31           O  
ATOM   2613  CB  LYS B 113      88.991  43.217  80.866  1.00  9.81           C  
ATOM   2614  CG  LYS B 113      89.170  44.602  80.343  1.00 10.98           C  
ATOM   2615  CD  LYS B 113      88.169  45.516  80.980  1.00 10.55           C  
ATOM   2616  CE  LYS B 113      88.623  46.943  80.860  1.00 11.82           C  
ATOM   2617  NZ  LYS B 113      87.591  47.853  81.386  1.00 14.80           N  
ATOM   2618  N   GLU B 114      90.252  40.795  81.994  1.00 17.65           N  
ATOM   2619  CA  GLU B 114      90.078  39.735  82.983  1.00 14.03           C  
ATOM   2620  C   GLU B 114      88.745  39.912  83.688  1.00  9.81           C  
ATOM   2621  O   GLU B 114      88.274  41.034  83.842  1.00 10.81           O  
ATOM   2622  CB  GLU B 114      91.193  39.789  84.016  1.00 18.76           C  
ATOM   2623  CG  GLU B 114      92.563  39.500  83.454  1.00 43.38           C  
ATOM   2624  CD  GLU B 114      93.303  38.468  84.267  1.00 55.31           C  
ATOM   2625  OE1 GLU B 114      93.066  37.261  84.040  1.00 71.37           O  
ATOM   2626  OE2 GLU B 114      94.085  38.862  85.161  1.00 61.96           O  
ATOM   2627  N   ALA B 115      88.175  38.807  84.164  1.00 11.93           N  
ATOM   2628  CA  ALA B 115      86.844  38.809  84.766  1.00 14.87           C  
ATOM   2629  C   ALA B 115      86.739  39.748  85.963  1.00 11.82           C  
ATOM   2630  O   ALA B 115      85.681  40.298  86.238  1.00 12.06           O  
ATOM   2631  CB  ALA B 115      86.454  37.395  85.176  1.00 14.68           C  
ATOM   2632  N   LYS B 116      87.848  39.958  86.657  1.00 16.03           N  
ATOM   2633  CA  LYS B 116      87.825  40.778  87.862  1.00 25.85           C  
ATOM   2634  C   LYS B 116      88.055  42.272  87.587  1.00 22.66           C  
ATOM   2635  O   LYS B 116      87.964  43.088  88.498  1.00 22.20           O  
ATOM   2636  CB  LYS B 116      88.842  40.245  88.889  1.00 19.99           C  
ATOM   2637  CG  LYS B 116      90.285  40.172  88.405  1.00 17.67           C  
ATOM   2638  CD  LYS B 116      91.242  40.657  89.486  1.00 29.90           C  
ATOM   2639  CE  LYS B 116      92.687  40.577  89.032  1.00 35.31           C  
ATOM   2640  NZ  LYS B 116      93.001  41.641  88.039  1.00 43.77           N  
ATOM   2641  N   ASP B 117      88.249  42.632  86.318  1.00 23.24           N  
ATOM   2642  CA  ASP B 117      88.578  44.008  85.945  1.00  9.75           C  
ATOM   2643  C   ASP B 117      87.452  44.735  85.227  1.00 13.77           C  
ATOM   2644  O   ASP B 117      87.474  45.963  85.114  1.00 22.97           O  
ATOM   2645  CB  ASP B 117      89.828  44.039  85.065  1.00  8.99           C  
ATOM   2646  CG  ASP B 117      91.075  43.646  85.817  1.00 13.40           C  
ATOM   2647  OD1 ASP B 117      91.168  43.937  87.030  1.00 12.01           O  
ATOM   2648  OD2 ASP B 117      91.960  43.024  85.190  1.00 28.76           O  
ATOM   2649  N   PHE B 118      86.500  43.985  84.684  1.00 10.95           N  
ATOM   2650  CA  PHE B 118      85.348  44.602  84.048  1.00 14.07           C  
ATOM   2651  C   PHE B 118      84.619  45.573  84.993  1.00 19.14           C  
ATOM   2652  O   PHE B 118      84.377  45.272  86.169  1.00 15.99           O  
ATOM   2653  CB  PHE B 118      84.388  43.531  83.525  1.00 12.04           C  
ATOM   2654  CG  PHE B 118      84.859  42.862  82.268  1.00 19.20           C  
ATOM   2655  CD1 PHE B 118      84.878  43.559  81.060  1.00 12.18           C  
ATOM   2656  CD2 PHE B 118      85.295  41.539  82.290  1.00 15.42           C  
ATOM   2657  CE1 PHE B 118      85.325  42.953  79.898  1.00 12.87           C  
ATOM   2658  CE2 PHE B 118      85.743  40.921  81.133  1.00 13.87           C  
ATOM   2659  CZ  PHE B 118      85.758  41.632  79.931  1.00 19.37           C  
ATOM   2660  N   THR B 119      84.314  46.755  84.464  1.00 13.41           N  
ATOM   2661  CA  THR B 119      83.687  47.819  85.228  1.00  6.47           C  
ATOM   2662  C   THR B 119      82.167  47.791  85.106  1.00 10.70           C  
ATOM   2663  O   THR B 119      81.594  46.961  84.394  1.00 16.00           O  
ATOM   2664  CB  THR B 119      84.207  49.202  84.765  1.00 11.48           C  
ATOM   2665  OG1 THR B 119      83.739  49.475  83.442  1.00 15.25           O  
ATOM   2666  CG2 THR B 119      85.732  49.234  84.757  1.00 15.20           C  
ATOM   2667  N   GLU B 120      81.520  48.739  85.774  1.00 10.40           N  
ATOM   2668  CA  GLU B 120      80.071  48.893  85.707  1.00 17.01           C  
ATOM   2669  C   GLU B 120      79.669  49.375  84.322  1.00 13.09           C  
ATOM   2670  O   GLU B 120      78.611  49.007  83.822  1.00 10.02           O  
ATOM   2671  CB  GLU B 120      79.615  49.906  86.754  1.00 14.10           C  
ATOM   2672  CG  GLU B 120      78.119  50.144  86.836  1.00 23.16           C  
ATOM   2673  CD  GLU B 120      77.749  51.139  87.933  1.00 31.60           C  
ATOM   2674  OE1 GLU B 120      78.626  51.905  88.394  1.00 37.81           O  
ATOM   2675  OE2 GLU B 120      76.575  51.144  88.354  1.00 43.92           O  
ATOM   2676  N   LYS B 121      80.552  50.160  83.702  1.00 17.68           N  
ATOM   2677  CA  LYS B 121      80.307  50.773  82.397  1.00 21.25           C  
ATOM   2678  C   LYS B 121      80.473  49.770  81.260  1.00 22.31           C  
ATOM   2679  O   LYS B 121      79.709  49.784  80.297  1.00 20.63           O  
ATOM   2680  CB  LYS B 121      81.262  51.950  82.182  1.00 22.33           C  
ATOM   2681  CG  LYS B 121      80.912  52.835  80.981  1.00 48.01           C  
ATOM   2682  CD  LYS B 121      79.405  53.161  80.908  1.00 66.15           C  
ATOM   2683  CE  LYS B 121      78.980  54.261  81.888  1.00 71.43           C  
ATOM   2684  NZ  LYS B 121      77.494  54.417  81.964  1.00 71.43           N  
ATOM   2685  N   ASP B 122      81.536  48.976  81.337  1.00 15.49           N  
ATOM   2686  CA  ASP B 122      81.698  47.805  80.481  1.00 12.29           C  
ATOM   2687  C   ASP B 122      80.457  46.923  80.544  1.00 12.15           C  
ATOM   2688  O   ASP B 122      79.919  46.528  79.517  1.00 15.88           O  
ATOM   2689  CB  ASP B 122      82.913  46.981  80.921  1.00 17.53           C  
ATOM   2690  CG  ASP B 122      84.220  47.772  80.890  1.00 13.64           C  
ATOM   2691  OD1 ASP B 122      84.351  48.757  80.125  1.00 30.05           O  
ATOM   2692  OD2 ASP B 122      85.134  47.383  81.636  1.00 13.79           O  
ATOM   2693  N   TYR B 123      80.014  46.625  81.762  1.00 12.56           N  
ATOM   2694  CA  TYR B 123      78.820  45.817  81.978  1.00  9.85           C  
ATOM   2695  C   TYR B 123      77.649  46.433  81.239  1.00 14.71           C  
ATOM   2696  O   TYR B 123      76.897  45.740  80.568  1.00 13.39           O  
ATOM   2697  CB  TYR B 123      78.499  45.732  83.475  1.00 15.65           C  
ATOM   2698  CG  TYR B 123      77.198  45.028  83.780  1.00 10.12           C  
ATOM   2699  CD1 TYR B 123      75.995  45.733  83.795  1.00 22.14           C  
ATOM   2700  CD2 TYR B 123      77.148  43.637  83.943  1.00 19.79           C  
ATOM   2701  CE1 TYR B 123      74.769  45.082  83.956  1.00 14.32           C  
ATOM   2702  CE2 TYR B 123      75.921  42.968  84.090  1.00 13.14           C  
ATOM   2703  CZ  TYR B 123      74.738  43.704  84.096  1.00 17.90           C  
ATOM   2704  OH  TYR B 123      73.520  43.080  84.220  1.00 13.65           O  
ATOM   2705  N   ASN B 124      77.512  47.746  81.359  1.00 22.46           N  
ATOM   2706  CA  ASN B 124      76.429  48.462  80.707  1.00 17.85           C  
ATOM   2707  C   ASN B 124      76.563  48.457  79.183  1.00 23.50           C  
ATOM   2708  O   ASN B 124      75.566  48.323  78.470  1.00 22.67           O  
ATOM   2709  CB  ASN B 124      76.357  49.896  81.233  1.00 18.81           C  
ATOM   2710  CG  ASN B 124      75.814  49.971  82.651  1.00 26.61           C  
ATOM   2711  OD1 ASN B 124      75.051  49.105  83.081  1.00 32.75           O  
ATOM   2712  ND2 ASN B 124      76.208  51.010  83.388  1.00 26.64           N  
ATOM   2713  N   ILE B 125      77.793  48.533  78.686  1.00 15.90           N  
ATOM   2714  CA  ILE B 125      78.023  48.479  77.252  1.00 12.14           C  
ATOM   2715  C   ILE B 125      77.728  47.085  76.689  1.00 15.74           C  
ATOM   2716  O   ILE B 125      76.866  46.948  75.836  1.00 23.94           O  
ATOM   2717  CB  ILE B 125      79.464  48.924  76.896  1.00 20.94           C  
ATOM   2718  CG1 ILE B 125      79.600  50.438  77.104  1.00 11.90           C  
ATOM   2719  CG2 ILE B 125      79.813  48.557  75.442  1.00 11.37           C  
ATOM   2720  CD1 ILE B 125      80.949  50.987  76.696  1.00 17.98           C  
ATOM   2721  N   ILE B 126      78.275  46.047  77.311  1.00  8.24           N  
ATOM   2722  CA  ILE B 126      78.149  44.690  76.789  1.00  8.57           C  
ATOM   2723  C   ILE B 126      76.741  44.087  76.916  1.00 10.45           C  
ATOM   2724  O   ILE B 126      76.137  43.701  75.918  1.00 19.67           O  
ATOM   2725  CB  ILE B 126      79.200  43.759  77.441  1.00 13.72           C  
ATOM   2726  CG1 ILE B 126      80.585  44.073  76.869  1.00 11.93           C  
ATOM   2727  CG2 ILE B 126      78.863  42.306  77.187  1.00  7.64           C  
ATOM   2728  CD1 ILE B 126      81.708  43.813  77.826  1.00 11.97           C  
ATOM   2729  N   MET B 127      76.182  44.081  78.120  1.00  8.47           N  
ATOM   2730  CA  MET B 127      74.850  43.511  78.327  1.00  8.79           C  
ATOM   2731  C   MET B 127      73.809  44.358  77.636  1.00  4.03           C  
ATOM   2732  O   MET B 127      72.786  43.853  77.191  1.00  9.45           O  
ATOM   2733  CB  MET B 127      74.513  43.415  79.821  1.00 12.21           C  
ATOM   2734  CG  MET B 127      75.069  42.176  80.510  1.00 21.61           C  
ATOM   2735  SD  MET B 127      74.244  40.666  79.985  1.00 23.32           S  
ATOM   2736  CE  MET B 127      72.539  41.100  80.283  1.00 31.56           C  
ATOM   2737  N   GLY B 128      74.095  45.649  77.536  1.00 11.68           N  
ATOM   2738  CA  GLY B 128      73.156  46.596  76.970  1.00  9.03           C  
ATOM   2739  C   GLY B 128      72.980  46.449  75.474  1.00 11.36           C  
ATOM   2740  O   GLY B 128      71.846  46.408  74.994  1.00 19.24           O  
ATOM   2741  N   THR B 129      74.080  46.375  74.725  1.00  6.40           N  
ATOM   2742  CA  THR B 129      73.929  46.236  73.292  1.00  8.70           C  
ATOM   2743  C   THR B 129      73.755  44.779  72.888  1.00 13.29           C  
ATOM   2744  O   THR B 129      72.837  44.479  72.137  1.00  7.47           O  
ATOM   2745  CB  THR B 129      75.052  46.984  72.449  1.00 14.70           C  
ATOM   2746  OG1 THR B 129      75.477  46.168  71.354  1.00 25.75           O  
ATOM   2747  CG2 THR B 129      76.241  47.388  73.277  1.00  2.00           C  
ATOM   2748  N   ASN B 130      74.419  43.864  73.594  1.00 15.23           N  
ATOM   2749  CA  ASN B 130      74.351  42.441  73.247  1.00  5.11           C  
ATOM   2750  C   ASN B 130      73.097  41.716  73.690  1.00  4.97           C  
ATOM   2751  O   ASN B 130      72.672  40.771  73.022  1.00 14.55           O  
ATOM   2752  CB  ASN B 130      75.567  41.686  73.778  1.00  5.51           C  
ATOM   2753  CG  ASN B 130      76.854  42.149  73.149  1.00 13.86           C  
ATOM   2754  OD1 ASN B 130      77.932  41.640  73.466  1.00 18.84           O  
ATOM   2755  ND2 ASN B 130      76.764  43.151  72.289  1.00 17.39           N  
ATOM   2756  N   PHE B 131      72.537  42.095  74.835  1.00  6.58           N  
ATOM   2757  CA  PHE B 131      71.317  41.454  75.291  1.00  3.36           C  
ATOM   2758  C   PHE B 131      70.106  42.371  75.377  1.00  4.19           C  
ATOM   2759  O   PHE B 131      69.069  42.067  74.792  1.00 18.94           O  
ATOM   2760  CB  PHE B 131      71.528  40.746  76.631  1.00  6.00           C  
ATOM   2761  CG  PHE B 131      70.289  40.046  77.143  1.00 12.44           C  
ATOM   2762  CD1 PHE B 131      69.767  38.944  76.464  1.00  9.72           C  
ATOM   2763  CD2 PHE B 131      69.570  40.569  78.217  1.00 10.10           C  
ATOM   2764  CE1 PHE B 131      68.543  38.380  76.837  1.00  8.69           C  
ATOM   2765  CE2 PHE B 131      68.338  40.017  78.596  1.00  9.90           C  
ATOM   2766  CZ  PHE B 131      67.825  38.922  77.902  1.00 13.01           C  
ATOM   2767  N   GLU B 132      70.192  43.445  76.157  1.00  9.44           N  
ATOM   2768  CA  GLU B 132      69.015  44.277  76.411  1.00 11.04           C  
ATOM   2769  C   GLU B 132      68.412  44.877  75.141  1.00 10.48           C  
ATOM   2770  O   GLU B 132      67.199  44.810  74.934  1.00 12.29           O  
ATOM   2771  CB  GLU B 132      69.332  45.398  77.404  1.00 10.03           C  
ATOM   2772  CG  GLU B 132      68.081  46.176  77.804  1.00 21.41           C  
ATOM   2773  CD  GLU B 132      68.324  47.237  78.863  1.00 24.64           C  
ATOM   2774  OE1 GLU B 132      69.457  47.749  78.958  1.00 30.41           O  
ATOM   2775  OE2 GLU B 132      67.357  47.583  79.583  1.00 39.31           O  
ATOM   2776  N   ALA B 133      69.264  45.435  74.288  1.00  7.87           N  
ATOM   2777  CA  ALA B 133      68.826  46.014  73.023  1.00 12.50           C  
ATOM   2778  C   ALA B 133      68.139  44.961  72.160  1.00 11.31           C  
ATOM   2779  O   ALA B 133      67.006  45.159  71.719  1.00 18.24           O  
ATOM   2780  CB  ALA B 133      70.020  46.601  72.284  1.00 13.62           C  
ATOM   2781  N   ALA B 134      68.770  43.791  72.064  1.00 12.43           N  
ATOM   2782  CA  ALA B 134      68.296  42.681  71.229  1.00  9.69           C  
ATOM   2783  C   ALA B 134      66.944  42.163  71.691  1.00 11.32           C  
ATOM   2784  O   ALA B 134      66.029  41.963  70.891  1.00 19.65           O  
ATOM   2785  CB  ALA B 134      69.325  41.549  71.238  1.00  2.29           C  
ATOM   2786  N   TYR B 135      66.803  42.034  73.003  1.00 14.68           N  
ATOM   2787  CA  TYR B 135      65.564  41.571  73.606  1.00 14.24           C  
ATOM   2788  C   TYR B 135      64.477  42.637  73.464  1.00 13.68           C  
ATOM   2789  O   TYR B 135      63.322  42.325  73.151  1.00 11.85           O  
ATOM   2790  CB  TYR B 135      65.811  41.236  75.084  1.00  8.71           C  
ATOM   2791  CG  TYR B 135      64.560  41.048  75.911  1.00 13.18           C  
ATOM   2792  CD1 TYR B 135      63.556  40.167  75.500  1.00 16.74           C  
ATOM   2793  CD2 TYR B 135      64.392  41.720  77.127  1.00  6.67           C  
ATOM   2794  CE1 TYR B 135      62.420  39.937  76.292  1.00 19.48           C  
ATOM   2795  CE2 TYR B 135      63.247  41.513  77.919  1.00  6.69           C  
ATOM   2796  CZ  TYR B 135      62.272  40.609  77.500  1.00 23.03           C  
ATOM   2797  OH  TYR B 135      61.185  40.317  78.307  1.00 12.85           O  
ATOM   2798  N   HIS B 136      64.843  43.896  73.686  1.00 10.87           N  
ATOM   2799  CA  HIS B 136      63.861  44.977  73.656  1.00 14.99           C  
ATOM   2800  C   HIS B 136      63.286  45.182  72.255  1.00 15.46           C  
ATOM   2801  O   HIS B 136      62.072  45.357  72.103  1.00 23.59           O  
ATOM   2802  CB  HIS B 136      64.474  46.283  74.164  1.00 20.85           C  
ATOM   2803  CG  HIS B 136      63.528  47.442  74.129  1.00 14.03           C  
ATOM   2804  ND1 HIS B 136      63.867  48.661  73.582  1.00 19.28           N  
ATOM   2805  CD2 HIS B 136      62.218  47.528  74.460  1.00 11.06           C  
ATOM   2806  CE1 HIS B 136      62.806  49.449  73.573  1.00  9.85           C  
ATOM   2807  NE2 HIS B 136      61.792  48.786  74.098  1.00 16.05           N  
ATOM   2808  N   LEU B 137      64.144  45.105  71.237  1.00 16.66           N  
ATOM   2809  CA  LEU B 137      63.694  45.147  69.846  1.00  7.87           C  
ATOM   2810  C   LEU B 137      62.716  44.024  69.546  1.00 12.09           C  
ATOM   2811  O   LEU B 137      61.689  44.233  68.893  1.00 13.46           O  
ATOM   2812  CB  LEU B 137      64.877  45.039  68.897  1.00 11.08           C  
ATOM   2813  CG  LEU B 137      65.729  46.290  68.715  1.00 13.39           C  
ATOM   2814  CD1 LEU B 137      66.865  45.961  67.763  1.00 11.07           C  
ATOM   2815  CD2 LEU B 137      64.881  47.443  68.185  1.00 11.98           C  
ATOM   2816  N   SER B 138      63.007  42.844  70.078  1.00 14.35           N  
ATOM   2817  CA  SER B 138      62.138  41.699  69.884  1.00  9.57           C  
ATOM   2818  C   SER B 138      60.761  41.952  70.497  1.00 12.90           C  
ATOM   2819  O   SER B 138      59.742  41.640  69.873  1.00 17.34           O  
ATOM   2820  CB  SER B 138      62.793  40.462  70.486  1.00  6.91           C  
ATOM   2821  OG  SER B 138      64.123  40.352  70.009  1.00  6.86           O  
ATOM   2822  N   GLN B 139      60.733  42.654  71.631  1.00 14.77           N  
ATOM   2823  CA  GLN B 139      59.473  43.048  72.270  1.00 13.03           C  
ATOM   2824  C   GLN B 139      58.641  44.001  71.423  1.00  8.03           C  
ATOM   2825  O   GLN B 139      57.444  43.801  71.261  1.00 15.95           O  
ATOM   2826  CB  GLN B 139      59.727  43.735  73.602  1.00 10.82           C  
ATOM   2827  CG  GLN B 139      60.244  42.858  74.711  1.00  8.87           C  
ATOM   2828  CD  GLN B 139      60.310  43.622  76.021  1.00 19.57           C  
ATOM   2829  OE1 GLN B 139      59.695  43.231  77.011  1.00 20.36           O  
ATOM   2830  NE2 GLN B 139      60.974  44.774  75.999  1.00  8.92           N  
ATOM   2831  N   ILE B 140      59.244  45.112  71.012  1.00 13.61           N  
ATOM   2832  CA  ILE B 140      58.499  46.138  70.290  1.00 14.71           C  
ATOM   2833  C   ILE B 140      58.274  45.744  68.835  1.00 15.11           C  
ATOM   2834  O   ILE B 140      57.447  46.340  68.148  1.00 18.92           O  
ATOM   2835  CB  ILE B 140      59.188  47.545  70.382  1.00 12.41           C  
ATOM   2836  CG1 ILE B 140      60.565  47.544  69.717  1.00 17.96           C  
ATOM   2837  CG2 ILE B 140      59.347  47.945  71.835  1.00 17.91           C  
ATOM   2838  CD1 ILE B 140      61.365  48.836  69.940  1.00  2.00           C  
ATOM   2839  N   ALA B 141      58.943  44.681  68.400  1.00 10.33           N  
ATOM   2840  CA  ALA B 141      58.762  44.159  67.048  1.00 13.99           C  
ATOM   2841  C   ALA B 141      57.628  43.144  66.991  1.00 13.21           C  
ATOM   2842  O   ALA B 141      57.014  42.944  65.942  1.00 18.92           O  
ATOM   2843  CB  ALA B 141      60.056  43.521  66.553  1.00  8.31           C  
ATOM   2844  N   TYR B 142      57.314  42.553  68.141  1.00 13.69           N  
ATOM   2845  CA  TYR B 142      56.350  41.462  68.227  1.00 18.43           C  
ATOM   2846  C   TYR B 142      55.089  41.672  67.387  1.00 20.10           C  
ATOM   2847  O   TYR B 142      54.713  40.800  66.613  1.00 28.14           O  
ATOM   2848  CB  TYR B 142      55.967  41.220  69.690  1.00 23.07           C  
ATOM   2849  CG  TYR B 142      54.844  40.228  69.894  1.00 22.60           C  
ATOM   2850  CD1 TYR B 142      55.013  38.879  69.586  1.00 19.96           C  
ATOM   2851  CD2 TYR B 142      53.640  40.624  70.469  1.00 20.47           C  
ATOM   2852  CE1 TYR B 142      54.019  37.945  69.870  1.00 17.02           C  
ATOM   2853  CE2 TYR B 142      52.634  39.697  70.744  1.00 20.07           C  
ATOM   2854  CZ  TYR B 142      52.839  38.360  70.454  1.00 15.23           C  
ATOM   2855  OH  TYR B 142      51.897  37.429  70.819  1.00 23.22           O  
ATOM   2856  N   PRO B 143      54.406  42.817  67.551  1.00 15.80           N  
ATOM   2857  CA  PRO B 143      53.139  43.017  66.841  1.00 13.53           C  
ATOM   2858  C   PRO B 143      53.343  43.114  65.330  1.00 16.96           C  
ATOM   2859  O   PRO B 143      52.503  42.667  64.548  1.00 18.24           O  
ATOM   2860  CB  PRO B 143      52.613  44.334  67.421  1.00 16.82           C  
ATOM   2861  CG  PRO B 143      53.394  44.547  68.670  1.00 11.82           C  
ATOM   2862  CD  PRO B 143      54.738  43.989  68.372  1.00 16.71           C  
ATOM   2863  N   LEU B 144      54.474  43.690  64.935  1.00 17.55           N  
ATOM   2864  CA  LEU B 144      54.841  43.787  63.534  1.00 18.65           C  
ATOM   2865  C   LEU B 144      55.107  42.403  62.932  1.00 20.83           C  
ATOM   2866  O   LEU B 144      54.650  42.109  61.829  1.00 25.66           O  
ATOM   2867  CB  LEU B 144      56.074  44.683  63.377  1.00 17.97           C  
ATOM   2868  CG  LEU B 144      55.868  46.195  63.216  1.00 18.08           C  
ATOM   2869  CD1 LEU B 144      55.291  46.776  64.480  1.00 18.11           C  
ATOM   2870  CD2 LEU B 144      57.195  46.868  62.891  1.00 14.39           C  
ATOM   2871  N   LEU B 145      55.788  41.539  63.682  1.00 18.93           N  
ATOM   2872  CA  LEU B 145      56.102  40.188  63.208  1.00 16.58           C  
ATOM   2873  C   LEU B 145      54.856  39.308  63.219  1.00 11.36           C  
ATOM   2874  O   LEU B 145      54.650  38.489  62.328  1.00 17.07           O  
ATOM   2875  CB  LEU B 145      57.182  39.552  64.084  1.00 13.65           C  
ATOM   2876  CG  LEU B 145      58.563  40.205  64.082  1.00 17.88           C  
ATOM   2877  CD1 LEU B 145      59.304  39.841  65.361  1.00 10.03           C  
ATOM   2878  CD2 LEU B 145      59.337  39.754  62.857  1.00  9.27           C  
ATOM   2879  N   LYS B 146      54.016  39.508  64.225  1.00 13.58           N  
ATOM   2880  CA  LYS B 146      52.738  38.810  64.329  1.00 19.84           C  
ATOM   2881  C   LYS B 146      51.840  39.121  63.128  1.00 20.20           C  
ATOM   2882  O   LYS B 146      51.289  38.214  62.497  1.00 26.76           O  
ATOM   2883  CB  LYS B 146      52.037  39.224  65.627  1.00 16.66           C  
ATOM   2884  CG  LYS B 146      51.064  38.200  66.160  1.00 28.45           C  
ATOM   2885  CD  LYS B 146      50.377  38.680  67.433  1.00 35.82           C  
ATOM   2886  CE  LYS B 146      49.162  37.806  67.754  1.00 55.85           C  
ATOM   2887  NZ  LYS B 146      48.982  37.540  69.213  1.00 68.30           N  
ATOM   2888  N   ALA B 147      51.798  40.396  62.749  1.00 18.75           N  
ATOM   2889  CA  ALA B 147      50.907  40.863  61.695  1.00 24.48           C  
ATOM   2890  C   ALA B 147      51.294  40.324  60.323  1.00 25.31           C  
ATOM   2891  O   ALA B 147      50.466  40.294  59.411  1.00 32.71           O  
ATOM   2892  CB  ALA B 147      50.880  42.389  61.672  1.00 20.31           C  
ATOM   2893  N   SER B 148      52.535  39.861  60.193  1.00 25.83           N  
ATOM   2894  CA  SER B 148      53.027  39.289  58.938  1.00 28.75           C  
ATOM   2895  C   SER B 148      52.599  37.832  58.763  1.00 31.69           C  
ATOM   2896  O   SER B 148      52.643  37.295  57.654  1.00 35.21           O  
ATOM   2897  CB  SER B 148      54.555  39.377  58.876  1.00 20.20           C  
ATOM   2898  OG  SER B 148      55.155  38.316  59.603  1.00 11.56           O  
ATOM   2899  N   GLN B 149      52.329  37.168  59.887  1.00 33.85           N  
ATOM   2900  CA  GLN B 149      51.930  35.764  59.912  1.00 28.11           C  
ATOM   2901  C   GLN B 149      53.019  34.805  59.428  1.00 24.19           C  
ATOM   2902  O   GLN B 149      52.784  33.607  59.287  1.00 33.13           O  
ATOM   2903  CB  GLN B 149      50.666  35.561  59.082  1.00 38.61           C  
ATOM   2904  CG  GLN B 149      49.428  36.202  59.672  1.00 53.64           C  
ATOM   2905  CD  GLN B 149      48.345  36.421  58.634  1.00 65.68           C  
ATOM   2906  OE1 GLN B 149      47.959  35.500  57.909  1.00 69.12           O  
ATOM   2907  NE2 GLN B 149      47.869  37.657  58.534  1.00 81.29           N  
ATOM   2908  N   ASN B 150      54.223  35.328  59.227  1.00 21.60           N  
ATOM   2909  CA  ASN B 150      55.372  34.508  58.877  1.00 16.28           C  
ATOM   2910  C   ASN B 150      56.629  35.197  59.398  1.00 13.62           C  
ATOM   2911  O   ASN B 150      57.440  35.719  58.624  1.00 12.78           O  
ATOM   2912  CB  ASN B 150      55.453  34.307  57.354  1.00 22.46           C  
ATOM   2913  CG  ASN B 150      56.740  33.607  56.920  1.00 35.62           C  
ATOM   2914  OD1 ASN B 150      57.368  33.994  55.933  1.00 41.51           O  
ATOM   2915  ND2 ASN B 150      57.160  32.606  57.686  1.00 36.16           N  
ATOM   2916  N   GLY B 151      56.751  35.233  60.721  1.00  6.61           N  
ATOM   2917  CA  GLY B 151      57.822  35.982  61.353  1.00  6.13           C  
ATOM   2918  C   GLY B 151      59.001  35.120  61.755  1.00 11.28           C  
ATOM   2919  O   GLY B 151      58.843  33.941  62.069  1.00 17.83           O  
ATOM   2920  N   ASN B 152      60.184  35.725  61.756  1.00  6.62           N  
ATOM   2921  CA  ASN B 152      61.419  35.071  62.156  1.00 12.05           C  
ATOM   2922  C   ASN B 152      62.243  36.037  63.007  1.00 14.74           C  
ATOM   2923  O   ASN B 152      62.436  37.189  62.625  1.00 20.46           O  
ATOM   2924  CB  ASN B 152      62.224  34.673  60.919  1.00 13.95           C  
ATOM   2925  CG  ASN B 152      61.776  33.361  60.332  1.00 17.15           C  
ATOM   2926  OD1 ASN B 152      61.028  33.315  59.353  1.00 18.13           O  
ATOM   2927  ND2 ASN B 152      62.231  32.278  60.931  1.00 11.74           N  
ATOM   2928  N   VAL B 153      62.622  35.604  64.206  1.00 17.14           N  
ATOM   2929  CA  VAL B 153      63.598  36.330  65.010  1.00  9.90           C  
ATOM   2930  C   VAL B 153      64.887  35.527  65.072  1.00 11.06           C  
ATOM   2931  O   VAL B 153      64.871  34.348  65.414  1.00 15.39           O  
ATOM   2932  CB  VAL B 153      63.096  36.583  66.449  1.00  8.74           C  
ATOM   2933  CG1 VAL B 153      64.156  37.349  67.244  1.00  2.00           C  
ATOM   2934  CG2 VAL B 153      61.795  37.373  66.423  1.00  2.83           C  
ATOM   2935  N   ILE B 154      65.969  36.129  64.596  1.00 12.90           N  
ATOM   2936  CA  ILE B 154      67.287  35.510  64.648  1.00 11.24           C  
ATOM   2937  C   ILE B 154      68.191  36.338  65.552  1.00 17.24           C  
ATOM   2938  O   ILE B 154      68.391  37.532  65.322  1.00 17.41           O  
ATOM   2939  CB  ILE B 154      67.944  35.445  63.251  1.00 18.37           C  
ATOM   2940  CG1 ILE B 154      66.975  34.831  62.232  1.00 15.25           C  
ATOM   2941  CG2 ILE B 154      69.265  34.685  63.334  1.00  7.53           C  
ATOM   2942  CD1 ILE B 154      67.176  33.371  61.990  1.00  7.30           C  
ATOM   2943  N   PHE B 155      68.695  35.711  66.607  1.00 16.64           N  
ATOM   2944  CA  PHE B 155      69.727  36.318  67.437  1.00 17.48           C  
ATOM   2945  C   PHE B 155      71.084  35.772  67.004  1.00 17.97           C  
ATOM   2946  O   PHE B 155      71.166  34.707  66.391  1.00 15.31           O  
ATOM   2947  CB  PHE B 155      69.495  35.992  68.918  1.00 17.63           C  
ATOM   2948  CG  PHE B 155      68.220  36.552  69.477  1.00 16.92           C  
ATOM   2949  CD1 PHE B 155      68.137  37.886  69.854  1.00 12.11           C  
ATOM   2950  CD2 PHE B 155      67.114  35.729  69.667  1.00 20.05           C  
ATOM   2951  CE1 PHE B 155      66.974  38.393  70.409  1.00 16.05           C  
ATOM   2952  CE2 PHE B 155      65.949  36.230  70.221  1.00 15.10           C  
ATOM   2953  CZ  PHE B 155      65.879  37.567  70.593  1.00 19.31           C  
ATOM   2954  N   LEU B 156      72.141  36.523  67.287  1.00 14.35           N  
ATOM   2955  CA  LEU B 156      73.489  36.069  66.985  1.00 16.22           C  
ATOM   2956  C   LEU B 156      74.259  35.767  68.255  1.00 16.62           C  
ATOM   2957  O   LEU B 156      74.440  36.641  69.098  1.00 18.51           O  
ATOM   2958  CB  LEU B 156      74.232  37.109  66.149  1.00 14.05           C  
ATOM   2959  CG  LEU B 156      74.280  36.643  64.695  1.00 14.92           C  
ATOM   2960  CD1 LEU B 156      73.244  37.385  63.869  1.00  9.26           C  
ATOM   2961  CD2 LEU B 156      75.666  36.832  64.154  1.00 12.05           C  
ATOM   2962  N   SER B 157      74.585  34.494  68.442  1.00 11.05           N  
ATOM   2963  CA  SER B 157      75.302  34.053  69.625  1.00  9.30           C  
ATOM   2964  C   SER B 157      76.779  33.929  69.287  1.00 10.66           C  
ATOM   2965  O   SER B 157      77.292  34.685  68.462  1.00 12.49           O  
ATOM   2966  CB  SER B 157      74.744  32.721  70.106  1.00  8.95           C  
ATOM   2967  OG  SER B 157      75.244  32.410  71.385  1.00 15.03           O  
ATOM   2968  N   SER B 158      77.474  32.994  69.928  1.00  7.99           N  
ATOM   2969  CA  SER B 158      78.909  32.860  69.722  1.00  5.35           C  
ATOM   2970  C   SER B 158      79.372  31.515  70.274  1.00 10.79           C  
ATOM   2971  O   SER B 158      78.673  30.896  71.076  1.00 10.12           O  
ATOM   2972  CB  SER B 158      79.638  34.010  70.432  1.00  7.47           C  
ATOM   2973  OG  SER B 158      81.034  34.001  70.186  1.00 22.75           O  
ATOM   2974  N   ILE B 159      80.523  31.044  69.800  1.00 10.67           N  
ATOM   2975  CA  ILE B 159      81.204  29.918  70.436  1.00 12.68           C  
ATOM   2976  C   ILE B 159      81.474  30.225  71.913  1.00 14.34           C  
ATOM   2977  O   ILE B 159      81.460  29.330  72.761  1.00 14.59           O  
ATOM   2978  CB  ILE B 159      82.546  29.575  69.717  1.00  8.20           C  
ATOM   2979  CG1 ILE B 159      83.378  30.841  69.480  1.00 18.30           C  
ATOM   2980  CG2 ILE B 159      82.270  28.886  68.396  1.00 11.62           C  
ATOM   2981  CD1 ILE B 159      84.754  30.587  68.840  1.00  4.07           C  
ATOM   2982  N   ALA B 160      81.574  31.517  72.220  1.00 17.92           N  
ATOM   2983  CA  ALA B 160      81.755  32.000  73.585  1.00 13.33           C  
ATOM   2984  C   ALA B 160      80.511  31.747  74.432  1.00 10.37           C  
ATOM   2985  O   ALA B 160      80.563  31.827  75.654  1.00 17.30           O  
ATOM   2986  CB  ALA B 160      82.092  33.493  73.568  1.00  6.50           C  
ATOM   2987  N   GLY B 161      79.391  31.465  73.769  1.00 11.77           N  
ATOM   2988  CA  GLY B 161      78.175  31.075  74.463  1.00  9.07           C  
ATOM   2989  C   GLY B 161      78.053  29.569  74.635  1.00  9.31           C  
ATOM   2990  O   GLY B 161      76.985  29.065  74.968  1.00 12.79           O  
ATOM   2991  N   PHE B 162      79.151  28.851  74.417  1.00 10.93           N  
ATOM   2992  CA  PHE B 162      79.190  27.402  74.626  1.00 15.71           C  
ATOM   2993  C   PHE B 162      80.087  27.024  75.821  1.00 11.89           C  
ATOM   2994  O   PHE B 162      79.651  26.388  76.780  1.00 14.80           O  
ATOM   2995  CB  PHE B 162      79.704  26.718  73.355  1.00 16.86           C  
ATOM   2996  CG  PHE B 162      79.757  25.221  73.448  1.00 17.14           C  
ATOM   2997  CD1 PHE B 162      78.600  24.462  73.304  1.00 18.38           C  
ATOM   2998  CD2 PHE B 162      80.967  24.564  73.657  1.00 21.23           C  
ATOM   2999  CE1 PHE B 162      78.643  23.068  73.367  1.00 18.56           C  
ATOM   3000  CE2 PHE B 162      81.019  23.166  73.723  1.00 22.12           C  
ATOM   3001  CZ  PHE B 162      79.856  22.421  73.579  1.00 15.08           C  
ATOM   3002  N   SER B 163      81.351  27.407  75.730  1.00 10.93           N  
ATOM   3003  CA  SER B 163      82.334  27.108  76.755  1.00 14.37           C  
ATOM   3004  C   SER B 163      83.127  28.388  76.958  1.00 12.65           C  
ATOM   3005  O   SER B 163      83.033  29.296  76.147  1.00 18.54           O  
ATOM   3006  CB  SER B 163      83.251  25.983  76.268  1.00 14.47           C  
ATOM   3007  OG  SER B 163      83.773  26.278  74.977  1.00 28.45           O  
ATOM   3008  N   ALA B 164      83.930  28.447  78.014  1.00 15.78           N  
ATOM   3009  CA  ALA B 164      84.675  29.664  78.337  1.00 16.45           C  
ATOM   3010  C   ALA B 164      85.838  29.959  77.376  1.00 17.50           C  
ATOM   3011  O   ALA B 164      86.587  29.056  76.970  1.00 16.58           O  
ATOM   3012  CB  ALA B 164      85.180  29.606  79.788  1.00  8.19           C  
ATOM   3013  N   LEU B 165      85.950  31.223  76.978  1.00 12.76           N  
ATOM   3014  CA  LEU B 165      87.103  31.698  76.220  1.00 11.72           C  
ATOM   3015  C   LEU B 165      87.814  32.789  77.022  1.00 15.60           C  
ATOM   3016  O   LEU B 165      87.175  33.546  77.756  1.00 14.30           O  
ATOM   3017  CB  LEU B 165      86.647  32.266  74.876  1.00 12.62           C  
ATOM   3018  CG  LEU B 165      85.911  31.354  73.894  1.00 17.05           C  
ATOM   3019  CD1 LEU B 165      85.511  32.185  72.688  1.00 16.96           C  
ATOM   3020  CD2 LEU B 165      86.797  30.190  73.464  1.00  7.33           C  
ATOM   3021  N   PRO B 166      89.145  32.915  76.862  1.00 11.09           N  
ATOM   3022  CA  PRO B 166      89.880  33.962  77.584  1.00 10.44           C  
ATOM   3023  C   PRO B 166      89.516  35.395  77.186  1.00 14.24           C  
ATOM   3024  O   PRO B 166      89.139  35.655  76.035  1.00 19.74           O  
ATOM   3025  CB  PRO B 166      91.346  33.636  77.297  1.00 10.26           C  
ATOM   3026  CG  PRO B 166      91.313  32.786  76.056  1.00 12.35           C  
ATOM   3027  CD  PRO B 166      90.055  31.994  76.161  1.00  5.72           C  
ATOM   3028  N   SER B 167      89.426  36.252  78.206  1.00 15.59           N  
ATOM   3029  CA  SER B 167      89.302  37.703  78.052  1.00 15.33           C  
ATOM   3030  C   SER B 167      87.903  38.233  77.729  1.00 12.31           C  
ATOM   3031  O   SER B 167      87.708  39.438  77.582  1.00 14.39           O  
ATOM   3032  CB  SER B 167      90.308  38.219  77.011  1.00 10.72           C  
ATOM   3033  OG  SER B 167      91.635  37.940  77.425  1.00 17.26           O  
ATOM   3034  N   VAL B 168      86.915  37.352  77.689  1.00  9.06           N  
ATOM   3035  CA  VAL B 168      85.583  37.756  77.265  1.00  4.94           C  
ATOM   3036  C   VAL B 168      84.489  37.199  78.172  1.00  7.97           C  
ATOM   3037  O   VAL B 168      83.353  37.028  77.744  1.00 11.27           O  
ATOM   3038  CB  VAL B 168      85.327  37.338  75.783  1.00  5.06           C  
ATOM   3039  CG1 VAL B 168      86.392  37.938  74.904  1.00  2.00           C  
ATOM   3040  CG2 VAL B 168      85.340  35.821  75.620  1.00  2.00           C  
ATOM   3041  N   SER B 169      84.801  37.055  79.457  1.00 11.97           N  
ATOM   3042  CA  SER B 169      83.880  36.439  80.410  1.00 12.68           C  
ATOM   3043  C   SER B 169      82.503  37.102  80.412  1.00 10.35           C  
ATOM   3044  O   SER B 169      81.484  36.439  80.238  1.00 21.06           O  
ATOM   3045  CB  SER B 169      84.479  36.447  81.827  1.00  9.73           C  
ATOM   3046  OG  SER B 169      84.735  37.759  82.291  1.00  5.54           O  
ATOM   3047  N   LEU B 170      82.487  38.427  80.495  1.00 17.41           N  
ATOM   3048  CA  LEU B 170      81.236  39.181  80.540  1.00 13.09           C  
ATOM   3049  C   LEU B 170      80.496  39.137  79.195  1.00 10.65           C  
ATOM   3050  O   LEU B 170      79.265  39.119  79.161  1.00 17.27           O  
ATOM   3051  CB  LEU B 170      81.523  40.633  80.961  1.00 10.19           C  
ATOM   3052  CG  LEU B 170      80.375  41.605  81.273  1.00 11.63           C  
ATOM   3053  CD1 LEU B 170      79.359  41.005  82.242  1.00 16.79           C  
ATOM   3054  CD2 LEU B 170      80.973  42.865  81.852  1.00 12.09           C  
ATOM   3055  N   TYR B 171      81.251  39.091  78.097  1.00  4.27           N  
ATOM   3056  CA  TYR B 171      80.679  38.872  76.772  1.00  4.34           C  
ATOM   3057  C   TYR B 171      79.960  37.522  76.723  1.00 13.04           C  
ATOM   3058  O   TYR B 171      78.797  37.449  76.310  1.00 17.99           O  
ATOM   3059  CB  TYR B 171      81.784  38.923  75.711  1.00 12.23           C  
ATOM   3060  CG  TYR B 171      81.345  38.600  74.295  1.00 17.23           C  
ATOM   3061  CD1 TYR B 171      80.735  39.567  73.498  1.00 17.31           C  
ATOM   3062  CD2 TYR B 171      81.679  37.380  73.703  1.00 12.66           C  
ATOM   3063  CE1 TYR B 171      80.496  39.341  72.148  1.00 17.65           C  
ATOM   3064  CE2 TYR B 171      81.438  37.141  72.353  1.00 17.79           C  
ATOM   3065  CZ  TYR B 171      80.857  38.132  71.576  1.00 22.08           C  
ATOM   3066  OH  TYR B 171      80.705  37.951  70.215  1.00 16.06           O  
ATOM   3067  N   SER B 172      80.619  36.478  77.229  1.00  7.17           N  
ATOM   3068  CA  SER B 172      80.043  35.133  77.243  1.00  2.50           C  
ATOM   3069  C   SER B 172      78.728  35.104  77.997  1.00  7.56           C  
ATOM   3070  O   SER B 172      77.751  34.519  77.525  1.00 11.00           O  
ATOM   3071  CB  SER B 172      81.017  34.138  77.875  1.00 10.79           C  
ATOM   3072  OG  SER B 172      82.202  34.028  77.101  1.00 17.75           O  
ATOM   3073  N   ALA B 173      78.692  35.777  79.143  1.00  2.46           N  
ATOM   3074  CA  ALA B 173      77.483  35.868  79.950  1.00  3.27           C  
ATOM   3075  C   ALA B 173      76.323  36.457  79.152  1.00 13.49           C  
ATOM   3076  O   ALA B 173      75.190  35.969  79.248  1.00 12.42           O  
ATOM   3077  CB  ALA B 173      77.748  36.703  81.185  1.00  6.27           C  
ATOM   3078  N   SER B 174      76.606  37.479  78.339  1.00  8.78           N  
ATOM   3079  CA  SER B 174      75.551  38.119  77.550  1.00 10.05           C  
ATOM   3080  C   SER B 174      75.027  37.178  76.457  1.00 15.61           C  
ATOM   3081  O   SER B 174      73.816  37.109  76.219  1.00 10.43           O  
ATOM   3082  CB  SER B 174      76.050  39.434  76.933  1.00  6.24           C  
ATOM   3083  OG  SER B 174      76.907  39.221  75.824  1.00  5.61           O  
ATOM   3084  N   LYS B 175      75.932  36.391  75.872  1.00  8.77           N  
ATOM   3085  CA  LYS B 175      75.578  35.385  74.872  1.00  2.18           C  
ATOM   3086  C   LYS B 175      74.825  34.201  75.486  1.00  6.82           C  
ATOM   3087  O   LYS B 175      74.029  33.547  74.817  1.00 13.84           O  
ATOM   3088  CB  LYS B 175      76.839  34.897  74.150  1.00  3.92           C  
ATOM   3089  CG  LYS B 175      77.517  35.959  73.298  1.00  2.00           C  
ATOM   3090  CD  LYS B 175      76.494  36.675  72.418  1.00  5.17           C  
ATOM   3091  CE  LYS B 175      77.163  37.632  71.455  1.00 14.55           C  
ATOM   3092  NZ  LYS B 175      76.219  38.148  70.429  1.00  2.00           N  
ATOM   3093  N   GLY B 176      75.041  33.967  76.777  1.00 16.88           N  
ATOM   3094  CA  GLY B 176      74.250  32.988  77.503  1.00  6.41           C  
ATOM   3095  C   GLY B 176      72.815  33.440  77.717  1.00 11.97           C  
ATOM   3096  O   GLY B 176      71.877  32.659  77.544  1.00 15.97           O  
ATOM   3097  N   ALA B 177      72.635  34.717  78.048  1.00 12.40           N  
ATOM   3098  CA  ALA B 177      71.297  35.289  78.169  1.00  6.41           C  
ATOM   3099  C   ALA B 177      70.543  35.195  76.840  1.00  7.58           C  
ATOM   3100  O   ALA B 177      69.402  34.739  76.809  1.00  9.10           O  
ATOM   3101  CB  ALA B 177      71.386  36.743  78.642  1.00  2.00           C  
ATOM   3102  N   ILE B 178      71.227  35.522  75.740  1.00  8.10           N  
ATOM   3103  CA  ILE B 178      70.661  35.395  74.395  1.00  4.23           C  
ATOM   3104  C   ILE B 178      70.191  33.959  74.111  1.00 13.29           C  
ATOM   3105  O   ILE B 178      69.037  33.747  73.707  1.00 10.54           O  
ATOM   3106  CB  ILE B 178      71.693  35.837  73.306  1.00 12.19           C  
ATOM   3107  CG1 ILE B 178      71.691  37.358  73.166  1.00  2.00           C  
ATOM   3108  CG2 ILE B 178      71.354  35.210  71.956  1.00 12.05           C  
ATOM   3109  CD1 ILE B 178      70.293  37.932  72.901  1.00  5.31           C  
ATOM   3110  N   ASN B 179      71.061  32.984  74.392  1.00  9.93           N  
ATOM   3111  CA  ASN B 179      70.776  31.569  74.140  1.00 12.06           C  
ATOM   3112  C   ASN B 179      69.520  31.110  74.863  1.00 15.86           C  
ATOM   3113  O   ASN B 179      68.665  30.442  74.282  1.00 17.91           O  
ATOM   3114  CB  ASN B 179      71.948  30.689  74.586  1.00  4.66           C  
ATOM   3115  CG  ASN B 179      73.152  30.788  73.667  1.00 10.25           C  
ATOM   3116  OD1 ASN B 179      74.214  30.261  73.984  1.00 23.10           O  
ATOM   3117  ND2 ASN B 179      72.998  31.459  72.529  1.00 13.15           N  
ATOM   3118  N   GLN B 180      69.394  31.506  76.127  1.00 17.46           N  
ATOM   3119  CA  GLN B 180      68.219  31.164  76.914  1.00 10.99           C  
ATOM   3120  C   GLN B 180      66.982  31.941  76.481  1.00 12.92           C  
ATOM   3121  O   GLN B 180      65.884  31.387  76.431  1.00 17.75           O  
ATOM   3122  CB  GLN B 180      68.488  31.402  78.395  1.00 19.46           C  
ATOM   3123  CG  GLN B 180      67.798  30.391  79.303  1.00 31.42           C  
ATOM   3124  CD  GLN B 180      68.007  28.954  78.854  1.00 31.87           C  
ATOM   3125  OE1 GLN B 180      67.045  28.206  78.657  1.00 37.08           O  
ATOM   3126  NE2 GLN B 180      69.265  28.571  78.659  1.00 24.16           N  
ATOM   3127  N   MET B 181      67.171  33.204  76.106  1.00 16.49           N  
ATOM   3128  CA  MET B 181      66.062  34.022  75.633  1.00 14.00           C  
ATOM   3129  C   MET B 181      65.501  33.454  74.329  1.00 13.51           C  
ATOM   3130  O   MET B 181      64.289  33.451  74.125  1.00 16.98           O  
ATOM   3131  CB  MET B 181      66.510  35.476  75.441  1.00 13.57           C  
ATOM   3132  CG  MET B 181      65.393  36.439  75.054  1.00  7.95           C  
ATOM   3133  SD  MET B 181      63.925  36.360  76.110  1.00 16.63           S  
ATOM   3134  CE  MET B 181      64.572  37.149  77.623  1.00  6.44           C  
ATOM   3135  N   THR B 182      66.366  32.841  73.524  1.00 15.44           N  
ATOM   3136  CA  THR B 182      65.931  32.205  72.280  1.00 12.72           C  
ATOM   3137  C   THR B 182      64.888  31.117  72.529  1.00  8.20           C  
ATOM   3138  O   THR B 182      63.849  31.072  71.868  1.00 13.24           O  
ATOM   3139  CB  THR B 182      67.109  31.565  71.529  1.00 14.77           C  
ATOM   3140  OG1 THR B 182      68.119  32.553  71.267  1.00 12.70           O  
ATOM   3141  CG2 THR B 182      66.622  30.979  70.223  1.00 11.07           C  
ATOM   3142  N   LYS B 183      65.141  30.282  73.529  1.00  9.31           N  
ATOM   3143  CA  LYS B 183      64.251  29.174  73.844  1.00  7.47           C  
ATOM   3144  C   LYS B 183      62.879  29.663  74.315  1.00 13.99           C  
ATOM   3145  O   LYS B 183      61.849  29.145  73.875  1.00 11.45           O  
ATOM   3146  CB  LYS B 183      64.891  28.269  74.902  1.00 12.31           C  
ATOM   3147  CG  LYS B 183      66.131  27.536  74.404  1.00  9.57           C  
ATOM   3148  CD  LYS B 183      66.797  26.731  75.500  1.00 11.42           C  
ATOM   3149  CE  LYS B 183      68.088  26.119  74.985  1.00 27.49           C  
ATOM   3150  NZ  LYS B 183      68.948  25.579  76.077  1.00 42.10           N  
ATOM   3151  N   SER B 184      62.872  30.731  75.112  1.00  8.60           N  
ATOM   3152  CA  SER B 184      61.646  31.256  75.721  1.00  8.42           C  
ATOM   3153  C   SER B 184      60.714  31.879  74.688  1.00  7.25           C  
ATOM   3154  O   SER B 184      59.504  31.646  74.711  1.00 10.79           O  
ATOM   3155  CB  SER B 184      61.994  32.303  76.785  1.00 10.09           C  
ATOM   3156  OG  SER B 184      62.669  31.722  77.887  1.00 14.97           O  
ATOM   3157  N   LEU B 185      61.276  32.722  73.824  1.00 11.72           N  
ATOM   3158  CA  LEU B 185      60.518  33.356  72.751  1.00 10.94           C  
ATOM   3159  C   LEU B 185      60.002  32.316  71.768  1.00 11.04           C  
ATOM   3160  O   LEU B 185      58.860  32.404  71.311  1.00 17.04           O  
ATOM   3161  CB  LEU B 185      61.382  34.379  72.008  1.00  8.09           C  
ATOM   3162  CG  LEU B 185      61.870  35.591  72.805  1.00  5.67           C  
ATOM   3163  CD1 LEU B 185      62.523  36.594  71.867  1.00  2.00           C  
ATOM   3164  CD2 LEU B 185      60.697  36.221  73.538  1.00  3.24           C  
ATOM   3165  N   ALA B 186      60.828  31.309  71.482  1.00 15.92           N  
ATOM   3166  CA  ALA B 186      60.432  30.200  70.602  1.00 13.44           C  
ATOM   3167  C   ALA B 186      59.177  29.476  71.099  1.00 12.24           C  
ATOM   3168  O   ALA B 186      58.257  29.211  70.323  1.00 15.26           O  
ATOM   3169  CB  ALA B 186      61.584  29.205  70.448  1.00  2.00           C  
ATOM   3170  N   CYS B 187      59.109  29.237  72.409  1.00 10.69           N  
ATOM   3171  CA  CYS B 187      57.974  28.543  73.003  1.00  8.25           C  
ATOM   3172  C   CYS B 187      56.768  29.453  73.177  1.00 11.22           C  
ATOM   3173  O   CYS B 187      55.639  29.026  72.970  1.00 12.70           O  
ATOM   3174  CB  CYS B 187      58.367  27.942  74.348  1.00  3.99           C  
ATOM   3175  SG  CYS B 187      59.586  26.628  74.213  1.00 16.82           S  
ATOM   3176  N   GLU B 188      57.004  30.717  73.516  1.00 14.00           N  
ATOM   3177  CA  GLU B 188      55.908  31.642  73.768  1.00  8.56           C  
ATOM   3178  C   GLU B 188      55.232  32.147  72.500  1.00 11.83           C  
ATOM   3179  O   GLU B 188      54.057  32.507  72.521  1.00 18.21           O  
ATOM   3180  CB  GLU B 188      56.403  32.831  74.580  1.00 15.02           C  
ATOM   3181  CG  GLU B 188      56.555  32.544  76.056  1.00 19.01           C  
ATOM   3182  CD  GLU B 188      56.813  33.792  76.857  1.00 22.27           C  
ATOM   3183  OE1 GLU B 188      56.318  34.868  76.462  1.00 20.42           O  
ATOM   3184  OE2 GLU B 188      57.521  33.703  77.877  1.00 20.13           O  
ATOM   3185  N   TRP B 189      55.982  32.205  71.403  1.00 12.80           N  
ATOM   3186  CA  TRP B 189      55.501  32.868  70.192  1.00 15.08           C  
ATOM   3187  C   TRP B 189      55.167  31.918  69.041  1.00 19.73           C  
ATOM   3188  O   TRP B 189      54.623  32.348  68.023  1.00 26.52           O  
ATOM   3189  CB  TRP B 189      56.528  33.904  69.722  1.00 15.01           C  
ATOM   3190  CG  TRP B 189      56.680  35.083  70.648  1.00 10.49           C  
ATOM   3191  CD1 TRP B 189      55.932  35.357  71.764  1.00 15.32           C  
ATOM   3192  CD2 TRP B 189      57.575  36.188  70.488  1.00  8.30           C  
ATOM   3193  NE1 TRP B 189      56.301  36.562  72.298  1.00 13.62           N  
ATOM   3194  CE2 TRP B 189      57.303  37.099  71.533  1.00 11.02           C  
ATOM   3195  CE3 TRP B 189      58.555  36.515  69.541  1.00 10.91           C  
ATOM   3196  CZ2 TRP B 189      57.973  38.322  71.654  1.00 10.79           C  
ATOM   3197  CZ3 TRP B 189      59.218  37.735  69.661  1.00 17.09           C  
ATOM   3198  CH2 TRP B 189      58.919  38.624  70.709  1.00  7.23           C  
ATOM   3199  N   ALA B 190      55.421  30.623  69.229  1.00 15.16           N  
ATOM   3200  CA  ALA B 190      55.253  29.637  68.162  1.00 13.54           C  
ATOM   3201  C   ALA B 190      53.827  29.630  67.628  1.00 13.86           C  
ATOM   3202  O   ALA B 190      53.607  29.535  66.420  1.00 23.24           O  
ATOM   3203  CB  ALA B 190      55.634  28.249  68.670  1.00  8.53           C  
ATOM   3204  N   LYS B 191      52.869  29.826  68.529  1.00 16.48           N  
ATOM   3205  CA  LYS B 191      51.450  29.869  68.175  1.00 23.52           C  
ATOM   3206  C   LYS B 191      51.114  31.099  67.339  1.00 22.63           C  
ATOM   3207  O   LYS B 191      50.050  31.170  66.727  1.00 29.46           O  
ATOM   3208  CB  LYS B 191      50.587  29.877  69.442  1.00 37.20           C  
ATOM   3209  CG  LYS B 191      50.703  31.164  70.281  1.00 53.67           C  
ATOM   3210  CD  LYS B 191      49.546  31.320  71.273  1.00 62.22           C  
ATOM   3211  CE  LYS B 191      48.780  32.630  71.066  1.00 74.05           C  
ATOM   3212  NZ  LYS B 191      49.473  33.822  71.649  1.00 80.16           N  
ATOM   3213  N   ASP B 192      51.980  32.105  67.412  1.00 23.42           N  
ATOM   3214  CA  ASP B 192      51.791  33.358  66.697  1.00 22.28           C  
ATOM   3215  C   ASP B 192      52.429  33.329  65.313  1.00 18.87           C  
ATOM   3216  O   ASP B 192      52.473  34.348  64.623  1.00 16.39           O  
ATOM   3217  CB  ASP B 192      52.373  34.509  67.516  1.00 28.07           C  
ATOM   3218  CG  ASP B 192      51.629  34.731  68.817  1.00 34.79           C  
ATOM   3219  OD1 ASP B 192      50.381  34.752  68.787  1.00 38.77           O  
ATOM   3220  OD2 ASP B 192      52.288  34.885  69.870  1.00 36.50           O  
ATOM   3221  N   ASN B 193      52.918  32.152  64.921  1.00 19.08           N  
ATOM   3222  CA  ASN B 193      53.616  31.953  63.653  1.00 23.95           C  
ATOM   3223  C   ASN B 193      54.936  32.709  63.568  1.00 20.98           C  
ATOM   3224  O   ASN B 193      55.302  33.212  62.508  1.00 38.41           O  
ATOM   3225  CB  ASN B 193      52.716  32.346  62.474  1.00 34.18           C  
ATOM   3226  CG  ASN B 193      51.682  31.288  62.149  1.00 46.89           C  
ATOM   3227  OD1 ASN B 193      51.625  30.234  62.787  1.00 55.75           O  
ATOM   3228  ND2 ASN B 193      50.865  31.557  61.137  1.00 57.30           N  
ATOM   3229  N   ILE B 194      55.637  32.812  64.692  1.00 17.22           N  
ATOM   3230  CA  ILE B 194      56.982  33.372  64.703  1.00  8.15           C  
ATOM   3231  C   ILE B 194      57.970  32.309  65.186  1.00 12.45           C  
ATOM   3232  O   ILE B 194      57.785  31.722  66.253  1.00 11.19           O  
ATOM   3233  CB  ILE B 194      57.081  34.592  65.637  1.00  2.71           C  
ATOM   3234  CG1 ILE B 194      56.000  35.615  65.291  1.00 10.78           C  
ATOM   3235  CG2 ILE B 194      58.446  35.217  65.513  1.00 13.95           C  
ATOM   3236  CD1 ILE B 194      55.652  36.567  66.420  1.00  7.50           C  
ATOM   3237  N   ARG B 195      58.991  32.043  64.376  1.00 10.21           N  
ATOM   3238  CA  ARG B 195      60.061  31.125  64.749  1.00  9.78           C  
ATOM   3239  C   ARG B 195      61.281  31.896  65.252  1.00  8.55           C  
ATOM   3240  O   ARG B 195      61.551  33.007  64.812  1.00 12.07           O  
ATOM   3241  CB  ARG B 195      60.430  30.251  63.546  1.00  5.06           C  
ATOM   3242  CG  ARG B 195      59.258  29.403  63.026  1.00  6.12           C  
ATOM   3243  CD  ARG B 195      59.699  28.438  61.942  1.00  5.32           C  
ATOM   3244  NE  ARG B 195      60.023  29.120  60.685  1.00 13.92           N  
ATOM   3245  CZ  ARG B 195      61.246  29.225  60.167  1.00 17.07           C  
ATOM   3246  NH1 ARG B 195      62.311  28.798  60.843  1.00 12.20           N  
ATOM   3247  NH2 ARG B 195      61.412  29.803  58.979  1.00 12.97           N  
ATOM   3248  N   VAL B 196      61.989  31.323  66.214  1.00 11.67           N  
ATOM   3249  CA  VAL B 196      63.059  32.038  66.896  1.00  7.00           C  
ATOM   3250  C   VAL B 196      64.258  31.106  67.027  1.00 10.11           C  
ATOM   3251  O   VAL B 196      64.156  30.038  67.619  1.00 15.25           O  
ATOM   3252  CB  VAL B 196      62.610  32.515  68.315  1.00 10.76           C  
ATOM   3253  CG1 VAL B 196      63.668  33.412  68.936  1.00  3.52           C  
ATOM   3254  CG2 VAL B 196      61.282  33.262  68.235  1.00  2.00           C  
ATOM   3255  N   ASN B 197      65.394  31.524  66.472  1.00 12.04           N  
ATOM   3256  CA  ASN B 197      66.624  30.730  66.483  1.00  7.67           C  
ATOM   3257  C   ASN B 197      67.843  31.624  66.692  1.00  4.68           C  
ATOM   3258  O   ASN B 197      67.767  32.827  66.478  1.00 14.34           O  
ATOM   3259  CB  ASN B 197      66.778  29.983  65.156  1.00  8.73           C  
ATOM   3260  CG  ASN B 197      65.676  28.978  64.930  1.00  5.69           C  
ATOM   3261  OD1 ASN B 197      64.743  29.222  64.164  1.00  8.65           O  
ATOM   3262  ND2 ASN B 197      65.748  27.858  65.639  1.00  7.60           N  
ATOM   3263  N   SER B 198      68.960  31.042  67.119  1.00  5.67           N  
ATOM   3264  CA  SER B 198      70.231  31.766  67.155  1.00  6.75           C  
ATOM   3265  C   SER B 198      71.247  31.067  66.282  1.00 10.26           C  
ATOM   3266  O   SER B 198      71.224  29.839  66.154  1.00 10.82           O  
ATOM   3267  CB  SER B 198      70.793  31.862  68.574  1.00  2.00           C  
ATOM   3268  OG  SER B 198      69.999  32.711  69.379  1.00 15.86           O  
ATOM   3269  N   VAL B 199      72.047  31.878  65.595  1.00 14.09           N  
ATOM   3270  CA  VAL B 199      73.225  31.414  64.879  1.00  9.80           C  
ATOM   3271  C   VAL B 199      74.441  31.864  65.674  1.00  6.85           C  
ATOM   3272  O   VAL B 199      74.529  33.007  66.097  1.00  9.89           O  
ATOM   3273  CB  VAL B 199      73.263  32.006  63.458  1.00 14.49           C  
ATOM   3274  CG1 VAL B 199      74.555  31.612  62.739  1.00  3.42           C  
ATOM   3275  CG2 VAL B 199      72.044  31.521  62.680  1.00 15.99           C  
ATOM   3276  N   ALA B 200      75.313  30.917  65.986  1.00 15.94           N  
ATOM   3277  CA  ALA B 200      76.425  31.157  66.882  1.00  6.55           C  
ATOM   3278  C   ALA B 200      77.747  30.881  66.172  1.00 16.52           C  
ATOM   3279  O   ALA B 200      78.143  29.728  66.000  1.00 17.31           O  
ATOM   3280  CB  ALA B 200      76.289  30.286  68.105  1.00  8.58           C  
ATOM   3281  N   PRO B 201      78.406  31.944  65.672  1.00 17.03           N  
ATOM   3282  CA  PRO B 201      79.593  31.807  64.819  1.00  9.80           C  
ATOM   3283  C   PRO B 201      80.851  31.362  65.564  1.00 12.78           C  
ATOM   3284  O   PRO B 201      80.962  31.553  66.777  1.00 19.99           O  
ATOM   3285  CB  PRO B 201      79.772  33.211  64.222  1.00 16.23           C  
ATOM   3286  CG  PRO B 201      78.419  33.864  64.355  1.00  4.14           C  
ATOM   3287  CD  PRO B 201      77.863  33.317  65.636  1.00  7.29           C  
ATOM   3288  N   GLY B 202      81.799  30.777  64.830  1.00  6.97           N  
ATOM   3289  CA  GLY B 202      83.170  30.715  65.305  1.00  9.39           C  
ATOM   3290  C   GLY B 202      83.910  32.010  65.012  1.00  9.02           C  
ATOM   3291  O   GLY B 202      83.294  33.067  64.888  1.00 15.95           O  
ATOM   3292  N   VAL B 203      85.232  31.947  64.916  1.00 12.10           N  
ATOM   3293  CA  VAL B 203      86.023  33.120  64.558  1.00  9.27           C  
ATOM   3294  C   VAL B 203      85.731  33.542  63.121  1.00 14.15           C  
ATOM   3295  O   VAL B 203      86.105  32.858  62.169  1.00 16.49           O  
ATOM   3296  CB  VAL B 203      87.539  32.839  64.702  1.00 16.94           C  
ATOM   3297  CG1 VAL B 203      88.361  34.003  64.136  1.00  9.30           C  
ATOM   3298  CG2 VAL B 203      87.880  32.594  66.165  1.00 15.98           C  
ATOM   3299  N   ILE B 204      85.000  34.637  62.976  1.00 10.60           N  
ATOM   3300  CA  ILE B 204      84.823  35.274  61.682  1.00 12.61           C  
ATOM   3301  C   ILE B 204      85.680  36.538  61.648  1.00 24.78           C  
ATOM   3302  O   ILE B 204      85.581  37.394  62.542  1.00 20.58           O  
ATOM   3303  CB  ILE B 204      83.340  35.660  61.426  1.00 15.47           C  
ATOM   3304  CG1 ILE B 204      82.397  34.525  61.852  1.00 11.74           C  
ATOM   3305  CG2 ILE B 204      83.143  36.004  59.958  1.00 10.99           C  
ATOM   3306  CD1 ILE B 204      82.615  33.195  61.141  1.00 10.11           C  
ATOM   3307  N   LEU B 205      86.531  36.640  60.626  1.00 22.26           N  
ATOM   3308  CA  LEU B 205      87.419  37.786  60.445  1.00 29.43           C  
ATOM   3309  C   LEU B 205      86.703  39.077  60.035  1.00 35.37           C  
ATOM   3310  O   LEU B 205      86.504  39.352  58.851  1.00 44.06           O  
ATOM   3311  CB  LEU B 205      88.487  37.455  59.410  1.00 41.47           C  
ATOM   3312  CG  LEU B 205      89.691  36.685  59.942  1.00 53.99           C  
ATOM   3313  CD1 LEU B 205      90.437  36.069  58.773  1.00 59.88           C  
ATOM   3314  CD2 LEU B 205      90.595  37.615  60.748  1.00 55.35           C  
ATOM   3315  N   THR B 206      86.388  39.898  61.030  1.00 25.77           N  
ATOM   3316  CA  THR B 206      85.671  41.138  60.811  1.00 14.62           C  
ATOM   3317  C   THR B 206      86.442  42.257  61.505  1.00 21.18           C  
ATOM   3318  O   THR B 206      87.418  41.997  62.214  1.00 20.29           O  
ATOM   3319  CB  THR B 206      84.261  41.056  61.413  1.00 15.27           C  
ATOM   3320  OG1 THR B 206      84.373  40.851  62.821  1.00 10.09           O  
ATOM   3321  CG2 THR B 206      83.457  39.909  60.794  1.00  6.38           C  
ATOM   3322  N   PRO B 207      85.983  43.513  61.354  1.00 20.22           N  
ATOM   3323  CA  PRO B 207      86.459  44.632  62.168  1.00 21.10           C  
ATOM   3324  C   PRO B 207      86.534  44.345  63.663  1.00 21.81           C  
ATOM   3325  O   PRO B 207      87.510  44.719  64.307  1.00 30.10           O  
ATOM   3326  CB  PRO B 207      85.461  45.739  61.845  1.00 11.43           C  
ATOM   3327  CG  PRO B 207      85.179  45.514  60.416  1.00 10.30           C  
ATOM   3328  CD  PRO B 207      85.157  44.001  60.235  1.00 21.43           C  
ATOM   3329  N   LEU B 208      85.560  43.605  64.190  1.00 22.83           N  
ATOM   3330  CA  LEU B 208      85.488  43.329  65.625  1.00 20.21           C  
ATOM   3331  C   LEU B 208      86.751  42.624  66.110  1.00 22.56           C  
ATOM   3332  O   LEU B 208      87.289  42.965  67.169  1.00 31.03           O  
ATOM   3333  CB  LEU B 208      84.243  42.483  65.947  1.00 23.82           C  
ATOM   3334  CG  LEU B 208      83.904  42.193  67.415  1.00 19.22           C  
ATOM   3335  CD1 LEU B 208      82.424  42.341  67.646  1.00 18.39           C  
ATOM   3336  CD2 LEU B 208      84.332  40.794  67.776  1.00 11.44           C  
ATOM   3337  N   VAL B 209      87.292  41.740  65.274  1.00 24.17           N  
ATOM   3338  CA  VAL B 209      88.494  40.992  65.634  1.00 29.73           C  
ATOM   3339  C   VAL B 209      89.770  41.716  65.212  1.00 33.61           C  
ATOM   3340  O   VAL B 209      90.775  41.669  65.924  1.00 44.61           O  
ATOM   3341  CB  VAL B 209      88.487  39.537  65.043  1.00 23.73           C  
ATOM   3342  CG1 VAL B 209      87.068  38.981  65.007  1.00 23.72           C  
ATOM   3343  CG2 VAL B 209      89.102  39.500  63.664  1.00 30.62           C  
ATOM   3344  N   GLU B 210      89.705  42.445  64.098  1.00 29.84           N  
ATOM   3345  CA  GLU B 210      90.874  43.128  63.558  1.00 28.90           C  
ATOM   3346  C   GLU B 210      91.266  44.305  64.440  1.00 27.09           C  
ATOM   3347  O   GLU B 210      92.444  44.550  64.675  1.00 27.59           O  
ATOM   3348  CB  GLU B 210      90.591  43.625  62.147  1.00 40.92           C  
ATOM   3349  CG  GLU B 210      90.399  42.518  61.127  1.00 64.23           C  
ATOM   3350  CD  GLU B 210      90.182  43.047  59.719  1.00 79.39           C  
ATOM   3351  OE1 GLU B 210      89.884  44.254  59.561  1.00 82.11           O  
ATOM   3352  OE2 GLU B 210      90.316  42.248  58.765  1.00 88.68           O  
ATOM   3353  N   THR B 211      90.266  45.038  64.912  1.00 21.77           N  
ATOM   3354  CA  THR B 211      90.472  46.117  65.863  1.00 20.80           C  
ATOM   3355  C   THR B 211      91.046  45.582  67.179  1.00 25.34           C  
ATOM   3356  O   THR B 211      92.016  46.128  67.712  1.00 34.12           O  
ATOM   3357  CB  THR B 211      89.140  46.854  66.130  1.00 24.82           C  
ATOM   3358  OG1 THR B 211      88.673  47.445  64.910  1.00 27.13           O  
ATOM   3359  CG2 THR B 211      89.316  47.941  67.183  1.00 22.53           C  
ATOM   3360  N   ALA B 212      90.498  44.469  67.653  1.00 26.13           N  
ATOM   3361  CA  ALA B 212      90.923  43.883  68.914  1.00 14.95           C  
ATOM   3362  C   ALA B 212      92.369  43.393  68.849  1.00 22.10           C  
ATOM   3363  O   ALA B 212      93.144  43.614  69.784  1.00 23.72           O  
ATOM   3364  CB  ALA B 212      89.996  42.746  69.292  1.00 21.02           C  
ATOM   3365  N   ILE B 213      92.757  42.786  67.730  1.00 19.75           N  
ATOM   3366  CA  ILE B 213      94.100  42.221  67.640  1.00 24.49           C  
ATOM   3367  C   ILE B 213      95.144  43.278  67.276  1.00 29.69           C  
ATOM   3368  O   ILE B 213      96.299  43.184  67.689  1.00 34.74           O  
ATOM   3369  CB  ILE B 213      94.173  40.998  66.663  1.00 22.72           C  
ATOM   3370  CG1 ILE B 213      93.973  41.419  65.213  1.00 33.27           C  
ATOM   3371  CG2 ILE B 213      93.114  39.978  67.022  1.00 37.11           C  
ATOM   3372  CD1 ILE B 213      94.081  40.272  64.236  1.00 24.95           C  
ATOM   3373  N   LYS B 214      94.691  44.369  66.667  1.00 31.06           N  
ATOM   3374  CA  LYS B 214      95.550  45.526  66.432  1.00 31.82           C  
ATOM   3375  C   LYS B 214      95.885  46.208  67.760  1.00 23.73           C  
ATOM   3376  O   LYS B 214      97.033  46.563  68.006  1.00 24.13           O  
ATOM   3377  CB  LYS B 214      94.850  46.522  65.500  1.00 29.97           C  
ATOM   3378  CG  LYS B 214      95.660  46.910  64.274  1.00 45.55           C  
ATOM   3379  CD  LYS B 214      94.973  46.460  62.987  1.00 60.50           C  
ATOM   3380  CE  LYS B 214      95.456  45.082  62.538  1.00 73.30           C  
ATOM   3381  NZ  LYS B 214      94.724  44.574  61.337  1.00 73.81           N  
ATOM   3382  N   LYS B 215      94.887  46.288  68.637  1.00 22.21           N  
ATOM   3383  CA  LYS B 215      94.967  47.012  69.911  1.00 17.17           C  
ATOM   3384  C   LYS B 215      95.951  46.330  70.864  1.00 23.99           C  
ATOM   3385  O   LYS B 215      96.772  46.983  71.513  1.00 28.56           O  
ATOM   3386  CB  LYS B 215      93.569  47.048  70.546  1.00 15.97           C  
ATOM   3387  CG  LYS B 215      93.412  47.929  71.782  1.00 26.36           C  
ATOM   3388  CD  LYS B 215      92.224  47.471  72.650  1.00 27.45           C  
ATOM   3389  CE  LYS B 215      91.092  48.504  72.698  1.00 35.44           C  
ATOM   3390  NZ  LYS B 215      90.950  49.171  74.037  1.00 41.99           N  
ATOM   3391  N   ASN B 216      95.908  45.003  70.870  1.00 27.39           N  
ATOM   3392  CA  ASN B 216      96.573  44.204  71.883  1.00 21.77           C  
ATOM   3393  C   ASN B 216      96.985  42.906  71.208  1.00 18.94           C  
ATOM   3394  O   ASN B 216      96.139  42.162  70.718  1.00 20.43           O  
ATOM   3395  CB  ASN B 216      95.601  43.904  73.032  1.00 23.38           C  
ATOM   3396  CG  ASN B 216      96.309  43.510  74.329  1.00 26.12           C  
ATOM   3397  OD1 ASN B 216      95.799  43.760  75.420  1.00 38.84           O  
ATOM   3398  ND2 ASN B 216      97.456  42.855  74.213  1.00 25.28           N  
ATOM   3399  N   PRO B 217      98.293  42.627  71.165  1.00 19.09           N  
ATOM   3400  CA  PRO B 217      98.813  41.385  70.582  1.00 23.07           C  
ATOM   3401  C   PRO B 217      98.556  40.119  71.407  1.00 24.16           C  
ATOM   3402  O   PRO B 217      98.800  39.006  70.936  1.00 25.22           O  
ATOM   3403  CB  PRO B 217     100.307  41.667  70.409  1.00 22.95           C  
ATOM   3404  CG  PRO B 217     100.598  42.767  71.364  1.00 25.30           C  
ATOM   3405  CD  PRO B 217      99.365  43.607  71.409  1.00 22.78           C  
ATOM   3406  N   HIS B 218      98.046  40.286  72.625  1.00 18.69           N  
ATOM   3407  CA  HIS B 218      97.553  39.152  73.403  1.00 19.81           C  
ATOM   3408  C   HIS B 218      96.254  38.632  72.795  1.00 16.97           C  
ATOM   3409  O   HIS B 218      95.986  37.439  72.834  1.00 19.15           O  
ATOM   3410  CB  HIS B 218      97.292  39.549  74.861  1.00 30.09           C  
ATOM   3411  CG  HIS B 218      98.531  39.684  75.696  1.00 43.84           C  
ATOM   3412  ND1 HIS B 218      99.530  38.732  75.715  1.00 53.75           N  
ATOM   3413  CD2 HIS B 218      98.887  40.618  76.612  1.00 43.84           C  
ATOM   3414  CE1 HIS B 218     100.443  39.073  76.606  1.00 55.96           C  
ATOM   3415  NE2 HIS B 218     100.077  40.213  77.164  1.00 45.31           N  
ATOM   3416  N   GLN B 219      95.436  39.532  72.255  1.00  7.51           N  
ATOM   3417  CA  GLN B 219      94.233  39.112  71.548  1.00 14.41           C  
ATOM   3418  C   GLN B 219      94.561  38.444  70.228  1.00 13.55           C  
ATOM   3419  O   GLN B 219      93.889  37.495  69.836  1.00 24.58           O  
ATOM   3420  CB  GLN B 219      93.288  40.290  71.311  1.00 17.17           C  
ATOM   3421  CG  GLN B 219      92.271  40.480  72.421  1.00 19.49           C  
ATOM   3422  CD  GLN B 219      92.893  41.023  73.696  1.00 23.48           C  
ATOM   3423  OE1 GLN B 219      93.532  40.293  74.450  1.00 25.01           O  
ATOM   3424  NE2 GLN B 219      92.611  42.283  73.992  1.00 25.85           N  
ATOM   3425  N   LYS B 220      95.648  38.871  69.591  1.00 14.92           N  
ATOM   3426  CA  LYS B 220      96.151  38.172  68.413  1.00 20.82           C  
ATOM   3427  C   LYS B 220      96.430  36.715  68.767  1.00 21.62           C  
ATOM   3428  O   LYS B 220      95.886  35.813  68.145  1.00 22.81           O  
ATOM   3429  CB  LYS B 220      97.426  38.837  67.898  1.00 22.59           C  
ATOM   3430  CG  LYS B 220      98.020  38.160  66.678  1.00 36.63           C  
ATOM   3431  CD  LYS B 220      97.137  38.355  65.454  1.00 54.53           C  
ATOM   3432  CE  LYS B 220      97.455  37.342  64.359  1.00 68.06           C  
ATOM   3433  NZ  LYS B 220      98.904  37.304  63.994  1.00 72.34           N  
ATOM   3434  N   GLU B 221      97.182  36.509  69.844  1.00 26.04           N  
ATOM   3435  CA  GLU B 221      97.466  35.178  70.383  1.00 30.83           C  
ATOM   3436  C   GLU B 221      96.212  34.323  70.497  1.00 31.53           C  
ATOM   3437  O   GLU B 221      96.155  33.204  69.987  1.00 33.57           O  
ATOM   3438  CB  GLU B 221      98.062  35.295  71.783  1.00 36.21           C  
ATOM   3439  CG  GLU B 221      99.562  35.391  71.854  1.00 57.35           C  
ATOM   3440  CD  GLU B 221     100.038  35.493  73.291  1.00 78.21           C  
ATOM   3441  OE1 GLU B 221      99.795  34.540  74.066  1.00 85.29           O  
ATOM   3442  OE2 GLU B 221     100.591  36.550  73.665  1.00 91.05           O  
ATOM   3443  N   GLU B 222      95.259  34.820  71.274  1.00 25.71           N  
ATOM   3444  CA  GLU B 222      94.065  34.070  71.611  1.00 24.87           C  
ATOM   3445  C   GLU B 222      93.292  33.656  70.363  1.00 27.47           C  
ATOM   3446  O   GLU B 222      92.873  32.506  70.237  1.00 24.12           O  
ATOM   3447  CB  GLU B 222      93.182  34.908  72.536  1.00 23.47           C  
ATOM   3448  CG  GLU B 222      93.771  35.100  73.923  1.00 10.22           C  
ATOM   3449  CD  GLU B 222      93.047  36.153  74.745  1.00 13.63           C  
ATOM   3450  OE1 GLU B 222      91.965  36.617  74.331  1.00 27.19           O  
ATOM   3451  OE2 GLU B 222      93.572  36.530  75.812  1.00 33.94           O  
ATOM   3452  N   ILE B 223      93.186  34.578  69.410  1.00 23.37           N  
ATOM   3453  CA  ILE B 223      92.460  34.330  68.168  1.00 28.39           C  
ATOM   3454  C   ILE B 223      93.138  33.234  67.331  1.00 23.51           C  
ATOM   3455  O   ILE B 223      92.488  32.299  66.863  1.00 21.69           O  
ATOM   3456  CB  ILE B 223      92.338  35.637  67.328  1.00 31.01           C  
ATOM   3457  CG1 ILE B 223      91.546  36.695  68.109  1.00 27.58           C  
ATOM   3458  CG2 ILE B 223      91.685  35.349  65.973  1.00 29.43           C  
ATOM   3459  CD1 ILE B 223      90.071  36.425  68.211  1.00 14.48           C  
ATOM   3460  N   ASP B 224      94.456  33.311  67.216  1.00 18.45           N  
ATOM   3461  CA  ASP B 224      95.207  32.318  66.468  1.00 21.69           C  
ATOM   3462  C   ASP B 224      95.014  30.935  67.057  1.00 21.15           C  
ATOM   3463  O   ASP B 224      94.893  29.953  66.330  1.00 30.45           O  
ATOM   3464  CB  ASP B 224      96.693  32.670  66.462  1.00 23.40           C  
ATOM   3465  CG  ASP B 224      97.032  33.759  65.464  1.00 31.03           C  
ATOM   3466  OD1 ASP B 224      96.168  34.116  64.629  1.00 38.73           O  
ATOM   3467  OD2 ASP B 224      98.176  34.257  65.519  1.00 35.25           O  
ATOM   3468  N   ASN B 225      94.880  30.877  68.374  1.00 23.36           N  
ATOM   3469  CA  ASN B 225      94.719  29.606  69.048  1.00 17.05           C  
ATOM   3470  C   ASN B 225      93.290  29.092  69.018  1.00 11.30           C  
ATOM   3471  O   ASN B 225      93.067  27.895  69.131  1.00 19.23           O  
ATOM   3472  CB  ASN B 225      95.249  29.713  70.471  1.00 31.60           C  
ATOM   3473  CG  ASN B 225      96.753  29.987  70.505  1.00 58.91           C  
ATOM   3474  OD1 ASN B 225      97.226  30.842  71.260  1.00 67.88           O  
ATOM   3475  ND2 ASN B 225      97.503  29.306  69.633  1.00 62.80           N  
ATOM   3476  N   PHE B 226      92.344  29.971  68.699  1.00 14.87           N  
ATOM   3477  CA  PHE B 226      90.971  29.560  68.436  1.00 10.40           C  
ATOM   3478  C   PHE B 226      90.902  28.911  67.056  1.00 15.26           C  
ATOM   3479  O   PHE B 226      90.101  28.004  66.823  1.00 15.61           O  
ATOM   3480  CB  PHE B 226      90.024  30.762  68.470  1.00 13.60           C  
ATOM   3481  CG  PHE B 226      89.968  31.471  69.797  1.00 17.47           C  
ATOM   3482  CD1 PHE B 226      90.523  30.903  70.943  1.00 16.80           C  
ATOM   3483  CD2 PHE B 226      89.362  32.722  69.891  1.00 13.78           C  
ATOM   3484  CE1 PHE B 226      90.476  31.572  72.165  1.00  7.19           C  
ATOM   3485  CE2 PHE B 226      89.312  33.399  71.105  1.00  9.61           C  
ATOM   3486  CZ  PHE B 226      89.870  32.821  72.244  1.00  9.91           C  
ATOM   3487  N   ILE B 227      91.717  29.414  66.133  1.00 12.80           N  
ATOM   3488  CA  ILE B 227      91.740  28.916  64.761  1.00 14.78           C  
ATOM   3489  C   ILE B 227      92.447  27.564  64.652  1.00 16.34           C  
ATOM   3490  O   ILE B 227      92.035  26.703  63.871  1.00 21.40           O  
ATOM   3491  CB  ILE B 227      92.418  29.937  63.824  1.00 13.42           C  
ATOM   3492  CG1 ILE B 227      91.506  31.153  63.648  1.00 10.77           C  
ATOM   3493  CG2 ILE B 227      92.718  29.310  62.471  1.00 16.96           C  
ATOM   3494  CD1 ILE B 227      92.190  32.335  63.019  1.00 10.26           C  
ATOM   3495  N   VAL B 228      93.470  27.356  65.475  1.00 13.82           N  
ATOM   3496  CA  VAL B 228      94.185  26.086  65.485  1.00 17.60           C  
ATOM   3497  C   VAL B 228      93.330  25.014  66.159  1.00 21.32           C  
ATOM   3498  O   VAL B 228      93.398  23.834  65.798  1.00 28.78           O  
ATOM   3499  CB  VAL B 228      95.582  26.198  66.192  1.00 21.64           C  
ATOM   3500  CG1 VAL B 228      96.309  27.450  65.726  1.00 19.68           C  
ATOM   3501  CG2 VAL B 228      95.443  26.200  67.708  1.00 29.93           C  
ATOM   3502  N   LYS B 229      92.464  25.457  67.071  1.00 20.14           N  
ATOM   3503  CA  LYS B 229      91.498  24.594  67.751  1.00 14.63           C  
ATOM   3504  C   LYS B 229      90.360  24.190  66.818  1.00 13.45           C  
ATOM   3505  O   LYS B 229      89.624  23.245  67.100  1.00 22.93           O  
ATOM   3506  CB  LYS B 229      90.913  25.322  68.965  1.00 16.25           C  
ATOM   3507  CG  LYS B 229      91.078  24.586  70.284  1.00 29.96           C  
ATOM   3508  CD  LYS B 229      89.832  24.720  71.159  1.00 37.27           C  
ATOM   3509  CE  LYS B 229      88.655  23.928  70.592  1.00 38.50           C  
ATOM   3510  NZ  LYS B 229      87.452  23.955  71.476  1.00 25.93           N  
ATOM   3511  N   THR B 230      90.168  24.970  65.759  1.00 15.20           N  
ATOM   3512  CA  THR B 230      89.081  24.757  64.812  1.00 12.96           C  
ATOM   3513  C   THR B 230      89.498  23.659  63.852  1.00 15.32           C  
ATOM   3514  O   THR B 230      90.510  23.794  63.168  1.00 21.58           O  
ATOM   3515  CB  THR B 230      88.797  26.048  64.028  1.00 15.96           C  
ATOM   3516  OG1 THR B 230      88.534  27.110  64.952  1.00 18.44           O  
ATOM   3517  CG2 THR B 230      87.602  25.879  63.104  1.00  9.36           C  
ATOM   3518  N   PRO B 231      88.805  22.499  63.891  1.00 20.80           N  
ATOM   3519  CA  PRO B 231      89.162  21.334  63.071  1.00 16.36           C  
ATOM   3520  C   PRO B 231      89.400  21.685  61.606  1.00 21.63           C  
ATOM   3521  O   PRO B 231      90.311  21.140  60.971  1.00 24.07           O  
ATOM   3522  CB  PRO B 231      87.967  20.402  63.245  1.00 13.96           C  
ATOM   3523  CG  PRO B 231      87.499  20.686  64.624  1.00 19.20           C  
ATOM   3524  CD  PRO B 231      87.709  22.176  64.825  1.00 16.61           C  
ATOM   3525  N   MET B 232      88.626  22.649  61.098  1.00 21.65           N  
ATOM   3526  CA  MET B 232      88.789  23.138  59.728  1.00 18.14           C  
ATOM   3527  C   MET B 232      90.004  24.040  59.506  1.00 17.31           C  
ATOM   3528  O   MET B 232      90.375  24.297  58.363  1.00 22.95           O  
ATOM   3529  CB  MET B 232      87.516  23.842  59.257  1.00 11.11           C  
ATOM   3530  CG  MET B 232      86.510  22.886  58.618  1.00 14.47           C  
ATOM   3531  SD  MET B 232      85.122  23.758  57.904  1.00 25.88           S  
ATOM   3532  CE  MET B 232      83.880  22.608  58.105  1.00 22.24           C  
ATOM   3533  N   GLY B 233      90.580  24.552  60.595  1.00 22.76           N  
ATOM   3534  CA  GLY B 233      91.893  25.179  60.552  1.00 11.84           C  
ATOM   3535  C   GLY B 233      91.931  26.571  59.943  1.00 20.23           C  
ATOM   3536  O   GLY B 233      92.998  27.050  59.550  1.00 24.45           O  
ATOM   3537  N   ARG B 234      90.780  27.238  59.901  1.00 17.72           N  
ATOM   3538  CA  ARG B 234      90.660  28.550  59.267  1.00 14.30           C  
ATOM   3539  C   ARG B 234      89.514  29.302  59.909  1.00 16.12           C  
ATOM   3540  O   ARG B 234      88.628  28.692  60.502  1.00 18.51           O  
ATOM   3541  CB  ARG B 234      90.382  28.407  57.763  1.00 13.60           C  
ATOM   3542  CG  ARG B 234      89.086  27.664  57.426  1.00  8.15           C  
ATOM   3543  CD  ARG B 234      88.548  28.064  56.065  1.00 14.81           C  
ATOM   3544  NE  ARG B 234      87.363  27.299  55.680  1.00 14.64           N  
ATOM   3545  CZ  ARG B 234      86.157  27.829  55.496  1.00 19.84           C  
ATOM   3546  NH1 ARG B 234      85.934  29.102  55.791  1.00 10.90           N  
ATOM   3547  NH2 ARG B 234      85.159  27.065  55.075  1.00 11.39           N  
ATOM   3548  N   ALA B 235      89.517  30.621  59.760  1.00 20.23           N  
ATOM   3549  CA  ALA B 235      88.408  31.440  60.225  1.00 17.66           C  
ATOM   3550  C   ALA B 235      87.296  31.421  59.186  1.00 14.00           C  
ATOM   3551  O   ALA B 235      87.550  31.210  57.997  1.00 23.72           O  
ATOM   3552  CB  ALA B 235      88.876  32.865  60.473  1.00 19.95           C  
ATOM   3553  N   GLY B 236      86.061  31.579  59.651  1.00 13.59           N  
ATOM   3554  CA  GLY B 236      84.921  31.629  58.756  1.00 11.12           C  
ATOM   3555  C   GLY B 236      84.831  32.914  57.958  1.00 16.15           C  
ATOM   3556  O   GLY B 236      85.550  33.881  58.218  1.00 16.21           O  
ATOM   3557  N   LYS B 237      84.016  32.881  56.913  1.00 22.05           N  
ATOM   3558  CA  LYS B 237      83.717  34.061  56.116  1.00 17.04           C  
ATOM   3559  C   LYS B 237      82.308  34.477  56.505  1.00 18.28           C  
ATOM   3560  O   LYS B 237      81.469  33.619  56.785  1.00 17.79           O  
ATOM   3561  CB  LYS B 237      83.763  33.722  54.623  1.00 19.01           C  
ATOM   3562  CG  LYS B 237      85.142  33.342  54.104  1.00 34.83           C  
ATOM   3563  CD  LYS B 237      85.047  32.596  52.770  1.00 54.14           C  
ATOM   3564  CE  LYS B 237      85.464  31.125  52.905  1.00 64.40           C  
ATOM   3565  NZ  LYS B 237      85.219  30.300  51.676  1.00 63.80           N  
ATOM   3566  N   PRO B 238      82.038  35.800  56.558  1.00 18.96           N  
ATOM   3567  CA  PRO B 238      80.725  36.370  56.889  1.00  8.91           C  
ATOM   3568  C   PRO B 238      79.575  35.704  56.137  1.00 12.05           C  
ATOM   3569  O   PRO B 238      78.514  35.442  56.709  1.00 17.01           O  
ATOM   3570  CB  PRO B 238      80.866  37.837  56.497  1.00 15.19           C  
ATOM   3571  CG  PRO B 238      82.295  38.130  56.677  1.00  5.50           C  
ATOM   3572  CD  PRO B 238      83.031  36.861  56.295  1.00 10.12           C  
ATOM   3573  N   GLN B 239      79.811  35.401  54.864  1.00 16.10           N  
ATOM   3574  CA  GLN B 239      78.794  34.801  54.001  1.00 17.91           C  
ATOM   3575  C   GLN B 239      78.472  33.374  54.415  1.00 17.65           C  
ATOM   3576  O   GLN B 239      77.341  32.915  54.259  1.00 28.62           O  
ATOM   3577  CB  GLN B 239      79.242  34.830  52.532  1.00 21.24           C  
ATOM   3578  CG  GLN B 239      80.629  34.252  52.270  1.00 39.76           C  
ATOM   3579  CD  GLN B 239      81.683  35.323  52.010  1.00 44.19           C  
ATOM   3580  OE1 GLN B 239      81.660  36.403  52.605  1.00 37.25           O  
ATOM   3581  NE2 GLN B 239      82.633  35.008  51.143  1.00 52.04           N  
ATOM   3582  N   GLU B 240      79.445  32.704  55.025  1.00 17.98           N  
ATOM   3583  CA  GLU B 240      79.229  31.367  55.558  1.00  7.95           C  
ATOM   3584  C   GLU B 240      78.302  31.377  56.776  1.00 13.21           C  
ATOM   3585  O   GLU B 240      77.640  30.370  57.077  1.00  6.53           O  
ATOM   3586  CB  GLU B 240      80.568  30.727  55.903  1.00  5.62           C  
ATOM   3587  CG  GLU B 240      81.378  30.335  54.678  1.00  3.27           C  
ATOM   3588  CD  GLU B 240      82.698  29.670  55.027  1.00 15.92           C  
ATOM   3589  OE1 GLU B 240      83.476  30.249  55.811  1.00 14.54           O  
ATOM   3590  OE2 GLU B 240      82.993  28.597  54.464  1.00 14.46           O  
ATOM   3591  N   VAL B 241      78.160  32.553  57.388  1.00 13.24           N  
ATOM   3592  CA  VAL B 241      77.225  32.741  58.493  1.00  8.44           C  
ATOM   3593  C   VAL B 241      75.867  33.261  58.018  1.00  7.77           C  
ATOM   3594  O   VAL B 241      74.819  32.791  58.469  1.00 15.48           O  
ATOM   3595  CB  VAL B 241      77.817  33.689  59.559  1.00  2.00           C  
ATOM   3596  CG1 VAL B 241      76.788  33.987  60.632  1.00  6.74           C  
ATOM   3597  CG2 VAL B 241      79.029  33.050  60.194  1.00  3.48           C  
ATOM   3598  N   SER B 242      75.881  34.139  57.024  1.00  6.14           N  
ATOM   3599  CA  SER B 242      74.637  34.690  56.493  1.00  5.29           C  
ATOM   3600  C   SER B 242      73.841  33.649  55.713  1.00  7.87           C  
ATOM   3601  O   SER B 242      72.621  33.784  55.554  1.00  8.00           O  
ATOM   3602  CB  SER B 242      74.936  35.882  55.590  1.00  9.62           C  
ATOM   3603  OG  SER B 242      75.878  35.530  54.595  1.00 19.54           O  
ATOM   3604  N   ALA B 243      74.543  32.638  55.196  1.00  6.30           N  
ATOM   3605  CA  ALA B 243      73.922  31.555  54.430  1.00  9.41           C  
ATOM   3606  C   ALA B 243      72.964  30.739  55.291  1.00  7.25           C  
ATOM   3607  O   ALA B 243      71.842  30.456  54.872  1.00 20.49           O  
ATOM   3608  CB  ALA B 243      74.988  30.651  53.841  1.00  6.06           C  
ATOM   3609  N   LEU B 244      73.364  30.479  56.535  1.00  6.95           N  
ATOM   3610  CA  LEU B 244      72.521  29.771  57.500  1.00  9.18           C  
ATOM   3611  C   LEU B 244      71.397  30.653  58.028  1.00  7.35           C  
ATOM   3612  O   LEU B 244      70.292  30.181  58.286  1.00 19.88           O  
ATOM   3613  CB  LEU B 244      73.367  29.261  58.670  1.00 11.01           C  
ATOM   3614  CG  LEU B 244      72.682  28.541  59.842  1.00 11.43           C  
ATOM   3615  CD1 LEU B 244      71.828  27.374  59.360  1.00  3.98           C  
ATOM   3616  CD2 LEU B 244      73.758  28.052  60.793  1.00 12.82           C  
ATOM   3617  N   ILE B 245      71.706  31.924  58.249  1.00 13.60           N  
ATOM   3618  CA  ILE B 245      70.701  32.901  58.641  1.00 10.64           C  
ATOM   3619  C   ILE B 245      69.600  33.060  57.579  1.00  9.11           C  
ATOM   3620  O   ILE B 245      68.421  33.066  57.921  1.00 13.66           O  
ATOM   3621  CB  ILE B 245      71.371  34.251  58.945  1.00 14.01           C  
ATOM   3622  CG1 ILE B 245      72.311  34.073  60.139  1.00 11.01           C  
ATOM   3623  CG2 ILE B 245      70.316  35.354  59.160  1.00 11.92           C  
ATOM   3624  CD1 ILE B 245      72.475  35.308  60.978  1.00  9.60           C  
ATOM   3625  N   ALA B 246      69.981  33.047  56.299  1.00 15.09           N  
ATOM   3626  CA  ALA B 246      69.021  33.093  55.185  1.00 11.18           C  
ATOM   3627  C   ALA B 246      68.144  31.848  55.143  1.00  9.16           C  
ATOM   3628  O   ALA B 246      66.924  31.935  54.994  1.00 14.53           O  
ATOM   3629  CB  ALA B 246      69.762  33.237  53.867  1.00 11.98           C  
ATOM   3630  N   PHE B 247      68.776  30.689  55.296  1.00  6.80           N  
ATOM   3631  CA  PHE B 247      68.073  29.416  55.290  1.00  3.45           C  
ATOM   3632  C   PHE B 247      66.986  29.320  56.360  1.00 10.13           C  
ATOM   3633  O   PHE B 247      65.891  28.808  56.105  1.00 14.68           O  
ATOM   3634  CB  PHE B 247      69.069  28.270  55.463  1.00  7.95           C  
ATOM   3635  CG  PHE B 247      68.416  26.934  55.645  1.00 12.58           C  
ATOM   3636  CD1 PHE B 247      67.640  26.386  54.624  1.00  9.85           C  
ATOM   3637  CD2 PHE B 247      68.444  26.299  56.881  1.00 19.35           C  
ATOM   3638  CE1 PHE B 247      66.889  25.237  54.835  1.00 19.29           C  
ATOM   3639  CE2 PHE B 247      67.692  25.146  57.109  1.00 26.61           C  
ATOM   3640  CZ  PHE B 247      66.909  24.617  56.086  1.00 18.15           C  
ATOM   3641  N   LEU B 248      67.298  29.777  57.566  1.00  8.11           N  
ATOM   3642  CA  LEU B 248      66.371  29.663  58.683  1.00  9.12           C  
ATOM   3643  C   LEU B 248      65.108  30.499  58.488  1.00  7.34           C  
ATOM   3644  O   LEU B 248      64.102  30.286  59.165  1.00 11.55           O  
ATOM   3645  CB  LEU B 248      67.072  30.044  59.987  1.00  7.35           C  
ATOM   3646  CG  LEU B 248      68.148  29.059  60.467  1.00  6.79           C  
ATOM   3647  CD1 LEU B 248      68.910  29.672  61.620  1.00  5.50           C  
ATOM   3648  CD2 LEU B 248      67.516  27.737  60.899  1.00 10.79           C  
ATOM   3649  N   CYS B 249      65.153  31.410  57.519  1.00 13.55           N  
ATOM   3650  CA  CYS B 249      64.016  32.269  57.180  1.00 11.39           C  
ATOM   3651  C   CYS B 249      63.216  31.722  55.996  1.00 16.92           C  
ATOM   3652  O   CYS B 249      62.105  32.197  55.725  1.00 24.04           O  
ATOM   3653  CB  CYS B 249      64.491  33.689  56.853  1.00 16.57           C  
ATOM   3654  SG  CYS B 249      65.254  34.595  58.229  1.00 21.36           S  
ATOM   3655  N   PHE B 250      63.802  30.773  55.262  1.00 15.17           N  
ATOM   3656  CA  PHE B 250      63.082  30.064  54.201  1.00 11.45           C  
ATOM   3657  C   PHE B 250      61.875  29.375  54.821  1.00 11.82           C  
ATOM   3658  O   PHE B 250      61.936  28.904  55.959  1.00 19.08           O  
ATOM   3659  CB  PHE B 250      63.964  28.998  53.542  1.00 15.66           C  
ATOM   3660  CG  PHE B 250      65.070  29.548  52.684  1.00  7.87           C  
ATOM   3661  CD1 PHE B 250      65.081  30.882  52.288  1.00 12.06           C  
ATOM   3662  CD2 PHE B 250      66.104  28.720  52.271  1.00  6.18           C  
ATOM   3663  CE1 PHE B 250      66.110  31.377  51.497  1.00  6.30           C  
ATOM   3664  CE2 PHE B 250      67.136  29.207  51.484  1.00 12.02           C  
ATOM   3665  CZ  PHE B 250      67.139  30.542  51.097  1.00  8.08           C  
ATOM   3666  N   PRO B 251      60.750  29.338  54.098  1.00 10.84           N  
ATOM   3667  CA  PRO B 251      59.616  28.516  54.538  1.00 18.29           C  
ATOM   3668  C   PRO B 251      59.938  27.008  54.559  1.00 17.51           C  
ATOM   3669  O   PRO B 251      59.291  26.233  55.269  1.00 21.46           O  
ATOM   3670  CB  PRO B 251      58.515  28.865  53.534  1.00 20.86           C  
ATOM   3671  CG  PRO B 251      58.903  30.223  53.008  1.00 16.11           C  
ATOM   3672  CD  PRO B 251      60.402  30.177  52.938  1.00 14.68           C  
ATOM   3673  N   ALA B 252      60.980  26.618  53.825  1.00 18.80           N  
ATOM   3674  CA  ALA B 252      61.525  25.267  53.898  1.00 18.58           C  
ATOM   3675  C   ALA B 252      61.910  24.909  55.331  1.00 19.62           C  
ATOM   3676  O   ALA B 252      61.845  23.744  55.716  1.00 29.19           O  
ATOM   3677  CB  ALA B 252      62.740  25.146  52.990  1.00 12.12           C  
ATOM   3678  N   ALA B 253      62.261  25.922  56.122  1.00 13.12           N  
ATOM   3679  CA  ALA B 253      62.734  25.723  57.491  1.00  8.20           C  
ATOM   3680  C   ALA B 253      61.611  25.854  58.513  1.00 11.31           C  
ATOM   3681  O   ALA B 253      61.856  26.210  59.667  1.00  9.61           O  
ATOM   3682  CB  ALA B 253      63.830  26.727  57.801  1.00 12.77           C  
ATOM   3683  N   SER B 254      60.408  25.434  58.125  1.00 10.65           N  
ATOM   3684  CA  SER B 254      59.195  25.719  58.891  1.00 10.66           C  
ATOM   3685  C   SER B 254      58.953  24.905  60.183  1.00 17.68           C  
ATOM   3686  O   SER B 254      57.985  25.169  60.912  1.00 20.78           O  
ATOM   3687  CB  SER B 254      57.978  25.595  57.970  1.00  9.84           C  
ATOM   3688  OG  SER B 254      58.059  24.432  57.166  1.00  9.09           O  
ATOM   3689  N   TYR B 255      59.780  23.892  60.444  1.00 15.09           N  
ATOM   3690  CA  TYR B 255      59.636  23.111  61.674  1.00  9.10           C  
ATOM   3691  C   TYR B 255      60.796  23.377  62.625  1.00 11.26           C  
ATOM   3692  O   TYR B 255      60.825  22.864  63.738  1.00 19.89           O  
ATOM   3693  CB  TYR B 255      59.544  21.610  61.353  1.00  8.74           C  
ATOM   3694  CG  TYR B 255      58.760  20.790  62.372  1.00  2.09           C  
ATOM   3695  CD1 TYR B 255      57.514  21.217  62.849  1.00  2.00           C  
ATOM   3696  CD2 TYR B 255      59.280  19.599  62.880  1.00  9.79           C  
ATOM   3697  CE1 TYR B 255      56.804  20.475  63.814  1.00  4.57           C  
ATOM   3698  CE2 TYR B 255      58.586  18.855  63.838  1.00  2.00           C  
ATOM   3699  CZ  TYR B 255      57.355  19.295  64.299  1.00  4.22           C  
ATOM   3700  OH  TYR B 255      56.697  18.555  65.249  1.00 11.17           O  
ATOM   3701  N   ILE B 256      61.735  24.214  62.192  1.00 13.50           N  
ATOM   3702  CA  ILE B 256      62.898  24.566  62.997  1.00 13.67           C  
ATOM   3703  C   ILE B 256      62.683  25.817  63.870  1.00 11.48           C  
ATOM   3704  O   ILE B 256      62.669  26.936  63.369  1.00 18.91           O  
ATOM   3705  CB  ILE B 256      64.118  24.789  62.089  1.00  6.78           C  
ATOM   3706  CG1 ILE B 256      64.374  23.531  61.260  1.00  4.55           C  
ATOM   3707  CG2 ILE B 256      65.337  25.153  62.927  1.00 12.91           C  
ATOM   3708  CD1 ILE B 256      65.500  23.675  60.261  1.00  9.71           C  
ATOM   3709  N   THR B 257      62.534  25.622  65.176  1.00 10.14           N  
ATOM   3710  CA  THR B 257      62.448  26.748  66.099  1.00 10.42           C  
ATOM   3711  C   THR B 257      63.025  26.404  67.474  1.00 15.52           C  
ATOM   3712  O   THR B 257      63.120  25.231  67.849  1.00 15.54           O  
ATOM   3713  CB  THR B 257      60.982  27.253  66.236  1.00 11.33           C  
ATOM   3714  OG1 THR B 257      60.973  28.571  66.800  1.00 10.53           O  
ATOM   3715  CG2 THR B 257      60.170  26.334  67.109  1.00  2.00           C  
ATOM   3716  N   GLY B 258      63.521  27.429  68.160  1.00 14.98           N  
ATOM   3717  CA  GLY B 258      64.103  27.254  69.474  1.00  2.00           C  
ATOM   3718  C   GLY B 258      65.522  26.738  69.442  1.00  8.79           C  
ATOM   3719  O   GLY B 258      66.034  26.321  70.471  1.00 15.09           O  
ATOM   3720  N   GLN B 259      66.189  26.847  68.296  1.00 11.92           N  
ATOM   3721  CA  GLN B 259      67.510  26.245  68.120  1.00  8.51           C  
ATOM   3722  C   GLN B 259      68.628  27.256  68.228  1.00  9.44           C  
ATOM   3723  O   GLN B 259      68.461  28.422  67.889  1.00  2.00           O  
ATOM   3724  CB  GLN B 259      67.616  25.532  66.761  1.00  8.45           C  
ATOM   3725  CG  GLN B 259      66.880  24.184  66.690  1.00 11.71           C  
ATOM   3726  CD  GLN B 259      67.401  23.146  67.690  1.00 15.05           C  
ATOM   3727  OE1 GLN B 259      66.713  22.786  68.649  1.00 23.38           O  
ATOM   3728  NE2 GLN B 259      68.598  22.632  67.439  1.00 17.42           N  
ATOM   3729  N   ILE B 260      69.756  26.804  68.758  1.00  4.85           N  
ATOM   3730  CA  ILE B 260      71.001  27.535  68.638  1.00  9.51           C  
ATOM   3731  C   ILE B 260      71.930  26.624  67.855  1.00  7.89           C  
ATOM   3732  O   ILE B 260      72.104  25.458  68.211  1.00 16.62           O  
ATOM   3733  CB  ILE B 260      71.634  27.847  70.027  1.00  9.06           C  
ATOM   3734  CG1 ILE B 260      70.667  28.667  70.888  1.00 10.32           C  
ATOM   3735  CG2 ILE B 260      72.921  28.645  69.850  1.00  3.83           C  
ATOM   3736  CD1 ILE B 260      69.985  27.876  71.987  1.00 13.02           C  
ATOM   3737  N   ILE B 261      72.420  27.124  66.722  1.00 13.76           N  
ATOM   3738  CA  ILE B 261      73.232  26.332  65.795  1.00  7.99           C  
ATOM   3739  C   ILE B 261      74.579  27.022  65.616  1.00 10.81           C  
ATOM   3740  O   ILE B 261      74.629  28.193  65.238  1.00 14.52           O  
ATOM   3741  CB  ILE B 261      72.542  26.219  64.405  1.00  2.14           C  
ATOM   3742  CG1 ILE B 261      71.099  25.734  64.570  1.00  6.08           C  
ATOM   3743  CG2 ILE B 261      73.302  25.235  63.511  1.00  6.55           C  
ATOM   3744  CD1 ILE B 261      70.188  26.048  63.384  1.00  9.13           C  
ATOM   3745  N   TRP B 262      75.662  26.318  65.942  1.00  9.48           N  
ATOM   3746  CA  TRP B 262      77.012  26.856  65.767  1.00  7.71           C  
ATOM   3747  C   TRP B 262      77.491  26.709  64.321  1.00 11.15           C  
ATOM   3748  O   TRP B 262      77.424  25.630  63.744  1.00 16.81           O  
ATOM   3749  CB  TRP B 262      77.999  26.154  66.721  1.00  3.40           C  
ATOM   3750  CG  TRP B 262      77.920  26.666  68.138  1.00  8.95           C  
ATOM   3751  CD1 TRP B 262      78.702  27.637  68.700  1.00 14.38           C  
ATOM   3752  CD2 TRP B 262      76.901  26.371  69.100  1.00  6.12           C  
ATOM   3753  NE1 TRP B 262      78.216  27.986  69.941  1.00 10.49           N  
ATOM   3754  CE2 TRP B 262      77.110  27.226  70.211  1.00 13.80           C  
ATOM   3755  CE3 TRP B 262      75.824  25.477  69.133  1.00  9.52           C  
ATOM   3756  CZ2 TRP B 262      76.282  27.214  71.330  1.00 11.37           C  
ATOM   3757  CZ3 TRP B 262      75.003  25.466  70.243  1.00  9.93           C  
ATOM   3758  CH2 TRP B 262      75.236  26.331  71.328  1.00 14.56           C  
ATOM   3759  N   ALA B 263      77.939  27.808  63.729  1.00  9.93           N  
ATOM   3760  CA  ALA B 263      78.699  27.743  62.486  1.00  8.06           C  
ATOM   3761  C   ALA B 263      80.151  28.068  62.806  1.00  9.88           C  
ATOM   3762  O   ALA B 263      80.571  29.222  62.725  1.00 13.79           O  
ATOM   3763  CB  ALA B 263      78.139  28.732  61.469  1.00  3.51           C  
ATOM   3764  N   ASP B 264      80.925  27.041  63.145  1.00 14.66           N  
ATOM   3765  CA  ASP B 264      82.199  27.249  63.830  1.00 13.16           C  
ATOM   3766  C   ASP B 264      83.330  26.336  63.378  1.00  9.23           C  
ATOM   3767  O   ASP B 264      84.302  26.157  64.108  1.00 16.50           O  
ATOM   3768  CB  ASP B 264      82.010  27.092  65.343  1.00  6.48           C  
ATOM   3769  CG  ASP B 264      81.540  25.699  65.740  1.00 14.37           C  
ATOM   3770  OD1 ASP B 264      81.422  24.812  64.868  1.00 11.13           O  
ATOM   3771  OD2 ASP B 264      81.300  25.482  66.937  1.00  8.95           O  
ATOM   3772  N   GLY B 265      83.151  25.664  62.247  1.00  9.65           N  
ATOM   3773  CA  GLY B 265      84.211  24.822  61.716  1.00  4.88           C  
ATOM   3774  C   GLY B 265      84.588  23.653  62.610  1.00 13.25           C  
ATOM   3775  O   GLY B 265      85.682  23.102  62.493  1.00 12.76           O  
ATOM   3776  N   GLY B 266      83.674  23.265  63.493  1.00 10.74           N  
ATOM   3777  CA  GLY B 266      83.918  22.144  64.376  1.00 17.30           C  
ATOM   3778  C   GLY B 266      84.535  22.524  65.708  1.00 17.06           C  
ATOM   3779  O   GLY B 266      84.869  21.651  66.504  1.00 20.51           O  
ATOM   3780  N   PHE B 267      84.720  23.821  65.940  1.00 13.38           N  
ATOM   3781  CA  PHE B 267      85.297  24.299  67.196  1.00 14.89           C  
ATOM   3782  C   PHE B 267      84.672  23.638  68.429  1.00 10.31           C  
ATOM   3783  O   PHE B 267      85.386  23.055  69.242  1.00 12.20           O  
ATOM   3784  CB  PHE B 267      85.150  25.820  67.304  1.00 11.72           C  
ATOM   3785  CG  PHE B 267      85.886  26.421  68.474  1.00 11.76           C  
ATOM   3786  CD1 PHE B 267      85.263  26.547  69.716  1.00  3.47           C  
ATOM   3787  CD2 PHE B 267      87.202  26.867  68.331  1.00  7.36           C  
ATOM   3788  CE1 PHE B 267      85.939  27.109  70.796  1.00  6.46           C  
ATOM   3789  CE2 PHE B 267      87.883  27.433  69.405  1.00  8.26           C  
ATOM   3790  CZ  PHE B 267      87.250  27.552  70.641  1.00 10.10           C  
ATOM   3791  N   THR B 268      83.343  23.704  68.536  1.00 13.68           N  
ATOM   3792  CA  THR B 268      82.630  23.233  69.725  1.00 11.76           C  
ATOM   3793  C   THR B 268      82.485  21.716  69.807  1.00 14.61           C  
ATOM   3794  O   THR B 268      82.067  21.194  70.838  1.00 27.95           O  
ATOM   3795  CB  THR B 268      81.212  23.859  69.844  1.00 12.67           C  
ATOM   3796  OG1 THR B 268      80.444  23.569  68.668  1.00 16.32           O  
ATOM   3797  CG2 THR B 268      81.302  25.367  70.047  1.00 10.04           C  
ATOM   3798  N   ALA B 269      82.750  21.023  68.700  1.00 11.85           N  
ATOM   3799  CA  ALA B 269      82.816  19.561  68.690  1.00  9.54           C  
ATOM   3800  C   ALA B 269      84.193  19.082  69.143  1.00 12.91           C  
ATOM   3801  O   ALA B 269      84.353  17.953  69.596  1.00 20.33           O  
ATOM   3802  CB  ALA B 269      82.519  19.035  67.293  1.00  5.71           C  
ATOM   3803  N   ASN B 270      85.177  19.965  69.040  1.00 11.32           N  
ATOM   3804  CA  ASN B 270      86.557  19.628  69.353  1.00 14.47           C  
ATOM   3805  C   ASN B 270      86.827  19.684  70.859  1.00 13.80           C  
ATOM   3806  O   ASN B 270      86.750  20.743  71.486  1.00 17.37           O  
ATOM   3807  CB  ASN B 270      87.499  20.578  68.600  1.00 14.17           C  
ATOM   3808  CG  ASN B 270      88.971  20.216  68.766  1.00 20.85           C  
ATOM   3809  OD1 ASN B 270      89.844  20.942  68.301  1.00 15.96           O  
ATOM   3810  ND2 ASN B 270      89.252  19.090  69.414  1.00 12.45           N  
ATOM   3811  N   GLY B 271      87.140  18.527  71.428  1.00 19.46           N  
ATOM   3812  CA  GLY B 271      87.540  18.454  72.821  1.00  6.47           C  
ATOM   3813  C   GLY B 271      89.045  18.489  73.014  1.00 13.84           C  
ATOM   3814  O   GLY B 271      89.533  19.231  73.860  1.00 27.67           O  
ATOM   3815  N   GLY B 272      89.792  17.717  72.226  1.00 14.21           N  
ATOM   3816  CA  GLY B 272      91.212  17.563  72.504  1.00 11.18           C  
ATOM   3817  C   GLY B 272      92.141  17.467  71.309  1.00 13.08           C  
ATOM   3818  O   GLY B 272      93.314  17.094  71.449  1.00 20.50           O  
ATOM   3819  N   PHE B 273      91.603  17.735  70.125  1.00 15.08           N  
ATOM   3820  CA  PHE B 273      92.413  17.831  68.917  1.00 24.99           C  
ATOM   3821  C   PHE B 273      93.114  19.188  68.837  1.00 27.27           C  
ATOM   3822  O   PHE B 273      92.485  20.205  69.202  1.00 37.87           O  
ATOM   3823  CB  PHE B 273      91.544  17.645  67.676  1.00 18.33           C  
ATOM   3824  CG  PHE B 273      90.890  16.300  67.582  1.00 13.58           C  
ATOM   3825  CD1 PHE B 273      89.738  16.027  68.302  1.00  6.46           C  
ATOM   3826  CD2 PHE B 273      91.341  15.362  66.663  1.00 14.46           C  
ATOM   3827  CE1 PHE B 273      89.037  14.851  68.099  1.00  7.51           C  
ATOM   3828  CE2 PHE B 273      90.638  14.176  66.454  1.00 13.11           C  
ATOM   3829  CZ  PHE B 273      89.483  13.927  67.171  1.00  5.74           C  
ATOM   3830  OXT PHE B 273      94.283  19.221  68.405  1.00 33.95           O  
TER    3831      PHE B 273                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
