
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  246 ( 1839),  selected  246 , name 2jah_C
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 2jah_C.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     2_C      M       1           -
LGA    S     3_C      -       -           -
LGA    A     4_C      T       2          0.377
LGA    L     5_C      L       3          1.154
LGA    Q     6_C      S       4          1.268
LGA    G     7_C      G       5          1.471
LGA    K     8_C      K       6          0.879
LGA    V     9_C      T       7          0.499
LGA    A    10_C      L       8          0.534
LGA    L    11_C      F       9          0.689
LGA    I    12_C      I      10          0.583
LGA    T    13_C      T      11          0.505
LGA    G    14_C      G      12          0.508
LGA    A    15_C      A      13          0.364
LGA    S    16_C      S      14          0.932
LGA    S    17_C      R      15          1.022
LGA    G    18_C      G      16          0.805
LGA    I    19_C      I      17          0.474
LGA    G    20_C      G      18          0.357
LGA    E    21_C      L      19          0.625
LGA    A    22_C      A      20          0.284
LGA    T    23_C      I      21          0.536
LGA    A    24_C      A      22          0.370
LGA    R    25_C      L      23          0.415
LGA    A    26_C      R      24          0.776
LGA    L    27_C      A      25          0.968
LGA    A    28_C      A      26          0.912
LGA    A    29_C      R      27          1.113
LGA    E    30_C      D      28          1.972
LGA    G    31_C      G      29          1.837
LGA    A    32_C      A      30          1.086
LGA    A    33_C      N      31          0.586
LGA    V    34_C      V      32          0.513
LGA    A    35_C      A      33          0.495
LGA    I    36_C      I      34          0.674
LGA    A    37_C      A      35          1.229
LGA    A    38_C      A      36          0.805
LGA    R    39_C      K      37          0.878
LGA    R    40_C      S      38          1.009
LGA    V    41_C      A      39          1.703
LGA    E    42_C      V      40          3.183
LGA    -       -      A      41           -
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    K    43_C      T      48          1.630
LGA    L    44_C      I      49          1.833
LGA    R    45_C      H      50          0.907
LGA    A    46_C      S      51          1.337
LGA    L    47_C      A      52          2.020
LGA    G    48_C      A      53          1.545
LGA    D    49_C      A      54          1.626
LGA    E    50_C      A      55          2.416
LGA    L    51_C      V      56          2.277
LGA    T    52_C      N      57          1.630
LGA    A    53_C      A      58          2.907
LGA    A    54_C      A      59          3.630
LGA    G    55_C      G      60          3.381
LGA    A    56_C      G      61          1.686
LGA    K    57_C      Q      62          0.940
LGA    V    58_C      G      63          1.170
LGA    H    59_C      L      64          0.855
LGA    V    60_C      A      65          0.630
LGA    L    61_C      L      66          0.517
LGA    E    62_C      K      67          0.616
LGA    L    63_C      C      68          0.543
LGA    D    64_C      D      69          0.443
LGA    V    65_C      I      70          0.426
LGA    A    66_C      R      71          0.664
LGA    D    67_C      E      72          0.193
LGA    R    68_C      E      73          0.676
LGA    Q    69_C      D      74          0.678
LGA    G    70_C      Q      75          0.625
LGA    V    71_C      V      76          0.648
LGA    D    72_C      R      77          0.601
LGA    A    73_C      A      78          0.627
LGA    A    74_C      A      79          0.562
LGA    V    75_C      V      80          0.377
LGA    A    76_C      A      81          0.293
LGA    S    77_C      A      82          0.509
LGA    T    78_C      T      83          0.423
LGA    V    79_C      V      84          0.425
LGA    E    80_C      D      85          0.326
LGA    A    81_C      T      86          0.668
LGA    L    82_C      F      87          1.043
LGA    G    83_C      G      88          1.036
LGA    G    84_C      G      89          0.488
LGA    L    85_C      I      90          0.412
LGA    D    86_C      D      91          0.131
LGA    I    87_C      I      92          0.403
LGA    L    88_C      L      93          0.467
LGA    V    89_C      V      94          0.367
LGA    N    90_C      N      95          0.798
LGA    N    91_C      N      96          0.458
LGA    A    92_C      A      97          2.580
LGA    G    93_C      S      98          2.578
LGA    I    94_C      A      99          0.961
LGA    X    95_C      I     100          0.833
LGA    L    96_C      W     101          1.781
LGA    L    97_C      L     102          1.886
LGA    G    98_C      R     103          1.517
LGA    P    99_C      G     104          1.684
LGA    V   100_C      T     105          1.117
LGA    E   101_C      L     106          1.762
LGA    D   102_C      D     107          3.717
LGA    A   103_C      T     108          2.471
LGA    D   104_C      P     109          1.834
LGA    T   105_C      M     110          1.868
LGA    T   106_C      K     111          1.088
LGA    D   107_C      R     112          1.006
LGA    W   108_C      F     113          0.230
LGA    T   109_C      D     114          0.484
LGA    R   110_C      L     115          0.389
LGA    X   111_C      M     116          0.179
LGA    I   112_C      Q     117          0.517
LGA    D   113_C      Q     118          0.759
LGA    T   114_C      V     119          0.625
LGA    N   115_C      N     120          0.480
LGA    L   116_C      A     121          1.161
LGA    L   117_C      R     122          0.995
LGA    G   118_C      G     123          1.310
LGA    L   119_C      S     124          1.187
LGA    X   120_C      F     125          0.612
LGA    Y   121_C      V     126          0.474
LGA    X   122_C      C     127          0.487
LGA    T   123_C      A     128          0.568
LGA    R   124_C      Q     129          0.251
LGA    A   125_C      A     130          0.249
LGA    A   126_C      C     131          0.142
LGA    L   127_C      L     132          0.294
LGA    P   128_C      P     133          0.418
LGA    H   129_C      H     134          0.354
LGA    L   130_C      L     135          0.440
LGA    L   131_C      L     136          0.405
LGA    R   132_C      Q     137          0.562
LGA    S   133_C      A     138          0.546
LGA    -       -      P     139           -
LGA    K   134_C      N     140          4.263
LGA    G   135_C      P     141          0.688
LGA    T   136_C      H     142          0.388
LGA    V   137_C      I     143          0.465
LGA    V   138_C      L     144          0.660
LGA    Q   139_C      T     145          0.555
LGA    X   140_C      L     146          1.146
LGA    S   141_C      A     147          0.919
LGA    S   142_C      P     148          3.677
LGA    I   143_C      -       -           -
LGA    A   144_C      -       -           -
LGA    G   145_C      P     149          5.341
LGA    R   146_C      P     150          4.544
LGA    -       -      S     151           -
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    V   147_C      W     156           #
LGA    N   148_C      W     157          4.748
LGA    V   149_C      G     158           #
LGA    R   150_C      A     159          2.255
LGA    N   151_C      H     160          3.662
LGA    A   152_C      -       -           -
LGA    A   153_C      T     161          1.914
LGA    V   154_C      G     162          1.304
LGA    Y   155_C      Y     163          1.383
LGA    Q   156_C      T     164          1.065
LGA    A   157_C      L     165          0.909
LGA    T   158_C      A     166          1.435
LGA    K   159_C      K     167          1.895
LGA    F   160_C      M     168          1.747
LGA    G   161_C      G     169          1.732
LGA    V   162_C      M     170          1.649
LGA    N   163_C      S     171          1.492
LGA    A   164_C      L     172          1.800
LGA    F   165_C      V     173          1.687
LGA    S   166_C      T     174          1.061
LGA    E   167_C      L     175          1.431
LGA    T   168_C      G     176          1.618
LGA    L   169_C      L     177          1.106
LGA    R   170_C      A     178          0.951
LGA    Q   171_C      A     179          1.405
LGA    E   172_C      E     180          1.101
LGA    V   173_C      F     181          1.031
LGA    T   174_C      G     182          1.499
LGA    E   175_C      P     183          1.968
LGA    R   176_C      Q     184          1.282
LGA    G   177_C      G     185          1.132
LGA    V   178_C      V     186          0.742
LGA    R   179_C      A     187          0.729
LGA    V   180_C      I     188          0.442
LGA    V   181_C      N     189          1.603
LGA    V   182_C      A     190          0.269
LGA    I   183_C      L     191          0.934
LGA    E   184_C      W     192          1.691
LGA    P   185_C      P     193          2.463
LGA    -       -      R     194           -
LGA    G   186_C      T     195          4.096
LGA    T   187_C      V     196          1.316
LGA    T   188_C      I     197          0.866
LGA    D   189_C      A     198          0.336
LGA    T   190_C      T     199          0.375
LGA    E   191_C      D     200          0.890
LGA    L   192_C      A     201          1.386
LGA    R   193_C      I     202          3.140
LGA    G   194_C      N     203          3.250
LGA    H   195_C      -       -           -
LGA    I   196_C      M     204          3.936
LGA    T   197_C      -       -           -
LGA    H   198_C      -       -           -
LGA    T   199_C      -       -           -
LGA    A   200_C      -       -           -
LGA    T   201_C      -       -           -
LGA    K   202_C      -       -           -
LGA    E   203_C      -       -           -
LGA    X   204_C      -       -           -
LGA    Y   205_C      L     205          3.085
LGA    E   206_C      P     206          2.901
LGA    Q   207_C      G     207          1.330
LGA    R   208_C      -       -           -
LGA    I   209_C      V     208          2.663
LGA    S   210_C      D     209          3.125
LGA    Q   211_C      A     210           -
LGA    I   212_C      A     211           #
LGA    R   213_C      A     212          2.753
LGA    K   214_C      C     213          0.912
LGA    L   215_C      R     214          2.315
LGA    Q   216_C      R     215          1.639
LGA    A   217_C      P     216          0.758
LGA    Q   218_C      E     217          0.595
LGA    D   219_C      I     218          0.601
LGA    I   220_C      M     219          0.756
LGA    A   221_C      A     220          0.943
LGA    E   222_C      D     221          1.159
LGA    A   223_C      A     222          1.364
LGA    V   224_C      A     223          0.845
LGA    R   225_C      H     224          0.656
LGA    Y   226_C      A     225          0.884
LGA    A   227_C      V     226          0.619
LGA    V   228_C      L     227          0.642
LGA    T   229_C      T     228          0.912
LGA    A   230_C      R     229          1.391
LGA    P   231_C      E     230          2.440
LGA    H   232_C      A     231          3.182
LGA    H   233_C      A     232          3.608
LGA    A   234_C      G     233          4.879
LGA    T   235_C      F     234          1.687
LGA    V   236_C      H     235           #
LGA    -       -      G     236           -
LGA    H   237_C      Q     237          1.939
LGA    E   238_C      F     238          1.744
LGA    I   239_C      L     239          1.301
LGA    F   240_C      I     240          2.436
LGA    -       -      D     241           -
LGA    I   241_C      D     242          5.233
LGA    R   242_C      E     243           -
LGA    -       -      V     244           -
LGA    -       -      L     245           -
LGA    -       -      A     246           -
LGA    -       -      Q     247           -
LGA    -       -      A     248           -
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    P   243_C      A     257           #
LGA    T   244_C      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    D   245_C      L     264          3.301
LGA    Q   246_C      L     265          3.754
LGA    V   247_C      P     266           #
LGA    -       -      D     267           -
LGA    -       -      L     268           -
LGA    -       -      F     269           -
LGA    -       -      L     270           -
LGA    -       -      E     271           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  246  271    5.0    222    1.69    28.83     75.893    12.432

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.672670 * X  +   0.735333 * Y  +   0.082467 * Z  +  53.479225
  Y_new =   0.183138 * X  +  -0.057468 * Y  +  -0.981406 * Z  +  44.328781
  Z_new =  -0.716921 * X  +   0.675265 * Y  +  -0.173325 * Z  + 126.288223 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.822049   -1.319543  [ DEG:   104.3957    -75.6043 ]
  Theta =   0.799376    2.342217  [ DEG:    45.8008    134.1992 ]
  Phi   =   0.265813   -2.875779  [ DEG:    15.2300   -164.7700 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jah_C                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jah_C.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  246  271   5.0  222   1.69   28.83  75.893
REMARK  ---------------------------------------------------------- 
MOLECULE 2jah_C
HEADER    OXIDOREDUCTASE                          28-NOV-06   2JAH              
TITLE     BIOCHEMICAL AND STRUCTURAL ANALYSIS OF THE CLAVULANIC ACID            
TITLE    2 DEHYDEOGENASE (CAD) FROM STREPTOMYCES CLAVULIGERUS                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CLAVULANIC ACID DEHYDROGENASE;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES CLAVULIGERUS;                      
SOURCE   3 STRAIN: NRRL3585;                                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET24A                                    
KEYWDS    SHORT-CHAIN DEHYDROGENASE/REDUCTASE, LACTAMASE INHIBITOR,             
KEYWDS   2 ANTIBIOTIC BIOSYNTHESIS, NADPH, OXIDOREDUCTASE, CLAVULANIC           
KEYWDS   3 ACID                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.K.MACKENZIE,N.J.KERSHAW,H.HERNANDEZ,C.V.ROBINSON,                   
AUTHOR   2 C.J.SCHOFIELD,I.ANDERSSON                                            
REVDAT   1   20-FEB-07 2JAH    0                                                
JRNL        AUTH   A.K.MACKENZIE,N.J.KERSHAW,H.HERNANDEZ,C.V.ROBINSON,          
JRNL        AUTH 2 C.J.SCHOFIELD,I.ANDERSSON                                    
JRNL        TITL   CLAVULANIC ACID DEHYDROGENASE: STRUCTURAL AND                
JRNL        TITL 2 BIOCHEMICAL ANALYSIS OF THE FINAL STEP IN THE                
JRNL        TITL 3 BIOSYNTHESIS OF THE BETA-LACTAMASE INHIBITOR                 
JRNL        TITL 4 CLAVULANIC ACID.                                             
JRNL        REF    BIOCHEMISTRY                  V.  46  1523 2007              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2JAH A    1   247  UNP    Q9LCV7   Q9LCV7_STRCL     1    247             
DBREF  2JAH B    1   247  UNP    Q9LCV7   Q9LCV7_STRCL     1    247             
DBREF  2JAH C    1   247  UNP    Q9LCV7   Q9LCV7_STRCL     1    247             
DBREF  2JAH D    1   247  UNP    Q9LCV7   Q9LCV7_STRCL     1    247             
SEQRES   1 A  247  MSE PRO SER ALA LEU GLN GLY LYS VAL ALA LEU ILE THR          
SEQRES   2 A  247  GLY ALA SER SER GLY ILE GLY GLU ALA THR ALA ARG ALA          
SEQRES   3 A  247  LEU ALA ALA GLU GLY ALA ALA VAL ALA ILE ALA ALA ARG          
SEQRES   4 A  247  ARG VAL GLU LYS LEU ARG ALA LEU GLY ASP GLU LEU THR          
SEQRES   5 A  247  ALA ALA GLY ALA LYS VAL HIS VAL LEU GLU LEU ASP VAL          
SEQRES   6 A  247  ALA ASP ARG GLN GLY VAL ASP ALA ALA VAL ALA SER THR          
SEQRES   7 A  247  VAL GLU ALA LEU GLY GLY LEU ASP ILE LEU VAL ASN ASN          
SEQRES   8 A  247  ALA GLY ILE MSE LEU LEU GLY PRO VAL GLU ASP ALA ASP          
SEQRES   9 A  247  THR THR ASP TRP THR ARG MSE ILE ASP THR ASN LEU LEU          
SEQRES  10 A  247  GLY LEU MSE TYR MSE THR ARG ALA ALA LEU PRO HIS LEU          
SEQRES  11 A  247  LEU ARG SER LYS GLY THR VAL VAL GLN MSE SER SER ILE          
SEQRES  12 A  247  ALA GLY ARG VAL ASN VAL ARG ASN ALA ALA VAL TYR GLN          
SEQRES  13 A  247  ALA THR LYS PHE GLY VAL ASN ALA PHE SER GLU THR LEU          
SEQRES  14 A  247  ARG GLN GLU VAL THR GLU ARG GLY VAL ARG VAL VAL VAL          
SEQRES  15 A  247  ILE GLU PRO GLY THR THR ASP THR GLU LEU ARG GLY HIS          
SEQRES  16 A  247  ILE THR HIS THR ALA THR LYS GLU MSE TYR GLU GLN ARG          
SEQRES  17 A  247  ILE SER GLN ILE ARG LYS LEU GLN ALA GLN ASP ILE ALA          
SEQRES  18 A  247  GLU ALA VAL ARG TYR ALA VAL THR ALA PRO HIS HIS ALA          
SEQRES  19 A  247  THR VAL HIS GLU ILE PHE ILE ARG PRO THR ASP GLN VAL          
SEQRES   1 B  247  MSE PRO SER ALA LEU GLN GLY LYS VAL ALA LEU ILE THR          
SEQRES   2 B  247  GLY ALA SER SER GLY ILE GLY GLU ALA THR ALA ARG ALA          
SEQRES   3 B  247  LEU ALA ALA GLU GLY ALA ALA VAL ALA ILE ALA ALA ARG          
SEQRES   4 B  247  ARG VAL GLU LYS LEU ARG ALA LEU GLY ASP GLU LEU THR          
SEQRES   5 B  247  ALA ALA GLY ALA LYS VAL HIS VAL LEU GLU LEU ASP VAL          
SEQRES   6 B  247  ALA ASP ARG GLN GLY VAL ASP ALA ALA VAL ALA SER THR          
SEQRES   7 B  247  VAL GLU ALA LEU GLY GLY LEU ASP ILE LEU VAL ASN ASN          
SEQRES   8 B  247  ALA GLY ILE MSE LEU LEU GLY PRO VAL GLU ASP ALA ASP          
SEQRES   9 B  247  THR THR ASP TRP THR ARG MSE ILE ASP THR ASN LEU LEU          
SEQRES  10 B  247  GLY LEU MSE TYR MSE THR ARG ALA ALA LEU PRO HIS LEU          
SEQRES  11 B  247  LEU ARG SER LYS GLY THR VAL VAL GLN MSE SER SER ILE          
SEQRES  12 B  247  ALA GLY ARG VAL ASN VAL ARG ASN ALA ALA VAL TYR GLN          
SEQRES  13 B  247  ALA THR LYS PHE GLY VAL ASN ALA PHE SER GLU THR LEU          
SEQRES  14 B  247  ARG GLN GLU VAL THR GLU ARG GLY VAL ARG VAL VAL VAL          
SEQRES  15 B  247  ILE GLU PRO GLY THR THR ASP THR GLU LEU ARG GLY HIS          
SEQRES  16 B  247  ILE THR HIS THR ALA THR LYS GLU MSE TYR GLU GLN ARG          
SEQRES  17 B  247  ILE SER GLN ILE ARG LYS LEU GLN ALA GLN ASP ILE ALA          
SEQRES  18 B  247  GLU ALA VAL ARG TYR ALA VAL THR ALA PRO HIS HIS ALA          
SEQRES  19 B  247  THR VAL HIS GLU ILE PHE ILE ARG PRO THR ASP GLN VAL          
SEQRES   1 C  247  MSE PRO SER ALA LEU GLN GLY LYS VAL ALA LEU ILE THR          
SEQRES   2 C  247  GLY ALA SER SER GLY ILE GLY GLU ALA THR ALA ARG ALA          
SEQRES   3 C  247  LEU ALA ALA GLU GLY ALA ALA VAL ALA ILE ALA ALA ARG          
SEQRES   4 C  247  ARG VAL GLU LYS LEU ARG ALA LEU GLY ASP GLU LEU THR          
SEQRES   5 C  247  ALA ALA GLY ALA LYS VAL HIS VAL LEU GLU LEU ASP VAL          
SEQRES   6 C  247  ALA ASP ARG GLN GLY VAL ASP ALA ALA VAL ALA SER THR          
SEQRES   7 C  247  VAL GLU ALA LEU GLY GLY LEU ASP ILE LEU VAL ASN ASN          
SEQRES   8 C  247  ALA GLY ILE MSE LEU LEU GLY PRO VAL GLU ASP ALA ASP          
SEQRES   9 C  247  THR THR ASP TRP THR ARG MSE ILE ASP THR ASN LEU LEU          
SEQRES  10 C  247  GLY LEU MSE TYR MSE THR ARG ALA ALA LEU PRO HIS LEU          
SEQRES  11 C  247  LEU ARG SER LYS GLY THR VAL VAL GLN MSE SER SER ILE          
SEQRES  12 C  247  ALA GLY ARG VAL ASN VAL ARG ASN ALA ALA VAL TYR GLN          
SEQRES  13 C  247  ALA THR LYS PHE GLY VAL ASN ALA PHE SER GLU THR LEU          
SEQRES  14 C  247  ARG GLN GLU VAL THR GLU ARG GLY VAL ARG VAL VAL VAL          
SEQRES  15 C  247  ILE GLU PRO GLY THR THR ASP THR GLU LEU ARG GLY HIS          
SEQRES  16 C  247  ILE THR HIS THR ALA THR LYS GLU MSE TYR GLU GLN ARG          
SEQRES  17 C  247  ILE SER GLN ILE ARG LYS LEU GLN ALA GLN ASP ILE ALA          
SEQRES  18 C  247  GLU ALA VAL ARG TYR ALA VAL THR ALA PRO HIS HIS ALA          
SEQRES  19 C  247  THR VAL HIS GLU ILE PHE ILE ARG PRO THR ASP GLN VAL          
SEQRES   1 D  247  MSE PRO SER ALA LEU GLN GLY LYS VAL ALA LEU ILE THR          
SEQRES   2 D  247  GLY ALA SER SER GLY ILE GLY GLU ALA THR ALA ARG ALA          
SEQRES   3 D  247  LEU ALA ALA GLU GLY ALA ALA VAL ALA ILE ALA ALA ARG          
SEQRES   4 D  247  ARG VAL GLU LYS LEU ARG ALA LEU GLY ASP GLU LEU THR          
SEQRES   5 D  247  ALA ALA GLY ALA LYS VAL HIS VAL LEU GLU LEU ASP VAL          
SEQRES   6 D  247  ALA ASP ARG GLN GLY VAL ASP ALA ALA VAL ALA SER THR          
SEQRES   7 D  247  VAL GLU ALA LEU GLY GLY LEU ASP ILE LEU VAL ASN ASN          
SEQRES   8 D  247  ALA GLY ILE MSE LEU LEU GLY PRO VAL GLU ASP ALA ASP          
SEQRES   9 D  247  THR THR ASP TRP THR ARG MSE ILE ASP THR ASN LEU LEU          
SEQRES  10 D  247  GLY LEU MSE TYR MSE THR ARG ALA ALA LEU PRO HIS LEU          
SEQRES  11 D  247  LEU ARG SER LYS GLY THR VAL VAL GLN MSE SER SER ILE          
SEQRES  12 D  247  ALA GLY ARG VAL ASN VAL ARG ASN ALA ALA VAL TYR GLN          
SEQRES  13 D  247  ALA THR LYS PHE GLY VAL ASN ALA PHE SER GLU THR LEU          
SEQRES  14 D  247  ARG GLN GLU VAL THR GLU ARG GLY VAL ARG VAL VAL VAL          
SEQRES  15 D  247  ILE GLU PRO GLY THR THR ASP THR GLU LEU ARG GLY HIS          
SEQRES  16 D  247  ILE THR HIS THR ALA THR LYS GLU MSE TYR GLU GLN ARG          
SEQRES  17 D  247  ILE SER GLN ILE ARG LYS LEU GLN ALA GLN ASP ILE ALA          
SEQRES  18 D  247  GLU ALA VAL ARG TYR ALA VAL THR ALA PRO HIS HIS ALA          
SEQRES  19 D  247  THR VAL HIS GLU ILE PHE ILE ARG PRO THR ASP GLN VAL          
HET    MSE  A  95       8                                                       
HET    MSE  A 111       8                                                       
HET    MSE  A 120       8                                                       
HET    MSE  A 122      16                                                       
HET    MSE  A 140       8                                                       
HET    MSE  A 204       8                                                       
HET    MSE  B  95       8                                                       
HET    MSE  B 111       8                                                       
HET    MSE  B 120       8                                                       
HET    MSE  B 122      16                                                       
HET    MSE  B 140       8                                                       
HET    MSE  B 204       8                                                       
HET    MSE  C  95       8                                                       
HET    MSE  C 111       8                                                       
HET    MSE  C 120       8                                                       
HET    MSE  C 122      16                                                       
HET    MSE  C 140       8                                                       
HET    MSE  C 204       8                                                       
HET    MSE  D  95       8                                                       
HET    MSE  D 111       8                                                       
HET    MSE  D 120       8                                                       
HET    MSE  D 122       8                                                       
HET    MSE  D 140       8                                                       
HET    MSE  D 204       8                                                       
HET    NDP  A1248      48                                                       
HET    NDP  B1248      48                                                       
HET    NDP  C1248      48                                                       
HET    NDP  D1248      48                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     NDP NADPH DIHYDRO-NICOTINAMIDE-ADENINE-DINUCLEOTIDE                  
HETNAM   2 NDP  PHOSPHATE                                                       
FORMUL   1  MSE    24(C5 H11 N O2 SE)                                           
FORMUL   5  NDP    4(C21 H30 N7 O17 P3)                                         
FORMUL   9  HOH   *494(H2 O)                                                    
CRYST1   58.748  122.626  126.594  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3683  N   PRO C   2      67.134  34.007  41.261  1.00 33.18           N  
ATOM   3684  CA  PRO C   2      65.998  33.602  42.087  1.00 32.94           C  
ATOM   3685  C   PRO C   2      65.903  34.357  43.416  1.00 32.64           C  
ATOM   3686  O   PRO C   2      66.924  34.697  44.031  1.00 33.15           O  
ATOM   3687  CB  PRO C   2      66.266  32.118  42.319  1.00 32.96           C  
ATOM   3688  CG  PRO C   2      66.901  31.681  41.011  1.00 33.15           C  
ATOM   3689  CD  PRO C   2      67.642  32.886  40.454  1.00 33.11           C  
ATOM   3690  N   SER C   3      64.669  34.592  43.850  1.00 31.54           N  
ATOM   3691  CA  SER C   3      64.383  35.472  44.968  1.00 30.42           C  
ATOM   3692  C   SER C   3      63.443  34.798  45.955  1.00 29.68           C  
ATOM   3693  O   SER C   3      62.219  34.950  45.875  1.00 29.05           O  
ATOM   3694  CB  SER C   3      63.773  36.781  44.461  1.00 30.61           C  
ATOM   3695  OG  SER C   3      64.619  37.401  43.504  1.00 30.96           O  
ATOM   3696  N   ALA C   4      64.034  34.065  46.898  1.00 28.76           N  
ATOM   3697  CA  ALA C   4      63.290  33.308  47.906  1.00 27.95           C  
ATOM   3698  C   ALA C   4      62.511  34.197  48.878  1.00 27.37           C  
ATOM   3699  O   ALA C   4      61.570  33.741  49.523  1.00 27.33           O  
ATOM   3700  CB  ALA C   4      64.241  32.385  48.686  1.00 27.63           C  
ATOM   3701  N   LEU C   5      62.909  35.461  48.979  1.00 26.53           N  
ATOM   3702  CA  LEU C   5      62.333  36.370  49.970  1.00 26.17           C  
ATOM   3703  C   LEU C   5      61.698  37.591  49.310  1.00 25.77           C  
ATOM   3704  O   LEU C   5      61.605  38.666  49.916  1.00 25.11           O  
ATOM   3705  CB  LEU C   5      63.407  36.787  50.985  1.00 26.12           C  
ATOM   3706  CG  LEU C   5      63.967  35.695  51.910  1.00 26.17           C  
ATOM   3707  CD1 LEU C   5      65.170  36.205  52.678  1.00 25.95           C  
ATOM   3708  CD2 LEU C   5      62.913  35.187  52.887  1.00 27.45           C  
ATOM   3709  N   GLN C   6      61.269  37.420  48.058  1.00 25.38           N  
ATOM   3710  CA  GLN C   6      60.636  38.498  47.323  1.00 25.61           C  
ATOM   3711  C   GLN C   6      59.414  39.029  48.063  1.00 25.26           C  
ATOM   3712  O   GLN C   6      58.529  38.263  48.437  1.00 25.42           O  
ATOM   3713  CB  GLN C   6      60.221  38.030  45.926  1.00 25.59           C  
ATOM   3714  CG  GLN C   6      59.717  39.149  45.062  1.00 27.55           C  
ATOM   3715  CD  GLN C   6      60.808  40.141  44.691  1.00 30.26           C  
ATOM   3716  OE1 GLN C   6      61.872  39.759  44.191  1.00 30.79           O  
ATOM   3717  NE2 GLN C   6      60.538  41.426  44.915  1.00 30.59           N  
ATOM   3718  N   GLY C   7      59.380  40.339  48.276  1.00 24.94           N  
ATOM   3719  CA  GLY C   7      58.254  40.976  48.947  1.00 24.72           C  
ATOM   3720  C   GLY C   7      58.379  41.080  50.461  1.00 24.87           C  
ATOM   3721  O   GLY C   7      57.580  41.772  51.093  1.00 24.73           O  
ATOM   3722  N   LYS C   8      59.365  40.397  51.044  1.00 24.38           N  
ATOM   3723  CA  LYS C   8      59.540  40.404  52.498  1.00 24.37           C  
ATOM   3724  C   LYS C   8      60.368  41.607  52.944  1.00 23.69           C  
ATOM   3725  O   LYS C   8      61.140  42.168  52.162  1.00 24.14           O  
ATOM   3726  CB  LYS C   8      60.194  39.104  53.005  1.00 24.92           C  
ATOM   3727  CG  LYS C   8      59.487  37.794  52.637  1.00 26.57           C  
ATOM   3728  CD  LYS C   8      58.099  37.687  53.226  1.00 29.75           C  
ATOM   3729  CE  LYS C   8      57.377  36.497  52.647  1.00 32.89           C  
ATOM   3730  NZ  LYS C   8      55.895  36.649  52.772  1.00 35.51           N  
ATOM   3731  N   VAL C   9      60.197  42.001  54.202  1.00 22.66           N  
ATOM   3732  CA  VAL C   9      60.962  43.101  54.775  1.00 21.55           C  
ATOM   3733  C   VAL C   9      61.859  42.580  55.896  1.00 21.09           C  
ATOM   3734  O   VAL C   9      61.383  41.956  56.844  1.00 20.27           O  
ATOM   3735  CB  VAL C   9      60.041  44.217  55.324  1.00 21.34           C  
ATOM   3736  CG1 VAL C   9      60.854  45.272  56.064  1.00 21.91           C  
ATOM   3737  CG2 VAL C   9      59.213  44.860  54.203  1.00 21.38           C  
ATOM   3738  N   ALA C  10      63.156  42.848  55.779  1.00 20.40           N  
ATOM   3739  CA  ALA C  10      64.110  42.463  56.811  1.00 21.12           C  
ATOM   3740  C   ALA C  10      64.759  43.688  57.439  1.00 21.16           C  
ATOM   3741  O   ALA C  10      65.185  44.609  56.731  1.00 21.71           O  
ATOM   3742  CB  ALA C  10      65.178  41.530  56.231  1.00 20.23           C  
ATOM   3743  N   LEU C  11      64.813  43.700  58.767  1.00 21.55           N  
ATOM   3744  CA  LEU C  11      65.549  44.712  59.522  1.00 21.37           C  
ATOM   3745  C   LEU C  11      66.786  44.066  60.160  1.00 21.23           C  
ATOM   3746  O   LEU C  11      66.681  43.094  60.907  1.00 20.31           O  
ATOM   3747  CB  LEU C  11      64.631  45.373  60.564  1.00 21.96           C  
ATOM   3748  CG  LEU C  11      65.149  46.273  61.701  1.00 23.04           C  
ATOM   3749  CD1 LEU C  11      66.276  47.203  61.274  1.00 26.47           C  
ATOM   3750  CD2 LEU C  11      63.996  47.075  62.279  1.00 22.25           C  
ATOM   3751  N   ILE C  12      67.953  44.610  59.839  1.00 20.82           N  
ATOM   3752  CA  ILE C  12      69.217  44.026  60.275  1.00 20.68           C  
ATOM   3753  C   ILE C  12      69.971  45.065  61.093  1.00 20.90           C  
ATOM   3754  O   ILE C  12      70.345  46.116  60.577  1.00 19.96           O  
ATOM   3755  CB  ILE C  12      70.072  43.569  59.062  1.00 20.53           C  
ATOM   3756  CG1 ILE C  12      69.274  42.657  58.121  1.00 20.86           C  
ATOM   3757  CG2 ILE C  12      71.375  42.890  59.520  1.00 20.44           C  
ATOM   3758  CD1 ILE C  12      68.671  43.380  56.885  1.00 18.65           C  
ATOM   3759  N   THR C  13      70.154  44.789  62.384  1.00 21.01           N  
ATOM   3760  CA  THR C  13      70.920  45.693  63.232  1.00 21.23           C  
ATOM   3761  C   THR C  13      72.391  45.329  63.101  1.00 21.46           C  
ATOM   3762  O   THR C  13      72.726  44.171  62.791  1.00 21.83           O  
ATOM   3763  CB  THR C  13      70.476  45.622  64.711  1.00 21.07           C  
ATOM   3764  OG1 THR C  13      70.941  44.400  65.297  1.00 21.96           O  
ATOM   3765  CG2 THR C  13      68.954  45.726  64.825  1.00 21.58           C  
ATOM   3766  N   GLY C  14      73.267  46.301  63.342  1.00 20.84           N  
ATOM   3767  CA  GLY C  14      74.698  46.083  63.183  1.00 20.99           C  
ATOM   3768  C   GLY C  14      75.082  45.834  61.730  1.00 21.03           C  
ATOM   3769  O   GLY C  14      75.922  44.979  61.437  1.00 21.50           O  
ATOM   3770  N   ALA C  15      74.488  46.605  60.824  1.00 20.59           N  
ATOM   3771  CA  ALA C  15      74.624  46.370  59.388  1.00 20.60           C  
ATOM   3772  C   ALA C  15      75.812  47.081  58.740  1.00 20.49           C  
ATOM   3773  O   ALA C  15      76.057  46.906  57.538  1.00 20.38           O  
ATOM   3774  CB  ALA C  15      73.331  46.766  58.681  1.00 20.95           C  
ATOM   3775  N   SER C  16      76.530  47.890  59.519  1.00 19.99           N  
ATOM   3776  CA  SER C  16      77.559  48.776  58.970  1.00 20.34           C  
ATOM   3777  C   SER C  16      78.867  48.063  58.635  1.00 20.45           C  
ATOM   3778  O   SER C  16      79.678  48.594  57.870  1.00 20.20           O  
ATOM   3779  CB  SER C  16      77.815  49.977  59.892  1.00 20.25           C  
ATOM   3780  OG  SER C  16      78.194  49.572  61.199  1.00 20.62           O  
ATOM   3781  N   SER C  17      79.067  46.876  59.213  1.00 19.90           N  
ATOM   3782  CA  SER C  17      80.240  46.049  58.925  1.00 20.05           C  
ATOM   3783  C   SER C  17      80.008  44.577  59.277  1.00 19.95           C  
ATOM   3784  O   SER C  17      78.943  44.203  59.767  1.00 20.11           O  
ATOM   3785  CB  SER C  17      81.475  46.582  59.666  1.00 20.21           C  
ATOM   3786  OG  SER C  17      81.285  46.512  61.078  1.00 19.63           O  
ATOM   3787  N   GLY C  18      81.015  43.744  59.014  1.00 20.15           N  
ATOM   3788  CA  GLY C  18      81.014  42.353  59.461  1.00 19.98           C  
ATOM   3789  C   GLY C  18      79.836  41.499  59.004  1.00 20.22           C  
ATOM   3790  O   GLY C  18      79.361  41.605  57.865  1.00 19.78           O  
ATOM   3791  N   ILE C  19      79.379  40.650  59.914  1.00 19.80           N  
ATOM   3792  CA  ILE C  19      78.249  39.722  59.683  1.00 20.11           C  
ATOM   3793  C   ILE C  19      76.943  40.435  59.269  1.00 19.64           C  
ATOM   3794  O   ILE C  19      76.249  39.972  58.370  1.00 19.74           O  
ATOM   3795  CB  ILE C  19      78.030  38.835  60.937  1.00 19.65           C  
ATOM   3796  CG1 ILE C  19      79.210  37.861  61.103  1.00 19.30           C  
ATOM   3797  CG2 ILE C  19      76.696  38.069  60.874  1.00 20.21           C  
ATOM   3798  CD1 ILE C  19      79.419  37.373  62.540  1.00 18.90           C  
ATOM   3799  N   GLY C  20      76.620  41.549  59.920  1.00 20.08           N  
ATOM   3800  CA  GLY C  20      75.388  42.293  59.604  1.00 20.10           C  
ATOM   3801  C   GLY C  20      75.364  42.853  58.193  1.00 20.43           C  
ATOM   3802  O   GLY C  20      74.331  42.802  57.505  1.00 19.51           O  
ATOM   3803  N   GLU C  21      76.502  43.392  57.759  1.00 20.36           N  
ATOM   3804  CA  GLU C  21      76.652  43.864  56.383  1.00 21.31           C  
ATOM   3805  C   GLU C  21      76.422  42.717  55.385  1.00 20.99           C  
ATOM   3806  O   GLU C  21      75.622  42.839  54.460  1.00 21.38           O  
ATOM   3807  CB  GLU C  21      78.035  44.492  56.180  1.00 20.84           C  
ATOM   3808  CG  GLU C  21      78.329  44.905  54.752  1.00 21.89           C  
ATOM   3809  CD  GLU C  21      79.689  45.555  54.585  1.00 22.58           C  
ATOM   3810  OE1 GLU C  21      80.477  45.625  55.559  1.00 26.24           O  
ATOM   3811  OE2 GLU C  21      79.980  45.997  53.461  1.00 24.76           O  
ATOM   3812  N   ALA C  22      77.138  41.613  55.571  1.00 20.83           N  
ATOM   3813  CA  ALA C  22      76.992  40.458  54.686  1.00 20.44           C  
ATOM   3814  C   ALA C  22      75.561  39.907  54.700  1.00 20.46           C  
ATOM   3815  O   ALA C  22      75.040  39.495  53.656  1.00 20.55           O  
ATOM   3816  CB  ALA C  22      77.992  39.382  55.061  1.00 20.41           C  
ATOM   3817  N   THR C  23      74.921  39.922  55.872  1.00 20.11           N  
ATOM   3818  CA  THR C  23      73.537  39.447  55.995  1.00 20.07           C  
ATOM   3819  C   THR C  23      72.575  40.347  55.208  1.00 20.71           C  
ATOM   3820  O   THR C  23      71.748  39.852  54.436  1.00 20.88           O  
ATOM   3821  CB  THR C  23      73.124  39.272  57.464  1.00 20.09           C  
ATOM   3822  OG1 THR C  23      73.972  38.289  58.066  1.00 19.99           O  
ATOM   3823  CG2 THR C  23      71.670  38.799  57.589  1.00 19.31           C  
ATOM   3824  N   ALA C  24      72.705  41.661  55.381  1.00 20.85           N  
ATOM   3825  CA  ALA C  24      71.897  42.615  54.626  1.00 21.08           C  
ATOM   3826  C   ALA C  24      72.041  42.368  53.121  1.00 21.52           C  
ATOM   3827  O   ALA C  24      71.047  42.332  52.385  1.00 21.32           O  
ATOM   3828  CB  ALA C  24      72.285  44.045  54.990  1.00 21.26           C  
ATOM   3829  N   ARG C  25      73.279  42.174  52.666  1.00 21.79           N  
ATOM   3830  CA  ARG C  25      73.535  41.908  51.251  1.00 22.10           C  
ATOM   3831  C   ARG C  25      72.858  40.619  50.792  1.00 22.48           C  
ATOM   3832  O   ARG C  25      72.245  40.580  49.722  1.00 22.28           O  
ATOM   3833  CB  ARG C  25      75.036  41.815  50.967  1.00 22.35           C  
ATOM   3834  CG  ARG C  25      75.801  43.101  51.147  1.00 23.46           C  
ATOM   3835  CD  ARG C  25      77.267  42.907  50.763  1.00 26.35           C  
ATOM   3836  NE  ARG C  25      78.064  44.097  51.053  1.00 28.28           N  
ATOM   3837  CZ  ARG C  25      78.201  45.127  50.226  1.00 30.15           C  
ATOM   3838  NH1 ARG C  25      77.588  45.128  49.040  1.00 30.87           N  
ATOM   3839  NH2 ARG C  25      78.949  46.165  50.585  1.00 31.43           N  
ATOM   3840  N   ALA C  26      72.989  39.572  51.606  1.00 22.09           N  
ATOM   3841  CA  ALA C  26      72.456  38.249  51.290  1.00 22.41           C  
ATOM   3842  C   ALA C  26      70.931  38.276  51.201  1.00 22.39           C  
ATOM   3843  O   ALA C  26      70.339  37.678  50.294  1.00 22.15           O  
ATOM   3844  CB  ALA C  26      72.907  37.233  52.350  1.00 22.49           C  
ATOM   3845  N   LEU C  27      70.299  38.968  52.147  1.00 22.09           N  
ATOM   3846  CA  LEU C  27      68.838  39.072  52.154  1.00 22.19           C  
ATOM   3847  C   LEU C  27      68.308  39.912  50.993  1.00 22.24           C  
ATOM   3848  O   LEU C  27      67.328  39.532  50.352  1.00 22.17           O  
ATOM   3849  CB  LEU C  27      68.313  39.567  53.507  1.00 22.28           C  
ATOM   3850  CG  LEU C  27      68.640  38.655  54.701  1.00 22.14           C  
ATOM   3851  CD1 LEU C  27      68.083  39.241  55.984  1.00 23.36           C  
ATOM   3852  CD2 LEU C  27      68.120  37.221  54.482  1.00 22.96           C  
ATOM   3853  N   ALA C  28      68.965  41.038  50.721  1.00 22.37           N  
ATOM   3854  CA  ALA C  28      68.654  41.867  49.548  1.00 22.73           C  
ATOM   3855  C   ALA C  28      68.740  41.043  48.266  1.00 22.83           C  
ATOM   3856  O   ALA C  28      67.849  41.107  47.429  1.00 22.88           O  
ATOM   3857  CB  ALA C  28      69.578  43.074  49.468  1.00 22.76           C  
ATOM   3858  N   ALA C  29      69.803  40.251  48.134  1.00 23.36           N  
ATOM   3859  CA  ALA C  29      69.971  39.365  46.978  1.00 23.72           C  
ATOM   3860  C   ALA C  29      68.808  38.377  46.820  1.00 23.98           C  
ATOM   3861  O   ALA C  29      68.507  37.950  45.711  1.00 23.90           O  
ATOM   3862  CB  ALA C  29      71.294  38.624  47.061  1.00 23.80           C  
ATOM   3863  N   GLU C  30      68.162  38.016  47.927  1.00 24.00           N  
ATOM   3864  CA  GLU C  30      66.977  37.148  47.887  1.00 24.44           C  
ATOM   3865  C   GLU C  30      65.684  37.917  47.605  1.00 24.37           C  
ATOM   3866  O   GLU C  30      64.597  37.336  47.607  1.00 24.55           O  
ATOM   3867  CB  GLU C  30      66.838  36.357  49.199  1.00 25.53           C  
ATOM   3868  CG  GLU C  30      67.897  35.292  49.426  1.00 26.84           C  
ATOM   3869  CD  GLU C  30      67.958  34.246  48.319  1.00 31.03           C  
ATOM   3870  OE1 GLU C  30      66.965  34.051  47.578  1.00 32.99           O  
ATOM   3871  OE2 GLU C  30      69.020  33.609  48.186  1.00 33.85           O  
ATOM   3872  N   GLY C  31      65.806  39.223  47.375  1.00 23.88           N  
ATOM   3873  CA  GLY C  31      64.661  40.068  47.038  1.00 23.26           C  
ATOM   3874  C   GLY C  31      63.932  40.682  48.221  1.00 22.84           C  
ATOM   3875  O   GLY C  31      62.842  41.236  48.057  1.00 22.88           O  
ATOM   3876  N   ALA C  32      64.515  40.572  49.414  1.00 22.59           N  
ATOM   3877  CA  ALA C  32      63.973  41.247  50.589  1.00 21.92           C  
ATOM   3878  C   ALA C  32      64.283  42.740  50.518  1.00 21.71           C  
ATOM   3879  O   ALA C  32      65.376  43.136  50.095  1.00 21.73           O  
ATOM   3880  CB  ALA C  32      64.551  40.644  51.874  1.00 21.71           C  
ATOM   3881  N   ALA C  33      63.311  43.565  50.896  1.00 21.23           N  
ATOM   3882  CA  ALA C  33      63.585  44.963  51.194  1.00 21.06           C  
ATOM   3883  C   ALA C  33      64.351  44.970  52.519  1.00 21.12           C  
ATOM   3884  O   ALA C  33      64.002  44.218  53.444  1.00 21.65           O  
ATOM   3885  CB  ALA C  33      62.294  45.757  51.308  1.00 20.71           C  
ATOM   3886  N   VAL C  34      65.419  45.764  52.604  1.00 20.81           N  
ATOM   3887  CA  VAL C  34      66.255  45.773  53.821  1.00 20.70           C  
ATOM   3888  C   VAL C  34      66.298  47.124  54.539  1.00 20.66           C  
ATOM   3889  O   VAL C  34      66.604  48.160  53.937  1.00 20.43           O  
ATOM   3890  CB  VAL C  34      67.710  45.246  53.554  1.00 20.77           C  
ATOM   3891  CG1 VAL C  34      67.687  43.767  53.190  1.00 20.73           C  
ATOM   3892  CG2 VAL C  34      68.415  46.052  52.464  1.00 21.42           C  
ATOM   3893  N   ALA C  35      65.944  47.110  55.821  1.00 20.66           N  
ATOM   3894  CA  ALA C  35      66.209  48.238  56.698  1.00 20.68           C  
ATOM   3895  C   ALA C  35      67.516  47.931  57.425  1.00 20.94           C  
ATOM   3896  O   ALA C  35      67.638  46.905  58.098  1.00 20.79           O  
ATOM   3897  CB  ALA C  35      65.075  48.441  57.681  1.00 20.96           C  
ATOM   3898  N   ILE C  36      68.496  48.811  57.245  1.00 21.16           N  
ATOM   3899  CA  ILE C  36      69.856  48.597  57.736  1.00 21.05           C  
ATOM   3900  C   ILE C  36      70.195  49.593  58.853  1.00 21.38           C  
ATOM   3901  O   ILE C  36      70.163  50.819  58.636  1.00 21.12           O  
ATOM   3902  CB  ILE C  36      70.906  48.622  56.569  1.00 20.91           C  
ATOM   3903  CG1 ILE C  36      70.794  49.896  55.705  1.00 20.76           C  
ATOM   3904  CG2 ILE C  36      70.774  47.360  55.702  1.00 21.06           C  
ATOM   3905  CD1 ILE C  36      71.823  49.948  54.557  1.00 20.84           C  
ATOM   3906  N   ALA C  37      70.519  49.052  60.036  1.00 21.32           N  
ATOM   3907  CA  ALA C  37      70.707  49.850  61.249  1.00 21.61           C  
ATOM   3908  C   ALA C  37      72.083  49.692  61.891  1.00 21.76           C  
ATOM   3909  O   ALA C  37      72.611  48.592  61.984  1.00 21.96           O  
ATOM   3910  CB  ALA C  37      69.609  49.542  62.257  1.00 21.37           C  
ATOM   3911  N   ALA C  38      72.648  50.819  62.322  1.00 21.97           N  
ATOM   3912  CA  ALA C  38      73.895  50.881  63.094  1.00 22.56           C  
ATOM   3913  C   ALA C  38      74.173  52.341  63.442  1.00 23.05           C  
ATOM   3914  O   ALA C  38      73.371  53.220  63.112  1.00 23.00           O  
ATOM   3915  CB  ALA C  38      75.073  50.278  62.311  1.00 22.75           C  
ATOM   3916  N   ARG C  39      75.306  52.595  64.102  1.00 23.66           N  
ATOM   3917  CA  ARG C  39      75.676  53.949  64.538  1.00 24.12           C  
ATOM   3918  C   ARG C  39      76.480  54.746  63.511  1.00 24.61           C  
ATOM   3919  O   ARG C  39      76.368  55.979  63.457  1.00 24.50           O  
ATOM   3920  CB  ARG C  39      76.413  53.897  65.881  1.00 24.19           C  
ATOM   3921  CG  ARG C  39      75.584  53.275  66.991  1.00 23.19           C  
ATOM   3922  CD  ARG C  39      76.444  52.822  68.160  1.00 22.95           C  
ATOM   3923  NE  ARG C  39      77.516  51.931  67.723  1.00 22.81           N  
ATOM   3924  CZ  ARG C  39      78.543  51.567  68.485  1.00 24.55           C  
ATOM   3925  NH1 ARG C  39      78.644  52.010  69.739  1.00 25.54           N  
ATOM   3926  NH2 ARG C  39      79.470  50.758  67.994  1.00 24.70           N  
ATOM   3927  N   ARG C  40      77.296  54.058  62.712  1.00 24.90           N  
ATOM   3928  CA  ARG C  40      78.079  54.721  61.659  1.00 25.09           C  
ATOM   3929  C   ARG C  40      77.238  54.919  60.394  1.00 25.79           C  
ATOM   3930  O   ARG C  40      77.258  54.092  59.475  1.00 25.53           O  
ATOM   3931  CB  ARG C  40      79.363  53.939  61.335  1.00 25.01           C  
ATOM   3932  CG  ARG C  40      80.409  53.904  62.449  1.00 24.79           C  
ATOM   3933  CD  ARG C  40      81.524  52.881  62.155  1.00 24.77           C  
ATOM   3934  NE  ARG C  40      81.034  51.494  62.102  1.00 23.74           N  
ATOM   3935  CZ  ARG C  40      81.793  50.428  61.834  1.00 23.83           C  
ATOM   3936  NH1 ARG C  40      83.097  50.559  61.599  1.00 23.02           N  
ATOM   3937  NH2 ARG C  40      81.252  49.218  61.808  1.00 21.01           N  
ATOM   3938  N   VAL C  41      76.508  56.031  60.341  1.00 26.55           N  
ATOM   3939  CA  VAL C  41      75.585  56.283  59.228  1.00 27.35           C  
ATOM   3940  C   VAL C  41      76.305  56.329  57.877  1.00 27.48           C  
ATOM   3941  O   VAL C  41      75.766  55.869  56.873  1.00 27.48           O  
ATOM   3942  CB  VAL C  41      74.782  57.579  59.430  1.00 28.06           C  
ATOM   3943  CG1 VAL C  41      73.418  57.485  58.708  1.00 28.39           C  
ATOM   3944  CG2 VAL C  41      74.599  57.865  60.914  1.00 28.19           C  
ATOM   3945  N   GLU C  42      77.521  56.869  57.875  1.00 27.80           N  
ATOM   3946  CA  GLU C  42      78.355  56.975  56.675  1.00 28.51           C  
ATOM   3947  C   GLU C  42      78.567  55.603  56.027  1.00 28.15           C  
ATOM   3948  O   GLU C  42      78.481  55.473  54.799  1.00 27.79           O  
ATOM   3949  CB  GLU C  42      79.717  57.622  56.995  1.00 29.01           C  
ATOM   3950  CG  GLU C  42      79.787  58.421  58.316  1.00 31.26           C  
ATOM   3951  CD  GLU C  42      79.999  57.538  59.552  1.00 33.57           C  
ATOM   3952  OE1 GLU C  42      80.722  56.517  59.461  1.00 34.87           O  
ATOM   3953  OE2 GLU C  42      79.441  57.869  60.621  1.00 35.10           O  
ATOM   3954  N   LYS C  43      78.842  54.598  56.862  1.00 27.88           N  
ATOM   3955  CA  LYS C  43      78.973  53.208  56.422  1.00 27.72           C  
ATOM   3956  C   LYS C  43      77.651  52.695  55.852  1.00 27.18           C  
ATOM   3957  O   LYS C  43      77.624  52.108  54.767  1.00 26.91           O  
ATOM   3958  CB  LYS C  43      79.405  52.300  57.582  1.00 28.29           C  
ATOM   3959  CG  LYS C  43      80.781  52.580  58.172  1.00 30.22           C  
ATOM   3960  CD  LYS C  43      81.913  52.119  57.260  1.00 33.53           C  
ATOM   3961  CE  LYS C  43      83.121  51.674  58.089  1.00 34.56           C  
ATOM   3962  NZ  LYS C  43      84.359  51.610  57.253  1.00 36.07           N  
ATOM   3963  N   LEU C  44      76.567  52.917  56.600  1.00 26.52           N  
ATOM   3964  CA  LEU C  44      75.220  52.519  56.186  1.00 26.05           C  
ATOM   3965  C   LEU C  44      74.794  53.118  54.856  1.00 26.17           C  
ATOM   3966  O   LEU C  44      74.250  52.413  54.006  1.00 26.21           O  
ATOM   3967  CB  LEU C  44      74.195  52.906  57.251  1.00 26.14           C  
ATOM   3968  CG  LEU C  44      74.146  52.071  58.529  1.00 25.63           C  
ATOM   3969  CD1 LEU C  44      73.181  52.727  59.487  1.00 26.13           C  
ATOM   3970  CD2 LEU C  44      73.710  50.652  58.229  1.00 25.21           C  
ATOM   3971  N   ARG C  45      75.040  54.418  54.687  1.00 25.90           N  
ATOM   3972  CA  ARG C  45      74.690  55.123  53.457  1.00 25.89           C  
ATOM   3973  C   ARG C  45      75.422  54.522  52.269  1.00 25.50           C  
ATOM   3974  O   ARG C  45      74.829  54.313  51.216  1.00 25.11           O  
ATOM   3975  CB  ARG C  45      75.022  56.610  53.557  1.00 26.18           C  
ATOM   3976  CG  ARG C  45      74.173  57.386  54.533  1.00 27.71           C  
ATOM   3977  CD  ARG C  45      73.941  58.813  54.052  1.00 30.25           C  
ATOM   3978  NE  ARG C  45      73.576  59.709  55.151  1.00 32.40           N  
ATOM   3979  CZ  ARG C  45      72.505  59.554  55.930  1.00 32.98           C  
ATOM   3980  NH1 ARG C  45      71.675  58.529  55.749  1.00 32.92           N  
ATOM   3981  NH2 ARG C  45      72.269  60.425  56.900  1.00 32.84           N  
ATOM   3982  N   ALA C  46      76.710  54.236  52.463  1.00 25.51           N  
ATOM   3983  CA  ALA C  46      77.543  53.619  51.429  1.00 25.43           C  
ATOM   3984  C   ALA C  46      77.030  52.229  51.048  1.00 25.17           C  
ATOM   3985  O   ALA C  46      76.993  51.873  49.871  1.00 24.92           O  
ATOM   3986  CB  ALA C  46      78.994  53.553  51.890  1.00 25.72           C  
ATOM   3987  N   LEU C  47      76.624  51.450  52.048  1.00 24.85           N  
ATOM   3988  CA  LEU C  47      76.016  50.145  51.799  1.00 24.49           C  
ATOM   3989  C   LEU C  47      74.648  50.294  51.116  1.00 24.63           C  
ATOM   3990  O   LEU C  47      74.360  49.597  50.136  1.00 24.55           O  
ATOM   3991  CB  LEU C  47      75.897  49.345  53.098  1.00 24.14           C  
ATOM   3992  CG  LEU C  47      75.221  47.975  53.027  1.00 24.09           C  
ATOM   3993  CD1 LEU C  47      75.919  47.016  52.047  1.00 23.45           C  
ATOM   3994  CD2 LEU C  47      75.131  47.369  54.428  1.00 23.74           C  
ATOM   3995  N   GLY C  48      73.822  51.204  51.633  1.00 24.86           N  
ATOM   3996  CA  GLY C  48      72.505  51.483  51.058  1.00 25.67           C  
ATOM   3997  C   GLY C  48      72.606  51.845  49.586  1.00 26.66           C  
ATOM   3998  O   GLY C  48      71.892  51.280  48.748  1.00 26.66           O  
ATOM   3999  N   ASP C  49      73.514  52.772  49.277  1.00 27.21           N  
ATOM   4000  CA  ASP C  49      73.769  53.201  47.899  1.00 28.28           C  
ATOM   4001  C   ASP C  49      74.138  52.021  47.013  1.00 28.44           C  
ATOM   4002  O   ASP C  49      73.594  51.876  45.922  1.00 28.58           O  
ATOM   4003  CB  ASP C  49      74.888  54.249  47.853  1.00 28.67           C  
ATOM   4004  CG  ASP C  49      74.475  55.581  48.456  1.00 30.24           C  
ATOM   4005  OD1 ASP C  49      73.263  55.794  48.691  1.00 32.22           O  
ATOM   4006  OD2 ASP C  49      75.370  56.421  48.691  1.00 31.39           O  
ATOM   4007  N   GLU C  50      75.054  51.182  47.501  1.00 28.91           N  
ATOM   4008  CA  GLU C  50      75.493  49.976  46.797  1.00 29.55           C  
ATOM   4009  C   GLU C  50      74.308  49.054  46.513  1.00 28.77           C  
ATOM   4010  O   GLU C  50      74.103  48.624  45.375  1.00 28.60           O  
ATOM   4011  CB  GLU C  50      76.553  49.235  47.620  1.00 29.57           C  
ATOM   4012  CG  GLU C  50      77.504  48.384  46.788  1.00 31.48           C  
ATOM   4013  CD  GLU C  50      78.671  47.833  47.599  1.00 31.91           C  
ATOM   4014  OE1 GLU C  50      79.356  48.623  48.290  1.00 35.70           O  
ATOM   4015  OE2 GLU C  50      78.915  46.609  47.537  1.00 34.63           O  
ATOM   4016  N   LEU C  51      73.525  48.780  47.555  1.00 28.25           N  
ATOM   4017  CA  LEU C  51      72.357  47.910  47.449  1.00 28.04           C  
ATOM   4018  C   LEU C  51      71.271  48.478  46.538  1.00 27.83           C  
ATOM   4019  O   LEU C  51      70.736  47.757  45.691  1.00 27.95           O  
ATOM   4020  CB  LEU C  51      71.794  47.591  48.833  1.00 28.16           C  
ATOM   4021  CG  LEU C  51      72.700  46.728  49.716  1.00 28.48           C  
ATOM   4022  CD1 LEU C  51      71.980  46.335  51.002  1.00 27.90           C  
ATOM   4023  CD2 LEU C  51      73.196  45.496  48.958  1.00 28.59           C  
ATOM   4024  N   THR C  52      70.958  49.761  46.715  1.00 27.63           N  
ATOM   4025  CA  THR C  52      69.993  50.472  45.866  1.00 27.54           C  
ATOM   4026  C   THR C  52      70.407  50.397  44.393  1.00 27.67           C  
ATOM   4027  O   THR C  52      69.563  50.201  43.511  1.00 27.43           O  
ATOM   4028  CB  THR C  52      69.855  51.964  46.284  1.00 27.51           C  
ATOM   4029  OG1 THR C  52      69.565  52.057  47.688  1.00 27.09           O  
ATOM   4030  CG2 THR C  52      68.748  52.660  45.496  1.00 27.80           C  
ATOM   4031  N   ALA C  53      71.713  50.541  44.144  1.00 27.91           N  
ATOM   4032  CA  ALA C  53      72.281  50.510  42.787  1.00 28.13           C  
ATOM   4033  C   ALA C  53      72.104  49.160  42.093  1.00 28.30           C  
ATOM   4034  O   ALA C  53      72.044  49.092  40.860  1.00 28.45           O  
ATOM   4035  CB  ALA C  53      73.752  50.905  42.816  1.00 28.09           C  
ATOM   4036  N   ALA C  54      72.029  48.096  42.891  1.00 28.40           N  
ATOM   4037  CA  ALA C  54      71.777  46.745  42.394  1.00 28.43           C  
ATOM   4038  C   ALA C  54      70.281  46.399  42.353  1.00 28.42           C  
ATOM   4039  O   ALA C  54      69.912  45.249  42.107  1.00 29.01           O  
ATOM   4040  CB  ALA C  54      72.541  45.728  43.230  1.00 28.58           C  
ATOM   4041  N   GLY C  55      69.427  47.391  42.597  1.00 28.10           N  
ATOM   4042  CA  GLY C  55      67.977  47.198  42.510  1.00 27.34           C  
ATOM   4043  C   GLY C  55      67.260  46.832  43.804  1.00 26.89           C  
ATOM   4044  O   GLY C  55      66.071  46.500  43.781  1.00 26.74           O  
ATOM   4045  N   ALA C  56      67.969  46.896  44.930  1.00 26.27           N  
ATOM   4046  CA  ALA C  56      67.346  46.647  46.235  1.00 25.84           C  
ATOM   4047  C   ALA C  56      66.560  47.861  46.735  1.00 25.64           C  
ATOM   4048  O   ALA C  56      66.807  49.004  46.315  1.00 25.33           O  
ATOM   4049  CB  ALA C  56      68.386  46.220  47.269  1.00 25.94           C  
ATOM   4050  N   LYS C  57      65.597  47.583  47.609  1.00 25.11           N  
ATOM   4051  CA  LYS C  57      64.830  48.591  48.328  1.00 25.43           C  
ATOM   4052  C   LYS C  57      65.406  48.672  49.740  1.00 24.85           C  
ATOM   4053  O   LYS C  57      65.452  47.668  50.449  1.00 24.85           O  
ATOM   4054  CB  LYS C  57      63.361  48.175  48.356  1.00 25.91           C  
ATOM   4055  CG  LYS C  57      62.424  49.140  49.045  1.00 27.82           C  
ATOM   4056  CD  LYS C  57      60.986  48.750  48.756  1.00 29.84           C  
ATOM   4057  CE  LYS C  57      60.041  49.912  48.969  1.00 31.02           C  
ATOM   4058  NZ  LYS C  57      58.654  49.514  48.612  1.00 32.14           N  
ATOM   4059  N   VAL C  58      65.866  49.858  50.130  1.00 24.34           N  
ATOM   4060  CA  VAL C  58      66.663  50.030  51.346  1.00 23.79           C  
ATOM   4061  C   VAL C  58      66.140  51.177  52.215  1.00 23.66           C  
ATOM   4062  O   VAL C  58      65.750  52.216  51.702  1.00 23.65           O  
ATOM   4063  CB  VAL C  58      68.164  50.282  51.002  1.00 23.82           C  
ATOM   4064  CG1 VAL C  58      69.002  50.445  52.264  1.00 23.28           C  
ATOM   4065  CG2 VAL C  58      68.727  49.152  50.142  1.00 23.28           C  
ATOM   4066  N   HIS C  59      66.135  50.976  53.529  1.00 23.47           N  
ATOM   4067  CA  HIS C  59      65.783  52.020  54.488  1.00 23.27           C  
ATOM   4068  C   HIS C  59      66.928  52.154  55.490  1.00 23.34           C  
ATOM   4069  O   HIS C  59      67.227  51.210  56.220  1.00 22.96           O  
ATOM   4070  CB  HIS C  59      64.471  51.656  55.194  1.00 23.67           C  
ATOM   4071  CG  HIS C  59      64.012  52.667  56.197  1.00 24.04           C  
ATOM   4072  ND1 HIS C  59      63.703  53.965  55.859  1.00 24.42           N  
ATOM   4073  CD2 HIS C  59      63.788  52.561  57.529  1.00 25.29           C  
ATOM   4074  CE1 HIS C  59      63.321  54.621  56.942  1.00 25.27           C  
ATOM   4075  NE2 HIS C  59      63.368  53.793  57.969  1.00 25.84           N  
ATOM   4076  N   VAL C  60      67.580  53.314  55.506  1.00 23.02           N  
ATOM   4077  CA  VAL C  60      68.749  53.521  56.368  1.00 23.05           C  
ATOM   4078  C   VAL C  60      68.320  54.008  57.761  1.00 23.16           C  
ATOM   4079  O   VAL C  60      67.579  54.989  57.874  1.00 23.16           O  
ATOM   4080  CB  VAL C  60      69.766  54.504  55.717  1.00 22.91           C  
ATOM   4081  CG1 VAL C  60      70.889  54.877  56.681  1.00 22.30           C  
ATOM   4082  CG2 VAL C  60      70.346  53.909  54.434  1.00 23.13           C  
ATOM   4083  N   LEU C  61      68.786  53.316  58.804  1.00 22.94           N  
ATOM   4084  CA  LEU C  61      68.452  53.659  60.190  1.00 23.29           C  
ATOM   4085  C   LEU C  61      69.693  53.949  61.022  1.00 23.30           C  
ATOM   4086  O   LEU C  61      70.465  53.040  61.337  1.00 23.34           O  
ATOM   4087  CB  LEU C  61      67.684  52.513  60.857  1.00 23.12           C  
ATOM   4088  CG  LEU C  61      66.320  52.079  60.326  1.00 23.88           C  
ATOM   4089  CD1 LEU C  61      66.045  50.658  60.791  1.00 23.53           C  
ATOM   4090  CD2 LEU C  61      65.222  53.031  60.777  1.00 23.20           C  
ATOM   4091  N   GLU C  62      69.894  55.211  61.379  1.00 23.32           N  
ATOM   4092  CA  GLU C  62      70.912  55.545  62.364  1.00 23.46           C  
ATOM   4093  C   GLU C  62      70.360  55.144  63.725  1.00 23.06           C  
ATOM   4094  O   GLU C  62      69.355  55.683  64.179  1.00 22.39           O  
ATOM   4095  CB  GLU C  62      71.266  57.031  62.325  1.00 24.01           C  
ATOM   4096  CG  GLU C  62      72.216  57.450  63.454  1.00 24.59           C  
ATOM   4097  CD  GLU C  62      72.607  58.916  63.381  1.00 24.63           C  
ATOM   4098  OE1 GLU C  62      71.897  59.697  62.716  1.00 27.15           O  
ATOM   4099  OE2 GLU C  62      73.639  59.279  63.981  1.00 25.92           O  
ATOM   4100  N   LEU C  63      71.003  54.165  64.357  1.00 22.68           N  
ATOM   4101  CA  LEU C  63      70.465  53.590  65.588  1.00 22.67           C  
ATOM   4102  C   LEU C  63      71.534  53.061  66.520  1.00 22.77           C  
ATOM   4103  O   LEU C  63      72.461  52.370  66.087  1.00 22.23           O  
ATOM   4104  CB  LEU C  63      69.494  52.448  65.255  1.00 22.49           C  
ATOM   4105  CG  LEU C  63      68.877  51.639  66.401  1.00 22.73           C  
ATOM   4106  CD1 LEU C  63      67.983  52.515  67.269  1.00 22.48           C  
ATOM   4107  CD2 LEU C  63      68.107  50.451  65.827  1.00 22.32           C  
ATOM   4108  N   ASP C  64      71.370  53.389  67.802  1.00 22.85           N  
ATOM   4109  CA  ASP C  64      72.054  52.716  68.904  1.00 23.18           C  
ATOM   4110  C   ASP C  64      71.034  51.745  69.529  1.00 23.14           C  
ATOM   4111  O   ASP C  64      70.016  52.183  70.052  1.00 23.06           O  
ATOM   4112  CB  ASP C  64      72.521  53.779  69.908  1.00 23.52           C  
ATOM   4113  CG  ASP C  64      73.219  53.197  71.135  1.00 24.63           C  
ATOM   4114  OD1 ASP C  64      73.370  51.964  71.254  1.00 25.19           O  
ATOM   4115  OD2 ASP C  64      73.621  54.005  71.995  1.00 25.86           O  
ATOM   4116  N   VAL C  65      71.288  50.434  69.458  1.00 23.07           N  
ATOM   4117  CA  VAL C  65      70.309  49.451  69.968  1.00 23.78           C  
ATOM   4118  C   VAL C  65      70.088  49.569  71.475  1.00 24.33           C  
ATOM   4119  O   VAL C  65      69.072  49.109  71.987  1.00 24.74           O  
ATOM   4120  CB  VAL C  65      70.642  47.964  69.615  1.00 23.23           C  
ATOM   4121  CG1 VAL C  65      70.535  47.720  68.110  1.00 23.69           C  
ATOM   4122  CG2 VAL C  65      72.003  47.547  70.145  1.00 22.96           C  
ATOM   4123  N   ALA C  66      71.037  50.196  72.167  1.00 24.67           N  
ATOM   4124  CA  ALA C  66      70.957  50.364  73.615  1.00 25.51           C  
ATOM   4125  C   ALA C  66      69.929  51.439  73.991  1.00 26.11           C  
ATOM   4126  O   ALA C  66      69.533  51.556  75.161  1.00 26.59           O  
ATOM   4127  CB  ALA C  66      72.324  50.715  74.164  1.00 25.97           C  
ATOM   4128  N   ASP C  67      69.517  52.218  72.988  1.00 25.94           N  
ATOM   4129  CA  ASP C  67      68.584  53.336  73.143  1.00 26.52           C  
ATOM   4130  C   ASP C  67      67.146  52.842  72.953  1.00 26.82           C  
ATOM   4131  O   ASP C  67      66.646  52.748  71.820  1.00 26.79           O  
ATOM   4132  CB  ASP C  67      68.950  54.448  72.131  1.00 26.21           C  
ATOM   4133  CG  ASP C  67      68.032  55.670  72.200  1.00 26.86           C  
ATOM   4134  OD1 ASP C  67      67.301  55.862  73.192  1.00 27.40           O  
ATOM   4135  OD2 ASP C  67      68.067  56.462  71.238  1.00 26.83           O  
ATOM   4136  N   ARG C  68      66.496  52.528  74.073  1.00 27.01           N  
ATOM   4137  CA  ARG C  68      65.125  52.009  74.080  1.00 27.46           C  
ATOM   4138  C   ARG C  68      64.202  52.834  73.177  1.00 26.91           C  
ATOM   4139  O   ARG C  68      63.503  52.276  72.327  1.00 26.81           O  
ATOM   4140  CB  ARG C  68      64.592  51.912  75.527  1.00 27.78           C  
ATOM   4141  CG  ARG C  68      63.135  51.448  75.661  1.00 28.31           C  
ATOM   4142  CD  ARG C  68      62.597  51.628  77.097  1.00 29.65           C  
ATOM   4143  NE  ARG C  68      62.823  52.973  77.648  1.00 32.06           N  
ATOM   4144  CZ  ARG C  68      62.069  54.046  77.405  1.00 34.67           C  
ATOM   4145  NH1 ARG C  68      61.008  53.978  76.602  1.00 36.00           N  
ATOM   4146  NH2 ARG C  68      62.389  55.208  77.959  1.00 34.34           N  
ATOM   4147  N   GLN C  69      64.233  54.156  73.331  1.00 26.71           N  
ATOM   4148  CA  GLN C  69      63.423  55.052  72.495  1.00 26.47           C  
ATOM   4149  C   GLN C  69      63.824  55.019  71.019  1.00 26.46           C  
ATOM   4150  O   GLN C  69      62.954  55.074  70.122  1.00 25.96           O  
ATOM   4151  CB  GLN C  69      63.482  56.492  72.999  1.00 26.83           C  
ATOM   4152  CG  GLN C  69      62.798  56.718  74.340  1.00 28.09           C  
ATOM   4153  CD  GLN C  69      62.818  58.172  74.755  1.00 28.57           C  
ATOM   4154  OE1 GLN C  69      62.346  59.048  74.024  1.00 30.04           O  
ATOM   4155  NE2 GLN C  69      63.365  58.440  75.936  1.00 30.33           N  
ATOM   4156  N   GLY C  70      65.133  54.944  70.768  1.00 25.52           N  
ATOM   4157  CA  GLY C  70      65.645  54.860  69.402  1.00 24.74           C  
ATOM   4158  C   GLY C  70      65.123  53.604  68.732  1.00 24.41           C  
ATOM   4159  O   GLY C  70      64.708  53.631  67.576  1.00 24.20           O  
ATOM   4160  N   VAL C  71      65.139  52.502  69.477  1.00 24.27           N  
ATOM   4161  CA  VAL C  71      64.662  51.206  68.985  1.00 24.01           C  
ATOM   4162  C   VAL C  71      63.198  51.268  68.510  1.00 24.16           C  
ATOM   4163  O   VAL C  71      62.901  50.887  67.376  1.00 24.02           O  
ATOM   4164  CB  VAL C  71      64.881  50.100  70.050  1.00 24.08           C  
ATOM   4165  CG1 VAL C  71      63.985  48.901  69.797  1.00 23.91           C  
ATOM   4166  CG2 VAL C  71      66.355  49.691  70.078  1.00 24.13           C  
ATOM   4167  N   ASP C  72      62.301  51.773  69.361  1.00 24.12           N  
ATOM   4168  CA  ASP C  72      60.882  51.889  69.007  1.00 24.76           C  
ATOM   4169  C   ASP C  72      60.701  52.736  67.747  1.00 24.20           C  
ATOM   4170  O   ASP C  72      59.948  52.368  66.836  1.00 24.55           O  
ATOM   4171  CB  ASP C  72      60.068  52.492  70.167  1.00 25.14           C  
ATOM   4172  CG  ASP C  72      59.998  51.576  71.388  1.00 27.27           C  
ATOM   4173  OD1 ASP C  72      59.900  50.339  71.225  1.00 30.62           O  
ATOM   4174  OD2 ASP C  72      60.027  52.099  72.525  1.00 29.74           O  
ATOM   4175  N   ALA C  73      61.416  53.860  67.695  1.00 23.72           N  
ATOM   4176  CA  ALA C  73      61.377  54.758  66.542  1.00 23.17           C  
ATOM   4177  C   ALA C  73      61.883  54.096  65.251  1.00 22.86           C  
ATOM   4178  O   ALA C  73      61.328  54.332  64.173  1.00 22.84           O  
ATOM   4179  CB  ALA C  73      62.158  56.037  66.837  1.00 22.87           C  
ATOM   4180  N   ALA C  74      62.939  53.290  65.364  1.00 22.61           N  
ATOM   4181  CA  ALA C  74      63.521  52.571  64.217  1.00 22.33           C  
ATOM   4182  C   ALA C  74      62.584  51.504  63.638  1.00 22.20           C  
ATOM   4183  O   ALA C  74      62.468  51.376  62.417  1.00 22.30           O  
ATOM   4184  CB  ALA C  74      64.871  51.956  64.586  1.00 22.13           C  
ATOM   4185  N   VAL C  75      61.923  50.747  64.509  1.00 21.88           N  
ATOM   4186  CA  VAL C  75      60.871  49.814  64.095  1.00 21.93           C  
ATOM   4187  C   VAL C  75      59.699  50.535  63.409  1.00 22.37           C  
ATOM   4188  O   VAL C  75      59.259  50.125  62.329  1.00 22.27           O  
ATOM   4189  CB  VAL C  75      60.388  48.941  65.291  1.00 22.06           C  
ATOM   4190  CG1 VAL C  75      59.180  48.085  64.906  1.00 22.44           C  
ATOM   4191  CG2 VAL C  75      61.524  48.056  65.775  1.00 20.63           C  
ATOM   4192  N   ALA C  76      59.217  51.621  64.011  1.00 22.53           N  
ATOM   4193  CA  ALA C  76      58.125  52.403  63.428  1.00 23.01           C  
ATOM   4194  C   ALA C  76      58.491  52.980  62.051  1.00 23.28           C  
ATOM   4195  O   ALA C  76      57.699  52.910  61.104  1.00 23.50           O  
ATOM   4196  CB  ALA C  76      57.703  53.516  64.382  1.00 22.79           C  
ATOM   4197  N   SER C  77      59.700  53.537  61.955  1.00 23.64           N  
ATOM   4198  CA  SER C  77      60.240  54.094  60.709  1.00 23.98           C  
ATOM   4199  C   SER C  77      60.303  53.042  59.609  1.00 23.86           C  
ATOM   4200  O   SER C  77      60.018  53.327  58.440  1.00 23.64           O  
ATOM   4201  CB  SER C  77      61.651  54.622  60.956  1.00 23.90           C  
ATOM   4202  OG  SER C  77      62.040  55.504  59.930  1.00 26.38           O  
ATOM   4203  N   THR C  78      60.694  51.829  59.996  1.00 23.60           N  
ATOM   4204  CA  THR C  78      60.823  50.700  59.078  1.00 24.05           C  
ATOM   4205  C   THR C  78      59.476  50.243  58.517  1.00 24.09           C  
ATOM   4206  O   THR C  78      59.343  50.067  57.305  1.00 23.81           O  
ATOM   4207  CB  THR C  78      61.522  49.510  59.761  1.00 23.66           C  
ATOM   4208  OG1 THR C  78      62.842  49.904  60.168  1.00 24.68           O  
ATOM   4209  CG2 THR C  78      61.612  48.317  58.818  1.00 23.56           C  
ATOM   4210  N   VAL C  79      58.490  50.056  59.396  1.00 24.62           N  
ATOM   4211  CA  VAL C  79      57.163  49.577  58.981  1.00 25.18           C  
ATOM   4212  C   VAL C  79      56.437  50.623  58.132  1.00 25.56           C  
ATOM   4213  O   VAL C  79      55.667  50.284  57.230  1.00 25.92           O  
ATOM   4214  CB  VAL C  79      56.302  49.129  60.196  1.00 25.30           C  
ATOM   4215  CG1 VAL C  79      54.891  48.729  59.776  1.00 25.15           C  
ATOM   4216  CG2 VAL C  79      56.978  47.958  60.922  1.00 25.12           C  
ATOM   4217  N   GLU C  80      56.701  51.894  58.411  1.00 25.62           N  
ATOM   4218  CA  GLU C  80      56.100  52.971  57.645  1.00 26.13           C  
ATOM   4219  C   GLU C  80      56.746  53.047  56.252  1.00 25.78           C  
ATOM   4220  O   GLU C  80      56.045  53.174  55.244  1.00 25.71           O  
ATOM   4221  CB  GLU C  80      56.198  54.296  58.419  1.00 26.20           C  
ATOM   4222  CG  GLU C  80      55.187  55.367  57.998  1.00 28.60           C  
ATOM   4223  CD  GLU C  80      55.656  56.167  56.798  1.00 30.85           C  
ATOM   4224  OE1 GLU C  80      56.882  56.177  56.540  1.00 32.65           O  
ATOM   4225  OE2 GLU C  80      54.808  56.783  56.113  1.00 31.75           O  
ATOM   4226  N   ALA C  81      58.073  52.932  56.192  1.00 25.42           N  
ATOM   4227  CA  ALA C  81      58.795  53.055  54.924  1.00 25.49           C  
ATOM   4228  C   ALA C  81      58.657  51.815  54.030  1.00 25.38           C  
ATOM   4229  O   ALA C  81      58.543  51.936  52.805  1.00 25.42           O  
ATOM   4230  CB  ALA C  81      60.268  53.371  55.177  1.00 25.68           C  
ATOM   4231  N   LEU C  82      58.646  50.632  54.646  1.00 25.11           N  
ATOM   4232  CA  LEU C  82      58.712  49.374  53.893  1.00 25.11           C  
ATOM   4233  C   LEU C  82      57.441  48.509  53.914  1.00 25.28           C  
ATOM   4234  O   LEU C  82      57.374  47.501  53.205  1.00 26.06           O  
ATOM   4235  CB  LEU C  82      59.958  48.555  54.296  1.00 24.71           C  
ATOM   4236  CG  LEU C  82      61.335  49.215  54.113  1.00 24.34           C  
ATOM   4237  CD1 LEU C  82      62.450  48.256  54.437  1.00 21.94           C  
ATOM   4238  CD2 LEU C  82      61.529  49.800  52.692  1.00 23.89           C  
ATOM   4239  N   GLY C  83      56.439  48.901  54.701  1.00 25.38           N  
ATOM   4240  CA  GLY C  83      55.121  48.247  54.667  1.00 25.43           C  
ATOM   4241  C   GLY C  83      54.802  47.311  55.823  1.00 25.46           C  
ATOM   4242  O   GLY C  83      53.628  47.085  56.152  1.00 25.77           O  
ATOM   4243  N   GLY C  84      55.844  46.770  56.442  1.00 25.05           N  
ATOM   4244  CA  GLY C  84      55.699  45.813  57.536  1.00 24.71           C  
ATOM   4245  C   GLY C  84      57.057  45.283  57.951  1.00 24.42           C  
ATOM   4246  O   GLY C  84      58.082  45.875  57.612  1.00 23.93           O  
ATOM   4247  N   LEU C  85      57.060  44.178  58.698  1.00 24.31           N  
ATOM   4248  CA  LEU C  85      58.301  43.523  59.105  1.00 24.42           C  
ATOM   4249  C   LEU C  85      58.147  42.002  59.100  1.00 23.90           C  
ATOM   4250  O   LEU C  85      57.254  41.451  59.744  1.00 24.02           O  
ATOM   4251  CB  LEU C  85      58.747  44.014  60.490  1.00 24.68           C  
ATOM   4252  CG  LEU C  85      60.132  43.605  61.008  1.00 25.35           C  
ATOM   4253  CD1 LEU C  85      61.268  44.055  60.094  1.00 25.17           C  
ATOM   4254  CD2 LEU C  85      60.338  44.157  62.421  1.00 25.05           C  
ATOM   4255  N   ASP C  86      59.032  41.333  58.376  1.00 23.64           N  
ATOM   4256  CA  ASP C  86      58.955  39.879  58.209  1.00 23.44           C  
ATOM   4257  C   ASP C  86      60.106  39.113  58.856  1.00 23.13           C  
ATOM   4258  O   ASP C  86      59.945  37.955  59.266  1.00 22.72           O  
ATOM   4259  CB  ASP C  86      58.943  39.546  56.722  1.00 23.80           C  
ATOM   4260  CG  ASP C  86      57.699  40.035  56.027  1.00 23.90           C  
ATOM   4261  OD1 ASP C  86      56.642  39.386  56.174  1.00 25.11           O  
ATOM   4262  OD2 ASP C  86      57.784  41.057  55.317  1.00 23.28           O  
ATOM   4263  N   ILE C  87      61.277  39.747  58.882  1.00 22.64           N  
ATOM   4264  CA  ILE C  87      62.494  39.157  59.440  1.00 22.49           C  
ATOM   4265  C   ILE C  87      63.228  40.220  60.242  1.00 21.95           C  
ATOM   4266  O   ILE C  87      63.435  41.333  59.756  1.00 22.26           O  
ATOM   4267  CB  ILE C  87      63.459  38.639  58.328  1.00 21.99           C  
ATOM   4268  CG1 ILE C  87      62.774  37.573  57.466  1.00 23.12           C  
ATOM   4269  CG2 ILE C  87      64.767  38.101  58.945  1.00 23.28           C  
ATOM   4270  CD1 ILE C  87      63.547  37.178  56.203  1.00 23.13           C  
ATOM   4271  N   LEU C  88      63.596  39.885  61.478  1.00 22.04           N  
ATOM   4272  CA  LEU C  88      64.455  40.756  62.273  1.00 21.70           C  
ATOM   4273  C   LEU C  88      65.763  40.015  62.506  1.00 21.75           C  
ATOM   4274  O   LEU C  88      65.747  38.855  62.902  1.00 21.97           O  
ATOM   4275  CB  LEU C  88      63.795  41.117  63.609  1.00 21.85           C  
ATOM   4276  CG  LEU C  88      64.688  41.725  64.705  1.00 21.58           C  
ATOM   4277  CD1 LEU C  88      65.298  43.048  64.246  1.00 23.49           C  
ATOM   4278  CD2 LEU C  88      63.928  41.895  66.020  1.00 21.64           C  
ATOM   4279  N   VAL C  89      66.886  40.686  62.269  1.00 21.43           N  
ATOM   4280  CA  VAL C  89      68.195  40.108  62.571  1.00 21.28           C  
ATOM   4281  C   VAL C  89      68.875  40.970  63.634  1.00 21.43           C  
ATOM   4282  O   VAL C  89      69.325  42.087  63.344  1.00 21.00           O  
ATOM   4283  CB  VAL C  89      69.101  39.951  61.328  1.00 21.42           C  
ATOM   4284  CG1 VAL C  89      70.384  39.201  61.700  1.00 22.06           C  
ATOM   4285  CG2 VAL C  89      68.392  39.176  60.227  1.00 21.65           C  
ATOM   4286  N   ASN C  90      68.893  40.459  64.862  1.00 21.05           N  
ATOM   4287  CA  ASN C  90      69.530  41.137  65.996  1.00 21.17           C  
ATOM   4288  C   ASN C  90      71.016  40.830  66.016  1.00 21.35           C  
ATOM   4289  O   ASN C  90      71.472  39.902  66.704  1.00 22.00           O  
ATOM   4290  CB  ASN C  90      68.886  40.723  67.321  1.00 21.54           C  
ATOM   4291  CG  ASN C  90      67.612  41.486  67.614  1.00 22.56           C  
ATOM   4292  OD1 ASN C  90      67.572  42.724  67.506  1.00 22.01           O  
ATOM   4293  ND2 ASN C  90      66.567  40.762  68.008  1.00 23.20           N  
ATOM   4294  N   ASN C  91      71.765  41.606  65.245  1.00 21.03           N  
ATOM   4295  CA  ASN C  91      73.181  41.315  65.029  1.00 21.04           C  
ATOM   4296  C   ASN C  91      74.145  42.308  65.710  1.00 20.86           C  
ATOM   4297  O   ASN C  91      75.281  41.941  66.048  1.00 20.47           O  
ATOM   4298  CB  ASN C  91      73.451  41.138  63.527  1.00 20.59           C  
ATOM   4299  CG  ASN C  91      74.899  41.337  63.165  1.00 20.92           C  
ATOM   4300  OD1 ASN C  91      75.330  42.456  62.846  1.00 21.84           O  
ATOM   4301  ND2 ASN C  91      75.662  40.269  63.221  1.00 17.07           N  
ATOM   4302  N   ALA C  92      73.698  43.542  65.936  1.00 20.81           N  
ATOM   4303  CA  ALA C  92      74.528  44.521  66.668  1.00 21.32           C  
ATOM   4304  C   ALA C  92      75.150  43.889  67.923  1.00 21.09           C  
ATOM   4305  O   ALA C  92      74.463  43.220  68.699  1.00 21.76           O  
ATOM   4306  CB  ALA C  92      73.717  45.748  67.054  1.00 21.39           C  
ATOM   4307  N   GLY C  93      76.450  44.083  68.112  1.00 20.95           N  
ATOM   4308  CA  GLY C  93      77.107  43.572  69.314  1.00 21.46           C  
ATOM   4309  C   GLY C  93      78.571  43.945  69.430  1.00 21.40           C  
ATOM   4310  O   GLY C  93      79.206  44.317  68.440  1.00 21.03           O  
ATOM   4311  N   ILE C  94      79.105  43.831  70.642  1.00 21.97           N  
ATOM   4312  CA  ILE C  94      80.523  44.125  70.917  1.00 22.44           C  
ATOM   4313  C   ILE C  94      81.139  43.037  71.800  1.00 22.62           C  
ATOM   4314  O   ILE C  94      80.458  42.448  72.642  1.00 22.38           O  
ATOM   4315  CB  ILE C  94      80.700  45.508  71.591  1.00 22.81           C  
ATOM   4316  CG1 ILE C  94      79.729  45.656  72.764  1.00 23.42           C  
ATOM   4317  CG2 ILE C  94      80.511  46.647  70.574  1.00 24.44           C  
ATOM   4318  CD1 ILE C  94      80.112  46.706  73.724  1.00 26.90           C  
HETATM 4319  N   MSE C  95      82.427  42.761  71.602  1.00 22.93           N  
HETATM 4320  CA  MSE C  95      83.113  41.718  72.366  1.00 23.42           C  
HETATM 4321  C   MSE C  95      84.351  42.321  73.003  1.00 22.80           C  
HETATM 4322  O   MSE C  95      85.347  42.587  72.333  1.00 22.96           O  
HETATM 4323  CB  MSE C  95      83.499  40.534  71.470  1.00 23.67           C  
HETATM 4324  CG  MSE C  95      84.298  39.478  72.175  1.00 23.81           C  
HETATM 4325 SE   MSE C  95      84.886  38.055  71.000  0.90 26.36          SE  
HETATM 4326  CE  MSE C  95      86.304  39.023  70.092  1.00 26.06           C  
ATOM   4327  N   LEU C  96      84.268  42.557  74.305  1.00 21.95           N  
ATOM   4328  CA  LEU C  96      85.338  43.240  75.019  1.00 21.52           C  
ATOM   4329  C   LEU C  96      85.931  42.251  76.009  1.00 21.40           C  
ATOM   4330  O   LEU C  96      85.385  42.002  77.079  1.00 21.62           O  
ATOM   4331  CB  LEU C  96      84.806  44.504  75.692  1.00 21.33           C  
ATOM   4332  CG  LEU C  96      84.046  45.449  74.746  1.00 21.81           C  
ATOM   4333  CD1 LEU C  96      83.473  46.627  75.503  1.00 21.31           C  
ATOM   4334  CD2 LEU C  96      84.930  45.955  73.581  1.00 20.67           C  
ATOM   4335  N   LEU C  97      87.045  41.660  75.604  1.00 21.47           N  
ATOM   4336  CA  LEU C  97      87.663  40.598  76.360  1.00 21.33           C  
ATOM   4337  C   LEU C  97      88.646  41.137  77.391  1.00 21.26           C  
ATOM   4338  O   LEU C  97      89.203  42.236  77.256  1.00 21.30           O  
ATOM   4339  CB  LEU C  97      88.350  39.604  75.417  1.00 21.30           C  
ATOM   4340  CG  LEU C  97      87.577  39.084  74.202  1.00 21.01           C  
ATOM   4341  CD1 LEU C  97      88.495  38.209  73.376  1.00 20.99           C  
ATOM   4342  CD2 LEU C  97      86.309  38.304  74.622  1.00 20.23           C  
ATOM   4343  N   GLY C  98      88.867  40.343  78.427  1.00 21.23           N  
ATOM   4344  CA  GLY C  98      89.765  40.730  79.497  1.00 20.42           C  
ATOM   4345  C   GLY C  98      89.376  39.975  80.745  1.00 20.81           C  
ATOM   4346  O   GLY C  98      88.250  39.456  80.837  1.00 20.16           O  
ATOM   4347  N   PRO C  99      90.307  39.868  81.698  1.00 20.64           N  
ATOM   4348  CA  PRO C  99      89.951  39.184  82.948  1.00 21.01           C  
ATOM   4349  C   PRO C  99      88.875  39.927  83.744  1.00 20.94           C  
ATOM   4350  O   PRO C  99      88.641  41.120  83.539  1.00 20.63           O  
ATOM   4351  CB  PRO C  99      91.267  39.152  83.728  1.00 20.82           C  
ATOM   4352  CG  PRO C  99      92.108  40.237  83.129  1.00 21.32           C  
ATOM   4353  CD  PRO C  99      91.711  40.311  81.684  1.00 20.63           C  
ATOM   4354  N   VAL C 100      88.218  39.199  84.637  1.00 21.08           N  
ATOM   4355  CA  VAL C 100      87.278  39.806  85.572  1.00 21.29           C  
ATOM   4356  C   VAL C 100      88.021  40.701  86.560  1.00 21.49           C  
ATOM   4357  O   VAL C 100      87.583  41.817  86.852  1.00 21.51           O  
ATOM   4358  CB  VAL C 100      86.498  38.724  86.351  1.00 21.13           C  
ATOM   4359  CG1 VAL C 100      85.686  39.347  87.480  1.00 21.15           C  
ATOM   4360  CG2 VAL C 100      85.605  37.945  85.412  1.00 21.22           C  
ATOM   4361  N   GLU C 101      89.141  40.194  87.074  1.00 22.18           N  
ATOM   4362  CA  GLU C 101      89.949  40.902  88.064  1.00 21.77           C  
ATOM   4363  C   GLU C 101      90.342  42.282  87.536  1.00 21.94           C  
ATOM   4364  O   GLU C 101      90.922  42.406  86.448  1.00 21.62           O  
ATOM   4365  CB  GLU C 101      91.198  40.085  88.429  1.00 22.07           C  
ATOM   4366  CG  GLU C 101      92.110  40.754  89.464  1.00 22.69           C  
ATOM   4367  CD  GLU C 101      93.381  39.964  89.745  1.00 22.74           C  
ATOM   4368  OE1 GLU C 101      93.691  39.012  88.994  1.00 23.01           O  
ATOM   4369  OE2 GLU C 101      94.074  40.306  90.729  1.00 24.05           O  
ATOM   4370  N   ASP C 102      89.987  43.303  88.310  1.00 21.79           N  
ATOM   4371  CA  ASP C 102      90.294  44.707  88.003  1.00 22.31           C  
ATOM   4372  C   ASP C 102      89.848  45.161  86.620  1.00 21.86           C  
ATOM   4373  O   ASP C 102      90.457  46.049  86.021  1.00 21.28           O  
ATOM   4374  CB  ASP C 102      91.775  44.996  88.208  1.00 22.91           C  
ATOM   4375  CG  ASP C 102      92.008  45.929  89.357  1.00 26.08           C  
ATOM   4376  OD1 ASP C 102      92.219  47.127  89.084  1.00 29.37           O  
ATOM   4377  OD2 ASP C 102      91.942  45.479  90.525  1.00 29.64           O  
ATOM   4378  N   ALA C 103      88.763  44.568  86.134  1.00 21.04           N  
ATOM   4379  CA  ALA C 103      88.239  44.898  84.814  1.00 20.82           C  
ATOM   4380  C   ALA C 103      87.771  46.344  84.743  1.00 20.84           C  
ATOM   4381  O   ALA C 103      87.357  46.943  85.750  1.00 21.03           O  
ATOM   4382  CB  ALA C 103      87.109  43.963  84.431  1.00 20.89           C  
ATOM   4383  N   ASP C 104      87.887  46.913  83.552  1.00 20.26           N  
ATOM   4384  CA  ASP C 104      87.267  48.177  83.253  1.00 20.85           C  
ATOM   4385  C   ASP C 104      85.787  47.839  83.099  1.00 21.12           C  
ATOM   4386  O   ASP C 104      85.378  47.242  82.091  1.00 21.33           O  
ATOM   4387  CB  ASP C 104      87.875  48.755  81.962  1.00 21.01           C  
ATOM   4388  CG  ASP C 104      87.159  50.012  81.469  1.00 21.42           C  
ATOM   4389  OD1 ASP C 104      86.090  50.363  82.021  1.00 20.86           O  
ATOM   4390  OD2 ASP C 104      87.660  50.635  80.496  1.00 21.45           O  
ATOM   4391  N   THR C 105      84.988  48.175  84.110  1.00 21.08           N  
ATOM   4392  CA  THR C 105      83.572  47.748  84.117  1.00 21.67           C  
ATOM   4393  C   THR C 105      82.700  48.435  83.062  1.00 21.18           C  
ATOM   4394  O   THR C 105      81.556  48.031  82.833  1.00 21.27           O  
ATOM   4395  CB  THR C 105      82.907  47.871  85.505  1.00 21.63           C  
ATOM   4396  OG1 THR C 105      82.832  49.251  85.889  1.00 23.38           O  
ATOM   4397  CG2 THR C 105      83.690  47.089  86.545  1.00 22.40           C  
ATOM   4398  N   THR C 106      83.237  49.457  82.403  1.00 21.36           N  
ATOM   4399  CA  THR C 106      82.546  50.024  81.243  1.00 21.18           C  
ATOM   4400  C   THR C 106      82.556  49.040  80.063  1.00 21.37           C  
ATOM   4401  O   THR C 106      81.677  49.104  79.203  1.00 20.84           O  
ATOM   4402  CB  THR C 106      83.088  51.418  80.833  1.00 20.97           C  
ATOM   4403  OG1 THR C 106      84.369  51.282  80.203  1.00 21.27           O  
ATOM   4404  CG2 THR C 106      83.204  52.324  82.064  1.00 20.67           C  
ATOM   4405  N   ASP C 107      83.531  48.121  80.034  1.00 20.81           N  
ATOM   4406  CA  ASP C 107      83.472  46.986  79.101  1.00 20.91           C  
ATOM   4407  C   ASP C 107      82.148  46.241  79.296  1.00 20.62           C  
ATOM   4408  O   ASP C 107      81.472  45.845  78.330  1.00 20.85           O  
ATOM   4409  CB  ASP C 107      84.588  45.968  79.371  1.00 20.99           C  
ATOM   4410  CG  ASP C 107      85.934  46.374  78.822  1.00 21.78           C  
ATOM   4411  OD1 ASP C 107      86.062  47.449  78.182  1.00 20.89           O  
ATOM   4412  OD2 ASP C 107      86.888  45.585  79.040  1.00 21.90           O  
ATOM   4413  N   TRP C 108      81.793  46.049  80.566  1.00 19.87           N  
ATOM   4414  CA  TRP C 108      80.653  45.242  80.956  1.00 19.65           C  
ATOM   4415  C   TRP C 108      79.326  45.894  80.625  1.00 19.63           C  
ATOM   4416  O   TRP C 108      78.437  45.249  80.075  1.00 20.46           O  
ATOM   4417  CB  TRP C 108      80.673  44.968  82.458  1.00 18.62           C  
ATOM   4418  CG  TRP C 108      81.852  44.227  82.973  1.00 18.45           C  
ATOM   4419  CD1 TRP C 108      82.901  43.720  82.262  1.00 18.20           C  
ATOM   4420  CD2 TRP C 108      82.081  43.868  84.346  1.00 19.48           C  
ATOM   4421  NE1 TRP C 108      83.785  43.081  83.115  1.00 19.84           N  
ATOM   4422  CE2 TRP C 108      83.296  43.146  84.395  1.00 19.24           C  
ATOM   4423  CE3 TRP C 108      81.377  44.096  85.536  1.00 18.94           C  
ATOM   4424  CZ2 TRP C 108      83.823  42.643  85.595  1.00 19.22           C  
ATOM   4425  CZ3 TRP C 108      81.901  43.600  86.736  1.00 18.86           C  
ATOM   4426  CH2 TRP C 108      83.108  42.878  86.751  1.00 19.04           C  
ATOM   4427  N   THR C 109      79.193  47.166  80.986  1.00 19.98           N  
ATOM   4428  CA  THR C 109      77.938  47.883  80.802  1.00 20.19           C  
ATOM   4429  C   THR C 109      77.695  48.058  79.300  1.00 20.38           C  
ATOM   4430  O   THR C 109      76.570  47.920  78.842  1.00 20.64           O  
ATOM   4431  CB  THR C 109      77.913  49.239  81.551  1.00 19.89           C  
ATOM   4432  OG1 THR C 109      79.044  50.032  81.168  1.00 19.88           O  
ATOM   4433  CG2 THR C 109      77.936  49.015  83.078  1.00 20.32           C  
ATOM   4434  N   ARG C 110      78.758  48.312  78.543  1.00 20.54           N  
ATOM   4435  CA  ARG C 110      78.650  48.388  77.082  1.00 21.28           C  
ATOM   4436  C   ARG C 110      78.154  47.062  76.490  1.00 21.40           C  
ATOM   4437  O   ARG C 110      77.232  47.067  75.669  1.00 22.04           O  
ATOM   4438  CB  ARG C 110      79.978  48.796  76.442  1.00 21.28           C  
ATOM   4439  CG  ARG C 110      80.332  50.284  76.570  1.00 21.92           C  
ATOM   4440  CD  ARG C 110      81.770  50.535  76.112  1.00 22.19           C  
ATOM   4441  NE  ARG C 110      81.935  50.301  74.674  1.00 24.95           N  
ATOM   4442  CZ  ARG C 110      83.105  50.137  74.057  1.00 26.97           C  
ATOM   4443  NH1 ARG C 110      84.244  50.155  74.742  1.00 26.87           N  
ATOM   4444  NH2 ARG C 110      83.136  49.949  72.739  1.00 27.58           N  
HETATM 4445  N   MSE C 111      78.754  45.935  76.892  1.00 21.15           N  
HETATM 4446  CA  MSE C 111      78.331  44.623  76.356  1.00 21.73           C  
HETATM 4447  C   MSE C 111      76.905  44.280  76.758  1.00 21.57           C  
HETATM 4448  O   MSE C 111      76.121  43.839  75.933  1.00 21.58           O  
HETATM 4449  CB  MSE C 111      79.277  43.492  76.758  1.00 21.82           C  
HETATM 4450  CG  MSE C 111      80.541  43.470  75.956  1.00 21.17           C  
HETATM 4451 SE   MSE C 111      81.610  41.971  76.456  0.95 23.18          SE  
HETATM 4452  CE  MSE C 111      82.171  42.599  78.250  1.00 21.66           C  
ATOM   4453  N   ILE C 112      76.552  44.529  78.018  1.00 21.86           N  
ATOM   4454  CA  ILE C 112      75.195  44.235  78.482  1.00 22.26           C  
ATOM   4455  C   ILE C 112      74.161  45.102  77.765  1.00 22.25           C  
ATOM   4456  O   ILE C 112      73.104  44.612  77.359  1.00 22.69           O  
ATOM   4457  CB  ILE C 112      75.056  44.384  80.014  1.00 22.53           C  
ATOM   4458  CG1 ILE C 112      75.840  43.274  80.722  1.00 22.83           C  
ATOM   4459  CG2 ILE C 112      73.579  44.324  80.415  1.00 22.82           C  
ATOM   4460  CD1 ILE C 112      75.906  43.441  82.214  1.00 24.62           C  
ATOM   4461  N   ASP C 113      74.472  46.386  77.597  1.00 22.18           N  
ATOM   4462  CA  ASP C 113      73.556  47.318  76.922  1.00 22.44           C  
ATOM   4463  C   ASP C 113      73.301  46.950  75.466  1.00 22.12           C  
ATOM   4464  O   ASP C 113      72.165  47.014  75.001  1.00 21.93           O  
ATOM   4465  CB  ASP C 113      74.074  48.763  76.993  1.00 22.80           C  
ATOM   4466  CG  ASP C 113      73.855  49.400  78.350  1.00 24.18           C  
ATOM   4467  OD1 ASP C 113      73.198  48.782  79.210  1.00 27.38           O  
ATOM   4468  OD2 ASP C 113      74.337  50.537  78.553  1.00 24.64           O  
ATOM   4469  N   THR C 114      74.369  46.579  74.767  1.00 21.34           N  
ATOM   4470  CA  THR C 114      74.287  46.291  73.337  1.00 21.87           C  
ATOM   4471  C   THR C 114      73.825  44.844  73.096  1.00 21.73           C  
ATOM   4472  O   THR C 114      72.795  44.628  72.437  1.00 22.47           O  
ATOM   4473  CB  THR C 114      75.632  46.571  72.622  1.00 21.51           C  
ATOM   4474  OG1 THR C 114      76.043  47.921  72.891  1.00 22.32           O  
ATOM   4475  CG2 THR C 114      75.493  46.386  71.109  1.00 21.99           C  
ATOM   4476  N   ASN C 115      74.589  43.884  73.636  1.00 21.32           N  
ATOM   4477  CA  ASN C 115      74.432  42.454  73.346  1.00 21.77           C  
ATOM   4478  C   ASN C 115      73.155  41.846  73.903  1.00 21.87           C  
ATOM   4479  O   ASN C 115      72.555  40.955  73.286  1.00 22.23           O  
ATOM   4480  CB  ASN C 115      75.611  41.650  73.916  1.00 21.68           C  
ATOM   4481  CG  ASN C 115      76.928  42.003  73.279  1.00 21.88           C  
ATOM   4482  OD1 ASN C 115      77.021  42.920  72.447  1.00 22.59           O  
ATOM   4483  ND2 ASN C 115      77.972  41.291  73.678  1.00 22.20           N  
ATOM   4484  N   LEU C 116      72.768  42.315  75.088  1.00 22.42           N  
ATOM   4485  CA  LEU C 116      71.667  41.734  75.832  1.00 22.73           C  
ATOM   4486  C   LEU C 116      70.424  42.631  75.821  1.00 23.05           C  
ATOM   4487  O   LEU C 116      69.432  42.285  75.190  1.00 23.14           O  
ATOM   4488  CB  LEU C 116      72.106  41.415  77.266  1.00 22.66           C  
ATOM   4489  CG  LEU C 116      71.303  40.379  78.060  1.00 23.80           C  
ATOM   4490  CD1 LEU C 116      71.296  39.001  77.397  1.00 24.13           C  
ATOM   4491  CD2 LEU C 116      71.784  40.275  79.524  1.00 22.84           C  
ATOM   4492  N   LEU C 117      70.477  43.773  76.510  1.00 22.66           N  
ATOM   4493  CA  LEU C 117      69.318  44.686  76.581  1.00 23.26           C  
ATOM   4494  C   LEU C 117      68.859  45.207  75.206  1.00 22.86           C  
ATOM   4495  O   LEU C 117      67.667  45.159  74.879  1.00 22.96           O  
ATOM   4496  CB  LEU C 117      69.631  45.839  77.530  1.00 23.64           C  
ATOM   4497  CG  LEU C 117      68.571  46.433  78.459  1.00 26.34           C  
ATOM   4498  CD1 LEU C 117      67.508  45.446  78.937  1.00 25.15           C  
ATOM   4499  CD2 LEU C 117      69.309  47.039  79.654  1.00 27.61           C  
ATOM   4500  N   GLY C 118      69.812  45.669  74.398  1.00 22.44           N  
ATOM   4501  CA  GLY C 118      69.543  46.092  73.025  1.00 21.95           C  
ATOM   4502  C   GLY C 118      68.813  45.045  72.195  1.00 22.14           C  
ATOM   4503  O   GLY C 118      67.790  45.346  71.576  1.00 21.27           O  
ATOM   4504  N   LEU C 119      69.343  43.820  72.184  1.00 21.52           N  
ATOM   4505  CA  LEU C 119      68.705  42.696  71.489  1.00 21.61           C  
ATOM   4506  C   LEU C 119      67.282  42.431  72.011  1.00 21.73           C  
ATOM   4507  O   LEU C 119      66.375  42.157  71.232  1.00 21.58           O  
ATOM   4508  CB  LEU C 119      69.581  41.446  71.609  1.00 21.13           C  
ATOM   4509  CG  LEU C 119      69.056  40.132  71.022  1.00 22.29           C  
ATOM   4510  CD1 LEU C 119      70.231  39.305  70.457  1.00 22.31           C  
ATOM   4511  CD2 LEU C 119      68.270  39.354  72.089  1.00 20.86           C  
HETATM 4512  N   MSE C 120      67.094  42.520  73.330  1.00 21.37           N  
HETATM 4513  CA  MSE C 120      65.769  42.364  73.940  1.00 22.53           C  
HETATM 4514  C   MSE C 120      64.792  43.483  73.575  1.00 21.83           C  
HETATM 4515  O   MSE C 120      63.618  43.220  73.287  1.00 21.11           O  
HETATM 4516  CB  MSE C 120      65.893  42.277  75.468  1.00 22.12           C  
HETATM 4517  CG  MSE C 120      66.649  41.074  75.952  1.00 23.37           C  
HETATM 4518 SE   MSE C 120      67.096  41.237  77.857  0.95 27.52          SE  
HETATM 4519  CE  MSE C 120      67.500  39.383  78.108  1.00 24.17           C  
ATOM   4520  N   TYR C 121      65.267  44.730  73.625  1.00 21.66           N  
ATOM   4521  CA  TYR C 121      64.448  45.879  73.237  1.00 21.93           C  
ATOM   4522  C   TYR C 121      63.981  45.728  71.785  1.00 21.80           C  
ATOM   4523  O   TYR C 121      62.794  45.908  71.482  1.00 21.83           O  
ATOM   4524  CB  TYR C 121      65.245  47.185  73.343  1.00 22.26           C  
ATOM   4525  CG  TYR C 121      65.491  47.705  74.740  1.00 22.30           C  
ATOM   4526  CD1 TYR C 121      66.567  48.560  74.995  1.00 21.89           C  
ATOM   4527  CD2 TYR C 121      64.662  47.353  75.799  1.00 23.16           C  
ATOM   4528  CE1 TYR C 121      66.809  49.052  76.269  1.00 24.29           C  
ATOM   4529  CE2 TYR C 121      64.899  47.842  77.085  1.00 24.14           C  
ATOM   4530  CZ  TYR C 121      65.975  48.691  77.307  1.00 24.46           C  
ATOM   4531  OH  TYR C 121      66.218  49.194  78.572  1.00 25.05           O  
HETATM 4532  N   MSE C 122      64.912  45.401  70.893  0.50 21.39           N  
HETATM 4534  CA  MSE C 122      64.583  45.282  69.470  0.50 21.29           C  
HETATM 4536  C   MSE C 122      63.653  44.086  69.194  0.50 21.36           C  
HETATM 4538  O   MSE C 122      62.729  44.190  68.384  0.50 21.20           O  
HETATM 4540  CB  MSE C 122      65.857  45.245  68.614  0.50 21.35           C  
HETATM 4542  CG  MSE C 122      65.614  45.114  67.114  0.50 20.88           C  
HETATM 4544 SE   MSE C 122      64.363  46.413  66.369  0.50 20.10          SE  
HETATM 4546  CE  MSE C 122      65.599  47.784  65.744  0.50 19.95           C  
ATOM   4548  N   THR C 123      63.884  42.969  69.885  1.00 21.43           N  
ATOM   4549  CA  THR C 123      62.959  41.827  69.849  1.00 21.58           C  
ATOM   4550  C   THR C 123      61.538  42.248  70.254  1.00 21.75           C  
ATOM   4551  O   THR C 123      60.573  41.984  69.528  1.00 21.88           O  
ATOM   4552  CB  THR C 123      63.445  40.671  70.767  1.00 21.90           C  
ATOM   4553  OG1 THR C 123      64.709  40.193  70.290  1.00 21.22           O  
ATOM   4554  CG2 THR C 123      62.436  39.510  70.758  1.00 21.71           C  
ATOM   4555  N   ARG C 124      61.421  42.922  71.396  1.00 21.33           N  
ATOM   4556  CA  ARG C 124      60.125  43.344  71.931  1.00 21.49           C  
ATOM   4557  C   ARG C 124      59.397  44.311  70.992  1.00 21.48           C  
ATOM   4558  O   ARG C 124      58.183  44.201  70.798  1.00 21.48           O  
ATOM   4559  CB  ARG C 124      60.312  43.969  73.323  1.00 21.50           C  
ATOM   4560  CG  ARG C 124      59.025  44.475  74.011  1.00 21.49           C  
ATOM   4561  CD  ARG C 124      59.417  45.203  75.286  1.00 22.35           C  
ATOM   4562  NE  ARG C 124      58.343  46.023  75.839  1.00 24.03           N  
ATOM   4563  CZ  ARG C 124      57.958  47.193  75.339  1.00 26.06           C  
ATOM   4564  NH1 ARG C 124      58.550  47.692  74.259  1.00 25.56           N  
ATOM   4565  NH2 ARG C 124      56.971  47.867  75.916  1.00 26.21           N  
ATOM   4566  N   ALA C 125      60.143  45.250  70.414  1.00 21.32           N  
ATOM   4567  CA  ALA C 125      59.565  46.262  69.542  1.00 21.63           C  
ATOM   4568  C   ALA C 125      59.057  45.662  68.237  1.00 21.63           C  
ATOM   4569  O   ALA C 125      57.987  46.036  67.760  1.00 21.74           O  
ATOM   4570  CB  ALA C 125      60.570  47.383  69.279  1.00 21.61           C  
ATOM   4571  N   ALA C 126      59.816  44.724  67.673  1.00 21.79           N  
ATOM   4572  CA  ALA C 126      59.451  44.090  66.399  1.00 21.91           C  
ATOM   4573  C   ALA C 126      58.308  43.079  66.551  1.00 21.92           C  
ATOM   4574  O   ALA C 126      57.573  42.818  65.605  1.00 21.67           O  
ATOM   4575  CB  ALA C 126      60.676  43.407  65.774  1.00 22.08           C  
ATOM   4576  N   LEU C 127      58.168  42.516  67.746  1.00 21.96           N  
ATOM   4577  CA  LEU C 127      57.292  41.362  67.954  1.00 22.52           C  
ATOM   4578  C   LEU C 127      55.835  41.554  67.513  1.00 22.56           C  
ATOM   4579  O   LEU C 127      55.276  40.648  66.893  1.00 22.95           O  
ATOM   4580  CB  LEU C 127      57.359  40.872  69.410  1.00 22.16           C  
ATOM   4581  CG  LEU C 127      56.691  39.529  69.744  1.00 23.23           C  
ATOM   4582  CD1 LEU C 127      57.229  38.407  68.828  1.00 24.58           C  
ATOM   4583  CD2 LEU C 127      56.866  39.157  71.232  1.00 23.54           C  
ATOM   4584  N   PRO C 128      55.214  42.719  67.800  1.00 22.50           N  
ATOM   4585  CA  PRO C 128      53.834  42.824  67.294  1.00 22.53           C  
ATOM   4586  C   PRO C 128      53.739  42.713  65.768  1.00 22.49           C  
ATOM   4587  O   PRO C 128      52.757  42.184  65.243  1.00 22.37           O  
ATOM   4588  CB  PRO C 128      53.388  44.222  67.750  1.00 22.59           C  
ATOM   4589  CG  PRO C 128      54.279  44.558  68.874  1.00 22.75           C  
ATOM   4590  CD  PRO C 128      55.606  43.932  68.542  1.00 22.35           C  
ATOM   4591  N   HIS C 129      54.766  43.195  65.075  1.00 22.20           N  
ATOM   4592  CA  HIS C 129      54.815  43.149  63.617  1.00 22.16           C  
ATOM   4593  C   HIS C 129      55.072  41.739  63.091  1.00 22.03           C  
ATOM   4594  O   HIS C 129      54.448  41.303  62.112  1.00 21.49           O  
ATOM   4595  CB  HIS C 129      55.860  44.144  63.112  1.00 22.24           C  
ATOM   4596  CG  HIS C 129      55.613  45.543  63.582  1.00 22.85           C  
ATOM   4597  ND1 HIS C 129      54.669  46.365  63.004  1.00 23.52           N  
ATOM   4598  CD2 HIS C 129      56.153  46.247  64.604  1.00 23.00           C  
ATOM   4599  CE1 HIS C 129      54.655  47.526  63.638  1.00 24.56           C  
ATOM   4600  NE2 HIS C 129      55.547  47.480  64.611  1.00 23.67           N  
ATOM   4601  N   LEU C 130      55.987  41.035  63.755  1.00 21.99           N  
ATOM   4602  CA  LEU C 130      56.312  39.646  63.440  1.00 22.10           C  
ATOM   4603  C   LEU C 130      55.139  38.713  63.718  1.00 22.07           C  
ATOM   4604  O   LEU C 130      54.937  37.739  62.999  1.00 22.28           O  
ATOM   4605  CB  LEU C 130      57.548  39.186  64.222  1.00 21.94           C  
ATOM   4606  CG  LEU C 130      58.868  39.900  63.929  1.00 21.91           C  
ATOM   4607  CD1 LEU C 130      59.981  39.383  64.871  1.00 22.19           C  
ATOM   4608  CD2 LEU C 130      59.268  39.735  62.468  1.00 22.87           C  
ATOM   4609  N   LEU C 131      54.371  39.003  64.762  1.00 22.49           N  
ATOM   4610  CA  LEU C 131      53.148  38.239  65.018  1.00 22.71           C  
ATOM   4611  C   LEU C 131      52.168  38.349  63.843  1.00 23.00           C  
ATOM   4612  O   LEU C 131      51.617  37.342  63.384  1.00 23.34           O  
ATOM   4613  CB  LEU C 131      52.508  38.666  66.345  1.00 22.80           C  
ATOM   4614  CG  LEU C 131      53.266  38.155  67.578  1.00 22.26           C  
ATOM   4615  CD1 LEU C 131      52.836  38.894  68.837  1.00 23.49           C  
ATOM   4616  CD2 LEU C 131      53.089  36.654  67.763  1.00 22.20           C  
ATOM   4617  N   ARG C 132      51.982  39.569  63.342  1.00 23.16           N  
ATOM   4618  CA  ARG C 132      51.115  39.823  62.195  1.00 23.28           C  
ATOM   4619  C   ARG C 132      51.590  39.124  60.928  1.00 23.05           C  
ATOM   4620  O   ARG C 132      50.775  38.596  60.175  1.00 22.80           O  
ATOM   4621  CB  ARG C 132      50.989  41.322  61.941  1.00 23.44           C  
ATOM   4622  CG  ARG C 132      50.240  42.053  63.039  1.00 25.07           C  
ATOM   4623  CD  ARG C 132      49.902  43.480  62.629  1.00 28.66           C  
ATOM   4624  NE  ARG C 132      50.922  44.431  63.059  1.00 30.56           N  
ATOM   4625  CZ  ARG C 132      51.019  44.930  64.289  1.00 32.28           C  
ATOM   4626  NH1 ARG C 132      50.159  44.567  65.238  1.00 33.40           N  
ATOM   4627  NH2 ARG C 132      51.990  45.789  64.576  1.00 32.84           N  
ATOM   4628  N   SER C 133      52.904  39.108  60.702  1.00 22.63           N  
ATOM   4629  CA  SER C 133      53.448  38.531  59.467  1.00 22.85           C  
ATOM   4630  C   SER C 133      53.856  37.064  59.598  1.00 22.62           C  
ATOM   4631  O   SER C 133      54.312  36.464  58.626  1.00 21.94           O  
ATOM   4632  CB  SER C 133      54.642  39.358  58.961  1.00 22.80           C  
ATOM   4633  OG  SER C 133      55.711  39.308  59.876  1.00 23.04           O  
ATOM   4634  N   LYS C 134      53.687  36.486  60.791  1.00 22.22           N  
ATOM   4635  CA  LYS C 134      54.226  35.152  61.098  1.00 22.28           C  
ATOM   4636  C   LYS C 134      55.702  35.089  60.700  1.00 21.97           C  
ATOM   4637  O   LYS C 134      56.166  34.202  59.960  1.00 21.93           O  
ATOM   4638  CB  LYS C 134      53.374  34.041  60.472  1.00 22.45           C  
ATOM   4639  CG  LYS C 134      52.059  33.823  61.217  1.00 23.47           C  
ATOM   4640  CD  LYS C 134      51.273  32.654  60.648  1.00 26.62           C  
ATOM   4641  CE  LYS C 134      49.999  32.400  61.453  1.00 28.86           C  
ATOM   4642  NZ  LYS C 134      48.985  33.486  61.304  1.00 30.76           N  
ATOM   4643  N   GLY C 135      56.430  36.074  61.206  1.00 21.60           N  
ATOM   4644  CA  GLY C 135      57.768  36.361  60.746  1.00 21.66           C  
ATOM   4645  C   GLY C 135      58.813  35.595  61.516  1.00 21.14           C  
ATOM   4646  O   GLY C 135      58.491  34.698  62.301  1.00 21.35           O  
ATOM   4647  N   THR C 136      60.071  35.975  61.306  1.00 21.39           N  
ATOM   4648  CA  THR C 136      61.202  35.269  61.896  1.00 21.19           C  
ATOM   4649  C   THR C 136      62.138  36.254  62.583  1.00 21.61           C  
ATOM   4650  O   THR C 136      62.466  37.292  62.011  1.00 21.48           O  
ATOM   4651  CB  THR C 136      61.965  34.496  60.803  1.00 21.58           C  
ATOM   4652  OG1 THR C 136      61.076  33.543  60.204  1.00 20.26           O  
ATOM   4653  CG2 THR C 136      63.180  33.773  61.386  1.00 20.47           C  
ATOM   4654  N   VAL C 137      62.531  35.951  63.820  1.00 21.63           N  
ATOM   4655  CA  VAL C 137      63.581  36.723  64.480  1.00 22.04           C  
ATOM   4656  C   VAL C 137      64.856  35.885  64.546  1.00 21.69           C  
ATOM   4657  O   VAL C 137      64.848  34.743  65.022  1.00 22.10           O  
ATOM   4658  CB  VAL C 137      63.177  37.297  65.870  1.00 22.76           C  
ATOM   4659  CG1 VAL C 137      62.602  36.217  66.798  1.00 23.60           C  
ATOM   4660  CG2 VAL C 137      64.389  37.985  66.517  1.00 22.96           C  
ATOM   4661  N   VAL C 138      65.941  36.474  64.061  1.00 20.92           N  
ATOM   4662  CA  VAL C 138      67.239  35.831  64.029  1.00 20.53           C  
ATOM   4663  C   VAL C 138      68.131  36.532  65.038  1.00 20.66           C  
ATOM   4664  O   VAL C 138      68.422  37.720  64.895  1.00 20.44           O  
ATOM   4665  CB  VAL C 138      67.850  35.905  62.625  1.00 20.67           C  
ATOM   4666  CG1 VAL C 138      69.197  35.171  62.578  1.00 21.00           C  
ATOM   4667  CG2 VAL C 138      66.880  35.317  61.603  1.00 19.49           C  
ATOM   4668  N   GLN C 139      68.546  35.778  66.057  1.00 20.72           N  
ATOM   4669  CA  GLN C 139      69.434  36.252  67.114  1.00 21.03           C  
ATOM   4670  C   GLN C 139      70.867  35.864  66.819  1.00 21.56           C  
ATOM   4671  O   GLN C 139      71.178  34.671  66.658  1.00 22.24           O  
ATOM   4672  CB  GLN C 139      69.032  35.633  68.461  1.00 21.30           C  
ATOM   4673  CG  GLN C 139      67.516  35.622  68.732  1.00 20.88           C  
ATOM   4674  CD  GLN C 139      66.955  37.000  69.055  1.00 23.36           C  
ATOM   4675  OE1 GLN C 139      67.328  37.988  68.449  1.00 23.27           O  
ATOM   4676  NE2 GLN C 139      66.043  37.056  70.016  1.00 23.47           N  
HETATM 4677  N   MSE C 140      71.744  36.864  66.732  1.00 21.10           N  
HETATM 4678  CA  MSE C 140      73.162  36.593  66.523  1.00 21.30           C  
HETATM 4679  C   MSE C 140      73.815  36.342  67.872  1.00 21.86           C  
HETATM 4680  O   MSE C 140      74.213  37.280  68.564  1.00 22.32           O  
HETATM 4681  CB  MSE C 140      73.865  37.746  65.802  1.00 21.44           C  
HETATM 4682  CG  MSE C 140      75.236  37.378  65.272  1.00 22.18           C  
HETATM 4683 SE   MSE C 140      75.170  35.929  63.922  0.95 25.83          SE  
HETATM 4684  CE  MSE C 140      73.863  36.702  62.769  1.00 23.79           C  
ATOM   4685  N   SER C 141      73.908  35.071  68.246  1.00 21.72           N  
ATOM   4686  CA  SER C 141      74.601  34.699  69.461  1.00 22.32           C  
ATOM   4687  C   SER C 141      76.077  34.491  69.107  1.00 22.95           C  
ATOM   4688  O   SER C 141      76.659  35.299  68.375  1.00 23.60           O  
ATOM   4689  CB  SER C 141      73.955  33.457  70.072  1.00 22.33           C  
ATOM   4690  OG  SER C 141      74.545  33.107  71.309  1.00 21.38           O  
ATOM   4691  N   SER C 142      76.660  33.405  69.603  1.00 22.71           N  
ATOM   4692  CA  SER C 142      78.083  33.137  69.469  1.00 23.05           C  
ATOM   4693  C   SER C 142      78.357  31.744  69.989  1.00 22.47           C  
ATOM   4694  O   SER C 142      77.569  31.192  70.765  1.00 21.61           O  
ATOM   4695  CB  SER C 142      78.886  34.111  70.355  1.00 22.71           C  
ATOM   4696  OG  SER C 142      80.280  33.899  70.191  1.00 25.81           O  
ATOM   4697  N   ILE C 143      79.515  31.213  69.600  1.00 21.69           N  
ATOM   4698  CA  ILE C 143      80.136  30.116  70.308  1.00 22.11           C  
ATOM   4699  C   ILE C 143      80.214  30.441  71.804  1.00 21.94           C  
ATOM   4700  O   ILE C 143      80.102  29.540  72.635  1.00 21.77           O  
ATOM   4701  CB  ILE C 143      81.554  29.829  69.743  1.00 21.95           C  
ATOM   4702  CG1 ILE C 143      82.212  28.638  70.442  1.00 23.18           C  
ATOM   4703  CG2 ILE C 143      82.454  31.098  69.769  1.00 23.47           C  
ATOM   4704  CD1 ILE C 143      83.245  27.922  69.547  1.00 23.12           C  
ATOM   4705  N   ALA C 144      80.396  31.724  72.123  1.00 21.96           N  
ATOM   4706  CA  ALA C 144      80.403  32.235  73.507  1.00 21.96           C  
ATOM   4707  C   ALA C 144      79.086  32.065  74.240  1.00 21.94           C  
ATOM   4708  O   ALA C 144      79.021  32.273  75.460  1.00 21.48           O  
ATOM   4709  CB  ALA C 144      80.803  33.694  73.524  1.00 21.83           C  
ATOM   4710  N   GLY C 145      78.026  31.736  73.497  1.00 21.92           N  
ATOM   4711  CA  GLY C 145      76.751  31.350  74.100  1.00 22.24           C  
ATOM   4712  C   GLY C 145      76.654  29.860  74.401  1.00 22.31           C  
ATOM   4713  O   GLY C 145      75.661  29.415  74.954  1.00 22.63           O  
ATOM   4714  N   ARG C 146      77.687  29.100  74.044  1.00 22.61           N  
ATOM   4715  CA  ARG C 146      77.697  27.627  74.174  1.00 22.87           C  
ATOM   4716  C   ARG C 146      78.923  27.102  74.922  1.00 23.07           C  
ATOM   4717  O   ARG C 146      78.867  26.040  75.540  1.00 23.54           O  
ATOM   4718  CB  ARG C 146      77.654  26.956  72.782  1.00 23.18           C  
ATOM   4719  CG  ARG C 146      76.466  27.311  71.884  1.00 23.40           C  
ATOM   4720  CD  ARG C 146      75.084  26.833  72.429  1.00 25.12           C  
ATOM   4721  NE  ARG C 146      75.053  25.390  72.693  1.00 26.97           N  
ATOM   4722  CZ  ARG C 146      74.970  24.454  71.745  1.00 28.76           C  
ATOM   4723  NH1 ARG C 146      74.857  24.794  70.465  1.00 25.90           N  
ATOM   4724  NH2 ARG C 146      74.973  23.172  72.081  1.00 30.01           N  
ATOM   4725  N   VAL C 147      80.026  27.837  74.838  1.00 23.02           N  
ATOM   4726  CA  VAL C 147      81.337  27.420  75.367  1.00 23.11           C  
ATOM   4727  C   VAL C 147      81.963  28.589  76.143  1.00 22.97           C  
ATOM   4728  O   VAL C 147      81.992  29.708  75.637  1.00 23.27           O  
ATOM   4729  CB  VAL C 147      82.297  27.017  74.190  1.00 23.21           C  
ATOM   4730  CG1 VAL C 147      83.739  26.766  74.670  1.00 23.14           C  
ATOM   4731  CG2 VAL C 147      81.768  25.789  73.457  1.00 23.91           C  
ATOM   4732  N   ASN C 148      82.450  28.327  77.355  1.00 22.42           N  
ATOM   4733  CA  ASN C 148      83.152  29.335  78.152  1.00 22.32           C  
ATOM   4734  C   ASN C 148      84.673  29.178  78.098  1.00 21.68           C  
ATOM   4735  O   ASN C 148      85.194  28.113  78.424  1.00 21.93           O  
ATOM   4736  CB  ASN C 148      82.725  29.244  79.616  1.00 22.12           C  
ATOM   4737  CG  ASN C 148      81.313  29.699  79.828  1.00 23.24           C  
ATOM   4738  OD1 ASN C 148      80.963  30.821  79.487  1.00 24.17           O  
ATOM   4739  ND2 ASN C 148      80.483  28.826  80.393  1.00 23.86           N  
ATOM   4740  N   VAL C 149      85.370  30.240  77.704  1.00 22.21           N  
ATOM   4741  CA  VAL C 149      86.841  30.279  77.742  1.00 22.89           C  
ATOM   4742  C   VAL C 149      87.286  31.452  78.617  1.00 23.12           C  
ATOM   4743  O   VAL C 149      86.491  32.354  78.901  1.00 23.35           O  
ATOM   4744  CB  VAL C 149      87.488  30.399  76.315  1.00 23.71           C  
ATOM   4745  CG1 VAL C 149      87.213  29.150  75.480  1.00 24.01           C  
ATOM   4746  CG2 VAL C 149      87.024  31.670  75.587  1.00 24.24           C  
ATOM   4747  N   ARG C 150      88.551  31.431  79.044  0.50 23.13           N  
ATOM   4749  CA  ARG C 150      89.103  32.473  79.916  0.50 23.46           C  
ATOM   4751  C   ARG C 150      89.074  33.832  79.225  0.50 22.79           C  
ATOM   4753  O   ARG C 150      89.128  33.915  77.996  0.50 22.53           O  
ATOM   4755  CB  ARG C 150      90.534  32.127  80.375  0.50 23.74           C  
ATOM   4757  CG  ARG C 150      90.589  31.300  81.662  0.50 24.49           C  
ATOM   4759  CD  ARG C 150      91.996  30.813  82.032  0.50 24.78           C  
ATOM   4761  NE  ARG C 150      92.677  31.706  82.975  0.50 26.11           N  
ATOM   4763  CZ  ARG C 150      93.670  31.345  83.788  0.50 26.26           C  
ATOM   4765  NH1 ARG C 150      94.118  30.095  83.802  0.50 26.81           N  
ATOM   4767  NH2 ARG C 150      94.211  32.240  84.607  0.50 25.51           N  
ATOM   4769  N   ASN C 151      88.950  34.881  80.034  1.00 22.35           N  
ATOM   4770  CA  ASN C 151      88.967  36.284  79.574  1.00 22.13           C  
ATOM   4771  C   ASN C 151      87.768  36.735  78.745  1.00 21.90           C  
ATOM   4772  O   ASN C 151      87.810  37.758  78.071  1.00 21.74           O  
ATOM   4773  CB  ASN C 151      90.320  36.650  78.912  1.00 22.19           C  
ATOM   4774  CG  ASN C 151      91.496  36.348  79.820  1.00 23.71           C  
ATOM   4775  OD1 ASN C 151      91.431  36.581  81.030  1.00 27.57           O  
ATOM   4776  ND2 ASN C 151      92.562  35.801  79.252  1.00 25.57           N  
ATOM   4777  N   ALA C 152      86.684  35.975  78.813  1.00 21.61           N  
ATOM   4778  CA  ALA C 152      85.473  36.372  78.111  1.00 20.87           C  
ATOM   4779  C   ALA C 152      84.248  36.235  79.015  1.00 20.03           C  
ATOM   4780  O   ALA C 152      83.146  35.992  78.532  1.00 19.68           O  
ATOM   4781  CB  ALA C 152      85.314  35.551  76.811  1.00 20.83           C  
ATOM   4782  N   ALA C 153      84.433  36.403  80.327  1.00 19.32           N  
ATOM   4783  CA  ALA C 153      83.360  36.132  81.295  1.00 19.44           C  
ATOM   4784  C   ALA C 153      82.047  36.866  80.994  1.00 19.12           C  
ATOM   4785  O   ALA C 153      80.971  36.245  80.886  1.00 19.37           O  
ATOM   4786  CB  ALA C 153      83.835  36.433  82.744  1.00 18.41           C  
ATOM   4787  N   VAL C 154      82.131  38.181  80.856  1.00 19.04           N  
ATOM   4788  CA  VAL C 154      80.921  38.981  80.657  1.00 18.98           C  
ATOM   4789  C   VAL C 154      80.352  38.847  79.224  1.00 19.12           C  
ATOM   4790  O   VAL C 154      79.128  38.811  79.032  1.00 18.28           O  
ATOM   4791  CB  VAL C 154      81.151  40.439  81.072  1.00 19.43           C  
ATOM   4792  CG1 VAL C 154      79.894  41.279  80.822  1.00 19.81           C  
ATOM   4793  CG2 VAL C 154      81.563  40.489  82.565  1.00 18.84           C  
ATOM   4794  N   TYR C 155      81.230  38.728  78.233  1.00 18.88           N  
ATOM   4795  CA  TYR C 155      80.777  38.470  76.859  1.00 19.80           C  
ATOM   4796  C   TYR C 155      79.971  37.184  76.837  1.00 19.89           C  
ATOM   4797  O   TYR C 155      78.829  37.158  76.360  1.00 20.54           O  
ATOM   4798  CB  TYR C 155      81.968  38.315  75.928  1.00 19.94           C  
ATOM   4799  CG  TYR C 155      81.609  38.134  74.475  1.00 20.51           C  
ATOM   4800  CD1 TYR C 155      80.844  39.096  73.795  1.00 19.82           C  
ATOM   4801  CD2 TYR C 155      82.066  37.029  73.769  1.00 21.70           C  
ATOM   4802  CE1 TYR C 155      80.538  38.944  72.436  1.00 20.90           C  
ATOM   4803  CE2 TYR C 155      81.775  36.870  72.415  1.00 21.87           C  
ATOM   4804  CZ  TYR C 155      80.996  37.829  71.764  1.00 22.35           C  
ATOM   4805  OH  TYR C 155      80.716  37.679  70.429  1.00 23.05           O  
ATOM   4806  N   GLN C 156      80.560  36.127  77.400  1.00 20.22           N  
ATOM   4807  CA  GLN C 156      79.861  34.834  77.530  1.00 20.39           C  
ATOM   4808  C   GLN C 156      78.553  34.925  78.320  1.00 20.83           C  
ATOM   4809  O   GLN C 156      77.546  34.352  77.901  1.00 20.26           O  
ATOM   4810  CB  GLN C 156      80.828  33.758  78.041  1.00 20.75           C  
ATOM   4811  CG  GLN C 156      81.875  33.477  76.937  1.00 21.06           C  
ATOM   4812  CD  GLN C 156      83.188  32.855  77.378  1.00 22.23           C  
ATOM   4813  OE1 GLN C 156      83.932  32.375  76.532  1.00 23.11           O  
ATOM   4814  NE2 GLN C 156      83.486  32.864  78.673  1.00 20.03           N  
ATOM   4815  N   ALA C 157      78.553  35.671  79.428  1.00 20.28           N  
ATOM   4816  CA  ALA C 157      77.310  35.947  80.144  1.00 20.30           C  
ATOM   4817  C   ALA C 157      76.228  36.533  79.217  1.00 20.63           C  
ATOM   4818  O   ALA C 157      75.064  36.102  79.264  1.00 20.59           O  
ATOM   4819  CB  ALA C 157      77.565  36.876  81.339  1.00 20.39           C  
ATOM   4820  N   THR C 158      76.592  37.512  78.385  1.00 20.09           N  
ATOM   4821  CA  THR C 158      75.590  38.135  77.499  1.00 20.43           C  
ATOM   4822  C   THR C 158      75.066  37.136  76.469  1.00 20.56           C  
ATOM   4823  O   THR C 158      73.860  37.091  76.195  1.00 20.52           O  
ATOM   4824  CB  THR C 158      76.069  39.459  76.798  1.00 20.07           C  
ATOM   4825  OG1 THR C 158      77.069  39.184  75.800  1.00 20.77           O  
ATOM   4826  CG2 THR C 158      76.574  40.470  77.825  1.00 21.13           C  
ATOM   4827  N   LYS C 159      75.953  36.298  75.940  1.00 20.40           N  
ATOM   4828  CA  LYS C 159      75.548  35.368  74.882  1.00 20.47           C  
ATOM   4829  C   LYS C 159      74.754  34.151  75.397  1.00 20.34           C  
ATOM   4830  O   LYS C 159      73.728  33.784  74.808  1.00 20.47           O  
ATOM   4831  CB  LYS C 159      76.752  34.991  74.006  1.00 20.58           C  
ATOM   4832  CG  LYS C 159      77.373  36.205  73.286  1.00 21.32           C  
ATOM   4833  CD  LYS C 159      76.459  36.725  72.141  1.00 22.06           C  
ATOM   4834  CE  LYS C 159      77.142  37.810  71.323  1.00 21.02           C  
ATOM   4835  NZ  LYS C 159      76.245  38.413  70.281  1.00 20.43           N  
ATOM   4836  N   PHE C 160      75.169  33.567  76.529  1.00 20.13           N  
ATOM   4837  CA  PHE C 160      74.327  32.550  77.180  1.00 20.29           C  
ATOM   4838  C   PHE C 160      72.976  33.172  77.532  1.00 20.35           C  
ATOM   4839  O   PHE C 160      71.941  32.502  77.449  1.00 19.80           O  
ATOM   4840  CB  PHE C 160      74.985  31.980  78.438  1.00 20.64           C  
ATOM   4841  CG  PHE C 160      75.966  30.865  78.176  1.00 20.20           C  
ATOM   4842  CD1 PHE C 160      77.277  31.140  77.782  1.00 21.78           C  
ATOM   4843  CD2 PHE C 160      75.594  29.534  78.380  1.00 21.48           C  
ATOM   4844  CE1 PHE C 160      78.199  30.101  77.586  1.00 21.76           C  
ATOM   4845  CE2 PHE C 160      76.494  28.490  78.192  1.00 21.91           C  
ATOM   4846  CZ  PHE C 160      77.808  28.768  77.781  1.00 23.46           C  
ATOM   4847  N   GLY C 161      72.983  34.444  77.934  1.00 20.57           N  
ATOM   4848  CA  GLY C 161      71.734  35.159  78.213  1.00 20.44           C  
ATOM   4849  C   GLY C 161      70.840  35.272  76.987  1.00 20.95           C  
ATOM   4850  O   GLY C 161      69.628  35.016  77.072  1.00 21.24           O  
ATOM   4851  N   VAL C 162      71.419  35.678  75.856  1.00 19.91           N  
ATOM   4852  CA  VAL C 162      70.668  35.773  74.588  1.00 20.47           C  
ATOM   4853  C   VAL C 162      70.021  34.410  74.296  1.00 20.60           C  
ATOM   4854  O   VAL C 162      68.836  34.338  73.947  1.00 21.46           O  
ATOM   4855  CB  VAL C 162      71.582  36.199  73.396  1.00 20.35           C  
ATOM   4856  CG1 VAL C 162      70.900  35.964  72.011  1.00 20.81           C  
ATOM   4857  CG2 VAL C 162      72.063  37.652  73.546  1.00 20.03           C  
ATOM   4858  N   ASN C 163      70.793  33.331  74.467  1.00 20.69           N  
ATOM   4859  CA  ASN C 163      70.276  31.984  74.173  1.00 20.54           C  
ATOM   4860  C   ASN C 163      69.085  31.605  75.047  1.00 20.88           C  
ATOM   4861  O   ASN C 163      68.058  31.128  74.532  1.00 20.84           O  
ATOM   4862  CB  ASN C 163      71.385  30.928  74.245  1.00 20.02           C  
ATOM   4863  CG  ASN C 163      72.340  31.017  73.059  1.00 23.08           C  
ATOM   4864  OD1 ASN C 163      72.350  32.000  72.339  1.00 24.28           O  
ATOM   4865  ND2 ASN C 163      73.134  29.988  72.863  1.00 27.33           N  
ATOM   4866  N   ALA C 164      69.206  31.845  76.361  1.00 20.57           N  
ATOM   4867  CA  ALA C 164      68.111  31.537  77.279  1.00 20.48           C  
ATOM   4868  C   ALA C 164      66.886  32.416  76.986  1.00 20.45           C  
ATOM   4869  O   ALA C 164      65.768  31.897  76.879  1.00 20.02           O  
ATOM   4870  CB  ALA C 164      68.553  31.664  78.739  1.00 20.95           C  
ATOM   4871  N   PHE C 165      67.104  33.727  76.823  1.00 20.41           N  
ATOM   4872  CA  PHE C 165      66.028  34.652  76.412  1.00 20.70           C  
ATOM   4873  C   PHE C 165      65.307  34.154  75.165  1.00 21.28           C  
ATOM   4874  O   PHE C 165      64.064  34.123  75.118  1.00 21.21           O  
ATOM   4875  CB  PHE C 165      66.600  36.050  76.155  1.00 20.51           C  
ATOM   4876  CG  PHE C 165      65.597  37.043  75.617  1.00 20.44           C  
ATOM   4877  CD1 PHE C 165      64.769  37.754  76.484  1.00 23.04           C  
ATOM   4878  CD2 PHE C 165      65.501  37.286  74.246  1.00 22.89           C  
ATOM   4879  CE1 PHE C 165      63.839  38.689  75.992  1.00 20.98           C  
ATOM   4880  CE2 PHE C 165      64.585  38.204  73.744  1.00 22.20           C  
ATOM   4881  CZ  PHE C 165      63.753  38.916  74.623  1.00 21.68           C  
ATOM   4882  N   SER C 166      66.090  33.744  74.172  1.00 20.74           N  
ATOM   4883  CA  SER C 166      65.560  33.311  72.863  1.00 21.56           C  
ATOM   4884  C   SER C 166      64.838  31.963  72.896  1.00 21.72           C  
ATOM   4885  O   SER C 166      63.811  31.813  72.236  1.00 22.44           O  
ATOM   4886  CB  SER C 166      66.652  33.319  71.802  1.00 21.16           C  
ATOM   4887  OG  SER C 166      67.227  34.619  71.702  1.00 21.62           O  
ATOM   4888  N   GLU C 167      65.335  30.996  73.678  1.00 22.22           N  
ATOM   4889  CA  GLU C 167      64.580  29.739  73.851  1.00 21.89           C  
ATOM   4890  C   GLU C 167      63.251  29.981  74.553  1.00 21.81           C  
ATOM   4891  O   GLU C 167      62.214  29.396  74.174  1.00 20.80           O  
ATOM   4892  CB  GLU C 167      65.403  28.662  74.568  1.00 23.02           C  
ATOM   4893  CG  GLU C 167      64.586  27.494  75.175  1.00 22.91           C  
ATOM   4894  CD  GLU C 167      63.714  26.733  74.166  1.00 24.36           C  
ATOM   4895  OE1 GLU C 167      63.934  26.819  72.933  1.00 25.42           O  
ATOM   4896  OE2 GLU C 167      62.799  26.028  74.617  1.00 24.75           O  
ATOM   4897  N   THR C 168      63.268  30.836  75.574  1.00 21.00           N  
ATOM   4898  CA  THR C 168      62.027  31.176  76.252  1.00 21.08           C  
ATOM   4899  C   THR C 168      61.075  31.891  75.313  1.00 20.98           C  
ATOM   4900  O   THR C 168      59.873  31.576  75.282  1.00 20.66           O  
ATOM   4901  CB  THR C 168      62.260  32.023  77.517  1.00 20.91           C  
ATOM   4902  OG1 THR C 168      63.274  31.397  78.317  1.00 21.82           O  
ATOM   4903  CG2 THR C 168      60.962  32.129  78.327  1.00 21.67           C  
ATOM   4904  N   LEU C 169      61.602  32.861  74.562  1.00 20.47           N  
ATOM   4905  CA  LEU C 169      60.804  33.541  73.540  1.00 20.60           C  
ATOM   4906  C   LEU C 169      60.140  32.552  72.571  1.00 20.66           C  
ATOM   4907  O   LEU C 169      58.930  32.661  72.296  1.00 20.44           O  
ATOM   4908  CB  LEU C 169      61.653  34.537  72.754  1.00 20.86           C  
ATOM   4909  CG  LEU C 169      60.916  35.289  71.643  1.00 21.06           C  
ATOM   4910  CD1 LEU C 169      59.975  36.336  72.226  1.00 23.51           C  
ATOM   4911  CD2 LEU C 169      61.901  35.927  70.706  1.00 21.77           C  
ATOM   4912  N   ARG C 170      60.917  31.585  72.080  1.00 20.78           N  
ATOM   4913  CA  ARG C 170      60.381  30.533  71.197  1.00 21.09           C  
ATOM   4914  C   ARG C 170      59.189  29.839  71.846  1.00 21.14           C  
ATOM   4915  O   ARG C 170      58.118  29.709  71.236  1.00 20.47           O  
ATOM   4916  CB  ARG C 170      61.459  29.505  70.841  1.00 20.65           C  
ATOM   4917  CG  ARG C 170      61.001  28.452  69.816  1.00 20.68           C  
ATOM   4918  CD  ARG C 170      61.941  27.245  69.810  1.00 20.39           C  
ATOM   4919  NE  ARG C 170      61.864  26.555  71.086  1.00 21.13           N  
ATOM   4920  CZ  ARG C 170      60.894  25.704  71.423  1.00 21.60           C  
ATOM   4921  NH1 ARG C 170      59.935  25.380  70.554  1.00 21.09           N  
ATOM   4922  NH2 ARG C 170      60.897  25.159  72.628  1.00 21.47           N  
ATOM   4923  N   GLN C 171      59.349  29.416  73.093  1.00 21.03           N  
ATOM   4924  CA  GLN C 171      58.224  28.794  73.805  1.00 21.39           C  
ATOM   4925  C   GLN C 171      56.963  29.678  73.841  1.00 21.54           C  
ATOM   4926  O   GLN C 171      55.847  29.178  73.705  1.00 21.17           O  
ATOM   4927  CB  GLN C 171      58.621  28.389  75.226  1.00 21.32           C  
ATOM   4928  CG  GLN C 171      59.664  27.292  75.315  1.00 22.14           C  
ATOM   4929  CD  GLN C 171      60.019  26.957  76.750  1.00 21.69           C  
ATOM   4930  OE1 GLN C 171      59.190  27.086  77.651  1.00 23.69           O  
ATOM   4931  NE2 GLN C 171      61.252  26.521  76.972  1.00 22.64           N  
ATOM   4932  N   GLU C 172      57.162  30.985  73.996  1.00 21.38           N  
ATOM   4933  CA  GLU C 172      56.076  31.963  74.107  1.00 21.78           C  
ATOM   4934  C   GLU C 172      55.375  32.332  72.789  1.00 21.37           C  
ATOM   4935  O   GLU C 172      54.174  32.635  72.773  1.00 20.44           O  
ATOM   4936  CB  GLU C 172      56.611  33.242  74.743  1.00 21.38           C  
ATOM   4937  CG  GLU C 172      56.794  33.157  76.260  1.00 23.33           C  
ATOM   4938  CD  GLU C 172      57.446  34.401  76.842  1.00 24.08           C  
ATOM   4939  OE1 GLU C 172      57.288  35.506  76.253  1.00 25.62           O  
ATOM   4940  OE2 GLU C 172      58.113  34.271  77.897  1.00 26.87           O  
ATOM   4941  N   VAL C 173      56.116  32.326  71.688  1.00 20.59           N  
ATOM   4942  CA  VAL C 173      55.557  32.837  70.421  1.00 20.90           C  
ATOM   4943  C   VAL C 173      55.437  31.804  69.298  1.00 21.10           C  
ATOM   4944  O   VAL C 173      54.790  32.082  68.267  1.00 20.72           O  
ATOM   4945  CB  VAL C 173      56.338  34.105  69.890  1.00 20.87           C  
ATOM   4946  CG1 VAL C 173      56.326  35.237  70.913  1.00 20.45           C  
ATOM   4947  CG2 VAL C 173      57.779  33.766  69.481  1.00 20.15           C  
ATOM   4948  N   THR C 174      56.064  30.636  69.461  1.00 21.18           N  
ATOM   4949  CA  THR C 174      56.182  29.716  68.317  1.00 21.92           C  
ATOM   4950  C   THR C 174      54.820  29.221  67.829  1.00 22.22           C  
ATOM   4951  O   THR C 174      54.615  29.062  66.626  1.00 22.62           O  
ATOM   4952  CB  THR C 174      57.199  28.545  68.522  1.00 21.44           C  
ATOM   4953  OG1 THR C 174      57.566  28.007  67.238  1.00 21.14           O  
ATOM   4954  CG2 THR C 174      56.624  27.423  69.438  1.00 20.40           C  
ATOM   4955  N   GLU C 175      53.878  29.029  68.749  1.00 22.83           N  
ATOM   4956  CA  GLU C 175      52.547  28.556  68.355  1.00 23.04           C  
ATOM   4957  C   GLU C 175      51.783  29.606  67.543  1.00 23.03           C  
ATOM   4958  O   GLU C 175      50.858  29.268  66.815  1.00 22.80           O  
ATOM   4959  CB  GLU C 175      51.736  28.122  69.574  1.00 23.74           C  
ATOM   4960  CG  GLU C 175      52.270  26.883  70.265  1.00 24.12           C  
ATOM   4961  CD  GLU C 175      51.744  26.758  71.680  1.00 27.06           C  
ATOM   4962  OE1 GLU C 175      51.931  27.712  72.467  1.00 27.36           O  
ATOM   4963  OE2 GLU C 175      51.144  25.710  72.011  1.00 28.21           O  
ATOM   4964  N   ARG C 176      52.173  30.874  67.667  1.00 22.74           N  
ATOM   4965  CA  ARG C 176      51.544  31.946  66.883  1.00 22.69           C  
ATOM   4966  C   ARG C 176      52.319  32.213  65.584  1.00 22.38           C  
ATOM   4967  O   ARG C 176      52.058  33.183  64.867  1.00 22.57           O  
ATOM   4968  CB  ARG C 176      51.365  33.213  67.733  1.00 22.51           C  
ATOM   4969  CG  ARG C 176      50.199  33.113  68.707  1.00 21.69           C  
ATOM   4970  CD  ARG C 176      50.158  34.289  69.643  1.00 22.10           C  
ATOM   4971  NE  ARG C 176      51.287  34.243  70.575  1.00 21.25           N  
ATOM   4972  CZ  ARG C 176      51.724  35.278  71.283  1.00 21.34           C  
ATOM   4973  NH1 ARG C 176      51.151  36.469  71.168  1.00 21.44           N  
ATOM   4974  NH2 ARG C 176      52.750  35.117  72.100  1.00 21.94           N  
ATOM   4975  N   GLY C 177      53.270  31.333  65.284  1.00 21.96           N  
ATOM   4976  CA  GLY C 177      53.943  31.346  63.993  1.00 21.79           C  
ATOM   4977  C   GLY C 177      55.164  32.240  63.856  1.00 21.79           C  
ATOM   4978  O   GLY C 177      55.678  32.403  62.744  1.00 22.12           O  
ATOM   4979  N   VAL C 178      55.634  32.811  64.966  1.00 21.55           N  
ATOM   4980  CA  VAL C 178      56.886  33.571  64.962  1.00 21.32           C  
ATOM   4981  C   VAL C 178      58.047  32.604  65.216  1.00 21.50           C  
ATOM   4982  O   VAL C 178      58.124  31.962  66.263  1.00 21.11           O  
ATOM   4983  CB  VAL C 178      56.907  34.720  66.014  1.00 21.50           C  
ATOM   4984  CG1 VAL C 178      58.289  35.421  66.021  1.00 22.18           C  
ATOM   4985  CG2 VAL C 178      55.802  35.733  65.744  1.00 21.51           C  
ATOM   4986  N   ARG C 179      58.952  32.510  64.251  1.00 21.06           N  
ATOM   4987  CA  ARG C 179      60.061  31.577  64.356  1.00 20.64           C  
ATOM   4988  C   ARG C 179      61.241  32.259  65.030  1.00 21.04           C  
ATOM   4989  O   ARG C 179      61.605  33.382  64.660  1.00 20.65           O  
ATOM   4990  CB  ARG C 179      60.461  31.067  62.962  1.00 20.87           C  
ATOM   4991  CG  ARG C 179      59.318  30.418  62.193  1.00 20.62           C  
ATOM   4992  CD  ARG C 179      59.852  29.717  60.969  1.00 22.48           C  
ATOM   4993  NE  ARG C 179      60.426  30.654  60.003  1.00 21.14           N  
ATOM   4994  CZ  ARG C 179      60.943  30.296  58.833  1.00 23.27           C  
ATOM   4995  NH1 ARG C 179      60.962  29.020  58.476  1.00 21.62           N  
ATOM   4996  NH2 ARG C 179      61.439  31.222  58.013  1.00 21.97           N  
ATOM   4997  N   VAL C 180      61.837  31.570  66.008  1.00 20.92           N  
ATOM   4998  CA  VAL C 180      63.021  32.085  66.691  1.00 20.88           C  
ATOM   4999  C   VAL C 180      64.242  31.261  66.295  1.00 21.34           C  
ATOM   5000  O   VAL C 180      64.317  30.056  66.580  1.00 20.87           O  
ATOM   5001  CB  VAL C 180      62.841  32.127  68.210  1.00 20.87           C  
ATOM   5002  CG1 VAL C 180      64.067  32.795  68.881  1.00 22.59           C  
ATOM   5003  CG2 VAL C 180      61.547  32.867  68.555  1.00 21.14           C  
ATOM   5004  N   VAL C 181      65.171  31.942  65.617  1.00 20.65           N  
ATOM   5005  CA  VAL C 181      66.382  31.340  65.085  1.00 20.86           C  
ATOM   5006  C   VAL C 181      67.567  31.923  65.872  1.00 21.26           C  
ATOM   5007  O   VAL C 181      67.644  33.150  66.082  1.00 22.62           O  
ATOM   5008  CB  VAL C 181      66.531  31.641  63.552  1.00 20.80           C  
ATOM   5009  CG1 VAL C 181      67.913  31.262  63.040  1.00 20.56           C  
ATOM   5010  CG2 VAL C 181      65.422  30.961  62.737  1.00 19.34           C  
ATOM   5011  N   VAL C 182      68.490  31.060  66.289  1.00 20.72           N  
ATOM   5012  CA  VAL C 182      69.707  31.519  66.982  1.00 20.76           C  
ATOM   5013  C   VAL C 182      70.931  31.023  66.236  1.00 20.98           C  
ATOM   5014  O   VAL C 182      71.099  29.802  66.052  1.00 21.17           O  
ATOM   5015  CB  VAL C 182      69.760  31.037  68.458  1.00 20.48           C  
ATOM   5016  CG1 VAL C 182      71.016  31.552  69.146  1.00 22.00           C  
ATOM   5017  CG2 VAL C 182      68.511  31.498  69.221  1.00 21.99           C  
ATOM   5018  N   ILE C 183      71.776  31.964  65.816  1.00 20.77           N  
ATOM   5019  CA  ILE C 183      72.959  31.657  65.038  1.00 20.84           C  
ATOM   5020  C   ILE C 183      74.137  31.834  65.976  1.00 20.78           C  
ATOM   5021  O   ILE C 183      74.225  32.837  66.688  1.00 20.92           O  
ATOM   5022  CB  ILE C 183      73.143  32.617  63.814  1.00 20.53           C  
ATOM   5023  CG1 ILE C 183      71.881  32.706  62.952  1.00 21.49           C  
ATOM   5024  CG2 ILE C 183      74.378  32.212  62.963  1.00 20.15           C  
ATOM   5025  CD1 ILE C 183      71.524  31.464  62.154  1.00 21.72           C  
ATOM   5026  N   GLU C 184      75.026  30.853  65.986  1.00 20.94           N  
ATOM   5027  CA  GLU C 184      76.146  30.841  66.918  1.00 21.44           C  
ATOM   5028  C   GLU C 184      77.451  30.677  66.143  1.00 21.72           C  
ATOM   5029  O   GLU C 184      77.948  29.555  65.987  1.00 21.58           O  
ATOM   5030  CB  GLU C 184      75.980  29.720  67.950  1.00 21.69           C  
ATOM   5031  CG  GLU C 184      74.768  29.920  68.852  1.00 22.14           C  
ATOM   5032  CD  GLU C 184      74.172  28.623  69.390  1.00 25.07           C  
ATOM   5033  OE1 GLU C 184      74.591  27.504  68.983  1.00 24.54           O  
ATOM   5034  OE2 GLU C 184      73.269  28.738  70.249  1.00 27.72           O  
ATOM   5035  N   PRO C 185      78.002  31.795  65.637  1.00 21.77           N  
ATOM   5036  CA  PRO C 185      79.304  31.694  64.967  1.00 21.66           C  
ATOM   5037  C   PRO C 185      80.475  31.542  65.920  1.00 21.30           C  
ATOM   5038  O   PRO C 185      80.469  32.115  67.020  1.00 21.20           O  
ATOM   5039  CB  PRO C 185      79.442  33.052  64.245  1.00 21.45           C  
ATOM   5040  CG  PRO C 185      78.076  33.668  64.287  1.00 22.31           C  
ATOM   5041  CD  PRO C 185      77.469  33.167  65.562  1.00 21.45           C  
ATOM   5042  N   GLY C 186      81.479  30.790  65.474  1.00 20.98           N  
ATOM   5043  CA  GLY C 186      82.822  30.849  66.053  1.00 20.60           C  
ATOM   5044  C   GLY C 186      83.601  31.984  65.399  1.00 21.22           C  
ATOM   5045  O   GLY C 186      83.004  32.864  64.772  1.00 20.78           O  
ATOM   5046  N   THR C 187      84.927  31.952  65.533  1.00 21.01           N  
ATOM   5047  CA  THR C 187      85.804  33.028  65.037  1.00 20.97           C  
ATOM   5048  C   THR C 187      85.527  33.390  63.573  1.00 20.69           C  
ATOM   5049  O   THR C 187      85.709  32.570  62.667  1.00 20.15           O  
ATOM   5050  CB  THR C 187      87.292  32.653  65.193  1.00 21.23           C  
ATOM   5051  OG1 THR C 187      87.511  32.162  66.523  1.00 22.31           O  
ATOM   5052  CG2 THR C 187      88.197  33.868  64.924  1.00 21.75           C  
ATOM   5053  N   THR C 188      85.109  34.634  63.373  1.00 20.52           N  
ATOM   5054  CA  THR C 188      84.723  35.160  62.065  1.00 20.80           C  
ATOM   5055  C   THR C 188      85.514  36.442  61.788  1.00 21.85           C  
ATOM   5056  O   THR C 188      85.692  37.286  62.675  1.00 21.26           O  
ATOM   5057  CB  THR C 188      83.174  35.410  62.004  1.00 20.41           C  
ATOM   5058  OG1 THR C 188      82.484  34.223  62.409  1.00 20.04           O  
ATOM   5059  CG2 THR C 188      82.703  35.770  60.609  1.00 19.83           C  
ATOM   5060  N   ASP C 189      85.987  36.573  60.553  1.00 22.15           N  
ATOM   5061  CA  ASP C 189      86.886  37.663  60.167  1.00 23.60           C  
ATOM   5062  C   ASP C 189      86.122  38.973  59.991  1.00 23.38           C  
ATOM   5063  O   ASP C 189      85.692  39.323  58.886  1.00 23.58           O  
ATOM   5064  CB  ASP C 189      87.649  37.295  58.890  1.00 23.50           C  
ATOM   5065  CG  ASP C 189      88.813  38.246  58.594  1.00 25.90           C  
ATOM   5066  OD1 ASP C 189      89.251  39.011  59.487  1.00 27.92           O  
ATOM   5067  OD2 ASP C 189      89.294  38.212  57.450  1.00 28.53           O  
ATOM   5068  N   THR C 190      85.955  39.684  61.101  1.00 23.78           N  
ATOM   5069  CA  THR C 190      85.253  40.965  61.113  1.00 23.81           C  
ATOM   5070  C   THR C 190      86.063  42.010  61.885  1.00 24.31           C  
ATOM   5071  O   THR C 190      87.194  41.748  62.305  1.00 24.46           O  
ATOM   5072  CB  THR C 190      83.876  40.835  61.779  1.00 23.76           C  
ATOM   5073  OG1 THR C 190      84.040  40.607  63.194  1.00 22.84           O  
ATOM   5074  CG2 THR C 190      83.065  39.687  61.156  1.00 23.37           C  
ATOM   5075  N   GLU C 191      85.450  43.171  62.102  1.00 24.57           N  
ATOM   5076  CA  GLU C 191      86.045  44.259  62.886  1.00 24.73           C  
ATOM   5077  C   GLU C 191      85.913  44.054  64.397  1.00 24.50           C  
ATOM   5078  O   GLU C 191      86.460  44.836  65.178  1.00 24.24           O  
ATOM   5079  CB  GLU C 191      85.376  45.589  62.528  1.00 24.93           C  
ATOM   5080  CG  GLU C 191      85.499  46.000  61.073  1.00 24.98           C  
ATOM   5081  CD  GLU C 191      84.886  47.365  60.799  1.00 25.23           C  
ATOM   5082  OE1 GLU C 191      84.252  47.944  61.710  1.00 23.63           O  
ATOM   5083  OE2 GLU C 191      85.038  47.857  59.662  1.00 26.61           O  
ATOM   5084  N   LEU C 192      85.196  43.009  64.802  1.00 24.14           N  
ATOM   5085  CA  LEU C 192      84.833  42.817  66.213  1.00 24.58           C  
ATOM   5086  C   LEU C 192      86.032  42.956  67.152  1.00 24.90           C  
ATOM   5087  O   LEU C 192      85.967  43.672  68.157  1.00 25.19           O  
ATOM   5088  CB  LEU C 192      84.159  41.450  66.418  1.00 24.00           C  
ATOM   5089  CG  LEU C 192      83.495  41.150  67.763  1.00 24.31           C  
ATOM   5090  CD1 LEU C 192      82.224  41.968  67.944  1.00 23.42           C  
ATOM   5091  CD2 LEU C 192      83.169  39.659  67.856  1.00 24.13           C  
ATOM   5092  N   ARG C 193      87.126  42.279  66.812  1.00 25.32           N  
ATOM   5093  CA  ARG C 193      88.268  42.185  67.718  1.00 25.84           C  
ATOM   5094  C   ARG C 193      88.977  43.506  67.927  1.00 25.76           C  
ATOM   5095  O   ARG C 193      89.626  43.698  68.956  1.00 25.92           O  
ATOM   5096  CB  ARG C 193      89.260  41.128  67.249  1.00 26.48           C  
ATOM   5097  CG  ARG C 193      89.816  41.347  65.881  1.00 27.53           C  
ATOM   5098  CD  ARG C 193      90.605  40.134  65.468  1.00 30.96           C  
ATOM   5099  NE  ARG C 193      91.301  40.327  64.200  1.00 31.49           N  
ATOM   5100  CZ  ARG C 193      90.774  40.100  62.995  1.00 33.60           C  
ATOM   5101  NH1 ARG C 193      89.516  39.686  62.857  1.00 33.41           N  
ATOM   5102  NH2 ARG C 193      91.512  40.303  61.915  1.00 33.23           N  
ATOM   5103  N   GLY C 194      88.849  44.410  66.953  1.00 25.46           N  
ATOM   5104  CA  GLY C 194      89.467  45.729  67.029  1.00 25.74           C  
ATOM   5105  C   GLY C 194      89.107  46.525  68.274  1.00 25.53           C  
ATOM   5106  O   GLY C 194      89.876  47.389  68.697  1.00 25.28           O  
ATOM   5107  N   HIS C 195      87.947  46.228  68.866  1.00 25.23           N  
ATOM   5108  CA  HIS C 195      87.414  47.036  69.969  1.00 25.47           C  
ATOM   5109  C   HIS C 195      87.830  46.604  71.370  1.00 25.04           C  
ATOM   5110  O   HIS C 195      87.586  47.334  72.330  1.00 25.12           O  
ATOM   5111  CB  HIS C 195      85.887  47.143  69.879  1.00 25.86           C  
ATOM   5112  CG  HIS C 195      85.415  47.759  68.604  1.00 26.95           C  
ATOM   5113  ND1 HIS C 195      84.844  47.025  67.588  1.00 28.58           N  
ATOM   5114  CD2 HIS C 195      85.475  49.036  68.159  1.00 28.46           C  
ATOM   5115  CE1 HIS C 195      84.550  47.826  66.580  1.00 28.29           C  
ATOM   5116  NE2 HIS C 195      84.924  49.051  66.899  1.00 29.74           N  
ATOM   5117  N   ILE C 196      88.456  45.433  71.486  1.00 24.70           N  
ATOM   5118  CA  ILE C 196      88.923  44.931  72.785  1.00 24.29           C  
ATOM   5119  C   ILE C 196      89.822  45.979  73.444  1.00 24.15           C  
ATOM   5120  O   ILE C 196      90.774  46.477  72.812  1.00 23.44           O  
ATOM   5121  CB  ILE C 196      89.679  43.587  72.637  1.00 24.72           C  
ATOM   5122  CG1 ILE C 196      88.735  42.503  72.100  1.00 24.28           C  
ATOM   5123  CG2 ILE C 196      90.309  43.166  73.972  1.00 24.30           C  
ATOM   5124  CD1 ILE C 196      89.451  41.342  71.393  1.00 26.70           C  
ATOM   5125  N   THR C 197      89.506  46.318  74.697  1.00 23.74           N  
ATOM   5126  CA  THR C 197      90.191  47.407  75.410  1.00 24.03           C  
ATOM   5127  C   THR C 197      91.345  46.912  76.289  1.00 24.41           C  
ATOM   5128  O   THR C 197      92.282  47.664  76.562  1.00 24.03           O  
ATOM   5129  CB  THR C 197      89.216  48.229  76.284  1.00 23.97           C  
ATOM   5130  OG1 THR C 197      88.675  47.390  77.311  1.00 22.55           O  
ATOM   5131  CG2 THR C 197      88.081  48.806  75.453  1.00 23.40           C  
ATOM   5132  N   HIS C 198      91.275  45.655  76.729  1.00 24.40           N  
ATOM   5133  CA  HIS C 198      92.344  45.078  77.545  1.00 25.23           C  
ATOM   5134  C   HIS C 198      93.494  44.614  76.651  1.00 25.20           C  
ATOM   5135  O   HIS C 198      93.435  43.554  76.028  1.00 24.79           O  
ATOM   5136  CB  HIS C 198      91.828  43.945  78.440  1.00 25.01           C  
ATOM   5137  CG  HIS C 198      92.791  43.543  79.516  1.00 25.26           C  
ATOM   5138  ND1 HIS C 198      93.627  42.451  79.400  1.00 23.98           N  
ATOM   5139  CD2 HIS C 198      93.045  44.082  80.733  1.00 25.05           C  
ATOM   5140  CE1 HIS C 198      94.356  42.338  80.498  1.00 24.65           C  
ATOM   5141  NE2 HIS C 198      94.024  43.318  81.321  1.00 24.57           N  
ATOM   5142  N   THR C 199      94.544  45.432  76.612  1.00 25.57           N  
ATOM   5143  CA  THR C 199      95.630  45.287  75.649  1.00 25.96           C  
ATOM   5144  C   THR C 199      96.246  43.885  75.606  1.00 25.65           C  
ATOM   5145  O   THR C 199      96.351  43.287  74.533  1.00 25.87           O  
ATOM   5146  CB  THR C 199      96.725  46.356  75.901  1.00 26.23           C  
ATOM   5147  OG1 THR C 199      96.095  47.624  76.113  1.00 27.19           O  
ATOM   5148  CG2 THR C 199      97.674  46.459  74.713  1.00 27.03           C  
ATOM   5149  N   ALA C 200      96.642  43.368  76.765  1.00 25.45           N  
ATOM   5150  CA  ALA C 200      97.232  42.032  76.854  1.00 25.37           C  
ATOM   5151  C   ALA C 200      96.301  40.964  76.264  1.00 25.32           C  
ATOM   5152  O   ALA C 200      96.746  40.073  75.536  1.00 24.87           O  
ATOM   5153  CB  ALA C 200      97.584  41.703  78.302  1.00 25.28           C  
ATOM   5154  N   THR C 201      95.010  41.066  76.575  1.00 25.21           N  
ATOM   5155  CA  THR C 201      94.018  40.100  76.103  1.00 25.10           C  
ATOM   5156  C   THR C 201      93.788  40.223  74.587  1.00 25.67           C  
ATOM   5157  O   THR C 201      93.720  39.209  73.883  1.00 25.55           O  
ATOM   5158  CB  THR C 201      92.686  40.235  76.867  1.00 25.17           C  
ATOM   5159  OG1 THR C 201      92.935  40.213  78.280  1.00 24.11           O  
ATOM   5160  CG2 THR C 201      91.738  39.096  76.502  1.00 24.41           C  
ATOM   5161  N   LYS C 202      93.686  41.458  74.095  1.00 26.45           N  
ATOM   5162  CA  LYS C 202      93.574  41.710  72.657  1.00 27.29           C  
ATOM   5163  C   LYS C 202      94.708  41.029  71.894  1.00 27.98           C  
ATOM   5164  O   LYS C 202      94.473  40.367  70.880  1.00 28.07           O  
ATOM   5165  CB  LYS C 202      93.563  43.216  72.359  1.00 27.32           C  
ATOM   5166  CG  LYS C 202      93.550  43.547  70.871  1.00 28.42           C  
ATOM   5167  CD  LYS C 202      93.173  44.985  70.606  1.00 29.08           C  
ATOM   5168  CE  LYS C 202      92.911  45.189  69.125  1.00 30.16           C  
ATOM   5169  NZ  LYS C 202      92.486  46.589  68.835  1.00 32.17           N  
ATOM   5170  N   GLU C 203      95.931  41.189  72.395  1.00 28.36           N  
ATOM   5171  CA  GLU C 203      97.098  40.607  71.750  1.00 29.39           C  
ATOM   5172  C   GLU C 203      97.078  39.079  71.828  1.00 29.51           C  
ATOM   5173  O   GLU C 203      97.382  38.402  70.845  1.00 29.25           O  
ATOM   5174  CB  GLU C 203      98.390  41.219  72.321  1.00 29.68           C  
ATOM   5175  CG  GLU C 203      98.848  42.503  71.593  1.00 32.44           C  
ATOM   5176  CD  GLU C 203      97.693  43.460  71.239  1.00 36.02           C  
ATOM   5177  OE1 GLU C 203      97.197  43.410  70.084  1.00 37.71           O  
ATOM   5178  OE2 GLU C 203      97.279  44.259  72.112  1.00 36.10           O  
HETATM 5179  N   MSE C 204      96.670  38.543  72.977  1.00 29.84           N  
HETATM 5180  CA  MSE C 204      96.505  37.101  73.139  1.00 31.01           C  
HETATM 5181  C   MSE C 204      95.469  36.539  72.167  1.00 29.99           C  
HETATM 5182  O   MSE C 204      95.690  35.500  71.532  1.00 29.78           O  
HETATM 5183  CB  MSE C 204      96.083  36.769  74.568  1.00 30.92           C  
HETATM 5184  CG  MSE C 204      97.241  36.650  75.521  1.00 32.65           C  
HETATM 5185 SE   MSE C 204      96.561  36.330  77.290  0.60 35.95          SE  
HETATM 5186  CE  MSE C 204      95.637  34.689  76.952  1.00 33.09           C  
ATOM   5187  N   TYR C 205      94.346  37.237  72.052  1.00 29.55           N  
ATOM   5188  CA  TYR C 205      93.263  36.799  71.179  1.00 29.61           C  
ATOM   5189  C   TYR C 205      93.712  36.806  69.705  1.00 30.01           C  
ATOM   5190  O   TYR C 205      93.523  35.822  68.977  1.00 29.72           O  
ATOM   5191  CB  TYR C 205      92.011  37.653  71.419  1.00 29.09           C  
ATOM   5192  CG  TYR C 205      90.835  37.283  70.549  1.00 28.31           C  
ATOM   5193  CD1 TYR C 205      90.046  36.168  70.838  1.00 27.78           C  
ATOM   5194  CD2 TYR C 205      90.515  38.047  69.429  1.00 28.13           C  
ATOM   5195  CE1 TYR C 205      88.964  35.835  70.027  1.00 28.00           C  
ATOM   5196  CE2 TYR C 205      89.449  37.720  68.616  1.00 27.85           C  
ATOM   5197  CZ  TYR C 205      88.678  36.617  68.914  1.00 28.42           C  
ATOM   5198  OH  TYR C 205      87.616  36.305  68.098  1.00 28.52           O  
ATOM   5199  N   GLU C 206      94.357  37.892  69.287  1.00 30.74           N  
ATOM   5200  CA  GLU C 206      94.777  38.030  67.893  1.00 31.44           C  
ATOM   5201  C   GLU C 206      95.803  36.973  67.527  1.00 31.46           C  
ATOM   5202  O   GLU C 206      95.778  36.448  66.418  1.00 31.26           O  
ATOM   5203  CB  GLU C 206      95.272  39.443  67.595  1.00 31.69           C  
ATOM   5204  CG  GLU C 206      94.158  40.473  67.778  1.00 34.14           C  
ATOM   5205  CD  GLU C 206      94.308  41.689  66.901  1.00 36.80           C  
ATOM   5206  OE1 GLU C 206      95.452  42.164  66.708  1.00 39.35           O  
ATOM   5207  OE2 GLU C 206      93.268  42.179  66.406  1.00 38.26           O  
ATOM   5208  N   GLN C 207      96.664  36.626  68.480  1.00 31.75           N  
ATOM   5209  CA  GLN C 207      97.655  35.578  68.271  1.00 32.51           C  
ATOM   5210  C   GLN C 207      97.009  34.198  68.092  1.00 32.46           C  
ATOM   5211  O   GLN C 207      97.401  33.429  67.204  1.00 32.68           O  
ATOM   5212  CB  GLN C 207      98.679  35.566  69.413  1.00 32.87           C  
ATOM   5213  CG  GLN C 207      99.917  34.715  69.150  1.00 34.49           C  
ATOM   5214  CD  GLN C 207     100.471  34.895  67.748  1.00 36.60           C  
ATOM   5215  OE1 GLN C 207     100.834  36.002  67.346  1.00 37.12           O  
ATOM   5216  NE2 GLN C 207     100.532  33.800  66.992  1.00 37.39           N  
ATOM   5217  N   ARG C 208      96.015  33.909  68.925  1.00 32.31           N  
ATOM   5218  CA  ARG C 208      95.270  32.654  68.875  1.00 32.68           C  
ATOM   5219  C   ARG C 208      94.569  32.476  67.525  1.00 31.62           C  
ATOM   5220  O   ARG C 208      94.700  31.428  66.889  1.00 32.06           O  
ATOM   5221  CB  ARG C 208      94.265  32.604  70.031  1.00 32.92           C  
ATOM   5222  CG  ARG C 208      93.517  31.273  70.221  1.00 34.49           C  
ATOM   5223  CD  ARG C 208      92.969  31.106  71.653  1.00 35.17           C  
ATOM   5224  NE  ARG C 208      92.421  32.350  72.213  1.00 39.73           N  
ATOM   5225  CZ  ARG C 208      93.029  33.107  73.130  1.00 40.87           C  
ATOM   5226  NH1 ARG C 208      94.220  32.763  73.625  1.00 40.99           N  
ATOM   5227  NH2 ARG C 208      92.443  34.219  73.552  1.00 41.30           N  
ATOM   5228  N   ILE C 209      93.866  33.509  67.071  1.00 30.08           N  
ATOM   5229  CA  ILE C 209      93.062  33.393  65.858  1.00 29.07           C  
ATOM   5230  C   ILE C 209      93.849  33.505  64.548  1.00 28.47           C  
ATOM   5231  O   ILE C 209      93.360  33.104  63.496  1.00 28.12           O  
ATOM   5232  CB  ILE C 209      91.851  34.358  65.867  1.00 29.17           C  
ATOM   5233  CG1 ILE C 209      92.312  35.817  65.800  1.00 29.27           C  
ATOM   5234  CG2 ILE C 209      90.977  34.084  67.101  1.00 28.56           C  
ATOM   5235  CD1 ILE C 209      91.192  36.809  65.603  1.00 28.98           C  
ATOM   5236  N   SER C 210      95.069  34.033  64.617  1.00 27.86           N  
ATOM   5237  CA  SER C 210      95.920  34.164  63.435  1.00 27.26           C  
ATOM   5238  C   SER C 210      96.305  32.804  62.839  1.00 27.16           C  
ATOM   5239  O   SER C 210      96.718  32.713  61.677  1.00 26.90           O  
ATOM   5240  CB  SER C 210      97.185  34.962  63.783  1.00 27.21           C  
ATOM   5241  OG  SER C 210      98.031  34.239  64.667  1.00 26.11           O  
ATOM   5242  N   GLN C 211      96.162  31.754  63.643  1.00 26.40           N  
ATOM   5243  CA  GLN C 211      96.654  30.422  63.292  1.00 26.26           C  
ATOM   5244  C   GLN C 211      95.593  29.520  62.636  1.00 25.07           C  
ATOM   5245  O   GLN C 211      95.852  28.348  62.340  1.00 24.30           O  
ATOM   5246  CB  GLN C 211      97.249  29.751  64.546  1.00 26.69           C  
ATOM   5247  CG  GLN C 211      98.270  30.612  65.316  1.00 28.90           C  
ATOM   5248  CD  GLN C 211      99.609  30.782  64.587  1.00 31.60           C  
ATOM   5249  OE1 GLN C 211     100.594  30.108  64.908  1.00 33.56           O  
ATOM   5250  NE2 GLN C 211      99.653  31.694  63.612  1.00 33.25           N  
ATOM   5251  N   ILE C 212      94.402  30.073  62.418  1.00 24.04           N  
ATOM   5252  CA  ILE C 212      93.291  29.321  61.841  1.00 23.12           C  
ATOM   5253  C   ILE C 212      92.722  30.035  60.609  1.00 22.98           C  
ATOM   5254  O   ILE C 212      92.816  31.257  60.501  1.00 22.62           O  
ATOM   5255  CB  ILE C 212      92.136  29.085  62.873  1.00 23.00           C  
ATOM   5256  CG1 ILE C 212      91.587  30.411  63.415  1.00 21.98           C  
ATOM   5257  CG2 ILE C 212      92.615  28.198  64.027  1.00 22.82           C  
ATOM   5258  CD1 ILE C 212      90.078  30.402  63.745  1.00 23.38           C  
ATOM   5259  N   ARG C 213      92.138  29.267  59.688  1.00 22.13           N  
ATOM   5260  CA  ARG C 213      91.279  29.852  58.668  1.00 22.38           C  
ATOM   5261  C   ARG C 213      89.989  30.269  59.363  1.00 21.97           C  
ATOM   5262  O   ARG C 213      89.268  29.423  59.907  1.00 21.84           O  
ATOM   5263  CB  ARG C 213      90.979  28.861  57.545  1.00 22.33           C  
ATOM   5264  CG  ARG C 213      92.180  28.468  56.697  1.00 23.77           C  
ATOM   5265  CD  ARG C 213      91.858  27.249  55.829  1.00 26.86           C  
ATOM   5266  NE  ARG C 213      91.269  26.171  56.629  1.00 26.47           N  
ATOM   5267  CZ  ARG C 213      90.616  25.120  56.140  1.00 26.65           C  
ATOM   5268  NH1 ARG C 213      90.458  24.971  54.829  1.00 24.50           N  
ATOM   5269  NH2 ARG C 213      90.118  24.211  56.977  1.00 26.91           N  
ATOM   5270  N   LYS C 214      89.712  31.571  59.358  1.00 21.48           N  
ATOM   5271  CA  LYS C 214      88.542  32.112  60.052  1.00 21.02           C  
ATOM   5272  C   LYS C 214      87.268  31.916  59.231  1.00 20.93           C  
ATOM   5273  O   LYS C 214      87.310  31.833  57.988  1.00 20.09           O  
ATOM   5274  CB  LYS C 214      88.728  33.609  60.340  1.00 20.64           C  
ATOM   5275  CG  LYS C 214      89.865  33.949  61.275  1.00 22.09           C  
ATOM   5276  CD  LYS C 214      89.856  35.429  61.617  1.00 24.41           C  
ATOM   5277  CE  LYS C 214      91.194  35.888  62.185  1.00 26.01           C  
ATOM   5278  NZ  LYS C 214      92.259  35.987  61.152  1.00 28.30           N  
ATOM   5279  N   LEU C 215      86.134  31.855  59.923  1.00 20.60           N  
ATOM   5280  CA  LEU C 215      84.841  31.951  59.246  1.00 20.89           C  
ATOM   5281  C   LEU C 215      84.735  33.306  58.555  1.00 21.34           C  
ATOM   5282  O   LEU C 215      85.328  34.295  59.009  1.00 22.01           O  
ATOM   5283  CB  LEU C 215      83.688  31.765  60.235  1.00 20.70           C  
ATOM   5284  CG  LEU C 215      83.589  30.403  60.923  1.00 19.23           C  
ATOM   5285  CD1 LEU C 215      82.396  30.403  61.878  1.00 20.16           C  
ATOM   5286  CD2 LEU C 215      83.437  29.292  59.886  1.00 18.52           C  
ATOM   5287  N   GLN C 216      84.021  33.343  57.437  1.00 20.92           N  
ATOM   5288  CA  GLN C 216      83.807  34.588  56.721  1.00 21.48           C  
ATOM   5289  C   GLN C 216      82.435  35.157  57.038  1.00 21.43           C  
ATOM   5290  O   GLN C 216      81.498  34.410  57.303  1.00 20.97           O  
ATOM   5291  CB  GLN C 216      83.972  34.365  55.213  1.00 21.28           C  
ATOM   5292  CG  GLN C 216      85.347  33.832  54.854  1.00 23.67           C  
ATOM   5293  CD  GLN C 216      86.451  34.761  55.319  1.00 26.59           C  
ATOM   5294  OE1 GLN C 216      86.535  35.907  54.869  1.00 29.64           O  
ATOM   5295  NE2 GLN C 216      87.298  34.280  56.226  1.00 25.96           N  
ATOM   5296  N   ALA C 217      82.308  36.482  57.013  1.00 21.35           N  
ATOM   5297  CA  ALA C 217      81.009  37.098  57.285  1.00 21.94           C  
ATOM   5298  C   ALA C 217      79.958  36.525  56.330  1.00 21.90           C  
ATOM   5299  O   ALA C 217      78.815  36.315  56.728  1.00 22.17           O  
ATOM   5300  CB  ALA C 217      81.084  38.608  57.150  1.00 21.86           C  
ATOM   5301  N   GLN C 218      80.358  36.273  55.077  1.00 22.01           N  
ATOM   5302  CA  GLN C 218      79.467  35.624  54.091  1.00 22.76           C  
ATOM   5303  C   GLN C 218      78.993  34.216  54.507  1.00 21.45           C  
ATOM   5304  O   GLN C 218      77.877  33.834  54.197  1.00 20.97           O  
ATOM   5305  CB  GLN C 218      80.102  35.598  52.690  1.00 22.97           C  
ATOM   5306  CG  GLN C 218      81.293  34.663  52.543  1.00 25.64           C  
ATOM   5307  CD  GLN C 218      82.034  34.824  51.221  1.00 25.92           C  
ATOM   5308  OE1 GLN C 218      81.515  35.402  50.259  1.00 30.45           O  
ATOM   5309  NE2 GLN C 218      83.258  34.301  51.171  1.00 29.95           N  
ATOM   5310  N   ASP C 219      79.840  33.454  55.203  1.00 20.94           N  
ATOM   5311  CA  ASP C 219      79.438  32.143  55.722  1.00 20.38           C  
ATOM   5312  C   ASP C 219      78.271  32.275  56.701  1.00 20.37           C  
ATOM   5313  O   ASP C 219      77.326  31.492  56.650  1.00 19.85           O  
ATOM   5314  CB  ASP C 219      80.609  31.430  56.411  1.00 21.22           C  
ATOM   5315  CG  ASP C 219      81.817  31.259  55.500  1.00 21.33           C  
ATOM   5316  OD1 ASP C 219      81.641  31.183  54.258  1.00 21.66           O  
ATOM   5317  OD2 ASP C 219      82.956  31.191  56.019  1.00 21.70           O  
ATOM   5318  N   ILE C 220      78.350  33.263  57.592  1.00 19.55           N  
ATOM   5319  CA  ILE C 220      77.308  33.471  58.614  1.00 20.22           C  
ATOM   5320  C   ILE C 220      76.023  33.972  57.954  1.00 19.94           C  
ATOM   5321  O   ILE C 220      74.928  33.544  58.317  1.00 19.83           O  
ATOM   5322  CB  ILE C 220      77.762  34.437  59.753  1.00 20.11           C  
ATOM   5323  CG1 ILE C 220      79.168  34.074  60.275  1.00 21.15           C  
ATOM   5324  CG2 ILE C 220      76.718  34.472  60.901  1.00 20.79           C  
ATOM   5325  CD1 ILE C 220      79.339  32.576  60.659  1.00 21.13           C  
ATOM   5326  N   ALA C 221      76.170  34.861  56.970  1.00 20.35           N  
ATOM   5327  CA  ALA C 221      75.044  35.300  56.142  1.00 20.55           C  
ATOM   5328  C   ALA C 221      74.326  34.121  55.468  1.00 20.71           C  
ATOM   5329  O   ALA C 221      73.093  34.119  55.353  1.00 20.49           O  
ATOM   5330  CB  ALA C 221      75.512  36.316  55.085  1.00 20.40           C  
ATOM   5331  N   GLU C 222      75.088  33.126  55.011  1.00 21.71           N  
ATOM   5332  CA  GLU C 222      74.485  31.943  54.372  1.00 22.23           C  
ATOM   5333  C   GLU C 222      73.706  31.085  55.381  1.00 21.86           C  
ATOM   5334  O   GLU C 222      72.681  30.456  55.048  1.00 21.69           O  
ATOM   5335  CB  GLU C 222      75.556  31.119  53.650  1.00 23.03           C  
ATOM   5336  CG  GLU C 222      75.045  29.890  52.898  1.00 27.27           C  
ATOM   5337  CD  GLU C 222      73.808  30.157  52.045  1.00 32.07           C  
ATOM   5338  OE1 GLU C 222      73.901  30.985  51.100  1.00 33.61           O  
ATOM   5339  OE2 GLU C 222      72.743  29.533  52.335  1.00 33.28           O  
ATOM   5340  N   ALA C 223      74.213  31.035  56.606  1.00 21.52           N  
ATOM   5341  CA  ALA C 223      73.516  30.356  57.689  1.00 20.86           C  
ATOM   5342  C   ALA C 223      72.159  31.019  57.933  1.00 21.44           C  
ATOM   5343  O   ALA C 223      71.133  30.322  58.010  1.00 21.05           O  
ATOM   5344  CB  ALA C 223      74.371  30.347  58.961  1.00 21.70           C  
ATOM   5345  N   VAL C 224      72.156  32.357  58.015  1.00 21.33           N  
ATOM   5346  CA  VAL C 224      70.921  33.142  58.178  1.00 21.32           C  
ATOM   5347  C   VAL C 224      69.970  32.873  57.005  1.00 21.36           C  
ATOM   5348  O   VAL C 224      68.771  32.630  57.200  1.00 21.40           O  
ATOM   5349  CB  VAL C 224      71.184  34.680  58.311  1.00 21.05           C  
ATOM   5350  CG1 VAL C 224      69.842  35.463  58.418  1.00 21.06           C  
ATOM   5351  CG2 VAL C 224      72.094  34.988  59.524  1.00 20.72           C  
ATOM   5352  N   ARG C 225      70.522  32.904  55.798  1.00 22.00           N  
ATOM   5353  CA  ARG C 225      69.749  32.674  54.585  1.00 22.90           C  
ATOM   5354  C   ARG C 225      69.071  31.305  54.625  1.00 22.57           C  
ATOM   5355  O   ARG C 225      67.870  31.188  54.368  1.00 22.04           O  
ATOM   5356  CB  ARG C 225      70.654  32.780  53.359  1.00 23.28           C  
ATOM   5357  CG  ARG C 225      69.889  32.896  52.051  1.00 27.14           C  
ATOM   5358  CD  ARG C 225      70.681  32.273  50.919  1.00 31.78           C  
ATOM   5359  NE  ARG C 225      69.785  31.538  50.029  1.00 38.69           N  
ATOM   5360  CZ  ARG C 225      69.436  30.259  50.181  1.00 40.81           C  
ATOM   5361  NH1 ARG C 225      69.923  29.524  51.184  1.00 41.10           N  
ATOM   5362  NH2 ARG C 225      68.599  29.707  49.314  1.00 43.47           N  
ATOM   5363  N   TYR C 226      69.843  30.275  54.958  1.00 22.11           N  
ATOM   5364  CA  TYR C 226      69.294  28.931  55.116  1.00 22.18           C  
ATOM   5365  C   TYR C 226      68.144  28.877  56.135  1.00 21.79           C  
ATOM   5366  O   TYR C 226      67.047  28.379  55.829  1.00 21.88           O  
ATOM   5367  CB  TYR C 226      70.398  27.910  55.469  1.00 22.42           C  
ATOM   5368  CG  TYR C 226      69.812  26.657  56.076  1.00 22.52           C  
ATOM   5369  CD1 TYR C 226      69.069  25.759  55.297  1.00 22.87           C  
ATOM   5370  CD2 TYR C 226      69.972  26.385  57.438  1.00 23.05           C  
ATOM   5371  CE1 TYR C 226      68.500  24.609  55.871  1.00 23.98           C  
ATOM   5372  CE2 TYR C 226      69.406  25.253  58.020  1.00 23.53           C  
ATOM   5373  CZ  TYR C 226      68.681  24.372  57.235  1.00 24.82           C  
ATOM   5374  OH  TYR C 226      68.132  23.258  57.824  1.00 24.70           O  
ATOM   5375  N   ALA C 227      68.374  29.417  57.327  1.00 20.96           N  
ATOM   5376  CA  ALA C 227      67.331  29.425  58.365  1.00 21.25           C  
ATOM   5377  C   ALA C 227      66.034  30.138  57.951  1.00 21.18           C  
ATOM   5378  O   ALA C 227      64.940  29.610  58.170  1.00 20.61           O  
ATOM   5379  CB  ALA C 227      67.869  30.011  59.666  1.00 21.48           C  
ATOM   5380  N   VAL C 228      66.154  31.327  57.359  1.00 20.58           N  
ATOM   5381  CA  VAL C 228      64.964  32.141  57.055  1.00 21.23           C  
ATOM   5382  C   VAL C 228      64.193  31.674  55.813  1.00 21.49           C  
ATOM   5383  O   VAL C 228      63.008  31.988  55.668  1.00 21.71           O  
ATOM   5384  CB  VAL C 228      65.266  33.666  56.941  1.00 21.09           C  
ATOM   5385  CG1 VAL C 228      65.882  34.205  58.236  1.00 21.75           C  
ATOM   5386  CG2 VAL C 228      66.121  33.992  55.690  1.00 21.65           C  
ATOM   5387  N   THR C 229      64.864  30.943  54.931  1.00 21.64           N  
ATOM   5388  CA  THR C 229      64.215  30.407  53.719  1.00 21.91           C  
ATOM   5389  C   THR C 229      63.645  28.999  53.910  1.00 21.60           C  
ATOM   5390  O   THR C 229      62.983  28.478  53.013  1.00 22.02           O  
ATOM   5391  CB  THR C 229      65.156  30.425  52.492  1.00 21.91           C  
ATOM   5392  OG1 THR C 229      66.317  29.619  52.748  1.00 22.55           O  
ATOM   5393  CG2 THR C 229      65.565  31.869  52.141  1.00 22.44           C  
ATOM   5394  N   ALA C 230      63.914  28.385  55.064  1.00 21.69           N  
ATOM   5395  CA  ALA C 230      63.253  27.126  55.447  1.00 21.61           C  
ATOM   5396  C   ALA C 230      61.729  27.333  55.460  1.00 21.69           C  
ATOM   5397  O   ALA C 230      61.267  28.444  55.765  1.00 21.29           O  
ATOM   5398  CB  ALA C 230      63.748  26.645  56.800  1.00 21.94           C  
ATOM   5399  N   PRO C 231      60.948  26.284  55.106  1.00 21.10           N  
ATOM   5400  CA  PRO C 231      59.484  26.433  55.075  1.00 21.22           C  
ATOM   5401  C   PRO C 231      58.963  26.851  56.443  1.00 21.02           C  
ATOM   5402  O   PRO C 231      59.591  26.519  57.456  1.00 20.75           O  
ATOM   5403  CB  PRO C 231      58.975  25.031  54.722  1.00 21.21           C  
ATOM   5404  CG  PRO C 231      60.156  24.113  54.830  1.00 21.55           C  
ATOM   5405  CD  PRO C 231      61.388  24.934  54.707  1.00 21.30           C  
ATOM   5406  N   HIS C 232      57.829  27.551  56.483  1.00 20.99           N  
ATOM   5407  CA  HIS C 232      57.344  28.118  57.747  1.00 20.53           C  
ATOM   5408  C   HIS C 232      57.212  27.108  58.889  1.00 20.63           C  
ATOM   5409  O   HIS C 232      57.476  27.442  60.050  1.00 20.62           O  
ATOM   5410  CB  HIS C 232      56.008  28.853  57.576  1.00 20.66           C  
ATOM   5411  CG  HIS C 232      55.538  29.506  58.839  1.00 20.71           C  
ATOM   5412  ND1 HIS C 232      54.511  28.996  59.605  1.00 21.99           N  
ATOM   5413  CD2 HIS C 232      56.005  30.588  59.504  1.00 20.93           C  
ATOM   5414  CE1 HIS C 232      54.348  29.754  60.678  1.00 21.21           C  
ATOM   5415  NE2 HIS C 232      55.238  30.731  60.638  1.00 19.67           N  
ATOM   5416  N   HIS C 233      56.793  25.889  58.563  1.00 20.31           N  
ATOM   5417  CA  HIS C 233      56.598  24.855  59.572  1.00 20.39           C  
ATOM   5418  C   HIS C 233      57.889  24.392  60.232  1.00 20.40           C  
ATOM   5419  O   HIS C 233      57.843  23.652  61.215  1.00 20.51           O  
ATOM   5420  CB  HIS C 233      55.858  23.648  58.988  1.00 20.40           C  
ATOM   5421  CG  HIS C 233      56.654  22.872  57.985  1.00 20.80           C  
ATOM   5422  ND1 HIS C 233      56.534  23.070  56.628  1.00 22.67           N  
ATOM   5423  CD2 HIS C 233      57.564  21.883  58.142  1.00 20.98           C  
ATOM   5424  CE1 HIS C 233      57.346  22.245  55.993  1.00 23.30           C  
ATOM   5425  NE2 HIS C 233      57.986  21.517  56.889  1.00 21.13           N  
ATOM   5426  N   ALA C 234      59.031  24.818  59.693  1.00 20.32           N  
ATOM   5427  CA  ALA C 234      60.327  24.461  60.265  1.00 20.24           C  
ATOM   5428  C   ALA C 234      60.993  25.655  60.949  1.00 20.62           C  
ATOM   5429  O   ALA C 234      61.207  26.694  60.318  1.00 20.53           O  
ATOM   5430  CB  ALA C 234      61.236  23.881  59.181  1.00 20.21           C  
ATOM   5431  N   THR C 235      61.309  25.508  62.235  1.00 20.42           N  
ATOM   5432  CA  THR C 235      62.109  26.513  62.939  1.00 20.72           C  
ATOM   5433  C   THR C 235      63.525  25.994  63.173  1.00 21.25           C  
ATOM   5434  O   THR C 235      63.746  25.050  63.943  1.00 21.62           O  
ATOM   5435  CB  THR C 235      61.482  26.948  64.287  1.00 21.30           C  
ATOM   5436  OG1 THR C 235      60.242  27.617  64.042  1.00 21.38           O  
ATOM   5437  CG2 THR C 235      62.409  27.918  65.033  1.00 19.97           C  
ATOM   5438  N   VAL C 236      64.486  26.618  62.511  1.00 21.17           N  
ATOM   5439  CA  VAL C 236      65.879  26.230  62.694  1.00 21.46           C  
ATOM   5440  C   VAL C 236      66.371  27.003  63.917  1.00 21.39           C  
ATOM   5441  O   VAL C 236      66.897  28.125  63.814  1.00 21.40           O  
ATOM   5442  CB  VAL C 236      66.715  26.480  61.427  1.00 21.76           C  
ATOM   5443  CG1 VAL C 236      68.130  25.969  61.635  1.00 22.65           C  
ATOM   5444  CG2 VAL C 236      66.071  25.775  60.228  1.00 21.79           C  
ATOM   5445  N   HIS C 237      66.146  26.424  65.094  1.00 21.11           N  
ATOM   5446  CA  HIS C 237      66.329  27.195  66.304  1.00 21.16           C  
ATOM   5447  C   HIS C 237      67.791  27.492  66.623  1.00 21.15           C  
ATOM   5448  O   HIS C 237      68.084  28.492  67.275  1.00 22.17           O  
ATOM   5449  CB  HIS C 237      65.654  26.547  67.516  1.00 21.30           C  
ATOM   5450  CG  HIS C 237      65.745  27.378  68.758  1.00 20.81           C  
ATOM   5451  ND1 HIS C 237      65.209  28.643  68.841  1.00 22.34           N  
ATOM   5452  CD2 HIS C 237      66.314  27.131  69.964  1.00 23.75           C  
ATOM   5453  CE1 HIS C 237      65.445  29.143  70.043  1.00 23.49           C  
ATOM   5454  NE2 HIS C 237      66.108  28.243  70.746  1.00 24.23           N  
ATOM   5455  N   GLU C 238      68.694  26.600  66.229  1.00 21.68           N  
ATOM   5456  CA  GLU C 238      70.114  26.812  66.487  1.00 22.35           C  
ATOM   5457  C   GLU C 238      70.977  26.353  65.317  1.00 21.81           C  
ATOM   5458  O   GLU C 238      70.807  25.248  64.812  1.00 20.90           O  
ATOM   5459  CB  GLU C 238      70.564  26.081  67.757  1.00 22.79           C  
ATOM   5460  CG  GLU C 238      70.517  26.911  69.002  1.00 25.97           C  
ATOM   5461  CD  GLU C 238      71.028  26.168  70.245  1.00 25.69           C  
ATOM   5462  OE1 GLU C 238      70.447  25.125  70.590  1.00 30.95           O  
ATOM   5463  OE2 GLU C 238      71.970  26.668  70.907  1.00 30.43           O  
ATOM   5464  N   ILE C 239      71.891  27.221  64.884  1.00 21.16           N  
ATOM   5465  CA  ILE C 239      72.963  26.805  63.975  1.00 20.50           C  
ATOM   5466  C   ILE C 239      74.267  27.189  64.641  1.00 20.06           C  
ATOM   5467  O   ILE C 239      74.512  28.379  64.890  1.00 20.72           O  
ATOM   5468  CB  ILE C 239      72.879  27.473  62.578  1.00 20.18           C  
ATOM   5469  CG1 ILE C 239      71.536  27.159  61.907  1.00 20.32           C  
ATOM   5470  CG2 ILE C 239      74.063  26.997  61.701  1.00 19.82           C  
ATOM   5471  CD1 ILE C 239      71.293  27.903  60.586  1.00 19.61           C  
ATOM   5472  N   PHE C 240      75.068  26.177  64.969  1.00 20.81           N  
ATOM   5473  CA  PHE C 240      76.366  26.354  65.624  1.00 20.65           C  
ATOM   5474  C   PHE C 240      77.430  26.067  64.562  1.00 20.95           C  
ATOM   5475  O   PHE C 240      77.642  24.919  64.161  1.00 19.95           O  
ATOM   5476  CB  PHE C 240      76.458  25.406  66.853  1.00 20.85           C  
ATOM   5477  CG  PHE C 240      77.681  25.587  67.723  1.00 21.53           C  
ATOM   5478  CD1 PHE C 240      78.508  26.713  67.630  1.00 24.15           C  
ATOM   5479  CD2 PHE C 240      77.971  24.627  68.697  1.00 22.95           C  
ATOM   5480  CE1 PHE C 240      79.624  26.859  68.462  1.00 23.99           C  
ATOM   5481  CE2 PHE C 240      79.079  24.760  69.528  1.00 25.94           C  
ATOM   5482  CZ  PHE C 240      79.910  25.879  69.415  1.00 23.94           C  
ATOM   5483  N   ILE C 241      78.052  27.137  64.069  1.00 21.43           N  
ATOM   5484  CA  ILE C 241      79.035  27.026  63.002  1.00 22.45           C  
ATOM   5485  C   ILE C 241      80.418  27.425  63.531  1.00 22.90           C  
ATOM   5486  O   ILE C 241      80.583  28.512  64.095  1.00 23.51           O  
ATOM   5487  CB  ILE C 241      78.558  27.818  61.723  1.00 22.31           C  
ATOM   5488  CG1 ILE C 241      79.549  27.700  60.550  1.00 21.47           C  
ATOM   5489  CG2 ILE C 241      78.143  29.259  62.054  1.00 23.07           C  
ATOM   5490  CD1 ILE C 241      78.960  28.216  59.196  1.00 24.26           C  
ATOM   5491  N   ARG C 242      81.391  26.525  63.371  1.00 22.80           N  
ATOM   5492  CA  ARG C 242      82.729  26.678  63.951  1.00 23.03           C  
ATOM   5493  C   ARG C 242      83.790  26.677  62.862  1.00 21.63           C  
ATOM   5494  O   ARG C 242      83.613  26.004  61.853  1.00 21.34           O  
ATOM   5495  CB  ARG C 242      83.064  25.477  64.859  1.00 23.39           C  
ATOM   5496  CG  ARG C 242      82.459  25.423  66.240  1.00 26.32           C  
ATOM   5497  CD  ARG C 242      83.015  24.182  66.923  1.00 27.59           C  
ATOM   5498  NE  ARG C 242      82.545  23.953  68.286  1.00 31.18           N  
ATOM   5499  CZ  ARG C 242      83.240  24.198  69.391  1.00 30.31           C  
ATOM   5500  NH1 ARG C 242      84.457  24.718  69.344  1.00 32.31           N  
ATOM   5501  NH2 ARG C 242      82.699  23.928  70.558  1.00 33.09           N  
ATOM   5502  N   PRO C 243      84.938  27.365  63.087  1.00 21.23           N  
ATOM   5503  CA  PRO C 243      86.044  27.134  62.155  1.00 20.41           C  
ATOM   5504  C   PRO C 243      86.488  25.672  62.243  1.00 20.08           C  
ATOM   5505  O   PRO C 243      86.703  25.156  63.345  1.00 19.17           O  
ATOM   5506  CB  PRO C 243      87.167  28.064  62.669  1.00 20.60           C  
ATOM   5507  CG  PRO C 243      86.527  28.991  63.628  1.00 21.98           C  
ATOM   5508  CD  PRO C 243      85.297  28.317  64.156  1.00 20.90           C  
ATOM   5509  N   THR C 244      86.587  25.004  61.096  1.00 18.97           N  
ATOM   5510  CA  THR C 244      87.133  23.645  61.031  1.00 19.91           C  
ATOM   5511  C   THR C 244      88.515  23.559  61.689  1.00 20.29           C  
ATOM   5512  O   THR C 244      88.883  22.531  62.256  1.00 21.33           O  
ATOM   5513  CB  THR C 244      87.197  23.154  59.560  1.00 19.05           C  
ATOM   5514  OG1 THR C 244      85.905  23.318  58.963  1.00 19.51           O  
ATOM   5515  CG2 THR C 244      87.602  21.684  59.458  1.00 19.05           C  
ATOM   5516  N   ASP C 245      89.282  24.642  61.613  1.00 20.76           N  
ATOM   5517  CA  ASP C 245      90.673  24.617  62.052  1.00 21.59           C  
ATOM   5518  C   ASP C 245      90.847  24.755  63.555  1.00 22.00           C  
ATOM   5519  O   ASP C 245      91.961  24.665  64.064  1.00 21.67           O  
ATOM   5520  CB  ASP C 245      91.456  25.721  61.367  1.00 21.89           C  
ATOM   5521  CG  ASP C 245      91.793  25.392  59.926  1.00 23.38           C  
ATOM   5522  OD1 ASP C 245      91.582  24.235  59.481  1.00 24.61           O  
ATOM   5523  OD2 ASP C 245      92.305  26.294  59.241  1.00 24.82           O  
ATOM   5524  N   GLN C 246      89.749  24.984  64.257  1.00 22.36           N  
ATOM   5525  CA  GLN C 246      89.834  25.346  65.657  1.00 23.86           C  
ATOM   5526  C   GLN C 246      89.214  24.307  66.588  1.00 24.07           C  
ATOM   5527  O   GLN C 246      87.997  24.082  66.576  1.00 23.80           O  
ATOM   5528  CB  GLN C 246      89.182  26.708  65.839  1.00 23.61           C  
ATOM   5529  CG  GLN C 246      89.287  27.298  67.217  1.00 27.16           C  
ATOM   5530  CD  GLN C 246      88.266  28.385  67.384  1.00 31.20           C  
ATOM   5531  OE1 GLN C 246      87.066  28.113  67.498  1.00 34.01           O  
ATOM   5532  NE2 GLN C 246      88.721  29.632  67.363  1.00 33.51           N  
ATOM   5533  N   VAL C 247      90.060  23.672  67.394  1.00 25.00           N  
ATOM   5534  CA  VAL C 247      89.568  22.835  68.491  1.00 25.22           C  
ATOM   5535  C   VAL C 247      88.813  23.714  69.514  1.00 25.93           C  
ATOM   5536  O   VAL C 247      87.688  23.422  69.962  1.00 26.14           O  
ATOM   5537  CB  VAL C 247      90.729  22.023  69.149  1.00 25.30           C  
ATOM   5538  CG1 VAL C 247      90.253  21.260  70.375  1.00 24.48           C  
ATOM   5539  CG2 VAL C 247      91.323  21.041  68.156  1.00 24.81           C  
ATOM   5540  OXT VAL C 247      89.299  24.771  69.922  1.00 26.16           O  
TER    5541      VAL C 247                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
