
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  304 ( 2356),  selected  304 , name 2co0_A
# Molecule2: number of CA atoms  327 ( 2685),  selected  327 , name T0512.pdb
# PARAMETERS: 2co0_A.T0512.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V    31_A      A       1           -
LGA    K    32_A      S       2           -
LGA    -       -      G       3           -
LGA    -       -      L       4           -
LGA    -       -      F       5           -
LGA    -       -      I       6           -
LGA    -       -      T       7           -
LGA    -       -      N       8           -
LGA    -       -      E       9           -
LGA    -       -      G      10           -
LGA    -       -      N      11           -
LGA    -       -      F      12           -
LGA    -       -      Q      13           -
LGA    -       -      Y      14           -
LGA    -       -      S      15           -
LGA    -       -      N      16           -
LGA    -       -      A      17           -
LGA    -       -      T      18           -
LGA    -       -      L      19           -
LGA    -       -      S      20           -
LGA    -       -      Y      21           -
LGA    -       -      Y      22           -
LGA    -       -      D      23           -
LGA    -       -      P      24           -
LGA    P    33_A      A      25           #
LGA    N    34_A      T      26          3.404
LGA    Y    35_A      C      27          2.682
LGA    A    36_A      E      28          1.573
LGA    L    37_A      V      29          2.983
LGA    M    38_A      E      30          4.916
LGA    F    39_A      N      31           #
LGA    T    40_A      E      32          3.140
LGA    -       -      V      33           -
LGA    L    41_A      F      34          0.850
LGA    A    42_A      Y      35          2.931
LGA    -       -      R      36           -
LGA    -       -      A      37           -
LGA    -       -      N      38           -
LGA    -       -      G      39           -
LGA    -       -      F      40           -
LGA    G    43_A      K      41          3.528
LGA    H    44_A      L      42          2.703
LGA    T    45_A      G      43          2.345
LGA    K    46_A      D      44          0.948
LGA    A    47_A      V      45          1.476
LGA    V    48_A      A      46          0.594
LGA    S    49_A      Q      47          1.055
LGA    S    50_A      S      48          1.120
LGA    V    51_A      M      49          1.906
LGA    K    52_A      V      50          2.220
LGA    F    53_A      I      51          2.356
LGA    S    54_A      R      52          2.470
LGA    P    55_A      -       -           -
LGA    N    56_A      D      53          3.568
LGA    G    57_A      -       -           -
LGA    E    58_A      G      54          1.285
LGA    W    59_A      I      55          1.841
LGA    L    60_A      G      56          1.549
LGA    A    61_A      W      57          1.199
LGA    S    62_A      I      58          1.095
LGA    S    63_A      V      59          0.984
LGA    S    64_A      V      60          1.449
LGA    A    65_A      N      61          2.417
LGA    D    66_A      N      62          2.871
LGA    -       -      S      63           -
LGA    K    67_A      H      64          1.264
LGA    L    68_A      V      65          0.730
LGA    I    69_A      I      66          0.784
LGA    K    70_A      F      67          0.837
LGA    I    71_A      A      68          1.114
LGA    W    72_A      I      69          1.203
LGA    G    73_A      D      70          1.310
LGA    A    74_A      I      71          1.329
LGA    Y    75_A      N      72          1.690
LGA    D    76_A      T      73          1.700
LGA    G    77_A      F      74          1.075
LGA    K    78_A      K      75          1.516
LGA    F    79_A      E      76          0.978
LGA    E    80_A      V      77          1.344
LGA    K    81_A      G      78          1.117
LGA    T    82_A      R      79          0.971
LGA    I    83_A      I      80          1.070
LGA    S    84_A      T      81          2.000
LGA    G    85_A      G      82          2.684
LGA    H    86_A      F      83          1.819
LGA    K    87_A      T      84          2.240
LGA    L    88_A      S      85          3.174
LGA    G    89_A      -       -           -
LGA    I    90_A      P      86          1.875
LGA    S    91_A      R      87          2.539
LGA    D    92_A      Y      88          2.436
LGA    V    93_A      I      89          2.578
LGA    A    94_A      H      90          3.220
LGA    W    95_A      F      91          3.653
LGA    S    96_A      L      92          4.059
LGA    S    97_A      -       -           -
LGA    D    98_A      S      93          5.335
LGA    S    99_A      D      94           #
LGA    N   100_A      E      95           #
LGA    L   101_A      K      96          4.088
LGA    L   102_A      A      97          3.189
LGA    V   103_A      Y      98          2.385
LGA    S   104_A      V      99          1.791
LGA    A   105_A      T     100          1.667
LGA    S   106_A      Q     101          0.995
LGA    D   107_A      I     102          1.447
LGA    D   108_A      W     103          3.153
LGA    K   109_A      D     104          2.243
LGA    -       -      Y     105           -
LGA    T   110_A      R     106          2.337
LGA    L   111_A      I     107          1.879
LGA    K   112_A      F     108          1.905
LGA    I   113_A      I     109          2.732
LGA    W   114_A      I     110          2.149
LGA    D   115_A      N     111          2.006
LGA    V   116_A      P     112          1.408
LGA    S   117_A      K     113          1.132
LGA    S   118_A      T     114          1.181
LGA    G   119_A      Y     115          1.650
LGA    K   120_A      E     116          2.185
LGA    C   121_A      I     117          2.415
LGA    L   122_A      T     118          3.553
LGA    K   123_A      G     119          3.269
LGA    T   124_A      Y     120          1.496
LGA    L   125_A      I     121          1.868
LGA    K   126_A      E     122          1.622
LGA    G   127_A      C     123          1.328
LGA    -       -      P     124           -
LGA    -       -      D     125           -
LGA    H   128_A      M     126          4.045
LGA    -       -      D     127           -
LGA    -       -      M     128           -
LGA    -       -      E     129           -
LGA    S   129_A      S     130          5.633
LGA    N   130_A      G     131          1.943
LGA    Y   131_A      S     132          2.132
LGA    V   132_A      T     133          2.040
LGA    F   133_A      E     134          2.865
LGA    C   134_A      Q     135          2.503
LGA    C   135_A      -       -           -
LGA    N   136_A      M     136          1.916
LGA    F   137_A      V     137          3.557
LGA    N   138_A      Q     138          1.361
LGA    P   139_A      Y     139          5.639
LGA    Q   140_A      G     140          3.768
LGA    S   141_A      -       -           -
LGA    N   142_A      K     141          2.669
LGA    L   143_A      Y     142          2.251
LGA    I   144_A      V     143          2.011
LGA    V   145_A      Y     144          1.862
LGA    S   146_A      V     145          1.568
LGA    G   147_A      N     146          1.528
LGA    S   148_A      C     147          1.689
LGA    F   149_A      W     148          3.110
LGA    -       -      S     149           -
LGA    -       -      Y     150           -
LGA    D   150_A      Q     151          0.904
LGA    E   151_A      N     152          1.199
LGA    S   152_A      R     153          0.968
LGA    V   153_A      I     154          0.950
LGA    R   154_A      L     155          0.613
LGA    I   155_A      K     156          1.346
LGA    W   156_A      I     157          0.815
LGA    D   157_A      D     158          1.306
LGA    V   158_A      T     159          1.681
LGA    K   159_A      E     160          2.410
LGA    T   160_A      T     161          1.424
LGA    G   161_A      D     162          1.335
LGA    M   162_A      K     163          0.585
LGA    C   163_A      V     164          0.425
LGA    L   164_A      V     165          1.606
LGA    K   165_A      D     166          1.403
LGA    T   166_A      E     167          1.044
LGA    L   167_A      L     168          0.803
LGA    P   168_A      T     169          0.216
LGA    A   169_A      I     170          2.012
LGA    H   170_A      G     171          1.390
LGA    S   171_A      I     172          2.519
LGA    D   172_A      -       -           -
LGA    P   173_A      Q     173          1.344
LGA    V   174_A      P     174          1.527
LGA    S   175_A      T     175          0.747
LGA    A   176_A      S     176          0.346
LGA    V   177_A      L     177          1.326
LGA    H   178_A      V     178          1.784
LGA    F   179_A      M     179          2.335
LGA    N   180_A      D     180          2.658
LGA    R   181_A      K     181          4.102
LGA    D   182_A      Y     182          6.026
LGA    G   183_A      -       -           -
LGA    S   184_A      N     183          2.664
LGA    L   185_A      K     184          1.925
LGA    I   186_A      M     185          1.442
LGA    V   187_A      W     186          1.096
LGA    S   188_A      T     187          0.945
LGA    S   189_A      I     188          1.026
LGA    S   190_A      T     189          0.478
LGA    Y   191_A      D     190          0.893
LGA    D   192_A      G     191          2.594
LGA    -       -      G     192           -
LGA    -       -      Y     193           -
LGA    -       -      E     194           -
LGA    -       -      G     195           -
LGA    -       -      S     196           -
LGA    -       -      P     197           -
LGA    -       -      Y     198           -
LGA    -       -      G     199           -
LGA    -       -      Y     200           -
LGA    -       -      E     201           -
LGA    -       -      A     202           -
LGA    G   193_A      P     203          1.961
LGA    L   194_A      S     204          0.912
LGA    C   195_A      L     205          1.058
LGA    R   196_A      Y     206          0.507
LGA    I   197_A      R     207          0.963
LGA    W   198_A      I     208          0.806
LGA    D   199_A      D     209          1.142
LGA    T   200_A      A     210          1.356
LGA    A   201_A      E     211          1.988
LGA    S   202_A      T     212          1.680
LGA    G   203_A      F     213          1.305
LGA    Q   204_A      T     214          0.895
LGA    C   205_A      V     215          0.366
LGA    L   206_A      E     216          0.924
LGA    K   207_A      K     217          0.841
LGA    T   208_A      Q     218          0.945
LGA    L   209_A      F     219          1.902
LGA    I   210_A      K     220          3.362
LGA    D   211_A      F     221          4.438
LGA    D   212_A      K     222           #
LGA    D   213_A      L     223           #
LGA    N   214_A      G     224           #
LGA    P   215_A      D     225          2.068
LGA    P   216_A      W     226          2.132
LGA    V   217_A      P     227          1.765
LGA    S   218_A      S     228          1.269
LGA    F   219_A      E     229          1.291
LGA    V   220_A      V     230          0.739
LGA    K   221_A      Q     231          2.713
LGA    F   222_A      L     232          3.098
LGA    S   223_A      N     233          2.847
LGA    P   224_A      G     234          2.495
LGA    N   225_A      T     235          1.888
LGA    G   226_A      R     236          2.556
LGA    K   227_A      D     237          1.985
LGA    Y   228_A      T     238          1.992
LGA    I   229_A      L     239          1.325
LGA    L   230_A      Y     240          0.995
LGA    A   231_A      W     241          1.218
LGA    A   232_A      I     242          1.084
LGA    T   233_A      N     243          1.469
LGA    L   234_A      -       -           -
LGA    D   235_A      -       -           -
LGA    N   236_A      N     244          2.959
LGA    D   237_A      D     245          1.453
LGA    L   238_A      I     246          1.133
LGA    K   239_A      W     247          0.947
LGA    L   240_A      R     248          1.025
LGA    W   241_A      M     249          0.922
LGA    D   242_A      P     250          1.648
LGA    Y   243_A      V     251          3.435
LGA    S   244_A      E     252          2.335
LGA    K   245_A      A     253          1.762
LGA    G   246_A      D     254          3.163
LGA    -       -      R     255           -
LGA    -       -      V     256           -
LGA    K   247_A      P     257          3.836
LGA    C   248_A      V     258          6.062
LGA    L   249_A      R     259           #
LGA    K   250_A      P     260          5.185
LGA    T   251_A      F     261          0.846
LGA    Y   252_A      L     262          1.865
LGA    T   253_A      E     263          3.568
LGA    -       -      F     264           -
LGA    G   254_A      R     265          4.526
LGA    H   255_A      D     266           -
LGA    K   256_A      T     267          3.229
LGA    N   257_A      K     268          2.447
LGA    E   258_A      Y     269           #
LGA    K   259_A      -       -           -
LGA    Y   260_A      -       -           -
LGA    C   261_A      -       -           -
LGA    I   262_A      Y     270          3.640
LGA    F   263_A      G     271          3.658
LGA    A   264_A      L     272          1.588
LGA    N   265_A      T     273          1.196
LGA    F   266_A      V     274          1.159
LGA    S   267_A      N     275          0.695
LGA    V   268_A      P     276          3.316
LGA    T   269_A      N     277          3.540
LGA    G   270_A      -       -           -
LGA    G   271_A      N     278          4.094
LGA    K   272_A      G     279          2.970
LGA    W   273_A      E     280          0.723
LGA    I   274_A      V     281          0.560
LGA    V   275_A      Y     282          1.362
LGA    S   276_A      V     283          2.692
LGA    G   277_A      A     284          1.797
LGA    S   278_A      D     285          1.636
LGA    E   279_A      A     286          0.640
LGA    D   280_A      I     287          2.628
LGA    -       -      D     288           -
LGA    -       -      Y     289           -
LGA    -       -      Q     290           -
LGA    -       -      Q     291           -
LGA    -       -      Q     292           -
LGA    N   281_A      G     293          0.710
LGA    M   282_A      I     294          1.280
LGA    V   283_A      V     295          1.762
LGA    Y   284_A      Y     296          1.876
LGA    I   285_A      R     297          1.238
LGA    W   286_A      Y     298          1.276
LGA    N   287_A      S     299          1.274
LGA    L   288_A      P     300          1.584
LGA    Q   289_A      Q     301          1.280
LGA    T   290_A      G     302          2.762
LGA    K   291_A      -       -           -
LGA    E   292_A      K     303          2.317
LGA    I   293_A      L     304          2.340
LGA    V   294_A      I     305          1.576
LGA    Q   295_A      D     306          1.389
LGA    K   296_A      E     307          1.430
LGA    L   297_A      F     308          1.654
LGA    Q   298_A      Y     309          1.393
LGA    G   299_A      V     310          3.701
LGA    H   300_A      G     311          1.614
LGA    T   301_A      -       -           -
LGA    D   302_A      I     312          1.202
LGA    V   303_A      I     313          0.854
LGA    V   304_A      P     314          0.660
LGA    I   305_A      G     315          1.552
LGA    S   306_A      A     316          1.344
LGA    T   307_A      F     317          1.523
LGA    A   308_A      C     318          1.889
LGA    C   309_A      W     319          2.022
LGA    H   310_A      K     320          2.244
LGA    P   311_A      L     321          3.296
LGA    T   312_A      E     322          3.388
LGA    E   313_A      H     323           #
LGA    N   314_A      H     324           -
LGA    I   315_A      H     325           -
LGA    I   316_A      H     326           -
LGA    A   317_A      H     327           -
LGA    S   318_A      -       -           -
LGA    A   319_A      -       -           -
LGA    A   320_A      -       -           -
LGA    L   321_A      -       -           -
LGA    E   322_A      -       -           -
LGA    N   323_A      -       -           -
LGA    D   324_A      -       -           -
LGA    K   325_A      -       -           -
LGA    T   326_A      -       -           -
LGA    I   327_A      -       -           -
LGA    K   328_A      -       -           -
LGA    L   329_A      -       -           -
LGA    W   330_A      -       -           -
LGA    K   331_A      -       -           -
LGA    S   332_A      -       -           -
LGA    D   333_A      -       -           -
LGA    C   334_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  304  327    5.0    254    2.25     7.48     53.991    10.810

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.187435 * X  +  -0.390000 * Y  +  -0.901536 * Z  +  33.655605
  Y_new =  -0.854906 * X  +   0.516757 * Y  +  -0.045806 * Z  +  45.659325
  Z_new =   0.483739 * X  +   0.762143 * Y  +  -0.430272 * Z  +  11.243804 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.084746   -1.056847  [ DEG:   119.4471    -60.5529 ]
  Theta =  -0.504922   -2.636670  [ DEG:   -28.9299   -151.0701 ]
  Phi   =  -1.786628    1.354965  [ DEG:  -102.3662     77.6338 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2co0_A                                        
REMARK     2: T0512.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2co0_A.T0512.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  304  327   5.0  254   2.25    7.48  53.991
REMARK  ---------------------------------------------------------- 
MOLECULE 2co0_A
HEADER    TRANSCRIPTION                           25-MAY-06   2CO0              
TITLE     WDR5 AND UNMODIFIED HISTONE H3 COMPLEX AT 2.25 ANGSTROM               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: WD-REPEAT PROTEIN 5;                                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 20-334;                                           
COMPND   5 SYNONYM: BMP2-INDUCED 3-KB GENE PROTEIN;                             
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: HISTONE H3 DIMETHYL-LYSINE 4;                              
COMPND   8 CHAIN: B, D;                                                         
COMPND   9 FRAGMENT: HISTONE TAIL;                                              
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MOL_ID: 3;                                                           
COMPND  12 MOLECULE: WD-REPEAT PROTEIN 5;                                       
COMPND  13 CHAIN: C;                                                            
COMPND  14 FRAGMENT: RESIDUES 20-334;                                           
COMPND  15 SYNONYM: BMP2-INDUCED 3-KB GENE PROTEIN                              
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 SYNTHETIC: YES;                                                      
SOURCE   6 MOL_ID: 3;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   8 ORGANISM_COMMON: HUMAN                                               
KEYWDS    HISTONE PRESENTER, LYSINE METHYLATION, MLL1, LEUKEMIA, HOX            
KEYWDS   2 GENE ACTIVATION, TRANSCRIPTION ACTIVATION                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.J.RUTHENBURG,W.WANG,D.M.GRAYBOSCH,H.LI,C.D.ALLIS,                   
AUTHOR   2 D.J.PATEL,G.L.VERDINE                                                
REVDAT   2   20-DEC-06 2CO0    1       JRNL                                     
REVDAT   1   03-JUL-06 2CO0    0                                                
JRNL        AUTH   A.J.RUTHENBURG,W.WANG,D.M.GRAYBOSCH,H.LI,C.D.ALLIS,          
JRNL        AUTH 2 D.J.PATEL,G.L.VERDINE                                        
JRNL        TITL   HISTONE H3 RECOGNITION AND PRESENTATION BY THE               
JRNL        TITL 2 WDR5 MODULE OF THE MLL1 COMPLEX.                             
JRNL        REF    NAT.STRUCT.MOL.BIOL.          V.  13   704 2006              
JRNL        REFN                US ISSN 1545-9993                               
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2CO0 A   20   334  UNP    P61964   WDR5_HUMAN      20    334             
DBREF  2CO0 C   20   334  UNP    P61964   WDR5_HUMAN      20    334             
SEQRES   1 A  315  SER SER SER ALA THR GLN SER LYS PRO THR PRO VAL LYS          
SEQRES   2 A  315  PRO ASN TYR ALA LEU MET PHE THR LEU ALA GLY HIS THR          
SEQRES   3 A  315  LYS ALA VAL SER SER VAL LYS PHE SER PRO ASN GLY GLU          
SEQRES   4 A  315  TRP LEU ALA SER SER SER ALA ASP LYS LEU ILE LYS ILE          
SEQRES   5 A  315  TRP GLY ALA TYR ASP GLY LYS PHE GLU LYS THR ILE SER          
SEQRES   6 A  315  GLY HIS LYS LEU GLY ILE SER ASP VAL ALA TRP SER SER          
SEQRES   7 A  315  ASP SER ASN LEU LEU VAL SER ALA SER ASP ASP LYS THR          
SEQRES   8 A  315  LEU LYS ILE TRP ASP VAL SER SER GLY LYS CYS LEU LYS          
SEQRES   9 A  315  THR LEU LYS GLY HIS SER ASN TYR VAL PHE CYS CYS ASN          
SEQRES  10 A  315  PHE ASN PRO GLN SER ASN LEU ILE VAL SER GLY SER PHE          
SEQRES  11 A  315  ASP GLU SER VAL ARG ILE TRP ASP VAL LYS THR GLY MET          
SEQRES  12 A  315  CYS LEU LYS THR LEU PRO ALA HIS SER ASP PRO VAL SER          
SEQRES  13 A  315  ALA VAL HIS PHE ASN ARG ASP GLY SER LEU ILE VAL SER          
SEQRES  14 A  315  SER SER TYR ASP GLY LEU CYS ARG ILE TRP ASP THR ALA          
SEQRES  15 A  315  SER GLY GLN CYS LEU LYS THR LEU ILE ASP ASP ASP ASN          
SEQRES  16 A  315  PRO PRO VAL SER PHE VAL LYS PHE SER PRO ASN GLY LYS          
SEQRES  17 A  315  TYR ILE LEU ALA ALA THR LEU ASP ASN ASP LEU LYS LEU          
SEQRES  18 A  315  TRP ASP TYR SER LYS GLY LYS CYS LEU LYS THR TYR THR          
SEQRES  19 A  315  GLY HIS LYS ASN GLU LYS TYR CYS ILE PHE ALA ASN PHE          
SEQRES  20 A  315  SER VAL THR GLY GLY LYS TRP ILE VAL SER GLY SER GLU          
SEQRES  21 A  315  ASP ASN MET VAL TYR ILE TRP ASN LEU GLN THR LYS GLU          
SEQRES  22 A  315  ILE VAL GLN LYS LEU GLN GLY HIS THR ASP VAL VAL ILE          
SEQRES  23 A  315  SER THR ALA CYS HIS PRO THR GLU ASN ILE ILE ALA SER          
SEQRES  24 A  315  ALA ALA LEU GLU ASN ASP LYS THR ILE LYS LEU TRP LYS          
SEQRES  25 A  315  SER ASP CYS                                                  
SEQRES   1 B   15  ALA ARG THR LYS GLN THR ALA ARG LYS SER THR GLY GLY          
SEQRES   2 B   15  LYS ALA                                                      
SEQRES   1 C  315  SER SER SER ALA THR GLN SER LYS PRO THR PRO VAL LYS          
SEQRES   2 C  315  PRO ASN TYR ALA LEU MET PHE THR LEU ALA GLY HIS THR          
SEQRES   3 C  315  LYS ALA VAL SER SER VAL LYS PHE SER PRO ASN GLY GLU          
SEQRES   4 C  315  TRP LEU ALA SER SER SER ALA ASP LYS LEU ILE LYS ILE          
SEQRES   5 C  315  TRP GLY ALA TYR ASP GLY LYS PHE GLU LYS THR ILE SER          
SEQRES   6 C  315  GLY HIS LYS LEU GLY ILE SER ASP VAL ALA TRP SER SER          
SEQRES   7 C  315  ASP SER ASN LEU LEU VAL SER ALA SER ASP ASP LYS THR          
SEQRES   8 C  315  LEU LYS ILE TRP ASP VAL SER SER GLY LYS CYS LEU LYS          
SEQRES   9 C  315  THR LEU LYS GLY HIS SER ASN TYR VAL PHE CYS CYS ASN          
SEQRES  10 C  315  PHE ASN PRO GLN SER ASN LEU ILE VAL SER GLY SER PHE          
SEQRES  11 C  315  ASP GLU SER VAL ARG ILE TRP ASP VAL LYS THR GLY MET          
SEQRES  12 C  315  CYS LEU LYS THR LEU PRO ALA HIS SER ASP PRO VAL SER          
SEQRES  13 C  315  ALA VAL HIS PHE ASN ARG ASP GLY SER LEU ILE VAL SER          
SEQRES  14 C  315  SER SER TYR ASP GLY LEU CYS ARG ILE TRP ASP THR ALA          
SEQRES  15 C  315  SER GLY GLN CYS LEU LYS THR LEU ILE ASP ASP ASP ASN          
SEQRES  16 C  315  PRO PRO VAL SER PHE VAL LYS PHE SER PRO ASN GLY LYS          
SEQRES  17 C  315  TYR ILE LEU ALA ALA THR LEU ASP ASN THR LEU LYS LEU          
SEQRES  18 C  315  TRP ASP TYR SER LYS GLY LYS CYS LEU LYS THR TYR THR          
SEQRES  19 C  315  GLY HIS LYS ASN GLU LYS TYR CYS ILE PHE ALA ASN PHE          
SEQRES  20 C  315  SER VAL THR GLY GLY LYS TRP ILE VAL SER GLY SER GLU          
SEQRES  21 C  315  ASP ASN MET VAL TYR ILE TRP ASN LEU GLN THR LYS GLU          
SEQRES  22 C  315  ILE VAL GLN LYS LEU GLN GLY HIS THR ASP VAL VAL ILE          
SEQRES  23 C  315  SER THR ALA CYS HIS PRO THR GLU ASN ILE ILE ALA SER          
SEQRES  24 C  315  ALA ALA LEU GLU ASN ASP LYS THR ILE LYS LEU TRP LYS          
SEQRES  25 C  315  SER ASP CYS                                                  
SEQRES   1 D   15  ALA ARG THR LYS GLN THR ALA ARG LYS SER THR GLY GLY          
SEQRES   2 D   15  LYS ALA                                                      
FORMUL   5  HOH   *297(H2 O)                                                    
CRYST1   64.916   47.030  101.768  90.00 107.01  90.00 P 1 21 1      2          
ATOM      1  N   VAL A  31       1.620  18.654  17.210  1.00 47.63           N  
ATOM      2  CA  VAL A  31       2.568  19.132  18.258  1.00 46.15           C  
ATOM      3  C   VAL A  31       3.116  20.521  17.962  1.00 45.72           C  
ATOM      4  O   VAL A  31       3.391  20.878  16.816  1.00 46.25           O  
ATOM      5  CB  VAL A  31       3.777  18.177  18.419  1.00 45.92           C  
ATOM      6  CG1 VAL A  31       3.633  17.351  19.687  1.00 45.84           C  
ATOM      7  CG2 VAL A  31       3.874  17.269  17.218  1.00 46.56           C  
ATOM      8  N   LYS A  32       3.255  21.298  19.023  1.00 43.61           N  
ATOM      9  CA  LYS A  32       3.799  22.638  18.963  1.00 41.69           C  
ATOM     10  C   LYS A  32       4.463  22.777  20.317  1.00 40.22           C  
ATOM     11  O   LYS A  32       3.814  22.603  21.349  1.00 41.10           O  
ATOM     12  CB  LYS A  32       2.693  23.683  18.801  1.00 41.53           C  
ATOM     13  CG  LYS A  32       2.076  23.733  17.413  1.00 44.42           C  
ATOM     14  CD  LYS A  32       1.086  24.892  17.288  1.00 46.39           C  
ATOM     15  CE  LYS A  32       0.372  24.894  15.936  1.00 47.68           C  
ATOM     16  NZ  LYS A  32       0.799  26.012  15.042  1.00 48.89           N  
ATOM     17  N   PRO A  33       5.772  23.067  20.341  1.00 37.57           N  
ATOM     18  CA  PRO A  33       6.423  23.199  21.643  1.00 35.67           C  
ATOM     19  C   PRO A  33       5.728  24.285  22.453  1.00 34.27           C  
ATOM     20  O   PRO A  33       4.891  25.018  21.922  1.00 32.46           O  
ATOM     21  CB  PRO A  33       7.858  23.557  21.268  1.00 35.22           C  
ATOM     22  CG  PRO A  33       7.680  24.354  20.017  1.00 35.82           C  
ATOM     23  CD  PRO A  33       6.653  23.543  19.260  1.00 36.71           C  
ATOM     24  N   ASN A  34       6.052  24.375  23.738  1.00 33.61           N  
ATOM     25  CA  ASN A  34       5.448  25.400  24.582  1.00 33.86           C  
ATOM     26  C   ASN A  34       6.518  26.039  25.456  1.00 32.76           C  
ATOM     27  O   ASN A  34       6.401  26.085  26.681  1.00 31.55           O  
ATOM     28  CB  ASN A  34       4.330  24.798  25.433  1.00 36.43           C  
ATOM     29  CG  ASN A  34       4.838  23.803  26.449  1.00 38.90           C  
ATOM     30  OD1 ASN A  34       5.733  23.005  26.166  1.00 40.66           O  
ATOM     31  ND2 ASN A  34       4.257  23.837  27.642  1.00 40.78           N  
ATOM     32  N   TYR A  35       7.570  26.534  24.806  1.00 30.74           N  
ATOM     33  CA  TYR A  35       8.677  27.175  25.505  1.00 26.58           C  
ATOM     34  C   TYR A  35       8.210  28.358  26.331  1.00 26.93           C  
ATOM     35  O   TYR A  35       7.502  29.234  25.839  1.00 28.11           O  
ATOM     36  CB  TYR A  35       9.731  27.630  24.492  1.00 22.99           C  
ATOM     37  CG  TYR A  35      10.611  26.505  24.006  1.00 19.37           C  
ATOM     38  CD1 TYR A  35      11.693  26.054  24.766  1.00 16.51           C  
ATOM     39  CD2 TYR A  35      10.337  25.862  22.804  1.00 16.22           C  
ATOM     40  CE1 TYR A  35      12.481  24.994  24.332  1.00 17.61           C  
ATOM     41  CE2 TYR A  35      11.111  24.794  22.367  1.00 15.82           C  
ATOM     42  CZ  TYR A  35      12.181  24.370  23.131  1.00 16.35           C  
ATOM     43  OH  TYR A  35      12.964  23.332  22.694  1.00 20.67           O  
ATOM     44  N   ALA A  36       8.615  28.367  27.594  1.00 26.11           N  
ATOM     45  CA  ALA A  36       8.274  29.441  28.510  1.00 27.51           C  
ATOM     46  C   ALA A  36       9.556  29.912  29.185  1.00 28.20           C  
ATOM     47  O   ALA A  36      10.493  29.131  29.381  1.00 28.51           O  
ATOM     48  CB  ALA A  36       7.279  28.955  29.548  1.00 28.44           C  
ATOM     49  N   LEU A  37       9.587  31.189  29.546  1.00 28.71           N  
ATOM     50  CA  LEU A  37      10.758  31.792  30.173  1.00 28.59           C  
ATOM     51  C   LEU A  37      11.181  31.179  31.506  1.00 29.13           C  
ATOM     52  O   LEU A  37      10.399  31.118  32.452  1.00 30.00           O  
ATOM     53  CB  LEU A  37      10.519  33.293  30.361  1.00 28.73           C  
ATOM     54  CG  LEU A  37      11.721  34.134  30.797  1.00 27.39           C  
ATOM     55  CD1 LEU A  37      12.832  34.031  29.762  1.00 28.01           C  
ATOM     56  CD2 LEU A  37      11.284  35.577  30.961  1.00 27.76           C  
ATOM     57  N   MET A  38      12.428  30.722  31.558  1.00 30.49           N  
ATOM     58  CA  MET A  38      13.015  30.145  32.763  1.00 31.90           C  
ATOM     59  C   MET A  38      13.716  31.293  33.493  1.00 33.79           C  
ATOM     60  O   MET A  38      13.366  31.653  34.616  1.00 34.00           O  
ATOM     61  CB  MET A  38      14.084  29.100  32.416  1.00 32.57           C  
ATOM     62  CG  MET A  38      13.608  27.710  32.027  1.00 33.96           C  
ATOM     63  SD  MET A  38      14.934  26.764  31.179  1.00 33.64           S  
ATOM     64  CE  MET A  38      16.027  26.399  32.498  1.00 33.24           C  
ATOM     65  N   PHE A  39      14.712  31.868  32.823  1.00 33.75           N  
ATOM     66  CA  PHE A  39      15.498  32.945  33.406  1.00 33.56           C  
ATOM     67  C   PHE A  39      15.937  34.011  32.404  1.00 32.85           C  
ATOM     68  O   PHE A  39      15.877  33.823  31.192  1.00 31.77           O  
ATOM     69  CB  PHE A  39      16.760  32.365  34.053  1.00 33.89           C  
ATOM     70  CG  PHE A  39      16.496  31.249  35.014  1.00 35.11           C  
ATOM     71  CD1 PHE A  39      15.862  31.494  36.226  1.00 36.80           C  
ATOM     72  CD2 PHE A  39      16.880  29.950  34.707  1.00 35.78           C  
ATOM     73  CE1 PHE A  39      15.611  30.455  37.127  1.00 39.51           C  
ATOM     74  CE2 PHE A  39      16.634  28.904  35.599  1.00 38.33           C  
ATOM     75  CZ  PHE A  39      15.999  29.157  36.810  1.00 38.64           C  
ATOM     76  N   THR A  40      16.378  35.138  32.947  1.00 32.53           N  
ATOM     77  CA  THR A  40      16.902  36.241  32.165  1.00 31.64           C  
ATOM     78  C   THR A  40      18.275  36.451  32.780  1.00 30.52           C  
ATOM     79  O   THR A  40      18.388  36.760  33.969  1.00 29.61           O  
ATOM     80  CB  THR A  40      16.065  37.525  32.323  1.00 31.76           C  
ATOM     81  OG1 THR A  40      14.771  37.334  31.739  1.00 35.70           O  
ATOM     82  CG2 THR A  40      16.754  38.693  31.623  1.00 31.93           C  
ATOM     83  N   LEU A  41      19.321  36.253  31.986  1.00 29.35           N  
ATOM     84  CA  LEU A  41      20.683  36.405  32.477  1.00 28.83           C  
ATOM     85  C   LEU A  41      21.266  37.762  32.096  1.00 28.79           C  
ATOM     86  O   LEU A  41      21.526  38.034  30.919  1.00 27.94           O  
ATOM     87  CB  LEU A  41      21.573  35.283  31.929  1.00 28.19           C  
ATOM     88  CG  LEU A  41      21.046  33.848  32.045  1.00 27.94           C  
ATOM     89  CD1 LEU A  41      22.140  32.869  31.639  1.00 28.18           C  
ATOM     90  CD2 LEU A  41      20.593  33.570  33.465  1.00 28.90           C  
ATOM     91  N   ALA A  42      21.467  38.609  33.100  1.00 26.81           N  
ATOM     92  CA  ALA A  42      22.020  39.940  32.883  1.00 25.61           C  
ATOM     93  C   ALA A  42      23.447  40.012  33.405  1.00 24.46           C  
ATOM     94  O   ALA A  42      23.818  39.305  34.342  1.00 22.73           O  
ATOM     95  CB  ALA A  42      21.158  40.983  33.572  1.00 26.04           C  
ATOM     96  N   GLY A  43      24.249  40.875  32.792  1.00 23.72           N  
ATOM     97  CA  GLY A  43      25.628  41.008  33.218  1.00 22.56           C  
ATOM     98  C   GLY A  43      26.495  41.710  32.194  1.00 21.96           C  
ATOM     99  O   GLY A  43      27.296  42.582  32.543  1.00 21.65           O  
ATOM    100  N   HIS A  44      26.349  41.328  30.930  1.00 18.34           N  
ATOM    101  CA  HIS A  44      27.127  41.953  29.875  1.00 18.58           C  
ATOM    102  C   HIS A  44      26.816  43.441  29.799  1.00 19.20           C  
ATOM    103  O   HIS A  44      25.661  43.853  29.985  1.00 16.50           O  
ATOM    104  CB  HIS A  44      26.831  41.281  28.536  1.00 18.93           C  
ATOM    105  CG  HIS A  44      27.515  39.963  28.366  1.00 17.42           C  
ATOM    106  ND1 HIS A  44      28.886  39.832  28.397  1.00 17.39           N  
ATOM    107  CD2 HIS A  44      27.022  38.722  28.153  1.00 17.49           C  
ATOM    108  CE1 HIS A  44      29.210  38.565  28.208  1.00 17.70           C  
ATOM    109  NE2 HIS A  44      28.097  37.872  28.057  1.00 19.09           N  
ATOM    110  N   THR A  45      27.843  44.247  29.533  1.00 17.30           N  
ATOM    111  CA  THR A  45      27.661  45.693  29.453  1.00 17.00           C  
ATOM    112  C   THR A  45      27.382  46.213  28.045  1.00 16.32           C  
ATOM    113  O   THR A  45      27.068  47.389  27.861  1.00 18.27           O  
ATOM    114  CB  THR A  45      28.865  46.431  30.068  1.00 16.36           C  
ATOM    115  OG1 THR A  45      30.084  45.825  29.622  1.00 19.00           O  
ATOM    116  CG2 THR A  45      28.792  46.359  31.586  1.00 14.39           C  
ATOM    117  N   LYS A  46      27.500  45.337  27.054  1.00 15.79           N  
ATOM    118  CA  LYS A  46      27.201  45.698  25.671  1.00 15.31           C  
ATOM    119  C   LYS A  46      26.408  44.558  25.055  1.00 14.07           C  
ATOM    120  O   LYS A  46      26.167  43.551  25.706  1.00 15.88           O  
ATOM    121  CB  LYS A  46      28.476  45.942  24.864  1.00 15.13           C  
ATOM    122  CG  LYS A  46      29.166  47.254  25.183  1.00 16.64           C  
ATOM    123  CD  LYS A  46      30.307  47.511  24.221  1.00 18.79           C  
ATOM    124  CE  LYS A  46      30.926  48.885  24.455  1.00 20.82           C  
ATOM    125  NZ  LYS A  46      31.967  49.183  23.445  1.00 17.61           N  
ATOM    126  N   ALA A  47      25.994  44.729  23.807  1.00 14.91           N  
ATOM    127  CA  ALA A  47      25.230  43.712  23.096  1.00 17.22           C  
ATOM    128  C   ALA A  47      25.902  42.353  23.198  1.00 17.86           C  
ATOM    129  O   ALA A  47      27.127  42.252  23.123  1.00 19.88           O  
ATOM    130  CB  ALA A  47      25.100  44.095  21.625  1.00 16.32           C  
ATOM    131  N   VAL A  48      25.100  41.310  23.384  1.00 18.62           N  
ATOM    132  CA  VAL A  48      25.631  39.954  23.449  1.00 16.49           C  
ATOM    133  C   VAL A  48      25.764  39.527  21.985  1.00 17.91           C  
ATOM    134  O   VAL A  48      24.981  39.965  21.139  1.00 17.34           O  
ATOM    135  CB  VAL A  48      24.669  39.001  24.181  1.00 17.56           C  
ATOM    136  CG1 VAL A  48      25.275  37.609  24.254  1.00 14.50           C  
ATOM    137  CG2 VAL A  48      24.386  39.521  25.586  1.00 16.14           C  
ATOM    138  N   SER A  49      26.746  38.690  21.672  1.00 16.08           N  
ATOM    139  CA  SER A  49      26.936  38.281  20.289  1.00 17.12           C  
ATOM    140  C   SER A  49      26.706  36.793  20.025  1.00 17.60           C  
ATOM    141  O   SER A  49      26.408  36.399  18.899  1.00 15.72           O  
ATOM    142  CB  SER A  49      28.351  38.644  19.835  1.00 17.89           C  
ATOM    143  OG  SER A  49      29.313  37.922  20.591  1.00 18.12           O  
ATOM    144  N   SER A  50      26.843  35.965  21.053  1.00 17.47           N  
ATOM    145  CA  SER A  50      26.671  34.532  20.851  1.00 18.84           C  
ATOM    146  C   SER A  50      26.487  33.734  22.134  1.00 18.98           C  
ATOM    147  O   SER A  50      27.150  33.990  23.141  1.00 19.06           O  
ATOM    148  CB  SER A  50      27.885  33.995  20.087  1.00 17.62           C  
ATOM    149  OG  SER A  50      27.795  32.600  19.893  1.00 24.05           O  
ATOM    150  N   VAL A  51      25.577  32.768  22.095  1.00 18.00           N  
ATOM    151  CA  VAL A  51      25.341  31.907  23.247  1.00 17.81           C  
ATOM    152  C   VAL A  51      25.479  30.454  22.788  1.00 18.31           C  
ATOM    153  O   VAL A  51      24.971  30.076  21.730  1.00 18.18           O  
ATOM    154  CB  VAL A  51      23.943  32.149  23.869  1.00 17.40           C  
ATOM    155  CG1 VAL A  51      23.896  33.530  24.499  1.00 16.87           C  
ATOM    156  CG2 VAL A  51      22.851  32.015  22.810  1.00 17.69           C  
ATOM    157  N   LYS A  52      26.186  29.653  23.579  1.00 19.39           N  
ATOM    158  CA  LYS A  52      26.422  28.250  23.247  1.00 18.85           C  
ATOM    159  C   LYS A  52      26.382  27.348  24.470  1.00 19.29           C  
ATOM    160  O   LYS A  52      26.960  27.666  25.511  1.00 18.68           O  
ATOM    161  CB  LYS A  52      27.792  28.091  22.583  1.00 17.31           C  
ATOM    162  CG  LYS A  52      27.968  28.846  21.284  1.00 18.44           C  
ATOM    163  CD  LYS A  52      27.142  28.231  20.161  1.00 19.24           C  
ATOM    164  CE  LYS A  52      27.395  28.959  18.850  1.00 21.68           C  
ATOM    165  NZ  LYS A  52      28.853  29.046  18.526  1.00 19.85           N  
ATOM    166  N   PHE A  53      25.713  26.210  24.327  1.00 19.79           N  
ATOM    167  CA  PHE A  53      25.618  25.226  25.398  1.00 19.73           C  
ATOM    168  C   PHE A  53      26.822  24.297  25.356  1.00 20.33           C  
ATOM    169  O   PHE A  53      27.220  23.841  24.290  1.00 22.79           O  
ATOM    170  CB  PHE A  53      24.342  24.392  25.242  1.00 18.07           C  
ATOM    171  CG  PHE A  53      23.104  25.052  25.793  1.00 16.59           C  
ATOM    172  CD1 PHE A  53      22.980  25.301  27.155  1.00 14.35           C  
ATOM    173  CD2 PHE A  53      22.052  25.398  24.951  1.00 14.87           C  
ATOM    174  CE1 PHE A  53      21.828  25.882  27.675  1.00 15.04           C  
ATOM    175  CE2 PHE A  53      20.891  25.983  25.464  1.00 14.83           C  
ATOM    176  CZ  PHE A  53      20.781  26.223  26.826  1.00 12.56           C  
ATOM    177  N   SER A  54      27.414  24.020  26.509  1.00 21.76           N  
ATOM    178  CA  SER A  54      28.553  23.112  26.542  1.00 23.36           C  
ATOM    179  C   SER A  54      28.023  21.727  26.177  1.00 24.06           C  
ATOM    180  O   SER A  54      26.843  21.437  26.381  1.00 24.59           O  
ATOM    181  CB  SER A  54      29.162  23.068  27.941  1.00 24.66           C  
ATOM    182  OG  SER A  54      28.239  22.516  28.861  1.00 28.43           O  
ATOM    183  N   PRO A  55      28.882  20.856  25.630  1.00 24.35           N  
ATOM    184  CA  PRO A  55      28.459  19.505  25.252  1.00 26.37           C  
ATOM    185  C   PRO A  55      27.843  18.670  26.392  1.00 26.76           C  
ATOM    186  O   PRO A  55      26.877  17.940  26.172  1.00 28.34           O  
ATOM    187  CB  PRO A  55      29.741  18.893  24.699  1.00 26.10           C  
ATOM    188  CG  PRO A  55      30.417  20.084  24.076  1.00 25.35           C  
ATOM    189  CD  PRO A  55      30.250  21.124  25.155  1.00 23.96           C  
ATOM    190  N   ASN A  56      28.385  18.777  27.603  1.00 26.66           N  
ATOM    191  CA  ASN A  56      27.838  18.012  28.722  1.00 26.24           C  
ATOM    192  C   ASN A  56      26.533  18.611  29.224  1.00 27.07           C  
ATOM    193  O   ASN A  56      25.921  18.090  30.155  1.00 28.24           O  
ATOM    194  CB  ASN A  56      28.841  17.922  29.875  1.00 26.92           C  
ATOM    195  CG  ASN A  56      29.235  19.278  30.419  1.00 27.67           C  
ATOM    196  OD1 ASN A  56      28.388  20.143  30.645  1.00 27.54           O  
ATOM    197  ND2 ASN A  56      30.529  19.464  30.656  1.00 27.59           N  
ATOM    198  N   GLY A  57      26.125  19.721  28.617  1.00 26.73           N  
ATOM    199  CA  GLY A  57      24.873  20.367  28.973  1.00 26.91           C  
ATOM    200  C   GLY A  57      24.694  21.163  30.259  1.00 27.03           C  
ATOM    201  O   GLY A  57      23.590  21.656  30.507  1.00 26.43           O  
ATOM    202  N   GLU A  58      25.721  21.318  31.085  1.00 25.96           N  
ATOM    203  CA  GLU A  58      25.498  22.079  32.308  1.00 27.97           C  
ATOM    204  C   GLU A  58      25.909  23.546  32.233  1.00 27.90           C  
ATOM    205  O   GLU A  58      25.617  24.322  33.143  1.00 30.10           O  
ATOM    206  CB  GLU A  58      26.174  21.407  33.517  1.00 28.95           C  
ATOM    207  CG  GLU A  58      27.674  21.505  33.580  1.00 30.56           C  
ATOM    208  CD  GLU A  58      28.212  21.115  34.956  1.00 32.85           C  
ATOM    209  OE1 GLU A  58      27.878  21.804  35.945  1.00 33.63           O  
ATOM    210  OE2 GLU A  58      28.965  20.125  35.054  1.00 31.76           O  
ATOM    211  N   TRP A  59      26.562  23.945  31.150  1.00 25.36           N  
ATOM    212  CA  TRP A  59      26.975  25.330  31.039  1.00 24.30           C  
ATOM    213  C   TRP A  59      26.462  26.044  29.798  1.00 24.03           C  
ATOM    214  O   TRP A  59      26.132  25.423  28.782  1.00 24.07           O  
ATOM    215  CB  TRP A  59      28.499  25.440  31.040  1.00 25.12           C  
ATOM    216  CG  TRP A  59      29.206  24.630  32.070  1.00 25.77           C  
ATOM    217  CD1 TRP A  59      30.045  23.571  31.847  1.00 25.82           C  
ATOM    218  CD2 TRP A  59      29.206  24.852  33.481  1.00 26.23           C  
ATOM    219  NE1 TRP A  59      30.574  23.127  33.033  1.00 27.75           N  
ATOM    220  CE2 TRP A  59      30.076  23.896  34.054  1.00 27.01           C  
ATOM    221  CE3 TRP A  59      28.555  25.768  34.320  1.00 27.19           C  
ATOM    222  CZ2 TRP A  59      30.317  23.829  35.429  1.00 26.47           C  
ATOM    223  CZ3 TRP A  59      28.793  25.703  35.690  1.00 29.46           C  
ATOM    224  CH2 TRP A  59      29.670  24.735  36.229  1.00 28.29           C  
ATOM    225  N   LEU A  60      26.400  27.367  29.903  1.00 24.05           N  
ATOM    226  CA  LEU A  60      26.010  28.229  28.794  1.00 21.14           C  
ATOM    227  C   LEU A  60      27.104  29.282  28.757  1.00 21.30           C  
ATOM    228  O   LEU A  60      27.336  29.976  29.755  1.00 20.46           O  
ATOM    229  CB  LEU A  60      24.668  28.922  29.035  1.00 19.93           C  
ATOM    230  CG  LEU A  60      24.282  29.853  27.871  1.00 20.85           C  
ATOM    231  CD1 LEU A  60      23.895  29.020  26.649  1.00 19.97           C  
ATOM    232  CD2 LEU A  60      23.133  30.751  28.274  1.00 19.89           C  
ATOM    233  N   ALA A  61      27.796  29.384  27.628  1.00 18.40           N  
ATOM    234  CA  ALA A  61      28.849  30.374  27.492  1.00 17.47           C  
ATOM    235  C   ALA A  61      28.359  31.478  26.565  1.00 18.02           C  
ATOM    236  O   ALA A  61      27.730  31.206  25.535  1.00 18.24           O  
ATOM    237  CB  ALA A  61      30.110  29.736  26.931  1.00 14.29           C  
ATOM    238  N   SER A  62      28.638  32.722  26.943  1.00 16.91           N  
ATOM    239  CA  SER A  62      28.243  33.870  26.147  1.00 15.77           C  
ATOM    240  C   SER A  62      29.444  34.764  25.837  1.00 15.30           C  
ATOM    241  O   SER A  62      30.392  34.837  26.616  1.00 15.11           O  
ATOM    242  CB  SER A  62      27.183  34.683  26.880  1.00 15.89           C  
ATOM    243  OG  SER A  62      27.665  35.122  28.134  1.00 20.22           O  
ATOM    244  N   SER A  63      29.399  35.421  24.681  1.00 14.40           N  
ATOM    245  CA  SER A  63      30.451  36.334  24.256  1.00 14.04           C  
ATOM    246  C   SER A  63      29.737  37.642  23.956  1.00 15.14           C  
ATOM    247  O   SER A  63      28.567  37.640  23.575  1.00 15.75           O  
ATOM    248  CB  SER A  63      31.154  35.809  23.004  1.00 14.39           C  
ATOM    249  OG  SER A  63      30.237  35.633  21.932  1.00 14.59           O  
ATOM    250  N   SER A  64      30.429  38.760  24.119  1.00 15.68           N  
ATOM    251  CA  SER A  64      29.796  40.045  23.898  1.00 15.17           C  
ATOM    252  C   SER A  64      30.718  41.109  23.319  1.00 16.60           C  
ATOM    253  O   SER A  64      31.950  40.978  23.349  1.00 14.37           O  
ATOM    254  CB  SER A  64      29.209  40.546  25.224  1.00 15.69           C  
ATOM    255  OG  SER A  64      28.942  41.938  25.192  1.00 14.35           O  
ATOM    256  N   ALA A  65      30.099  42.165  22.793  1.00 15.48           N  
ATOM    257  CA  ALA A  65      30.832  43.281  22.228  1.00 16.22           C  
ATOM    258  C   ALA A  65      31.591  43.964  23.365  1.00 16.91           C  
ATOM    259  O   ALA A  65      32.390  44.868  23.124  1.00 16.98           O  
ATOM    260  CB  ALA A  65      29.869  44.265  21.567  1.00 12.30           C  
ATOM    261  N   ASP A  66      31.339  43.531  24.600  1.00 17.09           N  
ATOM    262  CA  ASP A  66      32.019  44.114  25.749  1.00 18.13           C  
ATOM    263  C   ASP A  66      33.366  43.448  26.003  1.00 18.39           C  
ATOM    264  O   ASP A  66      34.008  43.704  27.019  1.00 19.89           O  
ATOM    265  CB  ASP A  66      31.141  44.054  27.015  1.00 19.21           C  
ATOM    266  CG  ASP A  66      30.871  42.638  27.492  1.00 20.52           C  
ATOM    267  OD1 ASP A  66      31.500  41.687  26.982  1.00 19.99           O  
ATOM    268  OD2 ASP A  66      30.023  42.483  28.400  1.00 24.35           O  
ATOM    269  N   LYS A  67      33.783  42.594  25.068  1.00 17.46           N  
ATOM    270  CA  LYS A  67      35.075  41.906  25.130  1.00 16.38           C  
ATOM    271  C   LYS A  67      35.151  40.786  26.154  1.00 16.27           C  
ATOM    272  O   LYS A  67      36.215  40.203  26.367  1.00 16.69           O  
ATOM    273  CB  LYS A  67      36.193  42.916  25.403  1.00 18.16           C  
ATOM    274  CG  LYS A  67      36.160  44.115  24.470  1.00 21.32           C  
ATOM    275  CD  LYS A  67      37.327  45.073  24.690  1.00 23.84           C  
ATOM    276  CE  LYS A  67      37.091  46.036  25.836  1.00 24.94           C  
ATOM    277  NZ  LYS A  67      38.121  47.118  25.821  1.00 26.15           N  
ATOM    278  N   LEU A  68      34.026  40.462  26.775  1.00 14.57           N  
ATOM    279  CA  LEU A  68      34.028  39.412  27.788  1.00 15.62           C  
ATOM    280  C   LEU A  68      33.296  38.121  27.428  1.00 15.93           C  
ATOM    281  O   LEU A  68      32.434  38.085  26.551  1.00 15.10           O  
ATOM    282  CB  LEU A  68      33.423  39.956  29.083  1.00 15.13           C  
ATOM    283  CG  LEU A  68      33.987  41.264  29.640  1.00 15.51           C  
ATOM    284  CD1 LEU A  68      33.141  41.703  30.837  1.00 14.23           C  
ATOM    285  CD2 LEU A  68      35.439  41.066  30.044  1.00 11.00           C  
ATOM    286  N   ILE A  69      33.661  37.055  28.123  1.00 16.73           N  
ATOM    287  CA  ILE A  69      33.007  35.772  27.958  1.00 19.59           C  
ATOM    288  C   ILE A  69      32.500  35.421  29.346  1.00 21.99           C  
ATOM    289  O   ILE A  69      33.243  35.507  30.325  1.00 23.23           O  
ATOM    290  CB  ILE A  69      33.972  34.669  27.486  1.00 20.99           C  
ATOM    291  CG1 ILE A  69      34.335  34.892  26.012  1.00 21.76           C  
ATOM    292  CG2 ILE A  69      33.335  33.303  27.690  1.00 16.07           C  
ATOM    293  CD1 ILE A  69      35.441  33.980  25.497  1.00 22.19           C  
ATOM    294  N   LYS A  70      31.232  35.045  29.437  1.00 21.89           N  
ATOM    295  CA  LYS A  70      30.660  34.678  30.718  1.00 21.13           C  
ATOM    296  C   LYS A  70      30.096  33.267  30.670  1.00 21.56           C  
ATOM    297  O   LYS A  70      29.499  32.856  29.671  1.00 21.05           O  
ATOM    298  CB  LYS A  70      29.581  35.689  31.113  1.00 19.94           C  
ATOM    299  CG  LYS A  70      30.152  37.065  31.426  1.00 16.97           C  
ATOM    300  CD  LYS A  70      29.065  38.070  31.733  1.00 17.84           C  
ATOM    301  CE  LYS A  70      29.647  39.427  32.093  1.00 17.29           C  
ATOM    302  NZ  LYS A  70      30.397  39.401  33.379  1.00 19.25           N  
ATOM    303  N   ILE A  71      30.318  32.518  31.748  1.00 22.05           N  
ATOM    304  CA  ILE A  71      29.837  31.145  31.851  1.00 20.43           C  
ATOM    305  C   ILE A  71      28.675  31.141  32.837  1.00 21.57           C  
ATOM    306  O   ILE A  71      28.770  31.726  33.924  1.00 19.88           O  
ATOM    307  CB  ILE A  71      30.934  30.198  32.378  1.00 20.20           C  
ATOM    308  CG1 ILE A  71      32.196  30.312  31.519  1.00 19.93           C  
ATOM    309  CG2 ILE A  71      30.419  28.771  32.390  1.00 18.75           C  
ATOM    310  CD1 ILE A  71      32.031  29.838  30.092  1.00 20.77           C  
ATOM    311  N   TRP A  72      27.583  30.483  32.450  1.00 21.29           N  
ATOM    312  CA  TRP A  72      26.389  30.415  33.282  1.00 20.63           C  
ATOM    313  C   TRP A  72      25.901  28.979  33.437  1.00 21.92           C  
ATOM    314  O   TRP A  72      26.209  28.118  32.614  1.00 21.50           O  
ATOM    315  CB  TRP A  72      25.255  31.235  32.661  1.00 20.95           C  
ATOM    316  CG  TRP A  72      25.667  32.550  32.084  1.00 19.64           C  
ATOM    317  CD1 TRP A  72      26.378  32.756  30.939  1.00 19.58           C  
ATOM    318  CD2 TRP A  72      25.374  33.847  32.613  1.00 20.24           C  
ATOM    319  NE1 TRP A  72      26.545  34.100  30.717  1.00 19.40           N  
ATOM    320  CE2 TRP A  72      25.940  34.795  31.730  1.00 19.51           C  
ATOM    321  CE3 TRP A  72      24.687  34.301  33.747  1.00 18.92           C  
ATOM    322  CZ2 TRP A  72      25.840  36.173  31.945  1.00 20.85           C  
ATOM    323  CZ3 TRP A  72      24.588  35.675  33.963  1.00 20.42           C  
ATOM    324  CH2 TRP A  72      25.163  36.594  33.064  1.00 21.47           C  
ATOM    325  N   GLY A  73      25.131  28.739  34.494  1.00 22.04           N  
ATOM    326  CA  GLY A  73      24.582  27.422  34.736  1.00 22.37           C  
ATOM    327  C   GLY A  73      23.407  27.235  33.802  1.00 23.12           C  
ATOM    328  O   GLY A  73      22.453  28.005  33.835  1.00 22.84           O  
ATOM    329  N   ALA A  74      23.475  26.210  32.964  1.00 24.78           N  
ATOM    330  CA  ALA A  74      22.421  25.941  31.996  1.00 26.33           C  
ATOM    331  C   ALA A  74      21.050  25.655  32.611  1.00 28.01           C  
ATOM    332  O   ALA A  74      20.025  25.916  31.985  1.00 26.75           O  
ATOM    333  CB  ALA A  74      22.838  24.778  31.105  1.00 25.48           C  
ATOM    334  N   TYR A  75      21.027  25.134  33.836  1.00 28.81           N  
ATOM    335  CA  TYR A  75      19.759  24.798  34.473  1.00 30.06           C  
ATOM    336  C   TYR A  75      19.270  25.808  35.500  1.00 32.00           C  
ATOM    337  O   TYR A  75      18.063  26.028  35.623  1.00 34.04           O  
ATOM    338  CB  TYR A  75      19.856  23.407  35.113  1.00 28.85           C  
ATOM    339  CG  TYR A  75      20.355  22.345  34.160  1.00 26.16           C  
ATOM    340  CD1 TYR A  75      19.632  22.013  33.017  1.00 24.57           C  
ATOM    341  CD2 TYR A  75      21.565  21.695  34.385  1.00 24.99           C  
ATOM    342  CE1 TYR A  75      20.101  21.066  32.120  1.00 23.65           C  
ATOM    343  CE2 TYR A  75      22.046  20.745  33.492  1.00 25.04           C  
ATOM    344  CZ  TYR A  75      21.310  20.436  32.360  1.00 25.28           C  
ATOM    345  OH  TYR A  75      21.789  19.514  31.455  1.00 23.25           O  
ATOM    346  N   ASP A  76      20.190  26.421  36.237  1.00 31.34           N  
ATOM    347  CA  ASP A  76      19.806  27.402  37.247  1.00 32.66           C  
ATOM    348  C   ASP A  76      19.991  28.839  36.769  1.00 33.21           C  
ATOM    349  O   ASP A  76      19.527  29.773  37.415  1.00 34.01           O  
ATOM    350  CB  ASP A  76      20.623  27.187  38.518  1.00 32.22           C  
ATOM    351  CG  ASP A  76      22.101  27.125  38.240  1.00 34.64           C  
ATOM    352  OD1 ASP A  76      22.537  27.780  37.272  1.00 37.69           O  
ATOM    353  OD2 ASP A  76      22.831  26.434  38.987  1.00 36.92           O  
ATOM    354  N   GLY A  77      20.671  29.011  35.638  1.00 33.23           N  
ATOM    355  CA  GLY A  77      20.906  30.343  35.108  1.00 31.81           C  
ATOM    356  C   GLY A  77      21.811  31.140  36.024  1.00 31.88           C  
ATOM    357  O   GLY A  77      21.834  32.365  35.986  1.00 31.85           O  
ATOM    358  N   LYS A  78      22.575  30.434  36.846  1.00 31.68           N  
ATOM    359  CA  LYS A  78      23.479  31.063  37.800  1.00 33.30           C  
ATOM    360  C   LYS A  78      24.800  31.513  37.173  1.00 32.60           C  
ATOM    361  O   LYS A  78      25.468  30.740  36.488  1.00 31.24           O  
ATOM    362  CB  LYS A  78      23.749  30.080  38.941  1.00 35.14           C  
ATOM    363  CG  LYS A  78      24.758  30.522  39.984  1.00 40.41           C  
ATOM    364  CD  LYS A  78      24.806  29.499  41.121  1.00 43.52           C  
ATOM    365  CE  LYS A  78      26.229  29.017  41.408  1.00 46.45           C  
ATOM    366  NZ  LYS A  78      27.117  30.108  41.904  1.00 48.07           N  
ATOM    367  N   PHE A  79      25.170  32.772  37.401  1.00 31.86           N  
ATOM    368  CA  PHE A  79      26.430  33.289  36.876  1.00 30.88           C  
ATOM    369  C   PHE A  79      27.547  32.477  37.519  1.00 30.91           C  
ATOM    370  O   PHE A  79      27.521  32.221  38.720  1.00 31.15           O  
ATOM    371  CB  PHE A  79      26.619  34.761  37.239  1.00 29.65           C  
ATOM    372  CG  PHE A  79      27.987  35.290  36.904  1.00 30.52           C  
ATOM    373  CD1 PHE A  79      28.354  35.523  35.579  1.00 28.22           C  
ATOM    374  CD2 PHE A  79      28.921  35.520  37.907  1.00 28.88           C  
ATOM    375  CE1 PHE A  79      29.626  35.975  35.259  1.00 27.28           C  
ATOM    376  CE2 PHE A  79      30.202  35.974  37.597  1.00 29.38           C  
ATOM    377  CZ  PHE A  79      30.553  36.201  36.269  1.00 28.94           C  
ATOM    378  N   GLU A  80      28.532  32.078  36.727  1.00 30.90           N  
ATOM    379  CA  GLU A  80      29.626  31.278  37.250  1.00 31.07           C  
ATOM    380  C   GLU A  80      30.954  32.032  37.213  1.00 29.76           C  
ATOM    381  O   GLU A  80      31.689  32.051  38.201  1.00 30.14           O  
ATOM    382  CB  GLU A  80      29.747  29.983  36.450  1.00 33.28           C  
ATOM    383  CG  GLU A  80      30.190  28.770  37.253  1.00 39.81           C  
ATOM    384  CD  GLU A  80      29.112  28.273  38.204  1.00 41.81           C  
ATOM    385  OE1 GLU A  80      27.925  28.256  37.800  1.00 43.30           O  
ATOM    386  OE2 GLU A  80      29.453  27.886  39.345  1.00 43.19           O  
ATOM    387  N   LYS A  81      31.268  32.653  36.080  1.00 26.91           N  
ATOM    388  CA  LYS A  81      32.523  33.383  35.977  1.00 25.98           C  
ATOM    389  C   LYS A  81      32.642  34.213  34.713  1.00 25.41           C  
ATOM    390  O   LYS A  81      31.886  34.036  33.756  1.00 24.09           O  
ATOM    391  CB  LYS A  81      33.705  32.418  36.018  1.00 25.44           C  
ATOM    392  CG  LYS A  81      34.010  31.775  34.674  1.00 28.13           C  
ATOM    393  CD  LYS A  81      35.326  31.006  34.693  1.00 28.18           C  
ATOM    394  CE  LYS A  81      35.187  29.709  35.472  1.00 30.50           C  
ATOM    395  NZ  LYS A  81      36.482  28.985  35.539  1.00 31.92           N  
ATOM    396  N   THR A  82      33.616  35.116  34.726  1.00 24.70           N  
ATOM    397  CA  THR A  82      33.894  35.978  33.591  1.00 23.39           C  
ATOM    398  C   THR A  82      35.301  35.648  33.121  1.00 23.89           C  
ATOM    399  O   THR A  82      36.218  35.520  33.927  1.00 24.63           O  
ATOM    400  CB  THR A  82      33.826  37.475  33.977  1.00 23.24           C  
ATOM    401  OG1 THR A  82      32.476  37.824  34.315  1.00 21.93           O  
ATOM    402  CG2 THR A  82      34.284  38.351  32.819  1.00 20.71           C  
ATOM    403  N   ILE A  83      35.458  35.484  31.815  1.00 22.75           N  
ATOM    404  CA  ILE A  83      36.753  35.170  31.225  1.00 20.93           C  
ATOM    405  C   ILE A  83      37.071  36.348  30.317  1.00 20.91           C  
ATOM    406  O   ILE A  83      36.296  36.664  29.417  1.00 20.01           O  
ATOM    407  CB  ILE A  83      36.676  33.856  30.402  1.00 20.66           C  
ATOM    408  CG1 ILE A  83      36.281  32.697  31.320  1.00 18.33           C  
ATOM    409  CG2 ILE A  83      38.012  33.570  29.735  1.00 19.20           C  
ATOM    410  CD1 ILE A  83      35.880  31.440  30.588  1.00 18.61           C  
ATOM    411  N   SER A  84      38.194  37.012  30.568  1.00 21.08           N  
ATOM    412  CA  SER A  84      38.567  38.174  29.770  1.00 21.21           C  
ATOM    413  C   SER A  84      39.973  38.065  29.209  1.00 21.69           C  
ATOM    414  O   SER A  84      40.739  37.185  29.600  1.00 21.66           O  
ATOM    415  CB  SER A  84      38.446  39.443  30.616  1.00 22.17           C  
ATOM    416  OG  SER A  84      39.255  39.361  31.775  1.00 24.64           O  
ATOM    417  N   GLY A  85      40.302  38.974  28.296  1.00 21.46           N  
ATOM    418  CA  GLY A  85      41.621  38.983  27.682  1.00 21.13           C  
ATOM    419  C   GLY A  85      41.633  39.671  26.324  1.00 21.23           C  
ATOM    420  O   GLY A  85      42.572  40.404  25.997  1.00 21.86           O  
ATOM    421  N   HIS A  86      40.600  39.429  25.520  1.00 18.53           N  
ATOM    422  CA  HIS A  86      40.510  40.047  24.201  1.00 17.23           C  
ATOM    423  C   HIS A  86      40.549  41.573  24.300  1.00 18.01           C  
ATOM    424  O   HIS A  86      40.065  42.162  25.274  1.00 16.88           O  
ATOM    425  CB  HIS A  86      39.225  39.610  23.503  1.00 17.44           C  
ATOM    426  CG  HIS A  86      39.344  38.301  22.791  1.00 18.20           C  
ATOM    427  ND1 HIS A  86      40.220  38.106  21.745  1.00 19.64           N  
ATOM    428  CD2 HIS A  86      38.690  37.129  22.959  1.00 17.83           C  
ATOM    429  CE1 HIS A  86      40.100  36.870  21.298  1.00 18.05           C  
ATOM    430  NE2 HIS A  86      39.178  36.255  22.017  1.00 17.62           N  
ATOM    431  N   LYS A  87      41.120  42.206  23.279  1.00 18.81           N  
ATOM    432  CA  LYS A  87      41.248  43.656  23.229  1.00 18.87           C  
ATOM    433  C   LYS A  87      39.997  44.358  22.723  1.00 19.03           C  
ATOM    434  O   LYS A  87      39.749  45.511  23.070  1.00 21.71           O  
ATOM    435  CB  LYS A  87      42.411  44.047  22.323  1.00 20.09           C  
ATOM    436  CG  LYS A  87      43.665  44.501  23.028  1.00 24.38           C  
ATOM    437  CD  LYS A  87      44.433  43.352  23.625  1.00 27.03           C  
ATOM    438  CE  LYS A  87      45.847  43.794  23.960  1.00 30.80           C  
ATOM    439  NZ  LYS A  87      46.641  42.698  24.578  1.00 33.59           N  
ATOM    440  N   LEU A  88      39.226  43.674  21.886  1.00 17.00           N  
ATOM    441  CA  LEU A  88      38.016  44.253  21.318  1.00 14.40           C  
ATOM    442  C   LEU A  88      36.841  43.276  21.368  1.00 15.39           C  
ATOM    443  O   LEU A  88      36.988  42.135  21.796  1.00 16.61           O  
ATOM    444  CB  LEU A  88      38.279  44.681  19.872  1.00 13.36           C  
ATOM    445  CG  LEU A  88      39.264  45.836  19.640  1.00 14.45           C  
ATOM    446  CD1 LEU A  88      39.644  45.923  18.156  1.00 12.16           C  
ATOM    447  CD2 LEU A  88      38.643  47.144  20.099  1.00 10.63           C  
ATOM    448  N   GLY A  89      35.671  43.734  20.933  1.00 16.29           N  
ATOM    449  CA  GLY A  89      34.486  42.894  20.945  1.00 13.30           C  
ATOM    450  C   GLY A  89      34.705  41.488  20.413  1.00 13.35           C  
ATOM    451  O   GLY A  89      35.598  41.244  19.589  1.00  8.55           O  
ATOM    452  N   ILE A  90      33.866  40.564  20.885  1.00 11.98           N  
ATOM    453  CA  ILE A  90      33.928  39.159  20.500  1.00 13.03           C  
ATOM    454  C   ILE A  90      32.657  38.793  19.740  1.00 14.51           C  
ATOM    455  O   ILE A  90      31.554  39.052  20.223  1.00 15.47           O  
ATOM    456  CB  ILE A  90      34.033  38.262  21.755  1.00 12.41           C  
ATOM    457  CG1 ILE A  90      35.277  38.643  22.561  1.00 11.76           C  
ATOM    458  CG2 ILE A  90      34.076  36.792  21.359  1.00 11.09           C  
ATOM    459  CD1 ILE A  90      35.283  38.061  23.975  1.00 11.84           C  
ATOM    460  N   SER A  91      32.808  38.186  18.563  1.00 15.67           N  
ATOM    461  CA  SER A  91      31.655  37.803  17.738  1.00 15.75           C  
ATOM    462  C   SER A  91      31.194  36.356  17.889  1.00 16.73           C  
ATOM    463  O   SER A  91      30.089  36.018  17.473  1.00 15.62           O  
ATOM    464  CB  SER A  91      31.946  38.039  16.250  1.00 15.26           C  
ATOM    465  OG  SER A  91      32.020  39.416  15.926  1.00 18.09           O  
ATOM    466  N   ASP A  92      32.018  35.496  18.476  1.00 16.61           N  
ATOM    467  CA  ASP A  92      31.618  34.106  18.579  1.00 16.55           C  
ATOM    468  C   ASP A  92      32.478  33.312  19.546  1.00 17.41           C  
ATOM    469  O   ASP A  92      33.608  33.696  19.845  1.00 17.34           O  
ATOM    470  CB  ASP A  92      31.675  33.486  17.174  1.00 16.76           C  
ATOM    471  CG  ASP A  92      30.905  32.176  17.062  1.00 18.37           C  
ATOM    472  OD1 ASP A  92      29.987  31.939  17.879  1.00 17.38           O  
ATOM    473  OD2 ASP A  92      31.208  31.394  16.133  1.00 16.89           O  
ATOM    474  N   VAL A  93      31.912  32.218  20.048  1.00 19.04           N  
ATOM    475  CA  VAL A  93      32.592  31.306  20.967  1.00 20.83           C  
ATOM    476  C   VAL A  93      32.082  29.891  20.700  1.00 19.25           C  
ATOM    477  O   VAL A  93      30.931  29.706  20.315  1.00 19.36           O  
ATOM    478  CB  VAL A  93      32.312  31.643  22.457  1.00 22.96           C  
ATOM    479  CG1 VAL A  93      32.962  32.954  22.827  1.00 25.45           C  
ATOM    480  CG2 VAL A  93      30.813  31.693  22.709  1.00 23.26           C  
ATOM    481  N   ALA A  94      32.943  28.901  20.906  1.00 17.94           N  
ATOM    482  CA  ALA A  94      32.572  27.509  20.684  1.00 18.39           C  
ATOM    483  C   ALA A  94      33.243  26.606  21.726  1.00 18.56           C  
ATOM    484  O   ALA A  94      34.337  26.905  22.200  1.00 18.90           O  
ATOM    485  CB  ALA A  94      32.982  27.081  19.271  1.00 17.01           C  
ATOM    486  N   TRP A  95      32.581  25.506  22.079  1.00 18.32           N  
ATOM    487  CA  TRP A  95      33.107  24.559  23.060  1.00 20.75           C  
ATOM    488  C   TRP A  95      33.858  23.396  22.426  1.00 21.86           C  
ATOM    489  O   TRP A  95      33.580  22.997  21.294  1.00 23.08           O  
ATOM    490  CB  TRP A  95      31.982  23.947  23.906  1.00 17.37           C  
ATOM    491  CG  TRP A  95      31.240  24.888  24.792  1.00 19.01           C  
ATOM    492  CD1 TRP A  95      30.163  25.654  24.457  1.00 19.85           C  
ATOM    493  CD2 TRP A  95      31.488  25.129  26.183  1.00 18.75           C  
ATOM    494  NE1 TRP A  95      29.716  26.354  25.557  1.00 21.66           N  
ATOM    495  CE2 TRP A  95      30.514  26.052  26.627  1.00 19.97           C  
ATOM    496  CE3 TRP A  95      32.438  24.652  27.096  1.00 18.44           C  
ATOM    497  CZ2 TRP A  95      30.466  26.510  27.949  1.00 21.15           C  
ATOM    498  CZ3 TRP A  95      32.390  25.104  28.408  1.00 18.54           C  
ATOM    499  CH2 TRP A  95      31.408  26.026  28.822  1.00 21.52           C  
ATOM    500  N   SER A  96      34.803  22.842  23.174  1.00 21.92           N  
ATOM    501  CA  SER A  96      35.546  21.680  22.714  1.00 23.67           C  
ATOM    502  C   SER A  96      34.633  20.501  23.046  1.00 24.73           C  
ATOM    503  O   SER A  96      33.736  20.623  23.885  1.00 22.78           O  
ATOM    504  CB  SER A  96      36.867  21.542  23.470  1.00 22.62           C  
ATOM    505  OG  SER A  96      36.639  21.423  24.863  1.00 24.09           O  
ATOM    506  N   SER A  97      34.856  19.369  22.390  1.00 26.21           N  
ATOM    507  CA  SER A  97      34.042  18.175  22.612  1.00 29.59           C  
ATOM    508  C   SER A  97      33.941  17.713  24.069  1.00 29.54           C  
ATOM    509  O   SER A  97      32.971  17.054  24.443  1.00 29.18           O  
ATOM    510  CB  SER A  97      34.574  17.020  21.757  1.00 30.35           C  
ATOM    511  OG  SER A  97      34.554  17.361  20.382  1.00 34.91           O  
ATOM    512  N   ASP A  98      34.928  18.054  24.893  1.00 30.58           N  
ATOM    513  CA  ASP A  98      34.912  17.628  26.289  1.00 32.88           C  
ATOM    514  C   ASP A  98      34.456  18.711  27.270  1.00 32.46           C  
ATOM    515  O   ASP A  98      34.660  18.587  28.476  1.00 33.85           O  
ATOM    516  CB  ASP A  98      36.298  17.112  26.689  1.00 33.81           C  
ATOM    517  CG  ASP A  98      37.299  18.225  26.902  1.00 35.43           C  
ATOM    518  OD1 ASP A  98      37.032  19.357  26.456  1.00 37.15           O  
ATOM    519  OD2 ASP A  98      38.358  17.968  27.513  1.00 36.65           O  
ATOM    520  N   SER A  99      33.844  19.770  26.754  1.00 30.75           N  
ATOM    521  CA  SER A  99      33.350  20.852  27.602  1.00 28.90           C  
ATOM    522  C   SER A  99      34.437  21.490  28.459  1.00 27.21           C  
ATOM    523  O   SER A  99      34.138  22.255  29.373  1.00 27.38           O  
ATOM    524  CB  SER A  99      32.242  20.332  28.523  1.00 27.47           C  
ATOM    525  OG  SER A  99      31.171  19.767  27.787  1.00 28.99           O  
ATOM    526  N   ASN A 100      35.694  21.186  28.168  1.00 26.99           N  
ATOM    527  CA  ASN A 100      36.793  21.736  28.953  1.00 28.26           C  
ATOM    528  C   ASN A 100      37.413  22.989  28.351  1.00 27.88           C  
ATOM    529  O   ASN A 100      37.901  23.855  29.076  1.00 28.41           O  
ATOM    530  CB  ASN A 100      37.869  20.669  29.154  1.00 30.93           C  
ATOM    531  CG  ASN A 100      37.445  19.594  30.145  1.00 33.78           C  
ATOM    532  OD1 ASN A 100      38.012  18.504  30.172  1.00 37.23           O  
ATOM    533  ND2 ASN A 100      36.448  19.903  30.968  1.00 33.42           N  
ATOM    534  N   LEU A 101      37.382  23.088  27.027  1.00 27.30           N  
ATOM    535  CA  LEU A 101      37.961  24.234  26.345  1.00 25.95           C  
ATOM    536  C   LEU A 101      36.926  25.130  25.682  1.00 25.22           C  
ATOM    537  O   LEU A 101      35.792  24.719  25.428  1.00 25.58           O  
ATOM    538  CB  LEU A 101      38.970  23.764  25.294  1.00 26.31           C  
ATOM    539  CG  LEU A 101      40.206  23.029  25.815  1.00 26.62           C  
ATOM    540  CD1 LEU A 101      41.126  22.699  24.650  1.00 25.30           C  
ATOM    541  CD2 LEU A 101      40.932  23.900  26.829  1.00 28.03           C  
ATOM    542  N   LEU A 102      37.344  26.354  25.389  1.00 23.00           N  
ATOM    543  CA  LEU A 102      36.485  27.334  24.756  1.00 22.50           C  
ATOM    544  C   LEU A 102      37.353  28.141  23.812  1.00 22.14           C  
ATOM    545  O   LEU A 102      38.492  28.474  24.143  1.00 23.38           O  
ATOM    546  CB  LEU A 102      35.879  28.240  25.828  1.00 25.64           C  
ATOM    547  CG  LEU A 102      34.469  28.812  25.672  1.00 29.30           C  
ATOM    548  CD1 LEU A 102      33.497  27.763  25.149  1.00 30.15           C  
ATOM    549  CD2 LEU A 102      34.012  29.315  27.032  1.00 29.93           C  
ATOM    550  N   VAL A 103      36.834  28.426  22.623  1.00 20.76           N  
ATOM    551  CA  VAL A 103      37.563  29.221  21.642  1.00 19.76           C  
ATOM    552  C   VAL A 103      36.725  30.454  21.305  1.00 18.90           C  
ATOM    553  O   VAL A 103      35.504  30.371  21.191  1.00 20.62           O  
ATOM    554  CB  VAL A 103      37.847  28.411  20.344  1.00 20.30           C  
ATOM    555  CG1 VAL A 103      36.545  28.024  19.665  1.00 18.32           C  
ATOM    556  CG2 VAL A 103      38.730  29.234  19.398  1.00 19.29           C  
ATOM    557  N   SER A 104      37.373  31.602  21.154  1.00 17.33           N  
ATOM    558  CA  SER A 104      36.640  32.811  20.836  1.00 16.67           C  
ATOM    559  C   SER A 104      37.219  33.527  19.630  1.00 18.07           C  
ATOM    560  O   SER A 104      38.422  33.438  19.365  1.00 18.11           O  
ATOM    561  CB  SER A 104      36.636  33.747  22.044  1.00 16.01           C  
ATOM    562  OG  SER A 104      37.946  33.923  22.536  1.00 15.64           O  
ATOM    563  N   ALA A 105      36.348  34.222  18.899  1.00 17.17           N  
ATOM    564  CA  ALA A 105      36.735  34.978  17.712  1.00 16.09           C  
ATOM    565  C   ALA A 105      36.465  36.456  18.002  1.00 16.74           C  
ATOM    566  O   ALA A 105      35.333  36.845  18.322  1.00 17.54           O  
ATOM    567  CB  ALA A 105      35.932  34.504  16.505  1.00 15.70           C  
ATOM    568  N   SER A 106      37.500  37.280  17.878  1.00 15.52           N  
ATOM    569  CA  SER A 106      37.376  38.698  18.193  1.00 14.20           C  
ATOM    570  C   SER A 106      37.787  39.695  17.105  1.00 15.66           C  
ATOM    571  O   SER A 106      38.514  39.356  16.166  1.00 14.13           O  
ATOM    572  CB  SER A 106      38.184  38.984  19.460  1.00 15.50           C  
ATOM    573  OG  SER A 106      38.337  40.376  19.669  1.00 14.79           O  
ATOM    574  N   ASP A 107      37.312  40.931  17.248  1.00 12.69           N  
ATOM    575  CA  ASP A 107      37.659  41.996  16.317  1.00 14.61           C  
ATOM    576  C   ASP A 107      39.149  42.350  16.422  1.00 15.59           C  
ATOM    577  O   ASP A 107      39.701  42.982  15.520  1.00 14.32           O  
ATOM    578  CB  ASP A 107      36.846  43.259  16.606  1.00 16.65           C  
ATOM    579  CG  ASP A 107      35.422  43.186  16.081  1.00 18.67           C  
ATOM    580  OD1 ASP A 107      35.054  42.188  15.426  1.00 16.76           O  
ATOM    581  OD2 ASP A 107      34.669  44.151  16.326  1.00 21.17           O  
ATOM    582  N   ASP A 108      39.795  41.960  17.524  1.00 15.86           N  
ATOM    583  CA  ASP A 108      41.212  42.265  17.701  1.00 16.63           C  
ATOM    584  C   ASP A 108      42.075  41.441  16.755  1.00 17.25           C  
ATOM    585  O   ASP A 108      43.296  41.436  16.861  1.00 17.81           O  
ATOM    586  CB  ASP A 108      41.665  42.033  19.153  1.00 17.25           C  
ATOM    587  CG  ASP A 108      41.532  40.584  19.607  1.00 20.34           C  
ATOM    588  OD1 ASP A 108      41.563  39.663  18.762  1.00 22.18           O  
ATOM    589  OD2 ASP A 108      41.413  40.368  20.832  1.00 18.97           O  
ATOM    590  N   LYS A 109      41.411  40.738  15.841  1.00 17.42           N  
ATOM    591  CA  LYS A 109      42.051  39.904  14.834  1.00 16.15           C  
ATOM    592  C   LYS A 109      42.593  38.566  15.315  1.00 15.57           C  
ATOM    593  O   LYS A 109      43.271  37.863  14.568  1.00 14.11           O  
ATOM    594  CB  LYS A 109      43.150  40.697  14.129  1.00 17.64           C  
ATOM    595  CG  LYS A 109      42.612  41.987  13.527  1.00 21.02           C  
ATOM    596  CD  LYS A 109      43.520  42.565  12.458  1.00 25.70           C  
ATOM    597  CE  LYS A 109      44.801  43.121  13.039  1.00 27.17           C  
ATOM    598  NZ  LYS A 109      45.643  43.682  11.950  1.00 30.32           N  
ATOM    599  N   THR A 110      42.283  38.196  16.550  1.00 13.47           N  
ATOM    600  CA  THR A 110      42.762  36.921  17.057  1.00 14.71           C  
ATOM    601  C   THR A 110      41.618  36.048  17.542  1.00 14.76           C  
ATOM    602  O   THR A 110      40.472  36.488  17.653  1.00 15.63           O  
ATOM    603  CB  THR A 110      43.728  37.088  18.261  1.00 14.10           C  
ATOM    604  OG1 THR A 110      42.962  37.265  19.459  1.00 13.71           O  
ATOM    605  CG2 THR A 110      44.648  38.294  18.069  1.00 16.04           C  
ATOM    606  N   LEU A 111      41.952  34.797  17.815  1.00 14.30           N  
ATOM    607  CA  LEU A 111      41.015  33.844  18.376  1.00 16.88           C  
ATOM    608  C   LEU A 111      41.751  33.451  19.646  1.00 16.31           C  
ATOM    609  O   LEU A 111      42.975  33.536  19.691  1.00 18.69           O  
ATOM    610  CB  LEU A 111      40.846  32.613  17.480  1.00 16.13           C  
ATOM    611  CG  LEU A 111      40.059  32.735  16.171  1.00 19.09           C  
ATOM    612  CD1 LEU A 111      41.009  32.615  14.989  1.00 18.04           C  
ATOM    613  CD2 LEU A 111      39.004  31.626  16.096  1.00 17.62           C  
ATOM    614  N   LYS A 112      41.034  33.051  20.684  1.00 18.01           N  
ATOM    615  CA  LYS A 112      41.703  32.628  21.906  1.00 18.34           C  
ATOM    616  C   LYS A 112      41.150  31.310  22.428  1.00 19.21           C  
ATOM    617  O   LYS A 112      39.935  31.098  22.449  1.00 20.22           O  
ATOM    618  CB  LYS A 112      41.584  33.699  22.992  1.00 18.25           C  
ATOM    619  CG  LYS A 112      42.545  34.860  22.821  1.00 16.74           C  
ATOM    620  CD  LYS A 112      42.318  35.897  23.905  1.00 20.04           C  
ATOM    621  CE  LYS A 112      43.175  37.141  23.687  1.00 20.96           C  
ATOM    622  NZ  LYS A 112      44.620  36.866  23.891  1.00 21.08           N  
ATOM    623  N   ILE A 113      42.051  30.417  22.824  1.00 18.49           N  
ATOM    624  CA  ILE A 113      41.656  29.127  23.373  1.00 19.41           C  
ATOM    625  C   ILE A 113      41.705  29.293  24.893  1.00 21.54           C  
ATOM    626  O   ILE A 113      42.731  29.696  25.446  1.00 21.60           O  
ATOM    627  CB  ILE A 113      42.627  28.001  22.924  1.00 17.71           C  
ATOM    628  CG1 ILE A 113      42.676  27.934  21.392  1.00 17.09           C  
ATOM    629  CG2 ILE A 113      42.170  26.662  23.489  1.00 14.00           C  
ATOM    630  CD1 ILE A 113      43.629  26.887  20.848  1.00 14.63           C  
ATOM    631  N   TRP A 114      40.599  28.995  25.568  1.00 22.35           N  
ATOM    632  CA  TRP A 114      40.545  29.155  27.017  1.00 24.07           C  
ATOM    633  C   TRP A 114      40.295  27.866  27.788  1.00 25.68           C  
ATOM    634  O   TRP A 114      39.532  27.003  27.353  1.00 25.62           O  
ATOM    635  CB  TRP A 114      39.429  30.132  27.427  1.00 23.45           C  
ATOM    636  CG  TRP A 114      39.344  31.406  26.652  1.00 23.45           C  
ATOM    637  CD1 TRP A 114      38.706  31.603  25.461  1.00 22.99           C  
ATOM    638  CD2 TRP A 114      39.897  32.670  27.025  1.00 23.50           C  
ATOM    639  NE1 TRP A 114      38.825  32.910  25.071  1.00 22.29           N  
ATOM    640  CE2 TRP A 114      39.554  33.588  26.010  1.00 24.22           C  
ATOM    641  CE3 TRP A 114      40.652  33.116  28.117  1.00 24.65           C  
ATOM    642  CZ2 TRP A 114      39.939  34.929  26.058  1.00 24.28           C  
ATOM    643  CZ3 TRP A 114      41.035  34.448  28.163  1.00 22.81           C  
ATOM    644  CH2 TRP A 114      40.678  35.338  27.139  1.00 25.57           C  
ATOM    645  N   ASP A 115      40.934  27.754  28.948  1.00 27.58           N  
ATOM    646  CA  ASP A 115      40.720  26.612  29.826  1.00 29.50           C  
ATOM    647  C   ASP A 115      39.499  27.071  30.633  1.00 29.95           C  
ATOM    648  O   ASP A 115      39.590  27.996  31.437  1.00 31.26           O  
ATOM    649  CB  ASP A 115      41.918  26.417  30.759  1.00 31.28           C  
ATOM    650  CG  ASP A 115      41.750  25.220  31.691  1.00 32.15           C  
ATOM    651  OD1 ASP A 115      40.650  25.053  32.257  1.00 33.07           O  
ATOM    652  OD2 ASP A 115      42.723  24.459  31.872  1.00 34.29           O  
ATOM    653  N   VAL A 116      38.357  26.438  30.403  1.00 29.50           N  
ATOM    654  CA  VAL A 116      37.127  26.815  31.081  1.00 30.94           C  
ATOM    655  C   VAL A 116      37.152  26.864  32.614  1.00 31.59           C  
ATOM    656  O   VAL A 116      36.585  27.784  33.209  1.00 30.65           O  
ATOM    657  CB  VAL A 116      35.972  25.892  30.645  1.00 31.00           C  
ATOM    658  CG1 VAL A 116      34.690  26.275  31.364  1.00 33.04           C  
ATOM    659  CG2 VAL A 116      35.776  25.998  29.150  1.00 33.19           C  
ATOM    660  N   SER A 117      37.801  25.895  33.255  1.00 31.88           N  
ATOM    661  CA  SER A 117      37.828  25.855  34.718  1.00 33.01           C  
ATOM    662  C   SER A 117      38.717  26.891  35.399  1.00 31.96           C  
ATOM    663  O   SER A 117      38.393  27.356  36.487  1.00 33.44           O  
ATOM    664  CB  SER A 117      38.230  24.459  35.208  1.00 35.00           C  
ATOM    665  OG  SER A 117      39.630  24.260  35.097  1.00 39.59           O  
ATOM    666  N   SER A 118      39.837  27.241  34.779  1.00 32.05           N  
ATOM    667  CA  SER A 118      40.741  28.227  35.369  1.00 31.18           C  
ATOM    668  C   SER A 118      40.464  29.598  34.780  1.00 31.10           C  
ATOM    669  O   SER A 118      40.806  30.622  35.371  1.00 29.16           O  
ATOM    670  CB  SER A 118      42.193  27.845  35.103  1.00 31.77           C  
ATOM    671  OG  SER A 118      42.457  27.837  33.714  1.00 34.30           O  
ATOM    672  N   GLY A 119      39.845  29.601  33.603  1.00 30.89           N  
ATOM    673  CA  GLY A 119      39.512  30.844  32.934  1.00 30.31           C  
ATOM    674  C   GLY A 119      40.684  31.545  32.272  1.00 30.11           C  
ATOM    675  O   GLY A 119      40.525  32.637  31.729  1.00 30.16           O  
ATOM    676  N   LYS A 120      41.863  30.938  32.303  1.00 30.28           N  
ATOM    677  CA  LYS A 120      43.009  31.581  31.685  1.00 31.50           C  
ATOM    678  C   LYS A 120      43.212  31.185  30.227  1.00 30.56           C  
ATOM    679  O   LYS A 120      42.841  30.088  29.806  1.00 30.62           O  
ATOM    680  CB  LYS A 120      44.278  31.320  32.511  1.00 35.14           C  
ATOM    681  CG  LYS A 120      44.553  29.870  32.845  1.00 39.53           C  
ATOM    682  CD  LYS A 120      45.612  29.750  33.945  1.00 42.91           C  
ATOM    683  CE  LYS A 120      46.948  30.364  33.528  1.00 45.85           C  
ATOM    684  NZ  LYS A 120      47.991  30.232  34.594  1.00 47.67           N  
ATOM    685  N   CYS A 121      43.792  32.104  29.459  1.00 29.55           N  
ATOM    686  CA  CYS A 121      44.048  31.910  28.037  1.00 28.20           C  
ATOM    687  C   CYS A 121      45.228  30.996  27.752  1.00 27.82           C  
ATOM    688  O   CYS A 121      46.379  31.362  27.978  1.00 28.85           O  
ATOM    689  CB  CYS A 121      44.293  33.259  27.365  1.00 27.44           C  
ATOM    690  SG  CYS A 121      44.880  33.121  25.668  1.00 29.91           S  
ATOM    691  N   LEU A 122      44.935  29.808  27.238  1.00 26.76           N  
ATOM    692  CA  LEU A 122      45.969  28.839  26.917  1.00 25.41           C  
ATOM    693  C   LEU A 122      46.774  29.254  25.691  1.00 25.48           C  
ATOM    694  O   LEU A 122      47.982  29.048  25.640  1.00 26.54           O  
ATOM    695  CB  LEU A 122      45.340  27.469  26.679  1.00 24.36           C  
ATOM    696  CG  LEU A 122      44.577  26.890  27.865  1.00 22.46           C  
ATOM    697  CD1 LEU A 122      43.987  25.562  27.464  1.00 25.88           C  
ATOM    698  CD2 LEU A 122      45.508  26.723  29.054  1.00 21.74           C  
ATOM    699  N   LYS A 123      46.098  29.835  24.703  1.00 25.41           N  
ATOM    700  CA  LYS A 123      46.758  30.274  23.477  1.00 25.60           C  
ATOM    701  C   LYS A 123      46.018  31.383  22.736  1.00 25.43           C  
ATOM    702  O   LYS A 123      44.798  31.544  22.853  1.00 25.40           O  
ATOM    703  CB  LYS A 123      46.951  29.099  22.509  1.00 28.24           C  
ATOM    704  CG  LYS A 123      47.888  28.027  23.010  1.00 30.73           C  
ATOM    705  CD  LYS A 123      48.694  27.437  21.876  1.00 34.25           C  
ATOM    706  CE  LYS A 123      50.174  27.394  22.235  1.00 34.83           C  
ATOM    707  NZ  LYS A 123      50.424  26.594  23.464  1.00 37.64           N  
ATOM    708  N   THR A 124      46.782  32.144  21.964  1.00 23.59           N  
ATOM    709  CA  THR A 124      46.246  33.227  21.162  1.00 23.22           C  
ATOM    710  C   THR A 124      46.595  32.920  19.711  1.00 22.14           C  
ATOM    711  O   THR A 124      47.765  32.894  19.342  1.00 22.85           O  
ATOM    712  CB  THR A 124      46.864  34.573  21.573  1.00 22.24           C  
ATOM    713  OG1 THR A 124      46.439  34.901  22.902  1.00 22.77           O  
ATOM    714  CG2 THR A 124      46.428  35.667  20.620  1.00 23.60           C  
ATOM    715  N   LEU A 125      45.575  32.671  18.897  1.00 20.49           N  
ATOM    716  CA  LEU A 125      45.785  32.348  17.491  1.00 19.57           C  
ATOM    717  C   LEU A 125      45.867  33.619  16.658  1.00 19.89           C  
ATOM    718  O   LEU A 125      44.896  34.370  16.553  1.00 19.68           O  
ATOM    719  CB  LEU A 125      44.650  31.451  16.990  1.00 20.95           C  
ATOM    720  CG  LEU A 125      44.241  30.318  17.946  1.00 21.21           C  
ATOM    721  CD1 LEU A 125      43.263  29.397  17.246  1.00 20.63           C  
ATOM    722  CD2 LEU A 125      45.464  29.525  18.397  1.00 23.73           C  
ATOM    723  N   LYS A 126      47.039  33.849  16.073  1.00 19.40           N  
ATOM    724  CA  LYS A 126      47.285  35.037  15.269  1.00 19.95           C  
ATOM    725  C   LYS A 126      47.564  34.698  13.810  1.00 19.43           C  
ATOM    726  O   LYS A 126      48.253  33.723  13.507  1.00 19.04           O  
ATOM    727  CB  LYS A 126      48.467  35.811  15.851  1.00 22.63           C  
ATOM    728  CG  LYS A 126      48.296  36.180  17.311  1.00 27.26           C  
ATOM    729  CD  LYS A 126      49.511  36.932  17.825  1.00 31.97           C  
ATOM    730  CE  LYS A 126      49.312  37.416  19.258  1.00 35.09           C  
ATOM    731  NZ  LYS A 126      50.521  38.127  19.780  1.00 38.50           N  
ATOM    732  N   GLY A 127      47.031  35.517  12.911  1.00 18.41           N  
ATOM    733  CA  GLY A 127      47.216  35.286  11.492  1.00 17.80           C  
ATOM    734  C   GLY A 127      46.227  36.063  10.647  1.00 19.28           C  
ATOM    735  O   GLY A 127      46.587  36.594   9.592  1.00 19.60           O  
ATOM    736  N   HIS A 128      44.976  36.133  11.099  1.00 18.84           N  
ATOM    737  CA  HIS A 128      43.952  36.869  10.358  1.00 17.65           C  
ATOM    738  C   HIS A 128      44.331  38.337  10.288  1.00 16.21           C  
ATOM    739  O   HIS A 128      44.870  38.887  11.246  1.00 15.41           O  
ATOM    740  CB  HIS A 128      42.582  36.717  11.024  1.00 16.90           C  
ATOM    741  CG  HIS A 128      41.912  35.411  10.730  1.00 17.33           C  
ATOM    742  ND1 HIS A 128      41.570  35.022   9.452  1.00 16.47           N  
ATOM    743  CD2 HIS A 128      41.518  34.406  11.548  1.00 15.03           C  
ATOM    744  CE1 HIS A 128      40.994  33.834   9.495  1.00 15.55           C  
ATOM    745  NE2 HIS A 128      40.951  33.438  10.755  1.00 17.34           N  
ATOM    746  N   SER A 129      44.046  38.964   9.151  1.00 15.85           N  
ATOM    747  CA  SER A 129      44.377  40.367   8.950  1.00 15.91           C  
ATOM    748  C   SER A 129      43.194  41.311   9.143  1.00 16.09           C  
ATOM    749  O   SER A 129      43.248  42.474   8.739  1.00 16.20           O  
ATOM    750  CB  SER A 129      44.974  40.566   7.558  1.00 14.50           C  
ATOM    751  OG  SER A 129      44.060  40.197   6.555  1.00 16.85           O  
ATOM    752  N   ASN A 130      42.128  40.805   9.755  1.00 15.16           N  
ATOM    753  CA  ASN A 130      40.941  41.610  10.036  1.00 14.52           C  
ATOM    754  C   ASN A 130      40.106  40.881  11.094  1.00 13.25           C  
ATOM    755  O   ASN A 130      40.539  39.869  11.641  1.00 10.55           O  
ATOM    756  CB  ASN A 130      40.116  41.828   8.767  1.00 13.63           C  
ATOM    757  CG  ASN A 130      39.347  43.138   8.794  1.00 17.39           C  
ATOM    758  OD1 ASN A 130      38.887  43.586   9.844  1.00 17.99           O  
ATOM    759  ND2 ASN A 130      39.192  43.753   7.628  1.00 18.51           N  
ATOM    760  N   TYR A 131      38.917  41.391  11.383  1.00 13.66           N  
ATOM    761  CA  TYR A 131      38.067  40.775  12.398  1.00 15.44           C  
ATOM    762  C   TYR A 131      37.854  39.290  12.184  1.00 13.58           C  
ATOM    763  O   TYR A 131      37.661  38.850  11.058  1.00 15.11           O  
ATOM    764  CB  TYR A 131      36.685  41.433  12.427  1.00 15.02           C  
ATOM    765  CG  TYR A 131      36.721  42.930  12.381  1.00 21.01           C  
ATOM    766  CD1 TYR A 131      37.632  43.646  13.160  1.00 18.13           C  
ATOM    767  CD2 TYR A 131      35.856  43.640  11.549  1.00 24.25           C  
ATOM    768  CE1 TYR A 131      37.685  45.026  13.109  1.00 21.82           C  
ATOM    769  CE2 TYR A 131      35.900  45.027  11.491  1.00 26.35           C  
ATOM    770  CZ  TYR A 131      36.819  45.712  12.273  1.00 26.33           C  
ATOM    771  OH  TYR A 131      36.873  47.086  12.217  1.00 29.94           O  
ATOM    772  N   VAL A 132      37.911  38.525  13.269  1.00 14.10           N  
ATOM    773  CA  VAL A 132      37.630  37.098  13.199  1.00 14.34           C  
ATOM    774  C   VAL A 132      36.168  37.089  13.611  1.00 15.82           C  
ATOM    775  O   VAL A 132      35.807  37.603  14.674  1.00 14.37           O  
ATOM    776  CB  VAL A 132      38.438  36.279  14.196  1.00 13.21           C  
ATOM    777  CG1 VAL A 132      38.203  34.810  13.917  1.00 12.78           C  
ATOM    778  CG2 VAL A 132      39.931  36.618  14.080  1.00 11.85           C  
ATOM    779  N   PHE A 133      35.330  36.509  12.765  1.00 15.65           N  
ATOM    780  CA  PHE A 133      33.893  36.522  12.990  1.00 15.84           C  
ATOM    781  C   PHE A 133      33.257  35.245  13.532  1.00 15.81           C  
ATOM    782  O   PHE A 133      32.249  35.295  14.237  1.00 15.05           O  
ATOM    783  CB  PHE A 133      33.231  36.871  11.661  1.00 15.91           C  
ATOM    784  CG  PHE A 133      31.878  37.489  11.790  1.00 15.16           C  
ATOM    785  CD1 PHE A 133      31.744  38.813  12.192  1.00 14.71           C  
ATOM    786  CD2 PHE A 133      30.741  36.769  11.444  1.00 17.79           C  
ATOM    787  CE1 PHE A 133      30.492  39.427  12.240  1.00 15.11           C  
ATOM    788  CE2 PHE A 133      29.470  37.367  11.486  1.00 17.87           C  
ATOM    789  CZ  PHE A 133      29.350  38.701  11.882  1.00 18.14           C  
ATOM    790  N   CYS A 134      33.844  34.104  13.204  1.00 14.51           N  
ATOM    791  CA  CYS A 134      33.276  32.836  13.602  1.00 14.53           C  
ATOM    792  C   CYS A 134      34.328  31.783  13.877  1.00 15.55           C  
ATOM    793  O   CYS A 134      35.435  31.850  13.344  1.00 15.58           O  
ATOM    794  CB  CYS A 134      32.346  32.354  12.488  1.00 15.35           C  
ATOM    795  SG  CYS A 134      33.064  32.532  10.820  1.00 14.62           S  
ATOM    796  N   CYS A 135      33.967  30.794  14.692  1.00 14.97           N  
ATOM    797  CA  CYS A 135      34.890  29.726  15.046  1.00 17.25           C  
ATOM    798  C   CYS A 135      34.174  28.453  15.489  1.00 18.60           C  
ATOM    799  O   CYS A 135      32.992  28.479  15.828  1.00 19.66           O  
ATOM    800  CB  CYS A 135      35.831  30.213  16.152  1.00 16.98           C  
ATOM    801  SG  CYS A 135      34.993  30.911  17.595  1.00 15.53           S  
ATOM    802  N   ASN A 136      34.910  27.344  15.480  1.00 20.17           N  
ATOM    803  CA  ASN A 136      34.392  26.036  15.879  1.00 18.93           C  
ATOM    804  C   ASN A 136      35.494  24.984  15.968  1.00 17.91           C  
ATOM    805  O   ASN A 136      36.443  25.006  15.196  1.00 19.25           O  
ATOM    806  CB  ASN A 136      33.353  25.537  14.875  1.00 19.31           C  
ATOM    807  CG  ASN A 136      31.937  25.744  15.348  1.00 20.77           C  
ATOM    808  OD1 ASN A 136      31.617  25.485  16.508  1.00 21.70           O  
ATOM    809  ND2 ASN A 136      31.072  26.199  14.448  1.00 19.02           N  
ATOM    810  N   PHE A 137      35.356  24.061  16.913  1.00 18.09           N  
ATOM    811  CA  PHE A 137      36.306  22.960  17.076  1.00 16.36           C  
ATOM    812  C   PHE A 137      35.753  21.854  16.186  1.00 16.77           C  
ATOM    813  O   PHE A 137      34.560  21.861  15.877  1.00 14.44           O  
ATOM    814  CB  PHE A 137      36.285  22.423  18.505  1.00 14.59           C  
ATOM    815  CG  PHE A 137      37.063  23.239  19.495  1.00 15.21           C  
ATOM    816  CD1 PHE A 137      38.429  23.027  19.670  1.00 14.49           C  
ATOM    817  CD2 PHE A 137      36.415  24.161  20.315  1.00 12.30           C  
ATOM    818  CE1 PHE A 137      39.137  23.715  20.662  1.00 13.97           C  
ATOM    819  CE2 PHE A 137      37.112  24.853  21.305  1.00 13.49           C  
ATOM    820  CZ  PHE A 137      38.474  24.628  21.481  1.00 12.78           C  
ATOM    821  N   ASN A 138      36.599  20.914  15.770  1.00 15.68           N  
ATOM    822  CA  ASN A 138      36.103  19.788  14.988  1.00 14.69           C  
ATOM    823  C   ASN A 138      35.699  18.768  16.054  1.00 14.59           C  
ATOM    824  O   ASN A 138      36.008  18.962  17.234  1.00 16.02           O  
ATOM    825  CB  ASN A 138      37.179  19.240  14.038  1.00 15.61           C  
ATOM    826  CG  ASN A 138      38.475  18.872  14.742  1.00 15.05           C  
ATOM    827  OD1 ASN A 138      38.656  19.142  15.930  1.00 12.84           O  
ATOM    828  ND2 ASN A 138      39.391  18.258  13.995  1.00 13.07           N  
ATOM    829  N   PRO A 139      34.997  17.686  15.676  1.00 14.51           N  
ATOM    830  CA  PRO A 139      34.600  16.715  16.704  1.00 15.32           C  
ATOM    831  C   PRO A 139      35.761  16.182  17.535  1.00 17.90           C  
ATOM    832  O   PRO A 139      35.612  15.914  18.723  1.00 18.87           O  
ATOM    833  CB  PRO A 139      33.913  15.614  15.894  1.00 13.70           C  
ATOM    834  CG  PRO A 139      33.368  16.356  14.701  1.00 13.19           C  
ATOM    835  CD  PRO A 139      34.531  17.256  14.345  1.00 12.02           C  
ATOM    836  N   GLN A 140      36.916  16.025  16.899  1.00 19.91           N  
ATOM    837  CA  GLN A 140      38.102  15.519  17.576  1.00 21.21           C  
ATOM    838  C   GLN A 140      38.672  16.571  18.526  1.00 22.37           C  
ATOM    839  O   GLN A 140      39.434  16.249  19.440  1.00 22.86           O  
ATOM    840  CB  GLN A 140      39.162  15.117  16.549  1.00 21.45           C  
ATOM    841  CG  GLN A 140      38.671  14.109  15.526  1.00 20.30           C  
ATOM    842  CD  GLN A 140      38.163  14.748  14.250  1.00 23.43           C  
ATOM    843  OE1 GLN A 140      38.754  14.573  13.188  1.00 27.70           O  
ATOM    844  NE2 GLN A 140      37.069  15.498  14.346  1.00 21.14           N  
ATOM    845  N   SER A 141      38.289  17.824  18.297  1.00 22.11           N  
ATOM    846  CA  SER A 141      38.724  18.948  19.112  1.00 21.54           C  
ATOM    847  C   SER A 141      40.232  19.145  19.147  1.00 22.38           C  
ATOM    848  O   SER A 141      40.785  19.613  20.143  1.00 23.79           O  
ATOM    849  CB  SER A 141      38.184  18.805  20.535  1.00 21.98           C  
ATOM    850  OG  SER A 141      36.783  19.030  20.556  1.00 24.18           O  
ATOM    851  N   ASN A 142      40.896  18.786  18.055  1.00 22.98           N  
ATOM    852  CA  ASN A 142      42.338  18.963  17.951  1.00 23.11           C  
ATOM    853  C   ASN A 142      42.573  20.055  16.915  1.00 21.90           C  
ATOM    854  O   ASN A 142      43.706  20.465  16.669  1.00 24.47           O  
ATOM    855  CB  ASN A 142      43.017  17.667  17.504  1.00 24.22           C  
ATOM    856  CG  ASN A 142      42.631  17.266  16.099  1.00 26.61           C  
ATOM    857  OD1 ASN A 142      41.452  17.131  15.786  1.00 29.50           O  
ATOM    858  ND2 ASN A 142      43.628  17.073  15.241  1.00 28.90           N  
ATOM    859  N   LEU A 143      41.485  20.515  16.304  1.00 19.40           N  
ATOM    860  CA  LEU A 143      41.554  21.567  15.299  1.00 16.73           C  
ATOM    861  C   LEU A 143      40.517  22.641  15.564  1.00 15.26           C  
ATOM    862  O   LEU A 143      39.497  22.394  16.200  1.00 11.55           O  
ATOM    863  CB  LEU A 143      41.311  21.004  13.896  1.00 16.37           C  
ATOM    864  CG  LEU A 143      42.360  20.140  13.193  1.00 16.50           C  
ATOM    865  CD1 LEU A 143      41.836  19.747  11.826  1.00 17.00           C  
ATOM    866  CD2 LEU A 143      43.655  20.904  13.046  1.00 17.23           C  
ATOM    867  N   ILE A 144      40.794  23.837  15.063  1.00 15.24           N  
ATOM    868  CA  ILE A 144      39.882  24.964  15.180  1.00 14.44           C  
ATOM    869  C   ILE A 144      39.768  25.589  13.799  1.00 14.26           C  
ATOM    870  O   ILE A 144      40.767  25.727  13.089  1.00 15.06           O  
ATOM    871  CB  ILE A 144      40.400  26.017  16.187  1.00 15.06           C  
ATOM    872  CG1 ILE A 144      40.213  25.495  17.616  1.00 13.26           C  
ATOM    873  CG2 ILE A 144      39.660  27.337  15.994  1.00 12.47           C  
ATOM    874  CD1 ILE A 144      40.863  26.353  18.667  1.00 15.40           C  
ATOM    875  N   VAL A 145      38.546  25.928  13.402  1.00 13.41           N  
ATOM    876  CA  VAL A 145      38.309  26.548  12.108  1.00 10.73           C  
ATOM    877  C   VAL A 145      37.771  27.947  12.367  1.00 10.34           C  
ATOM    878  O   VAL A 145      36.922  28.145  13.236  1.00 11.06           O  
ATOM    879  CB  VAL A 145      37.290  25.735  11.259  1.00 10.66           C  
ATOM    880  CG1 VAL A 145      35.925  25.717  11.933  1.00  8.93           C  
ATOM    881  CG2 VAL A 145      37.189  26.327   9.866  1.00  8.00           C  
ATOM    882  N   SER A 146      38.276  28.924  11.622  1.00 11.71           N  
ATOM    883  CA  SER A 146      37.844  30.298  11.803  1.00 11.33           C  
ATOM    884  C   SER A 146      37.495  30.967  10.487  1.00 13.43           C  
ATOM    885  O   SER A 146      37.961  30.569   9.423  1.00 14.02           O  
ATOM    886  CB  SER A 146      38.928  31.105  12.515  1.00 10.65           C  
ATOM    887  OG  SER A 146      40.134  31.126  11.771  1.00 13.41           O  
ATOM    888  N   GLY A 147      36.652  31.986  10.584  1.00 13.73           N  
ATOM    889  CA  GLY A 147      36.228  32.739   9.423  1.00 13.60           C  
ATOM    890  C   GLY A 147      36.432  34.190   9.785  1.00 11.93           C  
ATOM    891  O   GLY A 147      36.124  34.598  10.899  1.00 13.02           O  
ATOM    892  N   SER A 148      36.942  34.976   8.851  1.00 10.99           N  
ATOM    893  CA  SER A 148      37.210  36.367   9.140  1.00 12.43           C  
ATOM    894  C   SER A 148      36.794  37.299   8.021  1.00 14.23           C  
ATOM    895  O   SER A 148      36.506  36.873   6.898  1.00 15.15           O  
ATOM    896  CB  SER A 148      38.713  36.540   9.437  1.00 13.62           C  
ATOM    897  OG  SER A 148      39.143  37.885   9.296  1.00 12.95           O  
ATOM    898  N   PHE A 149      36.751  38.583   8.352  1.00 14.35           N  
ATOM    899  CA  PHE A 149      36.418  39.613   7.387  1.00 14.13           C  
ATOM    900  C   PHE A 149      37.509  39.683   6.317  1.00 13.10           C  
ATOM    901  O   PHE A 149      37.299  40.271   5.259  1.00 11.34           O  
ATOM    902  CB  PHE A 149      36.306  40.961   8.086  1.00 15.35           C  
ATOM    903  CG  PHE A 149      34.907  41.357   8.403  1.00 18.62           C  
ATOM    904  CD1 PHE A 149      34.065  40.497   9.097  1.00 20.83           C  
ATOM    905  CD2 PHE A 149      34.424  42.596   8.007  1.00 20.23           C  
ATOM    906  CE1 PHE A 149      32.758  40.868   9.393  1.00 22.58           C  
ATOM    907  CE2 PHE A 149      33.117  42.976   8.298  1.00 23.22           C  
ATOM    908  CZ  PHE A 149      32.282  42.111   8.991  1.00 22.15           C  
ATOM    909  N   ASP A 150      38.673  39.089   6.587  1.00 12.18           N  
ATOM    910  CA  ASP A 150      39.745  39.115   5.596  1.00 13.02           C  
ATOM    911  C   ASP A 150      39.434  38.170   4.436  1.00 13.05           C  
ATOM    912  O   ASP A 150      40.250  37.981   3.543  1.00 14.48           O  
ATOM    913  CB  ASP A 150      41.107  38.776   6.215  1.00 10.95           C  
ATOM    914  CG  ASP A 150      41.169  37.383   6.795  1.00 13.81           C  
ATOM    915  OD1 ASP A 150      40.390  36.497   6.371  1.00 14.22           O  
ATOM    916  OD2 ASP A 150      42.025  37.168   7.674  1.00 14.77           O  
ATOM    917  N   GLU A 151      38.241  37.578   4.475  1.00 14.14           N  
ATOM    918  CA  GLU A 151      37.746  36.691   3.423  1.00 13.41           C  
ATOM    919  C   GLU A 151      38.347  35.290   3.392  1.00 13.68           C  
ATOM    920  O   GLU A 151      38.046  34.498   2.497  1.00 13.31           O  
ATOM    921  CB  GLU A 151      37.907  37.375   2.054  1.00 12.60           C  
ATOM    922  CG  GLU A 151      37.276  38.778   2.011  1.00 11.94           C  
ATOM    923  CD  GLU A 151      37.374  39.458   0.644  1.00 14.48           C  
ATOM    924  OE1 GLU A 151      37.945  38.861  -0.288  1.00 12.66           O  
ATOM    925  OE2 GLU A 151      36.874  40.596   0.500  1.00 14.89           O  
ATOM    926  N   SER A 152      39.165  34.970   4.386  1.00 13.48           N  
ATOM    927  CA  SER A 152      39.784  33.653   4.441  1.00 13.72           C  
ATOM    928  C   SER A 152      39.202  32.804   5.558  1.00 13.01           C  
ATOM    929  O   SER A 152      38.548  33.306   6.470  1.00 11.84           O  
ATOM    930  CB  SER A 152      41.296  33.771   4.677  1.00 13.23           C  
ATOM    931  OG  SER A 152      41.563  34.118   6.027  1.00 12.97           O  
ATOM    932  N   VAL A 153      39.454  31.506   5.455  1.00 12.51           N  
ATOM    933  CA  VAL A 153      39.048  30.529   6.447  1.00 13.41           C  
ATOM    934  C   VAL A 153      40.366  29.866   6.834  1.00 14.86           C  
ATOM    935  O   VAL A 153      41.100  29.399   5.967  1.00 17.48           O  
ATOM    936  CB  VAL A 153      38.114  29.452   5.852  1.00 12.61           C  
ATOM    937  CG1 VAL A 153      38.085  28.241   6.768  1.00  9.44           C  
ATOM    938  CG2 VAL A 153      36.699  30.013   5.685  1.00 12.93           C  
ATOM    939  N   ARG A 154      40.675  29.837   8.123  1.00 15.77           N  
ATOM    940  CA  ARG A 154      41.920  29.233   8.584  1.00 17.12           C  
ATOM    941  C   ARG A 154      41.658  28.049   9.501  1.00 18.56           C  
ATOM    942  O   ARG A 154      40.713  28.055  10.289  1.00 20.05           O  
ATOM    943  CB  ARG A 154      42.779  30.269   9.327  1.00 17.67           C  
ATOM    944  CG  ARG A 154      43.502  31.287   8.435  1.00 17.06           C  
ATOM    945  CD  ARG A 154      44.073  32.426   9.273  1.00 18.55           C  
ATOM    946  NE  ARG A 154      44.809  33.414   8.482  1.00 22.87           N  
ATOM    947  CZ  ARG A 154      46.123  33.382   8.260  1.00 22.45           C  
ATOM    948  NH1 ARG A 154      46.868  32.408   8.770  1.00 22.00           N  
ATOM    949  NH2 ARG A 154      46.699  34.329   7.530  1.00 20.16           N  
ATOM    950  N   ILE A 155      42.510  27.038   9.387  1.00 18.49           N  
ATOM    951  CA  ILE A 155      42.414  25.839  10.202  1.00 19.29           C  
ATOM    952  C   ILE A 155      43.620  25.848  11.140  1.00 20.13           C  
ATOM    953  O   ILE A 155      44.761  25.897  10.681  1.00 19.35           O  
ATOM    954  CB  ILE A 155      42.440  24.581   9.314  1.00 18.36           C  
ATOM    955  CG1 ILE A 155      41.246  24.606   8.356  1.00 19.78           C  
ATOM    956  CG2 ILE A 155      42.395  23.332  10.175  1.00 18.46           C  
ATOM    957  CD1 ILE A 155      41.327  23.577   7.242  1.00 18.49           C  
ATOM    958  N   TRP A 156      43.364  25.807  12.446  1.00 21.33           N  
ATOM    959  CA  TRP A 156      44.431  25.854  13.448  1.00 21.67           C  
ATOM    960  C   TRP A 156      44.598  24.595  14.287  1.00 21.23           C  
ATOM    961  O   TRP A 156      43.640  23.872  14.552  1.00 20.33           O  
ATOM    962  CB  TRP A 156      44.202  27.014  14.426  1.00 21.23           C  
ATOM    963  CG  TRP A 156      43.744  28.300  13.809  1.00 23.35           C  
ATOM    964  CD1 TRP A 156      42.517  28.563  13.261  1.00 22.61           C  
ATOM    965  CD2 TRP A 156      44.497  29.514  13.709  1.00 22.34           C  
ATOM    966  NE1 TRP A 156      42.462  29.868  12.832  1.00 23.64           N  
ATOM    967  CE2 TRP A 156      43.661  30.474  13.094  1.00 22.99           C  
ATOM    968  CE3 TRP A 156      45.796  29.885  14.077  1.00 22.22           C  
ATOM    969  CZ2 TRP A 156      44.086  31.784  12.840  1.00 23.34           C  
ATOM    970  CZ3 TRP A 156      46.219  31.187  13.825  1.00 20.23           C  
ATOM    971  CH2 TRP A 156      45.365  32.121  13.213  1.00 21.33           C  
ATOM    972  N   ASP A 157      45.830  24.363  14.726  1.00 23.27           N  
ATOM    973  CA  ASP A 157      46.142  23.226  15.581  1.00 22.44           C  
ATOM    974  C   ASP A 157      45.895  23.690  17.015  1.00 22.41           C  
ATOM    975  O   ASP A 157      46.491  24.666  17.474  1.00 21.40           O  
ATOM    976  CB  ASP A 157      47.605  22.818  15.426  1.00 25.03           C  
ATOM    977  CG  ASP A 157      47.931  21.534  16.172  1.00 28.38           C  
ATOM    978  OD1 ASP A 157      47.606  20.449  15.642  1.00 31.29           O  
ATOM    979  OD2 ASP A 157      48.493  21.608  17.290  1.00 28.81           O  
ATOM    980  N   VAL A 158      45.010  22.996  17.717  1.00 20.77           N  
ATOM    981  CA  VAL A 158      44.684  23.364  19.084  1.00 23.07           C  
ATOM    982  C   VAL A 158      45.871  23.268  20.044  1.00 25.34           C  
ATOM    983  O   VAL A 158      46.107  24.166  20.855  1.00 23.85           O  
ATOM    984  CB  VAL A 158      43.541  22.480  19.621  1.00 22.59           C  
ATOM    985  CG1 VAL A 158      43.325  22.750  21.106  1.00 21.70           C  
ATOM    986  CG2 VAL A 158      42.260  22.753  18.830  1.00 22.21           C  
ATOM    987  N   LYS A 159      46.611  22.172  19.946  1.00 27.14           N  
ATOM    988  CA  LYS A 159      47.742  21.929  20.826  1.00 29.05           C  
ATOM    989  C   LYS A 159      48.821  23.011  20.766  1.00 28.40           C  
ATOM    990  O   LYS A 159      49.235  23.534  21.800  1.00 28.42           O  
ATOM    991  CB  LYS A 159      48.355  20.558  20.514  1.00 31.66           C  
ATOM    992  CG  LYS A 159      49.193  19.969  21.647  1.00 38.03           C  
ATOM    993  CD  LYS A 159      48.318  19.574  22.843  1.00 43.06           C  
ATOM    994  CE  LYS A 159      49.156  19.038  24.010  1.00 45.88           C  
ATOM    995  NZ  LYS A 159      48.318  18.636  25.187  1.00 47.13           N  
ATOM    996  N   THR A 160      49.262  23.360  19.563  1.00 27.65           N  
ATOM    997  CA  THR A 160      50.315  24.357  19.405  1.00 27.64           C  
ATOM    998  C   THR A 160      49.845  25.786  19.172  1.00 26.73           C  
ATOM    999  O   THR A 160      50.598  26.734  19.389  1.00 26.73           O  
ATOM   1000  CB  THR A 160      51.245  23.991  18.245  1.00 29.01           C  
ATOM   1001  OG1 THR A 160      50.498  23.990  17.020  1.00 29.51           O  
ATOM   1002  CG2 THR A 160      51.857  22.614  18.474  1.00 29.40           C  
ATOM   1003  N   GLY A 161      48.608  25.945  18.723  1.00 25.65           N  
ATOM   1004  CA  GLY A 161      48.107  27.281  18.456  1.00 22.79           C  
ATOM   1005  C   GLY A 161      48.618  27.800  17.120  1.00 21.80           C  
ATOM   1006  O   GLY A 161      48.493  28.983  16.824  1.00 21.12           O  
ATOM   1007  N   MET A 162      49.197  26.917  16.309  1.00 20.22           N  
ATOM   1008  CA  MET A 162      49.712  27.311  15.005  1.00 21.04           C  
ATOM   1009  C   MET A 162      48.632  27.169  13.933  1.00 21.45           C  
ATOM   1010  O   MET A 162      47.715  26.362  14.061  1.00 20.86           O  
ATOM   1011  CB  MET A 162      50.921  26.448  14.615  1.00 23.18           C  
ATOM   1012  CG  MET A 162      52.198  26.663  15.450  1.00 26.33           C  
ATOM   1013  SD  MET A 162      52.880  28.347  15.371  1.00 25.91           S  
ATOM   1014  CE  MET A 162      52.221  29.021  16.891  1.00 25.86           C  
ATOM   1015  N   CYS A 163      48.750  27.969  12.880  1.00 21.88           N  
ATOM   1016  CA  CYS A 163      47.817  27.921  11.766  1.00 22.15           C  
ATOM   1017  C   CYS A 163      48.348  26.878  10.789  1.00 21.45           C  
ATOM   1018  O   CYS A 163      49.472  26.993  10.303  1.00 20.32           O  
ATOM   1019  CB  CYS A 163      47.737  29.285  11.076  1.00 21.13           C  
ATOM   1020  SG  CYS A 163      46.630  29.315   9.647  1.00 25.32           S  
ATOM   1021  N   LEU A 164      47.541  25.862  10.507  1.00 21.87           N  
ATOM   1022  CA  LEU A 164      47.947  24.793   9.600  1.00 23.13           C  
ATOM   1023  C   LEU A 164      47.578  25.092   8.152  1.00 24.80           C  
ATOM   1024  O   LEU A 164      48.286  24.683   7.232  1.00 25.73           O  
ATOM   1025  CB  LEU A 164      47.299  23.471  10.022  1.00 21.97           C  
ATOM   1026  CG  LEU A 164      47.489  22.997  11.466  1.00 22.67           C  
ATOM   1027  CD1 LEU A 164      46.694  21.719  11.692  1.00 24.15           C  
ATOM   1028  CD2 LEU A 164      48.966  22.756  11.744  1.00 21.73           C  
ATOM   1029  N   LYS A 165      46.472  25.806   7.952  1.00 24.66           N  
ATOM   1030  CA  LYS A 165      46.004  26.146   6.608  1.00 23.10           C  
ATOM   1031  C   LYS A 165      45.230  27.458   6.557  1.00 22.35           C  
ATOM   1032  O   LYS A 165      44.494  27.795   7.483  1.00 22.75           O  
ATOM   1033  CB  LYS A 165      45.077  25.057   6.059  1.00 23.62           C  
ATOM   1034  CG  LYS A 165      45.703  23.704   5.772  1.00 24.32           C  
ATOM   1035  CD  LYS A 165      44.652  22.775   5.161  1.00 23.38           C  
ATOM   1036  CE  LYS A 165      45.231  21.418   4.765  1.00 27.08           C  
ATOM   1037  NZ  LYS A 165      45.601  20.575   5.941  1.00 27.71           N  
ATOM   1038  N   THR A 166      45.403  28.183   5.458  1.00 21.02           N  
ATOM   1039  CA  THR A 166      44.694  29.430   5.214  1.00 19.43           C  
ATOM   1040  C   THR A 166      44.008  29.226   3.871  1.00 18.65           C  
ATOM   1041  O   THR A 166      44.669  29.158   2.842  1.00 19.85           O  
ATOM   1042  CB  THR A 166      45.643  30.634   5.092  1.00 18.47           C  
ATOM   1043  OG1 THR A 166      46.323  30.845   6.336  1.00 19.76           O  
ATOM   1044  CG2 THR A 166      44.855  31.886   4.733  1.00 15.43           C  
ATOM   1045  N   LEU A 167      42.685  29.116   3.878  1.00 18.90           N  
ATOM   1046  CA  LEU A 167      41.948  28.903   2.638  1.00 19.13           C  
ATOM   1047  C   LEU A 167      41.411  30.206   2.055  1.00 20.11           C  
ATOM   1048  O   LEU A 167      40.774  30.990   2.760  1.00 19.42           O  
ATOM   1049  CB  LEU A 167      40.774  27.953   2.878  1.00 18.34           C  
ATOM   1050  CG  LEU A 167      41.037  26.730   3.756  1.00 18.47           C  
ATOM   1051  CD1 LEU A 167      39.754  25.925   3.916  1.00 16.17           C  
ATOM   1052  CD2 LEU A 167      42.134  25.880   3.138  1.00 19.61           C  
ATOM   1053  N   PRO A 168      41.681  30.461   0.761  1.00 19.26           N  
ATOM   1054  CA  PRO A 168      41.216  31.667   0.066  1.00 19.37           C  
ATOM   1055  C   PRO A 168      39.757  31.366  -0.265  1.00 18.27           C  
ATOM   1056  O   PRO A 168      39.354  31.306  -1.427  1.00 17.68           O  
ATOM   1057  CB  PRO A 168      42.105  31.710  -1.170  1.00 19.36           C  
ATOM   1058  CG  PRO A 168      42.286  30.253  -1.482  1.00 20.96           C  
ATOM   1059  CD  PRO A 168      42.554  29.656  -0.113  1.00 19.71           C  
ATOM   1060  N   ALA A 169      38.990  31.173   0.803  1.00 17.54           N  
ATOM   1061  CA  ALA A 169      37.586  30.794   0.765  1.00 17.41           C  
ATOM   1062  C   ALA A 169      36.557  31.636   0.022  1.00 17.09           C  
ATOM   1063  O   ALA A 169      35.789  31.096  -0.770  1.00 17.02           O  
ATOM   1064  CB  ALA A 169      37.104  30.566   2.190  1.00 17.11           C  
ATOM   1065  N   HIS A 170      36.520  32.941   0.274  1.00 16.90           N  
ATOM   1066  CA  HIS A 170      35.517  33.786  -0.366  1.00 15.82           C  
ATOM   1067  C   HIS A 170      36.028  35.123  -0.860  1.00 14.78           C  
ATOM   1068  O   HIS A 170      37.208  35.427  -0.727  1.00 15.42           O  
ATOM   1069  CB  HIS A 170      34.366  34.009   0.610  1.00 15.25           C  
ATOM   1070  CG  HIS A 170      33.671  32.746   1.004  1.00 15.36           C  
ATOM   1071  ND1 HIS A 170      32.693  32.165   0.227  1.00 15.15           N  
ATOM   1072  CD2 HIS A 170      33.847  31.925   2.066  1.00 16.52           C  
ATOM   1073  CE1 HIS A 170      32.295  31.039   0.792  1.00 14.94           C  
ATOM   1074  NE2 HIS A 170      32.980  30.870   1.910  1.00 15.83           N  
ATOM   1075  N   SER A 171      35.123  35.920  -1.427  1.00 14.06           N  
ATOM   1076  CA  SER A 171      35.468  37.233  -1.953  1.00 15.78           C  
ATOM   1077  C   SER A 171      34.822  38.347  -1.130  1.00 14.89           C  
ATOM   1078  O   SER A 171      34.663  39.472  -1.592  1.00 16.72           O  
ATOM   1079  CB  SER A 171      35.037  37.340  -3.417  1.00 13.09           C  
ATOM   1080  OG  SER A 171      33.636  37.243  -3.535  1.00 16.67           O  
ATOM   1081  N   ASP A 172      34.450  38.012   0.096  1.00 15.17           N  
ATOM   1082  CA  ASP A 172      33.833  38.949   1.030  1.00 15.79           C  
ATOM   1083  C   ASP A 172      33.938  38.339   2.428  1.00 14.24           C  
ATOM   1084  O   ASP A 172      34.336  37.193   2.574  1.00 14.73           O  
ATOM   1085  CB  ASP A 172      32.365  39.191   0.669  1.00 15.62           C  
ATOM   1086  CG  ASP A 172      32.185  40.391  -0.240  1.00 19.18           C  
ATOM   1087  OD1 ASP A 172      32.841  41.423   0.024  1.00 17.80           O  
ATOM   1088  OD2 ASP A 172      31.384  40.312  -1.205  1.00 18.41           O  
ATOM   1089  N   PRO A 173      33.574  39.091   3.474  1.00 14.89           N  
ATOM   1090  CA  PRO A 173      33.666  38.543   4.833  1.00 13.24           C  
ATOM   1091  C   PRO A 173      33.034  37.165   4.979  1.00 14.52           C  
ATOM   1092  O   PRO A 173      32.046  36.856   4.315  1.00 15.17           O  
ATOM   1093  CB  PRO A 173      32.952  39.592   5.675  1.00 13.40           C  
ATOM   1094  CG  PRO A 173      33.221  40.865   4.938  1.00 14.97           C  
ATOM   1095  CD  PRO A 173      33.006  40.450   3.494  1.00 15.47           C  
ATOM   1096  N   VAL A 174      33.609  36.339   5.849  1.00 14.30           N  
ATOM   1097  CA  VAL A 174      33.092  34.992   6.095  1.00 14.90           C  
ATOM   1098  C   VAL A 174      32.238  35.034   7.356  1.00 15.81           C  
ATOM   1099  O   VAL A 174      32.732  35.308   8.449  1.00 16.86           O  
ATOM   1100  CB  VAL A 174      34.231  33.982   6.273  1.00 11.57           C  
ATOM   1101  CG1 VAL A 174      33.662  32.591   6.504  1.00  9.14           C  
ATOM   1102  CG2 VAL A 174      35.119  34.004   5.042  1.00 12.28           C  
ATOM   1103  N   SER A 175      30.950  34.755   7.188  1.00 15.06           N  
ATOM   1104  CA  SER A 175      29.992  34.823   8.281  1.00 15.58           C  
ATOM   1105  C   SER A 175      29.919  33.607   9.202  1.00 14.68           C  
ATOM   1106  O   SER A 175      29.568  33.742  10.379  1.00 14.68           O  
ATOM   1107  CB  SER A 175      28.602  35.147   7.703  1.00 14.75           C  
ATOM   1108  OG  SER A 175      28.294  34.291   6.616  1.00 13.49           O  
ATOM   1109  N   ALA A 176      30.263  32.431   8.687  1.00 13.55           N  
ATOM   1110  CA  ALA A 176      30.212  31.229   9.507  1.00 13.35           C  
ATOM   1111  C   ALA A 176      31.126  30.117   9.010  1.00 11.78           C  
ATOM   1112  O   ALA A 176      31.428  30.043   7.823  1.00 10.15           O  
ATOM   1113  CB  ALA A 176      28.766  30.718   9.586  1.00  8.45           C  
ATOM   1114  N   VAL A 177      31.562  29.266   9.939  1.00 11.06           N  
ATOM   1115  CA  VAL A 177      32.409  28.114   9.643  1.00 12.46           C  
ATOM   1116  C   VAL A 177      31.938  26.970  10.522  1.00 12.58           C  
ATOM   1117  O   VAL A 177      31.615  27.172  11.683  1.00 13.78           O  
ATOM   1118  CB  VAL A 177      33.898  28.391   9.918  1.00  9.83           C  
ATOM   1119  CG1 VAL A 177      34.407  29.445   8.950  1.00 12.23           C  
ATOM   1120  CG2 VAL A 177      34.089  28.854  11.348  1.00 10.55           C  
ATOM   1121  N   HIS A 178      31.903  25.765   9.971  1.00 16.08           N  
ATOM   1122  CA  HIS A 178      31.419  24.613  10.727  1.00 17.10           C  
ATOM   1123  C   HIS A 178      31.964  23.281  10.215  1.00 16.82           C  
ATOM   1124  O   HIS A 178      32.037  23.051   9.005  1.00 16.30           O  
ATOM   1125  CB  HIS A 178      29.887  24.586  10.647  1.00 17.98           C  
ATOM   1126  CG  HIS A 178      29.241  23.611  11.580  1.00 21.93           C  
ATOM   1127  ND1 HIS A 178      28.168  22.828  11.207  1.00 24.32           N  
ATOM   1128  CD2 HIS A 178      29.480  23.328  12.882  1.00 23.22           C  
ATOM   1129  CE1 HIS A 178      27.772  22.106  12.241  1.00 24.94           C  
ATOM   1130  NE2 HIS A 178      28.553  22.392  13.270  1.00 25.31           N  
ATOM   1131  N   PHE A 179      32.339  22.411  11.146  1.00 17.35           N  
ATOM   1132  CA  PHE A 179      32.830  21.074  10.814  1.00 17.47           C  
ATOM   1133  C   PHE A 179      31.612  20.159  10.782  1.00 17.95           C  
ATOM   1134  O   PHE A 179      30.629  20.417  11.477  1.00 18.62           O  
ATOM   1135  CB  PHE A 179      33.797  20.566  11.891  1.00 15.47           C  
ATOM   1136  CG  PHE A 179      35.227  20.985  11.685  1.00 14.57           C  
ATOM   1137  CD1 PHE A 179      36.020  20.355  10.728  1.00 13.41           C  
ATOM   1138  CD2 PHE A 179      35.787  21.992  12.462  1.00 12.63           C  
ATOM   1139  CE1 PHE A 179      37.353  20.716  10.549  1.00 11.95           C  
ATOM   1140  CE2 PHE A 179      37.115  22.363  12.295  1.00 14.00           C  
ATOM   1141  CZ  PHE A 179      37.904  21.723  11.335  1.00 14.18           C  
ATOM   1142  N   ASN A 180      31.666  19.105   9.974  1.00 19.41           N  
ATOM   1143  CA  ASN A 180      30.559  18.156   9.906  1.00 19.32           C  
ATOM   1144  C   ASN A 180      30.808  17.157  11.033  1.00 20.61           C  
ATOM   1145  O   ASN A 180      31.801  17.286  11.752  1.00 20.65           O  
ATOM   1146  CB  ASN A 180      30.501  17.487   8.525  1.00 17.93           C  
ATOM   1147  CG  ASN A 180      31.653  16.538   8.276  1.00 19.40           C  
ATOM   1148  OD1 ASN A 180      32.789  16.765   8.715  1.00 16.31           O  
ATOM   1149  ND2 ASN A 180      31.369  15.464   7.545  1.00 17.39           N  
ATOM   1150  N   ARG A 181      29.938  16.164  11.199  1.00 21.83           N  
ATOM   1151  CA  ARG A 181      30.088  15.231  12.321  1.00 23.44           C  
ATOM   1152  C   ARG A 181      31.307  14.307  12.384  1.00 20.79           C  
ATOM   1153  O   ARG A 181      31.612  13.786  13.450  1.00 20.19           O  
ATOM   1154  CB  ARG A 181      28.801  14.407  12.509  1.00 27.45           C  
ATOM   1155  CG  ARG A 181      28.488  13.421  11.404  1.00 33.90           C  
ATOM   1156  CD  ARG A 181      27.199  12.665  11.716  1.00 38.11           C  
ATOM   1157  NE  ARG A 181      26.941  11.605  10.747  1.00 41.79           N  
ATOM   1158  CZ  ARG A 181      25.833  10.870  10.717  1.00 43.30           C  
ATOM   1159  NH1 ARG A 181      24.869  11.080  11.606  1.00 42.88           N  
ATOM   1160  NH2 ARG A 181      25.691   9.924   9.797  1.00 43.23           N  
ATOM   1161  N   ASP A 182      32.010  14.096  11.277  1.00 19.53           N  
ATOM   1162  CA  ASP A 182      33.190  13.241  11.341  1.00 20.96           C  
ATOM   1163  C   ASP A 182      34.482  14.050  11.186  1.00 19.16           C  
ATOM   1164  O   ASP A 182      35.575  13.495  11.176  1.00 21.32           O  
ATOM   1165  CB  ASP A 182      33.118  12.107  10.297  1.00 22.26           C  
ATOM   1166  CG  ASP A 182      33.261  12.596   8.869  1.00 23.60           C  
ATOM   1167  OD1 ASP A 182      33.398  13.817   8.650  1.00 25.15           O  
ATOM   1168  OD2 ASP A 182      33.238  11.744   7.954  1.00 26.19           O  
ATOM   1169  N   GLY A 183      34.338  15.366  11.068  1.00 19.23           N  
ATOM   1170  CA  GLY A 183      35.483  16.253  10.938  1.00 18.29           C  
ATOM   1171  C   GLY A 183      36.108  16.350   9.557  1.00 18.73           C  
ATOM   1172  O   GLY A 183      36.936  17.226   9.306  1.00 18.40           O  
ATOM   1173  N   SER A 184      35.717  15.464   8.648  1.00 17.16           N  
ATOM   1174  CA  SER A 184      36.295  15.469   7.310  1.00 17.65           C  
ATOM   1175  C   SER A 184      35.905  16.686   6.477  1.00 17.14           C  
ATOM   1176  O   SER A 184      36.631  17.063   5.556  1.00 16.13           O  
ATOM   1177  CB  SER A 184      35.906  14.188   6.565  1.00 18.13           C  
ATOM   1178  OG  SER A 184      34.497  14.063   6.440  1.00 19.55           O  
ATOM   1179  N   LEU A 185      34.773  17.306   6.808  1.00 14.98           N  
ATOM   1180  CA  LEU A 185      34.301  18.460   6.051  1.00 14.40           C  
ATOM   1181  C   LEU A 185      34.125  19.738   6.851  1.00 14.89           C  
ATOM   1182  O   LEU A 185      33.904  19.718   8.065  1.00 14.77           O  
ATOM   1183  CB  LEU A 185      32.962  18.144   5.374  1.00 15.51           C  
ATOM   1184  CG  LEU A 185      32.877  16.969   4.402  1.00 16.99           C  
ATOM   1185  CD1 LEU A 185      31.466  16.874   3.854  1.00 17.06           C  
ATOM   1186  CD2 LEU A 185      33.877  17.163   3.273  1.00 18.65           C  
ATOM   1187  N   ILE A 186      34.198  20.851   6.130  1.00 14.09           N  
ATOM   1188  CA  ILE A 186      34.021  22.180   6.696  1.00 14.62           C  
ATOM   1189  C   ILE A 186      33.085  22.933   5.765  1.00 14.49           C  
ATOM   1190  O   ILE A 186      33.225  22.856   4.545  1.00 15.55           O  
ATOM   1191  CB  ILE A 186      35.344  22.981   6.731  1.00 13.37           C  
ATOM   1192  CG1 ILE A 186      36.344  22.327   7.684  1.00 13.27           C  
ATOM   1193  CG2 ILE A 186      35.062  24.419   7.140  1.00 11.93           C  
ATOM   1194  CD1 ILE A 186      37.742  22.918   7.585  1.00 13.38           C  
ATOM   1195  N   VAL A 187      32.126  23.650   6.331  1.00 13.94           N  
ATOM   1196  CA  VAL A 187      31.231  24.441   5.506  1.00 13.89           C  
ATOM   1197  C   VAL A 187      31.404  25.902   5.891  1.00 14.68           C  
ATOM   1198  O   VAL A 187      31.514  26.232   7.074  1.00 14.79           O  
ATOM   1199  CB  VAL A 187      29.750  24.036   5.678  1.00 13.46           C  
ATOM   1200  CG1 VAL A 187      29.300  24.242   7.108  1.00 13.52           C  
ATOM   1201  CG2 VAL A 187      28.896  24.860   4.732  1.00 11.53           C  
ATOM   1202  N   SER A 188      31.447  26.774   4.889  1.00 13.30           N  
ATOM   1203  CA  SER A 188      31.611  28.197   5.137  1.00 14.90           C  
ATOM   1204  C   SER A 188      30.592  29.006   4.349  1.00 15.58           C  
ATOM   1205  O   SER A 188      30.225  28.641   3.234  1.00 15.21           O  
ATOM   1206  CB  SER A 188      33.022  28.646   4.746  1.00 15.25           C  
ATOM   1207  OG  SER A 188      33.213  28.578   3.344  1.00 14.83           O  
ATOM   1208  N   SER A 189      30.139  30.107   4.941  1.00 15.24           N  
ATOM   1209  CA  SER A 189      29.185  30.994   4.289  1.00 14.01           C  
ATOM   1210  C   SER A 189      29.788  32.388   4.220  1.00 14.34           C  
ATOM   1211  O   SER A 189      30.616  32.767   5.057  1.00 13.64           O  
ATOM   1212  CB  SER A 189      27.863  31.025   5.056  1.00 13.69           C  
ATOM   1213  OG  SER A 189      28.076  31.330   6.417  1.00 17.54           O  
ATOM   1214  N   SER A 190      29.369  33.161   3.229  1.00 12.05           N  
ATOM   1215  CA  SER A 190      29.932  34.484   3.069  1.00 12.74           C  
ATOM   1216  C   SER A 190      28.999  35.517   2.461  1.00 13.72           C  
ATOM   1217  O   SER A 190      28.027  35.179   1.777  1.00 12.13           O  
ATOM   1218  CB  SER A 190      31.191  34.379   2.204  1.00 11.19           C  
ATOM   1219  OG  SER A 190      31.664  35.653   1.830  1.00 11.60           O  
ATOM   1220  N   TYR A 191      29.314  36.783   2.711  1.00 13.80           N  
ATOM   1221  CA  TYR A 191      28.551  37.880   2.150  1.00 14.82           C  
ATOM   1222  C   TYR A 191      28.682  37.866   0.623  1.00 14.38           C  
ATOM   1223  O   TYR A 191      27.981  38.608  -0.061  1.00 15.08           O  
ATOM   1224  CB  TYR A 191      29.039  39.224   2.700  1.00 16.70           C  
ATOM   1225  CG  TYR A 191      28.441  39.619   4.036  1.00 21.01           C  
ATOM   1226  CD1 TYR A 191      28.694  38.878   5.182  1.00 24.34           C  
ATOM   1227  CD2 TYR A 191      27.627  40.743   4.149  1.00 26.00           C  
ATOM   1228  CE1 TYR A 191      28.155  39.248   6.418  1.00 26.54           C  
ATOM   1229  CE2 TYR A 191      27.080  41.124   5.377  1.00 28.00           C  
ATOM   1230  CZ  TYR A 191      27.355  40.369   6.508  1.00 28.54           C  
ATOM   1231  OH  TYR A 191      26.848  40.749   7.735  1.00 30.99           O  
ATOM   1232  N   ASP A 192      29.575  37.040   0.079  1.00 12.02           N  
ATOM   1233  CA  ASP A 192      29.697  36.981  -1.377  1.00 15.43           C  
ATOM   1234  C   ASP A 192      28.538  36.178  -1.990  1.00 16.01           C  
ATOM   1235  O   ASP A 192      28.442  36.033  -3.207  1.00 16.77           O  
ATOM   1236  CB  ASP A 192      31.051  36.398  -1.815  1.00 14.49           C  
ATOM   1237  CG  ASP A 192      31.258  34.963  -1.368  1.00 16.45           C  
ATOM   1238  OD1 ASP A 192      30.325  34.345  -0.811  1.00 17.86           O  
ATOM   1239  OD2 ASP A 192      32.373  34.452  -1.581  1.00 15.05           O  
ATOM   1240  N   GLY A 193      27.661  35.668  -1.127  1.00 17.10           N  
ATOM   1241  CA  GLY A 193      26.498  34.926  -1.572  1.00 17.43           C  
ATOM   1242  C   GLY A 193      26.699  33.441  -1.743  1.00 17.98           C  
ATOM   1243  O   GLY A 193      25.779  32.726  -2.148  1.00 17.91           O  
ATOM   1244  N   LEU A 194      27.895  32.969  -1.419  1.00 18.26           N  
ATOM   1245  CA  LEU A 194      28.216  31.559  -1.565  1.00 19.11           C  
ATOM   1246  C   LEU A 194      28.335  30.782  -0.264  1.00 19.56           C  
ATOM   1247  O   LEU A 194      28.604  31.342   0.803  1.00 19.32           O  
ATOM   1248  CB  LEU A 194      29.542  31.400  -2.320  1.00 20.41           C  
ATOM   1249  CG  LEU A 194      29.739  32.203  -3.606  1.00 20.15           C  
ATOM   1250  CD1 LEU A 194      31.121  31.915  -4.189  1.00 16.91           C  
ATOM   1251  CD2 LEU A 194      28.642  31.844  -4.596  1.00 19.26           C  
ATOM   1252  N   CYS A 195      28.114  29.478  -0.382  1.00 19.14           N  
ATOM   1253  CA  CYS A 195      28.268  28.536   0.711  1.00 19.48           C  
ATOM   1254  C   CYS A 195      29.234  27.531   0.098  1.00 19.69           C  
ATOM   1255  O   CYS A 195      29.012  27.061  -1.020  1.00 20.08           O  
ATOM   1256  CB  CYS A 195      26.948  27.834   1.056  1.00 20.81           C  
ATOM   1257  SG  CYS A 195      25.847  28.759   2.153  1.00 23.30           S  
ATOM   1258  N   ARG A 196      30.317  27.217   0.797  1.00 18.64           N  
ATOM   1259  CA  ARG A 196      31.270  26.258   0.259  1.00 17.77           C  
ATOM   1260  C   ARG A 196      31.574  25.107   1.194  1.00 16.91           C  
ATOM   1261  O   ARG A 196      31.577  25.256   2.416  1.00 16.40           O  
ATOM   1262  CB  ARG A 196      32.568  26.962  -0.153  1.00 16.42           C  
ATOM   1263  CG  ARG A 196      32.527  27.425  -1.598  1.00 16.29           C  
ATOM   1264  CD  ARG A 196      33.577  28.462  -1.937  1.00 17.62           C  
ATOM   1265  NE  ARG A 196      33.522  28.794  -3.357  1.00 19.15           N  
ATOM   1266  CZ  ARG A 196      34.069  29.873  -3.905  1.00 21.71           C  
ATOM   1267  NH1 ARG A 196      34.723  30.747  -3.154  1.00 22.52           N  
ATOM   1268  NH2 ARG A 196      33.958  30.086  -5.212  1.00 20.93           N  
ATOM   1269  N   ILE A 197      31.803  23.948   0.592  1.00 16.57           N  
ATOM   1270  CA  ILE A 197      32.130  22.739   1.320  1.00 17.12           C  
ATOM   1271  C   ILE A 197      33.611  22.502   1.044  1.00 17.93           C  
ATOM   1272  O   ILE A 197      34.035  22.492  -0.111  1.00 16.64           O  
ATOM   1273  CB  ILE A 197      31.309  21.536   0.803  1.00 17.91           C  
ATOM   1274  CG1 ILE A 197      29.820  21.857   0.883  1.00 17.56           C  
ATOM   1275  CG2 ILE A 197      31.624  20.285   1.625  1.00 15.97           C  
ATOM   1276  CD1 ILE A 197      29.334  22.127   2.288  1.00 18.21           C  
ATOM   1277  N   TRP A 198      34.393  22.326   2.105  1.00 17.88           N  
ATOM   1278  CA  TRP A 198      35.824  22.102   1.953  1.00 17.43           C  
ATOM   1279  C   TRP A 198      36.264  20.771   2.539  1.00 17.35           C  
ATOM   1280  O   TRP A 198      35.707  20.292   3.529  1.00 17.42           O  
ATOM   1281  CB  TRP A 198      36.629  23.206   2.650  1.00 16.11           C  
ATOM   1282  CG  TRP A 198      36.175  24.576   2.341  1.00 15.06           C  
ATOM   1283  CD1 TRP A 198      35.179  25.271   2.961  1.00 14.19           C  
ATOM   1284  CD2 TRP A 198      36.677  25.423   1.307  1.00 14.70           C  
ATOM   1285  NE1 TRP A 198      35.026  26.500   2.374  1.00 13.56           N  
ATOM   1286  CE2 TRP A 198      35.932  26.619   1.352  1.00 13.23           C  
ATOM   1287  CE3 TRP A 198      37.680  25.284   0.340  1.00 15.95           C  
ATOM   1288  CZ2 TRP A 198      36.161  27.676   0.470  1.00 12.81           C  
ATOM   1289  CZ3 TRP A 198      37.909  26.336  -0.538  1.00 16.12           C  
ATOM   1290  CH2 TRP A 198      37.146  27.518  -0.468  1.00 16.06           C  
ATOM   1291  N   ASP A 199      37.276  20.183   1.918  1.00 16.45           N  
ATOM   1292  CA  ASP A 199      37.842  18.940   2.403  1.00 16.78           C  
ATOM   1293  C   ASP A 199      38.841  19.369   3.480  1.00 16.39           C  
ATOM   1294  O   ASP A 199      39.821  20.052   3.181  1.00 15.20           O  
ATOM   1295  CB  ASP A 199      38.575  18.219   1.275  1.00 17.79           C  
ATOM   1296  CG  ASP A 199      39.387  17.052   1.778  1.00 19.77           C  
ATOM   1297  OD1 ASP A 199      38.785  16.044   2.209  1.00 19.74           O  
ATOM   1298  OD2 ASP A 199      40.630  17.155   1.756  1.00 22.49           O  
ATOM   1299  N   THR A 200      38.584  18.978   4.724  1.00 15.39           N  
ATOM   1300  CA  THR A 200      39.442  19.341   5.852  1.00 16.69           C  
ATOM   1301  C   THR A 200      40.919  18.976   5.701  1.00 18.21           C  
ATOM   1302  O   THR A 200      41.804  19.798   5.944  1.00 17.21           O  
ATOM   1303  CB  THR A 200      38.933  18.695   7.168  1.00 15.91           C  
ATOM   1304  OG1 THR A 200      37.619  19.186   7.471  1.00 15.28           O  
ATOM   1305  CG2 THR A 200      39.869  19.030   8.319  1.00 16.81           C  
ATOM   1306  N   ALA A 201      41.189  17.745   5.292  1.00 19.30           N  
ATOM   1307  CA  ALA A 201      42.565  17.290   5.160  1.00 18.77           C  
ATOM   1308  C   ALA A 201      43.402  18.027   4.116  1.00 19.91           C  
ATOM   1309  O   ALA A 201      44.574  18.321   4.349  1.00 20.39           O  
ATOM   1310  CB  ALA A 201      42.578  15.798   4.876  1.00 20.52           C  
ATOM   1311  N   SER A 202      42.807  18.339   2.971  1.00 18.86           N  
ATOM   1312  CA  SER A 202      43.544  19.000   1.901  1.00 18.71           C  
ATOM   1313  C   SER A 202      43.284  20.490   1.800  1.00 19.58           C  
ATOM   1314  O   SER A 202      44.145  21.246   1.355  1.00 20.04           O  
ATOM   1315  CB  SER A 202      43.201  18.354   0.560  1.00 18.39           C  
ATOM   1316  OG  SER A 202      41.862  18.632   0.212  1.00 16.77           O  
ATOM   1317  N   GLY A 203      42.089  20.904   2.203  1.00 20.26           N  
ATOM   1318  CA  GLY A 203      41.726  22.304   2.127  1.00 19.09           C  
ATOM   1319  C   GLY A 203      41.175  22.649   0.759  1.00 19.51           C  
ATOM   1320  O   GLY A 203      40.944  23.818   0.471  1.00 19.73           O  
ATOM   1321  N   GLN A 204      40.973  21.642  -0.091  1.00 21.14           N  
ATOM   1322  CA  GLN A 204      40.441  21.867  -1.439  1.00 23.08           C  
ATOM   1323  C   GLN A 204      38.918  21.975  -1.412  1.00 22.96           C  
ATOM   1324  O   GLN A 204      38.256  21.298  -0.629  1.00 23.27           O  
ATOM   1325  CB  GLN A 204      40.851  20.729  -2.382  1.00 24.67           C  
ATOM   1326  CG  GLN A 204      42.355  20.502  -2.491  1.00 27.91           C  
ATOM   1327  CD  GLN A 204      43.118  21.774  -2.794  1.00 29.82           C  
ATOM   1328  OE1 GLN A 204      42.910  22.408  -3.827  1.00 31.28           O  
ATOM   1329  NE2 GLN A 204      44.006  22.160  -1.882  1.00 32.42           N  
ATOM   1330  N   CYS A 205      38.364  22.826  -2.271  1.00 23.94           N  
ATOM   1331  CA  CYS A 205      36.917  23.013  -2.328  1.00 23.09           C  
ATOM   1332  C   CYS A 205      36.240  21.822  -2.996  1.00 22.77           C  
ATOM   1333  O   CYS A 205      36.649  21.403  -4.071  1.00 22.38           O  
ATOM   1334  CB  CYS A 205      36.583  24.294  -3.093  1.00 22.46           C  
ATOM   1335  SG  CYS A 205      34.812  24.703  -3.092  1.00 27.05           S  
ATOM   1336  N   LEU A 206      35.212  21.276  -2.349  1.00 23.22           N  
ATOM   1337  CA  LEU A 206      34.481  20.131  -2.893  1.00 23.24           C  
ATOM   1338  C   LEU A 206      33.168  20.566  -3.524  1.00 24.86           C  
ATOM   1339  O   LEU A 206      32.631  19.871  -4.389  1.00 26.27           O  
ATOM   1340  CB  LEU A 206      34.199  19.094  -1.805  1.00 19.74           C  
ATOM   1341  CG  LEU A 206      35.386  18.262  -1.321  1.00 19.88           C  
ATOM   1342  CD1 LEU A 206      34.979  17.485  -0.084  1.00 16.79           C  
ATOM   1343  CD2 LEU A 206      35.863  17.328  -2.436  1.00 18.70           C  
ATOM   1344  N   LYS A 207      32.646  21.709  -3.090  1.00 24.74           N  
ATOM   1345  CA  LYS A 207      31.400  22.205  -3.652  1.00 24.06           C  
ATOM   1346  C   LYS A 207      31.096  23.651  -3.306  1.00 24.24           C  
ATOM   1347  O   LYS A 207      31.362  24.117  -2.193  1.00 23.15           O  
ATOM   1348  CB  LYS A 207      30.228  21.327  -3.211  1.00 27.60           C  
ATOM   1349  CG  LYS A 207      28.904  21.699  -3.879  1.00 29.66           C  
ATOM   1350  CD  LYS A 207      28.157  20.465  -4.340  1.00 32.16           C  
ATOM   1351  CE  LYS A 207      26.861  20.820  -5.058  1.00 35.64           C  
ATOM   1352  NZ  LYS A 207      27.087  21.473  -6.378  1.00 37.52           N  
ATOM   1353  N   THR A 208      30.546  24.356  -4.288  1.00 22.40           N  
ATOM   1354  CA  THR A 208      30.149  25.747  -4.134  1.00 23.64           C  
ATOM   1355  C   THR A 208      28.659  25.768  -4.448  1.00 25.59           C  
ATOM   1356  O   THR A 208      28.238  25.233  -5.470  1.00 26.16           O  
ATOM   1357  CB  THR A 208      30.886  26.675  -5.136  1.00 21.91           C  
ATOM   1358  OG1 THR A 208      32.291  26.706  -4.838  1.00 20.49           O  
ATOM   1359  CG2 THR A 208      30.336  28.079  -5.055  1.00 19.07           C  
ATOM   1360  N   LEU A 209      27.856  26.354  -3.566  1.00 28.60           N  
ATOM   1361  CA  LEU A 209      26.417  26.435  -3.794  1.00 30.29           C  
ATOM   1362  C   LEU A 209      25.966  27.857  -4.047  1.00 31.62           C  
ATOM   1363  O   LEU A 209      26.400  28.789  -3.366  1.00 30.31           O  
ATOM   1364  CB  LEU A 209      25.624  25.897  -2.605  1.00 32.23           C  
ATOM   1365  CG  LEU A 209      25.282  24.412  -2.633  1.00 35.56           C  
ATOM   1366  CD1 LEU A 209      26.436  23.615  -2.044  1.00 36.55           C  
ATOM   1367  CD2 LEU A 209      24.005  24.172  -1.837  1.00 37.28           C  
ATOM   1368  N   ILE A 210      25.089  28.008  -5.032  1.00 33.50           N  
ATOM   1369  CA  ILE A 210      24.544  29.306  -5.384  1.00 35.35           C  
ATOM   1370  C   ILE A 210      23.058  29.290  -5.089  1.00 36.71           C  
ATOM   1371  O   ILE A 210      22.387  28.280  -5.296  1.00 35.87           O  
ATOM   1372  CB  ILE A 210      24.715  29.629  -6.880  1.00 35.65           C  
ATOM   1373  CG1 ILE A 210      24.025  28.551  -7.716  1.00 36.49           C  
ATOM   1374  CG2 ILE A 210      26.191  29.750  -7.223  1.00 36.25           C  
ATOM   1375  CD1 ILE A 210      23.433  29.065  -9.019  1.00 38.91           C  
ATOM   1376  N   ASP A 211      22.566  30.417  -4.590  1.00 39.10           N  
ATOM   1377  CA  ASP A 211      21.157  30.605  -4.265  1.00 40.56           C  
ATOM   1378  C   ASP A 211      20.752  31.707  -5.244  1.00 41.25           C  
ATOM   1379  O   ASP A 211      20.836  32.892  -4.941  1.00 40.70           O  
ATOM   1380  CB  ASP A 211      21.034  31.053  -2.798  1.00 40.86           C  
ATOM   1381  CG  ASP A 211      19.594  31.243  -2.350  1.00 41.49           C  
ATOM   1382  OD1 ASP A 211      18.703  30.527  -2.854  1.00 41.72           O  
ATOM   1383  OD2 ASP A 211      19.358  32.105  -1.473  1.00 40.60           O  
ATOM   1384  N   ASP A 212      20.341  31.275  -6.432  1.00 42.52           N  
ATOM   1385  CA  ASP A 212      19.963  32.144  -7.548  1.00 43.92           C  
ATOM   1386  C   ASP A 212      20.311  33.638  -7.534  1.00 41.24           C  
ATOM   1387  O   ASP A 212      21.150  34.065  -8.322  1.00 42.00           O  
ATOM   1388  CB  ASP A 212      18.487  31.949  -7.904  1.00 47.45           C  
ATOM   1389  CG  ASP A 212      18.313  31.144  -9.195  1.00 50.88           C  
ATOM   1390  OD1 ASP A 212      18.347  29.889  -9.140  1.00 50.73           O  
ATOM   1391  OD2 ASP A 212      18.171  31.773 -10.270  1.00 51.75           O  
ATOM   1392  N   ASP A 213      19.689  34.438  -6.676  1.00 38.69           N  
ATOM   1393  CA  ASP A 213      20.015  35.866  -6.650  1.00 35.72           C  
ATOM   1394  C   ASP A 213      21.338  36.149  -5.907  1.00 33.89           C  
ATOM   1395  O   ASP A 213      21.842  37.278  -5.905  1.00 29.88           O  
ATOM   1396  CB  ASP A 213      18.875  36.646  -5.999  1.00 37.08           C  
ATOM   1397  CG  ASP A 213      18.965  38.119  -6.279  1.00 39.00           C  
ATOM   1398  OD1 ASP A 213      19.329  38.464  -7.423  1.00 41.47           O  
ATOM   1399  OD2 ASP A 213      18.668  38.929  -5.378  1.00 39.41           O  
ATOM   1400  N   ASN A 214      21.882  35.105  -5.284  1.00 31.59           N  
ATOM   1401  CA  ASN A 214      23.125  35.168  -4.518  1.00 30.09           C  
ATOM   1402  C   ASN A 214      23.198  36.240  -3.432  1.00 28.06           C  
ATOM   1403  O   ASN A 214      24.193  36.969  -3.326  1.00 27.70           O  
ATOM   1404  CB  ASN A 214      24.326  35.304  -5.454  1.00 32.05           C  
ATOM   1405  CG  ASN A 214      24.589  34.033  -6.237  1.00 36.20           C  
ATOM   1406  OD1 ASN A 214      24.129  32.950  -5.862  1.00 36.72           O  
ATOM   1407  ND2 ASN A 214      25.343  34.154  -7.322  1.00 37.99           N  
ATOM   1408  N   PRO A 215      22.143  36.352  -2.606  1.00 24.38           N  
ATOM   1409  CA  PRO A 215      22.140  37.348  -1.530  1.00 21.22           C  
ATOM   1410  C   PRO A 215      23.155  36.921  -0.464  1.00 19.04           C  
ATOM   1411  O   PRO A 215      23.479  35.736  -0.352  1.00 17.90           O  
ATOM   1412  CB  PRO A 215      20.702  37.292  -1.023  1.00 20.54           C  
ATOM   1413  CG  PRO A 215      20.339  35.860  -1.229  1.00 20.47           C  
ATOM   1414  CD  PRO A 215      20.892  35.574  -2.604  1.00 21.79           C  
ATOM   1415  N   PRO A 216      23.677  37.879   0.322  1.00 16.22           N  
ATOM   1416  CA  PRO A 216      24.658  37.621   1.383  1.00 14.84           C  
ATOM   1417  C   PRO A 216      24.242  36.475   2.299  1.00 13.15           C  
ATOM   1418  O   PRO A 216      23.122  36.467   2.806  1.00 12.09           O  
ATOM   1419  CB  PRO A 216      24.702  38.951   2.139  1.00 16.58           C  
ATOM   1420  CG  PRO A 216      24.433  39.945   1.059  1.00 15.53           C  
ATOM   1421  CD  PRO A 216      23.296  39.301   0.304  1.00 16.21           C  
ATOM   1422  N   VAL A 217      25.129  35.504   2.503  1.00 12.35           N  
ATOM   1423  CA  VAL A 217      24.810  34.389   3.392  1.00 13.16           C  
ATOM   1424  C   VAL A 217      25.342  34.767   4.765  1.00 15.42           C  
ATOM   1425  O   VAL A 217      26.544  34.934   4.965  1.00 16.15           O  
ATOM   1426  CB  VAL A 217      25.447  33.065   2.928  1.00 12.70           C  
ATOM   1427  CG1 VAL A 217      24.887  31.906   3.753  1.00 10.53           C  
ATOM   1428  CG2 VAL A 217      25.146  32.832   1.435  1.00 13.13           C  
ATOM   1429  N   SER A 218      24.424  34.906   5.709  1.00 14.84           N  
ATOM   1430  CA  SER A 218      24.753  35.322   7.060  1.00 15.13           C  
ATOM   1431  C   SER A 218      25.018  34.200   8.043  1.00 15.66           C  
ATOM   1432  O   SER A 218      25.433  34.455   9.164  1.00 17.22           O  
ATOM   1433  CB  SER A 218      23.625  36.202   7.591  1.00 14.53           C  
ATOM   1434  OG  SER A 218      22.370  35.568   7.385  1.00 14.54           O  
ATOM   1435  N   PHE A 219      24.777  32.962   7.638  1.00 14.83           N  
ATOM   1436  CA  PHE A 219      25.016  31.838   8.533  1.00 14.87           C  
ATOM   1437  C   PHE A 219      24.802  30.517   7.810  1.00 16.16           C  
ATOM   1438  O   PHE A 219      23.947  30.413   6.931  1.00 19.11           O  
ATOM   1439  CB  PHE A 219      24.066  31.901   9.735  1.00 13.80           C  
ATOM   1440  CG  PHE A 219      24.231  30.760  10.695  1.00 11.27           C  
ATOM   1441  CD1 PHE A 219      25.260  30.770  11.635  1.00 12.78           C  
ATOM   1442  CD2 PHE A 219      23.392  29.655  10.630  1.00 10.65           C  
ATOM   1443  CE1 PHE A 219      25.451  29.686  12.503  1.00 11.11           C  
ATOM   1444  CE2 PHE A 219      23.573  28.567  11.485  1.00 12.09           C  
ATOM   1445  CZ  PHE A 219      24.604  28.583  12.424  1.00 13.57           C  
ATOM   1446  N   VAL A 220      25.587  29.516   8.183  1.00 15.91           N  
ATOM   1447  CA  VAL A 220      25.458  28.188   7.599  1.00 16.76           C  
ATOM   1448  C   VAL A 220      25.911  27.166   8.636  1.00 16.25           C  
ATOM   1449  O   VAL A 220      26.705  27.480   9.514  1.00 16.18           O  
ATOM   1450  CB  VAL A 220      26.309  28.032   6.334  1.00 16.72           C  
ATOM   1451  CG1 VAL A 220      27.787  28.053   6.690  1.00 14.89           C  
ATOM   1452  CG2 VAL A 220      25.936  26.732   5.635  1.00 15.75           C  
ATOM   1453  N   LYS A 221      25.417  25.941   8.515  1.00 17.46           N  
ATOM   1454  CA  LYS A 221      25.743  24.887   9.465  1.00 17.66           C  
ATOM   1455  C   LYS A 221      25.232  23.535   8.971  1.00 17.21           C  
ATOM   1456  O   LYS A 221      24.193  23.465   8.322  1.00 16.08           O  
ATOM   1457  CB  LYS A 221      25.090  25.238  10.799  1.00 20.28           C  
ATOM   1458  CG  LYS A 221      24.964  24.128  11.800  1.00 20.65           C  
ATOM   1459  CD  LYS A 221      24.091  24.603  12.952  1.00 19.52           C  
ATOM   1460  CE  LYS A 221      24.598  24.065  14.272  1.00 19.37           C  
ATOM   1461  NZ  LYS A 221      23.982  24.802  15.417  1.00 23.91           N  
ATOM   1462  N   PHE A 222      25.966  22.468   9.275  1.00 17.64           N  
ATOM   1463  CA  PHE A 222      25.561  21.112   8.883  1.00 18.77           C  
ATOM   1464  C   PHE A 222      24.418  20.633   9.781  1.00 20.32           C  
ATOM   1465  O   PHE A 222      24.289  21.059  10.936  1.00 20.46           O  
ATOM   1466  CB  PHE A 222      26.721  20.120   9.051  1.00 17.03           C  
ATOM   1467  CG  PHE A 222      27.781  20.214   7.990  1.00 16.89           C  
ATOM   1468  CD1 PHE A 222      27.543  19.749   6.698  1.00 14.62           C  
ATOM   1469  CD2 PHE A 222      29.039  20.731   8.299  1.00 15.40           C  
ATOM   1470  CE1 PHE A 222      28.539  19.788   5.728  1.00 13.83           C  
ATOM   1471  CE2 PHE A 222      30.048  20.779   7.336  1.00 15.95           C  
ATOM   1472  CZ  PHE A 222      29.798  20.305   6.046  1.00 17.04           C  
ATOM   1473  N   SER A 223      23.596  19.740   9.245  1.00 19.67           N  
ATOM   1474  CA  SER A 223      22.510  19.168  10.018  1.00 20.08           C  
ATOM   1475  C   SER A 223      23.180  18.139  10.913  1.00 20.82           C  
ATOM   1476  O   SER A 223      24.293  17.712  10.635  1.00 20.38           O  
ATOM   1477  CB  SER A 223      21.496  18.495   9.089  1.00 19.45           C  
ATOM   1478  OG  SER A 223      22.145  17.695   8.122  1.00 19.91           O  
ATOM   1479  N   PRO A 224      22.524  17.733  12.007  1.00 23.49           N  
ATOM   1480  CA  PRO A 224      23.143  16.745  12.893  1.00 25.35           C  
ATOM   1481  C   PRO A 224      23.740  15.516  12.190  1.00 28.33           C  
ATOM   1482  O   PRO A 224      24.829  15.067  12.540  1.00 28.80           O  
ATOM   1483  CB  PRO A 224      22.005  16.392  13.842  1.00 24.64           C  
ATOM   1484  CG  PRO A 224      21.321  17.714  14.004  1.00 23.92           C  
ATOM   1485  CD  PRO A 224      21.243  18.204  12.566  1.00 24.23           C  
ATOM   1486  N   ASN A 225      23.034  14.981  11.200  1.00 29.30           N  
ATOM   1487  CA  ASN A 225      23.519  13.809  10.481  1.00 31.23           C  
ATOM   1488  C   ASN A 225      24.566  14.154   9.427  1.00 31.61           C  
ATOM   1489  O   ASN A 225      25.179  13.261   8.841  1.00 33.76           O  
ATOM   1490  CB  ASN A 225      22.358  13.067   9.817  1.00 32.47           C  
ATOM   1491  CG  ASN A 225      21.465  13.987   9.023  1.00 34.19           C  
ATOM   1492  OD1 ASN A 225      21.944  14.866   8.313  1.00 35.03           O  
ATOM   1493  ND2 ASN A 225      20.156  13.789   9.133  1.00 34.72           N  
ATOM   1494  N   GLY A 226      24.763  15.442   9.176  1.00 29.81           N  
ATOM   1495  CA  GLY A 226      25.766  15.855   8.208  1.00 28.47           C  
ATOM   1496  C   GLY A 226      25.399  15.813   6.736  1.00 27.89           C  
ATOM   1497  O   GLY A 226      26.222  16.160   5.887  1.00 28.47           O  
ATOM   1498  N   LYS A 227      24.185  15.396   6.409  1.00 26.84           N  
ATOM   1499  CA  LYS A 227      23.801  15.350   5.004  1.00 28.11           C  
ATOM   1500  C   LYS A 227      23.224  16.665   4.481  1.00 25.80           C  
ATOM   1501  O   LYS A 227      23.179  16.880   3.271  1.00 24.45           O  
ATOM   1502  CB  LYS A 227      22.817  14.200   4.745  1.00 31.12           C  
ATOM   1503  CG  LYS A 227      21.631  14.123   5.691  1.00 36.10           C  
ATOM   1504  CD  LYS A 227      20.844  12.824   5.475  1.00 39.35           C  
ATOM   1505  CE  LYS A 227      19.884  12.543   6.628  1.00 40.62           C  
ATOM   1506  NZ  LYS A 227      19.192  11.223   6.500  1.00 43.03           N  
ATOM   1507  N   TYR A 228      22.799  17.542   5.386  1.00 24.26           N  
ATOM   1508  CA  TYR A 228      22.230  18.829   4.988  1.00 25.21           C  
ATOM   1509  C   TYR A 228      23.005  20.017   5.522  1.00 24.51           C  
ATOM   1510  O   TYR A 228      23.852  19.891   6.408  1.00 26.05           O  
ATOM   1511  CB  TYR A 228      20.785  18.969   5.472  1.00 25.76           C  
ATOM   1512  CG  TYR A 228      19.900  17.808   5.108  1.00 29.54           C  
ATOM   1513  CD1 TYR A 228      19.780  17.381   3.784  1.00 28.89           C  
ATOM   1514  CD2 TYR A 228      19.179  17.133   6.091  1.00 30.87           C  
ATOM   1515  CE1 TYR A 228      18.965  16.308   3.453  1.00 30.98           C  
ATOM   1516  CE2 TYR A 228      18.358  16.059   5.764  1.00 31.47           C  
ATOM   1517  CZ  TYR A 228      18.255  15.654   4.446  1.00 30.26           C  
ATOM   1518  OH  TYR A 228      17.432  14.604   4.127  1.00 32.73           O  
ATOM   1519  N   ILE A 229      22.672  21.176   4.970  1.00 22.64           N  
ATOM   1520  CA  ILE A 229      23.268  22.439   5.348  1.00 22.33           C  
ATOM   1521  C   ILE A 229      22.132  23.446   5.502  1.00 21.28           C  
ATOM   1522  O   ILE A 229      21.306  23.601   4.602  1.00 20.98           O  
ATOM   1523  CB  ILE A 229      24.283  22.916   4.260  1.00 23.28           C  
ATOM   1524  CG1 ILE A 229      25.702  22.845   4.824  1.00 24.49           C  
ATOM   1525  CG2 ILE A 229      23.982  24.318   3.787  1.00 22.61           C  
ATOM   1526  CD1 ILE A 229      26.514  21.724   4.248  1.00 25.04           C  
ATOM   1527  N   LEU A 230      22.074  24.099   6.657  1.00 18.89           N  
ATOM   1528  CA  LEU A 230      21.056  25.111   6.920  1.00 17.04           C  
ATOM   1529  C   LEU A 230      21.724  26.476   6.714  1.00 16.32           C  
ATOM   1530  O   LEU A 230      22.646  26.831   7.442  1.00 15.38           O  
ATOM   1531  CB  LEU A 230      20.547  24.994   8.362  1.00 15.60           C  
ATOM   1532  CG  LEU A 230      19.505  26.026   8.809  1.00 15.28           C  
ATOM   1533  CD1 LEU A 230      18.156  25.717   8.165  1.00 13.18           C  
ATOM   1534  CD2 LEU A 230      19.376  25.997  10.322  1.00 15.35           C  
ATOM   1535  N   ALA A 231      21.263  27.236   5.726  1.00 15.07           N  
ATOM   1536  CA  ALA A 231      21.854  28.539   5.446  1.00 15.15           C  
ATOM   1537  C   ALA A 231      20.869  29.685   5.597  1.00 16.75           C  
ATOM   1538  O   ALA A 231      19.703  29.566   5.224  1.00 16.88           O  
ATOM   1539  CB  ALA A 231      22.439  28.561   4.040  1.00 12.14           C  
ATOM   1540  N   ALA A 232      21.352  30.800   6.137  1.00 15.45           N  
ATOM   1541  CA  ALA A 232      20.532  31.983   6.316  1.00 14.75           C  
ATOM   1542  C   ALA A 232      21.041  33.044   5.351  1.00 15.65           C  
ATOM   1543  O   ALA A 232      22.248  33.260   5.240  1.00 15.52           O  
ATOM   1544  CB  ALA A 232      20.637  32.490   7.753  1.00 14.09           C  
ATOM   1545  N   THR A 233      20.126  33.684   4.632  1.00 15.36           N  
ATOM   1546  CA  THR A 233      20.507  34.735   3.701  1.00 16.62           C  
ATOM   1547  C   THR A 233      19.806  36.012   4.135  1.00 17.42           C  
ATOM   1548  O   THR A 233      18.695  35.963   4.675  1.00 17.67           O  
ATOM   1549  CB  THR A 233      20.141  34.368   2.239  1.00 17.03           C  
ATOM   1550  OG1 THR A 233      18.788  33.901   2.176  1.00 17.87           O  
ATOM   1551  CG2 THR A 233      21.070  33.274   1.724  1.00 16.64           C  
ATOM   1552  N   LEU A 234      20.460  37.150   3.917  1.00 17.33           N  
ATOM   1553  CA  LEU A 234      19.905  38.437   4.329  1.00 17.87           C  
ATOM   1554  C   LEU A 234      18.670  38.921   3.564  1.00 18.08           C  
ATOM   1555  O   LEU A 234      18.412  40.119   3.472  1.00 19.33           O  
ATOM   1556  CB  LEU A 234      20.999  39.510   4.309  1.00 15.69           C  
ATOM   1557  CG  LEU A 234      22.111  39.280   5.339  1.00 14.81           C  
ATOM   1558  CD1 LEU A 234      23.100  40.428   5.289  1.00 12.44           C  
ATOM   1559  CD2 LEU A 234      21.502  39.146   6.734  1.00 11.96           C  
ATOM   1560  N   ASP A 235      17.910  37.982   3.019  1.00 17.50           N  
ATOM   1561  CA  ASP A 235      16.679  38.319   2.322  1.00 17.02           C  
ATOM   1562  C   ASP A 235      15.516  37.722   3.133  1.00 16.62           C  
ATOM   1563  O   ASP A 235      14.525  37.252   2.575  1.00 17.06           O  
ATOM   1564  CB  ASP A 235      16.705  37.768   0.890  1.00 15.50           C  
ATOM   1565  CG  ASP A 235      16.877  36.259   0.839  1.00 15.09           C  
ATOM   1566  OD1 ASP A 235      17.151  35.648   1.888  1.00 15.82           O  
ATOM   1567  OD2 ASP A 235      16.743  35.684  -0.260  1.00 17.39           O  
ATOM   1568  N   ASN A 236      15.670  37.748   4.459  1.00 15.20           N  
ATOM   1569  CA  ASN A 236      14.680  37.241   5.406  1.00 16.35           C  
ATOM   1570  C   ASN A 236      14.357  35.778   5.164  1.00 18.11           C  
ATOM   1571  O   ASN A 236      13.220  35.342   5.342  1.00 16.83           O  
ATOM   1572  CB  ASN A 236      13.388  38.049   5.309  1.00 14.72           C  
ATOM   1573  CG  ASN A 236      13.626  39.525   5.444  1.00 14.35           C  
ATOM   1574  OD1 ASN A 236      13.484  40.278   4.481  1.00 14.54           O  
ATOM   1575  ND2 ASN A 236      14.006  39.953   6.639  1.00 10.95           N  
ATOM   1576  N   ASP A 237      15.362  35.001   4.802  1.00 19.47           N  
ATOM   1577  CA  ASP A 237      15.084  33.621   4.497  1.00 21.93           C  
ATOM   1578  C   ASP A 237      16.124  32.608   4.967  1.00 20.92           C  
ATOM   1579  O   ASP A 237      17.318  32.892   4.990  1.00 22.49           O  
ATOM   1580  CB  ASP A 237      14.861  33.532   2.987  1.00 25.01           C  
ATOM   1581  CG  ASP A 237      14.825  32.126   2.494  1.00 31.91           C  
ATOM   1582  OD1 ASP A 237      13.981  31.348   2.984  1.00 36.06           O  
ATOM   1583  OD2 ASP A 237      15.644  31.795   1.613  1.00 38.74           O  
ATOM   1584  N   LEU A 238      15.642  31.432   5.364  1.00 19.76           N  
ATOM   1585  CA  LEU A 238      16.487  30.326   5.816  1.00 18.24           C  
ATOM   1586  C   LEU A 238      16.224  29.148   4.883  1.00 18.74           C  
ATOM   1587  O   LEU A 238      15.082  28.923   4.468  1.00 18.94           O  
ATOM   1588  CB  LEU A 238      16.139  29.915   7.250  1.00 16.80           C  
ATOM   1589  CG  LEU A 238      16.708  30.679   8.448  1.00 16.88           C  
ATOM   1590  CD1 LEU A 238      15.909  30.321   9.685  1.00 15.64           C  
ATOM   1591  CD2 LEU A 238      18.180  30.334   8.643  1.00 15.40           C  
ATOM   1592  N   LYS A 239      17.265  28.390   4.561  1.00 17.87           N  
ATOM   1593  CA  LYS A 239      17.115  27.252   3.664  1.00 17.97           C  
ATOM   1594  C   LYS A 239      17.892  26.009   4.060  1.00 18.56           C  
ATOM   1595  O   LYS A 239      19.042  26.084   4.498  1.00 19.30           O  
ATOM   1596  CB  LYS A 239      17.507  27.655   2.239  1.00 17.52           C  
ATOM   1597  CG  LYS A 239      16.452  28.493   1.538  1.00 18.75           C  
ATOM   1598  CD  LYS A 239      16.943  29.044   0.212  1.00 15.75           C  
ATOM   1599  CE  LYS A 239      15.812  29.761  -0.512  1.00 14.12           C  
ATOM   1600  NZ  LYS A 239      16.262  30.412  -1.774  1.00 14.26           N  
ATOM   1601  N   LEU A 240      17.239  24.861   3.907  1.00 18.61           N  
ATOM   1602  CA  LEU A 240      17.851  23.577   4.204  1.00 18.19           C  
ATOM   1603  C   LEU A 240      18.248  22.984   2.859  1.00 18.74           C  
ATOM   1604  O   LEU A 240      17.384  22.715   2.025  1.00 18.86           O  
ATOM   1605  CB  LEU A 240      16.851  22.652   4.894  1.00 17.98           C  
ATOM   1606  CG  LEU A 240      17.438  21.314   5.340  1.00 18.12           C  
ATOM   1607  CD1 LEU A 240      18.407  21.539   6.496  1.00 16.72           C  
ATOM   1608  CD2 LEU A 240      16.307  20.382   5.759  1.00 19.17           C  
ATOM   1609  N   TRP A 241      19.547  22.790   2.647  1.00 18.74           N  
ATOM   1610  CA  TRP A 241      20.047  22.247   1.393  1.00 20.23           C  
ATOM   1611  C   TRP A 241      20.703  20.877   1.498  1.00 22.90           C  
ATOM   1612  O   TRP A 241      21.387  20.569   2.482  1.00 22.71           O  
ATOM   1613  CB  TRP A 241      21.097  23.173   0.774  1.00 18.90           C  
ATOM   1614  CG  TRP A 241      20.625  24.518   0.377  1.00 20.86           C  
ATOM   1615  CD1 TRP A 241      20.444  25.593   1.189  1.00 20.26           C  
ATOM   1616  CD2 TRP A 241      20.287  24.950  -0.946  1.00 21.88           C  
ATOM   1617  NE1 TRP A 241      20.017  26.672   0.458  1.00 20.62           N  
ATOM   1618  CE2 TRP A 241      19.909  26.305  -0.856  1.00 21.87           C  
ATOM   1619  CE3 TRP A 241      20.264  24.322  -2.199  1.00 22.40           C  
ATOM   1620  CZ2 TRP A 241      19.513  27.049  -1.975  1.00 23.05           C  
ATOM   1621  CZ3 TRP A 241      19.873  25.063  -3.310  1.00 22.05           C  
ATOM   1622  CH2 TRP A 241      19.502  26.410  -3.189  1.00 23.55           C  
ATOM   1623  N   ASP A 242      20.481  20.057   0.477  1.00 24.30           N  
ATOM   1624  CA  ASP A 242      21.139  18.763   0.380  1.00 27.13           C  
ATOM   1625  C   ASP A 242      22.319  19.232  -0.469  1.00 29.17           C  
ATOM   1626  O   ASP A 242      22.222  19.282  -1.693  1.00 30.15           O  
ATOM   1627  CB  ASP A 242      20.292  17.770  -0.415  1.00 27.26           C  
ATOM   1628  CG  ASP A 242      21.052  16.493  -0.748  1.00 30.38           C  
ATOM   1629  OD1 ASP A 242      22.250  16.592  -1.095  1.00 29.32           O  
ATOM   1630  OD2 ASP A 242      20.457  15.392  -0.673  1.00 31.54           O  
ATOM   1631  N   TYR A 243      23.420  19.606   0.178  1.00 30.73           N  
ATOM   1632  CA  TYR A 243      24.566  20.130  -0.554  1.00 32.78           C  
ATOM   1633  C   TYR A 243      25.120  19.223  -1.654  1.00 33.42           C  
ATOM   1634  O   TYR A 243      25.556  19.710  -2.702  1.00 33.30           O  
ATOM   1635  CB  TYR A 243      25.696  20.537   0.402  1.00 31.89           C  
ATOM   1636  CG  TYR A 243      26.287  19.415   1.220  1.00 30.74           C  
ATOM   1637  CD1 TYR A 243      25.749  19.056   2.450  1.00 31.61           C  
ATOM   1638  CD2 TYR A 243      27.398  18.718   0.760  1.00 30.84           C  
ATOM   1639  CE1 TYR A 243      26.304  18.033   3.206  1.00 31.69           C  
ATOM   1640  CE2 TYR A 243      27.958  17.688   1.501  1.00 32.50           C  
ATOM   1641  CZ  TYR A 243      27.405  17.352   2.729  1.00 33.33           C  
ATOM   1642  OH  TYR A 243      27.945  16.335   3.481  1.00 35.34           O  
ATOM   1643  N   SER A 244      25.088  17.914  -1.431  1.00 34.04           N  
ATOM   1644  CA  SER A 244      25.588  16.958  -2.417  1.00 35.93           C  
ATOM   1645  C   SER A 244      24.850  17.122  -3.746  1.00 35.79           C  
ATOM   1646  O   SER A 244      25.464  17.216  -4.809  1.00 35.53           O  
ATOM   1647  CB  SER A 244      25.388  15.529  -1.908  1.00 36.50           C  
ATOM   1648  OG  SER A 244      25.170  15.522  -0.507  1.00 41.70           O  
ATOM   1649  N   LYS A 245      23.525  17.163  -3.667  1.00 36.18           N  
ATOM   1650  CA  LYS A 245      22.676  17.297  -4.842  1.00 35.13           C  
ATOM   1651  C   LYS A 245      22.419  18.744  -5.237  1.00 34.35           C  
ATOM   1652  O   LYS A 245      21.899  19.015  -6.321  1.00 32.61           O  
ATOM   1653  CB  LYS A 245      21.341  16.604  -4.580  1.00 37.34           C  
ATOM   1654  CG  LYS A 245      21.439  15.095  -4.482  1.00 39.61           C  
ATOM   1655  CD  LYS A 245      20.202  14.493  -3.831  1.00 41.74           C  
ATOM   1656  CE  LYS A 245      19.985  13.058  -4.300  1.00 42.49           C  
ATOM   1657  NZ  LYS A 245      21.252  12.267  -4.323  1.00 41.60           N  
ATOM   1658  N   GLY A 246      22.779  19.673  -4.361  1.00 33.24           N  
ATOM   1659  CA  GLY A 246      22.543  21.069  -4.666  1.00 31.32           C  
ATOM   1660  C   GLY A 246      21.051  21.303  -4.789  1.00 30.72           C  
ATOM   1661  O   GLY A 246      20.588  22.001  -5.691  1.00 31.22           O  
ATOM   1662  N   LYS A 247      20.292  20.702  -3.881  1.00 29.96           N  
ATOM   1663  CA  LYS A 247      18.843  20.846  -3.880  1.00 29.86           C  
ATOM   1664  C   LYS A 247      18.320  21.425  -2.574  1.00 27.95           C  
ATOM   1665  O   LYS A 247      18.762  21.043  -1.489  1.00 25.54           O  
ATOM   1666  CB  LYS A 247      18.172  19.493  -4.140  1.00 32.49           C  
ATOM   1667  CG  LYS A 247      18.058  19.134  -5.614  1.00 38.23           C  
ATOM   1668  CD  LYS A 247      17.170  20.137  -6.345  1.00 41.38           C  
ATOM   1669  CE  LYS A 247      17.070  19.826  -7.835  1.00 43.37           C  
ATOM   1670  NZ  LYS A 247      16.278  20.863  -8.567  1.00 44.84           N  
ATOM   1671  N   CYS A 248      17.376  22.355  -2.701  1.00 25.36           N  
ATOM   1672  CA  CYS A 248      16.753  23.000  -1.556  1.00 23.82           C  
ATOM   1673  C   CYS A 248      15.535  22.164  -1.163  1.00 23.03           C  
ATOM   1674  O   CYS A 248      14.573  22.068  -1.923  1.00 22.87           O  
ATOM   1675  CB  CYS A 248      16.321  24.420  -1.933  1.00 23.66           C  
ATOM   1676  SG  CYS A 248      15.444  25.327  -0.630  1.00 23.47           S  
ATOM   1677  N   LEU A 249      15.580  21.565   0.023  1.00 21.63           N  
ATOM   1678  CA  LEU A 249      14.486  20.722   0.494  1.00 22.68           C  
ATOM   1679  C   LEU A 249      13.402  21.466   1.269  1.00 23.08           C  
ATOM   1680  O   LEU A 249      12.225  21.105   1.209  1.00 24.10           O  
ATOM   1681  CB  LEU A 249      15.036  19.602   1.378  1.00 23.42           C  
ATOM   1682  CG  LEU A 249      16.201  18.811   0.782  1.00 23.91           C  
ATOM   1683  CD1 LEU A 249      16.691  17.805   1.796  1.00 25.95           C  
ATOM   1684  CD2 LEU A 249      15.755  18.113  -0.489  1.00 25.13           C  
ATOM   1685  N   LYS A 250      13.800  22.498   2.006  1.00 22.31           N  
ATOM   1686  CA  LYS A 250      12.860  23.265   2.810  1.00 21.18           C  
ATOM   1687  C   LYS A 250      13.280  24.722   2.907  1.00 22.71           C  
ATOM   1688  O   LYS A 250      14.449  25.073   2.706  1.00 20.85           O  
ATOM   1689  CB  LYS A 250      12.774  22.688   4.225  1.00 19.43           C  
ATOM   1690  CG  LYS A 250      12.409  21.214   4.288  1.00 21.52           C  
ATOM   1691  CD  LYS A 250      10.957  20.978   3.908  1.00 22.31           C  
ATOM   1692  CE  LYS A 250      10.578  19.515   4.064  1.00 23.01           C  
ATOM   1693  NZ  LYS A 250       9.159  19.278   3.682  1.00 24.67           N  
ATOM   1694  N   THR A 251      12.310  25.562   3.238  1.00 21.70           N  
ATOM   1695  CA  THR A 251      12.534  26.986   3.378  1.00 19.76           C  
ATOM   1696  C   THR A 251      11.799  27.409   4.638  1.00 19.08           C  
ATOM   1697  O   THR A 251      10.764  26.840   4.977  1.00 19.81           O  
ATOM   1698  CB  THR A 251      11.985  27.735   2.142  1.00 20.37           C  
ATOM   1699  OG1 THR A 251      12.855  27.500   1.026  1.00 22.58           O  
ATOM   1700  CG2 THR A 251      11.894  29.214   2.394  1.00 22.81           C  
ATOM   1701  N   TYR A 252      12.345  28.383   5.352  1.00 17.51           N  
ATOM   1702  CA  TYR A 252      11.718  28.864   6.575  1.00 17.03           C  
ATOM   1703  C   TYR A 252      11.737  30.379   6.496  1.00 17.08           C  
ATOM   1704  O   TYR A 252      12.804  31.000   6.426  1.00 16.43           O  
ATOM   1705  CB  TYR A 252      12.489  28.358   7.797  1.00 15.39           C  
ATOM   1706  CG  TYR A 252      12.684  26.857   7.778  1.00 16.50           C  
ATOM   1707  CD1 TYR A 252      11.676  25.986   8.201  1.00 16.52           C  
ATOM   1708  CD2 TYR A 252      13.854  26.305   7.267  1.00 15.91           C  
ATOM   1709  CE1 TYR A 252      11.833  24.599   8.108  1.00 15.98           C  
ATOM   1710  CE2 TYR A 252      14.019  24.934   7.168  1.00 17.55           C  
ATOM   1711  CZ  TYR A 252      13.011  24.085   7.586  1.00 17.04           C  
ATOM   1712  OH  TYR A 252      13.196  22.732   7.453  1.00 16.34           O  
ATOM   1713  N   THR A 253      10.546  30.966   6.475  1.00 16.11           N  
ATOM   1714  CA  THR A 253      10.412  32.408   6.372  1.00 16.17           C  
ATOM   1715  C   THR A 253       9.389  32.946   7.365  1.00 16.11           C  
ATOM   1716  O   THR A 253       8.765  32.183   8.105  1.00 15.39           O  
ATOM   1717  CB  THR A 253      10.003  32.808   4.932  1.00 17.67           C  
ATOM   1718  OG1 THR A 253       8.771  32.166   4.585  1.00 18.03           O  
ATOM   1719  CG2 THR A 253      11.075  32.381   3.938  1.00 16.80           C  
ATOM   1720  N   GLY A 254       9.233  34.265   7.384  1.00 16.52           N  
ATOM   1721  CA  GLY A 254       8.294  34.872   8.301  1.00 19.71           C  
ATOM   1722  C   GLY A 254       8.985  35.753   9.321  1.00 20.79           C  
ATOM   1723  O   GLY A 254       8.392  36.699   9.834  1.00 21.84           O  
ATOM   1724  N   HIS A 255      10.239  35.434   9.627  1.00 19.81           N  
ATOM   1725  CA  HIS A 255      11.016  36.215  10.582  1.00 20.39           C  
ATOM   1726  C   HIS A 255      11.633  37.407   9.849  1.00 21.26           C  
ATOM   1727  O   HIS A 255      11.370  37.624   8.665  1.00 22.50           O  
ATOM   1728  CB  HIS A 255      12.124  35.356  11.194  1.00 18.66           C  
ATOM   1729  CG  HIS A 255      13.054  34.774  10.180  1.00 19.61           C  
ATOM   1730  ND1 HIS A 255      14.421  34.740  10.357  1.00 21.68           N  
ATOM   1731  CD2 HIS A 255      12.817  34.225   8.965  1.00 20.70           C  
ATOM   1732  CE1 HIS A 255      14.984  34.201   9.291  1.00 20.91           C  
ATOM   1733  NE2 HIS A 255      14.034  33.879   8.433  1.00 20.32           N  
ATOM   1734  N   LYS A 256      12.456  38.180  10.544  1.00 22.67           N  
ATOM   1735  CA  LYS A 256      13.091  39.342   9.930  1.00 22.08           C  
ATOM   1736  C   LYS A 256      14.597  39.219  10.009  1.00 21.36           C  
ATOM   1737  O   LYS A 256      15.167  39.216  11.098  1.00 21.32           O  
ATOM   1738  CB  LYS A 256      12.647  40.621  10.638  1.00 26.06           C  
ATOM   1739  CG  LYS A 256      11.146  40.837  10.608  1.00 30.47           C  
ATOM   1740  CD  LYS A 256      10.771  42.057   9.784  1.00 33.52           C  
ATOM   1741  CE  LYS A 256       9.303  42.014   9.411  1.00 33.72           C  
ATOM   1742  NZ  LYS A 256       9.048  40.851   8.515  1.00 34.57           N  
ATOM   1743  N   ASN A 257      15.238  39.099   8.855  1.00 18.65           N  
ATOM   1744  CA  ASN A 257      16.675  38.987   8.833  1.00 17.44           C  
ATOM   1745  C   ASN A 257      17.295  39.526   7.554  1.00 18.35           C  
ATOM   1746  O   ASN A 257      17.430  38.798   6.562  1.00 18.19           O  
ATOM   1747  CB  ASN A 257      17.115  37.540   9.052  1.00 15.57           C  
ATOM   1748  CG  ASN A 257      18.613  37.425   9.224  1.00 17.17           C  
ATOM   1749  OD1 ASN A 257      19.280  38.383   9.639  1.00 18.30           O  
ATOM   1750  ND2 ASN A 257      19.151  36.253   8.942  1.00 14.32           N  
ATOM   1751  N   GLU A 258      17.658  40.806   7.581  1.00 17.93           N  
ATOM   1752  CA  GLU A 258      18.289  41.426   6.430  1.00 22.12           C  
ATOM   1753  C   GLU A 258      19.472  42.298   6.847  1.00 21.35           C  
ATOM   1754  O   GLU A 258      20.027  42.995   5.987  1.00 23.64           O  
ATOM   1755  CB  GLU A 258      17.304  42.303   5.637  1.00 24.31           C  
ATOM   1756  CG  GLU A 258      15.883  42.358   6.143  1.00 28.06           C  
ATOM   1757  CD  GLU A 258      15.046  43.355   5.346  1.00 29.37           C  
ATOM   1758  OE1 GLU A 258      15.080  44.565   5.661  1.00 27.15           O  
ATOM   1759  OE2 GLU A 258      14.358  42.922   4.398  1.00 30.75           O  
ATOM   1760  N   LYS A 259      19.859  42.258   8.127  1.00 21.34           N  
ATOM   1761  CA  LYS A 259      20.955  43.112   8.546  1.00 21.34           C  
ATOM   1762  C   LYS A 259      22.065  42.408   9.327  1.00 21.18           C  
ATOM   1763  O   LYS A 259      23.247  42.629   9.061  1.00 21.72           O  
ATOM   1764  CB  LYS A 259      20.410  44.266   9.381  1.00 25.68           C  
ATOM   1765  CG  LYS A 259      19.268  45.044   8.722  1.00 30.20           C  
ATOM   1766  CD  LYS A 259      18.733  46.137   9.644  1.00 35.88           C  
ATOM   1767  CE  LYS A 259      17.502  46.825   9.059  1.00 39.50           C  
ATOM   1768  NZ  LYS A 259      17.017  47.964   9.902  1.00 41.54           N  
ATOM   1769  N   TYR A 260      21.697  41.574  10.298  1.00 18.40           N  
ATOM   1770  CA  TYR A 260      22.703  40.893  11.119  1.00 18.36           C  
ATOM   1771  C   TYR A 260      22.870  39.408  10.826  1.00 17.79           C  
ATOM   1772  O   TYR A 260      21.982  38.759  10.264  1.00 15.67           O  
ATOM   1773  CB  TYR A 260      22.365  41.056  12.605  1.00 17.14           C  
ATOM   1774  CG  TYR A 260      22.219  42.489  13.051  1.00 18.31           C  
ATOM   1775  CD1 TYR A 260      23.323  43.228  13.488  1.00 18.67           C  
ATOM   1776  CD2 TYR A 260      20.979  43.122  12.998  1.00 18.54           C  
ATOM   1777  CE1 TYR A 260      23.191  44.564  13.857  1.00 17.14           C  
ATOM   1778  CE2 TYR A 260      20.835  44.452  13.361  1.00 18.52           C  
ATOM   1779  CZ  TYR A 260      21.939  45.166  13.787  1.00 18.18           C  
ATOM   1780  OH  TYR A 260      21.785  46.485  14.132  1.00 18.75           O  
ATOM   1781  N   CYS A 261      24.026  38.884  11.220  1.00 16.44           N  
ATOM   1782  CA  CYS A 261      24.336  37.467  11.059  1.00 18.33           C  
ATOM   1783  C   CYS A 261      23.784  36.716  12.273  1.00 17.62           C  
ATOM   1784  O   CYS A 261      24.463  36.542  13.290  1.00 19.49           O  
ATOM   1785  CB  CYS A 261      25.849  37.258  10.953  1.00 16.80           C  
ATOM   1786  SG  CYS A 261      26.550  37.926   9.440  1.00 16.67           S  
ATOM   1787  N   ILE A 262      22.541  36.275  12.151  1.00 17.13           N  
ATOM   1788  CA  ILE A 262      21.843  35.573  13.214  1.00 15.83           C  
ATOM   1789  C   ILE A 262      21.998  34.054  13.163  1.00 16.17           C  
ATOM   1790  O   ILE A 262      21.772  33.426  12.129  1.00 15.17           O  
ATOM   1791  CB  ILE A 262      20.349  35.929  13.166  1.00 15.17           C  
ATOM   1792  CG1 ILE A 262      20.192  37.447  13.322  1.00 14.79           C  
ATOM   1793  CG2 ILE A 262      19.589  35.161  14.237  1.00 12.59           C  
ATOM   1794  CD1 ILE A 262      18.748  37.933  13.276  1.00 15.18           C  
ATOM   1795  N   PHE A 263      22.386  33.480  14.295  1.00 15.40           N  
ATOM   1796  CA  PHE A 263      22.560  32.042  14.412  1.00 18.46           C  
ATOM   1797  C   PHE A 263      21.236  31.310  14.195  1.00 19.37           C  
ATOM   1798  O   PHE A 263      20.176  31.845  14.501  1.00 21.74           O  
ATOM   1799  CB  PHE A 263      23.104  31.668  15.800  1.00 16.55           C  
ATOM   1800  CG  PHE A 263      24.519  32.126  16.052  1.00 15.65           C  
ATOM   1801  CD1 PHE A 263      24.788  33.398  16.553  1.00 16.28           C  
ATOM   1802  CD2 PHE A 263      25.587  31.272  15.792  1.00 14.47           C  
ATOM   1803  CE1 PHE A 263      26.104  33.807  16.797  1.00 16.40           C  
ATOM   1804  CE2 PHE A 263      26.908  31.673  16.028  1.00 15.39           C  
ATOM   1805  CZ  PHE A 263      27.165  32.939  16.531  1.00 16.38           C  
ATOM   1806  N   ALA A 264      21.301  30.092  13.666  1.00 19.26           N  
ATOM   1807  CA  ALA A 264      20.108  29.276  13.445  1.00 18.75           C  
ATOM   1808  C   ALA A 264      20.428  27.897  14.005  1.00 19.19           C  
ATOM   1809  O   ALA A 264      21.591  27.501  14.048  1.00 17.50           O  
ATOM   1810  CB  ALA A 264      19.795  29.186  11.968  1.00 17.54           C  
ATOM   1811  N   ASN A 265      19.412  27.156  14.432  1.00 18.84           N  
ATOM   1812  CA  ASN A 265      19.686  25.843  15.006  1.00 19.99           C  
ATOM   1813  C   ASN A 265      18.720  24.748  14.585  1.00 20.49           C  
ATOM   1814  O   ASN A 265      17.671  24.999  14.000  1.00 18.91           O  
ATOM   1815  CB  ASN A 265      19.650  25.910  16.541  1.00 17.90           C  
ATOM   1816  CG  ASN A 265      20.406  27.105  17.110  1.00 22.45           C  
ATOM   1817  OD1 ASN A 265      21.635  27.148  17.097  1.00 22.30           O  
ATOM   1818  ND2 ASN A 265      19.662  28.081  17.616  1.00 23.58           N  
ATOM   1819  N   PHE A 266      19.116  23.525  14.918  1.00 20.99           N  
ATOM   1820  CA  PHE A 266      18.329  22.326  14.705  1.00 20.69           C  
ATOM   1821  C   PHE A 266      17.989  21.927  16.136  1.00 22.82           C  
ATOM   1822  O   PHE A 266      18.892  21.739  16.960  1.00 22.17           O  
ATOM   1823  CB  PHE A 266      19.172  21.217  14.069  1.00 18.96           C  
ATOM   1824  CG  PHE A 266      19.339  21.352  12.586  1.00 15.68           C  
ATOM   1825  CD1 PHE A 266      18.387  20.841  11.716  1.00 14.21           C  
ATOM   1826  CD2 PHE A 266      20.452  21.992  12.056  1.00 14.40           C  
ATOM   1827  CE1 PHE A 266      18.544  20.965  10.335  1.00 15.11           C  
ATOM   1828  CE2 PHE A 266      20.618  22.123  10.686  1.00 11.96           C  
ATOM   1829  CZ  PHE A 266      19.665  21.610   9.821  1.00 12.46           C  
ATOM   1830  N   SER A 267      16.699  21.843  16.444  1.00 23.39           N  
ATOM   1831  CA  SER A 267      16.260  21.438  17.775  1.00 24.79           C  
ATOM   1832  C   SER A 267      15.747  20.013  17.612  1.00 25.80           C  
ATOM   1833  O   SER A 267      14.689  19.789  17.023  1.00 24.24           O  
ATOM   1834  CB  SER A 267      15.146  22.355  18.271  1.00 23.77           C  
ATOM   1835  OG  SER A 267      14.673  21.919  19.527  1.00 23.45           O  
ATOM   1836  N   VAL A 268      16.501  19.052  18.133  1.00 27.32           N  
ATOM   1837  CA  VAL A 268      16.142  17.645  17.990  1.00 29.10           C  
ATOM   1838  C   VAL A 268      15.856  16.877  19.284  1.00 30.12           C  
ATOM   1839  O   VAL A 268      15.608  15.669  19.246  1.00 30.06           O  
ATOM   1840  CB  VAL A 268      17.255  16.902  17.227  1.00 28.45           C  
ATOM   1841  CG1 VAL A 268      17.442  17.534  15.862  1.00 28.77           C  
ATOM   1842  CG2 VAL A 268      18.562  16.970  18.011  1.00 27.95           C  
ATOM   1843  N   THR A 269      15.882  17.566  20.420  1.00 29.32           N  
ATOM   1844  CA  THR A 269      15.638  16.908  21.694  1.00 28.58           C  
ATOM   1845  C   THR A 269      14.210  16.395  21.837  1.00 28.26           C  
ATOM   1846  O   THR A 269      13.980  15.340  22.425  1.00 28.79           O  
ATOM   1847  CB  THR A 269      15.967  17.842  22.870  1.00 29.42           C  
ATOM   1848  OG1 THR A 269      15.269  19.083  22.711  1.00 27.66           O  
ATOM   1849  CG2 THR A 269      17.461  18.099  22.930  1.00 29.92           C  
ATOM   1850  N   GLY A 270      13.253  17.149  21.310  1.00 27.40           N  
ATOM   1851  CA  GLY A 270      11.858  16.740  21.368  1.00 27.46           C  
ATOM   1852  C   GLY A 270      11.350  16.636  19.942  1.00 26.65           C  
ATOM   1853  O   GLY A 270      11.800  15.782  19.182  1.00 27.38           O  
ATOM   1854  N   GLY A 271      10.412  17.497  19.574  1.00 25.99           N  
ATOM   1855  CA  GLY A 271       9.928  17.483  18.211  1.00 27.91           C  
ATOM   1856  C   GLY A 271      11.055  18.093  17.393  1.00 28.21           C  
ATOM   1857  O   GLY A 271      11.918  18.765  17.958  1.00 28.43           O  
ATOM   1858  N   LYS A 272      11.061  17.875  16.083  1.00 27.19           N  
ATOM   1859  CA  LYS A 272      12.112  18.421  15.236  1.00 25.91           C  
ATOM   1860  C   LYS A 272      11.783  19.831  14.776  1.00 24.75           C  
ATOM   1861  O   LYS A 272      10.890  20.043  13.950  1.00 24.58           O  
ATOM   1862  CB  LYS A 272      12.345  17.503  14.037  1.00 27.81           C  
ATOM   1863  CG  LYS A 272      12.787  16.113  14.447  1.00 28.63           C  
ATOM   1864  CD  LYS A 272      14.026  16.195  15.322  1.00 32.65           C  
ATOM   1865  CE  LYS A 272      14.445  14.837  15.870  1.00 35.55           C  
ATOM   1866  NZ  LYS A 272      13.530  14.345  16.941  1.00 38.44           N  
ATOM   1867  N   TRP A 273      12.514  20.799  15.316  1.00 21.80           N  
ATOM   1868  CA  TRP A 273      12.275  22.191  14.969  1.00 20.99           C  
ATOM   1869  C   TRP A 273      13.501  22.901  14.438  1.00 19.20           C  
ATOM   1870  O   TRP A 273      14.630  22.426  14.571  1.00 17.69           O  
ATOM   1871  CB  TRP A 273      11.803  22.974  16.189  1.00 22.02           C  
ATOM   1872  CG  TRP A 273      10.959  22.206  17.147  1.00 23.31           C  
ATOM   1873  CD1 TRP A 273      11.283  21.852  18.423  1.00 23.08           C  
ATOM   1874  CD2 TRP A 273       9.621  21.758  16.934  1.00 23.28           C  
ATOM   1875  NE1 TRP A 273      10.225  21.222  19.023  1.00 23.43           N  
ATOM   1876  CE2 TRP A 273       9.187  21.156  18.133  1.00 23.71           C  
ATOM   1877  CE3 TRP A 273       8.738  21.823  15.849  1.00 23.99           C  
ATOM   1878  CZ2 TRP A 273       7.912  20.607  18.275  1.00 24.92           C  
ATOM   1879  CZ3 TRP A 273       7.471  21.281  15.987  1.00 22.96           C  
ATOM   1880  CH2 TRP A 273       7.066  20.686  17.196  1.00 26.33           C  
ATOM   1881  N   ILE A 274      13.248  24.056  13.838  1.00 17.79           N  
ATOM   1882  CA  ILE A 274      14.289  24.925  13.330  1.00 17.01           C  
ATOM   1883  C   ILE A 274      14.122  26.163  14.201  1.00 17.13           C  
ATOM   1884  O   ILE A 274      13.026  26.723  14.288  1.00 16.60           O  
ATOM   1885  CB  ILE A 274      14.063  25.325  11.862  1.00 16.96           C  
ATOM   1886  CG1 ILE A 274      14.350  24.138  10.937  1.00 15.49           C  
ATOM   1887  CG2 ILE A 274      14.947  26.526  11.519  1.00 16.90           C  
ATOM   1888  CD1 ILE A 274      15.778  23.644  10.984  1.00 13.64           C  
ATOM   1889  N   VAL A 275      15.199  26.574  14.861  1.00 16.38           N  
ATOM   1890  CA  VAL A 275      15.155  27.734  15.739  1.00 14.92           C  
ATOM   1891  C   VAL A 275      16.084  28.856  15.272  1.00 14.48           C  
ATOM   1892  O   VAL A 275      17.191  28.606  14.812  1.00 14.91           O  
ATOM   1893  CB  VAL A 275      15.537  27.337  17.172  1.00 12.87           C  
ATOM   1894  CG1 VAL A 275      15.535  28.566  18.065  1.00 16.22           C  
ATOM   1895  CG2 VAL A 275      14.563  26.310  17.693  1.00 12.46           C  
ATOM   1896  N   SER A 276      15.625  30.092  15.403  1.00 15.86           N  
ATOM   1897  CA  SER A 276      16.422  31.233  14.989  1.00 15.58           C  
ATOM   1898  C   SER A 276      15.963  32.537  15.619  1.00 16.62           C  
ATOM   1899  O   SER A 276      14.779  32.722  15.914  1.00 16.61           O  
ATOM   1900  CB  SER A 276      16.380  31.372  13.461  1.00 14.94           C  
ATOM   1901  OG  SER A 276      16.903  32.619  13.040  1.00 15.11           O  
ATOM   1902  N   GLY A 277      16.917  33.440  15.822  1.00 16.25           N  
ATOM   1903  CA  GLY A 277      16.592  34.743  16.368  1.00 15.69           C  
ATOM   1904  C   GLY A 277      15.973  35.544  15.235  1.00 15.07           C  
ATOM   1905  O   GLY A 277      15.857  35.040  14.121  1.00 15.60           O  
ATOM   1906  N   SER A 278      15.582  36.784  15.500  1.00 14.96           N  
ATOM   1907  CA  SER A 278      14.965  37.625  14.477  1.00 14.52           C  
ATOM   1908  C   SER A 278      15.141  39.103  14.812  1.00 14.42           C  
ATOM   1909  O   SER A 278      15.201  39.479  15.982  1.00 15.41           O  
ATOM   1910  CB  SER A 278      13.473  37.281  14.356  1.00 11.42           C  
ATOM   1911  OG  SER A 278      12.823  38.110  13.409  1.00 13.04           O  
ATOM   1912  N   GLU A 279      15.208  39.939  13.778  1.00 15.77           N  
ATOM   1913  CA  GLU A 279      15.399  41.372  13.962  1.00 16.35           C  
ATOM   1914  C   GLU A 279      14.176  42.125  14.494  1.00 17.97           C  
ATOM   1915  O   GLU A 279      14.223  43.339  14.688  1.00 18.87           O  
ATOM   1916  CB  GLU A 279      15.901  41.999  12.657  1.00 16.32           C  
ATOM   1917  CG  GLU A 279      17.379  41.697  12.374  1.00 14.47           C  
ATOM   1918  CD  GLU A 279      17.728  41.722  10.891  1.00 17.18           C  
ATOM   1919  OE1 GLU A 279      16.942  42.281  10.092  1.00 18.37           O  
ATOM   1920  OE2 GLU A 279      18.797  41.184  10.527  1.00 15.20           O  
ATOM   1921  N   ASP A 280      13.083  41.408  14.728  1.00 19.51           N  
ATOM   1922  CA  ASP A 280      11.891  42.036  15.277  1.00 19.99           C  
ATOM   1923  C   ASP A 280      11.771  41.673  16.762  1.00 20.28           C  
ATOM   1924  O   ASP A 280      10.679  41.687  17.329  1.00 21.92           O  
ATOM   1925  CB  ASP A 280      10.635  41.597  14.525  1.00 19.21           C  
ATOM   1926  CG  ASP A 280      10.469  40.094  14.487  1.00 19.13           C  
ATOM   1927  OD1 ASP A 280      11.208  39.378  15.190  1.00 18.38           O  
ATOM   1928  OD2 ASP A 280       9.580  39.624  13.752  1.00 23.32           O  
ATOM   1929  N   ASN A 281      12.903  41.315  17.366  1.00 18.01           N  
ATOM   1930  CA  ASN A 281      12.983  40.998  18.794  1.00 18.45           C  
ATOM   1931  C   ASN A 281      12.405  39.669  19.288  1.00 19.20           C  
ATOM   1932  O   ASN A 281      12.301  39.454  20.500  1.00 17.02           O  
ATOM   1933  CB  ASN A 281      12.351  42.134  19.608  1.00 18.83           C  
ATOM   1934  CG  ASN A 281      12.979  43.492  19.309  1.00 20.40           C  
ATOM   1935  OD1 ASN A 281      13.846  43.618  18.446  1.00 17.88           O  
ATOM   1936  ND2 ASN A 281      12.530  44.517  20.026  1.00 22.00           N  
ATOM   1937  N   MET A 282      12.037  38.776  18.376  1.00 19.26           N  
ATOM   1938  CA  MET A 282      11.477  37.495  18.785  1.00 18.33           C  
ATOM   1939  C   MET A 282      12.325  36.305  18.360  1.00 19.31           C  
ATOM   1940  O   MET A 282      13.214  36.410  17.516  1.00 19.95           O  
ATOM   1941  CB  MET A 282      10.052  37.322  18.230  1.00 15.95           C  
ATOM   1942  CG  MET A 282       9.005  38.236  18.857  1.00 16.89           C  
ATOM   1943  SD  MET A 282       7.379  38.096  18.088  1.00 10.98           S  
ATOM   1944  CE  MET A 282       7.524  39.203  16.773  1.00 13.18           C  
ATOM   1945  N   VAL A 283      12.041  35.169  18.982  1.00 20.51           N  
ATOM   1946  CA  VAL A 283      12.716  33.920  18.680  1.00 19.22           C  
ATOM   1947  C   VAL A 283      11.713  33.146  17.835  1.00 20.64           C  
ATOM   1948  O   VAL A 283      10.551  33.015  18.222  1.00 22.49           O  
ATOM   1949  CB  VAL A 283      13.007  33.114  19.967  1.00 18.49           C  
ATOM   1950  CG1 VAL A 283      13.502  31.724  19.608  1.00 15.86           C  
ATOM   1951  CG2 VAL A 283      14.042  33.851  20.831  1.00 18.56           C  
ATOM   1952  N   TYR A 284      12.134  32.647  16.681  1.00 19.71           N  
ATOM   1953  CA  TYR A 284      11.209  31.891  15.846  1.00 19.49           C  
ATOM   1954  C   TYR A 284      11.479  30.400  15.888  1.00 20.48           C  
ATOM   1955  O   TYR A 284      12.628  29.960  15.871  1.00 22.55           O  
ATOM   1956  CB  TYR A 284      11.259  32.379  14.400  1.00 17.36           C  
ATOM   1957  CG  TYR A 284      10.470  33.641  14.139  1.00 15.05           C  
ATOM   1958  CD1 TYR A 284      10.831  34.845  14.735  1.00 16.60           C  
ATOM   1959  CD2 TYR A 284       9.381  33.636  13.263  1.00 15.39           C  
ATOM   1960  CE1 TYR A 284      10.136  36.027  14.462  1.00 15.17           C  
ATOM   1961  CE2 TYR A 284       8.676  34.817  12.978  1.00 16.47           C  
ATOM   1962  CZ  TYR A 284       9.066  36.009  13.582  1.00 16.87           C  
ATOM   1963  OH  TYR A 284       8.423  37.188  13.275  1.00 14.08           O  
ATOM   1964  N   ILE A 285      10.406  29.621  15.953  1.00 21.62           N  
ATOM   1965  CA  ILE A 285      10.508  28.173  15.991  1.00 21.75           C  
ATOM   1966  C   ILE A 285       9.607  27.616  14.898  1.00 22.84           C  
ATOM   1967  O   ILE A 285       8.394  27.834  14.904  1.00 23.07           O  
ATOM   1968  CB  ILE A 285      10.075  27.623  17.367  1.00 21.82           C  
ATOM   1969  CG1 ILE A 285      10.862  28.336  18.473  1.00 21.76           C  
ATOM   1970  CG2 ILE A 285      10.344  26.128  17.442  1.00 20.14           C  
ATOM   1971  CD1 ILE A 285      10.496  27.899  19.877  1.00 23.37           C  
ATOM   1972  N   TRP A 286      10.216  26.903  13.954  1.00 22.32           N  
ATOM   1973  CA  TRP A 286       9.500  26.325  12.820  1.00 20.35           C  
ATOM   1974  C   TRP A 286       9.413  24.813  12.895  1.00 21.19           C  
ATOM   1975  O   TRP A 286      10.278  24.160  13.479  1.00 21.92           O  
ATOM   1976  CB  TRP A 286      10.229  26.640  11.510  1.00 17.87           C  
ATOM   1977  CG  TRP A 286      10.222  28.044  11.052  1.00 16.52           C  
ATOM   1978  CD1 TRP A 286       9.346  28.616  10.180  1.00 15.16           C  
ATOM   1979  CD2 TRP A 286      11.190  29.046  11.365  1.00 15.84           C  
ATOM   1980  NE1 TRP A 286       9.712  29.914   9.921  1.00 13.90           N  
ATOM   1981  CE2 TRP A 286      10.842  30.204  10.640  1.00 15.20           C  
ATOM   1982  CE3 TRP A 286      12.322  29.080  12.193  1.00 16.23           C  
ATOM   1983  CZ2 TRP A 286      11.585  31.382  10.709  1.00 15.78           C  
ATOM   1984  CZ3 TRP A 286      13.061  30.253  12.264  1.00 14.04           C  
ATOM   1985  CH2 TRP A 286      12.687  31.387  11.528  1.00 15.54           C  
ATOM   1986  N   ASN A 287       8.376  24.256  12.281  1.00 20.97           N  
ATOM   1987  CA  ASN A 287       8.258  22.807  12.215  1.00 22.09           C  
ATOM   1988  C   ASN A 287       9.229  22.519  11.074  1.00 22.16           C  
ATOM   1989  O   ASN A 287       9.105  23.107  10.002  1.00 23.30           O  
ATOM   1990  CB  ASN A 287       6.843  22.386  11.817  1.00 22.73           C  
ATOM   1991  CG  ASN A 287       6.702  20.883  11.691  1.00 24.22           C  
ATOM   1992  OD1 ASN A 287       7.415  20.243  10.912  1.00 24.87           O  
ATOM   1993  ND2 ASN A 287       5.784  20.312  12.457  1.00 25.01           N  
ATOM   1994  N   LEU A 288      10.201  21.643  11.300  1.00 22.33           N  
ATOM   1995  CA  LEU A 288      11.199  21.347  10.275  1.00 22.19           C  
ATOM   1996  C   LEU A 288      10.634  20.769   8.978  1.00 23.19           C  
ATOM   1997  O   LEU A 288      11.067  21.146   7.888  1.00 22.09           O  
ATOM   1998  CB  LEU A 288      12.272  20.411  10.848  1.00 22.82           C  
ATOM   1999  CG  LEU A 288      13.586  20.266  10.076  1.00 23.53           C  
ATOM   2000  CD1 LEU A 288      14.654  19.677  10.986  1.00 24.40           C  
ATOM   2001  CD2 LEU A 288      13.380  19.400   8.844  1.00 25.26           C  
ATOM   2002  N   GLN A 289       9.663  19.867   9.095  1.00 24.77           N  
ATOM   2003  CA  GLN A 289       9.056  19.226   7.929  1.00 25.19           C  
ATOM   2004  C   GLN A 289       8.015  20.057   7.195  1.00 25.06           C  
ATOM   2005  O   GLN A 289       8.017  20.107   5.969  1.00 26.37           O  
ATOM   2006  CB  GLN A 289       8.418  17.898   8.327  1.00 27.08           C  
ATOM   2007  CG  GLN A 289       9.406  16.817   8.705  1.00 30.51           C  
ATOM   2008  CD  GLN A 289      10.363  16.490   7.579  1.00 32.14           C  
ATOM   2009  OE1 GLN A 289       9.959  16.342   6.427  1.00 35.35           O  
ATOM   2010  NE2 GLN A 289      11.642  16.360   7.909  1.00 33.82           N  
ATOM   2011  N   THR A 290       7.116  20.695   7.936  1.00 25.53           N  
ATOM   2012  CA  THR A 290       6.059  21.484   7.316  1.00 24.88           C  
ATOM   2013  C   THR A 290       6.436  22.941   7.060  1.00 26.13           C  
ATOM   2014  O   THR A 290       5.704  23.660   6.385  1.00 27.09           O  
ATOM   2015  CB  THR A 290       4.767  21.440   8.168  1.00 25.08           C  
ATOM   2016  OG1 THR A 290       4.969  22.142   9.399  1.00 24.83           O  
ATOM   2017  CG2 THR A 290       4.395  20.006   8.493  1.00 24.69           C  
ATOM   2018  N   LYS A 291       7.572  23.375   7.603  1.00 25.45           N  
ATOM   2019  CA  LYS A 291       8.038  24.751   7.416  1.00 26.08           C  
ATOM   2020  C   LYS A 291       7.090  25.746   8.070  1.00 26.96           C  
ATOM   2021  O   LYS A 291       7.171  26.951   7.839  1.00 26.71           O  
ATOM   2022  CB  LYS A 291       8.141  25.076   5.923  1.00 24.44           C  
ATOM   2023  CG  LYS A 291       9.072  24.164   5.148  1.00 24.68           C  
ATOM   2024  CD  LYS A 291       9.061  24.502   3.664  1.00 25.01           C  
ATOM   2025  CE  LYS A 291       7.718  24.177   3.025  1.00 26.36           C  
ATOM   2026  NZ  LYS A 291       7.658  24.642   1.610  1.00 28.68           N  
ATOM   2027  N   GLU A 292       6.198  25.231   8.899  1.00 28.84           N  
ATOM   2028  CA  GLU A 292       5.200  26.051   9.567  1.00 30.94           C  
ATOM   2029  C   GLU A 292       5.730  26.634  10.872  1.00 29.77           C  
ATOM   2030  O   GLU A 292       6.392  25.940  11.640  1.00 29.07           O  
ATOM   2031  CB  GLU A 292       3.974  25.174   9.822  1.00 34.59           C  
ATOM   2032  CG  GLU A 292       2.705  25.877  10.216  1.00 39.31           C  
ATOM   2033  CD  GLU A 292       1.518  24.932  10.149  1.00 42.03           C  
ATOM   2034  OE1 GLU A 292       1.096  24.591   9.021  1.00 40.29           O  
ATOM   2035  OE2 GLU A 292       1.023  24.512  11.218  1.00 45.23           O  
ATOM   2036  N   ILE A 293       5.457  27.914  11.112  1.00 29.64           N  
ATOM   2037  CA  ILE A 293       5.901  28.563  12.345  1.00 28.60           C  
ATOM   2038  C   ILE A 293       5.030  28.035  13.476  1.00 28.94           C  
ATOM   2039  O   ILE A 293       3.818  28.245  13.481  1.00 30.46           O  
ATOM   2040  CB  ILE A 293       5.743  30.097  12.277  1.00 26.85           C  
ATOM   2041  CG1 ILE A 293       6.703  30.681  11.238  1.00 24.67           C  
ATOM   2042  CG2 ILE A 293       6.011  30.705  13.649  1.00 28.65           C  
ATOM   2043  CD1 ILE A 293       6.674  32.201  11.159  1.00 22.51           C  
ATOM   2044  N   VAL A 294       5.640  27.344  14.431  1.00 28.94           N  
ATOM   2045  CA  VAL A 294       4.886  26.781  15.541  1.00 29.33           C  
ATOM   2046  C   VAL A 294       4.929  27.588  16.836  1.00 29.25           C  
ATOM   2047  O   VAL A 294       4.162  27.312  17.758  1.00 27.92           O  
ATOM   2048  CB  VAL A 294       5.332  25.341  15.835  1.00 29.60           C  
ATOM   2049  CG1 VAL A 294       4.901  24.432  14.697  1.00 30.63           C  
ATOM   2050  CG2 VAL A 294       6.843  25.285  16.009  1.00 31.86           C  
ATOM   2051  N   GLN A 295       5.807  28.584  16.909  1.00 28.07           N  
ATOM   2052  CA  GLN A 295       5.896  29.411  18.106  1.00 28.15           C  
ATOM   2053  C   GLN A 295       6.874  30.572  17.959  1.00 29.41           C  
ATOM   2054  O   GLN A 295       7.911  30.444  17.307  1.00 31.88           O  
ATOM   2055  CB  GLN A 295       6.284  28.548  19.318  1.00 27.20           C  
ATOM   2056  CG  GLN A 295       6.380  29.313  20.631  1.00 27.75           C  
ATOM   2057  CD  GLN A 295       6.524  28.409  21.851  1.00 28.41           C  
ATOM   2058  OE1 GLN A 295       7.026  27.287  21.761  1.00 26.25           O  
ATOM   2059  NE2 GLN A 295       6.097  28.908  23.006  1.00 29.65           N  
ATOM   2060  N   LYS A 296       6.522  31.707  18.557  1.00 28.42           N  
ATOM   2061  CA  LYS A 296       7.350  32.911  18.544  1.00 27.45           C  
ATOM   2062  C   LYS A 296       7.522  33.328  19.995  1.00 28.48           C  
ATOM   2063  O   LYS A 296       6.538  33.640  20.666  1.00 29.54           O  
ATOM   2064  CB  LYS A 296       6.656  34.058  17.811  1.00 27.26           C  
ATOM   2065  CG  LYS A 296       6.386  33.869  16.333  1.00 27.91           C  
ATOM   2066  CD  LYS A 296       5.759  35.144  15.780  1.00 28.29           C  
ATOM   2067  CE  LYS A 296       5.482  35.059  14.291  1.00 30.57           C  
ATOM   2068  NZ  LYS A 296       5.052  36.385  13.745  1.00 33.04           N  
ATOM   2069  N   LEU A 297       8.757  33.348  20.481  1.00 28.53           N  
ATOM   2070  CA  LEU A 297       9.018  33.724  21.866  1.00 28.31           C  
ATOM   2071  C   LEU A 297       9.200  35.237  22.027  1.00 29.27           C  
ATOM   2072  O   LEU A 297      10.076  35.833  21.404  1.00 29.58           O  
ATOM   2073  CB  LEU A 297      10.261  32.986  22.366  1.00 27.60           C  
ATOM   2074  CG  LEU A 297      10.254  31.477  22.087  1.00 26.38           C  
ATOM   2075  CD1 LEU A 297      11.476  30.832  22.715  1.00 24.53           C  
ATOM   2076  CD2 LEU A 297       8.986  30.854  22.641  1.00 26.08           C  
ATOM   2077  N   GLN A 298       8.368  35.852  22.865  1.00 29.31           N  
ATOM   2078  CA  GLN A 298       8.435  37.295  23.100  1.00 30.34           C  
ATOM   2079  C   GLN A 298       9.069  37.626  24.448  1.00 29.33           C  
ATOM   2080  O   GLN A 298       8.939  36.865  25.404  1.00 29.81           O  
ATOM   2081  CB  GLN A 298       7.031  37.908  23.039  1.00 31.91           C  
ATOM   2082  CG  GLN A 298       6.288  37.628  21.742  1.00 33.21           C  
ATOM   2083  CD  GLN A 298       4.964  38.358  21.662  1.00 34.10           C  
ATOM   2084  OE1 GLN A 298       4.919  39.581  21.524  1.00 35.75           O  
ATOM   2085  NE2 GLN A 298       3.875  37.611  21.754  1.00 36.01           N  
ATOM   2086  N   GLY A 299       9.748  38.770  24.520  1.00 28.54           N  
ATOM   2087  CA  GLY A 299      10.394  39.171  25.761  1.00 28.53           C  
ATOM   2088  C   GLY A 299      11.594  40.082  25.557  1.00 27.79           C  
ATOM   2089  O   GLY A 299      11.738  41.095  26.239  1.00 29.57           O  
ATOM   2090  N   HIS A 300      12.466  39.718  24.623  1.00 25.73           N  
ATOM   2091  CA  HIS A 300      13.645  40.520  24.323  1.00 23.16           C  
ATOM   2092  C   HIS A 300      13.222  41.882  23.768  1.00 22.73           C  
ATOM   2093  O   HIS A 300      12.189  41.986  23.108  1.00 22.87           O  
ATOM   2094  CB  HIS A 300      14.531  39.789  23.311  1.00 20.58           C  
ATOM   2095  CG  HIS A 300      15.388  38.720  23.918  1.00 17.68           C  
ATOM   2096  ND1 HIS A 300      16.421  39.003  24.788  1.00 19.65           N  
ATOM   2097  CD2 HIS A 300      15.381  37.374  23.766  1.00 15.82           C  
ATOM   2098  CE1 HIS A 300      17.013  37.876  25.146  1.00 18.12           C  
ATOM   2099  NE2 HIS A 300      16.400  36.873  24.541  1.00 16.41           N  
ATOM   2100  N   THR A 301      14.025  42.914  24.028  1.00 22.51           N  
ATOM   2101  CA  THR A 301      13.717  44.270  23.566  1.00 22.40           C  
ATOM   2102  C   THR A 301      14.608  44.782  22.439  1.00 23.44           C  
ATOM   2103  O   THR A 301      14.682  45.989  22.187  1.00 23.66           O  
ATOM   2104  CB  THR A 301      13.777  45.287  24.726  1.00 22.09           C  
ATOM   2105  OG1 THR A 301      15.039  45.182  25.400  1.00 20.53           O  
ATOM   2106  CG2 THR A 301      12.656  45.027  25.713  1.00 22.02           C  
ATOM   2107  N   ASP A 302      15.280  43.859  21.759  1.00 22.85           N  
ATOM   2108  CA  ASP A 302      16.147  44.209  20.644  1.00 20.06           C  
ATOM   2109  C   ASP A 302      16.439  42.941  19.845  1.00 20.81           C  
ATOM   2110  O   ASP A 302      16.129  41.824  20.282  1.00 20.73           O  
ATOM   2111  CB  ASP A 302      17.456  44.825  21.146  1.00 21.40           C  
ATOM   2112  CG  ASP A 302      18.164  45.654  20.079  1.00 20.98           C  
ATOM   2113  OD1 ASP A 302      17.897  45.447  18.876  1.00 23.24           O  
ATOM   2114  OD2 ASP A 302      19.001  46.507  20.441  1.00 20.80           O  
ATOM   2115  N   VAL A 303      17.024  43.128  18.666  1.00 19.85           N  
ATOM   2116  CA  VAL A 303      17.365  42.030  17.776  1.00 16.84           C  
ATOM   2117  C   VAL A 303      17.887  40.825  18.540  1.00 16.88           C  
ATOM   2118  O   VAL A 303      18.799  40.950  19.364  1.00 16.62           O  
ATOM   2119  CB  VAL A 303      18.447  42.473  16.760  1.00 16.80           C  
ATOM   2120  CG1 VAL A 303      18.908  41.282  15.921  1.00 14.08           C  
ATOM   2121  CG2 VAL A 303      17.896  43.587  15.870  1.00 13.08           C  
ATOM   2122  N   VAL A 304      17.293  39.662  18.283  1.00 16.14           N  
ATOM   2123  CA  VAL A 304      17.746  38.433  18.921  1.00 15.17           C  
ATOM   2124  C   VAL A 304      18.807  37.890  17.963  1.00 15.57           C  
ATOM   2125  O   VAL A 304      18.498  37.238  16.966  1.00 16.23           O  
ATOM   2126  CB  VAL A 304      16.588  37.431  19.102  1.00 12.57           C  
ATOM   2127  CG1 VAL A 304      17.107  36.134  19.695  1.00 10.71           C  
ATOM   2128  CG2 VAL A 304      15.532  38.033  20.023  1.00 11.18           C  
ATOM   2129  N   ILE A 305      20.061  38.193  18.276  1.00 16.26           N  
ATOM   2130  CA  ILE A 305      21.199  37.821  17.447  1.00 16.41           C  
ATOM   2131  C   ILE A 305      21.651  36.376  17.559  1.00 15.91           C  
ATOM   2132  O   ILE A 305      22.267  35.845  16.640  1.00 16.37           O  
ATOM   2133  CB  ILE A 305      22.425  38.713  17.772  1.00 14.88           C  
ATOM   2134  CG1 ILE A 305      23.514  38.535  16.711  1.00 16.36           C  
ATOM   2135  CG2 ILE A 305      22.984  38.344  19.135  1.00 13.16           C  
ATOM   2136  CD1 ILE A 305      23.228  39.243  15.401  1.00 13.18           C  
ATOM   2137  N   SER A 306      21.351  35.734  18.676  1.00 15.26           N  
ATOM   2138  CA  SER A 306      21.803  34.371  18.850  1.00 14.61           C  
ATOM   2139  C   SER A 306      20.853  33.506  19.657  1.00 15.20           C  
ATOM   2140  O   SER A 306      20.142  33.989  20.539  1.00 15.05           O  
ATOM   2141  CB  SER A 306      23.184  34.388  19.516  1.00 14.97           C  
ATOM   2142  OG  SER A 306      23.697  33.083  19.692  1.00 16.73           O  
ATOM   2143  N   THR A 307      20.845  32.220  19.321  1.00 13.62           N  
ATOM   2144  CA  THR A 307      20.026  31.230  19.991  1.00 14.65           C  
ATOM   2145  C   THR A 307      20.788  29.917  19.916  1.00 15.39           C  
ATOM   2146  O   THR A 307      21.510  29.661  18.951  1.00 16.29           O  
ATOM   2147  CB  THR A 307      18.652  31.022  19.306  1.00 15.48           C  
ATOM   2148  OG1 THR A 307      18.853  30.468  18.007  1.00 16.29           O  
ATOM   2149  CG2 THR A 307      17.888  32.336  19.188  1.00 15.58           C  
ATOM   2150  N   ALA A 308      20.629  29.098  20.947  1.00 15.62           N  
ATOM   2151  CA  ALA A 308      21.278  27.804  21.014  1.00 15.92           C  
ATOM   2152  C   ALA A 308      20.281  26.796  21.572  1.00 17.29           C  
ATOM   2153  O   ALA A 308      19.399  27.149  22.348  1.00 18.28           O  
ATOM   2154  CB  ALA A 308      22.502  27.879  21.918  1.00 15.75           C  
ATOM   2155  N   CYS A 309      20.421  25.542  21.165  1.00 18.70           N  
ATOM   2156  CA  CYS A 309      19.535  24.491  21.642  1.00 19.67           C  
ATOM   2157  C   CYS A 309      20.283  23.554  22.570  1.00 19.53           C  
ATOM   2158  O   CYS A 309      21.356  23.069  22.229  1.00 19.19           O  
ATOM   2159  CB  CYS A 309      18.965  23.704  20.461  1.00 19.92           C  
ATOM   2160  SG  CYS A 309      17.808  24.668  19.492  1.00 20.37           S  
ATOM   2161  N   HIS A 310      19.715  23.312  23.746  1.00 21.57           N  
ATOM   2162  CA  HIS A 310      20.336  22.420  24.717  1.00 23.56           C  
ATOM   2163  C   HIS A 310      20.504  21.036  24.088  1.00 23.46           C  
ATOM   2164  O   HIS A 310      19.611  20.551  23.398  1.00 23.49           O  
ATOM   2165  CB  HIS A 310      19.477  22.335  25.982  1.00 24.21           C  
ATOM   2166  CG  HIS A 310      20.185  21.721  27.149  1.00 25.22           C  
ATOM   2167  ND1 HIS A 310      20.372  20.362  27.278  1.00 25.48           N  
ATOM   2168  CD2 HIS A 310      20.781  22.285  28.226  1.00 25.66           C  
ATOM   2169  CE1 HIS A 310      21.050  20.116  28.384  1.00 26.23           C  
ATOM   2170  NE2 HIS A 310      21.310  21.267  28.978  1.00 26.04           N  
ATOM   2171  N   PRO A 311      21.655  20.384  24.321  1.00 24.22           N  
ATOM   2172  CA  PRO A 311      21.947  19.055  23.771  1.00 25.32           C  
ATOM   2173  C   PRO A 311      21.073  17.882  24.232  1.00 27.12           C  
ATOM   2174  O   PRO A 311      20.975  16.870  23.534  1.00 28.61           O  
ATOM   2175  CB  PRO A 311      23.420  18.856  24.125  1.00 23.74           C  
ATOM   2176  CG  PRO A 311      23.550  19.592  25.418  1.00 22.65           C  
ATOM   2177  CD  PRO A 311      22.776  20.865  25.150  1.00 22.44           C  
ATOM   2178  N   THR A 312      20.435  18.000  25.392  1.00 27.19           N  
ATOM   2179  CA  THR A 312      19.601  16.904  25.879  1.00 26.01           C  
ATOM   2180  C   THR A 312      18.202  17.322  26.311  1.00 27.04           C  
ATOM   2181  O   THR A 312      17.262  16.543  26.188  1.00 29.43           O  
ATOM   2182  CB  THR A 312      20.269  16.174  27.064  1.00 25.40           C  
ATOM   2183  OG1 THR A 312      20.472  17.095  28.142  1.00 25.22           O  
ATOM   2184  CG2 THR A 312      21.605  15.587  26.644  1.00 23.90           C  
ATOM   2185  N   GLU A 313      18.056  18.540  26.820  1.00 26.33           N  
ATOM   2186  CA  GLU A 313      16.750  19.011  27.269  1.00 26.61           C  
ATOM   2187  C   GLU A 313      16.114  19.977  26.267  1.00 26.17           C  
ATOM   2188  O   GLU A 313      16.800  20.566  25.433  1.00 25.06           O  
ATOM   2189  CB  GLU A 313      16.877  19.714  28.628  1.00 28.37           C  
ATOM   2190  CG  GLU A 313      17.429  18.851  29.765  1.00 33.40           C  
ATOM   2191  CD  GLU A 313      16.462  17.767  30.213  1.00 34.96           C  
ATOM   2192  OE1 GLU A 313      15.267  18.076  30.403  1.00 37.86           O  
ATOM   2193  OE2 GLU A 313      16.897  16.610  30.385  1.00 36.67           O  
ATOM   2194  N   ASN A 314      14.795  20.134  26.354  1.00 25.36           N  
ATOM   2195  CA  ASN A 314      14.098  21.046  25.463  1.00 24.11           C  
ATOM   2196  C   ASN A 314      14.229  22.437  26.071  1.00 24.81           C  
ATOM   2197  O   ASN A 314      13.279  22.991  26.620  1.00 23.56           O  
ATOM   2198  CB  ASN A 314      12.628  20.658  25.326  1.00 24.46           C  
ATOM   2199  CG  ASN A 314      12.440  19.214  24.879  1.00 24.95           C  
ATOM   2200  OD1 ASN A 314      13.115  18.734  23.962  1.00 22.61           O  
ATOM   2201  ND2 ASN A 314      11.510  18.517  25.524  1.00 25.37           N  
ATOM   2202  N   ILE A 315      15.436  22.982  25.969  1.00 25.49           N  
ATOM   2203  CA  ILE A 315      15.755  24.295  26.505  1.00 24.42           C  
ATOM   2204  C   ILE A 315      16.388  25.166  25.426  1.00 24.52           C  
ATOM   2205  O   ILE A 315      17.216  24.694  24.645  1.00 25.12           O  
ATOM   2206  CB  ILE A 315      16.747  24.173  27.685  1.00 24.33           C  
ATOM   2207  CG1 ILE A 315      16.089  23.408  28.831  1.00 24.81           C  
ATOM   2208  CG2 ILE A 315      17.195  25.557  28.139  1.00 25.61           C  
ATOM   2209  CD1 ILE A 315      16.994  23.182  30.025  1.00 25.29           C  
ATOM   2210  N   ILE A 316      15.987  26.432  25.379  1.00 23.54           N  
ATOM   2211  CA  ILE A 316      16.538  27.358  24.402  1.00 24.02           C  
ATOM   2212  C   ILE A 316      17.171  28.592  25.044  1.00 23.67           C  
ATOM   2213  O   ILE A 316      16.601  29.202  25.954  1.00 23.68           O  
ATOM   2214  CB  ILE A 316      15.462  27.841  23.403  1.00 22.80           C  
ATOM   2215  CG1 ILE A 316      14.982  26.669  22.545  1.00 22.97           C  
ATOM   2216  CG2 ILE A 316      16.032  28.952  22.521  1.00 21.62           C  
ATOM   2217  CD1 ILE A 316      13.867  27.028  21.586  1.00 20.11           C  
ATOM   2218  N   ALA A 317      18.357  28.948  24.561  1.00 21.11           N  
ATOM   2219  CA  ALA A 317      19.059  30.128  25.043  1.00 19.11           C  
ATOM   2220  C   ALA A 317      19.022  31.154  23.915  1.00 18.24           C  
ATOM   2221  O   ALA A 317      19.337  30.837  22.767  1.00 16.14           O  
ATOM   2222  CB  ALA A 317      20.493  29.783  25.390  1.00 14.70           C  
ATOM   2223  N   SER A 318      18.621  32.377  24.242  1.00 17.72           N  
ATOM   2224  CA  SER A 318      18.552  33.447  23.256  1.00 18.35           C  
ATOM   2225  C   SER A 318      19.246  34.668  23.840  1.00 18.07           C  
ATOM   2226  O   SER A 318      19.260  34.848  25.058  1.00 19.83           O  
ATOM   2227  CB  SER A 318      17.097  33.785  22.935  1.00 17.58           C  
ATOM   2228  OG  SER A 318      16.432  34.290  24.079  1.00 18.26           O  
ATOM   2229  N   ALA A 319      19.826  35.496  22.973  1.00 17.38           N  
ATOM   2230  CA  ALA A 319      20.528  36.704  23.411  1.00 17.27           C  
ATOM   2231  C   ALA A 319      20.273  37.847  22.429  1.00 16.14           C  
ATOM   2232  O   ALA A 319      20.175  37.624  21.224  1.00 18.24           O  
ATOM   2233  CB  ALA A 319      22.016  36.426  23.530  1.00 16.09           C  
ATOM   2234  N   ALA A 320      20.178  39.072  22.939  1.00 16.31           N  
ATOM   2235  CA  ALA A 320      19.890  40.224  22.089  1.00 16.66           C  
ATOM   2236  C   ALA A 320      20.949  41.311  22.111  1.00 16.67           C  
ATOM   2237  O   ALA A 320      21.885  41.277  22.908  1.00 16.73           O  
ATOM   2238  CB  ALA A 320      18.520  40.821  22.453  1.00 13.97           C  
ATOM   2239  N   LEU A 321      20.766  42.290  21.229  1.00 15.26           N  
ATOM   2240  CA  LEU A 321      21.702  43.388  21.081  1.00 15.60           C  
ATOM   2241  C   LEU A 321      21.634  44.502  22.127  1.00 16.89           C  
ATOM   2242  O   LEU A 321      20.978  44.376  23.156  1.00 15.05           O  
ATOM   2243  CB  LEU A 321      21.579  43.961  19.670  1.00 14.43           C  
ATOM   2244  CG  LEU A 321      21.845  42.917  18.578  1.00 12.61           C  
ATOM   2245  CD1 LEU A 321      21.615  43.524  17.212  1.00 10.85           C  
ATOM   2246  CD2 LEU A 321      23.278  42.398  18.712  1.00 11.02           C  
ATOM   2247  N   GLU A 322      22.324  45.597  21.821  1.00 20.07           N  
ATOM   2248  CA  GLU A 322      22.480  46.747  22.699  1.00 22.91           C  
ATOM   2249  C   GLU A 322      21.343  47.239  23.592  1.00 23.45           C  
ATOM   2250  O   GLU A 322      21.578  47.536  24.761  1.00 24.02           O  
ATOM   2251  CB  GLU A 322      23.034  47.921  21.895  1.00 24.86           C  
ATOM   2252  CG  GLU A 322      23.933  48.834  22.726  1.00 32.01           C  
ATOM   2253  CD  GLU A 322      25.108  48.088  23.382  1.00 35.50           C  
ATOM   2254  OE1 GLU A 322      25.980  47.546  22.659  1.00 35.66           O  
ATOM   2255  OE2 GLU A 322      25.154  48.046  24.631  1.00 37.01           O  
ATOM   2256  N   ASN A 323      20.123  47.341  23.074  1.00 22.55           N  
ATOM   2257  CA  ASN A 323      19.022  47.821  23.909  1.00 24.29           C  
ATOM   2258  C   ASN A 323      18.514  46.757  24.880  1.00 24.32           C  
ATOM   2259  O   ASN A 323      17.634  47.021  25.698  1.00 24.92           O  
ATOM   2260  CB  ASN A 323      17.862  48.301  23.040  1.00 27.12           C  
ATOM   2261  CG  ASN A 323      16.767  48.969  23.853  1.00 31.67           C  
ATOM   2262  OD1 ASN A 323      16.991  50.002  24.487  1.00 32.71           O  
ATOM   2263  ND2 ASN A 323      15.576  48.377  23.845  1.00 33.11           N  
ATOM   2264  N   ASP A 324      19.078  45.557  24.795  1.00 22.52           N  
ATOM   2265  CA  ASP A 324      18.664  44.453  25.648  1.00 21.34           C  
ATOM   2266  C   ASP A 324      19.840  43.953  26.502  1.00 21.40           C  
ATOM   2267  O   ASP A 324      19.815  44.045  27.730  1.00 18.83           O  
ATOM   2268  CB  ASP A 324      18.117  43.337  24.755  1.00 22.06           C  
ATOM   2269  CG  ASP A 324      17.473  42.220  25.536  1.00 22.94           C  
ATOM   2270  OD1 ASP A 324      18.094  41.740  26.507  1.00 22.31           O  
ATOM   2271  OD2 ASP A 324      16.349  41.817  25.171  1.00 24.54           O  
ATOM   2272  N   LYS A 325      20.870  43.432  25.840  1.00 21.88           N  
ATOM   2273  CA  LYS A 325      22.066  42.921  26.508  1.00 21.78           C  
ATOM   2274  C   LYS A 325      21.812  41.742  27.435  1.00 21.62           C  
ATOM   2275  O   LYS A 325      22.722  41.315  28.151  1.00 21.57           O  
ATOM   2276  CB  LYS A 325      22.749  44.007  27.332  1.00 23.43           C  
ATOM   2277  CG  LYS A 325      23.099  45.279  26.605  1.00 26.06           C  
ATOM   2278  CD  LYS A 325      24.021  46.102  27.490  1.00 29.00           C  
ATOM   2279  CE  LYS A 325      23.944  47.581  27.181  1.00 32.34           C  
ATOM   2280  NZ  LYS A 325      22.627  48.145  27.579  1.00 33.19           N  
ATOM   2281  N   THR A 326      20.591  41.222  27.449  1.00 19.85           N  
ATOM   2282  CA  THR A 326      20.314  40.087  28.314  1.00 20.80           C  
ATOM   2283  C   THR A 326      20.287  38.788  27.532  1.00 22.09           C  
ATOM   2284  O   THR A 326      20.285  38.778  26.297  1.00 24.21           O  
ATOM   2285  CB  THR A 326      18.962  40.223  29.060  1.00 19.84           C  
ATOM   2286  OG1 THR A 326      17.879  40.036  28.142  1.00 19.24           O  
ATOM   2287  CG2 THR A 326      18.843  41.591  29.713  1.00 18.78           C  
ATOM   2288  N   ILE A 327      20.273  37.695  28.281  1.00 21.73           N  
ATOM   2289  CA  ILE A 327      20.234  36.345  27.743  1.00 21.96           C  
ATOM   2290  C   ILE A 327      19.003  35.713  28.380  1.00 23.20           C  
ATOM   2291  O   ILE A 327      18.752  35.923  29.561  1.00 24.61           O  
ATOM   2292  CB  ILE A 327      21.482  35.556  28.186  1.00 19.97           C  
ATOM   2293  CG1 ILE A 327      22.742  36.240  27.642  1.00 19.26           C  
ATOM   2294  CG2 ILE A 327      21.378  34.118  27.735  1.00 20.05           C  
ATOM   2295  CD1 ILE A 327      24.021  35.684  28.195  1.00 14.24           C  
ATOM   2296  N   LYS A 328      18.221  34.963  27.616  1.00 23.43           N  
ATOM   2297  CA  LYS A 328      17.042  34.327  28.189  1.00 23.64           C  
ATOM   2298  C   LYS A 328      17.045  32.826  27.956  1.00 25.08           C  
ATOM   2299  O   LYS A 328      17.403  32.355  26.877  1.00 26.05           O  
ATOM   2300  CB  LYS A 328      15.759  34.942  27.619  1.00 21.37           C  
ATOM   2301  CG  LYS A 328      15.503  36.355  28.097  1.00 22.53           C  
ATOM   2302  CD  LYS A 328      14.288  36.971  27.422  1.00 22.18           C  
ATOM   2303  CE  LYS A 328      14.163  38.444  27.769  1.00 22.59           C  
ATOM   2304  NZ  LYS A 328      14.048  38.678  29.241  1.00 25.88           N  
ATOM   2305  N   LEU A 329      16.663  32.084  28.991  1.00 25.67           N  
ATOM   2306  CA  LEU A 329      16.591  30.631  28.934  1.00 26.76           C  
ATOM   2307  C   LEU A 329      15.124  30.242  28.892  1.00 27.70           C  
ATOM   2308  O   LEU A 329      14.346  30.635  29.762  1.00 28.95           O  
ATOM   2309  CB  LEU A 329      17.262  30.014  30.163  1.00 25.10           C  
ATOM   2310  CG  LEU A 329      18.787  30.137  30.163  1.00 26.43           C  
ATOM   2311  CD1 LEU A 329      19.354  29.774  31.527  1.00 26.29           C  
ATOM   2312  CD2 LEU A 329      19.354  29.237  29.079  1.00 24.43           C  
ATOM   2313  N   TRP A 330      14.741  29.488  27.872  1.00 27.92           N  
ATOM   2314  CA  TRP A 330      13.361  29.071  27.738  1.00 27.95           C  
ATOM   2315  C   TRP A 330      13.286  27.558  27.828  1.00 29.75           C  
ATOM   2316  O   TRP A 330      14.202  26.858  27.395  1.00 28.64           O  
ATOM   2317  CB  TRP A 330      12.797  29.550  26.405  1.00 25.46           C  
ATOM   2318  CG  TRP A 330      13.171  30.962  26.071  1.00 24.74           C  
ATOM   2319  CD1 TRP A 330      14.400  31.410  25.670  1.00 24.11           C  
ATOM   2320  CD2 TRP A 330      12.304  32.106  26.066  1.00 23.73           C  
ATOM   2321  NE1 TRP A 330      14.351  32.757  25.409  1.00 24.33           N  
ATOM   2322  CE2 TRP A 330      13.079  33.212  25.643  1.00 23.88           C  
ATOM   2323  CE3 TRP A 330      10.952  32.305  26.376  1.00 21.88           C  
ATOM   2324  CZ2 TRP A 330      12.543  34.501  25.518  1.00 22.12           C  
ATOM   2325  CZ3 TRP A 330      10.420  33.589  26.251  1.00 22.72           C  
ATOM   2326  CH2 TRP A 330      11.218  34.669  25.826  1.00 21.86           C  
ATOM   2327  N   LYS A 331      12.194  27.060  28.399  1.00 32.78           N  
ATOM   2328  CA  LYS A 331      12.002  25.625  28.561  1.00 36.05           C  
ATOM   2329  C   LYS A 331      10.642  25.186  28.037  1.00 37.26           C  
ATOM   2330  O   LYS A 331       9.638  25.881  28.215  1.00 36.28           O  
ATOM   2331  CB  LYS A 331      12.143  25.247  30.035  1.00 37.40           C  
ATOM   2332  CG  LYS A 331      11.898  23.784  30.328  1.00 41.60           C  
ATOM   2333  CD  LYS A 331      12.259  23.449  31.766  1.00 44.13           C  
ATOM   2334  CE  LYS A 331      11.862  22.023  32.111  1.00 45.29           C  
ATOM   2335  NZ  LYS A 331      12.384  21.050  31.114  1.00 48.01           N  
ATOM   2336  N   SER A 332      10.619  24.025  27.388  1.00 38.50           N  
ATOM   2337  CA  SER A 332       9.390  23.488  26.822  1.00 39.95           C  
ATOM   2338  C   SER A 332       9.196  22.021  27.165  1.00 42.12           C  
ATOM   2339  O   SER A 332      10.142  21.328  27.544  1.00 41.18           O  
ATOM   2340  CB  SER A 332       9.412  23.641  25.300  1.00 39.04           C  
ATOM   2341  OG  SER A 332       8.374  22.899  24.686  1.00 37.22           O  
ATOM   2342  N   ASP A 333       7.953  21.563  27.044  1.00 44.27           N  
ATOM   2343  CA  ASP A 333       7.624  20.163  27.284  1.00 46.98           C  
ATOM   2344  C   ASP A 333       7.865  19.561  25.914  1.00 48.37           C  
ATOM   2345  O   ASP A 333       8.161  18.374  25.766  1.00 48.87           O  
ATOM   2346  CB  ASP A 333       6.149  20.011  27.661  1.00 47.38           C  
ATOM   2347  CG  ASP A 333       5.777  20.812  28.887  1.00 48.10           C  
ATOM   2348  OD1 ASP A 333       6.358  20.560  29.963  1.00 48.69           O  
ATOM   2349  OD2 ASP A 333       4.906  21.696  28.777  1.00 48.84           O  
ATOM   2350  N   CYS A 334       7.738  20.435  24.921  1.00 49.45           N  
ATOM   2351  CA  CYS A 334       7.933  20.101  23.522  1.00 50.69           C  
ATOM   2352  C   CYS A 334       6.903  19.083  23.057  1.00 49.81           C  
ATOM   2353  O   CYS A 334       5.907  19.505  22.429  1.00 48.01           O  
ATOM   2354  CB  CYS A 334       9.345  19.563  23.314  1.00 50.79           C  
ATOM   2355  SG  CYS A 334       9.776  19.318  21.598  1.00 57.54           S  
ATOM   2356  OXT CYS A 334       7.093  17.885  23.343  1.00 51.16           O  
TER    2357      CYS A 334                                                      
END
MOLECULE T0512.pdb
ATOM      1  CB  ALA     1      12.905  20.187  31.922  1.00 26.80      A   
ATOM      2  C   ALA     1      15.012  20.293  30.586  1.00 26.38      A   
ATOM      3  O   ALA     1      15.777  21.234  30.801  1.00 27.23      A   
ATOM      4  N   ALA     1      15.088  19.766  32.990  1.00 28.87      A   
ATOM      5  CA  ALA     1      14.297  19.598  31.737  1.00 26.70      A   
ATOM      6  N   SER     2      14.763  19.827  29.365  1.00 24.75      A   
ATOM      7  CA  SER     2      15.391  20.412  28.183  1.00 23.05      A   
ATOM      8  CB  SER     2      15.090  19.568  26.945  1.00 25.55      A   
ATOM      9  OG  SER     2      15.726  18.305  27.034  1.00 32.70      A   
ATOM     10  C   SER     2      14.924  21.842  27.943  1.00 19.23      A   
ATOM     11  O   SER     2      13.790  22.199  28.256  1.00 18.20      A   
ATOM     12  N   GLY     3      15.810  22.654  27.379  1.00 14.29      A   
ATOM     13  CA  GLY     3      15.477  24.036  27.114  1.00 12.98      A   
ATOM     14  C   GLY     3      16.323  24.660  26.022  1.00 12.65      A   
ATOM     15  O   GLY     3      17.252  24.043  25.489  1.00 11.49      A   
ATOM     16  N   LEU     4      16.007  25.907  25.703  1.00 10.98      A   
ATOM     17  CA  LEU     4      16.712  26.629  24.660  1.00  9.54      A   
ATOM     18  CB  LEU     4      15.845  26.683  23.401  1.00  9.82      A   
ATOM     19  CG  LEU     4      16.374  27.550  22.253  1.00  7.33      A   
ATOM     20  CD1 LEU     4      17.610  26.903  21.659  1.00  5.88      A   
ATOM     21  CD2 LEU     4      15.287  27.699  21.199  1.00 10.02      A   
ATOM     22  C   LEU     4      17.061  28.044  25.086  1.00 10.00      A   
ATOM     23  O   LEU     4      16.187  28.808  25.499  1.00 11.23      A   
ATOM     24  N   PHE     5      18.342  28.389  24.998  1.00  9.46      A   
ATOM     25  CA  PHE     5      18.777  29.741  25.336  1.00  9.31      A   
ATOM     26  CB  PHE     5      20.180  29.753  25.942  1.00  8.92      A   
ATOM     27  CG  PHE     5      20.237  29.267  27.355  1.00  9.07      A   
ATOM     28  CD1 PHE     5      20.487  27.930  27.633  1.00  9.82      A   
ATOM     29  CD2 PHE     5      20.049  30.152  28.411  1.00 10.87      A   
ATOM     30  CE1 PHE     5      20.553  27.472  28.947  1.00  9.86      A   
ATOM     31  CE2 PHE     5      20.112  29.708  29.732  1.00 11.91      A   
ATOM     32  CZ  PHE     5      20.365  28.363  30.000  1.00 12.19      A   
ATOM     33  C   PHE     5      18.809  30.543  24.048  1.00 10.62      A   
ATOM     34  O   PHE     5      19.100  30.005  22.981  1.00  8.57      A   
ATOM     35  N   ILE     6      18.503  31.830  24.154  1.00  9.42      A   
ATOM     36  CA  ILE     6      18.513  32.726  23.004  1.00  9.62      A   
ATOM     37  CB  ILE     6      17.077  33.163  22.572  1.00 10.42      A   
ATOM     38  CG2 ILE     6      17.158  33.985  21.290  1.00  9.52      A   
ATOM     39  CG1 ILE     6      16.162  31.954  22.366  1.00  9.60      A   
ATOM     40  CD1 ILE     6      15.347  31.558  23.599  1.00  9.64      A   
ATOM     41  C   ILE     6      19.253  33.990  23.439  1.00 11.00      A   
ATOM     42  O   ILE     6      18.796  34.675  24.349  1.00 10.27      A   
ATOM     43  N   THR     7      20.396  34.287  22.824  1.00  9.85      A   
ATOM     44  CA  THR     7      21.127  35.504  23.171  1.00  9.86      A   
ATOM     45  CB  THR     7      22.641  35.407  22.868  1.00 10.36      A   
ATOM     46  OG1 THR     7      22.836  35.098  21.481  1.00 11.58      A   
ATOM     47  CG2 THR     7      23.301  34.352  23.739  1.00 10.85      A   
ATOM     48  C   THR     7      20.559  36.643  22.328  1.00 11.10      A   
ATOM     49  O   THR     7      20.150  36.430  21.186  1.00 11.33      A   
ATOM     50  N   ASN     8      20.528  37.844  22.894  1.00 10.06      A   
ATOM     51  CA  ASN     8      20.011  39.015  22.191  1.00 12.28      A   
ATOM     52  CB  ASN     8      18.758  39.535  22.888  1.00 11.94      A   
ATOM     53  CG  ASN     8      17.653  38.508  22.938  1.00 11.46      A   
ATOM     54  OD1 ASN     8      16.867  38.374  22.002  1.00 12.79      A   
ATOM     55  ND2 ASN     8      17.593  37.765  24.031  1.00 12.03      A   
ATOM     56  C   ASN     8      21.078  40.098  22.181  1.00 11.38      A   
ATOM     57  O   ASN     8      21.468  40.611  23.227  1.00 12.93      A   
ATOM     58  N   GLU     9      21.548  40.441  20.992  1.00 11.38      A   
ATOM     59  CA  GLU     9      22.582  41.452  20.846  1.00 11.14      A   
ATOM     60  CB  GLU     9      22.924  41.646  19.370  1.00 11.54      A   
ATOM     61  CG  GLU     9      23.693  40.506  18.726  1.00 13.41      A   
ATOM     62  CD  GLU     9      24.124  40.837  17.306  1.00 14.47      A   
ATOM     63  OE1 GLU     9      24.252  42.038  16.991  1.00 16.53      A   
ATOM     64  OE2 GLU     9      24.347  39.900  16.517  1.00 14.60      A   
ATOM     65  C   GLU     9      22.219  42.809  21.435  1.00 13.82      A   
ATOM     66  O   GLU     9      23.066  43.495  22.016  1.00 11.24      A   
ATOM     67  N   GLY    10      20.959  43.197  21.291  1.00 14.09      A   
ATOM     68  CA  GLY    10      20.562  44.506  21.762  1.00 15.00      A   
ATOM     69  C   GLY    10      21.153  45.437  20.719  1.00 16.49      A   
ATOM     70  O   GLY    10      21.467  44.995  19.609  1.00 12.90      A   
ATOM     71  N   ASN    11      21.323  46.708  21.069  1.00 16.20      A   
ATOM     72  CA  ASN    11      21.873  47.698  20.151  1.00 18.21      A   
ATOM     73  CB  ASN    11      20.975  48.935  20.138  1.00 18.59      A   
ATOM     74  CG  ASN    11      19.551  48.605  19.765  1.00 16.91      A   
ATOM     75  OD1 ASN    11      18.631  48.737  20.576  1.00 18.03      A   
ATOM     76  ND2 ASN    11      19.360  48.155  18.528  1.00 18.61      A   
ATOM     77  C   ASN    11      23.294  48.097  20.532  1.00 18.94      A   
ATOM     78  O   ASN    11      23.610  48.248  21.710  1.00 18.01      A   
ATOM     79  N   PHE    12      24.149  48.270  19.530  1.00 20.27      A   
ATOM     80  CA  PHE    12      25.534  48.643  19.781  1.00 20.18      A   
ATOM     81  CB  PHE    12      26.280  48.803  18.456  1.00 22.11      A   
ATOM     82  CG  PHE    12      27.717  49.205  18.613  1.00 21.69      A   
ATOM     83  CD1 PHE    12      28.100  50.537  18.486  1.00 23.73      A   
ATOM     84  CD2 PHE    12      28.691  48.252  18.893  1.00 21.14      A   
ATOM     85  CE1 PHE    12      29.434  50.912  18.633  1.00 21.88      A   
ATOM     86  CE2 PHE    12      30.026  48.617  19.043  1.00 22.77      A   
ATOM     87  CZ  PHE    12      30.399  49.950  18.912  1.00 21.03      A   
ATOM     88  C   PHE    12      25.655  49.922  20.610  1.00 21.84      A   
ATOM     89  O   PHE    12      25.044  50.944  20.291  1.00 19.53      A   
ATOM     90  N   GLN    13      26.438  49.842  21.685  1.00 22.36      A   
ATOM     91  CA  GLN    13      26.683  50.972  22.577  1.00 23.41      A   
ATOM     92  CB  GLN    13      27.213  52.156  21.756  1.00 25.50      A   
ATOM     93  CG  GLN    13      27.937  53.233  22.547  1.00 30.00      A   
ATOM     94  CD  GLN    13      28.923  54.009  21.687  1.00 31.64      A   
ATOM     95  OE1 GLN    13      28.598  54.425  20.574  1.00 32.05      A   
ATOM     96  NE2 GLN    13      30.134  54.207  22.201  1.00 34.00      A   
ATOM     97  C   GLN    13      25.443  51.371  23.380  1.00 23.48      A   
ATOM     98  O   GLN    13      25.375  52.464  23.943  1.00 23.86      A   
ATOM     99  N   TYR    14      24.460  50.479  23.434  1.00 22.84      A   
ATOM    100  CA  TYR    14      23.241  50.740  24.190  1.00 22.23      A   
ATOM    101  CB  TYR    14      22.003  50.454  23.338  1.00 24.09      A   
ATOM    102  CG  TYR    14      21.359  51.687  22.757  1.00 27.13      A   
ATOM    103  CD1 TYR    14      22.002  52.442  21.778  1.00 27.37      A   
ATOM    104  CE1 TYR    14      21.406  53.585  21.245  1.00 30.01      A   
ATOM    105  CD2 TYR    14      20.103  52.103  23.192  1.00 28.66      A   
ATOM    106  CE2 TYR    14      19.500  53.238  22.671  1.00 30.18      A   
ATOM    107  CZ  TYR    14      20.154  53.976  21.698  1.00 31.13      A   
ATOM    108  OH  TYR    14      19.549  55.102  21.187  1.00 32.15      A   
ATOM    109  C   TYR    14      23.213  49.856  25.428  1.00 21.48      A   
ATOM    110  O   TYR    14      22.362  50.020  26.302  1.00 20.37      A   
ATOM    111  N   SER    15      24.158  48.921  25.485  1.00 20.99      A   
ATOM    112  CA  SER    15      24.276  47.973  26.587  1.00 20.56      A   
ATOM    113  CB  SER    15      25.001  48.618  27.773  1.00 21.81      A   
ATOM    114  OG  SER    15      24.372  49.822  28.168  1.00 30.54      A   
ATOM    115  C   SER    15      22.914  47.445  27.018  1.00 19.90      A   
ATOM    116  O   SER    15      22.569  47.455  28.201  1.00 19.14      A   
ATOM    117  N   ASN    16      22.139  46.979  26.044  1.00 17.72      A   
ATOM    118  CA  ASN    16      20.817  46.445  26.324  1.00 15.32      A   
ATOM    119  CB  ASN    16      19.736  47.329  25.681  1.00 17.03      A   
ATOM    120  CG  ASN    16      19.914  47.493  24.189  1.00 13.60      A   
ATOM    121  OD1 ASN    16      20.965  47.189  23.639  1.00 13.95      A   
ATOM    122  ND2 ASN    16      18.881  47.996  23.526  1.00 16.04      A   
ATOM    123  C   ASN    16      20.683  44.996  25.863  1.00 16.02      A   
ATOM    124  O   ASN    16      19.582  44.524  25.583  1.00 16.63      A   
ATOM    125  N   ALA    17      21.814  44.295  25.791  1.00 13.87      A   
ATOM    126  CA  ALA    17      21.819  42.890  25.400  1.00 13.66      A   
ATOM    127  CB  ALA    17      23.249  42.406  25.175  1.00 13.74      A   
ATOM    128  C   ALA    17      21.173  42.096  26.528  1.00 12.76      A   
ATOM    129  O   ALA    17      21.292  42.467  27.696  1.00 12.91      A   
ATOM    130  N   THR    18      20.487  41.010  26.183  1.00 11.75      A   
ATOM    131  CA  THR    18      19.833  40.183  27.193  1.00 12.27      A   
ATOM    132  CB  THR    18      18.355  40.581  27.398  1.00 13.06      A   
ATOM    133  OG1 THR    18      17.627  40.357  26.183  1.00 10.21      A   
ATOM    134  CG2 THR    18      18.239  42.041  27.806  1.00 11.67      A   
ATOM    135  C   THR    18      19.850  38.712  26.827  1.00 10.74      A   
ATOM    136  O   THR    18      20.164  38.336  25.696  1.00 10.57      A   
ATOM    137  N   LEU    19      19.493  37.885  27.800  1.00 10.49      A   
ATOM    138  CA  LEU    19      19.451  36.446  27.610  1.00  9.72      A   
ATOM    139  CB  LEU    19      20.412  35.760  28.585  1.00  7.79      A   
ATOM    140  CG  LEU    19      20.512  34.234  28.534  1.00  8.21      A   
ATOM    141  CD1 LEU    19      21.086  33.804  27.190  1.00  9.55      A   
ATOM    142  CD2 LEU    19      21.410  33.742  29.666  1.00  7.69      A   
ATOM    143  C   LEU    19      18.037  35.944  27.856  1.00  9.35      A   
ATOM    144  O   LEU    19      17.390  36.339  28.828  1.00 10.96      A   
ATOM    145  N   SER    20      17.554  35.082  26.968  1.00  8.96      A   
ATOM    146  CA  SER    20      16.217  34.514  27.113  1.00  9.43      A   
ATOM    147  CB  SER    20      15.344  34.847  25.897  1.00  9.22      A   
ATOM    148  OG  SER    20      15.213  36.244  25.718  1.00 10.84      A   
ATOM    149  C   SER    20      16.336  33.006  27.235  1.00  9.65      A   
ATOM    150  O   SER    20      17.319  32.416  26.782  1.00  9.89      A   
ATOM    151  N   TYR    21      15.336  32.388  27.857  1.00  9.11      A   
ATOM    152  CA  TYR    21      15.306  30.937  28.024  1.00 12.10      A   
ATOM    153  CB  TYR    21      15.673  30.534  29.454  1.00 12.93      A   
ATOM    154  CG  TYR    21      15.682  29.031  29.655  1.00 13.86      A   
ATOM    155  CD1 TYR    21      16.755  28.254  29.213  1.00 16.37      A   
ATOM    156  CE1 TYR    21      16.764  26.871  29.390  1.00 16.55      A   
ATOM    157  CD2 TYR    21      14.615  28.385  30.278  1.00 14.02      A   
ATOM    158  CE2 TYR    21      14.613  27.003  30.459  1.00 16.77      A   
ATOM    159  CZ  TYR    21      15.690  26.253  30.014  1.00 16.35      A   
ATOM    160  OH  TYR    21      15.697  24.892  30.195  1.00 17.06      A   
ATOM    161  C   TYR    21      13.903  30.435  27.706  1.00 12.88      A   
ATOM    162  O   TYR    21      12.925  30.850  28.326  1.00 12.40      A   
ATOM    163  N   TYR    22      13.821  29.533  26.736  1.00 11.44      A   
ATOM    164  CA  TYR    22      12.550  28.971  26.296  1.00 10.74      A   
ATOM    165  CB  TYR    22      12.406  29.236  24.789  1.00  9.61      A   
ATOM    166  CG  TYR    22      11.219  28.602  24.093  1.00 11.53      A   
ATOM    167  CD1 TYR    22      11.378  27.459  23.308  1.00  9.87      A   
ATOM    168  CE1 TYR    22      10.301  26.902  22.614  1.00 12.52      A   
ATOM    169  CD2 TYR    22       9.950  29.173  24.172  1.00 12.25      A   
ATOM    170  CE2 TYR    22       8.864  28.624  23.484  1.00 13.39      A   
ATOM    171  CZ  TYR    22       9.048  27.491  22.706  1.00 12.79      A   
ATOM    172  OH  TYR    22       7.989  26.948  22.012  1.00 14.88      A   
ATOM    173  C   TYR    22      12.420  27.475  26.599  1.00 10.93      A   
ATOM    174  O   TYR    22      13.379  26.711  26.457  1.00 10.02      A   
ATOM    175  N   ASP    23      11.224  27.070  27.022  1.00 10.78      A   
ATOM    176  CA  ASP    23      10.925  25.673  27.328  1.00 13.46      A   
ATOM    177  CB  ASP    23      10.194  25.561  28.669  1.00 15.31      A   
ATOM    178  CG  ASP    23      10.019  24.121  29.123  1.00 16.90      A   
ATOM    179  OD1 ASP    23       9.799  23.238  28.265  1.00 17.75      A   
ATOM    180  OD2 ASP    23      10.089  23.870  30.343  1.00 17.34      A   
ATOM    181  C   ASP    23      10.004  25.172  26.219  1.00 14.67      A   
ATOM    182  O   ASP    23       8.824  25.519  26.183  1.00 15.59      A   
ATOM    183  N   PRO    24      10.532  24.353  25.296  1.00 14.67      A   
ATOM    184  CD  PRO    24      11.946  23.967  25.165  1.00 16.23      A   
ATOM    185  CA  PRO    24       9.738  23.815  24.185  1.00 14.71      A   
ATOM    186  CB  PRO    24      10.758  22.999  23.391  1.00 16.17      A   
ATOM    187  CG  PRO    24      12.057  23.688  23.684  1.00 18.43      A   
ATOM    188  C   PRO    24       8.543  22.963  24.618  1.00 16.73      A   
ATOM    189  O   PRO    24       7.554  22.854  23.889  1.00 16.09      A   
ATOM    190  N   ALA    25       8.635  22.361  25.798  1.00 16.76      A   
ATOM    191  CA  ALA    25       7.555  21.516  26.301  1.00 18.34      A   
ATOM    192  CB  ALA    25       8.070  20.624  27.426  1.00 19.31      A   
ATOM    193  C   ALA    25       6.360  22.329  26.787  1.00 19.42      A   
ATOM    194  O   ALA    25       5.217  21.892  26.673  1.00 21.77      A   
ATOM    195  N   THR    26       6.621  23.516  27.321  1.00 19.54      A   
ATOM    196  CA  THR    26       5.548  24.364  27.823  1.00 19.13      A   
ATOM    197  CB  THR    26       5.906  24.922  29.214  1.00 19.45      A   
ATOM    198  OG1 THR    26       7.044  25.786  29.104  1.00 16.47      A   
ATOM    199  CG2 THR    26       6.245  23.785  30.167  1.00 18.20      A   
ATOM    200  C   THR    26       5.257  25.534  26.889  1.00 19.85      A   
ATOM    201  O   THR    26       4.218  26.191  27.004  1.00 19.82      A   
ATOM    202  N   CYS    27       6.176  25.779  25.960  1.00 19.20      A   
ATOM    203  CA  CYS    27       6.059  26.881  25.006  1.00 19.73      A   
ATOM    204  CB  CYS    27       4.768  26.767  24.193  1.00 21.39      A   
ATOM    205  SG  CYS    27       4.800  25.462  22.954  1.00 21.63      A   
ATOM    206  C   CYS    27       6.089  28.213  25.737  1.00 19.33      A   
ATOM    207  O   CYS    27       5.467  29.184  25.309  1.00 20.63      A   
ATOM    208  N   GLU    28       6.825  28.248  26.844  1.00 19.66      A   
ATOM    209  CA  GLU    28       6.954  29.454  27.654  1.00 18.76      A   
ATOM    210  CB  GLU    28       6.608  29.146  29.112  1.00 21.52      A   
ATOM    211  CG  GLU    28       5.135  28.870  29.366  1.00 26.62      A   
ATOM    212  CD  GLU    28       4.260  30.066  29.052  1.00 28.83      A   
ATOM    213  OE1 GLU    28       4.558  31.168  29.560  1.00 32.36      A   
ATOM    214  OE2 GLU    28       3.274  29.907  28.301  1.00 31.86      A   
ATOM    215  C   GLU    28       8.370  30.014  27.582  1.00 17.14      A   
ATOM    216  O   GLU    28       9.348  29.271  27.667  1.00 15.39      A   
ATOM    217  N   VAL    29       8.478  31.328  27.426  1.00 14.74      A   
ATOM    218  CA  VAL    29       9.786  31.961  27.358  1.00 13.92      A   
ATOM    219  CB  VAL    29       9.979  32.709  26.010  1.00 13.18      A   
ATOM    220  CG1 VAL    29       9.042  33.907  25.926  1.00 11.03      A   
ATOM    221  CG2 VAL    29      11.423  33.138  25.853  1.00 10.74      A   
ATOM    222  C   VAL    29       9.978  32.949  28.502  1.00 15.13      A   
ATOM    223  O   VAL    29       9.030  33.604  28.936  1.00 14.90      A   
ATOM    224  N   GLU    30      11.207  33.040  28.998  1.00 14.77      A   
ATOM    225  CA  GLU    30      11.532  33.975  30.062  1.00 15.02      A   
ATOM    226  CB  GLU    30      12.083  33.248  31.288  1.00 18.51      A   
ATOM    227  CG  GLU    30      12.208  34.154  32.505  1.00 27.21      A   
ATOM    228  CD  GLU    30      12.570  33.398  33.775  1.00 30.78      A   
ATOM    229  OE1 GLU    30      13.773  33.340  34.118  1.00 29.94      A   
ATOM    230  OE2 GLU    30      11.644  32.854  34.423  1.00 32.01      A   
ATOM    231  C   GLU    30      12.591  34.905  29.495  1.00 13.82      A   
ATOM    232  O   GLU    30      13.560  34.453  28.882  1.00 12.24      A   
ATOM    233  N   ASN    31      12.402  36.203  29.696  1.00 11.60      A   
ATOM    234  CA  ASN    31      13.335  37.200  29.182  1.00 13.07      A   
ATOM    235  CB  ASN    31      12.558  38.254  28.388  1.00 11.85      A   
ATOM    236  CG  ASN    31      11.992  37.698  27.095  1.00 15.85      A   
ATOM    237  OD1 ASN    31      10.873  38.035  26.687  1.00 13.93      A   
ATOM    238  ND2 ASN    31      12.772  36.843  26.433  1.00 11.84      A   
ATOM    239  C   ASN    31      14.154  37.853  30.290  1.00 11.80      A   
ATOM    240  O   ASN    31      13.737  37.878  31.449  1.00 12.76      A   
ATOM    241  N   GLU    32      15.320  38.378  29.921  1.00 11.73      A   
ATOM    242  CA  GLU    32      16.236  39.019  30.861  1.00 13.94      A   
ATOM    243  CB  GLU    32      15.625  40.304  31.437  1.00 17.41      A   
ATOM    244  CG  GLU    32      15.018  41.246  30.415  1.00 20.93      A   
ATOM    245  CD  GLU    32      14.632  42.592  31.024  1.00 24.49      A   
ATOM    246  OE1 GLU    32      14.283  42.626  32.221  1.00 23.55      A   
ATOM    247  OE2 GLU    32      14.669  43.609  30.303  1.00 26.47      A   
ATOM    248  C   GLU    32      16.570  38.069  32.015  1.00 14.77      A   
ATOM    249  O   GLU    32      16.647  38.488  33.170  1.00 12.76      A   
ATOM    250  N   VAL    33      16.785  36.794  31.702  1.00 13.55      A   
ATOM    251  CA  VAL    33      17.073  35.804  32.741  1.00 14.61      A   
ATOM    252  CB  VAL    33      16.975  34.363  32.190  1.00 15.49      A   
ATOM    253  CG1 VAL    33      15.658  34.189  31.458  1.00 17.39      A   
ATOM    254  CG2 VAL    33      18.152  34.053  31.279  1.00 16.31      A   
ATOM    255  C   VAL    33      18.429  35.981  33.412  1.00 12.95      A   
ATOM    256  O   VAL    33      18.597  35.633  34.584  1.00 10.13      A   
ATOM    257  N   PHE    34      19.401  36.514  32.681  1.00 11.05      A   
ATOM    258  CA  PHE    34      20.716  36.719  33.266  1.00 11.68      A   
ATOM    259  CB  PHE    34      21.735  37.108  32.191  1.00 12.48      A   
ATOM    260  CG  PHE    34      23.110  37.386  32.731  1.00 10.92      A   
ATOM    261  CD1 PHE    34      23.440  38.651  33.209  1.00 10.04      A   
ATOM    262  CD2 PHE    34      24.074  36.383  32.765  1.00 10.59      A   
ATOM    263  CE1 PHE    34      24.706  38.918  33.712  1.00 10.51      A   
ATOM    264  CE2 PHE    34      25.350  36.634  33.268  1.00 11.51      A   
ATOM    265  CZ  PHE    34      25.669  37.906  33.743  1.00 13.31      A   
ATOM    266  C   PHE    34      20.618  37.808  34.327  1.00 12.84      A   
ATOM    267  O   PHE    34      21.056  37.627  35.465  1.00 13.33      A   
ATOM    268  N   TYR    35      20.025  38.934  33.953  1.00 11.15      A   
ATOM    269  CA  TYR    35      19.876  40.047  34.878  1.00 11.80      A   
ATOM    270  CB  TYR    35      19.286  41.255  34.150  1.00 11.66      A   
ATOM    271  CG  TYR    35      18.940  42.403  35.068  1.00 14.36      A   
ATOM    272  CD1 TYR    35      19.938  43.166  35.678  1.00 15.50      A   
ATOM    273  CE1 TYR    35      19.615  44.213  36.539  1.00 17.26      A   
ATOM    274  CD2 TYR    35      17.610  42.716  35.343  1.00 16.27      A   
ATOM    275  CE2 TYR    35      17.277  43.756  36.199  1.00 18.38      A   
ATOM    276  CZ  TYR    35      18.280  44.500  36.793  1.00 18.01      A   
ATOM    277  OH  TYR    35      17.940  45.525  37.642  1.00 21.03      A   
ATOM    278  C   TYR    35      19.000  39.684  36.078  1.00 10.74      A   
ATOM    279  O   TYR    35      19.310  40.050  37.212  1.00 10.09      A   
ATOM    280  N   ARG    36      17.909  38.965  35.836  1.00 11.58      A   
ATOM    281  CA  ARG    36      17.021  38.592  36.931  1.00 14.04      A   
ATOM    282  CB  ARG    36      15.747  37.933  36.386  1.00 16.53      A   
ATOM    283  CG  ARG    36      15.029  38.790  35.346  1.00 24.95      A   
ATOM    284  CD  ARG    36      13.523  38.896  35.560  1.00 30.66      A   
ATOM    285  NE  ARG    36      12.800  37.681  35.193  1.00 34.43      A   
ATOM    286  CZ  ARG    36      12.695  36.602  35.963  1.00 37.24      A   
ATOM    287  NH1 ARG    36      13.270  36.576  37.159  1.00 38.80      A   
ATOM    288  NH2 ARG    36      12.008  35.550  35.534  1.00 38.27      A   
ATOM    289  C   ARG    36      17.704  37.663  37.932  1.00 13.56      A   
ATOM    290  O   ARG    36      17.386  37.684  39.122  1.00 13.68      A   
ATOM    291  N   ALA    37      18.656  36.865  37.458  1.00 12.64      A   
ATOM    292  CA  ALA    37      19.352  35.923  38.332  1.00 13.05      A   
ATOM    293  CB  ALA    37      19.705  34.664  37.550  1.00 12.60      A   
ATOM    294  C   ALA    37      20.609  36.488  38.985  1.00 13.27      A   
ATOM    295  O   ALA    37      21.012  36.051  40.070  1.00 16.12      A   
ATOM    296  N   ASN    38      21.216  37.468  38.325  1.00 11.27      A   
ATOM    297  CA  ASN    38      22.456  38.067  38.802  1.00 11.43      A   
ATOM    298  CB  ASN    38      23.486  38.007  37.677  1.00 12.00      A   
ATOM    299  CG  ASN    38      23.940  36.592  37.398  1.00 13.86      A   
ATOM    300  OD1 ASN    38      24.671  36.008  38.192  1.00 14.89      A   
ATOM    301  ND2 ASN    38      23.490  36.023  36.284  1.00 13.28      A   
ATOM    302  C   ASN    38      22.384  39.479  39.370  1.00 11.29      A   
ATOM    303  O   ASN    38      23.225  39.867  40.183  1.00 11.71      A   
ATOM    304  N   GLY    39      21.401  40.256  38.941  1.00 10.12      A   
ATOM    305  CA  GLY    39      21.285  41.599  39.469  1.00 11.36      A   
ATOM    306  C   GLY    39      22.047  42.656  38.694  1.00 11.79      A   
ATOM    307  O   GLY    39      21.992  43.832  39.042  1.00  9.77      A   
ATOM    308  N   PHE    40      22.786  42.252  37.667  1.00 11.48      A   
ATOM    309  CA  PHE    40      23.502  43.220  36.842  1.00 11.82      A   
ATOM    310  CB  PHE    40      24.994  43.331  37.224  1.00 11.66      A   
ATOM    311  CG  PHE    40      25.745  42.038  37.155  1.00 12.08      A   
ATOM    312  CD1 PHE    40      25.779  41.182  38.246  1.00 13.66      A   
ATOM    313  CD2 PHE    40      26.421  41.673  35.994  1.00 13.10      A   
ATOM    314  CE1 PHE    40      26.473  39.977  38.183  1.00 14.64      A   
ATOM    315  CE2 PHE    40      27.117  40.470  35.922  1.00 12.69      A   
ATOM    316  CZ  PHE    40      27.143  39.622  37.019  1.00 13.80      A   
ATOM    317  C   PHE    40      23.332  42.831  35.379  1.00 12.22      A   
ATOM    318  O   PHE    40      23.065  41.670  35.059  1.00 13.14      A   
ATOM    319  N   LYS    41      23.464  43.821  34.503  1.00 12.33      A   
ATOM    320  CA  LYS    41      23.289  43.644  33.061  1.00 12.98      A   
ATOM    321  CB  LYS    41      23.304  45.015  32.368  1.00 12.43      A   
ATOM    322  CG  LYS    41      22.099  45.930  32.640  1.00 16.31      A   
ATOM    323  CD  LYS    41      22.383  47.334  32.100  1.00 21.43      A   
ATOM    324  CE  LYS    41      21.153  47.988  31.490  1.00 22.58      A   
ATOM    325  NZ  LYS    41      20.653  47.201  30.317  1.00 24.26      A   
ATOM    326  C   LYS    41      24.296  42.734  32.364  1.00 11.96      A   
ATOM    327  O   LYS    41      25.473  42.694  32.725  1.00 11.71      A   
ATOM    328  N   LEU    42      23.818  42.028  31.341  1.00 10.32      A   
ATOM    329  CA  LEU    42      24.647  41.119  30.554  1.00 10.91      A   
ATOM    330  CB  LEU    42      23.781  40.360  29.538  1.00 12.07      A   
ATOM    331  CG  LEU    42      24.447  39.294  28.658  1.00 11.43      A   
ATOM    332  CD1 LEU    42      25.167  38.275  29.530  1.00 10.95      A   
ATOM    333  CD2 LEU    42      23.373  38.599  27.805  1.00 10.28      A   
ATOM    334  C   LEU    42      25.727  41.911  29.829  1.00 12.02      A   
ATOM    335  O   LEU    42      26.867  41.462  29.708  1.00 12.71      A   
ATOM    336  N   GLY    43      25.374  43.095  29.341  1.00 11.36      A   
ATOM    337  CA  GLY    43      26.364  43.909  28.658  1.00 12.15      A   
ATOM    338  C   GLY    43      25.936  44.512  27.334  1.00 12.98      A   
ATOM    339  O   GLY    43      24.777  44.888  27.145  1.00 13.96      A   
ATOM    340  N   ASP    44      26.889  44.590  26.413  1.00 13.19      A   
ATOM    341  CA  ASP    44      26.667  45.163  25.098  1.00 13.08      A   
ATOM    342  CB  ASP    44      27.591  46.370  24.902  1.00 16.85      A   
ATOM    343  CG  ASP    44      27.102  47.312  23.821  1.00 18.66      A   
ATOM    344  OD1 ASP    44      26.256  48.173  24.123  1.00 22.91      A   
ATOM    345  OD2 ASP    44      27.557  47.184  22.673  1.00 23.66      A   
ATOM    346  C   ASP    44      26.949  44.115  24.022  1.00 12.23      A   
ATOM    347  O   ASP    44      28.046  43.560  23.950  1.00 11.22      A   
ATOM    348  N   VAL    45      25.938  43.867  23.197  1.00 11.27      A   
ATOM    349  CA  VAL    45      25.962  42.901  22.104  1.00 12.11      A   
ATOM    350  CB  VAL    45      26.777  43.429  20.862  1.00 15.56      A   
ATOM    351  CG1 VAL    45      28.229  43.567  21.180  1.00 18.79      A   
ATOM    352  CG2 VAL    45      26.583  42.494  19.664  1.00 17.07      A   
ATOM    353  C   VAL    45      26.397  41.487  22.487  1.00 12.10      A   
ATOM    354  O   VAL    45      27.535  41.072  22.257  1.00 12.67      A   
ATOM    355  N   ALA    46      25.464  40.757  23.100  1.00 12.04      A   
ATOM    356  CA  ALA    46      25.696  39.364  23.471  1.00 13.53      A   
ATOM    357  CB  ALA    46      24.496  38.813  24.234  1.00 11.23      A   
ATOM    358  C   ALA    46      25.817  38.718  22.088  1.00 12.40      A   
ATOM    359  O   ALA    46      24.977  38.958  21.223  1.00 12.29      A   
ATOM    360  N   GLN    47      26.861  37.915  21.884  1.00 13.00      A   
ATOM    361  CA  GLN    47      27.157  37.292  20.584  1.00 13.02      A   
ATOM    362  CB  GLN    47      28.640  37.528  20.250  1.00 13.46      A   
ATOM    363  CG  GLN    47      29.140  36.833  18.975  1.00 17.70      A   
ATOM    364  CD  GLN    47      28.552  37.430  17.710  1.00 19.29      A   
ATOM    365  OE1 GLN    47      28.607  36.829  16.638  1.00 24.46      A   
ATOM    366  NE2 GLN    47      27.993  38.624  17.828  1.00 18.42      A   
ATOM    367  C   GLN    47      26.867  35.801  20.384  1.00 12.18      A   
ATOM    368  O   GLN    47      26.341  35.403  19.346  1.00 12.32      A   
ATOM    369  N   SER    48      27.238  34.973  21.352  1.00 10.31      A   
ATOM    370  CA  SER    48      27.042  33.538  21.210  1.00  9.58      A   
ATOM    371  CB  SER    48      28.149  32.948  20.328  1.00  9.73      A   
ATOM    372  OG  SER    48      29.417  33.104  20.954  1.00  7.67      A   
ATOM    373  C   SER    48      27.067  32.837  22.561  1.00 11.57      A   
ATOM    374  O   SER    48      27.361  33.450  23.593  1.00 10.49      A   
ATOM    375  N   MET    49      26.789  31.538  22.551  1.00 10.13      A   
ATOM    376  CA  MET    49      26.782  30.782  23.789  1.00 10.56      A   
ATOM    377  CB  MET    49      25.463  31.016  24.528  1.00 11.04      A   
ATOM    378  CG  MET    49      25.306  30.209  25.808  1.00 13.32      A   
ATOM    379  SD  MET    49      23.618  30.571  26.687  1.00 21.19      A   
ATOM    380  CE  MET    49      23.881  29.531  28.286  1.00 13.08      A   
ATOM    381  C   MET    49      26.990  29.288  23.582  1.00  9.56      A   
ATOM    382  O   MET    49      26.498  28.706  22.620  1.00  8.46      A   
ATOM    383  N   VAL    50      27.729  28.676  24.501  1.00  9.11      A   
ATOM    384  CA  VAL    50      27.995  27.246  24.451  1.00 10.59      A   
ATOM    385  CB  VAL    50      29.464  26.960  24.032  1.00 10.54      A   
ATOM    386  CG1 VAL    50      29.781  25.484  24.217  1.00 14.19      A   
ATOM    387  CG2 VAL    50      29.681  27.359  22.560  1.00  9.23      A   
ATOM    388  C   VAL    50      27.753  26.672  25.840  1.00 11.84      A   
ATOM    389  O   VAL    50      27.938  27.367  26.838  1.00 11.83      A   
ATOM    390  N   ILE    51      27.319  25.417  25.904  1.00 10.88      A   
ATOM    391  CA  ILE    51      27.080  24.761  27.186  1.00 13.10      A   
ATOM    392  CB  ILE    51      25.603  24.321  27.344  1.00 12.78      A   
ATOM    393  CG2 ILE    51      25.463  23.334  28.513  1.00 12.75      A   
ATOM    394  CG1 ILE    51      24.728  25.561  27.562  1.00  9.79      A   
ATOM    395  CD1 ILE    51      23.243  25.279  27.645  1.00 10.11      A   
ATOM    396  C   ILE    51      27.987  23.547  27.301  1.00 14.75      A   
ATOM    397  O   ILE    51      28.062  22.725  26.390  1.00 15.49      A   
ATOM    398  N   ARG    52      28.693  23.449  28.419  1.00 14.61      A   
ATOM    399  CA  ARG    52      29.596  22.334  28.642  1.00 17.23      A   
ATOM    400  CB  ARG    52      31.043  22.767  28.392  1.00 19.04      A   
ATOM    401  CG  ARG    52      32.067  21.636  28.457  1.00 20.85      A   
ATOM    402  CD  ARG    52      33.477  22.187  28.357  1.00 23.01      A   
ATOM    403  NE  ARG    52      34.514  21.158  28.446  1.00 24.83      A   
ATOM    404  CZ  ARG    52      34.826  20.313  27.468  1.00 27.20      A   
ATOM    405  NH1 ARG    52      34.178  20.365  26.310  1.00 27.43      A   
ATOM    406  NH2 ARG    52      35.800  19.426  27.642  1.00 29.48      A   
ATOM    407  C   ARG    52      29.432  21.851  30.074  1.00 17.76      A   
ATOM    408  O   ARG    52      29.667  22.597  31.020  1.00 18.00      A   
ATOM    409  N   ASP    53      29.002  20.604  30.220  1.00 21.11      A   
ATOM    410  CA  ASP    53      28.806  19.989  31.530  1.00 23.77      A   
ATOM    411  CB  ASP    53      30.144  19.480  32.073  1.00 27.96      A   
ATOM    412  CG  ASP    53      30.802  18.474  31.155  1.00 31.17      A   
ATOM    413  OD1 ASP    53      30.160  17.449  30.839  1.00 32.35      A   
ATOM    414  OD2 ASP    53      31.964  18.710  30.753  1.00 34.82      A   
ATOM    415  C   ASP    53      28.167  20.891  32.583  1.00 24.07      A   
ATOM    416  O   ASP    53      28.829  21.293  33.539  1.00 24.85      A   
ATOM    417  N   GLY    54      26.887  21.202  32.414  1.00 22.16      A   
ATOM    418  CA  GLY    54      26.192  22.028  33.388  1.00 21.65      A   
ATOM    419  C   GLY    54      26.597  23.490  33.490  1.00 20.86      A   
ATOM    420  O   GLY    54      26.116  24.211  34.367  1.00 21.53      A   
ATOM    421  N   ILE    55      27.475  23.940  32.600  1.00 18.65      A   
ATOM    422  CA  ILE    55      27.919  25.328  32.620  1.00 16.82      A   
ATOM    423  CB  ILE    55      29.407  25.424  32.994  1.00 18.98      A   
ATOM    424  CG2 ILE    55      29.857  26.884  32.952  1.00 18.09      A   
ATOM    425  CG1 ILE    55      29.627  24.802  34.377  1.00 19.51      A   
ATOM    426  CD1 ILE    55      31.089  24.710  34.805  1.00 25.36      A   
ATOM    427  C   ILE    55      27.716  25.992  31.264  1.00 15.78      A   
ATOM    428  O   ILE    55      28.101  25.443  30.234  1.00 14.55      A   
ATOM    429  N   GLY    56      27.110  27.173  31.267  1.00 13.18      A   
ATOM    430  CA  GLY    56      26.887  27.877  30.021  1.00 12.33      A   
ATOM    431  C   GLY    56      27.866  29.022  29.886  1.00 11.63      A   
ATOM    432  O   GLY    56      28.045  29.799  30.822  1.00 11.99      A   
ATOM    433  N   TRP    57      28.518  29.123  28.733  1.00 10.88      A   
ATOM    434  CA  TRP    57      29.471  30.201  28.503  1.00 11.20      A   
ATOM    435  CB  TRP    57      30.799  29.644  27.991  1.00 12.83      A   
ATOM    436  CG  TRP    57      31.412  28.683  28.944  1.00 14.14      A   
ATOM    437  CD2 TRP    57      32.496  28.939  29.841  1.00 14.63      A   
ATOM    438  CE2 TRP    57      32.699  27.764  30.595  1.00 14.85      A   
ATOM    439  CE3 TRP    57      33.313  30.050  30.086  1.00 14.13      A   
ATOM    440  CD1 TRP    57      31.014  27.400  29.178  1.00 14.41      A   
ATOM    441  NE1 TRP    57      31.781  26.840  30.169  1.00 16.22      A   
ATOM    442  CZ2 TRP    57      33.690  27.663  31.576  1.00 14.88      A   
ATOM    443  CZ3 TRP    57      34.300  29.951  31.064  1.00 14.98      A   
ATOM    444  CH2 TRP    57      34.478  28.764  31.796  1.00 14.83      A   
ATOM    445  C   TRP    57      28.874  31.176  27.500  1.00 10.81      A   
ATOM    446  O   TRP    57      28.622  30.824  26.348  1.00  8.92      A   
ATOM    447  N   ILE    58      28.647  32.403  27.958  1.00  9.82      A   
ATOM    448  CA  ILE    58      28.048  33.450  27.139  1.00 10.00      A   
ATOM    449  CB  ILE    58      26.933  34.194  27.923  1.00  8.88      A   
ATOM    450  CG2 ILE    58      26.171  35.123  26.989  1.00  7.97      A   
ATOM    451  CG1 ILE    58      25.952  33.196  28.538  1.00  8.09      A   
ATOM    452  CD1 ILE    58      25.057  33.820  29.594  1.00  8.00      A   
ATOM    453  C   ILE    58      29.084  34.482  26.706  1.00 10.62      A   
ATOM    454  O   ILE    58      29.708  35.138  27.542  1.00  9.85      A   
ATOM    455  N   VAL    59      29.250  34.633  25.396  1.00 10.13      A   
ATOM    456  CA  VAL    59      30.200  35.595  24.855  1.00 10.23      A   
ATOM    457  CB  VAL    59      30.776  35.104  23.506  1.00 10.40      A   
ATOM    458  CG1 VAL    59      31.802  36.099  22.975  1.00  8.99      A   
ATOM    459  CG2 VAL    59      31.411  33.731  23.684  1.00 10.16      A   
ATOM    460  C   VAL    59      29.507  36.939  24.640  1.00 11.66      A   
ATOM    461  O   VAL    59      28.500  37.017  23.940  1.00 10.86      A   
ATOM    462  N   VAL    60      30.044  37.993  25.251  1.00 11.26      A   
ATOM    463  CA  VAL    60      29.472  39.325  25.112  1.00 10.81      A   
ATOM    464  CB  VAL    60      29.164  39.939  26.498  1.00 12.15      A   
ATOM    465  CG1 VAL    60      28.270  41.163  26.344  1.00 10.53      A   
ATOM    466  CG2 VAL    60      28.466  38.893  27.368  1.00  9.35      A   
ATOM    467  C   VAL    60      30.486  40.161  24.340  1.00 13.57      A   
ATOM    468  O   VAL    60      31.423  40.733  24.899  1.00 11.36      A   
ATOM    469  N   ASN    61      30.277  40.203  23.029  1.00 11.95      A   
ATOM    470  CA  ASN    61      31.159  40.890  22.105  1.00 12.34      A   
ATOM    471  CB  ASN    61      30.517  40.943  20.719  1.00 10.40      A   
ATOM    472  CG  ASN    61      31.330  41.764  19.748  1.00 11.28      A   
ATOM    473  OD1 ASN    61      30.975  42.896  19.429  1.00 12.09      A   
ATOM    474  ND2 ASN    61      32.442  41.206  19.289  1.00 10.20      A   
ATOM    475  C   ASN    61      31.674  42.279  22.454  1.00 13.07      A   
ATOM    476  O   ASN    61      32.883  42.508  22.448  1.00 13.91      A   
ATOM    477  N   ASN    62      30.777  43.210  22.746  1.00 13.75      A   
ATOM    478  CA  ASN    62      31.218  44.567  23.030  1.00 15.63      A   
ATOM    479  CB  ASN    62      30.273  45.562  22.358  1.00 15.47      A   
ATOM    480  CG  ASN    62      30.890  46.930  22.196  1.00 15.91      A   
ATOM    481  OD1 ASN    62      32.065  47.054  21.843  1.00 17.27      A   
ATOM    482  ND2 ASN    62      30.097  47.970  22.440  1.00 14.77      A   
ATOM    483  C   ASN    62      31.384  44.891  24.509  1.00 14.97      A   
ATOM    484  O   ASN    62      31.379  46.059  24.903  1.00 14.05      A   
ATOM    485  N   SER    63      31.533  43.846  25.318  1.00 15.02      A   
ATOM    486  CA  SER    63      31.741  44.001  26.752  1.00 15.16      A   
ATOM    487  CB  SER    63      30.584  43.387  27.542  1.00 14.95      A   
ATOM    488  OG  SER    63      29.407  44.166  27.387  1.00 14.83      A   
ATOM    489  C   SER    63      33.072  43.357  27.138  1.00 15.35      A   
ATOM    490  O   SER    63      33.446  43.317  28.311  1.00 13.84      A   
ATOM    491  N   HIS    64      33.780  42.841  26.135  1.00 14.86      A   
ATOM    492  CA  HIS    64      35.098  42.247  26.347  1.00 17.20      A   
ATOM    493  CB  HIS    64      36.074  43.360  26.741  1.00 20.63      A   
ATOM    494  CG  HIS    64      35.971  44.585  25.884  1.00 23.91      A   
ATOM    495  CD2 HIS    64      35.442  45.807  26.136  1.00 26.04      A   
ATOM    496  ND1 HIS    64      36.423  44.627  24.582  1.00 27.46      A   
ATOM    497  CE1 HIS    64      36.178  45.820  24.069  1.00 26.48      A   
ATOM    498  NE2 HIS    64      35.583  46.554  24.992  1.00 28.58      A   
ATOM    499  C   HIS    64      35.113  41.163  27.425  1.00 16.71      A   
ATOM    500  O   HIS    64      36.072  41.062  28.193  1.00 16.49      A   
ATOM    501  N   VAL    65      34.080  40.329  27.467  1.00 15.31      A   
ATOM    502  CA  VAL    65      34.005  39.312  28.511  1.00 13.50      A   
ATOM    503  CB  VAL    65      33.386  39.938  29.797  1.00 14.67      A   
ATOM    504  CG1 VAL    65      31.996  40.487  29.480  1.00 14.61      A   
ATOM    505  CG2 VAL    65      33.307  38.918  30.930  1.00 11.96      A   
ATOM    506  C   VAL    65      33.185  38.083  28.132  1.00 14.49      A   
ATOM    507  O   VAL    65      32.375  38.114  27.203  1.00 13.23      A   
ATOM    508  N   ILE    66      33.430  36.992  28.847  1.00 12.33      A   
ATOM    509  CA  ILE    66      32.676  35.762  28.669  1.00 12.89      A   
ATOM    510  CB  ILE    66      33.515  34.620  28.068  1.00 14.20      A   
ATOM    511  CG2 ILE    66      32.719  33.313  28.131  1.00 15.75      A   
ATOM    512  CG1 ILE    66      33.864  34.943  26.616  1.00 12.45      A   
ATOM    513  CD1 ILE    66      34.739  33.899  25.947  1.00 16.15      A   
ATOM    514  C   ILE    66      32.230  35.371  30.069  1.00 13.47      A   
ATOM    515  O   ILE    66      33.042  35.278  30.996  1.00 14.17      A   
ATOM    516  N   PHE    67      30.928  35.169  30.209  1.00 12.28      A   
ATOM    517  CA  PHE    67      30.320  34.795  31.474  1.00 11.87      A   
ATOM    518  CB  PHE    67      28.997  35.535  31.661  1.00 12.29      A   
ATOM    519  CG  PHE    67      29.148  36.966  32.080  1.00 12.11      A   
ATOM    520  CD1 PHE    67      29.555  37.283  33.370  1.00 14.03      A   
ATOM    521  CD2 PHE    67      28.860  37.999  31.194  1.00 12.58      A   
ATOM    522  CE1 PHE    67      29.670  38.610  33.774  1.00 13.05      A   
ATOM    523  CE2 PHE    67      28.974  39.332  31.590  1.00 15.02      A   
ATOM    524  CZ  PHE    67      29.378  39.637  32.883  1.00 12.87      A   
ATOM    525  C   PHE    67      30.045  33.307  31.547  1.00 13.41      A   
ATOM    526  O   PHE    67      29.572  32.704  30.584  1.00 14.57      A   
ATOM    527  N   ALA    68      30.347  32.719  32.696  1.00 12.59      A   
ATOM    528  CA  ALA    68      30.090  31.303  32.925  1.00 13.08      A   
ATOM    529  CB  ALA    68      31.324  30.628  33.517  1.00 11.87      A   
ATOM    530  C   ALA    68      28.942  31.274  33.926  1.00 13.03      A   
ATOM    531  O   ALA    68      29.069  31.810  35.028  1.00 13.69      A   
ATOM    532  N   ILE    69      27.823  30.661  33.550  1.00 11.65      A   
ATOM    533  CA  ILE    69      26.667  30.596  34.439  1.00 11.72      A   
ATOM    534  CB  ILE    69      25.481  31.440  33.910  1.00 11.81      A   
ATOM    535  CG2 ILE    69      25.875  32.906  33.803  1.00  8.87      A   
ATOM    536  CG1 ILE    69      25.028  30.888  32.556  1.00 11.63      A   
ATOM    537  CD1 ILE    69      23.647  31.336  32.139  1.00 10.42      A   
ATOM    538  C   ILE    69      26.136  29.180  34.621  1.00 14.07      A   
ATOM    539  O   ILE    69      26.365  28.299  33.788  1.00 12.21      A   
ATOM    540  N   ASP    70      25.420  28.972  35.720  1.00 14.18      A   
ATOM    541  CA  ASP    70      24.812  27.681  35.999  1.00 16.23      A   
ATOM    542  CB  ASP    70      24.352  27.627  37.452  1.00 16.47      A   
ATOM    543  CG  ASP    70      23.721  26.302  37.810  1.00 17.34      A   
ATOM    544  OD1 ASP    70      22.569  26.061  37.407  1.00 17.45      A   
ATOM    545  OD2 ASP    70      24.392  25.501  38.484  1.00 19.67      A   
ATOM    546  C   ASP    70      23.609  27.600  35.055  1.00 16.35      A   
ATOM    547  O   ASP    70      22.729  28.450  35.104  1.00 16.48      A   
ATOM    548  N   ILE    71      23.573  26.583  34.197  1.00 15.31      A   
ATOM    549  CA  ILE    71      22.490  26.443  33.224  1.00 16.44      A   
ATOM    550  CB  ILE    71      22.757  25.271  32.249  1.00 15.04      A   
ATOM    551  CG2 ILE    71      24.069  25.490  31.522  1.00 16.73      A   
ATOM    552  CG1 ILE    71      22.787  23.950  33.018  1.00 15.68      A   
ATOM    553  CD1 ILE    71      22.908  22.732  32.135  1.00 16.68      A   
ATOM    554  C   ILE    71      21.097  26.251  33.814  1.00 17.33      A   
ATOM    555  O   ILE    71      20.108  26.264  33.084  1.00 17.25      A   
ATOM    556  N   ASN    72      21.016  26.063  35.126  1.00 18.64      A   
ATOM    557  CA  ASN    72      19.731  25.866  35.782  1.00 19.26      A   
ATOM    558  CB  ASN    72      19.811  24.687  36.745  1.00 20.62      A   
ATOM    559  CG  ASN    72      20.025  23.378  36.029  1.00 21.98      A   
ATOM    560  OD1 ASN    72      19.214  22.979  35.192  1.00 21.86      A   
ATOM    561  ND2 ASN    72      21.120  22.700  36.347  1.00 22.14      A   
ATOM    562  C   ASN    72      19.265  27.097  36.540  1.00 18.74      A   
ATOM    563  O   ASN    72      18.103  27.494  36.445  1.00 19.59      A   
ATOM    564  N   THR    73      20.173  27.699  37.299  1.00 18.40      A   
ATOM    565  CA  THR    73      19.839  28.884  38.080  1.00 17.76      A   
ATOM    566  CB  THR    73      20.571  28.875  39.442  1.00 17.09      A   
ATOM    567  OG1 THR    73      21.988  28.942  39.229  1.00 16.54      A   
ATOM    568  CG2 THR    73      20.239  27.616  40.221  1.00 15.93      A   
ATOM    569  C   THR    73      20.198  30.175  37.348  1.00 18.11      A   
ATOM    570  O   THR    73      19.763  31.257  37.737  1.00 17.08      A   
ATOM    571  N   PHE    74      20.987  30.050  36.284  1.00 16.49      A   
ATOM    572  CA  PHE    74      21.428  31.201  35.491  1.00 16.87      A   
ATOM    573  CB  PHE    74      20.232  32.051  35.026  1.00 17.22      A   
ATOM    574  CG  PHE    74      19.147  31.265  34.339  1.00 17.03      A   
ATOM    575  CD1 PHE    74      19.459  30.282  33.406  1.00 18.64      A   
ATOM    576  CD2 PHE    74      17.809  31.512  34.627  1.00 19.01      A   
ATOM    577  CE1 PHE    74      18.452  29.550  32.774  1.00 18.00      A   
ATOM    578  CE2 PHE    74      16.794  30.788  34.000  1.00 19.27      A   
ATOM    579  CZ  PHE    74      17.118  29.805  33.071  1.00 20.16      A   
ATOM    580  C   PHE    74      22.395  32.088  36.279  1.00 16.61      A   
ATOM    581  O   PHE    74      22.838  33.125  35.782  1.00 15.91      A   
ATOM    582  N   LYS    75      22.727  31.687  37.504  1.00 15.96      A   
ATOM    583  CA  LYS    75      23.647  32.478  38.317  1.00 15.08      A   
ATOM    584  CB  LYS    75      23.535  32.090  39.795  1.00 16.64      A   
ATOM    585  CG  LYS    75      22.176  32.397  40.394  1.00 20.68      A   
ATOM    586  CD  LYS    75      22.264  32.672  41.886  1.00 24.68      A   
ATOM    587  CE  LYS    75      23.127  33.901  42.165  1.00 26.46      A   
ATOM    588  NZ  LYS    75      23.226  34.209  43.620  1.00 28.22      A   
ATOM    589  C   LYS    75      25.092  32.328  37.845  1.00 14.37      A   
ATOM    590  O   LYS    75      25.527  31.240  37.467  1.00 14.14      A   
ATOM    591  N   GLU    76      25.831  33.431  37.863  1.00 15.11      A   
ATOM    592  CA  GLU    76      27.224  33.428  37.429  1.00 15.12      A   
ATOM    593  CB  GLU    76      27.762  34.862  37.380  1.00 16.26      A   
ATOM    594  CG  GLU    76      29.187  34.964  36.853  1.00 17.27      A   
ATOM    595  CD  GLU    76      29.850  36.291  37.174  1.00 19.81      A   
ATOM    596  OE1 GLU    76      29.133  37.286  37.416  1.00 18.88      A   
ATOM    597  OE2 GLU    76      31.098  36.344  37.170  1.00 19.73      A   
ATOM    598  C   GLU    76      28.121  32.600  38.349  1.00 15.73      A   
ATOM    599  O   GLU    76      28.035  32.709  39.573  1.00 14.61      A   
ATOM    600  N   VAL    77      28.973  31.768  37.754  1.00 15.37      A   
ATOM    601  CA  VAL    77      29.911  30.956  38.524  1.00 17.01      A   
ATOM    602  CB  VAL    77      29.826  29.448  38.158  1.00 17.38      A   
ATOM    603  CG1 VAL    77      28.502  28.873  38.636  1.00 20.70      A   
ATOM    604  CG2 VAL    77      29.975  29.255  36.653  1.00 19.86      A   
ATOM    605  C   VAL    77      31.330  31.453  38.266  1.00 17.46      A   
ATOM    606  O   VAL    77      32.261  31.121  39.000  1.00 19.78      A   
ATOM    607  N   GLY    78      31.487  32.262  37.222  1.00 14.79      A   
ATOM    608  CA  GLY    78      32.794  32.801  36.891  1.00 15.58      A   
ATOM    609  C   GLY    78      32.730  33.662  35.647  1.00 14.10      A   
ATOM    610  O   GLY    78      31.682  33.740  35.013  1.00 12.90      A   
ATOM    611  N   ARG    79      33.838  34.316  35.305  1.00 14.10      A   
ATOM    612  CA  ARG    79      33.899  35.161  34.115  1.00 15.56      A   
ATOM    613  CB  ARG    79      33.229  36.515  34.371  1.00 16.23      A   
ATOM    614  CG  ARG    79      34.127  37.498  35.109  1.00 16.78      A   
ATOM    615  CD  ARG    79      33.452  38.839  35.355  1.00 18.70      A   
ATOM    616  NE  ARG    79      32.304  38.750  36.255  1.00 15.74      A   
ATOM    617  CZ  ARG    79      31.689  39.814  36.764  1.00 18.57      A   
ATOM    618  NH1 ARG    79      32.120  41.029  36.459  1.00 18.76      A   
ATOM    619  NH2 ARG    79      30.648  39.671  37.569  1.00 17.50      A   
ATOM    620  C   ARG    79      35.345  35.411  33.695  1.00 16.87      A   
ATOM    621  O   ARG    79      36.267  35.351  34.512  1.00 15.86      A   
ATOM    622  N   ILE    80      35.539  35.699  32.414  1.00 15.61      A   
ATOM    623  CA  ILE    80      36.871  35.988  31.905  1.00 17.79      A   
ATOM    624  CB  ILE    80      37.382  34.863  30.985  1.00 18.19      A   
ATOM    625  CG2 ILE    80      38.819  35.136  30.577  1.00 17.77      A   
ATOM    626  CG1 ILE    80      37.312  33.524  31.719  1.00 20.31      A   
ATOM    627  CD1 ILE    80      37.613  32.333  30.831  1.00 19.32      A   
ATOM    628  C   ILE    80      36.801  37.291  31.124  1.00 17.44      A   
ATOM    629  O   ILE    80      36.018  37.416  30.183  1.00 17.80      A   
ATOM    630  N   THR    81      37.602  38.270  31.533  1.00 17.50      A   
ATOM    631  CA  THR    81      37.628  39.563  30.860  1.00 18.62      A   
ATOM    632  CB  THR    81      37.456  40.726  31.860  1.00 20.23      A   
ATOM    633  OG1 THR    81      38.478  40.647  32.861  1.00 20.92      A   
ATOM    634  CG2 THR    81      36.092  40.666  32.526  1.00 20.40      A   
ATOM    635  C   THR    81      38.956  39.741  30.139  1.00 18.82      A   
ATOM    636  O   THR    81      39.824  38.877  30.214  1.00 21.43      A   
ATOM    637  N   GLY    82      39.103  40.853  29.427  1.00 19.19      A   
ATOM    638  CA  GLY    82      40.342  41.104  28.716  1.00 17.76      A   
ATOM    639  C   GLY    82      40.305  40.838  27.220  1.00 18.98      A   
ATOM    640  O   GLY    82      41.287  41.094  26.521  1.00 17.87      A   
ATOM    641  N   PHE    83      39.186  40.322  26.720  1.00 18.27      A   
ATOM    642  CA  PHE    83      39.055  40.039  25.292  1.00 16.97      A   
ATOM    643  CB  PHE    83      37.862  39.113  25.042  1.00 14.25      A   
ATOM    644  CG  PHE    83      37.947  37.806  25.772  1.00 13.40      A   
ATOM    645  CD1 PHE    83      38.948  36.889  25.465  1.00 14.51      A   
ATOM    646  CD2 PHE    83      37.035  37.494  26.775  1.00 13.18      A   
ATOM    647  CE1 PHE    83      39.042  35.675  26.144  1.00 11.81      A   
ATOM    648  CE2 PHE    83      37.117  36.282  27.462  1.00 12.06      A   
ATOM    649  CZ  PHE    83      38.124  35.372  27.144  1.00 13.41      A   
ATOM    650  C   PHE    83      38.871  41.318  24.485  1.00 16.87      A   
ATOM    651  O   PHE    83      38.129  42.214  24.888  1.00 17.87      A   
ATOM    652  N   THR    84      39.538  41.391  23.336  1.00 17.24      A   
ATOM    653  CA  THR    84      39.461  42.555  22.447  1.00 16.49      A   
ATOM    654  CB  THR    84      40.340  42.343  21.205  1.00 18.44      A   
ATOM    655  OG1 THR    84      41.672  42.018  21.620  1.00 19.86      A   
ATOM    656  CG2 THR    84      40.365  43.596  20.339  1.00 16.29      A   
ATOM    657  C   THR    84      38.026  42.788  21.980  1.00 17.37      A   
ATOM    658  O   THR    84      37.492  43.892  22.080  1.00 17.04      A   
ATOM    659  N   SER    85      37.411  41.735  21.457  1.00 15.43      A   
ATOM    660  CA  SER    85      36.035  41.797  20.977  1.00 14.03      A   
ATOM    661  CB  SER    85      35.947  42.713  19.759  1.00 13.15      A   
ATOM    662  OG  SER    85      34.596  42.948  19.407  1.00 11.94      A   
ATOM    663  C   SER    85      35.704  40.357  20.604  1.00 13.24      A   
ATOM    664  O   SER    85      35.693  39.991  19.429  1.00 12.39      A   
ATOM    665  N   PRO    86      35.429  39.525  21.623  1.00 12.25      A   
ATOM    666  CD  PRO    86      35.152  40.010  22.989  1.00 11.22      A   
ATOM    667  CA  PRO    86      35.103  38.099  21.507  1.00 12.29      A   
ATOM    668  CB  PRO    86      34.881  37.678  22.957  1.00 11.52      A   
ATOM    669  CG  PRO    86      34.279  38.904  23.562  1.00  9.44      A   
ATOM    670  C   PRO    86      33.942  37.731  20.597  1.00 11.62      A   
ATOM    671  O   PRO    86      32.930  38.428  20.523  1.00 11.35      A   
ATOM    672  N   ARG    87      34.109  36.609  19.909  1.00 12.71      A   
ATOM    673  CA  ARG    87      33.111  36.129  18.973  1.00 12.10      A   
ATOM    674  CB  ARG    87      33.735  36.046  17.577  1.00 11.54      A   
ATOM    675  CG  ARG    87      34.358  37.365  17.103  1.00 12.02      A   
ATOM    676  CD  ARG    87      33.320  38.490  16.985  1.00 12.80      A   
ATOM    677  NE  ARG    87      32.342  38.251  15.923  1.00 11.73      A   
ATOM    678  CZ  ARG    87      31.263  39.003  15.715  1.00 13.01      A   
ATOM    679  NH1 ARG    87      30.430  38.716  14.725  1.00 14.34      A   
ATOM    680  NH2 ARG    87      31.012  40.041  16.502  1.00 12.81      A   
ATOM    681  C   ARG    87      32.541  34.778  19.392  1.00 11.06      A   
ATOM    682  O   ARG    87      31.368  34.680  19.764  1.00 11.12      A   
ATOM    683  N   TYR    88      33.371  33.742  19.336  1.00  9.36      A   
ATOM    684  CA  TYR    88      32.941  32.400  19.707  1.00  9.99      A   
ATOM    685  CB  TYR    88      32.671  31.551  18.457  1.00 10.75      A   
ATOM    686  CG  TYR    88      31.518  32.058  17.619  1.00 10.49      A   
ATOM    687  CD1 TYR    88      31.681  33.149  16.765  1.00 10.16      A   
ATOM    688  CE1 TYR    88      30.608  33.670  16.049  1.00 10.80      A   
ATOM    689  CD2 TYR    88      30.247  31.490  17.731  1.00 10.11      A   
ATOM    690  CE2 TYR    88      29.163  32.003  17.018  1.00 11.44      A   
ATOM    691  CZ  TYR    88      29.353  33.098  16.179  1.00 12.33      A   
ATOM    692  OH  TYR    88      28.293  33.637  15.489  1.00 11.63      A   
ATOM    693  C   TYR    88      33.972  31.696  20.567  1.00 10.37      A   
ATOM    694  O   TYR    88      35.138  32.085  20.605  1.00 10.98      A   
ATOM    695  N   ILE    89      33.529  30.660  21.264  1.00 12.01      A   
ATOM    696  CA  ILE    89      34.419  29.885  22.102  1.00 11.38      A   
ATOM    697  CB  ILE    89      34.100  30.100  23.609  1.00 13.06      A   
ATOM    698  CG2 ILE    89      32.661  29.735  23.909  1.00 12.17      A   
ATOM    699  CG1 ILE    89      35.069  29.285  24.464  1.00 12.68      A   
ATOM    700  CD1 ILE    89      35.011  29.634  25.939  1.00 15.76      A   
ATOM    701  C   ILE    89      34.298  28.414  21.722  1.00 12.89      A   
ATOM    702  O   ILE    89      33.197  27.914  21.487  1.00 11.17      A   
ATOM    703  N   HIS    90      35.446  27.747  21.618  1.00 12.55      A   
ATOM    704  CA  HIS    90      35.510  26.330  21.276  1.00 13.75      A   
ATOM    705  CB  HIS    90      36.121  26.116  19.888  1.00 13.21      A   
ATOM    706  CG  HIS    90      36.314  24.672  19.540  1.00 15.26      A   
ATOM    707  CD2 HIS    90      37.418  23.888  19.568  1.00 15.14      A   
ATOM    708  ND1 HIS    90      35.268  23.846  19.186  1.00 15.11      A   
ATOM    709  CE1 HIS    90      35.719  22.616  19.016  1.00 14.25      A   
ATOM    710  NE2 HIS    90      37.020  22.614  19.243  1.00 14.94      A   
ATOM    711  C   HIS    90      36.386  25.633  22.305  1.00 12.49      A   
ATOM    712  O   HIS    90      37.543  26.000  22.491  1.00 11.63      A   
ATOM    713  N   PHE    91      35.834  24.622  22.967  1.00 13.04      A   
ATOM    714  CA  PHE    91      36.576  23.884  23.984  1.00 14.31      A   
ATOM    715  CB  PHE    91      35.622  23.336  25.047  1.00 13.70      A   
ATOM    716  CG  PHE    91      35.060  24.385  25.957  1.00 15.65      A   
ATOM    717  CD1 PHE    91      35.604  24.593  27.219  1.00 15.08      A   
ATOM    718  CD2 PHE    91      33.985  25.171  25.551  1.00 14.42      A   
ATOM    719  CE1 PHE    91      35.088  25.571  28.065  1.00 15.66      A   
ATOM    720  CE2 PHE    91      33.461  26.153  26.386  1.00 15.41      A   
ATOM    721  CZ  PHE    91      34.014  26.353  27.648  1.00 16.50      A   
ATOM    722  C   PHE    91      37.382  22.722  23.418  1.00 14.37      A   
ATOM    723  O   PHE    91      36.879  21.938  22.613  1.00 14.22      A   
ATOM    724  N   LEU    92      38.634  22.626  23.858  1.00 16.22      A   
ATOM    725  CA  LEU    92      39.535  21.551  23.454  1.00 18.25      A   
ATOM    726  CB  LEU    92      40.937  22.097  23.137  1.00 19.04      A   
ATOM    727  CG  LEU    92      41.159  22.963  21.888  1.00 19.91      A   
ATOM    728  CD1 LEU    92      40.589  22.242  20.670  1.00 18.76      A   
ATOM    729  CD2 LEU    92      40.497  24.322  22.060  1.00 21.58      A   
ATOM    730  C   LEU    92      39.611  20.578  24.633  1.00 19.42      A   
ATOM    731  O   LEU    92      39.834  19.380  24.459  1.00 20.08      A   
ATOM    732  N   SER    93      39.413  21.119  25.834  1.00 19.41      A   
ATOM    733  CA  SER    93      39.433  20.347  27.077  1.00 19.61      A   
ATOM    734  CB  SER    93      40.860  19.931  27.441  1.00 19.84      A   
ATOM    735  OG  SER    93      41.585  21.034  27.963  1.00 18.09      A   
ATOM    736  C   SER    93      38.887  21.220  28.200  1.00 20.07      A   
ATOM    737  O   SER    93      38.541  22.384  27.981  1.00 17.99      A   
ATOM    738  N   ASP    94      38.826  20.656  29.404  1.00 19.86      A   
ATOM    739  CA  ASP    94      38.347  21.382  30.576  1.00 22.66      A   
ATOM    740  CB  ASP    94      38.163  20.416  31.758  1.00 24.75      A   
ATOM    741  CG  ASP    94      36.893  19.584  31.646  1.00 28.28      A   
ATOM    742  OD1 ASP    94      36.404  19.379  30.513  1.00 31.75      A   
ATOM    743  OD2 ASP    94      36.386  19.121  32.690  1.00 30.08      A   
ATOM    744  C   ASP    94      39.309  22.507  30.972  1.00 21.64      A   
ATOM    745  O   ASP    94      38.930  23.427  31.697  1.00 21.06      A   
ATOM    746  N   GLU    95      40.544  22.446  30.484  1.00 20.98      A   
ATOM    747  CA  GLU    95      41.529  23.468  30.821  1.00 21.30      A   
ATOM    748  CB  GLU    95      42.715  22.820  31.534  1.00 25.32      A   
ATOM    749  CG  GLU    95      42.308  21.980  32.735  1.00 30.46      A   
ATOM    750  CD  GLU    95      43.421  21.071  33.223  1.00 34.11      A   
ATOM    751  OE1 GLU    95      43.139  20.200  34.073  1.00 35.80      A   
ATOM    752  OE2 GLU    95      44.571  21.227  32.757  1.00 35.34      A   
ATOM    753  C   GLU    95      42.031  24.273  29.626  1.00 18.85      A   
ATOM    754  O   GLU    95      42.908  25.123  29.773  1.00 17.66      A   
ATOM    755  N   LYS    96      41.470  24.027  28.449  1.00 16.88      A   
ATOM    756  CA  LYS    96      41.912  24.747  27.263  1.00 15.66      A   
ATOM    757  CB  LYS    96      43.055  23.967  26.606  1.00 17.59      A   
ATOM    758  CG  LYS    96      43.577  24.538  25.296  1.00 18.18      A   
ATOM    759  CD  LYS    96      44.717  23.666  24.779  1.00 18.45      A   
ATOM    760  CE  LYS    96      45.129  24.026  23.376  1.00 18.35      A   
ATOM    761  NZ  LYS    96      46.198  23.103  22.904  1.00 17.81      A   
ATOM    762  C   LYS    96      40.787  24.985  26.256  1.00 15.34      A   
ATOM    763  O   LYS    96      40.086  24.054  25.862  1.00 15.99      A   
ATOM    764  N   ALA    97      40.618  26.238  25.842  1.00 14.71      A   
ATOM    765  CA  ALA    97      39.585  26.597  24.871  1.00 14.75      A   
ATOM    766  CB  ALA    97      38.269  26.922  25.593  1.00 13.05      A   
ATOM    767  C   ALA    97      40.048  27.803  24.061  1.00 14.01      A   
ATOM    768  O   ALA    97      40.859  28.594  24.539  1.00 15.34      A   
ATOM    769  N   TYR    98      39.553  27.933  22.832  1.00 13.35      A   
ATOM    770  CA  TYR    98      39.918  29.064  21.986  1.00 12.53      A   
ATOM    771  CB  TYR    98      40.198  28.631  20.541  1.00 13.61      A   
ATOM    772  CG  TYR    98      41.363  27.686  20.338  1.00 13.16      A   
ATOM    773  CD1 TYR    98      42.448  27.667  21.217  1.00 14.40      A   
ATOM    774  CE1 TYR    98      43.548  26.840  20.986  1.00 13.14      A   
ATOM    775  CD2 TYR    98      41.407  26.851  19.221  1.00 12.51      A   
ATOM    776  CE2 TYR    98      42.499  26.025  18.977  1.00 14.34      A   
ATOM    777  CZ  TYR    98      43.566  26.026  19.861  1.00 13.71      A   
ATOM    778  OH  TYR    98      44.656  25.229  19.597  1.00 13.12      A   
ATOM    779  C   TYR    98      38.772  30.069  21.952  1.00 13.06      A   
ATOM    780  O   TYR    98      37.603  29.690  22.027  1.00 13.51      A   
ATOM    781  N   VAL    99      39.114  31.348  21.838  1.00 11.53      A   
ATOM    782  CA  VAL    99      38.117  32.410  21.765  1.00 11.27      A   
ATOM    783  CB  VAL    99      38.055  33.252  23.069  1.00 11.78      A   
ATOM    784  CG1 VAL    99      36.965  34.314  22.936  1.00 10.54      A   
ATOM    785  CG2 VAL    99      37.784  32.356  24.274  1.00 10.20      A   
ATOM    786  C   VAL    99      38.519  33.328  20.616  1.00 12.11      A   
ATOM    787  O   VAL    99      39.531  34.024  20.705  1.00 11.04      A   
ATOM    788  N   THR   100      37.739  33.313  19.535  1.00 11.29      A   
ATOM    789  CA  THR   100      38.024  34.150  18.369  1.00 12.09      A   
ATOM    790  CB  THR   100      37.242  33.681  17.110  1.00 11.31      A   
ATOM    791  OG1 THR   100      35.885  33.383  17.465  1.00 12.04      A   
ATOM    792  CG2 THR   100      37.899  32.445  16.502  1.00 11.04      A   
ATOM    793  C   THR   100      37.689  35.606  18.657  1.00 12.23      A   
ATOM    794  O   THR   100      36.975  35.907  19.613  1.00 12.55      A   
ATOM    795  N   GLN   101      38.193  36.506  17.818  1.00 12.64      A   
ATOM    796  CA  GLN   101      37.992  37.936  18.024  1.00 13.21      A   
ATOM    797  CB  GLN   101      39.204  38.518  18.759  1.00 15.06      A   
ATOM    798  CG  GLN   101      39.747  37.711  19.927  1.00 16.30      A   
ATOM    799  CD  GLN   101      38.964  37.920  21.188  1.00 18.49      A   
ATOM    800  OE1 GLN   101      38.566  39.045  21.500  1.00 17.52      A   
ATOM    801  NE2 GLN   101      38.744  36.843  21.938  1.00 18.44      A   
ATOM    802  C   GLN   101      37.866  38.718  16.723  1.00 13.46      A   
ATOM    803  O   GLN   101      38.291  38.255  15.668  1.00 12.84      A   
ATOM    804  N   ILE   102      37.279  39.909  16.805  1.00 12.84      A   
ATOM    805  CA  ILE   102      37.217  40.791  15.649  1.00 13.87      A   
ATOM    806  CB  ILE   102      35.782  41.248  15.294  1.00 13.84      A   
ATOM    807  CG2 ILE   102      35.180  42.068  16.426  1.00 13.97      A   
ATOM    808  CG1 ILE   102      35.833  42.067  14.001  1.00 13.39      A   
ATOM    809  CD1 ILE   102      34.473  42.483  13.459  1.00 16.80      A   
ATOM    810  C   ILE   102      38.064  41.986  16.107  1.00 14.82      A   
ATOM    811  O   ILE   102      38.134  42.269  17.306  1.00 14.60      A   
ATOM    812  N   TRP   103      38.717  42.660  15.164  1.00 16.00      A   
ATOM    813  CA  TRP   103      39.594  43.792  15.466  1.00 17.63      A   
ATOM    814  CB  TRP   103      38.878  44.831  16.345  1.00 19.39      A   
ATOM    815  CG  TRP   103      37.517  45.255  15.833  1.00 19.29      A   
ATOM    816  CD2 TRP   103      37.175  45.652  14.495  1.00 19.62      A   
ATOM    817  CE2 TRP   103      35.786  45.918  14.481  1.00 19.88      A   
ATOM    818  CE3 TRP   103      37.904  45.808  13.307  1.00 20.71      A   
ATOM    819  CD1 TRP   103      36.358  45.303  16.551  1.00 18.12      A   
ATOM    820  NE1 TRP   103      35.313  45.697  15.747  1.00 19.57      A   
ATOM    821  CZ2 TRP   103      35.109  46.330  13.324  1.00 19.48      A   
ATOM    822  CZ3 TRP   103      37.230  46.218  12.154  1.00 21.03      A   
ATOM    823  CH2 TRP   103      35.845  46.473  12.175  1.00 19.07      A   
ATOM    824  C   TRP   103      40.849  43.272  16.182  1.00 17.27      A   
ATOM    825  O   TRP   103      41.421  43.940  17.044  1.00 16.09      A   
ATOM    826  N   ASP   104      41.267  42.064  15.818  1.00 15.86      A   
ATOM    827  CA  ASP   104      42.448  41.452  16.408  1.00 16.68      A   
ATOM    828  CB  ASP   104      42.113  40.857  17.782  1.00 18.04      A   
ATOM    829  CG  ASP   104      43.333  40.741  18.684  1.00 18.44      A   
ATOM    830  OD1 ASP   104      44.403  40.322  18.199  1.00 17.66      A   
ATOM    831  OD2 ASP   104      43.222  41.065  19.886  1.00 18.29      A   
ATOM    832  C   ASP   104      42.939  40.351  15.471  1.00 16.99      A   
ATOM    833  O   ASP   104      42.138  39.693  14.804  1.00 14.26      A   
ATOM    834  N   TYR   105      44.253  40.158  15.414  1.00 16.74      A   
ATOM    835  CA  TYR   105      44.822  39.129  14.555  1.00 18.06      A   
ATOM    836  CB  TYR   105      46.091  39.649  13.862  1.00 20.59      A   
ATOM    837  CG  TYR   105      47.260  39.888  14.791  1.00 24.76      A   
ATOM    838  CD1 TYR   105      48.128  38.852  15.141  1.00 26.74      A   
ATOM    839  CE1 TYR   105      49.191  39.067  16.019  1.00 28.87      A   
ATOM    840  CD2 TYR   105      47.486  41.147  15.340  1.00 26.78      A   
ATOM    841  CE2 TYR   105      48.541  41.372  16.218  1.00 28.26      A   
ATOM    842  CZ  TYR   105      49.388  40.330  16.553  1.00 28.29      A   
ATOM    843  OH  TYR   105      50.421  40.557  17.430  1.00 30.51      A   
ATOM    844  C   TYR   105      45.145  37.890  15.381  1.00 16.71      A   
ATOM    845  O   TYR   105      45.704  36.926  14.868  1.00 15.51      A   
ATOM    846  N   ARG   106      44.772  37.913  16.657  1.00 16.30      A   
ATOM    847  CA  ARG   106      45.043  36.795  17.550  1.00 16.93      A   
ATOM    848  CB  ARG   106      45.799  37.283  18.788  1.00 19.06      A   
ATOM    849  CG  ARG   106      47.080  38.048  18.502  1.00 19.69      A   
ATOM    850  CD  ARG   106      47.530  38.798  19.744  1.00 20.92      A   
ATOM    851  NE  ARG   106      46.502  39.734  20.202  1.00 23.02      A   
ATOM    852  CZ  ARG   106      46.516  40.349  21.382  1.00 23.54      A   
ATOM    853  NH1 ARG   106      47.506  40.132  22.237  1.00 21.04      A   
ATOM    854  NH2 ARG   106      45.538  41.181  21.709  1.00 23.89      A   
ATOM    855  C   ARG   106      43.794  36.067  18.030  1.00 17.22      A   
ATOM    856  O   ARG   106      42.729  36.666  18.190  1.00 17.53      A   
ATOM    857  N   ILE   107      43.935  34.766  18.256  1.00 17.45      A   
ATOM    858  CA  ILE   107      42.843  33.968  18.789  1.00 18.01      A   
ATOM    859  CB  ILE   107      42.689  32.622  18.057  1.00 17.03      A   
ATOM    860  CG2 ILE   107      41.698  31.731  18.804  1.00 16.49      A   
ATOM    861  CG1 ILE   107      42.214  32.871  16.626  1.00 16.71      A   
ATOM    862  CD1 ILE   107      42.130  31.623  15.781  1.00 16.54      A   
ATOM    863  C   ILE   107      43.280  33.722  20.224  1.00 18.12      A   
ATOM    864  O   ILE   107      44.339  33.144  20.466  1.00 19.35      A   
ATOM    865  N   PHE   108      42.476  34.193  21.171  1.00 17.78      A   
ATOM    866  CA  PHE   108      42.780  34.044  22.588  1.00 16.57      A   
ATOM    867  CB  PHE   108      41.877  34.962  23.426  1.00 16.24      A   
ATOM    868  CG  PHE   108      42.247  36.421  23.366  1.00 13.78      A   
ATOM    869  CD1 PHE   108      42.525  37.038  22.150  1.00 12.64      A   
ATOM    870  CD2 PHE   108      42.276  37.189  24.530  1.00 14.76      A   
ATOM    871  CE1 PHE   108      42.827  38.398  22.091  1.00 15.50      A   
ATOM    872  CE2 PHE   108      42.576  38.552  24.484  1.00 13.89      A   
ATOM    873  CZ  PHE   108      42.851  39.159  23.260  1.00 13.55      A   
ATOM    874  C   PHE   108      42.615  32.612  23.083  1.00 16.90      A   
ATOM    875  O   PHE   108      41.599  31.963  22.827  1.00 16.29      A   
ATOM    876  N   ILE   109      43.626  32.124  23.793  1.00 15.16      A   
ATOM    877  CA  ILE   109      43.585  30.788  24.366  1.00 14.09      A   
ATOM    878  CB  ILE   109      44.923  30.047  24.209  1.00 14.25      A   
ATOM    879  CG2 ILE   109      44.792  28.634  24.767  1.00 14.37      A   
ATOM    880  CG1 ILE   109      45.339  30.013  22.739  1.00 14.17      A   
ATOM    881  CD1 ILE   109      46.714  29.423  22.521  1.00 16.44      A   
ATOM    882  C   ILE   109      43.342  30.998  25.852  1.00 14.99      A   
ATOM    883  O   ILE   109      43.986  31.845  26.474  1.00 14.59      A   
ATOM    884  N   ILE   110      42.420  30.234  26.423  1.00 14.72      A   
ATOM    885  CA  ILE   110      42.112  30.376  27.837  1.00 17.73      A   
ATOM    886  CB  ILE   110      40.749  31.076  28.047  1.00 17.26      A   
ATOM    887  CG2 ILE   110      40.767  32.452  27.404  1.00 16.81      A   
ATOM    888  CG1 ILE   110      39.628  30.212  27.458  1.00 18.32      A   
ATOM    889  CD1 ILE   110      38.229  30.719  27.754  1.00 20.89      A   
ATOM    890  C   ILE   110      42.054  29.046  28.580  1.00 17.20      A   
ATOM    891  O   ILE   110      42.099  27.973  27.979  1.00 17.94      A   
ATOM    892  N   ASN   111      41.964  29.142  29.901  1.00 18.67      A   
ATOM    893  CA  ASN   111      41.847  27.980  30.765  1.00 18.24      A   
ATOM    894  CB  ASN   111      42.998  27.923  31.773  1.00 19.53      A   
ATOM    895  CG  ASN   111      42.896  26.725  32.696  1.00 18.91      A   
ATOM    896  OD1 ASN   111      41.798  26.323  33.083  1.00 21.00      A   
ATOM    897  ND2 ASN   111      44.039  26.152  33.062  1.00 21.03      A   
ATOM    898  C   ASN   111      40.528  28.184  31.508  1.00 19.39      A   
ATOM    899  O   ASN   111      40.467  28.908  32.504  1.00 20.66      A   
ATOM    900  N   PRO   112      39.451  27.555  31.020  1.00 19.69      A   
ATOM    901  CD  PRO   112      39.417  26.722  29.806  1.00 19.53      A   
ATOM    902  CA  PRO   112      38.118  27.658  31.618  1.00 19.57      A   
ATOM    903  CB  PRO   112      37.306  26.648  30.816  1.00 20.33      A   
ATOM    904  CG  PRO   112      37.941  26.716  29.465  1.00 20.62      A   
ATOM    905  C   PRO   112      38.055  27.375  33.114  1.00 20.59      A   
ATOM    906  O   PRO   112      37.247  27.967  33.831  1.00 19.25      A   
ATOM    907  N   LYS   113      38.903  26.469  33.585  1.00 21.35      A   
ATOM    908  CA  LYS   113      38.897  26.106  34.994  1.00 23.78      A   
ATOM    909  CB  LYS   113      39.656  24.793  35.195  1.00 26.18      A   
ATOM    910  CG  LYS   113      39.306  24.085  36.496  1.00 30.37      A   
ATOM    911  CD  LYS   113      39.381  22.569  36.344  1.00 33.44      A   
ATOM    912  CE  LYS   113      40.779  22.106  35.972  1.00 34.20      A   
ATOM    913  NZ  LYS   113      40.817  20.638  35.726  1.00 36.41      A   
ATOM    914  C   LYS   113      39.455  27.193  35.907  1.00 24.05      A   
ATOM    915  O   LYS   113      38.988  27.357  37.033  1.00 24.71      A   
ATOM    916  N   THR   114      40.436  27.944  35.414  1.00 23.42      A   
ATOM    917  CA  THR   114      41.046  29.017  36.193  1.00 23.88      A   
ATOM    918  CB  THR   114      42.574  29.042  36.014  1.00 24.88      A   
ATOM    919  OG1 THR   114      42.888  29.217  34.628  1.00 26.65      A   
ATOM    920  CG2 THR   114      43.189  27.739  36.507  1.00 27.14      A   
ATOM    921  C   THR   114      40.503  30.389  35.806  1.00 22.40      A   
ATOM    922  O   THR   114      40.848  31.396  36.425  1.00 20.46      A   
ATOM    923  N   TYR   115      39.660  30.420  34.777  1.00 21.24      A   
ATOM    924  CA  TYR   115      39.059  31.658  34.296  1.00 20.79      A   
ATOM    925  CB  TYR   115      38.094  32.212  35.352  1.00 21.05      A   
ATOM    926  CG  TYR   115      36.896  31.324  35.609  1.00 22.24      A   
ATOM    927  CD1 TYR   115      35.870  31.214  34.669  1.00 21.77      A   
ATOM    928  CE1 TYR   115      34.776  30.378  34.889  1.00 20.59      A   
ATOM    929  CD2 TYR   115      36.797  30.573  36.780  1.00 20.97      A   
ATOM    930  CE2 TYR   115      35.707  29.734  37.008  1.00 18.53      A   
ATOM    931  CZ  TYR   115      34.703  29.641  36.062  1.00 21.19      A   
ATOM    932  OH  TYR   115      33.625  28.816  36.278  1.00 20.75      A   
ATOM    933  C   TYR   115      40.091  32.725  33.924  1.00 21.88      A   
ATOM    934  O   TYR   115      39.992  33.872  34.357  1.00 23.29      A   
ATOM    935  N   GLU   116      41.083  32.347  33.123  1.00 21.57      A   
ATOM    936  CA  GLU   116      42.106  33.294  32.697  1.00 22.96      A   
ATOM    937  CB  GLU   116      43.274  33.294  33.689  1.00 27.20      A   
ATOM    938  CG  GLU   116      43.954  31.948  33.863  1.00 32.70      A   
ATOM    939  CD  GLU   116      45.209  32.038  34.722  1.00 36.32      A   
ATOM    940  OE1 GLU   116      45.096  32.371  35.923  1.00 38.23      A   
ATOM    941  OE2 GLU   116      46.312  31.782  34.189  1.00 37.40      A   
ATOM    942  C   GLU   116      42.629  33.015  31.286  1.00 21.61      A   
ATOM    943  O   GLU   116      42.507  31.905  30.765  1.00 19.14      A   
ATOM    944  N   ILE   117      43.203  34.044  30.671  1.00 19.94      A   
ATOM    945  CA  ILE   117      43.766  33.929  29.333  1.00 19.93      A   
ATOM    946  CB  ILE   117      43.835  35.307  28.656  1.00 19.06      A   
ATOM    947  CG2 ILE   117      44.442  35.181  27.265  1.00 19.47      A   
ATOM    948  CG1 ILE   117      42.428  35.912  28.602  1.00 18.82      A   
ATOM    949  CD1 ILE   117      42.367  37.304  28.017  1.00 20.66      A   
ATOM    950  C   ILE   117      45.174  33.368  29.507  1.00 21.32      A   
ATOM    951  O   ILE   117      45.965  33.906  30.281  1.00 21.91      A   
ATOM    952  N   THR   118      45.484  32.287  28.798  1.00 20.57      A   
ATOM    953  CA  THR   118      46.794  31.656  28.919  1.00 21.03      A   
ATOM    954  CB  THR   118      46.656  30.137  29.098  1.00 20.70      A   
ATOM    955  OG1 THR   118      45.982  29.584  27.961  1.00 20.76      A   
ATOM    956  CG2 THR   118      45.870  29.821  30.357  1.00 20.93      A   
ATOM    957  C   THR   118      47.734  31.891  27.746  1.00 20.13      A   
ATOM    958  O   THR   118      48.941  31.697  27.867  1.00 21.88      A   
ATOM    959  N   GLY   119      47.195  32.303  26.609  1.00 20.35      A   
ATOM    960  CA  GLY   119      48.053  32.523  25.465  1.00 18.47      A   
ATOM    961  C   GLY   119      47.327  33.078  24.261  1.00 19.08      A   
ATOM    962  O   GLY   119      46.156  33.458  24.330  1.00 18.37      A   
ATOM    963  N   TYR   120      48.032  33.115  23.140  1.00 17.98      A   
ATOM    964  CA  TYR   120      47.469  33.649  21.914  1.00 19.44      A   
ATOM    965  CB  TYR   120      47.923  35.102  21.735  1.00 20.88      A   
ATOM    966  CG  TYR   120      47.542  36.008  22.885  1.00 23.33      A   
ATOM    967  CD1 TYR   120      46.226  36.434  23.052  1.00 22.92      A   
ATOM    968  CE1 TYR   120      45.859  37.244  24.126  1.00 25.46      A   
ATOM    969  CD2 TYR   120      48.491  36.416  23.825  1.00 24.21      A   
ATOM    970  CE2 TYR   120      48.133  37.226  24.906  1.00 25.18      A   
ATOM    971  CZ  TYR   120      46.816  37.634  25.048  1.00 25.42      A   
ATOM    972  OH  TYR   120      46.448  38.425  26.113  1.00 27.85      A   
ATOM    973  C   TYR   120      47.910  32.840  20.709  1.00 19.28      A   
ATOM    974  O   TYR   120      48.977  32.226  20.711  1.00 17.92      A   
ATOM    975  N   ILE   121      47.068  32.834  19.685  1.00 19.56      A   
ATOM    976  CA  ILE   121      47.380  32.150  18.442  1.00 19.13      A   
ATOM    977  CB  ILE   121      46.296  31.132  18.053  1.00 19.42      A   
ATOM    978  CG2 ILE   121      46.604  30.553  16.676  1.00 18.94      A   
ATOM    979  CG1 ILE   121      46.219  30.030  19.109  1.00 19.41      A   
ATOM    980  CD1 ILE   121      45.182  28.971  18.815  1.00 18.59      A   
ATOM    981  C   ILE   121      47.404  33.262  17.413  1.00 19.27      A   
ATOM    982  O   ILE   121      46.366  33.843  17.102  1.00 18.60      A   
ATOM    983  N   GLU   122      48.589  33.579  16.905  1.00 19.85      A   
ATOM    984  CA  GLU   122      48.720  34.645  15.917  1.00 20.76      A   
ATOM    985  CB  GLU   122      50.153  35.185  15.909  1.00 23.26      A   
ATOM    986  CG  GLU   122      50.591  35.818  17.226  1.00 26.45      A   
ATOM    987  CD  GLU   122      51.954  36.485  17.133  1.00 28.25      A   
ATOM    988  OE1 GLU   122      52.422  37.025  18.157  1.00 30.11      A   
ATOM    989  OE2 GLU   122      52.555  36.469  16.037  1.00 31.47      A   
ATOM    990  C   GLU   122      48.342  34.183  14.513  1.00 20.59      A   
ATOM    991  O   GLU   122      48.900  33.219  13.999  1.00 21.44      A   
ATOM    992  N   CYS   123      47.392  34.874  13.895  1.00 20.00      A   
ATOM    993  CA  CYS   123      46.967  34.522  12.548  1.00 20.23      A   
ATOM    994  CB  CYS   123      45.505  34.911  12.328  1.00 20.02      A   
ATOM    995  SG  CYS   123      44.350  34.006  13.393  1.00 20.32      A   
ATOM    996  C   CYS   123      47.853  35.232  11.536  1.00 20.61      A   
ATOM    997  O   CYS   123      48.119  36.426  11.659  1.00 20.24      A   
ATOM    998  N   PRO   124      48.321  34.500  10.515  1.00 20.12      A   
ATOM    999  CD  PRO   124      48.084  33.067  10.253  1.00 20.91      A   
ATOM   1000  CA  PRO   124      49.185  35.087   9.489  1.00 21.28      A   
ATOM   1001  CB  PRO   124      49.726  33.862   8.760  1.00 20.35      A   
ATOM   1002  CG  PRO   124      48.565  32.912   8.823  1.00 21.96      A   
ATOM   1003  C   PRO   124      48.469  36.049   8.550  1.00 21.02      A   
ATOM   1004  O   PRO   124      47.276  35.906   8.275  1.00 22.49      A   
ATOM   1005  N   ASP   125      49.207  37.042   8.073  1.00 21.01      A   
ATOM   1006  CA  ASP   125      48.668  38.017   7.138  1.00 21.68      A   
ATOM   1007  CB  ASP   125      48.380  37.328   5.799  1.00 22.63      A   
ATOM   1008  CG  ASP   125      49.636  36.805   5.129  1.00 26.25      A   
ATOM   1009  OD1 ASP   125      49.515  36.027   4.157  1.00 29.56      A   
ATOM   1010  OD2 ASP   125      50.745  37.175   5.567  1.00 27.95      A   
ATOM   1011  C   ASP   125      47.422  38.787   7.590  1.00 21.79      A   
ATOM   1012  O   ASP   125      46.492  38.970   6.809  1.00 22.37      A   
ATOM   1013  N   MET   126      47.382  39.213   8.846  1.00 22.46      A   
ATOM   1014  CA  MET   126      46.265  40.020   9.318  1.00 23.00      A   
ATOM   1015  CB  MET   126      45.018  39.166   9.630  1.00 24.16      A   
ATOM   1016  CG  MET   126      44.936  38.518  11.001  1.00 24.76      A   
ATOM   1017  SD  MET   126      43.105  37.840  11.413  1.00 25.33      A   
ATOM   1018  CE  MET   126      42.976  36.438  10.067  1.00 22.01      A   
ATOM   1019  C   MET   126      46.716  40.828  10.528  1.00 23.48      A   
ATOM   1020  O   MET   126      47.639  40.433  11.246  1.00 23.36      A   
ATOM   1021  N   ASP   127      46.094  41.984  10.724  1.00 24.50      A   
ATOM   1022  CA  ASP   127      46.451  42.855  11.835  1.00 24.86      A   
ATOM   1023  CB  ASP   127      47.018  44.172  11.307  1.00 26.39      A   
ATOM   1024  CG  ASP   127      46.128  44.807  10.263  1.00 26.90      A   
ATOM   1025  OD1 ASP   127      44.892  44.791  10.443  1.00 28.09      A   
ATOM   1026  OD2 ASP   127      46.665  45.327   9.263  1.00 30.06      A   
ATOM   1027  C   ASP   127      45.267  43.144  12.741  1.00 24.74      A   
ATOM   1028  O   ASP   127      44.215  42.521  12.623  1.00 24.01      A   
ATOM   1029  N   MET   128      45.450  44.103  13.642  1.00 24.09      A   
ATOM   1030  CA  MET   128      44.410  44.488  14.589  1.00 25.15      A   
ATOM   1031  CB  MET   128      45.014  45.292  15.743  1.00 25.37      A   
ATOM   1032  CG  MET   128      46.176  44.633  16.468  1.00 28.14      A   
ATOM   1033  SD  MET   128      45.686  43.139  17.596  1.00 33.56      A   
ATOM   1034  CE  MET   128      44.689  44.095  18.959  1.00 29.55      A   
ATOM   1035  C   MET   128      43.349  45.348  13.919  1.00 24.79      A   
ATOM   1036  O   MET   128      42.158  45.240  14.217  1.00 25.07      A   
ATOM   1037  N   GLU   129      43.799  46.211  13.016  1.00 24.16      A   
ATOM   1038  CA  GLU   129      42.922  47.131  12.310  1.00 24.25      A   
ATOM   1039  CB  GLU   129      43.758  47.991  11.354  1.00 27.71      A   
ATOM   1040  CG  GLU   129      44.710  48.957  12.076  1.00 31.44      A   
ATOM   1041  CD  GLU   129      45.850  48.261  12.824  1.00 33.60      A   
ATOM   1042  OE1 GLU   129      46.390  48.864  13.780  1.00 35.14      A   
ATOM   1043  OE2 GLU   129      46.223  47.125  12.456  1.00 32.74      A   
ATOM   1044  C   GLU   129      41.758  46.475  11.568  1.00 23.30      A   
ATOM   1045  O   GLU   129      40.638  46.991  11.587  1.00 23.17      A   
ATOM   1046  N   SER   130      42.006  45.340  10.924  1.00 21.49      A   
ATOM   1047  CA  SER   130      40.941  44.655  10.192  1.00 19.98      A   
ATOM   1048  CB  SER   130      41.070  44.929   8.692  1.00 20.23      A   
ATOM   1049  OG  SER   130      42.270  44.378   8.176  1.00 21.75      A   
ATOM   1050  C   SER   130      40.933  43.150  10.437  1.00 18.31      A   
ATOM   1051  O   SER   130      40.345  42.389   9.664  1.00 17.04      A   
ATOM   1052  N   GLY   131      41.581  42.722  11.516  1.00 16.81      A   
ATOM   1053  CA  GLY   131      41.630  41.304  11.826  1.00 18.41      A   
ATOM   1054  C   GLY   131      40.258  40.740  12.137  1.00 17.04      A   
ATOM   1055  O   GLY   131      39.358  41.469  12.560  1.00 14.66      A   
ATOM   1056  N   SER   132      40.094  39.438  11.926  1.00 15.85      A   
ATOM   1057  CA  SER   132      38.817  38.789  12.195  1.00 14.61      A   
ATOM   1058  CB  SER   132      37.739  39.305  11.241  1.00 15.55      A   
ATOM   1059  OG  SER   132      36.554  38.528  11.369  1.00 13.55      A   
ATOM   1060  C   SER   132      38.826  37.273  12.100  1.00 14.99      A   
ATOM   1061  O   SER   132      39.172  36.706  11.063  1.00 13.75      A   
ATOM   1062  N   THR   133      38.453  36.628  13.201  1.00 14.00      A   
ATOM   1063  CA  THR   133      38.315  35.177  13.257  1.00 12.97      A   
ATOM   1064  CB  THR   133      39.385  34.506  14.153  1.00 14.19      A   
ATOM   1065  OG1 THR   133      39.491  35.201  15.397  1.00 13.48      A   
ATOM   1066  CG2 THR   133      40.739  34.509  13.448  1.00 12.60      A   
ATOM   1067  C   THR   133      36.904  35.030  13.833  1.00 13.24      A   
ATOM   1068  O   THR   133      36.504  35.801  14.708  1.00 11.11      A   
ATOM   1069  N   GLU   134      36.143  34.063  13.334  1.00 12.41      A   
ATOM   1070  CA  GLU   134      34.754  33.899  13.758  1.00 12.41      A   
ATOM   1071  CB  GLU   134      33.849  34.265  12.563  1.00 12.32      A   
ATOM   1072  CG  GLU   134      32.370  34.499  12.869  1.00 13.35      A   
ATOM   1073  CD  GLU   134      32.092  35.850  13.518  1.00 12.44      A   
ATOM   1074  OE1 GLU   134      30.905  36.219  13.632  1.00 12.37      A   
ATOM   1075  OE2 GLU   134      33.056  36.544  13.917  1.00 14.46      A   
ATOM   1076  C   GLU   134      34.394  32.513  14.315  1.00 11.38      A   
ATOM   1077  O   GLU   134      34.731  32.193  15.456  1.00 10.82      A   
ATOM   1078  N   GLN   135      33.722  31.686  13.516  1.00  9.02      A   
ATOM   1079  CA  GLN   135      33.308  30.362  13.985  1.00  9.22      A   
ATOM   1080  CB  GLN   135      31.991  29.948  13.304  1.00  7.10      A   
ATOM   1081  CG  GLN   135      30.831  30.894  13.644  1.00  6.40      A   
ATOM   1082  CD  GLN   135      29.500  30.472  13.062  1.00  6.98      A   
ATOM   1083  OE1 GLN   135      28.513  31.194  13.175  1.00 11.14      A   
ATOM   1084  NE2 GLN   135      29.463  29.302  12.442  1.00  7.29      A   
ATOM   1085  C   GLN   135      34.365  29.280  13.809  1.00  8.81      A   
ATOM   1086  O   GLN   135      35.249  29.382  12.955  1.00  8.64      A   
ATOM   1087  N   MET   136      34.265  28.238  14.625  1.00  8.68      A   
ATOM   1088  CA  MET   136      35.236  27.155  14.572  1.00 10.22      A   
ATOM   1089  CB  MET   136      36.167  27.240  15.780  1.00 11.90      A   
ATOM   1090  CG  MET   136      36.907  28.549  15.949  1.00 14.94      A   
ATOM   1091  SD  MET   136      37.812  28.632  17.674  1.00 21.19      A   
ATOM   1092  CE  MET   136      36.375  29.422  18.705  1.00 18.05      A   
ATOM   1093  C   MET   136      34.616  25.771  14.557  1.00  8.94      A   
ATOM   1094  O   MET   136      33.544  25.549  15.116  1.00  8.46      A   
ATOM   1095  N   VAL   137      35.296  24.843  13.897  1.00  8.84      A   
ATOM   1096  CA  VAL   137      34.851  23.458  13.868  1.00 10.40      A   
ATOM   1097  CB  VAL   137      34.218  23.050  12.509  1.00 10.93      A   
ATOM   1098  CG1 VAL   137      32.914  23.806  12.302  1.00  8.92      A   
ATOM   1099  CG2 VAL   137      35.183  23.315  11.367  1.00 11.88      A   
ATOM   1100  C   VAL   137      36.098  22.630  14.126  1.00 11.69      A   
ATOM   1101  O   VAL   137      37.192  23.008  13.711  1.00  9.42      A   
ATOM   1102  N   GLN   138      35.953  21.520  14.837  1.00 12.13      A   
ATOM   1103  CA  GLN   138      37.117  20.688  15.109  1.00 13.68      A   
ATOM   1104  CB  GLN   138      37.140  20.246  16.578  1.00 16.57      A   
ATOM   1105  CG  GLN   138      38.330  19.352  16.928  1.00 17.94      A   
ATOM   1106  CD  GLN   138      38.672  19.354  18.411  1.00 20.81      A   
ATOM   1107  OE1 GLN   138      37.988  19.984  19.221  1.00 20.42      A   
ATOM   1108  NE2 GLN   138      39.747  18.655  18.771  1.00 19.28      A   
ATOM   1109  C   GLN   138      37.139  19.472  14.192  1.00 13.59      A   
ATOM   1110  O   GLN   138      36.100  18.882  13.887  1.00 13.21      A   
ATOM   1111  N   TYR   139      38.337  19.115  13.745  1.00 12.43      A   
ATOM   1112  CA  TYR   139      38.539  17.968  12.869  1.00 12.32      A   
ATOM   1113  CB  TYR   139      38.760  18.447  11.432  1.00 11.78      A   
ATOM   1114  CG  TYR   139      38.983  17.336  10.435  1.00 12.58      A   
ATOM   1115  CD1 TYR   139      38.004  16.368  10.205  1.00 12.81      A   
ATOM   1116  CE1 TYR   139      38.214  15.334   9.297  1.00 14.29      A   
ATOM   1117  CD2 TYR   139      40.180  17.243   9.727  1.00 13.12      A   
ATOM   1118  CE2 TYR   139      40.400  16.213   8.817  1.00 13.80      A   
ATOM   1119  CZ  TYR   139      39.415  15.264   8.608  1.00 14.99      A   
ATOM   1120  OH  TYR   139      39.635  14.246   7.714  1.00 15.55      A   
ATOM   1121  C   TYR   139      39.765  17.218  13.382  1.00 12.62      A   
ATOM   1122  O   TYR   139      40.899  17.533  13.016  1.00 10.19      A   
ATOM   1123  N   GLY   140      39.533  16.227  14.235  1.00 14.00      A   
ATOM   1124  CA  GLY   140      40.645  15.487  14.796  1.00 14.90      A   
ATOM   1125  C   GLY   140      41.449  16.448  15.651  1.00 15.57      A   
ATOM   1126  O   GLY   140      40.883  17.156  16.489  1.00 15.54      A   
ATOM   1127  N   LYS   141      42.760  16.502  15.433  1.00 14.14      A   
ATOM   1128  CA  LYS   141      43.616  17.395  16.209  1.00 15.01      A   
ATOM   1129  CB  LYS   141      45.056  16.878  16.235  1.00 13.21      A   
ATOM   1130  CG  LYS   141      45.769  16.952  14.896  1.00 15.72      A   
ATOM   1131  CD  LYS   141      47.190  16.415  15.003  1.00 16.78      A   
ATOM   1132  CE  LYS   141      47.925  16.542  13.682  1.00 18.01      A   
ATOM   1133  NZ  LYS   141      49.320  16.036  13.767  1.00 20.09      A   
ATOM   1134  C   LYS   141      43.610  18.805  15.640  1.00 14.80      A   
ATOM   1135  O   LYS   141      44.256  19.704  16.176  1.00 14.68      A   
ATOM   1136  N   TYR   142      42.875  19.002  14.554  1.00 13.01      A   
ATOM   1137  CA  TYR   142      42.824  20.312  13.928  1.00 13.56      A   
ATOM   1138  CB  TYR   142      42.926  20.172  12.403  1.00 13.39      A   
ATOM   1139  CG  TYR   142      44.211  19.545  11.907  1.00 14.47      A   
ATOM   1140  CD1 TYR   142      45.419  20.246  11.969  1.00 14.38      A   
ATOM   1141  CE1 TYR   142      46.608  19.687  11.499  1.00 13.27      A   
ATOM   1142  CD2 TYR   142      44.221  18.256  11.362  1.00 13.17      A   
ATOM   1143  CE2 TYR   142      45.409  17.684  10.886  1.00 14.56      A   
ATOM   1144  CZ  TYR   142      46.598  18.412  10.960  1.00 14.89      A   
ATOM   1145  OH  TYR   142      47.775  17.876  10.486  1.00 14.90      A   
ATOM   1146  C   TYR   142      41.553  21.079  14.250  1.00 13.65      A   
ATOM   1147  O   TYR   142      40.531  20.502  14.618  1.00 13.69      A   
ATOM   1148  N   VAL   143      41.638  22.395  14.130  1.00 13.42      A   
ATOM   1149  CA  VAL   143      40.480  23.248  14.318  1.00 12.63      A   
ATOM   1150  CB  VAL   143      40.536  24.066  15.634  1.00 14.25      A   
ATOM   1151  CG1 VAL   143      39.541  25.217  15.560  1.00 14.16      A   
ATOM   1152  CG2 VAL   143      40.167  23.174  16.827  1.00 11.88      A   
ATOM   1153  C   VAL   143      40.491  24.189  13.126  1.00 12.17      A   
ATOM   1154  O   VAL   143      41.513  24.806  12.816  1.00 10.79      A   
ATOM   1155  N   TYR   144      39.362  24.264  12.432  1.00 11.10      A   
ATOM   1156  CA  TYR   144      39.234  25.158  11.285  1.00 10.64      A   
ATOM   1157  CB  TYR   144      38.503  24.461  10.138  1.00 10.51      A   
ATOM   1158  CG  TYR   144      39.363  23.508   9.339  1.00 11.89      A   
ATOM   1159  CD1 TYR   144      40.281  23.987   8.404  1.00  9.72      A   
ATOM   1160  CE1 TYR   144      41.038  23.114   7.631  1.00 11.03      A   
ATOM   1161  CD2 TYR   144      39.233  22.123   9.485  1.00 11.18      A   
ATOM   1162  CE2 TYR   144      39.990  21.241   8.711  1.00 11.20      A   
ATOM   1163  CZ  TYR   144      40.885  21.746   7.788  1.00 10.41      A   
ATOM   1164  OH  TYR   144      41.623  20.895   6.997  1.00 13.08      A   
ATOM   1165  C   TYR   144      38.434  26.366  11.741  1.00 10.61      A   
ATOM   1166  O   TYR   144      37.496  26.234  12.524  1.00  9.33      A   
ATOM   1167  N   VAL   145      38.795  27.541  11.243  1.00  9.80      A   
ATOM   1168  CA  VAL   145      38.105  28.761  11.633  1.00 10.83      A   
ATOM   1169  CB  VAL   145      38.895  29.472  12.764  1.00 12.37      A   
ATOM   1170  CG1 VAL   145      40.373  29.566  12.380  1.00 11.47      A   
ATOM   1171  CG2 VAL   145      38.327  30.856  13.028  1.00 10.33      A   
ATOM   1172  C   VAL   145      37.919  29.713  10.452  1.00 12.30      A   
ATOM   1173  O   VAL   145      38.831  29.887   9.640  1.00 12.24      A   
ATOM   1174  N   ASN   146      36.737  30.315  10.335  1.00 12.05      A   
ATOM   1175  CA  ASN   146      36.511  31.248   9.241  1.00 11.75      A   
ATOM   1176  CB  ASN   146      35.058  31.175   8.715  1.00 11.78      A   
ATOM   1177  CG  ASN   146      34.026  31.704   9.703  1.00 12.79      A   
ATOM   1178  OD1 ASN   146      33.714  31.062  10.699  1.00 10.61      A   
ATOM   1179  ND2 ASN   146      33.488  32.891   9.419  1.00  7.74      A   
ATOM   1180  C   ASN   146      36.863  32.668   9.675  1.00 12.32      A   
ATOM   1181  O   ASN   146      36.660  33.056  10.829  1.00 12.23      A   
ATOM   1182  N   CYS   147      37.437  33.421   8.745  1.00 12.76      A   
ATOM   1183  CA  CYS   147      37.830  34.804   8.980  1.00 12.45      A   
ATOM   1184  CB  CYS   147      39.256  35.024   8.461  1.00 12.36      A   
ATOM   1185  SG  CYS   147      40.490  33.916   9.234  1.00 14.00      A   
ATOM   1186  C   CYS   147      36.814  35.646   8.216  1.00 12.48      A   
ATOM   1187  O   CYS   147      36.829  35.688   6.986  1.00 11.00      A   
ATOM   1188  N   TRP   148      35.943  36.321   8.961  1.00 12.36      A   
ATOM   1189  CA  TRP   148      34.860  37.111   8.382  1.00 12.30      A   
ATOM   1190  CB  TRP   148      33.639  37.038   9.320  1.00 11.73      A   
ATOM   1191  CG  TRP   148      32.500  37.945   8.926  1.00 12.44      A   
ATOM   1192  CD2 TRP   148      31.918  38.987   9.723  1.00 11.34      A   
ATOM   1193  CE2 TRP   148      30.933  39.618   8.931  1.00 13.48      A   
ATOM   1194  CE3 TRP   148      32.137  39.453  11.029  1.00 12.98      A   
ATOM   1195  CD1 TRP   148      31.856  37.979   7.721  1.00 12.23      A   
ATOM   1196  NE1 TRP   148      30.916  38.983   7.716  1.00 13.53      A   
ATOM   1197  CZ2 TRP   148      30.165  40.694   9.400  1.00 13.70      A   
ATOM   1198  CZ3 TRP   148      31.370  40.525  11.496  1.00 12.09      A   
ATOM   1199  CH2 TRP   148      30.399  41.130  10.680  1.00 13.73      A   
ATOM   1200  C   TRP   148      35.105  38.564   7.984  1.00 12.61      A   
ATOM   1201  O   TRP   148      35.229  38.876   6.803  1.00 10.80      A   
ATOM   1202  N   SER   149      35.151  39.445   8.976  1.00 12.90      A   
ATOM   1203  CA  SER   149      35.320  40.874   8.743  1.00 15.16      A   
ATOM   1204  CB  SER   149      35.239  41.610  10.079  1.00 13.86      A   
ATOM   1205  OG  SER   149      35.143  43.006   9.885  1.00 18.12      A   
ATOM   1206  C   SER   149      36.580  41.304   7.995  1.00 14.71      A   
ATOM   1207  O   SER   149      37.686  41.232   8.531  1.00 14.78      A   
ATOM   1208  N   TYR   150      36.403  41.771   6.761  1.00 14.85      A   
ATOM   1209  CA  TYR   150      37.525  42.227   5.944  1.00 16.25      A   
ATOM   1210  CB  TYR   150      38.185  43.444   6.599  1.00 18.43      A   
ATOM   1211  CG  TYR   150      37.259  44.625   6.728  1.00 19.63      A   
ATOM   1212  CD1 TYR   150      37.291  45.441   7.854  1.00 20.53      A   
ATOM   1213  CE1 TYR   150      36.428  46.523   7.981  1.00 21.84      A   
ATOM   1214  CD2 TYR   150      36.339  44.921   5.724  1.00 21.47      A   
ATOM   1215  CE2 TYR   150      35.472  46.001   5.838  1.00 23.68      A   
ATOM   1216  CZ  TYR   150      35.524  46.797   6.973  1.00 24.30      A   
ATOM   1217  OH  TYR   150      34.665  47.867   7.095  1.00 25.65      A   
ATOM   1218  C   TYR   150      38.555  41.130   5.739  1.00 17.41      A   
ATOM   1219  O   TYR   150      39.759  41.389   5.706  1.00 14.97      A   
ATOM   1220  N   GLN   151      38.072  39.899   5.612  1.00 16.21      A   
ATOM   1221  CA  GLN   151      38.946  38.751   5.379  1.00 15.87      A   
ATOM   1222  CB  GLN   151      39.140  37.942   6.667  1.00 16.14      A   
ATOM   1223  CG  GLN   151      39.792  38.699   7.829  1.00 16.56      A   
ATOM   1224  CD  GLN   151      41.184  39.228   7.506  1.00 17.26      A   
ATOM   1225  OE1 GLN   151      41.953  38.596   6.783  1.00 17.68      A   
ATOM   1226  NE2 GLN   151      41.518  40.386   8.065  1.00 20.03      A   
ATOM   1227  C   GLN   151      38.283  37.882   4.312  1.00 15.14      A   
ATOM   1228  O   GLN   151      37.129  38.113   3.949  1.00 15.49      A   
ATOM   1229  N   ASN   152      39.012  36.890   3.812  1.00 14.65      A   
ATOM   1230  CA  ASN   152      38.486  35.998   2.783  1.00 15.31      A   
ATOM   1231  CB  ASN   152      38.714  36.597   1.383  1.00 14.53      A   
ATOM   1232  CG  ASN   152      40.193  36.732   1.017  1.00 14.83      A   
ATOM   1233  OD1 ASN   152      40.529  37.088  -0.114  1.00 17.35      A   
ATOM   1234  ND2 ASN   152      41.077  36.452   1.968  1.00 10.97      A   
ATOM   1235  C   ASN   152      39.091  34.598   2.839  1.00 16.20      A   
ATOM   1236  O   ASN   152      39.362  33.986   1.806  1.00 18.26      A   
ATOM   1237  N   ARG   153      39.301  34.075   4.039  1.00 15.39      A   
ATOM   1238  CA  ARG   153      39.874  32.740   4.133  1.00 16.06      A   
ATOM   1239  CB  ARG   153      41.404  32.826   4.050  1.00 19.96      A   
ATOM   1240  CG  ARG   153      41.957  34.028   4.746  1.00 21.43      A   
ATOM   1241  CD  ARG   153      43.467  34.164   4.661  1.00 19.00      A   
ATOM   1242  NE  ARG   153      43.812  35.381   5.380  1.00 19.95      A   
ATOM   1243  CZ  ARG   153      44.909  35.563   6.102  1.00 19.36      A   
ATOM   1244  NH1 ARG   153      45.088  36.724   6.714  1.00 20.96      A   
ATOM   1245  NH2 ARG   153      45.818  34.604   6.208  1.00 15.81      A   
ATOM   1246  C   ARG   153      39.470  31.936   5.355  1.00 15.11      A   
ATOM   1247  O   ARG   153      38.865  32.448   6.299  1.00 13.52      A   
ATOM   1248  N   ILE   154      39.789  30.650   5.294  1.00 12.40      A   
ATOM   1249  CA  ILE   154      39.532  29.715   6.373  1.00 11.82      A   
ATOM   1250  CB  ILE   154      38.864  28.410   5.863  1.00  9.68      A   
ATOM   1251  CG2 ILE   154      38.695  27.430   7.021  1.00  8.35      A   
ATOM   1252  CG1 ILE   154      37.527  28.720   5.167  1.00  8.57      A   
ATOM   1253  CD1 ILE   154      36.524  29.492   6.012  1.00 10.03      A   
ATOM   1254  C   ILE   154      40.937  29.359   6.848  1.00 12.40      A   
ATOM   1255  O   ILE   154      41.833  29.154   6.026  1.00 13.56      A   
ATOM   1256  N   LEU   155      41.145  29.314   8.158  1.00 12.19      A   
ATOM   1257  CA  LEU   155      42.453  28.950   8.691  1.00 11.38      A   
ATOM   1258  CB  LEU   155      42.891  29.939   9.776  1.00 10.65      A   
ATOM   1259  CG  LEU   155      43.002  31.395   9.327  1.00  9.32      A   
ATOM   1260  CD1 LEU   155      43.441  32.269  10.494  1.00 12.24      A   
ATOM   1261  CD2 LEU   155      43.976  31.501   8.165  1.00 10.65      A   
ATOM   1262  C   LEU   155      42.386  27.546   9.283  1.00 11.12      A   
ATOM   1263  O   LEU   155      41.328  27.107   9.743  1.00 10.53      A   
ATOM   1264  N   LYS   156      43.522  26.853   9.256  1.00 10.17      A   
ATOM   1265  CA  LYS   156      43.652  25.502   9.796  1.00 11.29      A   
ATOM   1266  CB  LYS   156      44.219  24.551   8.730  1.00 11.20      A   
ATOM   1267  CG  LYS   156      44.255  23.087   9.157  1.00 11.40      A   
ATOM   1268  CD  LYS   156      44.782  22.180   8.048  1.00 14.26      A   
ATOM   1269  CE  LYS   156      44.696  20.713   8.451  1.00 14.48      A   
ATOM   1270  NZ  LYS   156      45.218  19.812   7.387  1.00 14.44      A   
ATOM   1271  C   LYS   156      44.616  25.580  10.980  1.00 11.74      A   
ATOM   1272  O   LYS   156      45.762  26.001  10.828  1.00 13.08      A   
ATOM   1273  N   ILE   157      44.146  25.177  12.155  1.00 12.19      A   
ATOM   1274  CA  ILE   157      44.949  25.230  13.370  1.00 14.06      A   
ATOM   1275  CB  ILE   157      44.213  26.040  14.467  1.00 14.40      A   
ATOM   1276  CG2 ILE   157      45.005  25.997  15.779  1.00 12.93      A   
ATOM   1277  CG1 ILE   157      43.984  27.477  13.986  1.00 16.14      A   
ATOM   1278  CD1 ILE   157      43.065  28.289  14.884  1.00 18.38      A   
ATOM   1279  C   ILE   157      45.282  23.857  13.953  1.00 14.52      A   
ATOM   1280  O   ILE   157      44.419  22.980  14.036  1.00 14.28      A   
ATOM   1281  N   ASP   158      46.538  23.674  14.355  1.00 14.09      A   
ATOM   1282  CA  ASP   158      46.969  22.421  14.970  1.00 14.99      A   
ATOM   1283  CB  ASP   158      48.429  22.111  14.623  1.00 16.54      A   
ATOM   1284  CG  ASP   158      48.858  20.730  15.090  1.00 16.69      A   
ATOM   1285  OD1 ASP   158      48.343  20.259  16.126  1.00 16.92      A   
ATOM   1286  OD2 ASP   158      49.720  20.110  14.428  1.00 17.36      A   
ATOM   1287  C   ASP   158      46.844  22.631  16.477  1.00 15.16      A   
ATOM   1288  O   ASP   158      47.616  23.384  17.071  1.00 14.52      A   
ATOM   1289  N   THR   159      45.879  21.958  17.094  1.00 15.28      A   
ATOM   1290  CA  THR   159      45.642  22.102  18.523  1.00 15.69      A   
ATOM   1291  CB  THR   159      44.322  21.414  18.929  1.00 15.80      A   
ATOM   1292  OG1 THR   159      44.427  20.002  18.722  1.00 15.41      A   
ATOM   1293  CG2 THR   159      43.171  21.960  18.088  1.00 16.08      A   
ATOM   1294  C   THR   159      46.784  21.561  19.372  1.00 16.78      A   
ATOM   1295  O   THR   159      46.904  21.892  20.551  1.00 16.03      A   
ATOM   1296  N   GLU   160      47.629  20.731  18.777  1.00 18.81      A   
ATOM   1297  CA  GLU   160      48.756  20.181  19.513  1.00 20.49      A   
ATOM   1298  CB  GLU   160      49.252  18.902  18.836  1.00 20.44      A   
ATOM   1299  CG  GLU   160      48.236  17.779  18.898  1.00 23.60      A   
ATOM   1300  CD  GLU   160      48.722  16.503  18.259  1.00 22.33      A   
ATOM   1301  OE1 GLU   160      47.944  15.529  18.232  1.00 26.61      A   
ATOM   1302  OE2 GLU   160      49.874  16.470  17.788  1.00 25.92      A   
ATOM   1303  C   GLU   160      49.886  21.203  19.629  1.00 20.02      A   
ATOM   1304  O   GLU   160      50.737  21.091  20.511  1.00 22.05      A   
ATOM   1305  N   THR   161      49.889  22.202  18.749  1.00 19.04      A   
ATOM   1306  CA  THR   161      50.925  23.238  18.771  1.00 18.98      A   
ATOM   1307  CB  THR   161      51.778  23.208  17.483  1.00 18.93      A   
ATOM   1308  OG1 THR   161      50.965  23.562  16.357  1.00 18.96      A   
ATOM   1309  CG2 THR   161      52.360  21.822  17.257  1.00 19.43      A   
ATOM   1310  C   THR   161      50.353  24.651  18.923  1.00 19.52      A   
ATOM   1311  O   THR   161      51.097  25.608  19.151  1.00 19.75      A   
ATOM   1312  N   ASP   162      49.031  24.765  18.805  1.00 17.38      A   
ATOM   1313  CA  ASP   162      48.320  26.040  18.902  1.00 16.79      A   
ATOM   1314  CB  ASP   162      48.467  26.667  20.295  1.00 16.96      A   
ATOM   1315  CG  ASP   162      47.808  25.840  21.383  1.00 16.57      A   
ATOM   1316  OD1 ASP   162      46.684  25.343  21.160  1.00 18.14      A   
ATOM   1317  OD2 ASP   162      48.408  25.698  22.470  1.00 14.45      A   
ATOM   1318  C   ASP   162      48.804  27.031  17.850  1.00 16.66      A   
ATOM   1319  O   ASP   162      48.934  28.228  18.118  1.00 15.54      A   
ATOM   1320  N   LYS   163      49.068  26.526  16.650  1.00 15.97      A   
ATOM   1321  CA  LYS   163      49.527  27.370  15.557  1.00 15.73      A   
ATOM   1322  CB  LYS   163      51.029  27.166  15.325  1.00 18.69      A   
ATOM   1323  CG  LYS   163      51.892  27.616  16.504  1.00 20.54      A   
ATOM   1324  CD  LYS   163      53.369  27.551  16.195  1.00 23.18      A   
ATOM   1325  CE  LYS   163      54.193  27.950  17.410  1.00 23.53      A   
ATOM   1326  NZ  LYS   163      53.861  29.329  17.874  1.00 27.93      A   
ATOM   1327  C   LYS   163      48.773  27.093  14.263  1.00 15.43      A   
ATOM   1328  O   LYS   163      48.301  25.979  14.031  1.00 12.54      A   
ATOM   1329  N   VAL   164      48.667  28.124  13.429  1.00 15.29      A   
ATOM   1330  CA  VAL   164      48.008  28.017  12.134  1.00 15.77      A   
ATOM   1331  CB  VAL   164      47.706  29.412  11.541  1.00 14.60      A   
ATOM   1332  CG1 VAL   164      47.124  29.274  10.140  1.00 14.12      A   
ATOM   1333  CG2 VAL   164      46.737  30.164  12.444  1.00 15.58      A   
ATOM   1334  C   VAL   164      49.001  27.293  11.233  1.00 17.33      A   
ATOM   1335  O   VAL   164      50.160  27.697  11.133  1.00 17.80      A   
ATOM   1336  N   VAL   165      48.551  26.218  10.592  1.00 17.16      A   
ATOM   1337  CA  VAL   165      49.415  25.432   9.717  1.00 16.08      A   
ATOM   1338  CB  VAL   165      49.468  23.959  10.179  1.00 16.46      A   
ATOM   1339  CG1 VAL   165      50.048  23.876  11.588  1.00 13.02      A   
ATOM   1340  CG2 VAL   165      48.078  23.355  10.146  1.00 13.90      A   
ATOM   1341  C   VAL   165      49.007  25.472   8.244  1.00 16.03      A   
ATOM   1342  O   VAL   165      49.744  24.995   7.379  1.00 15.75      A   
ATOM   1343  N   ASP   166      47.840  26.033   7.944  1.00 15.72      A   
ATOM   1344  CA  ASP   166      47.405  26.110   6.551  1.00 15.89      A   
ATOM   1345  CB  ASP   166      46.988  24.713   6.050  1.00 17.54      A   
ATOM   1346  CG  ASP   166      47.131  24.553   4.529  1.00 19.43      A   
ATOM   1347  OD1 ASP   166      46.902  23.430   4.025  1.00 19.53      A   
ATOM   1348  OD2 ASP   166      47.471  25.539   3.843  1.00 18.39      A   
ATOM   1349  C   ASP   166      46.246  27.087   6.419  1.00 15.90      A   
ATOM   1350  O   ASP   166      45.625  27.465   7.411  1.00 14.04      A   
ATOM   1351  N   GLU   167      45.977  27.519   5.194  1.00 15.33      A   
ATOM   1352  CA  GLU   167      44.877  28.437   4.947  1.00 15.29      A   
ATOM   1353  CB  GLU   167      45.342  29.892   5.055  1.00 16.52      A   
ATOM   1354  CG  GLU   167      46.390  30.297   4.040  1.00 18.18      A   
ATOM   1355  CD  GLU   167      46.722  31.772   4.127  1.00 19.62      A   
ATOM   1356  OE1 GLU   167      47.053  32.244   5.231  1.00 20.46      A   
ATOM   1357  OE2 GLU   167      46.654  32.459   3.088  1.00 23.68      A   
ATOM   1358  C   GLU   167      44.298  28.183   3.568  1.00 14.61      A   
ATOM   1359  O   GLU   167      44.923  27.536   2.729  1.00 11.74      A   
ATOM   1360  N   LEU   168      43.090  28.689   3.352  1.00 14.47      A   
ATOM   1361  CA  LEU   168      42.398  28.538   2.082  1.00 13.77      A   
ATOM   1362  CB  LEU   168      41.387  27.391   2.155  1.00 13.01      A   
ATOM   1363  CG  LEU   168      40.511  27.210   0.913  1.00 13.45      A   
ATOM   1364  CD1 LEU   168      41.372  26.726  -0.247  1.00 15.49      A   
ATOM   1365  CD2 LEU   168      39.397  26.220   1.201  1.00 14.73      A   
ATOM   1366  C   LEU   168      41.665  29.838   1.805  1.00 14.74      A   
ATOM   1367  O   LEU   168      40.879  30.295   2.633  1.00 13.91      A   
ATOM   1368  N   THR   169      41.941  30.438   0.651  1.00 15.16      A   
ATOM   1369  CA  THR   169      41.304  31.689   0.263  1.00 14.48      A   
ATOM   1370  CB  THR   169      42.271  32.600  -0.530  1.00 15.82      A   
ATOM   1371  OG1 THR   169      43.363  32.982   0.309  1.00 15.13      A   
ATOM   1372  CG2 THR   169      41.548  33.854  -1.010  1.00 16.47      A   
ATOM   1373  C   THR   169      40.093  31.407  -0.612  1.00 15.00      A   
ATOM   1374  O   THR   169      40.185  30.688  -1.605  1.00 14.63      A   
ATOM   1375  N   ILE   170      38.958  31.980  -0.236  1.00 13.86      A   
ATOM   1376  CA  ILE   170      37.725  31.790  -0.977  1.00 14.06      A   
ATOM   1377  CB  ILE   170      36.760  30.844  -0.211  1.00 11.83      A   
ATOM   1378  CG2 ILE   170      37.305  29.421  -0.225  1.00 10.81      A   
ATOM   1379  CG1 ILE   170      36.599  31.329   1.239  1.00 13.18      A   
ATOM   1380  CD1 ILE   170      35.546  30.575   2.043  1.00 12.21      A   
ATOM   1381  C   ILE   170      37.066  33.147  -1.173  1.00 14.89      A   
ATOM   1382  O   ILE   170      37.739  34.179  -1.170  1.00 16.55      A   
ATOM   1383  N   GLY   171      35.750  33.140  -1.345  1.00 15.35      A   
ATOM   1384  CA  GLY   171      35.027  34.384  -1.521  1.00 16.00      A   
ATOM   1385  C   GLY   171      35.255  35.305  -0.340  1.00 16.40      A   
ATOM   1386  O   GLY   171      35.694  34.877   0.728  1.00 14.89      A   
ATOM   1387  N   ILE   172      34.950  36.580  -0.531  1.00 16.37      A   
ATOM   1388  CA  ILE   172      35.145  37.544   0.526  1.00 16.46      A   
ATOM   1389  CB  ILE   172      35.059  38.996   0.009  1.00 18.65      A   
ATOM   1390  CG2 ILE   172      36.044  39.193  -1.150  1.00 19.56      A   
ATOM   1391  CG1 ILE   172      33.634  39.315  -0.438  1.00 18.97      A   
ATOM   1392  CD1 ILE   172      33.421  40.773  -0.802  1.00 20.70      A   
ATOM   1393  C   ILE   172      34.150  37.393   1.667  1.00 15.81      A   
ATOM   1394  O   ILE   172      32.952  37.182   1.464  1.00 14.16      A   
ATOM   1395  N   GLN   173      34.697  37.495   2.869  1.00 15.65      A   
ATOM   1396  CA  GLN   173      33.955  37.449   4.108  1.00 14.79      A   
ATOM   1397  CB  GLN   173      33.165  38.758   4.247  1.00 16.38      A   
ATOM   1398  CG  GLN   173      34.091  39.980   4.177  1.00 18.58      A   
ATOM   1399  CD  GLN   173      33.426  41.292   4.552  1.00 20.13      A   
ATOM   1400  OE1 GLN   173      34.097  42.317   4.691  1.00 20.08      A   
ATOM   1401  NE2 GLN   173      32.109  41.271   4.716  1.00 21.10      A   
ATOM   1402  C   GLN   173      33.070  36.246   4.440  1.00 14.21      A   
ATOM   1403  O   GLN   173      31.841  36.344   4.458  1.00 11.15      A   
ATOM   1404  N   PRO   174      33.692  35.082   4.695  1.00 13.70      A   
ATOM   1405  CD  PRO   174      35.128  34.758   4.610  1.00 14.13      A   
ATOM   1406  CA  PRO   174      32.906  33.896   5.048  1.00 13.20      A   
ATOM   1407  CB  PRO   174      33.952  32.780   5.067  1.00 13.63      A   
ATOM   1408  CG  PRO   174      35.215  33.503   5.451  1.00 14.99      A   
ATOM   1409  C   PRO   174      32.355  34.240   6.439  1.00 13.64      A   
ATOM   1410  O   PRO   174      33.088  34.747   7.288  1.00 14.36      A   
ATOM   1411  N   THR   175      31.073  33.968   6.656  1.00 12.47      A   
ATOM   1412  CA  THR   175      30.388  34.315   7.903  1.00 11.28      A   
ATOM   1413  CB  THR   175      28.935  34.727   7.623  1.00 10.50      A   
ATOM   1414  OG1 THR   175      28.210  33.589   7.133  1.00 10.51      A   
ATOM   1415  CG2 THR   175      28.879  35.834   6.580  1.00 10.00      A   
ATOM   1416  C   THR   175      30.296  33.267   9.005  1.00 13.08      A   
ATOM   1417  O   THR   175      30.263  33.607  10.190  1.00 13.79      A   
ATOM   1418  N   SER   176      30.227  32.001   8.615  1.00 11.35      A   
ATOM   1419  CA  SER   176      30.061  30.924   9.572  1.00 11.34      A   
ATOM   1420  CB  SER   176      28.565  30.720   9.823  1.00 10.60      A   
ATOM   1421  OG  SER   176      27.841  30.871   8.610  1.00 10.67      A   
ATOM   1422  C   SER   176      30.699  29.629   9.094  1.00 11.62      A   
ATOM   1423  O   SER   176      31.166  29.541   7.957  1.00 11.77      A   
ATOM   1424  N   LEU   177      30.702  28.614   9.951  1.00 10.48      A   
ATOM   1425  CA  LEU   177      31.328  27.348   9.591  1.00 10.47      A   
ATOM   1426  CB  LEU   177      32.836  27.462   9.854  1.00 11.52      A   
ATOM   1427  CG  LEU   177      33.788  26.393   9.327  1.00 10.54      A   
ATOM   1428  CD1 LEU   177      33.806  26.444   7.799  1.00  9.89      A   
ATOM   1429  CD2 LEU   177      35.187  26.641   9.878  1.00 10.53      A   
ATOM   1430  C   LEU   177      30.751  26.171  10.370  1.00 11.38      A   
ATOM   1431  O   LEU   177      30.623  26.229  11.594  1.00  8.87      A   
ATOM   1432  N   VAL   178      30.391  25.113   9.647  1.00 10.26      A   
ATOM   1433  CA  VAL   178      29.852  23.902  10.256  1.00  9.79      A   
ATOM   1434  CB  VAL   178      28.306  23.837  10.163  1.00 11.54      A   
ATOM   1435  CG1 VAL   178      27.687  24.944  11.017  1.00 10.43      A   
ATOM   1436  CG2 VAL   178      27.864  23.977   8.710  1.00  9.40      A   
ATOM   1437  C   VAL   178      30.430  22.686   9.549  1.00 11.22      A   
ATOM   1438  O   VAL   178      30.884  22.777   8.407  1.00 10.69      A   
ATOM   1439  N   MET   179      30.391  21.549  10.232  1.00  7.96      A   
ATOM   1440  CA  MET   179      30.926  20.299   9.707  1.00  9.52      A   
ATOM   1441  CB  MET   179      31.972  19.747  10.676  1.00 10.71      A   
ATOM   1442  CG  MET   179      32.673  18.502  10.180  1.00 13.35      A   
ATOM   1443  SD  MET   179      34.018  18.961   8.888  1.00 25.54      A   
ATOM   1444  CE  MET   179      35.459  19.304  10.136  1.00 15.08      A   
ATOM   1445  C   MET   179      29.834  19.245   9.538  1.00  9.65      A   
ATOM   1446  O   MET   179      29.168  18.903  10.516  1.00  7.17      A   
ATOM   1447  N   ASP   180      29.649  18.713   8.325  1.00  9.35      A   
ATOM   1448  CA  ASP   180      28.626  17.685   8.143  1.00  9.37      A   
ATOM   1449  CB  ASP   180      27.989  17.707   6.729  1.00  9.65      A   
ATOM   1450  CG  ASP   180      28.955  17.349   5.598  1.00  9.93      A   
ATOM   1451  OD1 ASP   180      29.869  16.520   5.784  1.00 10.20      A   
ATOM   1452  OD2 ASP   180      28.768  17.888   4.482  1.00 11.26      A   
ATOM   1453  C   ASP   180      29.125  16.290   8.490  1.00  8.95      A   
ATOM   1454  O   ASP   180      30.292  16.106   8.853  1.00  7.65      A   
ATOM   1455  N   LYS   181      28.234  15.308   8.385  1.00  9.75      A   
ATOM   1456  CA  LYS   181      28.570  13.932   8.738  1.00  9.11      A   
ATOM   1457  CB  LYS   181      27.286  13.092   8.864  1.00 10.67      A   
ATOM   1458  CG  LYS   181      26.549  12.814   7.563  1.00  8.89      A   
ATOM   1459  CD  LYS   181      25.322  11.948   7.820  1.00 10.96      A   
ATOM   1460  CE  LYS   181      24.694  11.469   6.527  1.00 12.02      A   
ATOM   1461  NZ  LYS   181      23.498  10.604   6.744  1.00 10.74      A   
ATOM   1462  C   LYS   181      29.573  13.246   7.809  1.00  9.39      A   
ATOM   1463  O   LYS   181      30.028  12.146   8.103  1.00  8.09      A   
ATOM   1464  N   TYR   182      29.926  13.892   6.698  1.00  9.38      A   
ATOM   1465  CA  TYR   182      30.901  13.318   5.767  1.00  8.91      A   
ATOM   1466  CB  TYR   182      30.460  13.496   4.316  1.00 10.00      A   
ATOM   1467  CG  TYR   182      29.133  12.868   3.978  1.00 10.05      A   
ATOM   1468  CD1 TYR   182      27.943  13.579   4.132  1.00  8.67      A   
ATOM   1469  CE1 TYR   182      26.719  13.002   3.807  1.00  8.98      A   
ATOM   1470  CD2 TYR   182      29.066  11.561   3.494  1.00 11.06      A   
ATOM   1471  CE2 TYR   182      27.852  10.975   3.170  1.00 12.04      A   
ATOM   1472  CZ  TYR   182      26.680  11.701   3.327  1.00 10.88      A   
ATOM   1473  OH  TYR   182      25.476  11.120   2.999  1.00 10.61      A   
ATOM   1474  C   TYR   182      32.252  13.999   5.938  1.00 10.06      A   
ATOM   1475  O   TYR   182      33.143  13.849   5.102  1.00  7.71      A   
ATOM   1476  N   ASN   183      32.397  14.752   7.022  1.00  9.91      A   
ATOM   1477  CA  ASN   183      33.631  15.486   7.292  1.00 11.59      A   
ATOM   1478  CB  ASN   183      34.805  14.514   7.468  1.00 12.54      A   
ATOM   1479  CG  ASN   183      34.885  13.964   8.883  1.00 15.12      A   
ATOM   1480  OD1 ASN   183      35.483  12.921   9.139  1.00 19.88      A   
ATOM   1481  ND2 ASN   183      34.285  14.684   9.815  1.00 14.76      A   
ATOM   1482  C   ASN   183      33.912  16.526   6.204  1.00 12.46      A   
ATOM   1483  O   ASN   183      35.052  16.730   5.769  1.00 10.47      A   
ATOM   1484  N   LYS   184      32.832  17.170   5.769  1.00 11.88      A   
ATOM   1485  CA  LYS   184      32.871  18.244   4.779  1.00 12.97      A   
ATOM   1486  CB  LYS   184      31.883  17.960   3.639  1.00 14.81      A   
ATOM   1487  CG  LYS   184      32.486  17.432   2.350  1.00 17.36      A   
ATOM   1488  CD  LYS   184      33.350  16.204   2.538  1.00 16.23      A   
ATOM   1489  CE  LYS   184      33.506  15.486   1.200  1.00 15.65      A   
ATOM   1490  NZ  LYS   184      34.640  14.527   1.162  1.00 17.53      A   
ATOM   1491  C   LYS   184      32.404  19.487   5.542  1.00 12.40      A   
ATOM   1492  O   LYS   184      31.376  19.442   6.220  1.00 11.04      A   
ATOM   1493  N   MET   185      33.152  20.585   5.457  1.00 10.15      A   
ATOM   1494  CA  MET   185      32.743  21.801   6.145  1.00 11.29      A   
ATOM   1495  CB  MET   185      33.945  22.524   6.764  1.00 14.65      A   
ATOM   1496  CG  MET   185      34.936  23.132   5.786  1.00 18.99      A   
ATOM   1497  SD  MET   185      36.492  23.836   6.762  1.00 32.84      A   
ATOM   1498  CE  MET   185      36.450  22.565   8.204  1.00 20.95      A   
ATOM   1499  C   MET   185      32.005  22.736   5.195  1.00 11.57      A   
ATOM   1500  O   MET   185      32.262  22.754   3.990  1.00 11.19      A   
ATOM   1501  N   TRP   186      31.066  23.494   5.750  1.00 11.03      A   
ATOM   1502  CA  TRP   186      30.277  24.428   4.966  1.00  8.87      A   
ATOM   1503  CB  TRP   186      28.790  24.054   5.004  1.00 10.18      A   
ATOM   1504  CG  TRP   186      28.473  22.744   4.372  1.00 10.21      A   
ATOM   1505  CD2 TRP   186      27.970  22.535   3.049  1.00  8.63      A   
ATOM   1506  CE2 TRP   186      27.842  21.139   2.867  1.00  9.33      A   
ATOM   1507  CE3 TRP   186      27.615  23.394   1.996  1.00  8.96      A   
ATOM   1508  CD1 TRP   186      28.627  21.503   4.927  1.00  9.39      A   
ATOM   1509  NE1 TRP   186      28.250  20.533   4.028  1.00  7.32      A   
ATOM   1510  CZ2 TRP   186      27.372  20.577   1.674  1.00  8.25      A   
ATOM   1511  CZ3 TRP   186      27.148  22.838   0.805  1.00  8.55      A   
ATOM   1512  CH2 TRP   186      27.030  21.438   0.657  1.00  8.88      A   
ATOM   1513  C   TRP   186      30.436  25.838   5.502  1.00  9.42      A   
ATOM   1514  O   TRP   186      30.453  26.057   6.715  1.00  5.57      A   
ATOM   1515  N   THR   187      30.562  26.794   4.588  1.00  9.57      A   
ATOM   1516  CA  THR   187      30.683  28.195   4.956  1.00 10.36      A   
ATOM   1517  CB  THR   187      32.160  28.650   5.054  1.00 10.70      A   
ATOM   1518  OG1 THR   187      32.204  30.002   5.525  1.00 10.75      A   
ATOM   1519  CG2 THR   187      32.850  28.576   3.684  1.00 10.48      A   
ATOM   1520  C   THR   187      29.979  29.027   3.897  1.00 10.71      A   
ATOM   1521  O   THR   187      29.958  28.669   2.718  1.00  8.47      A   
ATOM   1522  N   ILE   188      29.383  30.131   4.323  1.00  9.53      A   
ATOM   1523  CA  ILE   188      28.695  31.002   3.388  1.00 11.86      A   
ATOM   1524  CB  ILE   188      27.150  30.881   3.561  1.00 10.82      A   
ATOM   1525  CG2 ILE   188      26.722  31.451   4.909  1.00 12.82      A   
ATOM   1526  CG1 ILE   188      26.435  31.576   2.401  1.00 12.23      A   
ATOM   1527  CD1 ILE   188      24.958  31.227   2.302  1.00 12.75      A   
ATOM   1528  C   ILE   188      29.181  32.433   3.612  1.00 11.75      A   
ATOM   1529  O   ILE   188      29.290  32.897   4.746  1.00 11.59      A   
ATOM   1530  N   THR   189      29.509  33.116   2.521  1.00 14.39      A   
ATOM   1531  CA  THR   189      29.997  34.487   2.595  1.00 13.97      A   
ATOM   1532  CB  THR   189      31.002  34.785   1.458  1.00 13.76      A   
ATOM   1533  OG1 THR   189      30.307  34.846   0.204  1.00 11.88      A   
ATOM   1534  CG2 THR   189      32.060  33.682   1.381  1.00 12.41      A   
ATOM   1535  C   THR   189      28.827  35.448   2.471  1.00 15.60      A   
ATOM   1536  O   THR   189      27.758  35.066   1.989  1.00 16.81      A   
ATOM   1537  N   ASP   190      29.032  36.693   2.895  1.00 15.82      A   
ATOM   1538  CA  ASP   190      27.979  37.704   2.813  1.00 18.51      A   
ATOM   1539  CB  ASP   190      27.850  38.460   4.150  1.00 17.40      A   
ATOM   1540  CG  ASP   190      29.110  39.236   4.537  1.00 18.64      A   
ATOM   1541  OD1 ASP   190      29.198  39.657   5.711  1.00 17.66      A   
ATOM   1542  OD2 ASP   190      30.000  39.441   3.690  1.00 17.81      A   
ATOM   1543  C   ASP   190      28.218  38.672   1.652  1.00 19.61      A   
ATOM   1544  O   ASP   190      27.413  39.569   1.402  1.00 19.95      A   
ATOM   1545  N   GLY   191      29.325  38.464   0.941  1.00 20.32      A   
ATOM   1546  CA  GLY   191      29.660  39.293  -0.203  1.00 22.28      A   
ATOM   1547  C   GLY   191      29.979  40.747   0.090  1.00 23.76      A   
ATOM   1548  O   GLY   191      29.956  41.581  -0.816  1.00 23.54      A   
ATOM   1549  N   GLY   192      30.283  41.055   1.346  1.00 23.90      A   
ATOM   1550  CA  GLY   192      30.593  42.423   1.708  1.00 26.88      A   
ATOM   1551  C   GLY   192      29.397  43.337   1.517  1.00 28.51      A   
ATOM   1552  O   GLY   192      28.252  42.928   1.724  1.00 27.77      A   
ATOM   1553  N   TYR   193      29.661  44.577   1.113  1.00 30.55      A   
ATOM   1554  CA  TYR   193      28.601  45.556   0.894  1.00 31.13      A   
ATOM   1555  CB  TYR   193      28.199  46.196   2.228  1.00 31.26      A   
ATOM   1556  CG  TYR   193      29.331  46.883   2.962  1.00 33.58      A   
ATOM   1557  CD1 TYR   193      29.566  48.250   2.806  1.00 33.58      A   
ATOM   1558  CE1 TYR   193      30.614  48.884   3.479  1.00 34.74      A   
ATOM   1559  CD2 TYR   193      30.173  46.163   3.809  1.00 33.90      A   
ATOM   1560  CE2 TYR   193      31.225  46.784   4.484  1.00 34.66      A   
ATOM   1561  CZ  TYR   193      31.440  48.144   4.316  1.00 35.93      A   
ATOM   1562  OH  TYR   193      32.480  48.762   4.979  1.00 36.22      A   
ATOM   1563  C   TYR   193      29.039  46.625  -0.102  1.00 32.42      A   
ATOM   1564  O   TYR   193      30.233  46.840  -0.314  1.00 32.62      A   
ATOM   1565  N   GLU   194      28.066  47.286  -0.718  1.00 33.38      A   
ATOM   1566  CA  GLU   194      28.355  48.325  -1.698  1.00 35.18      A   
ATOM   1567  CB  GLU   194      27.063  48.791  -2.371  1.00 36.48      A   
ATOM   1568  CG  GLU   194      27.281  49.765  -3.516  1.00 39.88      A   
ATOM   1569  CD  GLU   194      25.979  50.187  -4.172  1.00 42.15      A   
ATOM   1570  OE1 GLU   194      25.272  49.309  -4.712  1.00 43.69      A   
ATOM   1571  OE2 GLU   194      25.661  51.395  -4.144  1.00 43.50      A   
ATOM   1572  C   GLU   194      29.058  49.511  -1.052  1.00 34.98      A   
ATOM   1573  O   GLU   194      28.617  50.025  -0.023  1.00 35.30      A   
ATOM   1574  N   GLY   195      30.156  49.939  -1.665  1.00 35.37      A   
ATOM   1575  CA  GLY   195      30.913  51.055  -1.135  1.00 34.24      A   
ATOM   1576  C   GLY   195      31.910  50.580  -0.101  1.00 34.77      A   
ATOM   1577  O   GLY   195      32.530  51.386   0.589  1.00 35.79      A   
ATOM   1578  N   SER   196      32.063  49.263   0.007  1.00 33.85      A   
ATOM   1579  CA  SER   196      32.990  48.675   0.964  1.00 32.48      A   
ATOM   1580  CB  SER   196      32.689  47.188   1.155  1.00 32.17      A   
ATOM   1581  OG  SER   196      33.668  46.582   1.978  1.00 30.41      A   
ATOM   1582  C   SER   196      34.434  48.831   0.514  1.00 32.81      A   
ATOM   1583  O   SER   196      34.762  48.588  -0.650  1.00 32.21      A   
ATOM   1584  N   PRO   197      35.320  49.234   1.439  1.00 33.13      A   
ATOM   1585  CD  PRO   197      35.054  49.534   2.858  1.00 32.49      A   
ATOM   1586  CA  PRO   197      36.740  49.418   1.130  1.00 32.39      A   
ATOM   1587  CB  PRO   197      37.270  50.107   2.383  1.00 33.64      A   
ATOM   1588  CG  PRO   197      36.439  49.491   3.461  1.00 32.32      A   
ATOM   1589  C   PRO   197      37.431  48.082   0.863  1.00 31.76      A   
ATOM   1590  O   PRO   197      38.520  48.038   0.289  1.00 32.51      A   
ATOM   1591  N   TYR   198      36.790  46.996   1.286  1.00 30.00      A   
ATOM   1592  CA  TYR   198      37.342  45.659   1.097  1.00 27.56      A   
ATOM   1593  CB  TYR   198      36.982  44.760   2.283  1.00 25.17      A   
ATOM   1594  CG  TYR   198      37.684  43.416   2.268  1.00 23.13      A   
ATOM   1595  CD1 TYR   198      39.076  43.337   2.326  1.00 20.99      A   
ATOM   1596  CE1 TYR   198      39.731  42.106   2.327  1.00 20.73      A   
ATOM   1597  CD2 TYR   198      36.959  42.226   2.208  1.00 21.94      A   
ATOM   1598  CE2 TYR   198      37.603  40.987   2.208  1.00 19.81      A   
ATOM   1599  CZ  TYR   198      38.989  40.936   2.269  1.00 19.28      A   
ATOM   1600  OH  TYR   198      39.634  39.722   2.272  1.00 16.61      A   
ATOM   1601  C   TYR   198      36.827  45.028  -0.192  1.00 26.89      A   
ATOM   1602  O   TYR   198      37.603  44.494  -0.986  1.00 27.47      A   
ATOM   1603  N   GLY   199      35.516  45.086  -0.400  1.00 25.62      A   
ATOM   1604  CA  GLY   199      34.951  44.508  -1.604  1.00 25.44      A   
ATOM   1605  C   GLY   199      33.448  44.324  -1.567  1.00 25.38      A   
ATOM   1606  O   GLY   199      32.826  44.384  -0.508  1.00 26.66      A   
ATOM   1607  N   TYR   200      32.869  44.108  -2.742  1.00 25.19      A   
ATOM   1608  CA  TYR   200      31.434  43.902  -2.891  1.00 24.52      A   
ATOM   1609  CB  TYR   200      30.744  45.233  -3.212  1.00 25.79      A   
ATOM   1610  CG  TYR   200      29.233  45.165  -3.296  1.00 26.08      A   
ATOM   1611  CD1 TYR   200      28.536  45.936  -4.227  1.00 28.22      A   
ATOM   1612  CE1 TYR   200      27.144  45.892  -4.308  1.00 26.71      A   
ATOM   1613  CD2 TYR   200      28.498  44.345  -2.441  1.00 27.05      A   
ATOM   1614  CE2 TYR   200      27.104  44.295  -2.513  1.00 26.72      A   
ATOM   1615  CZ  TYR   200      26.436  45.070  -3.449  1.00 27.87      A   
ATOM   1616  OH  TYR   200      25.063  45.018  -3.532  1.00 28.57      A   
ATOM   1617  C   TYR   200      31.266  42.936  -4.057  1.00 22.93      A   
ATOM   1618  O   TYR   200      31.609  43.265  -5.190  1.00 22.73      A   
ATOM   1619  N   GLU   201      30.751  41.741  -3.784  1.00 22.14      A   
ATOM   1620  CA  GLU   201      30.570  40.747  -4.836  1.00 20.78      A   
ATOM   1621  CB  GLU   201      31.855  39.926  -4.992  1.00 21.83      A   
ATOM   1622  CG  GLU   201      32.082  38.930  -3.855  1.00 23.60      A   
ATOM   1623  CD  GLU   201      33.491  38.357  -3.813  1.00 26.73      A   
ATOM   1624  OE1 GLU   201      33.690  37.351  -3.098  1.00 25.63      A   
ATOM   1625  OE2 GLU   201      34.399  38.909  -4.474  1.00 25.63      A   
ATOM   1626  C   GLU   201      29.410  39.809  -4.523  1.00 20.17      A   
ATOM   1627  O   GLU   201      28.872  39.814  -3.415  1.00 19.63      A   
ATOM   1628  N   ALA   202      29.025  39.006  -5.508  1.00 18.81      A   
ATOM   1629  CA  ALA   202      27.948  38.046  -5.311  1.00 19.27      A   
ATOM   1630  CB  ALA   202      27.561  37.407  -6.639  1.00 18.96      A   
ATOM   1631  C   ALA   202      28.475  36.987  -4.341  1.00 17.38      A   
ATOM   1632  O   ALA   202      29.515  36.376  -4.585  1.00 17.30      A   
ATOM   1633  N   PRO   203      27.765  36.762  -3.225  1.00 16.95      A   
ATOM   1634  CD  PRO   203      26.491  37.413  -2.871  1.00 16.93      A   
ATOM   1635  CA  PRO   203      28.148  35.780  -2.200  1.00 15.84      A   
ATOM   1636  CB  PRO   203      27.208  36.113  -1.048  1.00 15.64      A   
ATOM   1637  CG  PRO   203      25.958  36.505  -1.768  1.00 17.09      A   
ATOM   1638  C   PRO   203      27.996  34.332  -2.671  1.00 15.09      A   
ATOM   1639  O   PRO   203      27.326  34.063  -3.667  1.00 14.05      A   
ATOM   1640  N   SER   204      28.613  33.404  -1.944  1.00 15.11      A   
ATOM   1641  CA  SER   204      28.551  31.990  -2.295  1.00 14.19      A   
ATOM   1642  CB  SER   204      29.744  31.610  -3.184  1.00 16.60      A   
ATOM   1643  OG  SER   204      29.738  32.321  -4.410  1.00 18.65      A   
ATOM   1644  C   SER   204      28.549  31.064  -1.081  1.00 14.91      A   
ATOM   1645  O   SER   204      29.016  31.428   0.005  1.00 12.40      A   
ATOM   1646  N   LEU   205      28.019  29.860  -1.288  1.00 13.47      A   
ATOM   1647  CA  LEU   205      27.979  28.815  -0.267  1.00 12.65      A   
ATOM   1648  CB  LEU   205      26.613  28.119  -0.265  1.00  9.80      A   
ATOM   1649  CG  LEU   205      26.477  26.912   0.668  1.00  8.37      A   
ATOM   1650  CD1 LEU   205      26.625  27.366   2.108  1.00  9.19      A   
ATOM   1651  CD2 LEU   205      25.124  26.239   0.456  1.00  9.51      A   
ATOM   1652  C   LEU   205      29.059  27.824  -0.697  1.00 12.26      A   
ATOM   1653  O   LEU   205      29.083  27.410  -1.854  1.00 13.51      A   
ATOM   1654  N   TYR   206      29.953  27.456   0.217  1.00 12.60      A   
ATOM   1655  CA  TYR   206      31.043  26.531  -0.102  1.00 11.78      A   
ATOM   1656  CB  TYR   206      32.403  27.171   0.194  1.00 12.75      A   
ATOM   1657  CG  TYR   206      32.760  28.372  -0.645  1.00 12.70      A   
ATOM   1658  CD1 TYR   206      33.571  28.241  -1.773  1.00 14.55      A   
ATOM   1659  CE1 TYR   206      33.939  29.352  -2.526  1.00 16.39      A   
ATOM   1660  CD2 TYR   206      32.320  29.645  -0.292  1.00 12.69      A   
ATOM   1661  CE2 TYR   206      32.679  30.763  -1.040  1.00 14.83      A   
ATOM   1662  CZ  TYR   206      33.491  30.608  -2.154  1.00 17.65      A   
ATOM   1663  OH  TYR   206      33.856  31.709  -2.893  1.00 18.70      A   
ATOM   1664  C   TYR   206      30.998  25.228   0.680  1.00 12.64      A   
ATOM   1665  O   TYR   206      30.637  25.209   1.856  1.00 12.58      A   
ATOM   1666  N   ARG   207      31.383  24.147   0.012  1.00 13.04      A   
ATOM   1667  CA  ARG   207      31.469  22.829   0.626  1.00 14.26      A   
ATOM   1668  CB  ARG   207      30.624  21.812  -0.135  1.00 14.74      A   
ATOM   1669  CG  ARG   207      30.615  20.433   0.500  1.00 17.07      A   
ATOM   1670  CD  ARG   207      29.799  19.465  -0.338  1.00 20.79      A   
ATOM   1671  NE  ARG   207      30.636  18.493  -1.028  1.00 23.81      A   
ATOM   1672  CZ  ARG   207      30.213  17.707  -2.011  1.00 26.64      A   
ATOM   1673  NH1 ARG   207      31.050  16.843  -2.576  1.00 27.24      A   
ATOM   1674  NH2 ARG   207      28.960  17.796  -2.440  1.00 27.20      A   
ATOM   1675  C   ARG   207      32.951  22.489   0.480  1.00 13.37      A   
ATOM   1676  O   ARG   207      33.444  22.330  -0.637  1.00 12.99      A   
ATOM   1677  N   ILE   208      33.654  22.391   1.605  1.00 12.28      A   
ATOM   1678  CA  ILE   208      35.094  22.125   1.611  1.00 11.55      A   
ATOM   1679  CB  ILE   208      35.838  23.302   2.279  1.00 11.86      A   
ATOM   1680  CG2 ILE   208      37.355  23.101   2.195  1.00 12.32      A   
ATOM   1681  CG1 ILE   208      35.428  24.612   1.597  1.00 10.45      A   
ATOM   1682  CD1 ILE   208      35.695  25.849   2.429  1.00 13.26      A   
ATOM   1683  C   ILE   208      35.459  20.837   2.345  1.00 11.91      A   
ATOM   1684  O   ILE   208      35.000  20.596   3.461  1.00  9.86      A   
ATOM   1685  N   ASP   209      36.291  20.012   1.718  1.00 12.73      A   
ATOM   1686  CA  ASP   209      36.716  18.760   2.330  1.00 12.97      A   
ATOM   1687  CB  ASP   209      37.424  17.880   1.300  1.00 14.30      A   
ATOM   1688  CG  ASP   209      37.751  16.508   1.846  1.00 15.25      A   
ATOM   1689  OD1 ASP   209      36.811  15.821   2.299  1.00 15.73      A   
ATOM   1690  OD2 ASP   209      38.934  16.118   1.825  1.00 16.14      A   
ATOM   1691  C   ASP   209      37.669  19.060   3.486  1.00 13.28      A   
ATOM   1692  O   ASP   209      38.662  19.759   3.305  1.00 14.44      A   
ATOM   1693  N   ALA   210      37.376  18.525   4.668  1.00 12.29      A   
ATOM   1694  CA  ALA   210      38.214  18.765   5.843  1.00 12.87      A   
ATOM   1695  CB  ALA   210      37.500  18.279   7.104  1.00 13.88      A   
ATOM   1696  C   ALA   210      39.591  18.118   5.758  1.00 12.08      A   
ATOM   1697  O   ALA   210      40.587  18.712   6.172  1.00 11.69      A   
ATOM   1698  N   GLU   211      39.650  16.897   5.235  1.00 11.99      A   
ATOM   1699  CA  GLU   211      40.918  16.178   5.134  1.00 11.86      A   
ATOM   1700  CB  GLU   211      40.676  14.734   4.687  1.00 13.91      A   
ATOM   1701  CG  GLU   211      41.930  13.864   4.645  1.00 15.77      A   
ATOM   1702  CD  GLU   211      42.601  13.710   6.007  1.00 16.94      A   
ATOM   1703  OE1 GLU   211      41.901  13.798   7.030  1.00 17.93      A   
ATOM   1704  OE2 GLU   211      43.827  13.482   6.057  1.00 20.49      A   
ATOM   1705  C   GLU   211      41.916  16.833   4.193  1.00 13.05      A   
ATOM   1706  O   GLU   211      43.083  16.989   4.541  1.00 13.18      A   
ATOM   1707  N   THR   212      41.459  17.218   3.005  1.00 13.23      A   
ATOM   1708  CA  THR   212      42.339  17.837   2.022  1.00 12.72      A   
ATOM   1709  CB  THR   212      42.018  17.323   0.600  1.00 14.15      A   
ATOM   1710  OG1 THR   212      40.692  17.724   0.228  1.00 12.97      A   
ATOM   1711  CG2 THR   212      42.112  15.803   0.553  1.00 14.73      A   
ATOM   1712  C   THR   212      42.276  19.368   2.018  1.00 13.20      A   
ATOM   1713  O   THR   212      43.097  20.026   1.373  1.00 11.67      A   
ATOM   1714  N   PHE   213      41.311  19.927   2.743  1.00 11.79      A   
ATOM   1715  CA  PHE   213      41.129  21.377   2.825  1.00 11.97      A   
ATOM   1716  CB  PHE   213      42.335  22.036   3.511  1.00 11.71      A   
ATOM   1717  CG  PHE   213      42.038  23.386   4.126  1.00 10.76      A   
ATOM   1718  CD1 PHE   213      43.070  24.156   4.658  1.00 12.51      A   
ATOM   1719  CD2 PHE   213      40.731  23.864   4.222  1.00 10.83      A   
ATOM   1720  CE1 PHE   213      42.812  25.381   5.282  1.00 10.52      A   
ATOM   1721  CE2 PHE   213      40.456  25.089   4.843  1.00  9.58      A   
ATOM   1722  CZ  PHE   213      41.502  25.846   5.375  1.00 11.34      A   
ATOM   1723  C   PHE   213      40.959  21.961   1.423  1.00 13.60      A   
ATOM   1724  O   PHE   213      41.565  22.979   1.085  1.00 11.78      A   
ATOM   1725  N   THR   214      40.134  21.306   0.611  1.00 14.03      A   
ATOM   1726  CA  THR   214      39.878  21.753  -0.753  1.00 15.39      A   
ATOM   1727  CB  THR   214      40.417  20.741  -1.787  1.00 15.74      A   
ATOM   1728  OG1 THR   214      39.829  19.457  -1.547  1.00 18.69      A   
ATOM   1729  CG2 THR   214      41.935  20.622  -1.688  1.00 16.79      A   
ATOM   1730  C   THR   214      38.388  21.957  -1.028  1.00 14.64      A   
ATOM   1731  O   THR   214      37.540  21.215  -0.528  1.00 14.40      A   
ATOM   1732  N   VAL   215      38.085  22.969  -1.833  1.00 14.46      A   
ATOM   1733  CA  VAL   215      36.713  23.294  -2.214  1.00 14.42      A   
ATOM   1734  CB  VAL   215      36.654  24.649  -2.955  1.00 13.19      A   
ATOM   1735  CG1 VAL   215      35.243  24.909  -3.477  1.00 13.13      A   
ATOM   1736  CG2 VAL   215      37.089  25.766  -2.023  1.00 13.29      A   
ATOM   1737  C   VAL   215      36.173  22.217  -3.148  1.00 14.74      A   
ATOM   1738  O   VAL   215      36.802  21.898  -4.152  1.00 15.84      A   
ATOM   1739  N   GLU   216      35.011  21.659  -2.823  1.00 14.04      A   
ATOM   1740  CA  GLU   216      34.417  20.630  -3.668  1.00 15.78      A   
ATOM   1741  CB  GLU   216      34.000  19.420  -2.836  1.00 14.79      A   
ATOM   1742  CG  GLU   216      35.113  18.809  -2.015  1.00 15.81      A   
ATOM   1743  CD  GLU   216      34.723  17.460  -1.441  1.00 17.87      A   
ATOM   1744  OE1 GLU   216      33.526  17.265  -1.136  1.00 18.06      A   
ATOM   1745  OE2 GLU   216      35.615  16.605  -1.290  1.00 19.47      A   
ATOM   1746  C   GLU   216      33.199  21.157  -4.414  1.00 17.50      A   
ATOM   1747  O   GLU   216      32.923  20.743  -5.540  1.00 17.95      A   
ATOM   1748  N   LYS   217      32.474  22.066  -3.770  1.00 16.87      A   
ATOM   1749  CA  LYS   217      31.273  22.664  -4.345  1.00 17.62      A   
ATOM   1750  CB  LYS   217      30.018  21.978  -3.787  1.00 18.45      A   
ATOM   1751  CG  LYS   217      29.731  20.574  -4.317  1.00 24.21      A   
ATOM   1752  CD  LYS   217      29.142  20.614  -5.721  1.00 25.37      A   
ATOM   1753  CE  LYS   217      28.727  19.224  -6.196  1.00 27.58      A   
ATOM   1754  NZ  LYS   217      27.762  18.572  -5.266  1.00 31.74      A   
ATOM   1755  C   LYS   217      31.201  24.147  -4.006  1.00 16.28      A   
ATOM   1756  O   LYS   217      31.601  24.564  -2.922  1.00 14.39      A   
ATOM   1757  N   GLN   218      30.683  24.936  -4.940  1.00 16.47      A   
ATOM   1758  CA  GLN   218      30.520  26.370  -4.739  1.00 16.98      A   
ATOM   1759  CB  GLN   218      31.658  27.161  -5.388  1.00 17.29      A   
ATOM   1760  CG  GLN   218      31.646  28.641  -5.018  1.00 18.68      A   
ATOM   1761  CD  GLN   218      32.648  29.464  -5.813  1.00 20.19      A   
ATOM   1762  OE1 GLN   218      33.679  28.955  -6.255  1.00 20.75      A   
ATOM   1763  NE2 GLN   218      32.352  30.749  -5.984  1.00 17.81      A   
ATOM   1764  C   GLN   218      29.203  26.779  -5.384  1.00 18.07      A   
ATOM   1765  O   GLN   218      29.023  26.620  -6.595  1.00 16.79      A   
ATOM   1766  N   PHE   219      28.285  27.289  -4.571  1.00 16.91      A   
ATOM   1767  CA  PHE   219      26.987  27.736  -5.059  1.00 18.23      A   
ATOM   1768  CB  PHE   219      25.850  27.110  -4.242  1.00 17.60      A   
ATOM   1769  CG  PHE   219      25.938  25.613  -4.124  1.00 19.02      A   
ATOM   1770  CD1 PHE   219      26.603  25.025  -3.057  1.00 20.08      A   
ATOM   1771  CD2 PHE   219      25.377  24.791  -5.099  1.00 19.71      A   
ATOM   1772  CE1 PHE   219      26.710  23.638  -2.960  1.00 21.57      A   
ATOM   1773  CE2 PHE   219      25.480  23.403  -5.010  1.00 20.31      A   
ATOM   1774  CZ  PHE   219      26.147  22.827  -3.940  1.00 20.97      A   
ATOM   1775  C   PHE   219      26.960  29.250  -4.910  1.00 19.28      A   
ATOM   1776  O   PHE   219      26.849  29.770  -3.798  1.00 18.07      A   
ATOM   1777  N   LYS   220      27.072  29.954  -6.033  1.00 20.19      A   
ATOM   1778  CA  LYS   220      27.084  31.413  -6.024  1.00 20.98      A   
ATOM   1779  CB  LYS   220      27.932  31.943  -7.191  1.00 23.64      A   
ATOM   1780  CG  LYS   220      28.041  33.462  -7.240  1.00 24.45      A   
ATOM   1781  CD  LYS   220      29.203  33.930  -8.110  1.00 28.48      A   
ATOM   1782  CE  LYS   220      30.547  33.558  -7.493  1.00 28.53      A   
ATOM   1783  NZ  LYS   220      31.682  34.177  -8.232  1.00 30.71      A   
ATOM   1784  C   LYS   220      25.677  31.983  -6.090  1.00 21.11      A   
ATOM   1785  O   LYS   220      24.802  31.432  -6.759  1.00 20.44      A   
ATOM   1786  N   PHE   221      25.455  33.086  -5.383  1.00 20.25      A   
ATOM   1787  CA  PHE   221      24.137  33.702  -5.371  1.00 20.40      A   
ATOM   1788  CB  PHE   221      23.661  33.878  -3.927  1.00 18.93      A   
ATOM   1789  CG  PHE   221      23.660  32.594  -3.138  1.00 17.67      A   
ATOM   1790  CD1 PHE   221      24.579  32.392  -2.113  1.00 17.19      A   
ATOM   1791  CD2 PHE   221      22.765  31.573  -3.445  1.00 16.95      A   
ATOM   1792  CE1 PHE   221      24.612  31.189  -1.402  1.00 17.51      A   
ATOM   1793  CE2 PHE   221      22.788  30.365  -2.741  1.00 18.25      A   
ATOM   1794  CZ  PHE   221      23.714  30.175  -1.718  1.00 17.19      A   
ATOM   1795  C   PHE   221      24.104  35.026  -6.128  1.00 20.94      A   
ATOM   1796  O   PHE   221      24.950  35.283  -6.983  1.00 18.32      A   
ATOM   1797  N   LYS   222      23.121  35.860  -5.814  1.00 23.88      A   
ATOM   1798  CA  LYS   222      22.957  37.137  -6.496  1.00 25.40      A   
ATOM   1799  CB  LYS   222      21.461  37.414  -6.695  1.00 27.72      A   
ATOM   1800  CG  LYS   222      21.132  38.725  -7.399  1.00 31.95      A   
ATOM   1801  CD  LYS   222      19.624  38.904  -7.584  1.00 34.67      A   
ATOM   1802  CE  LYS   222      19.301  40.234  -8.265  1.00 36.54      A   
ATOM   1803  NZ  LYS   222      17.847  40.402  -8.559  1.00 38.27      A   
ATOM   1804  C   LYS   222      23.614  38.309  -5.775  1.00 25.48      A   
ATOM   1805  O   LYS   222      23.649  38.360  -4.545  1.00 24.76      A   
ATOM   1806  N   LEU   223      24.142  39.247  -6.555  1.00 24.79      A   
ATOM   1807  CA  LEU   223      24.781  40.432  -6.001  1.00 24.29      A   
ATOM   1808  CB  LEU   223      25.330  41.309  -7.129  1.00 24.92      A   
ATOM   1809  CG  LEU   223      25.986  42.621  -6.695  1.00 24.70      A   
ATOM   1810  CD1 LEU   223      27.218  42.330  -5.850  1.00 22.88      A   
ATOM   1811  CD2 LEU   223      26.360  43.430  -7.928  1.00 24.36      A   
ATOM   1812  C   LEU   223      23.736  41.208  -5.207  1.00 23.90      A   
ATOM   1813  O   LEU   223      22.619  41.418  -5.678  1.00 24.82      A   
ATOM   1814  N   GLY   224      24.099  41.629  -4.001  1.00 23.32      A   
ATOM   1815  CA  GLY   224      23.161  42.357  -3.171  1.00 23.29      A   
ATOM   1816  C   GLY   224      22.691  41.526  -1.988  1.00 23.61      A   
ATOM   1817  O   GLY   224      22.242  42.074  -0.980  1.00 23.44      A   
ATOM   1818  N   ASP   225      22.781  40.202  -2.102  1.00 22.86      A   
ATOM   1819  CA  ASP   225      22.371  39.334  -1.002  1.00 22.57      A   
ATOM   1820  CB  ASP   225      22.267  37.865  -1.437  1.00 22.46      A   
ATOM   1821  CG  ASP   225      21.178  37.618  -2.461  1.00 23.67      A   
ATOM   1822  OD1 ASP   225      20.205  38.398  -2.524  1.00 23.59      A   
ATOM   1823  OD2 ASP   225      21.297  36.615  -3.193  1.00 21.53      A   
ATOM   1824  C   ASP   225      23.400  39.408   0.119  1.00 21.65      A   
ATOM   1825  O   ASP   225      24.587  39.614  -0.130  1.00 23.07      A   
ATOM   1826  N   TRP   226      22.943  39.245   1.354  1.00 21.58      A   
ATOM   1827  CA  TRP   226      23.850  39.252   2.494  1.00 22.22      A   
ATOM   1828  CB  TRP   226      23.732  40.568   3.291  1.00 24.12      A   
ATOM   1829  CG  TRP   226      22.370  40.874   3.859  1.00 27.22      A   
ATOM   1830  CD2 TRP   226      21.251  41.421   3.152  1.00 29.63      A   
ATOM   1831  CE2 TRP   226      20.187  41.538   4.078  1.00 30.57      A   
ATOM   1832  CE3 TRP   226      21.040  41.818   1.823  1.00 29.58      A   
ATOM   1833  CD1 TRP   226      21.954  40.690   5.151  1.00 28.80      A   
ATOM   1834  NE1 TRP   226      20.644  41.088   5.290  1.00 31.43      A   
ATOM   1835  CZ2 TRP   226      18.932  42.042   3.719  1.00 31.18      A   
ATOM   1836  CZ3 TRP   226      19.792  42.318   1.465  1.00 31.35      A   
ATOM   1837  CH2 TRP   226      18.752  42.424   2.412  1.00 31.59      A   
ATOM   1838  C   TRP   226      23.528  38.034   3.357  1.00 20.39      A   
ATOM   1839  O   TRP   226      23.075  38.158   4.491  1.00 22.43      A   
ATOM   1840  N   PRO   227      23.773  36.826   2.817  1.00 18.95      A   
ATOM   1841  CD  PRO   227      24.384  36.571   1.500  1.00 17.99      A   
ATOM   1842  CA  PRO   227      23.507  35.571   3.528  1.00 17.13      A   
ATOM   1843  CB  PRO   227      23.703  34.512   2.444  1.00 18.25      A   
ATOM   1844  CG  PRO   227      24.758  35.103   1.581  1.00 19.54      A   
ATOM   1845  C   PRO   227      24.390  35.348   4.752  1.00 15.77      A   
ATOM   1846  O   PRO   227      25.393  36.040   4.945  1.00 14.75      A   
ATOM   1847  N   SER   228      24.008  34.380   5.581  1.00 13.79      A   
ATOM   1848  CA  SER   228      24.758  34.082   6.793  1.00 13.19      A   
ATOM   1849  CB  SER   228      24.761  35.307   7.708  1.00 15.03      A   
ATOM   1850  OG  SER   228      23.441  35.605   8.152  1.00 15.79      A   
ATOM   1851  C   SER   228      24.159  32.913   7.560  1.00 13.22      A   
ATOM   1852  O   SER   228      23.168  32.309   7.144  1.00 10.48      A   
ATOM   1853  N   GLU   229      24.787  32.614   8.691  1.00 12.95      A   
ATOM   1854  CA  GLU   229      24.354  31.571   9.608  1.00 12.91      A   
ATOM   1855  CB  GLU   229      23.120  32.057  10.378  1.00 16.40      A   
ATOM   1856  CG  GLU   229      23.431  33.099  11.443  1.00 20.93      A   
ATOM   1857  CD  GLU   229      24.387  32.574  12.510  1.00 23.21      A   
ATOM   1858  OE1 GLU   229      24.038  31.584  13.188  1.00 25.74      A   
ATOM   1859  OE2 GLU   229      25.485  33.147  12.669  1.00 25.78      A   
ATOM   1860  C   GLU   229      24.093  30.161   9.087  1.00 11.41      A   
ATOM   1861  O   GLU   229      22.967  29.663   9.174  1.00  9.90      A   
ATOM   1862  N   VAL   230      25.120  29.509   8.547  1.00  9.74      A   
ATOM   1863  CA  VAL   230      24.929  28.134   8.113  1.00  9.77      A   
ATOM   1864  CB  VAL   230      26.179  27.548   7.387  1.00 10.00      A   
ATOM   1865  CG1 VAL   230      26.226  28.039   5.944  1.00  9.68      A   
ATOM   1866  CG2 VAL   230      27.458  27.935   8.124  1.00  8.68      A   
ATOM   1867  C   VAL   230      24.681  27.366   9.418  1.00 11.26      A   
ATOM   1868  O   VAL   230      25.320  27.638  10.440  1.00 11.52      A   
ATOM   1869  N   GLN   231      23.732  26.436   9.377  1.00  9.13      A   
ATOM   1870  CA  GLN   231      23.355  25.613  10.527  1.00 10.27      A   
ATOM   1871  CB  GLN   231      22.094  26.179  11.200  1.00 10.21      A   
ATOM   1872  CG  GLN   231      22.264  27.469  11.998  1.00  9.41      A   
ATOM   1873  CD  GLN   231      23.042  27.266  13.288  1.00 13.09      A   
ATOM   1874  OE1 GLN   231      22.808  26.307  14.023  1.00 15.60      A   
ATOM   1875  NE2 GLN   231      23.964  28.176  13.573  1.00 13.17      A   
ATOM   1876  C   GLN   231      23.044  24.195  10.036  1.00 10.72      A   
ATOM   1877  O   GLN   231      22.564  24.017   8.915  1.00 10.37      A   
ATOM   1878  N   LEU   232      23.301  23.192  10.876  1.00 10.22      A   
ATOM   1879  CA  LEU   232      23.024  21.797  10.524  1.00  8.91      A   
ATOM   1880  CB  LEU   232      24.306  20.955  10.566  1.00 11.18      A   
ATOM   1881  CG  LEU   232      25.354  21.160   9.469  1.00  9.70      A   
ATOM   1882  CD1 LEU   232      26.618  20.390   9.816  1.00  8.46      A   
ATOM   1883  CD2 LEU   232      24.790  20.698   8.138  1.00  9.99      A   
ATOM   1884  C   LEU   232      22.024  21.175  11.490  1.00  8.72      A   
ATOM   1885  O   LEU   232      21.874  21.636  12.622  1.00  7.60      A   
ATOM   1886  N   ASN   233      21.345  20.124  11.044  1.00  9.01      A   
ATOM   1887  CA  ASN   233      20.394  19.439  11.904  1.00  9.48      A   
ATOM   1888  CB  ASN   233      19.301  18.760  11.060  1.00  9.54      A   
ATOM   1889  CG  ASN   233      19.840  17.676  10.145  1.00  9.34      A   
ATOM   1890  OD1 ASN   233      21.024  17.657   9.809  1.00 10.57      A   
ATOM   1891  ND2 ASN   233      18.961  16.773   9.721  1.00  9.38      A   
ATOM   1892  C   ASN   233      21.198  18.431  12.733  1.00 11.28      A   
ATOM   1893  O   ASN   233      22.420  18.339  12.586  1.00 10.40      A   
ATOM   1894  N   GLY   234      20.523  17.692  13.608  1.00 11.07      A   
ATOM   1895  CA  GLY   234      21.201  16.726  14.459  1.00 11.89      A   
ATOM   1896  C   GLY   234      22.097  15.704  13.775  1.00 11.73      A   
ATOM   1897  O   GLY   234      23.213  15.456  14.224  1.00 11.13      A   
ATOM   1898  N   THR   235      21.615  15.106  12.692  1.00 11.73      A   
ATOM   1899  CA  THR   235      22.390  14.103  11.965  1.00 12.88      A   
ATOM   1900  CB  THR   235      21.462  13.177  11.151  1.00 13.73      A   
ATOM   1901  OG1 THR   235      20.475  13.963  10.469  1.00 15.19      A   
ATOM   1902  CG2 THR   235      20.768  12.187  12.073  1.00 16.82      A   
ATOM   1903  C   THR   235      23.433  14.712  11.036  1.00 10.97      A   
ATOM   1904  O   THR   235      24.168  13.995  10.360  1.00 10.28      A   
ATOM   1905  N   ARG   236      23.485  16.041  11.009  1.00 11.32      A   
ATOM   1906  CA  ARG   236      24.436  16.784  10.183  1.00 10.48      A   
ATOM   1907  CB  ARG   236      25.858  16.589  10.718  1.00 11.73      A   
ATOM   1908  CG  ARG   236      26.068  17.118  12.137  1.00 14.20      A   
ATOM   1909  CD  ARG   236      27.400  16.653  12.693  1.00 17.11      A   
ATOM   1910  NE  ARG   236      27.643  17.139  14.051  1.00 21.62      A   
ATOM   1911  CZ  ARG   236      28.367  18.215  14.345  1.00 23.50      A   
ATOM   1912  NH1 ARG   236      28.929  18.927  13.377  1.00 25.43      A   
ATOM   1913  NH2 ARG   236      28.530  18.579  15.608  1.00 21.37      A   
ATOM   1914  C   ARG   236      24.396  16.420   8.704  1.00 10.79      A   
ATOM   1915  O   ARG   236      25.440  16.316   8.054  1.00  8.80      A   
ATOM   1916  N   ASP   237      23.194  16.219   8.172  1.00 10.95      A   
ATOM   1917  CA  ASP   237      23.053  15.893   6.760  1.00 10.04      A   
ATOM   1918  CB  ASP   237      22.631  14.433   6.562  1.00 12.95      A   
ATOM   1919  CG  ASP   237      21.583  13.983   7.547  1.00 16.22      A   
ATOM   1920  OD1 ASP   237      20.738  14.807   7.952  1.00 17.07      A   
ATOM   1921  OD2 ASP   237      21.603  12.790   7.906  1.00 20.59      A   
ATOM   1922  C   ASP   237      22.081  16.822   6.043  1.00  8.42      A   
ATOM   1923  O   ASP   237      21.811  16.648   4.858  1.00  7.62      A   
ATOM   1924  N   THR   238      21.556  17.803   6.770  1.00  8.12      A   
ATOM   1925  CA  THR   238      20.648  18.792   6.197  1.00  9.41      A   
ATOM   1926  CB  THR   238      19.182  18.588   6.654  1.00 10.66      A   
ATOM   1927  OG1 THR   238      18.708  17.316   6.184  1.00 11.66      A   
ATOM   1928  CG2 THR   238      18.284  19.692   6.074  1.00 11.30      A   
ATOM   1929  C   THR   238      21.151  20.151   6.656  1.00  9.92      A   
ATOM   1930  O   THR   238      21.199  20.442   7.853  1.00  6.50      A   
ATOM   1931  N   LEU   239      21.553  20.968   5.686  1.00  9.82      A   
ATOM   1932  CA  LEU   239      22.094  22.299   5.945  1.00  9.34      A   
ATOM   1933  CB  LEU   239      23.262  22.575   4.988  1.00  8.38      A   
ATOM   1934  CG  LEU   239      24.042  23.877   5.123  1.00 10.19      A   
ATOM   1935  CD1 LEU   239      25.025  23.762   6.280  1.00 10.27      A   
ATOM   1936  CD2 LEU   239      24.808  24.148   3.828  1.00  9.26      A   
ATOM   1937  C   LEU   239      21.049  23.392   5.781  1.00 11.13      A   
ATOM   1938  O   LEU   239      20.240  23.363   4.850  1.00 11.98      A   
ATOM   1939  N   TYR   240      21.075  24.347   6.703  1.00  9.91      A   
ATOM   1940  CA  TYR   240      20.168  25.494   6.684  1.00 10.98      A   
ATOM   1941  CB  TYR   240      19.281  25.533   7.931  1.00 10.99      A   
ATOM   1942  CG  TYR   240      18.249  24.439   8.042  1.00 11.81      A   
ATOM   1943  CD1 TYR   240      18.610  23.137   8.400  1.00 11.00      A   
ATOM   1944  CE1 TYR   240      17.642  22.138   8.543  1.00 12.40      A   
ATOM   1945  CD2 TYR   240      16.900  24.717   7.823  1.00 11.57      A   
ATOM   1946  CE2 TYR   240      15.932  23.732   7.961  1.00 12.18      A   
ATOM   1947  CZ  TYR   240      16.310  22.449   8.323  1.00 12.36      A   
ATOM   1948  OH  TYR   240      15.348  21.488   8.472  1.00 14.11      A   
ATOM   1949  C   TYR   240      21.013  26.757   6.712  1.00 10.50      A   
ATOM   1950  O   TYR   240      22.146  26.736   7.184  1.00 10.10      A   
ATOM   1951  N   TRP   241      20.458  27.853   6.211  1.00  9.65      A   
ATOM   1952  CA  TRP   241      21.147  29.132   6.241  1.00 10.84      A   
ATOM   1953  CB  TRP   241      22.312  29.175   5.231  1.00  9.40      A   
ATOM   1954  CG  TRP   241      21.929  29.211   3.784  1.00  8.63      A   
ATOM   1955  CD2 TRP   241      21.777  28.086   2.916  1.00  9.32      A   
ATOM   1956  CE2 TRP   241      21.438  28.585   1.638  1.00 10.45      A   
ATOM   1957  CE3 TRP   241      21.896  26.699   3.092  1.00  7.93      A   
ATOM   1958  CD1 TRP   241      21.678  30.322   3.022  1.00  8.86      A   
ATOM   1959  NE1 TRP   241      21.385  29.953   1.732  1.00 10.96      A   
ATOM   1960  CZ2 TRP   241      21.214  27.751   0.546  1.00  9.93      A   
ATOM   1961  CZ3 TRP   241      21.671  25.867   2.001  1.00 10.34      A   
ATOM   1962  CH2 TRP   241      21.336  26.396   0.748  1.00  9.97      A   
ATOM   1963  C   TRP   241      20.157  30.260   5.983  1.00 10.88      A   
ATOM   1964  O   TRP   241      18.986  30.015   5.685  1.00  9.41      A   
ATOM   1965  N   ILE   242      20.627  31.494   6.123  1.00  9.96      A   
ATOM   1966  CA  ILE   242      19.787  32.661   5.915  1.00  9.63      A   
ATOM   1967  CB  ILE   242      19.858  33.629   7.132  1.00  9.79      A   
ATOM   1968  CG2 ILE   242      18.891  34.790   6.928  1.00 10.13      A   
ATOM   1969  CG1 ILE   242      19.530  32.894   8.429  1.00  8.90      A   
ATOM   1970  CD1 ILE   242      19.782  33.728   9.692  1.00  9.92      A   
ATOM   1971  C   ILE   242      20.228  33.447   4.678  1.00 10.18      A   
ATOM   1972  O   ILE   242      21.421  33.672   4.464  1.00  8.59      A   
ATOM   1973  N   ASN   243      19.250  33.847   3.872  1.00 10.53      A   
ATOM   1974  CA  ASN   243      19.462  34.653   2.671  1.00 12.32      A   
ATOM   1975  CB  ASN   243      20.009  33.805   1.515  1.00 14.22      A   
ATOM   1976  CG  ASN   243      20.446  34.652   0.319  1.00 15.68      A   
ATOM   1977  OD1 ASN   243      20.782  34.126  -0.747  1.00 20.83      A   
ATOM   1978  ND2 ASN   243      20.448  35.966   0.495  1.00 11.92      A   
ATOM   1979  C   ASN   243      18.062  35.163   2.344  1.00 13.76      A   
ATOM   1980  O   ASN   243      17.384  34.638   1.455  1.00 13.61      A   
ATOM   1981  N   ASN   244      17.643  36.184   3.092  1.00 14.31      A   
ATOM   1982  CA  ASN   244      16.312  36.779   2.981  1.00 15.97      A   
ATOM   1983  CB  ASN   244      15.966  37.120   1.529  1.00 21.99      A   
ATOM   1984  CG  ASN   244      16.876  38.182   0.952  1.00 24.62      A   
ATOM   1985  OD1 ASN   244      17.067  39.236   1.553  1.00 29.88      A   
ATOM   1986  ND2 ASN   244      17.444  37.911  -0.221  1.00 29.75      A   
ATOM   1987  C   ASN   244      15.354  35.728   3.532  1.00 15.64      A   
ATOM   1988  O   ASN   244      14.758  35.921   4.589  1.00 16.52      A   
ATOM   1989  N   ASP   245      15.228  34.613   2.815  1.00 13.41      A   
ATOM   1990  CA  ASP   245      14.383  33.493   3.231  1.00 13.32      A   
ATOM   1991  CB  ASP   245      13.925  32.665   2.027  1.00 14.31      A   
ATOM   1992  CG  ASP   245      13.353  33.500   0.916  1.00 13.46      A   
ATOM   1993  OD1 ASP   245      12.145  33.786   0.956  1.00 15.23      A   
ATOM   1994  OD2 ASP   245      14.120  33.866   0.007  1.00 15.63      A   
ATOM   1995  C   ASP   245      15.275  32.569   4.058  1.00 12.82      A   
ATOM   1996  O   ASP   245      16.485  32.780   4.146  1.00 11.87      A   
ATOM   1997  N   ILE   246      14.678  31.542   4.655  1.00 11.80      A   
ATOM   1998  CA  ILE   246      15.461  30.548   5.389  1.00 11.39      A   
ATOM   1999  CB  ILE   246      14.744  30.018   6.655  1.00 12.10      A   
ATOM   2000  CG2 ILE   246      15.585  28.917   7.300  1.00 12.03      A   
ATOM   2001  CG1 ILE   246      14.511  31.152   7.657  1.00 10.85      A   
ATOM   2002  CD1 ILE   246      15.784  31.873   8.078  1.00 13.88      A   
ATOM   2003  C   ILE   246      15.582  29.393   4.389  1.00 11.90      A   
ATOM   2004  O   ILE   246      14.572  28.836   3.960  1.00 11.69      A   
ATOM   2005  N   TRP   247      16.805  29.043   4.005  1.00 10.51      A   
ATOM   2006  CA  TRP   247      17.014  27.962   3.045  1.00 11.85      A   
ATOM   2007  CB  TRP   247      18.020  28.392   1.974  1.00 12.06      A   
ATOM   2008  CG  TRP   247      17.610  29.618   1.233  1.00 13.77      A   
ATOM   2009  CD2 TRP   247      16.870  29.664   0.006  1.00 13.77      A   
ATOM   2010  CE2 TRP   247      16.632  31.023  -0.286  1.00 15.34      A   
ATOM   2011  CE3 TRP   247      16.380  28.685  -0.870  1.00 14.16      A   
ATOM   2012  CD1 TRP   247      17.794  30.911   1.621  1.00 10.82      A   
ATOM   2013  NE1 TRP   247      17.208  31.763   0.714  1.00 13.92      A   
ATOM   2014  CZ2 TRP   247      15.926  31.433  -1.422  1.00 15.70      A   
ATOM   2015  CZ3 TRP   247      15.675  29.095  -2.001  1.00 15.44      A   
ATOM   2016  CH2 TRP   247      15.456  30.455  -2.263  1.00 14.86      A   
ATOM   2017  C   TRP   247      17.516  26.668   3.674  1.00 12.71      A   
ATOM   2018  O   TRP   247      18.058  26.672   4.776  1.00 12.99      A   
ATOM   2019  N   ARG   248      17.332  25.557   2.970  1.00 12.91      A   
ATOM   2020  CA  ARG   248      17.830  24.273   3.451  1.00 12.74      A   
ATOM   2021  CB  ARG   248      16.845  23.602   4.416  1.00 16.28      A   
ATOM   2022  CG  ARG   248      15.660  22.912   3.781  1.00 18.94      A   
ATOM   2023  CD  ARG   248      14.975  22.060   4.835  1.00 21.04      A   
ATOM   2024  NE  ARG   248      13.732  21.452   4.375  1.00 21.15      A   
ATOM   2025  CZ  ARG   248      12.886  20.807   5.176  1.00 25.26      A   
ATOM   2026  NH1 ARG   248      11.767  20.281   4.693  1.00 23.11      A   
ATOM   2027  NH2 ARG   248      13.162  20.693   6.469  1.00 25.07      A   
ATOM   2028  C   ARG   248      18.115  23.367   2.263  1.00 13.19      A   
ATOM   2029  O   ARG   248      17.497  23.493   1.202  1.00 10.20      A   
ATOM   2030  N   MET   249      19.053  22.450   2.445  1.00 10.82      A   
ATOM   2031  CA  MET   249      19.438  21.555   1.368  1.00 13.67      A   
ATOM   2032  CB  MET   249      20.343  22.342   0.409  1.00 16.36      A   
ATOM   2033  CG  MET   249      21.247  21.525  -0.486  1.00 21.59      A   
ATOM   2034  SD  MET   249      22.588  22.658  -1.369  1.00 34.46      A   
ATOM   2035  CE  MET   249      23.672  23.112   0.122  1.00 18.27      A   
ATOM   2036  C   MET   249      20.165  20.338   1.922  1.00 12.03      A   
ATOM   2037  O   MET   249      20.831  20.429   2.947  1.00 11.83      A   
ATOM   2038  N   PRO   250      20.000  19.171   1.279  1.00 11.13      A   
ATOM   2039  CD  PRO   250      18.980  18.845   0.264  1.00 10.02      A   
ATOM   2040  CA  PRO   250      20.687  17.962   1.748  1.00  9.36      A   
ATOM   2041  CB  PRO   250      20.129  16.869   0.835  1.00  9.74      A   
ATOM   2042  CG  PRO   250      18.737  17.368   0.520  1.00  9.46      A   
ATOM   2043  C   PRO   250      22.172  18.227   1.495  1.00  9.57      A   
ATOM   2044  O   PRO   250      22.510  18.844   0.482  1.00  8.76      A   
ATOM   2045  N   VAL   251      23.059  17.789   2.388  1.00  7.53      A   
ATOM   2046  CA  VAL   251      24.487  18.055   2.183  1.00  6.49      A   
ATOM   2047  CB  VAL   251      25.344  17.721   3.453  1.00  5.52      A   
ATOM   2048  CG1 VAL   251      24.902  18.599   4.625  1.00  6.12      A   
ATOM   2049  CG2 VAL   251      25.226  16.246   3.820  1.00  2.87      A   
ATOM   2050  C   VAL   251      25.073  17.325   0.979  1.00  8.53      A   
ATOM   2051  O   VAL   251      26.167  17.653   0.517  1.00  8.05      A   
ATOM   2052  N   GLU   252      24.332  16.352   0.455  1.00  9.63      A   
ATOM   2053  CA  GLU   252      24.792  15.592  -0.699  1.00 11.03      A   
ATOM   2054  CB  GLU   252      24.379  14.124  -0.554  1.00 11.92      A   
ATOM   2055  CG  GLU   252      24.716  13.523   0.802  1.00 14.22      A   
ATOM   2056  CD  GLU   252      23.529  13.503   1.762  1.00 14.91      A   
ATOM   2057  OE1 GLU   252      22.583  14.311   1.590  1.00 13.76      A   
ATOM   2058  OE2 GLU   252      23.549  12.677   2.705  1.00 15.78      A   
ATOM   2059  C   GLU   252      24.253  16.149  -2.015  1.00 12.18      A   
ATOM   2060  O   GLU   252      24.609  15.664  -3.088  1.00 11.71      A   
ATOM   2061  N   ALA   253      23.405  17.169  -1.940  1.00 13.04      A   
ATOM   2062  CA  ALA   253      22.817  17.754  -3.146  1.00 14.85      A   
ATOM   2063  CB  ALA   253      21.721  18.745  -2.760  1.00 13.60      A   
ATOM   2064  C   ALA   253      23.833  18.435  -4.062  1.00 15.42      A   
ATOM   2065  O   ALA   253      24.873  18.914  -3.612  1.00 15.41      A   
ATOM   2066  N   ASP   254      23.515  18.478  -5.352  1.00 15.40      A   
ATOM   2067  CA  ASP   254      24.388  19.109  -6.328  1.00 16.35      A   
ATOM   2068  CB  ASP   254      24.479  18.268  -7.604  1.00 20.97      A   
ATOM   2069  CG  ASP   254      25.311  17.012  -7.418  1.00 22.55      A   
ATOM   2070  OD1 ASP   254      26.472  17.124  -6.969  1.00 28.32      A   
ATOM   2071  OD2 ASP   254      24.812  15.913  -7.727  1.00 27.53      A   
ATOM   2072  C   ASP   254      23.915  20.513  -6.675  1.00 15.86      A   
ATOM   2073  O   ASP   254      24.476  21.167  -7.550  1.00 15.58      A   
ATOM   2074  N   ARG   255      22.868  20.976  -6.003  1.00 14.49      A   
ATOM   2075  CA  ARG   255      22.373  22.321  -6.251  1.00 13.12      A   
ATOM   2076  CB  ARG   255      21.594  22.382  -7.569  1.00 16.86      A   
ATOM   2077  CG  ARG   255      20.176  21.849  -7.479  1.00 15.50      A   
ATOM   2078  CD  ARG   255      19.345  22.325  -8.660  1.00 20.63      A   
ATOM   2079  NE  ARG   255      17.919  22.089  -8.451  1.00 22.42      A   
ATOM   2080  CZ  ARG   255      16.957  22.575  -9.229  1.00 25.44      A   
ATOM   2081  NH1 ARG   255      15.685  22.306  -8.961  1.00 25.25      A   
ATOM   2082  NH2 ARG   255      17.265  23.337 -10.272  1.00 26.33      A   
ATOM   2083  C   ARG   255      21.479  22.778  -5.116  1.00 12.57      A   
ATOM   2084  O   ARG   255      20.950  21.965  -4.359  1.00 11.82      A   
ATOM   2085  N   VAL   256      21.324  24.090  -4.998  1.00 10.93      A   
ATOM   2086  CA  VAL   256      20.473  24.680  -3.975  1.00 12.49      A   
ATOM   2087  CB  VAL   256      20.845  26.163  -3.739  1.00 13.16      A   
ATOM   2088  CG1 VAL   256      19.871  26.797  -2.750  1.00 10.74      A   
ATOM   2089  CG2 VAL   256      22.282  26.262  -3.224  1.00 11.30      A   
ATOM   2090  C   VAL   256      19.032  24.607  -4.479  1.00 13.19      A   
ATOM   2091  O   VAL   256      18.752  24.970  -5.620  1.00 13.73      A   
ATOM   2092  N   PRO   257      18.105  24.124  -3.641  1.00 13.73      A   
ATOM   2093  CD  PRO   257      18.311  23.549  -2.299  1.00 14.41      A   
ATOM   2094  CA  PRO   257      16.698  24.022  -4.044  1.00 14.75      A   
ATOM   2095  CB  PRO   257      16.012  23.556  -2.762  1.00 14.75      A   
ATOM   2096  CG  PRO   257      17.061  22.716  -2.110  1.00 15.09      A   
ATOM   2097  C   PRO   257      16.150  25.362  -4.541  1.00 16.23      A   
ATOM   2098  O   PRO   257      16.618  26.420  -4.124  1.00 15.56      A   
ATOM   2099  N   VAL   258      15.166  25.316  -5.435  1.00 16.87      A   
ATOM   2100  CA  VAL   258      14.570  26.540  -5.966  1.00 16.20      A   
ATOM   2101  CB  VAL   258      13.761  26.271  -7.260  1.00 16.66      A   
ATOM   2102  CG1 VAL   258      14.695  25.871  -8.396  1.00 18.60      A   
ATOM   2103  CG2 VAL   258      12.737  25.180  -7.008  1.00 19.70      A   
ATOM   2104  C   VAL   258      13.639  27.163  -4.932  1.00 15.07      A   
ATOM   2105  O   VAL   258      13.443  28.375  -4.913  1.00 15.32      A   
ATOM   2106  N   ARG   259      13.062  26.331  -4.075  1.00 14.91      A   
ATOM   2107  CA  ARG   259      12.165  26.823  -3.038  1.00 15.50      A   
ATOM   2108  CB  ARG   259      10.895  25.974  -2.982  1.00 16.31      A   
ATOM   2109  CG  ARG   259       9.917  26.258  -4.105  1.00 17.29      A   
ATOM   2110  CD  ARG   259       9.182  27.558  -3.844  1.00 21.33      A   
ATOM   2111  NE  ARG   259       8.316  27.434  -2.680  1.00 19.74      A   
ATOM   2112  CZ  ARG   259       7.722  28.453  -2.070  1.00 23.40      A   
ATOM   2113  NH1 ARG   259       7.900  29.689  -2.512  1.00 23.67      A   
ATOM   2114  NH2 ARG   259       6.945  28.232  -1.015  1.00 24.65      A   
ATOM   2115  C   ARG   259      12.850  26.806  -1.681  1.00 15.39      A   
ATOM   2116  O   ARG   259      13.640  25.905  -1.382  1.00 13.97      A   
ATOM   2117  N   PRO   260      12.569  27.816  -0.845  1.00 15.33      A   
ATOM   2118  CD  PRO   260      11.901  29.085  -1.191  1.00 15.24      A   
ATOM   2119  CA  PRO   260      13.174  27.891   0.488  1.00 15.06      A   
ATOM   2120  CB  PRO   260      13.173  29.386   0.775  1.00 16.15      A   
ATOM   2121  CG  PRO   260      11.865  29.817   0.150  1.00 15.46      A   
ATOM   2122  C   PRO   260      12.377  27.111   1.533  1.00 15.30      A   
ATOM   2123  O   PRO   260      11.289  26.599   1.249  1.00 15.49      A   
ATOM   2124  N   PHE   261      12.933  27.012   2.736  1.00 13.62      A   
ATOM   2125  CA  PHE   261      12.267  26.325   3.833  1.00 13.61      A   
ATOM   2126  CB  PHE   261      13.271  25.949   4.929  1.00 13.58      A   
ATOM   2127  CG  PHE   261      12.628  25.384   6.166  1.00 13.73      A   
ATOM   2128  CD1 PHE   261      12.049  24.118   6.151  1.00 14.10      A   
ATOM   2129  CD2 PHE   261      12.579  26.126   7.339  1.00 13.63      A   
ATOM   2130  CE1 PHE   261      11.427  23.598   7.290  1.00 13.81      A   
ATOM   2131  CE2 PHE   261      11.961  25.620   8.483  1.00 14.50      A   
ATOM   2132  CZ  PHE   261      11.384  24.352   8.456  1.00 14.34      A   
ATOM   2133  C   PHE   261      11.207  27.258   4.420  1.00 13.65      A   
ATOM   2134  O   PHE   261      10.080  26.840   4.681  1.00 13.03      A   
ATOM   2135  N   LEU   262      11.586  28.518   4.634  1.00 12.73      A   
ATOM   2136  CA  LEU   262      10.683  29.536   5.177  1.00 13.69      A   
ATOM   2137  CB  LEU   262      11.022  29.854   6.639  1.00 12.72      A   
ATOM   2138  CG  LEU   262      10.153  30.919   7.331  1.00 16.48      A   
ATOM   2139  CD1 LEU   262       8.728  30.402   7.463  1.00 18.63      A   
ATOM   2140  CD2 LEU   262      10.716  31.252   8.714  1.00 18.23      A   
ATOM   2141  C   LEU   262      10.816  30.804   4.348  1.00 13.40      A   
ATOM   2142  O   LEU   262      11.884  31.415   4.301  1.00 13.94      A   
ATOM   2143  N   GLU   263       9.731  31.204   3.699  1.00 14.09      A   
ATOM   2144  CA  GLU   263       9.749  32.401   2.866  1.00 15.18      A   
ATOM   2145  CB  GLU   263       8.431  32.532   2.097  1.00 17.34      A   
ATOM   2146  CG  GLU   263       8.105  31.376   1.169  1.00 22.50      A   
ATOM   2147  CD  GLU   263       6.829  31.615   0.380  1.00 24.06      A   
ATOM   2148  OE1 GLU   263       6.476  30.760  -0.459  1.00 27.05      A   
ATOM   2149  OE2 GLU   263       6.184  32.662   0.603  1.00 24.08      A   
ATOM   2150  C   GLU   263       9.986  33.703   3.627  1.00 14.33      A   
ATOM   2151  O   GLU   263       9.615  33.846   4.793  1.00 15.74      A   
ATOM   2152  N   PHE   264      10.612  34.642   2.927  1.00 15.58      A   
ATOM   2153  CA  PHE   264      10.905  35.987   3.413  1.00 16.12      A   
ATOM   2154  CB  PHE   264      11.599  36.761   2.288  1.00 15.74      A   
ATOM   2155  CG  PHE   264      11.800  38.222   2.570  1.00 17.92      A   
ATOM   2156  CD1 PHE   264      12.635  38.630   3.602  1.00 16.53      A   
ATOM   2157  CD2 PHE   264      11.190  39.195   1.774  1.00 18.71      A   
ATOM   2158  CE1 PHE   264      12.869  39.978   3.839  1.00 19.46      A   
ATOM   2159  CE2 PHE   264      11.419  40.551   2.005  1.00 18.87      A   
ATOM   2160  CZ  PHE   264      12.262  40.942   3.041  1.00 21.10      A   
ATOM   2161  C   PHE   264       9.545  36.611   3.706  1.00 15.21      A   
ATOM   2162  O   PHE   264       8.591  36.346   2.983  1.00 14.72      A   
ATOM   2163  N   ARG   265       9.443  37.426   4.754  1.00 17.37      A   
ATOM   2164  CA  ARG   265       8.167  38.068   5.098  1.00 17.19      A   
ATOM   2165  CB  ARG   265       7.529  37.373   6.308  1.00 20.52      A   
ATOM   2166  CG  ARG   265       8.324  37.496   7.611  1.00 22.71      A   
ATOM   2167  CD  ARG   265       7.649  36.751   8.760  1.00 25.80      A   
ATOM   2168  NE  ARG   265       7.488  35.331   8.453  1.00 28.99      A   
ATOM   2169  CZ  ARG   265       6.945  34.434   9.272  1.00 30.30      A   
ATOM   2170  NH1 ARG   265       6.500  34.799  10.465  1.00 31.04      A   
ATOM   2171  NH2 ARG   265       6.842  33.166   8.893  1.00 31.36      A   
ATOM   2172  C   ARG   265       8.346  39.561   5.396  1.00 17.36      A   
ATOM   2173  O   ARG   265       7.669  40.120   6.258  1.00 16.67      A   
ATOM   2174  N   ASP   266       9.259  40.196   4.670  1.00 16.99      A   
ATOM   2175  CA  ASP   266       9.550  41.615   4.835  1.00 18.14      A   
ATOM   2176  CB  ASP   266       8.343  42.475   4.440  1.00 21.40      A   
ATOM   2177  CG  ASP   266       8.114  42.493   2.942  1.00 25.91      A   
ATOM   2178  OD1 ASP   266       7.318  41.668   2.450  1.00 28.15      A   
ATOM   2179  OD2 ASP   266       8.751  43.324   2.257  1.00 29.23      A   
ATOM   2180  C   ASP   266      10.028  42.001   6.225  1.00 17.65      A   
ATOM   2181  O   ASP   266       9.812  43.125   6.678  1.00 16.50      A   
ATOM   2182  N   THR   267      10.675  41.064   6.905  1.00 15.77      A   
ATOM   2183  CA  THR   267      11.222  41.344   8.220  1.00 14.27      A   
ATOM   2184  CB  THR   267      10.588  40.449   9.324  1.00 15.03      A   
ATOM   2185  OG1 THR   267      10.675  39.065   8.961  1.00 12.90      A   
ATOM   2186  CG2 THR   267       9.124  40.832   9.526  1.00 13.80      A   
ATOM   2187  C   THR   267      12.732  41.143   8.141  1.00 15.41      A   
ATOM   2188  O   THR   267      13.338  41.404   7.098  1.00 11.53      A   
ATOM   2189  N   LYS   268      13.343  40.671   9.221  1.00 14.73      A   
ATOM   2190  CA  LYS   268      14.784  40.489   9.227  1.00 13.26      A   
ATOM   2191  CB  LYS   268      15.445  41.711   9.877  1.00 12.84      A   
ATOM   2192  CG  LYS   268      15.160  43.035   9.174  1.00 13.86      A   
ATOM   2193  CD  LYS   268      15.898  43.129   7.846  1.00 12.87      A   
ATOM   2194  CE  LYS   268      15.708  44.492   7.185  1.00 15.19      A   
ATOM   2195  NZ  LYS   268      16.494  44.589   5.913  1.00 12.26      A   
ATOM   2196  C   LYS   268      15.257  39.218   9.926  1.00 14.13      A   
ATOM   2197  O   LYS   268      15.671  39.256  11.089  1.00 12.62      A   
ATOM   2198  N   TYR   269      15.189  38.095   9.217  1.00 12.02      A   
ATOM   2199  CA  TYR   269      15.655  36.825   9.764  1.00 13.31      A   
ATOM   2200  CB  TYR   269      15.497  35.710   8.728  1.00 12.36      A   
ATOM   2201  CG  TYR   269      14.058  35.391   8.384  1.00 10.66      A   
ATOM   2202  CD1 TYR   269      13.741  34.678   7.227  1.00 11.52      A   
ATOM   2203  CE1 TYR   269      12.419  34.385   6.899  1.00 11.76      A   
ATOM   2204  CD2 TYR   269      13.010  35.803   9.213  1.00 12.21      A   
ATOM   2205  CE2 TYR   269      11.684  35.515   8.897  1.00 13.15      A   
ATOM   2206  CZ  TYR   269      11.399  34.805   7.734  1.00 14.34      A   
ATOM   2207  OH  TYR   269      10.091  34.527   7.404  1.00 15.98      A   
ATOM   2208  C   TYR   269      17.125  37.077  10.069  1.00 12.71      A   
ATOM   2209  O   TYR   269      17.889  37.478   9.186  1.00 12.24      A   
ATOM   2210  N   TYR   270      17.507  36.834  11.321  1.00 12.76      A   
ATOM   2211  CA  TYR   270      18.860  37.102  11.795  1.00 12.12      A   
ATOM   2212  CB  TYR   270      18.799  38.278  12.772  1.00 13.61      A   
ATOM   2213  CG  TYR   270      20.140  38.863  13.125  1.00 15.07      A   
ATOM   2214  CD1 TYR   270      20.906  39.509  12.161  1.00 16.43      A   
ATOM   2215  CE1 TYR   270      22.147  40.050  12.475  1.00 16.41      A   
ATOM   2216  CD2 TYR   270      20.647  38.771  14.422  1.00 15.58      A   
ATOM   2217  CE2 TYR   270      21.891  39.310  14.746  1.00 14.27      A   
ATOM   2218  CZ  TYR   270      22.633  39.948  13.764  1.00 14.42      A   
ATOM   2219  OH  TYR   270      23.862  40.482  14.068  1.00 15.49      A   
ATOM   2220  C   TYR   270      19.612  35.939  12.461  1.00 13.08      A   
ATOM   2221  O   TYR   270      20.819  35.793  12.272  1.00 11.94      A   
ATOM   2222  N   GLY   271      18.904  35.145  13.261  1.00 10.96      A   
ATOM   2223  CA  GLY   271      19.517  34.017  13.944  1.00 10.41      A   
ATOM   2224  C   GLY   271      18.847  32.723  13.526  1.00  8.12      A   
ATOM   2225  O   GLY   271      17.711  32.741  13.058  1.00  8.52      A   
ATOM   2226  N   LEU   272      19.513  31.590  13.710  1.00  6.99      A   
ATOM   2227  CA  LEU   272      18.926  30.324  13.278  1.00  8.20      A   
ATOM   2228  CB  LEU   272      19.189  30.139  11.771  1.00  8.98      A   
ATOM   2229  CG  LEU   272      18.730  28.876  11.026  1.00 10.40      A   
ATOM   2230  CD1 LEU   272      17.225  28.888  10.906  1.00  9.26      A   
ATOM   2231  CD2 LEU   272      19.359  28.840   9.625  1.00 11.43      A   
ATOM   2232  C   LEU   272      19.489  29.129  14.026  1.00  8.09      A   
ATOM   2233  O   LEU   272      20.651  29.131  14.446  1.00  8.76      A   
ATOM   2234  N   THR   273      18.661  28.110  14.206  1.00  8.92      A   
ATOM   2235  CA  THR   273      19.121  26.885  14.847  1.00  8.40      A   
ATOM   2236  CB  THR   273      19.330  27.029  16.377  1.00 10.12      A   
ATOM   2237  OG1 THR   273      20.010  25.865  16.877  1.00  9.16      A   
ATOM   2238  CG2 THR   273      17.997  27.155  17.105  1.00  8.04      A   
ATOM   2239  C   THR   273      18.140  25.766  14.586  1.00  9.37      A   
ATOM   2240  O   THR   273      16.981  25.999  14.235  1.00  7.16      A   
ATOM   2241  N   VAL   274      18.632  24.545  14.738  1.00  8.45      A   
ATOM   2242  CA  VAL   274      17.828  23.357  14.533  1.00  9.39      A   
ATOM   2243  CB  VAL   274      18.319  22.559  13.301  1.00  9.13      A   
ATOM   2244  CG1 VAL   274      17.445  21.339  13.097  1.00  8.89      A   
ATOM   2245  CG2 VAL   274      18.289  23.449  12.055  1.00 10.57      A   
ATOM   2246  C   VAL   274      17.942  22.479  15.767  1.00 10.50      A   
ATOM   2247  O   VAL   274      19.040  22.237  16.271  1.00 10.36      A   
ATOM   2248  N   ASN   275      16.801  22.026  16.270  1.00 10.10      A   
ATOM   2249  CA  ASN   275      16.790  21.148  17.430  1.00 10.66      A   
ATOM   2250  CB  ASN   275      15.348  20.882  17.863  1.00 11.25      A   
ATOM   2251  CG  ASN   275      15.261  20.004  19.092  1.00 11.37      A   
ATOM   2252  OD1 ASN   275      15.781  18.890  19.106  1.00 14.84      A   
ATOM   2253  ND2 ASN   275      14.596  20.498  20.130  1.00 13.31      A   
ATOM   2254  C   ASN   275      17.469  19.847  16.983  1.00 11.18      A   
ATOM   2255  O   ASN   275      17.005  19.184  16.056  1.00 13.68      A   
ATOM   2256  N   PRO   276      18.576  19.467  17.639  1.00 13.62      A   
ATOM   2257  CD  PRO   276      19.200  20.178  18.769  1.00 12.90      A   
ATOM   2258  CA  PRO   276      19.330  18.252  17.308  1.00 14.34      A   
ATOM   2259  CB  PRO   276      20.596  18.396  18.151  1.00 14.55      A   
ATOM   2260  CG  PRO   276      20.119  19.126  19.345  1.00 16.92      A   
ATOM   2261  C   PRO   276      18.615  16.928  17.545  1.00 16.17      A   
ATOM   2262  O   PRO   276      19.055  15.891  17.054  1.00 16.21      A   
ATOM   2263  N   ASN   277      17.508  16.960  18.278  1.00 17.43      A   
ATOM   2264  CA  ASN   277      16.774  15.736  18.553  1.00 18.03      A   
ATOM   2265  CB  ASN   277      16.359  15.686  20.022  1.00 20.28      A   
ATOM   2266  CG  ASN   277      17.546  15.637  20.953  1.00 21.95      A   
ATOM   2267  OD1 ASN   277      18.515  14.917  20.703  1.00 24.45      A   
ATOM   2268  ND2 ASN   277      17.478  16.392  22.039  1.00 23.86      A   
ATOM   2269  C   ASN   277      15.549  15.514  17.676  1.00 18.53      A   
ATOM   2270  O   ASN   277      15.327  14.403  17.203  1.00 20.17      A   
ATOM   2271  N   ASN   278      14.760  16.559  17.446  1.00 17.10      A   
ATOM   2272  CA  ASN   278      13.554  16.408  16.642  1.00 16.09      A   
ATOM   2273  CB  ASN   278      12.331  16.818  17.462  1.00 17.08      A   
ATOM   2274  CG  ASN   278      12.453  18.214  18.012  1.00 15.31      A   
ATOM   2275  OD1 ASN   278      12.937  19.113  17.331  1.00 14.46      A   
ATOM   2276  ND2 ASN   278      12.011  18.408  19.250  1.00 16.09      A   
ATOM   2277  C   ASN   278      13.550  17.161  15.316  1.00 14.40      A   
ATOM   2278  O   ASN   278      12.586  17.074  14.563  1.00 13.05      A   
ATOM   2279  N   GLY   279      14.613  17.909  15.035  1.00 14.58      A   
ATOM   2280  CA  GLY   279      14.689  18.630  13.774  1.00 12.81      A   
ATOM   2281  C   GLY   279      13.896  19.920  13.660  1.00 12.95      A   
ATOM   2282  O   GLY   279      13.887  20.553  12.601  1.00 12.08      A   
ATOM   2283  N   GLU   280      13.221  20.316  14.732  1.00 11.27      A   
ATOM   2284  CA  GLU   280      12.457  21.548  14.692  1.00 12.10      A   
ATOM   2285  CB  GLU   280      11.674  21.719  15.994  1.00 13.01      A   
ATOM   2286  CG  GLU   280      10.461  20.796  16.028  1.00 13.70      A   
ATOM   2287  CD  GLU   280       9.748  20.788  17.359  1.00 14.90      A   
ATOM   2288  OE1 GLU   280       9.949  21.731  18.148  1.00 16.46      A   
ATOM   2289  OE2 GLU   280       8.973  19.839  17.608  1.00 16.12      A   
ATOM   2290  C   GLU   280      13.405  22.711  14.439  1.00 12.98      A   
ATOM   2291  O   GLU   280      14.514  22.759  14.980  1.00 12.25      A   
ATOM   2292  N   VAL   281      12.964  23.632  13.591  1.00 10.96      A   
ATOM   2293  CA  VAL   281      13.761  24.784  13.206  1.00 11.09      A   
ATOM   2294  CB  VAL   281      13.707  24.987  11.668  1.00  9.04      A   
ATOM   2295  CG1 VAL   281      14.606  26.147  11.250  1.00  8.18      A   
ATOM   2296  CG2 VAL   281      14.121  23.700  10.958  1.00  8.08      A   
ATOM   2297  C   VAL   281      13.297  26.065  13.884  1.00 11.49      A   
ATOM   2298  O   VAL   281      12.115  26.417  13.832  1.00 15.14      A   
ATOM   2299  N   TYR   282      14.236  26.757  14.520  1.00 11.37      A   
ATOM   2300  CA  TYR   282      13.938  28.016  15.195  1.00 10.33      A   
ATOM   2301  CB  TYR   282      14.455  27.998  16.637  1.00 10.47      A   
ATOM   2302  CG  TYR   282      13.688  27.091  17.574  1.00 10.17      A   
ATOM   2303  CD1 TYR   282      13.754  25.705  17.453  1.00 11.31      A   
ATOM   2304  CE1 TYR   282      13.055  24.873  18.328  1.00 10.23      A   
ATOM   2305  CD2 TYR   282      12.901  27.625  18.592  1.00 11.82      A   
ATOM   2306  CE2 TYR   282      12.200  26.804  19.470  1.00 12.29      A   
ATOM   2307  CZ  TYR   282      12.284  25.427  19.331  1.00 11.88      A   
ATOM   2308  OH  TYR   282      11.597  24.614  20.203  1.00 13.37      A   
ATOM   2309  C   TYR   282      14.597  29.156  14.429  1.00  9.68      A   
ATOM   2310  O   TYR   282      15.792  29.115  14.136  1.00 10.16      A   
ATOM   2311  N   VAL   283      13.804  30.167  14.101  1.00  9.34      A   
ATOM   2312  CA  VAL   283      14.279  31.331  13.363  1.00  8.38      A   
ATOM   2313  CB  VAL   283      13.455  31.529  12.070  1.00  9.46      A   
ATOM   2314  CG1 VAL   283      13.879  32.815  11.363  1.00  9.34      A   
ATOM   2315  CG2 VAL   283      13.634  30.323  11.154  1.00 10.07      A   
ATOM   2316  C   VAL   283      14.135  32.576  14.226  1.00  8.82      A   
ATOM   2317  O   VAL   283      13.041  32.873  14.704  1.00  9.56      A   
ATOM   2318  N   ALA   284      15.240  33.288  14.436  1.00  8.79      A   
ATOM   2319  CA  ALA   284      15.223  34.515  15.226  1.00 10.34      A   
ATOM   2320  CB  ALA   284      16.509  34.652  16.025  1.00  9.10      A   
ATOM   2321  C   ALA   284      15.072  35.684  14.262  1.00 10.88      A   
ATOM   2322  O   ALA   284      15.932  35.932  13.412  1.00 13.09      A   
ATOM   2323  N   ASP   285      13.958  36.389  14.402  1.00 11.95      A   
ATOM   2324  CA  ASP   285      13.625  37.517  13.545  1.00 12.00      A   
ATOM   2325  CB  ASP   285      12.145  37.409  13.156  1.00 10.49      A   
ATOM   2326  CG  ASP   285      11.759  38.339  12.023  1.00 10.67      A   
ATOM   2327  OD1 ASP   285      12.530  39.276  11.722  1.00 10.38      A   
ATOM   2328  OD2 ASP   285      10.672  38.135  11.449  1.00  9.49      A   
ATOM   2329  C   ASP   285      13.889  38.832  14.277  1.00 11.89      A   
ATOM   2330  O   ASP   285      13.262  39.119  15.298  1.00 11.21      A   
ATOM   2331  N   ALA   286      14.833  39.613  13.757  1.00 12.08      A   
ATOM   2332  CA  ALA   286      15.185  40.903  14.342  1.00 13.65      A   
ATOM   2333  CB  ALA   286      16.560  41.347  13.838  1.00 13.50      A   
ATOM   2334  C   ALA   286      14.135  41.970  14.013  1.00 15.33      A   
ATOM   2335  O   ALA   286      14.170  43.077  14.554  1.00 14.03      A   
ATOM   2336  N   ILE   287      13.203  41.622  13.128  1.00 15.30      A   
ATOM   2337  CA  ILE   287      12.126  42.516  12.704  1.00 17.27      A   
ATOM   2338  CB  ILE   287      11.258  42.980  13.897  1.00 18.61      A   
ATOM   2339  CG2 ILE   287      10.078  43.801  13.386  1.00 20.23      A   
ATOM   2340  CG1 ILE   287      10.756  41.773  14.694  1.00 21.91      A   
ATOM   2341  CD1 ILE   287       9.893  40.814  13.908  1.00 22.98      A   
ATOM   2342  C   ILE   287      12.631  43.762  11.982  1.00 16.62      A   
ATOM   2343  O   ILE   287      12.503  43.874  10.764  1.00 17.12      A   
ATOM   2344  N   ASP   288      13.186  44.706  12.738  1.00 15.74      A   
ATOM   2345  CA  ASP   288      13.710  45.940  12.158  1.00 15.72      A   
ATOM   2346  CB  ASP   288      12.621  47.020  12.152  1.00 15.19      A   
ATOM   2347  CG  ASP   288      12.150  47.391  13.547  1.00 18.19      A   
ATOM   2348  OD1 ASP   288      12.577  46.746  14.529  1.00 17.91      A   
ATOM   2349  OD2 ASP   288      11.337  48.333  13.663  1.00 17.70      A   
ATOM   2350  C   ASP   288      14.937  46.434  12.921  1.00 16.37      A   
ATOM   2351  O   ASP   288      15.347  47.588  12.780  1.00 15.78      A   
ATOM   2352  N   TYR   289      15.516  45.542  13.722  1.00 16.49      A   
ATOM   2353  CA  TYR   289      16.695  45.836  14.535  1.00 18.27      A   
ATOM   2354  CB  TYR   289      17.856  46.312  13.659  1.00 18.61      A   
ATOM   2355  CG  TYR   289      18.198  45.384  12.519  1.00 21.28      A   
ATOM   2356  CD1 TYR   289      17.997  45.779  11.197  1.00 22.75      A   
ATOM   2357  CE1 TYR   289      18.327  44.945  10.139  1.00 22.84      A   
ATOM   2358  CD2 TYR   289      18.739  44.119  12.755  1.00 21.23      A   
ATOM   2359  CE2 TYR   289      19.073  43.273  11.700  1.00 21.63      A   
ATOM   2360  CZ  TYR   289      18.865  43.698  10.396  1.00 23.21      A   
ATOM   2361  OH  TYR   289      19.213  42.888   9.346  1.00 22.93      A   
ATOM   2362  C   TYR   289      16.422  46.887  15.605  1.00 18.91      A   
ATOM   2363  O   TYR   289      17.351  47.387  16.238  1.00 17.41      A   
ATOM   2364  N   GLN   290      15.152  47.223  15.808  1.00 19.91      A   
ATOM   2365  CA  GLN   290      14.794  48.226  16.803  1.00 21.33      A   
ATOM   2366  CB  GLN   290      14.140  49.425  16.121  1.00 23.67      A   
ATOM   2367  CG  GLN   290      15.088  50.200  15.232  1.00 27.49      A   
ATOM   2368  CD  GLN   290      14.387  51.251  14.399  1.00 29.89      A   
ATOM   2369  OE1 GLN   290      15.035  52.063  13.748  1.00 32.54      A   
ATOM   2370  NE2 GLN   290      13.057  51.237  14.409  1.00 33.40      A   
ATOM   2371  C   GLN   290      13.870  47.694  17.886  1.00 20.72      A   
ATOM   2372  O   GLN   290      14.225  47.683  19.063  1.00 21.55      A   
ATOM   2373  N   GLN   291      12.684  47.258  17.484  1.00 20.42      A   
ATOM   2374  CA  GLN   291      11.712  46.741  18.431  1.00 19.78      A   
ATOM   2375  CB  GLN   291      10.329  46.673  17.773  1.00 22.01      A   
ATOM   2376  CG  GLN   291      10.277  45.904  16.461  1.00 23.93      A   
ATOM   2377  CD  GLN   291       8.948  46.073  15.729  1.00 25.68      A   
ATOM   2378  OE1 GLN   291       7.901  45.639  16.205  1.00 25.83      A   
ATOM   2379  NE2 GLN   291       8.992  46.713  14.567  1.00 26.38      A   
ATOM   2380  C   GLN   291      12.104  45.376  18.978  1.00 18.33      A   
ATOM   2381  O   GLN   291      13.112  44.795  18.574  1.00 17.95      A   
ATOM   2382  N   GLN   292      11.314  44.882  19.921  1.00 16.44      A   
ATOM   2383  CA  GLN   292      11.562  43.581  20.523  1.00 15.92      A   
ATOM   2384  CB  GLN   292      10.503  43.311  21.590  1.00 16.53      A   
ATOM   2385  CG  GLN   292      10.545  41.926  22.206  1.00 15.71      A   
ATOM   2386  CD  GLN   292       9.504  41.767  23.293  1.00 17.54      A   
ATOM   2387  OE1 GLN   292       8.438  42.381  23.234  1.00 18.37      A   
ATOM   2388  NE2 GLN   292       9.799  40.936  24.288  1.00 18.00      A   
ATOM   2389  C   GLN   292      11.512  42.514  19.433  1.00 14.30      A   
ATOM   2390  O   GLN   292      10.600  42.508  18.605  1.00 12.89      A   
ATOM   2391  N   GLY   293      12.496  41.617  19.436  1.00 13.88      A   
ATOM   2392  CA  GLY   293      12.553  40.563  18.434  1.00 13.12      A   
ATOM   2393  C   GLY   293      11.633  39.392  18.714  1.00 12.95      A   
ATOM   2394  O   GLY   293      11.108  39.250  19.816  1.00 11.72      A   
ATOM   2395  N   ILE   294      11.441  38.535  17.719  1.00 11.48      A   
ATOM   2396  CA  ILE   294      10.566  37.385  17.893  1.00 13.98      A   
ATOM   2397  CB  ILE   294       9.207  37.632  17.192  1.00 16.23      A   
ATOM   2398  CG2 ILE   294       9.438  37.890  15.713  1.00 17.07      A   
ATOM   2399  CG1 ILE   294       8.272  36.441  17.406  1.00 17.04      A   
ATOM   2400  CD1 ILE   294       6.869  36.657  16.861  1.00 19.69      A   
ATOM   2401  C   ILE   294      11.208  36.122  17.333  1.00 13.31      A   
ATOM   2402  O   ILE   294      11.977  36.176  16.373  1.00 12.51      A   
ATOM   2403  N   VAL   295      10.897  34.987  17.947  1.00 12.46      A   
ATOM   2404  CA  VAL   295      11.432  33.715  17.490  1.00 11.51      A   
ATOM   2405  CB  VAL   295      12.232  33.003  18.603  1.00  9.40      A   
ATOM   2406  CG1 VAL   295      12.681  31.625  18.128  1.00  7.88      A   
ATOM   2407  CG2 VAL   295      13.449  33.841  18.977  1.00  5.26      A   
ATOM   2408  C   VAL   295      10.298  32.811  17.024  1.00 13.04      A   
ATOM   2409  O   VAL   295       9.285  32.647  17.711  1.00 12.55      A   
ATOM   2410  N   TYR   296      10.490  32.239  15.841  1.00 12.77      A   
ATOM   2411  CA  TYR   296       9.527  31.340  15.223  1.00 14.21      A   
ATOM   2412  CB  TYR   296       9.351  31.707  13.746  1.00 17.40      A   
ATOM   2413  CG  TYR   296       8.763  33.082  13.538  1.00 19.23      A   
ATOM   2414  CD1 TYR   296       7.482  33.378  13.995  1.00 22.70      A   
ATOM   2415  CE1 TYR   296       6.930  34.639  13.825  1.00 23.89      A   
ATOM   2416  CD2 TYR   296       9.485  34.090  12.898  1.00 22.45      A   
ATOM   2417  CE2 TYR   296       8.939  35.365  12.722  1.00 25.05      A   
ATOM   2418  CZ  TYR   296       7.659  35.626  13.191  1.00 24.81      A   
ATOM   2419  OH  TYR   296       7.095  36.872  13.033  1.00 29.94      A   
ATOM   2420  C   TYR   296      10.008  29.899  15.337  1.00 13.78      A   
ATOM   2421  O   TYR   296      11.168  29.600  15.060  1.00 12.82      A   
ATOM   2422  N   ARG   297       9.108  29.014  15.751  1.00 11.63      A   
ATOM   2423  CA  ARG   297       9.415  27.597  15.904  1.00 11.68      A   
ATOM   2424  CB  ARG   297       9.074  27.142  17.321  1.00  9.65      A   
ATOM   2425  CG  ARG   297       9.151  25.649  17.541  1.00 10.30      A   
ATOM   2426  CD  ARG   297       8.656  25.309  18.929  1.00 11.03      A   
ATOM   2427  NE  ARG   297       8.749  23.883  19.223  1.00 13.89      A   
ATOM   2428  CZ  ARG   297       8.354  23.339  20.368  1.00 15.05      A   
ATOM   2429  NH1 ARG   297       7.842  24.109  21.317  1.00 14.76      A   
ATOM   2430  NH2 ARG   297       8.468  22.033  20.564  1.00 12.30      A   
ATOM   2431  C   ARG   297       8.610  26.788  14.892  1.00 12.96      A   
ATOM   2432  O   ARG   297       7.378  26.752  14.947  1.00 11.75      A   
ATOM   2433  N   TYR   298       9.316  26.136  13.974  1.00 13.31      A   
ATOM   2434  CA  TYR   298       8.690  25.345  12.919  1.00 14.68      A   
ATOM   2435  CB  TYR   298       9.110  25.905  11.551  1.00 17.18      A   
ATOM   2436  CG  TYR   298       8.438  27.213  11.174  1.00 20.26      A   
ATOM   2437  CD1 TYR   298       7.215  27.220  10.508  1.00 20.87      A   
ATOM   2438  CE1 TYR   298       6.578  28.414  10.174  1.00 23.21      A   
ATOM   2439  CD2 TYR   298       9.015  28.442  11.500  1.00 22.43      A   
ATOM   2440  CE2 TYR   298       8.383  29.647  11.170  1.00 23.70      A   
ATOM   2441  CZ  TYR   298       7.165  29.622  10.509  1.00 24.59      A   
ATOM   2442  OH  TYR   298       6.525  30.802  10.189  1.00 28.94      A   
ATOM   2443  C   TYR   298       9.056  23.865  12.994  1.00 14.24      A   
ATOM   2444  O   TYR   298      10.128  23.505  13.474  1.00 12.09      A   
ATOM   2445  N   SER   299       8.154  23.007  12.531  1.00 13.27      A   
ATOM   2446  CA  SER   299       8.432  21.582  12.519  1.00 15.01      A   
ATOM   2447  CB  SER   299       7.148  20.779  12.339  1.00 16.71      A   
ATOM   2448  OG  SER   299       6.662  20.936  11.016  1.00 19.31      A   
ATOM   2449  C   SER   299       9.333  21.348  11.308  1.00 15.49      A   
ATOM   2450  O   SER   299       9.477  22.222  10.454  1.00 13.14      A   
ATOM   2451  N   PRO   300       9.957  20.165  11.224  1.00 16.43      A   
ATOM   2452  CD  PRO   300       9.944  19.108  12.248  1.00 17.84      A   
ATOM   2453  CA  PRO   300      10.844  19.812  10.111  1.00 17.17      A   
ATOM   2454  CB  PRO   300      11.246  18.380  10.436  1.00 18.58      A   
ATOM   2455  CG  PRO   300      11.200  18.346  11.937  1.00 19.77      A   
ATOM   2456  C   PRO   300      10.111  19.911   8.770  1.00 18.44      A   
ATOM   2457  O   PRO   300      10.729  20.122   7.727  1.00 16.17      A   
ATOM   2458  N   GLN   301       8.790  19.749   8.807  1.00 19.80      A   
ATOM   2459  CA  GLN   301       7.971  19.820   7.601  1.00 21.22      A   
ATOM   2460  CB  GLN   301       6.681  19.012   7.786  1.00 24.88      A   
ATOM   2461  CG  GLN   301       6.888  17.526   8.110  1.00 28.93      A   
ATOM   2462  CD  GLN   301       7.454  17.286   9.506  1.00 31.88      A   
ATOM   2463  OE1 GLN   301       6.916  17.773  10.499  1.00 34.23      A   
ATOM   2464  NE2 GLN   301       8.537  16.524   9.583  1.00 32.28      A   
ATOM   2465  C   GLN   301       7.627  21.270   7.265  1.00 20.90      A   
ATOM   2466  O   GLN   301       7.016  21.559   6.232  1.00 20.08      A   
ATOM   2467  N   GLY   302       8.015  22.185   8.144  1.00 18.42      A   
ATOM   2468  CA  GLY   302       7.745  23.592   7.903  1.00 18.79      A   
ATOM   2469  C   GLY   302       6.422  24.106   8.443  1.00 18.89      A   
ATOM   2470  O   GLY   302       5.905  25.114   7.959  1.00 19.49      A   
ATOM   2471  N   LYS   303       5.866  23.424   9.438  1.00 19.16      A   
ATOM   2472  CA  LYS   303       4.606  23.860  10.032  1.00 19.03      A   
ATOM   2473  CB  LYS   303       3.760  22.656  10.456  1.00 22.53      A   
ATOM   2474  CG  LYS   303       2.409  23.040  11.048  1.00 26.13      A   
ATOM   2475  CD  LYS   303       1.489  21.835  11.244  1.00 30.04      A   
ATOM   2476  CE  LYS   303       1.821  21.037  12.503  1.00 32.73      A   
ATOM   2477  NZ  LYS   303       3.176  20.405  12.501  1.00 37.31      A   
ATOM   2478  C   LYS   303       4.887  24.729  11.250  1.00 18.59      A   
ATOM   2479  O   LYS   303       5.709  24.370  12.095  1.00 15.87      A   
ATOM   2480  N   LEU   304       4.208  25.869  11.341  1.00 16.96      A   
ATOM   2481  CA  LEU   304       4.401  26.771  12.472  1.00 17.76      A   
ATOM   2482  CB  LEU   304       3.664  28.102  12.240  1.00 17.50      A   
ATOM   2483  CG  LEU   304       3.680  29.096  13.405  1.00 17.05      A   
ATOM   2484  CD1 LEU   304       5.114  29.527  13.698  1.00 16.75      A   
ATOM   2485  CD2 LEU   304       2.818  30.307  13.068  1.00 19.24      A   
ATOM   2486  C   LEU   304       3.888  26.119  13.747  1.00 16.91      A   
ATOM   2487  O   LEU   304       2.708  25.767  13.848  1.00 17.08      A   
ATOM   2488  N   ILE   305       4.785  25.950  14.715  1.00 15.52      A   
ATOM   2489  CA  ILE   305       4.445  25.340  16.001  1.00 14.62      A   
ATOM   2490  CB  ILE   305       5.576  24.396  16.493  1.00 14.00      A   
ATOM   2491  CG2 ILE   305       5.263  23.889  17.888  1.00 14.93      A   
ATOM   2492  CG1 ILE   305       5.729  23.215  15.532  1.00 15.23      A   
ATOM   2493  CD1 ILE   305       6.975  22.369  15.804  1.00 15.63      A   
ATOM   2494  C   ILE   305       4.205  26.389  17.085  1.00 15.44      A   
ATOM   2495  O   ILE   305       3.272  26.273  17.876  1.00 12.65      A   
ATOM   2496  N   ASP   306       5.046  27.417  17.125  1.00 14.79      A   
ATOM   2497  CA  ASP   306       4.894  28.449  18.144  1.00 14.52      A   
ATOM   2498  CB  ASP   306       5.277  27.859  19.517  1.00 15.37      A   
ATOM   2499  CG  ASP   306       5.030  28.814  20.681  1.00 17.21      A   
ATOM   2500  OD1 ASP   306       3.991  29.509  20.697  1.00 17.67      A   
ATOM   2501  OD2 ASP   306       5.878  28.853  21.601  1.00 16.12      A   
ATOM   2502  C   ASP   306       5.772  29.637  17.795  1.00 13.97      A   
ATOM   2503  O   ASP   306       6.622  29.564  16.905  1.00 12.36      A   
ATOM   2504  N   GLU   307       5.540  30.744  18.483  1.00 15.42      A   
ATOM   2505  CA  GLU   307       6.326  31.947  18.285  1.00 16.36      A   
ATOM   2506  CB  GLU   307       5.726  32.820  17.176  1.00 19.66      A   
ATOM   2507  CG  GLU   307       4.298  33.278  17.391  1.00 24.34      A   
ATOM   2508  CD  GLU   307       3.792  34.118  16.236  1.00 28.08      A   
ATOM   2509  OE1 GLU   307       3.732  33.599  15.099  1.00 31.59      A   
ATOM   2510  OE2 GLU   307       3.457  35.300  16.455  1.00 30.79      A   
ATOM   2511  C   GLU   307       6.330  32.665  19.622  1.00 16.97      A   
ATOM   2512  O   GLU   307       5.361  32.588  20.378  1.00 14.86      A   
ATOM   2513  N   PHE   308       7.430  33.337  19.931  1.00 14.72      A   
ATOM   2514  CA  PHE   308       7.535  34.034  21.203  1.00 14.42      A   
ATOM   2515  CB  PHE   308       7.966  33.045  22.291  1.00 14.72      A   
ATOM   2516  CG  PHE   308       9.207  32.267  21.949  1.00 13.94      A   
ATOM   2517  CD1 PHE   308      10.458  32.693  22.388  1.00 13.98      A   
ATOM   2518  CD2 PHE   308       9.125  31.108  21.188  1.00 12.57      A   
ATOM   2519  CE1 PHE   308      11.618  31.968  22.080  1.00 12.62      A   
ATOM   2520  CE2 PHE   308      10.276  30.373  20.870  1.00 14.70      A   
ATOM   2521  CZ  PHE   308      11.525  30.808  21.321  1.00 13.10      A   
ATOM   2522  C   PHE   308       8.499  35.202  21.131  1.00 14.54      A   
ATOM   2523  O   PHE   308       9.526  35.137  20.452  1.00 13.43      A   
ATOM   2524  N   TYR   309       8.154  36.280  21.825  1.00 13.35      A   
ATOM   2525  CA  TYR   309       8.992  37.469  21.835  1.00 14.17      A   
ATOM   2526  CB  TYR   309       8.154  38.701  22.193  1.00 16.29      A   
ATOM   2527  CG  TYR   309       7.235  39.140  21.073  1.00 21.44      A   
ATOM   2528  CD1 TYR   309       6.063  38.439  20.782  1.00 23.56      A   
ATOM   2529  CE1 TYR   309       5.237  38.821  19.720  1.00 26.52      A   
ATOM   2530  CD2 TYR   309       7.560  40.236  20.276  1.00 23.43      A   
ATOM   2531  CE2 TYR   309       6.747  40.627  19.214  1.00 27.52      A   
ATOM   2532  CZ  TYR   309       5.589  39.917  18.940  1.00 28.74      A   
ATOM   2533  OH  TYR   309       4.787  40.301  17.885  1.00 29.35      A   
ATOM   2534  C   TYR   309      10.167  37.320  22.796  1.00 12.16      A   
ATOM   2535  O   TYR   309      10.020  36.831  23.914  1.00 13.36      A   
ATOM   2536  N   VAL   310      11.339  37.741  22.345  1.00 12.64      A   
ATOM   2537  CA  VAL   310      12.533  37.634  23.161  1.00 12.60      A   
ATOM   2538  CB  VAL   310      13.577  36.748  22.448  1.00 12.20      A   
ATOM   2539  CG1 VAL   310      13.059  35.321  22.386  1.00 10.63      A   
ATOM   2540  CG2 VAL   310      13.827  37.256  21.027  1.00 10.69      A   
ATOM   2541  C   VAL   310      13.096  39.015  23.479  1.00 12.59      A   
ATOM   2542  O   VAL   310      12.386  39.869  24.012  1.00 11.71      A   
ATOM   2543  N   GLY   311      14.367  39.232  23.163  1.00 12.07      A   
ATOM   2544  CA  GLY   311      14.975  40.523  23.409  1.00 11.25      A   
ATOM   2545  C   GLY   311      15.180  41.272  22.108  1.00 12.55      A   
ATOM   2546  O   GLY   311      14.559  40.953  21.092  1.00 13.64      A   
ATOM   2547  N   ILE   312      16.055  42.269  22.138  1.00 11.55      A   
ATOM   2548  CA  ILE   312      16.351  43.067  20.960  1.00 12.40      A   
ATOM   2549  CB  ILE   312      16.808  44.494  21.357  1.00 13.40      A   
ATOM   2550  CG2 ILE   312      17.228  45.282  20.114  1.00 12.68      A   
ATOM   2551  CG1 ILE   312      15.664  45.208  22.082  1.00 15.20      A   
ATOM   2552  CD1 ILE   312      16.038  46.550  22.682  1.00 16.56      A   
ATOM   2553  C   ILE   312      17.442  42.388  20.141  1.00 12.11      A   
ATOM   2554  O   ILE   312      18.497  42.020  20.661  1.00 10.40      A   
ATOM   2555  N   ILE   313      17.159  42.213  18.857  1.00 11.06      A   
ATOM   2556  CA  ILE   313      18.080  41.587  17.926  1.00 10.80      A   
ATOM   2557  CB  ILE   313      19.266  42.529  17.612  1.00 11.47      A   
ATOM   2558  CG2 ILE   313      20.167  41.915  16.539  1.00 12.68      A   
ATOM   2559  CG1 ILE   313      18.716  43.868  17.105  1.00 11.62      A   
ATOM   2560  CD1 ILE   313      19.770  44.868  16.681  1.00 11.86      A   
ATOM   2561  C   ILE   313      18.598  40.221  18.376  1.00 11.55      A   
ATOM   2562  O   ILE   313      19.790  40.045  18.640  1.00 10.01      A   
ATOM   2563  N   PRO   314      17.693  39.235  18.497  1.00 11.45      A   
ATOM   2564  CD  PRO   314      16.227  39.293  18.353  1.00 10.59      A   
ATOM   2565  CA  PRO   314      18.130  37.897  18.907  1.00 11.82      A   
ATOM   2566  CB  PRO   314      16.809  37.143  19.087  1.00 11.17      A   
ATOM   2567  CG  PRO   314      15.877  37.842  18.126  1.00 12.69      A   
ATOM   2568  C   PRO   314      18.963  37.364  17.743  1.00 13.30      A   
ATOM   2569  O   PRO   314      18.527  37.429  16.595  1.00 14.37      A   
ATOM   2570  N   GLY   315      20.158  36.853  18.019  1.00 13.44      A   
ATOM   2571  CA  GLY   315      20.983  36.375  16.926  1.00 13.14      A   
ATOM   2572  C   GLY   315      21.647  35.024  17.083  1.00 13.49      A   
ATOM   2573  O   GLY   315      22.233  34.518  16.127  1.00 13.60      A   
ATOM   2574  N   ALA   316      21.562  34.432  18.270  1.00 12.09      A   
ATOM   2575  CA  ALA   316      22.188  33.132  18.498  1.00 11.25      A   
ATOM   2576  CB  ALA   316      23.624  33.326  19.011  1.00 10.69      A   
ATOM   2577  C   ALA   316      21.405  32.243  19.460  1.00 10.41      A   
ATOM   2578  O   ALA   316      20.676  32.728  20.331  1.00  9.92      A   
ATOM   2579  N   PHE   317      21.568  30.934  19.301  1.00  8.72      A   
ATOM   2580  CA  PHE   317      20.877  29.977  20.153  1.00  9.02      A   
ATOM   2581  CB  PHE   317      19.885  29.132  19.335  1.00  5.53      A   
ATOM   2582  CG  PHE   317      18.796  29.924  18.652  1.00  6.35      A   
ATOM   2583  CD1 PHE   317      18.983  30.453  17.373  1.00  5.77      A   
ATOM   2584  CD2 PHE   317      17.567  30.110  19.278  1.00  7.15      A   
ATOM   2585  CE1 PHE   317      17.955  31.152  16.731  1.00  7.16      A   
ATOM   2586  CE2 PHE   317      16.535  30.806  18.650  1.00  5.61      A   
ATOM   2587  CZ  PHE   317      16.729  31.328  17.374  1.00  7.04      A   
ATOM   2588  C   PHE   317      21.856  29.022  20.828  1.00  8.91      A   
ATOM   2589  O   PHE   317      22.992  28.867  20.389  1.00 10.05      A   
ATOM   2590  N   CYS   318      21.411  28.389  21.906  1.00  8.36      A   
ATOM   2591  CA  CYS   318      22.225  27.391  22.595  1.00  9.05      A   
ATOM   2592  CB  CYS   318      23.178  28.006  23.633  1.00  9.10      A   
ATOM   2593  SG  CYS   318      24.307  26.763  24.357  1.00 10.84      A   
ATOM   2594  C   CYS   318      21.263  26.438  23.271  1.00  8.63      A   
ATOM   2595  O   CYS   318      20.458  26.830  24.118  1.00  8.49      A   
ATOM   2596  N   TRP   319      21.342  25.181  22.862  1.00  8.20      A   
ATOM   2597  CA  TRP   319      20.483  24.138  23.393  1.00  9.05      A   
ATOM   2598  CB  TRP   319      20.374  22.987  22.387  1.00  9.45      A   
ATOM   2599  CG  TRP   319      19.564  23.344  21.189  1.00  9.18      A   
ATOM   2600  CD2 TRP   319      18.138  23.432  21.125  1.00 10.88      A   
ATOM   2601  CE2 TRP   319      17.805  23.886  19.830  1.00  9.33      A   
ATOM   2602  CE3 TRP   319      17.107  23.180  22.043  1.00  8.99      A   
ATOM   2603  CD1 TRP   319      20.028  23.727  19.965  1.00 12.23      A   
ATOM   2604  NE1 TRP   319      18.977  24.055  19.142  1.00  9.68      A   
ATOM   2605  CZ2 TRP   319      16.482  24.089  19.425  1.00  9.74      A   
ATOM   2606  CZ3 TRP   319      15.795  23.382  21.641  1.00  9.67      A   
ATOM   2607  CH2 TRP   319      15.495  23.834  20.343  1.00  9.43      A   
ATOM   2608  C   TRP   319      20.968  23.581  24.711  1.00 10.17      A   
ATOM   2609  O   TRP   319      22.159  23.330  24.889  1.00  9.60      A   
ATOM   2610  N   LYS   320      20.034  23.395  25.636  1.00  9.68      A   
ATOM   2611  CA  LYS   320      20.354  22.812  26.927  1.00 12.54      A   
ATOM   2612  CB  LYS   320      19.778  23.638  28.078  1.00 14.29      A   
ATOM   2613  CG  LYS   320      20.358  23.244  29.436  1.00 16.08      A   
ATOM   2614  CD  LYS   320      19.551  23.806  30.597  1.00 19.76      A   
ATOM   2615  CE  LYS   320      18.280  23.004  30.816  1.00 21.36      A   
ATOM   2616  NZ  LYS   320      17.608  23.384  32.097  1.00 21.30      A   
ATOM   2617  C   LYS   320      19.678  21.449  26.884  1.00 14.24      A   
ATOM   2618  O   LYS   320      18.487  21.323  27.170  1.00 13.35      A   
ATOM   2619  N   LEU   321      20.444  20.437  26.496  1.00 15.40      A   
ATOM   2620  CA  LEU   321      19.936  19.081  26.382  1.00 18.42      A   
ATOM   2621  CB  LEU   321      20.535  18.410  25.145  1.00 17.05      A   
ATOM   2622  CG  LEU   321      20.333  19.212  23.850  1.00 17.39      A   
ATOM   2623  CD1 LEU   321      20.976  18.483  22.675  1.00 20.56      A   
ATOM   2624  CD2 LEU   321      18.844  19.414  23.613  1.00 16.30      A   
ATOM   2625  C   LEU   321      20.258  18.272  27.624  1.00 20.49      A   
ATOM   2626  O   LEU   321      21.359  18.354  28.170  1.00 20.28      A   
ATOM   2627  N   GLU   322      19.287  17.486  28.066  1.00 23.94      A   
ATOM   2628  CA  GLU   322      19.461  16.673  29.256  1.00 26.58      A   
ATOM   2629  CB  GLU   322      18.089  16.219  29.764  1.00 29.63      A   
ATOM   2630  CG  GLU   322      18.061  15.841  31.237  1.00 33.66      A   
ATOM   2631  CD  GLU   322      16.650  15.774  31.794  1.00 36.70      A   
ATOM   2632  OE1 GLU   322      16.503  15.480  33.004  1.00 37.76      A   
ATOM   2633  OE2 GLU   322      15.690  16.016  31.026  1.00 38.60      A   
ATOM   2634  C   GLU   322      20.364  15.468  29.000  1.00 26.92      A   
ATOM   2635  O   GLU   322      20.220  14.767  27.999  1.00 28.72      A   
ATOM   2636  N   HIS   323      21.309  15.248  29.906  1.00 27.72      A   
ATOM   2637  CA  HIS   323      22.232  14.122  29.806  1.00 28.44      A   
ATOM   2638  CB  HIS   323      23.174  14.286  28.606  1.00 27.61      A   
ATOM   2639  CG  HIS   323      24.119  15.439  28.732  1.00 28.26      A   
ATOM   2640  CD2 HIS   323      25.469  15.479  28.834  1.00 28.61      A   
ATOM   2641  ND1 HIS   323      23.693  16.749  28.773  1.00 29.13      A   
ATOM   2642  CE1 HIS   323      24.739  17.547  28.894  1.00 27.43      A   
ATOM   2643  NE2 HIS   323      25.829  16.802  28.934  1.00 30.19      A   
ATOM   2644  C   HIS   323      23.048  14.022  31.090  1.00 28.01      A   
ATOM   2645  O   HIS   323      23.182  14.995  31.832  1.00 27.87      A   
ATOM   2646  N   HIS   324      23.591  12.840  31.348  1.00 28.80      A   
ATOM   2647  CA  HIS   324      24.389  12.623  32.543  1.00 28.72      A   
ATOM   2648  CB  HIS   324      24.197  11.188  33.037  1.00 28.15      A   
ATOM   2649  CG  HIS   324      22.841  10.930  33.619  1.00 29.26      A   
ATOM   2650  CD2 HIS   324      21.795  10.201  33.159  1.00 28.25      A   
ATOM   2651  ND1 HIS   324      22.425  11.485  34.810  1.00 26.99      A   
ATOM   2652  CE1 HIS   324      21.183  11.111  35.058  1.00 28.45      A   
ATOM   2653  NE2 HIS   324      20.777  10.331  34.072  1.00 27.31      A   
ATOM   2654  C   HIS   324      25.863  12.904  32.274  1.00 30.27      A   
ATOM   2655  O   HIS   324      26.461  12.328  31.362  1.00 30.66      A   
ATOM   2656  N   HIS   325      26.443  13.802  33.065  1.00 30.45      A   
ATOM   2657  CA  HIS   325      27.849  14.157  32.909  1.00 31.58      A   
ATOM   2658  CB  HIS   325      28.155  15.478  33.628  1.00 33.63      A   
ATOM   2659  CG  HIS   325      27.135  16.551  33.392  1.00 35.68      A   
ATOM   2660  CD2 HIS   325      26.537  17.415  34.247  1.00 36.50      A   
ATOM   2661  ND1 HIS   325      26.622  16.832  32.144  1.00 36.37      A   
ATOM   2662  CE1 HIS   325      25.751  17.821  32.240  1.00 35.80      A   
ATOM   2663  NE2 HIS   325      25.681  18.193  33.506  1.00 35.28      A   
ATOM   2664  C   HIS   325      28.717  13.050  33.498  1.00 31.23      A   
ATOM   2665  O   HIS   325      28.269  12.293  34.357  1.00 31.59      A   
ATOM   2666  N   HIS   326      29.959  12.961  33.029  1.00 31.62      A   
ATOM   2667  CA  HIS   326      30.905  11.954  33.508  1.00 31.93      A   
ATOM   2668  CB  HIS   326      31.987  11.707  32.453  1.00 29.69      A   
ATOM   2669  CG  HIS   326      31.469  11.096  31.187  1.00 28.30      A   
ATOM   2670  CD2 HIS   326      31.351  11.602  29.937  1.00 25.83      A   
ATOM   2671  ND1 HIS   326      30.977   9.810  31.128  1.00 27.61      A   
ATOM   2672  CE1 HIS   326      30.577   9.549  29.895  1.00 26.06      A   
ATOM   2673  NE2 HIS   326      30.793  10.620  29.153  1.00 26.20      A   
ATOM   2674  C   HIS   326      31.557  12.418  34.811  1.00 33.12      A   
ATOM   2675  O   HIS   326      31.595  13.615  35.098  1.00 33.70      A   
ATOM   2676  N   HIS   327      32.067  11.466  35.592  1.00 33.88      A   
ATOM   2677  CA  HIS   327      32.715  11.768  36.870  1.00 34.47      A   
ATOM   2678  CB  HIS   327      32.059  10.977  38.004  1.00 35.44      A   
ATOM   2679  CG  HIS   327      30.620  11.322  38.230  1.00 37.72      A   
ATOM   2680  CD2 HIS   327      29.822  12.252  37.653  1.00 38.56      A   
ATOM   2681  ND1 HIS   327      29.838  10.666  39.156  1.00 37.79      A   
ATOM   2682  CE1 HIS   327      28.618  11.176  39.138  1.00 37.98      A   
ATOM   2683  NE2 HIS   327      28.582  12.139  38.235  1.00 39.36      A   
ATOM   2684  C   HIS   327      34.198  11.429  36.831  1.00 33.66      A   
ATOM   2685  O   HIS   327      34.583  10.292  37.102  1.00 32.85      A   
END
