
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  825),  selected  106 , name 1gyo_A
# Molecule2: number of CA atoms   71 (  556),  selected   71 , name T0513_17_85.pdb
# PARAMETERS: 1gyo_A.T0513_17_85.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    V     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    C     5_A      N      17           #
LGA    K     6_A      F      18          2.624
LGA    V     7_A      V      19          2.526
LGA    V     8_A      R      20          2.512
LGA    I     9_A      F      21          2.108
LGA    T    10_A      V      22          4.295
LGA    A    11_A      I      23          3.755
LGA    P    12_A      E      24          2.517
LGA    E    13_A      G      25          3.235
LGA    G    14_A      R      26           #
LGA    E    15_A      -       -           -
LGA    D    16_A      -       -           -
LGA    P    17_A      -       -           -
LGA    H    18_A      -       -           -
LGA    P    19_A      -       -           -
LGA    R    20_A      -       -           -
LGA    F    21_A      -       -           -
LGA    G    22_A      R      27           #
LGA    K    23_A      V      28          2.863
LGA    V    24_A      G      29          3.017
LGA    E    25_A      W      30          1.892
LGA    M    26_A      V      31          1.314
LGA    S    27_A      R      32          1.933
LGA    H    28_A      K      33          2.639
LGA    A    29_A      A      34          2.605
LGA    K    30_A      L      35          4.084
LGA    H    31_A      A      36          5.033
LGA    R    32_A      Q      37          4.430
LGA    N    33_A      -       -           -
LGA    V    34_A      -       -           -
LGA    S    35_A      R      38           #
LGA    C    36_A      L      39           #
LGA    V    37_A      K      40          5.048
LGA    S    38_A      A      41          1.708
LGA    C    39_A      H      42          1.770
LGA    H    40_A      G      43          1.475
LGA    H    41_A      R      44          3.669
LGA    M    42_A      V      45           #
LGA    F    43_A      F      46           -
LGA    D    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    C    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    D    48_A      -       -           -
LGA    F    49_A      D      47          4.230
LGA    Q    50_A      V      48           #
LGA    -       -      T      49           -
LGA    -       -      R      50           -
LGA    -       -      D      51           -
LGA    -       -      A      52           -
LGA    -       -      V      53           -
LGA    K    51_A      L      54          3.059
LGA    C    52_A      L      55          2.387
LGA    A    53_A      S      56          3.421
LGA    D    54_A      A      57          1.238
LGA    C    55_A      S      58          1.172
LGA    H    56_A      L      59          1.180
LGA    I    57_A      R      60          1.939
LGA    D    58_A      T      61          0.905
LGA    R    59_A      P      62          1.777
LGA    D    60_A      Q      63          5.084
LGA    D    61_A      -       -           -
LGA    R    62_A      -       -           -
LGA    S    63_A      -       -           -
LGA    Y    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    G    67_A      S      64          1.836
LGA    F    68_A      R      65          1.326
LGA    Y    69_A      T      66          1.102
LGA    K    70_A      R      67          1.849
LGA    A    71_A      A      68          2.420
LGA    W    72_A      V      69          1.228
LGA    H    73_A      A      70          0.680
LGA    S    74_A      D      71          1.980
LGA    E    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    E    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    S    79_A      -       -           -
LGA    C    80_A      V      72          3.661
LGA    R    81_A      V      73          1.130
LGA    G    82_A      D      74          1.780
LGA    C    83_A      R      75          1.875
LGA    H    84_A      L      76          2.337
LGA    K    85_A      A      77          2.941
LGA    A    86_A      D      78          2.123
LGA    M    87_A      E      79          1.529
LGA    K    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    K    90_A      -       -           -
LGA    N    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    Q    93_A      G      80          3.511
LGA    T    94_A      V      81          1.626
LGA    G    95_A      V      82          1.245
LGA    P    96_A      P      83          1.780
LGA    I    97_A      A      84          2.499
LGA    G    98_A      P      85          3.640
LGA    -       -      R      86           -
LGA    C    99_A      G      87           #
LGA    L   100_A      -       -           -
LGA    Q   101_A      -       -           -
LGA    G   102_A      -       -           -
LGA    C   103_A      -       -           -
LGA    H   104_A      -       -           -
LGA    E   105_A      -       -           -
LGA    A   106_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106   71    5.0     56    2.70     7.14     51.085     2.001

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.995217 * X  +   0.046429 * Y  +   0.085947 * Z  +  18.593576
  Y_new =   0.088627 * X  +   0.799174 * Y  +   0.594530 * Z  +  29.562923
  Z_new =  -0.041083 * X  +   0.599304 * Y  +  -0.799467 * Z  +  11.478398 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.498329   -0.643264  [ DEG:   143.1437    -36.8563 ]
  Theta =   0.041095    3.100498  [ DEG:     2.3545    177.6454 ]
  Phi   =   3.052774   -0.088818  [ DEG:   174.9111     -5.0889 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gyo_A                                        
REMARK     2: T0513_17_85.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gyo_A.T0513_17_85.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106   71   5.0   56   2.70    7.14  51.085
REMARK  ---------------------------------------------------------- 
MOLECULE 1gyo_A
HEADER    ELECTRON TRANSPORT                      29-APR-02   1GYO              
TITLE     CRYSTAL STRUCTURE OF THE DI-TETRAHEME CYTOCHROME C3 FROM              
TITLE    2 DESULFOVIBRIO GIGAS AT 1.2 ANG RESOLUTION                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYTOCHROME C3, A DIMERIC CLASS III C-TYPE                  
COMPND   3 CYTOCHROME;                                                          
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 SYNONYM: DIMERIC CYTOCHROME C3                                       
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DESULFOVIBRIO GIGAS                             
KEYWDS    CYTOCHROME C3, DI-TETRAHEME, AB INITIO, ELECTRON TRANSFER             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.ARAGAO,C.FRAZAO,L.SIEKER,G.M.SHELDRICK,J.LEGALL,                    
AUTHOR   2 M.A.CARRONDO                                                         
REVDAT   1   24-MAY-02 1GYO    0                                                
JRNL        AUTH   D.ARAGAO,C.FRAZAO,L.SIEKER,G.M.SHELDRICK,J.LEGALL,           
JRNL        AUTH 2 M.A.CARRONDO                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF THE DI-TETRAHEME CYTOCHROME             
JRNL        TITL 2 C3 FROM DESULFOVIBRIO GIGAS AT 1.2 ANG RESOLUTION            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.20 ANGSTROMS.                                          
DBREF  1GYO A    1   109  UNP    Q9R638   Q9R638_DESGI     1    109             
DBREF  1GYO B    1   109  UNP    Q9R638   Q9R638_DESGI     1    109             
SEQRES   1 A  109  LEU ASP VAL PRO CYS LYS VAL VAL ILE THR ALA PRO GLU          
SEQRES   2 A  109  GLY GLU ASP PRO HIS PRO ARG PHE GLY LYS VAL GLU MET          
SEQRES   3 A  109  SER HIS ALA LYS HIS ARG ASN VAL SER CYS VAL SER CYS          
SEQRES   4 A  109  HIS HIS MET PHE ASP GLY CYS GLY ASP PHE GLN LYS CYS          
SEQRES   5 A  109  ALA ASP CYS HIS ILE ASP ARG ASP ASP ARG SER TYR GLU          
SEQRES   6 A  109  ARG GLY PHE TYR LYS ALA TRP HIS SER GLU SER GLU ILE          
SEQRES   7 A  109  SER CYS ARG GLY CYS HIS LYS ALA MET LYS ALA LYS ASN          
SEQRES   8 A  109  GLU GLN THR GLY PRO ILE GLY CYS LEU GLN GLY CYS HIS          
SEQRES   9 A  109  GLU ALA ALA GLN LYS                                          
SEQRES   1 B  109  LEU ASP VAL PRO CYS LYS VAL VAL ILE THR ALA PRO GLU          
SEQRES   2 B  109  GLY GLU ASP PRO HIS PRO ARG PHE GLY LYS VAL GLU MET          
SEQRES   3 B  109  SER HIS ALA LYS HIS ARG ASN VAL SER CYS VAL SER CYS          
SEQRES   4 B  109  HIS HIS MET PHE ASP GLY CYS GLY ASP PHE GLN LYS CYS          
SEQRES   5 B  109  ALA ASP CYS HIS ILE ASP ARG ASP ASP ARG SER TYR GLU          
SEQRES   6 B  109  ARG GLY PHE TYR LYS ALA TRP HIS SER GLU SER GLU ILE          
SEQRES   7 B  109  SER CYS ARG GLY CYS HIS LYS ALA MET LYS ALA LYS ASN          
SEQRES   8 B  109  GLU GLN THR GLY PRO ILE GLY CYS LEU GLN GLY CYS HIS          
SEQRES   9 B  109  GLU ALA ALA GLN LYS                                          
HET    HEC  A 111      43                                                       
HET    HEC  A 112      43                                                       
HET    HEC  A 113      47                                                       
HET    HEC  A 114      43                                                       
HET    HEC  B 111      43                                                       
HET    HEC  B 112      43                                                       
HET    HEC  B 113      43                                                       
HET    HEC  B 114      43                                                       
HET    GOL  B 115       6                                                       
HET    GOL  B 116       7                                                       
HETNAM     HEC HEME C                                                           
HETNAM     GOL GLYCEROL                                                         
FORMUL   3  HEC    8(C34 H34 FE N4 O4)                                          
FORMUL  11  GOL    2(C3 H8 O3)                                                  
FORMUL  13  HOH   *280(H2 O)                                                    
CRYST1   56.670   56.670   94.170  90.00  90.00 120.00 P 31          6          
ATOM      1  N   LEU A   1       4.258  25.269   3.451  1.00 17.27           N  
ATOM      2  CA  LEU A   1       4.961  26.569   3.497  1.00 13.74           C  
ATOM      3  C   LEU A   1       5.806  26.662   4.758  1.00 13.28           C  
ATOM      4  O   LEU A   1       5.286  26.376   5.840  1.00 15.13           O  
ATOM      5  CB  LEU A   1       3.918  27.674   3.530  1.00 12.43           C  
ATOM      6  CG  LEU A   1       4.485  29.096   3.556  1.00 13.57           C  
ATOM      7  CD1 LEU A   1       5.394  29.348   2.365  1.00 16.46           C  
ATOM      8  CD2 LEU A   1       3.336  30.074   3.640  1.00 16.16           C  
ATOM      9  N   ASP A   2       7.056  27.101   4.629  1.00 13.43           N  
ATOM     10  CA  ASP A   2       7.907  27.433   5.741  1.00 12.53           C  
ATOM     11  C   ASP A   2       8.314  28.879   5.601  1.00 12.92           C  
ATOM     12  O   ASP A   2       9.007  29.204   4.639  1.00 15.55           O  
ATOM     13  CB  ASP A   2       9.160  26.557   5.754  1.00 13.47           C  
ATOM     14  CG  ASP A   2      10.091  26.819   6.906  1.00 14.41           C  
ATOM     15  OD1 ASP A   2       9.613  27.301   7.937  1.00 15.79           O  
ATOM     16  OD2 ASP A   2      11.296  26.488   6.776  1.00 17.29           O  
ATOM     17  N   VAL A   3       7.883  29.739   6.497  1.00 12.23           N  
ATOM     18  CA  VAL A   3       8.267  31.155   6.494  1.00 12.52           C  
ATOM     19  C   VAL A   3       9.555  31.221   7.300  1.00 12.58           C  
ATOM     20  O   VAL A   3       9.538  30.988   8.534  1.00 13.30           O  
ATOM     21  CB  VAL A   3       7.207  32.027   7.126  1.00 13.05           C  
ATOM     22  CG1 VAL A   3       7.687  33.481   7.184  1.00 14.99           C  
ATOM     23  CG2 VAL A   3       5.878  31.898   6.378  1.00 13.56           C  
ATOM     24  N   PRO A   4      10.705  31.472   6.691  1.00 12.99           N  
ATOM     25  CA  PRO A   4      11.949  31.415   7.472  1.00 12.99           C  
ATOM     26  C   PRO A   4      11.940  32.441   8.565  1.00 12.93           C  
ATOM     27  O   PRO A   4      11.585  33.611   8.365  1.00 14.26           O  
ATOM     28  CB  PRO A   4      13.033  31.714   6.406  1.00 14.42           C  
ATOM     29  CG  PRO A   4      12.373  31.209   5.167  0.56 15.52           C  
ATOM     31  CD  PRO A   4      10.935  31.746   5.245  1.00 13.72           C  
ATOM     32  N   CYS A   5      12.355  32.061   9.761  1.00 13.43           N  
ATOM     33  CA  CYS A   5      12.432  33.039  10.842  1.00 14.01           C  
ATOM     34  C   CYS A   5      13.519  34.061  10.583  1.00 12.97           C  
ATOM     35  O   CYS A   5      13.282  35.200  10.993  1.00 14.47           O  
ATOM     36  CB  CYS A   5      12.587  32.320  12.186  1.00 16.17           C  
ATOM     37  SG  CYS A   5      11.021  31.489  12.678  1.00 17.79           S  
ATOM     38  N   LYS A   6      14.606  33.672   9.922  1.00 13.63           N  
ATOM     39  CA  LYS A   6      15.615  34.667   9.505  1.00 13.95           C  
ATOM     40  C   LYS A   6      15.962  34.381   8.051  1.00 13.96           C  
ATOM     41  O   LYS A   6      16.125  33.206   7.709  1.00 15.06           O  
ATOM     42  CB  LYS A   6      16.843  34.662  10.409  0.63 17.05           C  
ATOM     44  CG  LYS A   6      17.872  35.719  10.068  0.63 20.06           C  
ATOM     46  CD  LYS A   6      19.245  35.435  10.686  0.63 28.76           C  
ATOM     48  CE  LYS A   6      19.195  35.579  12.189  0.63 40.66           C  
ATOM     50  NZ  LYS A   6      20.515  35.942  12.795  0.63 37.34           N  
ATOM     52  N   VAL A   7      16.060  35.426   7.260  1.00 16.37           N  
ATOM     53  CA  VAL A   7      16.413  35.374   5.861  1.00 17.92           C  
ATOM     54  C   VAL A   7      17.714  36.173   5.682  1.00 17.12           C  
ATOM     55  O   VAL A   7      17.939  37.159   6.366  1.00 17.70           O  
ATOM     56  CB  VAL A   7      15.332  35.882   4.873  1.00 18.86           C  
ATOM     57  CG1 VAL A   7      14.053  35.027   4.946  1.00 21.24           C  
ATOM     58  CG2 VAL A   7      14.955  37.317   5.115  1.00 20.05           C  
ATOM     59  N   VAL A   8      18.541  35.735   4.761  1.00 18.40           N  
ATOM     60  CA  VAL A   8      19.698  36.539   4.358  1.00 17.97           C  
ATOM     61  C   VAL A   8      19.429  37.025   2.950  1.00 16.04           C  
ATOM     62  O   VAL A   8      19.160  36.259   2.012  1.00 19.21           O  
ATOM     63  CB  VAL A   8      21.001  35.725   4.371  1.00 29.37           C  
ATOM     64  CG1 VAL A   8      22.136  36.634   3.917  1.00 38.26           C  
ATOM     65  CG2 VAL A   8      21.205  35.123   5.770  1.00 32.21           C  
ATOM     66  N   ILE A   9      19.385  38.326   2.816  1.00 13.98           N  
ATOM     67  CA  ILE A   9      19.060  39.026   1.625  1.00 13.61           C  
ATOM     68  C   ILE A   9      20.392  39.438   0.959  1.00 13.66           C  
ATOM     69  O   ILE A   9      21.236  40.012   1.628  1.00 14.89           O  
ATOM     70  CB  ILE A   9      18.174  40.242   1.896  1.00 13.02           C  
ATOM     71  CG1 ILE A   9      16.983  39.931   2.781  1.00 13.29           C  
ATOM     72  CG2 ILE A   9      17.714  40.856   0.545  1.00 13.58           C  
ATOM     73  CD1 ILE A   9      16.259  41.187   3.287  1.00 13.48           C  
ATOM     74  N   THR A  10      20.512  39.136  -0.316  1.00 15.99           N  
ATOM     75  CA  THR A  10      21.751  39.548  -1.018  1.00 17.05           C  
ATOM     76  C   THR A  10      21.423  39.974  -2.450  1.00 14.94           C  
ATOM     77  O   THR A  10      20.254  40.228  -2.762  1.00 15.83           O  
ATOM     78  CB  THR A  10      22.818  38.492  -0.864  1.00 19.40           C  
ATOM     79  OG1 THR A  10      24.107  38.965  -1.358  1.00 20.89           O  
ATOM     80  CG2 THR A  10      22.387  37.265  -1.640  1.00 23.27           C  
ATOM     81  N   ALA A  11      22.422  40.070  -3.280  1.00 15.11           N  
ATOM     82  CA  ALA A  11      22.246  40.468  -4.657  1.00 15.19           C  
ATOM     83  C   ALA A  11      21.364  39.457  -5.376  1.00 16.30           C  
ATOM     84  O   ALA A  11      21.217  38.300  -4.963  1.00 18.49           O  
ATOM     85  CB  ALA A  11      23.606  40.603  -5.344  1.00 17.16           C  
ATOM     86  N   PRO A  12      20.761  39.862  -6.510  1.00 16.22           N  
ATOM     87  CA  PRO A  12      19.933  38.915  -7.274  1.00 18.55           C  
ATOM     88  C   PRO A  12      20.705  37.660  -7.637  1.00 19.74           C  
ATOM     89  O   PRO A  12      21.908  37.707  -7.903  1.00 19.92           O  
ATOM     90  CB  PRO A  12      19.610  39.745  -8.529  1.00 18.47           C  
ATOM     91  CG  PRO A  12      19.632  41.169  -8.050  1.00 17.46           C  
ATOM     92  CD  PRO A  12      20.800  41.207  -7.122  1.00 16.02           C  
ATOM     93  N   GLU A  13      19.973  36.557  -7.693  1.00 22.19           N  
ATOM     94  CA  GLU A  13      20.525  35.239  -7.951  1.00 27.33           C  
ATOM     95  C   GLU A  13      21.483  35.244  -9.124  1.00 25.70           C  
ATOM     96  O   GLU A  13      21.067  35.773 -10.156  1.00 26.44           O  
ATOM     97  CB  GLU A  13      19.396  34.250  -8.281  1.00 36.22           C  
ATOM     98  CG  GLU A  13      19.850  32.811  -8.468  1.00 50.11           C  
ATOM     99  CD  GLU A  13      19.955  32.114  -7.136  1.00 70.65           C  
ATOM    100  OE1 GLU A  13      20.758  31.174  -6.979  1.00 81.46           O  
ATOM    101  OE2 GLU A  13      19.209  32.539  -6.218  1.00 61.73           O  
ATOM    102  N   GLY A  14      22.696  34.738  -8.950  1.00 27.10           N  
ATOM    103  CA  GLY A  14      23.610  34.642 -10.052  1.00 30.24           C  
ATOM    104  C   GLY A  14      24.502  35.857 -10.184  1.00 27.27           C  
ATOM    105  O   GLY A  14      25.459  35.774 -10.972  1.00 38.42           O  
ATOM    106  N   GLU A  15      24.192  36.929  -9.459  1.00 24.62           N  
ATOM    107  CA  GLU A  15      24.977  38.154  -9.573  1.00 23.34           C  
ATOM    108  C   GLU A  15      25.920  38.295  -8.379  1.00 22.65           C  
ATOM    109  O   GLU A  15      25.770  37.734  -7.308  1.00 26.55           O  
ATOM    110  CB  GLU A  15      24.099  39.413  -9.673  1.00 20.99           C  
ATOM    111  CG  GLU A  15      23.122  39.253 -10.868  0.57 25.17           C  
ATOM    113  CD  GLU A  15      23.811  39.402 -12.211  0.57 26.75           C  
ATOM    115  OE1 GLU A  15      23.319  38.886 -13.246  0.57 30.17           O  
ATOM    117  OE2 GLU A  15      24.871  40.055 -12.237  0.57 40.55           O  
ATOM    119  N   ASP A  16      26.965  39.092  -8.602  1.00 22.67           N  
ATOM    120  CA  ASP A  16      27.917  39.305  -7.544  1.00 24.50           C  
ATOM    121  C   ASP A  16      27.427  40.269  -6.464  1.00 20.62           C  
ATOM    122  O   ASP A  16      26.840  41.308  -6.778  1.00 21.51           O  
ATOM    123  CB  ASP A  16      29.199  39.894  -8.132  1.00 30.86           C  
ATOM    124  CG  ASP A  16      30.007  38.913  -8.928  1.00 39.69           C  
ATOM    125  OD1 ASP A  16      29.813  37.693  -8.775  1.00 51.85           O  
ATOM    126  OD2 ASP A  16      30.829  39.483  -9.679  1.00 55.02           O  
ATOM    127  N   PRO A  17      27.633  39.973  -5.189  1.00 21.17           N  
ATOM    128  CA  PRO A  17      27.231  40.873  -4.095  1.00 19.56           C  
ATOM    129  C   PRO A  17      28.025  42.166  -4.120  1.00 18.85           C  
ATOM    130  O   PRO A  17      29.172  42.219  -4.603  1.00 22.78           O  
ATOM    131  CB  PRO A  17      27.607  40.119  -2.813  1.00 24.43           C  
ATOM    132  CG  PRO A  17      28.681  39.201  -3.292  1.00 37.71           C  
ATOM    133  CD  PRO A  17      28.264  38.762  -4.685  1.00 25.53           C  
ATOM    134  N   HIS A  18      27.415  43.215  -3.617  1.00 17.87           N  
ATOM    135  CA  HIS A  18      28.142  44.454  -3.404  1.00 18.29           C  
ATOM    136  C   HIS A  18      29.345  44.200  -2.534  1.00 21.58           C  
ATOM    137  O   HIS A  18      29.215  43.383  -1.601  1.00 22.16           O  
ATOM    138  CB  HIS A  18      27.198  45.454  -2.756  1.00 17.55           C  
ATOM    139  CG  HIS A  18      27.763  46.814  -2.827  1.00 18.44           C  
ATOM    140  ND1 HIS A  18      28.685  47.253  -1.922  1.00 19.62           N  
ATOM    141  CD2 HIS A  18      27.554  47.789  -3.756  1.00 18.96           C  
ATOM    142  CE1 HIS A  18      29.018  48.496  -2.299  1.00 19.81           C  
ATOM    143  NE2 HIS A  18      28.352  48.830  -3.378  1.00 21.47           N  
ATOM    144  N   PRO A  19      30.496  44.761  -2.852  1.00 22.92           N  
ATOM    145  CA  PRO A  19      31.675  44.363  -2.090  1.00 26.71           C  
ATOM    146  C   PRO A  19      31.677  44.852  -0.656  1.00 25.84           C  
ATOM    147  O   PRO A  19      32.496  44.320   0.087  1.00 35.01           O  
ATOM    148  CB  PRO A  19      32.854  45.023  -2.846  1.00 33.32           C  
ATOM    149  CG  PRO A  19      32.203  46.023  -3.730  1.00 32.32           C  
ATOM    150  CD  PRO A  19      30.798  45.617  -3.991  1.00 25.95           C  
ATOM    151  N   ARG A  20      30.840  45.827  -0.267  1.00 23.19           N  
ATOM    152  CA  ARG A  20      30.819  46.304   1.106  1.00 22.67           C  
ATOM    153  C   ARG A  20      29.435  46.257   1.801  1.00 19.77           C  
ATOM    154  O   ARG A  20      29.327  46.217   3.019  1.00 26.76           O  
ATOM    155  CB  ARG A  20      31.291  47.762   1.124  1.00 25.00           C  
ATOM    156  CG  ARG A  20      31.457  48.233   2.538  1.00 34.08           C  
ATOM    157  CD  ARG A  20      32.421  49.353   2.852  1.00 38.09           C  
ATOM    158  NE  ARG A  20      32.618  49.415   4.307  1.00 32.61           N  
ATOM    159  CZ  ARG A  20      33.551  50.208   4.858  1.00 31.93           C  
ATOM    160  NH1 ARG A  20      34.319  50.976   4.080  1.00 28.42           N  
ATOM    161  NH2 ARG A  20      33.709  50.229   6.178  1.00 30.75           N  
ATOM    162  N   PHE A  21      28.353  46.267   1.047  1.00 16.41           N  
ATOM    163  CA  PHE A  21      26.988  46.293   1.508  1.00 14.64           C  
ATOM    164  C   PHE A  21      26.225  45.055   1.012  1.00 14.74           C  
ATOM    165  O   PHE A  21      25.057  45.148   0.653  1.00 16.46           O  
ATOM    166  CB  PHE A  21      26.317  47.581   1.001  1.00 14.79           C  
ATOM    167  CG  PHE A  21      26.817  48.816   1.691  1.00 15.19           C  
ATOM    168  CD1 PHE A  21      27.985  49.418   1.291  1.00 17.08           C  
ATOM    169  CD2 PHE A  21      26.139  49.382   2.757  1.00 16.12           C  
ATOM    170  CE1 PHE A  21      28.457  50.530   1.949  1.00 17.54           C  
ATOM    171  CE2 PHE A  21      26.617  50.457   3.429  1.00 17.18           C  
ATOM    172  CZ  PHE A  21      27.770  51.051   3.004  1.00 17.98           C  
ATOM    173  N   GLY A  22      26.871  43.890   0.997  1.00 15.50           N  
ATOM    174  CA  GLY A  22      26.393  42.791   0.166  1.00 17.74           C  
ATOM    175  C   GLY A  22      25.342  41.896   0.733  1.00 15.69           C  
ATOM    176  O   GLY A  22      24.684  41.197  -0.064  1.00 18.64           O  
ATOM    177  N   LYS A  23      25.186  41.849   2.049  1.00 15.55           N  
ATOM    178  CA  LYS A  23      24.253  40.921   2.684  1.00 17.42           C  
ATOM    179  C   LYS A  23      23.552  41.595   3.850  1.00 16.00           C  
ATOM    180  O   LYS A  23      24.192  42.309   4.635  1.00 17.22           O  
ATOM    181  CB  LYS A  23      24.920  39.638   3.224  1.00 26.54           C  
ATOM    182  CG  LYS A  23      25.360  38.655   2.170  1.00 32.42           C  
ATOM    183  CD  LYS A  23      25.979  37.396   2.676  1.00 46.03           C  
ATOM    184  CE  LYS A  23      25.938  37.081   4.142  1.00 58.63           C  
ATOM    185  NZ  LYS A  23      26.699  35.796   4.448  1.00 95.81           N  
ATOM    186  N   VAL A  24      22.270  41.352   4.003  1.00 14.43           N  
ATOM    187  CA  VAL A  24      21.504  41.891   5.132  1.00 13.49           C  
ATOM    188  C   VAL A  24      20.581  40.796   5.669  1.00 14.16           C  
ATOM    189  O   VAL A  24      19.904  40.133   4.882  1.00 15.87           O  
ATOM    190  CB  VAL A  24      20.625  43.091   4.707  1.00 12.19           C  
ATOM    191  CG1 VAL A  24      19.656  43.498   5.787  1.00 13.73           C  
ATOM    192  CG2 VAL A  24      21.530  44.247   4.237  1.00 13.99           C  
ATOM    193  N   GLU A  25      20.544  40.623   6.963  1.00 14.77           N  
ATOM    194  CA  GLU A  25      19.640  39.668   7.578  1.00 17.14           C  
ATOM    195  C   GLU A  25      18.360  40.373   7.929  1.00 16.96           C  
ATOM    196  O   GLU A  25      18.335  41.540   8.340  1.00 20.75           O  
ATOM    197  CB  GLU A  25      20.271  39.098   8.850  1.00 22.00           C  
ATOM    198  CG  GLU A  25      21.579  38.424   8.624  1.00 30.01           C  
ATOM    199  CD  GLU A  25      22.089  37.728   9.905  1.00 33.09           C  
ATOM    200  OE1 GLU A  25      23.072  36.991   9.694  1.00 49.78           O  
ATOM    201  OE2 GLU A  25      21.595  37.898  11.037  1.00 47.00           O  
ATOM    202  N   MET A  26      17.248  39.650   7.790  1.00 15.13           N  
ATOM    203  CA  MET A  26      15.979  40.153   8.259  1.00 14.75           C  
ATOM    204  C   MET A  26      15.250  39.049   8.997  1.00 13.93           C  
ATOM    205  O   MET A  26      15.226  37.894   8.576  1.00 15.68           O  
ATOM    206  CB  MET A  26      15.077  40.580   7.106  1.00 15.16           C  
ATOM    207  CG  MET A  26      13.863  41.387   7.512  1.00 16.77           C  
ATOM    208  SD  MET A  26      12.430  41.144   6.454  1.00 17.21           S  
ATOM    209  CE  MET A  26      11.949  39.576   7.040  1.00 18.33           C  
ATOM    210  N   SER A  27      14.675  39.435  10.136  1.00 14.11           N  
ATOM    211  CA  SER A  27      13.929  38.475  10.953  1.00 13.97           C  
ATOM    212  C   SER A  27      12.453  38.604  10.717  1.00 12.53           C  
ATOM    213  O   SER A  27      11.839  39.642  10.988  1.00 14.11           O  
ATOM    214  CB  SER A  27      14.239  38.752  12.417  1.00 16.50           C  
ATOM    215  OG  SER A  27      13.334  37.930  13.201  1.00 16.67           O  
ATOM    216  N   HIS A  28      11.822  37.531  10.224  1.00 12.86           N  
ATOM    217  CA  HIS A  28      10.345  37.528  10.196  1.00 12.72           C  
ATOM    218  C   HIS A  28       9.783  37.558  11.608  1.00 13.72           C  
ATOM    219  O   HIS A  28       8.742  38.142  11.842  1.00 14.57           O  
ATOM    220  CB  HIS A  28       9.774  36.326   9.452  1.00 12.33           C  
ATOM    221  CG  HIS A  28       9.718  36.445   7.951  1.00 11.57           C  
ATOM    222  ND1 HIS A  28      10.612  35.812   7.134  1.00 12.69           N  
ATOM    223  CD2 HIS A  28       8.873  37.085   7.115  1.00 11.87           C  
ATOM    224  CE1 HIS A  28      10.266  36.073   5.840  1.00 11.83           C  
ATOM    225  NE2 HIS A  28       9.222  36.844   5.810  1.00 11.29           N  
ATOM    226  N   ALA A  29      10.474  36.932  12.572  1.00 14.59           N  
ATOM    227  CA  ALA A  29       9.990  36.937  13.955  1.00 16.44           C  
ATOM    228  C   ALA A  29       9.874  38.351  14.502  1.00 16.22           C  
ATOM    229  O   ALA A  29       8.851  38.725  15.084  1.00 18.10           O  
ATOM    230  CB  ALA A  29      10.935  36.088  14.835  1.00 18.83           C  
ATOM    231  N   LYS A  30      10.914  39.155  14.274  1.00 15.49           N  
ATOM    232  CA  LYS A  30      10.908  40.511  14.789  1.00 16.41           C  
ATOM    233  C   LYS A  30       9.860  41.385  14.121  1.00 15.99           C  
ATOM    234  O   LYS A  30       9.367  42.343  14.718  1.00 17.57           O  
ATOM    235  CB  LYS A  30      12.291  41.176  14.629  1.00 17.82           C  
ATOM    236  CG  LYS A  30      13.344  40.608  15.541  1.00 21.95           C  
ATOM    237  CD  LYS A  30      13.036  40.943  17.009  1.00 35.56           C  
ATOM    238  CE  LYS A  30      14.125  40.501  17.958  1.00 40.28           C  
ATOM    239  NZ  LYS A  30      14.012  41.186  19.307  1.00 79.92           N  
ATOM    240  N   HIS A  31       9.516  41.030  12.866  1.00 14.28           N  
ATOM    241  CA  HIS A  31       8.492  41.721  12.110  1.00 13.89           C  
ATOM    242  C   HIS A  31       7.114  41.080  12.211  1.00 14.48           C  
ATOM    243  O   HIS A  31       6.233  41.344  11.377  1.00 14.85           O  
ATOM    244  CB  HIS A  31       8.876  41.872  10.651  1.00 14.02           C  
ATOM    245  CG  HIS A  31      10.043  42.814  10.477  1.00 13.03           C  
ATOM    246  ND1 HIS A  31      11.326  42.421  10.418  1.00 14.09           N  
ATOM    247  CD2 HIS A  31      10.086  44.151  10.263  1.00 12.73           C  
ATOM    248  CE1 HIS A  31      12.115  43.477  10.214  1.00 13.65           C  
ATOM    249  NE2 HIS A  31      11.393  44.576  10.131  1.00 12.74           N  
ATOM    250  N   ARG A  32       6.855  40.300  13.256  1.00 14.97           N  
ATOM    251  CA  ARG A  32       5.580  39.581  13.357  1.00 16.24           C  
ATOM    252  C   ARG A  32       4.360  40.470  13.484  1.00 18.02           C  
ATOM    253  O   ARG A  32       3.258  40.004  13.180  1.00 20.49           O  
ATOM    254  CB  ARG A  32       5.643  38.573  14.521  1.00 20.02           C  
ATOM    255  CG  ARG A  32       5.975  39.000  15.922  0.58 24.24           C  
ATOM    257  CD  ARG A  32       5.778  37.821  16.901  0.58 26.68           C  
ATOM    259  NE  ARG A  32       7.001  37.136  17.240  0.58 32.71           N  
ATOM    261  CZ  ARG A  32       7.967  36.279  17.393  0.58 30.60           C  
ATOM    263  NH1 ARG A  32       7.956  35.065  16.822  0.58 24.37           N  
ATOM    265  NH2 ARG A  32       9.088  36.514  18.121  0.58 28.96           N  
ATOM    267  N   ASN A  33       4.510  41.721  13.877  1.00 17.77           N  
ATOM    268  CA  ASN A  33       3.369  42.639  13.974  1.00 18.71           C  
ATOM    269  C   ASN A  33       3.192  43.478  12.707  1.00 19.63           C  
ATOM    270  O   ASN A  33       2.356  44.367  12.679  1.00 26.53           O  
ATOM    271  CB  ASN A  33       3.494  43.569  15.170  1.00 19.64           C  
ATOM    272  CG  ASN A  33       3.604  42.830  16.481  1.00 22.57           C  
ATOM    273  OD1 ASN A  33       2.875  41.860  16.713  1.00 26.03           O  
ATOM    274  ND2 ASN A  33       4.530  43.245  17.358  1.00 26.30           N  
ATOM    275  N   VAL A  34       3.941  43.186  11.661  1.00 17.11           N  
ATOM    276  CA  VAL A  34       3.858  43.894  10.395  1.00 16.45           C  
ATOM    277  C   VAL A  34       3.150  42.941   9.421  1.00 16.65           C  
ATOM    278  O   VAL A  34       3.567  41.790   9.284  1.00 16.21           O  
ATOM    279  CB  VAL A  34       5.243  44.269   9.876  1.00 16.05           C  
ATOM    280  CG1 VAL A  34       5.159  44.939   8.505  1.00 15.88           C  
ATOM    281  CG2 VAL A  34       6.000  45.131  10.912  1.00 17.03           C  
ATOM    282  N   SER A  35       2.084  43.373   8.780  1.00 17.06           N  
ATOM    283  CA  SER A  35       1.363  42.490   7.872  1.00 17.09           C  
ATOM    284  C   SER A  35       2.253  42.036   6.722  1.00 16.30           C  
ATOM    285  O   SER A  35       3.095  42.785   6.231  1.00 15.34           O  
ATOM    286  CB  SER A  35       0.089  43.158   7.305  1.00 20.40           C  
ATOM    287  OG  SER A  35       0.483  44.212   6.445  1.00 22.94           O  
ATOM    288  N   CYS A  36       1.986  40.811   6.244  1.00 15.75           N  
ATOM    289  CA  CYS A  36       2.804  40.252   5.158  1.00 14.87           C  
ATOM    290  C   CYS A  36       2.848  41.188   3.959  1.00 13.80           C  
ATOM    291  O   CYS A  36       3.926  41.411   3.371  1.00 14.06           O  
ATOM    292  CB  CYS A  36       2.319  38.895   4.680  1.00 15.68           C  
ATOM    293  SG  CYS A  36       1.835  37.687   5.914  1.00 16.14           S  
ATOM    294  N   VAL A  37       1.699  41.725   3.588  1.00 15.03           N  
ATOM    295  CA  VAL A  37       1.599  42.550   2.362  1.00 14.69           C  
ATOM    296  C   VAL A  37       2.298  43.869   2.510  1.00 13.88           C  
ATOM    297  O   VAL A  37       2.588  44.517   1.497  1.00 15.07           O  
ATOM    298  CB  VAL A  37       0.105  42.734   2.009  1.00 17.56           C  
ATOM    299  CG1 VAL A  37      -0.612  43.657   2.986  1.00 23.39           C  
ATOM    300  CG2 VAL A  37      -0.032  43.255   0.585  1.00 19.63           C  
ATOM    301  N   SER A  38       2.608  44.308   3.729  1.00 14.44           N  
ATOM    302  CA  SER A  38       3.342  45.538   3.910  1.00 14.03           C  
ATOM    303  C   SER A  38       4.725  45.481   3.244  1.00 13.74           C  
ATOM    304  O   SER A  38       5.230  46.534   2.856  1.00 14.80           O  
ATOM    305  CB  SER A  38       3.509  45.885   5.391  1.00 15.10           C  
ATOM    306  OG  SER A  38       2.238  46.109   5.999  1.00 18.71           O  
ATOM    307  N   CYS A  39       5.303  44.302   3.177  1.00 12.74           N  
ATOM    308  CA  CYS A  39       6.575  44.048   2.485  1.00 11.94           C  
ATOM    309  C   CYS A  39       6.328  43.330   1.155  1.00 11.53           C  
ATOM    310  O   CYS A  39       6.813  43.770   0.117  1.00 12.35           O  
ATOM    311  CB  CYS A  39       7.497  43.215   3.338  1.00 11.57           C  
ATOM    312  SG  CYS A  39       7.872  44.061   4.915  1.00 12.54           S  
ATOM    313  N   HIS A  40       5.622  42.203   1.226  1.00 12.64           N  
ATOM    314  CA  HIS A  40       5.303  41.429   0.031  1.00 12.52           C  
ATOM    315  C   HIS A  40       4.100  42.059  -0.673  1.00 12.94           C  
ATOM    316  O   HIS A  40       2.987  41.491  -0.683  1.00 14.02           O  
ATOM    317  CB  HIS A  40       4.959  39.999   0.450  1.00 13.24           C  
ATOM    318  CG  HIS A  40       6.085  39.267   1.112  1.00 12.48           C  
ATOM    319  ND1 HIS A  40       7.122  38.717   0.395  1.00 12.48           N  
ATOM    320  CD2 HIS A  40       6.305  38.930   2.404  1.00 12.13           C  
ATOM    321  CE1 HIS A  40       7.940  38.100   1.269  1.00 11.86           C  
ATOM    322  NE2 HIS A  40       7.487  38.197   2.487  1.00 11.81           N  
ATOM    323  N   HIS A  41       4.318  43.241  -1.210  1.00 13.02           N  
ATOM    324  CA  HIS A  41       3.234  44.102  -1.664  1.00 13.10           C  
ATOM    325  C   HIS A  41       2.496  43.527  -2.892  1.00 14.06           C  
ATOM    326  O   HIS A  41       1.385  44.014  -3.168  1.00 15.58           O  
ATOM    327  CB  HIS A  41       3.783  45.493  -2.006  1.00 12.82           C  
ATOM    328  CG  HIS A  41       4.731  45.558  -3.149  1.00 12.28           C  
ATOM    329  ND1 HIS A  41       4.311  45.921  -4.405  1.00 13.61           N  
ATOM    330  CD2 HIS A  41       6.067  45.288  -3.310  1.00 12.30           C  
ATOM    331  CE1 HIS A  41       5.343  45.898  -5.237  1.00 14.12           C  
ATOM    332  NE2 HIS A  41       6.447  45.534  -4.611  1.00 12.30           N  
ATOM    333  N   MET A  42       3.081  42.552  -3.560  1.00 13.33           N  
ATOM    334  CA  MET A  42       2.431  41.905  -4.699  1.00 14.97           C  
ATOM    335  C   MET A  42       1.623  40.694  -4.278  1.00 16.11           C  
ATOM    336  O   MET A  42       0.914  40.139  -5.146  1.00 19.41           O  
ATOM    337  CB  MET A  42       3.476  41.508  -5.734  1.00 15.38           C  
ATOM    338  CG  MET A  42       4.255  42.697  -6.299  1.00 16.43           C  
ATOM    339  SD  MET A  42       3.266  43.888  -7.224  1.00 17.11           S  
ATOM    340  CE  MET A  42       2.916  42.886  -8.652  1.00 23.03           C  
ATOM    341  N   PHE A  43       1.669  40.284  -3.023  1.00 14.67           N  
ATOM    342  CA  PHE A  43       0.870  39.126  -2.604  1.00 15.13           C  
ATOM    343  C   PHE A  43      -0.587  39.521  -2.419  1.00 15.47           C  
ATOM    344  O   PHE A  43      -0.852  40.497  -1.743  1.00 17.45           O  
ATOM    345  CB  PHE A  43       1.480  38.566  -1.290  1.00 15.22           C  
ATOM    346  CG  PHE A  43       0.679  37.338  -0.830  1.00 13.68           C  
ATOM    347  CD1 PHE A  43       0.880  36.092  -1.375  1.00 13.95           C  
ATOM    348  CD2 PHE A  43      -0.281  37.478   0.148  1.00 14.81           C  
ATOM    349  CE1 PHE A  43       0.188  34.970  -0.942  1.00 14.46           C  
ATOM    350  CE2 PHE A  43      -0.989  36.372   0.601  1.00 15.03           C  
ATOM    351  CZ  PHE A  43      -0.766  35.166   0.017  1.00 15.30           C  
ATOM    352  N   ASP A  44      -1.502  38.736  -3.000  1.00 16.68           N  
ATOM    353  CA  ASP A  44      -2.912  39.052  -2.820  1.00 20.37           C  
ATOM    354  C   ASP A  44      -3.647  37.757  -2.586  1.00 21.38           C  
ATOM    355  O   ASP A  44      -4.016  37.049  -3.556  1.00 25.29           O  
ATOM    356  CB  ASP A  44      -3.421  39.758  -4.053  0.56 23.21           C  
ATOM    358  CG  ASP A  44      -4.875  40.164  -3.940  0.56 19.50           C  
ATOM    360  OD1 ASP A  44      -5.603  39.662  -3.052  0.56 21.08           O  
ATOM    362  OD2 ASP A  44      -5.290  41.003  -4.805  0.56 24.16           O  
ATOM    364  N   GLY A  45      -3.883  37.392  -1.337  1.00 25.31           N  
ATOM    365  CA  GLY A  45      -4.750  36.301  -1.011  1.00 24.23           C  
ATOM    366  C   GLY A  45      -4.105  34.934  -1.027  1.00 19.64           C  
ATOM    367  O   GLY A  45      -4.161  34.174  -0.066  1.00 19.48           O  
ATOM    368  N   CYS A  46      -3.581  34.578  -2.201  1.00 18.66           N  
ATOM    369  CA  CYS A  46      -3.039  33.249  -2.325  1.00 17.53           C  
ATOM    370  C   CYS A  46      -1.958  33.346  -3.416  1.00 17.05           C  
ATOM    371  O   CYS A  46      -1.893  34.369  -4.129  1.00 21.07           O  
ATOM    372  CB  CYS A  46      -4.082  32.193  -2.678  1.00 17.44           C  
ATOM    373  SG  CYS A  46      -5.053  32.538  -4.198  1.00 19.72           S  
ATOM    374  N   GLY A  47      -1.151  32.309  -3.551  1.00 16.50           N  
ATOM    375  CA  GLY A  47      -0.050  32.354  -4.478  1.00 16.95           C  
ATOM    376  C   GLY A  47       1.266  32.243  -3.754  1.00 15.11           C  
ATOM    377  O   GLY A  47       1.345  31.613  -2.669  1.00 15.57           O  
ATOM    378  N   ASP A  48       2.261  32.812  -4.332  1.00 15.39           N  
ATOM    379  CA  ASP A  48       3.642  32.678  -3.918  1.00 15.68           C  
ATOM    380  C   ASP A  48       4.189  33.984  -3.337  1.00 14.85           C  
ATOM    381  O   ASP A  48       3.877  35.079  -3.795  1.00 18.49           O  
ATOM    382  CB  ASP A  48       4.511  32.225  -5.077  1.00 17.52           C  
ATOM    383  CG  ASP A  48       4.364  30.776  -5.439  1.00 16.80           C  
ATOM    384  OD1 ASP A  48       3.788  30.027  -4.622  1.00 20.30           O  
ATOM    385  OD2 ASP A  48       4.844  30.384  -6.546  1.00 20.50           O  
ATOM    386  N   PHE A  49       5.009  33.810  -2.319  1.00 15.30           N  
ATOM    387  CA  PHE A  49       5.829  34.861  -1.738  1.00 19.05           C  
ATOM    388  C   PHE A  49       7.196  34.861  -2.439  1.00 21.06           C  
ATOM    389  O   PHE A  49       8.154  34.202  -2.044  1.00 24.91           O  
ATOM    390  CB  PHE A  49       6.091  34.650  -0.263  1.00 19.26           C  
ATOM    391  CG  PHE A  49       4.808  34.874   0.515  1.00 15.30           C  
ATOM    392  CD1 PHE A  49       4.076  33.762   0.842  1.00 15.76           C  
ATOM    393  CD2 PHE A  49       4.375  36.133   0.879  1.00 16.22           C  
ATOM    394  CE1 PHE A  49       2.898  33.932   1.537  1.00 17.94           C  
ATOM    395  CE2 PHE A  49       3.191  36.301   1.571  1.00 18.03           C  
ATOM    396  CZ  PHE A  49       2.451  35.200   1.877  1.00 18.43           C  
ATOM    397  N   GLN A  50       7.294  35.588  -3.479  1.00 22.56           N  
ATOM    398  CA  GLN A  50       8.500  35.624  -4.297  1.00 21.60           C  
ATOM    399  C   GLN A  50       9.604  36.417  -3.655  1.00 20.70           C  
ATOM    400  O   GLN A  50       9.394  37.470  -2.971  1.00 21.88           O  
ATOM    401  CB  GLN A  50       8.207  36.372  -5.609  1.00 19.80           C  
ATOM    402  CG  GLN A  50       7.202  35.654  -6.487  1.00 22.83           C  
ATOM    403  CD  GLN A  50       7.043  36.426  -7.805  1.00 22.59           C  
ATOM    404  OE1 GLN A  50       5.953  36.930  -8.077  1.00 24.61           O  
ATOM    405  NE2 GLN A  50       8.117  36.496  -8.588  1.00 23.77           N  
ATOM    406  N   LYS A  51      10.834  36.006  -3.933  1.00 18.42           N  
ATOM    407  CA  LYS A  51      11.962  36.859  -3.576  1.00 16.57           C  
ATOM    408  C   LYS A  51      11.849  38.178  -4.325  1.00 14.01           C  
ATOM    409  O   LYS A  51      11.465  38.226  -5.479  1.00 14.86           O  
ATOM    410  CB  LYS A  51      13.276  36.183  -3.954  1.00 18.76           C  
ATOM    411  CG  LYS A  51      13.519  34.950  -3.066  1.00 21.39           C  
ATOM    412  CD  LYS A  51      14.948  34.463  -3.263  1.00 27.47           C  
ATOM    413  CE  LYS A  51      15.306  33.300  -2.361  0.53 31.63           C  
ATOM    415  NZ  LYS A  51      15.957  33.630  -1.063  0.53 43.46           N  
ATOM    417  N   CYS A  52      12.205  39.248  -3.614  1.00 14.16           N  
ATOM    418  CA  CYS A  52      12.004  40.563  -4.154  1.00 12.94           C  
ATOM    419  C   CYS A  52      12.753  40.724  -5.476  1.00 12.84           C  
ATOM    420  O   CYS A  52      12.219  41.320  -6.425  1.00 13.64           O  
ATOM    421  CB  CYS A  52      12.414  41.634  -3.147  1.00 12.40           C  
ATOM    422  SG  CYS A  52      11.819  41.388  -1.473  1.00 12.67           S  
ATOM    423  N   ALA A  53      13.977  40.237  -5.550  1.00 13.78           N  
ATOM    424  CA  ALA A  53      14.793  40.361  -6.720  1.00 14.33           C  
ATOM    425  C   ALA A  53      14.344  39.479  -7.873  1.00 16.23           C  
ATOM    426  O   ALA A  53      14.907  39.607  -8.961  1.00 17.72           O  
ATOM    427  CB  ALA A  53      16.254  40.055  -6.440  1.00 16.67           C  
ATOM    428  N   ASP A  54      13.261  38.704  -7.723  1.00 14.85           N  
ATOM    429  CA  ASP A  54      12.655  38.115  -8.909  1.00 15.56           C  
ATOM    430  C   ASP A  54      12.205  39.224  -9.846  1.00 14.32           C  
ATOM    431  O   ASP A  54      12.134  39.028 -11.070  1.00 16.63           O  
ATOM    432  CB  ASP A  54      11.455  37.258  -8.565  1.00 15.62           C  
ATOM    433  CG  ASP A  54      11.734  35.940  -7.940  1.00 18.08           C  
ATOM    434  OD1 ASP A  54      12.925  35.564  -7.689  1.00 21.06           O  
ATOM    435  OD2 ASP A  54      10.680  35.266  -7.703  1.00 23.52           O  
ATOM    436  N   CYS A  55      11.875  40.378  -9.265  1.00 14.61           N  
ATOM    437  CA  CYS A  55      11.380  41.538  -9.992  1.00 15.15           C  
ATOM    438  C   CYS A  55      12.293  42.739  -9.870  1.00 13.75           C  
ATOM    439  O   CYS A  55      12.588  43.423 -10.860  1.00 15.46           O  
ATOM    440  CB  CYS A  55       9.990  41.977  -9.525  1.00 15.31           C  
ATOM    441  SG  CYS A  55       8.809  40.608  -9.722  1.00 15.82           S  
ATOM    442  N   HIS A  56      12.788  42.973  -8.675  1.00 12.94           N  
ATOM    443  CA  HIS A  56      13.709  44.097  -8.374  1.00 13.30           C  
ATOM    444  C   HIS A  56      15.130  43.692  -8.696  1.00 13.31           C  
ATOM    445  O   HIS A  56      15.952  43.427  -7.819  1.00 14.22           O  
ATOM    446  CB  HIS A  56      13.538  44.476  -6.903  1.00 12.52           C  
ATOM    447  CG  HIS A  56      12.224  45.118  -6.605  1.00 12.31           C  
ATOM    448  ND1 HIS A  56      12.016  46.467  -6.773  1.00 12.51           N  
ATOM    449  CD2 HIS A  56      11.045  44.628  -6.180  1.00 12.00           C  
ATOM    450  CE1 HIS A  56      10.765  46.776  -6.440  1.00 12.30           C  
ATOM    451  NE2 HIS A  56      10.130  45.653  -6.079  1.00 12.01           N  
ATOM    452  N   ILE A  57      15.424  43.644  -9.993  1.00 13.99           N  
ATOM    453  CA  ILE A  57      16.646  43.102 -10.499  1.00 15.65           C  
ATOM    454  C   ILE A  57      17.679  44.143 -10.928  1.00 16.36           C  
ATOM    455  O   ILE A  57      18.861  43.879 -10.792  1.00 19.10           O  
ATOM    456  CB  ILE A  57      16.379  42.167 -11.694  0.62 18.84           C  
ATOM    458  CG1 ILE A  57      15.355  41.115 -11.446  0.62 21.28           C  
ATOM    460  CG2 ILE A  57      17.698  41.492 -12.145  0.62 25.47           C  
ATOM    462  CD1 ILE A  57      15.528  39.981 -12.461  0.62 40.25           C  
ATOM    464  N   ASP A  58      17.237  45.259 -11.470  1.00 15.54           N  
ATOM    465  CA  ASP A  58      18.162  46.199 -12.082  1.00 16.58           C  
ATOM    466  C   ASP A  58      19.083  46.827 -11.039  1.00 15.54           C  
ATOM    467  O   ASP A  58      18.596  47.328 -10.019  1.00 15.39           O  
ATOM    468  CB  ASP A  58      17.397  47.344 -12.751  1.00 18.47           C  
ATOM    469  CG  ASP A  58      18.383  48.385 -13.234  1.00 22.64           C  
ATOM    470  OD1 ASP A  58      19.312  48.063 -13.983  1.00 25.57           O  
ATOM    471  OD2 ASP A  58      18.341  49.550 -12.812  1.00 29.74           O  
ATOM    472  N   ARG A  59      20.359  46.864 -11.291  1.00 14.65           N  
ATOM    473  CA  ARG A  59      21.357  47.497 -10.434  1.00 14.04           C  
ATOM    474  C   ARG A  59      22.106  48.565 -11.195  1.00 15.07           C  
ATOM    475  O   ARG A  59      23.129  49.058 -10.701  1.00 16.21           O  
ATOM    476  CB  ARG A  59      22.297  46.421  -9.871  1.00 15.19           C  
ATOM    477  CG  ARG A  59      21.548  45.496  -8.907  1.00 16.66           C  
ATOM    478  CD  ARG A  59      22.349  44.236  -8.682  1.00 19.21           C  
ATOM    479  NE  ARG A  59      23.398  44.413  -7.681  1.00 16.34           N  
ATOM    480  CZ  ARG A  59      24.406  43.593  -7.486  1.00 16.49           C  
ATOM    481  NH1 ARG A  59      24.627  42.534  -8.277  1.00 19.84           N  
ATOM    482  NH2 ARG A  59      25.263  43.808  -6.502  1.00 16.55           N  
ATOM    483  N   ASP A  60      21.611  48.996 -12.348  1.00 15.30           N  
ATOM    484  CA  ASP A  60      22.322  50.019 -13.112  1.00 15.50           C  
ATOM    485  C   ASP A  60      22.292  51.392 -12.459  1.00 14.40           C  
ATOM    486  O   ASP A  60      23.181  52.205 -12.732  1.00 14.84           O  
ATOM    487  CB  ASP A  60      21.746  50.144 -14.515  1.00 18.00           C  
ATOM    488  CG  ASP A  60      21.923  48.973 -15.445  1.00 23.40           C  
ATOM    489  OD1 ASP A  60      22.659  48.060 -15.053  1.00 25.60           O  
ATOM    490  OD2 ASP A  60      21.341  49.046 -16.555  1.00 30.78           O  
ATOM    491  N   ASP A  61      21.286  51.664 -11.662  1.00 14.87           N  
ATOM    492  CA  ASP A  61      21.147  52.911 -10.894  1.00 13.52           C  
ATOM    493  C   ASP A  61      20.527  52.596  -9.569  1.00 13.20           C  
ATOM    494  O   ASP A  61      20.284  51.430  -9.264  1.00 15.32           O  
ATOM    495  CB  ASP A  61      20.389  53.980 -11.716  1.00 15.01           C  
ATOM    496  CG  ASP A  61      18.945  53.692 -11.939  1.00 16.56           C  
ATOM    497  OD1 ASP A  61      18.240  53.123 -11.070  1.00 15.57           O  
ATOM    498  OD2 ASP A  61      18.497  53.983 -13.059  1.00 23.83           O  
ATOM    499  N   ARG A  62      20.329  53.637  -8.757  1.00 12.98           N  
ATOM    500  CA  ARG A  62      19.670  53.498  -7.454  1.00 12.97           C  
ATOM    501  C   ARG A  62      18.368  54.288  -7.450  1.00 14.16           C  
ATOM    502  O   ARG A  62      17.899  54.669  -6.393  1.00 15.57           O  
ATOM    503  CB  ARG A  62      20.605  53.993  -6.333  1.00 13.63           C  
ATOM    504  CG  ARG A  62      21.846  53.126  -6.205  1.00 13.69           C  
ATOM    505  CD  ARG A  62      22.650  53.579  -4.979  1.00 14.14           C  
ATOM    506  NE  ARG A  62      23.911  52.790  -4.887  1.00 13.65           N  
ATOM    507  CZ  ARG A  62      24.843  53.029  -3.995  1.00 13.69           C  
ATOM    508  NH1 ARG A  62      24.639  54.003  -3.106  1.00 14.81           N  
ATOM    509  NH2 ARG A  62      25.930  52.307  -4.017  1.00 15.65           N  
ATOM    510  N   SER A  63      17.776  54.544  -8.619  1.00 13.04           N  
ATOM    511  CA  SER A  63      16.651  55.427  -8.789  1.00 14.32           C  
ATOM    512  C   SER A  63      15.402  54.682  -9.305  1.00 13.26           C  
ATOM    513  O   SER A  63      14.282  55.049  -8.949  1.00 15.70           O  
ATOM    514  CB  SER A  63      16.985  56.560  -9.774  1.00 19.23           C  
ATOM    515  OG  SER A  63      18.060  57.319  -9.141  1.00 20.64           O  
ATOM    516  N   TYR A  64      15.578  53.705 -10.172  1.00 13.27           N  
ATOM    517  CA  TYR A  64      14.423  53.043 -10.800  1.00 13.52           C  
ATOM    518  C   TYR A  64      13.572  52.370  -9.746  1.00 13.50           C  
ATOM    519  O   TYR A  64      14.062  51.548  -8.960  1.00 13.65           O  
ATOM    520  CB  TYR A  64      14.946  52.011 -11.751  1.00 15.31           C  
ATOM    521  CG  TYR A  64      13.978  51.274 -12.622  1.00 16.65           C  
ATOM    522  CD1 TYR A  64      12.859  51.866 -13.144  1.00 19.38           C  
ATOM    523  CD2 TYR A  64      14.222  49.920 -12.933  1.00 17.85           C  
ATOM    524  CE1 TYR A  64      11.956  51.171 -13.961  1.00 21.61           C  
ATOM    525  CE2 TYR A  64      13.356  49.230 -13.755  1.00 21.86           C  
ATOM    526  CZ  TYR A  64      12.232  49.854 -14.265  1.00 21.96           C  
ATOM    527  OH  TYR A  64      11.369  49.154 -15.078  1.00 28.10           O  
ATOM    528  N   GLU A  65      12.277  52.723  -9.709  1.00 14.72           N  
ATOM    529  CA  GLU A  65      11.385  52.189  -8.638  1.00 15.47           C  
ATOM    530  C   GLU A  65      11.218  50.680  -8.695  1.00 14.80           C  
ATOM    531  O   GLU A  65      10.912  50.046  -7.679  1.00 16.31           O  
ATOM    532  CB  GLU A  65      10.029  52.876  -8.742  1.00 18.00           C  
ATOM    533  CG  GLU A  65      10.176  54.383  -8.561  1.00 26.37           C  
ATOM    534  CD  GLU A  65      10.370  55.183  -9.861  1.00 41.10           C  
ATOM    535  OE1 GLU A  65      10.804  54.659 -10.963  1.00 29.36           O  
ATOM    536  OE2 GLU A  65      10.049  56.385  -9.631  1.00 36.17           O  
ATOM    537  N   ARG A  66      11.417  50.094  -9.861  1.00 14.22           N  
ATOM    538  CA  ARG A  66      11.291  48.640 -10.023  1.00 14.15           C  
ATOM    539  C   ARG A  66      12.632  47.935  -9.878  1.00 13.18           C  
ATOM    540  O   ARG A  66      12.705  46.720 -10.047  1.00 13.77           O  
ATOM    541  CB  ARG A  66      10.672  48.317 -11.388  1.00 17.14           C  
ATOM    542  CG  ARG A  66       9.228  48.731 -11.511  1.00 18.49           C  
ATOM    543  CD  ARG A  66       8.628  48.331 -12.824  1.00 21.05           C  
ATOM    544  NE  ARG A  66       7.293  48.847 -12.986  1.00 21.50           N  
ATOM    545  CZ  ARG A  66       6.444  48.359 -13.883  1.00 24.59           C  
ATOM    546  NH1 ARG A  66       5.214  48.863 -13.999  1.00 34.97           N  
ATOM    547  NH2 ARG A  66       6.900  47.362 -14.609  1.00 31.58           N  
ATOM    548  N   GLY A  67      13.686  48.693  -9.538  1.00 13.02           N  
ATOM    549  CA  GLY A  67      15.017  48.118  -9.440  1.00 13.01           C  
ATOM    550  C   GLY A  67      15.376  47.651  -8.038  1.00 11.40           C  
ATOM    551  O   GLY A  67      14.552  47.711  -7.126  1.00 12.06           O  
ATOM    552  N   PHE A  68      16.582  47.147  -7.911  1.00 12.11           N  
ATOM    553  CA  PHE A  68      17.027  46.500  -6.681  1.00 11.61           C  
ATOM    554  C   PHE A  68      17.154  47.486  -5.534  1.00 11.63           C  
ATOM    555  O   PHE A  68      16.589  47.259  -4.450  1.00 11.66           O  
ATOM    556  CB  PHE A  68      18.365  45.798  -6.962  1.00 12.37           C  
ATOM    557  CG  PHE A  68      18.891  44.985  -5.819  1.00 11.94           C  
ATOM    558  CD1 PHE A  68      18.329  43.770  -5.504  1.00 12.26           C  
ATOM    559  CD2 PHE A  68      19.972  45.439  -5.075  1.00 12.49           C  
ATOM    560  CE1 PHE A  68      18.846  42.993  -4.491  1.00 13.22           C  
ATOM    561  CE2 PHE A  68      20.502  44.654  -4.048  1.00 13.02           C  
ATOM    562  CZ  PHE A  68      19.948  43.419  -3.764  1.00 13.05           C  
ATOM    563  N   TYR A  69      17.890  48.577  -5.715  1.00 11.24           N  
ATOM    564  CA  TYR A  69      18.150  49.476  -4.583  1.00 10.94           C  
ATOM    565  C   TYR A  69      16.875  50.039  -3.965  1.00 10.85           C  
ATOM    566  O   TYR A  69      16.755  50.142  -2.733  1.00 11.27           O  
ATOM    567  CB  TYR A  69      19.070  50.609  -4.990  1.00 11.51           C  
ATOM    568  CG  TYR A  69      19.664  51.386  -3.836  1.00 10.87           C  
ATOM    569  CD1 TYR A  69      20.822  50.923  -3.209  1.00 11.15           C  
ATOM    570  CD2 TYR A  69      19.134  52.579  -3.370  1.00 11.92           C  
ATOM    571  CE1 TYR A  69      21.391  51.612  -2.179  1.00 11.63           C  
ATOM    572  CE2 TYR A  69      19.687  53.294  -2.349  1.00 12.07           C  
ATOM    573  CZ  TYR A  69      20.826  52.799  -1.739  1.00 12.56           C  
ATOM    574  OH  TYR A  69      21.436  53.490  -0.707  1.00 14.41           O  
ATOM    575  N   LYS A  70      15.921  50.425  -4.803  1.00 10.95           N  
ATOM    576  CA  LYS A  70      14.701  51.037  -4.306  1.00 10.85           C  
ATOM    577  C   LYS A  70      13.827  50.082  -3.517  1.00 10.70           C  
ATOM    578  O   LYS A  70      13.022  50.524  -2.698  1.00 12.50           O  
ATOM    579  CB  LYS A  70      13.904  51.673  -5.453  1.00 12.62           C  
ATOM    580  CG  LYS A  70      14.438  53.047  -5.887  1.00 12.49           C  
ATOM    581  CD  LYS A  70      14.162  54.133  -4.877  1.00 13.74           C  
ATOM    582  CE  LYS A  70      14.618  55.514  -5.305  0.65 15.39           C  
ATOM    584  NZ  LYS A  70      13.809  56.148  -6.374  0.65 15.52           N  
ATOM    586  N   ALA A  71      13.975  48.746  -3.693  1.00 10.94           N  
ATOM    587  CA  ALA A  71      13.179  47.802  -2.896  1.00 10.72           C  
ATOM    588  C   ALA A  71      13.455  47.987  -1.403  1.00 10.34           C  
ATOM    589  O   ALA A  71      12.569  47.769  -0.579  1.00 11.44           O  
ATOM    590  CB  ALA A  71      13.478  46.378  -3.287  1.00 11.92           C  
ATOM    591  N   TRP A  72      14.710  48.347  -1.077  1.00 10.52           N  
ATOM    592  CA  TRP A  72      15.166  48.378   0.307  1.00 10.44           C  
ATOM    593  C   TRP A  72      15.295  49.771   0.884  1.00 10.65           C  
ATOM    594  O   TRP A  72      15.283  49.950   2.095  1.00 11.48           O  
ATOM    595  CB  TRP A  72      16.485  47.620   0.455  1.00 10.49           C  
ATOM    596  CG  TRP A  72      16.646  46.480  -0.489  1.00 10.54           C  
ATOM    597  CD1 TRP A  72      17.445  46.448  -1.579  1.00 10.67           C  
ATOM    598  CD2 TRP A  72      15.969  45.216  -0.459  1.00 10.99           C  
ATOM    599  NE1 TRP A  72      17.352  45.237  -2.250  1.00 11.36           N  
ATOM    600  CE2 TRP A  72      16.430  44.475  -1.558  1.00 10.92           C  
ATOM    601  CE3 TRP A  72      15.011  44.656   0.401  1.00 10.66           C  
ATOM    602  CZ2 TRP A  72      15.988  43.171  -1.837  1.00 11.50           C  
ATOM    603  CZ3 TRP A  72      14.578  43.372   0.121  1.00 11.58           C  
ATOM    604  CH2 TRP A  72      15.062  42.642  -0.984  1.00 12.16           C  
ATOM    605  N   HIS A  73      15.451  50.758  -0.011  1.00 11.04           N  
ATOM    606  CA  HIS A  73      15.778  52.151   0.332  0.58 10.68           C  
ATOM    608  C   HIS A  73      14.992  53.096  -0.573  0.58 11.86           C  
ATOM    610  O   HIS A  73      15.398  53.400  -1.689  0.58 12.50           O  
ATOM    612  CB  HIS A  73      17.253  52.479   0.163  1.00 11.45           C  
ATOM    613  CG  HIS A  73      18.230  51.398   0.389  1.00 10.91           C  
ATOM    614  ND1 HIS A  73      18.574  50.481  -0.566  1.00 11.00           N  
ATOM    615  CD2 HIS A  73      19.014  51.111   1.444  1.00 11.07           C  
ATOM    616  CE1 HIS A  73      19.497  49.671  -0.078  1.00 10.82           C  
ATOM    617  NE2 HIS A  73      19.786  50.017   1.167  1.00 10.55           N  
ATOM    618  N   SER A  74      13.851  53.499  -0.075  0.58 15.25           N  
ATOM    620  CA  SER A  74      12.941  54.260  -0.919  1.00 15.00           C  
ATOM    621  C   SER A  74      12.197  55.083   0.118  1.00 14.59           C  
ATOM    622  O   SER A  74      12.033  54.587   1.249  1.00 18.30           O  
ATOM    623  CB  SER A  74      11.892  53.463  -1.747  1.00 14.49           C  
ATOM    624  OG  SER A  74      10.975  54.374  -2.295  1.00 13.68           O  
ATOM    625  N   GLU A  75      11.650  56.213  -0.254  1.00 15.64           N  
ATOM    626  CA  GLU A  75      10.671  56.898   0.593  1.00 19.06           C  
ATOM    627  C   GLU A  75       9.437  56.035   0.831  1.00 16.30           C  
ATOM    628  O   GLU A  75       8.710  56.167   1.785  1.00 18.16           O  
ATOM    629  CB  GLU A  75      10.164  58.208  -0.023  1.00 27.82           C  
ATOM    630  CG  GLU A  75       8.675  58.261  -0.255  1.00 49.65           C  
ATOM    631  CD  GLU A  75       7.476  58.651   0.535  1.00 55.50           C  
ATOM    632  OE1 GLU A  75       7.193  58.078   1.631  1.00 77.94           O  
ATOM    633  OE2 GLU A  75       6.659  59.530   0.129  1.00 75.76           O  
ATOM    634  N   SER A  76       9.168  55.131  -0.126  1.00 13.86           N  
ATOM    635  CA  SER A  76       8.059  54.230   0.035  1.00 13.83           C  
ATOM    636  C   SER A  76       8.099  53.455   1.339  1.00 13.69           C  
ATOM    637  O   SER A  76       9.138  52.880   1.674  1.00 13.54           O  
ATOM    638  CB  SER A  76       8.076  53.210  -1.116  1.00 14.98           C  
ATOM    639  OG  SER A  76       7.110  52.194  -0.874  1.00 14.89           O  
ATOM    640  N   GLU A  77       6.982  53.364   2.009  1.00 14.54           N  
ATOM    641  CA  GLU A  77       6.899  52.585   3.238  1.00 14.26           C  
ATOM    642  C   GLU A  77       6.868  51.088   3.011  1.00 13.60           C  
ATOM    643  O   GLU A  77       6.818  50.349   4.001  1.00 14.53           O  
ATOM    644  CB  GLU A  77       5.665  53.042   4.058  1.00 16.58           C  
ATOM    645  CG  GLU A  77       5.811  54.493   4.494  1.00 17.85           C  
ATOM    646  CD  GLU A  77       4.664  54.981   5.346  1.00 24.56           C  
ATOM    647  OE1 GLU A  77       4.072  54.133   6.042  1.00 38.54           O  
ATOM    648  OE2 GLU A  77       4.387  56.219   5.343  1.00 26.85           O  
ATOM    649  N   ILE A  78       6.934  50.624   1.771  1.00 12.95           N  
ATOM    650  CA  ILE A  78       7.184  49.202   1.487  1.00 12.35           C  
ATOM    651  C   ILE A  78       8.638  48.850   1.711  1.00 12.11           C  
ATOM    652  O   ILE A  78       8.993  47.688   1.948  1.00 12.37           O  
ATOM    653  CB  ILE A  78       6.742  48.849   0.059  1.00 12.67           C  
ATOM    654  CG1 ILE A  78       5.264  49.229  -0.174  1.00 14.79           C  
ATOM    655  CG2 ILE A  78       6.973  47.402  -0.265  1.00 12.85           C  
ATOM    656  CD1 ILE A  78       4.839  49.149  -1.642  1.00 17.74           C  
ATOM    657  N   SER A  79       9.541  49.847   1.588  1.00 11.48           N  
ATOM    658  CA  SER A  79      10.958  49.556   1.697  1.00 11.40           C  
ATOM    659  C   SER A  79      11.390  49.509   3.186  1.00 11.42           C  
ATOM    660  O   SER A  79      10.784  50.121   4.053  1.00 12.09           O  
ATOM    661  CB  SER A  79      11.845  50.573   0.964  1.00 11.86           C  
ATOM    662  OG  SER A  79      12.002  51.781   1.734  1.00 14.47           O  
ATOM    663  N   CYS A  80      12.471  48.790   3.413  1.00 10.85           N  
ATOM    664  CA  CYS A  80      13.045  48.647   4.746  1.00 10.86           C  
ATOM    665  C   CYS A  80      13.267  50.010   5.375  1.00 11.00           C  
ATOM    666  O   CYS A  80      12.774  50.320   6.477  1.00 12.66           O  
ATOM    667  CB  CYS A  80      14.363  47.899   4.724  1.00 11.64           C  
ATOM    668  SG  CYS A  80      14.496  46.436   3.717  1.00 11.82           S  
ATOM    669  N   ARG A  81      14.023  50.864   4.668  1.00 11.65           N  
ATOM    670  CA  ARG A  81      14.387  52.151   5.297  1.00 12.05           C  
ATOM    671  C   ARG A  81      13.207  53.092   5.302  1.00 12.22           C  
ATOM    672  O   ARG A  81      13.078  53.921   6.233  1.00 13.79           O  
ATOM    673  CB  ARG A  81      15.616  52.686   4.585  1.00 12.96           C  
ATOM    674  CG  ARG A  81      16.291  53.824   5.284  1.00 13.70           C  
ATOM    675  CD  ARG A  81      17.710  54.042   4.761  1.00 13.93           C  
ATOM    676  NE  ARG A  81      18.369  55.103   5.499  1.00 14.62           N  
ATOM    677  CZ  ARG A  81      18.370  56.382   5.177  1.00 15.64           C  
ATOM    678  NH1 ARG A  81      17.754  56.841   4.099  1.00 17.00           N  
ATOM    679  NH2 ARG A  81      19.019  57.245   5.986  1.00 19.80           N  
ATOM    680  N   GLY A  82      12.363  53.031   4.277  1.00 12.17           N  
ATOM    681  CA  GLY A  82      11.222  53.928   4.212  1.00 14.00           C  
ATOM    682  C   GLY A  82      10.209  53.687   5.316  1.00 12.81           C  
ATOM    683  O   GLY A  82       9.655  54.619   5.893  1.00 14.55           O  
ATOM    684  N   CYS A  83       9.908  52.431   5.600  1.00 12.93           N  
ATOM    685  CA  CYS A  83       8.997  52.157   6.714  1.00 13.07           C  
ATOM    686  C   CYS A  83       9.621  52.594   8.048  1.00 13.25           C  
ATOM    687  O   CYS A  83       8.995  53.266   8.866  1.00 14.81           O  
ATOM    688  CB  CYS A  83       8.652  50.672   6.744  1.00 13.94           C  
ATOM    689  SG  CYS A  83       7.607  50.396   8.242  1.00 14.80           S  
ATOM    690  N   HIS A  84      10.893  52.215   8.269  1.00 13.02           N  
ATOM    691  CA  HIS A  84      11.487  52.602   9.554  1.00 13.61           C  
ATOM    692  C   HIS A  84      11.501  54.125   9.706  1.00 14.39           C  
ATOM    693  O   HIS A  84      11.186  54.629  10.775  1.00 15.98           O  
ATOM    694  CB  HIS A  84      12.879  52.025   9.666  1.00 13.54           C  
ATOM    695  CG  HIS A  84      12.974  50.524   9.681  1.00 13.12           C  
ATOM    696  ND1 HIS A  84      14.191  49.905   9.518  1.00 12.72           N  
ATOM    697  CD2 HIS A  84      12.070  49.525   9.823  1.00 12.82           C  
ATOM    698  CE1 HIS A  84      14.016  48.584   9.554  1.00 12.29           C  
ATOM    699  NE2 HIS A  84      12.756  48.303   9.739  1.00 12.40           N  
ATOM    700  N   LYS A  85      11.855  54.867   8.639  1.00 14.28           N  
ATOM    701  CA  LYS A  85      11.857  56.325   8.782  1.00 15.46           C  
ATOM    702  C   LYS A  85      10.462  56.854   9.061  1.00 17.90           C  
ATOM    703  O   LYS A  85      10.269  57.787   9.874  1.00 19.39           O  
ATOM    704  CB  LYS A  85      12.450  56.968   7.540  1.00 15.94           C  
ATOM    705  CG  LYS A  85      13.927  56.887   7.403  1.00 16.84           C  
ATOM    706  CD  LYS A  85      14.587  57.531   6.163  1.00 18.63           C  
ATOM    707  CE  LYS A  85      14.289  59.014   6.117  1.00 21.78           C  
ATOM    708  NZ  LYS A  85      15.133  59.622   5.021  1.00 25.19           N  
ATOM    709  N   ALA A  86       9.434  56.325   8.398  1.00 16.70           N  
ATOM    710  CA  ALA A  86       8.083  56.817   8.606  1.00 17.64           C  
ATOM    711  C   ALA A  86       7.606  56.534  10.020  1.00 18.52           C  
ATOM    712  O   ALA A  86       6.939  57.363  10.639  1.00 21.81           O  
ATOM    713  CB  ALA A  86       7.129  56.172   7.613  1.00 19.32           C  
ATOM    714  N   MET A  87       7.940  55.358  10.536  1.00 18.64           N  
ATOM    715  CA  MET A  87       7.535  54.999  11.900  1.00 19.46           C  
ATOM    716  C   MET A  87       8.264  55.865  12.901  1.00 19.44           C  
ATOM    717  O   MET A  87       7.677  56.340  13.871  1.00 23.67           O  
ATOM    718  CB  MET A  87       7.802  53.506  12.150  1.00 18.88           C  
ATOM    719  CG  MET A  87       6.883  52.619  11.312  1.00 19.02           C  
ATOM    720  SD  MET A  87       6.970  50.875  11.738  1.00 18.67           S  
ATOM    721  CE  MET A  87       6.063  50.877  13.317  1.00 25.52           C  
ATOM    722  N   LYS A  88       9.552  56.077  12.697  1.00 19.99           N  
ATOM    723  CA  LYS A  88      10.292  56.956  13.593  1.00 21.87           C  
ATOM    724  C   LYS A  88       9.716  58.361  13.623  1.00 25.83           C  
ATOM    725  O   LYS A  88       9.670  58.996  14.707  1.00 29.69           O  
ATOM    726  CB  LYS A  88      11.760  57.015  13.156  1.00 25.97           C  
ATOM    727  CG  LYS A  88      12.552  57.917  14.128  1.00 32.39           C  
ATOM    728  CD  LYS A  88      14.011  57.552  14.062  1.00 39.55           C  
ATOM    729  CE  LYS A  88      14.754  58.087  15.287  1.00 49.31           C  
ATOM    730  NZ  LYS A  88      14.489  59.546  15.468  1.00 56.92           N  
ATOM    731  N   ALA A  89       9.271  58.872  12.491  1.00 23.66           N  
ATOM    732  CA  ALA A  89       8.674  60.208  12.420  1.00 25.95           C  
ATOM    733  C   ALA A  89       7.390  60.268  13.236  1.00 30.20           C  
ATOM    734  O   ALA A  89       6.987  61.306  13.723  1.00 34.21           O  
ATOM    735  CB  ALA A  89       8.416  60.585  10.963  1.00 31.05           C  
ATOM    736  N   LYS A  90       6.716  59.140  13.413  1.00 28.20           N  
ATOM    737  CA  LYS A  90       5.532  59.030  14.246  1.00 33.23           C  
ATOM    738  C   LYS A  90       5.848  58.583  15.663  1.00 32.49           C  
ATOM    739  O   LYS A  90       4.931  58.328  16.432  1.00 38.90           O  
ATOM    740  CB  LYS A  90       4.562  58.005  13.646  1.00 33.66           C  
ATOM    741  CG  LYS A  90       3.938  58.393  12.307  1.00 36.44           C  
ATOM    742  CD  LYS A  90       3.555  57.085  11.635  1.00 40.06           C  
ATOM    743  CE  LYS A  90       2.429  57.164  10.638  1.00 42.62           C  
ATOM    744  NZ  LYS A  90       2.626  58.283   9.674  1.00 80.52           N  
ATOM    745  N   ASN A  91       7.103  58.478  16.052  1.00 32.75           N  
ATOM    746  CA  ASN A  91       7.460  58.051  17.413  1.00 35.24           C  
ATOM    747  C   ASN A  91       6.926  56.670  17.757  1.00 31.60           C  
ATOM    748  O   ASN A  91       6.548  56.342  18.869  1.00 33.29           O  
ATOM    749  CB  ASN A  91       6.933  59.060  18.434  0.70 35.25           C  
ATOM    751  CG  ASN A  91       7.490  58.781  19.824  0.70 39.59           C  
ATOM    753  OD1 ASN A  91       6.858  59.102  20.835  0.70 66.61           O  
ATOM    755  ND2 ASN A  91       8.667  58.176  19.845  0.70 46.07           N  
ATOM    757  N   GLU A  92       6.992  55.795  16.749  1.00 27.79           N  
ATOM    758  CA  GLU A  92       6.661  54.399  16.917  1.00 27.05           C  
ATOM    759  C   GLU A  92       7.916  53.538  16.919  1.00 24.59           C  
ATOM    760  O   GLU A  92       8.836  53.707  16.135  1.00 26.80           O  
ATOM    761  CB  GLU A  92       5.743  53.958  15.756  1.00 24.50           C  
ATOM    762  CG  GLU A  92       4.380  54.655  15.842  1.00 27.87           C  
ATOM    763  CD  GLU A  92       3.579  54.380  14.584  1.00 29.98           C  
ATOM    764  OE1 GLU A  92       4.159  53.789  13.658  1.00 36.24           O  
ATOM    765  OE2 GLU A  92       2.390  54.754  14.483  1.00 38.25           O  
ATOM    766  N   GLN A  93       7.980  52.551  17.804  1.00 27.73           N  
ATOM    767  CA  GLN A  93       9.062  51.584  17.836  1.00 27.10           C  
ATOM    768  C   GLN A  93       9.286  50.927  16.473  1.00 22.01           C  
ATOM    769  O   GLN A  93       8.341  50.438  15.844  1.00 22.11           O  
ATOM    770  CB  GLN A  93       8.714  50.464  18.829  1.00 30.34           C  
ATOM    771  CG  GLN A  93       9.901  49.566  19.157  1.00 43.90           C  
ATOM    772  CD  GLN A  93       9.659  48.649  20.330  1.00 60.18           C  
ATOM    773  OE1 GLN A  93       9.975  47.453  20.304  1.00 92.85           O  
ATOM    774  NE2 GLN A  93       9.078  49.121  21.424  1.00 69.70           N  
ATOM    775  N   THR A  94      10.521  50.911  15.983  1.00 20.07           N  
ATOM    776  CA  THR A  94      10.796  50.454  14.604  1.00 17.69           C  
ATOM    777  C   THR A  94      12.247  50.062  14.475  1.00 16.98           C  
ATOM    778  O   THR A  94      13.005  50.013  15.456  1.00 20.03           O  
ATOM    779  CB  THR A  94      10.375  51.574  13.657  1.00 17.04           C  
ATOM    780  OG1 THR A  94      10.298  51.033  12.314  1.00 17.01           O  
ATOM    781  CG2 THR A  94      11.295  52.767  13.640  1.00 18.06           C  
ATOM    782  N   GLY A  95      12.629  49.785  13.233  1.00 15.76           N  
ATOM    783  CA  GLY A  95      13.963  49.342  12.901  1.00 15.36           C  
ATOM    784  C   GLY A  95      14.937  50.458  12.582  1.00 15.81           C  
ATOM    785  O   GLY A  95      14.614  51.634  12.650  1.00 17.02           O  
ATOM    786  N   PRO A  96      16.158  50.058  12.251  1.00 16.01           N  
ATOM    787  CA  PRO A  96      17.244  51.016  12.028  1.00 16.57           C  
ATOM    788  C   PRO A  96      17.168  51.761  10.723  1.00 14.73           C  
ATOM    789  O   PRO A  96      16.620  51.318   9.711  1.00 14.35           O  
ATOM    790  CB  PRO A  96      18.512  50.142  12.052  1.00 18.54           C  
ATOM    791  CG  PRO A  96      18.035  48.774  11.659  1.00 17.73           C  
ATOM    792  CD  PRO A  96      16.645  48.658  12.200  1.00 16.01           C  
ATOM    793  N   ILE A  97      17.818  52.926  10.768  1.00 15.83           N  
ATOM    794  CA  ILE A  97      17.820  53.860   9.648  1.00 14.75           C  
ATOM    795  C   ILE A  97      19.215  54.206   9.176  1.00 14.54           C  
ATOM    796  O   ILE A  97      19.397  54.416   7.969  1.00 14.85           O  
ATOM    797  CB  ILE A  97      17.026  55.115  10.057  1.00 17.35           C  
ATOM    798  CG1 ILE A  97      15.541  54.742  10.314  1.00 18.15           C  
ATOM    799  CG2 ILE A  97      17.168  56.233   9.065  1.00 17.67           C  
ATOM    800  CD1 ILE A  97      14.797  55.782  11.148  1.00 20.07           C  
ATOM    801  N   GLY A  98      20.187  54.363  10.049  1.00 14.63           N  
ATOM    802  CA  GLY A  98      21.513  54.758   9.568  1.00 14.94           C  
ATOM    803  C   GLY A  98      22.084  53.666   8.678  1.00 13.94           C  
ATOM    804  O   GLY A  98      21.861  52.474   8.799  1.00 14.40           O  
ATOM    805  N   CYS A  99      22.918  54.079   7.723  1.00 14.29           N  
ATOM    806  CA  CYS A  99      23.394  53.179   6.696  1.00 14.07           C  
ATOM    807  C   CYS A  99      24.231  52.035   7.259  1.00 15.01           C  
ATOM    808  O   CYS A  99      24.249  50.974   6.623  1.00 15.41           O  
ATOM    809  CB  CYS A  99      24.226  53.897   5.647  1.00 13.90           C  
ATOM    810  SG  CYS A  99      23.357  55.265   4.814  1.00 14.10           S  
ATOM    811  N   LEU A 100      24.919  52.235   8.374  1.00 15.88           N  
ATOM    812  CA  LEU A 100      25.722  51.180   8.995  1.00 17.12           C  
ATOM    813  C   LEU A 100      25.115  50.681  10.319  1.00 17.61           C  
ATOM    814  O   LEU A 100      25.812  49.954  11.031  1.00 20.63           O  
ATOM    815  CB  LEU A 100      27.189  51.618   9.092  1.00 19.45           C  
ATOM    816  CG  LEU A 100      27.879  51.804   7.715  1.00 18.38           C  
ATOM    817  CD1 LEU A 100      29.292  52.288   7.904  1.00 27.80           C  
ATOM    818  CD2 LEU A 100      27.877  50.506   6.866  1.00 25.38           C  
ATOM    819  N   GLN A 101      23.840  51.010  10.588  1.00 16.10           N  
ATOM    820  CA  GLN A 101      23.152  50.517  11.766  1.00 17.24           C  
ATOM    821  C   GLN A 101      22.268  49.337  11.445  1.00 15.89           C  
ATOM    822  O   GLN A 101      21.334  49.484  10.671  1.00 15.27           O  
ATOM    823  CB  GLN A 101      22.254  51.628  12.334  1.00 17.64           C  
ATOM    824  CG  GLN A 101      23.052  52.821  12.888  1.00 19.12           C  
ATOM    825  CD  GLN A 101      22.146  53.854  13.506  1.00 22.76           C  
ATOM    826  OE1 GLN A 101      21.203  54.301  12.835  1.00 22.10           O  
ATOM    827  NE2 GLN A 101      22.407  54.238  14.748  1.00 25.52           N  
ATOM    828  N   GLY A 102      22.570  48.195  12.075  1.00 17.08           N  
ATOM    829  CA  GLY A 102      21.654  47.063  12.015  1.00 16.17           C  
ATOM    830  C   GLY A 102      21.766  46.303  10.707  1.00 15.92           C  
ATOM    831  O   GLY A 102      22.359  45.212  10.649  1.00 20.20           O  
ATOM    832  N   CYS A 103      21.194  46.814   9.626  1.00 14.05           N  
ATOM    833  CA  CYS A 103      21.113  46.079   8.384  1.00 13.66           C  
ATOM    834  C   CYS A 103      22.498  45.746   7.821  1.00 13.55           C  
ATOM    835  O   CYS A 103      22.790  44.604   7.526  1.00 15.18           O  
ATOM    836  CB  CYS A 103      20.258  46.844   7.339  1.00 12.96           C  
ATOM    837  SG  CYS A 103      18.645  47.231   8.028  1.00 13.47           S  
ATOM    838  N   HIS A 104      23.329  46.810   7.696  1.00 13.82           N  
ATOM    839  CA  HIS A 104      24.673  46.653   7.190  1.00 14.31           C  
ATOM    840  C   HIS A 104      25.681  46.678   8.320  1.00 18.76           C  
ATOM    841  O   HIS A 104      26.661  47.314   8.292  1.00 29.53           O  
ATOM    842  CB  HIS A 104      24.996  47.762   6.144  1.00 14.04           C  
ATOM    843  CG  HIS A 104      24.031  47.765   4.991  1.00 12.38           C  
ATOM    844  ND1 HIS A 104      23.985  46.747   4.059  1.00 13.06           N  
ATOM    845  CD2 HIS A 104      23.124  48.680   4.543  1.00 12.31           C  
ATOM    846  CE1 HIS A 104      23.065  47.079   3.142  1.00 12.34           C  
ATOM    847  NE2 HIS A 104      22.513  48.222   3.409  1.00 11.98           N  
ATOM    848  N   GLU A 105      25.377  45.921   9.390  1.00 24.82           N  
ATOM    849  CA  GLU A 105      26.212  45.721  10.538  1.00 27.98           C  
ATOM    850  C   GLU A 105      26.310  44.269  10.967  1.00 31.40           C  
ATOM    851  O   GLU A 105      25.402  43.461  10.718  1.00 36.46           O  
ATOM    852  CB  GLU A 105      25.552  46.439  11.723  1.00 30.38           C  
ATOM    853  CG  GLU A 105      26.322  46.448  13.020  1.00 37.51           C  
ATOM    854  CD  GLU A 105      25.663  47.223  14.149  1.00 41.18           C  
ATOM    855  OE1 GLU A 105      24.586  47.830  13.980  1.00 26.70           O  
ATOM    856  OE2 GLU A 105      26.219  47.263  15.279  1.00 45.75           O  
ATOM    857  N   ALA A 106      27.339  43.856  11.673  1.00 37.62           N  
ATOM    858  CA  ALA A 106      27.498  42.610  12.347  1.00 39.82           C  
ATOM    859  C   ALA A 106      26.395  42.465  13.421  1.00 46.17           C  
ATOM    860  O   ALA A 106      26.231  43.435  14.191  1.00 81.86           O  
ATOM    861  CB  ALA A 106      28.839  42.580  13.020  1.00 49.57           C  
TER     862      ALA A 106                                                      
END
MOLECULE T0513_17_85.pdb
ATOM    136  N   ASN    17      17.209  32.934  15.316  1.00 20.86           N  
ATOM    137  CA  ASN    17      16.055  33.821  15.215  1.00 21.30           C  
ATOM    138  C   ASN    17      16.030  34.653  13.915  1.00 19.81           C  
ATOM    139  O   ASN    17      15.279  35.635  13.809  1.00 22.73           O  
ATOM    140  CB  ASN    17      15.951  34.697  16.480  1.00 20.06           C  
ATOM    141  CG  ASN    17      14.625  35.442  16.589  1.00 20.33           C  
ATOM    142  OD1 ASN    17      14.596  36.674  16.657  1.00 26.71           O  
ATOM    143  ND2 ASN    17      13.524  34.701  16.602  1.00 25.28           N  
ATOM    144  N   PHE    18      16.863  34.266  12.950  1.00 22.83           N  
ATOM    145  CA  PHE    18      17.038  34.993  11.685  1.00 20.77           C  
ATOM    146  C   PHE    18      16.729  34.131  10.466  1.00 26.09           C  
ATOM    147  O   PHE    18      16.856  32.904  10.510  1.00 23.90           O  
ATOM    148  CB  PHE    18      18.489  35.478  11.537  1.00 20.07           C  
ATOM    149  CG  PHE    18      18.897  36.501  12.565  1.00 21.76           C  
ATOM    150  CD1 PHE    18      18.942  37.859  12.237  1.00 24.52           C  
ATOM    151  CD2 PHE    18      19.251  36.104  13.865  1.00 24.38           C  
ATOM    152  CE1 PHE    18      19.316  38.798  13.175  1.00 21.09           C  
ATOM    153  CE2 PHE    18      19.629  37.040  14.816  1.00 27.62           C  
ATOM    154  CZ  PHE    18      19.662  38.396  14.477  1.00 22.52           C  
ATOM    155  N   VAL    19      16.347  34.797   9.371  1.00 23.29           N  
ATOM    156  CA  VAL    19      16.190  34.157   8.064  1.00 23.44           C  
ATOM    157  C   VAL    19      17.116  34.822   7.054  1.00 23.87           C  
ATOM    158  O   VAL    19      17.450  36.007   7.186  1.00 26.05           O  
ATOM    159  CB  VAL    19      14.722  34.166   7.535  1.00 26.11           C  
ATOM    160  CG1 VAL    19      13.813  33.322   8.418  1.00 29.80           C  
ATOM    161  CG2 VAL    19      14.181  35.594   7.420  1.00 26.39           C  
ATOM    162  N   ARG    20      17.533  34.023   6.065  1.00 21.52           N  
ATOM    163  CA  ARG    20      18.422  34.472   4.999  0.50 25.24           C  
ATOM    165  C   ARG    20      17.799  35.611   4.197  1.00 23.67           C  
ATOM    166  O   ARG    20      16.602  35.598   3.885  1.00 26.54           O  
ATOM    167  CB  ARG    20      18.765  33.299   4.066  0.50 26.19           C  
ATOM    169  CG  ARG    20      19.517  32.169   4.752  0.50 32.31           C  
ATOM    171  CD  ARG    20      19.716  30.936   3.868  0.50 37.64           C  
ATOM    173  NE  ARG    20      21.039  30.345   4.075  0.50 32.60           N  
ATOM    175  CZ  ARG    20      21.962  30.231   3.123  0.50 38.95           C  
ATOM    177  NH1 ARG    20      23.143  29.697   3.411  0.50 43.99           N  
ATOM    179  NH2 ARG    20      21.705  30.634   1.880  0.50 28.71           N  
ATOM    181  N   PHE    21      18.612  36.600   3.890  1.00 20.41           N  
ATOM    182  CA  PHE    21      18.195  37.664   2.981  1.00 19.15           C  
ATOM    183  C   PHE    21      18.908  37.400   1.650  1.00 22.86           C  
ATOM    184  O   PHE    21      20.145  37.355   1.582  1.00 21.81           O  
ATOM    185  CB  PHE    21      18.522  39.041   3.558  1.00 21.05           C  
ATOM    186  CG  PHE    21      18.246  40.177   2.615  1.00 24.51           C  
ATOM    187  CD1 PHE    21      17.130  40.161   1.782  1.00 25.06           C  
ATOM    188  CD2 PHE    21      19.075  41.286   2.588  1.00 26.03           C  
ATOM    189  CE1 PHE    21      16.873  41.200   0.908  1.00 32.51           C  
ATOM    190  CE2 PHE    21      18.810  42.341   1.700  1.00 24.87           C  
ATOM    191  CZ  PHE    21      17.706  42.282   0.869  1.00 21.39           C  
ATOM    192  N   VAL    22      18.104  37.221   0.606  1.00 23.08           N  
ATOM    193  CA  VAL    22      18.559  36.692  -0.692  1.00 20.41           C  
ATOM    194  C   VAL    22      18.247  37.636  -1.870  1.00 23.08           C  
ATOM    195  O   VAL    22      17.138  38.165  -1.984  1.00 23.12           O  
ATOM    196  CB  VAL    22      17.935  35.297  -0.938  1.00 20.68           C  
ATOM    197  CG1 VAL    22      18.300  34.736  -2.328  1.00 23.11           C  
ATOM    198  CG2 VAL    22      18.358  34.340   0.161  1.00 27.48           C  
ATOM    199  N   ILE    23      19.243  37.852  -2.723  1.00 24.77           N  
ATOM    200  CA  ILE    23      19.057  38.610  -3.967  1.00 27.98           C  
ATOM    201  C   ILE    23      19.535  37.726  -5.131  1.00 32.10           C  
ATOM    202  O   ILE    23      20.708  37.296  -5.164  1.00 25.66           O  
ATOM    203  CB  ILE    23      19.843  39.955  -3.981  1.00 31.42           C  
ATOM    204  CG1 ILE    23      19.464  40.859  -2.795  1.00 24.84           C  
ATOM    205  CG2 ILE    23      19.614  40.727  -5.293  1.00 31.38           C  
ATOM    206  CD1 ILE    23      20.302  42.150  -2.745  1.00 24.85           C  
ATOM    207  N   GLU    24      18.619  37.471  -6.067  1.00 35.79           N  
ATOM    208  CA  GLU    24      18.867  36.635  -7.256  1.00 40.85           C  
ATOM    209  C   GLU    24      19.596  35.344  -6.899  1.00 38.68           C  
ATOM    210  O   GLU    24      20.621  35.030  -7.497  1.00 39.34           O  
ATOM    211  CB  GLU    24      19.661  37.404  -8.330  1.00 41.46           C  
ATOM    212  CG  GLU    24      19.095  38.765  -8.702  1.00 58.88           C  
ATOM    213  CD  GLU    24      17.908  38.707  -9.655  1.00 71.12           C  
ATOM    214  OE1 GLU    24      17.830  37.743 -10.453  1.00 72.33           O  
ATOM    215  OE2 GLU    24      17.060  39.637  -9.610  1.00 72.59           O  
ATOM    216  N   GLY    25      19.097  34.634  -5.890  1.00 38.63           N  
ATOM    217  CA  GLY    25      19.656  33.332  -5.487  1.00 35.84           C  
ATOM    218  C   GLY    25      20.919  33.370  -4.642  1.00 39.23           C  
ATOM    219  O   GLY    25      21.433  32.320  -4.260  1.00 36.34           O  
ATOM    220  N   ARG    26      21.434  34.570  -4.363  1.00 31.50           N  
ATOM    221  CA  ARG    26      22.645  34.735  -3.546  1.00 31.87           C  
ATOM    222  C   ARG    26      22.285  35.258  -2.152  1.00 27.89           C  
ATOM    223  O   ARG    26      21.606  36.279  -2.051  1.00 25.53           O  
ATOM    224  CB  ARG    26      23.601  35.715  -4.232  1.00 34.35           C  
ATOM    225  CG  ARG    26      24.062  35.266  -5.640  1.00 46.09           C  
ATOM    226  CD  ARG    26      24.650  33.842  -5.609  1.00 67.45           C  
ATOM    227  NE  ARG    26      24.739  33.221  -6.934  1.00 79.26           N  
ATOM    228  CZ  ARG    26      25.765  33.359  -7.774  1.00 81.40           C  
ATOM    229  NH1 ARG    26      26.814  34.109  -7.449  1.00 76.67           N  
ATOM    230  NH2 ARG    26      25.738  32.746  -8.951  1.00 81.53           N  
ATOM    231  N   ARG    27      22.741  34.579  -1.097  1.00 28.09           N  
ATOM    232  CA  ARG    27      22.516  35.067   0.266  1.00 29.86           C  
ATOM    233  C   ARG    27      23.404  36.265   0.561  1.00 27.38           C  
ATOM    234  O   ARG    27      24.632  36.167   0.521  1.00 27.76           O  
ATOM    235  CB  ARG    27      22.714  33.994   1.345  1.00 28.19           C  
ATOM    236  CG  ARG    27      22.185  34.495   2.724  1.00 27.64           C  
ATOM    237  CD  ARG    27      22.737  33.767   3.968  1.00 32.43           C  
ATOM    238  NE  ARG    27      24.189  33.836   4.100  1.00 26.50           N  
ATOM    239  CZ  ARG    27      24.855  34.923   4.495  1.00 32.07           C  
ATOM    240  NH1 ARG    27      24.213  36.047   4.809  1.00 26.92           N  
ATOM    241  NH2 ARG    27      26.169  34.892   4.579  1.00 32.44           N  
ATOM    242  N   VAL    28      22.789  37.414   0.846  1.00 18.52           N  
ATOM    243  CA  VAL    28      23.609  38.605   1.129  1.00 22.68           C  
ATOM    244  C   VAL    28      23.372  39.166   2.544  1.00 22.19           C  
ATOM    245  O   VAL    28      23.990  40.150   2.928  1.00 22.40           O  
ATOM    246  CB  VAL    28      23.365  39.738   0.098  1.00 24.96           C  
ATOM    247  CG1 VAL    28      23.876  39.321  -1.282  1.00 24.70           C  
ATOM    248  CG2 VAL    28      21.873  40.109   0.066  1.00 28.33           C  
ATOM    249  N   GLY    29      22.451  38.565   3.285  1.00 20.83           N  
ATOM    250  CA  GLY    29      22.212  38.997   4.657  1.00 15.98           C  
ATOM    251  C   GLY    29      21.388  38.062   5.499  1.00 19.37           C  
ATOM    252  O   GLY    29      21.164  36.897   5.142  1.00 24.06           O  
ATOM    253  N   TRP    30      20.973  38.584   6.649  1.00 19.03           N  
ATOM    254  CA  TRP    30      20.178  37.855   7.647  1.00 17.42           C  
ATOM    255  C   TRP    30      19.232  38.867   8.246  1.00 20.49           C  
ATOM    256  O   TRP    30      19.659  39.943   8.660  1.00 20.00           O  
ATOM    257  CB  TRP    30      21.042  37.350   8.791  1.00 23.22           C  
ATOM    258  CG  TRP    30      22.128  36.434   8.394  1.00 25.03           C  
ATOM    259  CD1 TRP    30      23.468  36.727   8.254  1.00 27.24           C  
ATOM    260  CD2 TRP    30      21.986  35.054   8.118  1.00 28.67           C  
ATOM    261  NE1 TRP    30      24.156  35.601   7.893  1.00 31.31           N  
ATOM    262  CE2 TRP    30      23.274  34.556   7.803  1.00 28.47           C  
ATOM    263  CE3 TRP    30      20.896  34.186   8.096  1.00 24.83           C  
ATOM    264  CZ2 TRP    30      23.501  33.216   7.473  1.00 36.90           C  
ATOM    265  CZ3 TRP    30      21.118  32.847   7.769  1.00 36.21           C  
ATOM    266  CH2 TRP    30      22.413  32.379   7.460  1.00 31.44           C  
ATOM    267  N   VAL    31      17.957  38.507   8.323  1.00 17.37           N  
ATOM    268  CA  VAL    31      16.909  39.418   8.827  1.00 19.85           C  
ATOM    269  C   VAL    31      16.218  38.708   9.974  1.00 18.71           C  
ATOM    270  O   VAL    31      15.887  37.527   9.863  1.00 18.44           O  
ATOM    271  CB  VAL    31      15.901  39.734   7.689  1.00 24.44           C  
ATOM    272  CG1 VAL    31      14.615  40.380   8.198  1.00 28.37           C  
ATOM    273  CG2 VAL    31      16.560  40.638   6.637  1.00 24.28           C  
ATOM    274  N   ARG    32      16.008  39.417  11.082  1.00 18.35           N  
ATOM    275  CA  ARG    32      15.317  38.839  12.248  1.00 18.09           C  
ATOM    276  C   ARG    32      13.910  38.390  11.843  1.00 20.69           C  
ATOM    277  O   ARG    32      13.289  39.032  11.011  1.00 20.50           O  
ATOM    278  CB  ARG    32      15.253  39.853  13.387  1.00 26.61           C  
ATOM    279  CG  ARG    32      15.330  39.189  14.723  1.00 39.40           C  
ATOM    280  CD  ARG    32      15.433  40.164  15.878  1.00 32.98           C  
ATOM    281  NE  ARG    32      16.788  40.385  16.397  1.00 27.34           N  
ATOM    282  CZ  ARG    32      17.559  39.468  16.999  1.00 31.20           C  
ATOM    283  NH1 ARG    32      17.168  38.216  17.147  1.00 23.24           N  
ATOM    284  NH2 ARG    32      18.758  39.802  17.443  1.00 29.28           N  
ATOM    285  N   LYS    33      13.453  37.255  12.362  1.00 20.44           N  
ATOM    286  CA  LYS    33      12.118  36.739  11.984  1.00 24.51           C  
ATOM    287  C   LYS    33      10.963  37.745  12.142  1.00 23.04           C  
ATOM    288  O   LYS    33      10.120  37.859  11.246  1.00 20.15           O  
ATOM    289  CB  LYS    33      11.813  35.443  12.738  1.00 25.25           C  
ATOM    290  CG  LYS    33      12.553  34.232  12.191  1.00 24.38           C  
ATOM    291  CD  LYS    33      12.538  33.069  13.190  1.00 22.85           C  
ATOM    292  CE  LYS    33      13.393  31.904  12.653  1.00 29.69           C  
ATOM    293  NZ  LYS    33      13.288  30.715  13.555  1.00 33.21           N  
ATOM    294  N   ALA    34      10.908  38.463  13.263  1.00 23.39           N  
ATOM    295  CA  ALA    34       9.837  39.486  13.438  1.00 23.82           C  
ATOM    296  C   ALA    34       9.931  40.608  12.392  1.00 21.06           C  
ATOM    297  O   ALA    34       8.915  41.079  11.869  1.00 23.26           O  
ATOM    298  CB  ALA    34       9.838  40.053  14.861  1.00 24.14           C  
ATOM    299  N   LEU    35      11.150  41.021  12.057  1.00 21.64           N  
ATOM    300  CA  LEU    35      11.318  42.030  11.020  1.00 22.65           C  
ATOM    301  C   LEU    35      10.867  41.492   9.646  1.00 20.58           C  
ATOM    302  O   LEU    35      10.277  42.233   8.860  1.00 21.78           O  
ATOM    303  CB  LEU    35      12.768  42.517  10.957  1.00 18.60           C  
ATOM    304  CG  LEU    35      13.159  43.481   9.832  1.00 21.60           C  
ATOM    305  CD1 LEU    35      12.357  44.782   9.930  1.00 22.31           C  
ATOM    306  CD2 LEU    35      14.625  43.774   9.959  1.00 17.99           C  
ATOM    307  N   ALA    36      11.134  40.209   9.376  1.00 20.53           N  
ATOM    308  CA  ALA    36      10.707  39.572   8.135  1.00 24.82           C  
ATOM    309  C   ALA    36       9.195  39.669   7.995  1.00 25.43           C  
ATOM    310  O   ALA    36       8.695  39.931   6.891  1.00 25.13           O  
ATOM    311  CB  ALA    36      11.176  38.108   8.077  1.00 18.16           C  
ATOM    312  N   GLN    37       8.487  39.531   9.128  1.00 19.18           N  
ATOM    313  CA  GLN    37       7.026  39.711   9.172  1.00 21.96           C  
ATOM    314  C   GLN    37       6.611  41.128   8.806  1.00 24.15           C  
ATOM    315  O   GLN    37       5.595  41.324   8.129  1.00 28.98           O  
ATOM    316  CB  GLN    37       6.450  39.304  10.526  1.00 24.96           C  
ATOM    317  CG  GLN    37       6.470  37.799  10.786  1.00 41.37           C  
ATOM    318  CD  GLN    37       5.780  36.990   9.688  1.00 51.39           C  
ATOM    319  OE1 GLN    37       4.587  37.161   9.429  1.00 45.08           O  
ATOM    320  NE2 GLN    37       6.534  36.104   9.043  1.00 47.83           N  
ATOM    321  N   ARG    38       7.402  42.119   9.220  1.00 23.70           N  
ATOM    322  CA  ARG    38       7.148  43.510   8.841  0.50 22.14           C  
ATOM    324  C   ARG    38       7.373  43.714   7.341  1.00 27.87           C  
ATOM    325  O   ARG    38       6.623  44.433   6.689  1.00 25.76           O  
ATOM    326  CB  ARG    38       8.025  44.495   9.637  0.50 24.12           C  
ATOM    328  CG  ARG    38       7.914  44.432  11.169  0.50 21.02           C  
ATOM    330  CD  ARG    38       6.591  45.017  11.738  0.50 19.70           C  
ATOM    332  NE  ARG    38       5.452  44.110  11.583  0.50 18.95           N  
ATOM    334  CZ  ARG    38       5.293  42.965  12.246  0.50 23.77           C  
ATOM    336  NH1 ARG    38       4.217  42.214  12.017  0.50 28.31           N  
ATOM    338  NH2 ARG    38       6.198  42.563  13.140  0.50 29.77           N  
ATOM    340  N   LEU    39       8.399  43.069   6.804  1.00 27.55           N  
ATOM    341  CA  LEU    39       8.758  43.182   5.394  1.00 26.92           C  
ATOM    342  C   LEU    39       7.715  42.557   4.451  1.00 28.70           C  
ATOM    343  O   LEU    39       7.550  42.940   3.331  1.00 27.28           O  
ATOM    344  CB  LEU    39      10.122  42.556   5.162  1.00 23.52           C  
ATOM    345  CG  LEU    39      11.339  43.205   5.783  1.00 21.20           C  
ATOM    346  CD1 LEU    39      12.583  42.462   5.385  1.00 23.20           C  
ATOM    347  CD2 LEU    39      11.462  44.614   5.429  1.00 23.96           C  
ATOM    348  N   LYS    40       7.035  41.573   4.967  1.00 24.98           N  
ATOM    349  CA  LYS    40       5.956  40.906   4.311  1.00 32.51           C  
ATOM    350  C   LYS    40       4.847  41.820   3.842  1.00 33.88           C  
ATOM    351  O   LYS    40       4.201  41.545   2.891  1.00 34.37           O  
ATOM    352  CB  LYS    40       5.398  39.871   5.265  1.00 35.26           C  
ATOM    353  CG  LYS    40       4.833  38.712   4.620  1.00 42.25           C  
ATOM    354  CD  LYS    40       4.215  37.788   5.581  1.00 47.99           C  
ATOM    355  CE  LYS    40       5.219  36.895   6.146  1.00 56.22           C  
ATOM    356  NZ  LYS    40       4.614  35.738   6.844  1.00 65.56           N  
ATOM    357  N   ALA    41       4.651  42.919   4.534  1.00 33.32           N  
ATOM    358  CA  ALA    41       3.654  43.879   4.166  1.00 26.43           C  
ATOM    359  C   ALA    41       4.055  44.652   2.919  1.00 31.43           C  
ATOM    360  O   ALA    41       3.262  45.313   2.315  1.00 31.38           O  
ATOM    361  CB  ALA    41       3.446  44.781   5.243  1.00 28.22           C  
ATOM    362  N   HIS    42       5.315  44.560   2.560  1.00 22.14           N  
ATOM    363  CA  HIS    42       5.782  45.155   1.354  1.00 22.67           C  
ATOM    364  C   HIS    42       5.977  44.112   0.240  1.00 24.61           C  
ATOM    365  O   HIS    42       7.041  43.935  -0.242  1.00 21.94           O  
ATOM    366  CB  HIS    42       7.064  45.909   1.625  1.00 23.33           C  
ATOM    367  CG  HIS    42       6.906  47.023   2.603  1.00 26.26           C  
ATOM    368  ND1 HIS    42       6.771  48.327   2.211  1.00 28.75           N  
ATOM    369  CD2 HIS    42       6.846  47.032   3.946  1.00 27.23           C  
ATOM    370  CE1 HIS    42       6.650  49.092   3.270  1.00 29.65           C  
ATOM    371  NE2 HIS    42       6.684  48.330   4.335  1.00 22.96           N  
ATOM    372  N   GLY    43       4.902  43.451  -0.118  1.00 21.77           N  
ATOM    373  CA  GLY    43       4.938  42.357  -1.055  1.00 24.76           C  
ATOM    374  C   GLY    43       5.412  42.645  -2.467  1.00 28.20           C  
ATOM    375  O   GLY    43       5.741  41.776  -3.184  1.00 25.79           O  
ATOM    376  N   ARG    44       5.456  43.907  -2.835  1.00 21.72           N  
ATOM    377  CA  ARG    44       5.914  44.304  -4.161  1.00 24.32           C  
ATOM    378  C   ARG    44       7.437  44.361  -4.225  1.00 20.86           C  
ATOM    379  O   ARG    44       8.019  44.447  -5.305  1.00 23.65           O  
ATOM    380  CB  ARG    44       5.321  45.661  -4.548  1.00 22.47           C  
ATOM    381  CG  ARG    44       3.815  45.643  -4.754  1.00 21.53           C  
ATOM    382  CD  ARG    44       3.289  47.028  -5.094  1.00 22.88           C  
ATOM    383  NE  ARG    44       3.817  47.518  -6.364  1.00 23.77           N  
ATOM    384  CZ  ARG    44       3.800  48.793  -6.738  1.00 28.40           C  
ATOM    385  NH1 ARG    44       3.279  49.714  -5.938  1.00 23.25           N  
ATOM    386  NH2 ARG    44       4.303  49.149  -7.912  1.00 22.34           N  
ATOM    387  N   VAL    45       8.075  44.311  -3.060  1.00 16.84           N  
ATOM    388  CA  VAL    45       9.532  44.444  -2.974  1.00 19.47           C  
ATOM    389  C   VAL    45      10.146  43.169  -2.404  1.00 21.56           C  
ATOM    390  O   VAL    45      11.226  42.779  -2.841  1.00 22.98           O  
ATOM    391  CB  VAL    45       9.907  45.652  -2.097  1.00 19.99           C  
ATOM    392  CG1 VAL    45      11.447  45.847  -1.919  1.00 21.44           C  
ATOM    393  CG2 VAL    45       9.247  46.952  -2.669  1.00 21.74           C  
ATOM    394  N   PHE    46       9.484  42.556  -1.421  1.00 23.63           N  
ATOM    395  CA  PHE    46      10.014  41.345  -0.749  1.00 20.04           C  
ATOM    396  C   PHE    46       9.057  40.164  -0.851  1.00 26.86           C  
ATOM    397  O   PHE    46       7.859  40.313  -0.628  1.00 28.56           O  
ATOM    398  CB  PHE    46      10.268  41.631   0.747  1.00 21.13           C  
ATOM    399  CG  PHE    46      11.314  42.678   1.005  1.00 21.58           C  
ATOM    400  CD1 PHE    46      12.673  42.366   0.922  1.00 26.18           C  
ATOM    401  CD2 PHE    46      10.942  43.978   1.337  1.00 23.12           C  
ATOM    402  CE1 PHE    46      13.650  43.337   1.165  1.00 24.11           C  
ATOM    403  CE2 PHE    46      11.889  44.948   1.576  1.00 21.14           C  
ATOM    404  CZ  PHE    46      13.251  44.646   1.504  1.00 17.18           C  
ATOM    405  N   ASP    47       9.590  38.987  -1.178  1.00 20.78           N  
ATOM    406  CA  ASP    47       8.849  37.730  -1.002  1.00 24.46           C  
ATOM    407  C   ASP    47       9.338  37.080   0.284  1.00 26.67           C  
ATOM    408  O   ASP    47      10.537  36.823   0.431  1.00 31.75           O  
ATOM    409  CB  ASP    47       9.107  36.797  -2.180  1.00 32.25           C  
ATOM    410  CG  ASP    47       8.665  37.398  -3.500  1.00 45.29           C  
ATOM    411  OD1 ASP    47       7.537  37.927  -3.556  1.00 49.98           O  
ATOM    412  OD2 ASP    47       9.446  37.343  -4.473  1.00 54.42           O  
ATOM    413  N   VAL    48       8.430  36.834   1.220  1.00 27.58           N  
ATOM    414  CA  VAL    48       8.826  36.313   2.532  1.00 30.03           C  
ATOM    415  C   VAL    48       8.249  34.926   2.741  1.00 33.16           C  
ATOM    416  O   VAL    48       7.034  34.738   2.683  1.00 34.75           O  
ATOM    417  CB  VAL    48       8.411  37.276   3.708  1.00 29.61           C  
ATOM    418  CG1 VAL    48       8.797  36.679   5.070  1.00 29.77           C  
ATOM    419  CG2 VAL    48       9.052  38.643   3.525  1.00 31.49           C  
ATOM    420  N   THR    49       9.133  33.957   2.966  1.00 28.52           N  
ATOM    421  CA  THR    49       8.723  32.591   3.293  1.00 33.79           C  
ATOM    422  C   THR    49       9.204  32.264   4.698  1.00 37.87           C  
ATOM    423  O   THR    49       9.802  33.109   5.366  1.00 34.40           O  
ATOM    424  CB  THR    49       9.305  31.582   2.285  1.00 33.24           C  
ATOM    425  OG1 THR    49      10.733  31.717   2.232  1.00 42.54           O  
ATOM    426  CG2 THR    49       8.726  31.811   0.890  1.00 38.14           C  
ATOM    427  N   ARG    50       8.966  31.031   5.134  1.00 46.46           N  
ATOM    428  CA  ARG    50       9.394  30.554   6.452  1.00 50.39           C  
ATOM    429  C   ARG    50      10.920  30.552   6.612  1.00 42.25           C  
ATOM    430  O   ARG    50      11.437  30.711   7.717  1.00 50.08           O  
ATOM    431  CB  ARG    50       8.833  29.143   6.689  1.00 51.10           C  
ATOM    432  CG  ARG    50       8.908  28.632   8.125  1.00 65.81           C  
ATOM    433  CD  ARG    50       8.648  27.129   8.184  1.00 65.65           C  
ATOM    434  NE  ARG    50       9.511  26.455   9.160  1.00 82.09           N  
ATOM    435  CZ  ARG    50       9.228  26.304  10.454  1.00 86.34           C  
ATOM    436  NH1 ARG    50       8.094  26.778  10.958  1.00 87.28           N  
ATOM    437  NH2 ARG    50      10.086  25.675  11.248  1.00 84.79           N  
ATOM    438  N   ASP    51      11.629  30.389   5.503  1.00 32.87           N  
ATOM    439  CA  ASP    51      13.077  30.235   5.527  1.00 37.90           C  
ATOM    440  C   ASP    51      13.855  31.424   4.946  1.00 33.77           C  
ATOM    441  O   ASP    51      15.081  31.474   5.085  1.00 33.12           O  
ATOM    442  CB  ASP    51      13.488  28.953   4.773  1.00 46.29           C  
ATOM    443  CG  ASP    51      12.793  27.692   5.302  1.00 57.41           C  
ATOM    444  OD1 ASP    51      12.856  27.426   6.522  1.00 66.19           O  
ATOM    445  OD2 ASP    51      12.195  26.956   4.484  1.00 61.45           O  
ATOM    446  N   ALA    52      13.176  32.363   4.277  1.00 29.51           N  
ATOM    447  CA  ALA    52      13.909  33.400   3.549  1.00 31.37           C  
ATOM    448  C   ALA    52      13.112  34.666   3.256  1.00 27.18           C  
ATOM    449  O   ALA    52      11.890  34.637   3.109  1.00 27.33           O  
ATOM    450  CB  ALA    52      14.477  32.834   2.236  1.00 32.40           C  
ATOM    451  N   VAL    53      13.844  35.771   3.191  1.00 24.06           N  
ATOM    452  CA  VAL    53      13.359  37.013   2.627  1.00 23.42           C  
ATOM    453  C   VAL    53      14.046  37.168   1.268  1.00 27.83           C  
ATOM    454  O   VAL    53      15.281  37.291   1.186  1.00 26.26           O  
ATOM    455  CB  VAL    53      13.720  38.216   3.535  1.00 22.71           C  
ATOM    456  CG1 VAL    53      13.313  39.521   2.909  1.00 23.66           C  
ATOM    457  CG2 VAL    53      13.050  38.097   4.878  1.00 24.13           C  
ATOM    458  N   LEU    54      13.253  37.153   0.201  1.00 22.46           N  
ATOM    459  CA  LEU    54      13.779  37.276  -1.151  1.00 22.52           C  
ATOM    460  C   LEU    54      13.415  38.629  -1.732  1.00 22.04           C  
ATOM    461  O   LEU    54      12.262  39.026  -1.688  1.00 23.72           O  
ATOM    462  CB  LEU    54      13.206  36.181  -2.066  1.00 28.23           C  
ATOM    463  CG  LEU    54      14.094  34.965  -2.357  1.00 44.20           C  
ATOM    464  CD1 LEU    54      14.301  34.149  -1.120  1.00 47.96           C  
ATOM    465  CD2 LEU    54      13.496  34.074  -3.455  1.00 42.25           C  
ATOM    466  N   LEU    55      14.402  39.333  -2.262  1.00 20.07           N  
ATOM    467  CA  LEU    55      14.093  40.556  -2.999  1.00 24.13           C  
ATOM    468  C   LEU    55      13.367  40.173  -4.288  1.00 27.55           C  
ATOM    469  O   LEU    55      13.743  39.198  -4.951  1.00 23.84           O  
ATOM    470  CB  LEU    55      15.370  41.320  -3.291  1.00 25.84           C  
ATOM    471  CG  LEU    55      15.168  42.775  -3.660  1.00 25.00           C  
ATOM    472  CD1 LEU    55      14.453  43.534  -2.557  1.00 23.86           C  
ATOM    473  CD2 LEU    55      16.490  43.392  -3.953  1.00 22.17           C  
ATOM    474  N   SER    56      12.313  40.909  -4.621  1.00 26.26           N  
ATOM    475  CA  SER    56      11.503  40.630  -5.822  1.00 29.54           C  
ATOM    476  C   SER    56      12.328  40.562  -7.109  1.00 27.78           C  
ATOM    477  O   SER    56      13.165  41.423  -7.367  1.00 22.69           O  
ATOM    478  CB  SER    56      10.431  41.699  -6.007  1.00 31.72           C  
ATOM    479  OG  SER    56       9.711  41.455  -7.207  1.00 32.81           O  
ATOM    480  N   ALA    57      12.058  39.545  -7.920  1.00 29.77           N  
ATOM    481  CA  ALA    57      12.789  39.319  -9.167  1.00 32.42           C  
ATOM    482  C   ALA    57      12.470  40.390 -10.205  1.00 33.36           C  
ATOM    483  O   ALA    57      13.229  40.569 -11.147  1.00 34.96           O  
ATOM    484  CB  ALA    57      12.509  37.914  -9.725  1.00 36.66           C  
ATOM    485  N   SER    58      11.376  41.128  -9.990  1.00 28.68           N  
ATOM    486  CA  SER    58      11.012  42.274 -10.826  1.00 28.25           C  
ATOM    487  C   SER    58      11.974  43.463 -10.707  1.00 31.71           C  
ATOM    488  O   SER    58      11.977  44.358 -11.557  1.00 31.32           O  
ATOM    489  CB  SER    58       9.565  42.695 -10.543  1.00 34.24           C  
ATOM    490  OG  SER    58       9.420  43.333  -9.284  1.00 35.76           O  
ATOM    491  N   LEU    59      12.787  43.475  -9.653  1.00 24.78           N  
ATOM    492  CA  LEU    59      13.783  44.526  -9.471  1.00 30.63           C  
ATOM    493  C   LEU    59      15.071  44.018 -10.106  1.00 31.92           C  
ATOM    494  O   LEU    59      15.820  43.244  -9.497  1.00 31.98           O  
ATOM    495  CB  LEU    59      13.955  44.871  -7.980  1.00 29.62           C  
ATOM    496  CG  LEU    59      12.714  45.319  -7.215  1.00 25.65           C  
ATOM    497  CD1 LEU    59      12.954  45.256  -5.702  1.00 25.36           C  
ATOM    498  CD2 LEU    59      12.301  46.719  -7.619  1.00 29.09           C  
ATOM    499  N   ARG    60      15.300  44.459 -11.342  1.00 33.21           N  
ATOM    500  CA  ARG    60      16.249  43.826 -12.253  1.00 36.10           C  
ATOM    501  C   ARG    60      17.617  44.474 -12.231  1.00 33.20           C  
ATOM    502  O   ARG    60      18.578  43.881 -12.717  1.00 44.58           O  
ATOM    503  CB  ARG    60      15.712  43.878 -13.696  1.00 39.12           C  
ATOM    504  CG  ARG    60      14.323  43.261 -13.930  1.00 52.12           C  
ATOM    505  CD  ARG    60      14.402  41.782 -14.285  1.00 67.62           C  
ATOM    506  NE  ARG    60      13.334  41.402 -15.212  1.00 85.24           N  
ATOM    507  CZ  ARG    60      12.391  40.490 -14.977  1.00 88.67           C  
ATOM    508  NH1 ARG    60      12.359  39.816 -13.833  1.00 90.37           N  
ATOM    509  NH2 ARG    60      11.478  40.240 -15.906  1.00 88.09           N  
ATOM    510  N   THR    61      17.700  45.706 -11.724  1.00 29.10           N  
ATOM    511  CA  THR    61      18.947  46.463 -11.718  1.00 26.42           C  
ATOM    512  C   THR    61      19.334  46.835 -10.279  1.00 27.29           C  
ATOM    513  O   THR    61      18.456  46.936  -9.417  1.00 22.73           O  
ATOM    514  CB  THR    61      18.868  47.776 -12.543  1.00 29.34           C  
ATOM    515  OG1 THR    61      18.018  48.728 -11.881  1.00 26.60           O  
ATOM    516  CG2 THR    61      18.422  47.539 -13.999  1.00 24.84           C  
ATOM    517  N   PRO    62      20.634  47.044 -10.018  1.00 25.78           N  
ATOM    518  CA  PRO    62      21.002  47.565  -8.694  1.00 22.69           C  
ATOM    519  C   PRO    62      20.253  48.870  -8.342  1.00 29.65           C  
ATOM    520  O   PRO    62      19.791  49.003  -7.207  1.00 24.80           O  
ATOM    521  CB  PRO    62      22.528  47.800  -8.813  1.00 27.82           C  
ATOM    522  CG  PRO    62      22.973  46.819  -9.858  1.00 31.58           C  
ATOM    523  CD  PRO    62      21.829  46.806 -10.863  1.00 27.50           C  
ATOM    524  N   GLN    63      20.076  49.775  -9.315  1.00 24.51           N  
ATOM    525  CA  GLN    63      19.422  51.067  -9.069  1.00 25.29           C  
ATOM    526  C   GLN    63      17.965  50.872  -8.650  1.00 21.95           C  
ATOM    527  O   GLN    63      17.484  51.547  -7.720  1.00 23.61           O  
ATOM    528  CB  GLN    63      19.507  52.002 -10.296  1.00 31.56           C  
ATOM    529  CG  GLN    63      20.910  52.567 -10.603  1.00 41.77           C  
ATOM    530  CD  GLN    63      21.898  51.536 -11.202  1.00 57.34           C  
ATOM    531  OE1 GLN    63      21.501  50.544 -11.848  1.00 32.51           O  
ATOM    532  NE2 GLN    63      23.202  51.774 -10.973  1.00 51.09           N  
ATOM    533  N   SER    64      17.280  49.920  -9.284  1.00 21.83           N  
ATOM    534  CA  SER    64      15.876  49.666  -8.954  1.00 25.03           C  
ATOM    535  C   SER    64      15.750  49.055  -7.554  1.00 24.32           C  
ATOM    536  O   SER    64      14.890  49.460  -6.775  1.00 20.62           O  
ATOM    537  CB  SER    64      15.192  48.792 -10.011  1.00 28.61           C  
ATOM    538  OG  SER    64      15.627  47.452  -9.913  1.00 30.88           O  
ATOM    539  N   ARG    65      16.631  48.109  -7.241  1.00 20.58           N  
ATOM    540  CA  ARG    65      16.695  47.517  -5.897  1.00 21.14           C  
ATOM    541  C   ARG    65      16.955  48.511  -4.773  1.00 21.18           C  
ATOM    542  O   ARG    65      16.253  48.488  -3.756  1.00 19.62           O  
ATOM    543  CB  ARG    65      17.750  46.409  -5.852  1.00 23.32           C  
ATOM    544  CG  ARG    65      17.463  45.270  -6.805  1.00 18.45           C  
ATOM    545  CD  ARG    65      18.665  44.418  -6.897  1.00 23.80           C  
ATOM    546  NE  ARG    65      18.445  43.302  -7.792  1.00 28.23           N  
ATOM    547  CZ  ARG    65      19.393  42.818  -8.571  1.00 39.35           C  
ATOM    548  NH1 ARG    65      20.600  43.365  -8.529  1.00 26.87           N  
ATOM    549  NH2 ARG    65      19.131  41.801  -9.384  1.00 39.24           N  
ATOM    550  N   THR    66      17.976  49.349  -4.961  1.00 18.13           N  
ATOM    551  CA  THR    66      18.367  50.404  -4.029  1.00 18.63           C  
ATOM    552  C   THR    66      17.207  51.354  -3.731  1.00 22.30           C  
ATOM    553  O   THR    66      16.892  51.610  -2.565  1.00 17.93           O  
ATOM    554  CB  THR    66      19.518  51.206  -4.624  1.00 15.67           C  
ATOM    555  OG1 THR    66      20.662  50.330  -4.794  1.00 19.82           O  
ATOM    556  CG2 THR    66      19.902  52.414  -3.716  1.00 22.75           C  
ATOM    557  N   ARG    67      16.562  51.837  -4.791  1.00 21.29           N  
ATOM    558  CA  ARG    67      15.388  52.717  -4.654  1.00 26.02           C  
ATOM    559  C   ARG    67      14.202  52.034  -3.933  1.00 17.62           C  
ATOM    560  O   ARG    67      13.593  52.643  -3.029  1.00 21.68           O  
ATOM    561  CB  ARG    67      15.032  53.252  -6.059  1.00 24.56           C  
ATOM    562  CG  ARG    67      13.700  53.913  -6.270  1.00 35.10           C  
ATOM    563  CD  ARG    67      13.442  54.083  -7.804  1.00 28.40           C  
ATOM    564  NE  ARG    67      14.538  54.784  -8.478  1.00 34.03           N  
ATOM    565  CZ  ARG    67      15.203  54.347  -9.545  1.00 43.18           C  
ATOM    566  NH1 ARG    67      14.900  53.185 -10.139  1.00 42.38           N  
ATOM    567  NH2 ARG    67      16.184  55.099 -10.032  1.00 51.91           N  
ATOM    568  N   ALA    68      13.898  50.784  -4.297  1.00 21.03           N  
ATOM    569  CA  ALA    68      12.785  50.049  -3.702  1.00 16.16           C  
ATOM    570  C   ALA    68      13.012  49.854  -2.200  1.00 20.76           C  
ATOM    571  O   ALA    68      12.143  50.134  -1.392  1.00 20.74           O  
ATOM    572  CB  ALA    68      12.611  48.667  -4.367  1.00 15.55           C  
ATOM    573  N   VAL    69      14.181  49.335  -1.841  1.00 17.62           N  
ATOM    574  CA  VAL    69      14.494  49.098  -0.428  1.00 17.98           C  
ATOM    575  C   VAL    69      14.677  50.379   0.391  1.00 18.80           C  
ATOM    576  O   VAL    69      14.300  50.412   1.572  1.00 21.34           O  
ATOM    577  CB  VAL    69      15.722  48.180  -0.310  1.00 16.22           C  
ATOM    578  CG1 VAL    69      16.157  47.989   1.146  1.00 17.56           C  
ATOM    579  CG2 VAL    69      15.351  46.828  -0.894  1.00 15.21           C  
ATOM    580  N   ALA    70      15.217  51.420  -0.231  1.00 16.22           N  
ATOM    581  CA  ALA    70      15.393  52.699   0.447  1.00 18.41           C  
ATOM    582  C   ALA    70      14.053  53.236   0.933  1.00 23.35           C  
ATOM    583  O   ALA    70      13.960  53.719   2.057  1.00 20.90           O  
ATOM    584  CB  ALA    70      16.106  53.706  -0.414  1.00 20.53           C  
ATOM    585  N   ASP    71      13.029  53.113   0.093  1.00 19.14           N  
ATOM    586  CA  ASP    71      11.661  53.564   0.421  1.00 22.77           C  
ATOM    587  C   ASP    71      11.066  52.725   1.566  1.00 22.49           C  
ATOM    588  O   ASP    71      10.469  53.270   2.493  1.00 18.09           O  
ATOM    589  CB  ASP    71      10.774  53.529  -0.847  1.00 16.87           C  
ATOM    590  CG  ASP    71       9.287  53.667  -0.537  1.00 22.63           C  
ATOM    591  OD1 ASP    71       8.899  54.604   0.199  1.00 23.94           O  
ATOM    592  OD2 ASP    71       8.512  52.807  -0.986  1.00 23.44           O  
ATOM    593  N   VAL    72      11.256  51.403   1.515  1.00 19.22           N  
ATOM    594  CA  VAL    72      10.769  50.516   2.571  1.00 20.05           C  
ATOM    595  C   VAL    72      11.420  50.874   3.922  1.00 19.36           C  
ATOM    596  O   VAL    72      10.726  51.017   4.927  1.00 19.01           O  
ATOM    597  CB  VAL    72      11.034  49.025   2.216  1.00 20.04           C  
ATOM    598  CG1 VAL    72      10.739  48.072   3.440  1.00 24.21           C  
ATOM    599  CG2 VAL    72      10.201  48.614   1.010  1.00 22.38           C  
ATOM    600  N   VAL    73      12.743  51.023   3.908  1.00 17.33           N  
ATOM    601  CA  VAL    73      13.536  51.443   5.070  1.00 20.26           C  
ATOM    602  C   VAL    73      13.027  52.774   5.630  1.00 22.10           C  
ATOM    603  O   VAL    73      12.812  52.861   6.840  1.00 17.86           O  
ATOM    604  CB  VAL    73      15.051  51.490   4.716  1.00 21.15           C  
ATOM    605  CG1 VAL    73      15.854  52.320   5.724  1.00 22.24           C  
ATOM    606  CG2 VAL    73      15.574  50.041   4.613  1.00 20.63           C  
ATOM    607  N   ASP    74      12.790  53.755   4.746  1.00 20.58           N  
ATOM    608  CA  ASP    74      12.251  55.063   5.119  1.00 18.28           C  
ATOM    609  C   ASP    74      11.020  54.878   5.970  1.00 20.19           C  
ATOM    610  O   ASP    74      10.914  55.452   7.042  1.00 21.19           O  
ATOM    611  CB  ASP    74      11.869  55.914   3.896  1.00 19.53           C  
ATOM    612  CG  ASP    74      13.056  56.564   3.220  1.00 31.44           C  
ATOM    613  OD1 ASP    74      14.149  56.596   3.817  1.00 30.23           O  
ATOM    614  OD2 ASP    74      12.889  57.055   2.076  1.00 33.16           O  
ATOM    615  N   ARG    75      10.109  54.037   5.496  1.00 19.10           N  
ATOM    616  CA  ARG    75       8.804  53.931   6.138  1.00 21.32           C  
ATOM    617  C   ARG    75       8.854  53.063   7.393  1.00 21.32           C  
ATOM    618  O   ARG    75       8.255  53.401   8.398  1.00 17.97           O  
ATOM    619  CB  ARG    75       7.755  53.513   5.125  1.00 19.91           C  
ATOM    620  CG  ARG    75       7.548  54.674   4.110  1.00 20.27           C  
ATOM    621  CD  ARG    75       6.359  54.402   3.225  1.00 22.86           C  
ATOM    622  NE  ARG    75       6.733  53.521   2.129  1.00 25.46           N  
ATOM    623  CZ  ARG    75       6.126  52.384   1.815  1.00 27.49           C  
ATOM    624  NH1 ARG    75       5.079  51.963   2.505  1.00 25.53           N  
ATOM    625  NH2 ARG    75       6.553  51.690   0.767  1.00 23.23           N  
ATOM    626  N   LEU    76       9.635  51.995   7.363  1.00 20.28           N  
ATOM    627  CA  LEU    76       9.884  51.208   8.580  1.00 18.24           C  
ATOM    628  C   LEU    76      10.543  52.045   9.684  1.00 17.75           C  
ATOM    629  O   LEU    76      10.208  51.893  10.865  1.00 18.96           O  
ATOM    630  CB  LEU    76      10.747  49.987   8.241  1.00 18.67           C  
ATOM    631  CG  LEU    76      10.044  48.840   7.491  1.00 24.03           C  
ATOM    632  CD1 LEU    76      11.029  47.720   7.214  1.00 24.96           C  
ATOM    633  CD2 LEU    76       8.841  48.331   8.274  1.00 27.30           C  
ATOM    634  N   ALA    77      11.474  52.925   9.310  1.00 16.73           N  
ATOM    635  CA  ALA    77      12.117  53.812  10.286  1.00 21.15           C  
ATOM    636  C   ALA    77      11.117  54.843  10.818  1.00 22.18           C  
ATOM    637  O   ALA    77      11.066  55.100  12.027  1.00 19.61           O  
ATOM    638  CB  ALA    77      13.325  54.466   9.693  1.00 17.59           C  
ATOM    639  N   ASP    78      10.291  55.395   9.931  1.00 20.66           N  
ATOM    640  CA  ASP    78       9.179  56.292  10.347  1.00 19.06           C  
ATOM    641  C   ASP    78       8.312  55.602  11.411  1.00 18.85           C  
ATOM    642  O   ASP    78       7.870  56.240  12.365  1.00 22.08           O  
ATOM    643  CB  ASP    78       8.266  56.625   9.159  1.00 23.91           C  
ATOM    644  CG  ASP    78       8.888  57.584   8.160  1.00 19.56           C  
ATOM    645  OD1 ASP    78       9.904  58.282   8.455  1.00 22.27           O  
ATOM    646  OD2 ASP    78       8.328  57.646   7.032  1.00 23.65           O  
ATOM    647  N   GLU    79       8.110  54.294  11.256  1.00 19.40           N  
ATOM    648  CA  GLU    79       7.257  53.515  12.140  1.00 18.58           C  
ATOM    649  C   GLU    79       7.984  53.003  13.407  1.00 19.38           C  
ATOM    650  O   GLU    79       7.387  52.305  14.226  1.00 23.70           O  
ATOM    651  CB  GLU    79       6.646  52.344  11.361  1.00 20.27           C  
ATOM    652  CG  GLU    79       5.647  52.804  10.265  1.00 22.77           C  
ATOM    653  CD  GLU    79       5.568  51.905   9.043  1.00 30.88           C  
ATOM    654  OE1 GLU    79       6.058  50.756   9.116  1.00 25.70           O  
ATOM    655  OE2 GLU    79       5.018  52.361   7.992  1.00 25.40           O  
ATOM    656  N   GLY    80       9.262  53.354  13.564  1.00 17.12           N  
ATOM    657  CA  GLY    80      10.044  52.909  14.737  1.00 17.37           C  
ATOM    658  C   GLY    80      10.604  51.500  14.654  1.00 21.05           C  
ATOM    659  O   GLY    80      11.103  50.971  15.658  1.00 22.12           O  
ATOM    660  N   VAL    81      10.558  50.887  13.467  1.00 19.14           N  
ATOM    661  CA  VAL    81      10.930  49.474  13.314  1.00 20.51           C  
ATOM    662  C   VAL    81      12.445  49.248  13.111  1.00 20.06           C  
ATOM    663  O   VAL    81      13.037  48.268  13.647  1.00 17.76           O  
ATOM    664  CB  VAL    81      10.120  48.806  12.186  1.00 25.27           C  
ATOM    665  CG1 VAL    81      10.474  47.322  12.042  1.00 22.76           C  
ATOM    666  CG2 VAL    81       8.654  48.971  12.458  1.00 20.85           C  
ATOM    667  N   VAL    82      13.073  50.146  12.346  1.00 18.25           N  
ATOM    668  CA  VAL    82      14.499  50.035  12.016  1.00 16.89           C  
ATOM    669  C   VAL    82      15.127  51.393  12.281  1.00 16.23           C  
ATOM    670  O   VAL    82      14.387  52.399  12.357  1.00 19.06           O  
ATOM    671  CB  VAL    82      14.720  49.615  10.509  1.00 18.42           C  
ATOM    672  CG1 VAL    82      13.994  48.315  10.210  1.00 16.44           C  
ATOM    673  CG2 VAL    82      14.267  50.713   9.547  1.00 21.23           C  
ATOM    674  N   PRO    83      16.467  51.445  12.420  1.00 19.03           N  
ATOM    675  CA  PRO    83      17.159  52.709  12.574  1.00 16.16           C  
ATOM    676  C   PRO    83      16.935  53.643  11.408  1.00 19.13           C  
ATOM    677  O   PRO    83      16.727  53.205  10.281  1.00 19.03           O  
ATOM    678  CB  PRO    83      18.633  52.274  12.648  1.00 14.32           C  
ATOM    679  CG  PRO    83      18.580  50.895  13.208  1.00 19.67           C  
ATOM    680  CD  PRO    83      17.423  50.315  12.495  1.00 18.96           C  
ATOM    681  N   ALA    84      16.964  54.937  11.681  1.00 19.88           N  
ATOM    682  CA  ALA    84      16.800  55.923  10.623  1.00 19.34           C  
ATOM    683  C   ALA    84      18.026  55.982   9.719  1.00 17.45           C  
ATOM    684  O   ALA    84      19.150  56.024  10.202  1.00 19.89           O  
ATOM    685  CB  ALA    84      16.552  57.280  11.219  1.00 23.23           C  
ATOM    686  N   PRO    85      17.805  55.997   8.393  1.00 20.18           N  
ATOM    687  CA  PRO    85      18.928  56.220   7.463  1.00 23.79           C  
ATOM    688  C   PRO    85      19.585  57.578   7.699  1.00 26.63           C  
ATOM    689  O   PRO    85      18.905  58.550   8.050  1.00 22.39           O  
ATOM    690  CB  PRO    85      18.282  56.124   6.071  1.00 28.43           C  
ATOM    691  CG  PRO    85      16.819  56.059   6.290  1.00 31.93           C  
ATOM    692  CD  PRO    85      16.530  55.736   7.715  1.00 23.72           C  
ATOM    693  N   ARG    86      20.904  57.637   7.571  1.00 21.40           N  
ATOM    694  CA  ARG    86      21.638  58.873   7.856  1.00 25.10           C  
ATOM    695  C   ARG    86      22.387  59.424   6.647  1.00 26.58           C  
ATOM    696  O   ARG    86      23.023  60.469   6.752  1.00 28.84           O  
ATOM    697  CB  ARG    86      22.602  58.662   9.042  1.00 25.49           C  
ATOM    698  CG  ARG    86      21.896  58.067  10.263  1.00 30.08           C  
ATOM    699  CD  ARG    86      22.607  58.369  11.562  1.00 31.92           C  
ATOM    700  NE  ARG    86      22.427  59.762  11.944  1.00 40.56           N  
ATOM    701  CZ  ARG    86      21.426  60.221  12.691  1.00 33.94           C  
ATOM    702  NH1 ARG    86      21.371  61.511  12.968  1.00 31.03           N  
ATOM    703  NH2 ARG    86      20.491  59.408  13.175  1.00 24.20           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
END
