
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 ( 1597),  selected  106 , name 2djm_A
# Molecule2: number of CA atoms  145 ( 1093),  selected  145 , name T0514.pdb
# PARAMETERS: 2djm_A.T0514.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      S       1           -
LGA    S     2_A      S       2           -
LGA    -       -      L       3           -
LGA    -       -      T       4           -
LGA    -       -      E       5           -
LGA    -       -      T       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      L       9           -
LGA    -       -      W      10           -
LGA    -       -      S      11           -
LGA    -       -      I      12           -
LGA    -       -      N      13           -
LGA    -       -      C      14           -
LGA    -       -      G      15           -
LGA    -       -      I      16           -
LGA    -       -      Q      17           -
LGA    -       -      E      18           -
LGA    -       -      G      19           -
LGA    -       -      K      20           -
LGA    -       -      K      21           -
LGA    -       -      V      22           -
LGA    -       -      C      23           -
LGA    -       -      F      24           -
LGA    -       -      M      25           -
LGA    -       -      H      26           -
LGA    -       -      R      27           -
LGA    -       -      Q      28           -
LGA    -       -      E      29           -
LGA    -       -      V      30           -
LGA    -       -      N      31           -
LGA    -       -      D      32           -
LGA    -       -      Q      33           -
LGA    I     3_A      N      34           #
LGA    P     4_A      R      35           #
LGA    S     5_A      V      36          3.408
LGA    S     6_A      V      37          3.729
LGA    A     7_A      -       -           -
LGA    S     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    Q    10_A      V      38          0.851
LGA    L    11_A      A      39          2.419
LGA    D    12_A      M      40          2.630
LGA    S    13_A      S      41          0.781
LGA    Y    14_A      V      42          1.578
LGA    N    15_A      V      43          2.464
LGA    Y    16_A      L      44          3.497
LGA    -       -      N      45           -
LGA    D    17_A      A      46           #
LGA    G    18_A      D      47           #
LGA    S    19_A      G      48          4.582
LGA    T    20_A      V      49          1.942
LGA    F    21_A      V      50          2.040
LGA    S    22_A      S      51          0.588
LGA    G    23_A      G      52          2.736
LGA    K    24_A      N      53          0.889
LGA    I    25_A      L      54          0.959
LGA    Y    26_A      T      55          0.825
LGA    V    27_A      V      56          1.188
LGA    K    28_A      P      57          1.845
LGA    N    29_A      F      58          2.920
LGA    I    30_A      G      59          1.902
LGA    A    31_A      I      60          4.171
LGA    Y    32_A      L      61          2.368
LGA    -       -      V      62           -
LGA    S    33_A      S      63          3.885
LGA    K    34_A      K      64          3.658
LGA    K    35_A      P      65          2.071
LGA    V    36_A      V      66          1.123
LGA    T    37_A      R      67          1.475
LGA    V    38_A      L      68          1.547
LGA    V    39_A      Q      69          1.587
LGA    Y    40_A      V      70          3.397
LGA    A    41_A      -       -           -
LGA    D    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    S    44_A      -       -           -
LGA    D    45_A      -       -           -
LGA    N    46_A      -       -           -
LGA    W    47_A      D      71          5.018
LGA    N    48_A      -       -           -
LGA    N    49_A      E      72          4.992
LGA    N    50_A      G      73          2.379
LGA    G    51_A      K      74          3.717
LGA    N    52_A      A      75          1.666
LGA    I    53_A      V      76          1.208
LGA    I    54_A      I      77          0.421
LGA    A    55_A      E      78          1.449
LGA    A    56_A      T      79          2.461
LGA    S    57_A      G      80          2.711
LGA    F    58_A      I      81          1.885
LGA    S    59_A      R      82          1.857
LGA    G    60_A      T      83          1.094
LGA    P    61_A      C      84          1.751
LGA    I    62_A      V      85          0.672
LGA    S    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    S    65_A      P      86          1.956
LGA    N    66_A      A      87           #
LGA    Y    67_A      G      88          2.614
LGA    E    68_A      C      89          1.546
LGA    Y    69_A      I      90          1.185
LGA    W    70_A      V      91          1.378
LGA    T    71_A      P      92          0.769
LGA    F    72_A      I      93          2.614
LGA    S    73_A      V      94          1.937
LGA    A    74_A      F      95          2.641
LGA    S    75_A      D      96          1.669
LGA    V    76_A      K      97          2.341
LGA    K    77_A      N      98          3.053
LGA    G    78_A      Y      99          5.594
LGA    -       -      V     100           -
LGA    I    79_A      A     101          1.886
LGA    -       -      A     102           -
LGA    -       -      L     103           -
LGA    K    80_A      R     104          0.737
LGA    -       -      A     105           -
LGA    E    81_A      G     106          2.716
LGA    -       -      K     107           -
LGA    F    82_A      H     108          4.071
LGA    Y    83_A      L     109          1.166
LGA    I    84_A      K     110          3.791
LGA    K    85_A      L     111          0.309
LGA    Y    86_A      A     112          3.233
LGA    E    87_A      M     113          1.631
LGA    V    88_A      T     114          0.961
LGA    -       -      I     115           -
LGA    -       -      A     116           -
LGA    -       -      A     117           -
LGA    -       -      P     118           -
LGA    -       -      G     119           -
LGA    S    89_A      E     120          4.395
LGA    G    90_A      P     121          1.513
LGA    K    91_A      P     122          1.693
LGA    T    92_A      L     123          1.581
LGA    Y    93_A      N     124          2.884
LGA    Y    94_A      D     125          3.523
LGA    D    95_A      L     126          3.385
LGA    N    96_A      F     127          2.960
LGA    N    97_A      V     128          4.899
LGA    N    98_A      Q     129           #
LGA    S    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    N   101_A      L     130          3.951
LGA    Y   102_A      N     131          4.317
LGA    Q   103_A      G     132          3.793
LGA    V   104_A      F     133          1.842
LGA    S   105_A      S     134          3.307
LGA    -       -      N     135           -
LGA    -       -      A     136           -
LGA    T   106_A      L     137          3.381
LGA    -       -      N     138           -
LGA    -       -      R     139           -
LGA    -       -      L     140           -
LGA    -       -      I     141           -
LGA    -       -      A     142           -
LGA    -       -      L     143           -
LGA    -       -      Q     144           -
LGA    -       -      K     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106  145    5.0     84    2.67    10.71     35.133     3.027

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.896265 * X  +   0.097469 * Y  +   0.432676 * Z  + -101.300880
  Y_new =   0.093310 * X  +  -0.912280 * Y  +   0.398797 * Z  +  15.222060
  Z_new =   0.433592 * X  +   0.397801 * Y  +   0.808550 * Z  + -32.371124 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.457222   -2.684371  [ DEG:    26.1969   -153.8031 ]
  Theta =  -0.448475   -2.693118  [ DEG:   -25.6957   -154.3043 ]
  Phi   =   3.037856   -0.103737  [ DEG:   174.0563     -5.9437 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2djm_A                                        
REMARK     2: T0514.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2djm_A.T0514.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106  145   5.0   84   2.67   10.71  35.133
REMARK  ---------------------------------------------------------- 
MOLECULE 2djm_A
HEADER    SUGAR BINDING PROTEIN                   04-APR-06   2DJM              
TITLE     SOLUTION STRUCTURE OF N-TERMINAL STARCH-BINDING DOMAIN OF             
TITLE    2 GLUCOAMYLASE FROM RHIZOPUS ORYZAE                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUCOAMYLASE A;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: STARCH-BINDING DOMAIN, RESDIUES 1-106;                     
COMPND   5 SYNONYM: FAMILY 21 CARBOHYDRATE-BINDING MODULE;                      
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHIZOPUS ORYZAE;                                
SOURCE   3 ORGANISM_COMMON: FUNGI;                                              
SOURCE   4 GENE: AMYA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET23A                                    
KEYWDS    BETA SANDWICH, ANTI-PARALLEL, STRACH BINDING, CARBOHYDRATE            
KEYWDS   2 BINDING                                                              
EXPDTA    NMR, 15 STRUCTURES                                                    
AUTHOR    Y.N.LIU,Y.T.LAI,P.C.LYU                                               
REVDAT   1   27-MAR-07 2DJM    0                                                
JRNL        AUTH   Y.N.LIU,Y.T.LAI,W.I.CHOU,M.D.T.CHANG,P.C.LYU                 
JRNL        TITL   SOLUTION STRUCTURE OF FAMILY 21                              
JRNL        TITL 2 CARBOHYDRATE-BINDING MODULE FROM RHIZOPUS ORYZAE             
JRNL        TITL 3 GLUCOAMYLASE                                                 
JRNL        REF    BIOCHEM.J.                    V. 403    21 2007              
JRNL        REFN   ASTM BIJOAK  UK ISSN 0264-6021                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DJM A    1   106  GB     82491809 ABB77799        26    131             
SEQRES   1 A  106  ALA SER ILE PRO SER SER ALA SER VAL GLN LEU ASP SER          
SEQRES   2 A  106  TYR ASN TYR ASP GLY SER THR PHE SER GLY LYS ILE TYR          
SEQRES   3 A  106  VAL LYS ASN ILE ALA TYR SER LYS LYS VAL THR VAL VAL          
SEQRES   4 A  106  TYR ALA ASP GLY SER ASP ASN TRP ASN ASN ASN GLY ASN          
SEQRES   5 A  106  ILE ILE ALA ALA SER PHE SER GLY PRO ILE SER GLY SER          
SEQRES   6 A  106  ASN TYR GLU TYR TRP THR PHE SER ALA SER VAL LYS GLY          
SEQRES   7 A  106  ILE LYS GLU PHE TYR ILE LYS TYR GLU VAL SER GLY LYS          
SEQRES   8 A  106  THR TYR TYR ASP ASN ASN ASN SER ALA ASN TYR GLN VAL          
SEQRES   9 A  106  SER THR                                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1     -86.677   1.262 -20.244  1.00  0.00           N  
ATOM      2  CA  ALA A   1     -86.755   2.724 -20.029  1.00  0.00           C  
ATOM      3  C   ALA A   1     -88.209   3.187 -19.977  1.00  0.00           C  
ATOM      4  O   ALA A   1     -89.112   2.477 -20.420  1.00  0.00           O  
ATOM      5  CB  ALA A   1     -86.014   3.457 -21.134  1.00  0.00           C  
ATOM      6  H2  ALA A   1     -85.689   0.939 -20.153  1.00  0.00           H  
ATOM      7  HA  ALA A   1     -86.279   2.959 -19.089  1.00  0.00           H  
ATOM      8  HB1 ALA A   1     -85.865   4.487 -20.845  1.00  0.00           H  
ATOM      9  HB2 ALA A   1     -86.599   3.422 -22.039  1.00  0.00           H  
ATOM     10  HB3 ALA A   1     -85.057   2.986 -21.304  1.00  0.00           H  
ATOM     11  H1  ALA A   1     -87.255   0.767 -19.529  1.00  0.00           H  
ATOM     12  H3  ALA A   1     -87.028   1.012 -21.191  1.00  0.00           H  
ATOM     13  N   SER A   2     -88.430   4.376 -19.440  1.00  0.00           N  
ATOM     14  CA  SER A   2     -89.769   4.932 -19.336  1.00  0.00           C  
ATOM     15  C   SER A   2     -89.987   5.977 -20.420  1.00  0.00           C  
ATOM     16  O   SER A   2     -89.349   7.031 -20.424  1.00  0.00           O  
ATOM     17  CB  SER A   2     -89.991   5.541 -17.952  1.00  0.00           C  
ATOM     18  OG  SER A   2     -89.801   4.572 -16.934  1.00  0.00           O  
ATOM     19  H   SER A   2     -87.667   4.907 -19.116  1.00  0.00           H  
ATOM     20  HA  SER A   2     -90.476   4.129 -19.483  1.00  0.00           H  
ATOM     21  HB2 SER A   2     -89.290   6.349 -17.800  1.00  0.00           H  
ATOM     22  HB3 SER A   2     -90.999   5.924 -17.885  1.00  0.00           H  
ATOM     23  HG  SER A   2     -88.907   4.661 -16.565  1.00  0.00           H  
ATOM     24  N   ILE A   3     -90.875   5.662 -21.348  1.00  0.00           N  
ATOM     25  CA  ILE A   3     -91.168   6.544 -22.470  1.00  0.00           C  
ATOM     26  C   ILE A   3     -92.104   7.694 -22.077  1.00  0.00           C  
ATOM     27  O   ILE A   3     -91.763   8.856 -22.307  1.00  0.00           O  
ATOM     28  CB  ILE A   3     -91.771   5.760 -23.658  1.00  0.00           C  
ATOM     29  CG1 ILE A   3     -90.785   4.700 -24.152  1.00  0.00           C  
ATOM     30  CG2 ILE A   3     -92.154   6.703 -24.790  1.00  0.00           C  
ATOM     31  CD1 ILE A   3     -89.477   5.275 -24.661  1.00  0.00           C  
ATOM     32  H   ILE A   3     -91.346   4.808 -21.280  1.00  0.00           H  
ATOM     33  HA  ILE A   3     -90.230   6.969 -22.798  1.00  0.00           H  
ATOM     34  HB  ILE A   3     -92.671   5.271 -23.315  1.00  0.00           H  
ATOM     35 HG12 ILE A   3     -90.556   4.026 -23.339  1.00  0.00           H  
ATOM     36 HG13 ILE A   3     -91.240   4.140 -24.959  1.00  0.00           H  
ATOM     37 HG21 ILE A   3     -92.884   7.415 -24.432  1.00  0.00           H  
ATOM     38 HG22 ILE A   3     -92.576   6.132 -25.601  1.00  0.00           H  
ATOM     39 HG23 ILE A   3     -91.276   7.229 -25.134  1.00  0.00           H  
ATOM     40 HD11 ILE A   3     -88.827   4.473 -24.978  1.00  0.00           H  
ATOM     41 HD12 ILE A   3     -88.999   5.835 -23.873  1.00  0.00           H  
ATOM     42 HD13 ILE A   3     -89.675   5.929 -25.497  1.00  0.00           H  
ATOM     43  N   PRO A   4     -93.289   7.405 -21.478  1.00  0.00           N  
ATOM     44  CA  PRO A   4     -94.248   8.450 -21.092  1.00  0.00           C  
ATOM     45  C   PRO A   4     -93.604   9.576 -20.292  1.00  0.00           C  
ATOM     46  O   PRO A   4     -92.817   9.331 -19.374  1.00  0.00           O  
ATOM     47  CB  PRO A   4     -95.260   7.707 -20.224  1.00  0.00           C  
ATOM     48  CG  PRO A   4     -95.214   6.304 -20.714  1.00  0.00           C  
ATOM     49  CD  PRO A   4     -93.792   6.057 -21.134  1.00  0.00           C  
ATOM     50  HA  PRO A   4     -94.749   8.863 -21.955  1.00  0.00           H  
ATOM     51  HB2 PRO A   4     -94.965   7.776 -19.187  1.00  0.00           H  
ATOM     52  HB3 PRO A   4     -96.239   8.143 -20.359  1.00  0.00           H  
ATOM     53  HG2 PRO A   4     -95.493   5.628 -19.918  1.00  0.00           H  
ATOM     54  HG3 PRO A   4     -95.880   6.187 -21.557  1.00  0.00           H  
ATOM     55  HD2 PRO A   4     -93.227   5.635 -20.316  1.00  0.00           H  
ATOM     56  HD3 PRO A   4     -93.760   5.404 -21.994  1.00  0.00           H  
ATOM     57  N   SER A   5     -93.943  10.807 -20.642  1.00  0.00           N  
ATOM     58  CA  SER A   5     -93.344  11.967 -20.008  1.00  0.00           C  
ATOM     59  C   SER A   5     -94.302  13.152 -20.059  1.00  0.00           C  
ATOM     60  O   SER A   5     -94.753  13.631 -19.021  1.00  0.00           O  
ATOM     61  CB  SER A   5     -92.016  12.307 -20.695  1.00  0.00           C  
ATOM     62  OG  SER A   5     -91.249  13.224 -19.926  1.00  0.00           O  
ATOM     63  H   SER A   5     -94.627  10.934 -21.331  1.00  0.00           H  
ATOM     64  HA  SER A   5     -93.152  11.720 -18.976  1.00  0.00           H  
ATOM     65  HB2 SER A   5     -91.442  11.403 -20.825  1.00  0.00           H  
ATOM     66  HB3 SER A   5     -92.217  12.748 -21.661  1.00  0.00           H  
ATOM     67  HG  SER A   5     -90.933  13.939 -20.506  1.00  0.00           H  
ATOM     68  N   SER A   6     -94.616  13.623 -21.263  1.00  0.00           N  
ATOM     69  CA  SER A   6     -95.570  14.712 -21.422  1.00  0.00           C  
ATOM     70  C   SER A   6     -96.978  14.232 -21.061  1.00  0.00           C  
ATOM     71  O   SER A   6     -97.594  14.721 -20.113  1.00  0.00           O  
ATOM     72  CB  SER A   6     -95.534  15.235 -22.859  1.00  0.00           C  
ATOM     73  OG  SER A   6     -94.213  15.589 -23.240  1.00  0.00           O  
ATOM     74  H   SER A   6     -94.190  13.243 -22.058  1.00  0.00           H  
ATOM     75  HA  SER A   6     -95.288  15.504 -20.747  1.00  0.00           H  
ATOM     76  HB2 SER A   6     -95.895  14.467 -23.528  1.00  0.00           H  
ATOM     77  HB3 SER A   6     -96.164  16.109 -22.938  1.00  0.00           H  
ATOM     78  HG  SER A   6     -94.212  15.859 -24.167  1.00  0.00           H  
ATOM     79  N   ALA A   7     -97.469  13.266 -21.823  1.00  0.00           N  
ATOM     80  CA  ALA A   7     -98.749  12.651 -21.566  1.00  0.00           C  
ATOM     81  C   ALA A   7     -98.717  11.217 -22.076  1.00  0.00           C  
ATOM     82  O   ALA A   7     -97.639  10.643 -22.234  1.00  0.00           O  
ATOM     83  CB  ALA A   7     -99.838  13.450 -22.262  1.00  0.00           C  
ATOM     84  H   ALA A   7     -96.965  12.968 -22.600  1.00  0.00           H  
ATOM     85  HA  ALA A   7     -98.933  12.658 -20.502  1.00  0.00           H  
ATOM     86  HB1 ALA A   7    -100.746  12.882 -22.262  1.00  0.00           H  
ATOM     87  HB2 ALA A   7     -99.540  13.656 -23.279  1.00  0.00           H  
ATOM     88  HB3 ALA A   7     -99.994  14.379 -21.735  1.00  0.00           H  
ATOM     89  N   SER A   8     -99.886  10.642 -22.339  1.00  0.00           N  
ATOM     90  CA  SER A   8     -99.964   9.325 -22.959  1.00  0.00           C  
ATOM     91  C   SER A   8     -99.388   9.398 -24.366  1.00  0.00           C  
ATOM     92  O   SER A   8     -98.915   8.405 -24.921  1.00  0.00           O  
ATOM     93  CB  SER A   8    -101.422   8.861 -23.018  1.00  0.00           C  
ATOM     94  OG  SER A   8    -102.028   8.933 -21.738  1.00  0.00           O  
ATOM     95  H   SER A   8    -100.713  11.107 -22.113  1.00  0.00           H  
ATOM     96  HA  SER A   8     -99.386   8.632 -22.368  1.00  0.00           H  
ATOM     97  HB2 SER A   8    -101.970   9.496 -23.698  1.00  0.00           H  
ATOM     98  HB3 SER A   8    -101.463   7.840 -23.371  1.00  0.00           H  
ATOM     99  HG  SER A   8    -102.011   8.067 -21.325  1.00  0.00           H  
ATOM    100  N   VAL A   9     -99.426  10.597 -24.924  1.00  0.00           N  
ATOM    101  CA  VAL A   9     -98.956  10.846 -26.258  1.00  0.00           C  
ATOM    102  C   VAL A   9     -97.992  12.028 -26.275  1.00  0.00           C  
ATOM    103  O   VAL A   9     -98.013  12.868 -25.377  1.00  0.00           O  
ATOM    104  CB  VAL A   9    -100.161  11.111 -27.187  1.00  0.00           C  
ATOM    105  CG1 VAL A   9    -101.160  12.016 -26.515  1.00  0.00           C  
ATOM    106  CG2 VAL A   9     -99.735  11.720 -28.502  1.00  0.00           C  
ATOM    107  H   VAL A   9     -99.791  11.350 -24.420  1.00  0.00           H  
ATOM    108  HA  VAL A   9     -98.442   9.966 -26.603  1.00  0.00           H  
ATOM    109  HB  VAL A   9    -100.648  10.167 -27.394  1.00  0.00           H  
ATOM    110 HG11 VAL A   9    -101.905  12.292 -27.236  1.00  0.00           H  
ATOM    111 HG12 VAL A   9    -100.660  12.898 -26.144  1.00  0.00           H  
ATOM    112 HG13 VAL A   9    -101.628  11.491 -25.696  1.00  0.00           H  
ATOM    113 HG21 VAL A   9    -100.567  11.712 -29.187  1.00  0.00           H  
ATOM    114 HG22 VAL A   9     -98.922  11.145 -28.903  1.00  0.00           H  
ATOM    115 HG23 VAL A   9     -99.412  12.738 -28.338  1.00  0.00           H  
ATOM    116  N   GLN A  10     -97.130  12.045 -27.278  1.00  0.00           N  
ATOM    117  CA  GLN A  10     -96.215  13.150 -27.519  1.00  0.00           C  
ATOM    118  C   GLN A  10     -96.061  13.340 -29.024  1.00  0.00           C  
ATOM    119  O   GLN A  10     -95.975  12.364 -29.769  1.00  0.00           O  
ATOM    120  CB  GLN A  10     -94.846  12.870 -26.891  1.00  0.00           C  
ATOM    121  CG  GLN A  10     -93.914  14.073 -26.911  1.00  0.00           C  
ATOM    122  CD  GLN A  10     -92.495  13.730 -26.498  1.00  0.00           C  
ATOM    123  OE1 GLN A  10     -91.793  14.546 -25.901  1.00  0.00           O  
ATOM    124  NE2 GLN A  10     -92.053  12.524 -26.827  1.00  0.00           N  
ATOM    125  H   GLN A  10     -97.122  11.282 -27.899  1.00  0.00           H  
ATOM    126  HA  GLN A  10     -96.638  14.046 -27.086  1.00  0.00           H  
ATOM    127  HB2 GLN A  10     -94.987  12.566 -25.863  1.00  0.00           H  
ATOM    128  HB3 GLN A  10     -94.372  12.065 -27.434  1.00  0.00           H  
ATOM    129  HG2 GLN A  10     -93.891  14.477 -27.914  1.00  0.00           H  
ATOM    130  HG3 GLN A  10     -94.298  14.821 -26.233  1.00  0.00           H  
ATOM    131 HE21 GLN A  10     -92.660  11.926 -27.311  1.00  0.00           H  
ATOM    132 HE22 GLN A  10     -91.134  12.283 -26.583  1.00  0.00           H  
ATOM    133  N   LEU A  11     -96.056  14.580 -29.479  1.00  0.00           N  
ATOM    134  CA  LEU A  11     -95.900  14.855 -30.900  1.00  0.00           C  
ATOM    135  C   LEU A  11     -94.483  14.547 -31.369  1.00  0.00           C  
ATOM    136  O   LEU A  11     -93.505  15.045 -30.810  1.00  0.00           O  
ATOM    137  CB  LEU A  11     -96.220  16.313 -31.203  1.00  0.00           C  
ATOM    138  CG  LEU A  11     -96.179  16.674 -32.688  1.00  0.00           C  
ATOM    139  CD1 LEU A  11     -97.346  16.030 -33.422  1.00  0.00           C  
ATOM    140  CD2 LEU A  11     -96.196  18.181 -32.854  1.00  0.00           C  
ATOM    141  H   LEU A  11     -96.173  15.330 -28.848  1.00  0.00           H  
ATOM    142  HA  LEU A  11     -96.589  14.224 -31.439  1.00  0.00           H  
ATOM    143  HB2 LEU A  11     -97.208  16.529 -30.825  1.00  0.00           H  
ATOM    144  HB3 LEU A  11     -95.506  16.936 -30.684  1.00  0.00           H  
ATOM    145  HG  LEU A  11     -95.261  16.292 -33.128  1.00  0.00           H  
ATOM    146 HD11 LEU A  11     -97.247  16.215 -34.481  1.00  0.00           H  
ATOM    147 HD12 LEU A  11     -98.273  16.455 -33.068  1.00  0.00           H  
ATOM    148 HD13 LEU A  11     -97.344  14.966 -33.238  1.00  0.00           H  
ATOM    149 HD21 LEU A  11     -96.267  18.428 -33.902  1.00  0.00           H  
ATOM    150 HD22 LEU A  11     -95.287  18.599 -32.448  1.00  0.00           H  
ATOM    151 HD23 LEU A  11     -97.047  18.591 -32.330  1.00  0.00           H  
ATOM    152  N   ASP A  12     -94.392  13.728 -32.412  1.00  0.00           N  
ATOM    153  CA  ASP A  12     -93.110  13.377 -33.012  1.00  0.00           C  
ATOM    154  C   ASP A  12     -92.580  14.548 -33.814  1.00  0.00           C  
ATOM    155  O   ASP A  12     -91.529  15.108 -33.504  1.00  0.00           O  
ATOM    156  CB  ASP A  12     -93.268  12.172 -33.941  1.00  0.00           C  
ATOM    157  CG  ASP A  12     -91.941  11.658 -34.487  1.00  0.00           C  
ATOM    158  OD1 ASP A  12     -91.305  12.372 -35.289  1.00  0.00           O  
ATOM    159  OD2 ASP A  12     -91.534  10.528 -34.134  1.00  0.00           O  
ATOM    160  H   ASP A  12     -95.211  13.354 -32.795  1.00  0.00           H  
ATOM    161  HA  ASP A  12     -92.417  13.135 -32.221  1.00  0.00           H  
ATOM    162  HB2 ASP A  12     -93.751  11.380 -33.407  1.00  0.00           H  
ATOM    163  HB3 ASP A  12     -93.888  12.458 -34.779  1.00  0.00           H  
ATOM    164  N   SER A  13     -93.338  14.919 -34.836  1.00  0.00           N  
ATOM    165  CA  SER A  13     -92.932  15.963 -35.775  1.00  0.00           C  
ATOM    166  C   SER A  13     -93.948  16.124 -36.891  1.00  0.00           C  
ATOM    167  O   SER A  13     -94.848  15.301 -37.069  1.00  0.00           O  
ATOM    168  CB  SER A  13     -91.558  15.643 -36.377  1.00  0.00           C  
ATOM    169  OG  SER A  13     -91.548  14.353 -36.970  1.00  0.00           O  
ATOM    170  H   SER A  13     -94.209  14.477 -34.958  1.00  0.00           H  
ATOM    171  HA  SER A  13     -92.872  16.900 -35.241  1.00  0.00           H  
ATOM    172  HB2 SER A  13     -91.321  16.373 -37.135  1.00  0.00           H  
ATOM    173  HB3 SER A  13     -90.807  15.674 -35.600  1.00  0.00           H  
ATOM    174  HG  SER A  13     -91.455  13.679 -36.273  1.00  0.00           H  
ATOM    175  N   TYR A  14     -93.787  17.210 -37.619  1.00  0.00           N  
ATOM    176  CA  TYR A  14     -94.635  17.556 -38.735  1.00  0.00           C  
ATOM    177  C   TYR A  14     -93.861  18.503 -39.629  1.00  0.00           C  
ATOM    178  O   TYR A  14     -92.884  19.111 -39.187  1.00  0.00           O  
ATOM    179  CB  TYR A  14     -95.924  18.204 -38.231  1.00  0.00           C  
ATOM    180  CG  TYR A  14     -95.677  19.474 -37.465  1.00  0.00           C  
ATOM    181  CD1 TYR A  14     -95.555  20.670 -38.132  1.00  0.00           C  
ATOM    182  CD2 TYR A  14     -95.554  19.470 -36.088  1.00  0.00           C  
ATOM    183  CE1 TYR A  14     -95.317  21.843 -37.461  1.00  0.00           C  
ATOM    184  CE2 TYR A  14     -95.315  20.639 -35.396  1.00  0.00           C  
ATOM    185  CZ  TYR A  14     -95.197  21.829 -36.088  1.00  0.00           C  
ATOM    186  OH  TYR A  14     -94.955  23.001 -35.407  1.00  0.00           O  
ATOM    187  H   TYR A  14     -93.046  17.814 -37.402  1.00  0.00           H  
ATOM    188  HA  TYR A  14     -94.873  16.664 -39.293  1.00  0.00           H  
ATOM    189  HB2 TYR A  14     -96.561  18.434 -39.072  1.00  0.00           H  
ATOM    190  HB3 TYR A  14     -96.434  17.512 -37.576  1.00  0.00           H  
ATOM    191  HD1 TYR A  14     -95.638  20.670 -39.199  1.00  0.00           H  
ATOM    192  HD2 TYR A  14     -95.645  18.535 -35.558  1.00  0.00           H  
ATOM    193  HE1 TYR A  14     -95.229  22.762 -38.015  1.00  0.00           H  
ATOM    194  HE2 TYR A  14     -95.226  20.616 -34.322  1.00  0.00           H  
ATOM    195  HH  TYR A  14     -94.279  22.848 -34.731  1.00  0.00           H  
ATOM    196  N   ASN A  15     -94.272  18.627 -40.869  1.00  0.00           N  
ATOM    197  CA  ASN A  15     -93.572  19.483 -41.800  1.00  0.00           C  
ATOM    198  C   ASN A  15     -94.532  20.474 -42.429  1.00  0.00           C  
ATOM    199  O   ASN A  15     -95.752  20.295 -42.379  1.00  0.00           O  
ATOM    200  CB  ASN A  15     -92.882  18.637 -42.876  1.00  0.00           C  
ATOM    201  CG  ASN A  15     -91.979  19.440 -43.796  1.00  0.00           C  
ATOM    202  OD1 ASN A  15     -91.954  19.216 -45.006  1.00  0.00           O  
ATOM    203  ND2 ASN A  15     -91.190  20.343 -43.227  1.00  0.00           N  
ATOM    204  H   ASN A  15     -95.063  18.128 -41.170  1.00  0.00           H  
ATOM    205  HA  ASN A  15     -92.825  20.033 -41.242  1.00  0.00           H  
ATOM    206  HB2 ASN A  15     -92.284  17.884 -42.395  1.00  0.00           H  
ATOM    207  HB3 ASN A  15     -93.638  18.156 -43.480  1.00  0.00           H  
ATOM    208 HD21 ASN A  15     -91.223  20.443 -42.248  1.00  0.00           H  
ATOM    209 HD22 ASN A  15     -90.607  20.880 -43.812  1.00  0.00           H  
ATOM    210  N   TYR A  16     -93.966  21.509 -43.017  1.00  0.00           N  
ATOM    211  CA  TYR A  16     -94.738  22.578 -43.613  1.00  0.00           C  
ATOM    212  C   TYR A  16     -93.935  23.211 -44.736  1.00  0.00           C  
ATOM    213  O   TYR A  16     -92.703  23.237 -44.686  1.00  0.00           O  
ATOM    214  CB  TYR A  16     -95.074  23.636 -42.564  1.00  0.00           C  
ATOM    215  CG  TYR A  16     -96.159  24.605 -42.982  1.00  0.00           C  
ATOM    216  CD1 TYR A  16     -97.498  24.263 -42.866  1.00  0.00           C  
ATOM    217  CD2 TYR A  16     -95.844  25.860 -43.485  1.00  0.00           C  
ATOM    218  CE1 TYR A  16     -98.493  25.141 -43.239  1.00  0.00           C  
ATOM    219  CE2 TYR A  16     -96.835  26.746 -43.862  1.00  0.00           C  
ATOM    220  CZ  TYR A  16     -98.158  26.381 -43.738  1.00  0.00           C  
ATOM    221  OH  TYR A  16     -99.149  27.259 -44.116  1.00  0.00           O  
ATOM    222  H   TYR A  16     -92.988  21.545 -43.071  1.00  0.00           H  
ATOM    223  HA  TYR A  16     -95.650  22.162 -44.012  1.00  0.00           H  
ATOM    224  HB2 TYR A  16     -95.395  23.151 -41.656  1.00  0.00           H  
ATOM    225  HB3 TYR A  16     -94.187  24.212 -42.366  1.00  0.00           H  
ATOM    226  HD1 TYR A  16     -97.760  23.287 -42.485  1.00  0.00           H  
ATOM    227  HD2 TYR A  16     -94.806  26.142 -43.581  1.00  0.00           H  
ATOM    228  HE1 TYR A  16     -99.530  24.855 -43.134  1.00  0.00           H  
ATOM    229  HE2 TYR A  16     -96.569  27.718 -44.253  1.00  0.00           H  
ATOM    230  HH  TYR A  16     -98.902  27.677 -44.947  1.00  0.00           H  
ATOM    231  N   ASP A  17     -94.639  23.713 -45.735  1.00  0.00           N  
ATOM    232  CA  ASP A  17     -94.021  24.388 -46.874  1.00  0.00           C  
ATOM    233  C   ASP A  17     -95.101  24.848 -47.833  1.00  0.00           C  
ATOM    234  O   ASP A  17     -95.937  24.048 -48.259  1.00  0.00           O  
ATOM    235  CB  ASP A  17     -93.030  23.477 -47.607  1.00  0.00           C  
ATOM    236  CG  ASP A  17     -92.159  24.242 -48.583  1.00  0.00           C  
ATOM    237  OD1 ASP A  17     -91.227  24.942 -48.126  1.00  0.00           O  
ATOM    238  OD2 ASP A  17     -92.404  24.157 -49.802  1.00  0.00           O  
ATOM    239  H   ASP A  17     -95.614  23.646 -45.699  1.00  0.00           H  
ATOM    240  HA  ASP A  17     -93.499  25.254 -46.499  1.00  0.00           H  
ATOM    241  HB2 ASP A  17     -92.391  22.994 -46.882  1.00  0.00           H  
ATOM    242  HB3 ASP A  17     -93.579  22.724 -48.154  1.00  0.00           H  
ATOM    243  N   GLY A  18     -95.088  26.134 -48.163  1.00  0.00           N  
ATOM    244  CA  GLY A  18     -96.187  26.713 -48.909  1.00  0.00           C  
ATOM    245  C   GLY A  18     -97.467  26.599 -48.118  1.00  0.00           C  
ATOM    246  O   GLY A  18     -97.669  27.315 -47.134  1.00  0.00           O  
ATOM    247  H   GLY A  18     -94.324  26.694 -47.896  1.00  0.00           H  
ATOM    248  HA2 GLY A  18     -95.976  27.757 -49.103  1.00  0.00           H  
ATOM    249  HA3 GLY A  18     -96.301  26.190 -49.846  1.00  0.00           H  
ATOM    250  N   SER A  19     -98.328  25.691 -48.530  1.00  0.00           N  
ATOM    251  CA  SER A  19     -99.440  25.285 -47.705  1.00  0.00           C  
ATOM    252  C   SER A  19     -99.516  23.764 -47.708  1.00  0.00           C  
ATOM    253  O   SER A  19    -100.210  23.160 -48.527  1.00  0.00           O  
ATOM    254  CB  SER A  19    -100.731  25.889 -48.257  1.00  0.00           C  
ATOM    255  OG  SER A  19    -100.623  27.298 -48.387  1.00  0.00           O  
ATOM    256  H   SER A  19     -98.211  25.279 -49.410  1.00  0.00           H  
ATOM    257  HA  SER A  19     -99.271  25.639 -46.699  1.00  0.00           H  
ATOM    258  HB2 SER A  19    -100.928  25.469 -49.230  1.00  0.00           H  
ATOM    259  HB3 SER A  19    -101.550  25.659 -47.590  1.00  0.00           H  
ATOM    260  HG  SER A  19    -100.015  27.506 -49.117  1.00  0.00           H  
ATOM    261  N   THR A  20     -98.764  23.145 -46.812  1.00  0.00           N  
ATOM    262  CA  THR A  20     -98.776  21.703 -46.663  1.00  0.00           C  
ATOM    263  C   THR A  20     -98.520  21.309 -45.215  1.00  0.00           C  
ATOM    264  O   THR A  20     -97.639  21.869 -44.566  1.00  0.00           O  
ATOM    265  CB  THR A  20     -97.739  21.033 -47.590  1.00  0.00           C  
ATOM    266  OG1 THR A  20     -98.045  21.344 -48.959  1.00  0.00           O  
ATOM    267  CG2 THR A  20     -97.728  19.521 -47.400  1.00  0.00           C  
ATOM    268  H   THR A  20     -98.180  23.674 -46.232  1.00  0.00           H  
ATOM    269  HA  THR A  20     -99.757  21.352 -46.949  1.00  0.00           H  
ATOM    270  HB  THR A  20     -96.758  21.419 -47.350  1.00  0.00           H  
ATOM    271  HG1 THR A  20     -98.813  21.935 -48.983  1.00  0.00           H  
ATOM    272 HG21 THR A  20     -98.744  19.151 -47.399  1.00  0.00           H  
ATOM    273 HG22 THR A  20     -97.257  19.280 -46.458  1.00  0.00           H  
ATOM    274 HG23 THR A  20     -97.179  19.062 -48.208  1.00  0.00           H  
ATOM    275  N   PHE A  21     -99.286  20.358 -44.716  1.00  0.00           N  
ATOM    276  CA  PHE A  21     -99.040  19.769 -43.414  1.00  0.00           C  
ATOM    277  C   PHE A  21     -98.739  18.300 -43.611  1.00  0.00           C  
ATOM    278  O   PHE A  21     -99.355  17.629 -44.432  1.00  0.00           O  
ATOM    279  CB  PHE A  21    -100.261  19.946 -42.499  1.00  0.00           C  
ATOM    280  CG  PHE A  21    -100.083  19.419 -41.094  1.00  0.00           C  
ATOM    281  CD1 PHE A  21    -100.145  18.059 -40.826  1.00  0.00           C  
ATOM    282  CD2 PHE A  21     -99.861  20.289 -40.040  1.00  0.00           C  
ATOM    283  CE1 PHE A  21     -99.985  17.581 -39.539  1.00  0.00           C  
ATOM    284  CE2 PHE A  21     -99.702  19.814 -38.747  1.00  0.00           C  
ATOM    285  CZ  PHE A  21     -99.765  18.459 -38.500  1.00  0.00           C  
ATOM    286  H   PHE A  21    -100.040  20.022 -45.248  1.00  0.00           H  
ATOM    287  HA  PHE A  21     -98.175  20.246 -42.966  1.00  0.00           H  
ATOM    288  HB2 PHE A  21    -100.488  20.998 -42.426  1.00  0.00           H  
ATOM    289  HB3 PHE A  21    -101.103  19.435 -42.943  1.00  0.00           H  
ATOM    290  HD1 PHE A  21    -100.317  17.368 -41.637  1.00  0.00           H  
ATOM    291  HD2 PHE A  21     -99.816  21.347 -40.236  1.00  0.00           H  
ATOM    292  HE1 PHE A  21    -100.034  16.518 -39.348  1.00  0.00           H  
ATOM    293  HE2 PHE A  21     -99.536  20.505 -37.931  1.00  0.00           H  
ATOM    294  HZ  PHE A  21     -99.640  18.086 -37.495  1.00  0.00           H  
ATOM    295  N   SER A  22     -97.776  17.818 -42.882  1.00  0.00           N  
ATOM    296  CA  SER A  22     -97.463  16.409 -42.881  1.00  0.00           C  
ATOM    297  C   SER A  22     -96.908  16.036 -41.533  1.00  0.00           C  
ATOM    298  O   SER A  22     -95.798  16.415 -41.169  1.00  0.00           O  
ATOM    299  CB  SER A  22     -96.490  16.050 -43.996  1.00  0.00           C  
ATOM    300  OG  SER A  22     -95.347  16.890 -43.979  1.00  0.00           O  
ATOM    301  H   SER A  22     -97.265  18.429 -42.309  1.00  0.00           H  
ATOM    302  HA  SER A  22     -98.386  15.870 -43.033  1.00  0.00           H  
ATOM    303  HB2 SER A  22     -96.178  15.027 -43.855  1.00  0.00           H  
ATOM    304  HB3 SER A  22     -96.986  16.154 -44.954  1.00  0.00           H  
ATOM    305  HG  SER A  22     -95.154  17.195 -44.876  1.00  0.00           H  
ATOM    306  N   GLY A  23     -97.682  15.290 -40.792  1.00  0.00           N  
ATOM    307  CA  GLY A  23     -97.396  15.116 -39.396  1.00  0.00           C  
ATOM    308  C   GLY A  23     -97.483  13.688 -38.953  1.00  0.00           C  
ATOM    309  O   GLY A  23     -98.253  12.896 -39.499  1.00  0.00           O  
ATOM    310  H   GLY A  23     -98.432  14.813 -41.210  1.00  0.00           H  
ATOM    311  HA2 GLY A  23     -96.400  15.477 -39.199  1.00  0.00           H  
ATOM    312  HA3 GLY A  23     -98.099  15.703 -38.824  1.00  0.00           H  
ATOM    313  N   LYS A  24     -96.685  13.361 -37.967  1.00  0.00           N  
ATOM    314  CA  LYS A  24     -96.704  12.049 -37.389  1.00  0.00           C  
ATOM    315  C   LYS A  24     -96.544  12.166 -35.882  1.00  0.00           C  
ATOM    316  O   LYS A  24     -95.988  13.146 -35.374  1.00  0.00           O  
ATOM    317  CB  LYS A  24     -95.625  11.175 -38.020  1.00  0.00           C  
ATOM    318  CG  LYS A  24     -94.224  11.731 -37.876  1.00  0.00           C  
ATOM    319  CD  LYS A  24     -93.191  10.824 -38.524  1.00  0.00           C  
ATOM    320  CE  LYS A  24     -91.796  11.431 -38.468  1.00  0.00           C  
ATOM    321  NZ  LYS A  24     -91.702  12.676 -39.272  1.00  0.00           N  
ATOM    322  H   LYS A  24     -96.060  14.032 -37.608  1.00  0.00           H  
ATOM    323  HA  LYS A  24     -97.672  11.614 -37.595  1.00  0.00           H  
ATOM    324  HB2 LYS A  24     -95.651  10.201 -37.553  1.00  0.00           H  
ATOM    325  HB3 LYS A  24     -95.851  11.067 -39.080  1.00  0.00           H  
ATOM    326  HG2 LYS A  24     -94.181  12.705 -38.339  1.00  0.00           H  
ATOM    327  HG3 LYS A  24     -94.004  11.819 -36.822  1.00  0.00           H  
ATOM    328  HD2 LYS A  24     -93.178   9.877 -38.006  1.00  0.00           H  
ATOM    329  HD3 LYS A  24     -93.463  10.667 -39.559  1.00  0.00           H  
ATOM    330  HE2 LYS A  24     -91.555  11.656 -37.439  1.00  0.00           H  
ATOM    331  HE3 LYS A  24     -91.088  10.709 -38.853  1.00  0.00           H  
ATOM    332  HZ1 LYS A  24     -91.847  12.465 -40.284  1.00  0.00           H  
ATOM    333  HZ2 LYS A  24     -90.762  13.111 -39.153  1.00  0.00           H  
ATOM    334  HZ3 LYS A  24     -92.424  13.360 -38.966  1.00  0.00           H  
ATOM    335  N   ILE A  25     -97.039  11.176 -35.170  1.00  0.00           N  
ATOM    336  CA  ILE A  25     -97.244  11.299 -33.740  1.00  0.00           C  
ATOM    337  C   ILE A  25     -96.745  10.056 -33.005  1.00  0.00           C  
ATOM    338  O   ILE A  25     -96.694   8.962 -33.572  1.00  0.00           O  
ATOM    339  CB  ILE A  25     -98.741  11.534 -33.426  1.00  0.00           C  
ATOM    340  CG1 ILE A  25     -99.325  12.597 -34.366  1.00  0.00           C  
ATOM    341  CG2 ILE A  25     -98.920  11.968 -31.978  1.00  0.00           C  
ATOM    342  CD1 ILE A  25    -100.809  12.817 -34.194  1.00  0.00           C  
ATOM    343  H   ILE A  25     -97.246  10.328 -35.619  1.00  0.00           H  
ATOM    344  HA  ILE A  25     -96.687  12.159 -33.395  1.00  0.00           H  
ATOM    345  HB  ILE A  25     -99.266  10.604 -33.572  1.00  0.00           H  
ATOM    346 HG12 ILE A  25     -98.829  13.540 -34.186  1.00  0.00           H  
ATOM    347 HG13 ILE A  25     -99.150  12.296 -35.388  1.00  0.00           H  
ATOM    348 HG21 ILE A  25     -98.534  11.200 -31.322  1.00  0.00           H  
ATOM    349 HG22 ILE A  25     -99.969  12.122 -31.774  1.00  0.00           H  
ATOM    350 HG23 ILE A  25     -98.382  12.888 -31.810  1.00  0.00           H  
ATOM    351 HD11 ILE A  25    -101.014  13.134 -33.182  1.00  0.00           H  
ATOM    352 HD12 ILE A  25    -101.335  11.896 -34.397  1.00  0.00           H  
ATOM    353 HD13 ILE A  25    -101.143  13.580 -34.883  1.00  0.00           H  
ATOM    354  N   TYR A  26     -96.397  10.248 -31.744  1.00  0.00           N  
ATOM    355  CA  TYR A  26     -95.783   9.219 -30.922  1.00  0.00           C  
ATOM    356  C   TYR A  26     -96.639   8.998 -29.663  1.00  0.00           C  
ATOM    357  O   TYR A  26     -96.552   9.767 -28.708  1.00  0.00           O  
ATOM    358  CB  TYR A  26     -94.381   9.721 -30.556  1.00  0.00           C  
ATOM    359  CG  TYR A  26     -93.421   8.681 -30.044  1.00  0.00           C  
ATOM    360  CD1 TYR A  26     -93.617   8.073 -28.821  1.00  0.00           C  
ATOM    361  CD2 TYR A  26     -92.293   8.341 -30.779  1.00  0.00           C  
ATOM    362  CE1 TYR A  26     -92.713   7.145 -28.338  1.00  0.00           C  
ATOM    363  CE2 TYR A  26     -91.389   7.411 -30.309  1.00  0.00           C  
ATOM    364  CZ  TYR A  26     -91.602   6.817 -29.086  1.00  0.00           C  
ATOM    365  OH  TYR A  26     -90.695   5.899 -28.608  1.00  0.00           O  
ATOM    366  H   TYR A  26     -96.560  11.130 -31.340  1.00  0.00           H  
ATOM    367  HA  TYR A  26     -95.714   8.304 -31.490  1.00  0.00           H  
ATOM    368  HB2 TYR A  26     -93.933  10.164 -31.431  1.00  0.00           H  
ATOM    369  HB3 TYR A  26     -94.479  10.481 -29.793  1.00  0.00           H  
ATOM    370  HD1 TYR A  26     -94.497   8.334 -28.244  1.00  0.00           H  
ATOM    371  HD2 TYR A  26     -92.130   8.809 -31.737  1.00  0.00           H  
ATOM    372  HE1 TYR A  26     -92.882   6.680 -27.381  1.00  0.00           H  
ATOM    373  HE2 TYR A  26     -90.520   7.157 -30.899  1.00  0.00           H  
ATOM    374  HH  TYR A  26     -89.808   6.266 -28.669  1.00  0.00           H  
ATOM    375  N   VAL A  27     -97.477   7.959 -29.655  1.00  0.00           N  
ATOM    376  CA  VAL A  27     -98.470   7.811 -28.582  1.00  0.00           C  
ATOM    377  C   VAL A  27     -98.558   6.376 -28.065  1.00  0.00           C  
ATOM    378  O   VAL A  27     -98.315   5.414 -28.798  1.00  0.00           O  
ATOM    379  CB  VAL A  27     -99.887   8.308 -29.013  1.00  0.00           C  
ATOM    380  CG1 VAL A  27     -99.862   8.951 -30.387  1.00  0.00           C  
ATOM    381  CG2 VAL A  27    -100.929   7.197 -28.976  1.00  0.00           C  
ATOM    382  H   VAL A  27     -97.404   7.271 -30.348  1.00  0.00           H  
ATOM    383  HA  VAL A  27     -98.140   8.432 -27.766  1.00  0.00           H  
ATOM    384  HB  VAL A  27    -100.195   9.068 -28.306  1.00  0.00           H  
ATOM    385 HG11 VAL A  27    -100.859   9.260 -30.657  1.00  0.00           H  
ATOM    386 HG12 VAL A  27     -99.497   8.237 -31.112  1.00  0.00           H  
ATOM    387 HG13 VAL A  27     -99.209   9.813 -30.371  1.00  0.00           H  
ATOM    388 HG21 VAL A  27    -100.998   6.798 -27.976  1.00  0.00           H  
ATOM    389 HG22 VAL A  27    -100.640   6.411 -29.659  1.00  0.00           H  
ATOM    390 HG23 VAL A  27    -101.889   7.592 -29.274  1.00  0.00           H  
ATOM    391  N   LYS A  28     -98.902   6.255 -26.784  1.00  0.00           N  
ATOM    392  CA  LYS A  28     -99.028   4.964 -26.128  1.00  0.00           C  
ATOM    393  C   LYS A  28    -100.368   4.313 -26.426  1.00  0.00           C  
ATOM    394  O   LYS A  28    -101.392   4.977 -26.530  1.00  0.00           O  
ATOM    395  CB  LYS A  28     -98.850   5.108 -24.609  1.00  0.00           C  
ATOM    396  CG  LYS A  28     -99.474   3.975 -23.802  1.00  0.00           C  
ATOM    397  CD  LYS A  28     -98.915   3.889 -22.395  1.00  0.00           C  
ATOM    398  CE  LYS A  28     -97.582   3.158 -22.371  1.00  0.00           C  
ATOM    399  NZ  LYS A  28     -97.681   1.807 -22.995  1.00  0.00           N  
ATOM    400  H   LYS A  28     -99.085   7.067 -26.264  1.00  0.00           H  
ATOM    401  HA  LYS A  28     -98.244   4.328 -26.509  1.00  0.00           H  
ATOM    402  HB2 LYS A  28     -97.793   5.140 -24.387  1.00  0.00           H  
ATOM    403  HB3 LYS A  28     -99.301   6.038 -24.293  1.00  0.00           H  
ATOM    404  HG2 LYS A  28    -100.540   4.137 -23.740  1.00  0.00           H  
ATOM    405  HG3 LYS A  28     -99.284   3.042 -24.310  1.00  0.00           H  
ATOM    406  HD2 LYS A  28     -98.774   4.889 -22.011  1.00  0.00           H  
ATOM    407  HD3 LYS A  28     -99.619   3.357 -21.772  1.00  0.00           H  
ATOM    408  HE2 LYS A  28     -96.853   3.744 -22.911  1.00  0.00           H  
ATOM    409  HE3 LYS A  28     -97.264   3.047 -21.343  1.00  0.00           H  
ATOM    410  HZ1 LYS A  28     -97.579   1.873 -24.031  1.00  0.00           H  
ATOM    411  HZ2 LYS A  28     -98.609   1.381 -22.782  1.00  0.00           H  
ATOM    412  HZ3 LYS A  28     -96.939   1.177 -22.622  1.00  0.00           H  
ATOM    413  N   ASN A  29    -100.330   3.003 -26.549  1.00  0.00           N  
ATOM    414  CA  ASN A  29    -101.517   2.186 -26.723  1.00  0.00           C  
ATOM    415  C   ASN A  29    -102.171   1.890 -25.369  1.00  0.00           C  
ATOM    416  O   ASN A  29    -101.682   1.069 -24.598  1.00  0.00           O  
ATOM    417  CB  ASN A  29    -101.139   0.872 -27.428  1.00  0.00           C  
ATOM    418  CG  ASN A  29     -99.949   0.156 -26.783  1.00  0.00           C  
ATOM    419  OD1 ASN A  29     -99.039   0.789 -26.243  1.00  0.00           O  
ATOM    420  ND2 ASN A  29     -99.939  -1.164 -26.848  1.00  0.00           N  
ATOM    421  H   ASN A  29     -99.456   2.553 -26.515  1.00  0.00           H  
ATOM    422  HA  ASN A  29    -102.214   2.733 -27.340  1.00  0.00           H  
ATOM    423  HB2 ASN A  29    -101.988   0.203 -27.400  1.00  0.00           H  
ATOM    424  HB3 ASN A  29    -100.889   1.089 -28.459  1.00  0.00           H  
ATOM    425 HD21 ASN A  29    -100.688  -1.614 -27.305  1.00  0.00           H  
ATOM    426 HD22 ASN A  29     -99.188  -1.644 -26.430  1.00  0.00           H  
ATOM    427  N   ILE A  30    -103.270   2.578 -25.074  1.00  0.00           N  
ATOM    428  CA  ILE A  30    -104.008   2.325 -23.834  1.00  0.00           C  
ATOM    429  C   ILE A  30    -104.901   1.120 -24.048  1.00  0.00           C  
ATOM    430  O   ILE A  30    -104.796   0.100 -23.368  1.00  0.00           O  
ATOM    431  CB  ILE A  30    -104.907   3.515 -23.414  1.00  0.00           C  
ATOM    432  CG1 ILE A  30    -104.170   4.854 -23.523  1.00  0.00           C  
ATOM    433  CG2 ILE A  30    -105.429   3.306 -22.002  1.00  0.00           C  
ATOM    434  CD1 ILE A  30    -102.870   4.932 -22.758  1.00  0.00           C  
ATOM    435  H   ILE A  30    -103.600   3.250 -25.705  1.00  0.00           H  
ATOM    436  HA  ILE A  30    -103.300   2.116 -23.044  1.00  0.00           H  
ATOM    437  HB  ILE A  30    -105.759   3.533 -24.078  1.00  0.00           H  
ATOM    438 HG12 ILE A  30    -103.945   5.045 -24.562  1.00  0.00           H  
ATOM    439 HG13 ILE A  30    -104.816   5.638 -23.155  1.00  0.00           H  
ATOM    440 HG21 ILE A  30    -105.996   4.173 -21.694  1.00  0.00           H  
ATOM    441 HG22 ILE A  30    -104.599   3.161 -21.332  1.00  0.00           H  
ATOM    442 HG23 ILE A  30    -106.065   2.434 -21.978  1.00  0.00           H  
ATOM    443 HD11 ILE A  30    -102.400   5.885 -22.955  1.00  0.00           H  
ATOM    444 HD12 ILE A  30    -102.218   4.136 -23.082  1.00  0.00           H  
ATOM    445 HD13 ILE A  30    -103.064   4.836 -21.700  1.00  0.00           H  
ATOM    446  N   ALA A  31    -105.772   1.265 -25.026  1.00  0.00           N  
ATOM    447  CA  ALA A  31    -106.633   0.207 -25.470  1.00  0.00           C  
ATOM    448  C   ALA A  31    -106.426   0.040 -26.961  1.00  0.00           C  
ATOM    449  O   ALA A  31    -105.351   0.361 -27.473  1.00  0.00           O  
ATOM    450  CB  ALA A  31    -108.078   0.520 -25.141  1.00  0.00           C  
ATOM    451  H   ALA A  31    -105.819   2.116 -25.489  1.00  0.00           H  
ATOM    452  HA  ALA A  31    -106.353  -0.694 -24.965  1.00  0.00           H  
ATOM    453  HB1 ALA A  31    -108.709  -0.292 -25.470  1.00  0.00           H  
ATOM    454  HB2 ALA A  31    -108.362   1.423 -25.645  1.00  0.00           H  
ATOM    455  HB3 ALA A  31    -108.185   0.654 -24.074  1.00  0.00           H  
ATOM    456  N   TYR A  32    -107.429  -0.420 -27.670  1.00  0.00           N  
ATOM    457  CA  TYR A  32    -107.273  -0.633 -29.089  1.00  0.00           C  
ATOM    458  C   TYR A  32    -108.058   0.387 -29.893  1.00  0.00           C  
ATOM    459  O   TYR A  32    -107.543   0.960 -30.855  1.00  0.00           O  
ATOM    460  CB  TYR A  32    -107.690  -2.045 -29.438  1.00  0.00           C  
ATOM    461  CG  TYR A  32    -107.396  -2.421 -30.868  1.00  0.00           C  
ATOM    462  CD1 TYR A  32    -106.089  -2.517 -31.311  1.00  0.00           C  
ATOM    463  CD2 TYR A  32    -108.418  -2.677 -31.772  1.00  0.00           C  
ATOM    464  CE1 TYR A  32    -105.802  -2.862 -32.617  1.00  0.00           C  
ATOM    465  CE2 TYR A  32    -108.142  -3.022 -33.080  1.00  0.00           C  
ATOM    466  CZ  TYR A  32    -106.831  -3.113 -33.497  1.00  0.00           C  
ATOM    467  OH  TYR A  32    -106.547  -3.462 -34.796  1.00  0.00           O  
ATOM    468  H   TYR A  32    -108.284  -0.627 -27.234  1.00  0.00           H  
ATOM    469  HA  TYR A  32    -106.223  -0.516 -29.320  1.00  0.00           H  
ATOM    470  HB2 TYR A  32    -107.154  -2.719 -28.789  1.00  0.00           H  
ATOM    471  HB3 TYR A  32    -108.751  -2.153 -29.272  1.00  0.00           H  
ATOM    472  HD1 TYR A  32    -105.291  -2.315 -30.618  1.00  0.00           H  
ATOM    473  HD2 TYR A  32    -109.444  -2.604 -31.440  1.00  0.00           H  
ATOM    474  HE1 TYR A  32    -104.775  -2.931 -32.942  1.00  0.00           H  
ATOM    475  HE2 TYR A  32    -108.949  -3.219 -33.769  1.00  0.00           H  
ATOM    476  HH  TYR A  32    -105.919  -4.208 -34.791  1.00  0.00           H  
ATOM    477  N   SER A  33    -109.293   0.628 -29.491  1.00  0.00           N  
ATOM    478  CA  SER A  33    -110.129   1.586 -30.181  1.00  0.00           C  
ATOM    479  C   SER A  33    -109.718   3.004 -29.799  1.00  0.00           C  
ATOM    480  O   SER A  33    -110.295   3.625 -28.902  1.00  0.00           O  
ATOM    481  CB  SER A  33    -111.604   1.338 -29.854  1.00  0.00           C  
ATOM    482  OG  SER A  33    -112.459   2.108 -30.685  1.00  0.00           O  
ATOM    483  H   SER A  33    -109.653   0.148 -28.707  1.00  0.00           H  
ATOM    484  HA  SER A  33    -109.973   1.448 -31.243  1.00  0.00           H  
ATOM    485  HB2 SER A  33    -111.833   0.288 -30.004  1.00  0.00           H  
ATOM    486  HB3 SER A  33    -111.790   1.606 -28.821  1.00  0.00           H  
ATOM    487  HG  SER A  33    -111.930   2.548 -31.373  1.00  0.00           H  
ATOM    488  N   LYS A  34    -108.684   3.490 -30.464  1.00  0.00           N  
ATOM    489  CA  LYS A  34    -108.178   4.816 -30.239  1.00  0.00           C  
ATOM    490  C   LYS A  34    -108.477   5.671 -31.455  1.00  0.00           C  
ATOM    491  O   LYS A  34    -108.597   5.148 -32.563  1.00  0.00           O  
ATOM    492  CB  LYS A  34    -106.671   4.729 -30.012  1.00  0.00           C  
ATOM    493  CG  LYS A  34    -106.283   3.742 -28.933  1.00  0.00           C  
ATOM    494  CD  LYS A  34    -104.837   3.304 -29.066  1.00  0.00           C  
ATOM    495  CE  LYS A  34    -104.576   2.676 -30.429  1.00  0.00           C  
ATOM    496  NZ  LYS A  34    -103.206   2.113 -30.532  1.00  0.00           N  
ATOM    497  H   LYS A  34    -108.239   2.929 -31.135  1.00  0.00           H  
ATOM    498  HA  LYS A  34    -108.658   5.234 -29.368  1.00  0.00           H  
ATOM    499  HB2 LYS A  34    -106.205   4.412 -30.927  1.00  0.00           H  
ATOM    500  HB3 LYS A  34    -106.297   5.700 -29.739  1.00  0.00           H  
ATOM    501  HG2 LYS A  34    -106.428   4.198 -27.966  1.00  0.00           H  
ATOM    502  HG3 LYS A  34    -106.918   2.878 -29.028  1.00  0.00           H  
ATOM    503  HD2 LYS A  34    -104.194   4.163 -28.944  1.00  0.00           H  
ATOM    504  HD3 LYS A  34    -104.622   2.577 -28.300  1.00  0.00           H  
ATOM    505  HE2 LYS A  34    -105.291   1.883 -30.588  1.00  0.00           H  
ATOM    506  HE3 LYS A  34    -104.705   3.432 -31.189  1.00  0.00           H  
ATOM    507  HZ1 LYS A  34    -102.534   2.701 -30.007  1.00  0.00           H  
ATOM    508  HZ2 LYS A  34    -102.907   2.087 -31.538  1.00  0.00           H  
ATOM    509  HZ3 LYS A  34    -103.184   1.142 -30.154  1.00  0.00           H  
ATOM    510  N   LYS A  35    -108.613   6.965 -31.257  1.00  0.00           N  
ATOM    511  CA  LYS A  35    -108.817   7.871 -32.367  1.00  0.00           C  
ATOM    512  C   LYS A  35    -108.059   9.158 -32.100  1.00  0.00           C  
ATOM    513  O   LYS A  35    -108.376   9.933 -31.193  1.00  0.00           O  
ATOM    514  CB  LYS A  35    -110.308   8.133 -32.629  1.00  0.00           C  
ATOM    515  CG  LYS A  35    -111.056   8.683 -31.434  1.00  0.00           C  
ATOM    516  CD  LYS A  35    -112.471   9.107 -31.796  1.00  0.00           C  
ATOM    517  CE  LYS A  35    -112.470  10.271 -32.774  1.00  0.00           C  
ATOM    518  NZ  LYS A  35    -113.845  10.749 -33.066  1.00  0.00           N  
ATOM    519  H   LYS A  35    -108.556   7.332 -30.341  1.00  0.00           H  
ATOM    520  HA  LYS A  35    -108.388   7.405 -33.241  1.00  0.00           H  
ATOM    521  HB2 LYS A  35    -110.399   8.841 -33.439  1.00  0.00           H  
ATOM    522  HB3 LYS A  35    -110.776   7.204 -32.921  1.00  0.00           H  
ATOM    523  HG2 LYS A  35    -111.099   7.924 -30.669  1.00  0.00           H  
ATOM    524  HG3 LYS A  35    -110.515   9.538 -31.066  1.00  0.00           H  
ATOM    525  HD2 LYS A  35    -112.983   8.270 -32.247  1.00  0.00           H  
ATOM    526  HD3 LYS A  35    -112.987   9.403 -30.895  1.00  0.00           H  
ATOM    527  HE2 LYS A  35    -111.901  11.083 -32.348  1.00  0.00           H  
ATOM    528  HE3 LYS A  35    -112.007   9.950 -33.694  1.00  0.00           H  
ATOM    529  HZ1 LYS A  35    -114.395  10.000 -33.540  1.00  0.00           H  
ATOM    530  HZ2 LYS A  35    -113.814  11.585 -33.687  1.00  0.00           H  
ATOM    531  HZ3 LYS A  35    -114.328  11.004 -32.178  1.00  0.00           H  
ATOM    532  N   VAL A  36    -107.020   9.352 -32.869  1.00  0.00           N  
ATOM    533  CA  VAL A  36    -106.138  10.472 -32.669  1.00  0.00           C  
ATOM    534  C   VAL A  36    -106.575  11.649 -33.510  1.00  0.00           C  
ATOM    535  O   VAL A  36    -106.736  11.551 -34.727  1.00  0.00           O  
ATOM    536  CB  VAL A  36    -104.683  10.081 -32.962  1.00  0.00           C  
ATOM    537  CG1 VAL A  36    -103.783  11.282 -32.992  1.00  0.00           C  
ATOM    538  CG2 VAL A  36    -104.198   9.128 -31.898  1.00  0.00           C  
ATOM    539  H   VAL A  36    -106.849   8.729 -33.599  1.00  0.00           H  
ATOM    540  HA  VAL A  36    -106.207  10.759 -31.631  1.00  0.00           H  
ATOM    541  HB  VAL A  36    -104.636   9.584 -33.918  1.00  0.00           H  
ATOM    542 HG11 VAL A  36    -102.867  11.018 -33.484  1.00  0.00           H  
ATOM    543 HG12 VAL A  36    -103.573  11.572 -31.982  1.00  0.00           H  
ATOM    544 HG13 VAL A  36    -104.265  12.094 -33.517  1.00  0.00           H  
ATOM    545 HG21 VAL A  36    -104.809   8.249 -31.919  1.00  0.00           H  
ATOM    546 HG22 VAL A  36    -104.269   9.599 -30.928  1.00  0.00           H  
ATOM    547 HG23 VAL A  36    -103.170   8.858 -32.096  1.00  0.00           H  
ATOM    548  N   THR A  37    -106.781  12.755 -32.833  1.00  0.00           N  
ATOM    549  CA  THR A  37    -107.395  13.911 -33.427  1.00  0.00           C  
ATOM    550  C   THR A  37    -106.502  15.131 -33.308  1.00  0.00           C  
ATOM    551  O   THR A  37    -106.153  15.567 -32.207  1.00  0.00           O  
ATOM    552  CB  THR A  37    -108.755  14.170 -32.748  1.00  0.00           C  
ATOM    553  OG1 THR A  37    -108.575  14.320 -31.333  1.00  0.00           O  
ATOM    554  CG2 THR A  37    -109.710  13.013 -33.007  1.00  0.00           C  
ATOM    555  H   THR A  37    -106.507  12.794 -31.892  1.00  0.00           H  
ATOM    556  HA  THR A  37    -107.572  13.718 -34.478  1.00  0.00           H  
ATOM    557  HB  THR A  37    -109.181  15.073 -33.149  1.00  0.00           H  
ATOM    558  HG1 THR A  37    -109.070  13.637 -30.873  1.00  0.00           H  
ATOM    559 HG21 THR A  37    -109.555  12.640 -34.008  1.00  0.00           H  
ATOM    560 HG22 THR A  37    -110.729  13.355 -32.903  1.00  0.00           H  
ATOM    561 HG23 THR A  37    -109.521  12.222 -32.294  1.00  0.00           H  
ATOM    562  N   VAL A  38    -106.091  15.657 -34.448  1.00  0.00           N  
ATOM    563  CA  VAL A  38    -105.409  16.926 -34.463  1.00  0.00           C  
ATOM    564  C   VAL A  38    -106.398  18.020 -34.200  1.00  0.00           C  
ATOM    565  O   VAL A  38    -107.522  17.977 -34.675  1.00  0.00           O  
ATOM    566  CB  VAL A  38    -104.763  17.273 -35.814  1.00  0.00           C  
ATOM    567  CG1 VAL A  38    -104.262  18.703 -35.829  1.00  0.00           C  
ATOM    568  CG2 VAL A  38    -103.609  16.400 -36.151  1.00  0.00           C  
ATOM    569  H   VAL A  38    -106.258  15.187 -35.292  1.00  0.00           H  
ATOM    570  HA  VAL A  38    -104.648  16.926 -33.697  1.00  0.00           H  
ATOM    571  HB  VAL A  38    -105.507  17.165 -36.588  1.00  0.00           H  
ATOM    572 HG11 VAL A  38    -104.002  18.983 -36.840  1.00  0.00           H  
ATOM    573 HG12 VAL A  38    -103.378  18.786 -35.208  1.00  0.00           H  
ATOM    574 HG13 VAL A  38    -105.031  19.362 -35.457  1.00  0.00           H  
ATOM    575 HG21 VAL A  38    -103.001  16.963 -36.838  1.00  0.00           H  
ATOM    576 HG22 VAL A  38    -103.955  15.490 -36.620  1.00  0.00           H  
ATOM    577 HG23 VAL A  38    -103.043  16.171 -35.261  1.00  0.00           H  
ATOM    578  N   VAL A  39    -105.973  18.985 -33.450  1.00  0.00           N  
ATOM    579  CA  VAL A  39    -106.610  20.268 -33.473  1.00  0.00           C  
ATOM    580  C   VAL A  39    -105.537  21.280 -33.785  1.00  0.00           C  
ATOM    581  O   VAL A  39    -104.735  21.627 -32.917  1.00  0.00           O  
ATOM    582  CB  VAL A  39    -107.344  20.625 -32.160  1.00  0.00           C  
ATOM    583  CG1 VAL A  39    -108.848  20.523 -32.352  1.00  0.00           C  
ATOM    584  CG2 VAL A  39    -106.905  19.724 -31.024  1.00  0.00           C  
ATOM    585  H   VAL A  39    -105.184  18.842 -32.883  1.00  0.00           H  
ATOM    586  HA  VAL A  39    -107.330  20.265 -34.282  1.00  0.00           H  
ATOM    587  HB  VAL A  39    -107.105  21.647 -31.900  1.00  0.00           H  
ATOM    588 HG11 VAL A  39    -109.105  19.515 -32.639  1.00  0.00           H  
ATOM    589 HG12 VAL A  39    -109.160  21.208 -33.128  1.00  0.00           H  
ATOM    590 HG13 VAL A  39    -109.346  20.774 -31.429  1.00  0.00           H  
ATOM    591 HG21 VAL A  39    -107.467  19.969 -30.133  1.00  0.00           H  
ATOM    592 HG22 VAL A  39    -105.852  19.868 -30.836  1.00  0.00           H  
ATOM    593 HG23 VAL A  39    -107.085  18.693 -31.292  1.00  0.00           H  
ATOM    594  N   TYR A  40    -105.467  21.706 -35.042  1.00  0.00           N  
ATOM    595  CA  TYR A  40    -104.469  22.698 -35.414  1.00  0.00           C  
ATOM    596  C   TYR A  40    -105.137  23.958 -35.944  1.00  0.00           C  
ATOM    597  O   TYR A  40    -105.996  23.926 -36.821  1.00  0.00           O  
ATOM    598  CB  TYR A  40    -103.330  22.147 -36.337  1.00  0.00           C  
ATOM    599  CG  TYR A  40    -103.708  21.457 -37.648  1.00  0.00           C  
ATOM    600  CD1 TYR A  40    -104.711  21.935 -38.442  1.00  0.00           C  
ATOM    601  CD2 TYR A  40    -102.996  20.354 -38.109  1.00  0.00           C  
ATOM    602  CE1 TYR A  40    -105.041  21.361 -39.637  1.00  0.00           C  
ATOM    603  CE2 TYR A  40    -103.317  19.752 -39.313  1.00  0.00           C  
ATOM    604  CZ  TYR A  40    -104.346  20.265 -40.073  1.00  0.00           C  
ATOM    605  OH  TYR A  40    -104.680  19.680 -41.270  1.00  0.00           O  
ATOM    606  H   TYR A  40    -106.124  21.386 -35.707  1.00  0.00           H  
ATOM    607  HA  TYR A  40    -104.008  22.992 -34.474  1.00  0.00           H  
ATOM    608  HB2 TYR A  40    -102.686  22.972 -36.602  1.00  0.00           H  
ATOM    609  HB3 TYR A  40    -102.749  21.442 -35.760  1.00  0.00           H  
ATOM    610  HD1 TYR A  40    -105.259  22.750 -38.099  1.00  0.00           H  
ATOM    611  HD2 TYR A  40    -102.190  19.959 -37.508  1.00  0.00           H  
ATOM    612  HE1 TYR A  40    -105.831  21.794 -40.236  1.00  0.00           H  
ATOM    613  HE2 TYR A  40    -102.763  18.887 -39.651  1.00  0.00           H  
ATOM    614  HH  TYR A  40    -105.060  20.347 -41.857  1.00  0.00           H  
ATOM    615  N   ALA A  41    -104.759  25.068 -35.326  1.00  0.00           N  
ATOM    616  CA  ALA A  41    -105.485  26.314 -35.426  1.00  0.00           C  
ATOM    617  C   ALA A  41    -105.056  27.112 -36.619  1.00  0.00           C  
ATOM    618  O   ALA A  41    -103.888  27.097 -37.019  1.00  0.00           O  
ATOM    619  CB  ALA A  41    -105.301  27.131 -34.163  1.00  0.00           C  
ATOM    620  H   ALA A  41    -103.936  25.049 -34.791  1.00  0.00           H  
ATOM    621  HA  ALA A  41    -106.536  26.081 -35.522  1.00  0.00           H  
ATOM    622  HB1 ALA A  41    -105.798  28.082 -34.271  1.00  0.00           H  
ATOM    623  HB2 ALA A  41    -104.254  27.285 -33.990  1.00  0.00           H  
ATOM    624  HB3 ALA A  41    -105.727  26.597 -33.326  1.00  0.00           H  
ATOM    625  N   ASP A  42    -106.010  27.882 -37.097  1.00  0.00           N  
ATOM    626  CA  ASP A  42    -105.928  28.526 -38.399  1.00  0.00           C  
ATOM    627  C   ASP A  42    -104.934  29.677 -38.372  1.00  0.00           C  
ATOM    628  O   ASP A  42    -104.391  30.023 -37.317  1.00  0.00           O  
ATOM    629  CB  ASP A  42    -107.301  29.082 -38.796  1.00  0.00           C  
ATOM    630  CG  ASP A  42    -108.439  28.126 -38.503  1.00  0.00           C  
ATOM    631  OD1 ASP A  42    -108.993  28.190 -37.381  1.00  0.00           O  
ATOM    632  OD2 ASP A  42    -108.793  27.320 -39.389  1.00  0.00           O  
ATOM    633  H   ASP A  42    -106.804  28.040 -36.532  1.00  0.00           H  
ATOM    634  HA  ASP A  42    -105.616  27.784 -39.125  1.00  0.00           H  
ATOM    635  HB2 ASP A  42    -107.481  29.996 -38.253  1.00  0.00           H  
ATOM    636  HB3 ASP A  42    -107.301  29.294 -39.856  1.00  0.00           H  
ATOM    637  N   GLY A  43    -104.742  30.305 -39.526  1.00  0.00           N  
ATOM    638  CA  GLY A  43    -103.858  31.450 -39.629  1.00  0.00           C  
ATOM    639  C   GLY A  43    -104.495  32.705 -39.066  1.00  0.00           C  
ATOM    640  O   GLY A  43    -104.280  33.807 -39.570  1.00  0.00           O  
ATOM    641  H   GLY A  43    -105.213  29.982 -40.331  1.00  0.00           H  
ATOM    642  HA2 GLY A  43    -102.947  31.241 -39.085  1.00  0.00           H  
ATOM    643  HA3 GLY A  43    -103.617  31.616 -40.667  1.00  0.00           H  
ATOM    644  N   SER A  44    -105.301  32.525 -38.033  1.00  0.00           N  
ATOM    645  CA  SER A  44    -105.917  33.626 -37.323  1.00  0.00           C  
ATOM    646  C   SER A  44    -105.327  33.697 -35.929  1.00  0.00           C  
ATOM    647  O   SER A  44    -105.547  34.648 -35.179  1.00  0.00           O  
ATOM    648  CB  SER A  44    -107.422  33.410 -37.241  1.00  0.00           C  
ATOM    649  OG  SER A  44    -108.087  34.536 -36.687  1.00  0.00           O  
ATOM    650  H   SER A  44    -105.491  31.608 -37.736  1.00  0.00           H  
ATOM    651  HA  SER A  44    -105.705  34.537 -37.850  1.00  0.00           H  
ATOM    652  HB2 SER A  44    -107.812  33.228 -38.231  1.00  0.00           H  
ATOM    653  HB3 SER A  44    -107.605  32.550 -36.614  1.00  0.00           H  
ATOM    654  HG  SER A  44    -107.469  35.280 -36.638  1.00  0.00           H  
ATOM    655  N   ASP A  45    -104.583  32.642 -35.612  1.00  0.00           N  
ATOM    656  CA  ASP A  45    -103.877  32.498 -34.346  1.00  0.00           C  
ATOM    657  C   ASP A  45    -104.846  32.121 -33.242  1.00  0.00           C  
ATOM    658  O   ASP A  45    -105.487  32.983 -32.638  1.00  0.00           O  
ATOM    659  CB  ASP A  45    -103.097  33.772 -33.985  1.00  0.00           C  
ATOM    660  CG  ASP A  45    -102.280  33.632 -32.715  1.00  0.00           C  
ATOM    661  OD1 ASP A  45    -102.818  33.893 -31.619  1.00  0.00           O  
ATOM    662  OD2 ASP A  45    -101.084  33.282 -32.807  1.00  0.00           O  
ATOM    663  H   ASP A  45    -104.529  31.912 -36.259  1.00  0.00           H  
ATOM    664  HA  ASP A  45    -103.176  31.679 -34.465  1.00  0.00           H  
ATOM    665  HB2 ASP A  45    -102.424  34.015 -34.792  1.00  0.00           H  
ATOM    666  HB3 ASP A  45    -103.796  34.586 -33.851  1.00  0.00           H  
ATOM    667  N   ASN A  46    -104.994  30.810 -33.059  1.00  0.00           N  
ATOM    668  CA  ASN A  46    -105.726  30.234 -31.921  1.00  0.00           C  
ATOM    669  C   ASN A  46    -107.226  30.170 -32.210  1.00  0.00           C  
ATOM    670  O   ASN A  46    -107.747  30.933 -33.026  1.00  0.00           O  
ATOM    671  CB  ASN A  46    -105.454  31.045 -30.652  1.00  0.00           C  
ATOM    672  CG  ASN A  46    -106.023  30.419 -29.394  1.00  0.00           C  
ATOM    673  OD1 ASN A  46    -107.170  30.661 -29.031  1.00  0.00           O  
ATOM    674  ND2 ASN A  46    -105.216  29.627 -28.705  1.00  0.00           N  
ATOM    675  H   ASN A  46    -104.626  30.208 -33.739  1.00  0.00           H  
ATOM    676  HA  ASN A  46    -105.363  29.228 -31.776  1.00  0.00           H  
ATOM    677  HB2 ASN A  46    -104.389  31.157 -30.525  1.00  0.00           H  
ATOM    678  HB3 ASN A  46    -105.899  32.015 -30.785  1.00  0.00           H  
ATOM    679 HD21 ASN A  46    -104.302  29.486 -29.039  1.00  0.00           H  
ATOM    680 HD22 ASN A  46    -105.560  29.224 -27.876  1.00  0.00           H  
ATOM    681  N   TRP A  47    -107.909  29.244 -31.547  1.00  0.00           N  
ATOM    682  CA  TRP A  47    -109.295  28.962 -31.826  1.00  0.00           C  
ATOM    683  C   TRP A  47    -110.261  30.028 -31.359  1.00  0.00           C  
ATOM    684  O   TRP A  47    -110.306  30.394 -30.189  1.00  0.00           O  
ATOM    685  CB  TRP A  47    -109.682  27.617 -31.248  1.00  0.00           C  
ATOM    686  CG  TRP A  47    -109.258  26.564 -32.175  1.00  0.00           C  
ATOM    687  CD1 TRP A  47    -109.916  26.164 -33.283  1.00  0.00           C  
ATOM    688  CD2 TRP A  47    -108.048  25.842 -32.131  1.00  0.00           C  
ATOM    689  NE1 TRP A  47    -109.193  25.208 -33.938  1.00  0.00           N  
ATOM    690  CE2 TRP A  47    -108.037  25.000 -33.243  1.00  0.00           C  
ATOM    691  CE3 TRP A  47    -106.967  25.821 -31.255  1.00  0.00           C  
ATOM    692  CZ2 TRP A  47    -106.988  24.159 -33.499  1.00  0.00           C  
ATOM    693  CZ3 TRP A  47    -105.933  24.988 -31.515  1.00  0.00           C  
ATOM    694  CH2 TRP A  47    -105.944  24.170 -32.631  1.00  0.00           C  
ATOM    695  H   TRP A  47    -107.464  28.720 -30.861  1.00  0.00           H  
ATOM    696  HA  TRP A  47    -109.368  28.878 -32.895  1.00  0.00           H  
ATOM    697  HB2 TRP A  47    -109.181  27.468 -30.301  1.00  0.00           H  
ATOM    698  HB3 TRP A  47    -110.750  27.557 -31.122  1.00  0.00           H  
ATOM    699  HD1 TRP A  47    -110.868  26.553 -33.580  1.00  0.00           H  
ATOM    700  HE1 TRP A  47    -109.452  24.756 -34.766  1.00  0.00           H  
ATOM    701  HE3 TRP A  47    -106.931  26.437 -30.386  1.00  0.00           H  
ATOM    702  HZ2 TRP A  47    -106.960  23.529 -34.364  1.00  0.00           H  
ATOM    703  HZ3 TRP A  47    -105.091  24.977 -30.856  1.00  0.00           H  
ATOM    704  HH2 TRP A  47    -105.102  23.533 -32.811  1.00  0.00           H  
ATOM    705  N   ASN A  48    -111.044  30.502 -32.307  1.00  0.00           N  
ATOM    706  CA  ASN A  48    -112.197  31.326 -32.017  1.00  0.00           C  
ATOM    707  C   ASN A  48    -113.341  30.420 -31.542  1.00  0.00           C  
ATOM    708  O   ASN A  48    -114.257  30.102 -32.292  1.00  0.00           O  
ATOM    709  CB  ASN A  48    -112.571  32.135 -33.277  1.00  0.00           C  
ATOM    710  CG  ASN A  48    -113.981  32.695 -33.263  1.00  0.00           C  
ATOM    711  OD1 ASN A  48    -114.238  33.767 -32.720  1.00  0.00           O  
ATOM    712  ND2 ASN A  48    -114.898  31.978 -33.898  1.00  0.00           N  
ATOM    713  H   ASN A  48    -110.839  30.288 -33.241  1.00  0.00           H  
ATOM    714  HA  ASN A  48    -111.930  32.005 -31.221  1.00  0.00           H  
ATOM    715  HB2 ASN A  48    -111.886  32.963 -33.372  1.00  0.00           H  
ATOM    716  HB3 ASN A  48    -112.468  31.495 -34.143  1.00  0.00           H  
ATOM    717 HD21 ASN A  48    -114.606  31.143 -34.343  1.00  0.00           H  
ATOM    718 HD22 ASN A  48    -115.831  32.274 -33.862  1.00  0.00           H  
ATOM    719  N   ASN A  49    -113.222  29.934 -30.303  1.00  0.00           N  
ATOM    720  CA  ASN A  49    -114.239  29.058 -29.700  1.00  0.00           C  
ATOM    721  C   ASN A  49    -114.631  27.932 -30.667  1.00  0.00           C  
ATOM    722  O   ASN A  49    -115.779  27.492 -30.715  1.00  0.00           O  
ATOM    723  CB  ASN A  49    -115.468  29.891 -29.306  1.00  0.00           C  
ATOM    724  CG  ASN A  49    -116.494  29.106 -28.510  1.00  0.00           C  
ATOM    725  OD1 ASN A  49    -116.153  28.186 -27.766  1.00  0.00           O  
ATOM    726  ND2 ASN A  49    -117.760  29.468 -28.660  1.00  0.00           N  
ATOM    727  H   ASN A  49    -112.428  30.175 -29.776  1.00  0.00           H  
ATOM    728  HA  ASN A  49    -113.810  28.621 -28.810  1.00  0.00           H  
ATOM    729  HB2 ASN A  49    -115.144  30.730 -28.705  1.00  0.00           H  
ATOM    730  HB3 ASN A  49    -115.945  30.261 -30.206  1.00  0.00           H  
ATOM    731 HD21 ASN A  49    -117.959  30.213 -29.268  1.00  0.00           H  
ATOM    732 HD22 ASN A  49    -118.444  28.981 -28.156  1.00  0.00           H  
ATOM    733  N   ASN A  50    -113.665  27.473 -31.448  1.00  0.00           N  
ATOM    734  CA  ASN A  50    -113.938  26.514 -32.502  1.00  0.00           C  
ATOM    735  C   ASN A  50    -113.155  25.238 -32.242  1.00  0.00           C  
ATOM    736  O   ASN A  50    -112.353  25.179 -31.310  1.00  0.00           O  
ATOM    737  CB  ASN A  50    -113.572  27.116 -33.870  1.00  0.00           C  
ATOM    738  CG  ASN A  50    -114.130  26.321 -35.037  1.00  0.00           C  
ATOM    739  OD1 ASN A  50    -115.119  25.598 -34.896  1.00  0.00           O  
ATOM    740  ND2 ASN A  50    -113.513  26.464 -36.200  1.00  0.00           N  
ATOM    741  H   ASN A  50    -112.747  27.777 -31.300  1.00  0.00           H  
ATOM    742  HA  ASN A  50    -114.994  26.288 -32.485  1.00  0.00           H  
ATOM    743  HB2 ASN A  50    -113.963  28.125 -33.929  1.00  0.00           H  
ATOM    744  HB3 ASN A  50    -112.489  27.143 -33.967  1.00  0.00           H  
ATOM    745 HD21 ASN A  50    -112.731  27.078 -36.242  1.00  0.00           H  
ATOM    746 HD22 ASN A  50    -113.862  25.959 -36.982  1.00  0.00           H  
ATOM    747  N   GLY A  51    -113.378  24.217 -33.051  1.00  0.00           N  
ATOM    748  CA  GLY A  51    -112.674  22.981 -32.852  1.00  0.00           C  
ATOM    749  C   GLY A  51    -112.284  22.329 -34.159  1.00  0.00           C  
ATOM    750  O   GLY A  51    -112.922  21.374 -34.606  1.00  0.00           O  
ATOM    751  H   GLY A  51    -114.006  24.315 -33.798  1.00  0.00           H  
ATOM    752  HA2 GLY A  51    -111.783  23.205 -32.288  1.00  0.00           H  
ATOM    753  HA3 GLY A  51    -113.295  22.301 -32.285  1.00  0.00           H  
ATOM    754  N   ASN A  52    -111.239  22.855 -34.771  1.00  0.00           N  
ATOM    755  CA  ASN A  52    -110.760  22.365 -36.060  1.00  0.00           C  
ATOM    756  C   ASN A  52    -109.921  21.103 -35.902  1.00  0.00           C  
ATOM    757  O   ASN A  52    -108.704  21.165 -35.656  1.00  0.00           O  
ATOM    758  CB  ASN A  52    -109.961  23.452 -36.775  1.00  0.00           C  
ATOM    759  CG  ASN A  52    -110.860  24.511 -37.378  1.00  0.00           C  
ATOM    760  OD1 ASN A  52    -111.938  24.207 -37.887  1.00  0.00           O  
ATOM    761  ND2 ASN A  52    -110.442  25.762 -37.300  1.00  0.00           N  
ATOM    762  H   ASN A  52    -110.770  23.598 -34.340  1.00  0.00           H  
ATOM    763  HA  ASN A  52    -111.628  22.127 -36.658  1.00  0.00           H  
ATOM    764  HB2 ASN A  52    -109.297  23.928 -36.068  1.00  0.00           H  
ATOM    765  HB3 ASN A  52    -109.380  23.005 -37.567  1.00  0.00           H  
ATOM    766 HD21 ASN A  52    -109.583  25.946 -36.860  1.00  0.00           H  
ATOM    767 HD22 ASN A  52    -111.005  26.463 -37.696  1.00  0.00           H  
ATOM    768  N   ILE A  53    -110.581  19.962 -36.060  1.00  0.00           N  
ATOM    769  CA  ILE A  53    -109.941  18.672 -35.883  1.00  0.00           C  
ATOM    770  C   ILE A  53    -109.753  17.969 -37.216  1.00  0.00           C  
ATOM    771  O   ILE A  53    -110.587  18.065 -38.121  1.00  0.00           O  
ATOM    772  CB  ILE A  53    -110.742  17.765 -34.902  1.00  0.00           C  
ATOM    773  CG1 ILE A  53    -110.109  16.367 -34.754  1.00  0.00           C  
ATOM    774  CG2 ILE A  53    -112.185  17.642 -35.350  1.00  0.00           C  
ATOM    775  CD1 ILE A  53    -110.634  15.318 -35.722  1.00  0.00           C  
ATOM    776  H   ILE A  53    -111.529  19.991 -36.309  1.00  0.00           H  
ATOM    777  HA  ILE A  53    -108.966  18.850 -35.449  1.00  0.00           H  
ATOM    778  HB  ILE A  53    -110.739  18.249 -33.937  1.00  0.00           H  
ATOM    779 HG12 ILE A  53    -109.046  16.448 -34.914  1.00  0.00           H  
ATOM    780 HG13 ILE A  53    -110.286  16.006 -33.753  1.00  0.00           H  
ATOM    781 HG21 ILE A  53    -112.238  17.002 -36.220  1.00  0.00           H  
ATOM    782 HG22 ILE A  53    -112.554  18.613 -35.603  1.00  0.00           H  
ATOM    783 HG23 ILE A  53    -112.779  17.221 -34.554  1.00  0.00           H  
ATOM    784 HD11 ILE A  53    -110.429  15.630 -36.735  1.00  0.00           H  
ATOM    785 HD12 ILE A  53    -111.700  15.206 -35.589  1.00  0.00           H  
ATOM    786 HD13 ILE A  53    -110.145  14.374 -35.529  1.00  0.00           H  
ATOM    787  N   ILE A  54    -108.630  17.291 -37.326  1.00  0.00           N  
ATOM    788  CA  ILE A  54    -108.342  16.443 -38.460  1.00  0.00           C  
ATOM    789  C   ILE A  54    -107.749  15.137 -37.943  1.00  0.00           C  
ATOM    790  O   ILE A  54    -106.769  15.135 -37.194  1.00  0.00           O  
ATOM    791  CB  ILE A  54    -107.402  17.142 -39.473  1.00  0.00           C  
ATOM    792  CG1 ILE A  54    -107.138  16.249 -40.681  1.00  0.00           C  
ATOM    793  CG2 ILE A  54    -106.091  17.539 -38.818  1.00  0.00           C  
ATOM    794  CD1 ILE A  54    -106.427  16.973 -41.805  1.00  0.00           C  
ATOM    795  H   ILE A  54    -107.972  17.353 -36.598  1.00  0.00           H  
ATOM    796  HA  ILE A  54    -109.279  16.225 -38.956  1.00  0.00           H  
ATOM    797  HB  ILE A  54    -107.888  18.045 -39.808  1.00  0.00           H  
ATOM    798 HG12 ILE A  54    -106.521  15.416 -40.376  1.00  0.00           H  
ATOM    799 HG13 ILE A  54    -108.078  15.880 -41.062  1.00  0.00           H  
ATOM    800 HG21 ILE A  54    -105.552  16.648 -38.522  1.00  0.00           H  
ATOM    801 HG22 ILE A  54    -106.293  18.145 -37.947  1.00  0.00           H  
ATOM    802 HG23 ILE A  54    -105.493  18.104 -39.519  1.00  0.00           H  
ATOM    803 HD11 ILE A  54    -105.697  17.660 -41.385  1.00  0.00           H  
ATOM    804 HD12 ILE A  54    -107.145  17.526 -42.390  1.00  0.00           H  
ATOM    805 HD13 ILE A  54    -105.923  16.254 -42.433  1.00  0.00           H  
ATOM    806  N   ALA A  55    -108.383  14.031 -38.286  1.00  0.00           N  
ATOM    807  CA  ALA A  55    -108.034  12.753 -37.697  1.00  0.00           C  
ATOM    808  C   ALA A  55    -106.708  12.222 -38.240  1.00  0.00           C  
ATOM    809  O   ALA A  55    -106.460  12.250 -39.445  1.00  0.00           O  
ATOM    810  CB  ALA A  55    -109.143  11.744 -37.929  1.00  0.00           C  
ATOM    811  H   ALA A  55    -109.101  14.074 -38.952  1.00  0.00           H  
ATOM    812  HA  ALA A  55    -107.944  12.907 -36.629  1.00  0.00           H  
ATOM    813  HB1 ALA A  55    -110.078  12.146 -37.570  1.00  0.00           H  
ATOM    814  HB2 ALA A  55    -108.916  10.832 -37.395  1.00  0.00           H  
ATOM    815  HB3 ALA A  55    -109.224  11.533 -38.985  1.00  0.00           H  
ATOM    816  N   ALA A  56    -105.868  11.748 -37.335  1.00  0.00           N  
ATOM    817  CA  ALA A  56    -104.596  11.139 -37.698  1.00  0.00           C  
ATOM    818  C   ALA A  56    -104.779   9.633 -37.875  1.00  0.00           C  
ATOM    819  O   ALA A  56    -105.788   9.077 -37.441  1.00  0.00           O  
ATOM    820  CB  ALA A  56    -103.557  11.431 -36.623  1.00  0.00           C  
ATOM    821  H   ALA A  56    -106.117  11.797 -36.384  1.00  0.00           H  
ATOM    822  HA  ALA A  56    -104.264  11.575 -38.629  1.00  0.00           H  
ATOM    823  HB1 ALA A  56    -102.629  10.947 -36.872  1.00  0.00           H  
ATOM    824  HB2 ALA A  56    -103.910  11.061 -35.674  1.00  0.00           H  
ATOM    825  HB3 ALA A  56    -103.400  12.498 -36.556  1.00  0.00           H  
ATOM    826  N   SER A  57    -103.815   8.971 -38.497  1.00  0.00           N  
ATOM    827  CA  SER A  57    -103.936   7.551 -38.755  1.00  0.00           C  
ATOM    828  C   SER A  57    -102.700   6.823 -38.253  1.00  0.00           C  
ATOM    829  O   SER A  57    -101.581   7.316 -38.375  1.00  0.00           O  
ATOM    830  CB  SER A  57    -104.137   7.304 -40.253  1.00  0.00           C  
ATOM    831  OG  SER A  57    -104.595   5.983 -40.497  1.00  0.00           O  
ATOM    832  H   SER A  57    -103.001   9.438 -38.777  1.00  0.00           H  
ATOM    833  HA  SER A  57    -104.798   7.187 -38.218  1.00  0.00           H  
ATOM    834  HB2 SER A  57    -104.867   8.001 -40.636  1.00  0.00           H  
ATOM    835  HB3 SER A  57    -103.199   7.447 -40.767  1.00  0.00           H  
ATOM    836  HG  SER A  57    -103.996   5.542 -41.123  1.00  0.00           H  
ATOM    837  N   PHE A  58    -102.911   5.661 -37.667  1.00  0.00           N  
ATOM    838  CA  PHE A  58    -101.826   4.852 -37.169  1.00  0.00           C  
ATOM    839  C   PHE A  58    -101.037   4.243 -38.321  1.00  0.00           C  
ATOM    840  O   PHE A  58    -101.588   3.931 -39.379  1.00  0.00           O  
ATOM    841  CB  PHE A  58    -102.345   3.770 -36.221  1.00  0.00           C  
ATOM    842  CG  PHE A  58    -103.276   2.801 -36.869  1.00  0.00           C  
ATOM    843  CD1 PHE A  58    -102.769   1.776 -37.631  1.00  0.00           C  
ATOM    844  CD2 PHE A  58    -104.650   2.916 -36.727  1.00  0.00           C  
ATOM    845  CE1 PHE A  58    -103.597   0.883 -38.246  1.00  0.00           C  
ATOM    846  CE2 PHE A  58    -105.496   2.015 -37.345  1.00  0.00           C  
ATOM    847  CZ  PHE A  58    -104.966   0.993 -38.108  1.00  0.00           C  
ATOM    848  H   PHE A  58    -103.821   5.343 -37.563  1.00  0.00           H  
ATOM    849  HA  PHE A  58    -101.182   5.490 -36.627  1.00  0.00           H  
ATOM    850  HB2 PHE A  58    -101.505   3.213 -35.832  1.00  0.00           H  
ATOM    851  HB3 PHE A  58    -102.868   4.239 -35.401  1.00  0.00           H  
ATOM    852  HD1 PHE A  58    -101.698   1.681 -37.744  1.00  0.00           H  
ATOM    853  HD2 PHE A  58    -105.059   3.718 -36.131  1.00  0.00           H  
ATOM    854  HE1 PHE A  58    -103.171   0.104 -38.837  1.00  0.00           H  
ATOM    855  HE2 PHE A  58    -106.566   2.109 -37.231  1.00  0.00           H  
ATOM    856  HZ  PHE A  58    -105.620   0.285 -38.597  1.00  0.00           H  
ATOM    857  N   SER A  59     -99.738   4.111 -38.120  1.00  0.00           N  
ATOM    858  CA  SER A  59     -98.861   3.537 -39.120  1.00  0.00           C  
ATOM    859  C   SER A  59     -98.418   2.148 -38.684  1.00  0.00           C  
ATOM    860  O   SER A  59     -98.406   1.213 -39.484  1.00  0.00           O  
ATOM    861  CB  SER A  59     -97.644   4.441 -39.340  1.00  0.00           C  
ATOM    862  OG  SER A  59     -96.839   3.978 -40.412  1.00  0.00           O  
ATOM    863  H   SER A  59     -99.356   4.409 -37.264  1.00  0.00           H  
ATOM    864  HA  SER A  59     -99.413   3.457 -40.044  1.00  0.00           H  
ATOM    865  HB2 SER A  59     -97.979   5.443 -39.563  1.00  0.00           H  
ATOM    866  HB3 SER A  59     -97.048   4.457 -38.439  1.00  0.00           H  
ATOM    867  HG  SER A  59     -96.690   3.031 -40.320  1.00  0.00           H  
ATOM    868  N   GLY A  60     -98.049   2.019 -37.416  1.00  0.00           N  
ATOM    869  CA  GLY A  60     -97.662   0.727 -36.890  1.00  0.00           C  
ATOM    870  C   GLY A  60     -97.106   0.830 -35.487  1.00  0.00           C  
ATOM    871  O   GLY A  60     -96.884   1.935 -34.998  1.00  0.00           O  
ATOM    872  H   GLY A  60     -98.026   2.815 -36.829  1.00  0.00           H  
ATOM    873  HA2 GLY A  60     -98.527   0.079 -36.878  1.00  0.00           H  
ATOM    874  HA3 GLY A  60     -96.910   0.297 -37.533  1.00  0.00           H  
ATOM    875  N   PRO A  61     -96.889  -0.305 -34.807  1.00  0.00           N  
ATOM    876  CA  PRO A  61     -96.295  -0.328 -33.470  1.00  0.00           C  
ATOM    877  C   PRO A  61     -94.818   0.051 -33.504  1.00  0.00           C  
ATOM    878  O   PRO A  61     -94.087  -0.340 -34.418  1.00  0.00           O  
ATOM    879  CB  PRO A  61     -96.463  -1.786 -33.012  1.00  0.00           C  
ATOM    880  CG  PRO A  61     -97.408  -2.403 -33.989  1.00  0.00           C  
ATOM    881  CD  PRO A  61     -97.212  -1.659 -35.275  1.00  0.00           C  
ATOM    882  HA  PRO A  61     -96.818   0.329 -32.793  1.00  0.00           H  
ATOM    883  HB2 PRO A  61     -95.504  -2.282 -33.025  1.00  0.00           H  
ATOM    884  HB3 PRO A  61     -96.868  -1.805 -32.011  1.00  0.00           H  
ATOM    885  HG2 PRO A  61     -97.174  -3.450 -34.119  1.00  0.00           H  
ATOM    886  HG3 PRO A  61     -98.422  -2.284 -33.639  1.00  0.00           H  
ATOM    887  HD2 PRO A  61     -96.394  -2.084 -35.840  1.00  0.00           H  
ATOM    888  HD3 PRO A  61     -98.122  -1.661 -35.860  1.00  0.00           H  
ATOM    889  N   ILE A  62     -94.386   0.811 -32.508  1.00  0.00           N  
ATOM    890  CA  ILE A  62     -93.006   1.270 -32.444  1.00  0.00           C  
ATOM    891  C   ILE A  62     -92.108   0.153 -31.934  1.00  0.00           C  
ATOM    892  O   ILE A  62     -92.124  -0.176 -30.747  1.00  0.00           O  
ATOM    893  CB  ILE A  62     -92.858   2.498 -31.522  1.00  0.00           C  
ATOM    894  CG1 ILE A  62     -93.873   3.569 -31.897  1.00  0.00           C  
ATOM    895  CG2 ILE A  62     -91.455   3.069 -31.611  1.00  0.00           C  
ATOM    896  CD1 ILE A  62     -93.763   4.817 -31.063  1.00  0.00           C  
ATOM    897  H   ILE A  62     -95.006   1.059 -31.789  1.00  0.00           H  
ATOM    898  HA  ILE A  62     -92.694   1.548 -33.440  1.00  0.00           H  
ATOM    899  HB  ILE A  62     -93.031   2.183 -30.504  1.00  0.00           H  
ATOM    900 HG12 ILE A  62     -93.731   3.846 -32.929  1.00  0.00           H  
ATOM    901 HG13 ILE A  62     -94.869   3.175 -31.767  1.00  0.00           H  
ATOM    902 HG21 ILE A  62     -91.279   3.424 -32.615  1.00  0.00           H  
ATOM    903 HG22 ILE A  62     -90.739   2.303 -31.369  1.00  0.00           H  
ATOM    904 HG23 ILE A  62     -91.354   3.888 -30.916  1.00  0.00           H  
ATOM    905 HD11 ILE A  62     -93.684   4.550 -30.021  1.00  0.00           H  
ATOM    906 HD12 ILE A  62     -94.644   5.411 -31.211  1.00  0.00           H  
ATOM    907 HD13 ILE A  62     -92.890   5.379 -31.361  1.00  0.00           H  
ATOM    908  N   SER A  63     -91.335  -0.434 -32.831  1.00  0.00           N  
ATOM    909  CA  SER A  63     -90.456  -1.526 -32.467  1.00  0.00           C  
ATOM    910  C   SER A  63     -89.365  -1.046 -31.519  1.00  0.00           C  
ATOM    911  O   SER A  63     -88.543  -0.190 -31.865  1.00  0.00           O  
ATOM    912  CB  SER A  63     -89.853  -2.151 -33.721  1.00  0.00           C  
ATOM    913  OG  SER A  63     -90.876  -2.643 -34.568  1.00  0.00           O  
ATOM    914  H   SER A  63     -91.346  -0.116 -33.758  1.00  0.00           H  
ATOM    915  HA  SER A  63     -91.052  -2.271 -31.960  1.00  0.00           H  
ATOM    916  HB2 SER A  63     -89.280  -1.406 -34.254  1.00  0.00           H  
ATOM    917  HB3 SER A  63     -89.210  -2.970 -33.436  1.00  0.00           H  
ATOM    918  HG  SER A  63     -91.585  -3.009 -34.022  1.00  0.00           H  
ATOM    919  N   GLY A  64     -89.376  -1.594 -30.316  1.00  0.00           N  
ATOM    920  CA  GLY A  64     -88.407  -1.213 -29.314  1.00  0.00           C  
ATOM    921  C   GLY A  64     -89.059  -0.668 -28.057  1.00  0.00           C  
ATOM    922  O   GLY A  64     -88.406  -0.536 -27.022  1.00  0.00           O  
ATOM    923  H   GLY A  64     -90.055  -2.279 -30.108  1.00  0.00           H  
ATOM    924  HA2 GLY A  64     -87.815  -2.077 -29.053  1.00  0.00           H  
ATOM    925  HA3 GLY A  64     -87.755  -0.456 -29.727  1.00  0.00           H  
ATOM    926  N   SER A  65     -90.341  -0.332 -28.143  1.00  0.00           N  
ATOM    927  CA  SER A  65     -91.070   0.195 -26.992  1.00  0.00           C  
ATOM    928  C   SER A  65     -92.546  -0.175 -27.074  1.00  0.00           C  
ATOM    929  O   SER A  65     -93.041  -0.574 -28.128  1.00  0.00           O  
ATOM    930  CB  SER A  65     -90.927   1.716 -26.921  1.00  0.00           C  
ATOM    931  OG  SER A  65     -89.562   2.098 -26.964  1.00  0.00           O  
ATOM    932  H   SER A  65     -90.811  -0.437 -28.999  1.00  0.00           H  
ATOM    933  HA  SER A  65     -90.647  -0.240 -26.099  1.00  0.00           H  
ATOM    934  HB2 SER A  65     -91.445   2.162 -27.753  1.00  0.00           H  
ATOM    935  HB3 SER A  65     -91.359   2.073 -25.997  1.00  0.00           H  
ATOM    936  HG  SER A  65     -89.020   1.316 -27.135  1.00  0.00           H  
ATOM    937  N   ASN A  66     -93.242  -0.032 -25.960  1.00  0.00           N  
ATOM    938  CA  ASN A  66     -94.663  -0.349 -25.896  1.00  0.00           C  
ATOM    939  C   ASN A  66     -95.477   0.894 -26.249  1.00  0.00           C  
ATOM    940  O   ASN A  66     -96.228   1.427 -25.426  1.00  0.00           O  
ATOM    941  CB  ASN A  66     -95.026  -0.864 -24.497  1.00  0.00           C  
ATOM    942  CG  ASN A  66     -96.346  -1.618 -24.460  1.00  0.00           C  
ATOM    943  OD1 ASN A  66     -97.262  -1.352 -25.236  1.00  0.00           O  
ATOM    944  ND2 ASN A  66     -96.450  -2.573 -23.548  1.00  0.00           N  
ATOM    945  H   ASN A  66     -92.784   0.298 -25.151  1.00  0.00           H  
ATOM    946  HA  ASN A  66     -94.868  -1.121 -26.625  1.00  0.00           H  
ATOM    947  HB2 ASN A  66     -94.248  -1.532 -24.159  1.00  0.00           H  
ATOM    948  HB3 ASN A  66     -95.094  -0.026 -23.821  1.00  0.00           H  
ATOM    949 HD21 ASN A  66     -95.681  -2.737 -22.961  1.00  0.00           H  
ATOM    950 HD22 ASN A  66     -97.288  -3.087 -23.505  1.00  0.00           H  
ATOM    951  N   TYR A  67     -95.281   1.359 -27.476  1.00  0.00           N  
ATOM    952  CA  TYR A  67     -95.957   2.542 -28.002  1.00  0.00           C  
ATOM    953  C   TYR A  67     -96.384   2.284 -29.440  1.00  0.00           C  
ATOM    954  O   TYR A  67     -95.974   1.295 -30.051  1.00  0.00           O  
ATOM    955  CB  TYR A  67     -95.022   3.758 -27.962  1.00  0.00           C  
ATOM    956  CG  TYR A  67     -95.276   4.719 -26.817  1.00  0.00           C  
ATOM    957  CD1 TYR A  67     -95.284   4.292 -25.501  1.00  0.00           C  
ATOM    958  CD2 TYR A  67     -95.502   6.065 -27.064  1.00  0.00           C  
ATOM    959  CE1 TYR A  67     -95.512   5.175 -24.461  1.00  0.00           C  
ATOM    960  CE2 TYR A  67     -95.730   6.957 -26.036  1.00  0.00           C  
ATOM    961  CZ  TYR A  67     -95.735   6.509 -24.734  1.00  0.00           C  
ATOM    962  OH  TYR A  67     -95.968   7.393 -23.706  1.00  0.00           O  
ATOM    963  H   TYR A  67     -94.662   0.877 -28.066  1.00  0.00           H  
ATOM    964  HA  TYR A  67     -96.829   2.735 -27.394  1.00  0.00           H  
ATOM    965  HB2 TYR A  67     -94.002   3.417 -27.884  1.00  0.00           H  
ATOM    966  HB3 TYR A  67     -95.135   4.310 -28.885  1.00  0.00           H  
ATOM    967  HD1 TYR A  67     -95.114   3.251 -25.293  1.00  0.00           H  
ATOM    968  HD2 TYR A  67     -95.496   6.417 -28.086  1.00  0.00           H  
ATOM    969  HE1 TYR A  67     -95.516   4.818 -23.439  1.00  0.00           H  
ATOM    970  HE2 TYR A  67     -95.905   8.001 -26.254  1.00  0.00           H  
ATOM    971  HH  TYR A  67     -96.691   7.982 -23.949  1.00  0.00           H  
ATOM    972  N   GLU A  68     -97.192   3.179 -29.981  1.00  0.00           N  
ATOM    973  CA  GLU A  68     -97.634   3.064 -31.361  1.00  0.00           C  
ATOM    974  C   GLU A  68     -97.228   4.320 -32.126  1.00  0.00           C  
ATOM    975  O   GLU A  68     -96.802   5.305 -31.517  1.00  0.00           O  
ATOM    976  CB  GLU A  68     -99.142   2.828 -31.409  1.00  0.00           C  
ATOM    977  CG  GLU A  68     -99.630   2.227 -32.710  1.00  0.00           C  
ATOM    978  CD  GLU A  68    -101.053   1.733 -32.600  1.00  0.00           C  
ATOM    979  OE1 GLU A  68    -101.985   2.527 -32.822  1.00  0.00           O  
ATOM    980  OE2 GLU A  68    -101.249   0.551 -32.245  1.00  0.00           O  
ATOM    981  H   GLU A  68     -97.493   3.945 -29.443  1.00  0.00           H  
ATOM    982  HA  GLU A  68     -97.126   2.216 -31.801  1.00  0.00           H  
ATOM    983  HB2 GLU A  68     -99.410   2.151 -30.615  1.00  0.00           H  
ATOM    984  HB3 GLU A  68     -99.651   3.769 -31.258  1.00  0.00           H  
ATOM    985  HG2 GLU A  68     -99.577   2.976 -33.488  1.00  0.00           H  
ATOM    986  HG3 GLU A  68     -98.993   1.397 -32.958  1.00  0.00           H  
ATOM    987  N   TYR A  69     -97.400   4.314 -33.439  1.00  0.00           N  
ATOM    988  CA  TYR A  69     -96.741   5.290 -34.287  1.00  0.00           C  
ATOM    989  C   TYR A  69     -97.698   5.726 -35.363  1.00  0.00           C  
ATOM    990  O   TYR A  69     -98.215   4.908 -36.121  1.00  0.00           O  
ATOM    991  CB  TYR A  69     -95.462   4.721 -34.907  1.00  0.00           C  
ATOM    992  CG  TYR A  69     -94.474   5.794 -35.296  1.00  0.00           C  
ATOM    993  CD1 TYR A  69     -94.363   6.940 -34.528  1.00  0.00           C  
ATOM    994  CD2 TYR A  69     -93.653   5.667 -36.410  1.00  0.00           C  
ATOM    995  CE1 TYR A  69     -93.468   7.937 -34.853  1.00  0.00           C  
ATOM    996  CE2 TYR A  69     -92.750   6.662 -36.744  1.00  0.00           C  
ATOM    997  CZ  TYR A  69     -92.665   7.797 -35.962  1.00  0.00           C  
ATOM    998  OH  TYR A  69     -91.769   8.792 -36.285  1.00  0.00           O  
ATOM    999  H   TYR A  69     -98.062   3.708 -33.842  1.00  0.00           H  
ATOM   1000  HA  TYR A  69     -96.490   6.146 -33.677  1.00  0.00           H  
ATOM   1001  HB2 TYR A  69     -94.984   4.066 -34.193  1.00  0.00           H  
ATOM   1002  HB3 TYR A  69     -95.716   4.159 -35.794  1.00  0.00           H  
ATOM   1003  HD1 TYR A  69     -94.998   7.046 -33.663  1.00  0.00           H  
ATOM   1004  HD2 TYR A  69     -93.726   4.778 -37.018  1.00  0.00           H  
ATOM   1005  HE1 TYR A  69     -93.399   8.820 -34.236  1.00  0.00           H  
ATOM   1006  HE2 TYR A  69     -92.119   6.548 -37.615  1.00  0.00           H  
ATOM   1007  HH  TYR A  69     -91.577   9.325 -35.497  1.00  0.00           H  
ATOM   1008  N   TRP A  70     -97.947   7.013 -35.406  1.00  0.00           N  
ATOM   1009  CA  TRP A  70     -99.053   7.541 -36.155  1.00  0.00           C  
ATOM   1010  C   TRP A  70     -98.553   8.522 -37.197  1.00  0.00           C  
ATOM   1011  O   TRP A  70     -97.593   9.235 -36.951  1.00  0.00           O  
ATOM   1012  CB  TRP A  70     -99.995   8.222 -35.165  1.00  0.00           C  
ATOM   1013  CG  TRP A  70    -100.300   7.376 -33.950  1.00  0.00           C  
ATOM   1014  CD1 TRP A  70     -99.442   6.950 -32.996  1.00  0.00           C  
ATOM   1015  CD2 TRP A  70    -101.561   6.889 -33.557  1.00  0.00           C  
ATOM   1016  NE1 TRP A  70    -100.115   6.201 -32.069  1.00  0.00           N  
ATOM   1017  CE2 TRP A  70    -101.417   6.167 -32.385  1.00  0.00           C  
ATOM   1018  CE3 TRP A  70    -102.774   7.005 -34.103  1.00  0.00           C  
ATOM   1019  CZ2 TRP A  70    -102.483   5.560 -31.739  1.00  0.00           C  
ATOM   1020  CZ3 TRP A  70    -103.863   6.426 -33.492  1.00  0.00           C  
ATOM   1021  CH2 TRP A  70    -103.708   5.705 -32.305  1.00  0.00           C  
ATOM   1022  H   TRP A  70     -97.375   7.633 -34.898  1.00  0.00           H  
ATOM   1023  HA  TRP A  70     -99.565   6.724 -36.638  1.00  0.00           H  
ATOM   1024  HB2 TRP A  70     -99.549   9.145 -34.828  1.00  0.00           H  
ATOM   1025  HB3 TRP A  70    -100.927   8.439 -35.663  1.00  0.00           H  
ATOM   1026  HD1 TRP A  70     -98.391   7.149 -33.001  1.00  0.00           H  
ATOM   1027  HE1 TRP A  70     -99.736   5.786 -31.312  1.00  0.00           H  
ATOM   1028  HE3 TRP A  70    -102.857   7.526 -34.992  1.00  0.00           H  
ATOM   1029  HZ2 TRP A  70    -102.362   5.004 -30.821  1.00  0.00           H  
ATOM   1030  HZ3 TRP A  70    -104.846   6.561 -33.909  1.00  0.00           H  
ATOM   1031  HH2 TRP A  70    -104.570   5.262 -31.844  1.00  0.00           H  
ATOM   1032  N   THR A  71     -99.192   8.554 -38.356  1.00  0.00           N  
ATOM   1033  CA  THR A  71     -98.770   9.430 -39.442  1.00  0.00           C  
ATOM   1034  C   THR A  71     -99.972   9.926 -40.233  1.00  0.00           C  
ATOM   1035  O   THR A  71    -101.016   9.268 -40.254  1.00  0.00           O  
ATOM   1036  CB  THR A  71     -97.817   8.705 -40.421  1.00  0.00           C  
ATOM   1037  OG1 THR A  71     -98.367   7.434 -40.797  1.00  0.00           O  
ATOM   1038  CG2 THR A  71     -96.435   8.499 -39.818  1.00  0.00           C  
ATOM   1039  H   THR A  71     -99.984   7.981 -38.486  1.00  0.00           H  
ATOM   1040  HA  THR A  71     -98.248  10.274 -39.015  1.00  0.00           H  
ATOM   1041  HB  THR A  71     -97.714   9.312 -41.308  1.00  0.00           H  
ATOM   1042  HG1 THR A  71     -99.333   7.485 -40.791  1.00  0.00           H  
ATOM   1043 HG21 THR A  71     -96.528   7.972 -38.881  1.00  0.00           H  
ATOM   1044 HG22 THR A  71     -95.971   9.458 -39.646  1.00  0.00           H  
ATOM   1045 HG23 THR A  71     -95.827   7.921 -40.499  1.00  0.00           H  
ATOM   1046  N   PHE A  72     -99.835  11.091 -40.857  1.00  0.00           N  
ATOM   1047  CA  PHE A  72    -100.804  11.538 -41.843  1.00  0.00           C  
ATOM   1048  C   PHE A  72    -100.337  12.817 -42.537  1.00  0.00           C  
ATOM   1049  O   PHE A  72     -99.532  13.579 -41.998  1.00  0.00           O  
ATOM   1050  CB  PHE A  72    -102.197  11.753 -41.218  1.00  0.00           C  
ATOM   1051  CG  PHE A  72    -102.385  13.096 -40.567  1.00  0.00           C  
ATOM   1052  CD1 PHE A  72    -101.693  13.436 -39.418  1.00  0.00           C  
ATOM   1053  CD2 PHE A  72    -103.264  14.017 -41.112  1.00  0.00           C  
ATOM   1054  CE1 PHE A  72    -101.867  14.672 -38.828  1.00  0.00           C  
ATOM   1055  CE2 PHE A  72    -103.443  15.253 -40.527  1.00  0.00           C  
ATOM   1056  CZ  PHE A  72    -102.746  15.581 -39.384  1.00  0.00           C  
ATOM   1057  H   PHE A  72     -99.066  11.673 -40.639  1.00  0.00           H  
ATOM   1058  HA  PHE A  72    -100.868  10.759 -42.580  1.00  0.00           H  
ATOM   1059  HB2 PHE A  72    -102.946  11.653 -41.987  1.00  0.00           H  
ATOM   1060  HB3 PHE A  72    -102.363  10.994 -40.467  1.00  0.00           H  
ATOM   1061  HD1 PHE A  72    -101.008  12.727 -38.985  1.00  0.00           H  
ATOM   1062  HD2 PHE A  72    -103.811  13.761 -42.007  1.00  0.00           H  
ATOM   1063  HE1 PHE A  72    -101.318  14.926 -37.933  1.00  0.00           H  
ATOM   1064  HE2 PHE A  72    -104.133  15.963 -40.962  1.00  0.00           H  
ATOM   1065  HZ  PHE A  72    -102.884  16.549 -38.924  1.00  0.00           H  
ATOM   1066  N   SER A  73    -100.841  13.038 -43.741  1.00  0.00           N  
ATOM   1067  CA  SER A  73    -100.562  14.261 -44.474  1.00  0.00           C  
ATOM   1068  C   SER A  73    -101.835  15.088 -44.590  1.00  0.00           C  
ATOM   1069  O   SER A  73    -102.931  14.540 -44.714  1.00  0.00           O  
ATOM   1070  CB  SER A  73    -100.010  13.942 -45.863  1.00  0.00           C  
ATOM   1071  OG  SER A  73     -98.864  13.111 -45.777  1.00  0.00           O  
ATOM   1072  H   SER A  73    -101.423  12.364 -44.147  1.00  0.00           H  
ATOM   1073  HA  SER A  73     -99.826  14.825 -43.920  1.00  0.00           H  
ATOM   1074  HB2 SER A  73    -100.767  13.431 -46.441  1.00  0.00           H  
ATOM   1075  HB3 SER A  73     -99.735  14.860 -46.359  1.00  0.00           H  
ATOM   1076  HG  SER A  73     -98.851  12.509 -46.539  1.00  0.00           H  
ATOM   1077  N   ALA A  74    -101.685  16.397 -44.549  1.00  0.00           N  
ATOM   1078  CA  ALA A  74    -102.828  17.294 -44.546  1.00  0.00           C  
ATOM   1079  C   ALA A  74    -102.600  18.484 -45.464  1.00  0.00           C  
ATOM   1080  O   ALA A  74    -101.483  18.981 -45.589  1.00  0.00           O  
ATOM   1081  CB  ALA A  74    -103.092  17.783 -43.133  1.00  0.00           C  
ATOM   1082  H   ALA A  74    -100.774  16.781 -44.529  1.00  0.00           H  
ATOM   1083  HA  ALA A  74    -103.693  16.744 -44.883  1.00  0.00           H  
ATOM   1084  HB1 ALA A  74    -102.809  18.822 -43.052  1.00  0.00           H  
ATOM   1085  HB2 ALA A  74    -102.504  17.202 -42.438  1.00  0.00           H  
ATOM   1086  HB3 ALA A  74    -104.140  17.673 -42.901  1.00  0.00           H  
ATOM   1087  N   SER A  75    -103.654  18.946 -46.106  1.00  0.00           N  
ATOM   1088  CA  SER A  75    -103.562  20.158 -46.888  1.00  0.00           C  
ATOM   1089  C   SER A  75    -104.130  21.305 -46.077  1.00  0.00           C  
ATOM   1090  O   SER A  75    -105.347  21.482 -45.999  1.00  0.00           O  
ATOM   1091  CB  SER A  75    -104.329  20.007 -48.203  1.00  0.00           C  
ATOM   1092  OG  SER A  75    -104.134  21.133 -49.043  1.00  0.00           O  
ATOM   1093  H   SER A  75    -104.509  18.471 -46.044  1.00  0.00           H  
ATOM   1094  HA  SER A  75    -102.522  20.351 -47.097  1.00  0.00           H  
ATOM   1095  HB2 SER A  75    -103.983  19.124 -48.720  1.00  0.00           H  
ATOM   1096  HB3 SER A  75    -105.385  19.908 -47.994  1.00  0.00           H  
ATOM   1097  HG  SER A  75    -103.350  20.982 -49.597  1.00  0.00           H  
ATOM   1098  N   VAL A  76    -103.252  22.075 -45.458  1.00  0.00           N  
ATOM   1099  CA  VAL A  76    -103.694  23.192 -44.647  1.00  0.00           C  
ATOM   1100  C   VAL A  76    -103.472  24.484 -45.414  1.00  0.00           C  
ATOM   1101  O   VAL A  76    -102.457  24.656 -46.085  1.00  0.00           O  
ATOM   1102  CB  VAL A  76    -102.989  23.241 -43.267  1.00  0.00           C  
ATOM   1103  CG1 VAL A  76    -102.998  21.878 -42.616  1.00  0.00           C  
ATOM   1104  CG2 VAL A  76    -101.573  23.746 -43.370  1.00  0.00           C  
ATOM   1105  H   VAL A  76    -102.292  21.899 -45.564  1.00  0.00           H  
ATOM   1106  HA  VAL A  76    -104.757  23.071 -44.479  1.00  0.00           H  
ATOM   1107  HB  VAL A  76    -103.543  23.916 -42.631  1.00  0.00           H  
ATOM   1108 HG11 VAL A  76    -102.283  21.854 -41.800  1.00  0.00           H  
ATOM   1109 HG12 VAL A  76    -102.727  21.141 -43.350  1.00  0.00           H  
ATOM   1110 HG13 VAL A  76    -103.986  21.665 -42.237  1.00  0.00           H  
ATOM   1111 HG21 VAL A  76    -101.179  23.909 -42.379  1.00  0.00           H  
ATOM   1112 HG22 VAL A  76    -101.575  24.668 -43.914  1.00  0.00           H  
ATOM   1113 HG23 VAL A  76    -100.962  23.021 -43.886  1.00  0.00           H  
ATOM   1114  N   LYS A  77    -104.441  25.374 -45.335  1.00  0.00           N  
ATOM   1115  CA  LYS A  77    -104.424  26.596 -46.125  1.00  0.00           C  
ATOM   1116  C   LYS A  77    -103.992  27.770 -45.267  1.00  0.00           C  
ATOM   1117  O   LYS A  77    -103.708  28.857 -45.767  1.00  0.00           O  
ATOM   1118  CB  LYS A  77    -105.807  26.872 -46.733  1.00  0.00           C  
ATOM   1119  CG  LYS A  77    -106.222  25.900 -47.836  1.00  0.00           C  
ATOM   1120  CD  LYS A  77    -106.504  24.502 -47.302  1.00  0.00           C  
ATOM   1121  CE  LYS A  77    -106.950  23.562 -48.409  1.00  0.00           C  
ATOM   1122  NZ  LYS A  77    -105.876  23.314 -49.407  1.00  0.00           N  
ATOM   1123  H   LYS A  77    -105.192  25.210 -44.716  1.00  0.00           H  
ATOM   1124  HA  LYS A  77    -103.709  26.464 -46.921  1.00  0.00           H  
ATOM   1125  HB2 LYS A  77    -106.546  26.822 -45.948  1.00  0.00           H  
ATOM   1126  HB3 LYS A  77    -105.806  27.870 -47.147  1.00  0.00           H  
ATOM   1127  HG2 LYS A  77    -107.116  26.276 -48.309  1.00  0.00           H  
ATOM   1128  HG3 LYS A  77    -105.427  25.842 -48.566  1.00  0.00           H  
ATOM   1129  HD2 LYS A  77    -105.603  24.111 -46.855  1.00  0.00           H  
ATOM   1130  HD3 LYS A  77    -107.282  24.561 -46.557  1.00  0.00           H  
ATOM   1131  HE2 LYS A  77    -107.239  22.620 -47.968  1.00  0.00           H  
ATOM   1132  HE3 LYS A  77    -107.799  23.998 -48.911  1.00  0.00           H  
ATOM   1133  HZ1 LYS A  77    -105.242  22.556 -49.076  1.00  0.00           H  
ATOM   1134  HZ2 LYS A  77    -105.310  24.180 -49.557  1.00  0.00           H  
ATOM   1135  HZ3 LYS A  77    -106.295  23.030 -50.319  1.00  0.00           H  
ATOM   1136  N   GLY A  78    -103.946  27.539 -43.970  1.00  0.00           N  
ATOM   1137  CA  GLY A  78    -103.550  28.568 -43.042  1.00  0.00           C  
ATOM   1138  C   GLY A  78    -103.570  28.058 -41.625  1.00  0.00           C  
ATOM   1139  O   GLY A  78    -104.637  27.842 -41.053  1.00  0.00           O  
ATOM   1140  H   GLY A  78    -104.188  26.651 -43.634  1.00  0.00           H  
ATOM   1141  HA2 GLY A  78    -102.550  28.898 -43.286  1.00  0.00           H  
ATOM   1142  HA3 GLY A  78    -104.229  29.404 -43.127  1.00  0.00           H  
ATOM   1143  N   ILE A  79    -102.394  27.827 -41.073  1.00  0.00           N  
ATOM   1144  CA  ILE A  79    -102.267  27.342 -39.723  1.00  0.00           C  
ATOM   1145  C   ILE A  79    -101.295  28.222 -38.950  1.00  0.00           C  
ATOM   1146  O   ILE A  79    -100.482  28.928 -39.546  1.00  0.00           O  
ATOM   1147  CB  ILE A  79    -101.782  25.883 -39.739  1.00  0.00           C  
ATOM   1148  CG1 ILE A  79    -101.587  25.328 -38.339  1.00  0.00           C  
ATOM   1149  CG2 ILE A  79    -100.488  25.761 -40.526  1.00  0.00           C  
ATOM   1150  CD1 ILE A  79    -101.167  23.882 -38.350  1.00  0.00           C  
ATOM   1151  H   ILE A  79    -101.580  27.970 -41.591  1.00  0.00           H  
ATOM   1152  HA  ILE A  79    -103.237  27.379 -39.253  1.00  0.00           H  
ATOM   1153  HB  ILE A  79    -102.533  25.296 -40.240  1.00  0.00           H  
ATOM   1154 HG12 ILE A  79    -100.818  25.895 -37.835  1.00  0.00           H  
ATOM   1155 HG13 ILE A  79    -102.512  25.408 -37.786  1.00  0.00           H  
ATOM   1156 HG21 ILE A  79    -100.066  24.785 -40.357  1.00  0.00           H  
ATOM   1157 HG22 ILE A  79     -99.792  26.518 -40.197  1.00  0.00           H  
ATOM   1158 HG23 ILE A  79    -100.693  25.890 -41.578  1.00  0.00           H  
ATOM   1159 HD11 ILE A  79    -100.851  23.605 -37.372  1.00  0.00           H  
ATOM   1160 HD12 ILE A  79    -100.352  23.748 -39.046  1.00  0.00           H  
ATOM   1161 HD13 ILE A  79    -102.002  23.267 -38.650  1.00  0.00           H  
ATOM   1162  N   LYS A  80    -101.401  28.195 -37.636  1.00  0.00           N  
ATOM   1163  CA  LYS A  80    -100.555  29.023 -36.792  1.00  0.00           C  
ATOM   1164  C   LYS A  80    -100.253  28.334 -35.465  1.00  0.00           C  
ATOM   1165  O   LYS A  80     -99.116  28.345 -34.999  1.00  0.00           O  
ATOM   1166  CB  LYS A  80    -101.237  30.374 -36.548  1.00  0.00           C  
ATOM   1167  CG  LYS A  80    -100.409  31.380 -35.758  1.00  0.00           C  
ATOM   1168  CD  LYS A  80     -99.156  31.827 -36.510  1.00  0.00           C  
ATOM   1169  CE  LYS A  80     -97.946  30.961 -36.186  1.00  0.00           C  
ATOM   1170  NZ  LYS A  80     -97.574  31.030 -34.746  1.00  0.00           N  
ATOM   1171  H   LYS A  80    -102.068  27.600 -37.229  1.00  0.00           H  
ATOM   1172  HA  LYS A  80     -99.627  29.191 -37.316  1.00  0.00           H  
ATOM   1173  HB2 LYS A  80    -101.477  30.815 -37.503  1.00  0.00           H  
ATOM   1174  HB3 LYS A  80    -102.157  30.201 -36.008  1.00  0.00           H  
ATOM   1175  HG2 LYS A  80    -101.019  32.248 -35.561  1.00  0.00           H  
ATOM   1176  HG3 LYS A  80    -100.114  30.929 -34.823  1.00  0.00           H  
ATOM   1177  HD2 LYS A  80     -99.351  31.771 -37.570  1.00  0.00           H  
ATOM   1178  HD3 LYS A  80     -98.937  32.850 -36.239  1.00  0.00           H  
ATOM   1179  HE2 LYS A  80     -98.174  29.936 -36.439  1.00  0.00           H  
ATOM   1180  HE3 LYS A  80     -97.110  31.299 -36.781  1.00  0.00           H  
ATOM   1181  HZ1 LYS A  80     -96.715  30.474 -34.571  1.00  0.00           H  
ATOM   1182  HZ2 LYS A  80     -98.346  30.648 -34.149  1.00  0.00           H  
ATOM   1183  HZ3 LYS A  80     -97.395  32.019 -34.463  1.00  0.00           H  
ATOM   1184  N   GLU A  81    -101.261  27.706 -34.875  1.00  0.00           N  
ATOM   1185  CA  GLU A  81    -101.133  27.165 -33.517  1.00  0.00           C  
ATOM   1186  C   GLU A  81    -101.724  25.775 -33.481  1.00  0.00           C  
ATOM   1187  O   GLU A  81    -102.428  25.416 -34.410  1.00  0.00           O  
ATOM   1188  CB  GLU A  81    -101.887  28.047 -32.523  1.00  0.00           C  
ATOM   1189  CG  GLU A  81    -101.532  29.517 -32.608  1.00  0.00           C  
ATOM   1190  CD  GLU A  81    -100.138  29.804 -32.099  1.00  0.00           C  
ATOM   1191  OE1 GLU A  81     -99.918  29.680 -30.878  1.00  0.00           O  
ATOM   1192  OE2 GLU A  81     -99.259  30.161 -32.909  1.00  0.00           O  
ATOM   1193  H   GLU A  81    -102.095  27.564 -35.377  1.00  0.00           H  
ATOM   1194  HA  GLU A  81    -100.087  27.125 -33.253  1.00  0.00           H  
ATOM   1195  HB2 GLU A  81    -102.946  27.945 -32.703  1.00  0.00           H  
ATOM   1196  HB3 GLU A  81    -101.665  27.705 -31.523  1.00  0.00           H  
ATOM   1197  HG2 GLU A  81    -101.595  29.825 -33.642  1.00  0.00           H  
ATOM   1198  HG3 GLU A  81    -102.240  30.083 -32.020  1.00  0.00           H  
ATOM   1199  N   PHE A  82    -101.448  24.977 -32.445  1.00  0.00           N  
ATOM   1200  CA  PHE A  82    -102.151  23.705 -32.313  1.00  0.00           C  
ATOM   1201  C   PHE A  82    -101.853  22.984 -31.013  1.00  0.00           C  
ATOM   1202  O   PHE A  82    -101.086  23.451 -30.176  1.00  0.00           O  
ATOM   1203  CB  PHE A  82    -101.838  22.767 -33.487  1.00  0.00           C  
ATOM   1204  CG  PHE A  82    -100.440  22.221 -33.509  1.00  0.00           C  
ATOM   1205  CD1 PHE A  82     -99.398  22.969 -34.026  1.00  0.00           C  
ATOM   1206  CD2 PHE A  82    -100.174  20.955 -33.018  1.00  0.00           C  
ATOM   1207  CE1 PHE A  82     -98.117  22.462 -34.053  1.00  0.00           C  
ATOM   1208  CE2 PHE A  82     -98.895  20.444 -33.042  1.00  0.00           C  
ATOM   1209  CZ  PHE A  82     -97.866  21.199 -33.558  1.00  0.00           C  
ATOM   1210  H   PHE A  82    -100.775  25.240 -31.770  1.00  0.00           H  
ATOM   1211  HA  PHE A  82    -103.209  23.934 -32.329  1.00  0.00           H  
ATOM   1212  HB2 PHE A  82    -102.513  21.927 -33.453  1.00  0.00           H  
ATOM   1213  HB3 PHE A  82    -101.996  23.303 -34.412  1.00  0.00           H  
ATOM   1214  HD1 PHE A  82     -99.596  23.958 -34.413  1.00  0.00           H  
ATOM   1215  HD2 PHE A  82    -100.982  20.365 -32.611  1.00  0.00           H  
ATOM   1216  HE1 PHE A  82     -97.312  23.056 -34.458  1.00  0.00           H  
ATOM   1217  HE2 PHE A  82     -98.700  19.455 -32.656  1.00  0.00           H  
ATOM   1218  HZ  PHE A  82     -96.862  20.802 -33.579  1.00  0.00           H  
ATOM   1219  N   TYR A  83    -102.509  21.844 -30.882  1.00  0.00           N  
ATOM   1220  CA  TYR A  83    -102.215  20.842 -29.875  1.00  0.00           C  
ATOM   1221  C   TYR A  83    -102.899  19.550 -30.294  1.00  0.00           C  
ATOM   1222  O   TYR A  83    -103.959  19.589 -30.910  1.00  0.00           O  
ATOM   1223  CB  TYR A  83    -102.650  21.282 -28.472  1.00  0.00           C  
ATOM   1224  CG  TYR A  83    -103.928  22.086 -28.413  1.00  0.00           C  
ATOM   1225  CD1 TYR A  83    -105.135  21.522 -28.764  1.00  0.00           C  
ATOM   1226  CD2 TYR A  83    -103.920  23.405 -27.983  1.00  0.00           C  
ATOM   1227  CE1 TYR A  83    -106.310  22.250 -28.697  1.00  0.00           C  
ATOM   1228  CE2 TYR A  83    -105.083  24.140 -27.914  1.00  0.00           C  
ATOM   1229  CZ  TYR A  83    -106.278  23.557 -28.271  1.00  0.00           C  
ATOM   1230  OH  TYR A  83    -107.443  24.285 -28.203  1.00  0.00           O  
ATOM   1231  H   TYR A  83    -103.244  21.657 -31.511  1.00  0.00           H  
ATOM   1232  HA  TYR A  83    -101.151  20.678 -29.878  1.00  0.00           H  
ATOM   1233  HB2 TYR A  83    -102.792  20.406 -27.860  1.00  0.00           H  
ATOM   1234  HB3 TYR A  83    -101.863  21.884 -28.041  1.00  0.00           H  
ATOM   1235  HD1 TYR A  83    -105.144  20.497 -29.098  1.00  0.00           H  
ATOM   1236  HD2 TYR A  83    -102.980  23.858 -27.704  1.00  0.00           H  
ATOM   1237  HE1 TYR A  83    -107.246  21.795 -28.978  1.00  0.00           H  
ATOM   1238  HE2 TYR A  83    -105.055  25.167 -27.578  1.00  0.00           H  
ATOM   1239  HH  TYR A  83    -108.141  23.739 -27.816  1.00  0.00           H  
ATOM   1240  N   ILE A  84    -102.290  18.411 -30.024  1.00  0.00           N  
ATOM   1241  CA  ILE A  84    -102.847  17.159 -30.500  1.00  0.00           C  
ATOM   1242  C   ILE A  84    -103.543  16.419 -29.369  1.00  0.00           C  
ATOM   1243  O   ILE A  84    -103.034  16.358 -28.246  1.00  0.00           O  
ATOM   1244  CB  ILE A  84    -101.773  16.261 -31.151  1.00  0.00           C  
ATOM   1245  CG1 ILE A  84    -101.032  17.025 -32.258  1.00  0.00           C  
ATOM   1246  CG2 ILE A  84    -102.405  15.000 -31.714  1.00  0.00           C  
ATOM   1247  CD1 ILE A  84    -101.949  17.706 -33.250  1.00  0.00           C  
ATOM   1248  H   ILE A  84    -101.467  18.406 -29.487  1.00  0.00           H  
ATOM   1249  HA  ILE A  84    -103.585  17.397 -31.255  1.00  0.00           H  
ATOM   1250  HB  ILE A  84    -101.067  15.969 -30.388  1.00  0.00           H  
ATOM   1251 HG12 ILE A  84    -100.408  17.784 -31.808  1.00  0.00           H  
ATOM   1252 HG13 ILE A  84    -100.411  16.334 -32.810  1.00  0.00           H  
ATOM   1253 HG21 ILE A  84    -101.647  14.407 -32.196  1.00  0.00           H  
ATOM   1254 HG22 ILE A  84    -103.166  15.271 -32.435  1.00  0.00           H  
ATOM   1255 HG23 ILE A  84    -102.853  14.433 -30.912  1.00  0.00           H  
ATOM   1256 HD11 ILE A  84    -102.566  18.428 -32.731  1.00  0.00           H  
ATOM   1257 HD12 ILE A  84    -102.582  16.967 -33.720  1.00  0.00           H  
ATOM   1258 HD13 ILE A  84    -101.361  18.211 -34.002  1.00  0.00           H  
ATOM   1259  N   LYS A  85    -104.714  15.869 -29.663  1.00  0.00           N  
ATOM   1260  CA  LYS A  85    -105.512  15.227 -28.664  1.00  0.00           C  
ATOM   1261  C   LYS A  85    -105.427  13.729 -28.789  1.00  0.00           C  
ATOM   1262  O   LYS A  85    -105.317  13.174 -29.886  1.00  0.00           O  
ATOM   1263  CB  LYS A  85    -106.960  15.656 -28.795  1.00  0.00           C  
ATOM   1264  CG  LYS A  85    -107.152  17.154 -28.752  1.00  0.00           C  
ATOM   1265  CD  LYS A  85    -108.613  17.484 -28.581  1.00  0.00           C  
ATOM   1266  CE  LYS A  85    -109.421  17.204 -29.837  1.00  0.00           C  
ATOM   1267  NZ  LYS A  85    -110.867  17.463 -29.624  1.00  0.00           N  
ATOM   1268  H   LYS A  85    -105.043  15.878 -30.578  1.00  0.00           H  
ATOM   1269  HA  LYS A  85    -105.144  15.524 -27.695  1.00  0.00           H  
ATOM   1270  HB2 LYS A  85    -107.347  15.292 -29.734  1.00  0.00           H  
ATOM   1271  HB3 LYS A  85    -107.528  15.217 -27.988  1.00  0.00           H  
ATOM   1272  HG2 LYS A  85    -106.597  17.558 -27.919  1.00  0.00           H  
ATOM   1273  HG3 LYS A  85    -106.796  17.585 -29.676  1.00  0.00           H  
ATOM   1274  HD2 LYS A  85    -108.988  16.865 -27.788  1.00  0.00           H  
ATOM   1275  HD3 LYS A  85    -108.715  18.527 -28.313  1.00  0.00           H  
ATOM   1276  HE2 LYS A  85    -109.063  17.840 -30.633  1.00  0.00           H  
ATOM   1277  HE3 LYS A  85    -109.285  16.168 -30.115  1.00  0.00           H  
ATOM   1278  HZ1 LYS A  85    -111.018  18.460 -29.352  1.00  0.00           H  
ATOM   1279  HZ2 LYS A  85    -111.230  16.848 -28.863  1.00  0.00           H  
ATOM   1280  HZ3 LYS A  85    -111.405  17.266 -30.494  1.00  0.00           H  
ATOM   1281  N   TYR A  86    -105.489  13.093 -27.654  1.00  0.00           N  
ATOM   1282  CA  TYR A  86    -105.526  11.656 -27.587  1.00  0.00           C  
ATOM   1283  C   TYR A  86    -106.916  11.231 -27.155  1.00  0.00           C  
ATOM   1284  O   TYR A  86    -107.243  11.279 -25.968  1.00  0.00           O  
ATOM   1285  CB  TYR A  86    -104.472  11.153 -26.598  1.00  0.00           C  
ATOM   1286  CG  TYR A  86    -104.357   9.648 -26.540  1.00  0.00           C  
ATOM   1287  CD1 TYR A  86    -104.471   8.885 -27.686  1.00  0.00           C  
ATOM   1288  CD2 TYR A  86    -104.135   8.994 -25.339  1.00  0.00           C  
ATOM   1289  CE1 TYR A  86    -104.375   7.518 -27.642  1.00  0.00           C  
ATOM   1290  CE2 TYR A  86    -104.034   7.620 -25.287  1.00  0.00           C  
ATOM   1291  CZ  TYR A  86    -104.159   6.886 -26.446  1.00  0.00           C  
ATOM   1292  OH  TYR A  86    -104.087   5.515 -26.408  1.00  0.00           O  
ATOM   1293  H   TYR A  86    -105.532  13.616 -26.830  1.00  0.00           H  
ATOM   1294  HA  TYR A  86    -105.318  11.262 -28.570  1.00  0.00           H  
ATOM   1295  HB2 TYR A  86    -103.511  11.551 -26.877  1.00  0.00           H  
ATOM   1296  HB3 TYR A  86    -104.726  11.505 -25.608  1.00  0.00           H  
ATOM   1297  HD1 TYR A  86    -104.645   9.378 -28.624  1.00  0.00           H  
ATOM   1298  HD2 TYR A  86    -104.040   9.576 -24.433  1.00  0.00           H  
ATOM   1299  HE1 TYR A  86    -104.464   6.949 -28.542  1.00  0.00           H  
ATOM   1300  HE2 TYR A  86    -103.863   7.125 -24.344  1.00  0.00           H  
ATOM   1301  HH  TYR A  86    -104.564   5.199 -25.638  1.00  0.00           H  
ATOM   1302  N   GLU A  87    -107.740  10.819 -28.108  1.00  0.00           N  
ATOM   1303  CA  GLU A  87    -109.109  10.497 -27.810  1.00  0.00           C  
ATOM   1304  C   GLU A  87    -109.314   9.000 -27.941  1.00  0.00           C  
ATOM   1305  O   GLU A  87    -109.054   8.403 -28.981  1.00  0.00           O  
ATOM   1306  CB  GLU A  87    -110.045  11.282 -28.727  1.00  0.00           C  
ATOM   1307  CG  GLU A  87    -111.501  11.181 -28.324  1.00  0.00           C  
ATOM   1308  CD  GLU A  87    -112.375  12.192 -29.038  1.00  0.00           C  
ATOM   1309  OE1 GLU A  87    -112.313  13.392 -28.691  1.00  0.00           O  
ATOM   1310  OE2 GLU A  87    -113.137  11.797 -29.942  1.00  0.00           O  
ATOM   1311  H   GLU A  87    -107.418  10.708 -29.030  1.00  0.00           H  
ATOM   1312  HA  GLU A  87    -109.299  10.783 -26.786  1.00  0.00           H  
ATOM   1313  HB2 GLU A  87    -109.759  12.323 -28.706  1.00  0.00           H  
ATOM   1314  HB3 GLU A  87    -109.941  10.912 -29.732  1.00  0.00           H  
ATOM   1315  HG2 GLU A  87    -111.860  10.190 -28.555  1.00  0.00           H  
ATOM   1316  HG3 GLU A  87    -111.570  11.350 -27.263  1.00  0.00           H  
ATOM   1317  N   VAL A  88    -109.730   8.396 -26.857  1.00  0.00           N  
ATOM   1318  CA  VAL A  88    -109.856   6.962 -26.774  1.00  0.00           C  
ATOM   1319  C   VAL A  88    -111.293   6.606 -26.433  1.00  0.00           C  
ATOM   1320  O   VAL A  88    -112.008   7.418 -25.852  1.00  0.00           O  
ATOM   1321  CB  VAL A  88    -108.883   6.435 -25.689  1.00  0.00           C  
ATOM   1322  CG1 VAL A  88    -108.972   4.931 -25.519  1.00  0.00           C  
ATOM   1323  CG2 VAL A  88    -107.463   6.845 -26.048  1.00  0.00           C  
ATOM   1324  H   VAL A  88    -109.966   8.935 -26.069  1.00  0.00           H  
ATOM   1325  HA  VAL A  88    -109.588   6.532 -27.728  1.00  0.00           H  
ATOM   1326  HB  VAL A  88    -109.137   6.898 -24.747  1.00  0.00           H  
ATOM   1327 HG11 VAL A  88    -108.412   4.632 -24.646  1.00  0.00           H  
ATOM   1328 HG12 VAL A  88    -108.555   4.459 -26.388  1.00  0.00           H  
ATOM   1329 HG13 VAL A  88    -110.005   4.639 -25.406  1.00  0.00           H  
ATOM   1330 HG21 VAL A  88    -106.789   6.594 -25.247  1.00  0.00           H  
ATOM   1331 HG22 VAL A  88    -107.432   7.907 -26.223  1.00  0.00           H  
ATOM   1332 HG23 VAL A  88    -107.158   6.328 -26.948  1.00  0.00           H  
ATOM   1333  N   SER A  89    -111.714   5.398 -26.786  1.00  0.00           N  
ATOM   1334  CA  SER A  89    -113.059   4.935 -26.486  1.00  0.00           C  
ATOM   1335  C   SER A  89    -113.151   4.537 -25.009  1.00  0.00           C  
ATOM   1336  O   SER A  89    -113.883   3.625 -24.623  1.00  0.00           O  
ATOM   1337  CB  SER A  89    -113.414   3.767 -27.403  1.00  0.00           C  
ATOM   1338  OG  SER A  89    -114.801   3.475 -27.367  1.00  0.00           O  
ATOM   1339  H   SER A  89    -111.101   4.802 -27.258  1.00  0.00           H  
ATOM   1340  HA  SER A  89    -113.737   5.744 -26.683  1.00  0.00           H  
ATOM   1341  HB2 SER A  89    -113.149   4.033 -28.409  1.00  0.00           H  
ATOM   1342  HB3 SER A  89    -112.862   2.889 -27.101  1.00  0.00           H  
ATOM   1343  HG  SER A  89    -115.294   4.271 -27.617  1.00  0.00           H  
ATOM   1344  N   GLY A  90    -112.375   5.241 -24.202  1.00  0.00           N  
ATOM   1345  CA  GLY A  90    -112.338   5.023 -22.778  1.00  0.00           C  
ATOM   1346  C   GLY A  90    -111.804   6.233 -22.033  1.00  0.00           C  
ATOM   1347  O   GLY A  90    -112.221   6.512 -20.910  1.00  0.00           O  
ATOM   1348  H   GLY A  90    -111.813   5.932 -24.594  1.00  0.00           H  
ATOM   1349  HA2 GLY A  90    -113.336   4.802 -22.430  1.00  0.00           H  
ATOM   1350  HA3 GLY A  90    -111.700   4.182 -22.578  1.00  0.00           H  
ATOM   1351  N   LYS A  91    -110.874   6.957 -22.658  1.00  0.00           N  
ATOM   1352  CA  LYS A  91    -110.279   8.143 -22.049  1.00  0.00           C  
ATOM   1353  C   LYS A  91    -109.956   9.208 -23.073  1.00  0.00           C  
ATOM   1354  O   LYS A  91    -110.173   9.042 -24.269  1.00  0.00           O  
ATOM   1355  CB  LYS A  91    -108.989   7.794 -21.316  1.00  0.00           C  
ATOM   1356  CG  LYS A  91    -109.184   7.507 -19.842  1.00  0.00           C  
ATOM   1357  CD  LYS A  91    -109.411   8.780 -19.027  1.00  0.00           C  
ATOM   1358  CE  LYS A  91    -108.283   9.787 -19.213  1.00  0.00           C  
ATOM   1359  NZ  LYS A  91    -108.366  10.914 -18.245  1.00  0.00           N  
ATOM   1360  H   LYS A  91    -110.581   6.689 -23.548  1.00  0.00           H  
ATOM   1361  HA  LYS A  91    -110.988   8.544 -21.340  1.00  0.00           H  
ATOM   1362  HB2 LYS A  91    -108.552   6.927 -21.784  1.00  0.00           H  
ATOM   1363  HB3 LYS A  91    -108.303   8.623 -21.410  1.00  0.00           H  
ATOM   1364  HG2 LYS A  91    -110.052   6.886 -19.740  1.00  0.00           H  
ATOM   1365  HG3 LYS A  91    -108.316   6.990 -19.461  1.00  0.00           H  
ATOM   1366  HD2 LYS A  91    -110.337   9.236 -19.345  1.00  0.00           H  
ATOM   1367  HD3 LYS A  91    -109.478   8.518 -17.981  1.00  0.00           H  
ATOM   1368  HE2 LYS A  91    -107.340   9.280 -19.080  1.00  0.00           H  
ATOM   1369  HE3 LYS A  91    -108.337  10.184 -20.217  1.00  0.00           H  
ATOM   1370  HZ1 LYS A  91    -109.348  11.259 -18.169  1.00  0.00           H  
ATOM   1371  HZ2 LYS A  91    -107.760  11.705 -18.560  1.00  0.00           H  
ATOM   1372  HZ3 LYS A  91    -108.042  10.603 -17.302  1.00  0.00           H  
ATOM   1373  N   THR A  92    -109.441  10.305 -22.565  1.00  0.00           N  
ATOM   1374  CA  THR A  92    -108.962  11.404 -23.391  1.00  0.00           C  
ATOM   1375  C   THR A  92    -107.808  12.122 -22.692  1.00  0.00           C  
ATOM   1376  O   THR A  92    -107.798  12.250 -21.467  1.00  0.00           O  
ATOM   1377  CB  THR A  92    -110.078  12.423 -23.700  1.00  0.00           C  
ATOM   1378  OG1 THR A  92    -111.290  11.739 -24.048  1.00  0.00           O  
ATOM   1379  CG2 THR A  92    -109.680  13.344 -24.850  1.00  0.00           C  
ATOM   1380  H   THR A  92    -109.371  10.371 -21.586  1.00  0.00           H  
ATOM   1381  HA  THR A  92    -108.608  10.988 -24.322  1.00  0.00           H  
ATOM   1382  HB  THR A  92    -110.243  13.024 -22.821  1.00  0.00           H  
ATOM   1383  HG1 THR A  92    -111.118  10.792 -24.105  1.00  0.00           H  
ATOM   1384 HG21 THR A  92    -108.810  13.922 -24.569  1.00  0.00           H  
ATOM   1385 HG22 THR A  92    -110.499  14.011 -25.076  1.00  0.00           H  
ATOM   1386 HG23 THR A  92    -109.450  12.750 -25.722  1.00  0.00           H  
ATOM   1387  N   TYR A  93    -106.838  12.566 -23.473  1.00  0.00           N  
ATOM   1388  CA  TYR A  93    -105.709  13.334 -22.951  1.00  0.00           C  
ATOM   1389  C   TYR A  93    -105.321  14.399 -23.965  1.00  0.00           C  
ATOM   1390  O   TYR A  93    -105.990  14.578 -24.985  1.00  0.00           O  
ATOM   1391  CB  TYR A  93    -104.476  12.455 -22.676  1.00  0.00           C  
ATOM   1392  CG  TYR A  93    -104.731  11.207 -21.875  1.00  0.00           C  
ATOM   1393  CD1 TYR A  93    -105.180  10.081 -22.510  1.00  0.00           C  
ATOM   1394  CD2 TYR A  93    -104.496  11.152 -20.507  1.00  0.00           C  
ATOM   1395  CE1 TYR A  93    -105.404   8.906 -21.821  1.00  0.00           C  
ATOM   1396  CE2 TYR A  93    -104.717   9.986 -19.799  1.00  0.00           C  
ATOM   1397  CZ  TYR A  93    -105.170   8.864 -20.461  1.00  0.00           C  
ATOM   1398  OH  TYR A  93    -105.378   7.696 -19.768  1.00  0.00           O  
ATOM   1399  H   TYR A  93    -106.896  12.396 -24.436  1.00  0.00           H  
ATOM   1400  HA  TYR A  93    -106.021  13.813 -22.034  1.00  0.00           H  
ATOM   1401  HB2 TYR A  93    -104.052  12.146 -23.618  1.00  0.00           H  
ATOM   1402  HB3 TYR A  93    -103.744  13.035 -22.138  1.00  0.00           H  
ATOM   1403  HD1 TYR A  93    -105.358  10.140 -23.572  1.00  0.00           H  
ATOM   1404  HD2 TYR A  93    -104.142  12.036 -19.996  1.00  0.00           H  
ATOM   1405  HE1 TYR A  93    -105.754   8.028 -22.345  1.00  0.00           H  
ATOM   1406  HE2 TYR A  93    -104.535   9.955 -18.735  1.00  0.00           H  
ATOM   1407  HH  TYR A  93    -105.530   7.896 -18.832  1.00  0.00           H  
ATOM   1408  N   TYR A  94    -104.215  15.063 -23.695  1.00  0.00           N  
ATOM   1409  CA  TYR A  94    -103.719  16.147 -24.535  1.00  0.00           C  
ATOM   1410  C   TYR A  94    -102.196  16.151 -24.561  1.00  0.00           C  
ATOM   1411  O   TYR A  94    -101.554  15.953 -23.529  1.00  0.00           O  
ATOM   1412  CB  TYR A  94    -104.169  17.517 -24.010  1.00  0.00           C  
ATOM   1413  CG  TYR A  94    -105.654  17.804 -24.065  1.00  0.00           C  
ATOM   1414  CD1 TYR A  94    -106.367  17.721 -25.254  1.00  0.00           C  
ATOM   1415  CD2 TYR A  94    -106.331  18.210 -22.924  1.00  0.00           C  
ATOM   1416  CE1 TYR A  94    -107.715  18.030 -25.297  1.00  0.00           C  
ATOM   1417  CE2 TYR A  94    -107.676  18.513 -22.958  1.00  0.00           C  
ATOM   1418  CZ  TYR A  94    -108.363  18.425 -24.147  1.00  0.00           C  
ATOM   1419  OH  TYR A  94    -109.704  18.738 -24.187  1.00  0.00           O  
ATOM   1420  H   TYR A  94    -103.697  14.796 -22.909  1.00  0.00           H  
ATOM   1421  HA  TYR A  94    -104.095  16.004 -25.538  1.00  0.00           H  
ATOM   1422  HB2 TYR A  94    -103.867  17.603 -22.978  1.00  0.00           H  
ATOM   1423  HB3 TYR A  94    -103.665  18.285 -24.582  1.00  0.00           H  
ATOM   1424  HD1 TYR A  94    -105.859  17.403 -26.151  1.00  0.00           H  
ATOM   1425  HD2 TYR A  94    -105.789  18.279 -21.992  1.00  0.00           H  
ATOM   1426  HE1 TYR A  94    -108.254  17.963 -26.233  1.00  0.00           H  
ATOM   1427  HE2 TYR A  94    -108.183  18.821 -22.056  1.00  0.00           H  
ATOM   1428  HH  TYR A  94    -109.861  19.535 -23.659  1.00  0.00           H  
ATOM   1429  N   ASP A  95    -101.628  16.376 -25.735  1.00  0.00           N  
ATOM   1430  CA  ASP A  95    -100.213  16.713 -25.847  1.00  0.00           C  
ATOM   1431  C   ASP A  95    -100.114  18.159 -26.299  1.00  0.00           C  
ATOM   1432  O   ASP A  95    -100.379  18.475 -27.462  1.00  0.00           O  
ATOM   1433  CB  ASP A  95     -99.474  15.800 -26.834  1.00  0.00           C  
ATOM   1434  CG  ASP A  95     -97.990  16.136 -26.931  1.00  0.00           C  
ATOM   1435  OD1 ASP A  95     -97.244  15.830 -25.977  1.00  0.00           O  
ATOM   1436  OD2 ASP A  95     -97.566  16.700 -27.964  1.00  0.00           O  
ATOM   1437  H   ASP A  95    -102.172  16.324 -26.554  1.00  0.00           H  
ATOM   1438  HA  ASP A  95     -99.768  16.619 -24.865  1.00  0.00           H  
ATOM   1439  HB2 ASP A  95     -99.571  14.776 -26.510  1.00  0.00           H  
ATOM   1440  HB3 ASP A  95     -99.914  15.908 -27.816  1.00  0.00           H  
ATOM   1441  N   ASN A  96     -99.779  19.046 -25.373  1.00  0.00           N  
ATOM   1442  CA  ASN A  96     -99.839  20.467 -25.652  1.00  0.00           C  
ATOM   1443  C   ASN A  96     -98.833  21.246 -24.814  1.00  0.00           C  
ATOM   1444  O   ASN A  96     -99.164  21.668 -23.711  1.00  0.00           O  
ATOM   1445  CB  ASN A  96    -101.249  20.991 -25.383  1.00  0.00           C  
ATOM   1446  CG  ASN A  96    -101.397  22.457 -25.718  1.00  0.00           C  
ATOM   1447  OD1 ASN A  96    -100.681  22.997 -26.561  1.00  0.00           O  
ATOM   1448  ND2 ASN A  96    -102.355  23.102 -25.081  1.00  0.00           N  
ATOM   1449  H   ASN A  96     -99.475  18.739 -24.496  1.00  0.00           H  
ATOM   1450  HA  ASN A  96     -99.613  20.609 -26.699  1.00  0.00           H  
ATOM   1451  HB2 ASN A  96    -101.956  20.433 -25.979  1.00  0.00           H  
ATOM   1452  HB3 ASN A  96    -101.482  20.860 -24.339  1.00  0.00           H  
ATOM   1453 HD21 ASN A  96    -102.907  22.601 -24.444  1.00  0.00           H  
ATOM   1454 HD22 ASN A  96    -102.480  24.060 -25.283  1.00  0.00           H  
ATOM   1455  N   ASN A  97     -97.611  21.356 -25.351  1.00  0.00           N  
ATOM   1456  CA  ASN A  97     -96.515  22.238 -24.877  1.00  0.00           C  
ATOM   1457  C   ASN A  97     -96.329  22.296 -23.347  1.00  0.00           C  
ATOM   1458  O   ASN A  97     -95.322  21.817 -22.822  1.00  0.00           O  
ATOM   1459  CB  ASN A  97     -96.622  23.661 -25.501  1.00  0.00           C  
ATOM   1460  CG  ASN A  97     -97.644  24.615 -24.879  1.00  0.00           C  
ATOM   1461  OD1 ASN A  97     -98.707  24.223 -24.405  1.00  0.00           O  
ATOM   1462  ND2 ASN A  97     -97.310  25.897 -24.879  1.00  0.00           N  
ATOM   1463  H   ASN A  97     -97.413  20.778 -26.124  1.00  0.00           H  
ATOM   1464  HA  ASN A  97     -95.610  21.798 -25.269  1.00  0.00           H  
ATOM   1465  HB2 ASN A  97     -95.662  24.138 -25.426  1.00  0.00           H  
ATOM   1466  HB3 ASN A  97     -96.869  23.550 -26.549  1.00  0.00           H  
ATOM   1467 HD21 ASN A  97     -96.436  26.151 -25.277  1.00  0.00           H  
ATOM   1468 HD22 ASN A  97     -97.934  26.543 -24.478  1.00  0.00           H  
ATOM   1469  N   ASN A  98     -97.284  22.875 -22.649  1.00  0.00           N  
ATOM   1470  CA  ASN A  98     -97.218  23.060 -21.214  1.00  0.00           C  
ATOM   1471  C   ASN A  98     -98.630  23.279 -20.707  1.00  0.00           C  
ATOM   1472  O   ASN A  98     -99.073  22.626 -19.761  1.00  0.00           O  
ATOM   1473  CB  ASN A  98     -96.329  24.256 -20.852  1.00  0.00           C  
ATOM   1474  CG  ASN A  98     -96.155  24.422 -19.352  1.00  0.00           C  
ATOM   1475  OD1 ASN A  98     -96.165  23.446 -18.599  1.00  0.00           O  
ATOM   1476  ND2 ASN A  98     -95.984  25.657 -18.910  1.00  0.00           N  
ATOM   1477  H   ASN A  98     -98.105  23.152 -23.124  1.00  0.00           H  
ATOM   1478  HA  ASN A  98     -96.816  22.160 -20.773  1.00  0.00           H  
ATOM   1479  HB2 ASN A  98     -95.353  24.119 -21.295  1.00  0.00           H  
ATOM   1480  HB3 ASN A  98     -96.772  25.159 -21.244  1.00  0.00           H  
ATOM   1481 HD21 ASN A  98     -95.977  26.392 -19.569  1.00  0.00           H  
ATOM   1482 HD22 ASN A  98     -95.876  25.797 -17.942  1.00  0.00           H  
ATOM   1483  N   SER A  99     -99.336  24.200 -21.367  1.00  0.00           N  
ATOM   1484  CA  SER A  99    -100.736  24.456 -21.069  1.00  0.00           C  
ATOM   1485  C   SER A  99    -101.355  25.459 -22.053  1.00  0.00           C  
ATOM   1486  O   SER A  99    -102.391  26.062 -21.757  1.00  0.00           O  
ATOM   1487  CB  SER A  99    -100.874  24.979 -19.635  1.00  0.00           C  
ATOM   1488  OG  SER A  99     -99.954  26.033 -19.390  1.00  0.00           O  
ATOM   1489  H   SER A  99     -98.892  24.727 -22.060  1.00  0.00           H  
ATOM   1490  HA  SER A  99    -101.263  23.520 -21.153  1.00  0.00           H  
ATOM   1491  HB2 SER A  99    -101.878  25.351 -19.484  1.00  0.00           H  
ATOM   1492  HB3 SER A  99    -100.679  24.175 -18.940  1.00  0.00           H  
ATOM   1493  HG  SER A  99     -99.620  25.967 -18.479  1.00  0.00           H  
ATOM   1494  N   ALA A 100    -100.745  25.637 -23.226  1.00  0.00           N  
ATOM   1495  CA  ALA A 100    -101.214  26.656 -24.160  1.00  0.00           C  
ATOM   1496  C   ALA A 100    -101.438  26.121 -25.576  1.00  0.00           C  
ATOM   1497  O   ALA A 100    -102.537  25.681 -25.910  1.00  0.00           O  
ATOM   1498  CB  ALA A 100    -100.241  27.820 -24.183  1.00  0.00           C  
ATOM   1499  H   ALA A 100     -99.973  25.082 -23.467  1.00  0.00           H  
ATOM   1500  HA  ALA A 100    -102.157  27.028 -23.784  1.00  0.00           H  
ATOM   1501  HB1 ALA A 100     -99.431  27.597 -24.862  1.00  0.00           H  
ATOM   1502  HB2 ALA A 100     -99.842  27.961 -23.191  1.00  0.00           H  
ATOM   1503  HB3 ALA A 100    -100.750  28.717 -24.503  1.00  0.00           H  
ATOM   1504  N   ASN A 101    -100.376  26.128 -26.382  1.00  0.00           N  
ATOM   1505  CA  ASN A 101    -100.454  25.856 -27.822  1.00  0.00           C  
ATOM   1506  C   ASN A 101     -99.060  25.680 -28.388  1.00  0.00           C  
ATOM   1507  O   ASN A 101     -98.106  26.292 -27.906  1.00  0.00           O  
ATOM   1508  CB  ASN A 101    -101.135  27.010 -28.576  1.00  0.00           C  
ATOM   1509  CG  ASN A 101    -102.652  26.894 -28.636  1.00  0.00           C  
ATOM   1510  OD1 ASN A 101    -103.369  27.452 -27.806  1.00  0.00           O  
ATOM   1511  ND2 ASN A 101    -103.150  26.166 -29.625  1.00  0.00           N  
ATOM   1512  H   ASN A 101     -99.493  26.293 -25.989  1.00  0.00           H  
ATOM   1513  HA  ASN A 101    -101.016  24.948 -27.984  1.00  0.00           H  
ATOM   1514  HB2 ASN A 101    -100.889  27.940 -28.083  1.00  0.00           H  
ATOM   1515  HB3 ASN A 101    -100.755  27.039 -29.586  1.00  0.00           H  
ATOM   1516 HD21 ASN A 101    -102.526  25.745 -30.248  1.00  0.00           H  
ATOM   1517 HD22 ASN A 101    -104.123  26.078 -29.685  1.00  0.00           H  
ATOM   1518  N   TYR A 102     -98.943  24.838 -29.398  1.00  0.00           N  
ATOM   1519  CA  TYR A 102     -97.712  24.734 -30.160  1.00  0.00           C  
ATOM   1520  C   TYR A 102     -97.711  25.780 -31.261  1.00  0.00           C  
ATOM   1521  O   TYR A 102     -98.631  25.819 -32.081  1.00  0.00           O  
ATOM   1522  CB  TYR A 102     -97.566  23.352 -30.794  1.00  0.00           C  
ATOM   1523  CG  TYR A 102     -97.321  22.228 -29.817  1.00  0.00           C  
ATOM   1524  CD1 TYR A 102     -96.079  22.063 -29.223  1.00  0.00           C  
ATOM   1525  CD2 TYR A 102     -98.326  21.324 -29.504  1.00  0.00           C  
ATOM   1526  CE1 TYR A 102     -95.843  21.030 -28.342  1.00  0.00           C  
ATOM   1527  CE2 TYR A 102     -98.097  20.288 -28.622  1.00  0.00           C  
ATOM   1528  CZ  TYR A 102     -96.856  20.145 -28.045  1.00  0.00           C  
ATOM   1529  OH  TYR A 102     -96.626  19.125 -27.155  1.00  0.00           O  
ATOM   1530  H   TYR A 102     -99.706  24.265 -29.638  1.00  0.00           H  
ATOM   1531  HA  TYR A 102     -96.884  24.914 -29.491  1.00  0.00           H  
ATOM   1532  HB2 TYR A 102     -98.468  23.119 -31.336  1.00  0.00           H  
ATOM   1533  HB3 TYR A 102     -96.737  23.373 -31.485  1.00  0.00           H  
ATOM   1534  HD1 TYR A 102     -95.287  22.760 -29.457  1.00  0.00           H  
ATOM   1535  HD2 TYR A 102     -99.300  21.440 -29.958  1.00  0.00           H  
ATOM   1536  HE1 TYR A 102     -94.870  20.918 -27.889  1.00  0.00           H  
ATOM   1537  HE2 TYR A 102     -98.891  19.595 -28.389  1.00  0.00           H  
ATOM   1538  HH  TYR A 102     -96.962  18.285 -27.523  1.00  0.00           H  
ATOM   1539  N   GLN A 103     -96.699  26.629 -31.271  1.00  0.00           N  
ATOM   1540  CA  GLN A 103     -96.545  27.600 -32.339  1.00  0.00           C  
ATOM   1541  C   GLN A 103     -95.989  26.899 -33.568  1.00  0.00           C  
ATOM   1542  O   GLN A 103     -94.924  26.287 -33.511  1.00  0.00           O  
ATOM   1543  CB  GLN A 103     -95.601  28.745 -31.935  1.00  0.00           C  
ATOM   1544  CG  GLN A 103     -96.161  29.746 -30.931  1.00  0.00           C  
ATOM   1545  CD  GLN A 103     -96.536  29.122 -29.608  1.00  0.00           C  
ATOM   1546  OE1 GLN A 103     -95.713  28.996 -28.700  1.00  0.00           O  
ATOM   1547  NE2 GLN A 103     -97.789  28.751 -29.486  1.00  0.00           N  
ATOM   1548  H   GLN A 103     -96.038  26.597 -30.545  1.00  0.00           H  
ATOM   1549  HA  GLN A 103     -97.518  28.004 -32.574  1.00  0.00           H  
ATOM   1550  HB2 GLN A 103     -94.702  28.322 -31.516  1.00  0.00           H  
ATOM   1551  HB3 GLN A 103     -95.342  29.290 -32.823  1.00  0.00           H  
ATOM   1552  HG2 GLN A 103     -95.416  30.505 -30.750  1.00  0.00           H  
ATOM   1553  HG3 GLN A 103     -97.041  30.206 -31.359  1.00  0.00           H  
ATOM   1554 HE21 GLN A 103     -98.391  28.908 -30.256  1.00  0.00           H  
ATOM   1555 HE22 GLN A 103     -98.072  28.329 -28.649  1.00  0.00           H  
ATOM   1556  N   VAL A 104     -96.705  26.980 -34.675  1.00  0.00           N  
ATOM   1557  CA  VAL A 104     -96.248  26.365 -35.908  1.00  0.00           C  
ATOM   1558  C   VAL A 104     -95.178  27.237 -36.550  1.00  0.00           C  
ATOM   1559  O   VAL A 104     -95.343  28.454 -36.649  1.00  0.00           O  
ATOM   1560  CB  VAL A 104     -97.407  26.162 -36.906  1.00  0.00           C  
ATOM   1561  CG1 VAL A 104     -96.932  25.450 -38.163  1.00  0.00           C  
ATOM   1562  CG2 VAL A 104     -98.539  25.388 -36.255  1.00  0.00           C  
ATOM   1563  H   VAL A 104     -97.573  27.452 -34.659  1.00  0.00           H  
ATOM   1564  HA  VAL A 104     -95.822  25.400 -35.672  1.00  0.00           H  
ATOM   1565  HB  VAL A 104     -97.784  27.133 -37.189  1.00  0.00           H  
ATOM   1566 HG11 VAL A 104     -97.769  25.300 -38.828  1.00  0.00           H  
ATOM   1567 HG12 VAL A 104     -96.508  24.494 -37.895  1.00  0.00           H  
ATOM   1568 HG13 VAL A 104     -96.185  26.053 -38.656  1.00  0.00           H  
ATOM   1569 HG21 VAL A 104     -98.197  24.397 -36.002  1.00  0.00           H  
ATOM   1570 HG22 VAL A 104     -99.367  25.321 -36.941  1.00  0.00           H  
ATOM   1571 HG23 VAL A 104     -98.856  25.900 -35.357  1.00  0.00           H  
ATOM   1572  N   SER A 105     -94.074  26.620 -36.952  1.00  0.00           N  
ATOM   1573  CA  SER A 105     -92.958  27.347 -37.539  1.00  0.00           C  
ATOM   1574  C   SER A 105     -93.289  27.803 -38.959  1.00  0.00           C  
ATOM   1575  O   SER A 105     -92.851  27.200 -39.940  1.00  0.00           O  
ATOM   1576  CB  SER A 105     -91.702  26.473 -37.539  1.00  0.00           C  
ATOM   1577  OG  SER A 105     -91.401  26.010 -36.232  1.00  0.00           O  
ATOM   1578  H   SER A 105     -94.009  25.647 -36.852  1.00  0.00           H  
ATOM   1579  HA  SER A 105     -92.778  28.218 -36.930  1.00  0.00           H  
ATOM   1580  HB2 SER A 105     -91.856  25.619 -38.181  1.00  0.00           H  
ATOM   1581  HB3 SER A 105     -90.864  27.050 -37.904  1.00  0.00           H  
ATOM   1582  HG  SER A 105     -91.908  26.524 -35.579  1.00  0.00           H  
ATOM   1583  N   THR A 106     -94.082  28.855 -39.056  1.00  0.00           N  
ATOM   1584  CA  THR A 106     -94.416  29.444 -40.336  1.00  0.00           C  
ATOM   1585  C   THR A 106     -93.799  30.838 -40.432  1.00  0.00           C  
ATOM   1586  O   THR A 106     -94.483  31.824 -40.098  1.00  0.00           O  
ATOM   1587  CB  THR A 106     -95.945  29.522 -40.519  1.00  0.00           C  
ATOM   1588  OG1 THR A 106     -96.537  28.270 -40.143  1.00  0.00           O  
ATOM   1589  CG2 THR A 106     -96.306  29.827 -41.963  1.00  0.00           C  
ATOM   1590  OXT THR A 106     -92.606  30.934 -40.791  1.00  0.00           O  
ATOM   1591  H   THR A 106     -94.467  29.245 -38.240  1.00  0.00           H  
ATOM   1592  HA  THR A 106     -94.005  28.818 -41.115  1.00  0.00           H  
ATOM   1593  HB  THR A 106     -96.337  30.307 -39.888  1.00  0.00           H  
ATOM   1594  HG1 THR A 106     -96.049  27.554 -40.555  1.00  0.00           H  
ATOM   1595 HG21 THR A 106     -95.965  29.021 -42.596  1.00  0.00           H  
ATOM   1596 HG22 THR A 106     -95.832  30.749 -42.267  1.00  0.00           H  
ATOM   1597 HG23 THR A 106     -97.379  29.926 -42.054  1.00  0.00           H  
TER    1598      THR A 106                                                      
END
MOLECULE T0514.pdb
ATOM   7695  N   SER     1     -73.106  18.033 -40.322  1.00 86.00           N  
ATOM   7696  CA  SER     1     -73.011  18.711 -38.995  1.00 85.50           C  
ATOM   7697  C   SER     1     -74.354  19.367 -38.664  1.00 79.83           C  
ATOM   7698  O   SER     1     -74.616  20.512 -39.038  1.00 86.46           O  
ATOM   7699  CB  SER     1     -71.867  19.728 -38.999  1.00 86.33           C  
ATOM   7700  OG  SER     1     -71.212  19.767 -37.742  1.00 88.81           O  
ATOM   7701  N   SER     2     -75.186  18.622 -37.940  1.00 70.86           N  
ATOM   7702  CA  SER     2     -76.629  18.868 -37.847  1.00 70.05           C  
ATOM   7703  C   SER     2     -77.049  19.675 -36.613  1.00 66.08           C  
ATOM   7704  O   SER     2     -77.518  19.116 -35.621  1.00 67.53           O  
ATOM   7705  CB  SER     2     -77.364  17.524 -37.883  1.00 72.15           C  
ATOM   7706  OG  SER     2     -78.761  17.686 -37.715  1.00 76.65           O  
ATOM   7707  N   LEU     3     -76.905  20.994 -36.702  1.00 57.90           N  
ATOM   7708  CA  LEU     3     -77.150  21.891 -35.579  1.00 49.32           C  
ATOM   7709  C   LEU     3     -78.641  22.135 -35.344  1.00 45.20           C  
ATOM   7710  O   LEU     3     -79.395  22.383 -36.285  1.00 46.29           O  
ATOM   7711  CB  LEU     3     -76.427  23.218 -35.823  1.00 50.89           C  
ATOM   7712  CG  LEU     3     -75.688  23.894 -34.673  1.00 48.11           C  
ATOM   7713  CD1 LEU     3     -74.641  22.973 -34.089  1.00 51.21           C  
ATOM   7714  CD2 LEU     3     -75.040  25.155 -35.184  1.00 47.04           C  
ATOM   7715  N   THR     4     -79.051  22.068 -34.078  1.00 40.66           N  
ATOM   7716  CA  THR     4     -80.445  22.293 -33.688  1.00 38.62           C  
ATOM   7717  C   THR     4     -80.772  23.788 -33.633  1.00 40.67           C  
ATOM   7718  O   THR     4     -80.086  24.559 -32.951  1.00 39.89           O  
ATOM   7719  CB  THR     4     -80.760  21.636 -32.319  1.00 36.41           C  
ATOM   7720  OG1 THR     4     -80.313  20.276 -32.327  1.00 37.81           O  
ATOM   7721  CG2 THR     4     -82.255  21.661 -32.026  1.00 30.45           C  
ATOM   7722  N   GLU     5     -81.811  24.184 -34.370  1.00 39.96           N  
ATOM   7723  CA  GLU     5     -82.345  25.546 -34.329  1.00 39.54           C  
ATOM   7724  C   GLU     5     -83.553  25.564 -33.417  1.00 37.36           C  
ATOM   7725  O   GLU     5     -84.281  24.581 -33.340  1.00 38.64           O  
ATOM   7726  CB  GLU     5     -82.768  26.019 -35.722  1.00 39.72           C  
ATOM   7727  CG  GLU     5     -81.673  25.972 -36.765  1.00 42.97           C  
ATOM   7728  CD  GLU     5     -82.038  26.679 -38.058  1.00 52.29           C  
ATOM   7729  OE1 GLU     5     -81.494  26.288 -39.114  1.00 59.87           O  
ATOM   7730  OE2 GLU     5     -82.861  27.622 -38.023  1.00 58.70           O  
ATOM   7731  N   THR     6     -83.771  26.685 -32.739  1.00 39.74           N  
ATOM   7732  CA  THR     6     -84.865  26.804 -31.783  1.00 40.46           C  
ATOM   7733  C   THR     6     -85.754  27.995 -32.125  1.00 40.75           C  
ATOM   7734  O   THR     6     -85.275  29.127 -32.261  1.00 42.54           O  
ATOM   7735  CB  THR     6     -84.337  26.935 -30.323  1.00 42.91           C  
ATOM   7736  OG1 THR     6     -83.371  25.908 -30.059  1.00 46.85           O  
ATOM   7737  CG2 THR     6     -85.477  26.818 -29.319  1.00 44.55           C  
ATOM   7738  N   TYR     7     -87.047  27.721 -32.277  1.00 39.16           N  
ATOM   7739  CA  TYR     7     -88.045  28.754 -32.525  1.00 35.75           C  
ATOM   7740  C   TYR     7     -89.166  28.573 -31.529  1.00 35.97           C  
ATOM   7741  O   TYR     7     -90.017  27.699 -31.698  1.00 39.75           O  
ATOM   7742  CB  TYR     7     -88.560  28.689 -33.969  1.00 38.99           C  
ATOM   7743  CG  TYR     7     -87.478  28.999 -34.969  1.00 40.54           C  
ATOM   7744  CD1 TYR     7     -87.179  30.317 -35.305  1.00 37.88           C  
ATOM   7745  CD2 TYR     7     -86.726  27.978 -35.553  1.00 37.35           C  
ATOM   7746  CE1 TYR     7     -86.166  30.614 -36.212  1.00 41.16           C  
ATOM   7747  CE2 TYR     7     -85.712  28.261 -36.456  1.00 37.99           C  
ATOM   7748  CZ  TYR     7     -85.437  29.579 -36.783  1.00 40.84           C  
ATOM   7749  OH  TYR     7     -84.431  29.867 -37.675  1.00 49.82           O  
ATOM   7750  N   GLY     8     -89.140  29.398 -30.483  1.00 35.98           N  
ATOM   7751  CA  GLY     8     -90.046  29.261 -29.348  1.00 34.78           C  
ATOM   7752  C   GLY     8     -89.837  27.928 -28.661  1.00 37.11           C  
ATOM   7753  O   GLY     8     -88.768  27.666 -28.097  1.00 39.11           O  
ATOM   7754  N   LEU     9     -90.858  27.081 -28.742  1.00 35.37           N  
ATOM   7755  CA  LEU     9     -90.831  25.755 -28.144  1.00 32.71           C  
ATOM   7756  C   LEU     9     -90.501  24.674 -29.174  1.00 33.56           C  
ATOM   7757  O   LEU     9     -90.358  23.498 -28.825  1.00 34.51           O  
ATOM   7758  CB  LEU     9     -92.174  25.452 -27.473  1.00 30.66           C  
ATOM   7759  CG  LEU     9     -92.546  26.278 -26.243  1.00 31.48           C  
ATOM   7760  CD1 LEU     9     -93.946  25.918 -25.798  1.00 26.00           C  
ATOM   7761  CD2 LEU     9     -91.550  26.088 -25.099  1.00 28.69           C  
ATOM   7762  N   TRP    10     -90.363  25.084 -30.436  1.00 35.01           N  
ATOM   7763  CA  TRP    10     -90.121  24.154 -31.539  1.00 33.36           C  
ATOM   7764  C   TRP    10     -88.660  24.091 -31.974  1.00 35.75           C  
ATOM   7765  O   TRP    10     -87.944  25.097 -31.949  1.00 33.95           O  
ATOM   7766  CB  TRP    10     -91.035  24.480 -32.721  1.00 31.82           C  
ATOM   7767  CG  TRP    10     -92.432  23.993 -32.495  1.00 30.68           C  
ATOM   7768  CD1 TRP    10     -93.389  24.573 -31.708  1.00 27.17           C  
ATOM   7769  CD2 TRP    10     -93.025  22.808 -33.041  1.00 29.19           C  
ATOM   7770  NE1 TRP    10     -94.545  23.827 -31.737  1.00 30.50           N  
ATOM   7771  CE2 TRP    10     -94.350  22.738 -32.549  1.00 31.52           C  
ATOM   7772  CE3 TRP    10     -92.566  21.798 -33.901  1.00 28.90           C  
ATOM   7773  CZ2 TRP    10     -95.224  21.695 -32.888  1.00 32.76           C  
ATOM   7774  CZ3 TRP    10     -93.437  20.759 -34.242  1.00 30.01           C  
ATOM   7775  CH2 TRP    10     -94.749  20.716 -33.733  1.00 32.69           C  
ATOM   7776  N   SER    11     -88.225  22.890 -32.351  1.00 35.54           N  
ATOM   7777  CA  SER    11     -86.858  22.665 -32.800  1.00 34.01           C  
ATOM   7778  C   SER    11     -86.809  22.282 -34.273  1.00 34.91           C  
ATOM   7779  O   SER    11     -87.770  21.719 -34.807  1.00 32.84           O  
ATOM   7780  CB  SER    11     -86.184  21.585 -31.957  1.00 34.82           C  
ATOM   7781  OG  SER    11     -86.153  21.951 -30.592  1.00 40.26           O  
ATOM   7782  N   ILE    12     -85.691  22.609 -34.921  1.00 37.39           N  
ATOM   7783  CA  ILE    12     -85.430  22.225 -36.311  1.00 38.04           C  
ATOM   7784  C   ILE    12     -84.071  21.530 -36.443  1.00 37.76           C  
ATOM   7785  O   ILE    12     -83.051  22.050 -35.989  1.00 38.44           O  
ATOM   7786  CB  ILE    12     -85.517  23.448 -37.280  1.00 39.96           C  
ATOM   7787  CG1 ILE    12     -86.963  23.902 -37.431  1.00 38.91           C  
ATOM   7788  CG2 ILE    12     -84.949  23.115 -38.674  1.00 37.07           C  
ATOM   7789  CD1 ILE    12     -87.101  25.226 -38.088  1.00 41.12           C  
ATOM   7790  N   ASN    13     -84.079  20.346 -37.047  1.00 40.63           N  
ATOM   7791  CA  ASN    13     -82.853  19.655 -37.434  1.00 42.33           C  
ATOM   7792  C   ASN    13     -82.896  19.247 -38.904  1.00 45.34           C  
ATOM   7793  O   ASN    13     -83.948  18.864 -39.422  1.00 47.47           O  
ATOM   7794  CB  ASN    13     -82.620  18.432 -36.552  1.00 40.33           C  
ATOM   7795  CG  ASN    13     -82.231  18.804 -35.141  1.00 41.17           C  
ATOM   7796  OD1 ASN    13     -83.081  18.895 -34.255  1.00 42.99           O  
ATOM   7797  ND2 ASN    13     -80.942  19.039 -34.925  1.00 36.69           N  
ATOM   7798  N   CYS    14     -81.753  19.358 -39.573  1.00 51.92           N  
ATOM   7799  CA  CYS    14     -81.608  18.893 -40.950  1.00 58.30           C  
ATOM   7800  C   CYS    14     -80.651  17.708 -40.975  1.00 63.16           C  
ATOM   7801  O   CYS    14     -79.557  17.774 -40.421  1.00 65.08           O  
ATOM   7802  CB  CYS    14     -81.105  20.020 -41.853  1.00 57.24           C  
ATOM   7803  SG  CYS    14     -82.207  21.455 -41.929  1.00 61.75           S  
ATOM   7804  N   GLY    15     -81.073  16.612 -41.593  1.00 71.49           N  
ATOM   7805  CA  GLY    15     -80.278  15.392 -41.572  1.00 79.04           C  
ATOM   7806  C   GLY    15     -80.256  14.637 -42.882  1.00 83.68           C  
ATOM   7807  O   GLY    15     -81.005  14.953 -43.807  1.00 81.70           O  
ATOM   7808  N   ILE    16     -79.385  13.635 -42.951  1.00 89.29           N  
ATOM   7809  CA  ILE    16     -79.296  12.768 -44.116  1.00 95.07           C  
ATOM   7810  C   ILE    16     -79.867  11.387 -43.785  1.00 97.80           C  
ATOM   7811  O   ILE    16     -79.246  10.598 -43.067  1.00101.91           O  
ATOM   7812  CB  ILE    16     -77.840  12.662 -44.659  1.00 95.61           C  
ATOM   7813  CG1 ILE    16     -77.255  14.058 -44.917  1.00 95.45           C  
ATOM   7814  CG2 ILE    16     -77.797  11.817 -45.936  1.00 97.89           C  
ATOM   7815  CD1 ILE    16     -75.734  14.100 -44.990  1.00 96.35           C  
ATOM   7816  N   GLN    17     -81.070  11.121 -44.289  1.00 99.86           N  
ATOM   7817  CA  GLN    17     -81.656   9.781 -44.248  1.00103.94           C  
ATOM   7818  C   GLN    17     -81.935   9.297 -45.671  1.00107.30           C  
ATOM   7819  O   GLN    17     -82.322  10.090 -46.537  1.00109.45           O  
ATOM   7820  CB  GLN    17     -82.913   9.730 -43.366  1.00103.97           C  
ATOM   7821  CG  GLN    17     -84.047  10.667 -43.776  1.00103.34           C  
ATOM   7822  CD  GLN    17     -85.227  10.643 -42.816  1.00103.34           C  
ATOM   7823  OE1 GLN    17     -86.325  11.077 -43.163  1.00101.58           O  
ATOM   7824  NE2 GLN    17     -85.007  10.138 -41.605  1.00103.62           N  
ATOM   7825  N   GLU    18     -81.735   7.993 -45.887  1.00109.68           N  
ATOM   7826  CA  GLU    18     -81.668   7.343 -47.222  1.00108.94           C  
ATOM   7827  C   GLU    18     -80.948   8.127 -48.341  1.00104.86           C  
ATOM   7828  O   GLU    18     -81.362   8.105 -49.506  1.00105.18           O  
ATOM   7829  CB  GLU    18     -83.026   6.751 -47.681  1.00110.74           C  
ATOM   7830  CG  GLU    18     -84.210   7.717 -47.825  1.00113.55           C  
ATOM   7831  CD  GLU    18     -85.104   7.762 -46.593  1.00119.58           C  
ATOM   7832  OE1 GLU    18     -84.621   7.489 -45.471  1.00119.83           O  
ATOM   7833  OE2 GLU    18     -86.303   8.075 -46.749  1.00123.72           O  
ATOM   7834  N   GLY    19     -79.866   8.811 -47.965  1.00 99.61           N  
ATOM   7835  CA  GLY    19     -79.063   9.610 -48.891  1.00 93.47           C  
ATOM   7836  C   GLY    19     -79.633  10.977 -49.231  1.00 89.20           C  
ATOM   7837  O   GLY    19     -79.123  11.659 -50.126  1.00 84.86           O  
ATOM   7838  N   LYS    20     -80.686  11.380 -48.519  1.00 87.80           N  
ATOM   7839  CA  LYS    20     -81.356  12.659 -48.774  1.00 85.31           C  
ATOM   7840  C   LYS    20     -81.306  13.652 -47.624  1.00 84.60           C  
ATOM   7841  O   LYS    20     -81.594  13.304 -46.478  1.00 83.32           O  
ATOM   7842  CB  LYS    20     -82.820  12.453 -49.188  1.00 82.26           C  
ATOM   7843  CG  LYS    20     -83.153  12.836 -50.629  1.00 80.18           C  
ATOM   7844  CD  LYS    20     -82.756  14.271 -50.990  1.00 79.88           C  
ATOM   7845  CE  LYS    20     -81.530  14.316 -51.907  1.00 71.59           C  
ATOM   7846  NZ  LYS    20     -81.177  15.696 -52.331  1.00 69.67           N  
ATOM   7847  N   LYS    21     -80.950  14.892 -47.957  1.00 84.11           N  
ATOM   7848  CA  LYS    21     -81.076  16.017 -47.038  1.00 83.87           C  
ATOM   7849  C   LYS    21     -82.556  16.337 -46.825  1.00 81.07           C  
ATOM   7850  O   LYS    21     -83.272  16.685 -47.769  1.00 86.07           O  
ATOM   7851  CB  LYS    21     -80.317  17.244 -47.569  1.00 87.63           C  
ATOM   7852  CG  LYS    21     -80.607  18.573 -46.838  1.00 91.25           C  
ATOM   7853  CD  LYS    21     -80.062  18.608 -45.407  1.00 91.27           C  
ATOM   7854  CE  LYS    21     -78.579  18.952 -45.370  1.00 92.40           C  
ATOM   7855  NZ  LYS    21     -78.069  19.024 -43.973  1.00 94.73           N  
ATOM   7856  N   VAL    22     -83.006  16.185 -45.583  1.00 75.46           N  
ATOM   7857  CA  VAL    22     -84.368  16.538 -45.195  1.00 66.54           C  
ATOM   7858  C   VAL    22     -84.341  17.350 -43.894  1.00 60.14           C  
ATOM   7859  O   VAL    22     -83.654  16.991 -42.932  1.00 50.69           O  
ATOM   7860  CB  VAL    22     -85.316  15.282 -45.129  1.00 69.02           C  
ATOM   7861  CG1 VAL    22     -84.927  14.316 -44.011  1.00 62.21           C  
ATOM   7862  CG2 VAL    22     -86.785  15.694 -45.009  1.00 75.37           C  
ATOM   7863  N   CYS    23     -85.051  18.474 -43.893  1.00 57.05           N  
ATOM   7864  CA  CYS    23     -85.160  19.292 -42.693  1.00 52.37           C  
ATOM   7865  C   CYS    23     -86.501  19.053 -42.026  1.00 48.74           C  
ATOM   7866  O   CYS    23     -87.550  19.124 -42.672  1.00 48.88           O  
ATOM   7867  CB  CYS    23     -84.960  20.774 -43.012  1.00 53.59           C  
ATOM   7868  SG  CYS    23     -83.302  21.159 -43.621  1.00 61.48           S  
ATOM   7869  N   PHE    24     -86.462  18.751 -40.734  1.00 47.22           N  
ATOM   7870  CA  PHE    24     -87.689  18.483 -39.991  1.00 45.34           C  
ATOM   7871  C   PHE    24     -87.883  19.369 -38.767  1.00 40.99           C  
ATOM   7872  O   PHE    24     -86.934  19.890 -38.181  1.00 37.69           O  
ATOM   7873  CB  PHE    24     -87.866  16.983 -39.669  1.00 47.46           C  
ATOM   7874  CG  PHE    24     -86.757  16.385 -38.850  1.00 53.18           C  
ATOM   7875  CD1 PHE    24     -86.894  16.249 -37.469  1.00 57.41           C  
ATOM   7876  CD2 PHE    24     -85.590  15.920 -39.458  1.00 56.07           C  
ATOM   7877  CE1 PHE    24     -85.877  15.680 -36.699  1.00 57.82           C  
ATOM   7878  CE2 PHE    24     -84.563  15.356 -38.702  1.00 61.34           C  
ATOM   7879  CZ  PHE    24     -84.707  15.235 -37.317  1.00 59.01           C  
ATOM   7880  N   MET    25     -89.150  19.526 -38.415  1.00 40.89           N  
ATOM   7881  CA  MET    25     -89.627  20.457 -37.417  1.00 37.14           C  
ATOM   7882  C   MET    25     -90.204  19.579 -36.318  1.00 36.34           C  
ATOM   7883  O   MET    25     -91.072  18.749 -36.595  1.00 35.61           O  
ATOM   7884  CB  MET    25     -90.745  21.248 -38.069  1.00 40.66           C  
ATOM   7885  CG  MET    25     -91.015  22.605 -37.554  1.00 41.74           C  
ATOM   7886  SD  MET    25     -92.447  23.209 -38.467  1.00 33.57           S  
ATOM   7887  CE  MET    25     -93.338  23.885 -37.087  1.00 29.70           C  
ATOM   7888  N   HIS    26     -89.737  19.742 -35.080  1.00 36.22           N  
ATOM   7889  CA  HIS    26     -90.155  18.821 -34.012  1.00 34.22           C  
ATOM   7890  C   HIS    26     -90.321  19.388 -32.595  1.00 34.68           C  
ATOM   7891  O   HIS    26     -89.727  20.411 -32.225  1.00 32.90           O  
ATOM   7892  CB  HIS    26     -89.268  17.565 -33.993  1.00 31.23           C  
ATOM   7893  CG  HIS    26     -87.822  17.849 -33.742  1.00 33.71           C  
ATOM   7894  ND1 HIS    26     -87.235  17.684 -32.506  1.00 37.09           N  
ATOM   7895  CD2 HIS    26     -86.845  18.296 -34.566  1.00 32.07           C  
ATOM   7896  CE1 HIS    26     -85.959  18.012 -32.580  1.00 36.78           C  
ATOM   7897  NE2 HIS    26     -85.697  18.388 -33.819  1.00 36.25           N  
ATOM   7898  N   ARG    27     -91.147  18.696 -31.815  1.00 34.90           N  
ATOM   7899  CA  ARG    27     -91.499  19.109 -30.464  1.00 35.60           C  
ATOM   7900  C   ARG    27     -91.845  17.880 -29.620  1.00 37.37           C  
ATOM   7901  O   ARG    27     -92.615  17.022 -30.055  1.00 37.78           O  
ATOM   7902  CB  ARG    27     -92.693  20.072 -30.515  1.00 34.68           C  
ATOM   7903  CG  ARG    27     -93.389  20.316 -29.183  1.00 32.93           C  
ATOM   7904  CD  ARG    27     -92.882  21.562 -28.499  1.00 34.97           C  
ATOM   7905  NE  ARG    27     -93.150  21.549 -27.062  1.00 35.70           N  
ATOM   7906  CZ  ARG    27     -92.237  21.777 -26.118  1.00 35.79           C  
ATOM   7907  NH1 ARG    27     -90.983  22.061 -26.446  1.00 35.35           N  
ATOM   7908  NH2 ARG    27     -92.584  21.734 -24.840  1.00 32.78           N  
ATOM   7909  N   GLN    28     -91.264  17.802 -28.424  1.00 39.12           N  
ATOM   7910  CA  GLN    28     -91.625  16.785 -27.438  1.00 39.03           C  
ATOM   7911  C   GLN    28     -92.318  17.425 -26.248  1.00 35.59           C  
ATOM   7912  O   GLN    28     -91.953  18.522 -25.819  1.00 36.00           O  
ATOM   7913  CB  GLN    28     -90.382  16.060 -26.928  1.00 37.97           C  
ATOM   7914  CG  GLN    28     -89.815  15.019 -27.865  1.00 50.79           C  
ATOM   7915  CD  GLN    28     -88.584  14.336 -27.295  1.00 51.82           C  
ATOM   7916  OE1 GLN    28     -87.931  14.854 -26.380  1.00 48.50           O  
ATOM   7917  NE2 GLN    28     -88.258  13.163 -27.836  1.00 56.54           N  
ATOM   7918  N   GLU    29     -93.310  16.727 -25.706  1.00 34.54           N  
ATOM   7919  CA  GLU    29     -93.924  17.138 -24.452  1.00 36.76           C  
ATOM   7920  C   GLU    29     -93.641  16.119 -23.352  1.00 37.73           C  
ATOM   7921  O   GLU    29     -93.732  14.906 -23.576  1.00 36.19           O  
ATOM   7922  CB  GLU    29     -95.432  17.367 -24.605  1.00 38.13           C  
ATOM   7923  CG  GLU    29     -95.845  18.263 -25.776  1.00 38.36           C  
ATOM   7924  CD  GLU    29     -95.494  19.736 -25.598  1.00 42.52           C  
ATOM   7925  OE1 GLU    29     -95.164  20.170 -24.475  1.00 47.87           O  
ATOM   7926  OE2 GLU    29     -95.559  20.472 -26.602  1.00 44.00           O  
ATOM   7927  N   VAL    30     -93.284  16.629 -22.172  1.00 39.11           N  
ATOM   7928  CA  VAL    30     -92.918  15.794 -21.024  1.00 38.76           C  
ATOM   7929  C   VAL    30     -93.876  15.994 -19.843  1.00 40.55           C  
ATOM   7930  O   VAL    30     -94.572  17.009 -19.767  1.00 40.75           O  
ATOM   7931  CB  VAL    30     -91.444  16.041 -20.568  1.00 36.91           C  
ATOM   7932  CG1 VAL    30     -90.460  15.709 -21.687  1.00 33.10           C  
ATOM   7933  CG2 VAL    30     -91.237  17.483 -20.087  1.00 35.14           C  
ATOM   7934  N   ASN    31     -93.917  15.016 -18.939  1.00 43.33           N  
ATOM   7935  CA  ASN    31     -94.651  15.160 -17.681  1.00 43.25           C  
ATOM   7936  C   ASN    31     -93.779  15.766 -16.584  1.00 47.22           C  
ATOM   7937  O   ASN    31     -92.674  16.237 -16.865  1.00 47.32           O  
ATOM   7938  CB  ASN    31     -95.294  13.832 -17.233  1.00 43.59           C  
ATOM   7939  CG  ASN    31     -94.288  12.688 -17.073  1.00 43.57           C  
ATOM   7940  OD1 ASN    31     -93.078  12.894 -16.971  1.00 49.89           O  
ATOM   7941  ND2 ASN    31     -94.803  11.466 -17.049  1.00 39.28           N  
ATOM   7942  N   ASP    32     -94.274  15.749 -15.343  1.00 52.63           N  
ATOM   7943  CA  ASP    32     -93.516  16.253 -14.183  1.00 58.15           C  
ATOM   7944  C   ASP    32     -92.281  15.415 -13.813  1.00 58.15           C  
ATOM   7945  O   ASP    32     -91.374  15.908 -13.142  1.00 58.05           O  
ATOM   7946  CB  ASP    32     -94.427  16.458 -12.960  1.00 63.77           C  
ATOM   7947  CG  ASP    32     -95.443  15.332 -12.767  1.00 76.42           C  
ATOM   7948  OD1 ASP    32     -95.134  14.158 -13.075  1.00 83.20           O  
ATOM   7949  OD2 ASP    32     -96.559  15.631 -12.288  1.00 85.45           O  
ATOM   7950  N   GLN    33     -92.253  14.159 -14.264  1.00 60.15           N  
ATOM   7951  CA  GLN    33     -91.095  13.270 -14.084  1.00 60.41           C  
ATOM   7952  C   GLN    33     -90.101  13.388 -15.240  1.00 60.28           C  
ATOM   7953  O   GLN    33     -89.128  12.631 -15.309  1.00 63.82           O  
ATOM   7954  CB  GLN    33     -91.542  11.809 -13.928  1.00 58.58           C  
ATOM   7955  CG  GLN    33     -92.418  11.530 -12.707  1.00 67.98           C  
ATOM   7956  CD  GLN    33     -91.759  11.932 -11.396  1.00 76.84           C  
ATOM   7957  OE1 GLN    33     -92.246  12.817 -10.691  1.00 77.72           O  
ATOM   7958  NE2 GLN    33     -90.641  11.290 -11.069  1.00 78.90           N  
ATOM   7959  N   ASN    34     -90.371  14.333 -16.142  1.00 56.72           N  
ATOM   7960  CA  ASN    34     -89.528  14.644 -17.307  1.00 57.64           C  
ATOM   7961  C   ASN    34     -89.388  13.517 -18.343  1.00 53.14           C  
ATOM   7962  O   ASN    34     -88.394  13.450 -19.064  1.00 54.45           O  
ATOM   7963  CB  ASN    34     -88.152  15.190 -16.875  1.00 63.11           C  
ATOM   7964  CG  ASN    34     -87.574  16.183 -17.871  1.00 73.48           C  
ATOM   7965  OD1 ASN    34     -88.079  17.298 -18.021  1.00 82.99           O  
ATOM   7966  ND2 ASN    34     -86.505  15.782 -18.552  1.00 71.05           N  
ATOM   7967  N   ARG    35     -90.384  12.638 -18.426  1.00 50.00           N  
ATOM   7968  CA  ARG    35     -90.399  11.638 -19.493  1.00 52.19           C  
ATOM   7969  C   ARG    35     -91.392  12.000 -20.607  1.00 49.40           C  
ATOM   7970  O   ARG    35     -92.459  12.566 -20.351  1.00 46.47           O  
ATOM   7971  CB  ARG    35     -90.621  10.214 -18.955  1.00 54.38           C  
ATOM   7972  CG  ARG    35     -92.008   9.913 -18.435  1.00 63.48           C  
ATOM   7973  CD  ARG    35     -92.314   8.431 -18.562  1.00 72.96           C  
ATOM   7974  NE  ARG    35     -93.747   8.174 -18.460  1.00 81.89           N  
ATOM   7975  CZ  ARG    35     -94.569   7.959 -19.487  1.00 85.10           C  
ATOM   7976  NH1 ARG    35     -94.122   7.945 -20.737  1.00 84.71           N  
ATOM   7977  NH2 ARG    35     -95.855   7.748 -19.252  1.00 85.00           N  
ATOM   7978  N   VAL    36     -91.016  11.665 -21.839  1.00 46.28           N  
ATOM   7979  CA  VAL    36     -91.781  12.021 -23.036  1.00 43.64           C  
ATOM   7980  C   VAL    36     -93.111  11.271 -23.099  1.00 43.57           C  
ATOM   7981  O   VAL    36     -93.145  10.043 -23.052  1.00 45.58           O  
ATOM   7982  CB  VAL    36     -90.946  11.794 -24.329  1.00 43.77           C  
ATOM   7983  CG1 VAL    36     -91.721  12.214 -25.571  1.00 40.76           C  
ATOM   7984  CG2 VAL    36     -89.632  12.564 -24.252  1.00 43.73           C  
ATOM   7985  N   VAL    37     -94.199  12.032 -23.190  1.00 42.93           N  
ATOM   7986  CA  VAL    37     -95.549  11.475 -23.274  1.00 42.32           C  
ATOM   7987  C   VAL    37     -96.081  11.586 -24.705  1.00 43.22           C  
ATOM   7988  O   VAL    37     -96.640  10.634 -25.249  1.00 45.11           O  
ATOM   7989  CB  VAL    37     -96.511  12.177 -22.282  1.00 41.41           C  
ATOM   7990  CG1 VAL    37     -97.901  11.548 -22.323  1.00 44.11           C  
ATOM   7991  CG2 VAL    37     -95.952  12.127 -20.860  1.00 41.25           C  
ATOM   7992  N   VAL    38     -95.891  12.752 -25.312  1.00 42.01           N  
ATOM   7993  CA  VAL    38     -96.311  12.978 -26.691  1.00 44.83           C  
ATOM   7994  C   VAL    38     -95.192  13.689 -27.472  1.00 39.42           C  
ATOM   7995  O   VAL    38     -94.454  14.503 -26.911  1.00 42.68           O  
ATOM   7996  CB  VAL    38     -97.733  13.666 -26.765  1.00 47.06           C  
ATOM   7997  CG1 VAL    38     -97.745  15.019 -26.108  1.00 49.87           C  
ATOM   7998  CG2 VAL    38     -98.250  13.765 -28.184  1.00 54.30           C  
ATOM   7999  N   ALA    39     -95.029  13.324 -28.742  1.00 39.00           N  
ATOM   8000  CA  ALA    39     -94.053  13.963 -29.619  1.00 36.49           C  
ATOM   8001  C   ALA    39     -94.664  14.211 -30.995  1.00 40.04           C  
ATOM   8002  O   ALA    39     -95.598  13.516 -31.405  1.00 41.01           O  
ATOM   8003  CB  ALA    39     -92.787  13.106 -29.733  1.00 33.14           C  
ATOM   8004  N   MET    40     -94.135  15.209 -31.698  1.00 39.36           N  
ATOM   8005  CA  MET    40     -94.594  15.548 -33.040  1.00 37.36           C  
ATOM   8006  C   MET    40     -93.396  15.917 -33.903  1.00 36.61           C  
ATOM   8007  O   MET    40     -92.546  16.694 -33.484  1.00 38.65           O  
ATOM   8008  CB  MET    40     -95.604  16.701 -32.982  1.00 35.72           C  
ATOM   8009  CG  MET    40     -96.020  17.272 -34.336  1.00 44.41           C  
ATOM   8010  SD  MET    40     -97.527  18.253 -34.261  1.00 43.34           S  
ATOM   8011  CE  MET    40     -98.734  16.944 -34.198  1.00 57.38           C  
ATOM   8012  N   SER    41     -93.328  15.329 -35.095  1.00 38.59           N  
ATOM   8013  CA  SER    41     -92.282  15.642 -36.068  1.00 39.90           C  
ATOM   8014  C   SER    41     -92.924  15.923 -37.423  1.00 42.42           C  
ATOM   8015  O   SER    41     -93.814  15.194 -37.858  1.00 44.66           O  
ATOM   8016  CB  SER    41     -91.275  14.497 -36.171  1.00 38.92           C  
ATOM   8017  OG  SER    41     -90.050  14.948 -36.720  1.00 45.02           O  
ATOM   8018  N   VAL    42     -92.465  16.980 -38.084  1.00 43.27           N  
ATOM   8019  CA  VAL    42     -93.147  17.520 -39.258  1.00 43.16           C  
ATOM   8020  C   VAL    42     -92.174  17.983 -40.359  1.00 42.78           C  
ATOM   8021  O   VAL    42     -91.132  18.582 -40.069  1.00 41.02           O  
ATOM   8022  CB  VAL    42     -94.163  18.624 -38.813  1.00 45.42           C  
ATOM   8023  CG1 VAL    42     -94.091  19.877 -39.667  1.00 47.71           C  
ATOM   8024  CG2 VAL    42     -95.576  18.055 -38.765  1.00 50.61           C  
ATOM   8025  N   VAL    43     -92.503  17.669 -41.615  1.00 44.23           N  
ATOM   8026  CA  VAL    43     -91.737  18.158 -42.773  1.00 45.03           C  
ATOM   8027  C   VAL    43     -92.593  19.010 -43.711  1.00 47.46           C  
ATOM   8028  O   VAL    43     -93.827  18.887 -43.743  1.00 45.91           O  
ATOM   8029  CB  VAL    43     -91.058  17.017 -43.599  1.00 45.82           C  
ATOM   8030  CG1 VAL    43     -89.978  16.311 -42.785  1.00 47.96           C  
ATOM   8031  CG2 VAL    43     -92.085  16.022 -44.131  1.00 44.05           C  
ATOM   8032  N   LEU    44     -91.923  19.882 -44.461  1.00 48.25           N  
ATOM   8033  CA  LEU    44     -92.552  20.638 -45.533  1.00 49.20           C  
ATOM   8034  C   LEU    44     -92.233  19.926 -46.840  1.00 50.17           C  
ATOM   8035  O   LEU    44     -91.069  19.834 -47.241  1.00 48.59           O  
ATOM   8036  CB  LEU    44     -92.007  22.069 -45.574  1.00 50.42           C  
ATOM   8037  CG  LEU    44     -92.858  23.273 -46.005  1.00 51.57           C  
ATOM   8038  CD1 LEU    44     -92.022  24.181 -46.886  1.00 48.17           C  
ATOM   8039  CD2 LEU    44     -94.179  22.925 -46.686  1.00 53.02           C  
ATOM   8040  N   ASN    45     -93.269  19.405 -47.490  1.00 53.56           N  
ATOM   8041  CA  ASN    45     -93.105  18.705 -48.759  1.00 60.61           C  
ATOM   8042  C   ASN    45     -92.953  19.682 -49.926  1.00 61.95           C  
ATOM   8043  O   ASN    45     -93.225  20.880 -49.780  1.00 62.94           O  
ATOM   8044  CB  ASN    45     -94.268  17.736 -48.991  1.00 61.44           C  
ATOM   8045  CG  ASN    45     -94.318  16.625 -47.955  1.00 61.88           C  
ATOM   8046  OD1 ASN    45     -93.560  15.656 -48.027  1.00 64.24           O  
ATOM   8047  ND2 ASN    45     -95.216  16.760 -46.986  1.00 54.93           N  
ATOM   8048  N   ALA    46     -92.519  19.160 -51.073  1.00 67.68           N  
ATOM   8049  CA  ALA    46     -92.230  19.965 -52.270  1.00 72.47           C  
ATOM   8050  C   ALA    46     -93.438  20.734 -52.823  1.00 71.74           C  
ATOM   8051  O   ALA    46     -93.283  21.830 -53.370  1.00 64.68           O  
ATOM   8052  CB  ALA    46     -91.609  19.090 -53.357  1.00 71.52           C  
ATOM   8053  N   ASP    47     -94.630  20.158 -52.664  1.00 76.25           N  
ATOM   8054  CA  ASP    47     -95.876  20.788 -53.116  1.00 81.64           C  
ATOM   8055  C   ASP    47     -96.438  21.812 -52.121  1.00 80.37           C  
ATOM   8056  O   ASP    47     -97.388  22.535 -52.433  1.00 83.42           O  
ATOM   8057  CB  ASP    47     -96.933  19.726 -53.454  1.00 83.20           C  
ATOM   8058  CG  ASP    47     -97.331  18.887 -52.253  1.00 89.84           C  
ATOM   8059  OD1 ASP    47     -96.480  18.135 -51.726  1.00 88.83           O  
ATOM   8060  OD2 ASP    47     -98.509  18.972 -51.847  1.00 94.11           O  
ATOM   8061  N   GLY    48     -95.851  21.869 -50.928  1.00 78.39           N  
ATOM   8062  CA  GLY    48     -96.258  22.836 -49.913  1.00 75.66           C  
ATOM   8063  C   GLY    48     -97.114  22.258 -48.802  1.00 74.27           C  
ATOM   8064  O   GLY    48     -97.499  22.977 -47.874  1.00 73.74           O  
ATOM   8065  N   VAL    49     -97.419  20.963 -48.893  1.00 70.95           N  
ATOM   8066  CA  VAL    49     -98.200  20.284 -47.858  1.00 66.91           C  
ATOM   8067  C   VAL    49     -97.320  19.964 -46.637  1.00 61.43           C  
ATOM   8068  O   VAL    49     -96.161  19.555 -46.773  1.00 59.04           O  
ATOM   8069  CB  VAL    49     -98.986  19.037 -48.419  1.00 70.53           C  
ATOM   8070  CG1 VAL    49     -98.077  17.831 -48.676  1.00 70.34           C  
ATOM   8071  CG2 VAL    49    -100.136  18.653 -47.503  1.00 72.21           C  
ATOM   8072  N   VAL    50     -97.867  20.205 -45.449  1.00 55.18           N  
ATOM   8073  CA  VAL    50     -97.165  19.942 -44.198  1.00 51.62           C  
ATOM   8074  C   VAL    50     -97.600  18.579 -43.655  1.00 50.09           C  
ATOM   8075  O   VAL    50     -98.779  18.360 -43.366  1.00 49.43           O  
ATOM   8076  CB  VAL    50     -97.396  21.082 -43.168  1.00 54.49           C  
ATOM   8077  CG1 VAL    50     -96.922  20.691 -41.780  1.00 51.97           C  
ATOM   8078  CG2 VAL    50     -96.696  22.361 -43.622  1.00 58.52           C  
ATOM   8079  N   SER    51     -96.642  17.662 -43.546  1.00 46.60           N  
ATOM   8080  CA  SER    51     -96.927  16.305 -43.098  1.00 46.78           C  
ATOM   8081  C   SER    51     -95.855  15.764 -42.153  1.00 45.98           C  
ATOM   8082  O   SER    51     -94.767  16.326 -42.041  1.00 47.23           O  
ATOM   8083  CB  SER    51     -97.097  15.362 -44.297  1.00 46.56           C  
ATOM   8084  OG  SER    51     -95.844  15.036 -44.878  1.00 47.27           O  
ATOM   8085  N   GLY    52     -96.178  14.667 -41.478  1.00 45.55           N  
ATOM   8086  CA  GLY    52     -95.223  13.985 -40.616  1.00 43.07           C  
ATOM   8087  C   GLY    52     -95.883  12.979 -39.699  1.00 43.98           C  
ATOM   8088  O   GLY    52     -96.833  12.294 -40.090  1.00 43.52           O  
ATOM   8089  N   ASN    53     -95.381  12.902 -38.469  1.00 43.90           N  
ATOM   8090  CA  ASN    53     -95.834  11.907 -37.504  1.00 40.61           C  
ATOM   8091  C   ASN    53     -96.062  12.463 -36.107  1.00 39.65           C  
ATOM   8092  O   ASN    53     -95.329  13.336 -35.638  1.00 40.08           O  
ATOM   8093  CB  ASN    53     -94.838  10.745 -37.431  1.00 41.51           C  
ATOM   8094  CG  ASN    53     -94.871   9.867 -38.667  1.00 47.13           C  
ATOM   8095  OD1 ASN    53     -95.901   9.287 -39.005  1.00 50.75           O  
ATOM   8096  ND2 ASN    53     -93.738   9.759 -39.343  1.00 49.89           N  
ATOM   8097  N   LEU    54     -97.097  11.938 -35.462  1.00 37.37           N  
ATOM   8098  CA  LEU    54     -97.386  12.191 -34.062  1.00 38.77           C  
ATOM   8099  C   LEU    54     -97.122  10.899 -33.277  1.00 38.50           C  
ATOM   8100  O   LEU    54     -97.566   9.821 -33.675  1.00 39.47           O  
ATOM   8101  CB  LEU    54     -98.845  12.642 -33.919  1.00 40.65           C  
ATOM   8102  CG  LEU    54     -99.498  12.858 -32.553  1.00 48.06           C  
ATOM   8103  CD1 LEU    54     -98.949  14.092 -31.861  1.00 52.48           C  
ATOM   8104  CD2 LEU    54    -101.005  12.973 -32.727  1.00 43.73           C  
ATOM   8105  N   THR    55     -96.378  11.010 -32.180  1.00 39.30           N  
ATOM   8106  CA  THR    55     -96.126   9.865 -31.304  1.00 39.91           C  
ATOM   8107  C   THR    55     -96.993   9.965 -30.053  1.00 40.74           C  
ATOM   8108  O   THR    55     -96.873  10.912 -29.277  1.00 41.61           O  
ATOM   8109  CB  THR    55     -94.633   9.737 -30.907  1.00 41.37           C  
ATOM   8110  OG1 THR    55     -93.816   9.773 -32.083  1.00 45.21           O  
ATOM   8111  CG2 THR    55     -94.383   8.421 -30.165  1.00 38.83           C  
ATOM   8112  N   VAL    56     -97.865   8.980 -29.871  1.00 41.74           N  
ATOM   8113  CA  VAL    56     -98.785   8.946 -28.740  1.00 39.47           C  
ATOM   8114  C   VAL    56     -98.411   7.781 -27.797  1.00 40.99           C  
ATOM   8115  O   VAL    56     -97.630   6.910 -28.194  1.00 39.59           O  
ATOM   8116  CB  VAL    56    -100.268   8.874 -29.224  1.00 39.38           C  
ATOM   8117  CG1 VAL    56    -100.628  10.107 -30.044  1.00 38.86           C  
ATOM   8118  CG2 VAL    56    -100.544   7.595 -30.007  1.00 36.61           C  
ATOM   8119  N   PRO    57     -98.932   7.774 -26.543  1.00 40.92           N  
ATOM   8120  CA  PRO    57     -98.623   6.686 -25.603  1.00 40.34           C  
ATOM   8121  C   PRO    57     -99.085   5.286 -26.011  1.00 39.91           C  
ATOM   8122  O   PRO    57     -99.891   5.127 -26.932  1.00 41.60           O  
ATOM   8123  CB  PRO    57     -99.368   7.101 -24.325  1.00 40.00           C  
ATOM   8124  CG  PRO    57     -99.582   8.555 -24.455  1.00 39.77           C  
ATOM   8125  CD  PRO    57     -99.794   8.790 -25.906  1.00 37.98           C  
ATOM   8126  N   PHE    58     -98.547   4.284 -25.316  1.00 39.09           N  
ATOM   8127  CA  PHE    58     -99.014   2.905 -25.401  1.00 36.94           C  
ATOM   8128  C   PHE    58    -100.369   2.794 -24.711  1.00 38.40           C  
ATOM   8129  O   PHE    58    -100.719   3.639 -23.889  1.00 39.49           O  
ATOM   8130  CB  PHE    58     -98.033   1.968 -24.691  1.00 36.65           C  
ATOM   8131  CG  PHE    58     -96.719   1.777 -25.406  1.00 37.29           C  
ATOM   8132  CD1 PHE    58     -96.674   1.317 -26.721  1.00 32.46           C  
ATOM   8133  CD2 PHE    58     -95.525   2.011 -24.740  1.00 36.17           C  
ATOM   8134  CE1 PHE    58     -95.456   1.124 -27.365  1.00 30.64           C  
ATOM   8135  CE2 PHE    58     -94.301   1.820 -25.375  1.00 36.39           C  
ATOM   8136  CZ  PHE    58     -94.265   1.374 -26.687  1.00 33.57           C  
ATOM   8137  N   GLY    59    -101.122   1.746 -25.033  1.00 38.02           N  
ATOM   8138  CA  GLY    59    -102.386   1.476 -24.353  1.00 38.64           C  
ATOM   8139  C   GLY    59    -103.588   2.148 -24.991  1.00 40.57           C  
ATOM   8140  O   GLY    59    -104.689   2.114 -24.437  1.00 41.45           O  
ATOM   8141  N   ILE    60    -103.373   2.751 -26.159  1.00 39.42           N  
ATOM   8142  CA  ILE    60    -104.424   3.446 -26.893  1.00 38.65           C  
ATOM   8143  C   ILE    60    -105.140   2.452 -27.794  1.00 39.98           C  
ATOM   8144  O   ILE    60    -104.493   1.652 -28.471  1.00 42.85           O  
ATOM   8145  CB  ILE    60    -103.848   4.646 -27.724  1.00 38.15           C  
ATOM   8146  CG1 ILE    60    -103.155   5.668 -26.813  1.00 35.54           C  
ATOM   8147  CG2 ILE    60    -104.926   5.336 -28.572  1.00 36.48           C  
ATOM   8148  CD1 ILE    60    -103.977   6.131 -25.609  1.00 40.32           C  
ATOM   8149  N   LEU    61    -106.473   2.500 -27.777  1.00 40.96           N  
ATOM   8150  CA  LEU    61    -107.313   1.695 -28.658  1.00 41.73           C  
ATOM   8151  C   LEU    61    -107.102   2.086 -30.115  1.00 43.74           C  
ATOM   8152  O   LEU    61    -107.481   3.174 -30.556  1.00 45.62           O  
ATOM   8153  CB  LEU    61    -108.791   1.801 -28.261  1.00 43.12           C  
ATOM   8154  CG  LEU    61    -109.809   0.889 -28.954  1.00 47.01           C  
ATOM   8155  CD1 LEU    61    -109.384  -0.574 -28.917  1.00 46.29           C  
ATOM   8156  CD2 LEU    61    -111.168   1.062 -28.305  1.00 48.24           C  
ATOM   8157  N   VAL    62    -106.482   1.158 -30.833  1.00 45.81           N  
ATOM   8158  CA  VAL    62    -106.000   1.327 -32.199  1.00 46.43           C  
ATOM   8159  C   VAL    62    -107.124   1.393 -33.254  1.00 49.99           C  
ATOM   8160  O   VAL    62    -106.973   2.042 -34.297  1.00 49.86           O  
ATOM   8161  CB  VAL    62    -104.952   0.203 -32.488  1.00 47.63           C  
ATOM   8162  CG1 VAL    62    -105.276  -0.618 -33.727  1.00 44.38           C  
ATOM   8163  CG2 VAL    62    -103.540   0.753 -32.479  1.00 43.08           C  
ATOM   8164  N   SER    63    -108.252   0.744 -32.963  1.00 52.24           N  
ATOM   8165  CA  SER    63    -109.386   0.694 -33.888  1.00 55.22           C  
ATOM   8166  C   SER    63    -110.231   1.973 -33.879  1.00 55.13           C  
ATOM   8167  O   SER    63    -110.996   2.225 -34.813  1.00 56.93           O  
ATOM   8168  CB  SER    63    -110.260  -0.534 -33.604  1.00 56.41           C  
ATOM   8169  OG  SER    63    -110.703  -0.554 -32.259  1.00 58.82           O  
ATOM   8170  N   LYS    64    -110.087   2.770 -32.823  1.00 54.64           N  
ATOM   8171  CA  LYS    64    -110.773   4.056 -32.702  1.00 54.80           C  
ATOM   8172  C   LYS    64    -109.828   5.216 -33.061  1.00 55.37           C  
ATOM   8173  O   LYS    64    -108.627   5.136 -32.792  1.00 54.67           O  
ATOM   8174  CB  LYS    64    -111.362   4.217 -31.295  1.00 55.30           C  
ATOM   8175  CG  LYS    64    -112.561   3.308 -31.037  1.00 63.31           C  
ATOM   8176  CD  LYS    64    -113.400   3.779 -29.855  1.00 78.37           C  
ATOM   8177  CE  LYS    64    -114.502   4.741 -30.289  1.00 85.91           C  
ATOM   8178  NZ  LYS    64    -115.560   4.064 -31.097  1.00 90.27           N  
ATOM   8179  N   PRO    65    -110.364   6.296 -33.674  1.00 55.58           N  
ATOM   8180  CA  PRO    65    -109.497   7.330 -34.247  1.00 52.60           C  
ATOM   8181  C   PRO    65    -108.828   8.256 -33.237  1.00 49.82           C  
ATOM   8182  O   PRO    65    -109.250   8.339 -32.083  1.00 48.16           O  
ATOM   8183  CB  PRO    65    -110.454   8.155 -35.122  1.00 54.13           C  
ATOM   8184  CG  PRO    65    -111.767   7.441 -35.107  1.00 56.65           C  
ATOM   8185  CD  PRO    65    -111.788   6.625 -33.873  1.00 55.49           C  
ATOM   8186  N   VAL    66    -107.782   8.940 -33.696  1.00 46.27           N  
ATOM   8187  CA  VAL    66    -107.118   9.997 -32.944  1.00 44.24           C  
ATOM   8188  C   VAL    66    -107.577  11.331 -33.533  1.00 46.00           C  
ATOM   8189  O   VAL    66    -107.417  11.587 -34.731  1.00 43.01           O  
ATOM   8190  CB  VAL    66    -105.565   9.870 -33.002  1.00 42.88           C  
ATOM   8191  CG1 VAL    66    -104.891  11.013 -32.249  1.00 35.13           C  
ATOM   8192  CG2 VAL    66    -105.110   8.531 -32.428  1.00 35.10           C  
ATOM   8193  N   ARG    67    -108.167  12.164 -32.684  1.00 48.36           N  
ATOM   8194  CA  ARG    67    -108.753  13.427 -33.112  1.00 53.92           C  
ATOM   8195  C   ARG    67    -107.820  14.591 -32.793  1.00 49.32           C  
ATOM   8196  O   ARG    67    -107.342  14.724 -31.667  1.00 48.15           O  
ATOM   8197  CB  ARG    67    -110.116  13.618 -32.440  1.00 58.21           C  
ATOM   8198  CG  ARG    67    -110.978  14.714 -33.038  1.00 66.31           C  
ATOM   8199  CD  ARG    67    -112.314  14.790 -32.317  1.00 73.54           C  
ATOM   8200  NE  ARG    67    -112.903  16.125 -32.388  1.00 80.28           N  
ATOM   8201  CZ  ARG    67    -112.664  17.103 -31.518  1.00 86.09           C  
ATOM   8202  NH1 ARG    67    -111.839  16.912 -30.494  1.00 80.35           N  
ATOM   8203  NH2 ARG    67    -113.252  18.282 -31.672  1.00 91.87           N  
ATOM   8204  N   LEU    68    -107.562  15.424 -33.795  1.00 49.12           N  
ATOM   8205  CA  LEU    68    -106.675  16.571 -33.647  1.00 49.18           C  
ATOM   8206  C   LEU    68    -107.459  17.867 -33.811  1.00 49.62           C  
ATOM   8207  O   LEU    68    -108.159  18.051 -34.804  1.00 48.56           O  
ATOM   8208  CB  LEU    68    -105.534  16.513 -34.671  1.00 49.41           C  
ATOM   8209  CG  LEU    68    -104.300  15.649 -34.391  1.00 49.62           C  
ATOM   8210  CD1 LEU    68    -104.533  14.193 -34.745  1.00 50.08           C  
ATOM   8211  CD2 LEU    68    -103.119  16.188 -35.170  1.00 55.46           C  
ATOM   8212  N   GLN    69    -107.330  18.764 -32.839  1.00 48.75           N  
ATOM   8213  CA  GLN    69    -108.055  20.028 -32.864  1.00 49.66           C  
ATOM   8214  C   GLN    69    -107.172  21.176 -32.386  1.00 47.73           C  
ATOM   8215  O   GLN    69    -106.540  21.078 -31.335  1.00 45.89           O  
ATOM   8216  CB  GLN    69    -109.320  19.936 -32.002  1.00 49.58           C  
ATOM   8217  CG  GLN    69    -110.243  21.150 -32.100  1.00 56.24           C  
ATOM   8218  CD  GLN    69    -111.428  21.082 -31.147  1.00 57.65           C  
ATOM   8219  OE1 GLN    69    -111.413  20.341 -30.165  1.00 61.51           O  
ATOM   8220  NE2 GLN    69    -112.460  21.865 -31.434  1.00 63.23           N  
ATOM   8221  N   VAL    70    -107.132  22.258 -33.162  1.00 46.79           N  
ATOM   8222  CA  VAL    70    -106.425  23.465 -32.744  1.00 45.63           C  
ATOM   8223  C   VAL    70    -107.314  24.237 -31.771  1.00 50.88           C  
ATOM   8224  O   VAL    70    -108.377  24.738 -32.157  1.00 51.95           O  
ATOM   8225  CB  VAL    70    -106.029  24.367 -33.933  1.00 44.32           C  
ATOM   8226  CG1 VAL    70    -105.031  25.425 -33.477  1.00 41.51           C  
ATOM   8227  CG2 VAL    70    -105.442  23.542 -35.065  1.00 37.72           C  
ATOM   8228  N   ASP    71    -106.859  24.307 -30.517  1.00 57.99           N  
ATOM   8229  CA  ASP    71    -107.581  24.923 -29.392  1.00 60.52           C  
ATOM   8230  C   ASP    71    -109.024  24.421 -29.270  1.00 61.83           C  
ATOM   8231  O   ASP    71    -109.254  23.219 -29.136  1.00 62.03           O  
ATOM   8232  CB  ASP    71    -107.508  26.457 -29.463  1.00 62.89           C  
ATOM   8233  CG  ASP    71    -106.079  26.981 -29.403  1.00 69.66           C  
ATOM   8234  OD1 ASP    71    -105.280  26.458 -28.597  1.00 66.80           O  
ATOM   8235  OD2 ASP    71    -105.759  27.927 -30.157  1.00 74.25           O  
ATOM   8236  N   GLU    72    -109.986  25.336 -29.324  1.00 67.01           N  
ATOM   8237  CA  GLU    72    -111.397  24.967 -29.370  1.00 69.33           C  
ATOM   8238  C   GLU    72    -112.042  25.472 -30.658  1.00 67.56           C  
ATOM   8239  O   GLU    72    -113.250  25.704 -30.716  1.00 69.21           O  
ATOM   8240  CB  GLU    72    -112.128  25.476 -28.127  1.00 72.79           C  
ATOM   8241  CG  GLU    72    -111.884  24.613 -26.893  1.00 84.26           C  
ATOM   8242  CD  GLU    72    -112.101  25.361 -25.594  1.00 95.67           C  
ATOM   8243  OE1 GLU    72    -111.532  26.464 -25.436  1.00100.41           O  
ATOM   8244  OE2 GLU    72    -112.831  24.839 -24.724  1.00 98.92           O  
ATOM   8245  N   GLY    73    -111.215  25.616 -31.691  1.00 67.67           N  
ATOM   8246  CA  GLY    73    -111.646  26.110 -32.993  1.00 68.92           C  
ATOM   8247  C   GLY    73    -112.233  25.051 -33.907  1.00 68.85           C  
ATOM   8248  O   GLY    73    -112.516  23.929 -33.484  1.00 66.45           O  
ATOM   8249  N   LYS    74    -112.392  25.420 -35.175  1.00 73.69           N  
ATOM   8250  CA  LYS    74    -113.137  24.626 -36.153  1.00 76.53           C  
ATOM   8251  C   LYS    74    -112.253  23.676 -36.967  1.00 75.07           C  
ATOM   8252  O   LYS    74    -112.757  22.896 -37.783  1.00 74.22           O  
ATOM   8253  CB  LYS    74    -113.920  25.556 -37.090  1.00 81.61           C  
ATOM   8254  CG  LYS    74    -114.897  26.494 -36.380  1.00 88.45           C  
ATOM   8255  CD  LYS    74    -115.299  27.663 -37.273  1.00 94.43           C  
ATOM   8256  CE  LYS    74    -116.285  28.596 -36.579  1.00 94.31           C  
ATOM   8257  NZ  LYS    74    -117.639  27.985 -36.428  1.00 96.16           N  
ATOM   8258  N   ALA    75    -110.943  23.746 -36.739  1.00 73.41           N  
ATOM   8259  CA  ALA    75    -109.978  22.892 -37.434  1.00 69.88           C  
ATOM   8260  C   ALA    75    -109.856  21.516 -36.768  1.00 67.42           C  
ATOM   8261  O   ALA    75    -109.128  21.353 -35.782  1.00 65.58           O  
ATOM   8262  CB  ALA    75    -108.621  23.581 -37.510  1.00 70.25           C  
ATOM   8263  N   VAL    76    -110.579  20.535 -37.311  1.00 60.66           N  
ATOM   8264  CA  VAL    76    -110.595  19.175 -36.765  1.00 59.27           C  
ATOM   8265  C   VAL    76    -110.114  18.142 -37.797  1.00 59.79           C  
ATOM   8266  O   VAL    76    -110.641  18.064 -38.908  1.00 60.59           O  
ATOM   8267  CB  VAL    76    -111.999  18.791 -36.193  1.00 58.84           C  
ATOM   8268  CG1 VAL    76    -112.044  17.324 -35.750  1.00 59.68           C  
ATOM   8269  CG2 VAL    76    -112.380  19.697 -35.023  1.00 57.82           C  
ATOM   8270  N   ILE    77    -109.096  17.371 -37.417  1.00 58.69           N  
ATOM   8271  CA  ILE    77    -108.611  16.242 -38.207  1.00 59.27           C  
ATOM   8272  C   ILE    77    -108.860  14.942 -37.441  1.00 57.23           C  
ATOM   8273  O   ILE    77    -108.650  14.878 -36.228  1.00 54.63           O  
ATOM   8274  CB  ILE    77    -107.106  16.413 -38.573  1.00 60.42           C  
ATOM   8275  CG1 ILE    77    -106.971  17.218 -39.864  1.00 62.03           C  
ATOM   8276  CG2 ILE    77    -106.384  15.063 -38.733  1.00 63.50           C  
ATOM   8277  CD1 ILE    77    -105.544  17.554 -40.232  1.00 65.24           C  
ATOM   8278  N   GLU    78    -109.340  13.922 -38.145  1.00 57.78           N  
ATOM   8279  CA  GLU    78    -109.468  12.599 -37.555  1.00 60.04           C  
ATOM   8280  C   GLU    78    -108.614  11.602 -38.333  1.00 57.68           C  
ATOM   8281  O   GLU    78    -108.806  11.399 -39.533  1.00 59.36           O  
ATOM   8282  CB  GLU    78    -110.933  12.161 -37.490  1.00 61.44           C  
ATOM   8283  CG  GLU    78    -111.316  11.586 -36.139  1.00 71.59           C  
ATOM   8284  CD  GLU    78    -112.807  11.362 -35.982  1.00 82.86           C  
ATOM   8285  OE1 GLU    78    -113.399  11.973 -35.065  1.00 85.63           O  
ATOM   8286  OE2 GLU    78    -113.384  10.575 -36.764  1.00 85.45           O  
ATOM   8287  N   THR    79    -107.655  11.004 -37.634  1.00 55.81           N  
ATOM   8288  CA  THR    79    -106.732  10.030 -38.214  1.00 53.71           C  
ATOM   8289  C   THR    79    -106.540   8.885 -37.214  1.00 50.88           C  
ATOM   8290  O   THR    79    -107.223   8.843 -36.198  1.00 53.52           O  
ATOM   8291  CB  THR    79    -105.387  10.704 -38.633  1.00 56.65           C  
ATOM   8292  OG1 THR    79    -104.436   9.713 -39.047  1.00 55.80           O  
ATOM   8293  CG2 THR    79    -104.801  11.534 -37.490  1.00 53.91           C  
ATOM   8294  N   GLY    80    -105.636   7.952 -37.499  1.00 48.90           N  
ATOM   8295  CA  GLY    80    -105.436   6.798 -36.626  1.00 45.19           C  
ATOM   8296  C   GLY    80    -103.998   6.328 -36.531  1.00 43.56           C  
ATOM   8297  O   GLY    80    -103.134   6.782 -37.288  1.00 43.06           O  
ATOM   8298  N   ILE    81    -103.749   5.418 -35.588  1.00 41.38           N  
ATOM   8299  CA  ILE    81    -102.425   4.828 -35.381  1.00 38.65           C  
ATOM   8300  C   ILE    81    -102.105   3.891 -36.542  1.00 38.79           C  
ATOM   8301  O   ILE    81    -102.950   3.084 -36.931  1.00 42.90           O  
ATOM   8302  CB  ILE    81    -102.347   4.072 -34.017  1.00 37.88           C  
ATOM   8303  CG1 ILE    81    -102.470   5.056 -32.844  1.00 37.27           C  
ATOM   8304  CG2 ILE    81    -101.049   3.254 -33.893  1.00 33.72           C  
ATOM   8305  CD1 ILE    81    -102.728   4.400 -31.495  1.00 36.56           C  
ATOM   8306  N   ARG    82    -100.906   4.039 -37.106  1.00 36.17           N  
ATOM   8307  CA  ARG    82    -100.434   3.188 -38.197  0.50 35.92           C  
ATOM   8309  C   ARG    82     -99.723   1.959 -37.641  1.00 38.22           C  
ATOM   8310  O   ARG    82     -99.928   0.840 -38.121  1.00 36.05           O  
ATOM   8311  CB  ARG    82     -99.487   3.972 -39.112  0.50 34.83           C  
ATOM   8313  CG  ARG    82     -99.010   3.215 -40.350  0.50 39.11           C  
ATOM   8315  CD  ARG    82     -98.224   4.118 -41.294  0.50 35.84           C  
ATOM   8317  NE  ARG    82     -97.622   3.368 -42.395  0.50 33.08           N  
ATOM   8319  CZ  ARG    82     -96.374   2.903 -42.404  0.50 37.07           C  
ATOM   8321  NH1 ARG    82     -95.569   3.106 -41.368  0.50 32.81           N  
ATOM   8323  NH2 ARG    82     -95.926   2.231 -43.457  0.50 36.71           N  
ATOM   8325  N   THR    83     -98.886   2.189 -36.632  1.00 37.48           N  
ATOM   8326  CA  THR    83     -98.088   1.158 -35.979  1.00 39.27           C  
ATOM   8327  C   THR    83     -97.544   1.685 -34.654  1.00 39.23           C  
ATOM   8328  O   THR    83     -97.584   2.892 -34.390  1.00 39.06           O  
ATOM   8329  CB  THR    83     -96.901   0.695 -36.874  1.00 41.83           C  
ATOM   8330  OG1 THR    83     -96.245  -0.419 -36.262  1.00 49.98           O  
ATOM   8331  CG2 THR    83     -95.888   1.825 -37.118  1.00 40.10           C  
ATOM   8332  N   CYS    84     -97.042   0.782 -33.816  1.00 39.51           N  
ATOM   8333  CA  CYS    84     -96.324   1.200 -32.615  1.00 40.53           C  
ATOM   8334  C   CYS    84     -94.914   0.628 -32.602  1.00 39.63           C  
ATOM   8335  O   CYS    84     -94.671  -0.472 -33.091  1.00 41.58           O  
ATOM   8336  CB  CYS    84     -97.084   0.853 -31.328  1.00 40.84           C  
ATOM   8337  SG  CYS    84     -98.856   1.307 -31.327  1.00 47.99           S  
ATOM   8338  N   VAL    85     -93.994   1.422 -32.069  1.00 41.26           N  
ATOM   8339  CA  VAL    85     -92.575   1.088 -31.962  1.00 38.74           C  
ATOM   8340  C   VAL    85     -92.207   1.247 -30.470  1.00 39.32           C  
ATOM   8341  O   VAL    85     -93.071   1.667 -29.693  1.00 38.98           O  
ATOM   8342  CB  VAL    85     -91.720   2.011 -32.891  1.00 39.61           C  
ATOM   8343  CG1 VAL    85     -91.939   1.654 -34.361  1.00 36.84           C  
ATOM   8344  CG2 VAL    85     -92.010   3.488 -32.630  1.00 36.34           C  
ATOM   8345  N   PRO    86     -90.965   0.887 -30.050  1.00 39.93           N  
ATOM   8346  CA  PRO    86     -90.579   1.125 -28.642  1.00 40.46           C  
ATOM   8347  C   PRO    86     -90.798   2.546 -28.099  1.00 41.17           C  
ATOM   8348  O   PRO    86     -91.110   2.702 -26.920  1.00 41.73           O  
ATOM   8349  CB  PRO    86     -89.090   0.763 -28.623  1.00 38.19           C  
ATOM   8350  CG  PRO    86     -88.964  -0.271 -29.677  1.00 39.12           C  
ATOM   8351  CD  PRO    86     -89.882   0.187 -30.776  1.00 40.81           C  
ATOM   8352  N   ALA    87     -90.664   3.561 -28.953  1.00 41.92           N  
ATOM   8353  CA  ALA    87     -90.876   4.959 -28.552  1.00 41.74           C  
ATOM   8354  C   ALA    87     -92.349   5.317 -28.308  1.00 42.35           C  
ATOM   8355  O   ALA    87     -92.646   6.320 -27.659  1.00 44.31           O  
ATOM   8356  CB  ALA    87     -90.265   5.907 -29.580  1.00 39.31           C  
ATOM   8357  N   GLY    88     -93.261   4.500 -28.829  1.00 40.31           N  
ATOM   8358  CA  GLY    88     -94.694   4.729 -28.676  1.00 35.02           C  
ATOM   8359  C   GLY    88     -95.465   4.404 -29.941  1.00 38.26           C  
ATOM   8360  O   GLY    88     -94.940   3.763 -30.856  1.00 38.56           O  
ATOM   8361  N   CYS    89     -96.718   4.846 -29.992  1.00 37.23           N  
ATOM   8362  CA  CYS    89     -97.581   4.594 -31.143  1.00 37.64           C  
ATOM   8363  C   CYS    89     -97.558   5.742 -32.153  1.00 37.25           C  
ATOM   8364  O   CYS    89     -97.679   6.909 -31.783  1.00 38.90           O  
ATOM   8365  CB  CYS    89     -98.997   4.263 -30.677  1.00 36.32           C  
ATOM   8366  SG  CYS    89     -99.087   2.665 -29.817  1.00 44.05           S  
ATOM   8367  N   ILE    90     -97.386   5.397 -33.426  1.00 38.32           N  
ATOM   8368  CA  ILE    90     -97.156   6.382 -34.485  1.00 38.77           C  
ATOM   8369  C   ILE    90     -98.438   6.728 -35.234  1.00 38.84           C  
ATOM   8370  O   ILE    90     -99.085   5.851 -35.811  1.00 39.38           O  
ATOM   8371  CB  ILE    90     -96.072   5.896 -35.490  1.00 40.66           C  
ATOM   8372  CG1 ILE    90     -94.799   5.434 -34.759  1.00 40.11           C  
ATOM   8373  CG2 ILE    90     -95.768   6.968 -36.549  1.00 36.05           C  
ATOM   8374  CD1 ILE    90     -94.091   6.505 -33.922  1.00 47.31           C  
ATOM   8375  N   VAL    91     -98.788   8.015 -35.214  1.00 37.89           N  
ATOM   8376  CA  VAL    91     -99.967   8.541 -35.903  1.00 38.22           C  
ATOM   8377  C   VAL    91     -99.531   9.458 -37.056  1.00 38.71           C  
ATOM   8378  O   VAL    91     -99.006  10.547 -36.804  1.00 37.63           O  
ATOM   8379  CB  VAL    91    -100.880   9.336 -34.930  1.00 37.64           C  
ATOM   8380  CG1 VAL    91    -102.136   9.797 -35.628  1.00 34.89           C  
ATOM   8381  CG2 VAL    91    -101.244   8.505 -33.701  1.00 34.78           C  
ATOM   8382  N   PRO    92     -99.724   9.015 -38.321  1.00 41.21           N  
ATOM   8383  CA  PRO    92     -99.403   9.864 -39.476  1.00 42.25           C  
ATOM   8384  C   PRO    92    -100.380  11.022 -39.603  1.00 43.69           C  
ATOM   8385  O   PRO    92    -101.587  10.855 -39.385  1.00 46.34           O  
ATOM   8386  CB  PRO    92     -99.558   8.923 -40.679  1.00 40.31           C  
ATOM   8387  CG  PRO    92     -99.658   7.560 -40.117  1.00 41.73           C  
ATOM   8388  CD  PRO    92    -100.242   7.706 -38.751  1.00 40.34           C  
ATOM   8389  N   ILE    93     -99.847  12.189 -39.942  1.00 45.44           N  
ATOM   8390  CA  ILE    93    -100.636  13.410 -40.027  1.00 49.26           C  
ATOM   8391  C   ILE    93    -100.320  14.166 -41.312  1.00 48.71           C  
ATOM   8392  O   ILE    93     -99.160  14.278 -41.705  1.00 47.82           O  
ATOM   8393  CB  ILE    93    -100.407  14.322 -38.799  1.00 49.93           C  
ATOM   8394  CG1 ILE    93     -98.955  14.218 -38.324  1.00 54.73           C  
ATOM   8395  CG2 ILE    93    -101.351  13.927 -37.673  1.00 51.42           C  
ATOM   8396  CD1 ILE    93     -98.444  15.402 -37.553  1.00 48.62           C  
ATOM   8397  N   VAL    94    -101.369  14.643 -41.977  1.00 50.69           N  
ATOM   8398  CA  VAL    94    -101.246  15.502 -43.154  1.00 50.83           C  
ATOM   8399  C   VAL    94    -102.096  16.742 -42.903  1.00 50.88           C  
ATOM   8400  O   VAL    94    -103.281  16.628 -42.589  1.00 49.91           O  
ATOM   8401  CB  VAL    94    -101.702  14.779 -44.456  1.00 51.87           C  
ATOM   8402  CG1 VAL    94    -101.773  15.746 -45.634  1.00 51.56           C  
ATOM   8403  CG2 VAL    94    -100.766  13.624 -44.794  1.00 52.37           C  
ATOM   8404  N   PHE    95    -101.482  17.918 -43.019  1.00 51.11           N  
ATOM   8405  CA  PHE    95    -102.182  19.184 -42.817  1.00 53.11           C  
ATOM   8406  C   PHE    95    -102.367  19.943 -44.131  1.00 55.23           C  
ATOM   8407  O   PHE    95    -101.393  20.207 -44.839  1.00 57.10           O  
ATOM   8408  CB  PHE    95    -101.417  20.069 -41.830  1.00 51.34           C  
ATOM   8409  CG  PHE    95    -101.156  19.428 -40.493  1.00 51.30           C  
ATOM   8410  CD1 PHE    95     -99.856  19.297 -40.014  1.00 52.45           C  
ATOM   8411  CD2 PHE    95    -102.205  18.971 -39.704  1.00 51.81           C  
ATOM   8412  CE1 PHE    95     -99.611  18.719 -38.773  1.00 51.34           C  
ATOM   8413  CE2 PHE    95    -101.969  18.393 -38.462  1.00 49.46           C  
ATOM   8414  CZ  PHE    95    -100.673  18.267 -37.997  1.00 47.79           C  
ATOM   8415  N   ASP    96    -103.612  20.298 -44.449  1.00 58.17           N  
ATOM   8416  CA  ASP    96    -103.896  21.166 -45.601  1.00 62.07           C  
ATOM   8417  C   ASP    96    -103.629  22.639 -45.269  1.00 61.94           C  
ATOM   8418  O   ASP    96    -103.404  22.977 -44.103  1.00 61.30           O  
ATOM   8419  CB  ASP    96    -105.324  20.955 -46.143  1.00 62.34           C  
ATOM   8420  CG  ASP    96    -106.411  21.130 -45.079  1.00 68.13           C  
ATOM   8421  OD1 ASP    96    -106.406  22.134 -44.332  1.00 70.22           O  
ATOM   8422  OD2 ASP    96    -107.305  20.260 -45.012  1.00 74.75           O  
ATOM   8423  N   LYS    97    -103.677  23.499 -46.293  1.00 63.21           N  
ATOM   8424  CA  LYS    97    -103.397  24.944 -46.171  1.00 62.15           C  
ATOM   8425  C   LYS    97    -104.205  25.629 -45.062  1.00 58.72           C  
ATOM   8426  O   LYS    97    -103.676  26.483 -44.340  1.00 56.63           O  
ATOM   8427  CB  LYS    97    -103.646  25.671 -47.505  1.00 66.63           C  
ATOM   8428  CG  LYS    97    -103.078  24.989 -48.754  1.00 79.15           C  
ATOM   8429  CD  LYS    97    -101.597  25.278 -48.960  1.00 86.33           C  
ATOM   8430  CE  LYS    97    -101.089  24.618 -50.234  1.00 91.32           C  
ATOM   8431  NZ  LYS    97     -99.626  24.816 -50.433  1.00 92.22           N  
ATOM   8432  N   ASN    98    -105.474  25.231 -44.942  1.00 57.44           N  
ATOM   8433  CA  ASN    98    -106.388  25.775 -43.937  0.50 56.36           C  
ATOM   8435  C   ASN    98    -106.004  25.379 -42.513  1.00 56.07           C  
ATOM   8436  O   ASN    98    -106.101  26.193 -41.586  1.00 55.82           O  
ATOM   8437  CB  ASN    98    -107.826  25.333 -44.230  0.50 55.43           C  
ATOM   8439  CG  ASN    98    -108.272  25.685 -45.639  0.50 59.53           C  
ATOM   8441  OD1 ASN    98    -108.337  24.821 -46.514  0.50 56.99           O  
ATOM   8443  ND2 ASN    98    -108.574  26.959 -45.866  0.50 60.32           N  
ATOM   8445  N   TYR    99    -105.572  24.127 -42.346  1.00 53.30           N  
ATOM   8446  CA  TYR    99    -105.174  23.604 -41.038  1.00 49.37           C  
ATOM   8447  C   TYR    99    -103.825  24.171 -40.601  1.00 46.29           C  
ATOM   8448  O   TYR    99    -103.633  24.483 -39.422  1.00 46.34           O  
ATOM   8449  CB  TYR    99    -105.136  22.073 -41.041  1.00 49.20           C  
ATOM   8450  CG  TYR    99    -105.383  21.459 -39.678  1.00 47.60           C  
ATOM   8451  CD1 TYR    99    -104.369  21.396 -38.725  1.00 45.07           C  
ATOM   8452  CD2 TYR    99    -106.631  20.950 -39.339  1.00 47.01           C  
ATOM   8453  CE1 TYR    99    -104.583  20.839 -37.479  1.00 45.69           C  
ATOM   8454  CE2 TYR    99    -106.857  20.387 -38.087  1.00 49.26           C  
ATOM   8455  CZ  TYR    99    -105.826  20.337 -37.164  1.00 46.90           C  
ATOM   8456  OH  TYR    99    -106.029  19.789 -35.921  1.00 49.80           O  
ATOM   8457  N   VAL   100    -102.906  24.302 -41.556  1.00 43.96           N  
ATOM   8458  CA  VAL   100    -101.616  24.960 -41.332  1.00 43.98           C  
ATOM   8459  C   VAL   100    -101.799  26.388 -40.802  1.00 45.79           C  
ATOM   8460  O   VAL   100    -101.137  26.778 -39.843  1.00 48.00           O  
ATOM   8461  CB  VAL   100    -100.750  24.947 -42.617  1.00 44.35           C  
ATOM   8462  CG1 VAL   100     -99.566  25.891 -42.500  1.00 40.53           C  
ATOM   8463  CG2 VAL   100    -100.267  23.541 -42.908  1.00 42.15           C  
ATOM   8464  N   ALA   101    -102.725  27.136 -41.407  1.00 47.44           N  
ATOM   8465  CA  ALA   101    -103.055  28.503 -40.983  1.00 47.64           C  
ATOM   8466  C   ALA   101    -103.597  28.568 -39.554  1.00 46.99           C  
ATOM   8467  O   ALA   101    -103.307  29.517 -38.819  1.00 51.32           O  
ATOM   8468  CB  ALA   101    -104.048  29.135 -41.954  1.00 47.36           C  
ATOM   8469  N   ALA   102    -104.378  27.558 -39.174  1.00 45.72           N  
ATOM   8470  CA  ALA   102    -104.909  27.437 -37.818  1.00 43.91           C  
ATOM   8471  C   ALA   102    -103.809  27.097 -36.807  1.00 45.33           C  
ATOM   8472  O   ALA   102    -103.827  27.592 -35.680  1.00 46.79           O  
ATOM   8473  CB  ALA   102    -106.022  26.394 -37.774  1.00 42.26           C  
ATOM   8474  N   LEU   103    -102.859  26.258 -37.228  1.00 45.67           N  
ATOM   8475  CA  LEU   103    -101.682  25.882 -36.429  1.00 44.40           C  
ATOM   8476  C   LEU   103    -100.780  27.074 -36.107  1.00 44.93           C  
ATOM   8477  O   LEU   103    -100.211  27.149 -35.017  1.00 44.18           O  
ATOM   8478  CB  LEU   103    -100.866  24.811 -37.167  1.00 43.89           C  
ATOM   8479  CG  LEU   103    -100.812  23.312 -36.816  1.00 45.04           C  
ATOM   8480  CD1 LEU   103    -101.862  22.848 -35.824  1.00 40.47           C  
ATOM   8481  CD2 LEU   103    -100.864  22.475 -38.089  1.00 39.92           C  
ATOM   8482  N   ARG   104    -100.654  27.997 -37.060  1.00 45.96           N  
ATOM   8483  CA  ARG   104     -99.846  29.205 -36.884  1.00 45.42           C  
ATOM   8484  C   ARG   104    -100.493  30.188 -35.908  1.00 45.70           C  
ATOM   8485  O   ARG   104     -99.793  30.910 -35.198  1.00 47.56           O  
ATOM   8486  CB  ARG   104     -99.612  29.903 -38.226  1.00 48.20           C  
ATOM   8487  CG  ARG   104     -98.985  29.032 -39.300  1.00 48.50           C  
ATOM   8488  CD  ARG   104     -98.942  29.763 -40.628  1.00 48.41           C  
ATOM   8489  NE  ARG   104     -97.597  30.242 -40.930  1.00 45.45           N  
ATOM   8490  CZ  ARG   104     -96.884  29.856 -41.983  1.00 48.70           C  
ATOM   8491  NH1 ARG   104     -97.389  28.999 -42.860  1.00 61.07           N  
ATOM   8492  NH2 ARG   104     -95.668  30.342 -42.172  1.00 38.74           N  
ATOM   8493  N   ALA   105    -101.825  30.206 -35.880  1.00 46.39           N  
ATOM   8494  CA  ALA   105    -102.577  31.137 -35.038  1.00 48.45           C  
ATOM   8495  C   ALA   105    -102.917  30.547 -33.674  1.00 49.51           C  
ATOM   8496  O   ALA   105    -103.317  31.272 -32.760  1.00 52.08           O  
ATOM   8497  CB  ALA   105    -103.850  31.589 -35.753  1.00 48.13           C  
ATOM   8498  N   GLY   106    -102.755  29.232 -33.541  1.00 47.95           N  
ATOM   8499  CA  GLY   106    -103.172  28.515 -32.335  1.00 42.97           C  
ATOM   8500  C   GLY   106    -102.157  28.480 -31.207  1.00 42.20           C  
ATOM   8501  O   GLY   106    -100.995  28.862 -31.377  1.00 42.49           O  
ATOM   8502  N   LYS   107    -102.614  28.015 -30.048  1.00 43.00           N  
ATOM   8503  CA  LYS   107    -101.771  27.880 -28.865  1.00 47.17           C  
ATOM   8504  C   LYS   107    -101.509  26.412 -28.525  1.00 45.45           C  
ATOM   8505  O   LYS   107    -100.383  26.029 -28.207  1.00 44.60           O  
ATOM   8506  CB  LYS   107    -102.407  28.607 -27.674  1.00 50.63           C  
ATOM   8507  CG  LYS   107    -101.873  30.023 -27.475  1.00 65.02           C  
ATOM   8508  CD  LYS   107    -102.913  30.961 -26.882  1.00 77.55           C  
ATOM   8509  CE  LYS   107    -103.747  31.627 -27.972  1.00 86.67           C  
ATOM   8510  NZ  LYS   107    -104.663  32.663 -27.416  1.00 90.76           N  
ATOM   8511  N   HIS   108    -102.546  25.600 -28.561  1.00 45.01           N  
ATOM   8512  CA  HIS   108    -102.459  24.180 -28.282  1.00 44.56           C  
ATOM   8513  C   HIS   108    -103.063  23.346 -29.397  1.00 44.55           C  
ATOM   8514  O   HIS   108    -104.122  23.632 -29.880  1.00 43.56           O  
ATOM   8515  CB  HIS   108    -103.221  23.854 -27.015  1.00 47.32           C  
ATOM   8516  CG  HIS   108    -102.505  24.212 -25.762  1.00 54.73           C  
ATOM   8517  ND1 HIS   108    -102.780  23.614 -24.564  1.00 64.61           N  
ATOM   8518  CD2 HIS   108    -101.536  25.110 -25.515  1.00 62.28           C  
ATOM   8519  CE1 HIS   108    -102.005  24.123 -23.633  1.00 65.87           C  
ATOM   8520  NE2 HIS   108    -101.244  25.038 -24.183  1.00 62.10           N  
ATOM   8521  N   LEU   109    -102.395  22.283 -29.779  1.00 41.56           N  
ATOM   8522  CA  LEU   109    -102.997  21.270 -30.627  1.00 41.76           C  
ATOM   8523  C   LEU   109    -103.484  20.151 -29.717  1.00 42.73           C  
ATOM   8524  O   LEU   109    -102.692  19.347 -29.231  1.00 43.29           O  
ATOM   8525  CB  LEU   109    -102.010  20.747 -31.677  1.00 38.66           C  
ATOM   8526  CG  LEU   109    -102.527  19.658 -32.627  1.00 38.21           C  
ATOM   8527  CD1 LEU   109    -103.705  20.134 -33.472  1.00 38.18           C  
ATOM   8528  CD2 LEU   109    -101.416  19.180 -33.517  1.00 37.24           C  
ATOM   8529  N   LYS   110    -104.791  20.125 -29.480  1.00 43.89           N  
ATOM   8530  CA  LYS   110    -105.404  19.176 -28.560  1.00 43.28           C  
ATOM   8531  C   LYS   110    -105.587  17.811 -29.212  1.00 42.81           C  
ATOM   8532  O   LYS   110    -105.958  17.711 -30.386  1.00 41.27           O  
ATOM   8533  CB  LYS   110    -106.747  19.713 -28.057  1.00 46.86           C  
ATOM   8534  CG  LYS   110    -106.637  20.949 -27.172  1.00 53.48           C  
ATOM   8535  CD  LYS   110    -107.995  21.343 -26.614  1.00 68.99           C  
ATOM   8536  CE  LYS   110    -107.894  22.573 -25.725  1.00 83.43           C  
ATOM   8537  NZ  LYS   110    -109.224  22.997 -25.197  1.00 87.33           N  
ATOM   8538  N   LEU   111    -105.312  16.761 -28.444  1.00 43.69           N  
ATOM   8539  CA  LEU   111    -105.471  15.391 -28.923  1.00 43.91           C  
ATOM   8540  C   LEU   111    -106.586  14.683 -28.168  1.00 42.18           C  
ATOM   8541  O   LEU   111    -106.776  14.908 -26.971  1.00 42.42           O  
ATOM   8542  CB  LEU   111    -104.172  14.585 -28.777  1.00 44.52           C  
ATOM   8543  CG  LEU   111    -102.890  14.770 -29.601  1.00 45.49           C  
ATOM   8544  CD1 LEU   111    -103.057  15.711 -30.792  1.00 43.61           C  
ATOM   8545  CD2 LEU   111    -101.758  15.239 -28.714  1.00 46.82           C  
ATOM   8546  N   ALA   112    -107.317  13.826 -28.874  1.00 41.70           N  
ATOM   8547  CA  ALA   112    -108.374  13.027 -28.265  1.00 42.11           C  
ATOM   8548  C   ALA   112    -108.318  11.600 -28.786  1.00 40.83           C  
ATOM   8549  O   ALA   112    -108.326  11.375 -29.995  1.00 41.53           O  
ATOM   8550  CB  ALA   112    -109.737  13.640 -28.541  1.00 43.85           C  
ATOM   8551  N   MET   113    -108.261  10.641 -27.867  1.00 42.50           N  
ATOM   8552  CA  MET   113    -108.178   9.224 -28.225  1.00 41.77           C  
ATOM   8553  C   MET   113    -108.865   8.337 -27.185  1.00 43.96           C  
ATOM   8554  O   MET   113    -109.351   8.830 -26.165  1.00 43.85           O  
ATOM   8555  CB  MET   113    -106.716   8.800 -28.455  1.00 39.60           C  
ATOM   8556  CG  MET   113    -105.768   9.074 -27.297  1.00 39.28           C  
ATOM   8557  SD  MET   113    -104.057   9.187 -27.855  1.00 38.65           S  
ATOM   8558  CE  MET   113    -103.916  10.929 -28.210  1.00 41.68           C  
ATOM   8559  N   THR   114    -108.912   7.036 -27.464  1.00 46.22           N  
ATOM   8560  CA  THR   114    -109.570   6.062 -26.595  1.00 45.64           C  
ATOM   8561  C   THR   114    -108.539   5.101 -26.004  1.00 45.67           C  
ATOM   8562  O   THR   114    -107.699   4.574 -26.725  1.00 45.03           O  
ATOM   8563  CB  THR   114    -110.642   5.261 -27.373  1.00 45.96           C  
ATOM   8564  OG1 THR   114    -111.473   6.162 -28.109  1.00 48.22           O  
ATOM   8565  CG2 THR   114    -111.514   4.449 -26.434  1.00 42.63           C  
ATOM   8566  N   ILE   115    -108.603   4.896 -24.688  1.00 45.73           N  
ATOM   8567  CA  ILE   115    -107.736   3.945 -23.995  1.00 46.76           C  
ATOM   8568  C   ILE   115    -108.279   2.526 -24.181  1.00 48.35           C  
ATOM   8569  O   ILE   115    -109.484   2.295 -24.043  1.00 46.33           O  
ATOM   8570  CB  ILE   115    -107.608   4.296 -22.484  1.00 48.02           C  
ATOM   8571  CG1 ILE   115    -107.145   5.752 -22.308  1.00 45.46           C  
ATOM   8572  CG2 ILE   115    -106.644   3.342 -21.767  1.00 46.95           C  
ATOM   8573  CD1 ILE   115    -107.260   6.284 -20.886  1.00 46.24           C  
ATOM   8574  N   ALA   116    -107.391   1.590 -24.528  1.00 50.35           N  
ATOM   8575  CA  ALA   116    -107.740   0.171 -24.607  1.00 52.06           C  
ATOM   8576  C   ALA   116    -107.751  -0.436 -23.205  1.00 55.15           C  
ATOM   8577  O   ALA   116    -106.767  -1.031 -22.750  1.00 59.61           O  
ATOM   8578  CB  ALA   116    -106.782  -0.572 -25.521  1.00 44.31           C  
ATOM   8579  N   ALA   117    -108.878  -0.253 -22.527  1.00 58.19           N  
ATOM   8580  CA  ALA   117    -109.069  -0.675 -21.145  1.00 61.47           C  
ATOM   8581  C   ALA   117    -110.547  -1.048 -20.998  1.00 66.06           C  
ATOM   8582  O   ALA   117    -111.353  -0.647 -21.847  1.00 65.12           O  
ATOM   8583  CB  ALA   117    -108.688   0.464 -20.192  1.00 59.16           C  
ATOM   8584  N   PRO   118    -110.907  -1.847 -19.961  1.00 70.36           N  
ATOM   8585  CA  PRO   118    -112.326  -2.104 -19.686  1.00 69.83           C  
ATOM   8586  C   PRO   118    -113.139  -0.815 -19.520  1.00 67.26           C  
ATOM   8587  O   PRO   118    -112.801   0.036 -18.690  1.00 65.41           O  
ATOM   8588  CB  PRO   118    -112.289  -2.889 -18.371  1.00 72.29           C  
ATOM   8589  CG  PRO   118    -110.970  -3.562 -18.380  1.00 73.53           C  
ATOM   8590  CD  PRO   118    -110.035  -2.587 -19.025  1.00 71.48           C  
ATOM   8591  N   GLY   119    -114.183  -0.678 -20.336  1.00 64.56           N  
ATOM   8592  CA  GLY   119    -115.020   0.521 -20.353  1.00 65.34           C  
ATOM   8593  C   GLY   119    -114.679   1.468 -21.491  1.00 66.33           C  
ATOM   8594  O   GLY   119    -115.500   2.313 -21.870  1.00 65.92           O  
ATOM   8595  N   GLU   120    -113.468   1.304 -22.031  1.00 65.10           N  
ATOM   8596  CA  GLU   120    -112.886   2.149 -23.091  1.00 60.07           C  
ATOM   8597  C   GLU   120    -112.930   3.659 -22.797  1.00 56.48           C  
ATOM   8598  O   GLU   120    -113.626   4.403 -23.499  1.00 54.40           O  
ATOM   8599  CB  GLU   120    -113.501   1.823 -24.461  1.00 57.83           C  
ATOM   8600  CG  GLU   120    -113.168   0.420 -24.972  1.00 61.58           C  
ATOM   8601  CD  GLU   120    -113.903   0.049 -26.256  1.00 66.14           C  
ATOM   8602  OE1 GLU   120    -114.475   0.945 -26.917  1.00 66.14           O  
ATOM   8603  OE2 GLU   120    -113.890  -1.148 -26.617  1.00 72.51           O  
ATOM   8604  N   PRO   121    -112.171   4.114 -21.774  1.00 52.88           N  
ATOM   8605  CA  PRO   121    -112.229   5.517 -21.353  1.00 53.24           C  
ATOM   8606  C   PRO   121    -111.534   6.454 -22.351  1.00 56.38           C  
ATOM   8607  O   PRO   121    -110.611   6.030 -23.048  1.00 53.06           O  
ATOM   8608  CB  PRO   121    -111.475   5.522 -20.009  1.00 52.61           C  
ATOM   8609  CG  PRO   121    -111.177   4.091 -19.683  1.00 52.96           C  
ATOM   8610  CD  PRO   121    -111.185   3.358 -20.979  1.00 52.36           C  
ATOM   8611  N   PRO   122    -111.985   7.719 -22.435  1.00 59.94           N  
ATOM   8612  CA  PRO   122    -111.286   8.657 -23.309  1.00 58.33           C  
ATOM   8613  C   PRO   122    -110.017   9.220 -22.674  1.00 56.98           C  
ATOM   8614  O   PRO   122    -109.922   9.322 -21.444  1.00 57.07           O  
ATOM   8615  CB  PRO   122    -112.315   9.769 -23.519  1.00 60.21           C  
ATOM   8616  CG  PRO   122    -113.144   9.755 -22.281  1.00 61.14           C  
ATOM   8617  CD  PRO   122    -113.148   8.339 -21.768  1.00 60.85           C  
ATOM   8618  N   LEU   123    -109.047   9.561 -23.519  1.00 54.52           N  
ATOM   8619  CA  LEU   123    -107.865  10.303 -23.100  1.00 53.27           C  
ATOM   8620  C   LEU   123    -107.857  11.620 -23.871  1.00 54.53           C  
ATOM   8621  O   LEU   123    -107.614  11.639 -25.083  1.00 51.60           O  
ATOM   8622  CB  LEU   123    -106.586   9.495 -23.354  1.00 51.52           C  
ATOM   8623  CG  LEU   123    -105.254  10.038 -22.815  1.00 53.22           C  
ATOM   8624  CD1 LEU   123    -105.218  10.070 -21.284  1.00 52.01           C  
ATOM   8625  CD2 LEU   123    -104.097   9.215 -23.355  1.00 50.63           C  
ATOM   8626  N   ASN   124    -108.144  12.713 -23.163  1.00 56.50           N  
ATOM   8627  CA  ASN   124    -108.382  14.015 -23.792  1.00 56.92           C  
ATOM   8628  C   ASN   124    -107.468  15.139 -23.302  1.00 56.47           C  
ATOM   8629  O   ASN   124    -107.540  16.263 -23.805  1.00 57.02           O  
ATOM   8630  CB  ASN   124    -109.848  14.431 -23.610  1.00 59.19           C  
ATOM   8631  CG  ASN   124    -110.825  13.484 -24.293  1.00 62.91           C  
ATOM   8632  OD1 ASN   124    -110.506  12.856 -25.306  1.00 63.84           O  
ATOM   8633  ND2 ASN   124    -112.032  13.388 -23.741  1.00 62.51           N  
ATOM   8634  N   ASP   125    -106.609  14.837 -22.332  1.00 55.89           N  
ATOM   8635  CA  ASP   125    -105.779  15.864 -21.692  1.00 57.91           C  
ATOM   8636  C   ASP   125    -104.396  16.068 -22.331  1.00 55.21           C  
ATOM   8637  O   ASP   125    -103.591  16.868 -21.845  1.00 54.81           O  
ATOM   8638  CB  ASP   125    -105.666  15.616 -20.173  1.00 62.84           C  
ATOM   8639  CG  ASP   125    -105.107  14.231 -19.822  1.00 72.01           C  
ATOM   8640  OD1 ASP   125    -104.941  13.962 -18.613  1.00 81.27           O  
ATOM   8641  OD2 ASP   125    -104.833  13.413 -20.727  1.00 74.19           O  
ATOM   8642  N   LEU   126    -104.131  15.349 -23.420  1.00 51.02           N  
ATOM   8643  CA  LEU   126    -102.862  15.481 -24.138  1.00 46.92           C  
ATOM   8644  C   LEU   126    -102.934  16.535 -25.235  1.00 44.90           C  
ATOM   8645  O   LEU   126    -103.976  16.714 -25.877  1.00 45.37           O  
ATOM   8646  CB  LEU   126    -102.422  14.140 -24.730  1.00 47.54           C  
ATOM   8647  CG  LEU   126    -101.420  13.221 -24.023  1.00 47.39           C  
ATOM   8648  CD1 LEU   126    -101.581  13.167 -22.504  1.00 46.51           C  
ATOM   8649  CD2 LEU   126    -101.553  11.842 -24.625  1.00 44.20           C  
ATOM   8650  N   PHE   127    -101.809  17.212 -25.446  1.00 41.83           N  
ATOM   8651  CA  PHE   127    -101.706  18.298 -26.410  1.00 41.39           C  
ATOM   8652  C   PHE   127    -100.275  18.487 -26.886  1.00 40.58           C  
ATOM   8653  O   PHE   127     -99.340  17.969 -26.280  1.00 41.29           O  
ATOM   8654  CB  PHE   127    -102.233  19.626 -25.825  1.00 44.43           C  
ATOM   8655  CG  PHE   127    -101.652  19.980 -24.479  1.00 47.75           C  
ATOM   8656  CD1 PHE   127    -100.417  20.619 -24.373  1.00 47.14           C  
ATOM   8657  CD2 PHE   127    -102.350  19.680 -23.312  1.00 49.24           C  
ATOM   8658  CE1 PHE   127     -99.883  20.940 -23.128  1.00 49.24           C  
ATOM   8659  CE2 PHE   127    -101.824  19.998 -22.065  1.00 50.32           C  
ATOM   8660  CZ  PHE   127    -100.590  20.629 -21.973  1.00 51.44           C  
ATOM   8661  N   VAL   128    -100.116  19.241 -27.969  1.00 39.64           N  
ATOM   8662  CA  VAL   128     -98.810  19.727 -28.402  1.00 35.39           C  
ATOM   8663  C   VAL   128     -98.871  21.252 -28.339  1.00 37.91           C  
ATOM   8664  O   VAL   128     -99.822  21.863 -28.828  1.00 37.48           O  
ATOM   8665  CB  VAL   128     -98.448  19.246 -29.832  1.00 34.96           C  
ATOM   8666  CG1 VAL   128     -97.069  19.763 -30.258  1.00 30.06           C  
ATOM   8667  CG2 VAL   128     -98.479  17.727 -29.917  1.00 32.12           C  
ATOM   8668  N   GLN   129     -97.872  21.862 -27.707  1.00 38.26           N  
ATOM   8669  CA  GLN   129     -97.810  23.317 -27.601  1.00 36.17           C  
ATOM   8670  C   GLN   129     -97.309  23.935 -28.904  1.00 36.80           C  
ATOM   8671  O   GLN   129     -96.326  23.473 -29.489  1.00 36.17           O  
ATOM   8672  CB  GLN   129     -96.923  23.732 -26.432  1.00 35.06           C  
ATOM   8673  CG  GLN   129     -97.478  23.348 -25.062  1.00 36.77           C  
ATOM   8674  CD  GLN   129     -96.547  23.751 -23.932  1.00 39.52           C  
ATOM   8675  OE1 GLN   129     -96.678  24.837 -23.363  1.00 44.44           O  
ATOM   8676  NE2 GLN   129     -95.588  22.888 -23.615  1.00 37.86           N  
ATOM   8677  N   LEU   130     -97.986  24.989 -29.348  1.00 39.66           N  
ATOM   8678  CA  LEU   130     -97.746  25.542 -30.682  1.00 37.39           C  
ATOM   8679  C   LEU   130     -96.927  26.823 -30.700  1.00 36.78           C  
ATOM   8680  O   LEU   130     -96.784  27.445 -31.753  1.00 41.24           O  
ATOM   8681  CB  LEU   130     -99.072  25.741 -31.425  1.00 35.81           C  
ATOM   8682  CG  LEU   130     -99.896  24.487 -31.722  1.00 34.91           C  
ATOM   8683  CD1 LEU   130    -101.245  24.877 -32.294  1.00 34.39           C  
ATOM   8684  CD2 LEU   130     -99.152  23.531 -32.666  1.00 30.66           C  
ATOM   8685  N   ASN   131     -96.387  27.213 -29.548  1.00 39.07           N  
ATOM   8686  CA  ASN   131     -95.550  28.406 -29.468  1.00 38.32           C  
ATOM   8687  C   ASN   131     -94.264  28.239 -30.276  1.00 39.51           C  
ATOM   8688  O   ASN   131     -93.415  27.407 -29.953  1.00 40.05           O  
ATOM   8689  CB  ASN   131     -95.232  28.778 -28.015  1.00 41.74           C  
ATOM   8690  CG  ASN   131     -94.448  30.077 -27.907  1.00 44.69           C  
ATOM   8691  OD1 ASN   131     -93.229  30.068 -27.732  1.00 50.64           O  
ATOM   8692  ND2 ASN   131     -95.144  31.199 -28.033  1.00 50.20           N  
ATOM   8693  N   GLY   132     -94.150  29.023 -31.343  1.00 37.36           N  
ATOM   8694  CA  GLY   132     -93.003  28.953 -32.239  1.00 31.67           C  
ATOM   8695  C   GLY   132     -93.244  28.183 -33.527  1.00 34.02           C  
ATOM   8696  O   GLY   132     -92.359  28.129 -34.377  1.00 38.35           O  
ATOM   8697  N   PHE   133     -94.431  27.590 -33.670  1.00 36.76           N  
ATOM   8698  CA  PHE   133     -94.796  26.820 -34.870  1.00 38.96           C  
ATOM   8699  C   PHE   133     -94.644  27.644 -36.152  1.00 41.71           C  
ATOM   8700  O   PHE   133     -94.022  27.185 -37.115  1.00 42.81           O  
ATOM   8701  CB  PHE   133     -96.235  26.273 -34.773  1.00 39.20           C  
ATOM   8702  CG  PHE   133     -96.596  25.297 -35.871  1.00 41.70           C  
ATOM   8703  CD1 PHE   133     -96.525  23.924 -35.649  1.00 43.33           C  
ATOM   8704  CD2 PHE   133     -97.017  25.749 -37.127  1.00 42.03           C  
ATOM   8705  CE1 PHE   133     -96.848  23.014 -36.665  1.00 43.98           C  
ATOM   8706  CE2 PHE   133     -97.337  24.854 -38.146  1.00 39.80           C  
ATOM   8707  CZ  PHE   133     -97.254  23.484 -37.916  1.00 42.34           C  
ATOM   8708  N   SER   134     -95.220  28.848 -36.149  1.00 42.18           N  
ATOM   8709  CA  SER   134     -95.229  29.740 -37.313  1.00 42.38           C  
ATOM   8710  C   SER   134     -93.817  30.116 -37.757  1.00 40.58           C  
ATOM   8711  O   SER   134     -93.495  30.008 -38.943  1.00 42.40           O  
ATOM   8712  CB  SER   134     -96.059  30.995 -37.014  1.00 46.82           C  
ATOM   8713  OG  SER   134     -96.150  31.853 -38.136  1.00 54.10           O  
ATOM   8714  N   ASN   135     -92.980  30.528 -36.802  1.00 38.02           N  
ATOM   8715  CA  ASN   135     -91.591  30.900 -37.084  1.00 39.07           C  
ATOM   8716  C   ASN   135     -90.716  29.738 -37.534  1.00 40.40           C  
ATOM   8717  O   ASN   135     -89.853  29.910 -38.399  1.00 45.00           O  
ATOM   8718  CB  ASN   135     -90.956  31.588 -35.877  1.00 42.86           C  
ATOM   8719  CG  ASN   135     -91.424  33.016 -35.704  1.00 45.18           C  
ATOM   8720  OD1 ASN   135     -91.832  33.673 -36.664  1.00 49.01           O  
ATOM   8721  ND2 ASN   135     -91.363  33.509 -34.472  1.00 45.57           N  
ATOM   8722  N   ALA   136     -90.941  28.563 -36.950  1.00 40.02           N  
ATOM   8723  CA  ALA   136     -90.217  27.350 -37.346  1.00 38.53           C  
ATOM   8724  C   ALA   136     -90.631  26.886 -38.742  1.00 36.86           C  
ATOM   8725  O   ALA   136     -89.804  26.381 -39.498  1.00 38.11           O  
ATOM   8726  CB  ALA   136     -90.411  26.230 -36.319  1.00 36.47           C  
ATOM   8727  N   LEU   137     -91.905  27.070 -39.082  1.00 37.02           N  
ATOM   8728  CA  LEU   137     -92.394  26.736 -40.420  1.00 39.48           C  
ATOM   8729  C   LEU   137     -91.861  27.698 -41.484  1.00 41.97           C  
ATOM   8730  O   LEU   137     -91.545  27.270 -42.596  1.00 45.89           O  
ATOM   8731  CB  LEU   137     -93.922  26.674 -40.453  1.00 38.11           C  
ATOM   8732  CG  LEU   137     -94.596  26.152 -41.724  1.00 38.77           C  
ATOM   8733  CD1 LEU   137     -94.068  24.788 -42.136  1.00 37.35           C  
ATOM   8734  CD2 LEU   137     -96.089  26.102 -41.522  1.00 38.36           C  
ATOM   8735  N   ASN   138     -91.750  28.982 -41.131  1.00 42.09           N  
ATOM   8736  CA  ASN   138     -91.138  29.994 -42.000  1.00 42.09           C  
ATOM   8737  C   ASN   138     -89.689  29.657 -42.328  1.00 43.62           C  
ATOM   8738  O   ASN   138     -89.239  29.867 -43.454  1.00 48.34           O  
ATOM   8739  CB  ASN   138     -91.190  31.386 -41.355  1.00 42.26           C  
ATOM   8740  CG  ASN   138     -92.591  31.979 -41.320  1.00 42.14           C  
ATOM   8741  OD1 ASN   138     -93.517  31.477 -41.950  1.00 42.75           O  
ATOM   8742  ND2 ASN   138     -92.745  33.061 -40.571  1.00 41.76           N  
ATOM   8743  N   ARG   139     -88.969  29.140 -41.334  1.00 45.67           N  
ATOM   8744  CA  ARG   139     -87.590  28.693 -41.508  1.00 43.72           C  
ATOM   8745  C   ARG   139     -87.516  27.463 -42.424  1.00 43.33           C  
ATOM   8746  O   ARG   139     -86.610  27.356 -43.247  1.00 45.37           O  
ATOM   8747  CB  ARG   139     -86.942  28.429 -40.142  1.00 42.86           C  
ATOM   8748  CG  ARG   139     -85.506  27.912 -40.174  1.00 43.81           C  
ATOM   8749  CD  ARG   139     -84.563  28.856 -40.900  1.00 45.81           C  
ATOM   8750  NE  ARG   139     -83.174  28.411 -40.801  1.00 53.72           N  
ATOM   8751  CZ  ARG   139     -82.195  28.800 -41.613  1.00 55.64           C  
ATOM   8752  NH1 ARG   139     -82.438  29.636 -42.614  1.00 57.67           N  
ATOM   8753  NH2 ARG   139     -80.965  28.341 -41.429  1.00 55.83           N  
ATOM   8754  N   LEU   140     -88.484  26.557 -42.290  1.00 44.94           N  
ATOM   8755  CA  LEU   140     -88.597  25.388 -43.168  1.00 46.02           C  
ATOM   8756  C   LEU   140     -88.870  25.768 -44.627  1.00 49.25           C  
ATOM   8757  O   LEU   140     -88.360  25.119 -45.547  1.00 50.94           O  
ATOM   8758  CB  LEU   140     -89.676  24.427 -42.657  1.00 44.43           C  
ATOM   8759  CG  LEU   140     -89.263  23.036 -42.161  1.00 42.54           C  
ATOM   8760  CD1 LEU   140     -88.145  23.071 -41.135  1.00 34.28           C  
ATOM   8761  CD2 LEU   140     -90.474  22.281 -41.622  1.00 34.42           C  
ATOM   8762  N   ILE   141     -89.674  26.813 -44.825  1.00 50.63           N  
ATOM   8763  CA  ILE   141     -89.933  27.380 -46.152  1.00 51.16           C  
ATOM   8764  C   ILE   141     -88.652  28.003 -46.720  1.00 52.42           C  
ATOM   8765  O   ILE   141     -88.311  27.776 -47.885  1.00 55.57           O  
ATOM   8766  CB  ILE   141     -91.092  28.418 -46.116  1.00 51.67           C  
ATOM   8767  CG1 ILE   141     -92.414  27.733 -45.743  1.00 48.54           C  
ATOM   8768  CG2 ILE   141     -91.245  29.126 -47.466  1.00 53.10           C  
ATOM   8769  CD1 ILE   141     -93.491  28.667 -45.217  1.00 46.79           C  
ATOM   8770  N   ALA   142     -87.940  28.750 -45.876  1.00 52.51           N  
ATOM   8771  CA  ALA   142     -86.662  29.376 -46.232  1.00 53.46           C  
ATOM   8772  C   ALA   142     -85.546  28.372 -46.549  1.00 55.72           C  
ATOM   8773  O   ALA   142     -84.695  28.639 -47.401  1.00 60.79           O  
ATOM   8774  CB  ALA   142     -86.216  30.336 -45.124  1.00 50.56           C  
ATOM   8775  N   LEU   143     -85.555  27.228 -45.864  1.00 57.21           N  
ATOM   8776  CA  LEU   143     -84.567  26.172 -46.092  1.00 58.17           C  
ATOM   8777  C   LEU   143     -84.829  25.377 -47.377  1.00 61.92           C  
ATOM   8778  O   LEU   143     -83.911  24.755 -47.923  1.00 63.84           O  
ATOM   8779  CB  LEU   143     -84.485  25.230 -44.885  1.00 55.26           C  
ATOM   8780  CG  LEU   143     -83.691  25.691 -43.658  1.00 52.15           C  
ATOM   8781  CD1 LEU   143     -84.099  24.885 -42.426  1.00 47.67           C  
ATOM   8782  CD2 LEU   143     -82.186  25.601 -43.889  1.00 51.87           C  
ATOM   8783  N   GLN   144     -86.078  25.390 -47.846  1.00 65.75           N  
ATOM   8784  CA  GLN   144     -86.444  24.772 -49.123  1.00 71.05           C  
ATOM   8785  C   GLN   144     -85.878  25.549 -50.307  1.00 73.07           C  
ATOM   8786  O   GLN   144     -85.436  24.954 -51.296  1.00 73.75           O  
ATOM   8787  CB  GLN   144     -87.963  24.664 -49.268  1.00 71.94           C  
ATOM   8788  CG  GLN   144     -88.529  23.295 -48.930  1.00 77.77           C  
ATOM   8789  CD  GLN   144     -89.821  22.994 -49.678  1.00 79.09           C  
ATOM   8790  OE1 GLN   144     -90.596  23.898 -50.003  1.00 73.88           O  
ATOM   8791  NE2 GLN   144     -90.057  21.714 -49.952  1.00 79.06           N  
ATOM   8792  N   LYS   145     -85.898  26.877 -50.191  1.00 74.17           N  
ATOM   8793  CA  LYS   145     -85.368  27.774 -51.220  1.00 75.54           C  
ATOM   8794  C   LYS   145     -83.838  27.721 -51.302  1.00 76.51           C  
ATOM   8795  O   LYS   145     -83.263  27.926 -52.374  1.00 79.49           O  
ATOM   8796  CB  LYS   145     -85.854  29.206 -50.982  1.00 76.15           C  
ATOM   8797  CG  LYS   145     -87.359  29.376 -51.148  1.00 79.02           C  
ATOM   8798  CD  LYS   145     -87.827  30.741 -50.679  1.00 82.69           C  
ATOM   8799  CE  LYS   145     -89.345  30.829 -50.697  1.00 86.16           C  
ATOM   8800  NZ  LYS   145     -89.840  32.104 -50.106  1.00 88.65           N  
END
